/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: raconfig.cpp 
 *              
 *      Abstract: Raconfig main applcation 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 02     Created
 *      MarkW           9th  Feb 04     Baseline of code
 *      MarkW           22nd Feb 04     Added errno.h include
 *      MarkW           22nd Feb 04     Fixed country being incorrectly  
 *                                      in config file
 *      Mike Skinner    22nd Feb 04     Rolled in warning message change 
 ***************************************************************************/ 


#include <qapplication.h>

#include <qmessagebox.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <linux/wireless.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>  /* for mode definitions */
#include <signal.h>   /* for  disable CTRL-C */
#include <ctype.h>
#include <dirent.h>
#include <errno.h>
#include "raconfigform.h"  
#include "cardselect.h"
#include "countryform.h"
#include "rt_tool.h"
#include "configapi.h"

REGSTR_COUNTRY_ENTRY CountryRegionTable[] = 
{
	// define country				default channel minimum channel maximum channel 
	{REGSTR_COUNTRYREGION_FCC,		1,				1,				11},				
	{REGSTR_COUNTRYREGION_IC,		1,				1,				11},				
	{REGSTR_COUNTRYREGION_ETSI,		1,				1,				13},				
	{REGSTR_COUNTRYREGION_SPAIN,	10,				10,				11},				
	{REGSTR_COUNTRYREGION_FRANCE,	10,				10,				13},				
	{REGSTR_COUNTRYREGION_MKK,		14,				14,				14},				
	{REGSTR_COUNTRYREGION_MKK1,		1,				1,				14},				
	{REGSTR_COUNTRYREGION_ISRAEL,	3,				3,				9},				
};

UCHAR G_nCountryCount =sizeof(CountryRegionTable)/sizeof(REGSTR_COUNTRY_ENTRY);

extern int errno;
char  Configfile_name[255];
PRT_PROFILE_SETTING	RTMPProfile=NULL;
PRT_DEVICE_ADAPTER  pDevice_Adpater=NULL;
UCHAR CountryRegion=0;

#ifdef RT2460_DBG
ULONG RTDebugLevel = RT_DEBUG_LOUD;
#else
ULONG RTDebugLevel=RT_DEBUG_OFF;
#endif
	

/*------------------------------------------------------------------*/
/*
 * Extract the interface name out of /proc/net/wireless or /proc/net/dev.
 */
static inline char *
iw_get_ifname(char *	name,	/* Where to store the name */
	      int	nsize,	/* Size of name buffer */
	      char *	buf)	/* Current position in buffer */
{
	char *end;

	/* Skip leading spaces */
	while(isspace(*buf))
		buf++;

#ifndef IW_RESTRIC_ENUM
	/* Get name up to the last ':'. Aliases may contain ':' in them,
	 * but the last one should be the separator */
	end = strrchr(buf, ':');
#else
	/* Get name up to ": "
    * Note : we compare to ": " to make sure to process aliased interfaces
    * properly. Doesn't work on /proc/net/dev, because it doesn't guarantee
    * a ' ' after the ':'*/
	end = strstr(buf, ": ");
#endif
	
	/* Not found ??? To big ??? */
	if((end == NULL) || (((end - buf) + 1) > nsize))
		return(NULL);

	/* Copy */
	memcpy(name, buf, (end - buf));
	name[end - buf] = '\0';

	return(end + 2);
}

int m_open_cards(int socket_id)
{
	int i;
	char name[25];
	int  count=0;
	PRT_DEVICE_ADAPTER prtAdapter=NULL;	

	for (i=0; i<8; i++)
	{
		sprintf(name, "ra%d", i);		
		if(Check_DeviceName(socket_id, name, "RT2400PCI"))
		{
			count++;
			if(!pDevice_Adpater)
			{
				pDevice_Adpater = (PRT_DEVICE_ADAPTER) malloc(sizeof(RT_DEVICE_ADAPTER));
				if(pDevice_Adpater)
				{
					pDevice_Adpater->Device_Name = (char *)malloc(strlen(name)+1);
					if(!pDevice_Adpater->Device_Name)
					{
						printf("Not enough memory!\n");
						exit(1);
					}
					strcpy(pDevice_Adpater->Device_Name, name);
					pDevice_Adpater->Next = NULL;
					prtAdapter = pDevice_Adpater;
				}
				else
				{
					printf("Not enough memory!\n");
					exit(1);
				}
			}
			else
			{
				prtAdapter->Next = (PRT_DEVICE_ADAPTER) malloc(sizeof(RT_DEVICE_ADAPTER));
				if(prtAdapter->Next)
				{
					prtAdapter = prtAdapter->Next;
					prtAdapter->Device_Name = (char *)malloc(strlen(name)+1);
					if(!prtAdapter->Device_Name)
					{
						printf("Not enough memory!\n");
						exit(1);
					}
					strcpy(prtAdapter->Device_Name, name);
					prtAdapter->Next = NULL;
				}
				else
				{
					printf("Not enough memory!\n");
					exit(1);
				}
			}
		}
	}
		
	return count;
}

UCHAR Get_CountryRegion(char *Device_Name)
{
	char cfgdir[256];
	char tmpCountryRegion[10];	
	int  getCountryFlag=FALSE;
	unsigned int  country=0;

	if(getuid() == 0)
	{//Root user
		sprintf(cfgdir, "%s", RT2460_SYSTEM_PATH);
		if(getkeystring(Device_Name, "COUNTRYREGION", tmpCountryRegion, 10, RT2460_SYSTEM_PATH, CONFIG_FILE))
		{
			country = atoi(tmpCountryRegion);
			if( country < G_nCountryCount )
				getCountryFlag = TRUE;
		}
	}
	else
	{
		sprintf(cfgdir, "%s%s", getenv("HOME"), RT2460_LOCAL_PATH);
		if(getkeystring(Device_Name, "COUNTRYREGION", tmpCountryRegion, 10, cfgdir, CONFIG_FILE))
		{
			country = atoi(tmpCountryRegion);
			if( country < G_nCountryCount )
				getCountryFlag = TRUE;
		}
	}

	if( !getCountryFlag )
	{
		CountryForm *ctyForm = new CountryForm;
		ctyForm->show();
		if(ctyForm->exec() == QDialog::Accepted)
		{
			country = ctyForm->GetRegionID();
			sprintf(tmpCountryRegion, "%d", country);
			writekeystring(Device_Name, "COUNTRYREGION", tmpCountryRegion, cfgdir, CONFIG_FILE);
		}
		else
		{
			QMessageBox *mb = new QMessageBox();
			mb->setCaption("Information");
			mb->setText("This message dialog will pop up again next time, if no country region is selected.");
			mb->setIcon(QMessageBox::Information);
			mb->setButtonText(0, "&Ok");
			mb->exec();
			delete mb;			
		}
	}
	
	return ((UCHAR)country);
}


int main( int argc, char ** argv )
{
	int	  fd;	 
	char   buffer[255];
	int    pid;
	FILE   *fileLCK;
	int	 socket_id;
	int    adapter_num;
	int    isRuning=FALSE;
	DIR *dirptr;
	RaConfigForm *w;

	signal( SIGINT, SIG_IGN ); /* disable CTRL-C */

	QApplication a( argc, argv );

	fd=open("/tmp/.RaConfig.lck", O_RDWR | O_CREAT | O_EXCL);
	if (fd<0 && errno==EEXIST)
	{
		if((fileLCK=fopen("/tmp/.RaConfig.lck", "rb")) != NULL)
		{
			fgets(buffer, 255, fileLCK);
			sscanf(buffer, "%d", &pid);			
			fclose(fileLCK);
			sprintf(buffer, "/proc/%d", pid);
			dirptr = opendir(buffer);
			if(!dirptr)
			{
				isRuning = FALSE;
				if((fileLCK=fopen("/tmp/.RaConfig.lck", "wb")) != NULL)
				{
					fprintf(fileLCK, "%d", getpid());
					fclose(fileLCK);
				}
			}
			else
			{
				isRuning = TRUE;
			}
		}
	}
	else if(fd > 0)
	{
		//printf("/tmp/.RaConfig.lck not exist\n");
		isRuning = FALSE;
		system("chmod a+rw /tmp/.RaConfig.lck");
		system("chmod u-s /tmp/.RaConfig.lck");  //remove -rwsrw-rw-  *s*
		sprintf(buffer, "%d", getpid());
		write(fd, buffer, strlen(buffer)); 	
	}
	close(fd);
	
	if(isRuning)
	{
		QMessageBox *mb = new QMessageBox();
		mb->setCaption("Warning");
		mb->setText("Another RaConfig appears to be running - please close it and try again!");
		mb->setIcon(QMessageBox::Critical);
		mb->setButtonText(0, "&Ok");
		mb->exec();
		delete mb;
		return -1;
	}

	if((socket_id = Open_Socket()) < 0)
	{
		printf("Open socket error!\n");
		return -1;
	}

	adapter_num = m_open_cards(socket_id);
	if( adapter_num <=0)
	{//not found.
		DBGPRINT(RT_DEBUG_WARN, ("Not found NIC Driver!"));
		QMessageBox *mb = new QMessageBox();
		mb->setCaption("Error");
		mb->setText("Device driver not found!");
		mb->setIcon(QMessageBox::Critical);
		mb->setButtonText(0, "&Ok");
		mb->exec();
		delete mb;		
		unlink("/tmp/.RaConfig.lck"); 
		return -1;
	}
	else if (adapter_num == 1)
	{
		CountryRegion = Get_CountryRegion((char *)pDevice_Adpater->Device_Name);
		Set_OID_802_11_SET_COUNTRY_REGION(socket_id, (char *)pDevice_Adpater->Device_Name, &CountryRegion);

		w = new RaConfigForm(socket_id, pDevice_Adpater->Device_Name); 			
		w->resize(600, 520);
		a.setMainWidget(w);
	}
	else
	{
		CardSelect *cardSel = new CardSelect(socket_id, pDevice_Adpater);
		cardSel->show();
		cardSel->exec();

		CountryRegion = Get_CountryRegion((char *)cardSel->Get_Device_Name());
		Set_OID_802_11_SET_COUNTRY_REGION(socket_id, (char *)cardSel->Get_Device_Name(), &CountryRegion);

	   w = new RaConfigForm(socket_id, cardSel->Get_Device_Name()); 	
	   w->resize(600, 520);
	   a.setMainWidget(w);
	}
   w->show();	 
   a.connect( &a, SIGNAL( lastWindowClosed() ), &a, SLOT( quit() ) );	 
	a.exec();
	unlink("/tmp/.RaConfig.lck"); 
   return 0;
}
