/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: addform.h 
 *              
 *      Abstract: Implement add/edit profile settings 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 02     Created
 *      MarkW           9th  Feb 04     Baseline of code
 ***************************************************************************/ 


#ifndef ADDFORM_H
#define ADDFORM_H

#include <qvariant.h>
#include <qdialog.h>
#include <qvalidator.h>

#include "qhexvalidator.h"
#include "rt_tool.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QButtonGroup;
class QCheckBox;
class QComboBox;
class QLabel;
class QLineEdit;
class QListView;
class QListViewItem;
class QPushButton;
class QRadioButton;
class QSlider;
class QTabWidget;
class QWidget;

extern int 	socket_id;
extern char	device_name[8];	 
extern PRT_PROFILE_SETTING	RTMPProfile;

class AddForm : public QDialog
{ 
    Q_OBJECT

public:
    AddForm( int socket_id = 0 , const char *device_name = 0, QWidget* parent = 0, const char* name = 0, int type=PROFILE_ADD, QListView* pListView = 0, bool modal = FALSE, const char *BSSIDName=0, WFlags fl = 0 );
    ~AddForm();

	QLabel* TextLabel1;
	QLabel* TextLabel2;
	QLineEdit* ProfileLineEdit;
	QComboBox* SsidComboBox;
	QPushButton* OkProfilePushButton;
	QPushButton* CancelProfilePushButton;
	QTabWidget* ProfileTabWidget;
	QWidget* tab;
	QLabel* PreambleTextLabel;
	QComboBox* PreambleComboBox;
	QLabel* TextLabel8;
	QLabel* TextLabel7;
	QLabel* ChannelTextLabel;
	QComboBox* ChannelComboBox;
	QLabel* TextLabel9;
	QLabel* TextLabel9_2;
	QButtonGroup* ButtonGroup2;
	QRadioButton* TxRightAntRadioButton;
	QRadioButton* TxLeftAntRadioButton;
	QRadioButton* TxDiversityRadioButton;
	QComboBox* TransmitRateComboBox;
	QLabel* TextLabel4;
	QLabel* TextLabel3;
	QButtonGroup* ButtonGroup6;
	QRadioButton* RxRightAntRadioButton;
	QRadioButton* RxAntRadioButton;
	QRadioButton* RxDiversityRadioButton;
	QButtonGroup* PowerSaveButtonGroup;
	QRadioButton* Fast_PSPRadioButton;
	QRadioButton* Max_PSPRadioButton;
	QRadioButton* CAMRadioButton;
	QLineEdit* RTSLineEdit;
	QLineEdit* FragmentLineEdit;
	QSlider* RTSSlider;
	QSlider* FragmentSlider;
	QCheckBox* RTSCheckBox;
	QCheckBox* FragmentCheckBox;
	QComboBox* NetworkComboBox;
	QWidget* tab_2;
	QButtonGroup* ButtonGroup3;
	QLabel* TextLabel10;
	QComboBox* AuthenticationComboBox;
	QButtonGroup* ButtonGroup4;
	QLabel* TextLabel11;
	QLabel* TextLabel12;
	QButtonGroup* ButtonGroup5;
	QRadioButton* Key1RadioButton;
	QRadioButton* Key2RadioButton;
	QRadioButton* Key3RadioButton;
	QRadioButton* Key4RadioButton;
	QLineEdit* Key2LineEdit;
	QLineEdit* Key3LineEdit;
	QLineEdit* Key4LineEdit;
	QLineEdit* Key1LineEdit;
	QComboBox* WEPKeyTypeComboBox;
	QComboBox* WEPKeyLengthComboBox;
	QCheckBox* EncryptionCheckBox;

	QListView* ProfileListView;
	QHexValidator  *hexValidator;	 

	PNDIS_802_11_BSSID_LIST m_pBssidList;
	PRT_PROFILE_SETTING  ProfileSetting;
	int   AddForm_Type;
	int	  timerId_sitesurvey;
	int   Socket_Id;
	char  *Device_Name;
	bool  IsAddToProfile; 
	
	void GetAllSSIDName();
	bool m_IsAddToProfile();

public slots:

	virtual void CancelProfileButton_Click();
	virtual void OkProfileButton_Click();
	virtual void NetworkComboBox_activated( int );	
	virtual void RTSCheckBox_toggled(bool );
	virtual void FragmentCheckBox_toggled(bool );
	virtual void FragmentSlider_valueChanged(int);
	virtual void RTSSlider_valueChanged(int);
	virtual void EncryptionCheckBox_toggled(bool);
	virtual void WEPKeyLengthComboBox_activated(int);
	virtual void WEPKeyTypeComboBox_activated(int);	
	virtual void FragmentLineEdit_lostFocus();
	virtual void RTSLineEdit_lostFocus();	
};

#endif // ADDFORM_H
