/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: ape_meta.h,v 1.4 2003/08/08 21:42:37 robert Exp $

----------------------------------------------------------------------------*/
#ifndef INCLUDED_APE_H
#define INCLUDED_APE_H

#include "../config.h"

#ifdef HAVE_LIBAPE

#include <string>
#include <assert.h>
using namespace std;

#include "file_meta.h"

class Ape : public FileMetadata
{
    public:

                     Ape(void) {};
       virtual      ~Ape(void) {};

       bool          write  (const string &fileName, const Metadata &metadata, bool clear);
       bool          read   (const string &fileName, Metadata &metadata);

       void getError(string &error) { error = errString; };

    private:

       string   errString;
};

#endif
#endif
