///////
   //    Link.cc
   //    Link Class definitions
   //
   //    Class for links
   //
   //    Copyright (c) 1999-2002 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: Link.cc,v 1.11 2002/02/18 10:44:59 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#include "Link.h"

   // Static variables initialization
      int Link::debug = 0;

///////
   //    Construction
///////

Link::Link()
{
   Reset();
}

///////
   //    Destruction
///////

Link::~Link ()
{
}

///////
   //    Reset the schedule content
///////

void Link::Reset()
{
   IDUrlSrc = 0;
   IDUrlDest = 0;
   TagPosition = 0;
   AttrPosition = 0;
   Anchor.trunc();
   LinkType = Link_Normal;
   LinkResult = Link_NotChecked;
}


///////
   //    Output Link object
///////

ostream &operator<<( ostream &output, const Link &s)

{
   output << s.IDUrlSrc << " -> " << s.IDUrlDest;
   
   if (s.debug < 3) return output;
   
   // Only if debug level is greater than 2
   
   output << " (Tag n.: " << s.TagPosition << " - Attribute n. "
      << s.AttrPosition << " - Anchor " << s.Anchor << ")";
   
   return output;
}


///////
   //    Managing the Link Type of the Link
///////

///////
   //    Converts the Link_Type value into the corresponding
   //    String value
///////

void Link::RetrieveLinkType(String &Type) const
{

   switch(GetLinkType())
   {
      case (Link_Normal):
         Type="Normal";
         break;
      case (Link_Direct):
         Type="Direct";
         break;
      case (Link_Redirection):
         Type="Redirection";
         break;
   }

}

///////
   //    Converts the Type string value
   //    into the corresponding Link_Type value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int Link::SetLinkType(char *Type)
{

   if (!strcmp(Type, "Normal"))
      SetLinkType (Link_Normal);
   else if (!strcmp(Type, "Direct"))
      SetLinkType (Link_Direct);
   else if (!strcmp(Type, "Redirection"))
      SetLinkType (Link_Redirection);
   else return 0;
   
   return 1;
}


///////
   //    Managing the result of the link
///////

///////
   //    Converts the Link_Result value into the corresponding
   //    String value
///////

void Link::RetrieveLinkResult(String &Result) const
{

   switch(GetLinkResult())
   {
      case (Link_NotChecked):
         Result="NotChecked";
         break;
      case (Link_NotRetrieved):
         Result="NotRetrieved";
         break;
      case (Link_OK):
         Result="OK";
         break;
      case (Link_Broken):
         Result="Broken";
         break;
      case (Link_Redirected):
         Result="Redirected";
         break;
      case (Link_AnchorNotFound):
         Result="AnchorNotFound";
         break;
      case (Link_NotAuthorized):
         Result="NotAuthorized";
         break;
      case (Link_EMail):
         Result="EMail";
         break;
      case (Link_Javascript):
         Result="Javascript";
         break;
   }

}

///////
   //    Converts the Result string value
   //    into the corresponding Link_Result value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int Link::SetLinkResult(char *Result)
{

   if (!strcmp(Result, "NotChecked"))
      SetLinkResult (Link_NotChecked);
   else if (!strcmp(Result, "NotRetrieved"))
      SetLinkResult (Link_NotRetrieved);
   else if (!strcmp(Result, "OK"))
      SetLinkResult (Link_OK);
   else if (!strcmp(Result, "Broken"))
      SetLinkResult (Link_Broken);
   else if (!strcmp(Result, "Redirected"))
      SetLinkResult (Link_Redirected);
   else if (!strcmp(Result, "AnchorNotFound"))
      SetLinkResult (Link_AnchorNotFound);
   else if (!strcmp(Result, "NotAuthorized"))
      SetLinkResult (Link_NotAuthorized);
   else if (!strcmp(Result, "EMail"))
      SetLinkResult (Link_EMail);
   else if (!strcmp(Result, "Javascript"))
      SetLinkResult (Link_Javascript);
   else return 0;
   
   return 1;
}
