dnl
dnl Copyright (c) 1999-2001 Comune di Prato - Prato - Italy
dnl Some Portions Copyright (c) 1995-2001 The ht://Dig Group <www.htdig.org>
dnl Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
dnl $Id: acinclude.m4,v 1.1 2001/06/15 15:47:01 angusgb Exp $
dnl
dnl Part of the ht://Check package   <http://htcheck.sourceforge.net/>
dnl For copyright details, see the file COPYING in your distribution
dnl or the GNU General Public License version 2 or later
dnl <http://www.gnu.org/copyleft/gpl.html>
dnl

dnl
dnl AC_HTCHECK_ONCE(namespace, variable, code)
dnl
dnl execute code, if variable is not set in namespace
dnl
AC_DEFUN(AC_HTCHECK_ONCE,[
  unique=`echo $ac_n "$2$ac_c" | tr -c -d a-zA-Z0-9`
  cmd="echo $ac_n \"\$$1$unique$ac_c\""
  if test -n "$unique" && test "`eval $cmd`" = "" ; then
    eval "$1$unique=set"
    $3
  fi
])

dnl
dnl AC_EXPAND_PATH(path, variable)
dnl
dnl expands path to an absolute path and assigns it to variable
dnl
AC_DEFUN(AC_EXPAND_PATH,[
  if test -z "$1" || echo "$1" | grep '^/' >/dev/null ; then
    $2="$1"
  else
    $2="`pwd`/$1"
  fi
])

dnl
dnl AC_ADD_LIBPATH(path)
dnl
dnl add a library to linkpath/runpath
dnl
AC_DEFUN(AC_ADD_LIBPATH,[
  if test "$1" != "/usr/lib"; then
    AC_EXPAND_PATH($1, ai_p)
    AC_HTCHECK_ONCE(LIBPATH, $ai_p, [
      EXTRA_LIBS="$EXTRA_LIBS -L$ai_p"
      if test -n "$APXS" ; then
        RPATHS="$RPATHS ${apxs_runpath_switch}$ai_p'"
      else
        RPATHS="$RPATHS ${ld_runpath_switch}$ai_p"
      fi
    ])
  fi
])

dnl
dnl AC_ADD_INCLUDE(path)
dnl
dnl add a include path
dnl
AC_DEFUN(AC_ADD_INCLUDE,[
  if test "$1" != "/usr/include"; then
    AC_EXPAND_PATH($1, ai_p)
    AC_HTCHECK_ONCE(INCLUDEPATH, $ai_p, [
      INCLUDES="$INCLUDES -I$ai_p"
    ])
  fi
])

dnl
dnl AC_ADD_LIBRARY(library)
dnl
dnl add a library to the link line
dnl
AC_DEFUN(AC_ADD_LIBRARY,[
  AC_HTCHECK_ONCE(LIBRARY, $1, [
    EXTRA_LIBS="$EXTRA_LIBS -l$1"
  ])
])

dnl
dnl AC_ADD_LIBRARY_WITH_PATH(library, path)
dnl
dnl add a library to the link line and path to linkpath/runpath
dnl
AC_DEFUN(AC_ADD_LIBRARY_WITH_PATH,[
  AC_ADD_LIBPATH($2)
  AC_ADD_LIBRARY($1)
])

AC_DEFUN(AC_TEMP_LDFLAGS,[
  old_LDFLAGS="$LDFLAGS"
  LDFLAGS="$1 $LDFLAGS"
  $2
  LDFLAGS="$old_LDFLAGS"
])



AC_DEFUN(AC_CHECK_MYSQL,[

    if test "$1" = "yes"; then

      MYSQL_TYPE="automatic"

      # Autodetect
      for w in /usr/include /usr/local/include /usr/mysql /usr/local/mysql /opt /opt/mysql; do
        # check for plain setups
        if test -f $w/mysql.h; then
          MYSQL_INCDIR=$w
          break
        fi
        # check for "/usr/include/<packagename>" type setups
        if test -f $w/mysql/mysql.h; then
          MYSQL_INCDIR=$w/mysql
          break
        fi
        # check for "/usr/<packagename>/include" type setups
        if test -f $w/mysql/include/mysql.h; then
          MYSQL_INCDIR=$w/mysql/include
          break
        fi
      done

      for w in /usr/lib /usr/local/lib /usr/mysql /usr/local/mysql /opt /opt/mysql; do
        # check for plain setups
        if test -f $w/libmysqlclient.a -o -f $w/libmysqlclient.so; then
          MYSQL_LIBDIR=$w
          break
        fi
        # check for "/usr/lib/<packagename>" type setups
        if test -f $w/mysql/libmysqlclient.a -o -f $w/mysql/libmysqlclient.so; then
          MYSQL_LIBDIR=$w/mysql
          break
        fi
        # check for "/usr/<packagename>/lib" type setups
        if test -f $w/mysql/lib/libmysqlclient.a -o -f $w/mysql/lib/libmysqlclient.so; then
          MYSQL_LIBDIR=$w/mysql/lib
          break
        fi
      done
    else
      MYSQL_TYPE="manual in $1"
      # Manual detection for <$1>/include/<packagename>
      # and <$1>/include.
      if test -f $1/include/mysql/mysql.h; then
        MYSQL_INCDIR=$1/include/mysql
      elif test -f $1/include/mysql.h; then
        MYSQL_INCDIR=$1/include
      fi
      
      # Manual detection for <$1>/lib/<packagename>
      # and <$1>/lib.
      if test -f $1/lib/mysql/libmysqlclient.a -o -f $1/lib/mysql/libmysqlclient.so; then
        MYSQL_LIBDIR=$1/lib/mysql
      elif test -f $1/lib/libmysqlclient.a -o -f $1/lib/libmysqlclient.so; then
        MYSQL_LIBDIR=$1/lib
      fi
    fi
    
    ## Did we find anything?
    if test -z "$MYSQL_LIBDIR" ; then
      AC_MSG_RESULT(no $MYSQL_TYPE)
      AC_MSG_ERROR(Invalid MySQL directory - unable to find libmysqlclient.a or libmysqlclient.so.)
    fi
    if test -z "$MYSQL_INCDIR" ; then
      AC_MSG_RESULT(no)
      AC_MSG_ERROR(Invalid MySQL directory - unable to find mysql.h.)
    fi

    AC_ADD_LIBRARY_WITH_PATH(mysqlclient, $MYSQL_LIBDIR)
    AC_ADD_INCLUDE($MYSQL_INCDIR)

dnl    AC_DEFINE(HAVE_MYSQL)
    AC_MSG_RESULT(found in $MYSQL_INCDIR and $MYSQL_LIBDIR)

    dnl check for errmsg.h, which isn't installed by some versions of 3.21
    old_CPPFLAGS="$CPPFLAGS"
    CPPFLAGS="$CPPFLAGS -I$MYSQL_INCDIR"
    AC_CHECK_HEADERS(errmsg.h mysql.h)
])
