/* 
 *	HT Editor
 *	relfile.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>

#include "relfile.h"
#include "tools.h"

/*
 *	CLASS ht_reloc_file
 */

void	ht_reloc_file::init(ht_streamfile *s, bool os)
{
	ht_layer_streamfile::init(s, os);
	relocs=new ht_stree();
	((ht_stree*)relocs)->init(compare_keys_uint);
}

void	ht_reloc_file::done()
{
	relocs->destroy();
	delete relocs;
	ht_layer_streamfile::done();
}

void	ht_reloc_file::insert_reloc(FILEOFS o, ht_data *reloc)
{
	relocs->insert(new ht_data_uint(o), reloc);
}

UINT	ht_reloc_file::read(void *buf, UINT size)
{
	FILEOFS o=tell();
	UINT ret=ht_layer_streamfile::read(buf, size), c=ret;
	UINT i=0;
	while (c) {
		ht_data_uint q;
		q.value=o+i;
		ht_data *r=relocs->get(&q);
		if (r) {
			byte b[8];
			memset(b, 0, sizeof b);
			memmove(b, ((byte*)buf)+i, MIN(c, sizeof b));
			reloc_apply(r, b);
			memmove(((byte*)buf)+i, b, MIN(c, sizeof b));
		}
		i++;
		c--;
	}
	return ret;
}

void	ht_reloc_file::reloc_apply(ht_data *reloc, byte *data)
{
}

void	ht_reloc_file::reloc_unapply(ht_data *reloc, byte *data)
{
}

UINT	ht_reloc_file::write(void *buf, UINT size)
{
	FILEOFS o=tell();
	UINT ret=ht_layer_streamfile::write(buf, size), c=ret;
	UINT i=0;
	while (c) {
		ht_data_uint q;
		q.value=o+i;
		ht_data *r=relocs->get(&q);
		if (r) {
			byte b[8];
			memset(b, 0, sizeof b);
			memmove(b, ((byte*)buf)+i, MIN(c, sizeof b));
			reloc_unapply(r, b);
			memmove(((byte*)buf)+i, b, MIN(c, sizeof b));
		}
		i++;
		c--;
	}
	return ret;
}

