/*
 *	out_html.cc
 */

/*	Copyright (C) 1999, 2000, 2001 Sebastian Biallas (sb@web-productions.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "analy_names.h"
#include "htdebug.h"
#include "htinfo.h"
#include "out_html.h"
#include "tools.h"
#include "x86dis.h"
#include "string.h"

char *header = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n<html>\n<head>\n";
char *footer = "</body>\n</html>\n";
char *stylesheet = "<style type=\"text/css\">\n"
"<!--\n"
"body {\n"
"\tfont: 10pt arial,helvetica,sans-serif;\n"
"\tcolor:#000000;\n"
"\tbackground:#ffffff;\n"
"}\n"
"A:link {\n"
"\tcolor:#0000ff;\n"
"\ttext-decoration: none;\n"
"}\n"
"A:active {\n"
"\tcolor:#ff00ff;\n"
"\ttext-decoration: none;\n"
"}\n"
"A:visited {\n"
"\tcolor:#0000ff;\n"
"\ttext-decoration: none;\n"
"}\n"
"td {\n"
"\tfont: 12pt courier;\n"
"\tcolor:#000000;\n"
"\tvertical-align: top;\n"
"}\n"
"b {\n"
"\tfont: bold 11pt arial,helvetica,sans-serif;\n"
"\tcolor:#000000;\n"
"}\n"
"//-->\n"
"</style>\n";

int write_str(ht_stream *stream, char *s)
{
	return stream->write(s, strlen(s));
}

analyser *theanaly2;
char html_buffer[1024];

char *html_addr_sym_func(CPU_ADDR Addr, int *symstrlen)
{
	/* should only be called/used/assigned if theanaly2 is set */
	taddr *a = theanaly2->find_addr(Addr.addr32);
	if ((a) && (a->label)){
		int i = sprintf(html_buffer, "<a href=\"#A%08X\">%s</a>", Addr.addr32, a->label->name);
		if (symstrlen) *symstrlen=i;
		return html_buffer;
	} else {
		if (theanaly2->valid_addr(Addr.addr32, scvalid)) {
			int i = sprintf(html_buffer, "<a href=\"#A%08X\">%x</a>", Addr.addr32, Addr.addr32);
			if (symstrlen) *symstrlen=i;
			return html_buffer;
		}
	}
	return NULL;
}

int generate_html_output(analyser *analy, ht_stream *stream, ADDR from, ADDR to)
{
#if 0
	if ((!analy) || (!stream)) return HTML_OUTPUT_ERR_GENERIC;
	if (analy->active) return HTML_OUTPUT_ERR_ANALY_NOT_FINISHED;

	write_str(stream, header);
	write_str(stream, "\t<title>Analysis of ");
	write_str(stream, analy->getname());
	write_str(stream, "</title>\n");
	write_str(stream, stylesheet);
	write_str(stream, "</head>\n<body bgcolor=\"#ffffff\">\n");
	write_str(stream, "Analysis of <i>");
	write_str(stream, analy->getname());
	write_str(stream, "</i><br>generated by <a href=\""ht_url"\">"ht_name" version "ht_version"</a>.\n<hr>\n");
	write_str(stream, "\n<table cellspacing=0 border=0>\n");
	// main loop:
	ADDR Addr = from;
	while (1) {
		if (Addr > to) break;
		write_str(stream, "\n<tr>\n");

		taddr *a = analy->findaddr(Addr);

		int length = 0;

		char temp[1024];

		sprintf(temp, "<td><a name=\"A%08X\">"HEX8FORMAT8"</a></td>\n", Addr, Addr);
		write_str(stream, temp);


		if (analy->explored->contains(Addr)) {
			write_str(stream, "<td bgcolor=black>&nbsp;</td>\n");
		} else {
			write_str(stream, "<td>&nbsp;</td>\n");
		}


		if (a) {
			write_str(stream, "<td>\n<table cellspacing=0 border=0>\n");
			// comments
			tcomment *c = a->comments;
			if (c) {
				write_str(stream, "<tr><td colspan=2>\n");
				while (c)	{
					write_str(stream, c->text);
					write_str(stream, "<br>\n");
					c = c->next;
				}
				write_str(stream, "</td></tr>\n");
			}
			// label
			write_str(stream, "<tr>\n<td width=500>");
			if (a->label) {
				sprintf(temp, "<b>%s</b>:<br>\n", a->label->name);
				write_str(stream, temp);
			}
		} else {
			write_str(stream, "<td width=500>");
		}

		if (analy->validcodeaddr(Addr)) {
			taddr *nextaddr = analy->enum_addrs(Addr);
			int op_len;

			if (nextaddr) {
				op_len = MIN((dword)analy->maxopcodelength, (nextaddr->addr - Addr));
			} else {
				op_len = analy->maxopcodelength;
			}

			if (analy->disasm) {
				byte buf[16];
				OPCODE *o=analy->disasm->decode(analy->bufptr(Addr, buf, sizeof(buf)), op_len, analy->mapaddr(Addr));
				/* inits for addr-sym transformations */
				theanaly2 = analy;
				addr_sym_func = &html_addr_sym_func;
				/**/
				sprintf(temp, "  %s", analy->disasm->str(o, X86DIS_STYLE_HEX_NOZEROPAD));
				/* deinits for addr-sym transformations */
				theanaly2 = NULL;
				addr_sym_func = 0;
				/**/
				length=analy->disasm->getsize(o);
			} else {
				byte c;
				sprintf(temp, "  db      0%02xh", *(byte *)analy->bufptr(Addr, &c, 1));
				length=1;
			}
		} else {
			if (analy->validaddr(Addr, scvalid)) {
				if ((a) && (a->type.type == dtint)) {
					length = a->type.length;
					assert(length);
					byte c[4];
					if (analy->validaddr(Addr, scinitialized)) {
						switch (a->type.intsubtype) {
							case dstiword:
								sprintf(temp, "  dw      0%04xh", *(word *)analy->bufptr(Addr, c, 2));
								break;
							case dstidword:
								sprintf(temp, "  dd      0%08xh", *(dword *)analy->bufptr(Addr, c, 4));
								break;
							case dstibyte:
							default:
								analy->bufptr(Addr, c, 1);
								sprintf(temp, "  db      %02xh ; '%c'", c[0], (c[0]<32)?32:c[0]);
						}
					} else {
						switch (a->type.intsubtype) {
							case dstiword:
								strcpy(temp, "  dw      ????");
								break;
							case dstidword:
								strcpy(temp, "  dd      ????????");
								break;
							case dstibyte:
							default:
								strcpy(temp, "  db      ??");
						}
					}
				} else {
					length =	1;
					if (analy->validaddr(Addr, scinitialized)) {
						byte c;
						analy->bufptr(Addr, &c, 1);
						sprintf(temp, "  db      0%02xh ; '%c'", c, (c<32)?32:c);
					} else {
						strcpy(temp, "  db      ??");
					}
				}
			} else {
				ADDR next = analy->nextvalid(Addr);
				if (next != INVALID_ADDR) {
					length = next - Addr;
					sprintf(temp, "  db      ?? * %d", next - Addr);
				} else {
					length =	1;
					strcpy(temp, "  db      ??");
				}
			}
		}
/*		if (mode & ANALY_EDIT_BYTES) {
			if (validaddr(Addr, scinitialized)) {

				FILEADDR a=fileaddr(Addr);
				assert(a != INVALID_FILE_OFS);
				for (int i=0; i<(*length); i++) {
					buf = tag_make_edit_byte(buf, a+i);
				}
				for (int i=0; i<=(maxopcodelength*2)-(*length)*2; i++) {
					*(buf++)=' ';
				}
				*buf=0;
			}
		}*/

		char *t = temp;
		while (*t) {
			if ((t[0]==' ') && (t[1]==' ')) {
				write_str(stream, "&nbsp;");
			} else {
				stream->write(t, 1);
			}
			t++;
		}

		if (a) {
			write_str(stream, "</td>\n<td>");
			txref *x = a->xreflist;
			int i=0;
			while (x)	{
				if (i % 3==0) {
					write_str(stream, ";xref");
				}
				sprintf(temp, " %c<a href=\"#A%08X\">"HEX8FORMAT"</a>", xref_type_short(x->type), x->addr, x->addr);
				write_str(stream, temp);
				if (i % 3==2) {
					write_str(stream, "<br>\n");
				}
				i++;
				x = x->next;
			}
			write_str(stream, "</td>\n</tr></table>");
		}
		write_str(stream, "</td>\n</tr>\n");

		Addr += length;
	}
	// end
	write_str(stream, "</table>\n");
	write_str(stream, footer);
	return HTML_OUTPUT_OK;
#endif
	return 0;
}
