/* 
 *	HT Editor
 *	common.h
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef COMMON_H
#define COMMON_H

#include "global.h"

#define BUILDER(reg, obj) object *build_##obj(){return new obj();}
#define REGISTER(reg, obj) register_atom(reg, (void*)build_##obj);
#define UNREGISTER(reg, obj) unregister_atom(reg);

class ht_object_stream;

class object {
public:
	bool initialized;
	bool destroyed;

			object();
	virtual		~object();

		   void	init();
	virtual void	done();
	virtual object	*duplicate();
	virtual bool	idle();
	virtual int	load(ht_object_stream *s);
	virtual void	store(ht_object_stream *s);
	virtual OBJECT_ID object_id();
};

#include "stream.h"

#endif
