#ifndef EAP_SIM_COMMON_H
#define EAP_SIM_COMMON_H

#define EAP_SIM_NONCE_S_LEN 16
#define EAP_SIM_NONCE_MT_LEN 16
#define EAP_SIM_MAC_LEN 16
#define EAP_SIM_MK_LEN 20
#define EAP_SIM_K_AUT_LEN 16
#define EAP_SIM_K_ENCR_LEN 16
#define EAP_SIM_KEYING_DATA_LEN 64
#define EAP_SIM_IV_LEN 16

#define GSM_RAND_LEN 16

#define AKA_RAND_LEN 16
#define AKA_AUTN_LEN 16

void eap_sim_derive_keys(const u8 *mk, u8 *k_encr, u8 *k_aut, u8 *msk);
void eap_sim_derive_keys_reauth(unsigned int _counter,
				const u8 *identity, size_t identity_len,
				const u8 *nonce_s, const u8 *mk, u8 *msk);
int eap_sim_verify_mac(const u8 *k_aut, u8 *req, size_t req_len, u8 *mac,
		       u8 *extra, size_t extra_len);
void eap_sim_add_mac(const u8 *k_aut, u8 *msg, size_t msg_len, u8 *mac,
		     const u8 *extra, size_t extra_len);


/* EAP-SIM/AKA Attributes (0..127 non-skippable) */
#define EAP_SIM_AT_RAND 1
#define EAP_SIM_AT_AUTN 2 /* only AKA */
#define EAP_SIM_AT_RES 3 /* only AKA, only send */
#define EAP_SIM_AT_AUTS 4 /* only AKA, only send */
#define EAP_SIM_AT_PADDING 6 /* only encrypted */
#define EAP_SIM_AT_NONCE_MT 7 /* only SIM, only send */
#define EAP_SIM_AT_PERMANENT_ID_REQ 10
#define EAP_SIM_AT_MAC 11
#define EAP_SIM_AT_NOTIFICATION 12
#define EAP_SIM_AT_ANY_ID_REQ 13
#define EAP_SIM_AT_IDENTITY 14 /* only send */
#define EAP_SIM_AT_VERSION_LIST 15 /* only SIM */
#define EAP_SIM_AT_SELECTED_VERSION 16 /* only SIM */
#define EAP_SIM_AT_FULLAUTH_ID_REQ 17
#define EAP_SIM_AT_COUNTER 19 /* only encrypted */
#define EAP_SIM_AT_COUNTER_TOO_SMALL 20 /* only encrypted */
#define EAP_SIM_AT_NONCE_S 21 /* only encrypted */
#define EAP_SIM_AT_CLIENT_ERROR_CODE 22 /* only send */
#define EAP_SIM_AT_IV 129
#define EAP_SIM_AT_ENCR_DATA 130
#define EAP_SIM_AT_NEXT_PSEUDONYM 132 /* only encrypted */
#define EAP_SIM_AT_NEXT_REAUTH_ID 133 /* only encrypted */
#define EAP_SIM_AT_CHECKCODE 134 /* only AKA */
#define EAP_SIM_AT_RESULT_IND 135

/* AT_NOTIFICATION notification code values */
#define EAP_SIM_GENERAL_FAILURE_AFTER_AUTH 0
#define EAP_SIM_TEMPORARILY_DENIED 1026
#define EAP_SIM_NOT_SUBSCRIBED 1031
#define EAP_SIM_GENERAL_FAILURE_BEFORE_AUTH 16384
#define EAP_SIM_SUCCESS 32768


enum eap_sim_id_req {
	NO_ID_REQ, ANY_ID, FULLAUTH_ID, PERMANENT_ID
};


struct eap_sim_attrs {
	u8 *rand, *autn, *mac, *iv, *encr_data, *version_list, *nonce_s;
	u8 *next_pseudonym, *next_reauth_id;
	u8 *nonce_mt, *identity;
	size_t num_chal, version_list_len, encr_data_len;
	size_t next_pseudonym_len, next_reauth_id_len, identity_len;
	enum eap_sim_id_req id_req;
	int notification, counter, selected_version, client_error_code;
};

int eap_sim_parse_attr(u8 *start, u8 *end, struct eap_sim_attrs *attr,
		       int aka, int encr);
int eap_sim_parse_encr(const u8 *k_encr, u8 *encr_data, size_t encr_data_len,
		       const u8 *iv, struct eap_sim_attrs *attr, int aka);


struct eap_sim_msg;

struct eap_sim_msg * eap_sim_msg_init(int code, int id, int type, int subtype);
u8 * eap_sim_msg_finish(struct eap_sim_msg *msg, size_t *len, const u8 *k_aut,
			const u8 *extra, size_t extra_len);
void eap_sim_msg_free(struct eap_sim_msg *msg);
u8 * eap_sim_msg_add_full(struct eap_sim_msg *msg, u8 attr,
			  const u8 *data, size_t len);
u8 * eap_sim_msg_add(struct eap_sim_msg *msg, u8 attr,
		     u16 value, const u8 *data, size_t len);
u8 * eap_sim_msg_add_mac(struct eap_sim_msg *msg, u8 attr);
int eap_sim_msg_add_encr_start(struct eap_sim_msg *msg, u8 attr_iv,
			       u8 attr_encr);
int eap_sim_msg_add_encr_end(struct eap_sim_msg *msg, u8 *k_encr,
			     int attr_pad);

void eap_sim_report_notification(void *msg_ctx, int notification, int aka);

#endif /* EAP_SIM_COMMON_H */
