<?php
/**
 * @package Horde_Kolab
 *
 * $Horde: framework/Kolab/Kolab/XML/task.php,v 1.2.2.2 2008/01/02 11:30:38 jan Exp $
 */

/**
 * Kolab XML handler for task groupware objects
 *
 * $Horde: framework/Kolab/Kolab/XML/task.php,v 1.2.2.2 2008/01/02 11:30:38 jan Exp $
 *
 * Copyright 2007-2008 The Horde Project (http://www.horde.org/)
 *
 * @author  Thomas Jarosch <thomas.jarosch@intra2net.com>
 * @author  Gunnar Wrobel <wrobel@pardus.de>
 * @package Horde_Kolab
 */
class Horde_Kolab_XML_task extends Horde_Kolab_XML {
    /**
     * Specific data fields for the note object
     *
     * @var array
     */
    var $_fields_specific;

    /**
     * Constructor
     */
    function Horde_Kolab_XML_task()
    {
        $this->_root_name = 'task';

        /** Specific task fields, in kolab format specification order
         */
        $this->_fields_specific = array(
            'summary' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_DEFAULT,
                'default' => '',
            ),
            'location' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_DEFAULT,
                'default' => '',
            ),
            'creator'   => $this->_fields_simple_person,
            'organizer' => $this->_fields_simple_person,
            'start-date' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_DATE_OR_DATETIME,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            'alarm' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_INTEGER,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            'recurrence' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_COMPOSITE,
                'value'   => HORDE_KOLAB_XML_VALUE_CALCULATED,
                'load'    => 'Recurrence',
                'save'    => 'Recurrence',
            ),
            'attendee' => $this->_fields_attendee,
            'priority' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_INTEGER,
                'value'   => HORDE_KOLAB_XML_VALUE_DEFAULT,
                'default' => 3,
            ),
            'completed' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_INTEGER,
                'value'   => HORDE_KOLAB_XML_VALUE_DEFAULT,
                'default' => 0,
            ),
            'status' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_DEFAULT,
                'default' => 'not-started',
            ),
            'due-date' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_DATE_OR_DATETIME,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            'parent' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_STRING,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            // These are not part of the Kolab specification but it is
            // ok if the client supports additional entries
            'estimate' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_INTEGER,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
            'completed_date' => array(
                'type'    => HORDE_KOLAB_XML_TYPE_DATE_OR_DATETIME,
                'value'   => HORDE_KOLAB_XML_VALUE_MAYBE_MISSING,
            ),
        );

        parent::Horde_Kolab_XML();
    }

    /**
     * Load the groupware object based on the specifc XML values.
     *
     * @param array $children An array of XML nodes
     *
     * @return array Array with data or PEAR error
     */
    function _load(&$children)
    {
        $object = $this->loadArray($children, $this->_fields_specific);

        $object['name'] = $object['summary'];
        unset($object['summary']);

        if (empty($object['completed-date'])) {
            $object['completed-date'] = null;
        }

        if (empty($object['alarm'])) {
            $object['alarm'] = null;
        }

        if (isset($object['due-date'])) {
            $object['due'] = $object['due-date'];
            unset($object['due-date']);
        } else {
            $object['due'] = null;
        }

        if (isset($object['start-date'])) {
            $object['start'] = $object['start-date'];
            unset($object['start-date']);
        } else {
            $object['start'] = null;
        }

        if (!isset($object['estimate'])) {
            $object['estimate'] = null;
        }

        if (!isset($object['parent'])) {
            $object['parent'] = null;
        }

        $object['completed'] = (bool) Kolab::percentageToBoolean($object['completed']);

        if (isset($object['organizer']) && isset($object['organizer']['smtp-address'])) {
            $object['assignee'] = $object['organizer']['smtp-address'];
        }

        return $object;
    }

    /**
     * Save the specific XML values.
     *
     * @param array $root     The XML document root
     * @param array $object   The resulting data array
     *
     * @return boolean True on success, a PEAR error otherwise
     */
    function _save($root, $object)
    {
        $object['summary'] = $object['name'];
        unset($object['name']);

        $object['due-date'] = $object['due'];
        unset($object['due']);

        $object['start-date'] = $object['start'];
        unset($object['start']);

        $object['completed'] = Kolab::BooleanToPercentage($object['completed']);

        $result = $this->saveArray($root, $object, $this->_fields_specific);
        if (is_a($result, 'PEAR_Error')) {
            return $result;
        }
    }
}
