/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: winroot.h,v 1.1.1.1.42.1 2004/07/09 01:58:48 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _WINROOT_H_
#define _WINROOT_H_

#include "hxthread.h"
#include "baseroot.h"
#include "hxvctrl.h"
#include "ddraw.h"
#include "hxcolor.h"
#include "windraw2.h"
#include "hxstring.h"
#include "hxwintyp.h"
#include "hxmap.h"
#include "coloracc.h"
#include "ddhlpr.h"

// Forward declarations
//class CRootSurface;
class CHXWinSite;

typedef HRESULT (*PDRAWCREATE) (IID *,LPDIRECTDRAW *,LPUNKNOWN);
typedef HRESULT (*PDRAWENUM) (LPDDENUMCALLBACKA, LPVOID);

class COverlay
{
private:
    int		    m_nCID;	    
    int		    m_nAlpha;
    WINDRAW*	    m_pWindraw;
    WINDRAWSURFACE  m_backgroundSurface;
    WINDRAWSURFACE  m_overlaySurface;
    HXxRect	    m_destRect;
    HXxRect	    m_srcRect;
    HXxRect	    m_backgroundSrcRect;
    HXxSize	    m_allocSize;
	
public:
    COverlay(WINDRAW* pWindraw);
    ~COverlay();
    void CreateOverlay(REF(HXxSize) size, int nCID);
    void SetSrcRect(REF(HXxRect) rect);
    void SetAlpha(int nAlpha);
    void SetDestRect(REF(HXxRect) rect, WINDRAWSURFACE* pDestSurface);
    void DrawOverlay(WINDRAWSURFACE* pDestSurface);
    void RemoveOverlay(WINDRAWSURFACE* pDestSurface);
    void UpdateOverlay(HXxRect* pRect, WINDRAWSURFACE* pSrcSurface);
    void GetSize(REF(HXxSize) size);
    void GetDC(HDC* phDC);
    UCHAR* LockOverlay();
    void UnlockOverlay();
    UCHAR* GetAlpha();
    int	 GetCID();
    void ReleaseDC(HDC hDC);
};

class COverlayMgr
{
private:
    CHXMapStringToOb m_overlayMap;
	
public:
    COverlayMgr();
    ~COverlayMgr();
    BOOL GetOverlay(const char* pName, COverlay** pOverlay);
    void AddOverlay(const char* pName, COverlay* pOverlay);
    void RemoveOverlay(const char* pName, WINDRAWSURFACE* pDestSurface);
    void UpdateOverlays(HXxRect* pRect, WINDRAWSURFACE* pSrcSurface);
    void RemoveAll();
};

class CWinBaseRootSurface : public CBaseRootSurface
{
protected:
	
    virtual ~CWinBaseRootSurface();
	
    PRIVATE_DESTRUCTORS_ARE_NOT_A_CRIME
		
    CRITICAL_SECTION	m_CriticalSection;
	
    WINDRAW         m_windraw;
    WINDRAW         m_windrawCaps;
    WINDRAWSURFACE  m_compositionSurface;

    BOOL            m_bWindrawOpened;
    BOOL            m_bWindrawCapsOpened;
    BOOL            m_bBltLock;
    UCHAR*          m_pScratchSurface;
    int             m_nScratchSurfaceCID;
    BOOL            m_bScratchSurfaceCreated;
    HXxSize         m_scratchSize;
    BOOL            m_bShowingText;
    HBRUSH          m_hBrush;
    HPEN            m_hPen;
    COLORREF        m_textColor;
    COLORREF        m_nTextBackgroundColor;
    CHXString       m_sStatusText;
    HFONT		    m_hFont;
    HFONT		    m_hOldFont;
    HWND            m_hLastClipper;

	
    IHXErrorMessages*  m_pErrMsg;

    void	    SelectFont(HDC hdc);
    void	    UnSelectFont(HDC hDC);
    void	    CreateTextAlpha(COverlay* pOverlay);

public:

    UINT32 GetSurfaceType() {return m_fSurfaceType;}

protected:
	
#define _WORKAROUND_YUV_RGB_16BIT_HXCOLOR_BUG	   1
//#ifdef _WORKAROUND_YUV_RGB_16BIT_HXCOLOR_BUG

    WINDRAWSURFACE	m_scratchSurface;
    int			    m_nScratchPitch;
    HX_RESULT		CreateScratchSurface(int nCompositionSurfaceCID, HXxSize* pSize);
    HX_RESULT		DestroyScratchSurface();
    HX_RESULT		ScratchUnLock();
    HX_RESULT		ScratchLock();

//#endif /*_WORKAROUND_YUV_RGB_16BIT_HXCOLOR_BUG*/
	
    COverlayMgr		m_overlayMgr;
	
    UCHAR*		    m_pYUVScratchBits;
    BITMAPINFO		m_YUVScratchbmi;
    INT32		    m_nYUVPitch;
	
public:
    
    CWinBaseRootSurface(IUnknown* pContext, CHXBaseSite* pSite);
	
	void	    PrepareFullScreen();
	void	    _FillBorders();
	void	    SetFullScreen();
	void	    PrepareExitFullScreen();
//	void	    ExitFullScreen();
	
#if 0    
    void        DrawFocusRect(WINDRAWSURFACE* pSurface,
                              int nSurfaceCID,
                              HXxSize* pSurfaceSize,
                              UCHAR* pVidMem,
                              CHXBaseSite* pSite);
#endif

    void	    DrawText();
	void	    RestoreResolution();
	
	WINDRAW*    GetWinDraw() {return &m_windraw;}
	HX_RESULT   OpenWindraw();
	WINDRAWSURFACE* GetCompositionSurface() {return &m_compositionSurface;}
	
	
    virtual void _GetYUVScratchWidthHeight(UINT32* pWidth, UINT32* pHeight);
    virtual void _CreateYUVScratchSurface(UINT32 width, UINT32 height);
    virtual void _GetYUVScratchSurfacePointer(UCHAR** pYUVBits, INT32* YUVPitch);
    virtual HX_RESULT ScratchLock(UCHAR** pBits, INT32* pPitch);
    virtual HX_RESULT ScratchUnlock(UCHAR* pBits);
    virtual void _BltFromScratchToComposition(HXxRect& rDestRect, HXxRect& rSrcRect);
    virtual HX_RESULT _DebugBlt(UCHAR*               pImageData,
								HXBitmapInfoHeader* pBitmapInfo,
								REF(HXxRect)         rDestRect,
								REF(HXxRect)         rSrcRect);
    virtual HX_RESULT _MinimalUnlock(HXxWindow* pWindow);
    virtual HX_RESULT _LockComposition(UCHAR** pBits, INT32* pPitch);
    virtual HX_RESULT _CreateCompositionSurface();
    virtual HX_RESULT _DestroyCompositionSurface();
    virtual void      _MinimalBlt(HXxRect& src, HXxRect& dst);
    virtual void      _AdjustLastAppendedRectangle(REF(CHXSimpleList) rectList);
    virtual void      _PreFlightBlt(HXxRect& dst);
    virtual void      GetDisplayModes(CModesDesc* pModesDesc, INT32* nNumModes);
    virtual void      SetResolution(int width, int height, int depth, void*);
    virtual BOOL      _OptimizedSurfaceOpened();
    virtual BOOL      _IsHardwareAccelerationAvail();
    virtual BOOL      _AcquireHardwareAcceleration();
    virtual BOOL      _LoseHardwareAcceleration();
    virtual BOOL      _EnableHardwareAcceleration();
    virtual BOOL      _DisableHardwareAcceleration();

};


#endif
