#!/bin/sh

if [ `uname` = "SunOS" ] ; then
    echo "Checking display properties..."
    if [ -z "$DISPLAY" ] ; then
	DISPLAY=0:0
    fi
    DEPTH=`/usr/X/bin/xdpyinfo -display $DISPLAY | grep "depth of root window" | sed -e 's/[^0-9]//g;'`
    if [ "$DEPTH" = "24" ] ; then
	echo "Color depth for $DISPLAY set to 24 bits (good!)"
    else
	echo "Color depth for $DISPLAY set to $DEPTH bits."
	echo "This may cause video to display incorrectly (especially for 8 bits.)  Until"
	echo "this is fixed you may wish to switch to a higher bit depth if you plan on"
	echo "watching video with Helix Player."
    fi
else
    echo "This script is only for Solaris!"
fi
echo ""

