#!/bin/sh

# Mime Installer for Helix Player
# (C) 1999, 2003 RealNetworks, Inc.

# The purpose of this shell script is to automate the installation of 
# RealNetworks mimetypes for Netscape, GNOME, and KDE.  

# $1 - MP3/NOMP3 (whether or not to install MP3 mime types)
# $2 - global/local (install globally or in $HOME)

# Example:
# sh postinst/mimeinstall.sh NOMP3 global

# This script relies on the following files being located in the
# HelixPlayer/postinst directory
# * mime.kdelnk
# * app.kdelnk 
# * hxplay.desktop

# This script must be run in the HelixPlayer directory, as it relies
# on `pwd` to retrieve the HXPLAYDIR.  One could add the directory
# detection code from hxplay to this script; this is left as an
# exercise for the reader.


GLOBALINST=/usr/share
LOCALINST=$HOME
TMPDIR=/tmp/hxinstall.$$
GLOBALMIMETYPESDESTS="/etc/mime.types /usr/local/lib/netscape/mime.types"
GLOBALMAILCAPDESTS="/etc/mailcap /usr/local/lib/netscape/mailcap"
HXPLAYDIR=`pwd`
INSTDIR=$HXPLAYDIR/postinst

mkdir $TMPDIR

if [ ! -f hxplay.bin ] ;  then
    echo "This shell script should only be run from the installed location of the"
    echo "Helix Player.  Please cd to that directory and try again"
    exit
fi


installmime ()
{
# args
# 1 mime type
# 2 dest dir
# 3 mimetypes (space sep)
# 4 mime.types location
    kdeappdest=$5
    gnomedest=$6
    gnomeappdest=$7
    mkdir -p $2
 
    filename=$TMPDIR/`echo $1 | sed 's/\\//:/g'`.kdelnk
    kdestyleexts=`echo $3 | sed 's/\([a-z0-9A-Z][a-z0-9A-Z]*\)/*.\1;/g' | sed 's/ //g'`
    if [ ! -f $filename ]; 
    then 
	cat $INSTDIR/mime.kdelnk | sed s:__MIME__:$1:g |  \
                    sed s:__EXT__:$kdestyleexts:g > $filename
    fi
    mkdir -p `dirname $2/$1`
    cat $filename | sed s:__LOCATION__:`pwd`:g > $2/$1.kdelnk
    rm $filename
    filesmodified=$2/$1.kdelnk

    if [ -f $kdeappdest/HelixPlayer.kdelnk ] ; 
    then
       exts="`grep MimeType $kdeappdest/HelixPlayer.kdelnk`$1;"
       grep -v MimeType $kdeappdest/HelixPlayer.kdelnk > $TMPDIR/kdelink && cp $TMPDIR/kdelink $kdeappdest/HelixPlayer.kdelnk && rm $TMPDIR/kdelink
       echo $exts >> $kdeappdest/HelixPlayer.kdelnk
       filesmodified="$filesmodified $kdeappdest/HelixPlayer.kdelnk"
    fi
       
    mkdir -p $GNOMEDEST
    printf "$1\n" >> $GNOMEDEST/hxplay.keys
 # how come gnome doesn't let you do absolute paths?
    printf "\topen=hxplay %%f &\n" >> $GNOMEDEST/hxplay.keys
    printf "\tview=hxplay %%f &\n" >> $GNOMEDEST/hxplay.keys
    printf "\ticon-filename=`pwd`/rp7doc.png\n" >> $GNOMEDEST/hxplay.keys
    filesmodified="$filesmodified $GNOMEDEST/hxplay.keys"

    mkdir -p $GNOMEDEST
    printf "$1\n" >> $GNOMEDEST/hxplay.mime
    printf "\text: $3\n" >> $GNOMEDEST/hxplay.mime
    filesmodified="$filesmodified $GNOMEDEST/hxplay.mime"

    if [ $4 = "local" ] ;
    then 
        mimetypesdests="$LOCALINST/.mime.types"
        mailcapdests="$LOCALINST/.mailcap"
    else
        mimetypesdests=$GLOBALMIMETYPESDESTS
        mailcapdests=$GLOBALMAILCAPDESTS
    fi
   
    for mimetypesdest in $mimetypesdests ; do
            if [ ! -d `dirname $mimetypesdest` ] ; then 
		    mkdir -p `dirname $mimetypesdest`
            fi
            if [ -f $mimetypesdest ] ; then
		    grep -v $1 $mimetypesdest > $TMPDIR/mtdest && cp $TMPDIR/mtdest $mimetypesdest && rm $TMPDIR/mtdest
            fi
	    echo "$1 $3" >> $mimetypesdest
	    filesmodified="$filesmodified $mimetypesdest"
    done

    for mailcapdest in $mailcapdests ; do
            if [ ! -d `dirname $mailcapdest` ] ; then 
		    mkdir -p `dirname $mailcapdest`
            fi
            if [ -f $mailcapdest ] ; then
		    grep -v $1 $mailcapdest > $TMPDIR/mcdest && cp $TMPDIR/mcdest $mailcapdest && rm $TMPDIR/mcdest
	    fi
	    echo "$1;$HXPLAYDIR/hxplay \"%u\"" >> $mailcapdest
	    filesmodified="$filesmodified $mailcapdest"
    done

    first=0
    mime="$1"
    for file in $filesmodified ; do  printf "%-30s%-50s\n" "$mime" $file ; if  [ $first = 0 ] ; then first=1; mime=""; fi  ; done
}

abort () 
{
    echo "Error - mimeinstall.sh: $1"
    exit 1
}

if [ "$2" = "global" ];
then 
    STDDEST=global
    KDEDEST=$GLOBALINST/mimelnk/
    KDEAPPDEST=$GLOBALINST/applnk/Multimedia
    GNOMEDEST=$GLOBALINST/mime-info/
    rm -f $GNOMEDEST/hxplay.keys
    rm -f $GNOMEDEST/hxplay.mime
    GNOMEAPPDEST=$GLOBALINST/applications
    rm -f $GNOMEAPPDEST/helixplayer.desktop
else
    STDDEST=local
    KDEDEST=$LOCALINST/.kde/share/mimelnk/
    KDEAPPDEST=$LOCALINST/.kde/share/applnk/Multimedia
    GNOMEDEST=$LOCALINST/.gnome/mime-info/
    rm -f $GNOMEDEST/hxplay.keys
    rm -f $GNOMEDEST/hxplay.mime
    GNOMEAPPDEST=$LOCALINST/.gnome/apps
    rm -f $GNOMEAPPDEST/helixplayer.desktop
fi

# first install the app
mkdir -p $KDEAPPDEST
cat $INSTDIR/app.kdelnk | sed "s:__LOCATION__:$HXPLAYDIR:g" > $KDEAPPDEST/HelixPlayer.kdelnk
echo "Installed Helix Player link for KDE"

mkdir -p $GNOMEAPPDEST
cat $INSTDIR/hxplay.desktop | sed "s:__LOCATION__:$HXPLAYDIR:g" > $GNOMEAPPDEST/helixplayer.desktop
echo "Installed Helix Player link for GNOME"

printf "%-30s%-50s\n" MIMETYPE "INSTALLED LOCATION" 
printf "%-30s%-50s\n" -------------------------- ----------------------------------------------------------
installmime audio/x-pn-realaudio             $KDEDEST "rm ram"  $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/vnd.rn-realaudio           $KDEDEST "ra"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime application/smil                 $KDEDEST "smi smil" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime text/vnd.rn-realtext             $KDEDEST "rt"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime video/vnd.rn-realvideo           $KDEDEST "rv"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime image/vnd.rn-realflash           $KDEDEST "rf swf"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime application/x-shockwave-flash2-preview $KDEDEST "rf swf"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime application/sdp                  $KDEDEST "sdp"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime application/x-sdp                $KDEDEST "sdp"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime application/vnd.rn-realmedia     $KDEDEST "rm"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime image/vnd.rn-realpix             $KDEDEST "rp"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime audio/wav                        $KDEDEST "wav"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime audio/x-wav                      $KDEDEST "wav"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime audio/x-pn-wav                   $KDEDEST "wav"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime audio/x-pn-windows-acm           $KDEDEST "wav"      $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime audio/basic                      $KDEDEST "au"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime audio/x-pn-au                    $KDEDEST "au"       $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime audio/aiff                       $KDEDEST "aiff af"  $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime audio/x-aiff                     $KDEDEST "aiff af"  $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
#installmime audio/x-pn-aiff                  $KDEDEST "aiff af"  $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST

if [ "$1" = "MP3" ] ; then
installmime audio/mpeg      $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/mpg       $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/mp3       $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-mpeg    $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-mpg     $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-mp3     $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/rn-mpeg     $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/X-MP3-draft-00 $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/MPA $KDEDEST "mp3 mp2 mp1 mpa mpga" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/mpegurl   $KDEDEST "m3u pls" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-mpegurl $KDEDEST "m3u pls" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/scpls     $KDEDEST "m3u pls" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
installmime audio/x-scpls   $KDEDEST "m3u pls" $STDDEST $KDEAPPDEST $GNOMEDEST $GNOMEAPPDEST
fi

# if this directory isn't empty, there's something above not cleaning up after itself
rmdir $TMPDIR

echo " "
echo "If you're using KDE, you'll need to restart your X session"
echo "now for the changes to take effect.  Changes to netscape" 
echo "mime configuration will take effect upon restarting netscape."
