/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxstatustop.h,v 1.3.10.4 2004/07/09 01:48:55 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _HXSTATUS_DISPLAY_TOP_H_
#define _HXSTATUS_DISPLAY_TOP_H_

#include <gtk/gtk.h>

#include "commonapp.h"
#include "hxstatus.h"
#include "hxstatuspositionfield.h"
#include "hxstatusfield.h"

G_BEGIN_DECLS

/* Top level player embedded displays */
#define HX_TYPE_STATUS_DISPLAY_TOP (hxstatus_display_top_get_type ())
#define HX_STATUS_DISPLAY_TOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), HX_TYPE_STATUS_DISPLAY_TOP, HXStatusDisplayTop))

typedef struct _HXStatusDisplayTop      HXStatusDisplayTop;
typedef struct _HXStatusDisplayTopClass HXStatusDisplayTopClass;

/* Stuff that is unique to the top-level status display */
struct _HXStatusDisplayTop
{
    HXStatusDisplay display;

    GtkWidget* notebook;
    GtkWidget* status_label;
    GtkWidget* buffering_progress_bar;

    GtkWidget* position_field;
    GtkWidget* status_field;
    GtkWidget* statistics_table;

    GArray *player_signal_handlers_array;
    guint player_signal_handlers_array_len;    
};

struct _HXStatusDisplayTopClass
{
    HXStatusDisplayClass parent_class;
};
    
GtkWidget* hxstatus_display_top_new(void);
GType      hxstatus_display_top_get_type (void) G_GNUC_CONST;

void hxstatus_display_top_attach(HXStatusDisplayTop* status,
                                 GladeXML* xml);


G_END_DECLS

#endif
