/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: uninstall.h,v 1.1.2.1 2004/07/09 02:03:00 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _UNINSTALL_H_
#define _UNINSTALL_H_

#define OS_SEPARATOR_CHAR '\\'

// Dialog strings
#define STR_CONFIRM \
    "Are you sure you want to uninstall %s and all of its components?"

#define STR_CAPTION "Uninstallation of %s"

#define STR_ERR_NO_LOG "Uninstall failed. Log file %s not found."

#define STR_ERR_BAD_LOG "%s is not a valid install log."

#define STR_DEL_SERVICE "Deleting Services..."

#define STR_DEL_FILE "Deleting Files ..."

#define STR_DEL_REG "Editing the Registry ..."

#define STR_DEL_DIR "Removing Directories ..."

#define STR_DONE_MSG "%s has been successfully removed."

#define STR_ERR_RUNNING "%s appears to be running. " \
    "Please close the application and select OK to uninstall."


// Install type bitmasks
#define INST_SILENT             0x1
#define INST_NON_INTERACTIVE    0x2

// Line read size
#define READ_SIZE   MAX_PATH * 2

// SInstItem: Describes an install item, as read from file.
typedef struct _SInstItem
{
    char* szName;
    char* szValue;

    ~_SInstItem() { HX_VECTOR_DELETE(szName); HX_VECTOR_DELETE(szValue); }
} SInstItem;

typedef struct _SNode
{
    char* szString;
    _SNode* pNext;
    _SNode* pBack;
    _SNode(char* szStr) : szString(szStr), pNext(NULL), pBack(NULL) {}
} SNode;


// XXXJDG TODO: Lose the stack, it is no longer appropriate.
typedef SNode* STACKPOS;

// Simple searchable stack of strings
class CStringStack
{
public:
    CStringStack() : m_pHead(NULL){}
    ~CStringStack();
    
    void Push(char* szVal);
    char* Pop();
    char* Top();

    STACKPOS Find(const char* szVal);
    char* Remove(STACKPOS pos);
    char* FindAndRemove(const char* szVal);

private:
    SNode* m_pHead;
};

// Main uninstaller class
class CUninstaller
{
public:
    CUninstaller(HINSTANCE hInstance);
    ~CUninstaller();

    void Uninstall(const char* szLog, UINT32 ulFlags);

private:
    BOOL GetTitle();
    static BOOL CheckAppPath(const char* szAppPath);

    BOOL Confirm();
    BOOL GetNextItem(SInstItem*& pItem);
    
    void RemoveServices();
    void RemoveAll();    
    
    SInstItem* HandleItem(SInstItem* pItem);

    void RemoveInstallFile(const char* szFile);
    void RemoveMultipleFiles(const char* szFileDescriptor);
    void RemoveSharedFile(const char* szFile);    
    void RemoveService(const char* szServiceName);
    void RemoveRegValue(HKEY hkey, const char* szName, const char* szValue);
    SInstItem* RemoveRegKeyVals(char* szKey);
    BOOL RemoveInstDirectory(const char* szPath);
    BOOL RemoveRegTree(HKEY hkeyRoot, const char* szKey, BOOL bDelVals);
    BOOL RemoveRegTree(const char* szKey, BOOL bDelVals);
    static char* GetRootKey(const char* szName, HKEY& hkey);

    void GetNumItems();

    BOOL WarnRunning();
    BOOL ShowProgress();
    void SetProgress(UINT16 uProgress);
    void UpdateDlgText(const char* szText);
    void CloseProgress();
    void ShowDoneMessage();
    void CheckMessages();

    const char* m_szLog;
    FILE* m_fpLog;    
    char m_szTitle[READ_SIZE];
    char m_szAppPath[MAX_PATH+1];
    char m_szUninstPath[MAX_PATH+1];

    UINT32 m_ulInstFlags;

    UINT32 m_ulTotalItems;
    UINT32 m_ulItems;

    CStringStack m_Dirs;
    CStringStack m_RegKeys;

    HINSTANCE m_hInstance;
    HWND m_hwndDlg;
};

#endif // _UNINSTALL_H_
