/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: inststrs.h,v 1.1.2.1 2004/07/09 02:02:49 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _INSTSTRS_H_
#define _INSTSTRS_H_

// We need to break the lines on a console, but just let them wrap in a dialog
#ifdef _CONSOLE
#define STR_LNBRK "\n"
#else
#define STR_LNBRK " "
#endif

#ifndef _CONSOLE

#define STR_DLG_CAPTION "Setup of " PROG

#define STR_PROGRESS_CAPTION "Installing " PROG

#define STR_WELCOME \
    "Welcome to the " PROG " Setup program." STR_LNBRK \
    "This Setup program will install the " PROG " on your computer.\n\n" \
    "We strongly recommend exiting all other applications before" STR_LNBRK \
    "installing the " PROG ".\n\n" \
    "This program is protected by copyright law and international" STR_LNBRK \
    "treaties.\n\n" \
    "Unauthorized reproduction or distribution of this program," STR_LNBRK \
    "or any portion of it, may result in severe civil and criminal" STR_LNBRK \
    "penalties, and will be prosecuted to the maximum extent" STR_LNBRK \
    "possible under the law." STR_LNBRK

#define STR_CANCEL \
    "The " PROG " setup is not complete. If you exit now, the " PROG STR_LNBRK \
    "will not be installed.\n\n" \
    "You may, however, choose to run setup at a later time."

#endif // _CONSOLE

#define STR_LICENSE_ACCEPT \
    "Choose \"Accept\" to accept the terms of this" STR_LNBRK \
    "license agreement and continue with " PROG " setup." STR_LNBRK

#define STR_GETDIR \
    "Choose the folder where your copy of " PROG " will be" STR_LNBRK \
    "installed." STR_LNBRK

#ifdef HELIX_FEATURE_SERVER_ENCODING

#define STR_USERPWORD_PROMPT \
    "Please enter a username and password that you will use" STR_LNBRK \
    "to access the web-based " PROG " Administrator, monitor, " STR_LNBRK \
    "and live encoders:" STR_LNBRK

#else    

#define STR_USERPWORD_PROMPT \
    "Please enter a username and password that you will use" STR_LNBRK \
    "to access the web-based " PROG " Administrator and monitor." STR_LNBRK

#endif /* HELIX_FEATURE_SERVER_ENCODING */

#define STR_PORT_PROMPT1 \
    "Please enter a port on which " PROG " will listen for" STR_LNBRK

#define STR_PORT_PROMPT2 \
    "connections.  These connections have URLs that begin" STR_LNBRK \
    "with "

#define STR_PNA_PROMPT \
    STR_PORT_PROMPT1 "PNA " STR_PORT_PROMPT2 "\"pnm://\""

#define STR_RTSP_PROMPT \
    STR_PORT_PROMPT1 "RTSP " STR_PORT_PROMPT2 "\"rtsp://\""

#define STR_HTTP_PROMPT \
    STR_PORT_PROMPT1 "HTTP " STR_PORT_PROMPT2 "\"http://\""

#define STR_ADMIN_PROMPT \
    PROG " will listen for Administrator requests on the" STR_LNBRK \
    "port shown.  This port has been initialized to a random value" STR_LNBRK \
    "for security.  Please verify now that this pre-assigned port" STR_LNBRK \
    "will not interfere with ports already in use on your system;" STR_LNBRK \
    "you can change it if necessary." STR_LNBRK

#ifdef _WIN32
#define STR_NTSERVICE \
    PROG " default setup installs " PROG " as an" STR_LNBRK \
    "NT service. If you do not want to install " PROG STR_LNBRK \
    "as an NT service, then uncheck the box below." STR_LNBRK

#define STR_NTSERVICECHECK \
    "Install " PROG " as an NT service"
#endif // _WIN32

#define STR_CONFIG \
    "You have selected the following " PROG " configuration:" STR_LNBRK

#ifdef _WIN32
#define STR_SERVICE_INST "Install"
#define STR_SERVICE_NOINST "Do Not Install"
#endif // _WIN32

#define STR_DONE_MESSAGE \
    PROG " installation is complete." \


/*
 * Error messages
 */
#define STR_ERR_CAPTION \
    "Setup Error"

#define STR_WARN_CAPTION \
    "Warning"

#define STR_BAD_DIR \
    "The path entered is not valid."

#define STR_NO_USERNAME \
    "Username not specified!"
    
#define STR_BAD_PASS \
    "Invalid password entered, try again."

#define STR_PASS_MISMATCH \
    "Passwords don't match!"

#define STR_ERR_CREATE_DIR \
    "Setup could not create the install directory %s."

#define STR_ERR_WRITE_DIR \
    "Setup could not write to the install directory."

#define STR_ERR_APP_RUNNING \
    "%s appears to be running in the selected location. \n" \
    "Please close the application and select OK to continue."

#define STR_PORT_INVALID \
    "The port specified is not valid."

#define STR_PORT_DUPE \
    "Port %d has already been selected for %s. Please choose a different port."

#define STR_PORT_INUSE \
    "Port %d is currently in use. Use this port anyway?"


#endif // _INSTSTRS_H_
