/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smcallbk.h,v 1.1.22.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef SMCALLBK_H
#define SMCALLBK_H

// Forward declarations
typedef ULONG32 CallbackHandle;
class CSmilDocumentRenderer;
class CSmilAAnchorElement;

class HandlePendingSchedulingCallback : public IHXCallback
{
public:
    HandlePendingSchedulingCallback();
    virtual ~HandlePendingSchedulingCallback();

    // IUnknown methods
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)  (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    // IHXCallback methods
    STDMETHOD(Func) (THIS);

    // public members
    INT32                   m_lRefCount;
    CSmilDocumentRenderer*  m_pSmilDocumentRenderer;
    CallbackHandle          m_PendingHandle;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD             m_bIsCallbackPending : 1;
};


class CHyperlinkCallback : public IHXCallback
{
public:
    CHyperlinkCallback(CSmilDocumentRenderer* pDocRend);
    virtual ~CHyperlinkCallback();

    // IUnknown methods
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)  (THIS);
    STDMETHOD_(ULONG32,Release) (THIS);

    // IHXCallback methods
    STDMETHOD(Func) (THIS);

    // CHyperlinkCallback methods
    void           SetAnchor(CSmilAAnchorElement* pAnchor) { m_pAnchor = pAnchor; }
    HX_RESULT      AddAdditionalAnchor(CSmilAAnchorElement* pAnchor);
    HX_RESULT      ClearExtraAnchorList();
    BOOL           IsCallbackPending() const { return m_bIsCallbackPending; }
    CallbackHandle GetCallbackHandle() const { return m_PendingHandle;      }
    void           SetCallbackPending(BOOL bFlag) { m_bIsCallbackPending = bFlag; }
    void           SetCallbackHandle(CallbackHandle hand) { m_PendingHandle = hand; }
protected:
    INT32                  m_lRefCount;
    CSmilDocumentRenderer* m_pDocRend;
    CallbackHandle         m_PendingHandle;
    CSmilAAnchorElement*   m_pAnchor;
    CHXSimpleList*         m_pExtraAnchorsList;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD            m_bIsCallbackPending : 1;
};

#endif
