/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: parstabl.h,v 1.3.12.1 2004/07/09 01:57:56 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PARSTABL_H
#define PARSTABL_H

typedef struct
{
    SMIL2Element m_eElement;
    const char*  m_pszString;
} SMILElementTable;

static const SMILElementTable g_ElementTable[] =
{
    {SMIL2ElemA,                "a"               },
    {SMIL2ElemAnchor,           "anchor"          },
    {SMIL2ElemAnimate,          "animate"         },
    {SMIL2ElemAnimateColor,     "animateColor"    },
    {SMIL2ElemAnimateMotion,    "animateMotion"   },
    {SMIL2ElemAnimation,        "animation"       },
    {SMIL2ElemArea,             "area"            },
    {SMIL2ElemAudio,            "audio"           },
    {SMIL2ElemBody,             "body"            },
    {SMIL2ElemBrush,            "brush"           },
    {SMIL2ElemCustomAttributes, "customAttributes"},
    {SMIL2ElemCustomTest,       "customTest"      },
    {SMIL2ElemExcl,             "excl"            },
    {SMIL2ElemHead,             "head"            },
    {SMIL2ElemImg,              "img"             },
    {SMIL2ElemLayout,           "layout"          },
    {SMIL2ElemMeta,             "meta"            },
    {SMIL2ElemMetadata,         "metadata"        },
    {SMIL2ElemPar,              "par"             },
    {SMIL2ElemParam,            "param"           },
    {SMIL2ElemPrefetch,         "prefetch"        },
    {SMIL2ElemPriorityClass,    "priorityClass"   },
    {SMIL2ElemRef,              "ref"             },
    {SMIL2ElemRegPoint,         "regPoint"        },
    {SMIL2ElemRegion,           "region"          },
    {SMIL2ElemRootLayout,       "root-layout"     },
    {SMIL2ElemSeq,              "seq"             },
    {SMIL2ElemSet,              "set"             },
    {SMIL2ElemSmil,             "smil"            },
    {SMIL2ElemSwitch,           "switch"          },
    {SMIL2ElemText,             "text"            },
    {SMIL2ElemTextstream,       "textstream"      },
    {SMIL2ElemTopLayout,        "topLayout"       },
    {SMIL2ElemTransition,       "transition"      },
    {SMIL2ElemVideo,            "video"           },
    {NumSMIL2Elements,          NULL              }  // NOTE: THIS SHOULD ALWAYS BE LAST!!!
};

typedef struct
{
    SMIL2Attribute   m_eAttribute;
    const char*      m_pszString;
    XMLAttributeType m_eType;
}  SMILAttributeTable;

static const SMILAttributeTable g_AttributeTable[] =
{
    {SMIL2AttrAbstract,                  "abstract"                 , XMLAttrTypeCDATA},
    {SMIL2AttrAccesskey,                 "accesskey"                , XMLAttrTypeCDATA},
    {SMIL2AttrAccumulate,                "accumulate"               , XMLAttrTypeEnumerated},
    {SMIL2AttrActuate,                   "actuate"                  , XMLAttrTypeEnumerated},
    {SMIL2AttrAdditive,                  "additive"                 , XMLAttrTypeEnumerated},
    {SMIL2AttrAlt,                       "alt"                      , XMLAttrTypeCDATA},
    {SMIL2AttrAttributeName,             "attributeName"            , XMLAttrTypeCDATA},
    {SMIL2AttrAttributeType,             "attributeType"            , XMLAttrTypeCDATA},
    {SMIL2AttrAuthor,                    "author"                   , XMLAttrTypeCDATA},
    {SMIL2AttrBackground_Color,          "background-color"         , XMLAttrTypeCDATA},
    {SMIL2AttrBackgroundColor,           "backgroundColor"          , XMLAttrTypeCDATA},
    {SMIL2AttrBandwidth,                 "bandwidth"                , XMLAttrTypeCDATA},
    {SMIL2AttrBegin,                     "begin"                    , XMLAttrTypeCDATA},
    {SMIL2AttrBorderColor,               "borderColor"              , XMLAttrTypeCDATA},
    {SMIL2AttrBorderWidth,               "borderWidth"              , XMLAttrTypeCDATA},
    {SMIL2AttrBottom,                    "bottom"                   , XMLAttrTypeCDATA},
    {SMIL2AttrBy,                        "by"                       , XMLAttrTypeCDATA},
    {SMIL2AttrCalcMode,                  "calcMode"                 , XMLAttrTypeEnumerated},
    {SMIL2AttrClass,                     "class"                    , XMLAttrTypeCDATA},
    {SMIL2AttrClip_Begin,                "clip-begin"               , XMLAttrTypeCDATA},
    {SMIL2AttrClipBegin,                 "clipBegin"                , XMLAttrTypeCDATA},
    {SMIL2AttrClip_End,                  "clip-end"                 , XMLAttrTypeCDATA},
    {SMIL2AttrClipEnd,                   "clipEnd"                  , XMLAttrTypeCDATA},
    {SMIL2AttrClose,                     "close"                    , XMLAttrTypeEnumerated},
    {SMIL2AttrColor,                     "color"                    , XMLAttrTypeCDATA},
    {SMIL2AttrContent,                   "content"                  , XMLAttrTypeCDATA},
    {SMIL2AttrCoords,                    "coords"                   , XMLAttrTypeCDATA},
    {SMIL2AttrCopyright,                 "copyright"                , XMLAttrTypeCDATA},
    {SMIL2AttrCustomTest,                "customTest"               , XMLAttrTypeIDREF},
    {SMIL2AttrDefaultState,              "defaultState"             , XMLAttrTypeEnumerated},
    {SMIL2AttrDestinationLevel,          "destinationLevel"         , XMLAttrTypeCDATA},
    {SMIL2AttrDestinationPlaystate,      "destinationPlaystate"     , XMLAttrTypeEnumerated},
    {SMIL2AttrDirection,                 "direction"                , XMLAttrTypeEnumerated},
    {SMIL2AttrDur,                       "dur"                      , XMLAttrTypeCDATA},
    {SMIL2AttrEnd,                       "end"                      , XMLAttrTypeCDATA},
    {SMIL2AttrEndProgress,               "endProgress"              , XMLAttrTypeCDATA},
    {SMIL2AttrEndsync,                   "endsync"                  , XMLAttrTypeCDATA},
    {SMIL2AttrErase,                     "erase"                    , XMLAttrTypeEnumerated},
    {SMIL2AttrExternal,                  "external"                 , XMLAttrTypeEnumerated},
    {SMIL2AttrFadeColor,                 "fadeColor"                , XMLAttrTypeCDATA},
    {SMIL2AttrFill,                      "fill"                     , XMLAttrTypeEnumerated},
    {SMIL2AttrFillDefault,               "fillDefault"              , XMLAttrTypeEnumerated},
    {SMIL2AttrFit,                       "fit"                      , XMLAttrTypeEnumerated},
    {SMIL2AttrFragment,                  "fragment"                 , XMLAttrTypeCDATA},
    {SMIL2AttrFrom,                      "from"                     , XMLAttrTypeCDATA},
    {SMIL2AttrHeight,                    "height"                   , XMLAttrTypeCDATA},
    {SMIL2AttrHigher,                    "higher"                   , XMLAttrTypeEnumerated},
    {SMIL2AttrHorzRepeat,                "horzRepeat"               , XMLAttrTypeCDATA},
    {SMIL2AttrHref,                      "href"                     , XMLAttrTypeCDATA},
    {SMIL2AttrId,                        "id"                       , XMLAttrTypeID},
    {SMIL2AttrLeft,                      "left"                     , XMLAttrTypeCDATA},
    {SMIL2AttrLongdesc,                  "longdesc"                 , XMLAttrTypeCDATA},
    {SMIL2AttrLower,                     "lower"                    , XMLAttrTypeEnumerated},
    {SMIL2AttrMax,                       "max"                      , XMLAttrTypeCDATA},
    {SMIL2AttrMediaRepeat,               "mediaRepeat"              , XMLAttrTypeEnumerated},
    {SMIL2AttrMediaSize,                 "mediaSize"                , XMLAttrTypeCDATA},
    {SMIL2AttrMediaTime,                 "mediaTime"                , XMLAttrTypeCDATA},
    {SMIL2AttrMin,                       "min"                      , XMLAttrTypeCDATA},
    {SMIL2AttrName,                      "name"                     , XMLAttrTypeCDATA},
    {SMIL2AttrNohref,                    "nohref"                   , XMLAttrTypeEnumerated},
    {SMIL2AttrOpen,                      "open"                     , XMLAttrTypeEnumerated},
    {SMIL2AttrOrigin,                    "origin"                   , XMLAttrTypeEnumerated},
    {SMIL2AttrOverride,                  "override"                 , XMLAttrTypeEnumerated},
    {SMIL2AttrPauseDisplay,              "pauseDisplay"             , XMLAttrTypeEnumerated},
    {SMIL2AttrPeers,                     "peers"                    , XMLAttrTypeEnumerated},
    {SMIL2AttrReadIndex,                 "readIndex"                , XMLAttrTypeCDATA},
    {SMIL2AttrRegAlign,                  "regAlign"                 , XMLAttrTypeEnumerated},
    {SMIL2AttrRegion,                    "region"                   , XMLAttrTypeCDATA},
    {SMIL2AttrRegionName,                "regionName"               , XMLAttrTypeCDATA},
    {SMIL2AttrRegPoint,                  "regPoint"                 , XMLAttrTypeCDATA},
    {SMIL2AttrRepeat,                    "repeat"                   , XMLAttrTypeCDATA},
    {SMIL2AttrRepeatCount,               "repeatCount"              , XMLAttrTypeCDATA},
    {SMIL2AttrRepeatDur,                 "repeatDur"                , XMLAttrTypeCDATA},
    {SMIL2AttrRestart,                   "restart"                  , XMLAttrTypeEnumerated},
    {SMIL2AttrRestartDefault,            "restartDefault"           , XMLAttrTypeEnumerated},
    {SMIL2AttrRight,                     "right"                    , XMLAttrTypeCDATA},
    {SMIL2AttrSensitivity,               "sensitivity"              , XMLAttrTypeCDATA},
    {SMIL2AttrShape,                     "shape"                    , XMLAttrTypeEnumerated},
    {SMIL2AttrShow,                      "show"                     , XMLAttrTypeEnumerated},
    {SMIL2AttrShowBackground,            "showBackground"           , XMLAttrTypeEnumerated},
    {SMIL2AttrSkip_Content,              "skip-content"             , XMLAttrTypeEnumerated},
    {SMIL2AttrSoundLevel,                "soundLevel"               , XMLAttrTypeCDATA},
    {SMIL2AttrSourceLevel,               "sourceLevel"              , XMLAttrTypeCDATA},
    {SMIL2AttrSourcePlaystate,           "sourcePlaystate"          , XMLAttrTypeEnumerated},
    {SMIL2AttrSrc,                       "src"                      , XMLAttrTypeCDATA},
    {SMIL2AttrStartProgress,             "startProgress"            , XMLAttrTypeCDATA},
    {SMIL2AttrSubtype,                   "subtype"                  , XMLAttrTypeEnumerated},
    {SMIL2AttrSyncBehavior,              "syncBehavior"             , XMLAttrTypeEnumerated},
    {SMIL2AttrSyncBehaviorDefault,       "syncBehaviorDefault"      , XMLAttrTypeEnumerated},
    {SMIL2AttrSyncTolerance,             "syncTolerance"            , XMLAttrTypeCDATA},
    {SMIL2AttrSyncToleranceDefault,      "syncToleranceDefault"     , XMLAttrTypeCDATA},
    {SMIL2AttrSystem_Bitrate,            "system-bitrate"           , XMLAttrTypeCDATA},
    {SMIL2AttrSystem_Captions,           "system-captions"          , XMLAttrTypeEnumerated},
    {SMIL2AttrSystem_Language,           "system-language"          , XMLAttrTypeCDATA},
    {SMIL2AttrSystem_Overdub_Or_Caption, "system-overdub-or-caption", XMLAttrTypeEnumerated},
    {SMIL2AttrSystem_Required,           "system-required"          , XMLAttrTypeCDATA},
    {SMIL2AttrSystem_Screen_Depth,       "system-screen-depth"      , XMLAttrTypeCDATA},
    {SMIL2AttrSystem_Screen_Size,        "system-screen-size"       , XMLAttrTypeCDATA},
    {SMIL2AttrSystemAudioDesc,           "systemAudioDesc"          , XMLAttrTypeEnumerated},
    {SMIL2AttrSystemBitrate,             "systemBitrate"            , XMLAttrTypeCDATA},
    {SMIL2AttrSystemCaptions,            "systemCaptions"           , XMLAttrTypeEnumerated},
    {SMIL2AttrSystemComponent,           "systemComponent"          , XMLAttrTypeCDATA},
    {SMIL2AttrSystemCPU,                 "systemCPU"                , XMLAttrTypeNMTOKEN},
    {SMIL2AttrSystemLanguage,            "systemLanguage"           , XMLAttrTypeCDATA},
    {SMIL2AttrSystemOperatingSystem,     "systemOperatingSystem"    , XMLAttrTypeNMTOKEN},
    {SMIL2AttrSystemOverdubOrSubtitle,   "systemOverdubOrSubtitle"  , XMLAttrTypeEnumerated},
    {SMIL2AttrSystemRequired,            "systemRequired"           , XMLAttrTypeCDATA},
    {SMIL2AttrSystemScreenDepth,         "systemScreenDepth"        , XMLAttrTypeCDATA},
    {SMIL2AttrSystemScreenSize,          "systemScreenSize"         , XMLAttrTypeCDATA},
    {SMIL2AttrTabindex,                  "tabindex"                 , XMLAttrTypeCDATA},
    {SMIL2AttrTarget,                    "target"                   , XMLAttrTypeCDATA},
    {SMIL2AttrTargetElement,             "targetElement"            , XMLAttrTypeIDREF},
    {SMIL2AttrTitle,                     "title"                    , XMLAttrTypeCDATA},
    {SMIL2AttrTo,                        "to"                       , XMLAttrTypeCDATA},
    {SMIL2AttrTop,                       "top"                      , XMLAttrTypeCDATA},
    {SMIL2AttrTransIn,                   "transIn"                  , XMLAttrTypeCDATA},
    {SMIL2AttrTransOut,                  "transOut"                 , XMLAttrTypeCDATA},
    {SMIL2AttrType,                      "type"                     , XMLAttrTypeEnumerated},
    {SMIL2AttrUid,                       "uid"                      , XMLAttrTypeCDATA},
    {SMIL2AttrValue,                     "value"                    , XMLAttrTypeCDATA},
    {SMIL2AttrValues,                    "values"                   , XMLAttrTypeCDATA},
    {SMIL2AttrValuetype,                 "valuetype"                , XMLAttrTypeEnumerated},
    {SMIL2AttrVertRepeat,                "vertRepeat"               , XMLAttrTypeCDATA},
    {SMIL2AttrWidth,                     "width"                    , XMLAttrTypeCDATA},
    {SMIL2AttrXmlBase,                   "xml:base"                 , XMLAttrTypeCDATA},
    {SMIL2AttrXmlLang,                   "xml:lang"                 , XMLAttrTypeNMTOKEN},
    {SMIL2AttrXmlns,                     "xmlns"                    , XMLAttrTypeCDATA},
    {SMIL2AttrZ_Index,                   "z-index"                  , XMLAttrTypeCDATA},
    {NumSMIL2Attributes,                 NULL                       , XMLAttrTypeCDATA}  // NOTE: THIS SHOULD ALWAYS BE LAST!!!
};

static const struct EnumAttrTable
{
    SMIL2Attribute m_eAttr;
    const char*    m_pszStr;
    BYTE           m_ucEnum;
} g_EnumAttrTable[] =
{
    {SMIL2AttrAccumulate,                "none",                        AccumulateNone},
    {SMIL2AttrAccumulate,                "sum",                         AccumulateSum},
    {SMIL2AttrActuate,                   "onRequest",                   ActuateOnRequest},
    {SMIL2AttrActuate,                   "onLoad",                      ActuateOnLoad},
    {SMIL2AttrAdditive,                  "replace",                     AdditiveReplace},
    {SMIL2AttrAdditive,                  "sum",                         AdditiveSum},
    {SMIL2AttrCalcMode,                  "discrete",                    CalcModeDiscrete},
    {SMIL2AttrCalcMode,                  "linear",                      CalcModeLinear},
    {SMIL2AttrCalcMode,                  "paced",                       CalcModePaced},
    {SMIL2AttrClose,                     "onRequest",                   ViewportCloseOnRequest},
    {SMIL2AttrClose,                     "whenNotActive",               ViewportCloseWhenNotActive},
    {SMIL2AttrDefaultState,              "true",                        TRUE},
    {SMIL2AttrDefaultState,              "false",                       FALSE},
    {SMIL2AttrDestinationPlaystate,      "play",                        DestinationPlaystatePlay},
    {SMIL2AttrDestinationPlaystate,      "pause",                       DestinationPlaystatePause},
    {SMIL2AttrDestinationPlaystate,      "stop",                        DestinationPlaystateStop},
    {SMIL2AttrDirection,                 "forward",                     TransitionDirectionForward},
    {SMIL2AttrDirection,                 "reverse",                     TransitionDirectionReverse},
    {SMIL2AttrErase,                     "whenDone",                    EraseWhenDone},
    {SMIL2AttrErase,                     "never",                       EraseNever},
    {SMIL2AttrExternal,                  "true",                        TRUE},
    {SMIL2AttrExternal,                  "false",                       FALSE},
    {SMIL2AttrFill,                      "remove",                      FillRemove},
    {SMIL2AttrFill,                      "freeze",                      FillFreeze},
    {SMIL2AttrFill,                      "hold",                        FillHold},
    {SMIL2AttrFill,                      "transition",                  FillTransition},
    {SMIL2AttrFill,                      "auto",                        FillAuto},
    {SMIL2AttrFill,                      "default",                     FillDefault},
    {SMIL2AttrFillDefault,               "remove",                      FillDefaultRemove},
    {SMIL2AttrFillDefault,               "freeze",                      FillDefaultFreeze},
    {SMIL2AttrFillDefault,               "hold",                        FillDefaultHold},
    {SMIL2AttrFillDefault,               "transition",                  FillDefaultTransition},
    {SMIL2AttrFillDefault,               "auto",                        FillDefaultAuto},
    {SMIL2AttrFillDefault,               "inherit",                     FillDefaultInherit},
    {SMIL2AttrFit,                       "fill",                        FitFill},
    {SMIL2AttrFit,                       "hidden",                      FitHidden},
    {SMIL2AttrFit,                       "meet",                        FitMeet},
    {SMIL2AttrFit,                       "scroll",                      FitScroll},
    {SMIL2AttrFit,                       "slice",                       FitSlice},
    {SMIL2AttrHigher,                    "stop",                        HigherStop},
    {SMIL2AttrHigher,                    "pause",                       HigherPause},
    {SMIL2AttrLower,                     "defer",                       LowerDefer},
    {SMIL2AttrLower,                     "never",                       LowerNever},
    {SMIL2AttrMediaRepeat,               "preserve",                    MediaRepeatPreserve},
    {SMIL2AttrMediaRepeat,               "strip",                       MediaRepeatStrip},
    {SMIL2AttrNohref,                    "true",                        TRUE},
    {SMIL2AttrNohref,                    "false",                       FALSE},
    {SMIL2AttrOpen,                      "onStart",                     ViewportOpenOnStart},
    {SMIL2AttrOpen,                      "whenActive",                  ViewportOpenWhenActive},
    {SMIL2AttrOrigin,                    "default",                     0},
    {SMIL2AttrOverride,                  "visible",                     OverrideVisible},
    {SMIL2AttrOverride,                  "hidden",                      OverrideHidden},
    {SMIL2AttrPauseDisplay,              "disable",                     PauseDisplayDisable},
    {SMIL2AttrPauseDisplay,              "hide",                        PauseDisplayHide},
    {SMIL2AttrPauseDisplay,              "show",                        PauseDisplayShow},
    {SMIL2AttrPeers,                     "stop",                        PeersStop},
    {SMIL2AttrPeers,                     "pause",                       PeersPause},
    {SMIL2AttrPeers,                     "defer",                       PeersDefer},
    {SMIL2AttrPeers,                     "never",                       PeersNever},
    {SMIL2AttrRegAlign,                  "topLeft",                     RegAlignTopLeft},
    {SMIL2AttrRegAlign,                  "topMid",                      RegAlignTopMid},
    {SMIL2AttrRegAlign,                  "topRight",                    RegAlignTopRight},
    {SMIL2AttrRegAlign,                  "midLeft",                     RegAlignMidLeft},
    {SMIL2AttrRegAlign,                  "center",                      RegAlignCenter},
    {SMIL2AttrRegAlign,                  "midRight",                    RegAlignMidRight},
    {SMIL2AttrRegAlign,                  "bottomLeft",                  RegAlignBottomLeft},
    {SMIL2AttrRegAlign,                  "bottomMid",                   RegAlignBottomMid},
    {SMIL2AttrRegAlign,                  "bottomRight",                 RegAlignBottomRight},
    {SMIL2AttrRestart,                   "always",                      SmilRestartAlways},
    {SMIL2AttrRestart,                   "whenNotActive",               SmilRestartWhenNotActive},
    {SMIL2AttrRestart,                   "never",                       SmilRestartNever},
    {SMIL2AttrRestart,                   "default",                     SmilRestartDefault},
    {SMIL2AttrRestartDefault,            "inherit",                     SmilRestartInherit},
    {SMIL2AttrRestartDefault,            "always",                      SmilRestartAlways},
    {SMIL2AttrRestartDefault,            "never",                       SmilRestartNever},
    {SMIL2AttrRestartDefault,            "whenNotActive",               SmilRestartWhenNotActive},
    {SMIL2AttrShape,                     "rect",                        ShapeRect},
    {SMIL2AttrShape,                     "circle",                      ShapeCircle},
    {SMIL2AttrShape,                     "poly",                        ShapePoly},
    {SMIL2AttrShape,                     "default",                     ShapeDefault},
    {SMIL2AttrShow,                      "new",                         ShowNew},
    {SMIL2AttrShow,                      "pause",                       ShowPause},
    {SMIL2AttrShow,                      "replace",                     ShowReplace},
    {SMIL2AttrShowBackground,            "always",                      ShowBackgroundAlways},
    {SMIL2AttrShowBackground,            "whenActive",                  ShowBackgroundWhenActive},
    {SMIL2AttrSkip_Content,              "true",                        TRUE},
    {SMIL2AttrSkip_Content,              "false",                       FALSE},
    {SMIL2AttrSourcePlaystate,           "play",                        SourcePlaystatePlay},
    {SMIL2AttrSourcePlaystate,           "pause",                       SourcePlaystatePause},
    {SMIL2AttrSourcePlaystate,           "stop",                        SourcePlaystateStop},
    {SMIL2AttrSubtype,                   "leftToRight",                 TransitionSubtypeLeftToRight},
    {SMIL2AttrSubtype,                   "topToBottom",                 TransitionSubtypeTopToBottom},
    {SMIL2AttrSubtype,                   "topLeft",                     TransitionSubtypeTopLeft},
    {SMIL2AttrSubtype,                   "topRight",                    TransitionSubtypeTopRight},
    {SMIL2AttrSubtype,                   "bottomRight",                 TransitionSubtypeBottomRight},
    {SMIL2AttrSubtype,                   "bottomLeft",                  TransitionSubtypeBottomLeft},
    {SMIL2AttrSubtype,                   "topCenter",                   TransitionSubtypeTopCenter},
    {SMIL2AttrSubtype,                   "rightCenter",                 TransitionSubtypeRightCenter},
    {SMIL2AttrSubtype,                   "bottomCenter",                TransitionSubtypeBottomCenter},
    {SMIL2AttrSubtype,                   "leftCenter",                  TransitionSubtypeLeftCenter},
    {SMIL2AttrSubtype,                   "cornersIn",                   TransitionSubtypeCornersIn},
    {SMIL2AttrSubtype,                   "cornersOut",                  TransitionSubtypeCornersOut},
    {SMIL2AttrSubtype,                   "vertical",                    TransitionSubtypeVertical},
    {SMIL2AttrSubtype,                   "horizontal",                  TransitionSubtypeHorizontal},
    {SMIL2AttrSubtype,                   "diagonalBottomLeft",          TransitionSubtypeDiagonalBottomLeft},
    {SMIL2AttrSubtype,                   "diagonalTopLeft",             TransitionSubtypeDiagonalTopLeft},
    {SMIL2AttrSubtype,                   "doubleBarnDoor",              TransitionSubtypeDoubleBarnDoor},
    {SMIL2AttrSubtype,                   "doubleDiamond",               TransitionSubtypeDoubleDiamond},
    {SMIL2AttrSubtype,                   "down",                        TransitionSubtypeDown},
    {SMIL2AttrSubtype,                   "left",                        TransitionSubtypeLeft},
    {SMIL2AttrSubtype,                   "up",                          TransitionSubtypeUp},
    {SMIL2AttrSubtype,                   "right",                       TransitionSubtypeRight},
    {SMIL2AttrSubtype,                   "rectangle",                   TransitionSubtypeRectangle},
    {SMIL2AttrSubtype,                   "diamond",                     TransitionSubtypeDiamond},
    {SMIL2AttrSubtype,                   "circle",                      TransitionSubtypeCircle},
    {SMIL2AttrSubtype,                   "fourPoint",                   TransitionSubtypeFourPoint},
    {SMIL2AttrSubtype,                   "fivePoint",                   TransitionSubtypeFivePoint},
    {SMIL2AttrSubtype,                   "sixPoint",                    TransitionSubtypeSixPoint},
    {SMIL2AttrSubtype,                   "heart",                       TransitionSubtypeHeart},
    {SMIL2AttrSubtype,                   "keyhole",                     TransitionSubtypeKeyhole},
    {SMIL2AttrSubtype,                   "clockwiseTwelve",             TransitionSubtypeClockwiseTwelve},
    {SMIL2AttrSubtype,                   "clockwiseThree",              TransitionSubtypeClockwiseThree},
    {SMIL2AttrSubtype,                   "clockwiseSix",                TransitionSubtypeClockwiseSix},
    {SMIL2AttrSubtype,                   "clockwiseNine",               TransitionSubtypeClockwiseNine},
    {SMIL2AttrSubtype,                   "twoBladeVertical",            TransitionSubtypeTwoBladeVertical},
    {SMIL2AttrSubtype,                   "twoBladeHorizontal",          TransitionSubtypeTwoBladeHorizontal},
    {SMIL2AttrSubtype,                   "fourBlade",                   TransitionSubtypeFourBlade},
    {SMIL2AttrSubtype,                   "clockwiseTop",                TransitionSubtypeClockwiseTop},
    {SMIL2AttrSubtype,                   "clockwiseRight",              TransitionSubtypeClockwiseRight},
    {SMIL2AttrSubtype,                   "clockwiseBottom",             TransitionSubtypeClockwiseBottom},
    {SMIL2AttrSubtype,                   "clockwiseLeft",               TransitionSubtypeClockwiseLeft},
    {SMIL2AttrSubtype,                   "clockwiseTopLeft",            TransitionSubtypeClockwiseTopLeft},
    {SMIL2AttrSubtype,                   "counterClockwiseBottomLeft",  TransitionSubtypeCounterClockwiseBottomLeft},
    {SMIL2AttrSubtype,                   "clockwiseBottomRight",        TransitionSubtypeClockwiseBottomRight},
    {SMIL2AttrSubtype,                   "counterClockwiseTopRight",    TransitionSubtypeCounterClockwiseTopRight},
    {SMIL2AttrSubtype,                   "centerTop",                   TransitionSubtypeCenterTop},
    {SMIL2AttrSubtype,                   "centerRight",                 TransitionSubtypeCenterRight},
    {SMIL2AttrSubtype,                   "fanOutVertical",              TransitionSubtypeFanOutVertical},
    {SMIL2AttrSubtype,                   "fanOutHorizontal",            TransitionSubtypeFanOutHorizontal},
    {SMIL2AttrSubtype,                   "fanInVertical",               TransitionSubtypeFanInVertical},
    {SMIL2AttrSubtype,                   "fanInHorizontal",             TransitionSubtypeFanInHorizontal},
    {SMIL2AttrSubtype,                   "parallelVertical",            TransitionSubtypeParallelVertical},
    {SMIL2AttrSubtype,                   "parallelHorizontal",          TransitionSubtypeParallelHorizontal},
    {SMIL2AttrSubtype,                   "parallelDiagonal",            TransitionSubtypeParallelDiagonal},
    {SMIL2AttrSubtype,                   "oppositeVertical",            TransitionSubtypeOppositeVertical},
    {SMIL2AttrSubtype,                   "oppositeHorizontal",          TransitionSubtypeOppositeHorizontal},
    {SMIL2AttrSubtype,                   "parallelDiagonalTopLeft",     TransitionSubtypeParallelDiagonalTopLeft},
    {SMIL2AttrSubtype,                   "parallelDiagonalBottomLeft",  TransitionSubtypeParallelDiagonalBottomLeft},
    {SMIL2AttrSubtype,                   "top",                         TransitionSubtypeTop},
    {SMIL2AttrSubtype,                   "bottom",                      TransitionSubtypeBottom},
    {SMIL2AttrSubtype,                   "topLeftHorizontal",           TransitionSubtypeTopLeftHorizontal},
    {SMIL2AttrSubtype,                   "topLeftVertical",             TransitionSubtypeTopLeftVertical},
    {SMIL2AttrSubtype,                   "topLeftDiagonal",             TransitionSubtypeTopLeftDiagonal},
    {SMIL2AttrSubtype,                   "topRightDiagonal",            TransitionSubtypeTopRightDiagonal},
    {SMIL2AttrSubtype,                   "bottomRightDiagonal",         TransitionSubtypeBottomRightDiagonal},
    {SMIL2AttrSubtype,                   "bottomLeftDiagonal",          TransitionSubtypeBottomLeftDiagonal},
    {SMIL2AttrSubtype,                   "topLeftClockwise",            TransitionSubtypeTopLeftClockwise},
    {SMIL2AttrSubtype,                   "topRightClockwise",           TransitionSubtypeTopRightClockwise},
    {SMIL2AttrSubtype,                   "bottomRightClockwise",        TransitionSubtypeBottomRightClockwise},
    {SMIL2AttrSubtype,                   "bottomLeftClockwise",         TransitionSubtypeBottomLeftClockwise},
    {SMIL2AttrSubtype,                   "topLeftCounterClockwise",     TransitionSubtypeTopLeftCounterClockwise},
    {SMIL2AttrSubtype,                   "topRightCounterClockwise",    TransitionSubtypeTopRightCounterClockwise},
    {SMIL2AttrSubtype,                   "bottomRightCounterClockwise", TransitionSubtypeBottomRightCounterClockwise},
    {SMIL2AttrSubtype,                   "bottomLeftCounterClockwise",  TransitionSubtypeBottomLeftCounterClockwise},
    {SMIL2AttrSubtype,                   "verticalTopSame",             TransitionSubtypeVerticalTopSame},
    {SMIL2AttrSubtype,                   "verticalBottomSame",          TransitionSubtypeVerticalBottomSame},
    {SMIL2AttrSubtype,                   "verticalTopLeftOpposite",     TransitionSubtypeVerticalTopLeftOpposite},
    {SMIL2AttrSubtype,                   "verticalBottomLeftOpposite",  TransitionSubtypeVerticalBottomLeftOpposite},
    {SMIL2AttrSubtype,                   "horizontalLeftSame",          TransitionSubtypeHorizontalLeftSame},
    {SMIL2AttrSubtype,                   "horizontalRightSame",         TransitionSubtypeHorizontalRightSame},
    {SMIL2AttrSubtype,                   "horizontalTopLeftOpposite",   TransitionSubtypeHorizontalTopLeftOpposite},
    {SMIL2AttrSubtype,                   "horizontalTopRightOpposite",  TransitionSubtypeHorizontalTopRightOpposite},
    {SMIL2AttrSubtype,                   "diagonalBottomLeftOpposite",  TransitionSubtypeDiagonalBottomLeftOpposite},
    {SMIL2AttrSubtype,                   "diagonalTopLeftOpposite",     TransitionSubtypeDiagonalTopLeftOpposite},
    {SMIL2AttrSubtype,                   "twoBoxTop",                   TransitionSubtypeTwoBoxTop},
    {SMIL2AttrSubtype,                   "twoBoxBottom",                TransitionSubtypeTwoBoxBottom},
    {SMIL2AttrSubtype,                   "twoBoxLeft",                  TransitionSubtypeTwoBoxLeft},
    {SMIL2AttrSubtype,                   "twoBoxRight",                 TransitionSubtypeTwoBoxRight},
    {SMIL2AttrSubtype,                   "fourBoxVertical",             TransitionSubtypeFourBoxVertical},
    {SMIL2AttrSubtype,                   "fourBoxHorizontal",           TransitionSubtypeFourBoxHorizontal},
    {SMIL2AttrSubtype,                   "verticalLeft",                TransitionSubtypeVerticalLeft},
    {SMIL2AttrSubtype,                   "verticalRight",               TransitionSubtypeVerticalRight},
    {SMIL2AttrSubtype,                   "horizontalLeft",              TransitionSubtypeHorizontalLeft},
    {SMIL2AttrSubtype,                   "horizontalRight",             TransitionSubtypeHorizontalRight},
    {SMIL2AttrSubtype,                   "fromLeft",                    TransitionSubtypeFromLeft},
    {SMIL2AttrSubtype,                   "fromTop",                     TransitionSubtypeFromTop},
    {SMIL2AttrSubtype,                   "fromRight",                   TransitionSubtypeFromRight},
    {SMIL2AttrSubtype,                   "fromBottom",                  TransitionSubtypeFromBottom},
    {SMIL2AttrSubtype,                   "crossfade",                   TransitionSubtypeCrossfade},
    {SMIL2AttrSubtype,                   "fadeToColor",                 TransitionSubtypeFadeToColor},
    {SMIL2AttrSubtype,                   "fadeFromColor",               TransitionSubtypeFadeFromColor},
    {SMIL2AttrSyncBehavior,              "canSlip",                     SmilSyncBehaviorCanSlip},
    {SMIL2AttrSyncBehavior,              "locked",                      SmilSyncBehaviorLocked},
    {SMIL2AttrSyncBehavior,              "independent",                 SmilSyncBehaviorIndependent},
    {SMIL2AttrSyncBehavior,              "default",                     SmilSyncBehaviorDefault},
    {SMIL2AttrSyncBehaviorDefault,       "canSlip",                     SmilSyncBehaviorCanSlip},
    {SMIL2AttrSyncBehaviorDefault,       "locked",                      SmilSyncBehaviorLocked},
    {SMIL2AttrSyncBehaviorDefault,       "independent",                 SmilSyncBehaviorIndependent},
    {SMIL2AttrSyncBehaviorDefault,       "inherit",                     SmilSyncBehaviorInherit},
    {SMIL2AttrSystem_Captions,           "on",                          SystemCaptionsOn},
    {SMIL2AttrSystem_Captions,           "off",                         SystemCaptionsOff},
    {SMIL2AttrSystem_Overdub_Or_Caption, "overdub",                     OverdubOrCaptionOverdub},
    {SMIL2AttrSystem_Overdub_Or_Caption, "caption",                     OverdubOrCaptionCaption},
    {SMIL2AttrSystemAudioDesc,           "on",                          AudioDescOn},
    {SMIL2AttrSystemAudioDesc,           "off",                         AudioDescOff},
    {SMIL2AttrSystemCaptions,            "on",                          SystemCaptionsOn},
    {SMIL2AttrSystemCaptions,            "off",                         SystemCaptionsOff},
    {SMIL2AttrSystemOverdubOrSubtitle,   "overdub",                     OverdubOrSubtitleOverdub},
    {SMIL2AttrSystemOverdubOrSubtitle,   "subtitle",                    OverdubOrSubtitleSubtitle},
    {SMIL2AttrType,                      "barWipe",                     TransitionTypeBarWipe},
    {SMIL2AttrType,                      "boxWipe",                     TransitionTypeBoxWipe},
    {SMIL2AttrType,                      "fourBoxWipe",                 TransitionTypeFourBoxWipe},
    {SMIL2AttrType,                      "barnDoorWipe",                TransitionTypeBarnDoorWipe},
    {SMIL2AttrType,                      "diagonalWipe",                TransitionTypeDiagonalWipe},
    {SMIL2AttrType,                      "bowTieWipe",                  TransitionTypeBowTieWipe},
    {SMIL2AttrType,                      "miscDiagonalWipe",            TransitionTypeMiscDiagonalWipe},
    {SMIL2AttrType,                      "veeWipe",                     TransitionTypeVeeWipe},
    {SMIL2AttrType,                      "barnVeeWipe",                 TransitionTypeBarnVeeWipe},
    {SMIL2AttrType,                      "zigZagWipe",                  TransitionTypeZigZagWipe},
    {SMIL2AttrType,                      "barnZigZagWipe",              TransitionTypeBarnZigZagWipe},
    {SMIL2AttrType,                      "irisWipe",                    TransitionTypeIrisWipe},
    {SMIL2AttrType,                      "triangleWipe",                TransitionTypeTriangleWipe},
    {SMIL2AttrType,                      "arrowHeadWipe",               TransitionTypeArrowHeadWipe},
    {SMIL2AttrType,                      "pentagonWipe",                TransitionTypePentagonWipe},
    {SMIL2AttrType,                      "hexagonWipe",                 TransitionTypeHexagonWipe},
    {SMIL2AttrType,                      "ellipseWipe",                 TransitionTypeEllipseWipe},
    {SMIL2AttrType,                      "eyeWipe",                     TransitionTypeEyeWipe},
    {SMIL2AttrType,                      "roundRectWipe",               TransitionTypeRoundRectWipe},
    {SMIL2AttrType,                      "starWipe",                    TransitionTypeStarWipe},
    {SMIL2AttrType,                      "miscShapeWipe",               TransitionTypeMiscShapeWipe},
    {SMIL2AttrType,                      "clockWipe",                   TransitionTypeClockWipe},
    {SMIL2AttrType,                      "pinWheelWipe",                TransitionTypePinWheelWipe},
    {SMIL2AttrType,                      "singleSweepWipe",             TransitionTypeSingleSweepWipe},
    {SMIL2AttrType,                      "fanWipe",                     TransitionTypeFanWipe},
    {SMIL2AttrType,                      "doubleFanWipe",               TransitionTypeDoubleFanWipe},
    {SMIL2AttrType,                      "doubleSweepWipe",             TransitionTypeDoubleSweepWipe},
    {SMIL2AttrType,                      "saloonDoorWipe",              TransitionTypeSaloonDoorWipe},
    {SMIL2AttrType,                      "windshieldWipe",              TransitionTypeWindshieldWipe},
    {SMIL2AttrType,                      "snakeWipe",                   TransitionTypeSnakeWipe},
    {SMIL2AttrType,                      "spiralWipe",                  TransitionTypeSpiralWipe},
    {SMIL2AttrType,                      "parallelSnakesWipe",          TransitionTypeParallelSnakesWipe},
    {SMIL2AttrType,                      "boxSnakesWipe",               TransitionTypeBoxSnakesWipe},
    {SMIL2AttrType,                      "waterfallWipe",               TransitionTypeWaterfallWipe},
    {SMIL2AttrType,                      "pushWipe",                    TransitionTypePushWipe},
    {SMIL2AttrType,                      "slideWipe",                   TransitionTypeSlideWipe},
    {SMIL2AttrType,                      "fade",                        TransitionTypeFade},
    {SMIL2AttrValuetype,                 "data",                        ValuetypeData},
    {SMIL2AttrValuetype,                 "ref",                         ValuetypeRef},
    {SMIL2AttrValuetype,                 "object",                      ValuetypeObject},
    {SMIL2AttrRNDelivery,                "client",                      DeliveryClient},
    {SMIL2AttrRNDelivery,                "server",                      DeliveryServer},
    {SMIL2AttrRNHandledBy,               "_rpbrowser",                  HandledByRPBrowser},
    {SMIL2AttrRNHandledBy,               "_rpcontextwin",               HandledByRPContextWin},
    {SMIL2AttrRNHandledBy,               "_rpengine",                   HandledByRPEngine},
    {SMIL2AttrRNHandledBy,               "auto",                        HandledByAuto},
    {SMIL2AttrRNContextWindow,           "auto",                        ContextWindowAuto},
    {SMIL2AttrRNContextWindow,           "openAtStart",                 ContextWindowOpenAtStart},
    {SMIL2AttrRNResizeBehavior,          "zoom",                        ResizeZoom},
    {SMIL2AttrRNResizeBehavior,          "percentOnly",                 ResizePercentOnly},
    {XMLEventsAttrPhase,                 "capture",                     PhaseCapture},
    {XMLEventsAttrPhase,                 "default",                     PhaseDefault},
    {XMLEventsAttrPropagate,             "stop",                        PropagateStop},
    {XMLEventsAttrPropagate,             "continue",                    PropagateContinue},
    {XMLEventsAttrDefaultAction,         "cancel",                      DefaultActionCancel},
    {XMLEventsAttrDefaultAction,         "perform",                     DefaultActionPerform},
    {SMIL2AttrRNAccessErrorBehavior,     "inherit",                     AccessErrorBehaviorInherit},
    {SMIL2AttrRNAccessErrorBehavior,     "continue",                    AccessErrorBehaviorContinue},
    {SMIL2AttrRNAccessErrorBehavior,     "stop",                        AccessErrorBehaviorStop},
    {NumSMIL2Attributes,                 NULL,                          0}
};

#if defined(HELIX_FEATURE_SMIL2_VALIDATION)

static const SMIL2Element g_ElementEnumMap[] =
{
    SMIL2ElemA,
    SMIL2ElemAnchor,
    SMIL2ElemAnimate,
    SMIL2ElemAnimateColor,
    SMIL2ElemAnimateMotion,
    SMIL2ElemAnimation,
    SMIL2ElemArea,
    SMIL2ElemAudio,
    SMIL2ElemBody,
    SMIL2ElemBrush,
    SMIL2ElemCustomAttributes,
    SMIL2ElemCustomTest,
    SMIL2ElemExcl,
    SMIL2ElemHead,
    SMIL2ElemImg,
    SMIL2ElemLayout,
    SMIL2ElemMeta,
    SMIL2ElemMetadata,
    SMIL2ElemPar,
    SMIL2ElemParam,
    SMIL2ElemPrefetch,
    SMIL2ElemPriorityClass,
    SMIL2ElemRef,
    SMIL2ElemRegPoint,
    SMIL2ElemRegion,
    SMIL2ElemRootLayout,
    SMIL2ElemSeq,
    SMIL2ElemSet,
    SMIL2ElemSmil,
    SMIL2ElemSwitch,
    SMIL2ElemText,
    SMIL2ElemTextstream,
    SMIL2ElemTopLayout,
    SMIL2ElemTransition,
    SMIL2ElemVideo,
    SMIL2ElemRNParam,
    SMIL2ElemRNRendererList,
    SMIL2ElemRNRenderer,
    XMLEventsElemListener
};

static const SMILElementTable g_ExtElementTable[] =
{
    {SMIL2ElemRNParam,          "param"           },
    {SMIL2ElemRNRendererList,   "renderer-list"   },
    {SMIL2ElemRNRenderer,       "renderer"        },
    {XMLEventsElemListener,     "listener"        },
    {NumSMIL2Elements,          NULL              }  // NOTE: THIS SHOULD ALWAYS BE LAST!!!
};

static const SMILAttributeTable g_ExtAttributeTable[] =
{
    {SMIL2AttrRNBackgroundOpacity,       "backgroundOpacity"        , XMLAttrTypeCDATA},
    {SMIL2AttrRNChromaKey,               "chromaKey"                , XMLAttrTypeCDATA},
    {SMIL2AttrRNChromaKeyOpacity,        "chromaKeyOpacity"         , XMLAttrTypeCDATA},
    {SMIL2AttrRNChromaKeyTolerance,      "chromaKeyTolerance"       , XMLAttrTypeCDATA},
    {SMIL2AttrRNMediaOpacity,            "mediaOpacity"             , XMLAttrTypeCDATA},
    {SMIL2AttrRNOpacity,                 "opacity"                  , XMLAttrTypeCDATA},
    {SMIL2AttrRNDelivery,                "delivery"                 , XMLAttrTypeEnumerated},
    {SMIL2AttrRNHandledBy,               "handledBy"                , XMLAttrTypeEnumerated},
    {SMIL2AttrRNSendTo,                  "sendTo"                   , XMLAttrTypeCDATA},
    {SMIL2AttrRNContextWindow,           "contextWindow"            , XMLAttrTypeEnumerated},
    {SMIL2AttrRNSystemComponent,         "systemComponent"          , XMLAttrTypeCDATA},
    {SMIL2AttrRNResizeBehavior,          "resizeBehavior"           , XMLAttrTypeEnumerated},
    {XMLEventsAttrEvent,                 "event"                    , XMLAttrTypeCDATA},
    {XMLEventsAttrObserver,              "observer"                 , XMLAttrTypeCDATA},
    {XMLEventsAttrTarget,                "target"                   , XMLAttrTypeCDATA},
    {XMLEventsAttrHandler,               "handler"                  , XMLAttrTypeCDATA},
    {XMLEventsAttrPhase,                 "phase"                    , XMLAttrTypeEnumerated},
    {XMLEventsAttrPropagate,             "propagate"                , XMLAttrTypeEnumerated},
    {XMLEventsAttrDefaultAction,         "defaultAction"            , XMLAttrTypeEnumerated},
    {SMIL2AttrRNAccessErrorBehavior,     "accessErrorBehavior"      , XMLAttrTypeEnumerated},
    {NumSMIL2Attributes,                 NULL                       , XMLAttrTypeCDATA}  // NOTE: THIS SHOULD ALWAYS BE LAST!!!
};

static const BYTE g_AttrCollections[] =
{
    SMIL2AttrCollCore, 6,
        SMIL2AttrAlt,
        SMIL2AttrClass,
        SMIL2AttrId,
        SMIL2AttrLongdesc,
        SMIL2AttrTitle,
        SMIL2AttrXmlBase,
    SMIL2AttrCollI18N, 1,
        SMIL2AttrXmlLang,
    SMIL2AttrCollBasicTiming, 8,
        SMIL2AttrBegin,
        SMIL2AttrDur,
        SMIL2AttrEnd,
        SMIL2AttrRepeat,
        SMIL2AttrRepeatCount,
        SMIL2AttrRepeatDur,
        SMIL2AttrMin,
        SMIL2AttrMax,
    SMIL2AttrCollTest, 18,
        SMIL2AttrSystem_Bitrate,
        SMIL2AttrSystem_Captions,
        SMIL2AttrSystem_Language,
        SMIL2AttrSystem_Overdub_Or_Caption,
        SMIL2AttrSystem_Screen_Depth,
        SMIL2AttrSystem_Required,
        SMIL2AttrSystem_Screen_Size,
        SMIL2AttrSystemAudioDesc,
        SMIL2AttrSystemBitrate,
        SMIL2AttrSystemCaptions,
        SMIL2AttrSystemComponent,
        SMIL2AttrSystemCPU,
        SMIL2AttrSystemLanguage,
        SMIL2AttrSystemOperatingSystem,
        SMIL2AttrSystemOverdubOrSubtitle,
        SMIL2AttrSystemRequired,
        SMIL2AttrSystemScreenDepth,
        SMIL2AttrSystemScreenSize,
    SMIL2AttrCollTiming, 16,
        SMIL2AttrBegin,
        SMIL2AttrDur,
        SMIL2AttrEnd,
        SMIL2AttrFillDefault,
        SMIL2AttrMax,
        SMIL2AttrMin,
        SMIL2AttrRepeat,
        SMIL2AttrRepeatCount,
        SMIL2AttrRepeatDur,
        SMIL2AttrRestart,
        SMIL2AttrRestartDefault,
        SMIL2AttrSyncBehavior,
        SMIL2AttrSyncBehaviorDefault,
        SMIL2AttrSyncTolerance,
        SMIL2AttrSyncToleranceDefault,
        SMIL2AttrRNAccessErrorBehavior,
    SMIL2AttrCollSubregion, 12,
        SMIL2AttrBackground_Color,
        SMIL2AttrBackgroundColor,
        SMIL2AttrBottom,
        SMIL2AttrFit,
        SMIL2AttrHeight,
        SMIL2AttrLeft,
        SMIL2AttrRegPoint,
        SMIL2AttrRegAlign,
        SMIL2AttrRight,
        SMIL2AttrTop,
        SMIL2AttrWidth,
        SMIL2AttrZ_Index,
    SMIL2AttrCollMediaElement, 27,
        SMIL2AttrAbstract,
        SMIL2AttrAuthor,
        SMIL2AttrBackground_Color,
        SMIL2AttrBackgroundColor,
        SMIL2AttrClip_Begin,
        SMIL2AttrClip_End,
        SMIL2AttrClipBegin,
        SMIL2AttrClipEnd,
        SMIL2AttrCopyright,
        SMIL2AttrCustomTest,
        SMIL2AttrErase,
        SMIL2AttrFill,
        SMIL2AttrMediaRepeat,
        SMIL2AttrReadIndex,
        SMIL2AttrRegion,
        SMIL2AttrSensitivity,
        SMIL2AttrSrc,
        SMIL2AttrTabindex,
        SMIL2AttrTransIn,
        SMIL2AttrTransOut,
        SMIL2AttrType,
        SMIL2AttrRNBackgroundOpacity,
        SMIL2AttrRNChromaKey,
        SMIL2AttrRNChromaKeyOpacity,
        SMIL2AttrRNChromaKeyTolerance,
        SMIL2AttrRNMediaOpacity,
        XMLEventsAttrHandler,
    NumSMIL2AttributeCollections  // NOTE: THIS SHOULD ALWAYS BE LAST!!!
};

static const BYTE g_LegalAttr[] =
{
    SMIL2ElemA, 4, 13,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollBasicTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAccesskey,
        SMIL2AttrActuate,
        SMIL2AttrCustomTest,
        SMIL2AttrDestinationLevel,
        SMIL2AttrDestinationPlaystate,
        SMIL2AttrExternal,
        SMIL2AttrHref,
        SMIL2AttrShow,
        SMIL2AttrSourceLevel,
        SMIL2AttrSourcePlaystate,
        SMIL2AttrTabindex,
        SMIL2AttrTarget,
        SMIL2AttrRNSendTo,
    SMIL2ElemAnchor, 4, 18,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollBasicTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAccesskey,
        SMIL2AttrActuate,
        SMIL2AttrCoords,
        SMIL2AttrCustomTest,
        SMIL2AttrDestinationLevel,
        SMIL2AttrDestinationPlaystate,
        SMIL2AttrExternal,
        SMIL2AttrFragment,
        SMIL2AttrHref,
        SMIL2AttrNohref,
        SMIL2AttrShape,
        SMIL2AttrShow,
        SMIL2AttrSourceLevel,
        SMIL2AttrSourcePlaystate,
        SMIL2AttrTabindex,
        SMIL2AttrTarget,
        SMIL2AttrTitle,
        SMIL2AttrRNSendTo,
    SMIL2ElemAnimate, 4, 14,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollBasicTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAccumulate,
        SMIL2AttrAdditive,
        SMIL2AttrAttributeName,
        SMIL2AttrAttributeType,
        SMIL2AttrBy,
        SMIL2AttrCalcMode,
        SMIL2AttrCustomTest,
        SMIL2AttrFill,
        SMIL2AttrFillDefault,
        SMIL2AttrFrom,
        SMIL2AttrSkip_Content,
        SMIL2AttrTargetElement,
        SMIL2AttrTo,
        SMIL2AttrValues,
    SMIL2ElemAnimateColor, 4, 14,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollBasicTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAccumulate,
        SMIL2AttrAdditive,
        SMIL2AttrAttributeName,
        SMIL2AttrAttributeType,
        SMIL2AttrBy,
        SMIL2AttrCalcMode,
        SMIL2AttrCustomTest,
        SMIL2AttrFill,
        SMIL2AttrFillDefault,
        SMIL2AttrFrom,
        SMIL2AttrSkip_Content,
        SMIL2AttrTargetElement,
        SMIL2AttrTo,
        SMIL2AttrValues,
    SMIL2ElemAnimateMotion, 4, 13,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollBasicTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAccumulate,
        SMIL2AttrAdditive,
        SMIL2AttrBy,
        SMIL2AttrCalcMode,
        SMIL2AttrCustomTest,
        SMIL2AttrFill,
        SMIL2AttrFillDefault,
        SMIL2AttrFrom,
        SMIL2AttrOrigin,
        SMIL2AttrSkip_Content,
        SMIL2AttrTargetElement,
        SMIL2AttrTo,
        SMIL2AttrValues,
    SMIL2ElemAnimation, 6, 0,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrCollSubregion,
        SMIL2AttrCollMediaElement,
    SMIL2ElemArea, 4, 18,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollBasicTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAccesskey,
        SMIL2AttrActuate,
        SMIL2AttrCoords,
        SMIL2AttrCustomTest,
        SMIL2AttrDestinationLevel,
        SMIL2AttrDestinationPlaystate,
        SMIL2AttrExternal,
        SMIL2AttrFragment,
        SMIL2AttrHref,
        SMIL2AttrNohref,
        SMIL2AttrShape,
        SMIL2AttrShow,
        SMIL2AttrSourceLevel,
        SMIL2AttrSourcePlaystate,
        SMIL2AttrTabindex,
        SMIL2AttrTarget,
        SMIL2AttrTitle,
        SMIL2AttrRNSendTo,
    SMIL2ElemAudio, 6, 0,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrCollSubregion,
        SMIL2AttrCollMediaElement,
    SMIL2ElemBody, 3, 4,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrAbstract,
        SMIL2AttrAuthor,
        SMIL2AttrCopyright,
        SMIL2AttrFill,
    SMIL2ElemBrush, 5, 12,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrCollSubregion,
        SMIL2AttrAbstract,
        SMIL2AttrAuthor,
        SMIL2AttrColor,
        SMIL2AttrCopyright,
        SMIL2AttrCustomTest,
        SMIL2AttrErase,
        SMIL2AttrFill,
        SMIL2AttrRegion,
        SMIL2AttrTabindex,
        SMIL2AttrTransIn,
        SMIL2AttrTransOut,
        SMIL2AttrRNMediaOpacity,
    SMIL2ElemCustomAttributes, 3, 1,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrSkip_Content,
    SMIL2ElemCustomTest, 2, 4,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrDefaultState,
        SMIL2AttrOverride,
        SMIL2AttrSkip_Content,
        SMIL2AttrUid,
    SMIL2ElemExcl, 4, 8,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAbstract,
        SMIL2AttrAuthor,
        SMIL2AttrCopyright,
        SMIL2AttrCustomTest,
        SMIL2AttrEndsync,
        SMIL2AttrFill,
        SMIL2AttrRegion,
        SMIL2AttrSkip_Content,
    SMIL2ElemHead, 2, 0,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
    SMIL2ElemImg, 6, 0,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrCollSubregion,
        SMIL2AttrCollMediaElement,
    SMIL2ElemLayout, 3, 2,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrType,
        SMIL2AttrCustomTest,
    SMIL2ElemMeta, 2, 3,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrContent,
        SMIL2AttrName,
        SMIL2AttrSkip_Content,
    SMIL2ElemMetadata, 2, 1,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrSkip_Content,
    SMIL2ElemPar, 4, 7,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAbstract,
        SMIL2AttrAuthor,
        SMIL2AttrCopyright,
        SMIL2AttrCustomTest,
        SMIL2AttrEndsync,
        SMIL2AttrFill,
        SMIL2AttrRegion,
    SMIL2ElemParam, 3, 6,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrName,
        SMIL2AttrSkip_Content,
        SMIL2AttrType,
        SMIL2AttrValue,
        SMIL2AttrValuetype,
        SMIL2AttrRNDelivery,
    SMIL2ElemPrefetch, 4, 11,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrCollTiming,
        SMIL2AttrBandwidth,
        SMIL2AttrClip_Begin,
        SMIL2AttrClip_End,
        SMIL2AttrClipBegin,
        SMIL2AttrClipEnd,
        SMIL2AttrCustomTest,
        SMIL2AttrMediaSize,
        SMIL2AttrMediaTime,
        SMIL2AttrSkip_Content,
        SMIL2AttrSrc,
        SMIL2AttrRNHandledBy,
    SMIL2ElemPriorityClass, 3, 9,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrAbstract,
        SMIL2AttrAuthor,
        SMIL2AttrCopyright,
        SMIL2AttrCustomTest,
        SMIL2AttrHigher,
        SMIL2AttrLower,
        SMIL2AttrPauseDisplay,
        SMIL2AttrPeers,
        SMIL2AttrSkip_Content,
    SMIL2ElemRef, 6, 0,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrCollSubregion,
        SMIL2AttrCollMediaElement,
    SMIL2ElemRegPoint, 3, 7,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrBottom,
        SMIL2AttrCustomTest,
        SMIL2AttrLeft,
        SMIL2AttrRegAlign,
        SMIL2AttrRight,
        SMIL2AttrSkip_Content,
        SMIL2AttrTop,
    SMIL2ElemRegion, 3, 16,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrBackground_Color,
        SMIL2AttrBackgroundColor,
        SMIL2AttrBottom,
        SMIL2AttrCustomTest,
        SMIL2AttrFit,
        SMIL2AttrHeight,
        SMIL2AttrLeft,
        SMIL2AttrRegionName,
        SMIL2AttrRight,
        SMIL2AttrShowBackground,
        SMIL2AttrSkip_Content,
        SMIL2AttrSoundLevel,
        SMIL2AttrTop,
        SMIL2AttrWidth,
        SMIL2AttrZ_Index,
        SMIL2AttrRNOpacity,
    SMIL2ElemRootLayout, 3, 8,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrBackground_Color,
        SMIL2AttrBackgroundColor,
        SMIL2AttrCustomTest,
        SMIL2AttrHeight,
        SMIL2AttrSkip_Content,
        SMIL2AttrWidth,
        SMIL2AttrRNContextWindow,
        SMIL2AttrRNResizeBehavior,
    SMIL2ElemSeq, 4, 6,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAbstract,
        SMIL2AttrAuthor,
        SMIL2AttrCopyright,
        SMIL2AttrCustomTest,
        SMIL2AttrFill,
        SMIL2AttrRegion,
    SMIL2ElemSet, 4, 8,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollBasicTiming,
        SMIL2AttrCollTest,
        SMIL2AttrAttributeName,
        SMIL2AttrAttributeType,
        SMIL2AttrCustomTest,
        SMIL2AttrFill,
        SMIL2AttrFillDefault,
        SMIL2AttrSkip_Content,
        SMIL2AttrTargetElement,
        SMIL2AttrTo,
    SMIL2ElemSmil, 3, 1,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrXmlns,
    SMIL2ElemSwitch, 3, 1,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrCustomTest,
    SMIL2ElemText, 6, 0,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrCollSubregion,
        SMIL2AttrCollMediaElement,
    SMIL2ElemTextstream, 6, 0,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrCollSubregion,
        SMIL2AttrCollMediaElement,
    SMIL2ElemTopLayout, 3, 10,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTest,
        SMIL2AttrBackground_Color,
        SMIL2AttrBackgroundColor,
        SMIL2AttrClose,
        SMIL2AttrCustomTest,
        SMIL2AttrHeight,
        SMIL2AttrOpen,
        SMIL2AttrSkip_Content,
        SMIL2AttrWidth,
        SMIL2AttrRNContextWindow,
        SMIL2AttrRNResizeBehavior,
    SMIL2ElemTransition, 4, 12,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollBasicTiming,
        SMIL2AttrCollTest,
        SMIL2AttrBorderColor,
        SMIL2AttrBorderWidth,
        SMIL2AttrCustomTest,
        SMIL2AttrDirection,
        SMIL2AttrEndProgress,
        SMIL2AttrFadeColor,
        SMIL2AttrHorzRepeat,
        SMIL2AttrSkip_Content,
        SMIL2AttrStartProgress,
        SMIL2AttrSubtype,
        SMIL2AttrType,
        SMIL2AttrVertRepeat,
    SMIL2ElemVideo, 6, 0,
        SMIL2AttrCollCore,
        SMIL2AttrCollI18N,
        SMIL2AttrCollTiming,
        SMIL2AttrCollTest,
        SMIL2AttrCollSubregion,
        SMIL2AttrCollMediaElement,
    NumSMIL2Elements  // NOTE: THIS SHOULD ALWAYS BE LAST!!!
};

static const BYTE g_RequiredAttr[] =
{
    SMIL2ElemA, 1,
        SMIL2AttrHref,
    SMIL2ElemAnimate, 1,
        SMIL2AttrAttributeName,
    SMIL2ElemAnimateColor, 1,
        SMIL2AttrAttributeName,
    SMIL2ElemMeta, 2,
        SMIL2AttrName,
        SMIL2AttrContent,
    SMIL2ElemSet, 1,
        SMIL2AttrAttributeName,
    SMIL2ElemSmil, 1,
        SMIL2AttrXmlns,
    NumSMIL2Elements // NOTE: THIS SHOULD ALWAYS BE LAST!!!
};

static const BYTE g_LegalContent[] =
{
    SMIL2ElemA, 17,
        SMIL2ElemPar,
        SMIL2ElemSeq,
        SMIL2ElemExcl,
        SMIL2ElemAudio,
        SMIL2ElemVideo,
        SMIL2ElemAnimation,
        SMIL2ElemText,
        SMIL2ElemTextstream,
        SMIL2ElemImg,
        SMIL2ElemRef,
        SMIL2ElemBrush,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemPrefetch,
    SMIL2ElemAnchor, 2,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
    SMIL2ElemAnimate, 0,
    SMIL2ElemAnimateColor, 0,
    SMIL2ElemAnimateMotion, 0,
    SMIL2ElemAnimation, 8,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemAnchor,
        SMIL2ElemArea,
        SMIL2ElemParam,
    SMIL2ElemArea, 2,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
    SMIL2ElemAudio, 8,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemAnchor,
        SMIL2ElemArea,
        SMIL2ElemParam,
    SMIL2ElemBody, 18,
        SMIL2ElemPar,
        SMIL2ElemSeq,
        SMIL2ElemExcl,
        SMIL2ElemAudio,
        SMIL2ElemVideo,
        SMIL2ElemAnimation,
        SMIL2ElemText,
        SMIL2ElemImg,
        SMIL2ElemTextstream,
        SMIL2ElemRef,
        SMIL2ElemBrush,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemPrefetch,
        SMIL2ElemA,
    SMIL2ElemBrush, 8,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemAnchor,
        SMIL2ElemArea,
        SMIL2ElemParam,
    SMIL2ElemCustomAttributes, 1,  // (customTest+)
        SMIL2ElemCustomTest,
    SMIL2ElemCustomTest, 0,
    SMIL2ElemExcl, 19,            // ((par | seq | excl | audio | video | animation | 
        SMIL2ElemPar,            //   text | img | textstream | ref | brush | animate |
        SMIL2ElemSeq,            //   set | animateMotion | animateColor | switch | prefetch |
        SMIL2ElemExcl,           //   a)* | priorityClass+)
        SMIL2ElemAudio,
        SMIL2ElemVideo,
        SMIL2ElemAnimation,
        SMIL2ElemText,
        SMIL2ElemImg,
        SMIL2ElemTextstream,
        SMIL2ElemRef,
        SMIL2ElemBrush,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemPrefetch,
        SMIL2ElemA,
        SMIL2ElemPriorityClass,
    SMIL2ElemHead, 6,            // ( meta*, ((customAttributes), meta*)?, ((metadata),
        SMIL2ElemMeta,           //   meta*)?, ((layout | switch), meta*)?, ((transition+), meta*)? )
        SMIL2ElemCustomAttributes,
        SMIL2ElemMetadata,
        SMIL2ElemLayout,
        SMIL2ElemSwitch,
        SMIL2ElemTransition,
    SMIL2ElemImg, 8,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemAnchor,
        SMIL2ElemArea,
        SMIL2ElemParam,
    SMIL2ElemLayout, 4,
        SMIL2ElemRegion,
        SMIL2ElemTopLayout,
        SMIL2ElemRootLayout,
        SMIL2ElemRegPoint,
    SMIL2ElemMeta, 0,
    SMIL2ElemMetadata, 0,
    SMIL2ElemPar, 18,
        SMIL2ElemPar,
        SMIL2ElemSeq,
        SMIL2ElemExcl,
        SMIL2ElemAudio,
        SMIL2ElemVideo,
        SMIL2ElemAnimation,
        SMIL2ElemText,
        SMIL2ElemImg,
        SMIL2ElemTextstream,
        SMIL2ElemRef,
        SMIL2ElemBrush,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemPrefetch,
        SMIL2ElemA,
    SMIL2ElemParam, 0,
    SMIL2ElemPrefetch, 0,
    SMIL2ElemPriorityClass, 18,
        SMIL2ElemPar,
        SMIL2ElemSeq,
        SMIL2ElemExcl,
        SMIL2ElemAudio,
        SMIL2ElemVideo,
        SMIL2ElemAnimation,
        SMIL2ElemText,
        SMIL2ElemImg,
        SMIL2ElemTextstream,
        SMIL2ElemRef,
        SMIL2ElemBrush,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemPrefetch,
        SMIL2ElemA,
    SMIL2ElemRef, 8,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemAnchor,
        SMIL2ElemArea,
        SMIL2ElemParam,
    SMIL2ElemRegPoint, 0,
    SMIL2ElemRegion, 1,
        SMIL2ElemRegion,
    SMIL2ElemRootLayout, 0,
    SMIL2ElemSeq, 18,
        SMIL2ElemPar,
        SMIL2ElemSeq,
        SMIL2ElemExcl,
        SMIL2ElemAudio,
        SMIL2ElemVideo,
        SMIL2ElemAnimation,
        SMIL2ElemText,
        SMIL2ElemImg,
        SMIL2ElemTextstream,
        SMIL2ElemRef,
        SMIL2ElemBrush,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemPrefetch,
        SMIL2ElemA,
    SMIL2ElemSet, 0,
    SMIL2ElemSmil, 2, // (head?, body?)
        SMIL2ElemHead,
        SMIL2ElemBody,
    SMIL2ElemSwitch, 21,      // ((par | seq | excl | audio | video | animation |
        SMIL2ElemPar,         //   text | img | textstream | ref | brush | animate |
        SMIL2ElemSeq,         //   set | animateMotion | animateColor | switch |
        SMIL2ElemExcl,        //   prefetch | a | area | anchor)* | layout*)
        SMIL2ElemAudio,
        SMIL2ElemVideo,
        SMIL2ElemAnimation,
        SMIL2ElemText,
        SMIL2ElemImg,
        SMIL2ElemTextstream,
        SMIL2ElemRef,
        SMIL2ElemBrush,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemPrefetch,
        SMIL2ElemA,
        SMIL2ElemArea,
        SMIL2ElemAnchor,
        SMIL2ElemLayout,
    SMIL2ElemText, 8,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemAnchor,
        SMIL2ElemArea,
        SMIL2ElemParam,
    SMIL2ElemTextstream, 8,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemAnchor,
        SMIL2ElemArea,
        SMIL2ElemParam,
    SMIL2ElemTopLayout, 1,
        SMIL2ElemRegion,
    SMIL2ElemTransition, 0,
    SMIL2ElemVideo, 8,
        SMIL2ElemAnimate,
        SMIL2ElemSet,
        SMIL2ElemAnimateMotion,
        SMIL2ElemAnimateColor,
        SMIL2ElemSwitch,
        SMIL2ElemAnchor,
        SMIL2ElemArea,
        SMIL2ElemParam,
    NumSMIL2Elements  // NOTE: THIS SHOULD ALWAYS BE LAST!!!
};

static const struct NamespaceTable
{
    SupportedNamespace m_eNamespace;
    const char*        m_pszStr;
} g_NamespaceTable[] =
{
    {NamespaceSystemComponent,              "http://features.real.com/systemComponent/"},
    {NamespaceSizeControl,                  "http://features.real.com/2001/SMIL20/Extensions/sizeControl"},
    {NamespaceAlphaControl,                 "http://features.real.com/2001/SMIL20/Extensions/alphaControl"},
    {NamespaceParam,                        "http://features.real.com/2001/SMIL20/Extensions/param"},
    {NamespaceSendTo,                       "http://features.real.com/2001/SMIL20/Extensions/sendTo"},
    {NamespaceHandledBy,                    "http://features.real.com/2001/SMIL20/Extensions/handledBy"},
    {NamespaceRendererList,                 "http://features.real.com/2001/SMIL20/Extensions/rendererList"},
    {NamespaceAccessErrorBehavior,          "http://features.real.com/2001/SMIL20/Extensions/accessErrorBehavior"},
    {NamespaceAllSMIL2Extensions,           "http://features.real.com/2001/SMIL20/Extensions"},
    {NamespaceSMIL2AccessKeyTiming,         "http://www.w3.org/2001/SMIL20/WD/AccessKeyTiming"},
    {NamespaceSMIL2AudioLayout,             "http://www.w3.org/2001/SMIL20/WD/AudioLayout"},
    {NamespaceSMIL2BasicAnimation,          "http://www.w3.org/2001/SMIL20/WD/BasicAnimation"},
    {NamespaceSMIL2BasicContentControl,     "http://www.w3.org/2001/SMIL20/WD/BasicContentControl"},
    {NamespaceSMIL2BasicInlineTiming,       "http://www.w3.org/2001/SMIL20/WD/BasicInlineTiming"},
    {NamespaceSMIL2BasicLayout,             "http://www.w3.org/2001/SMIL20/WD/BasicLayout"},
    {NamespaceSMIL2BasicLinking,            "http://www.w3.org/2001/SMIL20/WD/BasicLinking"},
    {NamespaceSMIL2BasicMedia,              "http://www.w3.org/2001/SMIL20/WD/BasicMedia"},
    {NamespaceSMIL2BasicTimeContainers,     "http://www.w3.org/2001/SMIL20/WD/BasicTimeContainers"},
    {NamespaceSMIL2BasicTransistions,       "http://www.w3.org/2001/SMIL20/WD/BasicTransistions"},
    {NamespaceSMIL2BrushMedia,              "http://www.w3.org/2001/SMIL20/WD/BrushMedia"},
    {NamespaceSMIL2CustomTestAttributes,    "http://www.w3.org/2001/SMIL20/WD/CustomTestAttributes"},
    {NamespaceSMIL2EventTiming,             "http://www.w3.org/2001/SMIL20/WD/EventTiming"},
    {NamespaceSMIL2ExclTimeContainers,      "http://www.w3.org/2001/SMIL20/WD/ExclTimeContainers"},
    {NamespaceSMIL2FillDefault,             "http://www.w3.org/2001/SMIL20/WD/FillDefault"},
    {NamespaceSMIL2HierarchicalLayout,      "http://www.w3.org/2001/SMIL20/WD/HierarchicalLayout"},
//    {NamespaceSMIL2InlineTransitions,       "http://www.w3.org/2001/SMIL20/WD/InlineTransitions"}, // don't support this
    {NamespaceSMIL2LinkingAttributes,       "http://www.w3.org/2001/SMIL20/WD/LinkingAttributes"},
    {NamespaceSMIL2MediaAccessibility,      "http://www.w3.org/2001/SMIL20/WD/MediaAccessibility"},
    {NamespaceSMIL2MediaClipMarkers,        "http://www.w3.org/2001/SMIL20/WD/MediaClipMarkers"},
    {NamespaceSMIL2MediaClipping,           "http://www.w3.org/2001/SMIL20/WD/MediaClipping"},
    {NamespaceSMIL2MediaDescription,        "http://www.w3.org/2001/SMIL20/WD/MediaDescription"},
    {NamespaceSMIL2MediaMarkerTiming,       "http://www.w3.org/2001/SMIL20/WD/MediaMarkerTiming"},
    {NamespaceSMIL2MediaParam,              "http://www.w3.org/2001/SMIL20/WD/MediaParam"},
    {NamespaceSMIL2Metainformation,         "http://www.w3.org/2001/SMIL20/WD/Metainformation"},
    {NamespaceSMIL2MinMaxTiming,            "http://www.w3.org/2001/SMIL20/WD/MinMaxTiming"},
    {NamespaceSMIL2MultiArcTiming,          "http://www.w3.org/2001/SMIL20/WD/MultiArcTiming"},
    {NamespaceSMIL2MultiWindowLayout,       "http://www.w3.org/2001/SMIL20/WD/MultiWindowLayout"},
    {NamespaceSMIL2ObjectLinking,           "http://www.w3.org/2001/SMIL20/WD/ObjectLinking"},
    {NamespaceSMIL2PrefetchControl,         "http://www.w3.org/2001/SMIL20/WD/PrefetchControl"},
    {NamespaceSMIL2RepeatTiming,            "http://www.w3.org/2001/SMIL20/WD/RepeatTiming"},
    {NamespaceSMIL2RepeatValueTiming,       "http://www.w3.org/2001/SMIL20/WD/RepeatValueTiming"},
    {NamespaceSMIL2RestartDefault,          "http://www.w3.org/2001/SMIL20/WD/RestartDefault"},
    {NamespaceSMIL2RestartTiming,           "http://www.w3.org/2001/SMIL20/WD/RestartTiming"},
    {NamespaceSMIL2SkipContentControl,      "http://www.w3.org/2001/SMIL20/WD/SkipContentControl"},
//    {NamespaceSMIL2SplineAnimation,         "http://www.w3.org/2001/SMIL20/WD/SplineAnimation"}, // don't support this
    {NamespaceSMIL2Structure,               "http://www.w3.org/2001/SMIL20/WD/Structure"},
    {NamespaceSMIL2SyncbaseTiming,          "http://www.w3.org/2001/SMIL20/WD/SyncbaseTiming"},
    {NamespaceSMIL2SyncBehavior,            "http://www.w3.org/2001/SMIL20/WD/SyncBehavior"},
    {NamespaceSMIL2SyncBehaviorDefault,     "http://www.w3.org/2001/SMIL20/WD/SyncBehaviorDefault"},
    {NamespaceSMIL2SyncMaster,              "http://www.w3.org/2001/SMIL20/WD/SyncMaster"},
    {NamespaceSMIL2TimeContainerAttributes, "http://www.w3.org/2001/SMIL20/WD/TimeContainerAttributes"},
    {NamespaceSMIL2TimeManipulations,       "http://www.w3.org/2001/SMIL20/WD/TimeManipulations"},
    {NamespaceSMIL2TransitionModifiers,     "http://www.w3.org/2001/SMIL20/WD/TransitionModifiers"},
    {NamespaceSMIL2WallclockTiming,         "http://www.w3.org/2001/SMIL20/WD/WallclockTiming"},
    {NamespaceXMLEvents,                    "http://www.w3.org/2001/xml-events"},
    {NamespaceNotImplemented,               NULL}
};

#endif /* #if defined(HELIX_FEATURE_SMIL2_VALIDATION) */

#endif  // #ifndef PARSTABL_H
