/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: passivsw.cpp,v 1.3.12.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxwin.h"
#include "hxsite2.h"
// smlrendr
#include "passivsw.h"
// pndebug
#include "hxassert.h"
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static const char HX_THIS_FILE[] = __FILE__;
#endif

CSmilPassiveSiteWatcher::CSmilPassiveSiteWatcher(CSmilPassiveSiteWatcherResponse* pResponse,
                                                 IHXSite*                        pSite)
{
    m_lRefCount = 0;
    m_pResponse = pResponse;
    m_pSite     = pSite;
    if (m_pResponse)
    {
        m_pResponse->AddRef();
    }
    if (m_pSite)
    {
        m_pSite->AddRef();
        // Add ourselves as a passive site watcher
        IHXPassiveSiteWatcher* pWatcher = NULL;
        QueryInterface(IID_IHXPassiveSiteWatcher, (void**) &pWatcher);
        if (pWatcher)
        {
            IHXSite2* pSite2 = NULL;
            m_pSite->QueryInterface(IID_IHXSite2, (void**) &pSite2);
            if (pSite2)
            {
                pSite2->AddPassiveSiteWatcher(pWatcher);
            }
            HX_RELEASE(pSite2);
        }
        HX_RELEASE(pWatcher);
    }
}

CSmilPassiveSiteWatcher::~CSmilPassiveSiteWatcher()
{
    Close();
}

STDMETHODIMP CSmilPassiveSiteWatcher::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (ppvObj)
    {
        if(IsEqualIID(riid, IID_IUnknown))
        {
            AddRef();
            *ppvObj = (IUnknown*) (IHXPassiveSiteWatcher*) this;
        }
        else if(IsEqualIID(riid, IID_IHXPassiveSiteWatcher))
        {
            AddRef();
            *ppvObj = (IHXPassiveSiteWatcher*) this;
        }
        else
        {
            *ppvObj = NULL;
            retVal  = HXR_NOINTERFACE;
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

STDMETHODIMP_(ULONG32) CSmilPassiveSiteWatcher::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}

STDMETHODIMP_(ULONG32) CSmilPassiveSiteWatcher::Release()
{
    if(InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;
    return 0;
}

STDMETHODIMP CSmilPassiveSiteWatcher::PositionChanged(HXxPoint* pPoint)
{
    HX_RESULT retVal = HXR_OK;

    if (m_pResponse)
    {
        retVal = m_pResponse->SitePositionChanged(m_pSite, pPoint);
    }

    return retVal;
}

STDMETHODIMP CSmilPassiveSiteWatcher::SizeChanged(HXxSize* pSize)
{
    HX_RESULT retVal = HXR_OK;

    if (m_pResponse)
    {
        retVal = m_pResponse->SiteSizeChanged(m_pSite, pSize);
    }

    return retVal;
}

STDMETHODIMP CSmilPassiveSiteWatcher::Close()
{
    HX_RESULT retVal = HXR_OK;

    if (m_pSite)
    {
        // Release ourselves as a passive site watcher
        IHXPassiveSiteWatcher* pWatcher = NULL;
        QueryInterface(IID_IHXPassiveSiteWatcher, (void**) &pWatcher);
        if (pWatcher)
        {
            IHXSite2* pSite2 = NULL;
            m_pSite->QueryInterface(IID_IHXSite2, (void**) &pSite2);
            if (pSite2)
            {
                pSite2->RemovePassiveSiteWatcher(pWatcher);
            }
            HX_RELEASE(pSite2);
        }
        HX_RELEASE(pWatcher);
    }
    HX_RELEASE(m_pSite);
    if (m_pResponse)
    {
        m_pResponse->Release();
        m_pResponse = NULL;
    }

    return retVal;
}

