/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: layevent.h,v 1.4.12.1 2004/07/09 01:58:01 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef LAYEVENT_H
#define LAYEVENT_H

// Forward declarations
typedef _INTERFACE IHXSite          IHXSite;
typedef _INTERFACE IHXErrorMessages IHXErrorMessages;
class CSmilDocumentRenderer;
class CHXString;
#if defined(HELIX_FEATURE_SMIL2_ANIMATION)
class CSmilAnimateElement;
#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */
class CSmilParser;
struct SMILPlayToAssoc;
struct SMILSiteInfo;

class CSmilLayoutEvent
{
public:
    CSmilLayoutEvent(UINT16 uGroupIndex,
                     UINT32 ulEventTime,
                     BOOL   bIgnorEvent);
    virtual ~CSmilLayoutEvent();

    virtual HX_RESULT   handleEvent(UINT32 ulTime) = 0;
    virtual IHXSite*   getRegionSite() = 0;
    virtual IHXSite*   getRendererSite() = 0;
    virtual void        setHandledFlag(BOOL bFlag) {}
    virtual BOOL        getHandledFlag()           { return FALSE; }
    const char*         getEventTypeName();
    BOOL                IsShowOrHideEvent() { return ((m_type == eShowSite ||
                                      m_type == eHideSite) ? TRUE : FALSE); }

    enum EventType
    {
        eShowSite,
        eHideSite, 
        eBeginTransition, 
        eEndTransition,
        eAnimate,
        eNumEventTypes // This should always be last
    } m_type;

    static const char* const m_pszEventTypeName[];

    UINT32      m_ulEventTime;
    UINT16      m_uGroupIndex;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD m_bOnlyHideSite : 1;
    HX_BITFIELD m_bIgnorEvent : 1;
};

class CSmilShowSiteEvent: public CSmilLayoutEvent
{
public:
    CSmilShowSiteEvent(UINT16                 uGroupIndex,
                       UINT32                 ulEventTime,
                       IHXSite*              pSite,
                       IHXSite*              pRegionSite,
                       BOOL                   bShowSite,
                       BOOL                   bIgnorEvent = FALSE,
                       CSmilDocumentRenderer* pDoc = NULL,
                       const char*            pszMediaID = NULL,
                       const char*            pszRegionID = NULL,
                       ShowBackground         eShowBackground = ShowBackgroundAlways);
    virtual ~CSmilShowSiteEvent();

    // Required CSmilLayoutEvent methods
    virtual HX_RESULT   handleEvent(UINT32 ulTime);
    virtual IHXSite*   getRegionSite();
    virtual IHXSite*   getRendererSite();
    // CSmilShowSiteEvent methods
    BOOL                getShowSite();
    const char*         getMediaID();
    const char*         getRegionID();
private:
    IHXSite*              m_pRegionSite;
    IHXSite*              m_pSite;
    CSmilDocumentRenderer* m_pDoc;
    CHXString              m_MediaID;
    CHXString              m_RegionID;
    ShowBackground         m_eShowBackground;
    IHXErrorMessages*     m_pErrorMessages;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD            m_bShowSite : 1;
};

#if defined(HELIX_FEATURE_SMIL2_TRANSITIONS)

class CSmilTransitionEvent: public CSmilLayoutEvent
{
public:
    CSmilTransitionEvent(UINT32                 ulEventTime,
                         SMILPlayToAssoc*       pAssoc,
                         SMILSiteInfo*          pSiteInfo,
                         BOOL                   bBeginTransition,
                         CSmilDocumentRenderer* pRenderer);
    CSmilTransitionEvent(UINT32                 ulEventTime,
                         SMILPlayToAssoc*       pAssoc,
                         IHXSite*              pSite,
                         BOOL                   bBeginTransition,
                         CSmilDocumentRenderer* pRenderer);
    virtual ~CSmilTransitionEvent();

    virtual HX_RESULT   handleEvent(UINT32 ulTime);
    virtual IHXSite*   getRegionSite();
    virtual IHXSite*   getRendererSite();
private:
    CSmilDocumentRenderer* m_pDocRenderer;
    SMILPlayToAssoc*       m_pPlayToAssoc;
    SMILSiteInfo*          m_pSiteInfo;
    IHXSite*              m_pSite;
};

#endif /* #if defined(HELIX_FEATURE_SMIL2_TRANSITIONS) */

#if defined(HELIX_FEATURE_SMIL2_ANIMATION)

class CSmilAnimateEvent: public CSmilLayoutEvent
{
public:
    CSmilAnimateEvent(UINT16                 uGroupIndex,
                      UINT32                 ulEventTime,
                      BOOL                   bIgnorEvent,
                      CSmilAnimateElement*   pElement,
                      CSmilDocumentRenderer* pDocRenderer,
                      CSmilParser*           pParser);
    CSmilAnimateEvent(const CSmilAnimateEvent& rEvent);
    virtual ~CSmilAnimateEvent();

    virtual HX_RESULT   handleEvent(UINT32 ulTime);
    virtual IHXSite*   getRegionSite ();
    virtual IHXSite*   getRendererSite();
    virtual void        setHandledFlag(BOOL bFlag) { m_bHandled = bFlag; }
    virtual BOOL        getHandledFlag()           { return m_bHandled;  }

    BOOL                isSameElement(CSmilAnimateElement* pAnim);
    BOOL                hasEventBasedBegin() const { return m_bEventBasedBegin; }
private:
    CSmilAnimateElement*   m_pElement;
    CSmilDocumentRenderer* m_pDocRenderer;
    CSmilParser*           m_pSmilParser;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD            m_bEventBasedBegin : 1;
    HX_BITFIELD            m_bHandled : 1;
};

#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */

#endif
