/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smlerror.cpp,v 1.2.12.2 2004/07/13 18:24:26 bobclark Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include <stdio.h>

#include "hxtypes.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "hxerror.h"
#include "hxxres.h"
#include "hxxrsmg.h"

#include "hxwintyp.h"
#include "hxslist.h"
#include "hxstring.h"
#include "hxstack.h"
#include "hxstrutl.h"

#include "xmlres.h"
#include "smilres.h"
#include "xmlreslt.h"
#include "hxxml.h"

#include "hxxmlprs.h"
#include "sm1parse.h"
#include "sm1error.h"

#ifdef _WINDOWS
extern HINSTANCE g_hInstance;
#endif

const int MAX_ERROR_STRING = 1024;

CSmil1ErrorHandler::CSmil1ErrorHandler(IUnknown* pContext):
    m_pContext(pContext)
{
    if(m_pContext)
    {
	m_pContext->AddRef();
    }
}

CSmil1ErrorHandler::~CSmil1ErrorHandler()
{
    HX_RELEASE(m_pContext);
}

void
CSmil1ErrorHandler::Report(const char* pErrorText)
{
    IHXErrorMessages* pErrorMessage = 0;

    if(m_pContext &&
	pErrorText &&
	HXR_OK == m_pContext->QueryInterface(
	IID_IHXErrorMessages, (void**)&pErrorMessage))
    {
	pErrorMessage->Report(HXLOG_ERR, HXR_BAD_FORMAT,
	    0, pErrorText, NULL);
        HX_RELEASE(pErrorMessage);
    }
}

HX_RESULT
CSmil1ErrorHandler::GetErrorString(UINT32 ulErrorStringID,
				  char* pErrorStringBuffer)
{
    HX_RESULT rc = HXR_FAIL;
    const char* pErrorString = NULL;

    IHXExternalResourceManager* pResMgr = NULL;
    if(HXR_OK == m_pContext->QueryInterface(IID_IHXExternalResourceManager,
					    (void**)&pResMgr))
    {
	IHXExternalResourceReader* pResRdr = NULL;
	if(HXR_OK == pResMgr->CreateExternalResourceReader(
	    				CORE_RESOURCE_SHORT_NAME, pResRdr))
	{
#ifdef _WINDOWS
	    char szDLLPath[1024]; /* Flawfinder: ignore */
	    GetModuleFileName((HMODULE)g_hInstance, szDLLPath, sizeof(szDLLPath));
	    pResRdr->SetDefaultResourceFile(szDLLPath);
#endif
	    IHXXResource* pRes = pResRdr->GetResource(HX_RT_STRING,
							ulErrorStringID);
	    if(pRes)
	    {
		strcpy(pErrorStringBuffer, (const char*)pRes->ResourceData()); /* Flawfinder: ignore */
		rc = HXR_OK;
	    }
	    HX_RELEASE(pRes);
	    HX_RELEASE(pResRdr);
	}
	HX_RELEASE(pResMgr);
    }

    return rc;
}


//     CSmil1XMLSyntaxErrorHandler methods

static const struct
{
    UINT32	    m_ulErrorTag;
    UINT32	    m_ulErrorStringID;
} XMLSyntaxErrorStringTable[] =
{
    { HXR_XML_GENERALERROR,		    IDS_ERR_XML_GENERALERROR },
    { HXR_XML_BADENDTAG,		    IDS_ERR_XML_BADENDTAG },
    { HXR_XML_NOCLOSE,			    IDS_ERR_XML_NOCLOSE },
    { HXR_XML_BADATTRIBUTE,		    IDS_ERR_XML_BADATTRIBUTE },
    { HXR_XML_NOVALUE,			    IDS_ERR_XML_MISSINGQUOTE },
    { HXR_XML_MISSINGQUOTE,		    IDS_ERR_XML_MISSINGQUOTE },
    { HXR_XML_NOTAGTYPE,		    IDS_ERR_XML_NOTAGTYPE },
    { HXR_XML_ILLEGALID,		    IDS_ERR_XML_ILLEGALID },
    { HXR_XML_DUPATTRIBUTE,		    IDS_ERR_XML_DUPATTRIBUTE },
    { HXR_XML_COMMENT_B4_PROCINST,	    IDS_ERR_XML_COMMENT_B4_PROCINST },

    { HXR_XML_SYNTAX,			    IDS_ERR_XML_SYNTAX },
    { HXR_XML_NO_ELEMENTS,		    IDS_ERR_XML_NO_ELEMENTS },
// removed INVALID_TOKEN, replaced with specific errors below
//    { HXR_XML_INVALID_TOKEN,		    IDS_ERR_XML_INVALID_TOKEN },
    { HXR_XML_UNCLOSED_TOKEN,		    IDS_ERR_XML_UNCLOSED_TOKEN	 },
    { HXR_XML_PARTIAL_CHAR,		    IDS_ERR_XML_PARTIAL_CHAR },
    { HXR_XML_TAG_MISMATCH,		    IDS_ERR_XML_TAG_MISMATCH },
// use DUPATTRIBUTE instead
//    { HXR_XML_DUPLICATE_ATTRIBUTE,	    IDS_ERR_XML_DUPLICATE_ATTRIBUTE },
    { HXR_XML_JUNK_AFTER_DOC_ELEMENT,	    IDS_ERR_XML_JUNK_AFTER_DOC_ELEMENT },
    { HXR_XML_PARAM_ENTITY_REF,		    IDS_ERR_XML_PARAM_ENTITY_REF },
    { HXR_XML_UNDEFINED_ENTITY,		    IDS_ERR_XML_UNDEFINED_ENTITY },
    { HXR_XML_RECURSIVE_ENTITY_REF,	    IDS_ERR_XML_RECURSIVE_ENTITY_REF },
    { HXR_XML_ASYNC_ENTITY,		    IDS_ERR_XML_ASYNC_ENTITY },
    { HXR_XML_BAD_CHAR_REF,		    IDS_ERR_XML_BAD_CHAR_REF },
    { HXR_XML_BINARY_ENTITY_REF,	    IDS_ERR_XML_BINARY_ENTITY_REF },
    { PNR_XML_ATTRIBUTE_EXTEHXAL_ENTITY_REF, IDS_ERR_XML_ATTRIBUTE_EXTERNAL_ENTITY_REF },
    { HXR_XML_MISPLACED_XML_PI,		    IDS_ERR_XML_MISPLACED_XML_PI },
    { HXR_XML_UNKNOWN_ENCODING,		    IDS_ERR_XML_UNKNOWN_ENCODING },
    { HXR_XML_INCORRECT_ENCODING,	    IDS_ERR_XML_INCORRECT_ENCODING },
    { HXR_XML_UNCLOSED_CDATA_SECTION,	    IDS_ERR_XML_UNCLOSED_CDATA_SECTION },
    { PNR_XML_EXTEHXAL_ENTITY_HANDLING,		IDS_ERR_XML_EXTERNAL_ENTITY_HANDLING },
    { HXR_XML_NOT_STANDALONE,		    IDS_ERR_XML_NOT_STANDALONE },
    { HXR_XML_INVALID_NAME,		    IDS_ERR_XML_INVALID_NAME },
    { HXR_XML_INVALID_CHAR_IN_DOC,	    IDS_ERR_XML_INVALID_CHAR_IN_DOC },
    { HXR_XML_TWO_DASHES_NOT_ALLOWED_IN_COMMENT, IDS_ERR_XML_TWO_DASHES_NOT_ALLOWED_IN_COMMENT },
    { HXR_XML_INVALID_DECL,		    IDS_ERR_XML_INVALID_DECL },
    { HXR_XML_INVALID_PI,		    IDS_ERR_XML_INVALID_PI },
    { HXR_XML_INVALID_PI_TARGET,	    IDS_ERR_XML_INVALID_PI_TARGET },
    { HXR_XML_INVALID_CDATA,		    IDS_ERR_XML_INVALID_CDATA },
    { HXR_XML_NO_CLOSING_GT,		    IDS_ERR_XML_NO_CLOSING_GT },
    { HXR_XML_INVALID_HEX_CHAR_REF,	    IDS_ERR_XML_INVALID_HEX_CHAR_REF },
    { HXR_XML_INVALID_CHAR_REF,		    IDS_ERR_XML_INVALID_CHAR_REF },
    { HXR_XML_INVALID_REF,		    IDS_ERR_XML_INVALID_REF },
    { HXR_XML_MISSING_EQUALS,		    IDS_ERR_XML_MISSING_EQUALS },
// use MISSINGQUOTE instead
//    { HXR_XML_MISSING_QUOT_APOS,	    IDS_ERR_XML_MISSING_QUOT_APOS },
    { HXR_XML_MISSING_REQ_SPACE,	    IDS_ERR_XML_MISSING_REQ_SPACE },
    { HXR_XML_LT_NOT_ALLOWED,		    IDS_ERR_XML_LT_NOT_ALLOWED },
    { HXR_XML_EXPECTED_GT,		    IDS_ERR_XML_EXPECTED_GT },
    { HXR_XML_INVALID_GT_AFFT_2_RSQB_IN_CONTENT, IDS_ERR_XML_INVALID_GT_AFFT_2_RSQB_IN_CONTENT },
    { HXR_XML_INVALID_COMMENT,		    IDS_ERR_XML_INVALID_COMMENT }
};

CSmil1XMLSyntaxErrorHandler::CSmil1XMLSyntaxErrorHandler(IUnknown* pContext):
    CSmil1ErrorHandler(pContext)
{
}

CSmil1XMLSyntaxErrorHandler::~CSmil1XMLSyntaxErrorHandler()
{
}

void
CSmil1XMLSyntaxErrorHandler::GetReportString(UINT32 ulErrorID,
					    char* pErrorString)
{
    UINT32 ulErrorStringID = XMLSyntaxErrorStringTable[0].m_ulErrorStringID;

    for (int i = 0; 
	i < sizeof(XMLSyntaxErrorStringTable) / 
	    sizeof(XMLSyntaxErrorStringTable[0]); 
	++i)
    {
	if(XMLSyntaxErrorStringTable[i].m_ulErrorTag == ulErrorID)
	{
	    ulErrorStringID = XMLSyntaxErrorStringTable[i].m_ulErrorStringID;
	    break;
	}
    }

    if (GetErrorString(ulErrorStringID, pErrorString) != HXR_OK)
    {
	strcpy(pErrorString, "Error Strings can not be loaded %d: %s\n"); /* Flawfinder: ignore */
    }
}


void
CSmil1XMLSyntaxErrorHandler::ReportError(UINT32 ulErrorID,
					const char* pErrorText,
					UINT32 ulLineNumber)
{
    UINT32 ulErrorStringID = XMLSyntaxErrorStringTable[0].m_ulErrorStringID;

    for (int i = 0; 
	i < sizeof(XMLSyntaxErrorStringTable) / 
	    sizeof(XMLSyntaxErrorStringTable[0]); 
	++i)
    {
	if(XMLSyntaxErrorStringTable[i].m_ulErrorTag == ulErrorID)
	{
	    ulErrorStringID = XMLSyntaxErrorStringTable[i].m_ulErrorStringID;
	    break;
	}
    }

    char szErrorString[MAX_ERROR_STRING]; /* Flawfinder: ignore */
    if(HXR_OK == GetErrorString(ulErrorStringID,
				szErrorString))
    {
	CHXString errorText;
	errorText.Format(szErrorString, ulLineNumber, NULL==pErrorText?"(unknown)":pErrorText);
	Report(errorText);
    }
}


//  CSmil1SMILSyntaxErrorHandler methods

static const struct
{
    SMILErrorTag    m_ulErrorTag;
    UINT32	    m_ulErrorStringID;
} SMILSyntaxErrorStringTable[] =
{
    { SMILErrorGeneralError,		    IDS_ERR_SMIL_GENERALERROR },
    { SMILErrorBadXML,			    IDS_ERR_SMIL_BADXML },
    { SMILErrorNotSMIL,			    IDS_ERR_SMIL_NOTSMIL },
    { SMILErrorDuplicateID,		    IDS_ERR_SMIL_DUPLICATEID },
    { SMILErrorNonexistentID,		    IDS_ERR_SMIL_NONEXISTENTID },
    { SMILErrorNoBodyTag,		    IDS_ERR_SMIL_NOBODYTAG },
    { SMILErrorNoBodyElements,		    IDS_ERR_SMIL_NOBODYELEMENTS },
    { SMILErrorUnrecognizedTag,		    IDS_ERR_SMIL_UNRECOGNIZEDTAG },
    { SMILErrorUnrecognizedAttribute,	    IDS_ERR_SMIL_UNRECOGNIZEDATTRIBUTE },
    { SMILErrorUnexpectedTag,		    IDS_ERR_SMIL_UNEXPECTEDTAG },
    { SMILErrorBadDuration,		    IDS_ERR_SMIL_BADDURATION },
    { SMILErrorBadAttribute,		    IDS_ERR_SMIL_BADATTRIBUTE },
    { SMILErrorBadFragment,		    IDS_ERR_SMIL_BADFRAGMENT },
    { SMILErrorRequiredAttributeMissing,    IDS_ERR_SMIL_REQUIREDATTRIBUTEMISSING },
    { SMILErrorSyncAttributeMissing,	    IDS_ERR_SMIL_SYNCATTRIBUTEOUTOFSCOPE },
    { SMILErrorUnexpectedContent,	    IDS_ERR_SMIL_UNEXPECTEDCONTENT },
    { SMILErrorSMIL10Document,		    IDS_ERR_SMIL_SMIL10DOCUMENT },
    { SMILErrorIndefiniteNotSupported,	    IDS_ERR_SMIL_INDEFINITENOTSUPPORTED },
    { SMILErrorMetaDatatype,		    IDS_ERR_SMIL_METADATATYPE },
    { SMILErrorRootLayoutHeightWidthRequired,    IDS_ERR_SMIL_ROOTHEIGHTWIDTHREQUIRED },
    { SMILErrorBadID,			    IDS_ERR_SMIL_BADID },
    { SMILErrorNoSources,		    IDS_ERR_SMIL_NOSOURCES }
};

CSmil1SMILSyntaxErrorHandler::CSmil1SMILSyntaxErrorHandler(IUnknown* pContext):
    CSmil1ErrorHandler(pContext)
{
}

CSmil1SMILSyntaxErrorHandler::~CSmil1SMILSyntaxErrorHandler()
{
}

void
CSmil1SMILSyntaxErrorHandler::GetReportString(SMILErrorTag tag,
					    char* pErrorString)
{
    UINT32 ulErrorStringID = SMILSyntaxErrorStringTable[0].m_ulErrorStringID;

    for (int i = 0; 
	i < sizeof(SMILSyntaxErrorStringTable) / 
	    sizeof(SMILSyntaxErrorStringTable[0]); 
	++i)
    {
	if(SMILSyntaxErrorStringTable[i].m_ulErrorTag == tag)
	{
	    ulErrorStringID = SMILSyntaxErrorStringTable[i].m_ulErrorStringID;
	    break;
	}
    }

    
    if (GetErrorString(ulErrorStringID, pErrorString) != HXR_OK)
    {
	strcpy(pErrorString, "Error Strings can not be loaded %d: %s\n"); /* Flawfinder: ignore */
    }
}

void
CSmil1SMILSyntaxErrorHandler::ReportError(SMILErrorTag tag,
					const char* pErrorText,
					UINT32 ulLineNumber)
{
    UINT32 ulErrorStringID = SMILSyntaxErrorStringTable[0].m_ulErrorStringID;

    for (int i = 0; 
	i < sizeof(SMILSyntaxErrorStringTable) / 
	    sizeof(SMILSyntaxErrorStringTable[0]); 
	++i)
    {
	if(SMILSyntaxErrorStringTable[i].m_ulErrorTag == tag)
	{
	    ulErrorStringID = SMILSyntaxErrorStringTable[i].m_ulErrorStringID;
	    break;
	}
    }

    char szErrorString[MAX_ERROR_STRING]; /* Flawfinder: ignore */
    if(HXR_OK == GetErrorString(ulErrorStringID,
				szErrorString))
    {
	CHXString errorText;
	errorText.Format(szErrorString, ulLineNumber, NULL==pErrorText?"(unknown)":pErrorText);
	Report(errorText);
    }
}
