/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxcpngff.cpp,v 1.1.26.1 2004/07/09 01:51:04 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "hxplugn.h"
#include "ihxpckts.h"
#include "hxver.h"
#include "hxcomm.h"

// pnmisc
#include "baseobj.h"
#include "unkimp.h"

// pncont
#include "hxslist.h"
#include "hxstring.h"
#include "hxmap.h"
#include "carray.h"

// pxcomlib
#include "gstring.h"
#include "pxrndcod.h"
#include "pxffmcod.h"
#include "nestbuff.h"
#include "pxutil.h"
#include "pxmapmgr.h"
#include "pxparse.h"

// libpng
#include "png.h"

// pxpnglib
#include "pxpngdec.h"

// pxcpng
#include "pxcpngff.h"
#include "rppngdll.ver"

// pndebug
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE     
static char HX_THIS_FILE[] = __FILE__;
#endif

const char*  CRealPixPNGFileFormatCodec::m_pszDescription      = "Helix RealPix PNG File Format Codec Plugin";
const char*  CRealPixPNGFileFormatCodec::m_pszCopyright        = HXVER_COPYRIGHT;
const char*  CRealPixPNGFileFormatCodec::m_pszMoreInfoURL      = HXVER_MOREINFO;
const char*  CRealPixPNGFileFormatCodec::m_ppszFileExtension[] = {"png", NULL};
const char*  CRealPixPNGFileFormatCodec::m_ppszFileMimeType[]  = {"image/png", NULL};
const char*  CRealPixPNGFileFormatCodec::m_pszStreamMimeType   = "image/vnd.rn-realpix.png";
const UINT32 CRealPixPNGFileFormatCodec::m_ulStreamVersion     = HX_ENCODE_PROD_VERSION(0, 0, 0, 0);

CRealPixPNGFileFormatCodec::CRealPixPNGFileFormatCodec()
{
    m_lRefCount           = 0;
    m_pContext            = NULL;
    m_pCommonClassFactory = NULL;
    m_pMapManager         = NULL;
}

CRealPixPNGFileFormatCodec::~CRealPixPNGFileFormatCodec()
{
    ReleaseAllSessions();
    HX_RELEASE(m_pContext);
    HX_RELEASE(m_pCommonClassFactory);
    HX_RELEASE(m_pMapManager);
}

STDMETHODIMP CRealPixPNGFileFormatCodec::QueryInterface(REFIID riid, void** ppvObj)
{
    HX_RESULT retVal = HXR_OK;

    if (ppvObj)
    {
        // Set default
        *ppvObj = NULL;
        // Check for IID type
        if (IsEqualIID(riid, IID_IUnknown))
        {
            AddRef();
            *ppvObj = (IUnknown*) (IHXPlugin*) this;
        }
        else if (IsEqualIID(riid, IID_IHXPlugin))
        {
            AddRef();
            *ppvObj = (IHXPlugin*) this;
        }
        else if (IsEqualIID(riid, IID_IHXRealPixFileFormatCodec))
        {
            AddRef();
            *ppvObj = (IHXRealPixFileFormatCodec*) this;
        }
        else
        {
            retVal = HXR_NOINTERFACE;
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

STDMETHODIMP_(UINT32) CRealPixPNGFileFormatCodec::AddRef()
{
    return InterlockedIncrement(&m_lRefCount);
}


STDMETHODIMP_(UINT32) CRealPixPNGFileFormatCodec::Release()
{
    if (InterlockedDecrement(&m_lRefCount) > 0)
    {
        return m_lRefCount;
    }

    delete this;

    return 0;
}

STDMETHODIMP CRealPixPNGFileFormatCodec::GetPluginInfo(REF(BOOL)        bMultipleLoad,
                                                       REF(const char*) pDescription,
                                                       REF(const char*) pCopyright,
                                                       REF(const char*) pMoreInfoURL,
                                                       REF(ULONG32)     ulVersionNumber)
{
    bMultipleLoad   = TRUE;
    pDescription    = m_pszDescription;
    pCopyright      = m_pszCopyright;
    pMoreInfoURL    = m_pszMoreInfoURL;
    ulVersionNumber = TARVER_ULONG32_VERSION;

    return HXR_OK;
}

STDMETHODIMP CRealPixPNGFileFormatCodec::InitPlugin(IUnknown* pContext)
{
    HX_RESULT retVal = HXR_OK;

    if (pContext)
    {
        // Save a copy of the context
        HX_RELEASE(m_pContext);
        m_pContext = pContext;
        m_pContext->AddRef();

        // Get an IHXCommonClassFactory interface
        HX_RELEASE(m_pCommonClassFactory);
        retVal = m_pContext->QueryInterface(IID_IHXCommonClassFactory,
                                            (void**) &m_pCommonClassFactory);
        if (SUCCEEDED(retVal))
        {
            // Create a map manager
            HX_RELEASE(m_pMapManager);
            m_pMapManager = new PXMapManager();
            if (m_pMapManager)
            {
                m_pMapManager->AddRef();
            }
            else
            {
                retVal = HXR_OUTOFMEMORY;
            }
        }
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

STDMETHODIMP CRealPixPNGFileFormatCodec::GetFileFormatCodecInfo(REF(const char**) rppszFileExtension,
                                                                REF(const char**) rppszFileMimeType,
                                                                REF(const char*)  rpszStreamMimeType,
                                                                REF(UINT32)       rulStreamVersion,
                                                                REF(UINT32)       rulMaxPerImageOpaque,
                                                                REF(UINT32)       rulMaxPerPacketOpaque)
{
    rppszFileExtension    = m_ppszFileExtension;
    rppszFileMimeType     = m_ppszFileMimeType;
    rpszStreamMimeType    = m_pszStreamMimeType;
    rulStreamVersion      = m_ulStreamVersion;
    rulMaxPerImageOpaque  = 0;
    rulMaxPerPacketOpaque = 4;

    return HXR_OK;
}

STDMETHODIMP_(BOOL) CRealPixPNGFileFormatCodec::ValidInputData(IHXBuffer* pBuffer)
{
    return PXPNGDecode::ValidInputData(pBuffer);
}

STDMETHODIMP CRealPixPNGFileFormatCodec::ParseImage(IHXBuffer*      pBuffer,
                                                    REF(UINT32)      rulNumPackets,
                                                    REF(IHXValues*) rpParam,
                                                    REF(UINT32)      rulSessionHandle)
{
    HX_RESULT retVal = HXR_OK;

    if (pBuffer)
    {
        // Compute the maximum number of packets
        UINT32 ulMaxNumPackets = (pBuffer->GetSize() + kMinPacketSize - 1) / kMinPacketSize;

        // Create a PXParseSession object
        PXParseSession* pSession = new PXParseSession();
        if (pSession)
        {
            // AddRef the object
            pSession->AddRef();
            // Init the size
            retVal = pSession->InitSize(ulMaxNumPackets);
            if (SUCCEEDED(retVal))
            {
                // Parse the image, putting buffers into the session object
                HXxSize rImageDim;
                retVal = ParseBuffer(pBuffer, pSession, rImageDim);
                if (SUCCEEDED(retVal))
                {
                    // Now we can reduce our size to the number of packets we actually have
                    retVal = pSession->SetSize(pSession->GetNumPackets());
                    if (SUCCEEDED(retVal))
                    {
                        // Add the session to the map
                        retVal = m_pMapManager->AddEntry((void*) pSession, rulSessionHandle);
                        if (SUCCEEDED(retVal))
                        {
                            // AddRef the session since it's in the map
                            pSession->AddRef();
                            // Create an IHXValues object
                            IHXValues* pParam = NULL;
                            retVal             = m_pCommonClassFactory->CreateInstance(CLSID_IHXValues,
                                                                                       (void**) &pParam);
                            if (SUCCEEDED(retVal))
                            {
                                // Set properties in the IHXValues
                                pParam->SetPropertyULONG32("MaxPacketSize",    pSession->GetMaxPacketSize());
                                pParam->SetPropertyULONG32("MinPacketSize",    pSession->GetMinPacketSize());
                                pParam->SetPropertyULONG32("TotalBytes",       pSession->GetTotalBytes());
                                pParam->SetPropertyULONG32("TotalReqBytes",    pSession->GetTotalRequiredBytes());
                                pParam->SetPropertyULONG32("TotalNonReqBytes", pSession->GetTotalNonRequiredBytes());
                                pParam->SetPropertyULONG32("ImageWidth",       (UINT32) rImageDim.cx);
                                pParam->SetPropertyULONG32("ImageHeight",      (UINT32) rImageDim.cy);
                                // Set the outgoing parameters
                                rulNumPackets = pSession->GetNumPackets();
                                HX_RELEASE(rpParam);
                                rpParam = pParam;
                                rpParam->AddRef();
                            }
                            HX_RELEASE(pParam);
                        }
                    }
                }
            }
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
        HX_RELEASE(pSession);
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

STDMETHODIMP CRealPixPNGFileFormatCodec::GetImagePacket(UINT32           ulSessionHandle,
                                                        UINT32           ulPacketNum,
                                                        REF(IHXBuffer*) rpPacketBuffer,
                                                        REF(IHXBuffer*) rpOpaquePacketData,
                                                        REF(BOOL)        rbRequired)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pMapManager)
    {
        PXParseSession* pSession = NULL;
        retVal                   = m_pMapManager->GetEntry(ulSessionHandle, (void**) &pSession);
        if (SUCCEEDED(retVal))
        {
            // Get the packet from the session
            retVal = pSession->GetPacket(ulPacketNum,
                                         rpPacketBuffer,
                                         rpOpaquePacketData,
                                         rbRequired);
        }
    }

    return retVal;
}

STDMETHODIMP CRealPixPNGFileFormatCodec::ReleaseImage(UINT32 ulSessionHandle)
{
    HX_RESULT retVal = HXR_FAIL;

    if (m_pMapManager)
    {
        PXParseSession* pSession = NULL;
        retVal                   = m_pMapManager->DeleteEntry(ulSessionHandle, (void**) &pSession);
        HX_RELEASE(pSession);
    }

    return retVal;
}

HX_RESULT STDAPICALLTYPE CRealPixPNGFileFormatCodec::HXCreateInstance(IUnknown** ppIUnknown)
{
    HX_RESULT retVal = HXR_OK;

    if (ppIUnknown)
    {
        // Create file format codec
        CRealPixPNGFileFormatCodec* pCodec = new CRealPixPNGFileFormatCodec();
        if (pCodec)
        {
            // QI for IUnknown
            retVal = pCodec->QueryInterface(IID_IUnknown, (void**) ppIUnknown);
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
        if (FAILED(retVal))
        {
            HX_DELETE(pCodec);
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

HX_RESULT CRealPixPNGFileFormatCodec::ParseBuffer(IHXBuffer*     pBuffer,
                                                  PXParseSession* pSession,
                                                  REF(HXxSize)    rImageDim)
{
    HX_RESULT retVal = HXR_OK;

    if (pBuffer && pSession)
    {
        UINT32 ulWidth  = 0;
        UINT32 ulHeight = 0;
        if (PXPNGDecode::GetIHDRInfo(pBuffer, ulWidth, ulHeight))
        {
            rImageDim.cx = (INT32) ulWidth;
            rImageDim.cy = (INT32) ulHeight;
        }

        // Find the beginning of the IDAT chunk
        UINT32    ulOffset  = 0;
        UINT32    ulBytes   = 0;
        BOOL      bComplete = FALSE;
        BOOL      bPresent  = PXPNGDecode::IsChunkPresent(pBuffer,
                                                          0x49444154, // IDAT chunk
                                                          ulOffset,
                                                          ulBytes,
                                                          bComplete);
        if (bPresent && bComplete)
        {
            UINT32 ulFirstBufferSize = 0;
            if (ulOffset + kMinIDATBytes > kDefaultPacketSize)
            {
                // Since the size of the all the chunks before the IDAT is
                // greater than the ideal packet size, then we'll just do
                // the minimum here.
                ulFirstBufferSize   = ulOffset + kMinIDATBytes;
            }
            else
            {
                // Since the size of all the chunks before the IDAT is
                // LESS than the ideal packet size, we'll allow some of
                // the IDAT chunk into the first packet.
                ulFirstBufferSize = kDefaultPacketSize;
                if (ulFirstBufferSize > pBuffer->GetSize())
                {
                    ulFirstBufferSize = pBuffer->GetSize();
                }
            }
            // Add the first packet buffer
            UINT32 ulNumBuffers = 1;
            // Add all the rest of the packets past the first
            ulNumBuffers       += (pBuffer->GetSize() - ulFirstBufferSize + kDefaultPacketSize - 1) /
                                  kDefaultPacketSize;
            // Now run through and create the buffers
            UINT32 ulCurOffset = 0;
            UINT32 ulCurSize   = ulFirstBufferSize;
            for (UINT32 i = 0; i < ulNumBuffers && SUCCEEDED(retVal); i++)
            {
                // Create a nested buffer
                CHXNestedBuffer* pNest = NULL;
                retVal                 = CHXNestedBuffer::CreateObject(&pNest);
                if (SUCCEEDED(retVal))
                {
                    // AddRef the object
                    pNest->AddRef();
                    // Init the nested buffer
                    retVal = pNest->Init(pBuffer, ulCurOffset, ulCurSize);
                    if (SUCCEEDED(retVal))
                    {
                        // QI for IHXBuffer
                        IHXBuffer* pData = NULL;
                        retVal            = pNest->QueryInterface(IID_IHXBuffer,
                                                                  (void**) &pData);
                        if (SUCCEEDED(retVal))
                        {
                            // Update the current offset and size
                            ulCurOffset += ulCurSize;
                            ulCurSize    = kDefaultPacketSize;
                            if (ulCurOffset + ulCurSize > pBuffer->GetSize())
                            {
                                ulCurSize = pBuffer->GetSize() - ulCurOffset;
                            }
                            // Create the opaque buffer
                            IHXBuffer* pOpaque = NULL;
                            retVal = m_pCommonClassFactory->CreateInstance(CLSID_IHXBuffer,
                                                                           (void**) &pOpaque);
                            if (SUCCEEDED(retVal))
                            {
                                // Set its size
                                retVal = pOpaque->SetSize(4);
                                if (SUCCEEDED(retVal))
                                {
                                    // Pack the opaque buffer with a seq num
                                    BYTE* pBuf = pOpaque->GetBuffer();
                                    Pack32(pBuf, i);
                                    // Add the packet
                                    retVal = pSession->AddPacket(pData, pOpaque, (i ? FALSE : TRUE));
                                }
                            }
                            HX_RELEASE(pOpaque);
                        }
                        HX_RELEASE(pData);
                    }
                }
                HX_RELEASE(pNest);
            }
        }
        else
        {
            retVal = HXR_OUTOFMEMORY;
        }
    }
    else
    {
        retVal = HXR_FAIL;
    }

    return retVal;
}

void CRealPixPNGFileFormatCodec::ReleaseAllSessions()
{
    if (m_pMapManager)
    {
        UINT32          ulHandle = 0;
        PXParseSession* pSession = NULL;
        HX_RESULT       retVal   = m_pMapManager->GetFirstEntry(ulHandle, (void**) &pSession);
        while (SUCCEEDED(retVal))
        {
            HX_RELEASE(pSession);
            retVal = m_pMapManager->GetNextEntry(ulHandle, (void**) &pSession);
        }
        m_pMapManager->DeleteAllEntries();
    }
}

