/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: rpeffect.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _IMF_EFFECT_H
#define _IMF_EFFECT_H

typedef _INTERFACE IIMFEffect IIMFEffect;

 /****************************************************************************
 *
 *  Interface:          IIMFEffect
 *
 *  Purpose:            IMF Effect Interface
 *
 *  IID_IIMFEffect:     {54A71422-AE44-11d1-A8BC-444553540001}
 *
 ****************************************************************************/

DEFINE_GUID(IID_IIMFEffect, 0x54a71422, 0xae44, 0x11d1, 0xa8, 0xbc, 0x44,
            0x45, 0x53, 0x54, 0x0, 0x1);

#define CLSID_IIMFEffect IID_IIMFEffect

#undef  INTERFACE
#define INTERFACE IIMFEffect

DECLARE_INTERFACE_(IIMFEffect, IUnknown)
{
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)   (THIS_ REFIID riid, void **ppvObj) PURE;

    STDMETHOD_(ULONG32,AddRef)  (THIS) PURE;

    STDMETHOD_(ULONG32,Release) (THIS) PURE;

    /*
     * IIMFEffect methods
     */

    /*
     * This method returns information about the IMF Effect Plugin:
     * namely, the package name (single string) and the names of all
     * the effects this package contains (multiple strings).
     */
    STDMETHOD(GetEffectInfo) (THIS_ REF(const char  *) pszPackageName,
                                    REF(const char **) ppszEffectName) PURE;

    /*
     * This method inputs the parameters of the effect and then
     * outputs a session handle which uniquely identifies this session.
     */
    STDMETHOD(InitEffect)   (THIS_ const char * /*IN*/  pszEffectName,
                                   BYTE *       /*IN*/  pImageIn1,
                                   BYTE *       /*IN*/  pImageIn2,
                                   BYTE *       /*IN*/  pImageOut,
                                   UINT32       /*IN*/  ulWidth,
                                   UINT32       /*IN*/  ulHeight,
                                   UINT32       /*IN*/  ulImageIn1PadWidth,
                                   UINT32       /*IN*/  ulImageIn2PadWidth,
                                   UINT32       /*IN*/  ulImageOutPadWidth,
                                   const char * /*IN*/  pszData,
                                   IHXBuffer * /*IN*/  pFileBuffer,
                                   REF(INT32)   /*OUT*/ rlSessionHandle) PURE;
    /*
     * This method does the effect. lPercentComplete is in the range [0, 100].
     */
    STDMETHOD(DoEffect)      (THIS_ INT32  lSessionHandle,
                                    UINT32 ulPercentComplete) PURE;

    /*
     * This method instructs the effect package to release whatever 
     * resources it allocated in InitEffect().
     */
    STDMETHOD(TermEffect)    (THIS_ INT32 lSessionHandle) PURE;
};

#endif

