/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxrect.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _PXRECT_H
#define _PXRECT_H

class PXRect : public CHXBaseCountingObject,
               public CUnknownIMP
{
    DECLARE_UNKNOWN(PXRect)
public:
    PXRect();
    virtual ~PXRect() {};

    UINT32 GetX()      const     { return m_ulX; };
    UINT32 GetY()      const     { return m_ulY; };
    UINT32 GetWidth()  const     { return m_ulW; };
    UINT32 GetHeight() const     { return m_ulH; };

    void   SetX(UINT32 ulX)      { m_ulX = ulX; };
    void   SetY(UINT32 ulY)      { m_ulY = ulY; };
    void   SetWidth(UINT32 ulW)  { m_ulW = ulW; };
    void   SetHeight(UINT32 ulH) { m_ulH = ulH; };

    void   Set(UINT32 ulX, UINT32 ulY, UINT32 ulW, UINT32 ulH);
    BOOL   IsNull();
    BOOL   IsOverlapped(const PXRect& rRect);
    BOOL   Contains(const PXRect& rRect) const;
    void   Clip(const PXRect& rRect);
    void   ChangeOriginTo(const PXRect& rRect);
    void   ChangeOriginFrom(const PXRect& rRect);
    void   Scale(const PXRect& rSrc, const PXRect& rDst);
    void   AdjustForZeroValues(UINT32 ulW, UINT32 ulH);
    void   AdjustForOvershoot(UINT32 ulW, UINT32 ulH);
    void   InterpolateRect(UINT32 ulTime, UINT32 ulStart, UINT32 ulEnd,
                           const PXRect& rStart, const PXRect& rEnd);
    void   Pack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer);
    void   UnPack(BYTE * &pBuffer, UINT32 ulMajVer, UINT32 ulMinVer);

    const PXRect & operator = (const PXRect& rRect);
    BOOL           operator == (const PXRect& rRect) const;
    BOOL           operator != (const PXRect& rRect) const;
protected:
    UINT32 m_ulX;
    UINT32 m_ulY;
    UINT32 m_ulW;
    UINT32 m_ulH;
};

inline PXRect::PXRect()
{
    m_ulX = m_ulY = m_ulW = m_ulH = 0;
}

inline void PXRect::Set(UINT32 ulX, UINT32 ulY, UINT32 ulW, UINT32 ulH)
{
    m_ulX = ulX;
    m_ulY = ulY;
    m_ulW = ulW;
    m_ulH = ulH;
}

inline const PXRect& PXRect::operator = (const PXRect &rRect)
{
    Set(rRect.m_ulX, rRect.m_ulY, rRect.m_ulW, rRect.m_ulH);
    return *this;
}

inline BOOL PXRect::operator == (const PXRect& rRect) const
{
    BOOL bRet = TRUE;
    if (rRect.m_ulX != m_ulX ||
        rRect.m_ulY != m_ulY ||
        rRect.m_ulW != m_ulW ||
        rRect.m_ulH != m_ulH)
    {
        bRet = FALSE;
    }
    return bRet;
}

inline BOOL PXRect::operator != (const PXRect& rRect) const
{
    BOOL bRet = FALSE;
    if (rRect.m_ulX != m_ulX ||
        rRect.m_ulY != m_ulY ||
        rRect.m_ulW != m_ulW ||
        rRect.m_ulH != m_ulH)
    {
        bRet = TRUE;
    }
    return bRet;
}

inline BOOL PXRect::IsNull()
{
    return (m_ulX | m_ulY | m_ulW | m_ulH ? FALSE : TRUE);
}

inline BOOL PXRect::IsOverlapped(const PXRect& rRect)
{
    BOOL bOverlap = FALSE;
    if (rRect.m_ulX               < m_ulX + m_ulW &&
        rRect.m_ulY               < m_ulY + m_ulH &&
        rRect.m_ulX + rRect.m_ulW > m_ulX         &&
        rRect.m_ulY + rRect.m_ulH > m_ulY)
    {
        bOverlap = TRUE;
    }
    return bOverlap;
}

inline BOOL PXRect::Contains(const PXRect& rRect) const
{
    BOOL bContain = FALSE;
    if (rRect.m_ulX               >= m_ulX         &&
        rRect.m_ulY               >= m_ulY         &&
        rRect.m_ulX + rRect.m_ulW <= m_ulX + m_ulW &&
        rRect.m_ulY + rRect.m_ulH <= m_ulY + m_ulH)
    {
        bContain = TRUE;
    }
    return bContain;
}

inline void PXRect::Clip(const PXRect& rRect)
{
    UINT32 ulRight1    = m_ulX + m_ulW;
    UINT32 ulRight2    = rRect.m_ulX + rRect.m_ulW;
    UINT32 ulBottom1   = m_ulY + m_ulH;
    UINT32 ulBottom2   = rRect.m_ulY + rRect.m_ulH;
    UINT32 ulNewRight  = (ulRight1 < ulRight2 ? ulRight1 : ulRight2);
    UINT32 ulNewBottom = (ulBottom1 < ulBottom2 ? ulBottom1 : ulBottom2);

    m_ulX              = (m_ulX > rRect.m_ulX ? m_ulX : rRect.m_ulX);
    m_ulY              = (m_ulY > rRect.m_ulY ? m_ulY : rRect.m_ulY);
    m_ulW              = (ulNewRight >= m_ulX ? ulNewRight - m_ulX : 0);
    m_ulH              = (ulNewBottom >= m_ulY ? ulNewBottom - m_ulY : 0);
}

inline void PXRect::ChangeOriginTo(const PXRect& rRect)
{
    if (m_ulX >= rRect.m_ulX && m_ulY >= rRect.m_ulY)
    {
        m_ulX -= rRect.m_ulX;
        m_ulY -= rRect.m_ulY;
    }
}

inline void PXRect::ChangeOriginFrom(const PXRect& rRect)
{
    m_ulX += rRect.m_ulX;
    m_ulY += rRect.m_ulY;
}

inline void PXRect::Scale(const PXRect& rSrc, const PXRect& rDst)
{
    if (rSrc.GetWidth() > 0 && rSrc.GetHeight() > 0)
    {
        m_ulX = m_ulX * rDst.GetWidth()  / rSrc.GetWidth();
        m_ulY = m_ulY * rDst.GetHeight() / rSrc.GetHeight();
        m_ulW = m_ulW * rDst.GetWidth()  / rSrc.GetWidth();
        m_ulH = m_ulH * rDst.GetHeight() / rSrc.GetHeight();
    }
}

inline void PXRect::AdjustForZeroValues(UINT32 ulW, UINT32 ulH)
{
    if (!m_ulW)
    {
        m_ulW = ulW;
    }
    if (!m_ulH)
    {
        m_ulH = ulH;
    }
}

inline void PXRect::AdjustForOvershoot(UINT32 ulW, UINT32 ulH)
{
    if (m_ulW > ulW)
    {
        m_ulW = ulW;
    }
    if (m_ulX + m_ulW > ulW)
    {
        m_ulX = ulW - m_ulW;
    }
    if (m_ulH > ulH)
    {
        m_ulH = ulH;
    }
    if (m_ulY + m_ulH > ulH)
    {
        m_ulY = ulH - m_ulH;
    }
}

#endif


