/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxffmcod.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXFFMCOD_H
#define PXFFMCOD_H

typedef _INTERFACE IHXRealPixFileFormatCodec  IHXRealPixFileFormatCodec;
typedef _INTERFACE IHXValues  IHXValues;

/****************************************************************************
 *
 *  Interface: IHXRealPixFileFormatCodec
 *
 *  Purpose:   Interface between RealPix file format and codec
 *
 *  IID_IHXRealPixFileFormatCodec: {309F2D21-CC0A-11d2-8A53-100FF0000000}
 *
 ****************************************************************************/
DEFINE_GUID(IID_IHXRealPixFileFormatCodec, 0x309f2d21, 0xcc0a, 0x11d2, 0x8a, 0x53,
            0x10, 0xf, 0xf0, 0x0, 0x0, 0x0);

#undef  INTERFACE
#define INTERFACE IHXRealPixFileFormatCodec

DECLARE_INTERFACE_(IHXRealPixFileFormatCodec, IUnknown)
{
    /*
     * IUnknown methods
     */
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void **ppvObj) PURE;

    STDMETHOD_(UINT32,AddRef)  (THIS) PURE;

    STDMETHOD_(UINT32,Release) (THIS) PURE;

    /*
     * IHXRealPixFileFormatCodec Methods
     */

    /************************************************************************
     *  Method:
     *      IHXRealPixFileFormatCodec::GetFileFormatCodecInfo()
     *  Purpose:
     *      Returns the information about the codec.
     *  Arguments:
     *      rppszFileExtension:    array of file extensions codec can parse (out)
     *      rppszFileMimeType:     array of file mime types codec can parse (out)
     *      rpszStreamMimeType:    stream mime type this codec produces (out)
     *      rulStreamVersion:      stream version this codec will produce (out)
     *      rulMaxPerImageOpaque:  max number of per-image opaque bytes (out)
     *      rulMaxPerPacketOpaque: max number of per-packet opaque bytes (out)
     */
    STDMETHOD(GetFileFormatCodecInfo) (THIS_ REF(const char**) rppszFileExtension,
                                             REF(const char**) rppszFileMimeType,
                                             REF(const char*)  rpszStreamMimeType,
                                             REF(UINT32)       rulStreamVersion,
                                             REF(UINT32)       rulMaxPerImageOpaque,
                                             REF(UINT32)       rulMaxPerPacketOpaque) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixFileFormatCodec::ValidInputData()
     *  Purpose:
     *      Determines whether the input buffer contains data which can
     *      be parsed by this codec.
     *  Arguments:
     *      pBuffer: buffer containing beginning of image file (in)
     *  Returns:
     *      TRUE if this codec can parse this data;
     *      FALSE if this codec cannot parse this data
     */
    STDMETHOD_(BOOL,ValidInputData) (THIS_ IHXBuffer* pBuffer) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixFileFormatCodec::ParseImage()
     *  Purpose:
     *      This method parses an image file and internally creates packets
     *      out of the file. It also returns information about how the 
     *      image file was packetized.
     *  Arguments:
     *      pBuffer:                  buffer containing image file (in)
     *      rulNumPackets             number of packets produced (out)
     *      rpParam                   packetization information (out)
     *      rulSessionHandle:         handle to refer to this image-parsing session (out)
     *
     *      The following properties are set in rpParam:
     *
     *      Name                 Type     Description
     *      "MaxPacketSize"      ULONG32  Max size of parsed packets
     *      "MinPacketSize"      ULONG32  Min size of parsed packets
     *      "TotalBytes"         ULONG32  Total parsed bytes (data + opaque)
     *      "TotalReqBytes"      ULONG32  Total parsed bytes which cannot handle loss
     *      "TotalNonReqBytes"   ULONG32  Total parsed bytes which can handle loss
     *      "ImageWidth"         ULONG32  Image width in pixels
     *      "ImageHeight"        ULONG32  Image height in pixels
     *      "OpaqueData"         ULONG32  Per-image-file opaque data
     *      "ContentVersion"     ULONG32  Content version of image
     *      "NumPerPacketOpaque" ULONG32  Number of per-packet opaque bytes
     */
    STDMETHOD(ParseImage) (THIS_ IHXBuffer*      pBuffer,
                                 REF(UINT32)      rulNumPackets,
                                 REF(IHXValues*) rpParam,
                                 REF(UINT32)      rulSessionHandle) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixFileFormatCodec::GetImagePacket()
     *  Purpose:
     *      This methods retrieves the data for a particular packet.
     *  Arguments:
     *      ulSessionHandle:    image parsing session handle (in)
     *      ulPacketNum:        index of packet (in)
     *      rpPacketBuffer:     buffer containing raw image data (out)
     *      rpOpaquePacketData: per-packet opaque data (out)
     *      rbRequired:         TRUE: cannot decode without this packet
     *                          FALSE: can decode without this packet
     */
    STDMETHOD(GetImagePacket) (THIS_ UINT32           ulSessionHandle,
                                     UINT32           ulPacketNum,
                                     REF(IHXBuffer*) rpPacketBuffer,
                                     REF(IHXBuffer*) rpOpaquePacketData,
                                     REF(BOOL)        rbRequired) PURE;

    /************************************************************************
     *  Method:
     *      IHXRealPixFileFormatCodec::ReleaseImage()
     *  Purpose:
     *      This method informs the codec that the caller is finished with
     *      this image and the codec can release all resources
     *      associated with it.
     *  Arguments:
     *      ulSessionHandle: image-parsing session handle
     */
    STDMETHOD(ReleaseImage) (THIS_ UINT32 ulSessionHandle) PURE;
};

#endif

