/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: fileread.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef FILEREAD_H
#define FILEREAD_H

// Forward declarations
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef _INTERFACE IHXFileResponse       IHXFileResponse;
typedef _INTERFACE IHXFileObject         IHXFileObject;
typedef _INTERFACE IHXCommonClassFactory IHXCommonClassFactory;
class CHXBaseCountingObject;

class CHXFileReaderResponse : public IUnknown
{
public:
    CHXFileReaderResponse() {};
    virtual ~CHXFileReaderResponse() {};

    // IUnknown methods
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void** ppvObj) PURE;
    STDMETHOD_(UINT32,AddRef)  (THIS) PURE;
    STDMETHOD_(UINT32,Release) (THIS) PURE;

    STDMETHOD(InitDone)     (THIS_ HX_RESULT status) PURE;
    STDMETHOD(ReadDone)     (THIS_ HX_RESULT status, IHXBuffer* pBuffer) PURE;
    STDMETHOD(ShutdownDone) (THIS) PURE;
};

class CHXFileReader : public CHXBaseCountingObject,
                      public IHXFileResponse
{
public:
    CHXFileReader();
    virtual ~CHXFileReader();

    // CHXFileReader methods
    STDMETHOD(Init)     (THIS_ IUnknown*              pContext,
                               IHXFileObject*        pFileObject,
                               BOOL                   bCanPreload,
                               BOOL                   bCanCache,
                               CHXFileReaderResponse* pResponse);
    STDMETHOD(Read)     (THIS_ UINT32 ulOffset, UINT32 ulNumBytes);
    STDMETHOD(Shutdown) (THIS);

    // IUnknown methods
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(UINT32,AddRef)  (THIS);
    STDMETHOD_(UINT32,Release) (THIS);

    // IHXFileResponse methods
    STDMETHOD(InitDone)  (THIS_ HX_RESULT status);
    STDMETHOD(CloseDone) (THIS_ HX_RESULT status);
    STDMETHOD(ReadDone)  (THIS_ HX_RESULT status, IHXBuffer* pBuffer);
    STDMETHOD(WriteDone) (THIS_ HX_RESULT status);
    STDMETHOD(SeekDone)  (THIS_ HX_RESULT status);
protected:
    enum
    {
        kStateConstructed,
        kStateInitPending,
        kStateReady,
        kStateSeekPending,
        kStateReadPending,
        kStateClosePending,
        kReadSize       = 2048,
        kFlagCanPreload = 1,
        kFlagCanCache   = 2
    };

    INT32                   m_lRefCount;
    IUnknown*               m_pContext;
    IHXFileObject*         m_pFileObject;
    CHXFileReaderResponse*  m_pResponse;
    IHXCommonClassFactory* m_pCommonClassFactory;
    UINT32                  m_ulState;
    UINT32                  m_ulFlags;
    UINT32                  m_ulCurrentOffset;
    UINT32                  m_ulReqOffset;
    UINT32                  m_ulReqNumBytes;

    void Deallocate();
    BOOL CanPreload() { return (m_ulFlags & kFlagCanPreload ? TRUE : FALSE); }
    BOOL CanCache()   { return (m_ulFlags & kFlagCanCache   ? TRUE : FALSE); }
};

#endif
