/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: makebomb.cpp,v 1.1.26.1 2004/07/09 01:54:47 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

// include
#include "hxtypes.h"
#include "hxwintyp.h"
#include "hxcom.h"
#include "ihxpckts.h"
#include "hxvsurf.h"

// hxmisc
#include "baseobj.h"
#include "unkimp.h"

// pxcomlib
#include "pxrect.h"
#include "pxcolor.h"
#include "pximage.h"
#include "wirefmgr.h"
#include "makebomb.h"

// zlib
#include "zlib.h"

// hxdebug
#include "hxassert.h"
#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

#if defined(_WINDOWS)
const BOOL   PXMakeBombImage::m_bRowsInverted       = TRUE;
#else
const BOOL   PXMakeBombImage::m_bRowsInverted       = FALSE;
#endif
const UINT32 PXMakeBombImage::m_ulOriginalSize      = 1834;
const UINT32 PXMakeBombImage::m_ulImageBufferLength = 390;
const BYTE   PXMakeBombImage::m_pImageBuffer[]      =
{
    0x78, 0x9C, 0xED, 0xD2, 0xC9, 0x4B, 0x42, 0x51, 0x18, 0x05, 0xF0, 0x63, 
    0xD9, 0x68, 0xA3, 0xCD, 0xD9, 0x3C, 0x8F, 0x6F, 0xD9, 0x1F, 0x10, 0xB8, 
    0xEC, 0x5F, 0x92, 0x88, 0x24, 0x44, 0x11, 0x29, 0x42, 0x14, 0x11, 0x43, 
    0x44, 0x0C, 0x11, 0x45, 0xA2, 0x88, 0x88, 0x42, 0x44, 0x33, 0xCB, 0xB2, 
    0x79, 0xB4, 0x79, 0x5A, 0xB7, 0x37, 0xFB, 0x6E, 0xF0, 0x36, 0x9F, 0xAB, 
    0xB6, 0x9E, 0xC7, 0xE5, 0xC1, 0xFD, 0x71, 0xCE, 0xEA, 0x4E, 0xCF, 0x8C, 
    0x95, 0x81, 0x32, 0xA5, 0x04, 0x46, 0x72, 0x7F, 0xCD, 0xDF, 0x51, 0xA0, 
    0x9C, 0xEE, 0xBF, 0x8B, 0x00, 0xB5, 0x4A, 0x9C, 0xDC, 0x25, 0x1D, 0x97, 
    0x56, 0x8B, 0xB8, 0x4E, 0x87, 0xBD, 0xD9, 0x59, 0x24, 0xE6, 0xE6, 0xB0, 
    0x3F, 0x3F, 0x8F, 0x7D, 0xBD, 0x1E, 0xC9, 0x85, 0x05, 0x1C, 0x18, 0x0C, 
    0x38, 0x34, 0x1A, 0x91, 0x32, 0x99, 0x90, 0x32, 0x9B, 0x71, 0x64, 0xB1, 
    0xE0, 0x78, 0x71, 0x11, 0xE9, 0xA5, 0x25, 0xA4, 0x97, 0x97, 0x71, 0x62, 
    0xB5, 0xE2, 0xD4, 0x66, 0xC3, 0x99, 0xDD, 0x8E, 0x33, 0x87, 0x03, 0xE7, 
    0x4E, 0x27, 0x2E, 0x5C, 0x2E, 0x5C, 0xAE, 0xAC, 0xE0, 0xD2, 0xED, 0xC6, 
    0x95, 0xC7, 0x83, 0x6B, 0xAF, 0x17, 0x37, 0x3E, 0x1F, 0x6E, 0x56, 0x57, 
    0x71, 0xEB, 0xF7, 0xE3, 0x2E, 0x10, 0xC0, 0x7D, 0x30, 0x88, 0x4C, 0x28, 
    0x84, 0x4C, 0x38, 0x8C, 0x87, 0xB5, 0x35, 0x3C, 0xAE, 0xAF, 0xE3, 0x69, 
    0x63, 0x03, 0x4F, 0x9B, 0x9B, 0x78, 0xDE, 0xDA, 0xC2, 0xCB, 0xF6, 0x36, 
    0x5E, 0x77, 0x76, 0xF0, 0xBA, 0xBB, 0x8B, 0xB7, 0x48, 0x04, 0xEF, 0xD1, 
    0x28, 0x3E, 0x62, 0x31, 0x7C, 0xC4, 0xE3, 0xF8, 0x4C, 0x24, 0xF0, 0x95, 
    0x4C, 0x22, 0x9B, 0xCD, 0xA2, 0x90, 0x42, 0x0A, 0xF9, 0x5F, 0xA4, 0xFC, 
    0xD1, 0x4A, 0x82, 0xB9, 0x56, 0xCE, 0x5A, 0x7E, 0x11, 0xF5, 0x75, 0xB5, 
    0x35, 0xD5, 0x55, 0xAA, 0xCA, 0x8A, 0xF2, 0xB2, 0xD2, 0x12, 0x65, 0x71, 
    0x91, 0x02, 0x92, 0x4B, 0x42, 0x2B, 0x8F, 0xD4, 0x6B, 0xE3, 0x91, 0xAC, 
    0x9D, 0x47, 0xDA, 0xD4, 0xF0, 0x48, 0xBD, 0x0E, 0x1E, 0xC9, 0x3A, 0x79, 
    0xA4, 0xCD, 0x2E, 0x81, 0x64, 0x6A, 0x19, 0xA9, 0xD7, 0x2D, 0x90, 0xAC, 
    0x41, 0x46, 0xB2, 0x1E, 0x81, 0x64, 0x8D, 0x32, 0xD2, 0x66, 0x2F, 0x8F, 
    0xD4, 0xEB, 0xE3, 0x91, 0xAC, 0x9F, 0x47, 0xDA, 0x1C, 0xE0, 0x91, 0x7A, 
    0x83, 0x32, 0x92, 0x35, 0x09, 0x24, 0x1B, 0x92, 0x91, 0xAC, 0x59, 0x20, 
    0x6D, 0x0E, 0xCB, 0x48, 0xD6, 0x22, 0x90, 0x7A, 0x23, 0x3C, 0x92, 0x8D, 
    0xF2, 0x48, 0x9B, 0x63, 0x3C, 0x52, 0x6F, 0x9C, 0x47, 0xB2, 0x09, 0x1E, 
    0x21, 0xE5, 0xBE, 0x49, 0x1E, 0xC9, 0xF8, 0xF7, 0x8C, 0x5F, 0xCB, 0x1F, 
    0xFC, 0x00, 0xD4, 0x9C, 0xB5, 0x56
};

PXMakeBombImage::PXMakeBombImage()
{
    m_pColorMap  = NULL;
    m_pBits      = NULL;
    m_ulRowBytes = 0;
}

HX_RESULT PXMakeBombImage::MakeBombImage(IUnknown* pContext, UINT32 ulW, UINT32 ulH,
                                         UINT32 ulBackColor, REF(PXImage*) rpBombImage)
{
    HX_RESULT retVal = HXR_OK;

    if (pContext && ulW && ulH)
    {
        // Create a buffer big enough to old the decompressed buffer
        BYTE* pPostZlibBuf = new BYTE [m_ulOriginalSize];
        if (pPostZlibBuf)
        {
            // Inflate the data (zlib)
	    uLong ulPostZlibSize = m_ulOriginalSize;
            INT32 lRet            = uncompress(pPostZlibBuf, &ulPostZlibSize,
                                               m_pImageBuffer, m_ulImageBufferLength);
            if (lRet == Z_OK)
            {
                // Init parsing
                BYTE* pBuf = pPostZlibBuf;
                // Parse the BITMAPFILEHEADER
                PXBitmapFileHeader bfh;
                bfh.bfType      = (UINT16) PXWireFormatManager::UnPackUINT16_LE(pBuf);
                bfh.bfSize      = PXWireFormatManager::UnPackUINT32_LE(pBuf);
                bfh.bfReserved1 = (UINT16) PXWireFormatManager::UnPackUINT16_LE(pBuf);
                bfh.bfReserved2 = (UINT16) PXWireFormatManager::UnPackUINT16_LE(pBuf);
                bfh.bfOffBits   = PXWireFormatManager::UnPackUINT32_LE(pBuf);
                // Parse the BITMAPINFOHEADER
                m_cInfo.biSize          = PXWireFormatManager::UnPackUINT32_LE(pBuf);
                m_cInfo.biWidth         = (INT32) PXWireFormatManager::UnPackUINT32_LE(pBuf);
                m_cInfo.biHeight        = (INT32) PXWireFormatManager::UnPackUINT32_LE(pBuf);
                m_cInfo.biPlanes        = (UINT16) PXWireFormatManager::UnPackUINT16_LE(pBuf);
                m_cInfo.biBitCount      = (UINT16) PXWireFormatManager::UnPackUINT16_LE(pBuf);
                m_cInfo.biCompression   = PXWireFormatManager::UnPackUINT32_LE(pBuf);
                m_cInfo.biSizeImage     = PXWireFormatManager::UnPackUINT32_LE(pBuf);
                m_cInfo.biXPelsPerMeter = (INT32) PXWireFormatManager::UnPackUINT32_LE(pBuf);
                m_cInfo.biYPelsPerMeter = (INT32) PXWireFormatManager::UnPackUINT32_LE(pBuf);
                m_cInfo.biClrUsed       = PXWireFormatManager::UnPackUINT32_LE(pBuf);
                m_cInfo.biClrImportant  = PXWireFormatManager::UnPackUINT32_LE(pBuf);
                // Get the pointer to the color map
                m_pColorMap = (PXRGBQuad*) pBuf;
                // Skip to the bits
                m_pBits = (BYTE*) pPostZlibBuf + bfh.bfOffBits;
                // Compute the rowbytes
                UINT32 ulDataBytes = (m_cInfo.biWidth * m_cInfo.biBitCount + 7) >> 3;
                m_ulRowBytes       = ((ulDataBytes + 3) >> 2) << 2;
                // Create a PXImage object
                PXImage* pImage = NULL;
                retVal          = PXImage::CreateObject(&pImage);
                if (SUCCEEDED(retVal))
                {
                    // AddRef the object
                    pImage->AddRef();
                    // Set the dimensions, color, etc.
                    retVal = pImage->Create((INT32) ulW, (INT32) ulH, 32, HX_RGB,
                                            m_bRowsInverted, TRUE);
                    if (SUCCEEDED(retVal))
                    {
                        // Fill in with the background color
                        pImage->Fill32(ulBackColor);
                        // Compute where we will place the smaller image 
                        // in the larger one
                        INT32 lXOffset = 8;
                        INT32 lYOffset = 8;
                        INT32 lWidth   = m_cInfo.biWidth;
                        INT32 lHeight  = m_cInfo.biHeight;
                        if (lXOffset + lWidth > (INT32) ulW)
                        {
                            lXOffset = (INT32) ulW - lWidth;
                            if (lXOffset < 0)
                            {
                                lXOffset = 0;
                                lWidth   = (INT32) ulW;
                            }
                        }
                        if (lYOffset + lHeight > (INT32) ulH)
                        {
                            lYOffset = (INT32) ulH - lHeight;
                            if (lYOffset < 0)
                            {
                                lYOffset = 0;
                                lHeight  = (INT32) ulH;
                            }
                        }
                        // Decode into the image
                        for (INT32 lY = 0; lY < lHeight; lY++)
                        {
                            UINT32* pRow = (UINT32*) pImage->GetPixel(lXOffset, lYOffset + lY);
                            for (INT32 lX = 0; lX < lWidth; lX++)
                            {
                                *pRow++ = GetPixel(lX, lY);
                            }
                        }
                        // Assign the out parameter
                        HX_RELEASE(rpBombImage);
                        rpBombImage = pImage;
                        rpBombImage->AddRef();
                    }
                }
                HX_RELEASE(pImage);
            }
            else
            {
                retVal = HXR_FAIL;
            }
        }
        HX_VECTOR_DELETE(pPostZlibBuf);
    }
    else
    {
        retVal = HXR_INVALID_PARAMETER;
    }

    return retVal;
}

UINT32 PXMakeBombImage::GetPixel(INT32 lX, INT32 lY)
{
    UINT32 ulRet = 0;

    if (lX >= 0 && lX < m_cInfo.biWidth &&
        lY >= 0 && lY < m_cInfo.biHeight)
    {
        UINT32 ulXBitOffset  = (UINT32) lX * m_cInfo.biBitCount;
        UINT32 ulXByteOffset = ulXBitOffset >> 3;
        UINT32 ulPixel       = m_pBits[(m_cInfo.biHeight - 1 - lY) * m_ulRowBytes + ulXByteOffset];
        UINT32 ulShift       = 8 - (ulXBitOffset - (ulXByteOffset << 3)) - m_cInfo.biBitCount;
        UINT32 ulMask        = (1 << m_cInfo.biBitCount) - 1;
        UINT32 ulIndex       = (ulPixel >> ulShift) & ulMask;
        ulRet                = (m_pColorMap[ulIndex].rgbRed   << 16) |
                               (m_pColorMap[ulIndex].rgbGreen <<  8) |
                                m_pColorMap[ulIndex].rgbBlue;
    }

    return ulRet;
}
