#include <config.h>
#include "CGConf.h"
#include <list>

#if FF_DEBUG
#include <iostream>
#endif

using namespace std;


void CGConfUI::add_dir(	Glib::RefPtr <Gnome::Conf::Client>& pGConfClient, 
						const ustring& strDir, 
						SigC::Slot2 <void, const ustring&, const Gnome::Conf::Value&> slotValueChanged, 
						Gnome::Conf::ClientPreloadType enPreloadType /*= Gnome::Conf::CLIENT_PRELOAD_ONELEVEL*/)
{
	m_pGConfClient = pGConfClient;
	pGConfClient->add_dir(strDir, enPreloadType);
	list <Gnome::Conf::Entry> contEntries = pGConfClient->all_entries(strDir);

#if FF_DEBUG
	cerr << "contEntries.size()=" << contEntries.size() << endl;
#endif
	list <Gnome::Conf::Entry>::const_iterator it = contEntries.begin();
	for (; it != contEntries.end(); it++)
	{
		const Gnome::Conf::Value& value = pGConfClient->get(it->get_key());
		m_contEntries[it->get_key()] = value;
#if FF_DEBUG
		cerr << "GConf: " << it->get_key() << "=" << value.get_type();
		if (value.get_type() == 2)
			cerr << ", value=" << value.get_int();
		else if (value.get_type() == 4)
			cerr << ", value=" << value.get_bool();
		else if (value.get_type() == 1)
			cerr << ", value=" << value.get_string();
		cerr << endl;
#endif
	}
	
	pGConfClient->signal_value_changed().connect(slotValueChanged);
}
