.\"
.\" ppdcfile man page for CUPS.
.\"
.\" Copyright 2007-2016 by Apple Inc.
.\" Copyright 1997-2007 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH ppdcfile 5 "CUPS" "5 March 2016" "Apple Inc."
.SH NAME
ppdcfile \- cups ppd compiler source file format
.SH DESCRIPTION
The CUPS PPD compiler reads meta files that contain descriptions of one or more PPD files to be generated by
.BR ppdc (1).
This man page provides a quick reference to the supported keywords and should be used in conjunction with the online help for CUPS.
.PP
The source file format is plain ASCII text that can be edited using your favorite text editor. Comments are supported using the C (/* ... */) and C++ (// ...) comment mechanisms.
.PP
Printer driver information can be grouped and shared using curly braces ({ ... }); PPD files are written when a close brace or end-of-file is seen and a PCFileName directive has been defined.
.PP
Directives may be placed anywhere on a line and are followed by one or more values. The following is a list of the available directives and the values they accept:
.TP 5
\fB#define \fIname value\fR
.TP 5
\fB#elif \fR{\fIname \fR| \fIvalue\fR}
.TP 5
\fB#else\fR
.TP 5
\fB#endif\fR
.TP 5
\fB#font \fIname encoding "version" charset status\fR
.TP 5
\fB#if \fR{\fIname \fR| \fIvalue\fR}
.TP 5
\fB#include <\fIfilename\fB>\fR
.TP 5
\fB#include "\fIfilename\fB"\fR
.TP 5
\fB#media \fIname width length\fR
.TP 5
\fB#media "\fIname\fB/\fItext\fB" \fIwidth length\fR
.TP 5
\fB#po \fIlocale \fB"\fIfilename\fB"\fR
.TP 5
\fBAttribute \fIname \fB"" \fIvalue\fR
.TP 5
\fBAttribute \fIname keyword value\fR
.TP 5
\fBAttribute \fIname \fB"\fIkeyword\fB/\fItext\fB" \fIvalue\fR
.TP 5
\fBChoice \fIname \fB"\fIcode\fB"\fR
.TP 5
\fBChoice \fB"\fIname\fB/\fItext\fB" "\fIcode\fB"\fR
.TP 5
\fBColorDevice \fIboolean-value\fR
.TP 5
\fBColorModel \fIname colorspace colororder compression\fR
.TP 5
\fBColorModel "\fIname\fB/\fItext\fB" \fIcolorspace colororder compression\fR
.TP 5
\fBColorProfile \fIresolution\fB/\fImediatype gamma density matrix\fR
.TP 5
\fBCopyright "\fItext\fR"
.TP 5
\fBCustomMedia \fIname width length left bottom right top \fB"\fIsize-code\fB" "\fIregion-code\fB"\fR
.TP 5
\fBCustomMedia "\fIname\fB/\fItext\fB" \fIwidth length left bottom right top \fB"\fIsize-code\fB" "\fIregion-code\fB"\fR
.TP 5
\fBCutter \fIboolean-value\fR
.TP 5
\fBDarkness \fItemperature name\fR
.TP 5
\fBDarkness \fItemperature \fB"\fIname\fB/\fItext\fB"\fR
.TP 5
\fBDriverType \fItype\fR
.TP 5
\fBDuplex \fItype\fR
.TP 5
\fBFilter \fImime-type cost program\fR
.TP 5
\fBFinishing \fIname\fR
.TP 5
\fBFinishing "\fIname\fB/\fItext\fB"\fR
.TP 5
\fBFont *\fR
.TP 5
\fBFont \fIname encoding \fB"\fIversion\fB" \fIcharset status\fR
.TP 5
\fBGroup \fIname\fR
.TP 5
\fBGroup "\fIname\fB/\fItext\fB"\fR
.TP 5
\fBHWMargins \fIleft bottom right top\fR
.TP 5
\fBInputSlot \fIposition name\fR
.TP 5
\fBInputSlot \fIposition \fB"\fIname\fB/\fItext\fB"\fR
.TP 5
\fBInstallable \fIname\fR
.TP 5
\fBInstallable "\fIname\fB/\fItext\fB"\fR
.TP 5
\fBLocAttribute \fIname \fB"\fIkeyword\fB/\fItext\fB" \fIvalue\fR
.TP 5
\fBManualCopies \fIboolean-value\fR
.TP 5
\fBManufacturer "\fIname\fB"\fR
.TP 5
\fBMaxSize \fIwidth length\fR
.TP 5
\fBMediaSize \fIname\fR
.TP 5
\fBMediaType \fItype name\fR
.TP 5
\fBMediaType \fItype \fB"\fIname\fB/\fItext\fB"\fR
.TP 5
\fBMinSize \fIwidth length\fR
.TP 5
\fBModelName "\fIname\fB"\fR
.TP 5
\fBModelNumber \fInumber\fR
.TP 5
\fBOption \fIname type section order\fR
.TP 5
\fBOption "\fIname\fB/\fItext\fB" \fItype section order\fR
.TP 5
\fBPCFileName "\fIfilename.ppd\fB"\fR
.TP 5
\fBResolution \fIcolorspace bits-per-color row-count row-feed row-step name\fR
.TP 5
\fBResolution \fIcolorspace bits-per-color row-count row-feed row-step \fB"\fIname\fB/\fItext\fB"\fR
.TP 5
\fBSimpleColorProfile \fIresolution\fB/\fImediatype density yellow-density red-density gamma red-adjust green-adjust blue-adjust\fR
.TP 5
\fBThroughput \fIpages-per-minute\fR
.TP 5
\fBUIConstraints "\fI*Option1 *Option2\fB"\fR
.TP 5
\fBUIConstraints "\fI*Option1 Choice1 *Option2\fB"\fR
.TP 5
\fBUIConstraints "\fI*Option1 *Option2 Choice2\fB"\fR
.TP 5
\fBUIConstraints "\fI*Option1 Choice1 *Option2 Choice2\fB"\fR
.TP 5
\fBVariablePaperSize \fIboolean-value\fR
.TP 5
\fBVersion \fInumber\fR
.SH SEE ALSO
.BR ppdc (1),
.BR ppdhtml (1),
.BR ppdi (1),
.BR ppdmerge (1),
.BR ppdpo (1),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2016 by Apple Inc.
