/***************************************************************
 *
 * Copyright (C) 1990-2007, Condor Team, Computer Sciences Department,
 * University of Wisconsin-Madison, WI.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***************************************************************/

#include "condor_common.h"
#include "match_prefix.h"

int
match_prefix(const char *s1, const char *s2)
{
	size_t	s1l = strlen(s1);
	size_t	s2l = strlen(s2);
	size_t min = (s1l < s2l) ? s1l : s2l;

	// return true if the strings match (i.e., strcmp() returns 0)
	if (strncmp(s1, s2, min) == 0)
		return 1;

	return 0;
}
