// Copyright (c) 2009 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// Created by postproc-shortwords 1.8 on 2009-08-26 16:42:07
// From input file /export/hda3/cld/text_2008_quads_plus_sort.utf8
// See compact_lang_det.cc for usage
//
#include "encodings/compact_lang_det/cldutil.h"

// Included:
//      af-Latn ar-Arab be-Cyrl bg-Cyrl bs-Latn ca-Latn cs-Latn cy-Latn da-Latn
// de-Latn el-Grek en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn ga-Latn
// hi-Deva hr-Latn hu-Latn id-Latn is-Latn is-Latn it-Latn iw-Hebr ja-Hani
// ko-Hani lt-Latn lv-Latn mk-Cyrl ms-Latn nl-Latn no-Latn pl-Latn pt-Latn
// ro-Latn ru-Cyrl sh-Cyrl sh-Latn sk-Latn sl-Latn sr-Cyrl sv-Latn sw-Latn
// th-Thai tl-Latn tr-Latn uk-Cyrl vi-Latn xxx-Latn yi-Hebr zh-Hani zh-TW

// Remapped:
//      xxx-Latn=>ut-Latn sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl

// ms/id probabilities leveled

static const int kQuadTableBuildDate = 20090826;    // yyyymmdd

COMPILE_ASSERT(MONTENEGRIN == 160, k_montenegrin_changed);
COMPILE_ASSERT(EXT_NUM_LANGUAGES == 209, k_ext_num_languages_changed);

// Nil-grams: 18 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC ORIYA INUKTITUT

// Uni-grams: 6 languages
//     Japanese Korean Chinese VIETNAMESE ChineseT ZHUANG

// Words/Quads/Gibberish: 47 languages in range ENGLISH..AFRIKAANS:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     Ignore BULGARIAN CROATIAN SERBIAN IRISH TAGALOG TURKISH
//     UKRAINIAN HINDI MACEDONIAN INDONESIAN LATIN MALAY WELSH
//     BELARUSIAN ARABIC CATALAN SWAHILI SLOVENIAN MARATHI VIETNAMESE
//     SLOVAK PERSIAN NORWEGIAN_N YIDDISH AFRIKAANS

//  ENGLISH 6041
//  DANISH 2009
//  DUTCH 2291
//  FINNISH 5068
//  FRENCH 3532
//  GERMAN 4895
//  HEBREW 28055
//  ITALIAN 1534
//  NORWEGIAN 2098
//  POLISH 8303
//  PORTUGUESE 2348
//  RUSSIAN 6301
//  SPANISH 2055
//  SWEDISH 3256
//  CZECH 6990
//  ICELANDIC 5154
//  LATVIAN 5706
//  LITHUANIAN 4856
//  ROMANIAN 3611
//  HUNGARIAN 8204
//  ESTONIAN 5248
//  Ignore 42
//  BULGARIAN 5834
//  CROATIAN 4082
//  SERBIAN 6161
//  IRISH 3822
//  TAGALOG 1816
//  TURKISH 6112
//  UKRAINIAN 9725
//  HINDI 14453
//  MACEDONIAN 4401
//  INDONESIAN 2100
//  LATIN 2
//  MALAY 2026
//  WELSH 5143
//  BELARUSIAN 11926
//  ARABIC 23951
//  CATALAN 1989
//  SWAHILI 2597
//  SLOVENIAN 2813
//  MARATHI 318
//  VIETNAMESE 3944
//  SLOVAK 4357
//  PERSIAN 13411
//  NORWEGIAN_N 422
//  YIDDISH 7557
//  AFRIKAANS 2010


static const int kQuadTableSize = 65536;    // Bucket count
static const int kQuadTableKeyMask = 0xffff0000;    // Mask hash key

// 521808 possible entries:
// 257317 filled (49%), 1252 merged (0%), 263239 dropped (50%)
static const cld::IndirectProbBucket4 kQuadTable[kQuadTableSize] = {
  // key[4], words[4] in UTF-8
  // value[4]
  { {0xcb670001,0x7fe90002,0xbddb0003,0x69260004}},	// [000] шате_, _حروف_, rtèr, имаа
  { {0x20070005,0xbddb0006,0x7bc40007,0xfe9b0008}},	//   _kuni_, stèr, sniu, _סיימ
  { {0x5d3b0008,0x65630009,0xad1b000a,0x52e2000b}},	//   _בתיא, denh, _שוטר, _पर्स
  { {0x63bb000c,0x07a6000d,0x2007000e,0xf989000f}},	//   jiun, јадн, _muni_, ור_
  { {0xa7730010,0x20070011,0x65630012,0x63a90013}},	//   ўліч, _luni_, fenh, dhen
  { {0xef1f0014,0x94760015,0x24510016,0x64430017}},	//   tjük_, لدعا, _bơm_, funi
  { {0x28160018,0x64430019,0x24510016,0x63a9001a}},	//   _خوزس, guni, _cơm_, fhen
  { {0xef1f0014,0x63bb001b,0xdb0d001c,0x63a9001d}},	//   rjük_, giun, riaç, ghen
  { {0x3667001e,0x6d47001a,0x6563001f,0x32060003}},	//   _като_, ygja, benh, _quoy_
  { {0x63a90020,0xc5690021,0x3f730016,0x20070022}},	//   ahen, _محمل_, _ệu_, _buni_
  { {0x2b9c0023,0x75280024,0x3ff9000d,0x75d30015}},	//   _tích_, _iedz, лноќ_, _بيلا
  { {0x63bb0011,0x63a90025,0x749b000a,0xe3b20015}},	//   ciun, chen, _שיאפ, _برئ_
  { {0x69c50026,0x69dc0027,0x6fdd0003,0x6f1d0028}},	//   ynhe, _okre, xécu, rbsc
  { {0x71730029,0x92b7000a,0x7528002a,0x50b7002b}},	//   _وهنا, _דפדף_, _jedz, ادید_
  { {0x7528002c,0x212c002d,0x6d47002e,0xd0100015}},	//   _medz, madh_, rgja, _علة_
  { {0x212c002f,0x6d47002e,0x3fb40015,0x78700030}},	//   ladh_, sgja, _وإيس, zóvá
  { {0xafb80031,0x6b8d0032,0x9bc40033,0x6e240034}},	// [010] _خطوط_, rjag, цёрк, _gwib
  { {0x212c002f,0x63bb0011,0x64430035,0x7ac40036}},	//   nadh_, ziun, yuni, істе
  { {0x65630037,0x63a90038,0x27ed0039,0x6aad0030}},	//   venh, yhen, _phen_, szaf
  { {0x63bb0011,0x212c002d,0xa8040033,0x69dc003a}},	//   xiun, hadh_, ізіл, _ekre
  { {0xd6ab003b,0x63a9003c,0x9878003d,0x7528002a}},	//   خدام_, vhen, kšķa_, _bedz
  { {0x27ed003e,0x26df003f,0xb9950015,0x98170040}},	//   _when_, _vyuo_, _الآب, _نبرا
  { {0x27ed0041,0x63bb0042,0xf5560029,0x63a90043}},	//   _then_, tiun, صليب_, then
  { {0x7e6d0044,0xdce50045,0x69dc0046,0x67d40047}},	//   _osap, _zahă, _zkre, _досу
  { {0x67290048,0x212c002d,0x63a90049,0x1306004a}},	//   _ieej, fadh_, rhen, щный_
  { {0x212c002f,0x02020010,0x24750024,0xdb09002e}},	//   gadh_, язьн, _tām_, _ánæg
  { {0xddc4004b,0xc50c004c,0x63a9004d,0x5f06004e}},	//   _priž, _סלאָ, phen, йзна
  { {0xedb2000b,0x23740015,0xf456004f,0xd808004f}},	//   ुच्छ, _وانح, _ליער_, יִשָ
  { {0x66010050,0x7e6d0014,0x20000051,0x67ea0052}},	//   _kilk, _csap, _viii_, nýja
  { {0x212c002f,0xb2760053,0xd5f90053,0x41290054}},	//   cadh_, _לענג_, רפֿר, _соко_
  { {0x5cb70010,0x10150002,0xfce60055,0x66010056}},	//   блёў_, _ابتد, сово, _milk
  { {0xee3f0057,0x260a000b,0x28bd000b,0x7b9a002b}},	//   brý_, ादमी_, ्पनि, دپرس_
  { {0x6d41002d,0x8f1b000a,0x68e30012,0xba290058}},	// [020] ólac, _גופת, ündn, لسلم_
  { {0x0ae90029,0x44250059,0x31a9005a,0x6601005b}},	//   شرقي_, _owl_, _fúze_, _nilk
  { {0x75280048,0x7995005c,0x4d7b0053,0x31ba004c}},	//   _redz, _dozw, _ערטע, נזענ
  { {0xbb86003b,0xa3e7005d,0xf62a005e,0xccf3000a}},	//   _الحي, _मील_, гіки_, _מכת_
  { {0x6594005f,0x96330033,0x65a6001a,0xd765002b}},	//   жалу, зніц, _aðha, زنوی
  { {0x291e002e,0x69dc0060,0xdb16002e,0x5e57004c}},	//   _ýta_, _ukre, ábær, מינע_
  { {0xb8960029,0xe6440061,0x44250034,0x212c0062}},	//   _الزع, ğlığ, _cwl_, vadh_
  { {0x53980063,0xe6440064,0xdb0d002e,0x289b000a}},	//   рвия_, şlığ, nnað, _גילא
  { {0x212c002d,0xb355002b,0x70b20065,0x66010066}},	//   tadh_, تینا_, ुप्ल, _filk
  { {0xdbde0045,0x316a0054,0xf617000a,0x21b4005e}},	//   nţân, ушио_, _לחמש_, ійня
  { {0x212c002f,0x89db000a,0x74130067,0xdb0d001a}},	//   radh_, רחיי, _فولا, knað
  { {0x212c002f,0x7bc80068,0xee3f0069,0x0000006a}},	//   sadh_, édul, trý_,
  { {0x27fc002c,0x212c002d,0xa3c5000b,0x6ea8006b}},	//   ívny_, padh_, उचर_, бърг_
  { {0xe56e0010,0x98b80064,0xf237000a,0x8167006b}},	//   дзi_, _ları_, _פרוץ_, _гръб_
  { {0x79950050,0x71bb0008,0xdb0d002e,0x63b90026}},	//   _rozw, _תצוג, fnað, _ymwn
  { {0xdb0d001a,0x2d8c006c,0x80370015,0x0000006a}},	//   gnað, öder_, _اسوأ_,
  { {0x79950050,0x7e6d0035,0xedd50015,0xa9070015}},	// [030] _pozw, _usap, _ويبد, مبان
  { {0x67290020,0x5a34006d,0xddeb006e,0x67ea006f}},	//   _seej, янут, _حربه_, výja
  { {0xe7190070,0x515b000a,0x6d88000a,0xfd56000a}},	//   ليات_, רכבו, _הָרְ, _ושתי_
  { {0xe00b005d,0x66010071,0x6d5a0072,0xddc40073}},	//   _संसद_, _silk, õtav, _isiš
  { {0xd2460074,0x66010075,0xcdd5000a,0xf7480015}},	//   _تن_, _pilk, ֗ךְ_, إلهي_
  { {0xa2cc000b,0x44150076,0x75ed0077,0xd0060058}},	//   _तख़्, офит, dúzc, _يل_
  { {0x66010078,0x2d910079,0x67290072,0x0000006a}},	//   _vilk, ijze_, _teej,
  { {0xe3b10031,0x1309007a,0xe4560033,0x36d5007b}},	//   برت_, шний_, іжы_, _добр
  { {0x6609007c,0x6601007d,0x6790002b,0x0000006a}},	//   _uuek, _tilk, _سیوط,
  { {0x11d60029,0x8698007e,0x98b8007f,0x0000006a}},	//   يوية_, _укус_, _zarı_,
  { {0x98b80064,0xfbd9000b,0xe2a8002b,0x0000006a}},	//   _yarı_, भकाम, لاین_,
  { {0x14d60053,0x22590080,0x9f06002b,0x33f40058}},	//   _וועל_, _виды_, توحو, _فسنس
  { {0xc8e6000b,0xddc40081,0x0000006a,0x0000006a}},	//   _कर्म_, _asiš,   ,
  { {0x8024002b,0xa0a50082,0x867a000a,0xa1560054}},	//   _کروم, _малд, ברשו, _даљу_
  { {0x3b960083,0x8fe6003b,0xdb0d0084,0x68e30012}},	//   ојат, _وأعم, tnað, ündl
  { {0xc052000a,0x2fd70015,0xfbd10015,0x7ff6006e}},	//   _חזה_, _ووود_, ّتْ_, _بستا
  { {0xda660029,0x891a0015,0xdb0d001a,0x7c290085}},	// [040] غاري, لغاز_, rnað, ćera
  { {0x2b580086,0x98b80061,0x61340046,0x9992006f}},	//   _گیرد_, _sarı_, mýlí, kryť_
  { {0xd90d0086,0xc8ca0087,0x9f420046,0xd70a0088}},	//   ایف_, جوان_, elké_, анее_
  { {0xddcd0089,0xe8e00016,0xa6e6008a,0x47d30058}},	//   _vrať, hiệu_, ожел, ويلر
  { {0x3ce80065,0x0000006a,0x0000006a,0x0000006a}},	//   ज़ेरे_,   ,   ,
  { {0x7aeb0012,0x45b7008b,0xdb21008c,0x95f40065}},	//   ügte, огію_, ätöv, इगेट_
  { {0x07a6008d,0x53460033,0x0000006a,0x0000006a}},	//   _давн, охпа,   ,
  { {0xd3260036,0x68b7000a,0xbc1b000a,0xd3d70015}},	//   цьки, _וללא_, בוקש, يبيا_
  { {0xdcfe0048,0x3266005e,0x6722008e,0x6e36005a}},	//   _kopē, ітив, mboj, _nvyb
  { {0xd257008f,0xa697000a,0x27e60090,0x67220091}},	//   іцы_, _וכמה_, llon_, lboj
  { {0xdb060014,0x26100092,0xc0ca0001,0xb97b0008}},	//   _elké, _hào_, рупе_, בניי
  { {0x28bd000b,0xc2760015,0x75ed0093,0x27e60094}},	//   ्पति, _وُضع, púzc, nlon_
  { {0xa2d60074,0xd250003b,0x5f940063,0x20180095}},	//   _بيشت, _أنت_, фият, ūri_
  { {0x98a3003d,0xdcfe003d,0x158a000a,0x27e60096}},	//   _lejā_, _nopē, ׁנָֽ, hlon_
  { {0x26100092,0x2ca50097,0xac190098,0x4c95005e}},	//   _lào_, áld_, собу_, чивс
  { {0x68e3007c,0x7b880099,0xda150054,0x7dc9006f}},	//   ündm, ољуб_, здањ, oľsk
  { {0x26100023,0x27e60026,0xdc3c003d,0x61fd0046}},	// [050] _nào_, dlon_, kšķe, ůsle
  { {0xceb20053,0x27e60003,0x19b80015,0x828b000a}},	//   _ניי_, elon_, يطلة_, יְבֶ
  { {0x9783002b,0xfeb8009a,0x984b009b,0x0000006a}},	//   ویسه, _هایت_, ряза_,
  { {0xdc880008,0x26100092,0x201e0007,0xf093000a}},	//   _וְשָ, _bào_, ipti_, ונע_
  { {0xff7c0053,0x6b7a0008,0x79a7009c,0x4e1e000b}},	//   יטאמ, _פרשנ, _дрве, _बढ़ाई_
  { {0x8afa009d,0x5a34009e,0xbafa0008,0x9964009f}},	//   _להרי, _інст, _להרש, _отсл
  { {0x96bb005d,0xf992000a,0xd5120015,0x27e600a0}},	//   _शेरॉ, _ארם_, رِيد, blon_
  { {0xf7730021,0x0000006a,0x0000006a,0x0000006a}},	//   _غاز_,   ,   ,
  { {0xf6770086,0x82350015,0x76420003,0x261000a1}},	//   _بازخ, أربا, croy, _gào_
  { {0xd6c60086,0x14190029,0x20d50033,0x1996004f}},	//   _عملی, _هيئة_, зімс, ִ֣יר_
  { {0x3cdb000b,0xe8e00016,0x77f5004f,0x0000006a}},	//   _खुले_, riệu_, ּמָד_,
  { {0x940400a2,0x6d41002e,0xc4d2000a,0xb4c7000b}},	//   _قوله, ólan, _אגב_, ईपी_
  { {0xd5c80092,0xdb0d007c,0x7052002b,0x261000a1}},	//   iền_, nnaõ, ونیا, _xào_
  { {0xdd920074,0x98ab005d,0x427a00a3,0x67e3007c}},	//   روز_, चनाए, _לאנג, mõju
  { {0xc0e20036,0xa0a500a4,0x67220091,0xdce7002a}},	//   _пошк, _хайд, yboj, odję
  { {0x5f760086,0xeef60033,0x70b6000a,0xf0b6000a}},	//   _رابر, _няпэ, _מהצד_, _מלצר_
  { {0x4a460010,0x0b430010,0xfe720015,0xeb9700a5}},	// [060] янав, энтн, _أدب_, чит_
  { {0xfa490029,0xdebb000a,0xbed7000a,0x26100016}},	//   تشفى_, _למפל, _מופז_, _rào_
  { {0xd884002b,0xca29000a,0xbb860015,0x98dd0033}},	//   بهای, רם_, _فلدي, асцi
  { {0x2d9a003e,0x403a004c,0xd6c4002b,0x27e600a6}},	//   _hope_, מגעג, ومای, ulon_
  { {0x67220048,0xa6130036,0x0d96000a,0xd6a90021}},	//   rboj, еміч, ּכֶם_, يدهم_
  { {0x261000a7,0x63ab0020,0x6d5c00a8,0x201e008c}},	//   _vào_, _algn, nfra, ypti_
  { {0x661b008c,0x6d5c00a9,0x6d4e00aa,0x291800ab}},	//   _etuk, ifra, igba, _ifra_
  { {0x34370029,0xa857000f,0x883b000a,0x764200ac}},	//   أسود_, _מילה_, _לתלו, proy
  { {0x41e60010,0x6d5c00ad,0x644300ae,0xd62700af}},	//   зіна, kfra, arni, _ноте_
  { {0x56370053,0x4a9b0053,0x361b000a,0x6d4e0079}},	//   _מאמע_, צייג, _לומד, jgba
  { {0xf9930008,0x30a30063,0x14c80086,0xe8df0092}},	//   תרת_, еряв, _بهای_, _trục_
  { {0xd36f00b0,0x201e0007,0x69de00b1,0x926a0054}},	//   _مهم_, rpti_, hope, _грка_
  { {0xe3b300b2,0x82330015,0xc7b3000a,0x644a00b3}},	//   _אױף_, _كروا, תבר_, lufi
  { {0x72eb00b4,0xdb0d0003,0x12fb000a,0x2d9a00b5}},	//   _פֿאַ, phaë, _ההדב, _cope_
  { {0xd5c80023,0x515b0008,0x415b000a,0xc1780091}},	//   yền_, _הכוו, _הדוג, mdė_
  { {0x6d4e00b6,0x6d5c002e,0xc1780091,0x69de00b7}},	//   agba, afra, ldė_, eope
  { {0x6d5c00b8,0x4a550033,0xd5dc000b,0x5f740067}},	// [070] bfra, ькас, मकाज, _ساير
  { {0x5c0700b9,0xc1780007,0x7ae600ba,0x69de00bb}},	//   _няма, ndė_, _dykt, gope
  { {0x3ea60048,0x8d5a000a,0xdd16002b,0x661c00bc}},	//   _ļoti_, _וכתי, _توپخ, _črka
  { {0x644300bd,0xa714005e,0xdc36004c,0xc017000a}},	//   vrni, емці, _קארט_, פקדו_
  { {0x4b7a000a,0xa5090004,0xb5fd003d,0xc1780091}},	//   _וארו, оела_, _apša, kdė_
  { {0xf6500086,0xf6d4002b,0x7bdf00be,0xddd600bf}},	//   طئه_, رزند, loqu, _kryš
  { {0x645800c0,0x05740021,0x644300c1,0x33f500c2}},	//   gtvi, عاهد, urni, мчис
  { {0x8235002b,0xe3b100c3,0xdc8c000a,0x7bcd00c4}},	//   ورخا, ضرب_, מְחָ, nnau
  { {0x6d5c0026,0x645800c5,0x28bd000b,0xd24e0021}},	//   yfra, atvi, ्पवि, لني_
  { {0x81f60029,0xd059005e,0xeeeb0016,0x7bcd00c6}},	//   وفير_, ормі_, ýờng_, hnau
  { {0xc9480008,0xc1050015,0x2d9a00c7,0x7bcd0091}},	//   הֲרֹ, بودي, _rope_, knau
  { {0xd24e0086,0xe2910086,0x201800c8,0x0000006a}},	//   دنی_, _لذت_, íria_,
  { {0x2d9a003e,0x69de003f,0xc1780091,0x76590034}},	//   _pope_, yope, bdė_, ntwy
  { {0x42fa000a,0xdce5006f,0x90c500c9,0x12fa000a}},	//   _והנס, _dohľ, _обле, _והנב
  { {0x6d5c00ca,0xed570063,0x70b20015,0x7e7d00cb}},	//   rfra, ьор_, _لموض, avsp
  { {0x8ffa0086,0x6c070029,0x5ea60029,0x5e460015}},	//   _برتر_, ِيِّ_, _يمثل, _قَبْ
  { {0x69de00cc,0x8f8b000a,0xcbc50015,0x2fd70015}},	// [080] tope, _וְיֵ, رزفي, _تويد_
  { {0x7bcd00cd,0x7ae60091,0xee3700ce,0x4c6a00cf}},	//   anau, _vykt, _юнь_, _дион_
  { {0x8b2600d0,0x69de00d1,0xd8390033,0xdce5006f}},	//   _одне, rope, зэі_, _zohľ
  { {0x46ea00d2,0xfaa60033,0x86c60067,0x3207002a}},	//   оден_, _жамо, ويان, _liny_
  { {0x69de00d3,0xd6170058,0xe67700d4,0x0000006a}},	//   pope, وتوا_, _aţâţ,
  { {0x644a00d5,0x645800d6,0x5ee9004f,0xaac50058}},	//   tufi, ttvi, הַצְ, _ستُن
  { {0xd90d0086,0x84380029,0x645800cb,0x799c0034}},	//   _ایم_, أكبر_, utvi, _iorw
  { {0xc27400d7,0xb8d2000b,0x7469005e,0x02a600d8}},	//   елиј, टन_, ярів_, дром
  { {0x6aa400d9,0x026a005e,0xd7570015,0x870b000a}},	//   nyif, іший_, _تلقت_, _וּבֶ
  { {0xb5aa0029,0xc1780091,0x680c0061,0x569b000a}},	//   _بارك_, udė_, _eşde, _וימצ
  { {0xc1780007,0x61e800da,0x799c00db,0xa1b70015}},	//   rdė_, rldl, _morw, بطيء_
  { {0xdce5002c,0xd5c80016,0x73360015,0xdfd10067}},	//   _pohľ, iềm_, _آرائ, ايح_
  { {0x69cb00dc,0x799c00dd,0x7bdf00de,0xc3fb000a}},	//   égek, _oorw, voqu, _ולאש
  { {0x290700df,0x6c1b0015,0x6282007c,0x799c00e0}},	//   žnai_, قترح_, _iroo, _norw
  { {0x7bcd0007,0x7bdf00e1,0xd13900e2,0x3a2b00e3}},	//   tnau, toqu, _ххі_, _swcp_
  { {0x628200e4,0x442c0034,0x26ee000b,0xc8d90065}},	//   _kroo, _mwd_, _जरूर_, _बुगट
  { {0x2aab0036,0x8ff80086,0xa3d6005d,0xdee700e5}},	// [090] цтво_, _ترور_, _सदन_, _تأثي
  { {0xf99300e6,0xdb0d0003,0x799c00e7,0x9a36005e}},	//   خبر_, chaî, _corw, вiти_
  { {0x200900e8,0x1dd80015,0x7bdf00e9,0xddcd0091}},	//   _kiai_, _تبيع_, poqu, _kraž
  { {0xa6350036,0xacfa000a,0x3b270015,0x9989006f}},	//   енді, _מהתכ, _تعدّ, dsať_
  { {0x799c00ea,0xcfb8000a,0x68e7002a,0x2bb6000a}},	//   _forw, ולאי_, _wyjd, _נפשך_
  { {0xba430007,0xc58b0080,0x799c0026,0xc86700eb}},	//   žįst, ющее_, _gorw, _отби
  { {0x645c0020,0xc01c0092,0x76590026,0x98140015}},	//   _äril, rước_, stwy, _لبقا
  { {0x58050029,0x6f0d00ec,0xf3f10015,0x628200ed}},	//   _أورك, _ngac, دأت_, _broo
  { {0xc6740015,0x628200ee,0x6b9d00ef,0x85b90099}},	//   _لطلب, _croo, _mosg, _елас_
  { {0x69c50084,0x7c3a00f0,0xe5c400f1,0x95d8004a}},	//   nihe, štri, _исхо, _ждут_
  { {0x69c500f2,0xf99200f3,0x3cf9000b,0x60e900f4}},	//   iihe, ארי_, ंधों_, ямом_
  { {0x43840015,0x3207002a,0x04c80015,0x547a000a}},	//   _للمق, _winy_, _تومي_, _מטעו
  { {0xee3700f5,0x628200f6,0x3207003e,0x69c5008c}},	//   ння_, _groo, _tiny_, kihe
  { {0x63a900f7,0x0000006a,0x0000006a,0x0000006a}},	//   lken,   ,   ,
  { {0x61d60008,0xe3c90016,0x20090030,0x69c50034}},	//   _אוסף_, hằm_, _fiai_, dihe
  { {0xebe30036,0x20090092,0xddcd0007,0x61e1008c}},	//   госп, _giai_, _graž, loll
  { {0x799c00f8,0x661c00bd,0x7bc4007c,0x6b630033}},	// [0a0] _porw, _črko, riiu, ыкта
  { {0xf2d200b2,0x61e100f9,0x63a900fa,0x0000006a}},	//   װעב_, noll, hken,
  { {0x7c960029,0x799c00b8,0x9f7a000a,0x6ab6002a}},	//   _أشخا, _vorw, ּנְח, szyf
  { {0xf4f30036,0x69c500f2,0x1bba00e5,0x8c1b000a}},	//   _якiй_, aihe, _راجع_, _מוטי
  { {0x63a900fb,0x99800007,0xe7b3002b,0x7d110046}},	//   dken, usių_, دمند, řesň
  { {0xcb0a002b,0x63a900fc,0xc6f700fd,0x61e100fe}},	//   _ويگن_, eken, хніх_, joll
  { {0x61e100f2,0xb1980092,0x186700ff,0x443a0030}},	//   doll, _nhưỡ, _пари_, ép_
  { {0x62820100,0x645c007c,0x61e1008c,0x63a90101}},	//   _proo, _ärim, eoll, gken
  { {0x81c6006b,0x61e10102,0x6d410052,0x66080103}},	//   ещне, foll, ólak, _tidk
  { {0x7abb0008,0xf6090015,0xc223002b,0x26890015}},	//   פציו, _قتله_, اکنو, _تخفي_
  { {0x69cb00dc,0x79b70053,0xddcd0104,0x316c003d}},	//   égei, גליד_, _praž, redz_
  { {0xd4690029,0xd3790036,0x657a0105,0x62820106}},	//   _تحكم_, _очі_, _hath, _troo
  { {0x71a6008f,0xddcd0107,0x657a0108,0x61e10109}},	//   _падз, _vraž, _kath, boll
  { {0xd12f0074,0x40940029,0x61e1010a,0x01640015}},	//   _همه_, _للتر, coll, _شُعَ
  { {0xddcd010b,0xfbd3002b,0x657a010c,0x6b9d010d}},	//   _traž, هتر_, _math, _posg
  { {0x657a010e,0xddcd005a,0x0000006a,0x0000006a}},	//   _lath, _uraž,   ,
  { {0x3df5010f,0xef640063,0xb955006b,0x657a00da}},	// [0b0] _изис, _също, кващ, _oath
  { {0xdb0d002d,0xc4b0000b,0x3eb30061,0xd9440054}},	//   mhaí, जनाओ, ıntı_, леђи
  { {0xf84b0010,0xd64d0033,0x71d7000a,0xda080021}},	//   ячай_, _вiле, עובד_, ريمه_
  { {0x2eab000a,0x07a4005e,0xdc88000a,0x0000006a}},	//   ּשַּ, лаєн, _נְתָ,
  { {0x8b9a0008,0xf6530029,0x64c9000b,0xcb36000a}},	//   _חברת, ائص_, िप्श, _בארי_
  { {0x65940036,0x657a0110,0xb6a2004a,0xd5e5006b}},	//   лачу, _cath, ришл, ъжли
  { {0x69d50111,0x657a0112,0xad1c000a,0x61e10113}},	//   _ijze, _dath, לוגר, voll
  { {0x68e300b8,0xc1780007,0x657a002d,0xe4c80015}},	//   ündu, klės_, _eath, عبون_
  { {0x657a0114,0x853c0007,0x7d0800dc,0xd5fb0016}},	//   _fath, _plėt, _kérü, _trù
  { {0x36040029,0x92640115,0x657a0116,0x61e1008c}},	//   _موقف, اديم, _gath, uoll
  { {0xddcd002a,0x9f420046,0x63a900aa,0xc1780091}},	//   _draż, elká_, pken, elės_
  { {0x61e100f2,0x43740117,0x0000006a,0x0000006a}},	//   soll, _бушт,   ,
  { {0x7dc60015,0xc73a000a,0x63a60118,0x61e10119}},	//   نتسك, ותרת, ökne, poll
  { {0x6145011a,0xddcd002a,0xdd920015,0x67f8005a}},	//   _река, _graż, جوس_, míje
  { {0xb0240023,0xfce6011b,0x84ac000a,0x1fb6011c}},	//   _trườ, тово, ִימִ, _аспр
  { {0x1e86011d,0x8e4a0058,0x5ed60058,0xbb43011e}},	//   _алим, _قلبك_, _لتخز, иеск
  { {0xc332011f,0x7f7700f3,0xdcfe003d,0x49ba0015}},	// [0c0] יון_, _יעקב_, _kopī, وائد_
  { {0xa96a0015,0xadfa0015,0xe9d70120,0x2d950121}},	//   ظمام_, _تربط_, вку_, _брюс
  { {0xde890086,0xdd050011,0x657a0122,0x6d8b000a}},	//   _قضیه_, ăsăt, _rath, _חָכְ
  { {0xe3b80064,0x62840007,0x7bda0003,0xb09a004c}},	//   _atın_, _šiom, étud, ויער
  { {0x66730015,0xfecd000a,0x0af60033,0x657a010c}},	//   لدور, ּמוּ, _шчоў, _path
  { {0x7c3a002c,0x645c0020,0xa2d5000b,0xe4e6005e}},	//   štru, _ärik, _बख़्, кійн
  { {0xd4670001,0x397b000a,0xe5a30054,0x629d0123}},	//   вије_, _קטלנ, рији, äson
  { {0x07a30124,0xe76a0015,0x853c0091,0xdb040125}},	//   _касн, _تحسن_, _plės, dhiú
  { {0xa66500e5,0x657a0126,0xe284009a,0x0000006a}},	//   _مطلو, _tath, اطبی,
  { {0x601e0048,0x657a002f,0x90980004,0xd5fb0016}},	//   _līme, _uath, евот_, _trú
  { {0x9f350127,0x8937000a,0xdb040030,0x8f350128}},	//   лені, כריע_, ghiú, ленц
  { {0xdb0d002f,0xddcd005c,0x67f80046,0x1fa70129}},	//   thaí, _wraż, bíje, трог
  { {0xf773000a,0x7c22006f,0xd345002b,0xecdb000b}},	//   בקר_, _čora, _صفوی, _मुजफ
  { {0xdcf50024,0xc237000a,0x3134012a,0x0000006a}},	//   edzā, _ירדו_, _секр,
  { {0xa3d6000b,0x3ead0046,0xc1780091,0x9d18012b}},	//   _सदा_, šet_, slės_, тост_
  { {0x644a002d,0x6bd40015,0x7d080030,0xc1780091}},	//   irfi, لتقر, _sérü, plės_
  { {0x62840007,0xdd910029,0xba550015,0x8ae7005e}},	// [0d0] _šioj, _هوة_, طناع, тівл
  { {0x23b1002c,0x9935012c,0xa907002b,0x3ea40123}},	//   _mája_, افات, نبان, ämte_
  { {0x98140029,0x2907012d,0xadd6000a,0x09070033}},	//   لبنا, äna_, _תותח_, тчам
  { {0xc864012e,0x8c1a000a,0x4735012f,0x0000006a}},	//   ртфи, _רורי, ундс,
  { {0x644a0130,0x7bda0003,0x9f440003,0x75ed0030}},	//   erfi, étue, ômé_, lúzi
  { {0x27310023,0x601e0024,0x6d550131,0xf483002b}},	//   ạn_, _zīme, ngza, لاعی
  { {0x87db0086,0xe8940080,0x2c37000a,0x19580132}},	//   _قبرس_, _карь, דָ֖ם_, _шары_
  { {0xb8f7000b,0xe3e9002b,0x29070091,0x58d40133}},	//   ाप_, رکان_, žnas_, _тост
  { {0x443e0134,0x3878005c,0x11e5006b,0x68fa001a}},	//   _evt_, _zsrr_, лжим, _útdr
  { {0xc5b9000a,0x67f8006f,0xdb040125,0x05770015}},	//   _אֶ֣ר, ríje, thiú, _جارد
  { {0xcea90135,0x8fa60136,0xf992000a,0x9fca0137}},	//   _צי_, гане, צרט_, егна_
  { {0xa8a8000a,0x99de0138,0x261900a1,0x0000006a}},	//   דֹשִ, бiла_, _kèo_,
  { {0xe1ee0139,0x2bc6000b,0xe7f6000b,0xc7d6004f}},	//   _гг_, रोफा, ेषता_, רורי_
  { {0x26190016,0xd00e002b,0x2bc60065,0x0000006a}},	//   _mèo_, _کلي_, रोना,
  { {0x225f00dc,0xec160018,0x90e4002b,0x26190016}},	//   ltuk_, اورد, _پسون, _lèo_
  { {0xc052013a,0x8b08005a,0x7538013b,0x0000006a}},	//   _הזה_, jpří, zavz,
  { {0xdd040064,0x225f013c,0x5b350033,0x6fb30015}},	// [0e0] ırıs, ntuk_, рэсу, _دميا
  { {0x6e240064,0x5ebb00a3,0x8b080046,0x62840091}},	//   _itib, _נזיק, epří, _šiok
  { {0x601e0048,0x3136004c,0xad1b000a,0xddc6002a}},	//   _tīme, רנעם_, _רוטר, pukł
  { {0x645c0020,0xbddb0003,0x07e50033,0x48130033}},	//   _ärii, quèr, ацім, ёміс
  { {0x47330036,0x7f3b000a,0x225f0030,0xe5c6013d}},	//   сніс, תענו, jtuk_, лско
  { {0x28160086,0x225f00dc,0x4edb0053,0x8b080089}},	//   _موسس, dtuk_, ײַדנ, apří
  { {0xf8780008,0xb4660015,0x3545008b,0xa96700ce}},	//   _בְּל, ادته, рхів, _щира_
  { {0x5c37004c,0x722a013e,0x9f42013f,0x7f440140}},	//   ארקן_, нцов_, boké_, _ndiq
  { {0x85560031,0xd2140054,0x27e60141,0x0000006a}},	//   _مخاط, јмоћ, moon_,
  { {0x104a0142,0x27e60143,0x98a7002a,0x9a420016}},	//   нями_, loon_, źną_, _đẳn
  { {0x2a600020,0x6e24003f,0x2508002b,0x645e0144}},	//   htib_, _atib, _شرطی_, àpid
  { {0x27e60145,0x41b4002b,0x2366013b,0x0000006a}},	//   noon_, امگر, _uboj_,
  { {0xf1940146,0x63a20147,0xf1f7002b,0x62340148}},	//   _виль, _ioon, ضعیت_, _телу
  { {0x63a20020,0x3cb50010,0x27e60149,0x2002002a}},	//   _hoon, айгр, hoon_, amki_
  { {0x63a20020,0x27e6014a,0x14d8004f,0x0000006a}},	//   _koon, koon_, דַּמ,
  { {0x63a20020,0x764b0026,0x3013006b,0x27e6014b}},	//   _joon, yrgy, _удър, joon_
  { {0x63a2014c,0x1a5b0015,0xc987014d,0xdb240030}},	// [0f0] _moon, عشرة_, лужи, árár
  { {0x7e6d00b6,0x2bc6014e,0x60d30024,0x2618000b}},	//   _ipap, रोबा, ņemš, _पढ़ी_
  { {0x6d45003f,0x225f014f,0x27e60150,0xe8590151}},	//   _idha, ztuk_, foon_, таеш_
  { {0xbddb0152,0xd5b60001,0xd5c80092,0x63a20035}},	//   ssèd, cикл, iều_, _noon
  { {0xbb3a009d,0x69cb00dc,0xe6c7002b,0x959500ce}},	//   _בערי, éges, دتاي, ишкі
  { {0xd5bb0010,0xce38000a,0x75ed0030,0x94750015}},	//   эсе_, נאות_, húzv, لدبا
  { {0x05760015,0x63a20153,0x9f420154,0xd5380058}},	//   شمية_, _boon, soké_, اثها_
  { {0x225f00dc,0xdb040030,0xc2450155,0x86570015}},	//   ttuk_, lkiá, аник, _مخطئ
  { {0x6d450156,0xc7b2000a,0xa3d60157,0x63a20158}},	//   _odha, _ובן_, _सदर_, _doon
  { {0xf4850086,0x6d45003f,0xd2680015,0x1306004a}},	//   _پائی, _ndha, اصين_, шный_
  { {0x229a00df,0x40490063,0x225f0159,0x7e6d015a}},	//   ešką_, ъпно_, stuk_, _apap
  { {0x225f00dc,0xa856000a,0xc49a015b,0x6d45015c}},	//   ptuk_, סירה_, _בשעת, _adha
  { {0x7c25015d,0x69c70085,0x0000006a,0x0000006a}},	//   _athr, _omje,   ,
  { {0xb2ba000a,0x63a2015e,0x291f0061,0x82d6000a}},	//   _שמסר, _zoon, _şuan_, _דונג_
  { {0x41740074,0x30790053,0x40790053,0x2d840089}},	//   _دانس, _יאַנ, _יאַװ, ěme_
  { {0x4b260010,0x63a2015f,0x69c70160,0x2a600072}},	//   рмав, _xoon, _amje, ttib_
  { {0x9a250029,0xfd1200a2,0x2a360033,0xba23006b}},	// [100] معلن, _وجد_, рэбр, ждук
  { {0x1e3b013a,0x64410089,0x27e60161,0x96df0033}},	//   _שגיא, _ovli, woon_, _лiку_
  { {0xa3e5005d,0xb607003d,0xe73a0162,0x27e60163}},	//   पका_, _mašī, вее_, toon_
  { {0xd8230036,0x78a300f2,0xd62a0164,0xc6a60165}},	//   ідчи, änva, воде_, ирли
  { {0x27e60166,0x6d41002e,0xfc480046,0x64410167}},	//   roon_, ðlag, říč_, _avli
  { {0x36190010,0xa4f8002b,0x224d007c,0xef1f0061}},	//   уццю_, هکار_, drek_, zcü_
  { {0xb7960001,0x94230054,0x27e60168,0x224d0169}},	//   _краћ, омје, poon_, erek_
  { {0x987b015b,0x67f8006f,0x3266016a,0xdb0d0072}},	//   _באלט, bíja, атов, aiaõ
  { {0xfbb70008,0xe57a0001,0xf6690002,0x64410061}},	//   יפקת_, _иза_, _محله_, _evli
  { {0x2bc6005d,0x63a2016b,0x865b000a,0xdce7002a}},	//   रोता, _woon, _בדמי, leją
  { {0x09f70008,0x3d1d000b,0x55bb000a,0xd0100015}},	//   שמים_, _मलबे_, _שמבו, ثلج_
  { {0x3f80001c,0xc477000a,0x9f530061,0x224d016c}},	//   _caiu_, _כתבו_, _ödül_, brek_
  { {0x539b0008,0xef1f0061,0x6253016d,0x0000006a}},	//   _שידו, rcü_, ržoá,
  { {0xdb0d016e,0x3ea40123,0xc534000a,0x38610034}},	//   lhaç, ämta_, מָֽה_, ythr_
  { {0xab950124,0x51fb0008,0xd138005c,0x81fb000a}},	//   бављ, _שהוצ, ając_, _שהוז
  { {0x69c7016f,0xbf350063,0x5b150170,0x309b000a}},	//   _smje, _унищ, смат, _ישומ
  { {0x2bc6000b,0x3377000a,0x6d41001a,0xa9270058}},	// [110] रोधा, סתמך_, ólas, لعاه
  { {0x6d45003f,0xdcb10092,0x28870054,0x8ae40033}},	//   _udha, ở_, ићев, цісл
  { {0xcd760008,0x4dda0008,0xa34c0091,0x0c840033}},	//   _העתק_, _תחתו, dėžė_, _дыям
  { {0x2d8300dc,0x44250171,0xc60f000b,0x93bc0045}},	//   ldje_, _rtl_, ाद्य_, _stăn
  { {0x2d810020,0x7bcd0007,0xe758005e,0x61e80172}},	//   _kahe_, miau, ричі_, kodl
  { {0x85e80036,0x69c7016f,0x7bcd0007,0x09e40010}},	//   адів_, _umje, liau, _моўн
  { {0x23b10014,0x2db8000a,0xf773002b,0x6498006b}},	//   _fájl_, שלון_, _وار_, итър_
  { {0x2d810020,0x7bcd0173,0x9cd8000a,0xe3b10015}},	//   _lahe_, niau, יווה_, ثرت_
  { {0x27ed0061,0x61e80034,0x46150015,0x11390174}},	//   _iken_, fodl, _طوار, ляны_
  { {0x2d8100b8,0x224d00dd,0x3f80001c,0xb5fd0007}},	//   _nahe_, rrek_, _saiu_, _apšv
  { {0x7bcd0007,0x600a0175,0xa0690054,0x81a40015}},	//   kiau, лном_, ћама_, تحيل
  { {0x25a50176,0x224d0177,0x1fb6004a,0xa4f6000a}},	//   _holl_, prek_, ссор, _הצעד_
  { {0x73c40029,0x21690178,0x4ac7005d,0x25a50179}},	//   _بينم, _били_, _रेलव, _koll_
  { {0x2d83016f,0x4126017a,0xdce7002a,0x8e750138}},	//   gdje_, _лошо_, zeją, цуюч
  { {0x645c0020,0x27ed017b,0x6c360015,0x0136000a}},	//   _ärit, _oken_, إفرا, _הרצת_
  { {0x7bcd0007,0x8b95017c,0x802400e6,0x7fc50015}},	//   giau, оруч, _بروم, _وآيل
  { {0x39460010,0xe9da017d,0x63bb0012,0xef22002a}},	// [120] йнаг, гка_, ihun, ążą_
  { {0x25a500c0,0xbdfa0015,0xb9c50015,0x2fc900bc}},	//   _noll_, _حربا_, يتله, _zmag_
  { {0x6c86003b,0xddd60007,0x7bcd0007,0xe4640061}},	//   _الجم, _kryž, biau, ülüğ
  { {0x27ff017e,0xb73a0029,0xe7e9017f,0x7bcd0003}},	//   _chun_, اثاء_, афік_, ciau
  { {0x67630029,0x66e60036,0x95ca0180,0xd7ef0015}},	//   سُول, щода, лука_, ركه_
  { {0x63bb00b8,0x7a410089,0x27ed0181,0x4e7b004c}},	//   ehun, sátý, _eken_, טאנצ
  { {0x628b0182,0x29cf003d,0x6e360034,0x61e80183}},	//   _argo, aļas_, _lwyb, vodl
  { {0xb8cc000b,0xe44f0015,0x29150061,0xcb12000a}},	//   गह_, رضى_, ğdaş_, ּל֙_
  { {0xd130003b,0x1a9a00b2,0xdb9b004c,0x61e80061}},	//   ومة_, ריִע, רספר, todl
  { {0x361b0008,0x25a50026,0x15430184,0xf991000a}},	//   _עובד, _goll_, _неум, ֵ֨י_
  { {0x63bb002d,0x9f990185,0xa99b004c,0x2d830085}},	//   bhun, авну_, אביר, vdje_
  { {0xf8b3013a,0x753a0186,0x63bb0187,0x6b840079}},	//   פשר_, _hetz, chun, jdig
  { {0x61e80188,0x753a0012,0x7bcd00cd,0xddc400bf}},	//   podl, _ketz, viau, _spiš
  { {0x753a00b8,0x645c0020,0x52d7000a,0x0dc80189}},	//   _jetz, _äris, _פוגע_, буси_
  { {0x2d810020,0x7bcd018a,0x2d19000b,0xe0d30054}},	//   _vahe_, tiau, _दलील_, _ношњ
  { {0x753a018b,0xddc4018c,0x2636002a,0x5ba4018d}},	//   _letz, _vpiš, kło_, пруз
  { {0x6e360176,0x7bcd018e,0xaa59018f,0x2d81007c}},	// [130] _gwyb, riau, ризу_, _tahe_
  { {0x753a018b,0x2636005c,0x79c80029,0x7bcd0007}},	//   _netz, dło_, موقف_, siau
  { {0xddc4016f,0x90d50092,0x2636002a,0x27ff0016}},	//   _upiš, hàn, eło_, _phun_
  { {0x25a5018b,0xd6d10015,0x2bf40033,0xaa950190}},	//   _soll_, وقا_, _няўр, _димч
  { {0x95990191,0xb5fd010b,0xe7380010,0x2636005c}},	//   итку_, _opšt, сеі_, gło_
  { {0x5e580008,0x5c8b0008,0x7afd0192,0xe918005e}},	//   מידע_, ָאֵ֔, _izst, _горі_
  { {0x4d5c0053,0x799500b8,0x2636005c,0x25a500b8}},	//   אדוצ, _inzw, ało_, _voll_
  { {0x27ed003c,0x213e0193,0xe795002b,0xd36e0015}},	//   _uken_, eath_, _باسک, نهى_
  { {0x25a50100,0xdcfc003d,0x11890015,0x63bb0194}},	//   _toll_, idrā, لَةً_, rhun
  { {0xdb1d001a,0xc5fb0015,0x50450195,0x61420046}},	//   _umsæ, _إعرض_, оеоб, vílí
  { {0xc952013a,0x00e2008f,0xc0580010,0x3205003e}},	//   ומי_, джэн, біў_, rmly_
  { {0xe3b30196,0x661b0197,0x92950010,0x628b0198}},	//   _عرض_, _kuuk, _маец, _trgo
  { {0x645c0020,0x644300c0,0x333f0152,0x61450199}},	//   _ärir, lsni, maux_, _дела
  { {0x1167002b,0x661b019a,0x90d50021,0x6443019b}},	//   _طلبی_, _muuk, _وآثا, osni
  { {0x8fa6019c,0x70520029,0x1dbb000b,0x2636002a}},	//   _маке, _قنوا, _उतरत, zło_
  { {0x333f0152,0x2636005c,0xab660010,0x601e0024}},	//   naux_, yło_, ўвал, _zīmo
  { {0x49ca0001,0xba290029,0xbab60033,0x99630046}},	// [140] алан_, مسلم_, цёвы, líři_
  { {0x6b84019d,0x6443019e,0x0000006a,0x0000006a}},	//   sdig, ksni,   ,
  { {0x2d95008f,0x3e6400f2,0x9c660015,0xc7d0004a}},	//   _хрыс, löt_, _بهجو, е́ни
  { {0x753a00b8,0x08090015,0x6443019f,0xf989000a}},	//   _setz, مزني_, dsni, כר_
  { {0x96b70001,0x3e6401a0,0x96330010,0x7c2e00dd}},	//   жују_, nöt_, дніц, lpbr
  { {0x27380023,0xc7b900dc,0xd6390036,0x64430134}},	//   ẩn_, _elő_, сяці_, fsni
  { {0x26360050,0x644301a1,0xe73a01a2,0x291801a3}},	//   sło_, gsni, _веб_, _igra_
  { {0x8c1b0008,0x6d5c0026,0x889b000a,0x66e601a4}},	//   סופי, hgra, _דבלי, _доба
  { {0x82a60010,0xd6250029,0xf1aa00c3,0x644301a5}},	//   юшке, _فعلي, لاده_, asni
  { {0x62840007,0x71740029,0xfa97000a,0xa1580054}},	//   _šios, أهدا, קדיש_, љану_
  { {0xdfd100e6,0x79fb000a,0x333f0003,0x6d5c01a6}},	//   فيد_, שליח, baux_, dgra
  { {0x442e00b8,0x333f0152,0x4fc70010,0x74130015}},	//   mpf_, caux_, існа, _قولا
  { {0x22940063,0x8d770015,0xdefb0033,0x9f4e0030}},	//   _хиля, ياسا, рын_, ónál_
  { {0x64580089,0xe2a90086,0x6d5c01a7,0x201801a8}},	//   ouvi, _دامن_, ggra, íris_
  { {0xe0d40053,0x60210024,0x2ba7009c,0x5ba701a9}},	//   _מײַ_, _tēma, ојав, ораз
  { {0x3f850024,0xc0530008,0x6d5c01aa,0xcfe90115}},	//   ēlus_, _חזק_, agra, _دفعه_
  { {0x201c0020,0x0a150015,0xaa55006b,0x6443003d}},	// [150] _huvi_, سواح, яваш, zsni
  { {0x644301ab,0x645800f2,0xdce7005c,0x1a580015}},	//   ysni, kuvi, zeję, تشفة_
  { {0x7d7a0008,0xe7190029,0xf8b1002b,0x333f0003}},	//   _הנתו, ميات_, رکس_, yaux_
  { {0x6c7a0053,0x5c7a0053,0x644301a7,0x7f5d0012}},	//   _פארפ, _פארה, vsni, ngsq
  { {0x7afd0048,0x333f0152,0xcb9a0008,0xcdd5000a}},	//   _uzst, vaux_, _הסרט, ֔ךְ_
  { {0xae7c0008,0x3d19005d,0xae5801ac,0xca36000a}},	//   שְׁת, _दलों_, קסוס_, _מנשה_
  { {0x8cd1005d,0xe3b10029,0x333f0152,0x645801ad}},	//   _डेमो, فرة_, taux_, guvi
  { {0x644301ae,0x8cdc000a,0xdb1d0012,0x3e64008c}},	//   rsni, יחות, _umsä, yöt_
  { {0x333f0152,0x644301af,0xfa6b000a,0xb6350015}},	//   raux_, ssni, ׁכֵּ, _رفاع
  { {0x644300df,0x7abc0008,0x23b1006f,0x64580091}},	//   psni, יצחו, _máji_, buvi
  { {0x645c0020,0x333f0152,0xc9520053,0x602501b0}},	//   _ärip, paux_, עמט_, ядна
  { {0xb4fa0008,0x34fa000a,0x3e64008c,0xa3b4005e}},	//   _הפעי, _ההעד, töt_, _обхі
  { {0x3fc90086,0x9756000a,0xcaea000b,0x6d5c01b1}},	//   تگوی_, הירו_, _झुंड_, tgra
  { {0xda1f000b,0xd184005e,0x91f70058,0x0000006a}},	//   _बढ़त_, _олій, _بأصا,
  { {0x3e6400f2,0x31560053,0x9f9201b2,0x2b4001b3}},	//   söt_, _זיצן_, lší_, taic_
  { {0x6d5c01b4,0xba260033,0x9f42005a,0x3a26004e}},	//   sgra, здак, boká_, змаг
  { {0x6e46003b,0x9f920107,0x2b4001b5,0x2bad000b}},	// [160] _عندم, nší_, raic_, _टकरा
  { {0x2b4001b6,0x67f8006f,0x48e601b7,0x7c2e01b8}},	//   saic_, ríjm, позв, ppbr
  { {0x7d7b000a,0x9d1b015b,0x9f92006f,0x7d37000a}},	//   _פנטו, _לויט, hší_, _מניב_
  { {0x7872002e,0x4c9b000a,0xdc9b000f,0xd70a004a}},	//   _aðvö, _הבטו, _היטל, бнее_
  { {0x9f920107,0x9b17000a,0xeb91000a,0x28de0065}},	//   jší_, _מחכה_, _בָם_, _मशवि
  { {0x8afb0008,0xbafb000a,0x645801b9,0x9f92013f}},	//   _להכי, _להכש, tuvi, dší_
  { {0xdd570053,0x69ce01ba,0x986c003d,0x0ee90065}},	//   לבסט_, _imbe, rķēt_, _ऐड्स_
  { {0x7d0701bb,0xc8db000a,0xb7da002b,0xf2c6005e}},	//   léré, _הקלט, _اورا_, зсон
  { {0x201c01bc,0x645801bd,0x326600ce,0x518600af}},	//   _suvi_, suvi, їтив, пуна
  { {0x7d070152,0xb6bb000a,0x645801be,0x9f420046}},	//   néré, _הצמי, puvi, voká_
  { {0xf9930008,0x9f920089,0x601e0024,0x89eb000a}},	//   גרת_, aší_, _zīmj, מַטֵ
  { {0x78fb0053,0x60280089,0xb4fb0053,0x09b9000b}},	//   מפיו, _něme, _פלאר, _इत्य
  { {0x7d0700dc,0xc7b3000a,0x69ce01bf,0x7e7d0079}},	//   kéré, גבר_, _ombe, uwsp
  { {0x127b004c,0xc27b000a,0x527b000a,0x9f4201c0}},	//   _לאדע, _לרדי, _לנדא, roká_
  { {0x7d070152,0x4094002b,0x9f420057,0x6b8601c1}},	//   déré, _آلبر, soká_, _bakg
  { {0x60db000a,0x442c01c2,0x50db000a,0x69ce01c3}},	//   _לקונ, _mtd_, _לקוא, _ambe
  { {0xdcf20024,0x7d0701c4,0x6a1501c5,0xda7801c6}},	// [170] īgāk, féré, дмау, зях_
  { {0xceb20053,0xdebc000a,0x99d70015,0xbef80021}},	//   _סיי_, _למחל, أترا, _عريض_
  { {0xf1b30053,0xdcee0011,0xa3be000b,0x3137004c}},	//   עסע_, rebă, ीफा_, פראך_
  { {0x256f0064,0x69ce01c7,0x5a470033,0x9f920046}},	//   zılı_, _embe, _нэга, yší_
  { {0xeafa005d,0x1a940010,0x442c0089,0x256f0064}},	//   ्धृत_, _заяў, _atd_, yılı_
  { {0xcb1201c8,0x93b50023,0x9f9201c9,0x95c50015}},	//   _שלך_, _cũn, vší_, بيته
  { {0x628200dd,0xf992000a,0x9f420046,0x659201ca}},	//   _asoo, _ברם_, elký_, тају
  { {0xdcfe0024,0x9f9201cb,0xd347002b,0x442c01cc}},	//   _japā, tší_, سیته_, _dtd_
  { {0xa3be005d,0x256f0064,0xa3cc000b,0x1c1f000b}},	//   ीफ़_, tılı_, रफ़_, _मूसल_
  { {0xdcfe0048,0xab5b00b8,0x9f920107,0x98ba003d}},	//   _lapā, _flüg, rší_, lapā_
  { {0xd371003b,0x4105005f,0x256f0064,0xc0580010}},	//   _لها_, ьзов, rılı_, піў_
  { {0x256f0064,0x22520064,0x9f920107,0xdcfc0091}},	//   sılı_, ünkü_, pší_, ndrą
  { {0xa294017f,0xee3700a4,0x1efa0015,0x0eba0033}},	//   _паці, мня_, تعدة_, іумы_
  { {0x79870050,0x6e2d002d,0x63ab01cd,0x0000006a}},	//   _najw, _dtab, _hogn,
  { {0x2c870089,0x80240015,0x9b960067,0x7d0701ce}},	//   vídá_, _كريم, ولست, véré
  { {0x70760086,0xeb9701cf,0x672901d0,0x0000006a}},	//   _آميز_, мис_, _nfej,
  { {0x63a601d1,0xc9aa0010,0x7d0701bb,0xfe720015}},	// [180] ökni, овае_, téré, _شدة_
  { {0xc8d60015,0x0000006a,0x0000006a,0x0000006a}},	//   وزاع,   ,   ,
  { {0x07a6004a,0x1d0a0004,0xa2d4000b,0x2a69007c}},	//   мажн, _фени_, _बेन्, atab_
  { {0x7d070003,0xe73701d2,0x2d8a01d3,0x0000006a}},	//   séré, дец_, ldbe_,
  { {0x47330036,0x7d070152,0x442c01d4,0x0000006a}},	//   тніс, péré, _std_,
  { {0x2d8a0030,0x69ce01d5,0x442c01c2,0xf2020065}},	//   ndbe_, _umbe, _ptd_, _रीढ़_
  { {0xd75a0015,0xd823006b,0x644d003d,0xe4b80138}},	//   _ولست_, _адси, ņain, ялкі_
  { {0x8c1b000a,0xdc89000a,0x63ab01d6,0x57460058}},	//   חוקי, לְפָ, _cogn, _زخرف
  { {0x5313002b,0x03a7002b,0xa2940033,0x6ac7000b}},	//   پذير, بگلو_, хапі, _रेफ़र
  { {0x60280089,0xea9b004c,0x442c01d7,0x2508002b}},	//   _němc, קסיש, _ttd_, _فرضی_
  { {0x19570008,0x63ab00dc,0xf9570008,0x395701d8}},	//   וביל_, _fogn, וסית_, ושים_
  { {0xe29a01d9,0x33930029,0xd36f0086,0x6282007c}},	//   _мае_, _للمز, _نهم_, _tsoo
  { {0xc333000a,0x81a60015,0x31c601da,0x0000006a}},	//   _סוס_, _يحتل, _оскв,
  { {0xe0cf0074,0x12fb0008,0x0000006a,0x0000006a}},	//   ازی_, _והדב,   ,
  { {0xdb060014,0x415b000a,0x515b000a,0xfbab0033}},	//   _elkü, _ודוג, _וכוו, отай_
  { {0x9fe70029,0xcf270040,0x648b000a,0x2cac0123}},	//   _تسته, _غربي, חְמְ, ädda_
  { {0xdd95008f,0x9e070036,0x6e2d003f,0xef1f0061}},	// [190] _запы, _очол, _utab, ndüm_
  { {0x89340015,0x3df4004a,0x6f000061,0xb45e00af}},	//   نعما, _изыс, ümce, _боxо
  { {0x2a690005,0x917b0023,0x2251005c,0xf84b0033}},	//   stab_, _hệ_, ązki_, ючай_
  { {0xf093000a,0xaad0000b,0x957c002a,0x3ec4007f}},	//   כנע_, _सेवक, _skąp, _örtü_
  { {0xcb36013a,0xc5f5006b,0x7987002a,0x63ab01db}},	//   _ראשי_, някъ, _tajw, _rogn
  { {0x659401dc,0xd7c9002b,0x05790015,0x63ab01dd}},	//   качу, _کوره_, سمعة_, _sogn
  { {0x917b0023,0x6d3c0008,0x577b0015,0xd9140033}},	//   _lệ_, חתונ, _وصرح_, _адры
  { {0xd2a9004a,0xe3b100c3,0x0d18004f,0x99920138}},	//   зкие_, طرب_, וקוט_, лiзм_
  { {0xd24e00e6,0x614500e2,0x63ab01de,0x7bda0003}},	//   مني_, непа, _vogn, étui
  { {0x15150010,0xd1c6004a,0xd6180015,0xe5070067}},	//   _здзя, елье_, _قتلا_, _قباي
  { {0x672401df,0x833500ce,0x63ab01e0,0xddcb007f}},	//   žije, _знех, _togn, _şişe
  { {0xa856000a,0xdd92002b,0x8fa601e1,0x0000006a}},	//   עירה_, گوس_, хаме,
  { {0xf1a8002b,0xeef50033,0x0000006a,0x0000006a}},	//   سایه_, вярэ,   ,
  { {0x92c101e2,0xd245002b,0x11d70015,0xc0e501e3}},	//   ığın, یچ_, _تتصد, _полк
  { {0xddcd0011,0x61e600dc,0x60a40015,0x6cd6002b}},	//   _spaţ, ékle, _لإيق, رقرا
  { {0xba1a0058,0xfaa60138,0x0000006a,0x0000006a}},	//   كيرا_, набо,   ,
  { {0xc33201e4,0x6e930029,0x3956000d,0xf4120053}},	// [1a0] טון_, _مليا, ењет, רפן_
  { {0xac860083,0xdcfe0011,0x4c8601e5,0x7bdf01e6}},	//   _згол, _capă, _злов, anqu
  { {0xc1720008,0xa81a0087,0xfd120015,0x0d3b000a}},	//   רחב_, ستار_, _حجة_, _מגיב
  { {0xfaa601e7,0xdeba000a,0x999f003d,0xe66601e1}},	//   _замо, ּמַל, āršo_, етко
  { {0xcb150033,0x3c3e0046,0xd5c5005e,0x0000006a}},	//   _афры, lův_, _кiмн,
  { {0xa4d40127,0xe3b80061,0xe5a301e8,0x94d401e9}},	//   колі, _atıp_, личи, колц
  { {0xa3cc000b,0xe44f0015,0x3c3e0046,0x52b80065}},	//   रफल_, مضي_, nův_, इन्स
  { {0xc29800f4,0x7669008c,0xb806009a,0x6f0401ea}},	//   дких_, ösyö, _سبزه, _ozic
  { {0xdac2005e,0x66e301eb,0x280201ec,0x0000006a}},	//   кцiя_, _бота, ārnē_,
  { {0x64a601ed,0xbbad000b,0xb5ca002b,0x2fc00030}},	//   _паза, _टक्क, _عوام_, _alig_
  { {0x8f350010,0x320c0034,0xdb12001a,0x7bd601c2}},	//   кенц, rmdy_, _ágæt, kiyu
  { {0x83360029,0x83690015,0xe457000a,0xf8db000a}},	//   _أراض, _يصنف_, _טיבט_, לחימ
  { {0x82b30086,0xddcd0091,0x2e260034,0x644a01ee}},	//   _محوط, _apaš, _côf_, lsfi
  { {0x9f4b0089,0x917b0092,0xe29b000a,0x09af000b}},	//   mocí_, _vệ_, _משדר, _टवेय
  { {0x661a00f2,0x4c840033,0xdcfc002a,0xef1f0061}},	//   _mitk, ллёв, odrę, ndük_
  { {0xd13800df,0x749b0053,0x917b0092,0x7bdf01ef}},	//   lbą_, הילפ, _tệ_, unqu
  { {0x66d30014,0x4fd80008,0x3ced000b,0xd138002a}},	// [1b0] _műkö, _רוחב_, _आँके_, obą_
  { {0x644a01f0,0x317e01f1,0x661a01f2,0xe89501f3}},	//   ksfi, netz_, _nitk, казь
  { {0x200901f4,0x6d4701f5,0x2fc000cb,0x201b01f6}},	//   _khai_, maja, _ylig_, _épis_
  { {0x18980029,0x6d4701f7,0x7bc401f8,0x661a01f9}},	//   عضلة_, laja, chiu, _aitk
  { {0x6b9d00b8,0x46a40036,0x661a01fa,0xcf2c000a}},	//   _insg, лаїв, _bitk, הֽוֹ
  { {0xab5b00b8,0x6d4701fb,0x6b8d01fc,0xe52e007f}},	//   _flüc, naja, ldag, _güüğ
  { {0xab5b00b8,0x443e00e7,0x69d701fd,0xd49b01fe}},	//   _glüc, _cwt_, mixe, ярд_
  { {0xe65d0064,0x6d4701ff,0x20090016,0x6b8d0200}},	//   ştığ, haja, _nhai_, ndag
  { {0x74120086,0x6b8d0020,0x64580201,0xc6740018}},	//   جويا, idag, arvi, _مطلب
  { {0x27fd0026,0x461500e6,0x93bc0045,0x76590034}},	//   llwn_, _شوار, _stăt, mrwy
  { {0xf992013a,0x6d470202,0x76590026,0xe0d1002b}},	//   ברי_, daja, lrwy, شزد_
  { {0xc3cb0021,0x6b8d0079,0x20090203,0x1fb60204}},	//   _عظام_, jdag, _chai_, тсор
  { {0x93b6013a,0x63a9010b,0xddcd0085,0x76590034}},	//   _שלנו_, mjen, _spaš, nrwy
  { {0x865a0008,0xd2560008,0x6b8d0205,0x63a90206}},	//   ודשי, _ישנה_, edag, ljen
  { {0x2251005c,0xc5f20008,0xf1a8002b,0x6b8d001a}},	//   ązku_, ידך_, _ساوه_, fdag
  { {0x6b8d00b6,0xa00a00e6,0x63a90207,0x3c3e0046}},	//   gdag, _تقبل_, njen, rův_
  { {0x4b230191,0x63bb003f,0x63a9016f,0x6d470208}},	// [1c0] рмув, ikun, ijen, baja
  { {0xfe1e005d,0x63a90209,0x63bb007c,0x76590034}},	//   _यूएस_, hjen, hkun, drwy
  { {0x7659020a,0x8c430064,0x661a00dc,0x63a9020b}},	//   erwy, üşte, _ritk, kjen
  { {0x6e24003f,0x69d70144,0x76590034,0x18670054}},	//   _kuib, aixe, frwy, ђачи_
  { {0x76590176,0x661a00f2,0xcf930135,0x63a9020c}},	//   grwy, _pitk, יטא_, djen
  { {0x69c5020d,0x35f301f3,0xd5af0021,0x64580085}},	//   chhe, апір, يفن_, trvi
  { {0xd5b10092,0x04940015,0xa4d80033,0x76590034}},	//   _tín_, البح, эдку_, arwy
  { {0xfe1e005d,0x64a30001,0x63a9020e,0xe3b20021}},	//   _यूऍस_, раћа, gjen, شرع_
  { {0xfbd3013a,0x20090176,0x661a00dc,0x6d47003f}},	//   יתה_, _rhai_, _titk, yaja
  { {0xa3f50089,0x6feb005c,0x6b8d00dc,0xdcfe002c}},	//   ější_, ięce, zdag, _dopĺ
  { {0xd1380007,0x6d47020f,0x20090016,0xbfd9005e}},	//   rbą_, vaja, _phai_, еднє_
  { {0x63bb00b8,0x317e00b8,0xde590210,0x63a90211}},	//   ckun, setz_, намі_, cjen
  { {0x42540029,0x6d470212,0x8504002b,0x6e240045}},	//   _إنتر, taja, _شوچن, _cuib
  { {0x20d60058,0x3df4009b,0x0000006a,0x0000006a}},	//   _لتعج, изяс,   ,
  { {0x80a30086,0x6d470213,0x0fdb0015,0x621b000a}},	//   _نمون, raja, _يبعث_, _קווק
  { {0x5f770087,0x76590034,0x8117000a,0x5c070214}},	//   _شاعر, yrwy, _בחוג_, тяга
  { {0xf8eb000b,0xf96b0215,0xbf9b00aa,0x69c500da}},	// [1d0] _जुड़ा_, дрей_, glêe, thhe
  { {0x49540015,0x68fc0216,0x79c80015,0x6b8d0217}},	//   لخمس, _byrd, نوقف_, sdag
  { {0xf7950010,0x6b8d0218,0xa2d4000b,0xd7590015}},	//   лажэ, pdag, _बेस्, فلات_
  { {0x76590176,0xfecb000a,0x3dcf002a,0x98b80045}},	//   trwy, ֽמַּ, żową_, _seră_
  { {0x61e10026,0xe7840219,0xe7360054,0xc6a7006b}},	//   ynll, рухо, ћеш_, ържи
  { {0xe6180036,0x66d20064,0xa934021a,0x63bb0079}},	//   вді_, _sıkç, _верш, wkun
  { {0x76590026,0x63bb021b,0x0554005e,0x63a9021c}},	//   srwy, tkun, ртія, tjen
  { {0x93bc0011,0x9f42006f,0x7c2501d7,0x787a000a}},	//   _stăr, sokú_, _muhr, _אָמו
  { {0x63a9021d,0x59b7021e,0x63bb021f,0x66120030}},	//   rjen, _आकार, rkun, ókkö
  { {0x6d4500bd,0xa855000a,0x0574002b,0x7afd0220}},	//   _neha, ְיָה_, _نامد, _myst
  { {0x1c1f005d,0xf1c30007,0x361a0008,0x04670221}},	//   _मंगल_, _ryšį_, _נועד, _штам
  { {0x08760053,0xc43a0008,0xdb060222,0xdb0f016e}},	//   נערט_, _נתני, _loká, _você
  { {0x4425020a,0x69d50111,0x4e27006b,0x6d450223}},	//   _hul_, _omze, лоян_, _beha
  { {0x6145000d,0x4ed50036,0xbbbc000b,0x4252002b}},	//   _сека, рюют, ईस्क, _انور
  { {0xe0550029,0xfd450033,0x224d01d7,0xc172000a}},	//   _إختب, шэўн, lsek_, _לחג_
  { {0x44250020,0xdcf50024,0x224d005c,0x7afd0224}},	//   _mul_, edzē, osek_, _byst
  { {0xa95a0225,0x7afd0226,0xdcfc0227,0x7e9700c3}},	// [1e0] فجار_, _cyst, merč, _منير_
  { {0xd5b10023,0x3f820005,0x386100b8,0x7c2501f1}},	//   _nó_, leku_, fuhr_, _fuhr
  { {0x31ba0053,0xdb060057,0xd910002b,0x9f4b016e}},	//   עזענ, _doká, زیر_, locá_
  { {0x224d01e2,0x3f820020,0xc66a0001,0xccf3000a}},	//   ksek_, neku_, ешке_, _לכת_
  { {0x7f3b00b2,0x7afd0026,0x68fc0034,0x3f820228}},	//   גענו, _gyst, _wyrd, ieku_
  { {0xd5b100a7,0x44250064,0xd5b00015,0x64410034}},	//   _có_, _bul_, تفت_, _bwli
  { {0xd4670001,0x8884002b,0xfbd2000a,0xe56f006e}},	//   гије_, _خیان, ֶת֙_, سطو_
  { {0x4425002f,0x53980229,0x3f82016f,0x389b000a}},	//   _dul_, твия_, jeku_, _אילנ
  { {0xdb0600dc,0x316a006b,0x9f4b0144,0x8233002b}},	//   _elkö, ншно_, vocà_, یریا
  { {0x60210024,0x867b0008,0xc05a022a,0x20740033}},	//   _lēmu, _ארמו, нім_, алоў
  { {0x09f70008,0x89db000a,0xdfd10015,0x224d002a}},	//   רמים_, תחיי, قيد_, asek_
  { {0xdcf50024,0x98b80007,0x6d45013c,0x6d5a001a}},	//   zdzē, _gerą_, _seha, ótan
  { {0x6d45022b,0x4425022c,0x0000006a,0x0000006a}},	//   _peha, _zul_,   ,
  { {0xbb1b0152,0x98ad0046,0xeb9f00cb,0x7afd0013}},	//   _maît, _řeč_, _snø_, _ryst
  { {0x6c54005e,0x5478000a,0xd9fa000b,0x4bf9002b}},	//   йкру, כְּנ, ्तनत_, نبرگ_
  { {0x7afd022d,0xa09b0008,0xb09b000a,0xdb060030}},	//   _pyst, _טיוט, _טיור, _soká
  { {0x79d50036,0x6d450020,0xbb1b0003,0xdb060046}},	// [1f0] ажає, _teha, _naît, _poká
  { {0xa9070067,0xdcf5003d,0x5d670054,0x7afd022e}},	//   هبان, udzē, _стиз, _vyst
  { {0x7afd0050,0xd7c80086,0xd6ab002b,0xdb06022f}},	//   _wyst, گونه_, کدام_, _voká
  { {0xe7190029,0xdcfe005c,0x7afd0230,0x31e10231}},	//   نيات_, _napę, _tyst, _पद्ध
  { {0x98aa0024,0x44250232,0xa2d4000b,0xb6a5004a}},	//   ējām_, _sul_, _बेल्, рилл
  { {0x93bc0011,0xf4830086,0x2d830233,0xdcfc006f}},	//   _stăp, ماعی, neje_, zerč
  { {0xe3b1003b,0x75d2002b,0xf8b9000b,0xa889004f}},	//   قرة_, تيوا, _इथिय, _בָּ֥
  { {0xe3b10029,0xdb1d002e,0x44250234,0x58d40054}},	//   ترت_, _umsó, _vul_, _уост
  { {0xa2350010,0x290c002d,0xdcfc0007,0x42250004}},	//   шэйш, _údar_, verč, јдов
  { {0x41b50235,0x601f0091,0xca38000a,0x224d0236}},	//   рсит, _rūma, אנזה_, rsek_
  { {0x66ca00dc,0x3f820237,0xcea9000a,0x3fe60238}},	//   _töké, teku_, _קי_, ижов
  { {0xe0d60063,0x52d9004a,0xdb1d0052,0x0000006a}},	//   рвю_, _имею_, _alsí,
  { {0xe285002b,0xab5b0012,0x8db600fd,0x9e630239}},	//   _خطای, _plün, асві, овяд
  { {0x7bc8003d,0xae870004,0x3f82023a,0xdcfe002a}},	//   īdum, јбрз_, seku_, _zapę
  { {0xdd0e0064,0xe588000a,0x8c46023b,0xab5b0030}},	//   _dışa, נָשָ, ребе, _vlün
  { {0xc0520008,0x3ff30015,0xb92b0016,0xfce300ce}},	//   _וזה_, _وكور, _thuỵ_, іото
  { {0xaae50015,0xab290015,0xeab7023c,0x3946023d}},	// [200] مسكو, اسفل_, айт_, инаг
  { {0xc896023e,0x28960054,0x7d090046,0xdd2c0073}},	//   ирењ, ијес, řesa, lėži
  { {0xc8ca0087,0x2609000b,0xfeba002b,0x8726023f}},	//   خوان_, ितनी_, _ساکت_, амеж
  { {0x628b0026,0xeef60053,0xd7ef0015,0x6e93002b}},	//   _osgo, ֱמַר_, وكل_, _الیا
  { {0xb8fd000b,0x23a9000b,0x6b840240,0x55580033}},	//   _ते_, कानद, meig, галя_
  { {0xd5e3005e,0x6b840241,0x8e97004f,0x99800073}},	//   ожчи, leig, ידנו_, rpių_
  { {0x2927002c,0x26c00242,0x6feb002a,0xd5490015}},	//   ávať_, šio_, hęca, اجهم_
  { {0x6b840243,0x290a0244,0x25b20091,0x0000006a}},	//   neig, _izba_, _žalą_,
  { {0xa3c7000b,0xc1a600d7,0xe61a0245,0x27e60246}},	//   _उतर_, ајни, _ада_, mnon_
  { {0xda16005d,0x62990034,0x22590247,0xc1730248}},	//   थगित_, _drwo, áska_, ольщ
  { {0xc95301e4,0xd4d50010,0x629900b8,0xc0ca0249}},	//   חמת_, _ліцэ, _erwo, тупе_
  { {0x27e6024a,0x04db000a,0xa857000a,0x2fe40015}},	//   nnon_, _בקבל, סיכה_, ْكَف
  { {0x5f94010f,0xf7730008,0x93250086,0x22580080}},	//   цият, חקר_, _ارمن, _силы_
  { {0x7bc6022d,0xb2bb0008,0x627b000a,0x51f30015}},	//   _alku, _במדר, _סנונ, _وسور
  { {0x70540087,0x6b84024b,0xac95004a,0x2d83024c}},	//   _انبا, feig, щавш, reje_
  { {0x628b0176,0xe0fb0008,0x2ba4000d,0xe4570053}},	//   _ysgo, _שלהל, ојув, יילט_
  { {0x8ed80086,0x0a6b006b,0x2905024d,0xac18024e}},	// [210] _پذير_, ърви_, _šla_, роту_
  { {0x780f000b,0x99d40015,0x7bc60030,0x0000006a}},	//   िष्क_, يتلا, _elku,
  { {0x6b840048,0x6d41001a,0x4c95024f,0x63a20250}},	//   beig, ðlau, _уинс, _onon
  { {0x20140251,0x27e60252,0xdc9a004c,0x7d08007c}},	//   _èxit_, gnon_, _עירל, üdse
  { {0x23da005d,0x4b7a004f,0xdcfc01ec,0x0000006a}},	//   _बग़द, _גארו, merā,
  { {0xce38013a,0x63a20253,0x7ad0000b,0x7c94002b}},	//   סאות_, _anon, _सेटअ, _اشیا
  { {0x05740086,0xd64d0036,0xd7950063,0x97a70254}},	//   تاند, _гiпе, _ливъ, _крал
  { {0xc2450036,0xdcfc003d,0xab5b0255,0xb8dd000b}},	//   бник, nerā, _olüm, ेन_
  { {0x65870256,0xdd2c0091,0x248c01d7,0xe730006e}},	//   _выез, vėži, _esdm_, _آصف_
  { {0x6b84018b,0x13a7002b,0xbec40091,0xeab2004f}},	//   zeig, انکی_, šūki, לֹת_
  { {0x7dc2002c,0xeae4000b,0xa988000a,0x1600000b}},	//   _dôsl, _गश्त_, בָרִ, _लीटर_
  { {0x7dc2002c,0x87790053,0x487a000a,0xe8d6000a}},	//   _pôso, נאָי, נטרס, מותר_
  { {0x8287002b,0xdcfc003d,0xc2c40015,0x69c70257}},	//   _خجال, derā, _ويمي, _olje
  { {0xb6da0053,0x8cb6000b,0x8e07005e,0x6b840258}},	//   אַלט, ैनलो, йняв_, weig
  { {0x7d090089,0x8c9500fd,0x27e600e7,0x6b840259}},	//   řesn, орті, ynon_, teig
  { {0xbbe90015,0x0056000a,0x6fc60125,0xdb24002b}},	//   لرقم_, _השקת_, _fóca, زوئی
  { {0x7f3b0053,0xda650015,0x6b84025a,0x69c70085}},	// [220] _געפו, قالي, reig, _blje
  { {0x5d860029,0x6b84025b,0xbddb0003,0x49960054}},	//   _الدل, seig, ssèr, љшат
  { {0x6d4e00b6,0x97260029,0x3f920049,0xca29000a}},	//   maba, مفاو, _kayu_, תם_
  { {0x6d4e025c,0xa3d9000b,0x78a30123,0x69c7025d}},	//   laba, डोम_, ånva, _elje
  { {0x6f7b000a,0xd6770015,0x276b002b,0xef1f0061}},	//   רְבו, محوا_, اشمی_, ldür_
  { {0x6d4e025e,0x9e7b000a,0x3f9201d7,0xe1e7006e}},	//   naba, רנספ, _layu_, _رس_
  { {0x2bbf005d,0xef1f0064,0x225f01c2,0x8c1a000a}},	//   _एकमा, ndür_, eruk_, ְוִי
  { {0xa3d2005d,0xa8570008,0x136a025f,0x6d4e0260}},	//   हों_, _לילה_, ушки_, haba
  { {0xe6430083,0x7dcb0064,0x6d4e0261,0x06ea0262}},	//   _нетп, _hüse, kaba, _смак_
  { {0xd9fa005d,0x018a0146,0x75d30015,0x9f420227}},	//   ्तित_, ущий_, _فيقا, roký_
  { {0x20d30010,0x672d0263,0xa98b000a,0x9f420264}},	//   зіўс, žaje, אָכִ, soký_
  { {0xf8b3000a,0x69de0265,0x926a0004,0x225f0266}},	//   לשת_, hipe, _брка_, bruk_
  { {0x2bbf000b,0x69de0267,0x394a0085,0x0000006a}},	//   _एकबा, kipe, _oebs_,
  { {0xbd450029,0x3fc90086,0x30a60268,0x12e7000a}},	//   تنسي, ادگی_, _грив, _לֽוֹ_
  { {0x2a600020,0x69de0269,0xbfd50015,0x10530015}},	//   erib_, dipe, _ويتع, _فضيح
  { {0x69c7010b,0xeb4800fd,0x6e46001a,0x940b000a}},	//   _slje, йчук_, ðubú, ָּלֵ
  { {0x6d4e00b6,0x59d90010,0x539b0008,0xddeb0086}},	// [230] baba, адаў_, נימו, _مرده_
  { {0x49bb0086,0x2489005c,0x35be000b,0x99d70015}},	//   دارد_, łami_, ्सफ़, حترا
  { {0x2010005c,0x6d410061,0xdcfc003d,0x3915002b}},	//   łnił_, ılad, perā, آواز
  { {0x61fa0079,0xd6390033,0x225f0061,0x6457026a}},	//   hotl, аякі_, yruk_, áxim
  { {0x7bdf026b,0xe611002b,0x600c000a,0x7bcd026c}},	//   miqu, وشت_, נִבְ, mhau
  { {0x7bdf026d,0x69de026e,0x69c70085,0x06840033}},	//   liqu, cipe, _ulje, ягін
  { {0xddcc00df,0xf992000a,0x8d4c000a,0xa3d5000b}},	//   _žiūr, _קרל_, אֲחֵ, सफल_
  { {0x05770086,0x61e8026f,0x7bdf0270,0x7bcd0271}},	//   _گارد, endl, niqu, nhau
  { {0x6603002c,0xd24e0029,0x961d003d,0xb6340015}},	//   plnk, نني_, _apņe, _فعلت
  { {0x7bdf0152,0x4206005e,0xef1f0061,0x225f00cb}},	//   hiqu, жньо_, ydür_, rruk_
  { {0x0fda0029,0xbddb0251,0xe5700086,0x6d4e0272}},	//   لبحث_, ipèd, _سطل_, vaba
  { {0x61fa0020,0x69de003f,0x6d4e0273,0xf3f00015}},	//   aotl, zipe, waba, _كأن_
  { {0x7bdf0274,0xd808000a,0x61fa0061,0x6f0d002a}},	//   diqu, מִשָ, botl, _czac
  { {0x112b0036,0x8e75005e,0x7bcd0012,0xf194004a}},	//   _сюди_, чуюч, ehau, _ничь
  { {0x6d4e0275,0x6c360015,0x2fc90276,0xdcfc0045}},	//   raba, تفزا, _flag_, deră
  { {0x7bdf0277,0x6d41002e,0x6d4e0278,0x27ed01a3}},	//   giqu, ðlar, saba, _njen_
  { {0x6d4e0279,0xba1a0015,0xed5a027a,0x38cb002b}},	// [240] paba, ليرا_, _коп_, یامی_
  { {0xdcf50064,0xdcfc0011,0x6f040061,0x84e90065}},	//   _çağr, geră, _iyic, टपाट_
  { {0x881a0010,0x3205027b,0x7bdf01e6,0xe8f7027c}},	//   аўду_, illy_, biqu, олф_
  { {0xfaa60010,0x394a027d,0x7bcd027e,0xeb9a027f}},	//   _дамо, _webs_, chau, _тим_
  { {0x7f8d0053,0xdcfc0045,0xba760015,0xe5340280}},	//   טנאַ, beră, _باجت, пель
  { {0xfc4b0089,0x27ed00d9,0xfe9b004c,0x4e8b000a}},	//   říž_, _ejen_, יינמ, שָׁ֣
  { {0x60280089,0x69dc002d,0xa7860015,0xab5b0012}},	//   _těmi, _imre, _وشرو, _blüh
  { {0xd3770080,0x442200c0,0x7bc40007,0xa3ba0029}},	//   очь_, ök_, nkiu, شاعر_
  { {0x61fa0281,0x7bc40091,0xd3d70058,0xe3af0058}},	//   totl, ikiu, تبوا_, ضري_
  { {0x2fc90282,0x61e80283,0x443c01e0,0x0000006a}},	//   _slag_, undl, ppv_,
  { {0x6f0d005c,0x399b0053,0xeb07005d,0xdb1d001a}},	//   _szac, בייד, _शर्त_, _umsö
  { {0x93250074,0x32050041,0x7bdf0152,0xea010092}},	//   _فرهن, ally_, xiqu, _đập_
  { {0x6b960026,0x69dc0284,0x2fc9016b,0xdb0f0069}},	//   ddyg, _omre, _vlag_, _pocí
  { {0x72e90053,0xf5aa000a,0x442c0285,0x7d090046}},	//   _פֿײַ, ׁבָּ, _kud_, řesm
  { {0x4c940286,0x7bdf0287,0xd53b000a,0x7bcd0288}},	//   мирс, tiqu, שתלט, thau
  { {0x5a350289,0x69dc028a,0x442c028b,0x7dcb0012}},	//   знат, _amre, _mud_, _büsc
  { {0x7bdf028c,0x6d410064,0x2d93028d,0x7bcd028e}},	// [250] riqu, ılab, _taxe_, rhau
  { {0x7bdf028f,0x442c0161,0x88c7002b,0x7bcd0290}},	//   siqu, _oud_, يتال, shau
  { {0x7bdf0291,0x1e180015,0x20ca000b,0xf77100c3}},	//   piqu, _بغية_, ानिध, ّات_
  { {0xacfa000a,0x5a470033,0x69dc0061,0xdcfc0045}},	//   _להתכ, _мэга, _emre, seră
  { {0xd6db0292,0xf77000e5,0xe7980015,0x53a9000b}},	//   јте_, ضان_, تخلص_, कासश
  { {0x3aba0008,0x2aba000a,0xdcf5003d,0x9555002b}},	//   _המשנ, _המשא, jdzī, سختا
  { {0xdd7c0053,0x7d7c000a,0xf5560015,0x27ed0293}},	//   יטגל, ינגו, سليب_, _tjen_
  { {0xdcf5003d,0x398a002a,0xc2450294,0x69c501f9}},	//   edzī, rósł_, пник, lkhe
  { {0x23620014,0xe6880015,0x8c1c000a,0x69dc0034}},	//   ókja_, _ونفى_, סוחי, _ymre
  { {0x69c500b8,0xdb06002c,0x442c002d,0x320500da}},	//   nkhe, _pokú, _fud_, ully_
  { {0x7bc40007,0x3815000a,0x442c0295,0x10a50296}},	//   ykiu, ּקָם_, _gud_, чинн
  { {0x547a0008,0x27fd003e,0x76490297,0x02450015}},	//   _לטעו, nown_, _kwey, _فَصَ
  { {0xadf8005d,0xc7d6000a,0xd1bb002b,0x92640015}},	//   ंकलन_, פושי_, _پاشا_, _قدوم
  { {0x79950050,0x69c50298,0x64600091,0xa2d40065}},	//   _nazw, jkhe, ūziš, _बेट्
  { {0xdca30299,0x61e1029a,0x63b9002a,0x1d0a029b}},	//   нари, mill, _kown, севи_
  { {0x60d60008,0x61e1029c,0x3ce50030,0xdb16008c}},	//   _מוצא_, lill, úlva_, ykyä
  { {0x3c19008f,0x6b630010,0x5e570029,0x61e1029d}},	// [260] іўся_, экта, _فليس_, oill
  { {0xa96a0029,0x6d410064,0x61e1029e,0xfe9b000a}},	//   إمام_, ılac, nill, _פיימ
  { {0x5dbb0008,0x79950012,0x7786029f,0xd910002b}},	//   _הזיה, _dazw, злез, ئیز_
  { {0x442c002f,0x2d9802a0,0x61e102a1,0x2d8a02a2}},	//   _rud_, ldre_, hill, lebe_
  { {0x96b70001,0xd5ba0256,0x963302a3,0x61e102a4}},	//   зују_, йск_, еніц, kill
  { {0x61e102a5,0x46390036,0x8e5700a3,0x2d9802a6}},	//   jill, іччя_, לינג_, ndre_
  { {0x95530086,0x7c26003f,0xf74602a7,0x2d8a0012}},	//   رخوا, _kikr, _нево, iebe_
  { {0x9f590152,0x7995005c,0x3373006b,0x82380004}},	//   posé_, _zazw, егър, озис_
  { {0x60330011,0xe3af0015,0x5a9c000a,0xf1aa0067}},	//   _răma, ارى_, שׁ֖ו, ماده_
  { {0xe1d80036,0xdcf50024,0xa63b0008,0x442c02a8}},	//   ідні_, udzī, _לגמר, _tud_
  { {0xdcf50024,0x442c00e8,0x853b000a,0x653b000a}},	//   rdzī, _uud_, _הגבי, _העבד
  { {0x3ea002a9,0x61e102aa,0x8366002b,0x74130015}},	//   _brit_, aill, _ردصل, _كولا
  { {0x1ee70086,0x539b000a,0x61e102ab,0x93b7000a}},	//   سوسی_, _ליאו, bill, _מלאו_
  { {0x4426003f,0x21f40015,0x61e102ac,0x2d8a02ad}},	//   _hio_, _تكتس, cill, gebe_
  { {0x317b0008,0x717b0008,0xb17b0008,0x417b0008}},	//   _הרומ, _הנוס, _הטור, _הנוב
  { {0xcf270029,0xddeb002b,0xf993002b,0x3ea002ae}},	//   _عربي, _گربه_, کبر_, _frit_
  { {0x61eb0014,0x442602af,0x6dd50015,0xadf502b0}},	// [270] _állí, _mio_, _يقبض, _опиш
  { {0x2d8a001c,0x9aa40015,0xbdfb0015,0xc1780091}},	//   cebe_, عملو, _درعا_, mnės_
  { {0x27fd02b1,0x721b000a,0x7d7a000a,0x9d190099}},	//   town_, מומח, _ונתו, _фонт_
  { {0xc7940010,0x629b0007,0xa037000a,0xf6f5002b}},	//   ершы, yvuo, פאדה_, وزشگ
  { {0x63b90026,0x0f580008,0x27fd003e,0xdb23002b}},	//   _rown, ליאם_, rown_, _سوسی
  { {0xd126003b,0x06f40086,0x63b90034,0x65920054}},	//   _لم_, رسنج, _sown, ваљу
  { {0x4426010b,0x94750086,0x61e102b2,0x8d5c000a}},	//   _bio_, بگذا, vill, זכוי
  { {0x61e102b3,0xd794006b,0x3d150065,0x7c3801f6}},	//   will, _писъ, _धरने_, _évre
  { {0x61e102b4,0x52a9005e,0x442602b5,0x3f8b0085}},	//   till, івом_, _dio_, decu_
  { {0x5555002b,0x20c5005e,0x3216002b,0x629b0091}},	//   _آپار, дйом, وييد_, rvuo
  { {0x7dd0022d,0x63b9003e,0xb9360008,0xc952000a}},	//   _jäse, _town, ונתו_, כמי_
  { {0x3ea00152,0xb4fa009d,0xdee602b6,0x61e102b7}},	//   _prit_, _ולער, доми, sill
  { {0x7dd000c0,0x03d6000a,0x61e102b8,0xb1b50058}},	//   _läse, _קונם_, pill, _يحتش
  { {0x7c260293,0xa3d9000b,0x442602b9,0xb4f9004c}},	//   _sikr, डोर_, _zio_, ַפּי
  { {0x3b96000d,0x3e760134,0xc1050015,0xc1040015}},	//   мјат, sæt_, _توثي, _كوهي
  { {0x6ff60029,0xea010016,0x2d8a02ba,0xd48f00ce}},	//   _تستط, _đạp_, sebe_, трi_
  { {0x3b07010f,0x3a2602bb,0x6bd70058,0x7c2602bc}},	// [280] дето_, дмаг, ذوكس_, _vikr
  { {0xc9860029,0x60280089,0x7dcb0061,0xbd46006e}},	//   بشري, _těmt, _hüsn, _تندي
  { {0x8cb5014e,0x7c2600df,0x19b90286,0x2fd7002b}},	//   _उपयो, _tikr, чуть_, _روید_
  { {0x672d016f,0xb0b60053,0x4c9b000a,0xe0b6004c}},	//   žajn, ופעס_, _ובטו, ולעט_
  { {0x442602bd,0x501b000a,0xed56004f,0x667302be}},	//   _rio_, קונו, ֥בֶר_, ندور
  { {0x4426003f,0x15140033,0x0000006a,0x0000006a}},	//   _sio_, ндля,   ,
  { {0xd49702bf,0xe5a30054,0x52b8000b,0x442602c0}},	//   дры_, тији, ेन्स, _pio_
  { {0x2918002a,0xc1780091,0xdb0d001a,0xf2c6007e}},	//   ągać_, ynės_, okað, дсон
  { {0xd1660063,0x8cb5005d,0x442602c1,0xdb0d001a}},	//   мъни, _उपभो, _vio_, nkað
  { {0xe29f0084,0x7c3e016f,0x7dd00123,0x6ff2003d}},	//   æða_, _otpr, _läsb, vāca
  { {0xf9930008,0xf9460010,0x442602c2,0xdcfe003d}},	//   דרת_, чнiк_, _tio_, _mapē
  { {0x443e02c3,0xdb0d002e,0xa857000a,0x72c602c4}},	//   _itt_, kkað, ויטה_, _обез
  { {0x441b0053,0xc7b3000f,0xff0402c5,0x753d0030}},	//   _וואס, דבר_, вярн, _őszi
  { {0x7ae900bd,0x41770015,0x3f8b02c6,0x443e01d7}},	//   _žeto, _يمنح_, secu_, _ktt_
  { {0xc1780007,0xc1730008,0x40940015,0x7e6600cb}},	//   snės_, _יחס_, _ألبر, arkp
  { {0x5f950063,0xd01100c3,0x6fc60125,0x645802c7}},	//   _чиит, _حلب_, _nóch, isvi
  { {0x6feb0050,0xda15009c,0xbbbf000b,0xda7802c8}},	// [290] jęci, едањ, _एकीक, дях_
  { {0x62770008,0x443e02c9,0xac950054,0x645802ca}},	//   וגמא_, _ott_, _заош, ksvi
  { {0xab5b00b8,0x6d5502cb,0x9f4b0003,0x2907001a}},	//   _blüt, maza, encé_, æna_
  { {0x6d5502cc,0xad1a0008,0x645802cd,0x7dd00123}},	//   laza, _מותר, dsvi, _väse
  { {0x46480010,0x6fc6002d,0x443e02ce,0xbb3a000f}},	//   дзін_, _dóch, _att_, _מערי
  { {0xdcee0007,0xb6320015,0x6d5502cf,0x6b8d02d0}},	//   gebė, دفوع, naza, leag
  { {0x26c9016f,0xd138005c,0x67d5004a,0xd6180015}},	//   šao_, dcą_, _зову, ذتها_
  { {0xa3d9005d,0x03790015,0x6b8d02d1,0xdc6c000a}},	//   डों_, سحبت_, neag, ק֣וֹ
  { {0x443e02d2,0x60160107,0x6d5502d3,0xa8020061}},	//   _ett_, náme, kaza, ğıta
  { {0xf1b10029,0x66e40054,0x6b8d0125,0x6d5502d4}},	//   اءة_, _рођа, heag, jaza
  { {0x672402d5,0x9f420046,0x657c0123,0x14740015}},	//   žijt, liké_, _örha, _لانج
  { {0x649a0008,0xd4360053,0x72d50004,0x644302d6}},	//   _מסעד, _טרעק_, _поеф, mpni
  { {0xe1ee0063,0x6d410064,0x3f9e0089,0x63ab0035}},	//   _бг_, ılan, ětu_, _ingn
  { {0x7bcf02d7,0x76590034,0x200b02d8,0x443e00d6}},	//   _alcu, iswy, alci_, _ytt_
  { {0xb0420023,0xc5f20008,0x6feb002a,0xdb860170}},	//   _trưở, אדם_, zęci, нгви
  { {0x212b0046,0x8b2602d9,0x9f990030,0x0000006a}},	//   ěchu_, едбе, _táás_,
  { {0xada602da,0x4d3a02db,0x7dd002dc,0x49ca02dd}},	// [2a0] _запл, _няня_, _väsb, план_
  { {0xdb0d0084,0x200200f2,0x0b170015,0x6d5e02de}},	//   rkað, loki_, رقلة_, _udpa
  { {0x7dcb0064,0x7c3e02df,0x7de50015,0x9f9a000a}},	//   _müsl, _utpr, _جسيم, ּסְפ
  { {0x2ca50134,0x601602e0,0xdc3b004f,0x2d9a0072}},	//   ælde_, lámb, _מעטר, _hape_
  { {0xdcee0007,0x569402e1,0x69d1003d,0x473300e2}},	//   tebė, талт, _ūdeņ, уніс
  { {0xab5b00b8,0x245a0024,0x443e02e2,0xc5d8002b}},	//   _flüs, tīm_, _ptt_, بوتص_
  { {0xc977000a,0x7d090046,0x6458008c,0x7a290091}},	//   _רגלי_, řesv, usvi, _užta
  { {0xf7530086,0x987b0053,0xd138005c,0xd90d002b}},	//   _منفج, _מאלט, wcą_, _بیم_
  { {0x9f42008c,0x249c0091,0x200202e3,0x290a01c0}},	//   inkä_, _žymė_, doki_, _hyba_
  { {0x91e30001,0x27e602e4,0x9aeb000a,0xaa77000a}},	//   лоње, lion_, לַיִ, עתיד_
  { {0xc32a0029,0xc05702e5,0x443e0024,0x6d5502e6}},	//   _فكان_, нія_, _utt_, vaza
  { {0xde590010,0xd65e005e,0x27e602e7,0xc7e6000a}},	//   мамі_, _вiдд, nion_, תוֹ֙_
  { {0x0e340080,0x6d5502e8,0xb7db000a,0xdb06006f}},	//   лняю, taza, לקטי, _poký
  { {0xbbc9005d,0x7d0302e9,0x27e60026,0xdb060064}},	//   रस्क, _ønsk, hion_, _dokü
  { {0x5ff50063,0x31370008,0xfc64006b,0x2137000a}},	//   _изку, _ארוך_, лътн, _אטול_
  { {0xfc30003b,0x6d5a002e,0x40eb000a,0x2cac0123}},	//   صحف_, ótar, _מַחֲ, ådda_
  { {0x27e602ea,0x6b8d02eb,0x6ffc000a,0x497502ec}},	// [2b0] dion_, reag, _מההפ, клас
  { {0x601602c1,0x22f7004f,0xd91b02ed,0x0000006a}},	//   ráme, תזמן_, пье_,
  { {0x27e60026,0x4ddc0008,0x6fc6016e,0x98480033}},	//   fion_, _מחזו, _sóci, еяча_
  { {0xbcb60008,0x76590026,0xfecb000a,0x27e6026e}},	//   _ספרו_, tswy, ּמַּ, gion_
  { {0xa3b4014e,0x601600dc,0x8bba000a,0x7e7d02ee}},	//   ञान_, lámc, _חזרת, ntsp
  { {0x85780063,0x7d090046,0xd5bb0174,0x7e9c000a}},	//   есът_, řesu, ясе_, פסוו
  { {0x27e60176,0xcd980008,0x02c9000b,0xd90f002b}},	//   bion_, גדות_, िन्न, _ایا_
  { {0x47340029,0xdc8c0008,0xe3b10029,0x644302ef}},	//   _مركز, לְחָ, شرب_, rpni
  { {0x7dd000c0,0x62720015,0xdb16008c,0x0ee00065}},	//   _läsa, لهيئ, shyö, _पेंड
  { {0x644302f0,0x10a502d9,0x7e7d01d0,0x0000006a}},	//   ppni, вион, dtsp,
  { {0x55ba000a,0x2d9a00da,0x200202f1,0x63ab02f2}},	//   _קמעו, _rape_, toki_, _tngn
  { {0x34b60008,0xe458005e,0x23e9002b,0xb4bf000b}},	//   _בפעם_, _їжі_, _غذای_, ुनी_
  { {0x66030020,0x2d9a02f3,0x200202f4,0x7e7d01d0}},	//   oonk, _pape_, roki_, gtsp
  { {0xd656000a,0x80e50015,0x27e602f5,0x200202f6}},	//   כישת_, _لأعل, zion_, soki_
  { {0x8d76002b,0x7e7d02f7,0x7dd00012,0x207501b0}},	//   _یادا, atsp, _cäsa, _рулё
  { {0x27e602f8,0x660302f9,0x290a02fa,0x2259005a}},	//   xion_, honk, _ryba_, šsku_
  { {0x3ae80074,0x2d9a02fb,0xf1b5000b,0x501b000a}},	// [2c0] ربری_, _tape_, _अचान, _קופו
  { {0xdcfc0024,0x2492005c,0xdb06002a,0xba17002b}},	//   ndrī, łymi_, _sokó, پيما_
  { {0xdcfc0024,0xdb06005c,0x27e602fc,0x8e3a002b}},	//   idrī, _pokó, tion_, _عسکر_
  { {0x6c57000a,0x4c79000a,0x0000006a,0x0000006a}},	//   _ביטא_, _אָשׁ,   ,
  { {0xa3ab014e,0x644102fd,0x7d090089,0x27e602fe}},	//   खाई_, _atli, řest, rion_
  { {0xdb06005c,0x27e602ff,0xd9430300,0xc8660015}},	//   _wokó, sion_, _вери, _لطري
  { {0x94730015,0x9f590030,0x27e60301,0x09e30302}},	//   لديا, őzés_, pion_, _торн
  { {0xb8f6005d,0xc274000d,0xdcfc0024,0xccf30008}},	//   िन_, глиј, edrī, יכו_
  { {0x877b0053,0x7791002b,0x2348002b,0x64410303}},	//   _קאמי, _دینا, وسکی_, _etli
  { {0x75d30086,0xc05a0033,0x64530030,0xf1a60189}},	//   _پيما, мім_, údió, трин
  { {0xc60e005d,0x799c0304,0x43860015,0xf957000a}},	//   ितीय_, _marw, _للاق, כסית_
  { {0x6d410064,0x9f4b0077,0x185b004c,0xd5fb0016}},	//   ılam, vocó_, וכטע, _trụ
  { {0x7ee4005e,0xf2d70015,0x2e4b02ed,0xdbdc0052}},	//   ацре, _لبوش_, ьяно_, _ráðn
  { {0x9a090033,0x3d95004a,0x2d8500bf,0x709a0015}},	//   аiне_, ыигр, ýle_, _ينشأ_
  { {0xf4140053,0x2ca5002e,0x61e80293,0xe7f3000b}},	//   ָפּ_, íld_, midl, _अदला_
  { {0x3ec7008f,0xef67010f,0xa3ab005d,0xc3340008}},	//   _асоб, _ръко, खाए_, רוּ_
  { {0x799c0305,0x5b1502c8,0x2009003d,0x6603007f}},	// [2d0] _barw, умат, _ikai_, yonk
  { {0xc27b0008,0x799c0034,0xdd910015,0x79d4005e}},	//   ורמי, _carw, _اود_, ажує
  { {0xa9280033,0x2d910306,0x60160307,0xd246002b}},	//   віце_, meze_, láma, _گن_
  { {0x1b4b0029,0x2d910011,0x58840033,0x6603002a}},	//   _تؤدي_, leze_, рыфа, wonk
  { {0x799c0026,0xd2460067,0x7bcd0308,0x6fdc000a}},	//   _farw, _دن_, mkau, וקאס
  { {0xca7a0053,0x2d910011,0x7bcb001a,0x7dd00309}},	//   _אנשט, neze_, öguf, _läsn
  { {0x6016002e,0xb4bf000b,0x20090030,0x61e801c0}},	//   háma, ुने_, _okai_, didl
  { {0xe2b90001,0x61e8003d,0xddc60091,0x6603030a}},	//   ећој_, eidl, iukš, sonk
  { {0xd179005e,0x56f50004,0x2fc0030b,0x87e4030c}},	//   нсні_, _спаѓ, _roig_, _тюре
  { {0xe5730031,0x46150015,0x2d910022,0x2d830079}},	//   _خطر_, _صوار, jeze_, jfje_
  { {0x7bcd00f2,0x43750002,0x41b40033,0x2d91030d}},	//   kkau, _مهار, рсыт, deze_
  { {0xbb1b0003,0x14da004c,0xeb9f02de,0x5275030e}},	//   _abîm, _אַדמ, _skøn_, _буку
  { {0xd5a7005e,0xd6cf005e,0xee37006b,0x61e80125}},	//   _пiдп, йтi_, лня_, bidl
  { {0x63bb030f,0x6da60054,0x61e80310,0x16db000b}},	//   ljun, ћива, cidl, _मेज़ब
  { {0xdca10036,0x6c360002,0x8fa601b7,0x6b9d0311}},	//   остi_, افرا, _байе, _basg
  { {0x6b9d0176,0x8cb5005d,0x7bcd0035,0xdb0f016e}},	//   _casg, _उपरो, gkau, _incê
  { {0xc332011f,0xa3b4005d,0x7fd7000a,0x4b55006b}},	// [2e0] מון_, ञात_, _תופס_, ръст
  { {0xfd4a0036,0x3c94002b,0x7bcd0312,0x63bb007c}},	//   _язок_, _پیرز, akau, hjun
  { {0xe4e3005d,0x63bb002e,0xa1560008,0x6b9d0034}},	//   _केलि_, kjun, רבעה_, _fasg
  { {0x6b9d0313,0x60330045,0x18670004,0x38670314}},	//   _gasg, _cămi, ѓачи_, ánra_
  { {0xb7d70002,0x63bb0315,0x799c0316,0x320501c0}},	//   دونا_, djun, _tarw, koly_
  { {0x99d60015,0xd49a0317,0x6b840318,0x09e602ed}},	//   _إتحا, ери_, lfig, _согн
  { {0x61e80107,0x3957000a,0xdb1d00e9,0x8898000a}},	//   vidl, _תשלם_, _rosé, _בֹּה
  { {0x2d910319,0x6f09002a,0x7dcb0061,0xfdd1000b}},	//   zeze_, żeci, _püsk, _हत्फ
  { {0xd130003b,0xdb0f0003,0xdb1d00e9,0x6b84031a}},	//   يمة_, _ancê, _posé, ifig
  { {0xfa970053,0x2d910011,0xda7b0053,0x82330015}},	//   נדיש_, xeze_, עניר, حريا
  { {0xe4750010,0x3386006b,0xa0730033,0x2d91031b}},	//   _вучэ, _булв, быўш, veze_
  { {0x2d91003f,0xb4fb0008,0x8f4702bf,0x7cf20030}},	//   weze_, _אלבר, ыход, zűré
  { {0x61e8031c,0x2d91031d,0x60da0030,0x1eab0015}},	//   pidl, teze_, sztm, راحي_
  { {0x7dcb0005,0x6016002d,0x6aa90085,0x2327031e}},	//   _küsi, ráma, _šefo, _сочи_
  { {0xa1570008,0xd13f005c,0x75370053,0x2d91031f}},	//   _גבוה_, łącz_, ראלד_, reze_
  { {0x2d910320,0x7bcd0321,0x9ee90015,0xcc170015}},	//   seze_, ukau, _لفعل_, اذسب
  { {0x6b9d00dd,0xb955006b,0x15f6000b,0x63bd0123}},	// [2f0] _vasg, иващ, ेवार_, ösni
  { {0x6b9d0034,0x7bcd0322,0x0000006a,0x0000006a}},	//   _wasg, skau,   ,
  { {0x6b9d0034,0xdd15002b,0x47350323,0x61ef0324}},	//   _tasg, _خودخ, анес, écli
  { {0xf77300e6,0xd6d10115,0x6b9d0125,0x3ea90325}},	//   صاص_, يقا_, _uasg, _krat_
  { {0x9f820079,0x9f4c0030,0x29180326,0x07b60058}},	//   _zóó_, élék_, _ezra_, شهوة_
  { {0x4ade014e,0xb5fd0089,0x5e580053,0x2e3c004c}},	//   _नेटव, _ovše, ריגע_, עגונ
  { {0xb4650086,0xdb0600dc,0xf8ae002b,0x5d9c000a}},	//   شگاه, _inká, _يکم_, גבוה
  { {0xea010092,0xd26501b7,0x63bb0327,0x62650328}},	//   _đẹp_, акий, ujun, авиа
  { {0xd7f80329,0x63bb032a,0xe3b60174,0xeab7000a}},	//   _сур_, rjun, рбы_, רִ֔י_
  { {0xfa98004c,0x6ff2003d,0x7dcb007c,0x98a10061}},	//   רדזש_, māci, _füsi, lahı_
  { {0xf9920008,0x6ff20024,0x7dd000c0,0x63bb0091}},	//   חרי_, lāci, _säso, pjun
  { {0x0876004c,0xf1d9000b,0xdfcf0015,0xa3ab000b}},	//   סערט_, योजन, ِيَ_, खाओ_
  { {0x6ff20024,0x94040086,0x3205032b,0x0efa0138}},	//   nāci, _اونه, poly_, тэны_
  { {0xc5f20053,0x69c30061,0xd24e0015,0x8e0701c5}},	//   ַדן_, önel, _غنى_, иняв_
  { {0x2d9e032c,0xa3cc005d,0x442f0134,0xc0a80018}},	//   ľte_, _रकम_, _kig_, _مايل_
  { {0x6ff20048,0x2d9e0107,0xaec6005e,0x81140067}},	//   kāci, žte_, _вбил, _اذها
  { {0x601600dc,0x3e7f0045,0x99e60033,0xeb97013e}},	// [300] lámo, cît_, ажад, шит_
  { {0xae5b000a,0xdb1d0030,0x6ff2003d,0xe9d7032d}},	//   _שכיר, _alsó, dāci, аку_
  { {0xd9100086,0x6d4e00dc,0x6fcd0003,0x290e001a}},	//   سیر_, mbba, _bûch, æfa_
  { {0xc60e000b,0x60160030,0x684300fd,0x3cfb000a}},	//   ित्य_, zámn, інча, _ילינ
  { {0x7f3b0053,0xeb970063,0x6ff20024,0x3c3c00dc}},	//   דענו, _тия_, gāci, _hív_
  { {0x7dcb0020,0x6594000d,0x0466032e,0xf48a004a}},	//   _püsi, саку, атим, вщик_
  { {0x601d0152,0x442f032f,0xe006000b,0xfbd2000a}},	//   léme, _big_, रवाद_, ַת֙_
  { {0xdc370053,0x442f0026,0x395800ea,0x889b000a}},	//   סאפט_, _cig_, _hers_, _בבלי
  { {0x442f0330,0x601d0152,0xd80b000a,0x6d5c0331}},	//   _dig_, néme, _יִמָ, kara
  { {0x867b000a,0x6d5c0332,0x91b80004,0x60330045}},	//   _ברמו, jara, угот_, _lămu
  { {0xdfd10029,0x54730029,0xb937000a,0x225f013c}},	//   كيد_, _وهكذ, יניו_, asuk_
  { {0x3ea90333,0x644a0334,0x442f0335,0xb7bd0045}},	//   _prat_, mpfi, _gig_, _fiţu
  { {0x6d5c0336,0x7c2f02b9,0xa2d30015,0x32b70015}},	//   fara, _ricr, _ويمت, _ندوة_
  { {0x7c2f0176,0x3f550092,0xf2db000a,0x6d5c0337}},	//   _sicr, ấu_, _שַׁל, gara
  { {0x6ff20048,0x61ef0152,0x91bb000a,0x621b000a}},	//   zāci, ècle, _במגי, _שווק
  { {0x3ea900b8,0x6029005c,0xc1780091,0xcbf80015}},	//   _trat_, _ośmi, lgė_, لرقص_
  { {0xba550029,0x6d5c0338,0x6d570339,0x69d5033a}},	// [310] صناع, bara, _texa, _plze
  { {0xe29f0084,0xc1780007,0x6d990080,0xad27002b}},	//   æði_, ngė_, _своё_, _پرخو
  { {0xf7730021,0x9f420046,0x3958033b,0xdce50061}},	//   قاش_, liká_, _ders_, _tahı
  { {0x395800dd,0x6ff20024,0xbb94004a,0x7c240045}},	//   _eers_, tāci, _дающ, cmir
  { {0x601600dc,0xb6a50036,0x442f014c,0xfbb6000a}},	//   zámo, силл, _rig_, _הפרת_
  { {0x6ff20048,0xe578005e,0x442f033c,0x0608008b}},	//   rāci, изі_, _sig_, анік_
  { {0xe3b10029,0x6ff2003d,0xd466033d,0x442f033e}},	//   كرة_, sāci, бище_, _pig_
  { {0x1bf9005d,0x225f0030,0x39410012,0xc4f80015}},	//   ्किल_, tsuk_, lchs_, جعها_
  { {0xa5670086,0xfbb80008,0x36d4033f,0xeb92000a}},	//   _ندان, שפחת_, _дотр, פָה_
  { {0x7c240340,0xd6280054,0x6d5c0341,0xd1990342}},	//   zmir, _вође_, xara, утич_
  { {0x225f00dc,0x442f002d,0x1bf9000b,0x39410012}},	//   ssuk_, _tig_, ्काल_, ichs_
  { {0xcdc9013a,0x6d5c0343,0x672d0085,0x60160344}},	//   _אך_, wara, žaju, rámo
  { {0x1e830010,0xdb240064,0x539a000a,0x6d5c0332}},	//   плям, üsün, _תינו, tara
  { {0x32b8003b,0x7dd000f2,0xd1b8002b,0x229a000a}},	//   _خدمة_, _täsm, _پاها_, _תֹאמ
  { {0x2fd70074,0x8c460345,0x91ba000a,0x1c39004a}},	//   _گويد_, себе, _תמצי, иять_
  { {0x6bb50036,0xa3ca005d,0x9f82002e,0x7dd00209}},	//   осує, रॉप_, _góð_, _käsk
  { {0x09360029,0x39580346,0x7c240347,0x6d5c0348}},	// [320] مراج, _pers_, rmir, para
  { {0x60160014,0x601d0152,0x8d560001,0x2489002a}},	//   záml, réme, _утич, łamy_
  { {0x88860080,0x601d0152,0x39580349,0xfbd200e5}},	//   слеж, séme, _vers_, _فتح_
  { {0xca29000a,0xc8850061,0x39580034,0x872601c6}},	//   גם_, daşı_, _wers_, бмеж
  { {0xe5c6034a,0x39580061,0x6d410061,0xada9002b}},	//   йско, _ters_, ılav, _صدیق_
  { {0xa3ca005d,0xa5f80054,0x7bc6034b,0x0000006a}},	//   रॉन_, јеку_, _hoku,
  { {0xe9d70286,0x66d10030,0x54a60015,0x2246034c}},	//   _укр_, tókö, إحتف, _stok_
  { {0xebd6000a,0x7dcb0072,0x0000006a,0x0000006a}},	//   מֵ֥י_, _hüst,   ,
  { {0x7ae90084,0x6029005c,0x7dcb034d,0x32ba0015}},	//   _þett, _uśmi, _küst, ادعة_
  { {0xba9b0008,0xdcfc0024,0x104a034e,0x7bc6034f}},	//   נסיי, nerē, лями_, _loku
  { {0xe4520002,0x672d00bc,0xdb1d0069,0x5f950350}},	//   _رضا_, žajt, _rosí, оинт
  { {0x601600dc,0x7bc600dd,0xb4d4000b,0x9f42006f}},	//   lámj, _noku, हनी_, tiká_
  { {0xdb1d02d5,0x93a90015,0xd80b000a,0x5f94006b}},	//   _posí, _خالف_, רִיָ, чият
  { {0x270700a7,0xc27b0008,0x63a20125,0x7e640351}},	//   ống_, _תרגי, _haon, _dvip
  { {0xb1e50029,0x7a290007,0xdcfc0024,0x853b00a3}},	//   _بأنه, _užti, derē, רגלי
  { {0x4a550010,0xd0f7000a,0x7c15005e,0x27370046}},	//   жкас, _למות_, ідає, ižní_
  { {0x63a2000c,0x39410152,0x7a570015,0x200b01df}},	// [330] _maon, tchs_, إضرا, moci_
  { {0x531b004c,0x39a70054,0x39410012,0x9faf0046}},	//   רומצ, љшав, uchs_, iří_
  { {0x8d5a000a,0xdcf5003d,0x60160030,0xb8950015}},	//   _דכתי, iezī, zámm, تلاع
  { {0x61c5014e,0xc8850064,0xb6c50015,0x907b000a}},	//   _लक्ष, vaşı_, يْضً, רטאי
  { {0x4ae40010,0xb5fd0227,0x8f8c000a,0xef12000a}},	//   _еўра, _avša, רְבֵ, ֵּד_
  { {0x96280029,0x3e5c0053,0xdcfc0024,0x7bc600aa}},	//   مكنك_, נדוס, cerē, _zoku
  { {0xdb060123,0x7bc60352,0x05760058,0xb4b60058}},	//   _enkä, _yoku, زمية_, قُوا_
  { {0x04560015,0x77d70015,0xc245030e,0x7dcb0353}},	//   آلية_, _اغسط, оник, _küss
  { {0x69c7010b,0x63a2002d,0x85b90354,0x200b0085}},	//   _koje, _daon, _клас_, doci_
  { {0x7dcb018b,0x91e50036,0xd24e002b,0x80650355}},	//   _müss, іоне, کنی_, овож
  { {0x7e64002e,0x8c430064,0xcea9000a,0x7649008c}},	//   _svip, üşle, _שי_, _htey
  { {0x200b0251,0x24650024,0x187a000a,0xcfd30015}},	//   goci_, mēm_, סטרב, ِيَة
  { {0xa294009e,0x24650024,0x68e1007c,0xa3b8002b}},	//   _наці, lēm_, _üldf, _دالر_
  { {0x7dd00356,0xe29f002e,0xa2040036,0x63a2003f}},	//   _käsi, æðu_, _епід, _zaon
  { {0x7bc60357,0x63a20358,0x60160057,0x7dcb0359}},	//   _poku, _yaon, námk, _rüst
  { {0x7dcb0005,0xb0680087,0x1b4a000d,0x7769035a}},	//   _süst, _اصول_, рзаи_, _ndex
  { {0x7dcb0020,0x7e64003f,0xda650029,0x39ea0001}},	// [340] _püst, _uvip, كالي, адао_
  { {0xfd120029,0xba170021,0x6e93002b,0x7bc6035b}},	//   _يجد_, قيقا_, _کلیا, _woku
  { {0x764902f2,0x291c0123,0xd7c6004a,0xa3ca000b}},	//   _atey, åva_, жёло, रॉड_
  { {0x510c00b4,0x24650024,0xddcd005c,0x2d98035c}},	//   נהאַ, dēm_, _gwał, lere_
  { {0xd5ba005f,0x63a20251,0x601d0003,0x98bf003d}},	//   иск_, _raon, néma, ērām_
  { {0xe452003b,0x2d98035d,0x63a2035e,0x69c7035f}},	//   وضع_, nere_, _saon, _goje
  { {0x2609005d,0xb4d4000b,0xd64b005e,0xf7460004}},	//   ाक़ी_, हने_, _дiял, _мево
  { {0x98ba00df,0x2d980360,0x9faf0089,0x32660361}},	//   lapį_, here_, tří_, отов
  { {0xa2940010,0x7e600045,0x2d980362,0x200b0363}},	//   чапі, âmpl, kere_, voci_
  { {0x601d0152,0x2d980364,0xb97a000a,0xcb13000a}},	//   déma, jere_, ׁנִי, ולח_
  { {0x63a20365,0x2d980366,0x2465003d,0x3ea00061}},	//   _taon, dere_, cēm_, _asit_
  { {0x8c430061,0x7a290091,0x289b004f,0xb4250058}},	//   üşme, _užtv, ביטא, _فعنو
  { {0x57fb000a,0x2d980367,0x200b0368,0x41e60369}},	//   שלכו, fere_, roci_, _وستف
  { {0xddcf0011,0x2d98036a,0x68e1007c,0x2a720034}},	//   ducţ, gere_, _üldg, dryb_
  { {0xa1770008,0xa8020064,0xfbd30115,0x69c7036b}},	//   _ועוד_, şıya, وتر_, _roje
  { {0xa0080015,0x320c036c,0x69c7036d,0x7dcb007c}},	//   _وقول_, lody_, _soje, _püss
  { {0x539b0008,0x24650024,0x69c7036e,0x8f88000a}},	// [350] סימו, zēm_, _poje, _וְתֵ
  { {0x7a38005e,0x2d98036f,0x61fa0012,0xc237000a}},	//   цпфр_, cere_, nntl, קרבו_
  { {0xdb1d0089,0x69c70057,0x61fa01f1,0x26cf0034}},	//   _dosá, _voje, intl, wygo_
  { {0x69c70050,0x4c9a0008,0x320c0370,0x3f990371}},	//   _woje, _פברו, hody_, nesu_
  { {0x9bba0008,0x320c002a,0x501c000a,0x3bba000a}},	//   _הצרפ, kody_, בואו, _המרד
  { {0x53a30372,0x85e80036,0x24650024,0x27ef0373}},	//   _खोजश, одів_, tēm_, sign_
  { {0xf7730067,0xd5ae0015,0x94790033,0xed58004f}},	//   _يار_, طفي_, ёску_, חבור_
  { {0x3cfc0135,0xe4d20015,0x2cfc000a,0x6cfc000a}},	//   ילונ, عقيد, ילוא, יפוס
  { {0x2d98003c,0x24650024,0xa2630092,0x6d5a002e}},	//   yere_, sēm_, _giố, ðtak
  { {0x320c005c,0x2465003d,0x2d980374,0x42220138}},	//   gody_, pēm_, xere_, ндыв
  { {0x601602c1,0x224d0375,0x27ed0046,0xa0690054}},	//   lámi, spek_, _kmen_, љама_
  { {0xd8d60008,0x224d00dc,0x25a50376,0x351a000a}},	//   פורט_, ppek_, _hall_, _הוענ
  { {0x320c0377,0x60160378,0x1719000a,0x25a50379}},	//   body_, námi, מוֹע, _kall_
  { {0x7bcb002e,0xd1bb0015,0x44d70016,0x6fe40030}},	//   ögun, _خاصا_, õ_, tőcs
  { {0x81bc0024,0x71d6000a,0x61d6000a,0x91ba000a}},	//   kmēj, _מוסד_, _מוסף_, _למסי
  { {0x63760064,0x2d98037a,0xd12e0015,0x9e6600d7}},	//   münü, sere_, _حمى_, _евид
  { {0x6d4101e2,0x63760064,0xba1a0015,0x8f7b000a}},	// [360] ılar, lünü, ميرا_, _הנפק
  { {0xddcf0011,0x2a6f0030,0x8d56004a,0xdb04037b}},	//   rucţ, ágba_, _этич, ndié
  { {0x6d5e0048,0x63760064,0x5d3b000a,0x7d57000a}},	//   _iepa, nünü, _לתיא, _מייד_
  { {0x1cbb000a,0xf1ba0016,0x7bdf01f1,0x320c037c}},	//   _המטע, _nhơn_, chqu, zody_
  { {0x44d70092,0x6d5e0375,0x25a5037d,0xbddb0003}},	//   ẽ_, _kepa, _ball_, mpèr
  { {0x6d5e00e8,0x25a5037e,0x2b470046,0xdb1d02de}},	//   _jepa, _call_, ěnce_, _bosæ
  { {0x25a502d7,0x320c0107,0x39130033,0x0000006a}},	//   _dall_, vody_, _змёр,
  { {0x320c005c,0x6d5e0375,0x78fb000a,0x5334004a}},	//   wody_, _lepa, _הפלו, мейт
  { {0x44d70092,0x320c037f,0x25a50380,0x8506002b}},	//   ã_, tody_, _fall_, _کوان
  { {0x6720010b,0x2003010b,0x7dd00020,0x7ae40381}},	//   _izmj, čkim_, _käsu, izit
  { {0x63760064,0x99de0033,0x9316002b,0x9f990382}},	//   günü, нiка_, _کوشش, овну_
  { {0x6720005d,0xc43b0008,0x68e1007c,0x2d810383}},	//   _बराक_, _התאי, _ülde, _sche_
  { {0xb80d014e,0xe80d005d,0x6d5e0384,0x7c3e0152}},	//   िकतम_, िकता_, _bepa, _aupr
  { {0x3f990026,0x224b002c,0x7ae4002c,0x6d5e0049}},	//   sesu_, ícke_, dzit, _cepa
  { {0x7c3e0011,0x3f990020,0x63760061,0x9f4b0046}},	//   _cupr, pesu_, cünü, licí_
  { {0xec340036,0xd0110002,0x69dc0385,0x30830015}},	//   енсь, _جلب_, _alre, _أليف
  { {0x25ed005d,0x5a3500ff,0x9f4b0046,0x5e440015}},	// [370] _अगली_, днат, nicí_, _كَيْ
  { {0x11590053,0x443e0386,0x9d55002b,0x44d70016}},	//   ַדױע, _out_, _تندت, ỹ_
  { {0x99d40015,0x7c670002,0x718b000a,0xdb0d007c}},	//   رتكا, _عادل, מְאַ, ljaü
  { {0x69dc00dc,0x98170015,0x3789005e,0x2d840030}},	//   _elre, أبطا, ібло_, őmet_
  { {0x81bc0024,0x999f00dc,0xf7700031,0x63760061}},	//   rmēj, őről_, طان_, zünü
  { {0xf650003b,0x443e003e,0x6d47005c,0x60160387}},	//   ائن_, _but_, ncja, rámi
  { {0x98170029,0x64a20063,0x443e0388,0x25a50389}},	//   _فبرا, ваща, _cut_, _vall_
  { {0x74150087,0x04b40010,0x7dd0038a,0x25a50116}},	//   بوعا, эсія, _häst, _wall_
  { {0x443e0152,0x6d47005c,0x25a5038b,0x7dd0038c}},	//   _eut_, kcja, _tall_, _käst
  { {0x443e038d,0x63760064,0xc5fb0029,0xdb040012}},	//   _fut_, tünü, _اعرض_, heiß
  { {0x7bdd0064,0x6563038e,0x443e0334,0x260a000b}},	//   _olsu, manh, _gut_, िवरी_
  { {0x637601e2,0x7bcb0084,0x27fd0034,0x7dd0038f}},	//   rünü, ögul, nnwn_, _läst
  { {0x2e2400b8,0x7dcb00dc,0x63760061,0x7c3e0390}},	//   höfe_, _püsp, sünü, _supr
  { {0x7dd001d1,0xf2d2000a,0x3f5c0016,0x12e8000a}},	//   _näst, _בעד_, ậu_, _מַצּ
  { {0x62890391,0x3178002a,0x4cb70033,0x63a90392}},	//   lteo, órze_, млёю_, oden
  { {0x7bc4003f,0x305a000a,0xab7a0015,0x6289008c}},	//   ujiu, _ודקד, تمرا_, oteo
  { {0x7dd000c0,0xde1a0029,0x6d5e013c,0x62890393}},	// [380] _bäst, _وقعت_, _tepa, nteo
  { {0x63a900f2,0x673b0394,0x62890395,0xbddb00e9}},	//   hden, _aguj, iteo, spèr
  { {0xd7ef0396,0xd910002b,0x9f4b0046,0xb8650015}},	//   ву_, ایز_, zicí_, فانو
  { {0xf98900b2,0x38cb002b,0x63a90397,0xdb1d0123}},	//   יר_, غالی_, jden, _bosä
  { {0x443e0176,0x7dd000c0,0x77910086,0x96b70054}},	//   _sut_, _fäst, طیلا, дују_
  { {0x443e0398,0x69c30399,0x63a9039a,0x7dd0039b}},	//   _put_, önet, eden, _gäst
  { {0x97be0010,0xa4d80036,0x6feb005c,0x78450007}},	//   _краi, ядку_, ręcz, _tėva
  { {0x7a290007,0x60080061,0xd499005e,0xf3ca0015}},	//   _užtr, nımd, ярі_, تبته_
  { {0xa80201e2,0x443e0012,0x6563016e,0xcb89000a}},	//   ğıda, _wut_, banh, פְקֹ
  { {0x7abb0008,0x05760021,0x63a9039c,0x9f4b0125}},	//   קציו, _زائد, aden, ricí_
  { {0x7dd000b8,0x653b000a,0xc057022a,0x60080061}},	//   _läss, _ועבד, мія_, kımd
  { {0x601d0152,0x2918039d,0xb4aa0065,0xd25a009b}},	//   rémo, _myra_, गटी_, _дцк_
  { {0x03d7039e,0x5e84018d,0x6289039f,0x6008007f}},	//   _קודם_, курз, cteo, dımd
  { {0xd337000a,0xdb040012,0x160e0065,0x02ca0065}},	//   _חרדה_, weiß, ाकिर_, िहीन
  { {0x2bbb0029,0x2ba7000d,0xab950001,0x2d870064}},	//   يارة_, мјав, нављ, _önem_
  { {0xe451000a,0x8b5b0015,0x6e2003a0,0x0000006a}},	//   רֶם_, تجسس_, ïmbr,
  { {0x160e005d,0xdb040012,0x6d47002a,0x6b8d03a1}},	// [390] ाकार_, reiß, pcja, rfag
  { {0xdeb60008,0x442603a2,0x63a903a3,0xf9930021}},	//   _נפתח_, _lho_, zden, ضبط_
  { {0x7dd003a4,0xd7590015,0x5dc8000a,0x60080061}},	//   _väst, كلات_, _חֶרְ, bımd
  { {0x44260092,0xe758005e,0x9cd6000a,0xb7940054}},	//   _nho_, диці_, _נורה_, вршћ
  { {0xda670074,0x2003010b,0x7dd0022d,0x6563001c}},	//   _تاجي, čkih_, _täst, tanh
  { {0x291800c0,0xd1260015,0xd5f30033,0x7c2d03a5}},	//   _fyra_, _مم_, _лiнг, lmar
  { {0xfc46002c,0x683a0089,0x656303a6,0x23d503a7}},	//   žíva_, _vůdc, ranh, ецпр
  { {0x442600a7,0xa3ca000b,0xe8940033,0xad38000a}},	//   _cho_, रॉल_, _шась, ונוס_
  { {0x6563001c,0x46580029,0x66f3021e,0xe7300015}},	//   panh, _يؤكد_, _अधिक_, _نصك_
  { {0x7e7d0020,0x7582002b,0xc5170015,0x60e903a8}},	//   dusp, _میهم, _قبضت, змом_
  { {0x94a803a9,0x7c2d03aa,0x60160030,0x9f4b0144}},	//   _отца_, kmar, zámu, ficà_
  { {0x2a690020,0x644103ab,0xb4db000b,0x93940015}},	//   ksab_, _iuli, डनी_, _لجها
  { {0x644103ac,0x201e0024,0x7e7d0171,0x81d503ad}},	//   _huli, ēti_, gusp, _подх
  { {0x270e0023,0x64410278,0xa2f6000a,0xdca603ae}},	//   ộng_, _kuli, _אמנה_, наги
  { {0x656103af,0x644103b0,0xfce603b1,0x442d03b2}},	//   _melh, _juli, хово, ome_
  { {0xf0620063,0x442d0064,0x7c2d03b3,0x644103b4}},	//   _скъп, nme_, gmar, _muli
  { {0x160f014e,0x291e010b,0x442d03b5,0x4c350033}},	// [3a0] िवार_, _šta_, ime_, тэрт
  { {0xdb0602d5,0x442d03b6,0x5e570053,0xd23a004c}},	//   _jaké, hme_, _רייע_, פגעל
  { {0x644103b7,0x7c2d03b8,0x442d03b9,0x7dd00012}},	//   _nuli, bmar, kme_, _wäss
  { {0x7dd0022d,0xe8530086,0x3f820375,0x69c303ba}},	//   _täss, انند, ngku_, öner
  { {0xceb30008,0x442d03bb,0xeb3b000a,0x601603bc}},	//   ָיו_, dme_, _מעכש, láms
  { {0x9916008f,0x7a8b000a,0x442d03bd,0x86230342}},	//   _зьбі, _מָלַ, eme_, льще
  { {0xdcfc0048,0xb7960001,0xd49703be,0x44260016}},	//   derī, _праћ, еры_, _pho_
  { {0x442d03bf,0x68e1007c,0x6561007c,0x9f4b0144}},	//   gme_, _ülda, _eelh, xicà_
  { {0x656103c0,0x179b0053,0x23270054,0x316503c1}},	//   _felh, _צימב, ноћи_, falz_
  { {0x442603c2,0x7e7d0020,0x442d03c3,0x96a70033}},	//   _who_, vusp, ame_, _якуб_
  { {0x33d60191,0xf9930008,0xdfd103c4,0x09f7000a}},	//   _підт, ארת_, ليد_, תמים_
  { {0x04db0008,0x442d002d,0xa2e603c5,0x9f4b016e}},	//   _מקבל, cme_, _поед, ficá_
  { {0x9f4b0251,0x0cc9000b,0xa3d5000b,0xb3e9002b}},	//   ricà_, रह्म, _सकत_, _تعلل_
  { {0x2d850064,0x69ce03c6,0x3f710016,0x7afb0085}},	//   üle_, _nobe, ễu_, _žuto
  { {0x246c0046,0xac1903c7,0x0217000a,0xe1330033}},	//   něm_, дову_, _רחום_, _йншы
  { {0x7c2d03c8,0xdb060030,0x7e7d02f2,0xf0b7004f}},	//   umar, _zaké, pusp, _טלור_
  { {0x9f4b0020,0x7c2d03c9,0x9963006f,0xda7803ca}},	// [3b0] öjõu_, rmar, ríži_, еях_
  { {0x4efc000a,0x601d0046,0x69ce03cb,0x7c2d03cc}},	//   _מהחו, kémk, _cobe, smar
  { {0xe3c301e2,0x99840029,0x69ce03cd,0xfe36000a}},	//   ngıç_, المو, _dobe, _שרתי_
  { {0x65610089,0x6441003e,0x96f9004a,0x58b80015}},	//   _selh, _ruli, меет_, عالج_
  { {0xe72e0001,0xb6a50080,0xe7e2000b,0x85b8002b}},	//   ре_, тилл, _खतरा_, کانس_
  { {0x69ce03ce,0x7b070045,0x644103cf,0x0000006a}},	//   _gobe, ăptă, _puli,
  { {0x656103d0,0xd61800e6,0xdb060030,0x442d03d1}},	//   _velh, رتها_, _raké, tme_
  { {0x7bcf0011,0x14190015,0x4cbc000a,0x656103d2}},	//   _jocu, بيعة_, למוג, _welh
  { {0x69d80014,0x13090191,0x442d03d3,0x656103d4}},	//   öveg, ьний_, rme_, _telh
  { {0x7bcf03d5,0x644103d6,0xb5fd006f,0x442d03d7}},	//   _locu, _tuli, _ovši, sme_
  { {0xdb1d002f,0xf8e1005d,0xc0580010,0x80cb000b}},	//   _cosú, पनिय, ніў_, ाहें
  { {0x13a70086,0x60080064,0x31650012,0x0000006a}},	//   _سنتی_, dımc, salz_,
  { {0x3f8c005c,0x69c4005d,0xdb06002c,0x73c40015}},	//   ędu_, रामी, _také, _حينم
  { {0x82760053,0x63ab002e,0xd24e0015,0x867a000a}},	//   _יענע_, _hagn, _بنو_, ורשו
  { {0xa3d5005d,0xa0a50036,0x40940010,0xe588000a}},	//   _सका_, _райд, _брыт, עָשָ
  { {0x7ff60086,0xd00f00e6,0xddcd002a,0x79950012}},	//   _جستا, _ولو_, _kwaś, _abzw
  { {0xe7f7005d,0xd9460001,0x69ce03d8,0x78b5003d}},	// [3c0] ूचना_, вези, _pobe, _arzv
  { {0xdb0d002e,0xbd460029,0x7e600045,0x3856006b}},	//   rjað, _جندي, âmpu, въдс
  { {0xfeba0086,0x7bcf00d1,0x8ddb000a,0x81bc003d}},	//   _راکت_, _focu, _חקיק, mmēt
  { {0xd7ef0029,0x27e003d9,0x69ce03da,0x63ab03db}},	//   يكل_, óin_, _wobe, _nagn
  { {0xe7f3000b,0x34da000b,0x68e1007c,0x200203dc}},	//   _आगरा_, बन्द, _üldn, inki_
  { {0xa6130010,0x69d80030,0x8b0b004f,0x6b840072}},	//   аміч, öved, _חִלֵ, lgig
  { {0x44a30029,0x02ca000b,0x3545005e,0x9f42006f}},	//   لموق, िह्न, ухів, ahké_
  { {0x60160030,0x7174002b,0x601d0046,0x9f650030}},	//   zámr, گهدا, rémk, étük_
  { {0x41e60010,0x8c1b000a,0x81bc003d,0x99830091}},	//   віна, ווקי, kmēt, _gijų_
  { {0x60080064,0xdb1d002c,0xd657000a,0x7d090061}},	//   yımc, _posú, _סיבת_, şesi
  { {0xb97b013a,0x161b000b,0x897b000a,0x30a3006b}},	//   וניי, _पीटर_, וריצ, аряв
  { {0x63ab03dd,0x14d7000a,0xe3c30061,0x5436006e}},	//   _gagn, _שואל_, rgıç_, _شرار
  { {0xd336008f,0xd2500029,0xf8bf000b,0xa19403de}},	//   _рэжы, _انت_, _एप्प, _балч
  { {0x63ab03df,0xe0d20015,0x6b84007c,0x91e30054}},	//   _zagn, _نزع_, egig, _воље
  { {0x7dcb00dc,0xa3d6000b,0x9f420046,0xfe6e002b}},	//   _küsz, _हवा_, liký_, يگی_
  { {0x313700f3,0x60080061,0x3ed5012c,0x7b770040}},	//   _ברוך_, rımc, _مقبر, ضطرا
  { {0xfc300015,0x63a0002a,0x3b64006b,0xbbd3000b}},	// [3d0] زحف_, iemn, ръсв, _सवीक
  { {0x601d03e0,0x6b8402f2,0x60080061,0x60160077}},	//   démi, agig, pımc, lámp
  { {0xf1ba0092,0xf7750127,0x628003e1,0xec6b0033}},	//   _chơi_, гулю, humo, _ўрок_
  { {0xf09300b2,0x2e24002e,0x628003e2,0xf7700015}},	//   ינע_, nöfn_, kumo, قاه_
  { {0x62800024,0x60080064,0xdb7a000a,0x35d5004a}},	//   jumo, nıma, _אנרכ, лодё
  { {0x16a603e3,0x68e1007c,0x27e602f2,0x2e24001a}},	//   увши_, _üldo, ahon_, höfn_
  { {0x478b0001,0x63ab03e4,0xcd98000f,0x2002002a}},	//   _осам_, _pagn, דדות_, ynki_
  { {0x3d3c0008,0x24960086,0x3ea900f2,0xe3b10015}},	//   וגוס, انيد_, _osat_, صرب_
  { {0x62800007,0x7c3d03e5,0x63ab03e6,0x92b50021}},	//   gumo, _misr, _vagn, احبا
  { {0xb0ae005d,0x55bb0015,0x3f890034,0x00c9004a}},	//   टिंग, _تطرح_, _acau_, елок_
  { {0x228b003c,0xf4840010,0x70520086,0x88f6000a}},	//   søk_, _вучн, ینیا, ָ֖יו_
  { {0x5f760086,0xdb0d0020,0x653a004c,0x92b5012c}},	//   دادر, ljaõ, _װענד, _محتا
  { {0xfeba002b,0x7f19005e,0xe2990033,0x3ea90045}},	//   راحت_, віру_, _чал_, _csat_
  { {0xc332000a,0xd24e0015,0xdb1d01f6,0x5d760138}},	//   _הוד_, _عنى_, _insè, ыумф
  { {0x3ea90048,0x81bc0024,0xeb9a03e7,0xfce303e8}},	//   _esat_, rmēt, нив_, боро
  { {0x81bc03e9,0x5f76006e,0xfaa603ea,0xa09a004f}},	//   smēt, _صابر, лабо, _נספח
  { {0xac070080,0x7c3d003e,0xda650029,0xfe72002b}},	// [3e0] унта_, _disr, لالي, _ادب_
  { {0xd6c40086,0x7a22002c,0x69c4000b,0x443d0034}},	//   یمای, rôto, राधी, _liw_
  { {0x81bc03eb,0x68e1007c,0x8e37000a,0xcb6a03ec}},	//   slēg, _üldl, _תניא_, _пане_
  { {0x4b550063,0xd70a004a,0x48060033,0x81bc003d}},	//   _върт, ннее_, ыпев, nmēr
  { {0xcc3b0053,0xddc400bd,0x6d5c03ed,0x25ac0046}},	//   _רעכט, _zviš, obra, _padl_
  { {0xe9df002f,0x86750010,0x7d1e01be,0x6d5c03ee}},	//   _dtús_, рыцц, _kyps, nbra
  { {0xe0c703ef,0x601d0003,0x2a07027a,0x27e603f0}},	//   _از_, sémi, _серп_, phon_
  { {0xc27403f1,0xb908021e,0x75240046,0x443d0034}},	//   алиј, यन_, řizo, _ciw_
  { {0xfbd30008,0x26c200bc,0x37060151,0x63a003f2}},	//   מתה_, _škof_, _спаг, remn
  { {0xe6170010,0x81bc0024,0x63a003f3,0x569b000a}},	//   _бду_, emēr, semn, _אימצ
  { {0x43860086,0xe97b0053,0xb97b0053,0x5a17000a}},	//   _ملاق, ענטש, ענטי, רקין_
  { {0x75280048,0x273a0064,0x8937004c,0x75250012}},	//   _izdz, _günü_, טריע_, ühze
  { {0x7a2b0353,0x7413009a,0x6d5c02ad,0x0000006a}},	//   lüte, _اونا, fbra,
  { {0xf1a3006b,0xc333004c,0x81bc003d,0x2e24001a}},	//   _грън, _פוס_, rmēs, söfn_
  { {0x721b0008,0xdb1d0152,0x55bb000a,0x61fa03f4}},	//   _רווח, _insé, עמלו, mitl
  { {0x81bc0024,0x3b55000d,0xa4e7000a,0x3c440033}},	//   slēd, ркар, רֵךְ_, сэрв
  { {0x6d5c03f5,0x9f490061,0xef1f0012,0x3ea90144}},	// [3f0] bbra, _amaç_, afür_, _usat_
  { {0x6d5c001c,0xdcfc0024,0x61fa03f6,0x6d5a0061}},	//   cbra, sgrā, nitl, ıtac
  { {0xa3d5000b,0xa8020061,0xf7550015,0x317b000a}},	//   _सकल_, ğına, لناج, תאבד
  { {0xa8020064,0x68e1007c,0x61fa03f7,0x7e7d03f8}},	//   şına, _üldm, hitl, orsp
  { {0xa635005e,0xa7640033,0xd90f002b,0x600c000a}},	//   анді, скід, _کیا_, עִבְ
  { {0xaaa80063,0x81bc0024,0xab5b0012,0xf98900c3}},	//   _съюз_, zmēr, _unüb, _جنسي_
  { {0xadd8000a,0x8235002b,0x7e7d0012,0x7a2b0012}},	//   רווח_, یرخا, hrsp, güte
  { {0x6d5c03df,0x6d410064,0x7bcd0375,0xc4f80015}},	//   zbra, ılay, njau, دعها_
  { {0xd1b90087,0x7aed03f9,0x11e503fa,0x59c9000b}},	//   نادا_, nzat, ижим, रापर
  { {0x43750074,0x8467010f,0x20b50010,0x7bcd00f2}},	//   _چهار, _бъде, аёмс, hjau
  { {0x23c5005d,0x55ba039e,0xe5c403fb,0x43750021}},	//   वादद, _שמעו, _усто, _نهار
  { {0x229503fc,0x7aed0030,0x61fa0125,0x44270067}},	//   _видя, kzat, aitl, _صراف
  { {0x81bc0024,0x1e8301b7,0x78450091,0xe1f1012c}},	//   rmēr, олям, _dėvi, _وست_
  { {0x61fa031c,0xa252002b,0x7aed006f,0xdb04016e}},	//   citl, _بپوش, dzat, ldiç
  { {0x8f76017f,0xad250015,0x6d5c03fd,0x6f0d03fe}},	//   _купі, مرفو, rbra, _exac
  { {0x2fc00176,0x35c7014e,0xdb0403af,0x78ba002c}},	//   _unig_, लाड़, ndiç, _štvo

  { {0x4b550063,0x89660292,0x68e103ff,0xc9660355}},	// [400] съст, икаж, _üldj, ивай
  { {0x48b60063,0x7edb0053,0x99980046,0x7d1e0400}},	//   ищет, _סקיצ, _virů_, _typs
  { {0x3205003e,0x6d7b000a,0x98740046,0x7d7b000a}},	//   inly_, _באיח, _týče_, _בריג
  { {0x2cac001a,0x7b96005e,0x37760033,0x31670401}},	//   æddu_, _трої, рыжс, _lenz_
  { {0xbad50033,0x46f60004,0xe5c60402,0x7aed002a}},	//   _ліры, јчет, иско, czat
  { {0x5d7a00b2,0xd49a0403,0x36330015,0x6729003d}},	//   דאַק, ври_, يروس, _dzej
  { {0x53e60404,0x26c20046,0x399b000a,0x94aa004a}},	//   ициа, _škod_, _שילד, ттла_
  { {0xe3b20015,0x7a2b0405,0x656a019f,0x7afb0160}},	//   زرع_, rüte, safh, _žuti
  { {0x61fa0406,0xe7b30015,0x7a2b0030,0x41c60033}},	//   titl, _بمقد, süte, аёна
  { {0x6b960034,0x90e60058,0x9f5901f6,0x244a00a1}},	//   hfyg, لسجن, misé_, _tùm_
  { {0x7aed02d7,0x9f59038d,0xe1ef0015,0x3015005e}},	//   zzat, lisé_, بسي_, йдор
  { {0xf8b30008,0x61fa0407,0xde590210,0x44200408}},	//   קשר_, sitl, ламі_, _ói_
  { {0x7e7d0409,0x9f590003,0x6b96040a,0x42540040}},	//   ursp, nisé_, dfyg, _انتر
  { {0x752d0089,0xdef80010,0x60080064,0x7aed0107}},	//   řaze, рыю_, lıml, vzat
  { {0x31570008,0x7b670080,0x7bcd0024,0x30840029}},	//   _דיון_, итае, tjau, _العف
  { {0x600801e2,0x7aed0251,0x113b0008,0x7ff400a2}},	//   nıml, tzat, _בתול, _وسيا
  { {0x6e95040b,0x7bcd022d,0x5e95003b,0xadbd0033}},	// [410] _الخا, rjau, _الخط, _запi
  { {0x68e10020,0xa8020064,0xbd2b0029,0x2019040c}},	//   _üldk, şıla, _لأجل_, losi_
  { {0x7aed00dc,0x58870010,0x60080061,0x18a4005e}},	//   szat, рыза, kıml, жаєм
  { {0x27690086,0x2019040d,0xd874012c,0x6675009a}},	//   اشای_, nosi_, زامب, مدتر
  { {0xef1f0064,0xcfb8000a,0x60080061,0x601d0046}},	//   zgün_, ילאי_, dıml, léms
  { {0xe6180036,0xbb3a0008,0xc98403e3,0x2019040e}},	//   аді_, _תעשי, _муси, hosi_
  { {0x33f5005e,0x86240033,0x2019040f,0x65680383}},	//   йчис, цьце, kosi_, _dedh
  { {0xd77403c4,0x316702b9,0x58050015,0xeb91000a}},	//   _واقع, _senz_, _اورك, הָ֙_
  { {0x6d45002d,0x65680410,0x68f70091,0x9f59008c}},	//   _ogha, _fedh, žadė, insä_
  { {0x6d450176,0x27fd0026,0xdb060089,0x86c40015}},	//   _ngha, liwn_, _jaká, _بيكن
  { {0x27330023,0xa87900b2,0xcea90008,0x69d50411}},	//   _ảnh_, װאָר, _רי_, _moze
  { {0x6d45002f,0xdb060412,0x0394005e,0xd24e002b}},	//   _agha, _inkö, _мрія, بنی_
  { {0xc2cb0029,0x1dc3000b,0xdb1d0030,0xc43a004f}},	//   _جبال_, शांत, _mosó, _עתני
  { {0x9f5900f2,0xd336000a,0x644801d7,0x831a000a}},	//   ensä_, _פרסה_, _yudi, _גונז
  { {0xe0550029,0x68e10020,0x409200e5,0x76410413}},	//   _اختب, _üldh, _فلور, _mily
  { {0x2d8c005c,0x66180227,0x77690414,0x9955006f}},	//   żde_, zovk, _neex, výši_
  { {0x4a430415,0xbf890015,0x27fd0416,0xdd110417}},	// [420] знув, _ضئيل_, diwn_, _výši
  { {0x9f590152,0x7bcb002e,0xe9d70418,0x0d76002b}},	//   visé_, ögur, бку_, _دیسک_
  { {0xb8650029,0x60080064,0xa8020064,0x7c960031}},	//   قانو, yıml, şıma, _اشخا
  { {0x6448000c,0x263d006f,0x76410034,0x61e6003d}},	//   _rudi, _dňom_, _aily, īkli
  { {0x501b000a,0xa6fa0015,0x25560015,0xd5b10016}},	//   נונו, دعاء_, منشآ, _bá_
  { {0x9f590152,0x644802c1,0xd5b10092,0xceb30008}},	//   risé_, _pudi, _cá_, פיו_
  { {0xd4670124,0x76410176,0x65680134,0x60080061}},	//   бије_, _dily, _vedh, tıml
  { {0x9473003b,0x32540419,0xdb060227,0xe6460033}},	//   أدوا, овир, _zaká, _геап
  { {0x60080064,0xaac8000b,0xf1aa006e,0x2019041a}},	//   rıml, रमिक, هاده_, vosi_
  { {0x9098000d,0x76410026,0x31c60080,0xa074041b}},	//   авот_, _gily, ссив, огоч
  { {0x6448041c,0x2019041d,0xe28f002b,0x3ea001d7}},	//   _uudi, tosi_, وذی_, _apit_
  { {0x493b000a,0x5f39005e,0x2019008c,0x77ca000a}},	//   טגיו, ипня_, uosi_, אמֹ֗
  { {0x22570086,0x2d98041e,0x2019041f,0xc0e7009a}},	//   _هلند_, ffre_, rosi_, لفین_
  { {0xddcd0050,0x93250029,0xa1580036,0x7c240399}},	//   _stał, _برمن, _таку_, elir
  { {0x9cc80010,0xe4780008,0x69d50420,0xd12f0421}},	//   быта_, יָּש, _roze, _хх_
  { {0x68e10005,0xdfd10015,0x9fe7002b,0xa4fb004c}},	//   _üldi, _آية_, _دسته, אללט
  { {0xdd910029,0x69d50107,0x77690422,0x44240423}},	// [430] _قوة_, _poze, _reex, ilm_
  { {0xceb40053,0x9e15005e,0x78eb004a,0x62800424}},	//   _זיץ_, _єдні, льев_, irmo
  { {0x7afb002c,0x58840010,0x69d50425,0xdb1d0426}},	//   _ľutu, зыча, _voze, _insí
  { {0xe76b002b,0xdcfc0091,0xdb0f0003,0x76b90427}},	//   احان_, ugrą, _lacé, илер_
  { {0xdb230074,0xdc0f0046,0x59c9000b,0xdb060428}},	//   _روسی, něčn, रादर, _taká
  { {0x27fd0176,0x4efc0008,0x49cb004a,0xdce50046}},	//   siwn_, נהגו, _сумм_, _lehč
  { {0x9475002b,0xdb07001a,0xdb1d0125,0x64b3000b}},	//   تگذا, álæg, _tosó, ंटेश
  { {0xd794006b,0xdc6c004f,0x84360058,0x0000006a}},	//   _нисъ, נ֣וֹ, يكور_,
  { {0x72c5005e,0x0000006a,0x0000006a,0x0000006a}},	//   ібоз,   ,   ,
  { {0xbb3c00b2,0xfaff00dd,0xef1f0064,0x85bb0015}},	//   נעזי, _reël_, rgül_, _حارس_
  { {0xa0690124,0x23790086,0xe5c40256,0x600a0429}},	//   јама_, _نماد_, _эсто, ином_
  { {0xd9a6005d,0xcdc90008,0x6442042a,0xc4d80054}},	//   _ऑस्ट, _בך_, _gioi, _уђу_
  { {0x8db60036,0x11d5042b,0x51f500a2,0xb1d50058}},	//   осві, _мікр, _وستر, _ويؤث
  { {0x11440015,0x73040033,0x8c4602ed,0x4df502ed}},	//   _فَهُ, _эпіз, жеве, пяст
  { {0x10d50033,0x7a300123,0xfce601c5,0xee3700ce}},	//   _філё, näte, цово, інс_
  { {0xec160086,0xdb0d002d,0xf092000a,0x7c24042c}},	//   آورد, adaí, _חנה_, ulir
  { {0x533600b2,0x3ea0016f,0xdde9002b,0xeab7042d}},	// [440] ַנען_, _upit_, _گريه_, ойт_
  { {0xc9860029,0x998a0091,0x3ead0061,0x2afe000b}},	//   تشري, _ribų_, çete_, _रेणु_
  { {0xa17a0053,0xb17a0053,0xfc320015,0x78660033}},	//   שטעט, שטער, _يحج_, ікдз
  { {0xb09a0053,0x7a3000f2,0xca290008,0x7794002b}},	//   ייער, däte, דם_, ثیرا
  { {0xdce70024,0xf1a9000b,0xdb040125,0xc7a30004}},	//   majā, क़ान, hdiú, ќичк
  { {0x78af022d,0xdce70024,0xfa67042e,0xa96a00af}},	//   äivä, lajā, _фарк_, _њива_
  { {0x37e60036,0x14ca004a,0x0000006a,0x0000006a}},	//   _довг, рыли_,   ,
  { {0xdce70024,0xd6aa002b,0x97c60015,0x7dd0008c}},	//   najā, _پدرم_, _بتسم, _väsy
  { {0xc1a600d7,0x7bdb000a,0x6442008c,0x320a00af}},	//   ојни, שקפו, _vioi, ихон_
  { {0x68e90089,0x1a9b000a,0x81bc003d,0x6016001a}},	//   _ředi, סייע, alēn, mámy
  { {0xc9530008,0xa0540036,0xdce70024,0x7bc6042f}},	//   ומת_, явні, kajā, _onku
  { {0x429a0015,0x251b000a,0x645a0430,0xc034002b}},	//   _ننصح_, _דובא, _itti, وژيک
  { {0xf7730008,0x2ef40010,0xf1a9002b,0x68e1007c}},	//   וקר_, дзяр, _گانه_, _üldv
  { {0x69d800dc,0x9f590046,0x683102de,0x7bc60353}},	//   övel, misí_, måde, _anku
  { {0xdb0d002f,0x9f59002d,0x9b6b000d,0xf1a9002b}},	//   rdaí, lisí_, ишаа_, _دانه_
  { {0x3eb000f2,0xda670029,0xaa55006b,0x0077000a}},	//   ältä_, قائي, зваш, _ותהי_
  { {0x2aab0431,0x161a005d,0x03d7000a,0x7e2b0033}},	// [450] штво_, धवार_, קומם_, _віна_
  { {0x645a02d7,0x7c3a0007,0x5a340432,0xbf340015}},	//   _otti, įtra, днут, _غريغ
  { {0x6d55005c,0x9f59002d,0x8b670015,0xd60402a3}},	//   mcza, hisí_, _واحم, _лiкв
  { {0x99980007,0x27e900dc,0x6d55005c,0x0137000a}},	//   _virš_, óan_, lcza, קראת_
  { {0x4fbc0053,0xf1bc005d,0x645a0433,0x5b56000a}},	//   יזאצ, ्ञान, _atti, _מירב_
  { {0x7a3000b8,0xbb3a0008,0x8f1c000a,0x6b8d007c}},	//   täte, _לערי, בודת, lgag
  { {0x05760029,0xcd7c000a,0x69c70434,0x4d7c000a}},	//   سمية_, שְׂכ, _inje, שָׂא
  { {0x7a300435,0x6d55002a,0xf7730040,0x6b8d0436}},	//   räte, hcza, _زار_, ngag
  { {0x645a01e2,0xc7b2000f,0xae0b000b,0xf647005e}},	//   _etti, _אבן_, हचान_, _єхан
  { {0x200b005c,0x7a300437,0x2297006f,0x64b70058}},	//   enci_, päte, eľká_, _وحضر
  { {0x6d550050,0xc617005d,0x68310123,0x7e7b003d}},	//   dcza, दकीय_, pådd, šupl
  { {0xdd920086,0x34b6000a,0x6d55002a,0x24770045}},	//   کوس_, _מפעם_, ecza, măm_
  { {0x33f40029,0x24770011,0x63a90438,0xdce7003d}},	//   _تسلس, lăm_, meen, vajā
  { {0x725a0008,0x63a90439,0x52d6000a,0x224b006f}},	//   _הכספ, leen, _מונע_, ícku_
  { {0xdce70048,0x24770011,0xa2a3000b,0xdb0f0061}},	//   tajā, năm_, कबक्, _encü
  { {0x78ba00dc,0x6b8d043a,0x24510057,0x60dc043b}},	//   _átvi, ggag, _mám_, ärme
  { {0x24770092,0xdce7003d,0x200202f1,0x8a460015}},	// [460] hăm_, rajā, miki_, سَان
  { {0x4efb0008,0x63a9043c,0x6b8d02f2,0xe9d7043d}},	//   _להפו, heen, agag, пку_
  { {0x4ddb013a,0x24770011,0x24510264,0x63a9043e}},	//   _החיו, jăm_, _nám_, keen
  { {0x2002043f,0x63a90079,0xf989000a,0x24770045}},	//   niki_, jeen, טר_, dăm_
  { {0xa3cf005d,0xdb0600c0,0xf6d3002b,0x869a033d}},	//   शान_, _bakå, فزود, стет_
  { {0xf1d00092,0xe5b30010,0x9f590057,0x746a005e}},	//   _mạch_, ейшы, visí_, брив_
  { {0x24770440,0xd4670001,0x24510092,0x200203d6}},	//   găm_, пије_, _cám_, kiki_
  { {0x6d55005c,0x2002003f,0x24510441,0xd4670054}},	//   zcza, jiki_, _dám_, чиће_
  { {0x6d55005c,0xdce50024,0xa3530015,0x36670442}},	//   ycza, _mehā, رخيص, _нато_
  { {0x68310443,0x51f8005e,0x2b46006f,0x27e60444}},	//   råde, інню_, ľoch_, lkon_
  { {0x20020445,0xf1af0029,0x24770011,0x68e10020}},	//   fiki_, اءً_, căm_, _üldt
  { {0x6d55005c,0xf1d00092,0xa2630092,0x27e60446}},	//   wcza, _bạch_, _khố, nkon_
  { {0xf19401c5,0x234b002b,0x41e601f3,0xb3bb000a}},	//   _жиль, _اسمی_, _ніка, _למאכ
  { {0x127b0053,0x7a2b0064,0xc27b039e,0xf27b000a}},	//   _פאוע, gütl, _פרוי, _פרוש
  { {0x6d55005c,0x819b000a,0xf19b0447,0x319b000a}},	//   rcza, _הסוצ, _השוש, _הבונ
  { {0x40eb000a,0x321e0448,0x1bd40449,0x3015005e}},	//   _לַחֲ, loty_, нося, _ідпр
  { {0x24770011,0x59d90010,0xf1d00092,0xdb23002b}},	// [470] zăm_, одаў_, _gạch_, روطی
  { {0x96b3005d,0xceb4000a,0xdce70045,0x27e6008c}},	//   _इनबॉ, _טיפ_, gajă, ekon_
  { {0x4ddc0008,0x67d5044a,0x24770045,0x986b0015}},	//   _לחזו, можу, xăm_, صحاف_
  { {0xdb0f02c1,0x24770011,0xa08b000a,0xeabf0016}},	//   _hací, văm_, מְדִ, _trù_
  { {0xa2630092,0x24510057,0x9bba000a,0x9f4b0077}},	//   _chố, _sám_, _וצרפ, licó_
  { {0x24770011,0x2002044b,0x27e6044c,0x63a9044d}},	//   tăm_, ziki_, akon_, ween
  { {0x5884044e,0x63a9044f,0x4424002b,0xe5700040}},	//   _пыта, teen, کروف, اطه_
  { {0xf8b20008,0x24770450,0x7a300451,0x24510107}},	//   _בשל_, răm_, mäta, _vám_
  { {0x24770011,0x63a900ed,0x27ff01c2,0x0000006a}},	//   săm_, reen, _imun_,
  { {0x1306005f,0x81bc0048,0x68e10005,0x24510092}},	//   ьный_, blēm, _ülds, _tám_
  { {0xf1d00092,0x1faa000d,0x66030452,0xa988000a}},	//   _sạch_, окни_, mink, הָרִ
  { {0x9f4b02c1,0x351a004c,0x66030453,0x320c0454}},	//   dicó_, _ווענ, link, andy_
  { {0x20020455,0x69d800dc,0x23740067,0x784c0061}},	//   riki_, övek, _سانح, _işve
  { {0xc332013a,0x9f4b02c1,0x66030456,0xdca60457}},	//   _סוג_, ficó_, nink, маги
  { {0x81bc0048,0x27ed0458,0x2d840061,0x80160459}},	//   klēj, _olen_, ğme_, _офиц
  { {0x2d840064,0xc8f9000b,0x7a2b007c,0x6603045a}},	//   şme_, ्पैम_, sütl, hink
  { {0x1ee8002b,0xa037000a,0x6603045b,0x4a46045c}},	// [480] _رودی_, _קאפה_, kink, днав
  { {0x6603045d,0xbf9b016e,0x9059000a,0xe800000b}},	//   jink, niên, ַכְת, लोना_
  { {0x16c6005d,0x6603045e,0xdce70045,0x27e6008c}},	//   लम्ब, dink, rajă, tkon_
  { {0xa2630092,0xdb0f0089,0xcc360010,0xbf9b0092}},	//   _phố, _zací, _іхны, hiên
  { {0x27e600f2,0xfbdf0092,0xa73a0015,0xf743045f}},	//   rkon_, _kiên_, آثار_, вецо
  { {0xdef7000a,0xe5340121,0x66030460,0x186a0461}},	//   ומנט_, нель, gink, _маги_
  { {0x64a30001,0x81bc0024,0xdcfe0064,0x7ae400f2}},	//   ваја, blēj, _kapı, lyit
  { {0xfbdf00a7,0xa2630023,0xbf9b0152,0x248002c6}},	//   _liên_, _thố, nnêt, čim_
  { {0x23270001,0xe3af0015,0xdce7002a,0x321e002a}},	//   моћи_, شري_, mają, toty_
  { {0xfbdf0092,0x6603005c,0xdce7005c,0x22590462}},	//   _niên_, cink, lają, íska_
  { {0x69dc0463,0x22470464,0x321e0465,0xf1f7002b}},	//   _more, _dink_, roty_, بعيت_
  { {0xdce7005c,0xd0110115,0xa2a9000b,0xe3630317}},	//   nają, الح_, _जैक्, _акци
  { {0xfbdf0023,0xe81f005d,0x69dc00dd,0x3f850064}},	//   _biên_, यकता_, _oore, ğlu_
  { {0xbf9b0466,0xf1aa0029,0x9f4b0077,0x70540015}},	//   ciên, _ذاته_, ticó_, _كنتا
  { {0xdb0f0467,0xdce7005c,0x26c20046,0xfbdf0468}},	//   _vací, kają, _škol_, _diên_
  { {0xdb0d001c,0xdce7005c,0x1bb800e6,0x66030469}},	//   ndaç, jają, واقع_, zink
  { {0xdce70050,0x3c440010,0x63a2046a,0x69dc046b}},	// [490] dają, тэрв, _mbon, _bore
  { {0x7e6d003f,0x69dc046c,0x58870033,0xad270058}},	//   _iwap, _core, дыда, _يردو
  { {0x69dc046d,0x6603046e,0x81bc003d,0x27ed046f}},	//   _dore, vink, elēk, _plen_
  { {0xdd0d005c,0xdce7005c,0x58840033,0x66030470}},	//   półp, gają, тыфа, wink
  { {0x660300df,0xcff8013a,0x7af60050,0xf77003c4}},	//   tink, וצאה_, czyt, شان_
  { {0x04b50063,0x6603008c,0xcb12000a,0x69dc0471}},	//   есия, uink, _תלך_, _gore
  { {0xdcfe01e2,0x66030472,0x24e9005e,0xa3e3000b}},	//   _yapı, rink, ямки_, _नकद_
  { {0x4788000d,0xdce7005c,0xdb06002c,0x66030473}},	//   _осум_, cają, _rakú, sink
  { {0x52a60256,0xc24503e7,0x69c4000b,0x22470474}},	//   евым_, нник, राची, _pink_
  { {0x7bdd0050,0xdb1d00c0,0xf652000a,0x54a70015}},	//   _losu, _insä, _עצב_, _يحاف
  { {0x05960086,0xbf9b001c,0xc0580010,0x22470111}},	//   _سالگ, riên, міў_, _vink_
  { {0x34bd005d,0x35c7005d,0x6e2500d9,0x44290016}},	//   ्मीद, लाक़, _akhb, _óa_
  { {0x62640036,0x63b90026,0x56b5004c,0x63bb0475}},	//   _авіа, _iawn, עפֿן_, mdun
  { {0x63bb018b,0xdce7005c,0xf1d00092,0x409503fc}},	//   ldun, zają, _hạnh_, _зрит
  { {0x32050041,0xfbdf0023,0x63bb0064,0x9d530015}},	//   mily_, _viên_, odun, انفت
  { {0xc4d200b2,0x63b9002a,0x32050046,0x63bb0476}},	//   נגן_, _jawn, lily_, ndun
  { {0xfbdf0023,0xf1d00023,0x63bb00b8,0x7bdd0089}},	// [4a0] _tiên_, _mạnh_, idun, _dosu
  { {0xdce7005c,0xf1d00092,0x629b0007,0x63b900ea}},	//   wają, _lạnh_, ituo, _lawn
  { {0x69dc00fb,0xdce7005c,0x629b0020,0xc6d60086}},	//   _vore, tają, htuo, کتات
  { {0x629b0007,0x2917006e,0xd917002b,0xe73a0477}},	//   ktuo, رقند_, رينش_, пее_
  { {0xdce70050,0xd6d00015,0x862601f3,0x69dc0478}},	//   rają, ؤقت_, ньке, _tore
  { {0x32050046,0xdce7002a,0x69dc008c,0x63bb0012}},	//   jily_, sają, _uore, edun
  { {0x68e10020,0xf7720029,0x32050479,0x48b4000a}},	//   _üldp, _ماء_, dily_, _בִּן_
  { {0xf1d00023,0xd3700029,0x7e7b0024,0x7648047a}},	//   _cạnh_, جهة_, šupi, _widy
  { {0x7528005c,0xeb9f003c,0x63b9047b,0x4c3b000a}},	//   _wydz, _kjør_, _dawn, התקב
  { {0xfa970053,0x7528005c,0x51f7004a,0x867b004f}},	//   עדיש_, _tydz, енью_, _מרמו
  { {0x6815005c,0x09f7000a,0xdb0f0125,0xeb0d000b}},	//   ląda, גמים_, _macá, _सख्त_
  { {0x63a2003f,0x20d50007,0xdfd2002b,0x3205047c}},	//   _ubon, džią_, ليپ_, aily_
  { {0xe04a0074,0x4426003f,0x91e6047d,0x2d85047e}},	//   _کشته_, _iko_, _поде, óleo_
  { {0x92f20064,0x320500da,0x7c26047f,0x0000006a}},	//   ığım, cily_, _akkr,
  { {0x9e080015,0x7bdd0480,0x23c4000b,0x7c840481}},	//   ريفك_, _posu, _वफाद, луте
  { {0x7e6d003f,0x7a2b0012,0x6838001a,0xa097000a}},	//   _twap, müti, nídd, _נדחק_
  { {0xe9870001,0xdb26002b,0xbbe1000b,0x6a25002b}},	// [4b0] ећен, پولی, _नवीक, نفرم
  { {0x99990007,0xd6d1002b,0xe981005e,0x7b440015}},	//   _rusų_, یقا_, ражi_, ائِل
  { {0x4426010b,0xef20005c,0x78ba002c,0xfd560008}},	//   _oko_, ążek_, _štvr, _בשתי_
  { {0xdb1d00c0,0xe9380015,0x6675002b,0x6b670003}},	//   _anså, رسلت_, ندتر, _dégâ
  { {0x212b00a7,0x7c2d0482,0xd126002b,0xbb76000a}},	//   ́ch_, mlar, _چم_, _שעשו_
  { {0xeb9f003c,0xdcee0024,0x85e80036,0x44260483}},	//   _gjør_, labā, ндів_, _ako_
  { {0x34bd014e,0x66e70024,0x97a70484,0x32050485}},	//   ्मेद, _sīkā, _прал, vily_
  { {0x7c2d0482,0x629b0486,0xd7c90067,0x3ea90487}},	//   nlar, ttuo, _توره_, _opat_
  { {0x52a90036,0x6265006b,0x75240046,0xfbdf0016}},	//   євом_, ъвпа, řizp, _niêm_
  { {0x3d1a005d,0x22920086,0x7c2d03ba,0x629b0488}},	//   _मुझे_, گلیس, hlar, rtuo
  { {0x23e70191,0x32050041,0x00850063,0xc952000f}},	//   _підв, rily_, ълно, ימי_
  { {0x7c2d0064,0x3205031c,0xd00f0015,0x629b0489}},	//   jlar, sily_, ْلَ_, ptuo
  { {0x443f048a,0x7c2d048b,0x877a000a,0xc7d6000a}},	//   mmu_, dlar, וארי, דורי_
  { {0x644b00b6,0x6289002d,0x7c2d048c,0x600b00f2}},	//   _higi, mreo, elar, tömä
  { {0x7b960191,0x7c2d01e2,0xeb9a0036,0x644b003f}},	//   краї, flar, мив_, _kigi
  { {0x442d01e2,0xd0120087,0xd116000a,0x60080061}},	//   nle_, _خلع_, _בקצה_, rıms
  { {0xdb0f002d,0x3b070063,0xbf9b000a,0x8eb3002b}},	// [4c0] _pacá, вето_, _חיפש, _نميش
  { {0x442d048d,0x09f70015,0x644b048e,0x69c00091}},	//   hle_, نفقة_, _ligi, _ėmes
  { {0x7db5008f,0x442d048f,0x7d7b000a,0x9f06002b}},	//   _ёсьц, kle_, _קנטו, _سوگو
  { {0x7aeb0014,0x60da0053,0x5fb2000b,0x7c2d0490}},	//   ölté, וקענ, ज़िल, clar
  { {0x96960491,0x442d0492,0x7c240493,0x6d5c0494}},	//   треш, dle_, moir, ocra
  { {0x6d480007,0xceb3039e,0xa6650015,0x7c240003}},	//   ždau, ייד_, اطنو, loir
  { {0xeb9f003c,0x442d0495,0x69ce0496,0x1da4000b}},	//   _kjøp_, fle_, _inbe, ख्यत
  { {0xe4e30191,0x68e30497,0xad1b000a,0x644b0125}},	//   рішн, ände, ווצר, _cigi
  { {0x644b0498,0x3714000a,0x26c4007c,0xf7430499}},	//   _digi, _עַֽל_, _urmo_, _вето
  { {0x644b0084,0x7c2d0064,0xa6970008,0x7c24049a}},	//   _eigi, zlar, _בכמה_, hoir
  { {0xf9930008,0x7c2d049b,0x4426016f,0xdfd10031}},	//   ברת_, ylar, _tko_, ميد_
  { {0xb4fb00b2,0x6289002d,0x4426003f,0x683801cb}},	//   _קלאר, breo, _uko_, bíde
  { {0x69ce049c,0xfaff00dd,0x41b60015,0xc1b7002b}},	//   _onbe, _leër_, _لمشر, رایط_
  { {0x827700b2,0x24580092,0x20c6005e,0xfbdf0016}},	//   _יעדע_, _kém_, _асиг, _viêm_
  { {0x7c2d01e2,0x7c24002d,0x2d580142,0xdc74004a}},	//   tlar, foir, тись_, игры
  { {0xfbdf0092,0x24580089,0x69ce0293,0x0a6b049d}},	//   _tiêm_, _mém_, _anbe, држи_
  { {0x7c2d01e2,0x6d5c00fb,0x644000f2,0xba740015}},	// [4d0] rlar, bcra, immi, لالت
  { {0x442d01e2,0x7c2d0064,0x4424049e,0x7d0e0030}},	//   zle_, slar, hom_, ánsá
  { {0x7c2d01e2,0xd141005c,0x394700c0,0x24580092}},	//   plar, cząć_, äns_, _ném_
  { {0x3b640063,0x4424049f,0x8cfa000a,0x2057000a}},	//   _върв, jom_, _נִיח, דיאל_
  { {0x644b04a0,0x68e30123,0xc1780091,0xf7940033}},	//   _rigi, ändb, nkės_, рачэ
  { {0x69d80014,0xdb060089,0xf6240036,0x1a68002b}},	//   övet, _jaký, адіо, _شیمی_
  { {0xe3b10029,0x18b80080,0xa3cf000b,0xd90f002b}},	//   مرة_, _игры_, शाल_, _بیا_
  { {0x442404a1,0x443f04a2,0x7e7d04a3,0x628904a4}},	//   gom_, umu_, kssp, treo
  { {0x32d40010,0x11d90029,0xeb92000a,0x6815002a}},	//   ацэс, فوظة_, צָה_, lądo
  { {0x644000f2,0x628904a5,0x2e36001a,0x442d04a6}},	//   ammi, rreo, kæfa_, sle_
  { {0x91050080,0x644b04a7,0x442d04a8,0x89da000a}},	//   упне, _tigi, ple_, תחתי
  { {0x4424049f,0xd00f0015,0xdea2002b,0x629c0045}},	//   com_, كلٍ_, میبی, ăror
  { {0x7c240152,0xfe710015,0x3f9e002a,0x6d5c04a9}},	//   voir, ْدِ_, ętu_, tcra
  { {0xa0c50086,0x8e75005e,0xdb04016e,0x2c51002a}},	//   _ميتو, шуюч, leiç, _lądu_
  { {0x7c24038d,0x6d5c003e,0x201904aa,0x0c7904ab}},	//   toir, rcra, éric_, ксты_
  { {0xf0920008,0xabf50248,0xd12e0015,0x9ad602a3}},	//   _הנה_, ачущ, _عمي_, люзі
  { {0x7c2404ac,0xed5a01e1,0x6fd10065,0xbb75009b}},	// [4e0] roir, _поп_, धारू, русъ
  { {0x7bcf0467,0x7a2b0020,0xbb43005e,0x7c2404ad}},	//   _encu, kütu, сеук, soir
  { {0x2fd70086,0x81760053,0x5d9b000a,0xfce604ae}},	//   _شوید_, רגעס_, _אביה, _соно
  { {0x27e00084,0x788004af,0xdb04001c,0x61e0021e}},	//   ðin_, _návš, jeiç, _पक्ष
  { {0x4a75044e,0x5b7b0008,0x69d800dc,0xbad50010}},	//   _выст, _ארכא, öves, _кіры
  { {0x69ce04b0,0x4424002a,0xe8560015,0x75d40015}},	//   _unbe, wom_, _منسد, شيبا
  { {0x54a60029,0xdb04016e,0x6ab60034,0x442404b1}},	//   احتف, feiç, lwyf, tom_
  { {0xd90d0074,0xccf3000a,0x2676002b,0xb8da000b}},	//   _تیم_, מכו_, _مهرآ, ॅट_
  { {0x81bc0048,0x65960086,0x75d3002b,0x9963006f}},	//   klēt, _مجار, _گيلا, líši_
  { {0x68380089,0xdd1f002c,0xd7070033,0x245804b2}},	//   bídc, _líši, _снуе_, _tém_
  { {0xf993013a,0x30a30063,0xddcd0011,0x3d00005d}},	//   זרת_, бряв, _ataş, ोपों_
  { {0xde59008f,0x1e1d005d,0xd36f0115,0x7e7d04b3}},	//   камі_, पक्ष_, _فهم_, tssp
  { {0x0f540015,0x6815002a,0x7e7d0012,0x81d404b4}},	//   صَّح, ządo, ussp, _волх
  { {0xdb070014,0x52830029,0xdb0600dc,0x27230016}},	//   ámít, _الوك, _lakó, ựng_
  { {0xa0c30015,0x7c090067,0x7e7d0012,0x709404b5}},	//   _هيوو, نيسف_, sssp, _тайф
  { {0xf1d2005d,0x7a2b00b8,0xdb060061,0x49bb002b}},	//   तावन, hütt, _fakü, کارد_
  { {0xdb06002c,0x497503e7,0x7a570015,0x5fb2000b}},	// [4f0] _taký, илас, اضرا, ज़रल
  { {0xdd9104b6,0xd91b0080,0x2c51002a,0x7d200030}},	//   _بود_, нье_, _sądu_, ézsé
  { {0xd7e70127,0x48ab0010,0x6d480007,0x8d5a000a}},	//   лідо, этам_, ždar, _בכתי
  { {0xf3f10023,0x200b04b7,0x69d804b8,0xf8680015}},	//   _mục_, nici_, över, امني_
  { {0xb5fd00df,0x7c3a0152,0x4b7a000a,0x6fa7000b}},	//   _atša, ître, _בארו, ट्यू
  { {0xdb1f0020,0x48770031,0xdb0e001a,0x7bd70091}},	//   övõi, _مدرس, _þjál, šbuč
  { {0xdb1d00fb,0x200b0064,0x62860107,0x25b60015}},	//   _ansø, kici_, ákon, شهيد_
  { {0x69c9000b,0x62d50015,0x81bc003d,0x73e504b9}},	//   _होती, لآخر, klēs, роиз
  { {0x91d50036,0x200b04ba,0x221504bb,0x7a2b02ad}},	//   ацні, dici_, ифор, bütt
  { {0x7a3000f2,0x7d080046,0xdb0600bf,0xe12504bc}},	//   vätk, údsk, _zakó, импи
  { {0x200b04bd,0xf3f10016,0x7e6404be,0x81bc003d}},	//   fici_, _cục_, _stip, vlēt
  { {0x200b04bf,0x92b50015,0xf1a8002b,0xf3f10016}},	//   gici_, _نحتا, پایه_, _dục_
  { {0xd343002b,0xeef50033,0x3f8c0061,0x7f1a005e}},	//   _افشی, бярэ, ğdu_, тіну_
  { {0x7e6404c0,0x752d0046,0xc332000a,0x12fa004f}},	//   _vtip, řazu, _ווד_, _שהסב
  { {0x200b04c1,0xf1d20065,0x0000006a,0x0000006a}},	//   bici_, तारन,   ,
  { {0x61e300dc,0x9f1a0015,0xb09a000a,0x78450091}},	//   _honl, _لآخر_, _סיפר, _tėvy
  { {0x39560083,0x1a0604c2,0xda6500e5,0xb9560054}},	// [500] ањет, апам, مالي, атећ
  { {0x8e7b0008,0xba170015,0x2fc004c3,0x5ee9004f}},	//   _שניה, ليقا_, _haig_, _תַקְ
  { {0xd826006b,0x2cba04c4,0x8ba604c5,0x0000006a}},	//   аджи, _uspd_, _кинж,
  { {0x443d0176,0x68e301d1,0xb8ce005d,0x46ea0063}},	//   _nhw_, ända, _कह_, кден_
  { {0x2fc00251,0xa6b60063,0x59760010,0xddd60227}},	//   _maig_, рсещ, _выбу, _zvyš
  { {0xd6cf0086,0x645e001c,0xc6f7017f,0x200b04c6}},	//   بقه_, ípio, шніх_, zici_
  { {0x200b0064,0x7a3000f2,0xa5f70063,0xab5b0012}},	//   yici_, jäti, рещу_, _knüp
  { {0xd7f20029,0x25a00089,0xe8d70008,0x22b6002a}},	//   _بكر_, řil_, _דולר_, _płk_
  { {0xd5b20015,0xf805004a,0x9f490061,0xa3b700c3}},	//   _وفر_, _учён, _ilaç_, شاير_
  { {0xc05a008f,0xd578000a,0x5578000a,0x61e304c7}},	//   кім_, _תָּר, _תְּד, _conl
  { {0x3a37013a,0x39570008,0xe97b0053,0xf957000a}},	//   שרים_, ישים_, כניש, יסית_
  { {0x82a60132,0x0000006a,0x0000006a,0x0000006a}},	//   _вадж,   ,   ,
  { {0xe1fa0001,0x61e30064,0x66f8000b,0xdcef0046}},	//   _игд_, _fonl, ्छिक_, ědču
  { {0xf3f10023,0xdb04007c,0x2d850003,0x200b04c8}},	//   _tục_, ndiõ, ûle_, sici_
  { {0x52b6014e,0x2fc00144,0x6e270085,0xb23b000a}},	//   _अनुस, _faig_, rojb, _שעוז
  { {0xd0f70008,0x1ee70086,0x2d98003c,0x62820020}},	//   _כמות_, _نوعی_, agre_, _kvoo
  { {0xe8e00092,0xa3a8021e,0x61fa007c,0x80be000b}},	// [510] ưới_, ख्य_, ohtl, षिके
  { {0x683802d5,0xf99304c9,0x996704ca,0x23a6000b}},	//   vída, تبر_, ртал, क्तद
  { {0xb9c40029,0xf7550058,0xd7770058,0x0000006a}},	//   تقلي, مناج, لاشع,
  { {0xd7880029,0x96f9004a,0x628001ee,0x3f9904cb}},	//   لنمو_, леет_, ksmo, ngsu_
  { {0xc7b8004a,0x7d1b0061,0x27e40045,0x6f7a000a}},	//   рёх_, ğusu, _domn_, רְעו
  { {0x9985002b,0x628004cc,0x660804cd,0x443d04ce}},	//   _دلسو, dsmo, _cmdk, _shw_
  { {0xfc3f0023,0xdb0d001a,0xd7590015,0x200902b9}},	//   _khí_, ndaþ, _ملأت_, _omai_
  { {0x61e30064,0xd7940063,0x04560029,0x1d18000a}},	//   _sonl, _мисъ, حلية_, יקור_
  { {0x645c00dc,0xfc3f002d,0xdb1d0152,0x7aed04cf}},	//   _érin, _mhí_, _basé, nyat
  { {0x61fa04d0,0x7a300437,0x7aed0061,0x201901f6}},	//   ghtl, täti, iyat, érin_
  { {0xb8750484,0x40940121,0xfbdf0016,0xafdb04d1}},	//   алiз, орят, _hiêu_, rmøn
  { {0x25f5000b,0x7aed0049,0xfbdf0016,0x61fa04d2}},	//   ऍसवी_, kyat, _kiêu_, ahtl
  { {0x7a30022d,0x0cd0005d,0xd436000a,0x2fc00144}},	//   säti, हम्म, _פרנק_, _vaig_
  { {0x6da60001,0xfbdf0092,0xfc3f02c1,0x61fa04d3}},	//   љива, _miêu_, _ahí_, chtl
  { {0x4095040b,0xfc3f002f,0x9c590001,0xfbdf0016}},	//   _العر, _bhí_, ишту_, _liêu_
  { {0xfc3f0023,0x44f30092,0x7ff60086,0x3ce500c0}},	//   _chí_, ị_, _دستا, älva_
  { {0x68e304d4,0x89aa0004,0xbb4304d5,0x0000006a}},	// [520] ändn, лкав_, зетк,
  { {0xc3320008,0x200e005c,0xdb040003,0xb9560054}},	//   לון_, ślić_, nfié, стаћ
  { {0xe93a0180,0x19b9005e,0xb17a004c,0x224b006f}},	//   учај_, шуть_, רטער, ícky_
  { {0x8b960286,0x41ae000b,0x7d1b0061,0x60dc04d6}},	//   _уроч, _जॉनस, ğust, ärmi
  { {0x68380089,0x673b005c,0xe7f9000b,0x661a01d7}},	//   bídn, _czuj, ्फ़ा_, _pjtk
  { {0x99d603c4,0xd6270342,0x95c40015,0xd49a04d7}},	//   _اتحا, боче_, زيعه, гри_
  { {0x75890036,0x64c30058,0x6aa404d8,0xdb1d01f6}},	//   рсів_, كيول, ltif, _rasé
  { {0x62860007,0xe3b20015,0x20dc006f,0x7bc404d9}},	//   škom, سرع_, nšiť_, ndiu
  { {0x6aa404da,0x6815002a,0xd80b000a,0x44f30016}},	//   ntif, ządk, _עִלָ, ạ_
  { {0x7abb000a,0x61fa007c,0x611402ed,0x645c01f6}},	//   נציו, uhtl, ждоу, _ério
  { {0x2019001c,0x546a0004,0x64c60040,0x320c00bf}},	//   ério_, _саем_, _ديال, ridy_
  { {0x7a30008c,0xf537000a,0x62820079,0x6aa404db}},	//   mätu, _פנאי_, _tvoo, ktif
  { {0x73360086,0xde590010,0x7a30008c,0x8336012c}},	//   _ارائ, рагі_, lätu, _اراض
  { {0x831b0053,0x329b04dc,0x9e15005e,0xa2b7000b}},	//   _גודז, _עבוד, ідві, ्टर्
  { {0xfc3f0023,0xf1a90074,0x657a04dd,0xc237000a}},	//   _phí_, _خانه_, _meth, _הרגו_
  { {0x317e04de,0x99940046,0x9ee90015,0xf3f1000a}},	//   latz_, _češi_, _نفعل_, ֵ֣ן_
  { {0x1a5b0029,0xd00c0008,0x4a54006b,0x7c3a0003}},	// [530] اشرة_, _תּוֹ, зкус, îtra
  { {0x645a038d,0x9f4b0089,0x657a04df,0xeef8000a}},	//   _outi, nkcí_, _neth, _למחר_
  { {0xe8e000a7,0x31780050,0x7a30022d,0xfc3f0092}},	//   ười_, órzy_, jätu, _thí_
  { {0xd7580029,0x473504e0,0x7ce8000a,0xa09b000a}},	//   مجها_, онес, _הַשֶ, ריאט
  { {0x62860007,0x20190152,0xe70b0018,0x6aa404e1}},	//   škoj, insi_, دتان_, ctif
  { {0x19580010,0xa87b0015,0x96ba000b,0x25a90085}},	//   _гары_, _محرر_, _एनरॉ, đalo_
  { {0x8ccc005d,0x69d504af,0x44f30092,0x657a0026}},	//   हियो, _inze, ụ_, _deth
  { {0xfbdf0023,0x645a04e2,0x69c504e3,0x9f4b005a}},	//   _tiêu_, _duti, ldhe, ekcí_
  { {0x657a04e4,0xe1f9023c,0xb5a704e5,0xdb1d04e6}},	//   _feth, иги_, _грей, _insó
  { {0xf0a90033,0xda7a000a,0x80a904e7,0x657a04e8}},	//   акол_, סנתר, авов_, _geth
  { {0x32f40023,0xf992011f,0x7a3000f2,0x645a04e9}},	//   ày_, ורי_, mätt, _guti
  { {0x81bc0024,0xc2c50029,0x4429002e,0x7a3004ea}},	//   slēp, _ويضي, _ða_, lätt
  { {0xeef5008f,0x3f890176,0x69d504eb,0x8708000a}},	//   пярэ, _ddau_, _onze, ֶּשֶ
  { {0x27fd0034,0x2259001a,0x201901d7,0x02440015}},	//   hhwn_, ísku_, ansi_, _فَنَ
  { {0xb147002b,0x68e303c1,0xb489000a,0x2715000b}},	//   _دیدم_, ändl, יָּ֙, तपुर_
  { {0x69d504ec,0x6aa404ed,0x9963006f,0x63a904ee}},	//   _anze, ttif, _ríšu_, nfen
  { {0x6aa4003e,0x261a005d,0x63a904ef,0xaf03006b}},	// [540] utif, _बदली_, ifen, _опъл
  { {0x238c0007,0xe9d704f0,0x69c50159,0x20f50016}},	//   mėjų_, оку_, gdhe, ói_
  { {0x20dc002c,0x02b6005d,0x7a3000f2,0x9b760015}},	//   pšiť_, _अन्न, dätt, _واحص
  { {0xc66a0054,0x6aa40003,0x0d3b000a,0x645a04f1}},	//   ашке_, ptif, _כגיב, _ruti
  { {0x645a04f2,0x777b0152,0x657a0026,0x26cd04f3}},	//   _suti, _deux, _peth, _creo_
  { {0x62860007,0x76410026,0x7aeb0012,0x7c36001a}},	//   škok, _chly, ägte, llyr
  { {0x4ddb000a,0x63a904f4,0x78800046,0xd6d9002a}},	//   יחסו, ffen, _dává, _mgły_
  { {0x63a90026,0x0443000d,0x238c0091,0x27fd0034}},	//   gfen, мејн, kėjų_, chwn_
  { {0x442f00dc,0x7a3003a4,0x32f40092,0x23a6000b}},	//   _dkg_, bätt, ùy_, क्षद
  { {0x51f804f5,0xe4d60015,0x238c0091,0x645a04f6}},	//   сною_, _وتاب, dėjų_, _tuti
  { {0x42540086,0x69b70008,0x645a00f2,0x403504f7}},	//   _کنتر, חליף_, _uuti, зенс
  { {0x317e00b8,0x69c500dc,0x800700ce,0x0000006a}},	//   satz_, zdhe, ічне,
  { {0x41e60010,0x7a300123,0x238c0091,0x2259001a}},	//   _міка, näts, gėjų_, ískt_
  { {0x81f80002,0xd337000a,0x9f540033,0xc693000a}},	//   _دفتر_, _ורדה_, ьвяч, ואש_
  { {0x271c0023,0x80270029,0x1bd50063,0x71260015}},	//   ỉnh_, _وربم, повя, _برشل
  { {0xdfd1003b,0x6024009c,0xe0fb000a,0x929d002a}},	//   _أية_, _одја, _כלול, szłe
  { {0xe451000a,0x34b7000b,0x9e670015,0xc95b0033}},	// [550] תֶם_, _आन्द, _بابن, аўе_
  { {0x78a5002e,0xadb9002b,0xa9970015,0x826b000a}},	//   tthv, _اهدا_, تشرت, ׁ֣בַ
  { {0x9f40002e,0xd7590115,0x7a3004f8,0x67b50054}},	//   _hlið_, ملات_, vätt, збеђ
  { {0x080b0015,0x0000006a,0x0000006a,0x0000006a}},	//   جزئي_,   ,   ,
  { {0x7bda0008,0x7a3000b8,0xc6680004,0xdb1d00bf}},	//   _הקרו, tätt, ошје_, _kasí
  { {0x7c2d04f9,0x26cd0011,0x1dcb000b,0x29070125}},	//   loar, _vreo_, ायित, únas_
  { {0x7a3004fa,0xdb1d04fb,0x63a902ad,0x0000006a}},	//   rätt, _masí, tfen,
  { {0xc2c5003b,0x7a3004fc,0x26cd04fd,0x64420110}},	//   كيبي, sätt, _treo_, _choi
  { {0x44240029,0x69c1002e,0xd5bb04fe,0xa2350033}},	//   بروف, _óles, _все_, зэнш
  { {0x238c0007,0xfad6000a,0x1306004a,0x63a9047f}},	//   vėjų_, פותך_, яный_, sfen
  { {0xf99200b2,0x6442002f,0x63a904ff,0xa1e80015}},	//   ערט_, _fhoi, pfen, تريك_
  { {0xa3bb0074,0xb4d7005d,0x60160007,0xe53a0008}},	//   _خاطر_, ामी_, kšme, _התער
  { {0x7c2d0500,0x4dd6005e,0x64490501,0xb796000a}},	//   doar, півф, mmei, הכרח_
  { {0x7c2d0011,0x82370015,0xa1c4005e,0x8b08002a}},	//   eoar, _برصا, _обід, nięż
  { {0xf1b2013a,0xfce6005e,0x7c3a0003,0x644903f8}},	//   _נסה_, чово, îtro, omei
  { {0x7c2d0011,0x64490028,0x1e86030e,0xdb520015}},	//   goar, nmei, _елим, َّر_
  { {0x6ffb000a,0x442d0034,0xf992002b,0x8f9b000a}},	// [560] _להקפ, ioe_, فبا_, _היפי
  { {0x3f82013c,0x7d270030,0x64490502,0x442d0503}},	//   laku_, érsé, hmei, hoe_
  { {0x23bd014e,0x64490020,0x53bd000b,0x6ee5002b}},	//   ्याद, kmei, ्याश, _فسیل
  { {0xca290008,0xdb1d0089,0x7a3000b8,0x3f82016f}},	//   אם_, _zasí, täts, naku_
  { {0x64490020,0xf3f10092,0x2907001a,0x64420034}},	//   dmei, _cụm_, únar_, _rhoi
  { {0x7bc60504,0xeb3b0008,0x3f8200f2,0x6e2e02b9}},	//   _haku, _לעכש, haku_, nobb
  { {0x6442002d,0x7bc60505,0xdb0d001a,0x20190030}},	//   _phoi, _kaku, ldað, érik_
  { {0x29370053,0xa2c8005d,0x7bc60506,0x3f820507}},	//   _זאלן_, ़िल्, _jaku, jaku_
  { {0x7bc60508,0x9bb7000a,0xdb0d001a,0x722a004a}},	//   _maku, להקה_, ndað, йцов_
  { {0x7bc60509,0x6e2e050a,0x75350030,0xa5650015}},	//   _laku, jobb, ögzí, _قدمن
  { {0x6442002f,0x30730010,0xdfd10087,0x656801d7}},	//   _thoi, нуўс, نيد_, _ifdh
  { {0x04db013a,0xe2aa002b,0x3f82050b,0x7bc6050c}},	//   _לקבל, _هاتن_, gaku_, _naku
  { {0x7c2d0011,0x80a3002b,0xdb0d016e,0x63a2050d}},	//   voar, ومین, meaç, _icon
  { {0x6114050e,0x91e3050f,0x52d7000a,0xb2bb000a}},	//   _одлу, _поче, _מודע_, _למדר
  { {0x7c2d04f9,0xecf80033,0xa0a3012e,0x7d240510}},	//   toar, перш_, _зајд, ефте
  { {0x80a30015,0x7bc601d7,0x6c540511,0x2137000a}},	//   _أمين, _caku, ексу, _מטול_
  { {0xdd0c002a,0xba550054,0x7c2d0512,0x4a550513}},	// [570] góła, двај, roar, дкас
  { {0x5a340124,0x68380089,0x7c2d0011,0xa93d0033}},	//   енут, bídk, soar, адзi
  { {0x7c2d04f9,0x41ae000b,0x7bc60514,0x6449008c}},	//   poar, ज्यस, _faku, ymei
  { {0x2d9c01d1,0x27e90084,0xf5400033,0xa7a90033}},	//   _över_, ðan_, _якiм_, ікла_
  { {0x6fa5005d,0x7e690011,0xe69b002a,0xe72e0515}},	//   _कानू, _împă, _żołą, те_
  { {0x7bc60516,0xddc40045,0x2d830517,0x63a20518}},	//   _zaku, _itiţ, naje_, _acon
  { {0x64490519,0xfdf8000a,0xb4d7000b,0x784c0061}},	//   tmei, הצגת_, ामे_, _aşvu
  { {0x3cfc0053,0x9cd8000a,0x8b08002a,0xf7730021}},	//   מלונ, לווה_, sięż, _سار_
  { {0x6449051a,0x442d051b,0xdcfc00bc,0x3f82051c}},	//   rmei, roe_, varč, vaku_
  { {0xa87900b2,0x4209005e,0x63a203b8,0x61ea0034}},	//   ֿאָר, інно_, _econ, _cofl
  { {0x93270086,0x0519002b,0x7e6d051d,0x3f82051e}},	//   _کران, _بياب_, _atap, taku_
  { {0x63a2002d,0x68380046,0xa2cd000b,0x15180015}},	//   _gcon, vídk, तिद्, _عزلة_
  { {0xa2e4005e,0x63bb051f,0x3f820520,0x7bc60521}},	//   _поїд, meun, raku_, _raku
  { {0x8d760015,0x69c70522,0xdd920002,0xc2440033}},	//   باحا, _naje, ضور_, _знік
  { {0xa00a0029,0x7bc60523,0x2fe60015,0x7e6d0524}},	//   _وقتل_, _paku, _يكتف, _etap
  { {0x5baa0033,0x8c430499,0xaac9000b,0x63bb0525}},	//   ўкам_, весе, रिंक, neun
  { {0xf4120008,0x69c700d9,0x62860526,0xcf26002b}},	// [580] דפן_, _baje, škov, _ترغي
  { {0x7bc6000c,0xfe460036,0x2aa6006f,0x68380527}},	//   _waku, _інно, rôb_, mídi
  { {0x4ddb000a,0xb4d7000b,0x1c4603ae,0x7bc60528}},	//   _וחיו, ामो_, _оном, _taku
  { {0xd6d9002a,0x63bb0529,0xdd0c002a,0x3f800073}},	//   _szła_, jeun, póła, _jeiu_
  { {0xa3e1021e,0xf5e6005e,0x4e7a004c,0x8bbb000a}},	//   दान_, дійм, קאַצ, _וזכת
  { {0x6b84002f,0x63a2052a,0xaa46005e,0x746a052b}},	//   laig, _scon, _цегл, орив_
  { {0xf79a0015,0x9e49000a,0x4d7b000a,0xe9a30165}},	//   _ونسب_, הֲקִ, קרקע, _шарп
  { {0x6b84017e,0x69c7052c,0x1bfb0053,0x828a03a9}},	//   naig, _zaje, ַליב, особ_
  { {0x752d0064,0xf6970015,0x27e6052d,0x7d010030}},	//   ğaza, _ينفع_, mjon_, úlsz
  { {0x6b84052e,0x24f60457,0x27e6052f,0x64b60015}},	//   haig, _очер, ljon_, _يحار
  { {0x20d30010,0x72330029,0xa9bb000a,0x7e6d00ed}},	//   віўс, خريط, חזיר, _stap
  { {0x2d83003f,0x68e30530,0xa8670008,0xb4bc000b}},	//   waje_, ändi, וֹךְ_, ेटी_
  { {0x6b84002f,0x41e60015,0xe46a001a,0xfe6e002b}},	//   daig, _يستف, blöð_, یگی_
  { {0x828b000a,0x41b30015,0x0357000a,0xa28b004f}},	//   _וְהֶ, _لمهر, _חידש_, _וְה֖
  { {0x6b84002d,0xebc70001,0xb19b000a,0xfc330015}},	//   faig, мљан, _ויוכ, نحر_
  { {0xa0080029,0x2d830531,0x9b450015,0xa3e1000b}},	//   _يقول_, saje_, فنزو, दाय_
  { {0x27e600dc,0x7e6d003f,0x68380532,0xdb1d0533}},	// [590] djon_, _utap, cídi, _basá
  { {0x2fc90534,0x68150535,0xdb1d0536,0x0000006a}},	//   _haag_, jądr, _casá,
  { {0x6b8400df,0x61e700c0,0x321e003e,0x28a70033}},	//   baig, öjli, inty_, ьшаг
  { {0xf7700029,0x5fbc0053,0x69c7003f,0x6b840537}},	//   لاه_, ַצונ, _waje, caig
  { {0xdb1d0538,0x69c70539,0x2fc9053a,0xdcfc01ec}},	//   _ansö, _taje, _maag_, marā
  { {0x7a2b00b8,0xa5940063,0xfcab0008,0x2fc9016b}},	//   hütz, връщ, ַיִּ, _laag_
  { {0x63bb0384,0x2d810020,0xd46601b7,0x97a7012b}},	//   teun, _mehe_, нище_, _орал
  { {0xee3f002c,0x2d810020,0xdb1d0089,0xdd58000a}},	//   dtým_, _lehe_, _zasá, ובוט_
  { {0xb06500f2,0x17f80015,0xc6a4053b,0x63bb053c}},	//   kyää, _غرفة_, _архи, reun
  { {0xc5fb0029,0x6b8400dc,0xdb04001c,0xddc4016f}},	//   _بعرض_, zaig, nfiá, _otiš
  { {0x83fc016f,0x86080015,0x27ed053d,0x9324009a}},	//   _suđe, _تقلق_, _koen_, فرین
  { {0xc476000a,0x73c50015,0x27ed008c,0xb5fd053e}},	//   _נתנו_, _سيتم, _joen_, _duše
  { {0x798501c2,0xc7f6000a,0x92a70054,0xdcfc003d}},	//   kahw, גזרת_, _цјел, darā
  { {0x27ff0176,0x6289002d,0x27ed007c,0x6b840012}},	//   _llun_, mseo, _loen_, waig
  { {0x27ff01e2,0x6286053f,0xc5f20135,0x6b840540}},	//   _olun_, škot, נדל_, taig
  { {0x27ed003c,0xb9c6002b,0xfc1a0015,0x6b840125}},	//   _noen_, کتره, أقرب_, uaig
  { {0x6b840541,0x6459003f,0x6996007a,0x6c330067}},	// [5a0] raig, _miwi, ерех, افقا
  { {0x6b84002f,0x2d810012,0x64590542,0x27ff0543}},	//   saig, _gehe_, _liwi, _alun_
  { {0x7d7b000a,0xdd7b000a,0x27ed0034,0xdb1d0030}},	//   _מניו, _מטיל, _boen_, _vasá
  { {0xe108000a,0xf989000a,0x08090015,0xc6a6008a}},	//   וּנָ, מר_, وزني_, ерки
  { {0x27ed00f6,0x27e600dc,0xc0530053,0xa73a0058}},	//   _doen_, rjon_, אזא_, أثار_
  { {0x27e60544,0x8f1b000a,0x3e660016,0x7af6008c}},	//   sjon_, הונת, _môt_, myyt
  { {0x8cd3000b,0x7af6008c,0x64a30054,0x27e60030}},	//   डियो, lyyt, гаја, pjon_
  { {0x34470010,0xa3d4006b,0x27ed01d7,0x64590034}},	//   нчын_, тоич, _goen_, _ciwi
  { {0x64590026,0xe3af0015,0x7af6008c,0x02bc000b}},	//   _diwi, صري_, nyyt, ्टेन
  { {0x22580084,0x44ce0050,0x84e60080,0x171b0053}},	//   örk_, _tę_, _позж, _זומע
  { {0x7a2b018b,0x5a170008,0x85060015,0x8997004c}},	//   tütz, תקין_, _ثوان, עכטס_
  { {0x6d5e0035,0x889b000a,0x2d810012,0xa3760015}},	//   _agpa, הבטי, _sehe_, _أداؤ
  { {0xb065008c,0xee3f013f,0x69dc0545,0x2fc90546}},	//   tyää, stým_, _onre, _vaag_
  { {0x30a6005e,0xbf9b016e,0xa0a6005e,0x2fc90547}},	//   _зрив, chên, _зшил, _waag_
  { {0x11e90029,0x9c4704ab,0xdfd10015,0x61f50548}},	//   _تعني_, ехал, _نيث_, özle
  { {0x69dc00b8,0xc1780091,0x913b000a,0xa4e7000a}},	//   _anre, lbė_, _מעוק, תֵךְ_
  { {0x5a350549,0x600c0008,0x93b7000a,0x9058000a}},	// [5b0] внат, _מִזְ, עלמו_, _אבהו_
  { {0x20fc0016,0x9b440015,0xd6d9002a,0x49d90033}},	//   ỏi_, انكو, _szło_, ьдзю_
  { {0xdcfc0024,0x718b000a,0x1dde000b,0xfe38000a}},	//   parā, לְאַ, मारत, _ארזי_
  { {0xe7190029,0x69dc054a,0x6d45054b,0x87e4054c}},	//   ويات_, _enre, _izha, люче
  { {0x02bc000b,0xb7f2000b,0xf770012c,0x7bdd054d}},	//   ्टोन, _अकरम_, صان_, _insu
  { {0x27e00048,0x0c740086,0xceb400a3,0x7bcd054e}},	//   ķina_, _جدید, ריס_, ldau
  { {0x27ed0298,0xdb04002e,0xf4b30086,0x2c51002a}},	//   _toen_, leið, اشتگ, _sądy_
  { {0x7bcd0084,0x62890020,0x6aad003f,0x1958054f}},	//   ndau, tseo, otaf, _часы_
  { {0x2480016f,0x7c3a0152,0x7bcd0091,0xb2250054}},	//   ćima_, îtri, idau, кмил
  { {0x929d005c,0x6aad003f,0xf61900c3,0x62890550}},	//   szło, itaf, _غياث_, rseo
  { {0xa3e1005d,0x7ff60029,0x00e20010,0x62890551}},	//   दाद_, نسحا, ажэн, sseo
  { {0x339b003b,0xdb04002e,0x94740058,0x62890552}},	//   _رخصة_, keið, _إدلا, pseo
  { {0x7648022d,0x20fc0092,0x6d450553,0x6286008c}},	//   _yhdy, ải_, _azha, škor
  { {0x7af600f2,0x7bdd01c2,0x8e590054,0xc27a000a}},	//   vyyt, _ansu, ејсу_, _חרסי
  { {0x15f4005d,0x20190144,0xc172000a,0xbd830554}},	//   _अवसर_, èric_, _דחו_, ргск
  { {0x3e660152,0xdca301ca,0x20190003,0x20c80058}},	//   _tôt_, јати, érit_, _أبوي_
  { {0x09fa0029,0x32050046,0xa037004f,0x0ba90058}},	// [5c0] وفرة_, ohly_, _שאפה_, عافى_
  { {0xfe9b013a,0x7bcd0026,0x7bdd0493,0xab550015}},	//   _קיימ, adau, _ensu, ائِش
  { {0x7af600f2,0x7e6400f2,0x18a60256,0x765a008c}},	//   syyt, _huip, таем, _rity
  { {0x66010020,0xdb04002e,0x41be000b,0x752d0061}},	//   _allk, beið, _ऍसऍस, ğazl
  { {0xc1780007,0xf62a0036,0x7791002b,0xcb8b000a}},	//   ybė_, міки_, صیلا, _קְטֹ
  { {0x96330010,0x6838001c,0x69dc0334,0x0000006a}},	//   аніц, vídu, _unre,
  { {0xf9b7000a,0x7e640547,0x48e30555,0xafdb01d0}},	//   _שהלך_, _luip, _корв, lløe
  { {0xccf3000a,0xa7da0015,0xdcfe0085,0x8cd30065}},	//   שכה_, _تورط_, _nepč, डितो
  { {0x2a66002d,0xe737004a,0x6d480046,0xd40300eb}},	//   íobh_, _ает_, ýdaj, рящи
  { {0x32050556,0x88ca004f,0xa9b80138,0x0000006a}},	//   ghly_, ֵמָ֖, дзiр,
  { {0xa99b0053,0xbb1b0011,0x09f70008,0x20c30151}},	//   וביר, _neîn, דמים_, асяг
  { {0xc058008f,0xdfd10115,0xc4f7004f,0x3205016d}},	//   кія_, حيح_, _שמאז_, ahly_
  { {0xa2940010,0x82fa002b,0x92940099,0xf457004f}},	//   _салі, _تراز_, _салц, _סידר_
  { {0x27310092,0xdb04001a,0x0e3400f4,0xdef80033}},	//   ỡng_, veið, иняю, тыю_
  { {0xab950185,0xde580036,0xc1bb000a,0x9c650021}},	//   ливі, тарі_, _חמוש, اهرو
  { {0x6aad0557,0xb157000a,0xa4b7000a,0x6b680030}},	//   ttaf, _בסוג_, כללה_, _régó
  { {0xab840558,0xfb840010,0x6aad003f,0x59d90010}},	// [5d0] руск, рысн, utaf, ндаў_
  { {0xdb040084,0xd91b0080,0x66180559,0x7bcd0012}},	//   reið, мье_, jivk, sdau
  { {0x67d5000d,0x58870010,0x2bab000b,0x7d7a000a}},	//   ложу, тыза, _छापा, _אנתו
  { {0xc794008f,0xba7700a2,0x442600bd,0xe8940484}},	//   аршы, _لاست, _njo_, раць
  { {0x4b7a011f,0xd6390010,0xd6a80067,0x7cfc008c}},	//   _ראשו, някі_, ندوم_, pärö
  { {0xa2b8014e,0xd12603c4,0x68e300c0,0x2019055a}},	//   ्बन्, _هم_, änds, hisi_
  { {0x64b50029,0x24960015,0x2019055b,0x60060052}},	//   احتر, هنود_, kisi_, _hóme
  { {0x20190064,0x42c9033d,0xb5fd055c,0x34b60058}},	//   jisi_, егин_, _duša, اهيج_
  { {0x2019055d,0x3205055e,0xdb0f0046,0xe3b6055f}},	//   disi_, thly_, _obcí, убы_
  { {0xe4d70015,0x2019007c,0xe5690015,0x60e90560}},	//   _لتصب, eisi_, _أمضى_, емом_
  { {0x5f06000b,0xafdb02de,0xfbdf0034,0x6e35002a}},	//   सैन्_, dløb, _phêl_, dozb
  { {0xbb1b0011,0x889a000a,0xdee60561,0x320500da}},	//   _reîn, עברי, гоми, shly_
  { {0x443f0562,0xd24e0086,0xc7d6000a,0x20190144}},	//   mlu_, تنی_, אורי_, èria_
  { {0x22920029,0x831a0053,0x20190563,0x443f0564}},	//   _الوس, _אונז, érir_, llu_
  { {0x2fe60015,0x20190565,0xb0f60015,0x443f0566}},	//   _مكثف, bisi_, _مفوض_, olu_
  { {0x3ec900f2,0x20190567,0x443f0568,0x0c850033}},	//   ättä_, cisi_, nlu_, рыём
  { {0x8eb30086,0x6295005c,0x8c43017a,0x6e350030}},	// [5e0] _هميش, ązow, сете, bozb
  { {0x99860015,0x7a300012,0x443f0569,0x0000006a}},	//   الاو, lätz, hlu_,
  { {0x443f056a,0x3ea2056b,0x6d8b000a,0x3ce50123}},	//   klu_, lukt_, _אָכְ, älvt_
  { {0xdc9b0008,0xad1b0053,0x9d1b0053,0x443f0085}},	//   _איטל, _טויר, _טויט, jlu_
  { {0x443f0176,0x68e300c0,0xa3d7000b,0xce36000a}},	//   dlu_, ändr, ायन_, ְאֶת_
  { {0x7a3000b8,0x629b0007,0x7c240011,0x2019056c}},	//   hätz, druo, lnir, zisi_
  { {0x2955010f,0x2a3b000a,0xd497056d,0x24800085}},	//   _вътр, _נעלמ, гры_, ćimo_
  { {0x68e3056e,0x443f056f,0xa3ab000b,0x9cd7000a}},	//   ånde, glu_, गभग_, רוקה_
  { {0x629b0091,0x2d8a0570,0x20190571,0x87260572}},	//   gruo, kabe_, visi_, _смаж
  { {0x32b70029,0x51f80036,0x20190573,0x236d006f}},	//   ادية_, тною_, wisi_, acej_
  { {0xaa370053,0x3a370008,0xe020000b,0xca37000a}},	//   רטיק_, ררים_, मचंद_, רניה_
  { {0x7c24016f,0x69ce0574,0x2d8a007c,0x9f49001a}},	//   jnir, _labe, eabe_, _blað_
  { {0xa3e1005d,0x743b0053,0x20190575,0xbea40033}},	//   दार_, _װעגװ, risi_, баўк
  { {0xd25000e6,0x20190332,0x2fcd0085,0x2d8a0576}},	//   _بنت_, sisi_, žeg_, gabe_
  { {0x02170008,0xafdb02de,0xd23b000a,0x64400577}},	//   _תחום_, rløb, _רגול, olmi
  { {0xfbdf00a7,0xeaf8002b,0x38ae001a,0x2d85002a}},	//   _thêm_, گرفت_, dýr_, źle_
  { {0x4424002d,0x7a3000f2,0x7c280152,0xdd950010}},	// [5f0] inm_, läty, édra, _капы
  { {0xceb40053,0x69ce0578,0x0c75002b,0xd99900c3}},	//   _היץ_, _cabe, _نگرد, ئنات_
  { {0x69ce018b,0xa3d7000b,0xa9080015,0x7a30008c}},	//   _dabe, ायम_, هيكل_, näty
  { {0x8d740074,0xf0930008,0x6c7a0053,0xedc5000b}},	//   _پایا, מנע_, _שארפ, _लघुछ
  { {0x66e50579,0x68e304d1,0x69ce057a,0x958502ed}},	//   рола, åndb, _fabe, алле
  { {0x44a50029,0xcdd5000a,0xd6780015,0x69ce057b}},	//   لمتق, יךְ_, احنا_, _gabe
  { {0xfdf80008,0xf3e50286,0x7a30008c,0x443f057c}},	//   רצות_, ижко, jäty, tlu_
  { {0xc2c50029,0x7a30008c,0xd7c9002b,0xdc6c000a}},	//   ليبي, däty, _جوره_, ע֣וֹ
  { {0x443f0375,0x020500d7,0xa3d7000b,0x91f50015}},	//   rlu_, изин, ायब_, لأدا
  { {0xd24e00e6,0x443f057d,0x64400044,0x5155004a}},	//   وني_, slu_, almi, итну
  { {0xd00a057e,0xd59a000a,0xd12e0015,0x443f057f}},	//   вене_, _יֹאכ, ِمٍ_, plu_
  { {0xdcfe0024,0xc0590010,0x83350010,0x2d8a0035}},	//   _nepā, ліў_, _кнех, wabe_
  { {0x629d00dc,0x7995005c,0x60170033,0x91e50580}},	//   ásod, _odzw, роўя_, _воле
  { {0x44d503eb,0x7a30018b,0xd1670063,0x3ea20581}},	//   _kā_, sätz, _съди, rukt_
  { {0x6b66010f,0x2d8a0582,0x44d50024,0x6c360015}},	//   иква, rabe_, _jā_, لفسا
  { {0x69ce0583,0x8b26012e,0xf092004f,0x9e6600af}},	//   _sabe, адбе, _ונה_, _квид
  { {0xcb00005d,0x69ce0584,0x70530087,0x78bc0559}},	// [600] लैंड_, _pabe, _بنيا, _sprv
  { {0x0b5902bf,0xa95a00c3,0x7e7602f2,0x2d960585}},	//   урсы_, نجار_, _ityp, _трис
  { {0xa7660083,0x44c700dc,0xa90a0015,0x61ee007c}},	//   акед, _nő_, خيال_, öbli
  { {0xf0b60053,0x69ce0586,0xb5fd0085,0xb9550054}},	//   ילער_, _wabe, _bušo, стућ
  { {0xe7b3002b,0x7bc40045,0x69ce0587,0x16a70588}},	//   تمند, meiu, _tabe, ивци_
  { {0xa6130191,0x96f7000d,0x2888002b,0x94aa0015}},	//   оміч, решт_, _مصری_, نطبق_
  { {0xb4e0000b,0xe0c7002b,0x291e0123,0x628200da}},	//   दमे_, _بز_, _äta_, _swoo
  { {0x39470061,0xdc9b000a,0xf3f8003d,0x4c9b000a}},	//   ünse_, דיקל, _kuģi_, דבקו
  { {0x5214005f,0x41e60010,0xa320000b,0x3f8b0085}},	//   йдит, аіна, मपेज_, vacu_
  { {0x44c700dc,0x7178056d,0x41b4002b,0xe2140174}},	//   _fő_, ыбор_, حمدر, ёмны
  { {0xf993013a,0x30a3006b,0x69d9004c,0xbb1b0045}},	//   חרת_, оряв, אַרו, _reîm
  { {0xa2b8005d,0xdb1d00dc,0xa3e1000b,0x34fb000a}},	//   ्बद्, _vasú, दाः_, _שהאד
  { {0xc7b3000f,0x69a7000b,0x8857004c,0x7a30008c}},	//   חבר_, _चाली, ישטע_, säty
  { {0x27230092,0x82330021,0x8d740015,0x7bcf0589}},	//   ằng_, _وروا, قافا, _sacu
  { {0x4094040b,0x4c940080,0x9cf4005e,0x7bcf058a}},	//   _البر, жисс, озрі, _pacu
  { {0x515b0008,0x415b000a,0x3ced0085,0x2723006f}},	//   _בכוו, _בדוג, ćev_, nčnú_
  { {0x1a5b0029,0x9967058b,0xa3d7000b,0x20120079}},	// [610] نشطة_, ател, ायत_, ëzie_
  { {0x2b850092,0x0357000a,0xac9500af,0x0000006a}},	//   ặc_, שימש_, _лаош,
  { {0x6d5a0091,0x2723006f,0xc7c7058c,0x7bcf058d}},	//   žtar, kčnú_, исди, _tacu
  { {0xf7f40086,0x7bc40045,0x7d36004f,0x6e88009a}},	//   يسند, ceiu, _לנתב_, _حنیف_
  { {0xd6d90050,0xa3ea021e,0x25f5000b,0x87d40021}},	//   _była_, मान_, ्सली_, تغلا
  { {0x8578006b,0x9991002a,0xc4c50015,0x05a8005e}},	//   асът_, żały_, متعو, ивій_
  { {0x69c50020,0x18a40010,0xcd980008,0xe89401c5}},	//   mehe, _маём, בדות_, _марь
  { {0x69c50005,0xf8b2000a,0xe45f007c,0x53c9058e}},	//   lehe, _משל_, öö_, угим_
  { {0x60320024,0xe2990054,0xe5c7058f,0x60060533}},	//   lāmg, ћао_, _всео, _nóma
  { {0x44d50048,0xd49b0033,0xcb12000a,0x9f590125}},	//   _tā_, _ард_, פלי_, bhsú_
  { {0xa3d7005d,0x3f890590,0x629d0264,0x7e76002a}},	//   ायद_, _beau_, ásob, _styp
  { {0x69c500b8,0x34b6000a,0x263f002a,0x88ba000a}},	//   hehe, _לפעם_, _dłoń_, נזרי
  { {0x83b6000a,0xe3b0002b,0xaac6000b,0x63a90591}},	//   _הִוא_, _آرم_, _रैंक, mgen
  { {0x3f9e0064,0xc27a0053,0x63a90592,0xdcfe0045}},	//   ştu_, _ערצי, lgen, _nepă
  { {0x61e30593,0xddcd0011,0x1ee8002b,0x61fc0594}},	//   _innl, _staţ, _چوبی_, örle
  { {0xb09a0053,0x60160007,0x60dc0595,0x200b0046}},	//   _עיפר, kšmi, ærme, chci_
  { {0xfe72003b,0x63a90596,0x6da60597,0xada60598}},	// [620] _عدة_, igen, _липа, _лапл
  { {0x200200f2,0xcaa50015,0x443d0012,0x69c50599}},	//   lkki_, تصفي, _lkw_, gehe
  { {0xa3d7014e,0xdcfe0011,0x395c00c0,0xa3ea000b}},	//   ाया_, _depă, ävs_, माम_
  { {0x2002022d,0xa6e90023,0x63a90079,0x68e30123}},	//   nkki_, _trự, jgen, ånda
  { {0xadec0372,0x6c57000a,0xa3e1000b,0x37ab002b}},	//   ञापन_, _ליטא_, दाई_, ائمی_
  { {0x47330036,0x60320024,0x63a9059a,0xb8660115}},	//   чніс, lāmd, egen, _هارو
  { {0x7d7b0053,0x18a30010,0xf8780008,0x63a9059b}},	//   אנצו, _нарм, _כְּל, fgen
  { {0x3a3a01d1,0x6815005c,0xb274059c,0xc274009c}},	//   lopp_, ządz, олиш, олиј
  { {0xfbd30008,0x42540021,0x443d059d,0x0000006a}},	//   לתה_, ينبر, _dkw_,
  { {0x60060097,0xe2140033,0x63a9059e,0x25a8002b}},	//   _róma, імны, agen, _خضری_
  { {0x3f890152,0x63a9059f,0xd577004f,0x60060052}},	//   _peau_, bgen, _התבה_, _sóma
  { {0x82a60457,0xc4d3000a,0x61e300cb,0x7f590461}},	//   _гадж, _מגע_, _ennl, ианс_
  { {0x60dc0134,0x3f890003,0xa194009b,0xddcd013b}},	//   ærmb, _veau_, _далч, _ataš
  { {0xddcd005c,0xf0b7002b,0xcd74006b,0x6b8d05a0}},	//   _uważ, جایش_, згръ, waag
  { {0xf0b70086,0x321e05a1,0x69c505a2,0x1df8004a}},	//   _هايش_, mity_, vehe, щеры_
  { {0x321e05a3,0x6815002a,0x0077000a,0x600605a4}},	//   lity_, sądz, _פתחי_, _tóma
  { {0xeab00029,0x69c505a5,0x6b8d0159,0x7dc70033}},	// [630] فعل_, tehe, raag, _лёнд
  { {0x996705a6,0xddab05a7,0x321e05a8,0x7e7d05a9}},	//   стал, _стил_, nity_, mpsp
  { {0x69c503d6,0xa9280033,0x321e008c,0x094b05aa}},	//   rehe, біце_, iity_, учаи_
  { {0x69c5018b,0xad1a0008,0x69da002e,0xb8f1021e}},	//   sehe, _כותר, _óten, _वन_
  { {0xcf940053,0x8f9c000a,0xa635005e,0xe7390054}},	//   פטס_, רידי, онді, јел_
  { {0x20090026,0x75d50058,0x60160160,0x0000006a}},	//   _llai_, زيعا, ršmi,
  { {0x2002002e,0xe5c40033,0xc87f0061,0xa026008c}},	//   ykki_, ясцо, ışsa_, ntöä
  { {0x58050015,0xdb0d0077,0xad1c000a,0xdc8c000a}},	//   _بورك, leañ, טוור, רְגָ
  { {0x23290185,0xb725002b,0x42090054,0xf6740015}},	//   ропи_, _بکاه, инио_, _فالخ
  { {0x31250080,0xb5fd016f,0xb2360015,0x62320054}},	//   ждог, _mušk, يكيا_, мењу
  { {0x63a90079,0x443d01d7,0xd4980099,0x320701c0}},	//   pgen, _tkw_, _грч_, _vlny_
  { {0xa3ea005d,0x20560010,0xb4d5005d,0xf487002b}},	//   माण_, ўтор, िटी_, _ناچی
  { {0x2002022d,0xce4a05ab,0x321e05ac,0x2a7901f9}},	//   rkki_, изме_, bity_, _ntsb_
  { {0x27380023,0x27e00024,0x321e05ad,0x8cc6000b}},	//   ứng_, ķini_, city_, ाबलो
  { {0xdbc70084,0xed5a05ae,0x3e6f007c,0x8d630004}},	//   töðu, ров_, _eüt_, двре
  { {0xc4d205af,0x1c46017f,0xcb67006b,0x2004003d}},	//   וגל_, інам, жате_, ījis_
  { {0xdbc7002e,0x3a3a05b0,0x0000006a,0x0000006a}},	// [640] röðu, topp_,   ,
  { {0x497a008f,0x718c0053,0x68fe02ad,0x0000006a}},	//   рсаў_, ָװאַ, typd,
  { {0xd6d90050,0x3a3a00d6,0x0000006a,0x0000006a}},	//   _było_, ropp_,   ,
  { {0x321e00bf,0x574602db,0x6e3c02ad,0x386d005a}},	//   zity_, онеб, lorb, _čert_
  { {0x62860089,0x6e3c016b,0x66730058,0x2441016d}},	//   škoz, oorb, ودور, nómu_
  { {0x2ba8005d,0x3ecb0008,0xd49a05b1,0xd4da0015}},	//   गलवा, שֶׁ֣, ари_, لبعض_
  { {0x25a001e2,0x1db2005d,0xe4a6005e,0x321e05b2}},	//   ğil_, _जानत, ірко, vity_
  { {0x25a00064,0x321e005c,0x6e3c002d,0x18670004}},	//   şil_, wity_, horb, _фати_
  { {0x6ab60050,0x24890085,0x320c0034,0xe7f9000b}},	//   ntyf, ćama_, thdy_, ूसरा_
  { {0x6acb000a,0x3abb004f,0xa5730058,0xd2500369}},	//   בֶטַ, סמינ, _يُقت, عند_
  { {0x104b005f,0x3cf6005d,0xb3ca05b3,0x321e05b4}},	//   иями_, ीनों_, _влез_, rity_
  { {0x321e003e,0xd7e60015,0xdb21013f,0x8f3505b5}},	//   sity_, رك_, _štíh, земц
  { {0xa3d7005d,0x14390086,0x6e3c01f0,0x14170015}},	//   ायर_, _اينک_, forb, _بينة_
  { {0x40940015,0x6e3c05b6,0x0000006a,0x0000006a}},	//   _فلتر, gorb,   ,
  { {0x317b0008,0x5478000a,0x4478000a,0xb478000a}},	//   _דרומ, מְּנ, מְּא, מָּי
  { {0x80c7005d,0x6ff40015,0xbc27005e,0x23bc000b}},	//   ़बरे, _يسيط, ієви, ्जिद
  { {0xf96b033d,0x6e3c05b7,0x0000006a,0x0000006a}},	// [650] арей_, borb,   ,
  { {0x527b00b2,0xa2b2005d,0xc27b000a,0xa907006e}},	//   ינמא, _आमन्, ירמי, يبان
  { {0x81bc0024,0x602400dc,0x18a40036,0x60320024}},	//   tnēj, sőme, даєм, sāme
  { {0x2d91016f,0xfd56000a,0x7b040030,0x61f801de}},	//   laze_, _משתי_, ötté, _lovl
  { {0xeb760053,0x76c70002,0x501c000a,0x0000006a}},	//   _מערץ_, تغال, סודו,
  { {0xe6180036,0xe7300015,0x8f38000a,0x2d9105b8}},	//   оді_, خصم_, קאגו_, naze_
  { {0xf5050210,0xd4d90033,0xe3c50015,0x7e6d050b}},	//   язко, сьлі_, كْثَ, _luap
  { {0xb8ff000b,0x787a000a,0x6006006f,0x69d505b9}},	//   ति_, _לָמו, _rómo, _haze
  { {0x29ff005c,0xa2d20015,0x69d505ba,0x2d9105bb}},	//   ałań_, فييت, _kaze, kaze_
  { {0x11d5003b,0xddc4016f,0x46150067,0x35f80067}},	//   ستخد, _stiž, _عوار, _ورلد_
  { {0xcea90135,0x38b505bc,0x61fc0123,0xa85505bd}},	//   _תי_, når_, örla, ּיָה_
  { {0x6e3c00b8,0x69d505be,0xafdb01d0,0x3f82005a}},	//   worb, _laze, lløj, ubku_
  { {0x93270087,0x94db000b,0xd00f0015,0x63bb05bf}},	//   _بران, _मछुआ, الُ_, mfun
  { {0x2d8c03af,0xa2f60008,0x01650015,0xdb1d002a}},	//   úde_, _ממנה_, _عُبَ, _lasó
  { {0xe1660086,0x40920015,0x1d0705c0,0x59df000b}},	//   _عضوی, _كلور, пери_, _नफ़र
  { {0xc4d200b2,0x25e2005d,0xbc6305c1,0xd116000a}},	//   עגן_, _टोनी_, евск, _מקצה_
  { {0x2fc000b6,0x02b60053,0x63bb003f,0x69d505c2}},	// [660] _ibig_, ּלעך_, ifun, _baze
  { {0xa3e2005d,0x25db005d,0x6ab6005c,0x4a4305c3}},	//   _फोन_, _गोली_, rtyf, енув
  { {0x5dfb0008,0xa9670063,0x3dfb000a,0x8dfb000a}},	//   _הפינ, чиха_, _הליד, _ההית
  { {0xde6d0092,0x46ea05c4,0x83fc0085,0xcc77004f}},	//   _hươn, йден_, _tuđi, _מעטה_
  { {0x69d503af,0x073a003b,0x6d400064,0xa3ea000b}},	//   _faze, حساب_, şmad, मास_
  { {0x69d505c5,0x6b840012,0x2816002b,0x63bb05c6}},	//   _gaze, lbig, _کورس, efun
  { {0xdb0f038d,0x2d8500dc,0x629d00dc,0x63bb05c7}},	//   _accè, űleg_, áson, ffun
  { {0xde6d0092,0x929d002a,0xf8b7000a,0x02a605c8}},	//   _lươn, zyłe, _מפלי_, пром
  { {0x6b840035,0x61f802c6,0x35a60033,0x6aa400a9}},	//   ibig, _povl, _нааг, nrif
  { {0x27e00048,0x320a005c,0x6faa005d,0x9098000d}},	//   ķinu_, óby_, _काउं, овот_
  { {0x6aa405c9,0x2ee00049,0x2d9105ca,0xb5a90015}},	//   hrif, _arif_, vaze_, _ذالك_
  { {0xe45a05cb,0x2ee00026,0x44200064,0xc4c50015}},	//   _уже_, _brif_, _öi_, _تتكو
  { {0xf206010f,0x2d91006f,0xeb9f02de,0x7de7005e}},	//   _няко, taze_, _fløj_, півд
  { {0x9c8305cc,0x3205003e,0x6aa405cd,0xde6d0092}},	//   účov, ckly_, drif, _cươn
  { {0xc1bb0008,0xde6d0092,0x69d505ce,0x38a00045}},	//   _המוש, _dươn, _raze, nără_
  { {0x6aa40176,0x6b8400b6,0xdfd10002,0x929d002a}},	//   frif, gbig, _شيخ_, syłe
  { {0x8f9c0008,0x6aa405cf,0x69d50024,0xb03800a3}},	// [670] _היחי, grif, _paze, _מנהג_
  { {0x6f0f0064,0xde6d0092,0x6b8405d0,0x3ea4006f}},	//   ıncı, _gươn, abig, ámte_
  { {0x60320048,0x799c0026,0xe3c70007,0x2988006b}},	//   lāma, _ddrw, ščių_, ясто_
  { {0x290f005c,0x7af20046,0xdc88000a,0x8d87002b}},	//   ąga_, _šetř, _מְשָ, _بشکن
  { {0x16a90036,0x290702c6,0x7bda000a,0x6032003d}},	//   івки_, šna_, _וקרו, nāma
  { {0x68e100dc,0x45d20001,0xde6d0092,0xc60405d1}},	//   _áldo, вољс, _xươn, нзій
  { {0x2489016f,0x8cd3000b,0x7c2d05d2,0x63bb05d3}},	//   ćamo_, डिटो, onar, tfun
  { {0x63bb003f,0xdb0f05d4,0x1309006d,0x25eb000b}},	//   ufun, _accé, жний_, चाही_
  { {0x2d9e002e,0x35b50054,0x17f80015,0x7c2d05d5}},	//   ótek_, _обар, _عرفة_, inar
  { {0x3eab05d6,0x22560115,0x86c40015,0xaa7b006f}},	//   duct_, وليد_, _سيمن, _zrýc
  { {0xc609005d,0x7c2d05d7,0xf992000a,0x33b5004a}},	//   वसीय_, knar, כרי_, _жёлт
  { {0x2ee00176,0xde6d0016,0x001a0033,0xa03a0015}},	//   _prif_, _sươn, іўны_, تأخر_
  { {0xa3ea005d,0x7c2d00bd,0x644905d8,0x93940015}},	//   मार_, dnar, mlei, _سجنا
  { {0x3f82005c,0x442d05d9,0x4df50033,0x443f05da}},	//   dłuż_, lne_, няст, lou_
  { {0x442d05db,0x3eb90111,0xde6d0092,0x9e6303f1}},	//   one_, atst_, _vươn, тврд
  { {0x442d05dc,0x443f05dd,0xdbf20046,0x645b008c}},	//   nne_, nou_, přís, nmui
  { {0xde6d0023,0xc0530008,0x6aa40020,0x8c430345}},	// [680] _tươn, _בזה_, urif, тете
  { {0x2b8c0023,0x443f05de,0xab290015,0x644905df}},	//   ếc_, hou_, أسفل_, hlei
  { {0xe9470086,0xd23a0053,0xc8ca0018,0x851c000b}},	//   ورمی, קגעל, توان_, _भेंट_
  { {0x798e020a,0x442d05e0,0x443f05e1,0xccf3000a}},	//   _webw, jne_, jou_, _סכר_
  { {0xb8650086,0x629d00dc,0x443f05e2,0x442d05e3}},	//   رامو, ásol, dou_, dne_
  { {0x44ce0089,0x644905e4,0xa4d801f3,0x442d05e5}},	//   _př_, elei, здку_, ene_
  { {0xa3ea005d,0x3e7400c0,0x55e305e6,0x94aa05d1}},	//   माल_, _lät_, тојб, ітка_
  { {0x443f001c,0x27e00024,0x68e30134,0xaa7b002c}},	//   gou_, ķins_, ænde, _urýc
  { {0x61fc0123,0x3e740123,0x0000006a,0x0000006a}},	//   örlo, _nät_,   ,
  { {0x442d05e7,0xcb57000a,0x60dc02de,0xf12601c5}},	//   ane_, וספה_, ærmo, дьмо
  { {0x85060074,0x25eb005d,0xdfd10002,0x7c24014b}},	//   _توان, चारी_, هيد_, kiir
  { {0x443f05e8,0x6032003d,0x442d05e9,0x60240030}},	//   cou_, tāma, cne_, tőma
  { {0xdefb0010,0x64400007,0x9f050029,0x442405ea}},	//   цын_, momi, روسو, mim_
  { {0x60320024,0x644005eb,0x3eab05ec,0x6e440015}},	//   rāma, lomi, ruct_, َنَم
  { {0x718b000a,0x6440007c,0x6032003d,0x61ea05ed}},	//   _וְחַ, oomi, sāma, _infl
  { {0x442405ee,0xfc3000c3,0x2bdf000b,0x644005ef}},	//   nim_, لحق_, _पोशा, nomi
  { {0xa3b6005d,0xcd040089,0x8fa40001,0x7c2d05f0}},	// [690] _जान_, vněž_, _рање, rnar
  { {0x443f05f1,0x442d05f2,0x442405f3,0x7c2d05f4}},	//   zou_, zne_, him_, snar
  { {0x5a440010,0x39470134,0x8e380015,0x644005f5}},	//   тэта, æns_, _تسير_, komi
  { {0x443f001c,0x64400007,0x442405f6,0x27e90077}},	//   xou_, jomi, jim_, ñan_
  { {0x443f0264,0x4b7a000a,0x7bcd0003,0x442d05e3}},	//   vou_, _מארו, meau, vne_
  { {0x442d0050,0x9f5900c0,0x442405f7,0x64490034}},	//   wne_, ckså_, eim_, wlei
  { {0xe3b1003b,0x6006002d,0xfdf80008,0x442d05e3}},	//   هرة_, _fómh, וצגת_, tne_
  { {0x442d04f9,0x645b003f,0x644000f0,0x36d505f8}},	//   une_, umui, gomi, _побр
  { {0x442d05f9,0x7bcd0024,0xf77201ac,0x443f05fa}},	//   rne_, ieau, _תקמ_, rou_
  { {0xe1f1003b,0x443f05da,0x442d05fb,0x64b70015}},	//   اسة_, sou_, sne_, _يحضر
  { {0x659405fc,0x443f05e2,0x2c750123,0x602605fd}},	//   _раху, pou_, _nåd_, една
  { {0xa3b6000b,0x44270015,0x442405e0,0x644005fe}},	//   _जाय_, _غراف, cim_, comi
  { {0x2ac30024,0x7c2405ff,0xdd02006f,0x7bcd0600}},	//   nībā_, viir, ľuču, deau
  { {0xa3d7005d,0x2d9e0152,0xdd920031,0xb5fd0085}},	//   ायक_, ûte_, طور_, _gušt
  { {0xd00a0001,0xa3b6000b,0x91b6000a,0x7c240601}},	//   _неке_, _जाम_, _נפקא_, tiir
  { {0x711a000a,0x7bcd0602,0x611a004f,0x3e7402dc}},	//   _מוצפ, geau, _מוצה, _tät_
  { {0x1f660036,0xf4120053,0x60060603,0xeb750033}},	// [6a0] _яким, אפן_, _rómh, тысэ
  { {0xa3b1005d,0x7c240604,0xe9d70605,0x44240606}},	//   फ़्त_, siir, нку_, zim_
  { {0x44240064,0x7c240607,0x1bea0608,0x3fda000a}},	//   yim_, piir, _едни_, ּקְב
  { {0x44240609,0x95fa000b,0x929d002a,0x7d01060a}},	//   xim_, ्स्ट_, zyła, älse
  { {0x4424060b,0x60060077,0x2f97000a,0xb7d70015}},	//   vim_, _cómi, תכנן_, عوها_
  { {0x44240026,0x999a002a,0x0f37004c,0x6440002a}},	//   wim_, żyły_, ערסט_, womi
  { {0x7c2f002d,0x8c1a0008,0x81bc0024,0x4424060c}},	//   _áirí, ּוִי, inēt, tim_
  { {0xd4670124,0x644000f2,0xccf301d8,0x937a0015}},	//   није_, uomi, רכה_, أصغر_
  { {0x07b7003b,0x2ac30024,0x4424060d,0xa2260015}},	//   _سهلة_, cībā_, rim_, فرده
  { {0x4424060e,0x6440060f,0x872300ce,0x66130535}},	//   sim_, somi, _смуж, ądkó
  { {0xe9f90016,0x44240610,0x64400611,0x64a30612}},	//   huế_, pim_, pomi, _баха
  { {0x929d0050,0x28970008,0xdfd10087,0x2c750613}},	//   syła, עדכן_, جيح_, _råd_
  { {0x7bcd0614,0x93fb0008,0xaacf000b,0x33fb000a}},	//   veau, _מלאי, _सैंक, _מהאנ
  { {0x91e30054,0x81bc003d,0xd6eb000a,0xaa7b001a}},	//   _боље, gnēt, הַלָ, _brýn
  { {0x8c250015,0x7bcd0615,0xc534000a,0x2ac3003d}},	//   نفسه, teau, דָּה_, zībā_
  { {0x7c84000d,0x59c6000b,0x8cc2000b,0xdbf20046}},	//   ѓусе, _रॉबर, _लहरो, třás
  { {0x7b740029,0xc334000f,0x49cb056d,0xda090015}},	// [6b0] اطفا, דוּ_, зуем_, ويره_
  { {0x7bcd0616,0x1a65002b,0x9aa40015,0x2bcf000b}},	//   seau, ئیسی_, املو, हजहा
  { {0x48ab0617,0xae1c000a,0x5d55009c,0x7bcd0618}},	//   ятам_, _מוזכ, _шкот, peau
  { {0xfbab005f,0x629d0014,0x200b0089,0x4c9a000a}},	//   _этой_, ások, nkci_, _קברו
  { {0x79a700d7,0xc66b004a,0x8f9c004c,0xe56e012e}},	//   _прве, чшее_, לסאה, из_
  { {0x2ac30024,0x64a504c2,0x06080033,0xb5fd0091}},	//   rībā_, вака, ннік_, _aušr
  { {0xda3404ab,0x69c1000b,0x2ac3003d,0x7d7c000a}},	//   _серы, र्णी, sībā_, לנגו
  { {0x73e501e9,0x0000006a,0x0000006a,0x0000006a}},	//   тоиз,   ,   ,
  { {0x961d003d,0xe3b1002b,0x02bd000b,0x27ed0619}},	//   _atņe, هرک_, ्बेन, _inen_
  { {0x96df008f,0x85b80180,0xd5d40015,0x64c50058}},	//   _нiву_, _плус_, _متمث, _ليطل
  { {0xd656000a,0x7643061a,0xb97a000a,0x21690004}},	//   _סיעת_, mony, ונתי, ќини_
  { {0x7d07005c,0x27ed0012,0x94740067,0x7643061b}},	//   dyjs, _jnen_, _صدما, lony
  { {0x93940029,0x441a00f3,0x60240030,0x0f360033}},	//   _إجما, _קונס, sőmo, тэня
  { {0x6f06002a,0x7643061c,0xed5a00af,0x0000006a}},	//   rykc, nony, дог_,
  { {0xdcfc0048,0xdde400dc,0xb1160015,0x201a0015}},	//   varē, ésőb, _لقوا_, _يتبع_
  { {0xd164006b,0x27ff00da,0x764300a6,0x7ae90085}},	//   _съчи, _noun_, hony, _šeta
  { {0xee3a061d,0xab27061e,0xab660617,0x7643061f}},	// [6c0] _они_, вота_, твал, kony
  { {0x48e60001,0x7d010012,0x7643002a,0x629b0620}},	//   козв, älsc, jony, isuo
  { {0x2d980621,0x7d07002a,0x35c4000b,0x76430622}},	//   mare_, cyjs, ल्फ़, dony
  { {0x661d0007,0x8b260010,0x2d980623,0x3156004c}},	//   _įska, _адме, lare_, דיען_
  { {0x76430034,0xc6d30015,0x2d980045,0x4b55009b}},	//   fony, لتوت, oare_, _бърт
  { {0x8f1b0008,0x2d980624,0xeb00000b,0xceb5004c}},	//   וונת, nare_, ोनीत_, ריװ_
  { {0xd5e90092,0x6d480061,0x4c9b004f,0x64b30058}},	//   _qué, üdah, ֵ֑הו, لحير
  { {0x64590625,0x9836008f,0xd90d0086,0x20000011}},	//   _chwi, _рэгі, _عین_, _noii_
  { {0x20d304f9,0x7643000c,0x2d9801d1,0x69dc0626}},	//   _aţi_, bony, kare_, _kare
  { {0x69dc0298,0x7643005c,0x2d980627,0x69de0628}},	//   _jare, cony, jare_, ndpe
  { {0x50f30010,0x2d980629,0x32530033,0x98c50085}},	//   азэт, dare_, рвэр, čuće_
  { {0x351b000a,0x289b004c,0x0326062a,0x03a3029f}},	//   _קואנ, ויטא, _иден, _вицо
  { {0xdcf50048,0x4ea70063,0x63a2062b,0x69dc0011}},	//   pazī, ърна, _idon, _oare
  { {0xc0aa00b0,0x69dc0198,0x2d980629,0x7d07002a}},	//   _قابل_, _nare, gare_, tyjs
  { {0x20d30225,0x6d40062c,0xdfd10015,0x6272002a}},	//   _نتيج, şman, _هيث_, _błog
  { {0xec34062d,0x7d07005c,0x7643062e,0xd0f7000f}},	//   ансь, ryjs, zony, _ימות_
  { {0x7d07005c,0xbfb40015,0x69de0079,0x3b55062f}},	// [6d0] syjs, _ضحيت, fdpe, укар
  { {0x2d980630,0x69dc0631,0x58870033,0x0e470033}},	//   care_, _care, выда, _шэйм
  { {0xd8740021,0x320c013f,0x7c30001a,0xad19000a}},	//   لانب, ikdy_, ðirð, _נוֹר
  { {0xac190036,0xe10b0008,0xc7c4004a,0x6272002a}},	//   _чому_, וּדָ, исчи, _kłod
  { {0x07a4008f,0x7c3a0014,0xf77003c4,0x501c0632}},	//   раін, étre, زان_, וואו
  { {0x6272005c,0x7643003f,0x69dc0633,0xfb1a004c}},	//   _młod, uony, _gare, _טורמ
  { {0x5e580053,0x25a90064,0x7bdd0634,0x3f990635}},	//   דיגע_, ğal_, _kasu, kasu_
  { {0x2d9804f9,0x3f990085,0xa3ea000b,0x27ed0636}},	//   zare_, jasu_, माग_, _unen_
  { {0x3f990026,0x36d4059c,0x76430637,0x04560015}},	//   dasu_, _котр, pony, دلية_
  { {0x81850010,0x2d980011,0x386d0638,0x7bdd007c}},	//   ыгож, xare_, _hier_, _lasu
  { {0x63ae002d,0x2d980639,0x45b6000a,0x98480045}},	//   áiné, vare_, _תפעל_, _uşă_
  { {0x7bdd063a,0xafdb063b,0xc952000a,0x6d5a006f}},	//   _nasu, dløs, ממי_, ýtam
  { {0x539a0008,0x765a00f2,0x7e600111,0x2d98063c}},	//   _ניסו, _yhty, ïmpo, tare_
  { {0xb7c20024,0xc332000a,0xf2d2000a,0x386d063d}},	//   ēģin, _פוג_, _לעד_, _lier_
  { {0x7bdd063e,0x2d9803c9,0x721a000a,0x69dc063f}},	//   _basu, rare_, _רוצח, _rare
  { {0x44e301e2,0x59c6005d,0x69dc0640,0x2d980641}},	//   _mı_, र्नर, _sare, sare_
  { {0xc017000a,0x6272002a,0x44e30061,0x69dc0642}},	// [6e0] _תקפו_, _głod, _lı_, _pare
  { {0xeef70643,0x3d070030,0x38bc0052,0x0000006a}},	//   _עמיר_, ívvá_, tír_,
  { {0x44e30064,0x3ea000cb,0x290e001a,0x778603ae}},	//   _nı_, _hvit_, áfa_, глез
  { {0xe73a005f,0xb8dc005d,0xaaac005d,0xf0b60053}},	//   нее_, _आम_, _चिपक, טלער_
  { {0xc7a30063,0x69dc0644,0x386d016b,0x8f9b000a}},	//   сичк, _tare, _dier_, תיני
  { {0x386d0645,0xceb3039e,0x7995059b,0x3f99002a}},	//   _eier_, מיד_, _gezw, zasu_
  { {0x6282014c,0x7ae40646,0xd4c60015,0xa8d8000a}},	//   _stoo, lvit, اغتي, _בַּת
  { {0x7995005c,0x28030089,0x386d0647,0x7ae40648}},	//   _zezw, ěrná_, _gier_, ovit
  { {0xf5b60115,0xd40303a9,0x7ae40649,0x7bdb000a}},	//   _مصاد, сящи, nvit, תקפו
  { {0xddcd0089,0x660100e8,0x7e600079,0x7ae4064a}},	//   _staž, _golk, ïmpl, ivit
  { {0x463b00b2,0xddcd0011,0x09f70008,0x3f99064b}},	//   _טעמע, _luaţ, אמים_, tasu_
  { {0xb84a0010,0x63a2003f,0x6272002a,0xb4fb000a}},	//   млiв, _udon, _płod, _רפאי
  { {0x6d4001e2,0xcf270029,0x7bdd0375,0x20190091}},	//   şmal, ارجي, _rasu, ūrio_
  { {0xd2b7013a,0x27310023,0x44e30064,0x21760004}},	//   _עלות_, ạng_, _yı_, _судр
  { {0xdb0d002d,0x317b0135,0x7514000a,0x6272002a}},	//   rgaí, _ארומ, בַּע_, _włod
  { {0x6006001a,0x60c5007c,0xafdb064c,0x0000006a}},	//   _dóms, _ähma, rløs,
  { {0x7ac70010,0xdcfc0091,0x7ed70015,0x59c6000b}},	// [6f0] ысве, karė, _إزعا, र्भर
  { {0x386d003c,0xdb16002e,0xafdb0293,0xfaa80015}},	//   _sier_, reyð, pløs, اهلي_
  { {0x7bdd0005,0xdcfc0007,0x4426064d,0x7d7a000a}},	//   _tasu, darė, _omo_, _בנתו
  { {0x7995005c,0xe84b0115,0x2ee901c2,0xa09b000a}},	//   _wezw, رجان_, _kraf_, תיאט
  { {0x2d94002c,0x6b8d064e,0xcb9a0008,0xf7450001}},	//   ždeň_, mbag, _בסרט, јело
  { {0x6b8d064f,0x68e30650,0x59840033,0x386d0651}},	//   lbag, ånds, _глёб, _wier_
  { {0xd6180015,0x386d0652,0x66010653,0xa9c400e2}},	//   دتنا_, _tier_, _volk, _усяк
  { {0x66010654,0x92f50058,0xf2d9009a,0x0000006a}},	//   _wolk, لأخض, نبخش_,
  { {0x21f50191,0xa3ea000b,0x929d002a,0xe2990054}},	//   аїнс, माज_, myłk, њао_
  { {0x0322008f,0x20c50036,0xcad8000a,0x20da0085}},	//   ідэн, айом, רוזת_, kšić_
  { {0x2ee90026,0x6032003d,0xd3b9005e,0x7ae40655}},	//   _araf_, lāmi, _алеї_, zvit
  { {0xa4fa00b4,0x2ee90026,0x7ae400f2,0xb4fa000a}},	//   _בלעט, _braf_, yvit, _בפעי
  { {0x636b01e2,0xc7d60008,0x7d0100c0,0x60320024}},	//   _dönü, בורי_, älsn, nāmi
  { {0x91fc03eb,0x6d400064,0x62890656,0x6b8d0049}},	//   rmāc, şmam, mpeo, ebag
  { {0x3b960657,0x8b960658,0x6da3006b,0x2ee90546}},	//   ијат, ирач, юира, _eraf_
  { {0xe8e00023,0x6b8d0035,0xba760029,0x3911004c}},	//   _hiệp_, gbag, لائت, _סטאַנ
  { {0xba260033,0x6032003d,0xa3d6000b,0x6da60659}},	// [700] адак, jāmi, ाजत_, _кипа
  { {0xac760086,0x5e9b0008,0x7ae4065a,0x0e9b000a}},	//   _پادش, _שביק, rvit, _ששיל
  { {0xa3b6014e,0x636b0064,0x6b8d065b,0xdb0d0264}},	//   _जाल_, _yönü, bbag, čkác
  { {0xdb2000dc,0xbc7b0008,0x929d005c,0xf8a90018}},	//   ítóg, _שנכת, szły, ادله_
  { {0x6aad065c,0xdcfc0091,0x3946002a,0x2c7c0030}},	//   craf, tarė, łos_, _híd_
  { {0x4426065d,0x7aeb0134,0xceb30008,0xe4a60076}},	//   _smo_, ægte, קיו_, арио
  { {0xd497065e,0x44260020,0xdcfe003d,0xa3ba00c3}},	//   ары_, _pmo_, _iepē, ناظر_
  { {0x7c360026,0xa686065f,0xb7da0015,0xf2c60660}},	//   nnyr, _влад, _جورا_, асон
  { {0xd4670054,0xcb36004f,0x76d30058,0xf74a02be}},	//   шиће_, יאֵי_, _ويفض, _شجره_
  { {0xdb0d002e,0x82330015,0x69c80061,0xafdb00cb}},	//   ngaá, ْرَا, _öded, eløp
  { {0x9f91002e,0xe3ba0661,0xe8e00016,0x8027012c}},	//   _búðu_, _абе_, _diệp_, لرحم
  { {0x10730010,0x2ee90045,0xaffd005e,0x20730033}},	//   ўляю, _praf_, хомi, ўляў
  { {0x2bba000b,0x2475003d,0xd6220138,0x0000006a}},	//   इलना, _rāmi_, _лiда,
  { {0xf0b7002b,0x7126002b,0xd24f005e,0x6f1d0662}},	//   دایش_, _پرتل, _єц_, rzsc
  { {0xac19017c,0x61fc0123,0xdde10030,0xd01b0663}},	//   гову_, örlu, ítői, _афп_
  { {0xb0680010,0xa3b6000b,0x2ee90664,0x8fa40054}},	//   _крыж_, जलि_, _traf_, _даће
  { {0x6b8d0665,0xf9930029,0xda780666,0xbb840015}},	// [710] rbag, قبض_, аях_, تلقي
  { {0xd999003b,0xa3c8000b,0xe9990015,0x6272002a}},	//   انات_, _लॉस_, اناغ_, _złoc
  { {0x6aad0064,0xf0930053,0x29070011,0xa3d6000b}},	//   sraf, ַנס_, âna_, ाजा_
  { {0x6aad0667,0x6032003d,0xd7590015,0x9cd6000a}},	//   praf, tāmi, هلات_, _פורה_
  { {0x7c2d0668,0x929d002a,0xa6c902ed,0x0000006a}},	//   miar, ryłk, улла_,
  { {0x929d005c,0x5a440033,0xea76000a,0x7c2d0669}},	//   syłk, _дэса, _לגשר_, liar
  { {0x361a002b,0x6032003d,0x5884066a,0x0000006a}},	//   درنگ_, sāmi, _мыта,
  { {0xf77f01e2,0xa9540036,0xad3800a3,0xc2c50015}},	//   _üç_, _єкті, ינוס_, ميبي
  { {0xa3d6005d,0xa7150001,0x26cd003f,0x97150033}},	//   ाज़_, _удаљ, _upeo_, _умац
  { {0xe61300b0,0x7c2d066b,0x03220033,0xe1f905a7}},	//   _بشر_, hiar, ядын, уго_
  { {0xd24e0086,0x6272002a,0xb636004c,0xafdb00cb}},	//   رچه_, _płoc, _פרעס_, tløp
  { {0x9f06003b,0x6d400064,0x60060077,0x629d0030}},	//   موجو, şmak, _cómp, ásos
  { {0x201e00df,0x5285003b,0x91e5066c,0xc1780007}},	//   ėti_, _التك, _голе, odėl_
  { {0xe29f0084,0x6272005c,0x442d066d,0x644903f8}},	//   áðu_, _włoc, lie_, loei
  { {0x0c790080,0x7c2d066e,0xf652000a,0x6272002a}},	//   исты_, fiar, פצל_, _tłoc
  { {0x442d066f,0x2c7c0046,0x01340067,0x7c2d0670}},	//   nie_, _víd_, _بعهد, giar
  { {0xc27a0053,0x63a60671,0x627a004c,0x4c350033}},	// [720] ָרעי, ókni, ָנענ, цэрт
  { {0xb95a0015,0x69c10030,0x442d0672,0xceb3004f}},	//   هجاء_, _ölel, hie_, _זיז_
  { {0xf8aa0001,0xcb09000f,0x442d0673,0xe7860674}},	//   увек_, על_, kie_, було
  { {0x442d0675,0xdcfc003d,0x7c2d0676,0x0000006a}},	//   jie_, harī, ciar,
  { {0xdcfc0048,0xf62a0036,0xf7460080,0x3ea20677}},	//   karī, ліки_, щедо, nskt_
  { {0x442d0020,0x9e7b0053,0x96330033,0x27e00678}},	//   eie_, אנספ, пніц, žin_
  { {0xdcfc0048,0x485a0010,0x54e60015,0x344a0004}},	//   darī, _браў_, إستق, лчин_
  { {0xccf3000a,0x442d0679,0x4c9b000a,0x3cc9000a}},	//   לכו_, gie_, אבקו, ׁלוּ_
  { {0x386600c0,0x6032003d,0xe73a067a,0x41e600e2}},	//   mmor_, nāmu, _сеа_, біна
  { {0x7c2d04ed,0x442d067b,0x867b000a,0xdcf5002a}},	//   ziar, aie_, _ערבו, lczą
  { {0xf9930008,0xdcf5005c,0x442d067c,0xa158067d}},	//   הרת_, oczą, bie_, рану_
  { {0x3957013a,0xa93b0053,0x442d067e,0xb0a9000b}},	//   משים_, רײטי, cie_, _किरग
  { {0x7c2d067f,0xdcf50535,0x0000006a,0x0000006a}},	//   viar, iczą,   ,
  { {0x633b0053,0xdb0d016e,0x7c2d002a,0x211a0015}},	//   _געדױ, lgaç, wiar, _متعب_
  { {0x0ba70010,0x6c850015,0xe0860015,0x6a690091}},	//   йшам, تلزم, _اجتي, _užfi
  { {0x388100df,0x0000006a,0x0000006a,0x0000006a}},	//   _nėra_,   ,   ,
  { {0xda6700c3,0xdb0d016e,0x99990680,0xb9990681}},	// [730] مائي, igaç, икат_, ивах_
  { {0x6fb50074,0xff180008,0x127b0053,0xdd910015}},	//   _امکا, _לקחת_, טאמע, _تود_
  { {0x7c2d0682,0x6d8c000a,0x75e90030,0x58d9009b}},	//   piar, _עָזְ, nöző, рдея_
  { {0xc1c4005d,0x442d010c,0x69d8006f,0x2a7901c2}},	//   वभुग, xie_, ôver, _tusb_
  { {0xb9e7005e,0x442d0683,0xb6c7004a,0xc9870684}},	//   _ліви, vie_, ссей, _губи
  { {0xd9fd005d,0x442d0685,0x2d83005c,0x853c0007}},	//   _उचित_, wie_, ncje_, _idėj
  { {0xf6500086,0x442d0686,0x16380015,0xdcfc003d}},	//   رئه_, tie_, حسنة_, varī
  { {0x24090080,0x1d180008,0xbd18000a,0xd2a9004a}},	//   рнии_, מקור_, מחוז_, акие_
  { {0x2d83005c,0x13060080,0x764a003f,0x03250036}},	//   kcje_, жный_, bofy, юдин
  { {0xaadc0053,0x442d0687,0x764a002a,0x69d70688}},	//   רחזר, sie_, cofy, nexe
  { {0x7bd6003f,0xdbc6007c,0x442d0689,0x89ec004f}},	//   yeyu, mööd, pie_, רַחֵ
  { {0xa3b6014e,0x6286006f,0xe29f001a,0x3ea202dc}},	//   _जाए_, íkoc, áðs_, tskt_
  { {0x2d9a000c,0xb7da0008,0x6d580046,0x7f19005e}},	//   _pepe_, בקרי, _úvaz, біру_
  { {0xf2670054,0x667a004c,0xdcf5002a,0xc5f9000a}},	//   _уђем, יטשק, zczą, ׁפָט
  { {0xd24e003b,0xc5f20008,0xdcf5005c,0x69d7068a}},	//   _جنو_, ודם_, yczą, dexe
  { {0x6ab6002e,0x3ea2001a,0x63bb068b,0x6e2e0030}},	//   tuyf, pskt_, ngun, sibb
  { {0x8d760087,0xa3ab000b,0x2d9a068c,0xfaaa002b}},	// [740] _وادا, कृय_, _tepe_, شهاي_
  { {0x38660034,0xdb0d001a,0x63bb0049,0x200202d8}},	//   wmor_, rfað, hgun, ljki_
  { {0x69d9005d,0x39350010,0x61e3068d,0x0000006a}},	//   नज़ी, пэцс, _manl,
  { {0xb8f2014e,0x46ea068e,0x6d5e0192,0x8bb60015}},	//   _वह_, иден_, _izpa, _بإدا
  { {0x4e0e005d,0x8703004a,0x66da004a,0x3860003d}},	//   _हवाई_, дяще, рьер_, ķir_
  { {0xa3cc000b,0xb0a9000b,0x5ee9000a,0xcb13000a}},	//   श्न_, _किंग, מַצְ, _חלש_
  { {0x9f450089,0x6272002a,0x38810091,0x08c302d9}},	//   ělé_, _błon, _tėra_, _обрн
  { {0x61e30234,0x63bb0509,0x2c17004c,0x799c068f}},	//   _aanl, ggun, ַקיש_, _herw
  { {0xe8530086,0x75d60002,0x6272002a,0x2d83002a}},	//   _آنقد, _ويرا, _dłon, ycje_
  { {0x32180050,0x61e30690,0xd25a0180,0x27e402ce}},	//   óry_, _canl, јци_, _hamn_
  { {0xb97b0008,0xd499005e,0xe97b004c,0x27e60577}},	//   יניי, _грі_, יניש, odon_
  { {0x68e30134,0x69ca005d,0x27e60691,0x661d0091}},	//   ændi, स्ती, ndon_, _įski
  { {0xee3f0089,0xc2c40015,0x91780016,0x69ce0692}},	//   krýt_, _ريغي, hởi_, _obbe
  { {0xd3440074,0x61e30176,0x2e4b02c8,0x799c002a}},	//   _ویژه_, _ganl, рямо_, _nerw
  { {0x2d83002a,0x2cb80693,0xbc0702ed,0x660801d0}},	//   rcje_, gurd_, очай, _modk
  { {0x27e60694,0x6aa4003f,0x27e402ce,0x61e30061}},	//   jdon_, fsif, _namn_, _zanl
  { {0xa3cc005d,0x9b6b0063,0x61e30064,0x2d83005c}},	// [750] श्य_, ршва_, _yanl, pcje_
  { {0x3eb90020,0xdb040695,0xfe730015,0x27e60696}},	//   must_, egió, _تدع_, edon_
  { {0x3eb90005,0xb86b000d,0x4dda000a,0x25fe000b}},	//   lust_, ајде_, _החתו, लानी_
  { {0x69ce0697,0xc157000a,0x63a00085,0xaa7b001a}},	//   _ebbe, חשבו_, jamn, _brýt
  { {0xf770003b,0x3eb90020,0xdbc60020,0xd7c8002b}},	//   ناه_, nust_, tööd, تونه_
  { {0x6272005c,0xd5b10015,0x8a7a000a,0x6604005e}},	//   _słon, رفع_, _לאשת, мпіа
  { {0x1c0f014e,0x79850026,0xcd980008,0x3eb9007c}},	//   _सवाल_, mchw, חדות_, hust_
  { {0xd7c90074,0x3eb90698,0x6d3c0008,0x63bb00b8}},	//   _دوره_, kust_, יתונ, ugun
  { {0x61e30035,0x97150033,0xf2c50015,0x3eb90699}},	//   _panl, _эмац, أْخُ, just_
  { {0x3eb9069a,0x321e069b,0x2ea8000b,0x35b40342}},	//   dust_, ghty_, _कटौत, _обур
  { {0x61e3069c,0xf5590015,0xa3bb0115,0x79850012}},	//   _vanl, _الاب_, _ناشر_, ichw
  { {0xd3b80036,0x54370086,0x3dd80034,0xb4e7000b}},	//   _душі_, _برطر, werw_, यटी_
  { {0xdbd90084,0x2f560142,0x237600a2,0xe803000b}},	//   væðu, ятос, _عمود_, _रचना_
  { {0x32130016,0x4df50033,0xb5fd0091,0x1d0a004a}},	//   _ôxy_, мяст, _pušy, беги_
  { {0xdbd9002e,0xed5a069d,0x7aef069e,0x27e6069f}},	//   tæðu, сов_, _arct, ydon_
  { {0x799c06a0,0x6c360029,0xa09a015b,0x3eb906a1}},	//   _serw, أفرا, _פיפט, bust_
  { {0xdbd9002e,0x799c013c,0x25fe000b,0x5fbb000a}},	// [760] ræðu, _perw, लामी_, _הצפנ
  { {0xa3ab014e,0x19b90010,0x6aa406a2,0x2cb80012}},	//   कृत_, жуць_, rsif, purd_
  { {0xa3cc000b,0x6d7b000a,0x7d7b000a,0x48b6006b}},	//   श्ड_, _לאיח, _לניו, ящат
  { {0xdcf5005c,0x799c00dd,0x798506a3,0x6b9d0034}},	//   jczę, _werw, achw, _gesg
  { {0x799c06a4,0x6f7b000a,0x1779005e,0x27e606a5}},	//   _terw, צְאו, ісць_, rdon_
  { {0x26c600f2,0xd6220033,0x69ce0079,0xd49a06a6}},	//   rtoo_, _кiна, _ubbe, бри_
  { {0x628b0026,0x80da000b,0xa5070054,0x25fe000b}},	//   _atgo, _बनें, зеја_, लाबी_
  { {0xb6030048,0x493b000a,0xb4ac000b,0xa2d3000b}},	//   īšan, _הגלו, _कटी_, _बैङ्
  { {0x27f70107,0x1867005e,0xb603003d,0xf2c30033}},	//   šení_, _хати_, ūšan, нсэн
  { {0x3eb90005,0x63a006a7,0xe8e00016,0xdcf5002a}},	//   vust_, samn, _nhịp_, aczę
  { {0x3eb906a8,0x63a00030,0x41af0065,0x69c10065}},	//   wust_, pamn, _फ़ारस, र्टी
  { {0x3eb90005,0x9f350036,0x8fa400d7,0x34fb000a}},	//   tust_, демі, наџе, _להבד
  { {0x79850026,0x6b9d06a9,0xb4ac000b,0x0000006a}},	//   ychw, _resg, _कटु_,
  { {0x7e280033,0x3eb906aa,0xacf906ab,0x20d60058}},	//   піса_, rust_, онгу_, _فتعج
  { {0x3eb90020,0x61f80161,0xb2290015,0xd657000a}},	//   sust_, _invl, _بأنك_, פילת_
  { {0x5c7406ac,0xb1570008,0x31570008,0x9f050015}},	//   елст, _מסוג_, _מיון_, _يوغو
  { {0x8e840015,0x600c000a,0x7cf6001a,0xdce70061}},	// [770] _كليه, _לִזְ, týrð, rajı
  { {0xdce70064,0xdcf5005c,0xf1cf000b,0xa3cc000b}},	//   sajı, zczę, त्पन, श्त_
  { {0xdb0d002e,0x798506ad,0x6d88000a,0x91fc003d}},	//   ngaú, rchw, _מָרְ, emāk
  { {0x7985018b,0x69c80064,0xe719006e,0x48150033}},	//   schw, _öden, ييات_, ьмес
  { {0xf7730015,0x79850034,0xe6880058,0x0000006a}},	//   راص_, pchw, كننى_,
  { {0x8afa0008,0x7aed0546,0x0000006a,0x0000006a}},	//   _והשי, mvat,   ,
  { {0x7bcd003f,0xa506006b,0x7aed06ae,0x999a0030}},	//   ofau, деща_, lvat, cipő_
  { {0xfcaa00b4,0x3ea9022d,0x61e80026,0x657a00aa}},	//   קיפּ, _ovat_, eddl, _egth
  { {0x69ca005d,0x37c40015,0x7aed06af,0x66120030}},	//   स्वी, _سيلف, nvat, ükkö
  { {0x7aed00dc,0x80a9004a,0x063b00c3,0xa22900fd}},	//   ivat, овов_, _اسرع_, іжна_
  { {0x7aed06b0,0x34940063,0xa3c8000b,0x4420005e}},	//   hvat, _захр, _लॉक_, _зi_
  { {0x7aed06b1,0xa29500ce,0x0000006a,0x0000006a}},	//   kvat, _жаді,   ,
  { {0x6d490011,0xd4340015,0x5f7600c3,0x6272002a}},	//   şeal, _ثعلب, بادر, _złom
  { {0x7a200014,0x7aed060a,0x59cf000b,0x32450058}},	//   _köte, dvat, स्मर, _تنتف
  { {0xc0a80086,0x7aed06b2,0x602606b3,0x25fe000b}},	//   _فايل_, evat, _одка, लाती_
  { {0xa09a0008,0x8fa60086,0x7a2000c0,0xb09a039e}},	//   _ויקט, _کمکه, _möte, _ויקר
  { {0x0b170029,0x2eff00b8,0x6d450390,0x7aed025d}},	// [780] وقفة_, äuft_, _exha, gvat
  { {0xe9d706b4,0x9f9d001a,0x4a4306b5,0xed5a00ce}},	//   мку_, læði_, внув, _моп_
  { {0x49990036,0xd7e60036,0x8dfb000a,0x18a3006b}},	//   яття_, діло, _והית, вахм
  { {0x6d4001e2,0x9f4006b6,0xc7af0015,0x2ef200aa}},	//   şmas, _unió_, لّم_, _kryf_
  { {0xc7a303f1,0xa5f80010,0xa3c8005d,0x61e80026}},	//   тичк, зелу_, _लॉग_, yddl
  { {0x6272002a,0xe1cf000b,0x3eaf02de,0xd90d002b}},	//   _płom, त्मघ, _ægte_, _گیم_
  { {0xa5c4000b,0x68e3063b,0x442f06b7,0x0000006a}},	//   _राठौ, ændt, _bmg_,
  { {0xd4670001,0x690b0008,0xd90d002b,0x6b9606b8}},	//   мије_, _וּמְ, _دیم_, nbyg
  { {0x94020086,0xc2740054,0x86c6002b,0xd40306b9}},	//   فوژه, нлиј, _زيان, тящи
  { {0xf8d2014e,0x8afb0053,0xe4d60015,0xdb1506ba}},	//   _सहाय, קהיי, _يتاب, ébéc
  { {0xd130003b,0xe8df0092,0x9f450089,0x7aed044c}},	//   امج_, _buộc_, ělí_, zvat
  { {0xe8df0023,0x7aed0057,0x2497002b,0xeb9f00cb}},	//   _cuộc_, yvat, _آنند_, _fløy_
  { {0xd6d90050,0x2ef20026,0x6b9606bb,0x98b80073}},	//   _były_, _cryf_, dbyg, _tyrė_
  { {0xe7310008,0x6ab600dd,0x2ef200aa,0x3e64008c}},	//   אֵל_, dryf, _dryf_, yöte_
  { {0x1bd50063,0xfe240080,0x645c0024,0xc1bb000a}},	//   новя, тьян, _īrij, _ומוש
  { {0xec680036,0xa08b000a,0x2019003d,0x6b9606bc}},	//   друк_, _וְזִ, īris_, gbyg
  { {0x2ef206bd,0xc054000a,0xcb34006b,0xeaf80015}},	// [790] _gryf_, _בזק_, ветъ, وركت_
  { {0xe9d30029,0xc95b0010,0x9e67002b,0xdcfc0045}},	//   ضغط_, оўе_, _تابن, ucră
  { {0x7aed0607,0x5884054f,0x5c750666,0x2019008c}},	//   svat, выча, _плот, oksi_
  { {0x201900e8,0xad26002b,0x0137000a,0xe894005e}},	//   nksi_, _سرپو, ורבת_, таць
  { {0x201900f2,0xfbb6000a,0x59c7000b,0x76c40015}},	//   iksi_, _אפרת_, _लापर, نغول
  { {0x644200f2,0x06080010,0xff180008,0x56920054}},	//   _ajoi, мнік_, וקדת_, ћајт
  { {0x57b70058,0xbd9c004f,0x0000006a,0x0000006a}},	//   _يحرز, חסות,   ,
  { {0xe7950086,0xc4f80029,0x13090036,0xe7390026}},	//   _سارک, بعها_, зний_, _ddŵr_
  { {0x9f9d0084,0xeb920008,0x7c3a06be,0xc8790061}},	//   væði_, נָה_, étri, _iiş_
  { {0x201900f2,0x7a2000b8,0xcb58000a,0x410506bf}},	//   eksi_, _töte, וסחה_, езов
  { {0x79a8000a,0x2089006b,0xd5a6002b,0x6e3506c0}},	//   וֹרַ, яйни_, _سلنی, dizb
  { {0xcdc9013a,0x59cf000b,0x80a0000b,0x3cf90065}},	//   _לך_, स्तर, _खबरे, _उपजे_
  { {0xef17005f,0x9f9d0084,0x1e83005e,0x443f06c1}},	//   емя_, ræði_, ллям, mnu_
  { {0xc6920135,0x201906c2,0xfce606c3,0x443f06c4}},	//   ראם_, aksi_, ного, lnu_
  { {0xa3cc005d,0x52740086,0x621a00f3,0x443f06c5}},	//   श्व_, _شاهز, _מוסק, onu_
  { {0x443f06c6,0x98ac003d,0xaec60098,0x68e2002a}},	//   nnu_, ūlīt_, _збил, łodk
  { {0xdd2f0089,0xbdfa0087,0x645b008c,0x6c750033}},	// [7a0] _měře, _فردا_, ilui, турх
  { {0x2b9e0092,0x8e970008,0x6b9606c7,0x443f06c8}},	//   ắc_, _רדיו_, sbyg, hnu_
  { {0x69c801e2,0xcd360086,0xf1c2000b,0x2d9806c9}},	//   _ödem, _سردب, _शासन, mbre_
  { {0xad370008,0xc1bd005d,0x96ea017f,0xad1b000a}},	//   _טניס_, ्भुग, зька_, _זוטר
  { {0x68e30134,0x443f06ca,0xc8790061,0x2d9806cb}},	//   ændr, dnu_, _diş_, obre_
  { {0xd49a06cc,0x7f3b000a,0x7c2406cd,0x97130033}},	//   при_, התנג, lhir, ыміц
  { {0x443f06ce,0x24e7000d,0x2019008c,0x1dd2000b}},	//   fnu_, емји_, yksi_, द्यत
  { {0x6b7b0053,0x443f06cf,0x66e606d0,0xb866002b}},	//   ּרינ, gnu_, _поба, _سازو
  { {0xe7d501e2,0x41c60033,0x7c2406d1,0xe3af0015}},	//   lığı, нёна, ihir, حرى_
  { {0xd5e90029,0xe8df0016,0x69de06d2,0x443f06d3}},	//   _يعلن_, _nuớc_, nepe, anu_
  { {0x3a37013a,0x9f40002e,0x94d30029,0xd13a0036}},	//   תרים_, _snið_, _ميلش, яхи_
  { {0x645b06d4,0x443f06d5,0x351b000a,0x69de06d6}},	//   clui, cnu_, _מובנ, hepe
  { {0x4ea70010,0x7c24003f,0xdefb0033,0x6e350012}},	//   эрна, dhir, чын_, tizb
  { {0x127b0053,0xa3cc000b,0x12fb000a,0x7c240405}},	//   _זאגע, श्र_, _מהדב, ehir
  { {0xc0e300d0,0x70f30015,0x5d840015,0x69de06d7}},	//   _бојк, _مسيئ, الفل, depe
  { {0xe7d501e2,0x515b0008,0x8bc402bb,0x7c2406d8}},	//   dığı, _מכוו, лсуд, ghir
  { {0xc87f0064,0x61ea002e,0x2d9806d9,0x4a5506da}},	// [7b0] ışma_, _kafl, bbre_, вкас
  { {0xa93d0010,0xe919005e,0x443f06db,0x69de06dc}},	//   одзi, мозі_, znu_, gepe
  { {0x443f06dd,0x69c2000b,0x59c40015,0xe578003d}},	//   ynu_, _लारी, ايمك, _kaķu_
  { {0xf773002b,0x787a0046,0x63a206de,0x7c2406df}},	//   هاش_, _půva, _neon, chir
  { {0x4424002f,0x91780092,0x7ac70286,0x443f06e0}},	//   dhm_, hời_, _ясне, vnu_
  { {0x3eb9003e,0x69de0011,0xc1780007,0xe6180036}},	//   irst_, cepe, ndės_, нді_
  { {0x443f06e1,0xdb0d002e,0xd7950015,0x9f4c0046}},	//   tnu_, ngaþ, _للأخ, ědé_
  { {0x443f06e2,0xb6f50054,0xd87402be,0x645b005b}},	//   unu_, _избј, _ماقب, ului
  { {0x04560029,0x320e003f,0x645b06e3,0xe2910015}},	//   خلية_, _bofy_, rlui, جذب_
  { {0xd24e06e4,0x645b049c,0x443f06e5,0x44240012}},	//   يني_, slui, snu_, ahm_
  { {0x443f06e6,0x61ea0034,0x59c6000b,0x65190015}},	//   pnu_, _dafl, र्टर, _تقاس_
  { {0x69de06e7,0xc952015b,0x6272002a,0x7a200123}},	//   zepe, שמט_, _ołow, _möta
  { {0x69c7016f,0x0ef90010,0xdb060264,0x44e30030}},	//   _ocje, нэры_, _odká, _hű_
  { {0xdd920087,0xc332039e,0xc58e0016,0xdee30099}},	//   شور_, _דוד_, hồng_, јори
  { {0x6da30124,0x27310092,0xa00a0029,0x7c2406e8}},	//   риса, ạnh_, _يقتل_, thir
  { {0x8c43000d,0x60d60008,0x69d50012,0xc1780091}},	//   аесе, _יוצא_, _abze, adės_
  { {0xf9920115,0xaf4a0015,0xd5e1000b,0x7c2406e9}},	// [7c0] لبا_, _تشغل_, फ़ाज, rhir
  { {0x59760086,0xba230010,0xceb90089,0xe7d50064}},	//   نداز, адук, áře_, tığı
  { {0x7bdf001c,0x07a60010,0x291c0264,0x69de06ea}},	//   bequ, ваен, áva_, repe
  { {0xe73a06eb,0xca29000a,0x69de06ec,0x0000006a}},	//   мее_, חם_, sepe,
  { {0xa6fa0029,0x6272005c,0x91780016,0x7c3a0003}},	//   بعاء_, _głow, iới_, étru
  { {0xceb30008,0x4a750080,0x63a20020,0xb8960015}},	//   שיג_, _быст, _seon, _للسع
  { {0x04c70029,0xa491002b,0x7a200123,0xf79a0015}},	//   نووي_, میلت, _göta, _ينسب_
  { {0x61ea0176,0x94230001,0xa7850015,0x3eb9001a}},	//   _safl, имје, _مشكو, yrst_
  { {0x7c2304f9,0x59cf005d,0x3254067a,0xa6ca012c}},	//   _înre, स्वर, лвир, _زوال_
  { {0x6625002a,0xd5af00c3,0x05c9000b,0x3f80016e}},	//   ątkó, _وفق_, _रायब, _agiu_
  { {0x859b011f,0x850603c4,0x9f4e0227,0x3ea002f2}},	//   _חשבו, _جوان, čným_, _awit_
  { {0xc953013a,0x94a90029,0xdcea0046,0x7ae406ed}},	//   ימת_, _أطلق_, šněj, kwit
  { {0x61ea06ee,0x3eb9044d,0xf38f0016,0xd5c90065}},	//   _tafl, urst_, oảng_, _रामज
  { {0x6e940080,0xf773011f,0x7bc406ef,0x82d7000a}},	//   риру, יקר_, egiu, _סווג_
  { {0x62720050,0xfb87008f,0xc1030029,0x1dd2005d}},	//   _słow, вызн, _نووي, द्धत
  { {0xd10f014e,0x5fa7014e,0x7bc402d7,0xa1770008}},	//   ाहरण_, _ख़िल, ggiu, _בעוד_
  { {0xc3340008,0xda670015,0x7bdf06f0,0x49cb055f}},	// [7d0] אוּ_, نائي, requ, дуем_
  { {0xf7f40086,0x4d990127,0x2ee906f1,0x200b06f2}},	//   یسند, _якою_, _isaf_, ljci_
  { {0x5fa7000b,0x3da40033,0x6d41006f,0xbc8b0015}},	//   _ख़ाल, _трыб, úlad, _تضخم_
  { {0x787a0089,0xd7890087,0xc86406f3,0x9d1a004f}},	//   _důvo, رنتو_, атчи, _נורט
  { {0x1754005e,0xdb0d007c,0xd7e400ce,0xc58e00a1}},	//   авця, ngaü, ріхо, rồng_
  { {0x2636005c,0xc98706f4,0xbb76004f,0x1994058c}},	//   słon_, _шуми, _תעשו_, _варя
  { {0xadd8000a,0x64e80015,0xc9580033,0x7a200030}},	//   דווח_, َّهِ_, _аўт_, _kötn
  { {0x32cb06f5,0xd46602c8,0x1be3000b,0x7d7c000a}},	//   tøy_, лище_, ख़िल_, ונוו
  { {0x659506f6,0x27ff008c,0xdb040030,0x923906f7}},	//   _базу, _inun_, taié, ечну_
  { {0x2d810023,0xc5fb00a2,0x95d8004a,0x6d5a007c}},	//   _nghe_, _تعرض_, _идут_, ütak
  { {0xe4cb0074,0x69c506f8,0x64c40015,0x7bc40091}},	//   _زبان_, ighe, _نيلل, ygiu
  { {0xf3f00029,0x25a506f9,0x91fc003d,0xdb040030}},	//   _وأن_, _hell_, elād, saié
  { {0x27ed0176,0x25a506fa,0x2fdf0020,0xdcee0061}},	//   _maen_, _kell_, õuga_, vabı
  { {0x02450015,0x63a906fb,0xf1c60046,0x3d28002b}},	//   _حَتَ, laen, žáru_, نتزی_
  { {0x91fc0048,0xdcee0064,0x27ff0064,0x61e106fc}},	//   rmāt, tabı, _onun_, mell
  { {0x61e1022d,0x75160053,0x63a906fd,0x40920015}},	//   lell, אַמע_, naen, _الير
  { {0xab6606fe,0xcaa50015,0x4a4606ff,0xab270148}},	// [7e0] увал, لصلي, гнав, гота_
  { {0x25a502d7,0xdcee01e2,0x787a0089,0xef1f0064}},	//   _nell_, sabı, _půvo, zcük_
  { {0x32360053,0x60c10700,0x63a90701,0x27ed0702}},	//   נטען_, nulm, kaen, _baen_
  { {0x63a9003f,0x7e7e010c,0x76430703,0x385a012c}},	//   jaen, _hipp, enny, رشاد_
  { {0x61e10704,0xf6d30015,0x8f9b000a,0x25a50116}},	//   kell, مزود, גיני, _bell_
  { {0xf38f0023,0x25a50705,0x60c10706,0x4add000b}},	//   uảng_, _cell_, kulm, _नैटव
  { {0x83fd00dc,0xda5b0008,0x25a5052a,0x61e10707}},	//   klőd, _נכלל, _dell_, dell
  { {0x44220014,0x61e100f2,0x83fd00dc,0x76430049}},	//   ók_, eell, jlőd, anny
  { {0xe3af0029,0x25a50708,0x57460709,0xe64a006b}},	//   سري_, _fell_, _снаб, _зпад_
  { {0xf1c60089,0x20000011,0x2fc9002d,0x61e1070a}},	//   _část_, _anii_, _scag_, gell
  { {0x31780012,0xdb0602de,0x73c60040,0x63a9070b}},	//   ärz_, _udkæ, _ميام, baen
  { {0x0eeb0080,0xd259003d,0x82a6070c,0x25a502ad}},	//   ньги_, ruņa_, _бадж, _zell_
  { {0xe296000d,0x6fc6000b,0x33170015,0x6272002a}},	//   _среќ, _वारं, _مزود_, _błot
  { {0x6d5e04a9,0x61e1070d,0x50d3002b,0xc0aa0015}},	//   _bypa, cell, جزیر, _كابل_
  { {0xec6b070e,0x7e7e00da,0x91fc003d,0x224b006f}},	//   ерак_, _dipp, rlād, écke_
  { {0x60df0030,0xdb060123,0x9b950195,0x5d7802bb}},	//   őzmé, _odkä, риац, уйся_
  { {0x91fc0024,0xdfd8006b,0xdefb0033,0x5a35070f}},	// [7f0] plād, _същ_, _чый_, анат
  { {0x321e005c,0x633b004c,0xc7b90030,0x69c50710}},	//   nkty_, געמױ, _elől_, ughe
  { {0xae5c000a,0x9e7a000a,0xf9900015,0x69c50711}},	//   _אכזר, _שנתפ, سبل_, rghe
  { {0x62720712,0x765a0713,0x25a5003e,0x4c9a000a}},	//   _złot, _akty, _sell_, _שברו
  { {0x65640089,0x8f9c000a,0x61e10618,0x63a9014b}},	//   řihl, תידי, yell, vaen
  { {0xf77004c9,0x60c10064,0x2aba000a,0x3aba000a}},	//   سان_, yulm, _במשא, _במשנ
  { {0xe8940010,0x25a50714,0x61e10715,0x63a90716}},	//   _гась, _vell_, vell, taen
  { {0x25a50495,0x321e002a,0x5d7c004c,0x27ff0061}},	//   _well_, ekty_, ערהײ, _unun_
  { {0x7412003b,0xcb1200b2,0x25a5003e,0x52a602bf}},	//   تويا, ַלט_, _tell_, авым_
  { {0x60c10717,0xe9c90033,0xdb0d0077,0xe4a703ae}},	//   tulm, евiч_, ngañ, _брдо
  { {0xc5fa0053,0xb5fa0053,0x35470010,0x69ca000b}},	//   _שפעט, _שלעכ, _схав, स्टी
  { {0x60c101e2,0x1603005d,0x43750718,0xb4670067}},	//   rulm, लावर_, _култ, _صداه
  { {0x20550010,0x83fd00dc,0xa856000a,0x61e10220}},	//   стэр, rlőd, שירה_, pell
  { {0x5332000d,0x437200e6,0x6da30719,0x387f01c2}},	//   _фељт, _ظهور, жира, _liur_
  { {0xed5a071a,0x62860227,0xc0a90067,0xfce6005e}},	//   тов_, íkov, _شاغل_, шово
  { {0x6d5e0107,0x83fd0030,0x2000071b,0x70530015}},	//   _vypa, llőb, _unii_, _ونوا

  { {0x6272005c,0x6d5e005c,0xdcfc0024,0x7e7e071c}},	// [800] _głos, _wypa, obrī, _tipp
  { {0x1daa014e,0x3c3f00f2,0x6d41002d,0x4efb000a}},	//   _क़ित, tävä_, úlac, _יהפו
  { {0x5dbb000a,0x6fd3000b,0xd7ef0296,0x7786071d}},	//   _בזיה, ध्वं, оу_, алез
  { {0x386d071e,0xa7850015,0xd90d002b,0x7d1c008c}},	//   _cher_, مشهو, ریق_, myrs
  { {0xc6a3006d,0x66f4071f,0xa6c700af,0x26360535}},	//   орщи, сплу, илца_, słom_
  { {0x386d00b8,0x68fa0030,0xc8960099,0x963301f3}},	//   _eher_, _átdo, _врањ, оніц
  { {0x75890036,0x95080015,0xc918000a,0x29070123}},	//   усів_, اقعك_, _גֵּר, änat_
  { {0x6a6b00b8,0x6e3c0720,0x68e2002a,0xd3d70015}},	//   rüfe, hirb, łods, لبًا_
  { {0xf5ea0254,0x92940054,0x5433002b,0x3373006b}},	//   _имал_, љаоц, ترور, огър
  { {0xd4d6008f,0xb066008c,0x51f7004a,0x0000006a}},	//   _відэ, yvää, анью_,
  { {0xdcb10092,0x74160086,0x6e3c0721,0x20c3005e}},	//   ởi_, _پوشا, dirb, осяг
  { {0x6e3c002d,0x853b000a,0xcfab0015,0x74130015}},	//   eirb, _בגבי, خادم_, _وولا
  { {0x3294003b,0x22940722,0xfe7300a2,0x44260141}},	//   _التأ, _التس, قدس_, _ilo_
  { {0x12fb000a,0x91e3004a,0xf1a3006b,0x7658006f}},	//   _שהגב, _моче, _дрън, novy
  { {0x6272005c,0xda05005d,0x2ba703f1,0x442606c2}},	//   _włos, रासत_, ијав, _klo_
  { {0x717b013a,0x417b0008,0x5bb80080,0xd0080001}},	//   _בנוס, _בנוב, ился_, _веће_
  { {0xb0660020,0xe9870001,0xaed50001,0xab280004}},	// [810] svää, аћен, _уопш, аоѓа_
  { {0x7ac40121,0x387f01d7,0x7d1c0723,0x0000006a}},	//   юссе, _siur_, byrs,
  { {0xda7803ad,0xa3d6000b,0x4ddc000a,0x4f58002b}},	//   рят_, िभा_, _יחזו, _مجید_
  { {0xe8df00a7,0xfd56000a,0x3858005e,0x6d490045}},	//   _quốc_, _לשתי_, арію_, şeas
  { {0xd6390033,0x8b03002a,0x87040015,0x8b6700c3}},	//   лякі_, łębs, قبول, _خادم
  { {0xcb12000a,0x2d91002a,0xd1260015,0xe5a20724}},	//   _צלם_, ncze_, _فم_, пиши
  { {0x29070123,0x386d00da,0xe4c800c3,0xe8df00a1}},	//   ånad_, _ther_, لبين_, _tuốc_
  { {0xd4e40036,0x43690725,0x44260726,0x5fc60065}},	//   юючи, лайн_, _clo_, _वाइल
  { {0x32d00092,0xdcfc003d,0xd8380033,0x0000006a}},	//   gày_, tbrī, _тэр_,
  { {0x32d40033,0xe2440015,0x69c80727,0x7658006f}},	//   іцыс, ْخَي, _ödet, covy
  { {0x6d400064,0x2d91002a,0x786a0069,0x34940138}},	//   şmaz, dcze_, lýva, _дахр
  { {0x44260728,0x6e3c0012,0x33f40015,0x2d91002a}},	//   _glo_, wirb, _وسنس, ecze_
  { {0x2bcb005d,0xf412000a,0x9dba0033,0xcf3a008b}},	//   िलना, _מפא_, лыву_, учні_
  { {0x51950029,0x2374002c,0xe29c004c,0x44260729}},	//   _الغذ, ňajú_, _ישׂר, _zlo_
  { {0x1d190191,0x82340225,0x50db005d,0x6e3c001a}},	//   ають_, _برنا, _बहिष, rirb
  { {0x711a0008,0x6096002b,0x20d10030,0xd116000a}},	//   _תוקפ, _انيس_, mái_, _לקצה_
  { {0xc0530008,0x629b00f2,0x3b07017a,0x6272002a}},	// [820] _מזה_, npuo, бето_, _kłop
  { {0x7dea0080,0xdb0d001a,0xf9c4009a,0x0000006a}},	//   _смог_, rgað, تحری,
  { {0xd23a0053,0x7cd60015,0x8c26002b,0x20d10030}},	//   נגעל, _اتخذ, _هفده, nái_
  { {0xdb0600dc,0xa2aa005d,0xf0b60053,0xa9670063}},	//   _leké, _फ़िल्, מלער_, щиха_
  { {0x20d10092,0x29070123,0x83fd0030,0x628f072a}},	//   hái_, änar_, zlőc, ícol
  { {0x442600cb,0x20d10030,0xa5f803ea,0xdb06006f}},	//   _slo_, kái_, реку_, _odkú
  { {0xd4970010,0x6f1d005c,0x8898000a,0xd5b9005e}},	//   бры_, zysc, _כֹּה, рсі_
  { {0x94180080,0x2d91005c,0x786a01b2,0x53e60033}},	//   ржит_, zcze_, býva, сцка
  { {0x59cf005d,0x5b3b004c,0x6a700123,0x7a200123}},	//   स्कर, ָגיק, räff, _nötk
  { {0x6d4001e2,0xf238000d,0xa697000a,0xeab1000a}},	//   şmay, рпош_, _לכמה_, וֹט_
  { {0xc0aa0029,0x69dc002d,0x09f7000a,0x4a5b000a}},	//   داخل_, _mbre, זמים_, רדיו
  { {0x43860029,0x44200092,0x2d91005c,0x28c9000b}},	//   _الإق, _ôi_, wcze_, ांति
  { {0x316b002a,0xa857000a,0x69dc072b,0x3c270072}},	//   ęcza_, מיטה_, _obre, _nõva_
  { {0x2ceb0033,0x44f80016,0x27e6072c,0xd250009a}},	//   льбо_, _kĩ_, heon_, _تنت_
  { {0xb425005c,0x786a0264,0x80a40015,0x2d91002a}},	//   łżeń, zýva, _بمعن, rcze_
  { {0xd0110015,0x44f80016,0x01630015,0x69dc0676}},	//   _آلة_, _mĩ_, _عُيَ, _abre
  { {0x7b67072d,0x27e6072e,0x7a20072f,0x7de702a3}},	// [830] стве, deon_, _köth, _лінд
  { {0x3da702ed,0x0000006a,0x0000006a,0x0000006a}},	//   _уриб,   ,   ,
  { {0xdd920086,0xf96b0033,0x44f80016,0xa8cb006e}},	//   _توپ_, урай_, _nĩ_, طباق_
  { {0x7aee00f2,0x7c670225,0xdc88000a,0x27e60730}},	//   äntä, _داخل, _לְשָ, geon_
  { {0x95850731,0x7c2d0732,0xdcf50061,0xad8b004f}},	//   олле, mhar, mazı, ְנֵ֥
  { {0xc1b7000b,0x7c2d0733,0x7a200012,0x69d8000b}},	//   _आयेग, lhar, _nöth, न्दी
  { {0x44f80023,0xafdb02de,0x25fe000b,0x24090734}},	//   _cĩ_, rnøj, लाजी_, инки_
  { {0x44f80092,0x7afd0735,0x69c80061,0x7c2d0736}},	//   _dĩ_, _krst, _öder, nhar
  { {0xc7b900dc,0x20f70011,0x7bfa000a,0x7bcf0737}},	//   _idő_, _săi_, בִיה, _mccu
  { {0xdcf50064,0xd179005e,0x22560067,0x20d10030}},	//   hazı, исні_, يليد_, tái_
  { {0x7412002b,0x7bcf0738,0x629b0739,0x7c2d073a}},	//   سویا, _occu, spuo, khar
  { {0x629b008c,0x20f70045,0x20d1073b,0x38a70034}},	//   ppuo, _văi_, rái_, iŵr_
  { {0x442d002f,0xdcb10092,0xc7d60008,0x7c2d073c}},	//   mhe_, ẩn_, חורי_, dhar
  { {0x442d001c,0xc6920053,0x443f073d,0x7bcf073e}},	//   lhe_, ואך_, liu_, _accu
  { {0x7afd0020,0x442d073f,0xa06a0740,0x628b0741}},	//   _arst, ohe_, _кака_, _hugo
  { {0x628b003f,0x38a70026,0x442d0742,0x645b0743}},	//   _kugo, dŵr_, nhe_, noui
  { {0xda05005d,0x63ab0744,0x89aa0268,0xcfb7000a}},	// [840] रांत_, _megn, икав_, _ולפי_
  { {0x62830089,0x64490745,0x4ce6006b,0x7c2d00e7}},	//   _jino, hnei, _джоб, ahar
  { {0x7c2d002f,0x443f0007,0x7afd0746,0x1d0a004a}},	//   bhar, kiu_, _erst, _тени_
  { {0x6299005c,0x2f8d000a,0x7c2d02ff,0x645b0003}},	//   _otwo, ְרוּ, char, joui
  { {0x44f80023,0x98ab0024,0x629900dd,0x6684002b}},	//   _sĩ_, āmās_, _ntwo, سیال
  { {0x7c240005,0x35e1000b,0x4efb000a,0xafdb00cb}},	//   lkir, फ़ग़, יהנו, tnøk
  { {0x7a2000b8,0x291c0020,0x443f002c,0x1cba000a}},	//   _nöti, ävad_, fiu_, ׁמַע
  { {0x6283022d,0x44f80092,0x24e50010,0x64490134}},	//   _aino, _vĩ_, яціг, gnei
  { {0x63ab02b9,0xafdb00cb,0x8c1b000a,0x7c240747}},	//   _degn, snøk, שופי, ikir
  { {0x628b0748,0x442d0749,0x3866074a,0x6449074b}},	//   _dugo, ahe_, llor_, anei
  { {0x7233003b,0xf99301e4,0x59cf005d,0x69fb000f}},	//   بريط, ורת_, स्टर, בליק
  { {0xe3b20086,0x63ab074c,0x443f074d,0x63060015}},	//   _آرا_, _gegn, ciu_, _ووال
  { {0xe1ef0074,0xd5b10023,0xc7b30008,0x38660011}},	//   رسی_, _hóa_, ובר_, ilor_
  { {0x22570015,0x6440074e,0x35d2000b,0x7c24074f}},	//   _وجوب_, limi, _साफ़, ekir
  { {0x56370053,0xfe6e002b,0x64400750,0x7c2d0751}},	//   קאלע_, دگي_, oimi, thar
  { {0x59dd005d,0x7c2d0752,0x62830753,0x28c9000b}},	//   न्नर, uhar, _zino, ांसि
  { {0xdceb01e2,0x7c2d0754,0x8d870755,0x5f77009a}},	// [850] ınız, rhar, _мунд, _باغر
  { {0x7c2d000c,0x7afd0198,0x7c2400f2,0x61e80756}},	//   shar, _vrst, akir, nedl
  { {0xab950036,0x7c38002e,0x644900f2,0xf8b10086}},	//   _нині, ðará, ynei, عکس_
  { {0xdce50023,0x443f0251,0x7be50264,0x38660757}},	//   _nghĩ, xiu_, íruč, glor_
  { {0xe8e00092,0x66050758,0x69d8000b,0x443f0759}},	//   _khớp_, зпла, न्ही, viu_
  { {0x63ab02d7,0x61e8010b,0x65650020,0x443f005c}},	//   _segn, jedl, ühho, wiu_
  { {0x442d017e,0x6299005c,0x2bb2005d,0x85780063}},	//   the_, _stwo, _ज़मा, осът_
  { {0x6440075a,0xe3d50015,0x2409004a,0xa026008c}},	//   gimi, ستبع, снии_, isöä
  { {0x63ab075b,0x442d075c,0xe2990001,0x1306004a}},	//   _vegn, rhe_, љао_, зный_
  { {0x442d075d,0xd6280001,0x61e800da,0x7ae00012}},	//   she_, _дође_, gedl, _ämte
  { {0x91fc0024,0x6440075e,0x0ef4000b,0x442d075f}},	//   plān, bimi, इट्स_, phe_
  { {0x64400467,0x628b0035,0x1603005d,0xdee60760}},	//   cimi, _tugo, लाकर_, поми
  { {0x62990050,0xeef50033,0x7c2400cb,0x2bb20065}},	//   _utwo, мярэ, vkir, _ज़बा
  { {0x863500b2,0xe6070067,0xe1f1002b,0x7aed055e}},	//   לאָג_, رش_, _سست_, dwat
  { {0xd5b10023,0xdd8f0029,0x3207005c,0xad250015}},	//   _xóa_, اوف_, _inny_, ورفو
  { {0x7aed003f,0xdddc0227,0x8c46006b,0x7c24005b}},	//   fwat, zorň, чебе, ukir
  { {0x0ae90029,0x6fa2005d,0x443d00dd,0x7c240747}},	// [860] يركي_, _क्यू, _mmw_, rkir
  { {0x4efb0053,0x7c240761,0x1efb004c,0x64400762}},	//   _פליג, skir, _פליע, zimi
  { {0x64400064,0xae1b01ac,0x7aed01c2,0xd9430763}},	//   yimi, _הויכ, awat, нефи
  { {0x64400764,0x7a2002dc,0x0000006a,0x0000006a}},	//   ximi, _nötv,   ,
  { {0xabfb0008,0xa2bd000b,0x38660765,0xeb91000a}},	//   _ההכר, _शिष्, rlor_, _יָם_
  { {0x64400034,0xe4a60766,0x0000006a,0x0000006a}},	//   wimi, прио,   ,
  { {0x80c0005d,0x25ac0089,0x64400767,0x61e80768}},	//   _विधे, _vedl_, timi, vedl
  { {0x3298000d,0xb7da0029,0xdc9b0008,0x61e80026}},	//   овиќ_, _دورا_, זיקל, wedl
  { {0x61e80769,0x6440076a,0x6234006b,0x9393002b}},	//   tedl, rimi, депу, رجيا
  { {0x80c0014e,0x4b3700f3,0x248c01c2,0x6440076b}},	//   _विदे, פריל_, _tudm_, simi
  { {0x64a3076c,0x66080134,0x859b000f,0xd59b000a}},	//   _заха, _indk, _השבו, _הבבל
  { {0x7aed0050,0xa3e3005d,0xdcb10092,0x35d2000b}},	//   ywat, _पॉप_, ẩm_, _साड़
  { {0x82fa0086,0xd5b10016,0xbea40033,0x661a076d}},	//   _دراز_, _món_, наўк, _kotk
  { {0x661a022d,0xb4b60065,0x0000006a,0x0000006a}},	//   _jotk, _जिफ़_,   ,
  { {0x61db0008,0x11db0008,0x6ce4005e,0xcd74006b}},	//   _הקוד, _החוב, ніте, егръ
  { {0xc49b000a,0x7e600045,0x7bcd0091,0x661a051e}},	//   משלת, împr, ugau, _lotk
  { {0xa3de005d,0x35d2000b,0x5e450015,0xda090015}},	// [870] द्य_, _साढ़, _يَعْ, ييره_
  { {0x91fc03eb,0x2bcb014e,0x661a0084,0x2486002d}},	//   klām, िलहा, _notk, _liom_
  { {0x7aed076e,0x98c701b7,0xac19076f,0x4dda004f}},	//   swat, ясал, _дону_, _וחתו
  { {0xa2bd000b,0x6fbf000b,0x6608007c,0x6ca8004f}},	//   _शिल्, ्लिं, _andk, _מֹשְ
  { {0xd6db0770,0x907c000a,0xa6c9005e,0x9f520003}},	//   сте_, צטדי, ілка_, _payé_
  { {0x9aa4002b,0x64990054,0xcf2c000a,0x7a200123}},	//   _سمفو, отир_, מֽוֹ, _sötv
  { {0xcd980008,0xf8ae002b,0x661a0771,0x0000006a}},	//   הדות_, _نکن_, _dotk,
  { {0x3e640030,0x99840015,0x66080012,0x442b0772}},	//   lött_, _ألفو, _endk, óc_
  { {0x661a01b2,0x15f5000b,0x2636002a,0x13090138}},	//   _fotk, _इसपर_, głos_, іной_
  { {0x80d90036,0x02390015,0x2509002b,0x45d4067a}},	//   оєму_, تثبت_, _ورای_, _поус
  { {0xb7bd0011,0x9f450046,0x7a20001a,0x2127002b}},	//   _alţi, ělý_, _götu, سيحی_
  { {0x59dd014e,0xa3ae005d,0x155a000a,0x46d1000b}},	//   न्तर, करण_, _וכעב, _समाह
  { {0x9f5f002e,0xb7da000a,0xdb060077,0x7f1a0033}},	//   ðuð_, חקרי, _pekí, ціну_
  { {0x1e83008f,0xfce60036,0x3e6400dc,0x76430049}},	//   клям, мого, jött_, niny
  { {0x91fc0024,0x3e6400dc,0x7a200123,0x10f50033}},	//   klāj, dött_, _mött, _цяля
  { {0xe0560015,0x69c30077,0x6ab60773,0x76430774}},	//   _تختب, ónen, tsyf, hiny
  { {0x09ba0029,0xcb670775,0xae9a0015,0x3a06002b}},	// [880] قطاع_, дате_, _بضبط_, وکسی_
  { {0x6722003f,0x19b90033,0x3e640030,0xda05000b}},	//   vyoj, зуць_, gött_, रागत_
  { {0x76430776,0x6ab60123,0xdb160030,0x49060058}},	//   diny, ssyf, tgyó, بواق
  { {0xfbb2014e,0x0fee000b,0xd7e3005e,0xacfb000a}},	//   _ज़िम, ज़िश_, вішо, _והטכ
  { {0xe7320040,0x764301d7,0xc68f0015,0x9e65002b}},	//   خصا_, finy, لِن_, _زاین
  { {0xd10d005d,0x24860026,0xceb90089,0x59dd000b}},	//   िमाण_, _siom_, áři_, न्दर
  { {0xf9830777,0xfbb2000b,0x7a200123,0xa5070099}},	//   _агро, _ज़ाम, _dött, деја_
  { {0xa8030063,0xa957000a,0x7d010778,0x493b004f}},	//   _изсл, _חילק_, ålsi, _וגלו
  { {0xa01b0084,0xe3af0015,0xe6930015,0x41c60033}},	//   lmög, جرى_, _للقد, мёна
  { {0x7a200779,0xc5760015,0xeae9004c,0x764301d7}},	//   _gött, _قطاع, פֿפֿ, ciny
  { {0x644b002e,0xd46a0054,0xa01b0012,0x0000006a}},	//   ðmið, _диже_, nmög,
  { {0x3e640014,0xf537000a,0x7a200030,0x53460245}},	//   zött_, _קטאר_, _köts, _охла
  { {0x80c0005d,0xa2d30015,0xe1fa0138,0x0000006a}},	//   _विवे, _لينت, _мгд_,
  { {0xe24600e6,0xfc3f0046,0x20090034,0x7d00003d}},	//   _تخصي, _smí_, _wnai_, āmsn
  { {0x463b0053,0xdcb10015,0x0cd40342,0x3d9400af}},	//   קעלע, طىء_, корю, тиср
  { {0xe0d1000a,0xbb4b005e,0x9ee90015,0x20090034}},	//   _עֲו_, оїзд_, _ففعل_, _unai_
  { {0x3e6400dc,0x3a75077a,0xcb550054,0xf3f90045}},	// [890] tött_, елар, хваћ, ulţi_
  { {0x61f8044c,0x99870046,0xf96b004a,0x61fa077b}},	//   _javl, ónů_, орей_, ndtl
  { {0x91fc0024,0xa3ae000b,0xe9d00015,0x18a4005e}},	//   elāk, करा_, شغل_, ваєм
  { {0x2c270191,0x38c4002e,0xb17b0053,0x7643077c}},	//   _цьог, _sérð_, קטאר, winy
  { {0x7643013c,0x6b9a000a,0xcb9a000a,0x91fc003d}},	//   tiny, _משרד, _מסרט, glāk
  { {0xf7700074,0x321c077d,0x20d80030,0x61f8077e}},	//   جام_, _novy_, kéi_, _navl
  { {0x9f4e0089,0x35f8002b,0x7643077f,0xa01b02ad}},	//   čném_, برند_, riny, omöd
  { {0x7643064e,0xb465002b,0x97c50015,0x91fc003d}},	//   siny, رگاه, _سقطو, blāk
  { {0xa3de021e,0xd5b10016,0x786a006f,0xe8df0016}},	//   द्ध_, _hóm_, zývk, _khỏa_
  { {0x80c0021e,0xaac70065,0x7ac70065,0x0000006a}},	//   _विशे, _लिनक, _लिनअ,
  { {0xa87901ac,0xf4d40015,0x64450003,0xc10500c3}},	//   ּאָר, _لتنظ, éhis, روحي
  { {0x44f10780,0xb4fa0008,0xdb06002c,0xc9520008}},	//   _iš_, _מפעי, _leká, רמט_
  { {0xd24e0074,0x69d5005c,0xd12e0086,0x93270087}},	//   _گنو_, _ocze, لمی_, _تران
  { {0x69c30077,0x2d980781,0x2d8c0723,0xb374009a}},	//   ónel, ucre_, øde_, _شدنش
  { {0xdb040782,0x81f60002,0xc0a8002b,0x68e2002a}},	//   mbié, _سفير_, _قايل_, łodz
  { {0x3c2e006f,0xd259003d,0x7a200061,0x224502f2}},	//   _býva_, ruņu_, _nötr, lilk_
  { {0x5aca0033,0x2f550033,0xcaca0033,0xa9a60783}},	// [8a0] ялам_, _атэс, ягае_, еизд
  { {0x4a430784,0x2bb2000b,0xa01b0012,0x224502f2}},	//   гнув, _ज़वा, tmög, nilk_
  { {0x4c860785,0x35c9000b,0xa96a0015,0xd82601b7}},	//   _плов, _राज़, أمام_, нджи
  { {0xdc9b0053,0x76410026,0xa01b05f7,0xfaa60033}},	//   _מיטל, _amly, rmög, _памо
  { {0x44f100df,0x8c1b000a,0x45d40658,0xbc1b004c}},	//   _aš_, _זוכי, волс, _זוכש
  { {0xdcfc0482,0xceb30786,0xf7470015,0xd4910016}},	//   ları, ניו_, علوي_, _bù_
  { {0xb5a5005e,0x64c30058,0x85b70058,0x0000006a}},	//   трій, هيول, راوس_,
  { {0x6f0404f9,0xd4910016,0xdcfc0061,0x76410034}},	//   _oric, _dù_, narı, _emly
  { {0x32540054,0x9961003d,0x61f80787,0xe7370788}},	//   квир, _cīņa_, _pavl, _зет_
  { {0x2d8c002c,0x442f0789,0xc217005e,0xdcfc0061}},	//   ždej_, _elg_, еєю_, harı
  { {0xdcfc01e2,0x3a370008,0x6d490011,0x52730015}},	//   karı, גרים_, şeaz, دايز
  { {0x6f040043,0xf9460033,0x0000006a,0x0000006a}},	//   _bric, ьнiк_,   ,
  { {0xdcfc0064,0x92930033,0x76410034,0x2fc00034}},	//   darı, _баіц, _ymly, _ddig_
  { {0xbe880080,0x68e2002a,0x9a090033,0xe731000a}},	//   ессе_, łody, лiне_, בֵל_
  { {0xf1b30008,0x2d85078a,0xd12f00fd,0x6f04078b}},	//   _עסק_, äle_, _сх_, _eric
  { {0x6565007c,0xb062008c,0xac18078c,0x5bcb000b}},	//   ühhi, ääte, носу_, िलेव
  { {0xf9c7078d,0x628a0030,0xd0740015,0x0fa8000a}},	// [8b0] ещен, _kifo, _حدوث, _אֹתֽ
  { {0x1ed80015,0x69da078e,0x8b080046,0x78710123}},	//   _أبيب_, _ötel, _spřá, gåvn
  { {0xa9280010,0xbc790036,0xdcfc0061,0x78470033}},	//   ніце_, _обох_, barı, нэдж
  { {0x69d5005c,0x628a0034,0x612b0030,0x6d08004f}},	//   _wcze, _lifo, lölö, _נִתַ
  { {0xe8df0023,0x80380053,0x799c0026,0x8c1a000a}},	//   _thỏa_, ענדע_, _ffrw, _חורי
  { {0x69d5005c,0xd5b10092,0xb5c2078f,0x9665006b}},	//   _ucze, _tóm_, айшл, ъкле
  { {0x224500bd,0x19580010,0xe8df0016,0xd5b10016}},	//   vilk_, _зары_, _muịc_, _vé_
  { {0xd138005c,0xb8e7005d,0x13090142,0x44f10790}},	//   dzą_, ों_, дний_, _vš_
  { {0x56950063,0x95d9000d,0x628a0791,0x28c9000b}},	//   _разт, _одат_, _bifo, ांकि
  { {0xdcfc0064,0x02020033,0x7641001a,0x2019002a}},	//   zarı, азьн, _umly, ejsi_
  { {0xa2bd005d,0xf9920008,0xdcfc0064,0xc4c70015}},	//   _शिक्, ירי_, yarı, _ستاو
  { {0x50460054,0x7d1a0123,0x6f040792,0xd496000a}},	//   темб, ätsm, _pric, _סכנת_
  { {0xdcfc0064,0x539a039e,0x63a90793,0xc2c400c3}},	//   varı, _חינו, mben, _ميني
  { {0x6fa2005d,0x01350015,0x78780794,0x4df5027a}},	//   _क्रू, _لعبد, míve, ляст
  { {0xd138005c,0xdcfc0064,0x63a900bd,0x61d600f3}},	//   czą_, tarı, oben, _יוסף_
  { {0x218800b2,0xec160086,0x31560053,0x518405fc}},	//   _אָפּ, خورد, _שיקן_, _суча
  { {0x787803af,0x27fd0176,0xdcfc0064,0xea8a0180}},	// [8c0] níve, ddwn_, rarı, дбал_
  { {0x5ee90008,0xdcfc0064,0x26cf0085,0xde8a0015}},	//   _נַפְ, sarı, dugo_, _تضعه_
  { {0xdcfc0064,0x5f46002b,0x7d010795,0xd7fa0763}},	//   parı, _سنگل, ålst, дул_
  { {0xc7c30080,0x63a90085,0x3ead0045,0xb6a6067a}},	//   асши, jben, ţete_, видл
  { {0x63a90796,0xfaa60099,0x56f30015,0x0000006a}},	//   dben, _јаго, لأوز,
  { {0x78780089,0xd5e3005e,0x9f42008c,0x4733005e}},	//   díve, ижчи, mekä_, шніс
  { {0x628a04ed,0xd9460797,0xdb0f016e,0xe4d30015}},	//   _rifo, _реви, _recé, لتيب
  { {0x7c360176,0xa5070124,0x63a90798,0x628a0799}},	//   nhyr, ђења_, gben, _sifo
  { {0x26dd005c,0x96e50015,0x7878016e,0xa2b30033}},	//   ctwo_, _مثلم, gíve, абыч
  { {0x62060036,0x067601b0,0xf992000a,0x96760033}},	//   тчиз, _рубя, יר֙_, _рыбі
  { {0x1be2000b,0xd4c50015,0x83fd0030,0x79ab000a}},	//   खभाल_, _مغني, zlői, וֹכַ
  { {0xd138005c,0x14d7000a,0x70550067,0x23ba006e}},	//   rzą_, _יובל_, انحا, _آداب_
  { {0xd1380050,0x30280033,0x628a079a,0x7878059d}},	//   szą_, тоўп_, _tifo, cíve
  { {0xa3de014e,0xbbcb000b,0xdd1c0046,0xc693000a}},	//   द्र_, िल्क, láře, יאש_
  { {0x69c80064,0x70f30058,0x7d24011e,0x26dd0535}},	//   _ödey, _نسيئ, афте, ztwo_
  { {0xdfd10029,0xb4fb000a,0xe8e00016,0xc61f000b}},	//   _اية_, ופלי, ýời_, _भव्य_
  { {0x4a550033,0xe451000a,0xba5500af,0x0000006a}},	// [8d0] гкас, צֶל_, гвај,
  { {0x63a9020c,0x5b340015,0x5a340262,0xbdf502d9}},	//   zben, جعفر, анут, _спој
  { {0x98480064,0x27ef079b,0x09e4005e,0x0178000a}},	//   _ağı_, tegn_, роєн, תָּל
  { {0xdcb10023,0xdb06079c,0x3e76001a,0x97c50015}},	//   ẩu_, _bekä, mæta_, اقشو
  { {0x7878016e,0x27ef079d,0x7c2d079e,0xe70b0058}},	//   xíve, regn_, mkar, بتان_
  { {0xd7740029,0xbb3a004c,0x7c2d079f,0x26cf02d8}},	//   جامع, _טערי, lkar, rugo_
  { {0x26dd005c,0x245a0024,0xd4690175,0xdb060061}},	//   stwo_, zīme_, нике_, _pekç
  { {0x7c2d07a0,0x63a907a1,0xa3b900c3,0x787807a2}},	//   nkar, uben, رابر_, tíve
  { {0x17550010,0xc7b2000f,0xdb060012,0x069b002b}},	//   _свая, _לבן_, _gekä, _آخرت_
  { {0x96f80115,0x7d0807a3,0x63a907a4,0x7878016e}},	//   _جعفر_, ådsk, sben, ríve
  { {0x7878001c,0x9f4e0089,0xd5b10092,0x7c2d07a5}},	//   síve, čním_, _nói_, kkar
  { {0xddd50089,0xdb0a0227,0x7c2d07a6,0x05df0065}},	//   mozř, šnéh, jkar, प्रब
  { {0x91e507a7,0xa856000a,0x442d07a8,0x7c2d07a9}},	//   _боле, רירה_, mke_, dkar
  { {0xf77600b2,0xdd920070,0x2edc000b,0xfcaa0015}},	//   טערי_, صور_, मझौत, فارو_
  { {0x8cd4005d,0x8c7a0063,0x51840054,0x62810012}},	//   बंधो, ещат_, _кућа, mmlo
  { {0x7c2d00b6,0x2bf60033,0x442d07aa,0x64490045}},	//   gkar, ыягр, nke_, niei
  { {0x9b93003b,0x442d07ab,0x69da0061,0xf99200c3}},	// [8e0] إلكت, ike_, _ötek, مبا_
  { {0x3e76002e,0xe9d707ac,0x3b8307ad,0x05d2000b}},	//   bæta_, лку_, слуг, _साइब
  { {0x442d07ae,0xd5b10016,0x4ddb000a,0x08c606b5}},	//   kke_, _gói_, _אחיו, убен
  { {0x442d07af,0xca290008,0xdbd700b8,0xa3e3000b}},	//   jke_, הם_, mäßi, _पॉल_
  { {0xd707004a,0x8d76002b,0xdd1c0046,0x442d07b0}},	//   лнце_, _جاکا, váře, dke_
  { {0x442d07b1,0x38c8002b,0x8b0b000a,0x7af60034}},	//   eke_, _لاری_, _אִלֵ, mwyt
  { {0x64490176,0x54e60029,0x7af60026,0xc8f8000a}},	//   fiei, استق, lwyt, _בִּכ
  { {0x25f0005d,0xd4670001,0x4d7b0053,0x78a3001a}},	//   _इसकी_, лије_, ערקע, ínve
  { {0xa6ca0086,0x7af60026,0x91fc0024,0xd5d6002b}},	//   _سوال_, nwyt, klāt, _متاث
  { {0xe29f0084,0xd6cf0196,0x268a0015,0x442d07b2}},	//   íða_, _رقم_, _أخري_, ake_
  { {0xf593003b,0x20d30010,0x055602c5,0xddce0091}},	//   _المج, біўс, _стая, albū
  { {0x557700b2,0x442d07b3,0x38660177,0xe29a0254}},	//   _געבן_, cke_, noor_, _зад_
  { {0x80c0005d,0x6e9506f7,0xd3b90033,0x5f020065}},	//   _विके, ригу, _рухі_, शिष्_
  { {0x38660409,0x6e94004a,0x764a0034,0xd357000a}},	//   hoor_, сиру, nify, _גידי_
  { {0x16d1014e,0x7c2d0048,0x28c9000b,0xc534000a}},	//   _सम्ब, tkar, ांछि, בָּה_
  { {0xd1750010,0x7c2d07b4,0xa3e7000b,0x80a3006e}},	//   _тычы, ukar, म्प_, _امين
  { {0xc3340008,0x386605d6,0x7c2d07b5,0xead502e1}},	// [8f0] בוּ_, door_, rkar, розь
  { {0x7f3c00b4,0x442d07b6,0x7c2d07b7,0x38660546}},	//   _רעזו, zke_, skar, eoor_
  { {0x290707b8,0x442d07b9,0x64490034,0x68270033}},	//   ína_, yke_, yiei, льдз
  { {0x80d70053,0x386607ba,0x0000006a,0x0000006a}},	//   רואװ_, goor_,   ,
  { {0x76ab0124,0x9bba0008,0x6f1b00b8,0x442d07bb}},	//   хтев_, _בצרפ, äuch, vke_
  { {0xa3e7005d,0x19940036,0xa594006b,0x95c80054}},	//   म्न_, _гаря, бръщ, гућа_
  { {0x3d08005d,0x845907bc,0x74f60015,0x442d05e3}},	//   हिये_, крит_, لفوز_, tke_
  { {0xdd1d002c,0x6a6b00b8,0x91fc0024,0x142507bd}},	//   ráňt, rüfu, klās, рдим
  { {0x02d60015,0x7cec0030,0x425507be,0x644907bf}},	//   لويب_, _körö, итот, riei
  { {0x27ff00f2,0xcb120008,0x442d07c0,0xdb0f0247}},	//   _haun_, קלי_, ske_, _necí
  { {0x30760004,0x62810028,0x69dd000b,0x06840015}},	//   иумс, rmlo, _पानी, _اللُ
  { {0x649a01ac,0xdb0f016e,0x70530015,0x749a000a}},	//   _סינה, _mecâ, ْنَا, _סינפ
  { {0x92b70029,0x02a707c1,0xf1dd000b,0xe2980033}},	//   _إحصا, _срем, _मापन, _баі_
  { {0xed5a0124,0xd3560008,0xf652004c,0x45b5004c}},	//   вог_, _דיני_, ַצן_, יפֿל_
  { {0xdb0f02c1,0x32f6002a,0xa01b07c2,0x614207c3}},	//   _decí, _zły_, mmön, _меша
  { {0xbb760063,0x7c3a003d,0x7aa60015,0x7af60034}},	//   аузъ, ītro, لإطل, twyt
  { {0x4a4601d9,0x38660111,0xa3e7000b,0xcaa50015}},	// [900] анав, voor_, म्य_, مصلي
  { {0x78780089,0x7af60026,0xdebb0008,0x2bb20065}},	//   díva, rwyt, _שמיל, _ज़का
  { {0xf1dd005d,0x2619005d,0x91fc0024,0x41dd005d}},	//   _मानन, पानी_, olār, _मानस
  { {0x63bb0048,0xdb0f04f9,0xdc9b000a,0xa96701b7}},	//   jaun, _decâ, _שיכל, шиха_
  { {0x8f9b0008,0x9b030010,0x386600dd,0x46f6068e}},	//   דיני, _дзяд, roor_, рчет
  { {0x7cec00dc,0x5b57000a,0xddc707c4,0x386607c5}},	//   _görö, _כיכב_, oljš, soor_
  { {0xa3e7005d,0x764a07c6,0x5dc9000a,0x7a8b000a}},	//   म्भ_, rify, אֶפְ, _יָלַ
  { {0x63bb07c7,0x8ba9000a,0x27ff07c8,0x69c30030}},	//   gaun, ְׁתִ, _gaun_, ónev
  { {0xd6cf0015,0xd377004a,0xe3af0015,0x46a307c9}},	//   _يقف_, ичь_, ذري_, _матв
  { {0xc50a0015,0xa3e7000b,0xf991000a,0x2258007c}},	//   _لتصل_, म्ब_, ּ֨י_, õrk_
  { {0xd1300029,0x73c6002b,0x64a301f3,0x7bc607ca}},	//   سمح_, _نيام, _даха, _odku
  { {0x27e60176,0x92020024,0x04db0008,0x78a10030}},	//   nfon_, _šāda, _יקבל, _élve
  { {0x20050089,0xa8570008,0xc43b000a,0x83fd0030}},	//   ěli_, שיכה_, _בתאי, rlőt
  { {0x20050050,0x7a320134,0xf1dd000b,0x290a07cb}},	//   śli_, _sætn, _मायन, _orba_
  { {0xcd04004a,0xc534000a,0x2ca500aa,0x41270004}},	//   очти, זָּה_, ëld_, _војо_
  { {0x70550074,0xec340036,0xc3340008,0x69dc07cc}},	//   _دنبا, онсь, ֖וּ_, _acre
  { {0x290a0780,0x207c0053,0x27ff002e,0x44f80092}},	// [910] _arba_, _באהא, _raun_, _lũ_
  { {0xe919005e,0x9abe01f3,0xa93d0033,0x27ff007c}},	//   лозі_, вiта_, ндзi, _saun_
  { {0x7cec00dc,0xa3e7000b,0xad19000a,0x27e607cd}},	//   _vörö, म्ड_, _עוֹר, ffon_
  { {0xb8ef000b,0x787807ce,0x97150033,0x3157000a}},	//   _शि_, tíva, ймец, סיאן_
  { {0x7cec0014,0x8c1a0008,0x290a02b9,0x63bb008c}},	//   _törö, _עושי, _erba_, vaun
  { {0x27ff0034,0x69dc0125,0x248f01d7,0x59c50015}},	//   _waun_, _gcre, _sigm_, _ديسك
  { {0xe802005d,0x44f80092,0xce380008,0x05790015}},	//   _रोका_, _cũ_, שאות_, دمغة_
  { {0xed580008,0xd64d0010,0x80c0005d,0x6d48002d}},	//   יבור_, _лiпе, _विजे, údai
  { {0xdb0607cf,0xc6d40015,0x473507d0,0x869807d1}},	//   _sekú, _وتكت, _унас, _вкус_
  { {0xe4e70191,0x629b0152,0xb06300f2,0xdb0f0144}},	//   _відн, rquo, äänt, _mecà
  { {0x63a20026,0x9f5e0089,0xe4e40036,0xcf89000a}},	//   _ffon, ětí_, _міцн, _נט_
  { {0xaac7005d,0x660107d2,0x44e10387,0xc952000f}},	//   _लिंक, _halk, mó_, למי_
  { {0x43850015,0x539a000a,0x44e107d3,0x69c707d4}},	//   _الشق, _עיסו, ló_, _odje
  { {0xf6790053,0x660100f2,0x877a0053,0x6da307d5}},	//   טאָמ, _jalk, טארי, зира
  { {0x80ce000b,0xc27a000a,0x44e107d6,0x660107d7}},	//   _थिये, _גרסי, nó_, _malk
  { {0xdb0a0089,0x69dc07d8,0x3e7d0046,0xcb6a07d9}},	//   šníh, _scre, _pátý_, габе_
  { {0x63b90176,0x290a016f,0x44e10092,0x629901d7}},	// [920] _mewn, _srba_, hó_, _juwo
  { {0xbf9b03af,0x4229000a,0x499601b7,0xb40b002a}},	//   ndên, נֵּ֣, сшат, ążył
  { {0x31ba00b2,0x497a0010,0x387f0125,0x44e107da}},	//   רזענ, усаў_, _bhur_, jó_
  { {0xe73a005f,0x387f002f,0x07b70029,0x44e107db}},	//   лее_, _chur_, مهمة_, dó_
  { {0x27e60026,0xa01b007c,0xd62a0248,0x4b55006b}},	//   rfon_, dmöl, лоде_, _дърт
  { {0x63a204ed,0xceb300a3,0x7ae407dc,0x54e60015}},	//   _sfon, ליד_, mtit, مسبق
  { {0x96c4005d,0x44e107dd,0xc7a6004a,0xe4ea00c3}},	//   _रिकॉ, gó_, _гибк, اعته_
  { {0x44f80023,0x39570008,0xd5b10016,0x9cd7000a}},	//   _vũ_, _השלם_, _sót_, צופה_
  { {0x8c1b0008,0x85060086,0x326607de,0xd3700029}},	//   רופי, _گوان, йтов, بهة_
  { {0x11d8003b,0xd6250029,0x3e7f0152,0x8afb0135}},	//   جودة_, _وعلي, oîte_, נהיי
  { {0x0496003b,0x7174003b,0x44e102c1,0x63b90026}},	//   _الصح, تهدا, có_, _fewn
  { {0x6e250064,0x7c2607df,0xbfab004a,0x787804b2}},	//   _sohb, _nokr, ытое_, zívn
  { {0x447b00b4,0x1fa40033,0xa3760015,0x78780030}},	//   _ענדע, ярэг, _اداؤ, hívo
  { {0x63b90050,0xbc95000d,0x39dd005d,0xa2f7000a}},	//   _zewn, жавј, न्फ़ि, _למדה_
  { {0x90a60225,0x7c2607e0,0x7ae407e1,0x6d340148}},	//   _احتم, _bokr, etit, перф
  { {0x98c50024,0xb157000a,0x7d030030,0x3157000a}},	//   ūtīt_, _לסוג_, eírá, _ליון_
  { {0x44e10014,0x7878002c,0x9e660086,0x2fc901a7}},	// [930] zó_, tívn, _ژاپن, _idag_
  { {0x98b80064,0x44e102c1,0x442607e2,0x7d030030}},	//   _ayrı_, yó_, _loo_, gírá
  { {0x35d2000b,0xda78023c,0x25d2000b,0xb8f50015}},	//   _साज़, сят_, सलैण, تكاب
  { {0x44e102c1,0x6f0d07e3,0x60db004c,0xdd25003d}},	//   vó_, _krac, רקאנ, tīņa
  { {0xfaff0024,0x7d0307e4,0xba770015,0x660107e5}},	//   šību_, bírá, _هاست, _palk
  { {0x44e107e6,0xd1260196,0xaa5d005e,0x69c707e7}},	//   tó_, _قم_, _регi, _udje
  { {0xe3b1003b,0x63b90050,0x660107e8,0x5e580053}},	//   ورة_, _pewn, _valk, זיגע_
  { {0x386d003c,0x3ea900f2,0x660107e9,0x44e107ea}},	//   _uker_, _otat_, _walk, ró_
  { {0x660107eb,0xe2990054,0x44e107ea,0x1c2c000a}},	//   _talk, јао_, só_, רֽוּ
  { {0x63b9005c,0x44e10077,0x60e907ec,0x0000006a}},	//   _wewn, pó_, амом_,
  { {0x6f0d01e2,0xfbdf001c,0xf652000a,0x3ea90045}},	//   _arac, _ocê_, _קצב_, _atat_
  { {0x44c50024,0x93150015,0xa01b0123,0x7ae407ed}},	//   mē_, _وواش, lmöj, ytit
  { {0x44c50024,0x6da6004a,0x6f0d07ee,0x0d9a02ed}},	//   lē_, жига, _crac, итвы_
  { {0x442605d6,0x6f0d07ef,0x7c2607f0,0x0000006a}},	//   _zoo_, _drac, _sokr,
  { {0x27ed00b8,0x44c50024,0x7d030046,0xafe601b0}},	//   _oben_, nē_, vírá, _дойл
  { {0xeb970080,0x6a7000b8,0x320500da,0x2ca5001a}},	//   жит_, häft, ldly_, ílda_
  { {0x3b070254,0x6f0d07f1,0xaac50015,0x3a2607f2}},	// [940] оето_, _grac, كتلن, омаг
  { {0x3205003e,0x0b590033,0x7ae407f3,0x787807f4}},	//   ndly_, ёрты_, rtit, tívo
  { {0xd23a0053,0x7ae407f5,0x7c2607f6,0x27ed0030}},	//   סגעל, stit, _tokr, _bben_
  { {0x44c50024,0x7d030030,0x6bd6012c,0x4d7b004f}},	//   dē_, sírá, _بتدر, _כריע
  { {0xc7a307f7,0x7d030046,0xfaa607f8,0x0000006a}},	//   фичк, pírá, _фаго,
  { {0x3af900b2,0xe4a6000d,0x27ed00b8,0xa3e7005d}},	//   _פּרע, орио, _eben_, म्स_
  { {0xd497054f,0xc8b50033,0xc7a6006b,0x47d60015}},	//   оры_, _нсты, _мивк, _ويسر
  { {0xe4660061,0x320500da,0xf2c607f9,0x0000006a}},	//   _önüş, edly_, осон,
  { {0x83fd00dc,0x69da0064,0xb2860033,0xd25a011d}},	//   rlőp, _ötes, жынк, ицо_
  { {0xc5160015,0x89da000a,0x26c00091,0x52830015}},	//   _وبات, ׁחִי, šios_, وليك
  { {0x4a7b00b2,0xfbca014e,0xd2570010,0x64950089}},	//   שריב, िणाम, ўцы_, _všic
  { {0x320500da,0x4034004a,0x6f0d0771,0x0000006a}},	//   adly_, деюс, _prac,
  { {0xe67b0092,0x3d950763,0xa3560058,0xf8d70065}},	//   _hưở, зигр, _بخاص, _डम्प
  { {0xdef8008f,0x6f0d07fa,0x68e50416,0x0000006a}},	//   цыю_, _vrac, ythd,
  { {0x6ce40191,0xbc4b0010,0x6f0d07fb,0xd1300015}},	//   міте, ачае_, _wrac, _سمة_
  { {0x2611005d,0x6f0d07fc,0xafdb04d1,0x0c840138}},	//   _धोनी_, _trac, riøs, дыум
  { {0x93fb0008,0x44c50024,0x97ea0064,0xe9ab0021}},	// [950] סלמי, zē_, ışlı, لدان_
  { {0xf8b10086,0x78a300dc,0xceb2000a,0xeab00015}},	//   فکر_, ínvo, _ריי_, ضعك_
  { {0x57f5006b,0x6e2102ad,0x0000006a,0x0000006a}},	//   зпет, ölbu,   ,
  { {0x9cd60008,0x68e50495,0x44c5003d,0xa8020061}},	//   _צורה_, rthd, vē_, _çılg
  { {0x8c1a000f,0xbc1a000a,0x99d70015,0x8bc40033}},	//   _הורי, _הורש, _وتسا, _ўсюд
  { {0x1efc0053,0xafdb003c,0x2efc000a,0x44c5003d}},	//   ילדע, rnøy, שִׁב, tē_
  { {0x6a7007fd,0x2db8000a,0x7af90061,0xafdb00cb}},	//   räft, חלון_, şatı, snøy
  { {0xf9920008,0x98170029,0x8d5c0008,0x44c50024}},	//   _טרם_, _ببسا, יכוי, rē_
  { {0xf749003b,0xe3b10086,0x24480086,0xe3b60010}},	//   _الذي_, ورک_, تجوي_, чбы_
  { {0x36370074,0xeb920008,0x44c50024,0x9b16000a}},	//   _بررس, עָה_, pē_, פחתה_
  { {0x216907fe,0x3205003e,0x8622002b,0xdb1d02de}},	//   сини_, rdly_, _سکول, _udsæ
  { {0x29360053,0xd12e0015,0xa936000a,0x3ea4013f}},	//   פארן_, امَ_, פטרה_, ímto_
  { {0x2004002c,0x539a0447,0xc7d6000a,0x3e76001a}},	//   ľmi_, _הסנא, הורי_, læti_
  { {0x161e000b,0xa3e7000b,0xf3f90045,0xa0c50015}},	//   पायर_, म्र_, leţ_, _فيتو
  { {0xc692013a,0x91ba0008,0x443f07ff,0xed52002b}},	//   תאם_, _המצי, ohu_, رپر_
  { {0xc0a80029,0x01340002,0xaac7000b,0x7aa6004a}},	//   _باول_, _تعهد, _लिखक, зиаз
  { {0xf093000a,0x99830046,0x89f60033,0xe085012c}},	// [960] _אנה_, _bojů_, зяец, _تجوي
  { {0xb4bb005d,0x499a04ab,0xda650021,0x97ea0061}},	//   _अबू_, стая_, والي, ışmı
  { {0x9e650015,0xa96a0015,0xd7ef0800,0x7d0102de}},	//   _تاين, حمام_, ну_, ælst
  { {0xfc32003b,0xdb040111,0xc0ac000a,0x7a32001a}},	//   _أحد_, ncië, ׁיבָ, _mæti
  { {0xfbd3013a,0xf3f90045,0x7c360123,0x96b70054}},	//   _אתר_, deţ_, mkyr, пују_
  { {0xe8df0023,0xd6a90086,0x4b7b0008,0xdb0f016e}},	//   _giữa_, زدهم_, _לאכו, _secç
  { {0x4dfb004c,0x9abe0033,0x5ede000b,0xdb060030}},	//   מפסא, вiча_, कंड्_, _lekü
  { {0xb3c6000b,0xe73a067a,0xdbcf0046,0x895b000a}},	//   रृंख, _леб_, ožád, _הדלת
  { {0xdb0600dc,0x8c1b000a,0x75960015,0xf74307f9}},	//   _nekü, מוקי, _فجاء, _зето
  { {0x7a32002e,0xe67b0092,0x443f0801,0x83330015}},	//   _bæti, _tưở, ahu_, عريض
  { {0x2619005d,0xf1dd005d,0xa01b008c,0x75d30015}},	//   पारी_, _मारन, lmöi, _أيما
  { {0xc4860802,0xdb0600dc,0xb97b0008,0x73e60010}},	//   _элек, _bekü, מניי, _ходз
  { {0xee87004a,0x7a3202de,0xbf3401b7,0x9471002b}},	//   зыво, _tæth, енящ, _جگوا
  { {0x13170008,0xf0b70086,0x12fb000a,0xc333000a}},	//   _מחדל_, _کاوش_, _להדב, _רוס_
  { {0x7a320084,0xc27b0008,0xe9ff0092,0xa1570803}},	//   _gæti, _הרגי, _ngạc_, _нашу_
  { {0x415b013a,0x31c60089,0x2d580036,0x515b0008}},	//   _לדוג, bízí_, чись_, _לכוו
  { {0xdb040152,0x8f9c039e,0xdb060012,0xdb0d0003}},	// [970] nciè, _פיזי, _gekü, rbaï
  { {0x61fa0407,0x7a570015,0xca73002b,0xe29f001a}},	//   netl, أضرا, رناک, íði_
  { {0x60da0064,0x2489002c,0x53dc0065,0x6ca402db}},	//   nutm, ňami_, _यांश, _пряж
  { {0xf7700074,0x3755002b,0xf77500fd,0x61fa0804}},	//   گام_, وپاس, мулю, hetl
  { {0x61fa01e2,0x6440002d,0x2619005d,0x66050805}},	//   ketl, dhmi, पाली_, дпла
  { {0x61fa016f,0xf7700806,0xf3f90045,0x78780030}},	//   jetl, دام_, inţe_, hívh
  { {0x443f0807,0x61fa0808,0xd5e80058,0x91b300a1}},	//   thu_, detl, سعون_, _đèn_
  { {0xc9520008,0x52a90809,0x7cec000a,0xd2a905ab}},	//   _סמן_, овим_, צַוֶ, окие_
  { {0x13060080,0xa3df005d,0xf3f90045,0x61fa080a}},	//   дный_, तलब_, reţ_, fetl
  { {0x68e100c0,0x64400064,0x61fa078e,0x645b080b}},	//   _älds, ahmi, getl, snui
  { {0x95c40086,0xdcf6003d,0xa2cf000b,0xf3f90045}},	//   _سينه, ācīb, _दिव्, enţe_
  { {0xcdc9013a,0x6440080c,0x78a900bc,0xdbcf0046}},	//   _כך_, chmi, _čevl, yžád
  { {0xdb040111,0x43740180,0x61fa080d,0x0000006a}},	//   rcië, _пушт, betl,
  { {0xa294005e,0x0caa0015,0xc1050021,0x329a000a}},	//   _зачі, قطري_, _يوشي, _ובסד
  { {0xe2900015,0xebe6005e,0x1d07080e,0xf3f90045}},	//   _إذن_, мовп, мери_, anţe_
  { {0x6e21001a,0x0000006a,0x0000006a,0x0000006a}},	//   ölbr,   ,   ,
  { {0x29030020,0xfaff0024,0xba1a0015,0x5e460015}},	// [980] _asja_, šīnu_, ييرا_, _يَبْ
  { {0x7c36080f,0x64850810,0xf9920015,0x29110085}},	//   skyr, lóid, نبا_, _brza_
  { {0x32070041,0xac860036,0xae1b0053,0x3ea00152}},	//   _many_, _огол, _וויכ, _huit_
  { {0xc9850015,0x38cb002b,0x68e30144,0x999a0091}},	//   رشلي, زامی_, ànda, tipų_
  { {0x46a30010,0x61fa0700,0xabfb000a,0x1bfb000a}},	//   вачв, yetl, _והכר, _ולכב
  { {0x443d0026,0x28db000b,0x8a060033,0xd5af0040}},	//   _alw_, मूहि, _ўзве, لفه_
  { {0x5e5700b2,0xe0c70086,0xab5b0012,0xa7da0015}},	//   ויסע_, _جز_, _geüb, _ووسط_
  { {0x47d30029,0x2816002b,0x61fa0811,0xdb04039f}},	//   _ليفر, _تورس, wetl, ecié
  { {0x3ea00152,0x68e100c0,0x61fa00dc,0xa3df000b}},	//   _nuit_, _äldr, tetl, _तार_
  { {0x443d0026,0xdb040003,0x64400812,0xa683012e}},	//   _elw_, rciè, shmi, _алуд
  { {0x60da0020,0x61fa0813,0x659b000a,0xa055005e}},	//   uutm, retl, _ויבק, евні
  { {0xf9930008,0x68e100c0,0x3ea00814,0x61fa0815}},	//   כרת_, _ålde, _buit_, setl
  { {0xc7b30008,0x3cf1000b,0x69ce0816,0x741300c3}},	//   כבר_, ँढ़ने_, _odbe, _جونا
  { {0x3ea00817,0x799c0034,0x52130033,0x43930033}},	//   _duit_, _ngrw, _адшт, _раіс
  { {0xd3080023,0x6e940818,0x41db000a,0x41c30015}},	//   _hệ_, тиру, _וחוס, _شقيق
  { {0x1bbb0029,0x3ea00003,0xd3080016,0xdb5b0121}},	//   تاسع_, _fuit_, _kệ_, оюз_
  { {0x629800dc,0x7a32002e,0x661a0234,0xae0c000b}},	// [990] _kivo, _lætu, _ontk, िएशन_
  { {0x200903f8,0xdcfc007f,0x66080819,0x0000006a}},	//   _haai_, abrı, _nadk,
  { {0xd3080023,0xb86b0004,0xa9280033,0xdb1d0030}},	//   _lệ_, ојде_, міце_, _mesé
  { {0xa2cf014e,0xec350053,0x31570053,0xf8680015}},	//   _दिल्, _נאָר_, ויבן_, وملي_
  { {0xd7580015,0xe7240015,0x8bd6000a,0x0aeb0015}},	//   وجها_, َّمَ, _אורו_, _برجي_
  { {0x2009020a,0xdb1d002c,0xfb160053,0x629801a3}},	//   _laai_, _odsú, _אַלט_, _nivo
  { {0x67d50001,0x3207002a,0x69c5081a,0x46120015}},	//   _пову, _rany_, mahe, طوير
  { {0xcd98011f,0x69c50020,0xdcb10092,0x83fd00dc}},	//   ודות_, lahe, ẩy_, llőz
  { {0xb7bd0045,0x2fc003a0,0x6298081b,0x0000006a}},	//   _noţi, _reig_, _bivo,
  { {0x64950007,0x5999000a,0xd70202a3,0x7a32001a}},	//   _išim, ּשֹׁ, _вiта, _fætu
  { {0x7a32002e,0x245a0024,0x3ea00493,0x20090079}},	//   _gætu, zīmi_, _suit_, _baai_
  { {0x7a320084,0x78780227,0xf99200f3,0xe8d6000a}},	//   _hætt, tívi, טרי_, עורר_
  { {0x6485081c,0x3ea000da,0x2fc00144,0x200900aa}},	//   róid, _quit_, _veig_, _daai_
  { {0xe29f0084,0x6485002d,0xd356000a,0x3ea00144}},	//   íðu_, sóid, _איני_, _vuit_
  { {0x75f30064,0x7a32081d,0x63a9081e,0xab5b01d3}},	//   mızı, _mætt, ocen, _odüs
  { {0x98a70089,0x6f04002d,0xa156000a,0x91fc003d}},	//   šně_, _tsic, _רבקה_, anād
  { {0xfc3f002d,0x6f04003f,0xada6081f,0x6da6018d}},	// [9a0] _dlí_, _usic, _папл, _пипа
  { {0x75f301e2,0x19b9008f,0x09e30033,0xba260033}},	//   nızı, дуць_, лоун, эдзк
  { {0x27fd0026,0x3236004c,0x4236004c,0xba3b0144}},	//   fewn_, עטען_, ענעל_, _suïc
  { {0xe7860036,0xc18c0053,0x248d0820,0x59e2000b}},	//   нуло, קטאָ, jmem_, _पावर
  { {0x7a320821,0x2ba8005d,0xcfb7000a,0x9e65002b}},	//   _bætt, _ज़्या, גלני_, _ساین
  { {0x69ce0134,0x672d008c,0x25780822,0x63a90823}},	//   _udbe, äaja, мбль_, ecen
  { {0x629804ed,0xa507011e,0x0000006a,0x0000006a}},	//   _rivo, ееја_,   ,
  { {0x47d600a2,0x5503004a,0x63a902de,0xf1dd0065}},	//   _سيطر, учша, gcen, _माउन
  { {0xa01b0084,0x8857000a,0xdb080003,0x41e60033}},	//   llög, _נשמע_, élèv, ніна
  { {0xd3080023,0x24860041,0x63a90824,0xddc700bd}},	//   _vệ_, _whom_, acen, kojš
  { {0xb7bd0011,0xa3e8000b,0x45b7000a,0xa01b001a}},	//   _soţi, _बाप_, _נפאל_, nlög
  { {0x44cc0089,0xd3080092,0x653b0008,0x853b000a}},	//   mě_, _tệ_, _מעבד, _מגבי
  { {0x8457004c,0x62980825,0x0000006a,0x0000006a}},	//   _אבאס_, _tivo,   ,
  { {0x61460152,0xfc3f002d,0x28d1000b,0x200900aa}},	//   _célé, _slí_, _हिलि, _waai_
  { {0x69c50005,0x44cc0089,0x61460152,0x2009042f}},	//   vahe, ně_, _délé, _taai_
  { {0x8aa70080,0x717b000a,0x317b000a,0x9f520077}},	//   ержд, _מנוס, _מרומ, _cayó_
  { {0x657a0026,0xa3e8000b,0x69c50826,0x61460030}},	// [9b0] _lyth, _बान_, tahe, _félé
  { {0xbbeb0086,0x248d005c,0xbb840015,0xf3f90045}},	//   _کردم_, zmem_, الكي, inţa_
  { {0xe61f0023,0x18a4005e,0x78780030,0x657a0827}},	//   _đô_, гаєм, hívu, _nyth
  { {0x44cc0089,0x7a320134,0xd7590031,0x69c50828}},	//   dě_, _sætt, ولات_, sahe
  { {0xd763002b,0x245a003d,0x657a0123,0xab840829}},	//   دنشی, nīmu_, _ayth, _бурк
  { {0x657a0026,0x64950107,0x7aed082a,0xcad6004f}},	//   _byth, _všim, mtat, _בושת_
  { {0xf3f90011,0x8578006b,0x1600000b,0x657a082b}},	//   enţa_, нсът_, ऊज़र_, _cyth
  { {0xf8b2000a,0x99840015,0x657e0061,0x612a0061}},	//   _כשל_, _إلفو, üpha, zölç
  { {0x48640063,0x14220010,0x7a32063b,0xb722002b}},	//   _сърб, рдым, _tætt, _نکوه
  { {0x44cc0089,0x25ac082c,0xd64b005e,0x63a9082d}},	//   bě_, _gfdl_, _пiсл, scen
  { {0x387d0026,0x63a9082e,0xf3f90045,0x657a0034}},	//   olwr_, pcen, anţa_, _gyth
  { {0x321c082f,0x73390248,0x7aed0830,0x614601f6}},	//   _envy_, _озер_, ktat, _sélé
  { {0xe28e0831,0x7aed0030,0x387d0034,0x20550138}},	//   _ва_, jtat, ilwr_, утэр
  { {0xc0a80086,0x7aed0832,0x0dba00e6,0x82d6015b}},	//   بایل_, dtat, باحث_, _יונג_
  { {0x7aed0667,0x442f0085,0x2175004c,0x1fb60833}},	//   etat, _kog_, _בײַם_, _испр
  { {0x442f0834,0xb06300f2,0xe8df0016,0xc4d205bd}},	//   _jog_, äätt, _nhựa_, יגל_
  { {0x6146038d,0x7aed00b6,0x442f016f,0x80bd000b}},	// [9c0] _télé, gtat, _mog_, वीरे
  { {0x4a430835,0xd5e0000b,0x8f37000a,0x78780030}},	//   анув, _नाइज, _סניף_, hívt
  { {0x4dd900b2,0x2dd90053,0xd5be0024,0x387d0026}},	//   _אַרױ, _אַרב, šāka_, flwr_
  { {0x44cc0089,0xbb860015,0x657a0003,0xd7f70033}},	//   vě_, _للجي, _ryth, вуш_
  { {0xb606006b,0x657a0034,0x7aed0836,0xb865006e}},	//   вяйк, _syth, ctat, دالو
  { {0x44cc0089,0x98a70011,0xdb0600dc,0x7673042b}},	//   tě_, ână_, _bekö, аліф
  { {0xe9760086,0xdff4000b,0x04660054,0x8503002b}},	//   _شهرد, ेजाद_, ктим, لوون
  { {0x24650024,0xd4670054,0x78780030,0x6f160837}},	//   tēma_, кије_, tívu, _oryc
  { {0x657a0176,0xa01b002e,0x442f0838,0x65c60839}},	//   _wyth, kmör, _dog_, _абза
  { {0x44cc0046,0x442f0034,0x0000006a,0x0000006a}},	//   pě_, _eog_,   ,
  { {0x7aed03c0,0x442f0014,0x320a002c,0x3a370008}},	//   ztat, _fog_, ľby_, דרים_
  { {0x7658000c,0xe5370053,0x7aed00dc,0x320a0107}},	//   livy, _שטאט_, ytat, žby_
  { {0x7641008c,0x2d8c0046,0xbf0d000b,0x6442083a}},	//   _ylly, ýden_, िटेन_, _iloi
  { {0x442f00b8,0x539b0008,0x12a90029,0x7c2f083b}},	//   _zog_, _חידו, _أدنى_, _socr
  { {0xbca5003b,0xe29b0008,0x16df000b,0xe04b0015}},	//   امري, _קשור, _नम्ब, _يشبه_
  { {0xbf670029,0x7658003f,0x46d2000b,0x7aed083c}},	//   _لدخو, hivy, _सिंह, ttat
  { {0x4c940731,0x5b150033,0x7aed083d,0xfb340033}},	// [9d0] ритс, ымат, utat, антэ
  { {0x201e0024,0x7aed083e,0x27140016,0x99d40015}},	//   ētie_, rtat, _ình_, لتما
  { {0xda7803ad,0x39a40784,0x59c40015,0xdd910067}},	//   тят_, ршув, شينك, _دود_
  { {0xdd3a0008,0x87d40033,0x7aed083f,0x672d008c}},	//   _נערכ, аўшч, ptat, äajo
  { {0xd7ee0029,0x16350063,0x442f0011,0x7bda000a}},	//   سكو_, ледя, _rog_, _אקרו
  { {0x6442022d,0x7f3c0008,0x6d580007,0x442f00b8}},	//   _aloi, ועדו, _žvai, _sog_
  { {0x7878032c,0xe4c80029,0x56920001,0x78ac006f}},	//   tívt, نبين_, љајт, ľové
  { {0x130905cb,0x84580080,0xe80b000b,0x3c57000a}},	//   ений_, крыт_, _सोचा_, כֹ֖ל_
  { {0x628a002f,0x97ea01e2,0xe5e5002b,0x26cd0085}},	//   _bhfo, ıştı, _مزای, _uveo_
  { {0xa3e8000b,0x42250840,0xa3df0065,0xfad6004f}},	//   _बाथ_, удов, _ताक_, נותך_
  { {0xf3f50086,0xe4e40036,0xa2cf000b,0x6ec6000b}},	//   _متشک, _вічн, _दिक्, ़ीनु
  { {0x64420152,0x6138002d,0x63050058,0xab5b0546}},	//   _gloi, _súlú, _موصل, _reün
  { {0xa3e8005d,0x63bb0841,0x93270015,0x60da015e}},	//   _बात_, mbun, _جران, artm
  { {0xa2d8005d,0xb0630020,0x63bb0842,0x7a1b003d}},	//   _मित्, äärt, lbun, _jātē
  { {0xdb1d0089,0xa01b0843,0x2bba0015,0x5d860015}},	//   _desí, rmör, فاءة_, الأل
  { {0x40950010,0x6e3c0844,0x6f160845,0x6bb5005e}},	//   _крыт, skrb, _tryc, исує
  { {0x63bb00b8,0xc0530008,0x6f160089,0xcaa60015}},	// [9e0] ibun, _לזה_, _uryc, اصري
  { {0xbf9b000a,0x20020846,0x996c003d,0x8f9b004f}},	//   _איפש, leki_, _vēža_, _איפי
  { {0x9c66002b,0x38cb002b,0x1e97000a,0x46c6000b}},	//   _مهدو, فانی_, _תכיל_, रीनह
  { {0x46a60010,0xdb1d0046,0xeef6000a,0x20020847}},	//   гадв, _zesí, ָמַר_, neki_
  { {0xa2cf000b,0x601b008c,0x929d002a,0x2907001a}},	//   _दिग्, _hämä, zwła, ænar_
  { {0xb5aa0029,0x6442002d,0x63bb00b8,0xa5f80848}},	//   راتك_, _sloi, ebun, теку_
  { {0xa3e8014e,0x7bc60849,0x6442084a,0xbf9b00aa}},	//   _बाद_, _keku, _ploi, ndêr
  { {0x53e60010,0x7658084b,0x200201d7,0xb509000b}},	//   уцка, sivy, jeki_, विजय_
  { {0x3855010f,0xc1ea008f,0x200201e2,0x41c604f7}},	//   _търс, ньне_, deki_, лёна
  { {0x64a60036,0x27e60123,0x06760033,0xc5d50033}},	//   _бажа, lgon_, _субя, _віць
  { {0xdb1d016e,0x601b008c,0x8936000a,0x64850030}},	//   _resí, _nämä, רָ֥א_, móin
  { {0x6485084c,0xa3bb0157,0x7bc6084d,0x27e6084e}},	//   lóin, _अभय_, _neku, ngon_
  { {0xa857013a,0x73360015,0x27e60034,0x90540033}},	//   ריכה_, _حرائ, igon_, свяц
  { {0x539b00a3,0xe731000a,0xdb1d016e,0xa194084f}},	//   _ניגו, חֵל_, _lesã, _калч
  { {0xe7a4014e,0xdd95008f,0x523b0053,0x56370053}},	//   _ओलंप, равы, _אײגנ, נאלע_
  { {0x200201e2,0x7bc601d7,0x5b270822,0x0000006a}},	//   ceki_, _ceku, льза,
  { {0xba55009c,0xe451000a,0xb09c004c,0xadd50054}},	// [9f0] авај, קֶל_, _איהר, _копљ
  { {0x63bb0045,0x5d550850,0x27e60079,0x5eec000a}},	//   zbun, _вкот, egon_, _נַחְ
  { {0x3eb90024,0x63bb005c,0x648503d9,0x7e9a000a}},	//   lpst_, ybun, dóin, _שסתו
  { {0x64b10048,0x63a20297,0x27e9007c,0x2ca5001a}},	//   _jāie, _ngon, üan_, íldu_
  { {0x291800d9,0xd00c0008,0x67d4000d,0x7c2b0020}},	//   _erra_, גּוֹ, сочу, ögru
  { {0xbada0008,0x6485002d,0x20020851,0x99870030}},	//   _בקשת, góin, zeki_, űnő_
  { {0xce38013a,0x7dd000dc,0x91f50092,0x15450286}},	//   ראות_, lósí, híc, рейм
  { {0xd3f90010,0x63a20125,0x7c2d0852,0x63bb0853}},	//   тэкі_, _cgon, njar, ubun
  { {0x787a000a,0xe4320015,0x63bb0854,0x3aef0061}},	//   _יָמו, تفيد, rbun, nüp_
  { {0x63bb0855,0x5b7c004c,0x7e0f000b,0x994a0061}},	//   sbun, ערזא, ायोग_, nışa_
  { {0xd567000d,0x1021005d,0xafdb0134,0x80660342}},	//   _стап, यांश_, dkøb, ивож
  { {0xdd2f0089,0x8464006b,0x7afd0856,0x3aef0061}},	//   _běže, _лъче, _opst, küp_
  { {0x387e038d,0x343a0053,0x64490857,0xa01b001a}},	//   _être_, _שײנע, mhei, rmöp
  { {0x69c70522,0x442d0858,0xa695000a,0x443f0859}},	//   _neje, lje_, יכָה_, lku_
  { {0x7afd0048,0x31790053,0x27e60026,0x7bc602e8}},	//   _apst, _באַד, ygon_, _peku
  { {0x62060024,0x44f10092,0xef1a0661,0x442d085a}},	//   ārlū, _mơ_, _ами_, nje_
  { {0x69c70014,0x207b0053,0x442d016f,0x64490437}},	// [a00] _beje, _באקא, ije_, ihei
  { {0x601b022d,0xa2d8005d,0x6f090064,0x442d0201}},	//   _tämä, _मिस्, çece, hje_
  { {0x443f0005,0x6449020a,0x4ddb0008,0x7bc6085b}},	//   kku_, khei, _בחיו, _teku
  { {0x1ae6005f,0xf0930053,0x64490111,0xca2900a3}},	//   _комм, ַנג_, jhei, ום_
  { {0x69c700dc,0x648500dc,0xa3df000b,0x442d085c}},	//   _feje, tóin, _ताज_, dje_
  { {0x442d005c,0xaa46085d,0x443f0340,0x91a7000b}},	//   eje_, _тегл, eku_, _फ़्लै
  { {0x44f10023,0x7ae4085e,0x6d4e0012,0x86070015}},	//   _cơ_, luit, nzba, شقيق_
  { {0x644900f6,0x6281085f,0x645b0045,0x18a3067a}},	//   ghei, ello, giui, _фатм
  { {0x2338005f,0xdc370053,0x77940086,0x55e60860}},	//   уппы_, שאפט_, _ایشا, _возб
  { {0x11d80029,0x443f0861,0x75d30015,0x442d0862}},	//   دودة_, aku_, _ويقا, aje_
  { {0x85060074,0x442d00bd,0x7ae4002d,0x8233006e}},	//   _خوان, bje_, huit, تريا
  { {0x442d0050,0x63a20863,0x68e30144,0x38660864}},	//   cje_, _ugon, àndi, nnor_
  { {0x11f80086,0xd372002b,0xfe7f0865,0x9316002b}},	//   _موشک_, _بهش_, juïc_, _خوشش
  { {0x7ae40866,0x234b002b,0x02fb000a,0x66fa003d}},	//   duit, _جسمی_, _סלומ, mākā
  { {0x69c70867,0x6c970015,0x7c970015,0x0ed3000b}},	//   _reje, لشرط, لشرا, _तिकड
  { {0xe517014e,0xb19b000a,0x219b000a,0xf19b000a}},	//   थिति_, _ביוכ, _בבוא, _בשוש
  { {0x7ae40868,0x228b003c,0x994a0061,0x66fa003d}},	// [a10] guit, søke_, tışa_, nākā
  { {0x443f0107,0x3aef0061,0xd2b7000a,0x442d0869}},	//   zku_, rüp_, ילמת_, zje_
  { {0x442d086a,0x69c7086b,0x35e0000b,0x6449086c}},	//   yje_, _veje, _नाज़, yhei
  { {0x7ae4086d,0x3ea90509,0xad1a000a,0xc864086e}},	//   buit, _kuat_, _עורר, отчи
  { {0x44f10023,0x3b640063,0x442d00bd,0x7ae40011}},	//   _sơ_, _дърв, vje_, cuit
  { {0xcb360008,0x85e8005e,0x443f002a,0x2fc90125}},	//   _הנשק_, идів_, wku_, _leag_
  { {0x3ea90011,0xd5ae00e6,0x6449086f,0xfdf8000a}},	//   _luat_, رفي_, thei, יצגת_
  { {0xa2d8005d,0x442d0870,0x44f10016,0x7bcd0871}},	//   _मिश्, uje_, _vơ_, naau
  { {0xa3e8005d,0x442d0872,0xd408002b,0x66fa003d}},	//   _बार_, rje_, شتيم_, gākā
  { {0xa2d8005d,0x82f40010,0xf8d9000a,0x44f10016}},	//   _मिर्, ічыц, ְחָמ, _tơ_
  { {0x8467010f,0x2fc9002d,0x65150029,0x867a000a}},	//   _къде, _beag_, _دوائ, _ערעו
  { {0xa3bb005d,0x3ea90375,0xd079005e,0x66fa003d}},	//   _अभि_, _buat_, исяч_, bākā
  { {0x14740029,0x91fc0024,0x6f630256,0x94740021}},	//   _بالج, onāl, звяз, _بدلا
  { {0x28d8005d,0x6d4e00b8,0x877a000a,0xf776004c}},	//   _डिलि, tzba, ראשי, מערי_
  { {0xc2120008,0x3205003e,0x6efd00c0,0x6f0d00e8}},	//   _זהו_, mely_, _påbö, _esac
  { {0xa01b00f2,0xb6030107,0x32050769,0x2fc900aa}},	//   llön, _hráč, lely_, _geag_
  { {0xfb8a0010,0x6d4e0030,0x3ed3012c,0xb603013f}},	// [a20] убак_, szba, _فقير, _kráč
  { {0x239b0007,0x88c60015,0x32050873,0x27ed00a6}},	//   mąjį_, متصل, nely_, _acen_
  { {0x39790010,0xa3e8005d,0x7ae40874,0x64590079}},	//   асцю_, _बाल_, suit, _omwi
  { {0xb17a0053,0x2bba0015,0x7ae40875,0xa2d80065}},	//   אטער, _حادة_, puit, _मिल्
  { {0x3205003e,0xd7f90036,0x38660876,0x46f603a9}},	//   kely_, рує_, rnor_, счет
  { {0x2bd0005d,0x91fc0024,0xe4b80010,0x8f9b000a}},	//   तःका, gnāl, алкі_, איני
  { {0x2a6f00dc,0x32050873,0x186a0877,0x78a00123}},	//   égbe_, dely_, _бави_, _timv
  { {0xfbdf0026,0x91fc0024,0x66fa0024,0xe8e00092}},	//   _llên_, anāl, tākā, _chụp_
  { {0x661100f2,0x6440002e,0x239b0007,0x320500da}},	//   ökkä, rkmi, jąjį_, fely_
  { {0xd6cf0029,0x64400020,0x66fa0024,0x92b30029}},	//   _أقل_, skmi, rākā, أحيا
  { {0x53160074,0x20120049,0x66fa003d,0xda7b000a}},	//   _گذار, _bayi_, sākā, רניר
  { {0xa2e60010,0x0eeb0342,0xf3f90045,0x3ea1007c}},	//   _годд, льги_, tiţe_, _siht_
  { {0xe3160015,0x05ac000b,0x28af000b,0xd6c6012c}},	//   _دباب, _चलाब, _जूनि, بق_
  { {0x6d14000b,0xb3850015,0x25fb000b,0x32050878}},	//   डिंग_, _بجمه, ल्पी_, cely_
  { {0x725b0008,0x463b0053,0x7bcd002e,0x60b4002b}},	//   _תכופ, נעלע, taau, _بمبئ
  { {0xe1650086,0xc334000a,0x91fc003d,0x4fb7002b}},	//   _بدهي, ֗וּ_, inām, _اصغر
  { {0x6a350124,0xc3340008,0x6008000a,0x0ab80015}},	// [a30] онађ, חוּ_, _הִתְ, مطلب_
  { {0x91f50092,0xa381007c,0x7bcd001a,0x27ed0879}},	//   hín, öõig, saau, _scen_
  { {0xa3e8000b,0xcdf6000a,0x25fb0065,0xc0b200a1}},	//   बला_, _ומתי_, ल्फी_, _rưởi_
  { {0xac19087a,0xb901005d,0x3205087b,0xb17b000a}},	//   _тому_, _दि_, zely_, נטאר
  { {0xb06600f2,0xcff8000a,0x1dbf000b,0x6675002b}},	//   ltää, מצאה_, ्रपत, يدتر
  { {0xf770087c,0x1a940010,0x79c9002b,0x4b7a000a}},	//   ران_, _наяў, _خوسف_, _כארו
  { {0x32050041,0xb066022d,0x91fc0024,0x2e3c0008}},	//   vely_, ntää, rnāl, רגונ
  { {0xb066008c,0x32050034,0x64a2006b,0xe4c80015}},	//   itää, wely_, маща, حبون_
  { {0x32050041,0xe7330031,0x52a6054f,0xb066008c}},	//   tely_, _عصر_, овым_, htää
  { {0xe4e70036,0x239b0091,0xa2bf000b,0x22920058}},	//   _гідн, vąjį_, लीग्, وليس
  { {0x386d018c,0x3205003e,0x53fb0029,0xcf89000a}},	//   _kjer_, rely_, _مرشح_, _סט_
  { {0xdb1d00f2,0x6459003f,0x44f3001c,0x60dc087d}},	//   _kesä, _umwi, mã_, árma
  { {0x02450015,0x2d85068c,0xc7f6000a,0x32450015}},	//   _وَصَ, ülen_, חזרת_, _ونصف
  { {0xa01b008c,0x239b0091,0xdca60076,0xdb160061}},	//   llöl, rąjį_, жави, rayü
  { {0xf3f904f9,0x2d8c087e,0x387f0061,0x7643058a}},	//   enţi_, åde_, _okur_, ikny
  { {0x4c860033,0xac8600fd,0x6fb60058,0xbca30058}},	//   ілав, ігал, _بمظا, ِمِي
  { {0xe7ff005d,0x49ca0001,0x8b260033,0xdcef003d}},	// [a40] ोजना_, илан_, ўдзе, ījāt
  { {0x5e570029,0x25fb000b,0xceb90046,0x387f01c2}},	//   _وليس_, ल्मी_, íře_, _akur_
  { {0xf3f90045,0xad59006b,0xba170015,0xd7ef087f}},	//   anţi_, _грях_, تيلا_, му_
  { {0x225e00bd,0xafad000a,0xfe7f0144,0x77860880}},	//   zitk_, ְיוֹ, nuïn_, олез
  { {0x6009000a,0x59c60015,0x7c260881,0x98a30882}},	//   מִסְ, _ويحك, _inkr, фице
  { {0x9633008f,0x386d0134,0x6b8b00dc,0xc4da0001}},	//   мніц, _ejer_, ügge, ађи_
  { {0x86750010,0x344a03e7,0xdb07001a,0x7e9b000a}},	//   чыцц, ичин_, élög, בססו
  { {0x9cd70008,0x3957000a,0x66e60883,0x7e7c0884}},	//   קופה_, _ושלם_, _моба, horp
  { {0xe3af0029,0x16660063,0xcc3b0053,0x213e0026}},	//   خرى_, _двам, שעפט, wyth_
  { {0x7af600df,0xb06600f2,0xa646002b,0x8afb0447}},	//   ityt, ytää, _بخرن, ספיק
  { {0xf21f005d,0xea420033,0x7c260885,0x6e370886}},	//   बाज़_, явiў_, _onkr, _roxb
  { {0x91fc003d,0xc05b00ce,0x0000006a,0x0000006a}},	//   onāk, ріо_,   ,
  { {0x889b000a,0x289b004c,0xdefb0033,0x64b1003d}},	//   יבטי, ייטא, шын_, _jāin
  { {0x3f850048,0xb06600f2,0x7c260887,0x5e450015}},	//   ālu_, ttää, _ankr, أَسْ
  { {0x91bb0008,0xdfdb006b,0xac950888,0xf3f90045}},	//   _דמוי, _къп_, завш, liţa_
  { {0x1bbb0029,0x2bbb0015,0xb066008c,0x8cdc000b}},	//   شارع_, شارة_, rtää, _फिरो
  { {0xe8df0092,0xb06600f2,0x4426003f,0xdce70064}},	// [a50] _thừa_, stää, _mno_, ğlıd
  { {0x539b0008,0x7c2600bd,0x7e7c0390,0xe9870054}},	//   שימו, _enkr, corp, оћен
  { {0x7af60007,0x3a38016b,0x99910046,0xf3f90045}},	//   atyt, _dorp_, _vozů_, hiţa_
  { {0xa6c90029,0x38350010,0x7d7a000a,0x3858005e}},	//   موصل_, янер, _לנתו, орію_
  { {0x9bb6000a,0x8707002b,0xc8c9002b,0x2b52002a}},	//   _מהרה_, تبال, _گوزن_, czyc_
  { {0xd1260029,0xbb3a0008,0x44260889,0xcb9a000a}},	//   _كم_, _העשי, _ano_, _לסרט
  { {0x044502e1,0x4dfc004c,0xc5080015,0x91fc003d}},	//   зейн, יפגא, قتيل_, anāk
  { {0x44f3016e,0x94790054,0x387f088a,0x69d80030}},	//   rã_, љску_, _ukur_, óvev
  { {0x78240058,0x4426088b,0x44f3059d,0x0000006a}},	//   _تعّل, _dno_, sã_,
  { {0x4426018c,0x3a36000a,0xe6800045,0x64aa0046}},	//   _eno_, ִ֨ים_, ălţă, _břid
  { {0x05190058,0xfe7f03a0,0x7e7c088c,0x0000006a}},	//   _دياب_, tuïn_, vorp,
  { {0x44d704f9,0xe8df0023,0xb4fa0008,0xa06a088d}},	//   mă_, _chứa_, _לפעי, сама_
  { {0x44d704f9,0x644b088e,0x7d1e088f,0x27ff002d}},	//   lă_, _ilgi, _srps, _mbun_
  { {0x629d0089,0x539a000a,0xb2ba000a,0x8756000a}},	//   ůsob, _פיסו, _המסר, לברג_
  { {0x44d704f9,0x44260176,0xc0d20015,0xa8bc0061}},	//   nă_, _yno_, _كيوب, örüş_
  { {0xdb0d002d,0x0baa0015,0x7c9500fd,0x5baa0890}},	//   acaí, صارى_, друц, скам_
  { {0x78bb016f,0xaa46000d,0x290300dc,0x9aa60015}},	// [a60] _čuva, пеал, _apja_, سماو
  { {0x7af6014c,0x3af40123,0xaccb002a,0x69960891}},	//   rtyt, räp_, _żółw, прех
  { {0xbe3b0008,0x44d70011,0x18a60892,0xe8fa0893}},	//   _העית, jă_, чаем, сле_
  { {0x44d70011,0xa3ea005d,0xafdb0293,0x2cac001a}},	//   dă_, _टाइप_, lhør, íddu_
  { {0xf7430894,0x8c1b000a,0x91fc003d,0xdd8f002b}},	//   нецо, _הוכי, unāk, _لوی_
  { {0x7bc40007,0x76a90036,0xceb3000a,0xf3f90045}},	//   lbiu, ітів_, עיו_, viţa_
  { {0x44d70011,0x69dc0895,0xdb070030,0xf8e00065}},	//   gă_, _idre, ömör, _पटिय
  { {0xb60303eb,0x64a3000d,0x68e30896,0xad1b000a}},	//   ēšan, наја, ánde, מוצר
  { {0x69ce064e,0xf3630010,0x96b90897,0x7ae40898}},	//   _kebe, етэн, _духу_, nrit
  { {0x64aa0089,0x44d70011,0xb6bb000a,0x25fb000b}},	//   _přid, bă_, _לצמי, ल्दी_
  { {0x44d704f9,0x55bb0008,0x7ae400b8,0x64b30089}},	//   că_, _המבו, hrit, _přiř
  { {0x69ce018b,0x6f04002d,0x44260899,0x7d1c06c0}},	//   _lebe, _bpic, _uno_, dvrs
  { {0x69dc052c,0xa8570008,0xa87b004c,0x9f60001a}},	//   _odre, ליטה_, מאטר, órðu_
  { {0x539b0008,0x8cb1005d,0x62660086,0xe04b002b}},	//   _הידו, _आंदो, _عاشق, _گشته_
  { {0x01fb0008,0x51fb0008,0xd2170008,0xab5b00dc}},	//   _הפול, _ההוצ, _זקוק_, _leüt
  { {0x3cf6000b,0x7ae4089a,0x69dc089b,0xfe70002b}},	//   ँढ़ें_, frit, _adre, ندۀ_
  { {0x44d70440,0x69ce013c,0x1dbf000b,0xfaf30015}},	// [a70] ză_, _bebe, ्रदत, عثر_
  { {0x19ab000d,0x69ce089c,0xab840004,0x200b089d}},	//   стап_, _cebe, хуск, leci_
  { {0x3d24008f,0x7ae4089e,0x629a0091,0x44d70045}},	//   _зьяв, arit, imto, xă_
  { {0xf990003b,0x44d70011,0x9cd60008,0xc19b0053}},	//   ابك_, vă_, _קורה_, זשבי
  { {0x200b005c,0x7ae4089f,0x8c1a000a,0xbc1a000a}},	//   ieci_, crit, _וורי, _וורש
  { {0x44d70440,0xcb120008,0xa5650086,0xff18000a}},	//   tă_, _שלם_, وگان, פקות_
  { {0xdb1d002c,0x78a20057,0x7bcf0049,0x6d550012}},	//   _nesú, ňova, _kecu, nzza
  { {0x44d704f9,0x4439002e,0x200b016f,0xa01b00c0}},	//   ră_, ðs_, jeci_, slöj
  { {0xd5b100a7,0x44d704f9,0x04560029,0x7d1c0796}},	//   _các_, să_, بلية_, zvrs
  { {0x44d70011,0xd5d5002b,0xe0d908a0,0x6145070c}},	//   pă_, _آقاخ, ово_, деоа
  { {0x7ae4002c,0x69c50125,0xd00a006b,0x6fd8006f}},	//   zrit, ibhe, оене_, júcí
  { {0x7ae400f2,0x7bcf0011,0xe3b30029,0xd05a005e}},	//   yrit, _necu, _أرض_, ірні_
  { {0x73c40015,0x63050015,0xe1ee033d,0x82350015}},	//   _أيهم, _آوتل, _иг_, _يرتا
  { {0xf2d20008,0x91fc0024,0x3d0a005d,0x0165023e}},	//   _יעד_, riāc, ाबले_, _окло
  { {0x7ae408a1,0x91ba000a,0x69ce08a2,0xbea308a3}},	//   writ, _ומצי, _rebe, тарк
  { {0x7bcf0011,0x69ce08a4,0x50590033,0x69c50030}},	//   _cecu, _sebe, _ншыя_, ebhe
  { {0xd5b10023,0xf0930008,0xfeba0086,0x7bcf08a5}},	// [a80] _xác_, _בנה_, _بابت_, _decu
  { {0xff5f038d,0x6aa70111,0xe8df0092,0x41ba004c}},	//   raît_, _cijf, _chữa_, ַזנװ
  { {0xa90a0029,0x27fd0026,0x38cb002b,0xfbc608a6}},	//   تيال_, ffwn_, قانی_, _обно
  { {0x313600b2,0xa3c3005d,0xab2a08a7,0xad1b000a}},	//   ונעם_, ्रफ_, _дома_, _ווטר
  { {0x39460024,0xa09b0135,0x69ce08a8,0x628308a9}},	//   ņos_, קינט, _tebe, _okno
  { {0xd5b10092,0x454a005e,0x69ce0012,0x27f2002a}},	//   _rác_, жчим_, _uebe, żyn_
  { {0xaaa7000b,0xe4d30015,0x69350046,0xdb0601d0}},	//   _कूटक, نتيب, _přeš, _afkø
  { {0x64aa0089,0xd7060001,0xe314000d,0xdb1d0077}},	//   _přib, _озби, емињ, _resú
  { {0x41e602e5,0x27f70015,0xb66a0004,0x64aa0046}},	//   міна, _تفقد_, _диаз_, _břic
  { {0xd25003c4,0xd6260196,0x51f80036,0xa50a0054}},	//   اند_, _تعري, чною_, _меза_
  { {0xa01b00f2,0x92570029,0x45460115,0x63b90034}},	//   llöi, بشير_, _تناق, _ffwn
  { {0xc32a003b,0xd5b10023,0xe58b004f,0xb84a0138}},	//   _وكان_, _tác_, _וָדָ, йлiв
  { {0x200b0064,0x20190020,0xa2d8000b,0x7bcf08aa}},	//   reci_, rdsi_, _मिट्, _recu
  { {0x200b044c,0x1cbb0015,0x7bcf08ab,0x44cc002a}},	//   seci_, قارب_, _secu, oś_
  { {0x320c069b,0x1df8056d,0x7bcf08ac,0x6ca708ad}},	//   medy_, ьеры_, _pecu, драж
  { {0x28d8000b,0xc173000a,0x320c0046,0xa3c3000b}},	//   _डिजि, _שחק_, ledy_, ्रय_
  { {0x7b6700d7,0xa3b3000b,0x7bcf003d,0x6d550030}},	// [a90] фтве, जुट_, _vecu, szza
  { {0x22f7000a,0x1600000b,0x996705c0,0x648508ae}},	//   וזמן_, ल्मर_, мтел, lóit
  { {0x6aa70111,0xa3c3021e,0x320c005c,0x44cc002a}},	//   _vijf, ्रम_, iedy_, jś_
  { {0x3858002b,0xbbeb002b,0x99830091,0x7ae2003d}},	//   وشند_, _بردم_, _sojų_, šota
  { {0x320c002c,0x6c56000a,0xe70b002b,0x44cc002a}},	//   kedy_, _נישא_, تتان_, eś_
  { {0x24510107,0x88c70015,0x59c50015,0x7aed0375}},	//   _máme_, _يتأل, _سيرك, muat
  { {0x7aed08af,0xfe38000a,0xf8b40033,0xd8770058}},	//   luat, ורגי_, _абсэ, _قارب
  { {0xdb1d0293,0x0000006a,0x0000006a,0x0000006a}},	//   _besø,   ,   ,
  { {0x25a90086,0x64aa0089,0x1306004a,0x44cc002a}},	//   _فضای_, _přic, еный_, aś_
  { {0xcb120008,0x291e0007,0x320c00da,0x05b80040}},	//   נלי_, _štai_, gedy_, _قدمت_
  { {0x50b50010,0x1a160053,0xb899000a,0xca36000a}},	//   эспу, ײַיש_, ּבָש, תנתה_
  { {0x7aed0049,0x351a000a,0xdee608b0,0xa924006f}},	//   kuat, _מוענ, номи, _ôžet
  { {0x644900b8,0x64aa0089,0x201e0089,0x2bd3000b}},	//   mkei, _třic, ěti_, तरना
  { {0x443d003e,0x644908b1,0x24510227,0x7aed08b2}},	//   _how_, lkei, _dáme_, duat
  { {0x644900f2,0x52380015,0x27e00030,0x28af000b}},	//   okei, _تسنح_, óink_, _जूलि
  { {0x7aed000c,0x301a0015,0x6da30054,0x78a908b3}},	//   fuat, _رتبة_, уиса, _niev
  { {0x3b07010f,0x644900f2,0x1600000b,0x7aed08b4}},	// [aa0] нето_, ikei, ल्डर_, guat
  { {0x9b93003b,0x443d003e,0x2fe8002a,0x5e460015}},	//   الكت, _low_, ługą_, _أَدْ
  { {0x6449022d,0xef180024,0x628108b5,0xd94302ed}},	//   kkei, āļu_, iolo, лефи
  { {0x443d003e,0x68e30077,0x7aed013c,0x78a9006f}},	//   _now_, ánda, buat, _ciev
  { {0x0c230063,0x68430010,0x91fc03e9,0x78a908b6}},	//   _смян, ынца, onāt, _diev
  { {0x25fb014e,0x246c0046,0x7bd608b7,0x16d00065}},	//   ल्ली_, měmi_, layu, _हबीब
  { {0xb8660029,0x443d08b8,0xc8660015,0xf5170015}},	//   _كارو, _bow_, _كطري, فتيش_
  { {0x6449018b,0xd6d200e5,0x628108b9,0x85030021}},	//   gkei, _مقر_, eolo, اوين
  { {0xa3b70029,0x0edc000b,0xc7d7000a,0x4c9b000a}},	//   راير_, _बिगड, _רומי_, השקע
  { {0x644900df,0x2451006f,0xdb070003,0xf92a000a}},	//   akei, _ráme_, élég, ִוָּ
  { {0xc5f3000a,0x75d30015,0xd4c50033,0x320c08ba}},	//   _תדע_, _إيما, _асіп, redy_
  { {0xa3c3005d,0xd2500086,0x386608bb,0x1957000a}},	//   ्रण_, انگ_, nior_, תבטל_
  { {0xc43b0008,0xe29a0063,0x6485002d,0x2d8c0405}},	//   _מתאי, _еад_, róit, üden_
  { {0x661a022d,0x23690015,0xbea40033,0x44fa00aa}},	//   _jatk, _تحمي_, лаўк, oë_
  { {0xdcb10023,0x7c3d08bc,0x6ce4005e,0x661a08bd}},	//   ể_, _posr, літе, _matk
  { {0xdddc0046,0x7aed0043,0x661a08be,0x64850030}},	//   borů, tuat, _latk, lóir
  { {0xeab300a2,0xde79006b,0x49d90033,0x648b000a}},	// [ab0] اعر_, _обич_, ддзю_, פְלְ
  { {0x83fd00dc,0x78a908bf,0xbae40015,0x60cd002a}},	//   lnőt, _siev, اكلي, _łami
  { {0xdd9104b6,0x78a90048,0xd5b10092,0x7aed08c0}},	//   _خود_, _piev, _bán_, suat
  { {0x6485002d,0x386602b9,0x8c44012e,0x628108c1}},	//   hóir, gior_, _беџе, zolo
  { {0xdb0700f2,0xd5b10092,0x44fa00dd,0xab5b0111}},	//   ämäs, _dán_, eë_, _geüp
  { {0xa5090083,0x443d00d9,0xceb40008,0x99d40002}},	//   дека_, _sow_, איס_, _متفا
  { {0x6485002d,0xd61800a2,0x443d08c2,0xa01b001a}},	//   dóir, عتها_, _pow_, llöu
  { {0x6281002a,0x38660045,0xd5b10016,0xed6401c0}},	//   wolo, cior_, _gán_, loží_
  { {0xf7730029,0x644908c3,0x8c1c000a,0xc7b2000a}},	//   _صار_, rkei, לוהי, _כבן_
  { {0x6485002d,0x644908c4,0x629804b2,0xe607008c}},	//   góir, skei, _chvo, äpää
  { {0x2127002b,0x443d08c5,0x628108c6,0x8a16004f}},	//   ريحی_, _tow_, rolo, דחתו_
  { {0xa3d2014e,0x200404af,0xf76700e6,0x91fc0024}},	//   वरण_, ými_, لا_, liāl
  { {0x60c400bd,0xb7da000a,0x249f001a,0x6d47001a}},	//   _čime, וקרי, mmum_, eyja
  { {0x3f8c0024,0x9f6100dc,0x63bb08c7,0xfce6006d}},	//   ādu_, ását_, lcun, кого
  { {0x7bd60035,0xc5f2000a,0x9c860015,0x957c002a}},	//   tayu, ידם_, نشره, _idąc
  { {0x3ce500dc,0xa3c3000b,0x0701000b,0x248d0061}},	//   álva_, ्रि_, लझाव_, nlem_
  { {0x3866003e,0x248d08c8,0xcb6708c9,0x6e3e08ca}},	// [ac0] vior_, ilem_, вате_, _topb
  { {0x6fa7000b,0x3cea000b,0xae9a0015,0x7bd608cb}},	//   _गणतं, _छिपे_, _تضبط_, sayu
  { {0xfe370008,0xa3c3021e,0x661a08cc,0x6c860015}},	//   _סרטי_, ्रा_, _ratk, _للدم
  { {0xd5b10023,0xb90a005d,0x60dc00dc,0x83fd00dc}},	//   _báo_, _मि_, ármi, inős
  { {0xd5b100a7,0x69ca0084,0x2ca00020,0x248d08cd}},	//   _cáo_, ðfes, mmid_, dlem_
  { {0xe7370001,0x2ca0007c,0x44fa08ce,0x629d08cf}},	//   тељ_, lmid_, të_, ïsol
  { {0x386600c0,0xa2d4002b,0xd6270054,0xbf9b00aa}},	//   pior_, گيخت, тоје_, neêr
  { {0x7467004a,0x248d08d0,0x291808d1,0x661a08d2}},	//   крыв_, glem_, _isra_, _watk
  { {0x6d470050,0x2ca0002d,0xdb0d001c,0x6485002d}},	//   zyja, imid_, rcaç, tóir
  { {0x91fc0048,0xe731000a,0xae04000b,0xe61a005e}},	//   ciāl, _לֵב_, श्मन_, _іде_
  { {0x672208d3,0x248d08d4,0xd657000a,0x24f60033}},	//   lvoj, blem_, _שיבת_, _шчар
  { {0xdb040467,0x64850125,0xd8db000a,0x60da08d5}},	//   nció, sóir, וקטר, rstm
  { {0xf09f0251,0x733600e5,0xdb040077,0xb3e90015}},	//   rmà_, _جرائ, ició, _أعمل_
  { {0x2ca00020,0xc6940053,0x52d70008,0x672208d6}},	//   emid_, טאָ_, _יודע_, ivoj
  { {0xdb0400dc,0x7e670079,0x4fc708d7,0x6722005b}},	//   kció, rijp, _испа, hvoj
  { {0x30a40010,0x57cc000b,0x5577004c,0x09cb000b}},	//   _крыв, ारोह, דעלן_, िर्य
  { {0x6e450029,0xddc700bc,0x0bb4008b,0x69d708d8}},	// [ad0] _منظم, anjš, рбую, taxe
  { {0x2ca00020,0x68e30387,0x672202c6,0x64850125}},	//   amid_, ándo, dvoj, hóip
  { {0xb8b40029,0xa3d2000b,0xc7b10015,0x249f001a}},	//   لإنت, वरा_, مّا_, ymum_
  { {0x69ca002e,0x7ce8000a,0xa01b08d9,0x0000006a}},	//   ðfer, _בַשֶ, mlös,
  { {0x64aa0089,0xa01b00f2,0xa3c3000b,0x7c2f0390}},	//   _přin, llös, ्रस_, _incr
  { {0xe29a00a7,0xdb040467,0xf3f904f9,0xcb120008}},	//   _như_, ació, miţi_, _הלך_
  { {0x91fc0048,0xf3f90011,0x58d408da,0x79a4012e}},	//   riāl, liţi_, _вост, _врте
  { {0xdb040467,0x63bb0003,0xc9840054,0x0574012c}},	//   cció, ucun, _ђури, جاهد
  { {0x69d50014,0xf3f90011,0x2c36004c,0x64aa0046}},	//   _keze, niţi_, אָים_, _třin
  { {0x248d08db,0xa3c3021e,0x25ed000b,0xe29a0016}},	//   slem_, ्रह_, _घाटी_, _chư_
  { {0x10a608dc,0xa855000a,0x69d508dd,0xfe7f0144}},	//   лион, ָיָה_, _meze, nuïu_
  { {0xcea900b2,0x69d50111,0xf992000f,0x7f1a01f3}},	//   _זי_, _leze, מרי_, нігу_
  { {0xe28e08de,0xa2e5007a,0xeef60033,0x643a000a}},	//   _га_, _солд, ыянэ, _רעננ
  { {0xa01b00b8,0xe732000a,0x8234002b,0xf3f90045}},	//   flös, צֵר_, _پرها, diţi_
  { {0x2d8c0134,0xc236000a,0xdc9a0004,0xed5a08df}},	//   æde_, _תרצו_, еташ_, хов_
  { {0xfe7f08e0,0x2ca0007c,0x61f10045,0x6d41008c}},	//   duïu_, umid_, şelă, älaa
  { {0x69d508e1,0x70530086,0x2ca00020,0xf3f90045}},	// [ae0] _beze, _دنيا, rmid_, giţi_
  { {0xa01b0123,0x7c2f08e2,0x2ca008e3,0x442f08e4}},	//   slöt, _encr, smid_, _lng_
  { {0x2d8500dc,0xbd460015,0xd910002b,0x69d508e5}},	//   ület_, _إنجي, غیر_, _deze
  { {0xf3f90045,0x97c50015,0x3e6d00bf,0x2814009a}},	//   biţi_, لتهم, ržte_, شوتس
  { {0xdb0402c1,0x4c79000a,0xd7a9002b,0xe0c7002b}},	//   rció, _יָשׁ, ندهٔ_, _گز_
  { {0x442f08e6,0xdd250024,0x9f97000a,0xb9c50015}},	//   _ang_, līša, נדסה_, _نتفه
  { {0x20d1018c,0xdb0408e7,0xdcfe0024,0x7a410046}},	//   jši_, pció, _izpē, _dítě
  { {0xdd250024,0x6d5c003d,0x20d105ca,0x0000006a}},	//   nīša, izra, dši_,
  { {0x15f60115,0x76410030,0x91a90016,0xdc370643}},	//   _مساح, _foly, _đá_, ראפט_
  { {0x76410176,0xda14000b,0xcb13000a,0xd4d60033}},	//   _goly, ड़ित_, צלת_, _бідэ
  { {0x74130086,0x2d8c005c,0x3a370008,0xd48f0758}},	//   _گونا, żdej_, ארים_, _гр_
  { {0xd0e5000b,0x4254002b,0xd3ba005e,0x78a20077}},	//   _किरण_, انگر, _чужі_, nmov
  { {0xe29a0023,0xdd250048,0x2618000b,0x7413012c}},	//   _thư_, dīša, फ़पी_, _دونا
  { {0x98bc0089,0x33930015,0xf3f90045,0x20d100bc}},	//   ávě_, _الهز, viţi_, bši_
  { {0x442f0176,0x3d0f014e,0xfe7f08e0,0x78a200bd}},	//   _yng_, ाबें_, duït_, kmov
  { {0xf3f904f9,0x859b0008,0x78a2016f,0xac1808e8}},	//   tiţi_, תשלו, jmov, лосу_
  { {0x909800b0,0x4c940731,0xa01b08e9,0x9aa50015}},	// [af0] _حضور_, ситс, slös, لمرو
  { {0xf3f904f9,0x7f9c000a,0xa01b0123,0x9f400012}},	//   riţi_, _אבחז, plös, _heiß_
  { {0xf3f904f9,0x98510050,0x64aa0089,0x69d508ea}},	//   siţi_, nąć_, _přil, _veze
  { {0xdddc0011,0xf3f90011,0x69d508eb,0x64420150}},	//   porţ, piţi_, _weze, _nooi
  { {0x7bda009d,0x2d9c006f,0xfe7f0144,0x1707002b}},	//   _בקרו, _úver_, buït_, افتی_
  { {0xb5c20036,0xdebc000a,0x7bcd01f1,0x7aed08ec}},	//   ойшл, עמול, lbau, mrat
  { {0xe3b1003b,0x7a410089,0x9851005c,0x764108ed}},	//   يرة_, _vítě, jąć_, _voly
  { {0x13090191,0x2901002d,0x20d1044c,0xa8a40033}},	//   вний_, mtha_, vši_, _грук
  { {0x644200dd,0x76410007,0xf7940033,0x44230046}},	//   _dooi, _toly, _гатэ, ěj_
  { {0x2480010b,0x7aed08ee,0xdd25003d,0x02020033}},	//   čima_, irat, zīša, озьн
  { {0x27e0002e,0x3d0f000b,0x7aed08ef,0xdddc0085}},	//   ðing_, ाबों_, hrat, jorš
  { {0xa06a0001,0xe53a000a,0x8235002b,0xff2601c5}},	//   тама_, _בתער, ارکا, аммо
  { {0x083a0053,0x8db6005e,0xef1708f0,0x7aed0030}},	//   דערל, исві, амя_, jrat
  { {0x7aed08f1,0x8cb1000b,0xf2d00015,0x7bcd0012}},	//   drat, _आंखो, _رآه_, ebau
  { {0xdd250048,0xabd60001,0x7bcd00b8,0xada608f2}},	//   tīša, ицај, fbau, равл
  { {0x417a0008,0xe588000a,0x672908f3,0x7aed08f4}},	//   _שנקב, רָשָ, _orej, frat
  { {0xfe7f0251,0x2d8508f5,0x290108f6,0xdd25003d}},	// [b00] tuït_, üler_, etha_, rīša
  { {0xdd250024,0x6edb000a,0x9958006f,0x09e608f7}},	//   sīša, _שחיפ, ráža_, рожн
  { {0x2901002f,0xaa7b0089,0x1bea0004,0x672908f8}},	//   gtha_, _svýc, _идни_, _arej
  { {0xafdb0134,0x64aa0089,0x4d7b000a,0x2bba0015}},	//   lkør, _přim, _יריע, _جادة_
  { {0x2bd3005d,0x2901002d,0x78a20057,0x6442042f}},	//   तररा, atha_, rmov, _rooi
  { {0x3916002b,0x672908f9,0x78a208fa,0x24e6009b}},	//   _پورز, _drej, smov, ациг
  { {0x98a60036,0xd5b908fb,0x25080086,0x2901002d}},	//   _виве, усі_, ارتی_, ctha_
  { {0x3205003e,0x91680092,0x9418004a,0x44a30015}},	//   efly_, _lực_, ужит_, يموق
  { {0xa2b3004a,0x72d70033,0xd1ca08fc,0x672908fd}},	//   обыч, адыё_, кунд_, _grej
  { {0xd5d8000a,0xdcfe002a,0x26c00045,0x166308fe}},	//   _תַּש, _wypę, ţios_, _двум
  { {0x91a900a7,0x6729002c,0x6f0d08ff,0xe1660015}},	//   _đã_, _zrej, _spac, شددي
  { {0x90e70015,0x506701e1,0xb4fb004f,0x7aed0900}},	//   جَّل_, ртоа, _ילבר, yrat
  { {0xd2520015,0xfe7f0144,0x0000006a,0x0000006a}},	//   _ونص_, duïr_,   ,
  { {0x69d80084,0x9f4000b8,0x2d840064,0x7ea000b8}},	//   ðvel, _weiß_, ğmen_, höpf
  { {0xdd950010,0x929b000a,0xa3bd000b,0x7ea00012}},	//   савы, _שיות, _आलम_, köpf
  { {0x228b003c,0x31570008,0x7aed0901,0x6e95002b}},	//   søkt_, _כיון_, trat, _گلخا
  { {0x7bcd0048,0x64aa0089,0x907c0008,0xdb990902}},	// [b10] rbau, _přij, _שטחי, увач_
  { {0xe9ab0074,0xab840431,0x62880903,0x7aed0904}},	//   ندان_, цуск, nodo, rrat
  { {0x3d24004a,0x39470045,0x7aed0905,0xd8b80058}},	//   _дьяв, âns_, srat, لدنا_
  { {0x67290906,0x29010541,0x8c19000a,0x7aed0907}},	//   _prej, rtha_, _גוֹי, prat
  { {0xdd280048,0xd00c000a,0xdc360643,0x070900c3}},	//   mēša, דּוֹ, _הארט_, ايتي_
  { {0xdd280048,0x3eda0053,0xb607087a,0x2901002d}},	//   lēša, אַקא, рядк, ptha_
  { {0xd4690848,0x8938005e,0x99140015,0xddd50091}},	//   лике_, _кпрс_, _وبفض, enzū
  { {0x9cd80008,0xdd280024,0xa4840015,0xd5b10016}},	//   בוהה_, nēša, يجين, _mái_
  { {0x6729018c,0x62880176,0x9f440064,0x82350067}},	//   _urej, fodo, ümü_, مردا
  { {0x8b580008,0xe7300015,0xf6530015,0x62880908}},	//   ייחס_, _تصف_, _بئر_, godo
  { {0xf5950115,0xd6980033,0xdd28003d,0x32050909}},	//   _الاج, _лiто, kēša, rfly_
  { {0xa2d2002b,0x2056090a,0x7ae20160,0xb7bd00d4}},	//   _کيوت, стор, šoti, _faţe
  { {0x443f0024,0xdd280024,0x316b005c,0x8779004c}},	//   mju_, dēša, ńcz_, ראָי
  { {0xddc3023e,0x93940015,0x443f090b,0xc332000a}},	//   збри, _بجما, lju_, _מוד_
  { {0x91680092,0xc6920135,0xdd920002,0x6e930015}},	//   _vực_, פאל_, سور_, سلفا
  { {0x443f090c,0x645b0111,0xd5b10092,0x78a3016b}},	//   nju_, nhui, _cái_, ïnvl
  { {0x4e7a0029,0x8c430661,0xcff7004f,0x0000006a}},	// [b20] _محدد_, чете, _הצפה_,
  { {0x443f0020,0x64aa0089,0xda660015,0x7aeb0030}},	//   hju_, _přik, حاري, ágta
  { {0xcdb7000a,0xa96a0015,0xafdb00cb,0x645b0079}},	//   _לפיה_, دمام_, sjøe, khui
  { {0xdd280024,0xb7d70015,0x6288090d,0x0000006a}},	//   cēša, موما_, zodo,
  { {0xeb750010,0x6288003f,0x443f01a3,0xcc8a002b}},	//   _дырэ, yodo, dju_, _لنگه_
  { {0x89f5008f,0x7c24090e,0x443f090f,0x8f9b000f}},	//   _мясц, ldir, eju_, ניסי
  { {0x89db0008,0x62880910,0xa2da000b,0xba57000a}},	//   _תחלי, vodo, पीन्, _פסלו_
  { {0xa3a9005d,0x6288005c,0x63bc0089,0x24800796}},	//   _गृह_, wodo, ěrno, čimo_
  { {0x7c24003f,0x35fa012c,0x62880911,0x55e60912}},	//   idir, _مراد_, todo, _гозб
  { {0xdd280024,0x628800f2,0x69de0913,0xb6bb000a}},	//   zēša, uodo, nape, _עצבי
  { {0x443f00bd,0x212a002d,0x62880914,0x7c240915}},	//   bju_, íbh_, rodo, kdir
  { {0x62880916,0x32020089,0xa4b7000a,0x7537000a}},	//   sodo, řky_, _הלאה_, _לאבד_
  { {0x7c240026,0xdd280024,0x69de0917,0x62880918}},	//   ddir, vēša, kape, podo
  { {0xdce5002c,0xc2c4002b,0x69de0919,0xd0d4006b}},	//   _vzhľ, _هيچي, jape, _докъ
  { {0x64aa02d5,0xdd280024,0x2600000b,0x20040144}},	//   _přih, tēša, _रानी_, òmic_
  { {0xa177000a,0x60c7091a,0x2177000a,0x3cec0030}},	//   _לעוד_, íjme, _לתור_, ádva_
  { {0xdd280048,0xeabf0016,0xda14000b,0xe9d90004}},	// [b30] rēša, _trùm_, ड़ंत_, имач_
  { {0x7b740029,0x443f00bd,0xdd280024,0x7f3c000a}},	//   أطفا, zju_, sēša, _תעזו
  { {0x39150015,0xd5b10016,0xdd28003d,0x984b091b}},	//   تواز, _tái_, pēša, ляда_
  { {0x19a8091c,0x987c0046,0x69de0601,0x6446008c}},	//   ступ_, bíč_, aape, ökil
  { {0xac240033,0x443f091d,0x29d50015,0x7b080046}},	//   _эфэк, vju_, _ويحس, ěstí
  { {0xdb1d01d1,0xd6290724,0x8f9c000a,0x8f8c000a}},	//   _besö, роке_, אידי, נְאֵ
  { {0xf5320083,0x443f091e,0x645b091f,0x2eb5000b}},	//   дејќ, tju_, thui, ंदुत
  { {0x94790001,0x9cd8000a,0x443f0073,0x645e0073}},	//   јску_, זוהה_, uju_, ūpin
  { {0xa5f90001,0x645b0161,0xd7c80015,0x92390920}},	//   _везу_, rhui, _طوله_, ачну_
  { {0x645b0921,0x7bdf0140,0xdd1c013f,0x7c2406d1}},	//   shui, haqu, váže, zdir
  { {0x93270086,0x443f0922,0xf4870923,0x61450924}},	//   _گران, pju_, _лудн, цена
  { {0x78fa00a3,0x6d4e006f,0x1faa0925,0xbbb8000b}},	//   ספרו, vyba, икни_, _अलेक
  { {0x92b700a2,0x9327002b,0x7c240926,0x1600000b}},	//   _احصا, _دران, vdir, ल्कर_
  { {0xdd1c01cb,0xda0b000b,0xa3c3000b,0x7ea00123}},	//   ráže, स्मत_, ्रक_, köpe
  { {0xa3bd0157,0x69de0927,0xa247009a,0x7bdf059d}},	//   _आला_, vape, _نیکل_, faqu
  { {0xdb1d0928,0x69de08cf,0x6d4e0929,0xe93a009a}},	//   _lesõ, wape, ryba, یسات_
  { {0xf412011f,0x69de092a,0x7c24092b,0x4a46071f}},	// [b40] ופן_, tape, rdir, онав
  { {0x224700aa,0x499601ca,0x19960099,0x7c24092c}},	//   _jonk_, ошет, ојер, sdir
  { {0xdd0f01e2,0x8c46092d,0x2f04002e,0x6bd60029}},	//   mışt, _дене, lög_, _وتحر
  { {0xdd0f01e2,0x394700c0,0xc1720008,0xca29000a}},	//   lışt, änsa_, וחב_, כם_
  { {0x69de029e,0xc6f700fd,0xd7f9005e,0xc07b004c}},	//   pape, жніх_, сує_, סטנש
  { {0xf4ea0080,0x25080086,0x8f9b0135,0x7ae4092e}},	//   афий_, مربی_, ביני, msit
  { {0xd90d0074,0x7ae4092e,0x26000065,0xd5af0058}},	//   _میل_, lsit, _राठी_, نفه_
  { {0xfc570053,0x87060015,0x69dc092f,0xdb1d007c}},	//   ַביש_, _وبذل, _here, _eesõ
  { {0x69dc0930,0xdd0f0064,0x2f04001a,0x91fc03e9}},	//   _kere, kışt, jög_, mnāz
  { {0x2451002d,0x7bdf001c,0xdb210030,0x3cf80789}},	//   _lámh_, zaqu, étév, kurv_
  { {0xd257008f,0x69dc0931,0xa9bb0053,0x7ae40125}},	//   іць_, _mere, יזיר, hsit
  { {0xe0cf0086,0x66180932,0xdfd8006b,0x50670033}},	//   کزی_, levk, жър_, ітна
  { {0x2005005c,0x94a90015,0xf487002b,0x7bdf0933}},	//   ęli_, _اطلق_, _بالی, vaqu
  { {0x2489002c,0x479b000a,0x69dc0934,0x7ae40935}},	//   čame_, ייכס, _nere, dsit
  { {0x7648005c,0x16d7000b,0x7bdf0936,0xec6b0937}},	//   _mody, _डब्ब, taqu, арак_
  { {0x69dc04ed,0x415b0008,0xa068009c,0x3ced0796}},	//   _aere, _כדוג, _маја_, čev_
  { {0xc3340008,0x764500f2,0xb606002c,0x7ae40938}},	// [b50] הוּ_, öhyk, _kráľ, gsit
  { {0x76480026,0x69dc0939,0xeaf80015,0x2019093a}},	//   _nody, _cere, ترفت_, lesi_
  { {0x7ae4093b,0x4815093c,0x3983002b,0x2d870003}},	//   asit, змес, ذیرف, _âne_
  { {0x9d1a013a,0xb17b00b2,0x765a093d,0x8cf40033}},	//   _פורט, סטאר, _alty, _ўзяц
  { {0x27e00084,0x4c3a0008,0x69dc093e,0xd5b10016}},	//   ðina_, _התרב, _fere, _lát_
  { {0x2ca90020,0x3aba000a,0xa7380015,0x2aba000a}},	//   lmad_, _למשנ, تثمر_, _למשא
  { {0x67d50139,0x2019093f,0x7bdd0375,0xe4510015}},	//   _нову, kesi_, _kesu, فضة_
  { {0x4d7c0008,0x69c50940,0x7d7c01ac,0x20190941}},	//   ירוע, lche, ינוו, jesi_
  { {0x69dc01e2,0x76d50115,0x7bdd0942,0x2ca9007c}},	//   _yere, _رياض, _mesu, imad_
  { {0xddce0024,0xd5b10016,0x2019008c,0x69c5010c}},	//   ribū, _sáu_, eesi_, nche
  { {0x69c5018b,0x20190943,0x2618000b,0x867a000a}},	//   iche, fesi_, फ़री_, _פרעו
  { {0x7bdd0944,0xd59a0008,0x859a0008,0x2d840064}},	//   _nesu, _הבעל, _השעו, şmek_
  { {0x64aa0089,0x24510089,0x749a004c,0xdd0f0061}},	//   _přiv, _námi_, _פינפ, tışt
  { {0x2f04087d,0xe2980484,0x2ca9007c,0x7524003d}},	//   rög_, _даі_, emad_, āizv
  { {0x61e10945,0x7bdd018b,0x6da30292,0x6abd00b8}},	//   mall, _besu, еира, _ausf
  { {0x0d99008f,0x248d00dd,0x2ca9016f,0x69c50220}},	//   ітры_, noem_, gmad_, eche
  { {0xdd0f0064,0x7bc40946,0x7ae40947,0x2d9e0227}},	// [b60] pışt, rciu, usit, ťte_
  { {0x7bc404ed,0xada6009c,0x61e10948,0x2d8c007c}},	//   sciu, _напл, nall, üdes_
  { {0x764800df,0xda02005d,0x7bdd0026,0x5dbb000a}},	//   _rody, र्गत_, _fesu, _לזיה
  { {0xc8650029,0x717a0053,0x69dc0949,0x7bdd094a}},	//   وطني, זנעס, _were, _gesu
  { {0x387f00c0,0x61e1094b,0xdc8b000a,0x4adb000b}},	//   _djur_, kall, _לְךָ, मीदव
  { {0x6594000d,0x69c5094c,0x61e1094d,0x78bc0607}},	//   малу, cche, jall, _turv
  { {0x20c10023,0x20190064,0x7c2600bd,0x7bdd00e8}},	//   _nói_, yesi_, _kakr, _yesu
  { {0x6d41008c,0xa97b000a,0x04630342,0x297b004f}},	//   älai, _האלכ, етьм, _הטלא
  { {0x6618002c,0x6720016f,0xd5b10092,0x61e1094e}},	//   pevk, _usmj, _sát_, fall
  { {0x201900e8,0x3f850064,0x21540033,0x20c10016}},	//   wesi_, şluk_, дкоў, _bói_
  { {0x69c300bd,0x2019094f,0x92570015,0x20d30033}},	//   žneg, tesi_, ثشير_, ніўс
  { {0x2bb8000b,0x853b000a,0x653b000a,0x34aa0054}},	//   _अलगा, _לגבי, _לעבד, _увео_
  { {0xaa7b0089,0x8fe40010,0x20190950,0x61e10951}},	//   _svým, эцэд, resi_, ball
  { {0x61e10952,0x7bdd0849,0x20190953,0x44260954}},	//   call, _sesu, sesi_, _hao_
  { {0x44260955,0x8d770087,0x4c950956,0x20c10016}},	//   _kao_, ساسا, дивс, _gói_
  { {0x7c2600e8,0x317b000a,0x5c990033,0xfad9006b}},	//   _cakr, _לרומ, ікая_, ждащ_
  { {0x7643005c,0x2d8c00b8,0x69c50957,0xb606006f}},	// [b70] yjny, üder_, tche, _zráž
  { {0x27e00084,0x24510089,0x68e30011,0x44260958}},	//   ðinn_, _vámi_, ândo, _lao_
  { {0x291903c4,0xa01b002e,0x69c502ff,0x91bb000a}},	//   تقاد_, rnöf, rche, צמאי
  { {0x69c50959,0xd75900e6,0x4426095a,0x779907d1}},	//   sche, يلات_, _nao_, окер_
  { {0x69c5002d,0x7995005c,0xba7700a2,0x7ea00123}},	//   pche, _wyzw, _فاست, löpa
  { {0x7c26095b,0x4efc000a,0x8f9c000a,0xbb3a000a}},	//   _zakr, מהדו, ציגי, _ועשי
  { {0x44260023,0x7c3a002d,0x61e1095c,0x55040054}},	//   _bao_, _úcrá, vall, ечња
  { {0x44260023,0x45180036,0xe8940010,0x8d5c000a}},	//   _cao_, яція_, _зась, מכוי
  { {0xe73f001c,0x59e1005d,0xb6060046,0x61e1095d}},	//   _çõ_, _फ़ार, _sráž, tall
  { {0x25a00089,0x81bc003d,0x60e9076f,0x6304009a}},	//   řila_, ldēj, омом_, روپل
  { {0x64aa0089,0x4426095e,0x35550015,0x61e1095f}},	//   _přit, _fao_, _تناز, rall
  { {0xd36e0074,0x81bc003d,0x61e10960,0x387d0034}},	//   اهی_, ndēj, sall, nnwr_
  { {0x81bc0024,0xd12e002b,0x61e10961,0xb066008c}},	//   idēj, همی_, pall, erää
  { {0x44260962,0x644b0026,0xe0d9005e,0x11f5002b}},	//   _zao_, _hogi, _двк_, _آتشگ
  { {0x4426003f,0x90460029,0x7c260963,0xc69200a3}},	//   _yao_, _ينته, _pakr, דאם_
  { {0x27ed0964,0x44260016,0x7188004f,0x26cd0160}},	//   _nden_, _xao_, _מְפַ, _oteo_
  { {0xeb970965,0x644b08f8,0x0a4a0033,0x7c2600cb}},	// [b80] дит_, _mogi, озай_, _vakr
  { {0x248000bd,0x7c26003f,0x39ea005e,0x63bc0046}},	//   čimi_, _wakr, ідео_, ěrni
  { {0xa806008f,0x7c260966,0x387d0034,0xa3c2000b}},	//   дзел, _takr, fnwr_, ्डम_
  { {0xd7ef0015,0xd6d20015,0x649e0079,0xdb0d00bf}},	//   لكم_, نقص_, eëin, škán
  { {0x47360029,0xda660015,0xdd8f002b,0xdb1d02de}},	//   براز, _قاسي, _موی_, _afsæ
  { {0x44260023,0xdd1d0107,0x27ed0967,0xceb3000a}},	//   _sao_, lášt, _eden_, ֣יו_
  { {0x44260968,0x34940969,0x644b096a,0x7af601d0}},	//   _pao_, накр, _bogi, lryt
  { {0x7af6005c,0xfc3f0016,0xd4970033,0x4cbb000a}},	//   oryt, _khía_, мры_, חזקו
  { {0xb2860010,0xd7030063,0x84ea000b,0xd5cf0065}},	//   дынк, _изти, _टिकट_, _स्वज
  { {0x64aa0089,0x6579002d,0x4426003f,0xf6260036}},	//   _přis, ábhá, _wao_, _ідео
  { {0x442600b6,0x09f7013a,0x55bb000a,0x99f7000a}},	//   _tao_, ומים_, _ומבו, וזיה_
  { {0xdbd60209,0x644b096b,0x7af6096c,0x781c000b}},	//   _jääd, _gogi, kryt, _नसोक_
  { {0xfe730002,0xd5b10016,0x9343096d,0x0000006a}},	//   ندس_, _háp_, _инце,
  { {0x7ea000f2,0x539b000a,0x72040015,0x7af6002a}},	//   töpa, _וידו, _أوغم, dryt
  { {0xdd94008f,0x01fb0008,0x387d0026,0x51fb000a}},	//   вары, _ופול, ynwr_, _והוצ
  { {0xaa7b0046,0x629a096e,0x0000006a,0x0000006a}},	//   _zvýh, llto,   ,
  { {0xda67003b,0xf0940008,0x5a350063,0x5b150010}},	// [b90] وائي, _בנק_, ннат, эмат
  { {0x99d40015,0x2600000b,0x7ea00123,0x51b6004f}},	//   نتما, _राषी_, löpn, ֵּ֑ן_
  { {0x7af60091,0xceb4000a,0x2907096f,0x629a0970}},	//   aryt, _ביץ_, îna_, ilto
  { {0xc19b0008,0x7af60971,0x81bc003d,0x63a20972}},	//   חשבי, bryt, udēj, _ozon
  { {0x6d5500dc,0x387d0026,0xa3c2000b,0x2600000b}},	//   lyza, rnwr_, ंशन_, _राशी_
  { {0xcf58000a,0xf5050973,0xe5a50974,0x629a0975}},	//   ובדת_, езко, нили, jlto
  { {0x63a20014,0x98c30024,0xd5b10016,0x04b501b7}},	//   _azon, ēvēt_, _cáp_, нсия
  { {0x27ed00fb,0x64a20063,0x2db8000a,0xc952000a}},	//   _uden_, лаща, ולון_, _גמל_
  { {0xe6100086,0x200c00dc,0x64aa0089,0x662800f2}},	//   _چشم_, ődik_, _přir, öskä
  { {0x64b10048,0x60c701c9,0xdcff0046,0x245101c0}},	//   _jāiz, íjmo, ívěj, _rámu_
  { {0x6f16002a,0xafdb00cb,0x0000006a,0x0000006a}},	//   _spyc, lkøy,   ,
  { {0x88f6000a,0x74280015,0x7e75003d,0x20040072}},	//   עזרו_, _يكلف_, eizp, ümi_
  { {0xa856000a,0x83640015,0x0000006a,0x0000006a}},	//   גירה_, _لدول,   ,
  { {0x42550015,0x60c400bc,0x02450058,0x0000006a}},	//   _سنعر, _čimv, _سَبَ,
  { {0xdd9200e5,0xf652000a,0x725a000a,0x50960054}},	//   اوز_, נצל_, _מכספ, _приђ
  { {0xfc3f0023,0x6aa8000b,0x7c650015,0x80a70065}},	//   _phía_, कग्र, ناقل, _टीपे
  { {0xa089000a,0x539a004f,0x7c930058,0x0000006a}},	// [ba0] _קְצִ, ִיעו, القص,
  { {0xdbd600f2,0xcfb70008,0x9f420107,0x5dda004a}},	//   _sääd, _אלפי_, jaké_, _эфир_
  { {0x8d76006e,0x4ddb000a,0xd7ef00fd,0xdbd601be}},	//   _سادا, _מחיו, лу_, _pääd
  { {0x27e00976,0xe3a70021,0xd7f20015,0x2002088a}},	//   úin_, _مر_, اكش_, ngki_
  { {0x5ac700ce,0x2d9a0977,0x0000006a,0x0000006a}},	//   _плям_, _hype_,   ,
  { {0x8b0b000a,0x96b70054,0xf5260588,0x4d7a004f}},	//   _מִלֵ, нују_, ефин, ּרֵע
  { {0x88c50015,0x63a20030,0x2451001a,0x6a97004f}},	//   _لتقل, _szon, _náms_, _נכלא_
  { {0x7ea0022d,0x25a00089,0xccf3000a,0x69a5000b}},	//   köpo, řilo_, אכה_, _करती
  { {0x08770053,0xa6860010,0xf2060805,0x8c1b000a}},	//   _נעמט_, _злад, няно, לוקי
  { {0xaa160010,0x629a0978,0xe60e0054,0x32540979}},	//   дзiц, ulto, вдe_, твор
  { {0xf506005e,0x64a6052b,0x629a097a,0xe50502be}},	//   _їздо, _зажа, rlto, _لبني
  { {0x20b40010,0x25a10012,0xb97b000a,0x297b000a}},	//   лёўс, ühle_, לניי, לטיא
  { {0x8cd9000b,0x6722002a,0x64a30033,0xf1d10065}},	//   _फौजो, nwoj, _саца, _द्वन
  { {0x61140010,0xfc3f0092,0x6d55005c,0x83b7000a}},	//   _адку, _chín_, tyza, _נפגע_
  { {0xdd950010,0x6ca706eb,0xeca70054,0x321e097b}},	//   тавы, ераж, ејан, mety_
  { {0x6d55005c,0xc19b0008,0x219b000a,0x80a50015}},	//   ryza, _משוי, _מבוא, _جمعن
  { {0x30840015,0x7bf80033,0xcf270015,0x27e60030}},	// [bb0] _حليف, энтр_, _أربي, daon_
  { {0x3f7c000a,0x6722002a,0x9e670015,0x321e097c}},	//   _מאחס, dwoj, _ساخن, nety_
  { {0xa3c2005d,0xfe7f0144,0xdeb6004f,0x4de60065}},	//   ्डा_, duïx_, _שפתח_, _क़तई_
  { {0x9cd6000f,0x80a7000b,0xb7d6002b,0x69d8001a}},	//   _שורה_, _टीमे, پووا_, ðver
  { {0xe7580036,0x38a70020,0x58b80029,0xd6290660}},	//   ниці_, võrd_, رامج_, доле_
  { {0x7c2d0084,0xf6d40086,0xe736006b,0x1af6004f}},	//   ldar, ازند, теш_, _במשל_
  { {0x64aa0089,0xc984097d,0xceb4000a,0xce38000a}},	//   _přip, _бути, ניצ_, תאות_
  { {0x24890582,0xd9e1005d,0x93590004,0x3d19000b}},	//   čamo_, _फ़ुट, дроу_, _पहने_
  { {0x13060080,0x321e065b,0xa6ab00e6,0x58840033}},	//   вный_, fety_, _فائق_, _сыра
  { {0x68e10134,0xcb12000a,0x321e006f,0x7c2d0034}},	//   _ælds, סלי_, gety_, hdar
  { {0x320b005c,0xb1420033,0x3eba02f2,0x1636004f}},	//   ęcy_, анэл, _ript_, _שנער_
  { {0x7c2d0048,0x64550054,0x6446005b,0x0000006a}},	//   jdar, _швеђ, ökit,
  { {0xf8b200b2,0x7c2d097e,0x442d097f,0x443d0079}},	//   ישט_, ddar, mde_, _inw_
  { {0x645b00f2,0x64490980,0xa2f6000a,0x7c2d0981}},	//   lkui, ljei, _ימנה_, edar
  { {0x6722005c,0x0c96004a,0x7c2d0079,0x5cf50033}},	//   zwoj, вшая, fdar, ляту
  { {0x64490982,0x645b0983,0xf19a000a,0x7c2d0984}},	//   njei, nkui, _קשקש, gdar
  { {0xc0530008,0xe9d20015,0x6009000a,0x645b008c}},	// [bc0] _כזה_, لغا_, _נִקְ, ikui
  { {0x442d022d,0x0f570008,0x64490604,0xda790036}},	//   hde_, _סיים_, hjei, няє_
  { {0x27e600b6,0x37e6004a,0x7c2d0985,0xbf9b016e}},	//   taon_, воег, bdar, ngên
  { {0x3860002f,0x78a90493,0x321e037c,0xa96703ae}},	//   óir_, _chev, zety_, њица_
  { {0xe1e70074,0xf11e005d,0xa3c2000b,0x27e60986}},	//   _پس_, _बन्द_, ्डस_, raon_
  { {0xd6270054,0x78a90012,0x91fc003d,0x442d0987}},	//   воље_, _ehev, ehān, ede_
  { {0x442d0161,0x60c30012,0xd5d50033,0xa8060988}},	//   fde_, _nunm, уючы, _извл
  { {0xd6d20029,0x442d0989,0x98a6098a,0x78a90546}},	//   _نقر_, gde_, _рибе, _ghev
  { {0xdc9b0053,0x68e10134,0x799c0026,0x8463006b}},	//   ויקל, _ældr, _hyrw, ръще
  { {0x443d0176,0x386603af,0xe617098b,0x7c2d098c}},	//   _enw_, lhor_, _иду_, zdar
  { {0x9a350053,0xa5d8005d,0x867b000a,0xd166006b}},	//   אָרד_, _न्यौ, _קרבו, тъпи
  { {0xf99301e4,0x3866001c,0x68e3098d,0x3947008c}},	//   ירת_, nhor_, ândi, änsi_
  { {0x24580030,0x69ce001a,0x2d9e0359,0x26c4098e}},	//   _némi_, _ofbe, üten_, _jumo_
  { {0xdce505cc,0xd3570008,0xc7b30008,0x425600d7}},	//   _vyhľ, _בידי_, יבר_, _штет
  { {0xac19098f,0x5db40015,0x7c2d0990,0x7db40015}},	//   нову_, لإفر, tdar, لصفا
  { {0xfbd30074,0x69ce0991,0xdd250024,0x6abc00da}},	//   شتر_, _afbe, gūša, _airf
  { {0xfaf30029,0x7c2d0992,0xe5020065,0xeeab0993}},	// [bd0] ؤثر_, rdar, रूति_, _оток_
  { {0x442d0994,0xa2c3005d,0xf09f0251,0x99980091}},	//   zde_, रदत्, llà_, _norų_
  { {0x9f4e0030,0x442d0995,0xdbd1007c,0x98e40058}},	//   önöm_, yde_, _küüd, لكلو
  { {0x61e80996,0x24860085,0x7c3d0012,0x6abc0034}},	//   hadl, _njom_, _unsr, _eirf
  { {0xdbd10020,0xe72e03ad,0xe7080115,0x442d0997}},	//   _müüd, ще_, نتون_, vde_
  { {0x442d0111,0x6a60002e,0x99d40015,0x7aed0998}},	//   wde_, _höfn, _نتفا, msat
  { {0x799c0026,0xceb4000a,0x6b9d0034,0x64490030}},	//   _gyrw, ביס_, _hysg, tjei
  { {0x29010035,0xdbd10020,0x6a60001a,0x645b008c}},	//   muha_, _nüüd, _jöfn, ukui
  { {0x3e660152,0x60c30064,0x387c0999,0x44240015}},	//   _hôte_, _sunm, èvre_, شريف
  { {0xb7bd04f9,0xd9e1005d,0xfc3f002d,0x645b099a}},	//   _naţi, _फ़ोट, _shíl_, skui
  { {0x61e300fb,0x290102f2,0x41b5004a,0x6281063b}},	//   _venl, nuha_, ысит, rnlo
  { {0x44e10780,0x83350086,0xf7670225,0xbf9b001c}},	//   mų_, _مرتض, ما_, rgên
  { {0x44e10007,0xa3c2021e,0x249f001a,0x6b9d04d1}},	//   lų_, ्डर_, mlum_, _nysg
  { {0x290100b6,0x3f9e0048,0x249f099b,0x7f750010}},	//   kuha_, ātu_, llum_, руюц
  { {0x44e100df,0x10f50010,0xd7ce005d,0x80f50015}},	//   nų_, _сяля, हुँच, _إستض
  { {0x44e10007,0xa3e6000b,0x7aed0012,0x6b9d0034}},	//   ių_, _बड़ा_, fsat, _bysg
  { {0xfc3f099c,0x6b9d0026,0x7fe90002,0x69c3006f}},	// [be0] _dní_, _cysg, _شريف_, ľnen
  { {0x32050041,0x6b9d0176,0x44e100df,0x81bc0024}},	//   ngly_, _dysg, kų_, rdēv
  { {0x44e100df,0x19b90010,0x3e66099d,0x3866099e}},	//   jų_, вуць_, _côte_, thor_
  { {0x44e10007,0xd7ce000b,0x6abc06ad,0x2cfb000a}},	//   dų_, हुंच, _wirf, _אלטא
  { {0xd7f90036,0x81bc0024,0xdd1d002c,0x7aed00dc}},	//   тує_, ldēt, ráťt, csat
  { {0xfe360053,0xfc3f0046,0x2ca0099f,0x249f058a}},	//   ראַך_, _zní_, llid_, elum_
  { {0x44e10007,0x81bc0024,0xa3c2000b,0xb9b5006b}},	//   gų_, ndēt, ्डल_, _встъ
  { {0x249f002e,0x95530029,0x54540661,0x28760892}},	//   glum_, إخوا, рвит, _сыгр
  { {0x18670001,0x41e60484,0x988b000a,0xa87b000a}},	//   _сати_, ліна, _טָמֵ, _נאמר
  { {0x471b0053,0xdbd10020,0x44e10007,0x95c60015}},	//   _אומג, _süüd, bų_, _إياه
  { {0xfa970053,0xdbd10020,0x5a170053,0x2ca0048c}},	//   רדיש_, _püüd, נקטן_, klid_
  { {0xfc3f0092,0xc0ab0002,0x90e70015,0x7095009b}},	//   _phím_, عادل_, دَّل_, рамф
  { {0x543b00b2,0x08770053,0x04930029,0xfebb0029}},	//   _רעדא, רעכט_, _النح, فاست_
  { {0x6a60002e,0x929d002a,0xfc3f005a,0x7e2809a0}},	//   _söfn, tułe, _sní_, ліса_
  { {0xf518000a,0xf09f0144,0x0000006a,0x0000006a}},	//   כֵּל, plà_,   ,
  { {0xe9450086,0x2ca00020,0x6b9d0026,0xd9dd000b}},	//   یرای, glid_, _pysg, यर्ट
  { {0x0ca80080,0x44e10091,0xba75006b,0x4fd8000a}},	// [bf0] утри_, zų_, агащ, _עוזב_
  { {0x2bb80029,0x7aed09a1,0x2ca00158,0x7bcd09a2}},	//   طاقة_, rsat, alid_, scau
  { {0x7aed09a3,0x47d50087,0x6675002b,0xfe9c000a}},	//   ssat, ليار, یدتر, _איזמ
  { {0x2c270191,0x44e10007,0xab950036,0x961d005d}},	//   _сьог, vų_, _вимі, फ़्ट_
  { {0xd5e50036,0x66b5000d,0xd6db00a4,0x2600000b}},	//   ажли, абду, хте_, _राखी_
  { {0x44e100df,0x5694005e,0x24580046,0xcb12000a}},	//   tų_, бачт, _mému_, _ולך_
  { {0x249f002e,0xda48000a,0x3666006b,0x2e3c000a}},	//   tlum_, _עֲשָ, ращо_, תגונ
  { {0x9984003b,0x44e10007,0x60c400bd,0x62860030}},	//   _الفو, rų_, _čimp, ékon
  { {0x44e10007,0x8c1c000a,0xc86409a4,0x2cbc004c}},	//   sų_, תוחי, _утри, ײמזײ
  { {0x249f002e,0xe4e70036,0xaa7b0227,0x22920015}},	//   slum_, _бідн, _zvýr, يليس
  { {0x9a760008,0x249f0700,0x03f50015,0x2ca00034}},	//   שתתף_, plum_, _نكاح, ylid_
  { {0xb4c1014e,0xcea90008,0x32c90092,0x91fc0024}},	//   ंदी_, _חי_, _túy_, ekād
  { {0x0000006a,0x0000006a,0x0000006a,0x0000006a}},	//     ,   ,   ,
  { {0x3ebe0014,0xa2d20021,0x442f09a5,0x8fa300ce}},	//   ött_, _بيوت, _hag_, іаре
  { {0x81bc0024,0xbda50029,0xc27a000a,0xfce607d0}},	//   udēt, محفو, _שרצי, робо
  { {0x442f01d1,0xa01b00f2,0xbc6309a6,0x2fdf001a}},	//   _jag_, nnöl, овск, ðugt_

  { {0x91fc0048,0x6b850029,0xc0a90029,0x59d60002}},	// [c00] bkād, مشكل, _حاول_, لغار
  { {0xda66003b,0x25a00089,0x27e9002e,0x4a4309a7}},	//   جاري, řili_, ðann_, онув
  { {0x2cba0029,0x5dfb000a,0x91f6000a,0x9d4609a8}},	//   _لاحظ_, _בפינ, שמעו_, _тенд
  { {0x442f09a9,0x7c960086,0x97c50029,0xd7f00058}},	//   _nag_, _خشخا, متهم, سكت_
  { {0x7c2403af,0x281300a2,0x45d403de,0xd70702d9}},	//   meir, تونس, болс, инце_
  { {0x7c2409aa,0xb4c1021e,0x9a9d0033,0x8f37000a}},	//   leir, ंदू_, _зусi, יאנו_
  { {0x394700c0,0x442f09ab,0x046609ac,0x3958000a}},	//   änst_, _bag_, итим, _גֻּב
  { {0x7c2403af,0xcdb7000a,0x7791002b,0x2c67007c}},	//   neir, ספקה_, _کیها, _tõde_
  { {0xd5b10023,0x27e0002e,0x7e7c0007,0x57fb000a}},	//   _máy_, ðinu_, kirp, _שלמו
  { {0x7d1e003c,0x80ca021e,0xcb13000a,0xf6290015}},	//   _opps, _संदे, קלת_, _مسمى_
  { {0xba370008,0x3a3704dc,0xd5750036,0xca370008}},	//   בטיח_, ברים_, _луць, בניה_
  { {0xd4090074,0x320a005c,0x442f09ad,0x7c2409ae}},	//   _متهم_, żby_, _gag_, jeir
  { {0x236d005c,0xe2f805d1,0x7c2409af,0x78a209b0}},	//   czej_, _селі_, deir, ilov
  { {0xa2c3014e,0x442f0111,0x831b000a,0xbe8809b1}},	//   रदर्, _zag_, _סווז, ассе_
  { {0x7c240176,0xd0870080,0x6d5c0026,0xb7f8000b}},	//   feir, _выпи, gyra, ुलाम_
  { {0x2458002c,0x2d58034e,0x442409b2,0xc1bb000a}},	//   _tému_, шись_, nem_, _במוש
  { {0x6a60002e,0xdee40054,0xf9c701e3,0x6d5c0061}},	// [c10] _töfl, _доњи, ащен, ayra
  { {0x8f9c000a,0x93b7000a,0x442409b3,0x78a209b4}},	//   _ביחי, שלמו_, hem_, elov
  { {0x391509b5,0x2600000b,0x7c2409b6,0x442409b7}},	//   смер, _राजी_, beir, kem_
  { {0x78a2018c,0x87d40010,0x28f8005e,0x7c24016e}},	//   glov, оўшч, рець_, ceir
  { {0x8c1a0008,0xbc1a000a,0xd7ee0015,0x5c36000a}},	//   _גורי, _גורש, ركو_, _פרשן_
  { {0x6442002f,0x44240234,0x929d002a,0x7ea0008c}},	//   _anoi, eem_, kuła, töpi
  { {0x442f025c,0x96080010,0xbdf8000f,0xd5080015}},	//   _pag_, рэча_, שֶׂה_, لغين_
  { {0xe8940010,0xe3e90086,0x442409b8,0x64b3005d}},	//   _дась, اکان_, gem_, ुदेश
  { {0x83fd0030,0x753a09b9,0x787a004f,0x36d409ba}},	//   lhők, _ertz, _עָלו, _мотр
  { {0x9f4201b2,0x387d0034,0x236d09bb,0x442f09bc}},	//   jaká_, liwr_, rzej_, _wag_
  { {0x236d0050,0x25570089,0xa4d4005e,0x442409bd}},	//   szej_, _dělá_, _дохі, bem_
  { {0x7c24001c,0xd0e6002b,0x442409be,0x387d0034}},	//   xeir, حکوم_, cem_, niwr_
  { {0xe3b00086,0x6d5c09bf,0x69c3006f,0x6d4109c0}},	//   _قره_, wyra, ľnej, ålan
  { {0xda03005d,0x387d0026,0x539a000a,0x42da004c}},	//   _लागत_, hiwr_, _גינו, _עקצע
  { {0x11440029,0x7c2409c1,0x98a70046,0x6da609c2}},	//   _وَهُ, teir, íně_, сива
  { {0xeb9a09c3,0x3fe609c4,0x7c24059d,0xab2a09c5}},	//   гиб_, _ужив, ueir, лоба_
  { {0x64aa02d5,0x387d0176,0x7c2409c6,0xf093000a}},	// [c20] _přiz, diwr_, reir, _מנה_
  { {0x0f370008,0x7c2409c7,0x442409c8,0x2fd7002b}},	//   _פריט_, seir, zem_, _پوید_
  { {0x1e570008,0x97c60029,0x7d1e09c9,0x387d0026}},	//   _השיר_, مقاو, _upps, fiwr_
  { {0x18a60457,0x673b04a5,0x387d0034,0x088a0033}},	//   щаем, _bruj, giwr_, ыбей_
  { {0x78a206db,0x442409ca,0x4c830033,0x18670054}},	//   rlov, vem_, _хляв, љачи_
  { {0x44240050,0x13e0005d,0x2816002b,0x78a209cb}},	//   wem_, नर्भ, _گورس, slov
  { {0x2609005d,0x78a209cc,0xa4f8002b,0x3984002b}},	//   _सारी_, plov, شکار_, _بیاف
  { {0xb8de005d,0x9cd70008,0x281600a2,0x387d0034}},	//   ुआ_, זוקה_, _دورس, ciwr_
  { {0xe737005f,0xc1ea0036,0xafdb003c,0x2bda000b}},	//   _лет_, льне_, kjør, युया
  { {0x3d19005d,0x6f0609cd,0x442409ce,0xdb1d0030}},	//   _पहले_, dukc, sem_, özép
  { {0x3a370008,0x1a9b0053,0xca37000a,0x7d1b002a}},	//   זרים_, רייע, זניה_, łusz
  { {0xc9530008,0x9f4b0152,0x20050091,0xa3d7000b}},	//   למת_, lacé_, ėlio_, ़ुद_
  { {0x80ca005d,0xa01b00dc,0x321a002b,0x0000006a}},	//   _संवे, lnök, _ميشد_,
  { {0x63a2025c,0xafdb003c,0x539b000a,0x3179002b}},	//   _iyon, gjør, _עיגו, اجیک_
  { {0x127b0053,0xdd3a0011,0x865b0135,0x0217000a}},	//   _גאגע, văţa, נדלי, _החום_
  { {0x69d800dc,0x63a209cf,0x4fc70937,0x629a09d0}},	//   űvel, _kyon, _уска, loto
  { {0x5ea50029,0x62880410,0xd1380007,0x6d480123}},	// [c30] _ومعل, ondo, lvą_, ädar
  { {0xe9ab0018,0x1ed80015,0x629a09d1,0x0000006a}},	//   هدان_, _ابيب_, noto,
  { {0x99d40015,0xdd3a0045,0x9cb500c3,0x63a209d2}},	//   ستلا, răţa, _ومخت, _lyon
  { {0xbd880086,0xf7700086,0x2616000b,0x27e90077}},	//   _چنین_, کام_, प्सी_, úan_
  { {0x387d0026,0x6d41001a,0x9f4b0003,0x65c509d3}},	//   riwr_, ælaf, facé_, обла
  { {0x34b3005d,0xddc50089,0xa565002b,0xa684005e}},	//   ुद्द, _pohř, يگان, плід
  { {0x69c7003c,0x0e5c000a,0x629a09d4,0x63a20003}},	//   _igje, רדוב, doto, _ayon
  { {0xe459030e,0xdd1d006f,0x7d7c000a,0x673b09d5}},	//   ржи_, kážt, טרוג, _truj
  { {0x60ca00b8,0x27ef001a,0x61ea0012,0x87e4006b}},	//   _aufm, magn_, _befl, _хюсе
  { {0x629a09d6,0x6e21007c,0x9958006f,0xc2c80058}},	//   goto, õlbl, láša_, حبيل_
  { {0xdddc0007,0x602609d7,0xf953005e,0x63a209d8}},	//   sirū, одна, жнiй_, _eyon
  { {0x50460124,0xe45f0020,0x316b005c,0x9958006f}},	//   цемб, ööd_, ącz_, náša_
  { {0xe1ee09d9,0x8e5a0054,0x623509da,0x629a09db}},	//   _ог_, ајву_, _меду, boto
  { {0x61ea0028,0x02450015,0x68f5013f,0x6f0609dc}},	//   _gefl, _ذَبَ, _ovzd, rukc
  { {0x8c7a0063,0x2c67007c,0xdd9200c3,0xdb1d001a}},	//   ащат_, _sõda_, ذور_, _ofsó
  { {0x69d50079,0x6097002b,0x8c4309dd,0x90730058}},	//   _afze, _ونوس_, месе, _يهوش
  { {0xe9da0015,0xda660015,0x4bd90033,0x20e70030}},	// [c40] لذات_, ياطي, сься_, lői_
  { {0x89f50010,0xcf93004f,0x6dfa00af,0x7d150052}},	//   зяцц, _קטז_, _тхис_, éfsá
  { {0x38cb0086,0xc92a0063,0x08fa0015,0xacf6002b}},	//   لانی_, роеж_, شراب_, _بسخت
  { {0x186a000d,0x69da005d,0x629a09de,0x69c70030}},	//   јади_, _प्री, zoto, _egje
  { {0x41c9005d,0x629a003f,0x501b000a,0xf1c9000b}},	//   रशास, yoto, שונו, रशान
  { {0x47330191,0xd1380007,0x8f9b0008,0x7f3b000a}},	//   ьніс, yvą_, סיסי, יענו
  { {0x629a09df,0x61ea09e0,0x27ef02f2,0xafdb00cb}},	//   voto, _refl, bagn_, kjøp
  { {0x60c4007c,0xa01b0030,0x20e70030,0xb426002b}},	//   _niim, rnök, dői_, زعبو
  { {0x629a09e1,0xf3f5009a,0x2451005a,0x0000006a}},	//   toto, ستيک, _jámy_,
  { {0xfb1b0008,0x5666002b,0x629a09e2,0x7ae90061}},	//   סוימ, _بدرف, uoto, _çete
  { {0x61ea002e,0x22570015,0x6e21007c,0x20d30033}},	//   _vefl, تجيب_, õlbm, міўс
  { {0x7ea00123,0xe4e90067,0x629a09e3,0x74140369}},	//   köps, _طعمه_, soto, _روتا
  { {0xdfa70029,0xa01b008c,0x628f0003,0x60c40509}},	//   تحدي, nnöi, écoc, _diim
  { {0xb2370015,0x6dc70058,0x0000006a,0x0000006a}},	//   _وكنا_, تزحل,   ,
  { {0xeda4005e,0x14d8000a,0xa6e90016,0x41db004f}},	//   дшто, מַּמ, _giươ, _דחוס
  { {0x4bdb002b,0x3e540061,0xb4fb0643,0x7f9502a3}},	//   شبرد_, _aştı_, יפלי, _найх
  { {0x27ef0123,0x0000006a,0x0000006a,0x0000006a}},	// [c50] vagn_,   ,   ,
  { {0x0b880036,0x3cfe01a3,0x1995006b,0xfaa700fd}},	//   істи_, štva_, пазя, ішан
  { {0xd9990015,0xfeb80021,0x320c002a,0xd6220033}},	//   حنات_, _بايت_, igdy_, _мiка
  { {0x88c80036,0x4878005e,0x0000006a,0x0000006a}},	//   ілів_, осія_,   ,
  { {0x87270029,0x8bd6000a,0x20e70030,0xe73904b9}},	//   تعام, _מורו_, zői_, сел_
  { {0x9bba000a,0xd62909c2,0x27ef0723,0x8f9c000a}},	//   _לצרפ, соке_, sagn_, בידי
  { {0xb066008c,0x673e003d,0xc9840054,0xa5f600af}},	//   nsää, āpja, _жути, чеју_
  { {0xb06600f2,0x17f80029,0xaaaf000b,0x929d002a}},	//   isää, _ورقة_, _जीतक, tuło
  { {0x66f40001,0xa3b5000b,0xc6a70099,0x60c409e4}},	//   _опту, छें_, _држи, _riim
  { {0xcb120008,0x20e700dc,0xe6640080,0xc7c40036}},	//   עלי_, tői_, _отхо, _істи
  { {0x60c40020,0x27ed00da,0x614509e5,0x2d840061}},	//   _piim, _keen_, чена, şmez_
  { {0xc4d20008,0x26c509e6,0x75d3002b,0xdb060030}},	//   _נגד_, _hilo_, _ريچا, _szkí
  { {0x60c409e7,0x92a4005c,0x25a50034,0x27ed042f}},	//   _viim, ółcz, _hyll_, _meen_
  { {0xd3560008,0xed5a09e8,0xdbf6000b,0xc332000a}},	//   _מיני_, бог_, ेल्ड_, _רוג_
  { {0x60c4022d,0x69d80030,0x628109e9,0x26c509ea}},	//   _tiim, űvek, milo, _milo_
  { {0x628109eb,0x27ed0079,0x6459002a,0xada30033}},	//   lilo, _neen_, _jowi, хасл
  { {0xb066007c,0x2d850003,0x645909ec,0x628100d4}},	// [c60] asää, ûler_, _mowi, oilo
  { {0x628104f9,0x26c509ed,0xcf250058,0xc9b6011e}},	//   nilo, _nilo_, _آريي, псењ
  { {0x27ed03c2,0x2f160134,0x3e5b000a,0x0e5b00a3}},	//   _been_, læg_, _הדיס, _הדיב
  { {0xa8000089,0x6459051e,0x9cd7000a,0x628109ee}},	//   příč_, _nowi, _מוטה_, hilo
  { {0x62810084,0x26c5060b,0x163409ef,0xd7ef0015}},	//   kilo, _bilo_, деля, اكه_
  { {0x6b8909f0,0x98ac0064,0xdef7000a,0x8f1b000a}},	//   _þega, ılır_, למנט_, מונת
  { {0x3494008f,0x628100bd,0x15170029,0x645909f1}},	//   макр, dilo, كزية_, _bowi
  { {0x27ed09f2,0xc9550010,0xc917000a,0x78fb000a}},	//   _geen_, _ўтры, _מחלת_, _לפלו
  { {0x6459005c,0x87f90010,0xa6ca0029,0x628109f3}},	//   _dowi, _фэст_, _طوال_, filo
  { {0x271e0024,0x25a50971,0xa3dc000b,0x628109f4}},	//   rānā_, _fyll_, _त्र_, gilo
  { {0x7648005c,0xc5690015,0xecbe000b,0xe4d70058}},	//   _indy, _وحمل_, ्दाफ, _فولت_
  { {0xa3e6014e,0x7af6022d,0xdfd8006b,0x94d30015}},	//   _बजट_, ksyt, зър_, _أينش
  { {0x6a600084,0x5334017a,0x6f640015,0xe455002b}},	//   _höfu, _целт, ّهُم, _تفنگ
  { {0x64470048,0x62810011,0x3ec40010,0x7af609f5}},	//   ējie, cilo, ессб, dsyt
  { {0x386600dc,0xc534000a,0xadbd0033,0x621b000a}},	//   kkor_, וָּה_, равi, _הווק
  { {0xea000092,0x9f4b0089,0x765a09f6,0x4fc7055f}},	//   _đạn_, lací_, _loty, _эска
  { {0xb06600f2,0xfbd00029,0x24b7000a,0x2ef50033}},	// [c70] ssää, اتف_, להלן_, _ўзор
  { {0x27ed003e,0xa01b00dc,0x9f4b0089,0xd9f90033}},	//   _seen_, gnöv, nací_, інец_
  { {0x80a40086,0x32d20092,0xacb50054,0x88c70067}},	//   _زمین, _lây_, _обољ, ستال
  { {0x2c090086,0x91bb000a,0x7ea0001a,0x628109f7}},	//   _بعدی_, זמבי, löpp, zilo
  { {0xcc560008,0x9f4b0089,0x765a0026,0x4c3a000a}},	//   _חברי_, kací_, _boty, _ותרב
  { {0x645909f8,0xdd1c0089,0x627901b2,0xc794002b}},	//   _sowi, láše, lňov, رشنب
  { {0x64590050,0x765a09f9,0x9f4b01b2,0x27ed014c}},	//   _powi, _doty, dací_, _teen_
  { {0x32d20023,0x386600c0,0xf6770086,0xdd1c0089}},	//   _bây_, ckor_, _کارخ, náše
  { {0x32d20092,0x2ca90026,0x27f80046,0x69ca0061}},	//   _cây_, ilad_, řený_, şleş
  { {0x32d20092,0x83640015,0x765a002a,0x0bb8000a}},	//   _dây_, عديل, _goty, הלחם_
  { {0x628104f9,0xd567054f,0x645900da,0x2ca909fa}},	//   rilo, _этап, _towi, klad_
  { {0xd59a0008,0xf76700e6,0x627901c9,0x628109fb}},	//   _ובעל, نا_, jňov, silo
  { {0x32d20023,0x6281052a,0x2ca909fc,0xc7f6000a}},	//   _gây_, pilo, dlad_, וזרת_
  { {0x7cd500df,0x248d00bd,0xe1f1002b,0x216909fd}},	//   _sąra, lnem_, _شست_, _мили_
  { {0x6da309fe,0x3f9e002a,0x9db90033,0x2d950510}},	//   вира, łtu_, зыту_, ертс
  { {0x248d09ff,0x40950010,0x3cfe0a00,0x4e1f000b}},	//   nnem_, _прыт, štvo_, म्बई_
  { {0x32d20023,0xa5a4005d,0x248d00b8,0x6097002b}},	// [c80] _xây_, _चुनौ, inem_, _تنيس_
  { {0x2bde005d,0x7af6005c,0x77f8005d,0x2ca904f6}},	//   _फ्रा, rsyt, ुल्क_, alad_
  { {0x386d0085,0x729a004c,0x9f42006f,0xda650015}},	//   _bler_, קסעס, jakú_, راكي
  { {0x31560053,0x9f4b0089,0x20d30092,0xe7aa03a9}},	//   ויען_, zací_, _mãi_, овел_
  { {0x20d30092,0xfc3f002d,0x248d0a01,0x38660a02}},	//   _lãi_, _thír_, dnem_, rkor_
  { {0xa3c1005d,0x8f9b000a,0x38660a03,0x96330033}},	//   ंधन_, חיני, skor_, кніц
  { {0x386d01d1,0xceb300b2,0x9f4b0156,0xa3d40010}},	//   _fler_, דיג_, vací_, нойч
  { {0x628f0003,0x833401b7,0x2ca00a04,0xa97b000a}},	//   écon, ених, noid_, _ואלכ
  { {0x41c9005d,0xd6260029,0xfa6a000a,0x9f4b0247}},	//   रशंस, _يعطي, ַכֹּ, tací_
  { {0x20d30092,0x32d20092,0x4154034e,0x2ca004f6}},	//   _bãi_, _vây_, евос, hoid_
  { {0x9f4b0089,0x20d30092,0x248d0a05,0x1bee0065}},	//   rací_, _cãi_, bnem_, जराल_
  { {0x32d20023,0x246c005c,0xc1780091,0xb4ca000b}},	//   _tây_, yśmy_, lbėk_, ऊदी_
  { {0x80ca005d,0x93140015,0x10740033,0xcfab002b}},	//   _संके, _أوتش, тляю, تادم_
  { {0x8d6b000d,0x2ca90026,0x20050064,0xf1940342}},	//   ојба_, wlad_, şli_, _пиль
  { {0x44fa0024,0x329b000a,0x62790069,0x27e60546}},	//   nī_, _ובגד, tňov, kbon_
  { {0xbae50029,0xf537000a,0xac740021,0x4fc7004a}},	//   فكري, ונלי_, ناقش, _оспа
  { {0x7b180080,0x2bbb0029,0x2d9e0012,0x62790107}},	// [c90] мотр_, زارة_, üter_, rňov
  { {0x248d0a06,0x7055002b,0x6279013f,0xce6b096d}},	//   znem_, _آنکا, sňov, _фрид_
  { {0x321e00da,0xdb060046,0x627901c0,0x248d0a07}},	//   ifty_, _vzká, pňov, ynem_
  { {0xf8b1002b,0x59df000b,0x3a380326,0x2ca001f9}},	//   اکس_, _प्रर, _earp_, coid_
  { {0xcc760008,0x290c0134,0x248d00bd,0x65630026}},	//   _נעשה_, _ådan_, vnem_, wynh
  { {0x8cb9014e,0xb0cf005d,0x66d2002b,0x4535006b}},	//   ्दको, _संलग, ديوئ, ехит
  { {0xe5a20036,0x248d00bd,0xa01b008c,0x27e6059f}},	//   лиши, tnem_, nnös, bbon_
  { {0x20d30092,0x387f0509,0x27e60016,0x7c2d0a08}},	//   _rãi_, _umur_, cbon_, near
  { {0x248d0a09,0xf6d7002b,0x0478002b,0x20d30016}},	//   rnem_, _آزرد, بليک_, _sãi_
  { {0x248d00bd,0x26df003f,0x7c2d0a0a,0xd567011e}},	//   snem_, _ituo_, hear, _отеп
  { {0x00860a0b,0xcf89000a,0x248d0a0c,0x1c0f0065}},	//   елно, _פט_, pnem_, िलाल_
  { {0xe53a000a,0x853a000a,0xcea905bd,0x6908000a}},	//   _מתער, _מגעי, _הי_, וּשְ
  { {0xf8b20053,0x2ca000da,0x442d0a0d,0x644b0a0e}},	//   טשט_, void_, mee_, _ingi
  { {0x442d0a0f,0x8235002b,0x877a000a,0xed5a0a10}},	//   lee_, _سرتا, לארי, пог_
  { {0xfcb60080,0x7c2d002d,0x6fa0000b,0x22580015}},	//   ещаю, fear, _गुरू, _تجنب_
  { {0x7c2d0a11,0x442d0a12,0xdca604bb,0xdca30a13}},	//   gear, nee_, хаби, гаси
  { {0xac07008f,0x2ca00a14,0xaa460a15,0xab270a16}},	// [ca0] энта_, roid_, неал, нота_
  { {0x27ff00d9,0x9abe0033,0x7c2d0034,0x442d0a17}},	//   _adun_, пiса_, aear, hee_
  { {0x442d0a18,0x49ba0015,0xa8060004,0x58060015}},	//   kee_, سائد_, езел, فواك
  { {0x7c2d0a19,0x6e2e00dc,0xd7ef0015,0x7d0e02f2}},	//   cear, lebb, مكم_, mubs
  { {0x3a3800df,0x27e60a1a,0xf093000a,0xda660015}},	//   _tarp_, rbon_, ננד_, _كاسي
  { {0xe45f00f2,0x644b02cd,0x200001d7,0x7ae40a1b}},	//   öön_, _angi, _ldii_, mpit
  { {0x8934000a,0xa5660015,0x2b400a1c,0x7ae40a1d}},	//   _בָּא_, عدتن, lvic_, lpit
  { {0x7ae4000c,0x44fa0024,0x442d0a1e,0x9417006b}},	//   opit, rī_, gee_, ежът_
  { {0x7ae400f2,0x44fa003d,0xd3d70015,0x136a0a1f}},	//   npit, sī_, ربيا_, яшки_
  { {0x75d60029,0xda10005d,0x6b7b01ac,0x644b0a20}},	//   _أيضا, ालित_, פרינ, _engi
  { {0x018a0146,0xd48f0a21,0x6d5a008c,0x91b801b0}},	//   ящий_, _бр_, ätal, ьгот_
  { {0xf9930008,0x7f440003,0x442d0a22,0x0000006a}},	//   טרת_, _briq, cee_,
  { {0x69dc0467,0x387b0053,0x82f70015,0x2617000b}},	//   _ofre, לטטױ, _كروز_, _नामी_
  { {0x6e2e00dc,0xd1300015,0xc7b3000a,0x9f4b0144}},	//   gebb, _نمت_, טבר_, racà_
  { {0xceeb0086,0xdd940033,0xdd980a23,0x3ced0085}},	//   _کربن_, гары, ешт_, ćevo_
  { {0x45b7000a,0x7f850015,0x6aa9000b,0x69a4000b}},	//   תפלל_, _للعن, कत्र, _कड़ी
  { {0x9f53005c,0xddc5002c,0x19eb0015,0x5f950a24}},	// [cb0] ędów_, _dlhš, كراً_, _шиит
  { {0x99d40015,0x7c2d0a25,0x1dd5000b,0xd5b8003d}},	//   هتما, sear, _दलित, _abām_
  { {0x7c2d0041,0xa8cb0015,0x6f1d0012,0x6e21007c}},	//   pear, سباق_, ltsc, õlbu
  { {0xdddc0007,0xddeb002b,0x76580046,0x6f1d0651}},	//   mirš, _برکه_, ejvy, otsc
  { {0x442d0a26,0x69dc0034,0x7528003d,0xe72e005e}},	//   vee_, _ffre, _apdz, ше_
  { {0x6d4a002f,0xad8b000a,0xfd8b000a,0x442d0a27}},	//   _áfac, ּנֵ֥, ּטֵּ, wee_
  { {0xdd030024,0x91810092,0x27e9001a,0x6f1d0028}},	//   ērķa, iệc_, ðans_, htsc
  { {0x6e2e0030,0xa3dc000b,0x20ee0046,0x0445012f}},	//   zebb, तुल_, dři_, теин
  { {0x36d50191,0x442d003e,0x2ba7005d,0x92f60029}},	//   _розр, ree_, _कुमा, نفيذ_
  { {0xb1450036,0x6f0f0a28,0x93240015,0x6f1d0012}},	//   внол, ducc, ارين, dtsc
  { {0x8ccd005d,0xd00a0a29,0xd24e002b,0xafe6005e}},	//   _दंगो, мене_, غچه_, конл
  { {0x59c3000b,0x6f1d0a2a,0xe588000a,0xd00f0058}},	//   वेयर, ftsc, _אָנָ, يلٍ_
  { {0x547a0008,0xa856000a,0x04160067,0x3e740123}},	//   _קטנו, דירה_, _شيوع_, _läte_
  { {0x33760008,0xdee30a2b,0xe72e00af,0x0000006a}},	//   _בתנך_, рори, сеy_,
  { {0x6e2e02d7,0xada60a2c,0x6f1d0111,0x2616000b}},	//   rebb, тавл, atsc, प्टी_
  { {0x6e2e00dc,0x2c7502df,0x6acd000b,0x69dc0a2d}},	//   sebb, _nådd_, ़दूर, _sfre
  { {0x6d45018b,0x6b6301d9,0x7d1c00bd,0x7ae40a2e}},	// [cc0] _erha, акта, strs, upit
  { {0x5db60029,0xeef7000a,0x0ae90015,0x09e60342}},	//   _لإجر, _שמיר_, عرقي_, тожн
  { {0xbca60015,0x1bea004a,0x7ae40a2f,0xb05b014b}},	//   _لمدي, _одни_, spit, smäe
  { {0xe45f007c,0xfd97000a,0xe3a7006e,0xe7860302}},	//   ööl_, _ידיך_, _نر_, куло
  { {0x2f8d00f3,0x78a2007c,0x6283006f,0xb05b0012}},	//   ּרוּ, roov, _omno, lmäc
  { {0x20ee0089,0xa9060029,0x78a2007c,0x68fc0a30}},	//   yři_, _لبرن, soov, _tvrd
  { {0x91fc0024,0x6e230064,0xc5130015,0x2a670030}},	//   skāk, _önbe, لبيت, önbe_
  { {0x39470134,0x63ab079b,0x0463004a,0xa937004f}},	//   ænse_, _bygn, итым, _בטלה_
  { {0xd4330029,0x9c0b0008,0xe61a059c,0x660d0030}},	//   شعيب, וִיִ, _ода_, ánké
  { {0x8556002b,0x20ee0046,0x63ab0a02,0x32540a31}},	//   _لیتر_, tři_, _dygn, увор
  { {0x60f8008f,0xb5050086,0x09f70008,0xe5050015}},	//   эння_, _مظنو, כמים_, _مبني
  { {0x64a30010,0xdddc0007,0x30a40063,0xc57b000a}},	//   _каха, virš, иряв, _קראת
  { {0xd36f00e6,0x6f1d034d,0x8143002b,0xbf340a32}},	//   _وهم_, utsc, هپیم, анящ
  { {0x2c7500fb,0x6f1d04ec,0x6f0f0a33,0x13c7000a}},	//   _måde_, rtsc, rucc, _בּוֹ_
  { {0xeca7000d,0x6f0f0a34,0x62880a35,0x2258001a}},	//   вјан, succ, mido, örku_
  { {0x853b000a,0x62880a36,0xdd0d002a,0x20050091}},	//   וגלי, lido, _półt, ėlis_
  { {0x09bd005d,0xfe6e0086,0xcaf40015,0x0ff80015}},	// [cd0] ्ख्य, زگی_, لسلب, _شعيب_
  { {0xadbd008f,0x7a570029,0x160e000b,0x62880a37}},	//   _напi, خضرا, _सागर_, nido
  { {0x49a400d7,0x60cd0a38,0xb8d40015,0x67290a39}},	//   ајца, _kiam, لتنش, _spej
  { {0xd5e80092,0x2458002c,0x8c19000a,0x2c750a3a}},	//   _đón, _témy_, _אוֹי, _både_
  { {0xef1f0064,0xf77000e6,0xb8fa000b,0x97250015}},	//   ntü_, ياه_, _डू_, افتو
  { {0x98b30064,0x7c3d0213,0x9f420107,0xc66b004a}},	//   ıdır_, _hasr, jaký_, ьшее_
  { {0x63ab005c,0x6ed5000b,0x95c50015,0x8578006b}},	//   _sygn, _यूसु, ديثه, ксът_
  { {0x62880024,0xef1f0061,0x04b502ed,0x60cd0a3b}},	//   eido, ktü_, ысля, _niam
  { {0x7c3d0064,0x58840033,0x8235002b,0x99830091}},	//   _masr, _тыра, هردا, _tajų_
  { {0x7c3d0125,0x60cd007c,0xe3b601b0,0x78a20a3c}},	//   _lasr, _aiam, ыбы_, čove
  { {0x64150029,0xd9190008,0x65940004,0x1a9c004c}},	//   _مواط, עוֹל, _кафу, ויזע
  { {0x82d9006b,0x7c3d0a3d,0x20560a3e,0xdee60a3f}},	//   _зддс_, _nasr, утор, ломи
  { {0x443f002e,0x62880a40,0xb4c1000b,0x60cd0a41}},	//   mdu_, bido, ूदी_, _diam
  { {0x443f0a42,0xc332000a,0xe3b0002b,0x62880a43}},	//   ldu_, _לוד_, _برم_, cido
  { {0xe814005d,0xc5f2000a,0x60cd02b9,0x829a004c}},	//   _डाला_, מדם_, _fiam, _אױסק
  { {0xb05b0012,0x645b0a44,0x60cd0a45,0x443d0a46}},	//   rmäc, njui, _giam, _jaw_
  { {0x4bd90a47,0x8c430063,0x3fe30010,0x443d0a48}},	// [ce0] ться_, щете, _ужыв, _maw_
  { {0x443d0495,0xfaaa002b,0x443f008c,0xda660040}},	//   _law_, رهاي_, hdu_, داري
  { {0x2bc5005d,0xb05b008c,0x63ae002a,0xfbc9000a}},	//   लेबा, lmäa, ębni, פת_
  { {0x38600084,0x26cc0a49,0xfc320029,0x78bb001c}},	//   ðir_, _sido_, _احد_, _chuv
  { {0x4bfb0008,0x443f06ce,0x57f3005e,0x38cb002b}},	//   _אלכס, ddu_, спіт, رامی_
  { {0x0f37013a,0x569401ca,0x443f0a4a,0x75d3009a}},	//   טרנט_, јакт, edu_, ميها
  { {0x86750033,0x443d0542,0xb05b008c,0x62880a4b}},	//   шыцц, _baw_, hmäa, vido
  { {0xdd0400df,0xccf3000a,0xb993002b,0x6288002a}},	//   ūrėt, זכה_, _الفب, wido
  { {0x60cd002d,0xb27400d0,0x443d0a4c,0x8463006b}},	//   _riam, илиш, _daw_, съще
  { {0x645b00f2,0x6e3e0a4d,0x443f0a4e,0x60cd0a4f}},	//   ajui, _napb, adu_, _siam
  { {0xa0550036,0x75d30087,0xb4260067,0xda7b004c}},	//   авні, _ايما, _معشو, גניר
  { {0xf5370008,0xdfd10029,0xc3d60015,0x62880a50}},	//   _תנאי_, تيح_, _إغاث, sido
  { {0x62880a51,0x0000006a,0x0000006a,0x0000006a}},	//   pido,   ,   ,
  { {0x6440002e,0xd5a60021,0xd2500015,0xef1f007f}},	//   ldmi, قف_, _ذنب_, rtü_
  { {0xdcbb0063,0xef1f0064,0x64400a52,0x61fa0a53}},	//   еща_, stü_, odmi, matl
  { {0x64400a54,0xaed5000d,0x61fa0a55,0xdc0f0065}},	//   ndmi, _коиш, latl, िलेड_
  { {0x6d4a0084,0x6e950036,0x50b80225,0x3b550001}},	// [cf0] _áfan, _випу, _حدود_, шкар
  { {0xdb2400dc,0x28d9000b,0x443f0a56,0x25a00046}},	//   ásán, _बंदि, zdu_, řily_
  { {0x3947002e,0xd7d50001,0x628f06ba,0x443f0a57}},	//   íns_, ажењ, écoi, ydu_
  { {0xfe7f0034,0x61fa0a58,0xc1780091,0x8d5a004f}},	//   opïo_, hatl, lbės_, _סכרי
  { {0x07a50292,0x443f06db,0xe7390a59,0xabfa000a}},	//   јалн, vdu_, тел_, _שהשר
  { {0x443d0a5a,0xb95b0015,0x6a72001a,0xa5090a5b}},	//   _saw_, _كجزء_, _hæfn, века_
  { {0x3e74007c,0xf993002b,0x61fa0a5c,0x443d0a5d}},	//   _jäta_, _طبس_, datl, _paw_
  { {0x443f0a5e,0x9cd8000a,0xb05b008c,0x3e740a5f}},	//   udu_, נוחה_, ymäa, _mäta_
  { {0xa3a8005d,0xe1f10086,0x443f0a60,0x43750a61}},	//   _खुद_, يسد_, rdu_, руйт
  { {0xc6a703f1,0x2ef20026,0xd3280015,0xfb1c000a}},	//   _срби, _rwyf_, اثيم_, תוזמ
  { {0x7c240084,0x6e3e00e8,0x443d0026,0x850400e6}},	//   yfir, _rapb, _taw_, _هولن
  { {0x44f30045,0x3f6a0a62,0x61fa0a63,0x10a600ce}},	//   mţ_, вимо_, aatl, римн
  { {0x8234002b,0x61fa0061,0x0000006a,0x0000006a}},	//   _گرنا, batl,   ,
  { {0x91e50001,0xe37a000a,0x7f750033,0x6145055f}},	//   _токе, _ברנר, суюц, _века
  { {0x44f30011,0xa3dc005d,0xabf6024f,0xb05b0a64}},	//   nţ_, तुक_, ичащ, mmän
  { {0x9ce50010,0x3e7b0089,0xb05b0a65,0xab2a0001}},	//   сцёл, eště_, lmän, коба_
  { {0xfc3f001c,0xb05b0123,0x6388003d,0x0b430a66}},	// [d00] _daí_, omän, cīnī, онтн
  { {0x4efb000a,0x7c240a67,0xab270a68,0x7bdf0a69}},	//   _שהיו, sfir, рофа_, acqu
  { {0xd00f0074,0x19b9008f,0x25f90065,0x673b0a6a}},	//   _علی_, гуць_, _ईज़ी_, _asuj
  { {0xc18c0053,0x07ba0015,0x61fa0a6b,0xa01b008c}},	//   עטאָ, نهضة_, zatl, tiöi
  { {0xbb430036,0x91680092,0x61fa0064,0x64970024}},	//   _деяк, _mức_, yatl, eģio
  { {0xbb43000d,0xa01b00f2,0x3cfe0263,0x2cb20034}},	//   _ќерк, riöi, štvu_, llyd_
  { {0x5e57004c,0x2617000b,0xa5070004,0x442401c2}},	//   ייסע_, _नारी_, аеја_, tfm_
  { {0x493b000a,0x98a30a6c,0x2bf6000a,0xd90d002b}},	//   _בגלו, _дисе, ׁמֶן_, _سیه_
  { {0xc1780007,0xd2500029,0x61fa00dc,0x23480086}},	//   ybės_, كنة_, tatl, اسبی_
  { {0x15f8000a,0xeb91000a,0xe3af0015,0x27e10046}},	//   _תִּמ, לָי_, برى_, ěhne_
  { {0x70550087,0xd25702bf,0x67220a6d,0x2c750123}},	//   مندا, рцы_, ltoj, _låda_
  { {0x61fa0a6e,0x67220a6f,0x251b000a,0x44320016}},	//   satl, otoj, _יובא, _úy_
  { {0x73360029,0x67220a70,0x9098006b,0xe47b004c}},	//   _خرائ, ntoj, рвят_, _בראכ
  { {0xea0000a7,0x672200df,0x237b0008,0x645d00f2}},	//   _đến_, itoj, _שָׁמ, ösiv
  { {0x672200f2,0xb2bb0008,0x161b005d,0x1df80080}},	//   htoj, _שמור, प्टर_, ресы_
  { {0x115b0008,0x2c7500c0,0x5c740a0b,0xf3f1000a}},	//   _ידוע, _båda_, олст, ּ֣ן_
  { {0xa9e70029,0xb09c000a,0x109c000a,0xdb230061}},	// [d10] لثان, _שיחר, _שבחב, _örüm
  { {0xd138005c,0x8e840015,0x4a54058c,0x3e740123}},	//   ową_, _وليه, окус, _täta_
  { {0x67220a71,0xb7d500a2,0xdd910002,0x2ba7000b}},	//   etoj, مقاب, _روح_, _कुरा
  { {0x315700b2,0x20190375,0x8cba000b,0xa3c8000b}},	//   ייבן_, ngsi_, ्षणो, ोखा_
  { {0x6d5a008c,0x27200016,0xb05b008c,0xd874006e}},	//   ätav, gòn_, ymän, غامب
  { {0xbb3a00b2,0x5a470010,0x78a204af,0xa6840036}},	//   _געשי, _тэма, čova, олід
  { {0x28f803e7,0x1994006b,0x4993002b,0x6e35002a}},	//   _весь_, _даря, _بیار, iezb
  { {0xd7c90086,0x0d980008,0xcd98000f,0xaadb000b}},	//   _موزه_, יכום_, ידות_, _बढाक
  { {0xf7850015,0xd2a9004a,0xb05b0400,0xb4e60065}},	//   _الذَ, лкие_, tmän, _बढ़ी_
  { {0x27fd0026,0x91680092,0xcb36000a,0x2ca90034}},	//   lawn_, _sức_, צאתי_, hoad_
  { {0x61f801e2,0x29010a72,0xa879000a,0xa06a0a73}},	//   _devl, nsha_, ָאָר, гана_
  { {0x45b60008,0x307a0029,0xf9920008,0x27fd0034}},	//   _הפעל_, احدة_, לרי_, nawn_
  { {0x248d0048,0x889a0135,0x7205002b,0xb05b008c}},	//   miem_, רברי, _هوشم, mmäl
  { {0xd5b10023,0x248d0024,0x27fd0026,0xee3a0010}},	//   _ký_, liem_, hawn_, ынг_
  { {0x91680092,0x7cda002b,0x628f0003,0x2d9e0061}},	//   _tức_, اورز_, écou, çte_
  { {0x672200df,0x248d0a74,0x60850015,0x80e40015}},	//   ytoj, niem_, _وشيك, _بأول
  { {0xd5b10023,0xf1bf0089,0x59d60015,0x7e760015}},	// [d20] _lý_, řád_, مغار, _هادئ
  { {0xb05b0a75,0x2f5b000a,0x6f0406f2,0x2cb20034}},	//   hmäl, _עדינ, _ivic, slyd_
  { {0xfe37013a,0x248d0a76,0x01fa004c,0x69260004}},	//   _פרטי_, kiem_, רפעל, смеа
  { {0x248d0048,0x91fc0048,0x17fa0029,0x718a0053}},	//   jiem_, nkār, اراة_, נװײַ
  { {0x248d0048,0xd138005c,0x501b01d8,0x366a0004}},	//   diem_, zwą_, רונו, ладо_
  { {0x5ee9000a,0x47330033,0x67220a70,0x27200016}},	//   בַקְ, яніс, rtoj, ròn_
  { {0x764100df,0x91fc003d,0x67220a77,0x9f590003}},	//   _daly, kkār, stoj, rasé_
  { {0xb1760092,0xb8960029,0x248d0a78,0x5997000a}},	//   _ngượ, _الرع, giem_, _הכלב_
  { {0xa3a8000b,0x988b000a,0xb3760058,0xa01b02dc}},	//   _खुश_, _עָלֵ, إدعش, lhög
  { {0xda7b0053,0xd138002a,0x51f8005e,0x7c360a79}},	//   ָנטר, twą_, шною_, heyr
  { {0xd0110031,0x142a005e,0x7c36008c,0xc604000b}},	//   ولد_, _біло_, keyr, रणीय_
  { {0xd138002a,0x248d0a7a,0xbec3003d,0x0000006a}},	//   rwą_, ciem_, ķīmi,
  { {0x3e970029,0x5f940063,0x94bb000a,0x0000006a}},	//   مؤسس, зият, _עמדת,
  { {0x539b0008,0x6442002d,0x7d15003d,0x91fc003d}},	//   _גידו, _haoi, tuzs, akār
  { {0xb05b00f2,0x90e600e5,0xa1930033,0x6d40002a}},	//   lmäm, _استن, _нашч, łman
  { {0x7d150030,0xb4fb004f,0x6b7500ce,0xbca5009a}},	//   ruzs, טפלי, олбу, آمري
  { {0x64420a7b,0x2ca90a7c,0xfbd00015,0xd9f903ae}},	// [d30] _maoi, road_, فتك_, инац_
  { {0xacf8005c,0xf9c70457,0x7f4d0a7d,0xd759002b}},	//   _żółt, бщен, _iraq, یلات_
  { {0xb05b00f2,0xb9250015,0xe10b000a,0xdb060046}},	//   ymäl, تفضي, ָּבָ, _vyká
  { {0x6d400048,0xdb0f0152,0xd8250036,0x07d80015}},	//   āmat, _lycé, ідли, مذهب_
  { {0xbc1a0008,0x76410007,0x248d0a7e,0x27fd0335}},	//   _דורש, _paly, viem_, rawn_
  { {0xf1c8014e,0x248d005c,0x91fc0024,0x5b56000a}},	//   रधान, wiem_, zkār, _וישב_
  { {0x248d0048,0x9f400084,0xf5560021,0x76410351}},	//   tiem_, _leið_, قلوب_, _valy
  { {0x7b080084,0x13090a7f,0x7aed0a80,0x628a0a81}},	//   _ástæ, аний_, opat, _amfo
  { {0xb7bd04f9,0x6442002f,0x248d0a7e,0xdc6c000a}},	//   _obţi, _daoi, riem_, ר֣וֹ
  { {0x248d0048,0xbb3c0053,0x2f10002e,0x41050a82}},	//   siem_, רעזי, _lögð_, озов
  { {0x6442002f,0x91fc0024,0x645d0a83,0x248d003d}},	//   _faoi, tkār, ösis, piem_
  { {0xf4350010,0x9fca0254,0xb184006f,0xb7bd0045}},	//   _федэ, игна_, íťaz, _abţi
  { {0xe28e076c,0x98c50007,0x083a0053,0xa2da000b}},	//   _жа_, štės_, בערל, नदण्
  { {0xc5f90053,0x6e960015,0xc2c40015,0x91fc003d}},	//   יפֿט, زلزا, _فيني, skār
  { {0xa3c1005d,0xa01b0a84,0x7aed0a85,0x6c360015}},	//   ंधक_, giös, epat, يفسا
  { {0x6f000014,0x7f4d016e,0xec160015,0x7188000a}},	//   ámcs, _fraq, تورد, _לְפַ
  { {0x7aed00b6,0xcb0a0067,0x2ab4007c,0xa01b008c}},	// [d40] gpat, شيان_, läbi_, riöt
  { {0xf9920115,0xf221000b,0x6d5a008c,0x63b600cb}},	//   وبا_, _माफ़_, ätas, _øyne
  { {0x6ee50086,0x64970024,0xdca60a86,0x7aed0a87}},	//   _وسیل, rģij, _маои, apat
  { {0x628600dc,0xd7ef0029,0xa01b0a88,0xb05b005b}},	//   ékoz, نكم_, rhög, ymäm
  { {0xf1ab000b,0xa6f30033,0x6d43001a,0xa01b0123}},	//   _घुसन, дзіш, _ánar, shög
  { {0x6b630010,0x6442002d,0xf1bb000b,0x64970045}},	//   _ўкра, _saoi, ैधान, nţif
  { {0x9e5b0643,0x9e0b000a,0xdddc0030,0x2aaf0012}},	//   יכסט, שִׂ֖, nkrő, rübt_
  { {0xe814005d,0xa3e5005d,0x9998003d,0x387d0034}},	//   _डाटा_, बुल_, _garš_, chwr_
  { {0xd5a4002b,0x66e50015,0xa01b02ad,0x0000006a}},	//   _کلای, _فألق, ziös,
  { {0x026a0036,0x3f820a89,0x3678000a,0x9f40001a}},	//   рший_, dzku_, _פְּע, _reið_
  { {0x3a37013a,0x7aed005c,0x8cd6000b,0x64420a8a}},	//   חרים_, zpat, _मंगो, _taoi
  { {0xb05b00f2,0x232a0317,0x91fc003d,0x628f0a8b}},	//   mmäk, _води_, akāp, écor
  { {0xe29a0124,0xd2520015,0xb05b008c,0x0000006a}},	//   _кад_, _ينص_, lmäk,
  { {0x29070014,0xa2c1000b,0x628a0012,0x2f10001a}},	//   ának_, _रीप्, _umfo, _sögð_
  { {0x12a90029,0xdb06008c,0xdc8b045f,0xb05b008c}},	//   _ادنى_, _lykä, асал_, nmäk
  { {0xe57100b2,0x69d80007,0x9b890029,0x317b000a}},	//   ײַל_, žvel, منزل_, _כרומ
  { {0x7aed003f,0x5b150a8c,0xda670015,0xddde002a}},	// [d50] upat, ямат, يائي, _dopł
  { {0x8e840054,0x7aed0a8d,0xbce70058,0xcce70058}},	//   _огње, rpat, _وأجو, _وسجي
  { {0xdc2f0024,0x629a0a8e,0xd8b9002b,0x7aed07fc}},	//   ažād, into, مگرا_, spat
  { {0x7c590015,0xf807005e,0x7aed0a8f,0x6d58013f}},	//   _الحر_, ічен, ppat, _švag
  { {0x8cba005d,0xfc5a0008,0xd00c000a,0x78ab02de}},	//   ्षरो, _הכרמ, בּוֹ, rogv
  { {0x1af6000a,0x7f3c004f,0x0000006a,0x0000006a}},	//   _ממשל_, יעדו,   ,
  { {0x2d83002a,0xa506006b,0xa9550033,0x929d002a}},	//   nzje_, пеща_, _экві, jsła
  { {0x629a0a90,0xc952004f,0xbd9c004f,0x0000006a}},	//   ento, _אמל_, יסות,
  { {0xf7730018,0x3834017f,0x9c08000a,0x91fc003d}},	//   _غار_, _інфр, חִתִ, tkāp
  { {0xaabd000b,0xc6d40015,0x7d080046,0xb05b0a91}},	//   ्गिक, _قتلت, ádsk, lmäh
  { {0x0202008f,0x85050086,0xe45f0020,0x91fc0024}},	//   эзэн, _روشن, öös_, rkāp
  { {0x55ba0008,0x629a0a92,0x92a4002a,0x8fa60a93}},	//   _המעו, anto, ółrz, заме
  { {0xc4840033,0xaabd0065,0x5f760058,0x2349009a}},	//   _ўлік, ्गाक, ساحر, _دسای_
  { {0x92b70015,0x02450015,0xb05b0a94,0x0000006a}},	//   _بحصا, _رَبَ, hmäh,
  { {0x7c2f0011,0xdd920115,0x3179004c,0x99930046}},	//   _bbcr, رور_, _לאַד, dexů_
  { {0x8fa6005e,0xec34002b,0xa7fd0030,0xaf0601e1}},	//   _найе, بورگ, _elűz, _епил
  { {0x207b0053,0x8e560036,0x6a72001a,0x69da0015}},	// [d60] _לאקא, _етні, _hæfi, مباح_
  { {0x7c2f0134,0xdb06005c,0x20020a95,0x1eaa0015}},	//   _ebcr, _szkó, laki_, _داعي_
  { {0xceb300b4,0x4ddb0008,0xe8530086,0x9ddb000a}},	//   _איז_, _לחיו, کنند, _לקיח
  { {0x38cb0074,0x18a3006b,0x6f0602de,0xdca60302}},	//   مانی_, нахм, oskc, _хами
  { {0x29130251,0x629a00e7,0x99f60033,0xb8650369}},	//   arxa_, ynto, _няві, بالو
  { {0xd6d90036,0x929d005c,0xdcdb0065,0x98b10535}},	//   іті_, ysła, _मूँछ, _mszę_
  { {0xe9a30a96,0x442f0a97,0x9538005e,0x20020a98}},	//   _зарп, _bbg_, ізит_, kaki_
  { {0x399b0008,0x499b0008,0x629a0a99,0x200201ff}},	//   _הילד, _השלב, wnto, jaki_
  { {0x200201e2,0x6b8400b8,0x291a0a9a,0x83fd0030}},	//   daki_, nzig, lupa_, rkőp
  { {0xb05b022d,0x877b0008,0x1546005e,0x629a0a9b}},	//   mmäi, _האמי, _незм, unto
  { {0x24970074,0xa6e90023,0x2bb9005d,0xdb2300dc}},	//   _کنند_, _chươ, _आर्थ, _öröm
  { {0x60c40738,0x35e2000b,0xb9bb004f,0x2fd90058}},	//   _chim, _पलड़, מצית, توحد_
  { {0x6b840a9c,0x60c4003f,0xa867000a,0xbfab0a9d}},	//   jzig, _dhim, לֹךְ_, стне_
  { {0x291a0a9e,0xd3570008,0x539b0008,0xe731000a}},	//   kupa_, _מידי_, _פיגו, כֵל_
  { {0x2002000c,0xeda40036,0xb2bb000a,0xd12f062f}},	//   baki_, ешто, _המגר, _ях_
  { {0x30a4008f,0x5cb90010,0x60d60061,0x319b000a}},	//   _прыв, ілаў_, _giym, _לבונ
  { {0x3f9e01e2,0xcb34006b,0x290e0052,0x0000006a}},	// [d70] ştur_, нетъ, áfan_,
  { {0x99d70029,0x3f7c000a,0x49cb0033,0x0b88005e}},	//   ستطا, _לאחס, буем_, їсти_
  { {0x290701cb,0x6d410061,0xf8b1002b,0x291a02f2}},	//   éna_, çlad, نکر_, gupa_
  { {0x38690084,0x6a730064,0x6b840012,0xec150058}},	//   ðar_, _sıfı, bzig, _توحد
  { {0xf72b0010,0x64970011,0x08d4002b,0x600c000a}},	//   сцей_, nţie, رآمد, מִגְ
  { {0x20020a9f,0x442f01d7,0x7c2d0aa0,0xf2180065}},	//   zaki_, _sbg_, lfar, _दाग़_
  { {0xa93405fc,0x6f090089,0xb93403ae,0x64a50aa1}},	//   _перш, šech, _перј, мака
  { {0x6d7c000a,0xf992000a,0xb4b7000b,0x200200aa}},	//   מאוח, _סרן_, छते_, xaki_
  { {0xd408002b,0x20020aa2,0x7c2d0aa3,0x63e40015}},	//   ستيم_, vaki_, ifar, رسيك
  { {0xa6e90023,0x3ce0000b,0x7c2d00a9,0x60c40aa4}},	//   _phươ, कदमे_, hfar, _shim
  { {0xb97a0053,0x213e0026,0x10a60805,0x20020aa5}},	//   ַנשי, gwth_, динн, taki_
  { {0x66030aa6,0xf4b6002b,0x0000006a,0x0000006a}},	//   lank, _قشنگ,   ,
  { {0x64490176,0x7d1506cd,0x7c2d0aa7,0x64590aa8}},	//   mdei, erzs, dfar, _inwi
  { {0xa6e90023,0x442d0aa9,0xe2c90031,0x60c400da}},	//   _thươ, lfe_, _بوتو_, _whim
  { {0x64970045,0x60c40aaa,0xa06a045f,0x20020aab}},	//   aţie, _thim, _мака_, paki_
  { {0xf1a70086,0x27ff00b8,0x64490aac,0x6b840012}},	//   _واژه_, _neun_, ndei, tzig
  { {0x64970011,0x3e740020,0x2bc3005d,0x442d0334}},	// [d80] cţie, _läti_, _शरणा, ife_
  { {0xcf250015,0x6b840012,0x19960054,0xe9d20015}},	//   _أريي, rzig, мјер, نغا_
  { {0xb80a0029,0x66030aad,0xcb090008,0xccc601c5}},	//   قيام_, dank, של_, _обой
  { {0x224700dd,0xccf30008,0xca29039e,0x291a0aae}},	//   _lank_, _שכר_, ים_, rupa_
  { {0x64490026,0x7d1c03ba,0xc6f7022a,0x073a00e6}},	//   ddei, lurs, дніх_, تساب_
  { {0xcb8b01d8,0x442d0aaf,0x929d002a,0xea000016}},	//   _וְלֹ, efe_, dsło, _đặn_
  { {0x69dc001c,0x442d0645,0x75d30067,0x45470033}},	//   _igre, ffe_, نيها, дчым_
  { {0x3ae400c0,0x442200dc,0x660300f2,0xb05b00f2}},	//   _köp_, ük_, aank, lmäv
  { {0x7ae2002d,0x22470ab0,0xbcb7000a,0x7d1c0ab1}},	//   íoth, _bank_, ופקו_, hurs
  { {0xb2380015,0x64490ab2,0x38660123,0x07a307c9}},	//   أكدا_, adei, ljor_, _раун
  { {0x018a0080,0x7c2d0026,0xd257005e,0x8a17000a}},	//   ющий_, yfar, єць_, וחיו_
  { {0x7d1c0084,0x73c60029,0x1c1d000b,0xb08b0033}},	//   durs, _قيام, _फाइल_, іёне_
  { {0x7d1c00dd,0xdfd80063,0xf487002b,0xd372002b}},	//   eurs, дър_, _تالی, _جهش_
  { {0x53330036,0x69dc0ab3,0x6a72001a,0x62810ab4}},	//   _решт, _ngre, _kæfu, chlo
  { {0xf1aa0086,0xc3480092,0xec6b09e8,0x764801c2}},	//   _باشه_, _hổ_, орак_, _mady
  { {0x69dc03b8,0x64970045,0x1bd5033d,0x90a70015}},	//   _agre, pţie, еобя, _تحتم
  { {0x7c2d0ab5,0xdfd10015,0xab940432,0x6f2a002a}},	// [d90] rfar, _حية_, ватљ, ępcó
  { {0x68fc0026,0x27ff00dd,0x1a65002b,0xaceb0015}},	//   _bwrd, _seun_, ریزی_, _ورجل_
  { {0x5e5600b2,0x64490026,0x68fc0026,0x7d1c0ab6}},	//   _װירע_, ydei, _cwrd, curs
  { {0xb8e7000b,0xe7d3002b,0x929d002a,0x765a0ab7}},	//   _उठ_, نماگ, ysło, _anty
  { {0x764800b6,0xc3480092,0xa6e70092,0x87d40015}},	//   _bady, _nổ_, _giữ, نغها
  { {0x8afa0008,0x68fc0026,0x8f9c000a,0x6f1d02b9}},	//   _מהשי, _fwrd, חידי, iusc
  { {0x66030ab8,0x2496002b,0x68fc0034,0x22470ab9}},	//   rank, کنيد_, _gwrd, _rank_
  { {0xc3480023,0x6d45003f,0x93450aba,0x765a05bc}},	//   _bổ_, _msha, ение, _enty
  { {0xc3480092,0x22470abb,0x62810495,0x6f1d0abc}},	//   _cổ_, _pank_, thlo, jusc
  { {0xe1f10029,0x272902c1,0xda0f005d,0xe5f50015}},	//   دسة_, mún_, ाणित_, _أكاد
  { {0x9f5e0064,0x442d00b8,0x386d007c,0x6e3c02b3}},	//   ştü_, pfe_, _koer_, verb
  { {0xf76700a2,0xc9520053,0x6e3c0abd,0x64590abe}},	//   ها_, אמט_, werb, _unwi
  { {0x24180036,0x22470abf,0x7f760054,0x249f001a}},	//   _цією_, _tank_, хунц, mnum_
  { {0xdce7005c,0x7f750010,0xe732000a,0x6e3c0012}},	//   zyją, туюц, נֵר_, uerb
  { {0x387f0064,0x7afd0026,0x11450029,0xd5b2000a}},	//   _olur_, _awst, _أَبُ, ָׁן_
  { {0x249f002e,0x660100dc,0x10690029,0x7d1c0ac0}},	//   nnum_, _lelk, _يحيى_, rurs
  { {0x249f002e,0xc4d200f3,0xb09b00f3,0x1fb6017f}},	// [da0] inum_, רגן_, _מיקר, _яскр
  { {0x7fd70008,0x32050046,0x387f088a,0x6497003d}},	//   _אופס_, naly_, _alur_, oģis
  { {0x249f0ac1,0x980a0015,0x8dfb000a,0x76480ac2}},	//   knum_, كتشف_, _מהית, _rady
  { {0x3f7a0135,0x76480035,0xe704002b,0x32050046}},	//   ּאַס, _sady, نستی, haly_
  { {0x61360014,0x27290467,0x32050046,0x66010ac3}},	//   _külö, gún_, kaly_, _belk
  { {0x66010156,0xe7690046,0xc3480016,0x8cba000b}},	//   _celk, nářů, _rổ_, ्षको
  { {0x249f0084,0xc3480092,0x76480007,0x2ca00020}},	//   fnum_, _sổ_, _vady, onid_
  { {0x249f0084,0x66010020,0x95530031,0x5454071a}},	//   gnum_, _eelk, اخوا, твит
  { {0xcc3b00b2,0xb05b00c0,0x9cd70008,0x64970024}},	//   לעקט, lläg, עופה_, eģis
  { {0x2ca0002d,0x179b000a,0x2c7c0077,0xb05b008c}},	//   hnid_, _זימב, _oído_, hmät
  { {0x2b91002c,0xb05b00c0,0xd6cf0115,0x5a17004c}},	//   môcť_, nläg, _اقل_, עקטן_
  { {0xc3480023,0x33f60029,0xa4fb0053,0x69c3005c}},	//   _tổ_, _أساس, _זלאט, żneg
  { {0xb05b00b8,0x93260086,0xf09f0144,0xdb1d0061}},	//   hläg, _سرشن, rnà_, üyük
  { {0x6f1d002f,0x877b000a,0xa01b0028,0xc7b1000a}},	//   rusc, לאכי, chön, ׁ֑ם_
  { {0xac95007a,0x4c95005e,0xc2c30015,0xc534000a}},	//   вавш, вивс, _حيوي, כָּה_
  { {0xdcb8010f,0x91bb000a,0xc1bb000a,0x31bb000a}},	//   ещу_, _ממוי, _ממוש, _מזונ
  { {0x649704f9,0x613600dc,0xc3340008,0xfaf000e6}},	// [db0] nţia, _fülö, כוּ_, مثل_
  { {0xdb260086,0x2ca0007c,0x6e250012,0xb05b0ac4}},	//   ئولی, anid_, _uchb, amät
  { {0x6d45003f,0xd7f10015,0x249f001a,0xad19004f}},	//   _usha, لكا_, ynum_, _קוֹר
  { {0x660100f2,0xb05b00f2,0xb06600f2,0x27290ac5}},	//   _selk, mmäs, mpää, tún_
  { {0xf7450ac6,0xd6db0ac7,0x386d049c,0xb05b0ac8}},	//   тело, чте_, _voer_, lmäs
  { {0xe9d30086,0x64970091,0x29070125,0x69350ac9}},	//   _مغز_, dţia, ánas_, _ингу
  { {0x32050089,0x386d00dd,0x2729002d,0x249f002e}},	//   valy_, _toer_, sún_, tnum_
  { {0x66010384,0x249f002e,0xddde0046,0x3e740012}},	//   _welk, unum_, _dopř, _hätt_
  { {0xb05b00f2,0x249f0aca,0x8c1c000a,0x0219005e}},	//   hmäs, rnum_, פוזי, мінь_
  { {0x249f001a,0x42550004,0x5edc000b,0x44260acb}},	//   snum_, ттит, _गूग्_, _eco_
  { {0x249f002e,0xb05b0ac8,0xa01b001a,0xc1780174}},	//   pnum_, ymät, rhön, есяц_
  { {0x3e7400c0,0xcea9000a,0xdee60acc,0xa01b001a}},	//   _lätt_, _וי_, коми, shön
  { {0xab5b00dc,0x10a30805,0x443f0acd,0xcf430088}},	//   _szün, риян, meu_, аняй
  { {0x63a400df,0x443f0ace,0x6f0d0089,0x644b0acf}},	//   _žing, leu_, _dvac, _hagi
  { {0x81740086,0xc69201ac,0x27ed0012,0x29070045}},	//   _منوچ, באם_, _ofen_, ânal_
  { {0x443f0ad0,0x7f860029,0x644b0ad1,0x6f960015}},	//   neu_, _للبن, _jagi, _للعض
  { {0x644b0ad2,0x443f0ad3,0xb0b7000a,0x7c2b0144}},	// [dc0] _magi, ieu_, _בפקס_, ògra
  { {0xaa7b002e,0x644b0ad4,0x6a830004,0x38bc0030}},	//   _stýr, _lagi, алуа, míri_
  { {0x4806005e,0xa9260457,0xb05b0309,0x6f0d0046}},	//   впев, тдел, mmär, _zvac
  { {0x644b0ad5,0xb05b0ad6,0x63a4001a,0xd6e2002a}},	//   _nagi, rläg, _þing, ykłą_
  { {0x443f0ad7,0xb05b00c0,0x27e00ad8,0x38130033}},	//   deu_, släg, žino_, рміё
  { {0x7bc600bd,0xb05b0ad9,0xddde0089,0x44260ada}},	//   _izku, pläg, _popř, _sco_
  { {0x443f0251,0x85460010,0x644b064e,0x75d40029}},	//   feu_, тэле, _bagi, ديثا
  { {0x38c80074,0x443f0adb,0x644b02b9,0x7c240adc}},	//   _سازی_, geu_, _cagi, ngir
  { {0xb05b00c0,0xf3630033,0xf2c60add,0x03c300f4}},	//   kmär, атэн, ксон, исьм
  { {0xb05b00f2,0x64970011,0x7af60091,0xd257005e}},	//   ymäs, rţia, ipyt, вцю_
  { {0x443f0ade,0x78a201a3,0xfa77000a,0x63a40091}},	//   beu_, onov, דעית_, _žind
  { {0x04460124,0x61f50064,0x443f0adf,0xe4d6002b}},	//   _једн, ızla, ceu_, _شتاب
  { {0x64400064,0x9f590123,0x62340ae0,0x78a20ae1}},	//   memi, kaså_, _белу, inov
  { {0x649704f9,0xd130002b,0x64400ae2,0x644b002a}},	//   nţin, _همت_, lemi, _zagi
  { {0xf7080092,0xac27000d,0x3e7400c0,0x4dd40058}},	//   hủ_, кфак, _rätt_, لتفس
  { {0x3e7401d1,0x64400ae3,0x6abd000b,0x7c2402b9}},	//   _sätt_, nemi, ्ग्र, ggir
  { {0x5a350403,0x3b550010,0xfbd00015,0x40bc000a}},	// [dd0] лнат, ыкар, قتك_, _קזחס
  { {0xdce7005c,0x443f0ae4,0x2489006f,0x753a0045}},	//   zyję, zeu_, ďami_, _optz
  { {0x83fd00dc,0x7af6005c,0x64400ae5,0x39150ae6}},	//   rkőz, apyt, kemi, умер
  { {0xc19b0008,0x443f0251,0x64970045,0x28f8005e}},	//   ושבי, xeu_, eţin, тець_
  { {0x8c1a0008,0x443f0ae7,0x6ca8000a,0x644b0ae8}},	//   _אורי, veu_, _יֹשְ, _ragi
  { {0x7624005e,0x644004f6,0xd6260054,0xe5a50974}},	//   иміз, eemi, гоше_, лили
  { {0x443f0ae9,0x644b0aea,0x2e38000a,0xce38000a}},	//   teu_, _pagi, דרוש_, דאות_
  { {0x64400005,0x69c70796,0x95740033,0x03250004}},	//   gemi, _izje, рышч, гдин
  { {0x443f0aeb,0x64970045,0xd29900fd,0x644b0aec}},	//   reu_, bţin, етні_, _vagi
  { {0x443f0ae9,0xeb92000a,0x00da002b,0x565b0015}},	//   seu_, מָת_, کبخت_, _تشرح_
  { {0xe4e70191,0x44f50063,0xab5b00dc,0xef1f00dc}},	//   _різн, _спес, _szül, szül_
  { {0xa3550002,0xa3ea000b,0xe588000a,0xa936000a}},	//   _مختص, _मलय_, _בָנָ, נטרה_
  { {0x6d410064,0x9975005c,0xa856000a,0xee160033}},	//   çlan, nęła_, אירה_, львэ
  { {0x539a00a3,0xdee30aed,0x78a20aee,0xc7b2004f}},	//   _אינו, сори, znov, צבם_
  { {0x64970011,0xc6920aef,0x81bc003d,0x621a000a}},	//   nţio, זאם_, sfēr, _טוסק
  { {0xb05b0005,0xdd8f0029,0x91ba000a,0x3e7405ff}},	//   smär, سوق_, _אמצי, _päts_
  { {0xb05b00c0,0x9975005c,0x5f46002b,0x5b260015}},	// [de0] pmär, jęła_, _صندل, طفال
  { {0x7f29000a,0xca4a0015,0x2d9e0003,0xb05b008c}},	//   _סֵפֶ, علاه_, ûtes_, lmäp
  { {0xaf360086,0x82960053,0xdce80024,0x64400061}},	//   _شرکت, נדעס_, ēlēt, yemi
  { {0xe3a70074,0x6440016e,0xad1b000a,0x6d400045}},	//   _هر_, xemi, _אוטר, ămad
  { {0x47330086,0x2bba0015,0xb8eb000b,0x78a20af0}},	//   مروز, _ساحة_, _री_, rnov
  { {0x78a201a3,0x69c30061,0x96b70054,0x96330033}},	//   snov, ünec, лују_, йніц
  { {0x64970011,0xafdb0293,0x64400af1,0xcdf7000a}},	//   rţin, ndør, temi, אמצי_
  { {0x64970011,0xe3140004,0x78a201c0,0x54360058}},	//   sţin, амињ, čovs, ارغر
  { {0xeb970053,0xf2060af2,0x64970045,0xdc3b004c}},	//   ָדיר_, ляно, aţio, געפר
  { {0x67220007,0xd9f6000b,0x64400af3,0x86c60021}},	//   muoj, ेरित_, semi, _صيان
  { {0xd657013a,0x64970011,0x3cf8002c,0xba9b000a}},	//   _תיבת_, cţio, jprv_, תסיי
  { {0xf9930008,0x64970011,0xe58b0008,0x9f59002d}},	//   מרת_, nţil, _אָדָ, masú_
  { {0x26de0007,0x67220007,0xf4870086,0x7ae6003f}},	//   _kito_, nuoj, _حالی, _nukt
  { {0xc7b3013a,0xb05b018b,0x0cbf005d,0x38bc0046}},	//   מבר_, fläc, ्ष्म, míru_
  { {0x6d58002e,0x765e00f2,0xc27b01ac,0x6ca70af4}},	//   _ával, öpyy, _ארגי, граж
  { {0x67220007,0x1f7509ef,0x7ae60509,0x44ea0016}},	//   kuoj, _влия, _bukt, _mù_
  { {0x26de001c,0x67220007,0xafdb0af5,0x2d9e0003}},	// [df0] _oito_, juoj, rdøs, ûter_
  { {0x44ea038d,0x26de00b6,0x200b06d5,0x67220007}},	//   _où_, _nito_, laci_, duoj
  { {0x629a0af6,0x60cd0af7,0x6288008c,0x2aa8030c}},	//   iito, _kham, ihdo, утто_
  { {0x8934003b,0xa5650086,0x6cfa000a,0x9be4005e}},	//   إعلا, یگان, _שפרס, _гірк
  { {0xe7580036,0x67220007,0x4804005e,0xd6d5004a}},	//   лиці_, guoj, спів, ажды
  { {0x99d70029,0x44ea0092,0x87040146,0x629a0af8}},	//   _متزا, _bù_, сяце, jito
  { {0x200b02d5,0x26de0af9,0x6f1d00b8,0xb05b008c}},	//   kaci_, _dito_, hrsc, ymäp
  { {0x44ea0023,0x628800f2,0x200b049f,0x9733002b}},	//   _dù_, ehdo, jaci_, _هکتا
  { {0xd627003b,0xc4820191,0xe3b10029,0x66270029}},	//   _معاي, ільк, غرب_, _مراك
  { {0xa7740afa,0x64970011,0x65950afb,0x629a0afc}},	//   _улуч, pţio, _казу, gito
  { {0x42540010,0x64970011,0x76430afd,0x628301c9}},	//   стыт, lţim, meny, _vlno
  { {0x628800f2,0x200b0afe,0xb4fa000a,0x60cd0aff}},	//   ahdo, gaci_, _יפעי, _cham
  { {0x60cd003f,0x23290457,0xe3b30021,0x9046002b}},	//   _dham, _роли_, _ارض_, هنگه
  { {0x62880b00,0xc7d6000a,0x78a90085,0x41e700e2}},	//   chdo, יורי_, _ljev, _сіда
  { {0x9cb60029,0x67220007,0x200b016f,0xc69201ac}},	//   لمست, zuoj, baci_, קאל_
  { {0x70b30015,0x200b0b01,0x3ceb0069,0x60cd01f9}},	//   _وموض, caci_, _živí_, _gham
  { {0x4e1a0080,0x3ae80086,0xc9f60015,0xed59003d}},	// [e00] _июня_, ابری_, لساع, āža_
  { {0xda790036,0xef1f00dc,0x6e930015,0xff7b015b}},	//   ляє_, zzük_, _وليا, _סטימ
  { {0x2bb8005d,0xfe370053,0x26de0b02,0xd82601b7}},	//   _आडवा, _דריי_, _rito_, иджи
  { {0x26de02d7,0x09c6005d,0x38cb0086,0x31360053}},	//   _sito_, _वरीय, نانی_, ינעם_
  { {0x64970011,0x87030b03,0x30d90053,0xabfb0008}},	//   rţil, ояще, אַװע, _בהכר
  { {0x7523000c,0x200b02d5,0x67220007,0x254700dc}},	//   funz, zaci_, ruoj, _ből_
  { {0x32180050,0x67220321,0x629a0b04,0xaa3b000a}},	//   órym_, suoj, vito, _שתלח
  { {0x660a0134,0x3c76000a,0x3eb80b05,0x67220091}},	//   safk, יתֶם_, hort_, puoj
  { {0xc3270015,0x200b0b06,0xe3af0015,0x628800e7}},	//   لكين_, vaci_, ِرٍ_, thdo
  { {0xab5b0014,0x44ea0092,0x78a90089,0x60cd0b07}},	//   _szük, _tù_, _zjev, _sham
  { {0x3207003e,0xa44603fc,0x25eb000b,0x68e00061}},	//   _deny_, _внед, _चलती_, _kimd
  { {0x859b0008,0x6d410064,0x757b0053,0x80a40015}},	//   _בשבו, çlam, _שטאפ, ْمَن
  { {0x200b036e,0xe8d7004c,0x6f1d06a8,0x3eb80043}},	//   raci_, יוטר_, ursc, fort_
  { {0x6f1d018b,0x92b30015,0x333b004f,0x02440058}},	//   rrsc, _وحوا, _סתומ, _طَعَ
  { {0xbc070b08,0xfce90015,0xacf70015,0x6d470079}},	//   ичай, افري_, ؤسست, uwja
  { {0x60cd003f,0xe58b000a,0x7e20000b,0x11db000a}},	//   _uham, דָמָ, बलॉग_, _בחוב
  { {0x6a15004a,0xfbd3002b,0x3b54052b,0x929d002a}},	// [e10] ймау, زتر_, октр, asłu
  { {0x78a9016f,0x929d005c,0x3eb80b09,0x7ac4030c}},	//   _sjev, bsłu, cort_, осхе
  { {0x7ed40029,0x78a9016f,0x29670001,0xda08002b}},	//   _بزيا, _pjev, шњав, شينه_
  { {0x7643000c,0x254700dc,0x320c0057,0xc052000a}},	//   weny, _ről_, hady_, ּ֖א_
  { {0xa01b00b8,0x9848006b,0x320c002a,0xec6801b0}},	//   rhöh, ряха_, kady_, _трэк_
  { {0x7bda0008,0x7523003f,0x2ee90061,0x8b76000a}},	//   _תקשו, tunz, _muaf_, _התשע_
  { {0xbe3c0008,0x361800ce,0x3634009a,0x6608013b}},	//   דעות, рцію_, ترنس, _dedk
  { {0x76430b0a,0x320c00da,0x63a40091,0x98140015}},	//   seny, eady_, _žina, _وبقا
  { {0x752302b9,0x76430b0b,0x437500c2,0x0000006a}},	//   sunz, peny, суйт,
  { {0xf6740029,0x16380029,0x254700dc,0x06380015}},	//   _والخ, _نسمة_, _től_, _نسمع_
  { {0x3eb8002e,0x05790015,0x7c360034,0xd00a0b0c}},	//   vort_, _حماة_, yfyr, лене_
  { {0xb7bd04f9,0x3eb800b8,0x1287009a,0x200900d4}},	//   _acţi, wort_, امگی_, _ceai_
  { {0xd12e0074,0x42d50036,0x998c002a,0x3eb80b0d}},	//   ومی_, _ліку, _łoże_, tort_
  { {0x201e0b0e,0xa2f6000a,0x412900af,0xddde00d4}},	//   şti_, _המסה_, _боко_, _copş
  { {0x70f50029,0xd1480086,0x80f50029,0x3eb80b0f}},	//   _استئ, _نشين_, _استض, rort_
  { {0x6f04003e,0xada30010,0x27e00796,0xd12e0015}},	//   _twic, часл, žini_, _أمي_
  { {0x7c360b10,0xc4d2000a,0x3eb80b11,0xcb67007e}},	// [e20] rfyr, לגל_, port_, бате_
  { {0xb05b079c,0xa96a0579,0xda0a0015,0x6e460015}},	//   nlän, лиза_, اياه_, _اندم
  { {0x660800bd,0xb05b0b12,0x628100bc,0x8c46009b}},	//   _redk, ilän, iklo, _лене
  { {0x510a0053,0x80ce0065,0x0aea0058,0xb05b02ad}},	//   רהײַ, _धीमे, _مرسي_, hlän
  { {0x4cbb0008,0x68fb02d8,0x68430033,0x6c57004f}},	//   _תזכו, _čude, янца, _היכא_
  { {0xfd650023,0x07070015,0x24860085,0x0000006a}},	//   _nguồ, حيوي_, _slom_,
  { {0x9986003b,0x5d7a00b2,0x27e90263,0xc8f8000a}},	//   _الأو, טאַק, žana_, _כִּכ
  { {0x4917000a,0xa2f404e5,0x320c0b13,0xb05b02ad}},	//   _לקלל_, опич, wady_, elän
  { {0xf3ef0029,0xc4450086,0x77860001,0x8c1b000a}},	//   رأي_, زیون_, _улаз, אופי
  { {0x27320011,0xb1140004,0xda08000b,0xb05b0b14}},	//   mân_, омош, षरित_, glän
  { {0x3abb00b2,0xd2570010,0xaabb0053,0x85f70008}},	//   רמינ, сцы_, רזיכ, _הצבע_
  { {0x320c0b15,0x629d0003,0xf08b0015,0x62810b16}},	//   sady_, ésor, ائده_, aklo
  { {0xa4b7000a,0xff04006b,0x489b004c,0x43430033}},	//   _פלדה_, зясн, ריכװ, _нецв
  { {0xa2d30015,0xacf90511,0x62810b17,0x0000006a}},	//   _فينت, ингу_, cklo,
  { {0x40350b18,0xf5180008,0x27320b19,0x667b000a}},	//   _дейс, יֵּל, hân_, נטלק
  { {0xa0a40b1a,0xce330086,0xa01b00c0,0x859b004c}},	//   _најд, _کودک, ehöv, אשלו
  { {0xba75004a,0xf09f0144,0x1eab0015,0xf1bf0046}},	// [e30] огащ, mià_, _مادي_, řát_
  { {0xf09f0251,0x51f8000a,0x9e0705aa,0x99d70058}},	//   lià_, שִּׂ, _учил, متضا
  { {0xe291004f,0x28150369,0x0000006a,0x0000006a}},	//   וְא_, قواس,   ,
  { {0x17fb0029,0x50c9005d,0xf09f0144,0x6281035f}},	//   ارضة_, रतिष, nià_, zklo
  { {0xf105014e,0x27320092,0xd5e509a7,0x6c56000a}},	//   _शब्द_, gân_, ожли, _וירא_
  { {0x45190404,0xb05b0123,0x2ca902dc,0x6d580073}},	//   ация_, xlän, lnad_, _švai
  { {0x2ca90b1b,0xf69600c3,0x1a68002b,0x4c4b004f}},	//   onad_, تنوع_, _دیلی_, ָתִ֑
  { {0x2ca90005,0x8339000d,0xf1c30089,0x1d0c000a}},	//   nnad_, ачот_, _liší_, נּוּ
  { {0x64970011,0xf09f0144,0x20d20030,0xb05b0400}},	//   nţii, dià_, láig_, tlän
  { {0xe2990001,0x2ca90026,0x92e80015,0x0000006a}},	//   рао_, hnad_, حريق_,
  { {0x63a409f0,0xc6680083,0x13f5008f,0xb05b0b1c}},	//   _þinn, _уште_, _дзея, rlän
  { {0x61fc0064,0xb05b07fd,0x45b6000a,0x10050033}},	//   ırla, slän, _ופעל_, зяём
  { {0x6b89002a,0x1eca006b,0xb05b0b12,0x61fc0030}},	//   _żegn, илми_, plän, űrla
  { {0xb7da0008,0x3f8c005c,0x20d20030,0x0eba0174}},	//   יקרי, ądu_, káig_, румы_
  { {0x3f84002c,0x1d0a01dc,0x6e21001a,0x248d02ad}},	//   šmu_, реби_, ólba, ohem_
  { {0x90c30b18,0xf09f0251,0x2ca900c0,0x248d0b1d}},	//   _обще, cià_, gnad_, nhem_
  { {0xdca30b1e,0x2002007c,0x6a160015,0x1db6000b}},	// [e40] фати, mbki_, قبار, _आँकत
  { {0x4a430004,0xa01b0012,0xdcf60015,0x076a002b}},	//   мнув, nkön, _وأجب, یماً_
  { {0x02b60053,0x57ea03de,0x64970045,0xdb060123}},	//   קלעך_, адем_, aţii, _nykö
  { {0xd7f00029,0xaf35002b,0x718a004c,0xa01b0b1f}},	//   ركت_, _بویژ, סװײַ, shöv
  { {0x64970011,0x27320092,0xa01b008c,0x249f0b20}},	//   cţii, uân_, kkön, dium_
  { {0x63a400df,0x057600e5,0xe6930015,0x8ab8000a}},	//   _žino, قاعد, ولند, _הֶֽח
  { {0x38cb002b,0x29070045,0x442f0b21,0x65140058}},	//   _چاقی_, ânat_, _bcg_, أوبئ
  { {0x69ce0582,0x7d7b0643,0xb866006e,0x249f0b22}},	//   _izbe, ינצו, _باسو, gium_
  { {0x6843008f,0xd7ef0029,0xf09f0144,0xb6a60acc}},	//   _інфа, _شكل_, vià_, _диал
  { {0xa5f70001,0xc2170036,0x2ca90085,0xd250012c}},	//   _међу_, оєю_, znad_, رنج_
  { {0xe3af0086,0x2166005e,0xdb0f00e9,0xf09f0144}},	//   فری_, ітог, _excè, tià_
  { {0x6e3e00d9,0x320a002a,0xb4e6000b,0x27e00b23}},	//   _abpb, źby_, पदी_, žinu_
  { {0xb4c8005d,0x98b3016f,0x5f940063,0x14d70053}},	//   ोगी_, žeća_, дият, _וואל_
  { {0xcd370015,0xc694004c,0xf09f0144,0x6722003d}},	//   يرزب, לאָ_, sià_, iroj
  { {0x66cd002c,0x2d850107,0xb05b0b24,0x2ca90123}},	//   núka, ále_, lläm, tnad_
  { {0xbca5003b,0xe571000a,0x67220b25,0x9f610045}},	//   أمري, עַם_, kroj, ăpân_
  { {0xcb340063,0x50d40015,0x20d40015,0x7de701f3}},	// [e50] метъ, _تزور, _تتوج, _мінд
  { {0x64970045,0x249f0b26,0x20d20030,0xa9c70b27}},	//   rţii, zium_, táig_, осек
  { {0xb05b008c,0xdcef003d,0x645c003d,0x2ca90123}},	//   yläl, ēdēt, ērij, pnad_
  { {0x63ad002e,0x64970045,0x20d20030,0xc4c60058}},	//   _þang, pţii, ráig_, _سْ_
  { {0xae1f005d,0x1798004a,0x20d20030,0x27e90b28}},	//   _बयान_, овцы_, sáig_, žano_
  { {0x7bda0008,0x5b7a0008,0x7c2d0b29,0x4b7a000a}},	//   _לקרו, _הרשא, lgar, _האשו
  { {0x2002005c,0xe918005e,0x6722008c,0x16a60248}},	//   ybki_, _морі_, aroj, явши_
  { {0xddc7002c,0x7c2d0b2a,0x1309005e,0xf9880015}},	//   rejň, ngar, бний_, _بنفي_
  { {0xec790092,0xe5e5002b,0x86c50015,0xf559002b}},	//   _độc_, _فزای, _فيرن, _گلاب_
  { {0xc8790064,0x7c2d0026,0x248d0b2b,0x249f0b2c}},	//   _hoş_, hgar, shem_, sium_
  { {0x6b89002a,0xb05b008c,0xa01b0b2d,0x63ad0b2e}},	//   _żegl, lmäy, rkön, _žand
  { {0x628a0014,0x2eb6005d,0x2eb4000b,0x9234004c}},	//   _elfo, ृत्त, ंक्त, _אַקט_
  { {0x44f10b2f,0x1eaa0015,0x442d0061,0x6d5e0085}},	//   _há_, ماسي_, mge_, _srpa
  { {0x12fa0008,0x442d0b30,0xa01b0030,0x44f10b31}},	//   _ההסב, lge_, lköl, _ká_
  { {0x44f10b32,0x52740067,0x442d0b33,0x42520058}},	//   _já_, _تانز, oge_, _سنير
  { {0x768f003c,0x201e0007,0x7c2d0b34,0x64490b35}},	//   _høyd, ėtis_, ggar, neei
  { {0x20d2002d,0xbae60029,0x44f10b36,0x442d0b37}},	// [e60] ráid_, سكاي, _lá_, ige_
  { {0x20d2002d,0x78ab0091,0x7c2d0b38,0x6d5e013f}},	//   sáid_, engv, agar, _trpa
  { {0xc8790064,0xc4cb005d,0xb90a0010,0x44f10b39}},	//   _boş_, ाताओ, ёндз_, _ná_
  { {0xc8790011,0xa01b0400,0x67220b3a,0x26c7035f}},	//   _coş_, lhör, troj, elno_
  { {0x27e0022d,0xf0930053,0x6d5c00dd,0x38cb0086}},	//   äin_, ענד_, lvra, حالی_
  { {0xab5b0030,0xa96a0719,0x44f10b3b,0x67220b3c}},	//   _ezüs, _лига_, _bá_, rroj
  { {0x44f10b3d,0x6d5c016b,0xa4f8002b,0x9c83036d}},	//   _cá_, nvra, زکار_, ščev
  { {0x44f10b3e,0x26c702c6,0x442d0b3f,0x64490012}},	//   _dá_, alno_, gge_, geei
  { {0x684302db,0x78a20b40,0x0000006a,0x0000006a}},	//   _янта, miov,   ,
  { {0x44f10b41,0x4b7b0053,0x442d0b42,0x46a30185}},	//   _fá_, צטיג, age_, _заув
  { {0x44f1002f,0x3a37000a,0x7c2d0b43,0x04460b44}},	//   _gá_, הרים_, ygar, _нежн
  { {0x66cd002c,0xa01b08e9,0x84960015,0x232a0b45}},	//   núkn, ehör, _عجائ, _годи_
  { {0x4abe014e,0xaabe005d,0xa01b0012,0xb05b04f8}},	//   ्ताव, ्ताक, fhör, lläk
  { {0x2ee500b8,0x68fc0b46,0xddc50046,0x1df8055f}},	//   ölf_, _otrd, _zahř, зеры_
  { {0xdb1d0089,0xd23b0008,0x44f10092,0x291c0b47}},	//   _vysí, _הגול, _xá_, ával_
  { {0x5d540010,0x718b000a,0xd1380b48,0x7c2d0b49}},	//   экст, _לְחַ, mtą_, ugar
  { {0x64970011,0x768f003c,0xdd31002a,0x1f150033}},	// [e70] cţiu, _høye, lęże, _ўмоў
  { {0x6ce70036,0x1eea002b,0xd1380091,0x7bc60091}},	//   _німе, _گویی_, otą_, _dyku
  { {0xd13800df,0x7bc6002e,0xa01b008c,0x442d0b4a}},	//   ntą_, _eyku, hköm, yge_
  { {0xd13800df,0x99d40015,0xe9d00015,0xc8640054}},	//   itą_, رتلا, اغك_, етљи
  { {0x2d8300df,0xb8f4005d,0x44f10b4b,0xf7730021}},	//   lyje_, _सी_, _sá_, عاص_
  { {0xd1380007,0xf62b005e,0x80c9000b,0xb05b008c}},	//   ktą_, сіди_, रतुं, rmäy
  { {0x442d0b4c,0x2d830007,0xa01b0030,0xe610006e}},	//   tge_, nyje_, tköl, اشه_
  { {0x44f10b4d,0x78a20227,0x05760015,0x336502a7}},	//   _vá_, ciov, ظمية_, двиг
  { {0x644900da,0xd138002a,0xa01b0b4e,0xafdb04d1}},	//   reei, etą_, rköl, nfød
  { {0x44f1017e,0x46150086,0xe2990036,0x6d450b4f}},	//   _tá_, _آوار, іан_, _opha
  { {0x672b002e,0x442d00c0,0xe507002b,0xd1380091}},	//   lugj, pge_, _رباي, gtą_
  { {0xa06a0001,0x7afd0020,0x55ba000a,0xd5140015}},	//   цама_, _otst, _ומעו, _أبلغ
  { {0xd1380b48,0x883a000a,0x6d450b50,0x6fde0065}},	//   atą_, חתרו, _apha, _नृशं
  { {0xdd920086,0xdea2002b,0x64970045,0xdbc7001a}},	//   پور_, ئیدی, rţiu, _röði
  { {0x6d4e0111,0x2d830007,0x7afd02fd,0x32050b51}},	//   uwba, gyje_, _atst, mbly_
  { {0x6d5c00c0,0x69da001c,0x64970011,0x6c55005e}},	//   rvra, _útei, pţiu, нтує
  { {0xa01b00c0,0xab5b00dc,0x76410034,0x7ae70079}},	// [e80] phör, _szür, _obly, _bijt
  { {0xf1d1000b,0xdddc00bc,0x6d5c0547,0x7aef0b52}},	//   _हरान, akrš, pvra, _duct
  { {0xceb300b2,0x994a0115,0x7bc6002a,0x6abe0012}},	//   _ביז_, تلال_, _wyku, ropf
  { {0x5ca60342,0x6abe0012,0xcb6a096d,0x0000006a}},	//   _цимб, sopf, _даме_,
  { {0x9b03006b,0xd138002a,0x0665002b,0x7bc60061}},	//   _изяд, ztą_, کانپ, _uyku
  { {0xd1380870,0x2f97000a,0xa926012e,0x3e74006f}},	//   ytą_, וכנן_, _одгл, _päty_
  { {0x68fc00bc,0x764a0034,0x98a602c4,0x2a57000a}},	//   _utrd, refy, _живе, _קבלן_
  { {0x764a0026,0x399b000a,0x93780a32,0x7ae70546}},	//   sefy, _וילד, збит_, _zijt
  { {0xa2260086,0xb05b0123,0xf3f5002b,0xdd31002a}},	//   ورده, släk, رتيک, węże
  { {0x60c40007,0x3254017f,0xa01b0012,0xdd31002a}},	//   _akim, хвор, rköm, tęże
  { {0x60f80127,0xd1380091,0xd1300015,0xa3ba000b}},	//   яння_, utą_, دمج_, _आँक_
  { {0xd1380b53,0x60d60026,0x2d830007,0x320500da}},	//   rtą_, _chym, vyje_, ably_
  { {0xd1380b54,0x64970045,0x6d450b55,0x93930058}},	//   stą_, rţit, _spha, _لجوا
  { {0x2d830007,0x9325002b,0x61560015,0xd1380091}},	//   tyje_, _سرهن, _ينشئ, ptą_
  { {0x72330021,0xdd950033,0x7ae70079,0x64970045}},	//   _شروط, хавы, _rijt, mţir
  { {0xbf350036,0x2d830007,0xa01b0012,0x64970045}},	//   _знищ, ryje_, chöp, lţir
  { {0xa01b008c,0x7ebf0046,0x3ea30079,0xac18005e}},	// [e90] hkök, tápě, pijt_, ьоту_
  { {0x2d8300df,0xd337000a,0x0ab8002b,0x64970045}},	//   pyje_, ורמה_, وطلب_, nţir
  { {0xb05b008c,0xf770009a,0x0000006a,0x0000006a}},	//   eläi, یاه_,   ,
  { {0xc87901e2,0x3cfe00dc,0x386902c1,0x69c701b2}},	//   _kişi_, ítve_, ñar_, _vyje
  { {0xfc3f0014,0x69c7005c,0xf74b0029,0x7afd0b56}},	//   _amíg_, _wyje, تجاه_, _utst
  { {0xaa4500f2,0x055501b7,0xe9190033,0x62880079}},	//   ävää_, етия, _ногі_, jkdo
  { {0xafdb00cb,0xaabe0065,0x0000006a,0x0000006a}},	//   rdøy, ्तरक,   ,
  { {0xa3ba000b,0x1309005e,0x7d1a001a,0xf992000a}},	//   _आँख_, пний_, átsi, _ערן_
  { {0x27ed0b57,0x60d60b58,0xe7300015,0xa2e50b59}},	//   _igen_, _rhym, _نصل_, ноид
  { {0xe3b60010,0x41050296,0x60c40b5a,0xc56b0058}},	//   эбы_, нзов, _skim, _وحال_
  { {0x68e90050,0x32050b5b,0xd8d9000a,0x21690b5c}},	//   _kied, rbly_, ּקָר, чини_
  { {0x037b0086,0x62880b5d,0x397a004f,0x43950138}},	//   _وحشت_, akdo, לטתנ, _паес
  { {0xb3870029,0x64970045,0x68e90b5e,0x130401f3}},	//   _تجاه, bţir, _mied, _азім
  { {0x523900b2,0x02440015,0xc8790061,0x443f0b5f}},	//   _זײַנ, _لَهَ, _dişi_, lfu_
  { {0x7bcb00b8,0x27ed0111,0xd1bb0015,0x64590b60}},	//   ügun, _ogen_, _باشا_, _kawi
  { {0x63a40007,0x68e90b61,0x60c4003f,0x645b0b62}},	//   _žini, _nied, _ukim, ndui
  { {0x6d4101e2,0x64590b63,0x0b460033,0x645b008c}},	// [ea0] çlar, _mawi, энан, idui
  { {0x6b96002a,0x27ed0b64,0x64590b65,0xaf49009a}},	//   rzyg, _agen_, _lawi, _آشيل_
  { {0x68e90b66,0x905a000a,0x9c8307c4,0x35c4000b}},	//   _bied, ּכְת, ščav, _लुढ़
  { {0x64590050,0x7e7e0b67,0x645b080b,0xacfb004f}},	//   _nawi, _hopp, jdui, _מהטכ
  { {0x17540080,0xc017000a,0x7e7e0b68,0x68e90b69}},	//   твля, תקנו_, _kopp, _died
  { {0xcfb7004c,0x66e3005e,0x27ed0a3a,0xb865009a}},	//   עלסי_, гоча, _egen_, _یاقو
  { {0x443f0026,0x6c9a000a,0x6abe000b,0x75d3002b}},	//   ffu_, ּשִׂ, ्तीर, هيها
  { {0x7e7e022d,0xd4970080,0x44f3002b,0x20120061}},	//   _lopp, ерь_, دسوز, _neyi_
  { {0x82a60256,0x68e30161,0x7e7e008c,0x64590b6a}},	//   ешне, ïnde, _oopp, _dawi
  { {0x87170008,0x68e90024,0xdbc70020,0xcb370008}},	//   _נקבע_, _zied, _tööi, עניק_
  { {0xc5690029,0x64970045,0x61ee0091,0xb373002b}},	//   _يحمل_, rţir, žblo, ندیش
  { {0x645900b6,0xa98b000a,0x0000006a,0x0000006a}},	//   _gawi, לָכִ,   ,
  { {0x547b000a,0xdfd8006b,0x389b000a,0x6d580085}},	//   _מטאו, еър_, ליטנ, _švap
  { {0xa6e700a7,0x64590050,0x7e7e052a,0xd5a600e6}},	//   _nhữ, _zawi, _copp, لف_
  { {0x765a00df,0x20d2002d,0xa01b00f2,0xe611000a}},	//   _maty, máin_, hköi, יִן_
  { {0x6ca40256,0x765a0b6b,0x27e90b6c,0xd6d9002a}},	//   груж, _laty, žani_, _ppłk_
  { {0x5a3505b3,0x6008000a,0xfaf3012c,0x7a4b004a}},	// [eb0] кнат, _אִתְ, اثر_, зяев_
  { {0x765a005c,0x20d2002d,0x645b0011,0x68e90b6d}},	//   _naty, náin_, zdui, _sied
  { {0xfe9c0008,0x768f003c,0x58390010,0x68e90b6e}},	//   _מיזמ, _nøya, дзея_, _pied
  { {0x20d2002f,0x9d1a000a,0x26c500bf,0xe7310015}},	//   háin_, _קורט, _sklo_, لصت_
  { {0xed590024,0x20d9002d,0x68e90b6f,0x1834002b}},	//   āžu_, méid_, _vied, ارمح
  { {0x945d0050,0x68e90b70,0x64590b71,0xf6510015}},	//   końc, _wied, _sawi, شئت_
  { {0x68e90945,0xe1f10086,0xc6680010,0x25f2000b}},	//   _tied, یسد_, эшце_, ुड़ी_
  { {0x929d005c,0xb8f5000b,0xd5ae0015,0x27ed02de}},	//   dpła, हत_, تفى_, _ugen_
  { {0x660c00dc,0x645b0b72,0xec68000a,0xb05b0012}},	//   élkü, rdui, ת֑וֹ_, nläu
  { {0x2362002e,0x387f0556,0x20d9002d,0xf7480015}},	//   ækja_, _hour_, héid_, _سلمي_
  { {0xb05b0012,0x273b0034,0xfa6f02a3,0x645902f2}},	//   hläu, lên_, рмiн_, _tawi
  { {0x387f038d,0x7e0a000b,0x25fd000b,0x7e7e0b73}},	//   _jour_, वर्ग_, रुरी_, _sopp
  { {0xa4d40191,0x08760053,0x929d002a,0x0478002b}},	//   _соці, דערט_, apła, _سلوک_
  { {0x273b0023,0x9f9e001c,0xe0df02b9,0xa3b80058}},	//   iên_, _ação_, amò_, _ثامر_
  { {0x71640029,0xd0aa0015,0x2d8c006f,0xdca60099}},	//   _مايك, _يطعن_, áde_, вави
  { {0xeaed005d,0xa0c60021,0xed570004,0x0000006a}},	//   जदूत_, _جيبو, њот_,
  { {0xf41200b2,0x2d980030,0xb05b0012,0x7e7e0b74}},	// [ec0] יפן_, szre_, gläu, _topp
  { {0xbab30015,0x64950125,0xdab90033,0x7e7e00cb}},	//   لمقب, _fáig, ныхі_, _uopp
  { {0xceb90046,0x765a002a,0x6495013f,0x0000006a}},	//   éře_, _raty, _káid,
  { {0x387f0152,0x2db7000a,0x4bd60033,0xb17a004c}},	//   _cour_, _ילין_, _аўгу, וטער
  { {0x69d50014,0x929d005c,0x765a0007,0x97c30b75}},	//   _ezze, zpła, _paty, айце
  { {0xba1a0086,0x6f020064,0xa6340036,0x6495002d}},	//   _زيرا_, _çocu, ункі, _láid
  { {0x387f003e,0x64b30011,0x69c300dc,0xfaa30b76}},	//   _four_, răin, ünet, _таро
  { {0x765a002a,0xa01b0030,0xc7b90030,0xa29f000b}},	//   _waty, lköv, _időn_, गोस्
  { {0xd2500029,0x20d2002d,0x4307004a,0x6ac7001a}},	//   منة_, táin_, кхэм_, _örfá
  { {0xa01b00c0,0xe3af0029,0x7bdb000a,0x51860033}},	//   nköv, ترى_, וקפו, вума
  { {0x63ad002e,0x387f0b77,0xd25704f7,0xa697000a}},	//   _þann, _your_, тцы_, _שכבה_
  { {0x63a400df,0x20d2002f,0x2ebd005d,0x945d002a}},	//   _žinu, sáin_, ोत्त, rońc
  { {0xa0a40010,0x20d20b78,0xb376002b,0x9098006b}},	//   раўд, máil_, _جداش, твят_
  { {0x6fe90024,0x2fcd005c,0x945d002a,0x661800bc}},	//   _rīcī, żego_, pońc, navk
  { {0x929d002a,0xfcc70054,0xac9505ab,0x9c8304b2}},	//   jsły, вљам, гавш, áčov
  { {0x273b00a7,0x3cfe00dc,0x7059000d,0x20d2002d}},	//   yên_, ítva_, _чаир_, náil_
  { {0x20190b79,0x8bd50033,0x308400c3,0x1af40681}},	// [ed0] masi_, ужац, _خليف, иптя
  { {0x20d2002f,0x7e550191,0x69070010,0x3ea700dc}},	//   háil_, _своє, вядз, _önt_
  { {0x387f0b7a,0x20d9002f,0x661804af,0x69c80293}},	//   _pour_, péid_, davk, _ødel
  { {0xdb1d00f2,0x05b6005d,0x5c04006b,0x47d50015}},	//   _pysä, _अख़ब, _вяра, هيار
  { {0xfeb80086,0x7ac70010,0xb05b00f2,0x9cd60b7b}},	//   _سایت_, _асве, lläs, _תורה_
  { {0x2ca90b7c,0x273b0023,0x44f80b7d,0x78a20b7e}},	//   liad_, rên_, _bé_, ďova
  { {0x44f8002f,0x88830086,0x5e560053,0xa3f50010}},	//   _cé_, _پیشن, טיװע_, ляпш
  { {0x2366010b,0x2ca90176,0x20d2002f,0x20190b7f}},	//   _broj_, niad_, gáil_, jasi_
  { {0x20190523,0x69da0b80,0xb05b0012,0xf4840054}},	//   dasi_, _úter, hläs, рујн
  { {0x2ca90026,0x85a70054,0x20190045,0x44f80b81}},	//   hiad_, _ијед, easi_, _fé_
  { {0x20190b82,0xe4d6002b,0xb05b008c,0xe4350021}},	//   fasi_, ضویت_, ylät, _مفاد
  { {0x20d2002f,0x20190b83,0xa988000a,0x94050015}},	//   cáil_, gasi_, דָשִ, _صوته
  { {0x2ca90176,0x3245030e,0x248d0046,0xa856000a}},	//   diad_, _белг, mkem_, נישה_
  { {0xed5a0124,0x248d0089,0xc7d60008,0xf207007a}},	//   ног_, lkem_, טורי_, _рядо
  { {0x2ca90176,0x6495002d,0xddc50061,0x44f80016}},	//   fiad_, _táid, _vahş, _xé_
  { {0x2ca90b84,0x6abe005d,0x1bea09dd,0x248d0b85}},	//   giad_, ्त्र, едби_, nkem_
  { {0xb2f60053,0xab66054f,0xb05b0123,0xceb60021}},	// [ee0] ָצעס_, ывал, rlät, _محدث
  { {0x248d0005,0xb8650086,0xdde400dc,0x3958003d}},	//   hkem_, یانو, űrűs, _psrs_
  { {0x2ca90026,0xb05b00d5,0x1ea9002b,0x248d0030}},	//   biad_, plät, _جايي_, kkem_
  { {0x98c50010,0x76430026,0x2ca90026,0x44f80b86}},	//   асіл, efny, ciad_, _ré_
  { {0x44f80b87,0x248d0089,0xdc9b0053,0x66180b88}},	//   _sé_, dkem_, _טיטל, tavk
  { {0xbb430001,0x4ab8000b,0xfaa60054,0x39580091}},	//   _ћерк, _आदिव, _саго, _tsrs_
  { {0x20d2002f,0x20190064,0xb82a005e,0x2b400b89}},	//   táil_, yasi_, _повз_, ltic_
  { {0x2b400a1c,0x7c360034,0x15f0000b,0x44f80b8a}},	//   otic_, ngyr, _चलकर_, _vé_
  { {0xb05b018b,0x20d2002d,0x36360225,0x2b400b8b}},	//   klär, ráil_, _مراس, ntic_
  { {0x20d2002d,0x44f80b8c,0x171b000a,0x86ea0015}},	//   sáil_, _té_, _נובע, _أعرف_
  { {0x32630010,0x20d2002d,0xd01100e6,0x1a9b004c}},	//   стыв, páil_, يلد_, גייע
  { {0x68e20b8d,0x6f1d0b8e,0x4035004a,0x248d0b85}},	//   nmod, tssc, шемс, ckem_
  { {0x6f1d00b8,0x20190b8f,0xb4c0000b,0x03a309c3}},	//   ussc, rasi_, ंकी_, _лицо
  { {0x256301e2,0x3eaa00b8,0x2ca90b90,0x20190b91}},	//   _yıl_, gibt_, wiad_, sasi_
  { {0x2ca90176,0x6f040b92,0x01fb00a3,0x69ce0b93}},	//   tiad_, _etic, _אפול, _nybe
  { {0xb05b00b8,0xd138005c,0xa01b0030,0x94040065}},	//   rläs, rząd_, gköt, रडिच_
  { {0x2ca90176,0xfbd00029,0xda150054,0xbae50015}},	// [ef0] riad_, كتك_, идањ, لكري
  { {0x2ca90026,0x8f9c0053,0x69ce0b94,0x248d0046}},	//   siad_, _ריזי, _bybe, zkem_
  { {0xb9b50029,0x4fb4002b,0x6e95002b,0x2b400b95}},	//   جماع, _نصیر, _ملکا, atic_
  { {0x5d7a004c,0x69ce0013,0xdd7a000a,0x7648002a}},	//   _סארק, _dybe, _סטרל, _abdy
  { {0xdc3600b2,0x6568003f,0x8c1a000a,0x248d0046}},	//   _דארט_, _ardh, _בורי, vkem_
  { {0x83fd00dc,0xab660024,0x68e203df,0xe5710015}},	//   zdőd, _daļē, amod, قطب_
  { {0x291c0089,0xd61800e6,0x248d0b96,0x98070033}},	//   ávat_, اتها_, tkem_, _бязд
  { {0x06b10046,0x03250b97,0xc4850888,0xc3250b98}},	//   _řídí_, адин, рлик, амик
  { {0x67d40036,0xd299005e,0x58040015,0x42550015}},	//   _готу, втні_, _طولك, لنظر
  { {0x78ab0b99,0x248d0b9a,0xb3c60b9b,0xc2420248}},	//   ligv, skem_, рльз_, оньк
  { {0xe0da0b9c,0x3941003e,0xca36000a,0x6f040b9d}},	//   кво_, nths_, בנתה_, _stic
  { {0x6f04044c,0xd3710015,0x78ab0079,0x2d8a0091}},	//   _ptic, _وها_, nigv, vybe_
  { {0xa8560008,0x7d05002d,0x5ea60029,0x6fd6005e}},	//   בירה_, _aths, لمحل, рінц
  { {0x539a009d,0x1167002b,0x4175006e,0x91e50189}},	//   _בינו, _ملتی_, _نابس, _коле
  { {0xcce60015,0xa283002b,0x26c702b9,0x68e20034}},	//   لسري, _نیکو, iono_, ymod
  { {0x91ba000a,0x62830b9e,0x26c70034,0x768f00cb}},	//   _במצי, _hono, hono_, _søyl
  { {0x6f04016f,0x26c7003f,0x7ed605d1,0x0c370015}},	// [f00] _utic, kono_, _вінч, شكلة_
  { {0xf9920115,0xb05b00f2,0x26c70b9f,0x62830ba0}},	//   يبا_, lläp, jono_, _jono
  { {0x20d9001c,0x26c70ba1,0x2b400ba2,0x6d400045}},	//   léia_, dono_, stic_, ămas
  { {0x69ce04af,0x2a61002d,0xfc320015,0x2b400ba3}},	//   _vybe, adhb_, _بحد_, ptic_
  { {0x47330036,0x91fc003d,0xe7370190,0x39410ba4}},	//   жніс, ndāc, иец_, aths_
  { {0x628302d7,0x454a005e,0xfaa60054,0xa01b0012}},	//   _nono, вчим_, _ђаво, nkör
  { {0x94aa0015,0xa01b0400,0xd5af0040,0xa3e30065}},	//   َابِ_, ljöe, وفه_, फेस_
  { {0xd5b10092,0xd70603ad,0xc977000a,0xb4c0000b}},	//   _séc_, _взаи, _דגלי_, ंके_
  { {0xa2c2014e,0xf7490074,0x389b000f,0xdc8b000a}},	//   रकल्, _مجله_, _סימנ, דְיָ
  { {0x62830ba5,0x20d9016e,0x92b30015,0x26c70ba6}},	//   _cono, déia_, ْحَا, cono_
  { {0x09f7013a,0x99f70008,0xd138005c,0xfad7000a}},	//   ימים_, יזיה_, dząc_, שויך_
  { {0x75d30074,0xdcee0007,0xe53b000a,0xb97b000a}},	//   _بيما, mybė, _יתבר, דנטי
  { {0xd36f0015,0xdcee0091,0x33930015,0x24b7000a}},	//   _يهم_, lybė, _ولمز, _דהאן_
  { {0x7dc70029,0x8027002b,0x62830ba7,0xddb70015}},	//   لتأك, درگم, _gono, لحزب
  { {0x6ca70210,0x44260820,0x127b004c,0xdcee0091}},	//   араж, _kdo_, _באגע, nybė
  { {0x1bf50010,0x26c70ba8,0x30150004,0x62830ba9}},	//   спаў, zono_, _удир, _zono
  { {0x26c700e8,0x7de000dc,0xaa070015,0x9be7005e}},	// [f10] yono_, tásé, لظاه, рівк
  { {0xdcee0007,0xd138005c,0x9967072d,0x539b000a}},	//   kybė, cząc_, ител, דימו
  { {0xd36604b6,0x161a005d,0x26c704ed,0x29c80029}},	//   _که_, _नज़र_, vono_, لِكَ_
  { {0x39410baa,0xa177000a,0xb4c0000b,0x26c701d7}},	//   rths_, יעבד_, ंको_, wono_
  { {0xcc760008,0xf74900c3,0x7c480030,0xc7b90030}},	//   _הערה_, التي_, éprő, _idők_
  { {0x1af60b7b,0x2bb4000b,0x394100da,0x24510016}},	//   _למשל_, ंपरा, pths_, _ạm_
  { {0x4518008f,0x26c702d7,0xb9950029,0x99850029}},	//   ацыя_, rono_, _الأب, _الزو
  { {0x629a022d,0xe5700086,0xa8a406b4,0x2db80008}},	//   ehto, بطه_, _друк, ילון_
  { {0x26c70bab,0x0219005e,0x1306004a,0xf7940033}},	//   pono_, лінь_, бный_, _датэ
  { {0xafdb01f0,0x02450015,0x7bc8000a,0x629a0bac}},	//   rføl, حَدَ, יֶתֶ, ghto
  { {0xb5a707de,0x1c17000b,0xa2020033,0x3a36000a}},	//   _трай, तराल_, япэд, זרתם_
  { {0x656e002f,0x160b014e,0xafdb0bad,0x628300e8}},	//   _ábha, _स्तर_, pføl, _wono
  { {0xafdb00fb,0xdee60036,0xa856000a,0xa01b0bae}},	//   lføj, йоми, זירה_, tkör
  { {0x20d9001c,0xde030758,0x78bb03e6,0xb05b0b1f}},	//   réia_, зпри, _ljuv, släp
  { {0x69a7005d,0xd138005c,0x753c00b8,0x7c960baf}},	//   _टेली, rząc_, _ärzt, брац
  { {0x20d9001c,0xd138005c,0xa01b0bb0,0xa5c3002a}},	//   péia_, sząc_, skör, ciół
  { {0xc9f6003b,0xa01b0030,0x6097009a,0x0000006a}},	// [f20] مساع, pkör, _دنيس_,
  { {0x7810005d,0xe810005d,0x4b23005e,0x9b930015}},	//   ार्क_, ार्थ_, ямув, ألكت
  { {0x6b8d02f2,0xe9da0054,0x186a0bb1,0x0000006a}},	//   ayag, ћке_, лажи_,
  { {0x38cb0086,0xdcee0007,0xe81a0002,0x87260015}},	//   هانی_, vybė, ازات_, معتم
  { {0xb8650040,0x07ba0058,0x0000006a,0x0000006a}},	//   تالو, دهشة_,   ,
  { {0xa01b022d,0xdcee0007,0x17530033,0xd6270054}},	//   hköp, tybė, явія, боље_
  { {0xd639005e,0xa01b02dc,0xdcfc0073,0x0000006a}},	//   рячі_, kköp, tyrę,
  { {0x9d1b000a,0xa4d80004,0x6f16002a,0xad1b000a}},	//   אוקט, јдиу_, _owyc, אוקר
  { {0xc3270029,0x649c002d,0xb8de005d,0xd6d20002}},	//   مكين_, _léig, ीक_, _فقر_
  { {0x3218002c,0xddc5002c,0x2002002a,0x60cd0bb2}},	//   úry_, _zahŕ, ecki_, _skam
  { {0xa0550036,0x7a7b015b,0x4a7b000a,0x6722003d}},	//   овні, אריס, אריב, lsoj
  { {0x557700b2,0x661a0356,0xf1a30174,0xd0110015}},	//   _לעבן_, _hetk, ярын, بلح_
  { {0x7e2b0010,0xbfab018f,0x9f60001a,0xbf9b00aa}},	//   ліва_, утне_, ýrðu_, ebêr
  { {0xd3570008,0x768f00cb,0x2002002a,0x0dcb09dd}},	//   _לידי_, _røyk, acki_, губи_
  { {0x321e0bb3,0xc2ed0046,0xdd940033,0x661a0bb4}},	//   maty_, řící, пары, _metk
  { {0x7b15006b,0x6fb50015,0xf1bf0046,0x67220bb5}},	//   ждах, _ومثا, ášek_, ksoj
  { {0x6f160026,0xfbd300e5,0x6d5e0bb6,0xd5b10016}},	// [f30] _gwyc, ستر_, _espa, _nén_
  { {0x661a0bb7,0x321e002a,0x7d5500fd,0x24860158}},	//   _netk, naty_, _двох, _loom_
  { {0x6f16005c,0x7e99002b,0x3a840033,0xf96b0033}},	//   _zwyc, _منکر_, чытв, ырай_
  { {0xd7d50001,0x2907003d,0xe3c70091,0x7c87011e}},	//   ожењ, īna_, ūčių_, _ѓуне
  { {0x69dc00dc,0x69cb00b8,0xf1cf000b,0x321e002a}},	//   _ezre, ßgeb, _सुनन, katy_
  { {0xda7b0010,0xe611002b,0x321e0046,0x64950125}},	//   _сям_, ذشت_, jaty_, _cáin
  { {0x7d02002c,0xc909000a,0x2002002a,0x46180033}},	//   _čosk, _כִּ֛, ycki_, сціў_
  { {0xcd980008,0x76b2002a,0x6d410061,0x1305007e}},	//   מדות_, głyb, çlay, озим
  { {0xdc8c000a,0x24860bb8,0x0000006a,0x0000006a}},	//   רְוָ, _doom_,   ,
  { {0x52a90bb9,0x321e0bba,0x31250bbb,0x443d0bbc}},	//   рвом_, gaty_, одог, _wcw_
  { {0x6f16005c,0xdb06001a,0x85040058,0xd5bb011e}},	//   _swyc, _ómög, _فولن, _сса_
  { {0x649c002d,0x493a0135,0x43750015,0x661a0bbd}},	//   _réig, סגרו, _وهار, _zetk
  { {0x661a01e2,0xd5b10092,0x2bd5000b,0x8f99006b}},	//   _yetk, _kéo_, _दरगा, бърт_
  { {0x21690bbe,0xdc12000b,0xddde0045,0xfc3f0144}},	//   _вики_, ़र्ड_, _nopţ, _ací_
  { {0x649c017e,0xed5a0268,0x98c9000b,0x8cb8000b}},	//   _féid, шов_, िकाए, ्कलो
  { {0x1c460010,0x6f16002a,0x64490bbf,0x6c36009a}},	//   ўнам, _twyc, nfei, تفرا
  { {0x6d5e005c,0xf200000b,0x8b26004a,0x4df60033}},	// [f40] _wspa, लुक़_, юдае, _мянт
  { {0x649c002f,0x1ae30bc0,0x0000006a,0x0000006a}},	//   _téig, доум,   ,
  { {0x4c160015,0xa967006b,0x62810045,0x661a0bc1}},	//   _وبحس, жиха_, ijlo, _retk
  { {0x50ca014e,0x661a037f,0x6722008c,0xd8f7005e}},	//   रविष, _setk, tsoj, інії_
  { {0x2486003e,0x67220007,0x4e1e000b,0x6756002b}},	//   _room_, usoj, _बजाई_, تخار
  { {0x6b8b0bc2,0x9614000b,0x99910030,0x76b2002a}},	//   ägge, डरेट_, _edző_, dłyc
  { {0x69dc0024,0x80ca000b,0x64490bc3,0xa5070004}},	//   _uzre, रवाइ, ffei, оеја_
  { {0xe9d70036,0x672d0024,0xb1980092,0xe4ea0015}},	//   _єкт_, šaja, _ngưỡ, جعته_
  { {0xc4450086,0x649c002d,0x76b2005c,0x160b000b}},	//   سیون_, _réid, głyc, _स्वर_
  { {0xfbd3000a,0x85760015,0x68fc0bc4,0xc5760058}},	//   ותח_, _ودائ, _kurd, _وطاع
  { {0xe45a0191,0xdd1c002c,0x321e0bc5,0x76b2002a}},	//   _вже_, yšše, raty_, ałyc
  { {0x23480086,0x68fc0100,0x765800f2,0x6d5c0b90}},	//   _هستی_, _murd, levy, dwra
  { {0x61010048,0x38660bc6,0xff04006b,0xdfdb006b}},	//   _vēla, idor_, дясн, рън_
  { {0xdee70015,0x68fc01f6,0x6298005b,0x6d5c0416}},	//   تأجي, _ourd, _ulvo, fwra
  { {0xbd6809c3,0x6d5c0034,0x764a0034,0x68fc0bc7}},	//   орте_, gwra, iffy, _nurd
  { {0x90c400d7,0x90e7002b,0x859b000a,0xdcb10015}},	//   _обје, _بستن, בשלו, رىء_
  { {0x1eab0029,0xe0d00086,0x38660bc8,0xdee70015}},	// [f50] _نادي_, _جزو_, ddor_, _وأخي
  { {0x8a370015,0x768f00cb,0x68fc0223,0x321c0046}},	//   تعرض, _høyv, _burd, _jevy_
  { {0xad270074,0x64490176,0xe9f80036,0xa9070086}},	//   _برخو, yfei, інці_, زبان
  { {0x68fc01e2,0xe8f802e5,0x6495002d,0x18a4005e}},	//   _durd, ілі_, _cáil, маєм
  { {0x0c240010,0xcb440797,0x2d9100da,0x87040015}},	//   _імён, _охри, lyze_, وبول
  { {0x8afa0008,0x6d47007c,0x20d20030,0x24670016}},	//   _להשי, otja, láit_, _ốm_
  { {0xceb400b2,0x85570086,0x6495002d,0x6d470446}},	//   ויס_, تیار_, _fáil, ntja
  { {0x6d470251,0x7afd0bc9,0xe4c80015,0x1d0c000a}},	//   itja, _kust, يبين_, סּוּ
  { {0xe3b1003b,0x1306004a,0x42d50033,0x91fc003d}},	//   عرب_, пный_, зіну, rdān
  { {0xe2990124,0xbb76000a,0x76b2002a,0x68fc0061}},	//   сао_, פעתו_, rłyc, _yurd
  { {0x76b2005c,0x20d200dc,0xda48000a,0x41750015}},	//   słyc, káit_, חֲרָ, سادس
  { {0xf992000a,0xf8db000b,0xcea9000a,0x7afd0bca}},	//   גרט_, बतिय, _גי_, _oust
  { {0x7afd00df,0xb4c9000b,0xbf9b016e,0x93fa000a}},	//   _nust, ोती_, scên, _הלני
  { {0xc2c80015,0xf1c6000b,0x649c0125,0x998c006f}},	//   _وبول_, _रुकन, _géib, _čože_
  { {0x7c9602e5,0xe7eb005d,0x6495002d,0xfce60361}},	//   прац, जेता_, _láim, зово
  { {0x249f03af,0x14d5004c,0x7af5003d,0x6d5c0034}},	//   nhum_, פוּל_, _aizt, rwra
  { {0x7af50014,0x7afd0bcb,0x90e50015,0xdca3005e}},	// [f60] _bizt, _cust, _تسون, хати
  { {0x64950125,0x7afd0bcc,0x68fc0bcd,0x3ea600af}},	//   _sáil, _dust, _purd, _хиог
  { {0x8dfb000a,0xb906005e,0x2bac000b,0x5dfb000a}},	//   _להית, їздк, _घेरा, _לפינ
  { {0x68fc0293,0x48a9005e,0xf7460004,0x7afd0bce}},	//   _vurd, отім_, зедо, _fust
  { {0x68fc0bcf,0x7afd0bd0,0x78a300aa,0x38660bd1}},	//   _wurd, _gust, ënva, rdor_
  { {0x35d40080,0xba550063,0xd6270054,0x68fc0bd2}},	//   молё, _отсъ, поље_, _turd
  { {0xd5b00029,0x6495002d,0x7afd059b,0xddc7005c}},	//   ضفة_, _táil, _zust, dejś
  { {0x7de70014,0x957c005c,0xf74600a5,0x2ca002f2}},	//   lésé, _rząd, _небо, nhid_
  { {0xa7860015,0xe77a004f,0x987b004f,0x07a3011e}},	//   _عشرو, _לָ֑ך, _פרמק, _затн
  { {0xcb130008,0x7de700dc,0x079b000a,0x6d47001a}},	//   עלת_, nésé, _הסמל, ytja
  { {0x59be000b,0xdc3f006f,0x3035004a,0x01d80015}},	//   ्थिर, víľk, менё, تودع_
  { {0x64a30010,0x7bc30011,0xf1af0015,0xe4fb000a}},	//   _паха, şnui, اءٌ_, _הפאש
  { {0x74130015,0x7ee7006b,0xfebb002b,0x91fc003d}},	//   _أوها, зцве, ماست_, ldām
  { {0xc7b900dc,0xfd130002,0x6d4707e0,0x7afd0bd3}},	//   _időt_, فجر_, ttja, _rust
  { {0x20d20bd4,0x7de700dc,0x7afd0bd5,0x71f7006e}},	//   táit_, désé, _sust, _عروس_
  { {0x113b0008,0x6d4700dc,0xc1bb000a,0x11430015}},	//   _התהל, rtja, _למוש, _أَيُ
  { {0x69d80064,0x83fd00dc,0x61080046,0x0aeb0015}},	// [f70] üven, zdőo, _děle, مرئي_
  { {0x8f9c000a,0x6f0d0bd6,0xbe150015,0x7de70030}},	//   _ליחי, _itac, _تودع, gésé
  { {0xbbeb002b,0x28c90065,0xe91900ce,0x7afd02ad}},	//   _گردم_, िकलि, іоді_, _wust
  { {0xddc7005c,0x69d5002c,0xddde016f,0x20d20bd7}},	//   zejś, _vyze, _uopš, láir_
  { {0x07080015,0x7afd007c,0x69d5002a,0xf7940138}},	//   كيني_, _uust, _wyze, нацэ
  { {0x20d2002d,0xfbd200a3,0xe5e50015,0x768f00cb}},	//   náir_, _סתם_, وثغي, _nøyt
  { {0x24e90286,0x249f0bd8,0xa5f600af,0x0000006a}},	//   омки_, thum_, мељу_,
  { {0x6495002d,0x9f65002c,0xb4c9000b,0x20d20125}},	//   _táim, _štýl_, ोते_, háir_
  { {0x7d1a00dc,0xe3b10015,0x8235006e,0x249f0bd9}},	//   átsz, ضرة_, وردا, rhum_
  { {0xaabf000b,0x20d2001a,0xe3b6055f,0xd2a90033}},	//   ्विक, jáir_, ьбы_, ікне_
  { {0x61010024,0x6729001a,0x6f0d0bda,0x71a50bdb}},	//   _vēlo, _hvej, _atac, фанз
  { {0x7de70014,0x6442002d,0xf4850086,0x69c30061}},	//   zésé, _gcoi, _تائی, üney
  { {0xe3ae008f,0x10a30956,0x987a004c,0x93240015}},	//   _рб_, тиян, קאשט, _كرون
  { {0x83fd0014,0xc2c40029,0x6f0d002d,0x12fa000a}},	//   zdől, _كيني, _dtac, _והסב
  { {0x768f00cb,0x2ca00125,0x30860015,0x443f0bdc}},	//   _høys, thid_, _يلتف, ogu_
  { {0x443f0bdd,0xe1640015,0x67290077,0x236d006f}},	//   ngu_, _أدوي, _ovej, ovej_
  { {0x7de70014,0x9f44022d,0x0b460010,0x32f6002a}},	// [f80] tésé, ämä_, ьнан, _młyn_
  { {0x8d760086,0x2ca00bde,0x6b8b0123,0x249d0034}},	//   _قاجا, shid_, ägga, _llwm_
  { {0x7de700dc,0x61080089,0x48660063,0x8e7b000a}},	//   résé, _těle, дълб, _וניה
  { {0x7de700dc,0x0000006a,0x0000006a,0x0000006a}},	//   sésé,   ,   ,
  { {0x7c240bdf,0x7de70030,0xa6ca00af,0x0000006a}},	//   mair, pésé, олда_,
  { {0x443f0be0,0x6442002d,0x9f400111,0x7c240be1}},	//   egu_, _scoi, _azië_, lair
  { {0xa01b002e,0xd82600d7,0x5ee9000a,0xa4f8002b}},	//   fjöl, _одви, הַקְ, سکار_
  { {0xddde005c,0x628a0aaf,0xa01b002e,0x7c240be2}},	//   _kapł, _sofo, gjöl, nair
  { {0x63ad0be3,0x68e300d4,0x0000006a,0x0000006a}},	//   _žanr, înde,   ,
  { {0x7c240be4,0x4b7b000a,0x5b7b000a,0x46130015}},	//   hair, קאיו, קריא, _لوكر
  { {0x3a3704dc,0xca370008,0x6f0d0be5,0x60cf0045}},	//   ורים_, וניה_, _stac, tocm
  { {0xe7f5005d,0x10740036,0xa01b0030,0xa19301c6}},	//   ुँचा_, влюю, lköz, таюч
  { {0x23e2005d,0x44240be6,0xddde002a,0x7c240618}},	//   _परिद, mam_, _napł, dair
  { {0x768f06f5,0x44240be7,0x0000006a,0x0000006a}},	//   _høyr, lam_,   ,
  { {0x20d2002e,0xa2cb005d,0x7c240493,0x20c70a21}},	//   ráir_, सकर्, fair, _осиг
  { {0x7c24002f,0x63a40091,0x44240be8,0x64400be9}},	//   gair, _žiny, nam_, ngmi
  { {0xfbd0003b,0xba2b0029,0x7b09006f,0x3b550033}},	// [f90] لتك_, قسام_, _sľub, экар
  { {0x8a140015,0xf2d8000a,0x010a000a,0xdb040003}},	//   نظما, פַּל, ַלְּ, iziè
  { {0x443f0176,0x7c24002d,0xedd50015,0x44240bea}},	//   ygu_, bair, _سيحد, kam_
  { {0xd0f90053,0xdbd9002e,0xbc19000a,0x44240beb}},	//   פּער, _fæði, _מוֹש, jam_
  { {0xe7080040,0xdbd9001a,0x44240bec,0xf3f900d4}},	//   وتون_, _gæði, dam_, neţe_
  { {0xa01b00dc,0x4519085d,0x7f3c0053,0xfb1a000a}},	//   gköz, пция_, קעוו, _מושמ
  { {0xddde005c,0xe576006b,0x76b2002a,0x645b0bed}},	//   _zapł, езщ_, płyn, teui
  { {0xfdf8013a,0x78a20107,0x3552002b,0x443f0bee}},	//   וצות_, chov, انيز, ugu_
  { {0x61010024,0x645b0bef,0x443f0bf0,0x83fd0030}},	//   _vēlm, reui, rgu_, ldők
  { {0x5778003b,0x443f0176,0x44240150,0xf3f90045}},	//   _تصفح_, sgu_, aam_, deţe_
  { {0xe2a80015,0xa06a0788,0x44240bf1,0x0000006a}},	//   باين_, пана_, bam_,
  { {0x2005005c,0x7ff7002b,0x649c0125,0xf3f90045}},	//   ślin_, کسپا, _héin, feţe_
  { {0x9f4c0064,0xa295005e,0x3cf3000b,0xb7bd0045}},	//   _ölüm_, _паді, ंगने_, _feţe
  { {0x78a20107,0xd336000a,0xc1050015,0xa3b80015}},	//   zhov, _נרצה_, _كوتي, _تامر_
  { {0x7c240bf2,0x6b8b00c0,0xc69200a3,0x78a20069}},	//   tair, äggn, נאל_, yhov
  { {0xa01b0014,0x7c24002d,0x649c002d,0x80890015}},	//   zköz, uair, _léin, _يضيف_
  { {0x7c240bf3,0x945d002a,0x69cb0061,0xdb24002b}},	// [fa0] rair, lońs, şgel, ئوئی
  { {0x4a4305b3,0xd00f002b,0x636a0030,0x44240bf4}},	//   лнув, _پلی_, löná, zam_
  { {0xf2960053,0x7c240bf5,0x8296004c,0x89f50033}},	//   עכער_, pair, עדעס_, вяцц
  { {0xafdb01f0,0x442403a6,0xc8d6002b,0x4c83005e}},	//   mfør, xam_, رزاع, _блюв
  { {0xa01b00dc,0xafdb0293,0xe80f000b,0x2bba0015}},	//   tköz, lfør, ाड़ा_, _راحة_
  { {0x78a20bf6,0x44240bf7,0x945d0535,0x0000006a}},	//   shov, wam_, końs,
  { {0xb7bd04f9,0x78a200c0,0xafdb0293,0x44240bf8}},	//   _reţe, phov, nfør, tam_
  { {0x60c401a3,0xf8a7000b,0x945d002a,0x94aa0033}},	//   _njim, _कॄपय, dońs, ятла_
  { {0x64400005,0x73d70063,0x649c002d,0x36c6005e}},	//   rgmi, ндър_, _féin, _збаг
  { {0x9757000a,0xc757000a,0x44240bf9,0x92940054}},	//   _אימו_, _אימץ_, sam_, таоц
  { {0xb1450086,0x5a9b0053,0x1a9b004c,0xf3f90045}},	//   نیوم_, פשטא, פיטע, veţe_
  { {0xafdb0293,0x859b000a,0x0000006a,0x0000006a}},	//   dfør, _משבו,   ,
  { {0x61080089,0x94a90029,0xf3f90045,0x83fd0030}},	//   _děla, _تطلق_, teţe_, zdők
  { {0xd36f0086,0x71260029,0x623404e5,0x2a6a02dc}},	//   _دهه_, _كربل, _реку, _nabb_
  { {0xafdb0bfa,0xf3f90045,0xc173002b,0x41730015}},	//   gfør, reţe_, _مديت, _مايس
  { {0x11db0008,0x61db000a,0x41db000a,0xf3f90045}},	//   _מחוב, _מקוד, _מחוס, seţe_
  { {0x6fb90036,0xcb34006b,0x9abe0033,0x629a0bfb}},	// [fb0] _ігор_, летъ, мiра_, okto
  { {0x213e003e,0x629a0bfc,0xaf340015,0x60dd0bfd}},	//   outh_, nkto, _إريت, llsm
  { {0x649c0152,0x629a0bfe,0x9a880015,0x76b2002a}},	//   _réin, ikto, عَمْ_, głym
  { {0x8934003b,0xb4ca000b,0x99640033,0x4c950555}},	//   اعلا, लको_, ытул, _римс
  { {0x649c002d,0x4804005e,0xa8040033,0x213e0012}},	//   _péin, упів, узіл, huth_
  { {0xd1380007,0xcb36000a,0xf1b2000b,0x38690b28}},	//   krą_, _בנשק_, ुपान, žar_
  { {0x6abf014e,0x569200d7,0xf5320004,0x195808f0}},	//   ्वीर, рајт, аејќ, _пары_
  { {0x629a0bff,0x25ba0125,0xd1380c00,0x98f40021}},	//   ekto, úpla_, drą_, _مثقا
  { {0x03220033,0x20050046,0x03a501eb,0xb8e70065}},	//   адын, ělil_, типо, ैक_
  { {0x649c002d,0xfb38004c,0x945d002a,0x29030573}},	//   _héil, גאזש_, tońs, _kuja_
  { {0x10a60c01,0x2bd8000b,0xd12e0015,0xbbde0065}},	//   винн, _भुना, يمٌ_, _मर्क
  { {0xf8b3000b,0x40960c02,0x09f6004f,0x629a0c03}},	//   ूचिय, трот, כמתם_, akto
  { {0x6f63008f,0xc7b2000a,0xd138002a,0x32f6002a}},	//   авяз, ֹ֑ר_, arą_, _złym_
  { {0x945d005c,0x76430849,0xd138002a,0xafdb00cb}},	//   pońs, ngny, brą_, tfør
  { {0xb05b0012,0x63a90012,0x6287008c,0x925607f9}},	//   unäc, lzen, öjou, _рајт_
  { {0x6fb60029,0x649c002d,0xafdb0293,0x68fb0091}},	//   _لمعا, _néil, rfør, _niud
  { {0x63a90c04,0x4a460004,0xab2709fd,0xf093004f}},	// [fc0] nzen, кнав, кота_, _כנה_
  { {0xafdb06f5,0x2f97000a,0x63a90c05,0xc9f60058}},	//   pfør, _סכין_, izen, نساع
  { {0x68fb00df,0x2903001c,0xda650015,0x8d76002b}},	//   _biud, _cuja_, داقي, _شادا
  { {0x68fb0c06,0x6f04003f,0x7794002b,0x38c8002b}},	//   _ciud, _kuic, هیزا, راضی_
  { {0x6f040c07,0x63a90c08,0xf7430004,0x7c2b001a}},	//   _juic, jzen, иецо, ðgre
  { {0x63a90c09,0xf7930010,0xfbd30008,0xc6f7005e}},	//   dzen, рашэ, _כתר_, вніх_
  { {0x649c002d,0x6d4e0c0a,0x2bd8000b,0xd90d002b}},	//   _féil, ntba, _भँडा, _فیل_
  { {0x68fb04ed,0x649c002d,0x3eb80c0b,0x6d4e0c0c}},	//   _giud, _géil, hirt_, itba
  { {0x44f70029,0x69dc06bb,0x6d4e0c0d,0x7afc0c0e}},	//   خروج_, _hyre, htba, _kirt
  { {0xd1380870,0x61080046,0xd9e6000b,0xfd5f0016}},	//   trą_, _děln, _करात_, guyễ
  { {0x7afc0472,0x9a3b000a,0xf992000a,0x27ff0061}},	//   _mirt, ותיק, ׁר֙_, _ygun_
  { {0x4035008f,0x213e01b3,0x69dc0c0f,0x629a0c10}},	//   ыемс, ruth_, _myre, skto
  { {0x63a90050,0x7afc002d,0xb4be000b,0xdfd8006b}},	//   czen, _oirt, ँची_, вър_
  { {0xf7730008,0xa2930036,0x7174002b,0x7afc01d7}},	//   בקש_, _ваші, _مهتا, _nirt
  { {0x5c07054f,0xf2d3004c,0x6d4e0c11,0xd5d8004f}},	//   вяза, _דעס_, gtba, גַּש
  { {0x672d0048,0xec340036,0x6ca40088,0x3eb80125}},	//   šaji, инсь, аруж, airt_
  { {0x68e90026,0x7afc0ab5,0x99810046,0xda090015}},	// [fd0] _rhed, _birt, tahů_, فيذه_
  { {0x6495002d,0x7e990015,0xdee4023e,0xe0df02b9}},	//   _háit, _أندر_, _коњи, llò_
  { {0x3f990026,0x68e90034,0x7afc0c12,0x2d8c0013}},	//   lysu_, _phed, _dirt, ødet_
  { {0x08d40036,0x91bb000a,0x99810046,0x69dc0c13}},	//   ація, ומבי, sahů_, _dyre
  { {0xab2b0029,0x649c002d,0x61010024,0x64950125}},	//   _تسجل_, _céim, _vēli, _máit
  { {0x6495002f,0x4aa7014e,0xf77003c4,0x8f9c000a}},	//   _láit, _गतिव, غان_, וידי
  { {0x85550015,0x95550067,0x20d904a4,0x6fd50065}},	//   اختط, اختا, néis_, _युसू
  { {0x20050050,0xe89401d9,0xf5560029,0x5dfc000a}},	//   ślij_, _кась, اليب_, ופונ
  { {0x61080089,0xe894004a,0xb3850015,0xf8b2000a}},	//   _bělo, _тать, اجعه, _השן_
  { {0x454504c9,0xed6001c9,0x63a90c14,0x69080030}},	//   _منطق, ážku_, rzen, _ördö
  { {0x63a90c15,0x61080046,0xd6e40033,0x386d01c2}},	//   szen, _dělo, _лiтв, _kaer_
  { {0x71a20010,0x493a004c,0xf8d3000b,0x3eb80012}},	//   саюз, עגרו, तविय, wirt_
  { {0xd12e0086,0x6f040c16,0x889a000a,0x386d0316}},	//   يمی_, _quic, גברי, _maer_
  { {0x386d00dd,0x61450b1e,0x2d980c17,0x6d4e0c18}},	//   _laer_, _бека, tyre_, ttba
  { {0x2d9e0264,0x387f0061,0x2d950174,0x6da30988}},	//   áte_, _onur_, артс, бира
  { {0x6d4e0c19,0x0b1a0015,0x00da0015,0x3f990034}},	//   rtba, فقرة_, _ثبتت_, bysu_
  { {0x30db0053,0x0aea006b,0x2d9e0c1a,0x3cc7006b}},	// [fe0] _אַזע, едай_, šte_, улто_
  { {0x9a6a003b,0x649c0c1b,0x9e660c1c,0x0e660c1d}},	//   عمال_, _réim, _свод, _скон
  { {0xd5b10023,0x7afc0c1e,0x48e60033,0xeef7000a}},	//   _xét_, _virt, гожв, _תמיר_
  { {0x20d9002d,0xad670010,0x7afc0c1f,0x98da002b}},	//   léir_, _саюз_, _wirt, رباز_
  { {0x7c26003d,0xf76f0015,0x7bdd0034,0xec77006b}},	//   _iekr, كاو_, _gysu, _спя_
  { {0x7afc002d,0xe9440086,0x20d9002d,0x96e7005e}},	//   _uirt, _پرسی, néir_, льща_
  { {0x2aa40014,0x6495002d,0x3a090086,0x91fc003d}},	//   _több_, _náis, _شکلی_, ndāt
  { {0xb4be005d,0x297b0053,0xb97b0008,0x397b000a}},	//   ँचे_, _אטלא, _אנלי, _אטלנ
  { {0x5c370053,0x6495002d,0xb8930015,0x46160015}},	//   ארפן_, _ráit, _القع, _موذر
  { {0x59b8005d,0xa5da0029,0x21540033,0x7414002b}},	//   _आधार, _كبار_, акоў, دوکا
  { {0x6e250064,0x7c260234,0xdd120061,0xcad7004f}},	//   _rehb, _oekr, _rüşv, רוית_
  { {0x99f7000a,0x69c3002a,0x7d050061,0x09f7000a}},	//   טזיה_, źneg, _ruhs, טמים_
  { {0xe29a0c20,0x61080046,0x14d7000a,0xe0df02b9}},	//   _пад_, _tělo, _גואל_, rlò_
  { {0x7bdd005c,0x44260016,0x64950c21,0x20d90c22}},	//   _rysu, _heo_, _fáis, téis_
  { {0xc2c30018,0xc534000f,0xd2b7000a,0x02b7000a}},	//   _ديوي, יָּה_, _תלות_, _תהום_
  { {0x6495002d,0x20d90c23,0x317b000a,0x44260085}},	//   _háir, réis_, _טרומ, _jeo_
  { {0xc3340008,0x2bbb0015,0xb6060107,0x2d8c063b}},	// [ff0] יוּ_, رارة_, _zváž, øder_
  { {0x20d90c24,0x44260c25,0x7e55005e,0x49cb0033}},	//   péis_, _leo_, _твоє, нуем_
  { {0xedf30086,0x7bdd005c,0x6495002d,0x4efa000a}},	//   _ديدگ, _wysu, _máir, _שהתו
  { {0xddde0089,0x7c260c26,0x44260c27,0x9d1a004f}},	//   _např, _gekr, _neo_, _שורט
  { {0xd36603ef,0x2ca9002f,0x501c000a,0x97d80a31}},	//   _به_, mhad_, תודו, льшу_
  { {0xca490086,0x3a870010,0x9a870484,0xe7eb000b}},	//   _جلسه_, _сымв, _сумл, जेगा_
  { {0x4426002d,0x1ddb0065,0xaa5800ce,0x35a50138}},	//   _beo_, _मुमत, _щиру_, райг
  { {0xf7950033,0x44260c28,0x2ca90416,0x0000006a}},	//   _кабэ, _ceo_, nhad_,
  { {0x6495002d,0x44260c29,0x7305049d,0xa3160054}},	//   _báir, _deo_, јпоз, ажњу_
  { {0xe2990001,0xd7940029,0xbb3c0053,0x7295006b}},	//   тао_, _الْخ, געזי, рших
  { {0x20c60036,0x067a0053,0x667a0053,0x008609fe}},	//   ийом, _שנעל, _שטעק, ално
  { {0x2c15005d,0xc952000a,0x672d0085,0x44260c2a}},	//   _फ्लू_, חמט_, šaju, _geo_
  { {0x20d9002d,0xe8d6000a,0x5339004c,0x6e3a001a}},	//   téir_, שורר_, _סײַד, ótbo
  { {0x6495002d,0x249f001a,0xe2960c2b,0xddde0046}},	//   _táis, lkum_, _ваш_, _zapř
  { {0x20d9002d,0xb6060264,0xfcb6004a,0x823a004c}},	//   réir_, _uváž, ащаю, _סעקצ
  { {0x248d060b,0x2ca9002d,0xb05b008c,0x7c850054}},	//   njem_, ghad_, nnäl, буђе

  { {0x3b0706ac,0x3a26005e,0x249f0c2c,0xdca3004a}},	// [1000] ието_, имаг, ikum_, цати
  { {0x8eb30015,0xbf9b000a,0x249f0061,0x248d0c2d}},	//   _وميش, _סייש, hkum_, hjem_
  { {0x7c2601e2,0xb4f7005d,0x249f002e,0xbe3b0008}},	//   _tekr, ुदाय_, kkum_, _בעית
  { {0x31560053,0xb17a0053,0x2ca90c2e,0xed570c2f}},	//   ייען_, כטער, chad_, _тою_
  { {0x248d00bd,0x91fc0024,0x7aeb0030,0x96660c30}},	//   djem_, ndār, ülté, икде
  { {0x4426017e,0xe6930002,0x05760015,0xdcfc0091}},	//   _seo_, يلند, لاعد, tyrė
  { {0xda5b000a,0x4426007c,0xfc3f006f,0x0000006a}},	//   _שכלל, _peo_, _ulíc_,
  { {0xd497004a,0x9417006b,0xd37a0c31,0x57160058}},	//   иры_, ажът_, вчо_, _نورذ
  { {0x6495002f,0x68e20034,0xb8dc0157,0x44260c32}},	//   _páir, mlod, ेच_, _veo_
  { {0xd2570036,0x68e20bc8,0x6d5e0c33,0x291a0c34}},	//   ацю_, llod, _oppa, oppa_
  { {0x672d0a00,0xfa77000a,0x64a60c35,0x44260c36}},	//   šajt, בעית_, _кажа, _teo_
  { {0xd83f0107,0xdfa70004,0x04930015,0x55bb000a}},	//   _účtu_, ајго, _وللح, _במבו
  { {0x58f70053,0x34b30029,0x6495002d,0xc43b000a}},	//   ימטע_, _بمنز, _táir, _יתאי
  { {0x539b000a,0x91b7002b,0x3ea50030,0xd5b10016}},	//   _בידו, اطیر_, ólt_, _kép_
  { {0xa2d3005d,0x61430180,0xdcf70015,0xf531000a}},	//   डवर्, _деја, لأرب, ּ֥ל_
  { {0xbd440029,0x76b2005c,0x51fb0008,0x01fb000a}},	//   تنفي, pływ, _בהוצ, _בפול
  { {0x5a350063,0x68e20026,0x2ca90c37,0x90a7002b}},	// [1010] йнат, dlod, rhad_, _محکم
  { {0xda78005f,0x249f0089,0x657a0541,0x68e20c38}},	//   иях_, zkum_, _orth, elod
  { {0xceb200b2,0xd7c9002b,0xe9870054,0x83fd0030}},	//   _זיי_, گوشه_, шћан, ndőr
  { {0x89340015,0x213e00da,0x99840015,0xc7b10015}},	//   زعما, irth_, تلمو, ًّا_
  { {0xe7680029,0x96b90001,0x07080015,0xa09c000a}},	//   لحون_, луку_, ليني_, כיאט
  { {0x68e20024,0x23ca005d,0xaa950015,0xff18000a}},	//   alod, ापनद, _الآث, סקות_
  { {0x248d00bd,0xce380008,0x25a10046,0xd5750c39}},	//   tjem_, באות_, áhl_, суль
  { {0x6495002d,0x250a0086,0x7c2d0c3a,0x7ccc0061}},	//   _cáip, دروی_, naar, oğra
  { {0xf7730074,0x657a0176,0x248d00bd,0x249f002e}},	//   _باز_, _erth, rjem_, rkum_
  { {0x249f0c3b,0xe610002b,0x7c2d0c3c,0x13020138}},	//   skum_, _قشم_, haar, язьм
  { {0x6f160c3d,0x7c2d0c3e,0x63ad002a,0x0000006a}},	//   _styc, kaar, _żand,
  { {0x8464006b,0x14740015,0xd3080016,0x7c2d0c3f}},	//   _мъче, _وانج, _iện_, jaar
  { {0x999100dc,0x442d0c40,0xf456006e,0x26c70c41}},	//   _mező_, mae_, _طلوع_, onno_
  { {0x442d0c42,0xc7d605bd,0xdc20000b,0x64490c43}},	//   lae_, מורי_, बर्ड_, lgei
  { {0xc6920c44,0x70560015,0x6da30c45,0xf1cf000b}},	//   האם_, _هنغا, пира, _सुचन
  { {0xdd8f0040,0xdca6006b,0x64490c46,0x442d0c47}},	//   روق_, щаби, ngei, nae_
  { {0x501b000a,0x7e9a012c,0x2ca00c48,0xbb4a0058}},	// [1020] _גופו, _منظر_, rkid_, طلان_
  { {0x7c2d00b6,0x2ca00c49,0x442d0c4a,0x0000006a}},	//   aaar, skid_, hae_,
  { {0x9e7b00b2,0x38cb0086,0x68e20024,0xbca6002b}},	//   _ענטפ, گالی_, tlod, _همدي
  { {0x6c86003b,0xb05b008c,0xf849005e,0x48e6006b}},	//   _الحم, enäj, ичій_, щоев
  { {0x30db0053,0xddd50089,0x97560054,0x4733005e}},	//   אַגע, dezř, стељ, зніс
  { {0xcd290086,0x7e7a0053,0xa7850029,0xfaa60004}},	//   _حسین_, ראַז, تشمو, _ѓаво
  { {0xb996003b,0x64950125,0x68e20c4b,0xd9430c4c}},	//   _الزب, _páip, plod, _нери
  { {0xe3140001,0x442d00ea,0x26c702b9,0x62830aa0}},	//   омињ, gae_, anno_, _anno
  { {0x213e0176,0x657a0176,0xdc9b0053,0x389b000a}},	//   wrth_, _wrth, טיקל, _עימנ
  { {0x86ea0029,0x78a20264,0x2d780844,0xe6c6002b}},	//   _إعرف_, lkov, _oče_, _اتري
  { {0x290a0005,0x867b0008,0xd4d60010,0x442d0035}},	//   _juba_, _תרבו, _лідэ, bae_
  { {0xa492002b,0x27e9002a,0x290a01d7,0xb97b0643}},	//   _ریخت, żane_, _muba_, אנטי
  { {0x290a0020,0x43940180,0x623400d7,0xb3850015}},	//   _luba_, _фалс, _делу, _وجهه
  { {0x29180467,0x9e140036,0xa01b002e,0x7c2d0161}},	//   _otra_, здрі, gjör, waar
  { {0x61020048,0x7095000d,0xb05b00f2,0x78a20c4d}},	//   _vēlr, _макф, nnäk, kkov
  { {0xf1b3000a,0x78a2055c,0x3c450058,0x2b400c4e}},	//   _מסצ_, jkov, تَرِ, fric_
  { {0x4054003b,0xfe6e0086,0xdfd10029,0xaa070029}},	// [1030] _رئيس, رگی_, _زيد_, مظاه
  { {0x539b0008,0x5a350036,0xff500015,0x2bb80015}},	//   אימו, інет, _أخي_, حافة_
  { {0x6d410bd7,0x98170015,0x290a0c4f,0xdb04006f}},	//   álad, مبشا, _cuba_, rziá
  { {0x6d5500b8,0xec6b03ad,0x2b4000da,0x182b012c}},	//   mtza, _срок_, bric_, اساً_
  { {0x61080046,0x170a002b,0x2058000a,0x6d470c50}},	//   _děli, لفنی_, מיאל_, luja
  { {0xb7c60048,0xcf58000a,0xf655005e,0x0f58015b}},	//   diģē, צבות_, ітлю, ציום_
  { {0x6d4700bd,0x78a201c0,0x64490c51,0x442d0c52}},	//   nuja, bkov, tgei, tae_
  { {0x6e2e00dc,0x94790c53,0x67d5005e,0xf3590054}},	//   zabb, рску_, _добу, ашој_
  { {0x442d0c54,0xc64b00e6,0x52a90809,0x290a0085}},	//   rae_, _مجال_, ивим_, _zuba_
  { {0xadf9000b,0x6d550079,0x6e2e0012,0x2918001a}},	//   ंधान_, ktza, xabb, _ytra_
  { {0x71b50080,0x208a0c55,0x442002e1,0xf6500015}},	//   ющих, айни_, _нi_, _سئل_
  { {0x25d600b2,0xd0060015,0xafdb00cb,0x6d470c56}},	//   _ווען_, توحً, lføy, duja
  { {0xa8560008,0xa01b001a,0x32f6002a,0xc4f8002b}},	//   חירה_, tjör, _płyt_, _اعلا_
  { {0x78a90c57,0x78a20264,0x61130045,0x62830b58}},	//   _llev, zkov, _călc, _unno
  { {0xde030191,0x78a90c58,0x80e60029,0x6d470c59}},	//   дпри, _olev, _وأعل, guja
  { {0x6e2e0c19,0x8b2609ef,0x2b400c5a,0xdd8f0015}},	//   sabb, ждае, tric_, خوف_
  { {0x765c002e,0x6d470007,0x20050089,0xe61f0092}},	// [1040] _öryg, auja, ělit_, _đôn_
  { {0xe822005d,0x61e3001a,0xea87006b,0x8d660c5b}},	//   मर्थ_, _kynl, обул_, _двое
  { {0x78a900fb,0x89160029,0x6abe0177,0xe96a030e}},	//   _blev, زبائ, ripf, раел_
  { {0x814c0053,0x80370053,0x78a90c5c,0x2b4000da}},	//   רעאַ, ַנצע_, _clev, pric_
  { {0x29070084,0x905b000a,0x78a20c5d,0xf873009a}},	//   ínar_, שכנת, rkov, بهنج
  { {0x649c002d,0xeafa0015,0x7b090085,0xeb9f04d1}},	//   _léit, _خرجت_, _džud, _tfør_
  { {0x27ed0014,0xd6390036,0xc8660015,0x186a005e}},	//   _ezen_, сячі_, _وطري, _кави_
  { {0xd91b0008,0xf9b7000a,0x09b7004f,0x9d1b004f}},	//   _כולל, _והלך_, _ופלט_, בוקט
  { {0xccf3000f,0xf366005e,0xe3b20015,0xb05b008c}},	//   וכה_, ітин, برغ_, snäk
  { {0xb7c60024,0x76a60015,0x78a90046,0xc1780091}},	//   riģē, _بحرك, _zlev, tvė_
  { {0x61e30176,0x76b2002a,0x27e40c5e,0x6108002a}},	//   _cynl, słys, _hymn_, _ośle
  { {0x6d4700f2,0xc4c60015,0x26dc0c5f,0xe4650061}},	//   vuja, _بتطو, lovo_, _çöpe_
  { {0x248601d1,0xc4f7000a,0xb05b008c,0xc1780091}},	//   _inom_, _ומאז_, nnäi, svė_
  { {0x6d470c60,0x26dc052c,0x29040c61,0xadbd0033}},	//   tuja, novo_, _lima_, гагi
  { {0xdcbb010f,0x61e30026,0x621b0008,0x361b0053}},	//   аща_, _gynl, _דווק, שולד
  { {0x290400bd,0x6298099c,0x67f500dc,0x5b150c62}},	//   _nima_, _hovo, nüjé, змат
  { {0x63a00264,0xe6bc000b,0x309c000a,0x24860085}},	// [1050] nymn, ्चाङ, _כשהמ, _mnom_
  { {0x93fb000a,0x60dd0c63,0x78a90c64,0x6d470c65}},	//   שלמי, losm, _slev, puja
  { {0xdfd10074,0x89d90029,0x8883002b,0xda080067}},	//   _زيگ_, حوار_, ویسن, زينه_
  { {0xf7710070,0x7d1a00dc,0x6f0d003f,0x60dd0c66}},	//   فات_, ítse, _kuac, nosm
  { {0xf7940010,0x0a6b0001,0x807c0053,0x78a90089}},	//   мацэ, _крви_, ינאצ, _vlev
  { {0xd6db0292,0x26dc02c6,0x62980c67,0xe7360c68}},	//   ште_, govo_, _novo, чеш_
  { {0xa9540036,0x6f0d002d,0xf5920029,0x60dd0c69}},	//   _окрі, _luac, فلوج, kosm
  { {0x442b0092,0xc8c9009a,0x78a9005a,0x20090c6a}},	//   úc_, _اورن_, _ulev, _ngai_
  { {0x6f0d002f,0x649c002d,0x61e30c6b,0xf770006e}},	//   _nuac, _réit, _synl, _لال_
  { {0xf3f904f9,0xd2a9005f,0xc6740015,0x29040c6c}},	//   neţi_, ское_, _يطلب, _zima_
  { {0x1a9c0053,0x21690956,0x62980c6d,0x61130045}},	//   ייזע, щини_, _dovo, _băla
  { {0x85040015,0x95c4002b,0x6f0d0125,0x61130045}},	//   _قولن, _تيمه, _buac, _căla
  { {0x7ea20152,0x61fe0227,0x6446002a,0x09b8000b}},	//   _hôpi, _úpln, ókie, _आध्य
  { {0x52390053,0x62980a00,0xe3b00087,0x63c80029}},	//   _הײַנ, _govo, _جرم_, _بِهِ_
  { {0xf3f904f9,0xb7bd0011,0x91e20883,0x10a6029b}},	//   deţi_, _deţi, _поше, _никн
  { {0x236d005c,0x649c002d,0x113a000a,0x6ab4000b}},	//   owej_, _héir, _התקל, ंफ्र
  { {0x6b630c6e,0x29040c6f,0x6f0d0c70,0x80e80065}},	// [1060] нкта, _rima_, _guac, _टीएओ_
  { {0xf3f904f9,0x645b002f,0x6d41002d,0x0f7b000a}},	//   geţi_, hfui, álac, _פריל
  { {0x7e9b0008,0x0e9b0008,0x5e9b0008,0xfe9b0135}},	//   _הסיו, _השיל, _הביק, _היימ
  { {0x649c002f,0x6f57002b,0xa2bb0065,0x29d30058}},	//   _léir, _بلیز_, षोत्, رينس
  { {0x66e60c71,0xf7170015,0x2cfa000b,0x26dc07d4}},	//   пода, كينغ_, ्दील_, tovo_
  { {0xf3f904f9,0x26dc04ed,0x8f37000a,0x649c0125}},	//   ceţi_, uovo_, לאנו_, _néir
  { {0xb05b007c,0x29040c72,0x26dc0c73,0x0000006a}},	//   snäi, _tima_, rovo_,
  { {0x493b0008,0x7b07002d,0x39570008,0x27e9002a}},	//   _לגלו, _órtá, _משלם_, żana_
  { {0x7d060604,0x62980107,0xf7430076,0x649c0003}},	//   _miks, _povo, _пето, _séis
  { {0x2cfa005d,0x7d060c74,0x0bb7000a,0xdb9b000a}},	//   ्दुल_, _liks, פלים_, מספר
  { {0xb7bd0011,0xf1a301c5,0x81c6004a,0x2a57000a}},	//   _reţi, ерян, ящие, הבין_
  { {0x62980012,0x7d060c75,0x0000006a,0x0000006a}},	//   _wovo, _niks,   ,
  { {0xdfdb0063,0x7c240c76,0x629800bc,0x6f0d0c12}},	//   сън_, dbir, _tovo, _quac
  { {0xd24f003b,0xb2d30029,0xb3e900a2,0xa2d30015}},	//   _منه_, _كينغ, _بعمل_, _كينت
  { {0xa2d9005d,0xf3f90011,0x625b000a,0xeca70004}},	//   नकर्, veţi_, _הכוה, пјан
  { {0xc1050015,0x6f0d0125,0x6108005a,0x2a7f007f}},	//   _توعي, _tuac, _dělt, _şub_
  { {0xf3f90440,0x2d8c0c77,0x1eab0015,0x7d060c78}},	// [1070] teţi_, äder_, _هادي_, _diks
  { {0x6f7a000a,0x7c240c79,0x0dcb0c7a,0x7d060073}},	//   _וְטו, abir, _гуми_, _eiks
  { {0xf3f90011,0xa9070115,0xceeb002b,0x09340015}},	//   reţi_, سبان, _پرکن_, فرنج
  { {0xe9f80036,0xd117000a,0x6ef202de,0x2d9e0072}},	//   їнці_, פקדה_, ræbe, ätee_
  { {0x3b64010f,0xf3f90011,0xe7380010,0xda7b006b}},	//   _първ, peţi_, зеі_, _ляв_
  { {0x644700df,0x4519006b,0xeb92000a,0xcd34009a}},	//   ėjim, оция_, _סָר_, _تریب
  { {0x67240024,0xdb080030,0x45180033,0x0000006a}},	//   ģija, ölöt, пцыя_,
  { {0x03190086,0xc9520008,0x649c0125,0xdddc003d}},	//   يتخت_, _שמן_, _séir, berņ
  { {0x3365005e,0x2d570061,0x649c0125,0x7eb0008c}},	//   євог, hçe_, _péir, _häpe
  { {0x2d570064,0x7c2400bd,0x957c005c,0x236d002a}},	//   kçe_, zbir, _cząs, rwej_
  { {0x90460074,0xda48000a,0xf487008b,0x9419009b}},	//   ونده, הֲרָ, _нудн, _джет_
  { {0xcea900b4,0x25af0061,0xb603006f,0xf992000a}},	//   _די_, ımlı_, _vtáč, דרט_
  { {0x7d0601bf,0x9836004f,0xe2a8009a,0x0000006a}},	//   _riks, וטרו_, زاین_,
  { {0xa1c50036,0x7d060c7b,0x93fa000a,0x442f00aa}},	//   _облд, _siks, _ולני, _heg_
  { {0x2d9e0045,0x14d5000a,0xfce60c7c,0x7d060c7d}},	//   âte_, ֥וּל_, дово, _piks
  { {0x5f460029,0x442f0293,0x3cf8000b,0xb05b0a64}},	//   _قنبل, _jeg_, ंगें_, liän
  { {0x442f0c7e,0xa08b0008,0x46dd000b,0x200f006f}},	// [1080] _meg_, _וְיִ, यवाह, ámiť_
  { {0xda660029,0x4a43000d,0x7c240c7f,0x8e4a0015}},	//   باري, кнув, sbir, _بلدك_
  { {0x7d060c80,0xd9100086,0xa96a00e6,0x442f0409}},	//   _tiks, ایر_, تمام_, _oeg_
  { {0x291c0024,0x3ce901b2,0x7c2f0596,0x18a3006b}},	//   īva_, clav_, _gecr, кахм
  { {0x69d50012,0x945d002a,0xd7f7067a,0xafdb02de}},	//   _exze, zińc, муш_, lgør
  { {0x442f0005,0xd7f90036,0xcfb7000a,0xb05b0123}},	//   _aeg_, чує_, ולני_, lnät
  { {0xd5b00015,0x442f0c81,0xafdb063b,0xa9260033}},	//   طفة_, _beg_, ngør, _ідал
  { {0x98550010,0x2a780c82,0x5454006b,0x8cc1000b}},	//   _птуш, _harb_, хвит, रोपो
  { {0x442f0c83,0xbc1b0008,0xfc3f002e,0xd2500015}},	//   _deg_, חופש, _slík_, هنة_
  { {0xa79b000a,0xb92b0016,0x079b000a,0x179b000a}},	//   _ושמח, _nguỵ_, _וסמל, _וימב
  { {0x67220048,0xe1340033,0xb05b0123,0xa29f0065}},	//   lpoj, энны, knät, _ओवर्
  { {0x3cfa014e,0x14170029,0x3cf8000b,0x442f0c84}},	//   ्दों_, _قيمة_, ंगों_, _geg_
  { {0xceeb0029,0x5f940063,0x7c2f0493,0x34fb000a}},	//   قرآن_, вият, _recr, _והאד
  { {0x2d5701e2,0x98ba0c85,0x442f0079,0xafdb02de}},	//   tçe_, rupę_, _zeg_, fgør
  { {0x443d0026,0xafdb0134,0x26ce0c86,0x9d180a0b}},	//   _ydw_, ggør, info_, дост_
  { {0x9f550036,0x2cb20026,0x55770053,0x113b000a}},	//   _звич, ghyd_, ועלן_, _ותהל
  { {0xd1380091,0x7e770c87,0x7c220077,0xcb34006b}},	// [1090] lsą_, _taxp, ñora, кетъ
  { {0xe9ab00e6,0x3ce90c88,0xd138002a,0x20190030}},	//   يدان_, slav_, osą_, lcsi_
  { {0x7c2f0064,0x2a78002d,0x7eab0020,0xd1380c89}},	//   _tecr, _darb_, _hüpo, nsą_
  { {0x2cb20176,0xd1380007,0xd8b80029,0xf9900015}},	//   chyd_, isą_, ودنا_, جبك_
  { {0xbc1a0008,0x8c1a0008,0x442f0c8a,0x2b570086}},	//   _מורש, _מורי, _reg_, _زیاد_
  { {0x442f003c,0xd1380007,0xddd500dc,0xbae50015}},	//   _seg_, ksą_, lező, _أكسي
  { {0x5eec000a,0xd9140033,0xb05b0c8b,0x26c90085}},	//   קַדְ, _адсы, nnäs, đao_
  { {0x628a0c8c,0x6d470c8d,0xf9880029,0x2ca90123}},	//   _anfo, irja, _تنفي_, nkad_
  { {0xe3b10029,0x442f0c8e,0x86c50015,0xd1380091}},	//   طرة_, _veg_, _كيرن, esą_
  { {0xeb92000f,0x442f0c8f,0x673b008c,0xe2910058}},	//   רָה_, _weg_, _ivuj, اذة_
  { {0xddd500dc,0x5fc5000b,0x2f140123,0x2ca904f6}},	//   kező, _लेबल, _säg_, kkad_
  { {0xddd500dc,0x90e50015,0x628a0c90,0x3f6a0c91}},	//   jező, َسَن, _enfo, пимо_
  { {0x6d410c92,0xc7b2000a,0xddd50030,0xe3ae0c93}},	//   álan, ָ֑ר_, dező, _сб_
  { {0xd2510029,0x2f1400c0,0x539a00a3,0x639a000a}},	//   _صنع_, _väg_, _מינו, _מסננ
  { {0x98a70089,0xacf600d0,0x9f630046,0xd24e0058}},	//   éně_, ечај, ěvák_, _انى_
  { {0xafdb0134,0x91ba000a,0x0000006a,0x0000006a}},	//   rgør, _ממצי,   ,
  { {0xcb670c94,0x60d7000a,0xab660033,0xcb0a00c3}},	// [10a0] нате_, _רופא_, эвал, سيان_
  { {0xb05b00c0,0xafdb02de,0x8c430061,0x60c60c95}},	//   snät, pgør, ışab, likm
  { {0xc8790064,0x3ad30015,0xc8660c96,0xc212000a}},	//   _baş_, ديلز, етли, אהב_
  { {0xd4910023,0x2ca900c0,0x60c60049,0x998a0046}},	//   _tùy_, ckad_, nikm, _webů_
  { {0x60c60020,0x1002000b,0xb05b0c97,0xfe36000a}},	//   iikm, ोशिश_, onär, ֲרֵי_
  { {0x2f3b0053,0x26ce0c98,0xfc3f0046,0xf5200033}},	//   לגנד, unfo_, _zdí_, анкi_
  { {0x6d5c03b8,0x6d4e0c99,0xe7c0000b,0xe4a60c9a}},	//   ntra, nuba, _शेरप, ерпо
  { {0x6722008c,0x67450030,0x6d5c0c9b,0x09e303a7}},	//   ppoj, ütjü, itra, _сосн
  { {0x68e20020,0xa2940010,0x7afe0ad3,0x6d5c0541}},	//   mood, вапі, ompt, htra
  { {0x6d4e000c,0x9bbb0008,0x276b002b,0x05b60033}},	//   kuba, פציפ, _عشقی_, _псеў
  { {0x51f80036,0xd46a0c9c,0xd1380007,0xe3af0086}},	//   ьною_, _ниже_, usą_, لری_
  { {0xe61f0092,0x19b7000a,0xd1380091,0x68e2053a}},	//   _đôi_, תפטר_, rsą_, nood
  { {0xdefb004a,0x6d5c0c9d,0x883b004f,0xddd501d3}},	//   зыв_, etra, התכו, vező
  { {0x628a003e,0x6d5c00b8,0xe2970033,0x60c60091}},	//   _unfo, ftra, _пач_, aikm
  { {0x68e20c8d,0x627b0008,0xc27b0008,0x68eb001a}},	//   kood, _מנגנ, _מרגי, ylgd
  { {0x61430001,0x60c60064,0xa3e4000b,0x6fb50015}},	//   _сећа, cikm, पअप_, _لمبا
  { {0xfbd00029,0x6d4e007c,0x2ca90c9e,0x6d5c0c9f}},	// [10b0] متك_, auba, rkad_, atra
  { {0x2ca90ca0,0x6d4e0ca1,0x6d5c0ca2,0x0000006a}},	//   skad_, buba, btra,
  { {0xc984049d,0xb835006b,0xe8590033,0x99670033}},	//   луци, веещ, даеш_, этал
  { {0xcd960008,0x6d88000a,0xd3080016,0x7afe00aa}},	//   _סדרת_, _נָתְ, _iệu_, ampt
  { {0x4c9a000f,0xd763002b,0xdc36000a,0xb05b008c}},	//   _חברו, انتی, _בארט_, jiäm
  { {0xc6680001,0xe5710015,0x64460030,0xff7c000a}},	//   ешће_, لطب_, ókin, פטומ
  { {0x20e1005d,0x68e200dd,0xc8790061,0xc9e50015}},	//   नवाध, bood, _taş_, _شكرً
  { {0xe8d5004f,0x0000006a,0x0000006a,0x0000006a}},	//   _סוּר_,   ,   ,
  { {0x6d5c0ca3,0xa3de000b,0x60c6001a,0x7eb0007c}},	//   ztra, _दुआ_, vikm, _läpa
  { {0x8cc1000b,0x17f80015,0xa3a80015,0x63a600cb}},	//   रोतो, _سرقة_, عطيك_, økna
  { {0x61ea0176,0x2a760008,0x4a5c0053,0x60c60007}},	//   _cyfl, דעתך_, לדזו, tikm
  { {0xf9920008,0x387d0034,0x26c70ca4,0x6d5c0ca5}},	//   ׁ֨ר_, ndwr_, lino_, vtra
  { {0x883a0008,0x3f8401b2,0x20550033,0xb05b0123}},	//   ותרו, ímu_, ытэр, tnär
  { {0x7d1a0030,0x6d4e0ca6,0x6d5c0ca7,0xdee2005e}},	//   ítso, tuba, ttra, румi_
  { {0x61ea0176,0xed570561,0x40960015,0x201b001a}},	//   _gyfl, кор_, _للغر, ægið_
  { {0x8c43000d,0x5cf6005e,0xf992002b,0xe6f20016}},	//   иесе, тягу, یبا_, _mườ
  { {0x6d4e00b6,0x25e8005d,0x387d0026,0x6d5c03b0}},	// [10c0] suba, _चुनी_, ddwr_, stra
  { {0x1f37000a,0x0f37004c,0x28c4000b,0x68e20ca8}},	//   _שריר_, _שריט_, लोनि, wood
  { {0xda650029,0x68e20020,0x26c70ca9,0x8d1a0058}},	//   طالي, tood, dino_, _تزخر_
  { {0xdb0d00dc,0xd3080016,0xa01b001a,0xccfa0033}},	//   szaá, _hệt_, rdög, _іхні_
  { {0xcee9002b,0xc017000a,0x2c17000b,0x68e20caa}},	//   _زرین_, דקנו_, धुओं_, rood
  { {0x68e20020,0xb05b008c,0xe9da01c6,0xcdc9002b}},	//   sood, viäm, _жкг_, _آذین_
  { {0xceb30008,0x95530029,0xd5af0002,0xd3080016}},	//   שיו_, لخيا, يفه_, _mệt_
  { {0xfbd2000a,0x18a30033,0xe6f20016,0x98a30cab}},	//   ֹת֙_, _касм, _dườ, _кисе
  { {0x26c7018c,0xd4670001,0x37060033,0x6ef202de}},	//   bino_, тиње_, _апаг, væbn
  { {0x26c70cac,0xc174004a,0x60c402f2,0xe4650052}},	//   cino_, глощ, _amim, þörf_
  { {0xaa370053,0x3a37000f,0x40350cad,0xe6f20016}},	//   כטיק_, כרים_, ленс, _gườ
  { {0x7ccc0064,0x94260004,0xd250002b,0x7eb0007c}},	//   oğru, _рмде, جنگ_, _räpa
  { {0x2d9e0cae,0xa3b7002b,0x2d8c0caf,0xddce0073}},	//   äten_, _لاور_, åden_, bebū
  { {0x41dd005d,0xd337000a,0x62340cb0,0x6d410900}},	//   _नुकस, _ירדה_, _секу, šlam
  { {0xd3080092,0x2d850cb1,0xe611000a,0x9e34004a}},	//   _dệt_, íle_, מִן_, ресч
  { {0xc0ab0067,0xf0470033,0x1fa70302,0x26c70cb2}},	//   _زابل_, _рэко, _арог, zino_
  { {0x09bd005d,0x9be70036,0x80a40086,0x1be3000b}},	// [10d0] ्प्य, тівк, _خمين, _कुशल_
  { {0xdd030064,0x7a350086,0x387d0034,0x6e990054}},	//   ırıc, افاص, wdwr_, _чвор_
  { {0x6cd50031,0x26c70cb3,0x61f8000a,0x77690123}},	//   _مقدا, vino_, תִּג, _spex
  { {0x64420cb4,0x9854005e,0x487800ce,0xbc9500af}},	//   _ndoi, итіш, ксія_, _самј
  { {0x3ea10020,0xa3e4000b,0x7b090091,0xa8480015}},	//   _koht_, पॅम_, _užuo, ئلهم_
  { {0xe7eb000b,0xc7320015,0x66f401f3,0x0000006a}},	//   ड़ेगा_, حفوظ, апчу,
  { {0xf999000a,0x95c80054,0x26c70cb5,0x0000006a}},	//   _אֱ֭ל, кућа_, rino_,
  { {0x94750029,0x3f8200bf,0x26c70cb6,0x3f8600bc}},	//   ادثا, yvku_, sino_, _šoum_
  { {0x26c70cb7,0xdce50024,0x1309006d,0xa2e50b59}},	//   pino_, _arhī, нний_, лоид
  { {0x6b670024,0x7dd20030,0xe6f20016,0xd7f80418}},	//   mīgā, nűsé, _tườ, _рус_
  { {0x27fa005c,0x24550031,0xaadc000a,0xd3080016}},	//   ępne_, _مناس, וחזר, _rệt_
  { {0x351a0008,0x629a0cb8,0xe3b902ed,0x409600af}},	//   _טוענ, ajto, _плеч_, урот
  { {0x7ae50356,0x239b0029,0x6b67003d,0xc476004f}},	//   koht, _تخضع_, nīgā, _תתנו_
  { {0x7ae500f2,0xe39a0008,0x02440015,0x91fc003d}},	//   joht, _רֹאש, _نَهَ, teāt
  { {0x92560cb9,0x270f000b,0x63bb0012,0x290d0077}},	//   _сајт_, ादुर_, lzun, _oiea_
  { {0x63a90003,0x4f960cba,0x68fb0034,0x7188004f}},	//   oyen, _броу, _nhud, _יְפַ
  { {0x8b26008f,0x63bb00b8,0xf4120053,0x4c350033}},	// [10e0] удзе, nzun, מפן_, рэст
  { {0xfeba0074,0x7e560054,0x63bb0012,0x6b67003d}},	//   _ساخت_, _стиц, izun, dīgā
  { {0x09f60457,0xaa570015,0xa84a0015,0x0e5b000a}},	//   учая, الما_, فلام_, _אדיב
  { {0xd7fa0080,0x7e7e0193,0x61130011,0x27ed0cbb}},	//   нул_, _happ, _căli, _byen_
  { {0x7c950010,0xddc704b2,0x46a606eb,0x96ea0a96}},	//   _трэц, mejš, ладв, нька_
  { {0x66e302bf,0xaf77004c,0x8b8b000a,0xddc70cbc}},	//   боча, טענס_, _אָלֶ, lejš
  { {0x7b09016f,0xb5aa0029,0x89780008,0xd639005e}},	//   _ožuj, عاتك_, _בָּה, тячі_
  { {0xddc70cbd,0x7e7e0cbe,0xb8660015,0x63bb0012}},	//   nejš, _lapp, _حاسو, fzun
  { {0x6b670024,0x63a900dc,0xa5070001,0xaaa8000b}},	//   cīgā, gyen, ћења_, _गवाक
  { {0x6b5b000a,0x53130015,0x6b84007c,0x3a3a0cbf}},	//   עדיפ, حذير, ivig, napp_
  { {0x6b840020,0x63bb003f,0xa52603ae,0x2348002b}},	//   hvig, azun, _смед, رسکی_
  { {0x7a480024,0x6fb50015,0x659b000a,0xb386006e}},	//   lītē, لمجا, _ריאק, _مجته
  { {0x4fc70cc0,0xdfd8006b,0x7e7e0cc1,0xa29400e2}},	//   усна, гър_, _bapp, _валі
  { {0x7e7e0cc2,0xb68a004f,0xa5c30535,0x7a4801ec}},	//   _capp, ׂרָ֥, skół, nītē
  { {0xccfb0124,0x7eb0007c,0xd5d8000a,0x6b67003d}},	//   ећа_, _täpn, דַּש, zīgā
  { {0x61f50061,0x61f80cc3,0x0000006a,0x0000006a}},	//   üzle, _izvl,   ,
  { {0x5a350549,0x6bd40029,0x68fb0034,0xfce80058}},	// [10f0] инат, متكر, _rhud, افقي_
  { {0x68fb00da,0xdb04002a,0x6b67003d,0x2004006f}},	//   _shud, dzió, vīgā, ýmie_
  { {0x7dd200dc,0xb815000d,0x1cd90033,0x2243002a}},	//   rűsé, адеј, _адны_, ójki_
  { {0xf7710806,0x3157000a,0x7ae5007c,0x6b67003d}},	//   قات_, ריאן_, soht, tīgā
  { {0xcc56039e,0x4c3a000a,0x4e19000b,0x7c2d0cc4}},	//   _דברי_, _בתרב, _दलाई_, mbar
  { {0x6b670024,0x63a90aa5,0xe4630061,0x8b88000a}},	//   rīgā, vyen, şmüş, _עָרֶ
  { {0x5e580053,0x7d0f00dc,0x68fb0026,0x04b5006b}},	//   טיגע_, _kics, _thud, исия
  { {0x63bb018b,0x58d50036,0x3f890026,0x27f2002a}},	//   tzun, _тобт, _orau_, żyna_
  { {0xe7ec000b,0x63bb0012,0x7c2d00aa,0x657a0cc5}},	//   _छुपा_, uzun, ibar, _esth
  { {0x63bb00b8,0x7982005c,0xd2a9004a,0x52a6004a}},	//   rzun, łowe, ткое_, ивым_
  { {0x3d11000b,0x80a60015,0x3f8901c2,0x7c2d0cc6}},	//   _दंगे_, لمدن, _arau_, kbar
  { {0x7c2d005c,0xd59a0008,0x859a000a,0x251a000a}},	//   jbar, _בבעל, _בשעו, _סונא
  { {0x442d0cc7,0xddc703cd,0x889a000a,0x7e7e0cc8}},	//   mbe_, vejš, דברי, _papp
  { {0x7d0f002d,0xdcfc0227,0x03d6000a,0x442d0cc9}},	//   _aics, tvrď, _דונם_, lbe_
  { {0x3f890011,0x3c4200dc,0xddc70cca,0x98b5000b}},	//   _erau_, _lévő_, tejš, ंसाए
  { {0xed570083,0x3f890ccb,0xd6f10033,0x7e7e0ccc}},	//   јот_, _frau_, _лiчб, _wapp
  { {0x7d0f00dc,0xddc70ccd,0x442d0012,0x8cb7000b}},	// [1100] _dics, rejš, ibe_, ोफ़ो
  { {0x628107e9,0x7c2d0cce,0xcf250015,0x6b840ccf}},	//   ndlo, abar, _اريي, rvig
  { {0x442d00dc,0x3af50080,0x02b60053,0x8cc6002b}},	//   kbe_, сятс, סלעך_, _نقده
  { {0x387f0048,0x442d0cd0,0xad1b000a,0x391302a3}},	//   _caur_, jbe_, _שוכר, імір
  { {0x442d0198,0xdddc00dc,0xf7170029,0xd7ef0015}},	//   dbe_, merő, لينغ_, وكم_
  { {0xdb040014,0x6b8b0134,0x7d040cd1,0x6e3c0cd2}},	//   rzió, ægge, lmis, narb
  { {0x38560063,0x5ee9000a,0x62810034,0x7d040cd3}},	//   _възс, נַנְ, ddlo, omis
  { {0x6d41002d,0x48e30127,0x442d0030,0x6d4e0091}},	//   álai, _досв, gbe_, irba
  { {0x9ae90036,0xb4d6000b,0x4616002b,0x2b4000da}},	//   нiше_, _सदी_, _نوذر, nsic_
  { {0x6d410cd4,0x7d040cd5,0x29180cd6,0xf3630033}},	//   šlai, hmis, _kura_, ітын
  { {0x442d02d7,0xf42600f2,0x6e3c0cd7,0x5a1700a3}},	//   bbe_, ääsi_, darb, יקין_
  { {0x38660cd8,0x29180cd9,0xd5770008,0x649c0251}},	//   nfor_, _mura_, _כתבה_, _néix
  { {0x7d040cda,0xdfdb0063,0x6e3c0cdb,0x4ea70cdc}},	//   dmis, тън_, farb, арва
  { {0x6e3c0cdd,0x13bb000a,0x7d040cde,0xa1580280}},	//   garb, _שֶׁמ, emis, _баку_
  { {0x42fb0008,0x12fb0008,0x51930029,0x7d0f0112}},	//   _שהוס, _שהוב, _ولهذ, _pics
  { {0xdddc0014,0xc0350180,0xb035049d,0x7d040cdf}},	//   gerő, _униј, _униш, gmis
  { {0x5c070063,0x2fcf00c0,0x29180ce0,0x4ae70033}},	// [1110] рява, _ägg_, _aura_, аўжа
  { {0x9be40010,0xe9870001,0x7d040ce1,0x7c2d0ce2}},	//   ціск, ићен, amis, sbar
  { {0x442d0ce3,0xdd840033,0x180f000b,0x7d040ce4}},	//   ybe_, _дыяп, िश्व_, bmis
  { {0x7c950029,0x29180ce5,0x78470033,0x7d04007f}},	//   _الحص, _dura_, рэжж, cmis
  { {0x7bd801e2,0x62810034,0x442d0ce6,0x6cfa000a}},	//   şvur, ydlo, vbe_, _תפרס
  { {0x45450015,0x36c4005e,0xdbdd0030,0x7a400046}},	//   منتق, обіг, jáér, rátí
  { {0x20d2002c,0x27fa005c,0x442d0ce7,0x29180022}},	//   lšie_, ępna_, tbe_, _gura_
  { {0x9dd80008,0xadd80008,0x80c6005d,0x442d0ce8}},	//   יווק_, יווח_, _लगें, ube_
  { {0x7c220077,0x442d0ce9,0x20d2006f,0x6e3c0cea}},	//   ñori, rbe_, nšie_, yarb
  { {0x0bb8000a,0x7d0402c6,0x3f84001a,0x78ba0091}},	//   ילחם_, zmis, æmum_, _įtvi
  { {0xd2980010,0x20d2002c,0x7d040ceb,0x442d0030}},	//   ртыі_, hšie_, ymis, pbe_
  { {0xcea9039e,0x6109002a,0xdcfc0045,0xa988004f}},	//   _אי_, _yśli, ivră, בָשִ
  { {0x20d2032c,0xd3080092,0xdfd20031,0x93940021}},	//   jšie_, _tệp_, سيس_, _وجها
  { {0x249f0084,0x6d550011,0xed5a0cec,0x63f40015}},	//   ljum_, fuza, лог_, _بأمر
  { {0x7d040005,0xb4f90053,0x6e3c0ced,0x91780016}},	//   tmis, ָפּי, rarb, _vợt_
  { {0xa01b0061,0x7d04014b,0x3a380144,0x11d40015}},	//   ldön, umis, _serp_, _بتهد
  { {0x6a160029,0x2918003f,0x7d040cee,0xdca306cc}},	// [1120] مبار, _sura_, rmis, чати
  { {0x3f8f001c,0x249f007c,0x7d040cef,0xda79005e}},	//   _água_, hjum_, smis, ияє_
  { {0x5d860029,0x8fc50086,0x249f002e,0xd23a0053}},	//   _الجل, _هزین, kjum_, רגעל
  { {0xcb09000a,0x7188000a,0x20d2006f,0x98c502a3}},	//   גל_, יְנַ, bšie_, осіл
  { {0xdd8f0086,0x38660293,0x69d90012,0xa8e90058}},	//   _قوی_, rfor_, ßwer, جعلك_
  { {0x66e30036,0xe944002b,0xb05b0012,0xa7730033}},	//   поча, _ورزی, chäf, яліч
  { {0xceb30008,0x249f001a,0xa56a0058,0x0000006a}},	//   היג_, fjum_, اصتك_,
  { {0x249f002e,0xd5370015,0x65b20052,0x0000006a}},	//   gjum_, حثوا_, eðhö,
  { {0x3636002b,0x5c5b004c,0xdbdd0030,0x644f01d3}},	//   _هراس, װדיק, táér, ócia
  { {0x25610014,0xe3af0015,0x28c4000b,0xa01b0030}},	//   ból_, عري_, लोरि, gdön
  { {0x76480176,0xf09f0251,0x6a9b0053,0x6d480cf0}},	//   _iddy, tjà_, אשינ, ádal
  { {0xdbdd00dc,0xe04b002b,0x09f7000a,0x26ce0034}},	//   sáér, دشده_, ממים_, lifo_
  { {0x33f603c4,0xfebb0086,0x2e4b006b,0xdcfc0045}},	//   _اساس, هاست_, ляво_, zvră
  { {0xd1300029,0x20d2002c,0x121a0010,0x62010064}},	//   _قمت_, všie_, _сюды_, öylü
  { {0x7e7500bc,0x82630015,0x21260058,0x0000006a}},	//   rezp, _رهين, _اعتُ,
  { {0x853b00b2,0x8cf506b4,0x20d2006f,0xde47002b}},	//   טגלי, ізац, tšie_, _گیسو_
  { {0xab94005e,0xa4b7000a,0xab87006b,0xeb090015}},	// [1130] питі, צלמה_, щувк, لقرى_
  { {0x20d2002c,0x70550086,0x249f002a,0x531b004f}},	//   ršie_, _انکا, zjum_, טומצ
  { {0xceb2000f,0x89d90040,0x249f001a,0xadbd02a3}},	//   _חיי_, جوار_, yjum_, _ранi
  { {0x76480176,0x20d2002c,0x515b00f3,0xb05b008c}},	//   _addy, pšie_, רכאו, miäs
  { {0xb05b00f2,0x46a50063,0xe7680015,0x7528003d}},	//   liäs, жалв, محون_, _atdz
  { {0x7982005c,0x25610744,0x7f3c0053,0xf7700031}},	//   łowa, tól_, נעוו, عان_
  { {0x04590029,0x249f002e,0x65920054,0xf505005e}},	//   للغة_, tjum_, дају, озко
  { {0x25610014,0x4439002d,0xc32503ad,0x7eab007c}},	//   ról_, ús_, омик, _küps
  { {0x249f002e,0xd2990036,0x0000006a,0x0000006a}},	//   rjum_, атні_,   ,
  { {0x02c50191,0xe3b60033,0x63a60123,0x68eb0cf1}},	//   ійно, юбы_, äkna, logd
  { {0xd4e70191,0x2bd0005d,0x21690cf2,0xe1f10015}},	//   _люди, _सेना, шини_, بسة_
  { {0xc1060015,0x33950015,0xd00a006b,0x439501e1}},	//   توجي, _ولاز, иене_, _маес
  { {0x443f0176,0xb4e5005d,0x10a3006b,0x33d40033}},	//   mau_, पकी_, фиян, _нішт
  { {0xdcb10023,0x6729003f,0x443f0cf3,0x6d480091}},	//   ển_, _mtej, lau_, šdam
  { {0xa1560001,0xa0c60015,0xc692000a,0x2d8c006f}},	//   _дају_, _ويتو, ואם_, íde_
  { {0x443f0cf4,0x645b0cf5,0xa01b0030,0x62830cf6}},	//   nau_, ngui, ndöl, _hano
  { {0x7eb000f2,0xbb4a0015,0x645b0cf7,0x62830cf8}},	// [1140] _läpi, شلان_, igui, _kano
  { {0x386d018b,0x443f0cf9,0x2ca008c0,0x0af60033}},	//   _aber_, hau_, sjid_, ічаў
  { {0x6d410014,0x68460029,0xdc6a00fd,0xdca60cfa}},	//   álat, قَال, _канд_, _дани
  { {0x872a0010,0xb05b0cfb,0x186a0cfc,0xfc320015}},	//   аўка_, chäd, ради_, _تحد_
  { {0x443f0b7c,0x27e001e2,0x47330036,0x07a30010}},	//   dau_, çin_, дніс, мацн
  { {0x9f610014,0xba760015,0xe666005e,0x443f0cfd}},	//   ését_, _باحت, ітло, eau_
  { {0x443f0026,0x26ce0026,0x2b4f0046,0x7eab007c}},	//   fau_, rifo_, ělců_, _küpr
  { {0x443f0176,0x636a0cfe,0x62830c99,0x7c240cff}},	//   gau_, арог_, _aano, ncir
  { {0xdc8b000a,0x6d48013f,0xf7530015,0xa8a50015}},	//   בְיָ, ádaj, _ينفج, _عصفو
  { {0x62830d00,0x75960015,0xe7d5002b,0x67450046}},	//   _cano, _وجاء, _عملگ, řují
  { {0xe29a0023,0x81c60080,0xa1940004,0xa1860033}},	//   _chưa_, ющие, чанч, цыпл
  { {0xb97b000a,0xb05b008c,0x75d3006e,0x443f0d01}},	//   בנטי, viäs, _تيما, cau_
  { {0x64d90053,0x62830d02,0x3f8d0144,0x1394005e}},	//   _פֿעס, _fano, íeu_, _хилю
  { {0x7c260134,0x62830d03,0xb05b008c,0x64400d04}},	//   _afkr, _gano, tiäs, lami
  { {0x9c830d05,0xeca70cb9,0x31c3006b,0xac950888}},	//   íčov, ојан, _осъв, павш
  { {0x4c940080,0x6aaa00b8,0x91bb000a,0xc1bb000a}},	//   мисс, öffn, _כמוי, _כמוש
  { {0xd1080086,0xdfd10002,0xfbd00015,0xa01b0123}},	// [1150] _بقيه_, _سيد_, نتك_, ndöm
  { {0x6d410014,0xba980036,0x64400d06,0x44240016}},	//   álas, овує_, hami, hcm_
  { {0xceb200b4,0xe2a60084,0x67290089,0x20d2006f}},	//   _ניט_, _áður_, _stej, lšia_
  { {0x5d7a0632,0xc19b000a,0xdcef0091,0xdbdd0030}},	//   _פארק, ישבי, _įdėj, láír
  { {0x4c9a000a,0x64400d07,0x386d0012,0x7b640d08}},	//   _הברו, dami, _vber_, _отре
  { {0xcf580008,0xb7d20029,0x443f0026,0x8f7c0008}},	//   קבות_, عقوب, wau_, ינדק
  { {0x60cd0d09,0xce38000a,0xb05b008c,0x7c3d01d7}},	//   _omam, חאות_, snäy, _kesr
  { {0xb4e5014e,0x64400d0a,0x6283022d,0xe5040015}},	//   पके_, gami, _sano, وبيي
  { {0x443f0176,0x20d2002c,0x7c3d0213,0x97250015}},	//   rau_, jšia_, _mesr, _رفضو
  { {0x44260176,0x443f0d0b,0x78a90161,0x64400209}},	//   _efo_, sau_, _hoev, aami
  { {0x443f0d0c,0x64400020,0xe2a80040,0x44260034}},	//   pau_, bami, تاين_, _ffo_
  { {0xe4d70015,0xd5fa000a,0x64400d0d,0x7c3d0d0e}},	//   _بتطب, _הפער, cami, _nesr
  { {0x628300b6,0xa2950036,0xdd0c005c,0x78bb0107}},	//   _tano, _наді, różn, _mluv
  { {0xe29a0092,0x78bb02c1,0xc332000a,0x2261002a}},	//   _thưa_, _lluv, _טוד_, órkę_
  { {0x6da60c1c,0x6df60015,0xc692000a,0x61ee01c0}},	//   чива, سكرا, עאל_, čilé
  { {0x61fc01e2,0x8b260080,0xc5f20008,0x443d00da}},	//   ürle, здае, גדל_, _jew_
  { {0x305b0008,0x905b0008,0x945d005c,0x6d41001a}},	// [1160] _הדפד, _הכפת, lińs, álar
  { {0x7c240d0f,0x09e602c4,0x7fe90067,0x9f4f0030}},	//   scir, позн, _ظريف_, _ágá_
  { {0xfbc90008,0xe9da0001,0x224a002a,0x945d002a}},	//   נת_, љке_, óbki_, nińs
  { {0xb4e5005d,0x7eab0020,0x443d0d10,0x7982002a}},	//   पको_, _hüpp, _new_, łowo
  { {0x64400d11,0x945d002a,0x28bd000b,0xe704002b}},	//   vami, hińs, ्फ़ि, وستی
  { {0xab27010f,0xabfb0008,0x78bb0020,0xd94600d0}},	//   _хора_, _להכר, _eluv, _неги
  { {0x64400100,0x3ea50030,0xc448002b,0x09e30d12}},	//   tami, ölti_, قیان_, _зорн
  { {0x89db0008,0xb9db000a,0x644001d7,0xe4520058}},	//   _החלי, _החלש, uami, رضع_
  { {0x8cc1005d,0xe737069d,0x64400d13,0xdc8b000a}},	//   रोटो, _нет_, rami, זְיָ
  { {0x64400d14,0x20d2006f,0xa01b0123,0x644b00da}},	//   sami, všia_, rdöm, _edgi
  { {0x443d0041,0xdbdd00dc,0x8506002b,0x7055006e}},	//   _few_, váír, _فوئن, وندا
  { {0xdfd50010,0x69c10020,0x859b000a,0xb97b000a}},	//   домы, _ülee, _לשבו, זנטי
  { {0xdcb10023,0xb465002b,0x74130015,0x2d8c02de}},	//   ểm_, _آدمه, _كوما, æden_
  { {0x945d002a,0x20d2006f,0x7bc40535,0x0000006a}},	//   bińs, ršia_, dziu,
  { {0xdd940010,0x945d005c,0x7eb00020,0x9cf50484}},	//   нары, cińs, _näpu, дзві
  { {0x20d2002c,0x41db000a,0x11db000a,0x515b000a}},	//   pšia_, _לחוס, _לחוב, _הכהו
  { {0x2bc7005d,0x9f540010,0xfbd30087,0x6c540033}},	// [1170] _रेखा, _звыч, رتر_, экту
  { {0x7b09010b,0x62880d15,0x6008000a,0x78a90d16}},	//   _ažur, nddo, _מִתְ, _soev
  { {0x2d8c0d17,0x2d9e0123,0x60dd0d18,0x62880034}},	//   ådet_, ätet_, onsm, iddo
  { {0x18690036,0x315701ac,0xda080015,0x99640033}},	//   іали_, ליבן_, سينه_, этул
  { {0x9be40036,0x6298016b,0x99620046,0x945d002a}},	//   _зірк, _onvo, _míře_, zińs
  { {0x6d550d19,0x6d470535,0x0000006a,0x0000006a}},	//   orza, osja,   ,
  { {0x78a90991,0x58d50036,0xb9250086,0x291c0089}},	//   _toev, _жовт, _آفري, ívat_
  { {0x62880026,0x6d48002d,0xcd98039e,0xe3b909a8}},	//   eddo, ádai, לדות_, жби_
  { {0x27ff0064,0xa3e7005d,0xf7700115,0x6d550012}},	//   _uzun_, _मुख_, _مال_, hrza
  { {0x25e8005d,0x6d470020,0x62880034,0xdb9c000a}},	//   _चुकी_, ksja, gddo, מסחר
  { {0x6d55005c,0x35f50010,0x443d0034,0x41b40c6e}},	//   jrza, _ўпер, _tew_, есят
  { {0x644b00fb,0x6d55016f,0x62980d1a,0xc4fb002b}},	//   _udgi, drza, _envo, _اعطا_
  { {0x4fa3005e,0x945d002a,0x7d1e0085,0x91fc003d}},	//   вияв, sińs, _sups, egād
  { {0xad3a005e,0x945d002a,0x76430d1b,0x03d6000a}},	//   жчає_, pińs, nany, _קוסם_
  { {0xf2e6002b,0x80a60015,0x9288002b,0x6d410030}},	//   _تکيه_, _يمتن, _رئوف_, álap
  { {0x7643013c,0xc1060369,0x0000006a,0x0000006a}},	//   hany, _توبي,   ,
  { {0x6d470020,0xab660033,0x76430d1c,0xf093000a}},	// [1180] asja, ьвал, kany, _ינה_
  { {0x0f570008,0x6d55002a,0x76430d1d,0x4bd902ed}},	//   _קיים_, brza, jany, чься_
  { {0xa9670063,0x7e9b000a,0x5e9b000a,0xfe9b000a}},	//   диха_, _וסיו, _וביק, _ויימ
  { {0x0c260010,0x395a0d1e,0x8b2601ca,0xeb9a0d1f}},	//   _імгн, rups_, _одме, _дим_
  { {0x62880176,0x7643000c,0xb906014e,0x6d5c0d20}},	//   yddo, fany, _पद_, lura
  { {0xfbd30008,0x07a307c1,0x5751004c,0x395a0d21}},	//   _יתר_, таљн, _אױפֿה, pups_
  { {0xf9830d22,0x6d5c0d23,0x7e7c0d24,0xa9230138}},	//   _игро, nura, ierp, _адсл
  { {0x2ebb021e,0xd250002b,0x764302f2,0x7e7c0651}},	//   _उत्त, گند_, aany, herp
  { {0x76430d25,0x7e7c03d2,0xc445002b,0x6d5c0d26}},	//   bany, kerp, ریون_, hura
  { {0xd2500074,0xeb9100b2,0xcb9b0053,0x6d5c0d27}},	//   دند_, אָט_, קסיט, kura
  { {0x62880176,0xf1aa0086,0x6d5c0509,0x2a57000a}},	//   rddo, زاده_, jura, ובין_
  { {0x04930029,0xe5e7002b,0x6d5c0d28,0x0000006a}},	//   _للمح, _غزلی, dura,
  { {0x6d5c022d,0xef64006b,0x99620046,0x8236002b}},	//   eura, къро, _víře_, _قرغا
  { {0xdcfe0089,0x6d55005c,0x629800b8,0x6d5c02e8}},	//   _trpě, trza, _unvo, fura
  { {0x6d5c0d29,0x20d70058,0xd0d5009b,0x9f990546}},	//   gura, _يتعج, _покъ, _dáár_
  { {0x76430d2a,0xe58b000a,0x90e70015,0x20c20125}},	//   zany, חָמָ, _تستن, _cóid_
  { {0x2d9e018b,0x3f850048,0x2d8c0d2b,0xce95006b}},	// [1190] äter_, ālus_, åder_, _запъ
  { {0x6d5c0d2c,0x1a5b0015,0x7e7c00da,0x9af50015}},	//   bura, تشرة_, cerp, ركات
  { {0x644f0014,0xe8550015,0x6d5c0d2d,0x6b8d0d2e}},	//   ócik, فناد, cura, svag
  { {0x2bd0014e,0x76430d2f,0x2bcb0001,0x18a4005e}},	//   _सेवा, wany, _дуго_, каєм
  { {0xf3880092,0x76430375,0x69c50030,0xb8d7000b}},	//   _nợ_, tany, szhe, _चक_
  { {0xbb3a000f,0x7d0d0d30,0x2f5c000a,0xddde0085}},	//   _מעשי, lmas, קדונ, _hapš
  { {0x76430d31,0x04b50033,0xc6a4006b,0x6d480091}},	//   rany, еспя, ърци, šdav
  { {0x7d0d01e2,0xd7c90015,0x76430cc4,0x9fa000aa}},	//   nmas, _فوزه_, sany, _wéér_
  { {0x37550086,0xd8280033,0x76430d32,0x6d5c0d33}},	//   _سپاس, _ціск_, pany, zura
  { {0x1306005f,0x96bb0040,0x7d0d0d34,0x6d5c0d35}},	//   нный_, _بارز_, hmas, yura
  { {0xd12e0086,0xe1f90010,0x7d0d048b,0xd2f6002b}},	//   یمی_, яго_, kmas, رکها_
  { {0x3cfb005d,0xd36e0086,0xf9920632,0x2ec8005d}},	//   ्षों_, جهی_, ארט_, रफ्त
  { {0x76410091,0x7e7c0d36,0x7d0d0d37,0xa85a004f}},	//   _kely, terp, dmas, הדרכ
  { {0x83fd00dc,0x3ebe002e,0x7288005e,0x91e5072d}},	//   ggőe, ótt_, _обіг_, _поле
  { {0xc5f200b2,0x76410d38,0x224500bc,0x27fa002a}},	//   ָדן_, _mely, malk_, ępni_
  { {0x301a0015,0x7eb00012,0xdb070046,0x6d5c0d39}},	//   _عتبة_, _päps, ělýc, rura
  { {0x245a0064,0x207b004c,0x5f930015,0x6d5c0d3a}},	// [11a0] lümü_, _זאפא, _مليئ, sura
  { {0xb05b08e9,0x6d5c0d3b,0x160f000b,0x76410091}},	//   nhän, pura, ाधार_, _nely
  { {0xcee90074,0x245a0064,0x2e3b000a,0xe947002b}},	//   _ترين_, nümü_, _מגינ, فرنی
  { {0x7eb00005,0xe8f6002b,0x645c0030,0x0d830d3c}},	//   _täps, رساخ, őriz, _слюн
  { {0x8c1b000a,0xbc1b000a,0x20d200bc,0x76410d3d}},	//   _מוכי, _מוכש, jšim_, _bely
  { {0x46a30033,0x76410034,0x9af60015,0x45d40d3e}},	//   лачв, _cely, _أكست, колс
  { {0xceb30008,0xf3880092,0x76410026,0x09e6005e}},	//   ריו_, _sợ_, _dely, _човн
  { {0x69c10020,0xd3a60294,0x75210077,0xa5d700c3}},	//   _ülea, ероп, _dulz, عبور_
  { {0x8c1b0008,0x76410034,0xb05b0012,0x0000006a}},	//   הופי, _fely, fhän,
  { {0x76410d3f,0xf3880092,0x7d0d0d40,0xc1ea01c6}},	//   _gely, _vợ_, zmas, зьме_
  { {0x83fd00dc,0x7d0d0d41,0xfb17004c,0x25a10012}},	//   ggőb, ymas, ײַזט_, ählt_
  { {0x254c0089,0x31c30033,0x59c2000b,0x61f80046}},	//   měl_, усьв, वैयर, _vyvl
  { {0x2245049c,0xb05b00b8,0x5f940063,0xe0df04ed}},	//   balk_, bhän, гият, rnò_
  { {0x539b00a3,0x245a0061,0x7f5d0003,0x0000006a}},	//   _מידו, bümü_, rusq,
  { {0x3f84001a,0x254c0046,0x7d0d0d42,0x626300af}},	//   æmur_, něl_, tmas, _свја
  { {0xccf80001,0x01fb000a,0x628a0034,0x7d0d0d43}},	//   ећу_, _מפול, _hafo, umas
  { {0x7d0d0d44,0x7e2b00e2,0x60d8000a,0x3ea50030}},	// [11b0] rmas, _ніна_, _רוחא_, ölts_
  { {0x7e650012,0x2b490003,0x7d0d0d45,0x0000006a}},	//   _uchp, rsac_, smas,
  { {0x7d0d0064,0x764100da,0xd99900c3,0x6d480d46}},	//   pmas, _rely, بنات_, ádat
  { {0x254c0089,0xb9540015,0x628a0529,0xc052004f}},	//   děl_, ائلت, _lafo, ֹ֖א_
  { {0x81bc0024,0x245a0061,0x2eab000a,0x76410d47}},	//   ucēj, zümü_, ּשֶּ, _pely
  { {0x8bd6000a,0x81bc003d,0x20d20085,0x2ca9060a}},	//   _יורו_, rcēj, všim_, ljad_
  { {0xb5c20036,0x81bc003d,0xd5e5009b,0x2f0402dc}},	//   ийшл, scēj, ъжки, nöga_
  { {0x69cc002c,0x6442002d,0x76410034,0x3af40123}},	//   ôlež, _ceoi, _wely, läpp_
  { {0xe3b10029,0x99980011,0x13090142,0x76410034}},	//   شرة_, _terţ_, мний_, _tely
  { {0x628a0176,0x7eb00604,0x2ca9007c,0x4225006b}},	//   _cafo, _näpp, hjad_, ъдов
  { {0xd7020010,0x2258002a,0x628a0034,0x8368002b}},	//   _лiта, órka_, _dafo, وصیف_
  { {0x245a0064,0xe3b00086,0x3cc6000b,0xe5080015}},	//   rümü_, _گرم_, रोफ़ा, _كيلو_
  { {0xb05b0400,0x22950029,0x22450d48,0x52850015}},	//   mhäl, _للإس, palk_, _للشك
  { {0x628a0176,0x79820050,0xe3b00086,0xe195004a}},	//   _gafo, łowi, _درم_, _ариэ
  { {0xb05b00b8,0xbea30180,0xdd920015,0x6cd60015}},	//   chäo, шарк, جوز_, نقسا
  { {0x248d0d49,0xb05b0d4a,0xa3e5000b,0x1fb60d4b}},	//   ndem_, nhäl, _नशा_, _асор
  { {0x248d0046,0x8fa6067a,0x0000006a,0x0000006a}},	// [11c0] idem_, _рапе,   ,
  { {0x248d0012,0x6a1600c3,0x63a60123,0x3ced0b28}},	//   hdem_, نبار, äkni, čeva_
  { {0xae570008,0x19b90010,0x1e57000a,0x7d0a0054}},	//   _בסיס_, нуць_, _בשיר_, _оног_
  { {0x38cb0086,0x7995005c,0x248d03cd,0x254c0046}},	//   وانی_, _drzw, jdem_, věl_
  { {0x248d0026,0x23d0005d,0x79950012,0x9cd7000a}},	//   ddem_, _तेंद, _erzw, _יוטה_
  { {0x254c0089,0x6442002d,0x98a7003d,0x645c0091}},	//   těl_, _seoi, īnā_, ėrim
  { {0xa01b00dc,0xd943004a,0xe9a30d4c,0x87e1002b}},	//   ldöt, _веси, _карп, _ﻳا_
  { {0x628a0176,0xb8660087,0xa4f8002b,0xd4670054}},	//   _safo, _جاسو, رکار_, виће_
  { {0x2c6d0014,0xd3a30010,0xaa82002e,0xa7660010}},	//   lódó_, арэп, _þýsk, _шкад
  { {0x254c0046,0x68e20d4d,0x0cde0065,0xe73700ce}},	//   pěl_, lnod, नचुम, _реф_
  { {0x4a5b000a,0x64420d4e,0xe3af002b,0xe1d4005e}},	//   ודיו, _teoi, مری_, ужнь
  { {0xd5d90053,0x68e20d4f,0xe3ba0164,0x138a0015}},	//   _אַנש, nnod, _обе_, _يخشى_
  { {0xe7030023,0x35a8005d,0xc4cf0015,0x628a0034}},	//   _hướ, _कपड़, _بْن_, _tafo
  { {0x11d60029,0x7a480024,0x9f34005e,0x6b840d50}},	//   _لتعد, nūtē, рері, dwig
  { {0x2ca90020,0xf27b000a,0xb05b0123,0x51f3002b}},	//   tjad_, _חרוש, lhäm, _پسور
  { {0x20d200bd,0x0217000a,0xa26300a1,0x68e2013b}},	//   jših_, _בחום_, _luồ, jnod
  { {0x3a750080,0x68e204af,0x9b450086,0x2ca9038a}},	// [11d0] ллар, dnod, انطو, rjad_
  { {0x2ca9007c,0x7a540015,0x6a340054,0xda6700c3}},	//   sjad_, لضما, инуђ, ضائي
  { {0x68e20176,0x68e302c1,0xe7030092,0x6b84005c}},	//   fnod, éndo, _nướ, awig
  { {0xc8640054,0x236d002a,0x0cd4030c,0x0000006a}},	//   атљи, ytej_, _воюю,
  { {0xdcb10023,0x27e90061,0xe9ff0016,0x97c70015}},	//   ểu_, çan_, _trắc_, ختام
  { {0xe7030023,0xda340010,0x7d1d0d51,0x20d202c6}},	//   _bướ, _веры, _hiss, aših_
  { {0xb05b00b8,0x451903fc,0x248d00b8,0x06960015}},	//   thäl, нция_, tdem_, طنية_
  { {0xe7030023,0x05760029,0xf5760015,0xdb1e0107}},	//   _dướ, امية_, اميع_, _švéd
  { {0xb05b00b8,0x7d1d0d52,0x248d0d53,0x93950015}},	//   rhäl, _miss, rdem_, اجبا
  { {0x7c2d00da,0x27e00125,0x236d0d54,0xe979000a}},	//   hcar, úine_, rtej_, ֲנָש
  { {0x291e038d,0x92590086,0x01650080,0x236d0d55}},	//   _état_, وشگر_, ыкно, stej_
  { {0xd5ba0053,0x2f04002e,0x6b8400aa,0x853a000a}},	//   _אזעל, gögn_, ywig, _נגני
  { {0xe28e0d56,0xddc70030,0x442d0d57,0x2c6d0030}},	//   _ла_, dejű, mce_, zódó_
  { {0x6449002d,0x442d07ca,0x7c2d0049,0x68e20d54}},	//   laei, lce_, ecar, znod
  { {0x628104f9,0x5de60063,0x68e20026,0x8db50036}},	//   melo, ужва, ynod, асті
  { {0x62810d58,0x27e9002a,0x442d0d59,0x7d030058}},	//   lelo, żany_, nce_, مِّه
  { {0xdcf70087,0x69030020,0x442d0d5a,0x20d20085}},	// [11e0] افقت_, tõen, ice_, vših_
  { {0x7f3b0008,0xc3320008,0xee3a0010,0xdd040064}},	//   _רעיו, צוב_, _яно_, ırır
  { {0x2d960292,0x442d0089,0x68e2049c,0x497a0010}},	//   _српс, kce_, tnod, эсаў_
  { {0xccfa0036,0xdca60d5b,0x7c2d0d5c,0xb7d7002b}},	//   _їхні_, _сами, ccar, گوها_
  { {0x38c80086,0x60c4003f,0x68e20d5d,0x62810d5e}},	//   _یاری_, _mlim, rnod, kelo
  { {0xaf770053,0x6d5c0d5f,0x62810d60,0x442d0d61}},	//   רעסס_, orra, jelo, ece_
  { {0x62810d62,0xf1a70015,0xcad7015b,0x7aeb0030}},	//   delo, _اء_, _עולת_, égte
  { {0x6f1e005c,0x4498004a,0xc35402d9,0x29070144}},	//   _lipc, твию_, акиј, ïnat_
  { {0xb4e4021e,0x6d5c0012,0x6906003d,0x68b7000a}},	//   _नदी_, hrra, ārdē, _עלמא_
  { {0x38660026,0x03770086,0x26c70d63,0x6c1b000a}},	//   lgor_, احيت_, chno_, עֵהו
  { {0x764a001a,0xa697000a,0x442d0d64,0x7c2d0d65}},	//   mafy, _תכבה_, bce_, ycar
  { {0x442d04ed,0x38660d66,0x60c40d67,0x62810034}},	//   cce_, ngor_, _clim, aelo
  { {0x2d9e02d2,0xb4c0000b,0x62810d68,0xd8d7004c}},	//   åten_, ँसी_, belo, רוכט_
  { {0x7d1d0005,0x38660026,0x62810d69,0x2f04001a}},	//   _siss, hgor_, celo, sögn_
  { {0x7c2d0298,0xd1300086,0xc6b7000a,0xd578000a}},	//   tcar, _بمب_, נהלי_, כָּר
  { {0xd1380007,0x28b9000b,0xed58006f,0xf047004a}},	//   mpą_, _आवधि, áľa_, _сэко
  { {0x4bdb0086,0x7d1d0d6a,0x7c2d0d6b,0x6d5c0d6c}},	// [11f0] ربرد_, _viss, rcar, arra
  { {0x6e670001,0x442d0d6d,0x7c2d03b0,0x7d1d0d6e}},	//   _стиж, zce_, scar, _wiss
  { {0x60c400f2,0xaae80036,0x7d1d0d6f,0xda780033}},	//   _ylim, уєте_, _tiss, ыят_
  { {0x69c10020,0x7f5d0152,0xdd3a000a,0x62810319}},	//   _ülem, orsq, _שערכ, zelo
  { {0xa8480015,0xa3d3000b,0x442d0d70,0x07a50718}},	//   الهم_, _हें_, vce_, ралн
  { {0x05550063,0x442d005c,0x62810d71,0x3869002a}},	//   атия, wce_, xelo, żar_
  { {0x442d037f,0x8aa8000a,0x62810090,0x8989000a}},	//   tce_, _עֹשֶ, velo, _בָּ֔
  { {0x47350956,0x62810d72,0xed640057,0xd5ae0015}},	//   _внас, welo, leží_, ظفي_
  { {0x56670002,0xe73000e5,0x62810d73,0x442d0d74}},	//   _مداف, _فصل_, telo, rce_
  { {0x6d5c0d75,0x442d0d76,0xd7740015,0x60c40d77}},	//   yrra, sce_, _دافع, _slim
  { {0xfad60008,0x62810d78,0x869a000a,0x4206006b}},	//   שותך_, relo, _שיעז, иньо_
  { {0x6563001c,0x8235002b,0x272b02de,0x62810d79}},	//   munh, درکا, _køn_, selo
  { {0x20c20125,0x6f630342,0x5f060d7a,0x62810d7b}},	//   _fóin_, овяз, изма, pelo
  { {0xed5a0124,0x6d4e020a,0x82370029,0x68e90085}},	//   ког_, tsba, _إرشا, _ljed
  { {0x68fb0064,0x272b02de,0x66c6001a,0x68e90d7c}},	//   _okud, _løn_, _uðke, _ojed
  { {0xdcfc016f,0x60c4003f,0x27ff0061,0x63bb0061}},	//   tvrđ, _ulim, _oyun_, oyun
  { {0x69c10020,0x3f8c0024,0x1eca0001,0x1efa0015}},	// [1200] _ülej, ādus_, _алпи_, _لعدة_
  { {0xcfb70008,0x3c190010,0x19960001,0x63a90251}},	//   _כלפי_, уўся_, ијер, ixen
  { {0xae5b000a,0x0e5b000a,0x7bcd003d,0x3e5b000a}},	//   _בכיר, _בדיב, azau, _בדיס
  { {0x26c504ed,0xe73a0d7d,0xdddc0d7e,0x22470073}},	//   _allo_, вед_, održ, _lenk_
  { {0x16340063,0xf1ba0016,0x9077000a,0xed64006f}},	//   беля, _ngơn_, שענא_, beží_
  { {0xafdb0134,0x68e902de,0x46d0000b,0x66e3006b}},	//   sbøg, _ejed, थोंह, ооча
  { {0x09fa0029,0x20d2002c,0x8a7b000a,0x45470033}},	//   _شفرة_, lšiu_, _שאלת, ачым_
  { {0x26c502c1,0xd4970080,0x4422003c,0x7982002a}},	//   _ello_, арь_, øk_, łows
  { {0xdc89000a,0x185b000a,0x82a60d7f,0x20d2006f}},	//   רְצָ, _שכמע, ашне, nšiu_
  { {0x291f04f9,0xc8850064,0xb2730139,0x9f4f0003}},	//   _ziua_, arşı_, ольш, _âgé_
  { {0x21630036,0x63bb0035,0xe1d80036,0x3abb0135}},	//   отяг, ayun, удні_, דמינ
  { {0xddc50089,0xc5f3000a,0x55bb000a,0xd1380091}},	//   _schů, _ודע_, _שמאו, rpą_
  { {0xa294008f,0x7648032c,0x20d2002c,0x251b0135}},	//   _галі, _kedy, jšiu_, _סודא
  { {0x76480050,0x7b1000b8,0x0ea7000b,0x92f30015}},	//   _jedy, läuf, खाधड, _وأوض
  { {0xc5340008,0xdddc0d80,0x76480d81,0xec6b0004}},	//   מָּה_, adrž, _medy, крак_
  { {0xc05b0191,0x26dc02c1,0x50d40031,0x718b000a}},	//   _рік_, hivo_, _وزير, _יְחַ
  { {0x75280050,0x2bba005c,0xc334000a,0x89d9002b}},	// [1210] _ludz, jącą_, מוּ_, گوار_
  { {0x69c10020,0x68e906e6,0x26dc02c6,0x7b100012}},	//   _ülek, _sjed, jivo_, häuf
  { {0xc8ab0063,0x272b0595,0x99d90015,0x7bcd0030}},	//   къде_, _søn_, دواء_, szau
  { {0xf771003b,0x19580033,0x67550015,0x38c9002b}},	//   كات_, рацы_, مختر, دائی_
  { {0x2bde005d,0x76480034,0x83fd0030,0x7528003d}},	//   _नेपा, _bedy, ggől, _audz
  { {0xd00c000a,0x752809bb,0xf770006e,0x8c1a000a}},	//   כּוֹ, _budz, ظان_, _תושי
  { {0xcb120008,0x78570086,0x68e9016f,0x22470064}},	//   _מלך_, _نیاز_, _tjed, _renk_
  { {0x68e90d82,0x15b80033,0x20d20046,0xe5760174}},	//   _ujed, рышы_, nšit_, ёзы_
  { {0x27ff0061,0x764800e7,0x60dd0d83,0x0000006a}},	//   _uyun_, _fedy, dism,
  { {0xfbd20008,0x6563016e,0x0574002b,0x60dd0d84}},	//   פתי_, punh, _ژاند, eism
  { {0x63bb0035,0x20c2002d,0x75280d85,0x7a88000a}},	//   syun, _fóil_, _gudz, בָרַ
  { {0x397a013a,0x297a0632,0xa8790053,0x224700dd}},	//   נטרנ, נטרא, נאָר, _wenk_
  { {0x660100f2,0x80aa005d,0x443f0d86,0x20d20085}},	//   _hylk, टाबे, mbu_, dšit_
  { {0x2418005e,0x20d2006f,0x7d180030,0x13040033}},	//   _тією_, všiu_, _évsz, _дзім
  { {0x71960074,0xdca60d87,0xa135002b,0x2d950d88}},	//   _هنوز_, бави, _ارتش, ортс
  { {0x386d01c2,0x9c260004,0x70560067,0xc5f2000a}},	//   _ncer_, сдад, _انظا, פדן_
  { {0x443f0d89,0x2d840046,0x1d070719,0xbf660015}},	// [1220] ibu_, ňme_, сети_, _ادعو
  { {0x8e860029,0x20d2006f,0x9e660d8a,0x386d0d8b}},	//   _الده, ršiu_, _увод, _acer_
  { {0xceb7000a,0x91fc003d,0xf8b9000b,0x499a055f}},	//   _הפיק_, egāj, _आवशय, ытая_
  { {0x20d2002c,0x61fc0012,0x77ca004a,0x443f00b3}},	//   pšiu_, ürli, ллег_, jbu_
  { {0x4b550063,0x67210d8c,0xc053015b,0x26dc0d8d}},	//   _мърт, _bilj, לזא_, tivo_
  { {0x6721065d,0x7d040d8e,0x386d00d9,0xcf93000a}},	//   _cilj, llis, _ecer_, פטו_
  { {0xb05b0d8f,0x26dc0d90,0x67210085,0x76480d91}},	//   mhäv, rivo_, _dilj, _vedy
  { {0x39570008,0x76480026,0x2d980d92,0x54b800a4}},	//   _לשלם_, _wedy, ivre_, ргия_
  { {0x47c6000d,0x7d040d93,0xfa6a000a,0x6cab000a}},	//   _убав, ilis, ְכֹּ, אֹיְ
  { {0x52d80036,0x0bb7000a,0x66010d94,0xfbb7000a}},	//   рмою_, צלים_, _fylk, צפית_
  { {0x8afb0135,0x7a8b000a,0x60dd0d95,0x7d040d96}},	//   רפיק, אָכַ, tism, klis
  { {0xef260061,0xe019005e,0x9f990248,0xa98b004f}},	//   ğüne_, ижні_, авму_, נָיִ
  { {0x833a0080,0x6d5a002c,0xe6c4002e,0x9e4b0011}},	//   _счет_, átan, _þjóð, ţămâ
  { {0x7d16002c,0x4357000a,0x7d040d97,0xf1a60724}},	//   emys, _פסול_, elis, _грин
  { {0xb6bb0008,0x6d5a0d98,0x60dd0d99,0xc0d50015}},	//   נצלי, štan, pism, _ويتب
  { {0xd9040074,0x9c3905c0,0x7d040d9a,0x69c1007c}},	//   _سی_, рпат_, glis, _ülei
  { {0x88bd005c,0x2d8c0134,0x5c070d9b,0x8cda000b}},	// [1230] _liśc, æder_, сява, _नगरो
  { {0x6bd40015,0x61ff0030,0x443f06ca,0x9be4005e}},	//   ستقر, _ízlé, zbu_, чіск
  { {0x20d20089,0x18370029,0x3ebe0d9c,0x7d040d9d}},	//   pšit_, مرشح, ötte_, blis
  { {0x44260d9e,0x7d040d9f,0x77990a24,0xe84b009a}},	//   _ngo_, clis, икер_, اجان_
  { {0xd3660067,0x67290077,0xdddc0045,0x68f900da}},	//   _ته_, _quej, perţ, rowd
  { {0xe80f005d,0x77840010,0x98aa0024,0x91fc003d}},	//   ़ेगा_, яліз, ājām_, rgāj
  { {0x03190086,0x443f04af,0x67210da0,0x5fe0000b}},	//   یتخت_, tbu_, _vilj, _पेनल
  { {0xe5760033,0x0000006a,0x0000006a,0x0000006a}},	//   ізы_,   ,   ,
  { {0x7b1000b8,0xe795002b,0xe0df02b9,0xb05b0012}},	//   bäud, _بازک, diò_, nhäu
  { {0x66010050,0x799c0034,0x798e0034,0x44260da1}},	//   _tylk, _yrrw, _ysbw, _ego_
  { {0xd2980033,0x7d040da2,0x7b100012,0x7d160da3}},	//   стыі_, ylis, säug, ymys
  { {0xcea900f3,0xc9520135,0x2eb4000b,0xb05b008c}},	//   _בי_, ומט_, ुस्त, tkäa
  { {0x7d040061,0xc2c50015,0x78fa000a,0x02d50058}},	//   vlis, _ويصي, שפרו, _وتتخ
  { {0x61450da4,0x7f750033,0x316504b2,0x0000006a}},	//   _дека, чуюц, pulz_,
  { {0x7e23000d,0x644b013c,0xc8b9000b,0x2d980da5}},	//   ддрж, _kegi, _आवंट, uvre_
  { {0xe0df02b9,0x691102de,0x1bea0b1e,0xb05b0b1f}},	//   ciò_, nåed, адби_, lkän
  { {0x7d04017e,0x8b260191,0xeb970da6,0xec35002b}},	// [1240] rlis, ідже, оит_, سولگ
  { {0xda660029,0xda650029,0x7d160046,0xb05b0da7}},	//   تاري, كامي, smys, nkän
  { {0x64590050,0xe9da0001,0x984a0033,0x7d040da8}},	//   _odwi, јке_, аяла_, plis
  { {0xb17a0053,0xa17a0053,0xa8a3009c,0xe8fa0da9}},	//   יטער, יטעט, дршк, шле_
  { {0xb05b0400,0xf76f0021,0x4733002b,0x16340daa}},	//   phäv, ناو_, وروز, пеля
  { {0x8f9b0dab,0xd7f90036,0xe0df04ed,0xbf9b01ac}},	//   ייני, щує_, ziò_, יינש
  { {0xb05b01d1,0x2bde005d,0xe5a30001,0xceb3000a}},	//   dkän, _नेता, дији, ויג_
  { {0xc4f70015,0x644b0dac,0x64400dad,0x186708a0}},	//   يعيا_, _cegi, ubmi, _маси_
  { {0xe0df02b9,0x83fd0030,0x644b0dae,0xa6e60daf}},	//   viò_, ngőh, _degi, _джал
  { {0xa2a7005d,0x3ce00020,0xd3770010,0xe6c60015}},	//   फ़ॉल्, hiiv_, ічы_, _بتري
  { {0x27300092,0x644b0144,0x75d600c3,0xc4c60015}},	//   _hàn_, _fegi, _بيضا, _وتصو
  { {0xa3460010,0x6ab7005d,0x44260db0,0x7fb90015}},	//   _дэкл, _आक्र, _ugo_, مهجر_
  { {0x69c10020,0x6d5a0db1,0xd36f0015,0x39470030}},	//   _ülev, štal, _لهن_, ánsz_
  { {0x20050048,0x27300092,0xdefb0256,0x3f8b002a}},	//   āli_, _màn_, рым_, rwcu_
  { {0x27300092,0xdd940010,0x853c0091,0xc8bc000b}},	//   _làn_, мары, _drėg, ्घाट
  { {0x5ce70036,0xe9ab002b,0x27300016,0x75350030}},	//   іюва, یدان_, _oàn_, _ézze
  { {0x60c00db2,0x10170015,0xe451000a,0x27300016}},	// [1250] ömme, _ببغد, גֶב_, _nàn_
  { {0x501c0008,0x7f840086,0xb4c7000b,0xb05b0012}},	//   _דוחו, _کلین, _उत्_, rhäu
  { {0xdc3f099c,0x41ca005d,0x62880db3,0xb05b0012}},	//   líčk, ानिस, iedo, shäu
  { {0x27300092,0xb17b0053,0xf8b10086,0x26f5005d}},	//   _bàn_, שטאר, رکز_, ेत्र_
  { {0x6d550014,0xa7870029,0xa3da000b,0xdc3f013f}},	//   lsza, تشاو, _डेल_, níčk
  { {0x853c0007,0x644b0ac1,0x628806cf,0xf1ca000b}},	//   _orėd, _segi, jedo, ानान
  { {0x6e35005c,0x645d0007,0x62880db4,0x19580033}},	//   iczb, ųsim, dedo, _мары_
  { {0x28f80036,0x6d5506cd,0xed17004f,0x33d500ce}},	//   _десь_, isza, חַ֖ת_, зіот
  { {0xf41f00f2,0xf773002b,0x644b0db5,0x6b8d0db6}},	//   ää_, _تاز_, _vegi, nwag
  { {0xeb920008,0x65950db7,0xe1610033,0xb5950a32}},	//   תָה_, _назу, нямi_, _низш
  { {0x644b0db8,0xb05b0b1f,0xd24e002b,0x6b8d01f1}},	//   _tegi, rkän, اچه_, hwag
  { {0xb05b0123,0x69c1007c,0xef260061,0x0000006a}},	//   skän, _üleu, şüme_,
  { {0x20040084,0x21b80086,0x6d55002a,0x68eb0db9}},	//   æmi_, مپیک_, esza, ingd
  { {0x539a01ac,0x141a004c,0x6d5a0dba,0x62880d67}},	//   _לינו, _פוסב, štam, cedo
  { {0x2d9e0156,0x6d5500dc,0x3ce0007c,0x6da30719}},	//   íte_, gsza, tiiv_, нира
  { {0x91ba0008,0x6b8d086c,0xb05b07c2,0xdc3f00bf}},	//   _למצי, fwag, nkäl, bíčk
  { {0xab6602c5,0xb05b008c,0x0efa0033,0x6b8d0dbb}},	// [1260] явал, ikäl, _гэны_, gwag
  { {0x0e66005f,0xff240086,0x3f920035,0x9f9b0008}},	//   _экон, _تبعی, _isyu_, _פסיפ
  { {0xdebb0008,0x3ebb0008,0x27300016,0x7b100012}},	//   _המיל, _הציב, _sàn_, täub
  { {0x186a09ac,0xba170015,0x62880dbc,0xeb9f0013}},	//   сади_, سينا_, zedo, _frø_
  { {0x47330036,0x4c9b0008,0x65630012,0xdc9b000a}},	//   еніс, _הבכו, ernh, _היכל
  { {0x99640089,0x29060020,0x6beb05bd,0x3739005e}},	//   může_, sloa_, _הַלַ, іччю_
  { {0xb0cc000b,0x65930015,0xe1e70015,0x673b008c}},	//   ासाग, فجير, _أس_, _etuj
  { {0x62880176,0x27300092,0x77620bf5,0xdc3a005e}},	//   wedo, _tàn_, prox, ацiї_
  { {0x2f04001a,0x6d55002a,0x6288092c,0x0000006a}},	//   lögu_, zsza, tedo,
  { {0x86ea0029,0x68e20026,0x6d55005c,0xd250002b}},	//   _اعرف_, liod, ysza, خند_
  { {0x6d5a010b,0x69c10020,0xd6cf0029,0x6a9b0053}},	//   štaj, _ület, _حقل_, זשינ
  { {0xeafa005d,0x68e209bf,0x62880dbd,0x2347002b}},	//   ्तुत_, niod, sedo, _کلوپ_
  { {0xa4b70008,0x04430a61,0xc4d3000a,0x78fb000a}},	//   _מלאה_, _чечн, _אגף_, מפטו
  { {0x68e20026,0x0eeb00f4,0x6d550dbe,0x43e50015}},	//   hiod, сьми_, tsza, _تأمّ
  { {0xf29701d8,0x127b004c,0xdcfe0046,0x68eb0034}},	//   _זכור_, _לאגע, _uspě, yngd
  { {0x6d550dbf,0x27f2005c,0x1cbb0015,0xf1ba0016}},	//   rsza, żyny_, حاسب_, _ngơi_
  { {0x6d5503c0,0x46be000b,0x68e20dc0,0xfc300021}},	// [1270] ssza, ्साह, diod, احف_
  { {0xb05b0012,0x88bd002a,0xc1780091,0x6b8d0009}},	//   chär, _ciśn, otė_, rwag
  { {0xc1780007,0xceb20053,0x68e20034,0x60cd0dc1}},	//   ntė_, _סיט_, fiod, _klam
  { {0xa3cc005d,0xa3be005d,0xfd56000a,0x7c670015}},	//   रना_, ीना_, _קשרי_, _عاجل
  { {0x69d8002e,0x205800a3,0x4c9a000a,0x96f9002b}},	//   úver, ליאל_, _וברו, يعتر_
  { {0x60cd0dc2,0xf7700015,0x25570045,0x7b100012}},	//   _llam, طاه_, tăl_, räuc
  { {0x60cd0064,0xf6500002,0xae5c000a,0xb05b0dc3}},	//   _olam, ائه_, זכור, tkäl
  { {0xe894008f,0x68e20011,0x2ee30111,0xf992000a}},	//   _пась, ciod, hijf_, _ברל_
  { {0xd7020010,0xc1780007,0x13a7002b,0xd3be004a}},	//   _кiра, etė_, سندی_, а́ть
  { {0x66cf06f5,0x69c10005,0x13060080,0x78bb0dc4}},	//   _bøke, _üles, мный_, _houv
  { {0x60cd003e,0x208a0063,0xca36000a,0xf674002b}},	//   _blam, ойни_, ונתה_, _سالخ
  { {0xafe60191,0xd00a000d,0x55580010,0xd36e0086}},	//   домл, жеме_, _хаця_, دهی_
  { {0x78bb0152,0x92b50029,0x3438002b,0xa856000a}},	//   _mouv, _يحتا, _رسند_, וירה_
  { {0x60cd0020,0xf412000a,0x78bb0dc5,0xa01b02dc}},	//   _elam, _ספג_, _louv, dföd
  { {0x60cd010c,0x78a90079,0xb05b0b14,0x90e60058}},	//   _flam, _onev, rhär, _يسعن
  { {0x78bb038d,0x80f60015,0x7c850054,0x60cd0dc6}},	//   _nouv, _تستض, нуђе, _glam
  { {0xa2d4005d,0x9f1a0015,0x95e9000b,0x32070034}},	// [1280] योक्, _وآخر_, टपुट_, _hyny_
  { {0x68e2005c,0x273b0011,0xba6a0015,0xd94607d9}},	//   wiod, _mână_, تحرك_, дежи
  { {0xdce90064,0x2d9c00dc,0x02fa004c,0x2241007c}},	//   _çoğu, _éve_, קלעמ, _õhku_
  { {0x78bb0152,0x588304ab,0x88bd002a,0xe7860c91}},	//   _couv, выша, _wiśn, дуко
  { {0x78a9065d,0x69030020,0xd5af0086,0xba560063}},	//   _dnev, võet, یفه_, _отвъ
  { {0x68e20dc7,0x6ea7000b,0x46a3006b,0x85ba0015}},	//   siod, खाएँ, качв, قاعس_
  { {0x78660015,0x68e200a6,0xf6000138,0x0000006a}},	//   _يدرك, piod, ымкi_,
  { {0x78bb0dc8,0x6abc001a,0x051700c3,0xe3c40015}},	//   _gouv, _horf, وزيع_, فْعَ
  { {0x66cf0c83,0x69c10020,0x25de000b,0x128a006b}},	//   _søke, _üler, _केरी_, ощни_
  { {0xc17a0036,0x76a60015,0x60cd0dc9,0xf7d7015b}},	//   оїм_, _تحرك, _slam, _חומש_
  { {0xa2d4000b,0xba9b000a,0xd6250015,0xb05b0dca}},	//   योग्, קסטי, _كعمي, skäm
  { {0xd4c60029,0xe4a50036,0xc1780007,0xc4c60015}},	//   _تغطي, _пріо, rtė_, _تتطو
  { {0xc1780007,0xe8f10008,0x351b0053,0x60cd0079}},	//   stė_, אֻם_, _וואנ, _vlam
  { {0x32070176,0xd3b70036,0xc2c40015,0x63a20dcb}},	//   _fyny_, _юлії_, _سيعي, _iron
  { {0x27fa005c,0x12fb0008,0x2ee30079,0x63a20dcc}},	//   ępny_, _והגב, rijf_, _hron
  { {0x6ee9016f,0x629a0409,0x62980c0a,0x9597000a}},	//   džbe, ldto, _havo, וכלו_
  { {0xa2a7000b,0x5b150137,0x660801de,0x62980091}},	// [1290] फ़ॉक्, емат, _lydk, _kavo
  { {0x6abc0026,0x29040035,0x78bb0dcd,0x0377000a}},	//   _corf, _akma_, _souv, ותמת_
  { {0x78bb038d,0x2d9e00c0,0x6abc00b8,0x6eff0089}},	//   _pouv, åtet_, _dorf, rábě
  { {0x629802d7,0xc052000a,0x200901d7,0x394100da}},	//   _lavo, ָ֖א_, _kyai_, rphs_
  { {0x28080015,0xe758005e,0x57480033,0x6abc0dce}},	//   وْمَ_, дичі_, дзім_, _forf
  { {0x6abc0176,0x66cf003c,0x62980dcf,0x3f4d003d}},	//   _gorf, _søkb, _navo, ižu_
  { {0xd5b10031,0x66360015,0x89340058,0x63a20dd0}},	//   افع_, ركيس_, _لعقا, _aron
  { {0x273b04f9,0xb9250029,0x78a900da,0x7ae5007c}},	//   _până_, _أفري, _unev, liht
  { {0x13e90036,0xf7700015,0x63a20dd1,0x32070dd2}},	//   ямий_, _نال_, _cron, _syny_
  { {0x7dee00dc,0x99980091,0x6d5a0091,0xf7700015}},	//   nősé, _gerų_, štai, _خاف_
  { {0x629800b8,0x13a7002b,0x2012002a,0x05740015}},	//   _davo, سنگی_, _szyi_, _لاند
  { {0x0ef8005d,0xe0d20086,0xf9da0053,0xd59a000a}},	//   ंक्स_, ازد_, פֿיל, _מבעל
  { {0x316c0024,0x62980dd3,0xcf3a005e,0x7ae5007c}},	//   audz_, _favo, ячні_, kiht
  { {0x62980007,0xe3b00086,0x248d0dd4,0x0000006a}},	//   _gavo, _خرم_, leem_,
  { {0xddc10036,0xdd92012c,0x3f4d0dd5,0x11d70058}},	//   аттi_, دوز_, ažu_, _تتشد
  { {0x248d00dd,0x91fc0024,0x8b660015,0x11da000a}},	//   neem_, rgāt, فاطم, _מחצב
  { {0xc4d20053,0x4c350033,0x6abd0065,0x6abc0dd6}},	// [12a0] אגן_, тэст, ोसूर, _porf
  { {0x89f60010,0x19f60180,0x88bd002a,0x9f7b000a}},	//   няец, нџер, _wiśl, _צניח
  { {0xa84a0029,0x19b90033,0x91fc003d,0x6abc0dd7}},	//   كلام_, муць_, lgār, _vorf
  { {0x7ae500f2,0xa2a10231,0x0000006a,0x0000006a}},	//   aiht, _कोस्,   ,
  { {0x66e60dd8,0x07a3005e,0x62830dd9,0x68430054}},	//   нода, лацн, _obno, унча
  { {0x69c500aa,0xb05b008c,0xda650015,0x0000006a}},	//   byhe, tkäk, _لافي,
  { {0x6728010b,0x69c1007c,0xf5260766,0x0000006a}},	//   _vidj, _ülep, нфин,
  { {0x62980dda,0x63a20ddb,0x692c0045,0xb7da0015}},	//   _savo, _pron, _eşec, _فوزا_
  { {0xe3b20115,0x62980ddc,0x53e60033,0x34370067}},	//   ارع_, _pavo, эцка, رسيد_
  { {0x629a02de,0xeb91000a,0x63a20ddd,0x0000006a}},	//   udto, בָט_, _vron,
  { {0x64a60010,0xb0cc005d,0x63a20dde,0x21670004}},	//   _пажа, ासंग, _wron, ниќи_
  { {0x63a200a7,0x45b7000a,0x34560015,0x3cfa000b}},	//   _tron, _רפאל_, _أنشأ, ंवों_
  { {0xd8db0008,0x62980ddf,0xbfa80bb9,0x09dd021e}},	//   לקטר, _tavo, нтре_, _मध्य
  { {0xb3e90029,0x7982005c,0x61eb00dc,0x8413005e}},	//   _تعمل_, łowy, állá, _сміх
  { {0xe29b0135,0x7ae500bc,0xa19401b7,0x7d090015}},	//   _זשור, viht, _райч, ِيزِ_
  { {0xb05b00f2,0x88bd002a,0x2f1602de,0x1c890015}},	//   kkäi, _piśm, væge_, بَرٌ_
  { {0x7dee0014,0xea670124,0x1b780029,0x9ee90029}},	// [12b0] tősé, ењен, فصلة_, _يفعل_
  { {0x69110613,0x63bd0595,0x3a74004a,0x2bb80058}},	//   gåen, øsni, ллур, راقة_
  { {0x1df90080,0x7ae50064,0xb9250015,0x7dee0030}},	//   _цены_, riht, نفطي, rősé
  { {0xf7710806,0xcdb6000a,0x7dee0030,0xa907006e}},	//   لات_, _ספרה_, sősé, ربان
  { {0x4cba000a,0xd8b80015,0x257a00aa,0x7d0d0de0}},	//   _חזרו, عدما_, eël_, mlas
  { {0x9f38000a,0x67d202d9,0x7d0d0de1,0x0000006a}},	//   תנגד_, рољу, llas,
  { {0xa2a1005d,0x6d5a016f,0x8aa40063,0x7d0d0de2}},	//   _कोष्, štav, _сряд, olas
  { {0x45180010,0x5925002b,0x7d0d0de3,0xddd50de4}},	//   нцыя_, _شکاف, nlas, razň
  { {0xf7730015,0x83fd0030,0x07350de5,0x7d0d0de6}},	//   _حاز_, egőr, _резю, ilas
  { {0x7d0d0156,0xc3c80029,0x25fa000b,0x97240040}},	//   hlas, عظيم_, _ऊँची_, _مفقو
  { {0x86020086,0xcb12000a,0x7d0d0de7,0x63ad0de8}},	//   _پژوه, שלי_, klas, _šand
  { {0xa2a1005d,0xf9920008,0x34950180,0x81d40033}},	//   _कोर्, ברט_, _јадр, уцьц
  { {0xf3670080,0xe28e0de9,0xe0d7006b,0x7d0d0dea}},	//   _чтен, _ка_, твя_, dlas
  { {0x200c0024,0x601e002c,0x11d50015,0x03d6004c}},	//   ādi_, _rámč, _لتبد, _בונם_
  { {0x82340029,0xfc3f002c,0xd24e0015,0xf1a9002b}},	//   _إرها, _kníh_, _بنى_, _زاغه_
  { {0x98b80024,0x7d0d0deb,0x753c0030,0x628103c1}},	//   _otrā_, glas, _érze, lflo
  { {0xd00f0015,0x69110dec,0xcf590033,0x1d070ded}},	// [12c0] _ولى_, tåen, _прэч_, тети_
  { {0x7d0d0209,0x4a430902,0xcf57000a,0xeb970054}},	//   alas, инув, _שבית_, ђих_
  { {0x442f0dee,0x7d0d0def,0x27e90052,0x0000006a}},	//   _ogg_, blas, úann_,
  { {0xc863005e,0x91ba000a,0xf7460df0,0x6d5c0dca}},	//   атши, ומעי, ведо, msra
  { {0x09290029,0xd7ef0029,0xe737068e,0x64490030}},	//   رسمي_, يكم_, веч_, dbei
  { {0xa7140010,0xcf93000a,0x6d5a006f,0xa2a1000b}},	//   ымлі, יטד_, štau, _कोल्
  { {0xd5b00029,0x09e6004a,0xb05b007c,0xafdb00cb}},	//   صفة_, _ровн, skäi, tbøk
  { {0x69c300f2,0x7d040df1,0x52ca000b,0x60c00012}},	//   änee, nois, िस्स, ömml
  { {0x64a305e6,0xa87b000a,0xb8d60157,0x62810df2}},	//   рања, _קאמר, जा_, fflo
  { {0x02a60191,0x7d0d0df3,0xca320008,0x64490024}},	//   трим, zlas, ים֙_, abei
  { {0x7d04022d,0xf4840086,0xd48f0355,0xb5ca002b}},	//   kois, _ماشی, _кр_, _توام_
  { {0x7d0400f2,0xf487002b,0x7c2b0091,0x76580061}},	//   jois, _لاهی, žgri, lavy
  { {0xc0e40010,0xfbdf00dd,0x7d040df4,0x7d0d055c}},	//   роўк, _leêr_, dois, vlas
  { {0x7658000c,0x645d0091,0x7f9403ae,0x752b0df5}},	//   navy, ųsit, јарх, _zigz
  { {0x2fcd010b,0x1eea002b,0x6d5c0df6,0x7d0d0df7}},	//   šeg_, روفی_, gsra, tlas
  { {0x8c3b00b8,0x656a002d,0xab950054,0x7b100012}},	//   _maßg, irfh, лабљ, säul
  { {0x5c070063,0xdb580010,0x76580df8,0x7d0d0df9}},	// [12d0] тява, вюх_, kavy, rlas
  { {0xd37b000a,0x19eb0021,0x7d0d0dfa,0x7b100012}},	//   ורמט, وراً_, slas, bäum
  { {0x7d0d0dfb,0x89340015,0x6f020125,0x2486006f}},	//   plas, لعنا, _íoca, _obom_
  { {0x01350053,0xf09f0144,0x71d7004f,0x0000006a}},	//   אָסט_, ndà_, כובד_,
  { {0x97350074,0xc7ab0015,0x2b470033,0xf7850015}},	//   اکرا, بدال_, _шэнг, التَ
  { {0x76580091,0xfc3f0046,0x2ed1000b,0x0000006a}},	//   gavy, _sníh_, _हतोत,
  { {0xceb400f3,0x05540033,0xa5090dfc,0x0000006a}},	//   ייס_, атыя, нека_,
  { {0x2619005d,0x38a40b1e,0xa8a40dfd,0x8a1802ed}},	//   येगी_, _кјуб, _крук, _росс_
  { {0x64490dfe,0xf794008f,0x27e0002d,0xd5bf0024}},	//   rbei, _катэ, úint_, _šāds_
  { {0x64490dff,0x6d5c008c,0x8bba004f,0xf09f03a0}},	//   sbei, ysra, ׂ֖ית, edà_
  { {0xfad6013a,0x27390016,0x62810e00,0x290f0e01}},	//   רותך_, _hèn_, rflo, olga_
  { {0x20c2002d,0x3f6a0e02,0x27390016,0x62810e03}},	//   _cóip_, нимо_, _kèn_, sflo
  { {0xe3650036,0xd496000a,0x7d040e04,0x249f0e05}},	//   _скли, _תכנת_, vois, mdum_
  { {0x249f0084,0xe2960925,0x6d5c0e06,0x8fa3011e}},	//   ldum_, _баш_, tsra, љаре
  { {0x7d04022d,0xf6520008,0xa0a60418,0x6d5c04f8}},	//   tois, מצם_, _байд, usra
  { {0x6d5c0048,0x7b1000b8,0x249f0e07,0x7cda0015}},	//   rsra, räum, ndum_, روذز_
  { {0xcb670175,0x2d850061,0x5336004c,0xdca3005e}},	// [12e0] лате_, çler_, ָנען_, щати
  { {0xda650196,0x66cf003c,0x8f9b0008,0x7d0400f2}},	//   لامي, _søkn, _טיפי, sois
  { {0x38cb002b,0xd256000a,0x98a60a13,0x7d040e08}},	//   کالی_, רשעה_, лиже, pois
  { {0x237f005c,0x28df000b,0x27390016,0x6d5a0073}},	//   ktuj_, पोलि, _bèn_, štas
  { {0xfe360008,0x4b550063,0x76580e09,0x58370127}},	//   ְרֵי_, _въст, tavy, узія_
  { {0x4e7a00b2,0xb8cb005d,0x3b0a0080,0x2ca00020}},	//   גאַצ, _को_, _чего_, ldid_
  { {0x45d409ef,0x2ca0007c,0xf5200033,0x0ec6000b}},	//   ройс, odid_, онкi_, रॉयड
  { {0x2ca00e0a,0x76580007,0x7e09000a,0x734a006b}},	//   ndid_, savy, כִפֶ, нчов_
  { {0x765800df,0xe6460e0b,0x66760002,0xc67600e5}},	//   pavy, _безп, _مدار, _مطاب
  { {0x4b7b0053,0x63ad0057,0x6b7b004c,0xa01b001a}},	//   עטיג, _šanc, ערינ, ffön
  { {0x5ab70053,0xe57a005e,0xf0b5005e,0x7f4401c2}},	//   אליע_, _їзд_, айнь, _atiq
  { {0x853b000a,0x8597000a,0x2ca001c2,0x55bb000a}},	//   _נגדי, _תדאג_, jdid_, _רמאו
  { {0xf09f0251,0x9f35005e,0x2ca00034,0x0000006a}},	//   rdà_, регі, ddid_,
  { {0x539b0008,0x11d60031,0x74130067,0x8c3b0012}},	//   _ניוו, _متعد, _اوها, _maße
  { {0x56370053,0x7f440e0c,0xfd130015,0xfce90015}},	//   ראלע_, _etiq, مجر_, نفسي_
  { {0x2bd9002b,0x361b004f,0x0000006a,0x0000006a}},	//   پارک_, תולד,   ,
  { {0x6d47002e,0xba55009c,0xe4ab000a,0x6d5a0030}},	// [12f0] spja, ивај, עֹלָ, átar
  { {0xb05b00b8,0xcb680002,0x2ca0007c,0x0ab80015}},	//   rkäu, امله_, adid_, ُطلب_
  { {0x6d5a002c,0x3835007a,0xe8590033,0x80aa000b}},	//   štar, анер, ваеш_, _जोडे
  { {0x237f0050,0x5c07006b,0x7a320030,0xda080015}},	//   ytuj_, _бяга, tűtí, ديمه_
  { {0x0a6b0431,0xb05b00f2,0xe72e034e,0xa8780015}},	//   _први_, lkäs, же_, احمر_
  { {0x0f5800a3,0xff58004c,0xa6840033,0xe736098a}},	//   ניום_, נבוך_, йлід, шеш_
  { {0xa564003b,0xb05b0a75,0xb9250015,0x3ebe030a}},	//   مدين, nkäs, _نفسي, ötti_
  { {0x91f50092,0xe795002b,0x38600125,0x3365014d}},	//   hác, _پارک, óirt_, авиг
  { {0x249f0e0d,0xd7fb0a23,0xc603003d,0x68eb0073}},	//   rdum_, _чув_, dzēš_, migd
  { {0x68eb0111,0x237f005c,0xa01b002e,0x6d45002d}},	//   ligd, rtuj_, tfön, _otha
  { {0x25b90087,0x237f002a,0x0477002b,0x897b000a}},	//   _جهاد_, stuj_, _ملاک_, תָ֖ה
  { {0x61ee002d,0x237f0d55,0x68eb0161,0x20560098}},	//   úbla, ptuj_, nigd, штор
  { {0xa01b05d7,0x443f0e0e,0x6d450e0f,0x0000006a}},	//   sfön, mcu_, _atha,
  { {0x71a50033,0x56b5000a,0x50d6002b,0x443f0e10}},	//   _вакз, ׁפָן_, ازگر, lcu_
  { {0x1c3a008f,0xa01b00dc,0x91e205c4,0xf1a8002b}},	//   вязь_, lföl, _моше, _مايه_
  { {0x1c460e11,0x645b0012,0xdddc0091,0x443f0e12}},	//   рнам, naui, perž, ncu_
  { {0xdcb70092,0x2ca00020,0xef1a0080,0x6e460086}},	// [1300] ởng_, rdid_, _ими_, _پنجم
  { {0xc3320008,0x4e1a0015,0xb05b007c,0xe5e50046}},	//   קוב_, _لتجد_, skät, íměř
  { {0x89f50033,0x8c3b0012,0xda650015,0x0f02000b}},	//   бяцц, _saße, صالي, लकीस_
  { {0x270e014e,0x6d3b0135,0x3dfb000a,0x76410e13}},	//   ित्र_, _שײכו, _יליד, _afly
  { {0x40e9000a,0xa01b0030,0x443f0e14,0x60c4002a}},	//   נַעֲ, jföl, dcu_, _moim
  { {0x316b005c,0xa01b0123,0x60c4008c,0x60d60034}},	//   ńczy_, dföl, _loim, _llym
  { {0xd6da0086,0x3f850045,0xb866002b,0x75d3002b}},	//   _یورش_, ălui_, _پازو, ييها
  { {0x399b00b2,0x499b0008,0x3864030d,0x63ad0e15}},	//   _בילד, _בשלב, _udmr_, _šana
  { {0x9696005e,0x86960054,0xf743058c,0xe73a0e16}},	//   _вреш, _вјеч, _мето, _рез_
  { {0xdce7005c,0x78a20e17,0x877b000a,0xe0c8000a}},	//   mują, ldov, _באמי, _אֲ_
  { {0x3a37011f,0xaa370053,0x21780010,0xd5a40086}},	//   ירים_, יטיק_, ыйны_, _دلای
  { {0xd4f50010,0x60d60e18,0x60c40e19,0xd4670e1a}},	//   _лячы, _clym, _coim, _вице_
  { {0xdce7005c,0x77f4000b,0xefb1002b,0x60c40e1b}},	//   nują, _अशोक_, سیدگ, _doim
  { {0x0eeb006d,0xb05b008c,0xa6f8004f,0x0000006a}},	//   тьми_, tkäs, אִֽי,
  { {0xdef8008f,0xeda40185,0xb2bb000a,0x3f820e1c}},	//   рыя_, ошто, _במגר, atku_
  { {0xdce70050,0x60d60026,0x78a20e1d,0x3cf80015}},	//   kują, _glym, jdov, لعقد_
  { {0x30780015,0xd497000a,0x68eb0e1e,0x4b550015}},	// [1310] _ضحية_, סכמת_, vigd, صَار
  { {0x6e95003b,0xdce7005c,0x7ee40029,0x443f00bd}},	//   _الدا, dują, _وكين, zcu_
  { {0x68eb0159,0xa01b0030,0xdb040003,0x443f002a}},	//   tigd, zföl, iviè, ycu_
  { {0xa3c70065,0xcd34009a,0xe708009a,0xdce70535}},	//   _उथल_, _گریب, یتون_, fują
  { {0xdce7005c,0x07a503de,0x443f0e1f,0x3ea1007c}},	//   gują, салн, vcu_, _kaht_
  { {0x443f002a,0x98bc003d,0x67230085,0xcb36000a}},	//   wcu_, īvā_, umnj, _לנשק_
  { {0x3ea10020,0x443f0e20,0xdce70091,0x2d830e21}},	//   _maht_, tcu_, aują, ntje_
  { {0xfdf80e22,0x3f820e23,0xcdf8000a,0x7bcd0003}},	//   ימוש_, ytku_, ימוי_, oyau
  { {0x60c4002f,0xe3e90086,0xdce7005c,0x443f0e24}},	//   _roim, دکان_, cują, rcu_
  { {0x443f0e25,0x65870010,0xa01b0e26,0xe2990054}},	//   scu_, _выдз, rföl, ћан_
  { {0xe3a50086,0x60c40e27,0xd5d40015,0x26c50034}},	//   _گشای, _poim, _وتمث, _iolo_
  { {0x236d018c,0xfd1f0092,0xa01b0e28,0xc9b6000a}},	//   prej_, _nhì_, pföl, צהרת_
  { {0x60c4022d,0x66cf003c,0x78fa0053,0x98a70091}},	//   _voim, _nøkk, רפרו, ūnė_
  { {0xc3320008,0x68fb0e29,0xd336000a,0x3f820e2a}},	//   _זוג_, _ljud, _פרצה_, rtku_
  { {0x60c40e2b,0xdce7005c,0x68e900c0,0x3f820057}},	//   _toim, zują, _omed, stku_
  { {0x6459003e,0xc2120008,0x2fda0115,0xb05b03a4}},	//   _jewi, _מהו_, _موعد_, skär
  { {0x3f9e0048,0x5baa02bf,0x2d830079,0x78a20046}},	// [1320] ātus_, ыкам_, atje_, vdov
  { {0x7e560001,0x68fb0e2c,0xf4120135,0x2bf50033}},	//   _утиц, _ajud, לפן_, іятр
  { {0xfbc90008,0x68fb00c0,0xdce7005c,0x27220092}},	//   עת_, _bjud, wują, _hưng_
  { {0x64590176,0xdce7005c,0x2fdd0064,0x291f0e2d}},	//   _newi, tują, _özgü_, _chua_
  { {0x26c5002c,0x96ea0127,0x907b000a,0x18670588}},	//   _bolo_, лька_, רטני, сачи_
  { {0x8f9b0008,0xdce7005c,0xd7f90036,0x96f8000d}},	//   טיני, rują, шує_, јект_
  { {0xdce7005c,0x6b840e2e,0x6c9a000a,0xc448002b}},	//   sują, ltig, ָשִׂ, لیان_
  { {0xdce7005c,0xd497004a,0x98350033,0x6b840144}},	//   pują, брь_, _дэфі, otig
  { {0x64590176,0xd2500029,0xa5070001,0xd3a30010}},	//   _dewi, ونة_, љења_, прэп
  { {0xdb9b0053,0x6b840e2f,0x68e900bc,0x87f90033}},	//   נסיר, itig, _zmed, _тэст_
  { {0xf202005d,0x6b84059b,0x7abb000a,0xd9fa000b}},	//   _रुख़_, htig, אציו, ्थित_
  { {0x6b8402d2,0x64590e30,0x75d30015,0x1074005e}},	//   ktig, _gewi, _عينا, плюю
  { {0xdfd80063,0x351b000a,0x2d830546,0x272200a1}},	//   бър_, _עודנ, wtje_, _cưng_
  { {0xd9fa000b,0x2d830030,0x27220016,0xa3c70065}},	//   ्थात_, ttje_, _dưng_, ैनर_
  { {0x691802c1,0xa5d8000a,0xbd450015,0xa2e50015}},	//   víen, בַּי, تنزي, _بأنن
  { {0x9d15005e,0x5c07004a,0x2d830e31,0x3ff50015}},	//   ідач, бяза, rtje_, _وكثر
  { {0x6b840e32,0x692c0061,0xfc300015,0x2d830e33}},	// [1330] gtig, _eşek, فحك_, stje_
  { {0x433b0053,0xfaf300e6,0x10140021,0xc911000b}},	//   טעמב, أثر_, _عبيد, ़त्म_
  { {0xfd1f0023,0x753a018b,0x7bcd00e8,0x91f50016}},	//   _thì_, _nutz, syau, hán
  { {0xa8150001,0x26c50e34,0xd7f10015,0x417b004c}},	//   одеш, _solo_, وكا_, רנאב
  { {0x660401e2,0x6c7a0053,0xa08c000a,0x26c50e35}},	//   şikl, _דארפ, רְבִ, _polo_
  { {0x2f5c00a3,0x501c000a,0x0bb6000a,0x1f5c000a}},	//   נדונ, אודו, _ולשם_, נדוא
  { {0x6459005c,0xddd5005c,0x26c504ed,0x291f0e36}},	//   _pewi, lazł, _volo_, _thua_
  { {0xf992000f,0xa3c7000b,0x753a0012,0x6d5a0003}},	//   _קרן_, ैनल_, _dutz, âtai
  { {0xdcfc0024,0x03a50e37,0x26c5016e,0x0000006a}},	//   ntrā, ципо, _tolo_,
  { {0xdddc00dc,0x12870086,0x07f80021,0x765a0079}},	//   zerű, حمدی_, _ارفع_, _gety
  { {0xaade000b,0xb05b008c,0x27220016,0x63a40e38}},	//   फोटक, tkäp, _sưng_, _šint
  { {0xa8790053,0x79850026,0x7b1000b8,0x297a0135}},	//   סאָר, ithw, läut, סטרא
  { {0xa3bb0074,0x94050087,0xc50c004c,0xc7ac000a}},	//   _حاضر_, _بوشه, _גלאָ, ְׁלָ
  { {0x7304005e,0x91f50015,0xa2a1000b,0x63a90e39}},	//   _епіз, _وأثا, _कोच्, mven
  { {0x63a90e3a,0x9db90033,0x6da305a7,0xed5a0e3b}},	//   lven, быту_, мира, роб_
  { {0x161e000b,0x60dd0028,0x63a90e3c,0x4c860033}},	//   येटर_, chsm, oven, ўлав
  { {0xab660036,0x79850026,0x6b8400b8,0x0aea01f3}},	// [1340] ювал, ethw, utig, адай_
  { {0x60230010,0x6b840e3d,0xc9d60040,0xaa16012e}},	//   _ідэа, rtig, يزاب, офеј
  { {0x18a605c4,0x88e6004a,0x6b840e3e,0xa84a0058}},	//   жаем, ожже, stig, للام_
  { {0x7188000a,0x765a02f2,0xe7aa0e3f,0x274a02d9}},	//   מְנַ, _sety, ивел_, ачко_
  { {0x63a90111,0xd90d002b,0xc7960015,0xafad004f}},	//   jven, ایق_, تشاب, ָיוֹ
  { {0x501b0008,0x7d1600f2,0x645d002e,0x2d850144}},	//   בונו, llys, ðsin, àleg_
  { {0xd5470083,0x8c3b00b8,0xa9670c1c,0xa2da000b}},	//   опје_, _maßn, _мира_, _पॄष्
  { {0x63a902de,0x387f0125,0x94aa0e40,0xf3660e41}},	//   fven, _gcur_, ртка_, отон
  { {0x63a90079,0x7d160e42,0x0000006a,0x0000006a}},	//   gven, ilys,   ,
  { {0x0bb70008,0x7d160026,0xc6d80008,0x6f02002d}},	//   קלים_, hlys, _פַּר, _íoch
  { {0x6ebe000b,0xf9a00033,0x7b100012,0xc2b700ce}},	//   शानु, днiм_, läus, ілює_
  { {0x859b000a,0x403501b0,0x63a90e43,0x0000006a}},	//   _כשבו, яемс, bven,
  { {0x63a904f9,0x69180077,0x545300fd,0x4ea7087f}},	//   cven, víel, _цвіт, орва
  { {0x79850026,0xe2970e44,0xf773000a,0xcf270015}},	//   ythw, _мач_, וקש_, ترجي
  { {0x7b1000b8,0x7817000b,0x3ceb0004,0x9980006f}},	//   häus, _तर्क_, аќам_, eďže_
  { {0xdcee0024,0x69c30519,0xdcb80342,0x91040054}},	//   tubā, änem, ощу_, _опје
  { {0x28ab005d,0xa088000a,0xc104002b,0x7b10008c}},	// [1350] _घोषि, _וְתִ, _تويي, jäus
  { {0x42370053,0x1ec40015,0x7e99002b,0x7d160e45}},	//   ַנדל_, _يقيّ, _اندر_, alys
  { {0xdcfc0048,0x39580026,0x0e9a0008,0xf3f90045}},	//   strā, _cwrs_, _השתל, iaţa_
  { {0x2366010b,0x21bb0135,0x79850e46,0x63a90e47}},	//   _ovoj_, יזבא, rthw, yven
  { {0xba77003b,0x7d0d0011,0x4cba000a,0x97d80015}},	//   _واست, moas, _הזרו, يظهر_
  { {0x7d0d0e48,0xbb3a000a,0x63a902b9,0x98aa0046}},	//   loas, _לעשי, vven, _kubě_
  { {0x39580026,0x7b1002ad,0x0000006a,0x0000006a}},	//   _gwrs_, räut,   ,
  { {0x63a9065d,0x5dfc0135,0x7d0d0af6,0xb8b70015}},	//   tven, יפונ, noas, _بإست
  { {0x63a90152,0xf3f90045,0x437500ce,0x69370160}},	//   uven, faţa_, чуйт, _ećet
  { {0x396400f2,0x2cf9000b,0x2366006f,0x63a90e49}},	//   _ässä_, ्कुल_, _dvoj_, rven
  { {0x7d0d00f2,0xe4d70015,0x07080015,0xe4d6002b}},	//   koas, _وتصب, _بيلي_, زویت_
  { {0x2106014e,0x63a900dd,0x361a000a,0x7d0d0045}},	//   रवेश_, pven, _הועד, joas
  { {0xe4560053,0x08760053,0x20550010,0xdfd200e5}},	//   _זינט_, הערט_, ьтэр, ريس_
  { {0x75290e4a,0xb3080015,0xb14502d9,0x63f40058}},	//   lmez, _وغول_, _енкл, _تأمر
  { {0x412a07be,0x471a004f,0xe1f6011e,0x0000006a}},	//   _локо_, מושג, _нгш_,
  { {0x01360008,0xb05b00f2,0x75290061,0x225c0061}},	//   _צרפת_, ljän, nmez, _zevk_
  { {0xfc030e4b,0xceb60058,0xfce302db,0x98a40073}},	// [1360] епто, _فحدث, хото, _gimę_
  { {0x7d1600dd,0x80250015,0xd336000a,0xb05b0123}},	//   slys, _غريم, פרעה_, njän
  { {0xbe3b0008,0x7d160e4c,0xda650015,0x8e57000a}},	//   _לעית, plys, باقي, _מייג_
  { {0x80bf005d,0xcb090135,0xc18c004c,0x7b100012}},	//   षाये, אל_, שטאָ, täus
  { {0xdc3700b2,0xa01b002e,0x20ef0046,0xc7960033}},	//   _מאכט_, rgög, dřil_, яржы
  { {0x65940010,0x66e3017f,0x7b100012,0xa01b001a}},	//   даку, ноча, räus, sgög
  { {0xceb30008,0x39e7006b,0x236605e3,0x7aee02f2}},	//   תיו_, _едро_, _svoj_, _imbt
  { {0x6813005c,0x752900dc,0x98a30a61,0x225c0061}},	//   _będą, gmez, _писе, _sevk_
  { {0xd3b8005e,0x3636006e,0x366a0117,0x0000006a}},	//   ілої_, _فراس, _газо_,
  { {0x28130015,0x51f8005e,0x20050061,0x246c0016}},	//   _أوكس, жною_, şlik_, ớm_
  { {0xd2570033,0x7aee01d7,0x7416002b,0x7a8b004f}},	//   чцы_, _mmbt, _کوشا, זָכַ
  { {0xe53b0008,0x55bb0008,0x09f70008,0x6937016f}},	//   _התאר, _למבו, למים_, _kćer
  { {0x7d0d04f9,0xa3cd005d,0xdfd8006b,0xbff803ca}},	//   voas, रहण_, пър_, зеях_
  { {0x57fb000a,0x3d950e4d,0x93fb000a,0x539b000a}},	//   מלכו, мигр, _פלגי, _לידו
  { {0x629a0e4e,0x7d0d0e4f,0x7e280138,0x0000006a}},	//   meto, toas, зіта_,
  { {0x51fb0008,0x01fb000a,0x7aee0079,0xfc3f016e}},	//   _להוצ, _לפול, _ambt, _baía_
  { {0x7d0d0e50,0xf094000a,0xab940054,0xfc3f0e51}},	// [1370] roas, _טנק_, натљ, _caía_
  { {0x75290046,0x8018012c,0x629a0e52,0xa3cd0065}},	//   zmez, _عزيز_, neto, रहत_
  { {0x629a0e53,0x69da007c,0x7529005a,0x3eb70073}},	//   ieto, _ütel, ymez, četė_
  { {0x3ce00089,0x2c750015,0x629a0e54,0x08d4005e}},	//   chiv_, _تُحس, heto, нція
  { {0xdcfc0011,0xf09f0092,0x629a0e55,0xd366002b}},	//   stră, goài_, keto, _جه_
  { {0x7b100012,0xfb350033,0x501c000a,0x387d0034}},	//   säur, _інвэ, צוגו, sgwr_
  { {0x65920001,0xe5a2005e,0x9479005e,0x20ef0046}},	//   вају, вищи, оспу_, třil_
  { {0x33d50036,0x05b40033,0xd6180015,0x629a007c}},	//   діот, эсіў, أتها_, eeto
  { {0xe7390176,0xb05b00c0,0x63a200dc,0xd299008b}},	//   _grŵp_, tjän, _cson, отні_
  { {0xe2990054,0x290f0e56,0xe7330015,0x2ca9052d}},	//   цао_, loga_, _أصر_, hdad_
  { {0xdb2400dc,0x7f4d0e57,0x91e5006b,0x63a20e58}},	//   ésén, _ataq, фоне, _eson
  { {0x3cf9005d,0x290f0e59,0xa988000a,0x0000006a}},	//   ्कों_, noga_, הָשִ,
  { {0x2ca90123,0x83640015,0x629a0e5a,0x6828004f}},	//   ddad_, _كدول, beto, ּֽרְ
  { {0x2ca90077,0xb05b008c,0x853c0091,0x629a0e5b}},	//   edad_, ljäl, _grės, ceto
  { {0x386d0bcf,0x290f016f,0x9db90010,0x8c4607be}},	//   _oder_, koga_, пыту_, дебе
  { {0xc212000a,0xb05b008c,0xa03a0015,0x2ca90e5c}},	//   _שהה_, njäl, _بأثر_, gdad_
  { {0xcaca0033,0x394d00bc,0x6f660033,0x5aca0e5d}},	// [1380] огае_, _česa_, _ўвоз, олам_
  { {0x89f60e5e,0x63a60e5f,0xab1a0033,0xb05b0123}},	//   وثائ, ækni, іцах_, hjäl
  { {0xdebb0008,0x290f012d,0xbfa30016,0x88860e60}},	//   _ומיל, foga_, hiể, длеж
  { {0x69da00dc,0x38cb0086,0x629a0e61,0x9a25002b}},	//   _ütem, يانی_, zeto, رعلن
  { {0x872a0010,0x98a40046,0x4c9b000a,0xab2a07be}},	//   оўка_, _zimě_, _ובכו, _мома_
  { {0x47330036,0x386d0e62,0x2bbd000b,0x569302d9}},	//   вніс, _eder_, ोहरा, вашт
  { {0xa96a067a,0x69d802de,0x248d0e63,0xb05b0123}},	//   _фиба_, øved, ffem_, fjäl
  { {0x66cf003c,0x98a600bc,0x636a0e64,0xb8660058}},	//   _søkt, omoč_, орог_, _زارو
  { {0xd90d04b6,0x22490061,0x629a0e65,0xa686011e}},	//   _این_, _şaka_, teto, _олад
  { {0xa823002b,0x66290030,0x21540033,0x68e20e66}},	//   _شکنن, áskö, нкоў, lhod
  { {0x02a3008f,0xe3af0086,0xfa77000a,0x386d019f}},	//   трым, هری_, ועית_, _yder_
  { {0x754900dc,0x3d08000b,0xf5060033,0x69c3008c}},	//   őszö, वकों_, _ўздо, änei
  { {0x26cc0e67,0x32d9002b,0x6d480046,0x0443013d}},	//   _kodo_, زدیک_, ídan, _речн
  { {0xe1ef0074,0x7ce30005,0x37d900b2,0xa2b30033}},	//   اسی_, _kõrg, פֿרע, _абшч
  { {0x9f340191,0xdc3a01e2,0xc327003b,0x26cc0e68}},	//   тері, _açık, _تكون_, _modo_
  { {0xe7ab002c,0x26cc04e6,0x0000006a,0x0000006a}},	//   _ďaľš, _lodo_,   ,
  { {0x290f016f,0x2ca90e69,0x68e205ba,0x386d00aa}},	// [1390] voga_, rdad_, dhod, _rder_
  { {0x26cc0e6a,0xcf270002,0x7a540015,0xeafb000b}},	//   _nodo_, _تربي, نضما, ्वेत_
  { {0x7ce30020,0x63a00034,0xb05b008c,0x290f0e6b}},	//   _nõrg, hwmn, yjäl, toga_
  { {0x26de0e6c,0xf8b1009a,0x0000006a,0x0000006a}},	//   _alto_, دکس_,   ,
  { {0x26cc0e6d,0xf7480015,0xcc76000a,0x6c56000a}},	//   _bodo_, وجوه_, _אגרת_, _רישא_
  { {0xf7700087,0xba740015,0x3f7c004c,0xdb0602de}},	//   شاه_, _لافت, קאוס, _arkæ
  { {0x66f2002a,0x66cf00cb,0x48770015,0x9733002b}},	//   ałko, _søks, _يدرس, _یکتا
  { {0x2f160e6e,0xce38000f,0x68e20e6f,0x27e60061}},	//   lægt_, ואות_, chod, bzon_
  { {0xe3b10115,0xf7730115,0x58840033,0x92f500e2}},	//   ارب_, _جاز_, _шыра, ечні
  { {0x16db003b,0xbfa30016,0x8bfa000a,0x6588025d}},	//   _بذرة_, riể, לִיפ, örhö
  { {0x78a90020,0xcb120008,0xb05b04f8,0xb93a000a}},	//   _kaev, רלי_, lkäy, ּׂשכ
  { {0x98b80048,0xe454008f,0x26c701a3,0xe3b10015}},	//   _kurā_, _акцы, ljno_, _مرت_
  { {0x95220074,0x43840029,0xb05b00f2,0x60cd0011}},	//   _حکوم, _للنق, nkäy, _doam
  { {0x78a90020,0x68e20156,0xa2d50015,0xc2c50015}},	//   _laev, zhod, _سيعت, _سيبي
  { {0x27e60014,0x7bcb0012,0x68e20046,0x32da000a}},	//   zzon_, ägun, yhod, _מחסנ
  { {0xc06f0089,0x76930064,0x35a6000b,0x64490e70}},	//   íští, lıyı, _कैफ़, ncei
  { {0x68360064,0x68e20227,0x628100bc,0x91290015}},	// [13a0] _müdü, vhod, oglo, _تسوق_
  { {0x76930061,0x09e60e71,0x62810e72,0x0000006a}},	//   nıyı, нозн, nglo,
  { {0xae5b0008,0x26cc0007,0xe93a00e5,0xd910002b}},	//   _מכיר, _rodo_, سسات_, لیس_
  { {0xa01b01d1,0x3860002f,0x89160029,0x68e20089}},	//   mför, úir_, ربائ, uhod
  { {0xcc3b004c,0x68e20e73,0xa01b0e74,0xcc350033}},	//   _מעכט, rhod, lför, _ахры
  { {0xdddc002a,0x644b019f,0xb5a60a32,0x7ce3007c}},	//   marł, _afgi, ерий, _põrg
  { {0x68e2016f,0xa01b04d4,0xe1e70015,0x26cc00bc}},	//   phod, nför, _إس_, _vodo_
  { {0x7ce30020,0xd37a000d,0x6934002b,0x7c89000a}},	//   _võrg, пчо_, _شکار, ֵאתִ
  { {0x26cc0e75,0x53970033,0xd4670054,0x48e30b9b}},	//   _todo_, евыя_, хиње_, _сотв
  { {0x026a0080,0xd257005e,0xa01b0123,0x7ce3007c}},	//   чший_, нцю_, kför, _tõrg
  { {0xf92a000a,0x6611002b,0x7ce3007c,0x6d48005a}},	//   ּוָּ, _پژوا, _hõre, ídal
  { {0xa01b00c0,0x64490144,0x68360061,0xdddc002a}},	//   dför, ccei, _güdü, karł
  { {0xf8b30008,0xaf370086,0x4e16000b,0x2d9e0061}},	//   אשר_, فرست, _दुबई_, çten_
  { {0x661a00f2,0xdddc0535,0x0000006a,0x0000006a}},	//   _kytk, darł,   ,
  { {0x673a08e0,0x6d5e0026,0x171b0053,0xef1f00dc}},	//   _mitj, _cwpa, פולע, ltük_
  { {0xa1830033,0x51830e76,0xf531004f,0x3e340058}},	//   _сышл, _суша, ֹ֥ל_, افِر
  { {0xb05b00f2,0x9be7005e,0x2f1602de,0x78a9007c}},	// [13b0] hjäk, хівк, tægt_, _raev
  { {0x3f64006b,0x539b004f,0x7c1400ce,0x3e69009a}},	//   _стъб, הימו, удує, _کجکی_
  { {0x6d5e0034,0x78a90072,0x0000006a,0x0000006a}},	//   _gwpa, _paev,   ,
  { {0x6ee2002c,0xf9900015,0xda08006e,0x19b80015}},	//   _vôbe, إبل_, رينه_, عطلة_
  { {0x9814008f,0x7ce30005,0x317e00b8,0x78a90020}},	//   льшч, _võrd, hutz_, _vaev
  { {0xcf940135,0xef1f0030,0x26c700bc,0xbdf8002b}},	//   רטס_, dtük_, ujno_, _آریا_
  { {0xceb4013a,0x27290092,0xb05b00f2,0x6605006b}},	//   טיס_, húng_, skäy, ъпка
  { {0xdb060c77,0x94790cfe,0x673a0079,0xe610002b}},	//   _erkä, фску_, _eitj, حشه_
  { {0x644907cc,0x2c37000a,0x250a002b,0xf506006b}},	//   rcei, עָ֔ם_, بروی_, ънъл_
  { {0x57f40731,0xf767002b,0x80aa000b,0xb05b0012}},	//   _спут, یا_, _जोड़ू, ljäh
  { {0x05740074,0x04950029,0x95570029,0x98d5000b}},	//   _ماند, _للاح, _أخطا, _दवाए
  { {0x3f6a0e77,0x95540015,0xb05b0012,0xa01b0123}},	//   мимо_, _إخلا, njäh, vför
  { {0xa8560008,0xd00f0015,0xefc7004a,0xb05b0012}},	//   כירה_, ْلُ_, влял_, ijäh
  { {0x6b8d00fb,0xe1f10074,0xa01b01d1,0xc7d6000a}},	//   dtag, _پست_, tför, דושי_
  { {0x92580029,0x8d630292,0xdddc002a,0x613e003d}},	//   _أشهر_, ивре, warł, _pūle
  { {0xa01b0e78,0xdddc002a,0xc3390046,0x249f0e79}},	//   rför, tarł, řídá, neum_
  { {0xa01b0c77,0xdca3005e,0x6b8d0e7a,0xcb6706a6}},	// [13c0] sför, шати, gtag, кате_
  { {0xa01b00c0,0x73fa000a,0xed46004a,0x7bc403a0}},	//   pför, וּבו, _иноп, rxiu
  { {0xa01b002e,0xef1f00dc,0xfd120015,0xa967006b}},	//   ngön, ztük_, _نجح_, виха_
  { {0xe8740086,0xb05b0012,0xdddc002a,0x673a001a}},	//   انشگ, gjäh, parł, _sitj
  { {0x2ca00020,0x2729002c,0xe72a002b,0x38cb002b}},	//   meid_, kúnd_, وستو_, بالی_
  { {0xc1780007,0x2ca00e7b,0x46f6006b,0x971301f3}},	//   yrė_, leid_, ъчет, аміц
  { {0x442000df,0x88840086,0x5fa9005d,0xd5630033}},	//   _ši_, _میان, _चैनल, атып
  { {0xef1f00dc,0x2ca00020,0x44200016,0x98b80045}},	//   ttük_, neid_, _ơi_, _dură_
  { {0xccf301c8,0x2b46002d,0x656a002d,0x07a30e7c}},	//   יכה_, íoch_, ssfh, _катн
  { {0x2ca000f6,0x21290e7d,0xef1f0030,0x98b80045}},	//   heid_, _shah_, rtük_, _fură_
  { {0x60f90e7e,0xf1a30063,0x7a7b000a,0xca7b000a}},	//   ення_, арян, וריס, וניט
  { {0x85f7000a,0xdb04008c,0x64a6012e,0x249f0e7f}},	//   _בצבע_, lviä, _јада, ceum_
  { {0x99620089,0x2ca00020,0xfebb0086,0x44200092}},	//   _níže_, deid_, واست_, _ái_
  { {0x2d470e80,0xff040151,0x6b8d09c0,0x83b7004f}},	//   _põe_, аясн, vtag, _שפגע_
  { {0xe29701ca,0x929b004f,0xc0cb00af,0x224e02dc}},	//   _рај_, _חיות, _жупе_, _iffk_
  { {0x3237000a,0x6b8d0e81,0xd5b8003d,0x5c74029f}},	//   _בטון_, ttag, _azāk_, илст
  { {0xfc64006b,0x6e46001a,0xbab90323,0x4c140058}},	// [13d0] ръсн, íubú, нгах_, لبكس
  { {0xbb190029,0x7a40099c,0xab940036,0x6b8d0e82}},	//   رياض_, vští, рифі, rtag
  { {0x99850029,0xac990029,0x6b8d0e83,0x2ca00e84}},	//   الصو, _كندا_, stag, beid_
  { {0xf7710e85,0x98ad0050,0x25b90089,0x60dd0205}},	//   مات_, _mieć_, _čsl_, nksm
  { {0x6d08000a,0xb05b0012,0x60dd0e86,0x7a400046}},	//   _יִשַ, rjäh, iksm, uští
  { {0xd6db0a2c,0x06840036,0x6d450e87,0x6f150077}},	//   ьте_, игін, _kuha, nozc
  { {0x6d450005,0xf3f904f9,0x29880e88,0xa8a70e89}},	//   _juha, maţi_, _исто_, _ирак
  { {0xf3f904f9,0xb9250029,0xe3a90054,0x60dd0079}},	//   laţi_, _إفري, екид_, jksm
  { {0xe7960086,0x42d50010,0xf4950086,0x89340058}},	//   _مالک, гіну, نشکد, _ضعفا
  { {0xdb0403af,0xf3f904f9,0x2fd90176,0x8c1c0008}},	//   rviç, naţi_, dysg_, ווחי
  { {0xf652000a,0x85470033,0xf3f90045,0xd408002b}},	//   _הצב_, _рэзе, iaţi_, فتیم_
  { {0xf1c30089,0x455a0008,0xcea9011f,0x61fc002d}},	//   _alší_, _נכנס, _מי_, úrla
  { {0xe2a80086,0x2ca0007c,0xf536000a,0xf8b60643}},	//   راین_, veid_, _ענני_, אפרי_
  { {0x201e0048,0xf3f90011,0x6d450e8a,0x69ca0012}},	//   āti_, jaţi_, _buha, äfek
  { {0xe2960063,0xf3f90011,0x2ca00e8b,0x7c260e8c}},	//   _сащ_, daţi_, teid_, _szkr
  { {0x61d60008,0x645b0079,0xad2600c3,0x98b80091}},	//   _תוקף_, nbui, ارسو, _kurą_
  { {0xf3f90011,0x2ca00e8d,0xeb2a0e3f,0x8b650015}},	// [13e0] faţi_, reid_, ежал_, لالم
  { {0x2ca00005,0xf3f904f9,0x76410034,0xab77012c}},	//   seid_, gaţi_, _ngly, املا_
  { {0x4229000a,0x499a0033,0x2d9a0123,0x3f820e8e}},	//   תֵּ֣, этая_, _uppe_, luku_
  { {0xa3e3005d,0x7d7b00f3,0x09060033,0xb78a0054}},	//   नना_, _אנטו, ыпен, ељке_
  { {0xda14005d,0x7c260024,0xf3f90011,0x3f820e8f}},	//   _तुरत_, _uzkr, baţi_, nuku_
  { {0xf3f904f9,0x7d0400b8,0xd6d00015,0x3179002a}},	//   caţi_, lnis, تقت_, ńszy_
  { {0x44260d85,0x7d040e90,0xd5b00058,0xdcfc013b}},	//   _szo_, onis, زفة_, hurč
  { {0xd3a60674,0x33740e91,0x7d040e92,0x68f9002a}},	//   гроп, агир, nnis, ciwd
  { {0x98ad005c,0xd70a0254,0xe8d7000a,0x48060969}},	//   _sieć_, _знае_, _עומר_, _спав
  { {0x3f82003f,0x92b600e6,0x33970015,0x96750033}},	//   duku_, احظا, اخية_, _выці
  { {0xe3b20086,0x6f150046,0x7d040e93,0x9b17004f}},	//   _گرا_, vozc, knis, רחיה_
  { {0xf3f904f9,0x2ba5005d,0x3a370008,0xca370008}},	//   zaţi_, _ऑनला, טרים_, טניה_
  { {0x80f40010,0x4426003f,0x6d450e94,0x20ef0046}},	//   спях, _uzo_, _suha, dřit_
  { {0x6d450e95,0xf3f90011,0x02a3006b,0x543b004c}},	//   _puha, xaţi_, _гръм, _נעגא
  { {0xf3f904f9,0x7d040e96,0x78a20e97,0xdbc60012}},	//   vaţi_, fnis, keov, töße
  { {0x4fd50036,0xd9040086,0xfd440033,0x7d040e98}},	//   _вжит, _ری_, сэрн, gnis
  { {0xf3f904f9,0xdbc600b8,0xdb230086,0x5c070033}},	// [13f0] taţi_, röße, موری, уява
  { {0xcf270015,0xf3f90045,0x6d450e99,0x7d040e9a}},	//   _حربي, uaţi_, _tuha, anis
  { {0x7d04018b,0xf3f904f9,0xad27002b,0xe8550015}},	//   bnis, raţi_, _مرحو, لناد
  { {0xf3f904f9,0x78a20134,0x48390029,0xd246002b}},	//   saţi_, geov, نكاح_, _ژن_
  { {0xf3f90011,0x0b8b006b,0x62980057,0x9c28005e}},	//   paţi_, _ясни_, _obvo, _бірж_
  { {0x4b7a0053,0xe7330015,0xd7580058,0x645b0546}},	//   _באשו, حصص_, اجنا_, wbui
  { {0x2d910e9b,0x2d830e9c,0x645b0e9d,0x0000006a}},	//   ntze_, nuje_, tbui,
  { {0x09e1014e,0xe7250016,0x8c3b0012,0x78a20e9e}},	//   पनीय, _dưỡ, _faßt, ceov
  { {0xb4d5005d,0x2d830156,0xe78700d0,0x443900c0}},	//   _सकी_, huje_, _љубо, äs_
  { {0x3ae400c0,0x7d040e9f,0xa3c6000b,0x3f820ea0}},	//   _köpa_, znis, _उपर_, vuku_
  { {0xd5bb005e,0x2d830ea1,0x645b055e,0x90c60ea2}},	//   _яса_, juje_, pbui, абне
  { {0xf530003b,0x8a16000a,0xb1420033,0x96340b1e}},	//   _فإن_, יחתו_, ўнял, _унхц
  { {0x8c3b0012,0xe3a5002b,0x3ae402dc,0x0000006a}},	//   _maßs, _خشای, _löpa_,
  { {0x3f82010b,0xc8e2005d,0x0efa0033,0x602301c6}},	//   ruku_, _खत्म_, тэмы_, ідра
  { {0x20ef0089,0xacf6049d,0x7d040ea3,0x12fa000a}},	//   třit_, ачај, tnis, _שהצב
  { {0x3f820ea4,0x7ce3007c,0x3d28002b,0xfce30432}},	//   puku_, _põra, اتسی_, оосо

  { {0x0b1a0029,0xac050029,0x7d040738,0x5a66004a}},	// [1400] نقرة_, مذكو, rnis, икаб
  { {0xba260010,0x2d830ea5,0x1c39004a,0xca560054}},	//   адзк, buje_, уясь_, ртањ
  { {0x7e7b0008,0xc8660ea6,0x8e7b000a,0x2d830ea7}},	//   _באיז, атли, _בניה, cuje_
  { {0xd7fa0ea8,0x8c960033,0x3ae40123,0x7c960ea9}},	//   кул_, _троі, _döpa_, _троц
  { {0x27e0017e,0x78a20eaa,0xc60e000b,0x4b55006b}},	//   áin_, reov, िथ्य_, _гъст
  { {0xb05b008c,0xd7030248,0xb8820046,0xcfb7004f}},	//   ljät, озчи, _řídk, ילני_
  { {0xafdb0134,0x5f09000b,0x986a0015,0xb7e4000b}},	//   ncør, _सदस्_, _لحذف_, कनहम_
  { {0xd49a00ce,0x3756009a,0x63b90416,0xd9430598}},	//   трк_, _نپرس, _brwn, _фети
  { {0x66760074,0x63b90026,0xa87b000a,0xa5070054}},	//   _ندار, _crwn, _שאמר, јења_
  { {0xeb97000a,0xd5b8003d,0x8c1b004f,0xb1e60058}},	//   סדיר_, _trā_, כופי, لأجه
  { {0x2d8301c9,0x3ce0007c,0xb5ca0058,0x0000006a}},	//   xuje_, kkiv_, _جوام_,
  { {0xd5fb0008,0xb92a005e,0x2d8301df,0x1074005e}},	//   _בפבר, нкiв, vuje_, олюю
  { {0x89370053,0x2d83005c,0x29370053,0x2906008c}},	//   ירטע_, wuje_, יאטן_, inoa_
  { {0xdefb065e,0x539b0008,0xdcef0046,0x2ee5001a}},	//   тым_, _סיוו, ědčt, ólf_
  { {0xcf8e0086,0x2729002d,0x8e380015,0x3ea30030}},	//   وژی_, núna_, لسفر_, rejt_
  { {0x9fe70074,0x2c780036,0x823b000a,0xd23b000a}},	//   _نسخه, ийсь_, _בעוצ, _בגול
  { {0x6f950029,0xdb0f0eab,0x2d830eac,0x0000006a}},	// [1410] _الخض, _arcá, suje_,
  { {0x62880ead,0x5c040033,0xd357000a,0x2d830eae}},	//   ngdo, іята, יימי_, puje_
  { {0xaf340074,0xf9f90029,0x3ce900cb,0xc9870eaf}},	//   _بريت, دفاع_, phav_, рузи
  { {0xb4d5005d,0x2004002a,0x9928005e,0x6fcb0065}},	//   _सके_, źmie_, аюча_, ामपं
  { {0xe72e0010,0xc7a80029,0x97a7004a,0xf0b8004c}},	//   зе_, لدول_, ррел, ילאר_
  { {0x9a84049d,0x0f58000a,0xbae50015,0x2d730085}},	//   _мусл, סיום_, _اكسي, oće_
  { {0x5e78000a,0xf6960015,0xb9e400ce,0x272901d3}},	//   בתון_, صنيع_, _діти, gúna_
  { {0xe9190036,0xccf2000a,0x2d730085,0xd8740058}},	//   _собі_, ּ֛ה_, iće_, _واقب
  { {0x36d50001,0xa8250086,0x33920029,0x368b0eb0}},	//   _лоар, _اکان, كليز, _асен_
  { {0xa2e50004,0x24770016,0x628800cb,0xa979000a}},	//   соод, ểm_, ggdo, ְאָכ
  { {0xd9f7005d,0xa0c6002b,0xd9f9000b,0xddc70046}},	//   ंछित_, ميدو, ्पित_, dajů
  { {0xaac9005d,0xf49400ce,0xa5350138,0x8fa60138}},	//   राडक, _мрію, _унеч, баме
  { {0x2d73016f,0xc4840033,0x10160033,0x34b20015}},	//   eće_, _флік, сьня, _رموز
  { {0x63a9003f,0xd9f9000b,0xfe7a0033,0x441a004f}},	//   mwen, ्पात_, ыёмы_, _גונס
  { {0xdef90010,0x8db50036,0x6d260029,0x6e290046}},	//   рыў_, ості, معرك, řebn
  { {0xa5da004c,0x1c460033,0x6b840eb1,0x6c590054}},	//   אַמי, снам, tuig, ијус_
  { {0x60c40eb2,0xdcfc0024,0xfc2a0033,0xbd46002b}},	// [1420] _inim, gurā, ужак_, _گنجي
  { {0x4bd9004a,0x98a60085,0xb05b07c2,0x0000006a}},	//   шься_, omoć_, sjät,
  { {0xbed70053,0x60d60064,0x35bd000b,0x63a90eb3}},	//   _הויז_, _koym, ्मफ़, hwen
  { {0xe8940191,0xb05b0eb4,0x69c10046,0x5ca60a32}},	//   іаль, ljär, _šlec, _уимб
  { {0xbcb70008,0xb7960001,0xa77302a3,0x316b002a}},	//   _הפכו_, срећ, зліч, ączy_
  { {0x6ffc0024,0xef1f0064,0x8f9b0008,0x63a90177}},	//   mācī, ltür_, ריסי, dwen
  { {0x7f3b0053,0x60c4016f,0x237f002a,0xd9a50015}},	//   נעצו, _onim, eruj_, _وصفً
  { {0xdbdd032c,0x63a90012,0x98bc003d,0x7afe0eb5}},	//   zšír, fwen, īvē_, lipt
  { {0xb7f2005d,0x4bfb004c,0x969609fe,0x6ffc003d}},	//   _आइटम_, ָליס, _греш, nācī
  { {0x77e4000b,0xaa9e0033,0x6eeb04d2,0xf2c609c3}},	//   कनीक_, дзiў, _kübe, ссин
  { {0x5a9b0053,0xba9b01ac,0xef1f0061,0x6d5c0771}},	//   נשטא, נסטי, ktür_, jpra
  { {0x7afe0064,0x692c0011,0xa193017f,0x2a3b004c}},	//   hipt, _aşez, чаюч, טעימ
  { {0x7afe09f0,0x5f94006b,0x351b000a,0xf7c7000a}},	//   kipt, пият, _גואנ, ֶ֔ךָ_
  { {0xff070010,0x60c40201,0x39580eb6,0xd5a60015}},	//   сямн, _enim, _otrs_, وف_
  { {0xd578000a,0x5297000a,0xf297000a,0xab5b0028}},	//   יָּר, _הדוב_, _הכור_, _krüg
  { {0x99860050,0x657c02cd,0x69de00cb,0x6e290046}},	//   łoś_, _århu, dype, řebo
  { {0x8b580029,0x8af90785,0x6d5c0eb7,0x3078004f}},	// [1430] مجلس_, анас_, apra, _התחש_
  { {0xe5090092,0xa9c70036,0x6e990010,0x2d730085}},	//   oặc_, йсек, _твор_, pće_
  { {0x7f3c00b2,0x69670015,0x394a00da,0x96f9002b}},	//   _געזו, صداق, _cubs_, یعتر_
  { {0xad270074,0x3869002e,0x9bc704ab,0x0cab0254}},	//   _درخو, úar_, _лёгк, _стои_
  { {0x89340015,0x78a4007c,0x17c909c3,0xab840004}},	//   أعلا, õiva, ргли_, _нурк
  { {0xab5b00b8,0xe73900a5,0xb579034e,0x8f8c000a}},	//   _prüf, шел_, ащих_, רְאֵ
  { {0xd575005e,0x61040030,0xaedc004f,0x68e201d0}},	//   цуль, lőle, רקוז, bkod
  { {0xe8940010,0x63a900b8,0xd5ae0029,0xd6180015}},	//   _нась, twen, ئفي_, حتها_
  { {0x59e1005d,0x42e90001,0x63a90186,0xd36e0015}},	//   पनकर, имио_, uwen, نهي_
  { {0x63a9018b,0x68e90089,0x60c4016f,0x13020010}},	//   rwen, _hled, _snim, дзьм
  { {0x54550254,0x64c50015,0x68e90eb8,0x63a90012}},	//   _двет, _ويطل, _kled, swen
  { {0x6d5c00bc,0x6112003d,0x0000006a,0x0000006a}},	//   vpra, kāle,   ,
  { {0xb05b0123,0x7fd602a3,0x2b590eb9,0x6fd601f3}},	//   tjär, ціні, _ntsc_, цінц
  { {0x539a0008,0x68e90026,0x68e20eba,0x02440015}},	//   _כינו, _lled, zkod, _فَهَ
  { {0x3d280086,0x82370031,0xc332000a,0x98a40091}},	//   متری_, _ارشا, _חוג_, _gimė_
  { {0xb05b0044,0x70560015,0xab660033,0x6eeb0012}},	//   sjär, _بنظا, жвал, _rübe
  { {0xbf660015,0xcee9002b,0x2a7801d7,0x6d5c0ebb}},	// [1440] _بدعو, _گرين_, _pdrb_, spra
  { {0x8e860015,0x68e90077,0x394a0ebc,0x69de0ebd}},	//   _بلده, _aled, _pubs_, type
  { {0xdcfc0011,0x8c46091c,0x68e20ebe,0xfe9b000a}},	//   gură, _мене, tkod, _דיימ
  { {0x718c0053,0x319a0053,0xab5b00b8,0xc7c6004a}},	//   רװאַ, יבענ, _brüd, жски
  { {0x7d090582,0x6753002b,0xc6900015,0x4c360088}},	//   čest, وخور, ِّت_, _фэнт
  { {0x290d003f,0x68e20ebf,0xdaba0033,0x57b30033}},	//   _ejea_, skod, _тымі_, ьбіт
  { {0xc4480086,0xab5b0020,0xbb4303e7,0xa2c8000b}},	//   میان_, _prüg, _церк, ़ास्
  { {0x1517003b,0x68e90198,0xd2500086,0x88c60015}},	//   يزية_, _gled, کند_, _بتسل
  { {0xdcfc0024,0x93b30033,0x3e570046,0x442202de}},	//   ltrē, дбыц, nětí_, æk_
  { {0x35a60033,0xe3af0015,0xe5a60783,0x87f902ed}},	//   _мазг, ئري_, _мизи, _уэст_
  { {0xd3d70086,0x610400dc,0xdcfc0024,0x6f1c00ea}},	//   مبیا_, zőle, ntrē, dorc
  { {0x6b9600c0,0x361b000a,0x2366002a,0xdcf5002a}},	//   ktyg, _דובד, _twoj_, orzą
  { {0xc49b0008,0xf0440010,0xafe40033,0x6f1c0a25}},	//   _כשאת, дэро, доўл, forc
  { {0x6f1c0085,0x8e840058,0xe29700af,0x0000006a}},	//   gorc, ولُه, _даљ_,
  { {0x52130001,0xccfb0001,0x27320011,0xc27b000a}},	//   _одшт, аћа_, mând_, _כרגי
  { {0x8b670029,0x9f6b0001,0x610400dc,0xc534000a}},	//   قائم, _кроз_, tőle, לָּה_
  { {0x6f1c0188,0x2d680045,0x01340015,0x2bbb0015}},	// [1450] borc, aşe_, _تعود, جازة_
  { {0xf43b013a,0xc3340008,0x27320011,0x3c440015}},	//   שתמש, לוּ_, nând_, ذَلِ
  { {0xdcf5005c,0x68e90ec0,0xfc3f0ec1,0x9dab006b}},	//   erzą, _pled, _país_, _тъпа_
  { {0xaac9005d,0xc237000a,0x3e570046,0x39440144}},	//   राहक, קראו_, bětí_, _cims_
  { {0x99540089,0xdcfc0011,0x69ca0028,0x37ab0481}},	//   _výše_, sură, äfer, ртен_
  { {0x7bda0008,0x68e90026,0xd00c000f,0x501c000a}},	//   _הקשו, _wled, יּוֹ, בודו
  { {0x63a2001c,0xdcf5005c,0x7ce3007c,0xae7c000a}},	//   _apon, arzą, _nõrk, שְׂת
  { {0xe9180036,0x6fcb000b,0x68fb0061,0x2ca90125}},	//   _досі_, ामां, _umud, nead_
  { {0x291d005c,0x4615002b,0xe758005e,0x27320045}},	//   mowa_, _کوار, _миті_, fând_
  { {0x27320011,0x291d005c,0x386d0ec2,0x2ca90ec3}},	//   gând_, lowa_, _heer_, head_
  { {0x42250036,0x386d00f6,0x7d080107,0x6f1c0ec4}},	//   ядов, _keer_, édsk, vorc
  { {0xd59a0008,0x291d0ec5,0x45b6000a,0x659a000a}},	//   _לבעל, nowa_, _מפעל_, _ליעק
  { {0x386d0ec6,0x7ce30020,0x2d830030,0x2ca90ba4}},	//   _meer_, _tõrj, erje_, dead_
  { {0x27320011,0x386d0ec7,0x02450015,0x22590015}},	//   când_, _leer_, _عَبَ, _الغد_
  { {0x291d005c,0x2ca9002d,0x63bb0e5f,0xa9280227}},	//   kowa_, fead_, lvun, ližš
  { {0x27320011,0x317a000a,0x291d005c,0xf0660080}},	//   mâne_, _האקד, jowa_, _экип
  { {0x291d005c,0x2d8300c0,0x61e10ec8,0xa2b2000b}},	// [1460] dowa_, arje_, lyll, _असम्
  { {0xe81f005d,0x8b230080,0x4b23000d,0x6b9600c0}},	//   _बड़ा_, едуе, емув, rtyg
  { {0x6edb013a,0x7edb000a,0x386d0ec9,0x18a60033}},	//   _החיפ, _הקיצ, _beer_, заем
  { {0x27320011,0xdcf5005c,0x3eaa0012,0x291d002a}},	//   zând_, trzą, lebt_, gowa_
  { {0xdcfc0048,0x4cbb0008,0x386d003e,0x9cd7039e}},	//   strē, _הזכו, _deer_, _זוכה_
  { {0x2d980152,0x8f9b039e,0xb4b4000b,0xaf77004c}},	//   otre_, מיני, _छोड़_, לענס_
  { {0x6d460eca,0x27320045,0x291d002a,0xceb3000a}},	//   _kika, vând_, bowa_, גיו_
  { {0x2d980152,0x61e10ec8,0x89eb000a,0xdb04007c}},	//   itre_, dyll, _הַמֵ, hviü
  { {0x27320011,0x6b8402de,0x53e60033,0x6d460ecb}},	//   tând_, nrig, яцка, _mika
  { {0xdb0d03af,0x386d0111,0x248d001c,0x76480007}},	//   rvaç, _zeer_, agem_, _ugdy
  { {0x27320011,0x6b840ecc,0x6d4600f2,0x64a60ecd}},	//   rând_, hrig, _oika, _нажа
  { {0x2fc00176,0x3d16005d,0x7ce30020,0x6d460ece}},	//   _brig_, थकों_, _võrk, _nika
  { {0x27320011,0x613f0024,0x3869002e,0xe424002b}},	//   pând_, _jūli, ðari_, _تکثي
  { {0x6d46022d,0x442600b6,0x6136002e,0xd37b0008}},	//   _aika, _iyo_, jálf, _פרוט
  { {0xe29b000a,0x929b0008,0x06fd0089,0x429b0008}},	//   _השור, _היות, _říká_, _הסוב
  { {0x9075002b,0xe5090016,0x6b840dd3,0x6d460ecf}},	//   _کهکش, hặn_, frig, _cika
  { {0x2d9c01d1,0x0f270036,0x6d460d25,0x2d980ed0}},	// [1470] _även_, _ньом, _dika, atre_
  { {0x61120024,0x7cea099c,0xa3bf005d,0x6d5a0264}},	//   māla, _výra, ुमत_, ítac
  { {0x291d005c,0x752200dc,0xab5b00b8,0x6e9a000a}},	//   towa_, _okoz, _brüc, _ובתח
  { {0xf7710196,0xddde0089,0xc7b10015,0x39950ed1}},	//   نات_, _nepř, َّا_, rås_
  { {0x3f8b0064,0x61120024,0xab5b00b8,0x291d005c}},	//   nucu_, nāla, _drüc, rowa_
  { {0xd246003b,0x386d00f6,0x6d460297,0x291d0ed2}},	//   _لن_, _weer_, _zika, sowa_
  { {0x6721018c,0x5e580053,0x9f440089,0xe7160015}},	//   _vklj, ליגע_, ámé_, بيوت_
  { {0x61e1008c,0x6112003d,0x7d0d0ed3,0x63bb0ed4}},	//   vyll, kāla, nnas, tvun
  { {0x61e10026,0x53c9005e,0x6ef0007c,0xdc8c000a}},	//   wyll, ігом_, _häbe, צְהָ
  { {0x6721010b,0x7d0d0176,0x610400dc,0x61e10ed5}},	//   _uklj, hnas, dőla, tyll
  { {0x7d0d0ed6,0x2d980003,0x63bb0ed7,0x7a88004f}},	//   knas, xtre_, svun, הָרַ
  { {0x63a40011,0x63c80030,0x361a000a,0x61e10ed8}},	//   _ţine, érnö, _וועד, ryll
  { {0x61e10176,0x08760053,0x889a00a3,0x1eaa0015}},	//   syll, וערט_, חברי, ياسي_
  { {0x2d980ed9,0x6d46013c,0xada60eda,0x75290edb}},	//   ttre_, _sika, магл, llez
  { {0x2d980152,0xddc700bd,0x3eaa0012,0x7d0d001a}},	//   utre_, tajš, rebt_, fnas
  { {0x7d0d0ac1,0xd1320002,0x6112003d,0x2d980edc}},	//   gnas, _جمع_, bāla, rtre_
  { {0x83b500b2,0x2d980edd,0x0b460127,0x6136002d}},	// [1480] ופּע_, stre_, днан, tálf
  { {0x6d460ad5,0xbe660002,0xa01b0bc2,0xcaa60015}},	//   _wika, _تهدي, rgöt, بصري
  { {0x6d460048,0x7c26005c,0x9e630033,0x6136001a}},	//   _tika, _wykr, _швэд, rálf
  { {0x18670124,0xfd450010,0x395c0024,0xcb090008}},	//   даци_, _пэўн, īvs_, בל_
  { {0x7d04008c,0xda660040,0x75290085,0xa01b0a88}},	//   miis, _ياسي, dlez, lgör
  { {0x644b0ede,0x64590111,0x6eeb0064,0x752200bd}},	//   _aggi, _afwi, _lübn, _skoz
  { {0xdcf5005c,0x7ae30edf,0xaa57002b,0xe5a30054}},	//   erzę, önte, _آلفا_, вији
  { {0x290201d1,0x75290ee0,0x4254002b,0x3f8b0061}},	//   _öka_, glez, کندر, yucu_
  { {0x38660ee1,0xb7da0015,0xddde0046,0x228600ce}},	//   mbor_, _بوذا_, _vepř, мунг
  { {0x6d5e016f,0x65c6085d,0x75290089,0x51f8005e}},	//   _otpa, _обза, alez, зною_
  { {0xdcf5005c,0x752902c1,0xc4c60015,0xe8df0016}},	//   arzę, blez, _يتصو, _hiền_
  { {0xf5030063,0x6ef00123,0x3f8b0061,0x6112003d}},	//   _изхо, _näbb, tucu_, tāla
  { {0x7ce30005,0xc0e40010,0xe53b0008,0x6d5e0ee2}},	//   _kõrv, тоўк, _ותאר, _atpa
  { {0xe8df0023,0x3f8b0064,0x6112003d,0x0ca7000b}},	//   _miền_, rucu_, rāla, ख़्म
  { {0xdd94008f,0xc3480023,0xe8df0092,0xa01b0123}},	//   кары, _nổi_, _liền_, ggör
  { {0x201e0011,0x30a70292,0x3f8b0061,0x7e99002b}},	//   ştia_, _цркв, pucu_, _کندر_
  { {0xfd44008f,0x7d0d0ee3,0x6ef00012,0x386606c0}},	// [1490] тэрн, rnas, _säbe, dbor_
  { {0x0dcb010f,0x4ac9005d,0x19eb0115,0x7d0d0ee4}},	//   _думи_, राइव, يراً_, snas
  { {0xceb20053,0x212b00a9,0x7d0d001a,0xb5820033}},	//   _גיי_, olch_, pnas, _знiк
  { {0x9e040033,0xb8150099,0xe8df00a1,0xc34800a1}},	//   _шчыл, ндеј, _biền_, _dổi_
  { {0xd139002a,0x7cf10123,0x27e9001a,0x78ab00aa}},	//   mtąd_, _vård, áan_, regv
  { {0x6d580003,0xc1780091,0x38660ee5,0xf6e70138}},	//   _évac, ksė_, abor_, ьцен
  { {0x96b80015,0x38660123,0x27e907d4,0xa954008b}},	//   بانز_, bbor_, šan_, _аксі
  { {0xdb04001a,0xdcf5002a,0x7cf10ee6,0x0000006a}},	//   lvið, trzę, _fåre,
  { {0x613601b2,0x2409004a,0x68e4008c,0xe2990ee7}},	//   nále, янии_, öide, пап_
  { {0xe2990054,0x75290046,0xaad20065,0xe1610138}},	//   чао_, slez, सायक, лямi_
  { {0x91e50342,0xf6470054,0x9939004f,0x3ce90072}},	//   хоне, _цхан, ּתָה, kkav_
  { {0xdcf5002a,0x27320045,0x68f90061,0xa01b0123}},	//   przę, mâna_, _çadı, vgör
  { {0x7d040209,0x290f0ee8,0x13a7002b,0xdb04001a}},	//   viis, inga_, _آنتی_, kvið
  { {0x61360089,0x7ac4000b,0x3cfd000b,0xa01b0123}},	//   dále, राज़ी, रोसे_, tgör
  { {0x7d040209,0x7e530015,0x6da306a6,0xa0a608fc}},	//   tiis, انفص, лира, _зайд
  { {0xe0580086,0x7cea0057,0x8c960033,0x6112003d}},	//   _زیست_, _výro, эргі, mālo
  { {0x7d040044,0xdb04001a,0x249f001a,0xbb4a012c}},	// [14a0] riis, fvið, ifum_, سلان_
  { {0xda650029,0x7d040e95,0xfe42002b,0x6c330015}},	//   نامي, siis, _مکزی, افكا
  { {0xf9690036,0x10ba0008,0xbca60015,0x6112003d}},	//   дрій_, ּזְב, _كمدي, nālo
  { {0xdd2f0089,0xadd7000a,0xc8b60015,0xcb09015b}},	//   pěšn, _נוכח_, عصاب, זל_
  { {0x3c770008,0x569402e1,0x38660ee9,0x387f0034}},	//   _אתכם_, валт, rbor_, _ddur_
  { {0x290f0eea,0xa8240086,0x3f7b004c,0x4991002b}},	//   anga_, _یکشن, לאנס, _چیلر
  { {0x212b0026,0x7e9b000a,0x95970054,0x6b490091}},	//   ylch_, פסקו, етњу_, _užga
  { {0xe8df0023,0x499b000a,0x9553002b,0x9326002b}},	//   _tiền_, _משלב, دخوا, کربن
  { {0x6d3b000a,0x7ce3007c,0x0000006a,0x0000006a}},	//   התקנ, _tõrv,   ,
  { {0x877b0008,0xdb970053,0x13f30080,0xdb060030}},	//   _מאמי, עדיט_, узья, _erkö
  { {0xe6d9002e,0x27e60eeb,0xc1780091,0x61360eec}},	//   _þráð, lyon_, usė_, zále
  { {0x25d7004f,0x28c60065,0xef1f02ad,0x0000006a}},	//   _רואן_, _रोमि, grün_,
  { {0xe8df0023,0xd14a0086,0x6d5a0eed,0x27e6043a}},	//   _hiển_, _کشتن_, ítan, nyon_
  { {0x9f350036,0x26de003f,0x61360057,0x3eba00da}},	//   тегі, _joto_, vále, _capt_
  { {0xb2bb000a,0x26de0eee,0xd72d005e,0x7e7500bc}},	//   _זמור, _moto_, _лiце, razp
  { {0x6b8d0eef,0x61360ef0,0x26de0ef1,0x7cf10ef2}},	//   tuag, tále, _loto_, _sårb
  { {0x3eba0011,0x7d240067,0xfa870054,0x853b000a}},	// [14b0] _fapt_, افقن, ећем, לגלי
  { {0x26de04ed,0x61360046,0x27e609cf,0x3ce900bc}},	//   _noto_, rále, dyon_, skav_
  { {0xab5b018b,0x7b0b0024,0x249f002e,0x69070010}},	//   _grün, kļuv, yfum_, нядз
  { {0xa9540191,0x6c790053,0xdb04002e,0x290f0ef3}},	//   укці, _קאָפ, svið, unga_
  { {0x60cd003f,0xcc76000a,0x9b58006b,0x26de0ef4}},	//   _mnam, _שעשה_, _пият_, _boto_
  { {0x86980063,0xe8df0092,0xd6db0758,0x7ce30020}},	//   етът_, _biển_, яте_, _võru
  { {0x5b140292,0x27e603e4,0x60cd0847,0xa8a70ef5}},	//   _смрт, ayon_, _onam, _прак
  { {0x27e60ef6,0xe8df00a1,0x0000006a,0x0000006a}},	//   byon_, _diển_,   ,
  { {0xf6990124,0x249f0ef7,0x6f07002a,0x26de0ef8}},	//   _овај_, rfum_, kijc, _foto_
  { {0x929d0053,0x4c3c000a,0x6112003d,0x66270015}},	//   _פֿון_, התחב, tālo, _كراك
  { {0xe4e70036,0x9f440046,0xeab2000a,0x0596002b}},	//   _підн, ámí_, בֹר_, _لانگ
  { {0x23b5003b,0xd00a000d,0x67230ef9,0xf494006e}},	//   _لمؤس, деме_, lonj, _مشهد
  { {0x78bb0152,0xe2990345,0x3ae40123,0xa0670054}},	//   _mauv, _жал_, _köpt_, ђара_
  { {0x60cd0efa,0x67230375,0xdb240030,0xe2c8005e}},	//   _enam, nonj, ésün, _плід_
  { {0x8c960010,0x7c960063,0x27e60064,0xc69200a3}},	//   краі, крац, zyon_, יאם_
  { {0xfbe700a7,0xe6d9002e,0xc5f20008,0x7c850054}},	//   _thể_, _þræð, בדל_, луђе
  { {0x3eba003c,0xfeba0015,0x6fb3002b,0x1c460efb}},	// [14c0] _tapt_, _قادت_, _نميا, тнам
  { {0x60cd0dd9,0x0000006a,0x0000006a,0x0000006a}},	//   _znam,   ,   ,
  { {0xd9460efc,0x7c2902de,0xdcee0061,0x26de0efd}},	//   вежи, _øern, şkır, _roto_
  { {0xe786008f,0x8d77000a,0x0906006b,0x480a0923}},	//   вуко, _בגטו_, ъпен, меен_
  { {0x38cb0086,0x67230db2,0xbc1a005e,0x64550046}},	//   ظامی_, fonj, _ціні_, ězil
  { {0xc9860029,0xdb0f001c,0x67230962,0xdcfc003d}},	//   _لشري, _escâ, gonj, ktrī
  { {0x27e60efe,0x66e300d0,0x80b2000b,0xd90d002b}},	//   syon_, роја, ज़ाइ, _کین_
  { {0xef1f00dc,0x44b40180,0x6abc0eff,0x399c0144}},	//   erül_, убис, _harf, mís_
  { {0x26de04af,0x96960036,0xb2c60015,0x399c0f00}},	//   _toto_, _ареш, نغدو, lís_
  { {0x78bb0237,0x6723030d,0xe8df0016,0x26de008c}},	//   _zauv, conj, _tiển_, _uoto_
  { {0x68e0001a,0x399c0f01,0x04960015,0x6abc0f02}},	//   _komd, nís_, _للضح, _marf
  { {0xb97b0008,0x7cf80030,0xe4e301f3,0x7cea001a}},	//   ונטי, _hírf, _вішн, _dýrk
  { {0x399c002d,0x53b6000b,0x68e3016e,0xf8b3000a}},	//   hís_, _अनिश, êndi, בשר_
  { {0x3d9501e8,0x6ee2059d,0x0000006a,0x0000006a}},	//   лигр, _sôbr,   ,
  { {0x5e580191,0xdef8008f,0x7bc6005c,0x9e090029}},	//   тися_, тыя_, _arku, ريرك_
  { {0x853c0091,0x60cd0f03,0x3cf80015,0x8c640555}},	//   _spėj, _unam, نعقد_, итуд
  { {0x6d580152,0x7b740015,0x7b0b003d,0xbc27005e}},	// [14d0] _évan, لطلا, kļut, тєви
  { {0x8c440124,0x539b0008,0x78bb0152,0xe8df0092}},	//   ређе, וימו, _sauv, _miễn_
  { {0x61360014,0xce330086,0x78bb0152,0x69d80bfa}},	//   lála, _خودک, _pauv, øvep
  { {0xfc64010f,0xa2a9000b,0xfc3f0077,0x39150033}},	//   _върн, _जॉन्, _maíz_, ымер
  { {0x61360014,0xd3660074,0x9cd60008,0xab5b0012}},	//   nála, _ده_, _עושה_, _krüm
  { {0x2d910089,0xa5b90001,0x273b0092,0xc724005e}},	//   ouze_, ећих_, iêng_, адій
  { {0x6136002f,0x645b0f04,0xdb1d016e,0x399c030b}},	//   hála, tcui, _ersã, cís_
  { {0x38c200dc,0x91fc0024,0xce38000a,0x6abc0061}},	//   térő_, abāk, כאות_, _zarf
  { {0x07090015,0xd299005e,0xdb04008c,0x645b0f05}},	//   _كيري_, нтні_, rviö, rcui
  { {0xe8df0023,0x61e80176,0xa6f9000a,0x61360f06}},	//   _diễn_, fydl, _אִ֣י, dála
  { {0x394d049c,0x04950115,0xb146068e,0x13a7002b}},	//   _kies_, _ملاح, лнол, رنگی_
  { {0xa6e20084,0xe8d5000a,0x201e0061,0x6d5a0f07}},	//   _öðru, אוֹר_, ştim_, ítam
  { {0x61360f08,0x2d850046,0x80b3000b,0xa78c000a}},	//   gála, álen_, इज़े, ֽאלֹ
  { {0xe8d0005d,0x394d0708,0xe2990f09,0x6d410003}},	//   _सच्च, _lies_, _чак_, ïlan
  { {0x523900b2,0xd3360008,0x82d60008,0x3d28002b}},	//   _אײַנ, _גרסה_, _תוצג_, نتری_
  { {0x399c0251,0xacf50054,0xc212000a,0x6abc0f0a}},	//   vís_, ачуј, _להו_, _sarf
  { {0xdc750010,0x6abc0f0b,0x80d1000b,0x5f2a0004}},	// [14e0] рысь, _parf, धारे, _поим_
  { {0x80a0014e,0x89f6008f,0xa3d4000b,0x7cf10123}},	//   ग्रे, ляец, हमत_, _våra
  { {0x7ce30005,0xcd360029,0x6abc00c0,0xe704002b}},	//   _võrr, _مرحب, _varf, یستی
  { {0x6abc0f0c,0xdb0f0144,0xb86500c3,0xa87600c3}},	//   _warf, _escà, لاهو, اطات
  { {0x62830f0d,0x394d0f0e,0xa9250015,0x98730033}},	//   _odno, _dies_, جعله, сліц
  { {0x3f720024,0xd5b00029,0x7bcb000a,0x394d0b35}},	//   iņu_, قفت_, _אֶלֶ, _eies_
  { {0xfa77000a,0x6a9b000a,0xa6c70015,0xdb230030}},	//   _תעלת_, _רשלנ, طويل_, _óráj
  { {0x2904000c,0xc4480086,0xfc3f02c1,0x62830b90}},	//   _umma_, نیان_, _raíz_, _adno
  { {0xd250003b,0x9cd70008,0xe78a0086,0xc6960015}},	//   ينة_, רופה_, _سپاه_, _مشاع
  { {0x61360014,0x7cf800dc,0xe8df0092,0x3f720024}},	//   vála, _hírd, _viễn_, dņu_
  { {0x6234023e,0xb1150342,0xe6160004,0xf1a301c5}},	//   рену, имош, _сфаќ, брян
  { {0x6136002d,0x361b000a,0xe8df0016,0x62830f0f}},	//   tála, _אובד, _tiễn_, _edno
  { {0x8cbf005d,0xe47b0053,0x29370053,0xe4e90015}},	//   _लोगो, _טראכ, טאטן_, _جعله_
  { {0x4383003b,0xb3bb0008,0xbe650029,0x61360f08}},	//   _الوق, _נמוכ, شهري, rála
  { {0x61360f10,0x6d580152,0xeca7000d,0x9f440089}},	//   sála, _éval, лјан, ámá_
  { {0x55770053,0x61360f11,0x319b000a,0x3eb102ad}},	//   טעלן_, láln, _נבחנ, sezt_
  { {0xe8df00a7,0x1bd400a4,0xab95005e,0xab5b0012}},	// [14f0] _hiện_, ботя, ризі, _trüm
  { {0xe8df0023,0xab940036,0x63bd02de,0x394d0b35}},	//   _kiện_, сифі, æsni, _sies_
  { {0xc333000f,0x127b004c,0x394d0f12,0x28c6000b}},	//   צוע_, גאבע, _pies_, _रोहि
  { {0xd7f10029,0x2fc900dd,0xc052000a,0xdbeb0030}},	//   يكا_, _krag_, ַ֖ד_, lőír
  { {0x61360107,0xbc19000a,0x960d000b,0xdcee0091}},	//   káln, _יוֹש, िप्ट_, erbė
  { {0x2f5c000a,0xb8080015,0x394d0012,0x7bc80643}},	//   עדונ, ديهم_, _wies_, _עֶרֶ
  { {0x8aa40191,0xf7730086,0x45190f13,0x6d4f003f}},	//   _уряд, _گاز_, кция_, _kica
  { {0x7cf80f14,0x2bc9000b,0xed58000a,0xf42904e7}},	//   _vírg, रिपा, נבחר_, койл_
  { {0x54a40029,0x28f80a61,0x61360247,0x6d4f0f15}},	//   صحيف, _сеть_, fáln, _mica
  { {0xe8df0092,0x42550e88,0x03a800e6,0xfbd20008}},	//   _biện_, штит, اديو_, קתי_
  { {0x7cf800dc,0x6b8d0273,0x95570015,0xab5b0061}},	//   _híre, hrag, _إخطا, _brük
  { {0xe8df0023,0x3f720024,0x0fc60036,0xe04601e5}},	//   _diện_, tņu_, аймн, инни
  { {0x61120024,0x613d00dc,0x3f72003d,0x2d850046}},	//   nāli, zélg, uņu_, šlel_
  { {0xdcee0089,0x7cf8002d,0x2fc90f16,0xf1f90015}},	//   ědče, _míre, _drag_, _لعبت_
  { {0x2d9e038d,0x6d4f08c0,0x6b8d0273,0x65c00046}},	//   îte_, _bica, erag, máhá
  { {0x3fe60036,0x6b8d0f17,0x82340015,0xa2cd000b}},	//   _вжив, frag, _ارها, ताक्
  { {0x61360014,0x70b2005d,0xca560004,0xdbc70012}},	// [1500] lálo, ज़ील, атењ, rößt
  { {0xff7b0053,0x0f7b000a,0x7bc40f18,0x3ae8009a}},	//   _שטימ, _שאיב, rviu, دبری_
  { {0x6d4f03af,0x61360f19,0x6b8d0f1a,0x442f0091}},	//   _fica, nálo, arag, _lyg_
  { {0x2c5c005c,0x3ead016f,0xdbdc0f1b,0xf9890018}},	//   _bądź_, đete_, lšíc, اخله_
  { {0xd117000a,0x26350016,0x3a26002a,0x6b8d0f1c}},	//   סקנה_, _áo_, łop_, crag
  { {0x7cf8002f,0x6d440026,0x613d00dc,0xae0b000b}},	//   _díre, lmia, méle, _हेडन_
  { {0xd5b00029,0x613600dc,0x613d0030,0x7e7c01c2}},	//   سفة_, váln, léle, iarp
  { {0x54b80063,0x61360046,0x6112003d,0x7d160f1d}},	//   угия_, dálo, bāli, nnys
  { {0x2bc9005d,0x7e7c0f1e,0x93770033,0x613d0030}},	//   रिया, karp, абыт_, néle
  { {0x41c60010,0xdbdc0227,0x46f4000a,0xa79b000a}},	//   аёма, jšíc, _פֶּן_, _בשמח
  { {0x20d50029,0xdcf60046,0xd250002b,0x2a57000a}},	//   مقدس, ýběr, ينک_, יבין_
  { {0xab5b018b,0xe8df0023,0xb3560086,0x7e6e00c0}},	//   _früh, _viện_, _پیدا_, ebbp
  { {0x7cf10293,0xb4fb000a,0x6d44002a,0x61180033}},	//   _dårl, _בלאר, dmia, рояў_
  { {0x7e7c00c0,0xe8df0092,0x613600dc,0x6b8d0f1f}},	//   garp, _tiện_, láll, vrag
  { {0x13b6014e,0xab5b03ff,0xfff60086,0x433b000a}},	//   _अनुभ, _trük, لکیت_, _שעוב
  { {0x613600dc,0x6b8d0f20,0xccf80054,0x9099006b}},	//   náll, trag, аћу_, _свит_
  { {0x113c0008,0xfbd00015,0xdd2f0046,0x6b8d0f21}},	// [1510] _בתהל, وتك_, _těžb, urag
  { {0xf9c70f22,0xb4e3000b,0x03d7000a,0x7d160034}},	//   ищен, _नक्_, בומם_, anys
  { {0x6d4f0064,0x39580f23,0xdeb6000a,0xba740021}},	//   _tica, _curs_, _הפתח_, زالت
  { {0x61120024,0x58870033,0x39580f24,0x6b8d0f25}},	//   tāli, рыжа, _durs_, prag
  { {0x9cd6000a,0x7d0d0f26,0xa7a90054,0xab8401c5}},	//   _הורה_, mias, укла_, _мурк
  { {0x61360014,0xb882002e,0x7cf8002d,0x61120024}},	//   eáll, _þíni, _víre, rāli
  { {0xeef8000a,0x05680054,0xa5090076,0x02e0000b}},	//   שמור_, ајњи_, лека_, _पकड़न
  { {0x201e0011,0x61360f27,0xd6180015,0x7cf80125}},	//   ştii_, gáll, جتها_, _tíre
  { {0x57f5000d,0xe5040029,0xe3b10015,0x7cf80030}},	//   _упат, تبوي, سرة_, _hírc
  { {0x6d44005c,0xd346002b,0x8c1c000a,0x387d0034}},	//   zmia, مینه_, כוחי, lawr_
  { {0x7e7c002e,0x613d00dc,0x6d4409bf,0x8afa000a}},	//   varp, zéle, ymia, רפתק
  { {0x3f6a0124,0x387d0026,0x7d0d003f,0x1636000a}},	//   лимо_, nawr_, jias, _הנער_
  { {0x320b005c,0x7e7c0f28,0xe536000a,0x88ba004c}},	//   ńcy_, tarp, _פטנט_, נזשי
  { {0x083a0053,0x613d0f29,0x6136001a,0x645d0091}},	//   טערל, véle, málm, žsid
  { {0x51950029,0x527a004c,0x7d0d0f2a,0x412a024f}},	//   _العذ, _ענקא, fias, _йоко_
  { {0x4bda0080,0x1d07000d,0x7d0d0f2b,0xe1f0002b}},	//   льзя_, беси_, gias, _تسه_
  { {0x6136002c,0x4aaa0f2c,0xdbdc0107,0x6d440f2d}},	// [1520] nálm, лкан_, pšíc, rmia
  { {0x613600dc,0xca560054,0x6b8b0030,0xaad2000b}},	//   záll, стањ, ágga, साइक
  { {0x8e570053,0xc8790064,0x387d0026,0x1e57000a}},	//   _לייג_, _beş_, fawr_, _לשיר_
  { {0x27320011,0x3f82005c,0xd943006b,0x7c960c30}},	//   mâni_, osku_, пехи, _уроц
  { {0x2bc9005d,0xccf30008,0xa03a0053,0x02b7000b}},	//   रिणा, _זכר_, װײַז, _असंभ
  { {0xb8ef014e,0xbb4300fd,0x3b0a004a,0xdc37004c}},	//   _वो_, _неяк, _сего_, _לאכט_
  { {0xceb30008,0x61360030,0xa4d80342,0x3e5b004f}},	//   פיה_, táll, идку_, נדקס
  { {0x8a170008,0xdb1d00c0,0x4d7b0053,0xba17002b}},	//   _החלו_, _ersä, ארקע, _ايفا_
  { {0xe73a0083,0x61120024,0x2418054f,0x3f820f2e}},	//   _беа_, nālu, ропы_, jsku_
  { {0x2bc9005d,0x27f90020,0x66e50015,0xd7020033}},	//   रिता, _üsna_, _وألق, _пiса
  { {0xd2500002,0x7d0d01c2,0xe6c50015,0xd6eb000a}},	//   بند_, yias, _بتقي, _עַמָ
  { {0xca370008,0x3a3701e4,0x463b0053,0x613600dc}},	//   מניה_, מרים_, _געבע, lálj
  { {0xdcee0024,0xdb0d001a,0x39460533,0x7d0d0f2f}},	//   arbī, kvað, imos_, vias
  { {0x61360014,0x28cf005d,0x7d0d005c,0x539b000a}},	//   nálj, _सोनि, wias, _עיוו
  { {0xc27b00b2,0x427b0008,0xae45002b,0xdb0f0030}},	//   _גרוי, _גאוג, زپرو, ódít
  { {0xe2170008,0xdb060030,0xdcf5003d,0x0217004f}},	//   _לקוח_, _eskü, muzī, _לחום_
  { {0x212b002c,0xfc330015,0x9962006f,0x61360030}},	// [1530] moch_, سحر_, _ríše_, kálj
  { {0xda670029,0x6e950029,0x39460f30,0x4095002b}},	//   صائي, _بلدا, emos_, _الکر
  { {0xdcfc0024,0xb9b50225,0x48790010,0x99620107}},	//   gurē, تماع, асля_, _píše_
  { {0x9cb50029,0x38580015,0x212b0f31,0x319b015b}},	//   _بمحت, مشهد_, noch_, רבאנ
  { {0x69d8008c,0x7d1d0f32,0xe72e0f33,0x6d5a04b2}},	//   äver, _ijss, де_, ítav
  { {0x613600dc,0x212b0f34,0xd00c000a,0x85b90015}},	//   gálj, hoch_, טּוֹ, لابس_
  { {0x05790029,0x212b002c,0x286b049d,0x13d1000b}},	//   جمعة_, koch_, _брзо_, तम्भ
  { {0xe9190036,0x212b002c,0xfdf8000a,0xf8ae002b}},	//   _тобі_, joch_, מצות_, _لکه_
  { {0x613600dc,0x212b0f35,0x9f4e0046,0x290f0f36}},	//   bálj, doch_, žném_, miga_
  { {0xf6f50074,0x290f0f37,0x13090080,0xdb1d0c77}},	//   _بزرگ, liga_, рной_, _ursä
  { {0xc1060015,0x61460923,0xf7480015,0x0477002b}},	//   قودي, жена, _اللي_, _هلاک_
  { {0xa4f70086,0x290f0f38,0x3f8206cf,0xa2a9021e}},	//   _دکتر_, niga_, tsku_, _जॉर्
  { {0x613600dc,0x3f840107,0xe8d6000a,0x290f007c}},	//   lálk, ému_, קושר_, iiga_
  { {0x7cea002e,0x68f8003d,0x3f820f39,0x236d0085}},	//   _nýrr, īvdi, rsku_, mpej_
  { {0xdd920002,0x6cc60afb,0x91650067,0xd589000a}},	//   ظور_, ойва, _بهبه, יָּ֨
  { {0x613600dc,0x61120024,0x22140010,0x290f01a3}},	//   zálj, tālu, _эфір, jiga_
  { {0x6ef00005,0x290f0f3a,0x2d91002a,0xdd2f0046}},	// [1540] _läbi, diga_, arze_, běžn
  { {0xdcfc0048,0x2d91005c,0x38cb0086,0x60c40d4e}},	//   turē, brze_, یانی_, _haim
  { {0x613600dc,0x40930086,0x60c40f3b,0x6da60015}},	//   válj, _علیر, _kaim, _بمجم
  { {0x290f0020,0x61360f3c,0xc212000a,0x6112003d}},	//   giga_, dálk, והב_, māls
  { {0x39460f3d,0x87ba0080,0xdb040111,0x39400024}},	//   rmos_, рует_, ntië, ķis_
  { {0x6b84002f,0xc58a0080,0x3eb80f3e,0x758a068e}},	//   msig, ащие_, nert_, асив_
  { {0x613600dc,0x290f007c,0x4e8b000a,0x3eb80f3f}},	//   rálj, biga_, שָׂ֣, iert_
  { {0x443d018b,0x3eb800b8,0x60c40f40,0xddd50046}},	//   _bzw_, hert_, _naim, nazš
  { {0x14a6000b,0x212b006f,0x3eb80f41,0xa68605a7}},	//   क्षण, voch_, kert_, _млад
  { {0x61360f42,0x2002005c,0xd25a0001,0xa6f8000a}},	//   lálh, dzki_, шци_, _פִּי
  { {0xd62a0080,0x1a9b0053,0x4a5b0008,0x7ae300f2}},	//   _тоже_, סיטע, ידיו, önti
  { {0x61360014,0x613d002e,0x2d980f43,0xdb1d0144}},	//   nálh, féla, dure_, _essè
  { {0x60c40f44,0x212b0f45,0x3eb80f46,0x2d980ad3}},	//   _daim, roch_, fert_, eure_
  { {0x2d91005c,0x6b840f47,0x212b0f48,0x539b000a}},	//   trze_, dsig, soch_, _כידו
  { {0xfe540010,0x2d850f49,0x41e60484,0x77f8000b}},	//   дкрэ, éle_, _філа, ्छुक_
  { {0x2d83005c,0x01fb0008,0x60c40f4a,0x2d8d013b}},	//   rsje_, _כפול, _gaim, čee_
  { {0x2002005c,0x6b840035,0x3eb80f4b,0x2d470034}},	// [1550] czki_, gsig, bert_, _bŵer_
  { {0xad670029,0xdb040152,0x80a7005d,0x8aa70033}},	//   _واجه, ntiè, ट्रे, ўрад
  { {0x63bb00b8,0xc984005e,0x2ca90012,0xb05b008c}},	//   zwun, дучи, pfad_, ydäl
  { {0x6367002c,0xab5b0012,0x52b7000b,0x7cf80030}},	//   nčný, _brüt, _अस्स, _hírn
  { {0x3f990064,0xb8e3000b,0xd7f80054,0x290f0f4c}},	//   nusu_, _ऍस_, жуј_, riga_
  { {0x290f0f38,0xb579004a,0x61360307,0x47c40033}},	//   siga_, бщих_, tálk, ьбів
  { {0x3f990f4d,0x5e780008,0x7cf80089,0x6367002c}},	//   husu_, חתון_, _mírn, kčný
  { {0xd5ae0029,0x9f4400dc,0xf7bb0086,0x3eb80030}},	//   افي_, ámú_, _پدرش_, zert_
  { {0xb8ff005d,0x13090036,0x48fa0053,0xdc88000a}},	//   ता_, йний_, _פּלא, חְתָ
  { {0xa2050036,0x63bb00b8,0xe29907c1,0x3f990f4e}},	//   зпод, rwun, љан_, dusu_
  { {0xcb1200a3,0x3eb80f4f,0x6136016e,0xd5d40015}},	//   תלי_, vert_, láli, _يتمث
  { {0x443d005c,0x3eb800b8,0x7985003f,0x6b840f50}},	//   _tzw_, wert_, ishw, ysig
  { {0x3eb80f51,0x26c500e8,0xe28e0f52,0x60c40209}},	//   tert_, _kalo_, _па_, _vaim
  { {0x3eb800b8,0x2d980376,0xc2c50015,0x72c4005e}},	//   uert_, ture_, _ريبي, _обіз
  { {0x3eb806f5,0x57b8005d,0x27320011,0x2002005c}},	//   rert_, _इन्ह, mânt_, szki_
  { {0x3eb80f53,0x26c50035,0xab660f54,0x3ea10f55}},	//   sert_, _lalo_, звал, _echt_
  { {0x3f990064,0x613600dc,0xed350010,0x2d980376}},	// [1560] cusu_, válh, фэрэ, sure_
  { {0x2d9802d7,0x6b840e32,0x62810f56,0x613603bc}},	//   pure_, rsig, nalo, dáli
  { {0xc4bd000b,0x3a990033,0x68e90f57,0xd910002b}},	//   ्याओ, ўтую_, _boed, نیس_
  { {0xc7c60080,0xb05b00f2,0x68fb0026,0x68e90335}},	//   зски, ydäm, _clud, _coed
  { {0x68e90026,0x613600dc,0x6d5e003f,0xab5b0012}},	//   _doed, gáli, _hupa, _drüs
  { {0x6d5e0f58,0x8b8b000a,0x62810f59,0x7e7e0f5a}},	//   _kupa, _לָלֶ, jalo, _jepp
  { {0x62810f5b,0x613d0089,0xbb430f5c,0x69da0f5d}},	//   dalo, déln, _черк, _štef
  { {0x68fb0026,0x7cf80089,0x212001a3,0x68e90f5e}},	//   _glud, _míro, _njih_, _goed
  { {0xd4670001,0xe3c30015,0x6d5e0f5f,0x26c5016e}},	//   чиње_, فْيَ, _lupa, _falo_
  { {0x98b800df,0xe3af0196,0xd7fb000a,0x26c50f60}},	//   _kurį_, اري_, _ההמל, _galo_
  { {0x40950015,0xd4d60033,0x6d5e003d,0xb5ca0067}},	//   ولدر, _нідэ, _nupa, _دوام_
  { {0x63a40011,0x93aa0029,0x64a60033,0x6281007c}},	//   _ţinu, _هاتف_, _хада, aalo
  { {0xe5050086,0x6d5e0f61,0xdb040003,0x6367006f}},	//   _تبلي, _aupa, ptiè, rčný
  { {0x628a0134,0x6d5e00e8,0x3f990f62,0x7e7e02b9}},	//   _udfo, _bupa, rusu_, _cepp
  { {0xdd910029,0x271b004c,0x1df801b0,0xadbd0033}},	//   ضوء_, צולײ, перы_, шавi
  { {0xc19b000a,0x65c70046,0xdf58002b,0x291c0f63}},	//   _השהי, léhá, _کشيش_, éval_
  { {0x68e90b7c,0x201e01e2,0xd0080124,0xb05b00f2}},	// [1570] _roed, ştir_, _неће_, hdäk
  { {0x61360f64,0x7cf800dc,0x7e990087,0x3ea1002d}},	//   váli, _hírl, _بندر_, _ucht_
  { {0xed580083,0x68e90079,0x68fb0f65,0x613d0f66}},	//   _ноќ_, _poed, _plud, nélo
  { {0xf9900225,0xd8390033,0x89370015,0x61360f67}},	//   ابل_, опец_, أعطا, táli
  { {0x2b930074,0x68e9016b,0x263c0016,0x6d5e00bc}},	//   _سیاس, _voed, _ảo_, _zupa
  { {0x8f9c00f3,0x68e90079,0x9b45002b,0x45d50923}},	//   מידי, _woed, _آنسو, дцит
  { {0x273204f9,0x26c702c6,0x62810f68,0x3752002b}},	//   vânt_, rdno_, valo, خپوس
  { {0x5dfc000a,0x6281002a,0x6136013f,0x657a0416}},	//   מפונ, walo, páli, _dwth
  { {0xa2a1005d,0xf7940010,0xd794006b,0xf8b2000a}},	//   _खाद्, _патэ, _питъ, _בשן_
  { {0x613600dc,0x21cc0046,0x7bcd0003,0xed640046}},	//   nálv, _běh_, ivau, naží_
  { {0x63a404f9,0x387f00dd,0x613d0030,0x657a0034}},	//   _ţint, _keur_, réln, _gwth
  { {0xdb040077,0x2d8c0046,0x6d5e0f69,0x62810f6a}},	//   rtié, ádem_, _rupa, salo
  { {0x73e40036,0xa5140053,0x6d5e0f6b,0x62810f6c}},	//   _поїз, _אַװג_, _supa, palo
  { {0x387f038d,0x249f0f6d,0x63a90f6e,0xed5a009b}},	//   _leur_, lgum_, mten, жов_
  { {0x63a90f6f,0x613d0030,0xd10a0040,0x6da304bb}},	//   lten, célo, _وقته_, кира
  { {0x249f09f0,0x20560f70,0x417a000a,0x63a90f71}},	//   ngum_, _отпр, _ונקב, oten
  { {0xe8df0023,0x9f860033,0x38c60091,0x0aea01f3}},	// [1580] _chọn_, _ўгод, _jūrų_, одай_
  { {0x6a16002b,0x63a90f72,0x6d5e0f73,0xf1b1000b}},	//   وبار, iten, _tupa, _जहान
  { {0x8ca6005d,0x89f50010,0x6edb000a,0x7edb000a}},	//   _छापो, няцц, _וחיפ, _וקיצ
  { {0x63a90f74,0xa934002b,0xd6cf009a,0xef1f007f}},	//   kten, رباچ, یقن_, nsün_
  { {0x387f0f75,0x4cbb000a,0x38cb002b,0x3f7a004c}},	//   _deur_, _וזכו, تالی_, קאַס
  { {0x6136002e,0xdcfc0007,0xb7d70015,0x2ca0007c}},	//   málu, turė, بوها_, lgid_
  { {0xceb30008,0x613600dc,0x63a90f76,0x28cf000b}},	//   דיו_, lálu, eten, _सोवि
  { {0x2ca00020,0x249f002e,0x61280064,0x89d70029}},	//   ngid_, ggum_, nıld, _توفر_
  { {0x2ca00020,0x7791002b,0x69e30045,0x63a90f77}},	//   igid_, _مینا, ăteş, gten
  { {0x27320045,0xb5da0015,0x574307be,0xf5b60058}},	//   râns_, _وباء_, _ануб, _يصاد
  { {0x61280064,0x546a055f,0x61150f78,0x63a90f79}},	//   kıld, _даем_, едну, aten
  { {0x7bcd0007,0x05770015,0x61360030,0x2fd2002a}},	//   yvau, _آمنة_, zálv, _bryg_
  { {0xfebb0086,0x24f70010,0x40950086,0xa294017f}},	//   ياست_, _іншы_, ولگر, _залі
  { {0x2ca0007c,0x6b96002a,0xc43b000a,0x248402ad}},	//   egid_, dryg, _ותדי, lamm_
  { {0xfcc70001,0x929b0008,0x613600dc,0xd2b7000a}},	//   мљам, _ויות, válv, _חלות_
  { {0x6c550004,0xa2d60065,0x0000006a,0x0000006a}},	//   екбу, बाक्,   ,
  { {0x2bbb0015,0x7bcd008c,0x61360030,0x8aa70719}},	// [1590] غارة_, uvau, gálu, дред
  { {0xab940036,0x7bcd0f7a,0x20dd000b,0x2d850f7b}},	//   тифі, rvau, यावध, áles_
  { {0x387f0152,0x5ee8000a,0x891f004c,0x61360030}},	//   _peur_, _חַרְ, אַר_, rálv
  { {0x6f150064,0xa2150053,0xf77100e6,0xdcf5003d}},	//   lizc, ײַעס_, هات_, irzī
  { {0x32050f7c,0x63a90f7d,0x6d4d0f7e,0x366901eb}},	//   zzly_, xten, mmaa, пало_
  { {0xd2460f7f,0x4f9c0008,0x613600dc,0x6d4d0f80}},	//   _من_, קבוצ, lált, lmaa
  { {0xe613002b,0x6d4d0577,0x38600f81,0xa8a70f82}},	//   خشش_, omaa, žira_, _орак
  { {0x613600dc,0x6d4d0f83,0xc984023e,0xe3b1002b}},	//   nált, nmaa, _јури, هرخ_
  { {0x249f0084,0x6d4d00f2,0x9475002b,0x6f150061}},	//   rgum_, imaa, ودکا, kizc
  { {0xe3c80023,0x63a90f57,0xc2c50015,0x61280061}},	//   _dự_, rten, ريجي, zıld
  { {0x613d00dc,0xe1f10018,0x61280061,0x61360030}},	//   mélj, اسخ_, yıld, kált
  { {0xcea9013a,0xd576000a,0x63a90f84,0x04c80058}},	//   _לי_, _נתנה_, pten, _يولي_
  { {0x251a0053,0x6d4d0234,0x68fa004c,0xdb1d0f85}},	//   _צונא, dmaa, פּטװ, _assí
  { {0x201e0011,0x6d4d0f86,0xf772000a,0x61360030}},	//   ăti_, emaa, רקם_, válu
  { {0xe816005d,0x6561001c,0x61280064,0xc6920053}},	//   _देना_, _julh, tıld, טאם_
  { {0x656103af,0x61360f87,0x6d4d0f88,0xaac6002b}},	//   _mulh, gált, gmaa, کترن
  { {0xf1c90092,0x61280064,0xac0a000d,0x711b000a}},	// [15a0] _hạ_, rıld, чнаа_, _מוקפ
  { {0x6d4d0f89,0xab930015,0x61280061,0xb0ac000b}},	//   amaa, اللغ, sıld, ट्रग
  { {0x61280064,0x613600dc,0x9e7b000a,0x22f6004c}},	//   pıld, bált, _מניפ, עזען_
  { {0xe9730086,0x6d4600f2,0x01fa000a,0xc7ca004a}},	//   اهند, _uhka, הפעל, зыке_
  { {0xf1c90092,0xe73a0419,0xf093000a,0x69c302de}},	//   _lạ_, пед_, רנד_, æner
  { {0x8f9b00b2,0xc6f705d1,0x7bc60f8a,0xe5c608c9}},	//   פיצי, нніх_, _isku, есио
  { {0xe3c800a7,0xd5b7004a,0x64bd000b,0x61360307}},	//   _sự_, есы_, ्यूश, náls
  { {0x35c5005d,0x273b0092,0xaa570015,0x38c8002b}},	//   विज़, hênh_, _ألفا_, _غازی_
  { {0xd90d0074,0xe8b501e2,0x7d0400f2,0x465a0021}},	//   _بین_, lışı, ihis, _فؤاد_
  { {0x55e60036,0x51f80036,0xf1c90092,0x81d40a61}},	//   _позб, дною_, _bạ_, воох
  { {0x7cf80089,0x6136002e,0x9f440089,0x7d040f8b}},	//   _círk, jáls, ámý_, khis
  { {0xe3c80023,0x753b0011,0x7bc60abb,0x78a20522}},	//   _tự_, cluz, _osku, ngov
  { {0x0457003b,0x61360014,0x7d160064,0x656101c2}},	//   _كلمة_, vált, diys, _zulh
  { {0x1ee70074,0x3ea50014,0xe8b50061,0xa29401f3}},	//   روزی_, ült_, kışı, _ракі
  { {0x613d0030,0x61360030,0x6d4d0f8c,0x7bc607c2}},	//   nélk, tált, tmaa, _asku
  { {0x563700b2,0xd9040074,0x23b7005d,0x823b000a}},	//   גאלע_, _طی_, _अहमद, _מעוצ
  { {0x628e005c,0x61360f06,0x78a201a3,0xdb23002b}},	// [15b0] óbow, rált, dgov, هوری
  { {0xadf5008f,0xab180036,0x6d4d0f8d,0xdc45003d}},	//   _апош, нієї_, smaa, mīļo
  { {0xf1c90092,0x6d4d0234,0xceb2000a,0x7aee0030}},	//   _xạ_, pmaa, _דיי_, _dobt
  { {0xf0940053,0x57f50004,0x38c9002b,0x91fc003d}},	//   ָנס_, кпет, بائی_, ecāk
  { {0xdddc0f8e,0x613d0030,0x46a5029b,0xb6a5098b}},	//   parţ, télj, валв, вилл
  { {0x613d0030,0x78a2036d,0x0000006a,0x0000006a}},	//   félk, agov,   ,
  { {0x2bc9005d,0x49c80033,0xd6260054,0xe5e10033}},	//   रिका, _плён_, коше_, рылi_
  { {0x9ddc0008,0x69c70085,0x613d0030,0x3ce9013b}},	//   לקוח, _isje, sélj, njav_
  { {0x3f8b005c,0xf3f10015,0xd4680021,0x443902de}},	//   jscu_, شأة_, رحيم_, æs_
  { {0x69d5005c,0xdcfc0024,0x7790002b,0x42e9005e}},	//   _krze, turī, _ایوا, ємно_
  { {0x3f8b0011,0xb0dd000b,0xc2420342,0x65940f8f}},	//   escu_, यांग, иньк, _баху
  { {0xdddc0085,0xef1f0030,0x7412002b,0xf1c90016}},	//   jarš, ssül_, اویا, _vạ_
  { {0xc95200b2,0xa78c000a,0xc2c50015,0x0000006a}},	//   ימט_, ּאלֹ, _ليشي,
  { {0x78a2010b,0x69c7016f,0x69d5005c,0xe8b50064}},	//   zgov, _osje, _orze, yışı
  { {0x7d160061,0x6e930015,0x386d0f90,0x7d040f91}},	//   tiys, ؤلفا, _ofer_, this
  { {0xad390036,0xa3d5000b,0x7aee0144,0x6136006f}},	//   ечує_, हिप_, _sobt, ráls
  { {0xc0c90054,0xa03a0021,0x7d160f0a,0x5baa02a3}},	// [15c0] _чује_, _تأثر_, riys, ькам_
  { {0x69d5005c,0xe8b50064,0x62830f92,0x7d160727}},	//   _brze, tışı, _jeno, siys
  { {0x7bc6005c,0xf969005e,0xba170015,0xc332015b}},	//   _wsku, ерій_, نيكا_, סוב_
  { {0x69d5005c,0xe8b50064,0xcb09000a,0x2900016e}},	//   _drze, rışı, חל_, óia_
  { {0x69d500b8,0xf74a0015,0xe7b40015,0xdb080125}},	//   _erze, وجته_, امتد, ólót
  { {0x4733042b,0x62830f93,0x7cf10f94,0xe8b5007f}},	//   аніс, _neno, _hårp, pışı
  { {0x27e004f9,0x69d5005c,0xceb30008,0x69d80134}},	//   ţin_, _grze, ייג_, æved
  { {0x23ab0134,0xb8650015,0x2cb20034,0x0000006a}},	//   føj_, _ماكو, nfyd_,
  { {0x7d030011,0x6d3b000a,0x3957000a,0x69d5002a}},	//   _înse, ותקנ, _ישלם_, _zrze
  { {0x6e290064,0x7cf8002d,0xdc370053,0xe6c50015}},	//   şebi, _díri, כאפט_, _متمي
  { {0x26de003e,0xe816005d,0xcb130008,0xba9b0008}},	//   _into_, _देता_, שלת_, וסיי
  { {0x7cf80125,0x51f70174,0xf9460138,0x0000006a}},	//   _fíri, тнюю_, ннiк_,
  { {0x33940f95,0x62830f96,0xb4fb004f,0x0ede0065}},	//   _салё, _feno, _קלדר, मांड
  { {0x2cb20026,0x62830f97,0x80a5000b,0x63a0007c}},	//   efyd_, _geno, _कावे, mumn
  { {0xd7880023,0x82330086,0xb2bb000a,0x6288089f}},	//   hể_, _پروا, _חמור, mado
  { {0x26cc047e,0x3ead0046,0x7e620045,0x62880f98}},	//   _lado_, řet_, _şopt, lado
  { {0xac180001,0x7c840a8c,0x26de0f99,0x613d0030}},	// [15d0] воту_, русе, _onto_, vélh
  { {0x69d50f9a,0x613d0f9b,0x62880f9c,0xdd1c01c0}},	//   _prze, déli, nado, _vášn
  { {0x61280064,0xf9c70063,0x60cd0f9d,0xbd4b0015}},	//   lıla, ъщан, _kaam, _يؤجل_
  { {0xf1b30053,0xa3d5000b,0x19940033,0x60cd05ff}},	//   יסע_, हिम_, раця, _jaam
  { {0x612801e2,0x26cc000c,0x69d5005c,0x6d5d0035}},	//   nıla, _bado_, _wrze, _iisa
  { {0x69d50050,0xdb0f0144,0x6d5d0a38,0x62880f9e}},	//   _trze, _escò, _hisa, jado
  { {0x7cf80341,0x26cc0656,0x62880f9f,0xdb04016e}},	//   _síri, _dado_, dado, stiã
  { {0x25b60086,0x23ab0134,0x45180010,0x6b4b00dc}},	//   اهيد_, tøj_, кцыя_, függ
  { {0x6b8d03af,0xed110023,0x6d5d0fa0,0x62880fa1}},	//   nsag, _đối_, _misa, fado
  { {0x6d5d0407,0x61280064,0xf772000a,0x26cc016e}},	//   _lisa, dıla, _לקמ_, _gado_
  { {0xa1890010,0x3495000d,0x8a16000a,0x62830fa2}},	//   эбна_, _баер, ָ֗יו_, _veno
  { {0xd5fa0053,0x6d5d0fa3,0xd00a0fa4,0xd919000a}},	//   _אפער, _nisa, ееме_, תוֹל
  { {0x61280064,0x80a5000b,0xe2990fa5,0x62880fa6}},	//   gıla, _कारे, _зал_, bado
  { {0x3392003b,0x48160053,0x539a0008,0x6b8d0f47}},	//   _الوز, אַלן_, _ניצו, dsag
  { {0xdef90010,0xb1760016,0x91fc003d,0x6d5d0fa7}},	//   тыў_, _trượ, zbāz, _bisa
  { {0x61280064,0x721a000a,0x6d5d0fa8,0x6b8d001a}},	//   bıla, _רוקח, _cisa, fsag
  { {0x612801e2,0x6b8d0fa9,0xf093000a,0x6d5d0faa}},	// [15e0] cıla, gsag, _הנח_, _disa
  { {0x4e36006e,0x613d0fab,0x09e60fac,0x0dca0088}},	//   _معجز, véli, лозн, _злой_
  { {0x6b8d02f2,0x49ba0015,0x26cc0fad,0x98f60033}},	//   asag, عائد_, _rado_, лядч
  { {0x32360053,0x62880fae,0xa926004a,0xe93a0015}},	//   אטען_, zado, ыдел, رسات_
  { {0x01370053,0x62880faf,0xbcfb0003,0x9b460015}},	//   אָגט_, yado, _siég, _منحو
  { {0x62880341,0x613d0fb0,0x78a90fb1,0xbcfb0003}},	//   xado, réli, _ecev, _piég
  { {0xe1e70074,0x7d0304f9,0x61280064,0xb05b0b1c}},	//   _اس_, _însc, zıla, ndär
  { {0x612801e2,0x443d0176,0x09f70015,0xef1f0030}},	//   yıla, _byw_, _صفقة_, tsük_
  { {0x60cd0005,0x29040fb2,0x62880fb3,0x58f7000a}},	//   _raam, _ilma_, tado, _עצמן_
  { {0x26de003e,0x443d0026,0xc8790064,0x60cd0fb4}},	//   _unto_, _dyw_, _inşa_, _saam
  { {0x22580020,0xba9b0053,0xef1f00dc,0x867b000a}},	//   ärk_, עסטי, ssük_, _נראו
  { {0x612801e2,0x443d0026,0xa0550036,0x6b8d0152}},	//   tıla, _fyw_, ивні, ysag
  { {0xe3af0086,0x33f60002,0xf537000a,0x6b4b0012}},	//   _فرو_, _حساس, _גנאי_, lüge
  { {0x612801e2,0xd5a60029,0x69c5003e,0x6d5d0523}},	//   rıla, يف_, ywhe, _sisa
  { {0xbcfb038d,0x29040064,0x6b4b00b8,0x1317000a}},	//   _liée, _olma_, nüge, _תחול_
  { {0x612801e2,0x563b0053,0x463b0053,0xab5b007c}},	//   pıla, געלײ, געלע, _tsük
  { {0xaae0005d,0x30780029,0x6d5d0fb5,0x5b150fb6}},	// [15f0] नांक, _صحية_, _visa, амат
  { {0xa3d5005d,0x6d5d00e8,0xf1a8000b,0x945d002a}},	//   हित_, _wisa, _कमान, leńc
  { {0x6b8d0fb7,0x929b000a,0xba4702a3,0x6d5d0fb8}},	//   ssag, תיבת, ухай, _tisa
  { {0xd7d5000d,0x317b0053,0x69c5003e,0xc237004c}},	//   ижењ, גראמ, rwhe, נראו_
  { {0x1755005e,0xdb070030,0xdb040fb9,0x97d80058}},	//   авдя, álód, stiá, ُظهر_
  { {0x6b4b00b8,0x443d0026,0xbc1a000a,0x8c1a000a}},	//   füge, _ryw_, _יורש, _יורי
  { {0x5a44008f,0x0000006a,0x0000006a,0x0000006a}},	//   _гэта,   ,   ,
  { {0xd6180029,0xe93b0015,0x2d9e0085,0xe3b9005e}},	//   دتها_, _أسست_, šteg_, вби_
  { {0x76a70029,0xab5b0020,0x320c006f,0x9cd8000a}},	//   _محاك, _psüh, ezdy_, רוחה_
  { {0x57f40001,0x66200046,0x0587008b,0x9814012c}},	//   _упут, ázká, _будм, _طبقا
  { {0xf8c9000b,0xf2e6002b,0x04950015,0x212901d7}},	//   _रसाय, شکوه_, _نلاح, _bjah_
  { {0x33d5042b,0xa3d5000b,0x3a36000a,0xca36000a}},	//   _вікт, हिद_, ירתם_, ינתה_
  { {0x95540087,0xa9360008,0x320c002a,0xa2e50a9d}},	//   _اخلا, שטרה_, azdy_, _волд
  { {0xa8560008,0x394d001c,0xd139002a,0x539a000a}},	//   יירה_, _lhes_, stąp_, _יינו
  { {0xad3a005e,0xff050033,0x3d28002b,0x764e013f}},	//   вчає_, сяўн, هتری_, _úbyt
  { {0x25ed005d,0xc5f20008,0x6446002a,0x6f66012e}},	//   _अपनी_, חדל_, żkie, _квиз
  { {0xed570fba,0x6b4b0012,0xca8606b9,0x113b004f}},	// [1600] рот_, züge, игай, _בתקל
  { {0xbf130015,0x6ffb000a,0x1e960c9a,0x0d860fbb}},	//   _وويب, _ספיג, _трир, _клон
  { {0x7e9b0008,0x09fa0029,0xfe9b01ac,0x0e9b000a}},	//   _בסיו, خفضة_, _ביימ, _בשיל
  { {0x4069000a,0x0000006a,0x0000006a,0x0000006a}},	//   ְיוּ_,   ,   ,
  { {0x67d400d7,0x613d0030,0x6f1c0125,0xf76f0015}},	//   солу, mélt, oirc, واو_
  { {0xd737005e,0x971300e2,0x7cf80fbc,0x945d002a}},	//   апії_, оміц, _víru, zeńc
  { {0x44200011,0x95ca0fbd,0x2abb000a,0x0000006a}},	//   _ţi_, тула_, _שמלא,
  { {0x5e570053,0xc448002b,0x95d7006b,0x6b4b0012}},	//   סיקע_, هیان_, рдът_, rüge
  { {0x6f1c00b8,0xdcef0085,0x889b000a,0x7648002a}},	//   kirc, žeće, _שבמי, _wzdy
  { {0x0bb7000a,0xfbb7000a,0xf7460920,0x326607f9}},	//   סלים_, ספית_, _тезо, штив
  { {0x98af0024,0x8ad9004c,0xd62701c5,0x8afb0447}},	//   logā_, אַרפ, _кофе_, דהיי
  { {0xd5fb0053,0xe58b000a,0x23660091,0x799e0034}},	//   _שפאר, _יָדָ, _tuoj_, irpw
  { {0x69da00bc,0x9f590003,0x72d40515,0x9fe80058}},	//   _štel, lysé_, _голф, لَّم_
  { {0xa2d30029,0x6568003f,0xb3bb000a,0xe7f9000b}},	//   _وينت, _kudh, _סמוכ, ्नता_
  { {0xe2970001,0x51940015,0x6339004c,0x613d0030}},	//   _тај_, _البذ, _געװױ, félt
  { {0x6f1c0125,0x65680fbe,0x8b670015,0xa3ca0065}},	//   airc, _mudh, لائم, _लना_
  { {0xea670001,0x2d58034e,0x395f0144,0x394d0034}},	// [1610] ањен, рить_, _rius_, _rhes_
  { {0x67380085,0x656808cf,0x7cf80030,0x6f1c0fbf}},	//   jovj, _oudh, _bírs, circ
  { {0xc333000a,0xdb060030,0xdbeb0030,0x61280061}},	//   קוע_, émáb, tőór, kıll
  { {0xc7950015,0xa3d6000b,0x18690054,0x7bcb001a}},	//   مشتب, ाटा_, ћали_, ægus
  { {0x2d91005c,0x69ca02de,0x395f0144,0x387d0034}},	//   lsze_, æfer, _vius_, rbwr_
  { {0x16a90661,0x2ca90020,0x099b0015,0x65680fc0}},	//   увки_, lgad_, _لضرب_, _budh
  { {0x2ca90030,0xc5d500e2,0x394d0fc1,0xe8df0016}},	//   ogad_, сіль, _thes_, _nhện_
  { {0x7af500dc,0xb92500e6,0xc98407f7,0x2ca90fc2}},	//   _hozt, _افري, _фури, ngad_
  { {0x291d000c,0xe4c8002b,0x6f1c0061,0x97c40058}},	//   miwa_, شبين_, yirc, _وقفو
  { {0x291d0fc3,0x13060080,0xddde0227,0x5999000a}},	//   liwa_, йный_, _lepš, ְשָׁ
  { {0xdb04001c,0x2d91005c,0xc692000f,0x63b6008c}},	//   stiç, jsze_, _זאב_, _äynn
  { {0x14ca0086,0x291d003f,0xf4d40015,0xb47c005e}},	//   _مهمی_, niwa_, _وتنظ, _акцi
  { {0xc50c00b2,0x613d0030,0xa2d20065,0xb05b005b}},	//   _בלאָ, vélt, _भोक्, seän
  { {0x613d00dc,0x65680fc4,0x84e5000b,0x543a004c}},	//   féls, _yudh, कावट_, _גענא
  { {0x291d000c,0x6b5000c0,0xf2d20053,0x644e002a}},	//   kiwa_, lägg, _מעג_, ębie
  { {0x3c66008f,0x2ca900c0,0x291d003f,0x40960029}},	//   скаг, ggad_, jiwa_, _الظر
  { {0x61280064,0x291d003f,0xc4d2000a,0x1419000a}},	// [1620] nılm, diwa_, הגן_, אוּב
  { {0x2ca90fc5,0xaa8a0015,0x2d91002a,0x1eca004a}},	//   agad_, انام_, bsze_, _слои_
  { {0x8db60036,0x60c603f8,0x7c2f0051,0xeef7004f}},	//   _успі, oekm, _excr, _המיר_
  { {0x718a00b2,0x61280064,0xc9850029,0x3d14000b}},	//   רװײַ, kılm, تشكي, नोशे_
  { {0x31b100dc,0x07a30033,0xc7a309c4,0x67380085}},	//   ház_, зачн, зичк, tovj
  { {0x6d440495,0x09e6006b,0x98af003d,0xf1a80065}},	//   llia, _логн, rogā_, _कमलन
  { {0xfb1b0008,0x6d440fc6,0x291d003f,0x67380b28}},	//   _עולמ, olia, biwa_, rovj
  { {0x539800a4,0xdb04008c,0x5997000a,0x6d440fc7}},	//   авия_, stiä, _לכלב_, nlia
  { {0x6d440fc8,0x6738016f,0x9f6300dc,0x2d850fc9}},	//   ilia, povj, ívül_, ález_
  { {0x656800dc,0x6d440fca,0x91b80004,0x2d91002a}},	//   _tudh, hlia, агот_, ysze_
  { {0xe3af0074,0xf5390089,0x69da00bd,0x6d440fcb}},	//   وری_, boť_, _štej, klia
  { {0xd3e40074,0x4a5b0008,0x613d0030,0xd46a0054}},	//   _وقای, טדיו, véls, _сиде_
  { {0x2d910050,0x6d440fcc,0xb0aa000b,0x34560015}},	//   wsze_, dlia, _कारग, _انشأ
  { {0xa3d5005d,0x291d0fcd,0x31b1006f,0x2d91002a}},	//   हिर_, ziwa_, báz_, tsze_
  { {0xde590036,0x2d850152,0xb05b008c,0x02b7000a}},	//   раві_, èle_, meäm, _הלוך_
  { {0x6d4402d7,0x2d910fce,0x32430015,0xbca50015}},	//   glia, rsze_, _عنيف, تمري
  { {0x2d9100dc,0x6a670029,0x2ca90f38,0x69d802de}},	// [1630] ssze_, مطال, rgad_, æven
  { {0xdb510029,0x2d91005c,0xbb840029,0xaa670cad}},	//   ذَا_, psze_, سلمي, стак
  { {0x291d000c,0x61280064,0xd87900e6,0x7d030011}},	//   tiwa_, zılm, لمات_, _înso
  { {0xff500086,0xe8940036,0x61280064,0x628a00dc}},	//   _يخی_, заць, yılm, _lefo
  { {0x291d0fc3,0x69dc0fcf,0x62980fd0,0x31b10030}},	//   riwa_, _erre, _odvo, záz_
  { {0x7d0d03c0,0x6b5000c0,0x291d0fd1,0x7ac70fd2}},	//   lhas, vägg, siwa_, _усме
  { {0xdb0d002d,0xceb4000f,0x291d003f,0x7d0d0e8b}},	//   ntaí, פיק_, piwa_, ohas
  { {0x612801e2,0x62980fd3,0xa8350054,0x490500c3}},	//   tılm, _advo, _дебљ, _بورق
  { {0xe3b10029,0x628a0fd4,0x13090c71,0xd7740015}},	//   ذرة_, _befo, иний_, _فالع
  { {0x61280064,0xe29900d7,0x56940fd5,0x69ce0fd6}},	//   rılm, јан_, _наут, _ysbe
  { {0x60c60024,0x6d440026,0x90c60146,0x61280064}},	//   tekm, ylia, обне, sılm
  { {0x612801e2,0x320b005c,0xf992000f,0x7bcf0fd7}},	//   pılm, ący_, ורט_, _oscu
  { {0x75290011,0x60c60064,0x6b5004d4,0x63050015}},	//   mnez, rekm, läge, _ووصل
  { {0x26c70f4d,0x6d440026,0xb4c9005d,0xb7da000a}},	//   neno_, wlia, _लघु_, בקשי
  { {0x7bcf0011,0xcce60015,0x75290045,0x6b500fd8}},	//   _ascu, يسري, onez, näge
  { {0xbf65002b,0x26c70fd9,0x62980bf6,0xfce30eaf}},	//   _کديو, heno_, _zdvo, мосо
  { {0x6d440fda,0x62810fdb,0x8c430fdc,0x0c260a31}},	// [1640] rlia, oblo, дете, цман
  { {0x98ad002c,0xcaa60029,0xb0aa005d,0x26c70fdd}},	//   _cieľ_, تصري, _काँग, jeno_
  { {0x26c70fde,0x7bcf089f,0xa113002b,0xd12f002b}},	//   deno_, _escu, _رویت, _سمی_
  { {0x31ba0053,0xdb04002d,0x7d0d0fdf,0xf79a0058}},	//   יזענ, ntiú, chas, لنصب_
  { {0x6fca000b,0xdb040125,0x7aa60015,0x62810fe0}},	//   िबिं, itiú, _وإسل, kblo
  { {0x7d04022d,0x1a5a0015,0x26c70fe1,0x75290fe2}},	//   lkis, _نشأة_, geno_, enez
  { {0xb0aa005d,0x62810fe3,0xe4a60fe4,0x7d04008c}},	//   _कांग, dblo, орпо, okis
  { {0x88860731,0x7d04045a,0xd5d50033,0xef1f0061}},	//   _флаж, nkis, яючы, nsür_
  { {0x26c70ccd,0x394604ff,0xd94303ae,0x7d040fe5}},	//   beno_, mlos_, _цети, ikis
  { {0x8c1b0008,0x7d0d00dc,0x39460fe6,0x62810fe7}},	//   יופי, zhas, llos_, gblo
  { {0xfd4d0092,0xaadb0008,0xb5ca002b,0xa1740033}},	//   ghiệ, בחיר, _خوام_, ягні
  { {0x1074005e,0x39460012,0x62810fe8,0x40350fe9}},	//   млюю, nlos_, ablo, земс
  { {0x645d0091,0x232a0fea,0x68e4008c,0x23780015}},	//   žsir, _коди_, öidy, _امتد_
  { {0xf1a60feb,0x8d770015,0xdb040003,0x98af002a}},	//   _дрин, قارا, quiè, mogą_
  { {0xc27b0053,0x98af0007,0xf27b0008,0x61fc00c0}},	//   _דרוי, logą_, _דרוש, ärld
  { {0xdb04002f,0x459b0053,0x26c706d5,0x7d0400dc}},	//   ctiú, יסלע, zeno_, gkis
  { {0xdb0d002d,0x7d0d0fec,0x39460012,0x3014009b}},	// [1650] staí, rhas, dlos_, _одър
  { {0x657a00dc,0x39460a40,0x61360030,0x7d0d0c6b}},	//   _otth, elos_, dály, shas
  { {0xceb2039e,0x7d0d0fed,0x39460012,0x26c70fee}},	//   _איי_, phas, flos_, veno_
  { {0xcdda00b2,0xed58000d,0x39460fef,0x6b50012d}},	//   _פֿיר, _моќ_, glos_, väge
  { {0x60dc00b2,0x66e5006b,0x69d80123,0x97c7002b}},	//   יקאנ, зола, åver, تتام
  { {0xff7c01ac,0xabfa000a,0x39460ff0,0x8f8c004f}},	//   סטומ, _ההשר, alos_, בְהֵ
  { {0x39460ff1,0x06960015,0x753b002a,0xa5f60054}},	//   blos_, سنية_, touz, зеју_
  { {0x6b5000b8,0x613600dc,0xcdaa0053,0xf8ae002b}},	//   räge, bály, ציפֿ, _مکه_
  { {0x6b500123,0x753b0ff2,0x26c70ff3,0x6b4b0030}},	//   säge, rouz, peno_, nügo
  { {0x753b0089,0x13090139,0x7d0401d3,0x0000006a}},	//   souz, сной_, zkis,
  { {0xcb120008,0x61460ff4,0x753b00b3,0x644e002a}},	//   גלי_, зена, pouz, ębia
  { {0x3d05000b,0x80b8000b,0x62810ff5,0x55ba000a}},	//   रसों_, ेजें, sblo, _למעו
  { {0xb4d7005d,0x7fd5005e,0x8f75017f,0x4427006e}},	//   ायी_, мірі, дусі, _براف
  { {0x3f9e0156,0x3ebe002e,0xe7f3000b,0xad660015}},	//   čtu_, ýtt_, _आपना_, كاره
  { {0x33180086,0xdb040152,0xc27a000f,0x63a90ff6}},	//   _بزند_, quié, _פרקי, luen
  { {0xa01b002e,0x41b20029,0x2571002e,0xc19a000a}},	//   mbön, _أمير, _mál_, _השקי
  { {0x7d040ae5,0x63a90376,0xfbdf016e,0x3f890034}},	// [1660] rkis, nuen, _crê_, _gwau_
  { {0xe816014e,0xa3dc000b,0x6fdb000a,0x60d60ff7}},	//   _देगा_, डित_, _פקיס, _haym
  { {0x4efb000a,0x257100dc,0x7d040061,0x60d60ff8}},	//   _הליג, _nál_, pkis, _kaym
  { {0x63a90273,0xaa570015,0x39460a64,0x57ea0a32}},	//   kuen, سلنا_, ulos_, йдем_
  { {0xe816005d,0x2efa00b8,0xdcf70011,0x39460ff9}},	//   _देखा_, _kopf_, şcăr, rlos_
  { {0xc58a004a,0x7e7a004c,0x4e7a004c,0x60d600da}},	//   бщие_, זאַז, זאַצ, _laym
  { {0x5554002b,0x394609ae,0x7d150030,0x98af0535}},	//   وپتر, plos_, _ügsé, wogą_
  { {0xd3a60036,0x25710089,0x399b0008,0xf9b7000a}},	//   проп, _dál_, _לילד, _מהלך_
  { {0x63a902d7,0x07a3000d,0x94730029,0x07a6006b}},	//   guen, _патн, رديا, _хазн
  { {0xa3ab005d,0x877b000a,0xa318005e,0x957c002a}},	//   गढ़_, _לאמי, іжну_, _prąd
  { {0x867b000a,0xbef8000b,0xbcfb0003,0x645d0091}},	//   _הרבו, ुसैन_, _biél, žsip
  { {0x2906008c,0x212b0ffa,0x63a90ffb,0x60d60ffc}},	//   nkoa_, unch_, buen, _caym
  { {0x63a90467,0x5f94010f,0xdbf10046,0x2f0f0012}},	//   cuen, ният, tříc, _lüge_
  { {0x6b960ffd,0x4173009a,0x2efa01d3,0x0000006a}},	//   dsyg, بایس, _copf_,
  { {0xb2bb0008,0x3cfb005d,0x290600f2,0xa2bb0008}},	//   _המור, ैसले_, kkoa_, _המוט
  { {0x6144000d,0x5cb90033,0x645d001a,0x0000006a}},	//   _пеја, ўлаў_, ýsig,
  { {0xa3d5005d,0x309c000a,0xa3d2000b,0xdb99005e}},	// [1670] हिए_, _השחמ, _हैम_, ювач_
  { {0x2bb80015,0x7bcd0034,0x0000006a,0x0000006a}},	//   ثافة_, rwau,   ,
  { {0x60d60061,0x5d550ffe,0x66f00065,0x79a70138}},	//   _yaym, _окот, चानक_, ярае
  { {0x5fb1000b,0x25e0000b,0x6d88000a,0xad88000a}},	//   _जमाल, किनी_, _מָשְ, _מְשֻ
  { {0x98f40029,0xd7f80054,0x78a40030,0x25710fff}},	//   عثما, зуј_, óiva, _sál_
  { {0xd00c0008,0x85790080,0x257100dc,0xbb840015}},	//   מּוֹ, осит_, _pál_, _سلفي
  { {0x69da018c,0x2002005c,0x28a70033,0xd6ce0015}},	//   _štev, zyki_, _ншаг, شقي_
  { {0xb4d7005d,0x6b4b00b8,0x2907003d,0x644e002a}},	//   ाये_, zügl, īnas_, ębin
  { {0x2be0005d,0x2f0f00b8,0x19580033,0x61280030}},	//   निया, _züge_, _хаты_, nűle
  { {0x68fb0298,0xdddc0007,0x68e9006f,0x7d1a0030}},	//   _houd, varž, _hned, étsz
  { {0x60d61000,0x67231001,0x68fb1002,0xa0a607ec}},	//   _paym, minj, _koud, манд
  { {0x2002005c,0x68fb008c,0x67231003,0x22580052}},	//   tyki_, _joud, linj, ýrka_
  { {0x212200d9,0xe3b3002b,0x68fb1004,0x73090015}},	//   rikh_, _سرش_, _moud, _وقصف_
  { {0x7f190010,0x2002005c,0x68fb1005,0xf7670067}},	//   пісу_, ryki_, _loud, ضا_
  { {0xa3d5005d,0x68e9002c,0xdd1c0057,0x6e43049d}},	//   हिक_, _oned, _vážn, верз
  { {0xdb0d00b8,0x7bc30011,0x68fb014a,0x67230796}},	//   traß, ănun, _noud, hinj
  { {0xe3b900dc,0x67230796,0x2ba5000b,0xab661006}},	// [1680] ntű_, kinj, गंगा, двал
  { {0xbf660015,0x27210046,0x290d0045,0x98af002a}},	//   _تدعو, nčně_, _alea_, mogę_
  { {0x67231007,0x3ebe0020,0x2906008c,0x68fb1008}},	//   dinj, õttu_, tkoa_, _boud
  { {0x6603005c,0x58ba0029,0x07a60010,0x68fb0618}},	//   dynk, تائج_, дадн, _coud
  { {0x4c36008f,0x7b090030,0x2906008c,0x67231009}},	//   _цэнт, ástó, rkoa_, finj
  { {0x8f890008,0xdddc005c,0xa3dc000b,0x75d40015}},	//   פְנֵ, karż, डिस_, فيتا
  { {0xd5af0063,0x66e301ca,0x68fb100a,0x290d100b}},	//   ъс_, тоја, _foud, _flea_
  { {0x88c60029,0x25a00ea5,0x68fb100c,0x25a10046}},	//   _تتسل, čil_, _goud, áhla_
  { {0x644e005c,0x7afc100d,0x6723100e,0x6843100f}},	//   ębio, _kort, binj, _анта
  { {0x68fb0111,0xd7fb000a,0x57fb000a,0xb7d700c3}},	//   _zoud, _והמל, _ולמו, _زوما_
  { {0x2d9e0089,0x36060225,0x7afc0d2d,0x68e90034}},	//   átel_, _تواف, _mort, _yned
  { {0xe5060015,0xd1310021,0x957c002a,0xc5f3000a}},	//   _تبطي, امح_, _trąb, _שדף_
  { {0x7afc00dd,0xd4670054,0x98af002a,0x34bc0065}},	//   _oort, _жице_, gogę_, ्जीद
  { {0x7afc08aa,0xa6f8000a,0x33170015,0x15f20065}},	//   _nort, הִֽי, _يزود_, _अपार_
  { {0xa3d6005d,0x6455005c,0xccfb0001,0x828b000a}},	//   ाटक_, ęzie, оћа_, _וְחֶ
  { {0x6b5000c0,0xa1150086,0x319b000a,0xc19b000a}},	//   väga, _سوخت, _ובהנ, _ושהי
  { {0xdb0d03af,0x6603002a,0x7afc1010,0x7b740015}},	// [1690] ntaç, zynk, _bort, نطلا
  { {0x68fb1011,0x93b7000a,0xdb0d016e,0x68e91012}},	//   _soud, ולמו_, itaç, _sned
  { {0x68fb1013,0x6723044c,0x7afc1014,0x290d00da}},	//   _poud, vinj, _dort, _plea_
  { {0xe7f3000b,0x08d4005e,0x2d830079,0x38350121}},	//   _आपदा_, кція, mpje_, ннер
  { {0x2617005d,0x68fb0152,0x67231015,0x69da01a3}},	//   _भेजी_, _voud, tinj, _štet
  { {0xcaa70115,0xe73300e5,0x6b500123,0x68fb0079}},	//   _تصحي, خصص_, lägn, _woud
  { {0xe81f005d,0x76480026,0x67231016,0xbef8000a}},	//   _मेरा_, _cydy, rinj, וצגו_
  { {0x68e90335,0x61280064,0x76480026,0x67d51017}},	//   _uned, nılt, _dydy, _побу
  { {0x37350010,0x386d1018,0x97250015,0x67231019}},	//   _знаё, _iger_, _كفرو, pinj
  { {0xcb1200b2,0xf7720008,0xfbd20008,0x82350067}},	//   ָלט_, _עקב_, נתי_, فرجا
  { {0x0322008f,0x3f99002e,0xe1260b0c,0x7d0f0030}},	//   удэн, essu_, емни, _olcs
  { {0xa3dc000b,0xf953005e,0x2d9e0046,0xe8df0016}},	//   डिश_, ннiй_, átem_, _khốn_
  { {0x13f40063,0x6d5a0144,0x2bcf000b,0x2d830079}},	//   _изця, ïtam, _सैला, epje_
  { {0x2d9e0085,0x61ee0125,0x7d0f0030,0x98af002a}},	//   štem_, óilí, _alcs, rogę_
  { {0x2f1401d1,0x63bb101a,0x2d8c0152,0xed5a0da4}},	//   _lägg_, ltun, ède_, зов_
  { {0xc5f200b2,0x621a000a,0xbe630015,0x386d0123}},	//   נדן_, _מוצק, اهِي, _nger_
  { {0xe81f000b,0x63bb101b,0x7afc101c,0x5baa02bb}},	// [16a0] _मेला_, ntun, _port, якам_
  { {0x7fd70008,0x63bb101d,0x7d0f0030,0x9b46002b}},	//   _טופס_, itun, _elcs, رناو
  { {0x7afc0746,0xfd4a006b,0xceb7000a,0x60da000a}},	//   _vort, _нзок_, _אפיק_, ּקְנ
  { {0x76480176,0xb17a0053,0x7afc0334,0xa17a004c}},	//   _rydy, לטער, _wort, לטעט
  { {0x39130086,0x6d46101e,0x76480026,0x7afc0541}},	//   دونز, _ikka, _sydy, _tort
  { {0x98c50024,0xcf930008,0x8f9b000a,0xd5b00040}},	//   ītās_, נטו_, ליני, لفت_
  { {0xceb30135,0x49d4000a,0xdb040003,0x60c40085}},	//   טיג_, _בֵּן_, vriè, _obim
  { {0x63bb00b8,0x95c3002b,0x154301ca,0xa3dc0065}},	//   ftun, اييه, лејм, डिल_
  { {0xd4e3005f,0xdb040152,0xc34a0010,0x63bb101f}},	//   ующи, triè, зяне_, gtun
  { {0x0bb70008,0xdb0d001c,0x6b840b63,0x079b000a}},	//   עלים_, rtaç, ipig, _מסמל
  { {0x6d460084,0xdb040152,0xdb0d001c,0x4155029f}},	//   _okka, rriè, staç, квос
  { {0xdb0d016e,0x0577004f,0xf9460138,0x7644007f}},	//   ptaç, _נגדם_, мнiк_, ğiyd
  { {0x389b000a,0xe5050015,0xa01b0030,0x34fb004f}},	//   היכנ, _جبلي, mbök, _מהאד
  { {0x54530191,0x32050089,0xc2c40002,0x6d461020}},	//   _світ, byly_, _شيعي, _akka
  { {0x7c870001,0x1687000a,0x7d250015,0x0dc81021}},	//   еузе, עֲךָ_, نفسن, нути_
  { {0x2d830079,0x2262002a,0x386906c0,0x0000006a}},	//   rpje_, ęskę_, žari_,
  { {0x8aa7087a,0x113c000a,0x6b8402f2,0xfaa70df0}},	// [16b0] еред, _מתהל, gpig, ешен
  { {0x2fc902f2,0x69d51022,0x60dd1023,0x0000006a}},	//   _ipag_, _psze, ldsm,
  { {0xf9930225,0x63bb014f,0xaf340015,0x798e0034}},	//   ابط_, ztun, _حريت, _cwbw
  { {0xd23b0008,0x7d0f00dc,0x2d81002d,0x63bb06ee}},	//   הגבל, _ulcs, _ithe_, ytun
  { {0xb8c9014e,0x69d50050,0x9e670086,0xb09c000a}},	//   _गए_, _wsze, _تاکن, ליאר
  { {0x6d4d0c8d,0x99850015,0xc054000a,0x66b20004}},	//   llaa, _للسو, נזס_, абљу
  { {0x798e0026,0xda090115,0x6d46002e,0x05a9005e}},	//   _gwbw, _غيره_, _ykka, євий_
  { {0x386d0134,0x6d4d1024,0x63bb1025,0x60dd02de}},	//   _uger_, nlaa, ttun, jdsm
  { {0x7d030011,0xdcfc0024,0x63bb04ea,0xe3e9002b}},	//   _însu, nprā, utun, بکان_
  { {0x613d0f87,0x752202b9,0x2d9e0046,0x6b4b0012}},	//   mély, _emoz, átek_, fügi
  { {0x6d4d0005,0x2fc90035,0x63bb1026,0xb05b005b}},	//   klaa, _apag_, stun, keäs
  { {0x6d5a0007,0xd12f0015,0xbcfb016e,0xa4870015}},	//   įtak, ْمَ_, _fiéi, _أجان
  { {0x889a0008,0x2f140bc2,0x1c15000b,0x6b8401cc}},	//   וברי, _läge_, णनफल_, xpig
  { {0xdb04038d,0x656b1027,0xe1f100e6,0x4ed51028}},	//   prié, _high, _نسب_, люст
  { {0x7e230001,0xc1060015,0x14d5000a,0x6d4d008c}},	//   адрж, _لوثي, ֣וּל_, flaa
  { {0x657c00dc,0xc1720008,0x63a91029,0x6d4d102a}},	//   _érhe, _דחה_, oren, glaa
  { {0x656b0041,0x3c660033,0x63a9102b,0x765c0069}},	// [16c0] _migh, ткаг, nren, _úryv
  { {0x656b003e,0x613d00dc,0x0057000a,0x63a9102c}},	//   _ligh, dély, _בשפת_, iren
  { {0x644b00df,0x63a90940,0xdb1d0134,0x6d4d0409}},	//   _lygi, hren, _opsæ, blaa
  { {0x656b003e,0xdcfc0024,0x01fa00a3,0x63a9102d}},	//   _nigh, bprā, ופעל, kren
  { {0xab66005c,0xa7d30015,0x684304ab,0x63a9102e}},	//   _pożą, لتوص, анца, jren
  { {0x501b0008,0xfaa6004a,0x6d440045,0x63a9102f}},	//   וונו, _шаго, loia, dren
  { {0xdb0402c1,0x2be0000b,0x63a91030,0xf5b30015}},	//   stió, निवा, eren, لصيد
  { {0x7d160034,0x7d030045,0x63a91031,0xd37a1032}},	//   nhys, _înst, fren, мчо_
  { {0x63a91033,0xd8770015,0xe4d3002b,0xa7661034}},	//   gren, _شملت_, شتيب, _акад
  { {0x86ea0029,0x656b003e,0x86750010,0x51f80036}},	//   _تعرف_, _eigh, _быцц, еною_
  { {0x656b003e,0x8717000a,0x63a91035,0x64c60015}},	//   _figh, _שקבע_, aren, _ليال
  { {0x9426005f,0x452a006b,0x69130061,0x142603ae}},	//   _имее, _южен_, _içec, _идем
  { {0x6d441036,0x38bd0030,0x60dd1037,0x63a91038}},	//   doia, láró_, rdsm, cren
  { {0x9f60002e,0xf773000a,0xdb250030,0x7d16008c}},	//   ærðu_, יקש_, épül, ehys
  { {0x7e28022a,0xf2d30135,0xce94006b,0x6b500dca}},	//   віта_, _כעס_, расъ, rägl
  { {0x1bd5006b,0x2d580342,0x7d160034,0x2b890058}},	//   лобя, вись_, ghys, فَرٍ_
  { {0xdc55019c,0xfbd00029,0x6d4d0234,0x0000006a}},	// [16d0] увањ, يتك_, rlaa,
  { {0xf1b6005d,0x6d4d0991,0x60080008,0x7b140033}},	//   _अमान, slaa, _יִתְ, адух
  { {0x25780030,0x38bd0030,0x6d4d1039,0x63a9103a}},	//   _nél_, járó_, plaa, zren
  { {0xe0df04ed,0xf9900015,0x63a9103b,0x7d16103c}},	//   ndò_, تبك_, yren, chys
  { {0xfd56103d,0x656b103e,0xa6c90888,0x7d0d103f}},	//   _תשרי_, _righ, елла_, mkas
  { {0x656b1040,0x8c1a000a,0xe8df0016,0x63a91041}},	//   _sigh, _טורי, _phồn_, vren
  { {0x257800dc,0x19940010,0x63a91042,0x85940033}},	//   _cél_, _вася, wren, ашыц
  { {0x25781043,0xaa58005e,0x63a91044,0x693c0085}},	//   _dél_, _рису_, tren, včeg
  { {0xa774005e,0x38351045,0x7d0d1046,0x63a91047}},	//   _влуч, _снар, ikas, uren
  { {0xe1f9005f,0x257800dc,0x63a90901,0xe4560033}},	//   его_, _fél_, rren, ыжы_
  { {0x9afa0008,0x7d0d1048,0x656b1049,0xaaab000b}},	//   תפתח, kkas, _tigh, _चयनक
  { {0x7fb60010,0x63a90376,0x3a36000a,0x656b104a}},	//   лёгі, pren, טרתם_, _uigh
  { {0x7d0d104b,0xc2c50040,0x03a50120,0x6d4400d4}},	//   dkas, _ميشي, _сило, voia
  { {0xa856000a,0xa224002b,0xe4500015,0x54680033}},	//   טירה_, اریه, _بضم_, _раім_
  { {0x7d0d104c,0xdd1d0046,0xdb04016e,0xd7da000b}},	//   fkas, lářs, luiç, _मैनच
  { {0xd24e0015,0xceb8002a,0x9f400144,0x7e7c0085}},	//   _عني_, żę_, _triï_, scrp
  { {0x38bd00dc,0xd1170008,0x6eac005d,0xdb04016e}},	// [16e0] záró_, _תקפה_, _जयपु, nuiç
  { {0x7d0d104d,0x8a3a0080,0xaf0a0029,0x945d005c}},	//   akas, няет_, _أقدم_, leńs
  { {0x88860063,0xdebb000a,0xd884002b,0xb05b0012}},	//   глеж, _אמיל, لهای, nfän
  { {0x7aeb0024,0xb866002b,0xcb09000a,0x58960015}},	//   ēgta, هاشو, הל_, اجاز
  { {0xa3d2005d,0xdd1d0089,0x66f0000b,0x98a30818}},	//   _हैं_, jářs, चालक_, сиче
  { {0x05b40029,0xdd1d0089,0x2af60010,0x1e96000a}},	//   لمتح, dářs, _сямё, אכַל_
  { {0x645d09f0,0xceb3013a,0xe5c60a24,0x0000006a}},	//   ýsin, ציה_, усло,
  { {0x2578001a,0x945d0535,0x61fc02dc,0xd94607f9}},	//   _vél_, jeńs, ärlm, _себи
  { {0x28dd005d,0x46b60002,0xdb04016e,0x945d002a}},	//   _नोटि, _محاس, guiç, deńs
  { {0x9bbb00b2,0x5186104e,0x8bd7000a,0xa3d2000b}},	//   עציפ, лума, נויו_, _हैः_
  { {0xaac6014e,0xd2500074,0x4ac6005d,0x7bc30045}},	//   र्यक, تند_, र्यव, ănui
  { {0xdb04001c,0xd2570010,0xf653000a,0x63e60015}},	//   buiç, ыцы_, _הצע_, _مستك
  { {0xa3b3014e,0xe0df02b9,0x43940937,0xdb0d001a}},	//   जूद_, rdò_, _талс, rtaú
  { {0x1ee7002b,0xdb150030,0x3dda0012,0x7433008b}},	//   دوسی_, öbün, _bspw_, _уніф
  { {0xc27b00b2,0x627b000f,0xa3dc000b,0xbd4500c3}},	//   _ארוי, _אנונ, डिक_, لنسي
  { {0xf1a9014e,0x629a0c0a,0x26de104f,0x2d9e0045}},	//   _कितन, lato, _lato_, âtea_
  { {0x7d0d1050,0x2aab0054,0x7b770040,0x39461051}},	// [16f0] rkas, етео_, اطرا, doos_
  { {0x212b018b,0x6eb2005d,0xc334000a,0x501c000a}},	//   lich_, _जाएँ, ׁוּ_, _רוזו
  { {0x69070010,0x212b002a,0x7d0d1052,0x98751053}},	//   лядз, oich_, pkas, алец
  { {0x629a1054,0x5dfa000a,0x212b0051,0xaa641055}},	//   hato, _ספרנ, nich_, стук
  { {0xdc9a000a,0x6b4b0012,0x98070033,0x18690054}},	//   _שישל, fügt, ыяжд, њали_
  { {0x212b0041,0x945d005c,0x7ceb00c0,0x16a61056}},	//   hich_, zeńs, _förä, авши_
  { {0x212b0050,0x9f440089,0xc68e0015,0x140d000b}},	//   kich_, ímé_, ذِي_, िन्ह_
  { {0xdb04001c,0x212b0156,0x63f50029,0xdd1d0046}},	//   tuiç, jich_, لأخر, tářs
  { {0x26de001c,0x75290024,0x6455002a,0xe459006b}},	//   _fato_, riez, ęzio, ъжи_
  { {0xa1c5008f,0x13090080,0xdb04001c,0x032506f6}},	//   абод, тной_, ruiç, рдон
  { {0xcb140008,0x75291057,0x8505002b,0x27450046}},	//   מלץ_, piez, _پوشن, ríně_
  { {0x9567010f,0x212b005c,0x26de1058,0x757a000a}},	//   _създ, gich_, _zato_, _סטנפ
  { {0x6446007c,0x248d016e,0xd8d6004c,0x4ac6000b}},	//   ükit, mbem_, בורט_, र्डव
  { {0x6d5d003f,0xb05b1059,0x629a06ae,0xfe720058}},	//   _ahsa, pfän, cato, تدح_
  { {0xb05b07fd,0xad6600c3,0x7c960bdb,0xde03105a}},	//   lfäl, لاره, ирац, опри
  { {0x212b032c,0xdb0400f2,0x4c860033,0x3f8d0045}},	//   cich_, ntiö, рлав, ţeua_
  { {0xb05b00b8,0x8b26054f,0x998d0085,0x2fd7002b}},	// [1700] nfäl, адае, _ćeš_, _نويد_
  { {0x305b0008,0x9f9b0008,0x4f9b0008,0x905b000a}},	//   _בדפד, _שסיפ, _שביצ, _בכפת
  { {0xbcfb0003,0xa2bd000b,0x6b50007c,0x26de105b}},	//   _piét, _शान्, nägi, _rato_
  { {0xb05b00c0,0xe7860036,0x497302e1,0x629a105c}},	//   kfäl, ауко, іліс, zato
  { {0xa81a0002,0x18360015,0x26de105d,0x87ba004a}},	//   ختار_, جراح, _pato_, тует_
  { {0xc9860086,0x77910086,0xb5a600a4,0x70d3000b}},	//   _نشري, سیما, арий, _तस्ल
  { {0x96f70015,0x629a105e,0x64590535,0xb05b02ad}},	//   شعور_, vato, _azwi, efäl
  { {0xd943057e,0xbcfb0003,0xb05b0012,0xd4c30033}},	//   _деси, _hiér, ffäl, осьп
  { {0x53970010,0xbcfb00dc,0xaac6005d,0x26de105f}},	//   авыя_, _kiér, र्थक, _tato_
  { {0xe5a6005e,0x68e01060,0x68e2007c,0x212b1061}},	//   _вижи, _hamd, ldod, wich_
  { {0xd25a0063,0x29041062,0xbcfb1063,0x212b1064}},	//   ъци_, _koma_, _miér, tich_
  { {0x64460020,0x2d570061,0xddd4002a,0x629a1065}},	//   ükis, eçen_, łaśn, sato
  { {0x2f1400c0,0xa3dc005d,0xff07005e,0x212b1066}},	//   _säga_, डिओ_, аявн, rich_
  { {0x69dc00bd,0x8cc9000b,0x539b000a,0x23270004}},	//   _osre, ह्नो, _יידו, _кочи_
  { {0x4d27000d,0xa3d2005d,0x2d850384,0x7095006b}},	//   аќаа, हौर_, ële_, _лайф
  { {0x2f140005,0x5c751067,0x6298008c,0x25a10046}},	//   _väga_, слат, _hevo, áhli_
  { {0xa3dc014e,0x68e20176,0x7a870015,0xfc67006b}},	// [1710] डिट_, ddod, لشام, ръвн
  { {0xf1da005d,0x91da000b,0x4ea71068,0xeab30058}},	//   _बनान, _बनाई, _триа, تعر_
  { {0xf8750029,0x3f8b00bd,0xceb2004c,0xbae40058}},	//   مهاج, lpcu_, _ציט_, تكلي
  { {0x32370053,0xc8790064,0xf1a9000b,0x68e01069}},	//   סטאן_, _başa_, _किसन, _camd
  { {0x27e902c1,0x68e00035,0x62980079,0x9814002b}},	//   ían_, _damd, _oevo, يبها
  { {0x62980e25,0xc7240036,0x7bdd106a,0x8724005e}},	//   _nevo, одій, _issu, оміж
  { {0xe7f3005d,0x63a2106b,0x99d40015,0x27e60012}},	//   _आपका_, _avon, _وتفا, avon_
  { {0xce380008,0x68e00026,0x2e38000f,0xd5b8000b}},	//   יאות_, _gamd, ירוש_, _इमरज
  { {0xa3d2005d,0xd7e4005e,0xb8150054,0x248d002a}},	//   हौल_, _міфо, _удај, rbem_
  { {0xf770003b,0xb05b079c,0xd7590015,0xc2c50058}},	//   _قال_, rfäl, _صلات_, حيدي
  { {0x7c3b0084,0xa2aa005d,0x321101c9,0x41b40142}},	//   _þurf, _फ़ार्, ázy_, осят
  { {0x68f9000a,0x80fa0004,0x628e001a,0x89e8000a}},	//   אלֹה, ухот_, ðbor, בַשֵ
  { {0x4385003b,0x63850001,0xc106002b,0x753e0030}},	//   _التق, _угла, لوگي, épze
  { {0x629800f6,0xc692000a,0x68e20b46,0xe299106c}},	//   _gevo, ּאן_, zdod, _сак_
  { {0x321e005c,0xa3b3000b,0x7bdd082d,0x63a209cb}},	//   czty_, जूर_, _assu, _zvon
  { {0x31a301e2,0x6143106d,0x22580030,0x8234012c}},	//   mız_, _неща, ürke_, _برها
  { {0xed570083,0xb47a004c,0x2904106e,0xfc64009a}},	// [1720] сот_, אָבי, _roma_, زخری
  { {0x2904000c,0xda660029,0x7ed50036,0x6281106f}},	//   _soma_, ماضي, _діюч, nclo
  { {0x31a30482,0xe0df0251,0x58860010,0x9d461070}},	//   nız_, clòs_, была, _генд
  { {0xc8b60029,0xc8791071,0xa967006b,0x189a0015}},	//   إصاب, _paşa_, биха_, اضاة_
  { {0xe1e70086,0x68e21072,0x765a002a,0xc79608f0}},	//   _کس_, rdod, _szty, ёрды
  { {0x4733005e,0x07080015,0xa057004c,0x27e61073}},	//   пніс, شيعي_, זױנס_, rvon_
  { {0x76a90036,0x63a2002e,0x69dc016f,0x6d411074}},	//   ртів_, _svon, _usre, élag
  { {0x2561002e,0x76440064,0x31a30061,0x7d061075}},	//   hólf_, şiyo, dız_, _joks
  { {0x7d060007,0x26130092,0x97bd0484,0xa87b000a}},	//   _moks, ạo_, _архi, _תאמר
  { {0x8c1b000a,0x31a30061,0x7d061076,0xf1a90065}},	//   טופי, fız_, _loks, _किशन
  { {0x14ca005f,0x60f90e7e,0x8afb1077,0x2258004a}},	//   _были_, ання_, אליז, рины_
  { {0x54e50015,0x320c002a,0x7d061078,0x05661079}},	//   _وسنق, rydy_, _noks, _увен
  { {0x321e005c,0x657a003f,0x4346005e,0x8556002b}},	//   szty_, _huth, _ледв, _پیکر_
  { {0x543b0053,0x98bd005c,0x421a0015,0x657a044d}},	//   _געדא, mową_, _مزعج_, _kuth
  { {0x91860225,0x98bd005c,0x7d06107a,0x657a0030}},	//   _اجتم, lową_, _boks, _juth
  { {0xf2370008,0x5d55017f,0xdb16008c,0x4035107b}},	//   _לרוץ_, ікат, htyä, _мейс
  { {0xba990036,0x2d5803e7,0x1b7b0015,0x98bd002a}},	// [1730] иває_, сить_, اصرة_, nową_
  { {0x9f53005c,0xc018000a,0xdb040030,0x2dd5107c}},	//   ądów_, _לקחו_, triá, _джор
  { {0xc27b00b2,0xdb0d001a,0x7bc40144,0x0000006a}},	//   ארבי, ptaþ, atiu,
  { {0x76440064,0x98bd005c,0x35c2000b,0xa3b30065}},	//   ğiyl, kową_, _शहज़, जूँ_
  { {0x2b930086,0x9a870010,0x7bc4107d,0x657a0043}},	//   _ریاس, _губл, ctiu, _auth
  { {0x8f9c0053,0xdb160092,0x31a30064,0x98bd005c}},	//   ריגי, huyê, yız_, dową_
  { {0x395f0041,0x7d060064,0x451903fc,0xceb400f3}},	//   _thus_, _yoks, иция_, ליס_
  { {0x2a7b0007,0x6d8c000a,0x69c5107e,0xb385107f}},	//   šybą_, אָזְ, mthe, олил
  { {0x6b8d0111,0x4ac6000b,0x693c00bc,0x69c51080}},	//   npag, र्वव, očen, lthe
  { {0xf1c30089,0xe2990001,0x693c04af,0x6b8d1081}},	//   _naší_, шао_, nčen, ipag
  { {0x3f89013c,0x657a1082,0x69c51083,0xc5d9012c}},	//   _atau_, _guth, nthe, _خواص_
  { {0xe56e0191,0x31a301e2,0x69c51084,0x6b8d0111}},	//   _із_, rız_, ithe, kpag
  { {0x31a30064,0xb05b0012,0x98bd002a,0x69c502f7}},	//   sız_, nfäh, cową_, hthe
  { {0x60cd0020,0x543a004c,0x6b8d0079,0xa01b0030}},	//   _ebam, _דענא, dpag, tbör
  { {0xec9a00d0,0x693c0227,0x6b8d1085,0x69c51086}},	//   итај_, dčen, epag, jthe
  { {0x92580015,0xa01b0400,0x69c5031a,0x7bc41087}},	//   _اشهر_, rbör, dthe, ttiu
  { {0x7d060293,0xc4d2000a,0x4419000a,0xdee61088}},	// [1740] _voks, וגן_, בוּס, _допи
  { {0x78a91089,0xab5b0012,0xca560004,0x1e8301c5}},	//   _adev, _spür, отењ, _ольм
  { {0x6b8d0035,0x69c5108a,0xaac6000b,0xb05b0012}},	//   apag, gthe, र्षक, efäh
  { {0x6b8d108b,0x7bc4108c,0x57ea01b7,0x27ed108d}},	//   bpag, ptiu, идем_, _bren_
  { {0x2ca00db8,0xdb1600f2,0x69c5108e,0x6b500012}},	//   maid_, ttyä, athe, wägu
  { {0x291d00e8,0x2ca0108f,0x69c50012,0x46f6006b}},	//   ahwa_, laid_, bthe, ючет
  { {0xd5b00029,0x27ed1090,0x98bd002a,0x25dd000b}},	//   رفة_, _eren_, wową_, _कैदी_
  { {0x291d000c,0x4ac6005d,0x98bd005c,0xa5070001}},	//   chwa_, र्रव, tową_, жећа_
  { {0xdddc0085,0x27ed02d6,0xfc45004f,0xa7850058}},	//   jbrž, _gren_, ּאתָ_, _فشلو
  { {0xbcfb002d,0x2ca00112,0xa3cb000b,0x98bd002a}},	//   _mhéa, haid_, _लहर_, rową_
  { {0xdcfc0007,0x98bd005c,0x6603000d,0x2ca00020}},	//   sprę, sową_, _опфа, kaid_
  { {0x2ca01091,0x98bd002a,0x612b1092,0x212b00ce}},	//   jaid_, pową_, рцог_, ріон_
  { {0xdb04001c,0xb4b6005d,0xada2002c,0x5f940063}},	//   criç, जली_, _šúpl, мият
  { {0xa3d7005d,0xc7b3000a,0xadbd0033,0x69c51093}},	//   ाबर_, ובש_, лагi, ythe
  { {0xf1c302d5,0x2ca00026,0xe2460086,0xdb0d0003}},	//   _vaší_, faid_, _بخشي, fraî
  { {0xbcfb002d,0xccf80001,0x6b8d0079,0x2ca00034}},	//   _bhéa, оћу_, tpag, gaid_
  { {0xbcfb002f,0x2bb80029,0x0ca80063,0x693c0089}},	// [1750] _chéa, قالة_, ютри_, tčen
  { {0xbcfb002f,0x693c06d5,0x6b8d1094,0xcf92000a}},	//   _dhéa, učen, rpag, _רטי_
  { {0x6b8d0111,0xa2bd000b,0x291d00aa,0x69c80123}},	//   spag, _शास्, thwa_, _ädel
  { {0xbcfb002d,0x69c51095,0xd257000a,0xa2ca000b}},	//   _fhéa, rthe, חשבה_, त्त्
  { {0x6cfa013a,0xacfa000a,0x69c51096,0x3cfa000a}},	//   _הפרס, _ההרכ, sthe, _הפרב
  { {0x291d0f4d,0x5a470010,0xb05b0012,0x6d4d008c}},	//   shwa_, _дэба, rfäh, loaa
  { {0xb05b00b8,0x6ecd000b,0x693c0085,0x7c67002b}},	//   sfäh, द्यु, očel, _داگل
  { {0xd4d90191,0x2e3c01ac,0xdb04016e,0xbe3c000a}},	//   ські_, יגונ, triç, יעות
  { {0x27ed0111,0xe3b10029,0x249f1097,0x98af00d4}},	//   _uren_, ررة_, raum_, angă_
  { {0x6b500123,0xb2250e3f,0x42251098,0x20e800a1}},	//   lägr, змол, здов, _ởi_
  { {0x06760053,0xdb0d02c1,0xc049000a,0x93240015}},	//   _זײער_, ntañ, _עז_, برين
  { {0x6908000a,0xdb0d0234,0x0000006a,0x0000006a}},	//   ַּרְ, kraï,   ,
  { {0x2ca00005,0x24580010,0xa9160053,0x645d0020}},	//   vaid_, _даць_, פֿטס_, üsid
  { {0x656900b8,0xdb1c1099,0x693c0816,0x2d7801c0}},	//   lmeh, özün, ečel, _očet_
  { {0xdb0d0152,0xbcfb002d,0x2ca0109a,0x12fa000a}},	//   traî, _shéa, taid_, _להסב
  { {0x65690012,0x3b86109b,0xf19a000a,0x6d4d02f2}},	//   nmeh, злаг, _פשפש, goaa
  { {0x6569003f,0xe1650002,0x25dd000b,0x1d07109c}},	// [1760] imeh, _تدوي, _कैसी_, чети_
  { {0x6b5000c0,0x98bd002a,0x693c02d8,0x2ca0109d}},	//   vägs, mowę_, ačel, said_
  { {0x1e970008,0x8e7b0008,0x5eeb0008,0x7e7b000a}},	//   _מכיל_, _לניה, _הַכְ, _לאיז
  { {0xbcfb002f,0xfd120015,0xf79a0015,0xa967006b}},	//   _théa, _أجد_, منصب_, пиха_
  { {0xdb0400dd,0x4879005e,0xa7b800fd,0x61e6003d}},	//   nsië, ісця_, ілку_, ākli
  { {0xdbc70020,0x7d04003c,0x96ba02e1,0xb8e3000b}},	//   tööt, ljis, суду_, _एफ़_
  { {0xd5af0010,0xdb0400c0,0xc1da000b,0x7c240045}},	//   эс_, rriä, _बनेग, lzir
  { {0xdce4016f,0x7d160007,0x2a3b000a,0xc4c60015}},	//   kmič, nkys, _העלמ, ستبو
  { {0xdb0d002e,0x59750033,0x9cd70c44,0xd9430317}},	//   otað, _цыру, לוקה_, _чети
  { {0xdb0d002e,0x6569002c,0x98bd005c,0x47d3002b}},	//   ntað, ameh, dowę_, _سيمر
  { {0x8675008f,0x656200e8,0x75960015,0xa2bd000b}},	//   _жыцц, _thoh, _رجاء, _शार्
  { {0x2d570064,0x3a370008,0xaa370135,0x61360046}},	//   rçek_, לרים_, לטיק_, yšle
  { {0x50640124,0xe907000a,0xdb0d001a,0xdb0400aa}},	//   етра, הֶם֙_, ktað, rsiê
  { {0x8d770015,0x7077002b,0x7c2402c6,0x941e0061}},	//   كارا, _کاغذ, dzir, ığıy
  { {0x9757000f,0x9f440046,0x7d04001a,0x7e44007e}},	//   פילו_, ímá_, fjis, ехте
  { {0x91bb0008,0x693c016f,0xd23b000a,0xb23b004f}},	//   _המהי, učel, _לגול, _לעוז
  { {0x7f840029,0xdb0d016e,0x50fa000a,0x6f010030}},	// [1770] _كلين, nuaç, _וִיד, ölcs
  { {0x501c0008,0x7d04109e,0xdb0d0144,0x4424109f}},	//   _לוחו, ajis, rraï, izm_
  { {0xceb200b2,0xdb040152,0x89d90086,0x99d90015}},	//   _ביי_, isiè, توار_, تواء_
  { {0xdb0d002d,0x7c240085,0xa2d3000b,0x79240b9b}},	//   mraí, bzir, _बॉन्, ньчж
  { {0xdb0d02c1,0xa8780029,0xe7a80036,0x66e510a0}},	//   stañ, أحمر_, звіл_, дола
  { {0x8ae40191,0x3ce90020,0xdb0d016e,0x1bfa000a}},	//   _післ, ldav_, duaç, _ולשב
  { {0xdb0d002d,0xcb12000a,0xb865002b,0x45d20099}},	//   nraí, _ילך_, ساچو, војс
  { {0x3ce90020,0x7ae700dc,0xfdf80008,0x838910a1}},	//   ndav_, _hajt, לצות_, обив_
  { {0xdb0d10a2,0x94720086,0x65690a83,0x92b50015}},	//   hraí, نگها, rmeh, وحدا
  { {0x2329005e,0x3f84001a,0x27e00061,0x394f10a3}},	//   іони_, ímum_, çine_, logs_
  { {0xcb120008,0xb2090063,0x461500a2,0x98af0091}},	//   דלי_, ценз_, _توار, angą_
  { {0xcea9013a,0x8fa60190,0xdce406c0,0x0000006a}},	//   _כי_, маме, tmič,
  { {0xbcfb0152,0xd9aa000b,0xdb0d016e,0x25a00085}},	//   _phén, _चट्ट, cuaç, ćile_
  { {0xdb0400dd,0x69d50079,0x7ae710a4,0xdb160003}},	//   rsië, _opze, _najt, puyé
  { {0xdb0d002f,0xdb040079,0x7d1604d1,0xc106006e}},	//   graí, ssië, tkys, _يوتي
  { {0x2f14007c,0xad650021,0xc19a004f,0x1d5500af}},	//   _mägi_, فاقه, _ושקי, еђус
  { {0x3ce6032c,0x4e7a0015,0x5f2a004a,0x394f0f21}},	// [1780] ľov_, _وحدد_, _моим_, dogs_
  { {0xd9100086,0x3ce6002c,0xfe94002b,0xa2d3000b}},	//   گیر_, žov_, _سیرج, _बॉम्
  { {0x4efb000a,0x2f14007c,0xdb0d0125,0x9a6a0015}},	//   _והיו, _nägi_, craí, آمال_
  { {0xdb0d0084,0x693c002c,0xda6500e6,0xd910002b}},	//   stað, mček, رالي, دیر_
  { {0x31da005d,0x98a30b18,0xdb04002d,0x7ae700dc}},	//   _बन्ध, тиче, iriú, _fajt
  { {0x66e30001,0x758a0142,0xc58a006b,0x19ba0015}},	//   воља, осив_, ощие_, _وطأة_
  { {0xf1dd000b,0xd5ba01f3,0x0f37004f,0x0000006a}},	//   _फैलन, іск_, ורסט_,
  { {0xdb0d001c,0x7ae710a5,0xb9060138,0x0000006a}},	//   tuaç, _zajt, _ўзак,
  { {0x63bb003f,0xa7a70004,0x693c0046,0x337410a6}},	//   guun, _окта_, yčej, нгир
  { {0x60c4001c,0x1bfb0053,0x25450024,0x764d0064}},	//   _acim, קליב, vēle_, şaya
  { {0xe13510a7,0xdb0410a8,0x63bb02f2,0xa1590432}},	//   енны, friú, auun, зану_
  { {0xdb040152,0x2d850046,0x26dc10a9,0x0000006a}},	//   ssiè, ílem_, levo_,
  { {0xb5a00001,0x2897000a,0xc1780091,0x78a001d7}},	//   _енcи, ודכן_, tvės_, _memv
  { {0xdb0d10aa,0xd80b004f,0x0000006a,0x0000006a}},	//   traí, חִלָ,   ,
  { {0xdb04002d,0x7ae706e7,0xb2bb000a,0xd2500015}},	//   briú, _rajt, _ומור, _حنث_
  { {0xdb0d0ac5,0x7ae710ab,0x6f1e0079,0x2545003d}},	//   rraí, _sajt, _elpc, pēle_
  { {0x3f67005f,0xbbb90036,0x60dd044d,0xc1790091}},	// [1790] _отоб, ягає_, mesm, svės_
  { {0xbcfb0152,0xc8790011,0x26dc04c6,0xc334000a}},	//   _théo, _iaşi_, jevo_, ׂוּ_
  { {0x7ac40063,0x394f0123,0x26dc10ac,0xb9940015}},	//   ъсте, togs_, devo_, َلْب
  { {0x25f4005d,0x2561001a,0x60dd10ad,0xdb1d0052}},	//   ्मनी_, kóla_, nesm, _ppsó
  { {0x2259002a,0xbcb6000a,0x394f10ae,0x7aca0065}},	//   ęski_, _אפרו_, rogs_, _सॉकॅ
  { {0x5fbc0053,0x8c180015,0x63bb008c,0x257110af}},	//   קצונ, _غيّر_, vuun, _išli_
  { {0x96940036,0x6d480152,0xaa58005e,0x60dd10b0}},	//   тріш, édag, _жиру_, kesm
  { {0x3ea10020,0xfba3000b,0x74150015,0x75d2002b}},	//   _leht_, _ओबाम, فوعا, اييا
  { {0x60dd10b1,0x4ac60065,0x25610052,0x36d510b2}},	//   desm, र्कव, góla_, _поар
  { {0x07f80029,0x68e90026,0x60dd007c,0xa20510b3}},	//   _ترفع_, _haed, eesm, епод
  { {0x68e900d9,0x9f40002d,0xdb04002d,0x63bb0044}},	//   _kaed, _triú_, triú, suun
  { {0x4acf005d,0xaacf005d,0x628a0493,0xd24e002b}},	//   स्तव, स्तक, _effo, حچه_
  { {0x653a0053,0xbcfb006f,0x7c3b10b4,0xb05b0123}},	//   _צענד, _chém, _žurn, dfäs
  { {0x83b6000a,0x63a910b5,0xf767006e,0x6d4110b6}},	//   _נפצע_, msen, طا_, élan
  { {0x523900b2,0x6136003d,0xc332000a,0x81bc003d}},	//   _מײַנ, ašla, _גוג_, nzēl
  { {0x693c006f,0x2167033d,0xfce310b7,0x1d070302}},	//   rček, _пищи_, лосо, неси_
  { {0x63a910b8,0x5bc60015,0xab6610b9,0x113b004f}},	// [17a0] nsen, عترف, евал, _מתקל
  { {0x3ea100b8,0xba260033,0x63a910ba,0x0000006a}},	//   _geht_, ндзк, isen,
  { {0xfe720015,0x63a90012,0x64590034,0x3e36002b}},	//   _حدة_, hsen, _lywi, _سعدآ
  { {0xc7c60229,0x63a910bb,0xb05b0123,0xc9930015}},	//   ески, ksen, mfär, النظ
  { {0x6459003f,0x41a6000b,0x2906008c,0x26dc10ac}},	//   _nywi, _कौनस, rjoa_, tevo_
  { {0x7bcb0008,0xeb910008,0x26dc02c1,0x63a910bc}},	//   _מֶלֶ, _כָל_, uevo_, dsen
  { {0xd9100074,0x68e900d9,0x78a000bd,0xaa460004}},	//   _پیش_, _faed, _temv, _чевл
  { {0x44f4009c,0x63a902de,0x64590034,0x6126001a}},	//   тпис, fsen, _bywi, _hólf
  { {0x645910bd,0x9696005e,0xd4670054,0xdb0d001a}},	//   _cywi, _зреш, ниће_, rtaö
  { {0x6459005c,0x21200049,0x2f14007c,0x2561002a}},	//   _dywi, _alih_, _kägu_, róla_
  { {0x225800fb,0x5ab70053,0x75d30031,0x7d0b0123}},	//   ærk_, עלטע_, _ميلا, ögsk
  { {0x010b0086,0x859b0053,0x2d810012,0xe1670015}},	//   ستجو_, _זשאו, _ruhe_, عددي
  { {0xc8790011,0x64590026,0x63a900dc,0x2d8110be}},	//   _paşi_, _gywi, csen, _suhe_
  { {0xb05b0400,0x2d81008c,0x93fb004f,0x0000006a}},	//   ffär, _puhe_, _מלדי,
  { {0xa01b0014,0x51f30115,0x82d7000a,0x2f14007c}},	//   nböz, _مسير, _נוהג_, _nägu_
  { {0xbcfb0152,0x5d780080,0xd657000a,0xdde30030}},	//   _thém, ейся_, גילת_, érőe
  { {0x7ff70029,0x5c750063,0x3b5500af,0x68e910bf}},	// [17b0] _أسعا, тлат, вкар, _raed
  { {0x291f0125,0x68fb00cb,0x2b14005e,0xb05b0123}},	//   _slua_, _snud, льєр, sfäs
  { {0xc3330008,0x63a910c0,0x68e910c1,0xe945009a}},	//   נוע_, zsen, _paed, پرای
  { {0x5dc8000a,0x63a910c2,0xa3e0000b,0x68e910c3}},	//   _אֶשְ, ysen, दबा_, _qaed
  { {0x34dd005d,0x25710085,0xfc64006b,0xbcf40195}},	//   _मसौद, _ušli_, _бърн, _спящ
  { {0x45d50ea6,0x8f9c000a,0x8c1a0643,0x6126001a}},	//   вцит, לידי, _חושי, _gólf
  { {0xd7580029,0xb8950015,0x6618006f,0x7d0f0030}},	//   رجها_, _للأع, _čaká, _kocs
  { {0xf8a90086,0xdb1c00dc,0xa5f60001,0x63a910c4}},	//   _آگاه_, özön, ђењу_, tsen
  { {0x777a08e0,0x49440010,0x9cd8000a,0x25a00085}},	//   _fitx, _сэрб, תוחה_, ćila_
  { {0x63a910c5,0xfbd2004f,0x82f5009b,0x7bcd10c6}},	//   rsen, סתי_, тчиц, itau
  { {0x6459005c,0x7bcd00f2,0xaac6000b,0x63a910c7}},	//   _wywi, htau, र्टक, ssen
  { {0x05960086,0xe4d70015,0x46580015,0x7bcd0dca}},	//   _شامگ, _ستصب, _أؤكد_, ktau
  { {0x61e10176,0xc7ac000a,0x74290015,0xa023007c}},	//   swll, ּׁלָ, _تكشف_, ööpr
  { {0x81bc0048,0xb4640036,0xb05b00c0,0x539a000a}},	//   izēj, _скіл, tfär, _חיסו
  { {0x2d9e0152,0x6da30063,0xed5a10c8,0x7d0f10c9}},	//   ète_, иира, дов_, _bocs
  { {0x693c10ca,0x7bcd0012,0xb05b038f,0xed4308a0}},	//   lčev, ftau, rfär, ансп
  { {0xed57092d,0xa05a0029,0xb05b0c77,0x3157004c}},	// [17c0] тот_, _تؤثر_, sfär, _שיפן_
  { {0x81bc0024,0x5fbb000a,0x693c0263,0x6d480030}},	//   dzēj, _קצינ, nčev, édab
  { {0x89f50010,0x99f50127,0x18a610cb,0xb05b0012}},	//   ляцц, ляці, ваем, ngän
  { {0xe9950086,0x672110cc,0x9c660015,0xdcfe10cd}},	//   اهنگ, _allj, _لهجو, _kupč
  { {0x2ba9005d,0xc0ad004c,0xb05b0012,0xb7d40015}},	//   _चौपा, ליאָ, hgän, اقتب
  { {0xceb3000a,0xcf93000a,0xa027001a,0xb9960015}},	//   ֑יו_, סטו_, _hröð, _للسب
  { {0x19b90080,0xceb30008,0xe9a30054,0xb5a30033}},	//   _путь_, ביו_, _васп, арый
  { {0x25450024,0x291c0024,0xaa4310ce,0x765a0046}},	//   tēla_, īvas_, _тесл, _vyty
  { {0x98360010,0x288b0086,0x765a005c,0xe6c60015}},	//   _рэві, _آصفی_, _wyty, _لتضي
  { {0xd7640086,0x764d00dc,0x6d58002e,0xd5b20015}},	//   _صنای, ényé, _ívaf, _نفط_
  { {0x69130482,0x3abb0008,0x71e30010,0x7abb000a}},	//   _içer, ומינ, ацяж, וציו
  { {0x5637004c,0x7bcd0091,0xf48310cf,0x254501ec}},	//   _באבע_, ytau, _кушн, pēla_
  { {0xc0580036,0xc9530008,0xa923006f,0x889b000a}},	//   вір_, שמר_, úžia, ובכי
  { {0xdb2301e2,0x21f40029,0x8233002b,0x82360015}},	//   örün, _مكتس, اریا, _لرعا
  { {0xde740015,0x912b0015,0xd37b004f,0xde5800ce}},	//   لدفع, _يسبق_, _קרוט, варі_
  { {0xdb210064,0x7bcd10d0,0x61260125,0xaac6000b}},	//   ştür, ttau, _rólg, र्घक
  { {0x2d580ac7,0x8aa702b0,0x213910d1,0xa134002b}},	// [17d0] тить_, вред, mish_, _خروش
  { {0xdd110048,0xbcfb002d,0x213910d2,0x6e99006b}},	//   _kļūd, _mhéi, lish_, _явор_
  { {0x9f490064,0x6d480152,0x7bcd10d3,0x2019008c}},	//   _araç_, édac, stau, lysi_
  { {0x213910d4,0x5df6000f,0xd23b000a,0xfdf6000a}},	//   nish_, _עזרא_, וגבל, _עצרת_
  { {0x8c670010,0x2ca9007c,0x37ab01e9,0x0000006a}},	//   _штод, maad_, фтен_,
  { {0xcc76000a,0x501c000a,0x36690579,0x81bc003d}},	//   _תעשה_, וודו, нало_, rzēj
  { {0x62860089,0xa493002b,0x4429006f,0x75220046}},	//   ěkol, لیات, _ťa_, _bloz
  { {0xa3e90063,0x04c90029,0xdb0d016e,0x13e9030c}},	//   едиа_, روخي_, fraç, емий_
  { {0xbcfb002f,0xdb0d001c,0x21390705,0x693c0073}},	//   _chéi, graç, dish_, tčev
  { {0x8c440064,0x693c00bc,0x201904b2,0x96f80058}},	//   _öğey, učev, dysi_, _لعمر_
  { {0xbbd0014e,0xc69200a3,0xf7700015,0x46150021}},	//   _सङ्क, _האב_, _ذاك_, _حوار
  { {0xbcfb002f,0xb05b00b8,0xdb0d016e,0xa2d3000b}},	//   _fhéi, rgän, braç, _बॉर्
  { {0xd36e002b,0xf539006f,0xbcfb0125,0x2ca9042f}},	//   تهی_, miť_, _ghéi, daad_
  { {0xf539032c,0x248d044b,0xa856000a,0xc43a000a}},	//   liť_, lcem_, רישה_, _אתני
  { {0x63bb0024,0x693c044c,0x2f140123,0xa1920099}},	//   lrun, očet, _sägs_, _лајч
  { {0xf539002c,0x693c10d5,0x63bb10d6,0x90360067}},	//   niť_, nčet, orun, _مرخص
  { {0xaaba0086,0xa7fd0030,0x6126026a,0x3ce010d7}},	// [17e0] فدار_, _szűn, _cóle, reiv_
  { {0x291d003f,0x7dea0033,0x8b260033,0x63bb10d8}},	//   ekwa_, _змог_, ыдзе, irun
  { {0x63bb018b,0xeb75008f,0xb5ad005e,0x8288000a}},	//   hrun, рытэ, _днiп, דְנֶ
  { {0xb95a003b,0xf539002c,0x6366001a,0x2d9810d9}},	//   رجاء_, jiť_, iðna, mpre_
  { {0xf539032c,0xb8dc005d,0x645d0020,0x6d440d72}},	//   diť_, _आय_, üsil, mnia
  { {0x96b70001,0xceb30008,0x6d4410da,0x75220085}},	//   гућу_, ֖יו_, lnia, _sloz
  { {0x63bb10db,0x25a00085,0x6d4410dc,0x213900da}},	//   erun, ćilo_, onia, yish_
  { {0xdb0d001c,0x3eaa00b8,0xc5f7002b,0xbcfb0125}},	//   traç, habt_, اعوض_, _phéi
  { {0x77920086,0xdb0d016e,0x6d4410dd,0x213910de}},	//   _ایتا, uraç, inia, vish_
  { {0x51f80036,0x2139003e,0x6d4400d9,0x693c00bd}},	//   вною_, wish_, hnia, ačet
  { {0xe3af0074,0xf539002c,0x213910df,0x2d980085}},	//   يری_, biť_, tish_, jpre_
  { {0x63bb00c0,0xbcfb10e0,0x75220085,0x2d9800bc}},	//   brun, _théi, _uloz, dpre_
  { {0x6d44005c,0x29370053,0x613600bd,0x21390b77}},	//   dnia, ראכן_, ošlj, rish_
  { {0xa294078f,0x6d4410e1,0x69dc10e2,0xd370002b}},	//   _такі, enia, _opre, _بهت_
  { {0xde590036,0x6560002d,0x6d440026,0x201f0007}},	//   таві_, olmh, fnia, šui_
  { {0x5c070063,0x865b000a,0x2d870030,0x6d5601d7}},	//   ляза, גדלי, _énem_, goya
  { {0x0b940015,0x69dc10e3,0x2ca910e4,0x2d9800bc}},	// [17f0] مجلد, _apre, raad_, apre_
  { {0xf539032c,0x2ca90035,0x63a2003f,0x543b0053}},	//   ziť_, saad_, _mwon, געמא
  { {0x8f7a000a,0x63bb003d,0xdb0410e5,0x9f7a000a}},	//   _שנתק, zrun, erió, _שנתח
  { {0xf1b30008,0x2ba9000b,0x6d44002a,0xdced00bc}},	//   מסע_, _चौथा, cnia, omač
  { {0xf53905cc,0xe6c50029,0x69dc0003,0x693c006f}},	//   viť_, لتغي, _epre, ečes
  { {0xf7960029,0x645d0020,0x7d0d10e6,0x291d002a}},	//   جنوب_, üsim, ljas, skwa_
  { {0xf539002c,0xff18000a,0xceb405bd,0x7d0d10e7}},	//   tiť_, רקות_, ציק_, ojas
  { {0x7d0d022d,0xb60500dc,0xce38000a,0x63bb10e8}},	//   njas, _aláí, טאות_, trun
  { {0xf5760029,0xf539002c,0x7d1a000a,0xe4510015}},	//   جميع_, riť_, דֵיה, غضب_
  { {0xc6a40083,0xadf7005d,0xe1f90036,0xf539002c}},	//   _грци, ुमान_, вго_, siť_
  { {0x6d440176,0x7d0d0084,0x06840029,0xf539002c}},	//   ynia, kjas, _المُ, piť_
  { {0x54550010,0xba56000a,0x63bb10e9,0xd919000a}},	//   _квет, יסתו_, prun, דוֹל
  { {0x7d0d10ea,0x6d5610eb,0x251a000a,0xc5740015}},	//   djas, voya, _שונא, _اطلع
  { {0x82350086,0xdb040020,0x08760053,0x6d4410ec}},	//   _پرتا, uriü, יערט_, wnia
  { {0x7d0d002e,0x6d44005c,0x442d10ed,0x6d5610ee}},	//   fjas, tnia, lze_, toya
  { {0x69c4000b,0x7aee0049,0x2d980003,0x7d0d001a}},	//   ांसी, _sabt, rpre_, gjas

  { {0x2d9804f9,0x69dc10ef,0x5aca0036,0xeab20002}},	// [1800] spre_, _spre, клам_, قعا_
  { {0x69dc003c,0x6d440472,0x442d10f0,0xb0b6000b}},	//   _ppre, snia, ize_, _आएँग
  { {0x2d850089,0xdebb039e,0x3ebb000a,0xd884002b}},	//   ílet_, _במיל, _בציב, مهای
  { {0x7d0b00c0,0x71d60008,0x9c830264,0xe3a70067}},	//   ögst, יועד_, účtu, _ور_
  { {0x442d0111,0xec470080,0x7c2d002a,0x79950012}},	//   jze_, _взял_, czar, _etzw
  { {0x501b0008,0x69960036,0x442d10f1,0x473300fd}},	//   כונו, _врах, dze_, оніс
  { {0xceb30008,0x98a60036,0xb0b6005d,0x69dc002c}},	//   קיה_, _вибе, _आएंग, _upre
  { {0x75290667,0x98af0045,0xa96a016a,0x628310f2}},	//   ghez, rigă_, _риба_, _agno
  { {0x43060036,0x394610f3,0x46b60015,0x534604bb}},	//   аїна, mnos_, _نحاس, ихоа
  { {0xf36600d0,0xc5d6005e,0x394610f4,0x7d0d10f5}},	//   јтин, _відь, lnos_, zjas
  { {0x7c2d052a,0x7980003f,0x21550033,0x31c3006b}},	//   zzar, _kimw, йкоў, осяв
  { {0x7529000c,0x39460a75,0xd2570033,0x442d0061}},	//   chez, nnos_, рць_, bze_
  { {0x442d0050,0xc0e4008f,0x33940029,0xaac7000b}},	//   cze_, цоўк, _التز, _लालक
  { {0x39460026,0xdced0227,0x6d480003,0xd4670054}},	//   hnos_, rmač, édan, _тиче_
  { {0xeca70e88,0x8d770115,0xa697000a,0x28d7000b}},	//   ијан, لارا, שכלה_, ण्डि
  { {0x427b0008,0x394600dc,0xc27b01ac,0x7c2d10f6}},	//   _באוג, jnos_, _ברוי, tzar
  { {0x29e804f9,0x67da0024,0xfa870001,0x957c005c}},	// [1810] _aşa_, nājā, аћем, _brąz
  { {0x394610f7,0x2bc80004,0x75290030,0xe451000a}},	//   enos_, јуто_, zhez, פֶן_
  { {0x7c2d005c,0x39460026,0x442d10f8,0xd357000a}},	//   szar, fnos_, zze_, סיבי_
  { {0x645d0020,0xa3b3000b,0xbcfb0003,0x394610f9}},	//   üsik, ड़ूँ_, _chét, gnos_
  { {0xb8ef000b,0x6aa70030,0xa91d0085,0x78ab10fa}},	//   _शा_, _tejf, _niže, ragv
  { {0x86980063,0x3946047e,0xa9970015,0xfa55002b}},	//   атът_, anos_, _نشرت, _هرزگ
  { {0x98af0007,0x9f4e00dc,0xc68e0015,0x2d680012}},	//   eigą_, énél_, رِي_, ißen_
  { {0x442d10fb,0x7ae50044,0x0000006a,0x0000006a}},	//   tze_, leht,   ,
  { {0xf794008f,0xc95201e4,0x442d06af,0x67da003d}},	//   _матэ, _זמן_, uze_, gājā
  { {0x442d10fc,0x93440015,0x2d8c0046,0x7ae510fd}},	//   rze_, ْخَم, ídek_, neht
  { {0x442d10fe,0x568c0053,0xdce4005c,0x78a9007c}},	//   sze_, _סטאַ, amię, _keev
  { {0x2d6800b8,0x6136006f,0xf0ba002b,0x3a36000a}},	//   eßen_, ošli, دادش_, מרתם_
  { {0x95540029,0x59c9000b,0xdb04001a,0x69c50012}},	//   _بخلا, ांडर, krið, huhe
  { {0x539a0008,0xa8560008,0x254c0089,0x61260656}},	//   _עיצו, מירה_, měla_, _dóla
  { {0xe1640086,0x69c50020,0x853c0091,0x7e690046}},	//   _وضعی, juhe, _kvėp, řepn
  { {0x91ba0053,0x63a40064,0x61360f28,0x52a7000b}},	//   _עמפי, _çinc, kšli, _ग़ुस
  { {0xdb04001c,0xbcfb0003,0xf3880016,0x9f400052}},	// [1820] nsiç, _rhét, _lợn_, _frið_
  { {0x6ac60015,0x09e6005e,0xf1db000b,0xdb04016e}},	//   إقام, йозн, _बहान, isiç
  { {0x1efb00b2,0x80cf000b,0xd946033d,0x0000006a}},	//   _עלטע, _थामे, бежи,
  { {0x256100dc,0x1d0a10ff,0xe7860a3e,0x984a1100}},	//   bóli_, _семи_, буко, ляла_
  { {0xaab80086,0x39461101,0x87d700c3,0x2ca0007c}},	//   _نگار_, rnos_, مبوس_, mbid_
  { {0xe9aa0086,0x254c0046,0x25a50034,0x2d8200da}},	//   _مدرن_, děla_, _bwll_, _hike_
  { {0x2d82003f,0x9998000a,0x29e80045,0x81bc003d}},	//   _kike_, _כֹּח, _uşa_, nzēt
  { {0x77861102,0x89d70015,0x2ca000aa,0x25a50034}},	//   _глаз, _دوفر_, nbid_, _dwll_
  { {0xccf3000f,0x442200dc,0x4acf000b,0x2d821103}},	//   לכה_, ák_, स्कव, _mike_
  { {0xaaa8005d,0x2d821104,0x26c8002b,0x53340033}},	//   गरिक, _like_, _خطری_, іент
  { {0xd5b90191,0x6126002e,0x71270029,0x23a9005d}},	//   _всі_, _sóla, مرحل, चीबद
  { {0x81bc0048,0x59c9005d,0xc5f30008,0xdfd10115}},	//   dzēt, ांतर, _מדע_, ويج_
  { {0xd8d700b2,0xa2d3005d,0xe3af0015,0xe571004f}},	//   זוכט_, _बॉक्, _كرو_, _חַג_
  { {0x43740074,0x6e940080,0xa7fd00dc,0x2d6800b8}},	//   _بهتر, зиру, _szűk, ußen_
  { {0xe1890092,0x2d821105,0xddc50046,0x9cf500e2}},	//   _hẳn_, _bike_, _vzhů, озві
  { {0x6126002e,0x6136006f,0x614401ca,0x628e00bc}},	//   _tóla, yšli, _неја, žbod
  { {0xdb041106,0x7ae51107,0xdcfe0045,0x67280030}},	// [1830] trið, teht, _supă, _oldj
  { {0x69c5002e,0xbcfb0003,0x9a8701e5,0x78a91108}},	//   tuhe, _chér, суал, _seev
  { {0xceb2000a,0x2ba9000b,0x7ae51109,0xd91b1100}},	//   _קיט_, _चौरा, reht, льд_
  { {0x69c5110a,0x7ae5110b,0x5c07110c,0x0000006a}},	//   ruhe, seht, _ляга,
  { {0xf771040b,0x78a9007c,0x69c5007c,0xb882006f}},	//   وات_, _veev, suhe, _šíri
  { {0x69c500f2,0x25a50026,0x07090015,0xa595110d}},	//   puhe, _pwll_, شيبي_, орищ
  { {0xf592003b,0x1efa00b2,0x78a90020,0x21290049}},	//   ولوج, ילװע, _teev, _olah_
  { {0x1bfd000b,0xb9250015,0x254c0046,0xfd8a004c}},	//   _उछाल_, _بفري, těla_, סטפּ
  { {0x98170074,0x27ed0f01,0x47940058,0xa8a400af}},	//   _ابزا, _usen_, _فجلس, _хрск
  { {0xdb16022d,0x15ab006b,0x247f003d,0x25a50034}},	//   styö, _бъди_, _rāmī_, _twll_
  { {0x81bc0048,0x2129002d,0xeab2000f,0x07080015}},	//   dzēs, _blah_, וֹר_, _ديلي_
  { {0x254c0046,0x7656004f,0x3ce30065,0xcb050065}},	//   pěla_, _ובעד_, ख़ों_, राँड_
  { {0xd24e0086,0x28d1000b,0x7e690046,0xefc7033d}},	//   فنی_, _हानि, řepl, олял_
  { {0x321e0176,0xd5dd000b,0xe299110e,0x040e0016}},	//   byty_, _महाज, _так_, _lýợn
  { {0xad3a0036,0x5fb6000b,0x2d82110f,0x8284002b}},	//   ачає_, _अटकल, _pike_, _عجول
  { {0xc5f20008,0x8d660010,0x4d66022a,0xa00a0015}},	//   ודל_, івае, ікав, _نقبل_
  { {0x25a0016f,0xcb05000b,0x5f760015,0x2ca01110}},	// [1840] ćili_, रांड_, _واخر, rbid_
  { {0x4a9a0033,0x5de61111,0x3a9a0138,0x0000006a}},	//   ртаў_, _джоа, ртаю_,
  { {0xa3a9005d,0x80b1000b,0x6c86002b,0x7f5c0003}},	//   गीत_, _अजमे, _ولدم, morq
  { {0xdd0f0064,0x6d410003,0x61fc0723,0x47d60058}},	//   mışs, élat, årli, قيصر
  { {0xbcfb1112,0x321e002a,0x6bd60015,0x7d061113}},	//   _thér, zyty_, _بتجر, _inks
  { {0xab2a0124,0x3ffb004c,0x27e90144,0x98aa0061}},	//   _тога_, יפנע, çana_, ımın_
  { {0x76a90036,0x386d00dc,0x0f7b000a,0xda650015}},	//   стів_, _ezer_, ברסל, _فافي
  { {0xdb0d001a,0xb603006f,0x1de2000b,0x3d180065}},	//   luað, úšal, _पहनत, _धकों_
  { {0xd90d0086,0xad1b000a,0x25a90085,0xe79e003d}},	//   _حین_, שופר, ćala_, ēlēš
  { {0x63bd00dc,0xd37000e5,0x7bdb000a,0xbb3a000a}},	//   ásna, عهد_, סקיו, יעִי
  { {0x28d1000b,0xd257005e,0x5afb0643,0x92581114}},	//   _हामि, жця_, בליצ, сант_
  { {0x94d40029,0x69c300bd,0x254c0046,0xd4f50033}},	//   _ريتش, šneg, mělo_, _нячы
  { {0xf8b30008,0xb0340080,0xb97b0135,0xdfdb006b}},	//   ושר_, дняш, ינטי, шън_
  { {0x7d0600df,0x25450024,0x543b004c,0x7c29002a}},	//   _anks, vēli_, _דעדא, _żero
  { {0xdef8008f,0x645d007c,0x98af0091,0x61261115}},	//   цыя_, üsiv, aigę_, _gólo
  { {0x25450024,0xe611000a,0x212901d7,0x61260030}},	//   tēli_, עִם_, _ulah_, _jóll
  { {0xac77002b,0xbe870015,0xa91d00bc,0x0000006a}},	// [1850] زارش, _وجدو, _niža,
  { {0x539b009d,0x99d70115,0x78a20057,0xdea1002b}},	//   יימו, قتصا, ebov, _سیری
  { {0x78750030,0x386d1116,0x6f7a004f,0x1a65009a}},	//   küvé, _szer_, _לְטו, سیری_
  { {0xdb0d002d,0xec150015,0xad19000a,0x254c0046}},	//   msaí, _فوجد, _הוֹר, dělo_
  { {0x07a50608,0x186907c1,0xe838005e,0xe8f80033}},	//   чалн, љали_, опці_, ўлі_
  { {0x3707005f,0x8c1a000a,0x2e0b004f,0xb9c70058}},	//   ючев, _הושי, ֹלֵ֣, _وتأه
  { {0xf6250142,0xd5e80015,0x9782002b,0x78a2005a}},	//   ядко, قعين_, ریمه, bbov
  { {0xf5091117,0x395f1118,0x0000006a,0x0000006a}},	//   снил_, _ukus_,   ,
  { {0x97c40015,0xe796002b,0x612601c0,0x7cfa004f}},	//   _يقفو, _فالک, _sólo, זִיק
  { {0x395d003e,0xfbd20008,0x69d70144,0xdb04016e}},	//   lows_, עתי_, otxe, briõ
  { {0xeccb014e,0x644d0007,0x4add000b,0x9975000a}},	//   िलाफ, _žaid, न्यव, ּתָא_
  { {0x8a16000a,0x69d70144,0xe8d5000a,0xa4d5005e}},	//   לחתו_, itxe, הוֹר_, _ході
  { {0x4f960010,0xa3f40036,0x94040015,0xd12f0015}},	//   ярну, _опці, _يومه, امُ_
  { {0x539a0008,0x0735004c,0x2d961119,0x23fa004f}},	//   _היסו, לאָם_, зрас, _להנא
  { {0x78a20057,0x78bb0085,0x6126001a,0xde030342}},	//   ybov, _oduv, _hólm, нпри
  { {0x91ba0008,0xc5f20135,0xc1ba000a,0x621a004c}},	//   _המקי, עדן_, _המקש, _לוצק
  { {0xa08b000a,0xbbe90015,0x50460054,0xe8df0016}},	// [1860] _לְיִ, يركم_, _хепб, _ngựa_
  { {0x3057004f,0xdb5900ce,0x6d41111a,0x0000006a}},	//   _משפך_, оює_, élar,
  { {0x273000a7,0xe9da111b,0xdb0d002d,0x38c8002b}},	//   _hàng_, ске_, csaí, قاشی_
  { {0xd9100086,0x78a20069,0xb05b0123,0x27ff111c}},	//   خیر_, ubov, rgäv, _brun_
  { {0x78a2111d,0x7d7b000a,0xa09b015b,0xdb040125}},	//   rbov, _לנטו, ציסט, isiú
  { {0xb5a6005e,0x28d1000b,0x27300016,0x78a20079}},	//   прий, _हाथि, _màng_, sbov
  { {0xa5d70029,0x27300092,0x18a6005e,0xb9b5006b}},	//   كبير_, _làng_, _навм, _остъ
  { {0x539803fc,0xa5070054,0xd4c30138,0x0000006a}},	//   овия_, зећа_, нсьп,
  { {0xb8e2000b,0x27300016,0xf493006e,0xddde005a}},	//   ूल_, _nàng_, رشيد, _vzpř
  { {0x59d00372,0x798e000c,0xaacc005d,0xa91d0089}},	//   _हमार, _kubw, ालिक, _jižn
  { {0xd7570015,0x20000045,0x877b000a,0x41e6005e}},	//   _علمت_, _arii_, _פאבי, чіпа
  { {0x27300016,0xa91d00bc,0x6366001a,0xe57a0054}},	//   _bàng_, _ližn, iðni, _узе_
  { {0x27300023,0x645d0020,0xc05b0210,0x63ae0046}},	//   _càng_, üsit, сін_, áhně
  { {0x27300092,0x3f85002e,0x7bc40351,0xa91d111e}},	//   _dàng_, ölu_, driu, _nižn
  { {0x7bc40005,0x7af500bd,0xd24f0033,0x62660015}},	//   eriu, _razt, _чц_, _عاتق
  { {0xf5490092,0x859b000a,0xfaf3002b,0xdb0d0125}},	//   hấn_, משלו, کثر_, rsaí
  { {0x70550074,0x2bb80029,0xc1580008,0x6c54067d}},	// [1870] _زندا, كالة_, _משהו_, екту
  { {0x539b000a,0x60dd0028,0x1ac70065,0x2fd40058}},	//   ציבו, lfsm, _लाओथ, _أتيح
  { {0x79a40080,0x2a980015,0x7bc4025a,0xa2cf000b}},	//   ерче, سئلة_, ariu, _दास्
  { {0x7bc400da,0x63740144,0xcdb6004f,0x527b004f}},	//   briu, lànd, _קפרה_, זנבא
  { {0x7bc40251,0x6cfa000a,0x2cfa000a,0x395d111f}},	//   criu, _ופרס, _ולרא, rows_
  { {0x6d4d0079,0xf773012c,0xbae50058,0xe595009a}},	//   lnaa, راش_, _تكسي, وشبخ
  { {0x80bf005d,0x6d4d1120,0xe7560015,0x25a90085}},	//   ्लाइ, onaa, بلوغ_, ćalo_
  { {0x26d80123,0x6d4d1121,0x63bd013f,0x629803f8}},	//   _öron_, nnaa, ásno, _afvo
  { {0x23d4008f,0x47d500e6,0x6d480003,0x63a40061}},	//   нцэр, _زيار, édai, _çinl
  { {0x27300092,0xd7740015,0x69c50012,0x68eb08cf}},	//   _ràng_, _كالع, orhe, legd
  { {0x27300092,0x69c50026,0xa0c60015,0x60dd0012}},	//   _sàng_, nrhe, ويدو, ffsm
  { {0xd7d1014e,0x25450048,0xe7d1014e,0x69c500f2}},	//   _समाच, tēlu_, _समाप, irhe
  { {0x69c500b8,0x644e0061,0x6d4d0079,0x316c003d}},	//   hrhe, şbir, dnaa, ēdz_
  { {0x27300092,0xf1a80086,0xef830033,0x68eb00aa}},	//   _vàng_, _کاوه_, кляп, hegd
  { {0xa3a9000b,0xa91d0085,0x01360015,0x329a004f}},	//   गीर_, _nižo, _يعبد, _ובצד
  { {0x27300092,0x1d07018d,0x65691122,0x6d4d1123}},	//   _tàng_, меси_, nleh, gnaa
  { {0x6b870298,0x5fd2005d,0x7bc40007,0x799c06bd}},	// [1880] _bijg, _तमिल, uriu, _strw
  { {0xdcfd0048,0x6d4d1124,0x63740144,0x65691125}},	//   _visā, anaa, cànd, hleh
  { {0x20050024,0xfe720029,0x2d95006b,0xaadd000b}},	//   ālie_, _جدة_, _пряс, न्धक
  { {0x7bc40011,0x98a6004a,0x68460015,0x41c5000b}},	//   priu, фиде, وَال, _विनस
  { {0xeb9a03de,0x65690046,0x69c51126,0xd765002b}},	//   _фиг_, dleh, arhe, کنوی
  { {0xa037000a,0xf5490016,0x69c30046,0x2259005a}},	//   ואנה_, uấn_, ánec, řsky_
  { {0xa3b0000b,0xf5490016,0x799c002a,0x8cd5000b}},	//   टीन_, rấn_, _utrw, _णामो
  { {0x6ba501d1,0xdce40844,0xb90303de,0x13f4006b}},	//   _åtgä, klič, _изск, езия
  { {0xd8d700b2,0xbcfb0089,0xf8631127,0x7c241128}},	//   _קומט_, _okén, _авто, nyir
  { {0x6126002e,0x521409ef,0xab2b000a,0x657b02f2}},	//   _fólk, едот, ַ֥יִ, amuh
  { {0xa2cf000b,0xdce41129,0x6d4d112a,0x6569112b}},	//   _दार्, elič, ynaa, bleh
  { {0xf3880023,0x4035112c,0x96da0065,0x03a6112d}},	//   _lợi_, еемс, प्रॉ, _жидо
  { {0x28d1005d,0x63740251,0x60dd002e,0xb05b00c0}},	//   _हासि, tànd, rfsm, egär
  { {0x4424005c,0x656000dc,0x741300c3,0x636f01de}},	//   mym_, lomh, _جوها, lønn
  { {0x200d0011,0xf1c5005d,0x1df804ab,0x4424112e}},	//   ţei_, _वियन, меры_, lym_
  { {0xdce4112f,0x91bb000a,0xc445002b,0x69c50046}},	//   blič, _ומהי, _آیین_, vrhe
  { {0x44241130,0x6d4d1131,0x351b000a,0x68eb0030}},	// [1890] nym_, rnaa, קומנ, vegd
  { {0x6d4d016b,0x6560002d,0xa3e6000b,0x65690046}},	//   snaa, homh, _पहन_, zleh
  { {0xf9900015,0x6d4d0079,0x3d29002b,0x2d45003d}},	//   لبن_, pnaa, _فتحی_, uķes_
  { {0x4424002c,0xc27b000f,0x636f00cb,0x99d4006e}},	//   kym_, קראי, jønn, ئتلا
  { {0x0138000a,0x25ac0034,0x7c8407f7,0x6b870079}},	//   וראת_, _awdl_, _ауре, _tijg
  { {0x7d1d0014,0x442400f8,0x28d10065,0x0000006a}},	//   _hoss, dym_, _हावि,
  { {0xdce40198,0xf3880092,0x3cf90020,0xacbb0003}},	//   zlič, _gợi_, _kasv_, _flût
  { {0x7d1d022d,0xa5650086,0xccf2000a,0x657b02f2}},	//   _joss, رگان, ָ֛ה_, umuh
  { {0x13e60080,0xa3a9000b,0xd777012c,0x7d1d1132}},	//   емый_, गीं_, _قاطع, _moss
  { {0x25450024,0x7d1d1133,0x65691134,0xe735004f}},	//   tēls_, _loss, sleh, _אָ֣ז_
  { {0xb979000a,0xcb12039e,0xc049000a,0xf41f007c}},	//   ּנָי, אלי_, _פז_, ääb_
  { {0x7d1d03af,0x442410ec,0xdce410cd,0x0000006a}},	//   _noss, bym_, tlič,
  { {0x4424005c,0xb42700e6,0x44270087,0x75290030}},	//   cym_, _تعاو, _تراف, mkez
  { {0x75290014,0xb05b00c0,0x7bcd007c,0x798900aa}},	//   lkez, tgär, duau, _liew
  { {0xc69205af,0x8db50036,0x6e930002,0xdd920031}},	//   ראל_, ксті, الفا, اور_
  { {0x79890050,0x2d9e0024,0x75290030,0x8e830015}},	//   _niew, īte_, nkez, الِه
  { {0x7ff60029,0x90460086,0x7d1d1135,0x32d9000a}},	// [18a0] _أسبا, _سنده, _doss, ּחֲנ
  { {0x272b003c,0x7c36002a,0x305b004f,0xe8030065}},	//   _sønn_, rzyr, _מדפד, लिना_
  { {0xda660029,0x4424005c,0x3f92003f,0xddde005c}},	//   راطي, zym_, _huyu_, _wypł
  { {0x69c302c1,0x59d2000b,0xd884002b,0x612605a4}},	//   ánea, दंबर, نهای, _bóli
  { {0xa7fd0014,0x9d1b0053,0x75290030,0xeb9701b7}},	//   _szűr, _זוכט, dkez, _пия_
  { {0x57f30001,0xa84700e6,0x254c0089,0x07a30054}},	//   упшт, علوم_, měli_, ћајн
  { {0x44240050,0x38c8002b,0x35f70015,0x0d3a004f}},	//   wym_, _ياری_, فريد_, ּגִב
  { {0x752900dc,0x89db0008,0xc4480086,0x44241136}},	//   gkez, _מחלי, ویان_, tym_
  { {0x8497003b,0x39460f30,0xa806005e,0x636f04d1}},	//   رئيس_, mios_, _язал, rønn
  { {0x656002e9,0xa91d00bd,0x39461137,0x44241138}},	//   somh, _nižj, lios_, rym_
  { {0xa159059c,0x75d60015,0xb2c6002b,0x53c2000b}},	//   дану_, _سيشا, وغگو, _शिवश
  { {0xd2570010,0x31c30010,0xb7f4000b,0x4657004c}},	//   эцы_, ысьв, _इनाम_, _אױבן_
  { {0xc9530008,0xe803005d,0xb803000b,0x5f94024f}},	//   רמר_, लिया_, लियम_, лият
  { {0xdefb0010,0x254c0089,0x539b00a3,0xfdfe000b}},	//   чым_, děli_, _ציוו, ॉमंस_
  { {0x39460007,0x80a2005d,0x7d1d1139,0x12fb0447}},	//   kios_, _क्वे, _poss, _מהגב
  { {0x6366002e,0x9d18113a,0x0000006a,0x0000006a}},	//   rðnu, ност_,   ,
  { {0xdb0d113b,0x7d1d113c,0x3946113d,0x1f75006b}},	// [18b0] nsaç, _voss, dios_, _илия
  { {0xdb0d113e,0x7989002a,0x629a113f,0x3946059d}},	//   trañ, _siew, ncto, eios_
  { {0xa2d8021e,0x394609ae,0xbd79005e,0x629a1140}},	//   _मान्, fios_, _обоє_, icto
  { {0xad270015,0x6d480140,0x61e50012,0x39461141}},	//   _أردو, édat, _ähle, gios_
  { {0x7989003e,0x7c670087,0x2ca91142,0x0000006a}},	//   _view, _ساحل, mbad_,
  { {0xd00c000a,0xd618002b,0x2d8b0077,0xcf940643}},	//   לּוֹ, کتها_, _hice_, אטס_
  { {0x752903c0,0x56920001,0x39461143,0x5b56004f}},	//   tkez, шајт, bios_, _יישב_
  { {0x394606d4,0x6126001a,0xa3b9006e,0x2ca91144}},	//   cios_, _tóli, واخر_, nbad_
  { {0x80a2014e,0x75291145,0xa6f50001,0x442b1146}},	//   _क्षे, rkez, _изаш, ác_
  { {0x3eb3003e,0x69ca001c,0x63740251,0x13020010}},	//   _next_, áfeg, vànc, азьм
  { {0x68fb0458,0x3f920064,0x75290030,0x46150021}},	//   _kaud, _suyu_, pkez, _جوار
  { {0x2eaa014e,0x63740251,0x291f0003,0x68fb1147}},	//   कर्त, tànc, _joua_, _jaud
  { {0x88ba000a,0x20041148,0x68fb1149,0x73c4002b}},	//   וזרי, ími_, _maud, _مينم
  { {0x80a2014e,0x2d8b002d,0x63bb114a,0x6f63004a}},	//   _क्रे, _aice_, msun, ивяз
  { {0x7ed6002b,0x63bb114b,0x2d8b114c,0xc332004f}},	//   _یزدا, lsun, _bice_, _דוג_
  { {0x57d1005d,0x291f0011,0xf2880053,0x254c0089}},	//   _समूह, _noua_, _אָפֿ, těli_
  { {0x69c3002c,0x2d8b114d,0x63bb114e,0xdb0d001a}},	// [18c0] ánen, _dice_, nsun, trað
  { {0x5fb70008,0xffb7000a,0x7e760015,0x63bb114f}},	//   _שהיא_, _שליש_, _لاجئ, isun
  { {0x39460467,0x3ebe002e,0x9046002b,0x9b650015}},	//   tios_, óttu_, _سنگه, اطقه
  { {0x1e570008,0xc7a60fea,0x621a004c,0x63bb1150}},	//   _ישיר_, видк, וועק, ksun
  { {0x68fb0048,0x291f0011,0xf7f30029,0xbb860015}},	//   _daud, _doua_, لسود, _للحي
  { {0x394600df,0x2d8b0011,0xe7e3000b,0xc7a30054}},	//   sios_, _zice_, _गहरा_, шиљк
  { {0x7afc0f04,0x39460c98,0x68fb1151,0xb8960015}},	//   _iart, pios_, _faud, _للزع
  { {0x29dc0467,0x68fb1152,0x80a2000b,0x44f40054}},	//   mía_, _gaud, _क्ले, упис
  { {0xc9550010,0xb86600e5,0x3eb81153,0x1c05000b}},	//   _стры, _شارو, kart_, रियल_
  { {0x68fb0024,0xe44f0015,0xdb0d016e,0xa6c70763}},	//   _zaud, تضى_, rsaç, _алфа_
  { {0x29dc1154,0x63bb05d0,0x0697000a,0xc50a0015}},	//   nía_, asun, _סדאם_, _يتصل_
  { {0x68e20026,0x2d80005c,0x21640286,0x64a61155}},	//   nfod, jmie_, итяг, _рада
  { {0xdb0402c1,0x4fc70063,0xb4ae005d,0x3eb81156}},	//   nsió, ъсна, करी_, fart_
  { {0x63a200b6,0x0ccb005d,0xe803005d,0x2d8b0089}},	//   _iton, िल्म, लिता_, _sice_
  { {0x29dc0077,0xdb041157,0x2e480342,0x3e7c005a}},	//   jía_, mpiè, вято_, váté_
  { {0x29dc02c1,0xeca40054,0x3eb8053a,0xa2d8000b}},	//   día_, ијун, aart_, _माड्
  { {0xfbd00029,0x25a9016f,0x50b80002,0x3eb81158}},	// [18d0] قتل_, ćali_, _شديد_, bart_
  { {0x29dc0467,0xe4e2014e,0x1fa40063,0x79a7000d}},	//   fía_, क्ति_, _тръг, врде
  { {0x29dc0467,0x68e20026,0x99870046,0xdbd10012}},	//   gía_, ffod, ánů_, _füße
  { {0x63a21159,0x08d4005e,0x7c320030,0x7afc115a}},	//   _oton, иція, ókró, _eart
  { {0xb8db014e,0x115a004c,0xdd3a004c,0x7afc115b}},	//   _आज_, עדױע, _נעשכ, _fart
  { {0x29dc0467,0x68e20026,0x7afc0c8c,0xf72b0033}},	//   bía_, afod, _gart, ьцей_
  { {0x29dc0467,0x3a840010,0x69de0111,0x290e002d}},	//   cía_, _вытв, ctpe, ámaí_
  { {0x7afc0012,0x254c002a,0x63bb115c,0x3eb8115d}},	//   _zart, yśle_, tsun, zart_
  { {0xe3b1003b,0xbcfb032c,0x80bf000b,0x7afc0125}},	//   حرب_, _akék, ्लैं, _yart
  { {0x63bb115e,0xdc88000a,0xae13000b,0x2d80002a}},	//   rsun, כְתָ, डमान_, zmie_
  { {0x63bb115f,0xe8df0092,0x2d80002a,0xe4d50067}},	//   ssun, _ngừa_, ymie_, _مقاد
  { {0x34950124,0x7fd6042b,0x3eb81160,0x8fa61161}},	//   _садр, лігі, wart_, ламе
  { {0x67211162,0x251a000a,0xf4870054,0x3eb81163}},	//   _kolj, _רונא, _ружн, tart_
  { {0x08760053,0x083a004c,0x61260030,0xdbd10012}},	//   טערט_, געשל, _rólu, _süße
  { {0xa2d8005d,0xe4f9005d,0x68e20026,0xf3880016}},	//   _मात्, ्यपि_, yfod, _vợt_
  { {0x5c16005f,0x29dc02c1,0xa3b0000b,0xfc3f0077}},	//   льзу, vía_, टीव_, _reír_
  { {0x2d801164,0x3eb81165,0x69c30091,0x7afc1166}},	// [18e0] rmie_, part_, šnel, _part
  { {0x0eaa008f,0x2d80002c,0x29dc1167,0x5f060033}},	//   _якой_, smie_, tía_, _ёзна
  { {0x7afc1168,0x8e76000d,0x18a60457,0x5edb000a}},	//   _vart, _љупч, гаем, _אחיה
  { {0x29dc0467,0x386d01f0,0xc8b60015,0x7afc1169}},	//   ría_, _byer_, اصاب, _wart
  { {0x6d460064,0x68e20026,0x718b0053,0x7afc116a}},	//   _imka, rfod, גװײַ, _tart
  { {0xdb040467,0xa2d8005d,0xbcfb002c,0x29dc116b}},	//   rsió, _माध्, _akéh, pía_
  { {0xf41f022d,0xe9a3008f,0x6721016f,0xa9f8000a}},	//   ään_, _гасп, _dolj, _בִּת
  { {0xb4ae000b,0xaa430238,0x95d7006b,0x186a029f}},	//   करे_, _уесл, удът_, _заби_
  { {0x68e40020,0x14d5000b,0x08f90015,0xd7ca0015}},	//   õidu, _धारण, _جرّب_, _سواه_
  { {0x7982005c,0xeab6000a,0x4b37004c,0x672100bc}},	//   lmow, נִ֥י_, ָרטל_, _golj
  { {0xe693003b,0x06560010,0xf656005e,0xe44f002b}},	//   _المد, _стаў, _стаю, قضی_
  { {0xd59b000a,0x6ed70065,0x759b004f,0x644f016d}},	//   _נבדל, _बाहु, _נידח, úcic
  { {0x236500bc,0xaf37006e,0x2af6000b,0xe4760033}},	//   bolj_, هرست, ीयाँ_, _сужэ
  { {0x88bd0050,0x343b0053,0xde590033,0xb2a60015}},	//   _kośc, _אײדע, вагі_, _صحته
  { {0xd2b70135,0x2bc7000b,0x98bd002a,0xe29b000a}},	//   _גלות_, _लिहा, liwą_, _אשור
  { {0x7982005c,0x88bd002a,0x3169036d,0x23b8000b}},	//   jmow, _mośc, _ukaz_, _इबाद
  { {0x7982002a,0xfaa7005e,0x40ec000a,0x7ff70058}},	// [18f0] dmow, гшен, _נַהֲ, _إسعا
  { {0x20090003,0x69c300bc,0x2d680012,0x9b440015}},	//   _irai_, šnem, ußer_, منقو
  { {0xdb580080,0xeb9f0134,0x7bcb002e,0x12eb000a}},	//   уют_, _grøn_, águb, עַמּ
  { {0x97c50029,0x7bdf0012,0x3f83003d,0x2009116c}},	//   لقصو, ptqu, lmju_, _krai_
  { {0x6721065d,0x27c70080,0xdcef002a,0x9cd6000a}},	//   _polj, ущег, _chcą, _דורה_
  { {0x386d0123,0xd70502ed,0x79820535,0x9a87116d}},	//   _vyer_, рзки, amow, _бубл
  { {0x7bcd0084,0x6721116e,0x236500bd,0xe736006b}},	//   lrau, _volj, volj_, рещ_
  { {0x7bcd0012,0x20090091,0x87d70058,0x64a5116f}},	//   orau, _orai_, _مغطا, јапа
  { {0x36d50860,0x7bcd0435,0x7ce8000a,0x66080012}},	//   _возр, nrau, אַתֶ, _erdk
  { {0x82350029,0x96f800c3,0x2b0e000b,0xb3e80021}},	//   لرجا, _معمر_, साएँ_, اعيل_
  { {0xf7840029,0x88bd005c,0x7bcd00b8,0xc692000a}},	//   _اللَ, _gośc, hrau, _ואב_
  { {0x2b17005d,0x291d003f,0x7bcd1170,0xab66002a}},	//   नाडु_, njwa_, krau, _zażą
  { {0xdfd20015,0x23650085,0x20091171,0xa3a70054}},	//   غيس_, polj_, _crai_, _сјек
  { {0x82a5005f,0x7982005c,0x56b50053,0xe4560053}},	//   _такж, zmow, יפֿן_, _דינט_
  { {0x69c303cd,0x68e908aa,0x7e23012e,0x76000030}},	//   šnej, _obed, одрж, mázá
  { {0xf3880023,0x76000014,0x27ed00ed,0x63a91172}},	//   _hợp_, lázá, _open_, open
  { {0x4d630036,0x0b46070e,0x6a96005e,0xfc031173}},	// [1900] ікув, анан, ареє, опто
  { {0xbd460086,0x3c190010,0x63a90d89,0xb4ab001a}},	//   _چندي, ыўся_, ipen, íþjó
  { {0xe9da1174,0xeb750010,0xa2d8005d,0x27ed0079}},	//   тке_, сытэ, _मास्, _apen_
  { {0x88e6005f,0xa3e6005d,0x7bcd1175,0x853c0091}},	//   ржде, _पहल_, brau, _atėn
  { {0x7982005c,0x76000089,0xa09b000a,0x68430174}},	//   rmow, kázá, דינט, онца
  { {0xceb3000a,0x88bd002a,0x41c5000b,0x68e90061}},	//   ֗יו_, _pośc, _विंस, _ebed
  { {0xceb30008,0xd5b704ab,0xce36015b,0x63a91176}},	//   חיו_, асы_, יאַת_, epen
  { {0x5ca9000a,0x55060004,0x2ca00b95,0xab660535}},	//   ְׁתַ, рчка, ncid_, _ważą
  { {0xad370053,0xa507023e,0x27e9028f,0x07a30004}},	//   ינקס_, рења_, çant_, _матн
  { {0x3d0d000b,0x0000006a,0x0000006a,0x0000006a}},	//   _ढोने_,   ,   ,
  { {0xd2570036,0x2d9e0089,0xfa97000a,0x11d80015}},	//   ицю_, ítel_, ידיש_, دوجة_
  { {0xc05b0010,0xe0d00015,0xf5390046,0x80a2000b}},	//   віг_, وزُ_, chť_, कुले
  { {0xe53b0008,0xc05b0036,0xdb0d0030,0x2294006b}},	//   _בתאר, тін_, őkén, _лиля
  { {0x20090152,0xb4e2000b,0x6d561177,0xf09f0144}},	//   _vrai_, क्रय_, enya, scà_
  { {0xd337000a,0x637b000a,0x7052002b,0xfd1300c3}},	//   _דרגה_, _שנוד, قچیا, يجر_
  { {0x7bcd1178,0xc0cb1179,0x2009117a,0x4c94004a}},	//   trau, _руке_, _trai_, житс
  { {0x2bb80015,0x2d9c0030,0x317c0447,0xe571000a}},	// [1910] لالة_, _éven_, _ברהמ, פַל_
  { {0x7bcd117b,0xfaa70033,0xfb380054,0xda07005e}},	//   rrau, ршан, азуј_, ичеп
  { {0xb8950015,0xcb680067,0xb8b70015,0xceb2000a}},	//   ملاع, جمله_, لإشت, _מיי_
  { {0x637d0291,0x27390003,0x63a9117c,0xd87900c3}},	//   mène, _mène_, ypen, همات_
  { {0x98e40029,0xe6c50015,0xcce6002b,0x63a900da}},	//   تكنو, متغي, _اسپي, xpen
  { {0xf5490092,0xc7c80010,0x57a40010,0x6aa90061}},	//   hất_, рыце_, ішча, _şeff
  { {0x0f380053,0xceb4000a,0x8f38004c,0x7600117d}},	//   שרוט_, קיק_, שאוו_, vázá
  { {0x1e58013a,0xae58000a,0xcdaa004c,0x68e90085}},	//   ישור_, יסוס_, ניפֿ, _ubed
  { {0xe6c70086,0x63a9117e,0x637d0003,0x6b850125}},	//   _نتاي, upen, hène, omhg
  { {0xf5e70191,0x7c2d117f,0x6d4d007c,0x63a90faa}},	//   _відм, iyar, hiaa, rpen
  { {0xa2d8014e,0x7c2d1180,0x22490684,0x2128002b}},	//   _मार्, hyar, упни_, ليدی_
  { {0x04950029,0x645e005c,0xa9fa000a,0x7a88000a}},	//   _الإح, _śpie, נִית, יָרַ
  { {0xd496000a,0x6d4d1181,0x8467009b,0x0000006a}},	//   _הכנת_, diaa, _тъже,
  { {0xe4500029,0xf412000a,0x83640021,0x94740015}},	//   _تضم_, _מפד_, _ودول, _بدما
  { {0x9f4b00dc,0x9d560002,0xc692000a,0x442d1182}},	//   óját_, منست, לאם_, lye_
  { {0xe0da0124,0xad39005e,0xdced05b8,0x6d4d1183}},	//   _сви_, ачує_, rmağ, giaa
  { {0x442d0f4d,0x4f5a0086,0x6d560665,0x443f1184}},	// [1920] nye_, _مجدد_, rnya, nzu_
  { {0x8a3a005f,0x6c330015,0x6c55005e,0x442d0061}},	//   ляет_, أفكا, іттє, iye_
  { {0xd9100086,0xb4f9000b,0xf9920015,0xb2ba004c}},	//   ویس_, ्याय_, سبا_, רמער
  { {0x6d4d0111,0xf969005e,0x442d044d,0xbd46009a}},	//   ciaa, арій_, kye_, _چنگي
  { {0x307a00b2,0x3eba003e,0x29120064,0x2bba0029}},	//   װאַנ, _kept_, ıya_, _حاجة_
  { {0x443f03eb,0x29001185,0xd6cf0015,0x69961186}},	//   dzu_, žia_, فقه_, _грах
  { {0x7abb0008,0xa3b0005d,0xe7f4000b,0x2a350033}},	//   _תצלו, टीई_, _इनका_, _дэтр
  { {0x442d003f,0x7d041187,0x88c50015,0x3e830003}},	//   fye_, ndis, _وتقل, lété_
  { {0xd90d002b,0xfc4a0046,0x389b000a,0x7d041188}},	//   _جین_, blíž_, _תימנ, idis
  { {0x7d04022d,0xdced0263,0xd6d20018,0x87250015}},	//   hdis, vlač, _رقص_, _وعلم
  { {0x36060015,0x443f1189,0x7d0407a3,0x62740058}},	//   _دواف, azu_, kdis, تهدئ
  { {0xd257078f,0xf5490092,0xdced0227,0x78a20057}},	//   сць_, uất_, tlač, ncov
  { {0x443f005c,0xb97b0008,0x5067118a,0x7d04118b}},	//   czu_, טנטי, стна, ddis
  { {0xa8570008,0x88bd005c,0xdd950033,0x6d5a0003}},	//   מיכה_, _nośn, жавы, étan
  { {0x81a60029,0x8d770031,0xb2bb000a,0x6d4d118c}},	//   _احتل, مارا, _גמור, tiaa
  { {0xbd6b0080,0xdced0844,0x78a204b2,0x64400244}},	//   урге_, plač, jcov, ozmi
  { {0x7bd600e8,0x88bd002a,0xfd440033,0x64400012}},	// [1930] guyu, _bośn, чэрн, nzmi
  { {0x64400024,0x7d04118d,0x3ed50040,0xfb84056d}},	//   izmi, adis, _بقدر, пыхн
  { {0x637d0251,0x7c2d0849,0x314b000a,0xa9f50015}},	//   lènc, syar, ְתְּ, تكاث
  { {0x27300023,0x26de0896,0x7c2d118e,0x3915110d}},	//   _hành_, _acto_, pyar, юмер
  { {0x186900d7,0xb901000b,0x98c50061,0x637d0144}},	//   јали_, _दा_, çtır_, nènc
  { {0x442d0061,0x16a6005e,0xe736118f,0x637d0144}},	//   vye_, овши_, жеш_, iènc
  { {0xf77003c4,0x442d00dd,0x656900f2,0x316b002a}},	//   راه_, wye_, toeh, kocz_
  { {0xce380008,0x27300092,0x442d1190,0xb3c903ad}},	//   מאות_, _lành_, tye_, ализ_
  { {0x753b00dc,0x03a80086,0x92f501c6,0xf3590054}},	//   rhuz, یدیو_, очні, ишој_
  { {0x637d0251,0x2d9e0089,0x442d0464,0xa1c51191}},	//   dènc, ítek_, rye_, обод
  { {0x443f005c,0x442d00aa,0x5f1d000b,0x0574002b}},	//   szu_, sye_, मान्_, _کالد
  { {0xd00a000d,0xcea90008,0x394f00b8,0x208a0063}},	//   аеме_, _יי_, nigs_, ийни_
  { {0x41c5005d,0x637d0251,0x27300016,0x28de000b}},	//   _विकस, gènc, _bành_, फ्टि
  { {0xdfcf0029,0x179a0008,0x27300016,0x78bb1192}},	//   ضيف_, יישב, _cành_, _leuv
  { {0x27300092,0x41b50015,0x88bd002a,0xada30033}},	//   _dành_, _بمعر, _rośn, дасл
  { {0x2fcd018c,0x6cd60031,0x0d9904ab,0xa3b0000b}},	//   šega_, تقرا, стры_, टीक_
  { {0x637d0251,0x78a20264,0xb09b000a,0x8b26013e}},	// [1940] cènc, vcov, _דיפר, одае
  { {0x63a4002d,0x636f01f0,0x91ed000b,0x7bd60061}},	//   _éine, møns, _जहाज_, ruyu
  { {0x3e830003,0x09e309c3,0x78bb1193,0x811e0065}},	//   rété_, дохн, _beuv, _बचाओ_
  { {0xcb090008,0x7ed6002b,0x69c31194,0x6440002a}},	//   כל_, _ازکا, ânea, yzmi
  { {0x98a303a9,0xc18d004c,0xbc1a005e,0x38600061}},	//   фиче, אטאָ, _тіні_, çir_
  { {0x78a21195,0x6009000a,0x2cb202de,0x65940b76}},	//   scov, מִצְ, lbyd_, паку
  { {0xa3dc000b,0x78a204b2,0x7bc41196,0x3ecb000a}},	//   तंभ_, pcov, lsiu, שֶׂ֣
  { {0x6abc09f0,0x63740251,0x7bc40091,0x644001f1}},	//   _herf, màni, osiu, tzmi
  { {0x6abc0084,0x7414003b,0x5397008f,0x7bc41197}},	//   _kerf, سودا, овыя_, nsiu
  { {0x7879000a,0x128a006b,0x637d0144,0x27e61198}},	//   _הָעו, ищни_, vènc, mton_
  { {0x29040f4d,0xba9b0008,0xa6a90029,0x9af70008}},	//   _kama_, יסיי, _طالق_, חזיק_
  { {0x2906000c,0x637d0251,0x799c003f,0xe1670015}},	//   ndoa_, tènc, _murw, تدخي
  { {0x74130015,0x2cbf006f,0x41b4002b,0x6abc0827}},	//   _يوما, _ľud_, _کمبر, _oerf
  { {0x637d08e0,0x29040d25,0xfe790089,0x6b400123}},	//   rènc, _lama_, řům_, _högf
  { {0xce940063,0x637d0251,0x31351199,0x27300016}},	//   даръ, sènc, _некр, _vành_
  { {0x5c99044e,0x6abc0125,0x2904119a,0x6e280123}},	//   ская_, _aerf, _nama_, ädba
  { {0xdfdb0063,0x3fc90086,0xdb16008c,0x7af7119b}},	// [1950] _тъй_, _ادبی_, ksyä, text
  { {0x7ff40086,0xf5490092,0x6b40002e,0x501c039e}},	//   _آسيا, hấp_, _lögf, _כוחו
  { {0x78bb038d,0x7bc40020,0x99150010,0x6abc119c}},	//   _peuv, asiu, зьлі, _derf
  { {0x99d40015,0x7af7119d,0x27e6119e,0xbcfb0030}},	//   بتكا, sext, fton_, _ekér
  { {0xd7fb119f,0x78bb0003,0x46a5006b,0x27e611a0}},	//   руе_, _veuv, палв, gton_
  { {0x46a50063,0x3ffc004c,0x63740144,0x1b0b0033}},	//   чакв, יפדע, bàni, _тэмп_
  { {0x6728016f,0x99d40015,0x7f3c004c,0x3eb8004c}},	//   _dodj, _يتفا, שעוו, חלומ_
  { {0x58870010,0x6aa50026,0x6abc00b8,0xe3b9004a}},	//   _дыза, lchf, _zerf, бби_
  { {0x27ff0020,0xf799002b,0xc7c70054,0xc6e701c6}},	//   _usun_, _طناب_, _фсби, _міжп
  { {0xeb9f0134,0x934201c5,0x466b0137,0x60dd11a1}},	//   _esøg_, енье, _крем_, egsm
  { {0xe803014e,0xa2dd005d,0xe1f1002b,0x6aa50012}},	//   लिका_, पलब्, رسد_, ichf
  { {0x69c5003e,0xb6070007,0x2ef80409,0x672302c6}},	//   ishe, rašė, werf_, ljnj
  { {0x88bd005c,0x69c5002d,0xc49a000a,0x4195002b}},	//   _rośl, hshe, _השנת, _کشتز
  { {0x2d9c0014,0x539a0008,0x69c7016f,0x395f00c0}},	//   _évek_, _פיצו, _ovje, _ljus_
  { {0x6b9d018b,0xb2ba01d8,0xa2ba000a,0x877a004c}},	//   _ausg, _המצר, _המצט, מאשי
  { {0xdb0d0061,0x69c511a2,0x2bc7000b,0x27e611a3}},	//   asaü, dshe, _लिखा, yton_
  { {0x7bc40007,0x2cb211a4,0x27e611a5,0xd00f0067}},	// [1960] usiu, rbyd_, xton_, _ملي_
  { {0x7bc404f9,0x4a9a008f,0x63740251,0x799c00e8}},	//   rsiu, стаў_, tàni, _purw
  { {0x7e9b0008,0xceb70008,0x6abc11a6,0x387f11a7}},	//   _לסיו, _מפיק_, _verf, _azur_
  { {0x6abc11a8,0x27e611a9,0x63740144,0xa926004a}},	//   _werf, tton_, ràni, ядел
  { {0x2904016f,0x672811aa,0x510d004c,0x6abc1060}},	//   _vama_, _podj, יהאַ, _terf
  { {0x47330036,0x7d060061,0x27e611ab,0x394d03a0}},	//   нніс, _haks, rton_, _emes_
  { {0x7d060197,0x290411ac,0x27e60ae5,0x8f89000a}},	//   _kaks, _tama_, ston_, קְנֵ
  { {0xda5b0008,0x7d0611ad,0x6b9d11ae,0x27e611af}},	//   _הכלל, _jaks, _yusg, pton_
  { {0xad1b0008,0x69c7016f,0x7d0611b0,0xd45200af}},	//   מוקר, _zvje, _maks, xофф
  { {0x883b013a,0xb7d70029,0x083b000a,0x7d0611b1}},	//   _התמו, _روما_, _העמל, _laks
  { {0x76430050,0x26cc0176,0x6587002e,0xcb13000a}},	//   czny, _iddo_, árhæ, גלת_
  { {0x867b0053,0xf487002b,0x859b004f,0xca7b004f}},	//   _פראו, _کامی, _השאו, מניט
  { {0x60dd11b2,0xcfa7004a,0xdb0d007c,0x0000006a}},	//   rgsm, яшни, tsaü,
  { {0x69c500f2,0x3da711b3,0x81f60015,0x00540015}},	//   yshe, зраб, _فأعط, رَّج
  { {0xdef80010,0x9e140036,0x637b000a,0xadbd0033}},	//   чыя_, ндрі, _הנגד, рабi
  { {0x88bd002a,0x76070046,0x625b004f,0x0000006a}},	//   _pośm, lézá, _לכוה,
  { {0xd11a005d,0x69c7016f,0x0fdb0015,0x73fa000a}},	// [1970] धारण_, _svje, _ابعث_, מּ֑ו
  { {0x648b000a,0x69c3016e,0x0058000a,0x6aa50012}},	//   זְבְ, âneo, _משחת_, uchf
  { {0xf9f90115,0x6aa511b4,0xceb2000a,0x7d0611b5}},	//   تفاع_, rchf, _שיט_, _faks
  { {0xe2930053,0x26cc0026,0x6aa50012,0xe9d00067}},	//   גװע_, _addo_, schf, اغل_
  { {0xfc640063,0x394d00bd,0x68f903e1,0x69c511b6}},	//   _зърн, _vmes_, rewd, sshe
  { {0x8c1a0008,0xb9e7005e,0xe29a0016,0x69c511b7}},	//   _וושי, _ніби, _ngư_, pshe
  { {0x69c7010b,0xba770086,0x945d005c,0xcb12000a}},	//   _uvje, _راست, kańc, _בלם_
  { {0xbe3c0008,0x7643005c,0x98070033,0x27f00046}},	//   מעות, rzny, _нязд, ílný_
  { {0xb4ad005d,0x67d40a6c,0x7643002a,0x387f01c2}},	//   _कभी_, _поту, szny, _uzur_
  { {0xd75b0074,0xc7b2000a,0x81c911b8,0x644d0091}},	//   _اجرا_, _סבב_, огов_, _žais
  { {0xa51d0010,0xb6350015,0x77640144,0xeab2004f}},	//   _вялi, _تفاع, éixe, כֹר_
  { {0x2d9c0030,0x0000006a,0x0000006a,0x0000006a}},	//   _évei_,   ,   ,
  { {0x7d060048,0x307a0029,0x6b4000c0,0x60cd0026}},	//   _raks, تحدة_, _höge, _ddam
  { {0x6d4f11b9,0xf456000f,0x539a000a,0xf412000a}},	//   _amca, _קיסר_, _ויסו, _שפג_
  { {0x2d9e038d,0x4df50191,0x7d0611ba,0x41260015}},	//   ête_, нятт, _paks, _يفتق
  { {0x91ba000a,0xf236002b,0xc1ba000a,0xee37005e}},	//   _ומקי, _تبهک, _ומקש, єнт_
  { {0xed57000d,0x7d0611bb,0x98ad002a,0xaae20065}},	// [1980] фот_, _vaks, _zleć_, _पादक
  { {0x4c830004,0x5aca008b,0xf1c1000b,0x5fd30065}},	//   тлув, ілем_, _शबान, _तितल
  { {0x823a0053,0x63510089,0xfbc9000a,0x63740144}},	//   ֿענצ, měně, שת_, mànt
  { {0x63740144,0x7d0600cb,0x0000006a,0x0000006a}},	//   lànt, _uaks,   ,
  { {0x07fa00e6,0xa09b00a3,0x661d0091,0x1c430033}},	//   تراع_, קיסט, _ąska, _аням
  { {0xd5b00086,0xeb9f02e9,0xf1c0006f,0x6b400012}},	//   هفت_, _prøv_, úšky_, _böge
  { {0x8a030719,0x0000006a,0x0000006a,0x0000006a}},	//   _изре,   ,   ,
  { {0xa9260010,0x3ce00134,0xa5070054,0xdb0d001a}},	//   _ўдал, ngiv_, дећа_, lsað
  { {0x671e005d,0x14180029,0xb366006b,0xa6e600af}},	//   पादक_, سيدة_, дънк, _ожал
  { {0xf7720029,0xdb0d001a,0x8c1b000a,0x6beb004f}},	//   _شاء_, nsað, קויי, חַטַ
  { {0xcad70008,0xd2500029,0x945d005c,0x2fc911bc}},	//   ווית_, انج_, tańc, _svag_
  { {0x914b017f,0x7bcb0030,0xd257055f,0x0000006a}},	//   ічна_, águk, ьцы_,
  { {0xf537000a,0x945d002a,0xf41f008c,0x6b400012}},	//   _קנדי_, rańc, äät_, _zöge
  { {0x637404ed,0x2d8c0079,0x5f94006b,0x6b400052}},	//   tànu, ïden_, кият, _lögb
  { {0xf2060063,0x254c005c,0x22f7000a,0x9f520030}},	//   _цяло, eśli_, _חזון_, óbát_
  { {0x9d180063,0x0000006a,0x0000006a,0x0000006a}},	//   мост_,   ,   ,
  { {0xd0110015,0x63ad0061,0x70550021,0xdb0d001a}},	// [1990] _إلخ_, _çant, _سندا, fsað
  { {0xdb0d001a,0x539b000a,0x6378004f,0xea63009a}},	//   gsað, קיבו, פְּס, نپذی
  { {0x69c802de,0xe9ab009a,0x0000006a,0x0000006a}},	//   _ædel, زدان_,   ,
  { {0xdce40064,0x98f40010,0xd257000a,0xeb9f00cb}},	//   mliğ, вяшч, ושבה_, _brøt_
  { {0xdce40064,0x7ac711bd,0x9cd6000a,0xe89400ce}},	//   lliğ, _осве, _אורה_, ваць
  { {0x80380053,0xd706005e,0xd5e5006b,0x254c0046}},	//   ונדע_, енше_, ежки, měly_
  { {0xd5b1003b,0xdce401e2,0x5ebc000a,0x58d511be}},	//   دفع_, nliğ, חזוק, _повт
  { {0x6b4000b8,0xd61800e6,0xe5f20058,0xa493009a}},	//   _vöge, بتها_, اكيد, نیات
  { {0x6d5a0152,0x47d50115,0x2d9911bf,0x656201d7}},	//   étai, _سيار, _mise_, _djoh
  { {0xdce40064,0x422511c0,0x8c1a000a,0x58840174}},	//   kliğ, едов, פותי, _рыса
  { {0x4ae2005d,0x44390024,0x63a4002d,0x78a402c6}},	//   _पासव, šs_, _éinn, žive
  { {0xa06a0001,0x254c002a,0x64a50004,0x0000006a}},	//   зама_, yśli_, _џала,
  { {0x2c6c0046,0x98a4003d,0x9259002b,0x0000006a}},	//   _kódů_, _jomā_, تشکر_,
  { {0x2d990003,0x254c0046,0xa357006e,0x7f19008b}},	//   _aise_, děly_, _تخصص, місу_
  { {0x72050015,0x975a000a,0x2d9901f6,0x0000006a}},	//   _أوبم, לדשט, _bise_,
  { {0x6283010b,0x2004002e,0xa1c2006b,0x6e930015}},	//   _izno, æmis_, _сбъд, طلقا
  { {0x2601000b,0xbea6058f,0x4f96013d,0x6b400030}},	// [19a0] _वैसी_, _папк, _проу, _rögb
  { {0x539a0008,0x1ae3018d,0x2d9900aa,0x0000006a}},	//   פיעו, лоум, _eise_,
  { {0x533600b2,0xdebb0008,0x5ebb000a,0x3ebb000a}},	//   ענען_, _ממיל, _מזיק, _מציב
  { {0xe1ff0050,0x59760086,0xdb1d00c0,0xdb0d002e}},	//   łów_, رداز, _avsä, ssað
  { {0xdc9b000a,0x6d5611c1,0x69d70144,0x3157004f}},	//   _מיכל, miya, arxe, עינן_
  { {0x2d990011,0x657b01d7,0x56780174,0xd5ba01cf}},	//   _zise_, eluh, мбля_, пси_
  { {0xceb3013a,0xfb1b000a,0x6b6311c2,0xfe79005a}},	//   ניה_, _צולמ, _скра, řův_
  { {0x59760010,0x7afe11c3,0x6d44016e,0x6d5611c4}},	//   _чыгу, lept, nhia, niya
  { {0x75d40074,0xe3af0074,0xa3e70001,0xe3b20029}},	//   ريکا, یری_, едња_, درع_
  { {0xfd1f0023,0xa29401f3,0xdce40061,0x0edc000b}},	//   _nhìn_, капі, yliğ, _बागड
  { {0xf41f0020,0xd25a006b,0xb98a000a,0x2002002a}},	//   äär_, яци_, ּרָ֖, ewki_
  { {0x84660063,0x88bd005c,0x64a30054,0x0446006b}},	//   _пъле, _dośw, _баца, _пеен
  { {0x557700b2,0x2d99003e,0x54330002,0x6d560273}},	//   _װעגן_, _rise_, _مرور, diya
  { {0xf413000a,0xdce40061,0x2d9911c5,0x69de11c6}},	//   _תפס_, tliğ, _sise_, kupe
  { {0xe2130029,0x63a211c7,0xa2bb006f,0xa3dc000b}},	//   _مبيع, _huon, äčše, तूर_
  { {0x63a2000c,0xdce401e2,0x26c100dc,0x6d4411c8}},	//   _kuon, rliğ, óhoz_, ghia
  { {0x63a200f2,0x2d9911c9,0xdce40061,0x539b000a}},	// [19b0] _juon, _vise_, sliğ, ִיאו
  { {0xdce40064,0x2d990495,0x5f950099,0x68e20030}},	//   pliğ, _wise_, _шипт, egod
  { {0x63a2022d,0xda670806,0x70550086,0x6d44002d}},	//   _luon, رائي, _سنگا, bhia
  { {0xacbb0152,0x99d40015,0xf8b1002b,0xe8590033}},	//   _coût, اتلا, شکر_, маеш_
  { {0x63a20035,0xe72e0010,0x7afe0061,0x0c75002b}},	//   _nuon, ае_, bept, _شگرد
  { {0xf72b0010,0x95c50015,0x7d0d11ca,0x7afe11cb}},	//   яцей_, نيته, ldas, cept
  { {0xff18000a,0xae14000b,0xc1790091,0x2d9c0030}},	//   תקות_, डियन_, ntės_, _évet_
  { {0x63a211cc,0xacbb0003,0x7d0d11cd,0x2002002a}},	//   _buon, _goût, ndas, ywki_
  { {0x5964006b,0x7ae10030,0xa822002b,0xe3b10015}},	//   _съра, _ölts, _نکون, جرب_
  { {0x7d0d00f2,0x88bd005c,0xd759002b,0xf647013e}},	//   hdas, _pośw, _غلات_, _пхен
  { {0xcb120008,0x82f40010,0x60c611ce,0x614609dd}},	//   בלי_, учыц, takm, вена
  { {0x7afe00b8,0x81d40010,0x45b6000a,0x26c711cf}},	//   zept, ыцьц, _יפעל_, lano_
  { {0xf99200b2,0x60c60064,0x6283005c,0x69de0fce}},	//   ירט_, rakm, _wzno, zupe
  { {0x7529044c,0xd24e002b,0xb7da000a,0x64490012}},	//   ljez, _ژنو_, וקשי, mzei
  { {0x6d5611d0,0x6d4411d1,0x68e209bf,0xada611d2}},	//   tiya, thia, ygod, табл
  { {0xdcf60091,0x32070012,0x7c36008c,0x26120065}},	//   plyč, _isny_, tyyr, थिती_
  { {0x7afe04f9,0x644900b8,0x753b003f,0x6d440801}},	// [19c0] tept, nzei, ikuz, rhia
  { {0x6d5611d3,0x4e7a0029,0xdb590036,0x60c405d8}},	//   siya, _يحدد_, нює_, _heim
  { {0x3ed900b2,0x3cea005d,0x644900b8,0x5a960418}},	//   _אַרא, _छापे_, hzei, траф
  { {0x6c860029,0x79890335,0xd00f002b,0x394011d4}},	//   _للجم, _chew, _الی_, óis_
  { {0x87e30080,0xacbb0152,0x68e211d5,0x26c711d6}},	//   ающе, _voût, rgod, fano_
  { {0xa77302e1,0xe72f0015,0x75290030,0xd6cf0015}},	//   аліч, قصى_, ejez, ققه_
  { {0x24800048,0x63a204ed,0x2d9c00dc,0x644900b8}},	//   _šim_, _suon, _éves_, ezei
  { {0x644900b8,0xda4b000a,0x26c702f2,0x60c411d7}},	//   fzei, _חֲמָ, aano_, _neim
  { {0xe8d70008,0xd6da002b,0x64490012,0xdced0085}},	//   _שומר_, _يورش_, gzei, slać
  { {0x63a2022d,0x394603af,0xdced016f,0x7d0d00dc}},	//   _vuon, lhos_, plać, zdas
  { {0xf5490092,0x9554002b,0xfb15004c,0x7d0d0061}},	//   hấy_, _یخچا, אַרט_, ydas
  { {0x394603af,0x51870001,0x60c4002d,0x9655006b}},	//   nhos_, ђуна, _ceim, _съуч
  { {0x60c411d8,0xe53b0008,0x14d700a3,0x934611d9}},	//   _deim, _קתדר, _יואל_, _инде
  { {0x533300d7,0xee87004a,0x6b9c0012,0x7f850021}},	//   _вешт, выбо, _nirg, السن
  { {0xa3a8005d,0xc7c80092,0x139b0008,0x02fb00a3}},	//   _खंड_, hố_, _קבוע, _חלומ
  { {0xc1790007,0x6b9c0541,0x90450015,0x6da40004}},	//   rtės_, _airg, _منعه, риѓа
  { {0xc1790007,0x7d0d064e,0xdd9402bf,0x26c711da}},	// [19d0] stės_, rdas, раты, yano_
  { {0x1602005d,0x7cde0011,0x6b9c002d,0xdf390015}},	//   लबार_, tărâ, _cirg, _أكدت_
  { {0x26c711db,0x995c0046,0xb9c40015,0x6b9c11dc}},	//   vano_, líř_, لقلي, _dirg
  { {0x26c70050,0x09e4005e,0x6d5a0324,0xc9840d7a}},	//   wano_, роїн, état, аучи
  { {0x9bc40010,0x386911dd,0x26c711de,0x75290085}},	//   _вёск, çar_, tano_, vjez
  { {0xa03c0008,0x99d70015,0x69d80046,0xade7000b}},	//   ועדפ, _لترا, ávec, _ओमान_
  { {0x78a411df,0xa3a8000b,0x15f50015,0xdb060046}},	//   živa, _खूब_, استح, _utká
  { {0xf3ff11e0,0x2409005f,0x7bcd0024,0x394611e1}},	//   ção_, ении_, osau, chos_
  { {0xc952000a,0xf8ae002b,0xf2a5004a,0xd83b0033}},	//   _המן_, _رکن_, липп, _ўэб_
  { {0x2b1c014e,0x6449018b,0x753b0089,0xe7300115}},	//   नाएँ_, rzei, skuz, _وصل_
  { {0xd4f50010,0x644911e2,0x7ae511e3,0xc1060015}},	//   _бялы, szei, ight, هودي
  { {0xe4cb0086,0x26c50026,0x7bcd11e4,0x6146055f}},	//   _آبان_, _helo_, ksau, уема
  { {0xe5700015,0x44270015,0xfd1f0016,0x25a511e5}},	//   _بطل_, _جراف, _chìm_, _hull_
  { {0xe8e0000b,0x26c500b3,0x8235006e,0x60c411e6}},	//   _पञ्च, _jelo_, _مربا, _weim
  { {0x60c40176,0x200901d7,0xad660015,0x26c50524}},	//   _teim, _esai_, هاره, _melo_
  { {0xc27a0008,0xf1b200a3,0xfcb5005e,0xad650015}},	//   _ארצי, _פסח_, ищую, لاقه
  { {0x7ff60029,0xab6604c2,0x5bc50015,0x4c860033}},	// [19e0] _إسبا, гвал, لتلف, улав
  { {0x909b0008,0x68e9001c,0xcb0a0002,0xaf0601e5}},	//   _אספק, _aced, عيان_, _спол
  { {0x21200089,0x7f3b0053,0x637d0144,0x3f4d003d}},	//   _knih_, _נעטו, gèni, ažus_
  { {0x07a60010,0x6b40002e,0xc7c60a32,0x6b9c002a}},	//   гадн, _gögn, гски, _wirg
  { {0x6b9c0024,0xf7f30015,0xc7af0015,0x7e7e11e7}},	//   _tirg, مسود, كّن_, _hypp
  { {0x26c50844,0x2d8011e8,0x25a511e9,0xfaa311ea}},	//   _celo_, llie_, _bull_, _гаро
  { {0x2120016f,0x26c50796,0xaa46006b,0x394611eb}},	//   _onih_, _delo_, _севл, phos_
  { {0x25a50495,0x61e111ec,0x2956006b,0xba170040}},	//   _dull_, dull, _съгр, _حيفا_
  { {0xb8660029,0xdd040007,0x786611ed,0x778611ee}},	//   _صارو, ūrės, _сказ, _блаз
  { {0x57fb000a,0x25a511ef,0x26c511f0,0x61e111f1}},	//   _אלמו, _full_, _gelo_, full
  { {0x8717000a,0x9f42008c,0x7bcd003d,0xa3e5000b}},	//   _תקבע_, itkä_, zsau, बूब_
  { {0x26c5018c,0xa15911f2,0x64a611f3,0x995c0046}},	//   _zelo_, таму_, _сада, tíř_
  { {0xd0e6014e,0x54360115,0x251b004c,0x61e1008c}},	//   _कारण_, _حرار, _רודא, aull
  { {0xa2940484,0x61e111f4,0x92940515,0x35a90065}},	//   _калі, bull, _калц, _चूड़
  { {0x1df802bf,0x42170015,0x61e111f5,0xc292009a}},	//   леры_, _مزيج_, cull, _دیدب
  { {0x2d8004ba,0x721b000a,0x867b000a,0x7bcd11f6}},	//   glie_, _טווח, גרלו, tsau
  { {0x200900e8,0xfbd00015,0xcb550054,0x5c9908f0}},	// [19f0] _usai_, كتل_, аваћ, ткая_
  { {0x7ae5003e,0x6d5a0003,0x7e2b0033,0x9d55002b}},	//   ught, étar, _зіма_, _چندت
  { {0x2d8011f7,0x7d0e008c,0x7bcd11f8,0x9b680427}},	//   blie_, önsä, ssau, ушта_
  { {0x7bcd0945,0xb815000d,0x48150579,0x6b400123}},	//   psau, идеј, имес, _högl
  { {0x26c503af,0x25a502d7,0xf7710196,0x8cf40033}},	//   _pelo_, _sull_, يات_, _узяц
  { {0x7bda0008,0x25a5043a,0x6eba000b,0x7d0f0030}},	//   _בקשו, _pull_, ्रयु, _hacs
  { {0x6b40018b,0x65c209ef,0x8f38004c,0xd5ae0021}},	//   _mögl, обща, ראוו_, وفو_
  { {0x61e1022d,0x25a50251,0x6b40001a,0xb4df0157}},	//   vull, _vull_, _lögl, तले_
  { {0xa3e5005d,0x2d160053,0x26c505e3,0x7d0f11f9}},	//   बंध_, בֿים_, _telo_, _macs
  { {0x61e111fa,0xe29911fb,0x5f150065,0x25a511fc}},	//   tull, кап_, _फोल्_, _tull_
  { {0xcb1200a3,0xe12611fd,0x61e1008c,0xe4d5009a}},	//   קלט_, амни, uull, _نقاد
  { {0xa3e5000b,0x1168002b,0x2a76000a,0xd343002b}},	//   बंद_, الحی_, יעתך_, _گفتی
  { {0x88ba000a,0x2259002a,0x4fa6006b,0x8fa60133}},	//   כזרי, ńsk_, ригв, раге
  { {0x61e100f2,0x8f76005e,0x90d6002b,0xd0070054}},	//   pull, румі, دآگا, јере_
  { {0x3f840024,0x42790053,0xef170180,0xed5a014d}},	//   ēmu_, _באַג, јмс_, вов_
  { {0xdca3007a,0x205611fe,0x2d8011ff,0x7d060099}},	//   жати, _втор, ulie_, јзаж
  { {0xebe6005e,0x317b0447,0x9c970015,0x717b000a}},	// [1a00] розп, _באקד, لنفط_, _שנפס
  { {0xa03b0008,0x2d8005ed,0x7e7e1200,0x34b30065}},	//   _סעיפ, slie_, _typp, ीरुद
  { {0x6edb0008,0xa3e5005d,0xf1ab000b,0x7edb0c44}},	//   _בחיפ, बूत_, _घूमन, _בקיצ
  { {0xd9460001,0xebe60a13,0xae1b004f,0xcc8a009a}},	//   једи, _комп, _סוככ, _لنجه_
  { {0x4cbb0008,0x88bd005c,0x7d041201,0x98560004}},	//   _בזכו, _pośr, meis, јтеш
  { {0xed59002c,0x57770010,0x7d041202,0x63a40003}},	//   ďže_, абіў_, leis, _éini
  { {0x94d40010,0x76a9005e,0x645d001a,0xe73701ca}},	//   бойц, утів_, úsin, реј_
  { {0x7d04022d,0x9404006e,0xb7da006e,0x0000006a}},	//   neis, موعه, _لورا_,
  { {0xc34a0063,0x95530086,0x6b40002e,0x66e60180}},	//   вяне_, تخوا, _lögm, _воза
  { {0x7982003e,0x16760001,0x7791002b,0x973c0085}},	//   llow, _кћер, _فینا, _biće
  { {0x7d041203,0x32180046,0x6d46008c,0xdbd1001a}},	//   keis, íry_, _olka, _lýðv
  { {0x7d0400f2,0x9257004a,0x9326002b,0xf9a000fd}},	//   jeis, рают_, ارکن, онiм_
  { {0x60d60026,0x5f770029,0x32020089,0x7416002b}},	//   _ddym, لاسر, ňky_, _خوشا
  { {0xc0580036,0x6d461204,0xc43b000a,0xf1a605c0}},	//   рію_, _alka, _בתדי, _крин
  { {0xd378010b,0x7d041205,0x331b000a,0x5d650015}},	//   moć_, feis, _שֵׂע, مُسْ
  { {0x929b013a,0xe29b0008,0x7c870e77,0x25de000b}},	//   _ביות, _בשור, аузе, _गिनी_
  { {0x75220089,0xdfd100e5,0xfaa71206,0x9cc80033}},	// [1a10] _mnoz, _عيد_, ашен, рыса_
  { {0x6d460111,0x78a40263,0xd3781207,0x7982002a}},	//   _elka, živl, noć_, elow
  { {0x3f830263,0xce68004a,0x7e2b0033,0x7d0400d5}},	//   mlju_, _вряд_, _ріпа_, beis
  { {0x97c50029,0xae1a0008,0x49780010,0x7982002a}},	//   مقصو, _עורכ, асіў_, glow
  { {0xb8f20015,0x31790030,0xd3781207,0xf8071208}},	//   سكوب, iosz_, koć_, рчен
  { {0xd2460074,0x907a0053,0xdb230086,0xdc9a000a}},	//   _فن_, נטװי, _بوسی, _תישל
  { {0x5a440010,0xd5e80015,0xeb03000b,0x79821209}},	//   _дэта, لعين_, रजीत_, blow
  { {0x7bdf0a40,0x8938120a,0x0000006a,0x0000006a}},	//   orqu, _кпсс_,   ,
  { {0x14220010,0x4615002b,0x2eb7000b,0x94790033}},	//   здым, _گوار, _अभूत, ыску_
  { {0xf7850015,0x51b90033,0x9353002b,0x7d040b65}},	//   _الطَ, лымя_, تربچ, zeis
  { {0x27e90091,0x0000006a,0x0000006a,0x0000006a}},	//   šinę_,   ,   ,
  { {0x42540010,0x6458005c,0xcea900a3,0xd12f0015}},	//   ітэт, _ściś, _טי_, ّمَ_
  { {0x05740029,0xd91a0053,0xd05a0036,0x4429120b}},	//   _بالد, אורל, урні_, _ça_
  { {0x7d04018b,0x02390087,0x853c0091,0x6e3c02d2}},	//   weis, _مثبت_, _nuėj, tyrb
  { {0x7bdf0251,0xeb9f003c,0x7d04120c,0x7982002a}},	//   erqu, _esøk_, teis, ylow
  { {0x90c60ea6,0x3f830abb,0x4236000a,0x27ff0045}},	//   _убие, alju_, _לנצל_, _opun_
  { {0x3f83016f,0x0bea002b,0x6d580091,0x7d04120d}},	// [1a20] blju_, طفاً_, _įvad, reis
  { {0x7d040c58,0x63bb120e,0x0057000a,0x637d0144}},	//   seis, ipun, _לשפת_, cènt
  { {0xd35a0053,0xe9da1179,0x993a042b,0x88bd002a}},	//   נדעל, уке_, ляду_, _pośp
  { {0xf1b2000a,0x8288000a,0x71d6000a,0xe4470015}},	//   פסד_, בְנֶ, מועד_, _فض_
  { {0x9b8a0067,0x18670054,0x645d006f,0xe73a120f}},	//   _منحل_, баци_, úsil, лед_
  { {0x78250029,0xa09b0008,0xceb30008,0x63bb1210}},	//   تعمل, אינט, ֔יו_, dpun
  { {0xceb300a3,0xd6d90036,0x8f9b0643,0xa96a0785}},	//   היו_, рті_, ניצי, _бива_
  { {0x93b4005e,0xd90e002b,0x63bb026c,0x0000006a}},	//   обиц, _سیت_, fpun,
  { {0x63bb1211,0xe56f0015,0xa5070004,0x0000006a}},	//   gpun, عطى_, сења_,
  { {0xaaba014e,0x51f80036,0x61f80010,0x68fb1212}},	//   ेरिक, аною_, аноў_, _zbud
  { {0x3f83016f,0xdb7b0053,0x62340004,0x4b7b05bd}},	//   vlju_, רניכ, цену, רטיג
  { {0x73e6008f,0x71470080,0x1a9b0053,0x4a9b0053}},	//   _годз, схож, טייע, טייג
  { {0x04960029,0x637d0144,0x31790030,0x7afc0b28}},	//   _الشح, tènt, rosz_, _obrt
  { {0x8504009a,0x0000006a,0x0000006a,0x0000006a}},	//   _دوچن,   ,   ,
  { {0xd5d8000a,0x637d0144,0xd1310015,0xa5d8000a}},	//   יַּש, rènt, _يمت_, יַּי
  { {0x52830029,0x78a40085,0xe16b0015,0x3f8300bc}},	//   _عليك, živj, _حصته_, slju_
  { {0xfd4f0092,0x2bb80015,0x3f830085,0xe7d3003d}},	// [1a30] _khiế, مالة_, plju_, ršūš
  { {0xd5b801ec,0x0000006a,0x0000006a,0x0000006a}},	//   _otā_,   ,   ,
  { {0x27ff1213,0x63bb0012,0x3ce91214,0xc9871215}},	//   _spun_, zpun, pgav_, буди
  { {0x28f9004a,0x6f07002a,0xb9250015,0x6b40001a}},	//   редь_, lejc, تفصي, _lögh
  { {0x6aa90011,0x88c8005e,0x17990088,0x63bb1216}},	//   _şefu, слів_, авды_, xpun
  { {0xfd4f0092,0x68fb002a,0x645d006f,0x6d4d1217}},	//   _nhiế, _wbud, úsim, lhaa
  { {0xc5d50036,0xaa5d00ce,0xf6f6009a,0x0000006a}},	//   ціль, _ревi, تزنگ,
  { {0x63bb1218,0x68fb0085,0xcdaa004c,0x659203ae}},	//   tpun, _ubud, סיפֿ, мају
  { {0x69da01d1,0x14250036,0x63bb00f2,0x1c1c000b}},	//   _åter, ідом, upun, नियल_
  { {0xfd4f00a7,0x27e0002d,0xd6d10086,0x98880008}},	//   _chiế, áine_, _آقا_, _הָעֵ
  { {0x6f070089,0x63bb1219,0x6d48121a,0xf647006b}},	//   dejc, spun, ūdai, _ухан
  { {0xd24e0074,0xdced016f,0x415a005e,0x515a0033}},	//   خچه_, klađ, ршою_, ршоў_
  { {0x297a0053,0x88f6000a,0x6d4d01c2,0x2329121b}},	//   שטרא, חזרו_, dhaa, _воли_
  { {0x6569121c,0x889a00a3,0x289a004c,0x657b0046}},	//   lneh, יברי, יירא, louh
  { {0x41760074,0xbea302bf,0xa3e5000b,0x6d5f01c2}},	//   _وابس, дарк, बूर_, fiqa
  { {0x63a30458,0x6d430011,0x62830035,0xfe43005e}},	//   _hinn, _înal, _iyno, єнто
  { {0x63a30005,0x3c66008f,0x62830026,0x5aca007a}},	// [1a40] _kinn, цкаг, _hyno, илам_
  { {0xbad50010,0x261a000b,0x5db60015,0x61e10034}},	//   зіцы, _मछली_, _وإجر, orll
  { {0x0b170029,0xf8aa0010,0x4e2a006d,0x63a3121d}},	//   تقلة_, авек_, _тонн_, _minn
  { {0x63a3041c,0x6d4d0111,0xb9c5002b,0x98a6121e}},	//   _linn, chaa, ستمه, циде
  { {0x63a3002d,0x38cb0086,0x6569002c,0xd90d002b}},	//   _oinn, شانی_, dneh, دیق_
  { {0x501b0008,0x6d440007,0x1754034e,0x7d160091}},	//   יונו, lkia, явля, ldys
  { {0x63ab0084,0x656900b8,0xdce402c6,0xf62a005e}},	//   _augn, fneh, hnič, ріли_
  { {0x6d4400df,0x63a3002d,0xe96a0a1f,0x65930015}},	//   nkia, _ainn, _табл_, وجير
  { {0xfd4f0092,0x63a300f6,0x6d440007,0x12c6002b}},	//   _phiế, _binn, ikia, يتدپ
  { {0x63a3002f,0xdce4121f,0x7d1600f2,0x5fa5021e}},	//   _cinn, dnič, hdys, _गूगल
  { {0x6d4400f2,0x62830026,0x63a3003e,0xdb0f00dc}},	//   kkia, _cyno, _dinn, ödés
  { {0x63a31220,0x62830026,0x3ce4000b,0x443f02f2}},	//   _einn, _dyno, गलों_, byu_
  { {0xfd4f0023,0x61e10026,0x7d1606bd,0xe0870015}},	//   _thiế, arll, ddys, تجدي
  { {0x6d441221,0x62660021,0x62830034,0x93770015}},	//   ekia, _واثق, _fyno, _وصور_
  { {0xdd950010,0x26cc001c,0xee840010,0x62830034}},	//   завы, _medo_, дыто, _gyno
  { {0x91b70086,0x1bb50010,0x26cc1222,0xdfd10015}},	//   _بطور_, збаў, _ledo_, _كيب_
  { {0x317200dc,0x7127002b,0x6d5f01c2,0x6f071223}},	// [1a50] ézze_, _هرکل, riqa, pejc
  { {0xce950063,0x13bb004c,0x60cd007c,0x656904b2}},	//   _напъ, יזמע, _heam, zneh
  { {0x657b003f,0x60cd013c,0x5f740015,0x7d160091}},	//   youh, _keam, _تاير, bdys
  { {0x644000f2,0x929b000a,0x89a8005e,0x6ee7002b}},	//   kymi, ביבת, іків_, _اسکل
  { {0x88070086,0x6569002c,0xb8070087,0xecb6000a}},	//   تظام, vneh, تباه, _מפרץ_
  { {0xdc3a0008,0x26cc1224,0x4c9a000a,0x2bc4000b}},	//   _העשר, _cedo_, _לברו, _लौटा
  { {0x63a31225,0x65691226,0x8698006b,0x6440001a}},	//   _rinn, tneh, отът_, eymi
  { {0x60cd1227,0xe5050015,0x70b5000b,0x05550033}},	//   _neam, سبعي, ंडोल, ятля
  { {0x3f980176,0xb4bb005d,0x65691228,0x63a3074e}},	//   ymru_, _अभी_, rneh, _pinn
  { {0xaacb014e,0x657b0089,0xe4560033,0xdce40263}},	//   िरिक, souh, яжы_, vnič
  { {0x171a0008,0x6d441229,0x60cd108e,0x656a0125}},	//   _לֵאמ, ykia, _beam, ómhá
  { {0x6d93122a,0xdce40b6c,0x63a3122b,0x216a0923}},	//   nçad, tnič, _winn, сими_
  { {0x82350074,0x6283005c,0xd40b0015,0x10160015}},	//   زرگا, _wyno, _ختام_, أبجد
  { {0x20dc0092,0x61e8122c,0xb3ba000a,0xca6b0033}},	//   ửi_, budl, _המסכ, зiмi
  { {0xdce4052c,0x6146122d,0x9e66002b,0xddde005a}},	//   snič, _нека, ساسن, _vypů
  { {0x6d44122e,0xdce406c0,0x60cd030d,0x2d95122f}},	//   ukia, pnič, _geam, друс
  { {0x2fc90026,0x6fb30015,0x945d002a,0x6d440620}},	// [1a60] _gwag_, _كميا, mańs, rkia
  { {0x8eea0036,0x305b000a,0x3ae8002b,0xa3cd000b}},	//   _умов_, _לדפד, تبری_, षीय_
  { {0x6440005c,0x26cc0f8b,0x2f3b000a,0x7f3b000a}},	//   zymi, _redo_, _הגיד, _העיו
  { {0x4c6a004a,0xc9590033,0x6440005b,0x0000006a}},	//   _гимн_, оўі_, yymi,
  { {0x0c230010,0xad1b0008,0x2d820293,0xa8170015}},	//   _змян, _הוכר, _ikke_, كتور_
  { {0x6d93016e,0x7791002b,0x98a30a32,0xeb97024f}},	//   açad, پیما, хиче, _ния_
  { {0x945d005c,0x78ad0a00,0xb5aa0029,0x8b230063}},	//   kańs, žava, حاتك_, _ядре
  { {0xe5a30001,0x945d005c,0xf9040086,0x64401230}},	//   нији, jańs, _تأسی, tymi
  { {0x945d002a,0x7bd601d7,0xd37a006b,0x60cd1231}},	//   dańs, nsyu, йчо_, _ream
  { {0xcc570008,0xdc8b000a,0x60cd1232,0x23b70015}},	//   פסיק_, מְיָ, _seam, أديب_
  { {0x60cd0005,0xb6bb000a,0x91e30004,0x78a900aa}},	//   _peam, _הצבי, ноќе, _ygev
  { {0xf8cc014e,0x39460007,0x2fd90015,0x945d002a}},	//   ारिय, nkos_, يوجد_, gańs
  { {0xb97b0008,0xb4e8000b,0xc953000a,0x60cd1233}},	//   מנטי, बली_, תמר_, _veam
  { {0xd14b0074,0x9098006b,0xdfa40004,0x0000006a}},	//   _گشتن_, явят_, ејсо,
  { {0xfe700029,0x12fb009d,0x42fb000a,0x945d002a}},	//   هدف_, _להגב, _ההוס, bańs
  { {0x2d58005f,0x6b400084,0xe2130058,0x25bb004f}},	//   пись_, _mögu, _أبوع, מצלמ
  { {0x6b40002e,0x2fc90ad5,0x67280085,0x515c000a}},	// [1a70] _lögu, _uwag_, _ondj, _לכהו
  { {0x2aab0124,0xe451000a,0x7ff40058,0x0000006a}},	//   стао_, כֶב_, _أسيا,
  { {0x7f3c0008,0x442b0092,0x6286005c,0x4efa0008}},	//   _לעזו, ̣c_, ękow, _והתו
  { {0xbcfb02c1,0x67280020,0x2bb5000b,0x8cce000b}},	//   _ejér, _andj, _अंपा, तरणो
  { {0x16a90080,0xe7390ea6,0x6d930341,0xd7fb0937}},	//   овли_, жел_, rçad, суе_
  { {0x945d002a,0x2be2000b,0x07090058,0x2d8911eb}},	//   zańs, _पिता, زيبي_, llae_
  { {0x25a61234,0x7539002a,0x0000006a,0x0000006a}},	//   _biol_, _powz,   ,
  { {0x6b40002e,0xf9930086,0x25de005d,0xe3b91235}},	//   _dögu, _سبز_, _गिरी_, оби_
  { {0x0ebf000b,0x56f50004,0x6ebf000b,0x395f055e}},	//   ्राड, _опаѓ, ्राँ, _imus_
  { {0xaadd005d,0xf8680015,0xc2451236,0x945d0535}},	//   मणिक, _عملي_, днок, wańs
  { {0x77900086,0x945d005c,0x66f2000b,0xc0e60033}},	//   _حیوا, tańs, _घातक_, монк
  { {0x2ec6005d,0x69d8001c,0xb05b00b8,0x6b400123}},	//   वर्त, ávei, rbän, _högt
  { {0x945d002a,0x657c0030,0x660d003d,0x3494012e}},	//   rańs, _írha, žokļ, _зацр
  { {0x1ea90015,0x22680046,0x2d8900aa,0x6265011a}},	//   كافي_, átká_, elae_, _овла
  { {0xdef90010,0x945d005c,0xe8220046,0xb2ba000a}},	//   чыў_, pańs, _měšť, _ומצר
  { {0xa1870063,0xdb24009a,0x0000006a,0x0000006a}},	//   _обща_, کوئی,   ,
  { {0x50db004f,0xad650058,0x3160007f,0x0000006a}},	// [1a80] _וחפצ, رافه, _imiz_,
  { {0x32ba0053,0x5f060010,0x394d1237,0xef94002b}},	//   ַזנד, _ўзна, _ales_, _سیزد
  { {0xceb305af,0x6b520f47,0xe293000a,0x39461238}},	//   _בית_, _lægg, תְּ_, tkos_
  { {0x39460007,0x9cb60086,0x7643005c,0x78ad01a3}},	//   ukos_, _زمست, dyny, žavn
  { {0x6b40002e,0xaac60015,0xeb9a067a,0xaf58000a}},	//   _sögu, _يتسن, _мим_, ּׁ֔ה_
  { {0x394d03af,0xd5ba0178,0x46140029,0x3946121a}},	//   _eles_, оси_, فوتر, skos_
  { {0xda650029,0x394d0546,0x0000006a,0x0000006a}},	//   _كافي, _fles_,   ,
  { {0xb4e8005d,0xe9470086,0xda5b000a,0x14180015}},	//   बले_, _قرقی, _וכלל, كيبة_
  { {0xd90d0086,0x25a61239,0xe7b30058,0xaab20065}},	//   _دین_, _viol_, _لمقد, _जलाक
  { {0x628f005c,0x883b000a,0x25f6000b,0x66290030}},	//   ęcon, _ותמו, _एमपी_, éskö
  { {0x6b4001d1,0xcb130008,0xd25700ce,0x394d0072}},	//   _högs, דלת_, дця_, _yles_
  { {0x041a0015,0x0566123a,0x27e6123b,0x2d47059d}},	//   _ويضع_, _ювен, oron_, _põem_
  { {0x6d4304f9,0x104b0036,0x859b000a,0xd59b000a}},	//   _înai, іями_, _ושאו, _ובאל
  { {0x2bb5000b,0xe1ef002b,0x40340054,0x63bd123c}},	//   _अंबा, دسی_, њерс, ísne
  { {0x3da7008f,0x6b40001a,0x27e6123d,0x637b004f}},	//   драб, _lögs, hron_, _ונגד
  { {0x3f8a0073,0x0000006a,0x0000006a,0x0000006a}},	//   albu_,   ,   ,
  { {0x1eab0029,0x2bbb0015,0x0000006a,0x0000006a}},	// [1a90] _وادي_, تازة_,   ,
  { {0xa3e6014e,0x1b780029,0xbe870015,0x2d8900aa}},	//   _बटन_, وصلة_, _يجدو, slae_
  { {0x27e602c1,0x6b4000dc,0x27e00125,0xab84123e}},	//   eron_, _rögt, áinn_, тутк
  { {0x7e9a000a,0x0e9a000a,0xab5b0061,0x61fa0401}},	//   _מסתו, _משתל, _stüd, ittl
  { {0x7d0d1213,0x76430034,0x31580643,0x78ad0085}},	//   meas, wyny, ויאן_, žavo
  { {0x7d0d123f,0xf7730196,0x764300f2,0xb9c70015}},	//   leas, خاص_, tyny, _يتأه
  { {0x27e61240,0xfbb5000b,0x2bb50065,0xe9b40138}},	//   aron_, _अंडम, _अंडा, _абсь
  { {0x7d0d1241,0x1a68002b,0xd5ae0015,0x46180033}},	//   neas, _تیمی_, حفي_, ьціў_
  { {0xa7750010,0x998500dc,0xf8b200f3,0x98140015}},	//   _злач, _élő_, _תשמ_, _لبلا
  { {0x6b4000c0,0xdb0600dc,0x7d0d0a0a,0x6b5202de}},	//   _högr, _kuká, heas, _vægg
  { {0x59990008,0x26c700bd,0x7d0d00f2,0xa9990008}},	//   ּשָׁ, mbno_, keas, ּבָר
  { {0x361a0008,0xc222002b,0xcf89000a,0x14ca009a}},	//   _מועד, اکوو, _הט_, _فهمی_
  { {0x2d801242,0x61fa003e,0x84470015,0xd24e002b}},	//   voie_, attl, _تخال, لنی_
  { {0xa8560008,0xc43a000a,0x6d4f1243,0xf43a000a}},	//   גישה_, _מתני, _alca, _מתנש
  { {0x236500c0,0x51f50029,0xfd96004a,0xab640061}},	//   milj_, _أستر, ешаю, nmüş
  { {0x65a70030,0xf11a0040,0x7d0d1244,0x27e61245}},	//   _műho, _رغبت_, geas, yron_
  { {0xed570ea6,0x6b520134,0xbf9b00aa,0x7ed6008b}},	// [1aa0] хот_, _læge, rwêr, _пінч
  { {0x78ad0796,0x6c830015,0xf1d3000b,0xdb060030}},	//   žavl, الْم, _दबान, _buká
  { {0xeef7000a,0x9af30015,0x2dda0015,0x2d730085}},	//   _אמיר_, اكمت, _عبدة_, mćen_
  { {0x7d0d0939,0x25f6000b,0x6d930061,0x6a95005e}},	//   ceas, _एमबी_, rçac, трує
  { {0x68460010,0x58830afa,0xe7861246,0x7aeb0030}},	//   энда, лыша, нуко, álté
  { {0xf09300b2,0x7bc41247,0x27e000bd,0xab7a0015}},	//   אנד_, mpiu, šino_, _رمزا_
  { {0x38720011,0xe1e70087,0xd5b10016,0x3687006b}},	//   _ţară_, _حس_, _cú_, нсън_
  { {0x88c50029,0x2601000b,0x76a9005e,0x69dc1248}},	//   _لتكل, _शहरी_, фтів_, _ivre
  { {0x88810074,0xb6030048,0xd7ca0015,0xf8cc000b}},	//   _پیون, āšan, _رواه_, ारीप
  { {0xb7d70029,0x8c1b0008,0x41e6042b,0x7d0d0045}},	//   _أولا_, לופי, німа, zeas
  { {0xf6290029,0xf7770008,0x8b57000a,0xc298005e}},	//   _يسمى_, _טעמי_, גייס_, ькох_
  { {0xb5050015,0x29020123,0x914b00ce,0x0000006a}},	//   _لظهو, _ökad_, їчна_,
  { {0xe53b0008,0x30a70010,0x7d0d0011,0xd4090015}},	//   _מתאר, эров, veas, _يتهم_
  { {0x23780015,0x69dc1249,0x4ea7124a,0x8417004f}},	//   _تمتد_, _ovre, ерба, _נקוב_
  { {0x831b0008,0x3ea5124b,0x7d0d124c,0xa2b7004f}},	//   _מוגז, ält_, teas, _אפוד_
  { {0x2bb5005d,0xdb060069,0x6ab90065,0x6286005a}},	//   _अंदा, _ruká, इड्र, řkos
  { {0xe7cf005d,0x69dc124d,0x61ef002a,0x7d0d124e}},	// [1ab0] _सौंप, _avre, ącle, reas
  { {0x7d0d124f,0x2be2000b,0xfaa5002b,0x61e81250}},	//   seas, _पिरा, نجای, ordl
  { {0x5ee80008,0xdcfd0024,0xdeb6000a,0x7d0d1251}},	//   _אַרְ, _eksā, _בפתח_, peas
  { {0x64c410cd,0x200901d7,0xda080015,0x63aa001a}},	//   nčič, _kpai_, عينه_, _lifn
  { {0x399e0089,0x69dc1252,0xa158000a,0xe89402a3}},	//   _růst_, _evre, עבדה_, гаць
  { {0x3f831253,0x7af5002a,0xe758005e,0xf094004f}},	//   noju_, _uczt, ничі_, ננס_
  { {0xc8f5010f,0xceb4039e,0xbb76000a,0xda05000b}},	//   _извъ, ניק_, _יעשו_, _रहित_
  { {0xab640061,0x69c51254,0xa3ad0065,0x19950138}},	//   rmüş, mphe, कदल_, _рабя
  { {0x290f1255,0x3f831256,0x039501b7,0xad1c004f}},	//   mega_, koju_, кроя, לוהר
  { {0x290f0ab5,0x4225005e,0x38760030,0x71f90058}},	//   lega_, вдов, óerő_, ورجس_
  { {0x2d680064,0x628a0026,0x7bcf0026,0x9b16000a}},	//   iğer_, _cyfo, _lwcu, דחתה_
  { {0x290f018c,0x291d000c,0x50460124,0x628a0176}},	//   nega_, ndwa_, вемб, _dyfo
  { {0xc8da0008,0x30760b1e,0x84440015,0xbf660015}},	//   וקרט, тунс, _مخول, ندسو
  { {0xdf150191,0x5f06006b,0x290f1257,0xe28505ab}},	//   льсь, ъзга, hega_, _илли
  { {0x290f1258,0x628a0026,0x0219005e,0x0000006a}},	//   kega_, _gyfo, _ціль_,
  { {0x290f116e,0x2d680061,0x69ce0034,0x78ad00bc}},	//   jega_, eğer_, _rwbe, žavj
  { {0x290f0005,0xc4d20632,0x8c430080,0x73ac000a}},	// [1ac0] dega_, יגן_, аете, ִיאֵ
  { {0x6009000a,0x7fd7004c,0x290f007c,0x7bc40091}},	//   _נִפְ, _שויס_, eega_, rpiu
  { {0xe8fa008f,0xa9a60063,0xab5b00b8,0xbea60180}},	//   дле_, вижд, _stüc, _јанк
  { {0x290f1259,0x81bc003d,0xadd7000a,0xd7e600e2}},	//   gega_, lvēc, _בוטח_, віко
  { {0xd9430054,0xe7b3012c,0x98130058,0x0000006a}},	//   јечи, لمند, لبوا,
  { {0xbcfb0089,0x6d93125a,0x69d80057,0x290f007c}},	//   _jmén, nçan, áves, aega_
  { {0x6f0301e2,0xceb30008,0xfb1b000a,0x69dc0085}},	//   _önce, סיה_, _קולמ, _uvre
  { {0x38c8002b,0x9418004a,0x15140a32,0xa3dd0065}},	//   _ساری_, ежит_, удия, तओं_
  { {0xa5070001,0x13d30033,0x98a300d8,0x88050015}},	//   тења_, ажыў, _вите, _مظلم
  { {0x5fdc005d,0x2bb5000b,0x4c9b000a,0x926a0004}},	//   _बिजल, _अंसा, ושפע, дрма_
  { {0xe1d80033,0x995e0046,0x973c0085,0x3f83125b}},	//   эдні_, _můž_, _nići, voju_
  { {0xbcfb0152,0x3f83002a,0x27e90b28,0x044a125c}},	//   _amén, woju_, šane_, _опек_
  { {0x3f830095,0x1074005e,0xc0ab0021,0x5064125d}},	//   toju_, илюю, بادل_, атра
  { {0x20e30092,0x643b0053,0x2ebf000b,0x3f830091}},	//   ổi_, _קעגנ, ्रेत, uoju_
  { {0x7e440001,0x6397000a,0x291d002a,0xaed4056d}},	//   ахте, _שדוא_, ydwa_, росш
  { {0xf1a4008f,0xb063008c,0x8d7400c3,0xdce4002a}},	//   _крын, ääss, لاقا, ynią
  { {0x290f125e,0x9da8006b,0x3ae9002b,0xbca40015}},	// [1ad0] vega_, търа_, فبای_, لمفي
  { {0x3b540010,0x93fb0008,0xdca40001,0x207c015b}},	//   акур, ולמי, рађи, _קאזא
  { {0x7c2600b8,0x290f125f,0x2b8f0012,0x2bdf0157}},	//   _erkr, tega_, lück_, _फटका
  { {0xdced00b3,0x98e50015,0x44261260,0xaa580054}},	//   onač, اكشو, _oro_, њицу_
  { {0x69c5003e,0x4426008c,0x290f1261,0x88c800ce}},	//   sphe, _nro_, rega_, тлів_
  { {0x290f1262,0x7784009e,0x6d4d1263,0xdced0085}},	//   sega_, аліз, lkaa, inač
  { {0x6446003c,0x69d80091,0x7d1d1264,0x27fd0034}},	//   økin, šver, _kass, stwn_
  { {0xdb0d0467,0x44260176,0x6d4d1265,0x02bd000b}},	//   mpañ, _bro_, nkaa, ोर्न
  { {0xb4650086,0x7d1d050d,0x6b52001a,0x38600125}},	//   دگاه, _mass, _hæga, úirt_
  { {0xdced016f,0x44261266,0x7d1d1267,0x787a000a}},	//   dnač, _dro_, _lass, _אָבו
  { {0x6d4d022d,0xe6590029,0x44261268,0x216a0515}},	//   kkaa, _ثلاث_, _ero_, еини_
  { {0x44261269,0x7bc10046,0x6d4d126a,0x7d1d126b}},	//   _fro_, _člun, jkaa, _nass
  { {0xd9e0014e,0x656900f2,0x6d9a0026,0x73e50004}},	//   _पट्ट, mieh, nïae, _солз
  { {0x9264002b,0x224c0030,0x6569126c,0x7d1d02f2}},	//   ادیم, ökké_, lieh, _aass
  { {0xd3360008,0xb0630020,0x8db50036,0xfce6126d}},	//   _תרצה_, äärs, исті, лово
  { {0x6d4d0035,0xe6d0000b,0x27e00030,0x8d550004}},	//   gkaa, _सज्ज, áink_, атуч
  { {0x0c26008f,0x5f760086,0x7d1d126e,0xeab20015}},	// [1ae0] ыман, _مادر, _dass, معا_
  { {0x501b0008,0x656900b8,0xac970015,0xc7b90030}},	//   _טופו, hieh, انكا_, _erők_
  { {0xeb970001,0x0e750010,0x4efb0135,0x1efb00f3}},	//   ћих_, _выяў, _אליג, _אליע
  { {0x39400084,0xdce8003d,0xfd120015,0x6f1e0034}},	//   ðis_, ēlēs, _اجد_, _hapc
  { {0x6f1e03c0,0x48e307de,0xf74600f1,0x7d04126f}},	//   _kapc, сочв, ледо, mfis
  { {0x77910086,0xe7370063,0xa773042b,0x8c2b000a}},	//   قیقا, леч_, бліч, _אֵלֵ
  { {0xf6e50010,0x7c241270,0x65690012,0xdced0a30}},	//   рцін, lvir, fieh, znač
  { {0x44261271,0xb7d60015,0x398e0046,0x741400c3}},	//   _pro_, _مقرب, kýsi_, لوبا
  { {0x38560063,0x136a0254,0xc3540054,0x7c241272}},	//   _съвс, ешни_, икиј, nvir
  { {0xbcfb038d,0x07a60124,0xa3e5005d,0x4df6000b}},	//   _amél, _сазн, _फिर_, ुझाई_
  { {0xe135005f,0x6569002c,0xa294022a,0x2294004a}},	//   анны, bieh, рані, риня
  { {0xd257008f,0x51870083,0x6569032c,0x69de0cd9}},	//   уць_, ѓуна, cieh, ispe
  { {0x64460020,0x50670b75,0x44261273,0xa3d40088}},	//   äkid, утна, _uro_, _толч
  { {0x2b8f018b,0xa3f7000a,0x23270054,0x7c241274}},	//   rück_, _עמוק_, _бољи_, dvir
  { {0x41e60010,0xadd50001,0x8d770087,0xb2bb000f}},	//   _сіла, робљ, هارا, _אמור
  { {0x60d60084,0x7c240084,0x6d4d00f2,0x62981275}},	//   _geym, fvir, ukaa, _izvo
  { {0x5c070033,0x1d640015,0x9f4b0046,0x6d4d1276}},	// [1af0] ыява, حدَّ, lucí_, rkaa
  { {0x6569018b,0x7d1d1277,0xda7b0010,0x316b002a}},	//   zieh, _wass, няе_, licz_
  { {0x88d50010,0xda15000d,0x7d1d1278,0xdce4002a}},	//   аўлі, рдењ, _tass, hnię
  { {0xdce40050,0x2a980015,0x316b002a,0x6b9c0012}},	//   knię, ائكة_, nicz_, _ehrg
  { {0x6d930ade,0xdb0d1279,0xe0d2000a,0x69de127a}},	//   nçam, spañ, חֲו_, aspe
  { {0x6d580007,0x5fbc0053,0xb8ec005d,0xd6a90086}},	//   _įvai, עצונ, _श्_, نگام_
  { {0xf8c9038d,0xeef8000a,0x0555006b,0x764a0034}},	//   _créé_, אמור_, ития, gyfy
  { {0x79a4000d,0x15450080,0xdce4002a,0xe6280015}},	//   _груе, реим, fnię, اثون_
  { {0x645b003f,0xc952000a,0xdce4002a,0x69060030}},	//   uzui, _ומן_, gnię, érdő
  { {0x33650a61,0x7bdf06be,0xe787127b,0x65690012}},	//   рвог, isqu, _субо, sieh
  { {0x291f0020,0x069b0015,0x4615012c,0x7d04127c}},	//   _kaua_, _أخذت_, _خوار, yfis
  { {0xc4f80029,0xe4cb0015,0x216a127d,0x20560033}},	//   _معها_, _أبان_, тими_, атгр
  { {0xb4c30372,0xc9160008,0x6d930064,0x68e4002d}},	//   ्री_, בחרת_, rçal, óidi
  { {0x2d8b0089,0x6446008c,0x291f007c,0xab5b0012}},	//   _akce_, äkie, _laua_, _stün
  { {0x6d930251,0x60d6002e,0x7bdf0466,0xbda60015}},	//   pçal, _teym, esqu, لحرو
  { {0x7c2400df,0x27e001a3,0xc27a000a,0xb05b0012}},	//   tvir, šini_, _ברצי, ebäu
  { {0x7d04002e,0xab66127e,0x0d990033,0x6b660004}},	// [1b00] rfis, авал, утры_, акаа
  { {0x3fdb0008,0xd00f0086,0x9e66007a,0x7c24127f}},	//   _שקיב, _کلی_, _ввод, rvir
  { {0x2be2005d,0x399c002d,0xbd8a04c9,0x20020020}},	//   _पिका, híse_, _لندن_, ltki_
  { {0x6d430011,0x929a0008,0x48c30054,0x69de1280}},	//   _înap, דיעת, ољша, rspe
  { {0x27e0002d,0x69de1281,0xdb0f0045,0xdb0d001a}},	//   éin_, sspe, _ducâ, ppað
  { {0xbf360053,0x35e60001,0x69de0123,0x69c30046}},	//   שאַץ_, ацив, pspe, ínec
  { {0x09e3009c,0x4b7b0643,0xe9d7006b,0x65c301ca}},	//   _морн, _סאלו, _вкс_, обја
  { {0x27e90048,0xa5340431,0x399c002d,0x0000006a}},	//   šana_, снич, físe_,
  { {0xc9550010,0x93460029,0xa98b0008,0x61e70030}},	//   _утры, لخدم, _יָמִ, ájln
  { {0x316b08c2,0xc6d8000a,0x9f4b0046,0xd7fb000a}},	//   wicz_, _תַּר, tucí_, _בהמל
  { {0x8ab71282,0x5ab7004c,0xd2500015,0x236b006f}},	//   יליג_, יליע_, سنح_, _žijú_
  { {0x26dc1283,0x8c480061,0x39440091,0xd5af0067}},	//   lavo_, _kağı, _joms_, _قفل_
  { {0xb4d2005d,0x64a6057e,0xca6b005e,0x47f9000a}},	//   वरी_, _тада, дiлi, ְּשׁ
  { {0x6d930527,0x26dc1284,0xe72e0033,0x73c30058}},	//   rçam, navo_, зеi_, _بيوم
  { {0x539b0008,0xc1790007,0x7bc60a6f,0x139b039e}},	//   _שיוו, urės_, _atku, _שבוע
  { {0x06570008,0x39440ad3,0xdd910015,0x7175002b}},	//   בילך_, _noms_, سوء_, _دهبا
  { {0x4bd80015,0x717c000a,0x26dc1285,0x417c004f}},	// [1b10] لبلد_, _שנחס, kavo_, _שנחב
  { {0x7bdf038d,0x26dc1286,0x68fb1287,0x6e96002b}},	//   rsqu, javo_, _scud, _گلپا
  { {0x26dc0007,0x49b80115,0xaab4005e,0x99d40067}},	//   davo_, لاند_, ійці, قتنا
  { {0x8c4801e2,0x58d9005e,0x91bb000a,0xdb0e0f24}},	//   _bağı, уддя_, דמאי, _libè
  { {0xdc3500b4,0xd7fb0010,0x9be4005e,0xd0f8000a}},	//   _האָט_, туе_, _мірк, שמדת_
  { {0x8c4801e2,0x26dc0007,0x6f150077,0x8c1a004f}},	//   _dağı, gavo_, nezc, _גושי
  { {0xcf580008,0x8f9c004c,0x6b5202de,0x60dd1288}},	//   שבות_, דיגי, _mægl, kasm
  { {0x7415003b,0x5e780008,0xb4c3000b,0x2002002a}},	//   موعا, יתון_, ्रे_, ytki_
  { {0x69c7016f,0xb345016e,0x60dd001a,0x26dc1289}},	//   _htje, _noçã, dasm, bavo_
  { {0xda0e005d,0x43740036,0xdc880008,0x61e70030}},	//   _सहमत_, жуют, יְתָ, ájlo
  { {0xe695003b,0x399c0125,0x6f150077,0x0000006a}},	//   _الاد, síse_, dezc,
  { {0xf65201e4,0x8c480064,0xca1a000a,0x04c90021}},	//   _מצב_, _yağı, נֵיכ, _صوتي_
  { {0x98790053,0xa4b6000a,0x657e0030,0xf48703ae}},	//   ראָט, _הלנה_, éphe, _тужн
  { {0x889a000a,0x8f76005e,0x83fd0030,0x20021207}},	//   טברי, сумі, ezőg, rtki_
  { {0x20020668,0x82d6000a,0xdd920015,0x52d6000a}},	//   stki_, _הוצג_, كوس_, _הוצע_
  { {0x26dc1286,0xc2120008,0x5f76002b,0x0000006a}},	//   zavo_, _זהה_, _گابر,
  { {0x0ab60029,0xdca3005e,0x3944128a,0x0000006a}},	// [1b20] محاد, зати, _roms_,
  { {0xef1a0124,0xb05b01d1,0x6721128b,0x39440150}},	//   _смо_, rbät, _nalj, _soms_
  { {0x26dc0007,0x8c480061,0x72da004c,0x4a9a0033}},	//   vavo_, _sağı, רקעג, утаў_
  { {0xb4c30231,0xd910002b,0x9965005e,0x3f8a0046}},	//   ्रो_, بیر_, отіл, lobu_
  { {0xdb0e0d92,0x2be2000b,0x81bc003d,0xa967024f}},	//   _libé, _पिटा, evēl, щица_
  { {0x66e30001,0x501b0008,0xa09b00f3,0x7d16128c}},	//   поља, טונו, ניסט, leys
  { {0x86260010,0x67210a00,0x96f90033,0x6dbc006f}},	//   сьле, _dalj, рэчу_, _očam
  { {0x6d46022d,0x67230796,0xee09000a,0xb4d2000b}},	//   _joka, adnj, ׁמוֹ_, वरे_
  { {0x6d460007,0x3f8a0085,0xfb56000a,0x88bb004f}},	//   _moka, kobu_, ֶׁ֨ר_, _תזמי
  { {0x8c1b013a,0x69c1038d,0x8857000a,0xdb070030}},	//   נויי, _élec, _השמע_, _kijá
  { {0x6d5a0024,0x6d4600dd,0x611508f0,0x3f8a01c0}},	//   ītaj, _ooka, одну, dobu_
  { {0x6721044c,0x32630033,0x27e0128d,0x60dd0091}},	//   _zalj, ятыв, šinu_, uasm
  { {0x7d160064,0xc0580127,0x60dd128e,0xa98b000a}},	//   deys, бір_, rasm, רָיִ
  { {0x93fb0008,0xc058042b,0x2019002a,0x60dd128f}},	//   _עלוי, сію_, rwsi_, sasm
  { {0x6f1502c1,0xde58005e,0x6d461290,0xfe730040}},	//   rezc, барі_, _boka, سدس_
  { {0x2d980015,0x88bd0535,0x2b9408d9,0x0000006a}},	//   مَّد_, _maśc, bäck_,
  { {0x81bc0048,0xc1740008,0x7ff70029,0x6d930291}},	// [1b30] zvēl, _מחק_, _اسعا, nçai
  { {0xfbd00015,0xcaf40015,0x8aa70b1e,0x99d70015}},	//   عتق_, كسمب, бред, متصا
  { {0x83fd0030,0x539b000a,0xdb26002b,0x4f67002b}},	//   mzőe, ניבו, تولی, _ناگف
  { {0x7522002c,0x6dbc0085,0x2bbb0015,0xe8550015}},	//   _naoz, _očaj, _ماسة_, يناد
  { {0x672109e7,0xf745004a,0x17fb0015,0xbcfb0125}},	//   _palj, жело, ارصة_, _nméi
  { {0xec360008,0x81bc003d,0x3fdc000a,0x2c770069}},	//   _ואשר_, tvēl, נקוב, aždé_
  { {0x69c7016f,0x6723016f,0x67211291,0xd5e80015}},	//   _utje, rdnj, _valj, معين_
  { {0x6b52001a,0x672101c2,0x5dcc000a,0x854900af}},	//   _nægj, _walj, אֶזְ, рзив_
  { {0x27e0002f,0xe3b61292,0x6b4000dc,0xb8df005d}},	//   áint_, обы_, _rögz, ूँ_
  { {0x98ad002c,0xd6d80004,0x8c1c05bd,0x43691293}},	//   _hneď_, _гтц_, רוזי, раон_
  { {0x44270086,0x95c40015,0x81bc003d,0xc7b90030}},	//   _گراف, _فيله, lvēj, _erőt_
  { {0xe4350086,0xd05a0033,0x798b0034,0x75220f21}},	//   _وفاد, аргі_, nogw, _gaoz
  { {0x7d1600f2,0x6d461294,0xbf9b016e,0x44270067}},	//   veys, _roka, rtên, _دراف
  { {0xbf9b001c,0x20ea0092,0x83fd00dc,0x6d461295}},	//   stên, ời_, rződ, _soka
  { {0x7d16022d,0x83fd0030,0x6d461296,0x3f8a08c6}},	//   teys, sződ, _poka, robu_
  { {0x3f8a0188,0x83fd0030,0xb05b0123,0x2b940012}},	//   sobu_, pződ, rbär, päck_
  { {0xed57000d,0xceb60029,0x0b461297,0x7f860015}},	// [1b40] цот_, _وحدث, онан, _ولبن
  { {0x6d46002a,0x68e90061,0xdc750033,0xc332004f}},	//   _woka, _aded, чысь, ֽוא_
  { {0x32050041,0x7bcd00f2,0x6d461298,0x7cd60015}},	//   ntly_, apau, _toka, _وتحذ
  { {0xc27a0053,0x6d46008c,0x0000006a,0x0000006a}},	//   ברעי, _uoka,   ,
  { {0x68e90026,0x6dbc002c,0x88160031,0x57a60345}},	//   _dded, _očak, تباط, ошка
  { {0xe3a70029,0x05ea1299,0xf7430054,0xe5c60054}},	//   _زر_, афии_, дељо, осио
  { {0xd6d9129a,0xd5b7005f,0xda0e005d,0x8a030054}},	//   сті_, осы_, _सहित_, _озре
  { {0xceb3000a,0xb5aa0015,0x7c29129b,0xe8f709a0}},	//   ויו_, جاتك_, _šeri, _млс_
  { {0x8d5b0053,0x320500da,0xd37a0fea,0x83fd0030}},	//   יכקי, etly_, ичо_, ezőb
  { {0x46a6008f,0xc7b900dc,0x28130015,0x320500da}},	//   _дазв, _erős_, _توكس, ftly_
  { {0xd3770010,0x7abb000a,0x2b940012,0x7bcd003d}},	//   ўчы_, יציו, räch_, zpau
  { {0x81bc0048,0xa2ae000b,0xdbd20061,0xf653004f}},	//   lvēk, ीशब्, _güçt, _קצף_
  { {0x3205003e,0x0000006a,0x0000006a,0x0000006a}},	//   atly_,   ,   ,
  { {0xdefb008f,0x389b0053,0xdfd00015,0x6d930f85}},	//   шым_, ייכנ, ئيّ_, nçav
  { {0x32050041,0xd250003b,0x6d580091,0x7d6b0004}},	//   ctly_, _سنة_, _įvar, ашав_
  { {0x6ecb014e,0x5cb90010,0xd1310015,0x865b000a}},	//   _त्रु, слаў_, _أمة_, בדלי
  { {0x4c940080,0x351b0008,0x0cab0585,0x0000006a}},	// [1b50] дитс, סומנ, ртви_,
  { {0x7f190086,0x3378000a,0x5b14004a,0x7bcd129c}},	//   _ايدز_, צְּב, ммут, rpau
  { {0x7bcd0780,0xdb0e00dc,0x99870089,0xdb05002d}},	//   spau, óján, ínů_, nmhé
  { {0x7bcd00f2,0x828b000a,0x9b45002b,0x58d4005e}},	//   ppau, בְדֶ, _کنسو, доцт
  { {0xdd3a0008,0x5d3a0008,0x3d3a0008,0x97c40015}},	//   _הערכ, _התרא, _הגרס, وتوم
  { {0x70b7005d,0xfbd2000a,0x9f530003,0x32050046}},	//   ःशुल, _אתך_, écès_, ytly_
  { {0x6446019a,0x0000006a,0x0000006a,0x0000006a}},	//   äkin,   ,   ,
  { {0xea000016,0x9e7c000a,0x6d93016e,0xab5b02ad}},	//   _hiếp_, ינופ, açav, _stüh
  { {0xf3f10029,0xc5680029,0xb7d50087,0x5fb7000b}},	//   رأة_, تحول_, _رقاب, _इंगल
  { {0x6d5a0024,0xe7330015,0xdce40061,0x8c1a000a}},	//   ītai, _تصر_, kniğ, צותי
  { {0x83640015,0x95570015,0x3d0c0065,0x672e0052}},	//   بديل, _وخصا, ड्डे_, _óbja
  { {0xd24e0029,0x3205003e,0xa5c6002e,0x9f4201b2}},	//   انَ_, rtly_, slóð, mské_
  { {0x3205031c,0x9f4201b2,0x659a000a,0x40960033}},	//   stly_, lské_, _פינק, ярот
  { {0x320500da,0x80cc000b,0x657b007c,0x2c190065}},	//   ptly_, _थ्रे, lnuh, _नैइं_
  { {0xd24e0086,0x6da6129d,0x9f420107,0x2bb5000b}},	//   _منو_, зива, nské_, _अंजा
  { {0x3cf6005d,0xf8b90092,0xc6920053,0xad39005e}},	//   इलें_, _ngũ_, גאל_, очує_
  { {0xfbd10029,0x81a50002,0x27e910ca,0x60fb000a}},	// [1b60] َتْ_, _تحول, šanj_, _ההפק
  { {0x8b26008f,0x8b230080,0x0c790010,0xed16002a}},	//   ядзе, ндуе, істы_, _łódź_
  { {0xdebb0008,0x69da0029,0x3ebb0008,0x9f420107}},	//   _למיל, صباح_, _לציב, jské_
  { {0xf9690036,0x9f420107,0xf99200e6,0xa2f9000b}},	//   орій_, dské_, ربا_, ्भुज_
  { {0x18180086,0x28cb000b,0x9f420046,0x3d05000b}},	//   تراک_, ाड़ि, eské_, _हॉटे_
  { {0xbb4a003b,0x38330033,0xcff7000a,0x7bcb129e}},	//   _الآن_, энір, פצצה_, ígue
  { {0x6b52002e,0xf62a005e,0x442f129f,0x4ae10065}},	//   _nægi, сіли_, _arg_, _फ़तव
  { {0xa8240086,0xd90d0086,0xceb3000f,0x4a7b000a}},	//   _يکشن, _نیم_, עיה_, _הרלב
  { {0x9f5912a0,0xdc3a005e,0x6d4412a1,0x0000006a}},	//   ltså_, ицiї_, ijia,
  { {0x325412a2,0x87250015,0xd8770015,0xdb1d016e}},	//   двор, _يعلم, _عملت_, _ausê
  { {0x442f0161,0xc7b3000a,0x27e612a3,0xdb210030}},	//   _erg_, _נבע_, lson_, ötés
  { {0x463b0053,0x55bb01d8,0x3cf6000b,0xa63b000a}},	//   _לעבע, _המאו, इलों_, _לגבר
  { {0x90540010,0xdb0e002d,0xc953000a,0xc05800fd}},	//   евяц, _aibí, גמר_, пір_
  { {0xd3700086,0x68e20026,0x27e60252,0x2327004a}},	//   _جهت_, haod, ison_, _ночи_
  { {0xdd950010,0x639b000a,0x26de12a4,0x539b004f}},	//   давы, _הסגנ, _meto_, _היגו
  { {0x5d99008f,0x127b0053,0x26de0844,0xebd9006b}},	//   ікаў_, _לאוע, _leto_, ждаш_
  { {0xcfe80015,0x7bc00003,0x68e20091,0x9f420046}},	// [1b70] _ففيه_, _émul, daod, zské_
  { {0x7b770029,0x3213005c,0xfaa703e3,0x6d560509}},	//   أطرا, łbyś_, пшен, akya
  { {0x98bf04f9,0x7055002b,0x49d9005e,0x61fa12a5}},	//   _nouă_, _رنگا, іддю_, nutl
  { {0x1a680086,0x9f420107,0x6d5600da,0xdb060012}},	//   سیقی_, vské_, ckya, _zukü
  { {0xea000023,0x7b0200f2,0x7d0d12a6,0xf0b8004f}},	//   _tiếp_, äytö, mfas, פלגר_
  { {0x9f420107,0x7c2d12a7,0xdc3a000a,0xbae50015}},	//   tské_, mvar, _ועשר, _زكري
  { {0xa3df005d,0xe7080115,0xcb12000a,0xe619005e}},	//   धीन_, ستون_, _שלל_, іди_
  { {0x98bf04f9,0xce380008,0x9f420107,0xd4d9022a}},	//   _două_, לאות_, rské_, цькі_
  { {0xbcfb00dc,0x7d1a000a,0xf5920015,0x61fa0012}},	//   _elég, חֵיה, خليج, eutl
  { {0x9f420089,0xa7740010,0xdb1d0123,0x5275005e}},	//   pské_, _злуч, _utsä, думу
  { {0x6d5d0064,0x7c2d007c,0x7d0d12a8,0x4254110d}},	//   _olsa, hvar, kfas, етят
  { {0x6560002d,0x442f0796,0x2d680061,0x7c2d12a9}},	//   chmh, _trg_, nşet_, kvar
  { {0xcfaa00a2,0x995c04b2,0xdb0e006f,0x26c7002a}},	//   قاسم_, níš_, _sibí, ocno_
  { {0x03d60008,0xdfcf00e6,0xb3ba000a,0x671d000b}},	//   _חוסם_, شيف_, _ומסכ, फ़िक_
  { {0xe6070086,0x7d0d00b8,0x490e000b,0x7975002a}},	//   خش_, ffas, ण्डो_, nąws
  { {0xf8a50086,0x78bb003f,0x752912aa,0xada30033}},	//   _مک_, _nguv, ndez, васл
  { {0x9f52002e,0x7125012c,0x75290012,0x9f86005e}},	// [1b80] ðbót_, _سريل, idez, _огид
  { {0x7d0d003f,0x0aea005e,0xda660015,0xeb9f00cb}},	//   afas, ідей_, واضي, _spør_
  { {0x0f5704dc,0x2fc0002d,0xb9060033,0xd94612ab}},	//   _חיים_, _huig_, дзек, межи
  { {0x442d010b,0x3cfa0015,0x27e612ac,0x6f1c12ad}},	//   kve_, _بعدد_, tson_, lerc
  { {0x510d0053,0x48e312ae,0x907b004c,0x8b660067}},	//   מהאַ, точв, ֿטצי, _قاسم
  { {0x64460020,0x61fa0064,0x442d0eed,0xe9da0165}},	//   äkim, yutl, dve_, _мкг_
  { {0x27e612af,0x65940033,0x657e0003,0x442d12b0}},	//   sson_, наку, épho, eve_
  { {0x4d5b004c,0x61fa0061,0x6f1c12b1,0x442d12b2}},	//   ַדיצ, vutl, herc, fve_
  { {0xea000092,0x26de0794,0x15ea000b,0x7c89000a}},	//   _khắp_, _teto_, _टिकर_, ּאתִ
  { {0x6d9312b3,0xc726005e,0x6f1c0077,0x61fa01c2}},	//   nçar, _ідей, jerc, tutl
  { {0x7d0d01e2,0xe3af0029,0x442d12b4,0xf7430658}},	//   yfas, جري_, ave_, _шефо
  { {0x316b005e,0xdb1d0003,0x88bd002a,0x7c2d0091}},	//   ішно_, _eusè, _naśl, yvar
  { {0x232a0098,0xc4560015,0x5fd90065,0x236a0058}},	//   _моди_, _تضاع, _बौखल, _وحتي_
  { {0x69c300dc,0xcddb0001,0x5f450015,0x68e001d7}},	//   ínek, жња_, رنزل, _lemd
  { {0x42fb0008,0x12fb000a,0x02fb000a,0x6e940d22}},	//   _והוס, _והוב, _ולומ, виру
  { {0x672800bd,0x7c2d12b5,0x91870015,0xbcfb12b6}},	//   _ladj, tvar, _تجتم, _amér
  { {0x7d0d00b8,0x25a6002d,0xdd9401b0,0x7c2d12b7}},	// [1b90] rfas, _mhol_, таты, uvar
  { {0x672812b8,0x6f1c12b9,0x38660796,0x1f7412ba}},	//   _nadj, cerc, dzor_, _алья
  { {0xfe350053,0x442d12bb,0x6b52001a,0x644605ff}},	//   _װאָך_, zve_, _nægu, äkij
  { {0xdb1d0152,0x6d9312bc,0x8aa412bd,0x442d12be}},	//   _musé, rças, труд, yve_
  { {0x27e912bf,0xe73912c0,0x8d5a000f,0xf9900015}},	//   éan_, зел_, _זכרי, جبل_
  { {0x25a60014,0x9f590152,0xd822004a,0x394612c1}},	//   _ahol_, fusé_, удши, ajos_
  { {0xe6110074,0x69dc0026,0xdb05002d,0xf7700002}},	//   اشت_, _gwre, nmhí, جان_
  { {0x442d12c2,0x94250549,0x6f1c12c3,0x14250a0b}},	//   tve_, емие, zerc, едим
  { {0x442d038d,0xdb0e00dc,0x752900dc,0x395f0020}},	//   uve_, _hibá, rdez, _ilus_
  { {0x6298020a,0x291d000c,0x7ae501e2,0x13090892}},	//   _byvo, lewa_, naht, чной_
  { {0x06380015,0x9f590003,0xf2e6002b,0x63b812c4}},	//   _يسمع_, cusé_, رکوه_, _divn
  { {0x04c80015,0x99f6000a,0x1a16004c,0x291d0cc1}},	//   _قومي_, עזרה_, ײַטש_, newa_
  { {0xdbd70209,0x394d12c5,0x9359005e,0x25ad12c6}},	//   _jäät, _moes_, _нрку_, mmel_
  { {0x291d003f,0x7ae50049,0x25ad007c,0x75ca002a}},	//   hewa_, jaht, lmel_, _węze
  { {0x291d003f,0x4279004c,0xdbd7007c,0x4252002b}},	//   kewa_, _מאַג, _läät, _منور
  { {0xa0a60033,0x6f1c12c7,0xa00a0015,0x291d002a}},	//   _пайд, serc, _فقبل_, jewa_
  { {0x68e00007,0xdde30024,0xac86071f,0xc4d2000a}},	// [1ba0] _remd, ērša, хгал, טגן_
  { {0xe6250023,0x6b520134,0x395f12c8,0xddce0030}},	//   _đông_, _nægt, _alus_, szbő
  { {0xfce612c9,0x4ae1005d,0x68e000e8,0x6edb000a}},	//   _поно, _फ़रव, _pemd, _מחיפ
  { {0x70770086,0xab5b00b8,0x02b60053,0x394d0034}},	//   _آمیز_, _stüt, גלעך_, _coes_
  { {0x394d0495,0x2d8012ca,0xea000016,0xdc760033}},	//   _does_, mnie_, _thắp_, _чынь
  { {0x2d800dbf,0x395f0020,0x58370010,0x9c0b000a}},	//   lnie_, _elus_, эзія_, _מִלִ
  { {0x56930185,0x69ce0b56,0x394d00da,0x63b80123}},	//   лашт, _utbe, _foes_, _rivn
  { {0x394d00ea,0x291d0375,0x2d8012cb,0xa5340719}},	//   _goes_, cewa_, nnie_, тнич
  { {0x2d8012cc,0x672812cd,0x15130138,0x63b812ce}},	//   inie_, _tadj, удыя, _pivn
  { {0x2129003f,0xd62a067a,0x7c3b12cf,0x2d8012d0}},	//   _saah_, _нозе_, _áure, hnie_
  { {0x7d0601d1,0x6fa7005d,0x74140086,0x2d80005c}},	//   _ocks, _गठबं, روگا, knie_
  { {0xea000023,0x25d90086,0x2d80005c,0x62980107}},	//   _nhập_, _آهنگ_, jnie_, _vyvo
  { {0x2d800050,0xbfab0033,0xa5690015,0xe58b000a}},	//   dnie_, зтве_, _تصلك_, _צָבָ
  { {0x2d800050,0xab640064,0x291d12d1,0x200b0085}},	//   enie_, nlüğ, zewa_, rtci_
  { {0xbe8812d2,0x6e95005e,0x6b52001a,0x7ae501be}},	//   есте_, тиву, _lægs, vaht
  { {0xe29b0008,0x5eb40080,0x929b000a,0x429b000a}},	//   _משור, уйст, _מיות, _מסוב
  { {0x7ae50020,0xacf80010,0xab640061,0xe58b000a}},	// [1bb0] taht, энту_, klüğ, לָמָ
  { {0x2d80005c,0xdbd7008c,0x7c2602de,0x200c0045}},	//   anie_, _räät, _dskr, ădit_
  { {0xf7710086,0x2d80005c,0xdbd700f2,0x395f0493}},	//   یات_, bnie_, _säät, _plus_
  { {0xdbd7022d,0xd879003b,0x2d800050,0x88bd002a}},	//   _päät, ومات_, cnie_, _taśm
  { {0x7ae5022d,0xbcfb0896,0x98e40058,0x49b8009a}},	//   paht, _eléc, اكهو, رامد_
  { {0x291d12d3,0xbcfb0003,0x23a2001a,0x6d4f0061}},	//   sewa_, _fléc, yðja_, _hoca
  { {0x291d000c,0x86980063,0xc9770029,0x7f2c000a}},	//   pewa_, нтът_, _كارث, לֵהֶ
  { {0x1da7005d,0xd5ae0015,0xdb080030,0x395f0fc7}},	//   _कीमत, يفو_, ülöt, _ulus_
  { {0x42d50010,0xe4c80002,0x25ad128a,0xc9840ac9}},	//   кіну, ربين_, rmel_, _сури
  { {0x6b52002e,0x98740010,0x2d80062e,0x8c1c000a}},	//   _hægr, _слуц, znie_, לוחי
  { {0x36d4005f,0x2d800050,0x96ca005d,0x442612d4}},	//   _сохр, ynie_, _स्टॉ, _eso_
  { {0x27e90048,0xf8c1005d,0x27ed12d5,0x29020123}},	//   šanu_, एशिय, _kven_, _ökat_
  { {0x25fd005d,0xd24e0086,0xe588000a,0x2d9212d6}},	//   रूरी_, منی_, _אָסָ, voye_
  { {0x6b52002e,0x2d8007e9,0x3ebe00cb,0xa856004f}},	//   _lægr, wnie_, øtt_, דישה_
  { {0x2d800dbf,0xdee30818,0x1ec70099,0xdd920040}},	//   tnie_, роси, тлси_, لوس_
  { {0x27ed0838,0x6dbc12d7,0x1602000b,0x106a0015}},	//   _oven_, _sčas, रंतर_, _يحظى_
  { {0x9cb30015,0x2d8012d8,0x752b0030,0xd197004f}},	// [1bc0] لمفت, rnie_, _magz, _שכפי_
  { {0xab5b00b8,0x2ca70004,0x998d07c4,0x6b6312d9}},	//   _stür, ткуп_, _češ_, акуа
  { {0x6d4f002f,0xeb970124,0xea000092,0x48e605c4}},	//   _foca, њих_, _thập_, воев
  { {0x81bc0024,0xb8f30015,0xba1700c3,0x0000006a}},	//   ovēr, لكمب, ضيها_,
  { {0xf746019c,0x7c2612da,0x7a130046,0x4c83006b}},	//   кедо, _uskr, větš, _вляв
  { {0x7bd6000c,0x7d0412db,0x0000006a,0x0000006a}},	//   mpyu, lgis,   ,
  { {0x27ed12dc,0xab640064,0x7c240012,0x0f7b000a}},	//   _even_, rlüğ, lwir, ורסל
  { {0xa5070054,0x83fd0030,0x6995005e,0x7d0412dd}},	//   већа_, mzőj, _брух, ngis
  { {0x7c2400b8,0x14180015,0x7d0404d2,0xe4a3005e}},	//   nwir, ريدة_, igis, ирьо
  { {0x442600bd,0xdb05002d,0xa2630092,0x43940004}},	//   _vso_, omhá, _trố, ѓанс
  { {0x7982005c,0xa2660063,0x81bc0024,0xd6390010}},	//   onow, тъпл, evēr, _пяці_
  { {0xd5e90029,0x92570080,0xaaa7000b,0x4273110d}},	//   _أعلن_, тают_, केटक, ргюс
  { {0xf8db000a,0x7645008c,0x442612de,0x7982002a}},	//   וחכמ, ähyv, _uso_, inow
  { {0xc7b40053,0x6ae1000b,0xc7b1000a,0xf8b3000a}},	//   רבֿ_, _फ़ेर, ֶ֑ם_, ישר_
  { {0x7982003e,0x44240026,0xd37812df,0xbcfb0003}},	//   know, lwm_, mić_, _aléa
  { {0x7982005c,0x2d550134,0xd37812df,0x9f590057}},	//   jnow, _nået_, lić_, musí_
  { {0xd0110021,0x3179002a,0x81bd003d,0x7982002a}},	// [1bd0] _الخ_, misz_, svēs, dnow
  { {0xf0e3005d,0x765800f2,0xd37812df,0x20e3000b}},	//   _ख़ुद_, kyvy, nić_, _ख़ुश_
  { {0xdb05002f,0xfdb90758,0x44240034,0x3f830085}},	//   gmhá, _площ_, hwm_, mnju_
  { {0x7982005c,0x317912e0,0xc27b000a,0xbcfb0003}},	//   gnow, nisz_, ורבי, _fléa
  { {0xbcfb002d,0x9f420107,0xbbeb0015,0x97c40015}},	//   _gléa, lská_, _ترجم_, لقنو
  { {0xf094000a,0xd3780085,0x9f590046,0x7982002a}},	//   סנס_, jić_, kusí_, anow
  { {0x2d550134,0xd378016f,0x9f420057,0x95c5002b}},	//   _fået_, dić_, nská_, ديبه
  { {0xc3d90036,0x81bd0024,0xdb1d04af,0x2d550134}},	//   ньої_, zvēr, _musí, _gået_
  { {0x54350074,0xe7050086,0xb8e9005d,0xd37812da}},	//   اربر, _مسای, ोड_, fić_
  { {0x290200c0,0x399c002e,0x6ae1000b,0x82350015}},	//   _ökar_, vísi_, _फ़ोर, هرجا
  { {0x3f83016f,0x3179005c,0x9f420264,0x65620eb3}},	//   dnju_, fisz_, jská_, _floh
  { {0xf530003b,0x44240176,0x74120086,0x3cfd005d}},	//   _وإن_, bwm_, جویا, एलों_
  { {0xa3df005d,0x81bd0024,0xd37812e1,0x61fa12e2}},	//   धीश_, tvēr, bić_, artl
  { {0xd3780050,0x40850001,0x92650015,0x7982002a}},	//   cić_, руџб, _مدعم, znow
  { {0x7982005c,0x81bd0024,0x31790fce,0x51f50015}},	//   ynow, rvēr, bisz_, _إستر
  { {0x3179005c,0x81bd0024,0x127a0053,0x6ae1000b}},	//   cisz_, svēr, _ראקע, _फ़ॉर
  { {0xfafa0015,0xeafa00c3,0x3f830085,0x8c430099}},	// [1be0] فراغ_, فرات_, bnju_, бете
  { {0x7982005c,0x7c2412e3,0x4f26006b,0x83fd0030}},	//   wnow, rwir, _сдоб, ezők
  { {0x7c2412e4,0x6f7b000a,0xe8fa062a,0xed5a0a66}},	//   swir, _רְחו, еле_, _зон_
  { {0xd3780050,0x88e60457,0x329a004c,0xea000016}},	//   zić_, ужде, ײבנד, _chạp_
  { {0xe3c80092,0x7982005c,0x83fd00dc,0x200212e5}},	//   _mực_, rnow, szőj, nuki_
  { {0xe3c80023,0x7982002a,0xdbd2007c,0xfe36000a}},	//   _lực_, snow, _müüt, ָרֵי_
  { {0xd378010b,0x6b6312e6,0x15f30029,0xd6d90036}},	//   vić_, _укра, مسيح, тті_
  { {0x44240176,0xd3780050,0x7bc612e7,0x20020061}},	//   twm_, wić_, _kuku, kuki_
  { {0xe6440064,0x88860001,0xd378016f,0x7bc6055a}},	//   ılığ, _слаж, tić_, _juku
  { {0x3179005c,0x44240026,0x61fa00bc,0x33740a1f}},	//   wisz_, rwm_, trtl, ргор
  { {0x44240026,0xd378016f,0x7bc60201,0x85060087}},	//   swm_, rić_, _luku, _موان
  { {0x6ae1005d,0xe3c80092,0xf1ab0018,0xd37812df}},	//   _फ़्र, _cực_, عاده_, sić_
  { {0xf5930029,0x69c10152,0xd37812e1,0xb4c2000b}},	//   _النج, _élev, pić_, ्डी_
  { {0x31790050,0x9f420057,0x8cba000b,0x1ee7002b}},	//   sisz_, tská_, ्शनो, طوری_
  { {0x31790050,0x5237002b,0x139b000a,0x3f830085}},	//   pisz_, _مسيح_, _רבוע, rnju_
  { {0x9f420057,0xac190054,0x27e001c0,0x7bc612e8}},	//   rská_, кобу_, šiny_, _buku
  { {0x3f83016f,0x7bc6013c,0xbb7501ca,0xab7512e9}},	// [1bf0] pnju_, _cuku, агај, агаш
  { {0x9f420089,0x7bc612ea,0xa3e6000b,0x88bd002a}},	//   pská_, _duku, यीय_, _zaśw
  { {0xb60a0010,0xcb080015,0x75c30030,0x8f9c000a}},	//   _жнiв, ايمن_, _kőze, _איזי
  { {0xdc340227,0x4dda000a,0x2d99007c,0xddc7002a}},	//   _zúča, _שחרו, _ukse_, zyjś
  { {0x83fd0030,0x88c8005e,0xe72e12eb,0xc8af000b}},	//   rzők, улів_, ое_, जेंट
  { {0x6d4d0020,0x2b14005d,0x77840033,0xabfa000a}},	//   ljaa, न्दु_, бліз, _בהשר
  { {0xcf580008,0xf1c90092,0x7bc600b8,0x0f58000a}},	//   רבות_, _mạc_, _zuku, ריום_
  { {0xf1c90023,0xdb1d016e,0x7ae70046,0xdd210046}},	//   _lạc_, _fusã, _hejt, _lůžk
  { {0x68eb0035,0xe3c80016,0x6d4d008c,0x87070040}},	//   magd, _rực_, ijaa, _مبال
  { {0x466b0036,0xdced0064,0x69c7003f,0xdbd2007c}},	//   _прем_, ynağ, _kuje, _rüüt
  { {0x38ba01e2,0x6723065d,0x75d10024,0xdbd20020}},	//   _türü_, menj, _bāze, _süüt
  { {0x27e004f9,0x69c702c1,0xdc34002c,0x68eb0035}},	//   ţine_, _muje, _súča, nagd
  { {0xe3c80023,0xf1c90092,0xfc3f00dc,0x660312ec}},	//   _vực_, _bạc_, _szín_, lunk
  { {0xc4840010,0x8f75005e,0x23ab02de,0x7ae70046}},	//   _улік, бусі, føje_, _nejt
  { {0x7bc61203,0x20020049,0x93940067,0xbcfb0003}},	//   _suku, suki_, _اجنا, _cléo
  { {0x8234002b,0xdbd2007c,0x64460123,0x5f76002b}},	//   _درها, _tüüt, åkig, _چادر

  { {0x68eb00b6,0x5f760002,0x672312ed,0x31570002}},	// [1c00] dagd, _نادر, kenj, _خليج_
  { {0xaae50029,0xdb590036,0x6723060b,0xaaba0086}},	//   مسمو, лює_, jenj, ندار_
  { {0x6723018c,0x66030007,0x4efb009d,0x7ae712ee}},	//   denj, junk, _בהיו, _dejt
  { {0xe3c80023,0xd9100086,0xd7fa0010,0x3f9812ef}},	//   _lựa_, ثیر_, вук_, loru_
  { {0x386012f0,0xd8f7005e,0x7ae70030,0xf9890015}},	//   áir_, рнії_, _fejt, دخله_
  { {0x2b03005d,0xa037000a,0xa773005e,0x672312f1}},	//   _लाएँ_, יאנה_, оліч, genj
  { {0xf62a0036,0xf6e50010,0xfb1b000a,0x25fd000b}},	//   тіли_, сцін, _שולמ, रंगी_
  { {0xa6e90023,0x3f980089,0xb4c2005d,0x8e57000a}},	//   _ngươ, horu_, ्डे_, ייצג_
  { {0x65880089,0x5346006b,0x5398006b,0x06f6002b}},	//   běhn, ахна, лвия_, _نساج
  { {0xdb150014,0x44970080,0x672301a3,0xaaaa000b}},	//   _kizá, рвью_, cenj, _कराक
  { {0x69c10014,0xe3c80092,0x6603005c,0xa15906f6}},	//   _élet, _dựa_, cunk, гану_
  { {0x2c5e0024,0x867b000a,0x506701f3,0x6446014b}},	//   _kādā_, _ברבו, атга, äkis
  { {0x938a0063,0x3d0a000b,0x69c012f2,0x19b7000a}},	//   _иска_, िलने_, _mime, יפטר_
  { {0x69c012f3,0x939300a2,0xc43b000a,0x3f9812f4}},	//   _lime, _وجوا, _שתגי, goru_
  { {0xdef8008f,0x7ae70694,0xa187054f,0x7db70015}},	//   шыя_, _rejt, _выпл, لصرا
  { {0x69c012f5,0x67230b6c,0xb2bb000a,0x7ae70030}},	//   _nime, zenj, _במור, _sejt
  { {0x2ac70001,0x31580008,0x65a500dc,0x7ae702de}},	// [1c10] аљев, _כיהן_, zóho, _pejt
  { {0xa4b70008,0x69c012f6,0x9b880015,0x09f70015}},	//   שלמה_, _aime, لنقل_, لأصد
  { {0xc8790045,0x5e590c30,0xfaf00015,0xd9f90033}},	//   _ieşi_, _синя_, بثق_, унец_
  { {0x4998005e,0xf7f50015,0x2c07000b,0xb4c2000b}},	//   атія_, مستد, िंदू_, ्डो_
  { {0x68eb00b6,0x7ae7002c,0x68270080,0x21380053}},	//   ragd, _tejt, рьез, יטאל_
  { {0x660312f7,0x21cc0046,0x69c700bc,0xa7a901b0}},	//   tunk, _něho_, _tuje, ыкла_
  { {0x6723010b,0x68eb0035,0xd6ce0015,0x69d50012}},	//   renj, pagd, رقي_, _utze
  { {0x9985003b,0xe616008f,0x19940010,0x660312f8}},	//   _الرو, ёды_, _дася, runk
  { {0x681a0048,0x443912f9,0x67d4005e,0x660312fa}},	//   gādā, ís_, _моту, sunk
  { {0xe730003b,0x69c0000c,0xb4e6005d,0x75d50015}},	//   _يصل_, _zime, _बड़ी_, _هيئا
  { {0xcb120008,0x69c100dc,0xb6350002,0xb063008c}},	//   הלי_, _éles, _دفاع, ääns
  { {0x3f980305,0x35b5030c,0x0000006a,0x0000006a}},	//   woru_, _убер,   ,
  { {0x55ba000a,0x3438002b,0xdf76002b,0xbcfb0003}},	//   _עמנו, _پسند_, مدآب, _clém
  { {0x50d8005d,0x20f80092,0xf1cf000b,0x8235002b}},	//   _भ्रष, ọi_, _संपन, _هربا
  { {0xc8790011,0x59b9005d,0x25fd005d,0x03ac000a}},	//   _deşi_, ेदार, रंटी_, _שׁוּ
  { {0x68e9003e,0xbf9b001c,0xc6920135,0x3f9812fb}},	//   _need, quên, פאן_, soru_
  { {0x7d160026,0x7ff60115,0x3f9810d6,0xe0d7004a}},	// [1c20] rfys, _اسبا, poru_, _увы_
  { {0x290d0011,0xaf0609c3,0x69c012fc,0x0000006a}},	//   _acea_, _упол, _sime,
  { {0xcf5701e4,0x0f570053,0xfbc9000a,0x637a004c}},	//   _הבית_, _היים_, תת_, נװעס
  { {0xb4e6005d,0xea000092,0xc7c612fd,0xbd460058}},	//   _बजे_, _nhấp_, бски, _انحي
  { {0x69c00a72,0x68e9055e,0xad37000a,0x8f9a000a}},	//   _vime, _deed, _הנכס_, ְיֶי
  { {0xaa460579,0xc448002b,0x07b70015,0x681a003d}},	//   _легл, ییان_, مهنة_, vādā
  { {0x1b7b0053,0x65880089,0x6b630256,0x68e912fe}},	//   _עטלע, běhl, _экра, _feed
  { {0xea000023,0x2c5e0024,0x32050057,0xb5aa0015}},	//   _chấp_, _tādā_, duly_, داتك_
  { {0x786605ae,0x23b40015,0x3ce90065,0x0000006a}},	//   _указ, يمبس, जरते_,
  { {0x681a0048,0xd7ef0015,0x3f72003d,0xe80d0065}},	//   rādā, _أكل_, iņus_, _समता_
  { {0x6b9b0053,0xcb9b039e,0x62660040,0x75d300c3}},	//   רשיד, רסיט, صادق, _فيلا
  { {0x3abb000a,0xa0b90054,0x31c30033,0xb063008c}},	//   טמינ, игну_, ясьв, ääos
  { {0xf8ba005d,0x91ca000b,0x5436002b,0xdc1d01ec}},	//   ेशिय, _संवै, _درار, kņāt
  { {0x995c0089,0xbed400af,0x98a40073,0x0000006a}},	//   jíž_, зорј, _gamą_,
  { {0xf1c90023,0x15f80008,0x1317000a,0x234b002b}},	//   _hạn_, יִּמ, _החול_, _حسنی_
  { {0x2fc90026,0x9d150033,0x0dc812ff,0x0000006a}},	//   _tuag_, ўдач, сури_,
  { {0x68e91300,0x8fa50015,0x9b450015,0x83fd0030}},	// [1c30] _reed, _ومعه, ينرو, szőv
  { {0x9aab0029,0x68e90100,0xf1c90016,0x7c840099}},	//   هداف_, _seed, _mạn_, чусе
  { {0x6aba001a,0x799900aa,0x9d191301,0x3ea70030}},	//   _útfl, toww, _конт_, _ánt_
  { {0xad270087,0xe919005e,0x8ed8002b,0x49b8006e}},	//   _اردو, роді_, _پذیر_, ماند_
  { {0xf1c90092,0xb4e6005d,0x68e91302,0x98a9006f}},	//   _nạn_, _बड़े_, _veed, ľaď_
  { {0x6d810048,0x7c2f1303,0x45d502b0,0x8c1a0643}},	//   rķau, _iscr, оцит, _דושי
  { {0x68e91304,0x27e0003d,0x5eec000a,0x636d0e51}},	//   _teed, ģina_, אַחְ, _húng
  { {0xf1c900a7,0xf7730074,0x160b014e,0x25b60029}},	//   _bạn_, _کار_, संबर_, يهود_
  { {0xfb57000a,0xf1c90016,0xe4560033,0x6d5a0003}},	//   ֶׁ֛ר_, _cạn_, жжы_, êtai
  { {0x23b20086,0x4374034e,0xf1c90016,0xf8ae002b}},	//   وميس, зуют, _dạn_, _شکن_
  { {0xea000023,0xe1261305,0x0000006a,0x0000006a}},	//   _thấp_, омни,   ,
  { {0x2613001c,0xd1c60010,0x24190afa,0xe4cb0015}},	//   mão_, ўляе_, _воды_, _إبان_
  { {0x2613001c,0x7c2f1306,0x490e0065,0x23750369}},	//   lão_, _nscr, ण्टो_, _واتح
  { {0x7f750010,0x5334004a,0x2613016e,0x88ba000a}},	//   пусц, _нечт, oão_, יזרי
  { {0x3ebe1307,0x2613001c,0x7c2f1308,0x539a000a}},	//   ätt_, não_, _ascr, _דיסו
  { {0x9f42006f,0xd012006e,0x75f00030,0x3cf60065}},	//   nskú_, _قلع_, _hózá, ेलें_
  { {0x3cd90010,0x636d002d,0x8fe60015,0xdca30a6c}},	// [1c40] сьсю_, _cúng, _بأعم, дати
  { {0x8a3a0080,0x8b260010,0x1dd2000b,0xf093000a}},	//   ияет_, юдзе, _दंपत, _קנז_
  { {0x2d9e0003,0x7c2f1309,0xf1c90016,0x2613016e}},	//   îtes_, _escr, _mạo_, jão_
  { {0x2613001c,0xc8790045,0x9f42006f,0x8c4601e1}},	//   dão_, _leşu_, jskú_, _деме
  { {0x6d46130a,0x274a08c9,0x443d02ad,0x9f42016d}},	//   _inka, ичко_, _nrw_, dskú_
  { {0x2613016e,0xdb1d0061,0xd7570015,0xa09b000a}},	//   fão_, _rusç, يلنت_, סיסט
  { {0x2613001c,0xf1c90092,0x6725007c,0x443d0034}},	//   gão_, _sạn_, õhja, _arw_
  { {0x69de00f2,0x5454130b,0xaa77000a,0xa9230054}},	//   mppe, звит, _ותלד_, _одсл
  { {0xf1c90092,0xe947002b,0x68e2130c,0x1867130d}},	//   _bạo_, _ظرفی, mbod, _дати_
  { {0x8c1b0008,0xf1c90016,0x2613016e,0x2d680061}},	//   סויי, _vạn_, bão_, rşey_
  { {0x8b030089,0x2613001c,0xbb3b000a,0x443d0034}},	//   _úřed, cão_, בעיי, _erw_
  { {0xdb1d00b8,0x69de0c0a,0x3cf6000b,0x68e20c0c}},	//   _zusä, ippe, ेलों_, nbod
  { {0xf5770015,0x5067005e,0x2606000b,0x107402ed}},	//   _بمنع_, ітма, सूरी_, дляю
  { {0xf1c90092,0x83fd00dc,0x42560015,0x925a0015}},	//   _gạo_, rzőt, _ونشر, _نشعر_
  { {0xcdd80001,0xd5d8000a,0xa5d805bd,0x9dbb00c3}},	//   жњу_, מַּש, מַּי, لدرز_
  { {0xd6570008,0xdb1c0077,0x31690085,0x7c87130e}},	//   חילת_, _dirí, _ulaz_, оузе
  { {0x2613001c,0x2b58130f,0xfbd00067,0x68e20012}},	// [1c50] zão_, _borc_, نتل_, dbod
  { {0x6a670029,0xfaa71310,0x1aa70054,0x8aa70cab}},	//   يطال, ошен, ојег, оред
  { {0x2613001c,0x539b0008,0x7e2b00ce,0x0000006a}},	//   xão_, סיבו, _тіпа_,
  { {0xdeb6013a,0x49c80010,0x2613016e,0x7e9a000a}},	//   _מפתח_, ілін_, vão_, _לסתו
  { {0x9f42002c,0x9cd60008,0x78270015,0x8ca2000b}},	//   vskú_, _מורה_, تعال, _कुपो
  { {0x261303af,0x6fdc0053,0xd2460029,0x4cba000a}},	//   tão_, סקוס, _كن_, _לזרו
  { {0xa955005e,0x9f42006f,0x4efc000a,0xf993012c}},	//   _екві, tskú_, בלוג, _قبر_
  { {0x261303af,0x7d0d1311,0x7c2d1209,0x361800ce}},	//   rão_, ngas, owar, юцію_
  { {0x261303af,0x9f42006f,0xbcfb0125,0x7c2d1312}},	//   são_, rskú_, _cléi, nwar
  { {0x2613001c,0x31b6000b,0x7c2d01c2,0x0000006a}},	//   pão_, ृद्ध, iwar,
  { {0x636d002d,0xe6100015,0xe2991191,0x7c2d1313}},	//   _rúnd, _لشن_, сан_, hwar
  { {0x661c007c,0x225804d6,0x7c2d1314,0xf8cb0065}},	//   _ärka, ärka_, kwar, िशिय
  { {0xf1c90023,0x645d00b8,0xa4870029,0xd7880092}},	//   _tạo_, äsid, _بجان, iển_
  { {0x442d003f,0x69de00f2,0x54560008,0xe1f10015}},	//   mwe_, yppe, _מסנן_, _كسب_
  { {0xf2d200b2,0x442d00dd,0x68e20495,0x7c2d1315}},	//   _טעג_, lwe_, ybod, ewar
  { {0x7d0d0035,0xfc3f002d,0x3cca0001,0x442d1316}},	//   ggas, _brí_, слао_, owe_
  { {0xed57000d,0x2bba0029,0x7c2d1317,0x2b581318}},	// [1c60] чот_, مائة_, gwar, _porc_
  { {0x103b0008,0xf1c90092,0x2f150030,0x4c83006b}},	//   _פגיע, _lạm_, rúgó_, хлув
  { {0xa9261319,0x7c2d131a,0x2f5b000a,0xaf5b000a}},	//   здел, awar, _הדינ, _הכיכ
  { {0xc7c60e88,0x31b201b2,0xcb09000a,0xd884002b}},	//   пски, báze_, טל_, وهای
  { {0x6d3b0008,0x0734005e,0x68460033,0xe7f5000b}},	//   _התכנ, делю, янда, ुंगा_
  { {0xe3a703c4,0x501b0008,0x656b131b,0x442d0034}},	//   _سر_, מונו, _algh, dwe_
  { {0x442d131c,0xbcfb0125,0x0000006a,0x0000006a}},	//   ewe_, _sléi,   ,
  { {0xb06300f2,0x15130080,0xbcfb0c1b,0x69ce0045}},	//   ääks, едъя, _pléi, _iube
  { {0xe3af002b,0x7ae30030,0xa3e6000b,0x7982002a}},	//   گري_, űnte, यीं_, miow
  { {0x27f70089,0x51f80036,0x2768002b,0x7d0d0030}},	//   ření_, оною_, _بشری_, zgas
  { {0xe3af0015,0x29f8131d,0x2258004a,0x3263006b}},	//   دري_, nča_, цины_, етяв
  { {0x79820050,0x7aee00b8,0xe3b80064,0xc05b005e}},	//   niow, _lebt, smı_, біг_
  { {0xafe40010,0xe53b0008,0x69ce131e,0x8557000a}},	//   ноўл, _לתאר, _lube, _משאב_
  { {0x33940015,0x4fc4131f,0x93fb000a,0x31b20046}},	//   _تلتز, есса, _פלוי, váze_
  { {0xd7880023,0x798b0176,0x69ce0077,0x5337000a}},	//   yển_, yngw, _nube, _מנגן_
  { {0x7c2d07e9,0x8d77002b,0x82330015,0x7d0d01c2}},	//   twar, سازا, _أروا, ugas
  { {0x2d5805cb,0x7982005c,0x5ae70029,0x212b1320}},	// [1c70] чить_, diow, كثاف, mech_
  { {0x7c2d1321,0x31b20046,0x212b1322,0x3c440015}},	//   rwar, ráze_, lech_, عَلِ
  { {0xb9c70086,0x20190020,0xdea10086,0xbdb50001}},	//   ستاه, ltsi_, _شیری, _обој
  { {0x28f80010,0xfc3f1323,0x798b003f,0x212b1324}},	//   зець_, _trí_, ungw, nech_
  { {0xf7700074,0x7e6100c0,0x20191325,0xdd3a000a}},	//   گان_, älpf, ntsi_, _וערכ
  { {0x80a0014e,0xf09400b2,0xa3ab000b,0x201901be}},	//   _ऐडसे, ענס_, _कीं_, itsi_
  { {0xf77004c9,0x442d00dd,0x644602df,0x69ce1326}},	//   دان_, wwe_, åkin, _gube
  { {0x7982005c,0x04590015,0x1a68002b,0xbcfb0030}},	//   ciow, قلعة_, _عینی_, _elév
  { {0x442d0991,0x212b1327,0x200b016f,0xcad5000a}},	//   uwe_, dech_, juci_, ֽוֹת_
  { {0x442d020a,0xf8b20008,0xe1f91328,0x8c1a000a}},	//   rwe_, _ישן_, ого_, קותי
  { {0xc2c5003b,0xf1c90023,0xbb3c0053,0x290f00c0}},	//   بيدي, _tạm_, מעזי, ogga_
  { {0x7bdd0005,0x15f40029,0xd17a0036,0x290f1329}},	//   _otsu, _أسلح, існі_, ngga_
  { {0xbf9b001c,0x3f83132a,0x94ab002b,0x88f6004f}},	//   rrên, fiju_, _اطاق_, וזרו_
  { {0x3f83016f,0x7982002a,0x94ba004f,0x0000006a}},	//   giju_, ziow, _ומנת,
  { {0x7bcf038d,0xddd4002c,0xada60146,0x212b0046}},	//   _aucu, ňažn, давл, bech_
  { {0x7bcf04f9,0xc692000a,0x212b0046,0xd1ba0015}},	//   _bucu, דאל_, cech_, _باتا_
  { {0xeafa0029,0x3f83016f,0x7bc7132b,0x67210844}},	// [1c80] قرات_, biju_, _biju, _oblj
  { {0x3f83132c,0x3c190010,0x09e60361,0x7982002a}},	//   ciju_, яўся_, дожн, wiow
  { {0x639a0053,0x7bc70049,0x539a000a,0xadfa002b}},	//   קסענ, _diju, קיעו, _برخط_
  { {0x7aee132d,0x2d850030,0x257a003d,0xf8aa009f}},	//   _webt, élet_, pūli_, овек_
  { {0x87d70086,0x76410026,0x2089000a,0x38cb002b}},	//   وبوس_, _arly, ּתוֹ_, زانی_
  { {0x212b037f,0xe7b3002b,0x7982002a,0x69ce113f}},	//   zech_, نمند, siow, _tube
  { {0x8b030089,0x7982005c,0xceb3000a,0x09e6005e}},	//   _úřad, piow, ֛יו_, _іоан
  { {0xd8260292,0x3f83132a,0xceb3000a,0x7434006b}},	//   _одби, ziju_, כיו_, ениф
  { {0xf8b2005d,0x212b0089,0x76410026,0xb8660058}},	//   _जरिय, vech_, _erly, _غارو
  { {0xd37003c4,0x212b0026,0x7415002b,0xc21a005e}},	//   اهد_, wech_, روپا, оєм_
  { {0x9f5900dc,0x3f83016f,0x212b132e,0xc56a0015}},	//   pusú_, viju_, tech_, _وحصل_
  { {0xf6530008,0xd7880092,0x73e60010,0x7c260134}},	//   _בצע_, iểm_, _жодз, _opkr
  { {0x3205003e,0x55bb0008,0xc05b0010,0x3f830b6c}},	//   arly_, _ומאו, цін_, tiju_
  { {0xa294008f,0xf4870086,0x200b016f,0x20190020}},	//   _палі, _تامی, ruci_, rtsi_
  { {0x212b0264,0x3f83132f,0x639b000a,0x1dc50015}},	//   pech_, riju_, _וסגנ, فْسِ
  { {0x7bcf0375,0x3f831330,0x81fb000a,0x51fb000a}},	//   _pucu, siju_, _וההז, _וההצ
  { {0x91b80029,0x9f420107,0x3f831331,0xe116004c}},	// [1c90] _تطور_, lský_, piju_, _אַיז_
  { {0xfbab0010,0x3196003d,0x1e350033,0x5fdc000a}},	//   ітай_, rāze_, _зноў, _וחזק
  { {0x09e40036,0x2d8500dc,0x9f420107,0x75221332}},	//   воєн, éles_, nský_, _oboz
  { {0xaadf0372,0x4adf014e,0x39490467,0x1adf005d}},	//   _प्रक, _प्रव, ñas_, _प्रथ
  { {0xba740074,0x9d1a0053,0x636d002d,0x99870030}},	//   _یافت, _צושט, _lúna, ínű_
  { {0xbcfb001c,0xbae50015,0x99d70015,0xe7360fb6}},	//   _elét, _سكري, _يتزا, ееш_
  { {0x6442008c,0x9f420107,0xe619005e,0x99d40015}},	//   _aroi, jský_, їди_, _لتقا
  { {0xe5050015,0x673f002a,0x9f4201c0,0x60cd1333}},	//   ربعي, _żyją, dský_, _ngam
  { {0x6442038d,0x7d1a000a,0xaad3000b,0x442601d7}},	//   _croi, הֵיה, _तलाक, _cpo_
  { {0x64421334,0xf1c90092,0x95cb0010,0x60cd013c}},	//   _droi, _hại_, _дуда_, _agam
  { {0x636d002d,0xdb05002d,0x249b0007,0x80c2000b}},	//   _cúna, lmhó, _žymę_, रेने
  { {0x6d5d1335,0x64420152,0x636d002d,0x25d600f3}},	//   _nosa, _froi, _dúna, _טוען_
  { {0xf1c90092,0xf3e4005e,0x6569038c,0x4f9600f4}},	//   _mại_, _ажіо, mkeh, ерву
  { {0xf1c900a7,0x0dca0029,0x25710089,0x9971005c}},	//   _lại_, كبرى_, _dále_, nął_
  { {0xf8a50086,0x443f1336,0x21cc0046,0x63a10030}},	//   _چک_, lvu_, _běhu_, moln
  { {0xf6520053,0xada30010,0x443f1337,0x27ed1338}},	//   נצן_, гасл, ovu_, _owen_
  { {0xf1ca0092,0x0c260033,0x6d5d1339,0xd910002b}},	// [1ca0] _nại_, эман, _dosa, ییس_
  { {0x909b0008,0x9971005c,0x443f00f2,0xbcfb001a}},	//   _מספק, jął_, ivu_, _slét
  { {0x9f5f00dc,0xa3c0000b,0x27ed0034,0x0906133a}},	//   _órán_, ंगत_, _awen_, епен
  { {0x7e6100c0,0x443f016f,0xf1ca0092,0x7539002a}},	//   älpe, kvu_, _bại_, _nawz
  { {0xe973002b,0x63a1133b,0x18670a0b,0x9f42013f}},	//   دهند, koln, наци_, zský_
  { {0xb907000b,0xfc3f0046,0x78ad007c,0xf1ca0016}},	//   _म्_, _vzít_, üava, _dại_
  { {0x8cba005d,0xe5c603fc,0x443f133c,0x16370015}},	//   ्शको, нсио, evu_, فسية_
  { {0xdb1c0064,0x9f420057,0x6442133d,0x60c90091}},	//   _birç, vský_, _proi, žemi
  { {0x70af005d,0xe4520031,0xed5e0016,0x27ed133e}},	//   _घरेल, اضع_, _đột_, _gwen_
  { {0x2c170053,0xbf9b0152,0x6c7b0135,0x9f420057}},	//   עקיש_, trêm, פריד, tský_
  { {0x443f0048,0xa2940484,0x22940238,0x27ed0012}},	//   avu_, тані, тиня, _zwen_
  { {0x64421334,0x9f40002e,0x9f420264,0x32020057}},	//   _troi, _svið_, rský_, čky_
  { {0x4426003f,0x3866133f,0xb97b000a,0x63a10022}},	//   _upo_, nyor_, לנטי, boln
  { {0xbf9b0152,0x9f420089,0x33980015,0xd437000a}},	//   prêm, pský_, _تنتج_, _נטוי_
  { {0x64470024,0x636d001a,0x6d5d1340,0x673a00bc}},	//   ājie, _kúnn, _posa, _matj
  { {0x9971002a,0x1cbb0058,0x0000006a,0x0000006a}},	//   zął_, كاذب_,   ,
  { {0x6d5d0251,0x91bc0008,0xfbd30087,0xcf270015}},	// [1cb0] _vosa, _צמחי, اتر_, _كردي
  { {0x673a016f,0x5e950015,0x6e950015,0x6569006f}},	//   _natj, _للخط, _للخا, zkeh
  { {0x69c90048,0x6d5d002d,0x539b0008,0x61fa1341}},	//   _piee, _tosa, לימו, nstl
  { {0xbcfb0014,0xd70e000b,0x63a10e8c,0x9cb50015}},	//   _elér, _साउथ_, zoln, _لمجت
  { {0xa3c0005d,0xa3c2000b,0xf1b4000a,0x673a0045}},	//   ंगा_, ्दा_, אסף_, _batj
  { {0xdb05002d,0x21040007,0xbbcd000b,0xd702006b}},	//   rmhó, mčių_, ़दीक, азши
  { {0xab940036,0x63a101b2,0x3f910012,0x38661342}},	//   _сирі, voln, inzu_, ayor_
  { {0xf1ca00a7,0x63a10050,0xd8770015,0x75d1003d}},	//   _tại_, woln, _كاذب, _jāzi
  { {0x210400df,0xe8940036,0x02c9005d,0x656900b8}},	//   nčių_, _бать, रश्न, rkeh
  { {0x21040007,0x443f1343,0x9c18000a,0xf1bf0069}},	//   ičių_, rvu_, תחזק_, emá_
  { {0x77900086,0x443f0209,0xa54b0033,0xc2c50015}},	//   _دیوا, svu_, _нядз_, ضيحي
  { {0x63a100dc,0x46560053,0x63860003,0x21040091}},	//   soln, _בױען_, _pénè, kčių_
  { {0x63a11344,0x78fa000a,0x61e40085,0x04c80015}},	//   poln, ופרו, _čile, _كومي_
  { {0xa2830086,0x25ad1345,0x25bf0045,0x25a00796}},	//   _میخو, llel_, lmul_, čile_
  { {0x539a0008,0xe3c80092,0x21040007,0x394d1346}},	//   _קיצו, _cựu_, ečių_, _ones_
  { {0x395f1347,0x63860003,0x27e00045,0xa5c2001a}},	//   _nous_, _ténè, ţini_, _þótt
  { {0x711b000a,0x91bb000a,0x29d71348,0x203302be}},	// [1cc0] _חופפ, _קמפי, _aça_, _نفيس
  { {0x09ca005d,0x7e6100c0,0x394d1349,0x0e66134a}},	//   िद्य, älpc, _anes_, _акон
  { {0xc3320008,0x395f0781,0xb6d90033,0x0000006a}},	//   שוב_, _bous_, _эмiг,
  { {0x8e97000a,0xa927005e,0x02b6004c,0xfaa30033}},	//   _ידיו_, віше_, דלעך_, шахо
  { {0x2614005d,0x394d0107,0xbcfb0030,0x395f134b}},	//   नूनी_, _dnes_, _ilép, _dous_
  { {0xbf9b038d,0x18670001,0x07080015,0x98730033}},	//   quêt, ђаји_, ريعي_, шліц
  { {0x2bd8005d,0xd6270001,0x6aa300b8,0xbb3b004c}},	//   _भंडा, воје_, ünft, _קעלי
  { {0x2ef801f1,0x395f01c2,0x746a0e4d,0xa5340766}},	//   harf_, _gous_, дров_, унич
  { {0x47c6008f,0xd0e3000b,0xb7d700c3,0x12e6004e}},	//   _абав, _क्षण_, _لوقا_, кінг
  { {0xc445002b,0x63760045,0x27e6134c,0x0000006a}},	//   ایون_, _mâng, mpon_,
  { {0xcb13013a,0xd2570036,0x63760011,0x2ef800b8}},	//   בלת_, вця_, _lâng, darf_
  { {0x25a600b6,0x867b000a,0x21040091,0xf1bf0046}},	//   _ukol_, _קראו, yčių_, umá_
  { {0x69d80046,0xf1bf0794,0x61fa134d,0xe5a30a10}},	//   ívej, rmá_, sstl, _тици
  { {0x2d92003f,0x61fa0012,0x27e602f2,0xbcfb0030}},	//   enye_, pstl, ipon_, _alép
  { {0x3da7000d,0xc333000a,0xa2570015,0x2606000b}},	//   враб, _כוס_, _لشيء_, सूची_
  { {0x463b0053,0xc1150054,0x3ebe001a,0xb1150054}},	//   ועלע, _смиј, ýtta_, _смиш
  { {0xc05b0036,0x0dc8134e,0x511a000a,0x5bb9134f}},	// [1cd0] _цій_, тури_, _אֵינ, елая_
  { {0x395f038d,0x201e0011,0xbb740001,0xbf35006b}},	//   _sous_, ătit_, агуј, _снощ
  { {0x210400df,0xe805005d,0xe8cb005d,0x99d40015}},	//   sčių_, _रिहा_, िश्च, لتنا
  { {0x200b0e63,0xad19000a,0x21040091,0x49b800c3}},	//   orci_, _אוֹר, pčių_, ناند_
  { {0x395f0b7a,0x0904005e,0x6d4f1350,0x25710030}},	//   _vous_, рпін, _inca, _nála_
  { {0xf1ca0092,0x394d0026,0xe7380033,0xa3b2000b}},	//   _hạt_, _wnes_, кеі_, _झील_
  { {0x395f038d,0x63760045,0x25bf0045,0x27e61351}},	//   _tous_, _mând, tmul_, apon_
  { {0x84590083,0x2249016f,0x394d1352,0x2571005a}},	//   ерот_, _čak_, _unes_, _bála_
  { {0xb8e9000b,0x6994004a,0x87270015,0xf1ca0016}},	//   ैश_, _трёх, _لعام, _mạt_
  { {0x69d50064,0x25bf0011,0xf1ca0092,0xb882002c}},	//   _kuze, smul_, _lạt_, číto
  { {0x200b005c,0x751500e5,0x818a0015,0xe28507be}},	//   erci_, _مواض, فندق_, улни
  { {0x9f5e0089,0xdb1d00b8,0x68f90026,0xd00a05b3}},	//   čtí_, _ausü, nawd, неме_
  { {0xe44e0457,0xb4fa000a,0x63640144,0x2ef8001a}},	//   _уж_, _נפסי, _còns, tarf_
  { {0x6d4f1353,0xa856000a,0x32450067,0x7af50046}},	//   _anca, אישה_, _منتف, _nezt
  { {0xa3c2005d,0x27e600bd,0xe80d005d,0x63761354}},	//   ्दर_, zpon_, _समझा_, _sâng
  { {0x7e610123,0xcd36002b,0x0000006a,0x0000006a}},	//   älpa, درآب,   ,
  { {0x1c460010,0xf1a9002b,0x2d9200cb,0x69d51036}},	// [1ce0] ынам, _جاوه_, rnye_, _auze
  { {0x63760011,0xabaa00a2,0x6d4f1355,0x0057000a}},	//   _gând, رهام_, _enca, _עשית_
  { {0xd9461208,0xa96a018d,0x8f1b004f,0x48e6011e}},	//   лежи, нижа_, _אוית, гоев
  { {0xfe370008,0xba170015,0xf1ca0016,0x2258014b}},	//   _ערכי_, طيها_, _gạt_, ärki_
  { {0x58d7005e,0x77610144,0xf3f90045,0xe78606da}},	//   удія_, _bolx, byţi_, луко
  { {0x321e00f2,0x3f8a003f,0xeef6000a,0xfaa61356}},	//   ytty_, nibu_, אמַר_, _баго
  { {0x3687006b,0xd6260015,0xeb9709c2,0x7bcb000a}},	//   лсън_, اعتي, _сир_, _רֶכֶ
  { {0x7bce08c0,0x78b1001a,0x636d0125,0xa8ea0015}},	//   _hibu, ðkvæ, _dúnm, _سعرك_
  { {0xb7160029,0x34940010,0x7bce003f,0xa3c0000b}},	//   _مباش, рапр, _kibu, ंगल_
  { {0x3f8a000c,0x41e60127,0x5c37004c,0xc7d7000a}},	//   jibu_, ліма, נרין_, _עובי_
  { {0x6b7b0053,0x63760011,0x179b000a,0xcb13000a}},	//   גרינ, _rând, _טימב, זלת_
  { {0x844604c9,0xe4e30033,0x257800aa,0x7bce1357}},	//   _مختل, _лішн, _sélf_, _libu
  { {0x200b0003,0x7d160034,0x63761358,0xa98b004f}},	//   urci_, dgys, _pând, תָיִ
  { {0x447b00b2,0x84170008,0xf487002b,0x6266002b}},	//   _אנדע, _עקוב_, _حامی, _مابق
  { {0x63030029,0x63760011,0x6da50015,0xf3c9006e}},	//   _طويل, _vând, لمسم, _شبهه_
  { {0xfbdf0034,0x3d0f000b,0x7d161359,0x0000006a}},	//   _drên_, िलें_, ggys,
  { {0x0fb90054,0x69d5135a,0x2d890d36,0x403500af}},	// [1cf0] _илић_, _suze, riae_, _тепс
  { {0x59d9005d,0x7648135b,0x320c0e63,0x34d10065}},	//   _बंदर, _ordy, ordy_, _हल्द
  { {0x7bce0c61,0x5f74002b,0x539b000a,0x5a35023c}},	//   _dibu, _داير, עיבו, рнет
  { {0xe9ab0086,0xd7880092,0x2d8c0030,0x6d4f135c}},	//   ردان_, iểu_, édet_, _unca
  { {0x68f90050,0x69da0152,0x6cfa0008,0xacfa0447}},	//   rawd, _éten, _בפרס, _בהרכ
  { {0x68f90026,0xf745135d,0x3ead0046,0xa7a9006b}},	//   sawd, реко, řetu_, ъкла_
  { {0x7f3c0053,0x8b9a000a,0x870401c5,0xfaa90040}},	//   געוו, _יבשת, сяче, _شهري_
  { {0x49bb0086,0x05651017,0x24920091,0xca480015}},	//   _سازد_, рвин, _žyma_, _حلفه_
  { {0x320b005c,0x23d40033,0x0000006a,0x0000006a}},	//   ącym_, йцэр,   ,
  { {0x25a0018c,0xb7bd04f9,0xc4280015,0xe3b10015}},	//   čila_, _opţi, اثيل_, غرة_
  { {0x67250020,0x45d507de,0xe299135e,0xbb3a004f}},	//   õhju, _тоес, тан_, דעתי
  { {0x69d8001c,0x798b0026,0x3d0f005d,0xa06a057e}},	//   ívei, nigw, िलों_, вама_
  { {0x671c005d,0x3f8a003f,0x6fa60015,0x85c80015}},	//   _नामक_, tibu_, لإسك, _إِنْ_
  { {0xb4c1005d,0x747a000a,0x92650058,0x0000006a}},	//   ंधी_, _שנסג, _ندعم,
  { {0x3f8a0f4d,0x0fc30191,0xacf607c1,0x7bce0049}},	//   ribu_, ійсн, ичај, _ribu
  { {0x3f8a003f,0x7d160007,0x25710107,0x4aa9000b}},	//   sibu_, ugys, _málo_, _कड़व
  { {0x3b860010,0xbbba0015,0x798b0034,0x9c8704b2}},	// [1d00] алаг, ندئذ_, digw, vočí
  { {0xfbdf00a7,0xdcf60061,0x6ffb0643,0xcb0a002b}},	//   _trên_, ıcın, _שפיג, ئيان_
  { {0x69c20150,0xca560180,0xe8fa06c3,0xb4c10065}},	//   tmoe, штањ, вле_, ंधु_
  { {0xc8ca00e5,0xfd1200c3,0x5ca6012e,0xbbea0058}},	//   نوان_, _بجد_, _вимб, _لرسم_
  { {0xa01b00b8,0xb7d70087,0x97c60c71,0x4813005e}},	//   rzög, لونا_, айде, жміс
  { {0x6e3300dc,0x63760011,0x88c50015,0xe3a70021}},	//   _újbó, _mânc, حتمل, _ذر_
  { {0xd6d90036,0x9c870057,0xb633002b,0x96170015}},	//   уті_, počí, قعيت, لغير_
  { {0x2a3b000a,0x9dd7000a,0xe9a30033,0x342602da}},	//   _בעלמ, סופק_, _дасп, афов
  { {0xa3e70001,0x4d77000a,0xa967135f,0xd49a009b}},	//   адња_, יתקל_, _тита_, ърк_
  { {0xd6f80008,0xa6f8000a,0x93930015,0xf3660a13}},	//   _תִּש, _תִּי, ْجَا, ртин
  { {0x0bb7000f,0xd0d5006b,0x877b000a,0x8506002b}},	//   שלים_, йонъ, _שאבי, _نوان
  { {0xa194008b,0x240a006b,0x51f7055f,0x2187011e}},	//   жаюч, _анди_, шнюю_, рѓов
  { {0x6376001c,0xe0df02b9,0x50640189,0x80a40058}},	//   _cânc, rcò_, отра, ْمُن
  { {0x93fb0008,0x547b0008,0x447b000a,0x1ee7002b}},	//   _ילדי, _שְׁנ, _שְׁא, شوری_
  { {0x63a800fb,0x03bb000a,0xb3bb000a,0x59a6000b}},	//   modn, _שצול, _שמוכ, गकार
  { {0x21290375,0x25780030,0x63a81360,0x22580072}},	//   _ubah_, _féle_, lodn, ärku_
  { {0x91bc0008,0xb478000a,0x8c190015,0x5cb90033}},	// [1d10] _במהי, נָֽי, طيار_, улаў_
  { {0x8ae70191,0x2d8c0152,0x7f840015,0x1f150033}},	//   ріал, éder_, _ولين, _умоў
  { {0x8337004c,0x69da0030,0x1ba80015,0x18f70058}},	//   שאבס_, _étel, جُلٌ_, لأشج
  { {0x63a81361,0x645d0601,0x2bd9002b,0xd257004f}},	//   hodn, äsik, _ماسک_, ישבה_
  { {0x8d5a0008,0x798b0034,0x63a81362,0x0aeb0058}},	//   _עכשי, rigw, kodn, _لرأي_
  { {0xcc3a00b2,0xdc3a00b2,0xf1ca0092,0x778400fd}},	//   _געשט, _געשר, _lạp_, оліз
  { {0x6446002e,0xb9e40036,0x798b003f,0xaac3000b}},	//   ækin, _міти, pigw, वेशक
  { {0xf1ca0092,0x1e98000a,0xd5e80015,0x0000006a}},	//   _nạp_, יכול_, جعون_,
  { {0x7989003f,0x2613005d,0xe8180015,0x47d5006e}},	//   _imew, _धमकी_, _نزلت_, _طيار
  { {0xf7730074,0xc6a70292,0x63a81363,0x32450015}},	//   _بار_, _креи, godn, منخف
  { {0x636d1364,0xc517002b,0x6146029f,0x81ca004a}},	//   _júni, _نبشت, бена, лгов_
  { {0xdb05038f,0x636d0f01,0xf1ca00a1,0x31b90de4}},	//   llhä, _múni, _cạp_, téza_
  { {0x24180010,0x63a806db,0x493a000a,0x001a0033}},	//   _вочы_, bodn, נגשו, ыўны_
  { {0x2bdb014e,0xdee300d8,0x53341365,0x75c30030}},	//   _बढ़ा, зори, _мечт, _tőzs
  { {0xdef90010,0x1d0a0c55,0xfce6005e,0xdb050003}},	//   шыў_, леви_, йово, cohé
  { {0xf1d0021e,0xa19300d7,0x6e930015,0xed460054}},	//   _सूचन, _најч, ألفا, љнап
  { {0xd117000a,0x645d008c,0x442f1366,0x0000006a}},	// [1d20] _הקפה_, äsih, _jpg_,
  { {0xcef60054,0x636d001a,0xdb090015,0x20021367}},	//   _учињ, _búni, لزمه_, mski_
  { {0x6e460074,0xc0a90086,0xbf9b0003,0xeb970054}},	//   _انجم, _مایل_, rrêt, љих_
  { {0x9f490084,0xf8fa0029,0xcd36002b,0xda650015}},	//   _hvað_, اءات_, _اردب, غالي
  { {0x2002060b,0x4f65002b,0xbf9b0003,0x9f49001a}},	//   nski_, _طایف, prêt, _kvað_
  { {0x7c240024,0x39400091,0x38330033,0x07a31368}},	//   mtir, žis_, янір, пачн
  { {0x644b1369,0x8afb01e4,0xbb77000a,0x443d136a}},	//   _argi, _תהלי, _פעלו_, _asw_
  { {0x25a0018c,0xb9960029,0x63a8005c,0x7afe0007}},	//   čilo_, _الرب, wodn, lapt
  { {0x6d440026,0x69c0008c,0xf1ca0016,0x94760015}},	//   idia, _ihme, _rạp_, إدعا
  { {0xc1ea0892,0x2002136b,0xb7db000a,0x28130015}},	//   льме_, dski_, _עקבי, _رومس
  { {0xdb1c0152,0x442f00d9,0xe1351292,0x644b136c}},	//   _chré, _epg_, онны, _ergi
  { {0x5a9b0053,0x1a9b0053,0xdb1c002d,0x68e20ec2}},	//   רשטא, ריטע, _dhré, ncod
  { {0x6d440b7c,0x60e40010,0x55bb000a,0xf08b0015}},	//   ddia, яцэз, _עמדו, ائجه_
  { {0x4034012e,0x7c2404ef,0x6d44136d,0x68e2136e}},	//   џерс, dtir, edia, hcod
  { {0x41e60074,0xdb1c002f,0xf1ca0023,0xa2930036}},	//   _استف, _ghré, _tạp_, _наші
  { {0x7c24002e,0xd0110031,0x6bd70015,0x2002136f}},	//   ftir, _قلب_, متطر, bski_
  { {0xe520005d,0x68e20079,0xa01b0030,0x292f002b}},	// [1d30] _यानि_, dcod, szöb, _ﻫﻴﭻ_
  { {0xda7b0010,0x68e20111,0x24740092,0x7bc50061}},	//   ляе_, ecod, ìm_, umhu
  { {0x7a35003b,0x6d441370,0x7c241371,0x78bb0030}},	//   تفاص, bdia, atir, _szuv
  { {0x621b000a,0xe9d80033,0x7bc50125,0xac191372}},	//   רואק, ёкі_, smhu, _кому_
  { {0xc88b0029,0xe9d00029,0xe8f80127,0xa3b8000b}},	//   دخال_, رغم_, слі_, चता_
  { {0x8cbe000b,0xbae50015,0x6c56000a,0xc018000a}},	//   _शरतो, _ذكري, _וישא_, מקדו_
  { {0xb579005e,0x24740016,0x8579004a,0x65c504d5}},	//   ищих_, èm_, исит_, обка
  { {0x2409071a,0x2002051e,0xe945002b,0x68e202b9}},	//   ании_, yski_, _برآی, ccod
  { {0x75ca0050,0xdb200064,0x9359017c,0xe576005e}},	//   _języ, ütçe, арну_, ізь_
  { {0xdc88000a,0x83891373,0x6d44006f,0x387200cb}},	//   מְתָ, рбов_, zdia, øyre_
  { {0xe6950029,0x24740092,0xcb1204dc,0x6d440026}},	//   _بلاد, àm_, ולי_, ydia
  { {0x2002052c,0xa4f70086,0xf5b70015,0x68fb0003}},	//   tski_, _اکثر_, _اصطد, _jeud
  { {0x84470086,0x443d00b8,0xcfaa0015,0xf4340033}},	//   _دخال, _usw_, لاسم_, _нецэ
  { {0xf767003b,0xe8df0092,0x7d060030,0xdb1c0125}},	//   ذا_, _baịn_, _mérő, _thré
  { {0xfc3f0467,0x64491374,0x6e4307c9,0x20020072}},	//   _así_, lvei, мерз, sski_
  { {0x752902b9,0x20021375,0x64490091,0x68fb0d7c}},	//   nfez, pski_, ovei, _neud
  { {0x6fb60029,0x644907df,0xab660f70,0x7ed601f3}},	// [1d40] _ومعا, nvei, овал, _мінч
  { {0x2fd70074,0xda660015,0x6d441376,0x75e70061}},	//   _گوید_, ياضي, sdia, _kızd
  { {0xcf57000a,0x3946004a,0x8d2a1377,0x7afe1378}},	//   _ובית_, жнег, _конв_, rapt
  { {0x7afe1379,0xdebb000a,0x7c24137a,0xd9d7005e}},	//   sapt, _כמיל, ptir, імії_
  { {0x183600e6,0xade0005d,0x68ed0077,0x68fb137b}},	//   تراح, _खंडन_, ñada, _deud
  { {0xbb560029,0x5c730033,0x69d80030,0x68e2137c}},	//   _بنسب, _ўлёт, íves, scod
  { {0xd95a0001,0x7e7a0053,0x7afc0045,0x6449137d}},	//   _краљ_, יאַז, _iert, evei
  { {0x3196003d,0xdb210030,0x9dd7000a,0x2578137e}},	//   bāzi_, ütöt, חוקק_, _béla_
  { {0x7afc137f,0x644900cb,0x7d7b004f,0x69dc1380}},	//   _kert, gvei, ינקו, _hure
  { {0xe3b20029,0x69dc1381,0xcc57004c,0x1dda000b}},	//   برع_, _kure, קסיק_, भदात
  { {0x64490007,0x3946047e,0x1dbf000b,0x3bbb000a}},	//   avei, odos_, ्षमत, שמיד
  { {0xe1ef0086,0x69dc1382,0x394603b8,0xddcb0091}},	//   کسی_, _mure, ndos_, čiūn
  { {0xf8ca005d,0xe571000a,0x84960015,0xafe40033}},	//   िधिय, _רַב_, _بجائ, моўл
  { {0x7afc0d75,0xb4c8000b,0xa6f8000a,0x25a9036d}},	//   _nert, ोखी_, מִֽי, čale_
  { {0xccfb0001,0x2e480063,0x645d00f2,0xa3de000b}},	//   ића_, оято_, äsiv, _दूत_
  { {0xdd910015,0xc1790091,0xfc3f013f,0x98ca0065}},	//   روء_, rpės_, _psí_, िधाए
  { {0x0bd50029,0xdcef0011,0x7afc1383,0xef67006b}},	// [1d50] سياح, _alcă, _bert, _дъно
  { {0x20191384,0x7afc0aff,0x394600e1,0xdf390015}},	//   musi_, _cert, edos_, _اكدت_
  { {0xea000092,0x64490024,0x69dc0939,0xaae8005e}},	//   _đảo_, zvei, _cure, юєте_
  { {0xe9d8008f,0x3f9106c0,0x69dc1385,0x2019008c}},	//   ікі_, lizu_, _dure, ousi_
  { {0x8d5a0008,0x7afc1386,0x394400da,0x66e51387}},	//   _הכרי, _fert, _dams_, пола
  { {0x69dc0152,0x3946047e,0x37ab00d7,0xa3de000b}},	//   _fure, ados_, штен_, _दूध_
  { {0x7c3901e2,0x2019003f,0xf7700002,0x7bdd0061}},	//   şarı, husi_, خان_, _husu
  { {0x7afc00b8,0x7e9c0053,0x64491388,0x7bdd1389}},	//   _zert, יסוו, tvei, _kusu
  { {0x7bd5000c,0x2019138a,0x6fab000b,0x7529138b}},	//   _kizu, jusi_, चकां, rfez
  { {0x2571002e,0x2019138c,0x43740286,0xcad5000a}},	//   _máli_, dusi_, дуют, ּוֹת_
  { {0xcb1200b2,0xa91d0007,0x7ae50596,0x1ddb000b}},	//   עלט_, _amži, icht, _मूलत
  { {0x291d000c,0x24190080,0xb6ba0008,0xcf890643}},	//   ngwa_, _годы_, _הצעי, _גט_
  { {0x291d003f,0x6281014f,0x04580015,0x2019138d}},	//   igwa_, szlo, _وجهت_, gusi_
  { {0x636d002d,0x03b70015,0x39460091,0x3f9e007c}},	//   _cúnt, _بإصد, zdos_, õtu_
  { {0x272f01e2,0x56b50053,0x3ebe0d17,0xdb1c0064}},	//   mını_, לפֿן_, ått_, _virü
  { {0x69da0152,0x2019138e,0xa0a6138f,0x7afc1390}},	//   _étei, busi_, _найд, _sert
  { {0x7afc1391,0xf539006f,0xdca3032d,0x39441392}},	// [1d60] _pert, ieť_, еати, _rams_
  { {0x272f0064,0xef861393,0x0b8a0015,0xab270054}},	//   nını_, _хлоп, حضري_, зофа_
  { {0x6edb0008,0x81bd0024,0x19ba034e,0x7afc1394}},	//   _לחיפ, ktēl, будь_, _vert
  { {0x7ae51395,0x7afc0940,0xd5b2006b,0x7bdd0045}},	//   acht, _wert, аrни, _fusu
  { {0x7afc0849,0x25ad0409,0xccf3000a,0x2d920061}},	//   _tert, doel_, _רכש_, miye_
  { {0x4cbb0008,0x6d461396,0x272f0061,0x2d920061}},	//   _לזכו, _haka, jını_, liye_
  { {0x272f0064,0x6d461397,0x20190030,0xfaa31398}},	//   dını_, _kaka, zusi_, _заро
  { {0x7ec70014,0x2d920064,0x25ad0026,0x6d461399}},	//   lépé, niye_, goel_, _jaka
  { {0xb4c8000b,0x6d46139a,0x272f0061,0xad37000a}},	//   ोखे_, _maka, fını_, לנקס_
  { {0x6843010f,0xa87b0008,0x4274005e,0x2019139b}},	//   _януа, _האמר, дгос, vusi_
  { {0x2d920064,0x0cb9000b,0xe139005e,0x25ad0546}},	//   kiye_, _आर्म, озні_, boel_
  { {0x6d46139c,0x20190b83,0xf653000a,0x02a30033}},	//   _naka, tusi_, _רצף_, эрым
  { {0x2d920064,0xb0c7005d,0x272f0064,0x645d0201}},	//   diye_, रेंग, bını_, äsit
  { {0x08770053,0x272f0064,0x20190553,0x6442008c}},	//   לעכט_, cını_, rusi_, _isoi
  { {0xae1d005d,0xe3b80064,0xfe540010,0x2d920064}},	//   बंधन_, mlı_, нкрэ, fiye_
  { {0xf1a4008f,0xd2b70008,0x6aba002e,0x929b0008}},	//   _прын, _מלות_, _útfy, _ליות
  { {0xea000023,0x5c9904ab,0xa0080015,0xfce80015}},	// [1d70] _đạo_, цкая_, _فقيل_, سفلي_
  { {0xe3b801e2,0x7ae5059b,0x0bb4034e,0x6d46007c}},	//   nlı_, ucht, ебую, _eaka
  { {0x6d4601e2,0x7ae500b8,0x68ed02c1,0x7bd5139d}},	//   _faka, rcht, ñado, _vizu
  { {0x64420945,0x7ae500b8,0xe3b80064,0xd87900e6}},	//   _osoi, scht, hlı_, يمات_
  { {0xe3b801e2,0x272f0064,0xf7450299,0x25ad03f8}},	//   klı_, yını_, дело, voel_
  { {0x501c000a,0x6d46139e,0x32050247,0xfc5a004f}},	//   מודו, _zaka, ysly_, _וכשמ
  { {0x81bd0048,0xda340010,0x95c50015,0xf9930015}},	//   ttēl, _перы, ويته, _كبر_
  { {0xd11f005d,0x13e9005e,0xdb1c001a,0x1dbf000b}},	//   _भाषण_, омий_, _hirð, ्षित
  { {0x272f0064,0x20090024,0x82f90015,0xe3b80061}},	//   tını_, _nvai_, يردز_, flı_
  { {0xd3890036,0xe2990001,0xb2f40080,0xec38000a}},	//   ійне_, жао_, няющ, לאחר_
  { {0x272f0482,0xda7a00b2,0x32050041,0x9f5900f2}},	//   rını_, ַנשר, usly_, issä_
  { {0x272f01e2,0xc692039e,0x3d07000b,0x645d008c}},	//   sını_, _באב_, षणों_, äsis
  { {0xe3ae008f,0xa01b0014,0x3205003e,0x6d46139f}},	//   _аб_, szön, ssly_, _raka
  { {0xdb1c002d,0x81bd0024,0xdfd20115,0x753b0602}},	//   _phrí, ntēj, ئيس_, leuz
  { {0x1d0a000d,0x2d920064,0x533205e6,0xdd920002}},	//   жеби_, tiye_, _рејт, نوس_
  { {0x9f5900f2,0x0d9a0033,0x24920091,0x656b06cd}},	//   essä_, ітвы_, _žymi_, _jogh
  { {0x2d920064,0xdb07002e,0xad250015,0x81bd003d}},	// [1d80] riye_, _skjá, عرفو, ktēj
  { {0x6d460f4d,0x2d920064,0xdcef003d,0xdb1c0125}},	//   _waka, siye_, ādāt, _thrí
  { {0x2d8013a0,0x753b0111,0x6d4613a1,0x637f06be}},	//   phie_, keuz, _taka, _gêne
  { {0xe3b80064,0x3ebe001a,0x81bd01ec,0x0000006a}},	//   zlı_, ýttu_, etēj,
  { {0xe3b80064,0xd90d0086,0x7d0413a2,0x6d3b000a}},	//   ylı_, صیل_, mais, _ותכנ
  { {0xdc8b0008,0x7d0413a3,0x752202b9,0xf7430054}},	//   _וְלָ, lais, _scoz, вељо
  { {0x68e90026,0x27ed0111,0x2f97000a,0x443f002a}},	//   _ffed, _eten_, וכסן_, ewu_
  { {0xc9660010,0x7d0413a4,0x69950033,0x81bd003d}},	//   _ўвай, nais, _зрух, atēj
  { {0xe3b80064,0xcdb7000a,0x87260004,0x2db7004f}},	//   tlı_, ופקה_, _омаж, ולקן_
  { {0x656b002d,0x7d0413a5,0x3196003d,0x25a90dd9}},	//   _eogh, hais, kāzs_, čala_
  { {0x7d04022d,0x81bd0048,0xe3b801e2,0x656b002f}},	//   kais, stēm, rlı_, _fogh
  { {0x2d9e0014,0xc5f30008,0x7d040604,0xe3b80061}},	//   étel_, _ידע_, jais, slı_
  { {0xe3b80061,0x9f59008c,0x31b90030,0x13f30033}},	//   plı_, yssä_, nézi_, _азія
  { {0x81bd0024,0xc05801c6,0x7879004f,0xe28f009a}},	//   otēk, фію_, פָרו, اذی_
  { {0xd9040074,0xdfd413a6,0x8d770018,0x52830015}},	//   _پی_, торы, وارا, _للوك
  { {0x81a70015,0x5f1b000b,0x7d0413a7,0x9257006e}},	//   _تحتل, _बाक्_, gais, _آشور_
  { {0x4c940080,0xfbdf13a8,0x9f840030,0x3b5513a9}},	// [1d90] витс, _quê_, zöé_, нкар
  { {0x31a40064,0xa3c3000b,0x1bd5004a,0x60c013aa}},	//   mıza_, ्षय_, хозя, ümme
  { {0xc9150124,0xdb1c0084,0xfbd00015,0xb9e4005e}},	//   едећ, _virð, شتك_, вічи
  { {0xae1a000a,0x5e76000a,0x443f002a,0x28f8005e}},	//   _צורכ, _נתרן_, ywu_, дець_
  { {0x656b017e,0x31a401e2,0xa3c3014e,0xf8b10086}},	//   _rogh, nıza_, ्षम_, اکز_
  { {0xf1ca0092,0x656b002d,0xabfa000a,0xdb0704d1}},	//   _dạy_, _sogh, _מהשר, _skjæ
  { {0x81bd0048,0xbbbd005d,0x45d513ab,0x2bd8000b}},	//   rtēj, ्गीक, нцит, _भूटा
  { {0x79820050,0x443f002a,0x81bd003d,0x85940033}},	//   chow, twu_, stēj, кшыц
  { {0x27ed003c,0x81bd0024,0xfbdf13ac,0x753b13ad}},	//   _uten_, ptēj, _grêt_, reuz
  { {0x2d8c0152,0xe3c50015,0xa71402a3,0xca35004f}},	//   édez_, عْدَ, _амфі, ֲנָה_
  { {0x03220010,0x656b002d,0x68e400b3,0xe4d90015}},	//   ыдэн, _togh, žide, _فوات_
  { {0x46380029,0xe4510015,0x31a40061,0x63ba0052}},	//   _تأكد_, _مضت_, fıza_, altn
  { {0x600713ae,0x7bc7008c,0x30760054,0x7d0413af}},	//   нням_, _ohju, хунс, vais
  { {0x0000006a,0x0000006a,0x0000006a,0x0000006a}},	//     ,   ,   ,
  { {0xf77200a3,0x02450015,0x63a60030,0x6da6004a}},	//   נקל_, _أَبَ, ékne, еива
  { {0x3f83007c,0xf1ba000a,0x7bc7007c,0xa3de000b}},	//   ahju_, _מֶ֥ל, _ahju, _दूँ_
  { {0xdee60cf2,0xc19b000a,0xeafa0015,0xdb1e008c}},	// [1da0] _попи, _משקי, كرات_, ympä
  { {0x7d0413b0,0x9b460029,0xdb1c002d,0x2bba0015}},	//   sais, عناو, _bhrá, ساءة_
  { {0x61eb04f9,0xe9da111b,0xc332039e,0xdb1c0057}},	//   _înlă, чке_, רוב_, _chrá
  { {0x307a0053,0xfbdf0152,0xcb09000a,0x2571001a}},	//   ּאַנ, _prêt_, מל_, _máls_
  { {0x75c30030,0xa3de000b,0x75e70061,0x63ba02dc}},	//   _főzz, _दूं_, _rıza, yltn
  { {0x60c4000c,0x38cb0086,0x501b0008,0xdb1c002d}},	//   _mzim, سانی_, פוצו, _fhrá
  { {0xe2870029,0xe60f0015,0xdb1c0125,0x0000006a}},	//   _إذ_, مشي_, _ghrá,
  { {0xe5540099,0x99d60058,0xd6d900ce,0x0000006a}},	//   ткињ, _أقرت, фті_,
  { {0x60c4000c,0x64a30001,0x98a30bb1,0x4614009a}},	//   _nzim, лаћа, _бите, روکر
  { {0xb8f3005d,0x54330029,0x88350033,0x389b004f}},	//   हे_, ارير, _шэсц, _זימנ
  { {0xf656005e,0x26de02f2,0x60c413b1,0x25710030}},	//   _ятаю, _igto_, _azim, _pált_
  { {0x4a9b0053,0x546a0063,0xbcfb0003,0x63760045}},	//   לייג, _наем_, _inég, _mâni
  { {0xc953013a,0x257100dc,0x74130040,0x0000006a}},	//   אמר_, _vált_, _مونا,
  { {0xa3c3014e,0x25a0018c,0x60c40024,0xd5df000b}},	//   ्षण_, čilu_, _dzim, _पूँज
  { {0x9757000a,0xde58005e,0x4377004c,0x83690015}},	//   עילו_, нарі_, _אײגן_, _تصنف_
  { {0x315b0015,0x3eba00cb,0xb2bb000a,0xa2bb000a}},	//   _رجعة_, _dypt_, _ממור, _ממוט
  { {0x2ef5010f,0x321e005c,0x71d8000a,0xdb1c0125}},	// [1db0] _изпр, luty_, _אוהד_, _shrá
  { {0x35b2000b,0x7e610123,0xf3f1000a,0xfaa7005e}},	//   ँकड़, älps, ׁ֣ב_, ншен
  { {0x314b0008,0x321e037f,0xd5df000b,0x9a590021}},	//   ּתְּ, nuty_, _पूंज, بلاط_
  { {0x39780127,0x621b000a,0x201913b2,0x628813b3}},	//   нсію_, לובק, orsi_, izdo
  { {0x6d5d13b4,0xa09c004c,0xad1a000a,0xc19c004f}},	//   _insa, ּיוט, _קושר, השאי
  { {0x2b1e005d,0x39490cd4,0x6d4d13b5,0xb6590a61}},	//   _पाएँ_, žas_, ldaa, дших_
  { {0xfbdf03af,0xe7080115,0xcf58000a,0x7c2d13b6}},	//   _três_, رتون_, תבות_, ltar
  { {0x49040086,0x99d40002,0x0e5c000a,0x6d4d13b7}},	//   _موفق, _متقا, לדוב, ndaa
  { {0x6d4d00f2,0xd6db0004,0x69c9008c,0x200b0085}},	//   idaa, _ете_, _ihee, jsci_
  { {0x69da0152,0x87d70015,0x7c2d13b8,0x3ead0046}},	//   _éter, _أغرا, itar, řety_
  { {0x60c400dc,0x7c2d13b9,0xdce60024,0x6f070a52}},	//   _szim, htar, _lokā, dajc
  { {0x25090086,0x04b5006b,0x7c2d13ba,0xd00a0004}},	//   _آرای_, _исля, ktar, меме_
  { {0x15180029,0xdce6003d,0x21a3004a,0x40330033}},	//   _أزمة_, _nokā, риям, аеўс
  { {0x6d5d13bb,0x6d4d0079,0x7c2d13bc,0xe04303ae}},	//   _ansa, edaa, dtar, јнри
  { {0xee150010,0x657b003f,0xc7b2000a,0xdfcf0015}},	//   льтэ, okuh, יבך_, زيف_
  { {0x40960029,0x6d5d0045,0x6d4d02f2,0xc236000a}},	//   _للعر, _cnsa, gdaa, _ירצו_
  { {0x60c4016f,0x7c2d0a4d,0x1ae60da6,0xcd27006b}},	// [1dc0] _uzim, gtar, возм, ъжте_
  { {0xa3c1005d,0x8ad60029,0x3eba0111,0xa3c3000b}},	//   ंति_, نتائ, _typt_, ्षि_
  { {0x4dd60029,0xab27006b,0x657b05ff,0x442d13bd}},	//   _لتحس, тоха_, kkuh, hte_
  { {0x69c913be,0x442d0362,0x3f980049,0xa91d01c0}},	//   _chee, kte_, liru_, _alžb
  { {0xa3c3014e,0xa3c1005d,0x39130010,0x69db0144}},	//   ्षा_, ंता_, рмір, _diue
  { {0xbb760063,0x18670001,0x69c90111,0x31b90089}},	//   _румъ, таљи_, _ehee, lézt_
  { {0xbf9b0053,0x96270015,0xf6e50033,0x8f9b015b}},	//   ויסש, نكوك_, уцін, ויסי
  { {0x657b13bf,0xe5c60054,0x628813c0,0x442d13c1}},	//   gkuh, њско, vzdo, fte_
  { {0x37e60191,0xa3c0014e,0x75e701e2,0x674500dc}},	//   _розг, ूगल_, _hızl, ítjü
  { {0x61e313c2,0x671c000b,0x637f016e,0x75e70061}},	//   _bunl, _नाटक_, _pêna, _kızl
  { {0xf3630174,0x3f980085,0x7c2d13c3,0x442d05ef}},	//   ртын, diru_, ztar, ate_
  { {0x92930010,0x6446002e,0x6f07005c,0x9695009c}},	//   раюц, ækis, wajc, _сруш
  { {0x5334008f,0x68ed02c1,0x2904003f,0x442d13c4}},	//   _белт, ñadi, _mema_, cte_
  { {0x321e003e,0xdce6003d,0x29040d29,0xf457004f}},	//   puty_, _rokā, _lema_, _שיגר_
  { {0x91e30001,0x7c2d005c,0xcddb0001,0x6f07002a}},	//   _које, wtar, дња_, rajc
  { {0x290413c5,0xed140036,0x672d0085,0x7c2d0624}},	//   _nema_, имсь, đaji, ttar
  { {0xd1b80067,0x3f9813c6,0x7c2d13c7,0x6d4d13c8}},	// [1dd0] _جاوا_, biru_, utar, rdaa
  { {0xd9cb005d,0x2d8200f6,0xbcfb0152,0x257800dc}},	//   िष्ट, _elke_, _poés, _déli_
  { {0x6abc0026,0x7bdc0375,0x442d13c9,0x69c90034}},	//   _cyrf, _diru, zte_, _phee
  { {0x27e400e8,0x7bdc0034,0x6abc0034,0x442d13ca}},	//   _bumn_, _eiru, _dyrf, yte_
  { {0x442d13cb,0x69db0144,0x9d1a000a,0x7bdc13cc}},	//   xte_, _viue, _אורט, _firu
  { {0x69c9003e,0x07090029,0x442d04af,0xb07c004c}},	//   _whee, ريبي_, vte_, ונדז
  { {0xc7940086,0x6abc0026,0xdcf6002a,0x3635002b}},	//   جشنب, _gyrf, łcąc, ارتس
  { {0x05540080,0x58050015,0x6f0513cd,0xa3e7000b}},	//   атья, _مورك, _lehc, _मंद_
  { {0xf1bf13ce,0x77930086,0x65690209,0x33d5005e}},	//   dlá_, _پیغا, rjeh, ліот
  { {0x29040024,0x442d13cf,0xf7700040,0x61e302f2}},	//   _zema_, rte_, _وال_, _punl
  { {0x3f9801a3,0x65690085,0x442d05a9,0x35f513d0}},	//   viru_, pjeh, ste_, _спер
  { {0xeab2000a,0x442d13d1,0xdd110061,0x208a02dd}},	//   מֹר_, pte_, _rüşd, ейми_
  { {0x394d0176,0xa8790053,0x628e002c,0xd0960892}},	//   _maes_, גאָר, úbor, ушны
  { {0x649a00b4,0x749a00b2,0xe7c3000b,0xf1bf013f}},	//   _אינה, _אינפ, षतिप, alá_
  { {0xe1f104b6,0x200000da,0x6fc00012,0xc3320447}},	//   _است_, _wwii_, löck, _לוג_
  { {0x22580134,0x6e930015,0xbda50015,0x9da50015}},	//   ærke_, حلفا, لحقو, لصقه
  { {0x25bf0011,0xe0da0805,0x31600061,0x6abc0034}},	// [1de0] ilul_, _яви_, _iniz_, _syrf
  { {0xdd0401e2,0xbb4a0029,0x69c30003,0x1ee8002b}},	//   ısın, علان_, înen, _جودی_
  { {0xe37a01ac,0x7bdc0a25,0x0f57000a,0x3bd5004a}},	//   ערער, _viru, _עיטם_, рютс
  { {0x7bdc005c,0xfe9b0135,0xdcf70045,0x25780030}},	//   _wiru, _טיימ, ăcăr, _téli_
  { {0x18330015,0x8eda002b,0xd90d002b,0x7bdc13d2}},	//   مروح, _تذکر_, بیق_, _tiru
  { {0xc8080092,0x6fb4000b,0x4733005e,0xf8a90015}},	//   rở_, ंकिं, йніс, خدمه_
  { {0x394d0026,0x290413d3,0x7d0613d4,0xd5b00015}},	//   _faes_, _tema_, _keks, يفت_
  { {0x5e570053,0x81bd0024,0xe5c602bf,0x746a014d}},	//   ריקע_, ntēt, ысло, еров_
  { {0xd90d002b,0x69d80091,0xdb1c0012,0x7d0613d5}},	//   _آیه_, įved, _thrä, _meks
  { {0x883b000a,0x25bf0045,0x38cb002b,0x3437006e}},	//   _אתמו, alul_, _ساقی_, اسيد_
  { {0x0bb7000a,0xfbb7000a,0x877b004c,0x81bd003d}},	//   רלים_, רפית_, _ראבי, ktēt
  { {0x25bf0045,0x6fc0038f,0xd0d5006b,0x216713d6}},	//   clul_, böck, ионъ, утог
  { {0x637613d7,0x05b30015,0xb97b000a,0x637f059d}},	//   _sânu, _امنح, תרכז, _gêno
  { {0x63760011,0xf1bf13d8,0x8233009a,0x7d060073}},	//   _cânt, slá_, جریا, _aeks
  { {0xa3c3014e,0xa3c1005d,0x2dcb0054,0xbed50b1e}},	//   ्षर_, ंतर_, ећан_, ровј
  { {0xbca50029,0x8cf50004,0xe213006e,0xf1bb000a}},	//   لمزي, рзац, _ابوع, _אֶ֖ל
  { {0xcb1b000d,0xd0110086,0xe04b0015,0x63760045}},	// [1df0] еќе_, _بلخ_, _أشبه_, _fânt
  { {0xeb930015,0x3ce6006f,0x75e70061,0xdb23009a}},	//   حظر_, ľova_, _sızm, صوصی
  { {0x9a27002b,0x7d060030,0x7dc70058,0x394d059d}},	//   طعان, _feks, _متحك, _paes_
  { {0x4dfa00b2,0xa9070002,0x99d400a2,0xb9350054}},	//   _שפרא, ابان, متنا, редј
  { {0xd70507d1,0xa1ac004f,0x0000006a,0x0000006a}},	//   азли, עֱבִ,   ,
  { {0x17f80029,0x07a5000d,0x91720016,0xe73913d9}},	//   ارنة_, јакн, rở_, тек_
  { {0x25bf0011,0x6d4f013c,0xe5710015,0x27f800bc}},	//   tlul_, _kaca, قطة_, _črne_
  { {0x6fc00012,0x6d4f13da,0xd5e80015,0x59a90065}},	//   töck, _jaca, دعون_, _कदिर
  { {0xb81c005d,0x64a50010,0x572700e5,0x87270031}},	//   _नियम_, рапа, _مراق, _معام
  { {0x6d4f13db,0xa757006e,0x9cd8004f,0x25bf005a}},	//   _laca, _حضرت, נוזה_, slul_
  { {0x3dc00034,0xa2d00065,0x25bf13dc,0x0000006a}},	//   yliw_, डेल्, plul_,
  { {0x24960074,0x63760045,0x672d0085,0xe29603ca}},	//   انید_, _sânt, đaju, раю_
  { {0x764e002e,0x7d060c2c,0xd00f0015,0xa4d5005e}},	//   _ábyr, _reks, ولَ_, _тоді
  { {0x63760011,0x645913dd,0x7d0613de,0xa856004f}},	//   _dâns, _irwi, _seks, בישה_
  { {0x3ebe002e,0x645c0024,0x2d9613df,0x539a0447}},	//   ætt_, ārie, арас, _ביסו
  { {0x41b30015,0x6459002a,0xed460b1e,0xa19301ca}},	//   _ومور, _krwi, јнап, _мајч
  { {0x81bd0024,0xcaf60029,0x7d0613e0,0x91bb000a}},	// [1e00] rtēt, لساب, _veks, _במקי
  { {0x6e2f00dc,0xb8820089,0x2578001a,0x81bd003d}},	//   önbö, říkl, _hélt_, stēt
  { {0xeb970001,0x3daa0010,0x590a006b,0x81bd003d}},	//   јих_, _акно_, веем_, ptēt
  { {0x32360053,0xc236000a,0x010d004f,0x0000006a}},	//   יטען_, ירעו_, ֲלוּ,
  { {0xa01b00dc,0x6d441358,0x7b010030,0x0000006a}},	//   szöv, meia, éztü,
  { {0x2d80005c,0x207b0053,0xc7a30661,0x9057000a}},	//   lkie_, כאנא, оичк, יבנו_
  { {0xbb3b0008,0x7c2402c1,0xdaba0086,0x7fd70008}},	//   _שעלי, luir, _شهرت_, בוסס_
  { {0x2d80020a,0xdb0713e1,0x94aa0015,0x6d441349}},	//   nkie_, _skjø, َاةِ_, neia
  { {0xb7160086,0x89db000a,0x34940033,0x69c2007c}},	//   _نباش, _יחלי, сапр, mloe
  { {0x6e3e003c,0x69c213e2,0x6d4413e3,0x6459002a}},	//   _oppb, lloe, heia, _drwi
  { {0x0cc3005d,0x2d8013e4,0xcb130008,0xdb1c002d}},	//   _शर्म, kkie_, חלת_, _bhrú
  { {0x25780030,0x067b000a,0x867b000a,0x7c24036d}},	//   _célt_, _שנאל, _שראו, kuir
  { {0x248d005c,0x6d44016e,0x2d80002a,0xdb05039f}},	//   czem_, deia, dkie_, rohú
  { {0xdb0500c0,0x7c24028f,0x6d4f0c98,0x613c02de}},	//   llhö, duir, _saca, _pålæ
  { {0xf2060063,0xa3b3000b,0xbcfb0003,0x4fd4005e}},	//   _тяло, झकर_, _anéa, іжст
  { {0xdb1c002f,0x463b0053,0x69c80024,0xccf80001}},	//   _ghrú, כעלע, _ūden, ићу_
  { {0x65620f1b,0x442413e5,0x69c20026,0x5b150142}},	// [1e10] _mnoh, num_, dloe, ймат
  { {0x6d4f013c,0x3378000a,0x2d80002a,0x6a170015}},	//   _waca, נְּב, akie_, لبصر
  { {0x6d4f002f,0x5a350661,0x7f3c000a,0xddc70030}},	//   _taca, снет, _יעזו, őműv
  { {0xac190036,0x2d8013e6,0xdeb6000a,0x98150015}},	//   _йому_, ckie_, _לפתח_, مبتا
  { {0x765a0050,0x442413e7,0x7d0d13e8,0x7c240045}},	//   _arty, jum_, maas, cuir
  { {0xbb85003b,0x442413e9,0xcc760008,0x4af8004a}},	//   _السي, dum_, _הגשת_, _верю_
  { {0xff18000a,0xe7680015,0x69c213ea,0xe28e011e}},	//   בקות_, شحون_, bloe, _наi_
  { {0x44240084,0x69c20251,0x31b2002c,0xa01b05a5}},	//   fum_, cloe, bázy_, nzös
  { {0x442413eb,0xe3b909dd,0x0000006a,0x0000006a}},	//   gum_, лби_,   ,
  { {0xd774003b,0x8c1a0008,0x248d080c,0x2d80002a}},	//   _والع, נותי, rzem_, zkie_
  { {0x7c240011,0x237800c0,0x248d0eba,0xc049000a}},	//   zuir, örja_, szem_, _רז_
  { {0xa06a0001,0x3d21000b,0x6a96000a,0x0f20000b}},	//   гама_, यलों_, מכתא_, बल्स_
  { {0x442404f9,0xb09a0036,0x645d0134,0x79ba000a}},	//   cum_, утнє_, æsid, רֶיה
  { {0xa0270084,0x644913ec,0x5456000a,0x7d0d007c}},	//   _stöð, mwei, _לסנן_, eaas
  { {0x644900b8,0x2d80005c,0x51f50225,0x0219005e}},	//   lwei, tkie_, _استر, _сіль_
  { {0x7d0d0020,0x752913ed,0xdb05016e,0x7c2413ee}},	//   gaas, ngez, ilhõ, tuir
  { {0x644900b8,0x69c20161,0xf1b3000a,0x2d80044d}},	// [1e20] nwei, vloe, _מסה_, rkie_
  { {0xcb0a0086,0x5f4600a2,0x2d8002ef,0xa01b0030}},	//   ايان_, _اندل, skie_, rzöt
  { {0x7d0d0020,0x644913ef,0x6e3e13f0,0xe8fa13f1}},	//   baas, hwei, _uppb, гле_
  { {0xed5f002c,0x6455003d,0x75290079,0x442413f2}},	//   ážte_, āzij, jgez, yum_
  { {0xa3e7005d,0x7c240dd3,0xccf3000a,0xe80b000b}},	//   _मूल_, quir, _מכר_, _सौदा_
  { {0x64490026,0x31b2006f,0xb7d700c3,0x69c213f3}},	//   dwei, rázy_, مونا_, sloe
  { {0x4424005c,0x7e7a004c,0x4e7a004c,0x64490028}},	//   wum_, טאַז, טאַצ, ewei
  { {0x644900b8,0x9f8400f2,0xba17000a,0x752913f4}},	//   fwei, löä_, _לחלץ_, ggez
  { {0x161a005d,0x7982005c,0xad1b000a,0x8886007e}},	//   _नटवर_, mkow, אופר, _улаж
  { {0xd2140001,0x79820647,0x442413f5,0x4394005e}},	//   омоћ, lkow, rum_, іанс
  { {0xb7d70115,0x3bbb000a,0xd4e6006b,0x442413f6}},	//   _اولا_, רמיד, _люли, sum_
  { {0x79820050,0x44240084,0x656200f2,0xdb1e002d}},	//   nkow, pum_, _unoh, ompó
  { {0x54330086,0xf993000a,0x853b000a,0x7d0d008c}},	//   _فرور, פרש_, _תגדי, vaas
  { {0x1ee7002b,0xc4c50015,0xd5be01ec,0x0000006a}},	//   صوری_, _بتمو, žādo_,
  { {0x7a1c04f9,0x5337000a,0x539b000a,0x877b05bd}},	//   nătă, _לנגן_, _תיוו, נאלי
  { {0xdd94008f,0x63ba13f7,0x32530063,0x71a4049d}},	//   пасы, lotn, _хвър, _најз
  { {0x7982005c,0x2d580a61,0xaae70015,0x6fb50015}},	// [1e30] dkow, щить_, مساو, _ومبا
  { {0x7d0d0020,0x5b1500fd,0x2d9e0140,0xa01b0030}},	//   saas, імет, éter_, szös
  { {0x7d0d00f2,0x644900b8,0x27f800bc,0x7ff4002b}},	//   paas, zwei, _črna_, _وسیا
  { {0xf1c9014e,0x41c9000b,0x4879006b,0x61ea13f8}},	//   रतिन, रतिस, исля_, _mufl
  { {0x63ba13f9,0x18691191,0x7d56000a,0xa3cb000b}},	//   kotn, рали_, _וירד_, लतम_
  { {0x3619005f,0xa09c0053,0xb09c0053,0x7982002a}},	//   ацию_, ניגט, ניגר, akow
  { {0x994d002c,0x75290186,0xff18000a,0x798213fa}},	//   môžu_, tgez, זקות_, bkow
  { {0x0e9c0053,0x644913fb,0x06960015,0x7982002a}},	//   טשול, twei, غنية_, ckow
  { {0x61ea00b8,0xa3e9000d,0xa8180015,0x13e6004a}},	//   _aufl, јдоа_, _هتلر_, омый_
  { {0x290f13fc,0x644913fd,0x1309004a,0x36d50342}},	//   laga_, rwei, шной_, _дозр
  { {0x644913fe,0xd6e80008,0x04f50010,0x59990008}},	//   swei, _הַנָ, _дзею, ֹשָׁ
  { {0x15a8006b,0x290f13ff,0xc5f2004f,0x63a80072}},	//   _лъчи_, naga_, _חדא_, andn
  { {0x2bbe014e,0x43850015,0xafdb00cb,0x63ba1400}},	//   ्तमा, _ولصق, lvøy, botn
  { {0x3e8a0010,0x7982005c,0x79890e18,0xd347002b}},	//   айго_, zkow, _llew, _ایده_
  { {0x7982005c,0xaf99034e,0x290f1401,0xad66006e}},	//   ykow, стях_, kaga_, ياره
  { {0xa3c3005d,0xf652000a,0xa0a61402,0x290f1403}},	//   ्षक_, וצל_, _майд, jaga_
  { {0x0eb6005d,0x9f8400f2,0x8f760033,0x290f1404}},	// [1e40] _आँकड, töä_, _дуні, daga_
  { {0x76411405,0x290f1406,0x7982002a,0x60c40061}},	//   _oply, eaga_, wkow, _iyim
  { {0x79820050,0x7f3b004c,0x798900e7,0x61e4019a}},	//   tkow, _דעיו, _blew, _kiil
  { {0x5f460074,0xd23a0053,0xed5a0f70,0xae57000a}},	//   _انگل, יגעל, _том_, _וסטס_
  { {0x7982005c,0x91720016,0x39461407,0x61e41408}},	//   rkow, iờ_, reos_, _miil
  { {0x7982005c,0x394602c1,0x79890fcd,0x9af60015}},	//   skow, seos_, _elew, _ذكرت
  { {0x394602c1,0x290f0523,0x637f016e,0x7982002a}},	//   peos_, baga_, _gêni, pkow
  { {0x61e400f2,0x63ba06ed,0xd5b00015,0x6d5601f9}},	//   _niil, wotn, عفة_, ndya
  { {0x61ea0011,0x63ba1164,0x236a00d7,0xcb9a000a}},	//   _sufl, totn, ајно_, ֙יִם
  { {0xe72a002b,0xbcfb0030,0x7989002a,0xa78600c3}},	//   _خسرو_, _anél, _zlew, _بشرو
  { {0x32660036,0x63ba1409,0x60cd1116,0xa159140a}},	//   ітов, rotn, _szam, бану_
  { {0x63ba00bd,0x656f00b8,0xe578003d,0x81bd003d}},	//   sotn, öcht, _puķu_, cuēl
  { {0x83f8006b,0x25d70643,0x63ba140b,0x61e4140c}},	//   _уелс_, _וואן_, potn, _diil
  { {0xa2940484,0x60cd00bc,0xbcfb0030,0x9e0700fd}},	//   _налі, _vzam, _enél, жчал
  { {0x290f0035,0x3f83001a,0x61e4140d,0x61f0002a}},	//   yaga_, rkju_, _fiil, ódlą
  { {0xd0110015,0x71f7006e,0x3f830052,0x0000006a}},	//   _كلب_, _بروس_, skju_,
  { {0xe57100b2,0x6ebb005d,0x290f0f38,0x3fa8001a}},	// [1e50] ײַן_, _शुरु, vaga_, ðvuð_
  { {0x7e2b008f,0xddeb0086,0xba740086,0x69c00f28}},	//   _кіма_, _پرده_, ژانت, _akme
  { {0xdced016f,0x8aa7005e,0xfc3f0016,0xdb07001a}},	//   ljač, црад, _axít_, _skjó
  { {0x99810046,0xe81c0065,0xdced0160,0x0000006a}},	//   ruhů_, _निशा_, ojač,
  { {0xa804008f,0x78470015,0x515c000a,0x290f140e}},	//   дзіл, تضام, יכאו, raga_
  { {0x637f016e,0x69c00061,0xa8480015,0x2009140f}},	//   _têni, _ekme, تلهم_, _mwai_
  { {0x6442001c,0xf96b1410,0x91720016,0xaab40015}},	//   _apoi, _край_, hớ_, _قصفت
  { {0xe7950086,0x7641002c,0x04950033,0x64420125}},	//   _کارک, _vply, зроў, _bpoi
  { {0xc952000a,0xdced0085,0xd7f81411,0x0000006a}},	//   _אמן_, jjač, _дух_,
  { {0xe3b10015,0xbb9a000a,0x56670021,0xdced0085}},	//   عرة_, ֶ֑יך, _وداف, djač
  { {0x4b7c00b2,0x61e400f2,0x76410227,0x656f0012}},	//   יאזו, _piil, _uply, öchs
  { {0xe802014e,0x644f0134,0xf656000a,0x7656000a}},	//   रीका_, æcis, _מסעי_, _מבעד_
  { {0xe5c40010,0x7fd60033,0x1168002b,0x61e41412}},	//   _ўсхо, зіві, ملگی_, _viil
  { {0xf7670018,0x2215006b,0x93fa000a,0xe0d7006b}},	//   را_, _ефир, _הלסי, явя_
  { {0x61e4008c,0x63a11413,0x27ed005b,0x0000006a}},	//   _tiil, miln, _luen_,
  { {0xf6520053,0x63a11414,0xdce40085,0x661c02de}},	//   עצן_, liln, njić, _ærke
  { {0x201a0029,0x8b260010,0x27f800bc,0x0c260033}},	// [1e60] _اتبع_, здзе, _črno_, яман
  { {0x645b00f2,0xe7ef000b,0x909b000a,0x63a11415}},	//   ivui, _चढ़ा_, _לספק, niln
  { {0xaac50086,0x3f7b0008,0x0f7b000a,0x8f7b000a}},	//   وتمن, _האיס, _האיב, _הניק
  { {0x290d04f9,0x27ed02c1,0x7e610134,0x657900da}},	//   _ceea_, _buen_, ælpe, _nowh
  { {0xa3cb005d,0xbc19005e,0x4ddb000a,0x7d041416}},	//   लता_, _мірі_, _לחטו, mbis
  { {0x26c50089,0x68ed002c,0x63a100bc,0xbf9b0003}},	//   _bylo_, ľada, jiln, mpêc
  { {0x68ed02d5,0x63a1018c,0x6b630484,0x16370015}},	//   žada, diln, _якра, كسية_
  { {0x442a0010,0xb6080089,0xe944002b,0x63a10012}},	//   бцом_, jišť, _ترسی, eiln
  { {0x2608000b,0xbcfb006f,0xdb050077,0x44f3002b}},	//   _सबकी_, _poéz, cohó, رسيز
  { {0x57fb0008,0x5398005e,0xd7fb000a,0xb8820046}},	//   _ללמו, івня_, _להמל, řísl
  { {0xdb37000a,0xa29401f3,0x9731009a,0x0000006a}},	//   הניח_, фані, _شکوا,
  { {0x6442008c,0xa3e70065,0x7c240160,0x0000006a}},	//   _tpoi, _मूक_, krir,
  { {0x53340080,0xf1b00015,0x7d040085,0x63a11417}},	//   _желт, اءٍ_, dbis, biln
  { {0x44a50015,0x63a11418,0x62811419,0x7d04141a}},	//   _تحمّ, ciln, bylo, ebis
  { {0x433b0008,0xe3b30053,0x733b0008,0xe731000a}},	//   _העוב, _אױס_, _העוס, כֵן_
  { {0x7d040035,0x7c24141b,0x4424141c,0x828b004f}},	//   gbis, frir, orm_, _לְחֶ
  { {0xb6060085,0x7c24141d,0xdfb50054,0x3cb4141e}},	// [1e70] lošć, grir, _обињ, ейтр
  { {0x44240b1b,0x7d0405d0,0x25a00046,0x3b54110c}},	//   irm_, abis, čily_, нкур
  { {0x7c24141f,0xb6060085,0x8f7c000a,0x7d041420}},	//   arir, nošć, _לנזק, bbis
  { {0x99d70015,0x7c870054,0x7c240d29,0x7e08004f}},	//   ستضا, _еуге, brir, _מִשֶ
  { {0x27ed0092,0xf7950010,0xdb1c1421,0x98c70015}},	//   _quen_, мадэ, _chró, أغان
  { {0xf7940010,0xf77100a2,0x777a0251,0xdb23008c}},	//   начэ, ضات_, _cotx, äräa
  { {0x63a11422,0x7d0f0030,0x45d50190,0x44241423}},	//   viln, _kecs, мцит, erm_
  { {0x49750010,0x63a1005c,0x27ed00f2,0xdb050144}},	//   _ўлас, wiln, _tuen_, cohò
  { {0x97250015,0x69c30003,0xe4560033,0x3dc902f2}},	//   _يفرو, îneu, джы_, ilaw_
  { {0x1b7a0053,0x7d0400b8,0x7d0f00dc,0x33990015}},	//   ַטרע, zbis, _lecs, تخبة_
  { {0xcb120008,0x3ce6002c,0x63a11424,0x28d9000b}},	//   כלי_, ľovi_, riln, बेरि
  { {0x7c240084,0xa0a60054,0x6452008c,0x10a603de}},	//   yrir, дамд, äjiä, димн
  { {0xbcfb002c,0xc916000a,0xe4cb0015,0x63a11425}},	//   _inéh, וחרת_, _ابان_, piln
  { {0x7df50007,0x3f8c0264,0x7c241426,0xf8ab00a1}},	//   _sąsa, ódu_, vrir, _đời_
  { {0x7d0f0014,0x25ad0134,0x12fa000a,0xb222001a}},	//   _becs, onel_, _והצב, þætt
  { {0x3cf5014e,0x25ad0220,0x25bf084a,0x61fc0030}},	//   एँगे_, nnel_, noul_, írle
  { {0x7d0400b6,0xa01b00f2,0x070d000b,0xdca31427}},	// [1e80] rbis, lyön, हराव_, вати
  { {0x1c39004a,0x60c00012,0x7c241428,0x7d041429}},	//   яясь_, ümmu, rrir, sbis
  { {0x3dc90026,0x68ed006f,0x41b3002b,0x7d0f01d3}},	//   blaw_, ľadn, _سمیر, _fecs
  { {0xdb1c002d,0xda6500e6,0xd00f002b,0x7c24142a}},	//   _phró, عالي, _حلی_, prir
  { {0xb8f6014e,0xd7ef0029,0x0000006a,0x0000006a}},	//   _हर_, لكن_,   ,
  { {0xa6340036,0x4b55006b,0x25ad0061,0xa01b007f}},	//   енкі, _пъст, enel_, kyön
  { {0x9f8d002e,0x97c50015,0x5ee9000a,0x0000006a}},	//   nþá_, رتهم, הַפְ,
  { {0xba9b000a,0x2b580030,0xa53408b0,0xb6060085}},	//   _וסלי, _harc_, хнич, vošć
  { {0x9326002b,0x31b9006f,0x6b730535,0x0000006a}},	//   وردن, cézy_, _węgł,
  { {0x42740080,0xa87b0008,0xb6060085,0x81bd003d}},	//   егос, _ואמר, tošć, grēn
  { {0xa1590054,0xe2140033,0x51f802a3,0x3218142b}},	//   пану_, эмны, янню_, éry_
  { {0xc4860191,0x21670036,0x5a170053,0x546a0010}},	//   _олек, фтог, וקטן_, _маем_
  { {0xf5770029,0x1074007a,0xc058022a,0xa3e7000b}},	//   _تمنع_, вляю, мір_, _मंच_
  { {0x0efb014e,0xbefb000b,0x88060065,0x42560058}},	//   ्रेस_, ्रेन_, सीएफ़_, _ينشر
  { {0x7d0f0030,0x52730015,0x3dc9055e,0xfebb002b}},	//   _pecs, _لايز, tlaw_, زاست_
  { {0xcdd80001,0xa5d805bd,0xe287009a,0x0000006a}},	//   дњу_, לַּי, _تطهی,
  { {0x2b580034,0x7d020077,0x60c00012,0x5c990138}},	// [1e90] _barc_, ñosa, ümmt, чкая_
  { {0x2bb80015,0x1a8b0015,0xcaa70015,0x5ffc000a}},	//   والة_, يضاً_, وصاي, _והזה
  { {0x7d0f1349,0xb50e000b,0xe9e90058,0x2019142c}},	//   _tecs, सराय_, أفصى_, lssi_
  { {0x68ed002c,0x7d1d0012,0x645c003d,0xdcef003d}},	//   ľado, _udss, ārij, ādēt
  { {0x6cfa0008,0x68ed04af,0x20190604,0xd9160067}},	//   _מפרס, žado, nssi_, ريوش_
  { {0x237c0b28,0x0000006a,0x0000006a,0x0000006a}},	//   _novj_,   ,   ,
  { {0x2bbe005d,0xcf940053,0x199504ab,0x7c2d142d}},	//   ्तरा, כטס_, _завя, luar
  { {0xc867006b,0x6d4d142e,0x0000006a,0x0000006a}},	//   _отзи, neaa,   ,
  { {0x73e5006b,0x7c2d142f,0x25ad02ff,0x25bf0045}},	//   ноиз, nuar, rnel_, roul_
  { {0xe2990001,0x69cb1430,0x182a002b,0x6d4d007c}},	//   зао_, llge, _رقمی_, heaa
  { {0x2019002e,0x6d4d00f2,0x7c2d1431,0x69cb00fc}},	//   essi_, keaa, huar, olge
  { {0x865a000a,0xa3cf000b,0xf652000a,0xe56e0033}},	//   _מדעי, _वीर_, _תצא_, _ёз_
  { {0xbcfb002d,0x656b04ed,0x5576000a,0x1fb60004}},	//   _gnéi, _ingh, _רענן_, есвр
  { {0x69cb00b8,0x7c2d1432,0x6fd50033,0x889a000a}},	//   hlge, duar, вісц, לברי
  { {0x3c430024,0x1eaa0015,0x442d1433,0x20191434}},	//   hīvā_, ساسي_, lue_, assi_
  { {0x52740029,0x7c2d002d,0x29e80061,0x0efb000b}},	//   _جاهز, fuar, _aşan_, ्रॉस_
  { {0x6aa8005d,0x442d0493,0x4339000a,0x7c2d1435}},	// [1ea0] कप्र, nue_, ּעֲב, guar
  { {0x3a060086,0xe0d70010,0xa3c1000b,0x69cb1436}},	//   فکری_, _явы_, ूति_, elge
  { {0x115a000a,0x63760045,0xa9260df0,0x5eeb000a}},	//   ּדְע, _pânz, едел, _מַכְ
  { {0xb17b00c0,0x442d1437,0xbe49002b,0x6d4d0079}},	//   rmåg, kue_, _کشیم_, ceaa
  { {0x637604f9,0xd1170008,0xd90d0086,0x442d003f}},	//   _vânz, תקנה_, زیل_, jue_
  { {0x656b0176,0x501b0008,0xdb07002e,0x7d161438}},	//   _angh, לונו, _skjö, lays
  { {0x442d1439,0x3ce6006f,0xca7a002b,0xa785002b}},	//   eue_, ľovu_, _عمرش_, خشنو
  { {0xfa890010,0x89da0015,0x09e3143a,0x0000006a}},	//   _ўсёй_, _روذر_, _босн,
  { {0x98af0091,0x349401b0,0x442d143b,0x6e2e06a8}},	//   degė_, тапр, gue_, hubb
  { {0x656b0026,0x96960877,0x51f80342,0xdc9b000a}},	//   _engh, _преш, мною_, פסיכ
  { {0xeb970008,0x9473002b,0xbcfb0003,0x7bde0045}},	//   גדיר_, ندیا, _inév, impu
  { {0x7c2d01c2,0x442d143c,0x9c870046,0x6e2e143d}},	//   yuar, bue_, ničí, dubb
  { {0x20190152,0xf1a40010,0xe82a0008,0xe3af002b}},	//   ussi_, урэн, הוָֽ, شری_
  { {0xa3cb000b,0xf1f7002b,0x20190bb5,0xccf90535}},	//   लतः_, بعیت_, rssi_, _żś_
  { {0x6f1500bd,0x656b0026,0x2e480142,0x71f70015}},	//   razc, _yngh, нято_, _كريس_
  { {0x40950029,0x7bde0509,0x99810046,0xdb0e0030}},	//   _للبر, empu, vrhů_, _okbó
  { {0xb81c000b,0x6d4d143e,0xac9400ce,0xab87009b}},	// [1eb0] _निगम_, reaa, гатш, нужк
  { {0xb17b0134,0x6d4d143f,0x69cb0079,0x3df51440}},	//   småd, seaa, wlge, _изос
  { {0x49390010,0x59390010,0x6d4d1441,0x7c2d1442}},	//   дзею_, дзеў_, peaa, suar
  { {0x4ac40029,0x3c430024,0x69cb007c,0xa91d00bc}},	//   ديمق, tīvā_, ulge, _možg
  { {0xe10c00b2,0xdee70086,0x89340015,0x7c2d1443}},	//   פּאָ, _تأکي, اعما, quar
  { {0x9be40010,0xa3cf005d,0xa2c1000b,0x58b80015}},	//   _біск, _वीं_, रॅड्, رانج_
  { {0xead40080,0x9732002b,0xcb12000a,0xcf58000a}},	//   _борь, شکلا, _כלם_, גבות_
  { {0x68fb0034,0xa01b008c,0x442d1444,0x9c87006f}},	//   _ufud, työl, tue_, cičí
  { {0xe432003b,0x0000006a,0x0000006a,0x0000006a}},	//   لفيد,   ,   ,
  { {0x8235002b,0xe71900c3,0x394f1445,0x2d9e0003}},	//   پردا, _آيات_, legs_, étez_
  { {0xbb3c0053,0x36750029,0xfbd20008,0x442d106a}},	//   לעזי, _جهاز, שתי_, sue_
  { {0xe4d90029,0xdb1e1446,0x656b0824,0x0f0a000b}},	//   _قوات_, ropé, _ungh, वर्स_
  { {0x442d1447,0x80d9005e,0x7bde1448,0x0000006a}},	//   que_, еєру_, ympu,
  { {0x6e2e1449,0xdb1c005a,0x0000006a,0x0000006a}},	//   tubb, _okrá,   ,
  { {0x6da60e91,0x62640015,0x7d020077,0x5cf60138}},	//   вива, _مايق, ñoso, вязу
  { {0x3205003e,0x12e80135,0xedc70015,0x3236000a}},	//   mply_, _אַפּ, نِّي_, _סטפן_
  { {0xa91d010b,0x2bf60080,0x5f060063,0x7fda0004}},	// [1ec0] _možd, тябр, _изпа, _офот_
  { {0xaf0a0029,0x6e2e04ed,0x7d160035,0x7e9a0029}},	//   _تقدم_, pubb, says, _ينظر_
  { {0xfeba0015,0xdee603ae,0x0000006a,0x0000006a}},	//   _زادت_, _јони,   ,
  { {0x9975004a,0x637e0046,0xdd050045,0x984a005e}},	//   лучш, _záně, ăsăr, дяка_
  { {0x81bd0024,0xe995002b,0xd7f00058,0xc7ba0138}},	//   frēj, دهنگ, حكت_, мёк_
  { {0xe7180015,0xc66a004a,0xb7d700c3,0xa09b000a}},	//   ريبت_, дшие_, نونا_, וינט
  { {0x98b201e2,0x092a0015,0xcf93000a,0x7d7c000a}},	//   ıyı_, _يسري_, שטו_, ּנ֖ו
  { {0xceb30008,0xd6d9005e,0xaa57002b,0x0466144a}},	//   ייו_, хті_, _جلفا_, втом
  { {0xdb1c0089,0x3205144b,0xa01b005b,0x0000006a}},	//   _zkrá, eply_, työm,
  { {0x32540432,0xe3af0015,0x98750061,0xa91d00bc}},	//   гвор, ْرَ_, lüğe_, _požg
  { {0xc56a0029,0xd6250015,0xc5f6009b,0x66e60766}},	//   _يحصل_, _معني, _рязъ, _рожа
  { {0xfbdf0026,0x316d1279,0x28d9000b,0x75380535}},	//   _apêl_, ñez_, बेकि, óczę
  { {0x90540010,0x60d6002a,0xf206000b,0x71a40033}},	//   авяц, _czym, वीज़_, раўз
  { {0x547b013a,0x9e35056d,0x8233002b,0x3266005e}},	//   _קטגו, легч, دریا, _атив
  { {0x63a8144c,0xdb060046,0xdd950033,0x2bec000b}},	//   midn, ámýc, гавы, _अंजू_
  { {0xf2d30053,0x7bc7144d,0x865b000a,0xa91d0046}},	//   _דעצ_, _skju, ודלי, _kože
  { {0xdb1c0084,0xfbd9023e,0xfaff0024,0xa91d07c4}},	// [1ed0] _skrá, едај_, žīms_, _jože
  { {0xa91d010b,0x8f550191,0xfecb0029,0xe4ab000a}},	//   _može, _свої, _يبدو_, וֹבָ
  { {0x7ac4119f,0x7522122c,0x61ed0eca,0xdb05001a}},	//   асце, _odoz, _kial, nihé
  { {0x629a00dc,0xeb9f02de,0xafdb02de,0xaa6401f3}},	//   izto, _stød_, stød, штук
  { {0xc19c0008,0x61ed003f,0x81bd0024,0x23b4000b}},	//   ושאי, _mial, trēj, ुवाद
  { {0x752202b9,0x89fb0015,0x47c401f3,0xab84013e}},	//   _adoz, _يعزز_, абів, _куск
  { {0x6d5d025c,0x27ec003e,0x3f810089,0x86980063}},	//   _kasa, _didn_, _mohu_, ктът_
  { {0x7bc5003f,0x63a8144e,0x62880e63,0xe459144f}},	//   lohu, eidn, dydo, ежи_
  { {0x629a0024,0x6d5d1450,0x60cd1451,0x0000006a}},	//   ezto, _masa, _nyam,
  { {0x2bd9005d,0x60d6005c,0x6d5d1452,0x490b000b}},	//   _बीमा, _rzym, _lasa, ारको_
  { {0x16380015,0x60d6002a,0xe207002a,0x42541453}},	//   _لسنة_, _szym, _ogół_, атят
  { {0x74b9000d,0x61ed002d,0x320500da,0x6d5d1454}},	//   _пулс_, _cial, rply_, _nasa
  { {0x343900b2,0x7bc50020,0xc9520008,0xb0de000b}},	//   _נײַע, kohu, צמך_, नेंग
  { {0x443f0048,0x947404c9,0x32051455,0xe47a000a}},	//   mtu_, _خدما, pply_, _רָאש
  { {0x443f07e8,0xa2ca005d,0x6288005c,0x629a005c}},	//   ltu_, _सुप्, cydo, czto
  { {0x2d95008f,0x61ed04ed,0x5de61456,0x6d5d00be}},	//   арус, _gial, ужба, _casa
  { {0x2004002d,0x6d5d0849,0x4fb60015,0x443f1457}},	// [1ee0] ímid_, _dasa, _مصدر, ntu_
  { {0x28b7005d,0x7980003f,0xa09b00a3,0x443f1458}},	//   _आख़ि, _somw, _נייט, itu_
  { {0x443f0005,0x092a0080,0x69db002d,0x657b007c}},	//   htu_, ежей_, _bhue, kjuh
  { {0x7d560036,0x644b1459,0xa9c501f3,0x8d56145a}},	//   _стої, _opgi, асік, _сточ
  { {0x657b0020,0xa2ca005d,0x443f06cf,0x8eb3002b}},	//   djuh, _सुन्, jtu_, _نمیش
  { {0xcb760001,0x6d5d145b,0xdb1c145c,0x35f7002b}},	//   _сумњ, _zasa, _skræ, گرود_
  { {0x6d5d01e2,0xbb3b0053,0xa01b00f2,0x569402c8}},	//   _yasa, _רעלי, työk, райт
  { {0x7df50780,0x77920086,0xda4b000a,0x2d82055e}},	//   _sąsk, _گیتا, _אֲמָ, _joke_
  { {0x61ed002f,0x443f0024,0xc50a0086,0x97360087}},	//   _rial, gtu_, وتکل_, _معاص
  { {0xb8930029,0xf20607de,0xdb1e0227,0x61ed145d}},	//   _الكع, лямо, kopí, _sial
  { {0x61ed0375,0xf3630256,0x60cd0375,0xa175008b}},	//   _pial, стын, _syam, агні
  { {0x7bc5000c,0x62880026,0x443f0049,0x7df5002a}},	//   zohu, rydo, btu_, _wąsk
  { {0x7bc5000c,0x629a145e,0x14390086,0xa3cf000b}},	//   yohu, szto, _لينک_, _वीक_
  { {0xd3700029,0x60cd003f,0x98a9005c,0x225802de}},	//   _ذهب_, _vyam, żać_, ærks_
  { {0xcddb0431,0x12fb000a,0x02fb000a,0x6d5d145f}},	//   ења_, _אהוב, _אלומ, _pasa
  { {0x2d5805cb,0x5d55000d,0x3cb5006b,0x7ae10f9c}},	//   лись_, јкат, айбр, _últi
  { {0x7bdc002f,0x6560002d,0xdb070247,0x6d5d1460}},	// [1ef0] _bhru, idmh, šmír, _vasa
  { {0x7bdc002f,0xa01b00f2,0x6d5d0cf9,0x39b10007}},	//   _chru, vyöh, _wasa, mąsi_
  { {0x6440007c,0x443f002a,0x19590033,0xaa550925}},	//   htmi, ztu_, кажы_, рвеш
  { {0x25fb005d,0x4237004c,0x7bc5007c,0x9f600030}},	//   _लंबी_, רנאל_, sohu, örös_
  { {0x998700dc,0xb8fd005d,0x443f0156,0xe8f802e1}},	//   énő_, _डर_, xtu_, улі_
  { {0x16390029,0x8ae702e5,0x6605000d,0xd702005e}},	//   نسبة_, _бібл, апка, озши
  { {0x66240029,0x96750010,0x2d820705,0xdb051461}},	//   مريك, рылі, _yoke_, rnhä
  { {0x7c2d04ed,0xd6ce0029,0x443f1462,0xd5b100e6}},	//   orar, بقى_, ttu_, تفع_
  { {0x9984003b,0x765a1463,0xf992000a,0xed600046}},	//   _القو, _esty, _ורן_, ážit_
  { {0x47340086,0x657b0e95,0xc245000d,0x395f1464}},	//   _هرمز, sjuh, анок, _haus_
  { {0x7d0d00c0,0xe2b50010,0xa229006b,0x6d44028a}},	//   kbas, рспэ, ъжна_, yfia
  { {0x9f490084,0x7c2d1465,0x7df5002a,0x41b30015}},	//   _stað_, krar, _gąsi, ْمَر
  { {0x95c40086,0x6459003f,0x2d8200bc,0x644e0045}},	//   _اينه, _uswi, _roke_, ăbic
  { {0x765a0176,0x23290036,0xc7b20053,0x20040024}},	//   _ysty, _роки_, ַבן_, īmi_
  { {0x442d0014,0xc332004c,0x91fc003d,0xdee61466}},	//   lre_, _ווו_, lvān, рови
  { {0x442d1467,0xb2ba0447,0x7bdc00da,0x7d0d09cf}},	//   ore_, _במצר, _shru, gbas
  { {0x6fd60210,0xed570004,0x6db70085,0x6d441468}},	// [1f00] _вінц, шот_, pćan, rfia
  { {0x8b260036,0xdb23002e,0x442d1469,0x25a90046}},	//   рдже, ærða, ire_, čaly_
  { {0x442d018b,0x2d9e0152,0x49060015,0x29e80061}},	//   hre_, ètes_, لواق, _uşak_
  { {0xdb1c00c0,0x3ebb000a,0x8dfb000a,0x7c2d146a}},	//   _skrä, _יציב, _שהכת, brar
  { {0x442d0134,0xed570063,0x7bdc111f,0x7c2d146b}},	//   jre_, _тоя_, _thru, crar
  { {0x7df51256,0xaa060087,0xa50e000b,0x442d0cbb}},	//   _sąsi, _نظره, सर्च_, dre_
  { {0x6603000d,0x6753002b,0x09e60342,0x1e96000a}},	//   опја, زخور, _вовн, יכַל_
  { {0x395f0007,0xda5b000a,0x6f1c146c,0x1d16000a}},	//   _gaus_, _בכלל, harc, ׁקֶר_
  { {0xd3700015,0x765a002a,0x442d146d,0x9f8d001a}},	//   كهة_, _wsty, gre_, rþú_
  { {0x883b013a,0x46a6010f,0x9378000d,0x6440146e}},	//   _בתמו, _казв, убот_, rtmi
  { {0xd257017f,0x6440146f,0xaf37002b,0x442d1470}},	//   аця_, stmi, یرست, are_
  { {0xa50a061e,0x0446017a,0x442d1471,0x7d0d0012}},	//   _реда_, _ведн, bre_, xbas
  { {0xdcef0048,0x9f84002e,0x6f1c0026,0x98b30024}},	//   ādīt, töð_, farc, _ādīt_
  { {0x7c2d1472,0x6304002b,0x6f1c1473,0xe4510c44}},	//   vrar, _اوغل, garc, _זֶה_
  { {0x63bd00dc,0xfda70054,0xa311006f,0x9f84001a}},	//   ésne, ајам, äčšo, röð_
  { {0x527b0008,0xf27b05af,0xb11503de,0x20040144}},	//   _ינוא, _ירוש, _умиш, ímic_
  { {0xdce600df,0x5ce70036,0x91bc0008,0x2d58007a}},	// [1f10] _mokė, рюва, _שמחי, шить_
  { {0xea670001,0x09bf000b,0xd9bf000b,0x388e003d}},	//   ињен, एक्य, एक्ट, _mērā_
  { {0x442d1474,0x38660012,0x200b00bc,0x41bb000b}},	//   zre_, evor_, lpci_, _उदास
  { {0x442d1475,0xa91d044c,0x7c2d1476,0x75e701d3}},	//   yre_, _boža, prar, _tűzi
  { {0x4dda0008,0x67d5000d,0x5ea4002b,0x9f40030b}},	//   _תחרו, боду, _همیل, _guió_
  { {0xd8740074,0x67470010,0x442d1477,0x2058004c}},	//   تامب, рэдз, vre_, יידל_
  { {0x3618008f,0xaa950029,0xa6c90139,0x06090054}},	//   ацыю_, _الأث, ылка_, ћник_
  { {0xdeb8000a,0x0562006b,0x442d1478,0xceb8004f}},	//   יפוח_, звън, tre_, יפוק_
  { {0x291d00b6,0x3160001c,0x442d1479,0x4990002b}},	//   mawa_, _raiz_, ure_, _زیور
  { {0x316000d9,0x291d13bf,0x442d147a,0x0000006a}},	//   _saiz_, lawa_, rre_,
  { {0x442d0014,0xe6b3002b,0x5999000a,0xa91d147b}},	//   sre_, _بلاگ, ָשָׁ, _zoža
  { {0x291d147c,0x568c0053,0xcf89000f,0x6f1c10ec}},	//   nawa_, _שטאַ, _אט_, warc
  { {0xa4d40036,0xafe6005e,0xe8d5000a,0x6f1c147d}},	//   _доці, йомл, מוֹר_, tarc
  { {0x291d00d9,0xdb1e013f,0xb17b0f94,0xafe601d2}},	//   hawa_, kopá, lmål, согл
  { {0xc7d60008,0x291d147e,0x531a0643,0x7643002a}},	//   מושי_, kawa_, _עוקצ, ntny
  { {0x6dac0061,0x3d12000b,0xada301b0,0x6da3147f}},	//   aşan, ़रें_, пасл, писа
  { {0xdd8f0029,0x291d1480,0x6f1c1481,0xc19b000a}},	// [1f20] روك_, dawa_, parc, _תשפי
  { {0xc910000b,0xa3dd000b,0xc4d20643,0x6dac0045}},	//   ार्म_, _थीम_, לגן_, cşan
  { {0xdb070014,0xa96a0124,0xfaaa002b,0xa92a0033}},	//   ámár, лижа_, دهاي_, гіле_
  { {0x38cb0086,0xa91d0156,0x291d0fd1,0x91f6000a}},	//   گامی_, _poža, gawa_, צמנו_
  { {0x53c7014e,0x25ad002c,0x7643002a,0x38660012}},	//   रकाश, diel_, etny, uvor_
  { {0x38cb0086,0x18530010,0x9b960029,0xbb860029}},	//   دامی_, явіў, _الست, _الآي
  { {0x25ad0384,0x8d5a000a,0x1a78000a,0x291d1482}},	//   fiel_, ָכִי, _דְּמ, bawa_
  { {0xe5c60001,0x25ad002a,0x05760015,0x2d8000aa}},	//   љско, giel_, صاعد, njie_
  { {0x76430273,0x29d30015,0x03f80054,0x79ab000a}},	//   atny, _ريكس, јној_, _עֹלַ
  { {0x388e0048,0x5c5b0632,0x61e60079,0x442a00bc}},	//   _vērā_, נדיק, emkl, čb_
  { {0x3f85002e,0x21790010,0x4b7b0053,0xcb130008}},	//   ölum_, айны_, אטיג, הלת_
  { {0x3d12000b,0xf09f0144,0x7df50091,0xf484002b}},	//   ़रों_, tzà_, _mąst, _واشی
  { {0x7df50007,0x23e6042b,0x200b1483,0xe4d60067}},	//   _ląst, _лікв, upci_, _اتاب
  { {0xa294008f,0xdbf10089,0x291d1484,0x92940254}},	//   _малі, _příl, zawa_, _малц
  { {0x02430015,0xc7b3000a,0x6d8a001a,0x6e940ac9}},	//   _فَوَ, לבש_, _nýas, пиру
  { {0x81bd003d,0x0000006a,0x0000006a,0x0000006a}},	//   grēt,   ,   ,
  { {0x4dd40015,0x75e70030,0x539a004f,0x7dd3007f}},	// [1f30] ستفس, _tűzv, ְי֣ו, nçsi
  { {0x81bd0024,0xdea40086,0xd879002b,0x7a050091}},	//   arēt, _کیفی, یمات_, _lėte
  { {0x9f840020,0xdab900e6,0xcae3000b,0xda080015}},	//   töö_, جهات_, केंड_, ميله_
  { {0x8f550086,0xbae40015,0xd7f10016,0x6ab9000b}},	//   _انگش, سكني, _sĩ_, _आशीर
  { {0xf7700074,0xc9740029,0x291d1485,0xa2ca000b}},	//   کان_, ثالث, rawa_, _सुस्
  { {0xcc76000a,0x501c000a,0x25ad06a8,0x291d1486}},	//   _ועשה_, רוגו, wiel_, sawa_
  { {0x19950010,0xfbd2000a,0xda09000a,0xd7f10016}},	//   _давя, _חתם_, _כִּ֚, _vĩ_
  { {0x91fc0024,0x8429005e,0x6fd202de,0x200901c2}},	//   rvāl, ажив_, ræci, _otai_
  { {0xad1c000a,0x04560015,0x25ad1487,0x76431488}},	//   אוחר, قلية_, riel_, stny
  { {0xe3b10015,0x42251489,0xb17b02cd,0xe795002b}},	//   ظرة_, одов, smål, _بارک
  { {0x09b500b2,0xf4860086,0x25ad148a,0x36040015}},	//   ַפֿט_, مایی, piel_, _فولف
  { {0xe3b80061,0x6a3a000a,0x69cb148b,0x0000006a}},	//   anı_, סגרפ, noge,
  { {0x69cb0026,0x6d5600da,0xb5c8009a,0x61e6148c}},	//   ioge, veya, _اونم_, rmkl
  { {0xaab9005d,0xe3b30021,0x69cb148d,0xa856004f}},	//   _आशंक, _عرش_, hoge, חישה_
  { {0x59c9014e,0x2d8000dd,0xf7720008,0xe819000b}},	//   िकार, tjie_, וקם_, नीता_
  { {0x753b000c,0xed460033,0xa01b008c,0xe62700a1}},	//   nguz, ўнап, työt, _đổ_
  { {0x80e60015,0x81bd003d,0x2bb0002a,0x8c430499}},	// [1f40] _بأغل, arēs, eńca_, мете
  { {0x2d99148e,0xeab20015,0x6d560003,0xab2a02bb}},	//   _else_, وعا_, seya, рожа_
  { {0xe8fa148f,0xa01b008c,0x539a000a,0x386d00cb}},	//   але_, syöt, סיעו, _arer_
  { {0xfd120029,0xcd36002b,0x69cb1490,0x6edb004f}},	//   _تجد_, _بردب, goge, _כחיפ
  { {0xe3b80064,0x7791002b,0x7d041491,0x97c6030c}},	//   ynı_, کیلا, mcis, ойде
  { {0x7c241492,0x7d041493,0xf093000a,0x262a03ae}},	//   msir, lcis, ונד_, ацио_
  { {0x07a3000d,0x41ca005d,0xbf9b0003,0x8f7b000a}},	//   ќајн, रवास, mpêt, ינסק
  { {0x69cb1494,0x38aa002a,0x342603ae,0x7d041495}},	//   coge, tórą_, офов, ncis
  { {0xdb1e0134,0xb866002b,0x7c241496,0xf7560058}},	//   ropæ, _بازو, nsir, _ونرج
  { {0xa3e70001,0x77920086,0xbb3a000a,0x66760021}},	//   одња_, _زیبا, ׁעִי, _ودار
  { {0x8afb1077,0x6b83002e,0x20090824,0x5b57000a}},	//   יליז, öngi, _stai_, חייב_
  { {0xa194022a,0x9633042b,0x7c241497,0x61f70033}},	//   даюч, _ініц, ksir, ўняў_
  { {0xa2ca014e,0xd5e90015,0x2bbf000b,0xd1300015}},	//   _सुर्, _اعلن_, ्वमा, ضمّ_
  { {0xc0580191,0x09b7005d,0x69cb00b8,0xe4e90067}},	//   цію_, _अद्य, zoge, _طعنه_
  { {0xdef40010,0x8d7700e6,0xf3c90029,0x11d70015}},	//   дпры, يارا, _ابنه_, _وتعد
  { {0x7c241498,0x212900e8,0x329b000a,0xe29b000a}},	//   fsir, _udah_, _כבוד, _כשור
  { {0xe5710008,0xdfdb006b,0x7dda0144,0xdb1e008c}},	// [1f50] עַל_, _вън_, aïso, kopä
  { {0x63ba00b8,0x78a2002c,0x7982002a,0xdfab0067}},	//   nntn, dzov, ejow, _خطبه_
  { {0x7c2400df,0x6b51001a,0x69cb1499,0xb955004a}},	//   asir, _aðgæ, toge, звещ
  { {0x4426052c,0xc27b000a,0x7d04149a,0x91fc01ec}},	//   _ovo_, ירבי, ccis, evāk
  { {0x6c790053,0x5d7a000a,0xdb1e007c,0x7d7a000a}},	//   _האָפ, _הארק, fopä, _הנרו
  { {0xbdf80086,0xfc16000a,0xf7940033,0xe7a8005e}},	//   _دریا_, _מקשי_, мачэ, овіл_
  { {0xa2ca000b,0xff18000a,0x29dc0077,0x4426149b}},	//   _सुल्, חקות_, mían_, _avo_
  { {0x7982005c,0x29dc0077,0x386d00cb,0xdebc000a}},	//   cjow, lían_, _trer_, ימול
  { {0x93790029,0xe3b10115,0x7d1d0fb7,0x7d010030}},	//   مصدر_, فرد_, _mess, _záró
  { {0xf8ae0086,0x29dc02c1,0x79890161,0xcc76000a}},	//   _حکم_, nían_, _hoew, פעתה_
  { {0x03220010,0x7d04005c,0xe664004a,0x4426149c}},	//   эдэн, ycis, _отцо, _evo_
  { {0xe6100086,0x7d1d149d,0xc19a005e,0x7c24005b}},	//   _ششم_, _ness, стої_, ysir
  { {0xb4fa0008,0x764b0007,0x34fa000a,0x92b5002b}},	//   _הפני, žnyč, _ההנד, تحکا
  { {0x6dac0061,0x0ef90033,0x8f750033,0x7989149e}},	//   rşam, жэты_, мусі, _loew
  { {0xf7720053,0x29dc02c1,0x2d9602bf,0x7d1d149f}},	//   עקל_, dían_, прас, _bess
  { {0xb8830d05,0x91e30063,0x7c240205,0xa5c6001a}},	//   _klíč, _поще, tsir, mkóð
  { {0xe3190092,0xeafa00e6,0x113b000a,0x7d0414a0}},	// [1f60] _điể, مرات_, _התפל, rcis
  { {0x7d0404a0,0xa01b008c,0xdbf10046,0x29dc0077}},	//   scis, pyör, _přál, gían_
  { {0x4efb0008,0xc3320008,0xafdb0134,0x61e414a1}},	//   _להיו, תוב_, ktøj, _khil
  { {0xfbc90008,0xe9d20015,0x7d010030,0x7c2414a2}},	//   את_, رغا_, _váró, psir
  { {0x29dc02c1,0x61e40125,0xdb1e008c,0xafdb01d0}},	//   bían_, _mhil, topä, dtøj
  { {0x29dc02c1,0x60d600f2,0xc7a314a3,0x07a314a4}},	//   cían_, _myym, ничк, начн
  { {0x4e7a00b2,0x44260084,0xdb1e14a5,0xa3c1000b}},	//   מאַצ, _svo_, ropä, ्कन_
  { {0x2abb0008,0x798900aa,0xcad7000a,0x7abb000a}},	//   _המלא, _goew, _זולת_, _הצלו
  { {0xa5070001,0x86c6002b,0x18a3004a,0x85b70015}},	//   чења_, _کيان, _затм, ثاوس_
  { {0xe44f003b,0x389b0008,0x889b000a,0x6f1e0085}},	//   اضي_, _הימנ, _השמצ, _nepc
  { {0xc444002b,0x7dda0079,0x2bbf0065,0xd57600ce}},	//   سیژن_, eïsm, ्वता, _нудь
  { {0x867b0008,0xd6eb0008,0x4426002e,0xd5fb0008}},	//   _לרבו, _הַדָ, _tvo_, _הפאר
  { {0xa91d0263,0x6ab9000b,0x6d98001a,0xf44001f3}},	//   _božj, _आश्र, _pían, _ролi_
  { {0x64470045,0x7a050091,0x7d1d14a6,0xa91d14a7}},	//   ăjit, _lėta, _sess, _rožm
  { {0x7d1d14a8,0xd3e50086,0x61e4002d,0x29dc02c1}},	//   _pess, _تقوی, _fhil, vían_
  { {0x61e40011,0xb2bb000a,0xfd130015,0xa2bb000a}},	//   _ghil, _למור, عجز_, _למוט
  { {0x6ecd005d,0x7d1d14a9,0xa3d0000b,0x29dc0077}},	// [1f70] _दुरु, _vess, वकप_, tían_
  { {0xa3cc000b,0x7e6102de,0x798914aa,0x7d1d14ab}},	//   लवि_, ælps, _soew, _wess
  { {0x29dc02c1,0xbb840029,0xecf90484,0x7d1d14ac}},	//   rían_, علمي, _менш_, _tess
  { {0x6f1e002a,0xbcfb0030,0x29dc0052,0x0000006a}},	//   _zepc, _lnéz, sían_,
  { {0xa3cc0065,0x0000006a,0x0000006a,0x0000006a}},	//   लवा_,   ,   ,
  { {0xccf2000a,0x35d5000b,0xbc7a000a,0xf77300c3}},	//   _שכך_, _डीज़, _ונשת, عاش_
  { {0xc7c80010,0x6b83002e,0x79890111,0x99d70015}},	//   чыце_, öngu, _toew, _فترا
  { {0x24090080,0x6d4d064e,0x75d50015,0xa2ad000b}},	//   онии_, nfaa, بيعا, ुपस्
  { {0x2900002c,0x25aa002b,0xafdb02de,0xa8340054}},	//   žiac_, تضوی_, rtøj, _петљ
  { {0xdc88000a,0x57b4005e,0x9f530003,0x69d914ad}},	//   לְתָ, _збут, _fixé_, llwe
  { {0x6723065d,0x61e4010c,0x6f1e00bc,0x95cb0763}},	//   manj, _phil, _repc, _луда_
  { {0xa5c60084,0x3d17000b,0x24550015,0x27ff008c}},	//   rkóð, तरों_, _يناس, _kuun_
  { {0xa5c6002e,0xfbbf000b,0x21a3004a,0x27ff007c}},	//   skóð, ्वाम, тиям, _juun_
  { {0x61e4003e,0x82350086,0x98b2005c,0x27ff00f2}},	//   _whil, _قربا, żyć_, _muun_
  { {0x644914ae,0xa01b005b,0x0000006a,0x0000006a}},	//   ltei, syöp,   ,
  { {0xf2d2103d,0x64490024,0x672314af,0x656914b0}},	//   _שעה_, otei, hanj, ndeh
  { {0x6723116e,0xab660010,0xbfc60661,0x1c460010}},	// [1f80] kanj, мвал, _обик, ьнам
  { {0x672314b1,0xd9b8005d,0x8fa6002b,0x7ed600c3}},	//   janj, ेक्ट, _آمده, _يزدا
  { {0x64490c8d,0x236700bd,0x67230a00,0x8f7b000a}},	//   htei, _manj_, danj, _וניק
  { {0x3a3a0f3a,0xaae50018,0xdcfd002a,0x644914b2}},	//   rupp_, رسلو, _posą, ktei
  { {0x26030467,0xdb0e0084,0xdcb90080,0x0d830033}},	//   _año_, þjón, _ещё_, _рлян
  { {0x31bb005d,0xe7040086,0x69d900dd,0x236700bd}},	//   _उद्ध, رستی, alwe, _nanj_
  { {0x88bd005c,0xc34e0016,0x644914b3,0xda630e4d}},	//   _odśw, _bổng_, etei, _иври
  { {0xc34e0092,0x7a8b000a,0x64490012,0xe819000b}},	//   _cổng_, _וָמַ, ftei, _नौका_
  { {0x6e3c0061,0x3f98001a,0x672314b4,0x69d90030}},	//   hurb, kkru_, banj, őbeá
  { {0x6723044c,0xdb050061,0x68fb0045,0x969614b5}},	//   canj, rihç, _zgud, _ореш
  { {0xfb370053,0x644914b6,0xa294017f,0x7d1600aa}},	//   ואיש_, atei, хані, kbys
  { {0x6e3c002e,0x92930010,0x64490012,0x6dac0061}},	//   durb, таюц, btei, ağaz
  { {0x14e2014e,0x2d8b0089,0x3e4800b8,0x64490251}},	//   _परिण, _roce_, eßt_, ctei
  { {0x61ee002c,0x6e3c00da,0x7052002b,0x0000006a}},	//   _ďale, furb, اچيا,
  { {0x518714b7,0x433b000a,0xfbbf000b,0x333b000a}},	//   _жупа, _ועוב, ्वसम, _ותומ
  { {0x6723044c,0x236700bc,0xa2ad0065,0x0000006a}},	//   zanj, _zanj_, ुपर्,
  { {0x2d8b0ede,0xf1bf12c3,0xbb7500af,0xb6010052}},	// [1f90] _voce_, mná_, нгај, _þáve
  { {0x291f0251,0x7f5c0251,0x4fc7017f,0x0076000a}},	//   _seua_, cerq, _іспа, _נתתי_
  { {0x672314b8,0x6449003d,0xc955055f,0xdb1c013f}},	//   vanj, ztei, етлы, _ukrý
  { {0xead8005e,0x67230573,0xf1bf14b9,0xad19000a}},	//   ємці_, wanj, nná_, _מוֹר
  { {0x6723052c,0xd8b800e6,0xe72e022a,0xb9920021}},	//   tanj, ودها_, ле_, طلوب
  { {0xf771003b,0xa3dd005d,0x8c1a000a,0xf7490015}},	//   طات_, _थीं_, _מושי, سلبي_
  { {0xe9190036,0xf6510067,0x291f0144,0x672314ba}},	//   _нові_, ائت_, _teua_, ranj
  { {0x644914bb,0xf1bf0107,0x672314bc,0xd5e80015}},	//   ttei, jná_, sanj, وعين_
  { {0xf1bf0107,0x644914bd,0xe4560033,0x656914be}},	//   dná_, utei, ежы_, rdeh
  { {0x43740036,0x644914bf,0x9cd8000a,0xd2a9004a}},	//   вуют, rtei, ווחה_, зкое_
  { {0xc34e0023,0xfbd20008,0xb345016e,0x236700bc}},	//   _tổng_, רתי_, _acçã, _vanj_
  { {0x0efa0372,0x46580029,0x1a9a0053,0x216a10a0}},	//   ्ड्स_, _تؤكد_, פירע, чими_
  { {0x43950010,0x25bf0011,0x66010020,0x395d14c0}},	//   _падс, mnul_, _hulk, iews_
  { {0xb46405d1,0x2d8f08e9,0xe436000a,0x660114c1}},	//   _шкіл, ögen_, _נרצח_, _kulk
  { {0x6601022d,0xf1bf0227,0x539a000a,0x25bf0045}},	//   _julk, bná_, _מיסו, onul_
  { {0xdd9200e5,0xf1bf0107,0xec160021,0xac0a0004}},	//   دور_, cná_, فورد, знаа_
  { {0x45da00b2,0x81bd0024,0xc5f2000f,0xdca30b5c}},	// [1fa0] פֿלא, ksēj, רדן_, гати
  { {0x7d160176,0xa3c1005d,0x67210607,0x0083005e}},	//   sbys, ्कि_, _nelj, _сльо
  { {0xdb1c005c,0xe7e3000b,0xa91d00bc,0x25bf0046}},	//   _skró, गतना_, _zoži, knul_
  { {0xb8660029,0x6da60036,0x08c6000d,0x621a000a}},	//   فاتو, _чима, нбен, פונק
  { {0xa3c1005d,0x69c30003,0x6721036d,0x3cfb000a}},	//   ्का_, énea, _belj, _מלכנ
  { {0xd7ef003b,0xe66600d0,0xf1bf0107,0x672100bc}},	//   مكن_, етио, zná_, _celj
  { {0xdb1c005c,0xd2cf005d,0xcf930008,0xfbc30080}},	//   _wkró, _सुलझ, רטו_, _сбро
  { {0xceb3000a,0xa96714c2,0x25bf0045,0x660114c3}},	//   טיו_, _писа_, gnul_, _dulk
  { {0xe73a000d,0xf1bf0264,0xb7da0115,0x9f4a0144}},	//   _неа_, vná_, _فورا_, ambé_
  { {0x42740036,0xa857000a,0x25bf0045,0xc4530015}},	//   вгос, _אימה_, anul_, اضيع
  { {0x36360086,0xf1bf099c,0x9bb7000a,0xdc030046}},	//   _سراس, tná_, תהיה_, včíh
  { {0xa91d14c4,0xf484002b,0x672106f2,0xd5b20015}},	//   _poži, _لاتی, _zelj, _حفص_
  { {0x557700b2,0x4fc7006b,0x660114c5,0xf1bf14c6}},	//   _רעדן_, есва, _zulk, rná_
  { {0xe47b00f3,0xf1bf0057,0x54970033,0x533408a0}},	//   _מרדכ, sná_, _явіў_, _рект
  { {0x862b000a,0x7d090015,0xf1bf14b9,0xade7006b}},	//   ּֽלֶ, ِيرِ_, pná_, ецак
  { {0xcdd80001,0xdce60061,0xa91d00bc,0xc2530015}},	//   ењу_, _alkı, _toži, _إخوت
  { {0x41c400e5,0x0000006a,0x0000006a,0x0000006a}},	// [1fb0] _حقيق,   ,   ,
  { {0x09c90065,0xf411004f,0xd9c90065,0x0000006a}},	//   िक्य, ׁ֤ב_, िक्ट,
  { {0x29120061,0x7cea0030,0x672114c7,0x9b440369}},	//   ıyan_, töré, _relj, انمو
  { {0xd2b70008,0x4998005e,0xf8b90015,0xc98408a6}},	//   עלאת_, нтія_, وهاب_, лучи
  { {0x09040036,0x660114c8,0x8934002b,0x395d00da}},	//   упін, _sulk, طعنا, rews_
  { {0xec360008,0xd7f80054,0x660114c9,0xb17b0123}},	//   _באשר_, нуј_, _pulk, llåd
  { {0xbbbf014e,0x36660063,0xb51c005d,0xe5710029}},	//   ्वीक, ващо_, नरूप_, لطة_
  { {0x25bf0045,0xdcfd002a,0x99d70015,0xc654002b}},	//   unul_, _posę, _أتسا, افيک
  { {0x9f5308e0,0x672114ca,0x25bf0011,0x79c80015}},	//   _així_, _telj, rnul_, _أوقف_
  { {0xe2990001,0x660114cb,0xe8740002,0x75c80046}},	//   дао_, _tulk, _حافظ, věze
  { {0xb2f40080,0x52820010,0x25fa000b,0xd5ae002b}},	//   ляющ, агэб, _ऊंची_, صفی_
  { {0x7afa002e,0xe196004a,0x75c80046,0x2d8f0012}},	//   _útte, троэ, těze, ögel_
  { {0xd00f0015,0x2ca90085,0x9596000a,0xd469011e}},	//   يلَ_, jzad_, _שכנו_, _циле_
  { {0x656b017e,0x52850015,0xf70e0016,0xdb1e0061}},	//   _hagh, _للتك, hủng_, üyüy
  { {0x443f0df8,0x7e2301ca,0xb17b01d0,0x645c00d4}},	//   luu_, идрж, flåd, ărie
  { {0x3f85002e,0x91fc003d,0xfce6118a,0xdde90067}},	//   ölur_, rvāt, вобо, فرقه_
  { {0x443f14cc,0x656b14cd,0x6f020045,0xfc030129}},	// [1fc0] nuu_, _magh, _şocu, ипто
  { {0xb17b003c,0x91fc0024,0x656b14ce,0x4e0611b3}},	//   småt, mvār, _lagh, _изоб
  { {0x6a86010f,0x628700f2,0x443f14cf,0xbf9b000a}},	//   ължа, äjoh, huu_, _חייש
  { {0x656b00b6,0x64590177,0x443f14d0,0xceb3000a}},	//   _nagh, _opwi, kuu_, _כית_
  { {0x91fc0024,0xa87a0015,0x443f128b,0xd90d002b}},	//   nvār, بحار_, juu_, سیل_
  { {0x2b58002b,0x98a30054,0x6d4414d1,0x244b01d0}},	//   _سیصد_, риље, lgia, døm_
  { {0xacbb0003,0x6d44007c,0x6eb7000b,0x87250015}},	//   _jeûn, ogia, ोपयु, اعهم
  { {0x7ae300dc,0xb5aa0015,0x6d4414d2,0xd5b7055f}},	//   ünte, باتك_, ngia, ксы_
  { {0x91fc0024,0x80e1000b,0xe7320015,0xa7660054}},	//   jvār, _नरें, _نصا_, _икад
  { {0x96b60054,0x0000006a,0x0000006a,0x0000006a}},	//   _исељ,   ,   ,
  { {0xc7d70008,0xbb3b0008,0x32630063,0x88bd002a}},	//   _יומי_, ועיי, атяв, _teśc
  { {0x69c20026,0xc05b005e,0x0000006a,0x0000006a}},	//   nnoe, міг_,   ,
  { {0x91fc0048,0x20840029,0xe3af002b,0x753d0030}},	//   gvār, للَّ, صری_, ósze
  { {0x644014d3,0xf457000a,0x4fc409c3,0x6d4414d4}},	//   mumi, _סיור_, асса, egia
  { {0x75e50014,0xa3c1005d,0x7c3a0024,0x93fb0135}},	//   lóza, ्कर_, _ātra, _קלוי
  { {0x6d4402d7,0xbd450015,0xfd130015,0xd657000a}},	//   ggia, طنطي, شجر_, כילת_
  { {0x644014d5,0x5c75056d,0x4fc701b0,0x69c202d8}},	// [1fd0] numi, ылат, _асна, dnoe
  { {0x765a0050,0x5b140036,0xbbbf005d,0x6d4400e8}},	//   _opty, имут, ्वेक, agia
  { {0x63af0144,0xc333000a,0x5a350b1e,0x6e950b59}},	//   ècni, שוע_, унет, _сину
  { {0x644014d6,0x09d40010,0x8e1a000a,0x69c20034}},	//   kumi, аціў, _רֵיח, gnoe
  { {0x64400048,0x28f80036,0x5d3a000a,0xf7950033}},	//   jumi, вець_, _אתרא, ладэ
  { {0x60da0053,0x656b002d,0xb6050156,0x8a370015}},	//   ײַנג, _sagh, hláš, _لعرض
  { {0x656b025c,0xc6a70063,0x45d505b3,0x0f58000a}},	//   _pagh, ърди, лцит, דיום_
  { {0x4efc013a,0x443f00f2,0xa91d0085,0xc8790061}},	//   ולוג, tuu_, _požu, _ayşe_
  { {0x644014d7,0xe4320015,0x1994006b,0x656b02b9}},	//   gumi, مفيد, _татя, _vagh
  { {0x8c1a0008,0xa774000d,0xca35000a,0x75c80046}},	//   עותי, _клуч, ְנָה_, tězc
  { {0x6d4414d8,0x8ab6000a,0xb607006b,0xd7df000b}},	//   ygia, ָ֔יו_, _рязк, _पीएच
  { {0xa1360029,0xe5700087,0x443f0209,0x82f40033}},	//   دردش, _وطن_, puu_, шчыц
  { {0x7c2d00c0,0x79ba000a,0x7d0d14d9,0xad9b016e}},	//   jsar, תֶיה, dcas, _miúd
  { {0xafdb00cb,0xe46a001a,0x7c2d14da,0x442d14db}},	//   dtøs, sröð_, dsar, mse_
  { {0x442d14dc,0xfe710015,0xed5a14dd,0x6da600eb}},	//   lse_, يدِ_, нов_, гива
  { {0x69c300dc,0x442d0472,0x6d440091,0x91fd01ec}},	//   énel, ose_, ugia, svār
  { {0x6d4414de,0x442d14df,0x7077012c,0xf1b3004f}},	// [1fe0] rgia, nse_, _مميز_, _לסה_
  { {0x2bba0029,0x6d440304,0x442d14e0,0xd884002b}},	//   راءة_, sgia, ise_, یهای
  { {0x8ad5008f,0xb17b0134,0x442d034d,0x7d0d00da}},	//   аюцц, slåe, hse_, bcas
  { {0x442d14e1,0xafdb003c,0x6dac0064,0xcb090008}},	//   kse_, støt, aşar, לל_
  { {0x64e2005d,0x69c20150,0xe947002b,0x442d14e2}},	//   _परेश, rnoe, ارمی, jse_
  { {0x38cb0074,0x64400024,0x88350033,0x442d0c3e}},	//   رانی_, vumi, рэцц, dse_
  { {0x49940086,0x7f3b0053,0xe2870029,0xaab8005d}},	//   _پیشر, געצו, _اذ_, _आधिक
  { {0x644014e3,0xad9b002d,0xca97000a,0x75e60033}},	//   tumi, _giúd, _גדלי_, ыўле
  { {0xd326087a,0xb9930029,0x48e30608,0xdcef003d}},	//   льни, _القب, _готв, _rocī
  { {0x644014e4,0x533407c1,0x394614e5,0xbb3a000a}},	//   rumi, јент, lgos_, ׂעִי
  { {0x66e60080,0x7c2d0024,0x442d14e6,0x45460031}},	//   _сожа, zsar, ase_, _مناق
  { {0x394614e7,0x644014e8,0x7c2d14e9,0x14ca004a}},	//   ngos_, pumi, ysar, _пыли_
  { {0xc5f3013a,0x6fb50029,0x88bd005c,0x39460007}},	//   _הדף_, لمحا, _leśn, igos_
  { {0xe4fb000a,0x7d0d14ea,0xf413000a,0x1fa70054}},	//   _נפגש, wcas, _הפס_, урмг
  { {0x539b000f,0x7d0d00da,0xee84056d,0x99780091}},	//   _איגו, tcas, быто, nčų_
  { {0x7c870036,0x63ba14eb,0x56b7004c,0xf127005e}},	//   лузе, litn, אפלן_, _сько
  { {0xdfd10029,0x69c30152,0x1bb50033,0x20040144}},	// [1ff0] _ويب_, énem, абаў, ímit_
  { {0x212b14ec,0x8f55005e,0x39460077,0x7c2d14ed}},	//   lach_, _твої, egos_, rsar
  { {0x442d0700,0x6ffa000a,0x7c2d14ee,0xdb080030}},	//   zse_, _שהתפ, ssar, ólás
  { {0x212b14ef,0x32350053,0xa2bb004c,0x442d14f0}},	//   nach_, שטײן_, עמאט, yse_
  { {0x39490048,0x61ed002d,0x63ba14f1,0x672a001a}},	//   ļas_, _mhal, kitn, fafj
  { {0x212b002f,0x442d0020,0xb6590bb9,0x394614f2}},	//   hach_, vse_, вших_, agos_
  { {0x212b14f3,0x16a614f4,0xaa5c005e,0x69ca0003}},	//   kach_, ивши_, _перi, éfec
  { {0x212b005c,0x629a14f5,0x442d14f6,0x61ed14f7}},	//   jach_, dyto, tse_, _nhal
  { {0x212b14f8,0x442d0493,0x291d003f,0x75c1003d}},	//   dach_, use_, mbwa_, nēzi
  { {0x92f50036,0xb8940029,0x442d14f9,0xe3b10015}},	//   ичні, _الْع, rse_, ترب_
  { {0x61ed002d,0xf089000a,0x20190727,0x9bb6000a}},	//   _bhal, _קנ_, epsi_, שהתה_
  { {0xfad6000a,0x61ed02ff,0x63ba0125,0x442d14fa}},	//   יותך_, _chal, aitn, pse_
  { {0xd83e032c,0xc5f20008,0x15f40002,0xad66002b}},	//   _účte_, _ודא_, _اسلح, یاره
  { {0x629a14fb,0x1eaa0015,0x39460077,0x63ba0480}},	//   byto, نازي_, zgos_, citn
  { {0xc7b20008,0x39460007,0x733a0053,0x7db60c55}},	//   קבל_, ygos_, _סעקס, асац
  { {0x3d20014e,0x4ad9005d,0x7bc5001c,0xe1f20087}},	//   बरें_, _बुधव, enhu, _بست_

  { {0x8b260080,0xac0714fc,0x8c4609ac,0x2c0b002b}},	// [2000] идае, инта_, резе, نعلی_
  { {0x109b0008,0xb09b000a,0xafdb0af5,0x207b004c}},	//   _סביב, _סייר, stør, _יאפא
  { {0x7f3b0008,0x32070251,0x34e2005d,0x2f3b000a}},	//   _בעיו, _juny_, _पर्द, _בגיד
  { {0x394600df,0x26de0091,0x8c4614fd,0x0ae90058}},	//   ugos_, _ryto_, _кеме, اركي_
  { {0x8eb30086,0x629a005c,0xadf8000b,0x76430034}},	//   _همیش, zyto, ंगठन_, euny
  { {0x81bd0048,0x57b30036,0x212b1332,0x39460fc9}},	//   lsēt, обіт, zach_, sgos_
  { {0xd7190036,0x212b0034,0x5694110d,0x63ba14fe}},	//   уючі_, yach_, сайт, vitn
  { {0x0d960008,0xe5c6023e,0x28160067,0x81bd003d}},	//   יכֶם_, јско, _نورس, nsēt
  { {0x88bd0050,0x2fd800c0,0xcc56000a,0xf7460054}},	//   _jeśl, korg_, ׁבֵי_, _везо
  { {0x61ed14ff,0x26de0089,0x212b005c,0x629a0007}},	//   _shal, _tyto_, wach_, tyto
  { {0x81bd0024,0xe3af00a2,0x212b1500,0x68e00034}},	//   ksēt, بري_, tach_, _hymd
  { {0x3d20005d,0x629a1501,0x29dc0077,0x869b004f}},	//   बरों_, ryto, mías_, _שיאז
  { {0x67280123,0x7bdc1502,0x29dc0077,0xe53b000a}},	//   _kedj, _okru, lías_, _יתאר
  { {0x644f08e0,0xd83f0107,0x61ed1503,0x212b1504}},	//   àcie, _účet_, _whal, sach_
  { {0x29dc02c1,0x6728044c,0x212b1505,0xaffc005e}},	//   nías_, _medj, pach_, торi
  { {0xdce60024,0x02fb0135,0xaada000b,0x42fb000a}},	//   _sakā, _בלומ, _भड़क, _בהוס
  { {0xdce60024,0x50b80086,0x6be50015,0x9bc90015}},	// [2010] _pakā, _پديد_, مكرم, هورك_
  { {0xa3e6005d,0x69db0595,0x6728100e,0x764301c2}},	//   पति_, _skue, _nedj, yuny
  { {0x7ff400b0,0x6ff40015,0x5a470033,0x68e91506}},	//   _بسيا, _بسيط, рэза, _szed
  { {0x29dc0077,0xc172000a,0x7cd90021,0x6a140138}},	//   días_, ּ֗א_, _موجز_, імчу
  { {0x68e00176,0xa2d8005d,0xa3e6005d,0xf84b004a}},	//   _cymd, _नुस्, पता_, тчей_
  { {0x785a0048,0xe5790026,0x29dc02c1,0x8a170087}},	//   dāvā, glŷn_, fías_, _نظرا
  { {0xf7700225,0x29dc02c1,0x86750033,0xda340033}},	//   بان_, gías_, сылц, _меры
  { {0x9f96002e,0xca480015,0x2fd80079,0x645c0045}},	//   hæð_, _خلفه_, zorg_, ărin
  { {0x24520029,0x69d9005c,0x68e00026,0x320703e1}},	//   كنيس, mowe, _gymd, _suny_
  { {0x29dc0467,0x69d907e9,0x76430509,0x47940015}},	//   bías_, lowe, puny, _وجلس
  { {0xd5750010,0x29dc02c1,0x6b9503a3,0x70b2000b}},	//   _гуль, cías_, _mozg, ीप्ल
  { {0x69d9005c,0x13a7002b,0x35f51507,0x05740040}},	//   nowe, انگی_, _упер, _واند
  { {0xd24e0074,0x2fd8002e,0x14190029,0x200901c2}},	//   ونی_, torg_, _صيغة_, _cuai_
  { {0x443f0b7c,0xf412000a,0x141a000a,0xd8d6000a}},	//   mru_, _צפו_, _עוצב, מורט_
  { {0x69d9005c,0xdee60b0c,0x38ae0030,0xe2150015}},	//   kowe, сови, _köré_, _ابتع
  { {0xdced032c,0x29000007,0x69d9005c,0xd24e0015}},	//   adač, žiai_, jowe, _أني_
  { {0xc5f20053,0x69d91508,0xcc290015,0xd00f0015}},	// [2020] לדל_, dowe, لألم_, _كلي_
  { {0x68e000c0,0x3f9e007c,0x394d1509,0x443f150a}},	//   _rymd, ötud_, _aces_, iru_
  { {0x4906003b,0x1ee8002b,0x443f150b,0x2f97000a}},	//   مواق, _خودی_, hru_, _הכין_
  { {0x70530074,0x5d860029,0x69d9150c,0x443f150d}},	//   _بنیا, _الحل, gowe, kru_
  { {0xa85600d0,0x783a023e,0x2089000a,0x0719000b}},	//   стеј, уџет_, ֹתוֹ_, नुभव_
  { {0x0f7a0053,0x3f7a004c,0x29dc0077,0x75c80046}},	//   ראַב, ראַס, tías_, tězo
  { {0xda650015,0x69d9051e,0x386d068c,0x9f520077}},	//   _وافي, bowe, _eser_, _huyó_
  { {0x76a90036,0x29dc02c1,0x860700e6,0x29040035}},	//   штів_, rías_, حقيق_, _ugma_
  { {0x2bbf000b,0x29dc010d,0x443f150e,0x6b950061}},	//   ्वचा, sías_, gru_, _yozg
  { {0xa3b4005e,0x037a0015,0x212901c2,0x29dc0077}},	//   ібні, احظت_, _seah_, pías_
  { {0x4df8005d,0x22580080,0xe717000a,0xf202000b}},	//   ंगाई_, шины_, _החבר_, _रूख़_
  { {0x8afb000a,0x2001007c,0x443f150f,0xda7b004f}},	//   טליז, _sihi_, bru_, אנטר
  { {0x443f04f9,0x9f96001a,0x0453002b,0xc1b8033d}},	//   cru_, tæð_, _فئود, слях_
  { {0x4fc70080,0x33f60e88,0x69d9005c,0x44261510}},	//   ссма, _учес, zowe, _iwo_
  { {0x6b95005c,0x69d9003f,0xd3570008,0x82330067}},	//   _rozg, yowe, _השוק_, _فريا
  { {0xd1310074,0x64401511,0xbd191512,0x0000006a}},	//   _کمک_, ormi, ржах_,
  { {0xd0110086,0xbbb9005e,0x5bb901b0,0x1dc40015}},	// [2030] _تلخ_, агає_, алая_, سْكِ
  { {0x6ac4014e,0x69d9005c,0x749b000a,0x2cb80015}},	//   वपूर, wowe, אימפ, حافظ_
  { {0x69d91513,0xdd950010,0x64400012,0x0000006a}},	//   towe, _даны, hrmi,
  { {0x88190010,0x195902bf,0xec150015,0x127b004c}},	//   аўку_, рады_, _ووجد, טאבע
  { {0xf09f0251,0x6845017f,0xdd31002a,0x69d91514}},	//   nyà_, інка, _mężo, rowe
  { {0x645c04f9,0x69d91515,0x443f1516,0x67d400ce}},	//   ăril, sowe, vru_, почу
  { {0x86980063,0x753d0030,0xf7700015,0x69d91517}},	//   йтът_, ószo, عاه_, powe
  { {0x443f1518,0xe6280029,0x84590fba,0xe41b004c}},	//   tru_, حثون_, арот_, _אָרגאַ
  { {0xc7c80092,0x2365065d,0xb4650086,0x386d043a}},	//   uốc_, telj_, تگاه, _user_
  { {0x443f1519,0xdb0e001a,0xfe09000b,0xb8df000b}},	//   rru_, _embæ, वदास_, ुप_
  { {0x6d5d04af,0x6440151a,0x01660146,0x32b90015}},	//   _obsa, armi, окно, شددة_
  { {0xc1060015,0x7d020091,0xcf89000a,0xf1bf151b}},	//   توحي, žosi, _בט_, giá_
  { {0x25bf0045,0xb17b0123,0x2365013b,0x0000006a}},	//   miul_, plån, pelj_,
  { {0x25bf0011,0x3cdd005d,0x6d4f151c,0x6d5d079c}},	//   liul_, _खड़े_, _acca, _absa
  { {0x11d60015,0x1d0a07be,0xd3d80015,0x249f0061}},	//   _وتبد, иеви_, _ابنا_, lyum_
  { {0x25bf04f9,0x0c2600d0,0x51f6002b,0xf1bf016e}},	//   niul_, жман, _بستر, ciá_
  { {0x752b0030,0xfce3107f,0x249f151d,0x0000006a}},	// [2040] _megz, дото, nyum_,
  { {0xbfc3004a,0x25bf0045,0xab1a01b0,0x9e660e4b}},	//   _обык, hiul_, рцах_, _двод
  { {0xed5a0083,0xcfa9002b,0x7539002a,0x3dc902f2}},	//   _кон_, _دايم_, _odwz, bnaw_
  { {0xad5a0010,0xe9da1179,0xba17002b,0x010d004f}},	//   _трох_, шке_, زيها_, ְלוּ
  { {0x25bf0011,0x999c00dc,0x515b004f,0x0000006a}},	//   diul_, évő_, שכנו,
  { {0x907b0008,0x207b0053,0x8bd8000a,0x249f151e}},	//   יטני, יאנא, _הַֽח, dyum_
  { {0x645c0045,0xbcfb01d3,0x61e601ec,0x0000006a}},	//   ărim, _ebéd, klkl,
  { {0xdb070084,0x7e9b0053,0x25bf0045,0x25ad151f}},	//   ámör, יסצו, giul_, ghel_
  { {0xf1bf016e,0xa73a002b,0x938a1520,0x88c50058}},	//   viá_, _نثار_, асна_, _فتكل
  { {0x7c290064,0x25ad007c,0xfc5b000a,0x61e60353}},	//   _çere, ahel_, סכימ, elkl
  { {0x25bf1521,0xcb130008,0x86c600e5,0x5b7b000a}},	//   biul_, ולת_, _بيان, בריא
  { {0x4426003e,0x25bf0011,0xb606016f,0x29000007}},	//   _two_, ciul_, rišć, žiau_
  { {0xf1bf002c,0xcf9b0099,0xa0c50015,0x8f0b009b}},	//   riá_, ајв_, سيسو, ихва_
  { {0x43740074,0x3373005e,0x4ea70763,0x02340058}},	//   _رهبر, _огір, орба, _ففتح
  { {0x3ea500dc,0xd13b0033,0xe28f0015,0x98ad0535}},	//   ált_, _кхп_, _لذي_, _ideą_
  { {0x4237000a,0x321e04a9,0x3dc90034,0xdb0d01d3}},	//   _ונהל_, mpty_, unaw_, űkül
  { {0x030e005d,0xc19c0008,0xf19c000a,0x0000006a}},	// [2050] _सलाह_, _כשהי, _כשהש,
  { {0xda7b006b,0x673a02de,0x6ed6000b,0xee870088}},	//   ияе_, _ndtj, _मुकु, _дымо
  { {0xf0b80086,0x9ff80015,0x0000006a,0x0000006a}},	//   _هایش_, _بريء_,   ,
  { {0x7aed003d,0x2ca01522,0x0000006a,0x0000006a}},	//   _ģitā, byid_,   ,
  { {0xb17c0053,0x98f40010,0xdcef0007,0x9cc8004a}},	//   יטאר, мяшч, _įdėk, _дыра_
  { {0x6cfa0008,0x4c9a000a,0xacfa000a,0x7b640e91}},	//   _לפרס, _הבשו, _להרכ, _отсе
  { {0x67ed00dc,0x2d991523,0x25ad1524,0xd7580058}},	//   gúja, _kose_, thel_, تجنا_
  { {0x6d4d1525,0x391501c6,0x2d991526,0x0000006a}},	//   ngaa, _хмар, _jose_,
  { {0x25bf0011,0xd8770086,0x04560029,0x29120061}},	//   riul_, _بازب, كلية_, ıyat_
  { {0x2d990708,0xe7b50067,0xfb96000a,0xbbba000a}},	//   _lose_, _عماد, ִ֣ית_, ֶ֖יך
  { {0x69cb1527,0x95cb0bb9,0x25bf0045,0x91e61528}},	//   onge, _куда_, piul_, зоне
  { {0x2d990398,0xa06a0054,0x69cb0b2d,0x6a96004f}},	//   _nose_, бама_, nnge, לכתא_
  { {0x69cb1529,0x920b000b,0x9554002b,0xd4c70015}},	//   inge, _सूरज_, _آخما, _بغاي
  { {0xa4fa0008,0x69cb0012,0x7bcb0003,0x141a004f}},	//   _פלסט, hnge, égul, _הוסב
  { {0x59db005d,0x6449152a,0xa3b80015,0x395f0003}},	//   यकार, luei, _بانر_, _obus_
  { {0x2d9904ed,0xf2d2000a,0x6d4d152b,0x395f00aa}},	//   _cose_, _רעה_, ggaa, _nbus_
  { {0x6ac4000b,0xe04a002b,0x64490144,0x26110016}},	// [2060] वप्र, _اشعه_, nuei, _láo_
  { {0x6d4d1521,0x395f152c,0xa3cb000b,0x69cb152d}},	//   agaa, _abus_, रचि_, enge
  { {0x4f9b0008,0xbf9b0008,0x9f9b0008,0x2ca00375}},	//   _הביצ, _הייש, _הסיפ, syid_
  { {0x5f46002b,0xd23a004c,0xb5f90033,0xfe37000a}},	//   _بنگل, מגעל, _кнiг, _צרכי_
  { {0x7d7b0008,0x3f9a0024,0x98a3007a,0x51b5004c}},	//   _הנכו, _kopu_, нице, וּװן_
  { {0x26110023,0x64490251,0xdb1e0144,0x69cb0cc6}},	//   _báo_, duei, xipè, ange
  { {0x261100a7,0xdbc70209,0xe5c6006b,0xe7370054}},	//   _cáo_, töös, зспо, чеј_
  { {0x69c300dc,0x9418004a,0xe60f009a,0x7bde152e}},	//   énet, ожит_, دشو_, lopu
  { {0xdce40007,0xc5130015,0x6449152f,0xe4a601f3}},	//   keič, ربيت, guei, ярко
  { {0xdc9b0053,0xb8050015,0x7643002a,0x93930015}},	//   צייל, _قبله, brny, ّجَا
  { {0xf7730008,0xe4d60086,0xd257005e,0x0edb000b}},	//   _רקע_, _کتاب, пця_, _मुंड
  { {0x92570080,0x64490251,0x98a4003d,0xa01b0012}},	//   чают_, buei, _zemā_, nvög
  { {0x6449038d,0x7bde00f2,0xb0340010,0xad9b002d}},	//   cuei, kopu, нняш, _diúl
  { {0x2259005c,0xf43b000a,0x6f15002a,0x34fb000a}},	//   ńska_, _פגומ, uczc, _ההדד
  { {0xdb1e002f,0x735b0008,0x3da70010,0x1ee7002b}},	//   cipé, _הכוח, праб, سوری_
  { {0x91e40001,0x91720016,0xdd170065,0x361b004f}},	//   _поје, rợ_, धुंध_, מולד
  { {0x113c0008,0x9c190029,0x6d4d1530,0x91bc000a}},	// [2070] _התחל, زياء_, rgaa, _למהי
  { {0x2bbb0015,0xbb850015,0x7bde1531,0xfa8b1532}},	//   حارة_, بلطي, gopu, йсей_
  { {0xcb080015,0x2cbf006f,0xdb200030,0x3e350058}},	//   أيمن_, _ľudu_, ótáb, _تفجر
  { {0xc7c80092,0xdb1e00f2,0x69cb1533,0x2d990091}},	//   uốn_, enpä, unge, _uose_
  { {0xe72e005e,0x320e002a,0x6f0c0030,0x26110016}},	//   ке_, _lufy_, _álcá, _sáo_
  { {0xdb230086,0xe93b002b,0x7bde1036,0x66e51534}},	//   _سوری, _گسست_, copu, мола
  { {0xe7300087,0xe919005e,0xff18000a,0x7f3c004c}},	//   اصه_, _мові_, הקות_, זעוו
  { {0x49b80018,0x64491535,0xa5f60054,0xc48507f7}},	//   _فاقد_, tuei, меју_, длик
  { {0xa3b90015,0x87070015,0x2900006f,0xa8980033}},	//   قادر_, _فبال, žiar_, _екту_
  { {0xe2a20023,0x26110016,0xa3b7000b,0xf3c90015}},	//   _thử_, _táo_, घों_, تبعه_
  { {0xd6270002,0xf6550004,0x6dac0061,0xeb92000a}},	//   _رعاي, _цвеќ, aşay, דָר_
  { {0xf8a70015,0x799b042f,0xf652004f,0x7a88004f}},	//   نة_, _jouw, _יצב_, פָתַ
  { {0x29360053,0x7bde003f,0x644911dd,0x85040015}},	//   וארן_, yopu, quei, _كومن
  { {0xb4fa000a,0x03950033,0xa4fa000a,0x34fa000a}},	//   _ופני, _ірля, _ולנט, _והנד
  { {0x5de60010,0x0ef90010,0xdce40091,0xdee313d0}},	//   джва, зэты_, reič, вори
  { {0x69bf005d,0xcd36002b,0x6e930040,0xdd92012c}},	//   लोमी, برآب, خلفا, خور_
  { {0xa5c6002e,0x718b0008,0x5f760115,0x61e41536}},	// [2080] ljóð, _וְיַ, _قادر, _ikil
  { {0x78a2003f,0xafdb00cb,0x4e1a0015,0xfaa61111}},	//   vyov, ktøy, _وتجد_, мазо
  { {0x799b0111,0x7c3a0024,0x9a6a0031,0x7bde1537}},	//   _bouw, _ātru, تمال_, ropu
  { {0xbd460015,0xfbc905bd,0x08c60788,0xc4ad0065}},	//   _تنحي, בת_, мбен, टनाओ
  { {0x69c20034,0xa817002b,0x7bde1538,0x644f0144}},	//   rioe, وتور_, popu, àcil
  { {0x7a0c04f9,0x316b002a,0xa77300e2,0xe3a7012c}},	//   _aşte, zecz_, кліч, _شر_
  { {0x6b9c1539,0x69c20546,0x66e300af,0x0000006a}},	//   _iorg, pioe, коља,
  { {0x2abb000a,0x35f700c3,0x6b9c0030,0x79890034}},	//   _ומלא, وريد_, _horg, _gnew
  { {0x4c9b00b2,0x690b000f,0x236a00d0,0x69c0153a}},	//   ַשטע, _וּבְ, ојно_, _imme
  { {0x889b0008,0xb89b000a,0x6b9c153b,0xf3660788}},	//   _ובמי, _ובמש, _jorg, фтин
  { {0xbcfb002d,0x316b005c,0x6b9c04dd,0x2b16000b}},	//   _mbéa, tecz_, _morg, दुएँ_
  { {0x6b9c10e0,0xc693000a,0xca37000a,0x61f6028a}},	//   _lorg, _שאף_, ונטה_, _chyl
  { {0x6b9c0234,0x9554002b,0xb5fb000a,0xdb1c0030}},	//   _oorg, _يخچا, _ולאכ, _emré
  { {0xe4c70086,0x6b9c153c,0x61e40061,0xa3b7009a}},	//   _تصمی, _norg, _ekil, _ياور_
  { {0xa3cb000b,0xa3bd000b,0xdd9b153d,0x69c0153e}},	//   रचर_, ीचर_, оша_, _omme
  { {0x31c40010,0xc5f8003d,0x0000006a,0x0000006a}},	//   _асьв, _spēj_,   ,
  { {0x6b9c153f,0xfc300015,0x2cfb0065,0x799b0546}},	// [2090] _borg, لحل_, ्शेल_, _rouw
  { {0x21f2002c,0xf092000a,0x5457000a,0xbfd50015}},	//   máha_, _עני_, וסמן_, _سيجع
  { {0xcff6000a,0xafdb00cb,0x656201c0,0x61e40052}},	//   _רצתה_, nrøm, _oboh, _ykil
  { {0x49b80086,0x4efa000a,0x6d4b0125,0x58d50238}},	//   واند_, _מהתו, ógad, ноет
  { {0x6b9c0c0a,0xa9680015,0x9d1a000a,0x2d8b1540}},	//   _forg, ظمهم_, _מורט, _ince_
  { {0xdce401e2,0x79890026,0x6b9c0376,0xafdb00cb}},	//   ldiğ, _wnew, _gorg, ttøy
  { {0x4ae4008f,0x4ad9000b,0xdcfd0091,0x799b0079}},	//   _аўта, _बँटव, _posė, _touw
  { {0xdce40064,0x6b9c1541,0xc6a4006b,0xafdb01de}},	//   ndiğ, _zorg, ърчи, rtøy
  { {0x37c50015,0x9817002b,0x44391542,0x6b9c0a63}},	//   _كيرف, _آبرا, és_, _yorg
  { {0x61e41543,0x56670015,0x57780015,0xf77300c3}},	//   _skil, _يداف, _يصلح_, _جار_
  { {0x2d8b0041,0x98a40011,0x52b80033,0xd794006b}},	//   _once_, _temă_, дыяў_, _шифъ
  { {0x2259005c,0xa91d0091,0xa06a0a3e,0xe29a0016}},	//   ńsko_, _požy, пама_, _ngưu_
  { {0x54a70015,0x2256002b,0xf536000a,0xe6040015}},	//   _تحاف, ولید_, _ננסי_, _شِهَ
  { {0x649a000a,0xc49a000a,0xdff50033,0x3cf5000b}},	//   _מינה, _משנת, вясь, ्धने_
  { {0x645b1544,0x61f61545,0x0000006a,0x0000006a}},	//   ltui, _thyl,   ,
  { {0xb2ba000a,0xc692000a,0x64460091,0x6b9c1546}},	//   _ממצר, נאן_, škie, _sorg
  { {0x8b260010,0xf3900092,0x3c660010,0xdd8f0015}},	// [20a0] едзе, _mảnh_, экаг, حوق_
  { {0xda660029,0x6abd005d,0x645b1547,0x69c30003}},	//   فاصي, ्पूर, itui, ènen
  { {0x6b9c018b,0xfe720086,0x0f57000a,0xff57000a}},	//   _vorg, _صدد_, _איים_, _אביך_
  { {0x317b000a,0xed5f006f,0x645b1548,0xe8fa07f8}},	//   ּ֨אמ, ížte_, ktui, пле_
  { {0xd7e602e1,0x645b0079,0xdb1e1549,0x69230099}},	//   ніко, jtui, lipí, умча
  { {0x7c24154a,0x6b9c064c,0x0000006a,0x0000006a}},	//   mpir, _uorg,   ,
  { {0x61fd0084,0x7c24154b,0x569401e3,0xd9460195}},	//   ymsl, lpir, тайт, _певи
  { {0xf3900023,0x14180029,0xd5b7154c,0xda5b000a}},	//   _cảnh_, ويبة_, есь_, _מכלל
  { {0xdce60024,0xb8860107,0x7c2402f2,0xc9550033}},	//   _nokļ, _blíž, npir, _штры
  { {0x883b000a,0xb8e6000b,0xcc57000a,0x14f30033}},	//   _מתמו, ॉप_, עסיק_, ызыў
  { {0xf8bf09f0,0x0bb70008,0x6283016f,0x645b043c}},	//   _þér_, גלים_, _crno, atui
  { {0x645b00dd,0x65620046,0x0000006a,0x0000006a}},	//   btui, _uboh,   ,
  { {0x53a60010,0xc0ab0015,0xf1c0000b,0xdce40061}},	//   _падб, ساحل_, शोधन, vdiğ
  { {0x32940029,0x7c2400bd,0x44f30010,0x22940015}},	//   _للتأ, dpir, _спіс, _للتس
  { {0xe37b000a,0x777a0016,0x7bc5154d,0x7c24003d}},	//   _מרגר, _matx, vihu, epir
  { {0xf1bb004f,0xa0c50058,0x66f7004f,0xbdf80058}},	//   _מֶ֖ל, _ليعو, תמלא_, فرقا_
  { {0xdce401e2,0xd1640063,0x3b550c1d,0xa0220061}},	// [20b0] rdiğ, _същи, ккар, _şöva
  { {0x657b154e,0xa91d154f,0x69da005a,0x60f80138}},	//   zduh, _inži, _ítej, _яныя_
  { {0xc3330008,0xdcef0045,0x8c440061,0x6abd000b}},	//   רוע_, _bacă, ışar, ्पेर
  { {0x0000006a,0x0000006a,0x0000006a,0x0000006a}},	//     ,   ,   ,
  { {0xed600089,0xf7950033,0x3da40033,0x777a0144}},	//   ížet_, кадэ, _срэб, _batx
  { {0xa08c0008,0xf7710115,0x307c0135,0x98a209b5}},	//   לְוִ, شات_, פאונ, рише
  { {0xd915008f,0x68e9002a,0xcec40046,0x96750033}},	//   _адбы, _wyed, moří_, тылі
  { {0xd6ce0029,0x645b1550,0xdb1e00d4,0x0000006a}},	//   تقى_, ttui, cipâ,
  { {0x75c80089,0x645b008c,0x672c0030,0xa5f60054}},	//   vězt, utui, éljü, њењу_
  { {0x645b1551,0xb464006e,0x4374005e,0xd2a902ed}},	//   rtui, اديه, гуют, дкое_
  { {0xcb12000f,0x645b1552,0xe6950015,0x3f9e001a}},	//   ילי_, stui, _جلاد, ötum_
  { {0xb6d80053,0xcec40046,0x82f40033,0x645b0045}},	//   _אַױט, hoří_, ычыц, ptui
  { {0x98a40007,0x75291553,0xe6040015,0xa93a000a}},	//   _temą_, mbez, _إِنَ, ותרפ
  { {0x64490d75,0x645c0045,0x03a2012e,0x43450c71}},	//   mrei, ărit, _вишо, _рекв
  { {0x64491554,0xd0070bb9,0xed5a10b7,0xdee61098}},	//   lrei, тере_, мов_, тови
  { {0x661c0014,0xb602002e,0x752904de,0x52d60447}},	//   _érke, _þátt, nbez, _בוצע_
  { {0x973c016f,0x64491555,0xff2600a5,0x4d630004}},	// [20c0] _hoće, nrei, _импо, јкув
  { {0x4b230036,0xd00f002b,0x1037004c,0x442f0034}},	//   имув, _گلی_, _שטים_, _mwg_
  { {0xf1c6005d,0x2d9e0152,0x3bd50080,0x64491556}},	//   _लगान, êtes_, уютс, hrei
  { {0x64491557,0xd9180021,0xd00f002b,0xd94603ae}},	//   krei, ريتش_, _دلی_, теди
  { {0x38cb0086,0x5cf50033,0x8e3a002b,0x4614002b}},	//   واهی_, _бяру, _عسگر_, گوبر
  { {0xb17b01d1,0x75291558,0x64491559,0xd885009a}},	//   llåt, ebez, drei, اهوی
  { {0x16370029,0x4b7b0053,0xad9b002d,0x8bd7000a}},	//   نسية_, _קאלו, _siúi, _סולו_
  { {0xfa770008,0xadf8005d,0x55740254,0x6449155a}},	//   _בעלת_, ंगटन_, угит, frei
  { {0x48060010,0xe8ea0086,0xc7c80092,0x6449155b}},	//   _апав, _آرزو_, hối_, grei
  { {0x75c80089,0xafdb02de,0x3cfb000a,0x7529155c}},	//   tězs, msøg, ולפנ, abez
  { {0xafdb02de,0xd3770033,0xf1f6000b,0x75290030}},	//   lsøg, тчы_, ीगढ़_, bbez
  { {0x442f0034,0x673800bc,0xf1a71111,0x6449155d}},	//   _fwg_, lavj, трон, brei
  { {0xe1ff02c1,0xafdb0134,0x1074155e,0x43860015}},	//   rmó_, nsøg, аляю, _للإق
  { {0x9f5308e0,0x26180092,0x533404d7,0xe507004f}},	//   _això_, _kéo_, _сект, _ב֖וֹ_
  { {0x9f340036,0xcec40089,0xde58005e,0x2fcd0085}},	//   ресі, voří_, карі_, đeg_
  { {0x26180016,0x63bd003d,0x2486155f,0x41551560}},	//   _méo_, īsne, _krom_, _свис
  { {0x6abd005d,0x69c30152,0x71d8000a,0x6ce7005e}},	// [20d0] ्प्र, ènem, _שוחד_, тіве
  { {0xdb0700dc,0xafdb0134,0x0bb40010,0x2d9e0003}},	//   _aljá, dsøg, абую, êter_
  { {0xafdb0134,0x4ae40010,0x26180003,0x5c04004a}},	//   esøg, аўца, _néo_, рята
  { {0xdd951561,0xe9190036,0x3eac0723,0xe80f0065}},	//   _самы, ході_, ødte_, ादला_
  { {0xafdb0134,0x39440127,0x91bc000a,0x764a0034}},	//   gsøg, рніг, ומאי, erfy
  { {0xdb0700dc,0x68380046,0xd7f40033,0x26180016}},	//   _eljá, _súdá, азчы, _béo_
  { {0xcf940135,0x37080029,0x64490034,0xfc3f001a}},	//   יטס_, نْهُ_, wrei, _hví_
  { {0xafdb02de,0x64491562,0x24861563,0x69ca01f6}},	//   bsøg, trei, _brom_, éfet
  { {0x752900d9,0x67380085,0x91fd003d,0x04940033}},	//   rbez, bavj, itād, арэў
  { {0x752904de,0x24861564,0x64491565,0xd7e400fd}},	//   sbez, _drom_, rrei, _кіхо
  { {0x35550115,0xd1ca0054,0x02c500fd,0x64491566}},	//   _مناز, елне_, уйно, srei
  { {0x248603c2,0x64460007,0x645c0011,0xe5730015}},	//   _from_, škia, ărir, _خطط_
  { {0x3fc80086,0xf539002c,0xd469012e,0x24861567}},	//   ندسی_, mať_, _чиле_, _grom_
  { {0xf539002c,0x8e7600c2,0x0000006a,0x0000006a}},	//   lať_, лубч,   ,
  { {0xc7c80092,0x213900c7,0x1eaa0369,0x0000006a}},	//   uối_, bash_, راسي_,
  { {0xf539002c,0x25ad1568,0x7db50138,0x21391569}},	//   nať_, nkel_, асуц, cash_
  { {0x3dd20034,0xb17b156a,0x4c860033,0x808a0015}},	// [20e0] rnyw_, rlåt, ылав, _أضعف_
  { {0xb17b00cb,0x9f5e00f2,0xb346016e,0x25ad007c}},	//   slåt, ötä_, moçõ, hkel_
  { {0x53360053,0xf539002c,0x2ca90035,0x7c22002d}},	//   רנען_, kať_, ayad_, íorb
  { {0xe9e50036,0xf539002c,0xafdb02de,0x83fd0030}},	//   аціо, jať_, tsøg, ltőd
  { {0xf539002c,0x07a6156b,0xe894156c,0x3157000a}},	//   dať_, ладн, раль, רינן_
  { {0xafdb00fb,0x50db004c,0x30db004c,0x83fd0030}},	//   rsøg, עקסא, ײַדע, ntőd
  { {0x673800bd,0x1a78000f,0x8a78000a,0x9a78000a}},	//   ravj, _בְּמ, _בָּק, _בָּח
  { {0x442a0124,0x6d5600b6,0xceb3000a,0x2d800252}},	//   нцом_, ngya, מיו_, ndie_
  { {0x6d560035,0xa84a0031,0xa4d4005e,0x61e6156d}},	//   igya, _سلام_, ропі, dokl
  { {0x21f20046,0x610c003d,0x883b000a,0xcc77000a}},	//   sáhl_, _mēlī, _נתבו, נגית_
  { {0xf539006f,0x4422003d,0xb7db004f,0xeb97004f}},	//   bať_, ūk_, _טקמי, אדיר_
  { {0xd9f6005d,0x2486002d,0xf539006f,0x25ad156e}},	//   ेषित_, _trom_, cať_, ckel_
  { {0x33860323,0xe3af002b,0x2d80156f,0x21391570}},	//   _буйв, زری_, ddie_, rash_
  { {0x14d70008,0x2a66005c,0xad9b0125,0x2d801571}},	//   _גודל_, łoby_, _liút, edie_
  { {0xe3370053,0xe2460015,0x8337000a,0xc6d8000a}},	//   _גרופ_, _إختي, _גאוס_, דַּר
  { {0x7c290061,0x6d560030,0x0000006a,0x0000006a}},	//   _çerk, ggya,   ,
  { {0xdfd50010,0xe58b000a,0xade8002b,0xed600046}},	// [20f0] _вопы, עָלָ, افقم_, ížat_
  { {0x6ee7003b,0x91fd0048,0xf539002c,0x6d560a4d}},	//   _مسجل, stād, zať_, agya
  { {0x20d40086,0xfbd00015,0x633b004c,0xc9150054}},	//   _نتیج, ستك_, געבױ, адећ
  { {0xe9ce05d1,0xd257000a,0x5e880015,0x7aee02de}},	//   ік_, רשאה_, _إنَّ_, _dybt
  { {0xf53905cc,0xd5b10023,0x3d3a0008,0xdd3a000a}},	//   vať_, _lúc_, _בגרס, _בערכ
  { {0x22590050,0xdd1c0007,0x8a370015,0x98af0045}},	//   ński_, _iššo, _معرض, eagă_
  { {0x25ad0020,0xf539002c,0xf7700015,0x1a68002b}},	//   tkel_, tať_, ثان_, _میلی_
  { {0x16620010,0xa4451572,0x0000006a,0x0000006a}},	//   івым, анид,   ,
  { {0x9848010f,0xf539002c,0x64461573,0x69cb1574}},	//   _бяха_, rať_, škin, mige
  { {0xf539002c,0xd2650010,0x81bd0024,0x92b50015}},	//   sať_, акой, spēl, لحجا
  { {0x22490063,0x25b000dc,0x8b88039e,0x31a60015}},	//   ъпни_, álló_, אָרֶ, لمدف
  { {0x69cb018b,0x6aba0064,0x61e60007,0x14750015}},	//   nige, _ütfe, uokl, _ناتج
  { {0x6e25002d,0x81bd0024,0x61e61575,0x8fe60015}},	//   _athb, opēj, rokl, لأسم
  { {0x6d4b002d,0x69cb00b8,0xdfd20115,0x94ba000a}},	//   ógan, hige, زيز_, _שמסת
  { {0xa91d04af,0x6da60080,0x5f06006b,0x3f840046}},	//   _každ, аива, рзва, ěmu_
  { {0x32da0008,0x63a31576,0x9f43008c,0x973c0085}},	//   _שחקנ, _honn, eljä_, _moća
  { {0x2d800f75,0x63a31577,0xa91d1578,0xec7a0063}},	// [2100] rdie_, _konn, _mažd, ъпа_
  { {0xeab20029,0x60fb000a,0xaec6005e,0x103b000a}},	//   يعا_, _בהפק, _вбол, _שגיע
  { {0x69cb1579,0xbad50033,0x8f9b000a,0x63a3157a}},	//   fige, біцы, _סיטי, _monn
  { {0x69cb00b8,0x63a30c0b,0x291200cb,0x49ca006b}},	//   gige, _lonn, øya_, ълен_
  { {0x443f005c,0x2089000a,0x38cb002b,0x91fd003d}},	//   jsu_, ָתוֹ_, پانی_, ltāc
  { {0x98a40089,0xc66a0080,0xe72f0015,0x91fd003d}},	//   _země_, вшие_, وصى_, otāc
  { {0x29560063,0x69cb00b8,0xf6570029,0x91fd0024}},	//   _възр, bige, لجيش_, ntāc
  { {0xd378016f,0x18a60036,0xaa5700c3,0x6705000b}},	//   moći_, _кабм, _خلفا_, षेधक_
  { {0x2616014e,0xb0c5005d,0x63a30493,0x98af0045}},	//   _पूरी_, _लेंग, _bonn, ragă_
  { {0x63a30287,0xb8650015,0xe3af0015,0x7982157b}},	//   _conn, _دافو, ِرَ_, ldow
  { {0x6d4604af,0x63a3073e,0x7982002a,0x67ed0030}},	//   _odka, _donn, odow, gúju
  { {0x7c26016f,0xd6cf0029,0x7982157c,0x31c70235}},	//   _otkr, _تقم_, ndow, рсов
  { {0x84630063,0x55bb000a,0xc5f3000a,0x90540033}},	//   _дъще, _במאו, _ודף_, овяц
  { {0x4426025c,0xe3b70010,0xd103000b,0x9257002b}},	//   _ito_, _кліч_, रेषण_, دشیر_
  { {0x639b0008,0xc3fb01d8,0x7c260095,0x33fb000a}},	//   _בסגנ, _שלוש, _atkr, _שהונ
  { {0x7982005c,0x4426066f,0xa91d02c6,0xf531000a}},	//   jdow, _kto_, _kaže, ּ֥ן_
  { {0x61ed0035,0x30a40010,0xdb1e00f2,0x69cb157d}},	// [2110] _ikal, _дрэв, kipä, vige
  { {0x4426000c,0xa91d0007,0x69d80152,0xdb0e00dc}},	//   _mto_, _maže, éven, _elbí
  { {0x69cb157e,0x39150015,0x5fdc000a,0x89370015}},	//   tige, مواز, _בחזק, لعشا
  { {0x8d950029,0x6440157f,0x443f0b90,0x44260ed2}},	//   _الحش, ksmi, ysu_, _oto_
  { {0xfd960008,0x79800026,0x61ed003f,0xbcfb0152}},	//   _הדרך_, _damw, _mkal, _obéi
  { {0x6d580064,0xdb1e0020,0x628a0026,0x7982002a}},	//   ıbaş, gipä, _orfo, adow
  { {0x3f8100d9,0x64420493,0x753b003f,0x5fb8000a}},	//   _mahu_, _avoi, tauz, שהוא_
  { {0x81bd03eb,0xc1c6005d,0xdddc044c,0x63a31580}},	//   spēj, _लगेग, ovrš, _sonn
  { {0x628a0026,0x69c9003f,0x63a31581,0x85c40015}},	//   _arfo, _imee, _ponn, تغوم
  { {0x443f1582,0x63ba1583,0x6395004a,0x61ed1584}},	//   rsu_, ghtn, сшиф, _akal
  { {0x443f0084,0x44260176,0x6d5d002d,0xf77000a2}},	//   ssu_, _eto_, _ocsa, _زال_
  { {0x5999000a,0xc19a005e,0x443f1585,0x63a31586}},	//   אשֹׁ, утої_, psu_, _wonn
  { {0x628a018b,0x95c40029,0x973c016f,0x297a0053}},	//   _erfo, _بينه, _moćn, נטשא
  { {0x7982005c,0x63ba02f7,0x23260ffe,0x63a3008c}},	//   zdow, chtn, _лоши_, _uonn
  { {0xdfcf0196,0x539a000a,0xa91d1587,0x7982002a}},	//   ريف_, _תיצו, _zaže, ydow
  { {0x451900b2,0x3d280086,0xfd95005e,0xe058002b}},	//   רוּװ, شتری_, ошую, _پیست_
  { {0x6da31588,0xada3008a,0x6bda0058,0x8f760138}},	// [2120] чита, чатл, هورس_, _луні
  { {0xa3ca005d,0xdd3c005c,0x2259005c,0x69c9048c}},	//   रोप_, lążk, ńsku_, _amee
  { {0x8e861589,0x0a4a0a61,0xdddc016f,0xad9b002d}},	//   _الجه, узей_, avrš, _dhúb
  { {0xe93a0029,0xe9da0080,0x79821515,0x6d4602de}},	//   اسات_, ыке_, udow, _udka
  { {0x7982005c,0x60000123,0x67ed0030,0x69c80091}},	//   rdow, römf, yújt, _įded
  { {0x98730010,0xd0f7000a,0x207b004c,0xa6660021}},	//   яліц, זמנת_, טאנא, مطبو
  { {0x77910086,0xa91d016f,0x7982020d,0xdb1e0209}},	//   ظیما, _saže, pdow, ripä
  { {0xa91d0007,0xfad70008,0xdb1e0e95,0x6446158a}},	//   _paže, _הולך_, sipä, škim
  { {0x2d82003e,0xd7f20015,0x81bd003d,0x32f70016}},	//   _make_, _فكر_, spēk, _ãy_
  { {0xf8a70086,0xd4e30080,0xa91d016f,0x61ed158b}},	//   _دگمه_, яющи, _važe, _skal
  { {0xc7b30008,0xe2f80036,0x9f8d0089,0xdddc0796}},	//   _צבע_, рені_, uží_, zvrš
  { {0xdb1c002e,0xa1590010,0xad9b002d,0xc2b7005e}},	//   _umræ, шаму_, _mhúc, слює_
  { {0xafdb0bfa,0x673a00f2,0x3f8101d7,0x4426158c}},	//   drør, _ketj, _pahu_, _uto_
  { {0x82330086,0xe8d7000a,0x14d7000a,0x4394135e}},	//   _کروا, מוכר_, _פוגל_, _факс
  { {0x25a60171,0xc7d7000a,0x673a158d,0xe2970099}},	//   _kool_, צולי_, _metj, _гај_
  { {0x463b0053,0xd257000a,0x69d80003,0x2d8204a9}},	//   טעלע, _השהה_, ével, _cake_
  { {0x3f81013c,0x21f90057,0xdb0e0144,0x4c94158e}},	// [2130] _tahu_, lého_, _albà, питс
  { {0x2d87002a,0x75d30045,0x69c9158f,0x673a042f}},	//   śne_, răzi, _smee, _netj
  { {0x21f90107,0x2d82055e,0x68fb0030,0x1df90132}},	//   ného_, _fake_, _szud, _вены_
  { {0xd378016f,0x725b0053,0xad9b002d,0xbc9501ca}},	//   moću_, רכאפ, _dhúc, _дамј
  { {0x21f90107,0x673a1590,0x973c0085,0xe7390477}},	//   hého_, _betj, _voćn, аел_
  { {0x21f90156,0x2d82003f,0x7e8b000a,0x7c2d1139}},	//   kého_, _zake_, ָאֵ֖, mpar
  { {0x2d82000c,0x56920001,0x1f5c004c,0x2f5c000a}},	//   _yake_, дајт, אדוא, אדונ
  { {0x75d50015,0x79a7012e,0x142510b7,0x95c50015}},	//   تيعا, _урге, одим, تيبه
  { {0x57d5000d,0x28f8005e,0x6f000030,0xe3b91591}},	//   _доаѓ, _геть_, _kábí, иби_
  { {0xd874006e,0x87d7006e,0x7c2d1592,0x53c9107f}},	//   _عاقب, _اغرا, ipar, ргом_
  { {0x69d9005c,0x25a6055e,0x27e00125,0xcb8c000a}},	//   onwe, _fool_, éine_, רְחֹ
  { {0x7c2d1593,0x04950015,0x69d90012,0xe60e005e}},	//   kpar, _ولاح, nnwe, _ід_
  { {0xa8790053,0x15180015,0x69d90012,0xdbc6007c}},	//   באָר, _ازمة_, inwe, mööb
  { {0x2d821594,0x44070b44,0x21f901c0,0x442d1595}},	//   _sake_, _учеб, bého_, mpe_
  { {0x2d8200e8,0x442d1596,0xdd92006e,0x7c2d1597}},	//   _pake_, lpe_, ووس_, epar
  { {0x8d660010,0x60000123,0x4d660033,0x91fd003d}},	//   ўвае, döme, ўкав, ltān
  { {0xfaf80048,0x90c3005f,0x7c2d0035,0x71650015}},	// [2140] _šī_, _объе, gpar, _رايك
  { {0x0b4605d1,0x2d820705,0x442d1598,0xe81d000b}},	//   інен, _wake_, ipe_, _पढ़ा_
  { {0x2d821599,0x65b50264,0xafdb00cb,0x60000123}},	//   _take_, _náho, prør, römd
  { {0x673a05d8,0xf2d2004c,0x7c2d00c7,0x65b50046}},	//   _setj, ועב_, bpar, _sáhn
  { {0x7c2d016e,0x65bc0030,0x673a159a,0x661a09bb}},	//   cpar, _jéhe, _petj, _sutk
  { {0xe7930001,0x64460091,0x661a01be,0x1b76002b}},	//   дишњ, škik, _putk, _بدحج
  { {0x442d159b,0x25a60100,0x8f1b000a,0xd6d00015}},	//   epe_, _pool_, בוצת, عقب_
  { {0x21f90264,0x746a009f,0x7a0c0045,0xe46a0004}},	//   vého_, аров_, _oşti, ашол_
  { {0x65b50046,0xc4f70015,0x673a0030,0x276b002b}},	//   _táhn, يعًا_, _tetj, _چشمی_
  { {0x661a159c,0x21f90107,0xa7b8000a,0xccf3000a}},	//   _tutk, tého_, _פֶּת, וכח_
  { {0x74140086,0x85460010,0x4bfb0053,0xe57a0063}},	//   _کوتا, _дэле, שליס, _взе_
  { {0x21f90227,0x41c70033,0xd46a159d,0xda7b000a}},	//   rého_, іёна, _виде_, בנטר
  { {0x55d900b2,0x14c70080,0x3866159e,0xbf67002b}},	//   _פֿענ, _мыши_, ntor_, يدآو
  { {0xa91d0007,0xb4c8000b,0x9f430069,0x3866159f}},	//   _maža, ोपी_, pojí_, itor_
  { {0xa1870010,0x179b000a,0x81f70015,0xdb21001a}},	//   _дыпл, סילב, _وأعط, ótís
  { {0x65b501b2,0xb2bb000a,0x2251006f,0xdb060046}},	//   _náhl, _כמור, ázke_, ímýc
  { {0xf1bf002f,0xa91d0b6c,0xc05b005e,0xab2b0015}},	// [2150] mhá_, _naža, _тій_, لسال_
  { {0x2bbb0029,0x7c2d15a0,0xfe500061,0xfc300015}},	//   جارة_, rpar, üçük_, ضحك_
  { {0xd378005c,0x7a4003d9,0x8f88000a,0xf989002b}},	//   ieć_, _rátá, _וְרֵ, یخچه_
  { {0xa3ca014e,0x4e7a0053,0x12150053,0x7e7a0053}},	//   रोत_, _פארצ, פֿער_, _פארז
  { {0xf1b401e4,0xd8b800e6,0xbd9a000a,0xc87b0004}},	//   וסף_, يدها_, _הסרת, рџе_
  { {0xec360008,0x907c0008,0x00580008,0xa91d121a}},	//   _מאשר_, שְׁפ, קשות_, _daža
  { {0x1f38000a,0xb9350054,0x386615a1,0x9aa502be}},	//   חרור_, _невј, ator_, _عمرو
  { {0x31790050,0x19580033,0xd6780015,0xd5e80015}},	//   jesz_, _масы_, تحها_, يعين_
  { {0xe4510029,0x442d15a2,0x386603b0,0x65690012}},	//   رضة_, upe_, ctor_, rfeh
  { {0x75d30011,0x442d15a3,0x65b50227,0xe4c80015}},	//   văzu, rpe_, _záhl, غبين_
  { {0xa3ca014e,0x656900b8,0xfbd2000a,0x37c40015}},	//   रोध_, pfeh, תתי_, _تيلف
  { {0x216a0a61,0xe8e00092,0x98af005c,0x442d0362}},	//   щими_, uyệt_, wagę_, ppe_
  { {0x251a000a,0x439501e5,0x00da0015,0x40330033}},	//   _הונא, _надс, صبحت_, неўс
  { {0x02450015,0x3cef000b,0x660915a4,0x3f6a0054}},	//   _فَتَ, _आड़े_, lmek, љиво_
  { {0xa3b80002,0x433a000a,0xe3b2004c,0x22590015}},	//   _ظاهر_, _העצב, _אױג_, _العد_
  { {0x31790050,0x6da30001,0x91fd0024,0xd24e0029}},	//   cesz_, ниса, ntāl, _إني_
  { {0x90460029,0x1d070a6c,0x515b000a,0x71d7000a}},	// [2160] _عنده, зети_, _הכפו, _מוקד_
  { {0xab1a0010,0x0e6615a5,0x386600bc,0x660915a6}},	//   сцах_, _екон, vtor_, hmek
  { {0x660915a7,0x38660034,0xdbd9001a,0x8f1b004f}},	//   kmek, wtor_, ræðs, _לוית
  { {0xd378005c,0xa91d0007,0x58860139,0x7e9b000a}},	//   zeć_, _paža, зыка, _הסטו
  { {0x66090020,0x59bd000b,0xd90d002b,0x0395003d}},	//   dmek, ्फ़र, لیف_, _ķīnā_
  { {0xa91d016f,0x386615a8,0x31791022,0x66f40004}},	//   _važa, rtor_, zesz_, мплу
  { {0x3e870046,0x200a0045,0xf1bf006f,0xdce60091}},	//   mítá_, imbi_, yhá_, _pakė
  { {0x0576003b,0x9adb0008,0xd5b00029,0x386615a9}},	//   ساعد, _החלט, ئفة_, ptor_
  { {0x6d4b002d,0xa91d0085,0x83860033,0x83fd0030}},	//   ógai, _kažn, пыне, rtőn
  { {0x88bb0008,0x644f15aa,0x58bb000a,0x6609003d}},	//   _הזמי, ácia, _הממצ, amek
  { {0x2c6615ab,0x217908f0,0xdcfd003d,0x9314009a}},	//   hôd_, ойны_, _masā, بودش
  { {0xf1bf0089,0xdcfd0024,0x5afb000a,0xa91d02c6}},	//   uhá_, _lasā, מליצ, _lažn
  { {0x442004f9,0xbcfb15ac,0xa3b7002b,0x7bce15ad}},	//   _îi_, _océa, زایر_, _ombu
  { {0xad9b15ae,0x7538002a,0xdfdb006b,0xf2e6006b}},	//   _chún, ńczą, съм_, _нюйо
  { {0x33fb0008,0xad9b002d,0x93fb000a,0x4383002b}},	//   _ההגנ, _dhún, _הלגי, _سليق
  { {0x22f70008,0xe4570053,0x9df901c6,0x7bce15af}},	//   _מזון_, _אָנזאָ, інат_, _ambu
  { {0xa91d0007,0x7c15005e,0xc1050015,0x6285001a}},	// [2170] _bažn, ддає, _توظي, _áhor
  { {0xd9b5000b,0x0005002b,0x91fd003d,0x103c000a}},	//   ंस्ट, _تثبی, itām, _הגזע
  { {0xa91d00df,0xfe24056d,0x4a44005e,0x660915b0}},	//   _dažn, _пьян, енєв, ymek
  { {0x6aaa00c0,0x63aa0034,0xc27b000a,0x61ef07ee}},	//   äffa, _lofn, מרבי, nocl
  { {0xdbc700f2,0xc794002b,0x2d9903e6,0x98170058}},	//   töäs, کشنب, _inse_, أبصا
  { {0xbcb60008,0xbcfb002d,0xdc9a0008,0xa69500d7}},	//   _חפשו_, _gcéa, _וישל, дриј
  { {0x660915b1,0xe6640054,0x600c000a,0x25bf00aa}},	//   tmek, етњо, צִדְ, thul_
  { {0x25bf0020,0xafdb00cb,0xa3ca000b,0x7de50091}},	//   uhul_, ruøy, रोस_, bėse
  { {0x91fd03eb,0xed600089,0x660915b2,0x44390006}},	//   rtāl, ížit_, rmek, ès_
  { {0xe3b10029,0x63aa10bd,0xd7c80015,0x9f5e0061}},	//   ئرة_, _cofn, _فوقه_, ötü_
  { {0x66090024,0x2d990079,0x91e60f78,0x0000006a}},	//   pmek, _onse_, доне,
  { {0x44b515b3,0xa91d0007,0x36040058,0xc033005a}},	//   _обес, _mažo, _كولف, ěšné
  { {0xa3ca005d,0x95540058,0x69d801f6,0x0000006a}},	//   रोह_, _أخما, évei,
  { {0x63aa0026,0x2d8900aa,0x200a036d,0x6b8715b4}},	//   _gofn, edae_, umbi_, _najg
  { {0xc332000a,0x248d15b5,0x61ef016e,0x81bd003d}},	//   _יוג_, lvem_, bocl, tpēt
  { {0xbcfb002f,0x2176017f,0xbdda005e,0x0000006a}},	//   _scéa, _цукр, ієві_,
  { {0xdcfd0024,0xa91d016f,0xceb80007,0x3c660033}},	// [2180] _pasā, _pažn, šę_, ькаг
  { {0xaaba0086,0xa08b000a,0x2057000a,0xfd110015}},	//   يدار_, _וְטִ, _קייל_, اجِ_
  { {0xa91d010b,0x4f9b000a,0x9f9b000a,0x8268000a}},	//   _važn, _וביצ, _וסיפ, ּ֣עַ
  { {0xa91d0024,0xed5a002b,0xd99a0015,0xe8fa15b6}},	//   _dažo, _بشدت_, تنصت_, оле_
  { {0x58370033,0x7d7b000a,0xa87a0021,0x6d4415b7}},	//   дзія_, _ונכו, تحار_, maia
  { {0x6283060b,0x98a30001,0x8c43023e,0x95f8000b}},	//   _osno, тиље, _јере, ुष्ट_
  { {0x5a550063,0x6009000a,0x248d016e,0xba2315b8}},	//   _пъту, הִקְ, evem_, _адск
  { {0x77b408e0,0x1dde005d,0x986a0015,0x3949001a}},	//   _màxi, नचित, _وحذف_, óast_
  { {0x186a027c,0xe76600af,0xa01b02ad,0x0000006a}},	//   _фази_, _овап, iwöc,
  { {0xc6760029,0x69c215b9,0x4c9b000a,0x7bde047f}},	//   _يطاب, lhoe, קביו, nnpu
  { {0xcb570008,0x5b570c44,0xc7d7000a,0x6d4415ba}},	//   וסיה_, ושין_, _קובי_, kaia
  { {0xf5930029,0x85060002,0xa1940484,0x22510107}},	//   _للمج, _قوان, ваюч, ázka_
  { {0x4613002b,0x3cfa000b,0x2259002a,0x64b60015}},	//   _شوهر, ्धों_, ąska_, _تحار
  { {0xe3af0015,0xafdb00cb,0x6000008c,0xb4fb000a}},	//   _نرى_, msøk, töma, _ולדר
  { {0xafdb003c,0x05b2000b,0x11d70015,0x3377000a}},	//   lsøk, _जवाब, _يتعد, _חתוך_
  { {0xe3b80064,0xa91d0024,0x41e70015,0x64460091}},	//   lkı_, _ražo, _تستف, škiu
  { {0x8c19002b,0x113c000a,0x51f4002b,0x5bb90174}},	// [2190] سيار_, _ותחל, _جسور, плая_
  { {0x69c20079,0x441b000a,0x2d8900aa,0xe3b80061}},	//   ehoe, קובס, sdae_, nkı_
  { {0x248d0089,0xb17b02d2,0x6fd40015,0x5a350238}},	//   zvem_, pnåd, _جزيئ, хнет
  { {0x7eb6000a,0xd5a60002,0x317c004c,0x69c2042f}},	//   _נהרס_, _صف_, ַרומ, ghoe
  { {0xe3b80064,0xfd56000a,0x99d400c3,0x89d40015}},	//   kkı_, _אשרי_, ختلا, ختلط
  { {0x65bc0003,0xe0b8000a,0xdc3a05bd,0xe79b00c3}},	//   _réha, ולדט_, _מעשר, تخصص_
  { {0xafdb003c,0x6f7a000a,0x0000006a,0x0000006a}},	//   esøk, לְקו,   ,
  { {0xff180008,0x91fd0024,0x34a90054,0x248d0046}},	//   וקות_, stāj, звио_, tvem_
  { {0x600000c0,0xd5e80015,0xf8f40033,0xafdb00cb}},	//   dömn, بعون_, _аптэ, gsøk
  { {0xf7700074,0x6560002f,0xa3ca005d,0x87070015}},	//   _نام_, agmh, रोल_, _قبال
  { {0xeb9215bb,0xe29915bc,0xbb3a000a,0xc6a40004}},	//   אָר_, чан_, העתי, _ирци
  { {0xdb070084,0xcb12000a,0x1df9000b,0x56b6004c}},	//   _hljó, טלי_, ंतोष_, _אפען_
  { {0xb1430010,0xd4c40015,0x60b6002b,0xdb050012}},	//   ынял, _لغوي, رمسئ, chhö
  { {0xe4560053,0x78a400f2,0xa2e5004a,0x8f7502a3}},	//   _ניצט_, äivi, _полд, кусі
  { {0x670f005d,0x69c20026,0x64460007,0xa91d016f}},	//   ाधिक_, yhoe, škit, _pažl
  { {0x62860024,0x752915bd,0x70560015,0xdca615be}},	//   ākot, ncez, _كنعا, наби
  { {0x6b5615bf,0x644915c0,0x998d002a,0x6d4415c1}},	// [21a0] فضائ, nsei, _mień_, raia
  { {0x799b02e8,0xa037000a,0x6d4415c2,0x644915c3}},	//   _anuw, _ראיה_, saia, isei
  { {0x69c215c4,0xc0a90086,0x6d440375,0x2f3b000a}},	//   thoe, _فایل_, paia, _מגיד
  { {0x3940002d,0x644915c5,0x590a006b,0xb2ba000a}},	//   úis_, ksei, пеем_, המער
  { {0x69c20409,0xad1b000f,0xd9170033,0x83fd0030}},	//   rhoe, _מוכר, ньш_, rtőj
  { {0x7aeb0030,0xc7a3011a,0x64490d34,0x798b0034}},	//   élté, личк, dsei, adgw
  { {0x644b0971,0xeb91000a,0x644915c6,0xb60500bf}},	//   _avgi, _דָן_, esei, znáš
  { {0x38cb0086,0xafdb003c,0xa91d00bd,0x7b060024}},	//   _کافی_, tsøk, _lažj, ērtē
  { {0xdb070084,0x91fd0024,0x69c015c7,0xe3b80061}},	//   _fljó, stāk, _ilme, tkı_
  { {0x61e4000c,0xa3ca005d,0xafdb003c,0xe1fb005d}},	//   _ajil, रों_, rsøk, ृष्ण_
  { {0xa1590124,0x26d800c0,0x26c7005c,0xe3b80064}},	//   ману_, _äro_, czno_, rkı_
  { {0xe3b80064,0x644900b8,0xb6bb0008,0xf2c30033}},	//   skı_, bsei, _מצבי, усьн
  { {0xe3b80061,0x64b3006e,0xdfd10015,0xecd0000b}},	//   pkı_, _محور, ليح_, _सेलफ
  { {0x69c000cb,0xdb1e007c,0x30a4005e,0xa01b001a}},	//   _llme, gipü, урюв, fvör
  { {0x02930015,0x65bc0003,0x63b50030,0xb6050046}},	//   _مؤيد, _jého, özne, snáš
  { {0xb7b50016,0x02fb000a,0x7a470046,0x290400c7}},	//   _kịc, _מלומ, _létá, _ozma_
  { {0xf3f90045,0xfc300021,0x6ad90065,0xa01b15c8}},	// [21b0] suţe_, محل_, भप्र, rvös
  { {0xe800000b,0x69c015c9,0x61fd15ca,0x8ae700ce}},	//   _लीला_, _alme, llsl, ніел
  { {0xb7b50092,0x2bb80015,0x8ae7005e,0xdcef003d}},	//   _lịc, راكة_, хіал, _pacē
  { {0x91f60092,0x32370053,0x644900f2,0xdeb6000a}},	//   hún, גטאן_, ysei, _יפתח_
  { {0xf7710015,0xec150015,0x18690004,0x61fd02de}},	//   لاث_, _لوحد, фали_, ilsl
  { {0x2d8b0467,0xa91d0007,0xa6990001,0x64490020}},	//   _hace_, _kažk, дњих_, vsei
  { {0xedcb000a,0x998d002a,0x4ddb004f,0x2f98004f}},	//   ּמִֽ, _pień_, ּח֥ו, תכון_
  { {0x644915cb,0x66240015,0x644f0085,0x442f0c48}},	//   tsei, دروك, šcim, _ptg_
  { {0xd5ae0029,0xe3b10015,0xb4bd000b,0xb9e4005e}},	//   تفي_, لرد_, ीछे_, _сіри
  { {0xb7b50023,0x644915cc,0x98170015,0x2d8b00da}},	//   _dịc, rsei, _أبرا, _lace_
  { {0x1309005f,0xbcfb0003,0x443d15cd,0x9f8f0012}},	//   ьной_, _scél, _www_, _süß_
  { {0x32090092,0x2d8b0077,0x201a02f2,0x9f4a04b2}},	//   _chay_, _nace_, _sipi_, robí_
  { {0xe588000a,0x9f4a0107,0xb05b0012,0x33950015}},	//   _רָעָ, sobí_, nzäh, _للإز
  { {0xdce6006f,0x61fd0052,0x0000006a,0x0000006a}},	//   ámče, alsl,   ,
  { {0x201a003f,0xdb070046,0xb05b02ad,0x2d8b0160}},	//   _vipi_, _bojí, hzäh, _bace_
  { {0xc69201ac,0xa91d003d,0xf652004f,0x0000006a}},	//   סאן_, _dažk, יצל_,
  { {0xdb070089,0xad2500a2,0x11d70015,0x7bd70045}},	// [21c0] _dojí, ارفو, _جوية_, fixu
  { {0x291f02c1,0xdce40024,0xa01b002e,0xf38c0053}},	//   _agua_, ediģ, svör, ּראָ
  { {0x68fb0467,0xcf570008,0x0f570632,0x0b590010}},	//   _ayud, _בבית_, _ביים_, эрты_
  { {0xfbc90008,0xf1bb0016,0x29d50046,0x7a470030}},	//   חת_, _luơn_, sťan_, _sétá
  { {0x07a60010,0x2d80046d,0x764a0034,0xc7c6033d}},	//   кадн, meie_, wsfy, кски
  { {0xc7af0015,0xd7f7006b,0x2d8000cb,0x8ccb000b}},	//   يّن_, кущ_, leie_, _सेटो
  { {0xfaa315ce,0x692615cf,0xbb77000a,0x96340054}},	//   _каро, _амба, _שעלו_, ћниц
  { {0x5e5700b2,0xceb30008,0x96b70001,0xa533006b}},	//   דיקע_, שיה_, ђују_, анъч
  { {0x8a17000a,0x65b50077,0x3957004f,0xe8f700af}},	//   _יחלו_, _náhu, _ששמם_, _алт_
  { {0x2d8004f9,0x65bc0046,0x212001c2,0xa785012c}},	//   heie_, _tého, _agih_, _مشمو
  { {0x2d80020a,0xd7ef0029,0x0bb70008,0xe3af0115}},	//   keie_, _بكل_, דלים_, تري_
  { {0xb6d90053,0x04960029,0x3035004a,0xa5da006e}},	//   _אַנט, _للصح, лемё, _غبار_
  { {0x2d8b0b62,0x3eb8001a,0x0000006a,0x0000006a}},	//   _race_, eyrt_,   ,
  { {0x040d0016,0x403401c5,0xa4b7004f,0x0000006a}},	//   _mườn, рерс, _בלדה_,
  { {0x320900a7,0xa6f8000a,0x0dbb0015,0x040d0016}},	//   _thay_, גִּי, وارث_, _lườn
  { {0x1317000a,0xdddc14a7,0xc536004f,0x0000006a}},	//   _בחול_, avrž, דָ֑ה_,
  { {0x1df80080,0xf3f90045,0xdcf40015,0xe1ff0030}},	// [21d0] теты_, luţa_, لأكب, mló_
  { {0xf0920008,0x1b7b0029,0xad9b002d,0x309a000a}},	//   _פני_, بصرة_, _mhúi, _נשתמ
  { {0xcb680015,0xc9590015,0x2d8b15d0,0x7afc0416}},	//   ضمنه_, فلاش_, _tace_, _cyrt
  { {0xe1ff00dc,0x83fd0030,0xe945002b,0xa91d06c0}},	//   nló_, rtői, ارای, _kaži
  { {0x3da4008f,0x040d0092,0x7c22002d,0x7dda0091}},	//   _трэб, _cườn, íort, rįst
  { {0xa91d00df,0x040d0092,0x1d16000a,0xb05b0012}},	//   _maži, _dườn, _תקשר_, rzäh
  { {0xf770087c,0xb05b0012,0x3619004a,0xa6640015}},	//   تان_, szäh, нцию_, لطيو
  { {0xd5b10092,0xdddc0046,0x394400da,0xb867002b}},	//   _nút_, zvrž, _gems_, _لائو
  { {0x58840010,0xad9b002d,0x4415006b,0xe576056d}},	//   _выха, _chúi, лфот, узы_
  { {0xd7740086,0x39440024,0x69d912d1,0x60001581}},	//   _نامع, _zems_, liwe, tömm
  { {0x614615d1,0xd5b10016,0xd57508f7,0x216a15d2}},	//   лена, _bút_, _буль, нини_
  { {0xcf89000a,0xfa76000a,0x600015d3,0x69d915d4}},	//   _מט_, נערת_, römm, niwe
  { {0xd24e0074,0xe3b30074,0x753b003f,0xe4c80015}},	//   ينی_, _پرش_, mbuz, _لبون_
  { {0xd8da0008,0xe1ff00dc,0x24530086,0x645b0079}},	//   תקשר, aló_, _منچس, mrui
  { {0x3ebe002e,0xa91d0024,0x2eb50080,0x69d9003f}},	//   átt_, _daži, астс, kiwe
  { {0x45b50053,0x0c3a0015,0x01660923,0x3f8c0d7c}},	//   נפּל_, فكرة_, _скио, ždu_
  { {0x69d90026,0x7afc0026,0x672100bc,0xec7a0033}},	// [21e0] diwe, _syrt, _oglj, эпа_
  { {0x8b260805,0x3ea615d5,0xac970058,0x9f86009b}},	//   удже, _биог, دنكا_, _сгод
  { {0x645b002f,0x0309000a,0x9a460015,0x6f4b000a}},	//   hrui, תִּֽ, اضطه, _אֲכַ
  { {0x91fd0024,0x5cf60010,0xb2f60053,0x38cb0086}},	//   stāv, _бягу, אצעס_, کامی_
  { {0x6d46121a,0x7afc0034,0x98560ac9,0xb85600af}},	//   _ieka, _wyrt, утеш, уђењ
  { {0x91fd0048,0xa6340036,0x645b15d6,0xe1ff0030}},	//   ltāt, анкі, drui, zló_
  { {0x6d460375,0xf1c10264,0xf76f00c3,0x645b0079}},	//   _keka, ášky_, ساو_, erui
  { {0x040d0092,0x54540893,0x4e37004c,0x91fd003d}},	//   _tườn, авит, אָזן_, ntāt
  { {0x136a0063,0xd5b10092,0x86070015,0x48e6004a}},	//   ншни_, _rút_, دقيق_, _соав
  { {0xf626005e,0x6d4615d7,0x4274125c,0xd7b80065}},	//   _бджо, _leka, агос, _अविच
  { {0xb345001c,0x2bf70053,0x7c26108a,0x41b50015}},	//   _seçã, רמין_, _lukr, لمدر
  { {0xd257008f,0x645b15d8,0x6d4615d9,0xd5b9004a}},	//   ыць_, brui, _neka, _а́ю_
  { {0x7c2600df,0xf3f90011,0xa91d0007,0x50670010}},	//   _nukr, suţa_, _paži, ытна
  { {0xa3e8005d,0x69d912d1,0x4fc709c3,0xee870033}},	//   _यदि_, ziwe, усма, лыбо
  { {0x4426000c,0xfebb002b,0xe1ff0030,0x6d4615da}},	//   _huo_, راست_, pló_, _beka
  { {0x44260007,0x98c4000b,0x6d4615db,0xc2530015}},	//   _kuo_, वनाए, _ceka, _اخوت
  { {0x44260007,0x8bd50010,0x69d9003f,0x41c40031}},	// [21f0] _juo_, ажац, viwe, _دقيق
  { {0xf1bf0089,0x7c260091,0x69d80003,0x4aeb004a}},	//   lká_, _dukr, èven, ньем_
  { {0x4426022d,0x99350029,0xb9250058,0x3f830160}},	//   _luo_, لفات, لفضي, meju_
  { {0x3ebe0af5,0x89370021,0x19590033,0x6d460009}},	//   øtte_, اعضا, тады_, _geka
  { {0x442600df,0xa9480086,0x3158004c,0x80db000b}},	//   _nuo_, الهٔ_, רידן_, _पेमे
  { {0xfe700086,0x7bd500b8,0x629815dc,0x65b50227}},	//   _بدی_, _umzu, _orvo, _náhr
  { {0xdb05002e,0xf1bf0307,0x6d4615dd,0x0000006a}},	//   rkhó, kká_, _yeka,
  { {0x44260035,0x370a000b,0x645b15de,0x649915df}},	//   _buo_, ाधड़ी_, trui, втор_
  { {0x6298022d,0x05a60080,0x645b14e9,0xf7490015}},	//   _arvo, рвый_, urui, _للذي_
  { {0xe2990124,0x6721016f,0xf7730002,0x60000123}},	//   вао_, _uglj, _دار_, römk
  { {0xd5ae0086,0x8bd6000a,0x11d60015,0xd7c80015}},	//   سفی_, שותו_, لتحد, _حوله_
  { {0x11d6005e,0x3f91003d,0xe63a004f,0xd6d80138}},	//   ріор, edzu_, _יתעכ, _сту_
  { {0x62980111,0x628a15e0,0x55ba000a,0x03a50c9a}},	//   _ervo, _esfo, _שמנו, _вило
  { {0x25ad0020,0x91fd0024,0x88ba0053,0x6d4615e1}},	//   ljel_, tuāc, דזשי, _seka
  { {0xf2330086,0x6d4615e2,0x7c2615e3,0x33da004f}},	//   _ابتک, _peka, _sukr, _בחסד
  { {0xf1bf0156,0x6717005d,0x25bf15e4,0xdee3005e}},	//   cká_, धेयक_, nkul_, іоти
  { {0x8fc50086,0xcce50015,0x0b4608a6,0xec160015}},	// [2200] _گزين, مسكي, инан, لورد
  { {0x91fd15e5,0x1d190a31,0x909b000a,0x7dc3007c}},	//   grāf, уюсь_, _יספק, _võsa
  { {0xa92615e6,0x6d460509,0xaf5b000a,0x2f5b000a}},	//   адел, _teka, _בכיכ, _בדינ
  { {0x25ad0030,0x98bd002a,0x61e615e7,0xa95a0058}},	//   jjel_, zawą_, nnkl, ئجار_
  { {0xdb070089,0x61e60007,0x83fd00dc,0x6d3b0008}},	//   _vojá, inkl, ntős, _בתכנ
  { {0x91fd0048,0xd90d0086,0xf1bf01b2,0x06540015}},	//   ntār, ریل_, zká_, منتح
  { {0x442602d7,0x64420050,0xdb0700dc,0x4b7b000f}},	//   _suo_, _swoi, _tojá, _שאלו
  { {0xafdb06f5,0xbcfb002d,0xd5b7004a,0xd910002b}},	//   nsør, _scéi, исы_, _فیض_
  { {0xa4d40010,0x98bd002a,0xdb1e007c,0x442603f0}},	//   сопі, tawą_, gipö, _quo_
  { {0xa5070001,0xa91d0007,0x61e6093b,0x62980c1a}},	//   шења_, _pažv, enkl, _prvo
  { {0x3f830007,0xa91d0024,0x98bd002a,0x03c30033}},	//   veju_, _dažu, rawą_, ісьм
  { {0x64420050,0x442615e8,0x76bb000a,0x28db000b}},	//   _twoi, _tuo_, _שמאפ, _मेडि
  { {0xdb0e0064,0xe3af0086,0x75d3012c,0x43940148}},	//   _albü, سری_, _بينا, _галс
  { {0xf1bf0f1b,0x63f30015,0xdfdb006b,0x33f30067}},	//   ská_, _وأور, тъм_, _وسوس
  { {0xdeb40174,0x3f8315e9,0x753d0030,0x5337004f}},	//   обры, reju_, űsze, _דנון_
  { {0xd657000a,0x7ae1006f,0x82330040,0xdb1e007c}},	//   יילת_, _žlto, _بروا, nipõ
  { {0x91fd0024,0x4c940731,0x26e2000b,0x7de50091}},	// [2210] stās, оитс, गपुर_, lėsk
  { {0x60c00293,0xde67006b,0x3dc915ea,0x3c440058}},	//   ømme, _къмп, shaw_, تَكِ
  { {0x6e95003b,0x2003044c,0xee870033,0x3a750249}},	//   _الجا, mlji_, _тыпо, слер
  { {0x62860050,0x39150010,0xf9d4005e,0xaa58098b}},	//   łkow, бмер, оцію, рицу_
  { {0x9f510089,0x2259002a,0x1821000b,0xb4e5000b}},	//   hozí_, ąski_, मदेव_, _नशे_
  { {0x6000008c,0x8a370015,0x29d5016d,0x0000006a}},	//   tömi, _نعرض, zťah_,
  { {0x91fd0024,0xc7c80010,0x45d50063,0xcf58000a}},	//   orād, шыце_, йцит, בבות_
  { {0x59f9005f,0x3940002e,0x77bd0251,0x6d4d0b63}},	//   _себя_, ðist_, _mèxi, naaa
  { {0x7bc715eb,0x04560029,0x26c1002c,0x64c50029}},	//   _klju, ملية_, šho_, صيدل
  { {0xb8dd005d,0xd6db0923,0xe7300015,0x6498006b}},	//   ुई_, _ите_, _قصم_, ртър_
  { {0x57fa0053,0xf089000a,0x8b88000a,0xdb1e007c}},	//   _עלעו, _רנ_, בָרֶ, bipõ
  { {0xd3780085,0x930d0061,0xad9b0125,0x91e615ec}},	//   viće_, _ışık, _mhús, соме
  { {0x34ab0029,0xa9fa000a,0x7412002b,0xe3ae1377}},	//   _جداً_, רִית, تویا, _еб_
  { {0x6d4b002e,0xd3780085,0x91fd003d,0x656902f7}},	//   ðgan, tiće_, erād, lgeh
  { {0xada615ed,0x6da615ee,0xe3b0002b,0x72350015}},	//   бавл, бива, _ترن_, _ارتط
  { {0x1d260054,0x656915ef,0xd3780085,0xdb1201f6}},	//   смам, ngeh, riće_, _égér
  { {0x998d005c,0x69d80152,0x20030b28,0xdca31411}},	// [2220] _wieś_, èvem, blji_, пати
  { {0x7f860029,0x91fd0024,0x7dda0089,0xbb4a0087}},	//   _الدن, arād, půso, الان_
  { {0x4a9a0010,0x1617000b,0x5fb7000a,0xb05b0123}},	//   ытаў_, दगार_, _ההיא_, tyäg
  { {0x27e9002d,0x7bc700dc,0xdb1c00c0,0x65690079}},	//   éann_, _elju, _omrö, jgeh
  { {0x28d2021e,0xa8770015,0x63a300aa,0x656915f0}},	//   _देखि, محور_, _onnn, dgeh
  { {0xfaa6008f,0x207b0053,0xf093000a,0xab2702b0}},	//   _лаго, ראסא, פנו_, _гора_
  { {0x656900b8,0x8f9b0008,0x7bde0213,0x2a350010}},	//   fgeh, טיסי, mipu, _мэтр
  { {0x75d40087,0x69cb11b4,0xa9c6002b,0x45b8004a}},	//   تيبا, chge, _ازسو, ргию_
  { {0xc34a15f1,0xe73a0829,0x74140058,0x3437009a}},	//   ляне_, _без_, يوبا, یسید_
  { {0x91fd0024,0x289b004c,0xa91d0091,0xdcef003d}},	//   zrād, _גימא, _važt, _sacī
  { {0xd5af15f2,0x4b7b000a,0xabfb000a,0x628f002a}},	//   _ес_, נאטו, רפיז, łcon
  { {0x31c70080,0x9c830007,0x645d0896,0x92570080}},	//   ссов, ščiu, ásic, щают_
  { {0x7bde15f3,0x107415f4,0xf50600e2,0x83fd0030}},	//   kipu, пляю, _уздо, rtőr
  { {0x6ee70029,0x7de50091,0x93f3005e,0xb4e4000b}},	//   مسأل, mėsi, _епіц, फपी_
  { {0x7de500df,0x43770053,0x91fd0024,0x63770008}},	//   lėsi, _לײגן_, trād, _הגוף_
  { {0x7bcb0024,0x91e40054,0x83fd0030,0x0000006a}},	//   īgum, _ноје, ltőp,
  { {0xcf8e0074,0x7bcb0024,0x30a40033,0x7de50091}},	// [2230] رژی_, ūgum, _ерэв, nėsi
  { {0x2bbb0029,0xdfd10086,0xad9b002d,0x3b5500e2}},	//   دارة_, _آيد_, _chúr, ікер
  { {0xc333013a,0x7bc700bc,0x6d4d02f2,0x387f15f5}},	//   פוף_, _vlju, paaa, _spur_
  { {0x7de50007,0x6b8502ad,0x0000006a,0x0000006a}},	//   kėsi, sehg,   ,
  { {0xa01b00dc,0xfd96000a,0xf865005e,0x27e90077}},	//   dvöz, _ודרך_, івко, éano_
  { {0x7de50007,0x207c0053,0xdb0e0011,0x98480139}},	//   dėsi, טאדא, _dobâ, сяца_
  { {0x5fbc013a,0x3ffc0053,0x656915f6,0x6f4c000a}},	//   רצונ, אפגע, tgeh, אֲחַ
  { {0x95990484,0x59c50015,0xe45915f7,0xa91d003d}},	//   ртку_, _بيرك, ажи_, _dažr
  { {0x656915f8,0x7de50091,0x0000006a,0x0000006a}},	//   rgeh, gėsi,   ,
  { {0xa3d3005d,0x656900b8,0xd7fb13ae,0x61ed041c}},	//   सों_, sgeh, _суб_, _ajal
  { {0xf77004b6,0xd9b5000a,0xcb88000a,0x65690547}},	//   _سال_, ַּ֨ח_, זְרֹ, pgeh
  { {0xb1da0036,0x7de50007,0x216a03e7,0x36050015}},	//   рьох_, bėsi, шими_, _بوصف
  { {0x23b50015,0x98bd002a,0xe3d50015,0xd00a15f9}},	//   _ومؤس, tawę_, _وتتع, иеме_
  { {0xd9b6005d,0x75d3002b,0x69c90079,0xcf250015}},	//   _अक्ट, _بيچا, _llee, كرفي
  { {0x98bd005c,0x61ed002e,0xdb0e0046,0x69c9008c}},	//   rawę_, _fjal, _pobí, _olee
  { {0x61ed0084,0x91fd0024,0xc692039e,0x22510057}},	//   _gjal, nuāl, ואל_, ázku_
  { {0xfc1a0029,0x6b560015,0xd3780085,0x2259002a}},	// [2240] لقرب_, قضائ, lića_, ąsku_
  { {0x6000008c,0x69c915fa,0x6abe0dca,0x73f9004f}},	//   tömu, _alee, typf, בּ֣ו
  { {0xdcff0024,0x69c905d6,0x092a004a,0xd3780085}},	//   īvāk, _blee, ажей_, nića_
  { {0x7ae3002d,0x600000b8,0x9e630033,0x627a004c}},	//   únta, römu, _ўвяд, ינענ
  { {0x91fd0024,0x8b660029,0xe7c5000b,0x9b460015}},	//   duāl, _واسم, वसंप, _ونحو
  { {0xa09b0135,0xb09b004c,0xaa460aed,0x409b000a}},	//   יינט, יינר, _мегл, יבנס
  { {0xeb9100b2,0x69c9003e,0xe666008b,0xc9860015}},	//   _אָן_, _flee, ітко, _وشري
  { {0x35f70086,0xd378016f,0xfad7000a,0x8f1b004f}},	//   يريد_, dića_, _וולך_, סוקת
  { {0x386600c7,0x6b990125,0xb7e615fb,0x9f510030}},	//   quor_, _éagó, _джак, hozá_
  { {0x7de50007,0x249d0026,0x61ed0c8e,0x9f580003}},	//   rėsi, _drwm_, _sjal, boré_
  { {0xc7b30008,0x69c900f2,0x51f905d1,0x2c740034}},	//   _קבע_, _ylee, йною_, häd_
  { {0xc2b7005e,0x7de50073,0x645d0073,0x0000006a}},	//   іляє_, pėsi, šsia,
  { {0xc95301e4,0x80db005d,0x05b30015,0xa50706a6}},	//   ומר_, _पेशे, _تمنح, _деца_
  { {0xa2e60015,0xcf270015,0xd3780085,0x3a2404a9}},	//   _وأثن, ترحي, bića_, _limp_
  { {0xcddb03f1,0x91fd0024,0xc7d7000a,0x80db000b}},	//   ања_, grāc, קולי_, _पेरे
  { {0xd1310015,0xd257004f,0x2904007f,0x61ed0de4}},	//   _ثمة_, _ושהה_, _oyma_, _ujal
  { {0xfc300015,0x8cc40015,0x91bc000a,0xcf270058}},	// [2250] نحل_, وقفه, _כמהי, _وردي
  { {0xaac70074,0xc43b000a,0x69c915fc,0x91fd003d}},	//   يتان, יתמי, _slee, zuāl
  { {0x8ae70191,0xaa950029,0x0af90029,0x93fb000a}},	//   ціал, ثلاث, حفاظ_, סלבי
  { {0x99d40086,0xd8750015,0xbcfb006f,0xfbdf0034}},	//   وتنا, كاتب, _dcér, _gwên_
  { {0xed05002b,0xc7a5006b,0x394f0012,0x1eea002b}},	//   _روسپ, зилк, rags_, _نویی_
  { {0x29040176,0x9f58032c,0x4cba000a,0xe7310067}},	//   _dyma_, toré_, _המשג, رصت_
  { {0x91fd0024,0x6fc2006f,0x28db000b,0xaa5815fd}},	//   tuāl, _dôch, _मेरि, _миру_
  { {0xd378016f,0x61fd0024,0x3694005e,0x212901c2}},	//   vića_, josl, ьшіс, _ngah_
  { {0x478b0080,0x61fd15fe,0x44390003,0xf992004f}},	//   _всем_, dosl, ës_, _ארן_
  { {0x44390024,0x4734002b,0xd3780085,0x0bb6000a}},	//   īs_, _قرمز, tića_, ִ֜ים_
  { {0x443915ff,0x9f4e0089,0xe1fa0010,0x7dca002e}},	//   ūs_, áním_, йго_, _lýsa
  { {0x249d0026,0xd3780085,0x61fd1600,0x41b30058}},	//   _trwm_, rića_, gosl, ّمَر
  { {0x394d1601,0x10160010,0xf8bd000b,0x9f4e0046}},	//   _mees_, зьвя, ्निय, šním_
  { {0x78a60084,0x437500b2,0x394d049c,0xdd920086}},	//   _ákve, _זײַן_, _lees_, کور_
  { {0x443f1602,0xc7b20053,0x6012002e,0xc3320053}},	//   lpu_, ײבן_, væmd, _אוו_
  { {0xc8bd005d,0x82d60008,0xc6920053,0x443f0024}},	//   ्नाट, _מוצג_, עאן_, opu_
  { {0xdd8f0070,0x3c660010,0xc5f2000a,0x69bf000b}},	// [2260] دوق_, якаг, גדן_, _वक़ी
  { {0x909b0008,0xb09b000a,0xa09b000a,0x443f1603}},	//   _פסיק, _פייר, _פייט, ipu_
  { {0x5fbb000a,0x394d00da,0x09e602ed,0x3a2401f9}},	//   _הצינ, _bees_, пожн, _pimp_
  { {0x6fcb0064,0x3236004c,0xf9920015,0xa96a135f}},	//   _tücc, לטען_, عبا_, сида_
  { {0x6d441604,0xc7b8005e,0xdb0e013f,0x18670bb1}},	//   mbia, оґа_, _dobá, зачи_
  { {0x6d440007,0x3f8a0026,0x25b20026,0x3f981605}},	//   lbia, nebu_, _ŵyl_, ndru_
  { {0x3a2404f9,0x63b8099c,0x67530086,0x394d1606}},	//   _timp_, _rovn, رخور, _fees_
  { {0x6fcb0064,0x394d00dd,0xda5b000a,0x86c30015}},	//   _müca, _gees_, _לכלל, عيين
  { {0x6d441607,0x61fd1608,0x6283005a,0x0000006a}},	//   ibia, vosl, _apno,
  { {0x883b0008,0x7de50007,0x8857000a,0x60270003}},	//   _לתמו, lėst, _משמע_, hémè
  { {0xd6c40086,0x443f0340,0x11d90015,0x9473002b}},	//   _تمای, apu_, قودة_, ودیا
  { {0x25a60026,0x7c3a0046,0x92930033,0x3f981609}},	//   _unol_, _čtrn, хаюц, edru_
  { {0x859b000a,0x77bd0144,0x9f580034,0x61fd06ca}},	//   _לשאו, _tèxt, gorï_, rosl
  { {0xb7bd04f9,0x251b000a,0x3f8a01d7,0x6d440034}},	//   _puţi, _הודא, gebu_, ebia
  { {0x6b95052c,0x64400991,0x637b000a,0xd37b000a}},	//   _razg, lpmi, _הנוד, _הרוט
  { {0x463b004c,0x3f9800d4,0x92f200d4,0x0000006a}},	//   מעלע, adru_, ăşăm,
  { {0x7de50007,0x0c390029,0x394d0335,0x515c000a}},	// [2270] dėst, زكاة_, _rees_, _הכחו
  { {0xfe6e0074,0xbca4003b,0x60cf0064,0x394d0100}},	//   دگی_, عملي, ınmı, _sees_
  { {0x6b950064,0x660200dc,0x6d44160a,0x7d06001a}},	//   _vazg, _okok, bbia, _eyks
  { {0x3eac0293,0x248d002a,0xc237000a,0xd8f5002b}},	//   ådte_, ywem_, פרדו_, وزشک
  { {0x315800b2,0x88190010,0x394d007c,0x6d5d0789}},	//   ליאן_, оўку_, _vees_, _idsa
  { {0x394d020a,0x4639004a,0x98a2135f,0x67d41534}},	//   _wees_, очия_, тише, ночу
  { {0x4ac50086,0x6d4f0049,0x9f5e0003,0x1665005e}},	//   _غيرق, _keca, ôté_, євим
  { {0x19940010,0x248d005c,0x8459160b,0x6e3800dc}},	//   _пася, twem_, орот_, _évbe
  { {0x85540086,0x6f090046,0x6d4f160c,0x657b0012}},	//   ریور_, řech, _meca, rfuh
  { {0x798b0034,0x443f160d,0x657b02ad,0x6d4f10b6}},	//   legw, rpu_, sfuh, _leca
  { {0x6d440026,0xd7580029,0x7c2f160e,0xdb68000a}},	//   ybia, _رجلا_, _lucr, הֳרָ
  { {0x798b0026,0x65150029,0x71da0036,0x96fa0008}},	//   negw, _قوائ, ієнт_, _ולעת
  { {0x95540086,0xc4fb0086,0x66090061,0xd3b90033}},	//   _سخنا, _اعضا_, mlek, _мукі_
  { {0x02450015,0x66091123,0x7d060811,0x6d440034}},	//   _قَتَ, llek, _ryks, wbia
  { {0x6d4f0041,0x4427160f,0x3f8a1610,0xe80e000b}},	//   _beca, _iin_, rebu_, ितता_
  { {0x7e610084,0x661b00f2,0x44271611,0x6d4f01c2}},	//   álpa, nmuk, _hin_, _ceca
  { {0x1d070001,0x6d441612,0xfce30076,0x6fd6005e}},	// [2280] дети_, rbia, вото, _жінц
  { {0xabaa0029,0x7d060007,0x8c950033,0xd239000a}},	//   غهام_, _vyks, эрсі, ַגְל
  { {0x6eb5005d,0x1ee80086,0x7d06005c,0x8f8b000a}},	//   _उपयु, _روحی_, _wyks, _וְכֵ
  { {0x44271613,0x58860010,0xfe9b000a,0xc8ca0115}},	//   _lin_, дыка, _ויטמ, يوان_
  { {0xa3cd000b,0x891a002b,0x91fd003d,0x645d14b9}},	//   रसा_, آغاز_, krān, ásil
  { {0x442701e2,0x66091614,0x660209cd,0x945d002a}},	//   _nin_, elek, _skok, zyńc
  { {0xd6d0003b,0x34b8005d,0x442f1615,0x4a4602a3}},	//   طقة_, ेन्द, _aug_, _інав
  { {0xd5b0003b,0x661b02f2,0x7c270079,0x442f1616}},	//   افة_, gmuk, _zijr, _bug_
  { {0xc5f70015,0x7c290030,0x44271617,0x39461618}},	//   بعوض_, _éert, _bin_, mbos_
  { {0x394600df,0xa3d8005d,0xe8d70008,0x442f1619}},	//   lbos_, ठों_, _חומר_, _dug_
  { {0xbcfb161a,0x6609161b,0x4427161c,0xdb9b004f}},	//   _idée, blek, _din_, קסטר
  { {0xf6690029,0x7dc30020,0x4427161d,0x6602003f}},	//   _رحمه_, _tõsi, _ein_, _ukok
  { {0x361b0053,0x4427161e,0x9393002b,0x29f80085}},	//   _וואד, _fin_, رجیا, mčad_
  { {0x250b0086,0x6d4f013c,0x73c40015,0xe4b70033}},	//   _برمی_, _seca, _سيعم, _юліі_
  { {0x442f00b8,0x12b30015,0x33fb000a,0x92b30015}},	//   _zug_, _لإيج, _והגנ, _لحيا
  { {0x4427161f,0xa1870033,0x518701f3,0x7bce1620}},	//   _zin_, _цыкл, _цука, _albu
  { {0x6d4f0024,0x42180015,0x7d080015,0x44271621}},	// [2290] _veca, _تزوج_, ِيقِ_, _yin_
  { {0x2fc700a7,0x44270023,0x660900dc,0x60c00c77}},	//   _ông_, _xin_, zlek, ämme
  { {0x6d4f1622,0x2ef40033,0x38661623,0x61ef1624}},	//   _teca, _азэр, eror_, oncl
  { {0x38660bc8,0xeab00015,0x6d5d02de,0x7bce0030}},	//   fror_, جعك_, _udsa, _elbu
  { {0xdd3a013a,0x52ca000b,0xf1b4000a,0x71d8004c}},	//   _מערכ, ानुस, כסף_, וואד_
  { {0xe6110086,0xa695009c,0xcc76000a,0x96950054}},	//   گشت_, ериј, _אעשה_, ериш
  { {0x44271625,0x6b6800dc,0x77360015,0x66091626}},	//   _rin_, ségü, ركيز_, tlek
  { {0x9f58002c,0xfc3f002d,0xe611002b,0xa87b0015}},	//   vorí_, _tríd_, دشت_, _وحذر_
  { {0x0efc005d,0x66091627,0x661b0d20,0x2d991628}},	//   _एड्स_, rlek, rmuk, _mase_
  { {0xe3b1003b,0x02ca005d,0x78a6002e,0xd8860086}},	//   ارة_, ानून, _ákva, _سهمی
  { {0x03940010,0x8c1c000a,0x1309056d,0x44271629}},	//   трыя, חוזי, яной_, _vin_
  { {0x4427108f,0x442f055e,0x764302f2,0x2d99162a}},	//   _win_, _tug_, mpny, _nase_
  { {0x4427162b,0x2ec8000b,0xb0e0000b,0xe534004a}},	//   _tin_, रन्त, _पेशग, _речь
  { {0xe4560053,0x4427162c,0x3cf3000b,0xe3b0002b}},	//   _טינט_, _uin_, ंपने_, _پره_
  { {0x39460007,0xdb1c0061,0x2d99162d,0x249f001a}},	//   ybos_, üzün, _base_, lvum_
  { {0xdb1c0152,0x2d990376,0x160f000b,0x7dca0247}},	//   _forê, _case_, ातिर_, _výso
  { {0x3dd20176,0x8fa60de5,0xa3e3000b,0x61e6162e}},	// [22a0] rhyw_, _запе, _नगा_, mikl
  { {0xfc3f002f,0x61e6162f,0x395f0011,0x2d99003e}},	//   _dtí_, likl, _adus_, _ease_
  { {0x160f005d,0xb17b00c0,0x319a000a,0x2fc50061}},	//   ातार_, pnåt, ּבְנ, ölge_
  { {0x523a0053,0x61e61630,0x2d991631,0x249f001a}},	//   לײענ, nikl, _gase_, kvum_
  { {0xa9270191,0xb346001c,0x61e60020,0x5837005e}},	//   ніше_, niçõ, iikl, езія_
  { {0x2d990c6d,0x386603b8,0x6d561632,0xc053004f}},	//   _zase_, rror_, laya, נזו_
  { {0x25bd1633,0x61e61634,0xd7570015,0xe5c61635}},	//   _bowl_, kikl, رجوا_, еспо
  { {0x3f9a0048,0xceb3011f,0x3949002e,0x6d561636}},	//   _lapu_, ריה_, ðast_, naya
  { {0x1867000d,0x61e61637,0x76430030,0x53e61638}},	//   _пати_, dikl, apny, ецна
  { {0x3c770008,0x61e60007,0xb3560086,0x66001639}},	//   עתים_, eikl, ریبا_, somk
  { {0xd2570036,0x6600003f,0x61e6048b,0xf77300a3}},	//   нця_, pomk, fikl, _תקע_
  { {0x6d56163a,0xab640064,0x6012002e,0x61e60091}},	//   jaya, ldüğ, væma, gikl
  { {0x7dca04af,0x6d56013c,0x2ca00085,0x2d99163b}},	//   _výsl, daya, jvid_, _rase_
  { {0xb4be005d,0x2ca000c0,0x2005002c,0xab640064}},	//   ीनी_, dvid_, ôli_, ndüğ
  { {0xd3350010,0xdb15163c,0x1ee7002b,0x8337004c}},	//   _рэчы, _pozí, روری_, _טאגס_
  { {0x3253010f,0x6d5600b6,0x3ebe012d,0xb346016e}},	//   _свър, gaya, ätta_, biçõ
  { {0x51fc000a,0xacf8163d,0x2d99163e,0xa91d163f}},	// [22b0] _מההצ, енту_, _vase_, _obža
  { {0x1cb80015,0x3dc90535,0x9f5803a0,0x0000006a}},	//   راقب_, skaw_, corà_,
  { {0x20030007,0x6d561640,0x2d991641,0x83fd0030}},	//   moji_, baya, _tase_, ttőz
  { {0x20030064,0x9a880015,0x645d0030,0xaf4b002b}},	//   loji_, عَنْ_, ásik, _بشکل_
  { {0xcf270086,0x7dda0089,0x83fd00dc,0xe72e0254}},	//   _ترکي, růst, rtőz, ие_
  { {0xa01b002e,0xa09c0053,0xb09c000a,0x08c40033}},	//   stöf, פיוט, פיור, ыбін
  { {0x91fd003d,0x34c9000b,0x60c6006f,0x5ba4009b}},	//   trāl, िन्द, zykm, _сряз
  { {0xb4be000b,0x36180033,0xc485070c,0xa5f600af}},	//   ीनू_, нцыю_, влик, кеју_
  { {0x91a90092,0x61e61642,0x99870091,0x20030de8}},	//   _giả_, vikl, ūnų_, koji_
  { {0x799b003f,0xe4c80029,0x20030007,0xf77000e6}},	//   _hauw, عبين_, joji_, _هام_
  { {0x6d5600b6,0x27e7002e,0xc64b00e6,0xeb92000a}},	//   yaya, minn_, _رجال_, בָר_
  { {0xe3b10086,0x27e71643,0xc692000a,0xb346016e}},	//   ارک_, linn_, _כאב_, tiçõ
  { {0xc9520008,0x32020107,0x69cb0079,0x26c70091}},	//   סמך_, roky_, ikge, lyno_
  { {0x200300bd,0xb346001c,0xa8560008,0x60c6008c}},	//   goji_, riçõ, כישה_, rykm
  { {0x52b20029,0xb346001c,0x26c70007,0x6d560ad4}},	//   _نموذ, siçõ, nyno_, taya
  { {0x799b0111,0xac9a0015,0x753b1644,0x69cb0079}},	//   _nauw, ونزا_, ncuz, jkge
  { {0x27e7002e,0x91fd0024,0x645b0618,0xdcfd0091}},	// [22c0] kinn_, krāj, nsui, _masė
  { {0x201a003b,0xfaa6034e,0x80db000b,0x2055006b}},	//   _تتبع_, казо, _पेटे, _стър
  { {0x81f70086,0x799b00b8,0x6d561645,0x27e7001a}},	//   _سفیر_, _bauw, paya, dinn_
  { {0x5e5700b2,0xd5af0036,0x645b0604,0x186a0004}},	//   _ביטע_, _всi_, ksui, дади_
  { {0x27e7002e,0x61e4003f,0xa1370053,0x76410091}},	//   finn_, _mmil, דאנק_, _atly
  { {0xf0930053,0x27e7074c,0xda660002,0xe6780033}},	//   ינד_, ginn_, _لاري, ейкі_
  { {0x7dc30020,0xab640064,0x656600dc,0x67d30036}},	//   _tõst, rdüğ, ókho, рощу
  { {0x69cb00b8,0x6b9c013c,0x6a97000a,0xd3780085}},	//   ckge, _harg, _בכלא_, mići_
  { {0xb4cc014e,0xb4be014e,0xd467000d,0x6b9c1646}},	//   रने_, ीने_, виње_, _karg
  { {0x674502d5,0x799b005c,0x43940001,0x69c01647}},	//   čují, _zauw, ћанс, _home
  { {0xa3e3005d,0xd6c40086,0xad9b002c,0x6b9c1648}},	//   _नगर_, _حمای, _skúm, _marg
  { {0xdb1c1649,0x6b9c164a,0x386906c0,0x31c702ed}},	//   _coré, _larg, šare_, тсов
  { {0xf993000a,0xdb1c0003,0x5067006b,0xa2630016}},	//   ברר_, _doré, ътна, _huố
  { {0xbcfb002d,0x9f58002c,0x3f85002c,0xa3e1000b}},	//   _ndéa, torá_, ýlu_, नोद_
  { {0x9e070191,0xb062008c,0x3ea5001a,0xe731000a}},	//   вчал, _äänn, ílt_, מֵן_
  { {0xa2630023,0x1dc50015,0xd3780085,0x200300bc}},	//   _muố, دْرِ, dići_, soji_
  { {0x9d1505c4,0x6b9c04dd,0x320902f2,0x91f8004f}},	// [22d0] удач, _barg, _ikay_, _שמחו_
  { {0x6b9c113d,0x6fb50015,0x8bd40033,0xfc3f0077}},	//   _carg, _إمدا, ажуц, _cría_
  { {0x6b9c164b,0x69c00079,0x6fcb0012,0x6562006f}},	//   _darg, _bome, _lück, _odoh
  { {0xceb20053,0x5ee8000a,0x27e70012,0x99d70015}},	//   _היט_, _יַרְ, winn_, ختطا
  { {0x26c70026,0x27e7164c,0xa3c3005d,0x6b9c13e1}},	//   wyno_, tinn_, _एकल_, _farg
  { {0x628a0134,0xa8040033,0xd7f80054,0x480400e2}},	//   _opfo, азіл, куј_, апів
  { {0x27e70b41,0x06540010,0xa2630092,0x645b00da}},	//   rinn_, атыў, _cuố, wsui
  { {0x3f9100b8,0xceb40643,0x27e7164d,0x645b164e}},	//   hezu_, שיק_, sinn_, tsui
  { {0x6b9c0064,0x27e7002e,0xad9b002c,0xc7f90036}},	//   _yarg, pinn_, _akúk, _знає_
  { {0x69c00111,0xb8f7000b,0x61e4164f,0x645b1650}},	//   _zome, ान_, _smil, rsui
  { {0xdb1c001c,0x8bd60008,0x645b1651,0xeb92000a}},	//   _poré, רותו_, ssui, זָר_
  { {0x6627003b,0xc6da00b2,0xcb120008,0x7dca0264}},	//   _شراك, _אַדר, מלי_, _výsk
  { {0xa91d00df,0x89da000a,0x6fcb0012,0x397a004c}},	//   _pažy, תחרי, _küch, עטשנ
  { {0x3a2d0111,0x701901f3,0x68e40125,0xdee60fdc}},	//   _liep_, віст_, úidi, гоги
  { {0xa2630023,0x7dca002e,0xd00f0015,0x2fc5001a}},	//   _xuố, _hýsi, سلف_, ölga_
  { {0xa01b00dc,0x63b50007,0xd3780085,0x7bc30b2d}},	//   gtöb, šanč, vići_, önun
  { {0x6da30063,0xb8860089,0x5baa0418,0x6b9c1652}},	// [22e0] щита, _kníž, нкам_, _parg
  { {0xa01b00f2,0xc0530008,0x69c01653,0x8ad60033}},	//   ttöe, _הזז_, _some, люец
  { {0x77940074,0xc332013a,0x7dca002e,0x69c012d7}},	//   ییرا, צוא_, _lýsi, _pome
  { {0x7db60029,0x9f580251,0x6b9c013c,0xbcfb0077}},	//   _إصدا, forç_, _warg, _idén
  { {0x2d9201e2,0x6fcb00b8,0xd7e6042b,0x1754011b}},	//   meye_, _büch, ліко, авля
  { {0x6fcb018b,0x69c0003e,0xccab04dc,0x0f7a004c}},	//   _rück, _wome, _אֱלֹ, גאַב
  { {0x96f80080,0xa2630092,0xb7650036,0xeab4000a}},	//   ъект_, _quố, ртій, _דִּי_
  { {0x7a8b0008,0xa3d6000b,0xa2a2000b,0x2d920f0a}},	//   _אָמַ, _सतह_, गिस्, neye_
  { {0x7c2e003f,0x08d60010,0xf7461654,0xdb1e007c}},	//   _kibr, _сцвя, _безо, skpä
  { {0x54330029,0x66da004a,0x5fc6000b,0x25af1655}},	//   حرير, _пьер_, रॉमल, _engl_
  { {0x0bb70008,0x2d920064,0x3f91016f,0xe1d9005e}},	//   אלים_, keye_, vezu_, вдні_
  { {0x4a5b000a,0xc2b7005e,0xa565002b,0x6fcb0012}},	//   עדכו, улює_, _ندهن, _züch
  { {0x7c2e002f,0xc0ab00c3,0x3f910085,0x2d921656}},	//   _oibr, راحل_, tezu_, deye_
  { {0x749b000a,0xddc700bc,0xed590091,0x40340427}},	//   _ניופ, dujš, _žž_, серс
  { {0xa6f80008,0x6298016f,0x3f9106f2,0x02a30033}},	//   דִּי, _usvo, rezu_, _грым
  { {0xb886002c,0x7c2e002d,0x6dc4004a,0xb03506b3}},	//   _zníž, _aibr, бсуж, _книш
  { {0xdb6b0036,0x8c250015,0x3a2d0079,0xcb550054}},	// [22f0] ерел_, لفره, _riep_, иваћ
  { {0xcb680054,0x0000006a,0x0000006a,0x0000006a}},	//   лађе_,   ,   ,
  { {0x7f3a000a,0x7959029b,0xbf15002b,0xfa8b0033}},	//   _בעתו, виер_, _خودب, эсай_
  { {0x2d920061,0x0dcb0015,0x442e1657,0xba740058}},	//   ceye_, _أبدى_, _lif_, صامت
  { {0xbcfb0003,0x99840045,0x8d5a000a,0xdcfd003d}},	//   _idéo, _simţ_, _בכרי, _masī
  { {0xdcfd0024,0xf77100e5,0x6d4d0234,0x9058000a}},	//   _lasī, زات_, lbaa, נסוף_
  { {0x45d5066c,0x19950010,0xf6960015,0xd7580021}},	//   ицит, _кавя, لنوع_, اجها_
  { {0xb8860089,0x05a90a61,0x6d4d0161,0xb867002b}},	//   _sníž, твий_, nbaa, _مائو
  { {0xe4560010,0x851f005d,0x9c890036,0x6fcb0012}},	//   ажы_, मेंट_, ерiа, _tüch
  { {0x98170029,0xc4e20010,0x3d1d005d,0x787a000a}},	//   _إبرا, іжэй, _मरने_, _יָבו
  { {0x6d4d00f6,0x6b6000dc,0x7216005e,0x629e1658}},	//   kbaa, lágí, иємц, _špor
  { {0x78a9003c,0x10a603fc,0xb6ba000a,0x07080015}},	//   _krev, аимн, _בצעי, _صيني_
  { {0x21a30080,0x2d920061,0x6d4d0079,0x20d500e2}},	//   циям, veye_, dbaa, бірс
  { {0xf4b6002b,0x64491659,0x7dd800e1,0xfe46165a}},	//   _خشمگ, mpei, _míse, инго
  { {0x2d920064,0xdd9200e6,0xed5a165b,0xdbcf006f}},	//   teye_, يوس_, ков_, bľúb
  { {0x6d4d165c,0x3860044c,0x12fa000a,0x645d0091}},	//   gbaa, širi_, _בהצב, šsiu
  { {0x61fd00dc,0x2d920064,0xef19002a,0x14d5000a}},	// [2300] érle, reye_, ęża_, בוּל_
  { {0x2d92165d,0x8e76009b,0x62810546,0x0000006a}},	//   seye_, _кумч, otlo,
  { {0x7f5c120b,0xfc3f0077,0x75fe003d,0x6d4d0030}},	//   marq, _frío_, līze, bbaa
  { {0x180e005d,0x22510264,0x5a33005e,0x83fd0030}},	//   ित्व_, ázky_, ініт, lsőd
  { {0x913b00b2,0x4c670036,0x27150092,0x38600c1b}},	//   דענק, _киян_, _án_, éir_
  { {0x6f090064,0x2b28002b,0xe6660659,0xcb6a004a}},	//   şece, _مغزی_, атио, _шаге_
  { {0x644900dd,0x442e165e,0xd910002b,0x8c2b000a}},	//   epei, _rif_, _کیش_, _יֵלֵ
  { {0x69d9165f,0x7e61002e,0x7dd8002d,0xbdf6000a}},	//   chwe, álpi, _físe, יֶ֥ה_
  { {0x030b005d,0x6281005c,0x05730015,0x2e3c001a}},	//   _सुबह_, etlo, زايد, _líf_
  { {0x66e60809,0xa87b000a,0x2bfb000b,0x03c61377}},	//   _коза, _באמר, ्वयं_, рсим
  { {0xe7370080,0x442e0003,0xbf67002b,0x69cd007c}},	//   _тех_, _vif_, یدآو, öaeg
  { {0x92570080,0xd3780085,0xb80e0065,0x0000006a}},	//   шают_, viću_, ितकम_,
  { {0x90981660,0x1074007a,0x7dd11661,0x645d0b7e}},	//   авят_, оляю, _såso, ásit
  { {0x9217000b,0xc8840061,0xdbcf006f,0x14db000a}},	//   _धीरज_, mağı_, sľúb, _שַׁמ
  { {0x63bc002e,0x6d4d016b,0xdb230064,0x637b00a3}},	//   örnu, tbaa, ürün, _סנהד
  { {0xcdd80124,0x6d4d00dd,0x629d003d,0x91e40054}},	//   ању_, ubaa, āsot, _моје
  { {0xdce601e2,0xd9040086,0xc8840064,0x7f5c1662}},	// [2310] _bakı, _آی_, nağı_, barq
  { {0x2fe40015,0x2b470033,0x2b580045,0x6d4d1663}},	//   _وكيف, рэаг, _cerc_, sbaa
  { {0xd8b80074,0x4ae40010,0x6d4d0234,0x99350015}},	//   یدها_, оўца, pbaa, مفات
  { {0xf99303c4,0x7dd80089,0x98350033,0x80a4002b}},	//   تبط_, _píse, бэкі, _امین
  { {0xcdb60008,0xa3c8000b,0xaf08002b,0x98a51664}},	//   _הפרה_, ैसा_, _مقیم_, силе
  { {0xec360008,0xe8080033,0x2bc80004,0xf8070004}},	//   _לאשר_, анід_, _кусо_, шчен
  { {0x5a440010,0xb6580033,0x6b600030,0x6f7a000a}},	//   _мэта, ашых_, ságí, רְנו
  { {0x29f800bd,0xeef8000a,0xdce8002a,0x973c0085}},	//   nčal_, ימור_, śląs, _raće
  { {0xdce601e2,0x9f8f0064,0x7c25002d,0xcdb8000f}},	//   _yakı, _güç_, omhr, שפחה_
  { {0x3cff014e,0xa3e1005d,0xe2990001,0x6449043c}},	//   _रखने_, नों_, гао_, rpei
  { {0x11d6003b,0x7c25002d,0x9f5100dc,0x64491665}},	//   متحد, imhr, hozó_, spei
  { {0x9f510014,0x395d0034,0x64491666,0xa0c60058}},	//   kozó_, naws_, ppei, ميجو
  { {0xc8840064,0xd4690175,0xf536000a,0x9f580030}},	//   cağı_, _силе_, _הנני_, morú_
  { {0xd91a0053,0x7dca002e,0xc34b004a,0xa01b008c}},	//   טורל, _lýst, _ряде_, ttöa
  { {0x6fd000c0,0xc332000a,0xdce60061,0x7f5c0d29}},	//   _häck, _צוה_, _rakı, rarq
  { {0x41e50015,0xdce60061,0x6e2402f2,0x14d5000a}},	//   _وسيف, _sakı, umib, ֖וּל_
  { {0x2b5800dc,0x5b3600a2,0x6e2400dc,0x30860015}},	// [2320] _perc_, معار, rmib, _الخف
  { {0x660900dd,0x83fd00dc,0x2f56017c,0x10bb000a}},	//   hoek, lsőb, _утис, _עזיב
  { {0x4e1a0074,0x80250029,0x7dd8002e,0xdce60061}},	//   _متحد_, _بريم, _vísb, _vakı
  { {0xc236000a,0xda650015,0x6012001a,0xaa570015}},	//   צרנו_, زامي, dæmi, صلها_
  { {0xdce60064,0xc7c60404,0x1cba0031,0x260b000b}},	//   _takı, йски, _صاحب_, ावनी_
  { {0x9ad60010,0x711b000a,0x3d1d000b,0x7dca00bf}},	//   _любі, נוספ, _मरते_, _výsu
  { {0x8f9b0008,0xe0df04ed,0x91fd003d,0xceb3000a}},	//   ריצי, zzò_, nsāc, ֜יו_
  { {0xd6d90036,0xc8840064,0x1af70008,0xceb3039e}},	//   шті_, tağı_, _המלל_, ליו_
  { {0xdb1c0251,0x200a1667,0x493b000a,0x288b009a}},	//   _horà, kobi_, _תגמו, _مصلی_
  { {0xfa6a000a,0xe2aa0015,0x91fd003d,0xc8840061}},	//   ְכָּ, هاجن_, ksāc, rağı_
  { {0x51f90036,0x9f5800dc,0x200a00bd,0x91fd0024}},	//   иною_, ború_, dobi_, krāt
  { {0xe45a005e,0x961a0015,0x8637004f,0xc17400ce}},	//   _бжд_, _صغار_, _הראב_, плющ
  { {0xe3af0086,0x91fd003d,0x200a156a,0xddce003d}},	//   ذری_, drāt, fobi_, arbū
  { {0xe47b000a,0xe0df01e0,0x44f30138,0x0000006a}},	//   _ערוכ, rzò_, _эпіс,
  { {0xe2460070,0xd35b011f,0x6fd000b8,0x53e50015}},	//   _اختي, _גדול, _mäch, _بأنف
  { {0x9f5100dc,0x8e15042b,0xbd450015,0x6fd00012}},	//   tozó_, ідац, زنطي, _läch
  { {0x91a90023,0xf1f80074,0x320b005c,0xd1310015}},	// [2330] _giá_, _دعوت_, mocy_, _تمة_
  { {0x66090298,0x6fd000b8,0x44d40092,0x543b0053}},	//   zoek, _näch, ì_, טעמא
  { {0x6fb50074,0xfbd00029,0x3ce00085,0xcb1b0004}},	//   _همکا, رتك_, aziv_, уќа_
  { {0x7dd10134,0x6012002e,0x6fcb0064,0x61ef1668}},	//   _måsk, væmi, _vücu, nicl
  { {0x8934003b,0x718c0008,0x229a0024,0x9ccb04ab}},	//   أعما, רְבַ, _lūk_, _сына_
  { {0x6fd000c0,0xa01b00dc,0x61ef1669,0xd6a90015}},	//   _räck, ztön, hicl, لدعم_
  { {0x9f58002c,0xa01b166a,0x2ca9166b,0xa93d0033}},	//   torú_, ytön, lvad_, _адбi
  { {0xe6190083,0x59f90080,0x3ebe00f2,0x25bf007c}},	//   јди_, _тебя_, ätti_, ujul_
  { {0x4439001c,0x6fd00012,0x7bc7007c,0x38600125}},	//   ês_, _fäch, _koju, áirt_
  { {0x6498010f,0x6609020a,0xa3ba0086,0xf3e50036}},	//   стър_, soek, لاپر_, іжно
  { {0x44d40023,0xdb1c0014,0x2ca9007c,0xdced003d}},	//   à_, _korá, hvad_, edaļ
  { {0x6fd000c0,0x3a7a000a,0x34b50015,0xe4510015}},	//   _täck, סטרד, _وماز, _قضت_
  { {0x3494032d,0xa01b166c,0xe4cb0015,0xdb1c166d}},	//   _нацр, rtön, _حبان_, _morá
  { {0x34b20074,0x2329166e,0x8c420064,0xc2c50015}},	//   _آموز, _коли_, üğme, _ويشي
  { {0xa01b002e,0x443f0152,0x539a0008,0xdced0024}},	//   mtöl, lqu_, _כיסו, adaļ
  { {0xa01b0014,0xaaba0086,0xdd920002,0x657b166f}},	//   ltöl, یدار_, بور_, nguh
  { {0x7dd80089,0xe206000b,0x2f231670,0x38c3003d}},	// [2340] _císa, रवीण_, tégé_, _jūrā_
  { {0xab660036,0x443f1671,0xa01b1288,0xcb6a098b}},	//   івел, iqu_, ntöl, раже_
  { {0x5fb70008,0x2ca90020,0xa01b00dc,0x2f230003}},	//   _והיא_, avad_, itöl, régé_
  { {0x9f99002e,0x6fd00012,0x44d40016,0xc213000a}},	//   láðu_, _säch, ỳ_, ֵ֔ף_
  { {0x91a00023,0x26ce0034,0x58960015,0xe8260342}},	//   _chỉ_, wyfo_, تجاز, офко
  { {0x3cff005d,0x6fcb0064,0x6d4404ed,0x3f981672}},	//   _रखते_, _hücr, lcia, neru_
  { {0xfa671673,0x6d441674,0xdb1c039f,0x0000006a}},	//   _марк_, ocia, _forá,
  { {0x39420005,0xa01b00dc,0x7bc70111,0x29d60015}},	//   _üks_, etöl, _zoju, _بيرس
  { {0x224900bd,0xa01b001a,0xa3c8000b,0x44d40016}},	//   _čaka_, ftöl, ैसल_, ù_
  { {0x657b0035,0x3f98016f,0x69c2049c,0x63a31675}},	//   aguh, jeru_, ljoe, _cann
  { {0x8c1b000a,0x61ef0287,0x764800cb,0x645d0091}},	//   שויי, ticl, _utdy, šsip
  { {0xa01b00f2,0x63a3002d,0x51f80088,0xc4c60058}},	//   ttöo, _eann, жнюю_, _وتشو
  { {0x85f90053,0x44f60086,0x2d8700dc,0x63e60015}},	//   _פּעק, _بساز, őnek_, _وستك
  { {0x80270029,0x63a30335,0xa3ce000b,0x6d440228}},	//   ترجم, _gann, _रवि_, ecia
  { {0xfeb80074,0xbcfb001c,0x9f340036,0x3377000a}},	//   يافت_, _idéi, дері, _ותוך_
  { {0x6560002d,0x7bca002e,0x29d70064,0x7dd801c9}},	//   namh, öfun, _açan_, _písa
  { {0x61ed016f,0xad9b002c,0x6560003f,0x7188000a}},	// [2350] _imal, _skús, iamh, _וְתַ
  { {0xdb1c00dc,0x7dd8002e,0xc052000a,0xcfe80015}},	//   _sorá, _vísa, _רזי_, _وفيه_
  { {0x61ed00bd,0x539b000f,0x3ceb000b,0xdd910015}},	//   _kmal, שיבו, _घेरे_, _كود_
  { {0xfe9a00b2,0x6d4402d7,0x02fb00a3,0x88350033}},	//   _פירמ, ccia, סלאמ, пэкц
  { {0x6d5d0048,0x98f40015,0xa01b008c,0xad27002b}},	//   _iesa, وثها, ytöl, _گرگو
  { {0x6d5d0482,0x6560002d,0xb6590080,0x05a3000b}},	//   _hesa, eamh, бших_, _खोजब
  { {0xba740074,0x69c200dd,0xcf580008,0x6d5d013c}},	//   _يافت, bjoe, חבות_, _kesa
  { {0xfb34008f,0xe7080029,0x9f4300f2,0xa9090015}},	//   _інтэ, غتون_, lijä_, _هيزل_
  { {0xb4d5005d,0xa01b00f2,0x6d5d1676,0x3d19000b}},	//   सने_, ttöl, _mesa, _दरों_
  { {0x33d4005e,0x61ed1677,0x7c3d01d7,0x6d44002a}},	//   діют, _amal, _musr, zcia
  { {0x443f038d,0xa01b002e,0x63a31678,0x3f9806ca}},	//   squ_, rtöl, _vann, veru_
  { {0x63a300f6,0xdb1c0134,0xa01b1679,0x6d5d167a}},	//   _wann, _foræ, stöl, _nesa
  { {0xe4490029,0xe20b002e,0x9f4300f2,0x853a000a}},	//   _التى_, _slóð_, kijä_, _הגני
  { {0xf8a504b6,0xa01b008c,0x60c9007c,0x61ed167b}},	//   _یک_, ltöj, äema, _emal
  { {0x9f990084,0x7c3d00b8,0x6d5d013c,0x443d0a4c}},	//   ráðu_, _ausr, _besa, _huw_
  { {0xa01b00f2,0x6df60029,0x6012002e,0xf1bf001a}},	//   ntöj, أكرا, væmu, nmál_
  { {0xdd8f0029,0x6d5d167c,0x3d28002b,0x6d44167d}},	// [2360] طول_, _desa, زتری_, rcia
  { {0x69db022d,0x6d4404ed,0xac830033,0xe81b000b}},	//   _alue, scia, эгул, _पीला_
  { {0xcf570008,0x7f3b000a,0x2f3b000a,0xdce80061}},	//   _מבית_, _לעיו, _לגיד, ğlıs
  { {0xb23a00b2,0x6d5d167e,0xf3f10092,0x79a30a61}},	//   צענז, _gesa, hị_, ерше
  { {0x2d8200c0,0xf9870015,0x89630015,0x27ec01d7}},	//   _icke_, سنوي_, رُون, _pmdn_
  { {0xf8670015,0x5694167f,0x69db1680,0x68e2002a}},	//   أموي_, дакт, _elue, rzod
  { {0xa6c80015,0x644b0091,0x030b000b,0x91fd003d}},	//   توغل_, _atgi, _सुलह_, krāp
  { {0x75e60010,0xe9a31681,0x8afb000a,0x44b403ae}},	//   яўле, _пасп, _ההלי, дбис
  { {0xdb1c0064,0x3a09002b,0x6560001a,0x9f94008c}},	//   _borç, _بکلی_, ramh, _kää_
  { {0xa01b00f2,0x443d0026,0x65601682,0x61ed1683}},	//   ttöm, _duw_, samh, _smal
  { {0x6b670030,0x39460533,0x656002f2,0x9f9401be}},	//   légí, ocos_, pamh, _mää_
  { {0x1a9b0053,0x39461684,0xd49a012e,0x7ae10030}},	//   זיטע, ncos_, _грк_, _ülte
  { {0x7dd80089,0xdb1c1685,0x38661686,0x6d5d1687}},	//   _písn, _forç, nsor_, _resa
  { {0x925704b6,0x7a230020,0x7e62002a,0xa01b001a}},	//   _کشور_, mõte, _łopa, mtök
  { {0x7c3d1688,0x6d5d1689,0x141b000a,0xa01b008c}},	//   _susr, _pesa, _הוגב, ltök
  { {0x42fb013a,0x12fb000a,0x1317000a,0x52830015}},	//   _להוס, _להוב, _מחול_, _أليك
  { {0x82340015,0x3f81002a,0x4c94168a,0x7dd80046}},	// [2370] _ثروا, _tchu_, нитс, _tísn
  { {0x39460077,0x2d820012,0x69db00aa,0x4ea7107b}},	//   ecos_, _ecke_, _slue, _ерма
  { {0xdb580080,0xdd0c005c,0x69da0007,0xa01b0c8b}},	//   яют_, góło, _įter, htök
  { {0x61fd0084,0xc3330008,0xa5bd0091,0x225800bf}},	//   nnsl, גוע_, amųj, árky_
  { {0xe739067a,0xb90b0015,0x78a6006f,0x1869012f}},	//   оел_, حزام_, _škvr, цали_
  { {0x27c70080,0x945d005c,0x443d0079,0x4cba004f}},	//   ящег, zyńs, _ruw_, _ומשג
  { {0x5692049d,0xa01b008c,0x6446001a,0x25a60125}},	//   вајт, ttöj, íkin, _baol_
  { {0x25a6002d,0xcb34006b,0x443d028a,0x3946168b}},	//   _caol_, _чесъ, _puw_, ccos_
  { {0xf8ae0086,0xf1bf087d,0xdb1c016e,0xa01b001a}},	//   _پکن_, rmál_, _porç, gtök
  { {0xa3e905d1,0xcad5000a,0xa01b008c,0xd7e4005e}},	//   ідна_, ֥וֹת_, stöj, _піхо
  { {0xfbd2000a,0x945d002a,0xf3f10016,0xfc3f0125}},	//   דתי_, tyńs, rị_, _luí_
  { {0x25a60c0b,0x04950015,0xa01b008c,0x67210085}},	//   _gaol_, _يلاح, ltöh, _izlj
  { {0x55ac0053,0x644b02d2,0x395f0ade,0x20b50174}},	//   _ליאַ, _utgi, _meus_, нёрс
  { {0xe820005d,0x7dd8002c,0x94040015,0x67240046}},	//   यतया_, _píso, _كونه, řije
  { {0x7413002b,0x38660030,0x4392012e,0x83fd01d3}},	//   _قوچا, zsor_, _рајс, lsőo
  { {0xe1f20086,0xc6920008,0x38660026,0xfc3f002d}},	//   _جست_, כאל_, ysor_, _buí_
  { {0x39a60780,0xfc3f002d,0xa00a0029,0x9f9400f2}},	// [2380] _jūsų_, _cuí_, _وقبل_, _pää_
  { {0x39a600df,0xafdb0cd8,0x3ebe0123,0x0eba056d}},	//   _mūsų_, spør, ätts_, _думы_
  { {0xbad50010,0xbe660015,0xa5bd0091,0xaf030033}},	//   ніцы, _تهجي, rmųj, _апэл
  { {0xa01b008c,0x38660030,0xcd360058,0x394601ec}},	//   ytök, tsor_, _يرحب, ucos_
  { {0x5fd2005d,0x395f168c,0x9f94008c,0x7e7c001a}},	//   _हवाल, _deus_, _tää_, lurp
  { {0x7a230020,0x77630251,0x25a6002d,0x38c30091}},	//   võte, ganx, _saol_, dūrą_
  { {0xa3b1005d,0x61fd002e,0xdaba0029,0xe7370054}},	//   _ऑफ़_, ynsl, _ظهرت_, мељ_
  { {0x2613001c,0xa01b168d,0x2d80168e,0x746a168f}},	//   dãos_, ttök, ngie_, оров_
  { {0xd49a0036,0x211d000b,0x38c8002b,0xd4060342}},	//   іри_, _नरेश_, _عاری_, дяни
  { {0x9f58002c,0xd3700086,0x628800d6,0xf1bf013f}},	//   torý_, دهد_, ttdo, rmám_
  { {0x2613001c,0xc7b3000f,0xdb1c01f0,0xd4130015}},	//   gãos_, _שבע_, _forå, خبيث
  { {0x22ac0046,0xa01b001a,0x83fd0030,0xf2140058}},	//   _věk_, ptök, lsől, َبَة
  { {0x7dd101d1,0xe4ea0015,0xe4d60015,0x25d70033}},	//   _måst, _بعضه_, _تتاب, _імшы_
  { {0x251b000a,0x7dd10804,0xd6e20535,0x0000006a}},	//   _וודא, _låst, pułą_,
  { {0x2ca00026,0x637b000a,0xdd950033,0xa01b008c}},	//   ewid_, _ונוד, навы, ntöi
  { {0x644f0125,0x442c0079,0x8d7700c3,0x7d770015}},	//   ícig, lmd_, باسا, باسط
  { {0xfc3f1690,0x1cb80015,0x395f1691,0x515c000a}},	// [2390] _quí_, واكب_, _reus_, _וכחו
  { {0x395f122a,0xd83812d7,0x1b7b0015,0xf24a004f}},	//   _seus_, _nič_, تصرة_, ַגְּ
  { {0x0f56000a,0xe1ff0077,0x395f0144,0x442c0079}},	//   _איתם_, onó_, _peus_, imd_
  { {0x3ebe003c,0x2011016f,0xda080015,0x319c004c}},	//   åtte_, lozi_, ويله_, ַבונ
  { {0x7b6715ed,0x3869002d,0x6e2d1692,0x395f0144}},	//   _отве, éar_, mmab, _veus_
  { {0x7b740086,0x907c0053,0x60d8000a,0x307c004c}},	//   _لطفا, קטוי, וודא_, קאונ
  { {0x395f12b3,0xe80e000b,0x260b000b,0x099b0015}},	//   _teus_, ाक़ा_, ावली_, _وضرب_
  { {0x442c0159,0xd5b10115,0xdcef0061,0x38c30091}},	//   emd_, افظ_, _hacı, tūrą_
  { {0x66021693,0x601202de,0x91fd003d,0x973c002a}},	//   _djok, kæmp, rsāl, _zaćm
  { {0xf7480015,0x69d90547,0x8cfa000a,0xa9230091}},	//   _يلقي_, lkwe, לִיח, įžda
  { {0xd24e0074,0xd6d10029,0xb81b000b,0xf486009a}},	//   ینی_, _حقا_, _पीएम_, وایی
  { {0xcf890008,0x7dd80227,0xe1ff0077,0x6aba0030}},	//   _לט_, _písm, gnó_, _átfe
  { {0xea000092,0xa3d509ef,0xb5c8002b,0x764102f2}},	//   hiết_, _подч, _تونم_, _huly
  { {0x201104ed,0x40330010,0x661b0604,0x7e7c1694}},	//   gozi_, леўс, lluk, turp
  { {0x4427018b,0x661b007c,0x9f4a0144,0xdb15006f}},	//   _ihn_, oluk, ribà_, _pozý
  { {0x45b500b2,0x764100e8,0x661b1695,0x6da310ce}},	//   עפּל_, _muly, nluk, лиса
  { {0x91fd0048,0x921700b2,0x0c260a0b,0xfce3008d}},	// [23a0] ksāj, _אַזױ_, еман, гото
  { {0xfc3f002f,0xf093000a,0x44270012,0xa3b5000b}},	//   _arís_, _ענת_, _jhn_, _चोम_
  { {0x2f5b011f,0xdb1c006f,0x76410034,0x9f5802b9}},	//   _מדינ, _horú, _nuly, borò_
  { {0x6a160086,0xceb301d8,0xdb1c006f,0xf8660965}},	//   ربار, _עיר_, _korú, евдо
  { {0x6d3b0008,0x661b0364,0x442c1696,0xba170040}},	//   _מתכנ, dluk, ymd_, ريها_
  { {0xfb560086,0xdc8b000a,0x660200cb,0xc6a60923}},	//   _سپرد, _מְלָ, _sjok, ерии
  { {0x09e60036,0x69960afb,0x8f7b000a,0xd6d00015}},	//   _зовн, _прах, לנסק, شقة_
  { {0x7bce0020,0xe7f2000b,0x76410034,0x69d91697}},	//   _hobu, _अगवा_, _duly, ckwe
  { {0x6d8b000a,0xb4da000b,0x4498005e,0xa01b0bb5}},	//   הָיְ, ठने_, євою_, stöi
  { {0x443801d1,0xb8d4005d,0xa01b00f2,0xb7da0015}},	//   ör_, जट_, ltöv, _عوضا_
  { {0x45e400a7,0x7982005c,0x442c1698,0xc7d7000a}},	//   _đượ, ogow, rmd_, _רובי_
  { {0x7982005c,0xd6db000a,0xd2570033,0xdb0e0123}},	//   ngow, _מחבל, эць_, _inbä
  { {0xd5e90029,0xe3b2002b,0x50670033,0x9f5802b9}},	//   _تعلن_, _مرغ_, этна, vorò_
  { {0x29f8002c,0xa3e4000b,0x6d430046,0x99840046}},	//   očas_, _नति_, ěnam, _nimž_
  { {0x6e9405c4,0xce94006b,0xd7b7004c,0x82b3012c}},	//   лиру, ларъ, עהלט_, _محيط
  { {0x63aa0084,0xfc3f001a,0xdb1c001a,0x6e2d02f2}},	//   _hafn, _asía_, _forú, umab
  { {0x7dd81699,0xdfd10015,0xfd130015,0x6ce7005e}},	// [23b0] _získ, _نية_, اجز_, хіве
  { {0x63aa0084,0xfbd30086,0x661b0061,0x4bfb0015}},	//   _jafn, دتر_, zluk, أعرج_
  { {0xa036013a,0xbb840029,0x9f8f007c,0x29d70061}},	//   _שאתה_, المي, _müü_, _uçak_
  { {0x9f580084,0xdb0e016e,0x91a00016,0xea000016}},	//   lorð_, _robô, _khí_, riết_
  { {0x99140036,0x91fd03e9,0x76410091,0x98a5107c}},	//   льші, esāk, _suly, тиле
  { {0x63aa0084,0x62980150,0x3695007a,0xf094000a}},	//   _nafn, _opvo, вшис, רנס_
  { {0xeb37002b,0xd705006b,0x35a50033,0x67d20004}},	//   _سرسخ, ъзки, вайг, роју
  { {0xceb4103d,0xa8490029,0xf9930002,0xdb15002a}},	//   ריק_, _يلزم_, _حبس_, _wozó
  { {0x7dd8002d,0xf8bf0107,0x661b169a,0x7a040033}},	//   _dísh, _šéf_, rluk, _сярж
  { {0x91aa005d,0x13a7002b,0x7dd80046,0x67240046}},	//   _जोड़े, رنجی_, _písk, řija
  { {0xd6db005f,0xb17b169b,0xf5950015,0x386d169c}},	//   _эта_, rhån, _للاج, _hver_
  { {0x99980024,0xcb12000a,0xa06a0709,0xdb1c006f}},	//   _kurš_, שלט_, мама_, _porú
  { {0x91a00092,0xd1320029,0x95c40015,0x53a50015}},	//   _chí_, شمس_, _حينه, _لمشك
  { {0xa0a30180,0x7982002a,0x9f58001a,0x25ad0013}},	//   јард, zgow, gorð_, ldel_
  { {0x91a00092,0x7982051e,0x7bce0d3a,0x248d169d}},	//   _thì_, ygow, _robu, ltem_
  { {0xc27a000a,0x386d169e,0xbcfb0003,0xb17b0123}},	//   _חרקי, _over_, _adéq, nhål
  { {0xe7f2005d,0x9f58002e,0xf1a90086,0xec16002b}},	// [23c0] _अगला_, borð_, _سايه_, نورد
  { {0xeafa0115,0x80890015,0x73ac000a,0x248d169f}},	//   ورات_, _أضيف_, ּיאֵ, item_
  { {0x386d02d7,0x6f790053,0xaf770053,0xed5a10b7}},	//   _aver_, _אָרג, _בעיס_, _оон_
  { {0xe9da0036,0xe8fa0080,0xc332000f,0xb86600c3}},	//   ьке_, мле_, בוב_, ناتو
  { {0x7bce0007,0xb8940015,0x88e6006b,0x7982002a}},	//   _tobu, التع, ъжде, rgow
  { {0x248d03df,0x481302e1,0xa01b16a0,0x91fd003d}},	//   dtem_, аміс, stöv, tsāk
  { {0x386d003e,0x7c3c008c,0x8c170058,0x3984009a}},	//   _ever_, _iirr, _شيفر_, _میاف
  { {0x63aa002e,0xa01b16a1,0xdbe30003,0x9f8f007c}},	//   _safn, ltöt, _réél, _süü_
  { {0x64420152,0x99870011,0x248d0012,0x5506006b}},	//   _quoi, ţiţi_, gtem_, ъчка
  { {0x3202032c,0x660d0559,0xa857039e,0xa01b16a2}},	//   enky_, čaka, _סיבה_, ntöt
  { {0x5b7b0008,0x51f9017f,0x6b7b000a,0x4b7b05bd}},	//   וריא, енню_, ורינ, וטיג
  { {0x91a00023,0x91a90023,0xcb13011f,0xc4c60015}},	//   _phí_, _khả_, ילת_, _لتتو
  { {0x7cda003d,0x50640511,0x9f8f0061,0x248d16a3}},	//   _jārā, итра, _tüü_, ctem_
  { {0xdb1c0bfa,0x92f60015,0x2005007c,0xa2e60015}},	//   _forø, _لأعض, õli_, _لأبن
  { {0x9f5809f0,0x92940010,0xdef40010,0xc2c300e5}},	//   rorð_, _сайц, апры, _نيوي
  { {0x3253010f,0x9f58001a,0x2251006f,0x61e616a4}},	//   _твър, sorð_, ízke_, chkl
  { {0xbddb1671,0x7c3c16a5,0xcfab0015,0x0000006a}},	// [23d0] _lièg, _birr, _قادم_,
  { {0x9c190029,0x7c840180,0xcb540054,0x8c19006e}},	//   رياء_, јуте, ивућ, ريار_
  { {0x443c00dd,0x248d16a6,0x8ff80015,0xdfd1002b}},	//   _miv_, ztem_, _جرير_, _نيک_
  { {0xe7e5005d,0xe2930053,0xaa580054,0x443c0a3a}},	//   कसभा_, יװע_, тицу_, _liv_
  { {0x248d0089,0xd5b6000b,0x75fe003d,0xfc330067}},	//   xtem_, _अफ़ज, cīzi, _نحس_
  { {0x7784005e,0xba770015,0x6e3d16a7,0x8c440061}},	//   иліз, _لارت, _hisb, üşer
  { {0x2f980008,0xa01b00f2,0xb17b0123,0x56390004}},	//   דכון_, ltös, thål, нџир_
  { {0x0696003b,0xa5650086,0x26c9016f,0x248d16a6}},	//   انية_, اگان, ćao_, ttem_
  { {0xb17b00c0,0xa01b0a75,0x248d16a8,0x04560015}},	//   rhål, ntös, utem_, هلية_
  { {0x7dd8002e,0x20030085,0x03a50054,0xb17b0123}},	//   _vísi, jnji_, ћино, shål
  { {0x17f80029,0x2003060b,0xf6550004,0x7d1d16a9}},	//   _شركة_, dnji_, _свеќ, _lyss
  { {0x64b50002,0xfa96000a,0x95570040,0x6e3d16aa}},	//   _محتر, נדרש_, _شخصا, _nisb
  { {0x69cb0079,0x2004016e,0xe3ae0054,0xd9fa004f}},	//   ijge, émio_, _лб_, תִיך
  { {0x75fe0024,0x443c1639,0xc916000a,0x93bc0045}},	//   vīzi, _giv_, רחשת_, umăt
  { {0xf3f0003b,0x93bc0011,0x6e3d0251,0xe81b000b}},	//   _بأن_, rmăt, _bisb, _पीछा_
  { {0x628111a9,0x63a116ab,0x65690601,0x79890034}},	//   mulo, leln, naeh, _ncew
  { {0x6b560036,0x6e3d16ac,0xa01b008c,0xac460015}},	// [23e0] гтех, _disb, ttöt, ائره
  { {0x3d04005d,0x35c5000b,0xa01b0012,0xfc3f0125}},	//   _रखीं_, वाड़, eröf, _tsín_
  { {0x4a9a0010,0xdce40091,0xa2a9000b,0x61e416ad}},	//   этаў_, maič, टिट्, _klil
  { {0x7cda0048,0x8e7b0053,0xc3320008,0x5f46002b}},	//   _pārā, _אנטה, זוב_, _جنگل
  { {0xd91702e5,0xbddb0152,0x78a900dc,0x62810020}},	//   льш_, _sièg, _csev, hulo
  { {0xf1bf00dc,0xda660115,0xbddb0003,0x76aa011d}},	//   lmát_, _ماري, _pièg, етив_
  { {0x1ae60080,0x998d002c,0x61f60107,0x66730015}},	//   _совм, _sieť_, _omyl, مدير
  { {0xa01b00c0,0x91a90092,0x7bde00c0,0x45d415f7}},	//   ntör, _thả_, lkpu, роис
  { {0xd9100074,0x24490092,0xdce416ae,0x80a4000b}},	//   _بیش_, _cúm_, kaič, _चैले
  { {0x27f80064,0x644f16af,0xb8f8000b,0x289b000a}},	//   _örn_, ícia, ाह_, _אימא
  { {0x2c170053,0xa01b048b,0x92940033,0xfc17004c}},	//   רקיש_, ktör, шанц, רקיי_
  { {0xa01b022d,0xe1350080,0x154616b0,0xf1ab0015}},	//   ytös, инны, _седм, راجه_
  { {0x20030085,0xa01b0030,0x6e3d00bc,0x63a116b1}},	//   tnji_, dtör, _risb, beln
  { {0x7d1d00c0,0x3cff0091,0x53340912,0xdce40091}},	//   _ryss, _žuvo_, _келт, gaič
  { {0x9f350191,0x539b0008,0x62810ff9,0x200301a3}},	//   реві, _ניהו, culo, rnji_
  { {0xa01b1238,0xddd500dc,0x5d5516b2,0x171b004c}},	//   gtör, tsző, ркат, גולע
  { {0x8f550086,0x200310ca,0x316b002a,0x6e3d16b3}},	// [23f0] _پنجش, pnji_, macz_, _visb
  { {0x9f4b00f2,0x2ef5004a,0xb17b0123,0x69c016b4}},	//   äjät_, _взор, skåd, _anme
  { {0xddd500dc,0xa01b00f2,0x61e4008c,0x61f60034}},	//   ssző, stös, _ylil, _ymyl
  { {0x316b005c,0xc333000a,0x19950fea,0x7bde00aa}},	//   nacz_, צוף_, радя, akpu
  { {0xad9b002e,0x42380053,0xa9680029,0xa3e4000b}},	//   _ljúk, אנאל_, امهم_, नसा_
  { {0x38580086,0x2d840061,0x6c7a000a,0x83fd0030}},	//   اشند_, _ömer_, _באשפ, lsőv
  { {0x0f580008,0x65c50080,0x316b002a,0x7bc8000a}},	//   ניהם_, ибка, kacz_, _עֶשֶ
  { {0x04950010,0x660d00bd,0x9f41002c,0xa01b001a}},	//   ароў, čako, _dlhé_, brög
  { {0xa7870087,0x63a116b5,0x5c8b000a,0xdb070046}},	//   _مشاو, teln, ׂרֵ֣, _mají
  { {0x628116b6,0x9cd8000a,0xf7480015,0xb9090157}},	//   tulo, טוחה_, _ملكي_, मन_
  { {0xdce40091,0x212901c2,0x09f5000a,0xeb92000a}},	//   vaič, _azah_, ֹמָם_, חָר_
  { {0xb1da0036,0xdb070089,0x93bc0011,0xb4950001}},	//   тьох_, _nají, umăr, _видљ
  { {0x3d04014e,0x7a230005,0x7dd80089,0x93bc0011}},	//   _रखें_, võtl, _míst, rmăr
  { {0xdff50010,0xa936000a,0x3075004a,0x917a0016}},	//   бясь, יטרה_, щуюс, _mẩu_
  { {0x316b0050,0xb7f8005d,0xa01b025d,0xfe7908f0}},	//   bacz_, ्चतम_, ttör, лёты_
  { {0x61e4003f,0x9046002b,0x0000006a,0x0000006a}},	//   _ulil, _پنده,   ,

  { {0x6c360015,0xdb0502de,0xf1bf16b7,0x75fe003d}},	// [2400] لفرا, ndhæ, rmát_, cīzu
  { {0x8b26008f,0x3ff30015,0xa01b16b8,0x0000006a}},	//   адзе, _وكير, stör,
  { {0xa01b0a55,0x3f7b000a,0x23670030,0x8f7b000a}},	//   ptör, _באיס, _menj_, _בניק
  { {0xf2960053,0x82960053,0xfbc9000a,0x201816b9}},	//   יכער_, ידעס_, ות_, lori_
  { {0xc7c600d0,0xaf360086,0x9f5116ba,0xa8870a32}},	//   иски, _حرکت, lizá_, ийца_
  { {0xdb070089,0x22400020,0x67240046,0x6aba0030}},	//   _zají, _liik_, řijm, _átfo
  { {0xb7650191,0xa5f803c5,0xc14b0016,0xdb0502de}},	//   стій, леку_, _câịp_, edhæ
  { {0x20180026,0xba5700f3,0xd5b7091c,0x4e7b004c}},	//   hori_, _כסלו_, ась_, דאקצ
  { {0xa4f80086,0xad9b002e,0xe97b000a,0xe4e6005e}},	//   دکار_, _sjúk, _שנמש, рійн
  { {0x47aa0029,0x988b000a,0xa2e60015,0x224700da}},	//   _جارٍ_, _יָבֵ, لأجن, _bunk_
  { {0x91fd0048,0x0bb70008,0xa6ca0015,0x28130015}},	//   ksāt, בלים_, _جوال_, _بولس
  { {0x54a60015,0xd49a16bb,0x7dd816bc,0xe0e70033}},	//   _نحتف, _арк_, _míss, аўго
  { {0xf9930008,0x2bc9000b,0xf8c6000b,0x201816bd}},	//   חרר_, रामा, लमिय, fori_
  { {0x7a230005,0xb7f8005d,0x75fe003d,0x224716be}},	//   võtm, ्चिम_, rīzu, _funk_
  { {0x62350254,0x52840015,0xbddb0003,0x7648002a}},	//   _леку, _العك, _nièc, _judy
  { {0xaac70074,0x5d780080,0x433b000a,0x51f40015}},	//   یتان, ийся_, _בעוב, _وسير
  { {0x40950029,0x201816bf,0x61fd16c0,0x7dd8006f}},	// [2410] _الخر, bori_, misl, _ríst
  { {0x61fd15a7,0xdd2f0046,0xf457000a,0x5ba701ca}},	//   lisl, _těžc, יימר_, јраз
  { {0xfb150015,0x2bc9000b,0x2ac70054,0x4c140015}},	//   حواج, राबा, шљав, زبكس
  { {0x12f90053,0x29d70061,0x7bca001a,0x3219097b}},	//   נהײב, _açar_, öfur, nosy_
  { {0xa8a70080,0xf813002b,0x7648002a,0xb9920015}},	//   ррек, يستگ, _audy, سلوب
  { {0x387d0026,0x764816c1,0xf7710031,0x9f580140}},	//   rrwr_, _budy, سات_, tiré_
  { {0x2ca90026,0x3f7a004c,0xdb1c002a,0xf696006e}},	//   lwad_, אָפע, _doró, منوع_
  { {0x61fd16c2,0x2a64006b,0xe70b002b,0x69c90046}},	//   jisl, _фърг, _یتان_, áleč
  { {0x22400020,0x2ca90026,0x224700da,0x9f5816c3}},	//   _riik_, nwad_, _sunk_, siré_
  { {0x91fd0024,0x9f580003,0xa7d40015,0x53c9058e}},	//   ksās, piré_, _وتلص, угом_
  { {0x7a230005,0x22560086,0x201804a1,0xcad5000a}},	//   võtj, یلید_, vori_, צוֹת_
  { {0x515a0010,0x61fd16c4,0x78bb16c5,0x0000006a}},	//   ышоў_, gisl, _kruv,
  { {0x63c20089,0x201812b9,0xca1a000a,0xa01b008c}},	//   ávní, tori_, רֵיכ, ttöp
  { {0x90d5008f,0xe8df0092,0xd91a000f,0xb4e3000b}},	//   іцяч, _ngọn_, רושל, ननी_
  { {0x201811c8,0x4356000a,0x799b002a,0xc2550040}},	//   rori_, _פסקל_, _obuw, _اختت
  { {0xfbdf0092,0x229100dc,0x93bc0011,0xdb1c00b8}},	//   _quên_, mák_, plăc, _vorü
  { {0xbddb038d,0x7bd50064,0x22910f49,0xac0a0004}},	// [2420] _sièc, _bozu, lák_, гнаа_
  { {0xbddb0152,0x6faa0001,0x9f8612ba,0xdb0e0077}},	//   _pièc, _свог_, _угод, _habé
  { {0xfe720196,0x6c330029,0x1c3903e7,0x229116c6}},	//   _عدد_, أفلا, рять_, nák_
  { {0xed5a0063,0xda650015,0xb6350138,0x0000006a}},	//   _щом_, تاكي, _кнiз,
  { {0xdb1c005c,0xcdb70008,0xd7fa16c7,0x0000006a}},	//   _poró, _הפכה_, лук_,
  { {0x229100dc,0xa09b00a3,0xba6a0015,0x613b004c}},	//   kák_, ריסט, _محرك_, אײנס
  { {0xc6770029,0x645b0152,0x22910f49,0xcaa50015}},	//   محيط_, epui, ják_, _وصفي
  { {0xfbc9005d,0x5e570053,0x3ebe00f2,0x442e07cf}},	//   राथम, זיקע_, ätty_, _shf_
  { {0x92a8005c,0x61fd0057,0x7645001a,0x6e2416c8}},	//   _małż, visl, íhyr, ilib
  { {0x61fd0176,0x03f80001,0x13f40036,0x9cd70008}},	//   wisl, рној_, ізня, צויה_
  { {0xdb9b0632,0x17570008,0x8c1b000a,0x0bb7000a}},	//   נסטר, _הסבר_, רויי, זלים_
  { {0xd46a0083,0x92930010,0x60dd00f2,0x19ca000a}},	//   _биде_, чаюц, tysm, אמֹ֑
  { {0x682d002c,0xb08b0033,0x361b000a,0x6115005e}},	//   súde, ыёне_, _גואד, ідгу
  { {0xe507000a,0x229116c9,0x6d4602f2,0x61fd16ca}},	//   _ל֖וֹ_, bák_, _agka, sisl
  { {0x6397013a,0x93fb0008,0xdd9b0063,0xb7db000a}},	//   _הדוא_, _תלוי, лша_, נקלי
  { {0xbcfb00dc,0x7bd50012,0x6e24002a,0xd657004f}},	//   _idéz, _sozu, glib, מילת_
  { {0x8bd504c2,0xe1ff0077,0x83fd0030,0x2d890416}},	// [2430] ожац, mió_, csős, rgae_
  { {0xe1ff16cb,0xab94005e,0x2bc9000b,0x6e2416cc}},	//   lió_, зифі, राधा, alib
  { {0x539b000a,0xe7c7000b,0x9f3500fd,0x0000006a}},	//   ריבו, लासप, _фені,
  { {0xddab01d9,0x3ebe0134,0x99840015,0xe1ff16cd}},	//   _стол_, ætte_, كلمو, nió_
  { {0x229116ce,0x2bc90065,0x0000006a,0x0000006a}},	//   zák_, रादा,   ,
  { {0xa08c000a,0x67d203ae,0xd24600c3,0xe78716cf}},	//   רְאִ, дољу, _ين_, судо
  { {0x99850087,0x501c000a,0xad27002b,0x98140015}},	//   _ولسو, אוגו, _خرگو, أبنا
  { {0x91a90023,0xcb12000a,0x8af8006b,0x7a2a006f}},	//   _nhà_, _חלל_, _унсс_, pýta
  { {0xb4e3005d,0xa50907bc,0xe1ff16d0,0x54c5005e}},	//   नने_, репа_, dió_, ібоб
  { {0xe2910029,0x229100dc,0x22510069,0xdb0e039f}},	//   وذج_, ták_, ízko_, _sabé
  { {0xd1ca0124,0xd5ae0086,0x23290a6c,0xdb150012}},	//   алне_, رفی_, рони_, _unzä
  { {0x36340029,0xbba6000b,0xe1ff16d1,0x229116d2}},	//   _فرنس, _ऑस्क, gió_, rák_
  { {0x20d60010,0xd408002b,0x33f50015,0x6609007c}},	//   цінс, شتیم_, _وستس, mnek
  { {0xc49a000a,0xb14301f3,0x493a000a,0x82f9002b}},	//   _כשנת, ьнял, יגרו, _پرتز_
  { {0x7f430a2c,0xe1ff04f3,0xdb1c002e,0x660916d3}},	//   держ, bió_, _norð, onek
  { {0xe1ff16d4,0x644300b6,0x644b003f,0x660916d5}},	//   ció_, _hini, _kugi, nnek
  { {0x656b0014,0xf5360053,0x644316d6,0x6e240509}},	// [2440] _megh, ַטער_, _kini, rlib
  { {0xdb070014,0x9f58002f,0xdb1c002e,0x60db00b8}},	//   _sajá, oirí_, _borð, äume
  { {0x9d4616d7,0x1619000b,0x661b16d8,0x442516d9}},	//   _менд, दवार_, kouk, ill_
  { {0x18a60036,0x661b00f2,0x6459005c,0xda650015}},	//   жадм, jouk, _otwi, سامي
  { {0x62810012,0x9c87006f,0x9f43001a,0x3ed3002b}},	//   hrlo, rečí, mhjá_, _فقیر
  { {0xdb1c002e,0x644316da,0xb7d70015,0x60bb004c}},	//   _forð, _nini, يونا_, יצנד
  { {0x644b0007,0xdb07001a,0x98a30091,0x8b2316db}},	//   _augi, _snjö, _ąją_, _ждре
  { {0x36330086,0xe1ff0251,0x1af7000a,0x99590045}},	//   وريس, xió_, _ומלל_, râţi_
  { {0x644300b6,0xe1ff02c1,0x644b02b9,0x35f7002b}},	//   _bini, vió_, _cugi, ترود_
  { {0xa2f40036,0xd4970010,0x88bd005c,0x644316dc}},	//   зпоч, іры_, _wyśc, _cini
  { {0xe1ff02c1,0xe3b80064,0x883b000a,0x64430ab0}},	//   tió_, llık_, _כתמו, _dini
  { {0x64430746,0x44250541,0xd5b0002b,0x644b16dd}},	//   _eini, all_, _سفت_, _fugi
  { {0xe1ff02c1,0xe3b80064,0xc0e40010,0x64430738}},	//   rió_, nlık_, доўк, _fini
  { {0xd250003b,0xe1ff08e0,0x93b30036,0xbddb0251}},	//   _كنت_, sió_, _обіц, _cièn
  { {0x2ee5002e,0x637b000a,0x3a2607c4,0x7a31156a}},	//   álf_, _כנגד, klop_, låte
  { {0x628816de,0xc3390089,0xe3b80064,0x667b0008}},	//   mudo, čítá, klık_, יטלק
  { {0x5ce70036,0x61ef002d,0x201a001a,0x7dd80077}},	// [2450] цюва, mhcl, ófið_, _vísp
  { {0xbc680029,0xa2be005d,0x23cd000b,0x63a80030}},	//   تمكن_, षिप्, ़ायद, nedn
  { {0xa3ab000b,0x6600002a,0x628816df,0x441b004f}},	//   ख़त_, kimk, nudo, סובס
  { {0x66000089,0xda78017f,0xd337000a,0xe3b80061}},	//   jimk, іях_, קראה_, flık_
  { {0x998d002c,0x7d250087,0x442516e0,0xed56004c}},	//   _tiež_, _رفسن, yll_, _מברר_
  { {0x27c70080,0x1a5b0029,0x3d3a0008,0x63a816e1}},	//   ющег, _نشرة_, _לגרס, jedn
  { {0xfbd2013a,0xd6a80029,0x6459005c,0xe7760015}},	//   _אתם_, قديم_, _stwi, سميث_
  { {0x2bc9000b,0xb955006b,0x44250034,0x5eec000a}},	//   रावा, _хващ, wll_, יַחְ
  { {0x644316e2,0x99900011,0x973c002a,0x661b16e3}},	//   _pini, ţaţi_, _waćp, rouk
  { {0x76c70015,0x682d006f,0x63a80030,0x442516e4}},	//   _وغال, búda, gedn, ull_
  { {0xf08900f3,0xca35000a,0x9f94008c,0x9f580125}},	//   _תנ_, ּנָה_, _käö_, uirí_
  { {0x644b0020,0x8aa8000a,0x91a90016,0x7a3100cb}},	//   _tugi, חֹשֶ, _phá_, båte
  { {0x628800df,0x64430035,0x7bc716e5,0x63a8016f}},	//   audo, _tini, _onju, bedn
  { {0x3a2600dc,0xdfd20002,0xafe607be,0x628816e6}},	//   zlop_, ريز_, чогл, budo
  { {0xf1bf002f,0x92640031,0x6264002b,0xe3b80061}},	//   mlán_, _قديم, _قايق, zlık_
  { {0x67ef0134,0x32da0008,0x7bc70375,0xed640057}},	//   _højd, _לחצנ, _anju, drží_
  { {0xdca316e7,0x5ca3006b,0x320201c0,0xac8616e8}},	// [2460] нати, нитб, miky_, ягал
  { {0x917a0092,0xa09700a3,0x60fb000a,0x70fb000a}},	//   _hầu_, _צדיק_, _להפק, _להפח
  { {0x6fdb0008,0xca750010,0x3fdb0008,0x9f580144}},	//   _הקיס, дучы, _הקיב, mirà_
  { {0x63a80050,0x8c460080,0x628f005c,0x32020227}},	//   zedn, _неме, ńcow, niky_
  { {0x29120061,0xfc3f001a,0x2bc9000b,0xba170015}},	//   çya_, _asíu_, राशा, أينا_
  { {0xdb0e0467,0xe3b80064,0x7077004c,0xa09b000a}},	//   _habí, rlık_, לײנע_, מינט
  { {0xfbc9014e,0x7a23007c,0xdb0e006f,0x63a80c1a}},	//   रारम, võtv, _kabí, vedn
  { {0x9aeb0008,0xceb30008,0xe3b80064,0x682d002d}},	//   _הַמִ, תיה_, plık_, rúda
  { {0x660016e9,0xb8650058,0x63a816ea,0x0000006a}},	//   rimk, _ياكو, tedn,
  { {0x628816eb,0x13f3004a,0xb05b04d6,0x15130138}},	//   tudo, езья, lväg, эдыя
  { {0x320201c9,0xa75b000f,0xc7b3000a,0xe6c50015}},	//   fiky_, _הדבר, _רבע_, _يتمي
  { {0x917a0023,0xdb0e0089,0x62880134,0x63a80820}},	//   _cầu_, _nabí, rudo, sedn
  { {0x7a230020,0x4fc70063,0x3cf8000b,0x55bb000a}},	//   mõtt, псва, ूपों_, _למאו
  { {0x2d9c00dc,0xa01b00dc,0x853b0008,0x9f580251}},	//   ővel_, ltöz, _הגדי, girà_
  { {0x539b009d,0xb05b00c0,0xa3b5005d,0xf413000f}},	//   _היוו, kväg, _चोट_, _אפס_
  { {0xe3b801e2,0x02450029,0x3ebe002e,0x92b30015}},	//   ldı_, _تَعَ, ætta_, _أحوا
  { {0x61ed00b6,0x67ef0134,0xb0150001,0xfbd907c1}},	// [2470] _ilal, _høje, _омиљ, одај_
  { {0xe3b801e2,0xd6ec000b,0x68e20061,0x9f5801e0}},	//   ndı_, जनाथ_, dyod, cirà_
  { {0x245216ec,0x200316ed,0xbd020079,0x8f9a004f}},	//   _lâm_, miji_, _éénm, _ויתי
  { {0xa9540036,0x200301a3,0x9f5816ee,0xeab00015}},	//   екці, liji_, mirá_, طعم_
  { {0x7a15005c,0x99d40115,0xf990002b,0x38ca002b}},	//   jąte, عتما, ابم_, قاوی_
  { {0x7a230020,0x61ed0026,0x20030a00,0xb8d5005d}},	//   võtu, _llal, niji_, _जन_
  { {0x86790010,0xb6580010,0xdce60024,0xcf58000a}},	//   цёлу_, пшых_, _iekā, הבות_
  { {0xb9c50070,0xe459080e,0xdcfd0061,0x200316ef}},	//   _تقري, ожи_, _hası, hiji_
  { {0xdcfd0064,0xc7470086,0xef19002a,0xf1bf16f0}},	//   _kası, _فضاي, ęży_, tlán_
  { {0x13090080,0x24520092,0x200309de,0xf794004a}},	//   жной_, _dâm_, jiji_, _пауэ
  { {0x442b0024,0x69c9003e,0x32020057,0x200301a3}},	//   ēc_, _knee, tiky_, diji_
  { {0xd6d8005f,0x471a00b2,0x69db0152,0xf1bf16f1}},	//   _эту_, _וועג, _joue, slán_
  { {0x250904b6,0x917a0092,0x32020107,0x0574012c}},	//   _برای_, _cấu_, riky_, _ساند
  { {0xdcfd01e2,0x917a0023,0xdce60048,0x67ef02de}},	//   _nası, _dấu_, _nekā, _føje
  { {0x50430e77,0x43720015,0x9f5816f2,0x69c916f3}},	//   терб, _شهير, rirà_, _onee
  { {0xacb60015,0xed5a005e,0x69db16f4,0x2e150058}},	//   ومزغ, іоз_, _noue, ّبْح
  { {0xdcfd01e2,0x24520092,0x3d280086,0x2003044c}},	// [2480] _bası, _xâm_, ستری_, biji_
  { {0x2003065d,0xcdc90053,0x68e2003f,0x9f580c98}},	//   ciji_, ױך_, vyod, birá_
  { {0x9f580077,0xfaaa002b,0xfc3f0077,0x7a15002a}},	//   cirá_, تهاي_, _asís_, ząte
  { {0xef17008f,0x79a30292,0xe3b80064,0xba170015}},	//   _імя_, врше, zdı_, ويلا_
  { {0x7a230005,0xd6cf0086,0xe3b80064,0xb05b00c0}},	//   võtt, یقه_, ydı_, rväg
  { {0xd0f7000a,0xb05b04d6,0x78ad016e,0x68e209cf}},	//   ומנת_, sväg, çava, ryod
  { {0x7a230020,0x7bdc002d,0x66730015,0x7791002b}},	//   tõtt, _ioru, ندير, ایما
  { {0xc8830064,0x1dd1005d,0x200301a3,0x16370015}},	//   üğü_, हायत, ziji_, وسية_
  { {0xe4520015,0x7bdc16f5,0x9f58016e,0xd6170015}},	//   خضع_, _koru, zirá_, بتوا_
  { {0x88bd005c,0xf1bf0030,0x7792002b,0xdb0e016e}},	//   _myśl, alál_, _شیبا, _gabã
  { {0xe3b80064,0x20030263,0x7a310123,0x7bdc16f6}},	//   rdı_, viji_, låta, _moru
  { {0xd257008f,0x24520023,0x38690045,0xdb1c0123}},	//   ьць_, _tâm_, ţare_, _inrä
  { {0x2003044c,0x60f804ab,0xd5cf0016,0xe63b004f}},	//   tiji_, дняя_, _kềnh_, _ותאכ
  { {0xa2be000b,0xd3b7005e,0xf1bf0030,0x9f5816f7}},	//   षिद्, _олії_, mlám_, tirá_
  { {0xff290015,0x200316f8,0xcddb0054,0xf1bf0030}},	//   سكري_, riji_, оња_, llám_
  { {0x20030263,0x63b80293,0x9f580896,0xdce6003d}},	//   siji_, _havn, rirá_, _sekā
  { {0x229800dc,0x0e440010,0x4174002b,0x200316f9}},	// [2490] lék_, тэрм, _شايس, piji_
  { {0xbcfb00dc,0xfe710086,0x63b80a00,0xfbd30115}},	//   _beér, _مگر_, _javn, ختر_
  { {0xdcfd0064,0xa036000a,0x7bdc16fa,0x629a01be}},	//   _vası, _ראתה_, _doru, ntto
  { {0xf1bf16fb,0xc3330008,0x629a16fc,0x63b80d7e}},	//   klám_, דוע_, itto, _lavn
  { {0x69db16fd,0x8d5a000a,0x186916fe,0x60090091}},	//   _voue, _מכרי, чали_, ažme
  { {0xfe700086,0xdb0716ff,0x229800dc,0x63b80293}},	//   _حدی_, _majú, kék_, _navn
  { {0xd6d1003b,0x26c102d5,0x22980030,0x3a540138}},	//   اقع_, ího_, jék_, _аксё
  { {0x917a0023,0x7bdc0064,0x229800dc,0x99840015}},	//   _mẫu_, _zoru, dék_, _للفو
  { {0xdb07002c,0x7bdc1700,0xc8b40015,0x212901c2}},	//   _najú, _yoru, _لإلغ, _nyah_
  { {0x4423002c,0x76a70015,0xdb0e0030,0xf6e708b0}},	//   ôj_, _يحاك, _habá, _оцен
  { {0x2bb2005d,0xe9ff0092,0xfbd20008,0x21290509}},	//   ीयता, _giản_, אתי_, _ayah_
  { {0xbbdc000b,0xe1f2012c,0x0000006a,0x0000006a}},	//   _मक्क, اسد_,   ,
  { {0x64a5008f,0x04c80015,0xa4390033,0xc4fb0040}},	//   _чала, _يومي_, _езду_, _بعضا_
  { {0xdb0e0123,0x7fd6008b,0x289a000a,0x63b8063b}},	//   _inbö, хімі, הישא, _gavn
  { {0xada60080,0x6da60164,0x71a60033,0xdee60015}},	//   навл, нива, _зайз, رأسي
  { {0x7bdc01e2,0x11d60029,0x25ad0150,0xc1ba0115}},	//   _soru, _ستبد, neel_, _رابط_
  { {0x7bdc1701,0x63a60030,0x0d990088,0x248d1702}},	// [24a0] _poru, őkne, ьтры_, nuem_
  { {0xa09b00b2,0x394d003e,0x1f66017f,0xb09b000a}},	//   _צייט, _ages_, _яком, _צייר
  { {0x88bd0050,0x9b930015,0x25ad1703,0xc1ba000a}},	//   _wyśl, المت, keel_, ּמְש
  { {0x60c41704,0x9f06002b,0xd910002b,0x7077002b}},	//   _krim, _يوکو, لیز_, _تمیز_
  { {0x317b0008,0x25ad0150,0x7ae5008c,0x22980030}},	//   פרסמ, deel_, ayht, zék_
  { {0x207b004c,0xf7930033,0x75fe003d,0x907b000a}},	//   לאנא, гашэ, mūzi, לטני
  { {0x2cb20176,0x63b802c6,0xa96a1705,0xcf93000a}},	//   lwyd_, _ravn, _нива_, אטו_
  { {0x04660010,0x1a9b004c,0x0f37004c,0x7af20061}},	//   нтом, _מילע, ערקט_, ıktı
  { {0x2cb20176,0x248d12b3,0x35c5000b,0x224901c2}},	//   nwyd_, guem_, वाज़, _riak_
  { {0x22980014,0xa87b0008,0x224901d7,0x80c4000b}},	//   ték_, _מאמר, _siak_, िटने
  { {0x2cb20026,0x7dd800dc,0x05661706,0x8497002b}},	//   hwyd_, _dísz, _звен, وئیس_
  { {0x629a1024,0xcb13000a,0x0665002b,0x22980030}},	//   rtto, טלת_, _شامپ, rék_
  { {0xc0cb0001,0xd5af0002,0xa3b40033,0x60c4082d}},	//   чуне_, _دفن_, _аблі, _crim
  { {0x2cb20176,0x14c9009a,0x60c41707,0x629a02ad}},	//   dwyd_, _آهوی_, _drim, ptto
  { {0x443e018b,0xbdc7006b,0x64930dba,0x6e2601d7}},	//   mmt_, нщай, ržiš, _bkkb
  { {0x2cb20176,0x442c1708,0x80be000b,0x52830015}},	//   fwyd_, lld_, शिशे, _إليك
  { {0x2cb20026,0x644a1709,0x7c970029,0x443e170a}},	// [24b0] gwyd_, _kifi, عشرا, omt_
  { {0xf1c0006f,0x0c390015,0xdb15006f,0x6288170b}},	//   čšej_, ذكاة_, _enzý, ordo
  { {0x67ef0134,0xfc300029,0x141b0008,0x443e170c}},	//   _nøja, صحك_, לומב, imt_
  { {0x443e0012,0x2cb20034,0x88bd002a,0x7ae5008c}},	//   hmt_, bwyd_, _wyśm, ryht
  { {0xa17c00b2,0x7ae500f2,0x644a002d,0x67d5170d}},	//   לטאט, syht, _oifi, коду
  { {0x00580008,0x07a50180,0x6e2d0fb7,0x7d00001a}},	//   עשות_, такн, llab, _ýmsa
  { {0x79a7008f,0xf6b20029,0xdb0e0046,0x25ad170e}},	//   _прае, لموج, _tabá, teel_
  { {0x6e2d170f,0x248d0527,0x442c15fc,0xfa37002b}},	//   nlab, tuem_, eld_, _سرزد
  { {0x8cc4014e,0x6e2d1710,0x58840033,0x62881711}},	//   रियो, ilab, _быха, erdo
  { {0xf1bf1712,0x03a50054,0x2c37000a,0x89340015}},	//   blák_, њино, עָ֗ם_, _إعفا
  { {0x6e2d002e,0xe2850063,0xf5e7005e,0x25ad042f}},	//   klab, ълни, _підм, peel_
  { {0x2cb20026,0xe4d50015,0xa5670015,0x644a0034}},	//   ywyd_, _لتتب, _أدان, _eifi
  { {0xa8790053,0x644a003f,0xdd92002b,0x69d90079}},	//   ואָר, _fifi, یوس_, ijwe
  { {0xedca000b,0x9888000a,0xa01b0012,0x6d5d1713}},	//   ाञ्छ, עָרֵ, nröh, _afsa
  { {0x91fd0048,0x7a381714,0xa2d20021,0x5f031715}},	//   mpān, líte, _نيوت, азра
  { {0xa6e90023,0x6e2d1716,0x60c40939,0x65691717}},	//   _trươ, glab, _trim, nbeh
  { {0x7a381718,0x270d000b,0x2cb20034,0x442701d7}},	// [24c0] níte, िपुर_, uwyd_, _kkn_
  { {0x2cb20176,0x6d5d0061,0x6e2d1719,0x2bd2000b}},	//   rwyd_, _efsa, alab, साधा
  { {0x2cb20026,0x6e2d0cf7,0xee3a171a,0xeb97171b}},	//   swyd_, blab, _оно_, тих_
  { {0x65690111,0x58860010,0x99460015,0x066d004c}},	//   jbeh, выка, نَاه, _נאָך_
  { {0x443e002e,0x010d000a,0x4c830033,0x442c171c}},	//   ymt_, ּלוּ, _кляв, yld_
  { {0xc8650029,0x6569002c,0x6b630286,0x6602171d}},	//   اطني, ebeh, _вкра, _smok
  { {0x764b00b6,0x644a04ed,0xa3d5000b,0xc6930015}},	//   _bigy, _rifi, हान_, لشيع
  { {0x442c0111,0x7ae31581,0x644a1610,0x764b0034}},	//   wld_, änte, _sifi, _cigy
  { {0x41d6005d,0x7a3800dc,0xa9260087,0x09e3006b}},	//   धानस, gíte, _شعره, _тотн
  { {0x442c003e,0x6e2d0024,0x52d80036,0x6e24002d}},	//   uld_, zlab, емою_, hoib
  { {0x764b00dc,0x442c171e,0x7a310123,0x3f85171f}},	//   _figy, rld_, kåtl, ólum_
  { {0xda7b000a,0xd0d5009b,0x44270072,0x644a0072}},	//   ונטר, гомъ, _ekn_, _wifi
  { {0x7a15002a,0x61f80033,0x7a38039f,0x0000006a}},	//   kątn, тняў_, cíte,
  { {0xa91d15e9,0x6e951293,0xa294004e,0xe3b8007f}},	//   _udže, лигу, _бакі, alır_
  { {0xdbdc002e,0xd378005c,0x6e2d1720,0xa2e30004}},	//   _ráðl, mać_, tlab, _војд
  { {0xd378005c,0x6e2d0061,0xb6bb015b,0x61e9007c}},	//   lać_, ulab, וצלי, öeld
  { {0x3179005c,0x24f6000a,0x30a40033,0x6e2d1721}},	// [24d0] masz_, כֶ֑ם_, _крэв, rlab
  { {0xd378005c,0x317906e7,0x6e2d0192,0xa50b000a}},	//   nać_, lasz_, slab, וּבִ
  { {0x1622005d,0xe28b0089,0xf09f062b,0x7a3800dc}},	//   मवार_, _účtů_, ltà_, zíte
  { {0xa01b002e,0x4994005e,0x3179002a,0x19590033}},	//   fsög, ишіт, nasz_, хады_
  { {0xd3780050,0x9d14005e,0xf09f1722,0xa3d5000b}},	//   kać_, _вдяч, ntà_, हाम_
  { {0x7a3800dc,0xf807006b,0xd378002a,0xe7390658}},	//   víte, ъчен, jać_, нел_
  { {0xd3780050,0x9f5102c1,0x317912f7,0x6f7a000a}},	//   dać_, lizó_, kasz_, תְנו
  { {0x26c5016f,0xa87b0029,0xcb1200a3,0x3179002a}},	//   _vrlo_, _يحذر_, _הלל_, jasz_
  { {0x75f50089,0x3179005c,0xbddb0003,0x9f510077}},	//   _náze, dasz_, _fièv, nizó_
  { {0xd378005c,0x7a381723,0x68e40201,0x33650033}},	//   gać_, ríte, äide, ывог
  { {0xf09f04ed,0x7a381724,0x420a1725,0xe1f20015}},	//   età_, síte, енно_, مسح_
  { {0x7a3800dc,0xf1bf001c,0xc049004f,0x28c70065}},	//   píte, gdá_, _זז_, लिपि
  { {0x7c250085,0x53a50b76,0xd378002a,0x03a50788}},	//   kohr, _балб, bać_, _било
  { {0x25bd0026,0xd378005c,0x25bf0011,0xe8d6000a}},	//   _hawl_, cać_, ldul_, אושר_
  { {0x93240074,0x539a0008,0x64410012,0x9f96007c}},	//   _پرون, _ניקו, mmli, müük_
  { {0xe1f20074,0x25bf1726,0x66091727,0x20d6005e}},	//   _دست_, ndul_, niek, _біос
  { {0xa3c8005d,0xf09f0144,0x25bd0034,0x6e241728}},	// [24e0] _लोड_, ctà_, _mawl_, roib
  { {0x44250b7c,0x249f002e,0xeb97067a,0x5fba004f}},	//   nol_, itum_, лиу_, _נֶ֥ג
  { {0xb05b01d1,0x6b5900dc,0x66091729,0x7f9b000a}},	//   nvän, _súgó, kiek, _אביז
  { {0xd378005c,0xceb30053,0x644100b8,0x44250f48}},	//   zać_, _פיר_, hmli, hol_
  { {0x4425172a,0xdc750010,0x6609172b,0xbbea0015}},	//   kol_, _высь, diek, _كرسم_
  { {0xa01b002e,0x93bc0011,0xa089000a,0x28b5000b}},	//   rsög, nlăt, דְקִ, _आईरि
  { {0x386600e8,0x6609049c,0x249f002e,0x44250f48}},	//   spor_, fiek, etum_, dol_
  { {0xd3780f9a,0x200a0064,0xb05b00c0,0x66090519}},	//   wać_, hibi_, dvän, giek
  { {0x44250176,0xd378005c,0x200a0064,0xc7960031}},	//   fol_, tać_, kibi_, _مشاب
  { {0x4425172c,0x3a260150,0x3179002a,0xd7570015}},	//   gol_, loop_, wasz_, _ملكت_
  { {0xd378005c,0x16660001,0x3179172d,0x25bf172e}},	//   rać_, _свем, tasz_, bdul_
  { {0xf09f02d7,0x2ca00005,0x91a0005d,0xd378005c}},	//   ttà_, ktid_, ग्लै, sać_
  { {0x3dc00026,0x4425172f,0xd378002a,0xf1bf1730}},	//   ddiw_, bol_, pać_, kláv_
  { {0xc356010f,0xf09f1722,0x44251731,0xb4b2000b}},	//   _съдъ, rtà_, col_, फ़टी_
  { {0xa36f002c,0xf09f1732,0xd35b000a,0x46f4000a}},	//   äčši, stà_, _אדול, בֶּן_
  { {0x8d770015,0x7055002b,0x2cab0045,0x9f510077}},	//   طارا, _پندا, _ppcd_, tizó_
  { {0xdbd20020,0x682d002c,0x80a40086,0x8c570015}},	// [24f0] _füüs, súdi, _همين, ائرا
  { {0x41c3014e,0x320b0876,0x66091733,0x9f510077}},	//   षयवस, licy_, ziek, rizó_
  { {0xddd00064,0x69e70033,0x2bb80015,0x7c251734}},	//   _çeşi, людз, داقة_, rohr
  { {0x320b005c,0x249f002e,0x69d5000b,0x443c007c}},	//   nicy_, ytum_, णाधी, _lhv_
  { {0x2ca00026,0xad19000a,0xaf4b002b,0x25bd1735}},	//   ctid_, _יוֹר, _تشکل_, _rawl_
  { {0x25bd0176,0x6609005c,0xa2650092,0xba770002}},	//   _sawl_, wiek, _buộ, _مارت
  { {0xec36013a,0xa2650023,0x442512f9,0x96b9018f}},	//   _כאשר_, _cuộ, vol_, тулу_
  { {0x3ebe002e,0x249f1736,0x25bf01d7,0x442500a9}},	//   ætti_, ttum_, udul_, wol_
  { {0xfa340086,0xc3d50010,0x25bf1737,0x44251738}},	//   _طرفد, аўны, rdul_, tol_
  { {0x66091739,0x13e60080,0x4425173a,0xa8480015}},	//   siek, имый_, uol_, _ملقم_
  { {0x249f1220,0x7a3800dc,0xddc70007,0x6609173b}},	//   stum_, líta, gpjū, piek
  { {0x44250176,0x249f002e,0xb05b00c0,0x7a880008}},	//   sol_, ptum_, rvän, נָתַ
  { {0xb05b00c0,0xa3d5000b,0x80260015,0x13a7002b}},	//   svän, हाद_, لرسم, _منشی_
  { {0x88bd0050,0xb4fa0008,0x34fa0447,0xb05b0123}},	//   _wyśw, _בפני, _בהנד, mväl
  { {0x645b0467,0x200a173c,0x539a0008,0x245b0092}},	//   lqui, ribi_, _ייסו, _hêm_
  { {0x8e550191,0x4d66008f,0xdd920225,0x78bb00f2}},	//   стрі, ркав, تور_, _osuv
  { {0x93bc0011,0xb05b008c,0x6b560fea,0x7a380030}},	// [2500] plăt, nväl, атех, jíta
  { {0x307b013a,0x907b00b2,0x645b0251,0x2722002c}},	//   _שאינ, _שטיי, iqui, nčné_
  { {0xf1da005d,0xdb15001c,0x78bb0209,0x600b000a}},	//   _बचान, _razã, _asuv, _יִטְ
  { {0x61e400f2,0xc3320008,0xb17b0d2b,0xe9a60010}},	//   _joil, חוב_, lkår, радп
  { {0xdb1c0152,0x61e4002d,0x2722002c,0x98a307be}},	//   _maré, _moil, kčné_, жиче
  { {0x18670001,0xf0930008,0xda660015,0x248d173d}},	//   шаљи_, קנו_, _ناري, drem_
  { {0x5b350010,0x69c1000b,0x8c1b000a,0xdb050012}},	//   _гэту, _रोकी, _סולי, gehä
  { {0x78660036,0x61e4173e,0x68eb02df,0xd8760015}},	//   _вказ, _noil, bygd, _نائب
  { {0x91830023,0x7a38039f,0x248d173f,0x0000006a}},	//   _nếu_, cíta, grem_,
  { {0x320b002a,0xdb1c0144,0xdb150030,0xe8f70054}},	//   wicy_, _parè, _hazá, _тлу_
  { {0x4b7b15bb,0xec370008,0xcb57000a,0x23b7000b}},	//   כטיג, שאיר_, יסיה_, _असरद
  { {0x61e41740,0x69c01741,0x93bc0045,0x2722006f}},	//   _coil, _jame, glăr, ačné_
  { {0xfeb80074,0x245b0176,0x61e4173e,0xd5fb000a}},	//   یافت_, _gêm_, _doil, _בפאר
  { {0x7a310123,0x25ac0091,0xb17b0789,0x9fe80015}},	//   tåtk, ūklė_, gkår, لُّم_
  { {0x69c004f9,0x34b6005d,0x9f350010,0x75f500dc}},	//   _oame, _अनुद, севі, _háza
  { {0xdb0501d1,0x5d551742,0x69c01743,0x78a21744}},	//   nehå, скат, _name, ktov
  { {0x78a2016f,0x69c21745,0xbddb0003,0x7a310123}},	// [2510] jtov, ddoe, _bièr, såtk
  { {0x6fb50087,0x7b670010,0x0a6b0180,0xeb930031}},	//   _امدا, ртае, врди_, تظر_
  { {0xcf92013a,0xd9550015,0x645b0077,0x69c200aa}},	//   _צטט_, مناخ, zqui, fdoe
  { {0x91830092,0xc333000a,0x4279004c,0xb05b008c}},	//   _yếu_, קוף_, ראײג, yväl
  { {0xf0940053,0xf1bf00dc,0xbddb0003,0xa01b0123}},	//   ַנק_, llás_, _fièr, bröt
  { {0xe8f80010,0x645d02c1,0xc864005e,0x68e4007c}},	//   шлі_, ísim, ітчи, äida
  { {0xc6680124,0x7a381746,0x657b0035,0xa3d5000b}},	//   ашње_, mítn, tauh, हास_
  { {0xff180008,0x04950010,0x69c01747,0x95991748}},	//   יקות_, броў, _game, утку_
  { {0x78bb007c,0xdb0504d2,0xadd8000a,0xf992000a}},	//   _usuv, sehä, שוחח_, _מרן_
  { {0x61e41740,0x248d1749,0x69c0174a,0x245b016e}},	//   _soil, rrem_, _zame, _vêm_
  { {0x645b11e0,0x69c0000c,0x7a15005c,0x2722002c}},	//   squi, _yame, jątk, rčné_
  { {0x245b03af,0xcb120008,0x82f40010,0xdb0800dc}},	//   _têm_, ללי_, ючыц, ülés
  { {0x70560029,0x61e40152,0xe6040015,0x45450015}},	//   إنسا, _voil, _بِنَ, _انشق
  { {0x51f60074,0x10160033,0xb1430033,0xe299174b}},	//   _گستر, сьмя, янял, _бак_
  { {0x22950029,0x52850029,0x3376000a,0x61e4174c}},	//   _العس, _البك, _העצם_, _toil
  { {0x51f60074,0x78a20156,0x64590035,0xb17b174d}},	//   _دستر, ytov, _kuwi, skår
  { {0x228301e2,0x5baa0010,0x78a204af,0xf1bf0030}},	// [2520] lık_, лкам_, xtov, rlát_
  { {0x69c0174e,0x6281174f,0xaf9a0fdc,0x0000006a}},	//   _same, oslo, _стих_,
  { {0xcf570008,0xdcef0024,0x22830064,0xc27a004c}},	//   _לבית_, _vecā, nık_, ָרני
  { {0x88860029,0x7db60029,0xf1bf00dc,0x3ebe002e}},	//   مؤتم, _اصدا, llár_, ættu_
  { {0x1754006d,0xc19b000a,0x219b000a,0x78a21750}},	//   овля, רשני, רבנא, utov
  { {0x69c0003f,0x78a2049e,0x2018001a,0x69c203f8}},	//   _wame, rtov, nnri_, sdoe
  { {0x78a21751,0x46670174,0x75f50046,0x69c01752}},	//   stov, брым_, _sáza, _tame
  { {0x9b170008,0x22830064,0xf1bf002d,0x8e7b0053}},	//   _החלה_, dık_, hlár_, אנקה
  { {0x7a380014,0x7a15005c,0xe4e6017f,0x86c6002b}},	//   líto, zątk, сійн, _گيان
  { {0x8cbb013a,0xa41c003d,0x64590034,0x4cbb000a}},	//   נציק, _ādēļ_, _duwi, נזיו
  { {0x02a30142,0x86c600e6,0x7a380030,0xb7d70015}},	//   прям, _ديان, níto, _دولا_
  { {0x224001c2,0x75f51753,0x20181193,0xdd28003d}},	//   _chik_, _táza, enri_, zēšo
  { {0x25b70074,0xb1140010,0x62810844,0x9f41006f}},	//   _دهند_, змяш, aslo, _dlhý_
  { {0x7a3800dc,0xa01b0061,0xb4d40157,0xb05b008c}},	//   kíto, erör, हमी_, lväk
  { {0xa3d5014e,0xa6f80008,0x628112d7,0x0cd1000b}},	//   हार_, בִּי, cslo, सम्म
  { {0xbd890029,0x6463002e,0x7a381754,0xf1bf00dc}},	//   شنطن_, _óvið, díto, rlás_
  { {0xf1d6005d,0xc4b6005d,0xae02000b,0x765a1755}},	// [2530] धारन, _अनोख, रोइन_, _luty
  { {0x3a2d020a,0xf1bf002d,0x41a5000b,0xa01b0123}},	//   _skep_, clár_, ग्रस, rrös
  { {0x1dc4005d,0x765a0007,0x7a381756,0x220b000a}},	//   _लोकत, _nuty, gíto, ְפְּ
  { {0x5ee80008,0xb6460033,0x7a380030,0x60cd1757}},	//   _הַשְ, _кнiж, sítn, _kram
  { {0x7a380089,0x28a7004a,0x22830061,0x7cc7002b}},	//   mítl, сшег, zık_, _ازجم
  { {0x907c0008,0xf7710015,0x22830061,0x26cc0085}},	//   רטגי, ذات_, yık_, _brdo_
  { {0xa3dc000b,0xdc3a000a,0xcf94015b,0x8f8c000a}},	//   डान_, _כעשר, לטס_, רְדֵ
  { {0x7d0909f0,0x26c700bd,0x7aea04d4,0x59f8005e}},	//   _þess, rvno_, äfte, _леся_
  { {0xa3d5014e,0x9475002b,0xe6160033,0xe4560033}},	//   हाल_, زگشا, ўды_, ожы_
  { {0x228301e2,0x981703c4,0x62811758,0xd2a9055f}},	//   tık_, _ابرا, tslo, акое_
  { {0x60cd0482,0xe9ff0092,0x28c7000b,0xcad5000a}},	//   _aram, _nhẫn_, लिवि, קוֹת_
  { {0x64590035,0x75f50264,0x6aa5130f,0xd9f9000b}},	//   _tuwi, _zázn, ithf, ंसित_
  { {0x902a0015,0x01360021,0x24190088,0x7a380030}},	//   لأسف_, تعدد, _коды_, zíto
  { {0x9e660015,0xdd010046,0x3f9e007c,0x60cd1759}},	//   قارن, štěv, ütu_, _dram
  { {0xd3470086,0x60cd0020,0xb6ac000a,0xed5a0004}},	//   _دیده_, _eram, ְׁמֹ, иов_
  { {0x7bd500b8,0xed57000d,0x60cd175a,0xc1ba0021}},	//   _anzu, жот_, _fram, _ضابط_
  { {0xac0a0004,0xa01b0123,0x60db0012,0xdca3144a}},	// [2540] анаа_, rrör, äumt, мати
  { {0x60260191,0x9f6000f2,0xb0690067,0xa01b0123}},	//   _єдна, ärät_, _اصيل_, srör
  { {0x34b6005d,0xda650029,0xb05b00f2,0x75f50069}},	//   _अन्द, كاني, yväk, _názo
  { {0xa3d5005d,0x7bc50a72,0x7a38175b,0x765a002a}},	//   हाँ_, adhu, ríto, _ruty
  { {0x79890176,0x7a380014,0x2db7013a,0x63660089}},	//   _ddew, síto, _ולכן_, nční
  { {0x7a38175c,0xab7a0015,0xa3c8000b,0xdb1c175d}},	//   píto, _خمسا_, _लों_, _harí
  { {0xf1ca014e,0xdb1c001a,0x2d800045,0xb8070021}},	//   ियान, _karí, oaie_, تيوم_
  { {0x95ca0124,0x94aa05e6,0x63660046,0x7b050030}},	//   рука_, атоа_, kční, őttü
  { {0x75fc0014,0xa3d5005d,0xe9ff0092,0x8ccd005d}},	//   _néze, हां_, _hiến_, सियो
  { {0xe9ff0023,0x03f80001,0xe6c60015,0xc34a004a}},	//   _kiến_, сној_, _وتضي, ияне_
  { {0x0bb7000a,0x75d60015,0x01d90015,0xbcfb016e}},	//   חלים_, _ويطا, مودع_, _afél
  { {0xe9ff0092,0x60cd175e,0xf20700ce,0x0000006a}},	//   _miến_, _pram, іяно,
  { {0x845a000d,0x32f50016,0x4fc70783,0x7a38001a}},	//   _трет_, áy_, осва, vítl
  { {0xe9ff0016,0xe4e90015,0x188b000a,0x7a3100cb}},	//   _phẫn_, _دعمه_, סְכּ, lått
  { {0x2263002c,0xa6f8000a,0x6397000a,0xfb00003d}},	//   ľské_, זִּי, _ודוא_, _šūnu_
  { {0x02fb0008,0x442c175f,0xc33300a3,0x2d58034e}},	//   _כלומ, lod_, _קוק_, жить_
  { {0xa80201e2,0x75fc00dc,0xdb1c0533,0x442c1133}},	// [2550] şıyo, _kézb, _darí, ood_
  { {0xe9ff0023,0x442c1760,0xa0080015,0xab94005e}},	//   _biến_, nod_, _وقيل_, дифі
  { {0x20111761,0x64480064,0x7a380030,0x7bc500cb}},	//   mizi_, imdi, mítj, rdhu
  { {0x2486010b,0x7a3800dc,0x6aa50026,0xe9ff0092}},	//   _ovom_, lítj, rthf, _khẩn_
  { {0x8dda0008,0x4dda000a,0x442c1762,0xcdf6000a}},	//   _הקרק, _החרו, kod_, _זמרי_
  { {0x20110482,0xe0df0251,0xe8080036,0x7bd500b8}},	//   nizi_, ixò_, онід_, _unzu
  { {0x96750010,0x501c000a,0xb05b007c,0x442c1763}},	//   чылі, בוגו, sväh, dod_
  { {0x8f1c000a,0xc1da000b,0x39151764,0xe6280058}},	//   יוות, _बचेग, _ембр, يثين_
  { {0x442c0176,0x58840010,0x86c50086,0x79c80029}},	//   fod_, _жыха, زيکن, _بوقف_
  { {0x7305006b,0x20110085,0x442c1765,0x9cd6000a}},	//   зпоз, jizi_, god_, פותה_
  { {0x44390048,0xc6d40029,0x20110db0,0x96f80015}},	//   ēs_, _يتمت, dizi_, _وعمر_
  { {0xdb0e0046,0x2011003d,0xc73a000a,0x5ef10065}},	//   _nabý, eizi_, _התעת, ीनन्_
  { {0x455a011f,0xa01b00b8,0xe9ff0092,0x442c1766}},	//   _הכנס, rsön, _chẩn_, bod_
  { {0x764901e2,0x2011003f,0x7fd506b4,0x22560086}},	//   lmey, gizi_, місі, _کليد_
  { {0xdee60805,0xdb1c1767,0x661b006f,0x6436000a}},	//   чови, _parí, onuk, _צאצא_
  { {0x661b022d,0x764901e2,0xee3a0010,0xe1ff0077}},	//   nnuk, nmey, ёна_, chó_
  { {0xb05b00f2,0x819b0008,0xd3470086,0xc19b000a}},	// [2560] yväi, _הספצ, _دیگه_, _השפי
  { {0x60090007,0x1d19005e,0x2d800003,0x6cd30015}},	//   yžmi, іють_, saie_, عقلا
  { {0xab69003b,0x7a3800dc,0x76490064,0xa01b008c}},	//   تحقق_, sítm, kmey, isöl
  { {0xdb1c001c,0xc8c7000b,0xaa570015,0x8276004c}},	//   _parâ, लिंट, سلها_, פענע_
  { {0xed520086,0x442c0035,0x6448002e,0xdb1c016e}},	//   _سپس_, yod_, ymdi, _barã
  { {0xe9ff0023,0x6d3b0008,0xdb0e0089,0x2609000b}},	//   _tiến_, _לתכנ, _zabý, ़ोसी_
  { {0x2486016f,0xa3d5005d,0x8c431768,0x8cc4000b}},	//   _svom_, हाई_, _чере, रिको
  { {0xceb3013a,0x442c0026,0xc9d40086,0xfb1b000a}},	//   גיה_, wod_, _تمرک, _הולמ
  { {0x38c80074,0x7d041769,0x29020123,0xdb1c016e}},	//   _بازی_, nzis, _åka_, _farã
  { {0xa2f401e5,0x7d00001a,0x6443176a,0xd326030c}},	//   дпоч, _ýmsu, _chni, зьми
  { {0x442c176b,0xe4da002b,0x67a50015,0x6448003d}},	//   rod_, _گوشت_, _تحقق, rmdi
  { {0xd257008f,0xbbc8005d,0x7982003f,0xe3af002b}},	//   яць_, रयुक, naow, پری_
  { {0x442c010b,0x5067176c,0x7a380030,0xf5ab000a}},	//   pod_, ятна, títj, _ה֑וּ
  { {0xe2f80010,0x7d040d55,0x14d7000a,0xc7b4004c}},	//   _мелі_, dzis, _מודל_, ובֿ_
  { {0xc43b0008,0x9f5802b9,0x7a380030,0x5333012e}},	//   _התגי, tirò_, rítj, _пешт
  { {0x753d005c,0x7a3800dc,0x63ba176d,0x2e4b0033}},	//   ższe, sítj, letn, сяго_
  { {0x7d040007,0xdd940010,0x2718000b,0x7a380030}},	// [2570] gzis, эаты, धपुर_, míth
  { {0x7a380f11,0x307c000a,0xf045002b,0x629a16c3}},	//   líth, _האזנ, _تعبی, outo
  { {0xdb1c08e0,0x3f83176e,0xfc300015,0xc175000a}},	//   _carà, maju_, احق_, ֵחַ_
  { {0x7aea00c0,0x63ba00dc,0x7a3800dc,0x39150a61}},	//   äfta, hetn, níth, ммер
  { {0x48ab176f,0x6d580046,0xf1bf0016,0x63ba1770}},	//   стем_, ěvat, goái_, ketn
  { {0xfe700086,0x63ba0263,0x2ca90123,0x629a1771}},	//   _جدی_, jetn, mtad_, kuto
  { {0x76490064,0x67d2000d,0x2ca91772,0x629a1773}},	//   tmey, тоју, ltad_, juto
  { {0x629a1774,0x9b440029,0xceb40008,0x05da000b}},	//   duto, _سنقو, תיק_, भाषब
  { {0x764901e2,0x3f83016f,0xdb170003,0x7a381712}},	//   rmey, kaju_, dexé, díth
  { {0x43740036,0x3f83016f,0x63ba00dc,0xdc8c000a}},	//   нуют, jaju_, getn, צְחָ
  { {0x3f83016f,0x0cba000b,0x47350033,0x7bc71775}},	//   daju_, _उन्म, _ўнес, _maju
  { {0xcf890dab,0x7a3816d2,0x2ca91776,0xa5c6002a}},	//   _כט_, gíth, ktad_, _próż
  { {0xa3c8000b,0xa4d400fd,0xaca30016,0x25ad0123}},	//   _लोक_, _поці, _diịc, mfel_
  { {0x63ba0085,0x2ca90030,0x344b018d,0x3f830085}},	//   cetn, dtad_, _учен_, gaju_
  { {0xe9ff0092,0x67ef0134,0x2bd1000b,0xa5c6002a}},	//   _nhắn_, _højs, _सफ़ा, _wróż
  { {0xee3a02e5,0x2be0000b,0xb22600fd,0xc332000a}},	//   іна_, नाभा, _імпл, _שוה_
  { {0xbc6a0074,0x3f83016f,0x7a380089,0x25ad0012}},	// [2580] زمان_, baju_, sítk, ifel_
  { {0xdb1c0251,0xeafa00e6,0x7b160029,0x3f83016f}},	//   _parà, يرات_, وظائ, caju_
  { {0xdb1c0014,0xe9ff0092,0x3fdb000a,0x7a381309}},	//   _bará, _chắn_, _וקיב, líti
  { {0xdb1c0656,0x63ba1777,0xf99200c3,0xad9b0125}},	//   _cará, zetn, ئبا_, _clúd
  { {0x307a0053,0x395200f2,0x2252006f,0x3c460015}},	//   קאַנ, äys_, ízky_, _يَجِ
  { {0x38cb0086,0x60c4003f,0x7a380030,0x7bc71778}},	//   غانی_, _msim, zíth, _gaju
  { {0xa3c8005d,0xd6d000e5,0xc6a60004,0x97c50015}},	//   _लोग_, اقب_, фрли, عتهم
  { {0xd90e002b,0x3f831779,0xe5a30054,0x6f030061}},	//   _پیت_, zaju_, вићи, _ünce
  { {0xfe37000a,0x91fd003d,0x7a380030,0x63ba177a}},	//   ורקי_, kpār, víth, tetn
  { {0xb05b177b,0xdb1c177c,0x46b60015,0x629a177d}},	//   hwäc, _zará, _يحاس, tuto
  { {0x3f83010b,0x629a00f2,0x63ba177e,0xe2150256}},	//   vaju_, uuto, retn, емны
  { {0x74130086,0x91fd0024,0x629a177f,0xc05b005e}},	//   _یونا, epār, ruto, жів_
  { {0xc5f3013a,0x3f83016f,0x7a381780,0x75d30015}},	//   _בדף_, taju_, ríth, _جينا
  { {0xbbc8014e,0xa01b01d1,0x67ef00fb,0x48f90053}},	//   रयोक, msök, _højr, פּרא
  { {0x60c40356,0xa01b00c0,0x3f831781,0x7a3800dc}},	//   _esim, lsök, raju_, píth
  { {0x7a38002d,0x3f831782,0x2ca91783,0x0000006a}},	//   bíti, saju_, ttad_,
  { {0xe81f005d,0x3f831784,0xa01b0123,0x7a310123}},	// [2590] _बदला_, paju_, nsök, dåtp
  { {0x2c6400c0,0x41dd005d,0x9f4500dc,0x2ca91785}},	//   _död_, यावस, óló_, rtad_
  { {0x386d1786,0x7bc70020,0x25ad0f50,0xdb1c1787}},	//   _ster_, _vaju, yfel_, _pará
  { {0xceb200b2,0xdb260086,0xa01b00c0,0x31bc0053}},	//   _גיט_, رونی, ksök, ַזונ
  { {0x9f58002f,0xdb1c00dc,0x7bc71788,0x58d9005e}},	//   mhrá_, _vará, _taju, яддя_
  { {0x07a20254,0xd0f8000a,0xdc88000a,0x29160015}},	//   гашн, ומדת_, _קְרָ, عقود_
  { {0x49bb0074,0x25ad04f9,0x19950010,0xa01b00c0}},	//   _وارد_, tfel_, _павя, esök
  { {0xcf58011f,0x04c90015,0x6b850049,0x62881789}},	//   ובות_, كوبي_, lahg, dsdo
  { {0x9e4c000a,0xa01b0123,0x8cd2000b,0xad9b001a}},	//   חֲזִ, gsök, ठियो, _klúb
  { {0x7d1a0008,0x25ad00c0,0x13090afa,0xc7470031}},	//   לֵיה, sfel_, зной_, _قضاي
  { {0xa91d00bd,0x6d5d0bfa,0x98140015,0x8bd6000a}},	//   _deže, _ogsa, _شبكا, גותו_
  { {0xb05b008c,0x69cb0599,0xa01b0123,0x60020016}},	//   yvät, ndge, bsök, _môme
  { {0xe9ff0023,0xa01b0030,0x38a90125,0xb05b0c9e}},	//   _nhận_, csök, núr_, dväs
  { {0x2c6400c0,0x64580876,0x68e4014b,0xd9bc000b}},	//   _röd_, _givi, äidi, _ईस्ट
  { {0xa3dc005d,0x7a380030,0x8d760015,0x6e290069}},	//   डार_, mítv, فاءا, čebn
  { {0x91fd0024,0x7a380030,0x6458178a,0x61ed178b}},	//   spār, lítv, _zivi, _goal
  { {0xf6520053,0x60c4003f,0xdd8f00e5,0x908a0015}},	// [25a0] רצן_, _usim, صول_, _عندك_
  { {0x61ed0298,0x75fc00dc,0x26c5178c,0xaec60033}},	//   _zoal, _nézn, _oslo_, _збол
  { {0x8f9b00b2,0xdb1c001c,0x9f7b000a,0x0f7b000a}},	//   _ציטי, _març, _מניח, _מריל
  { {0xa9c50033,0x427a004c,0x75f50030,0xdb0f0046}},	//   ксік, פאנג, _fázi, ádát
  { {0xb05b00c0,0x7a3800dc,0x2be0000b,0x4c67006b}},	//   lvär, kítv, नादा, _пиян_
  { {0xfaa61006,0x3c340123,0x8d76002b,0xa01b0123}},	//   _паго, rävs_, _تاگا, vsök
  { {0x8f9b0053,0x4df4005d,0x6458178d,0xb05b07c2}},	//   ליסי, _इकाई_, _rivi, nvär
  { {0xb5aa0029,0xc1ca005d,0x69e20046,0x28c7000b}},	//   سابك_, ियोग, áteč, लिखि
  { {0x76590176,0x28160015,0xdb1c0006,0x64bc000b}},	//   _diwy, _كورس, _enrô, ्टेश
  { {0xa01b01d1,0x61ed0375,0xc3390046,0xb05b0123}},	//   rsök, _soal, číná, kvär
  { {0xa01b00c0,0xb355002b,0xb05b008c,0x6458178e}},	//   ssök, نیها_, yväs, _vivi
  { {0x2d821007,0x85760015,0x753d002a,0xb05b0123}},	//   _neke_, _أدائ, ższa, dvär
  { {0xf1d6000b,0xb05b0fd8,0xf1a40033,0x60f8004a}},	//   धाजन, evär, ырэн, еняя_
  { {0xdb1c178f,0x7ee702ed,0x0000006a,0x0000006a}},	//   _garç, нцбе,   ,
  { {0x2266002a,0x7a380030,0xc7d7000a,0x61ed1790}},	//   ótką_, lítu, עולי_, _toal
  { {0xe9ff0092,0x433b0008,0xbddb0152,0xbdd50063}},	//   _phận_, _מעוב, _thèm, ъобщ
  { {0x4c941791,0x7d55006b,0x5d5516b2,0x673a001a}},	// [25b0] литс, твах, ткат, _lytj
  { {0xb603002c,0xbd440015,0x5c0402a3,0x9b950058}},	//   čšin, انكي, ляха, ئلات
  { {0xa01b00dc,0xda780010,0xb05b1792,0x62a400bf}},	//   kröz, еяч_, sväs, _úroč
  { {0x61490024,0xe9ff0092,0x8a940015,0xfaf00015}},	//   _tūlī, _thận_, اؤلا, حثك_
  { {0x28f80036,0xf09f0144,0xfd440033,0x69cb1717}},	//   нець_, nuà_, _бэрн, rdge
  { {0xd8b80015,0x307c004c,0x907c004c,0xd9420054}},	//   عدنا_, לאדנ, לטדי, јеши
  { {0xa01b0012,0x38a91793,0x98c10061,0x9782002b}},	//   rsöh, súr_, ısız_, شینه
  { {0xb606016f,0x7ae300f2,0xa91d0085,0x660d006f}},	//   ješć, äntu, _vežb, ďako
  { {0xdb1c0064,0xf1bf002c,0xc5680015,0x0000006a}},	//   _parç, deá_, رحيل_,
  { {0x75f5099c,0x39140010,0xf09f0144,0xd5d10065}},	//   _názv, _смур, duà_, _दोरज
  { {0xfbd20008,0x98140015,0xf7700015,0xb05b0123}},	//   בתי_, _إبقا, _طال_, yvär
  { {0x7a3800dc,0x3f85002e,0x151500a4,0x216a004a}},	//   sítv, ðlun_, _идея, ьими_
  { {0x7a3800dc,0xe44e006b,0xd12f0015,0x73c50015}},	//   pítv, _вж_, ْمُ_, _ليشم
  { {0x35a7005d,0x505902a3,0x889a000a,0xe29901e1}},	//   _गाड़, ешся_, ובשי, _жак_
  { {0x2d821794,0xb05b00c0,0xf772000a,0xc7b2004c}},	//   _peke_, tvär, שקל_, ױבן_
  { {0xf1bf002d,0xc692039e,0xdd920015,0xc1060021}},	//   ceá_, יאל_, شوط_, _لوبي
  { {0xd24f0029,0xb05b00c0,0xa00a0029,0x4d630036}},	// [25c0] _بني_, rvär, _يقبل_, ркув
  { {0x395f017e,0x2d8200dd,0x0e6616b0,0xb05b03a4}},	//   _agus_, _weke_, _икон, svär
  { {0x9ad50036,0xbad50010,0x7a380030,0x2d821795}},	//   люці, ліцы, zítu, _teke_
  { {0x38c8002b,0xd910002b,0xb05b0012,0x20181796}},	//   فاتی_, میز_, nwän, liri_
  { {0x718d004c,0x20180125,0x18671797,0x8b660040}},	//   לװאַ, oiri_, вачи_, _لازم
  { {0xe9ff0023,0x6d461798,0x38330033,0xd7ef0015}},	//   _phản_, _izka, анір, يكن_
  { {0xcac70175,0x86c30040,0x2ca01799,0x2018007c}},	//   _игре_, ليون, luid_, iiri_
  { {0xceb3000a,0x60d60034,0x2018179a,0x66030004}},	//   ׁיו_, _orym, hiri_, ипја
  { {0xe4e60036,0x2018179b,0x2ca0007c,0xb6060085}},	//   тійн, kiri_, nuid_, vešć
  { {0x2018003f,0x33740033,0x2249179c,0xe9ff0016}},	//   jiri_, ыгор, _shak_, _thản_
  { {0xf2c307de,0xd5a4002b,0xb05b0012,0x32fc0016}},	//   асян, _ملای, fwän, ủy_
  { {0x2ca00020,0xdb150057,0x2018001a,0x25bf0045}},	//   kuid_, _nazý, eiri_, ceul_
  { {0x7a3800dc,0x2018179d,0x249f00da,0x64a30033}},	//   líts, firi_, cuum_, _вача
  { {0xdb17001c,0x2ca00111,0xc953000a,0x60d6179e}},	//   nexã, duid_, ימר_, _drym
  { {0x0d670063,0x7a3800dc,0xbe880080,0x6602179f}},	//   възм, níts, ксте_, _klok
  { {0xd3570008,0x4357000a,0x443e17a0,0xa91d17a1}},	//   _בשוק_, _בסול_, llt_, _leža
  { {0x6abb000b,0x201817a2,0x443e17a3,0x60d617a4}},	// [25d0] ईब्र, biri_, olt_, _grym
  { {0x91a00023,0x25bf0011,0x2bbb0015,0xe04b0015}},	//   _thị_, zeul_, بارة_, _تشبه_
  { {0x49750001,0x940b000a,0x61fd0091,0xf813002b}},	//   глес, וּאֵ, oksl, یستگ
  { {0x443e018b,0x5efa0008,0x0a940036,0x7a3800dc}},	//   hlt_, _נפרד, рацю, díts
  { {0x61fd0007,0xa91d002c,0x693417a5,0x5d9a00f3}},	//   iksl, _beža, анцу, _אברה
  { {0x443e00dc,0x660217a6,0x16a9023b,0x0000006a}},	//   jlt_, _alok, евки_,
  { {0x7a380014,0xb6590036,0x099b0015,0x2be0000b}},	//   gíts, нших_, _يضرب_, नारा
  { {0x2018003f,0x36180010,0x443e17a7,0xa01b01d3}},	//   ziri_, кцыю_, elt_, csöv
  { {0x644a002d,0x998f0046,0xd5e80015,0xdce4003d}},	//   _bhfi, logů_, ضعين_, ociā
  { {0xdce40048,0x660217a8,0x249f0020,0x0478002b}},	//   nciā, _elok, ruum_, کلیک_
  { {0x66020084,0xf772000a,0x201817a9,0x7a3817aa}},	//   _flok, _הקב_, viri_, pítt
  { {0x60d6002a,0x660201c2,0x07080015,0x443e17ab}},	//   _prym, _glok, _جيمي_, alt_
  { {0x25e0014e,0x657b064e,0x201816a8,0xca1a000a}},	//   कारी_, mbuh, tiri_, תֵיכ
  { {0x04920029,0x6602005c,0xc3050015,0x23290aed}},	//   _الوح, _zlok, _مبعو, _поли_
  { {0x2018000c,0x7f190127,0xce34002b,0x539a000a}},	//   riri_, віту_, لوسک, _טיסו
  { {0x2ca00020,0x2018003f,0xd6cf0036,0x7c3e0079}},	//   tuid_, siri_, стi_, wlpr
  { {0x271f000b,0xe1f2002b,0x75f50030,0x7a380030}},	// [25e0] यपुर_, _نسک_, _házs, zíts
  { {0x207b0053,0x307b000a,0x6d460046,0xb05b0012}},	//   _ראיא, _ראינ, _vzka, nwäl
  { {0xda65003b,0x657b0035,0x1c39005e,0x99f6005e}},	//   لاني, kbuh, тять_, ляді
  { {0x53360053,0x6e9b0008,0x7e9b0008,0x7a3800dc}},	//   אנען_, _אבטח, _אסטו, víts
  { {0x46140086,0x2ca017ac,0xddc4002a,0x248d08d0}},	//   یوتر, quid_, rmiń, jsem_
  { {0x409b000a,0x3157000a,0xd7e7006b,0x9847006b}},	//   תבסס, אינן_, лмче_, ляща_
  { {0xdcfd0024,0x25e0000b,0x7c2b0324,0x66020d84}},	//   _iesā, काली_, égre, _plok
  { {0x3f8a003f,0x443e059b,0x7a380030,0x657b02f2}},	//   habu_, wlt_, ríts, gbuh
  { {0xa91d0582,0x7a38084c,0x248d00dc,0x7bce17ad}},	//   _teža, síts, gsem_, _kabu
  { {0x78a202d7,0x69c20026,0x03f80001,0x439400d7}},	//   muov, leoe, тној_, јанс
  { {0x8c370008,0x7bce03ac,0x3f85001a,0x248d17ae}},	//   רטיס_, _mabu, ðlum_, asem_
  { {0xcb13000a,0xeac7000a,0x5b57004c,0xdb1c0125}},	//   מלת_, נִי֙_, טשין_, _barú
  { {0x61fd17af,0x78a201e0,0x0000006a,0x0000006a}},	//   rksl, nuov,   ,
  { {0x7bce17b0,0xdcfd003d,0x138a0015,0x3f85001a}},	//   _nabu, _nesā, _أخشى_, úlu_
  { {0xb7db0053,0x68f9002a,0x8ca7000b,0x3219096c}},	//   עקלי, zywd, टूनो, pisy_
  { {0x7bce0035,0x6fde000b,0x78a20bf6,0x518717b1}},	//   _aabu, माउं, kuov, _сука
  { {0x3f8a000c,0x80270086,0x9c39000d,0x69c2169b}},	// [25f0] babu_, _مردم, впат_, deoe
  { {0xa91d002c,0x3f150036,0x26e4005d,0x6e2416ad}},	//   _bežn, _вдос, _कपूर_, anib
  { {0xdb1502c1,0xdce40024,0xd7f10092,0x2bb80015}},	//   _razó, rciā, _rõ_, طالة_
  { {0x2a980015,0xd337000a,0x0d64006b,0xdb150077}},	//   ائلة_, נראה_, _гърм, _sazó
  { {0x417c000a,0x2259013f,0xc4c60015,0x7bce17b2}},	//   תנדב, írky_, _بْ_, _fabu
  { {0xb8cd014e,0xe8f8008f,0xdb1e00dc,0x248d1259}},	//   _कम_, ылі_, zepé, vsem_
  { {0xdd2f0046,0x75fc0030,0xe1ff0030,0xd5e5009b}},	//   věřo, _kézh, kkó_, ижки
  { {0x86450054,0x06b8002b,0x7bce17b3,0x78a20069}},	//   јниж, انيک_, _zabu, buov
  { {0xccf20053,0xdb0500b8,0xf429045f,0x44620088}},	//   ַכט_, gehö, коил_, овыв
  { {0x68f600f2,0xa01b008c,0xddd50030,0x248d17b4}},	//   äyde, isös, iszű, rsem_
  { {0x248d17b5,0xb05b0012,0x657b02f2,0x232917b6}},	//   ssem_, rwäl, pbuh, тони_
  { {0xc1060029,0xa06a17b7,0x3f8a003f,0xf8a70029}},	//   لوجي, кама_, wabu_, ية_
  { {0x3f8a000c,0xa8790053,0x95c40015,0x3eb10012}},	//   tabu_, כאָר, _دينه, etzt_
  { {0x8fa60083,0x7d0d005c,0x661b0a6f,0x15180015}},	//   јаве, dzas, liuk, _حزمة_
  { {0xa2250074,0x3f8a0f58,0x539a000a,0x7bce17b8}},	//   _گروه, rabu_, _סיקו, _rabu
  { {0x3f8a003f,0x75f501c0,0x644117b9,0x661b17ba}},	//   sabu_, _zázr, llli, niuk
  { {0xed5a0083,0xddd500dc,0x42530015,0x7c660015}},	// [2600] тоа_, gszű, _بنير, شاذل
  { {0x9b850029,0x4f960c5b,0x60c90061,0x64410034}},	//   مؤمن, _триу, çeme, nlli
  { {0x4f9b0008,0xbf9b00a3,0x9f9b000a,0xc966042d}},	//   _בביצ, _בייש, _בסיפ, авей
  { {0xe8fa00d8,0xbcfb0030,0x4a730015,0xdca60317}},	//   кле_, _igén, زُهر, _ками
  { {0x18b8008f,0x7d0d005c,0x8d630036,0x7fe90086}},	//   углы_, czas, _євре, _شریف_
  { {0x48130036,0x660905ff,0xa91d0b28,0x9b890067}},	//   оміс, ehek, _težn, _مخفف_
  { {0xddc40024,0x290014c4,0x2cb217bb,0xcf93000a}},	//   rmiņ, šia_, ltyd_, קטה_
  { {0x64410c8d,0xa01b00c0,0x75fc0030,0x2b470061}},	//   elli, nsör, _kézi, ünce_
  { {0x186a0036,0xda5b000a,0xa99b000a,0x2cb200aa}},	//   _рази_, _יכלל, _שבמר, ntyd_
  { {0xe9ff0023,0xf36603f1,0x69080064,0x6609007c}},	//   _phần_, штин, ırdı, ahek
  { {0x7bd900b2,0xa3c5005d,0x32660180,0x5334018d}},	//   אַרק, उज़_, јтов, сент
  { {0xd5b00086,0x6609003f,0x9f58002d,0xe6120015}},	//   _رفت_, chek, bhrú_, _بشئ_
  { {0xba57000a,0xa5650015,0xa91d0046,0x6474004a}},	//   יסטו_, _ادمن, _nežl, _углу
  { {0xe9ff0092,0x33170086,0xfe730031,0xe3af0015}},	//   _thần_, ازید_, قدر_, _قرى_
  { {0x54390053,0xadbd0010,0x229400a2,0x3a260111}},	//   _געװא, навi, _البس, knop_
  { {0x735b000a,0xd35b000a,0x9f34005e,0x2cb200aa}},	//   _בכוח, _בדול, цесі, ftyd_
  { {0xb478000a,0x7c87056d,0x25e7000b,0x7c970015}},	// [2610] רָֽי, рубе, झाती_, ؤشرا
  { {0x60cd166f,0x7d0d002a,0x113c000a,0xab980015}},	//   _isam, rzas, _בתחל, لخمر_
  { {0x9e3507be,0xe0540015,0xdce70061,0x7d0d1116}},	//   _генч, _بخيب, ılıd, szas
  { {0xa2d7005d,0x0000006a,0x0000006a,0x0000006a}},	//   यित्,   ,   ,
  { {0xe9ff0023,0x01fc004c,0xdcfd0045,0x4911000b}},	//   _nhấn_, כפאל, _desă, _देखो_
  { {0x60cd003f,0xed56000a,0x8d5a000a,0xf09f17bc}},	//   _msam, _לברר_, _תכשי, irà_
  { {0xfeca0053,0xaa940477,0x66090db6,0x79a70004}},	//   ָמפּ, _мирч, thek, _врзе
  { {0x9f58002d,0xc48506a6,0x60cd09cb,0x9a840054}},	//   thrú_, блик, _osam, _фурл
  { {0xf795008f,0xe9ff0016,0x6609008c,0x60cd001a}},	//   _газэ, _chấn_, rhek, _nsam
  { {0xf7700029,0xf09f1732,0x22830030,0x840517bd}},	//   _قام_, drà_, tűk_, спож
  { {0x7c220152,0x15b90010,0xd7f817be,0x60cd17bf}},	//   éori, _былы_, _тут_, _asam
  { {0x0000006a,0x0000006a,0x0000006a,0x0000006a}},	//     ,   ,   ,
  { {0x89da0008,0x80260015,0x7bc517c0,0x3123005e}},	//   אחרי, مرسم, kehu, здяг
  { {0x43850029,0x653a0053,0x249f0134,0xa936000a}},	//   _الثق, _גענד, mrum_, מטרה_
  { {0xd138005c,0x60cd17c1,0xf09f1732,0xc2c80021}},	//   łą_, _esam, arà_, _نبيل_
  { {0x629c0024,0xf09f0251,0x8d660033,0x249f17c2}},	//   šroc, brà_, свае, orum_
  { {0x4d4a0001,0xee370010,0x249f00c0,0xf6520135}},	// [2620] упан_, ёну_, nrum_, לצל_
  { {0xf1bf002f,0x2cb200dd,0x249f001a,0x7a150091}},	//   nnán_, rtyd_, irum_, mąty
  { {0x7ed5005e,0x7c2b0140,0xdce4002a,0x249f0061}},	//   _діяч, égra, dcią, hrum_
  { {0xf1bf002d,0x9b960086,0xc3320008,0xdb0700dc}},	//   hnán_, _گلست, הוב_, émár
  { {0xadd7000a,0x5e57004c,0x98a3023c,0x2d8017c3}},	//   _הוכח_, _ליטע_, зиче, mbie_
  { {0xdb1e0014,0x2bb70089,0x4c350033,0xda6600c3}},	//   lepí, _věcí_, _дэст, _هاري
  { {0x2d80005c,0x66740086,0xdb0e00f2,0x1a7800f3}},	//   obie_, زگار, äjän, _כְּמ
  { {0xe5c60892,0x443c002e,0xe9ff0016,0x249f001a}},	//   сско, _skv_, _phấn_, frum_
  { {0x8cdb005d,0xdce4002a,0xb906123a,0x7afe1419}},	//   नियो, bcią, _узак, lypt
  { {0x600b0064,0xf09f04ed,0x94730015,0x75fc0030}},	//   _küme, vrà_, أديا, _nézv
  { {0x61f617c4,0x7c3b05bd,0x60cd008c,0x249f17c5}},	//   _boyl, רגיז, _ssam, arum_
  { {0xf09f17c6,0x64a61006,0x201a02b9,0x44220030}},	//   trà_, _гада, _ampi_, ők_
  { {0x339402bf,0x763b0053,0x44fa002b,0xf09f0144}},	//   _далё, _געאג, _حراج_, urà_
  { {0xf09f02d7,0x3e6e0089,0x61e40026,0xa8ab0008}},	//   rrà_, _být_, _enil, נֹכִ
  { {0x32b70015,0xa3c5000b,0xb698004f,0xe3b0009a}},	//   _هدية_, उजर_, יֹּת, _فرژ_
  { {0x60cd00ec,0xd251002b,0x5eb4004a,0x93250067}},	//   _tsam, _تنب_, яйст, _برهن
  { {0x7bc505c7,0x60cd17c7,0xa2d0000b,0xdfd50033}},	// [2630] tehu, _usam, धिक्, _допы
  { {0x43780008,0xbddb0152,0x7b6702bf,0xdcfd0091}},	//   שְּׁ, _chèr, стае, _nesą
  { {0x2ca00005,0xb9950087,0xeb4b0cfe,0x2d8017c8}},	//   arid_, قلاب, учак_, bbie_
  { {0x314b000a,0x2bc7000b,0x0a580015,0x2ca017c9}},	//   ְתַּ, रजहा, مؤنث_, brid_
  { {0xb05b002c,0x38ca002b,0x75fc0030,0x37891377}},	//   dväz, لاوی_, _jézu, абло_
  { {0x4cba0053,0xbddb0003,0x249f0123,0x86991092}},	//   _דזשו, _thès, vrum_, атит_
  { {0x32090717,0xa3be000b,0xb05b0012,0x05da000b}},	//   _olay_, ुजन_, rwäh, _मोहब
  { {0xb05b00b8,0xf1d9000b,0x46490004,0xa5f60054}},	//   swäh, _बोलन, јзин_, жећу_
  { {0xc7ab0086,0xdb1e0011,0xd8740015,0x37c50015}},	//   _مدال_, cepâ, _فالب, _ويرف
  { {0x320904a7,0x24520002,0x387d0034,0x61f60f0a}},	//   _alay_, ونيس, mpwr_, _soyl
  { {0x2d80005c,0x8c1a000a,0x9735002b,0x249f17ca}},	//   ybie_, שותי, _بکشا, srum_
  { {0xcad60008,0x2d8b0085,0x320917cb,0x8236006e}},	//   קורת_, _nece_, _clay_, ترخا
  { {0xa06a17b7,0x628e00dc,0x05740018,0xf3f10015}},	//   рага_, ábor, _راند, _يأت_
  { {0xee3f002c,0xc4f80015,0xa3d40033,0x602602a3}},	//   _aký_, _دعما_, _ночч, ідва
  { {0x8d760015,0x50431715,0x9e050065,0x72360058}},	//   قاءا, ферб, रसंघ_, _وربط
  { {0xf1bf0030,0xac86027a,0xbcfb0030,0x2ca017cc}},	//   nnál_, жгал, _igéj, trid_
  { {0xee37042b,0x2d800d74,0xbddb0003,0x2d8b0085}},	// [2640] іну_, rbie_, _chèq, _dece_
  { {0x8b260010,0xa91d00bc,0xeaba006b,0x2ca017cd}},	//   одзе, _težj, ийз_, rrid_
  { {0x2d8b04ed,0xf1bf00dc,0x38b20026,0x611c003d}},	//   _fece_, knál_, wâr_, sālī
  { {0xa3d5005d,0x752f005c,0x2d8b0064,0xb2ba004c}},	//   ाएँ_, żczy, _gece_, ימער
  { {0xf1bf0030,0x0000006a,0x0000006a,0x0000006a}},	//   dnál_,   ,   ,
  { {0xec340086,0x2d8b0011,0xd6d000e6,0x3857002b}},	//   _روزگ, _zece_, فقت_, يشود_
  { {0x6fad000b,0x8a0601f3,0x41aa000b,0x5fb2000b}},	//   _जासू, _дзве, _कांस, _जानल
  { {0x1637040b,0x7ae10014,0xd5b7091c,0x93bc0045}},	//   يسية_, _álta, ось_, rnăm
  { {0xa3d5005d,0x442a0001,0x05950086,0xd884002b}},	//   ाएं_, ицом_, سايگ, _رهای
  { {0x22400014,0xb8060067,0x320900da,0x344a0b1e}},	//   _akik_, _ببره, _slay_, јчин_
  { {0xe73a0036,0x320917ce,0x7982002a,0x53f70058}},	//   _теж_, _play_, obow, تريح_
  { {0x601000c0,0x80ac000b,0xb05b0123,0xf1ab00c3}},	//   _jämf, _जमशे, lväx, جاده_
  { {0xd258008f,0xf9930008,0xddcd005c,0x2d8b0045}},	//   юць_, ורר_, ymał, _rece_
  { {0x600b0020,0x2a640a1c,0xb4d6000b,0xb05b0123}},	//   _sümb, _limb_, ाटी_, nväx
  { {0x28d1014e,0xed8b0124,0xd678000a,0x65790003}},	//   _दैनि, исак_, מָּכ, _éché
  { {0xdb1c00b8,0x12770015,0x51f40015,0x9c650015}},	//   _darü, _بحوث_, _يسير, كهرو
  { {0x69c6002e,0x31690030,0x9b6b011e,0xb05b02dc}},	// [2650] _ókey, _igaz_, ашеа_, kväx
  { {0x9f58002e,0x2bb80029,0x9c470010,0x3a3f12b8}},	//   skrá_, قامة_, іхал, _skup_
  { {0xa91d10ca,0x2a6401c2,0x2bac000b,0x78a217cf}},	//   _težk, _bimb_, _चारा, erov
  { {0xbda70015,0x3f910085,0x78a201df,0x25da000b}},	//   _بحدو, lazu_, frov, _खोली_
  { {0xe9d80010,0xcd760053,0xdb15001c,0xdb1c17d0}},	//   ўкі_, _מערק_, _razõ, _baró
  { {0xf7710e85,0x46f50063,0xacfa000a,0x907c000a}},	//   رات_, зчит, _ההשכ, סטוי
  { {0xf1bf0030,0x1ab407d0,0x46a50239,0x78a217d1}},	//   tnál_, _обря, чайв, arov
  { {0xdce4002a,0x78a20787,0xbae40015,0xc4850de9}},	//   ecię, brov, _تكفي, плик
  { {0xdb1c002d,0xe525005e,0xad9b0125,0xf1bf0d46}},	//   _faró, ядип, _clúi, rnál_
  { {0x43740036,0xa91d17d2,0x28c0000b,0xf1bf0030}},	//   муют, _neži, _एहति, snál_
  { {0x7bd517d3,0x3f9e001a,0xf1bf0030,0xe2990054}},	//   _mazu, ótum_, pnál_, љам_
  { {0xdb1c005c,0xcb12000a,0xb6ba000a,0xad9b0125}},	//   _zaró, תלט_, _לצעי, _flúi
  { {0x2bac005d,0xa91d049f,0xad9b0125,0x0ef6000b}},	//   _चाला, _beži, _glúi, ीन्स_
  { {0xdb0500dc,0xd47a0008,0x0478002b,0x3f8c006f}},	//   eghí, _האסל, _بلوک_, údu_
  { {0x25ad17d4,0x7982002a,0x78a2006f,0xd37a000a}},	//   ogel_, ybow, zrov, _פרקט
  { {0x386d00dd,0x12fa000a,0x9f630046,0xe9ff0016}},	//   _ouer_, _להצב, ívám_, _thẹn_
  { {0xed57000d,0x7bd517d5,0x7f7601b0,0x75fc0030}},	// [2660] зот_, _bazu, _нунц, _kézr
  { {0x7bd504f9,0x2137000a,0xef94002b,0x1c430133}},	//   _cazu, _מטפל_, _زیرد, енум
  { {0x6ffb000a,0x7bd50012,0xf1bf0046,0xd910002b}},	//   _הפיג, _dazu, znám_, چیز_
  { {0x38c80086,0xdb1e0144,0xd910002b,0x78a217d6}},	//   قاتی_, repà, نیز_, trov
  { {0xdce4005c,0x2d92003f,0x98730033,0x7bd501c2}},	//   ycię, maye_, еліц, _fazu
  { {0x660b007c,0x7bd50045,0x69dd001a,0x25ad17d7}},	//   _algk, _gazu, _ósen, egel_
  { {0x78a20046,0xb05b0123,0x386d0383,0xdb1c0077}},	//   srov, rväx, _euer_, _varó
  { {0x25ad00dc,0xddcf0011,0x78a20901,0x35b3006b}},	//   ggel_, _micş, prov, ебър
  { {0x0ee9000b,0xb3ea0015,0x85730015,0xb4460033}},	//   _ऑप्स_, معدل_, رديئ, зэнк
  { {0xb8650029,0xd7760015,0xdb1c0003,0x9cd7000a}},	//   _قالو, _رائع, _abré, לופה_
  { {0x0bb70008,0x60c40007,0x2d9d005c,0x877b000a}},	//   הלים_, _apim, ówek_, _האבי
  { {0x60990015,0x0000006a,0x0000006a,0x0000006a}},	//   ينجس_,   ,   ,
  { {0x2d92000c,0x463b0053,0x3f910107,0x5fe7005e}},	//   daye_, _פעדע, tazu_, півж
  { {0x54530036,0xa3e3021e,0xf487002b,0x644f0003}},	//   _звіт, _पोप_, _راهی, ïcit
  { {0x69c0032c,0xb3bb0008,0x645a002e,0x7bc30020}},	//   _obme, _המוכ, mmti, õnum
  { {0xfbd30086,0xc27b0008,0x443e17d8,0x77fa000b}},	//   کتر_, _פרחי, lot_, ्सुक_
  { {0x423801e4,0x1df80080,0x442c17d9,0x2d580a61}},	// [2670] _מנהל_, четы_, ond_, зить_
  { {0x443e0048,0xf09201e4,0x69c00012,0xdde00046}},	//   not_, _שני_, _abme, ětše
  { {0x645a0cdd,0x2d9217da,0xe7f0000b,0x442c17db}},	//   imti, baye_, चाना_, ind_
  { {0x7bd5003f,0x99a80029,0xa2a4005d,0xd337000a}},	//   _wazu, كُمْ_, _किन्, הרבה_
  { {0xddc401e2,0x89370029,0x386d17dc,0x5c740010}},	//   lmiş, أعضا, _quer_, _плят
  { {0xd366003b,0x443e0048,0x7c3e04ed,0xfeb8002b}},	//   _له_, jot_, copr, _بایت_
  { {0xddc40064,0x629c00dc,0x443e17dd,0x6e2d03b0}},	//   nmiş, árol, dot_, onab
  { {0x386d0003,0xceb4004c,0x442c15fc,0x644817de}},	//   _tuer_, גיק_, end_, eldi
  { {0xda340080,0x443e17df,0x629804ed,0x69cb17e0}},	//   _четы, fot_, _avvo, mege
  { {0x04560029,0x2d92003f,0x69cb17e1,0xe4590033}},	//   ولية_, zaye_, lege, ўжо_
  { {0x69d90026,0xdb1c002e,0xd1ca0bb9,0x69cb016b}},	//   odwe, _jarð, олне_, oege
  { {0x7ae300f2,0xddcd003d,0x07080015,0x644817e2}},	//   änty, lmaņ, _عيني_, aldi
  { {0x6e2d0026,0x2004001c,0x69cb0012,0x76490061}},	//   dnab, êmio_, iege, mley
  { {0x94740029,0x764917e3,0xe7f0000b,0x443e17e4}},	//   _أدنا, lley, चाया_, cot_
  { {0x7f43005f,0x42d5005e,0x023a0015,0x7c3e17e5}},	//   верж, _цілу, _وثبت_, vopr
  { {0x6e2d0084,0x764917e6,0x765b0061,0xa3d5000b}},	//   gnab, nley, nmuy, ाएक_
  { {0x40950010,0x3eaa0011,0x60c4003f,0xf55a004c}},	// [2680] _прэт, subt_, _upim, ַדעמ
  { {0x6faa0029,0x600b007c,0x2d920003,0x6d46013f}},	//   _بهدف_, _hümn, saye_, _vyka
  { {0x764901e2,0x600b0020,0x6d46005c,0xe9da0a61}},	//   kley, _kümn, _wyka, жке_
  { {0x69cb17e7,0x443e17e8,0xb9260115,0x6b8e17e9}},	//   gege, zot_, وفاي, _webg
  { {0x442c17ea,0x644317eb,0x644817ec,0x7c3e17ed}},	//   ynd_, _okni, yldi, popr
  { {0xdb1c0084,0xebf4000a,0xd6b4006b,0x93bc0045}},	//   _farð, _אֶֽת_, ейкъ, lnăv
  { {0x6b630010,0x76490064,0x7d0401a0,0xbb460004}},	//   _акра, fley, lyis, _цевк
  { {0xceb3013a,0xf1bf00dc,0x442c0026,0xb05b00b8}},	//   דיה_, rnák_, wnd_, nwär
  { {0x64a3000d,0x26c50020,0x443e17ee,0x2cfb004c}},	//   вања, _eplo_, tot_, ַלטא
  { {0x442c0708,0xb05b0012,0xa2f4004a,0xb902000b}},	//   und_, hwär, епоч, धि_
  { {0xe57a008f,0x442c05f7,0x443e17ef,0xd5af1411}},	//   _дзе_, rnd_, rot_, _ис_
  { {0x7d04022d,0x20ca005d,0x6596002b,0xdddc0046}},	//   kyis, िबंध, _آجار, dprů
  { {0xc1050029,0x443e17f0,0xdb1e007c,0xc5130015}},	//   روسي, pot_, lepä, _لبوت
  { {0xddc40064,0xa294042b,0xdb1e016e,0x7d16002a}},	//   tmiş, _закі, cepç, dzys
  { {0x629500dc,0xd0100015,0xb05b0012,0x69d90034}},	//   ázot, جلّ_, fwär, ydwe
  { {0xddc40064,0xc3330008,0x600b0020,0x7c870001}},	//   rmiş, _שוק_, _gümn, дуже
  { {0xde640063,0x69cb17f1,0xdc550180,0xd904002b}},	// [2690] търп, vege, евањ, _ئی_
  { {0x76490064,0xa4b7000a,0xeb4b004a,0xbc4b0033}},	//   zley, ולמה_, очек_, ічае_
  { {0x76490064,0x764017f2,0xbf150015,0x765b0061}},	//   yley, komy, _أوجب, ymuy
  { {0x7640005c,0xdb1c002e,0xdddd005c,0xf1bf002d}},	//   jomy, _varð, _wisł, nfá_
  { {0x4e160008,0x7d16005c,0xad9b002d,0x5d7a0135}},	//   _נחשב_, czys, _dlút, _מארק
  { {0x78ab1786,0xf807005e,0x69cb17f3,0x628117f4}},	//   rugv, ьчен, sege, yplo
  { {0x76490064,0xba740015,0xcff8000a,0xcb440bb1}},	//   tley, _لاقت, וצגה_, _ахти
  { {0x6ec20065,0x24f500ce,0xad9b059d,0x0000006a}},	//   _लहसु, ечор, _glút,
  { {0x764917e6,0x3e7500c0,0x48770086,0xe7e0021e}},	//   rley, _låt_, _آدرس, _गोवा_
  { {0x62810234,0xdb1e007c,0x5285007e,0xebfa000a}},	//   tplo, bepä, нгоб, ִּים
  { {0x764902f2,0xc7d6000a,0x4a59000a,0x0ece000b}},	//   pley, _רועי_, ּדָו, _हैंड
  { {0xc049000a,0x9635005e,0x7d16002a,0x628117f5}},	//   _הז_, _янец, yzys, rplo
  { {0xa3b7005d,0xe5070015,0x65070015,0x628117f6}},	//   _छाप_, _تباي, _تذاك, splo
  { {0xb4fa000a,0x34fa000a,0x9f9b007c,0x7d04008c}},	//   _מפני, _מהנד, jääk_, vyis
  { {0x84640063,0xe7f0000b,0x92b50015,0xf772000a}},	//   _ръце, चाता_, _أحتا, רקל_
  { {0xee3a0191,0x7d04022d,0x660917f7,0xc6920135}},	//   їна_, tyis, nkek, טאל_
  { {0x4425002d,0x644117f8,0xa3b6000b,0xb05b0012}},	// [26a0] oil_, ooli, ङ्क_, rwär
  { {0x7d160050,0x113b000a,0x644117f9,0x6e24007c}},	//   rzys, _מתפל, noli, siib
  { {0x7d16005c,0xca750010,0xa3b7000b,0x61da000a}},	//   szys, вучы, _छान_, ּקְד
  { {0x6aa3002f,0xf99200e6,0x60970086,0x442517fa}},	//   ánfa, ابا_, _تنیس_, hil_
  { {0x49730010,0x644104c6,0xdb1c0125,0x2fda02f2}},	//   уліс, koli, _ibrí, _kapg_
  { {0xf093000a,0xd7e70054,0x98e30015,0x442517fb}},	//   ננו_, емље_, اكوو, jil_
  { {0x644117fc,0x0cd0000b,0x387f15ca,0x442517fd}},	//   doli, _हनुम, _etur_, dil_
  { {0xcb670010,0xdb1e0020,0x629c0024,0x2abb000a}},	//   _часе_, repä, šrok, _ממלא
  { {0xddde003d,0xdbd7007c,0xdb1e17fe,0x442517ff}},	//   _atpū, _fääs, sepä, fil_
  { {0x64410176,0xdcef0024,0x44251800,0x78660015}},	//   goli, _secī, gil_, _أدرك
  { {0xa3b6005d,0xb05b0012,0xc7b3000a,0x63a7002a}},	//   ङ्ग_, ltäg, _תבע_, ójna
  { {0x4425002f,0xdb210030,0x6441007c,0x1677004f}},	//   ail_, ütés, aoli, _נגדל_
  { {0xc05b0036,0xb5fb000f,0x489b004c,0xc5160067}},	//   зів_, _מלאכ, ּילװ, _ثبات
  { {0x44251801,0x20d60085,0xf1bf0125,0xe0df02b9}},	//   cil_, džić_, sfá_, rvò_
  { {0xdd950010,0x6f640015,0x9f34005e,0x7c25005b}},	//   кавы, ُهُم, гері, vihr
  { {0x629a115b,0x432b000a,0xe7e70065,0x93bc00d4}},	//   msto, _מֵחֲ, _टोना_, rnău
  { {0x629a1802,0x30150010,0x2ba70054,0x61ed1803}},	// [26b0] lsto, _адпр, ејев, _inal
  { {0x600b1804,0xbca40015,0x2bbb0015,0xe7e0000b}},	//   _kümm, املي, ثارة_, _गोला_
  { {0xd0110086,0x25bf00da,0xe9d9002a,0x90340015}},	//   _ملک_, yful_, _paź_, _حريص
  { {0xc27b0008,0x64410fcd,0xdbd70607,0x629a1805}},	//   פרדי, zoli, _sääs, isto
  { {0xfd96013a,0xdbd70c58,0x6441003f,0x2d89003f}},	//   _בדרך_, _pääs, yoli, mbae_
  { {0x25bf003e,0x46a50054,0x2ca90123,0x78a40030}},	//   wful_, вакв, mrad_, áiva
  { {0x25bf003e,0x44251806,0xcf2c000a,0x629a1207}},	//   tful_, vil_, ּֽוֹ, jsto
  { {0x78a4010b,0x44250b90,0xb6580010,0x2ca91807}},	//   šiva, wil_, ншых_, orad_
  { {0x34b20029,0x25bf14e6,0x44251808,0x629a1809}},	//   لميز, rful_, til_, esto
  { {0x2b9c0089,0x13090256,0x64580046,0x6441180a}},	//   mácí_, дной_, _chvi, uoli
  { {0x8bd6000a,0x4425180b,0xa856000a,0x38bb00aa}},	//   דותו_, ril_, _סיעה_, lêr_
  { {0x412a0142,0xe5e50086,0x4425180c,0x644103fe}},	//   домо_, _جزئی, sil_, soli
  { {0x660600dc,0x69db00b8,0x2242180d,0x25b600e6}},	//   ökke, _maue, rokk_, _شهود_
  { {0x2ca9180e,0x6fd50033,0x629a180f,0x69db1810}},	//   drad_, лісц, bsto, _laue
  { {0x539a013a,0xa0671811,0xdb051812,0xf852006f}},	//   _חיצו, тара_, nghä, úžiť_
  { {0xe8df0092,0x3ea5084c,0xf1bf08fa,0x02460058}},	//   _cuịa_, álta_, lián_, _جَبَ
  { {0x8e550036,0x4d660010,0x3b96009c,0x93bc0045}},	// [26c0] утрі, ткав, вјет, mnăr
  { {0x61ed037f,0x3157000a,0xaf0601e8,0xf1bf1813}},	//   _znal, _ביפן_, _апол, nián_
  { {0x69db0ecc,0x93bc0045,0x2ca91814,0x3f98097a}},	//   _baue, onăr, arad_, maru_
  { {0xfaa3008f,0x3c940086,0x2ca91815,0xa2a4000b}},	//   рацо, _میرز, brad_, _किस्
  { {0x69db00b8,0xa9670c45,0xd7fa02db,0x0000006a}},	//   _daue, вица_, дуй_,
  { {0xbcfb0014,0xdb21002c,0x629a1816,0x25da000b}},	//   _egés, štát, ysto, _खोजी_
  { {0x48ee005d,0x99860015,0xfaa60004,0x2ba4003d}},	//   _आपको_, _للأو, _јабо, rīcē_
  { {0x7f3b0008,0x76591817,0x7bdc013c,0x3f981818}},	//   ועצו, _chwy, _haru, haru_
  { {0x26030467,0x78660010,0xb05b008c,0x3f981819}},	//   _años_, _аказ, ltäe, karu_
  { {0xe3af0015,0x7bde181a,0x741400c3,0x629a181b}},	//   يرٍ_, ndpu, اودا, tsto
  { {0x04430004,0x3f98181c,0xb05b008c,0x629a181d}},	//   реќн, daru_, ntäe, usto
  { {0x92930010,0x7bdc015a,0xb0de000b,0xba9b05bd}},	//   шаюц, _laru, मिंग, וסטי
  { {0x63f60015,0x3f980034,0xd0110015,0x629a181e}},	//   _لأغر, faru_, ملح_, ssto
  { {0xc9530008,0x629a181f,0xc05801c6,0x7bdc1820}},	//   שמש_, psto, віс_, _naru
  { {0x5f941821,0xcddb0054,0x7f940088,0x6e94004a}},	//   рист, мња_, расх, ииру
  { {0x61ed06e8,0x4e180021,0xddc4002a,0xee840033}},	//   _unal, نتقد_, elił, рыро
  { {0xe3900023,0x7bdc000c,0x7d55006b,0x68e21822}},	// [26d0] _điề, _baru, увах, jvod
  { {0xdfd10086,0x600b0064,0x69db1823,0x7c14005e}},	//   _ايد_, _mümk, _saue, адує
  { {0xba740115,0x2ca90123,0x7bdc1824,0x8f19000a}},	//   لانت, srad_, _daru, _נוֹת
  { {0xc33301e4,0x601000c0,0xc9870054,0xdb0e0030}},	//   בוע_, _jämn, тужи, _abbó
  { {0x76590176,0x621c0053,0x80d9000b,0xcf27002b}},	//   _rhwy, וואק, मिटे, _سرگي
  { {0x601000c0,0x38bb00dd,0x7bdc1825,0xed580033}},	//   _lämn, rêr_, _garu, _шоў_
  { {0x8cdb005d,0x76590026,0x68e20796,0x5692009c}},	//   निको, _phwy, avod, бајт
  { {0xcf580008,0x601000c0,0x24590003,0xe8e00016}},	//   כבות_, _nämn, ième_, huột_
  { {0x9525002b,0x24590f1c,0x63a7002a,0x58d40248}},	//   دکام, hème_, ójno, _котт
  { {0x87d70031,0xe8550015,0x6b950085,0xa819000a}},	//   _جغرا, _صناد, _jezg, _אֵ֣י
  { {0xcad5000a,0xa22a0a0b,0x76590034,0x3f981826}},	//   נוֹת_, ежна_, _thwy, varu_
  { {0x62480077,0x24590003,0x3f981827,0xa2a40065}},	//   eñor, dème_, waru_, _किर्
  { {0x93bc0045,0xddc4002a,0x9567006b,0x3f981828}},	//   rnăr, ylił, _ръжд, taru_
  { {0x705600e6,0xdd2f0089,0x2a6d0012,0x2249007c}},	//   انسا, měňo, _lieb_, _ekak_
  { {0xdb1c04af,0xada60a61,0x69c20034,0x68e21608}},	//   _obrá, лавл, yfoe, zvod
  { {0x7bdc1829,0x2bc6005d,0x3f98182a,0x1ea90058}},	//   _saru, र्ना, saru_, ضافي_
  { {0xf1bf00dc,0x22980089,0xee370666,0xdd8f0015}},	// [26e0] rnát_, _týká_, унт_, ثوق_
  { {0xb05b00f2,0xd0f7000a,0x00f7000a,0x4d63182b}},	//   ttäe, _עמית_, _עזים_, скув
  { {0x60100012,0x6b950045,0x7bdc182c,0x7fd7000a}},	//   _hämo, _dezg, _varu, _גויס_
  { {0x02b60053,0x7bdc182d,0x6abe0012,0xc9850015}},	//   טלעך_, _waru, rtpf, لشهي
  { {0x984a182e,0xba170015,0xb05b008c,0xa3b30157}},	//   няка_, دينا_, stäe, टला_
  { {0xa09b0135,0xd6d00015,0xa3e3000b,0x6c360015}},	//   גיסט, ققت_, _पोल_, _إفسا
  { {0x394d003e,0x7584002b,0xb05b0123,0x8ad8000a}},	//   _eyes_, لیام, ltäc, _בַּפ
  { {0xa5bd0091,0xa6c70021,0xfa67009b,0x0000006a}},	//   liųj, اويل_, _баск_,
  { {0x27ef0089,0x75fc00dc,0xd3700015,0x99160033}},	//   ální_, _kézz, يهة_, _сьві
  { {0x1cbb0053,0x986a0015,0x9cd7000a,0x224902de}},	//   עמיע, _أحرف_, נויה_, _skak_
  { {0x2bc6005d,0xe9ff0092,0x2bf7000a,0x6354004a}},	//   र्या, _chặn_, אמין_, рвну
  { {0x54e60225,0xa2d5000b,0xdb050012,0xf1bf0046}},	//   _مستق, _बनर्, pfhö, ciál_
  { {0x3d00005d,0x75d300a2,0x6283182f,0x0000006a}},	//   ोनों_, _دينا, _etno,
  { {0x2bc6014e,0x75fc0014,0x60100012,0x24590003}},	//   र्मा, _nézz, _dämo, tème_
  { {0xaed5005e,0xce95006b,0xe1ff0030,0x6b950030}},	//   шовш, рабъ, tmód_, _rezg
  { {0x66020005,0xc1050029,0x24590003,0x52830015}},	//   _jook, _نوعي, rème_, _اليك
  { {0x82340086,0x20010020,0xcd340029,0x2bc6005d}},	// [26f0] _دروا, _tohi_, مركب, र्भा
  { {0x6602003e,0x6fb2005d,0x60cd0035,0x7d0200f2}},	//   _look, _जाएं, _ipam, äosa
  { {0xbcfb0030,0x539b000a,0xdddc0085,0xe1ff0030}},	//   _egép, גיבו, sprš, pmód_
  { {0x5efa000f,0xfde9000b,0x2bc6000b,0xf9900015}},	//   _ספרד, _ऑफिस_, र्बा, كبه_
  { {0xa9350080,0x88c40015,0x6b950061,0x200c0123}},	//   шедш, متول, _tezg, ödig_
  { {0x6010079c,0x807c004c,0x80ad000b,0xa7a600af}},	//   _näml, ענוצ, _जिने, акша_
  { {0xe5710029,0x66021830,0xc9871831,0x87d40138}},	//   يطة_, _book, _бузи, ёўшч
  { {0x7aea00fb,0x46e6006b,0x66021832,0xaa590920}},	//   æfte, рдън_, _cook, _рибу_
  { {0xf1bf0227,0xc7d9006b,0x5dc8000a,0x84590004}},	//   riál_, _имах_, אֶתְ, крот_
  { {0xe4c80029,0x89340015,0x03a50099,0x44d6002a}},	//   ابين_, _اعفا, јино, _dł_
  { {0xfbd20008,0x6602007c,0x9694005e,0xa5d50004}},	//   חתי_, _fook, _гріш, _вжеш
  { {0x016603fc,0x9732002b,0xd1c70033,0x2005001a}},	//   икно, _بکها, алюе_, ölin_
  { {0xe0d7010f,0x998f0007,0xf1bf006f,0xa5090054}},	//   авя_, logų_, ciám_, _јела_
  { {0x8e86004a,0x7f1a009a,0xa06a00af,0x0fd90132}},	//   игге, پيرز_, ђава_, льсы_
  { {0x44d6005c,0x92f60087,0xfd96005e,0x5f03023c}},	//   _zł_, _نفوذ_, ишаю, озра
  { {0xdcfd003d,0xb13a0015,0x98c5000b,0xd1ba0015}},	//   _nesē, _لأخذ_, लझाए, _شابا_
  { {0x4c850029,0x9c2606eb,0x8fa61833,0x0c2609d3}},	// [2700] مؤلف, адад, _капе, аман
  { {0x515b013a,0x309b0008,0xb09b000a,0x7aa60015}},	//   _בכפו, _ששימ, _שייר, لإصل
  { {0xdef9008f,0xf1eb005d,0xfaf60033,0xb05b0123}},	//   _быў_, _जोड़_, шчаю, stäc
  { {0xda65003b,0xb05b00c0,0xa5bd0091,0x6e9b000a}},	//   ماني, ptäc, siųj, _בבטח
  { {0x68e91834,0x6edc000b,0x5cf6004a,0x09360067}},	//   _cred, _पनडु, _тяну, جراج
  { {0xb8ce0372,0xb8fe000b,0xeef6000a,0x2d801835}},	//   _कि_, _तन_, ֹמֵר_, lcie_
  { {0x68e91836,0x8f9b0053,0x3e7c0089,0x2bc6005d}},	//   _ered, דיצי, _jít_, र्णा
  { {0x3e7c0089,0x2d801837,0x95ca0350,0x0d96000a}},	//   _mít_, ncie_, тука_, ׁכֶם_
  { {0x68e91838,0x44271839,0x3e7c0016,0x7e64008c}},	//   _gred, _bmn_, _lít_, imip
  { {0xe3b80064,0x14180015,0x2ca0007c,0x2a78007c}},	//   lnız_, ايدة_, isid_, _kurb_
  { {0x2d80066f,0xa823002b,0xf7460004,0xa01b0030}},	//   kcie_, _بکنن, _тежо, spök
  { {0x2bc6014e,0x2ca00005,0xe4e60036,0x2d80005c}},	//   र्ता, ksid_, _вікн, jcie_
  { {0x60100123,0x25a6183a,0xf8d40065,0xdce401ec}},	//   _täml, _idol_, _धनोप, gaiļ
  { {0x2d80005c,0x629c00dc,0x2ca00020,0xc7b1000a}},	//   ecie_, áros, dsid_, ּ֑ם_
  { {0x93fb0008,0xf09f183b,0x33fb000a,0x442c03b5}},	//   _בלגי, ssà_, _בהגנ, mid_
  { {0xef19005c,0x13170008,0xc104002b,0x02440015}},	//   ąż_, _כחול_, _ژويي, _وَوَ
  { {0x442c0111,0x64480201,0x8264002b,0x25d7000a}},	// [2710] oid_, oodi, _بهين, סומן_
  { {0x442c183c,0x6448183d,0x7e64007c,0x2d80002a}},	//   nid_, nodi, amip, acie_
  { {0x2bc6014e,0x68e9060b,0x2a7800da,0x2ca0007c}},	//   र्धा, _sred, _curb_, asid_
  { {0x68e9183e,0x442c183f,0x644817d1,0x2d801840}},	//   _pred, hid_, hodi, ccie_
  { {0x89a80036,0xb9c40029,0x442c1841,0x48e50bb1}},	//   рків_, تقني, kid_, солв
  { {0xcc760008,0x98f40029,0x6e2d003e,0x9695049d}},	//   _לגשת_, تثما, liab, бриш
  { {0x442c1842,0x2a78002d,0x56920054,0x3e7c0016}},	//   did_, _gurb_, пајт, _xít_
  { {0x0f380008,0x1f38000a,0xdb160125,0x68e9153c}},	//   ירוט_, ירור_, _ócái, _tred
  { {0x2d9904ed,0x68e9060b,0x64480026,0x7d0d1843}},	//   _mese_, _ured, fodi, nyas
  { {0x2d9906f5,0x33f50894,0x442c1844,0xf8ae002b}},	//   _lese_, счис, gid_, _سکه_
  { {0x249f0084,0x8c1a0008,0x2d80005c,0xddc60024}},	//   ssum_, רותי, ycie_, _likš
  { {0xc8790064,0x360400a2,0x2d991845,0x442c1846}},	//   _kuş_, _وولف, _nese_, aid_
  { {0x442c1847,0xd656000a,0xddc60085,0x3e7c0016}},	//   bid_, _פינת_, _nikš, _sít_
  { {0xaf360015,0x644805ef,0x2d80002a,0x7d0d1848}},	//   مرأت, codi, wcie_, dyas
  { {0xa8560008,0x6e2d0493,0xf772000a,0x539a000a}},	//   מישה_, fiab, לקם_, _עסקא
  { {0xf2d20053,0x2ca00020,0xddcd0064,0x82840015}},	//   _זעה_, tsid_, rmaş, _بجول
  { {0x6e360007,0x61eb002d,0x7fd6042b,0x2d801849}},	// [2720] rnyb, _ógla, _ліні, rcie_
  { {0xe0fb0008,0x2ca00020,0xb05b0f7a,0x0ba90015}},	//   _עליל, rsid_, ltän, لامى_
  { {0xd24f0086,0x2ca00020,0x329a004c,0xb6ab005e}},	//   _زنی_, ssid_, ָבנד, _змiн
  { {0x753d005c,0xceb3000a,0x6448184a,0x2d9900aa}},	//   ższy, _ציר_, zodi, _gese_
  { {0x91bb0008,0xdb1e00dc,0x64480064,0xe3b80064}},	//   רמני, lepü, yodi, ygı_
  { {0xf0930008,0x442c184b,0x98a70061,0x0000006a}},	//   לנד_, xid_, şiği_,
  { {0x6448184c,0x07a3049d,0x09e617b6,0xddc4003d}},	//   vodi, чајн, _ловн, rliņ
  { {0x442c184d,0xf1bf00dc,0xd5ba024e,0xcb37004f}},	//   wid_, riák_, уск_, _האלי_
  { {0x38cb0074,0x6934002b,0x14f40033,0x6448184e}},	//   _مالی_, _بکار, ізоў, todi
  { {0x3e4100df,0xccf3000a,0x74140015,0x7982002a}},	//   mėte_, פכת_, زوجا, lcow
  { {0x95ca0191,0xd80b0008,0x442c184f,0x51f9042b}},	//   _була_, _עִמָ, rid_, анню_
  { {0x442c0005,0x661b000c,0x64481850,0xdb1e002a}},	//   sid_, chuk, sodi, lepó
  { {0xc5f30008,0x248600c0,0x2d9902b9,0x442c1851}},	//   _מדף_, _utom_, _rese_, pid_
  { {0x2005002e,0x46dc000b,0x94bb000a,0x5f740015}},	//   ðli_, _मनाह, _עמות, كافر
  { {0x2d9902c1,0x877b039e,0xb4250031,0x59c8000b}},	//   _pese_, ראלי, _بعنو, रभार
  { {0x3e410007,0x7e550036,0xd57a000a,0x8337000a}},	//   kėte_, іває, אָ֑ר, _לאוס_
  { {0x7c970029,0x80a4002b,0x6ad1000b,0x6e2d1852}},	// [2730] إشرا, _فمين, सब्र, riab
  { {0xfbd00086,0x3e410007,0x7d0d117f,0x916d0016}},	//   فتم_, dėte_, ryas, _nổi_
  { {0x7d0d01e2,0xe37b0053,0x6d41005c,0x3ad50087}},	//   syas, ארבר, _ślad, تياز
  { {0x7d0d0064,0xb95505c4,0x9cf50033,0xb2bb004c}},	//   pyas, овещ, _дзмі, רמאר
  { {0xb23c0053,0x3e410091,0x98c70b9b,0x48ab098b}},	//   נעדז, gėte_, ссел, утем_
  { {0x6d5d0024,0xba7700a2,0x31580643,0x18691853}},	//   _izsa, _هارت, ציגן_, шали_
  { {0xb05b022d,0x3619004a,0x6fac000b,0xd6a9002b}},	//   ytän, ицию_, _जयसू, شگام_
  { {0xc485111b,0x34a90001,0x06960015,0x7bd70045}},	//   олик, авио_, آنية_, lexu
  { {0x2bc6014e,0x26de1854,0xe6160036,0xc3d50010}},	//   र्वा, _esto_, ідь_, оўны
  { {0x661b003f,0x9f6000dc,0x799b00aa,0x78a602de}},	//   shuk, űrés_, _heuw, _ækva
  { {0xb05b022d,0xd7f80092,0xe299049d,0x290f1855}},	//   ttän, _khăn_, јам_, lyga_
  { {0xcf890dab,0x04c90029,0x90c60a1f,0xd6e8004f}},	//   _יט_, _نوصي_, обме, _לַנָ
  { {0x89da0008,0x290f0091,0xb05b1856,0xdb150012}},	//   בחרי, nyga_, rtän, _abzü
  { {0xb05b1857,0x853a000a,0x04670054,0xc2c8002b}},	//   stän, _דגני, _утем, جبیل_
  { {0x7982002a,0x7bd71858,0xdee3011a,0x3f6a080e}},	//   ycow, dexu, мори, риво_
  { {0xd5f90053,0xeafa0086,0x224b1859,0xdb1e0030}},	//   ספּר, یرات_, cock_, repü
  { {0xad660074,0xce470033,0x8f76008b,0x3519000a}},	// [2740] زاره, ізуе_, _муні, בוּנ
  { {0x28b8000b,0x6b560f5c,0x7982002a,0xb05b0a64}},	//   उंसि, отех, wcow, ntäl
  { {0x61e400b6,0xfe4607be,0xab770015,0xa3b7000b}},	//   _kail, _мноо, زمنا_, _छाई_
  { {0x3e410007,0xdcfd0007,0x7db60015,0xd7f80016}},	//   tėte_, _nesė, _بصدا, _chăn_
  { {0xc7ba008f,0x8d660036,0x7982002a,0x78a20046}},	//   аёй_, _євге, rcow, usov
  { {0xacd900b2,0x2cb20176,0x3e410007,0x799b0111}},	//   _פֿרי, mryd_, rėte_, _eeuw
  { {0xa01b00f2,0xa714005e,0x28da000b,0x78a2185a}},	//   mpöt, ямкі, _मैरि, ssov
  { {0x78ad010b,0x2bc6000b,0x2bd8000b,0x6b9c185b}},	//   šava, र्रा, ड़वा, _herg
  { {0x6b9c0020,0x80da000b,0x7aee00bc,0xb7d60058}},	//   _kerg, _पैले, _hrbt, _وقرب
  { {0x61f60026,0xa91d0091,0x136a097d,0xdb1c016e}},	//   _anyl, _nežy, ишни_, _acré
  { {0xb4e3014e,0x61e4185c,0x4b7b0053,0x6b9c0939}},	//   कटॉप_, _bail, יטיג, _merg
  { {0x61e412bf,0xe693002b,0x722b033d,0x7bd70030}},	//   _cail, _آلند, рцов_, zexu
  { {0x660f0c77,0x61e4185d,0x2d92185e,0x224b185f}},	//   öcke, _dail, dbye_, rock_
  { {0xf8b3000a,0xa3b7000b,0x104b0121,0x2cb20034}},	//   ושש_, _छाए_, рями_, dryd_
  { {0x9e070036,0x61e41860,0x3ea50030,0xdd9b1797}},	//   очал, _fail, élt_, иша_
  { {0x2cb20026,0x3ead0107,0x61e41861,0x68e00046}},	//   fryd_, čet_, _gail, _osmd
  { {0xc05b0191,0xb05b00f2,0x1cb80029,0x6fb6002b}},	// [2750] _він_, ltäm, قالب_, _کمپا
  { {0x3eb800b8,0xddd6005c,0xeb900021,0xecb80015}},	//   burt_, omyś, نظم_, تطفت_
  { {0xb05b00f2,0x23c2005d,0x6a94005e,0x99f50033}},	//   ntäm, _शानद, дріє, зялі
  { {0x2cb21862,0x6b9c0079,0x600b0061,0xb05b008c}},	//   bryd_, _eerg, _gümr, itäm
  { {0x5dfa000a,0xd9450004,0x7aee0012,0x6b9c1863}},	//   _הפרנ, џели, _erbt, _ferg
  { {0x3abb0074,0xa69500d7,0x28080015,0x6d3a000a}},	//   _پاسخ_, приј, يْنَ_, _הֲלו
  { {0x99d70021,0x8f8c000a,0x4e0f000b,0x1995176c}},	//   _وترا, בְחֵ, _सवाई_, _навя
  { {0xd6ce003b,0x6b850026,0xc6680001,0x7f3c004c}},	//   اقي_, lchg, ошње_, יעוו
  { {0x6d4300b8,0x27f60089,0x61e41864,0x69d91865}},	//   ßnah, ádní_, _rail, mewe
  { {0x94220080,0x61e40376,0x787a000a,0x69d91866}},	//   емье, _sail, _הָאו, lewe
  { {0xef20005c,0x6b8500b8,0xddc4005c,0xc7c40142}},	//   ążki_, ichg, gliś, _юсти
  { {0xb05b01d1,0x61460658,0x2cb20034,0x60100123}},	//   stäl, зема, yryd_, _jämv
  { {0xf9920008,0x69d9055e,0xb05b008c,0x61e41867}},	//   ערך_, iewe, atäm, _vail
  { {0xdff50010,0xb4d7005d,0xe3b30086,0xb05b00f2}},	//   мясь, ाबी_, _آرش_, ltäj
  { {0x63a11868,0x539a000a,0x1287002b,0x26c702c6}},	//   maln, _היצו, _بمبی_, ntno_
  { {0xbc760029,0x2cb21869,0x625d0003,0xb05b008c}},	//   كهرب, tryd_, léon, ntäj
  { {0xee370036,0x5baa0892,0x721b000a,0x91bb000a}},	// [2760] їну_, йкам_, _לוקח, _המפי
  { {0xdce60048,0x26c701a3,0xe572000a,0x63a1186a}},	//   _iekļ, ktno_, גַע_, naln
  { {0x9f97000a,0x0f7b000a,0x3f7b000a,0x69cb0012}},	//   _מדיה_, _לאיב, _לאיס, ffge
  { {0x32090092,0xe8fa0892,0xc27a000a,0xe944002b}},	//   _xoay_, йле_, צרני, ورشی
  { {0x3a3f02ce,0x6b9c0049,0x63a1186b,0xddd6002a}},	//   _djup_, _terg, kaln, zmyś
  { {0xb05b00f2,0xddc4005c,0x3e410007,0x63a10f0d}},	//   ytäm, yliś, mėta_, jaln
  { {0x8c1b013a,0x69d9186c,0xbb4301c5,0xe5c6006b}},	//   _פולי, bewe, _зерк, пспо
  { {0xbb3b01e4,0xd5e20092,0xfecd000a,0xb4d7000b}},	//   _העלי, _khỏ, ׁמוּ, ाबू_
  { {0x3e410091,0xdce6003d,0x27170016,0xa98b000a}},	//   nėta_, _nekļ, ãn_, _הָבִ
  { {0xb05b022d,0x2281001a,0x63a1186d,0x7e7e02dc}},	//   ttäm, _bók_, galn, _oupp
  { {0xe1d90191,0x3160186e,0x61d9006b,0x7e7e007c}},	//   одні_, _aziz_, омня_, _nupp
  { {0xe717103d,0x63a10020,0xb05b00f2,0xa194022a}},	//   _מחבר_, aaln, rtäm, наюч
  { {0xd6250196,0xdb2300dc,0xf1a40010,0xb05b04fc}},	//   _تعلي, _örök, эрэн, stäm
  { {0x3e410007,0x988b000a,0x250b002b,0x225200aa}},	//   dėta_, מָלֵ, _درمی_, _ekyk_
  { {0xdef80010,0xa8570008,0x628a02d2,0x93770015}},	//   пыт_, פילה_, _utfo, _عصور_
  { {0xc3330008,0x433b0008,0xf1bf0030,0x5c9901b0}},	//   _רוק_, _לעוב, giát_, жкая_
  { {0x93bd0053,0x30840015,0xb05b186f,0x30a40033}},	// [2770] _אַלף_, _كليف, ntäk, _прэв
  { {0x9ce40010,0x3138000f,0x9c47005e,0x7055002b}},	//   эцсл, _מנחם_, їхал, _زنجا
  { {0x6b8500b8,0xd7f80092,0x8b670015,0x442e1870}},	//   rchg, _chăm_, سائم, _mmf_
  { {0x69cb00b8,0xeab00029,0x7c2e1447,0xf1bf016e}},	//   ufge, اعل_, _embr, ngá_
  { {0x37e503c5,0x69d9108e,0xba740040,0xf1bf0030}},	//   долг, rewe, رامت, liás_
  { {0x3cfa000a,0x9be400fd,0xacfa000a,0xf8070342}},	//   _ולשנ, _піск, _והשכ, ячен
  { {0xb05b022d,0x63a1018c,0xdb2300f2,0x66e70030}},	//   ttäj, valn, ärän, déká
  { {0x601001d1,0x63a11871,0x672300bc,0xeef8000a}},	//   _hämt, waln, rznj, למור_
  { {0x63a11872,0x26c700bd,0x93fd0010,0x03d9005e}},	//   taln, stno_, аўнi, оєнь_
  { {0xb05b00f2,0x60100123,0x7d02008c,0xd2a9004a}},	//   stäj, _jämt, äosi, окое_
  { {0x56940124,0x2bcf005d,0xeb92000a,0x96f8006b}},	//   _захт, स्या, כָר_, _нефт_
  { {0x63a1013c,0x74f90015,0xf1bf0030,0x600b073f}},	//   saln, _وفاز_, diás_, _sümp
  { {0xa5bd00df,0xe44e042b,0x6908000a,0x7e7e1873}},	//   siųs, _аж_, ִּשְ, _supp
  { {0x2281002e,0xf8b60008,0x3cf1000b,0xe46b004a}},	//   _tók_, ופשי_, ँटने_, _ушел_
  { {0x41c6005d,0x93450d7f,0x0000006a,0x0000006a}},	//   _वापस, _юнке,   ,
  { {0x25bf1874,0xdb080046,0xd5e20016,0xd2b6000a}},	//   ngul_, ílít, _phỏ, _חלקת_
  { {0xed570083,0x71fa002b,0xb5fd00bc,0xf1bf0307}},	// [2780] дот_, _هرکس_, emšk, riát_
  { {0x8d630080,0x660b0134,0x4d630036,0x1fb60010}},	//   твуе, _logk, ткув, _ўспр
  { {0x78a902d7,0xb9e60036,0x5ffb000a,0xfaa30033}},	//   _avev, діли, _והיה, вахо
  { {0xd5e20092,0xfbc9000f,0xd910002b,0xdb1e008c}},	//   _thỏ, ית_, هیز_, kepö
  { {0xd3780085,0xaa050015,0xb86a0054,0x02da000b}},	//   leće_, عظمه, ојке_, _बन्न
  { {0xd7f80023,0x368a0036,0x387f0161,0x7c2e1875}},	//   _thăm_, осин_, _duur_, _umbr
  { {0x8f9b000a,0xd5ba005e,0x7c3e0123,0x20181876}},	//   קיקי, осп_, mnpr, ikri_
  { {0x973c016f,0x8a060010,0xb05b00f2,0xd6d9005e}},	//   _neće, _ўзае, ttäk, яті_
  { {0x47c60124,0xe3ce0023,0x387f00aa,0xf8890015}},	//   _обав, _dựng_, _guur_, _فضلى_
  { {0xb8650015,0x25bf0045,0x7e6601d7,0x7c3e1877}},	//   _كالو, agul_, _lhkp, nnpr
  { {0x0bb7013a,0xe2f80036,0xfbb70008,0xd378016f}},	//   ולים_, чені_, ופית_, jeće_
  { {0xd378010b,0x0000006a,0x0000006a,0x0000006a}},	//   deće_,   ,   ,
  { {0xa3b40033,0x89eb000a,0xc516002b,0xb05b014b}},	//   _зблі, קַטֵ, _تبات, ltäi
  { {0x8ca2005d,0x0000006a,0x0000006a,0x0000006a}},	//   गठनो,   ,   ,
  { {0xadd50001,0x76870064,0xb3bb000a,0x6f640015}},	//   новљ, _kıya, _ומוכ, َهُم
  { {0x645a1878,0xf1d00092,0x601000b8,0x80da000b}},	//   llti, _hạng_, _sämt, _पैके
  { {0x5cb9008f,0x2d58034e,0x443e1879,0x9cc8004a}},	// [2790] ялаў_, дить_, ont_, дыха_
  { {0x2bbb0029,0x443e187a,0xdb26002b,0xdb1e007c}},	//   تارة_, nnt_, کومی, hepõ
  { {0xf1d00023,0x916d0092,0x387f187b,0x443e187c}},	//   _mạng_, _hồi_, _suur_, int_
  { {0x443e00b8,0xdb1c002d,0x32190177,0xddcf0045}},	//   hnt_, _gcrí, nksy_, _dicţ
  { {0x99d40029,0x1bbb00e6,0x7e6d187d,0x625d187e}},	//   ئتما, _واسع_, mmap, véol
  { {0xd3660074,0xb907005d,0x443e0111,0x7e6d0e95}},	//   _مه_, _बन_, jnt_, lmap
  { {0x7ac410b9,0x2aa80888,0xa9c715be,0xb05b0072}},	//   _исте, _отто_, _осак, rtäh
  { {0x645a002e,0xceb40632,0xb05b0020,0x387f00dd}},	//   elti, דיק_, stäh, _tuur_
  { {0x2bcf014e,0xa9540036,0x443e002e,0x79c80031}},	//   स्था, _акті, fnt_, _توقف_
  { {0xd378016f,0x7305049d,0x6932002b,0x5b79000a}},	//   zeće_, епоз, _حکمر, ּרֹא
  { {0xf1d00023,0xdb070046,0x25a40034,0xc6a40a10}},	//   _dạng_, _odjí, baml_, _арчи
  { {0x2bcf014e,0x7afa00dc,0xfb1a0008,0x2ca9007c}},	//   स्ता, _átte, פורמ, ksad_
  { {0xa155010f,0xddc40064,0xd408002b,0x64c40015}},	//   върш, eliş, ستیم_, _لينل
  { {0xdb1c002f,0x6606002e,0x201e002e,0xd437002b}},	//   _scrí, ökkv, óti_, _تعصب
  { {0x141a000a,0x2018001a,0x7d0b0123,0x20730033}},	//   _מוסב, rkri_, ägsn, улёў
  { {0x64b50064,0x42d4005e,0x20180e05,0x41a7009b}},	//   _eğiş, _рішу, skri_, _звън_
  { {0x10160010,0xd3780085,0xfe43187f,0xbc6601b0}},	// [27a0] _зьня, reće_, унто, евак
  { {0xaf9a005f,0xf5360053,0x2482002c,0x9cb30015}},	//   _этих_, ײטער_, íkmi_, املت
  { {0xb4160053,0xe803005d,0xdef90010,0x3f98031f}},	//   עקעס_, लाना_, _жыў_, mbru_
  { {0xda650029,0xe9e50036,0x0f370053,0x3a06002b}},	//   ناني, кціо, _טריט_, رکزی_
  { {0x443e1878,0xc237000a,0x629c0030,0x6e240030}},	//   ynt_, ערנו_, ároz, mhib
  { {0xb05b022d,0x39130033,0x6e240030,0xf6e60b1e}},	//   ttäi, ымір, lhib, ецин
  { {0x8c43087a,0x7d1600f2,0x7bde003f,0xcf930008}},	//   _сере, lyys, mepu, נטה_
  { {0xa7370029,0xa3d2005d,0xceb30008,0x443e1880}},	//   عثور_, ह्न_, איה_, wnt_
  { {0x6846000d,0xdb1c016e,0x288b002b,0x5fb1000b}},	//   _знаа, _ucrâ, _فصلی_, _जयलल
  { {0xb05b022d,0xe8d70008,0x916d1881,0x9c870057}},	//   ltäv, _אומר_, _nối_, lačí
  { {0xa195054f,0xfa6a000a,0x443e0380,0x68e20034}},	//   канч, ּכָּ, rnt_, lwod
  { {0x765b0467,0x68e2005c,0xb05b00f2,0x7bde0012}},	//   cluy, owod, ntäv, hepu
  { {0xf1d00092,0x6e24003f,0x6606001a,0xb05b008c}},	//   _tạng_, dhib, ökku, itäv
  { {0xb05b022d,0x251b0053,0xb803005d,0xe803005d}},	//   htäv, _צוגא, लायम_, लाया_
  { {0x66ab000a,0x6e67006b,0x916d0016,0x7f84012c}},	//   ּ֙לֶ, етаж, _dối_, الفن
  { {0x7e6d02f2,0x735b000a,0x2ca9060a,0x916d0016}},	//   umap, _מכוח, tsad_, _tồi_
  { {0xd90404b6,0x32440029,0xdb1c005c,0x02440015}},	// [27b0] _ای_, _حنيف, _obró, _حَيَ
  { {0x6e240064,0x113c000a,0x8d740015,0xff070033}},	//   ahib, _מתחל, طاقا, _зямн
  { {0x2ca900c0,0xa3d2000b,0x1eab0021,0x7640001a}},	//   ssad_, ह्य_, _عادي_, knmy
  { {0xe975002b,0xddc40045,0x5a35006b,0x6e241882}},	//   نهاد, rmiţ, ънет, chib
  { {0x6010079c,0x2604000b,0xadf40033,0xad270015}},	//   _kämp, वानी_, _спяш, _أرجو
  { {0x7bde04f9,0xec350053,0x764000f2,0xe9680010}},	//   cepu, _יאָר_, enmy, хаіл_
  { {0xb9950015,0x99850015,0x68e2002a,0x765b0061}},	//   _للأب, _للزو, awod, tluy
  { {0x601004b8,0x6447044c,0xc8f5006b,0x24f500ce}},	//   _lämp, čjim, _избъ, вчор
  { {0xe1ff005c,0x200c00dc,0x367200c3,0xa3b902be}},	//   lmów_, ödik_, جهيز, وادر_
  { {0xa934000d,0x2496002b,0x765b001a,0x972702ed}},	//   _сеуш, کنید_, sluy, _пьед
  { {0x2bc6000b,0x916d0016,0x765b0061,0x23c2000b}},	//   र्टा, _rối_, pluy, _शारद
  { {0xc049000a,0x7aea02de,0x7bde002a,0x22161883}},	//   _וז_, æfti, zepu, тфор
  { {0xbcfb0030,0xc2431884,0x0000006a,0x0000006a}},	//   _szén, рняк,   ,
  { {0xc0e307c1,0x73c4002b,0x7d16008c,0x056401f3}},	//   јорк, _ميهم, vyys, _свін
  { {0xada60036,0xb05b00f2,0x6e240410,0x6da612d2}},	//   кавл, ytäv, thib, кива
  { {0x68e20176,0x7bd500b8,0x82d6000a,0xee3a005e}},	//   ywod, _abzu, _יוצג_, єна_
  { {0x916d0023,0x6026008f,0x644100f6,0x6609016f}},	// [27c0] _tối_, _адпа, onli, ijek
  { {0x64411885,0x63a3178c,0xd3780085,0x0c231886}},	//   nnli, _jenn, leća_, амун
  { {0xb05b022d,0x2604005d,0x7d1600f2,0xfa890127}},	//   ttäv, वामी_, syys, есій_
  { {0x644100b8,0x3a20002d,0x2bc6000b,0x63a31887}},	//   hnli, óip_, र्जा, _lenn
  { {0xe3a70086,0x7189000a,0xb05b04f8,0x7bde007c}},	//   _پر_, תְעַ, rtäv, pepu
  { {0x64410111,0x63a300b8,0xb05b0ac8,0xf8630036}},	//   jnli, _nenn, stäv, авчо
  { {0x290004f9,0x45d40010,0xe2870015,0x6f080012}},	//   ţia_, гойс, _خذ_, ädch
  { {0xd378016f,0x661b0035,0xf64f0015,0xb05b0012}},	//   jeća_, gkuk, يئي_, ltät
  { {0x916d0023,0xd378016f,0xb4be005d,0x2bcf000b}},	//   _mỗi_, deća_, ुझे_, स्वा
  { {0x916d0023,0x661b1888,0xa2d4002b,0x2955006b}},	//   _lỗi_, akuk, هيخت, _съср
  { {0x628304f9,0x60100020,0xddc40263,0x8857000a}},	//   _cuno, _rämp, zmiš, _ישמע_
  { {0xd737000a,0x27ec00da,0x44250012,0x63bc001a}},	//   _בטבת_, _hadn_, ahl_, órnb
  { {0xc05b0191,0xb6350053,0x63a31889,0xe1ff002a}},	//   дів_, _גרײס_, _fenn, zmów_
  { {0x63a3188a,0xdfd8006b,0x4425188b,0xe1ff002a}},	//   _genn, къс_, chl_, ymów_
  { {0x64580024,0xe803000b,0x5f740021,0x62830045}},	//   _ikvi, लाता_, لافر, _guno
  { {0x3377013a,0xf3650036,0x63770008,0xfeb80029}},	//   _בתוך_, _стін, _בגוף_, ضافت_
  { {0xde580036,0x3949005c,0x8cf50010,0x0ba7004a}},	// [27d0] таті_, żasz_, ызац, вшем
  { {0x8bb40015,0x61ed188c,0xb05b0012,0xddc40085}},	//   لإما, _haal, ttäu, rmiš
  { {0x41a7005d,0xfe6e0086,0x63a8002c,0x61ed188d}},	//   _ख़ास, تگی_, iadn, _kaal
  { {0xc3330008,0xeab00015,0xa3d9000b,0x63a80057}},	//   סוף_, زعم_, _डॉन_, hadn
  { {0xa9540036,0x3949001c,0x6609016f,0x645801a3}},	//   акці, ças_, vjek, _okvi
  { {0xab940191,0x973c016f,0xd378016f,0xa3d2000b}},	//   _вирі, _seća, zeća_, _हॉल_
  { {0xb05b00f2,0x64410293,0xd6a80067,0x63a3188e}},	//   ltäs, vnli, نديم_, _renn
  { {0xff7c0008,0x7ada0053,0x3a260111,0x24e9009f}},	//   וטומ, _אַמה, chop_, емии_
  { {0xb05b00f2,0x66090020,0x69cc0057,0x63a31042}},	//   ntäs, rjek, ílež, _penn
  { {0xe3b1003b,0x661b022d,0x8d5c0008,0x6609188f}},	//   حرة_, skuk, וכחי, sjek
  { {0xc5d50191,0xbcfb00dc,0x8bd60008,0x63a31890}},	//   _біль, _szél, אותו_, _venn
  { {0x2604005d,0xf5590015,0x7e7d06d1,0x63a31891}},	//   वाणी_, _كلاب_, _nisp, _wenn
  { {0xf484000d,0xb05b008c,0x63a303aa,0x61ed1892}},	//   _кујн, ytät, _tenn, _daal
  { {0xc9520008,0x7e7d002d,0xb7f9000a,0x2bd8000b}},	//   צמם_, _aisp, ׂפָת, ड़छा
  { {0xb05b1893,0x61ed0064,0xa0671179,0xf1bf002d}},	//   kräf, _faal, уара_, mhán_
  { {0xd5e20023,0xc692103d,0x21280086,0x229200a2}},	//   _khó, מאל_, _ليبی_, _اليس
  { {0x4d66070e,0x8b96004a,0x2604000b,0x6d5d00e7}},	// [27e0] укав, греч, वाती_, _cysa
  { {0x309b04dc,0x69c90011,0x2bcf000b,0xab2a0658}},	//   _רשימ, _acee, स्ला, ноза_
  { {0x0af60010,0xdd12003d,0xdc75004a,0x68e91894}},	//   ычаў, _kļūt, рыть, _ased
  { {0xb05b0b14,0x63a800bd,0x1d0a0661,0xa8ea0015}},	//   stät, zadn, _земи_, فعتك_
  { {0xd5e20023,0x09360015,0xd8b70015,0x522d004c}},	//   _nhó, دراج, هدوا_, וואַ
  { {0xdd3b00b2,0xcaa60029,0x3a261895,0xcb760054}},	//   _װעלכ, _مصري, shop_, _бубњ
  { {0xd5e20092,0x63a8017b,0x1706002b,0x5694013e}},	//   _phò, vadn, افعی_, шайт
  { {0xe4e60191,0xa281005c,0x88c60015,0x63a8002a}},	//   гіон, łość_, _متطل, wadn
  { {0x39460001,0xd5e20092,0xe1ff0125,0x7c89004f}},	//   _снаг, _chó, llóg_, ֣אתִ
  { {0xc94b0008,0xf7860015,0xd4d70015,0x656f0046}},	//   _אֲבֹ, _إلاَ, ابيض_, ýcha
  { {0x2604005d,0x61ed0035,0xfc570053,0xb05b00c0}},	//   वादी_, _paal, רביש_, ktär
  { {0xa2270018,0x63a81837,0xa175005e,0x64a60513}},	//   ارده, sadn, игні, _бада
  { {0x7e7d02d7,0x61ed06c2,0x63a80787,0xb5fd10cd}},	//   _risp, _vaal, padn, rmšt
  { {0x3e4100df,0xf1bf002d,0x25a60026,0x439409d7}},	//   mėti_, chán_, _heol_, _такс
  { {0x3e410007,0xb05b00b8,0x61ed049c,0x26b40008}},	//   lėti_, hräg, _taal, יִּם_
  { {0xb05b008c,0x92b3006e,0x387e1896,0x3d950a32}},	//   ttäs, _احوا, _litr_, риар
  { {0x7e7d0048,0x3e410007,0x527c0053,0xc047006e}},	// [27f0] _visp, nėti_, _אנהא, _مخدو
  { {0x25a60026,0xb05b00c0,0x6d5d013f,0x0000006a}},	//   _leol_, dräg, _vysa,
  { {0xb05b1897,0xe803000b,0x9b440015,0x6d5d002a}},	//   stäs, लासा_, منكو, _wysa
  { {0x3e4100df,0x636f00dc,0x2bc7000b,0x98dd0033}},	//   kėti_, lóné, _लावा, дскi
  { {0x9df8004a,0x28f8008b,0x6fd2000b,0xe945002b}},	//   _снят_, лець_, द्वं, جرای
  { {0x3e4100df,0x25a900bd,0x5c070010,0x76b50001}},	//   dėti_, _žal_, _сяма, аљиц
  { {0xe6110015,0xb05b0012,0x7ceb0123,0x2fc70052}},	//   قشة_, präf, _förå, _öngu_
  { {0x25a6002d,0x04c90015,0xe6110067,0xd5e20016}},	//   _ceol_, نوبي_, تشت_, _phó
  { {0xf1bf002f,0xa5f60054,0x25a600e7,0x68e91898}},	//   thán_, рењу_, _deol_, _used
  { {0xa87b0015,0x4423002a,0x24520040,0xb4e5000b}},	//   _أحرر_, ój_, ينيس, _पनी_
  { {0x63bc0084,0xe7840086,0x316900dc,0xca35000a}},	//   órna, _المپ, _azaz_, ֹנָה_
  { {0x3e4100df,0xa4d50036,0xd5751899,0xe803000b}},	//   bėti_, _воді, _куль, लावा_
  { {0xc1e7002b,0x3d01000b,0xd12f0015,0x42550033}},	//   شکيل_, ोहों_, ِمُ_, стэт
  { {0xa06a008f,0xfaf80024,0xe3b9005e,0x0163005e}},	//   тага_, _šīm_, _рбк_, ікро
  { {0x43750053,0xbf650029,0xb05b008c,0x6e36006b}},	//   _דײַן_, مدفو, ttär, ахах
  { {0x644f0152,0x6e030015,0x42530058,0x8d760058}},	//   écif, يِّن, _ونور, لاءا

  { {0x6fd60036,0x62730029,0xa2a1000b,0x1d890015}},	// [2800] _кінц, _بهيئ, कीर्, ائفي_
  { {0xd00f0029,0x5faa000b,0x7ba50015,0xb05b189a}},	//   _يلي_, _क़िल, مصمم, stär
  { {0x5fbb000a,0x8f9b000a,0x394d0730,0x79a6027c}},	//   _בצינ, _שיטי, _axes_, арле
  { {0xb05b00b8,0x79850015,0x3857002b,0x2a6d0046}},	//   träg, مؤهل, یشود_, _cheb_
  { {0xda650029,0x2604000b,0xd794006b,0x6e260061}},	//   حالي, वासी_, билъ, _ilkb
  { {0x25a6002f,0xe917005e,0xc9d4002b,0xb05b008c}},	//   _seol_, роші_, _گمرک, ntäp
  { {0x6f1c0026,0xeab4000a,0x973c0085,0x478902a3}},	//   nyrc, _לִּי_, _većo, усім_
  { {0x6b630036,0xb05b08e9,0x8e97000a,0x998b00d4}},	//   _єкта, präg, בדקו_, ălţa_
  { {0x87da0086,0x6f1c0026,0x7bc3001a,0xd40606b9}},	//   _لباس_, hyrc, ónug, аяни
  { {0x3e4100df,0xf7e90015,0x2604000b,0xe7b30015}},	//   rėti_, _مرمى_, वाही_, _ومقد
  { {0x2338054f,0x8c1b000a,0x3e410091,0x63520046}},	//   упны_, דויי, sėti_, děné
  { {0xd2580036,0x25dd005d,0xd3770010,0x3e410007}},	//   иця_, _कॉपी_, шчы_, pėti_
  { {0x0494003b,0x067b000a,0x6abe0012,0x90a40058}},	//   _التح, _סנדל, hrpf, ْحِم
  { {0x34fb0008,0xd3a3006b,0x04db015b,0x251b0643}},	//   _שהגד, _дръп, _סקול, _בודא
  { {0x6f1c0176,0xfda70001,0x63670063,0xee870010}},	//   gyrc, ијам, _кръг_, рыго
  { {0xe37b000f,0xd37b000a,0x1609000b,0x629a189b}},	//   _ברור, _ברוט, वायर_, mpto
  { {0xb05b00c0,0xcec40089,0x786d016e,0x6abe0012}},	// [2810] träd, teří_, lúve, erpf
  { {0x2bb80029,0x515c000a,0xbca40015,0x0000006a}},	//   لامة_, _בכחו, تمكي,
  { {0x5fdc000f,0x539b000a,0x660200aa,0xb05b0b14}},	//   _יחזק, דיבו, _onok, rräd
  { {0xdb1e001a,0xca8400e2,0xdbd90061,0x497501d2}},	//   efpó, ігій, lçüd, блес
  { {0x8cf40010,0x66ec005d,0x26de16ee,0xd8e703ea}},	//   _дзяц, झिझक_, _apto_, рцеп
  { {0x1d160008,0x3eb1005c,0xb8ff000b,0x07a20a31}},	//   _הקשר_, oszt_, _तह_, пашн
  { {0x6dbb002a,0x87d40015,0x2a7f01c2,0x68420033}},	//   ałał, تغنا, _tiub_, янша
  { {0xee320008,0x656f0107,0xf9900015,0x177a02ed}},	//   ּֽה_, ýcho, _يبق_, у́сь_
  { {0xe459017a,0x0000006a,0x0000006a,0x0000006a}},	//   лжи_,   ,   ,
  { {0x98140087,0x9f4c0f1b,0x84440058,0x0000006a}},	//   _وبلا, ždé_, ْخَل,
  { {0xe7190086,0x6fce000b,0x06850015,0x68fb0069}},	//   _حيات_, _ताबू, _الصُ, _hrud
  { {0xd1ba0015,0x3f91002a,0xcf89015b,0x7a88000a}},	//   دادا_, eczu_, _טט_, יָשַ
  { {0x85050074,0x6f1c0026,0x291d0297,0x2604000b}},	//   _دوشن, wyrc, nywa_, वारी_
  { {0x33950029,0xe3b80064,0xb4fa000a,0xc2c8002b}},	//   _الغز, lkın_, _תפסי, دبیل_
  { {0xd7f10023,0xe3b0002b,0x66f7000b,0x66f9000b}},	//   _mã_, _آره_, ंटिक_, ्मिक_
  { {0xb05b0012,0x0d860612,0x68fb189c,0xe3b8007f}},	//   gräb, слан, _orud, nkın_
  { {0x61e6189d,0xac831884,0x0000006a,0x0000006a}},	// [2820] mekl, згул,   ,
  { {0x21370008,0x442700e8,0x69db0077,0x3b0a0510}},	//   _לטפל_, _jln_, _abue, лезо_
  { {0xfc3f08e0,0xf017000a,0x7017000a,0x63a7002a}},	//   _avís_, _הקיץ_, _החיד_, ójny
  { {0x61e601e2,0x38c80086,0xb346016e,0xddcd0061}},	//   nekl, لاتی_, leçõ, mlaş
  { {0x25ad0176,0x656f002c,0x8d760067,0x68fb189e}},	//   dael_, ýchl, _دادا, _crud
  { {0x5fdb000b,0x7e64189f,0x68fb0c5e,0xab66007c}},	//   म्पल, llip, _drud, gmüü
  { {0xddcd0064,0x2604000b,0x6dbb002a,0xf99f0004}},	//   nlaş, वाली_, słał, _нè_
  { {0x291d005c,0x61e6016f,0x7e9b000a,0x7afc0012}},	//   bywa_, jekl, נספו, _irrt
  { {0xa926005f,0x2bcf005d,0x998f0007,0x68fb18a0}},	//   _удал, स्का, angų_, _grud
  { {0xddcd01e2,0xe3b80064,0xdc89000a,0x52d8005e}},	//   klaş, akın_, סְפָ, амою_
  { {0x5c5b00b2,0x2bf70008,0x57fb000a,0xddcd0061}},	//   רדיק, זמין_, _תלבו, jlaş
  { {0xad9b11e0,0xc0cb0124,0xcb130008,0x5fdb005d}},	//   _anún, луге_, ללת_, म्नल
  { {0x661d00f2,0xe3b20015,0xb5050015,0x7bdc18a1}},	//   öske, _فرغ_, _وظهو, _obru
  { {0xd7f10016,0xddcd0061,0x2229002b,0x70a9000b}},	//   _xã_, flaş, ازگی_, _कबील
  { {0x643b0053,0x543b0053,0x291d005c,0x644f0d92}},	//   _געגנ, _געגא, zywa_, écie
  { {0x61e601e2,0x7e640035,0x645a18a2,0xad670015}},	//   cekl, glip, loti, ماءه
  { {0x42380008,0x9c39000d,0x442c00d9,0x443e18a3}},	// [2830] _לנהל_, апат_, ohd_, oit_
  { {0xf3f10092,0x645a18a4,0x351b000a,0xb346016e}},	//   họn_, noti, אומנ, ceçõ
  { {0x207c0053,0x6008000a,0x443e007c,0x2bb80015}},	//   _גאזא, _הִרְ, iit_, صالة_
  { {0x1df90080,0xa2c0005d,0x31b7005d,0x443e1640}},	//   _темы_, _विन्, _अयोध, hit_
  { {0x89a8005e,0x443e03cf,0x645a18a5,0xc4c60015}},	//   сків_, kit_, koti, _تْ_
  { {0x63aa002e,0xa6950292,0x645a121a,0x443e0a5e}},	//   _nefn, ориј, joti, jit_
  { {0xa3be005d,0x645a18a6,0x9b09000a,0x59c50015}},	//   ेलन_, doti, _דִּ֥, _ويسك
  { {0x7f3c0053,0xbb480029,0xfc3f002d,0xe61918a7}},	//   טעוו, _الفن_, _tvís_, рди_
  { {0x442700e8,0x64480d75,0x68fb003f,0xddcd0061}},	//   _pln_, fndi, _urud, zlaş
  { {0x63aa0176,0xddcd01e2,0x04560029,0xdc8c0008}},	//   _cefn, ylaş, يلية_, נְחָ
  { {0x63aa0176,0x33650029,0x25b90086,0xdb1c002d}},	//   _defn, تهدف, _نهاد_, _scrú
  { {0x64480c60,0x443e0f1f,0x26c718a8,0xd7c9000b}},	//   andi, ait_, muno_, _राँच
  { {0xe3ae18a9,0x61e618aa,0xa5670015,0x625d0003}},	//   _об_, rekl, _ادان, téor
  { {0x63aa1878,0xb97a000a,0x24960015,0xddcd0061}},	//   _gefn, ינרי, _بنود_, tlaş
  { {0xb346016e,0xdb070030,0x61e618ab,0x26c718ac}},	//   reçõ, _fejé, pekl, nuno_
  { {0x22b50048,0x764900f2,0x0e660484,0xb05b079c}},	//   māk_, nney, ікан, träc
  { {0x22b50048,0x22a700dc,0x5baa03e7,0x7c3e18ad}},	// [2840] lāk_, lők_, икам_, tipr
  { {0x27e7003c,0x6e2d02f2,0xa2c0000b,0xebe31797}},	//   jenn_, ahab, _विम्, моуп
  { {0xd24f0086,0xd1490086,0xaaba002b,0x69d90012}},	//   _سنی_, _نشین_, شدار_, ffwe
  { {0xddcd04f9,0x7c3e00df,0xc2cc0053,0x443e18ae}},	//   rmaţ, sipr, רמאָ, zit_
  { {0x3ead010b,0x644818af,0xed57034e,0x7d0b079c}},	//   ćete_, yndi, _мою_, ägst
  { {0x76490064,0x22b5003d,0x26c70017,0xd794006b}},	//   eney, kāk_, funo_, чикъ
  { {0xdcf60064,0x26c702c1,0x443e18b0,0x6009000a}},	//   mayı, guno_, vit_, מִקְ
  { {0xdcf601e2,0xba9b0053,0x22a700dc,0xf6e50010}},	//   layı, _כסלי, dők_, яцін
  { {0xb80a0086,0xa5070001,0x629818b1,0x645a18b2}},	//   _پيام_, жења_, _stvo, toti
  { {0x186a010f,0x68ed18b3,0x644818b4,0x47c303fa}},	//   _тази_, çade, undi, _обув
  { {0x2bcf005d,0x1bfb0053,0x63aa002e,0x22b50024}},	//   स्टा, בליב, _vefn, gāk_
  { {0x443e00d1,0x85060015,0xd3780085,0xa19401c6}},	//   sit_, _ووان, neći_, маюч
  { {0xda7b013a,0x443e18b5,0x3d04000b,0x645a18b6}},	//   ינטר, pit_, रमों_, poti
  { {0x764000df,0xc05b0036,0x22b50024,0xb6020089}},	//   limy, рім_, bāk_, řádk
  { {0x539b0008,0x6e2d18b7,0x5457000a,0xdcf60061}},	//   _דיוו, thab, _וסגן_, dayı
  { {0xd378016f,0x2bdd000b,0x5e450015,0x8d6b0004}},	//   jeći_, न्ना, أَرْ, ајза_
  { {0xd378010b,0x6e2d18b8,0x8d770018,0xacf81155}},	// [2850] deći_, rhab, زارا, онту_
  { {0x1c05005d,0xad9b016e,0x6e240061,0x7640008c}},	//   राइल_, _inúm, akib, himy
  { {0x6e2d0220,0x764018b9,0x27e700cb,0xde5900fd}},	//   phab, kimy, venn_, _гані_
  { {0x69d90012,0x753d0030,0x26c70573,0x7d0b0123}},	//   ufwe, úszk, vuno_, ägss
  { {0xb23c0053,0x22b50024,0x22a700dc,0x01fc0053}},	//   סעדז, zāk_, zők_, יפאל
  { {0x26c70026,0xf80705ae,0xa7fc007f,0x0000006a}},	//   tuno_, ючен, _akıb,
  { {0xdce60024,0xd3780085,0x27e7148c,0x0000006a}},	//   _izkā, beći_, renn_,
  { {0xe7300067,0x68f0008c,0x060918ba,0x22a70030}},	//   خصه_, ähdä, сник_, vők_
  { {0xe4d60029,0xa994002b,0x26c702b9,0x7649082f}},	//   كويت_, _آشفت, suno_, rney
  { {0x22a70014,0x87070029,0x22b50024,0xd707002b}},	//   tők_, _وبال, tāk_, _وظاي
  { {0x2bdd005d,0xa2c0000b,0x17f80015,0x786d006f}},	//   न्या, _विण्, _برقة_, cúva
  { {0x22b50048,0x26f9014e,0x2c6d0264,0x22a70030}},	//   rāk_, ्मीर_, _vždy_, rők_
  { {0x48fe000b,0x85040015,0x22b5003d,0x22a70030}},	//   लियो_, _يومن, sāk_, sők_
  { {0xb4fa0008,0xd8480092,0xd3780085,0xd012006e}},	//   _לפני, họn_, zeći_, رلز_
  { {0x0e6a0029,0x539a000a,0x973c0085,0x644118bb}},	//   مصري_, _פיקו, _peći, mili
  { {0xb2ba0008,0xa2c0005d,0xa2ba0008,0xe1ff18bc}},	//   _המקר, _वित्, _המקט, llón_
  { {0x973c010b,0x6c8600e5,0x3cf6000b,0x718b000a}},	// [2860] _veći, سلام, ँटें_, _לְיַ
  { {0x2242003c,0xe0fb000a,0x644118bd,0x3c630004}},	//   likk_, _פליל, nili, екуг
  { {0xdcf601e2,0xbcfb00dc,0xd378016f,0x62970077}},	//   rayı, _szét, teći_, _éxod
  { {0xf2960053,0xdcf60064,0x644118be,0x224200cb}},	//   לכער_, sayı, hili, nikk_
  { {0xd378016f,0x5dfb000a,0x644118bf,0x76400091}},	//   reći_, _הפכנ, kili, vimy
  { {0xb05b00b8,0xf0930008,0xbad60010,0xd378016f}},	//   hrän, ענו_, _нібы, seći_
  { {0xe9a60036,0x644118c0,0xfe36000a,0x7fd7000a}},	//   _навп, dili, ּרִי_, פוקס_
  { {0xa3d9005d,0x2abb000a,0x44250046,0xd6d9005e}},	//   ड्स_, _למלא, ekl_, юті_
  { {0xdced002c,0x786d002c,0xb05b0012,0xe60f0015}},	//   zbaľ, súva, drän, اشى_
  { {0xa2c0005d,0x988b0008,0x674700dc,0x6edd000b}},	//   _विद्, _הָאֵ, árjá, _पहलु
  { {0x644f038d,0x2242003c,0x079b000a,0xa87b004c}},	//   écia, fikk_, _הסבל, _פאבר
  { {0xb05b01d1,0x7ae100b8,0x224200cb,0xe6170054}},	//   grän, _älte, gikk_, _ндх_
  { {0xe1ff18c1,0xca37000a,0x644118c2,0xd5fb000a}},	//   blón_, לנטה_, bili, _לפאר
  { {0x201a0026,0x104b004a,0x60c00030,0xe1ff0077}},	//   _copi_, сями_, ámma, clón_
  { {0x33db0008,0x629c0107,0x64b50061,0x32b70015}},	//   _החוד, írod, _eşiğ, _فدية_
  { {0x22420030,0x61f600da,0x0000006a,0x0000006a}},	//   cikk_, _gayl,   ,
  { {0x91bc013a,0xc1bc0008,0xbcfb00dc,0xbba8000b}},	// [2870] _המחי, _המחש, _azér, गरूक
  { {0x201a0026,0xa3be000b,0x9f430046,0x7c670015}},	//   _gopi_, ेलि_, lejí_, ساءل
  { {0x99890089,0xf1d4005d,0x682f0293,0x6a94005e}},	//   íkům_, _थामन, _jøde, еріє
  { {0x3a260035,0x682f0134,0xceb2000a,0x4a44005e}},	//   gkop_, _møde, _ביט_, ннєв
  { {0xbcfb0014,0xa3be000b,0xca24004a,0xaa580054}},	//   _ezér, ेला_, эффи, чицу_
  { {0xccf2000a,0x66e518c3,0x644118c4,0xd3780160}},	//   _שכם_, дока, xili, leću_
  { {0x32090064,0x682f063b,0x2d9f007c,0x6441033e}},	//   _onay_, _rødd, _õues_, vili
  { {0x64410b7c,0xdb070089,0xc7440029,0x36350018}},	//   wili, _její, عضوي, برتس
  { {0x28080089,0x3d00000b,0xf8b900c3,0x44250046}},	//   átní_, रिये_, _ذهاب_, tkl_
  { {0xe7b50074,0xd8740015,0xc8c8002b,0xd83b0033}},	//   _آماد, _كالب, _رومن_, _уэб_
  { {0x61f601e2,0x2242003c,0x28080089,0xb05b04d4}},	//   _payl, tikk_, štní_, trän
  { {0xf8d1005d,0x923a0036,0x249f002e,0xd378016f}},	//   _समाय, ічну_, ppum_, jeću_
  { {0x2242003c,0xd378016f,0x64411645,0xb05b0309}},	//   rikk_, deću_, pili, ltäy
  { {0x2242003c,0xdee601c5,0x682f0595,0x682d002a}},	//   sikk_, моги, _føde, eźdz
  { {0x2bcc000b,0x539a000a,0xa06718c5,0x61f618c6}},	//   ालसा, _ויצו, фара_, _tayl
  { {0x74a4000b,0x9f430046,0xc2560015,0x0206004a}},	//   चीकृ, cejí_, _تختت, _цзин
  { {0xdb0e00dd,0x0baa0015,0xdb07006f,0x91bb000a}},	// [2880] _gebê, قاضى_, _dejí, _ומפי
  { {0xe572000a,0x6c330015,0x3299000a,0x682d002a}},	//   דַע_, نفقا, ַבְד, aźdz
  { {0x5f460086,0x3e480011,0xfeba002b,0x2bdd000b}},	//   _آنجل, eşte_, _باخت_, न्धा
  { {0xa2c0014e,0xfaf80048,0xc3320008,0xb9e30036}},	//   _विस्, _šīs_, כוב_, віши
  { {0x0897003b,0xd83a0010,0xc27b000a,0x127b004c}},	//   وضوع_, жэй_, קרני, קאנע
  { {0x0ee2005d,0x9f430089,0x2bdd000b,0xd889002b}},	//   _पहाड, zejí_, न्दा, سخهٔ_
  { {0xd6cf0063,0x66e30180,0x3e480045,0x91ee000b}},	//   ът_, воја, aşte_, ज़ाज_
  { {0x2487002f,0x26c018c7,0xbb3b0008,0x44f40709}},	//   _ainm_, čio_, _ועלי, епис
  { {0x83fc0085,0x05bf000b,0x25af02b9,0x0000006a}},	//   hođe, _एयरब, _degl_,
  { {0x83fc010b,0x224000dc,0xc9850015,0xd3780085}},	//   kođe, _amik_, _أشفي, zeću_
  { {0x97260087,0xd6cf0031,0x430a005e,0x60c602f7}},	//   _تفاو, _نقل_, іхом_, erkm
  { {0x64a6008f,0xc7b8016f,0xd62600e5,0xd251002b}},	//   _жада, _dođe_, _تعطي, انح_
  { {0x7c2e18c8,0x067b000a,0x867b000a,0xdce7003d}},	//   _olbr, _ונאל, _וראו, ālīb
  { {0x9f430089,0x656f00b8,0x34f30033,0xf1bf0030}},	//   sejí_, üche, _шпіё, ehát_
  { {0x83fc016f,0xddc4002a,0x5f94125c,0x60c618c9}},	//   gođe, dnił, тист, arkm
  { {0x41e702e5,0xddc4002a,0xe731000a,0x5c9908f0}},	//   _ціка, enił, נֵם_, зкая_
  { {0xee840010,0x5c7502a7,0xd3780085,0x7bde0012}},	// [2890] тыро, елат, reću_, ffpu
  { {0x78a204af,0x83fc016f,0x4fc70010,0x9f4c0227}},	//   dpov, bođe, _ўспа, ždá_
  { {0xf993002b,0xb5fd18ca,0x7cf80030,0x63ae002a}},	//   نبش_, loše, túrá, óbny
  { {0xd37b0053,0x9f7a000a,0x2cc40061,0x8c490061}},	//   קראט, _מנתח, ürdü_, _başö
  { {0xb5fd016f,0x5d850115,0x682f04d1,0x442e00da}},	//   noše, _سلسل, _rødb, _olf_
  { {0x46f50142,0x2c05000b,0xe8f80033,0xb05b008c}},	//   ечит, राओं_, ьлі_, ttäy
  { {0xa2c0000b,0x7b64004a,0x7bc8000a,0x78a2036d}},	//   _विष्, _атте, _קֶשֶ, apov
  { {0x7af50030,0x2c740123,0xb5fd0085,0x442e18cb}},	//   _iszt, räde_, koše, _alf_
  { {0xa4d60001,0xa8a7017f,0x74150015,0x98f40015}},	//   едњу_, _ірак, فوظا, _لثلا
  { {0xa2c0005d,0x7af5005c,0x25a20064,0xccf2000a}},	//   _विश्, _kszt, ıkla_, נכי_
  { {0xe5e10010,0x4374005e,0xcad5000a,0xc6d40015}},	//   _былi_, куют, עוֹת_, _لتنت
  { {0x83fc016f,0x349518a7,0xe6040015,0xc7b80085}},	//   vođe, _задр, _لِمَ, _vođe_
  { {0x65940124,0xddc4002a,0x45b6000a,0x660b18cc}},	//   _рачу, ynił, _נפסל_, _ingk
  { {0x7af500dc,0x7bc3002e,0x3f980045,0x251a000a}},	//   _oszt, ónul, ucru_, _מונא
  { {0xe4560053,0xbcfb00dc,0x4375004c,0x9e760054}},	//   _איסט_, _szép, _אײַן_, ећај
  { {0x2612005d,0xcfaa002b,0x83fc0085,0xddc4002a}},	//   थायी_, _کاظم_, rođe, wnił
  { {0x7af500dc,0x61e402f2,0x20130052,0x0000006a}},	// [28a0] _aszt, _ibil, ýnið_,
  { {0x3ec50064,0x4d6318cd,0xa7fc0061,0x6b560248}},	//   üstü_, укув, _akın, нтех
  { {0x4fd700b2,0x7fd700b2,0x660b00e8,0xe7c9000b}},	//   _אויב_, _אויס_, _ongk, _राजप
  { {0x5e460015,0xf2d2015b,0x6e9b000a,0x6ad00065}},	//   _أَحْ, רעא_, _מבטח, _हमीर
  { {0x61e4000c,0x7af500dc,0x67d4049d,0x186a05f8}},	//   _mbil, _eszt, волу, пади_
  { {0xd6d00029,0x25dd005d,0xc173000a,0xa2c0000b}},	//   لقت_, क्सी_, אחד_, _विल्
  { {0x67b70029,0xad9b002e,0xcc870015,0x97a5005e}},	//   راوح_, _snúi, _أنّه_, тріл
  { {0xdb1c002d,0x89a50015,0x95d7006b,0x61e4007f}},	//   _ndré, _لإكم, едът_, _nbil
  { {0xb17b00c0,0x54540254,0xda650015,0x1c05000b}},	//   neåt, квит, _شافي, राचल_
  { {0xccf3013a,0x660b0375,0x61e418ce,0x88bb000a}},	//   רכז_, _engk, _abil, _מזמי
  { {0xf2e50011,0x22590088,0x6fd7000b,0xdb0e0077}},	//   ţând_, дины_, _बाबू, _bebé
  { {0x5ab700b4,0xb05b008c,0xd5d60015,0xf2c30033}},	//   עלכע_, rräm, _ستؤث, ысьн
  { {0x656f002c,0x64a30484,0xf3f5002b,0xa3f402a3}},	//   ýcht, _бача, رتیک, _аплі
  { {0xdb0700dc,0xf537000a,0x7a330061,0xb5fd1587}},	//   _lejá, _אנדי_, _içte, roše
  { {0xc0ab0074,0x63bc002e,0x3ca9000b,0x15f4000b}},	//   _کابل_, órnu, _चौड़ा, _आसार_
  { {0x27ee0034,0x290418cf,0xfe7300c3,0x7f840058}},	//   hefn_, _orma_, ادس_, طلقن
  { {0xcbc70086,0xebc70001,0xf1bf0089,0x627c000a}},	// [28b0] فزاي, ељен, nkám_, _צנחנ
  { {0x69c00ad3,0x61e418d0,0x09bb000b,0x61fd18d1}},	//   _adme, _zbil, ॉल्य, ldsl
  { {0x19f90033,0xdb070030,0x61e80030,0x49d9005e}},	//   дэль_, _bejá, ődle, ддею_
  { {0xff16000a,0xb05b0123,0x68ed1702,0x61fd18d2}},	//   _סקרת_, kräk, çado, ndsl
  { {0xd3660074,0x7e6d0048,0x99d40067,0xdb070077}},	//   _چه_, mlap, اتما, _dejá
  { {0xd3660074,0xab950001,0x7e6d18d3,0x7bd5005c}},	//   _نه_, _јављ, llap, _uczu
  { {0x316c0050,0x8f9c0053,0xcc540063,0x57a40033}},	//   ędzi_, ליגי, _свръ, ушча
  { {0x7e6d00dc,0x59d8005d,0xda09002b,0x87040021}},	//   nlap, _डायर, _تيره_, ابول
  { {0xe895008f,0x9f4a0251,0x25dd000b,0xe65d0061}},	//   _разь, rebé_, क्षी_, çtığ
  { {0xe3b10015,0xdb05001a,0xe29903ae,0xdb0e0030}},	//   جرة_, dahú, мао_, _sebé
  { {0xe1bf005d,0x26dc0264,0xe8d1000b,0xe6c70067}},	//   ्लंघ, ctvo_, _समुच, _ستاي
  { {0xa69600a3,0xd24f0015,0xa116002b,0x7e6d003d}},	//   _סכנה_, ْنَ_, پوست, jlap
  { {0x463a00b2,0x7e6d0024,0x60dd02de,0x85b8002b}},	//   _קענע, dlap, gtsm, _سانس_
  { {0x25dd005d,0xd0120031,0x91a2000b,0x7536004c}},	//   क्री_, جلس_, _क्रै, _באנד_
  { {0x998f0007,0x023a0029,0x60dd0c0d,0x61e418d4}},	//   nigų_, _يثبت_, atsm, _tbil
  { {0xa7fc0064,0xc6920135,0xe8d1000b,0x61e40b28}},	//   _akıl, שאן_, _समूच, _ubil
  { {0x0d860a13,0x6a7818d5,0xa05a0058,0x3e5a005a}},	// [28c0] тлан, nífe, _يؤخر_, jďte_
  { {0x6faa0029,0xe0b700a3,0xd9ba000b,0x2bdd000b}},	//   _تهدف_, _שליט_, उण्ट, न्ला
  { {0xe9da0080,0x3daa0080,0xb5fd002c,0xcb0a0115}},	//   дке_, _окно_, alši, بيان_
  { {0x831a0053,0x1e97000a,0xceb80091,0x98a608b0}},	//   וועז, _שככל_, šęs_, виде
  { {0x6c860029,0xb7b50092,0x314d000a,0xd197000a}},	//   _للحم, _vọn, ּתוּ, דכני_
  { {0x69dd0123,0x913b000a,0x18740174,0xf1bf00bf}},	//   _ösen, וענק, ыгля, vkám_
  { {0xddcd0011,0x27ee0026,0xcf93000a,0xb9960015}},	//   noaş, refn_, סטה_, _للزب
  { {0xceb30008,0xe1ff0030,0x1af7000a,0xd49a012e}},	//   ביה_, rlók_, _במלל_, мро_
  { {0x29040011,0x5e570053,0x26dc0198,0xb8e50029}},	//   _urma_, כיקע_, stvo_, _مثله
  { {0xa84a012c,0x7d7b000a,0x98760099,0x7e6d01ec}},	//   _غلام_, ונפו, _рубљ, zlap
  { {0x0bb70008,0xd7760029,0xfbd3000a,0x1db2000b}},	//   כלים_, _شائع, בתת_, जरात
  { {0xd7d2005d,0xbddb0003,0x64430061,0x27e90085}},	//   _साँच, _amèn, _emni, đane_
  { {0x61fd0dec,0x68e90045,0x61ef18d6,0x59d70065}},	//   rdsl, _xped, recl, ण्टर
  { {0xa4b7000a,0xa3b6000b,0xb5fd003d,0xdb05001a}},	//   _ילדה_, _ज़ि_, moša, rahú
  { {0x6f24005e,0xf487002b,0xb5fd003d,0x5333006b}},	//   аєте, _شاهی, loša, _вещт
  { {0x6443005c,0x2d8f0134,0xfda40001,0x1317000a}},	//   _zmni, øge_, ијум, _יחול_
  { {0x3d0d014e,0xb5fd0048,0xe7d2000b,0x23b6000b}},	// [28d0] समें_, noša, _सांप, _आजाद
  { {0x7e6d0780,0xd0f800f3,0x9b27029b,0x644818d7}},	//   slap, _יצחק_, кфел, nidi
  { {0x68e918d8,0xe945002b,0xfbd00015,0xe0df02b9}},	//   _sped, گرای, غتك_, ltò_
  { {0xb5fd0024,0xe1ff07e6,0x6e360107,0x2cbe0091}},	//   koša, ndó_, chyb, _žydų_
  { {0x89a80036,0xb5fd0024,0xe0df04ed,0xbe3a000a}},	//   тків_, joša, ntò_, _נעשת
  { {0xb5fd0048,0x29c30092,0x3e5a0227,0x6e2d02ad}},	//   doša, ựa_, rďte_, lkab
  { {0x3669005f,0x644818d9,0x48ef000b,0x501c000a}},	//   нако_, didi, _इनको_, ווגו
  { {0xd5b10029,0x83fc016f,0xc7b8016f,0xd90f002b}},	//   حفظ_, vođa, _vođa_, _ویا_
  { {0x9f4300f2,0xb5fd0024,0x229a0024,0x5a440010}},	//   lejä_, goša, _rīka_, _тэра
  { {0xb05b0012,0xe5760033,0x644818da,0x5f9402ed}},	//   bräi, ызы_, gidi, ти́т
  { {0x84580063,0x96fb0029,0x6e2d0064,0xdddd006f}},	//   ърът_, _تعذر_, kkab, _zisť
  { {0x82360086,0xb5fd0024,0x83fc0085,0x98a00091}},	//   اردا, boša, rođa, šią_
  { {0x78f90053,0x69da0053,0x3c360134,0x7d090085}},	//   עפֿו, ײַכו, _hæve_, _šesn
  { {0x9f43022d,0xddc401cb,0xc1bf000b,0x6305002b}},	//   kejä_, dliš, ्लॉग, _موتل
  { {0x752900dc,0x3ebe002e,0xd5b7000b,0x0eb90033}},	//   lyez, étt_, _इजाज, куты_
  { {0x6e2d0035,0x661b0849,0xb17b0293,0xdd8f0015}},	//   gkab, njuk, reår, كوف_
  { {0x7529000c,0x753b00b8,0xab640064,0xddc40963}},	// [28e0] nyez, nzuz, zcüğ, gliš
  { {0x1c0e005d,0x661b0e95,0xbc6a0002,0x6e2d18db}},	//   साइल_, hjuk, رمان_, akab
  { {0x49ca18dc,0xbf9b004c,0x27e00030,0x9f8b007c}},	//   елен_, _ריטש, őink_, _söök_
  { {0xb05b0123,0xddc400bc,0x644818dd,0x6e2d18de}},	//   tsäg, bliš, zidi, ckab
  { {0x28f80a2c,0xad9b002c,0x627c005c,0x644802e8}},	//   тель_, _vnút, _głoś, yidi
  { {0xe1ff0030,0xb5fd18df,0x7d040ef2,0x8c4600af}},	//   rlói_, voša, mvis, _сеге
  { {0xfaa30180,0x627c002a,0xa3d7000b,0xeed6000a}},	//   _гасо, _złoś, िलन_, אֵ֥ת_
  { {0xb5fd0048,0x64480176,0xceb30008,0xb05b0123}},	//   toša, widi, זיה_, psäg
  { {0x25b9002e,0x752900dc,0x7d0418e0,0x97c60040}},	//   ðsla_, gyez, nvis, _متضم
  { {0x2a660035,0xb5fd18e1,0x5c37004c,0x64480234}},	//   loob_, roša, ָרטן_, uidi
  { {0xd793003b,0x7d04022d,0x3ce00020,0xb5fd0340}},	//   _المخ, hvis, htiv_, soša
  { {0xb5fd18e2,0xe0df04ed,0x5b57004c,0xd3770033}},	//   lošn, ttò_, רשטן_, ычы_
  { {0xc5f3013a,0xa2c0005d,0xf1bf0030,0x7feb005e}},	//   _לדף_, _विक्, nkái_, нєва_
  { {0xe0df04ed,0x7d0418e3,0xe1ff002a,0x4fc70033}},	//   rtò_, dvis, ylów_, ысма
  { {0xf8d1014e,0x9f340036,0xd9040086,0xe0df04ed}},	//   _सम्प, бері, _کی_, stò_
  { {0x7bca002e,0x7d0402de,0x9f43008c,0x21360003}},	//   ófun, fvis, vejä_, êché_
  { {0x5bcb0001,0xdb0e02c1,0x786d002c,0x7c970021}},	// [28f0] ећег_, _debí, súvi, اشرا
  { {0xad9b0f64,0x9f4300f2,0x212b0d55,0x6e2d18e4}},	//   _saúd, tejä_, mych_, skab
  { {0x8f9a000a,0x1a65002b,0x9aa40015,0xddc407c4}},	//   _ביתי, لیسی_, مملو, sliš
  { {0x58b90015,0x9f43008c,0xb05b0123,0x98a90085}},	//   ناتج_, rejä_, gräv, šač_
  { {0x212b18e5,0x3ce00011,0xab950036,0xba740015}},	//   nych_, ctiv_, _вигі, حالت
  { {0x63ba016f,0x9f4300f2,0xdb05002d,0x15e2000b}},	//   jatn, pejä_, lbhí, क्सर_
  { {0xdb580036,0x75d50086,0xc7c40080,0x63ba18e6}},	//   _бют_, ليغا, ссчи, datn
  { {0x212b002c,0xd5ae0015,0x9f4a016e,0x645800bc}},	//   kych_, وفى_, lebã_, _ajvi
  { {0x680b0048,0xe3b10086,0xe4d6002b,0x67d50054}},	//   _pēdē, يرد_, لويت_, _возу
  { {0x212b00f8,0x13090080,0xe2e5005e,0x661b156a}},	//   dych_, вной_, ажоп, sjuk
  { {0x9f4c002c,0x8bd6000a,0x35f518e7,0xb05b0012}},	//   ždú_, בותו_, _впер, nräu
  { {0xcad60008,0x7d0400f2,0x224b0f8b,0x2ca90079}},	//   סורת_, yvis, gick_, kpad_
  { {0x63ba0049,0x23dd000b,0x8505002b,0x6d4b001a}},	//   batn, _मापद, _خوشن, úgal
  { {0x645d038d,0x82360086,0x98a0016f,0x7d0418e8}},	//   ésid, ارگا, šić_, vvis
  { {0x683f0007,0x6fd7000b,0xdfcf0015,0x20040046}},	//   _išdė, _बारू, ظيف_, ěmi_
  { {0x31260063,0xb21b02de,0x02460015,0x212b18e9}},	//   _вдиг, lmæn, _خَبَ, bych_
  { {0x212b0050,0xb21b0134,0x1c4618ea,0xcd27005e}},	// [2900] cych_, omæn, анам, ажте_
  { {0x69db0467,0x629e0656,0x6e46002b,0x6abe0012}},	//   _acue, _époc, _چندم, tspf
  { {0x23dd005d,0xb5fd0024,0x0b460004,0x68fb1703}},	//   _मानद, jošo, јнен, _asud
  { {0xd3560008,0x3ebe002e,0x7d040db2,0x7e9b000a}},	//   ביעי_, áttu_, pvis, _שסכו
  { {0x9f580251,0x7d030010,0xb5fd18eb,0x656f0012}},	//   ldrà_, _дзяж, tošn, üchl
  { {0xd90d0086,0xb05b00b8,0x6d3b000a,0x6826001a}},	//   عیل_, bräu, _יתכנ, _aðdr
  { {0x212b0050,0x63ba18ec,0x9f580251,0xb05b0c77}},	//   zych_, vatn, ndrà_, mrät
  { {0x7bc3002e,0x27e9016f,0x88c60029,0x8afb000a}},	//   ónuv, đana_, _نتطل, _בהלי
  { {0x8e370053,0x15e2000b,0xb4260015,0x2bdd000b}},	//   ינקא_, क्षर_, لعدو, न्का
  { {0x3cf9005d,0x224b1650,0xb05b0400,0x25ad18ed}},	//   _उनसे_, wick_, nrät, abel_
  { {0x212b0f9a,0x8bd70053,0x3c77000a,0xd37a006b}},	//   wych_, סוטו_, שתים_, ъчи_
  { {0x212b0d55,0x63ba18ee,0x058601e1,0x722b02ed}},	//   tych_, satn, _кулм, тцов_
  { {0x92580063,0x361b000a,0x224b037e,0x32050046}},	//   раят_, _שודד, rick_, ěly_
  { {0x50670124,0x212b18ef,0x104b03e7,0x44a30021}},	//   ртма, rych_, тями_, _بموق
  { {0xe2970083,0xc0580191,0x6716005d,0x447b0008}},	//   _кај_, рія_, थमिक_, _שנוע
  { {0xbbaf000b,0x7147004a,0x2ca918f0,0x63b800cb}},	//   टर्क, _вхож, tpad_, _hevn
  { {0xdb05002f,0xb5fd18f1,0xfd100015,0x52840015}},	// [2910] rbhí, došl, وجك_, _بليك
  { {0x0ba70010,0x63b8003c,0xb05b0b14,0x9c380054}},	//   ршам, _jevn, träu, апут_
  { {0xdb1500dc,0xb9950015,0xddc4002a,0x68e218f2}},	//   _kezé, ملاب, nniś, etod
  { {0xdb05007c,0xb05b0012,0x2ca918f3,0x3a2418f4}},	//   mahü, rräu, ppad_, _comp_
  { {0xfe00005d,0x4e16000a,0x49b8002b,0x7c320030}},	//   _लोटस_, _החרב_, شاند_, ákró
  { {0xb5fd0024,0xfaa70036,0x7bdc002d,0x63b818f5}},	//   tošo, _вшан, _gcru, _nevn
  { {0x26c118f6,0x7bc3002e,0xab040020,0xad9b016e}},	//   ého_, ónuu, _ööpä, _gaúc
  { {0xa2c00372,0x9f5802c1,0xcf58011f,0x26c90085}},	//   _विज्, ndrá_, יבות_, čao_
  { {0xdb0701b2,0x68fb10af,0x25ad18f7,0xd3b900ce}},	//   _nejú, _usud, rbel_, луні_
  { {0xc6e70191,0x62980947,0xe1ff0030,0x200101d7}},	//   _відп, _buvo, klós_, _nahi_
  { {0xd6db0124,0xe3650142,0x5b3a000a,0xa349012e}},	//   _шта_, скни, ָׂרו, узна_
  { {0xf5950029,0xe1f20029,0xb21b02de,0x61e60012}},	//   _الإج, أسد_, smæn, ufkl
  { {0x5fdc000b,0x659a000a,0xb148002b,0x661d001a}},	//   _बादल, _עיסק, شیدم_, ösku
  { {0xf66a0084,0x05740086,0xa8790053,0x22920086}},	//   phæð_, _بامد, טאָר, _کليس
  { {0x20010717,0xdb1c0227,0xae5a005e,0xb05b186f}},	//   _dahi_, _odrá, грає_, vrät
  { {0xb05b0012,0x7bc70390,0xdd920015,0x63b80046}},	//   tsäc, _adju, سوط_, _zevn
  { {0x629800b8,0xa3de000b,0xe1ff0030,0xb05b0400}},	// [2920] _zuvo, _णाम_, alós_, trät
  { {0xddcd005c,0xd37e0085,0xb05b03c1,0x0429000a}},	//   gnał, šćem_, rsäc, נֵּֽ
  { {0x5f0608fe,0x31ba000a,0xbb4a006e,0x6286063b}},	//   _узна, ָזְנ, دلان_, omko
  { {0xb05b0bc2,0x5f17000a,0xddcd002a,0x68e218f8}},	//   srät, _החטא_, anał, ttod
  { {0xb05b00c0,0xa3d7021e,0xa9540033,0xb5fd0f81}},	//   prät, िला_, ўклі, rošl
  { {0xd6da0036,0x6c360086,0x2c0e000b,0x2906008c}},	//   гти_, _افسا, साओं_, rvoa_
  { {0x87060010,0xfe1c000b,0xdc37004c,0xb21b001a}},	//   сяле, _पचास_, _פאלט_, fmæl
  { {0xb05b008c,0xf1bf0030,0x8b57015b,0x60c406c0}},	//   isäa, nkát_, _הילס_, _ovim
  { {0x27330023,0x63b80264,0x5a17000a,0x07da002b}},	//   ạn_, _pevn, _פקמן_, _مذاب_
  { {0x2937000a,0x96ba125d,0xdb1c0247,0x224918f9}},	//   _האמן_, _буду_, _zdrá, _smak_
  { {0xe6960029,0x3618002b,0xd5af18fa,0x8c1b000a}},	//   _الصد, _پراگ_, _нс_, אויי
  { {0xe717000a,0xddcd002a,0xdb05007c,0x0000006a}},	//   _לחבר_, znał, vahü,
  { {0xdb1500dc,0x067b0053,0x85760015,0xcfa7005e}},	//   _vezé, _ענדל, _ادائ, йшви
  { {0x23480086,0xf1db005d,0xa0550036,0x6e95000d}},	//   _پستی_, _भावन, івві, живу
  { {0xadbd008f,0x9f340036,0x2001007c,0x4477000a}},	//   кавi, пері, _vahi_, _העגל_
  { {0x66020005,0xd357000a,0x44e2001a,0xe1ff0030}},	//   _jaok, _לשוק_, oð_, rlós_
  { {0x61ed0035,0x99860046,0x61440054,0x200118fb}},	// [2930] _ibal, ehož_, _нећа, _tahi_
  { {0x44e20084,0xb6060085,0x2bb80015,0x0000006a}},	//   ið_, lašć, مامة_,
  { {0xaab5005e,0xf24b000a,0xf1bf0030,0x999906f3}},	//   ійді, ְגְּ, bkát_, акет_
  { {0xb05b08e9,0x8f88000a,0x3c2f0061,0x497518fc}},	//   präs, _לְרֵ, _sıvı_, олес
  { {0x7bc30084,0x61ed000c,0xa9690001,0x69d90028}},	//   ónus, _mbal, јила_, rgwe
  { {0xbcfb0152,0xdb050125,0x1d16000a,0x16a90974}},	//   _exéc, abhá, _וקשר_, авки_
  { {0x44e20084,0xaaa9000a,0x682f0595,0xe7390818}},	//   eð_, _כֹּ֖, _jødi, рей_
  { {0xe7f5005d,0xf6250036,0x562901b7,0x644a18fd}},	//   _इसका_, ідпо, ржим_, _amfi
  { {0x845918fe,0xb5fd01a3,0xb21b18ff,0x44e2001a}},	//   ирот_, lošk, rmæl, gð_
  { {0x61ed1900,0xf1bf0030,0x94790004,0xb21b001a}},	//   _abal, zkát_, јсиу_, smæl
  { {0x44e20084,0xfbd20008,0x60c4016f,0x3860002d}},	//   að_, ותי_, _svim, éire_
  { {0xe5ef008c,0x75150015,0xbf13000b,0x3c3602de}},	//   äkää, _وواض, डमैन_, _nævn_
  { {0x644f0152,0x629e0003,0x62861901,0xe44e03ca}},	//   écis, _épon, rmko, _жж_
  { {0x389a000a,0xfc3f0046,0xdfd200c3,0x22591902}},	//   יישנ, _stín_, بيس_, ansk_
  { {0x02460015,0xbea30033,0x44271903,0xb5fd0085}},	//   _وَتَ, даск, _ion_, jošk
  { {0x44271904,0x78a90089,0x6d05000b,0xb13a0015}},	//   _hon_, _otev, रिंग_, _نأخذ_
  { {0xec4a005f,0xdb9a0001,0x9c260254,0xb1e50015}},	// [2940] азал_, атељ_, одад, _رأيه
  { {0x44271905,0x73f9000a,0x1bba0015,0x2004003d}},	//   _jon_, יּ֣ו, شائع_, ēmis_
  { {0x44271906,0x290d08b2,0x7c27002a,0x1ae3006b}},	//   _mon_, _area_, _dojr, дохм
  { {0x38c80086,0xb05b03c1,0x6097009a,0xddcd0535}},	//   ماتی_, nsän, _دنیس_, gnań
  { {0xb05b008c,0x290d1907,0x61eb0061,0xa88a033d}},	//   isän, _crea_, _ögle, айда_
  { {0xb8f2005d,0x764b0026,0x44271908,0x38cb002b}},	//   _वि_, _amgy, _non_, شاهی_
  { {0xab2a001e,0xd6d00029,0x3e480045,0xe9a6005e}},	//   _това_, رقة_, eşti_, _мавп
  { {0x4427002f,0xcf930008,0xd4b80731,0x2e37004c}},	//   _aon_, וטו_, блиц_, ַריש_
  { {0xe4e60191,0x44271909,0xa5d70015,0x290d0045}},	//   ційн, _bon_, زبير_, _grea_
  { {0x44e20084,0x4427190a,0x4438190b,0x61ed190c}},	//   rð_, _con_, ór_, _sbal
  { {0xd2510086,0xe2f80036,0x78830089,0x4427190d}},	//   فند_, щені_, _důvě, _don_
  { {0x92580080,0xe665005e,0x9f450046,0x4427190e}},	//   жают_, _етіо, ýlí_, _eon_
  { {0xc2180191,0x85560086,0xa633005e,0x2167005e}},	//   ією_, _بخاط, _інші, ютог
  { {0x9f4c0107,0xddcd002a,0xdb1e016e,0xd48f008b}},	//   ždý_, znań, rapê, _ір_
  { {0x764b0176,0xa5c3005c,0x645a0125,0xb6060085}},	//   _ymgy, spół, mnti, pašć
  { {0x5d990033,0x4d990323,0x4427190f,0x7e761910}},	//   скаў_, скаю_, _zon_, glyp
  { {0xe04b0074,0x443e007c,0x9f510046,0x2d8f1911}},	// [2950] _نشده_, oht_, mezí_, äge_
  { {0x645a1912,0xddcd0045,0xfbab0151,0xae14000b}},	//   nnti, flaţ, ртай_, डाउन_
  { {0x2bb80029,0xdefb0010,0x645a1913,0x6ffa000a}},	//   زالة_, _тып_, inti, _ההתפ
  { {0xf9c70191,0x7b64010f,0x290d04f9,0xb5fd116e}},	//   іщен, фтуе, _prea_, rošk
  { {0xf99003c4,0xae1a000a,0xc27c000a,0x07a507be}},	//   نبه_, _הורכ, בראי, палн
  { {0x290d0011,0x09340029,0x7c3e1914,0xb05b008c}},	//   _vrea_, برمج, chpr, isäo
  { {0xc9f70015,0x2b57002b,0x443e0125,0x09f70015}},	//   _وسرع, _بیاد_, dht_, _وأرد
  { {0x682f169b,0x443e0a83,0x44271915,0x1f5c000a}},	//   _nødv, eht_, _son_, ידוא
  { {0xc6480015,0x98170015,0xd7e7005e,0xb05b0123}},	//   تجول_, _وبطا, _міжо, vsän
  { {0x443e1916,0xfb96000a,0xf7730015,0x0000006a}},	//   ght_, ּ֣ית_, _قاض_,
  { {0x44270bcf,0xdb0e00b8,0xa8220086,0x2509002b}},	//   _von_, _gebä, _سکون, _گرای_
  { {0x98cf005d,0x44271917,0xf8cf005d,0xfc3f0bd7}},	//   _हटाए, _won_, _हटाय, _stíl_
  { {0xb5fd0024,0x44271918,0x263f002a,0x443e0125}},	//   joši, _ton_, głoś_, bht_
  { {0x443e1919,0xb5fd003d,0x25bd0034,0x1fa7006b}},	//   cht_, doši, _hewl_, зкри_
  { {0xa8560008,0x765b0061,0x7d0b01d0,0x0000006a}},	//   לישה_, onuy, ægsn,
  { {0x9f4b0014,0x23760021,0x6446003d,0x925703ae}},	//   áját_, _عميد_, īkie, _најт_
  { {0x229a0024,0xd257000a,0xdb1c016e,0x61db000a}},	// [2960] _rīki_, _משקה_, _gerê, _הקפד
  { {0xdb1e00dc,0x4176002b,0x9046002b,0xddc40045}},	//   lapé, _واکس, _رنجه, foiţ
  { {0xb05b022d,0x4f9b0008,0xbf9b0008,0x1c390036}},	//   isäl, _לביצ, _לייש, цять_
  { {0x62870046,0x0136004f,0x7d290052,0x0000006a}},	//   ňkov, ּרַת_, ðssó,
  { {0x645a191a,0x6284002d,0xddcd0045,0x5d7501b0}},	//   ynti, _mhio, slaţ, _журф
  { {0x7b0100f2,0x6296003f,0xa157000a,0x7d7b000a}},	//   äytä, _liyo, הבנה_, _לנכו
  { {0xb17b0bfa,0x8f9b00a3,0x6e360091,0x765b001a}},	//   mgåe, זיצי, okyb, fnuy
  { {0x6e360007,0x6d440012,0xcf93000a,0x629609cf}},	//   nkyb, ozia, עטה_, _niyo
  { {0xa4f80086,0x6d44191b,0x38cb002b,0x0000006a}},	//   تکار_, nzia, _هالی_,
  { {0x644f0152,0x6e24003f,0x533410a1,0x443e007c}},	//   écip, hjib, деот, uht_
  { {0xddcd02d5,0xe41a002c,0x6296191c,0x60c6007c}},	//   hlaš, _kľúč, _biyo, eskm
  { {0xa77b0053,0x46a30010,0x4b7b000a,0x25b7002b}},	//   _פראפ, _чацв, מאיו, _فهمد_
  { {0x61f80010,0x6296117f,0x051a002b,0xe57a00ce}},	//   чняў_, _diyo, _ديشب_, _узд_
  { {0xc953013a,0x6d440050,0xc05b0484,0xc6c6004f}},	//   תמש_, dzia, сім_, ּהּ֙_
  { {0x6284002d,0xb17b0134,0x0877004c,0x9f5a191d}},	//   _fhio, dgåe, פעלט_, _papá_
  { {0x3377013a,0xb5fd0024,0x735b000a,0xddc40045}},	//   _מתוך_, toši, _לכוח, voiţ
  { {0x7e6d0011,0xddcd0198,0xdb1c0144,0xb5fd0091}},	// [2970] roap, glaš, _herè, uoši
  { {0x6e24003f,0x00bc000a,0xb5fd191e,0xcf270015}},	//   ajib, _המזמ, roši, _فرجي
  { {0x3cf9005d,0x69c20026,0x539b00f3,0x0af90015}},	//   _उनके_, faoe, ציאו, تفاظ_
  { {0xddcd00bd,0xbdf90015,0x7bde02f2,0x99d40067}},	//   blaš, _بفحص_, agpu, فتها
  { {0x8c3b018b,0x99840089,0x88c8005e,0x23dd000b}},	//   _auße, _domů_, злів_, _मालद
  { {0xe8f80010,0x7d0d01d3,0x27e102ad,0x682f174d}},	//   ялі_, mvas, ühn_, _nødt
  { {0xca7700e6,0x7d0d191f,0x2619000b,0xba770015}},	//   _فارغ, lvas, भाली_, _فارت
  { {0xff180008,0x443c1920,0x765b0061,0x34a90054}},	//   לקות_, _alv_, unuy, овио_
  { {0x3a840010,0x58d404e0,0x89340015,0x3ce9060a}},	//   _чырв, _потт, _كعكا, ntav_
  { {0x23c60046,0x3ce90085,0x42c902d9,0x5fdc0065}},	//   víjí_, itav_, огон_, _बाइल
  { {0xb05b00c0,0x3ce90020,0x7d0d0e95,0x6284002d}},	//   rsäl, htav_, hvas, _phio
  { {0xc7b80085,0x0555006b,0xdb1c02de,0x76400034}},	//   _dođu_, _отля, _udrå, chmy
  { {0x66090064,0x95c8005e,0xdb1e0cf7,0x320c0046}},	//   mdek, _хліб_, rapé, ědy_
  { {0x6d44002c,0xdfd20015,0xddcd0085,0x749a000a}},	//   vzia, ضير_, vlaš, _ויספ
  { {0x6284002f,0xdee31921,0x66091922,0xada60033}},	//   _thio, кори, odek, дабл
  { {0x9e750054,0xb2ba000a,0x1e750004,0x2ca600e1}},	//   ећуј, _ומקר, еѓус, íodo_
  { {0x15e2005d,0x99840046,0xdd8f00c3,0xfc2a1923}},	// [2980] क्टर_, _romů_, لوف_, ожак_
  { {0x660900f2,0x6d441924,0x6441001a,0x26c7036d}},	//   hdek, rzia, nhli, ksno_
  { {0xf09301d8,0xdb1c0030,0x7d0909cb,0x501b000a}},	//   _שנת_, _keré, _šest, _וויו
  { {0xa2d5005d,0xddcd0024,0x2a600020,0xceb3000f}},	//   _भिन्, plaš, õib_, _שיר_
  { {0x08fa0021,0x8dfb000a,0xdb1c0030,0xb5fd003d}},	//   تراب_, _והכת, _meré, nošu
  { {0x6bd60015,0x645d0003,0xcee9002b,0x76aa0e60}},	//   _تتحر, ésil, _برین_, отив_
  { {0x8c3b00b8,0xda660058,0x98690058,0x0000006a}},	//   _fußb, _قاري, أحنف_,
  { {0xd5b00029,0x44250134,0x6674002b,0xba260033}},	//   دفة_, ejl_, رگار, _ўдак
  { {0x69c00048,0x7d1b0251,0x3494006b,0x5e77000a}},	//   _ieme, _àust, наир, ותקן_
  { {0xd90d0086,0xd4670001,0x682f0293,0x69c01925}},	//   _دیه_, миње_, _døds, _heme
  { {0x69c00d25,0x988b000a,0x734a030c,0xbbd705bd}},	//   _keme, _וָאֵ, ючив_, וויץ_
  { {0x9f58002c,0x06b10089,0x682f0293,0x6fdc000b}},	//   ceré_, žící_, _føds, _बाउं
  { {0x229a0048,0x656f00b8,0x69c00d25,0x7bce005c}},	//   _rīku_, ücht, _meme, _odbu
  { {0x6441018b,0xd0840080,0x69c01714,0xdb1500dc}},	//   chli, выси, _leme, _lezá
  { {0x32670063,0xfe73012c,0x33db000a,0x0000006a}},	//   _отив, ندر_, _וחוד,
  { {0xe5080023,0x27e9016f,0xbddb18b3,0xdb150057}},	//   _kỷ_, đani_, _amèr, _nezá
  { {0xa2da005d,0x61fd1926,0xdd030024,0x91bc000a}},	// [2990] पूर्, mesl, _ārēj, _ומחי
  { {0x66090064,0x54780008,0xb05b00f2,0xb5fd1927}},	//   zdek, פְּנ, isäk, lošt
  { {0xdb1500dc,0xf214000b,0xde190015,0x7d0d1928}},	//   _bezá, _तोड़_, _فقدت_, svas
  { {0xfe3500b2,0x69c01929,0xdb050003,0x61fd192a}},	//   _נאָך_, _ceme, nché, nesl
  { {0xda080086,0xe8ee0080,0xadd60008,0x61fd192b}},	//   بينه_, ыл_, _אורח_, iesl
  { {0x0138000a,0x6bd40015,0xb5fd0046,0x66e502db}},	//   ורדת_, _لتفر, hošt, еока
  { {0x9f580089,0x3ea10020,0x6609016b,0xbbcb000b}},	//   teré_, _juht_, tdek, ाणीक
  { {0x06540010,0x85570086,0x69c0192c,0xf1db000b}},	//   ктыў, ویار_, _geme, _भागन
  { {0x6441192d,0x61fd192e,0x6609151d,0x0000006a}},	//   thli, desl, rdek,
  { {0x03250083,0xe3b10029,0x60dd0020,0x26dc0007}},	//   едон, درة_, dusm, buvo_
  { {0x35b5192f,0x69cc0089,0x979a004c,0x69c01930}},	//   _збер, ůlež, _זשעק, _yeme
  { {0xcb1200b2,0x61fd0384,0x68340251,0xb5fd0024}},	//   אלט_, gesl, _ràdi, tošu
  { {0x25b90084,0x7bc50035,0xddc40089,0xb6340015}},	//   ðslu_, kahu, tliž, _جعلت
  { {0xf8b20008,0x14d6000a,0xd0120021,0x7bc51931}},	//   רשם_, _נוצל_, دلس_, jahu
  { {0x5e96003b,0x3a3f0064,0x63050029,0xf772004c}},	//   فلسط, _olup_, _أوبل, ָקן_
  { {0xf1bf0030,0xd356000a,0x61fd1932,0x929a004f}},	//   lján_, _ריקי_, cesl, _ציפת
  { {0xc692103d,0xd7e0005d,0x8fa6017f,0x6bd6002b}},	// [29a0] ראן_, _नालच, _папе, فتار
  { {0x69c01933,0xf1bf0030,0x539a000a,0xec770920}},	//   _seme, nján_, ִינו, епу_
  { {0x69c0064e,0x4fbb0008,0x5f460015,0xcb0a0015}},	//   _peme, _מציא, _أنجل, ثيان_
  { {0xf38c0053,0xfbc9000a,0x0f570643,0xda6600c3}},	//   קראָ, מת_, _טיים_, راضي
  { {0xa3cf005d,0xd83a0010,0x2610005d,0xbd9b0135}},	//   षणा_, зэй_, _दोषी_, _מסכת
  { {0xdb1e00dc,0x916d0092,0x26dc1934,0x394602c1}},	//   lapí, _hội_, tuvo_, rzos_
  { {0x8c1b00b2,0x316c0050,0x28d2000b,0xcc77000a}},	//   _צולי, ędzy_, _सिवि, _נעלה_
  { {0xe5c6004a,0xb21b02de,0xddd10091,0xdb1e006f}},	//   хско, mlæg, _įgūd, napí
  { {0xb21b02de,0xb5fd0085,0x0595009a,0x61fd007f}},	//   llæg, vošt, پايگ, vesl
  { {0xb05b00c0,0x60dd007c,0x43941935,0x7c2e1936}},	//   rsäk, vusm, капс, _jobr
  { {0xb21b0134,0x229a0024,0xe1ff002d,0x61fd1937}},	//   nlæg, _rīks_, nnóg_, tesl
  { {0x916d0023,0xe5080023,0xe5a30054,0x60dd1938}},	//   _nội_, _tỷ_, _бици, tusm
  { {0x7bc5003f,0x3ea10020,0xe5080092,0xdb051939}},	//   yahu, _suht_, _uỷ_, rché
  { {0x7c2e193a,0x251b000a,0xa3a9000b,0x61fd193b}},	//   _nobr, _מודא, गुआ_, sesl
  { {0xddc4005c,0x60dd007c,0x2240193c,0xfc3f0030}},	//   bliż, susm, _flik_, _ktív_
  { {0xb21b193d,0x82370015,0xb05b008c,0x442e0c8f}},	//   dlæg, _سرعا, isäi, _hof_
  { {0x3d1b005d,0x3a2d0177,0x7bc5193e,0x6c750054}},	// [29b0] नमें_, _roep_, tahu, влађ
  { {0xddeb04b6,0xac19005e,0x5d840015,0x6f03016e}},	//   _کرده_, ьозу_, الكل, _ânco
  { {0xfb190015,0x220b000a,0xbb190015,0x7c2e193f}},	//   بقاع_, ּפְּ, بياض_, _dobr
  { {0x7bc504af,0xf2d30053,0x5ee8000a,0x442e1940}},	//   sahu, רעף_, _אַשְ, _lof_
  { {0x7c95003b,0x7bc50035,0xb21b0134,0xbddb0251}},	//   _للحص, pahu, lmæs, _elèc
  { {0xbddb0152,0x46f50036,0x25a9002a,0x28d2000b}},	//   _flèc, вчит, _żal_, _सिरि
  { {0x1c0a005d,0xddcd005c,0xe7080015,0xaa59107f}},	//   _होटल_, miał, فتين_, _живу_
  { {0x60cd016f,0xb05b00f2,0x7c2e0264,0xa8020061}},	//   _ovam, ssäh, _zobr, çıra
  { {0xe1ff00dc,0x93fd0010,0x98f400e5,0xe81e000b}},	//   deó_, оўнi, _مثلا, पाशा_
  { {0xddcd005c,0x442e0026,0xcad5000a,0x22401941}},	//   niał, _cof_, ֣וֹת_, _slik_
  { {0x22400050,0xf1c30023,0x60cd1942,0xb21b02de}},	//   _plik_, _trở_, _avam, klæd
  { {0x6b9a002e,0xe6040015,0x3552009a,0xe3b1009a}},	//   _útge, _مِمَ, انیز, درک_
  { {0xf1bf0014,0xdd010089,0x4103006b,0x45b6000a}},	//   pján_, čtět, азяв, _ספסל_
  { {0x65940124,0xd4790053,0x442e0034,0x2a7d0034}},	//   _сачу, _קאַל, _gof_, hlwb_
  { {0xf456000a,0x83f60054,0xd466029f,0xbfc31943}},	//   _שיצר_, _рејс_, _шише_, рбск
  { {0xb17b00c0,0x8d760015,0x7c2e0ec1,0x224000cb}},	//   mgån, ناءا, _sobr, _ulik_
  { {0x660b00b6,0xb17b00c0,0xdca303ad,0xed571944}},	// [29c0] _magk, lgån, иати, вот_
  { {0x2137015b,0x660b02dc,0x30760132,0x0000006a}},	//   _סטיל_, _lagk, _шуйс,
  { {0x9f4800f2,0xfaa30033,0xb17b0123,0x8b9612ba}},	//   ähän_, аахо, ngån, трач
  { {0xb21b0084,0x660b0035,0x7c2e0034,0x5d860015}},	//   rlæg, _nagk, _wobr, _للجل
  { {0xb21b0134,0xd94603ad,0xda650021,0xddcd002a}},	//   slæg, ъеди, دالي, biał
  { {0xddcd005c,0x987302e5,0x2b4d0046,0xf770009a}},	//   ciał, аліц, _řece_, یاژ_
  { {0x44200023,0x97c50015,0x7d040012,0x97240015}},	//   _đi_, اتهم, lwis, افعو
  { {0x2619000b,0xf76f0015,0xb17b0123,0x6b830359}},	//   भागी_, غاو_, dgån, ünge
  { {0x2ca6017e,0x57ea000d,0x25f3000b,0xdb1c1945}},	//   íodh_, _одам_, ्ज़ी_, _merí
  { {0x93b40033,0xa9750054,0xd83800b3,0x6a7809ae}},	//   ыбоц, _сусј, _biče_, rífu
  { {0x7bdb000a,0xdb150012,0x66270061,0x7d0401f1}},	//   וקיו, _gezä, ürkç, hwis
  { {0xddcd005c,0x7d04003f,0xb21b1946,0x7e0c000b}},	//   ział, kwis, emær, हयोग_
  { {0x7642003f,0xa4d40036,0xa9bb000a,0x6a78001a}},	//   _iloy, _солі, וזכר, lífs
  { {0xb21b1946,0x6697004c,0xf993015b,0x1074005e}},	//   gmær, _נאַרײ, ירר_, иляю
  { {0xf8c80092,0x7d040313,0x925b0015,0xadd50054}},	//   hứ_, ewis, _يشعر_, ловљ
  { {0x63970008,0x12870086,0xddcd005c,0x6d0e000b}},	//   _בדוא_, _جمعی_, wiał, सिंग_
  { {0xd90404b6,0xebc70124,0x2d580a2c,0xb21b0134}},	// [29d0] _بی_, вљен, вить_, smæs
  { {0x5fb7000b,0x6bd40067,0x61f60046,0x76421947}},	//   _अभिल, لتمر, _zbyl, _lloy
  { {0xddcd005c,0xc174002b,0x8c3b0012,0x98b8003d}},	//   riał, _مدیت, _fußn, _ārā_
  { {0x629e0152,0xddcd005c,0x7f3a000a,0x22591948}},	//   _épou, siał, _נערו, nisk_
  { {0x4dda013a,0xbd6b0001,0xddcd002a,0xdb1c1949}},	//   _אחרו, _црне_, piał, _cerâ
  { {0x07090015,0xb7d90015,0xd366009a,0xd7c902be}},	//   فيتي_, روعا_, _هه_, روبه_
  { {0x660b025c,0x06f50015,0xf0940643,0xd7e4005e}},	//   _pagk, استج, בנס_, річо
  { {0x9f9c0008,0xceb40008,0xdb0700dc,0xf509194a}},	//   וסופ, ביק_, _bejö, енил_
  { {0xd919000a,0x614a0003,0xb05b0012,0xddcd002a}},	//   _אוּל, _mêlé, lsäu, miań
  { {0x2c1c000b,0x9cd6000a,0xb17b0123,0x7d7c000a}},	//   नाएं_, נותה_, tgån, ונחו
  { {0xc7350087,0x7d04194b,0x8c1a000a,0x9234004c}},	//   _حفاظ, zwis, גותי, אָרט_
  { {0x7d04005c,0xb17b00c0,0x41b6004a,0x98bd002a}},	//   ywis, rgån, ысот, azwą_
  { {0x1c03000b,0x7fd600e2,0x6fd600ce,0x5155194c}},	//   रजाल_, ліві, лівц, атру
  { {0xdb1c02c1,0xd838044c,0xf1e8000b,0x8f760033}},	//   _serí, _tiče_, ट्ज़_, губі
  { {0x9e66002b,0xdb1c194d,0x2259194e,0x7f860058}},	//   هارن, _perí, bisk_, الأن
  { {0x22590050,0x25ad194f,0xb21b02de,0x11e6004a}},	//   cisk_, ncel_, smær, _сжим
  { {0xb21b02de,0xdb1c1950,0xc1060015,0xddcd002a}},	// [29e0] pmær, _verí, _صودي, diań
  { {0x5f760086,0x629e0251,0xdb1e0125,0x7d041951}},	//   _ماجر, _èpoc, eapá, rwis
  { {0x41b8000b,0xe9da1952,0x7d040012,0x28c6000b}},	//   _आभास, еке_, swis, रीनि
  { {0x539a000a,0xfe42002b,0xe9e5005e,0x38c8002b}},	//   גיעו, _اکسی, иціо, ناتی_
  { {0x91bb000a,0x27150016,0x9f581953,0x64430030}},	//   גמני, _h́nh_, lerà_, _olni
  { {0xdcfd0048,0xf5390046,0xe89400e2,0x0000006a}},	//   _uzsā, dyť_, шаль,
  { {0xf1ba0023,0xeab401e4,0xcc870015,0xbb460004}},	//   _đơn_, _כִּי_, _إنّه_, _севк
  { {0xfb1b0008,0x7e640a54,0x963416e7,0xb05b0400}},	//   _אולמ, nnip, рниц, lsät
  { {0xc9660010,0x3d17000b,0x9f5802b9,0x6a6b000a}},	//   _свай, निये_, herà_, _טֻמְ
  { {0x54540661,0x2259005c,0x68e20a6d,0xc4f70015}},	//   рвот, wisk_, muod, اعيا_
  { {0xd5e20023,0x5c5b0053,0xb05b00f2,0xb8930029}},	//   _chọ, תדיק, isät, _اللع
  { {0xbb3b0053,0x3eb800bc,0x9f581953,0x64430091}},	//   געטי, dprt_, derà_, _elni
  { {0xf1bf00dc,0x27150092,0x25f3000b,0x7c3e00cb}},	//   lják_, _ánh_, ्जरी_, kkpr
  { {0x33940010,0xd40a0015,0x61e602f2,0x22591590}},	//   _калё, _ستتم_, agkl, sisk_
  { {0x33170029,0x343b0053,0x645a1954,0xa6f8000a}},	//   _مزيد_, _אײגע, miti, כִּי
  { {0x442c00c0,0x9757000a,0xc333000a,0x68e20091}},	//   ljd_, אילו_, _לוצ_, kuod
  { {0x26c10014,0x5d990010,0x644800f2,0xdc550292}},	// [29f0] ához_, ткаў_, ohdi, авањ
  { {0x68e20007,0xddcd005c,0x40ec000a,0xe7e0000b}},	//   duod, wiań, _נַחֲ, _नागप
  { {0xcb550124,0x442c0111,0x443e1955,0xdb0e00b8}},	//   јвећ, ijd_, ikt_, _gebü
  { {0xdb1c03af,0xf1bf00dc,0x99a80029,0x20031956}},	//   _serã, dják_, هُمْ_, leji_
  { {0x443e002e,0x89a80036,0xfc3f002d,0x645a1957}},	//   kkt_, уків_, _dtír_, kiti
  { {0xccf20008,0x443e0111,0xd8b80015,0x3158015b}},	//   _וכך_, jkt_, ادنا_, ניגן_
  { {0xaa950036,0xf1bf00dc,0xfc3f02c1,0xdb1c001c}},	//   _вивч, gják_, _guía_, _verã
  { {0xe6c40029,0xceb400f3,0x443e1958,0xcf58000a}},	//   حتوي, זיק_, ekt_, טבות_
  { {0xdb1c001c,0x7bc70375,0x69cb1959,0xdcef003d}},	//   _terã, _keju, mage, _izcē
  { {0x4d7c0053,0x6448002d,0xf539002c,0x8cdd000b}},	//   ערזע, ghdi, ryť_, _पिनो
  { {0x9f58195a,0x628d0125,0x200305ca,0xcc56000a}},	//   xerà_, _bhao, deji_, שבתי_
  { {0x7bc70048,0x443e0111,0x38ab0134,0x9f5804ed}},	//   _leju, akt_, _kør_, verà_
  { {0x628d002f,0x9f58195b,0x645a195c,0x38ab00cb}},	//   _dhao, derá_, biti, _jør_
  { {0x443e195d,0x7649002e,0x645a195e,0x6d4d0079}},	//   ckt_, lhey, citi, dzaa
  { {0x94740029,0x68e20007,0xe516000b,0x0e560054}},	//   _ادنا, zuod, तिथि_, ађар
  { {0x628d002d,0x9f5802b9,0xd24f0015,0xdb1c006f}},	//   _ghao, rerà_, _ينو_, _nerá
  { {0x527b0008,0xb05b03a4,0x6486002e,0x127b004c}},	// [2a00] _בנקא, tsät, iðin, _באקע
  { {0xdb1c002d,0xb05b0012,0x9c230054,0xbab60015}},	//   _aerá, usät, одуд, لمطب
  { {0x49ca0080,0xb05b0c77,0x3fdb000a,0x9f58195f}},	//   влен_, rsät, _בקיב, berá_
  { {0x4e030010,0x38ab169b,0xb05b0f3a,0x9f580656}},	//   _дзюб, _bør_, ssät, cerá_
  { {0xb05b00c0,0x39400ab3,0x6448008c,0xd9d7005e}},	//   psät, áis_, yhdi, рмії_
  { {0xf1bf0014,0x2c1c005d,0x68e20007,0x26dc0085}},	//   tják_, नाओं_, ruod, trvo_
  { {0x68e200f2,0x39400007,0x45d40010,0x7d160089}},	//   suod, šis_, бойс, lvys
  { {0xd6260029,0x2619005d,0xb6e30010,0x96b700e6}},	//   شعبي, _मोदी_, цюшк, جاوز_
  { {0x38ab00fb,0x37e60080,0x645a1960,0x04660973}},	//   _gør_, _возг, titi, итом
  { {0x628d002f,0x9f58002c,0x443e003d,0xf1bf0030}},	//   _shao, zerá_, ukt_, pják_
  { {0xcc3b0053,0xfbd3000a,0x7414002b,0xa87b000a}},	//   דעיט, חתת_, لوکا, _יאמר
  { {0xa75b0008,0x443e1961,0x7ae30144,0x6f09002a}},	//   _בדבר, skt_, ànti, łeck
  { {0xc05b0191,0x9f58001c,0xdcef0024,0x51870010}},	//   вів_, verá_, ādīs, руна
  { {0xc05b0036,0xdb1e0251,0x02a606fe,0x853b000a}},	//   тім_, capç, _крим, _בגדי
  { {0xa2e3000d,0xdb1e0020,0x628d002d,0x44f00291}},	//   _дојд, napä, _thao, là_
  { {0x2003003f,0x7bc7064e,0x98bd005c,0xb05b00f2}},	//   seji_, _seju, azwę_, tsäs
  { {0x629f0152,0x2ba70001,0xdb1e0020,0xdb050264}},	// [2a10] _époq, ајев, hapä, dchá
  { {0x44f002d7,0xdb1c02c1,0x6d4d0111,0x6e2d0079}},	//   ià_, _será, rzaa, sjab
  { {0x44f00092,0x2bb9005d,0xb05b1581,0x38ab13e1}},	//   hà_, इडबा, ssäs, _sør_
  { {0xceb200b4,0xc212000a,0x7d0b02de,0xe0df01e0}},	//   _מיט_, ּ֔א_, ægss, orò_
  { {0xe9d80010,0xdb1c0fc9,0x79800034,0x78eb004a}},	//   ркі_, _verá, _cymw, тьев_
  { {0xfd96000a,0x44f00144,0x1bb800c3,0xb0b8000a}},	//   _לדרך_, dà_, _نافع_, ספוס_
  { {0xb9e70036,0xdb051962,0x69cb1963,0x87040015}},	//   _візи, rbhó, page, قبيل
  { {0x62560007,0x683d0251,0x99d40015,0x38ab0013}},	//   ršok, _mèdi, _وتقا, _tør_
  { {0x64860084,0xf8070036,0x79800026,0x49040015}},	//   rðin, _вчен, _gymw, _ووفق
  { {0x04450054,0xddcd00bc,0x76950091,0x61ed1964}},	//   сеон, jlaž, _ašyt, _acal
  { {0x9f580251,0xe0df1732,0x60c41965,0xddcd18b1}},	//   merç_, erò_, _swim, dlaž
  { {0x44f00144,0x78a11966,0x7d16008c,0x0000006a}},	//   bà_, _hilv, yvys,
  { {0xf6740029,0x44f00251,0x78a91967,0x25bf142d}},	//   _بالخ, cà_, _juev, mbul_
  { {0xf992000a,0xf3f10015,0x78a90077,0xb97a004f}},	//   פרם_, _رأت_, _muev, רנשי
  { {0x7ae50020,0x61ed00f2,0xf1bf00dc,0x3e860015}},	//   juht, ällö, bbá_, مشرف
  { {0xf8a504b6,0x60db0007,0x25bf1968,0x6ca60015}},	//   _يک_, šuma, nbul_, مصطل
  { {0x78a90467,0x64410024,0x925a002b,0xc692000a}},	// [2a20] _nuev, okli, _لشکر_, לאל_
  { {0xdd8f00e6,0x64411969,0x3157000a,0x8b9601b7}},	//   رول_, nkli, _ליפן_, бреч
  { {0xb09b0008,0x3ad30015,0x25bf01c2,0x6441196a}},	//   _תייר, كيلز, kbul_, ikli
  { {0x0dba0029,0xd9100086,0xdb1e0020,0xdb050046}},	//   _حادث_, ویز_, vapä, uchá
  { {0x78a9010d,0x44f00144,0x807a000a,0x9e630033}},	//   _cuev, xà_, ְנֶצ, _хвяд
  { {0x78a10048,0xb900005d,0x76590034,0xaad1000b}},	//   _cilv, _थि_, _amwy, _हिचक
  { {0x61b8000b,0xbbc4000b,0x1ae318c3,0x5694012a}},	//   _आभूष, षरीक, _норм, оакт
  { {0x44f002d7,0x44b40191,0xbb3b0053,0xc8e0005d}},	//   tà_, обис, _געלי, _निपट
  { {0xb4260015,0xdb1c196b,0x78a9196c,0x9f5a0030}},	//   معدو, _berç, _guev, _kapó_
  { {0x25bf0064,0x44f0196d,0x64410035,0x9f5a0251}},	//   abul_, rà_, gkli, _japó_
  { {0xcc7b00b2,0xe2f80036,0x78730015,0x95c6002b}},	//   רװיר, шені_, _عُما, _هياه
  { {0x644100dd,0x3ea2005c,0x78a10111,0xe0df04ed}},	//   akli, _nikt_, _zilv, trò_
  { {0xdb1c00f2,0xf5960029,0xd516002b,0x867b0643}},	//   _herä, _الشج, _دباغ, _גראו
  { {0xdb1c196e,0x61ed005c,0x6441196f,0xe0df02b9}},	//   _gerç, _wcal, ckli, rrò_
  { {0x76590026,0xc058042b,0xc6d8000f,0xb3f7000a}},	//   _ymwy, сія_, יַּר, _המוח_
  { {0x74bf000b,0x8de50058,0x2fdf00d4,0x0000006a}},	//   लीकृ, تكره, şug_,
  { {0x7c35002c,0xdd9401b0,0x3ea20795,0xdb1c0061}},	// [2a30] _pozr, заты, _dikt_, _yerç
  { {0x4d98044e,0x3ea2003d,0x25bf01c2,0xbc3b009a}},	//   скую_, _eikt_, zbul_, دسرا_
  { {0xfbd00029,0x29d50029,0xdc300091,0x5f95029f}},	//   عتك_, قياس, ažįs, _финт
  { {0x64410024,0x78a11970,0x7ae50a94,0xdd2b0030}},	//   zkli, _silv, ruht, sőűr
  { {0xbcfb001c,0x7ae50044,0x49c801f3,0x7c871971}},	//   _exér, suht, слін_, _гуве
  { {0xdb1c01d1,0xdd31005c,0xd0f8000a,0x8aa71972}},	//   _berä, zęśc, צמות_, _град
  { {0x20131973,0xf6d5005e,0x8ca20065,0x6e38013b}},	//   _maxi_, ціля, _कूटो, žabš
  { {0xe892006f,0x44f90033,0x56920099,0x625601c0}},	//   ĺňať_, ахоў_, мајт, lšov
  { {0x78a1075b,0x89370086,0xe9d9005c,0x58050015}},	//   _tilv, _اعزا, _idź_, _وورك
  { {0x99480029,0xf9900029,0xa9880008,0x64411974}},	//   _الكل_, _سبق_, _הָעִ, ukli
  { {0xdb1c00b8,0xc5d50036,0xb21b0134,0x8bd6000a}},	//   _gerä, _діль, rlæn, חותו_
  { {0x99f90053,0x625a004a,0x64411975,0x28e00065}},	//   ױפֿפ, ррор_, skli, _निमि
  { {0xdb1c168c,0x99f6000a,0xa2d5000b,0x7a88000a}},	//   _terç, חזרה_, _भिक्, מָשַ
  { {0x224900d9,0xf8b2000a,0x2d8200aa,0x3ea20795}},	//   _elak_, ושך_, _ryke_, _sikt_
  { {0x03250036,0x82860015,0x4fa3006b,0x6b830012}},	//   _єдин, _وجعل, дирв, üngl
  { {0x3f8403eb,0xdcf7005d,0xedf4002b,0x1e8600e2}},	//   āmu_, ुबंध_, ثيرگ, ілам
  { {0x62730029,0x3ea200c0,0x0d9a056d,0xdbca0248}},	// [2a40] _تهيئ, _vikt_, ртвы_, игад_
  { {0x39420020,0x62861976,0xc8e0000b,0x6b660248}},	//   _üksi_, llko, _निबट, окза
  { {0x0b460010,0x3ea20024,0x6da600ff,0xe7ed000b}},	//   ўнен, _tikt_, _мина, च्छा_
  { {0xaac50015,0x66fc003d,0xf9861977,0x99460058}},	//   ستمن, nākš, огео, يَاه
  { {0xa3e9000b,0xf1bf0030,0x62861978,0x082a1979}},	//   यला_, mját_, ilko, ицки_
  { {0xdb1c00f2,0xf1bf00dc,0x410b000a,0x9f58008c}},	//   _perä, lját_, שִׁ֣, perä_
  { {0x27e001e2,0xf7930010,0x38c8002b,0xa09b000a}},	//   ğin_, машэ, _گازی_, ביסט
  { {0xdb1c00b8,0x67f4002e,0x27e0062c,0x8f9b000a}},	//   _verä, fþjó, şin_, סיקי
  { {0xd40603ad,0xe46a0004,0x746a0e1a,0x69c2197a}},	//   ояни, ишол_, иров_, mboe
  { {0xb3540805,0x68e20026,0xdb1c00f2,0x6abe00cb}},	//   зкош, mrod, _terä, oppf
  { {0xf1bf00dc,0x68e4002d,0x22490150,0x28c6000b}},	//   kját_, áidf, _plak_, रीरि
  { {0x64a6197b,0x68e2197c,0x22440015,0x69c2197d}},	//   _дада, orod, ِنَّ, nboe
  { {0x1a9b00b2,0xf1bf00dc,0xba9b04dc,0x2beb021e}},	//   ייטע, dját_, יסטי, _चालू_
  { {0xadee005d,0x7414002b,0x68e20030,0x6286197e}},	//   ङ्घन_, _روبا, irod, alko
  { {0xd83800bd,0x6fbf000b,0x69c216f3,0xce95006b}},	//   _moč_, ्रबं, kboe, завъ
  { {0xf1bf00dc,0x68e20205,0xd019002a,0xe731000a}},	//   gját_, krod, śń_, עֵם_
  { {0x5d550549,0xa3ae005d,0xfbab034e,0xdfa70015}},	// [2a50] чкат, _कला_, атей_, _وحدي
  { {0xf1bf00dc,0x68e2197f,0xd83800bc,0x4c940a32}},	//   aját_, drod, _noč_, диус
  { {0xb5fd0f81,0x30a40033,0x68e21980,0x625601c0}},	//   liše, _ўрыв, erod, ršov
  { {0xc33300b2,0x5a350063,0x69c20111,0x539b000a}},	//   ווע_, янет, gboe, ביבו
  { {0x2ca30298,0x68e2005c,0x62560107,0x4054002b}},	//   _tijd_, grod, pšov, _رئیس
  { {0xdb150030,0x96f90015,0xe1ff0030,0xd7fb0189}},	//   _kezü, معبر_, liód_, руд_
  { {0x44290023,0x3ffc00b2,0xb6590080,0x17f80015}},	//   _đa_, יפגע, йших_, ترنة_
  { {0x67f4002e,0x68e21981,0x05b90015,0xdb050012}},	//   tþjó, brod, حدثت_, rchä
  { {0xdb05018b,0xc68e0015,0x66fc003d,0x7d0d1982}},	//   schä, دِي_, vākš, nwas
  { {0x67f4002e,0x87270015,0x7d0d02f2,0x28e00065}},	//   rþjó, _وعام, iwas, _निति
  { {0x58840010,0x67f4002e,0x59cf000b,0x2bfd000b}},	//   _цыта, sþjó, _हजार, र्यू_
  { {0xdb120014,0x6286003d,0x83fc0085,0x41e50015}},	//   égév, ulko, viđe, وسُف
  { {0x271c0023,0xa5670086,0xf221000b,0xd24f0015}},	//   _ảnh_, _بدان, याज़_, انُ_
  { {0x66fc0024,0xdb1500b8,0x94ba000a,0xa879004c}},	//   sākš, _bezü, _המסת, מאָר
  { {0xa2d20015,0x44271983,0xf1bf0030,0x7d0d1984}},	//   _كيوت, _inn_, tját_, ewas
  { {0xdd920029,0xd24f0015,0x68e2002a,0x66091985}},	//   فوز_, _منى_, yrod, neek
  { {0x59cf000b,0xf1bf0030,0x16c80065,0xad250058}},	// [2a60] _हज़र, rját_, _रब्ब, وركو
  { {0x66091986,0x4c830345,0x515b000a,0xac830c71}},	//   heek, елув, _לכפו, егул
  { {0x103b0008,0xf1bf00dc,0x291f003f,0xda6f006b}},	//   _הגיע, pját_, _arua_, ея_
  { {0x200a0064,0xdca61987,0x7d0d003f,0x20181988}},	//   lebi_, _нами, bwas, ldri_
  { {0xb05b0020,0x68e20007,0x69c20159,0x7d0d0026}},	//   späe, urod, rboe, cwas
  { {0xb17b003c,0x2af60033,0xd8230054,0x764b0034}},	//   mgåt, _нябё, едљи, _algy
  { {0x20180024,0xa91d099c,0xa09b0135,0xbbba000b}},	//   idri_, _vyža, זיסט, ेरीक
  { {0x4427002f,0x54b803ad,0xe4e6005e,0x46a30054}},	//   _ann_, огия_, піон, најв
  { {0x7bce064e,0x88c50015,0x48e30289,0xb17b00cb}},	//   _kebu, _يتكل, _потв, ngåt
  { {0x88bb000a,0x986a0015,0x200a0085,0xb5fd06c0}},	//   _לזמי, _احرف_, jebi_, više
  { {0x67bb0008,0x77bb000a,0xf3660342,0x2018001a}},	//   _המבק, _המבח, ятин, ddri_
  { {0x7d0d005c,0x44271989,0x9f58006f,0xf1bf0030}},	//   ywas, _enn_, berú_, ejár_
  { {0x867b000a,0xba57004c,0xda7b000a,0x067b000a}},	//   _פרדו, לסטו_, מנטר, _פנדל
  { {0xc0580010,0xd59b0008,0xb5fd0796,0x859b000a}},	//   піс_, _הבדל, riše, _השדו
  { {0x33fb009d,0x8c3b00b8,0xa3e9000b,0x93fb000a}},	//   _להגנ, _mußt, यलर_, _הלוי
  { {0x7d0d0035,0xb5fd0796,0xf3130015,0x1eea002b}},	//   twas, piše, _أبوظ, توفی_
  { {0x62560007,0x200a0064,0xa6970008,0x41c3000b}},	// [2a70] ršot, bebi_, לכלה_, _व्यस
  { {0x7c140036,0xfbab0033,0x5458000a,0xdb070030}},	//   ндує, стай_, קֳּד, _ifjú
  { {0x2bb80029,0x6ffa000a,0x99d70015,0x7bdc0034}},	//   سالة_, _והתפ, كتشا, _ddru
  { {0xa3dc005d,0xfd1f0092,0x43770053,0x2cb90015}},	//   तृत_, _trì_, הײבן_, _وُجد_
  { {0x9f5102c1,0x28a7004a,0x6609007c,0xf9900021}},	//   pezó_, чшег, veek, هبه_
  { {0x7bce059b,0x6fbf000b,0x7e6d0030,0x6609198a}},	//   _gebu, ्रिं, lnap, week
  { {0xe7360063,0x6d400020,0xac94198b,0x6609198c}},	//   дещ_, _ümar, _чарш, teek
  { {0x7bdc198d,0x7e6d030f,0x61fd0079,0xddc40045}},	//   _zdru, nnap, jfsl, mniţ
  { {0x6fbf005d,0x7cde0011,0x7e6d198e,0x66090161}},	//   ्रां, părţ, inap, reek
  { {0x68e4002f,0xcc3a0053,0x61fd002e,0x7e6d198f}},	//   áide, ַערט, efsl, hnap
  { {0x420a02c8,0xfbd2000a,0x8c1c000a,0xc7b2000a}},	//   онно_, כתי_, מוזי, _סבא_
  { {0x1fc60372,0xd9ff005d,0xc049000a,0xf7480015}},	//   वर्ड, ोजित_, _דז_, _علني_
  { {0xd4350029,0x113a0033,0x7e6d1990,0x241908f0}},	//   _يعتب, цяны_, dnap, _моды_
  { {0xe800000b,0x24180033,0x2bb2000b,0x859a000a}},	//   ल्पा_, _ночы_, _जलधा, _ושנו
  { {0x7bce1991,0xa28a0015,0x92660015,0x10a30296}},	//   _rebu, _وضعك_, _يدعم, тирн
  { {0x7bdc01cb,0x7bce013c,0x200a1992,0x67210085}},	//   _sdru, _sebu, sebi_, _mrlj
  { {0xd59a004c,0x6aae1993,0x6abc1994,0x0000006a}},	// [2a80] ַבעל, _subf, _strf,
  { {0x7e6d0035,0x1daa000b,0xfce30c02,0xb17b02dc}},	//   anap, _कलकत, тофо, rgåt
  { {0x28e0000b,0x5f76002b,0x4fd7000a,0xddc6004a}},	//   _निहि, _زادر, _קוטב_, _обни
  { {0x533600b2,0x1bf0000b,0xb9b4002b,0x7bce1995}},	//   ונען_, _चावल_, رمتع, _webu
  { {0x644f0024,0x7c490030,0xd8b70015,0x7bce1996}},	//   īcij, ásró, ودوا_, _tebu
  { {0x7bdc016f,0x8884002b,0xdb240045,0xa157000a}},	//   _udru, ریان, ăsân, ובנה_
  { {0xba0a0015,0x62840091,0x68e40125,0x61fd00aa}},	//   _وترك_, _okio, áidb, yfsl
  { {0x44200440,0x8c3b0012,0x151401b7,0x7c3c16c8}},	//   _şi_, _wußt, едия, _horr
  { {0x6d440375,0x7c3c1997,0xd6770015,0xf3f10016}},	//   nyia, _korr, بحوا_, hịu_
  { {0x03f80001,0xdb1c01f0,0x62840573,0x798d002a}},	//   чној_, _berø, _akio, żawc
  { {0x8c1b000a,0x17790033,0x7c3c1998,0xe7d5002b}},	//   קוטי, _есць_, _morr, _سمنگ
  { {0x68ed0780,0x75460063,0x1fb7000b,0x63ad1999}},	//   žodž, _онез, अड्ड, _şant
  { {0x61f4002c,0xa19400e2,0x61fd199a,0x7c3c0547}},	//   _želá, каюч, rfsl, _oorr
  { {0x7c3c199b,0x20840015,0x30840015,0x0000006a}},	//   _norr, َلَّ, َلَف,
  { {0x9f5f0064,0xe3b80064,0x75220057,0xa3b70015}},	//   _ürün_, mcı_, _hroz, _غاور_
  { {0x7e6d003f,0xd717000a,0x60380061,0x91690016}},	//   unap, וחלט_, _aşmı, _lửa_
  { {0x7c3c0c07,0x28e0000b,0x8d770067,0xb1b9002a}},	// [2a90] _borr, _निषि, ذارا, ążąc
  { {0xe3b80064,0x2ca7199c,0x7c3c1103,0x6f050016}},	//   ncı_, önd_, _corr, _tphc
  { {0x7c3c0335,0x30780015,0x660200bc,0x443c199d}},	//   _dorr, _تحية_, _obok, _mov_
  { {0x60cd199e,0xddeb0086,0xddc40011,0x7a390010}},	//   _kwam, _برده_, rniţ, япер_
  { {0xa8030064,0xb90b00a2,0xc27c000a,0xf8b1002b}},	//   _çıkt, تزام_, חראי, اکر_
  { {0x91690092,0x60cd003f,0x68eb0159,0x6e3d0034}},	//   _cửa_, _mwam, rugd, _hosb
  { {0xddc400bd,0x98bf0064,0x394915ff,0x1ab40010}},	//   lniš, ırım_, šas_, _абся
  { {0xf7700031,0xddc40085,0x83fc0085,0x7c3c199f}},	//   جاه_, oniš, viđa, _zorr
  { {0xc8f40063,0x22920046,0x6e3d00c7,0xd7fb0a15}},	//   _изтъ, jáka_, _mosb, _муж_
  { {0xe1ff002a,0xe5760033,0xf8b2000a,0x87070015}},	//   onów_, эзы_, _עשב_, _يبال
  { {0x13a70086,0x63ad19a0,0xc169000a,0xddc400bc}},	//   بندی_, _şans, _פח_, hniš
  { {0xf0890008,0x23bf000b,0x28c6000b,0x64480061}},	//   _הנ_, _श्रद, रीकि, akdi
  { {0x321e0089,0xc56b0040,0xddc402d8,0x752219a1}},	//   ěty_, _بحال_, jniš, _groz
  { {0x653a0053,0x661b19a2,0xddc402c6,0x853a000a}},	//   _מענד, lduk, dniš, _מגני
  { {0x7522095b,0xc2c80115,0xc7b2000a,0x6e3d0079}},	//   _zroz, _قبيل_, רבל_, _bosb
  { {0x82360074,0x6e3d19a3,0x6aa9002a,0xb05b008c}},	//   _سربا, _cosb, _nief, isäy
  { {0x6e3d0026,0x33f90008,0xb05b008c,0x1d0702b0}},	// [2aa0] _dosb, ּהֲנ, mpän, нети_
  { {0xe0fb0008,0x31570053,0x661b008c,0x7e6405ff}},	//   _צליל, _ניין_, hduk, siip
  { {0x4ff70053,0x7c3c19a4,0x916900a1,0x7d1b005a}},	//   _אזיע_, _vorr, _rửa_, _šust
  { {0x91690023,0x7ae3002f,0xddc4018c,0x78a800c0}},	//   _sửa_, ánta, bniš, _sidv
  { {0xe3b80061,0x5f76002b,0xc98319a5,0xe1ff002a}},	//   ycı_, _زاگر, луши, anów_
  { {0xa9670029,0x98a312bd,0x260a0016,0xb5fd19a6}},	//   عموم_, гиче, _ẹo_, viša
  { {0x09e60191,0xda660015,0x75220046,0xe3b80061}},	//   _повн, _كاري, _sroz, vcı_
  { {0xceb30008,0x8afb000a,0x752219a7,0xe8fa0004}},	//   ניח_, _מהלי, _proz, _нлб_
  { {0xc8ca0018,0x7d1b016e,0xe4740054,0x78a80804}},	//   _روان_, _áust, клињ, _tidv
  { {0x201a0014,0x07a613ae,0x78250029,0x7b070030}},	//   _napi_, _зазн, _لعمل, _írtá
  { {0x60cd19a8,0xddc40844,0xb5fd0091,0xe3b80061}},	//   _swam, zniš, siša, rcı_
  { {0xd3770010,0xb5fd0fd0,0x752219a9,0xe606008c}},	//   эчы_, lišn, _troz, äsää
  { {0x865b000a,0x44f90144,0x2619000b,0x1ee7002b}},	//   _צדדי, cè_, _मोटी_, کوزی_
  { {0xddc40263,0xc56900e5,0x20cd044c,0xe1ff002a}},	//   vniš, _تحمل_, rži_, ynów_
  { {0x141b0008,0x6e3d00dd,0x4ee40033,0xadd50054}},	//   _מוגב, _posb, літз, ковљ
  { {0xddc40844,0x6d1c000b,0x9f6001d3,0x0000006a}},	//   tniš, निंग_, árát_,
  { {0x22ac0089,0x7db40015,0xc27c000a,0x6aa919aa}},	// [2ab0] _věku_, اصفا, _מרהי, _rief
  { {0x31580053,0xddc40844,0xb05b008c,0xb5fd0085}},	//   _ריזן_, rniš, ysäy, jišn
  { {0xb5fd19ab,0xcfb60008,0x99f50010,0xd07400a2}},	//   dišn, _בלתי_, вялі, _حديث
  { {0xee21005e,0xe1ff002a,0xddc4036d,0x314b000a}},	//   _темi_, rnów_, pniš, ּתַּ
  { {0x9dd60053,0xdfa7002b,0x9be7005e,0x62640030}},	//   _בורק_, _تحکي, _півк, dőol
  { {0x6bd40115,0xddeb002b,0x7ae2003d,0x6486001a}},	//   _متفر, _برگه_, ņota, iðis
  { {0x6aa900b8,0xe3b10086,0x39460035,0x79c90115}},	//   _tief, یرد_, ayos_, _يوسف_
  { {0x6b8302ad,0x44f903a0,0xdb1e03a0,0x0000006a}},	//   üngu, tè_, aapó,
  { {0x44f90251,0xe4d6002b,0xf495004a,0x04950033}},	//   uè_, نويت_, крою, кроў
  { {0x764910d0,0xe5040015,0x661b19ac,0x032502ed}},	//   skey, ابيي, sduk, вдон
  { {0x35f50010,0x201a0375,0x95d9004a,0x6b8c000a}},	//   _апер, _rapi_, _ждет_, ּאכֵ
  { {0x201a00e8,0x216a0758,0xcb12000a,0xe1f20015}},	//   _sapi_, дими_, בלט_, جسد_
  { {0x2124002d,0x89da000a,0x6fd6005e,0xe535006b}},	//   ímh_, וחרי, ківц, _шедь
  { {0x0596002b,0x3a3f19ad,0x8548005e,0xdcee003d}},	//   _شانگ, _loup_, _язів_, ūdīg
  { {0xfc3f0f14,0xe1ff0077,0x201a0072,0xb05b005b}},	//   _luís_, mión_, _vapi_, ppän
  { {0x201a003f,0x33760008,0x2ee5001a,0xe1ff19ae}},	//   _wapi_, _בעצם_, álfa_, lión_
  { {0x201a013c,0x70560015,0x84ac000a,0xbea319af}},	// [2ac0] _tapi_, _لنظا, ִיאִ, ратк
  { {0xe1ff02c1,0x8b260010,0xe572000a,0xec7700ce}},	//   nión_, кдзе, בַע_, впу_
  { {0x8fa605e6,0xb5fd0085,0xfeba002b,0x539a0c44}},	//   _јане, višn, _تاخت_, ֵינו
  { {0xc332013a,0x3a3f19b0,0xaae50015,0x2fd80144}},	//   יוב_, _coup_, اسلو, larg_
  { {0xdb1e002e,0x3ea019b1,0x63bc0030,0xc7b80085}},	//   tapó, mmit_, űrni, _lađe_
  { {0xdb1c0014,0xb7d80029,0x515b0008,0xfbc30004}},	//   _kerü, روبا_, וכנו, _вбро
  { {0x8c1b0008,0xe704002b,0xc7b80085,0x16660015}},	//   _קולי, استی, _nađe_, َابَ
  { {0xdb1c00dc,0x96b70054,0xeb9719b2,0xb21b0052}},	//   _merü, њују_, _рис_, nlæt
  { {0xb5fd01a3,0xca750033,0x2292001a,0x3ea00771}},	//   mišl, _суры, tákn_, imit_
  { {0xe1ff19b3,0x9f580077,0xbd9b000a,0x62640030}},	//   gión_, neró_, וספת, sőol
  { {0x9f580089,0x225200dd,0x07a60660,0x25bd0034}},	//   terý_, _blyk_, _ражн, _ffwl_
  { {0xacbb0152,0xdb1c19b4,0xb5da0015,0x26da0046}},	//   _brûl, _heró, _آباء_, ápou_
  { {0xb1140033,0xc5f3000a,0xb5fd0046,0x7c2e0079}},	//   амяш, _כדף_, rnšt, _onbr
  { {0xe1ff0782,0xdb1c19b5,0x5453009e,0x6486002e}},	//   ción_, _berü, _квіт, rðis
  { {0xeeab0036,0xc058005e,0x9f580077,0x9f66001a}},	//   дтак_, тія_, deró_, óuðu_
  { {0x645d0024,0x02a404ab,0x7c2e19b6,0x6dc4004a}},	//   īsie, _крым, _anbr, исуж
  { {0xa5c2002a,0x645d003d,0xb5fd006f,0xcc990099}},	// [2ad0] łówk, ūsie, dišl, евац_
  { {0x3ea019b7,0xfc190015,0x3a3f00da,0x7ae319b8}},	//   amit_, عقاب_, _soup_, ánto
  { {0x3ea010df,0xdb1c0012,0xdb14001a,0xaab40015}},	//   bmit_, _gerü, ðaði, لإنش
  { {0x3ce900bd,0xd7f80011,0xd357000a,0xb21b02de}},	//   prav_, _acă_, כיבי_, mlæs
  { {0x8bb70015,0x09e4005e,0xa3c4000b,0x99d4002b}},	//   _لإزا, роін, ौरा_, شتنا
  { {0xe1ff02c1,0x20110ee0,0xf813002b,0x46f5004a}},	//   xión_, nezi_, شستگ, гчит
  { {0xef120008,0x27e90064,0x2011003f,0xead4124a}},	//   ֶּה_, ğan_, iezi_, _вось
  { {0x27e901e2,0x20110045,0x2bcb000b,0xab8400af}},	//   şan_, hezi_, िरका, _ђурк
  { {0x2a64010f,0x06960029,0xa565002b,0x20110aa5}},	//   _търг, دنية_, دگان, kezi_
  { {0x69d919b9,0x98170087,0x98a40054,0x20110030}},	//   lawe, _جبرا, _виђе, jezi_
  { {0x3ea000f2,0x7bd519ba,0xf2a6029b,0x201119bb}},	//   ymit_, _mezu, лиоп, dezi_
  { {0xe1ff0467,0xb21b0134,0x69d919bc,0xddd60069}},	//   sión_, dlæs, nawe, chyň
  { {0x6486002e,0xd5ae0087,0x4a5a000a,0xa616000a}},	//   rðir, _عفو_, תדרו, _תקנד_
  { {0xdb05002d,0x8936004c,0x9f5802b9,0x69d919bd}},	//   nchó, ארשע_, derò_, hawe
  { {0x2d8f00b8,0x2eb50a61,0x53320004,0x63050015}},	//   ügen_, истс, _гејт, _إوبل
  { {0x229900dc,0x69d919be,0xdb1c0012,0x7e550033}},	//   téke_, jawe, _verü, атуц
  { {0xed5719bf,0x7bd519c0,0x9f580077,0xb21b001a}},	// [2ae0] гот_, _bezu, teró_, rlæt
  { {0xdb1c0014,0x09cc005d,0xd9cc005d,0x3ea00024}},	//   _terü, ार्य, ार्ट, smit_
  { {0x272301e2,0x5f460029,0x8cb0000b,0x60db003d}},	//   _nın_, _إنجل, _अंको, šumt
  { {0x248519c1,0x9f410077,0x7ae2003d,0xdb210030}},	//   holm_, _echó_, ņoto, ötár
  { {0xc7ba0010,0x1ae0000b,0x9f58010d,0xb5fd19c2}},	//   нёй_, _पटकथ, peró_, rišl
  { {0xd9430124,0xddcd005c,0x98730484,0x9d2b000a}},	//   сељи, chał, бліц, _אֵלִ
  { {0xc8e0005d,0x7d160026,0xa634005e,0x69d90647}},	//   _निकट, lwys, инкі, bawe
  { {0x60c4001c,0x58d60015,0x20110045,0xdb05002a}},	//   _otim, _ميرذ, zezi_, achó
  { {0x29560063,0x7d1619c3,0x89db000a,0xb21b01f0}},	//   _съвр, nwys, _רחמי, klær
  { {0xb7b50092,0x3cfb0053,0xebd6000a,0xe6440061}},	//   _hạn, עלינ, נֵ֥י_, ılış
  { {0x2259004a,0x60c40091,0x7d160034,0x5c370447}},	//   вины_, _atim, hwys, אטיב_
  { {0xe4520074,0x2011000c,0x6681002b,0x88c70046}},	//   _گفتگ, wezi_, _ویول, směš
  { {0x61e40176,0xb7b50023,0x8cb0000b,0xa4d401f3}},	//   _ddil, _mạn, _अंगो, _толі
  { {0x61e401e2,0xf593003b,0x7d1600aa,0x60c40125}},	//   _edil, _الهج, dwys, _dtim
  { {0xa91d002c,0x69d9003f,0x03bb000a,0x7d1600aa}},	//   _vyži, yawe, _אצול, ewys
  { {0x02fb000a,0x2449001a,0x1c02000b,0x7d1619c4}},	//   _נלחמ, _rúmi_, र्सल_, fwys
  { {0xdb0500b8,0xe6d1000b,0x2beb0004,0x320902f2}},	// [2af0] schü, _सब्ज, еќен_, _ibay_
  { {0x6bd40029,0x69d91480,0x2bb80015,0x319c000a}},	//   متمر, wawe, هامة_, _אבחנ
  { {0x9f35005e,0x547b004c,0x7bd50085,0x69d919c5}},	//   _тені, עטבו, _vezu, tawe
  { {0x5fbf005d,0x7f3a0053,0xb7b50092,0x7d160026}},	//   ्रकल, _סערו, _cạn, bwys
  { {0xb7b50023,0x80a40086,0x8dda000a,0xe0df02b9}},	//   _dạn, _خمین, _בקרק, nsò_
  { {0xb3460064,0xe800005d,0x628619c6,0xa9680058}},	//   _kaçı, ल्ला_, zoko, دمهم_
  { {0xe739087a,0x91690092,0xa3e8000b,0x628619c7}},	//   тей_, _lừa_, यणन_, yoko
  { {0x8aa419c8,0xb5fd1573,0x24520003,0xb3460061}},	//   _груд, mišk, _râma_, _maçı
  { {0xf1c80089,0xb5fd158a,0x2c6f002a,0xe611002b}},	//   ndář_, lišk, ażde_, مشک_
  { {0xb4650973,0x4465110c,0x62860535,0x0000006a}},	//   ркол, рвов, woko,
  { {0xe29a0001,0x8c1a0008,0xb5fd158a,0x21290509}},	//   као_, דותי, nišk, _arah_
  { {0xe126004a,0x69ac000b,0x7d160034,0xf77000c3}},	//   амми, ुँची, ywys, _عال_
  { {0x8a160008,0x2d8f00b8,0x9548002b,0xd5a3002b}},	//   בחרו_, ügel_, _مشوق_, _الشی
  { {0x9f580084,0x455a0008,0xb5fd0007,0x7019042b}},	//   ferð_, _בכנס, kišk, ліст_
  { {0x9f580084,0xb5fd19c9,0xfec30015,0x8fa60a68}},	//   gerð_, višj, قيَّ, раве
  { {0x201e0007,0x25bf064e,0xb5fd00f0,0x20d6005e}},	//   žti_, ncul_, dišk, _кіос
  { {0xbc660010,0xb21b003c,0xedd30015,0x00e30033}},	// [2b00] авак, plær, زيلد, _джын
  { {0x7d16020a,0xb5fd158a,0x6f660121,0x644319ca}},	//   rwys, fišk, _ввоз, _joni
  { {0xb5fd0007,0xe9da12d2,0x7d1600aa,0x644319cb}},	//   gišk, вке_, swys, _moni
  { {0x539a000a,0x536c004c,0x62870085,0xa92619cc}},	//   דיעו, עכאַ, čkog, идел
  { {0xb5fd0007,0x8277004c,0xd3780085,0x2ba7000b}},	//   aišk, סענע_, maće_, केबा
  { {0xdb1c002e,0xb5fd1573,0x1c02000b,0x8cd6000b}},	//   _ferð, bišk, र्शल_, मीणो
  { {0xdb1c0084,0xd6d703be,0xa089000a,0x475a006b}},	//   _gerð, аты_, נְנִ, ърдя_
  { {0xddcd19cd,0x960a0010,0x963419ce,0xcb37000a}},	//   mnaţ, тэка_, сниц, _דאלי_
  { {0xd90e0086,0xe9440086,0xc9660033,0x9537006b}},	//   _آیت_, _ارزی, _твай, изът_
  { {0xddcd0011,0x656f002d,0xc34a006b,0x644319cf}},	//   onaţ, úcha, вяме_, _coni
  { {0x0bb7013a,0x6f090050,0x84330036,0xfbb7000a}},	//   ילים_, łecz, інює, יפית_
  { {0xe717000a,0x9f58001a,0xf50600f4,0x32671208}},	//   _כחבר_, verð_, _вздо, ртов
  { {0xdfdb010f,0xc6930008,0x50f40342,0x644319d0}},	//   къв_, _ואף_, озят, _foni
  { {0xd48f0036,0x91690092,0x92030024,0x64a30033}},	//   _єр_, _vừa_, _šādo, _дача
  { {0xaf340086,0xb05b00f2,0xe0df062b,0x749b000a}},	//   يرفت, npäi, ssò_, _שיופ
  { {0xb5fd1573,0x9757000a,0x433b000a,0x443e0123}},	//   višk, בילו_, _יעוב, ljt_
  { {0x8bb70029,0xdbd1002e,0x656d002c,0x212900bd}},	// [2b10] لإضا, _býðu, _ľahk, _urah_
  { {0xb5fd00df,0xa8020061,0x3138004f,0x60640058}},	//   tišk, çıla, _כרחך_, _وهيل
  { {0xf2d300b2,0x2d87005c,0x2b470045,0x307c000a}},	//   ַעס_, łne_, ânc_, _באזנ
  { {0xdb1c09f0,0xb5fd19d1,0xd9990015,0xd337000a}},	//   _verð, rišk, هنات_, ירבה_
  { {0xb5fd0007,0xfe36000a,0xf1b4000a,0x91f8000a}},	//   sišk, _הארך_, קסס_, שמדו_
  { {0x893406e4,0x31580053,0x1ed8002b,0xe1ff0030}},	//   تعما, סיגן_, _حبیب_, fiók_
  { {0x9b45002b,0xe1ff0030,0xd7f806f6,0x4faa000a}},	//   _انزو, giók_, руч_, ְׁפְ
  { {0x645a0e95,0xceb4000a,0x7e6d19d2,0xd706004a}},	//   ehti, חיק_, niap, ёные_
  { {0x644319d3,0xd5490080,0x6d4d013c,0x25bf0045}},	//   _poni, уппе_, nyaa, rcul_
  { {0x645a19d4,0x628d003f,0x25bf19d5,0x7996002a}},	//   ghti, _akao, scul_, żywc
  { {0xd795003b,0xe1ff00dc,0xf1a900a3,0xf7850015}},	//   _الاخ, ciók_, _נס_, _الضَ
  { {0xc04919d6,0x443e0085,0x425600c9,0xb5fd0091}},	//   _אז_, ajt_, стот, kiši
  { {0xa979004c,0xd3780085,0x644319d7,0x7e6d19d8}},	//   ראָכ, vaće_, _toni, diap
  { {0x46130086,0x645a19d9,0x10a6107f,0x305500af}},	//   _دوچر, chti, сигн, ођст
  { {0x8c3b0012,0x7d0f0030,0xd3780085,0xddc400d4}},	//   _fußz, _apcs, taće_, ghiş
  { {0x3392002b,0x92650015,0x7e6d19da,0x0000006a}},	//   _عليز, _وديم, giap,
  { {0x80b2000b,0xe1ff0030,0xd3780085,0x6da319db}},	// [2b20] _इंटे, ziók_, raće_, зита
  { {0x3ce019dc,0x8f76004e,0x0000006a,0x0000006a}},	//   rsiv_, _гумі,   ,
  { {0xeafa0086,0x6d4d013c,0x60a50015,0xeab20015}},	//   طرات_, ayaa, _بإيق, سعا_
  { {0xeb970a2c,0xddcd0011,0xaa65005e,0x99dd006f}},	//   щих_, rnaţ, отік, _poňa
  { {0x2d840152,0x645a00f2,0xdd920002,0x799b002a}},	//   _âme_, yhti, _روس_, _czuw
  { {0x98730033,0xa91d0091,0xb9000065,0x99dd016d}},	//   пліц, _ryžt, _दब_, _voňa
  { {0x39520007,0xf743000d,0x23db000b,0x7bdb000a}},	//   šys_, зејо, _मज़द, _תקלו
  { {0xceb30008,0xdb1c00c0,0xbb77000a,0xddcd0085}},	//   היה_, _berö, _העלו_, onaš
  { {0xb05b00f2,0x645d0024,0xca37000a,0xf7ea0015}},	//   späi, īsin, _פנמה_, _مرضى_
  { {0x14b7003b,0xb05b00f2,0xb8960029,0x7bde015a}},	//   حديث_, ppäi, _الطع, napu
  { {0x53980036,0x9f450064,0xe21502bf,0xe9ff0016}},	//   рвня_, ülü_, омны, _xoắn_
  { {0x91690092,0x4b7b01ac,0x68e219dd,0xf36302bf}},	//   _nữa_, ראטו, osod, ятын
  { {0xc05b0036,0x5a9b0053,0x65960086,0x60d60026}},	//   гів_, טשטא, _اجار, _cwym
  { {0xd3ba0036,0xdb1c001a,0x7d0400d5,0x60d60034}},	//   _суді_, _afrí, dtis, _dwym
  { {0x7e6d01c2,0x91690016,0xe3b80061,0x6fda0065}},	//   tiap, _bữa_, ndım_, _बजरं
  { {0x33770008,0x6377000a,0x798d002a,0x7d0419de}},	//   _לתוך_, _לגוף_, żawi, ftis
  { {0x1dc40015,0x7d040030,0x60d60034,0xfe700015}},	// [2b30] سْلِ, gtis, _gwym, ردف_
  { {0x7e6d0375,0x859b000a,0xdb5b0033,0xb5fd19df}},	//   siap, רשמו, люе_, riši
  { {0xfb150015,0xd011002b,0x6d4d01c2,0x68e20034}},	//   تواج, _فلک_, syaa, esod
  { {0x02fb0053,0xb5fd02c6,0x7bde008c,0xdd910058}},	//   רלאמ, piši, aapu, _يود_
  { {0xe9d8008f,0x645802c1,0xab620064,0x127c0053}},	//   скі_, _olvi, _çünk, נאדע
  { {0x40ec000a,0xe9d9002a,0x68290030,0xa6c90fb6}},	//   אַהֲ, _weź_, ködő, алка_
  { {0x70b5005d,0xdc9a000a,0xf742006b,0x07a21305}},	//   ंदुल, _כישל, дещо, машн
  { {0x245b038d,0x7996005c,0xb6580010,0xdb1c0026}},	//   _même_, żywa, йшых_, _ffrâ
  { {0x69db0026,0xe1ff06e7,0x6f1b002a,0xe4590719}},	//   _ieue, ciói_, łuch, ижи_
  { {0xdb1c00b8,0xad27008b,0x3cdb000b,0x1309056d}},	//   _verö, рвiс, खीये_, аной_
  { {0x37c40015,0xe1ff002a,0x60d6002a,0xd6390033}},	//   _رينف, niów_, _swym, _вялі_
  { {0x7de60014,0xdb1c0064,0x7d0419e0,0xa3b5000b}},	//   _késő, _terö, ytis, _झलक_
  { {0xef1f002a,0x7bde19e1,0x98bd002a,0x69db0144}},	//   óżne_, yapu, tywę_, _meue
  { {0x9f580152,0x68e4002d,0x88ba004c,0x7ae2003d}},	//   lgré_, áidi, יזשי, ņoti
  { {0xe29a19e2,0xc0590010,0x1eaa0015,0xdb1c016e}},	//   _как_, сіў_, لاري_, _jerô
  { {0x69db018b,0x4e060010,0xe1ff005c,0x7d040ae5}},	//   _neue, ўзаб, diów_, ttis
  { {0xe0d2003b,0x76590026,0x02030010,0x0eb6000b}},	// [2b40] _غزة_, _mlwy, _ўзьн, _आंकड
  { {0x76590176,0x7c960010,0xe058002b,0xe3b80061}},	//   _llwy, ірац, _ایست_, ydım_
  { {0xda660036,0x3bd50080,0x9f060031,0x4dd60015}},	//   овжи, яютс, _بوجو, _وتحس
  { {0x201819e3,0x7ff60086,0x7ae30045,0x386e0034}},	//   leri_, _اسکا, ânta, wifr_
  { {0xcaa50029,0xb9930015,0x7bde015a,0x69db0144}},	//   أصلي, ولمب, papu, _deue
  { {0x752900dc,0xab2a18a7,0x76590034,0x68ed0030}},	//   dvez, _кога_, _alwy, áada
  { {0xf8bf0298,0x76590026,0x69db19e4,0x752900dc}},	//   _één_, _blwy, _feue, evez
  { {0xe3b801e2,0x76590026,0x7bdc19e5,0x9f450003}},	//   rdım_, _clwy, _heru, ûlé_
  { {0x20180064,0x7bdc0375,0x28160015,0xdb21008c}},	//   keri_, _keru, _وورس, ätös
  { {0x94760029,0xb05b00f2,0x07a60033,0x97360015}},	//   تدعا, npät, _дазн, _وعاص
  { {0x76590176,0x42550029,0xdb0500b8,0x7bdc013c}},	//   _flwy, كندر, schö, _meru
  { {0xbddb0152,0x75290844,0x644100d9,0x76590034}},	//   _poèm, bvez, ajli, _glwy
  { {0x290600f2,0xe3b80064,0x85760015,0xddcd0046}},	//   ntoa_, ndık_, _بدائ, chař
  { {0x20180375,0xe3af002b,0x6fd9002a,0x3a2419e6}},	//   geri_, عری_, dźcó, _lamp_
  { {0xcddb0180,0xff040256,0x2906008c,0x6abc01c2}},	//   иња_, мятн, htoa_, _nurf
  { {0x7bdc19e7,0xb5fd0091,0x0000006a,0x0000006a}},	//   _aeru, sišv,   ,
  { {0x8cf50010,0x7bdc19e8,0x201819e9,0xdcfd003d}},	// [2b50] язац, _beru, beri_, _izsī
  { {0x7bdc0011,0x20180011,0xb5fd06cf,0x69db027d}},	//   _ceru, ceri_, lišt, _seue
  { {0x20010e18,0x2906008c,0x7bdc19ea,0x6abc01f9}},	//   _ichi_, etoa_, _deru, _curf
  { {0xd9590010,0xe1ff005c,0x6abc059b,0x3a2407fc}},	//   йшлі_, riów_, _durf, _camp_
  { {0xcfab0086,0x3ea90197,0xd91b004a,0x69db0144}},	//   _حاکم_, mmat_, рье_, _veue
  { {0xd8220080,0x3ea919eb,0xeafb002b,0xb5fd00bc}},	//   едши, lmat_, _پرست_, hišt
  { {0xf6510029,0x7bc5002d,0x76590034,0x7d190061}},	//   فئة_, mchu, _plwy, şası
  { {0xe9df09f0,0x3a240026,0x38c90086,0xb5fd19ec}},	//   _þú_, _gamp_, _هائی_, jišt
  { {0x5a340010,0x1a680086,0x20010011,0xb5fd06cf}},	//   _ўнут, _بینی_, _ochi_, dišt
  { {0x2001000c,0x75290014,0xfdb8000b,0x3ea90049}},	//   _nchi_, rvez, _अल्फ, hmat_
  { {0x7bc500b8,0xa4480015,0x8bd6000a,0xb4640015}},	//   ichu, تشيك_, הותו_, بديه
  { {0x7bc5002d,0xb05b002c,0xc243005e,0x95c40015}},	//   hchu, zpät, енюк, _قيمه
  { {0x55ba0008,0x3ea900d9,0x2ef80012,0xd3780085}},	//   _המנו, dmat_, wurf_, raća_
  { {0x394000f2,0x70560015,0xd00a0054,0x9fc70054}},	//   äisi_, أنسا, љеве_, згра_
  { {0x43750053,0x602f0007,0xe800000b,0xe456004c}},	//   _מײַן_, dėmė, ल्टा_, _מיסט_
  { {0x75f60061,0x7bdc06a2,0xf1bf19ed,0xe3b80061}},	//   müzü, _seru, ldán_, ydık_
  { {0x0d9a0010,0x8d660010,0x51fb0008,0xdd920115}},	// [2b60] ствы_, чвае, _ההפצ, روط_
  { {0x7bc5002d,0xee3f006f,0x8fa608f7,0xf1bf0030}},	//   gchu, _chýb_, _напе, ndán_
  { {0xddc4005c,0x68ed00dc,0x501b000a,0x6f0c0045}},	//   oniż, áadn, _פוטו, încă
  { {0x82d60053,0x290600f2,0xda650031,0x7bc5002a}},	//   פונג_, ttoa_, واني, achu
  { {0xba290015,0xb05b008c,0x7bdc19ee,0xd7e6005e}},	//   تسلم_, mpär, _teru, пійо
  { {0x6e2600b6,0x7c5a0029,0x290600f2,0xd90d0086}},	//   _hakb, _السر_, rtoa_, شیم_
  { {0x2906022d,0xdc370053,0xc66a0080,0xdb830b1e}},	//   stoa_, _צאלט_, йшие_, _згри
  { {0xb8660086,0x6e26005c,0xe6630036,0x4b7b0008}},	//   _کارو, _jakb, етьо, _האלו
  { {0xc7b60015,0x6e3b000a,0x6e2619ef,0xa7b60099}},	//   _فصاع, מתקד, _makb, _есеј
  { {0x6e2619f0,0x2913009a,0x224901f9,0x8386066a}},	//   _lakb, _سومآ, _soak_, зыме
  { {0xb5fd04c6,0xe9ff0016,0xb05b0072,0x68ec0073}},	//   tišt, _hoạn_, kpär, žodį
  { {0x76bb0008,0x6e2601c2,0x22440015,0x54e60058}},	//   _המאפ, _nakb, ّنَّ, _فستق
  { {0xb5fd010b,0x321919f1,0x9f51001a,0x61fd19f2}},	//   rišt, resy_, _íbúa_, rgsl
  { {0xb97b000a,0xf0440138,0xa2ca04c5,0x0000006a}},	//   מרכז, нэсо, _луиз_,
  { {0x9f340036,0xb5fd0089,0xe9ff0092,0x987b0053}},	//   нері, pišt, _loạn_, צאלט
  { {0x5f94059c,0x5eb4086e,0x7bc50034,0x644a086c}},	//   хист, ейст, wchu, _hofi
  { {0x628f002c,0x998f002a,0x8e740015,0x3ea919f3}},	// [2b70] moco, zegł_, رافض, rmat_
  { {0x7bc519f4,0xe5530030,0xb05b0a64,0x5ba702b0}},	//   uchu, éséé, rpäs, през
  { {0xe7a50024,0x7bc519f5,0xe1ff0030,0x7b670f82}},	//   ādīš, rchu, ogó_, чтае
  { {0xe1ff19f6,0x7bc519f7,0x68ed00dc,0xd1080086}},	//   ciót_, schu, áado, _بقیه_
  { {0xa9540191,0x5a340033,0x08c4005e,0x9a880015}},	//   нкці, энцт, ебін, أَنْ_
  { {0xf7700074,0x60cd003f,0x644a0026,0x75f60061}},	//   گاه_, _mtam, _nofi, yüzü
  { {0xab950036,0xe1ff0537,0x572400e6,0xe7080015}},	//   _циві, chóg_, فريق, كتين_
  { {0x60cd00f2,0xb8820030,0xf7700021,0x2a7f1839}},	//   _otam, áírj, داه_, _ujub_
  { {0x68e4002f,0xd5e80015,0xa3f50033,0x80b9000b}},	//   áidt, سعين_, мянш, _एंगे
  { {0x644a0176,0x61ed19f8,0xd928000a,0xe1ff0030}},	//   _cofi, _adal, _מֵעָ, ziót_
  { {0x5884008f,0x60cd0064,0x442b0046,0x67210085}},	//   _чыта, _atam, ěc_, _uslj
  { {0x442b002a,0xd7f80045,0xaad50065,0xb5fd016d}},	//   śc_, _umăr_, डीएक, rišs
  { {0x98a40011,0x61ed0026,0x2bfe005d,0xb1430342}},	//   _urmă_, _ddal, _लालू_, внял
  { {0x644a0026,0x94ba000a,0xf3f5002b,0x7c270e1f}},	//   _gofi, _ומסת, _آتشک, _najr
  { {0x92e8003b,0xcec40089,0x28dd000b,0xdee6005e}},	//   _فريق_, daří_, नीति, ьови
  { {0x93240015,0x644a0bbd,0xed5a0fea,0x442719f9}},	//   _أرون, _zofi, ооб_, _han_
  { {0xfce3005f,0x3cf5005d,0x312302bf,0x6e260079}},	// [2b80] кото, एंगे_, _адыг, _vakb
  { {0xb05b0020,0x61ed1837,0x2ca7070c,0x442719fa}},	//   spär, _zdal, дкуп_, _jan_
  { {0x661b00f2,0xe9ff0092,0x20570008,0xe1ff19fb}},	//   keuk, _soạn_, _חייל_, ciós_
  { {0xe1ff005c,0x92080024,0x442719fc,0x6298016e}},	//   chód_, _frāž, _lan_, _êxod
  { {0x09360015,0x09e308ad,0xddc40091,0x5886055f}},	//   براج, точн, snių, мыка
  { {0xd9430054,0x7afa0123,0x442719fd,0xe1ff19fe}},	//   тељи, _åtto, _nan_, zgó_
  { {0xc7b00015,0xe73702d9,0x644a19ff,0x17f70058}},	//   دّث_, деј_, _rofi, ذروة_
  { {0x442715d8,0x7c27002a,0x68e40125,0x764b0034}},	//   _aan_, _zajr, áids, _cogy
  { {0xd7cf005d,0x44271a00,0xc6a3006b,0x644a0045}},	//   _स्वच, _ban_, ърши, _pofi
  { {0x44270388,0x628f002a,0xddd6006f,0xb7160058}},	//   _can_, woco, skyň, _يباش
  { {0x4427013c,0x67bb000a,0xd3700015,0x77bb000a}},	//   _dan_, _ומבק, اهج_, _ומבח
  { {0x92580080,0x4427002d,0x926b005e,0xc7b80085}},	//   дают_, _ean_, ірна_, _nađi_
  { {0x84460029,0x44271a01,0xe1ff19b8,0x628f1a02}},	//   _يختل, _fan_, rgó_, roco
  { {0xa3df014e,0x44271a03,0xd4c50015,0x628f1a04}},	//   तरण_, _gan_, _أغني, soco
  { {0x764b00e8,0x626b0089,0xc7b1000a,0x33fb000a}},	//   _yogy, dřov, ָ֑ם_, _והונ
  { {0x2cb8002d,0x6db50baf,0x61ed1a05,0xe1ff0144}},	//   _aird_, ейбу, _udal, riós_
  { {0xce940063,0x2cb81a06,0xddcd002a,0x60cd1a07}},	// [2b90] татъ, _bird_, tkał, _utam
  { {0x82350086,0x69c90079,0x22990030,0x2ee50052}},	//   _آرژا, _sfee, déki_, álfs_
  { {0xe945002b,0x5fbe000b,0x64940144,0x68e91a08}},	//   کرای, ्डरल, làis, _sved
  { {0xdb0e00dc,0xdd910086,0x539b000a,0xddcd002a}},	//   áján, _موج_, חיבו, skał
  { {0xcce7003b,0xe6ed002c,0xcdf6000a,0x6bd70058}},	//   _تسجي, _väčš, _אמרי_, _يتسر
  { {0xa1580008,0x07a505b1,0xc7a5030c,0xf1bf013f}},	//   ובדה_, налн, нилк, ddám_
  { {0x44271a09,0x2bae005d,0xf7730018,0x3eb90546}},	//   _ran_, झेदा, خاش_, _kist_
  { {0x19950010,0x2d99008c,0x44271a0a,0x3eb9087b}},	//   _забя, _kyse_, _san_, _jist_
  { {0xe5790080,0x68e90107,0xeab00031,0x442711a3}},	//   язи_, _uved, _ضعف_, _pan_
  { {0x9cd6000a,0x3eb91a0b,0xe3b1002b,0x285b0015}},	//   עותה_, _list_, ُرد_, _بؤرة_
  { {0x87070086,0x44271a0c,0xe29a1a0d,0xd6c3002b}},	//   _زبال, _van_, зан_, _شمشی
  { {0x44271a0e,0x23780030,0x3eb91a0f,0x0000006a}},	//   _wan_, úrja_, _nist_,
  { {0xdb1c00c0,0xc19a005e,0x35f8002b,0x44271a10}},	//   _ifrå, ятої_, _زرند_, _tan_
  { {0x3204002a,0xf8a70015,0xd576004f,0xa52400ce}},	//   żmy_, طة_, _אתנה_, _шмід
  { {0x68ed00dc,0x322900f2,0x3eb900b8,0x66c70061}},	//   áadj, ötyä_, _bist_, _yıka
  { {0x6cd60015,0xf772004c,0x3eb9082b,0x0000006a}},	//   فقرا, אקל_, _cist_,
  { {0x626b0089,0x127b004c,0x63a6002a,0xc27b000a}},	// [2ba0] třov, _מאקע, ękne, _מרקי
  { {0x4f261a11,0xf2e6002b,0x3eb90079,0x61e61a12}},	//   _здоб, _تکیه_, _eist_, lakl
  { {0x5fdb0008,0x80890029,0x2be1000b,0xeed6000a}},	//   _מחיק, _تضيف_, _फ़रा, _אֵ֚ת_
  { {0x2cb80bcf,0xb346001c,0xc332000f,0x88e609ef}},	//   _wird_, laçõ, טוב_, ежде
  { {0xa3df005d,0x9269004c,0x626b005a,0x0000006a}},	//   तरा_, ובאַ_, přov,
  { {0xeee70074,0x317b0053,0x20c60092,0xb346001c}},	//   _تغیی, האנד, _môi_, naçõ
  { {0x20c60092,0xf09300a3,0xcb94002b,0x8ba3004a}},	//   _lôi_, אנג_, _شهرک, _бирж
  { {0x95ca0572,0x35460245,0x963404d7,0x0000006a}},	//   чука_, ехов, тниц,
  { {0xd4060036,0xea77000a,0xddcd0045,0x06e0000b}},	//   няни, _נגמר_, liaţ, _गौरव_
  { {0x5454066c,0xdbdf001a,0x62870085,0xf1bf0046}},	//   твот, níði, čkom, rdám_
  { {0xd2510087,0xd706005e,0x66c70061,0xddcd0045}},	//   لند_, _їзди, _tıka, niaţ
  { {0xa75b0008,0x20c60016,0x375b000a,0x78ba0030}},	//   _מדבר, _bôi_, _מכבד, _hitv
  { {0xf1bf00dc,0xf44001f3,0x20c60016,0x3eb91a13}},	//   ldák_, _волi_, _côi_, _rist_
  { {0xb346001c,0x853b0008,0x200517f7,0x3eb902d2}},	//   gaçõ, _מגדי, üli_, _sist_
  { {0xddcd002a,0xdb210061,0x61f40123,0x833300c3}},	//   ykań, ötür, ådlö, _مريض
  { {0x61e60064,0xddcd0011,0x439b000a,0x639b000a}},	//   cakl, diaţ, _מבוג, _מסונ
  { {0x442c0176,0x3f9e002e,0x3eb90293,0xdfd1002b}},	// [2bb0] odd_, ýtur_, _vist_, _پيج_
  { {0xb346001c,0x2bbb0029,0x3eb90111,0x7e640061}},	//   caçõ, ساطة_, _wist_, ahip
  { {0x442c1878,0x2d9900dd,0x73a9000a,0x6e950015}},	//   idd_, _wyse_, ֵינֵ, _للدا
  { {0x7d090045,0xbdf9006e,0x7e641a14,0x78ba0073}},	//   _ţesu, _تفحص_, chip, _aitv
  { {0x6e3d00b8,0x88c80036,0x7afe1a15,0x9cb50015}},	//   _insb, елів_, aupt, _لمحت
  { {0xa3bc005d,0x645a0079,0x61e61a16,0x6eaf0065}},	//   _अलग_, jkti, zakl, ंगवु
  { {0xddcd0011,0xba770015,0x7d0d1a17,0x61e6007f}},	//   ciaţ, _كارت, ltas, yakl
  { {0x442c0176,0xb346001c,0x7f3c0053,0x99d70021}},	//   edd_, zaçõ, לעוו, _سترا
  { {0x0568000d,0xc4850142,0x2c6400c0,0xe8e00016}},	//   ејќи_, клик, _född_, _đệm_
  { {0xcdaa0053,0x69d90012,0x7d0d118c,0x629d1a18}},	//   ויפֿ, lbwe, itas, elso
  { {0xb904005d,0xb346001c,0x7d0d1a19,0x20c60016}},	//   भी_, vaçõ, htas, _sôi_
  { {0x27e7002f,0x442c1a1a,0x45d505c4,0x7d0d1a1b}},	//   lann_, add_, _родс, ktas
  { {0xb346001c,0x320c005c,0x68ed00dc,0x69d900b8}},	//   taçõ, ędy_, áadh, ibwe
  { {0x7d0d00fb,0x27e7002f,0xdfd20029,0xc7ce0092}},	//   dtas, nann_, شير_, hống_
  { {0xb34603af,0x24960029,0x5f06006b,0xa284002b}},	//   raçõ, _جنود_, ъзва, _میدو
  { {0x20c600a7,0xdbc90020,0xb346001c,0x7996002a}},	//   _tôi_, _mõõd, saçõ, żywi
  { {0x27e7002e,0xb346016e,0xdbdf001a,0xf1bf0030}},	// [2bc0] kann_, paçõ, tíði, zdák_
  { {0xbc630010,0x7e641a1c,0x61e41a1d,0xe3b80061}},	//   авук, ship, _heil, mdır_
  { {0xe3b80064,0xbddb0291,0x78ba001a,0xdbdf001a}},	//   ldır_, _poèt, _ritv, ríði
  { {0xddcd0011,0x6da60029,0x60c4003f,0x53360053}},	//   riaţ, _لمجم, _kuim, כנען_
  { {0x442c0b7c,0xe3b80064,0x61e41a1e,0x27e70123}},	//   ydd_, ndır_, _meil, fann_
  { {0x27e71a1f,0xcee90086,0xddcd0011,0x60c4003f}},	//   gann_, _ترین_, piaţ, _muim
  { {0xa7fc0064,0x60c4002d,0x91830092,0x9c17000a}},	//   _alıc, _luim, iếp_, _שחלק_
  { {0xdb1c002f,0x442c0176,0x61e41a20,0xb7bc003d}},	//   _ngré, wdd_, _neil, _maģi
  { {0x60c40007,0x0906049d,0x7e9b000a,0xd3780085}},	//   _nuim, _шпан, וסקו, maći_
  { {0x27e7002d,0xdb1c0152,0x78ba00f6,0xe56f0015}},	//   cann_, _agré, _uitv, غطي_
  { {0x442c0176,0x7d0d00dc,0xa2b50063,0x61e41a21}},	//   rdd_, ztas, лбоч, _beil
  { {0xd378016f,0x7d0d0671,0x442a00bc,0x61e4124e}},	//   naći_, ytas, žb_, _ceil
  { {0x60c4002d,0x4613002b,0x83f80004,0x25a00125}},	//   _cuim, _خونر, _зелс_, _áil_
  { {0x2bfe014e,0xa2ca000b,0x250b002b,0x60c40547}},	//   _लागू_, _संप्, _زرهی_, _duim
  { {0x61e41a22,0x260f000b,0xa0740033,0xcebb0054}},	//   _feil, थ्वी_, рыўш, дља_
  { {0x01650015,0x68ed0085,0x7d0d1a23,0x60c40077}},	//   _مُعَ, šadi, ttas, _fuim
  { {0x7d0d1a24,0x60c41306,0xf1c40069,0x6e2d1a25}},	// [2bd0] utas, _guim, ášť_, rdab
  { {0x7d0d1a26,0x61e4059b,0xbbdd000b,0x3f840061}},	//   rtas, _zeil, यरेक, ğmur_
  { {0xddc6005c,0xda350010,0xbae40015,0xd9f915b8}},	//   _dokł, лежы, لكلي, енец_
  { {0x27e700b8,0x99d40002,0xa2ca000b,0x6a94005e}},	//   wann_, لتها, _संन्, аріє
  { {0xe9d8008f,0xee3f002c,0xf1bf0125,0x6ce40033}},	//   ткі_, _iný_, meád_, _вісе
  { {0x27e7002d,0x6ac50015,0xd70905ab,0x66e502ed}},	//   uann_, _مقسم, енке_, гока
  { {0xe3b80064,0xd7ee0029,0xd8740115,0x9b890015}},	//   zdır_, سكي_, جانب, _أنزل_
  { {0xddcd0048,0xe3b80064,0x68f60091,0x98e50015}},	//   skaņ, ydır_, šyda, _مكرو
  { {0x27e7002e,0xa5d9002b,0x765b0061,0x66240015}},	//   pann_, وبکر_, rkuy, شريك
  { {0x656900b8,0x60c40161,0x61e41a27,0xbbe1000b}},	//   rzeh, _ruim, _seil, _फ़ोक
  { {0x656900dc,0x60c41a28,0xbbe1000b,0x8704013e}},	//   szeh, _suim, _फ़ैक, _вяче
  { {0xa75a004c,0xeb92000a,0x52860015,0x216a02ed}},	//   _אדער, מָר_, الحك, еими_
  { {0x4a5a0008,0x61e41a29,0x60c41a2a,0xdd0001ec}},	//   גדרו, _veil, _quim, ītīg
  { {0xe3b801e2,0x04590015,0x61e41a2b,0x99dd0046}},	//   rdır_, _سلعة_, _weil, _koňs
  { {0x9975005c,0x61e41a2c,0xc29a004a,0x6f630004}},	//   nęło_, _teil, _птиц_, бврз
  { {0xa2060e4d,0x6fd4000b,0xd356000a,0x7afa0804}},	//   _спид, _ब्रू, _תיקי_, _åtti
  { {0x0eb9044e,0x66c70064,0xddc6005c,0x4c8616b0}},	// [2be0] туры_, _sıkl, _pokł, глав
  { {0x91bb000a,0xdde3003d,0x5d130058,0x0000006a}},	//   _אמפי, ārša, إِلا,
  { {0x9975002a,0xaae60015,0xfaa61a2d,0x26c5026a}},	//   jęło_, اسطو, гажо, _nulo_
  { {0x2cb00007,0x6f790008,0x1efb0053,0x3ce8021e}},	//   _žodį_, _יְרו, _אלטע, _चौथे_
  { {0xf9920029,0x127b0053,0x08f70015,0xed5700eb}},	//   حبا_, עאנע, هروب_, _боя_
  { {0x66c70482,0xb7ca0015,0x3ea01a2e,0xa92804b2}},	//   _tıkl, ربتك_, llit_, južš
  { {0x3c630342,0x5c730033,0xcb6a0b1e,0x6b661a2f}},	//   _укрг, _улёт, _џабе_, _сква
  { {0x7c2e1a30,0x44f4058f,0x26c502f2,0x3ea001f9}},	//   _habr, апис, _dulo_, nlit_
  { {0x5e570053,0xca750010,0x3e7f00f2,0xdebb004c}},	//   טיקע_, _туры, lätä_, עמפל
  { {0xd91b0053,0x24520011,0xa98b000f,0x6fd4000b}},	//   _אומל, _câmp_, _אָבִ, _ब्लू
  { {0x68ed00dc,0x36060031,0x5c97004c,0x66c70061}},	//   áadv, _مواف, רכיע_, _yıkm
  { {0x21b50191,0x0bb70008,0xa295022a,0x4b37004c}},	//   ийня, טלים_, рамі, ארטל_
  { {0x667b0053,0x463b0053,0xe6930015,0x067b015b}},	//   _אטאק, _רעדע, _الند, _אנאל
  { {0x3e670020,0x3e7f008c,0x53340129,0x7c2e1a31}},	//   _mõte_, kätä_, _вект, _nabr
  { {0xdb1c0026,0x316b005c,0xe7f7000b,0x23270054}},	//   _sgrî, szcz_, ीलता_, _боји_
  { {0x442e0026,0xf777004c,0x3ea01a32,0xddcd1a33}},	//   _haf_, אעלי_, glit_, snaž
  { {0x3cee014e,0x9f430089,0xdbdf002e,0x21290509}},	// [2bf0] ेंगे_, mají_, _bíðu, _usah_
  { {0x9f430089,0x8c440001,0x93bc0045,0x3ea01547}},	//   lají_, беђе, bdăt, alit_
  { {0xbb840029,0xb9c50015,0xb09c004c,0xfbd00021}},	//   ملكي, لقضي, _איזר, ستل_
  { {0x9f430089,0xda670021,0xe37b004c,0x3ea01a34}},	//   nají_, دائي, עראר, clit_
  { {0xd7c9002b,0x3208000a,0x7c2e1a35,0xba22005e}},	//   نوشه_, א֖וּ_, _fabr, ідшк
  { {0x9f430089,0x3cfa000a,0xfd96000a,0x2c14000b}},	//   hají_, _בלשנ, _כדרך_, न्दू_
  { {0x36690cb9,0x9f430089,0x00580008,0xf7710070}},	//   како_, kají_, רשות_, غات_
  { {0xbb84003b,0x7ae30011,0x7c2e06ca,0x0000006a}},	//   _الفي, ântu, _zabr,
  { {0x9f430089,0x4975006b,0xa4d60054,0x98b90099}},	//   dají_, _тлас, адњу_, _алат_
  { {0x99540001,0x26c5008c,0x94050015,0x5d48000a}},	//   _укуц, _tulo_, جوده, רָהּ_
  { {0x53a5000d,0xa564002b,0x52aa0054,0x3ea0008c}},	//   ранб, لدین, квом_, ylit_
  { {0xcb120008,0x67b80115,0x673c0030,0x2c6402dc}},	//   חלט_, _صالح_, _árja, _möda_
  { {0x9405002b,0x4103006b,0x8352002b,0xd3780085}},	//   _نوشه, озяв, مپیا, daću_
  { {0x05a80036,0xb4fa0008,0xad9b002d,0x14190015}},	//   _свій_, _יפני, _gcúi, _شيعة_
  { {0xdee60a6c,0x9e760054,0x3f9e001a,0xd47a000a}},	//   роби, аћај, ætu_, _באסל
  { {0xdbdf0084,0x6e2f0016,0xdb1c0034,0x7c2e1a36}},	//   _síðu, _cacb, _sgrï, _sabr

  { {0x3ea00084,0x6bd60029,0x7c2e1a37,0x9cb60015}},	// [2c00] rlit_, لتار, _pabr, لمرت
  { {0xa7fc01e2,0x6286006f,0x113b000a,0x3ea01a38}},	//   _alın, lnko, _יתפל, slit_
  { {0xf1a9002b,0x6ffb000a,0x62870d70,0x3ea01a39}},	//   _لایه_, _בפיג, čkov, plit_
  { {0x3e7f00f2,0x2c6400c0,0xcdaa002b,0xeb971a3a}},	//   rätä_, _döda_, _لهجه_, ших_
  { {0x3e7f022d,0x93bc0011,0xa3e8000b,0x67d40004}},	//   sätä_, ndăr, बरम_, болу
  { {0x7d041a3b,0x987302e1,0x6e241a3c,0x2c640123}},	//   muis, оліц, leib, _föda_
  { {0x8c1b0008,0xe0b70008,0x7d041024,0xd6cf0342}},	//   _שולי, בלסט_, luis, ют_
  { {0x95d70063,0x89d70015,0x442e1a3d,0x98560535}},	//   адът_, _نوفر_, _saf_, dłą_
  { {0x9f430089,0x78b1002e,0x68ed0030,0xf9fb000a}},	//   vají_, ákvæ, áadt, _שהממ
  { {0xb8060074,0xb7960001,0x6e2400b8,0x442e01c2}},	//   _خبره, _крећ, heib, _qaf_
  { {0x9f430089,0x1c0b000b,0x63a6002a,0x43941a3e}},	//   tají_, स्टल_, ękno, санс
  { {0x877b000a,0x7d041a3f,0x62860595,0x6e240030}},	//   _באבי, kuis, gnko, jeib
  { {0x61f60026,0x5ab70053,0x4fc700a4,0x7d041986}},	//   _ddyl, ילטע_, исва, juis
  { {0x7d041a40,0x251b000a,0x0377002b,0xdb1c00be}},	//   duis, _סווא, احیت_, _agrí
  { {0xf0b40036,0x1df904ab,0xf7d7000a,0x6aa2001a}},	//   ійсь, левы_, שולש_, klof
  { {0x2c6400c0,0xdce60064,0xcdd80054,0x539b000a}},	//   _röda_, _aykı, ињу_, _שיהו
  { {0xd9040086,0xa2ca005d,0xebc70001,0xd5b3000a}},	// [2c10] _تی_, _सूत्, аљен, ַׁע_
  { {0x38a9006f,0x8bd80bbb,0xc19c004f,0x2292005a}},	//   kúra_, имус_, _בשחי, dáky_
  { {0xeb090029,0x7d04008c,0xca15006b,0x6e950920}},	//   اقصى_, auis, йджъ, _гину
  { {0xe8f5003b,0x7d041a41,0x3a98005e,0x6f010144}},	//   مستخ, buis, атію_, àlcu
  { {0x3cfe005d,0xa9c40033,0x4238004c,0xb9270da4}},	//   _लिये_, ісцк, ינאל_, рфей
  { {0xed56000a,0x5c040033,0xf1bf0030,0x17150015}},	//   _הבשר_, _мяса, ldás_, مذبح
  { {0xe7080029,0x9aa5002b,0x6286002a,0xda3508f0}},	//   لتين_, _همسو, ynko, _левы
  { {0xcb120008,0x7c251a42,0x0f58000a,0x0a940033}},	//   _מלל_, lehr, שיהם_, _дасю
  { {0x95550015,0xd8420046,0x959908f0,0xaa5800af}},	//   إخبا, áčí_, ытку_, _титу_
  { {0xb465005f,0x8af9000a,0x6e240012,0xe80e000b}},	//   скол, ְהָי, zeib, _साया_
  { {0x8c1a0008,0x36d4005e,0x60d61a43,0x6e240030}},	//   אותי, _дохр, _stym, yeib
  { {0x9980002c,0xca7a004c,0xd24f0015,0x62861a44}},	//   žiť_, ָנשט, ّنَ_, unko
  { {0xf6520008,0x7c2500b8,0x9856002a,0xd5480040}},	//   _מצא_, kehr, słą_, _نجوم_
  { {0x75360053,0x7d0400f2,0x200c0020,0x660910cc}},	//   _לאנד_, vuis, üdi_, lgek
  { {0x64430b41,0x78a30024,0x8fa6070e,0x74120002}},	//   _inni, ilnv, саве, _رويا
  { {0xa3df000b,0x7d041a45,0x22f605bd,0x44251a46}},	//   तरक_, tuis, _הזקן_, lel_
  { {0x75290111,0x6e2405c7,0x3daa0054,0x628700bc}},	// [2c20] nwez, reib, укао_, čkot
  { {0x8b260010,0x31370135,0xa3ab000b,0x7c250012}},	//   йдзе, _פנים_, _खरा_, gehr
  { {0x291f00f2,0x00bb000a,0xb9c60021,0xdb24002b}},	//   _apua_, _תמימ, مقاي, توای
  { {0xa2ca014e,0x201800c0,0x44251a47,0x7d041a48}},	//   _संस्, lfri_, hel_, puis
  { {0x6443022d,0x2baa005d,0x66090161,0x44251a49}},	//   _onni, _करवा, dgek, kel_
  { {0xd90d0086,0x38a9163c,0x91bb000a,0xeb9a1a4a}},	//   ئیل_, túra_, אמני, _биг_
  { {0xfaa60010,0xbad50010,0xf1bf1a4b,0x8ad8000a}},	//   _гаво, _міты, ndár_, _כַּפ
  { {0xa6c700e6,0x64431042,0x14f80054,0x44251a4c}},	//   حويل_, _anni, анић_, eel_
  { {0xc9660010,0x4d7b0053,0x89661a4d,0x96170015}},	//   _увай, ָריע, _укаж, صغير_
  { {0xe8d70008,0x442502b3,0x68f30046,0xa2f402dd}},	//   _לומר_, gel_, ředí, опоч
  { {0xd3d70029,0x4c9b000a,0xd7960015,0xd7ef0015}},	//   حبًا_, רביו, _الضخ, _سكن_
  { {0x44250176,0x46690036,0x64430b84,0xf2c30033}},	//   ael_, _крім_, _enni, ясьн
  { {0xf4d70015,0x44251a4e,0x0000006a,0x0000006a}},	//   _هونغ_, bel_,   ,
  { {0x27ee002e,0x23480086,0xe3af002b,0xe81b000b}},	//   nafn_, _نسبی_, ظری_, प्पा_
  { {0x447b0008,0xd6f80008,0xa6f8000a,0xd47b000a}},	//   _תנוע, יִּש, יִּי, _תאול
  { {0x7c2500b8,0x63be0046,0x8e150033,0x6287111e}},	//   wehr, ězně, ўдац, čkos
  { {0xdc550124,0x463b0053,0xcbc70015,0xd0110015}},	// [2c30] овањ, נעמע, مزاي, _قلة_
  { {0xba3d0046,0x61ef1a4f,0xddc6005a,0x8cf40138}},	//   _lhůt, lacl, _mokř, язуц
  { {0x212b0176,0x50d40086,0x99d90015,0xdfd2002b}},	//   lwch_, _وزیر, لواء_, _تيپ_
  { {0x44251a50,0x19eb0015,0x639b000a,0xe81b000b}},	//   zel_, اراً_, נסאנ, प्ना_
  { {0x212b0176,0xa2bc0053,0x44250700,0xa3e8000b}},	//   nwch_, אמאט, yel_, बरा_
  { {0xb17c000a,0x37090015,0x27ee0034,0x212b0034}},	//   נטגר, لْتُ_, gafn_, iwch_
  { {0xb8d0005d,0x2bdf005d,0x212b0026,0x44251a51}},	//   _टी_, _प्या, hwch_, vel_
  { {0x0f7c000a,0x5eec000a,0x44251a52,0xba740015}},	//   טרול, רַגְ, wel_, _فاقت
  { {0x200a0026,0x20180034,0x44251a53,0x4900000b}},	//   ygbi_, yfri_, tel_, _रियो_
  { {0x212b0176,0x75290111,0x24960086,0x660902f7}},	//   dwch_, rwez, ينيد_, sgek
  { {0x224a000d,0x212b0026,0x44251a54,0xb76712ae}},	//   апни_, ewch_, rel_, _утай
  { {0xd6ab0070,0x44251a55,0xc049000a,0x212b0034}},	//   _صدام_, sel_, _בז_, fwch_
  { {0x212b0176,0xa4f70086,0xc5e8000a,0x14750015}},	//   gwch_, _اکبر_, _הַצֹ, _واتج
  { {0x6443002e,0x73c40015,0x316c002a,0xd00a0054}},	//   _unni, _فيهم, ądz_, јеве_
  { {0x1fb5106d,0xe81b000b,0xdfcf0015,0xae7a062f}},	//   зстр, प्या_, ضيق_, асах_
  { {0x212b0026,0x00ca08a6,0x35d1000b,0x201800d6}},	//   bwch_, _клик_, _हलफ़, sfri_
  { {0x63a30176,0xf1bf002d,0x80e60015,0x212b0034}},	// [2c40] _hynn, leán_, _بأعل, cwch_
  { {0x63a30084,0x0c230080,0x3e670020,0xf1b90089}},	//   _kynn, ммун, _võta_, ýše_
  { {0xd138005c,0x5b2600a2,0x49ca1a56,0xeafa0021}},	//   łąd_, تفال, ален_, شرات_
  { {0x09e3000d,0x7e6d1a57,0x63a30bc8,0xb1cd000a}},	//   доцн, chap, _mynn, ְמוֹ
  { {0xe80e000b,0xb5fd006f,0xba1700c3,0x67d415df}},	//   _सादा_, chši, تينا_, полу
  { {0x6e360007,0x88c50015,0xd7f00015,0xd8b70015}},	//   ldyb, ستهل, ركب_, يدوا_
  { {0xc053000a,0x466a0783,0x7e64005b,0x0000006a}},	//   וזג_, ирим_, okip,
  { {0xf1bf002d,0x27ee002e,0x7791002b,0xddc40045}},	//   deán_, safn_, رینا, chiţ
  { {0xceb3011f,0x7d161a58,0x7e641a59,0xad1a004f}},	//   ויה_, ntys, ikip, ׁוֵר
  { {0xc8660029,0x63a30026,0x7d7b000a,0xf71a0033}},	//   _بطري, _bynn, ינפו, _віды_
  { {0x63a30176,0xe3b80064,0xfbd3000a,0x7e64008c}},	//   _cynn, ldız_, ותת_, kkip
  { {0x212b0026,0x63a30026,0x63b50057,0x45460015}},	//   twch_, _dynn, ýzna, _وناق
  { {0xa2ca000b,0x61ef0110,0x212b0034,0xc6b7000a}},	//   _सूर्, racl, uwch_, _והאי_
  { {0x212b0176,0x74130002,0x14180015,0x4543002b}},	//   rwch_, _يونا, _طيبة_, _آنوق
  { {0x63a30176,0x212b0176,0x9f340036,0xb6d8000a}},	//   _gynn, swch_, мері, מַּט
  { {0x97570008,0xa195017f,0x64581a5a,0x12780015}},	//   חילו_, _найч, _hovi, _وحيث_
  { {0x7e6d1a5b,0xd01b006b,0x5bcb0054,0x9856002a}},	// [2c50] rhap, _кфн_, аћег_, słę_
  { {0x2ba70001,0x61ed1a5c,0x7e641a5d,0x6e360091}},	//   ојев, _heal, akip, adyb
  { {0xf42900f2,0x30940015,0x998f0030,0x629d1a5e}},	//   lmää_, _تشيس, vegő_, ooso
  { {0x3ae70026,0x60cd003f,0x61ed003e,0x13b7004c}},	//   rŵp_, _kuam, _jeal, קהאל_
  { {0x61ed17ce,0xd92b006b,0x6d4b0123,0x67210160}},	//   _meal, рцел_, ågad, _splj
  { {0x60dc000a,0x64581a5f,0x629d1a60,0x8d5a000a}},	//   סקונ, _novi, hoso, _הכשי
  { {0x915e0092,0xb5fd0024,0xf42900f2,0xad9b002d}},	//   oặc_, ekša, hmää_, _gcúr
  { {0xdb1c00dc,0x99d40015,0x7c35165d,0x63a31200}},	//   _ugrá, _يتقا, _hazr, _rynn
  { {0x65600026,0x629d1a61,0x4585004a,0x2806013f}},	//   gymh, doso, ягив, ávné_
  { {0xf1bf002d,0xb9240015,0x33d4005e,0x1309004a}},	//   teán_, _تفكي, міют, бной_
  { {0x61ed002d,0x07080029,0x6b56000a,0x13a7002b}},	//   _beal, _ويكي_, ִישׁ_, تندی_
  { {0x61ed002f,0xf1bf002f,0x7d160c4d,0xd575005e}},	//   _ceal, reán_, ytys, _нуль
  { {0xf8cb005d,0xf1bf002d,0x61ed1a62,0x66060030}},	//   ादिय, seán_, _deal, ókke
  { {0x653a00b2,0x63a31a63,0xc952000a,0x7c35172e}},	//   _לענד, _tynn, תמך_, _nazr
  { {0xdfcf0018,0x61ed0c0b,0xe432002b,0xbf650015}},	//   ايف_, _feal, _سفيد, ودفو
  { {0xee3a0001,0x64460024,0xe81b000b,0x61ed0921}},	//   љна_, ēkie, प्ता_, _geal
  { {0xf1bf002f,0xd00a03ae,0xc6920643,0x7e641a64}},	// [2c60] neál_, _лепе_, גאן_, rkip
  { {0x7e641a65,0x61ed1a66,0x7d161a67,0x76590034}},	//   skip, _zeal, rtys, _lowy
  { {0x8b260036,0x6d4b00c0,0xe805021e,0x7d161a68}},	//   ядже, ägar, _राजा_, stys
  { {0x76590050,0x0ae90029,0x2bbd000b,0x9f5f01d3}},	//   _nowy, تركي_, ्ख़ा, _árán_
  { {0x9056000a,0x63a6002a,0x28f80033,0x98a60e4d}},	//   ּסֶף_, ękni, цель_, пиде
  { {0x26cc02c1,0xb8f4000b,0x28f7004a,0x68e90034}},	//   _pudo_, _सं_, чешь_, _dwed
  { {0xe1ff005c,0x629d0b63,0x765900e7,0xa8170040}},	//   chów_, yoso, _bowy, ستور_
  { {0xfaa30191,0x7d041a69,0x9b17000a,0xf429008c}},	//   _засо, oris, _מחלה_, ymää_
  { {0x68e90026,0xb5fd003d,0xf64f0015,0xa3e8000b}},	//   _gwed, ukša, ائى_, बरल_
  { {0x26cc03af,0xd4d70029,0x61ed1a6a,0xb21b02de}},	//   _tudo_, أبيض_, _seal, nnæv
  { {0x61ed0005,0xa3b6005d,0xe61a061d,0x229503ad}},	//   _peal, चें_, _где_, диня
  { {0xd3770010,0xe707002b,0x7d041a6b,0xb6d30058}},	//   ячы_, _رسمی, kris, _أقنع
  { {0xe5340080,0xc0e40010,0xf1bf002d,0x104b006b}},	//   _цель, ноўк, ceál_, бяви_
  { {0x61e001e2,0x61ed003e,0x55bb0008,0x629d00f2}},	//   ımla, _weal, _המדו, soso
  { {0xda0d005d,0xf42900f2,0x7c3502c6,0x60c5007c}},	//   _हालत_, smää_, _razr, _vihm
  { {0xe0df02b9,0x7c350085,0x7d041a6c,0x816b0cb0}},	//   ppò_, _sazr, fris, _гроб_
  { {0x81fc0008,0xaffd0036,0x2249002c,0x82340040}},	// [2c70] _ההחז, _копi, _inak_, _سريا
  { {0xdfd10029,0xfbd00015,0x0000006a,0x0000006a}},	//   _جيد_, هتم_,   ,
  { {0xaac703c4,0xde590036,0x68e91a6d,0x7d041a6e}},	//   ستان, _дані_, _swed, aris
  { {0x7d18002f,0x68e90035,0x7d041a6f,0x5ee8000a}},	//   éasá, _pwed, bris, _מַשְ
  { {0x3ea90123,0x17c90e77,0xd91b0088,0xe8f801f3}},	//   mlat_, огли_, сье_, злі_
  { {0x01380008,0xc7a50036,0x49b80018,0x07a51a0d}},	//   פרות_, милк, ساند_, малн
  { {0x76590d72,0xe80e000b,0xb8f4000b,0xdce4002a}},	//   _powy, _सारा_, _सू_, dzię
  { {0xd8770074,0x645c01d1,0xb5fd00bd,0x5692009c}},	//   _کارب, örin, akšn, кајт
  { {0x58050015,0xa525005e,0xdb1c0123,0xb8150099}},	//   _يورك, ємод, _egrä, _одај
  { {0x22490375,0x3ea9008c,0x383500fd,0xe01f000b}},	//   _anak_, hlat_, _інер, म्मद_
  { {0x8bd6000a,0xc1ea0015,0x3ea91a70,0xa22a1a71}},	//   וותו_, يّده_, klat_, ожна_
  { {0x1dbf005d,0x03940010,0x179a000a,0x38b20045}},	//   ्शात, эрыя, _ויעב, râre_
  { {0x66c70061,0xb148002b,0x13a7002b,0x3ea91a72}},	//   _fıkr, سیدم_, تنگی_, dlat_
  { {0x63850124,0x55ba000a,0x3ea90123,0x22491a73}},	//   _огла, _ומנו, elat_, _enak_
  { {0xe29f0084,0xd3350010,0x7545005c,0x82860029}},	//   boð_, _цэлы, łrzę, _يجعل
  { {0x0eaa0010,0xecea024f,0xe058002b,0x7d041a74}},	//   ікай_, ждал_, _کیست_, tris
  { {0x32d30023,0xd12f0086,0xb21b02de,0xbea30c6e}},	// [2c80] _hãy_, _نمي_, tnæv, татк
  { {0x7d041a75,0x6c4a0015,0x25a2007c,0x2249088b}},	//   rris, غلاف_, ükli_, _znak_
  { {0x7d041a76,0x3ea91a77,0x7c650058,0xbad60138}},	//   sris, blat_, راكل, фізы
  { {0x3ea90251,0x7d040376,0x20d4007c,0x2a660085}},	//   clat_, pris, _käi_, ukob_
  { {0xaac50086,0xbdfb0086,0x20d40607,0x2bdf000b}},	//   رتمن, _برپا_, _jäi_, _प्वा
  { {0xd6da1a78,0xe8940033,0x9cb6002b,0x3ea01a79}},	//   оти_, эаль, _آمست, loit_
  { {0xf793008f,0x3ea008cf,0x80d50065,0x45d402ed}},	//   кашэ, ooit_, _यूने, нойс
  { {0xa3c3005d,0xdce4002a,0xf729005e,0xdb1c0123}},	//   ्शन_, wzię, яцій_, _vgrä
  { {0x64c8000b,0xd40602ed,0x20d40072,0x0000006a}},	//   रदेश, мяни, _näi_,
  { {0x986a0015,0x2db7000a,0xc3540004,0x33860033}},	//   _بحرف_, ולפן_, екој, думв
  { {0xd37a062d,0xe29f001a,0x88c50015,0x68e20416}},	//   ючи_, toð_, _ستكل, lpod
  { {0x57250086,0x32d30092,0x68e21a7a,0x056612ff}},	//   _سرمق, _dãy_, opod, _овен
  { {0xa2ca005d,0xf1ab0086,0x76bb0008,0xddcd006f}},	//   _संक्, تاده_, _ומאפ, tiaž
  { {0x104b0036,0x9f43002c,0x33940010,0xdbf30061}},	//   цями_, majú_, _палё, _işçi
  { {0x9f43002c,0xc058022a,0x442c1a7b,0x32d30016}},	//   lajú_, фія_, med_, _gãy_
  { {0x92580029,0x02fb000a,0x442c1a7c,0xd737000a}},	//   _يشير_, _ולהמ, led_, וטלת_
  { {0xdfd510a7,0x865b0008,0x9f43002c,0x442c1a7d}},	// [2c90] _попы, קדמי, najú_, oed_
  { {0xb5fd0048,0x442c1a7e,0x3ea91a7f,0x2919003d}},	//   ekšl, ned_, slat_, _īsa_
  { {0x9f43006f,0x1ae4005e,0x68e21a80,0x442c1a81}},	//   hajú_, воєм, epod, ied_
  { {0x2bdf0372,0xfbdf014e,0x9f43002c,0x3a750010}},	//   _प्रा, _प्रम, kajú_, элер
  { {0x26de04ed,0x4dda0008,0x442c1a82,0xd82504e0}},	//   _atto_, _מחרו, ked_, едли
  { {0x9f43002c,0x442c1a83,0x961d003d,0xf84b004a}},	//   dajú_, jed_, diņa, ючей_
  { {0xa2ca005d,0x442c1a84,0xb6a50511,0xc7a2006d}},	//   _संग्, ded_, никл, лишк
  { {0xbb480086,0xee320008,0x442c1a85,0x628f0079}},	//   _تلفن_, ָֽה_, eed_, jnco
  { {0x660600dc,0x9989005c,0x79a70e88,0x442c0335}},	//   ókka, żał_, _црве, fed_
  { {0xa2ca014e,0xe451003b,0x442c1a86,0x57270015}},	//   _संख्, اضة_, ged_, _يراق
  { {0xae0f005d,0xcc56000a,0xe2860c96,0xfe0f000b}},	//   िलान_, תבתי_, елни, िलास_
  { {0x644a1a87,0xa3c0000b,0x442c007c,0x9f43006f}},	//   _enfi, ूख़_, aed_, bajú_
  { {0x3e6e002e,0x442c1a88,0xd36e002b,0x764b0030}},	//   _nýta_, bed_, لهی_, _ingy
  { {0x442c1a89,0xa06a0010,0xa8790053,0xa2ca021e}},	//   ced_, чага_, לאָר, _सूक्
  { {0x6e2d002d,0x53320004,0x3ea01a8a,0x7f1901c6}},	//   feab, _бејт, toit_, міту_
  { {0x7d0d003f,0xb13a0015,0xddcd002a,0xd7f10016}},	//   fuas, _فأخذ_, ciaż, _lẽ_
  { {0x3ea01a8b,0x8cca0015,0x62861a8c,0x98a40091}},	// [2ca0] roit_, سواق_, miko, _esmę_
  { {0xc19b0008,0x69db0077,0x628609cb,0xbca60067}},	//   _משפי, _afue, liko, رماي
  { {0x9f43002c,0x961d0024,0xb5fd0024,0xe1ff002d}},	//   zajú_, ziņa, ekšm, mhór_
  { {0x649c0064,0x442c07e9,0x6e2d00da,0xfce615d5}},	//   _içiş, zed_, ceab, _помо
  { {0x442c003e,0x3cd50010,0x58d7005e,0x6286008c}},	//   yed_, _аўст, едія_, iiko
  { {0x442c003e,0x9f43002c,0x62860e95,0xddcd002a}},	//   xed_, vajú_, hiko, cjał
  { {0x442c003e,0xe66600d7,0xa09b000a,0xab090015}},	//   ved_, етпо, היסט, _يتفق_
  { {0x442c0495,0x9f43002c,0x961d003d,0xdb1f0030}},	//   wed_, tajú_, tiņa, _óvár
  { {0xdb1c002d,0x442c1a8d,0x35b4006b,0x39460033}},	//   _ngrú, ted_, ъбир, _янаг
  { {0x998000df,0x7d7b0008,0x9f43002c,0x47d30015}},	//   žių_, פניו, rajú_, _ميكر
  { {0x442c1a8e,0x9989006f,0x62861a8f,0xe56f002b}},	//   red_, ľať_, fiko, لطی_
  { {0x62860005,0x9989002c,0x442c1a90,0xf1a7056d}},	//   giko, žať_, sed_, ергн
  { {0x442c0abe,0x60f80088,0x2c6f002a,0x93aa002b}},	//   ped_, нняя_, ażdy_, _کاشف_
  { {0xc0580484,0x62861a91,0x644a00da,0x7d0d008c}},	//   ніс_, aiko, _unfi, vuas
  { {0xcf9800d0,0x2f28006b,0x533410b7,0x6e2d1a92}},	//   ејт_, нюто_, _рейт, teab
  { {0xad9b0125,0xb21b1a93,0x3e6e006f,0xce580033}},	//   _ndúc, rnæs, _pýta_, насц_
  { {0x8d740015,0xbbeb0015,0x6e2d1a94,0x1bd50a66}},	// [2cb0] هاكا, كرام_, reab, возя
  { {0xf8b80092,0x9c380054,0x6e2d1a95,0x38a90030}},	//   _nhĩ_, нпут_, seab, púri_
  { {0x749b0008,0x39441a96,0x307c000a,0x68fb0085}},	//   לימפ, _arms_, _מאזנ, _svud
  { {0xd7f100a7,0x636b00dc,0xa9350015,0xbae40015}},	//   _sẽ_, lönö, َّاب, اكني
  { {0xb5fd0091,0x26da013f,0x5fd50065,0x7d0d01e0}},	//   ukšm, ípon_, _दलाल, quas
  { {0x717c000a,0x62861a97,0xf1b4000a,0x0f8b004f}},	//   הנדס, ziko, נסס_, ּאֵ֑
  { {0xa695009c,0xd874002b,0x63aa0034,0x39441a98}},	//   криј, دانب, _nyfn, _erms_
  { {0x99d40015,0x8aa400e2,0x6edc00bc,0x62861059}},	//   _متكا, _бруд, _učbe, xiko
  { {0x58d50036,0xf9930018,0xa2cb000b,0x62861a99}},	//   _розт, _صبر_, _संज्, viko
  { {0x44651a9a,0x58d40a21,0x290f007c,0xb9c40015}},	//   твов, _софт, muga_, _صقلي
  { {0xe3b9008f,0x63aa0176,0xfbd20008,0xe29a0770}},	//   ьбо_, _cyfn, יתי_, дан_
  { {0x63ae0061,0x63aa0034,0xf987012c,0x2485007c}},	//   übna, _dyfn, لب_, silm_
  { {0xa56400e6,0x290f0020,0x0fda004a,0x867a000a}},	//   _مدون, nuga_, дьбы_, _קרנו
  { {0x291d0fcd,0x62861a9b,0x5576000a,0x0000006a}},	//   itwa_, siko, _בענן_,
  { {0x63aa0026,0x290f199c,0x8fa60254,0x93440015}},	//   _gyfn, huga_, таве, _مخيم
  { {0x290f0020,0x7bdc04ed,0xf2d20008,0xe3b00067}},	//   kuga_, _sfru, _דעה_, _اره_
  { {0xc5f200a3,0x6284002a,0x290f007c,0x7e230054}},	// [2cc0] ידן_, _imio, juga_, јдуж
  { {0x20040007,0xad650015,0x6aca000b,0xf0ba002b}},	//   ėmis_, دافه, िद्र, _تابش_
  { {0x753c003d,0xbb4a0058,0x78a3005b,0x9a250138}},	//   ārzi, بلان_, donv, сiяй_
  { {0x290f1a9c,0xf98a0015,0xc986012b,0x9f97004f}},	//   fuga_, وناي_, кули, _ידיה_
  { {0xf9920015,0x290f007c,0x89330015,0x645c01be}},	//   جبا_, guga_, لعوا, örik
  { {0x7afc016f,0xa7fc0064,0x6aa20020,0x4813005e}},	//   _tvrt, _alır, soof, иміс
  { {0x7c3c002f,0xba0a0015,0x291d01d7,0xe72f0015}},	//   _iarr, _يترك_, atwa_, قصي_
  { {0xcf93000a,0xc6a6006b,0xaac50015,0x96341a9d}},	//   יטו_, ърли, _متقن, униц
  { {0x291d005c,0x08c60010,0xdd110061,0xe60f002b}},	//   ctwa_, _абан, _müşe, زشي_
  { {0xccf3000a,0x38cb002b,0x3e67007c,0xdb0e0045}},	//   סכת_, _قالی_, _võti_, _izbâ
  { {0xd2510074,0x64a30083,0x18770008,0x961d0024}},	//   مند_, раќа, _שעבר_, ciņo
  { {0xa77b01ac,0x2179004a,0x8717000a,0xf5060033}},	//   _קראפ, еймы_, _יקבע_, _аздо
  { {0x95530074,0xaf340086,0x3437002b,0x51840054}},	//   _نخوا, یرفت, رسید_, аура
  { {0x3e7506f5,0x8cd6000b,0x2584003d,0xa3d312ae}},	//   _måte_, _बढ़ो, rīlī_, _кошч
  { {0x6d4617e3,0x54330031,0x66020247,0x1ee7009a}},	//   _arka, _ضرور, _kdok, ئوری_
  { {0x3cfe005d,0x443e1a9e,0x636b0030,0x443c1a9f}},	//   _लिखे_, ldt_, sönö, _hav_
  { {0x961d0048,0x5cb90010,0xdd110064,0x7c3c1aa0}},	// [2cd0] ziņo, елаў_, _düşe, _barr
  { {0x1a650086,0x443c1aa1,0x443e1aa2,0xcfab002b}},	//   گیری_, _jav_, ndt_, _يادم_
  { {0x44e20023,0x6d4600b8,0x6ec70029,0x7c3c1aa3}},	//   hư_, _erka, _لتحق, _darr
  { {0x7c3c002f,0x99840007,0x290f1aa4,0x8f88000a}},	//   _earr, _namų_, tuga_, _יְרֵ
  { {0xc27c00f3,0xe8df0016,0xb9250067,0x1a040033}},	//   וראי, _trọn_, افتي, рпім
  { {0x443c03eb,0xfc640063,0xad1a0008,0x443e0111}},	//   _nav_, _късн, _אושר, jdt_
  { {0x291d005c,0x290f0020,0x46f40010,0xa4f7002b}},	//   stwa_, suga_, ачыт, چکتر_
  { {0x443e0111,0xc1e3021e,0x9f5e0003,0x6d460123}},	//   edt_, _क्लब_, ûté_, _yrka
  { {0xfeca0053,0x7e6d1238,0x2614000b,0x6e3d02f2}},	//   עמפּ, ikap, _धारी_, _masb
  { {0x649d0251,0x38a9006f,0x49740033,0x7e6d008c}},	//   nèix, túru_, _тлус, hkap
  { {0xf7700086,0x46150087,0x7e6d1aa5,0xc169000a}},	//   _وام_, _موار, kkap, _צח_
  { {0xe0c900b2,0x32ba0029,0x6d03000b,0x443e0079}},	//   _זײ_, عددة_, _लिंग_, adt_
  { {0x321e005c,0x7e6d1aa6,0x51f7009a,0x0000006a}},	//   ęty_, dkap, دسپر,
  { {0x85b80086,0xdfd200e6,0x66020227,0x7e6d0030}},	//   _شانس_, صير_, _zdok, ekap
  { {0x141a000a,0x6569008c,0x1e960db7,0x44271aa7}},	//   _נוקב, lyeh, грар, _ibn_
  { {0xd7f10023,0x93bc0045,0x9e750054,0x6da6004a}},	//   _dõi_, sfăc, аћуј, гиба
  { {0x261b005d,0xbda50029,0x614616d7,0x12a90015}},	// [2ce0] _यानी_, لحكو, _сепа, _جدوى_
  { {0x31570008,0x7e6d0019,0x7e761aa8,0xc157000a}},	//   _עיין_, akap, shyp, _עשיו_
  { {0x8e86068e,0x9cb30015,0x629d0003,0xaa460004}},	//   _бгне, حملت, érog, лежл
  { {0x7c3c1042,0x998d002a,0x26da006f,0x6d460085}},	//   _warr, _oceń_, ípom_, _trka
  { {0x7c3c1aa9,0x99550061,0x58860174,0x0d83024e}},	//   _tarr, rüşe_, лыка, _глян
  { {0x8d4b0008,0x219b004c,0x61f61aaa,0x98a30f82}},	//   _אֲלֵ, עבסא, _leyl, биче
  { {0xc7af02bf,0x7fd700a3,0x2bc3000b,0x87260021}},	//   сё_, נוקס_, वेदा, اعتم
  { {0x9b930029,0x443c1aab,0x657b0012,0xfaa61aac}},	//   _الفت, _sav_, fzuh, _сабо
  { {0x6d441aad,0x443c0007,0x44271aae,0xb355002b}},	//   nvia, _pav_, _bbn_, ییها_
  { {0xd5c0005d,0xe8d70008,0x443e0079,0x7414012c}},	//   शेषज, _עובר_, udt_, جودا
  { {0x443e0a9c,0xd8770015,0xfc57004c,0x61f61aaf}},	//   rdt_, _حملت_, אביש_, _beyl
  { {0x673a0085,0x71750015,0x479b000a,0x61f61ab0}},	//   _istj, لهجا, _איבס, _ceyl
  { {0x6d44002c,0x61f80010,0x9f510057,0xc50a0015}},	//   jvia, ыняў_, razí_, _أتصل_
  { {0x60d60064,0x14180015,0xc05b01f3,0x6d44006f}},	//   _duym, _شيبة_, хім_, dvia
  { {0xb4c2005d,0xb4c0005d,0xcebb0001,0x5ea50029}},	//   ्दी_, ंगी_, еља_, لمسل
  { {0xe80e005d,0x38bb00dd,0x539b000a,0x4ea71ab1}},	//   _साझा_, mêre_, _ריהו, урга
  { {0x38bb00dd,0x6abb0026,0x5d550254,0x6e3d00aa}},	// [2cf0] lêre_, _rhuf, шкат, _vasb
  { {0x673a0020,0xd01100e6,0x9ed9017a,0x7e6d1ab2}},	//   _ostj, _بلد_, _имот_, skap
  { {0x649d0251,0x38bb00dd,0xca15006b,0x600c000a}},	//   rèix, nêre_, иджъ, _נִזְ
  { {0x99d40067,0x8bc40088,0xbddb0144,0xe74d0030}},	//   متها, ссуд, _enèr, _kéöü
  { {0xc27c00b2,0x8dfa0008,0x527c0053,0xe9d80010}},	//   ערדי, _שהשת, ענדא, укі_
  { {0x1bd4058f,0x8d48000a,0xa9661ab3,0x00f8004f}},	//   _горя, _עֲרֵ, риша_, נמוך_
  { {0x4af60086,0xdc9a000a,0x4c9a000a,0x1a65002b}},	//   _نکند_, _יישל, _יבשו, _پیشی_
  { {0x0f580008,0xe1ff002a,0x442701d7,0x9a871ab4}},	//   ריהם_, mków_, _sbn_, _сугл
  { {0xd4550036,0x7d0d08f5,0xb4c2000b,0x4d57000a}},	//   атнь, nras, ्दू_, רֹ֔ן_
  { {0x7c25002d,0x032500d0,0xddc40007,0x657b0012}},	//   nfhr, адон, nkiš, rzuh
  { {0xe1ff0050,0x96550063,0x3a3f1404,0xee3f006f}},	//   nków_, _вълч, _kaup_, _akým_
  { {0x216a0036,0x6d440007,0x7c25002d,0x61461ab5}},	//   вими_, yvia, hfhr, аема
  { {0xe2971ab6,0xc568006e,0x34951161,0x7d0d1ab7}},	//   рая_, _محول_, _кадр, jras
  { {0xd4660124,0xb4fa0008,0xe5c40010,0x38bb00dd}},	//   _више_, _ספצי, _усхо, bêre_
  { {0x6ec60015,0x6f630004,0x1eaa0015,0x7d0d1ab8}},	//   لترق, оврз, ناري_, eras
  { {0x539a0e22,0xe1ff005c,0x7afa002e,0x29000007}},	//   _ביצו, dków_, _ætti, šiai_
  { {0xf6520008,0x4c860010,0xac860219,0x1cba0015}},	// [2d00] חצן_, алав, агал, نائب_
  { {0xe0fb013a,0xd12f0086,0x70770086,0xf7f2002a}},	//   _שליל, _کمی_, _ناپذ, ężką_
  { {0xdddd0014,0x0ca900a2,0x2abc0077,0x64411ab9}},	//   _első, اطقي_, híbe_, idli
  { {0x6da60036,0x8b650029,0xf38c004c,0x7d0d1aba}},	//   _вима, حاكم, עראָ, bras
  { {0x2900001c,0x9f430077,0xed430033,0xe1ff002a}},	//   éia_, bajó_, _дняп, aków_
  { {0x20181abb,0x3eb200f2,0xf1b90264,0x3706007a}},	//   ngri_, llyt_, ýši_, ачив
  { {0x26cf02f2,0x64411abc,0x27170015,0xe1ff002a}},	//   _bigo_, ddli, لآية_, cków_
  { {0xeb970191,0x644100b8,0xbb3b0008,0x2240013c}},	//   _тис_, edli, _בעלי, _naik_
  { {0xd5b70a7f,0xd9460054,0xb9290015,0x7a460030}},	//   ись_, _њези, _مثلك_, gétő
  { {0xb4c0005d,0x91690092,0xb4c2005d,0x38bb00dd}},	//   ंगे_, _lựa_, ्दे_, têre_
  { {0x3e7500c0,0x36060029,0x2240013c,0x0ec6000b}},	//   _låta_, _نواف, _baik_, लगाड
  { {0x92940010,0x7ae10030,0x38bb00aa,0x39461abd}},	//   жаюц, _élte, rêre_, ovos_
  { {0x867b0008,0x265b000a,0xe1ff002a,0x7416002b}},	//   _בראו, _שכדא, zków_, _نوشا
  { {0x27fc0cd8,0xe1ff005c,0x3946016e,0x7d0d0363}},	//   navn_, yków_, ivos_, vras
  { {0x06fd0089,0x94bb000a,0xa857000a,0x43370015}},	//   žívá_, _שמות, סילה_, _نسيج_
  { {0x2295002b,0xf777000a,0x41e7005e,0x7d01001a}},	//   _دلبس, בעלי_, _тіка, járý
  { {0x7d0d1abe,0x91690092,0xb2bc000a,0xdb1c002a}},	// [2d10] uras, _dựa_, _במהר, _ogró
  { {0xe1ff005c,0x7ae90046,0x7d0d1abf,0x61fd1ac0}},	//   tków_, _četb, rras, lasl
  { {0x309a0008,0x99d50029,0x2a641ac1,0x9e350004}},	//   _תשתמ, مقات, _bomb_, _ленч
  { {0x7e550086,0xde590484,0x7d0d1ac2,0x8f36000a}},	//   _انحص, _самі_, pras, _פארו_
  { {0x39490467,0x0dcb000d,0xe1ff005c,0xf9900002}},	//   ías_, _јуни_, sków_, وبه_
  { {0xf8a80010,0xb4c0000b,0x49b80067,0x229200bc}},	//   авік_, ंगो_, جامد_, mške_
  { {0xb21b001a,0x6d40001a,0x61fd1ac3,0xf7490015}},	//   mhæf, _ámar, kasl, البي_
  { {0x2f980008,0x2a6400dc,0x7d1b0012,0x61fd003d}},	//   יכון_, _gomb_, _äuss, jasl
  { {0x88070225,0x4975070e,0xa3c9000b,0x99850015}},	//   _نظام, _улас, लेन_, _الذو
  { {0x2abc002d,0x981700a2,0xedb6000a,0x998f0046}},	//   ríbe_, _خبرا, מִית_, legů_
  { {0x69cb005d,0x9f580003,0x64411ac4,0xa25b016e}},	//   _तृती, paré_, rdli, rmôn
  { {0x6f150467,0x27211ac5,0x290f1ac6,0x625a1ac7}},	//   duzc, món_, orga_, урор_
  { {0x2935004c,0x51170033,0x27211ac8,0xe5090015}},	//   זאָן_, боўю_, lón_, _إيتو_
  { {0x05a8005e,0x672300bc,0x6f0804b2,0xd5b40015}},	//   _твій_, otnj, ádco, _بإمع
  { {0xb21b0134,0x8456000a,0xe456000a,0xdee603a8}},	//   dhæf, _לבסס_, _ליסט_, соби
  { {0xbda60015,0xd1320015,0x39460091,0xdc10000b}},	//   محذو, _فمع_, yvos_, ाल्ड_
  { {0xee370001,0x9b8a002b,0xed571ac9,0x272119b8}},	// [2d20] љну_, گنال_, бот_, hón_
  { {0xa3ab000b,0xcc090015,0x4f960004,0xb17b02dc}},	//   कअप_, لزمن_, _грму, rbåt
  { {0x5f4600a2,0xf1a9002b,0x27211aca,0x4b260004}},	//   _انجل, _مایه_, jón_, смев
  { {0x82d60053,0xef22005c,0x2010002a,0x3ea900c7}},	//   צונג_, ążę_, łnią_, coat_
  { {0x186a09ac,0x1958055f,0x3946008c,0xe9f70138}},	//   лади_, ралы_, uvos_, сніі_
  { {0xa9670054,0x2a6400da,0xfce31acb,0x27211acc}},	//   сиља_, _womb_, _хоро, fón_
  { {0xcc77000a,0xa3c9000b,0x39460091,0x61fd0f0a}},	//   _פעלה_, लेम_, svos_, yasl
  { {0x3e6e0046,0x1efb004c,0xddcd002a,0x6e361acd}},	//   _býti_, אלקע, jjaś, neyb
  { {0x61fd0014,0x9992005c,0xb5fd0024,0xe9440086}},	//   vasl, żył_, ekšs, _برزی
  { {0xd6d20806,0xb8650029,0xe56f0015,0x7d7b000a}},	//   _فقط_, _والو, عطي_, טנפו
  { {0xd5b2002b,0x2259004a,0x27211ace,0x61fd1acf}},	//   _کفش_, аины_, cón_, tasl
  { {0x41e40010,0xb5fd0007,0x0bb70008,0x9757000a}},	//   зіра, ukšt, מלים_, _ליבו_
  { {0x61fd02c6,0xb5fd0091,0x64a61883,0x645c1ad0}},	//   rasl, rkšt, _лада, öris
  { {0x2d801ad1,0x8cd3005d,0x7d160061,0x351b000a}},	//   dzie_, _भूगो, duys, _עוונ
  { {0x61e40176,0x7e6600c0,0x4fc40758,0x61fd1ad2}},	//   _ffil, _bokp, зста, pasl
  { {0x63970008,0xa195006b,0x5f941ad3,0x9e090015}},	//   _לדוא_, _майч, чист, شيطك_
  { {0x272102c1,0x81170086,0x2d58006d,0x3ea900da}},	// [2d30] zón_, _اذعا, бить_, roat_
  { {0xaae70029,0xebc70001,0xc4d3000a,0xfc300015}},	//   مسؤو, бљен, פגע_, فحم_
  { {0xb21b002e,0xb5fd0796,0xdb510015,0x7b350015}},	//   rhæf, ljše, بَا_, تفاؤ
  { {0xdb1f002e,0xf1bd005d,0xb21b001a,0x6f0116ee}},	//   _ávís, _ईरान, shæf, álcu
  { {0xae1a00b2,0xb5fd10ca,0x89370015,0x290f1ad4}},	//   _דורכ, njše, إعصا, urga_
  { {0x27211ad5,0x0c750086,0x07390029,0xd118000a}},	//   tón_, _بگرد, لسبب_, מקדה_
  { {0xe7080021,0xddcd002a,0x2d9c0061,0xe1ff1ad6}},	//   متين_, yjaś, şvet_, kaó_
  { {0xb5fd0024,0x272107ea,0xf509125c,0x628f0160}},	//   ekšr, rón_, анил_, jico
  { {0x628f1ad7,0x27210077,0x58870174,0x6499016a}},	//   dico, són_, _лыжа, итор_
  { {0x73050191,0x917a0092,0x32090064,0x6aab1ad8}},	//   опоз, hập_, _aday_, logf
  { {0x8c1a0008,0xe3b10029,0x628f0a40,0x07080015}},	//   בותי, برة_, fico, _هيلي_
  { {0x628f0656,0xc2c60015,0xd1ca0054,0xd575187f}},	//   gico, تيجي, илне_, _муль
  { {0xd5480115,0xf494002b,0x3cde000b,0x26da006f}},	//   _هجوم_, _کشند, _कंधे_, ípov_
  { {0xd01200e6,0x201e007c,0x5552009a,0x661b0072}},	//   بلس_, üti_, _آپور, lguk
  { {0xe81c000b,0x644302b9,0x661b007c,0x52860015}},	//   _नासा_, _iani, oguk, _ولتك
  { {0xee3a00d7,0x661b1ad9,0x38b20045,0x644315db}},	//   јна_, nguk, râri_, _hani
  { {0x644303ac,0x7fd6009e,0xa3c3005d,0x3c660033}},	// [2d40] _kani, _міні, ्शक_, окаг
  { {0x2d80002c,0x64431ada,0xfcb600ce,0xab2a01e9}},	//   rzie_, _jani, іщаю, иоза_
  { {0x6a860da6,0x4a46006d,0xdddd002a,0xe9da058e}},	//   олжа, жнев, _dosł, аке_
  { {0x9c870089,0x539a0008,0xe5670015,0xddc60091}},	//   _počá, ביעו, _قط_, _jokū
  { {0xdb070089,0x09360015,0xef19002a,0x79360015}},	//   _vyjá, تراج, ąże_, تعاط
  { {0xc1730008,0xd90d0086,0x64431adb,0x36d41adc}},	//   וחד_, ایل_, _nani, покр
  { {0xe3a70074,0x8b2303f1,0x09e60036,0x394d02c1}},	//   _آر_, _одре, _мовн, _eres_
  { {0xba1a0015,0x7d041add,0x7ae10030,0x628f1ade}},	//   _خيرا_, osis, _élta, xico
  { {0xd90d0086,0x9f58002c,0xe4c6004a,0xfa890033}},	//   _مین_, darí_, жённ, _усёй_
  { {0x64431adf,0xf878000a,0x67560015,0x628f002a}},	//   _cani, _פְּל, _وخار, wico
  { {0x7bdb000a,0x628f1ae0,0xd4970033,0x1cbb000a}},	//   יקיו, tico, ўры_, שמיע
  { {0xd377008f,0x7d041ae1,0xdb2100dc,0x95ca0709}},	//   ючы_, ksis, étét, _кула_
  { {0x66d50007,0x7d040024,0x64431ae2,0x628f1ae3}},	//   _iška, jsis, _fani, rico
  { {0x644309a9,0xdfd80063,0x66001ae4,0x628f1ae5}},	//   _gani, жът_, lamk, sico
  { {0x628f0a40,0x4e8b006b,0xdddd002a,0xd47b000a}},	//   pico, ащам_, _rosł, _דאגל
  { {0x7d04000c,0x637b000a,0x64431ae6,0x66001ae7}},	//   fsis, _כנוד, _zani, namk
  { {0xd9040074,0x7d0400b6,0xdddd005c,0x9d150036}},	// [2d50] _جی_, gsis, _posł, ядач
  { {0xfc330029,0x14d70008,0x660000d9,0xa0680001}},	//   بحر_, קובל_, hamk, _мања_
  { {0x66000375,0x68e9179f,0x5a350004,0x44e00016}},	//   kamk, _sted, знет, _lò_
  { {0xc1750008,0xcf92004c,0x5e590015,0xeaf80015}},	//   ּחַ_, _טטי_, _الحس_, تركت_
  { {0x9e5a0008,0xd2b80008,0x6aab02de,0x63a6002a}},	//   _הכרט, קלדת_, rogf, ękny
  { {0x68e9002c,0x3e7c0089,0xf8680015,0x48ab0054}},	//   _vted, _víte_, يمني_, штем_
  { {0xf77104c9,0x68e9005c,0xdb230086,0xa08c039e}},	//   عات_, _wted, _توزی, יְהִ
  { {0x394d1ae8,0x44e00092,0x05650142,0x4f9c000a}},	//   _tres_, _bò_, звин, יבוצ
  { {0x79820050,0xceb4000f,0x64431ae9,0x7545005e}},	//   czow, ויק_, _pani, їноз
  { {0x44e00092,0xd8770002,0x629d0a8b,0x4877002b}},	//   _dò_, _بارب, éron, _بدرس
  { {0xf1a900b4,0x229200df,0x03220010,0x11d6005e}},	//   _עס_, eška_, ндэн, зігр
  { {0x67ba0008,0x64431438,0xe29a1aea,0x47340015}},	//   _המעק, _wani, сам_, _تركز
  { {0x2bb8005d,0xa7fc0064,0x44e00016,0x64431aeb}},	//   _अर्थ, _alıy, _gò_, _tani
  { {0x7ae904c6,0xf09f0144,0x22590091,0xd1c70033}},	//   _četn, dràs_, _čekų_, яляе_
  { {0x6e2f001c,0x7982002a,0x6d4f1aec,0x1fb5144a}},	//   _bbcb, zzow, _arca, дстр
  { {0x3e6e0084,0xc7b20008,0xae59005e,0x7d041aed}},	//   _nýtt_, גבל_, орує_, tsis
  { {0xed570345,0x621b000a,0x0d860054,0x721b000a}},	// [2d60] пот_, _הופק, члан, _הופח
  { {0xe0580086,0x14d6000a,0x7d041aee,0xb564000a}},	//   _بیست_, פועל_, rsis, וֹעַ_
  { {0x6fdb000a,0x3fdb000a,0x7d0402b3,0x8ad60067}},	//   _לקיס, _לקיב, ssis, ستائ
  { {0xf09f0144,0xa176000a,0xfaa31aef,0x7aa3005e}},	//   bràs_, ּעַד_, нахо, нихз
  { {0xda650015,0x9f580144,0xadd7000a,0x0000006a}},	//   بالي, larà_, _מוכח_,
  { {0x91bb0008,0x7982005c,0xf7720115,0xe6b4002a}},	//   זמני, rzow, فاع_, łużą
  { {0xa3ab005d,0x7982005c,0x9f580251,0xbf360053}},	//   _कुल_, szow, narà_, לאַץ_
  { {0x8b9b0008,0x9aeb000a,0x45d4027a,0x09e60054}},	//   _הבלת, _לַמִ, мойс, _хоан
  { {0xa3c9000b,0xfaa30eaf,0x66001af0,0x89eb004f}},	//   लेस_, _чато, ramk, _הַבֵ
  { {0xd2510086,0x628d002d,0x660000b8,0x9cd60008}},	//   چند_, _smao, samk, הוִה_
  { {0xd2510074,0x4adc000b,0xe215004a,0x66000030}},	//   نند_, यदिव, ммны, pamk
  { {0x9f580251,0x11d90029,0xa75b0008,0x26db000a}},	//   darà_, توحة_, _לדבר, _הקאמ
  { {0xc05b0036,0x32540010,0x75d30015,0xeab1000a}},	//   бів_, хвяр, _كيما, דֹם_
  { {0x82f7002b,0xa3c9000b,0x4ee7005e,0x229202d8}},	//   _کروز_, लेह_, зіаз, rška_
  { {0xb5fd065d,0x9f580251,0x64480026,0x64581af1}},	//   ljša, garà_, mddi, _invi
  { {0x02a4008f,0x877b0053,0x290600f2,0x539b000a}},	//   _прым, זאלי, ksoa_, _ליוו
  { {0xfeb80086,0xb5fd00bd,0x2d58007a,0x98cc000b}},	// [2d70] سافت_, njša, пить_, ाषाए
  { {0x26de00dd,0xebc70001,0x7c970015,0x9f580144}},	//   _outo_, пљен, أشرا, barà_
  { {0x9f580251,0x64480026,0x2003003f,0x4b550015}},	//   carà_, iddi, maji_, بَار
  { {0x39350010,0x629d00cb,0x20030696,0x6d4b02dc}},	//   дэкс, nnso, laji_, ågas
  { {0xe9ab002b,0x26de06aa,0x6d4f0045,0xf773002b}},	//   حدان_, _auto_, _urca, کاش_
  { {0x2003003f,0x629d1915,0x89a8005e,0x9f5816ee}},	//   naji_, hnso, чків_, lará_
  { {0x61e600c0,0x97280015,0xf048000a,0x60df01c2}},	//   yckl, كثيف_, לָה֙_, _luqm
  { {0xa3c2005d,0x644806f1,0x9f580c98,0xcf58000a}},	//   ्धन_, eddi, nará_, לבות_
  { {0x64481af2,0x6d4d1af3,0x20030d06,0x9f4c0125}},	//   fddi, nvaa, kaji_, údú_
  { {0x1309004a,0x6d4d14e9,0x629d1af4,0x9f58059d}},	//   оной_, ivaa, enso, hará_
  { {0x3e7c002e,0x9f580251,0xf799002b,0x26de1349}},	//   _líta_, xarà_, _بناب_, _guto_
  { {0x9f581af5,0x6d4d007c,0x7ae90046,0x645818c4}},	//   varà_, kvaa, _četl, _envi
  { {0x6f15005c,0x9f580656,0x51550681,0x0000006a}},	//   erzc, dará_, нтру,
  { {0x9f580251,0x629d1af6,0xe588000a,0x200301d7}},	//   tarà_, anso, _מָצָ, gaji_
  { {0xa3c9000b,0xd00f0015,0x7e6401d7,0xe7270040}},	//   लेश_, ؤلف_, tjip, خص_
  { {0x9f581af7,0x76490064,0x229200bc,0x12fa000a}},	//   rarà_, ndey, mško_, _והקב
  { {0x82360074,0xdb0e0089,0x9f580251,0xb2290015}},	// [2d80] _فرکا, _vybí, sarà_, _رأيك_
  { {0x28e1005d,0xfbd20115,0x7649008c,0x66d500bc}},	//   _पढ़ि, نتا_, hdey, _oško
  { {0xab270eb0,0x6d4d1af8,0x0ae90015,0x69c0002a}},	//   доха_, avaa, كرني_, _szme
  { {0x99dd099c,0x9f580656,0x2906008c,0x4dd60015}},	//   _daňo, cará_, tsoa_, _يتحس
  { {0x64480b7c,0xda650015,0xa9670076,0x48e30033}},	//   yddi, عامي, мица_, вочв
  { {0x76590026,0x68fb005c,0xd7ef0015,0x3ead1af9}},	//   _anwy, _dwud, لكه_, čete_
  { {0x2906001c,0x8a060001,0x7bdc02f2,0xba1a002b}},	//   ssoa_, _озве, _igru, _ويسا_
  { {0x2003000c,0xc9560080,0xf429008c,0xf76f0058}},	//   zaji_, _отзы, ylää_, شاى_
  { {0xceb30008,0x6f1c1afa,0x69c018e1,0x66d50091}},	//   כיה_, hurc, _uzme, _eško
  { {0xb4b8005d,0x26de01b2,0x9f580c98,0x3d16000b}},	//   चते_, _tuto_, zará_, _फटने_
  { {0x629d1afb,0x64481afc,0xd62a1afd,0xb7db000a}},	//   tnso, rddi, _може_, _וקבי
  { {0x6f1c018b,0x9f5800e1,0x38a9006f,0x7d161afe}},	//   durc, xará_, dúry_, krys
  { {0x20030f4d,0x44f30010,0x75291aff,0x104b0b08}},	//   taji_, _апіс, ctez, ояви_
  { {0x656f00b8,0x55bb000a,0x27170016,0x7bdc01d7}},	//   äche, _ומדו, ũng_, _ngru
  { {0xf4130008,0xa2950010,0xd0d40063,0xe2ab0029}},	//   _ספק_, _пакі, торъ, _وابن_
  { {0x6d4d0111,0x4ea4017a,0x5e58004a,0xb2a70015}},	//   tvaa, вруа, мися_, _تحته
  { {0xf1a40010,0x9f580656,0xdd9404ab,0x81fc000a}},	// [2d90] _арэн, rará_, ваты, _והחז
  { {0x3156013a,0x9f580a40,0x76490061,0x6d4d1b00}},	//   _ניתן_, sará_, zdey, rvaa
  { {0xda15000d,0xbae40015,0x752900bc,0xdee700c3}},	//   едењ, نكلي, ztez, _تأخي
  { {0x8f1a000a,0x28c4000b,0x2249007c,0x1dbe000b}},	//   _צורת, _लीबि, _jaak_, ्धशत
  { {0x22491786,0xeab00029,0x99d400e6,0xcd2b0015}},	//   _maak_, جعل_, نتها, _بسجن_
  { {0x9178000a,0xacfa004f,0x212b01f9,0x0000006a}},	//   ועדף_, _מהשכ, itch_,
  { {0x7afc0176,0x20010020,0xcb690015,0x3ce5000b}},	//   _gwrt, _mehi_, _عمره_, _झंडे_
  { {0x752904ed,0x06091b01,0x26c61553,0x7bdc09bb}},	//   ttez, чник_, _choo_, _zgru
  { {0xf5480023,0x78f80015,0x76490061,0x3915012c}},	//   _cụ_, _يعكس_, rdey, _سواز
  { {0xf5480023,0x2db80008,0x75291b02,0x3365168f}},	//   _dụ_, ולחן_, rtez, евог
  { {0xa3c9005d,0xe8d60008,0xe66700a4,0x872700c3}},	//   लें_, _נוער_, _отдо, _زعام
  { {0xbbdc005d,0x75290045,0xfbd2000a,0x229207c4}},	//   _बल्क, ptez, טתי_, rško_
  { {0x0000006a,0x0000006a,0x0000006a,0x0000006a}},	//     ,   ,   ,
  { {0x38a9006f,0x7d1600aa,0x2a6d1b03,0xa855000a}},	//   túry_, vrys, _loeb_, ׂיָה_
  { {0xc7b200b2,0x2baf005d,0x7e561b04,0xb416000a}},	//   ָבן_, _जुला, нтац, _טקסס_
  { {0x9f5c09f0,0x291d0f4d,0x683301e2,0xb21b02de}},	//   _því_, kuwa_, lıdı, lhæn
  { {0xafe605f8,0xe3b80061,0xec7a01c5,0xd10a0040}},	// [2da0] _попл, ngın_, ппа_, _عقده_
  { {0xcf460010,0x68330064,0xb21b0134,0x22490111}},	//   _зной, nıdı, nhæn, _zaak_
  { {0x6bd70015,0xe803000b,0x66c50030,0x3ce5000b}},	//   فوكس_, _रज़ा_, iókb, _झूठे_
  { {0xdceb0064,0xb90604ab,0x68e00034,0x49ca004a}},	//   _çiğn, ездк, _pumd, плен_
  { {0xe2970053,0x38c8002b,0xf9920015,0x09ca0065}},	//   עכנט_, واتی_, دبا_, िधेय
  { {0x6d461b05,0x49730010,0xd90d002b,0x3ea01b06}},	//   _iska, ыліс, زیم_, lnit_
  { {0x501b0008,0xbcb70008,0x66c50030,0x7c3e0e90}},	//   לוסו, _נפלו_, zóke, mepr
  { {0x3ea01897,0x3944007c,0x8b0b000a,0xa5341b07}},	//   nnit_, _tsms_, _מִמֵ, внич
  { {0x224900dd,0xb21b0134,0xfe370008,0x3e7c0046}},	//   _raak_, fhæn, גרפי_, _líto_
  { {0xf5480023,0x224912c5,0xa9230091,0x3ea01b08}},	//   _vụ_, _saak_, ėžta, hnit_
  { {0xd7640086,0x7c3e090f,0x2c1e0065,0x9c0b004f}},	//   _جنای, iepr, _पाईं_, הִכִ
  { {0xd62a0080,0xf5480092,0x877b000a,0x270c0046}},	//   _ходе_, _tụ_, _מאבי, měn_
  { {0x22490298,0xc05b0036,0x63860152,0x399b004c}},	//   _vaak_, пів_, _béné, ִילד
  { {0x68330061,0x3ea01b09,0xa3ab000b,0xc1740058}},	//   cıdı, enit_, _कुक_, ادَت
  { {0x270c0089,0x9f340036,0xa8570008,0x2249016b}},	//   něn_, лері, עילה_, _taak_
  { {0x62670031,0x644a1b0a,0x03bb000a,0xceb80054}},	//   _سابق, _hafi, _מצול, ељу_
  { {0x5ff50063,0x443e0161,0x61ed0123,0x644a1b0b}},	// [2db0] _изпу, oet_, _ifal, _kafi
  { {0x6386038d,0x319c000a,0x8d740015,0xe81c000b}},	//   _géné, _מבחנ, دافا, _नागा_
  { {0x443e0298,0xa3c2005d,0xf24b000a,0xe3b80061}},	//   iet_, ्धि_, ּגְּ, zgın_
  { {0xd9990029,0xe3b80064,0x443e1b0c,0x291d02f2}},	//   ونات_, ygın_, het_, tuwa_
  { {0x61ed003f,0x443e1b0d,0x7c3e0007,0x68330061}},	//   _mfal, ket_, bepr, yıdı
  { {0x1d160008,0x443e1b0e,0xa3c2000b,0x98f40015}},	//   _בקשר_, jet_, ्धा_, اثنا
  { {0x1ab50010,0x61ed0026,0xd8b80087,0x8aa7005e}},	//   _абвя, _ofal, ردها_, _зрад
  { {0x2f5c0053,0x443e1b0f,0xead40033,0x0000006a}},	//   לדונ, eet_, _бось,
  { {0xe5710029,0x443e1b10,0x2e380008,0x1662004a}},	//   شطة_, fet_, תרחש_, рвым
  { {0xf9900086,0x5d48000a,0x3ea00046,0xb8e7000b}},	//   _طبق_, תָהּ_, znit_, ैग_
  { {0x68330064,0x644a1b11,0x53a50658,0x03a51b12}},	//   rıdı, _dafi, танб, тино
  { {0x7c3e1b13,0x68330064,0x8bd6000a,0x63860003}},	//   zepr, sıdı, כותו_, _séné
  { {0x63860152,0x3ea00089,0x443e1b14,0xe56e0c30}},	//   _péné, vnit_, bet_, _тз_
  { {0x61ed0176,0x659a004c,0x61430054,0x443e1b15}},	//   _efal, _קיסק, јера, cet_
  { {0xc003009c,0x63860003,0x3ea00046,0xdee609fd}},	//   рпск, _véné, tnit_, тоби
  { {0x6d460cd4,0xd336000a,0x644a1b16,0xb5fd01ec}},	//   _pska, _ירצה_, _zafi, ekšz
  { {0x7c3e1b17,0xf1bf0034,0x63860003,0x1d07118f}},	// [2dc0] tepr, ffáu_, _téné, кети_
  { {0x91770008,0x711b0053,0x764b0035,0x3ea01b18}},	//   _סעיף_, _קויפ, _lagy, snit_
  { {0x6d460050,0x290d1b19,0xbb860029,0xa3d1000b}},	//   _wska, _avea_, خلاي, वधि_
  { {0x443e1b1a,0x7c3e1b1b,0x270c0046,0xc332000a}},	//   zet_, sepr, věn_, שוא_
  { {0x443e1b1c,0x99340015,0x7c3e1b1d,0x6d461b1e}},	//   yet_, افتت, pepr, _uska
  { {0x443e11bc,0x3cfb000b,0xfd5f0016,0x270c0046}},	//   xet_, _लौटे_, huyệ, těn_
  { {0xfb16002b,0x644a1b1f,0xdc37004c,0xb09b004c}},	//   _جوزج, _rafi, _שאלט_, ויסר
  { {0x6d44005c,0x443e1b20,0x99dd006f,0x6e241b21}},	//   owia, wet_, _naňh, ngib
  { {0x48e60191,0x7ae9016f,0x644a0026,0x6602007c}},	//   _розв, _četi, _pafi, _veok
  { {0x54530080,0x443e1b22,0x442702b9,0x61ed1b23}},	//   авьт, uet_, _ccn_, _sfal
  { {0x6602022d,0xbc1b0053,0x8c1b103d,0x443e1b24}},	//   _teok, וויש, וויי, ret_
  { {0x92580080,0x443e1b25,0x644a0573,0xb5ca006e}},	//   вают_, set_, _wafi, _قوام_
  { {0x644a1b26,0x443e1b27,0xc0970015,0x3e750123}},	//   _tafi, pet_, نجست, _mått_
  { {0x8438003b,0x649a005e,0x1c1e000b,0x66c50030}},	//   _أكثر_, _ютер_, _पागल_, móka
  { {0x66c500dc,0x138a0015,0xe208002a,0xaab20065}},	//   lóka, _تخشى_, _stół_, जवाक
  { {0x645d0048,0x2ebf005d,0x3e7500c0,0x61ed003f}},	//   ēsie, ्षेत, _nått_, _ufal
  { {0x518702e5,0x3f8a0046,0xaed4005e,0x5d550174}},	// [2dd0] _шука, azbu_, ротш, ыкат
  { {0x1acb005d,0xfdc3000b,0x20c4008c,0x66c50030}},	//   िष्ठ, _शरीफ, löin_, ióka
  { {0xdfd10086,0x764000f2,0xf413000a,0x6d44002a}},	//   _ديد_, kemy, שפע_, awia
  { {0xc3330008,0xdcf70015,0xcf56000a,0xb21b02de}},	//   יוע_, _لأسب, _עברת_, skæf
  { {0x66ea005c,0xae1a000a,0x0d64006b,0x202a001a}},	//   _ręka, _אורכ, _кърм, _ýtið_
  { {0x66d50007,0xfaf3002b,0xbae50015,0xb4ac000b}},	//   _iški, _نثر_, _مكسي, कको_
  { {0x9f5100dc,0xe7080031,0x3e751b28,0x4c340033}},	//   mazó_, نتين_, _fått_, _тэўт
  { {0x3e750971,0x3fdc000a,0x7d0d01be,0x9f510077}},	//   _gått_, וקוב, osas, lazó_
  { {0xdd1201e2,0x95550021,0xdb1c0030,0x764b0091}},	//   _müşt, اخبا, _izrá, _vagy
  { {0x7c250026,0x229200bd,0x9b15000a,0x04c90015}},	//   nghr, mški_, ְחָה_, عودي_
  { {0x6d44002a,0xc759003d,0x22920085,0xe29a04bb}},	//   zwia, šībā, lški_, еан_
  { {0x09b50053,0x95550115,0xc04900f3,0xcb36000a}},	//   ָפֿט_, _مختا, _מז_, נארי_
  { {0xd5bb008f,0x44270016,0x96080033,0x9f580003}},	//   _ўсе_, _tcn_, _рэха_, mbré_
  { {0x351a0053,0xd378005c,0xc4840484,0xf8c3000b}},	//   _נוצנ, być_, _клік, षतिय
  { {0xa3c9005d,0xe29a07d5,0x8cb9000b,0x6fb6002b}},	//   लेख_, _пак_, ्तनो, امزا
  { {0x539a000a,0x6d44002a,0x26dd01d7,0xdd920040}},	//   _ריקו, twia, _jiwo_, موز_
  { {0x7d0d00b6,0x6284000c,0x6c1a0029,0xdd120064}},	// [2de0] gsas, _ilio, فتاح_, _düşt
  { {0x7640005c,0x6d44005c,0x64411b29,0x50460054}},	//   zemy, rwia, neli, _сеоб
  { {0xe47a0053,0x44e9002d,0x61e900bd,0x9f580125}},	//   ערעכ, _lú_, žele, harú_
  { {0xa3ab005d,0xaaba0086,0x4df50010,0x644109e7}},	//   _कुछ_, ردار_, _вярт, heli
  { {0x44e90084,0xd378005c,0xf2d3000a,0xa9960015}},	//   _nú_, zyć_, צעד_, دشات
  { {0x7ae9016f,0x200a0035,0x64411b2a,0x62840034}},	//   _četv, nabi_, jeli, _llio
  { {0xeef60008,0x3179005c,0xd6da1b2b,0x64410e84}},	//   אמֶר_, zysz_, нти_, deli
  { {0x66c500dc,0x9b930015,0xf60a002b,0x224200cb}},	//   tóka, _طلقت, رتبه_, jekk_
  { {0x49ca0124,0x44e91b2c,0x64411b2d,0xd49a1a9d}},	//   _члан_, _cú_, feli, ерн_
  { {0xb8ea005d,0x27f701b2,0x66e60329,0x62841b2e}},	//   ोष_, čení_, _божа, _alio
  { {0x44e9002c,0xa8570008,0xd7ef0015,0x7d0d0030}},	//   _eú_, _תיבה_, _ركن_, zsas
  { {0x66c500dc,0x35fa0029,0x74140086,0x8ccb005d}},	//   lókn, _أراد_, دوگا, _तीनो
  { {0x85760015,0xd378002a,0x44e91b2f,0xca970643}},	//   _حدائ, syć_, _gú_, רדכי_
  { {0x64411b30,0x224d0c6d,0x230a0015,0x657d0013}},	//   celi, žek_, _كتبي_, øshe
  { {0x447b00b2,0x1ee70086,0xdfd50139,0xc6c6000a}},	//   _אנגע, اوری_, ровы, ָהּ֙_
  { {0x7d0d0209,0x2005002a,0xe3130067,0xf313006e}},	//   tsas, źli_, _ابوب, _ابوظ
  { {0x320b003e,0xe21400e5,0x7d0d01be,0x629d0003}},	// [2df0] macy_, _طبيع, usas, érou
  { {0x2dd80015,0x7d0d1b31,0x320b051e,0x859b004f}},	//   طبقة_, rsas, lacy_, גשמו
  { {0x628400f2,0x66d50007,0x7d0d1b32,0x7c250125}},	//   _ylio, _iškv, ssas, rghr
  { {0xd3570008,0x639b0053,0xa3c9000b,0x6fb6002b}},	//   טיבי_, עסאנ, लेट_, _خمپا
  { {0x44250026,0x19580010,0x64411b33,0xdfd1002b}},	//   ygl_, лацы_, yeli, _ديگ_
  { {0x7e6d0020,0xfc670063,0x99d40002,0xa3e0000b}},	//   ljap, _съмн, حتما, _थलग_
  { {0x44e91b34,0xb5fd00bd,0xe0b8004c,0x26dd002a}},	//   _sú_, ljši, אלגט_, _piwo_
  { {0x7f3c0053,0x7be30064,0x3dc6002a,0x320b002a}},	//   געהו, ştuğ, żowe_, jacy_
  { {0xc68e0029,0x26c30024,0xb5fd00bd,0xe8df0092}},	//   بِي_, ējo_, njši, _trốn_
  { {0x9984003b,0x98db0029,0x62841b35,0x44e90016}},	//   _الكو, _أبرز_, _slio, _vú_
  { {0x46150074,0xc1690008,0x200a00bd,0xebd7000a}},	//   _نوار, _קח_, vabi_, נֵ֖י_
  { {0x44e9017e,0xc5d50191,0xa5f90001,0x320b1b36}},	//   _tú_, _кіль, _реду_, gacy_
  { {0x273100a7,0x200a0035,0xa3c9005d,0x224213e1}},	//   _hơn_, tabi_, लेज_, rekk_
  { {0xe3b00074,0x0574002b,0x251a004f,0x0000006a}},	//   _کره_, _دامد, _יונא,
  { {0xb4c3005d,0x200a0582,0x441a0053,0x67230849}},	//   ्षी_, rabi_, _סוקס, nunj
  { {0x6284000c,0x66c50f87,0x200a1b37,0x320b00da}},	//   _ulio, ióko, sabi_, cacy_
  { {0xb2bb009d,0x6146000d,0xee370001,0xa2bb000a}},	// [2e00] _במקר, _тепа, јну_, _במקט
  { {0xcc870010,0x3e7c0046,0xfbc60850,0x6723088a}},	//   абуе_, _míti_, абзо, kunj
  { {0x0b460956,0x66ea002a,0x69c901c2,0x6723088a}},	//   рнен, _ręko, _azee, junj
  { {0x533600b2,0xb4c1005d,0xba170015,0xd336000a}},	//   ינען_, ंतु_, ليما_, ירעה_
  { {0x656f00b8,0x66c500dc,0xd9540015,0xe6da001a}},	//   ächl, tókn, إنتخ, ðsíð
  { {0xfb260086,0x57f30cb9,0x98b70010,0xf7720015}},	//   _پرسپ, општ, аліт_, قاع_
  { {0x61e401d1,0xa7b81292,0x27310092,0x67630015}},	//   _ogil, ылку_, _cơn_, قُول
  { {0x66c5002e,0x2baf000b,0x45440015,0xfaa61b38}},	//   sókn, _जुटा, منعق, _табо
  { {0xd5b00015,0x54b8006b,0xe5c6004a,0x8aab000a}},	//   ثفة_, лгия_, шско, _סֹלֶ
  { {0x14180029,0x6723016f,0x4438001a,0x8433005e}},	//   ديدة_, bunj, ýr_, оньє
  { {0x94730015,0x88bb000a,0xe8d7000a,0x988b000a}},	//   تديا, _יזמי, _כומר_, _בָאֵ
  { {0x9f610003,0x442a002a,0x079b000a,0x48fd0065}},	//   _épée_, żb_, _בסבל, रीको_
  { {0xe298008f,0x32540010,0xe6930087,0x320b1b39}},	//   раў_, цвяр, _بلند, racy_
  { {0x40350054,0x61e41b3a,0xdfa703ae,0x653b05bd}},	//   љевс, _egil, ајбо, _סעוד
  { {0xddc40048,0xcebb0001,0xddc6005c,0x7ed70015}},	//   ndiņ, вља_, _nakł, لزرا
  { {0x33db0008,0x6e64005e,0xdc0f000b,0x6d58003d}},	//   _בחוד, отуж, ाण्ड_, āvan
  { {0x629d1b3b,0x66c50030,0x7e6d019a,0xbbaf0065}},	// [2e10] miso, zóko, rjap, _जुड़क
  { {0xfd4d00a7,0xc1bc0008,0x91bc0008,0xc4f7000a}},	//   _khoả, _במחש, _במחי, יזמי_
  { {0x629d0f21,0xf092004f,0xa4b7004f,0x9b440058}},	//   oiso, _זני_, סלבה_, ينكو
  { {0x6723003f,0x69c000dd,0x6a94005e,0x6d4b001a}},	//   vunj, _byme, оріє, ægas
  { {0x69c00176,0x27310092,0xaa560015,0xe9470674}},	//   _cyme, _sơn_, صلوا_, рхео
  { {0x6c850029,0xd0f8000a,0x00f8000a,0x66c50030}},	//   _السم, סמות_, סמוך_, tóko
  { {0x3e7c0089,0xd7ee0015,0x28120015,0x46150015}},	//   _síti_, ركي_, سويس, موغر
  { {0x9aa50074,0x7ae00007,0x629d003f,0xc6680054}},	//   _امرو, _gimt, jiso, ишње_
  { {0xddc60050,0x69c00176,0xddc40046,0x8e98000a}},	//   _zakł, _gyme, ojiš, ידהו_
  { {0xd874003b,0x61e40026,0x67231b3c,0xe8740015}},	//   _والب, _sgil, punj, _والظ
  { {0xe3b10029,0x58ba004c,0xf1d0000b,0xdb1c1b3d}},	//   ثرة_, _עמעצ, _सृजन, _pyré
  { {0xeb3a004c,0x216a030c,0x0598002b,0x2292006f}},	//   נערש, гими_, امیک_, yšku_
  { {0x68e10293,0xe2970088,0x68e90012,0xe5a50054}},	//   _kild, сая_, _jued, _ћили
  { {0x629d1b3e,0xa4d4005e,0x0379002b,0xd466006b}},	//   aiso, _дочі, _محبت_, _гише_
  { {0xf1bf00dc,0xe3b3002b,0x1168002b,0x1eaa0015}},	//   lgál_, _برش_, _چلبی_, هاري_
  { {0x681b0048,0x673c00f2,0xc8790045,0x3376000a}},	//   lādē, _ärje, _duşi_, _לעצם_
  { {0x7ae00007,0xe1ff002a,0x7afb0045,0x22920046}},	// [2e20] _rimt, ejów_, _ăuta, ušku_
  { {0xcb6a0001,0xad250021,0x31570643,0x22920085}},	//   лазе_, ترفو, _פיין_, ršku_
  { {0x60db0008,0xb5fd00bd,0xfcb5005e,0x69c01b3f}},	//   _תקינ, ljšu, іщую, _syme
  { {0x7f3b0053,0x68e10026,0xddc40046,0xacea0015}},	//   _געטו, _aild, ajiš, _مرسل_
  { {0x39130036,0x1e57000a,0x68e11b40,0xb5fd00bc}},	//   змір, _השכר_, _bild, njšu
  { {0x96f80010,0xbcfb002e,0x69c00264,0x68e90034}},	//   аект_, _bréf, _vyme, _dued
  { {0xd6d0003b,0xbb860029,0xb21b0134,0x68e10064}},	//   وقت_, _الأي, mhæv, _dild
  { {0xdd08002c,0x994c002c,0x567800a4,0x7ae00091}},	//   _môže, môže_, рбия_, _uimt
  { {0xc9aa008f,0xd5ba0afa,0xb9960015,0x09f70015}},	//   _свае_, ыск_, _الذب, _طفلة_
  { {0x68e10084,0x629d0026,0x07a600e2,0x046608ad}},	//   _gild, wiso, _лазн, стим
  { {0x66c500dc,0x8cbb004c,0x629d0d97,0xa5bd0091}},	//   iókj, רציק, tiso, ngųj
  { {0xc8790045,0xe1d9005e,0xa50a008a,0x25a90160}},	//   _ruşi_, идні_, _беда_, _žale_
  { {0x75d60086,0xc50a0015,0xe1ff1b41,0x25ab006f}},	//   _ايشا, _إتصل_, rbó_, čilú_
  { {0xfd4d0092,0xcff4006b,0xc8790045,0x94d30058}},	//   _thoả, зпръ, _puşi_, _فينش
  { {0xe7f0005d,0xe4370008,0x66d50007,0xd437000a}},	//   _चलना_, _הרוח_, _iškr, _הרוק_
  { {0x6e940809,0xc333004c,0x9df91b42,0x82a401ca}},	//   пису, _זוק_, рнат_, _најж
  { {0xcc990124,0xe29f0084,0xa3c2000b,0xa0c50015}},	// [2e30] авац_, mið_, ्धक_, _ويعو
  { {0xe29f0084,0x6bd70015,0x68e90077,0x5c74005e}},	//   lið_, متضر, _rued, плут
  { {0xa0360008,0xe80c005d,0x41b50086,0xda7b042b}},	//   _ואתה_, _सज़ा_, _دمکر, ляд_
  { {0x68e90782,0x66f10048,0xe29f002e,0x02c9005d}},	//   _pued, _nāka, nið_, रतिभ
  { {0x68e11b43,0x8e56000a,0xa925005e,0xa9690848}},	//   _pild, _וירג_, ідкл, рила_
  { {0xaf340074,0xbcfb0152,0xddeb0086,0x0138000f}},	//   _بریت, _préf, _جرگه_, צרות_
  { {0xe29f0084,0x907c0053,0x3ea91b44,0xf7710115}},	//   kið_, רטוי, onat_, ظات_
  { {0x68e90026,0x3ea91b45,0xb4c3000b,0x68e10b9d}},	//   _tued, nnat_, ्ष्_, _wild
  { {0x394d003e,0x30e30053,0x68e10595,0xe29f001a}},	//   _uses_, _שריפֿ, _tild, dið_
  { {0x9f88002e,0xa4d60054,0xe29f001a,0xf494005e}},	//   kóða_, одњу_, eið_, зрюю
  { {0xe29f0084,0x681b0024,0x9f88002e,0xbcfb0003}},	//   fið_, rādē, jóða_, _frég
  { {0xe29f0084,0xcb120008,0x6d4f1b46,0x6d5d1b47}},	//   gið_, ולט_, _osca, _orsa
  { {0xd1760010,0xbbc6000b,0x3ea91b48,0xa50915f7}},	//   цыны, _वर्क, dnat_, _тела_
  { {0xcfaa0029,0x74f60015,0x39400061,0x3e7c001a}},	//   لازم_, _بفوز_, çisi_, _lítt_
  { {0xe4d20015,0x78a40125,0xf6680030,0xc4d2004f}},	//   _تقود, éivi, _áüés_, _חגג_
  { {0xd5f90053,0x3ea90251,0xc332000a,0xd13200c3}},	//   שפּר, gnat_, _חוה_, _قمع_
  { {0x660b0014,0x648d002d,0x3ce30111,0x61f600c0}},	// [2e40] _megk, _cúig, _bijv_, _ifyl
  { {0x8521005d,0xa7fc0064,0x660b00dc,0x6d5d00bc}},	//   _मिनट_, _anın, _legk, _drsa
  { {0x9b460015,0x9b1a002b,0x6d5d07fd,0x6d4f03b8}},	//   تناو, شتاز_, _ersa, _esca
  { {0xfaa3090a,0x0000006a,0x0000006a,0x0000006a}},	//   махо,   ,   ,
  { {0x82d70053,0xda650015,0xbcfb1b49,0x3ea0019a}},	//   קונג_, ثالي, _créd, miit_
  { {0x3ea01b4a,0x66f10024,0x66c50030,0x100a0065}},	//   liit_, _sāka, lókh, वरिश_
  { {0x8cb9000b,0xa3de000b,0x0000006a,0x0000006a}},	//   ्तरो, _दृढ_,   ,
  { {0xbcfb04aa,0xda660021,0x7bce0045,0x9f580077}},	//   _fréd, _باسي, _izbu, laró_
  { {0x94aa000d,0x95d70063,0x95ca01f3,0x66c50030}},	//   итоа_, одът_, шука_, iókh
  { {0x3ea91b4b,0x3ead01a3,0x7a40001a,0x7afe00cb}},	//   znat_, četi_, _fátæ, oppt
  { {0xe29f0084,0xadfc000b,0xa3cf000b,0x5c5b000a}},	//   tið_, ौरान_, _शरण_, בדיק
  { {0x55660058,0x0000006a,0x0000006a,0x0000006a}},	//   _وهاك,   ,   ,
  { {0xe29f09f0,0x3ea910d5,0x7feb005e,0x3ea0007c}},	//   rið_, vnat_, иєва_, diit_
  { {0xe29f002e,0xf8ca005d,0x648d002d,0xc4c60015}},	//   sið_, ितिय, _cúid, _بتصو
  { {0xc0580191,0xa6f80008,0xd6f80008,0x3f850057}},	//   ція_, מִּי, מִּש, álu_
  { {0x82f70086,0x442c0111,0xce680036,0xe29800d7}},	//   _بروز_, lgd_, оруд_, _мај_
  { {0x6fbb005d,0xa1150015,0x98ca000b,0x2d58004a}},	// [2e50] _शुरू, _عودت, िताए, оить_
  { {0xebc70001,0x4d9802bf,0x64481b4c,0x442c1b4d}},	//   ољен, цкую_, nedi, ngd_
  { {0xaa4b005e,0x442c0079,0x64480079,0x3ea90123}},	//   иїде_, igd_, iedi, pnat_
  { {0x2011010b,0xbcfb1b4e,0x64481b4f,0x4fd6004f}},	//   lazi_, _préd, hedi, _מותב_
  { {0x6d5d00b8,0xca740029,0xd5a60015,0x6f15002a}},	//   _ursa, بالغ, _أف_, lszc
  { {0xbcfb038d,0x6448010b,0x4d7a000a,0x4dda000a}},	//   _crée, jedi, _הרשע, _לחרו
  { {0x6d4d0111,0x6f150e8c,0x64481b50,0x6e2d02b9}},	//   lwaa, nszc, dedi, ogab
  { {0x7a16002a,0x442c0079,0x915e0016,0x64481b51}},	//   rętó, egd_, hắc_, eedi
  { {0x6e2d1b52,0x20111b53,0xa5f60054,0x6d4d06a8}},	//   igab, kazi_, чењу_, nwaa
  { {0xa3cf000b,0xe3b10015,0x442c0123,0x660b1b54}},	//   _शरद_, فرج_, ggd_, _wegk
  { {0xe7f0005d,0x9cd8000a,0xe3b90054,0x6f15002a}},	//   _चलता_, חוזה_, сбн_, jszc
  { {0x442c0159,0x6d4d1b55,0x32020046,0x998f0030}},	//   agd_, kwaa, ubky_, legű_
  { {0x6f150050,0x64640011,0x3634002b,0x20d6005e}},	//   eszc, _ştiţ, _آرمس, зівс
  { {0xb4fa0008,0x455a0008,0x64481355,0xd576000a}},	//   _הפסי, _לכנס, cedi, _מתנה_
  { {0x6e2d00b8,0x66c50030,0x43040015,0x5f06106c}},	//   fgab, tókh, _قذيف, язва
  { {0xa7fc0064,0xc332000a,0x531a000a,0xa206004a}},	//   _anıl, _נוח_, _הוקצ, _эпид
  { {0x6d4d0409,0xa0a60004,0xb4f9004c,0xb21b001a}},	// [2e60] gwaa, _наид, מפּי, rhæt
  { {0x3137013a,0xddcb0064,0x66f10024,0xb21b002e}},	//   _צריך_, şişl, _nāko, shæt
  { {0x307b013a,0x807b0008,0x395f0509,0x907b000a}},	//   _האינ, _הניצ, _arus_, _הטיי
  { {0x28c4000b,0xe9da004a,0x31600061,0xce4a0054}},	//   _लीजि, бке_, _kriz_, _узме_
  { {0xb9e30036,0x628600f2,0xda65002b,0x9f580077}},	//   ніши, ikko, ظامي, paró_
  { {0xcee9002b,0x9cb6002b,0x6aab06cd,0x7d161b56}},	//   _درین_, _رمزت, angf, msys
  { {0xa7370029,0x7bce0085,0xe3a70015,0x27171b57}},	//   كثير_, _uzbu, _أر_, găn_
  { {0xd90d0086,0x64480026,0xcb37000a,0x98ac0061}},	//   _چین_, wedi, _מאלי_, ılıp_
  { {0x644801e2,0xe4c604f7,0x7d161b58,0x34941886}},	//   tedi, зённ, nsys, дапр
  { {0x7ce90007,0x6f15005c,0xc917000a,0x0d97000a}},	//   _užre, yszc, _מחמת_, פכים_
  { {0x442c0079,0x6d4d0079,0x57fb000a,0x64481b59}},	//   rgd_, zwaa, _הלבו, redi
  { {0x64481b5a,0xa25b0152,0x20110297,0x75d60015}},	//   sedi, plôm, wazi_, _فيضا
  { {0xd6270036,0x644805fe,0x6f15002a,0xecbe000b}},	//   _хоче_, pedi, wszc, ्ताफ
  { {0xf993000a,0x44f20034,0xe3af002b,0xe4d7002b}},	//   גרש_, _iâ_, ئری_, _فونت_
  { {0x543b00b2,0x643b0008,0x2fc50134,0x201102c6}},	//   _לעגא, _העונ, ælg_, razi_
  { {0x6d4d0079,0x6f15002a,0x998f0030,0xef540033}},	//   twaa, rszc, zegű_, эксь
  { {0x50670033,0xa7fc0061,0x2005001a,0x6e2d1b5b}},	// [2e70] _етна, _anım, ðlis_, rgab
  { {0x6e2d00b8,0x6d4d09f2,0x787d0152,0x44f20034}},	//   sgab, rwaa, _lèvr, _mâ_
  { {0x29000011,0x1a65002b,0x3e7c0046,0x6e2d003d}},	//   ţial_, ویسی_, _vítr_, pgab
  { {0xfbd0003b,0x6723018c,0x66f10048,0x7aee0251}},	//   اتك_, vrnj, _sāko, _dubt
  { {0x9e5a000a,0x5c070033,0x224b02f7,0x6d4d01c2}},	//   _וכרט, _нява, ieck_, qwaa
  { {0xccf20008,0xba770086,0xe73100c3,0xbcfb0a8b}},	//   _בכך_, _کاست, نصب_, _tréb
  { {0xe7391028,0xe7fe000b,0x0000006a,0x0000006a}},	//   цей_, _उभरा_,   ,
  { {0x05650080,0x61e90263,0xbcfb1b5c,0x3694004a}},	//   двин, želj, _gréc, ешьс
  { {0xb345001c,0x06960029,0x648d002d,0x395f0213}},	//   _opçã, بنية_, _núic, _urus_
  { {0x628d01be,0x1827002b,0x99d40015,0x44310061}},	//   _alao, _رقصی_, _ستقا, üz_
  { {0xdc380053,0x8c1a000a,0x620a0015,0x96070015}},	//   לאזט_, חותי, يْدِ_, _فبإم
  { {0xd29a0036,0x78a300f2,0x11d60036,0xa6c90015}},	//   ітні_, linv, дігр, _بوصل_
  { {0x6286022d,0x7529047e,0x22150033,0x5a16004f}},	//   rkko, quez, эфэр, וקרן_
  { {0x62860005,0xc0e3005e,0xc4db0054,0xa988000a}},	//   skko, кояк, _уђе_, פָרִ
  { {0x93fa000a,0x33920015,0xf486002b,0xae7a004a}},	//   _ולצי, _للوز, _زاوی, осах_
  { {0xee3a008f,0x92b6003b,0x628d002d,0xdd920086}},	//   ўна_, _تحتا, _glao, نوز_
  { {0xc237000a,0x7aee0d67,0x6da30b27,0xec7a01e1}},	// [2e80] _חאפז_, _subt, вита, опа_
  { {0x7982003f,0x70770015,0xe588000a,0x02f9000a}},	//   vyow, _يميز_, הָעָ, ַלְמ
  { {0xbcfb038d,0xbb4a0067,0x9f1a0015,0x5ed60015}},	//   _préc, تلان_, _بآخر_, _يتجز
  { {0x8b65003b,0x49ca0579,0x1e831b5d,0x1e260058}},	//   عالم, олен_, _алюм, _تفحّ
  { {0xd9100086,0x7d03006b,0x28ca0065,0x7bc70052}},	//   ایط_, _изяж, ितलि, _eyju
  { {0xa967004a,0x787d1b5e,0x91bb004f,0xd197004f}},	//   ьича_, _sèvr, חמני, וכני_
  { {0x93bc0045,0x212b002a,0x0000006a,0x0000006a}},	//   ngăt, zuch_,   ,
  { {0xdb0e005c,0x8f1b000a,0x8b9b000a,0x96341b5f}},	//   _wybó, קופת, _ובלת, хниц
  { {0xfaa30001,0x61e91b60,0xd44a00ce,0x08c60138}},	//   _рато, želk, оянд_, _жбан
  { {0x54540010,0xe97b000a,0x27f70015,0x224b0012}},	//   хвот, _ונמש, _يفقد_, weck_
  { {0xd2510031,0x7d0b0030,0x224b0012,0x0000006a}},	//   هند_, ágsz, teck_,
  { {0x6d460134,0x68e81b61,0x45460015,0x212b0012}},	//   _opka, _hidd, _يناق, tuch_
  { {0x656f00b8,0x93bc0011,0x224b1b62,0xddc60046}},	//   ächt, egăt, reck_, _takř
  { {0x557700b2,0x212b020d,0x68e81b63,0x0000006a}},	//   _קעגן_, ruch_, _jidd,
  { {0x212b00b8,0x23730087,0x6d460cd4,0x889b000a}},	//   such_, _لايح, _apka, קבלי
  { {0x68e81b64,0x64581b65,0x443e1b66,0x65621b67}},	//   _lidd, _havi, lft_, _kroh
  { {0x61ed0020,0x7bca00b8,0xb11900c3,0x64581b68}},	// [2e90] _igal, üfun, _عقدا_, _kavi
  { {0xbcfb038d,0x443e00b8,0x61fa0089,0xe1d80010}},	//   _créa, nft_, ětle, _ідэі_
  { {0x661d00df,0xbcfb002f,0x9be40010,0x443e1b69}},	//   ųski, _dréa, віцк, ift_
  { {0x80ad000b,0xc212000a,0x69dd01c0,0x64581b6a}},	//   ँचवे, ָ֔א_, _úsek, _lavi
  { {0x1e960008,0xbcfb002d,0xdb1c0107,0x68e81b6b}},	//   _נכשל_, _fréa, _vyrá, _bidd
  { {0xbcfb002f,0x443e0111,0x68e80064,0xa75501b7}},	//   _gréa, jft_, _cidd, етищ
  { {0x68e80176,0xf094011f,0x69c600cb,0x78a31b6c}},	//   _didd, כנס_, _øken, rinv
  { {0x68e80026,0x443e1b6d,0xca24004a,0x8cb9000b}},	//   _eidd, eft_, _аффи, ्तको
  { {0x443e1b6e,0x68e81b6f,0xb95b0015,0x64581b70}},	//   fft_, _fidd, _بجزء_, _bavi
  { {0xe1fa014e,0x656200b8,0x64581b71,0x61ed1b72}},	//   ूर्ण_, _droh, _cavi, _agal
  { {0x53c90036,0x7ae90007,0xf1a9000a,0xe3b10015}},	//   ягом_, _kiet, _פס_, طرد_
  { {0xb6070010,0x7e7d0024,0x656f00b8,0x7afa0030}},	//   _цяжк, _nosp, ächs, _étte
  { {0x1a9a004c,0xdce70046,0xe569006b,0x7ae91b73}},	//   פישע, áměs, _хилд_, _miet
  { {0x7ae91b74,0x64581137,0x61ed1b75,0x66060061}},	//   _liet, _gavi, _egal, ıkke
  { {0xb4cb005d,0xf8b20008,0xa3bb0015,0x3ff30058}},	//   लती_, אשם_, _باشر_, اكفر
  { {0x139a0008,0x733a0053,0xf7720135,0x539a000a}},	//   _מבצע, _זעקס, נקן_, _מיצו
  { {0xbcfb1b76,0x6439000a,0x753b1b77,0x7e7d1b78}},	// [2ea0] _préa, ּעֲנ, ntuz, _dosp
  { {0xe0d204c9,0x6ab8005d,0x765900ea,0x8f76005e}},	//   _حزب_, इक्र, _lawy, _зумі
  { {0xa09b0053,0xcb090036,0x7ae90303,0x1037000a}},	//   _זייט, дхід_, _biet, _אטים_
  { {0xc3320008,0x7ae9003d,0x7e7d1b79,0x2282001a}},	//   רוא_, _ciet, _gosp, _tóku_
  { {0x6443005c,0x9e630010,0xaa570029,0x443e002e}},	//   _obni, _свяд, علها_, yft_
  { {0x7d041b7a,0x0000006a,0x0000006a,0x0000006a}},	//   mpis,   ,   ,
  { {0x7ce90007,0x64581b7b,0x5694006b,0x8c43006b}},	//   _užra, _ravi, какт, _щере
  { {0xddcd016f,0x95080029,0xd6d70802,0xbb3b0008}},	//   ljaš, وقعك_, нты_, _מעלי
  { {0x7ae30161,0x1fdd000b,0xb4cb000b,0xddcd07c4}},	//   ïnte, _मण्ड, लतू_, ojaš
  { {0xd91b013a,0x64a30001,0x443e00b8,0xb7960001}},	//   _מומל, лања, uft_, _прећ
  { {0xa2950036,0x443e1b7c,0x229509ef,0xf5ea006b}},	//   вані, rft_, виня, _емел_
  { {0xda10014e,0x645806e8,0xcb8b000a,0x65621b7d}},	//   ारित_, _wavi, לְכֹ, _troh
  { {0xd2510074,0x5187008f,0x1a9b0053,0xba9b0008}},	//   هنگ_, хуна, ליטע, לסטי
  { {0xb4fb000a,0xc0e40033,0x7e7d1b7e,0x7659002a}},	//   _צפוי, лоўк, _sosp, _zawy
  { {0x6e6702b6,0xf487002b,0x9e96002b,0xd904002b}},	//   нтаж, _ثانی, چاقچ, _گی_
  { {0x66c50030,0xc7d7000a,0x61ed1b7f,0xddcf0535}},	//   lókr, תולי_, _ugal, _racł
  { {0xd9040086,0xac271b80,0xdd94054f,0x7ae91b81}},	// [2eb0] _دی_, ефек, гаты, _riet
  { {0xd140005c,0x22b60024,0x7ae91b82,0xda67002b}},	//   żący_, māka_, _siet, کائي
  { {0x22b60024,0x7ae91b83,0xf413004c,0x7d041b84}},	//   lāka_, _piet, רפע_, apis
  { {0xe9f8005e,0xc333004f,0x0000006a,0x0000006a}},	//   енці_, טוע_,   ,
  { {0x273a0111,0xe8f80484,0x7ae91b85,0xddcf002a}},	//   eën_, елі_, _viet, _wacł
  { {0x5c14002b,0x7ae9002a,0x49b80067,0x2ca5001a}},	//   _مظفر, _wiet, راند_, _öld_
  { {0x648d002e,0x6b8300c0,0x98140087,0x7ae91b86}},	//   _búin, ängd, ابها, _tiet
  { {0xdddd0048,0x0f580008,0x22b60024,0xb9250015}},	//   _nosū, תיהם_, kāka_, _لفري
  { {0x648d002f,0x765b0d40,0xf505009b,0x0000006a}},	//   _dúin, rduy, ъзпо,
  { {0xb4cb005d,0x23750015,0x99d40015,0xa5440015}},	//   लते_, ناجح, _إتفا, اضيو
  { {0xdc88000a,0xb767005e,0x648d0125,0x6c56000a}},	//   גְרָ, _ятай, _fúin, דיתא_
  { {0x3dc6002a,0xddcd06f2,0x7d041b87,0x0000006a}},	//   żowi_, zjaš, ypis,
  { {0xe2971b88,0x66090801,0x22b6003d,0x5bbe0065}},	//   тая_, mbek, gāka_, _ऍड्व
  { {0xbcfb0003,0xdb080030,0xd00f0015,0x93bc0045}},	//   _prén, őlép, يلُ_, rgăr
  { {0xc0590010,0x12aa0029,0x3f8c0107,0xd7f100a1}},	//   хіў_, _يدعى_, ádu_, _lão_
  { {0xe3e80053,0x7d04016f,0x601f0061,0xbcfb1b89}},	//   _אַפֿ, tpis, _açmı, _créo
  { {0x1ea90029,0x7bd504ed,0xf1de000b,0xee37006b}},	// [2ec0] رافي_, _azzu, नेशन, ънт_
  { {0x0cbe014e,0x7d040049,0x9cb30015,0x2a6d0247}},	//   ्तेम, rpis, لمقت, _aneb_
  { {0x91f6000b,0x26df0091,0x20181b8a,0x64410012}},	//   _इलाज_, kmuo_, mari_, ifli
  { {0xca750010,0xba290029,0xfa890127,0x8b23004a}},	//   лучы, فسهم_, нсій_, рдце
  { {0xdb0e00c0,0xf1bf0030,0x26df0091,0x5c34002b}},	//   _nybö, lgár_, dmuo_, _مکاز
  { {0x66d50007,0xd90d0086,0xfc030fe4,0xc19b000a}},	//   _išky, سیم_, _впро, ושני
  { {0xf0930008,0x22b60024,0x20180251,0xe757005e}},	//   שנו_, zāka_, iari_, вищі_
  { {0x3eb21b8b,0x6b8307fd,0x20181b8c,0xdb1c002a}},	//   nnyt_, änge, hari_, _wzró
  { {0xd9460124,0xa3e4005d,0x20181b8d,0x15130033}},	//   _јези, पेन_, kari_, адыя
  { {0x3eb200f2,0xb8f6021e,0x98e60015,0x93780004}},	//   hnyt_, सत_, _شكاو, ебот_
  { {0x53340010,0x66091b8e,0x20181b8f,0xdddd0091}},	//   ыент, bbek, dari_, _posū
  { {0x22b60024,0x558a0661,0x268a0015,0x20131b90}},	//   tāka_, _обем_, _تخطي_, _sexi_
  { {0x20180705,0x2499003d,0x75291b91,0x1677004f}},	//   fari_, ūsma_, crez, _שגדל_
  { {0x9f35042b,0x22b6003d,0x3d16000b,0xf3661797}},	//   легі, rāka_, _पौधे_, _атин
  { {0x22b60024,0xbcfb0003,0x6437004c,0x645d003d}},	//   sāka_, _préo, _סאהא_, ēsit
  { {0x2018166f,0xceb80054,0x5eb40ef5,0x26c41b92}},	//   aari_, вљу_, айст, nomo_
  { {0x2018000c,0x3f9e001a,0xd2b8000a,0xd578000a}},	// [2ed0] bari_, útur_, _שלחת_, עָֽר
  { {0x6609003f,0x653b0008,0x8c590015,0x20181b93}},	//   zbek, ועמד, علاء_, cari_
  { {0x6ce4005e,0x26c41b94,0x7529036d,0x0000006a}},	//   ріте, komo_, zrez,
  { {0x3e040063,0xddcd0089,0xc3330008,0x6e950015}},	//   _вярв, zdař, שוף_, _إلحا
  { {0xe29c000a,0x26c41b95,0xf9900040,0x6b830123}},	//   ושאר, domo_, يبه_, ängb
  { {0x08c4017f,0x7c870785,0x99d400e5,0x475903fc}},	//   абін, _руме, جتما, ерия_
  { {0xf6510029,0x46a50063,0x648d002d,0x2bc80912}},	//   مئة_, лакв, _dúil, _ауто_
  { {0x75291b96,0x8579000d,0xc6190002,0x3ea9127a}},	//   trez, есот_, رتبط_, niat_
  { {0xd4151561,0x20180508,0x59b7005d,0x66091b97}},	//   льны, yari_, _आखिर, rbek
  { {0x1309005f,0x478b0063,0x75291b98,0xf992000a}},	//   нной_, _осем_, rrez, _הרמ_
  { {0x3eb2022d,0xe4c80029,0xb6350015,0x26cd0077}},	//   ynyt_, خبين_, _مفاع, pleo_
  { {0xbcfb0152,0xfbd20008,0x26c41b99,0x75291b9a}},	//   _prél, מתי_, como_, prez
  { {0xe56e0124,0x04450b75,0x3ea91b9b,0x361a000a}},	//   _уз_, _белн, diat_, _נוסד
  { {0x03190015,0x291f0573,0x291d01d7,0xbcfb0003}},	//   _كتبت_, _mvua_, iswa_, _crém
  { {0xb4c1000b,0x73c50015,0xc4d2000a,0x20181b9c}},	//   ूती_, _حيثم, _הגג_, rari_
  { {0x20181b9d,0xc332000a,0xe3b00067,0x22b6003d}},	//   sari_, _הוה_, _بره_, māko_
  { {0x8d661292,0x22b60024,0xc5f2000a,0xa3e7000b}},	// [2ee0] ывае, lāko_, מדן_, _मृत_
  { {0x26c4003f,0x219b00a3,0xc19b000a,0xbcfb0247}},	//   zomo_, _נביא, _נשיי, _grém
  { {0x26c4000c,0x0c370029,0x22b60024,0x4b261179}},	//   yomo_, اكمة_, nāko_, умев
  { {0x3ea91b9e,0x648d0125,0x7e5600af,0x0000006a}},	//   ciat_, _súil, _стоц,
  { {0x22920046,0x38140033,0xc237000a,0x38c8002b}},	//   ušky_, амлё, ראנז_, پاشی_
  { {0x61d70008,0x7bf8000a,0x6e360091,0xdca600af}},	//   נוסף_, _יִֽה, lgyb, _саги
  { {0x38cb0086,0x37a7006b,0x26c41b9f,0x57460058}},	//   راهی_, лтън_, tomo_, اختف
  { {0x7f3b0053,0x212b0026,0x21200263,0xa7fc0061}},	//   געקו, yrch_, _ovih_, _anıt
  { {0x18360002,0x3f8a01b2,0x7afb00bc,0x7826006e}},	//   _مراح, hybu_, _čuti, _معضل
  { {0x4438018b,0xb9930029,0xb80a0029,0x26c4003f}},	//   ür_, _الكب, _أيام_, somo_
  { {0xf8b3000a,0xa3d40033,0x22b6003d,0x212b0034}},	//   _פשע_, ронч, gāko_, wrch_
  { {0x92580080,0x7ae211b6,0xc7d7004f,0x623502ed}},	//   гают_, nmot, _גובי_, шему
  { {0x3ea908e0,0x212b00b8,0xd6df002a,0xa5070054}},	//   viat_, urch_, ółem_, _беча_
  { {0xe3a40086,0x3ea9005c,0x22b60024,0x6d560026}},	//   _پشتی, wiat_, bāko_, dwya
  { {0x92950010,0x7ae200c0,0xd7b8000a,0x22b6003d}},	//   _вайц, kmot, דֶּך, cāko_
  { {0x5e580191,0x6db5027a,0x201e001a,0x25a90085}},	//   лися_, айбу, ótir_, _žali_
  { {0xfc67006b,0x3ea91ba0,0x7c15005e,0x7ae21ba1}},	// [2ef0] лъжн, riat_, идає, dmot
  { {0xb8820046,0x25d7000a,0x3ea91ba2,0x6e360030}},	//   říjm, רומן_, siat_, agyb
  { {0x75eb0014,0x6ffa000a,0x50b80015,0xef67006b}},	//   _közü, _בהתפ, _حديد_, _съпо
  { {0xeaae0036,0x4e79004c,0x3f7a004c,0x628f0079}},	//   ій_, _סאָצ, _סארס, nkco
  { {0xfe360053,0xd9440029,0x224900e8,0x89370015}},	//   _דארך_, مئوي, _mbak_, اعصا
  { {0xf77100e6,0x98e40015,0xd705006b,0xe0fc000a}},	//   قاب_, مكنو, азки, עלול
  { {0x1038004c,0xdd0e0061,0x66f1003d,0xa7fc0061}},	//   אטום_, _kışl, _nākt, _anıs
  { {0x31690050,0xa3de0089,0x22b60024,0xada6006f}},	//   _oraz_, _běží_, vāko_, slúž
  { {0x98750036,0xef19002a,0x60c70dd2,0x3a7404bb}},	//   _клац, ąży_, kojm, _ултр
  { {0x66f10048,0x26130092,0x22b60024,0x25db000b}},	//   _sāku, ảo_, tāko_, खेगी_
  { {0x2120010b,0xe3b10029,0x798b0026,0x29000045}},	//   _svih_, ترة_, lygw, ţiat_
  { {0x91e618dc,0x61fa0046,0x22b6003d,0x95550015}},	//   ионе, ětlo, rāko_, _نختا
  { {0x6f05002d,0x661b00f2,0x51ba01b0,0x15f40058}},	//   _athc, mauk, тыня_, _اسمح
  { {0x859a0008,0x7ae212b8,0x661b1ba3,0xf8a70015}},	//   _בשנו, zmot, lauk, زة_
  { {0x44fb020a,0x23760086,0xafe60248,0xa0670054}},	//   _hê_, _نمود_, ровл, јаса_
  { {0x44fb0023,0x75eb0064,0xddd60033,0xeef50033}},	//   _kê_, _gözü, аўзэ, сярэ
  { {0xdd0e0064,0x6e361ba4,0x20d6008b,0x8d63005e}},	// [2f00] _dışl, rgyb, _вінс, овте
  { {0x6e360026,0x44fb1ba5,0x61db000a,0x6d560034}},	//   sgyb, _mê_, _בקפד, rwya
  { {0x907b0008,0x66f10024,0x394d00da,0x44fb1ba6}},	//   _סטטי, _māks, _apes_, _lê_
  { {0x6b8300c0,0x4fbb00f3,0x7bce0227,0x661b1ba7}},	//   änga, _יציא, _vybu, jauk
  { {0x09b0005d,0x7bce005c,0x88e60457,0xb9570015}},	//   जपेय, _wybu, ажде, لجوء_
  { {0x9915008f,0x66f1003d,0xe8380033,0x7ae21ba8}},	//   сьці, _nāks, упкі_, smot
  { {0x7c470030,0xa09b000a,0x7ae2055e,0x78aa1ba9}},	//   ésrő, כיסט, pmot, rifv
  { {0x44fb1baa,0x3546170d,0x661b1bab,0x628402b9}},	//   _bê_, ахов, gauk, _noio
  { {0x66f10024,0x245b0007,0xa5070004,0x0000006a}},	//   _sākt, kšmė_, аења_,
  { {0x44fb1bac,0x75eb0061,0x07a607c3,0xa818000a}},	//   _dê_, _sözü, _казн, _תֵּי
  { {0x2bf70008,0x8c1b0008,0x57fb0135,0x9cd7000a}},	//   ימין_, כויי, _סלאו, שויה_
  { {0x1546005e,0x7a410030,0x661b01d7,0x5b7b000a}},	//   _ведм, mátó, cauk, דרטא
  { {0x628f0079,0xddd6002a,0xe1ff010d,0x7a410030}},	//   rkco, ndyń, rcó_, látó
  { {0xd59b000a,0x160e000b,0xe1ff1bad,0x351b004f}},	//   _שֹׁכ, सरकर_, scó_, _יודנ
  { {0x3169005c,0xe3af0029,0x60c7002c,0x4ea719bf}},	//   _wraz_, _يرى_, rojm, араа
  { {0x3169016e,0xf1a70e3f,0xf239009b,0x0000006a}},	//   _traz_, _врон, _спиш_,
  { {0x7c070015,0xd657000a,0x44fb0016,0x0000006a}},	// [2f10] لباك, סימת_, _xê_,
  { {0x70550074,0xcc740124,0xb0350054,0xfc330015}},	//   _اندا, огућ, _унош, تحر_
  { {0x07f20053,0x6a170015,0x6ec70015,0x9f580046}},	//   _װאָס_, لبشر, _نتحق, obrý_
  { {0x99d90029,0x539b000a,0xdfd1009a,0x660201ec}},	//   هواء_, כיבו, _ويک_, _nfok
  { {0x661b09e2,0x644a002a,0xc238004f,0xfaa80058}},	//   vauk, _obfi, שרדו_, جهني_
  { {0x88c80191,0x31580053,0xfc670063,0x78470010}},	//   алів_, יידן_, _тъмн, рэдж
  { {0xbb850029,0xab950029,0x44fb00dd,0x661b00f2}},	//   _الزي, _الأغ, _sê_, tauk
  { {0x66f10024,0xcfb80008,0xe7080015,0xbcfb0003}},	//   _sāks, ילוי_, جتون_, _préh
  { {0x05680083,0x6aa9003f,0x661b1bae,0xa3e40231}},	//   ајќи_, _imef, rauk, पेस_
  { {0x661b0048,0x88550008,0x44fb1baf,0xc8240015}},	//   sauk, _לֹ֣א_, _vê_, _وفقً
  { {0x97a70010,0x661b00f2,0x44fb0026,0xe6430061}},	//   _трал, pauk, _wê_, şmış
  { {0xc7b20008,0xf0890643,0x92b60015,0x44fb1bb0}},	//   _צבא_, _אנ_, إحدا, _tê_
  { {0xd6c60074,0xe3b10086,0x3076005e,0xf505004a}},	//   _امنی, ترک_, бувс, _узло
  { {0xbcfb002d,0xb97a0008,0xa06a0001,0x03a8002b}},	//   _gréi, אנשי, ћава_, ادیو_
  { {0x141a0008,0xdfd200e5,0xf852006f,0x8416000a}},	//   _עוקב, سير_, ážiť_, _הקצב_
  { {0xb21b0134,0xed5a1bb1,0xee37070c,0xbea30b27}},	//   skær, лоб_, йнс_, паск
  { {0x6cd60029,0xf1a90086,0xa2c5000b,0x6b831bb2}},	// [2f20] مقرا, _پايه_, रवर्, ängn
  { {0x8db50036,0xcc290029,0x317b000a,0x4c830190}},	//   істі, لأمم_, _ערימ, плув
  { {0x6d5d1bb3,0x0b461310,0xeb2a011e,0x0000006a}},	//   _essa, снен, ужел_,
  { {0x2f5b0008,0xc332000f,0x8aa5005e,0x0136000a}},	//   _עדכנ, לוב_, орід, ֶרֶת_
  { {0x823b0053,0xda650070,0x44270160,0x0000006a}},	//   רענצ, تالي, _odn_,
  { {0x3cf1002c,0x6c860029,0x515b000a,0x7189000a}},	//   ľovú_, _الآم, טכנו, יְצַ
  { {0x6d441bb4,0xb8ff000b,0x9f580077,0xeb9a07be}},	//   ltia, _धी_, mbró_, _сив_
  { {0xddcd0064,0x7e641bb5,0x22af0046,0xfbb7000a}},	//   ndaş, ndip, křka_, _הפלת_
  { {0x7a4100dc,0x6d441a0e,0x661d001a,0x8aab004f}},	//   sátó, ntia, ðska, _עֹלֶ
  { {0x6d44002d,0x0000006a,0x0000006a,0x0000006a}},	//   itia,   ,   ,
  { {0x6c7b004c,0