/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef HELPERS_H
#define HELPERS_H



//This will not really happen if the sample is 16 bits, as it
//will be removed by the optimizer

#define DEPTH_SHIFT ( (sizeof(Depth)==1) ? 8 : 0 )


/* Since all resamplers will most likely share this, and this is the most critical section
  of the code (besides i cannot trust the compiler for inlining this properly)
  I am forced to go with a macro scheme to share the common parts of te resampling process.
*/

//need local variables in the stack, as the stack will be cached in a single cache line.
#define HELPER_INITIALIZE \
										\
		/*Precision template */						\
		Uint8 fractional_size=mixdata->fractional_size;			\
        	Depth *data_ptr=(Depth*)mixdata->sample->get_data_16();         \
		data_ptr+=mixdata->sample_offset >> fractional_size;		\
		sample_t *dest_buffer=mixdata->dst_buff;			\
		/* Data handler */						\
        	register Sint32 final_data;                                     \
		register float final_float;					\
        	float send_l=mixdata->l_volume;                                \
        	float send_r=mixdata->r_volume;  				\
        	float send_l_prev=mixdata->l_volume_prev;                      \
        	float send_r_prev=mixdata->r_volume_prev;  			\
        	Sint32 segment_offset=mixdata->sample_offset&( ((Sint64)1<<(Sint64)fractional_size)-1); \
        	Sint32 increment=mixdata->increment;				\
        	/* Filter Setup */                                              \
		float hist_a1=mixdata->filter.hist_a1;				\
		float hist_a2=mixdata->filter.hist_a2;				\
		float hist_b1=mixdata->filter.hist_b1;				\
		float hist_b2=mixdata->filter.hist_b2;				\
		float pre_filter;						\
		float f_a1=mixdata->filter.coeffs.a1;	                        \
		float f_a2=mixdata->filter.coeffs.a2;			\
		float f_b0=mixdata->filter.coeffs.b0;	                        \
		float f_b1=mixdata->filter.coeffs.b1;	                        \
		float f_b2=mixdata->filter.coeffs.b2;			\
        	                                                                \
        	/* Ramp Setup */                                                \
		float ramp_l_base=(float)(send_l-send_l_prev)/(float)mixdata->samples_to_mix; \
		float ramp_r_base=(float)(send_r-send_r_prev)/(float)mixdata->samples_to_mix; \
		float ramp_l=ramp_l_base;                          \
		float ramp_r=ramp_r_base;                          \
		send_l=send_l_prev;				\
		send_r=send_r_prev;				\
		int sample_increment_threshold=(abs(increment)>>fractional_size)?1:((1<<fractional_size)/abs(increment));	\
		sample_increment_threshold+=5;	 /*just in case?*/		\
        	                                                                \
        	Uint32 samples_to_mix=mixdata->samples_to_mix;                  \
		if ((int)sample_increment_threshold>(int)samples_to_mix) sample_increment_threshold=samples_to_mix;

/* Using 8 simply to allow for more complex interpolation methods */

#define CHECK_END_OF_SAMPLE_AT_MIX_END  ((mixdata->increment>0) && ( (((Sint64)mixdata->sample_offset+((Sint64)mixdata->increment*(Sint64)samples_to_mix))>>fractional_size) >= (Uint64)(mixdata->sample->get_size()-sample_increment_threshold)))
#define CHECK_END_OF_SAMPLE_AT_MIX_BEGIN ((mixdata->increment<0) && ( (((Sint64)mixdata->sample_offset)>>fractional_size) >= (Uint64)(mixdata->sample->get_size()-sample_increment_threshold)))

#define HELPER_BEGIN_LOOP	\
				\
		while(samples_to_mix--) {




#define HELPER_PERFORM_DEPTH_SHIFT 	\
					\
			final_data<<=DEPTH_SHIFT;	\
			final_float=(float)final_data / 32768.0;

#define HELPER_PERFORM_VOLUME_RAMP 	\
					\
			send_l+=ramp_l; 		\
			send_r+=ramp_r; 		

#define HELPER_PERFORM_FILTERING 	\
					\
		/* This will also be removed if compiling with no filter version */				\
			if (FILTER_VERSION) {										\
				pre_filter=final_float;											\
				final_float = (final_float * f_b0 + hist_b1 * f_b1  + hist_b2 * f_b2 + hist_a1 * f_a1 + hist_a2 * f_a2); 	\
				hist_a2=hist_a1;                                                             		\
				hist_b2=hist_b1;                                                             		\
				hist_b1=pre_filter;			\
				hist_a1=final_float;			\
			}

#define HELPER_PERFORM_MIXDOWN 	\
                                \
			*dest_buffer++ += send_l * final_float;					\
			*dest_buffer++ += send_r * final_float;                              	\
			segment_offset+=increment;                                		\

#define HELPER_END_LOOP	\
                        \
		}


#define HELPER_MIX_ONE_RAW_SAMPLE \
	final_data=data_ptr[segment_offset>>fractional_size];	\
	HELPER_PERFORM_DEPTH_SHIFT				\
	HELPER_PERFORM_VOLUME_RAMP				\
        HELPER_PERFORM_FILTERING				\
	HELPER_PERFORM_MIXDOWN





#define HELPER_UPDATE_MIXDATA_STATUS	\
					\
		mixdata->filter.hist_a1=hist_a1;        						\
		mixdata->filter.hist_a2=hist_a2;                                                   \
		mixdata->filter.hist_b1=hist_b1;        						\
		mixdata->filter.hist_b2=hist_b2;                                                   \
		mixdata->sample_offset+=segment_offset;                                           \



#endif


