/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          interface_widget_envelope_options.cpp  -  description
                             -------------------
    begin                : Fri Mar 29 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_envelope_options.h"

Interface_widget_envelope_options::Interface_widget_envelope_options(){

	lfo=NULL;
	envelope=NULL;
	
	updating=false;
	envelope_editor = new Envelope_Editor;
	checkbutton_loop = new Gtk::CheckButton("Loop");
	chckbutton_sustain = new Gtk::CheckButton("Sustain");
	label177 = new Gtk::Label("Begin:");
	label178 = new Gtk::Label("End:");
	label179 = new Gtk::Label("Begin:");
	label180 = new Gtk::Label("end:");
	hseparator145 = new Gtk::HSeparator();
	hseparator146 = new Gtk::HSeparator();
	spnbutton_begin_adj = new Gtk::Adjustment(0, 0, 100, 1, 10, 10);
	spnbutton_begin = new Gtk::SpinButton(*spnbutton_begin_adj, 1, 0);
	spinbutton_end_adj = new Gtk::Adjustment(1, 0, 100, 1, 10, 10);
	spinbutton_end = new Gtk::SpinButton(*spinbutton_end_adj, 1, 0);
	spinbutton_sus_begin_adj = new Gtk::Adjustment(1, 0, 100, 1, 10, 10);
	spinbutton_sus_begin = new Gtk::SpinButton(*spinbutton_sus_begin_adj, 1, 0);
	spinbutton_sus_end_adj = new Gtk::Adjustment(1, 0, 100, 1, 10, 10);
	spinbutton_sus_end = new Gtk::SpinButton(*spinbutton_sus_end_adj, 1, 0);
	label181 = new Gtk::Label("LFO Delay(ms): ");
	spinbutton_lfo_delay_adj = new Gtk::Adjustment(0, 0, 10, 0.01, 1, 1);
	spinbutton_lfo_delay = new Gtk::SpinButton(*spinbutton_lfo_delay_adj, 1, 2);
	hbox49 = new Gtk::HBox(false, 0);
	label182 = new Gtk::Label("LFO Wave: ");
	option_lfo_wave = new Gtk::OptionMenu();
	hbox50 = new Gtk::HBox(false, 0);
	label183 = new Gtk::Label("LFO Speed:");
	spinbutton_lfo_speed_adj = new Gtk::Adjustment(1, 1, 127, 1, 10, 10);
	spinbutton_lfo_speed = new Gtk::SpinButton(*spinbutton_lfo_speed_adj, 1, 0);
	hbox51 = new Gtk::HBox(false, 0);
	label184 = new Gtk::Label("LFO Depth:");
	spinbutton_lfo_depth_adj = new Gtk::Adjustment(0, 0, 127, 1, 10, 10);
	spinbutton_lfo_depth = new Gtk::SpinButton(*spinbutton_lfo_depth_adj, 1, 0);
	hbox52 = new Gtk::HBox(false, 0);
	checkbutton_lfo_sync = new Gtk::CheckButton("LFO Sync");
	checkbutton_enable = new Gtk::CheckButton("Enable");
	checkbutton_lfo_enabled = new Gtk::CheckButton("LFO Enable");
	hbox87 = new Gtk::HBox(false, 0);
	table34 = new Gtk::Table(3, 6, false);
	label295 = new Gtk::Label("Fadeout:");
	spinbutton186_adj = new Gtk::Adjustment(0, 0, 100, 1, 10, 10);
	spinbutton186 = new Gtk::SpinButton(*spinbutton186_adj, 1, 0);
	hseparator220 = new Gtk::HSeparator();
	hbox90 = new Gtk::HBox(false, 0);
	vbox17 = new Gtk::VBox(false, 0);
	
//envelope_editor->set_alignment(0.5, 0.5);
//   envelope_editor->set_padding(0, 0);
   label177->set_alignment(0, 0.5);
   label177->set_padding(0, 0);
   label178->set_alignment(0, 0.5);
   label178->set_padding(0, 0);
   label179->set_alignment(0, 0.5);
   label179->set_padding(0, 0);
   label180->set_alignment(0, 0.5);
   label180->set_padding(0, 0);
   spnbutton_begin->set_editable(true);
   spinbutton_end->set_editable(true);
   spinbutton_sus_begin->set_editable(true);
   spinbutton_sus_end->set_editable(true);
   label181->set_alignment(0.5, 0.5);
   label181->set_padding(0, 0);
   spinbutton_lfo_delay->set_usize(66, -1);
   spinbutton_lfo_delay->set_editable(true);
   spinbutton_lfo_delay->set_digits(2);
   hbox49->pack_start(*label181, false, false, 0);
   hbox49->pack_start(*spinbutton_lfo_delay);
   label182->set_alignment(0.5, 0.5);
   label182->set_padding(0, 0);
   {

      Gtk::Menu *_m(new Gtk::Menu());
      Gtk::MenuItem *_mi;
      _mi = manage(new Gtk::MenuItem("Sine"));
      _m->append(*_mi);
      _mi->show();
      _mi->set_user_data((gpointer)0);
      _mi = manage(new Gtk::MenuItem("Saw"));
      _m->append(*_mi);
      _mi->show();
      _mi->set_user_data((gpointer)1);
      _mi = manage(new Gtk::MenuItem("Square"));
      _m->append(*_mi);
      _mi->show();
      _mi->set_user_data((gpointer)2);
      _mi = manage(new Gtk::MenuItem("Noise"));
      _m->append(*_mi);
      _mi->show();
      _mi->set_user_data((gpointer)3);
      _m->set_active(0);
      option_lfo_wave->set_menu(*_m);
   }
   hbox50->pack_start(*label182, false, false, 0);
   hbox50->pack_end(*option_lfo_wave, false, false, 0);
   label183->set_alignment(0.5, 0.5);
   label183->set_padding(0, 0);
   spinbutton_lfo_speed->set_editable(true);
   hbox51->pack_start(*label183, false, false, 0);
   hbox51->pack_start(*spinbutton_lfo_speed);
   label184->set_alignment(0.5, 0.5);
   label184->set_padding(0, 0);
   spinbutton_lfo_depth->set_editable(true);
   hbox52->pack_start(*label184, false, false, 0);
   hbox52->pack_start(*spinbutton_lfo_depth);
   hbox87->pack_start(*checkbutton_enable, false, false, 0);
   hbox87->pack_start(*checkbutton_lfo_enabled, false, false, 0);
   table34->attach(*checkbutton_loop, 0, 1, 0, 1, GTK_FILL, 0, 0, 0);
   table34->attach(*chckbutton_sustain, 2, 3, 0, 1, GTK_FILL, 0, 0, 0);
   table34->attach(*label177, 0, 1, 1, 2, GTK_FILL, 0, 0, 0);
   table34->attach(*label178, 0, 1, 2, 3, GTK_FILL, 0, 0, 0);
   table34->attach(*label179, 2, 3, 1, 2, GTK_FILL, 0, 0, 0);
   table34->attach(*label180, 2, 3, 2, 3, GTK_FILL, 0, 0, 0);
   table34->attach(*hseparator145, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
   table34->attach(*hseparator146, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
   table34->attach(*spnbutton_begin, 1, 2, 1, 2, 0, 0, 0, 0);
   table34->attach(*spinbutton_end, 1, 2, 2, 3, 0, 0, 0, 0);
   table34->attach(*spinbutton_sus_begin, 3, 4, 1, 2, 0, 0, 0, 0);
   table34->attach(*spinbutton_sus_end, 3, 4, 2, 3, 0, 0, 0, 0);
   table34->attach(*hbox49, 4, 5, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
   table34->attach(*hbox50, 4, 5, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
   table34->attach(*hbox51, 5, 6, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
   table34->attach(*hbox52, 5, 6, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
   table34->attach(*checkbutton_lfo_sync, 5, 6, 0, 1, GTK_FILL, 0, 0, 0);
   table34->attach(*hbox87, 4, 5, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
   label295->set_alignment(0.5, 0.5);
   label295->set_padding(0, 0);
   spinbutton186->set_editable(true);
   hbox90->pack_start(*label295, false, false, 0);
   hbox90->pack_start(*spinbutton186, false, false, 0);
   hbox90->pack_start(*hseparator220);
   vbox17->pack_start(*envelope_editor);
   vbox17->pack_start(*table34, false, false, 0);
   vbox17->pack_start(*hbox90, false, false, 0);
   pack_start(*vbox17);
   envelope_editor->show();
   checkbutton_loop->show();
   chckbutton_sustain->show();
   label177->show();
   label178->show();
   label179->show();
   label180->show();
   hseparator145->show();
   hseparator146->show();
   spnbutton_begin->show();
   spinbutton_end->show();
   spinbutton_sus_begin->show();
   spinbutton_sus_end->show();
   label181->show();
   spinbutton_lfo_delay->show();
   hbox49->show();
   label182->show();
   option_lfo_wave->show();
   hbox50->show();
   label183->show();
   spinbutton_lfo_speed->show();
   hbox51->show();
   label184->show();
   spinbutton_lfo_depth->show();
   hbox52->show();
   checkbutton_lfo_sync->show();
   checkbutton_enable->show();
   checkbutton_lfo_enabled->show();
   hbox87->show();
   table34->show();
   label295->show();
   spinbutton186->show();
   hseparator220->show();
   hbox90->show();
   vbox17->show();
   show();

   envelope_editor->set_events(GDK_POINTER_MOTION_MASK|GDK_BUTTON_PRESS_MASK|GDK_BUTTON_RELEASE_MASK|GDK_ENTER_NOTIFY_MASK|GDK_LEAVE_NOTIFY_MASK|GDK_KEY_PRESS_MASK);


   checkbutton_loop->toggled.connect(SigC::slot((this), &Interface_widget_envelope_options::on_checkbutton_loop_toggled));
   chckbutton_sustain->toggled.connect(SigC::slot((this), &Interface_widget_envelope_options::on_chckbutton_sustain_toggled));
   spnbutton_begin->changed.connect(SigC::slot((this), &Interface_widget_envelope_options::on_spnbutton_begin_changed));
   spinbutton_end->changed.connect(SigC::slot((this), &Interface_widget_envelope_options::on_spinbutton_end_changed));
   spinbutton_sus_begin->changed.connect(SigC::slot((this), &Interface_widget_envelope_options::on_spinbutton_sus_begin_changed));
   spinbutton_sus_end->changed.connect(SigC::slot((this), &Interface_widget_envelope_options::on_spinbutton_sus_end_changed));
   spinbutton_lfo_delay->changed.connect(SigC::slot((this), &Interface_widget_envelope_options::on_spinbutton_lfo_delay_changed));
   spinbutton_lfo_speed->changed.connect(SigC::slot((this), &Interface_widget_envelope_options::on_spinbutton_lfo_speed_changed));
   spinbutton_lfo_depth->changed.connect(SigC::slot((this), &Interface_widget_envelope_options::on_spinbutton_lfo_depth_changed));
   spinbutton186->changed.connect(SigC::slot((this), &Interface_widget_envelope_options::on_spinbutton_fadeout_changed));

   checkbutton_lfo_sync->toggled.connect(SigC::slot((this), &Interface_widget_envelope_options::on_checkbutton_lfo_sync_toggled));
   checkbutton_enable->toggled.connect(SigC::slot((this), &Interface_widget_envelope_options::on_checkbutton_enable_toggled));
   checkbutton_lfo_enabled->toggled.connect(SigC::slot((this), &Interface_widget_envelope_options::on_checkbutton_lfo_enabled_toggled));
   	
   envelope_editor->button_press_event.connect(slot(this,&Interface_widget_envelope_options::on_envelope_editor_clicked));
//   envelope_editor.key_press_event.connect(slot(this,&Interface::on_envelope_instruments_volume_key_pressed));
   envelope_editor->changed.connect(slot(this,&Interface_widget_envelope_options::update));
   	
	
}

void Interface_widget_envelope_options::update_spin_rules() {

	spnbutton_begin_adj->set_upper(envelope->loop_end_node);
	spnbutton_begin_adj->set_lower(0);
	
	spinbutton_end_adj->set_upper(envelope->node.size()-1);
	spinbutton_end_adj->set_lower(envelope->loop_begin_node);
	
	spinbutton_sus_begin_adj->set_upper(envelope->sustain_loop_end_node);
	spinbutton_sus_begin_adj->set_lower(0);
	
	spinbutton_sus_end_adj->set_upper(envelope->node.size()-1);
	spinbutton_sus_end_adj->set_lower(envelope->sustain_loop_begin_node);
	
}






void Interface_widget_envelope_options::update() {

	updating=true;

	if (envelope) {
	
		checkbutton_loop->set_active(envelope->loop_on);
		checkbutton_enable->set_active(envelope->on);
		chckbutton_sustain->set_active(envelope->sustain_loop_on);
	
		update_spin_rules();
		
		spnbutton_begin->set_value(envelope->loop_begin_node);
		spinbutton_end->set_value(envelope->loop_end_node);
		spinbutton_sus_begin->set_value(envelope->sustain_loop_begin_node);
		spinbutton_sus_end->set_value(envelope->sustain_loop_end_node);
		
		spinbutton186->set_value(envelope->fadeout);
	}

	if (lfo) {
		
		spinbutton_lfo_speed->set_value(lfo->speed);
		spinbutton_lfo_delay->set_value((float)lfo->delay/100.0);
	
		spinbutton_lfo_depth->set_value(lfo->depth);
	
		checkbutton_lfo_sync->set_active(lfo->sync);
		checkbutton_lfo_enabled->set_active(lfo->enable);
	
	}	
	
	
	updating=false;

}


void Interface_widget_envelope_options::on_spinbutton_fadeout_changed() {

	if (updating) return;

	envelope->fadeout=spinbutton186->get_value_as_int();

}

void Interface_widget_envelope_options::on_checkbutton_loop_toggled() {

	if (updating) return;

	envelope->loop_on=checkbutton_loop->get_active();
	envelope_editor->queue_draw();

}
void Interface_widget_envelope_options::on_chckbutton_sustain_toggled() {

	if (updating) return;

	envelope->sustain_loop_on=chckbutton_sustain->get_active();
	envelope_editor->queue_draw();

}
void Interface_widget_envelope_options::on_spnbutton_begin_changed() {

	if (updating) return;

	envelope->loop_begin_node=spnbutton_begin->get_value_as_int();
	update_spin_rules();
	envelope_editor->queue_draw();
	

}
void Interface_widget_envelope_options::on_spinbutton_end_changed() {

	if (updating) return;

	envelope->loop_end_node=spinbutton_end->get_value_as_int();
	update_spin_rules();
	envelope_editor->queue_draw();


}
void Interface_widget_envelope_options::on_spinbutton_sus_begin_changed() {

	if (updating) return;

	envelope->sustain_loop_begin_node=spinbutton_sus_begin->get_value_as_int();
	update_spin_rules();
	envelope_editor->queue_draw();


}
void Interface_widget_envelope_options::on_spinbutton_sus_end_changed() {

	if (updating) return;

	envelope->sustain_loop_end_node=spinbutton_sus_end->get_value_as_int();
	update_spin_rules();
	envelope_editor->queue_draw();
	
}
void Interface_widget_envelope_options::on_spinbutton_lfo_delay_changed() {

	if (updating) return;

	lfo->delay=spinbutton_lfo_delay_adj->get_value()*100.0;

}
void Interface_widget_envelope_options::on_spinbutton_lfo_speed_changed() {

	if (updating) return;

	lfo->speed=spinbutton_lfo_speed->get_value_as_int();
}
void Interface_widget_envelope_options::on_spinbutton_lfo_depth_changed() {

	if (updating) return;

	lfo->depth=spinbutton_lfo_depth->get_value_as_int();
}
void Interface_widget_envelope_options::on_checkbutton_lfo_sync_toggled() {

	if (updating) return;

	lfo->sync=checkbutton_lfo_sync->get_active();
}
void Interface_widget_envelope_options::on_checkbutton_enable_toggled() {

	if (updating) return;

	envelope->on=checkbutton_loop->get_active();
	envelope_editor->queue_draw();
	
}
void Interface_widget_envelope_options::on_checkbutton_lfo_enabled_toggled() {

	if (updating) return;

	lfo->enable=checkbutton_lfo_enabled->get_active();
	
}


void Interface_widget_envelope_options::set_envelope(Envelope *p_envelope) {

	envelope=p_envelope;
	envelope_editor->set_envelope(p_envelope);

	update();
	
}
void Interface_widget_envelope_options::set_LFO(LFO *p_lfo) {

	lfo=p_lfo;
	update();
}


gint Interface_widget_envelope_options::on_envelope_editor_clicked(GdkEventButton* event) {

	switch (event->button) {

		case 1: {

			envelope_editor->attempt_node_grab(event->x,event->y);
		} break;

		case 2: {

			envelope_editor->start_zoom(event->x,event->y);
		} break;

		case 3: {

			envelope_editor->delete_selected_node();
		} break;

	}

	return 0;
}


Interface_widget_envelope_options::~Interface_widget_envelope_options(){
}
