image {
  resolution 640 480
  aa 1 1
  samples 4
  filter gaussian
}

camera {
  type thinlens
  eye    -0.754123 -340.443 73.6866
  target 1.17265 -29.155 59.1488
  up     0 0 1
  fov    47
  aspect 1.333333
  fdist  320
  lensr  9
}

light {
  type sunsky
  up 0 0 1
  east 0 1 0
  sundir 1 -1 0.31
  turbidity 2
  samples 16
}

shader {
  name ground.shader
  type diffuse
  diff 0.5 0.5 0.5
}


object {
  shader ground.shader
  type plane
  p 0 0 0
  n 0 0 1
}


shader {
  name 3---Default
  type shiny
  diff 0.490196 0.909804 0
  refl 0.1
}

shader {
  name 7---Default
  type diffuse
  diff 1 1 1
}

shader {
  name 1---Default
  type shiny
  diff 0.0352941 0.619608 1
  refl 0.1
}

shader {
  name 2---Default
  type shiny
  diff 1 0.870588 0
  refl 0.1
}

object {
  shader 3---Default
  type mesh
  name Sphere01
  5469 10320
  v 9.12482 -25.8656 107.225    0.19626 -0.456562 0.867775    0 0
  v 15.7221 -21.6807 107.221    0.314302 -0.3142 0.895819    0 0
  v 19.3194 -16.0369 107.279    0.38288 -0.1209 0.915853    0 0
  v 19.3783 -10.0775 107.225    0.392252 0.106262 0.913699    0 0
  v 15.6074 -4.22276 107.292    0.307236 0.319018 0.896568    0 0
  v 9.12481 -0.0192098 107.225    0.19626 0.456562 0.867775    0 0
  v 15.6118 -35.5597 97.0649    0.262129 -0.735408 0.62487    0 0
  v 27.4685 -28.5938 97.0565    0.505637 -0.54262 0.670742    0 0
  v 34.3014 -18.5243 102.673    -0.273778 0.0818378 0.958305    0 0
  v 34.0825 -8.26898 97.0404    0.665175 0.217747 0.714233    0 0
  v 27.4639 2.47861 97.0612    0.521273 0.521647 0.675395    0 0
  v 15.6118 9.67482 97.0649    0.262129 0.735408 0.62487    0 0
  v 20.0726 -41.6422 84.4709    0.260169 -0.913633 0.312389    0 0
  v 34.9632 -32.9702 84.5349    0.666491 -0.623169 0.409207    0 0
  v 42.9847 -19.8872 84.4835    0.87797 -0.280209 0.388137    0 0
  v 42.878 -6.24639 84.5738    0.871768 0.26858 0.409737    0 0
  v 34.5454 6.53686 84.5118    0.639656 0.694814 0.328746    0 0
  v 19.5336 15.2725 84.5105    0.321288 0.912704 0.252478    0 0
  v 20.7931 -41.9764 69.245    0.289254 -0.922756 -0.254664    0 0
  v 36.8116 -33.0215 69.718    0.688154 -0.664177 -0.292085    0 0
  v 44.9922 -19.8972 69.5609    0.925937 -0.306959 -0.220037    0 0
  v 44.9922 -5.98761 69.5609    0.925938 0.306958 -0.220037    0 0
  v 36.1864 6.54454 69.5609    0.637358 0.738883 -0.218693    0 0
  v 20.4418 15.2261 69.5512    0.313767 0.923207 -0.221899    0 0
  v 16.5209 -35.1725 56.0335    0.255152 -0.671139 -0.696039    0 0
  v 28.4678 -28.3972 56.1425    0.433947 -0.497364 -0.751212    0 0
  v 35.3673 -18.4582 56.1425    0.550673 -0.180701 -0.814927    0 0
  v 35.3673 -7.42667 56.1425    0.550673 0.180701 -0.814927    0 0
  v 28.4678 2.51238 56.1425    0.433947 0.497364 -0.751212    0 0
  v 16.1583 9.37679 56.1403    0.238947 0.698952 -0.674071    0 0
  v 7.50106 -25.881 47.5221    0.198243 -0.467564 -0.861443    0 0
  v 12.8679 -21.9139 47.5221    0.296243 -0.276046 -0.914352    0 0
  v 15.9146 -16.1443 47.5221    0.326794 -0.087213 -0.941063    0 0
  v 15.9146 -9.74053 47.5221    0.326794 0.087213 -0.941063    0 0
  v 12.8679 -3.97093 47.5221    0.296243 0.276046 -0.914352    0 0
  v 7.50106 -0.00383633 47.5221    0.198243 0.467564 -0.861443    0 0
  v 36.2014 -21.8545 99.9867    -0.013484 -0.967395 0.252911    0 0
  v 40.1235 -19.4871 97.1437    0.913808 -0.282385 -0.291914    0 0
  v 38.0003 -16.2663 100.012    0.349026 0.883653 0.31199    0 0
  v 46.8951 -22.2005 113.968    -0.780349 0.171978 0.601232    0 0
  v 47.7509 -23.6142 113.184    -0.216436 -0.968164 -0.125751    0 0
  v 49.5463 -22.5776 112.561    0.730802 -0.147462 -0.666471    0 0
  v 48.4726 -21.1421 113.407    0.170293 0.98357 0.0599236    0 0
  v 48.9501 -23.0503 119.096    -0.955537 0.284536 -0.0773836    0 0
  v 50.9626 -26.0743 117.593    -0.35865 -0.709639 -0.606451    0 0
  v 55.0014 -23.8205 116.563    0.285361 0.0242313 -0.958114    0 0
  v 52.537 -20.7535 118.202    -0.0968928 0.873668 -0.476777    0 0
  v 49.3774 -23.2423 121.885    -0.875798 0.205473 0.43676    0 0
  v 52.3813 -27.7459 119.656    -0.237683 -0.937249 -0.255091    0 0
  v 58.4144 -24.3733 118.107    0.573837 -0.0760021 -0.815435    0 0
  v 54.7518 -19.8073 120.556    0.0499419 0.985845 -0.160051    0 0
  v 52.2665 -23.8004 125.048    -0.485631 0.0453773 0.872985    0 0
  v 55.1743 -28.1603 122.889    -0.00333474 -0.957352 0.288906    0 0
  v 61.0138 -24.8964 121.39    0.942349 -0.241828 -0.231294    0 0
  v 57.4675 -20.4758 123.761    0.277113 0.875111 0.396722    0 0
  v 56.2586 -24.4157 125.99    -0.00590275 -0.112291 0.993658    0 0
  v 57.572 -26.344 125.024    0.23241 -0.623921 0.746128    0 0
  v 60.1058 -24.9094 124.379    0.714859 -0.282226 0.639785    0 0
  v 58.5688 -22.9597 125.413    0.401727 0.302261 0.864439    0 0
  v 9.36977 1.95135 41.5883    0.381083 0.877835 0.290141    0 0
  v 15.9925 -2.62445 41.5899    0.674628 0.65395 0.342385    0 0
  v 19.6395 -8.56243 41.6162    0.883635 0.255277 0.392457    0 0
  v 18.6653 -16.6293 45.232    0.218609 -0.0479805 0.974632    0 0
  v 15.8206 -23.4699 41.6092    0.66894 -0.65967 0.342571    0 0
  v 9.36977 -27.8362 41.5883    0.381083 -0.877835 0.290141    0 0
  v 10.2646 2.9406 33.5791    0.394361 0.918571 0.0265706    0 0
  v 17.4635 -2.0922 33.5794    0.73385 0.678921 0.0230329    0 0
  v 21.338 -9.00965 33.5716    0.967055 0.253953 0.0176604    0 0
  v 21.3985 -16.7888 33.2879    0.968136 -0.250257 0.0092036    0 0
  v 17.4597 -23.7926 33.5701    0.734758 -0.677891 0.0243804    0 0
  v 10.2646 -28.8254 33.5791    0.394361 -0.918571 0.0265706    0 0
  v 9.69069 2.28468 25.0062    0.387615 0.898614 -0.20554    0 0
  v 16.5124 -2.53142 25.0062    0.718779 0.65229 -0.240573    0 0
  v 20.207 -9.26099 25.0062    0.932072 0.241422 -0.270106    0 0
  v 20.207 -16.6239 25.0062    0.932072 -0.241423 -0.270106    0 0
  v 16.5124 -23.3534 25.0062    0.718778 -0.65229 -0.240573    0 0
  v 9.69069 -28.1695 25.0062    0.387615 -0.898615 -0.20554    0 0
  v 7.91072 0.250435 17.9815    0.335365 0.76269 -0.553023    0 0
  v 13.5727 -3.81137 17.9815    0.585824 0.52704 -0.615662    0 0
  v 16.7614 -9.69373 17.9793    0.725804 0.185477 -0.662425    0 0
  v 16.9392 -16.2215 18.076    0.741751 -0.191094 -0.642875    0 0
  v 13.5705 -22.0694 17.9793    0.585933 -0.525855 -0.616571    0 0
  v 7.91072 -26.1353 17.9815    0.335365 -0.76269 -0.553023    0 0
  v 4.81901 -3.19439 14.1073    0.217589 0.421988 -0.880103    0 0
  v 8.44367 -6.03647 14.0763    0.306752 0.277276 -0.910506    0 0
  v 10.818 -10.2631 14.087    0.364121 0.100074 -0.92596    0 0
  v 13.7585 -15.8844 14.6436    0.916525 -0.233706 -0.324596    0 0
  v 8.34765 -20.0026 14.0721    0.302559 -0.286497 -0.909053    0 0
  v 4.81901 -22.6905 14.1073    0.21759 -0.421989 -0.880102    0 0
  v 3.99515 -8.63112 12.5313    0.119487 0.0869803 -0.989018    0 0
  v 5.42087 -11.305 12.5523    0.146197 0.0380917 -0.988522    0 0
  v 5.07554 -14.5284 12.4696    0.13215 -0.0334477 -0.990665    0 0
  v 3.97243 -17.272 12.5283    0.117633 -0.0878613 -0.989163    0 0
  v 19.1245 -20.1954 41.9671    0.386655 -0.89533 0.221091    0 0
  v 21.5584 -16.9774 38.3151    0.79211 -0.210432 -0.572957    0 0
  v 20.9248 -13.2986 41.9044    0.704041 0.656028 0.271944    0 0
  v 23.4299 -16.9852 44.8807    0.133289 0.0403885 0.990254    0 0
  v 23.1682 -19.5406 42.2788    0.0136732 -0.998652 0.0500725    0 0
  v 24.2419 -17.2353 39.0919    -0.0888317 -0.0537975 -0.994593    0 0
  v 24.43 -14.6287 41.8955    0.156936 0.987428 -0.0189043    0 0
  v 28.3718 -17.485 43.2136    0.533998 0.0330831 0.844838    0 0
  v 27.2943 -19.7851 41.1224    -0.0737253 -0.995331 0.0622946    0 0
  v 27.0526 -17.6819 38.0848    -0.564271 -0.0304754 -0.825027    0 0
  v 28.05 -15.2383 40.4402    0.184933 0.978955 -0.0862967    0 0
  v 32.1074 -18.1965 39.5996    0.810857 0.0731531 0.580654    0 0
  v 30.5111 -20.1415 38.4049    -0.0222691 -0.997607 0.0654491    0 0
  v 29.2178 -18.3384 36.0405    -0.734744 -0.103546 -0.670396    0 0
  v 30.8609 -16.3447 37.3911    0.192195 0.961243 -0.197671    0 0
  v 33.5378 -18.6516 36.3777    0.997082 -0.01176 -0.0754272    0 0
  v 32.3148 -19.8784 36.0093    0.239163 -0.897953 -0.369434    0 0
  v 31.035 -18.7176 34.8524    -0.177798 -0.289287 -0.940585    0 0
  v 32.2983 -17.4813 35.2704    0.363557 0.661844 -0.655583    0 0
  v 10.2201 -17.6388 13.4668    0.036809 -0.862096 -0.505406    0 0
  v 8.17089 -15.2101 12.6184    -0.377782 0.0876883 -0.921733    0 0
  v 11.32 -13.3875 13.4381    0.269515 0.761226 -0.589828    0 0
  v 14.1248 -16.0945 10.9558    0.958572 -0.222583 0.177755    0 0
  v 11.3182 -17.4616 10.4803    -0.129772 -0.991152 0.0278766    0 0
  v 9.64812 -15.5799 10.1039    -0.939784 0.219906 -0.261626    0 0
  v 12.1625 -14.1836 10.327    0.129769 0.987114 -0.0936293    0 0
  v 14.5428 -16.4666 6.32056    0.971275 -0.229341 0.0634566    0 0
  v 11.9546 -17.719 5.96867    -0.128534 -0.991058 0.0358289    0 0
  v 10.4044 -15.9947 5.68852    -0.960347 0.226092 -0.163145    0 0
  v 12.7237 -14.7173 5.79949    0.127575 0.985711 -0.10999    0 0
  v 14.5541 -16.7437 2.56142    0.967346 -0.237603 -0.0882368    0 0
  v 12.4358 -17.7726 2.2556    -0.106263 -0.988183 -0.110461    0 0
  v 11.1575 -16.3548 2.04254    -0.902394 0.199574 -0.38191    0 0
  v 13.0649 -15.3085 2.1164    0.145291 0.959115 -0.242876    0 0
  v 13.9608 -16.7676 0.977822    0.665216 -0.207447 -0.717254    0 0
  v 12.9238 -17.2817 0.831119    0.0338334 -0.67246 -0.739359    0 0
  v 12.2682 -16.5715 0.719038    -0.401201 0.0489557 -0.914681    0 0
  v 13.2345 -16.0529 0.761266    0.188105 0.541826 -0.819171    0 0
  v 25.3668 -40.7155 80.7996    0.542735 -0.839896 -0.00375026    0 0
  v 26.0003 -40.809 73.4452    0.534848 -0.83262 0.14381    0 0
  v 33.7834 -36.5506 73.6764    0.438543 -0.890515 0.121092    0 0
  v 32.865 -36.4098 80.9545    0.442493 -0.896769 -0.00253319    0 0
  v 25.6994 -38.7863 80.0815    0.752069 -0.0425741 -0.657708    0 0
  v 26.1704 -38.8819 73.9699    0.644097 0.0249728 0.764536    0 0
  v 32.5912 -35.3822 74.2187    -0.702942 -0.129022 0.699447    0 0
  v 31.8757 -35.2249 80.2475    -0.583032 -0.191604 -0.789533    0 0
  v 26.3814 -33.3639 79.0008    0.76494 -0.500593 -0.405307    0 0
  v 26.7538 -33.4405 74.5896    0.695303 -0.462774 0.549904    0 0
  v 31.3615 -30.9044 74.7584    -0.296047 -0.689644 0.660869    0 0
  v 30.8755 -30.7981 79.1316    -0.205446 -0.726798 -0.655406    0 0
  v 12.2997 -42.1633 63.1305    0.165456 -0.87268 -0.459407    0 0
  v 1.31948 -27.415 107.169    3.76637e-007 -0.535496 0.844538    0 0
  v 1.31948 -11.8449 110.865    2.63838e-007 0.0092209 0.999957    0 0
  v 1.31948 -6.94617 110.473    6.98755e-009 0.189752 0.981832    0 0
  v 1.31948 -37.9784 97.0649    -4.16366e-007 -0.794846 0.606811    0 0
  v 1.31948 12.0935 97.0649    4.1963e-009 0.794846 0.606811    0 0
  v 1.31948 -44.1849 84.5127    0 -0.974221 0.225597    0 0
  v 1.31948 18.3521 69.5184    4.71564e-008 0.974637 -0.223791    0 0
  v 1.31948 10.8007 54.5622    0.042249 0.813646 -0.579824    0 0
  v 1.31948 -27.2189 47.5221    1.86473e-009 -0.912699 0.408633    0 0
  v 1.31948 1.74241 47.5221    0.106861 0.545852 -0.831039    0 0
  v 1.31948 3.60952 41.5883    1.86585e-009 0.964505 0.264064    0 0
  v 1.31948 4.76021 33.5791    7.46402e-009 0.999701 0.0244478    0 0
  v 1.31948 3.99748 25.0062    -1.10063e-007 0.98186 -0.189609    0 0
  v 1.31948 -29.8823 25.0062    -1.68826e-007 -0.98186 -0.189609    0 0
  v 1.31948 -2.29134 14.1502    4.73118e-008 0.527146 -0.849775    0 0
  v 1.31948 -20.5149 12.8047    -2.79664e-009 -0.249513 -0.968372    0 0
  v 1.31948 -43.0334 63.205    4.6603e-010 -0.92636 -0.376639    0 0
  v -6.48585 -25.8656 107.225    -0.19626 -0.456562 0.867775    0 0
  v -12.9728 -35.5597 97.0649    -0.262129 -0.735408 0.62487    0 0
  v -24.6691 -28.7451 97.052    -0.504555 -0.541359 0.672574    0 0
  v -12.9286 -21.6939 107.32    -0.299401 -0.324395 0.897289    0 0
  v -33.392 -22.0221 99.9828    0.00381561 -0.95444 0.298378    0 0
  v -31.0508 -18.3549 102.697    0.15649 0.139631 0.97776    0 0
  v -16.3793 -15.9933 107.487    -0.372402 -0.119101 0.920397    0 0
  v -32.8645 -13.8806 97.228    -0.51507 0.665131 0.540651    0 0
  v -32.332 -11.3362 97.0212    -0.682361 0.109167 0.722818    0 0
  v -16.663 -10.1928 107.339    -0.381248 0.119071 0.916772    0 0
  v -25.1572 1.87622 97.0598    -0.537208 0.501786 0.677952    0 0
  v -13.0214 -4.31533 107.292    -0.3119 0.315867 0.896073    0 0
  v -12.9728 9.67483 97.0649    -0.262129 0.735408 0.62487    0 0
  v -6.48585 -0.019209 107.225    -0.196259 0.456562 0.867775    0 0
  v 1.31948 1.53014 107.169    -3.35041e-007 0.535496 0.844538    0 0
  v -17.4337 -41.6422 84.4709    -0.260169 -0.913633 0.312389    0 0
  v -32.3218 -33.064 84.4664    -0.663709 -0.631822 0.400365    0 0
  v -40.4271 -19.9118 84.2721    -0.877629 -0.280405 0.388768    0 0
  v -37.4296 -19.3885 96.5746    -0.944151 -0.241868 -0.223781    0 0
  v -40.441 -6.38546 84.4584    -0.879002 0.271134 0.392226    0 0
  v -31.9834 6.40804 84.5117    -0.643132 0.687264 0.337713    0 0
  v -16.8946 15.2725 84.5105    -0.321288 0.912704 0.252478    0 0
  v 1.31948 18.3284 84.503    1.40066e-009 0.972983 0.230876    0 0
  v -34.1726 -33.0215 69.718    -0.688154 -0.664176 -0.292086    0 0
  v -42.3532 -19.8972 69.5609    -0.925937 -0.306958 -0.220037    0 0
  v -42.3533 -5.98761 69.5609    -0.925937 0.306959 -0.220037    0 0
  v -33.5474 6.54453 69.5609    -0.637358 0.738883 -0.218693    0 0
  v -17.8029 15.2261 69.5512    -0.313767 0.923207 -0.221899    0 0
  v -18.1542 -41.9764 69.245    -0.289254 -0.922756 -0.254664    0 0
  v -13.882 -35.1725 56.0335    -0.255152 -0.671139 -0.696038    0 0
  v -25.8288 -28.3972 56.1425    -0.433947 -0.497364 -0.751212    0 0
  v -32.7283 -18.4582 56.1425    -0.550673 -0.180701 -0.814927    0 0
  v -32.7283 -7.42667 56.1425    -0.550673 0.180701 -0.814927    0 0
  v -25.8288 2.51238 56.1425    -0.433947 0.497364 -0.751212    0 0
  v -13.5194 9.37679 56.1403    -0.238946 0.698952 -0.674071    0 0
  v -4.86209 -25.881 47.5221    -0.198243 -0.467564 -0.861443    0 0
  v -10.229 -21.9139 47.5221    -0.296243 -0.276046 -0.914352    0 0
  v -13.2756 -16.1443 47.5221    -0.326794 -0.087213 -0.941063    0 0
  v -13.2756 -9.74053 47.5221    -0.326794 0.087213 -0.941063    0 0
  v -10.229 -3.97093 47.5221    -0.296243 0.276046 -0.914352    0 0
  v -4.86209 -0.00383633 47.5221    -0.198243 0.467564 -0.861443    0 0
  v -53.6196 -24.4157 125.99    0.00590489 -0.112291 0.993658    0 0
  v -54.933 -26.344 125.024    -0.23241 -0.623922 0.746128    0 0
  v -57.4668 -24.9094 124.379    -0.71486 -0.282225 0.639785    0 0
  v -55.9299 -22.9597 125.413    -0.401727 0.302261 0.864438    0 0
  v -45.1119 -23.6142 113.184    0.216436 -0.968164 -0.125751    0 0
  v -44.1087 -22.143 113.791    0.783697 0.146794 0.603548    0 0
  v -46.7721 -22.5225 112.366    -0.726731 -0.177905 -0.663485    0 0
  v -45.133 -20.8352 112.481    -0.182008 0.980246 0.077407    0 0
  v -48.3236 -26.0743 117.593    0.358649 -0.709636 -0.606454    0 0
  v -46.3111 -23.0503 119.096    0.955537 0.284536 -0.077383    0 0
  v -52.3625 -23.8205 116.563    -0.28536 0.0242315 -0.958114    0 0
  v -49.8981 -20.7535 118.202    0.096892 0.873667 -0.476778    0 0
  v -49.7424 -27.7459 119.656    0.237683 -0.937249 -0.25509    0 0
  v -46.7384 -23.2423 121.885    0.875799 0.205475 0.436757    0 0
  v -55.7755 -24.3733 118.107    -0.573838 -0.0760031 -0.815434    0 0
  v -52.1129 -19.8073 120.556    -0.0499409 0.985845 -0.160051    0 0
  v -52.5353 -28.1603 122.889    0.00333496 -0.957351 0.288907    0 0
  v -49.6276 -23.8004 125.048    0.485631 0.0453775 0.872986    0 0
  v -58.3749 -24.8964 121.39    -0.942349 -0.241828 -0.231294    0 0
  v -54.8285 -20.4758 123.761    -0.277113 0.875111 0.396722    0 0
  v -13.3535 -2.62445 41.5899    -0.674628 0.65395 0.342385    0 0
  v -6.73081 1.95135 41.5883    -0.381083 0.877835 0.290141    0 0
  v -17.0006 -8.56243 41.6162    -0.883635 0.255277 0.392457    0 0
  v -16.0263 -16.6293 45.232    -0.218609 -0.047981 0.974632    0 0
  v -18.2858 -13.2986 41.9044    -0.704041 0.656028 0.271944    0 0
  v -13.1816 -23.4699 41.6092    -0.66894 -0.65967 0.342571    0 0
  v -16.4855 -20.1954 41.9671    -0.386656 -0.89533 0.221091    0 0
  v -6.73081 -27.8362 41.5883    -0.381083 -0.877835 0.290142    0 0
  v 1.31948 -29.4944 41.5883    1.39939e-009 -0.964505 0.264063    0 0
  v -14.8246 -2.0922 33.5794    -0.73385 0.678921 0.023033    0 0
  v -7.62565 2.9406 33.5791    -0.394361 0.918572 0.0265706    0 0
  v -18.6991 -9.00965 33.5716    -0.967055 0.253953 0.0176604    0 0
  v -18.9195 -16.9774 38.3151    -0.79211 -0.210433 -0.572957    0 0
  v -18.7595 -16.7888 33.2879    -0.968136 -0.250257 0.00920358    0 0
  v -14.8207 -23.7926 33.5701    -0.734758 -0.677891 0.0243804    0 0
  v -7.62565 -28.8254 33.5791    -0.394361 -0.918571 0.0265706    0 0
  v 1.31948 -30.6451 33.5791    0 -0.999701 0.0244478    0 0
  v -13.8734 -2.53142 25.0062    -0.718779 0.65229 -0.240572    0 0
  v -7.05172 2.28468 25.0062    -0.387615 0.898614 -0.20554    0 0
  v -17.568 -9.26099 25.0062    -0.932072 0.241422 -0.270105    0 0
  v -17.568 -16.6239 25.0062    -0.932072 -0.241423 -0.270105    0 0
  v -13.8734 -23.3534 25.0062    -0.718779 -0.65229 -0.240573    0 0
  v -7.05172 -28.1695 25.0062    -0.387615 -0.898614 -0.20554    0 0
  v -10.9338 -3.81137 17.9815    -0.585824 0.52704 -0.615662    0 0
  v -5.27176 0.250435 17.9815    -0.335365 0.762689 -0.553024    0 0
  v -14.1224 -9.69373 17.9792    -0.725804 0.185475 -0.662425    0 0
  v -14.3002 -16.2215 18.076    -0.741751 -0.191094 -0.642875    0 0
  v -10.9316 -22.0694 17.9793    -0.585932 -0.525855 -0.616571    0 0
  v -5.27176 -26.1353 17.9815    -0.335365 -0.76269 -0.553023    0 0
  v 1.31948 -27.5168 17.9815    3.69704e-007 -0.853896 -0.520444    0 0
  v -5.8047 -6.03647 14.0763    -0.306751 0.277275 -0.910507    0 0
  v -2.18004 -3.19439 14.1073    -0.217588 0.421988 -0.880103    0 0
  v -8.179 -10.2631 14.087    -0.364123 0.100076 -0.925959    0 0
  v -11.1195 -15.8844 14.6436    -0.916525 -0.233706 -0.324597    0 0
  v -8.681 -13.3875 13.4381    -0.269515 0.761229 -0.589824    0 0
  v -5.70868 -20.0026 14.0721    -0.302559 -0.286496 -0.909053    0 0
  v -7.5811 -17.6388 13.4668    -0.0368095 -0.862096 -0.505406    0 0
  v -2.18004 -22.6905 14.1073    -0.217588 -0.421988 -0.880103    0 0
  v 1.31948 -23.5935 14.1502    -2.33063e-010 -0.527148 -0.849774    0 0
  v -1.35618 -8.63112 12.5313    -0.119484 0.0869796 -0.989019    0 0
  v 1.31948 -7.81332 12.369    1.86996e-006 0.0943731 -0.995537    0 0
  v 1.31948 -5.36995 12.8047    -8.11026e-008 0.249515 -0.968371    0 0
  v -2.7819 -11.305 12.5523    -0.146197 0.0380917 -0.988522    0 0
  v -5.53193 -15.2101 12.6184    0.377784 0.0876882 -0.921732    0 0
  v -2.43657 -14.5284 12.4696    -0.132149 -0.0334476 -0.990665    0 0
  v -1.33347 -17.272 12.5283    -0.117631 -0.0878614 -0.989163    0 0
  v 1.31948 -18.0715 12.369    -5.22814e-006 -0.0943698 -0.995537    0 0
  v -30.8988 -18.6516 36.3777    -0.997082 -0.0117623 -0.0754286    0 0
  v -29.6758 -19.8784 36.0093    -0.239165 -0.897952 -0.369435    0 0
  v -28.3961 -18.7176 34.8524    0.177797 -0.289285 -0.940586    0 0
  v -29.6594 -17.4813 35.2704    -0.363553 0.661845 -0.655584    0 0
  v -20.5292 -19.5406 42.2788    -0.0136735 -0.998652 0.0500729    0 0
  v -20.791 -16.9852 44.8807    -0.133288 0.0403887 0.990254    0 0
  v -21.6029 -17.2353 39.0919    0.0888325 -0.0537987 -0.994593    0 0
  v -21.7911 -14.6287 41.8955    -0.156936 0.987428 -0.0189044    0 0
  v -24.6554 -19.7851 41.1224    0.0737262 -0.995331 0.062294    0 0
  v -25.7328 -17.485 43.2136    -0.533999 0.0330834 0.844837    0 0
  v -24.4136 -17.6819 38.0848    0.564272 -0.0304751 -0.825026    0 0
  v -25.411 -15.2383 40.4402    -0.184934 0.978955 -0.0862968    0 0
  v -27.8722 -20.1415 38.4049    0.0222699 -0.997607 0.0654497    0 0
  v -29.4685 -18.1965 39.5996    -0.810857 0.0731532 0.580654    0 0
  v -26.5789 -18.3384 36.0405    0.734744 -0.103548 -0.670395    0 0
  v -28.2219 -16.3447 37.3911    -0.192194 0.961243 -0.197671    0 0
  v -11.3219 -16.7676 0.977822    -0.665208 -0.207442 -0.717263    0 0
  v -10.2848 -17.2817 0.831112    -0.0338393 -0.672467 -0.739354    0 0
  v -9.62922 -16.5715 0.719038    0.4012 0.0489349 -0.914682    0 0
  v -10.5955 -16.0529 0.761273    -0.188107 0.54184 -0.819161    0 0
  v -8.67927 -17.4616 10.4803    0.129772 -0.991152 0.0278766    0 0
  v -11.4858 -16.0945 10.9558    -0.958572 -0.222582 0.177755    0 0
  v -7.00915 -15.5799 10.1039    0.939783 0.219906 -0.261627    0 0
  v -9.52352 -14.1836 10.327    -0.12977 0.987114 -0.0936292    0 0
  v -9.31562 -17.719 5.96867    0.128534 -0.991058 0.0358289    0 0
  v -11.9039 -16.4666 6.32056    -0.971275 -0.229341 0.0634569    0 0
  v -7.7654 -15.9947 5.68852    0.960347 0.226092 -0.163145    0 0
  v -10.0847 -14.7173 5.7995    -0.127575 0.985711 -0.10999    0 0
  v -9.79684 -17.7726 2.25562    0.106263 -0.988183 -0.11046    0 0
  v -11.9152 -16.7437 2.56143    -0.967346 -0.237604 -0.0882363    0 0
  v -8.51856 -16.3548 2.04254    0.902393 0.199576 -0.381911    0 0
  v -10.426 -15.3085 2.11641    -0.14529 0.959116 -0.242875    0 0
  v -23.3613 -40.809 73.4452    -0.534847 -0.832621 0.143809    0 0
  v -22.7278 -40.7155 80.7996    -0.542734 -0.839896 -0.00374991    0 0
  v -31.1444 -36.5506 73.6764    -0.438544 -0.890515 0.121092    0 0
  v -30.2261 -36.4098 80.9545    -0.442493 -0.896768 -0.00253184    0 0
  v -23.7424 -33.3639 79.0008    -0.764939 -0.500593 -0.405308    0 0
  v -24.1149 -33.4405 74.5896    -0.695302 -0.462775 0.549904    0 0
  v -28.7226 -30.9044 74.7584    0.296046 -0.689644 0.660869    0 0
  v -28.2365 -30.7981 79.1316    0.205445 -0.726798 -0.655406    0 0
  v -23.5314 -38.8819 73.9699    -0.644097 0.0249732 0.764536    0 0
  v -23.0604 -38.7863 80.0815    -0.752069 -0.0425753 -0.657708    0 0
  v -29.9522 -35.3822 74.2187    0.702941 -0.129023 0.699448    0 0
  v -29.2367 -35.2249 80.2475    0.583032 -0.191604 -0.789533    0 0
  v 1.31948 -38.4853 56.0476    1.25455e-007 -0.659112 -0.752045    0 0
  v 1.31948 -44.8033 70.6502    0 -0.994275 -0.106854    0 0
  v -9.66077 -42.1633 63.1305    -0.165456 -0.87268 -0.459406    0 0
  v 1.31948 -40.7534 58.5135    1.17307e-009 -0.969747 -0.244112    0 0
  v 1.31948 -18.9387 110.473    -3.66147e-007 -0.18975 0.981833    0 0
  v 1.31948 -16.1043 110.833    4.62107e-007 -0.0427774 0.999085    0 0
  v 1.31948 -14.04 110.865    2.65702e-007 -0.0092209 0.999957    0 0
  v 1.31948 -9.78051 110.833    4.65837e-007 0.0427774 0.999085    0 0
  v 1.31948 1.63198 17.9815    -2.42574e-007 0.853896 -0.520444    0 0
  v 1.31948 -38.5532 59.1495    0 -0.0331685 0.99945    0 0
  v 10.5945 -39.9689 62.9455    -0.936665 -0.0839964 -0.340005    0 0
  v 1.31948 -40.3721 62.0651    -9.34017e-010 0.00511513 -0.999987    0 0
  v -7.95554 -39.9689 62.9455    0.936665 -0.0839965 -0.340005    0 0
  v 1.31948 -29.9913 59.4986    -1.32321e-008 -0.163732 0.986505    0 0
  v 8.7561 -32.1616 62.2259    -0.738389 -0.557249 -0.37981    0 0
  v 1.31948 -31.2981 61.4669    5.64219e-009 -0.276309 -0.961069    0 0
  v -6.11713 -32.1616 62.2259    0.738389 -0.557249 -0.379808    0 0
  v 17.718 -28.6074 102.708    0.332884 -0.553619 0.763344    0 0
  v 26.7488 -21.3328 102.217    0.344024 -0.442986 0.827896    0 0
  v 29.229 -13.7341 102.212    0.46584 0.233758 0.853434    0 0
  v 25.2855 -4.78211 102.701    0.515167 0.307881 0.799883    0 0
  v 17.69 2.71385 102.725    0.3344 0.553645 0.762663    0 0
  v 7.07558 6.59857 102.711    0.116388 0.680839 0.723126    0 0
  v 25.3309 -35.5654 91.2302    0.429777 -0.728044 0.534082    0 0
  v 36.5525 -24.6053 91.9632    0.676182 -0.605281 0.420015    0 0
  v 40.0106 -13.8793 91.9581    0.870986 0.186808 0.454408    0 0
  v 36.303 -0.922949 91.0716    0.697741 0.43157 0.571756    0 0
  v 25.3353 9.66863 91.0633    0.443936 0.747441 0.494219    0 0
  v 9.78638 15.2157 91.0629    0.147872 0.878751 0.453796    0 0
  v 41.9115 -26.786 77.1882    0.848102 -0.514877 0.124998    0 0
  v 46.2528 -12.9665 77.184    0.987533 0.0010222 0.157406    0 0
  v 41.7356 0.975964 77.1698    0.820423 0.559124 0.119526    0 0
  v 29.0594 12.1687 77.1687    0.491313 0.869769 0.0459801    0 0
  v 11.115 18.372 77.1483    0.163925 0.986441 0.00787499    0 0
  v 27.0018 -35.3901 62.1606    0.421738 -0.733972 -0.532374    0 0
  v 38.59 -25.406 62.3419    0.683709 -0.472728 -0.555941    0 0
  v 42.7627 -12.9424 62.3401    0.808766 1.12488e-007 -0.588131    0 0
  v 38.5806 -0.486991 62.3401    0.682816 0.481974 -0.549057    0 0
  v 26.8748 9.50157 62.3394    0.420792 0.768457 -0.482087    0 0
  v 10.3353 15.0335 62.2977    0.142314 0.883111 -0.447059    0 0
  v 17.0546 -28.4544 51.4172    0.28377 -0.478638 -0.830891    0 0
  v 24.3846 -21.5527 51.4183    0.381709 -0.251498 -0.889408    0 0
  v 27.0064 -12.9424 51.4183    0.411183 1.60266e-007 -0.911553    0 0
  v 24.3846 -4.33219 51.4183    0.381709 0.251498 -0.889408    0 0
  v 17.0509 2.5705 51.4183    0.282787 0.481726 -0.829441    0 0
  v 6.82923 6.37296 51.3964    0.146158 0.611335 -0.777758    0 0
  v 58.4799 -24.7268 125.616    0.356868 -0.208118 0.910677    0 0
  v 41.4927 -21.493 107.266    -0.610348 -0.627039 0.484043    0 0
  v 43.469 -21.8456 105.666    0.33399 -0.871967 -0.357944    0 0
  v 44.1015 -19.7814 105.732    0.708149 0.655025 -0.263566    0 0
  v 42.1022 -19.5022 107.332    -0.256574 0.799738 0.54276    0 0
  v 49.1012 -24.2295 117.086    -0.827868 -0.557346 0.0632463    0 0
  v 51.859 -24.5905 115.91    0.200229 -0.691726 -0.693847    0 0
  v 52.5714 -22.1532 116.188    0.434513 0.673653 -0.597821    0 0
  v 49.8136 -21.7922 117.364    -0.510562 0.842103 0.173746    0 0
  v 49.344 -25.5925 119.691    -0.853187 -0.517541 -0.0649951    0 0
  v 54.6651 -26.2621 117.466    0.143122 -0.619725 -0.771659    0 0
  v 56.0573 -21.5864 117.998    0.317462 0.637011 -0.70245    0 0
  v 50.7361 -20.9168 120.223    -0.548103 0.836395 0.00515298    0 0
  v 50.9852 -26.5069 122.674    -0.631848 -0.629982 0.451543    0 0
  v 57.4831 -27.3187 119.957    0.354307 -0.833755 -0.423461    0 0
  v 59.189 -21.6112 120.604    0.608513 0.696345 -0.380547    0 0
  v 52.6911 -20.7994 123.321    -0.391666 0.78272 0.48368    0 0
  v 54.8647 -26.1721 125.25    -0.15056 -0.514382 0.844241    0 0
  v 59.1768 -26.7189 123.445    0.522938 -0.776369 0.351833    0 0
  v 60.3007 -22.9282 123.878    0.792663 0.38679 0.471253    0 0
  v 55.9887 -22.3815 125.683    -0.023138 0.389957 0.920542    0 0
  v 11.7615 -0.828174 44.7368    0.514798 0.719908 0.465527    0 0
  v 16.6255 -6.01155 44.7473    0.717011 0.407373 0.565634    0 0
  v 18.2932 -12.6727 45.0155    0.777297 0.0276544 0.628526    0 0
  v 16.461 -19.9043 45.0156    0.688285 -0.410153 0.598363    0 0
  v 11.7514 -25.0611 44.7439    0.51406 -0.719914 0.466332    0 0
  v 4.97308 -28.0508 44.7367    0.188571 -0.897861 0.397853    0 0
  v 13.8124 0.491973 37.7967    0.562983 0.808542 0.171201    0 0
  v 19.3793 -5.33642 37.7981    0.849139 0.497666 0.176895    0 0
  v 21.4565 -12.7537 37.774    0.988949 0.0874846 0.11969    0 0
  v 19.4546 -20.5376 37.774    0.820163 -0.564307 0.094286    0 0
  v 13.8088 -26.3803 37.7946    0.562337 -0.8094 0.169257    0 0
  v 5.75404 -29.8314 37.7966    0.197534 -0.968898 0.149055    0 0
  v 14.0292 0.631119 29.2297    0.572739 0.812619 -0.107796    0 0
  v 19.6374 -5.51194 29.2297    0.868973 0.477469 -0.130035    0 0
  v 21.5734 -12.9356 29.2228    0.990233 0.00247577 -0.139398    0 0
  v 19.6375 -20.3718 29.2227    0.86819 -0.47866 -0.130881    0 0
  v 14.0291 -26.516 29.2296    0.572757 -0.812609 -0.107776    0 0
  v 5.83721 -30.0298 29.2297    0.19859 -0.975633 -0.0932849    0 0
  v 12.4077 -0.486118 21.1642    0.539196 0.759506 -0.363894    0 0
  v 17.4764 -6.08647 21.1642    0.798316 0.435398 -0.416077    0 0
  v 19.254 -12.9444 21.1653    0.899383 0.0031709 -0.437149    0 0
  v 17.4788 -19.7978 21.1653    0.797832 -0.438602 -0.413633    0 0
  v 12.4077 -25.3987 21.1642    0.539226 -0.759458 -0.36395    0 0
  v 5.21704 -28.5237 21.1642    0.190712 -0.927823 -0.320582    0 0
  v 8.97031 -2.84746 15.6732    0.358905 0.494458 -0.791643    0 0
  v 12.9156 -7.28081 15.676    0.488491 0.264635 -0.831471    0 0
  v 14.3548 -13.0285 15.5689    0.583777 0.101973 -0.805485    0 0
  v 12.9357 -18.5611 15.5701    0.50356 -0.384683 -0.773593    0 0
  v 8.96827 -23.0389 15.6726    0.358737 -0.496147 -0.790662    0 0
  v 3.91519 -25.3649 15.6843    0.141488 -0.661633 -0.736358    0 0
  v 3.8332 -6.16287 12.8718    0.164302 0.214018 -0.962913    0 0
  v 6.89195 -8.92894 13.0254    0.230671 0.12228 -0.965318    0 0
  v 7.87181 -12.8773 12.9649    0.185597 0.106034 -0.976888    0 0
  v 6.80704 -17.0872 12.9636    0.134693 -0.198961 -0.970707    0 0
  v 3.82992 -19.7255 12.8715    0.163027 -0.214803 -0.962955    0 0
  v 2.48878 -22.0039 13.3638    0.0916302 -0.386256 -0.917829    0 0
  v 32.6524 -18.7744 35.0936    0.451553 -0.249031 -0.856787    0 0
  v 20.604 -18.7378 44.22    0.0583942 -0.691651 0.719868    0 0
  v 21.8826 -18.9408 40.0793    0.224167 -0.815595 -0.533437    0 0
  v 22.8929 -15.1646 39.9369    0.340802 0.690849 -0.637637    0 0
  v 21.6104 -14.9744 44.0775    0.200111 0.679425 0.70593    0 0
  v 25.5899 -18.8101 43.6685    0.151659 -0.712961 0.684606    0 0
  v 25.4005 -18.9613 39.8896    -0.250364 -0.782593 -0.569971    0 0
  v 26.089 -15.7587 39.5289    -0.138763 0.730811 -0.668326    0 0
  v 26.2784 -15.6074 43.3077    0.3154 0.724042 0.613421    0 0
  v 29.8776 -19.2774 41.2071    0.422215 -0.710606 0.562826    0 0
  v 28.3656 -19.3945 38.165    -0.491406 -0.773025 -0.401188    0 0
  v 28.7436 -16.5156 37.5694    -0.348408 0.719549 -0.600718    0 0
  v 30.2556 -16.3985 40.6115    0.607382 0.699298 0.376921    0 0
  v 32.7977 -19.6302 37.6018    0.625513 -0.711767 0.319564    0 0
  v 30.6402 -19.7006 35.9193    -0.354083 -0.829344 -0.432219    0 0
  v 30.708 -17.4514 35.2436    -0.308459 0.629565 -0.713093    0 0
  v 32.8655 -17.381 36.9261    0.689282 0.718911 0.0897603    0 0
  v 13.1695 -16.69 0.574299    0.140803 -0.0911965 -0.985829    0 0
  v 12.6133 -17.0545 12.7558    0.432922 -0.899879 0.0528869    0 0
  v 9.41963 -16.6635 11.8772    -0.670458 -0.651521 -0.354974    0 0
  v 10.0357 -14.2874 11.8145    -0.412458 0.82171 -0.393284    0 0
  v 13.2376 -14.6483 12.6932    0.714456 0.699368 -0.0209063    0 0
  v 13.3635 -17.2658 8.54064    0.42193 -0.901 0.100866    0 0
  v 10.4084 -16.9288 8.07788    -0.749178 -0.658513 -0.0713616    0 0
  v 10.9587 -14.7833 7.95914    -0.481434 0.860494 -0.166646    0 0
  v 13.9139 -15.1203 8.42191    0.696832 0.717184 -0.00854975    0 0
  v 13.6863 -17.5119 4.12475    0.429964 -0.901402 0.0510421    0 0
  v 11.0474 -17.2105 3.72169    -0.743839 -0.660079 -0.104876    0 0
  v 11.5373 -15.2963 3.61371    -0.477964 0.855755 -0.198076    0 0
  v 14.1763 -15.5976 4.01677    0.704308 0.706519 -0.0691437    0 0
  v 13.7098 -17.3755 1.40153    0.459025 -0.837858 -0.295448    0 0
  v 11.9439 -17.1719 1.13165    -0.572133 -0.57455 -0.585283    0 0
  v 12.2694 -15.8904 1.059    -0.377331 0.694698 -0.612385    0 0
  v 14.0353 -16.0939 1.32888    0.699807 0.57893 -0.418461    0 0
  v 22.8942 -42.1354 77.1279    0.290263 -0.95632 0.0346456    0 0
  v 30.1291 -38.5218 70.9676    0.470787 -0.847808 -0.244093    0 0
  v 35.9464 -34.8149 77.2926    0.692757 -0.713632 0.104006    0 0
  v 28.6968 -38.4254 83.4281    0.470097 -0.81817 0.331069    0 0
  v 28.7979 -30.6261 76.7921    0.479466 -0.875142 0.0651152    0 0
  v 24.7515 -40.9397 77.0558    0.966113 -0.246652 0.0760816    0 0
  v 29.7567 -38.4663 72.8097    0.206305 -0.443103 0.872409    0 0
  v 33.895 -35.8146 77.3488    -0.498287 -0.866136 -0.0389606    0 0
  v 28.8898 -38.2881 81.5948    0.312015 -0.506343 -0.803905    0 0
  v 24.848 -36.5091 76.8458    0.988558 -0.131133 0.0745471    0 0
  v 29.2992 -34.3109 73.0545    0.0300915 -0.133391 0.990606    0 0
  v 32.9832 -31.9491 77.1136    -0.957159 -0.269061 -0.107019    0 0
  v 28.532 -34.1474 80.9049    0.15598 -0.228886 -0.960875    0 0
  v 9.77929 -43.5514 66.1693    0.106022 -0.965864 -0.236358    0 0
  v 4.03349 -23.0583 109.27    0.0675378 -0.345595 0.93595    0 0
  v 7.07669 -19.3483 109.938    0.144356 -0.217206 0.965393    0 0
  v 9.80119 -16.3754 109.979    0.181006 -0.11187 0.977099    0 0
  v 10.7665 -12.9622 109.988    0.191502 0.00267721 0.981489    0 0
  v 9.77427 -9.51687 109.996    0.179278 0.105656 0.978109    0 0
  v 7.07554 -6.53672 109.939    0.143505 0.217781 0.96539    0 0
  v 4.03349 -2.82656 109.27    0.0675393 0.345592 0.935951    0 0
  v 7.07558 -32.4834 102.711    0.116388 -0.680839 0.723126    0 0
  v 9.79368 -41.1057 91.0634    0.142233 -0.877322 0.45834    0 0
  v 10.9666 -44.3733 77.2674    0.12827 -0.991033 0.0374105    0 0
  v 6.91989 -32.2106 51.3888    0.10461 -0.56365 -0.819363    0 0
  v 4.97308 2.17103 44.7367    0.202364 0.899924 0.386246    0 0
  v 5.75404 3.94657 37.7966    0.197534 0.968898 0.149055    0 0
  v 5.83721 4.14494 29.2297    0.19859 0.975633 -0.0932849    0 0
  v 5.21704 2.6389 21.1642    0.190712 0.927823 -0.320582    0 0
  v 3.91519 -0.51991 15.6843    0.141488 0.661632 -0.736359    0 0
  v 2.48878 -3.8809 13.3638    0.0916282 0.386255 -0.91783    0 0
  v -15.0356 -28.6124 102.734    -0.32898 -0.556985 0.762587    0 0
  v -22.9825 -21.4369 102.829    -0.353657 -0.43901 0.825952    0 0
  v -25.5944 -13.3934 102.834    -0.523746 0.180664 0.832496    0 0
  v -23.1322 -5.7969 102.737    -0.524289 0.297568 0.797856    0 0
  v -15.069 2.68215 102.725    -0.341156 0.549544 0.762636    0 0
  v -4.43661 6.59857 102.711    -0.116388 0.680839 0.723127    0 0
  v -22.689 -35.6035 91.2032    -0.425765 -0.731131 0.533078    0 0
  v -33.8109 -25.475 91.2515    -0.678853 -0.593715 0.432042    0 0
  v -37.8575 -13.2136 91.1708    -0.84133 0.124681 0.525945    0 0
  v -34.4136 -2.22355 91.0289    -0.70098 0.411671 0.58237    0 0
  v -22.7202 9.62786 91.0633    -0.450652 0.740868 0.498024    0 0
  v -7.14741 15.2157 91.0629    -0.147872 0.87875 0.453797    0 0
  v -39.2722 -26.8228 77.1589    -0.848567 -0.515617 0.118632    0 0
  v -43.6392 -12.9406 77.15    -0.988859 0.000501645 0.148852    0 0
  v -39.1176 0.943576 77.1685    -0.820046 0.559658 0.119611    0 0
  v -26.4212 12.1674 77.1687    -0.491705 0.869515 0.0465784    0 0
  v -8.47607 18.372 77.1483    -0.163925 0.986441 0.00787534    0 0
  v -24.3628 -35.3901 62.1606    -0.421738 -0.733972 -0.532374    0 0
  v -35.951 -25.406 62.3419    -0.683709 -0.472728 -0.555941    0 0
  v -40.1237 -12.9424 62.3401    -0.808765 -2.8075e-007 -0.588131    0 0
  v -35.9416 -0.486991 62.3401    -0.682816 0.481974 -0.549057    0 0
  v -24.2359 9.50157 62.3394    -0.420792 0.768457 -0.482087    0 0
  v -7.69637 15.0335 62.2977    -0.142313 0.883111 -0.447059    0 0
  v -14.4156 -28.4544 51.4172    -0.28377 -0.478637 -0.830892    0 0
  v -21.7457 -21.5527 51.4183    -0.381709 -0.251498 -0.889408    0 0
  v -24.3674 -12.9424 51.4183    -0.411183 -1.57936e-007 -0.911553    0 0
  v -21.7457 -4.3322 51.4183    -0.381709 0.251498 -0.889408    0 0
  v -14.412 2.5705 51.4183    -0.282787 0.481726 -0.829441    0 0
  v -4.19027 6.37296 51.3964    -0.146158 0.611335 -0.777758    0 0
  v -55.841 -24.7268 125.616    -0.35687 -0.208117 0.910676    0 0
  v -38.7703 -21.4825 107.247    0.606775 -0.609591 0.51012    0 0
  v -40.7928 -21.8687 105.587    -0.352666 -0.867299 -0.351309    0 0
  v -40.2232 -19.1241 103.764    -0.718676 0.662495 -0.211201    0 0
  v -37.9037 -18.851 105.719    0.199254 0.803371 0.561153    0 0
  v -46.4608 -24.2289 117.084    0.826071 -0.559986 0.0634205    0 0
  v -49.2187 -24.5899 115.908    -0.199404 -0.693829 -0.691983    0 0
  v -49.8888 -22.135 116.126    -0.463176 0.665796 -0.584964    0 0
  v -47.128 -21.7735 117.307    0.512891 0.831218 0.214522    0 0
  v -46.705 -25.5925 119.691    0.853187 -0.517541 -0.064995    0 0
  v -52.0261 -26.2621 117.466    -0.143123 -0.619725 -0.771658    0 0
  v -53.4183 -21.5864 117.998    -0.317462 0.637011 -0.70245    0 0
  v -48.0972 -20.9168 120.223    0.548103 0.836395 0.00515388    0 0
  v -48.3462 -26.5069 122.674    0.63185 -0.629981 0.451541    0 0
  v -54.8442 -27.3187 119.957    -0.354307 -0.833755 -0.423461    0 0
  v -56.5501 -21.6112 120.604    -0.608513 0.696344 -0.380548    0 0
  v -50.0521 -20.7994 123.321    0.391666 0.782721 0.48368    0 0
  v -52.2258 -26.1721 125.25    0.15056 -0.514382 0.844241    0 0
  v -56.5378 -26.7189 123.445    -0.522938 -0.776369 0.351833    0 0
  v -57.6618 -22.9282 123.878    -0.792663 0.386789 0.471253    0 0
  v -53.3497 -22.3815 125.683    0.0231398 0.389957 0.920542    0 0
  v -9.12256 -0.828174 44.7368    -0.514798 0.719908 0.465527    0 0
  v -13.9865 -6.01155 44.7473    -0.717012 0.407373 0.565634    0 0
  v -15.6542 -12.6727 45.0155    -0.777297 0.0276548 0.628526    0 0
  v -13.822 -19.9043 45.0156    -0.688286 -0.410153 0.598362    0 0
  v -9.11242 -25.0611 44.7439    -0.51406 -0.719914 0.466332    0 0
  v -2.33412 -28.0508 44.7367    -0.18857 -0.897861 0.397853    0 0
  v -11.1734 0.491973 37.7967    -0.562983 0.808542 0.171201    0 0
  v -16.7404 -5.33642 37.7981    -0.849139 0.497666 0.176895    0 0
  v -18.8176 -12.7537 37.774    -0.988949 0.0874853 0.11969    0 0
  v -16.8156 -20.5376 37.774    -0.820164 -0.564306 0.0942861    0 0
  v -11.1699 -26.3803 37.7946    -0.562337 -0.8094 0.169257    0 0
  v -3.11507 -29.8314 37.7966    -0.197534 -0.968898 0.149055    0 0
  v -11.3902 0.631119 29.2297    -0.572739 0.81262 -0.107796    0 0
  v -16.9985 -5.51194 29.2297    -0.868973 0.477469 -0.130036    0 0
  v -18.9344 -12.9356 29.2228    -0.990233 0.00247584 -0.139398    0 0
  v -16.9986 -20.3718 29.2227    -0.86819 -0.47866 -0.130881    0 0
  v -11.3902 -26.516 29.2296    -0.572757 -0.812609 -0.107776    0 0
  v -3.19825 -30.0298 29.2297    -0.19859 -0.975633 -0.0932851    0 0
  v -9.76871 -0.486117 21.1642    -0.539197 0.759505 -0.363894    0 0
  v -14.8374 -6.08647 21.1642    -0.798316 0.435398 -0.416077    0 0
  v -16.615 -12.9444 21.1653    -0.899383 0.00317098 -0.437149    0 0
  v -14.8398 -19.7978 21.1653    -0.797832 -0.438602 -0.413633    0 0
  v -9.76869 -25.3987 21.1642    -0.539225 -0.759458 -0.36395    0 0
  v -2.57808 -28.5237 21.1642    -0.190712 -0.927823 -0.320582    0 0
  v -6.33135 -2.84746 15.6732    -0.358905 0.494458 -0.791643    0 0
  v -10.2766 -7.28081 15.676    -0.488492 0.264634 -0.831471    0 0
  v -11.7158 -13.0285 15.5689    -0.583777 0.101975 -0.805485    0 0
  v -10.2967 -18.5611 15.57    -0.50356 -0.384683 -0.773593    0 0
  v -6.3293 -23.0389 15.6726    -0.358737 -0.496147 -0.790662    0 0
  v -1.27622 -25.3649 15.6843    -0.141489 -0.661632 -0.736359    0 0
  v -1.19424 -6.16287 12.8718    -0.164302 0.214018 -0.962913    0 0
  v -4.25298 -8.92894 13.0254    -0.230673 0.122281 -0.965317    0 0
  v -5.23285 -12.8773 12.9649    -0.185598 0.106032 -0.976888    0 0
  v -4.16808 -17.0872 12.9636    -0.134691 -0.19896 -0.970708    0 0
  v -1.19096 -19.7255 12.8715    -0.163028 -0.214802 -0.962955    0 0
  v 0.150184 -22.0039 13.3638    -0.0916326 -0.386256 -0.917829    0 0
  v -30.0134 -18.7744 35.0936    -0.451552 -0.249034 -0.856786    0 0
  v -17.965 -18.7378 44.22    -0.0583942 -0.691651 0.719868    0 0
  v -19.2436 -18.9408 40.0793    -0.224166 -0.815595 -0.533437    0 0
  v -20.254 -15.1646 39.9369    -0.340802 0.690849 -0.637637    0 0
  v -18.9715 -14.9744 44.0775    -0.200112 0.679426 0.705929    0 0
  v -22.9509 -18.8101 43.6685    -0.151659 -0.712961 0.684607    0 0
  v -22.7616 -18.9613 39.8896    0.250364 -0.782592 -0.569971    0 0
  v -23.45 -15.7587 39.5289    0.138762 0.73081 -0.668327    0 0
  v -23.6394 -15.6074 43.3077    -0.315401 0.724042 0.613421    0 0
  v -27.2386 -19.2774 41.2071    -0.422216 -0.710606 0.562826    0 0
  v -25.7266 -19.3945 38.165    0.491405 -0.773026 -0.401188    0 0
  v -26.1046 -16.5156 37.5694    0.348408 0.719549 -0.600718    0 0
  v -27.6166 -16.3985 40.6115    -0.607381 0.699298 0.376923    0 0
  v -30.1588 -19.6302 37.6018    -0.625512 -0.711768 0.319563    0 0
  v -28.0012 -19.7006 35.9193    0.354083 -0.829344 -0.432219    0 0
  v -28.069 -17.4514 35.2436    0.308457 0.629566 -0.713092    0 0
  v -30.2266 -17.381 36.9261    -0.689282 0.718911 0.0897601    0 0
  v -10.5305 -16.69 0.574293    -0.14081 -0.0911892 -0.985828    0 0
  v -9.97432 -17.0545 12.7558    -0.432922 -0.899879 0.0528869    0 0
  v -6.78066 -16.6635 11.8772    0.670457 -0.651522 -0.354973    0 0
  v -7.39673 -14.2874 11.8145    0.412457 0.821709 -0.393286    0 0
  v -10.5986 -14.6483 12.6932    -0.714455 0.699369 -0.020906    0 0
  v -10.7246 -17.2658 8.54064    -0.42193 -0.901 0.100866    0 0
  v -7.7694 -16.9288 8.07787    0.749178 -0.658513 -0.0713619    0 0
  v -8.31975 -14.7833 7.95915    0.481434 0.860494 -0.166646    0 0
  v -11.2749 -15.1203 8.42191    -0.696832 0.717184 -0.00854978    0 0
  v -11.0474 -17.5119 4.12475    -0.429964 -0.901402 0.0510422    0 0
  v -8.40841 -17.2106 3.72168    0.743839 -0.660079 -0.104876    0 0
  v -8.89833 -15.2963 3.61372    0.477963 0.855755 -0.198076    0 0
  v -11.5373 -15.5976 4.01678    -0.704309 0.706519 -0.0691436    0 0
  v -11.0708 -17.3755 1.40153    -0.459023 -0.837859 -0.295448    0 0
  v -9.30495 -17.1719 1.13165    0.572133 -0.574549 -0.585284    0 0
  v -9.6304 -15.8904 1.059    0.377331 0.6947 -0.612383    0 0
  v -11.3963 -16.0939 1.32888    -0.699803 0.578928 -0.41847    0 0
  v -20.2552 -42.1354 77.1279    -0.290263 -0.956319 0.034646    0 0
  v -27.4902 -38.5218 70.9676    -0.470787 -0.847808 -0.244094    0 0
  v -33.3074 -34.8158 77.2919    -0.691896 -0.714582 0.103207    0 0
  v -26.0578 -38.4263 83.4274    -0.469884 -0.818826 0.329748    0 0
  v -26.1589 -30.6261 76.7921    -0.479465 -0.875142 0.0651156    0 0
  v -22.1125 -40.9397 77.0558    -0.966113 -0.246652 0.0760818    0 0
  v -27.1177 -38.4663 72.8097    -0.206304 -0.443102 0.87241    0 0
  v -31.256 -35.8146 77.3488    0.49829 -0.866135 -0.0389611    0 0
  v -26.2508 -38.2881 81.5948    -0.312015 -0.506343 -0.803905    0 0
  v -22.2091 -36.5091 76.8458    -0.988558 -0.131132 0.0745461    0 0
  v -26.6602 -34.3109 73.0545    -0.0300917 -0.133391 0.990606    0 0
  v -30.3442 -31.9491 77.1136    0.957159 -0.26906 -0.107018    0 0
  v -25.893 -34.1474 80.9048    -0.155979 -0.228886 -0.960875    0 0
  v -3.55258 -40.7188 58.9233    -0.187522 -0.729974 -0.657247    0 0
  v -1.39453 -23.0583 109.27    -0.0675377 -0.345594 0.935951    0 0
  v -4.43605 -19.3485 109.939    -0.142891 -0.218198 0.965387    0 0
  v -7.11709 -16.3784 110.008    -0.173428 -0.109971 0.978687    0 0
  v -8.08286 -12.9489 110.021    -0.182903 0.00441654 0.983121    0 0
  v -7.1474 -9.54038 109.997    -0.178232 0.10765 0.978082    0 0
  v -4.4371 -6.53764 109.939    -0.143766 0.217601 0.965392    0 0
  v -1.39452 -2.82656 109.27    -0.0675393 0.345592 0.935951    0 0
  v -4.43662 -32.4834 102.711    -0.116389 -0.680839 0.723126    0 0
  v -7.15472 -41.1057 91.0634    -0.142233 -0.877322 0.45834    0 0
  v -8.32768 -44.3733 77.2674    -0.12827 -0.991033 0.0374105    0 0
  v -4.28092 -32.2106 51.3888    -0.10461 -0.563651 -0.819362    0 0
  v -2.33412 2.17103 44.7367    -0.202364 0.899924 0.386246    0 0
  v -3.11507 3.94657 37.7966    -0.197535 0.968898 0.149055    0 0
  v -3.19825 4.14494 29.2297    -0.19859 0.975633 -0.093285    0 0
  v -2.57808 2.6389 21.1642    -0.190712 0.927823 -0.320582    0 0
  v -1.27622 -0.51991 15.6843    -0.141488 0.661631 -0.736359    0 0
  v 0.150184 -3.8809 13.3638    -0.0916277 0.386254 -0.91783    0 0
  v 5.39873 -29.4588 60.9178    -0.12534 -0.879525 -0.459049    0 0
  v 7.8595 -41.0633 60.6516    -0.439787 -0.378989 0.81422    0 0
  v 7.95107 -42.2946 62.8557    0.131624 -0.318519 -0.938734    0 0
  v -5.3121 -42.2946 62.8557    -0.131624 -0.318519 -0.938734    0 0
  v -5.22053 -41.0633 60.6516    0.439787 -0.37899 0.81422    0 0
  v 7.45272 -34.6906 60.8308    -0.438624 -0.0381751 0.897859    0 0
  v 7.45272 -35.9289 62.7255    0.149171 -0.0439591 -0.987834    0 0
  v -4.81375 -35.9289 62.7255    -0.149171 -0.0439591 -0.987834    0 0
  v -4.81375 -34.6906 60.8308    0.438624 -0.0381752 0.897859    0 0
  v 1.31948 -12.9423 12.1921    -1.11905e-009 0.000690799 -1    0 0
  v 13.9697 -40.1108 60.955    0.248159 -0.780121 -0.574307    0 0
  v 6.19154 -40.7188 58.9233    0.187521 -0.729976 -0.657245    0 0
  v -7.14033 -43.5514 66.1693    -0.106022 -0.965864 -0.236358    0 0
  v -11.3307 -40.1108 60.955    -0.248159 -0.780121 -0.574307    0 0
  v -2.75976 -29.4588 60.9178    0.12534 -0.879525 -0.45905    0 0
  v 5.41772 -20.9976 109.761    0.130166 -0.259968 0.956804    0 0
  v 12.6087 -23.9859 107.272    0.24855 -0.395545 0.884176    0 0
  v 8.61852 -17.9295 109.974    0.168281 -0.159836 0.972694    0 0
  v 18.153 -18.9388 107.126    0.356818 -0.237975 0.903354    0 0
  v 10.503 -14.6988 110.001    0.186171 -0.0536186 0.981053    0 0
  v 19.9874 -13.14 107.126    0.400802 0.00705493 0.916138    0 0
  v 10.5089 -11.209 109.996    0.188455 0.0483739 0.98089    0 0
  v 17.8838 -7.02023 107.288    0.359822 0.220319 0.906635    0 0
  v 8.60705 -7.95719 109.981    0.164648 0.162211 0.972923    0 0
  v 12.5972 -1.9008 107.279    0.246366 0.396898 0.884181    0 0
  v 5.41772 -4.88724 109.761    0.130164 0.25997 0.956804    0 0
  v 5.41772 1.34543 107.133    0.0966577 0.523848 0.84631    0 0
  v 12.5977 -31.01 102.72    0.230834 -0.630346 0.741201    0 0
  v 22.032 -32.58 97.0641    0.387398 -0.658243 0.645476    0 0
  v 22.3004 -25.3557 102.548    0.429734 -0.443768 0.786383    0 0
  v 31.744 -24.173 97.3358    0.411316 -0.674947 0.61259    0 0
  v 27.3568 -17.3058 103.271    0.335285 -0.107131 0.936006    0 0
  v 35.4134 -12.9906 97.3279    0.616027 0.449929 0.646587    0 0
  v 27.513 -9.24933 102.538    0.55444 0.167276 0.815239    0 0
  v 31.5284 -2.78526 97.0525    0.612304 0.368646 0.699417    0 0
  v 22.0201 -0.615725 102.724    0.437845 0.441144 0.78338    0 0
  v 22.0316 6.6721 97.0646    0.393111 0.65358 0.646759    0 0
  v 12.5977 5.12519 102.72    0.230834 0.630346 0.741201    0 0
  v 8.60748 11.4861 97.0649    0.131625 0.780316 0.611377    0 0
  v 17.9521 -39.0485 91.0874    0.282809 -0.820978 0.495999    0 0
  v 27.6001 -37.5716 86.1768    0.44704 -0.767684 0.459147    0 0
  v 31.6223 -30.8041 91.2482    0.579185 -0.599297 0.552619    0 0
  v 39.7721 -26.3212 84.6601    0.785296 -0.485978 0.383583    0 0
  v 40.0366 -19.4061 90.9518    0.914033 -0.291056 0.282543    0 0
  v 43.8965 -13.1834 84.6589    0.911717 0.00451528 0.410794    0 0
  v 39.1123 -7.30741 91.2133    0.773475 0.237907 0.587484    0 0
  v 39.7082 0.474048 84.5166    0.775642 0.50518 0.378381    0 0
  v 31.6123 4.93514 91.061    0.587548 0.608232 0.533705    0 0
  v 27.6677 11.5426 84.5124    0.481637 0.829475 0.282838    0 0
  v 17.9108 13.1208 91.0634    0.29577 0.832487 0.468493    0 0
  v 10.6185 17.5558 84.5059    0.160514 0.95844 0.235854    0 0
  v 18.9004 -43.0363 77.1463    0.1972 -0.979815 0.0327916    0 0
  v 29.3304 -37.5772 67.8921    0.45046 -0.791155 -0.413714    0 0
  v 38.1746 -32.1591 77.2155    0.789329 -0.603511 0.112844    0 0
  v 41.6961 -26.536 69.5725    0.820187 -0.523994 -0.229616    0 0
  v 45.1306 -20.088 77.1665    0.941582 -0.30545 0.141857    0 0
  v 46.1281 -12.9424 69.5609    0.975337 6.56005e-007 -0.220719    0 0
  v 45.1199 -5.82167 77.1755    0.941164 0.303336 0.14899    0 0
  v 41.6127 0.616237 69.5609    0.799435 0.559488 -0.218808    0 0
  v 36.2943 7.08121 77.1693    0.660507 0.746425 0.0811167    0 0
  v 28.9731 11.4903 69.56    0.471479 0.85401 -0.219941    0 0
  v 20.5019 16.0008 77.1626    0.326865 0.944835 0.021116    0 0
  v 11.0842 17.5517 69.5309    0.158205 0.961828 -0.223289    0 0
  v 9.92187 -36.8852 55.8208    0.159844 -0.699635 -0.696391    0 0
  v 19.997 -38.6403 61.9549    0.323547 -0.78667 -0.525801    0 0
  v 22.855 -32.3087 56.1316    0.348509 -0.606177 -0.714907    0 0
  v 33.6149 -30.8937 62.3262    0.553246 -0.628594 -0.546616    0 0
  v 32.7194 -23.6956 56.1425    0.505358 -0.34985 -0.788808    0 0
  v 41.7106 -19.3313 62.3401    0.774433 -0.259002 -0.57721    0 0
  v 36.2572 -12.9424 56.1425    0.566306 8.97692e-008 -0.824195    0 0
  v 41.7106 -6.5535 62.3401    0.774433 0.259002 -0.57721    0 0
  v 32.7194 -2.18926 56.1425    0.505358 0.34985 -0.788808    0 0
  v 33.5548 4.95894 62.3401    0.557492 0.65173 -0.514248    0 0
  v 22.8187 6.43274 56.1422    0.343388 0.614797 -0.710006    0 0
  v 18.9814 12.9266 62.3332    0.28354 0.842124 -0.458728    0 0
  v 8.88774 11.1033 56.0083    0.141694 0.760651 -0.633509    0 0
  v 4.44852 -26.8892 47.5221    0.18895 -0.887998 0.419235    0 0
  v 12.1801 -30.794 51.4074    0.207711 -0.558462 -0.803104    0 0
  v 10.3803 -24.1879 47.5221    0.258969 -0.375199 -0.890034    0 0
  v 21.234 -25.3173 51.4183    0.307606 -0.315739 -0.897601    0 0
  v 14.7453 -19.1846 47.5221    0.317174 -0.178535 -0.931411    0 0
  v 26.3468 -17.359 51.4183    0.351192 -0.103215 -0.930597    0 0
  v 16.3076 -12.9424 47.5221    0.329575 -9.31536e-010 -0.944129    0 0
  v 26.3468 -8.52587 51.4183    0.351192 0.103216 -0.930597    0 0
  v 14.7453 -6.70022 47.5221    0.317174 0.178535 -0.931411    0 0
  v 21.234 -0.567517 51.4183    0.307606 0.31574 -0.897601    0 0
  v 10.3803 -1.69693 47.5221    0.258969 0.375199 -0.890034    0 0
  v 12.1439 4.91807 51.4181    0.193972 0.507651 -0.839443    0 0
  v 34.3148 -20.5526 102.025    -0.263901 -0.666756 0.696988    0 0
  v 38.5291 -21.6361 97.8594    0.474658 -0.875871 -0.0868913    0 0
  v 39.9725 -17.1227 97.8766    0.823915 0.565802 -0.0321258    0 0
  v 35.5282 -16.7735 102.042    0.0270557 0.718339 0.695167    0 0
  v 47.0164 -23.0978 113.683    -0.711927 -0.608175 0.351116    0 0
  v 48.824 -23.3549 112.724    0.299505 -0.81956 -0.488486    0 0
  v 49.316 -21.6694 112.876    0.623901 0.687244 -0.37208    0 0
  v 47.5084 -21.4123 113.835    -0.38612 0.802972 0.454034    0 0
  v 41.4205 -20.4319 107.616    -0.652062 0.169968 0.738869    0 0
  v 42.297 -22.1165 106.479    -0.180879 -0.983445 0.01094    0 0
  v 44.2832 -20.8864 105.328    0.806129 -0.21834 -0.549985    0 0
  v 43.1929 -19.1922 106.576    0.244657 0.957595 0.152169    0 0
  v 49.2631 -24.976 118.52    -0.865267 -0.428268 -0.260576    0 0
  v 53.389 -25.5011 116.793    0.0698346 -0.522859 -0.849554    0 0
  v 54.4625 -21.8733 117.208    0.223149 0.596711 -0.770806    0 0
  v 50.3366 -21.3482 118.935    -0.570588 0.804228 -0.166276    0 0
  v 48.8922 -22.9341 117.479    -0.92515 0.230719 0.301441    0 0
  v 50.2356 -24.9711 116.453    -0.291921 -0.87885 -0.377365    0 0
  v 52.9369 -23.4636 115.754    0.521075 -0.053085 -0.851858    0 0
  v 51.2804 -21.3965 116.861    0.0320326 0.97738 -0.209053    0 0
  v 49.8423 -26.113 121.032    -0.768256 -0.602112 0.217356    0 0
  v 56.0039 -26.8841 118.456    0.252052 -0.743562 -0.619342    0 0
  v 57.6202 -21.4715 119.07    0.462919 0.681063 -0.567326    0 0
  v 51.4585 -20.7003 121.646    -0.484443 0.83624 0.25694    0 0
  v 48.9418 -23.112 120.43    -0.955314 0.260824 0.139091    0 0
  v 51.5364 -27.0047 118.501    -0.317316 -0.820496 -0.475496    0 0
  v 56.7461 -24.0941 117.166    0.397271 -0.0138684 -0.917596    0 0
  v 53.5782 -20.147 119.281    -0.0409137 0.93259 -0.358612    0 0
  v 52.7167 -26.5793 124.221    -0.406143 -0.601326 0.68808    0 0
  v 58.6808 -27.3266 121.727    0.471081 -0.878978 -0.0740344    0 0
  v 60.2444 -22.0871 122.322    0.777713 0.628606 -0.00402736    0 0
  v 54.2803 -21.3399 124.816    -0.227025 0.631576 0.741331    0 0
  v 50.4952 -23.4801 123.573    -0.732073 0.139491 0.666791    0 0
  v 53.6629 -28.2281 121.223    -0.144082 -0.989248 -0.0250757    0 0
  v 60.0254 -24.6707 119.588    0.752656 -0.144773 -0.642301    0 0
  v 56.1649 -19.8571 122.172    0.14562 0.987456 0.0610403    0 0
  v 56.8877 -25.4981 125.697    0.080355 -0.401718 0.912231    0 0
  v 59.0604 -25.7789 124.787    0.485803 -0.547596 0.681274    0 0
  v 59.6215 -23.8668 125.007    0.628602 0.084516 0.773122    0 0
  v 57.4488 -23.5861 125.918    0.164839 0.128 0.97798    0 0
  v 54.5 -24.1549 125.848    -0.207808 -0.0489251 0.976945    0 0
  v 56.6237 -27.3388 124.266    0.141182 -0.801582 0.580976    0 0
  v 60.875 -24.963 123.18    0.898838 -0.294133 0.324924    0 0
  v 58.2857 -21.7348 124.907    0.377126 0.58753 0.71595    0 0
  v 12.9626 -0.0641749 41.5884    0.542206 0.778636 0.315814    0 0
  v 18.2538 -5.4913 41.5954    0.793291 0.484092 0.369248    0 0
  v 20.2134 -11.5574 41.6866    0.892769 0.220537 0.392844    0 0
  v 17.7339 -21.2672 41.6884    0.668916 -0.661107 0.339837    0 0
  v 12.9454 -25.8416 41.5904    0.537643 -0.782088 0.315086    0 0
  v 5.4298 -29.0766 41.5883    0.193771 -0.942964 0.270687    0 0
  v 8.50017 1.03439 44.7367    0.367138 0.826689 0.426374    0 0
  v 14.5416 -3.23835 44.7378    0.629012 0.582522 0.514794    0 0
  v 17.8791 -9.11551 44.8133    0.77955 0.206084 0.591466    0 0
  v 17.22 -16.3604 45.9063    0.723122 -0.182978 0.666043    0 0
  v 14.4402 -22.6909 44.8086    0.629422 -0.580966 0.516048    0 0
  v 8.50017 -26.9192 44.7367    0.367137 -0.826689 0.426375    0 0
  v 14.1945 0.747163 33.5791    0.57402 0.81838 0.0274905    0 0
  v 19.8671 -5.38061 33.5793    0.872359 0.488613 0.0157327    0 0
  v 21.8453 -12.8743 33.5101    0.999748 0.00987906 0.0201503    0 0
  v 19.8679 -20.4928 33.5092    0.870801 -0.491347 0.0168388    0 0
  v 14.1941 -26.632 33.5782    0.574241 -0.818219 0.0276463    0 0
  v 5.90032 -30.183 33.5791    0.199241 -0.979632 0.024978    0 0
  v 9.98657 2.62618 37.7966    0.390345 0.906809 0.159148    0 0
  v 17.0108 -2.23436 37.7978    0.712301 0.679188 0.177005    0 0
  v 20.8407 -8.7925 37.7811    0.948484 0.258138 0.183691    0 0
  v 21.2085 -16.8173 36.6613    0.968228 -0.249813 -0.0113411    0 0
  v 16.975 -23.6849 37.7763    0.713521 -0.679248 0.171785    0 0
  v 9.98657 -28.511 37.7966    0.390345 -0.906809 0.159148    0 0
  v 13.4045 0.20053 25.0062    0.562841 0.796166 -0.222103    0 0
  v 18.8042 -5.73829 25.0062    0.847644 0.463637 -0.257954    0 0
  v 20.6766 -12.9424 25.0062    0.961578 1.57777e-007 -0.274532    0 0
  v 18.8042 -20.1466 25.0062    0.847644 -0.463636 -0.257954    0 0
  v 13.4045 -26.0854 25.0062    0.562842 -0.796165 -0.222103    0 0
  v 5.59829 -29.4496 25.0062    0.196329 -0.961233 -0.193612    0 0
  v 10.1447 2.80355 29.2297    0.392858 0.914234 -0.099191    0 0
  v 17.2625 -2.20229 29.2297    0.733899 0.668792 -0.118786    0 0
  v 21.0869 -9.14085 29.2289    0.958797 0.249184 -0.136441    0 0
  v 21.093 -16.7354 29.2005    0.958243 -0.248393 -0.141673    0 0
  v 17.2621 -23.6825 29.2288    0.733992 -0.668723 -0.118595    0 0
  v 10.1447 -28.6884 29.2297    0.392858 -0.914234 -0.0991909    0 0
  v 10.9554 -1.48655 17.9815    0.472236 0.660424 -0.583809    0 0
  v 15.5414 -6.59424 17.9813    0.672807 0.364939 -0.643545    0 0
  v 17.1956 -12.9621 17.9919    0.748103 0.014106 -0.663432    0 0
  v 15.5657 -19.285 17.9919    0.670792 -0.379671 -0.637094    0 0
  v 10.9552 -24.3979 17.9813    0.472389 -0.660153 -0.583992    0 0
  v 4.66158 -27.1748 17.9815    0.17276 -0.830908 -0.528911    0 0
  v 8.96624 1.45674 21.1642    0.37481 0.862906 -0.338986    0 0
  v 15.3159 -3.05236 21.1642    0.682564 0.617395 -0.391062    0 0
  v 18.8059 -9.43517 21.164    0.872566 0.225198 -0.43349    0 0
  v 18.8236 -16.4527 21.1737    0.87666 -0.226526 -0.424444    0 0
  v 15.3157 -22.8321 21.164    0.682583 -0.617158 -0.391403    0 0
  v 8.96624 -27.3416 21.1642    0.37481 -0.862906 -0.338986    0 0
  v 6.58271 -4.43312 14.0558    0.261982 0.349805 -0.899445    0 0
  v 9.9078 -8.05463 14.0892    0.344153 0.189342 -0.919624    0 0
  v 11.1573 -12.2895 14.0108    0.3604 0.213048 -0.908142    0 0
  v 9.58227 -18.4602 14.0122    0.270613 -0.394427 -0.878178    0 0
  v 6.57311 -21.4671 14.0554    0.259298 -0.353866 -0.898634    0 0
  v 3.11777 -23.4524 14.1664    0.116111 -0.505494 -0.854982    0 0
  v 6.4766 -1.37971 15.6784    0.26856 0.587695 -0.76321    0 0
  v 11.202 -4.84282 15.6753    0.43276 0.387635 -0.813915    0 0
  v 13.9853 -10.0199 15.6706    0.522277 0.134909 -0.842037    0 0
  v 14.7812 -15.9651 15.9972    0.67146 -0.173114 -0.720537    0 0
  v 11.1815 -21.0571 15.6691    0.434319 -0.391889 -0.811042    0 0
  v 6.4766 -24.5051 15.6784    0.268561 -0.587695 -0.76321    0 0
  v 2.49381 -8.60287 12.3812    0.0843306 0.0740015 -0.993686    0 0
  v 4.21054 -10.2749 12.4434    0.118142 0.0558323 -0.991426    0 0
  v 4.78476 -12.9125 12.4282    0.126663 0.011703 -0.991877    0 0
  v 4.12006 -15.6305 12.4254    0.105589 -0.0644343 -0.99232    0 0
  v 3.09855 -4.80599 13.112    0.152631 0.297332 -0.942495    0 0
  v 5.70504 -7.29409 13.0005    0.209395 0.182373 -0.960674    0 0
  v 7.68794 -10.7859 13.0347    0.247051 0.064756 -0.966837    0 0
  v 6.77471 -14.9553 12.7307    0.0883193 -0.0238126 -0.995808    0 0
  v 5.65424 -18.6448 12.9954    0.205569 -0.183859 -0.961217    0 0
  v 3.09855 -21.0789 13.112    0.152631 -0.29733 -0.942496    0 0
  v 18.391 -19.0615 44.3166    0.261954 -0.628713 0.732188    0 0
  v 20.4179 -19.3725 39.4031    0.61596 -0.748718 -0.244979    0 0
  v 21.7136 -14.4167 39.3603    0.872148 0.410069 -0.266836    0 0
  v 19.6476 -14.2336 44.2738    0.458522 0.448304 0.767321    0 0
  v 23.1105 -18.6867 44.1409    0.0561411 -0.709377 0.70259    0 0
  v 23.6641 -18.8572 40.194    -0.0507728 -0.801175 -0.596272    0 0
  v 24.5245 -15.5082 39.9326    0.0286271 0.730141 -0.682697    0 0
  v 23.9709 -15.3377 43.8795    0.186925 0.733965 0.652958    0 0
  v 20.8395 -16.8206 45.0526    0.0596519 0.0211872 0.997994    0 0
  v 20.991 -19.6961 42.234    0.142394 -0.984973 0.0977311    0 0
  v 22.7069 -17.1076 39.0086    0.257416 -0.101643 -0.96094    0 0
  v 22.4628 -14.195 42.025    0.325023 0.943846 0.0592837    0 0
  v 27.8843 -19.0305 42.6963    0.290943 -0.712019 0.639047    0 0
  v 26.9848 -19.1647 39.1993    -0.411143 -0.766862 -0.492833    0 0
  v 27.5 -16.0647 38.7342    -0.270152 0.723307 -0.635488    0 0
  v 28.3995 -15.9304 42.2312    0.490949 0.700946 0.517343    0 0
  v 25.9996 -17.2005 44.3089    0.318757 0.0348192 0.947197    0 0
  v 25.3133 -19.606 41.9242    -0.0547066 -0.997353 0.0478952    0 0
  v 25.7218 -17.4223 38.7666    -0.338859 -0.0343643 -0.940209    0 0
  v 26.3231 -14.9088 41.3951    0.134332 0.989928 -0.0446926    0 0
  v 31.5402 -19.5013 39.418    0.511718 -0.707928 0.486809    0 0
  v 29.57 -19.598 36.9913    -0.483702 -0.802336 -0.349699    0 0
  v 29.8085 -17.0093 36.3001    -0.388068 0.710887 -0.586551    0 0
  v 31.7786 -16.9126 38.7267    0.636707 0.725955 0.259986    0 0
  v 30.425 -17.8374 41.5635    0.707591 0.0461643 0.705113    0 0
  v 29.0277 -19.9809 39.8806    -0.0555483 -0.995887 0.0715833    0 0
  v 28.2074 -18.0092 37.1017    -0.701913 -0.0515256 -0.710397    0 0
  v 29.5821 -15.7585 39.0071    0.219559 0.964142 -0.149078    0 0
  v 33.2407 -19.4385 36.1013    0.722634 -0.63115 -0.281867    0 0
  v 31.6439 -19.477 35.2265    0.0164762 -0.689695 -0.723913    0 0
  v 31.6106 -17.9929 34.7662    0.0754724 0.240117 -0.967806    0 0
  v 33.2074 -17.9544 35.641    0.788266 0.419583 -0.450096    0 0
  v 33.3015 -18.4913 37.6567    0.923285 0.0772288 0.376273    0 0
  v 31.7079 -20.1837 36.9621    0.0783159 -0.995536 -0.0526675    0 0
  v 30.1429 -18.5951 35.1718    -0.573262 -0.206931 -0.792812    0 0
  v 31.8122 -16.8809 35.9705    0.225574 0.91452 -0.335813    0 0
  v 12.4357 -17.3665 14.2916    0.510975 -0.761935 -0.397944    0 0
  v 8.49092 -16.7321 12.8317    -0.299856 -0.510957 -0.805611    0 0
  v 9.23647 -13.8369 12.812    -0.132967 0.562572 -0.815986    0 0
  v 13.2634 -14.1712 14.272    0.733781 0.480887 -0.47991    0 0
  v 13.0517 -17.1228 10.8094    0.415229 -0.899954 0.132917    0 0
  v 9.99945 -16.7719 10.2286    -0.740308 -0.658428 -0.135706    0 0
  v 10.5751 -14.537 10.1241    -0.471919 0.855853 -0.211677    0 0
  v 13.6273 -14.8878 10.7049    0.691214 0.721192 0.0458852    0 0
  v 13.7353 -15.9465 12.9918    0.963166 -0.231335 0.137095    0 0
  v 10.8 -17.3978 12.2609    -0.108964 -0.990119 -0.0882666    0 0
  v 9.07106 -15.3986 11.7148    -0.836409 0.195191 -0.512172    0 0
  v 11.7042 -13.9123 12.169    0.157268 0.969319 -0.188911    0 0
  v 13.555 -17.4086 6.21745    0.425084 -0.901437 0.0819425    0 0
  v 10.7333 -17.0869 5.78652    -0.749887 -0.658697 -0.0615433    0 0
  v 11.2577 -15.0403 5.67117    -0.482334 0.861021 -0.161236    0 0
  v 14.0794 -15.362 6.1021    0.700016 0.71323 -0.0357951    0 0
  v 14.3992 -16.2784 8.65025    0.968712 -0.226814 0.100765    0 0
  v 11.6865 -17.5911 8.27596    -0.129555 -0.990758 0.0401783    0 0
  v 10.065 -15.7842 7.97153    -0.957903 0.225302 -0.177935    0 0
  v 12.4937 -14.4445 8.10182    0.126726 0.986888 -0.0999665    0 0
  v 13.7465 -17.5176 2.46834    0.442645 -0.89569 -0.0424889    0 0
  v 11.4307 -17.2524 2.11456    -0.710767 -0.652986 -0.261572    0 0
  v 11.8597 -15.5723 2.01964    -0.457808 0.826273 -0.328153    0 0
  v 14.1755 -15.8374 2.37343    0.712413 0.682262 -0.164275    0 0
  v 14.609 -16.6306 4.22423    0.972439 -0.232003 0.0231944    0 0
  v 12.1906 -17.8023 3.88899    -0.123767 -0.992308 0.00249189    0 0
  v 10.7386 -16.1887 3.63307    -0.95215 0.221177 -0.21093    0 0
  v 12.9091 -14.9948 3.73064    0.13202 0.981076 -0.141637    0 0
  v 13.5301 -17.0958 0.829068    0.380098 -0.545913 -0.746662    0 0
  v 12.5338 -16.9801 0.676736    -0.238067 -0.35575 -0.903751    0 0
  v 12.7163 -16.2568 0.635567    -0.148345 0.344011 -0.927173    0 0
  v 13.7126 -16.3725 0.787899    0.50298 0.255314 -0.825728    0 0
  v 14.3261 -16.7847 1.4895    0.896458 -0.239263 -0.372983    0 0
  v 12.7102 -17.5745 1.23988    -0.0540708 -0.91933 -0.389756    0 0
  v 11.7224 -16.4847 1.09158    -0.709058 0.136244 -0.691863    0 0
  v 13.1901 -15.6849 1.13277    0.173059 0.849379 -0.498604    0 0
  v 24.147 -41.1366 81.7699    0.348485 -0.911876 0.216888    0 0
  v 25.0032 -41.2185 72.4934    0.349666 -0.926866 -0.13658    0 0
  v 34.8574 -35.7983 72.6633    0.627601 -0.767755 -0.129111    0 0
  v 33.5967 -35.714 81.8654    0.60948 -0.740564 0.283018    0 0
  v 24.2943 -41.5408 77.0873    0.566984 -0.821777 0.0566674    0 0
  v 30.0329 -38.7011 72.2306    0.468712 -0.868757 0.159903    0 0
  v 34.7134 -35.7016 77.3506    0.422249 -0.903546 0.0728713    0 0
  v 28.9748 -38.5414 82.2073    0.500174 -0.865222 -0.0348801    0 0
  v 24.7897 -39.476 76.988    0.997188 0.0219739 0.0716461    0 0
  v 29.4886 -37.155 72.9906    -0.0265549 -0.0274951 0.999269    0 0
  v 33.3786 -34.6616 77.2708    -0.972487 -0.204202 -0.112119    0 0
  v 28.6797 -36.9826 81.2682    0.0959982 -0.121484 -0.98794    0 0
  v 25.7159 -40.2055 80.3374    0.785112 -0.354753 -0.50769    0 0
  v 26.2254 -40.3072 73.8523    0.700297 -0.281185 0.65614    0 0
  v 33.0568 -36.5778 74.1098    -0.258355 -0.721124 0.642832    0 0
  v 32.2949 -36.4181 80.5096    -0.198954 -0.731987 -0.651623    0 0
  v 25.9526 -33.1932 76.7472    0.834532 -0.54531 0.0786979    0 0
  v 29.0977 -31.64 74.068    0.315664 -0.639257 0.701218    0 0
  v 31.7007 -29.9712 76.9364    -0.349732 -0.936727 -0.0151921    0 0
  v 28.5556 -31.5244 79.6156    0.404463 -0.694353 -0.595217    0 0
  v 25.7117 -35.9041 79.7794    0.777924 -0.18985 -0.598992    0 0
  v 26.1611 -35.9946 73.9889    0.679272 -0.127446 0.722735    0 0
  v 32.2353 -32.6823 74.2229    -0.661123 -0.225765 0.715504    0 0
  v 31.5603 -32.5332 79.9378    -0.541629 -0.28308 -0.79152    0 0
  v 7.6216 -41.2386 60.1217    0.00540431 -0.956571 -0.291448    0 0
  v 5.41772 -27.2303 107.133    0.0966572 -0.523848 0.84631    0 0
  v 8.60748 -37.371 97.0649    0.131625 -0.780316 0.611377    0 0
  v 10.6365 -43.4791 84.511    0.135105 -0.961538 0.239145    0 0
  v 10.9703 -44.1497 70.6239    0.127654 -0.98636 -0.103915    0 0
  v 4.44852 1.04514 47.5221    0.144663 0.51847 -0.84277    0 0
  v 5.4298 3.19177 41.5883    0.19377 0.942964 0.270687    0 0
  v 5.90032 4.29818 33.5791    0.199241 0.979632 0.0249781    0 0
  v 5.59829 3.56472 25.0062    0.196329 0.961233 -0.193612    0 0
  v 4.66158 1.28999 17.9815    0.17276 0.830907 -0.528911    0 0
  v 3.11777 -2.43249 14.1664    0.116112 0.505494 -0.854982    0 0
  v 2.49118 -17.2841 12.3808    0.0836185 -0.0742833 -0.993725    0 0
  v 8.63292 -42.8887 63.7249    0.08478 -0.9217 -0.378526    0 0
  v 1.31948 -12.9424 110.868    4.04597e-007 5.53523e-010 1    0 0
  v 1.31948 -8.74361 110.768    1.39867e-009 0.116978 0.993134    0 0
  v 1.31948 -32.9483 102.714    1.7599e-007 -0.694059 0.719918    0 0
  v 1.31948 7.06342 102.714    -2.28204e-007 0.694059 0.719918    0 0
  v 1.31948 -41.8025 91.0636    -1.00804e-007 -0.894068 0.447931    0 0
  v 1.31948 15.9204 91.0626    -4.94671e-008 0.893538 0.448987    0 0
  v 1.31948 -45.049 77.2783    -4.66355e-010 -0.999388 0.0349798    0 0
  v 1.31948 15.6911 62.1828    -4.5737e-008 0.894642 -0.446783    0 0
  v 1.31948 -32.753 51.3959    0 -0.582326 -0.812955    0 0
  v 1.31948 7.21454 51.2475    0.107357 0.596787 -0.795185    0 0
  v 1.31948 2.57308 44.7367    0 0.938785 0.344502    0 0
  v 1.31948 -28.4273 44.7367    9.32369e-010 -0.921707 0.387887    0 0
  v 1.31948 4.39455 37.7966    -4.66444e-010 0.989333 0.145671    0 0
  v 1.31948 4.60085 29.2297    -1.01678e-007 0.995822 -0.0913149    0 0
  v 1.31948 3.03471 21.1642    -1.18518e-007 0.949316 -0.314324    0 0
  v 1.31948 -28.9196 21.1642    1.15718e-007 -0.949316 -0.314324    0 0
  v 1.31948 -4.08425 13.2257    -2.96005e-008 0.383201 -0.923665    0 0
  v 1.31948 -21.8006 13.2257    5.82687e-011 -0.383202 -0.923665    0 0
  v -9.95869 -31.01 102.72    -0.230834 -0.630346 0.741201    0 0
  v -19.3758 -32.5961 97.0636    -0.385407 -0.659434 0.645452    0 0
  v -19.2694 -25.3822 102.794    -0.425529 -0.452207 0.783859    0 0
  v -9.95301 -23.9873 107.282    -0.243665 -0.398561 0.884181    0 0
  v -28.6798 -24.6016 97.3264    -0.403978 -0.670128 0.622679    0 0
  v -31.232 -20.587 102.263    0.218253 -0.639623 0.737054    0 0
  v -23.8573 -17.1261 103.829    -0.359225 -0.0846534 0.929404    0 0
  v -15.1277 -18.9786 107.373    -0.344454 -0.234803 0.908966    0 0
  v -30.5211 -15.6793 101.357    -0.244974 0.671593 0.69925    0 0
  v -32.4311 -12.6781 97.0362    -0.658787 0.271336 0.701696    0 0
  v -24.8804 -10.4488 102.864    -0.557528 0.135414 0.819039    0 0
  v -17.0446 -13.0293 107.375    -0.387166 0.00587332 0.921992    0 0
  v -29.9151 -4.83355 97.0465    -0.625456 0.337439 0.70352    0 0
  v -19.5602 -0.932791 102.724    -0.451003 0.431696 0.781175    0 0
  v -15.3717 -7.27536 107.3    -0.3586 0.224319 0.906138    0 0
  v -19.4258 6.61186 97.0644    -0.403274 0.645606 0.648508    0 0
  v -9.95869 5.12519 102.72    -0.230834 0.630346 0.741201    0 0
  v -9.96355 -1.91006 107.279    -0.248491 0.395586 0.884174    0 0
  v -5.96851 11.4861 97.0649    -0.131625 0.780316 0.611377    0 0
  v -2.77875 1.34543 107.133    -0.0966575 0.523848 0.84631    0 0
  v -15.3131 -39.0485 91.0874    -0.282809 -0.820978 0.495999    0 0
  v -24.9607 -37.5832 86.1683    -0.445474 -0.77031 0.456261    0 0
  v -28.9792 -31.1379 90.9935    -0.572298 -0.605324 0.553225    0 0
  v -37.1124 -26.6661 84.4169    -0.789259 -0.485987 0.37535    0 0
  v -37.653 -19.3937 90.3113    -0.914006 -0.270429 0.302425    0 0
  v -35.8506 -21.9808 97.571    -0.507171 -0.860616 -0.0460194    0 0
  v -36.7651 -15.8552 95.4379    -0.805319 0.555612 0.206774    0 0
  v -41.4569 -12.9546 84.4267    -0.918479 -0.0063851 0.395419    0 0
  v -37.3578 -8.82829 90.865    -0.786923 0.194435 0.585617    0 0
  v -37.2917 0.118414 84.5023    -0.774977 0.50343 0.382059    0 0
  v -29.2123 4.52746 91.0603    -0.595996 0.589693 0.545023    0 0
  v -25.0365 11.5297 84.5124    -0.484122 0.827167 0.285341    0 0
  v -15.2718 13.1208 91.0634    -0.29577 0.832487 0.468493    0 0
  v -7.97952 17.5558 84.5059    -0.160514 0.95844 0.235854    0 0
  v -35.5353 -32.1706 77.2069    -0.787887 -0.606088 0.109049    0 0
  v -39.0571 -26.536 69.5725    -0.820187 -0.523994 -0.229616    0 0
  v -42.5006 -20.0918 77.1429    -0.941931 -0.305985 0.138343    0 0
  v -43.4891 -12.9424 69.5609    -0.975338 -7.55628e-007 -0.220719    0 0
  v -42.4982 -5.82352 77.1628    -0.941522 0.30565 0.141824    0 0
  v -38.9737 0.616238 69.5609    -0.799435 0.559489 -0.218808    0 0
  v -33.663 7.06833 77.1693    -0.661254 0.745484 0.0836429    0 0
  v -26.3342 11.4903 69.56    -0.471479 0.85401 -0.219941    0 0
  v -17.863 16.0008 77.1626    -0.326865 0.944835 0.0211159    0 0
  v -8.44525 17.5517 69.5309    -0.158205 0.961828 -0.223289    0 0
  v 1.31948 19.1828 77.1394    2.90807e-007 0.999991 0.00420396    0 0
  v -17.358 -38.6403 61.9549    -0.323547 -0.78667 -0.525801    0 0
  v -20.216 -32.3087 56.1316    -0.348509 -0.606177 -0.714906    0 0
  v -30.9759 -30.8937 62.3262    -0.553246 -0.628594 -0.546616    0 0
  v -26.6914 -37.5772 67.8921    -0.45046 -0.791156 -0.413714    0 0
  v -30.0804 -23.6956 56.1425    -0.505358 -0.349849 -0.788808    0 0
  v -39.0717 -19.3313 62.3401    -0.774433 -0.259002 -0.57721    0 0
  v -33.6183 -12.9424 56.1425    -0.566306 -9.3042e-008 -0.824195    0 0
  v -39.0717 -6.5535 62.3401    -0.774432 0.259002 -0.577211    0 0
  v -30.0804 -2.18926 56.1425    -0.505358 0.34985 -0.788808    0 0
  v -30.9158 4.95894 62.3401    -0.557492 0.65173 -0.514248    0 0
  v -20.1798 6.43274 56.1422    -0.343388 0.614798 -0.710006    0 0
  v -16.3424 12.9266 62.3332    -0.28354 0.842124 -0.458728    0 0
  v -6.24878 11.1033 56.0083    -0.141694 0.760651 -0.633509    0 0
  v -9.54116 -30.794 51.4074    -0.20771 -0.558462 -0.803105    0 0
  v -7.74135 -24.1879 47.5221    -0.258969 -0.375199 -0.890034    0 0
  v -18.595 -25.3173 51.4183    -0.341633 -0.372714 -0.86277    0 0
  v -12.1064 -19.1846 47.5221    -0.317174 -0.178535 -0.931411    0 0
  v -23.7079 -17.359 51.4183    -0.404015 -0.126178 -0.906008    0 0
  v -13.6686 -12.9424 47.5221    -0.329575 4.84399e-008 -0.944129    0 0
  v -23.7079 -8.52587 51.4183    -0.404015 0.126178 -0.906008    0 0
  v -12.1064 -6.70022 47.5221    -0.317174 0.178535 -0.931411    0 0
  v -18.595 -0.567517 51.4183    -0.341632 0.372714 -0.86277    0 0
  v -7.74135 -1.69693 47.5221    -0.258969 0.375199 -0.890034    0 0
  v -9.50489 4.91806 51.4181    -0.204349 0.569949 -0.795864    0 0
  v -1.80956 1.04514 47.5221    -0.132353 0.528001 -0.838867    0 0
  v -54.2488 -25.4981 125.697    -0.0803544 -0.401719 0.912231    0 0
  v -56.4215 -25.7789 124.787    -0.485803 -0.547597 0.681273    0 0
  v -56.9825 -23.8668 125.007    -0.628603 0.0845159 0.773121    0 0
  v -54.8098 -23.5861 125.918    -0.16484 0.128002 0.977979    0 0
  v -39.6408 -22.1326 106.478    0.1832 -0.982746 0.025466    0 0
  v -44.3627 -23.092 113.666    0.710743 -0.610094 0.350186    0 0
  v -38.3267 -20.2635 107.164    0.623454 0.191626 0.758013    0 0
  v -41.2889 -20.7314 104.757    -0.817828 -0.21123 -0.535293    0 0
  v -46.1715 -23.3494 112.705    -0.297856 -0.821025 -0.487032    0 0
  v -38.3113 -18.0449 103.68    -0.262842 0.944226 0.198371    0 0
  v -46.241 -21.4879 112.26    -0.651107 0.656276 -0.381263    0 0
  v -44.403 -21.225 113.265    0.402432 0.780081 0.479084    0 0
  v -47.5966 -24.9711 116.453    0.29192 -0.878851 -0.377364    0 0
  v -46.6241 -24.976 118.52    0.865266 -0.428268 -0.260578    0 0
  v -46.2385 -22.9284 117.462    0.924843 0.214909 0.313814    0 0
  v -50.2844 -23.4581 115.734    -0.527478 -0.0691528 -0.84675    0 0
  v -50.75 -25.5011 116.793    -0.0698358 -0.52286 -0.849553    0 0
  v -48.5714 -21.3658 116.768    -0.0516389 0.984711 -0.166364    0 0
  v -51.8235 -21.8733 117.208    -0.223148 0.596712 -0.770805    0 0
  v -47.6976 -21.3482 118.935    0.570588 0.804227 -0.166276    0 0
  v -48.8974 -27.0047 118.501    0.317316 -0.820496 -0.475496    0 0
  v -47.2033 -26.113 121.032    0.768256 -0.602113 0.217354    0 0
  v -46.3028 -23.112 120.43    0.955314 0.260824 0.139092    0 0
  v -54.1071 -24.0941 117.166    -0.397272 -0.0138692 -0.917596    0 0
  v -53.365 -26.8841 118.456    -0.252052 -0.743562 -0.619342    0 0
  v -50.9392 -20.147 119.281    0.0409137 0.93259 -0.358611    0 0
  v -54.9812 -21.4715 119.07    -0.46292 0.681062 -0.567327    0 0
  v -48.8196 -20.7003 121.646    0.484442 0.83624 0.25694    0 0
  v -51.024 -28.2281 121.223    0.144082 -0.989248 -0.0250767    0 0
  v -50.0778 -26.5793 124.221    0.406141 -0.601325 0.688082    0 0
  v -47.8562 -23.4801 123.573    0.732073 0.139491 0.666792    0 0
  v -57.3865 -24.6707 119.588    -0.752655 -0.144773 -0.642302    0 0
  v -56.0418 -27.3266 121.727    -0.471081 -0.878977 -0.0740354    0 0
  v -53.5259 -19.8571 122.172    -0.14562 0.987456 0.0610405    0 0
  v -57.6054 -22.0871 122.322    -0.777713 0.628607 -0.00402736    0 0
  v -51.6413 -21.3399 124.816    0.227024 0.631574 0.741332    0 0
  v -53.9847 -27.3388 124.266    -0.141182 -0.801582 0.580976    0 0
  v -51.861 -24.1549 125.848    0.207807 -0.0489229 0.976946    0 0
  v -58.236 -24.963 123.18    -0.898838 -0.294133 0.324925    0 0
  v -55.6467 -21.7348 124.907    -0.377127 0.58753 0.71595    0 0
  v -11.9026 -3.23835 44.7378    -0.642267 0.611735 0.461816    0 0
  v -10.3236 -0.0641757 41.5884    -0.542206 0.778636 0.315814    0 0
  v -5.86121 1.03439 44.7367    -0.367138 0.826689 0.426375    0 0
  v -15.2401 -9.11551 44.8133    -0.809527 0.223709 0.54279    0 0
  v -15.6148 -5.4913 41.5954    -0.793291 0.484092 0.369248    0 0
  v -14.581 -16.3604 45.9063    -0.540837 -0.137561 0.829803    0 0
  v -17.0086 -14.2336 44.2738    -0.458523 0.448305 0.76732    0 0
  v -17.5745 -11.5574 41.6866    -0.892769 0.220536 0.392844    0 0
  v -11.8012 -22.6909 44.8086    -0.637479 -0.609648 0.471116    0 0
  v -15.0949 -21.2672 41.6884    -0.668916 -0.661107 0.339837    0 0
  v -15.752 -19.0615 44.3166    -0.261954 -0.628713 0.732189    0 0
  v -5.86121 -26.9192 44.7367    -0.371417 -0.845574 0.383476    0 0
  v -10.3064 -25.8416 41.5904    -0.537643 -0.782088 0.315086    0 0
  v -1.80956 -26.8892 47.5221    -0.18895 -0.887998 0.419235    0 0
  v -2.79084 -29.0766 41.5883    -0.193771 -0.942964 0.270687    0 0
  v -14.3719 -2.23436 37.7978    -0.712301 0.679188 0.177005    0 0
  v -11.5555 0.747163 33.5791    -0.57402 0.81838 0.0274905    0 0
  v -7.34761 2.62618 37.7966    -0.390345 0.906809 0.159148    0 0
  v -18.2018 -8.7925 37.7811    -0.948484 0.258138 0.18369    0 0
  v -17.2281 -5.38061 33.5793    -0.872359 0.488613 0.0157327    0 0
  v -19.0746 -14.4167 39.3603    -0.872148 0.41007 -0.266835    0 0
  v -18.5695 -16.8173 36.6613    -0.968227 -0.249814 -0.0113415    0 0
  v -19.2063 -12.8743 33.5101    -0.999748 0.00987906 0.0201503    0 0
  v -17.7789 -19.3725 39.4031    -0.61596 -0.748718 -0.244979    0 0
  v -14.336 -23.6849 37.7763    -0.713521 -0.679248 0.171785    0 0
  v -17.2289 -20.4928 33.5092    -0.870801 -0.491347 0.016839    0 0
  v -7.34761 -28.511 37.7966    -0.390345 -0.906809 0.159148    0 0
  v -11.5551 -26.632 33.5782    -0.574241 -0.818219 0.0276462    0 0
  v 1.31948 -30.2794 37.7966    0 -0.989333 0.145671    0 0
  v -3.26135 -30.183 33.5791    -0.199241 -0.979632 0.0249782    0 0
  v -14.6235 -2.20229 29.2297    -0.733899 0.668792 -0.118786    0 0
  v -10.7655 0.20053 25.0062    -0.562841 0.796166 -0.222103    0 0
  v -7.50574 2.80355 29.2297    -0.392858 0.914234 -0.099191    0 0
  v -18.4479 -9.14085 29.2289    -0.958797 0.249184 -0.136441    0 0
  v -16.1653 -5.73829 25.0062    -0.847644 0.463637 -0.257954    0 0
  v -18.454 -16.7354 29.2005    -0.958243 -0.248393 -0.141674    0 0
  v -18.0377 -12.9424 25.0062    -0.961578 1.0643e-007 -0.274532    0 0
  v -14.6232 -23.6825 29.2288    -0.733992 -0.668723 -0.118595    0 0
  v -16.1653 -20.1466 25.0062    -0.847644 -0.463637 -0.257954    0 0
  v -7.50574 -28.6884 29.2297    -0.392858 -0.914234 -0.0991913    0 0
  v -10.7655 -26.0854 25.0062    -0.562841 -0.796166 -0.222103    0 0
  v 1.31948 -30.4857 29.2297    -3.12496e-008 -0.995822 -0.0913148    0 0
  v -2.95932 -29.4496 25.0062    -0.196329 -0.961233 -0.193612    0 0
  v -12.677 -3.05236 21.1642    -0.682564 0.617396 -0.391062    0 0
  v -8.31644 -1.48655 17.9815    -0.472236 0.660423 -0.583809    0 0
  v -6.32727 1.45674 21.1642    -0.37481 0.862906 -0.338986    0 0
  v -16.1669 -9.43517 21.164    -0.872566 0.225198 -0.43349    0 0
  v -12.9025 -6.59424 17.9813    -0.672807 0.364939 -0.643545    0 0
  v -16.1847 -16.4527 21.1737    -0.87666 -0.226526 -0.424444    0 0
  v -14.5566 -12.9621 17.9919    -0.748103 0.0141075 -0.663433    0 0
  v -12.6767 -22.8321 21.164    -0.682583 -0.617158 -0.391403    0 0
  v -12.9267 -19.285 17.9919    -0.670792 -0.37967 -0.637094    0 0
  v -6.32727 -27.3416 21.1642    -0.37481 -0.862905 -0.338986    0 0
  v -8.31622 -24.3979 17.9813    -0.472389 -0.660153 -0.583992    0 0
  v -2.02261 -27.1748 17.9815    -0.172761 -0.830907 -0.528911    0 0
  v -8.56299 -4.84282 15.6753    -0.432761 0.387635 -0.813915    0 0
  v -3.94375 -4.43312 14.0558    -0.261982 0.349805 -0.899445    0 0
  v -3.83763 -1.37971 15.6784    -0.26856 0.587695 -0.76321    0 0
  v -11.3464 -10.0199 15.6706    -0.522275 0.134907 -0.842039    0 0
  v -7.26884 -8.05463 14.0892    -0.344153 0.18934 -0.919625    0 0
  v -12.1423 -15.9651 15.9972    -0.67146 -0.173114 -0.720537    0 0
  v -10.6245 -14.1712 14.272    -0.733782 0.480886 -0.47991    0 0
  v -8.51831 -12.2895 14.0108    -0.360401 0.21305 -0.908141    0 0
  v -8.54253 -21.0571 15.6691    -0.434318 -0.391889 -0.811043    0 0
  v -6.9433 -18.4602 14.0122    -0.270612 -0.394431 -0.878176    0 0
  v -9.79676 -17.3665 14.2916    -0.510975 -0.761935 -0.397944    0 0
  v -3.83763 -24.5051 15.6784    -0.26856 -0.587695 -0.76321    0 0
  v -3.93415 -21.4671 14.0554    -0.259298 -0.353865 -0.898635    0 0
  v 1.31948 -25.6295 15.6827    1.19486e-007 -0.684516 -0.728998    0 0
  v -0.478802 -23.4524 14.1664    -0.116113 -0.505495 -0.854981    0 0
  v -3.06607 -7.29409 13.0005    -0.209396 0.182375 -0.960673    0 0
  v 0.145153 -8.60287 12.3812    -0.084331 0.0740006 -0.993686    0 0
  v 1.31948 -6.44114 12.5709    9.29839e-007 0.185378 -0.982667    0 0
  v -0.459581 -4.80599 13.112    -0.152632 0.297331 -0.942495    0 0
  v -5.04897 -10.7859 13.0347    -0.247051 0.064756 -0.966837    0 0
  v -1.57158 -10.2749 12.4434    -0.118141 0.0558314 -0.991426    0 0
  v -6.59751 -13.8369 12.812    0.132972 0.562572 -0.815984    0 0
  v -4.13575 -14.9553 12.7307    -0.08832 -0.0238155 -0.995807    0 0
  v -2.14579 -12.9125 12.4282    -0.126663 0.0117028 -0.991877    0 0
  v -5.85195 -16.7321 12.8317    0.299859 -0.510956 -0.805611    0 0
  v -3.01527 -18.6448 12.9954    -0.205568 -0.183863 -0.961216    0 0
  v -1.48109 -15.6305 12.4254    -0.105591 -0.0644355 -0.99232    0 0
  v -0.459581 -21.0789 13.112    -0.152634 -0.297329 -0.942496    0 0
  v 1.31948 -19.4437 12.5709    -9.78803e-007 -0.185378 -0.982667    0 0
  v 0.147784 -17.2841 12.3808    -0.0836182 -0.0742855 -0.993725    0 0
  v -30.6017 -19.4385 36.1013    -0.722634 -0.63115 -0.281868    0 0
  v -29.0049 -19.477 35.2265    -0.0164773 -0.689695 -0.723912    0 0
  v -28.9716 -17.9929 34.7662    -0.0754701 0.240119 -0.967805    0 0
  v -30.5684 -17.9544 35.641    -0.788267 0.419582 -0.450095    0 0
  v -18.352 -19.6961 42.234    -0.142393 -0.984973 0.0977305    0 0
  v -20.4716 -18.6867 44.1409    -0.0561413 -0.709376 0.70259    0 0
  v -18.2006 -16.8206 45.0526    -0.0596524 0.0211874 0.997994    0 0
  v -20.0679 -17.1076 39.0086    -0.257416 -0.101643 -0.96094    0 0
  v -21.0252 -18.8572 40.194    0.0507724 -0.801175 -0.596273    0 0
  v -19.8239 -14.195 42.025    -0.325022 0.943846 0.0592836    0 0
  v -21.8855 -15.5082 39.9326    -0.0286261 0.730142 -0.682696    0 0
  v -21.3319 -15.3377 43.8795    -0.186924 0.733966 0.652958    0 0
  v -22.6744 -19.606 41.9242    0.0547067 -0.997353 0.0478951    0 0
  v -25.2454 -19.0305 42.6963    -0.290944 -0.712018 0.639048    0 0
  v -23.3606 -17.2005 44.3089    -0.318757 0.0348186 0.947197    0 0
  v -23.0829 -17.4223 38.7666    0.338858 -0.0343647 -0.94021    0 0
  v -24.3459 -19.1647 39.1993    0.411143 -0.766862 -0.492833    0 0
  v -23.6841 -14.9088 41.3951    -0.134332 0.989928 -0.0446925    0 0
  v -24.8611 -16.0647 38.7342    0.270152 0.723307 -0.635488    0 0
  v -25.7605 -15.9304 42.2312    -0.49095 0.700945 0.517343    0 0
  v -26.3888 -19.9809 39.8806    0.0555473 -0.995887 0.0715824    0 0
  v -28.9012 -19.5013 39.418    -0.511717 -0.707929 0.486809    0 0
  v -27.7861 -17.8374 41.5635    -0.70759 0.0461643 0.705113    0 0
  v -25.5684 -18.0092 37.1017    0.701912 -0.0515264 -0.710398    0 0
  v -26.931 -19.598 36.9913    0.483703 -0.802336 -0.349699    0 0
  v -26.9432 -15.7585 39.0071    -0.219559 0.964142 -0.149078    0 0
  v -27.1695 -17.0093 36.3001    0.388067 0.710887 -0.586552    0 0
  v -29.1397 -16.9126 38.7267    -0.636707 0.725955 0.259987    0 0
  v -29.069 -20.1837 36.9621    -0.0783157 -0.995537 -0.0526672    0 0
  v -30.6625 -18.4913 37.6567    -0.923284 0.0772289 0.376273    0 0
  v -27.504 -18.5951 35.1718    0.573262 -0.206931 -0.792811    0 0
  v -29.1732 -16.8809 35.9705    -0.225572 0.91452 -0.335814    0 0
  v -10.8911 -17.0958 0.829075    -0.380099 -0.545914 -0.746661    0 0
  v -9.89486 -16.9801 0.676743    0.238079 -0.355743 -0.903751    0 0
  v -10.0774 -16.2568 0.635567    0.148338 0.344014 -0.927173    0 0
  v -11.0736 -16.3725 0.787899    -0.50298 0.25532 -0.825725    0 0
  v -8.16098 -17.3978 12.2609    0.108963 -0.990119 -0.0882666    0 0
  v -10.4128 -17.1228 10.8094    -0.415229 -0.899955 0.132917    0 0
  v -11.0963 -15.9465 12.9919    -0.963166 -0.231336 0.137096    0 0
  v -6.4321 -15.3986 11.7148    0.836409 0.195193 -0.512171    0 0
  v -7.36049 -16.7719 10.2286    0.740308 -0.658428 -0.135706    0 0
  v -9.06519 -13.9123 12.169    -0.157268 0.969319 -0.188912    0 0
  v -7.93612 -14.537 10.1241    0.47192 0.855853 -0.211677    0 0
  v -10.9884 -14.8878 10.7049    -0.691214 0.721192 0.0458848    0 0
  v -9.04758 -17.5911 8.27596    0.129555 -0.990758 0.0401785    0 0
  v -10.9161 -17.4086 6.21745    -0.425084 -0.901437 0.0819424    0 0
  v -11.7603 -16.2784 8.65024    -0.968712 -0.226813 0.100765    0 0
  v -7.42602 -15.7842 7.97153    0.957903 0.225302 -0.177936    0 0
  v -8.09437 -17.0869 5.78652    0.749888 -0.658696 -0.0615434    0 0
  v -9.85476 -14.4445 8.10182    -0.126726 0.986888 -0.0999665    0 0
  v -8.61876 -15.0403 5.67117    0.482334 0.861021 -0.161236    0 0
  v -11.4405 -15.362 6.1021    -0.700016 0.71323 -0.0357951    0 0
  v -9.55159 -17.8023 3.88899    0.123767 -0.992308 0.00249173    0 0
  v -11.1076 -17.5176 2.46834    -0.442645 -0.895689 -0.0424892    0 0
  v -11.9701 -16.6306 4.22421    -0.972439 -0.232002 0.0231938    0 0
  v -8.09961 -16.1887 3.63307    0.95215 0.221178 -0.210929    0 0
  v -8.79172 -17.2524 2.11456    0.710766 -0.652987 -0.261572    0 0
  v -10.2701 -14.9948 3.73064    -0.132019 0.981076 -0.141637    0 0
  v -9.22069 -15.5723 2.01964    0.457809 0.826273 -0.328152    0 0
  v -11.5365 -15.8374 2.37344    -0.712413 0.682263 -0.164273    0 0
  v -10.0712 -17.5745 1.23988    0.054071 -0.91933 -0.389755    0 0
  v -11.6872 -16.7847 1.4895    -0.896458 -0.239264 -0.372981    0 0
  v -9.08343 -16.4847 1.09158    0.709058 0.136243 -0.691863    0 0
  v -10.5511 -15.6849 1.13277    -0.173062 0.849374 -0.498612    0 0
  v -16.2614 -43.0363 77.1463    -0.1972 -0.979815 0.0327916    0 0
  v -22.3643 -41.2185 72.4934    -0.349666 -0.926866 -0.136579    0 0
  v -21.6554 -41.5408 77.0873    -0.566984 -0.821777 0.0566673    0 0
  v -21.508 -41.1366 81.7699    -0.348485 -0.911876 0.216888    0 0
  v -32.2184 -35.7983 72.6633    -0.627601 -0.767755 -0.129111    0 0
  v -27.3939 -38.7011 72.2306    -0.468712 -0.868758 0.159902    0 0
  v -30.9575 -35.7197 81.8613    -0.608087 -0.742838 0.280039    0 0
  v -32.0745 -35.7016 77.3506    -0.422251 -0.903545 0.0728709    0 0
  v -26.3359 -38.5414 82.2073    -0.500174 -0.865222 -0.0348797    0 0
  v -23.3137 -33.1932 76.7472    -0.834532 -0.54531 0.0786984    0 0
  v -26.4588 -31.64 74.068    -0.315665 -0.639258 0.701217    0 0
  v -29.0617 -29.9712 76.9364    0.349731 -0.936727 -0.0151925    0 0
  v -25.9166 -31.5244 79.6156    -0.404463 -0.694353 -0.595218    0 0
  v -23.5864 -40.3072 73.8523    -0.700296 -0.281184 0.656141    0 0
  v -22.1507 -39.476 76.988    -0.997188 0.0219738 0.0716459    0 0
  v -23.0769 -40.2055 80.3374    -0.785112 -0.354753 -0.507691    0 0
  v -30.4178 -36.5778 74.1098    0.258353 -0.721125 0.642831    0 0
  v -26.8497 -37.155 72.9906    0.0265548 -0.0274952 0.999269    0 0
  v -29.6559 -36.4181 80.5096    0.198954 -0.731988 -0.651622    0 0
  v -30.7396 -34.6616 77.2708    0.972487 -0.204202 -0.112118    0 0
  v -26.0407 -36.9826 81.2682    -0.0959982 -0.121484 -0.98794    0 0
  v -23.5221 -35.9946 73.9889    -0.679272 -0.127446 0.722736    0 0
  v -23.0727 -35.9041 79.7794    -0.777924 -0.189849 -0.598992    0 0
  v -29.5963 -32.6823 74.2229    0.661123 -0.225764 0.715505    0 0
  v -28.9213 -32.5332 79.9378    0.541628 -0.283081 -0.79152    0 0
  v -7.28291 -36.8852 55.8208    -0.159844 -0.699635 -0.696392    0 0
  v -8.3313 -44.1497 70.6239    -0.127655 -0.98636 -0.103915    0 0
  v 1.31948 -43.9466 65.9439    -6.99245e-010 -0.968328 -0.249681    0 0
  v -5.99396 -42.8887 63.7249    -0.0847798 -0.9217 -0.378525    0 0
  v -4.98263 -41.2386 60.1217    -0.00540137 -0.956573 -0.291443    0 0
  v 1.31948 -40.2538 57.5938    -9.48995e-010 -0.721601 -0.692309    0 0
  v -2.77875 -27.2303 107.133    -0.0966576 -0.523848 0.84631    0 0
  v -2.77875 -20.9976 109.761    -0.130165 -0.259968 0.956804    0 0
  v 1.31948 -22.2852 109.609    -5.74231e-007 -0.333025 0.942918    0 0
  v -5.96284 -17.9309 109.985    -0.162143 -0.163864 0.973067    0 0
  v 1.31948 -17.1412 110.768    -1.8649e-009 -0.116978 0.993134    0 0
  v -7.83059 -14.6946 110.024    -0.179282 -0.0531227 0.982362    0 0
  v 1.31948 -15.1005 110.855    5.36136e-007 -0.0221088 0.999756    0 0
  v -7.85849 -11.2127 110.008    -0.183251 0.056314 0.981452    0 0
  v -5.97338 -7.96645 109.981    -0.165257 0.161783 0.972891    0 0
  v 1.31948 -10.7844 110.855    5.37534e-007 0.0221088 0.999756    0 0
  v -2.77875 -4.88724 109.761    -0.130164 0.25997 0.956804    0 0
  v 1.31948 -3.59969 109.609    -1.74849e-008 0.333024 0.942918    0 0
  v -5.96852 -37.371 97.0649    -0.131625 -0.780316 0.611377    0 0
  v -7.9975 -43.4791 84.511    -0.135105 -0.961538 0.239145    0 0
  v -2.79083 3.19177 41.5883    -0.193771 0.942964 0.270687    0 0
  v -3.26135 4.29818 33.5791    -0.199241 0.979632 0.0249781    0 0
  v -2.95932 3.56472 25.0062    -0.196329 0.961233 -0.193612    0 0
  v -2.02261 1.28999 17.9815    -0.17276 0.830908 -0.528911    0 0
  v -0.478802 -2.43249 14.1664    -0.116112 0.505494 -0.854982    0 0
  v 1.31948 -0.25537 15.6827    1.57292e-007 0.684516 -0.728998    0 0
  v 7.64336 -39.0957 60.7825    -0.437891 -0.0501218 0.89763    0 0
  v 7.64336 -40.3358 62.7704    0.148072 0.0151509 -0.988861    0 0
  v -5.0044 -40.3358 62.7704    -0.148072 0.0151509 -0.988861    0 0
  v -5.0044 -39.0957 60.7825    0.437891 -0.0501217 0.89763    0 0
  v 1.31948 -40.5394 58.9918    5.82348e-009 -0.383567 0.923513    0 0
  v 11.0566 -41.918 62.9368    -0.633869 -0.669657 -0.387    0 0
  v 1.31948 -42.3352 62.1775    9.69729e-010 -0.414731 -0.909944    0 0
  v -8.41765 -41.918 62.9368    0.63387 -0.669657 -0.387    0 0
  v 6.75234 -30.5679 60.8071    -0.48487 -0.24637 0.839168    0 0
  v 6.75234 -31.4427 62.1248    0.0903209 -0.288989 -0.953062    0 0
  v -4.11337 -31.4427 62.1248    -0.0903213 -0.288989 -0.953062    0 0
  v -4.11337 -30.5679 60.8071    0.48487 -0.24637 0.839168    0 0
  v 1.31948 -34.1293 59.245    -3.7708e-009 -0.0306872 0.999529    0 0
  v 10.2259 -35.6505 62.8845    -0.913486 -0.213497 -0.346357    0 0
  v 1.31948 -35.9454 62.0238    -3.73806e-009 -0.0455797 -0.998961    0 0
  v -7.58693 -35.6505 62.8845    0.913486 -0.213497 -0.346356    0 0
  v 15.0605 -42.2972 65.1244    0.261187 -0.891041 -0.371252    0 0
  v 9.16085 -40.625 59.858    0.242506 -0.697636 -0.674162    0 0
  v -12.4215 -42.2972 65.1244    -0.261187 -0.891041 -0.371252    0 0
  v -6.52189 -40.625 59.858    -0.242507 -0.697635 -0.674163    0 0
  v 1.31948 -28.9923 60.1695    1.19987e-007 -0.943679 -0.330863    0 0
  v 13.1149 -27.5025 105.191    0.255599 -0.523071 0.81306    0 0
  v 17.1648 -32.1723 99.9755    0.304746 -0.652725 0.6936    0 0
  v 22.63 -28.9946 99.9284    0.415749 -0.558054 0.718142    0 0
  v 17.2531 -25.0416 105.146    0.339724 -0.439263 0.831646    0 0
  v 20.88 -21.9145 104.921    0.405398 -0.339031 0.848946    0 0
  v 27.2063 -24.9649 99.7401    0.47016 -0.487256 0.735888    0 0
  v 32.0822 -21.8981 100.01    0.115014 -0.79276 0.598585    0 0
  v 30.5455 -19.3492 102.144    0.0550661 -0.29009 0.955414    0 0
  v 22.9835 -18.4247 105.027    0.410529 -0.235491 0.880915    0 0
  v 24.0782 -15.0291 105.026    0.448184 -0.0316916 0.893379    0 0
  v 31.4789 -16.4765 102.146    0.149363 0.235682 0.960284    0 0
  v 34.382 -14.8517 100.014    0.376773 0.698956 0.607868    0 0
  v 31.7471 -11.0997 99.7273    0.606555 0.205699 0.76797    0 0
  v 24.2179 -11.5296 104.917    0.485236 0.0822362 0.870507    0 0
  v 22.7563 -7.74051 105.143    0.469148 0.205712 0.858827    0 0
  v 29.9467 -6.29109 99.915    0.594394 0.270332 0.757375    0 0
  v 26.8904 -1.29915 99.9687    0.533277 0.410682 0.739564    0 0
  v 20.4213 -4.04497 105.202    0.417377 0.32974 0.846799    0 0
  v 17.1614 -0.858133 105.202    0.337737 0.441436 0.831305    0 0
  v 22.5668 3.03396 99.9742    0.426113 0.551956 0.716779    0 0
  v 17.1648 6.28743 99.9755    0.305965 0.652189 0.693567    0 0
  v 13.1149 1.61767 105.191    0.25518 0.523388 0.812987    0 0
  v 8.61063 3.39294 105.155    0.170194 0.588946 0.790048    0 0
  v 11.0739 8.46182 99.9755    0.18589 0.714041 0.674975    0 0
  v 4.61214 9.5532 99.9755    0.0616742 0.743822 0.665526    0 0
  v 3.80229 4.24284 105.146    0.0454462 0.626952 0.777731    0 0
  v 20.4386 -35.9701 94.1098    0.343842 -0.742653 0.574665    0 0
  v 22.905 -38.7372 88.2788    0.359924 -0.809116 0.464527    0 0
  v 30.1516 -34.4467 88.3307    0.525294 -0.6869 0.50223    0 0
  v 26.9031 -32.1274 94.1496    0.478348 -0.643399 0.59768    0 0
  v 32.0261 -27.1576 94.309    0.570759 -0.562294 0.59838    0 0
  v 35.9929 -28.817 88.1353    0.686716 -0.545922 0.47999    0 0
  v 40.0482 -22.6161 87.9795    0.808623 -0.410587 0.421363    0 0
  v 38.6375 -21.2084 94.118    0.822088 -0.568014 0.0391433    0 0
  v 35.5994 -22.9974 96.389    0.353346 -0.875063 0.330774    0 0
  v 38.2058 -14.9719 96.3933    0.647216 0.66421 0.374079    0 0
  v 39.8775 -17.3566 94.1199    0.998304 0.0270708 0.0515349    0 0
  v 41.9813 -16.5859 87.9773    0.891864 -0.115618 0.437278    0 0
  v 41.8351 -10.1158 88.1328    0.85416 0.141242 0.500461    0 0
  v 37.3947 -10.6484 94.2962    0.73591 0.215642 0.641821    0 0
  v 35.6615 -4.81997 94.1362    0.68903 0.31637 0.652034    0 0
  v 39.9257 -3.3962 87.9252    0.786467 0.364679 0.498476    0 0
  v 35.9228 2.97095 87.8766    0.683766 0.56492 0.461875    0 0
  v 32.1007 1.08724 94.103    0.610807 0.479086 0.63039    0 0
  v 26.9181 6.20548 94.1084    0.488007 0.638383 0.595245    0 0
  v 30.0991 8.45774 87.8794    0.542381 0.731263 0.413615    0 0
  v 22.8293 12.7301 87.8797    0.388541 0.840436 0.37776    0 0
  v 20.4386 10.0853 94.1098    0.348623 0.746991 0.566097    0 0
  v 13.1063 12.6954 94.1098    0.209274 0.810183 0.547548    0 0
  v 14.5906 15.6478 87.8783    0.232682 0.904923 0.356333    0 0
  v 5.80405 17.1236 87.8765    0.0777526 0.934938 0.346188    0 0
  v 5.301 14.0103 94.1098    0.0699707 0.839914 0.538189    0 0
  v 39.0287 -29.7572 80.9695    0.787447 -0.556526 0.264965    0 0
  v 40.083 -29.8206 73.3934    0.81014 -0.5837 -0.0544731    0 0
  v 43.9772 -23.4771 73.3573    0.898582 -0.437613 -0.0323411    0 0
  v 42.8786 -23.4188 80.9351    0.867465 -0.417998 0.269782    0 0
  v 45.0832 -16.5673 80.9346    0.946171 -0.144219 0.289762    0 0
  v 46.2704 -16.5144 73.3573    0.987166 -0.158457 -0.0198641    0 0
  v 46.2704 -9.37041 73.3573    0.987164 0.158651 -0.0183844    0 0
  v 45.054 -9.48089 80.9657    0.942801 0.145878 0.299743    0 0
  v 42.8541 -2.49159 80.9242    0.864017 0.419928 0.277732    0 0
  v 43.9772 -2.40776 73.3573    0.892604 0.449797 -0.0306757    0 0
  v 39.5045 4.02877 73.3573    0.741645 0.668861 -0.0508737    0 0
  v 38.5076 4.00064 80.9145    0.73296 0.638349 0.235118    0 0
  v 32.2489 9.62524 80.915    0.571998 0.798597 0.187246    0 0
  v 33.0793 9.61239 73.3573    0.569353 0.818863 -0.072808    0 0
  v 25.0689 14.0691 73.3538    0.403633 0.910385 -0.090993    0 0
  v 24.4447 14.0898 80.9134    0.408486 0.900329 0.150154    0 0
  v 15.5935 17.18 80.9064    0.244663 0.961241 0.127105    0 0
  v 15.981 17.1778 73.3397    0.242207 0.964777 -0.102671    0 0
  v 6.27531 18.78 73.3222    0.0818641 0.990823 -0.107557    0 0
  v 6.14396 18.7569 80.8976    0.0821007 0.989719 0.117116    0 0
  v 24.5488 -38.6461 65.3318    0.379267 -0.810111 -0.447076    0 0
  v 21.8104 -35.6439 58.9866    0.341548 -0.715853 -0.609016    0 0
  v 28.3627 -31.9618 59.0738    0.443556 -0.636798 -0.630672    0 0
  v 32.0806 -34.4241 65.4912    0.517793 -0.717777 -0.465495    0 0
  v 38.2128 -29.1269 65.8921    0.694338 -0.581993 -0.423295    0 0
  v 33.8567 -27.2534 59.0738    0.552589 -0.502697 -0.664787    0 0
  v 37.6813 -21.8258 59.0738    0.638106 -0.326048 -0.697505    0 0
  v 42.3689 -22.9078 65.8621    0.815441 -0.411637 -0.406954    0 0
  v 44.5771 -16.3214 65.8621    0.89625 -0.146724 -0.418578    0 0
  v 39.6421 -15.9545 59.0738    0.685881 -0.111975 -0.719047    0 0
  v 39.6421 -9.93032 59.0738    0.685881 0.111975 -0.719047    0 0
  v 44.5771 -9.56345 65.8621    0.89625 0.146724 -0.418578    0 0
  v 42.3689 -2.97707 65.8621    0.813599 0.417423 -0.404741    0 0
  v 37.6813 -4.05904 59.0738    0.638148 0.326425 -0.69729    0 0
  v 33.8567 1.36858 59.0738    0.553621 0.506541 -0.660999    0 0
  v 38.0617 3.11162 65.8621    0.680067 0.624326 -0.38435    0 0
  v 31.8744 8.39349 65.8621    0.525446 0.768928 -0.364219    0 0
  v 28.3627 6.07698 59.0738    0.444106 0.64753 -0.619253    0 0
  v 21.5203 9.83039 59.072    0.325694 0.744607 -0.582653    0 0
  v 24.1624 12.6096 65.8586    0.374724 0.858778 -0.349402    0 0
  v 15.4182 15.5514 65.8446    0.225958 0.912601 -0.340737    0 0
  v 13.7779 12.4328 59.065    0.199691 0.806422 -0.556603    0 0
  v 5.5286 13.5428 58.7167    0.042249 0.813646 -0.579824    0 0
  v 6.08456 17.0684 65.827    0.0760707 0.937669 -0.339102    0 0
  v 17.3305 -31.8983 53.6077    0.265007 -0.560815 -0.784384    0 0
  v 11.869 -27.4536 49.4185    0.232424 -0.422487 -0.876061    0 0
  v 15.5349 -25.0685 49.4185    0.279753 -0.326165 -0.90297    0 0
  v 22.7167 -28.7903 53.6251    0.338182 -0.469875 -0.815384    0 0
  v 27.0962 -24.867 53.6251    0.396976 -0.347796 -0.849381    0 0
  v 18.4966 -22.0666 49.4185    0.308534 -0.226181 -0.923931    0 0
  v 20.5583 -18.6061 49.4185    0.322924 -0.132409 -0.937117    0 0
  v 30.1449 -20.3445 53.6251    0.435271 -0.213266 -0.874675    0 0
  v 31.7079 -15.4523 53.6251    0.454244 -0.0710456 -0.88804    0 0
  v 21.6153 -14.8628 49.4185    0.328847 -0.0430449 -0.943402    0 0
  v 21.6153 -11.022 49.4185    0.328847 0.0430448 -0.943402    0 0
  v 31.7079 -10.4326 53.6251    0.454244 0.0710457 -0.88804    0 0
  v 30.1449 -5.54036 53.6251    0.435271 0.213266 -0.874675    0 0
  v 20.5583 -7.27871 49.4185    0.322924 0.132409 -0.937117    0 0
  v 18.4966 -3.81825 49.4185    0.308533 0.226181 -0.923931    0 0
  v 27.0962 -1.0178 53.6251    0.396976 0.347797 -0.849381    0 0
  v 22.7167 2.90546 53.6251    0.337624 0.471132 -0.81489    0 0
  v 15.5349 -0.816351 49.4185    0.279753 0.326165 -0.90297    0 0
  v 11.869 1.56877 49.4185    0.232424 0.422488 -0.876061    0 0
  v 17.2724 6.02776 53.6248    0.260868 0.571157 -0.778285    0 0
  v 11.1407 8.17541 53.6234    0.170857 0.64179 -0.747605    0 0
  v 7.78602 3.19637 49.4185    0.162047 0.504195 -0.84825    0 0
  v 3.4978 4.20305 49.4185    0.105427 0.558063 -0.823074    0 0
  v 4.63478 9.15618 53.2821    0.105072 0.676994 -0.72845    0 0
  v 57.3279 -24.5696 125.927    0.129905 -0.150339 0.980063    0 0
  v 58.0792 -25.6364 125.385    0.285583 -0.482816 0.827847    0 0
  v 59.4477 -24.8442 125.038    0.582286 -0.257549 0.77111    0 0
  v 58.6259 -23.7707 125.601    0.397595 0.105587 0.911466    0 0
  v 37.8038 -20.1645 104.527    -0.577821 -0.267452 0.771098    0 0
  v 38.4492 -21.4055 103.615    -0.335459 -0.887656 0.315491    0 0
  v 44.885 -22.6318 110.381    -0.479122 -0.854939 0.198803    0 0
  v 44.4757 -21.8658 110.84    -0.764543 -0.26643 0.586933    0 0
  v 39.9477 -21.7536 102.217    0.100303 -0.991197 -0.0864133    0 0
  v 41.4098 -20.8569 101.237    0.645943 -0.64444 -0.409212    0 0
  v 46.7361 -22.2069 109.359    0.549231 -0.630276 -0.548723    0 0
  v 45.7892 -22.7682 109.788    0.0830222 -0.958062 -0.27427    0 0
  v 41.9211 -19.2309 101.257    0.896423 0.226474 -0.380966    0 0
  v 41.127 -18.0093 102.267    0.508942 0.860395 0.0264244    0 0
  v 46.4542 -20.5318 109.927    0.478246 0.870016 -0.119801    0 0
  v 47.0021 -21.3123 109.414    0.798809 0.338378 -0.497398    0 0
  v 39.5672 -17.857 103.665    0.0698064 0.917778 0.390911    0 0
  v 38.2537 -18.7343 104.547    -0.374325 0.518911 0.768513    0 0
  v 44.7417 -20.9712 110.896    -0.549654 0.556169 0.623342    0 0
  v 45.55 -20.3953 110.519    -0.0809599 0.938157 0.336611    0 0
  v 48.2395 -23.2262 115.956    -0.874624 -0.25604 0.411675    0 0
  v 48.8012 -24.1226 115.493    -0.548657 -0.835502 0.0302109    0 0
  v 49.8823 -25.2325 117.553    -0.64216 -0.683901 -0.346282    0 0
  v 48.9924 -23.8609 118.232    -0.988588 -0.145778 -0.03799    0 0
  v 49.9688 -24.2804 114.96    0.0489896 -0.899754 -0.433639    0 0
  v 51.1585 -23.6207 114.624    0.472639 -0.545816 -0.691879    0 0
  v 53.5668 -24.449 116.316    0.25098 -0.357071 -0.899727    0 0
  v 51.7121 -25.4678 116.787    -0.0722613 -0.706838 -0.703675    0 0
  v 51.4634 -22.5723 114.737    0.667591 0.384172 -0.637757    0 0
  v 50.7312 -21.6592 115.242    0.377392 0.884547 -0.274138    0 0
  v 52.8963 -21.4434 117.25    0.15633 0.795032 -0.586076    0 0
  v 54.0405 -22.8393 116.501    0.360011 0.376784 -0.853479    0 0
  v 49.5636 -21.5014 115.775    -0.188734 0.962815 0.193306    0 0
  v 48.5444 -22.1777 116.069    -0.666943 0.581469 0.465919    0 0
  v 49.466 -22.2511 118.417    -0.78063 0.624749 0.0174605    0 0
  v 51.0665 -21.2081 118.017    -0.32275 0.923192 -0.208685    0 0
  v 48.8511 -24.2276 119.514    -0.988487 -0.140217 -0.056859    0 0
  v 50.0862 -26.1257 118.581    -0.641313 -0.678173 -0.358886    0 0
  v 50.519 -26.8729 119.7    -0.589927 -0.797468 -0.126612    0 0
  v 49.0161 -24.5662 120.831    -0.948895 -0.217878 0.228313    0 0
  v 52.6253 -26.4467 117.518    -0.0771449 -0.695953 -0.713932    0 0
  v 55.1988 -25.03 116.858    0.233721 -0.34434 -0.909288    0 0
  v 56.7398 -25.5349 117.601    0.360492 -0.450542 -0.816736    0 0
  v 53.6085 -27.2604 118.408    0.00295734 -0.824708 -0.565552    0 0
  v 55.8616 -22.7984 117.113    0.331152 0.372987 -0.866729    0 0
  v 54.2822 -20.8675 118.155    0.13424 0.781214 -0.60966    0 0
  v 55.6323 -20.4747 119.178    0.240042 0.84566 -0.476696    0 0
  v 57.5494 -22.8207 117.91    0.482753 0.385532 -0.78633    0 0
  v 51.7432 -20.5465 119.217    -0.330947 0.912384 -0.240892    0 0
  v 49.5139 -21.9959 119.769    -0.780612 0.624887 -0.0126675    0 0
  v 49.8256 -21.8519 121.14    -0.74394 0.620671 0.247632    0 0
  v 52.5428 -20.0872 120.47    -0.275566 0.960574 -0.03689    0 0
  v 49.7716 -24.8989 122.392    -0.825103 -0.276225 0.492854    0 0
  v 51.4356 -27.4513 121.141    -0.492848 -0.861479 0.122291    0 0
  v 52.8774 -27.7039 122.801    -0.353156 -0.859099 0.370447    0 0
  v 51.226 -25.1707 124.043    -0.633866 -0.309994 0.708603    0 0
  v 54.8561 -27.8788 119.711    0.0922453 -0.923834 -0.371513    0 0
  v 58.3229 -25.9677 118.817    0.497579 -0.556293 -0.665548    0 0
  v 59.7125 -26.2317 120.495    0.637725 -0.650108 -0.413118    0 0
  v 56.272 -28.1283 121.382    0.190479 -0.974581 -0.117941    0 0
  v 59.2207 -22.9632 119.158    0.65609 0.384559 -0.649353    0 0
  v 57.1006 -20.3676 120.563    0.357534 0.885512 -0.296711    0 0
  v 58.4992 -20.6738 122.227    0.486537 0.872807 -0.0386001    0 0
  v 60.6034 -23.2499 120.833    0.847259 0.35117 -0.398538    0 0
  v 53.6801 -19.9401 121.993    -0.198528 0.961364 0.1907    0 0
  v 50.6694 -21.8945 122.733    -0.65139 0.571318 0.499286    0 0
  v 52.1169 -22.1889 124.381    -0.503136 0.474643 0.722196    0 0
  v 55.1046 -20.2494 123.646    -0.094034 0.892375 0.441389    0 0
  v 53.3111 -25.2489 125.266    -0.338716 -0.317304 0.885771    0 0
  v 54.6719 -27.3389 124.24    -0.135733 -0.754293 0.642354    0 0
  v 56.4528 -26.4757 125.148    0.0575511 -0.604693 0.794377    0 0
  v 55.5471 -25.0983 125.829    -0.0877678 -0.289349 0.953191    0 0
  v 57.4694 -27.6911 123.07    0.306933 -0.911928 0.272358    0 0
  v 60.3048 -26.1295 122.341    0.733723 -0.674855 0.0788799    0 0
  v 60.0239 -25.6702 123.954    0.670043 -0.54348 0.50564    0 0
  v 58.1721 -26.6959 124.428    0.35726 -0.726535 0.586951    0 0
  v 61.0365 -23.6712 122.621    0.967813 0.209584 0.139331    0 0
  v 59.2986 -21.5455 123.769    0.607835 0.687672 0.397044    0 0
  v 59.3347 -22.7588 124.879    0.581431 0.376235 0.721377    0 0
  v 60.4698 -24.158 124.128    0.815066 0.0105917 0.579271    0 0
  v 56.5011 -21.1933 124.939    0.0700884 0.665281 0.743296    0 0
  v 54.0428 -22.7907 125.546    -0.254232 0.294148 0.921327    0 0
  v 55.9931 -23.5862 126.003    -0.0315707 0.108798 0.993562    0 0
  v 57.6155 -22.5387 125.599    0.213325 0.375442 0.901962    0 0
  v 9.58549 -0.285746 46.1521    0.444701 0.763268 0.468683    0 0
  v 12.4696 -2.36685 46.1524    0.573415 0.636808 0.515433    0 0
  v 13.9318 -1.61542 43.2312    0.593976 0.695134 0.404945    0 0
  v 10.729 0.62724 43.2306    0.457304 0.80877 0.369816    0 0
  v 14.8002 -4.92605 46.1533    0.670912 0.473423 0.570743    0 0
  v 16.4078 -7.85111 46.173    0.737562 0.290361 0.609665    0 0
  v 18.262 -7.2163 43.2584    0.799764 0.350922 0.487065    0 0
  v 16.4988 -4.27743 43.2335    0.707592 0.547845 0.446296    0 0
  v 17.1872 -11.0861 46.2472    0.781056 0.0973089 0.616832    0 0
  v 16.9721 -14.5202 46.528    0.791303 -0.0975026 0.603599    0 0
  v 18.3553 -14.9364 45.2236    0.50904 0.0944654 0.855543    0 0
  v 19.7357 -12.8277 43.2929    0.746192 0.365159 0.556648    0 0
  v 19.1103 -10.3894 43.3463    0.845419 0.158294 0.510107    0 0
  v 16.1126 -17.934 46.5272    0.752582 -0.291294 0.590565    0 0
  v 14.7 -20.9719 46.2451    0.675197 -0.473599 0.565521    0 0
  v 16.1882 -21.8977 43.3408    0.677606 -0.576189 0.457008    0 0
  v 17.8345 -20.2283 43.3137    0.490767 -0.715599 0.497057    0 0
  v 17.5601 -18.0417 45.232    0.416684 -0.335023 0.845065    0 0
  v 12.4496 -23.5206 46.1707    0.573619 -0.636849 0.515155    0 0
  v 9.58549 -25.5991 46.1521    0.444654 -0.763274 0.468717    0 0
  v 10.729 -26.5121 43.2306    0.456055 -0.809336 0.370119    0 0
  v 13.8697 -24.3275 43.2526    0.587482 -0.697587 0.410167    0 0
  v 6.38098 -27.0336 46.1521    0.28029 -0.857096 0.432233    0 0
  v 3.02363 -27.744 46.1521    0.0948036 -0.906581 0.411245    0 0
  v 3.27617 -28.8875 43.2306    0.0962095 -0.941139 0.32404    0 0
  v 7.11476 -28.0931 43.2306    0.28442 -0.896191 0.340511    0 0
  v 11.6383 1.37297 39.7645    0.474758 0.848828 0.232583    0 0
  v 15.0907 -1.02242 39.7651    0.62652 0.738351 0.249622    0 0
  v 15.7872 -0.671061 35.7226    0.649455 0.753564 0.101732    0 0
  v 12.1878 1.84146 35.7223    0.4851 0.868936 0.0981218    0 0
  v 17.834 -3.85154 39.7674    0.762138 0.592214 0.26159    0 0
  v 19.7214 -6.96677 39.768    0.88192 0.386743 0.26953    0 0
  v 20.5643 -7.0865 35.718    0.920186 0.379349 0.0967041    0 0
  v 18.625 -3.69001 35.7238    0.798095 0.594577 0.0975823    0 0
  v 20.6817 -10.3338 39.7585    0.945493 0.172759 0.276037    0 0
  v 21.1027 -12.8992 40.1786    0.925629 0.340743 0.164638    0 0
  v 21.5426 -15.2177 37.9489    0.984994 -0.000529841 -0.172591    0 0
  v 21.64 -14.81 35.3157    0.992094 -0.104549 0.0694126    0 0
  v 21.5574 -10.8332 35.689    0.985438 0.135833 0.102279    0 0
  v 20.6953 -18.4936 37.9573    0.860403 -0.475607 -0.183042    0 0
  v 19.1494 -20.4703 40.1994    0.64392 -0.75665 0.11335    0 0
  v 17.6113 -22.3102 39.7529    0.741031 -0.625824 0.243345    0 0
  v 18.6097 -22.1945 35.6864    0.79701 -0.596517 0.0945652    0 0
  v 20.6348 -18.7082 35.3148    0.919256 -0.388752 0.0619743    0 0
  v 15.0462 -24.9178 39.7622    0.623024 -0.743506 0.242979    0 0
  v 11.6383 -27.2578 39.7645    0.47377 -0.84956 0.231924    0 0
  v 12.1878 -27.7263 35.7223    0.48514 -0.868921 0.0980573    0 0
  v 15.7842 -25.2137 35.7151    0.650206 -0.752958 0.10142    0 0
  v 7.69878 -28.9585 39.7645    0.291942 -0.931997 0.214828    0 0
  v 3.47725 -29.8213 39.7645    0.0986385 -0.973796 0.20492    0 0
  v 3.59901 -30.4077 35.7223    0.100064 -0.991147 0.0872664    0 0
  v 8.05219 -29.502 35.7223    0.296204 -0.950761 0.0911912    0 0
  v 12.2824 1.92427 31.4043    0.487562 0.872102 -0.0414948    0 0
  v 15.9053 -0.622171 31.4044    0.657396 0.752073 -0.0470797    0 0
  v 15.4508 -0.875135 27.0865    0.650088 0.739753 -0.173641    0 0
  v 11.9251 1.61152 27.0865    0.482612 0.861115 -0.159893    0 0
  v 18.7525 -3.72754 31.4046    0.809463 0.58447 -0.0562603    0 0
  v 20.6878 -7.22601 31.4035    0.926177 0.371828 -0.0627691    0 0
  v 20.1185 -7.3751 27.0865    0.910173 0.362388 -0.200646    0 0
  v 18.2282 -3.92738 27.0865    0.798936 0.571099 -0.188537    0 0
  v 21.6685 -10.9845 31.3977    0.989734 0.128458 -0.0626506    0 0
  v 21.685 -14.852 31.323    0.990535 -0.11858 -0.0691256    0 0
  v 21.0752 -14.8246 27.0865    0.970275 -0.123163 -0.208318    0 0
  v 21.0752 -11.0602 27.0865    0.970418 0.123951 -0.207183    0 0
  v 20.7019 -18.6408 31.3228    0.924151 -0.375926 -0.0680059    0 0
  v 18.7494 -22.1572 31.3972    0.809467 -0.584542 -0.0554497    0 0
  v 18.2282 -21.9575 27.0865    0.798911 -0.57114 -0.188523    0 0
  v 20.1185 -18.5098 27.0865    0.909823 -0.36269 -0.20169    0 0
  v 15.9047 -25.2627 31.4029    0.657577 -0.751929 -0.0468557    0 0
  v 12.2824 -27.8091 31.4043    0.487579 -0.872093 -0.0414856    0 0
  v 11.9251 -27.4964 27.0865    0.482613 -0.861115 -0.159892    0 0
  v 15.4508 -25.0097 27.0865    0.650095 -0.73975 -0.173628    0 0
  v 8.11308 -29.5981 31.4043    0.297023 -0.954098 -0.0383876    0 0
  v 3.61999 -30.5114 31.4043    0.100341 -0.994273 -0.0367802    0 0
  v 3.54073 -30.12 27.0865    0.099504 -0.984788 -0.142446    0 0
  v 7.88311 -29.2353 27.0865    0.294629 -0.943991 -0.148574    0 0
  v 11.2174 0.991909 23.0204    0.471732 0.838161 -0.27378    0 0
  v 14.5514 -1.36789 23.0204    0.631643 0.716702 -0.295575    0 0
  v 13.2088 -2.10342 19.4729    0.581928 0.657379 -0.478761    0 0
  v 10.1609 0.0670403 19.4729    0.440731 0.777456 -0.448684    0 0
  v 17.1949 -4.28126 23.0204    0.77199 0.550184 -0.318321    0 0
  v 19.0031 -7.58731 23.0204    0.875083 0.34765 -0.336704    0 0
  v 17.3376 -7.9051 19.4725    0.786787 0.311263 -0.532992    0 0
  v 15.6524 -4.8095 19.4729    0.701914 0.498132 -0.509098    0 0
  v 19.921 -11.1308 23.0204    0.930351 0.118468 -0.347005    0 0
  v 19.921 -14.7541 23.0204    0.931112 -0.117698 -0.34522    0 0
  v 18.2426 -14.6591 19.4971    0.839823 -0.0951544 -0.534456    0 0
  v 18.1949 -11.2411 19.4711    0.831135 0.106736 -0.54573    0 0
  v 19.0031 -18.2975 23.0204    0.875414 -0.348597 -0.334859    0 0
  v 17.1949 -21.6036 23.0204    0.77193 -0.550265 -0.318329    0 0
  v 15.6506 -21.0721 19.4711    0.701115 -0.49935 -0.509006    0 0
  v 17.3838 -17.9843 19.4971    0.789925 -0.324657 -0.520208    0 0
  v 14.5514 -24.517 23.0204    0.63165 -0.716679 -0.295618    0 0
  v 11.2174 -26.8768 23.0204    0.471733 -0.838159 -0.273782    0 0
  v 10.1609 -25.9519 19.4729    0.440759 -0.777427 -0.448708    0 0
  v 13.2085 -23.7808 19.4725    0.582043 -0.657033 -0.479097    0 0
  v 7.42751 -28.5165 23.0204    0.289556 -0.922491 -0.255281    0 0
  v 3.38371 -29.3446 23.0204    0.0977249 -0.964559 -0.245104    0 0
  v 3.14932 -28.1873 19.4729    0.0925097 -0.908685 -0.407103    0 0
  v 6.74744 -27.4436 19.4729    0.273965 -0.864122 -0.422181    0 0
  v 8.65808 -1.2486 16.7254    0.362919 0.630937 -0.685718    0 0
  v 11.299 -3.14971 16.7254    0.465001 0.5217 -0.715265    0 0
  v 8.8703 -4.4685 14.796    0.334408 0.374599 -0.864781    0 0
  v 6.74351 -2.88952 14.8013    0.276238 0.45661 -0.845695    0 0
  v 13.4582 -5.56093 16.7254    0.54773 0.386203 -0.742185    0 0
  v 14.9666 -8.35977 16.7236    0.602723 0.236986 -0.761946    0 0
  v 12.0119 -8.87847 14.8058    0.424975 0.171673 -0.888777    0 0
  v 10.7124 -6.50084 14.8055    0.389228 0.274684 -0.879233    0 0
  v 15.7309 -11.4111 16.7163    0.633373 0.0879264 -0.768835    0 0
  v 15.9693 -14.5502 16.8465    0.670821 -0.0530643 -0.739718    0 0
  v 14.1367 -14.75 15.19    0.765416 0.0477051 -0.641765    0 0
  v 12.5657 -13.1697 14.3688    0.490806 0.41676 -0.765128    0 0
  v 12.6686 -11.3815 14.7973    0.444638 0.0982476 -0.890306    0 0
  v 15.1979 -17.548 16.8465    0.629591 -0.28157 -0.724109    0 0
  v 13.4493 -20.3077 16.7163    0.547698 -0.39628 -0.736878    0 0
  v 10.586 -19.5727 14.7949    0.380048 -0.320517 -0.867659    0 0
  v 11.305 -18.0665 14.3792    0.329701 -0.63386 -0.699656    0 0
  v 13.5616 -16.9805 15.1942    0.677578 -0.415691 -0.606703    0 0
  v 11.2973 -22.7319 16.7236    0.465423 -0.521697 -0.714992    0 0
  v 8.65808 -24.6363 16.7254    0.362954 -0.63095 -0.685687    0 0
  v 6.74351 -22.9953 14.8013    0.275687 -0.457582 -0.845349    0 0
  v 8.84501 -21.4541 14.7939    0.333224 -0.382099 -0.861953    0 0
  v 5.78003 -25.9174 16.7254    0.232631 -0.71815 -0.655853    0 0
  v 2.8159 -26.5409 16.7254    0.0784531 -0.765846 -0.638221    0 0
  v 2.4197 -24.5611 14.8356    0.058847 -0.597126 -0.799986    0 0
  v 4.5904 -24.0725 14.8287    0.1915 -0.543449 -0.817307    0 0
  v 4.58414 -4.63927 13.4657    0.211584 0.318213 -0.924107    0 0
  v 6.14335 -5.91526 13.4393    0.237216 0.26722 -0.933982    0 0
  v 3.95824 -7.57363 12.6423    0.13531 0.140329 -0.980815    0 0
  v 2.21316 -7.19003 12.4866    0.0853857 0.136417 -0.986965    0 0
  v 2.3918 -5.76428 12.7592    0.0896238 0.224225 -0.970408    0 0
  v 7.75761 -7.511 13.4868    0.27627 0.193097 -0.941482    0 0
  v 8.8611 -9.4674 13.4969    0.296673 0.121665 -0.947197    0 0
  v 5.99591 -10.2771 12.7019    0.179328 0.0758205 -0.980863    0 0
  v 5.12734 -8.68853 12.6899    0.171207 0.100353 -0.980111    0 0
  v 9.39981 -11.5298 13.4895    0.299959 0.0782779 -0.950735    0 0
  v 9.87247 -13.0437 13.3335    0.189187 0.437251 -0.879216    0 0
  v 7.94173 -14.1985 12.8067    -0.0329563 0.157519 -0.986966    0 0
  v 6.04718 -13.8314 12.6125    0.156356 0.00691582 -0.987677    0 0
  v 6.39131 -11.9454 12.696    0.186482 0.0275712 -0.982071    0 0
  v 7.47612 -16.029 12.8109    -0.0794031 -0.142888 -0.986549    0 0
  v 8.72129 -17.5405 13.344    0.0459065 -0.536286 -0.842787    0 0
  v 7.59319 -18.6118 13.4777    0.253022 -0.230684 -0.939556    0 0
  v 5.06923 -17.243 12.6823    0.161164 -0.107266 -0.981081    0 0
  v 5.60669 -15.5969 12.6125    0.134607 -0.0829177 -0.987424    0 0
  v 6.11046 -20.0172 13.4374    0.232407 -0.271301 -0.934014    0 0
  v 4.58414 -21.2456 13.4657    0.210822 -0.318953 -0.924026    0 0
  v 2.3918 -20.1206 12.7592    0.0895361 -0.224307 -0.970397    0 0
  v 2.21316 -18.6948 12.4866    0.0852026 -0.13649 -0.986971    0 0
  v 3.94521 -18.3217 12.6406    0.133528 -0.141016 -0.980961    0 0
  v 3.37166 -22.2772 13.6031    0.162809 -0.396815 -0.903344    0 0
  v 2.0549 -22.666 13.6374    0.0399669 -0.455882 -0.889143    0 0
  v 2.04932 -21.2151 13.0255    0.0624049 -0.313511 -0.947532    0 0
  v 33.3517 -18.7276 35.6846    0.850067 -0.135455 -0.508958    0 0
  v 32.5658 -19.4932 35.4957    0.357094 -0.686119 -0.633818    0 0
  v 31.7259 -18.7656 34.8261    0.098764 -0.288869 -0.952261    0 0
  v 32.5244 -17.9969 35.0307    0.445425 0.288813 -0.847457    0 0
  v 19.4594 -17.863 44.8823    0.0882279 -0.381193 0.920276    0 0
  v 19.628 -19.5742 43.2713    0.176206 -0.86553 0.468837    0 0
  v 21.8883 -19.3043 43.3367    0.0496011 -0.9008 0.431392    0 0
  v 21.9194 -17.8434 44.7966    0.0418703 -0.400817 0.915201    0 0
  v 20.5101 -19.708 40.9026    0.33273 -0.92958 -0.158658    0 0
  v 21.6342 -18.1668 39.0627    0.465931 -0.563035 -0.682569    0 0
  v 23.1417 -18.0857 39.4495    0.0526506 -0.542715 -0.838265    0 0
  v 22.3773 -19.4013 41.1979    0.0772376 -0.952224 -0.295471    0 0
  v 22.2383 -15.889 39.0162    0.581315 0.292279 -0.759372    0 0
  v 21.9873 -14.1372 40.7864    0.574489 0.791781 -0.207476    0 0
  v 23.6174 -14.734 40.9278    0.189926 0.903402 -0.384439    0 0
  v 23.6378 -16.2188 39.3415    0.0977731 0.418167 -0.903093    0 0
  v 21.0948 -14.0375 43.1551    0.399915 0.772286 0.493602    0 0
  v 20.0531 -15.6193 44.8358    0.181112 0.346958 0.920227    0 0
  v 22.4155 -15.9765 44.6885    0.119701 0.452767 0.883557    0 0
  v 23.1285 -14.6371 43.0666    0.202032 0.89662 0.394025    0 0
  v 24.5293 -17.9577 44.4992    0.161166 -0.406461 0.899341    0 0
  v 24.265 -19.299 43.1492    0.0395425 -0.909682 0.413419    0 0
  v 26.525 -19.4503 42.5069    0.0840068 -0.911227 0.403247    0 0
  v 27.0149 -18.1742 43.7187    0.334754 -0.404748 0.850952    0 0
  v 24.3622 -19.3846 41.0837    -0.092511 -0.945136 -0.313304    0 0
  v 24.7722 -18.1716 39.3355    -0.209082 -0.517371 -0.829827    0 0
  v 26.278 -18.3643 38.8433    -0.434168 -0.494911 -0.752702    0 0
  v 26.2303 -19.5264 40.5567    -0.21755 -0.934406 -0.282058    0 0
  v 25.187 -16.434 39.1688    -0.147089 0.439359 -0.886188    0 0
  v 25.3991 -15.0406 40.6669    0.0342041 0.912153 -0.408421    0 0
  v 27.0288 -15.3154 40.0099    -0.0459413 0.909651 -0.412826    0 0
  v 26.5974 -16.6799 38.6246    -0.35434 0.43692 -0.826768    0 0
  v 25.302 -14.9551 42.7323    0.211443 0.911499 0.35279    0 0
  v 24.9441 -16.2201 44.3324    0.247875 0.459983 0.852627    0 0
  v 27.3342 -16.4898 43.5    0.438493 0.4444 0.781174    0 0
  v 27.3235 -15.2394 41.96    0.315241 0.898123 0.306591    0 0
  v 29.2378 -18.4542 42.3884    0.526036 -0.399919 0.750567    0 0
  v 28.553 -19.6619 41.3672    0.168763 -0.912007 0.373849    0 0
  v 30.29 -19.8636 39.8319    0.239186 -0.912441 0.332026    0 0
  v 31.1155 -18.7513 40.6091    0.659254 -0.390893 0.642329    0 0
  v 27.9015 -19.729 39.6119    -0.290238 -0.929771 -0.22647    0 0
  v 27.609 -18.622 38.0003    -0.605299 -0.489504 -0.627693    0 0
  v 28.7637 -18.8946 36.9385    -0.660452 -0.526355 -0.535494    0 0
  v 29.3492 -19.921 38.3637    -0.299258 -0.936928 -0.180584    0 0
  v 27.8457 -17.0202 37.7176    -0.52083 0.425153 -0.740257    0 0
  v 28.4931 -15.7244 38.9052    -0.0737391 0.904371 -0.420329    0 0
  v 29.7649 -16.2715 37.4938    -0.102855 0.898526 -0.426698    0 0
  v 28.93 -17.4348 36.5905    -0.599291 0.409745 -0.687721    0 0
  v 29.1446 -15.6573 40.6605    0.442172 0.873489 0.203716    0 0
  v 29.4745 -16.8524 42.1057    0.629952 0.438463 0.641023    0 0
  v 31.2818 -17.2915 40.2611    0.731758 0.463374 0.499814    0 0
  v 30.7056 -16.2141 38.962    0.473386 0.875499 0.0969889    0 0
  v 32.6207 -19.0112 38.6497    0.761064 -0.37892 0.526499    0 0
  v 31.7333 -20.012 38.1475    0.307329 -0.91346 0.266719    0 0
  v 32.6588 -19.9232 36.6436    0.428466 -0.902394 -0.0458482    0 0
  v 33.4387 -19.1202 36.9168    0.913537 -0.369095 0.170934    0 0
  v 30.6005 -20.057 37.0455    -0.25247 -0.949281 -0.187415    0 0
  v 29.7886 -19.1235 35.8949    -0.605913 -0.588777 -0.534987    0 0
  v 30.7821 -19.1953 35.1605    -0.312418 -0.593293 -0.741889    0 0
  v 31.5879 -19.9524 35.9654    -0.0416169 -0.920045 -0.389596    0 0
  v 29.8696 -17.8199 35.5201    -0.592302 0.361072 -0.720281    0 0
  v 30.803 -16.7978 36.1085    -0.123729 0.880244 -0.458107    0 0
  v 31.6023 -17.345 35.1656    0.0620182 0.709844 -0.701623    0 0
  v 30.781 -18.1579 34.8415    -0.305137 0.139472 -0.94204    0 0
  v 31.9358 -16.7529 37.2104    0.463623 0.886025 0.00359048    0 0
  v 32.7017 -17.7075 38.2749    0.787737 0.493785 0.368303    0 0
  v 33.4376 -18.0828 36.5977    0.917377 0.395435 0.0452921    0 0
  v 32.6732 -17.3158 35.8437    0.54455 0.782695 -0.301418    0 0
  v 13.646 -16.741 0.734968    0.460737 -0.164534 -0.872153    0 0
  v 13.051 -17.0413 0.663427    0.0829806 -0.451098 -0.888608    0 0
  v 12.6591 -16.6263 0.584057    -0.185796 -0.00937138 -0.982544    0 0
  v 13.2317 -16.3247 0.622619    0.178115 0.287728 -0.941004    0 0
  v 13.229 -16.5973 13.7929    0.738816 -0.671971 -0.0510438    0 0
  v 11.5028 -17.4407 13.2717    0.211103 -0.962872 -0.168266    0 0
  v 11.9607 -17.3542 11.6377    0.173168 -0.982127 0.0737456    0 0
  v 13.5292 -16.595 11.9705    0.684033 -0.708184 0.174855    0 0
  v 9.65145 -17.1779 12.665    -0.33026 -0.85664 -0.396354    0 0
  v 8.67531 -16.0129 12.3172    -0.674246 -0.258014 -0.691969    0 0
  v 9.41304 -16.1175 11.036    -0.906818 -0.288557 -0.307272    0 0
  v 10.3143 -17.1632 11.2639    -0.451027 -0.885941 -0.108087    0 0
  v 9.03003 -14.6426 12.2962    -0.524728 0.508333 -0.682831    0 0
  v 10.5357 -13.7681 12.6127    -0.0766085 0.884515 -0.460179    0 0
  v 11.1008 -14.1213 11.1495    -0.183501 0.962303 -0.200751    0 0
  v 9.72767 -14.9007 10.9902    -0.70654 0.625792 -0.330432    0 0
  v 12.4089 -13.9509 13.2194    0.482741 0.834309 -0.266249    0 0
  v 13.6056 -15.147 13.7719    0.953081 0.28635 -0.0981847    0 0
  v 13.8439 -15.3782 11.9248    0.916761 0.375846 0.135235    0 0
  v 12.7473 -14.3123 11.5233    0.443808 0.895723 -0.0267279    0 0
  v 13.908 -16.7429 9.79907    0.690338 -0.710409 0.13694    0 0
  v 12.3833 -17.4722 9.56051    0.174767 -0.980984 0.0844231    0 0
  v 12.659 -17.6079 7.24348    0.177407 -0.981444 0.0727554    0 0
  v 14.1237 -16.9092 7.45362    0.695794 -0.711557 0.097758    0 0
  v 10.7789 -17.2887 9.29102    -0.464826 -0.884975 -0.0274747    0 0
  v 9.89698 -16.2844 9.12537    -0.943994 -0.287892 -0.161224    0 0
  v 10.2664 -16.4696 6.86455    -0.950563 -0.287331 -0.117775    0 0
  v 11.1161 -17.4321 7.00784    -0.466096 -0.884701 -0.00766708    0 0
  v 10.1971 -15.1162 9.06412    -0.738361 0.641557 -0.207913    0 0
  v 11.5291 -14.3683 9.13791    -0.200761 0.968555 -0.146954    0 0
  v 11.8332 -14.6344 6.8502    -0.203426 0.969354 -0.137733    0 0
  v 10.5532 -15.3505 6.80149    -0.74427 0.645211 -0.172523    0 0
  v 13.1335 -14.5517 9.4074    0.440634 0.896808 -0.0397022    0 0
  v 14.2081 -15.5748 9.73783    0.9229 0.377444 0.0760973    0 0
  v 14.4105 -15.7901 7.39057    0.927859 0.372161 0.0239454    0 0
  v 13.3761 -14.8102 7.08582    0.44239 0.894524 -0.0641773    0 0
  v 14.2472 -17.0607 5.21214    0.698678 -0.711634 0.0736614    0 0
  v 12.8603 -17.7231 5.00968    0.180181 -0.98203 0.0561451    0 0
  v 13.0271 -17.7631 3.11866    0.189043 -0.981968 0.00118661    0 0
  v 14.2906 -17.1583 3.30896    0.704042 -0.709998 0.0150843    0 0
  v 11.3983 -17.5563 4.78638    -0.464271 -0.885428 -0.0216634    0 0
  v 10.592 -16.6437 4.6539    -0.948379 -0.288467 -0.131773    0 0
  v 10.9553 -16.7771 2.79951    -0.929093 -0.29181 -0.22723    0 0
  v 11.6929 -17.6106 2.91489    -0.45381 -0.88591 -0.0960231    0 0
  v 10.8636 -15.5832 4.59411    -0.742608 0.64351 -0.185546    0 0
  v 12.0773 -14.905 4.6369    -0.201804 0.967593 -0.151784    0 0
  v 12.3116 -15.1911 2.77834    -0.19409 0.957079 -0.215243    0 0
  v 11.2028 -15.8093 2.74488    -0.728807 0.629722 -0.268868    0 0
  v 13.5393 -15.0719 4.8602    0.445409 0.891402 -0.083753    0 0
  v 14.5187 -16.0002 5.15235    0.929975 0.3676 -0.00410967    0 0
  v 14.5381 -16.1905 3.25434    0.932177 0.355857 -0.0664151    0 0
  v 13.6457 -15.3436 2.98212    0.453247 0.880643 -0.137969    0 0
  v 14.2074 -17.1563 1.93477    0.70645 -0.691166 -0.152377    0 0
  v 13.1659 -17.6573 1.76642    0.213529 -0.963629 -0.160703    0 0
  v 13.2398 -17.3941 1.0148    0.232705 -0.810903 -0.536921    0 0
  v 13.9672 -17.0402 1.13358    0.639494 -0.549957 -0.537211    0 0
  v 12.0624 -17.5305 1.5978    -0.408868 -0.856714 -0.314434    0 0
  v 11.4486 -16.8395 1.51324    -0.824901 -0.283496 -0.489048    0 0
  v 12.0538 -16.819 0.841091    -0.530264 -0.208795 -0.821721    0 0
  v 12.4939 -17.3078 0.900764    -0.241 -0.683018 -0.689496    0 0
  v 11.6525 -16.0388 1.46792    -0.658018 0.561738 -0.501461    0 0
  v 12.5723 -15.5288 1.48455    -0.167719 0.90085 -0.400425    0 0
  v 12.8456 -15.919 0.821904    -0.0686836 0.663262 -0.745229    0 0
  v 12.1908 -16.2775 0.810337    -0.444743 0.349874 -0.824495    0 0
  v 13.6758 -15.6555 1.65317    0.469294 0.832807 -0.293591    0 0
  v 14.4113 -16.3556 1.88947    0.918654 0.314141 -0.239564    0 0
  v 14.1042 -16.4988 1.10282    0.774588 0.154451 -0.613317    0 0
  v 13.5915 -16.0053 0.935929    0.434797 0.620628 -0.652513    0 0
  v 21.5158 -42.2267 80.2288    0.240428 -0.960425 0.140632    0 0
  v 21.984 -42.3129 73.9762    0.24816 -0.966105 -0.0711191    0 0
  v 24.3783 -41.621 74.9172    0.41742 -0.908633 0.0121531    0 0
  v 23.9895 -41.581 79.3169    0.416802 -0.905358 0.0812509    0 0
  v 26.4942 -40.0146 70.072    0.387206 -0.869606 -0.306361    0 0
  v 33.1323 -36.3435 70.2014    0.551511 -0.766327 -0.329513    0 0
  v 32.4449 -37.3927 72.1639    0.51057 -0.858531 -0.0473665    0 0
  v 27.7604 -39.9457 72.056    0.453214 -0.890219 -0.0459104    0 0
  v 36.8322 -34.0331 74.159    0.748877 -0.661297 -0.0432388    0 0
  v 35.9694 -34.0016 80.317    0.724919 -0.645069 0.241616    0 0
  v 34.5678 -35.5817 79.4988    0.561144 -0.817899 0.127119    0 0
  v 35.1678 -35.6471 75.1411    0.567091 -0.822418 0.0451394    0 0
  v 31.4204 -36.2917 84.1549    0.540867 -0.730596 0.416763    0 0
  v 25.1768 -39.9081 84.12    0.376059 -0.848313 0.372754    0 0
  v 26.7125 -39.8354 82.294    0.464217 -0.871753 0.156686    0 0
  v 31.1857 -37.257 82.36    0.516341 -0.839247 0.17046    0 0
  v 27.225 -31.8823 78.1788    0.674466 -0.70932 -0.204845    0 0
  v 27.4821 -31.9362 75.3578    0.63446 -0.68847 0.351383    0 0
  v 30.4168 -30.306 75.4598    0.12805 -0.908138 0.398608    0 0
  v 30.1237 -30.2427 78.2688    0.176033 -0.931128 -0.319394    0 0
  v 24.775 -41.0822 78.9498    0.773867 -0.627484 -0.0859924    0 0
  v 25.0626 -41.1339 75.2133    0.76647 -0.596376 0.238451    0 0
  v 25.2195 -40.2359 75.3322    0.909889 -0.0275693 0.413934    0 0
  v 24.9706 -40.1855 78.7481    0.960328 -0.0639098 -0.271452    0 0
  v 27.891 -39.7354 72.8172    0.515081 -0.693134 0.504238    0 0
  v 31.846 -37.5859 72.9594    0.29876 -0.836542 0.459282    0 0
  v 31.3891 -37.0146 73.295    -0.250223 -0.230741 0.940291    0 0
  v 27.7869 -38.9676 73.1509    0.331102 -0.0957801 0.938721    0 0
  v 34.1734 -36.0947 75.5083    0.132446 -0.97219 0.193145    0 0
  v 33.7096 -36.0072 79.1893    0.126927 -0.983721 -0.127207    0 0
  v 33.1017 -35.5615 78.9903    -0.764878 -0.441925 -0.468683    0 0
  v 33.515 -35.6522 75.6307    -0.843121 -0.43137 0.32104    0 0
  v 30.8812 -37.4057 81.5855    0.343217 -0.855373 -0.387994    0 0
  v 27.1024 -39.591 81.4986    0.582 -0.732594 -0.352961    0 0
  v 27.0966 -38.823 81.0839    0.45915 -0.180669 -0.869793    0 0
  v 30.5343 -36.8298 81.1716    -0.140333 -0.30286 -0.942647    0 0
  v 24.9211 -37.942 78.5757    0.959707 -0.0350683 -0.278807    0 0
  v 25.1591 -37.9891 75.2835    0.908255 -0.00139372 0.418414    0 0
  v 25.5607 -34.8049 75.3792    0.872761 -0.310005 0.377073    0 0
  v 25.3439 -34.7615 78.2137    0.91518 -0.334063 -0.225493    0 0
  v 27.6284 -36.7696 73.1811    0.291257 -0.00720246 0.956618    0 0
  v 31.0944 -34.8931 73.3198    -0.351422 -0.0505175 0.934853    0 0
  v 30.6749 -32.1288 73.6724    -0.176268 -0.403715 0.897744    0 0
  v 27.6999 -33.7485 73.5569    0.448081 -0.32352 0.833402    0 0
  v 33.1382 -33.5828 75.5707    -0.951118 -0.129696 0.280274    0 0
  v 32.7381 -33.494 78.8084    -0.868306 -0.159844 -0.469569    0 0
  v 32.1119 -30.9199 78.4189    -0.673321 -0.557063 -0.486127    0 0
  v 32.4453 -30.9937 75.6234    -0.753443 -0.542838 0.371013    0 0
  v 30.2688 -34.7135 80.9108    -0.234874 -0.140966 -0.96175    0 0
  v 26.965 -36.6317 80.8266    0.423273 -0.0980643 -0.900679    0 0
  v 27.1143 -33.6265 80.1647    0.561207 -0.396409 -0.726572    0 0
  v 29.9727 -31.9763 80.2412    -0.062314 -0.478294 -0.875986    0 0
  v 14.5167 -43.1865 67.7907    0.190191 -0.960865 -0.20141    0 0
  v 5.99324 -44.2828 68.1195    0.0600495 -0.982894 -0.174111    0 0
  v 5.45473 -43.4043 64.5126    0.0481338 -0.948424 -0.313329    0 0
  v 11.9999 -42.8371 64.6481    0.155955 -0.933692 -0.322332    0 0
  v 3.02379 -24.8088 108.59    0.0175588 -0.431005 0.902179    0 0
  v 6.01859 -24.1263 108.634    0.145564 -0.381187 0.912966    0 0
  v 3.02379 -20.7968 110.055    0.0442272 -0.255945 0.965679    0 0
  v 3.80229 -18.5213 110.477    0.0708167 -0.180528 0.981017    0 0
  v 8.61064 -22.391 108.811    0.179522 -0.325379 0.928386    0 0
  v 11.0915 -20.6489 108.858    0.21577 -0.272033 0.937785    0 0
  v 4.61214 -17.174 110.61    0.088366 -0.109439 0.990058    0 0
  v 5.301 -16.0639 110.637    0.0933036 -0.0642195 0.993564    0 0
  v 13.1946 -18.6847 108.827    0.257213 -0.202447 0.944911    0 0
  v 14.5744 -16.4797 108.854    0.273494 -0.143934 0.951044    0 0
  v 5.78053 -14.8597 110.651    0.092338 -0.0371192 0.995036    0 0
  v 6.02639 -13.5901 110.656    0.0922636 -0.00954037 0.995689    0 0
  v 15.285 -14.1862 108.857    0.291359 -0.0298848 0.956147    0 0
  v 15.313 -11.8334 108.835    0.294188 0.0352779 0.955096    0 0
  v 6.02639 -12.2948 110.656    0.0926337 0.0101979 0.995648    0 0
  v 5.78053 -11.0251 110.651    0.0923835 0.0344901 0.995126    0 0
  v 14.5289 -9.46119 108.877    0.278689 0.122132 0.952584    0 0
  v 13.1029 -7.21505 108.883    0.250565 0.203712 0.946424    0 0
  v 5.301 -9.82097 110.637    0.0920706 0.0644504 0.993665    0 0
  v 4.61214 -8.71083 110.61    0.0878508 0.109772 0.990067    0 0
  v 11.0732 -5.2389 108.87    0.211982 0.274469 0.937939    0 0
  v 8.61063 -3.49389 108.811    0.179089 0.325657 0.928372    0 0
  v 3.80229 -7.3635 110.477    0.0707665 0.180568 0.981013    0 0
  v 3.02379 -5.08805 110.055    0.0442268 0.255945 0.965679    0 0
  v 6.01859 -1.7585 108.634    0.145564 0.381186 0.912967    0 0
  v 3.02379 -1.076 108.59    0.0175589 0.431005 0.902179    0 0
  v 4.61214 -35.4381 99.9755    0.061674 -0.743822 0.665526    0 0
  v 11.0739 -34.3467 99.9755    0.185891 -0.714041 0.674974    0 0
  v 8.61064 -29.2778 105.155    0.170194 -0.588946 0.790048    0 0
  v 3.80229 -30.1277 105.146    0.0454461 -0.626953 0.777731    0 0
  v 5.80405 -42.9982 87.8801    0.0740176 -0.935639 0.34511    0 0
  v 14.7074 -41.6419 87.8763    0.20378 -0.900744 0.383581    0 0
  v 13.1063 -38.5802 94.1098    0.207215 -0.808382 0.550981    0 0
  v 5.301 -39.8951 94.1098    0.0697488 -0.83994 0.538179    0 0
  v 6.25705 -44.8484 73.8088    0.0693598 -0.996937 -0.0361393    0 0
  v 15.6486 -43.6117 73.5345    0.180471 -0.982243 -0.0512735    0 0
  v 15.2969 -43.4012 80.9069    0.174412 -0.974908 0.138329    0 0
  v 6.14396 -44.5903 80.9152    0.0722345 -0.989963 0.121474    0 0
  v 3.4978 -29.888 49.4185    0.054982 -0.55775 -0.828186    0 0
  v 7.78603 -29.0812 49.4185    0.156373 -0.507316 -0.847454    0 0
  v 11.4308 -33.9889 53.5379    0.174741 -0.620796 -0.76425    0 0
  v 4.86685 -35.2584 53.5189    0.0780824 -0.639122 -0.765131    0 0
  v 3.02363 1.94082 46.1521    0.163449 0.924352 0.344756    0 0
  v 6.38098 1.14874 46.1521    0.288253 0.855423 0.430304    0 0
  v 7.11476 2.20829 43.2306    0.284744 0.896203 0.340208    0 0
  v 3.27617 3.0027 43.2306    0.0979678 0.94274 0.318815    0 0
  v 3.47725 3.93648 39.7645    0.0986386 0.973796 0.20492    0 0
  v 7.69878 3.07362 39.7645    0.291942 0.931997 0.214828    0 0
  v 8.05219 3.61714 35.7223    0.296204 0.950761 0.0911912    0 0
  v 3.59901 4.52289 35.7223    0.100064 0.991147 0.0872666    0 0
  v 3.61999 4.62652 31.4043    0.100341 0.994273 -0.0367802    0 0
  v 8.11308 3.71321 31.4043    0.297023 0.954098 -0.0383876    0 0
  v 7.88311 3.35041 27.0865    0.294628 0.943991 -0.148574    0 0
  v 3.54073 4.23515 27.0865    0.0995043 0.984788 -0.142446    0 0
  v 3.38371 3.45978 23.0204    0.0977251 0.964559 -0.245104    0 0
  v 7.4275 2.63164 23.0204    0.289556 0.922491 -0.255281    0 0
  v 6.74744 1.55877 19.4729    0.273965 0.864122 -0.422181    0 0
  v 3.14932 2.30242 19.4729    0.0925098 0.908685 -0.407103    0 0
  v 2.8159 0.656057 16.7254    0.0784531 0.765845 -0.638221    0 0
  v 5.78003 0.0325906 16.7254    0.232631 0.71815 -0.655853    0 0
  v 4.5904 -1.81232 14.8288    0.191499 0.54345 -0.817306    0 0
  v 2.4197 -1.32374 14.8356    0.0588498 0.597126 -0.799985    0 0
  v 2.0549 -3.21886 13.6374    0.0399701 0.455876 -0.889145    0 0
  v 3.37166 -3.60763 13.6031    0.162807 0.396814 -0.903345    0 0
  v 2.04932 -4.66976 13.0256    0.0624045 0.313517 -0.94753    0 0
  v -10.476 -27.5025 105.191    -0.254102 -0.524022 0.812916    0 0
  v -14.4804 -25.0525 105.229    -0.3304 -0.446441 0.83158    0 0
  v -19.8565 -29.0292 99.9945    -0.413599 -0.561014 0.717076    0 0
  v -14.5259 -32.1723 99.9755    -0.303961 -0.653325 0.693379    0 0
  v -17.7744 -21.962 105.244    -0.39607 -0.348241 0.849622    0 0
  v -19.7355 -18.3764 105.455    -0.40707 -0.223583 0.88561    0 0
  v -27.1422 -19.1196 102.657    -0.115316 -0.226757 0.9671    0 0
  v -29.0736 -22.2287 100.039    -0.140402 -0.7845 0.604026    0 0
  v -24.1211 -25.1312 99.9145    -0.471659 -0.489362 0.733527    0 0
  v -20.9777 -14.8471 105.403    -0.444289 -0.0411788 0.894937    0 0
  v -21.3469 -11.6909 105.223    -0.480513 0.08298 0.873053    0 0
  v -28.9678 -12.2337 99.9976    -0.629252 0.111565 0.769152    0 0
  v -30.1235 -13.4874 99.459    -0.563644 0.465567 0.682314    0 0
  v -27.4898 -16.0523 102.577    -0.288995 0.237999 0.927274    0 0
  v -20.2898 -8.3862 105.255    -0.467127 0.205597 0.859955    0 0
  v -17.9942 -4.41525 105.201    -0.423883 0.325814 0.845085    0 0
  v -24.7947 -2.28049 99.9665    -0.548575 0.394646 0.737103    0 0
  v -28.2053 -8.69037 100.011    -0.608006 0.224678 0.761477    0 0
  v -14.5648 -0.93219 105.202    -0.344848 0.436791 0.830839    0 0
  v -10.476 1.61767 105.191    -0.256388 0.52269 0.813056    0 0
  v -14.5259 6.28743 99.9755    -0.308805 0.650557 0.693841    0 0
  v -20.0365 2.83769 99.9737    -0.441407 0.540401 0.716329    0 0
  v -5.97167 3.39294 105.155    -0.170194 0.588946 0.790048    0 0
  v -1.16332 4.24284 105.146    -0.0454462 0.626952 0.777731    0 0
  v -1.97317 9.5532 99.9755    -0.0616742 0.743822 0.665526    0 0
  v -8.4349 8.46182 99.9755    -0.185891 0.714041 0.674975    0 0
  v -17.7996 -35.9701 94.1098    -0.342843 -0.743138 0.574634    0 0
  v -24.2333 -32.2479 94.079    -0.47352 -0.645638 0.599108    0 0
  v -27.5088 -34.5564 88.2497    -0.52065 -0.694426 0.496686    0 0
  v -20.266 -38.7372 88.2788    -0.358948 -0.809921 0.46388    0 0
  v -29.1966 -27.6036 94.1157    -0.564709 -0.560585 0.60568    0 0
  v -32.5329 -23.5393 96.3495    -0.343852 -0.85828 0.380948    0 0
  v -36.2196 -21.3713 93.5074    -0.854285 -0.515394 0.0675728    0 0
  v -37.4841 -22.9281 87.5633    -0.812653 -0.40053 0.423286    0 0
  v -33.3617 -29.2469 87.8368    -0.685849 -0.551018 0.475383    0 0
  v -34.9525 -13.385 94.8777    -0.667036 0.440377 0.600942    0 0
  v -35.284 -11.8838 93.9872    -0.739489 0.113823 0.663476    0 0
  v -39.6099 -10.317 87.8796    -0.864255 0.123681 0.487613    0 0
  v -39.5646 -16.2465 87.6521    -0.8883 -0.128554 0.440905    0 0
  v -37.5002 -16.8161 92.9623    -0.982315 0.0358736 0.183767    0 0
  v -34.311 -7.51479 94.0175    -0.702801 0.2647 0.660307    0 0
  v -30.0816 -0.010098 94.1008    -0.619291 0.455093 0.639819    0 0
  v -33.5914 2.45568 87.876    -0.686082 0.552571 0.47324    0 0
  v -37.8798 -4.33103 87.8043    -0.791865 0.355926 0.496253    0 0
  v -24.4031 5.98601 94.108    -0.501163 0.621916 0.601711    0 0
  v -17.7996 10.0853 94.1098    -0.351507 0.744975 0.566969    0 0
  v -20.1903 12.7301 87.8797    -0.389974 0.839425 0.378531    0 0
  v -27.5216 8.35468 87.8792    -0.548838 0.721983 0.421327    0 0
  v -10.4674 12.6954 94.1098    -0.209273 0.810183 0.547548    0 0
  v -2.66203 14.0103 94.1098    -0.0699708 0.839914 0.538189    0 0
  v -3.16508 17.1236 87.8765    -0.0777525 0.934938 0.346188    0 0
  v -11.9516 15.6478 87.8783    -0.232682 0.904923 0.356333    0 0
  v -36.3859 -29.867 80.8885    -0.786602 -0.562257 0.255194    0 0
  v -40.2507 -23.5194 80.8275    -0.869646 -0.416716 0.264697    0 0
  v -41.3383 -23.4771 73.3573    -0.898607 -0.437443 -0.0339142    0 0
  v -37.444 -29.8206 73.3934    -0.809727 -0.584105 -0.056248    0 0
  v -42.5193 -16.5027 80.8159    -0.947375 -0.148747 0.283468    0 0
  v -42.5032 -9.41324 80.8644    -0.947129 0.148792 0.284267    0 0
  v -43.6314 -9.37041 73.3573    -0.987046 0.159034 -0.0211726    0 0
  v -43.6314 -16.5144 73.3573    -0.987074 -0.158786 -0.0217156    0 0
  v -40.2919 -2.57699 80.9038    -0.864437 0.422916 0.271828    0 0
  v -35.9301 3.89759 80.9143    -0.733386 0.635874 0.240437    0 0
  v -36.8655 4.02877 73.3573    -0.741737 0.668806 -0.0502478    0 0
  v -41.3383 -2.40776 73.3573    -0.892444 0.450045 -0.0316784    0 0
  v -29.6222 9.60463 80.915    -0.573819 0.79648 0.19066    0 0
  v -21.8057 14.0898 80.9134    -0.408841 0.90012 0.150439    0 0
  v -22.43 14.0691 73.3538    -0.403654 0.910378 -0.0909654    0 0
  v -30.4403 9.61239 73.3573    -0.569491 0.8188 -0.0724374    0 0
  v -12.9545 17.18 80.9064    -0.244663 0.961241 0.127105    0 0
  v -3.50499 18.7569 80.8976    -0.0821008 0.989719 0.117117    0 0
  v -3.63634 18.78 73.3222    -0.0818641 0.990823 -0.107557    0 0
  v -13.3421 17.1778 73.3397    -0.242207 0.964777 -0.102671    0 0
  v -21.9099 -38.6461 65.3318    -0.379267 -0.810111 -0.447076    0 0
  v -29.4416 -34.4241 65.4912    -0.517794 -0.717777 -0.465495    0 0
  v -25.7237 -31.9618 59.0738    -0.443556 -0.636798 -0.630672    0 0
  v -19.1714 -35.6439 58.9866    -0.341548 -0.715853 -0.609016    0 0
  v -35.5739 -29.1269 65.8921    -0.694338 -0.581993 -0.423294    0 0
  v -39.7299 -22.9078 65.8621    -0.815441 -0.411637 -0.406954    0 0
  v -35.0423 -21.8258 59.0738    -0.638106 -0.326048 -0.697505    0 0
  v -31.2178 -27.2534 59.0738    -0.552589 -0.502697 -0.664786    0 0
  v -41.9382 -16.3214 65.8621    -0.89625 -0.146725 -0.418578    0 0
  v -41.9382 -9.56345 65.8621    -0.89625 0.146724 -0.418579    0 0
  v -37.0031 -9.93032 59.0738    -0.685881 0.111975 -0.719047    0 0
  v -37.0031 -15.9545 59.0738    -0.685881 -0.111975 -0.719047    0 0
  v -39.7299 -2.97707 65.8621    -0.813599 0.417423 -0.404741    0 0
  v -35.4228 3.11162 65.8621    -0.680067 0.624327 -0.38435    0 0
  v -31.2178 1.36858 59.0738    -0.553621 0.506541 -0.660999    0 0
  v -35.0423 -4.05904 59.0738    -0.638148 0.326425 -0.69729    0 0
  v -29.2354 8.39349 65.8621    -0.525446 0.768928 -0.364219    0 0
  v -21.5234 12.6096 65.8586    -0.374724 0.858778 -0.349402    0 0
  v -18.8813 9.83038 59.072    -0.325694 0.744607 -0.582653    0 0
  v -25.7237 6.07698 59.0738    -0.444106 0.64753 -0.619253    0 0
  v -12.7793 15.5514 65.8446    -0.225958 0.912601 -0.340737    0 0
  v -3.44559 17.0684 65.827    -0.0760707 0.937669 -0.339102    0 0
  v -2.88964 13.5428 58.7167    -0.042249 0.813646 -0.579824    0 0
  v -11.1389 12.4328 59.065    -0.199691 0.806422 -0.556604    0 0
  v -14.6915 -31.8983 53.6077    -0.265007 -0.560814 -0.784384    0 0
  v -20.0778 -28.7903 53.6251    -0.338182 -0.469875 -0.815384    0 0
  v -12.8959 -25.0685 49.4185    -0.279753 -0.326165 -0.90297    0 0
  v -9.23006 -27.4536 49.4185    -0.232424 -0.422487 -0.876061    0 0
  v -24.4573 -24.867 53.6251    -0.396976 -0.347796 -0.849381    0 0
  v -27.5059 -20.3445 53.6251    -0.435271 -0.213266 -0.874675    0 0
  v -17.9193 -18.6061 49.4185    -0.322924 -0.132409 -0.937117    0 0
  v -15.8576 -22.0666 49.4185    -0.308533 -0.226181 -0.923931    0 0
  v -29.0689 -15.4523 53.6251    -0.454244 -0.0710458 -0.88804    0 0
  v -29.069 -10.4326 53.6251    -0.454244 0.0710457 -0.88804    0 0
  v -18.9764 -11.022 49.4185    -0.328847 0.0430451 -0.943402    0 0
  v -18.9764 -14.8628 49.4185    -0.328847 -0.043045 -0.943402    0 0
  v -27.5059 -5.54036 53.6251    -0.435271 0.213266 -0.874675    0 0
  v -24.4573 -1.0178 53.6251    -0.396976 0.347796 -0.849381    0 0
  v -15.8576 -3.81825 49.4185    -0.308533 0.226181 -0.923931    0 0
  v -17.9193 -7.27871 49.4185    -0.322924 0.132409 -0.937117    0 0
  v -20.0778 2.90546 53.6251    -0.337623 0.471132 -0.81489    0 0
  v -14.6335 6.02776 53.6248    -0.260868 0.571157 -0.778285    0 0
  v -9.23006 1.56877 49.4185    -0.232424 0.422488 -0.876061    0 0
  v -12.8959 -0.816351 49.4185    -0.279753 0.326165 -0.90297    0 0
  v -8.5017 8.1754 53.6234    -0.170857 0.64179 -0.747605    0 0
  v -1.99581 9.15618 53.2821    -0.105072 0.676994 -0.72845    0 0
  v -0.858833 4.20305 49.4185    -0.110298 0.551221 -0.827037    0 0
  v -5.14706 3.19637 49.4185    -0.162047 0.504195 -0.84825    0 0
  v -54.689 -24.5696 125.927    -0.129905 -0.150338 0.980063    0 0
  v -55.9869 -23.7707 125.601    -0.397595 0.105586 0.911466    0 0
  v -56.8087 -24.8442 125.038    -0.582286 -0.25755 0.77111    0 0
  v -55.4402 -25.6364 125.385    -0.285584 -0.482816 0.827847    0 0
  v -34.8864 -20.1206 104.489    0.536026 -0.185423 0.823587    0 0
  v -41.7189 -21.8198 110.699    0.762186 -0.255433 0.594833    0 0
  v -42.2461 -22.6318 110.381    0.477926 -0.854902 0.201813    0 0
  v -35.6757 -21.44 103.681    0.314507 -0.890679 0.328292    0 0
  v -37.2779 -21.874 102.146    -0.0900475 -0.995016 -0.0428378    0 0
  v -43.1502 -22.7682 109.788    -0.0825362 -0.959323 -0.269978    0 0
  v -43.989 -22.1627 109.203    -0.55494 -0.626273 -0.547562    0 0
  v -38.6737 -20.9134 100.974    -0.697893 -0.595635 -0.397698    0 0
  v -38.6139 -18.7011 99.6981    -0.924713 0.225643 -0.306578    0 0
  v -43.8222 -21.0916 108.636    -0.810041 0.309664 -0.497937    0 0
  v -42.5991 -20.0061 108.268    -0.498446 0.859699 -0.111668    0 0
  v -36.2514 -16.3222 98.645    -0.503535 0.844166 0.183948    0 0
  v -33.8996 -16.2286 100.838    -0.191212 0.878424 0.43796    0 0
  v -41.6561 -19.8623 108.919    0.0774442 0.930418 0.358224    0 0
  v -41.5132 -20.7414 110.191    0.54928 0.541429 0.636511    0 0
  v -34.2543 -18.2246 103.701    0.274089 0.521613 0.807958    0 0
  v -45.5769 -23.217 115.928    0.871003 -0.268942 0.411125    0 0
  v -46.3534 -23.8609 118.232    0.988292 -0.14835 -0.0356611    0 0
  v -47.2434 -25.2325 117.553    0.642027 -0.684035 -0.346263    0 0
  v -46.1622 -24.1226 115.493    0.547967 -0.835969 0.0298127    0 0
  v -47.3298 -24.2804 114.96    -0.048436 -0.900063 -0.43306    0 0
  v -49.0731 -25.4678 116.787    0.0723136 -0.706956 -0.703551    0 0
  v -50.9278 -24.449 116.316    -0.251829 -0.359539 -0.898507    0 0
  v -48.4979 -23.6119 114.593    -0.468395 -0.556834 -0.685961    0 0
  v -48.7163 -22.5281 114.581    -0.686205 0.34895 -0.638245    0 0
  v -51.4015 -22.8393 116.501    -0.368866 0.374072 -0.850887    0 0
  v -50.2573 -21.4434 117.25    -0.16997 0.801346 -0.573546    0 0
  v -47.849 -21.5541 114.91    -0.411569 0.873513 -0.259971    0 0
  v -46.6736 -21.3948 115.455    0.193904 0.951587 0.238504    0 0
  v -48.4276 -21.2081 118.017    0.31974 0.929053 -0.186082    0 0
  v -46.8271 -22.2511 118.417    0.782337 0.622103 0.0306065    0 0
  v -45.7875 -22.1317 115.928    0.67658 0.550923 0.488592    0 0
  v -46.2121 -24.2276 119.514    0.988487 -0.140216 -0.0568562    0 0
  v -46.3771 -24.5662 120.831    0.948896 -0.217877 0.228311    0 0
  v -47.88 -26.8729 119.7    0.589927 -0.797469 -0.12661    0 0
  v -47.4472 -26.1257 118.581    0.641312 -0.678173 -0.358886    0 0
  v -49.9863 -26.4467 117.518    0.0771439 -0.695952 -0.713933    0 0
  v -50.9695 -27.2604 118.408    -0.00295882 -0.824709 -0.56555    0 0
  v -54.1008 -25.5349 117.601    -0.360493 -0.450542 -0.816736    0 0
  v -52.5598 -25.03 116.858    -0.233723 -0.344342 -0.909287    0 0
  v -53.2226 -22.7984 117.113    -0.331153 0.372988 -0.866728    0 0
  v -54.9104 -22.8207 117.91    -0.482752 0.385531 -0.786331    0 0
  v -52.9934 -20.4747 119.178    -0.240041 0.84566 -0.476697    0 0
  v -51.6433 -20.8675 118.155    -0.134239 0.781213 -0.609661    0 0
  v -49.1042 -20.5465 119.217    0.330946 0.912385 -0.240892    0 0
  v -49.9039 -20.0872 120.47    0.275565 0.960574 -0.0368895    0 0
  v -47.1866 -21.8519 121.14    0.74394 0.620671 0.247631    0 0
  v -46.8749 -21.9959 119.769    0.780613 0.624887 -0.0126652    0 0
  v -47.1327 -24.8989 122.392    0.825103 -0.276226 0.492854    0 0
  v -48.587 -25.1707 124.043    0.633866 -0.309992 0.708604    0 0
  v -50.2384 -27.7039 122.801    0.353156 -0.859099 0.370446    0 0
  v -48.7966 -27.4513 121.141    0.492849 -0.861479 0.12229    0 0
  v -52.2171 -27.8788 119.711    -0.0922452 -0.923833 -0.371514    0 0
  v -53.633 -28.1283 121.382    -0.190479 -0.974581 -0.117943    0 0
  v -57.0735 -26.2317 120.495    -0.637724 -0.650109 -0.413119    0 0
  v -55.6839 -25.9677 118.817    -0.497578 -0.556293 -0.665548    0 0
  v -56.5817 -22.9632 119.158    -0.656091 0.384559 -0.649353    0 0
  v -57.9644 -23.2499 120.833    -0.847259 0.35117 -0.398537    0 0
  v -55.8602 -20.6738 122.227    -0.486537 0.872807 -0.0385989    0 0
  v -54.4616 -20.3676 120.563    -0.357534 0.885512 -0.296712    0 0
  v -51.0411 -19.9401 121.993    0.198528 0.961364 0.190699    0 0
  v -52.4656 -20.2494 123.646    0.0940341 0.892376 0.441388    0 0
  v -49.4779 -22.1889 124.381    0.503137 0.474644 0.722196    0 0
  v -48.0305 -21.8945 122.733    0.65139 0.571319 0.499286    0 0
  v -50.6721 -25.2489 125.266    0.338716 -0.317304 0.885771    0 0
  v -52.9081 -25.0983 125.829    0.0877676 -0.28935 0.953191    0 0
  v -53.8139 -26.4757 125.148    -0.0575509 -0.604693 0.794377    0 0
  v -52.033 -27.3389 124.24    0.135732 -0.754293 0.642354    0 0
  v -54.8304 -27.6911 123.07    -0.306933 -0.911928 0.272359    0 0
  v -55.5331 -26.6959 124.428    -0.35726 -0.726536 0.586951    0 0
  v -57.3849 -25.6702 123.954    -0.670043 -0.54348 0.505641    0 0
  v -57.6658 -26.1295 122.341    -0.733723 -0.674855 0.0788793    0 0
  v -58.3975 -23.6712 122.621    -0.967813 0.209584 0.13933    0 0
  v -57.8309 -24.158 124.128    -0.815067 0.010592 0.57927    0 0
  v -56.6958 -22.7588 124.879    -0.581431 0.376235 0.721377    0 0
  v -56.6596 -21.5455 123.769    -0.607834 0.687673 0.397043    0 0
  v -53.8622 -21.1933 124.939    -0.0700878 0.665281 0.743296    0 0
  v -54.9765 -22.5387 125.599    -0.213325 0.375442 0.901962    0 0
  v -53.3541 -23.5862 126.003    0.0315723 0.1088 0.993562    0 0
  v -51.4038 -22.7907 125.546    0.25423 0.294148 0.921327    0 0
  v -6.94653 -0.285746 46.1521    -0.444701 0.763268 0.468683    0 0
  v -8.09 0.62724 43.2306    -0.457305 0.80877 0.369816    0 0
  v -11.2928 -1.61542 43.2312    -0.593976 0.695134 0.404946    0 0
  v -9.83065 -2.36685 46.1524    -0.573415 0.636808 0.515433    0 0
  v -12.1612 -4.92605 46.1533    -0.670912 0.473423 0.570743    0 0
  v -13.8598 -4.27743 43.2335    -0.707592 0.547845 0.446296    0 0
  v -15.6231 -7.2163 43.2584    -0.799763 0.350922 0.487065    0 0
  v -13.7688 -7.85111 46.173    -0.737563 0.290361 0.609665    0 0
  v -14.5482 -11.0861 46.2472    -0.781057 0.0973098 0.616831    0 0
  v -16.4713 -10.3894 43.3463    -0.845419 0.158294 0.510107    0 0
  v -17.0968 -12.8277 43.2929    -0.746192 0.365159 0.556648    0 0
  v -15.7163 -14.9364 45.2236    -0.50904 0.094465 0.855543    0 0
  v -14.3331 -14.5202 46.528    -0.791303 -0.0975026 0.6036    0 0
  v -13.4737 -17.934 46.5272    -0.752582 -0.291295 0.590565    0 0
  v -14.9211 -18.0417 45.232    -0.416683 -0.335023 0.845065    0 0
  v -15.1955 -20.2283 43.3137    -0.490767 -0.7156 0.497057    0 0
  v -13.5492 -21.8977 43.3408    -0.677606 -0.576189 0.457008    0 0
  v -12.0611 -20.9719 46.2451    -0.675197 -0.473599 0.56552    0 0
  v -9.81063 -23.5206 46.1707    -0.573619 -0.636849 0.515155    0 0
  v -11.2307 -24.3275 43.2526    -0.587482 -0.697587 0.410167    0 0
  v -8.09 -26.5121 43.2306    -0.456055 -0.809336 0.370119    0 0
  v -6.94653 -25.5991 46.1521    -0.444654 -0.763274 0.468717    0 0
  v -3.74201 -27.0336 46.1521    -0.28029 -0.857096 0.432233    0 0
  v -4.47579 -28.0931 43.2306    -0.28442 -0.896191 0.340511    0 0
  v -0.637205 -28.8875 43.2306    -0.0962095 -0.941139 0.32404    0 0
  v -0.384665 -27.744 46.1521    -0.0948036 -0.906581 0.411245    0 0
  v -8.99931 1.37297 39.7645    -0.474758 0.848828 0.232583    0 0
  v -9.54883 1.84146 35.7223    -0.4851 0.868936 0.0981218    0 0
  v -13.1482 -0.671061 35.7226    -0.649455 0.753564 0.101732    0 0
  v -12.4517 -1.02242 39.7651    -0.62652 0.738351 0.249622    0 0
  v -15.195 -3.85154 39.7674    -0.762138 0.592213 0.26159    0 0
  v -15.986 -3.69001 35.7238    -0.798095 0.594577 0.0975821    0 0
  v -17.9254 -7.0865 35.718    -0.920186 0.379349 0.0967039    0 0
  v -17.0824 -6.96677 39.768    -0.88192 0.386744 0.26953    0 0
  v -18.0427 -10.3338 39.7585    -0.945494 0.172758 0.276037    0 0
  v -18.9184 -10.8332 35.689    -0.985438 0.135833 0.102279    0 0
  v -19.0011 -14.81 35.3157    -0.992094 -0.104549 0.0694122    0 0
  v -18.9037 -15.2177 37.9489    -0.984994 -0.000530315 -0.17259    0 0
  v -18.4638 -12.8992 40.1786    -0.925629 0.340743 0.164638    0 0
  v -18.0564 -18.4936 37.9573    -0.860403 -0.475607 -0.183043    0 0
  v -17.9958 -18.7082 35.3148    -0.919256 -0.388752 0.0619742    0 0
  v -15.9708 -22.1945 35.6864    -0.797011 -0.596516 0.0945653    0 0
  v -14.9724 -22.3102 39.7529    -0.741031 -0.625824 0.243345    0 0
  v -16.5104 -20.4703 40.1994    -0.64392 -0.75665 0.11335    0 0
  v -12.4072 -24.9178 39.7622    -0.623024 -0.743506 0.242979    0 0
  v -13.1452 -25.2137 35.7151    -0.650206 -0.752959 0.10142    0 0
  v -9.54883 -27.7263 35.7223    -0.48514 -0.868921 0.0980573    0 0
  v -8.99931 -27.2578 39.7645    -0.473771 -0.84956 0.231924    0 0
  v -5.05982 -28.9585 39.7645    -0.291942 -0.931997 0.214827    0 0
  v -5.41323 -29.502 35.7223    -0.296204 -0.950761 0.0911914    0 0
  v -0.960041 -30.4077 35.7223    -0.100064 -0.991147 0.0872666    0 0
  v -0.838288 -29.8213 39.7645    -0.0986384 -0.973796 0.204919    0 0
  v -9.64342 1.92427 31.4043    -0.487562 0.872102 -0.0414947    0 0
  v -9.28617 1.61152 27.0865    -0.482612 0.861115 -0.159893    0 0
  v -12.8118 -0.875135 27.0865    -0.650088 0.739753 -0.173641    0 0
  v -13.2663 -0.622171 31.4044    -0.657396 0.752073 -0.0470796    0 0
  v -16.1135 -3.72754 31.4046    -0.809463 0.58447 -0.0562603    0 0
  v -15.5893 -3.92738 27.0865    -0.798937 0.571099 -0.188537    0 0
  v -17.4795 -7.3751 27.0865    -0.910173 0.362389 -0.200647    0 0
  v -18.0489 -7.22601 31.4035    -0.926177 0.371828 -0.062769    0 0
  v -19.0296 -10.9845 31.3977    -0.989734 0.128458 -0.0626506    0 0
  v -18.4362 -11.0602 27.0865    -0.970418 0.123951 -0.207183    0 0
  v -18.4362 -14.8246 27.0865    -0.970275 -0.123163 -0.208318    0 0
  v -19.0461 -14.852 31.323    -0.990535 -0.118581 -0.0691258    0 0
  v -18.063 -18.6408 31.3228    -0.924151 -0.375926 -0.068006    0 0
  v -17.4795 -18.5098 27.0865    -0.909823 -0.36269 -0.201689    0 0
  v -15.5893 -21.9575 27.0865    -0.798911 -0.57114 -0.188523    0 0
  v -16.1105 -22.1572 31.3972    -0.809467 -0.584541 -0.0554496    0 0
  v -13.2657 -25.2627 31.4029    -0.657577 -0.751929 -0.0468557    0 0
  v -12.8118 -25.0097 27.0865    -0.650094 -0.73975 -0.173628    0 0
  v -9.28617 -27.4964 27.0865    -0.482613 -0.861115 -0.159892    0 0
  v -9.64342 -27.8091 31.4043    -0.487579 -0.872093 -0.0414856    0 0
  v -5.47412 -29.5981 31.4043    -0.297023 -0.954098 -0.0383876    0 0
  v -5.24415 -29.2353 27.0865    -0.294629 -0.943991 -0.148574    0 0
  v -0.901767 -30.12 27.0865    -0.0995041 -0.984788 -0.142446    0 0
  v -0.981027 -30.5114 31.4043    -0.100341 -0.994273 -0.0367802    0 0
  v -8.5784 0.991911 23.0204    -0.471732 0.838161 -0.27378    0 0
  v -7.52194 0.0670403 19.4729    -0.440731 0.777456 -0.448684    0 0
  v -10.5698 -2.10342 19.4729    -0.581928 0.657379 -0.478761    0 0
  v -11.9124 -1.36789 23.0204    -0.631643 0.716702 -0.295575    0 0
  v -14.5559 -4.28126 23.0204    -0.77199 0.550184 -0.318321    0 0
  v -13.0134 -4.8095 19.4729    -0.701914 0.498132 -0.509098    0 0
  v -14.6986 -7.9051 19.4725    -0.786788 0.311263 -0.532991    0 0
  v -16.3642 -7.58731 23.0204    -0.875083 0.34765 -0.336704    0 0
  v -17.282 -11.1308 23.0204    -0.930351 0.118467 -0.347005    0 0
  v -15.5559 -11.2411 19.4711    -0.831135 0.106735 -0.54573    0 0
  v -15.6036 -14.6591 19.4971    -0.839822 -0.0951547 -0.534457    0 0
  v -17.282 -14.7541 23.0204    -0.931113 -0.117697 -0.34522    0 0
  v -16.3642 -18.2975 23.0204    -0.875414 -0.348597 -0.334859    0 0
  v -14.7449 -17.9843 19.4971    -0.789924 -0.324657 -0.520209    0 0
  v -13.0117 -21.0721 19.4711    -0.701115 -0.49935 -0.509006    0 0
  v -14.5559 -21.6036 23.0204    -0.77193 -0.550265 -0.318329    0 0
  v -11.9124 -24.517 23.0204    -0.63165 -0.716679 -0.295618    0 0
  v -10.5695 -23.7808 19.4725    -0.582043 -0.657033 -0.479097    0 0
  v -7.52194 -25.9519 19.4729    -0.440759 -0.777427 -0.448707    0 0
  v -8.5784 -26.8768 23.0204    -0.471734 -0.838159 -0.273782    0 0
  v -4.78854 -28.5165 23.0204    -0.289555 -0.922491 -0.255281    0 0
  v -4.10847 -27.4436 19.4729    -0.273965 -0.864122 -0.42218    0 0
  v -0.510351 -28.1873 19.4729    -0.0925097 -0.908685 -0.407103    0 0
  v -0.74474 -29.3446 23.0204    -0.0977249 -0.964559 -0.245104    0 0
  v -6.01911 -1.2486 16.7254    -0.362919 0.630937 -0.685717    0 0
  v -4.10455 -2.88952 14.8013    -0.276237 0.456611 -0.845695    0 0
  v -6.23133 -4.4685 14.796    -0.334409 0.374597 -0.864782    0 0
  v -8.66006 -3.14971 16.7254    -0.465001 0.5217 -0.715264    0 0
  v -10.8193 -5.56093 16.7254    -0.547729 0.386203 -0.742186    0 0
  v -8.07342 -6.50084 14.8055    -0.389228 0.274683 -0.879233    0 0
  v -9.37292 -8.87847 14.8058    -0.424974 0.171672 -0.888778    0 0
  v -12.3277 -8.35977 16.7236    -0.602722 0.236986 -0.761947    0 0
  v -13.092 -11.4111 16.7163    -0.633373 0.0879252 -0.768835    0 0
  v -10.0297 -11.3815 14.7973    -0.444638 0.0982475 -0.890306    0 0
  v -9.92675 -13.1697 14.3688    -0.490807 0.416764 -0.765125    0 0
  v -11.4978 -14.75 15.19    -0.765416 0.0477058 -0.641765    0 0
  v -13.3303 -14.5502 16.8465    -0.670821 -0.0530648 -0.739718    0 0
  v -12.5589 -17.548 16.8465    -0.629592 -0.281569 -0.724108    0 0
  v -10.9226 -16.9805 15.1942    -0.677578 -0.41569 -0.606704    0 0
  v -8.66602 -18.0665 14.3792    -0.329702 -0.633861 -0.699655    0 0
  v -7.94699 -19.5727 14.7949    -0.380047 -0.320519 -0.867659    0 0
  v -10.8104 -20.3077 16.7163    -0.547698 -0.39628 -0.736878    0 0
  v -8.65828 -22.7319 16.7236    -0.465423 -0.521697 -0.714992    0 0
  v -6.20605 -21.4541 14.7939    -0.333223 -0.382097 -0.861954    0 0
  v -4.10455 -22.9953 14.8013    -0.275688 -0.457582 -0.845349    0 0
  v -6.01911 -24.6363 16.7254    -0.362954 -0.63095 -0.685687    0 0
  v -3.14106 -25.9174 16.7254    -0.232631 -0.71815 -0.655853    0 0
  v -1.95144 -24.0725 14.8288    -0.191499 -0.543452 -0.817306    0 0
  v 0.219268 -24.5611 14.8356    -0.0588486 -0.597127 -0.799985    0 0
  v -0.176931 -26.5409 16.7254    -0.0784535 -0.765845 -0.638221    0 0
  v -1.94518 -4.63927 13.4657    -0.211582 0.318213 -0.924107    0 0
  v 0.247163 -5.76428 12.7592    -0.0896242 0.224226 -0.970407    0 0
  v 0.42581 -7.19003 12.4866    -0.0853836 0.136418 -0.986965    0 0
  v -1.31927 -7.57363 12.6423    -0.13531 0.140331 -0.980815    0 0
  v -3.50438 -5.91526 13.4393    -0.237217 0.267219 -0.933982    0 0
  v -5.11864 -7.511 13.4869    -0.276271 0.193096 -0.941482    0 0
  v -2.48838 -8.68853 12.6899    -0.171208 0.100351 -0.980111    0 0
  v -3.35695 -10.2771 12.7019    -0.179328 0.0758216 -0.980863    0 0
  v -6.22213 -9.4674 13.4969    -0.296674 0.121668 -0.947197    0 0
  v -6.76085 -11.5298 13.4895    -0.29996 0.0782794 -0.950734    0 0
  v -3.75234 -11.9454 12.696    -0.186482 0.0275736 -0.982071    0 0
  v -3.40821 -13.8314 12.6125    -0.156354 0.00691361 -0.987677    0 0
  v -5.30277 -14.1985 12.8067    0.032955 0.157518 -0.986966    0 0
  v -7.23351 -13.0437 13.3335    -0.189186 0.437255 -0.879214    0 0
  v -4.83716 -16.029 12.8109    0.0794083 -0.142891 -0.986548    0 0
  v -2.96772 -15.5969 12.6125    -0.134607 -0.0829188 -0.987424    0 0
  v -2.43026 -17.243 12.6823    -0.161165 -0.107266 -0.981081    0 0
  v -4.95423 -18.6118 13.4777    -0.253021 -0.230687 -0.939555    0 0
  v -6.08232 -17.5405 13.344    -0.045902 -0.536288 -0.842786    0 0
  v -3.4715 -20.0172 13.4374    -0.232408 -0.271299 -0.934015    0 0
  v -1.30625 -18.3217 12.6406    -0.13353 -0.141017 -0.980961    0 0
  v 0.42581 -18.6948 12.4866    -0.0852042 -0.136488 -0.986971    0 0
  v 0.247163 -20.1206 12.7592    -0.0895374 -0.224307 -0.970397    0 0
  v -1.94518 -21.2456 13.4657    -0.210821 -0.318952 -0.924026    0 0
  v -0.732697 -22.2772 13.6031    -0.162811 -0.396814 -0.903345    0 0
  v 0.589648 -21.2151 13.0255    -0.062405 -0.313511 -0.947532    0 0
  v 0.584069 -22.666 13.6374    -0.0399669 -0.455881 -0.889143    0 0
  v -30.7127 -18.7276 35.6846    -0.850067 -0.135457 -0.508958    0 0
  v -29.8855 -17.9969 35.0307    -0.445423 0.288814 -0.847458    0 0
  v -29.0869 -18.7656 34.8261    -0.0987641 -0.288869 -0.952261    0 0
  v -29.9269 -19.4932 35.4957    -0.357095 -0.686119 -0.633817    0 0
  v -16.8205 -17.863 44.8823    -0.0882275 -0.381193 0.920276    0 0
  v -19.2804 -17.8434 44.7966    -0.041871 -0.400817 0.915201    0 0
  v -19.2494 -19.3043 43.3367    -0.049601 -0.9008 0.431392    0 0
  v -16.989 -19.5742 43.2713    -0.176207 -0.86553 0.468838    0 0
  v -17.8711 -19.708 40.9026    -0.332731 -0.929579 -0.158658    0 0
  v -19.7383 -19.4013 41.1979    -0.077237 -0.952224 -0.295471    0 0
  v -20.5027 -18.0857 39.4495    -0.0526505 -0.542715 -0.838265    0 0
  v -18.9953 -18.1668 39.0627    -0.465932 -0.563034 -0.682569    0 0
  v -19.5994 -15.889 39.0162    -0.581315 0.292279 -0.759372    0 0
  v -20.9988 -16.2188 39.3415    -0.0977721 0.418167 -0.903093    0 0
  v -20.9784 -14.734 40.9278    -0.189926 0.903402 -0.384439    0 0
  v -19.3483 -14.1372 40.7864    -0.574488 0.791781 -0.207476    0 0
  v -18.4558 -14.0375 43.1551    -0.399915 0.772286 0.493602    0 0
  v -20.4895 -14.6371 43.0666    -0.202032 0.89662 0.394025    0 0
  v -19.7765 -15.9765 44.6885    -0.119702 0.452768 0.883557    0 0
  v -17.4141 -15.6193 44.8358    -0.181113 0.346959 0.920227    0 0
  v -21.8904 -17.9577 44.4992    -0.161166 -0.40646 0.899342    0 0
  v -24.3759 -18.1742 43.7187    -0.334754 -0.404748 0.850952    0 0
  v -23.8861 -19.4503 42.5069    -0.0840069 -0.911227 0.403247    0 0
  v -21.6261 -19.299 43.1492    -0.0395422 -0.909682 0.413419    0 0
  v -21.7232 -19.3846 41.0837    0.0925116 -0.945136 -0.313304    0 0
  v -23.5913 -19.5264 40.5567    0.21755 -0.934406 -0.282058    0 0
  v -23.639 -18.3643 38.8433    0.434168 -0.494911 -0.752702    0 0
  v -22.1332 -18.1716 39.3355    0.209082 -0.517371 -0.829827    0 0
  v -22.548 -16.434 39.1688    0.147088 0.439357 -0.886189    0 0
  v -23.9584 -16.6799 38.6246    0.354339 0.436919 -0.826768    0 0
  v -24.3898 -15.3154 40.0099    0.0459406 0.90965 -0.412826    0 0
  v -22.7602 -15.0406 40.6669    -0.0342035 0.912153 -0.40842    0 0
  v -22.663 -14.955 42.7323    -0.211442 0.911499 0.35279    0 0
  v -24.6846 -15.2394 41.96    -0.315241 0.898123 0.306591    0 0
  v -24.6953 -16.4898 43.5    -0.438493 0.444401 0.781173    0 0
  v -22.3051 -16.2201 44.3324    -0.247875 0.459983 0.852628    0 0
  v -26.5989 -18.4542 42.3884    -0.526037 -0.399919 0.750567    0 0
  v -28.4766 -18.7513 40.6091    -0.659253 -0.390893 0.64233    0 0
  v -27.651 -19.8636 39.8319    -0.239186 -0.912441 0.332026    0 0
  v -25.914 -19.6619 41.3672    -0.168764 -0.912006 0.373849    0 0
  v -25.2625 -19.729 39.6119    0.290238 -0.92977 -0.226471    0 0
  v -26.7103 -19.921 38.3637    0.299257 -0.936928 -0.180584    0 0
  v -26.1248 -18.8946 36.9385    0.660452 -0.526355 -0.535494    0 0
  v -24.9701 -18.622 38.0003    0.605299 -0.489505 -0.627693    0 0
  v -25.2067 -17.0202 37.7176    0.52083 0.425153 -0.740257    0 0
  v -26.291 -17.4348 36.5905    0.599291 0.409744 -0.687721    0 0
  v -27.1259 -16.2715 37.4938    0.102856 0.898526 -0.426698    0 0
  v -25.8541 -15.7244 38.9052    0.0737388 0.904371 -0.420328    0 0
  v -26.5056 -15.6573 40.6605    -0.442173 0.873489 0.203716    0 0
  v -28.0666 -16.2141 38.962    -0.473386 0.875499 0.0969891    0 0
  v -28.6428 -17.2915 40.2611    -0.731758 0.463373 0.499815    0 0
  v -26.8355 -16.8524 42.1057    -0.629952 0.438464 0.641023    0 0
  v -29.9817 -19.0112 38.6498    -0.761064 -0.378919 0.526499    0 0
  v -30.7997 -19.1202 36.9168    -0.913538 -0.369094 0.170934    0 0
  v -30.0198 -19.9232 36.6436    -0.428465 -0.902394 -0.0458496    0 0
  v -29.0944 -20.012 38.1475    -0.307329 -0.91346 0.266719    0 0
  v -27.9615 -20.057 37.0455    0.252471 -0.949281 -0.187415    0 0
  v -28.949 -19.9524 35.9654    0.041617 -0.920045 -0.389596    0 0
  v -28.1432 -19.1953 35.1605    0.312417 -0.593292 -0.74189    0 0
  v -27.1497 -19.1235 35.8949    0.605914 -0.588778 -0.534985    0 0
  v -27.2307 -17.8199 35.5201    0.592301 0.361073 -0.720282    0 0
  v -28.1421 -18.1579 34.8415    0.305136 0.139474 -0.94204    0 0
  v -28.9633 -17.345 35.1656    -0.0620151 0.709845 -0.701623    0 0
  v -28.164 -16.7978 36.1085    0.123729 0.880243 -0.458109    0 0
  v -29.2968 -16.7529 37.2104    -0.463622 0.886026 0.00359124    0 0
  v -30.0342 -17.3158 35.8437    -0.544551 0.782695 -0.301419    0 0
  v -30.7986 -18.0828 36.5977    -0.917377 0.395433 0.0452918    0 0
  v -30.0627 -17.7075 38.275    -0.787737 0.493784 0.368304    0 0
  v -11.007 -16.741 0.734975    -0.460737 -0.164539 -0.872151    0 0
  v -10.5927 -16.3247 0.622619    -0.178113 0.287741 -0.941    0 0
  v -10.0201 -16.6263 0.584057    0.185805 -0.00937282 -0.982542    0 0
  v -10.4121 -17.0413 0.66342    -0.0829831 -0.451103 -0.888606    0 0
  v -10.59 -16.5973 13.7929    -0.738816 -0.671971 -0.051044    0 0
  v -10.8903 -16.595 11.9705    -0.684033 -0.708184 0.174856    0 0
  v -9.32176 -17.3542 11.6377    -0.173168 -0.982128 0.0737458    0 0
  v -8.86385 -17.4407 13.2717    -0.211103 -0.962871 -0.168267    0 0
  v -7.01248 -17.1779 12.665    0.330258 -0.856639 -0.396357    0 0
  v -7.67529 -17.1632 11.2639    0.451027 -0.885941 -0.108087    0 0
  v -6.77407 -16.1175 11.036    0.906817 -0.288557 -0.307273    0 0
  v -6.03635 -16.0129 12.3172    0.674246 -0.258013 -0.691969    0 0
  v -6.39106 -14.6426 12.2962    0.524727 0.508334 -0.682831    0 0
  v -7.08871 -14.9007 10.9902    0.706539 0.625793 -0.330432    0 0
  v -8.46188 -14.1213 11.1495    0.183501 0.962303 -0.200751    0 0
  v -7.89671 -13.7681 12.6127    0.0766089 0.884513 -0.460182    0 0
  v -9.76998 -13.9509 13.2194    -0.482742 0.834309 -0.26625    0 0
  v -10.1083 -14.3123 11.5233    -0.443807 0.895723 -0.026728    0 0
  v -11.2049 -15.3782 11.9248    -0.916762 0.375846 0.135234    0 0
  v -10.9666 -15.147 13.772    -0.953081 0.28635 -0.0981843    0 0
  v -11.269 -16.743 9.79907    -0.690337 -0.71041 0.13694    0 0
  v -11.4847 -16.9092 7.45362    -0.695794 -0.711557 0.0977582    0 0
  v -10.02 -17.6079 7.24348    -0.177408 -0.981445 0.0727554    0 0
  v -9.74431 -17.4722 9.56051    -0.174767 -0.980984 0.084423    0 0
  v -8.1399 -17.2887 9.29102    0.464826 -0.884975 -0.0274745    0 0
  v -8.47709 -17.4321 7.00784    0.466096 -0.884701 -0.00766706    0 0
  v -7.62741 -16.4696 6.86456    0.950563 -0.287331 -0.117775    0 0
  v -7.25802 -16.2844 9.12536    0.943995 -0.287891 -0.161224    0 0
  v -7.55812 -15.1162 9.06412    0.738361 0.641557 -0.207913    0 0
  v -7.91426 -15.3505 6.8015    0.74427 0.645211 -0.172523    0 0
  v -9.19421 -14.6344 6.8502    0.203425 0.969354 -0.137733    0 0
  v -8.89015 -14.3683 9.13791    0.200761 0.968555 -0.146954    0 0
  v -10.4946 -14.5517 9.4074    -0.440634 0.896809 -0.0397023    0 0
  v -10.7371 -14.8102 7.08583    -0.442389 0.894524 -0.0641774    0 0
  v -11.7715 -15.7901 7.39056    -0.927859 0.372161 0.0239455    0 0
  v -11.5691 -15.5748 9.73783    -0.9229 0.377445 0.0760972    0 0
  v -11.6082 -17.0607 5.21213    -0.698677 -0.711635 0.0736614    0 0
  v -11.6517 -17.1583 3.30896    -0.704042 -0.709998 0.0150843    0 0
  v -10.3881 -17.7631 3.11866    -0.189043 -0.981968 0.00118652    0 0
  v -10.2214 -17.7231 5.00969    -0.180181 -0.98203 0.0561452    0 0
  v -8.75931 -17.5563 4.78638    0.46427 -0.885429 -0.0216632    0 0
  v -9.05397 -17.6106 2.91489    0.453809 -0.88591 -0.0960233    0 0
  v -8.31637 -16.7771 2.7995    0.929093 -0.29181 -0.227231    0 0
  v -7.95303 -16.6437 4.6539    0.948379 -0.288466 -0.131772    0 0
  v -8.22463 -15.5832 4.59411    0.742609 0.64351 -0.185546    0 0
  v -8.56383 -15.8093 2.74488    0.728806 0.629724 -0.268867    0 0
  v -9.67261 -15.1911 2.77835    0.19409 0.957079 -0.215242    0 0
  v -9.4383 -14.905 4.63691    0.201804 0.967593 -0.151784    0 0
  v -10.9004 -15.0719 4.8602    -0.445408 0.891402 -0.083753    0 0
  v -11.0067 -15.3436 2.98212    -0.453247 0.880643 -0.137969    0 0
  v -11.8991 -16.1905 3.25434    -0.932177 0.355857 -0.0664153    0 0
  v -11.8798 -16.0002 5.15235    -0.929974 0.367601 -0.00410986    0 0
  v -11.5684 -17.1563 1.93477    -0.706449 -0.691166 -0.152377    0 0
  v -11.3282 -17.0402 1.13358    -0.639489 -0.549958 -0.537215    0 0
  v -10.6008 -17.3941 1.0148    -0.232709 -0.810905 -0.536917    0 0
  v -10.5269 -17.6573 1.76642    -0.213529 -0.963629 -0.160702    0 0
  v -9.42341 -17.5305 1.59781    0.408867 -0.856715 -0.314432    0 0
  v -9.85489 -17.3078 0.900758    0.241002 -0.683016 -0.689498    0 0
  v -9.41483 -16.819 0.841098    0.530261 -0.208797 -0.821722    0 0
  v -8.80959 -16.8395 1.51323    0.824901 -0.283496 -0.489049    0 0
  v -9.01354 -16.0388 1.46793    0.658018 0.561738 -0.50146    0 0
  v -9.55185 -16.2775 0.81033    0.444742 0.34987 -0.824497    0 0
  v -10.2066 -15.919 0.821904    0.0686732 0.66326 -0.745232    0 0
  v -9.93329 -15.5288 1.48455    0.167718 0.90085 -0.400425    0 0
  v -11.0368 -15.6555 1.65316    -0.469292 0.832808 -0.293592    0 0
  v -10.9526 -16.0053 0.935942    -0.434793 0.620633 -0.652511    0 0
  v -11.4652 -16.4988 1.10282    -0.774584 0.154456 -0.613321    0 0
  v -11.7724 -16.3556 1.88946    -0.918654 0.31414 -0.239563    0 0
  v -18.8768 -42.2267 80.2288    -0.240427 -0.960426 0.140632    0 0
  v -21.3505 -41.581 79.3169    -0.416803 -0.905358 0.081251    0 0
  v -21.7393 -41.621 74.9172    -0.417421 -0.908632 0.0121529    0 0
  v -19.345 -42.3129 73.9762    -0.248159 -0.966105 -0.0711196    0 0
  v -23.8552 -40.0146 70.072    -0.387206 -0.869606 -0.306361    0 0
  v -25.1214 -39.9457 72.056    -0.453214 -0.890219 -0.045908    0 0
  v -29.8059 -37.3927 72.1639    -0.51057 -0.858531 -0.0473665    0 0
  v -30.4934 -36.3435 70.2014    -0.551511 -0.766327 -0.329513    0 0
  v -34.1932 -34.0331 74.159    -0.748534 -0.661659 -0.0436418    0 0
  v -32.5289 -35.6471 75.1411    -0.567008 -0.822476 0.0451166    0 0
  v -31.9289 -35.5817 79.4988    -0.560374 -0.818545 0.12635    0 0
  v -33.3299 -34.0167 80.3058    -0.723036 -0.648568 0.237861    0 0
  v -28.7809 -36.3069 84.1437    -0.539594 -0.733745 0.412864    0 0
  v -28.5467 -37.257 82.36    -0.515991 -0.839701 0.169279    0 0
  v -24.0735 -39.8354 82.294    -0.464218 -0.871772 0.156574    0 0
  v -22.5378 -39.9081 84.12    -0.375913 -0.848588 0.372273    0 0
  v -24.586 -31.8823 78.1788    -0.674465 -0.70932 -0.204846    0 0
  v -27.4848 -30.2427 78.2688    -0.176033 -0.931128 -0.319394    0 0
  v -27.7778 -30.306 75.4598    -0.128051 -0.908138 0.398607    0 0
  v -24.8432 -31.9362 75.3578    -0.634459 -0.68847 0.351383    0 0
  v -22.136 -41.0822 78.9498    -0.773867 -0.627484 -0.0859928    0 0
  v -22.3316 -40.1855 78.7481    -0.960328 -0.0639105 -0.271452    0 0
  v -22.5805 -40.2359 75.3322    -0.909889 -0.0275691 0.413934    0 0
  v -22.4236 -41.1339 75.2133    -0.76647 -0.596376 0.238452    0 0
  v -25.2521 -39.7354 72.8172    -0.515082 -0.693135 0.504236    0 0
  v -25.1479 -38.9676 73.1509    -0.331101 -0.0957792 0.938722    0 0
  v -28.7501 -37.0146 73.295    0.250223 -0.230741 0.940291    0 0
  v -29.207 -37.5859 72.9594    -0.29876 -0.836543 0.45928    0 0
  v -31.5345 -36.0947 75.5083    -0.132447 -0.97219 0.193144    0 0
  v -30.8761 -35.6522 75.6307    0.843122 -0.431369 0.32104    0 0
  v -30.4628 -35.5615 78.9903    0.764879 -0.441924 -0.468682    0 0
  v -31.0706 -36.0072 79.1893    -0.126927 -0.983721 -0.127207    0 0
  v -28.2422 -37.4057 81.5855    -0.343217 -0.855373 -0.387993    0 0
  v -27.8954 -36.8298 81.1716    0.140332 -0.30286 -0.942647    0 0
  v -24.4576 -38.823 81.0839    -0.45915 -0.180669 -0.869793    0 0
  v -24.4634 -39.591 81.4986    -0.582 -0.732596 -0.352959    0 0
  v -22.2821 -37.942 78.5757    -0.959706 -0.0350675 -0.278808    0 0
  v -22.7049 -34.7615 78.2137    -0.91518 -0.334063 -0.225493    0 0
  v -22.9217 -34.8049 75.3792    -0.872761 -0.310006 0.377074    0 0
  v -22.5202 -37.9891 75.2835    -0.908255 -0.00139263 0.418414    0 0
  v -24.9895 -36.7696 73.1811    -0.291257 -0.00720216 0.956618    0 0
  v -25.0609 -33.7485 73.5569    -0.448081 -0.32352 0.833401    0 0
  v -28.0359 -32.1288 73.6724    0.176268 -0.403715 0.897744    0 0
  v -28.4554 -34.8931 73.3198    0.351422 -0.0505176 0.934853    0 0
  v -30.4993 -33.5828 75.5707    0.951118 -0.129696 0.280275    0 0
  v -29.8064 -30.9937 75.6234    0.753443 -0.542838 0.371013    0 0
  v -29.4729 -30.9199 78.4189    0.67332 -0.557064 -0.486128    0 0
  v -30.0992 -33.494 78.8084    0.868306 -0.159843 -0.469568    0 0
  v -27.6299 -34.7135 80.9108    0.234873 -0.140967 -0.96175    0 0
  v -27.3338 -31.9763 80.2412    0.0623136 -0.478294 -0.875986    0 0
  v -24.4753 -33.6265 80.1647    -0.561206 -0.39641 -0.726572    0 0
  v -24.326 -36.6317 80.8266    -0.423273 -0.0980646 -0.900679    0 0
  v -1.95988 -40.0817 57.9027    -0.179742 -0.611577 -0.770497    0 0
  v -1.59486 -40.7201 58.5135    -0.0534867 -0.880928 -0.470219    0 0
  v -6.60973 -41.2628 60.5683    -0.208589 -0.783391 -0.585482    0 0
  v -0.384826 -24.8089 108.59    -0.0175588 -0.431005 0.902179    0 0
  v -0.384826 -20.7968 110.055    -0.0442272 -0.255945 0.965679    0 0
  v -3.37962 -24.1263 108.634    -0.145565 -0.381187 0.912966    0 0
  v -1.16332 -18.5213 110.477    -0.0707344 -0.180593 0.981011    0 0
  v -1.97317 -17.174 110.61    -0.0875345 -0.109981 0.990072    0 0
  v -8.42581 -20.6511 108.875    -0.208818 -0.27651 0.93805    0 0
  v -5.97167 -22.391 108.811    -0.178707 -0.325899 0.928361    0 0
  v -2.66204 -16.0639 110.637    -0.0911054 -0.0650658 0.993713    0 0
  v -3.14157 -14.8597 110.651    -0.0903294 -0.0357124 0.995271    0 0
  v -11.7749 -16.4818 108.957    -0.264136 -0.134512 0.955059    0 0
  v -10.4219 -18.6956 108.91    -0.243028 -0.209566 0.947111    0 0
  v -3.38742 -13.5901 110.656    -0.0898601 -0.010437 0.9959    0 0
  v -3.38742 -12.2948 110.656    -0.0905156 0.0122749 0.995819    0 0
  v -12.5486 -11.804 108.932    -0.28236 0.0497641 0.958017    0 0
  v -12.4854 -14.1441 108.97    -0.279018 -0.0365886 0.959588    0 0
  v -3.14157 -11.0251 110.651    -0.0916579 0.0355367 0.995156    0 0
  v -2.66204 -9.82097 110.637    -0.0920626 0.0645286 0.99366    0 0
  v -10.5063 -7.28911 108.883    -0.251572 0.20388 0.946121    0 0
  v -11.9056 -9.5264 108.897    -0.273375 0.130279 0.953044    0 0
  v -1.97317 -8.71083 110.61    -0.0879202 0.109715 0.990067    0 0
  v -1.16332 -7.3635 110.477    -0.0707781 0.180558 0.981014    0 0
  v -5.97167 -3.49389 108.811    -0.179336 0.3255 0.928379    0 0
  v -8.44268 -5.25371 108.87    -0.213591 0.273443 0.937874    0 0
  v -0.384825 -5.08805 110.055    -0.0442268 0.255945 0.965679    0 0
  v -0.384825 -1.076 108.59    -0.0175589 0.431005 0.902179    0 0
  v -3.37962 -1.7585 108.634    -0.145564 0.381187 0.912967    0 0
  v -1.97317 -35.438 99.9755    -0.061674 -0.743822 0.665526    0 0
  v -1.16332 -30.1277 105.146    -0.0454461 -0.626952 0.777731    0 0
  v -5.97167 -29.2778 105.155    -0.170195 -0.588946 0.790048    0 0
  v -8.4349 -34.3467 99.9755    -0.185891 -0.71404 0.674975    0 0
  v -3.16508 -42.9982 87.8801    -0.0740177 -0.935639 0.34511    0 0
  v -2.66204 -39.8951 94.1098    -0.0697488 -0.83994 0.538179    0 0
  v -10.4674 -38.5802 94.1098    -0.207215 -0.808382 0.550981    0 0
  v -12.0685 -41.6419 87.8763    -0.203779 -0.900744 0.383581    0 0
  v -3.61808 -44.8484 73.8088    -0.0693597 -0.996937 -0.0361394    0 0
  v -3.505 -44.5903 80.9152    -0.0722343 -0.989963 0.121474    0 0
  v -12.6579 -43.4012 80.9069    -0.174413 -0.974908 0.138329    0 0
  v -13.0096 -43.6117 73.5345    -0.180472 -0.982243 -0.0512737    0 0
  v -0.858834 -29.888 49.4185    -0.054982 -0.55775 -0.828186    0 0
  v -2.22789 -35.2584 53.5189    -0.0780827 -0.639122 -0.765131    0 0
  v -8.79179 -33.9889 53.5379    -0.174741 -0.620796 -0.76425    0 0
  v -5.14706 -29.0812 49.4185    -0.156373 -0.507316 -0.847454    0 0
  v -0.384664 1.94082 46.1521    -0.163449 0.924352 0.344756    0 0
  v -0.637205 3.0027 43.2306    -0.0979678 0.94274 0.318815    0 0
  v -4.47579 2.20829 43.2306    -0.284744 0.896203 0.340207    0 0
  v -3.74201 1.14874 46.1521    -0.288253 0.855423 0.430304    0 0
  v -0.838287 3.93648 39.7645    -0.0986387 0.973796 0.20492    0 0
  v -0.96004 4.52289 35.7223    -0.100064 0.991147 0.0872666    0 0
  v -5.41322 3.61714 35.7223    -0.296204 0.950761 0.0911912    0 0
  v -5.05982 3.07362 39.7645    -0.291942 0.931997 0.214828    0 0
  v -0.981026 4.62652 31.4043    -0.100341 0.994273 -0.0367802    0 0
  v -0.901766 4.23515 27.0865    -0.0995043 0.984788 -0.142446    0 0
  v -5.24415 3.35041 27.0865    -0.294628 0.943991 -0.148574    0 0
  v -5.47411 3.71321 31.4043    -0.297023 0.954098 -0.0383875    0 0
  v -0.74474 3.45978 23.0204    -0.097725 0.964559 -0.245104    0 0
  v -0.510351 2.30242 19.4729    -0.0925099 0.908685 -0.407103    0 0
  v -4.10847 1.55877 19.4729    -0.273965 0.864122 -0.42218    0 0
  v -4.78854 2.63164 23.0204    -0.289555 0.922491 -0.255281    0 0
  v -0.176931 0.656057 16.7254    -0.0784527 0.765846 -0.638221    0 0
  v 0.219268 -1.32374 14.8356    -0.0588492 0.597126 -0.799986    0 0
  v -1.95144 -1.81232 14.8288    -0.1915 0.54345 -0.817307    0 0
  v -3.14106 0.0325898 16.7254    -0.232632 0.71815 -0.655853    0 0
  v 0.584069 -3.21886 13.6374    -0.0399687 0.455877 -0.889145    0 0
  v 0.589649 -4.66976 13.0256    -0.0624053 0.313515 -0.94753    0 0
  v -0.732697 -3.60763 13.6031    -0.162809 0.396813 -0.903345    0 0
  v 3.93966 -29.159 60.1076    -0.234186 -0.740992 0.629355    0 0
  v 7.41792 -30.4142 61.6084    -0.487298 -0.772433 -0.407294    0 0
  v 3.93966 -29.8087 61.0836    0.0896242 -0.512785 -0.853826    0 0
  v 4.75182 -40.9468 59.3247    -0.170988 -0.907878 0.382781    0 0
  v 10.3586 -41.7589 61.8865    -0.319505 -0.940845 0.112814    0 0
  v 9.90891 -40.8281 61.9944    -0.648801 -0.172474 0.741154    0 0
  v 4.75525 -40.0091 59.6202    -0.258506 -0.104594 0.96033    0 0
  v 10.6028 -42.484 63.3268    0.0637397 -0.724461 -0.686363    0 0
  v 4.996 -42.724 62.7597    0.0668989 -0.788484 -0.611406    0 0
  v 4.75525 -41.6253 62.3186    0.10961 -0.0610002 -0.992101    0 0
  v 9.90891 -41.4746 63.0738    -0.0115342 -0.0409389 -0.999095    0 0
  v -2.35704 -42.724 62.7597    -0.066899 -0.788484 -0.611406    0 0
  v -7.96382 -42.484 63.3268    -0.0637396 -0.724461 -0.686362    0 0
  v -7.26995 -41.4746 63.0738    0.0115341 -0.0409389 -0.999095    0 0
  v -2.11629 -41.6253 62.3186    -0.10961 -0.0610002 -0.992101    0 0
  v -7.71964 -41.7589 61.8865    0.319507 -0.940844 0.112817    0 0
  v -2.11286 -40.9468 59.3247    0.170988 -0.907878 0.38278    0 0
  v -2.11629 -40.0091 59.6202    0.258506 -0.104594 0.96033    0 0
  v -7.26995 -40.8281 61.9944    0.648801 -0.172474 0.741154    0 0
  v 4.6544 -36.6804 59.7108    -0.256871 -0.0236426 0.966156    0 0
  v 9.65677 -37.5262 62.0527    -0.64067 -0.0432428 0.766597    0 0
  v 8.93486 -33.0339 61.8468    -0.701175 -0.179329 0.690068    0 0
  v 4.49128 -31.9773 59.8246    -0.254111 -0.0619235 0.965191    0 0
  v 9.65677 -38.1994 63.1014    -0.00439581 -0.0135299 -0.999899    0 0
  v 4.6544 -38.3634 62.3327    0.11473 -0.00535686 -0.993382    0 0
  v 4.49128 -33.4812 62.102    0.116493 -0.114794 -0.986535    0 0
  v 8.93486 -33.6355 62.7577    -0.0574176 -0.202754 -0.977545    0 0
  v -2.01543 -38.3634 62.3327    -0.11473 -0.00535686 -0.993382    0 0
  v -7.01781 -38.1994 63.1014    0.00439584 -0.0135299 -0.999899    0 0
  v -6.2959 -33.6355 62.7577    0.0574174 -0.202754 -0.977545    0 0
  v -1.85232 -33.4812 62.102    -0.116493 -0.114794 -0.986535    0 0
  v -7.01781 -37.5262 62.0527    0.64067 -0.0432426 0.766597    0 0
  v -2.01543 -36.6804 59.7108    0.256871 -0.0236424 0.966157    0 0
  v -1.85232 -31.9773 59.8246    0.254111 -0.0619237 0.965191    0 0
  v -6.2959 -33.0339 61.8468    0.701175 -0.17933 0.690068    0 0
  v -0.26455 -15.8477 12.3331    -0.0728689 -0.0484226 -0.996165    0 0
  v -1.08414 -14.0248 12.32    -0.0787473 -0.0184395 -0.996724    0 0
  v -1.19904 -11.8407 12.3469    -0.0918998 0.0249165 -0.995456    0 0
  v -0.277576 -10.0477 12.3348    -0.0764981 0.0462484 -0.995997    0 0
  v 1.31948 -9.41758 12.2774    1.42876e-006 0.0407007 -0.999171    0 0
  v 2.91654 -10.0477 12.3348    0.076497 0.0462493 -0.995997    0 0
  v 3.83801 -11.8407 12.3469    0.0919003 0.0249154 -0.995456    0 0
  v 3.7231 -14.0248 12.32    0.0787461 -0.0184393 -0.996724    0 0
  v 2.90352 -15.8477 12.3331    0.0728688 -0.0484206 -0.996165    0 0
  v 1.31948 -16.4673 12.2774    3.897e-007 -0.0407702 -0.999169    0 0
  v 13.1221 -41.4687 62.4773    0.267669 -0.793564 -0.546451    0 0
  v 8.73061 -39.2152 58.1208    0.172817 -0.730062 -0.661169    0 0
  v 15.2283 -37.961 58.6378    0.243409 -0.749853 -0.615202    0 0
  v 17.7723 -40.9971 64.4094    0.310642 -0.834644 -0.45483    0 0
  v 9.24869 -41.2628 60.5683    0.208589 -0.783392 -0.585481    0 0
  v 4.23382 -40.7201 58.5135    0.0534873 -0.880927 -0.47022    0 0
  v 4.59884 -40.0817 57.9027    0.179742 -0.611577 -0.770498    0 0
  v -9.36097 -42.8371 64.6481    -0.155955 -0.933692 -0.322332    0 0
  v -2.81576 -43.4043 64.5126    -0.0481339 -0.948424 -0.313329    0 0
  v -3.35427 -44.2828 68.1195    -0.0600495 -0.982894 -0.174111    0 0
  v -11.8778 -43.1865 67.7907    -0.190191 -0.960865 -0.201409    0 0
  v -10.4831 -41.4687 62.4773    -0.267669 -0.793564 -0.546452    0 0
  v -15.1333 -40.9971 64.4094    -0.310642 -0.834644 -0.45483    0 0
  v -12.5894 -37.961 58.6378    -0.243409 -0.749853 -0.615202    0 0
  v -6.09164 -39.2152 58.1208    -0.172817 -0.730062 -0.661169    0 0
  v -1.3007 -29.8087 61.0836    -0.0896243 -0.512784 -0.853827    0 0
  v -4.77895 -30.4142 61.6084    0.487298 -0.772433 -0.407294    0 0
  v -1.3007 -29.159 60.1076    0.234186 -0.740993 0.629354    0 0
  v 10.8995 -28.4771 105.177    0.213179 -0.557212 0.80254    0 0
  v 15.2168 -29.9195 102.723    0.281285 -0.595885 0.752197    0 0
  v 15.2389 -26.3566 105.184    0.296685 -0.484152 0.823149    0 0
  v 10.8995 -24.9751 107.259    0.218386 -0.426897 0.877534    0 0
  v 18.9188 -34.2071 97.0649    0.325586 -0.701078 0.634415    0 0
  v 19.9921 -30.6994 99.9638    0.361041 -0.610454 0.704979    0 0
  v 14.1811 -33.3943 99.9755    0.245374 -0.687477 0.683496    0 0
  v 25.0457 -27.0769 99.8578    0.467498 -0.49658 0.731337    0 0
  v 20.0848 -27.083 102.655    0.383183 -0.502403 0.775088    0 0
  v 24.8993 -30.7013 97.0616    0.446369 -0.606952 0.657544    0 0
  v 14.2253 -22.8904 107.26    0.279841 -0.358539 0.890584    0 0
  v 19.1396 -23.5602 105.062    0.382594 -0.383867 0.840397    0 0
  v 24.3482 -23.435 102.37    0.443633 -0.424121 0.7895    0 0
  v 22.2396 -20.1782 104.862    0.416493 -0.276678 0.866016    0 0
  v 17.072 -20.3492 107.153    0.34199 -0.271455 0.899641    0 0
  v 29.6878 -26.2805 97.0481    0.511511 -0.538681 0.669462    0 0
  v 29.4418 -23.0937 99.7369    0.346466 -0.618201 0.705541    0 0
  v 35.0953 -21.346 101.116    -0.154011 -0.886764 0.43581    0 0
  v 30.835 -20.7508 101.428    0.0726593 -0.600229 0.796521    0 0
  v 33.8245 -22.6829 98.2193    0.198042 -0.868526 0.454358    0 0
  v 30.8734 -17.8666 102.327    0.0778731 -0.0242549 0.996668    0 0
  v 26.9122 -19.1017 103.081    0.306852 -0.272639 0.911871    0 0
  v 34.1028 -19.5694 102.524    -0.310586 -0.286723 0.90627    0 0
  v 18.8431 -17.4925 107.209    0.367953 -0.195302 0.909102    0 0
  v 23.4752 -16.6947 105.165    0.424589 -0.135497 0.89519    0 0
  v 28.0491 -15.6107 103.08    0.367317 0.0718278 0.927318    0 0
  v 24.4425 -13.3375 104.859    0.469208 0.00827947 0.883049    0 0
  v 19.7592 -14.5986 107.209    0.395151 -0.0428895 0.917614    0 0
  v 34.7523 -17.5449 102.533    -0.153598 0.421569 0.893693    0 0
  v 32.5768 -15.3983 101.432    0.274449 0.529332 0.802799    0 0
  v 36.4174 -14.7413 98.2238    0.478686 0.736417 0.478069    0 0
  v 32.6996 -13.1643 99.7299    0.531922 0.429908 0.729546    0 0
  v 36.702 -16.3524 101.139    0.19792 0.862714 0.465351    0 0
  v 31.0032 -8.77093 99.8433    0.612334 0.197629 0.7655    0 0
  v 28.2628 -11.4046 102.36    0.556091 0.152326 0.817043    0 0
  v 34.7609 -10.7895 97.0338    0.66515 0.233916 0.709125    0 0
  v 19.8291 -11.6232 107.155    0.400317 0.0498404 0.91502    0 0
  v 23.5931 -9.64933 105.058    0.484702 0.13469 0.864247    0 0
  v 26.5239 -7.01634 102.646    0.539528 0.238834 0.807383    0 0
  v 21.7012 -5.8551 105.187    0.447298 0.268934 0.852994    0 0
  v 18.7295 -8.5325 107.267    0.378455 0.166139 0.910588    0 0
  v 33.0007 -5.56041 97.0467    0.641209 0.295723 0.708095    0 0
  v 28.5763 -3.7654 99.9533    0.569325 0.339961 0.748529    0 0
  v 24.8877 1.00239 99.9721    0.484751 0.483063 0.729154    0 0
  v 23.7876 -2.62308 102.722    0.48245 0.373802 0.792158    0 0
  v 29.6785 -0.0650826 97.0575    0.574425 0.442082 0.688912    0 0
  v 16.8427 -5.57292 107.294    0.335577 0.271783 0.901955    0 0
  v 18.9102 -2.36201 105.202    0.379463 0.388335 0.839764    0 0
  v 19.9727 1.16349 102.725    0.386428 0.502427 0.77346    0 0
  v 15.2159 0.46799 105.199    0.294904 0.485709 0.822872    0 0
  v 14.1794 -3.00192 107.288    0.275316 0.361724 0.890706    0 0
  v 24.8974 4.72428 97.0634    0.459072 0.594141 0.660491    0 0
  v 19.9763 4.79561 99.9752    0.366069 0.607526 0.704915    0 0
  v 14.1811 7.50948 99.9755    0.245374 0.687477 0.683496    0 0
  v 15.2168 4.03466 102.723    0.281331 0.595855 0.752203    0 0
  v 18.9188 8.32223 97.0649    0.327473 0.699924 0.634719    0 0
  v 10.8995 -0.909769 107.259    0.217837 0.42733 0.87746    0 0
  v 10.8995 2.59222 105.177    0.213179 0.557212 0.80254    0 0
  v 9.87722 5.98475 102.715    0.174924 0.660376 0.730278    0 0
  v 6.24578 3.96233 105.14    0.107918 0.618572 0.778282    0 0
  v 7.31184 0.780496 107.171    0.160063 0.492687 0.855359    0 0
  v 12.1628 10.7301 97.0649    0.197039 0.761864 0.617041    0 0
  v 7.8739 9.14341 99.9755    0.123863 0.733392 0.668426    0 0
  v 1.31948 9.69015 99.9755    2.15388e-007 0.74693 0.664902    0 0
  v 4.21281 6.95188 102.712    0.0563135 0.691602 0.720081    0 0
  v 4.98121 11.9412 97.0649    0.0659537 0.791246 0.607931    0 0
  v 3.3996 1.53168 107.149    0.0318299 0.536456 0.843328    0 0
  v 1.31948 4.31088 105.155    -1.19843e-006 0.625795 0.779988    0 0
  v 16.8513 -37.4358 94.1098    0.277337 -0.778913 0.562476    0 0
  v 21.7565 -37.4755 91.1633    0.356929 -0.776976 0.518565    0 0
  v 23.809 -34.1963 94.1197    0.410958 -0.696992 0.587635    0 0
  v 24.0048 -39.5999 85.8124    0.35788 -0.83129 0.425299    0 0
  v 26.606 -36.7047 88.4949    0.4408 -0.749871 0.493344    0 0
  v 18.9662 -40.4232 87.975    0.283394 -0.857781 0.428836    0 0
  v 33.3459 -31.8538 88.1047    0.608637 -0.613943 0.502628    0 0
  v 28.6509 -33.3502 91.2277    0.504312 -0.66812 0.54707    0 0
  v 31.1575 -35.4246 85.8446    0.53856 -0.700226 0.468654    0 0
  v 29.6619 -29.7768 94.2094    0.543086 -0.578944 0.608179    0 0
  v 34.1512 -27.9014 91.3843    0.621282 -0.557937 0.550196    0 0
  v 34.0028 -24.7408 94.8888    0.502121 -0.696633 0.512422    0 0
  v 37.6019 -29.5529 84.6383    0.744793 -0.543792 0.386747    0 0
  v 38.1935 -25.6374 88.1758    0.755333 -0.480736 0.445382    0 0
  v 41.3724 -19.6375 87.8216    0.867016 -0.276273 0.414675    0 0
  v 38.8324 -21.9632 91.1701    0.825553 -0.482025 0.293452    0 0
  v 41.619 -23.1178 84.5624    0.83203 -0.403481 0.380696    0 0
  v 39.4883 -20.7176 97.311    0.742139 -0.626301 -0.238697    0 0
  v 37.2545 -22.5898 94.8961    0.60139 -0.77756 0.183657    0 0
  v 39.5709 -19.3113 93.9081    0.953347 -0.301744 -0.00898231    0 0
  v 37.3897 -21.9831 98.8262    0.18563 -0.978027 0.094896    0 0
  v 39.1497 -16.5 98.8489    0.552689 0.816131 0.168715    0 0
  v 39.4562 -15.7687 94.8996    0.888091 0.402432 0.222133    0 0
  v 37.7895 -13.1224 94.8819    0.721601 0.413331 0.555383    0 0
  v 40.5008 -16.7855 91.1683    0.949014 -0.0601309 0.309445    0 0
  v 40.291 -18.2036 97.3202    0.965629 0.135895 -0.221569    0 0
  v 43.7113 -16.5743 84.5613    0.906904 -0.133946 0.39948    0 0
  v 42.0703 -13.4243 88.1725    0.882586 0.00726887 0.470094    0 0
  v 41.1591 -6.74495 88.0023    0.824817 0.248793 0.507719    0 0
  v 39.7267 -10.4871 91.3756    0.791233 0.174756 0.586013    0 0
  v 43.6382 -9.71899 84.6391    0.899155 0.136279 0.41587    0 0
  v 36.7695 -7.79828 94.1948    0.718135 0.229595 0.656938    0 0
  v 37.9598 -4.09137 91.1176    0.738622 0.336796 0.583958    0 0
  v 34.0967 -1.82198 94.1092    0.653702 0.396809 0.644373    0 0
  v 41.5577 -2.83082 84.5353    0.828865 0.393263 0.397903    0 0
  v 38.1689 -0.135574 87.8878    0.739685 0.467752 0.483812    0 0
  v 33.2215 5.85738 87.8783    0.61744 0.654334 0.436595    0 0
  v 34.1758 2.11388 91.0583    0.649093 0.520124 0.555112    0 0
  v 37.3604 3.61451 84.511    0.712267 0.605697 0.354693    0 0
  v 29.6992 3.79921 94.1064    0.555539 0.561797 0.612993    0 0
  v 28.6462 7.45686 91.0626    0.517675 0.68569 0.511705    0 0
  v 23.8127 8.30214 94.1094    0.419116 0.699422 0.578921    0 0
  v 31.2942 9.18743 84.5124    0.561303 0.770051 0.303251    0 0
  v 26.6151 10.7545 87.8798    0.466274 0.792578 0.392949    0 0
  v 18.8012 14.367 87.8792    0.310852 0.87741 0.365408    0 0
  v 21.7376 11.5601 91.0635    0.370208 0.795696 0.47939    0 0
  v 23.7272 13.5788 84.5118    0.402162 0.876281 0.265325    0 0
  v 16.8513 11.551 94.1098    0.278888 0.783255 0.555638    0 0
  v 13.9128 14.3404 91.0632    0.221793 0.859854 0.459847    0 0
  v 9.24309 13.516 94.1098    0.139685 0.828906 0.541667    0 0
  v 15.148 16.6001 84.5083    0.240763 0.939848 0.24232    0 0
  v 10.243 16.5681 87.8773    0.155208 0.923876 0.349805    0 0
  v 1.31948 17.3102 87.8762    0 0.938611 0.344979    0 0
  v 5.57433 15.7435 91.0627    0.0740885 0.88988 0.450139    0 0
  v 5.99298 18.1338 84.5039    0.080529 0.969382 0.231977    0 0
  v 1.31948 14.1759 94.1098    -1.99645e-007 0.843565 0.537027    0 0
  v 37.1888 -32.3188 80.7922    0.760477 -0.59389 0.262621    0 0
  v 39.96 -29.7424 77.1982    0.814312 -0.568371 0.11769    0 0
  v 41.0662 -26.6722 80.9751    0.824284 -0.499395 0.26676    0 0
  v 39.4748 -29.7095 69.6073    0.772763 -0.585493 -0.245022    0 0
  v 42.1437 -26.7583 73.3663    0.851195 -0.523226 -0.0412457    0 0
  v 38.1831 -32.3501 73.6029    0.782112 -0.619835 -0.0640808    0 0
  v 45.4104 -20.0411 73.3573    0.949821 -0.311788 -0.0250521    0 0
  v 43.7053 -23.5337 77.1744    0.893456 -0.429121 0.132635    0 0
  v 43.5724 -23.2636 69.5609    0.874102 -0.43334 -0.219458    0 0
  v 44.2797 -20.0371 80.9035    0.915062 -0.293469 0.276654    0 0
  v 45.9765 -16.5518 77.1742    0.976408 -0.153818 0.151549    0 0
  v 45.3283 -13.0388 80.9736    0.95385 0.00227302 0.300276    0 0
  v 45.8441 -16.442 69.5609    0.96277 -0.156729 -0.220252    0 0
  v 46.557 -12.9424 73.3573    0.999863 -1.58624e-006 -0.0165795    0 0
  v 45.4104 -5.84375 73.3573    0.949873 0.311805 -0.0227975    0 0
  v 45.9692 -9.3739 77.182    0.975376 0.154317 0.157569    0 0
  v 45.8441 -9.4428 69.5609    0.96277 0.156728 -0.220252    0 0
  v 44.2371 -5.94726 80.9396    0.91188 0.287812 0.292642    0 0
  v 43.6992 -2.35755 77.1716    0.887278 0.440612 0.13638    0 0
  v 40.9345 0.83982 80.9167    0.803123 0.53683 0.258472    0 0
  v 43.5724 -2.62125 69.5609    0.869106 0.443416 -0.219173    0 0
  v 41.9991 0.896696 73.3573    0.821274 0.569126 -0.0400647    0 0
  v 36.5218 6.94762 73.3573    0.655595 0.752548 -0.0621824    0 0
  v 39.2578 4.13638 77.1692    0.743519 0.661095 0.100661    0 0
  v 39.1413 3.68484 69.5609    0.720653 0.657937 -0.218584    0 0
  v 35.6026 6.94455 80.9148    0.654247 0.726504 0.210125    0 0
  v 32.8738 9.76796 77.1693    0.574845 0.815904 0.0620797    0 0
  v 28.5088 12.0159 80.9147    0.490136 0.855606 0.166448    0 0
  v 32.776 9.1553 69.5609    0.552522 0.804147 -0.219243    0 0
  v 29.2405 11.9954 73.3564    0.48517 0.870482 -0.0828875    0 0
  v 20.6279 15.8058 73.3485    0.322553 0.94145 -0.0981429    0 0
  v 24.9144 14.2556 77.1667    0.408922 0.912019 0.0316801    0 0
  v 24.8407 13.5229 69.5571    0.391831 0.893069 -0.221126    0 0
  v 20.1188 15.8201 80.9108    0.326707 0.935222 0.136463    0 0
  v 15.8851 17.3763 77.1558    0.245102 0.969414 0.0127187    0 0
  v 10.9186 18.1616 80.9015    0.163433 0.979178 0.120415    0 0
  v 15.8394 16.5732 69.5416    0.2358 0.945893 -0.2229    0 0
  v 11.1797 18.1732 73.3301    0.162298 0.981022 -0.106089    0 0
  v 1.31948 18.9862 73.3186    3.81857e-007 0.994133 -0.108163    0 0
  v 6.2428 18.9775 77.1421    0.0825606 0.996574 0.00492245    0 0
  v 6.22729 18.1488 69.5222    0.0799782 0.971338 -0.223844    0 0
  v 1.31948 18.958 80.8958    9.33607e-010 0.993247 0.116023    0 0
  v 20.905 -40.2022 65.2368    0.345986 -0.835828 -0.426246    0 0
  v 23.4514 -37.2143 62.1159    0.370505 -0.767937 -0.522493    0 0
  v 28.3814 -36.6223 65.236    0.439889 -0.766469 -0.467999    0 0
  v 25.448 -39.6695 68.1464    0.376154 -0.840237 -0.390526    0 0
  v 19.734 -33.8876 56.0989    0.302131 -0.645375 -0.701576    0 0
  v 25.1545 -33.9523 59.052    0.391367 -0.682612 -0.617149    0 0
  v 18.4588 -36.9943 58.8558    0.291433 -0.740681 -0.605358    0 0
  v 31.3063 -29.7148 59.0738    0.496748 -0.578859 -0.646656    0 0
  v 30.4476 -33.2785 62.2473    0.481821 -0.688441 -0.542124    0 0
  v 25.7957 -30.4678 56.1425    0.391332 -0.559518 -0.730616    0 0
  v 33.0469 -35.4339 68.3083    0.543499 -0.730891 -0.412804    0 0
  v 35.4298 -31.9571 65.8068    0.600575 -0.659768 -0.451681    0 0
  v 36.3294 -28.2494 62.3475    0.620246 -0.55978 -0.549492    0 0
  v 40.5018 -26.0663 65.8696    0.760018 -0.508725 -0.404439    0 0
  v 30.783 -26.1292 56.1425    0.472494 -0.42697 -0.771003    0 0
  v 35.9898 -24.6123 59.0738    0.59883 -0.42137 -0.681065    0 0
  v 38.9068 -18.9284 59.0738    0.667369 -0.222529 -0.710703    0 0
  v 40.3956 -22.4238 62.3401    0.734387 -0.376594 -0.56467    0 0
  v 34.2548 -21.128 56.1425    0.531137 -0.268333 -0.803674    0 0
  v 43.749 -19.6575 65.8621    0.863762 -0.288733 -0.412976    0 0
  v 42.4997 -16.1573 62.3401    0.800038 -0.131439 -0.585375    0 0
  v 44.8532 -12.9424 65.8621    0.907366 4.88135e-007 -0.420341    0 0
  v 36.0347 -15.7179 56.1425    0.562199 -0.0906506 -0.822019    0 0
  v 39.8872 -12.9424 59.0738    0.691893 -8.42547e-009 -0.722    0 0
  v 38.9068 -6.95645 59.0738    0.667369 0.222529 -0.710704    0 0
  v 42.4997 -9.72756 62.3401    0.800038 0.131439 -0.585374    0 0
  v 36.0347 -10.1669 56.1425    0.562199 0.0906509 -0.822019    0 0
  v 43.749 -6.22737 65.8621    0.863761 0.288732 -0.412977    0 0
  v 40.3956 -3.46106 62.3401    0.733874 0.377821 -0.564518    0 0
  v 40.464 0.148806 65.8621    0.750708 0.529718 -0.39476    0 0
  v 34.2548 -4.75686 56.1425    0.531137 0.268332 -0.803674    0 0
  v 35.9898 -1.27255 59.0738    0.599404 0.421774 -0.68031    0 0
  v 31.3063 3.82991 59.0738    0.500419 0.583129 -0.639954    0 0
  v 36.2916 2.33193 62.3401    0.622882 0.573724 -0.531845    0 0
  v 30.783 0.2444 56.1425    0.472494 0.426971 -0.771003    0 0
  v 35.1894 5.87273 65.8621    0.602973 0.704744 -0.373846    0 0
  v 30.3961 7.35727 62.3401    0.488495 0.717142 -0.497071    0 0
  v 28.1782 10.6478 65.8613    0.448917 0.81958 -0.356036    0 0
  v 25.7957 4.58294 56.1425    0.389784 0.561314 -0.730065    0 0
  v 25.082 8.08531 59.0734    0.385268 0.70145 -0.599614    0 0
  v 17.7336 11.2877 59.0694    0.262832 0.780137 -0.567719    0 0
  v 23.0502 11.3665 62.3373    0.352156 0.809948 -0.469009    0 0
  v 19.589 8.03847 56.1416    0.292592 0.661413 -0.690595    0 0
  v 19.8886 14.2529 65.8533    0.300133 0.889611 -0.344255    0 0
  v 14.7277 14.1566 62.3264    0.213201 0.866779 -0.45082    0 0
  v 10.8005 16.4938 65.8349    0.151676 0.928485 -0.338985    0 0
  v 12.5788 10.4244 56.1381    0.184617 0.727834 -0.660435    0 0
  v 9.69549 13.2048 58.9753    0.134114 0.825587 -0.548106    0 0
  v 1.31948 13.6032 58.5452    0.0351732 0.817334 -0.575089    0 0
  v 5.85052 15.5345 62.2279    0.0707953 0.891855 -0.446748    0 0
  v 5.12222 11.3357 55.6244    0.0821262 0.764903 -0.638889    0 0
  v 1.31948 17.2638 65.8234    -1.87682e-007 0.940362 -0.340176    0 0
  v 14.414 -33.0835 53.5815    0.220117 -0.596926 -0.77151    0 0
  v 14.6815 -29.7342 51.4139    0.251012 -0.520239 -0.816299    0 0
  v 20.1186 -30.4589 53.6208    0.30295 -0.520929 -0.798032    0 0
  v 8.97473 -25.1147 47.5221    0.241982 -0.412577 -0.878194    0 0
  v 13.772 -26.347 49.4185    0.25073 -0.385902 -0.887814    0 0
  v 9.86173 -28.3709 49.4185    0.18898 -0.475277 -0.859301    0 0
  v 17.1217 -23.6358 49.4185    0.290691 -0.287068 -0.912738    0 0
  v 19.2538 -26.9753 51.4183    0.282051 -0.37574 -0.882761    0 0
  v 11.688 -23.1159 47.5221    0.286699 -0.31413 -0.905056    0 0
  v 25.0632 -26.9179 53.6251    0.369381 -0.412302 -0.832806    0 0
  v 22.9497 -23.5013 51.4183    0.36645 -0.306788 -0.878405    0 0
  v 28.7966 -22.6663 53.6251    0.418356 -0.281999 -0.863397    0 0
  v 13.8903 -20.5974 47.5221    0.312316 -0.215108 -0.925304    0 0
  v 19.6465 -20.3827 49.4185    0.31427 -0.187402 -0.930653    0 0
  v 21.2189 -16.7589 49.4185    0.325732 -0.0920616 -0.940969    0 0
  v 25.5224 -19.4967 51.4183    0.343819 -0.16096 -0.925138    0 0
  v 15.4233 -17.6941 47.5221    0.324137 -0.124806 -0.937741    0 0
  v 31.1218 -17.9302 53.6251    0.446876 -0.142769 -0.88313    0 0
  v 26.8415 -15.1648 51.4183    0.40923 -0.0611354 -0.910381    0 0
  v 31.9033 -12.9424 53.6251    0.456273 3.44314e-007 -0.88984    0 0
  v 16.2093 -14.5536 47.5221    0.328678 -0.0403904 -0.943578    0 0
  v 21.7475 -12.9424 49.4185    0.329168 4.65781e-009 -0.944271    0 0
  v 21.219 -9.12598 49.4185    0.325732 0.0920617 -0.940969    0 0
  v 26.8415 -10.72 51.4183    0.354216 0.0529266 -0.933665    0 0
  v 16.2093 -11.3313 47.5221    0.328678 0.0403904 -0.943578    0 0
  v 31.1218 -7.95462 53.6251    0.446876 0.142768 -0.88313    0 0
  v 25.5224 -6.38811 51.4183    0.395531 0.185133 -0.8996    0 0
  v 28.7966 -3.21852 53.6251    0.418355 0.282 -0.863397    0 0
  v 15.4233 -8.19071 47.5221    0.324137 0.124806 -0.937741    0 0
  v 19.6465 -5.50214 49.4185    0.31427 0.187402 -0.930653    0 0
  v 17.1217 -2.249 49.4185    0.290691 0.287069 -0.912738    0 0
  v 22.9497 -2.38352 51.4183    0.32115 0.26892 -0.908044    0 0
  v 13.8903 -5.28749 47.5221    0.312316 0.215108 -0.925304    0 0
  v 25.0632 1.03309 53.6251    0.369381 0.412302 -0.832806    0 0
  v 19.2538 1.09041 51.4183    0.318037 0.424151 -0.847908    0 0
  v 20.1041 4.57759 53.625    0.301026 0.524935 -0.796132    0 0
  v 11.688 -2.76897 47.5221    0.286699 0.31413 -0.905056    0 0
  v 13.772 0.462106 49.4185    0.25073 0.385902 -0.887814    0 0
  v 9.86173 2.48606 49.4185    0.18898 0.475277 -0.859301    0 0
  v 14.667 3.85297 51.4182    0.225085 0.471001 -0.852933    0 0
  v 8.97473 -0.770115 47.5221    0.241982 0.412577 -0.878194    0 0
  v 14.2689 7.23427 53.6242    0.214497 0.612463 -0.760841    0 0
  v 9.52313 5.74602 51.4178    0.167158 0.599381 -0.782816    0 0
  v 7.9189 8.82482 53.5375    0.151728 0.654868 -0.740356    0 0
  v 5.98913 0.586594 47.5221    0.171256 0.499252 -0.849364    0 0
  v 5.65901 3.75146 49.4185    0.137388 0.526457 -0.839028    0 0
  v 1.31948 4.6029 49.4185    0.102821 0.560156 -0.821981    0 0
  v 4.08655 6.83498 51.3325    0.106363 0.597265 -0.79496    0 0
  v 2.88878 1.41576 47.5221    0.112809 0.541948 -0.832806    0 0
  v 1.31948 9.32852 52.9419    0.109704 0.680781 -0.724225    0 0
  v 56.5144 -24.9038 125.915    0.0199389 -0.237954 0.971072    0 0
  v 57.7415 -25.1226 125.722    0.207881 -0.323222 0.923208    0 0
  v 58.0207 -24.1679 125.833    0.260383 -0.0244367 0.965196    0 0
  v 56.7685 -24.0375 126.015    0.0545066 -0.00716099 0.998488    0 0
  v 58.2523 -26.1484 124.944    0.337521 -0.613072 0.714298    0 0
  v 58.826 -25.2635 125.268    0.437368 -0.394114 0.808321    0 0
  v 57.2679 -26.021 125.357    0.162657 -0.542957 0.823857    0 0
  v 59.9828 -24.4514 124.668    0.703029 -0.117203 0.701437    0 0
  v 59.1053 -24.3088 125.378    0.507899 -0.0643638 0.859008    0 0
  v 59.7287 -25.3177 124.568    0.627832 -0.419466 0.655649    0 0
  v 58.0993 -23.1929 125.683    0.297789 0.241943 0.923464    0 0
  v 59.0837 -23.3203 125.27    0.507186 0.234408 0.829346    0 0
  v 37.9646 -20.8559 104.182    -0.496096 -0.654306 0.570764    0 0
  v 41.3582 -20.9811 107.513    -0.697954 -0.262973 0.666112    0 0
  v 37.9168 -19.4258 104.649    -0.530948 0.153079 0.833463    0 0
  v 39.1471 -21.7318 102.926    -0.140923 -0.985148 0.0981021    0 0
  v 41.8203 -21.8947 106.904    -0.431889 -0.865497 0.253745    0 0
  v 47.3198 -23.4351 113.445    -0.511068 -0.84909 0.133626    0 0
  v 44.6073 -22.2962 110.644    -0.672057 -0.608366 0.422174    0 0
  v 45.2865 -22.81 110.084    -0.198899 -0.978209 -0.0595513    0 0
  v 44.5131 -21.4033 110.936    -0.724917 0.169822 0.667575    0 0
  v 46.8662 -22.6653 113.868    -0.813509 -0.269487 0.515344    0 0
  v 40.7392 -21.4641 101.612    0.378637 -0.88863 -0.258788    0 0
  v 42.879 -22.0887 106.044    0.0867325 -0.976366 -0.197955    0 0
  v 41.8427 -20.0674 101.112    0.846548 -0.251666 -0.469065    0 0
  v 43.9698 -21.4216 105.414    0.581216 -0.650097 -0.48945    0 0
  v 49.2764 -23.0081 112.59    0.522698 -0.596352 -0.609221    0 0
  v 46.3025 -22.552 109.533    0.315679 -0.848854 -0.424021    0 0
  v 46.9995 -21.7784 109.306    0.772589 -0.182937 -0.607981    0 0
  v 48.2839 -23.5722 112.933    0.0750255 -0.936192 -0.343388    0 0
  v 41.6731 -18.4955 101.65    0.757225 0.627499 -0.181262    0 0
  v 44.3105 -20.31 105.449    0.843061 0.293995 -0.45035    0 0
  v 40.3895 -17.7904 102.981    0.276419 0.939137 0.203993    0 0
  v 43.7059 -19.3899 106.132    0.50227 0.862229 -0.0654655    0 0
  v 48.9399 -21.3249 113.136    0.43853 0.881153 -0.176806    0 0
  v 46.8013 -20.8746 109.637    0.671144 0.670741 -0.315711    0 0
  v 46.018 -20.3499 110.237    0.214307 0.97067 0.108958    0 0
  v 49.5388 -22.1092 112.671    0.748232 0.369041 -0.551324    0 0
  v 38.8065 -18.181 104.22    -0.146371 0.789035 0.596657    0 0
  v 42.6319 -19.2449 106.992    -0.0177098 0.932489 0.360764    0 0
  v 41.6835 -19.9184 107.548    -0.479274 0.550649 0.683434    0 0
  v 47.1287 -21.7663 113.949    -0.606889 0.558707 0.565271    0 0
  v 45.106 -20.6188 110.748    -0.333539 0.794688 0.507171    0 0
  v 47.9759 -21.1877 113.647    -0.135618 0.946703 0.292167    0 0
  v 48.4283 -23.73 115.751    -0.761634 -0.599573 0.245815    0 0
  v 48.86 -23.6056 117.333    -0.951634 -0.215862 0.218624    0 0
  v 48.2673 -22.6843 116.074    -0.846618 0.187636 0.498026    0 0
  v 49.3255 -24.3305 115.218    -0.243359 -0.943308 -0.225714    0 0
  v 49.5738 -24.7149 116.779    -0.601157 -0.786354 -0.14233    0 0
  v 49.9716 -25.696 118.07    -0.648124 -0.63391 -0.422011    0 0
  v 49.2934 -24.6326 117.929    -0.865384 -0.470911 -0.17133    0 0
  v 50.7062 -25.5483 117.156    -0.342081 -0.764018 -0.547045    0 0
  v 49.0323 -23.0296 118.411    -0.961638 0.272492 0.0316209    0 0
  v 48.9012 -24.0491 118.882    -0.983393 -0.114738 -0.140618    0 0
  v 50.6175 -24.026 114.752    0.268962 -0.772813 -0.574821    0 0
  v 51.0446 -24.9074 116.151    -0.00193022 -0.824049 -0.566516    0 0
  v 51.4782 -23.1183 114.608    0.655659 -0.104349 -0.747812    0 0
  v 52.537 -24.0869 115.765    0.37835 -0.462329 -0.801937    0 0
  v 54.4025 -24.7493 116.579    0.198049 -0.312643 -0.928995    0 0
  v 52.7242 -25.0737 116.492    0.108855 -0.573965 -0.811612    0 0
  v 54.0641 -23.6766 116.304    0.354018 0.00358902 -0.935232    0 0
  v 52.1721 -25.976 117.149    -0.0991697 -0.653588 -0.750325    0 0
  v 51.1893 -22.0601 114.963    0.552073 0.693552 -0.462818    0 0
  v 52.9169 -22.7871 115.913    0.530391 0.389294 -0.753084    0 0
  v 50.1642 -21.4472 115.528    0.111634 0.993014 -0.0382335    0 0
  v 51.9944 -21.6578 116.522    0.278697 0.860629 -0.426199    0 0
  v 53.6034 -21.139 117.703    0.10475 0.758664 -0.643006    0 0
  v 53.6123 -22.0554 116.839    0.285856 0.623451 -0.727733    0 0
  v 52.0088 -21.1215 117.666    -0.0600012 0.912986 -0.403554    0 0
  v 54.975 -22.8145 116.801    0.289131 0.367693 -0.883858    0 0
  v 49.0001 -21.7641 115.962    -0.445108 0.820538 0.358602    0 0
  v 50.5236 -21.4652 117.149    -0.25805 0.966021 0.0146334    0 0
  v 49.2399 -22.3058 117.482    -0.739487 0.614105 0.275742    0 0
  v 49.4737 -22.1143 119.103    -0.781458 0.617645 -0.0885353    0 0
  v 50.1815 -21.6143 118.276    -0.560528 0.825373 -0.0675763    0 0
  v 51.4029 -20.8589 118.624    -0.34375 0.890906 -0.296853    0 0
  v 49.2685 -25.2961 119.098    -0.865222 -0.465744 -0.185672    0 0
  v 48.8775 -24.399 120.155    -0.981261 -0.177733 0.0744178    0 0
  v 48.9081 -23.0757 119.761    -0.960825 0.277076 0.00659726    0 0
  v 51.2298 -26.5611 118.031    -0.343733 -0.755602 -0.557597    0 0
  v 50.258 -26.519 119.114    -0.623353 -0.739105 -0.255256    0 0
  v 50.9009 -27.1846 120.366    -0.544587 -0.838699 0.00292323    0 0
  v 49.5238 -25.865 120.327    -0.819916 -0.567035 0.0788052    0 0
  v 51.9108 -27.401 119.032    -0.280182 -0.886294 -0.368756    0 0
  v 49.0864 -23.1655 121.13    -0.926589 0.235652 0.293088    0 0
  v 49.3022 -24.7319 121.568    -0.893682 -0.251339 0.371701    0 0
  v 54.0293 -25.8979 117.106    0.0981968 -0.561781 -0.821438    0 0
  v 53.096 -26.8761 117.927    -0.0413294 -0.758304 -0.650589    0 0
  v 55.8906 -23.9584 116.839    0.327974 0.0097018 -0.944637    0 0
  v 55.9724 -25.2918 117.188    0.290836 -0.393159 -0.872262    0 0
  v 57.5178 -25.7601 118.133    0.431121 -0.506338 -0.746831    0 0
  v 55.3166 -26.5915 117.904    0.197577 -0.684714 -0.70152    0 0
  v 57.5825 -24.2312 117.577    0.483658 -0.0437452 -0.874163    0 0
  v 54.1871 -27.5959 118.992    0.0486099 -0.881226 -0.47019    0 0
  v 55.272 -21.7135 117.583    0.259257 0.613264 -0.746119    0 0
  v 56.7148 -22.798 117.472    0.398511 0.379897 -0.834786    0 0
  v 53.0525 -20.424 118.731    -0.0757119 0.898592 -0.432203    0 0
  v 54.9521 -20.6418 118.636    0.181629 0.813125 -0.553027    0 0
  v 56.3421 -20.379 119.81    0.29995 0.870675 -0.389814    0 0
  v 56.8345 -21.5022 118.482    0.389044 0.661608 -0.641031    0 0
  v 54.137 -19.9367 119.88    0.00328562 0.964711 -0.26329    0 0
  v 58.3798 -22.8733 118.46    0.570467 0.38744 -0.724195    0 0
  v 50.5112 -21.1117 119.575    -0.56374 0.819889 -0.0998928    0 0
  v 52.1142 -20.2847 119.823    -0.307824 0.939588 -0.149727    0 0
  v 49.62 -21.9053 120.439    -0.770489 0.628413 0.106976    0 0
  v 50.1642 -21.8451 121.896    -0.7024 0.600577 0.382023    0 0
  v 51.0417 -20.7757 120.905    -0.520761 0.843443 0.131953    0 0
  v 53.0558 -19.9677 121.184    -0.238175 0.967964 0.0794836    0 0
  v 50.3337 -26.3362 121.835    -0.706272 -0.621921 0.338223    0 0
  v 50.4157 -25.0508 123.239    -0.741921 -0.295322 0.601945    0 0
  v 49.85 -23.3487 122.722    -0.811469 0.174054 0.557873    0 0
  v 52.9766 -28.0352 120.403    -0.193414 -0.970555 -0.143574    0 0
  v 52.1016 -27.6366 121.971    -0.431871 -0.869237 0.240653    0 0
  v 53.7413 -27.6168 123.576    -0.247323 -0.820051 0.516089    0 0
  v 51.7838 -26.5972 123.49    -0.535327 -0.625252 0.567878    0 0
  v 54.4067 -28.2835 122.069    -0.0827468 -0.989856 0.115493    0 0
  v 51.3037 -23.6322 124.37    -0.627328 0.097783 0.772592    0 0
  v 52.194 -25.2423 124.74    -0.489794 -0.318097 0.811737    0 0
  v 56.7472 -27.1378 119.153    0.302895 -0.792183 -0.529813    0 0
  v 55.5672 -28.0695 120.523    0.137766 -0.955721 -0.260036    0 0
  v 59.2564 -24.5243 118.789    0.661359 -0.108649 -0.742159    0 0
  v 59.0796 -26.1331 119.616    0.564955 -0.603863 -0.562294    0 0
  v 60.1461 -26.2387 121.415    0.706685 -0.683103 -0.184299    0 0
  v 58.1487 -27.3929 120.829    0.411035 -0.867547 -0.280022    0 0
  v 60.6389 -24.7992 120.467    0.852716 -0.189101 -0.486946    0 0
  v 56.9222 -28.0154 122.246    0.252711 -0.964765 0.0732525    0 0
  v 58.4305 -21.5044 119.792    0.534051 0.69303 -0.484251    0 0
  v 59.9894 -23.0891 119.961    0.746246 0.374855 -0.550091    0 0
  v 55.4455 -19.7729 121.339    0.0959827 0.993845 -0.055321    0 0
  v 57.8417 -20.4595 121.385    0.417718 0.889181 -0.18673    0 0
  v 59.0069 -21.0295 123.039    0.561125 0.809442 0.173039    0 0
  v 59.8191 -21.802 121.462    0.692584 0.683053 -0.231873    0 0
  v 56.8567 -20.0835 122.998    0.20508 0.956649 0.206799    0 0
  v 60.98 -23.4443 121.732    0.94313 0.295855 -0.151577    0 0
  v 52.0171 -20.7028 122.473    -0.442462 0.816434 0.371031    0 0
  v 54.3761 -20.0266 122.834    -0.152945 0.939433 0.306713    0 0
  v 51.3255 -22.0068 123.584    -0.588178 0.531674 0.609402    0 0
  v 53.0279 -22.448 125.058    -0.384438 0.390439 0.83652    0 0
  v 53.4543 -21.0063 124.124    -0.323448 0.726376 0.606432    0 0
  v 55.8261 -20.6309 124.369    -0.0140541 0.798784 0.601454    0 0
  v 53.771 -26.4255 124.809    -0.268648 -0.559897 0.783801    0 0
  v 54.466 -25.1983 125.627    -0.209269 -0.3106 0.927218    0 0
  v 53.3744 -23.9803 125.537    -0.336866 -0.00623609 0.941532    0 0
  v 55.9321 -27.8178 123.635    0.0761318 -0.888075 0.45335    0 0
  v 55.5991 -26.9364 124.771    -0.0393391 -0.680368 0.731814    0 0
  v 55.9162 -25.8555 125.543    -0.0384597 -0.463481 0.885272    0 0
  v 57.1928 -26.8067 124.743    0.19997 -0.695901 0.689735    0 0
  v 55.5159 -24.3075 125.988    -0.0824464 -0.0887896 0.992632    0 0
  v 59.0162 -27.0859 122.615    0.511036 -0.845566 0.154469    0 0
  v 57.8929 -27.2273 123.811    0.342599 -0.831094 0.438073    0 0
  v 61.0674 -24.9488 122.319    0.957541 -0.280071 0.0683768    0 0
  v 60.2452 -25.931 123.209    0.714032 -0.628497 0.308464    0 0
  v 59.1844 -26.2736 124.174    0.513681 -0.678983 0.524513    0 0
  v 60.5118 -24.9451 123.897    0.791315 -0.289999 0.538258    0 0
  v 60.3881 -22.4767 123.139    0.815036 0.519974 0.255623    0 0
  v 60.843 -23.9145 123.439    0.914707 0.117115 0.386775    0 0
  v 57.9442 -21.0576 124.404    0.338698 0.741267 0.579489    0 0
  v 59.3995 -22.1469 124.392    0.614401 0.538485 0.576668    0 0
  v 60.0326 -23.3991 124.504    0.727658 0.241694 0.641948    0 0
  v 58.4908 -22.4132 125.247    0.397989 0.413479 0.818926    0 0
  v 55.1429 -21.8163 125.333    -0.119512 0.510018 0.851821    0 0
  v 57.1057 -21.856 125.351    0.141238 0.523177 0.840439    0 0
  v 55.0638 -23.1819 125.858    -0.138897 0.205881 0.96867    0 0
  v 56.7644 -22.981 125.873    0.0689321 0.266078 0.961484    0 0
  v 11.0822 -1.256 46.1522    0.510245 0.707413 0.489097    0 0
  v 10.1767 0.184685 44.7367    0.444149 0.778113 0.444154    0 0
  v 8.00871 0.522858 46.1521    0.364606 0.815886 0.448768    0 0
  v 13.7187 -3.59722 46.1527    0.621962 0.566206 0.540901    0 0
  v 13.226 -1.97794 44.7372    0.572182 0.659784 0.487128    0 0
  v 14.5618 -1.29252 41.5889    0.609865 0.720998 0.328979    0 0
  v 12.3958 -0.426533 43.2307    0.529179 0.755485 0.386279    0 0
  v 15.3088 -2.90915 43.232    0.652207 0.628224 0.424218    0 0
  v 8.95926 1.51561 43.2306    0.374594 0.856916 0.354083    0 0
  v 11.2226 1.02798 41.5883    0.466369 0.831161 0.302774    0 0
  v 15.7009 -6.34634 46.1586    0.703251 0.390383 0.594171    0 0
  v 15.6798 -4.58318 44.7389    0.671934 0.506221 0.540597    0 0
  v 16.9076 -9.43337 46.2011    0.760957 0.197635 0.617968    0 0
  v 17.3636 -7.52261 44.7698    0.748605 0.31467 0.583587    0 0
  v 19.0618 -7.00631 41.6031    0.842111 0.381574 0.381117    0 0
  v 17.4878 -5.71492 43.2406    0.756685 0.457141 0.467386    0 0
  v 18.8075 -8.77624 43.292    0.832835 0.236165 0.500611    0 0
  v 17.2269 -4.02736 41.5915    0.734086 0.578447 0.355692    0 0
  v 17.2181 -12.7887 46.345    0.79094 0.00054568 0.611893    0 0
  v 18.1569 -10.7894 44.8846    0.79475 0.127662 0.593358    0 0
  v 16.565 -16.2467 46.6405    0.778025 -0.196288 0.596782    0 0
  v 17.6993 -14.6076 45.7048    0.744941 -0.0599162 0.664435    0 0
  v 19.09 -15.3319 44.9715    0.314388 0.238189 0.918927    0 0
  v 18.9726 -13.6255 44.5    0.643968 0.242207 0.7257    0 0
  v 17.8843 -16.4964 45.4666    0.406319 -0.10282 0.907928    0 0
  v 20.4955 -12.5749 41.7899    0.840637 0.404238 0.360445    0 0
  v 19.3574 -11.8189 43.3654    0.818103 0.206283 0.5368    0 0
  v 20.2975 -13.5294 43.1994    0.587574 0.594301 0.549147    0 0
  v 19.9758 -10.1497 41.6364    0.89936 0.18076 0.398092    0 0
  v 15.522 -19.5273 46.3435    0.714312 -0.386837 0.583195    0 0
  v 16.8191 -18.0809 45.7059    0.692834 -0.309397 0.651349    0 0
  v 13.6686 -22.2942 46.1986    0.623508 -0.565644 0.539708    0 0
  v 15.477 -21.3906 44.8805    0.662628 -0.521711 0.537347    0 0
  v 16.8832 -22.2765 41.6302    0.70107 -0.620658 0.35112    0 0
  v 17.0548 -20.8647 43.3671    0.619606 -0.616359 0.485994    0 0
  v 15.1535 -23.1208 43.2857    0.645726 -0.628903 0.433034    0 0
  v 18.651 -19.8458 43.2565    0.313615 -0.812298 0.49175    0 0
  v 17.5033 -19.3573 44.5157    0.469917 -0.54729 0.692569    0 0
  v 18.4258 -20.6131 41.8127    0.539727 -0.789656 0.291786    0 0
  v 18.414 -17.9309 44.9944    0.208836 -0.364413 0.907519    0 0
  v 11.0772 -24.6295 46.1568    0.510151 -0.707431 0.489169    0 0
  v 13.1854 -23.9247 44.7655    0.570772 -0.659893 0.488631    0 0
  v 8.00871 -26.4077 46.1521    0.364606 -0.815886 0.448768    0 0
  v 10.1767 -26.0695 44.7367    0.443782 -0.778362 0.444084    0 0
  v 11.2226 -26.9128 41.5883    0.464521 -0.832283 0.30253    0 0
  v 12.3803 -25.4728 43.2361    0.525129 -0.757705 0.387457    0 0
  v 8.95926 -27.4005 43.2306    0.374594 -0.856916 0.354083    0 0
  v 14.493 -24.6761 41.5967    0.60112 -0.728903 0.327651    0 0
  v 5.98913 -26.4714 47.5221    0.282282 -0.856474 0.432169    0 0
  v 4.71504 -27.4784 46.1521    0.187736 -0.888505 0.418706    0 0
  v 6.76035 -27.5795 44.7367    0.278385 -0.868704 0.4097    0 0
  v 1.31948 -27.832 46.1521    1.86471e-009 -0.912789 0.408431    0 0
  v 3.15419 -28.3333 44.7367    0.0943073 -0.915961 0.390028    0 0
  v 2.88878 -27.1373 47.5221    0.0953876 -0.906667 0.41092    0 0
  v 3.38529 -29.3894 41.5883    0.097467 -0.959165 0.265523    0 0
  v 5.21416 -28.5892 43.2306    0.19121 -0.924428 0.329958    0 0
  v 1.31948 -28.9873 43.2306    -9.32779e-010 -0.946779 0.321885    0 0
  v 7.43173 -28.5582 41.5883    0.288333 -0.916044 0.278797    0 0
  v 13.4392 0.245803 39.7646    0.55342 0.796965 0.242021    0 0
  v 11.964 1.64865 37.7966    0.480642 0.861091 0.16585    0 0
  v 9.71553 2.32645 39.7645    0.38635 0.894949 0.223161    0 0
  v 16.5648 -2.39908 39.7659    0.694446 0.67216 0.256798    0 0
  v 15.504 -0.812733 37.7971    0.639104 0.748726 0.175942    0 0
  v 15.9258 -0.605006 33.5792    0.656036 0.754256 0.0267224    0 0
  v 14.0686 0.662903 35.7224    0.569824 0.815485 0.101415    0 0
  v 17.3154 -2.13163 35.7231    0.72556 0.680665 0.101285    0 0
  v 10.1729 2.83581 35.7223    0.392902 0.914708 0.0945326    0 0
  v 12.2979 1.93785 33.579    0.487461 0.872707 0.0276446    0 0
  v 18.8891 -5.37553 39.7684    0.82485 0.498825 0.266076    0 0
  v 18.3049 -3.74181 37.7989    0.782686 0.596501 0.177734    0 0
  v 20.3219 -8.62096 39.765    0.924798 0.262955 0.274962    0 0
  v 20.2269 -7.01954 37.793    0.906652 0.382426 0.178136    0 0
  v 20.7219 -7.1584 33.5769    0.926804 0.375258 0.0146816    0 0
  v 19.7099 -5.34277 35.7228    0.864789 0.493005 0.0953172    0 0
  v 21.1821 -8.91777 35.7074    0.961786 0.254515 0.100942    0 0
  v 18.7791 -3.68797 33.5798    0.807667 0.589334 0.0189824    0 0
  v 20.9066 -11.8463 39.8593    0.94816 0.20239 0.245012    0 0
  v 21.2137 -10.6567 37.7602    0.969779 0.152571 0.190395    0 0
  v 21.4147 -13.6203 40.5448    0.810739 0.585338 -0.00901788    0 0
  v 21.4782 -13.7852 38.7885    0.982193 0.187778 -0.00597647    0 0
  v 21.2853 -16.8896 37.6689    0.936966 -0.242937 -0.251151    0 0
  v 21.5157 -14.8911 36.9158    0.997356 -0.071214 0.0144653    0 0
  v 21.7679 -15.6102 38.5906    0.860857 0.143822 -0.488098    0 0
  v 21.7513 -14.8414 33.3757    0.993389 -0.11398 0.0136478    0 0
  v 21.7051 -12.8061 35.5845    0.995884 0.0126131 0.0897608    0 0
  v 21.3031 -16.7943 35.14    0.967002 -0.249257 0.052701    0 0
  v 21.71 -10.9226 33.5624    0.991299 0.129869 0.0214465    0 0
  v 21.0659 -18.2946 38.6134    0.710508 -0.538172 -0.453376    0 0
  v 19.9307 -19.7728 38.8041    0.769754 -0.637431 -0.0340536    0 0
  v 20.5444 -18.6645 36.9169    0.907146 -0.420813 0.00166434    0 0
  v 18.5123 -21.1881 39.8611    0.722111 -0.6623 0.199786    0 0
  v 19.7421 -20.0218 40.6018    0.500601 -0.86528 -0.0262684    0 0
  v 16.4535 -23.6242 39.7587    0.692607 -0.67747 0.247648    0 0
  v 18.2333 -22.2119 37.756    0.772929 -0.610505 0.172816    0 0
  v 18.7715 -22.1967 33.5611    0.808106 -0.588643 0.0215517    0 0
  v 19.7116 -20.5192 35.5827    0.865507 -0.494766 0.0781303    0 0
  v 17.3078 -23.753 35.7043    0.727555 -0.678481 0.101623    0 0
  v 20.7571 -18.6814 33.3753    0.92448 -0.381089 0.0103427    0 0
  v 13.4281 -26.1445 39.7639    0.550298 -0.799805 0.239757    0 0
  v 15.4897 -25.0859 37.7885    0.639821 -0.749007 0.172098    0 0
  v 9.71554 -28.2113 39.7645    0.38635 -0.894949 0.223161    0 0
  v 11.964 -27.5335 37.7966    0.480514 -0.861164 0.165842    0 0
  v 12.2979 -27.8227 33.5791    0.487507 -0.872681 0.027645    0 0
  v 14.0679 -26.5477 35.7205    0.570327 -0.815157 0.101228    0 0
  v 10.1729 -28.7207 35.7223    0.392902 -0.914708 0.0945329    0 0
  v 15.9243 -25.2798 33.5755    0.656481 -0.753853 0.0271633    0 0
  v 5.61152 -29.4962 39.7645    0.195873 -0.958211 0.208484    0 0
  v 7.90818 -29.2783 37.7966    0.294365 -0.943325 0.153256    0 0
  v 1.31948 -29.9308 39.7645    9.32882e-010 -0.97904 0.203669    0 0
  v 3.54939 -30.1664 37.7966    0.0994516 -0.984209 0.146432    0 0
  v 3.62343 -30.5284 33.5791    0.100364 -0.994647 0.024569    0 0
  v 5.85206 -30.0658 35.7223    0.198605 -0.976059 0.0886822    0 0
  v 1.31948 -30.5232 35.7223    0 -0.996227 0.0867864    0 0
  v 8.12307 -29.6138 33.579    0.29706 -0.954515 0.0256416    0 0
  v 14.1765 0.733325 31.4043    0.574876 0.817078 -0.0435976    0 0
  v 12.1539 1.81179 29.2297    0.485747 0.867988 -0.103184    0 0
  v 10.2517 2.92583 31.4043    0.394152 0.918185 -0.0397601    0 0
  v 17.4402 -2.1174 31.4045    0.736724 0.674264 -0.0510497    0 0
  v 15.7416 -0.7148 29.2297    0.655319 0.746874 -0.112854    0 0
  v 15.0487 -1.09542 25.0062    0.642704 0.730404 -0.231174    0 0
  v 13.767 0.450276 27.0865    0.568632 0.805558 -0.166531    0 0
  v 16.9475 -2.34194 27.0865    0.727893 0.66134 -0.18111    0 0
  v 9.95418 2.58582 27.0865    0.390563 0.90764 -0.153785    0 0
  v 11.6087 1.33453 25.0062    0.478244 0.851871 -0.213539    0 0
  v 19.8368 -5.43596 31.4044    0.873716 0.482644 -0.0606192    0 0
  v 18.5629 -3.80769 29.2297    0.806538 0.577867 -0.124764    0 0
  v 21.3002 -9.08106 31.4014    0.965699 0.25182 -0.0633379    0 0
  v 20.4806 -7.29601 29.2294    0.920435 0.36715 -0.134163    0 0
  v 19.6199 -7.46996 25.0062    0.896021 0.356354 -0.264873    0 0
  v 19.2872 -5.61168 27.0865    0.86026 0.470994 -0.195239    0 0
  v 20.7164 -9.19787 27.0865    0.947503 0.245634 -0.204701    0 0
  v 17.7663 -4.08558 25.0062    0.788147 0.562536 -0.249755    0 0
  v 21.7958 -12.9152 31.3768    0.997994 0.00554921 -0.0630704    0 0
  v 21.4509 -11.0274 29.228    0.982454 0.126021 -0.137485    0 0
  v 21.3244 -16.7692 31.2879    0.965348 -0.250091 -0.0745512    0 0
  v 21.4551 -14.8454 29.2093    0.982181 -0.123182 -0.141942    0 0
  v 20.5592 -14.7931 25.0062    0.954174 -0.121586 -0.273437    0 0
  v 21.1948 -12.9424 27.0865    0.978081 -8.92586e-007 -0.208227    0 0
  v 20.7164 -16.687 27.0865    0.947108 -0.245534 -0.206637    0 0
  v 20.5592 -11.0918 25.0062    0.954175 0.121586 -0.273437    0 0
  v 19.8371 -20.4443 31.3764    0.872344 -0.485159 -0.060306    0 0
  v 20.4841 -18.5843 29.2093    0.919433 -0.368313 -0.137797    0 0
  v 17.4387 -23.7674 31.4007    0.736993 -0.674009 -0.0505358    0 0
  v 18.5622 -22.0771 29.2279    0.806495 -0.578012 -0.124373    0 0
  v 17.7663 -21.7993 25.0062    0.788147 -0.562535 -0.249755    0 0
  v 19.2872 -20.2732 27.0865    0.860233 -0.470979 -0.195391    0 0
  v 16.9475 -23.5429 27.0865    0.727897 -0.661345 -0.181077    0 0
  v 19.6199 -18.4149 25.0062    0.896021 -0.356354 -0.264873    0 0
  v 14.1763 -26.6182 31.404    0.574934 -0.81704 -0.0435582    0 0
  v 15.7415 -25.17 29.2293    0.655348 -0.746857 -0.112794    0 0
  v 10.2517 -28.8107 31.4043    0.394152 -0.918185 -0.0397601    0 0
  v 12.1539 -27.6966 29.2297    0.48575 -0.867986 -0.103184    0 0
  v 11.6087 -27.2194 25.0062    0.478244 -0.851871 -0.213538    0 0
  v 13.767 -26.3351 27.0865    0.568633 -0.805559 -0.166529    0 0
  v 9.95418 -28.4707 27.0865    0.390563 -0.90764 -0.153785    0 0
  v 15.0487 -24.7894 25.0062    0.642704 -0.730404 -0.231174    0 0
  v 5.89352 -30.1665 31.4043    0.199146 -0.979257 -0.0373606    0 0
  v 8.03038 -29.4676 29.2297    0.296067 -0.950356 -0.0957476    0 0
  v 1.31948 -30.6279 31.4043    -1.58593e-008 -0.99933 -0.0365862    0 0
  v 3.59149 -30.3706 29.2297    0.100018 -0.990745 -0.0917647    0 0
  v 3.47054 -29.7734 25.0062    0.098792 -0.976699 -0.190521    0 0
  v 5.73695 -29.7863 27.0865    0.197596 -0.969551 -0.14466    0 0
  v 1.31948 -30.2325 27.0865    -1.20328e-007 -0.989909 -0.141703    0 0
  v 7.67944 -28.9139 25.0062    0.292599 -0.935384 -0.198601    0 0
  v 12.956 -0.10839 23.0204    0.554049 0.782382 -0.284445    0 0
  v 10.7388 0.572977 21.1642    0.460269 0.815407 -0.351089    0 0
  v 9.36476 1.91219 23.0204    0.38294 0.885291 -0.26385    0 0
  v 15.9741 -2.76579 23.0204    0.705169 0.639073 -0.30712    0 0
  v 13.9432 -1.70106 21.1642    0.612944 0.694219 -0.377305    0 0
  v 12.3326 -2.58347 17.9815    0.531325 0.598337 -0.599738    0 0
  v 11.7455 -0.942292 19.4729    0.513941 0.721805 -0.463533    0 0
  v 14.5211 -3.39845 19.4729    0.645342 0.582413 -0.494296    0 0
  v 8.48495 0.906689 19.4729    0.360294 0.82542 -0.434592    0 0
  v 9.47139 -0.536588 17.9815    0.407407 0.714952 -0.56821    0 0
  v 18.2069 -5.89491 23.0204    0.828899 0.45288 -0.328368    0 0
  v 16.4962 -4.52054 21.1642    0.745251 0.53021 -0.404324    0 0
  v 19.5768 -9.33907 23.0204    0.909351 0.235299 -0.343096    0 0
  v 18.2488 -7.73105 21.1642    0.840991 0.333637 -0.425935    0 0
  v 16.25 -8.11337 17.9806    0.703596 0.277375 -0.654229    0 0
  v 16.5941 -6.31793 19.4728    0.749107 0.407674 -0.52215    0 0
  v 17.8741 -9.55236 19.472    0.814338 0.209424 -0.54129    0 0
  v 14.6457 -5.15426 17.9815    0.633571 0.448265 -0.630591    0 0
  v 20.0357 -12.9424 23.0204    0.937473 -8.26445e-007 -0.348059    0 0
  v 19.1398 -11.1797 21.1638    0.891609 0.11362 -0.43832    0 0
  v 19.5768 -16.5458 23.0204    0.910421 -0.235576 -0.340057    0 0
  v 19.1517 -14.709 21.1703    0.895497 -0.110811 -0.431053    0 0
  v 17.1847 -14.6057 18.0421    0.753849 -0.0762918 -0.652603    0 0
  v 18.3133 -12.9503 19.477    0.83819 0.0075033 -0.545327    0 0
  v 17.9452 -16.3446 19.5107    0.826355 -0.213203 -0.521232    0 0
  v 17.0655 -11.3174 17.977    0.738447 0.0955651 -0.667505    0 0
  v 18.2069 -19.9899 23.0204    0.828997 -0.452932 -0.328051    0 0
  v 18.2604 -18.1549 21.1703    0.842957 -0.337532 -0.418922    0 0
  v 15.9741 -23.1191 23.0204    0.705149 -0.639056 -0.3072    0 0
  v 16.4958 -21.3635 21.1638    0.744854 -0.530396 -0.404812    0 0
  v 14.6413 -20.7225 17.977    0.631626 -0.449816 -0.631439    0 0
  v 16.6038 -19.5647 19.477    0.747134 -0.414852 -0.519316    0 0
  v 14.5202 -22.4848 19.472    0.64539 -0.581835 -0.494914    0 0
  v 16.3656 -17.7829 18.0421    0.709336 -0.300316 -0.637693    0 0
  v 12.956 -25.7765 23.0204    0.554048 -0.782379 -0.284454    0 0
  v 13.9431 -24.1836 21.1642    0.612965 -0.694127 -0.37744    0 0
  v 9.36476 -27.797 23.0204    0.382939 -0.885292 -0.26385    0 0
  v 10.7388 -26.4578 21.1642    0.460276 -0.815402 -0.351091    0 0
  v 9.47139 -25.3483 17.9815    0.407464 -0.714911 -0.568221    0 0
  v 11.7454 -24.9424 19.4728    0.514019 -0.721695 -0.463618    0 0
  v 8.48495 -26.7915 19.4729    0.360294 -0.82542 -0.434592    0 0
  v 12.3317 -23.2998 17.9806    0.531542 -0.597729 -0.600153    0 0
  v 5.42677 -29.033 23.0204    0.194295 -0.948871 -0.248782    0 0
  v 7.11946 -28.0305 21.1642    0.283908 -0.900888 -0.328325    0 0
  v 1.31948 -29.4492 23.0204    -2.24831e-007 -0.969809 -0.243867    0 0
  v 3.27754 -28.8204 21.1642    0.0958241 -0.943994 -0.315743    0 0
  v 2.99634 -27.4319 17.9815    0.0866685 -0.848314 -0.522352    0 0
  v 4.96376 -27.9087 19.4729    0.184202 -0.892111 -0.412562    0 0
  v 1.31948 -28.2799 19.4729    8.42257e-007 -0.914205 -0.405252    0 0
  v 6.30358 -26.7434 17.9815    0.256217 -0.802257 -0.539199    0 0
  v 10.0235 -2.12853 16.7254    0.416279 0.579024 -0.70103    0 0
  v 7.74183 -2.04193 15.6751    0.316509 0.541968 -0.77852    0 0
  v 7.2334 -0.523647 16.7254    0.301093 0.678367 -0.670195    0 0
  v 12.4541 -4.29842 16.7254    0.509563 0.456582 -0.7293    0 0
  v 10.1357 -3.78408 15.6738    0.396868 0.443723 -0.803496    0 0
  v 7.53031 -5.18492 14.0614    0.282235 0.316888 -0.905497    0 0
  v 7.81652 -3.62258 14.7938    0.305036 0.414855 -0.857233    0 0
  v 9.8529 -5.42777 14.8019    0.364023 0.326511 -0.872283    0 0
  v 5.66393 -2.28191 14.8144    0.238634 0.500586 -0.832146    0 0
  v 5.684 -3.76432 14.0746    0.241373 0.382263 -0.891972    0 0
  v 14.2996 -6.92034 16.7249    0.578731 0.312592 -0.753231    0 0
  v 12.1328 -6.01471 15.6761    0.463822 0.326123 -0.823719    0 0
  v 15.4476 -9.86233 16.7208    0.620087 0.157316 -0.768599    0 0
  v 13.5373 -8.62218 15.6743    0.508071 0.200249 -0.837714    0 0
  v 10.4374 -9.15232 14.0895    0.355534 0.147264 -0.922989    0 0
  v 11.4362 -7.66023 14.8068    0.408868 0.223508 -0.8848    0 0
  v 12.4269 -10.1281 14.8026    0.43665 0.117406 -0.891938    0 0
  v 9.23969 -7.00453 14.0852    0.32846 0.232758 -0.915389    0 0
  v 15.8827 -12.9819 16.7461    0.649859 0.0177807 -0.759847    0 0
  v 14.2468 -11.455 15.6645    0.528927 0.0937439 -0.843474    0 0
  v 15.8034 -16.0832 16.9143    0.670669 -0.1725 -0.72142    0 0
  v 14.864 -14.5719 15.8994    0.675462 -0.0148186 -0.737246    0 0
  v 13.7348 -14.9774 14.5402    0.905252 0.171926 -0.388536    0 0
  v 13.6205 -13.7603 14.8796    0.640297 0.257598 -0.723646    0 0
  v 14.1164 -15.9022 15.2962    0.785418 -0.202796 -0.584801    0 0
  v 11.2304 -12.9427 13.8045    0.332213 0.487978 -0.807163    0 0
  v 12.7205 -12.4563 14.687    0.462077 0.193831 -0.865399    0 0
  v 12.3975 -13.6314 13.8703    0.505757 0.676553 -0.535244    0 0
  v 11.0389 -11.3526 14.0829    0.365759 0.0975579 -0.925582    0 0
  v 14.3481 -18.9532 16.7461    0.586873 -0.337329 -0.736064    0 0
  v 14.1676 -17.2802 15.9004    0.621225 -0.318045 -0.716189    0 0
  v 12.4497 -21.5783 16.7208    0.510535 -0.45576 -0.729134    0 0
  v 12.0919 -19.9003 15.6639    0.456331 -0.353591 -0.816539    0 0
  v 9.04766 -19.1887 14.0769    0.308451 -0.283796 -0.90792    0 0
  v 11.1267 -18.6878 14.689    0.36847 -0.418989 -0.829866    0 0
  v 9.78969 -20.5514 14.7966    0.363981 -0.336424 -0.868526    0 0
  v 11.3529 -17.6653 13.8965    0.270396 -0.854379 -0.443759    0 0
  v 12.5864 -17.7726 14.8874    0.505114 -0.545662 -0.668665    0 0
  v 9.94182 -17.9573 13.816    0.166131 -0.643773 -0.746965    0 0
  v 13.2815 -16.7268 14.5507    0.74497 -0.574783 -0.338591    0 0
  v 10.023 -23.7555 16.7249    0.416633 -0.578833 -0.700977    0 0
  v 10.1276 -22.1068 15.6713    0.397712 -0.446155 -0.80173    0 0
  v 7.2334 -25.3612 16.7254    0.301093 -0.678367 -0.670194    0 0
  v 7.74183 -23.8429 15.6751    0.316363 -0.5421 -0.778487    0 0
  v 5.684 -22.1205 14.0746    0.240253 -0.383479 -0.891752    0 0
  v 7.8102 -22.2717 14.7932    0.303308 -0.418434 -0.856106    0 0
  v 5.66393 -23.6029 14.8144    0.238636 -0.500585 -0.832146    0 0
  v 7.4919 -20.7616 14.0597    0.277263 -0.325744 -0.90389    0 0
  v 4.30514 -26.3092 16.7254    0.157044 -0.748644 -0.644103    0 0
  v 5.20092 -25.0118 15.682    0.209077 -0.630534 -0.747472    0 0
  v 1.31948 -26.6167 16.7254    4.87652e-007 -0.771298 -0.636474    0 0
  v 2.61976 -25.5666 15.6837    0.0695043 -0.679755 -0.730139    0 0
  v 2.22749 -23.5768 14.1605    0.0488435 -0.524871 -0.849779    0 0
  v 3.51248 -24.395 14.838    0.127638 -0.581314 -0.803606    0 0
  v 1.31948 -24.6051 14.8315    -2.3321e-009 -0.599596 -0.800302    0 0
  v 3.9726 -23.1457 14.1433    0.177994 -0.4676 -0.865834    0 0
  v 5.28951 -5.25832 13.428    0.220506 0.289776 -0.931347    0 0
  v 3.47605 -5.35803 13.0141    0.168047 0.261989 -0.950327    0 0
  v 3.96546 -4.08131 13.5311    0.195401 0.352924 -0.915021    0 0
  v 7.01095 -6.65213 13.469    0.258849 0.234722 -0.936965    0 0
  v 4.89185 -6.6985 12.9571    0.191013 0.206154 -0.959695    0 0
  v 3.31048 -8.65267 12.4499    0.102098 0.084043 -0.991218    0 0
  v 3.09626 -7.34843 12.5668    0.117207 0.133907 -0.984038    0 0
  v 4.67622 -7.98165 12.6909    0.161199 0.128818 -0.978479    0 0
  v 1.31948 -7.12752 12.4454    3.6475e-006 0.145388 -0.989375    0 0
  v 2.43978 -6.37958 12.6404    0.0931434 0.177687 -0.979669    0 0
  v 1.80777 -8.20093 12.3487    0.0555759 0.0746759 -0.995658    0 0
  v 2.21354 -5.23178 12.8765    0.0817987 0.259244 -0.962342    0 0
  v 1.31948 -5.88927 12.681    -9.60456e-008 0.213704 -0.976898    0 0
  v 8.37658 -8.46004 13.4953    0.28713 0.157248 -0.944896    0 0
  v 6.35665 -8.05932 13.019    0.223792 0.148195 -0.963305    0 0
  v 9.20443 -10.5013 13.4941    0.304122 0.0825235 -0.949052    0 0
  v 7.35618 -9.83767 13.0328    0.238903 0.0976052 -0.966125    0 0
  v 4.81247 -10.905 12.481    0.130585 0.0463485 -0.990353    0 0
  v 5.50333 -9.51383 12.6801    0.169941 0.0854874 -0.981739    0 0
  v 6.3702 -11.0603 12.7193    0.192044 0.0492317 -0.980151    0 0
  v 4.0029 -9.36315 12.4713    0.115244 0.0702891 -0.990847    0 0
  v 9.57868 -12.4212 13.4478    0.268131 0.195184 -0.943403    0 0
  v 7.82584 -11.7738 13.0248    0.246134 0.0534792 -0.967759    0 0
  v 10.2139 -13.4689 13.078    0.0497196 0.720178 -0.692006    0 0
  v 8.7052 -13.4649 12.9897    0.0747494 0.303665 -0.949842    0 0
  v 7.54455 -15.101 12.7565    -0.0883178 0.0188641 -0.995914    0 0
  v 7.13704 -13.9635 12.7754    0.10608 0.0521259 -0.99299    0 0
  v 8.54486 -14.4528 12.6619    -0.284121 0.342459 -0.895543    0 0
  v 4.84994 -13.8394 12.4251    0.124748 -0.00532623 -0.992174    0 0
  v 6.22754 -12.8849 12.6533    0.170015 0.0126146 -0.985361    0 0
  v 5.84273 -14.7478 12.5926    0.143242 -0.0365667 -0.989012    0 0
  v 5.07058 -11.9869 12.4784    0.136233 0.0243842 -0.990377    0 0
  v 8.14638 -16.0022 12.6724    -0.375475 -0.206092 -0.903629    0 0
  v 7.83539 -16.8772 12.9975    -0.0233289 -0.348203 -0.937129    0 0
  v 6.63831 -15.9437 12.7764    0.0759884 -0.104887 -0.991577    0 0
  v 8.16899 -17.9554 13.4474    0.188697 -0.332082 -0.924183    0 0
  v 9.22411 -17.3027 13.1042    -0.164508 -0.750487 -0.640082    0 0
  v 6.92874 -19.3517 13.4644    0.252639 -0.239604 -0.937424    0 0
  v 6.25593 -17.9329 13.0089    0.207665 -0.172599 -0.962852    0 0
  v 3.97209 -16.5465 12.4673    0.111651 -0.0737969 -0.991004    0 0
  v 5.34641 -16.4162 12.6499    0.147062 -0.0897778 -0.985044    0 0
  v 4.64541 -17.9279 12.6868    0.159322 -0.129393 -0.97871    0 0
  v 4.57153 -14.965 12.4251    0.110279 -0.0536177 -0.992453    0 0
  v 5.28129 -20.6384 13.4276    0.217773 -0.292696 -0.931077    0 0
  v 4.87135 -19.2081 12.955    0.188404 -0.207111 -0.960005    0 0
  v 3.96546 -21.8035 13.5311    0.1954 -0.352923 -0.915021    0 0
  v 3.47605 -20.5268 13.0141    0.167887 -0.262279 -0.950276    0 0
  v 1.31948 -19.9956 12.681    9.32481e-010 -0.213704 -0.976899    0 0
  v 2.43978 -19.5053 12.6404    0.0929718 -0.177705 -0.979682    0 0
  v 2.21354 -20.6531 12.8765    0.0818007 -0.259239 -0.962343    0 0
  v 1.80777 -17.6839 12.3487    0.055422 -0.0747321 -0.995662    0 0
  v 3.09301 -18.539 12.5663    0.116426 -0.134304 -0.984077    0 0
  v 1.31948 -18.7573 12.4454    -3.68296e-006 -0.145383 -0.989375    0 0
  v 3.29996 -17.2406 12.4485    0.100849 -0.0845837 -0.9913    0 0
  v 2.75179 -22.5902 13.6493    0.105423 -0.438087 -0.89273    0 0
  v 2.74482 -21.5921 13.2249    0.126866 -0.342949 -0.930748    0 0
  v 1.31948 -22.6446 13.6169    -9.32094e-010 -0.45559 -0.89019    0 0
  v 1.97211 -21.8662 13.2609    0.0460693 -0.384168 -0.922113    0 0
  v 1.31948 -21.1036 12.9706    1.8646e-009 -0.307725 -0.951475    0 0
  v 33.4979 -19.0196 36.2378    0.949471 -0.270227 -0.159633    0 0
  v 33.0475 -19.1486 35.5245    0.609298 -0.452532 -0.651131    0 0
  v 33.0204 -18.351 35.276    0.654436 0.0648561 -0.753331    0 0
  v 33.4809 -18.3368 36.0258    0.957365 0.177199 -0.228152    0 0
  v 32.0362 -19.7612 35.6316    0.140397 -0.838753 -0.5261    0 0
  v 32.1706 -19.1683 35.082    0.235846 -0.495556 -0.835943    0 0
  v 32.7743 -19.7436 36.0291    0.418292 -0.837426 -0.35178    0 0
  v 31.2549 -18.3928 34.7416    -0.0812765 -0.0813838 -0.993363    0 0
  v 32.1435 -18.3708 34.8335    0.2753 -0.0278006 -0.960956    0 0
  v 31.2719 -19.0756 34.9536    -0.0969127 -0.47764 -0.873194    0 0
  v 32.7429 -17.645 35.38    0.532196 0.591374 -0.605842    0 0
  v 32.0048 -17.6625 34.9826    0.241072 0.519744 -0.819604    0 0
  v 19.439 -18.8592 44.2373    0.132388 -0.670869 0.729663    0 0
  v 20.645 -17.8349 44.8362    0.0354839 -0.397029 0.91712    0 0
  v 19.6704 -16.7338 45.1129    0.0843621 -0.00200002 0.996433    0 0
  v 19.9953 -19.8949 42.1159    0.238731 -0.960141 0.145384    0 0
  v 20.7217 -19.3987 43.3131    0.0939893 -0.889153 0.447854    0 0
  v 23.0841 -19.2761 43.2971    0.0350274 -0.907515 0.418556    0 0
  v 21.8423 -18.6845 44.2071    0.036732 -0.704423 0.708829    0 0
  v 22.0644 -19.5832 42.2966    0.0698887 -0.995474 0.0643952    0 0
  v 22.1127 -16.9008 44.9941    0.0682214 0.0382075 0.996938    0 0
  v 23.2313 -17.8854 44.7041    0.0859063 -0.405059 0.910246    0 0
  v 21.0854 -19.1023 39.8215    0.428642 -0.801514 -0.416944    0 0
  v 21.4046 -19.508 41.1013    0.196255 -0.947983 -0.250624    0 0
  v 22.0531 -17.0472 38.7523    0.503302 -0.14646 -0.851608    0 0
  v 22.3447 -18.1005 39.3323    0.236335 -0.558092 -0.795412    0 0
  v 23.9694 -18.1127 39.4415    -0.0877567 -0.529205 -0.843943    0 0
  v 22.759 -18.8662 40.1968    0.0754198 -0.809793 -0.581849    0 0
  v 23.4573 -17.1674 39.1123    0.0497898 -0.0680353 -0.99644    0 0
  v 23.3793 -19.367 41.1921    -0.0107414 -0.949845 -0.312538    0 0
  v 22.2098 -14.8624 39.7343    0.625274 0.594291 -0.505817    0 0
  v 22.8847 -16.0824 39.2563    0.298132 0.381591 -0.874932    0 0
  v 21.6044 -13.825 41.9881    0.492526 0.857784 0.147054    0 0
  v 22.7463 -14.4938 40.9114    0.351835 0.874675 -0.3334    0 0
  v 24.5264 -14.9017 40.8436    0.097037 0.91063 -0.401668    0 0
  v 23.6891 -15.3658 39.9942    0.150843 0.720413 -0.676943    0 0
  v 23.4285 -14.4492 41.9995    0.215688 0.976447 0.00539598    0 0
  v 24.4283 -16.3266 39.3021    -0.0407054 0.434612 -0.899698    0 0
  v 20.5478 -14.6704 44.1501    0.302029 0.594276 0.745395    0 0
  v 22.0607 -14.3931 43.1231    0.272986 0.857679 0.435735    0 0
  v 21.1823 -15.8254 44.7602    0.120117 0.419981 0.899549    0 0
  v 23.6901 -16.0992 44.5647    0.167518 0.465384 0.869112    0 0
  v 22.7724 -15.184 44.0045    0.167416 0.721674 0.671684    0 0
  v 24.2312 -14.8107 42.9486    0.189894 0.910332 0.367745    0 0
  v 24.3652 -18.7316 43.9637    0.0968837 -0.713011 0.694427    0 0
  v 25.7963 -18.0556 44.1735    0.241367 -0.406402 0.881238    0 0
  v 24.7311 -17.0847 44.6555    0.220156 0.0381056 0.97472    0 0
  v 24.2552 -19.5525 42.1558    -0.023366 -0.998734 0.0445475    0 0
  v 25.4168 -19.3611 42.8875    0.0551941 -0.911088 0.4085    0 0
  v 27.5752 -19.5546 42.0019    0.125234 -0.91157 0.391608    0 0
  v 26.7684 -18.9128 43.2484    0.214794 -0.712518 0.667969    0 0
  v 26.3304 -19.6879 41.5808    -0.0682999 -0.996194 0.0541439    0 0
  v 27.2187 -17.3335 43.8315    0.422244 0.0331072 0.905878    0 0
  v 28.1678 -18.3087 43.1265    0.432252 -0.402221 0.807079    0 0
  v 24.5473 -18.8921 40.091    -0.151813 -0.792727 -0.590369    0 0
  v 25.3158 -19.4418 40.8721    -0.157329 -0.939996 -0.302746    0 0
  v 24.9982 -17.32 38.9755    -0.219768 -0.0399037 -0.974736    0 0
  v 25.5438 -18.2572 39.135    -0.326406 -0.503687 -0.799849    0 0
  v 26.9685 -18.4877 38.4639    -0.533018 -0.485758 -0.69277    0 0
  v 26.2157 -19.0554 39.5918    -0.334416 -0.773785 -0.53798    0 0
  v 26.4081 -17.5427 38.4685    -0.459885 -0.0270344 -0.887567    0 0
  v 27.0955 -19.6262 40.1369    -0.258383 -0.931367 -0.256502    0 0
  v 25.325 -15.6341 39.7783    -0.0581912 0.733006 -0.677728    0 0
  v 25.911 -16.5492 38.9426    -0.25521 0.441371 -0.860267    0 0
  v 25.3959 -14.7741 41.6973    0.137761 0.989928 -0.0326121    0 0
  v 26.2338 -15.1716 40.3911    -0.0122321 0.911588 -0.410924    0 0
  v 27.7824 -15.4928 39.5167    -0.0610004 0.906973 -0.416748    0 0
  v 26.8146 -15.8971 39.1817    -0.21047 0.72709 -0.653485    0 0
  v 27.2088 -15.0558 40.9793    0.154918 0.986075 -0.0604749    0 0
  v 27.2432 -16.8343 38.2159    -0.449965 0.431632 -0.781809    0 0
  v 25.1429 -15.4736 43.651    0.243675 0.732239 0.635962    0 0
  v 26.3348 -15.091 42.4065    0.256031 0.90666 0.335284    0 0
  v 26.1635 -16.3475 43.9811    0.338675 0.451991 0.825229    0 0
  v 28.4426 -16.6553 42.8784    0.541487 0.437195 0.718089    0 0
  v 27.3673 -15.7546 42.8382    0.401202 0.711729 0.57661    0 0
  v 28.2621 -15.4212 41.3817    0.389145 0.883229 0.261672    0 0
  v 28.9213 -19.154 42.0052    0.362299 -0.711072 0.602592    0 0
  v 30.2215 -18.604 41.5381    0.598169 -0.39548 0.696986    0 0
  v 29.4423 -17.6559 42.4457    0.629893 0.038049 0.77575    0 0
  v 28.193 -19.8846 40.5457    -0.0642006 -0.99566 0.0673713    0 0
  v 29.458 -19.7667 40.6336    0.206777 -0.912282 0.353532    0 0
  v 31.0485 -19.9472 38.993    0.267697 -0.912521 0.309263    0 0
  v 30.7512 -19.3951 40.334    0.469618 -0.709987 0.524764    0 0
  v 29.8 -20.0684 39.1571    -0.0379688 -0.996812 0.070173    0 0
  v 31.3151 -18.0206 40.6029    0.763784 0.0596638 0.642709    0 0
  v 31.9164 -18.8893 39.6351    0.707181 -0.384421 0.593393    0 0
  v 27.6998 -19.2798 38.7141    -0.462111 -0.766487 -0.446039    0 0
  v 28.6516 -19.8292 39.0111    -0.297644 -0.933174 -0.201482    0 0
  v 27.6506 -17.8405 37.6187    -0.653293 -0.0335808 -0.75636    0 0
  v 28.2055 -18.7601 37.4819    -0.646665 -0.502472 -0.573887    0 0
  v 29.2895 -19.0182 36.3996    -0.65023 -0.556904 -0.516778    0 0
  v 28.9873 -19.5026 37.5811    -0.493014 -0.787819 -0.369158    0 0
  v 28.7281 -18.1783 36.5652    -0.73342 -0.0708668 -0.676071    0 0
  v 29.9977 -19.9988 37.6987    -0.283062 -0.943645 -0.171492    0 0
  v 28.1435 -16.2764 38.184    -0.316353 0.720834 -0.6167    0 0
  v 28.4071 -17.2247 37.1643    -0.572283 0.419531 -0.704617    0 0
  v 28.8437 -15.4796 39.7683    0.217171 0.968786 -0.119542    0 0
  v 29.1556 -15.9906 38.2171    -0.0838155 0.901401 -0.424795    0 0
  v 30.3157 -16.5471 36.7771    -0.120624 0.894718 -0.430035    0 0
  v 29.299 -16.7655 36.9286    -0.370028 0.718102 -0.589414    0 0
  v 30.2572 -16.0539 38.2002    0.214719 0.960215 -0.178556    0 0
  v 29.4167 -17.6375 36.0309    -0.614068 0.397106 -0.682075    0 0
  v 29.365 -16.1505 41.4751    0.564536 0.69434 0.446308    0 0
  v 29.962 -15.9282 39.8395    0.469749 0.870654 0.145937    0 0
  v 30.4231 -17.0686 41.2204    0.68946 0.449185 0.568223    0 0
  v 32.0436 -17.5086 39.2665    0.757464 0.482946 0.439331    0 0
  v 31.0629 -16.658 39.6816    0.628825 0.711603 0.313367    0 0
  v 31.3665 -16.4956 38.0713    0.464162 0.884127 0.0535915    0 0
  v 32.2428 -19.5903 38.4909    0.558819 -0.706585 0.434119    0 0
  v 33.1532 -19.0953 37.721    0.83137 -0.380915 0.404633    0 0
  v 32.7971 -18.3564 38.5893    0.856496 0.0858369 0.508967    0 0
  v 31.1625 -20.1948 37.6541    0.0132939 -0.99921 0.0374502    0 0
  v 32.2887 -20.0175 37.3471    0.37177 -0.913451 0.165516    0 0
  v 33.1439 -19.5893 36.7995    0.701435 -0.705454 0.101605    0 0
  v 32.1009 -20.0637 36.3864    0.175 -0.958474 -0.225173    0 0
  v 33.5382 -18.5925 36.8861    0.989076 0.040323 0.141785    0 0
  v 30.1187 -19.6745 36.4248    -0.439495 -0.821982 -0.362201    0 0
  v 31.1373 -20.055 36.4518    -0.173022 -0.95022 -0.259123    0 0
  v 29.6818 -18.48 35.559    -0.696468 -0.148083 -0.702142    0 0
  v 30.2799 -19.1896 35.4675    -0.490897 -0.61995 -0.612113    0 0
  v 31.1412 -19.6446 35.5127    -0.201383 -0.803868 -0.559679    0 0
  v 30.6243 -18.676 34.9298    -0.339157 -0.270188 -0.901094    0 0
  v 30.2706 -17.2302 35.722    -0.378716 0.69177 -0.614841    0 0
  v 30.3155 -17.9905 35.1072    -0.495216 0.287495 -0.819822    0 0
  v 31.3853 -16.6097 36.6234    0.188125 0.953202 -0.236676    0 0
  v 31.2305 -17.0537 35.5505    -0.0678178 0.830663 -0.55263    0 0
  v 31.1434 -17.696 34.9139    -0.154138 0.490365 -0.857778    0 0
  v 32.1236 -17.19 35.5057    0.304977 0.798629 -0.518825    0 0
  v 32.3946 -17.1459 37.7881    0.648156 0.735612 0.196895    0 0
  v 32.3819 -17.0162 36.4458    0.495683 0.862893 -0.0985599    0 0
  v 33.1888 -17.8962 37.3607    0.839759 0.482899 0.248222    0 0
  v 33.1461 -17.6408 36.2007    0.756627 0.644996 -0.107218    0 0
  v 13.8063 -16.9232 0.898848    0.565339 -0.373587 -0.735407    0 0
  v 13.3682 -16.9035 0.663963    0.275228 -0.323891 -0.905176    0 0
  v 13.4624 -16.5296 0.642664    0.330382 0.0714911 -0.941136    0 0
  v 13.8896 -16.5931 0.880056    0.629562 -0.005092 -0.776934    0 0
  v 12.7433 -17.1706 0.740102    -0.0837239 -0.557796 -0.825744    0 0
  v 12.8534 -16.8435 0.58523    -0.049075 -0.232562 -0.971343    0 0
  v 13.1979 -17.2235 0.80962    0.181239 -0.641935 -0.745032    0 0
  v 12.4457 -16.4256 0.659292    -0.31674 0.177856 -0.931688    0 0
  v 12.9475 -16.4697 0.563925    -0.00318447 0.134345 -0.990929    0 0
  v 12.3624 -16.7557 0.678077    -0.356594 -0.116492 -0.926968    0 0
  v 13.4626 -16.1752 0.749994    0.328401 0.446178 -0.832513    0 0
  v 13.008 -16.1224 0.680476    0.0448328 0.472249 -0.880324    0 0
  v 12.4636 -17.1414 13.5787    0.472116 -0.871884 -0.130094    0 0
  v 13.3346 -16.5629 12.9298    0.700027 -0.705397 0.111255    0 0
  v 13.657 -15.9014 13.8716    0.970441 -0.241037 -0.0120389    0 0
  v 10.5107 -17.4635 12.9434    -0.0676795 -0.969092 -0.237235    0 0
  v 11.7177 -17.351 12.5153    0.185753 -0.982588 -0.00414686    0 0
  v 12.1949 -17.4086 10.6493    0.17269 -0.980766 0.0909751    0 0
  v 12.8282 -17.0626 11.8303    0.416318 -0.900665 0.124427    0 0
  v 11.0738 -17.4083 11.4348    -0.125053 -0.992147 -0.00254021    0 0
  v 13.9168 -16.013 12.016    0.954387 -0.223002 0.198534    0 0
  v 13.7434 -16.6646 10.9239    0.684714 -0.709105 0.168335    0 0
  v 9.01095 -16.6668 12.4514    -0.537167 -0.612865 -0.579524    0 0
  v 10.012 -17.1401 12.0453    -0.418915 -0.882392 -0.21423    0 0
  v 8.67239 -15.3077 12.2647    -0.676397 0.157791 -0.719436    0 0
  v 9.08888 -16.0538 11.7651    -0.836556 -0.284289 -0.468352    0 0
  v 9.67375 -16.1968 10.1495    -0.933331 -0.2887 -0.213413    0 0
  v 9.74108 -16.7045 11.1294    -0.722054 -0.657563 -0.215056    0 0
  v 9.38896 -15.4878 10.9881    -0.910454 0.21211 -0.355082    0 0
  v 10.567 -17.2214 10.3395    -0.461991 -0.885272 -0.0534498    0 0
  v 9.67541 -14.1015 12.4122    -0.311162 0.739808 -0.596542    0 0
  v 9.41753 -14.786 11.7317    -0.650628 0.593339 -0.473953    0 0
  v 11.4879 -13.699 12.8858    0.196244 0.92244 -0.332554    0 0
  v 10.8329 -13.9745 11.9618    -0.152346 0.94401 -0.292635    0 0
  v 11.3345 -14.2415 10.2001    -0.196728 0.967126 -0.161139    0 0
  v 10.331 -14.423 11.0437    -0.455533 0.847039 -0.273887    0 0
  v 11.939 -14.0622 11.309    0.137602 0.984132 -0.112025    0 0
  v 9.98076 -15.0048 10.0937    -0.729294 0.636606 -0.250726    0 0
  v 13.1609 -14.4561 13.5394    0.744451 0.633586 -0.210622    0 0
  v 12.5442 -14.1655 12.4318    0.460561 0.881978 -0.09999    0 0
  v 13.6688 -15.2751 12.8964    0.932258 0.354435 0.0726058    0 0
  v 14.0504 -15.4727 10.8682    0.916988 0.380669 0.119269    0 0
  v 13.4182 -14.7812 11.7445    0.694171 0.718153 0.0488142    0 0
  v 12.9624 -14.4286 10.5099    0.439638 0.89793 -0.0209653    0 0
  v 13.2272 -17.192 9.70046    0.419468 -0.900513 0.114554    0 0
  v 14.0318 -16.8258 8.63072    0.693701 -0.711152 0.114202    0 0
  v 14.2827 -16.1841 9.82273    0.965298 -0.224679 0.133112    0 0
  v 11.5195 -17.5241 9.41283    -0.12968 -0.990884 0.0364953    0 0
  v 12.5349 -17.5402 8.41178    0.176348 -0.981193 0.0784975    0 0
  v 12.7644 -17.6705 6.09598    0.178457 -0.981691 0.0666026    0 0
  v 13.4698 -17.3395 7.36722    0.423701 -0.901291 0.0902864    0 0
  v 11.8286 -17.6577 7.11336    -0.129108 -0.990826 0.0399271    0 0
  v 14.483 -16.3738 7.47173    0.970458 -0.228261 0.0781514    0 0
  v 14.1925 -16.9889 6.30251    0.697175 -0.711675 0.0864059    0 0
  v 10.2189 -16.8481 9.19518    -0.746523 -0.658622 -0.094449    0 0
  v 10.9589 -17.3605 8.16497    -0.465678 -0.884855 -0.0132688    0 0
  v 9.87057 -15.6797 9.08165    -0.952273 0.22312 -0.20831    0 0
  v 10.0916 -16.3765 8.01371    -0.948654 -0.287644 -0.131592    0 0
  v 10.4302 -16.5599 5.72793    -0.950533 -0.287565 -0.117449    0 0
  v 10.5769 -17.0098 6.92541    -0.750045 -0.658576 -0.0609187    0 0
  v 10.24 -15.8902 6.82375    -0.960258 0.226151 -0.163584    0 0
  v 11.2595 -17.4989 5.86614    -0.465737 -0.884869 -0.00978505    0 0
  v 10.7816 -14.6578 9.08035    -0.478762 0.858679 -0.182912    0 0
  v 10.3851 -15.2323 7.95039    -0.742707 0.643925 -0.183704    0 0
  v 12.3447 -14.3117 9.24441    0.127314 0.987136 -0.096714    0 0
  v 11.6927 -14.4999 8.00666    -0.202988 0.96916 -0.139728    0 0
  v 11.9587 -14.7701 5.71234    -0.203092 0.968958 -0.140972    0 0
  v 11.1147 -14.9115 6.80718    -0.482544 0.861178 -0.159761    0 0
  v 12.6174 -14.5803 6.93995    0.126705 0.986443 -0.104285    0 0
  v 10.7099 -15.4683 5.66641    -0.744265 0.645155 -0.172756    0 0
  v 13.7898 -15.0017 9.58564    0.694384 0.719466 0.0141087    0 0
  v 13.2687 -14.6796 8.25347    0.441092 0.895858 -0.0536407    0 0
  v 14.3253 -15.6816 8.5674    0.925907 0.375007 0.0454553    0 0
  v 14.4722 -15.8973 6.24099    0.928958 0.370048 0.0100353    0 0
  v 14.0077 -15.2412 7.24898    0.698443 0.715238 -0.0247538    0 0
  v 13.4636 -14.9417 5.94217    0.443613 0.893275 -0.0725728    0 0
  v 13.6281 -17.4686 5.1286    0.426854 -0.901533 0.0709575    0 0
  v 14.2818 -17.1191 4.20634    0.700929 -0.711356 0.0516925    0 0
  v 14.5873 -16.5533 5.23011    0.9719 -0.230382 0.0483186    0 0
  v 12.0737 -17.7703 4.88555    -0.126998 -0.991589 0.0249524    0 0
  v 12.9476 -17.7569 4.00907    0.183413 -0.98237 0.0361855    0 0
  v 13.0995 -17.7328 2.36295    0.198569 -0.978202 -0.0607604    0 0
  v 13.7268 -17.5307 3.22996    0.434825 -0.900351 0.0171715    0 0
  v 12.3097 -17.8061 3.004    -0.117744 -0.992324 -0.0378171    0 0
  v 14.6005 -16.6952 3.32672    0.971968 -0.234405 -0.0182159    0 0
  v 14.2678 -17.1726 2.54382    0.70712 -0.705434 -0.0484174    0 0
  v 10.8868 -17.1559 4.70992    -0.748158 -0.659299 -0.0747331    0 0
  v 11.5402 -17.5962 3.79411    -0.460828 -0.886197 -0.0478824    0 0
  v 10.5667 -16.0946 4.61605    -0.958144 0.224646 -0.177469    0 0
  v 10.7632 -16.7174 3.66893    -0.942648 -0.290048 -0.165189    0 0
  v 11.18 -16.819 2.07211    -0.895082 -0.291535 -0.337395    0 0
  v 11.2253 -17.2448 2.84787    -0.734071 -0.65973 -0.160921    0 0
  v 10.9317 -16.2758 2.76632    -0.937922 0.214185 -0.272812    0 0
  v 11.8644 -17.5914 2.17427    -0.438342 -0.879984 -0.182986    0 0
  v 11.396 -15.1674 4.59781    -0.481014 0.859533 -0.172711    0 0
  v 11.0245 -15.6965 3.61134    -0.738367 0.639284 -0.214779    0 0
  v 12.8206 -14.8539 4.72113    0.129111 0.984252 -0.120739    0 0
  v 12.1934 -15.0439 3.65015    -0.199102 0.964331 -0.174425    0 0
  v 12.4364 -15.3512 2.04772    -0.184309 0.939668 -0.288191    0 0
  v 11.6893 -15.4302 2.74546    -0.471609 0.847207 -0.244593    0 0
  v 12.9902 -15.1447 2.8538    0.136918 0.974437 -0.178117    0 0
  v 11.4087 -15.923 2.02149    -0.705617 0.607182 -0.365286    0 0
  v 14.1374 -15.4802 5.01649    0.701678 0.710871 -0.0480804    0 0
  v 13.6008 -15.2046 3.86513    0.448411 0.887777 -0.103828    0 0
  v 14.5431 -16.0982 4.14875    0.931226 0.363379 -0.0278076    0 0
  v 14.4965 -16.2766 2.49321    0.930435 0.341644 -0.132552    0 0
  v 14.1907 -15.7161 3.12755    0.707904 0.698597 -0.104088    0 0
  v 13.6715 -15.4927 2.23641    0.460335 0.865545 -0.19729    0 0
  v 13.7429 -17.4648 1.86396    0.452304 -0.880713 -0.140595    0 0
  v 14.1078 -17.1115 1.46896    0.689524 -0.651868 -0.315633    0 0
  v 14.4625 -16.773 1.95216    0.949448 -0.240532 -0.201727    0 0
  v 12.5734 -17.6928 1.66881    -0.0868845 -0.971043 -0.222546    0 0
  v 13.216 -17.5424 1.32004    0.232528 -0.919878 -0.315842    0 0
  v 13.6414 -17.2528 1.06574    0.445173 -0.73342 -0.513728    0 0
  v 12.8335 -17.4255 0.965041    -0.00201206 -0.79041 -0.612575    0 0
  v 14.1453 -16.7808 1.16404    0.774274 -0.224761 -0.591593    0 0
  v 11.6737 -17.2272 1.54781    -0.661812 -0.628854 -0.408103    0 0
  v 12.2759 -17.434 1.17635    -0.352997 -0.795906 -0.491861    0 0
  v 11.4278 -16.4245 1.48847    -0.830405 0.17432 -0.529189    0 0
  v 11.7452 -16.8393 1.10788    -0.70496 -0.260991 -0.659481    0 0
  v 12.2306 -17.0896 0.850079    -0.427066 -0.47594 -0.768828    0 0
  v 12.0212 -16.5353 0.839336    -0.533504 0.0852624 -0.841489    0 0
  v 12.0562 -15.7258 1.46287    -0.430137 0.781065 -0.452681    0 0
  v 11.9184 -16.1569 1.0692    -0.573534 0.48224 -0.662196    0 0
  v 13.1343 -15.4909 1.54423    0.15733 0.925744 -0.343867    0 0
  v 12.7113 -15.7194 1.07917    -0.137787 0.817993 -0.558481    0 0
  v 12.4898 -16.0655 0.791907    -0.285014 0.543413 -0.789601    0 0
  v 13.2241 -15.8837 0.877502    0.186716 0.683628 -0.705542    0 0
  v 14.1253 -15.9634 1.77903    0.713872 0.648856 -0.263387    0 0
  v 13.6515 -15.8278 1.22286    0.472672 0.76084 -0.444639    0 0
  v 14.281 -16.4292 1.43029    0.876482 0.26086 -0.404637    0 0
  v 13.9006 -16.2287 1.00757    0.639828 0.445523 -0.626202    0 0
  v 19.0158 -42.7089 80.7333    0.2017 -0.968088 0.148738    0 0
  v 21.3436 -42.5271 77.13    0.224542 -0.973984 0.0305943    0 0
  v 23.0794 -41.8766 79.6659    0.303814 -0.944913 0.121805    0 0
  v 22.7203 -41.3682 82.7372    0.298919 -0.916418 0.266132    0 0
  v 23.6349 -41.5027 71.4094    0.316596 -0.930634 -0.18354    0 0
  v 23.5233 -41.923 74.5852    0.306997 -0.950447 -0.0490191    0 0
  v 19.4594 -42.8545 73.492    0.20789 -0.975212 -0.0757881    0 0
  v 24.8058 -41.3702 75.0881    0.563006 -0.820479 0.0991923    0 0
  v 23.8023 -41.8148 77.1098    0.412019 -0.910085 0.0445561    0 0
  v 25.7025 -40.9984 73.1093    0.432191 -0.901617 -0.017235    0 0
  v 24.9546 -40.9207 81.1684    0.436089 -0.89132 0.123998    0 0
  v 24.4775 -41.3221 79.1041    0.557899 -0.829583 0.0232563    0 0
  v 29.8855 -38.1834 69.743    0.457931 -0.813238 -0.359086    0 0
  v 27.3706 -40.0004 71.3086    0.405533 -0.889647 -0.209933    0 0
  v 35.6447 -34.8439 71.617    0.671707 -0.711272 -0.207126    0 0
  v 32.7829 -37.0356 71.4076    0.546307 -0.807966 -0.220769    0 0
  v 32.129 -37.5358 72.6285    0.451039 -0.881276 0.141128    0 0
  v 30.1438 -38.6736 71.7451    0.478786 -0.875919 -0.0594153    0 0
  v 34.2555 -36.3136 73.3001    0.545957 -0.837781 -0.0073809    0 0
  v 27.8663 -39.8557 72.4978    0.496496 -0.851778 0.167232    0 0
  v 36.8791 -33.7921 77.2512    0.758654 -0.642211 0.109586    0 0
  v 35.8779 -35.0665 74.7693    0.683541 -0.729891 -0.00552751    0 0
  v 34.1382 -34.7915 82.8028    0.642013 -0.680222 0.353719    0 0
  v 35.1645 -35.0183 79.8004    0.666945 -0.717195 0.202027    0 0
  v 34.107 -35.8565 79.3244    0.423281 -0.905173 0.0386628    0 0
  v 35.2494 -35.4006 77.3272    0.569398 -0.817033 0.0907914    0 0
  v 33.1907 -36.198 81.2963    0.541524 -0.826032 0.156279    0 0
  v 34.6252 -35.9361 75.3591    0.429409 -0.897686 0.0988351    0 0
  v 28.279 -38.1236 84.5388    0.453875 -0.786735 0.418385    0 0
  v 31.3075 -36.939 83.0605    0.536069 -0.776942 0.330138    0 0
  v 26.1647 -39.9054 83.0109    0.408451 -0.864495 0.292945    0 0
  v 26.9738 -39.7224 81.8348    0.522933 -0.852048 -0.0235536    0 0
  v 28.9079 -38.5418 82.6919    0.490397 -0.854861 0.16948    0 0
  v 31.0464 -37.371 81.9147    0.472437 -0.8808 -0.0315564    0 0
  v 26.047 -33.24 78.072    0.818086 -0.532596 -0.216971    0 0
  v 27.2381 -31.7443 76.753    0.666998 -0.741271 0.0750391    0 0
  v 28.6573 -30.8345 78.3169    0.476872 -0.847 -0.234915    0 0
  v 27.2484 -32.4698 79.3959    0.648704 -0.584358 -0.487554    0 0
  v 27.7162 -32.5677 74.2176    0.567881 -0.539009 0.622077    0 0
  v 28.9529 -30.8975 75.2922    0.435513 -0.824301 0.36174    0 0
  v 26.2647 -33.2846 75.4542    0.775553 -0.51232 0.368845    0 0
  v 31.6541 -30.294 75.6427    -0.340408 -0.833803 0.43462    0 0
  v 30.372 -29.9876 76.8561    0.196018 -0.979649 0.0431963    0 0
  v 30.4528 -31.0642 74.3188    -0.0279994 -0.699523 0.714061    0 0
  v 29.9109 -30.9469 79.4723    0.0638688 -0.750336 -0.657964    0 0
  v 31.3625 -30.2301 78.2358    -0.275782 -0.851585 -0.445812    0 0
  v 24.5965 -41.2887 77.072    0.797256 -0.599566 0.0700289    0 0
  v 24.925 -40.7429 78.8368    0.934212 -0.286459 -0.21258    0 0
  v 25.6072 -40.5159 80.5306    0.695442 -0.678171 -0.237582    0 0
  v 26.1639 -40.6166 73.6897    0.660439 -0.630153 0.408322    0 0
  v 25.1876 -40.7949 75.2943    0.898334 -0.240603 0.367569    0 0
  v 25.1971 -39.3397 75.3282    0.905611 0.0319997 0.4229    0 0
  v 24.8017 -40.3751 77.0305    0.996758 -0.0342755 0.0727987    0 0
  v 26.2169 -39.767 73.9425    0.664372 -0.0503575 0.745704    0 0
  v 25.7332 -39.6678 80.1957    0.768656 -0.119907 -0.628323    0 0
  v 24.955 -39.2914 78.6668    0.958471 -0.00216016 -0.285181    0 0
  v 29.8998 -38.6664 72.5792    0.396613 -0.762764 0.510773    0 0
  v 27.857 -39.4757 73.0297    0.431969 -0.350914 0.83082    0 0
  v 33.3853 -36.67 73.9412    0.206409 -0.915728 0.344729    0 0
  v 31.5985 -37.4449 73.1753    -0.0102602 -0.563685 0.825926    0 0
  v 31.2202 -36.1967 73.3369    -0.341488 -0.0685094 0.937386    0 0
  v 29.6156 -37.997 72.9406    0.0411363 -0.152341 0.987472    0 0
  v 32.7935 -36.1799 74.1972    -0.596757 -0.344634 0.724644    0 0
  v 27.7032 -38.1019 73.1962    0.286266 0.00255372 0.958147    0 0
  v 34.2638 -35.8703 77.3583    0.105301 -0.993766 0.0366129    0 0
  v 33.8056 -36.0307 75.5962    -0.448785 -0.836859 0.313462    0 0
  v 32.5643 -36.5156 80.6991    0.214674 -0.93271 -0.289772    0 0
  v 33.3748 -35.9401 79.0818    -0.417055 -0.830657 -0.368881    0 0
  v 32.8898 -34.7773 78.903    -0.856676 -0.208603 -0.471795    0 0
  v 33.6017 -35.4424 77.3202    -0.883681 -0.45856 -0.0939663    0 0
  v 32.0632 -36.0203 80.3658    -0.48685 -0.384223 -0.784442    0 0
  v 33.2948 -34.8669 75.6196    -0.940412 -0.18032 0.288287    0 0
  v 28.9605 -38.4926 81.8511    0.465274 -0.788697 -0.401842    0 0
  v 30.7053 -37.2593 81.3464    0.0717033 -0.601663 -0.795525    0 0
  v 27.1321 -39.3287 81.2576    0.547342 -0.430343 -0.717789    0 0
  v 27.0296 -37.9616 80.9495    0.417182 -0.0856711 -0.904776    0 0
  v 28.7879 -37.8205 81.41    0.16148 -0.237089 -0.957973    0 0
  v 30.3837 -36.0152 81.035    -0.225891 -0.156176 -0.961552    0 0
  v 24.758 -38.1237 76.9203    0.997326 -0.0126574 0.071974    0 0
  v 25.0053 -36.3584 78.4372    0.954938 -0.154481 -0.253436    0 0
  v 25.6546 -37.4445 79.9707    0.757822 -0.0685328 -0.648852    0 0
  v 26.118 -37.5379 73.9441    0.650978 -0.000288313 0.759097    0 0
  v 25.2367 -36.4042 75.2749    0.908605 -0.125424 0.398379    0 0
  v 25.2011 -34.8236 76.7831    0.947284 -0.310977 0.0771107    0 0
  v 26.4009 -34.5113 74.2283    0.699992 -0.326254 0.635272    0 0
  v 25.9835 -34.4265 79.4234    0.782978 -0.372821 -0.497945    0 0
  v 29.388 -35.837 72.9783    -0.0294148 -0.0223962 0.999316    0 0
  v 27.6112 -35.2315 73.2524    0.34607 -0.1248 0.929871    0 0
  v 32.4452 -34.0907 74.1892    -0.7159 -0.0941541 0.691825    0 0
  v 30.9374 -33.4287 73.3846    -0.292373 -0.167901 0.94145    0 0
  v 29.2078 -32.8448 73.3699    0.145506 -0.344861 0.927307    0 0
  v 31.8408 -31.5339 74.4337    -0.491024 -0.494837 0.71696    0 0
  v 33.2203 -33.3803 77.1988    -0.982169 -0.148627 -0.115126    0 0
  v 32.9026 -32.1688 75.5499    -0.916516 -0.258621 0.305145    0 0
  v 31.7387 -33.9347 80.1342    -0.596066 -0.159211 -0.786993    0 0
  v 32.5208 -32.0839 78.6619    -0.832592 -0.281578 -0.476974    0 0
  v 32.5239 -30.7189 77.0242    -0.822204 -0.563538 -0.0800374    0 0
  v 31.2485 -31.4035 79.5703    -0.38346 -0.538166 -0.750557    0 0
  v 28.5903 -35.667 81.1408    0.0948342 -0.119614 -0.988281    0 0
  v 30.1463 -33.2566 80.6844    -0.173842 -0.25504 -0.951175    0 0
  v 26.9705 -35.0984 80.6025    0.474903 -0.212236 -0.854063    0 0
  v 28.5171 -32.6976 80.4374    0.26633 -0.429916 -0.862694    0 0
  v 15.6119 -43.355 70.269    0.196381 -0.973806 -0.114618    0 0
  v 10.461 -43.8743 68.1161    0.120397 -0.978432 -0.167852    0 0
  v 13.0753 -43.0369 65.9626    0.181038 -0.949545 -0.256103    0 0
  v 17.2555 -42.2254 66.7021    0.278018 -0.905038 -0.321888    0 0
  v 1.31948 -44.4172 68.0407    -1.86483e-009 -0.983151 -0.182793    0 0
  v 5.73617 -43.8507 66.07    0.0528389 -0.967232 -0.248335    0 0
  v 6.18163 -44.6367 70.6896    0.0670629 -0.992197 -0.105113    0 0
  v 5.19324 -43.0074 63.4186    0.0463793 -0.924392 -0.378615    0 0
  v 9.15865 -43.2049 64.7202    0.0909424 -0.947438 -0.306743    0 0
  v 1.31948 -43.4618 64.3388    0 -0.946914 -0.321488    0 0
  v 13.4855 -42.269 63.9994    0.260861 -0.866981 -0.424612    0 0
  v 11.2045 -42.6364 63.7889    0.121886 -0.912928 -0.389495    0 0
  v 3.3996 -27.4165 107.149    0.0318296 -0.536457 0.843327    0 0
  v 4.62465 -24.7435 108.559    0.0829158 -0.420218 0.903627    0 0
  v 2.84261 -22.5279 109.536    0.0254151 -0.337197 0.941091    0 0
  v 1.31948 -24.7036 108.631    2.37925e-007 -0.425379 0.905015    0 0
  v 7.31184 -23.246 108.742    0.16928 -0.34706 0.922439    0 0
  v 4.62465 -22.0428 109.583    0.108164 -0.301605 0.947278    0 0
  v 7.31184 -26.6653 107.171    0.160063 -0.492687 0.855359    0 0
  v 1.31948 -20.3832 110.172    -2.1694e-006 -0.243938 0.969791    0 0
  v 3.3996 -19.4999 110.313    0.0653267 -0.201927 0.977219    0 0
  v 6.24578 -20.1173 109.874    0.135532 -0.239171 0.961472    0 0
  v 4.21281 -17.7749 110.568    0.0822182 -0.145395 0.985951    0 0
  v 1.31948 -17.8928 110.662    -3.72819e-009 -0.158945 0.987287    0 0
  v 9.88164 -21.5342 108.848    0.194038 -0.301451 0.933529    0 0
  v 12.207 -19.7081 108.849    0.237015 -0.238523 0.94177    0 0
  v 7.87831 -18.6369 109.966    0.154997 -0.192841 0.968911    0 0
  v 1.31948 -16.5798 110.816    0 -0.0608015 0.99815    0 0
  v 4.98121 -16.6325 110.626    0.0931331 -0.0821109 0.992262    0 0
  v 9.26517 -17.1724 109.976    0.175967 -0.137125 0.974799    0 0
  v 5.56846 -15.4718 110.646    0.0939665 -0.0486175 0.994388    0 0
  v 1.31948 -15.6105 110.846    9.51141e-007 -0.0215462 0.999768    0 0
  v 14.0015 -17.6012 108.819    0.267321 -0.17901 0.946834    0 0
  v 14.98 -15.3361 108.883    0.2815 -0.0879694 0.95552    0 0
  v 10.2095 -15.5482 109.992    0.182824 -0.0892832 0.979083    0 0
  v 1.31948 -14.5763 110.861    9.32331e-010 -0.00908944 0.999959    0 0
  v 5.93419 -14.2313 110.654    0.0917557 -0.022006 0.995538    0 0
  v 10.6945 -13.8355 109.996    0.189284 -0.0212619 0.981692    0 0
  v 6.05712 -12.9424 110.657    0.0926251 7.55034e-007 0.995701    0 0
  v 1.31948 -13.4937 110.867    8.08263e-007 -0.00269625 0.999996    0 0
  v 15.4193 -13.0214 108.824    0.296055 0.00524603 0.955157    0 0
  v 15.0036 -10.6405 108.862    0.287995 0.077888 0.954459    0 0
  v 10.7015 -12.0831 109.99    0.191091 0.0236779 0.981287    0 0
  v 1.31948 -12.3911 110.867    8.0733e-007 0.00269625 0.999996    0 0
  v 5.93419 -11.6535 110.654    0.0923075 0.0221138 0.995485    0 0
  v 10.1982 -10.3507 109.998    0.183733 0.0799405 0.97972    0 0
  v 5.56845 -10.4131 110.646    0.0927043 0.0481163 0.99453    0 0
  v 1.31948 -11.3086 110.861    0 0.00908944 0.999959    0 0
  v 13.8938 -8.31337 108.884    0.265324 0.166182 0.94973    0 0
  v 12.1611 -6.18424 108.877    0.230637 0.243089 0.942186    0 0
  v 9.24223 -8.71614 109.99    0.171718 0.137497 0.975504    0 0
  v 1.31948 -10.2743 110.846    9.60466e-007 0.0215462 0.999768    0 0
  v 4.98121 -9.25237 110.626    0.0925654 0.0817602 0.992344    0 0
  v 7.87372 -7.24866 109.969    0.153336 0.19402 0.96894    0 0
  v 4.21281 -8.10999 110.568    0.0821522 0.145357 0.985963    0 0
  v 1.31948 -9.30502 110.816    -9.32849e-010 0.0608015 0.99815    0 0
  v 9.87705 -4.35134 108.851    0.19245 0.30264 0.933473    0 0
  v 7.31184 -2.63884 108.742    0.16928 0.34706 0.922439    0 0
  v 6.24578 -5.76752 109.874    0.1354 0.239333 0.96145    0 0
  v 1.31948 -7.99207 110.662    1.39807e-008 0.158945 0.987287    0 0
  v 3.3996 -6.38497 110.313    0.0653254 0.20193 0.977219    0 0
  v 4.62464 -3.84203 109.583    0.108163 0.301604 0.947278    0 0
  v 2.84261 -3.35698 109.536    0.0254158 0.337195 0.941092    0 0
  v 1.31948 -5.50169 110.172    -5.82624e-011 0.243939 0.969791    0 0
  v 4.62464 -1.14139 108.559    0.0829161 0.420218 0.903627    0 0
  v 1.31948 -1.18124 108.631    -8.92673e-008 0.425379 0.905016    0 0
  v 4.98122 -37.8261 97.0649    0.065953 -0.791246 0.607931    0 0
  v 7.8739 -35.0283 99.9755    0.123864 -0.733392 0.668427    0 0
  v 4.21282 -32.8367 102.712    0.0563134 -0.691601 0.720081    0 0
  v 1.31948 -35.575 99.9755    -4.3264e-007 -0.746931 0.664902    0 0
  v 9.87722 -31.8696 102.715    0.174924 -0.660376 0.730278    0 0
  v 12.1628 -36.6149 97.0649    0.197039 -0.761864 0.617041    0 0
  v 6.24578 -29.8472 105.14    0.107917 -0.618572 0.778281    0 0
  v 1.31948 -30.1957 105.155    1.1989e-006 -0.625795 0.779988    0 0
  v 5.99298 -43.9929 84.5127    0.0736283 -0.971158 0.226783    0 0
  v 10.2722 -42.4735 87.8791    0.140941 -0.924773 0.353455    0 0
  v 5.57433 -41.6257 91.0636    0.0732343 -0.890469 0.449113    0 0
  v 1.31948 -43.1838 87.8801    -9.33715e-010 -0.939651 0.342134    0 0
  v 13.942 -40.2526 91.0627    0.214057 -0.853942 0.474303    0 0
  v 15.2199 -42.7057 84.506    0.184956 -0.948766 0.256191    0 0
  v 9.2431 -39.4008 94.1098    0.139612 -0.828476 0.542343    0 0
  v 1.31948 -40.0607 94.1098    -4.03028e-007 -0.843717 0.536789    0 0
  v 11.0737 -44.3534 73.756    0.130084 -0.99088 -0.0351347    0 0
  v 6.23824 -44.8542 77.2823    0.0704052 -0.996853 0.0364233    0 0
  v 1.31948 -45.0342 73.793    0 -0.999247 -0.0387873    0 0
  v 15.3144 -43.7095 77.2071    0.168174 -0.985105 0.0358679    0 0
  v 10.8444 -44.0971 80.9131    0.128493 -0.983507 0.12729    0 0
  v 1.31948 -44.7863 80.9152    0 -0.992944 0.118588    0 0
  v 5.65902 -29.5863 49.4185    0.101594 -0.541261 -0.834695    0 0
  v 4.14457 -32.6059 51.3917    0.0549596 -0.578021 -0.814169    0 0
  v 1.31948 -29.9879 49.4185    0 -0.565039 -0.825064    0 0
  v 9.59566 -31.613 51.3965    0.148424 -0.540778 -0.827967    0 0
  v 13.3041 -36.1309 55.9245    0.202458 -0.693568 -0.691357    0 0
  v 8.28151 -34.6891 53.507    0.126432 -0.638772 -0.758937    0 0
  v 1.31948 -35.5103 53.5355    -1.86461e-009 -0.629249 -0.777204    0 0
  v 6.21281 -37.5574 55.7714    0.115809 -0.704377 -0.700315    0 0
  v 4.71504 1.61402 46.1521    0.209365 0.887982 0.409456    0 0
  v 3.15419 2.46882 44.7367    0.102102 0.928913 0.355942    0 0
  v 1.31948 2.0696 46.1521    0 0.972647 0.23229    0 0
  v 6.76035 1.6947 44.7367    0.279532 0.86827 0.40984    0 0
  v 7.43173 2.67332 41.5883    0.288333 0.916044 0.278797    0 0
  v 5.21416 2.70431 43.2306    0.191307 0.924895 0.328589    0 0
  v 1.31948 3.10248 43.2306    2.79776e-009 0.949635 0.313359    0 0
  v 3.38529 3.50455 41.5883    0.0974675 0.959165 0.265523    0 0
  v 5.61152 3.61134 39.7645    0.195872 0.958211 0.208484    0 0
  v 3.54939 4.28157 37.7966    0.0994517 0.984209 0.146432    0 0
  v 1.31948 4.04591 39.7645    9.32882e-010 0.97904 0.203669    0 0
  v 7.90818 3.39346 37.7966    0.294365 0.943325 0.153255    0 0
  v 8.12307 3.72896 33.5791    0.29706 0.954514 0.0256415    0 0
  v 5.85206 4.181 35.7223    0.198605 0.976059 0.0886827    0 0
  v 1.31948 4.63835 35.7223    0 0.996227 0.0867867    0 0
  v 3.62343 4.64352 33.579    0.100364 0.994647 0.0245691    0 0
  v 5.89352 4.28167 31.4043    0.199146 0.979257 -0.0373609    0 0
  v 3.59149 4.48577 29.2296    0.100018 0.990745 -0.0917648    0 0
  v 1.31948 4.74304 31.4043    -3.17185e-008 0.99933 -0.036586    0 0
  v 8.03038 3.58273 29.2297    0.296067 0.950356 -0.0957475    0 0
  v 7.67944 3.02909 25.0062    0.292598 0.935384 -0.198601    0 0
  v 5.73695 3.90146 27.0865    0.197596 0.969551 -0.144661    0 0
  v 1.31948 4.34765 27.0865    -2.43454e-007 0.989909 -0.141703    0 0
  v 3.47053 3.88853 25.0062    0.0987929 0.976699 -0.190521    0 0
  v 5.42677 3.1482 23.0204    0.194295 0.948871 -0.248782    0 0
  v 3.27754 2.93554 21.1642    0.0958242 0.943994 -0.315743    0 0
  v 1.31948 3.56433 23.0204    2.23898e-007 0.969809 -0.243867    0 0
  v 7.11946 2.14567 21.1642    0.283908 0.900888 -0.328325    0 0
  v 6.30358 0.85854 17.9815    0.256217 0.802258 -0.539199    0 0
  v 4.96376 2.02383 19.4729    0.184203 0.892111 -0.412562    0 0
  v 1.31948 2.3951 19.4729    -8.44125e-007 0.914205 -0.405252    0 0
  v 2.99634 1.54705 17.9815    0.0866688 0.848314 -0.522353    0 0
  v 4.30514 0.424397 16.7254    0.157044 0.748644 -0.644103    0 0
  v 2.61976 -0.318296 15.6837    0.069504 0.679754 -0.730139    0 0
  v 1.31948 0.731849 16.7254    -9.342e-010 0.771297 -0.636475    0 0
  v 5.20092 -0.873043 15.682    0.209077 0.630532 -0.747473    0 0
  v 3.9726 -2.73919 14.1433    0.177993 0.4676 -0.865834    0 0
  v 3.51248 -1.48989 14.838    0.12764 0.581314 -0.803606    0 0
  v 1.31948 -1.27974 14.8315    1.96829e-007 0.599598 -0.800301    0 0
  v 2.22749 -2.30802 14.1605    0.0488462 0.524871 -0.849779    0 0
  v 2.75179 -3.29468 13.6493    0.105426 0.438083 -0.892731    0 0
  v 1.97211 -4.01865 13.261    0.0460689 0.384165 -0.922114    0 0
  v 1.31948 -3.24023 13.6169    0 0.455585 -0.890192    0 0
  v 2.74482 -4.29277 13.2249    0.126862 0.342953 -0.930746    0 0
  v 1.31948 -4.78122 12.9706    -9.74254e-008 0.307729 -0.951474    0 0
  v -8.26052 -24.9751 107.259    -0.217205 -0.427827 0.877375    0 0
  v -12.5665 -26.3593 105.205    -0.291043 -0.488372 0.82267    0 0
  v -12.5778 -29.9195 102.723    -0.27991 -0.596822 0.751967    0 0
  v -8.26052 -28.4771 105.177    -0.213179 -0.557212 0.80254    0 0
  v -16.2168 -23.5856 105.247    -0.368708 -0.397171 0.840422    0 0
  v -17.2718 -27.103 102.759    -0.377122 -0.508758 0.773915    0 0
  v -11.5195 -22.8958 107.302    -0.270207 -0.364995 0.890936    0 0
  v -22.1914 -30.7659 97.0597    -0.444471 -0.607749 0.658094    0 0
  v -17.3195 -30.7081 99.9803    -0.358976 -0.61236 0.70438    0 0
  v -22.127 -27.1616 99.984    -0.468521 -0.496996 0.7304    0 0
  v -11.5422 -33.3943 99.9755    -0.245374 -0.687477 0.683497    0 0
  v -16.2799 -34.2071 97.0649    -0.325028 -0.701419 0.634325    0 0
  v -14.1492 -20.3747 107.338    -0.32497 -0.280401 0.9032    0 0
  v -19.0278 -20.1494 105.291    -0.414255 -0.276072 0.867282    0 0
  v -21.2381 -23.5536 102.643    -0.447544 -0.427765 0.785316    0 0
  v -20.3009 -16.6037 105.547    -0.418871 -0.133886 0.898121    0 0
  v -23.3419 -18.8854 103.742    -0.318977 -0.252976 0.913376    0 0
  v -15.8512 -17.483 107.445    -0.358594 -0.184761 0.915027    0 0
  v -31.0191 -19.4939 102.717    0.238903 -0.199841 0.950257    0 0
  v -27.3777 -20.8197 101.898    -0.107705 -0.578628 0.808449    0 0
  v -27.4146 -17.6606 102.715    -0.154735 0.00538035 0.987941    0 0
  v -30.8483 -23.0302 98.2129    -0.203613 -0.847453 0.490272    0 0
  v -26.2852 -23.4654 99.8322    -0.349971 -0.618562 0.703493    0 0
  v -32.1958 -21.4718 101.206    0.119447 -0.885729 0.448572    0 0
  v -26.7517 -26.5627 97.0395    -0.507942 -0.538363 0.672428    0 0
  v -16.804 -14.5005 107.446    -0.382836 -0.0507785 0.92242    0 0
  v -21.4815 -13.1612 105.203    -0.469626 -0.0020902 0.882863    0 0
  v -24.5471 -15.3338 103.636    -0.400703 0.0501996 0.914832    0 0
  v -20.9153 -10.1539 105.269    -0.477626 0.141932 0.867023    0 0
  v -25.3232 -11.9764 102.739    -0.5674 0.130216 0.813081    0 0
  v -16.9753 -11.6266 107.353    -0.386193 0.0634888 0.920231    0 0
  v -32.36 -12.3362 97.0145    -0.683725 0.100356 0.722807    0 0
  v -29.4206 -12.8416 99.74    -0.6164 0.239626 0.750087    0 0
  v -28.8206 -10.9538 100.018    -0.62205 0.115294 0.774442    0 0
  v -31.3495 -14.5616 99.4131    -0.40946 0.726098 0.552381    0 0
  v -28.1314 -14.54 101.696    -0.439285 0.450915 0.776984    0 0
  v -32.5661 -13.0252 97.1024    -0.641386 0.351376 0.682026    0 0
  v -30.6413 -17.024 102.319    0.00140934 0.428541 0.903521    0 0
  v -16.1531 -8.77542 107.319    -0.3722 0.175462 0.911416    0 0
  v -19.3278 -6.40531 105.214    -0.449293 0.270407 0.851479    0 0
  v -24.3229 -8.41218 102.794    -0.544509 0.220785 0.809175    0 0
  v -16.3771 -2.54716 105.202    -0.387694 0.382724 0.83858    0 0
  v -21.5069 -3.25721 102.721    -0.493457 0.365075 0.789443    0 0
  v -14.3096 -5.75806 107.293    -0.33858 0.27132 0.900971    0 0
  v -27.7041 -1.26987 97.0547    -0.589076 0.417683 0.691758    0 0
  v -26.7321 -5.39563 99.9749    -0.583436 0.315898 0.748205    0 0
  v -22.5204 0.511719 99.971    -0.501868 0.468009 0.72739    0 0
  v -31.6731 -8.69346 97.034    -0.660193 0.228011 0.715651    0 0
  v -11.5616 -3.03895 107.288    -0.27886 0.359449 0.890524    0 0
  v -12.5876 0.449475 105.198    -0.298754 0.483144 0.822993    0 0
  v -17.4053 1.03666 102.725    -0.397497 0.49493 0.772684    0 0
  v -8.26052 2.59222 105.177    -0.213179 0.557212 0.802539    0 0
  v -12.5778 4.03466 102.723    -0.283209 0.594574 0.752512    0 0
  v -8.26052 -0.909768 107.259    -0.218365 0.426916 0.87753    0 0
  v -16.2799 8.32223 97.0649    -0.330927 0.697798 0.635268    0 0
  v -17.3645 4.74655 99.9751    -0.375552 0.600938 0.705573    0 0
  v -11.5422 7.50948 99.9755    -0.245374 0.687476 0.683497    0 0
  v -22.3914 4.48332 97.0629    -0.475958 0.577587 0.663218    0 0
  v -4.67288 0.780496 107.171    -0.160063 0.492687 0.855359    0 0
  v -3.60681 3.96233 105.14    -0.107917 0.618572 0.778282    0 0
  v -7.23826 5.98475 102.715    -0.174925 0.660375 0.730278    0 0
  v -1.57385 6.95188 102.712    -0.0563134 0.691601 0.720081    0 0
  v -0.760633 1.53168 107.149    -0.03183 0.536457 0.843327    0 0
  v -2.34225 11.9412 97.0649    -0.0659537 0.791246 0.607931    0 0
  v -5.23493 9.14341 99.9755    -0.123863 0.733392 0.668426    0 0
  v -9.52385 10.7301 97.0649    -0.197039 0.761864 0.617041    0 0
  v -21.1623 -34.2264 94.1021    -0.407738 -0.698858 0.587662    0 0
  v -19.1176 -37.4755 91.1633    -0.355478 -0.777792 0.518339    0 0
  v -14.2124 -37.4358 94.1098    -0.277337 -0.778913 0.562476    0 0
  v -26.9367 -30.0389 94.0728    -0.538773 -0.579472 0.611504    0 0
  v -25.9999 -33.5024 91.1199    -0.497596 -0.674479 0.545415    0 0
  v -28.5169 -35.4709 85.8103    -0.53674 -0.705365 0.463    0 0
  v -23.9661 -36.7322 88.4746    -0.437415 -0.753285 0.491152    0 0
  v -30.704 -32.0985 87.9288    -0.60289 -0.625655 0.495055    0 0
  v -16.3273 -40.4232 87.9751    -0.283393 -0.857781 0.428836    0 0
  v -21.3659 -39.5999 85.8124    -0.357353 -0.831625 0.425086    0 0
  v -30.8973 -25.412 94.7757    -0.490976 -0.691676 0.529648    0 0
  v -31.4069 -28.4172 91.1286    -0.619022 -0.554078 0.556604    0 0
  v -34.6053 -22.2691 98.7281    -0.174531 -0.971587 0.159869    0 0
  v -34.5474 -23.2391 94.3843    -0.616123 -0.757534 0.215718    0 0
  v -37.1027 -19.2381 93.2463    -0.962168 -0.269062 0.0428773    0 0
  v -36.442 -22.2449 90.4655    -0.835659 -0.460864 0.298796    0 0
  v -36.8697 -20.8643 96.9538    -0.796729 -0.566388 -0.210778    0 0
  v -39.0125 -23.3215 84.3239    -0.83444 -0.400303 0.378771    0 0
  v -35.6264 -26.0553 87.7782    -0.758363 -0.473395 0.448087    0 0
  v -38.8795 -19.6606 87.4476    -0.865241 -0.274488 0.419542    0 0
  v -34.9601 -29.7975 84.4624    -0.744934 -0.552606 0.373764    0 0
  v -35.1156 -12.6429 94.3319    -0.722494 0.226498 0.653223    0 0
  v -36.9622 -14.6217 93.2892    -0.833573 0.351331 0.426288    0 0
  v -35.0356 -14.5608 95.9212    -0.565496 0.695514 0.443255    0 0
  v -35.1117 -10.2578 93.9859    -0.738772 0.141566 0.658919    0 0
  v -37.6487 -11.1282 91.0087    -0.793239 0.131545 0.594531    0 0
  v -41.2129 -9.68472 84.4491    -0.909334 0.137398 0.392725    0 0
  v -39.721 -13.0277 87.9239    -0.882071 -0.0192593 0.470722    0 0
  v -39.0462 -7.478 87.797    -0.834732 0.242034 0.494612    0 0
  v -38.2094 -16.3274 90.5122    -0.934891 -0.0803326 0.345724    0 0
  v -41.2217 -16.4087 84.3316    -0.906609 -0.141758 0.397449    0 0
  v -37.4453 -17.6233 95.8491    -0.984792 0.143555 -0.097856    0 0
  v -32.4307 -3.64788 94.0773    -0.66281 0.366092 0.653192    0 0
  v -36.312 -5.86922 90.9523    -0.748122 0.309746 0.586831    0 0
  v -27.3702 3.25054 94.1053    -0.568164 0.539437 0.621448    0 0
  v -32.0148 1.29852 91.0571    -0.654063 0.501243 0.56653    0 0
  v -34.8753 3.35687 84.5107    -0.712654 0.599572 0.364194    0 0
  v -36.0012 -0.910318 87.8568    -0.739682 0.460234 0.490974    0 0
  v -30.7363 5.59974 87.878    -0.623128 0.641255 0.447776    0 0
  v -39.1629 -3.17128 84.4795    -0.83046 0.396153 0.391662    0 0
  v -21.2047 8.24727 94.1093    -0.428622 0.691305 0.581705    0 0
  v -26.1028 7.29378 91.0623    -0.527685 0.672272 0.519229    0 0
  v -14.2124 11.551 94.1098    -0.278888 0.783255 0.555638    0 0
  v -19.0986 11.5601 91.0635    -0.372535 0.794403 0.479731    0 0
  v -21.0882 13.5788 84.5118    -0.402928 0.875898 0.265428    0 0
  v -23.9915 10.7287 87.8798    -0.470776 0.788592 0.395591    0 0
  v -16.1623 14.367 87.8792    -0.310853 0.877409 0.365408    0 0
  v -28.686 9.1359 84.5123    -0.5648 0.765358 0.308591    0 0
  v -6.60413 13.516 94.1098    -0.139685 0.828906 0.541667    0 0
  v -11.2738 14.3404 91.0632    -0.221793 0.859854 0.459846    0 0
  v -2.93537 15.7435 91.0627    -0.0740885 0.88988 0.450139    0 0
  v -3.35401 18.1338 84.5039    -0.080529 0.969382 0.231977    0 0
  v -7.60399 16.5681 87.8773    -0.155208 0.923876 0.349805    0 0
  v -12.509 16.6001 84.5083    -0.240763 0.939848 0.24232    0 0
  v -38.4257 -26.8194 80.8581    -0.826249 -0.501348 0.256832    0 0
  v -37.3201 -29.7698 77.1779    -0.813778 -0.57038 0.111493    0 0
  v -34.5482 -32.3651 80.7579    -0.758119 -0.599394 0.256871    0 0
  v -41.6766 -20.0521 80.8092    -0.915396 -0.294565 0.274374    0 0
  v -41.0691 -23.5588 77.1475    -0.894241 -0.428847 0.128152    0 0
  v -40.9334 -23.2636 69.5609    -0.874102 -0.43334 -0.219457    0 0
  v -39.5048 -26.7583 73.3663    -0.851106 -0.523185 -0.0435508    0 0
  v -42.7715 -20.0411 73.3573    -0.949795 -0.31178 -0.026122    0 0
  v -35.5441 -32.3501 73.6029    -0.781977 -0.619913 -0.0649665    0 0
  v -36.8358 -29.7095 69.6073    -0.772763 -0.585493 -0.245022    0 0
  v -42.7909 -12.9351 80.8376    -0.957961 0.000688077 0.286899    0 0
  v -43.3563 -16.5356 77.1446    -0.977005 -0.155157 0.146248    0 0
  v -41.6668 -5.95466 80.8889    -0.914007 0.293135 0.280469    0 0
  v -43.3523 -9.35699 77.1567    -0.976665 0.155893 0.147726    0 0
  v -43.2052 -9.4428 69.5609    -0.96277 0.156728 -0.220251    0 0
  v -43.918 -12.9424 73.3573    -0.999809 8.82039e-008 -0.0195515    0 0
  v -42.7715 -5.84375 73.3573    -0.949829 0.311789 -0.0247392    0 0
  v -43.2052 -16.442 69.5609    -0.96277 -0.156729 -0.220252    0 0
  v -38.3793 0.710263 80.9115    -0.801895 0.537764 0.260334    0 0
  v -41.0794 -2.3789 77.1665    -0.887238 0.441759 0.132885    0 0
  v -32.9944 6.89302 80.9148    -0.655769 0.723556 0.215484    0 0
  v -36.6342 4.11062 77.1692    -0.743579 0.660573 0.103601    0 0
  v -36.5024 3.68484 69.5609    -0.720653 0.657937 -0.218584    0 0
  v -39.3601 0.896696 73.3573    -0.82128 0.569129 -0.0398955    0 0
  v -33.8828 6.94762 73.3573    -0.655619 0.752577 -0.0615726    0 0
  v -40.9334 -2.62125 69.5609    -0.869106 0.443416 -0.219173    0 0
  v -25.873 12.0108 80.9147    -0.491123 0.854844 0.167454    0 0
  v -30.2379 9.76281 77.1693    -0.575283 0.815493 0.0634112    0 0
  v -17.4798 15.8201 80.9108    -0.326707 0.935222 0.136463    0 0
  v -22.2755 14.2556 77.1667    -0.409001 0.911984 0.0316866    0 0
  v -22.2018 13.5229 69.5571    -0.391831 0.893069 -0.221125    0 0
  v -26.6016 11.9954 73.3564    -0.485174 0.870489 -0.0827895    0 0
  v -17.989 15.8058 73.3485    -0.322553 0.94145 -0.098143    0 0
  v -30.137 9.1553 69.5609    -0.552522 0.804146 -0.219243    0 0
  v -8.27961 18.1616 80.9015    -0.163433 0.979178 0.120415    0 0
  v -13.2461 17.3763 77.1558    -0.245102 0.969414 0.0127186    0 0
  v -3.60384 18.9775 77.1421    -0.082561 0.996574 0.00492296    0 0
  v -3.58833 18.1488 69.5222    -0.0799782 0.971338 -0.223845    0 0
  v -8.54069 18.1732 73.3301    -0.162298 0.981022 -0.106089    0 0
  v -13.2004 16.5732 69.5416    -0.2358 0.945893 -0.2229    0 0
  v -22.809 -39.6695 68.1464    -0.376154 -0.840237 -0.390526    0 0
  v -25.7425 -36.6223 65.236    -0.439889 -0.766469 -0.467999    0 0
  v -20.8124 -37.2143 62.1159    -0.370505 -0.767937 -0.522493    0 0
  v -18.2661 -40.2022 65.2368    -0.345985 -0.835828 -0.426246    0 0
  v -32.7909 -31.9571 65.8068    -0.600576 -0.659768 -0.451681    0 0
  v -27.8087 -33.2785 62.2473    -0.481821 -0.68844 -0.542124    0 0
  v -30.408 -35.4339 68.3083    -0.543499 -0.730891 -0.412804    0 0
  v -23.1567 -30.4678 56.1425    -0.391332 -0.559518 -0.730616    0 0
  v -22.5156 -33.9523 59.052    -0.391367 -0.682612 -0.617149    0 0
  v -28.6673 -29.7148 59.0738    -0.496748 -0.578859 -0.646655    0 0
  v -15.8198 -36.9943 58.8558    -0.291434 -0.740681 -0.605358    0 0
  v -17.095 -33.8876 56.0989    -0.302131 -0.645375 -0.701575    0 0
  v -37.8628 -26.0663 65.8696    -0.760018 -0.508726 -0.404439    0 0
  v -33.6904 -28.2494 62.3475    -0.620246 -0.55978 -0.549492    0 0
  v -41.1101 -19.6575 65.8621    -0.863762 -0.288732 -0.412976    0 0
  v -37.7566 -22.4238 62.3401    -0.734387 -0.376595 -0.56467    0 0
  v -31.6158 -21.128 56.1425    -0.531137 -0.268332 -0.803674    0 0
  v -33.3509 -24.6123 59.0738    -0.59883 -0.42137 -0.681065    0 0
  v -36.2678 -18.9284 59.0738    -0.667368 -0.222529 -0.710704    0 0
  v -28.144 -26.1292 56.1425    -0.472494 -0.42697 -0.771003    0 0
  v -42.2142 -12.9424 65.8621    -0.907366 -9.80026e-007 -0.420341    0 0
  v -39.8607 -16.1573 62.3401    -0.800038 -0.131439 -0.585374    0 0
  v -41.1101 -6.22737 65.8621    -0.863761 0.288732 -0.412978    0 0
  v -39.8607 -9.72756 62.3401    -0.800037 0.13144 -0.585375    0 0
  v -33.3958 -10.1669 56.1425    -0.562199 0.0906509 -0.822019    0 0
  v -37.2482 -12.9424 59.0738    -0.691893 -9.36163e-009 -0.722    0 0
  v -36.2678 -6.95645 59.0738    -0.667369 0.22253 -0.710703    0 0
  v -33.3958 -15.7179 56.1425    -0.562199 -0.0906515 -0.822019    0 0
  v -37.825 0.148806 65.8621    -0.750708 0.529719 -0.39476    0 0
  v -37.7566 -3.46106 62.3401    -0.733874 0.37782 -0.564518    0 0
  v -32.5505 5.87273 65.8621    -0.602973 0.704744 -0.373845    0 0
  v -33.6526 2.33193 62.3401    -0.622882 0.573724 -0.531845    0 0
  v -28.144 0.244399 56.1425    -0.472494 0.426971 -0.771003    0 0
  v -33.3509 -1.27255 59.0738    -0.599405 0.421774 -0.68031    0 0
  v -28.6673 3.82991 59.0738    -0.500419 0.583129 -0.639954    0 0
  v -31.6158 -4.75686 56.1425    -0.531137 0.268333 -0.803674    0 0
  v -25.5392 10.6478 65.8613    -0.448917 0.81958 -0.356036    0 0
  v -27.7571 7.35727 62.3401    -0.488495 0.717142 -0.497071    0 0
  v -17.2496 14.2529 65.8533    -0.300133 0.889611 -0.344255    0 0
  v -20.4112 11.3665 62.3373    -0.352156 0.809948 -0.469009    0 0
  v -16.95 8.03847 56.1416    -0.292592 0.661413 -0.690596    0 0
  v -22.443 8.0853 59.0734    -0.385268 0.70145 -0.599614    0 0
  v -15.0946 11.2877 59.0694    -0.262832 0.780137 -0.567719    0 0
  v -23.1567 4.58294 56.1425    -0.389784 0.561314 -0.730065    0 0
  v -8.16155 16.4938 65.8349    -0.151676 0.928485 -0.338985    0 0
  v -12.0887 14.1566 62.3264    -0.213201 0.866779 -0.45082    0 0
  v -3.21156 15.5345 62.2279    -0.0707951 0.891855 -0.446747    0 0
  v -2.48325 11.3357 55.6244    -0.0821258 0.764903 -0.638889    0 0
  v -7.05652 13.2048 58.9753    -0.134114 0.825587 -0.548106    0 0
  v -9.93988 10.4244 56.1381    -0.184618 0.727833 -0.660435    0 0
  v -17.4796 -30.4589 53.6208    -0.30295 -0.520928 -0.798032    0 0
  v -12.0426 -29.7342 51.4139    -0.251012 -0.520239 -0.816299    0 0
  v -11.775 -33.0835 53.5815    -0.220117 -0.596926 -0.77151    0 0
  v -22.4242 -26.9179 53.6251    -0.369381 -0.412302 -0.832806    0 0
  v -16.6148 -26.9753 51.4183    -0.318219 -0.423883 -0.847974    0 0
  v -9.04903 -23.1159 47.5221    -0.286699 -0.31413 -0.905056    0 0
  v -11.1331 -26.347 49.4185    -0.25073 -0.385902 -0.887814    0 0
  v -14.4827 -23.6358 49.4185    -0.290691 -0.287069 -0.912738    0 0
  v -7.22277 -28.3709 49.4185    -0.18898 -0.475277 -0.859301    0 0
  v -6.33576 -25.1147 47.5221    -0.241982 -0.412577 -0.878194    0 0
  v -26.1576 -22.6663 53.6251    -0.418356 -0.281999 -0.863397    0 0
  v -20.3107 -23.5013 51.4183    -0.36645 -0.306788 -0.878405    0 0
  v -28.4828 -17.9302 53.6251    -0.446876 -0.142768 -0.88313    0 0
  v -22.8835 -19.4967 51.4183    -0.395531 -0.185133 -0.8996    0 0
  v -12.7844 -17.6941 47.5221    -0.324137 -0.124806 -0.937741    0 0
  v -17.0075 -20.3827 49.4185    -0.31427 -0.187402 -0.930653    0 0
  v -18.58 -16.7589 49.4185    -0.325732 -0.0920616 -0.940969    0 0
  v -11.2513 -20.5974 47.5221    -0.312316 -0.215108 -0.925304    0 0
  v -29.2643 -12.9424 53.6251    -0.456273 -3.44314e-007 -0.88984    0 0
  v -24.2025 -15.1648 51.4183    -0.40923 -0.0611354 -0.910381    0 0
  v -28.4828 -7.95462 53.6251    -0.446876 0.142769 -0.88313    0 0
  v -24.2025 -10.72 51.4183    -0.40923 0.0611354 -0.910381    0 0
  v -13.5703 -11.3313 47.5221    -0.328678 0.0403907 -0.943578    0 0
  v -19.1085 -12.9424 49.4185    -0.329168 6.52093e-009 -0.944271    0 0
  v -18.58 -9.12598 49.4185    -0.325732 0.0920617 -0.940969    0 0
  v -13.5703 -14.5536 47.5221    -0.328678 -0.0403906 -0.943578    0 0
  v -26.1576 -3.21852 53.6251    -0.418356 0.281999 -0.863398    0 0
  v -22.8835 -6.38812 51.4183    -0.395531 0.185133 -0.8996    0 0
  v -22.4242 1.03309 53.6251    -0.369381 0.412302 -0.832805    0 0
  v -20.3107 -2.38352 51.4183    -0.36645 0.306788 -0.878405    0 0
  v -11.2513 -5.28749 47.5221    -0.312316 0.215108 -0.925304    0 0
  v -17.0075 -5.50214 49.4185    -0.31427 0.187402 -0.930653    0 0
  v -14.4827 -2.249 49.4185    -0.290691 0.287068 -0.912738    0 0
  v -12.7844 -8.19071 47.5221    -0.324137 0.124806 -0.937741    0 0
  v -17.4651 4.57759 53.625    -0.301026 0.524936 -0.796132    0 0
  v -16.6148 1.09041 51.4183    -0.318037 0.424151 -0.847908    0 0
  v -11.6299 7.23427 53.6242    -0.214497 0.612463 -0.760841    0 0
  v -12.0281 3.85297 51.4182    -0.250844 0.524798 -0.813427    0 0
  v -6.33576 -0.770115 47.5221    -0.241982 0.412577 -0.878194    0 0
  v -11.1331 0.462105 49.4185    -0.25073 0.385902 -0.887814    0 0
  v -7.22276 2.48606 49.4185    -0.18898 0.475277 -0.859301    0 0
  v -9.04903 -2.76897 47.5221    -0.286699 0.31413 -0.905056    0 0
  v -5.27993 8.82482 53.5375    -0.151728 0.654867 -0.740356    0 0
  v -6.88416 5.74602 51.4178    -0.167158 0.599381 -0.782816    0 0
  v -1.44759 6.83498 51.3325    -0.106363 0.597265 -0.79496    0 0
  v -0.249818 1.41576 47.5221    -0.1204 0.540297 -0.832816    0 0
  v -3.02005 3.75145 49.4185    -0.12472 0.531349 -0.837922    0 0
  v -3.35017 0.586594 47.5221    -0.171256 0.499252 -0.849364    0 0
  v -54.1295 -24.0375 126.015    -0.0545037 -0.00715731 0.998488    0 0
  v -55.3818 -24.1679 125.833    -0.260387 -0.0244343 0.965195    0 0
  v -55.1026 -25.1226 125.722    -0.207883 -0.323225 0.923207    0 0
  v -53.8755 -24.9038 125.915    -0.0199355 -0.237956 0.971071    0 0
  v -56.4448 -23.3203 125.27    -0.507185 0.23441 0.829346    0 0
  v -56.4663 -24.3088 125.378    -0.507898 -0.0643647 0.859009    0 0
  v -55.4604 -23.1929 125.683    -0.29779 0.241944 0.923463    0 0
  v -57.0898 -25.3177 124.568    -0.627832 -0.419466 0.655649    0 0
  v -56.1871 -25.2635 125.268    -0.437369 -0.394114 0.808321    0 0
  v -57.3438 -24.4514 124.668    -0.703031 -0.117202 0.701435    0 0
  v -54.6289 -26.021 125.357    -0.162656 -0.542956 0.823858    0 0
  v -55.6133 -26.1484 124.944    -0.337522 -0.613073 0.714297    0 0
  v -34.6967 -19.2348 104.323    0.470453 0.194423 0.86074    0 0
  v -38.5258 -20.9218 107.355    0.685744 -0.204254 0.698595    0 0
  v -35.1154 -20.8623 104.256    0.475621 -0.628036 0.615918    0 0
  v -44.1683 -22.6423 113.798    0.811392 -0.281709 0.512137    0 0
  v -41.9388 -22.2847 110.609    0.672268 -0.602557 0.430095    0 0
  v -41.5793 -21.2883 110.583    0.719374 0.174455 0.672359    0 0
  v -42.6475 -22.81 110.084    0.197822 -0.978528 -0.0578691    0 0
  v -39.1477 -21.9033 106.92    0.425233 -0.866149 0.262608    0 0
  v -44.6809 -23.4351 113.445    0.51076 -0.849324 0.133318    0 0
  v -36.4392 -21.7964 102.924    0.144344 -0.981224 0.127922    0 0
  v -40.2323 -22.1188 106.026    -0.0841643 -0.980095 -0.179806    0 0
  v -38.0649 -21.603 101.459    -0.411555 -0.880034 -0.236984    0 0
  v -45.6449 -23.5722 112.933    -0.0745379 -0.936357 -0.343045    0 0
  v -43.6365 -22.541 109.494    -0.321251 -0.847522 -0.422497    0 0
  v -44.09 -21.6681 108.917    -0.772089 -0.194523 -0.605011    0 0
  v -41.193 -21.3893 105.184    -0.613122 -0.61962 -0.490054    0 0
  v -46.5833 -22.9861 112.512    -0.515838 -0.607036 -0.604498    0 0
  v -38.9186 -19.9109 100.463    -0.866353 -0.234767 -0.440814    0 0
  v -40.9364 -19.9458 104.242    -0.858098 0.294045 -0.420957    0 0
  v -37.7394 -17.3917 98.9529    -0.735692 0.67693 -0.022886    0 0
  v -46.6294 -21.9989 112.281    -0.76242 0.323803 -0.560239    0 0
  v -43.2903 -20.5115 108.405    -0.686475 0.659249 -0.306827    0 0
  v -41.978 -19.7361 108.386    -0.230383 0.965147 0.124156    0 0
  v -39.2308 -18.4161 103.484    -0.497552 0.867427 0.00361804    0 0
  v -45.6929 -21.062 112.306    -0.471207 0.863317 -0.180687    0 0
  v -34.6645 -15.7796 99.1716    -0.3458 0.877685 0.331801    0 0
  v -37.918 -18.2781 104.605    -0.0367458 0.924793 0.378692    0 0
  v -33.847 -17.1492 102.557    -0.00499545 0.804074 0.594509    0 0
  v -44.7094 -20.9212 112.847    0.14938 0.933993 0.324567    0 0
  v -41.5342 -20.2443 109.608    0.318869 0.793204 0.518796    0 0
  v -38.0854 -19.5497 106.596    0.429447 0.571536 0.699229    0 0
  v -44.1949 -21.6514 113.597    0.622383 0.525066 0.580469    0 0
  v -45.5694 -22.6613 116.003    0.848341 0.16123 0.504304    0 0
  v -46.2151 -23.6033 117.326    0.949521 -0.222345 0.221299    0 0
  v -45.7834 -23.7277 115.744    0.75924 -0.60336 0.243951    0 0
  v -46.2622 -24.0491 118.882    0.983394 -0.114736 -0.140614    0 0
  v -46.6544 -24.6326 117.929    0.865357 -0.471139 -0.170836    0 0
  v -46.3933 -23.0296 118.411    0.961614 0.271759 0.0380212    0 0
  v -48.0673 -25.5483 117.156    0.34208 -0.764017 -0.547047    0 0
  v -46.9348 -24.7149 116.779    0.600815 -0.786563 -0.142618    0 0
  v -47.3326 -25.696 118.07    0.648122 -0.633909 -0.422016    0 0
  v -46.6866 -24.3305 115.218    0.24336 -0.943307 -0.225714    0 0
  v -48.4056 -24.9074 116.151    0.00222251 -0.824179 -0.566325    0 0
  v -47.9732 -24.0238 114.744    -0.266462 -0.775365 -0.572544    0 0
  v -49.5331 -25.976 117.149    0.0991682 -0.653587 -0.750326    0 0
  v -50.0852 -25.0737 116.492    -0.109071 -0.574245 -0.811386    0 0
  v -51.4251 -23.6766 116.304    -0.357994 0.00233648 -0.933721    0 0
  v -49.8926 -24.0847 115.757    -0.378392 -0.468144 -0.798537    0 0
  v -51.7635 -24.7493 116.579    -0.198048 -0.312646 -0.928994    0 0
  v -48.7851 -23.0962 114.531    -0.655844 -0.132912 -0.743104    0 0
  v -50.2509 -22.776 115.874    -0.548502 0.37726 -0.746204    0 0
  v -48.3759 -21.9874 114.717    -0.58351 0.669595 -0.45952    0 0
  v -52.336 -22.8145 116.801    -0.28913 0.367697 -0.883857    0 0
  v -50.9734 -22.0554 116.839    -0.297074 0.627984 -0.719294    0 0
  v -49.3699 -21.1215 117.666    0.0499079 0.922505 -0.382744    0 0
  v -49.2946 -21.6315 116.439    -0.308032 0.864722 -0.396702    0 0
  v -50.9644 -21.139 117.703    -0.10475 0.758664 -0.643006    0 0
  v -47.245 -21.3244 115.158    -0.129313 0.991604 -0.000636509    0 0
  v -47.8219 -21.4386 117.069    0.250871 0.965908 0.063911    0 0
  v -46.1745 -21.6892 115.734    0.45617 0.79705 0.395753    0 0
  v -48.7639 -20.8589 118.624    0.343749 0.890907 -0.296854    0 0
  v -47.5426 -21.6143 118.276    0.557992 0.828345 -0.0498981    0 0
  v -46.5715 -22.2943 117.446    0.7404 0.600861 0.301288    0 0
  v -46.8348 -22.1143 119.103    0.781458 0.617645 -0.0885353    0 0
  v -46.2692 -23.0757 119.761    0.960825 0.277075 0.00660366    0 0
  v -46.2385 -24.399 120.155    0.981261 -0.177729 0.0744197    0 0
  v -46.6295 -25.2961 119.098    0.865222 -0.465744 -0.18567    0 0
  v -46.6633 -24.7319 121.568    0.893683 -0.25134 0.371697    0 0
  v -46.8848 -25.865 120.327    0.819915 -0.567035 0.0788079    0 0
  v -46.4474 -23.1655 121.13    0.926591 0.235653 0.293081    0 0
  v -49.2718 -27.401 119.032    0.28018 -0.886296 -0.368752    0 0
  v -47.6191 -26.519 119.114    0.623352 -0.739107 -0.255253    0 0
  v -48.2619 -27.1846 120.366    0.544586 -0.8387 0.00292456    0 0
  v -48.5909 -26.5611 118.031    0.343733 -0.7556 -0.557599    0 0
  v -50.457 -26.8761 117.927    0.0413271 -0.758303 -0.650591    0 0
  v -51.3903 -25.8979 117.106    -0.0981974 -0.561782 -0.821437    0 0
  v -51.5481 -27.5959 118.992    -0.0486098 -0.881226 -0.470189    0 0
  v -52.6777 -26.5915 117.904    -0.197577 -0.684713 -0.70152    0 0
  v -54.9436 -24.2312 117.577    -0.483657 -0.0437467 -0.874164    0 0
  v -53.3334 -25.2918 117.188    -0.290839 -0.393159 -0.872261    0 0
  v -54.8788 -25.7601 118.133    -0.43112 -0.506338 -0.746831    0 0
  v -53.2516 -23.9584 116.839    -0.32798 0.00969986 -0.944635    0 0
  v -54.0759 -22.798 117.472    -0.398512 0.379895 -0.834786    0 0
  v -52.6331 -21.7135 117.583    -0.259256 0.613264 -0.746119    0 0
  v -55.7408 -22.8733 118.46    -0.570469 0.387438 -0.724194    0 0
  v -54.1956 -21.5023 118.482    -0.389042 0.661607 -0.641032    0 0
  v -51.498 -19.9367 119.88    -0.00328471 0.964711 -0.263292    0 0
  v -52.3132 -20.6418 118.636    -0.181628 0.813126 -0.553026    0 0
  v -53.7031 -20.379 119.81    -0.299948 0.870675 -0.389816    0 0
  v -50.4135 -20.424 118.731    0.0757115 0.898593 -0.432203    0 0
  v -49.4752 -20.2847 119.823    0.307823 0.939589 -0.149724    0 0
  v -47.8723 -21.1117 119.575    0.56374 0.81989 -0.0998908    0 0
  v -50.4169 -19.9677 121.184    0.238175 0.967964 0.0794824    0 0
  v -48.4027 -20.7757 120.905    0.52076 0.843444 0.131951    0 0
  v -46.981 -21.9053 120.439    0.77049 0.628412 0.106976    0 0
  v -47.5253 -21.8451 121.896    0.702399 0.600578 0.382023    0 0
  v -47.211 -23.3487 122.722    0.811469 0.174054 0.557874    0 0
  v -47.7768 -25.0508 123.239    0.74192 -0.295322 0.601947    0 0
  v -47.6948 -26.3362 121.835    0.706272 -0.621922 0.338221    0 0
  v -49.555 -25.2423 124.74    0.489794 -0.318097 0.811737    0 0
  v -49.1449 -26.5972 123.49    0.535327 -0.62525 0.567879    0 0
  v -48.6648 -23.6322 124.37    0.627328 0.097783 0.772592    0 0
  v -51.7677 -28.2835 122.069    0.0827471 -0.989856 0.115493    0 0
  v -49.4626 -27.6366 121.971    0.431873 -0.869237 0.240651    0 0
  v -51.1023 -27.6168 123.576    0.247322 -0.82005 0.516091    0 0
  v -50.3376 -28.0352 120.403    0.193415 -0.970555 -0.143575    0 0
  v -52.9282 -28.0695 120.523    -0.137766 -0.95572 -0.260037    0 0
  v -54.1082 -27.1378 119.153    -0.302896 -0.792183 -0.529812    0 0
  v -54.2832 -28.0154 122.246    -0.252711 -0.964765 0.0732531    0 0
  v -55.5098 -27.3929 120.829    -0.411035 -0.867547 -0.280024    0 0
  v -57.9999 -24.7992 120.467    -0.852716 -0.189103 -0.486946    0 0
  v -56.4407 -26.1331 119.616    -0.564955 -0.603865 -0.562293    0 0
  v -57.5071 -26.2387 121.415    -0.706685 -0.683103 -0.184301    0 0
  v -56.6174 -24.5243 118.789    -0.661358 -0.108648 -0.742159    0 0
  v -57.3505 -23.0891 119.961    -0.746245 0.374855 -0.550094    0 0
  v -55.7916 -21.5044 119.792    -0.534052 0.693028 -0.484252    0 0
  v -58.341 -23.4443 121.732    -0.94313 0.295855 -0.151577    0 0
  v -57.1802 -21.802 121.462    -0.692585 0.683053 -0.231872    0 0
  v -54.2177 -20.0835 122.998    -0.20508 0.956648 0.2068    0 0
  v -55.2027 -20.4595 121.385    -0.41772 0.889181 -0.18673    0 0
  v -56.3679 -21.0295 123.039    -0.561124 0.809442 0.17304    0 0
  v -52.8066 -19.7729 121.339    -0.0959822 0.993845 -0.0553218    0 0
  v -51.7372 -20.0266 122.834    0.152946 0.939433 0.306713    0 0
  v -49.3781 -20.7028 122.473    0.44246 0.816434 0.371033    0 0
  v -53.1871 -20.6309 124.369    0.0140537 0.798784 0.601453    0 0
  v -50.8153 -21.0063 124.124    0.323449 0.726377 0.60643    0 0
  v -48.6866 -22.0068 123.584    0.588177 0.531675 0.609401    0 0
  v -50.3889 -22.448 125.058    0.384437 0.390438 0.83652    0 0
  v -50.7354 -23.9803 125.537    0.336865 -0.00623521 0.941532    0 0
  v -51.827 -25.1983 125.627    0.209269 -0.3106 0.927218    0 0
  v -51.132 -26.4255 124.809    0.268648 -0.559897 0.783801    0 0
  v -53.2773 -25.8555 125.543    0.038459 -0.463481 0.885272    0 0
  v -52.8769 -24.3075 125.988    0.0824465 -0.0887891 0.992632    0 0
  v -54.5538 -26.8067 124.743    -0.199969 -0.695902 0.689734    0 0
  v -52.9602 -26.9364 124.771    0.039339 -0.680369 0.731813    0 0
  v -53.2931 -27.8178 123.635    -0.0761321 -0.888075 0.453351    0 0
  v -55.254 -27.2273 123.811    -0.342598 -0.831094 0.438074    0 0
  v -56.3772 -27.0859 122.615    -0.511036 -0.845566 0.154468    0 0
  v -56.5455 -26.2736 124.174    -0.51368 -0.678982 0.524515    0 0
  v -57.8729 -24.9451 123.897    -0.791316 -0.289996 0.538258    0 0
  v -57.6062 -25.931 123.209    -0.714033 -0.628496 0.308464    0 0
  v -58.4285 -24.9488 122.319    -0.957541 -0.280071 0.0683765    0 0
  v -58.2041 -23.9145 123.439    -0.914707 0.117113 0.386777    0 0
  v -57.7491 -22.4767 123.139    -0.815036 0.519975 0.255621    0 0
  v -57.3936 -23.3991 124.504    -0.72766 0.241693 0.641947    0 0
  v -55.8519 -22.4132 125.247    -0.39799 0.413478 0.818926    0 0
  v -56.7605 -22.1469 124.392    -0.614401 0.538484 0.576668    0 0
  v -55.3052 -21.0576 124.404    -0.338698 0.741268 0.579488    0 0
  v -54.4667 -21.856 125.351    -0.141238 0.523177 0.840439    0 0
  v -52.5039 -21.8163 125.333    0.119512 0.510018 0.851821    0 0
  v -54.1254 -22.981 125.873    -0.0689324 0.266078 0.961484    0 0
  v -52.4249 -23.1819 125.858    0.138897 0.205882 0.968669    0 0
  v -5.36974 0.522858 46.1521    -0.364606 0.815886 0.448768    0 0
  v -7.53778 0.184685 44.7367    -0.444149 0.778113 0.444153    0 0
  v -8.44321 -1.256 46.1522    -0.517764 0.717798 0.465496    0 0
  v -8.58368 1.02798 41.5883    -0.466369 0.831161 0.302774    0 0
  v -9.75686 -0.426533 43.2307    -0.529179 0.755485 0.386279    0 0
  v -6.32029 1.51561 43.2306    -0.374594 0.856916 0.354082    0 0
  v -12.6698 -2.90915 43.2321    -0.652207 0.628223 0.424218    0 0
  v -10.587 -1.97794 44.7372    -0.58863 0.678667 0.439233    0 0
  v -11.9228 -1.29252 41.5889    -0.609865 0.720998 0.328978    0 0
  v -11.0797 -3.59722 46.1527    -0.621962 0.566206 0.540901    0 0
  v -13.0408 -4.58318 44.7389    -0.671934 0.506221 0.540597    0 0
  v -13.062 -6.34634 46.1586    -0.72045 0.399639 0.56678    0 0
  v -14.588 -4.02736 41.5915    -0.734086 0.578447 0.355692    0 0
  v -14.8489 -5.71492 43.2406    -0.756685 0.457141 0.467387    0 0
  v -16.1685 -8.77624 43.292    -0.832835 0.236165 0.500612    0 0
  v -14.7246 -7.52261 44.7698    -0.781772 0.326935 0.530986    0 0
  v -16.4228 -7.00631 41.6031    -0.842111 0.381574 0.381117    0 0
  v -14.2686 -9.43337 46.2011    -0.760958 0.197635 0.617967    0 0
  v -15.5179 -10.7894 44.8846    -0.794749 0.127662 0.593359    0 0
  v -14.5791 -12.7887 46.345    -0.777448 0.00289101 0.628941    0 0
  v -17.3368 -10.1497 41.6364    -0.89936 0.18076 0.398092    0 0
  v -16.7184 -11.8189 43.3654    -0.818104 0.206282 0.5368    0 0
  v -17.6585 -13.5294 43.1994    -0.587575 0.594301 0.549147    0 0
  v -16.3337 -13.6255 44.5    -0.643969 0.242208 0.725699    0 0
  v -17.8565 -12.5749 41.7899    -0.840637 0.404239 0.360445    0 0
  v -15.2453 -16.4964 45.4666    -0.406319 -0.102821 0.907928    0 0
  v -15.0603 -14.6076 45.7048    -0.595806 0.0135817 0.803014    0 0
  v -16.451 -15.3319 44.9715    -0.314389 0.238188 0.918926    0 0
  v -13.926 -16.2467 46.6405    -0.778024 -0.196289 0.596782    0 0
  v -14.1802 -18.0809 45.7059    -0.692834 -0.309397 0.651348    0 0
  v -12.883 -19.5273 46.3435    -0.699944 -0.382093 0.603393    0 0
  v -15.775 -17.9309 44.9944    -0.208836 -0.364413 0.907519    0 0
  v -14.8643 -19.3573 44.5157    -0.469916 -0.54729 0.69257    0 0
  v -15.7868 -20.6131 41.8127    -0.539726 -0.789656 0.291785    0 0
  v -14.4159 -20.8647 43.3671    -0.619606 -0.616359 0.485995    0 0
  v -16.012 -19.8458 43.2565    -0.313615 -0.812298 0.491751    0 0
  v -12.5145 -23.1208 43.2857    -0.645726 -0.628904 0.433033    0 0
  v -12.838 -21.3906 44.8805    -0.685835 -0.535244 0.493096    0 0
  v -14.2442 -22.2765 41.6302    -0.701069 -0.620658 0.35112    0 0
  v -11.0296 -22.2942 46.1986    -0.623508 -0.565644 0.539707    0 0
  v -10.5465 -23.9247 44.7655    -0.570772 -0.659894 0.48863    0 0
  v -8.43821 -24.6295 46.1568    -0.517609 -0.717463 0.466184    0 0
  v -11.8541 -24.6761 41.5967    -0.60112 -0.728903 0.327652    0 0
  v -9.74133 -25.4728 43.2361    -0.525129 -0.757705 0.387457    0 0
  v -6.32029 -27.4005 43.2306    -0.374594 -0.856916 0.354083    0 0
  v -7.53778 -26.0695 44.7367    -0.453997 -0.795997 0.400345    0 0
  v -8.58368 -26.9128 41.5883    -0.464521 -0.832283 0.30253    0 0
  v -5.36974 -26.4077 46.1521    -0.364606 -0.815886 0.448768    0 0
  v -4.12138 -27.5795 44.7367    -0.278385 -0.868704 0.409701    0 0
  v -2.07608 -27.4784 46.1521    -0.189698 -0.897739 0.397591    0 0
  v -3.35017 -26.4714 47.5221    -0.282282 -0.856474 0.432169    0 0
  v -4.79276 -28.5582 41.5883    -0.288333 -0.916044 0.278797    0 0
  v -2.5752 -28.5892 43.2306    -0.19121 -0.924428 0.329958    0 0
  v -0.515223 -28.3333 44.7367    -0.0959258 -0.931595 0.350613    0 0
  v -0.746323 -29.3894 41.5883    -0.097467 -0.959165 0.265523    0 0
  v -0.249818 -27.1373 47.5221    -0.0953876 -0.906667 0.41092    0 0
  v -7.07657 2.32645 39.7645    -0.38635 0.894949 0.223161    0 0
  v -9.32499 1.64865 37.7966    -0.480642 0.861091 0.16585    0 0
  v -10.8003 0.245803 39.7646    -0.55342 0.796964 0.242021    0 0
  v -9.65893 1.93785 33.5791    -0.487461 0.872707 0.0276445    0 0
  v -11.4297 0.662903 35.7224    -0.569824 0.815485 0.101415    0 0
  v -7.53396 2.83581 35.7223    -0.392902 0.914708 0.0945326    0 0
  v -14.6764 -2.13163 35.7231    -0.72556 0.680664 0.101284    0 0
  v -12.865 -0.812733 37.7971    -0.639104 0.748726 0.175942    0 0
  v -13.2868 -0.605006 33.5792    -0.656036 0.754256 0.0267224    0 0
  v -13.9259 -2.39908 39.7659    -0.694446 0.672161 0.256798    0 0
  v -15.666 -3.74181 37.7989    -0.782686 0.596501 0.177733    0 0
  v -16.2502 -5.37553 39.7684    -0.82485 0.498824 0.266076    0 0
  v -16.1401 -3.68797 33.5798    -0.807667 0.589334 0.0189827    0 0
  v -17.071 -5.34277 35.7228    -0.864789 0.493005 0.095317    0 0
  v -18.5432 -8.91777 35.7074    -0.961786 0.254515 0.100942    0 0
  v -17.588 -7.01954 37.793    -0.906652 0.382426 0.178136    0 0
  v -18.0829 -7.1584 33.5769    -0.926804 0.375258 0.0146816    0 0
  v -17.6829 -8.62096 39.765    -0.924797 0.262955 0.274962    0 0
  v -18.5747 -10.6567 37.7602    -0.969779 0.152571 0.190395    0 0
  v -18.2677 -11.8463 39.8593    -0.94816 0.202389 0.245012    0 0
  v -19.071 -10.9226 33.5624    -0.991299 0.12987 0.0214464    0 0
  v -19.0661 -12.8061 35.5845    -0.995883 0.012613 0.0897616    0 0
  v -18.6641 -16.7943 35.14    -0.967002 -0.249257 0.0527011    0 0
  v -18.8767 -14.8911 36.9158    -0.997356 -0.0712138 0.0144639    0 0
  v -19.1124 -14.8414 33.3757    -0.993389 -0.113981 0.0136479    0 0
  v -19.1289 -15.6102 38.5906    -0.860859 0.143821 -0.488096    0 0
  v -18.8393 -13.7852 38.7885    -0.982193 0.187779 -0.0059755    0 0
  v -18.6463 -16.8896 37.6689    -0.936965 -0.242938 -0.251152    0 0
  v -18.7757 -13.6203 40.5448    -0.810739 0.585339 -0.00901807    0 0
  v -17.9054 -18.6645 36.9169    -0.907146 -0.420812 0.00166503    0 0
  v -17.2918 -19.7728 38.8041    -0.769755 -0.637431 -0.0340535    0 0
  v -18.4269 -18.2946 38.6134    -0.710507 -0.538172 -0.453376    0 0
  v -18.1181 -18.6814 33.3753    -0.924481 -0.381089 0.0103427    0 0
  v -17.0726 -20.5192 35.5827    -0.865507 -0.494766 0.07813    0 0
  v -14.6688 -23.753 35.7043    -0.727555 -0.678481 0.101623    0 0
  v -15.5943 -22.2119 37.756    -0.772929 -0.610505 0.172816    0 0
  v -16.1325 -22.1967 33.5611    -0.808106 -0.588643 0.0215519    0 0
  v -15.8734 -21.1881 39.8611    -0.722111 -0.6623 0.199787    0 0
  v -13.8146 -23.6242 39.7587    -0.692607 -0.67747 0.247649    0 0
  v -17.1031 -20.0218 40.6018    -0.500601 -0.865279 -0.0262687    0 0
  v -12.8507 -25.0859 37.7885    -0.639821 -0.749007 0.172098    0 0
  v -10.7891 -26.1445 39.7639    -0.550298 -0.799805 0.239757    0 0
  v -13.2853 -25.2798 33.5755    -0.656481 -0.753854 0.0271633    0 0
  v -11.4289 -26.5477 35.7205    -0.570327 -0.815157 0.101228    0 0
  v -7.53396 -28.7207 35.7223    -0.392902 -0.914708 0.0945328    0 0
  v -9.32499 -27.5335 37.7966    -0.480514 -0.861164 0.165842    0 0
  v -9.65894 -27.8227 33.5791    -0.487507 -0.872681 0.0276451    0 0
  v -7.07657 -28.2113 39.7645    -0.38635 -0.894949 0.223161    0 0
  v -5.26922 -29.2783 37.7966    -0.294365 -0.943325 0.153255    0 0
  v -2.97256 -29.4962 39.7645    -0.195872 -0.958211 0.208483    0 0
  v -5.4841 -29.6138 33.5791    -0.29706 -0.954514 0.0256417    0 0
  v -3.2131 -30.0658 35.7223    -0.198605 -0.976059 0.088683    0 0
  v -0.91042 -30.1664 37.7966    -0.0994521 -0.984209 0.146432    0 0
  v -0.984469 -30.5284 33.5791    -0.100364 -0.994647 0.024569    0 0
  v -7.61273 2.92583 31.4043    -0.394152 0.918185 -0.03976    0 0
  v -9.51494 1.81179 29.2297    -0.485748 0.867988 -0.103184    0 0
  v -11.5375 0.733325 31.4044    -0.574876 0.817078 -0.0435977    0 0
  v -8.96977 1.33453 25.0062    -0.478245 0.851871 -0.213538    0 0
  v -11.128 0.450276 27.0865    -0.568632 0.805559 -0.166531    0 0
  v -7.31522 2.58582 27.0865    -0.390563 0.90764 -0.153785    0 0
  v -14.3086 -2.34194 27.0865    -0.727893 0.66134 -0.181109    0 0
  v -13.1027 -0.7148 29.2297    -0.655319 0.746874 -0.112854    0 0
  v -12.4097 -1.09542 25.0062    -0.642704 0.730404 -0.231174    0 0
  v -14.8012 -2.1174 31.4045    -0.736724 0.674264 -0.0510493    0 0
  v -15.924 -3.80769 29.2297    -0.806538 0.577867 -0.124764    0 0
  v -17.1979 -5.43596 31.4044    -0.873716 0.482644 -0.0606192    0 0
  v -15.1273 -4.08558 25.0062    -0.788148 0.562535 -0.249754    0 0
  v -16.6482 -5.61168 27.0865    -0.860259 0.470994 -0.195239    0 0
  v -18.0774 -9.19787 27.0865    -0.947503 0.245634 -0.204701    0 0
  v -17.8416 -7.29601 29.2294    -0.920435 0.367151 -0.134163    0 0
  v -16.9809 -7.46996 25.0062    -0.896021 0.356355 -0.264873    0 0
  v -18.6612 -9.08106 31.4014    -0.965699 0.251819 -0.0633375    0 0
  v -18.812 -11.0274 29.228    -0.982454 0.12602 -0.137485    0 0
  v -19.1568 -12.9152 31.3768    -0.997994 0.00554935 -0.0630709    0 0
  v -17.9202 -11.0918 25.0062    -0.954175 0.121585 -0.273437    0 0
  v -18.5558 -12.9424 27.0865    -0.978081 -8.92586e-007 -0.208227    0 0
  v -18.0774 -16.687 27.0865    -0.947108 -0.245534 -0.206637    0 0
  v -18.8161 -14.8454 29.2093    -0.98218 -0.123183 -0.141942    0 0
  v -17.9202 -14.7931 25.0062    -0.954175 -0.121586 -0.273437    0 0
  v -18.6854 -16.7692 31.2879    -0.965348 -0.250091 -0.0745512    0 0
  v -17.8451 -18.5843 29.2093    -0.919433 -0.368313 -0.137797    0 0
  v -17.1982 -20.4443 31.3764    -0.872344 -0.485159 -0.0603061    0 0
  v -16.9809 -18.4149 25.0062    -0.896021 -0.356354 -0.264873    0 0
  v -16.6482 -20.2732 27.0865    -0.860233 -0.470979 -0.195391    0 0
  v -14.3086 -23.5429 27.0865    -0.727897 -0.661345 -0.181077    0 0
  v -15.9232 -22.0771 29.2279    -0.806495 -0.578012 -0.124373    0 0
  v -15.1273 -21.7993 25.0062    -0.788148 -0.562535 -0.249755    0 0
  v -14.7997 -23.7674 31.4007    -0.736993 -0.674009 -0.050536    0 0
  v -13.1025 -25.17 29.2293    -0.655348 -0.746858 -0.112795    0 0
  v -11.5374 -26.6182 31.404    -0.574934 -0.81704 -0.0435584    0 0
  v -12.4097 -24.7894 25.0062    -0.642704 -0.730404 -0.231173    0 0
  v -11.128 -26.3351 27.0865    -0.568633 -0.805559 -0.166529    0 0
  v -7.31522 -28.4707 27.0865    -0.390563 -0.90764 -0.153785    0 0
  v -9.51494 -27.6966 29.2297    -0.48575 -0.867986 -0.103184    0 0
  v -8.96977 -27.2194 25.0062    -0.478245 -0.851871 -0.213539    0 0
  v -7.61273 -28.8107 31.4043    -0.394152 -0.918185 -0.03976    0 0
  v -5.39141 -29.4676 29.2297    -0.296067 -0.950356 -0.0957476    0 0
  v -3.25455 -30.1665 31.4043    -0.199146 -0.979257 -0.0373606    0 0
  v -5.04047 -28.9139 25.0062    -0.292599 -0.935384 -0.198601    0 0
  v -3.09799 -29.7863 27.0865    -0.197596 -0.969551 -0.14466    0 0
  v -0.952523 -30.3706 29.2297    -0.100017 -0.990745 -0.0917648    0 0
  v -0.831569 -29.7734 25.0062    -0.098792 -0.976699 -0.190521    0 0
  v -6.72579 1.91219 23.0204    -0.382939 0.885292 -0.26385    0 0
  v -8.09986 0.572977 21.1642    -0.460268 0.815407 -0.35109    0 0
  v -10.317 -0.108389 23.0204    -0.554049 0.782381 -0.284445    0 0
  v -6.83243 -0.536588 17.9815    -0.407407 0.714952 -0.56821    0 0
  v -9.10651 -0.942291 19.4729    -0.513941 0.721805 -0.463533    0 0
  v -5.84598 0.90669 19.4729    -0.360294 0.82542 -0.434592    0 0
  v -11.8821 -3.39845 19.4729    -0.645341 0.582414 -0.494296    0 0
  v -11.3043 -1.70106 21.1642    -0.612944 0.69422 -0.377305    0 0
  v -9.69361 -2.58347 17.9815    -0.531325 0.598337 -0.599738    0 0
  v -13.3351 -2.76579 23.0204    -0.705168 0.639073 -0.30712    0 0
  v -13.8572 -4.52054 21.1642    -0.745251 0.53021 -0.404325    0 0
  v -15.5679 -5.89491 23.0204    -0.8289 0.45288 -0.328367    0 0
  v -12.0067 -5.15426 17.9815    -0.63357 0.448268 -0.630591    0 0
  v -13.9552 -6.31793 19.4728    -0.749108 0.407674 -0.522148    0 0
  v -15.2351 -9.55236 19.472    -0.81434 0.209423 -0.541288    0 0
  v -15.6099 -7.73105 21.1642    -0.840991 0.333637 -0.425935    0 0
  v -13.611 -8.11336 17.9806    -0.703597 0.277374 -0.654228    0 0
  v -16.9378 -9.33907 23.0204    -0.909351 0.2353 -0.343097    0 0
  v -16.5008 -11.1797 21.1638    -0.891609 0.11362 -0.43832    0 0
  v -17.3968 -12.9424 23.0204    -0.937473 -5.58434e-007 -0.348058    0 0
  v -14.4265 -11.3174 17.977    -0.738448 0.0955647 -0.667505    0 0
  v -15.6743 -12.9503 19.477    -0.838191 0.00750353 -0.545325    0 0
  v -15.3062 -16.3446 19.5107    -0.826354 -0.213203 -0.521233    0 0
  v -16.5128 -14.709 21.1703    -0.895497 -0.11081 -0.431053    0 0
  v -14.5457 -14.6057 18.0421    -0.753849 -0.0762946 -0.652603    0 0
  v -16.9378 -16.5458 23.0204    -0.910421 -0.235575 -0.340056    0 0
  v -15.6214 -18.1549 21.1703    -0.842956 -0.337533 -0.418923    0 0
  v -15.5679 -19.9899 23.0204    -0.828997 -0.452932 -0.32805    0 0
  v -13.7266 -17.7829 18.0421    -0.709337 -0.300315 -0.637693    0 0
  v -13.9649 -19.5647 19.477    -0.747133 -0.414852 -0.519316    0 0
  v -11.8812 -22.4848 19.472    -0.64539 -0.581834 -0.494914    0 0
  v -13.8568 -21.3635 21.1638    -0.744854 -0.530396 -0.404812    0 0
  v -12.0023 -20.7225 17.977    -0.631626 -0.449816 -0.631438    0 0
  v -13.3351 -23.1191 23.0204    -0.70515 -0.639055 -0.3072    0 0
  v -11.3042 -24.1836 21.1642    -0.612965 -0.694127 -0.377441    0 0
  v -10.317 -25.7765 23.0204    -0.554047 -0.78238 -0.284453    0 0
  v -9.69273 -23.2998 17.9806    -0.531542 -0.597729 -0.600153    0 0
  v -9.10642 -24.9424 19.4728    -0.514019 -0.721695 -0.463617    0 0
  v -5.84598 -26.7915 19.4729    -0.360294 -0.82542 -0.434592    0 0
  v -8.09986 -26.4578 21.1642    -0.460276 -0.815403 -0.35109    0 0
  v -6.83243 -25.3483 17.9815    -0.407465 -0.714911 -0.568221    0 0
  v -6.72579 -27.797 23.0204    -0.38294 -0.885291 -0.26385    0 0
  v -4.48049 -28.0305 21.1642    -0.283908 -0.900888 -0.328325    0 0
  v -2.7878 -29.033 23.0204    -0.194295 -0.948871 -0.248783    0 0
  v -3.66461 -26.7434 17.9815    -0.256217 -0.802258 -0.539199    0 0
  v -2.3248 -27.9087 19.4729    -0.184203 -0.892111 -0.412561    0 0
  v -0.63857 -28.8204 21.1642    -0.0958244 -0.943994 -0.315742    0 0
  v -0.357375 -27.4319 17.9815    -0.0866684 -0.848314 -0.522352    0 0
  v -4.59444 -0.523648 16.7254    -0.301093 0.678367 -0.670194    0 0
  v -5.10286 -2.04193 15.6751    -0.316507 0.541969 -0.77852    0 0
  v -7.38451 -2.12853 16.7254    -0.416279 0.579025 -0.701029    0 0
  v -3.04503 -3.76432 14.0746    -0.241372 0.382265 -0.891972    0 0
  v -5.17755 -3.62258 14.7938    -0.305036 0.414855 -0.857233    0 0
  v -3.02496 -2.28191 14.8144    -0.238634 0.500586 -0.832146    0 0
  v -7.21394 -5.42777 14.8019    -0.364021 0.326512 -0.872284    0 0
  v -7.49677 -3.78408 15.6738    -0.396869 0.443722 -0.803496    0 0
  v -4.89134 -5.18492 14.0614    -0.282237 0.316884 -0.905498    0 0
  v -9.81517 -4.29842 16.7254    -0.509563 0.456581 -0.729301    0 0
  v -9.49387 -6.01471 15.6761    -0.463824 0.326123 -0.823718    0 0
  v -11.6607 -6.92034 16.7249    -0.578728 0.31259 -0.753234    0 0
  v -6.60073 -7.00453 14.0852    -0.328457 0.232756 -0.915391    0 0
  v -8.79725 -7.66023 14.8068    -0.408869 0.223503 -0.884801    0 0
  v -9.7879 -10.1281 14.8026    -0.436647 0.117405 -0.891939    0 0
  v -10.8984 -8.62218 15.6743    -0.508068 0.200252 -0.837715    0 0
  v -7.79845 -9.15232 14.0895    -0.355535 0.147264 -0.922989    0 0
  v -12.8087 -9.86233 16.7208    -0.620088 0.157314 -0.768598    0 0
  v -11.6078 -11.455 15.6645    -0.528927 0.0937395 -0.843475    0 0
  v -13.2438 -12.9819 16.7461    -0.649857 0.0177816 -0.759848    0 0
  v -8.3999 -11.3526 14.0829    -0.365761 0.0975573 -0.925582    0 0
  v -10.0815 -12.4563 14.687    -0.462077 0.193834 -0.865398    0 0
  v -9.75852 -13.6314 13.8703    -0.50576 0.676552 -0.535242    0 0
  v -10.9815 -13.7603 14.8796    -0.640297 0.257598 -0.723645    0 0
  v -8.59141 -12.9427 13.8045    -0.332212 0.487986 -0.807159    0 0
  v -11.4775 -15.9022 15.2962    -0.785417 -0.202795 -0.584802    0 0
  v -12.2251 -14.5719 15.8994    -0.675462 -0.0148168 -0.737246    0 0
  v -11.0958 -14.9774 14.5402    -0.905252 0.171926 -0.388536    0 0
  v -13.1644 -16.0832 16.9143    -0.67067 -0.172501 -0.721419    0 0
  v -11.5286 -17.2802 15.9004    -0.621226 -0.318044 -0.716189    0 0
  v -11.7091 -18.9532 16.7461    -0.586874 -0.337328 -0.736063    0 0
  v -10.6426 -16.7268 14.5507    -0.744971 -0.574781 -0.338593    0 0
  v -9.9474 -17.7726 14.8874    -0.505114 -0.545662 -0.668665    0 0
  v -7.30285 -17.9573 13.816    -0.16613 -0.643777 -0.746962    0 0
  v -8.48778 -18.6878 14.689    -0.36847 -0.418992 -0.829865    0 0
  v -8.71395 -17.6653 13.8965    -0.270397 -0.85438 -0.443758    0 0
  v -7.15072 -20.5514 14.7966    -0.363981 -0.33642 -0.868527    0 0
  v -9.45295 -19.9003 15.6639    -0.456329 -0.353591 -0.81654    0 0
  v -6.40869 -19.1887 14.0769    -0.30845 -0.283803 -0.907918    0 0
  v -9.81073 -21.5783 16.7208    -0.510535 -0.455761 -0.729134    0 0
  v -7.48858 -22.1068 15.6713    -0.397713 -0.446155 -0.80173    0 0
  v -7.38407 -23.7555 16.7249    -0.416634 -0.578832 -0.700977    0 0
  v -4.85293 -20.7616 14.0598    -0.277262 -0.325743 -0.90389    0 0
  v -5.17123 -22.2717 14.7932    -0.303307 -0.418432 -0.856107    0 0
  v -3.02496 -23.6029 14.8144    -0.238635 -0.500588 -0.832145    0 0
  v -5.10287 -23.8429 15.6751    -0.316363 -0.5421 -0.778487    0 0
  v -3.04503 -22.1205 14.0746    -0.240255 -0.383473 -0.891754    0 0
  v -4.59444 -25.3612 16.7254    -0.301093 -0.678367 -0.670194    0 0
  v -2.56196 -25.0118 15.682    -0.209075 -0.630533 -0.747473    0 0
  v -1.66617 -26.3092 16.7254    -0.157045 -0.748643 -0.644104    0 0
  v -1.33364 -23.1457 14.1433    -0.177991 -0.467601 -0.865834    0 0
  v -0.873516 -24.395 14.838    -0.127641 -0.581315 -0.803604    0 0
  v 0.019207 -25.5666 15.6837    -0.0695061 -0.679754 -0.730139    0 0
  v 0.411479 -23.5768 14.1605    -0.048843 -0.524871 -0.849779    0 0
  v -1.32649 -4.08131 13.5311    -0.195399 0.352922 -0.915022    0 0
  v -0.837082 -5.35803 13.0141    -0.168045 0.261993 -0.950327    0 0
  v -2.65054 -5.25832 13.428    -0.220505 0.289775 -0.931347    0 0
  v 0.199182 -6.37958 12.6404    -0.0931429 0.177691 -0.979668    0 0
  v 0.425427 -5.23178 12.8765    -0.081802 0.259244 -0.962341    0 0
  v 0.831194 -8.20093 12.3487    -0.0555703 0.074675 -0.995658    0 0
  v -0.457298 -7.34844 12.5668    -0.11721 0.133908 -0.984038    0 0
  v -2.03726 -7.98165 12.6909    -0.161196 0.12882 -0.978479    0 0
  v -2.25288 -6.6985 12.9571    -0.191013 0.206154 -0.959695    0 0
  v -0.671519 -8.65267 12.4499    -0.102102 0.0840413 -0.991217    0 0
  v -4.37198 -6.65213 13.469    -0.258851 0.234721 -0.936964    0 0
  v -3.71769 -8.05932 13.019    -0.223797 0.148194 -0.963304    0 0
  v -5.73761 -8.46004 13.4953    -0.287129 0.157251 -0.944896    0 0
  v -1.36394 -9.36315 12.4713    -0.115242 0.0702888 -0.990847    0 0
  v -2.86437 -9.51383 12.6801    -0.169944 0.0854852 -0.981739    0 0
  v -3.73124 -11.0603 12.7193    -0.192044 0.0492317 -0.980151    0 0
  v -4.71721 -9.83767 13.0328    -0.238902 0.0976083 -0.966125    0 0
  v -2.17351 -10.905 12.481    -0.130585 0.0463485 -0.990353    0 0
  v -6.56546 -10.5013 13.4941    -0.304124 0.0825239 -0.949051    0 0
  v -5.18687 -11.7738 13.0248    -0.246133 0.053485 -0.967759    0 0
  v -6.93972 -12.4212 13.4478    -0.268136 0.195186 -0.943401    0 0
  v -2.43162 -11.9869 12.4784    -0.136234 0.0243877 -0.990376    0 0
  v -3.58857 -12.8849 12.6533    -0.170013 0.0126149 -0.985361    0 0
  v -3.20376 -14.7478 12.5926    -0.143235 -0.0365649 -0.989013    0 0
  v -4.49807 -13.9635 12.7754    -0.10608 0.0521237 -0.99299    0 0
  v -2.21097 -13.8394 12.4251    -0.124749 -0.00533444 -0.992174    0 0
  v -5.9059 -14.4528 12.6619    0.284119 0.342462 -0.895543    0 0
  v -6.06623 -13.4649 12.9897    -0.0747532 0.303659 -0.949844    0 0
  v -4.90559 -15.101 12.7565    0.0883192 0.0188602 -0.995914    0 0
  v -7.57493 -13.4689 13.078    -0.0497141 0.720183 -0.692001    0 0
  v -3.99934 -15.9437 12.7764    -0.0759907 -0.104894 -0.991576    0 0
  v -5.19642 -16.8772 12.9975    0.0233361 -0.348203 -0.937129    0 0
  v -5.50742 -16.0022 12.6724    0.375484 -0.206093 -0.903625    0 0
  v -1.93257 -14.965 12.4251    -0.110285 -0.0536107 -0.992453    0 0
  v -2.70744 -16.4162 12.6499    -0.147065 -0.0897826 -0.985044    0 0
  v -2.00644 -17.9279 12.6868    -0.159324 -0.12939 -0.978711    0 0
  v -3.61696 -17.9329 13.0089    -0.207663 -0.172598 -0.962853    0 0
  v -1.33312 -16.5465 12.4673    -0.111649 -0.0738049 -0.991003    0 0
  v -5.53002 -17.9554 13.4474    -0.188695 -0.33208 -0.924185    0 0
  v -4.28978 -19.3517 13.4644    -0.252637 -0.239607 -0.937424    0 0
  v -6.58514 -17.3027 13.1042    0.16451 -0.750487 -0.640083    0 0
  v -2.23239 -19.2081 12.9551    -0.188407 -0.207112 -0.960004    0 0
  v -2.64232 -20.6384 13.4276    -0.217774 -0.292698 -0.931076    0 0
  v -0.660997 -17.2406 12.4486    -0.100857 -0.0845795 -0.991299    0 0
  v -0.454041 -18.539 12.5663    -0.116423 -0.134309 -0.984077    0 0
  v 0.199182 -19.5053 12.6404    -0.0929723 -0.177701 -0.979683    0 0
  v 0.831194 -17.6839 12.3487    -0.0554208 -0.0747353 -0.995662    0 0
  v 0.425427 -20.6531 12.8765    -0.0818007 -0.259239 -0.962343    0 0
  v -0.837082 -20.5268 13.0141    -0.16789 -0.262279 -0.950275    0 0
  v -1.32649 -21.8035 13.5311    -0.195399 -0.352922 -0.915022    0 0
  v -0.105855 -21.5921 13.2249    -0.126868 -0.342951 -0.930746    0 0
  v -0.112829 -22.5902 13.6493    -0.105426 -0.438085 -0.89273    0 0
  v 0.666854 -21.8662 13.2609    -0.04607 -0.384168 -0.922113    0 0
  v -30.8419 -18.3368 36.0258    -0.957364 0.177196 -0.228156    0 0
  v -30.3814 -18.351 35.276    -0.654437 0.0648526 -0.75333    0 0
  v -30.4085 -19.1486 35.5245    -0.609297 -0.452532 -0.651131    0 0
  v -30.8589 -19.0196 36.2378    -0.949471 -0.270227 -0.159634    0 0
  v -29.3658 -17.6625 34.9826    -0.241068 0.519747 -0.819603    0 0
  v -29.5046 -18.3708 34.8335    -0.275299 -0.0278031 -0.960957    0 0
  v -30.1039 -17.645 35.38    -0.532194 0.591374 -0.605843    0 0
  v -28.6329 -19.0756 34.9536    0.0969113 -0.477639 -0.873195    0 0
  v -29.5317 -19.1683 35.082    -0.235848 -0.495557 -0.835942    0 0
  v -28.6159 -18.3928 34.7416    0.0812764 -0.0813831 -0.993363    0 0
  v -30.1353 -19.7436 36.0291    -0.41829 -0.837427 -0.35178    0 0
  v -29.3972 -19.7612 35.6316    -0.1404 -0.838753 -0.5261    0 0
  v -17.0314 -16.7338 45.1129    -0.0843604 -0.00199958 0.996433    0 0
  v -18.006 -17.8349 44.8362    -0.0354839 -0.39703 0.917119    0 0
  v -16.8001 -18.8592 44.2373    -0.132388 -0.670869 0.729663    0 0
  v -20.5923 -17.8854 44.7041    -0.0859068 -0.405058 0.910246    0 0
  v -19.2033 -18.6845 44.2071    -0.036732 -0.704423 0.708829    0 0
  v -19.4738 -16.9008 44.9941    -0.0682242 0.0382085 0.996938    0 0
  v -19.4254 -19.5832 42.2966    -0.0698885 -0.995474 0.0643955    0 0
  v -18.0827 -19.3987 43.3131    -0.0939893 -0.889153 0.447854    0 0
  v -20.4451 -19.2761 43.2971    -0.0350275 -0.907515 0.418556    0 0
  v -17.3563 -19.8949 42.1159    -0.238732 -0.960141 0.145384    0 0
  v -18.7657 -19.508 41.1013    -0.196253 -0.947983 -0.250624    0 0
  v -18.4464 -19.1023 39.8215    -0.428641 -0.801514 -0.416944    0 0
  v -20.7403 -19.367 41.1921    0.0107392 -0.949845 -0.312537    0 0
  v -20.1201 -18.8662 40.1968    -0.0754201 -0.809791 -0.58185    0 0
  v -20.8183 -17.1674 39.1123    -0.0497897 -0.0680356 -0.99644    0 0
  v -19.7058 -18.1005 39.3323    -0.236336 -0.558092 -0.795411    0 0
  v -21.3304 -18.1127 39.4415    0.0877572 -0.529205 -0.843943    0 0
  v -19.4141 -17.0472 38.7523    -0.503302 -0.14646 -0.851608    0 0
  v -20.2457 -16.0824 39.2563    -0.298132 0.381591 -0.874932    0 0
  v -19.5708 -14.8624 39.7343    -0.625274 0.594292 -0.505817    0 0
  v -21.7893 -16.3266 39.3021    0.0407076 0.434612 -0.899698    0 0
  v -21.0502 -15.3658 39.9942    -0.150843 0.720413 -0.676943    0 0
  v -20.7896 -14.4492 41.9995    -0.215688 0.976447 0.00539558    0 0
  v -20.1073 -14.4938 40.9114    -0.351834 0.874676 -0.3334    0 0
  v -21.8875 -14.9017 40.8436    -0.0970369 0.91063 -0.401668    0 0
  v -18.9655 -13.825 41.9881    -0.492526 0.857784 0.147054    0 0
  v -19.4218 -14.3931 43.1231    -0.272984 0.85768 0.435735    0 0
  v -17.9089 -14.6704 44.1501    -0.302031 0.594276 0.745395    0 0
  v -21.5922 -14.8107 42.9486    -0.189894 0.910331 0.367745    0 0
  v -20.1335 -15.184 44.0045    -0.167415 0.721673 0.671684    0 0
  v -18.5434 -15.8254 44.7602    -0.120118 0.419983 0.899548    0 0
  v -21.0512 -16.0992 44.5647    -0.167516 0.465384 0.869112    0 0
  v -22.0921 -17.0847 44.6555    -0.220155 0.0381037 0.97472    0 0
  v -23.1573 -18.0556 44.1735    -0.241367 -0.406399 0.881239    0 0
  v -21.7262 -18.7316 43.9637    -0.0968823 -0.713011 0.694428    0 0
  v -25.5288 -18.3087 43.1265    -0.432252 -0.402225 0.807077    0 0
  v -24.1294 -18.9128 43.2484    -0.214795 -0.712518 0.667968    0 0
  v -24.5797 -17.3335 43.8315    -0.422242 0.0331076 0.905878    0 0
  v -23.6915 -19.6879 41.5808    0.0682998 -0.996195 0.0541439    0 0
  v -22.7779 -19.3611 42.8875    -0.055194 -0.911088 0.4085    0 0
  v -24.9363 -19.5546 42.0019    -0.125234 -0.91157 0.391609    0 0
  v -21.6163 -19.5525 42.1558    0.0233669 -0.998734 0.0445472    0 0
  v -22.6769 -19.4418 40.8721    0.15733 -0.939996 -0.302746    0 0
  v -21.9084 -18.8921 40.091    0.151815 -0.792728 -0.590369    0 0
  v -24.4565 -19.6262 40.1369    0.258384 -0.931367 -0.256503    0 0
  v -23.5768 -19.0554 39.5918    0.334414 -0.773785 -0.537981    0 0
  v -23.7692 -17.5427 38.4685    0.459885 -0.0270334 -0.887567    0 0
  v -22.9048 -18.2572 39.135    0.326405 -0.503686 -0.79985    0 0
  v -24.3295 -18.4877 38.4639    0.533019 -0.485758 -0.69277    0 0
  v -22.3593 -17.32 38.9755    0.219768 -0.0399055 -0.974736    0 0
  v -23.272 -16.5492 38.9426    0.255207 0.441369 -0.860269    0 0
  v -22.6861 -15.6341 39.7783    0.0581925 0.733007 -0.677727    0 0
  v -24.6043 -16.8343 38.2159    0.449967 0.431632 -0.781808    0 0
  v -24.1756 -15.8971 39.1817    0.21047 0.727089 -0.653487    0 0
  v -24.5698 -15.0558 40.9793    -0.154918 0.986075 -0.060475    0 0
  v -23.5948 -15.1716 40.3911    0.0122327 0.911588 -0.410923    0 0
  v -25.1435 -15.4928 39.5167    0.0609991 0.906973 -0.416748    0 0
  v -22.7569 -14.7741 41.6973    -0.137761 0.989928 -0.0326125    0 0
  v -23.6958 -15.091 42.4065    -0.256031 0.90666 0.335284    0 0
  v -22.5039 -15.4736 43.651    -0.243675 0.73224 0.635961    0 0
  v -25.6232 -15.4212 41.3817    -0.389145 0.883229 0.261672    0 0
  v -24.7283 -15.7546 42.8382    -0.401202 0.711728 0.57661    0 0
  v -23.5245 -16.3475 43.9811    -0.338676 0.451991 0.825229    0 0
  v -25.8036 -16.6553 42.8784    -0.541489 0.437197 0.718087    0 0
  v -26.8033 -17.6559 42.4457    -0.629895 0.0380494 0.775748    0 0
  v -27.5826 -18.604 41.5381    -0.598169 -0.395478 0.696987    0 0
  v -26.2824 -19.154 42.0052    -0.362299 -0.71107 0.602593    0 0
  v -29.2774 -18.8893 39.6351    -0.707179 -0.384423 0.593394    0 0
  v -28.1122 -19.3951 40.334    -0.469618 -0.709987 0.524764    0 0
  v -28.6761 -18.0206 40.6029    -0.763782 0.0596636 0.642711    0 0
  v -27.161 -20.0684 39.1571    0.0379693 -0.996812 0.0701725    0 0
  v -26.8191 -19.7667 40.6336    -0.206777 -0.912282 0.353531    0 0
  v -28.4095 -19.9472 38.993    -0.267697 -0.912521 0.309263    0 0
  v -25.554 -19.8846 40.5457    0.0642 -0.99566 0.0673709    0 0
  v -26.0126 -19.8292 39.0111    0.297642 -0.933174 -0.201482    0 0
  v -25.0608 -19.2798 38.7141    0.462111 -0.766487 -0.446039    0 0
  v -27.3588 -19.9988 37.6987    0.283064 -0.943645 -0.171491    0 0
  v -26.3483 -19.5026 37.5811    0.493012 -0.787821 -0.369158    0 0
  v -26.0891 -18.1783 36.5652    0.733421 -0.0708667 -0.676071    0 0
  v -25.5666 -18.7601 37.4819    0.646666 -0.502471 -0.573887    0 0
  v -26.6505 -19.0182 36.3996    0.650229 -0.556904 -0.516779    0 0
  v -25.0116 -17.8405 37.6187    0.653291 -0.033582 -0.756361    0 0
  v -25.7682 -17.2247 37.1643    0.572284 0.419529 -0.704618    0 0
  v -25.5045 -16.2764 38.184    0.316353 0.720835 -0.616699    0 0
  v -26.7777 -17.6375 36.0309    0.61407 0.397104 -0.682075    0 0
  v -26.6601 -16.7655 36.9286    0.370028 0.718102 -0.589414    0 0
  v -27.6182 -16.0539 38.2002    -0.214719 0.960215 -0.178555    0 0
  v -26.5167 -15.9906 38.2171    0.0838154 0.901402 -0.424794    0 0
  v -27.6767 -16.5471 36.7771    0.120624 0.894718 -0.430035    0 0
  v -26.2048 -15.4796 39.7683    -0.217171 0.968786 -0.119542    0 0
  v -27.3231 -15.9282 39.8395    -0.469749 0.870654 0.145937    0 0
  v -26.7261 -16.1505 41.4751    -0.564537 0.694339 0.446309    0 0
  v -28.7275 -16.4956 38.0713    -0.464161 0.884128 0.0535923    0 0
  v -28.4239 -16.658 39.6816    -0.628825 0.711604 0.313368    0 0
  v -27.7842 -17.0686 41.2204    -0.689459 0.449184 0.568225    0 0
  v -29.4046 -17.5086 39.2665    -0.757463 0.482947 0.439331    0 0
  v -30.1581 -18.3564 38.5893    -0.856497 0.0858379 0.508965    0 0
  v -30.5143 -19.0953 37.721    -0.831372 -0.380912 0.404632    0 0
  v -29.6038 -19.5903 38.4909    -0.558817 -0.706587 0.434119    0 0
  v -30.5049 -19.5893 36.7995    -0.701435 -0.705455 0.101604    0 0
  v -30.8993 -18.5925 36.8861    -0.989075 0.0403206 0.141789    0 0
  v -29.462 -20.0637 36.3864    -0.175001 -0.958473 -0.225174    0 0
  v -29.6497 -20.0175 37.3471    -0.371769 -0.913451 0.165514    0 0
  v -28.5236 -20.1948 37.6541    -0.0132937 -0.99921 0.0374502    0 0
  v -28.4983 -20.055 36.4518    0.173021 -0.95022 -0.259123    0 0
  v -27.4797 -19.6745 36.4248    0.439496 -0.821981 -0.362201    0 0
  v -28.5022 -19.6446 35.5127    0.201382 -0.803869 -0.559678    0 0
  v -27.9853 -18.676 34.9298    0.339156 -0.270185 -0.901096    0 0
  v -27.641 -19.1896 35.4675    0.4909 -0.61995 -0.61211    0 0
  v -27.0428 -18.48 35.559    0.69647 -0.148085 -0.70214    0 0
  v -27.6766 -17.9905 35.1072    0.495214 0.287497 -0.819822    0 0
  v -27.6316 -17.2302 35.722    0.378713 0.691769 -0.614843    0 0
  v -28.5044 -17.696 34.9139    0.154139 0.490369 -0.857776    0 0
  v -29.4847 -17.19 35.5057    -0.304975 0.798629 -0.518828    0 0
  v -28.5916 -17.0537 35.5505    0.0678189 0.830662 -0.552632    0 0
  v -28.7463 -16.6097 36.6234    -0.188125 0.953202 -0.236676    0 0
  v -29.743 -17.0162 36.4458    -0.495683 0.862893 -0.098561    0 0
  v -29.7556 -17.1459 37.7881    -0.648157 0.735612 0.196896    0 0
  v -30.5071 -17.6408 36.2007    -0.756626 0.644997 -0.107219    0 0
  v -30.5499 -17.8962 37.3607    -0.839759 0.482896 0.248224    0 0
  v -11.2506 -16.5931 0.880056    -0.629556 -0.00509833 -0.776939    0 0
  v -10.8234 -16.5296 0.642664    -0.330393 0.0714891 -0.941132    0 0
  v -10.7293 -16.9035 0.663963    -0.27525 -0.323897 -0.905168    0 0
  v -11.1674 -16.9232 0.898848    -0.565327 -0.373582 -0.735419    0 0
  v -10.3691 -16.1224 0.680483    -0.0448403 0.472255 -0.880321    0 0
  v -10.3086 -16.4697 0.563925    0.00318944 0.134355 -0.990928    0 0
  v -10.8237 -16.1752 0.749994    -0.328401 0.446197 -0.832503    0 0
  v -9.72347 -16.7557 0.678083    0.356598 -0.116511 -0.926964    0 0
  v -10.2144 -16.8435 0.585223    0.0490934 -0.232564 -0.971341    0 0
  v -9.80672 -16.4256 0.659292    0.316735 0.177847 -0.931692    0 0
  v -10.5589 -17.2235 0.80962    -0.181258 -0.641941 -0.745021    0 0
  v -10.1043 -17.1706 0.740102    0.0837359 -0.557782 -0.825753    0 0
  v -11.018 -15.9014 13.8716    -0.970441 -0.241038 -0.012039    0 0
  v -10.6957 -16.5629 12.9298    -0.700027 -0.705397 0.111255    0 0
  v -9.82461 -17.1414 13.5787    -0.472116 -0.871884 -0.130094    0 0
  v -11.1045 -16.6646 10.9239    -0.684715 -0.709104 0.168336    0 0
  v -10.1892 -17.0626 11.8303    -0.416318 -0.900665 0.124427    0 0
  v -11.2778 -16.013 12.0161    -0.954387 -0.223003 0.198533    0 0
  v -8.43478 -17.4083 11.4348    0.125054 -0.992147 -0.0025392    0 0
  v -9.07876 -17.351 12.5153    -0.185752 -0.982588 -0.00414734    0 0
  v -9.55592 -17.4086 10.6493    -0.17269 -0.980766 0.0909751    0 0
  v -7.87178 -17.4635 12.9434    0.0676778 -0.969091 -0.237239    0 0
  v -7.37298 -17.1401 12.0453    0.418914 -0.882393 -0.214229    0 0
  v -6.37199 -16.6668 12.4514    0.537165 -0.612867 -0.579524    0 0
  v -7.92805 -17.2214 10.3395    0.461992 -0.885272 -0.0534496    0 0
  v -7.10211 -16.7045 11.1294    0.722054 -0.657563 -0.215057    0 0
  v -6.75 -15.4878 10.9881    0.910453 0.212112 -0.355084    0 0
  v -6.44991 -16.0538 11.7651    0.836556 -0.284289 -0.468352    0 0
  v -7.03479 -16.1968 10.1495    0.933331 -0.2887 -0.213413    0 0
  v -6.03342 -15.3077 12.2647    0.676396 0.157795 -0.719437    0 0
  v -6.77857 -14.786 11.7317    0.650625 0.593343 -0.473953    0 0
  v -7.03644 -14.1015 12.4122    0.311165 0.739805 -0.596544    0 0
  v -7.34179 -15.0048 10.0937    0.729294 0.636606 -0.250726    0 0
  v -7.69205 -14.423 11.0437    0.455534 0.847039 -0.273886    0 0
  v -9.30003 -14.0622 11.309    -0.137602 0.984132 -0.112026    0 0
  v -8.19398 -13.9745 11.9618    0.152346 0.944009 -0.292638    0 0
  v -8.69555 -14.2415 10.2001    0.196727 0.967126 -0.161139    0 0
  v -8.84888 -13.699 12.8858    -0.196247 0.92244 -0.332554    0 0
  v -9.90523 -14.1655 12.4318    -0.46056 0.881979 -0.0999902    0 0
  v -10.5219 -14.4561 13.5394    -0.744451 0.633586 -0.21062    0 0
  v -10.3234 -14.4286 10.5099    -0.439638 0.897931 -0.0209655    0 0
  v -10.7792 -14.7812 11.7445    -0.69417 0.718154 0.0488142    0 0
  v -11.0298 -15.2751 12.8964    -0.932257 0.354435 0.0726065    0 0
  v -11.4115 -15.4727 10.8682    -0.916988 0.380668 0.119268    0 0
  v -11.6437 -16.1841 9.82273    -0.965298 -0.224679 0.133112    0 0
  v -11.3928 -16.8258 8.63073    -0.693701 -0.711152 0.114202    0 0
  v -10.5882 -17.192 9.70046    -0.419467 -0.900514 0.114553    0 0
  v -11.5535 -16.9889 6.30251    -0.697174 -0.711676 0.0864054    0 0
  v -10.8308 -17.3395 7.36722    -0.423701 -0.901291 0.0902867    0 0
  v -11.8441 -16.3738 7.47173    -0.970459 -0.22826 0.078152    0 0
  v -9.18959 -17.6577 7.11336    0.129107 -0.990827 0.0399271    0 0
  v -9.89598 -17.5402 8.41178    -0.176349 -0.981193 0.0784976    0 0
  v -10.1254 -17.6705 6.09598    -0.178457 -0.981691 0.0666027    0 0
  v -8.8805 -17.5241 9.41283    0.12968 -0.990884 0.0364954    0 0
  v -8.31989 -17.3605 8.16497    0.465678 -0.884855 -0.0132682    0 0
  v -7.57993 -16.8481 9.19518    0.746523 -0.658622 -0.0944483    0 0
  v -8.62054 -17.4989 5.86614    0.465737 -0.884869 -0.00978562    0 0
  v -7.93789 -17.0098 6.92541    0.750045 -0.658575 -0.0609192    0 0
  v -7.60106 -15.8902 6.82376    0.960258 0.226151 -0.163585    0 0
  v -7.45261 -16.3765 8.01371    0.948654 -0.287644 -0.131593    0 0
  v -7.79127 -16.5599 5.72794    0.950533 -0.287565 -0.117449    0 0
  v -7.2316 -15.6797 9.08165    0.952273 0.223121 -0.20831    0 0
  v -7.74613 -15.2323 7.95039    0.742705 0.643927 -0.183704    0 0
  v -8.14261 -14.6578 9.08035    0.478762 0.858679 -0.182913    0 0
  v -8.07094 -15.4683 5.66642    0.744266 0.645154 -0.172756    0 0
  v -8.47573 -14.9115 6.80718    0.482545 0.861178 -0.15976    0 0
  v -9.97843 -14.5803 6.93995    -0.126706 0.986443 -0.104286    0 0
  v -9.05369 -14.4999 8.00666    0.202988 0.96916 -0.139729    0 0
  v -9.31974 -14.7701 5.71234    0.203091 0.968959 -0.140972    0 0
  v -9.70578 -14.3117 9.24441    -0.127314 0.987136 -0.0967138    0 0
  v -10.6298 -14.6796 8.25347    -0.441091 0.895858 -0.053641    0 0
  v -11.1509 -15.0017 9.58564    -0.694384 0.719466 0.0141085    0 0
  v -10.8246 -14.9417 5.94217    -0.443612 0.893276 -0.0725728    0 0
  v -11.3687 -15.2412 7.24898    -0.698442 0.715238 -0.0247538    0 0
  v -11.6863 -15.6816 8.5674    -0.925907 0.375006 0.0454554    0 0
  v -11.8332 -15.8973 6.24099    -0.928958 0.370049 0.0100353    0 0
  v -11.9484 -16.5533 5.23011    -0.9719 -0.230382 0.0483188    0 0
  v -11.6428 -17.1191 4.20634    -0.700928 -0.711356 0.0516928    0 0
  v -10.9892 -17.4686 5.1286    -0.426854 -0.901532 0.0709575    0 0
  v -11.6288 -17.1726 2.54382    -0.707121 -0.705433 -0.0484175    0 0
  v -11.0878 -17.5307 3.22996    -0.434825 -0.900351 0.0171721    0 0
  v -11.9615 -16.6952 3.32672    -0.971968 -0.234405 -0.018217    0 0
  v -9.67075 -17.8061 3.004    0.117743 -0.992324 -0.0378179    0 0
  v -10.3086 -17.7569 4.00908    -0.183413 -0.98237 0.0361856    0 0
  v -10.4606 -17.7328 2.36295    -0.198567 -0.978202 -0.0607607    0 0
  v -9.43475 -17.7703 4.88555    0.126998 -0.991589 0.0249523    0 0
  v -8.90119 -17.5962 3.79411    0.460827 -0.886198 -0.0478826    0 0
  v -8.24782 -17.1559 4.70992    0.748158 -0.659298 -0.0747324    0 0
  v -9.22545 -17.5914 2.17427    0.438339 -0.879986 -0.182987    0 0
  v -8.58632 -17.2448 2.84787    0.73407 -0.659732 -0.160921    0 0
  v -8.29269 -16.2758 2.76632    0.937922 0.214187 -0.272811    0 0
  v -8.12423 -16.7174 3.66892    0.942648 -0.290046 -0.165189    0 0
  v -8.54099 -16.819 2.07211    0.895082 -0.291536 -0.337393    0 0
  v -7.92772 -16.0946 4.61605    0.958144 0.224645 -0.177469    0 0
  v -8.38552 -15.6965 3.61134    0.738367 0.639284 -0.214779    0 0
  v -8.75706 -15.1674 4.59782    0.481013 0.859533 -0.172712    0 0
  v -8.76977 -15.923 2.02149    0.705616 0.607183 -0.365288    0 0
  v -9.0503 -15.4302 2.74547    0.471608 0.847208 -0.244591    0 0
  v -10.3513 -15.1447 2.85381    -0.136917 0.974437 -0.178118    0 0
  v -9.55442 -15.0439 3.65016    0.199102 0.964331 -0.174425    0 0
  v -9.7974 -15.3512 2.04772    0.184308 0.939669 -0.28819    0 0
  v -10.1816 -14.8539 4.72113    -0.12911 0.984253 -0.120738    0 0
  v -10.9619 -15.2046 3.86513    -0.448412 0.887776 -0.103828    0 0
  v -11.4984 -15.4802 5.01649    -0.701678 0.71087 -0.0480811    0 0
  v -11.0325 -15.4927 2.2364    -0.460335 0.865546 -0.197289    0 0
  v -11.5518 -15.7161 3.12755    -0.707904 0.698597 -0.104088    0 0
  v -11.9041 -16.0982 4.14875    -0.931225 0.363382 -0.0278078    0 0
  v -11.8576 -16.2766 2.4932    -0.930435 0.341644 -0.132551    0 0
  v -11.8236 -16.773 1.95216    -0.949448 -0.240534 -0.201724    0 0
  v -11.4688 -17.1115 1.46896    -0.689522 -0.651873 -0.315628    0 0
  v -11.1039 -17.4648 1.86396    -0.452304 -0.880712 -0.140596    0 0
  v -11.0024 -17.2528 1.06574    -0.445165 -0.733421 -0.513734    0 0
  v -11.5064 -16.7808 1.16403    -0.77427 -0.224753 -0.591601    0 0
  v -10.1946 -17.4255 0.965041    0.0020044 -0.79042 -0.612562    0 0
  v -10.5771 -17.5424 1.32004    -0.232528 -0.919876 -0.315845    0 0
  v -9.93447 -17.6928 1.66881    0.0868881 -0.971043 -0.222544    0 0
  v -9.63689 -17.434 1.17635    0.353 -0.79591 -0.491852    0 0
  v -9.03478 -17.2272 1.54781    0.661807 -0.62886 -0.408101    0 0
  v -9.59167 -17.0896 0.850079    0.427068 -0.475921 -0.768838    0 0
  v -9.38226 -16.5353 0.839336    0.533507 0.0852425 -0.841489    0 0
  v -9.1062 -16.8393 1.10788    0.704953 -0.260988 -0.65949    0 0
  v -8.78884 -16.4245 1.48847    0.830401 0.174328 -0.529191    0 0
  v -9.27946 -16.1569 1.0692    0.573539 0.482245 -0.662188    0 0
  v -9.41719 -15.7258 1.46287    0.430139 0.781063 -0.452682    0 0
  v -9.85087 -16.0655 0.791907    0.285008 0.543418 -0.7896    0 0
  v -10.5852 -15.8837 0.877516    -0.186729 0.683628 -0.705539    0 0
  v -10.0723 -15.7194 1.07917    0.137787 0.817993 -0.558482    0 0
  v -10.4953 -15.4909 1.54423    -0.157328 0.925745 -0.343866    0 0
  v -11.0125 -15.8278 1.22286    -0.472668 0.760836 -0.44465    0 0
  v -11.4863 -15.9634 1.77902    -0.713872 0.648857 -0.263385    0 0
  v -11.2616 -16.2287 1.00758    -0.63982 0.445532 -0.626204    0 0
  v -11.6421 -16.4292 1.43028    -0.876481 0.260858 -0.40464    0 0
  v -20.0813 -41.3682 82.7372    -0.29892 -0.916418 0.266131    0 0
  v -20.4405 -41.8766 79.6659    -0.303813 -0.944913 0.121806    0 0
  v -18.7046 -42.5271 77.13    -0.224541 -0.973984 0.0305941    0 0
  v -16.3768 -42.7089 80.7333    -0.201701 -0.968088 0.148737    0 0
  v -21.8385 -41.3221 79.1041    -0.557902 -0.829581 0.0232545    0 0
  v -21.1633 -41.8148 77.1098    -0.412023 -0.910083 0.044556    0 0
  v -22.3157 -40.9207 81.1684    -0.436089 -0.89132 0.123998    0 0
  v -23.0636 -40.9984 73.1093    -0.432189 -0.901618 -0.0172374    0 0
  v -20.8843 -41.923 74.5852    -0.306997 -0.950447 -0.0490195    0 0
  v -22.1668 -41.3702 75.0881    -0.563004 -0.82048 0.0991931    0 0
  v -16.8204 -42.8545 73.492    -0.20789 -0.975212 -0.0757875    0 0
  v -20.9959 -41.5027 71.4094    -0.316595 -0.930634 -0.18354    0 0
  v -24.7316 -40.0004 71.3086    -0.405532 -0.889647 -0.209934    0 0
  v -27.2465 -38.1834 69.743    -0.457931 -0.813237 -0.359088    0 0
  v -25.2274 -39.8557 72.4978    -0.496496 -0.851778 0.167229    0 0
  v -27.5049 -38.6736 71.7451    -0.478787 -0.875919 -0.0594112    0 0
  v -31.6166 -36.3136 73.3001    -0.545957 -0.837781 -0.00738025    0 0
  v -30.144 -37.0356 71.4076    -0.546307 -0.807967 -0.220768    0 0
  v -29.49 -37.5358 72.6285    -0.451039 -0.881276 0.141127    0 0
  v -33.0057 -34.8439 71.617    -0.671707 -0.711272 -0.207126    0 0
  v -33.239 -35.0665 74.7693    -0.683504 -0.729925 -0.00564414    0 0
  v -34.24 -33.7959 77.2484    -0.757755 -0.643497 0.10825    0 0
  v -31.9863 -35.9361 75.3591    -0.429412 -0.897684 0.098834    0 0
  v -32.6104 -35.4006 77.3272    -0.569116 -0.817233 0.090758    0 0
  v -30.5518 -36.198 81.2963    -0.540651 -0.826889 0.15476    0 0
  v -32.5254 -35.0221 79.7976    -0.665167 -0.71937 0.20015    0 0
  v -31.4681 -35.8565 79.3244    -0.423281 -0.905173 0.0386627    0 0
  v -31.4984 -34.8142 82.786    -0.639769 -0.685177 0.348177    0 0
  v -28.6684 -36.9427 83.0577    -0.535525 -0.778568 0.327177    0 0
  v -25.6399 -38.1274 84.536    -0.453425 -0.787797 0.416872    0 0
  v -28.4075 -37.371 81.9147    -0.472437 -0.8808 -0.0315555    0 0
  v -26.2689 -38.5418 82.6919    -0.490435 -0.854914 0.169102    0 0
  v -23.5258 -39.9054 83.0109    -0.408382 -0.864547 0.292885    0 0
  v -24.3348 -39.7224 81.8348    -0.522932 -0.852049 -0.0235497    0 0
  v -24.6094 -32.4698 79.3959    -0.648703 -0.584358 -0.487555    0 0
  v -26.0183 -30.8345 78.3169    -0.476871 -0.847 -0.234915    0 0
  v -24.5992 -31.7443 76.753    -0.666997 -0.741272 0.0750401    0 0
  v -23.4081 -33.24 78.072    -0.818086 -0.532596 -0.216972    0 0
  v -28.7235 -30.2301 78.2358    0.275781 -0.851584 -0.445813    0 0
  v -27.7331 -29.9876 76.8561    -0.196018 -0.979649 0.0431964    0 0
  v -27.2719 -30.9469 79.4723    -0.0638686 -0.750336 -0.657965    0 0
  v -27.8138 -31.0642 74.3188    0.0279995 -0.699524 0.714061    0 0
  v -26.3139 -30.8975 75.2922    -0.435513 -0.824301 0.361739    0 0
  v -29.0152 -30.294 75.6427    0.340408 -0.833803 0.43462    0 0
  v -23.6257 -33.2846 75.4542    -0.775552 -0.51232 0.368846    0 0
  v -25.0773 -32.5677 74.2176    -0.567881 -0.539009 0.622077    0 0
  v -22.9682 -40.5159 80.5306    -0.695441 -0.678172 -0.237582    0 0
  v -22.286 -40.7429 78.8368    -0.934211 -0.286459 -0.21258    0 0
  v -21.9576 -41.2887 77.072    -0.797254 -0.599569 0.0700294    0 0
  v -22.316 -39.2914 78.6668    -0.958471 -0.00216091 -0.285181    0 0
  v -22.1627 -40.3751 77.0305    -0.996758 -0.0342754 0.0727987    0 0
  v -23.0943 -39.6678 80.1957    -0.768656 -0.119909 -0.628323    0 0
  v -23.5779 -39.767 73.9425    -0.664372 -0.0503568 0.745704    0 0
  v -22.5486 -40.7949 75.2943    -0.898334 -0.240603 0.367569    0 0
  v -22.5581 -39.3397 75.3282    -0.905611 0.0320003 0.4229    0 0
  v -23.5249 -40.6166 73.6897    -0.66044 -0.63015 0.408326    0 0
  v -25.218 -39.4757 73.0297    -0.431968 -0.350912 0.830821    0 0
  v -27.2609 -38.6664 72.5792    -0.396614 -0.762765 0.510771    0 0
  v -25.0642 -38.1019 73.1962    -0.286266 0.00255385 0.958147    0 0
  v -26.9766 -37.997 72.9406    -0.0411356 -0.15234 0.987472    0 0
  v -30.1546 -36.1799 74.1972    0.596756 -0.344636 0.724644    0 0
  v -28.9596 -37.4449 73.1753    0.0102605 -0.563685 0.825926    0 0
  v -28.5812 -36.1967 73.3369    0.341488 -0.0685097 0.937386    0 0
  v -30.7463 -36.67 73.9412    -0.206413 -0.915728 0.344726    0 0
  v -31.1667 -36.0307 75.5962    0.448786 -0.836859 0.313463    0 0
  v -31.6248 -35.8703 77.3583    -0.105299 -0.993766 0.0366128    0 0
  v -30.6559 -34.8669 75.6196    0.940412 -0.18032 0.288288    0 0
  v -30.9628 -35.4424 77.3202    0.883682 -0.458559 -0.093966    0 0
  v -29.4243 -36.0203 80.3658    0.486849 -0.384224 -0.784442    0 0
  v -30.7358 -35.9402 79.0818    0.417055 -0.830658 -0.368881    0 0
  v -30.2508 -34.7773 78.903    0.856677 -0.208603 -0.471795    0 0
  v -29.9253 -36.5156 80.6991    -0.214676 -0.93271 -0.289771    0 0
  v -28.0664 -37.2593 81.3464    -0.0717039 -0.601664 -0.795524    0 0
  v -26.3215 -38.4926 81.8511    -0.465274 -0.788698 -0.401841    0 0
  v -27.7447 -36.0152 81.035    0.225891 -0.156176 -0.961552    0 0
  v -26.1489 -37.8205 81.41    -0.16148 -0.237089 -0.957973    0 0
  v -24.4931 -39.3287 81.2576    -0.547342 -0.430343 -0.71779    0 0
  v -24.3906 -37.9616 80.9495    -0.417182 -0.0856715 -0.904776    0 0
  v -23.0156 -37.4445 79.9707    -0.757822 -0.0685312 -0.648853    0 0
  v -22.3663 -36.3584 78.4372    -0.954937 -0.15448 -0.253438    0 0
  v -22.1191 -38.1237 76.9203    -0.997326 -0.0126558 0.0719729    0 0
  v -22.5621 -34.8236 76.7831    -0.947284 -0.310978 0.0771107    0 0
  v -23.3445 -34.4265 79.4234    -0.782978 -0.372822 -0.497945    0 0
  v -23.7619 -34.5113 74.2283    -0.699991 -0.326255 0.635271    0 0
  v -22.5977 -36.4042 75.2749    -0.908605 -0.125425 0.39838    0 0
  v -23.4791 -37.5379 73.9441    -0.650978 -0.000287895 0.759097    0 0
  v -24.9722 -35.2315 73.2524    -0.346071 -0.1248 0.929871    0 0
  v -26.749 -35.837 72.9783    0.0294146 -0.0223962 0.999316    0 0
  v -26.5689 -32.8448 73.3699    -0.145507 -0.34486 0.927307    0 0
  v -29.2019 -31.5339 74.4337    0.491024 -0.494837 0.71696    0 0
  v -28.2984 -33.4287 73.3846    0.292373 -0.1679 0.94145    0 0
  v -29.8063 -34.0907 74.1892    0.715901 -0.0941537 0.691825    0 0
  v -30.2637 -32.1688 75.5499    0.916516 -0.258621 0.305146    0 0
  v -30.5813 -33.3803 77.1988    0.982169 -0.148627 -0.115124    0 0
  v -29.8849 -30.7189 77.0242    0.822204 -0.563538 -0.0800373    0 0
  v -28.6095 -31.4035 79.5703    0.383459 -0.538167 -0.750557    0 0
  v -29.8819 -32.0839 78.6619    0.832592 -0.281579 -0.476974    0 0
  v -29.0997 -33.9347 80.1342    0.596065 -0.159211 -0.786993    0 0
  v -27.5073 -33.2566 80.6844    0.17384 -0.25504 -0.951175    0 0
  v -25.9513 -35.667 81.1408    -0.0948356 -0.119616 -0.98828    0 0
  v -25.8782 -32.6976 80.4374    -0.266329 -0.429914 -0.862695    0 0
  v -24.3316 -35.0984 80.6025    -0.4749 -0.212236 -0.854064    0 0
  v 1.31948 -39.7557 57.1917    -1.87273e-009 -0.648889 -0.760883    0 0
  v -1.46665 -40.4349 58.0741    -0.121022 -0.723343 -0.6798    0 0
  v -4.76202 -40.703 59.2801    -0.241395 -0.656461 -0.714694    0 0
  v -3.39479 -39.6715 57.9385    -0.181194 -0.655847 -0.732826    0 0
  v -1.94382 -40.9024 59.003    0.0142611 -0.970957 -0.23883    0 0
  v -4.30575 -40.9956 59.4693    -0.132657 -0.836259 -0.532046    0 0
  v 1.31948 -40.5804 58.0714    -3.75145e-009 -0.884076 -0.467343    0 0
  v -8.62835 -41.4459 61.6309    -0.25824 -0.752789 -0.605492    0 0
  v -7.57245 -41.6514 61.5197    -0.0860656 -0.909571 -0.406538    0 0
  v -0.203642 -22.5279 109.536    -0.0254158 -0.337195 0.941092    0 0
  v -1.98568 -24.7435 108.559    -0.0829161 -0.420218 0.903627    0 0
  v -0.760633 -27.4165 107.149    -0.0318296 -0.536456 0.843328    0 0
  v -0.760633 -19.4999 110.313    -0.0653254 -0.20193 0.977219    0 0
  v -1.98568 -22.0428 109.583    -0.108162 -0.301604 0.947278    0 0
  v -4.67288 -26.6653 107.171    -0.160065 -0.492686 0.855359    0 0
  v -4.67288 -23.246 108.742    -0.169281 -0.347061 0.922438    0 0
  v -1.57385 -17.7749 110.568    -0.0821113 -0.145332 0.98597    0 0
  v -3.60681 -20.1173 109.874    -0.135308 -0.239443 0.961436    0 0
  v -2.34225 -16.6325 110.626    -0.0922321 -0.0815608 0.992392    0 0
  v -5.23266 -18.6375 109.971    -0.152199 -0.194786 0.968965    0 0
  v -7.23599 -21.5348 108.852    -0.191107 -0.303622 0.93343    0 0
  v -9.50113 -19.7135 108.891    -0.225496 -0.246888 0.942442    0 0
  v -2.92949 -15.4718 110.646    -0.0916051 -0.0476727 0.994654    0 0
  v -6.59277 -17.1752 109.997    -0.168254 -0.139597 0.975809    0 0
  v -3.29522 -14.2313 110.654    -0.0898799 -0.0216491 0.995717    0 0
  v -7.53043 -15.5487 110.018    -0.176346 -0.0840933 0.98073    0 0
  v -11.182 -17.6131 108.932    -0.254864 -0.175937 0.950837    0 0
  v -12.2073 -15.3195 108.974    -0.271394 -0.0877157 0.958463    0 0
  v -3.41815 -12.9424 110.657    -0.089875 2.42341e-007 0.995953    0 0
  v -8.01537 -13.8249 110.024    -0.18105 -0.024359 0.983172    0 0
  v -3.29522 -11.6535 110.654    -0.0912157 0.0219086 0.99559    0 0
  v -8.03116 -12.0757 110.015    -0.183484 0.0308894 0.982537    0 0
  v -12.6017 -12.9681 108.954    -0.282735 0.00829631 0.959162    0 0
  v -12.3189 -10.6554 108.91    -0.278895 0.0934143 0.955767    0 0
  v -2.92949 -10.4131 110.646    -0.0925682 0.0480573 0.994546    0 0
  v -7.56309 -10.367 110.002    -0.181308 0.0836467 0.979863    0 0
  v -2.34225 -9.25237 110.626    -0.092596 0.0817866 0.992339    0 0
  v -6.61386 -8.73466 109.99    -0.171986 0.137883 0.975402    0 0
  v -11.3032 -8.40743 108.888    -0.263773 0.170485 0.949399    0 0
  v -9.5433 -6.22126 108.877    -0.232554 0.241942 0.94201    0 0
  v -1.57385 -8.10999 110.568    -0.082164 0.145363 0.985961    0 0
  v -5.23688 -7.25236 109.969    -0.1537 0.193815 0.968923    0 0
  v -0.760633 -6.38497 110.313    -0.0653254 0.20193 0.977219    0 0
  v -3.60681 -5.76752 109.874    -0.13544 0.239285 0.961456    0 0
  v -7.2402 -4.35505 108.851    -0.193197 0.302119 0.933488    0 0
  v -4.67288 -2.63884 108.742    -0.16928 0.34706 0.922439    0 0
  v -0.203642 -3.35698 109.536    -0.0254158 0.337195 0.941092    0 0
  v -1.98568 -3.84203 109.583    -0.108163 0.301604 0.947278    0 0
  v -1.98568 -1.14139 108.559    -0.082916 0.420218 0.903627    0 0
  v -1.57385 -32.8367 102.712    -0.0563135 -0.691602 0.72008    0 0
  v -5.23493 -35.0283 99.9755    -0.123863 -0.733392 0.668426    0 0
  v -2.34225 -37.8261 97.0649    -0.065953 -0.791246 0.607931    0 0
  v -3.60681 -29.8472 105.14    -0.107918 -0.618572 0.778281    0 0
  v -7.23826 -31.8696 102.715    -0.174925 -0.660375 0.730278    0 0
  v -9.52386 -36.6149 97.0649    -0.197039 -0.761864 0.617041    0 0
  v -2.93537 -41.6257 91.0636    -0.0732343 -0.890468 0.449113    0 0
  v -7.63321 -42.4735 87.8791    -0.140941 -0.924773 0.353455    0 0
  v -3.35401 -43.9929 84.5127    -0.0736279 -0.971158 0.226783    0 0
  v -6.60413 -39.4008 94.1098    -0.139612 -0.828476 0.542343    0 0
  v -11.3031 -40.2526 91.0627    -0.214057 -0.853942 0.474302    0 0
  v -12.581 -42.7057 84.506    -0.184956 -0.948766 0.256191    0 0
  v -3.59927 -44.8542 77.2823    -0.0704048 -0.996853 0.0364233    0 0
  v -8.43474 -44.3534 73.756    -0.130084 -0.99088 -0.0351352    0 0
  v -3.54267 -44.6367 70.6896    -0.0670629 -0.992197 -0.105113    0 0
  v -8.20546 -44.0971 80.9131    -0.128493 -0.983507 0.12729    0 0
  v -12.6754 -43.7095 77.2071    -0.168175 -0.985105 0.035868    0 0
  v -12.9729 -43.355 70.269    -0.196381 -0.973806 -0.114618    0 0
  v -1.50561 -32.6059 51.3917    -0.0549602 -0.57802 -0.814169    0 0
  v -3.02005 -29.5863 49.4185    -0.105849 -0.564012 -0.818954    0 0
  v -3.57384 -37.5574 55.7714    -0.115809 -0.704377 -0.700315    0 0
  v -5.64255 -34.6891 53.507    -0.126432 -0.638772 -0.758937    0 0
  v -6.95669 -31.613 51.3965    -0.161289 -0.589094 -0.791805    0 0
  v -10.6651 -36.1309 55.9245    -0.202458 -0.693568 -0.691357    0 0
  v -0.515223 2.46882 44.7367    -0.102102 0.928913 0.355942    0 0
  v -2.07608 1.61402 46.1521    -0.211216 0.895809 0.391042    0 0
  v -0.746323 3.50455 41.5883    -0.0974676 0.959165 0.265523    0 0
  v -2.5752 2.70431 43.2306    -0.191307 0.924895 0.328589    0 0
  v -4.12138 1.6947 44.7367    -0.284879 0.884799 0.368747    0 0
  v -4.79276 2.67332 41.5883    -0.288333 0.916044 0.278797    0 0
  v -0.91042 4.28157 37.7966    -0.0994517 0.984209 0.146432    0 0
  v -2.97255 3.61134 39.7645    -0.195873 0.958211 0.208484    0 0
  v -0.984468 4.64352 33.5791    -0.100364 0.994647 0.0245691    0 0
  v -3.2131 4.181 35.7223    -0.198605 0.976059 0.0886827    0 0
  v -5.26922 3.39346 37.7966    -0.294365 0.943325 0.153256    0 0
  v -5.4841 3.72896 33.5791    -0.29706 0.954514 0.0256415    0 0
  v -0.952522 4.48577 29.2297    -0.100018 0.990745 -0.0917649    0 0
  v -3.25455 4.28167 31.4043    -0.199146 0.979257 -0.037361    0 0
  v -0.831569 3.88853 25.0062    -0.0987925 0.9767 -0.190521    0 0
  v -3.09799 3.90146 27.0865    -0.197596 0.969551 -0.14466    0 0
  v -5.39141 3.58273 29.2297    -0.296067 0.950356 -0.0957474    0 0
  v -5.04047 3.02909 25.0062    -0.292599 0.935384 -0.198602    0 0
  v -0.63857 2.93554 21.1642    -0.0958242 0.943994 -0.315744    0 0
  v -2.7878 3.1482 23.0204    -0.194296 0.948871 -0.248782    0 0
  v -0.357374 1.54705 17.9815    -0.0866689 0.848314 -0.522352    0 0
  v -2.3248 2.02383 19.4729    -0.184202 0.892111 -0.412562    0 0
  v -4.48049 2.14567 21.1642    -0.283908 0.900888 -0.328324    0 0
  v -3.66461 0.85854 17.9815    -0.256217 0.802257 -0.539199    0 0
  v 0.0192073 -0.318295 15.6837    -0.0695021 0.679754 -0.730139    0 0
  v -1.66617 0.424397 16.7254    -0.157045 0.748645 -0.644102    0 0
  v 0.411479 -2.30802 14.1605    -0.0488462 0.52487 -0.849779    0 0
  v -0.873516 -1.48989 14.838    -0.12764 0.581312 -0.803607    0 0
  v -2.56196 -0.873043 15.682    -0.209078 0.630531 -0.747473    0 0
  v -1.33364 -2.73919 14.1433    -0.177993 0.4676 -0.865834    0 0
  v 0.666854 -4.01865 13.261    -0.046063 0.384165 -0.922114    0 0
  v -0.112829 -3.29468 13.6493    -0.105427 0.438087 -0.892729    0 0
  v -0.105855 -4.29277 13.2249    -0.12687 0.342945 -0.930748    0 0
  v 4.28442 -30.1288 59.9359    -0.255398 -0.172139 0.951389    0 0
  v 6.11932 -29.5746 60.8389    -0.457688 -0.835645 0.303675    0 0
  v 3.73281 -29.0562 60.4525    -0.0541796 -0.937401 -0.344012    0 0
  v 1.31948 -29.0572 59.7514    -2.2342e-009 -0.746737 0.66512    0 0
  v 8.22619 -31.7452 62.29    -0.229707 -0.436787 -0.869742    0 0
  v 6.11932 -29.9969 61.4734    -0.0113012 -0.591846 -0.805972    0 0
  v 8.22619 -31.335 61.6718    -0.781771 -0.45895 0.422136    0 0
  v 1.31948 -29.7718 60.825    3.77895e-009 -0.521633 -0.85317    0 0
  v 4.28442 -31.3169 61.7252    0.111643 -0.265804 -0.957541    0 0
  v 4.58279 -40.9024 59.003    -0.0142613 -0.970957 -0.23883    0 0
  v 7.86969 -41.3057 60.4806    -0.297315 -0.886043 0.355713    0 0
  v 4.79222 -40.7002 59.5175    -0.260041 -0.37277 0.890742    0 0
  v 1.31948 -40.791 58.8093    0 -0.919009 0.394236    0 0
  v 11.5069 -42.1903 63.012    -0.137579 -0.879525 -0.45553    0 0
  v 10.1159 -41.5096 61.9507    -0.625229 -0.473128 0.620676    0 0
  v 10.2114 -41.6514 61.5197    0.0860699 -0.909568 -0.406543    0 0
  v 9.75132 -39.5538 62.0257    -0.642041 -0.0692477 0.763537    0 0
  v 7.76155 -40.3782 60.7399    -0.441537 -0.123578 0.888692    0 0
  v 10.7679 -41.2349 62.9253    -0.894682 -0.250289 -0.37    0 0
  v 1.31948 -39.8448 59.0942    0 -0.0944004 0.995534    0 0
  v 4.69222 -38.7203 59.6717    -0.256891 -0.037202 0.965724    0 0
  v 8.23596 -42.6563 63.1397    0.0984787 -0.7606 -0.641708    0 0
  v 10.1769 -42.1675 63.1318    0.0150422 -0.287937 -0.957531    0 0
  v 1.31948 -42.7317 62.5215    9.55172e-010 -0.804568 -0.593861    0 0
  v 4.85326 -42.336 62.4287    0.0978632 -0.397805 -0.912236    0 0
  v 4.69222 -40.3738 62.3223    0.113094 0.00793722 -0.993553    0 0
  v 7.76155 -41.5903 62.7636    0.145732 -0.0352103 -0.988697    0 0
  v 1.31948 -41.6225 62.0623    3.74784e-009 -0.0789446 -0.996879    0 0
  v 9.75132 -40.2152 63.0859    -0.00804 0.00800462 -0.999936    0 0
  v -2.55427 -43.0074 63.4186    -0.0463798 -0.924392 -0.378615    0 0
  v -5.59699 -42.6563 63.1397    -0.0984785 -0.760602 -0.641706    0 0
  v -2.2143 -42.336 62.4287    -0.0978632 -0.397805 -0.912236    0 0
  v -8.8679 -42.1903 63.012    0.137579 -0.879525 -0.45553    0 0
  v -7.53796 -42.1675 63.1318    -0.0150423 -0.287937 -0.957531    0 0
  v -8.56549 -42.6364 63.7889    -0.121886 -0.912928 -0.389494    0 0
  v -7.11236 -40.2152 63.0859    0.00804006 0.00800461 -0.999936    0 0
  v -5.12259 -41.5903 62.7636    -0.145732 -0.0352103 -0.988697    0 0
  v -8.12889 -41.2349 62.9253    0.894682 -0.250289 -0.37    0 0
  v -2.05325 -40.3738 62.3223    -0.113094 0.00793725 -0.993553    0 0
  v -5.23072 -41.3057 60.4806    0.297313 -0.886045 0.355709    0 0
  v -7.47692 -41.5096 61.9507    0.625229 -0.473127 0.620677    0 0
  v -2.15325 -40.7002 59.5175    0.260041 -0.372769 0.890742    0 0
  v -2.05325 -38.7203 59.6717    0.256891 -0.0372021 0.965724    0 0
  v -5.12259 -40.3782 60.7399    0.441537 -0.123576 0.888692    0 0
  v -7.11236 -39.5538 62.0257    0.642041 -0.0692477 0.763537    0 0
  v 7.57245 -37.0612 60.8162    -0.43783 -0.0289118 0.898593    0 0
  v 4.60101 -34.2969 59.7557    -0.257388 -0.0324265 0.965764    0 0
  v 1.31948 -36.5111 59.1909    1.13127e-008 -0.0214991 0.999769    0 0
  v 10.4905 -37.948 62.9659    -0.936675 -0.0822235 -0.340411    0 0
  v 9.44478 -35.201 62.0136    -0.65081 -0.0713354 0.755882    0 0
  v 7.18808 -32.3997 60.8161    -0.443435 -0.0736023 0.893279    0 0
  v 9.57076 -33.5544 62.5996    -0.823991 -0.442407 -0.353998    0 0
  v 1.31948 -31.819 59.3387    -1.50856e-008 -0.0638435 0.99796    0 0
  v 7.57245 -38.3235 62.7826    0.151882 -0.00230537 -0.988396    0 0
  v 9.44478 -35.8615 63.0241    0.000265395 -0.0754845 -0.997147    0 0
  v 1.31948 -38.3624 62.0749    -5.60507e-009 -0.00811681 -0.999967    0 0
  v 4.60101 -35.948 62.2819    0.116147 -0.0427076 -0.992313    0 0
  v 7.18808 -33.5277 62.5242    0.138237 -0.113278 -0.9839    0 0
  v 1.31948 -33.4734 61.8438    1.87094e-009 -0.121831 -0.992551    0 0
  v -4.93349 -38.3235 62.7826    -0.151882 -0.00230538 -0.988396    0 0
  v -1.96205 -35.948 62.2819    -0.116147 -0.0427076 -0.992313    0 0
  v -7.85154 -37.948 62.9659    0.936675 -0.0822233 -0.340411    0 0
  v -6.80581 -35.8615 63.0241    -0.00026547 -0.0754845 -0.997147    0 0
  v -5.58722 -31.7452 62.29    0.229707 -0.436787 -0.869743    0 0
  v -4.54911 -33.5277 62.5242    -0.138237 -0.113279 -0.9839    0 0
  v -6.93179 -33.5544 62.5996    0.823991 -0.442408 -0.353997    0 0
  v -1.64546 -31.3169 61.7252    -0.111643 -0.265804 -0.957541    0 0
  v -4.93349 -37.0612 60.8162    0.43783 -0.0289111 0.898593    0 0
  v -6.80581 -35.201 62.0136    0.65081 -0.0713356 0.755882    0 0
  v -1.96205 -34.2969 59.7557    0.257388 -0.0324265 0.965764    0 0
  v -1.64546 -30.1288 59.9359    0.255398 -0.172139 0.951388    0 0
  v -4.54911 -32.3997 60.8161    0.443435 -0.073603 0.893279    0 0
  v -5.58722 -31.335 61.6718    0.781771 -0.458949 0.422137    0 0
  v -0.333423 -14.6175 12.2913    -0.0573673 -0.0331959 -0.997801    0 0
  v 0.658604 -15.6526 12.2723    -0.0484234 -0.0342706 -0.998239    0 0
  v -0.735327 -12.9315 12.2947    -0.0720005 0.00850999 -0.997368    0 0
  v -0.374425 -11.2724 12.2996    -0.0668811 0.0279528 -0.997369    0 0
  v 0.655347 -10.2349 12.2727    -0.0492098 0.0340862 -0.998207    0 0
  v 1.98362 -10.2349 12.2727    0.0492105 0.034088 -0.998207    0 0
  v 3.01339 -11.2724 12.2996    0.0668811 0.0279528 -0.997369    0 0
  v 3.37429 -12.9315 12.2947    0.0720029 0.00850985 -0.997368    0 0
  v 2.97239 -14.6175 12.2913    0.0573693 -0.0331968 -0.997801    0 0
  v 1.98036 -15.6526 12.2723    0.0484241 -0.0342724 -0.998239    0 0
  v 11.2673 -41.4459 61.6309    0.258239 -0.752791 -0.605491    0 0
  v 11.3803 -40.4472 60.4088    0.220053 -0.75947 -0.612195    0 0
  v 15.1711 -41.3222 63.3296    0.287746 -0.816909 -0.499861    0 0
  v 12.0189 -38.6621 58.3778    0.195475 -0.754592 -0.626402    0 0
  v 6.03375 -39.6715 57.9385    0.181194 -0.655846 -0.732826    0 0
  v 16.8392 -39.5572 61.5191    0.281416 -0.792909 -0.540462    0 0
  v 6.94471 -40.9956 59.4693    0.132659 -0.836257 -0.532048    0 0
  v 7.40098 -40.703 59.2801    0.241395 -0.656462 -0.714693    0 0
  v 4.10562 -40.4349 58.0741    0.121022 -0.723343 -0.6798    0 0
  v -6.51969 -43.2049 64.7202    -0.0909424 -0.947437 -0.306745    0 0
  v -10.4364 -43.0369 65.9626    -0.181037 -0.949546 -0.256103    0 0
  v -10.8465 -42.269 63.9994    -0.26086 -0.866981 -0.424613    0 0
  v -3.0972 -43.8507 66.07    -0.0528389 -0.967232 -0.248335    0 0
  v -7.82202 -43.8743 68.1161    -0.120397 -0.978432 -0.167852    0 0
  v -14.6165 -42.2254 66.7021    -0.278019 -0.905038 -0.321887    0 0
  v -12.5321 -41.3222 63.3296    -0.287746 -0.816909 -0.499862    0 0
  v -8.74138 -40.4472 60.4088    -0.220053 -0.75947 -0.612194    0 0
  v -14.2002 -39.5572 61.5191    -0.281416 -0.792909 -0.540462    0 0
  v -9.37998 -38.6621 58.3778    -0.195475 -0.754592 -0.626402    0 0
  v -3.48035 -29.9969 61.4734    0.0113004 -0.591844 -0.805973    0 0
  v -1.09384 -29.0562 60.4525    0.0541786 -0.9374 -0.344014    0 0
  v -3.48035 -29.5746 60.8389    0.457688 -0.835645 0.303676    0 0
  v 7.50106 -25.881 47.5221    0.36667 -0.814716 0.449212    0 0
  v 12.8679 -21.9139 47.5221    0.627639 -0.559383 0.541443    0 0
  v 15.9146 -16.1443 47.5221    0.778497 -0.195649 0.596375    0 0
  v 15.9146 -9.74053 47.5221    0.762578 0.19449 0.616968    0 0
  v 12.8679 -3.97093 47.5221    0.626346 0.559251 0.543074    0 0
  v 7.50106 -0.00383633 47.5221    0.36667 0.814716 0.449212    0 0
  v 1.31948 10.8007 54.5622    0.0989814 0.727784 -0.678626    0 0
  v 1.31948 10.8007 54.5622    -0.042249 0.813646 -0.579824    0 0
  v 1.31948 10.8007 54.5622    -0.0989814 0.727784 -0.678626    0 0
  v 1.31948 -27.2189 47.5221    0 -0.564112 -0.825699    0 0
  v 1.31948 1.74241 47.5221    3.77498e-009 0.952791 0.303627    0 0
  v 1.31948 1.74241 47.5221    -0.106861 0.545852 -0.831039    0 0
  v -4.86209 -25.881 47.5221    -0.366669 -0.814716 0.449212    0 0
  v -10.229 -21.9139 47.5221    -0.627639 -0.559383 0.541443    0 0
  v -13.2756 -16.1443 47.5221    -0.778497 -0.19565 0.596375    0 0
  v -13.2756 -9.74053 47.5221    -0.762578 0.19449 0.616966    0 0
  v -10.229 -3.97093 47.5221    -0.626346 0.559251 0.543074    0 0
  v -4.86209 -0.00383633 47.5221    -0.36667 0.814716 0.449212    0 0
  v 17.0546 -28.4544 51.4172    0.261574 -0.417592 -0.87017    0 0
  v 24.3846 -21.5527 51.4183    0.336404 -0.20856 -0.918333    0 0
  v 27.0064 -12.9424 51.4183    0.355748 2.32906e-009 -0.934582    0 0
  v 24.3846 -4.33219 51.4183    0.336403 0.20856 -0.918333    0 0
  v 17.0509 2.5705 51.4183    0.261442 0.418432 -0.869806    0 0
  v 6.82923 6.37296 51.3964    0.139888 0.553393 -0.82109    0 0
  v 6.82923 6.37296 51.3964    0.116211 0.565721 -0.816367    0 0
  v 6.82923 6.37296 51.3964    0.122763 0.621193 -0.773982    0 0
  v 11.7615 -0.828174 44.7368    0.5231 0.742284 0.418786    0 0
  v 16.6255 -6.01155 44.7473    0.739911 0.438454 0.510187    0 0
  v 18.2932 -12.6727 45.0155    0.745473 0.145293 0.650507    0 0
  v 16.461 -19.9043 45.0156    0.59544 -0.515416 0.616277    0 0
  v 11.7514 -25.0611 44.7439    0.520109 -0.742973 0.421281    0 0
  v 4.97308 -28.0508 44.7367    0.19 -0.914338 0.357612    0 0
  v 6.91989 -32.2106 51.3888    0.115799 -0.606052 -0.786951    0 0
  v 4.97308 2.17103 44.7367    0.192754 0.915322 0.353597    0 0
  v -14.4156 -28.4544 51.4172    -0.261574 -0.417592 -0.87017    0 0
  v -21.7457 -21.5527 51.4183    -0.336403 -0.20856 -0.918333    0 0
  v -24.3674 -12.9424 51.4183    -0.355748 5.58975e-009 -0.934582    0 0
  v -21.7457 -4.3322 51.4183    -0.336403 0.20856 -0.918333    0 0
  v -14.412 2.5705 51.4183    -0.261442 0.418432 -0.869806    0 0
  v -4.19027 6.37296 51.3964    -0.126377 0.580514 -0.804383    0 0
  v -9.12256 -0.828174 44.7368    -0.5231 0.742284 0.418786    0 0
  v -13.9865 -6.01155 44.7473    -0.73991 0.438454 0.510187    0 0
  v -15.6542 -12.6727 45.0155    -0.745474 0.145293 0.650507    0 0
  v -13.822 -19.9043 45.0156    -0.595439 -0.515416 0.616278    0 0
  v -9.11242 -25.0611 44.7439    -0.520109 -0.742973 0.421281    0 0
  v -2.33412 -28.0508 44.7367    -0.19 -0.914338 0.357612    0 0
  v -4.28092 -32.2106 51.3888    -0.115799 -0.606052 -0.786951    0 0
  v -2.33412 2.17103 44.7367    -0.192754 0.915322 0.353597    0 0
  v 8.88774 11.1033 56.0083    0.119924 0.709842 -0.694077    0 0
  v 4.44852 -26.8892 47.5221    0.107835 -0.53808 -0.835967    0 0
  v 12.1801 -30.794 51.4074    0.194354 -0.504016 -0.841543    0 0
  v 10.3803 -24.1879 47.5221    0.513026 -0.704336 0.490628    0 0
  v 21.234 -25.3173 51.4183    0.341633 -0.372713 -0.86277    0 0
  v 14.7453 -19.1846 47.5221    0.717041 -0.383572 0.582    0 0
  v 26.3468 -17.359 51.4183    0.404015 -0.126178 -0.906008    0 0
  v 16.3076 -12.9424 47.5221    0.791264 0.000193983 0.611474    0 0
  v 26.3468 -8.52587 51.4183    0.404015 0.126178 -0.906008    0 0
  v 14.7453 -6.70022 47.5221    0.70733 0.383312 0.593933    0 0
  v 21.234 -0.567517 51.4183    0.341633 0.372714 -0.86277    0 0
  v 10.3803 -1.69693 47.5221    0.513078 0.704334 0.490575    0 0
  v 12.1439 4.91807 51.4181    0.20435 0.569949 -0.795864    0 0
  v 8.50017 1.03439 44.7367    0.371417 0.845574 0.383477    0 0
  v 14.5416 -3.23835 44.7378    0.642267 0.611735 0.461815    0 0
  v 17.8791 -9.11551 44.8133    0.809527 0.223709 0.542789    0 0
  v 17.22 -16.3604 45.9063    0.540838 -0.137561 0.829802    0 0
  v 14.4402 -22.6909 44.8086    0.637479 -0.609648 0.471116    0 0
  v 8.50017 -26.9192 44.7367    0.371417 -0.845574 0.383476    0 0
  v 4.44852 1.04514 47.5221    0.12001 0.537396 -0.834747    0 0
  v 4.44852 1.04514 47.5221    0.222974 0.887096 0.404158    0 0
  v 1.31948 -32.753 51.3959    -1.86386e-009 -0.616764 -0.787148    0 0
  v 1.31948 7.21454 51.2475    -0.107357 0.596787 -0.795185    0 0
  v 1.31948 2.57308 44.7367    9.32532e-010 0.942298 0.334774    0 0
  v 1.31948 -28.4273 44.7367    -9.32391e-010 -0.937251 0.348655    0 0
  v -6.24878 11.1033 56.0083    -0.119924 0.709842 -0.694077    0 0
  v -9.54116 -30.794 51.4074    -0.194354 -0.504016 -0.841543    0 0
  v -7.74135 -24.1879 47.5221    -0.513026 -0.704336 0.490628    0 0
  v -18.595 -25.3173 51.4183    -0.307606 -0.31574 -0.897601    0 0
  v -12.1064 -19.1846 47.5221    -0.717041 -0.383572 0.582    0 0
  v -23.7079 -17.359 51.4183    -0.351192 -0.103215 -0.930597    0 0
  v -13.6686 -12.9424 47.5221    -0.791265 0.000194607 0.611474    0 0
  v -23.7079 -8.52587 51.4183    -0.351192 0.103215 -0.930597    0 0
  v -12.1064 -6.70022 47.5221    -0.70733 0.383312 0.593933    0 0
  v -18.595 -0.567517 51.4183    -0.307606 0.31574 -0.897601    0 0
  v -7.74135 -1.69693 47.5221    -0.513079 0.704334 0.490575    0 0
  v -9.50489 4.91806 51.4181    -0.193972 0.507651 -0.839443    0 0
  v -1.80956 1.04514 47.5221    -0.222974 0.887096 0.404158    0 0
  v -11.9026 -3.23835 44.7378    -0.629012 0.582522 0.514794    0 0
  v -5.86121 1.03439 44.7367    -0.371417 0.845574 0.383476    0 0
  v -15.2401 -9.11551 44.8133    -0.779549 0.206083 0.591466    0 0
  v -14.581 -16.3604 45.9063    -0.723123 -0.182979 0.666041    0 0
  v -11.8012 -22.6909 44.8086    -0.629422 -0.580966 0.516048    0 0
  v -5.86121 -26.9192 44.7367    -0.367137 -0.826689 0.426375    0 0
  v -1.80956 -26.8892 47.5221    -0.107835 -0.53808 -0.835967    0 0
  v 5.5286 13.5428 58.7167    0.0806959 0.844978 -0.528679    0 0
  v 11.869 -27.4536 49.4185    0.231115 -0.46305 -0.855669    0 0
  v 15.5349 -25.0685 49.4185    0.286715 -0.368442 -0.884333    0 0
  v 18.4966 -22.0666 49.4185    0.324204 -0.261827 -0.909032    0 0
  v 20.5583 -18.6061 49.4185    0.345248 -0.155907 -0.925471    0 0
  v 21.6153 -14.8628 49.4185    0.354695 -0.0511261 -0.933583    0 0
  v 21.6153 -11.022 49.4185    0.354695 0.051126 -0.933583    0 0
  v 20.5583 -7.27871 49.4185    0.345248 0.155907 -0.925471    0 0
  v 18.4966 -3.81825 49.4185    0.324204 0.261827 -0.909032    0 0
  v 15.5349 -0.816351 49.4185    0.286681 0.368647 -0.884259    0 0
  v 11.869 1.56877 49.4185    0.230911 0.465103 -0.854611    0 0
  v 7.78602 3.19637 49.4185    0.156691 0.540423 -0.826675    0 0
  v 3.4978 4.20305 49.4185    0.116211 0.565721 -0.816367    0 0
  v 3.4978 4.20305 49.4185    0.12001 0.537396 -0.834747    0 0
  v 4.63478 9.15618 53.2821    0.12156 0.666705 -0.735341    0 0
  v 9.58549 -0.285746 46.1521    0.446082 0.77656 0.444934    0 0
  v 12.4696 -2.36685 46.1524    0.575317 0.655802 0.488809    0 0
  v 14.8002 -4.92605 46.1533    0.676259 0.499276 0.541661    0 0
  v 16.4078 -7.85111 46.173    0.751448 0.309044 0.582938    0 0
  v 17.1872 -11.0861 46.2472    0.790027 0.114169 0.602348    0 0
  v 16.9721 -14.5202 46.528    0.750312 -0.0732649 0.657012    0 0
  v 16.1126 -17.934 46.5272    0.704209 -0.29786 0.644491    0 0
  v 14.7 -20.9719 46.2451    0.667515 -0.502146 0.549794    0 0
  v 12.4496 -23.5206 46.1707    0.574514 -0.65532 0.490397    0 0
  v 9.58549 -25.5991 46.1521    0.445822 -0.776612 0.445104    0 0
  v 6.38098 -27.0336 46.1521    0.279904 -0.867986 0.410187    0 0
  v 3.02363 -27.744 46.1521    0.0947392 -0.915767 0.390379    0 0
  v 3.4978 -29.888 49.4185    0.0541754 -0.577888 -0.814316    0 0
  v 7.78603 -29.0812 49.4185    0.151419 -0.538417 -0.828963    0 0
  v 3.02363 1.94082 46.1521    0.112635 0.926554 0.358904    0 0
  v 6.38098 1.14874 46.1521    0.283192 0.867782 0.408358    0 0
  v -2.88964 13.5428 58.7167    -0.0806958 0.844978 -0.528678    0 0
  v -12.8959 -25.0685 49.4185    -0.286715 -0.368442 -0.884333    0 0
  v -9.23006 -27.4536 49.4185    -0.231115 -0.46305 -0.855669    0 0
  v -17.9193 -18.6061 49.4185    -0.345248 -0.155907 -0.925471    0 0
  v -15.8576 -22.0666 49.4185    -0.324204 -0.261827 -0.909032    0 0
  v -18.9764 -11.022 49.4185    -0.354695 0.051126 -0.933583    0 0
  v -18.9764 -14.8628 49.4185    -0.354695 -0.051126 -0.933583    0 0
  v -15.8576 -3.81825 49.4185    -0.324204 0.261827 -0.909032    0 0
  v -17.9193 -7.27871 49.4185    -0.345248 0.155907 -0.925471    0 0
  v -9.23006 1.56877 49.4185    -0.230911 0.465103 -0.854611    0 0
  v -12.8959 -0.816351 49.4185    -0.286681 0.368647 -0.884259    0 0
  v -1.99581 9.15618 53.2821    -0.12156 0.666705 -0.735342    0 0
  v -0.858833 4.20305 49.4185    -0.116212 0.56572 -0.816367    0 0
  v -5.14706 3.19637 49.4185    -0.156691 0.540423 -0.826675    0 0
  v -6.94653 -0.285746 46.1521    -0.446082 0.776559 0.444934    0 0
  v -9.83065 -2.36685 46.1524    -0.575317 0.655801 0.488809    0 0
  v -12.1612 -4.92605 46.1533    -0.676259 0.499276 0.541661    0 0
  v -13.7688 -7.85111 46.173    -0.751449 0.309043 0.582938    0 0
  v -14.5482 -11.0861 46.2472    -0.790026 0.114169 0.602349    0 0
  v -14.3331 -14.5202 46.528    -0.750313 -0.0732653 0.65701    0 0
  v -13.4737 -17.934 46.5272    -0.70421 -0.297861 0.64449    0 0
  v -12.0611 -20.9719 46.2451    -0.667515 -0.502146 0.549793    0 0
  v -9.81063 -23.5206 46.1707    -0.574514 -0.65532 0.490396    0 0
  v -6.94653 -25.5991 46.1521    -0.445822 -0.776612 0.445103    0 0
  v -3.74201 -27.0336 46.1521    -0.279904 -0.867986 0.410187    0 0
  v -0.384665 -27.744 46.1521    -0.0947392 -0.915767 0.390379    0 0
  v -0.858834 -29.888 49.4185    -0.0541757 -0.577888 -0.814316    0 0
  v -5.14706 -29.0812 49.4185    -0.151419 -0.538418 -0.828962    0 0
  v -0.384664 1.94082 46.1521    -0.112635 0.926554 0.358904    0 0
  v -3.74201 1.14874 46.1521    -0.283192 0.867782 0.408358    0 0
  v 1.31948 13.6032 58.5452    0 0.867292 -0.4978    0 0
  v 1.31948 13.6032 58.5452    -0.0351732 0.817334 -0.575089    0 0
  v 5.12222 11.3357 55.6244    0.109352 0.802222 -0.586926    0 0
  v 5.12222 11.3357 55.6244    0.0910776 0.719517 -0.688476    0 0
  v 14.6815 -29.7342 51.4139    0.226184 -0.468367 -0.854092    0 0
  v 8.97473 -25.1147 47.5221    0.447318 -0.761712 0.468724    0 0
  v 13.772 -26.347 49.4185    0.266988 -0.410887 -0.871716    0 0
  v 9.86173 -28.3709 49.4185    0.199156 -0.500842 -0.842315    0 0
  v 17.1217 -23.6358 49.4185    0.311478 -0.307567 -0.899102    0 0
  v 19.2538 -26.9753 51.4183    0.318219 -0.423883 -0.847974    0 0
  v 11.688 -23.1159 47.5221    0.57813 -0.632651 0.515284    0 0
  v 22.9497 -23.5013 51.4183    0.32115 -0.268919 -0.908044    0 0
  v 13.8903 -20.5974 47.5221    0.678605 -0.466703 0.567171    0 0
  v 19.6465 -20.3827 49.4185    0.338186 -0.201648 -0.919221    0 0
  v 21.2189 -16.7589 49.4185    0.35143 -0.0993174 -0.930931    0 0
  v 25.5224 -19.4967 51.4183    0.395531 -0.185134 -0.8996    0 0
  v 15.4233 -17.6941 47.5221    0.752769 -0.289351 0.591282    0 0
  v 26.8415 -15.1648 51.4183    0.354216 -0.0529266 -0.933665    0 0
  v 16.2093 -14.5536 47.5221    0.791202 -0.0972379 0.603775    0 0
  v 21.7475 -12.9424 49.4185    0.355441 4.65801e-009 -0.934699    0 0
  v 21.219 -9.12598 49.4185    0.35143 0.0993175 -0.930931    0 0
  v 26.8415 -10.72 51.4183    0.40923 0.0611354 -0.910381    0 0
  v 16.2093 -11.3313 47.5221    0.780874 0.0956474 0.617323    0 0
  v 25.5224 -6.38811 51.4183    0.343819 0.16096 -0.925138    0 0
  v 15.4233 -8.19071 47.5221    0.739055 0.284085 0.610814    0 0
  v 19.6465 -5.50214 49.4185    0.338186 0.201648 -0.919222    0 0
  v 17.1217 -2.249 49.4185    0.311477 0.307568 -0.899102    0 0
  v 22.9497 -2.38352 51.4183    0.36645 0.306789 -0.878405    0 0
  v 13.8903 -5.28749 47.5221    0.67583 0.46486 0.571979    0 0
  v 19.2538 1.09041 51.4183    0.28188 0.376011 -0.8827    0 0
  v 11.688 -2.76897 47.5221    0.578023 0.632549 0.51553    0 0
  v 13.772 0.462106 49.4185    0.267167 0.411161 -0.871532    0 0
  v 9.86173 2.48606 49.4185    0.200156 0.503323 -0.840597    0 0
  v 14.667 3.85297 51.4182    0.250845 0.524798 -0.813428    0 0
  v 8.97473 -0.770115 47.5221    0.447318 0.761712 0.468724    0 0
  v 9.52313 5.74602 51.4178    0.15207 0.543665 -0.825411    0 0
  v 7.9189 8.82482 53.5375    0.124334 0.663835 -0.737472    0 0
  v 5.98913 0.586594 47.5221    0.292622 0.852353 0.433435    0 0
  v 5.65901 3.75146 49.4185    0.144584 0.554032 -0.819844    0 0
  v 5.65901 3.75146 49.4185    0.117858 0.564038 -0.817294    0 0
  v 5.65901 3.75146 49.4185    0.112029 0.536142 -0.836661    0 0
  v 1.31948 4.6029 49.4185    -0.102821 0.560156 -0.821981    0 0
  v 4.08655 6.83498 51.3325    0.114564 0.567399 -0.815434    0 0
  v 4.08655 6.83498 51.3325    0.122654 0.621145 -0.774038    0 0
  v 2.88878 1.41576 47.5221    0.127983 0.538613 -0.832777    0 0
  v 2.88878 1.41576 47.5221    0.20226 0.907654 0.367772    0 0
  v 1.31948 9.32852 52.9419    -0.109704 0.680781 -0.724225    0 0
  v 11.0822 -1.256 46.1522    0.517764 0.717798 0.465496    0 0
  v 10.1767 0.184685 44.7367    0.454289 0.795804 0.400396    0 0
  v 8.00871 0.522858 46.1521    0.369033 0.825745 0.426568    0 0
  v 13.7187 -3.59722 46.1527    0.633881 0.577014 0.515024    0 0
  v 13.226 -1.97794 44.7372    0.588631 0.678667 0.439232    0 0
  v 15.7009 -6.34634 46.1586    0.72045 0.399639 0.566781    0 0
  v 15.6798 -4.58318 44.7389    0.69797 0.525534 0.486469    0 0
  v 16.9076 -9.43337 46.2011    0.780097 0.201645 0.592274    0 0
  v 17.3636 -7.52261 44.7698    0.781773 0.326935 0.530985    0 0
  v 17.2181 -12.7887 46.345    0.777448 0.00288978 0.62894    0 0
  v 18.1569 -10.7894 44.8846    0.827532 0.128864 0.546429    0 0
  v 16.565 -16.2467 46.6405    0.719686 -0.181661 0.670113    0 0
  v 17.6993 -14.6076 45.7048    0.595808 0.0135809 0.803012    0 0
  v 15.522 -19.5273 46.3435    0.699943 -0.382093 0.603394    0 0
  v 16.8191 -18.0809 45.7059    0.524409 -0.30614 0.794527    0 0
  v 13.6686 -22.2942 46.1986    0.634748 -0.574806 0.516424    0 0
  v 15.477 -21.3906 44.8805    0.685835 -0.535245 0.493096    0 0
  v 11.0772 -24.6295 46.1568    0.517609 -0.717463 0.466184    0 0
  v 13.1854 -23.9247 44.7655    0.58653 -0.676471 0.445388    0 0
  v 8.00871 -26.4077 46.1521    0.369033 -0.825744 0.426569    0 0
  v 10.1767 -26.0695 44.7367    0.453997 -0.795997 0.400345    0 0
  v 5.98913 -26.4714 47.5221    0.165418 -0.502654 -0.848514    0 0
  v 4.71504 -27.4784 46.1521    0.189698 -0.897739 0.397591    0 0
  v 6.76035 -27.5795 44.7367    0.283708 -0.885229 0.368618    0 0
  v 1.31948 -27.832 46.1521    1.86475e-009 -0.921776 0.387723    0 0
  v 3.15419 -28.3333 44.7367    0.0959259 -0.931595 0.350613    0 0
  v 2.88878 -27.1373 47.5221    0.0585908 -0.557789 -0.827912    0 0
  v 5.65902 -29.5863 49.4185    0.105848 -0.564012 -0.818955    0 0
  v 4.14457 -32.6059 51.3917    0.0585403 -0.614802 -0.786506    0 0
  v 1.31948 -29.9879 49.4185    0 -0.581699 -0.813404    0 0
  v 9.59566 -31.613 51.3965    0.161289 -0.589094 -0.791805    0 0
  v 4.71504 1.61402 46.1521    0.211216 0.895809 0.391042    0 0
  v 3.15419 2.46882 44.7367    0.10277 0.934898 0.339711    0 0
  v 1.31948 2.0696 46.1521    0 0.942166 0.335145    0 0
  v 6.76035 1.6947 44.7367    0.284879 0.884799 0.368747    0 0
  v -2.48325 11.3357 55.6244    -0.109351 0.802222 -0.586926    0 0
  v -2.48325 11.3357 55.6244    -0.0910776 0.719517 -0.688476    0 0
  v -12.0426 -29.7342 51.4139    -0.226184 -0.468367 -0.854092    0 0
  v -16.6148 -26.9753 51.4183    -0.282051 -0.37574 -0.882761    0 0
  v -9.04903 -23.1159 47.5221    -0.57813 -0.632651 0.515284    0 0
  v -11.1331 -26.347 49.4185    -0.266988 -0.410887 -0.871716    0 0
  v -14.4827 -23.6358 49.4185    -0.311477 -0.307568 -0.899102    0 0
  v -7.22277 -28.3709 49.4185    -0.199156 -0.500842 -0.842315    0 0
  v -6.33576 -25.1147 47.5221    -0.447317 -0.761711 0.468725    0 0
  v -20.3107 -23.5013 51.4183    -0.32115 -0.26892 -0.908044    0 0
  v -22.8835 -19.4967 51.4183    -0.34382 -0.16096 -0.925138    0 0
  v -12.7844 -17.6941 47.5221    -0.752769 -0.289351 0.591282    0 0
  v -17.0075 -20.3827 49.4185    -0.338186 -0.201648 -0.919222    0 0
  v -18.58 -16.7589 49.4185    -0.35143 -0.0993174 -0.930931    0 0
  v -11.2513 -20.5974 47.5221    -0.678605 -0.466703 0.567171    0 0
  v -24.2025 -15.1648 51.4183    -0.354216 -0.0529266 -0.933665    0 0
  v -24.2025 -10.72 51.4183    -0.354216 0.0529266 -0.933665    0 0
  v -13.5703 -11.3313 47.5221    -0.780875 0.0956482 0.617322    0 0
  v -19.1085 -12.9424 49.4185    -0.355441 4.65801e-009 -0.934699    0 0
  v -18.58 -9.12598 49.4185    -0.35143 0.0993175 -0.930931    0 0
  v -13.5703 -14.5536 47.5221    -0.791201 -0.0972383 0.603776    0 0
  v -22.8835 -6.38812 51.4183    -0.343819 0.16096 -0.925138    0 0
  v -20.3107 -2.38352 51.4183    -0.32115 0.268919 -0.908044    0 0
  v -11.2513 -5.28749 47.5221    -0.67583 0.46486 0.571979    0 0
  v -17.0075 -5.50214 49.4185    -0.338186 0.201648 -0.919222    0 0
  v -14.4827 -2.249 49.4185    -0.311477 0.307567 -0.899102    0 0
  v -12.7844 -8.19071 47.5221    -0.739055 0.284085 0.610814    0 0
  v -16.6148 1.09041 51.4183    -0.28188 0.376011 -0.8827    0 0
  v -12.0281 3.85297 51.4182    -0.225084 0.471001 -0.852933    0 0
  v -6.33576 -0.770115 47.5221    -0.447318 0.761712 0.468724    0 0
  v -11.1331 0.462105 49.4185    -0.267167 0.411161 -0.871532    0 0
  v -7.22276 2.48606 49.4185    -0.200156 0.503323 -0.840597    0 0
  v -9.04903 -2.76897 47.5221    -0.578023 0.632549 0.51553    0 0
  v -5.27993 8.82482 53.5375    -0.124334 0.663834 -0.737472    0 0
  v -6.88416 5.74602 51.4178    -0.15207 0.543665 -0.82541    0 0
  v -1.44759 6.83498 51.3325    -0.118679 0.594619 -0.7952    0 0
  v -0.249818 1.41576 47.5221    -0.20226 0.907653 0.367772    0 0
  v -3.02005 3.75145 49.4185    -0.131234 0.559092 -0.818653    0 0
  v -3.35017 0.586594 47.5221    -0.292622 0.852353 0.433435    0 0
  v -5.36974 0.522858 46.1521    -0.369032 0.825744 0.426569    0 0
  v -7.53778 0.184685 44.7367    -0.45429 0.795804 0.400396    0 0
  v -8.44321 -1.256 46.1522    -0.510246 0.707413 0.489097    0 0
  v -10.587 -1.97794 44.7372    -0.572182 0.659784 0.487128    0 0
  v -11.0797 -3.59722 46.1527    -0.633881 0.577014 0.515024    0 0
  v -13.0408 -4.58318 44.7389    -0.69797 0.525533 0.486469    0 0
  v -13.062 -6.34634 46.1586    -0.703251 0.390383 0.594171    0 0
  v -14.7246 -7.52261 44.7698    -0.748605 0.31467 0.583587    0 0
  v -14.2686 -9.43337 46.2011    -0.780096 0.201644 0.592275    0 0
  v -15.5179 -10.7894 44.8846    -0.827532 0.128865 0.546429    0 0
  v -14.5791 -12.7887 46.345    -0.790941 0.000546661 0.611892    0 0
  v -15.0603 -14.6076 45.7048    -0.744942 -0.0599174 0.664433    0 0
  v -13.926 -16.2467 46.6405    -0.719687 -0.181661 0.670111    0 0
  v -14.1802 -18.0809 45.7059    -0.524409 -0.30614 0.794527    0 0
  v -12.883 -19.5273 46.3435    -0.714312 -0.386837 0.583194    0 0
  v -12.838 -21.3906 44.8805    -0.662629 -0.52171 0.537347    0 0
  v -11.0296 -22.2942 46.1986    -0.634747 -0.574806 0.516424    0 0
  v -10.5465 -23.9247 44.7655    -0.586529 -0.676471 0.445388    0 0
  v -8.43821 -24.6295 46.1568    -0.510152 -0.707431 0.489169    0 0
  v -7.53778 -26.0695 44.7367    -0.443782 -0.778362 0.444083    0 0
  v -5.36974 -26.4077 46.1521    -0.369032 -0.825745 0.426569    0 0
  v -4.12138 -27.5795 44.7367    -0.283708 -0.885229 0.368618    0 0
  v -2.07608 -27.4784 46.1521    -0.187736 -0.888505 0.418706    0 0
  v -3.35017 -26.4714 47.5221    -0.165418 -0.502654 -0.848514    0 0
  v -0.515223 -28.3333 44.7367    -0.0943073 -0.915961 0.390028    0 0
  v -0.249818 -27.1373 47.5221    -0.0585908 -0.557789 -0.827912    0 0
  v -1.50561 -32.6059 51.3917    -0.0585409 -0.614802 -0.786506    0 0
  v -3.02005 -29.5863 49.4185    -0.101594 -0.541261 -0.834695    0 0
  v -6.95669 -31.613 51.3965    -0.148423 -0.540779 -0.827967    0 0
  v -0.515223 2.46882 44.7367    -0.10277 0.934898 0.339711    0 0
  v -2.07608 1.61402 46.1521    -0.209365 0.887982 0.409456    0 0
  v -4.12138 1.6947 44.7367    -0.279531 0.868271 0.40984    0 0
  t 0 2582 1292
  t 1292 2585 0
  t 659 2583 1292
  t 1292 2582 659
  t 330 2584 1292
  t 1292 2583 330
  t 648 2585 1292
  t 1292 2584 648
  t 6 2586 1293
  t 1293 2588 6
  t 660 2587 1293
  t 1293 2586 660
  t 330 2583 1293
  t 1293 2587 330
  t 659 2588 1293
  t 1293 2583 659
  t 7 2589 1294
  t 1294 2591 7
  t 661 2590 1294
  t 1294 2589 661
  t 330 2587 1294
  t 1294 2590 330
  t 660 2591 1294
  t 1294 2587 660
  t 1 2592 1295
  t 1295 2593 1
  t 648 2584 1295
  t 1295 2592 648
  t 330 2590 1295
  t 1295 2584 330
  t 661 2593 1295
  t 1295 2590 661
  t 1 2593 1296
  t 1296 2596 1
  t 661 2594 1296
  t 1296 2593 661
  t 331 2595 1296
  t 1296 2594 331
  t 650 2596 1296
  t 1296 2595 650
  t 7 2597 1297
  t 1297 2589 7
  t 662 2598 1297
  t 1297 2597 662
  t 331 2594 1297
  t 1297 2598 331
  t 661 2589 1297
  t 1297 2594 661
  t 36 2599 1298
  t 1298 2601 36
  t 720 2600 1298
  t 1298 2599 720
  t 331 2598 1298
  t 1298 2600 331
  t 662 2601 1298
  t 1298 2598 662
  t 8 2602 1299
  t 1299 2604 8
  t 663 2603 1299
  t 1299 2602 663
  t 331 2600 1299
  t 1299 2603 331
  t 720 2604 1299
  t 1299 2600 720
  t 2 2605 1300
  t 1300 2606 2
  t 650 2595 1300
  t 1300 2605 650
  t 331 2603 1300
  t 1300 2595 331
  t 663 2606 1300
  t 1300 2603 663
  t 2 2606 1301
  t 1301 2609 2
  t 663 2607 1301
  t 1301 2606 663
  t 332 2608 1301
  t 1301 2607 332
  t 652 2609 1301
  t 1301 2608 652
  t 8 2610 1302
  t 1302 2602 8
  t 723 2611 1302
  t 1302 2610 723
  t 332 2607 1302
  t 1302 2611 332
  t 663 2602 1302
  t 1302 2607 663
  t 38 2612 1303
  t 1303 2614 38
  t 664 2613 1303
  t 1303 2612 664
  t 332 2611 1303
  t 1303 2613 332
  t 723 2614 1303
  t 1303 2611 723
  t 9 2615 1304
  t 1304 2617 9
  t 665 2616 1304
  t 1304 2615 665
  t 332 2613 1304
  t 1304 2616 332
  t 664 2617 1304
  t 1304 2613 664
  t 3 2618 1305
  t 1305 2619 3
  t 652 2608 1305
  t 1305 2618 652
  t 332 2616 1305
  t 1305 2608 332
  t 665 2619 1305
  t 1305 2616 665
  t 3 2619 1306
  t 1306 2622 3
  t 665 2620 1306
  t 1306 2619 665
  t 333 2621 1306
  t 1306 2620 333
  t 654 2622 1306
  t 1306 2621 654
  t 9 2623 1307
  t 1307 2615 9
  t 666 2624 1307
  t 1307 2623 666
  t 333 2620 1307
  t 1307 2624 333
  t 665 2615 1307
  t 1307 2620 665
  t 10 2625 1308
  t 1308 2627 10
  t 667 2626 1308
  t 1308 2625 667
  t 333 2624 1308
  t 1308 2626 333
  t 666 2627 1308
  t 1308 2624 666
  t 4 2628 1309
  t 1309 2629 4
  t 654 2621 1309
  t 1309 2628 654
  t 333 2626 1309
  t 1309 2621 333
  t 667 2629 1309
  t 1309 2626 667
  t 4 2629 1310
  t 1310 2632 4
  t 667 2630 1310
  t 1310 2629 667
  t 334 2631 1310
  t 1310 2630 334
  t 656 2632 1310
  t 1310 2631 656
  t 10 2633 1311
  t 1311 2625 10
  t 668 2634 1311
  t 1311 2633 668
  t 334 2630 1311
  t 1311 2634 334
  t 667 2625 1311
  t 1311 2630 667
  t 11 2635 1312
  t 1312 2637 11
  t 669 2636 1312
  t 1312 2635 669
  t 334 2634 1312
  t 1312 2636 334
  t 668 2637 1312
  t 1312 2634 668
  t 5 2638 1313
  t 1313 2639 5
  t 656 2631 1313
  t 1313 2638 656
  t 334 2636 1313
  t 1313 2631 334
  t 669 2639 1313
  t 1313 2636 669
  t 5 2639 1314
  t 1314 2642 5
  t 669 2640 1314
  t 1314 2639 669
  t 335 2641 1314
  t 1314 2640 335
  t 658 2642 1314
  t 1314 2641 658
  t 11 2643 1315
  t 1315 2635 11
  t 670 2644 1315
  t 1315 2643 670
  t 335 2640 1315
  t 1315 2644 335
  t 669 2635 1315
  t 1315 2640 669
  t 148 2645 1316
  t 1316 2647 148
  t 946 2646 1316
  t 1316 2645 946
  t 335 2644 1316
  t 1316 2646 335
  t 670 2647 1316
  t 1316 2644 670
  t 175 2648 1317
  t 1317 2649 175
  t 658 2641 1317
  t 1317 2648 658
  t 335 2646 1317
  t 1317 2641 335
  t 946 2649 1317
  t 1317 2646 946
  t 6 2650 1318
  t 1318 2586 6
  t 671 2651 1318
  t 1318 2650 671
  t 336 2652 1318
  t 1318 2651 336
  t 660 2586 1318
  t 1318 2652 660
  t 12 2653 1319
  t 1319 2655 12
  t 672 2654 1319
  t 1319 2653 672
  t 336 2651 1319
  t 1319 2654 336
  t 671 2655 1319
  t 1319 2651 671
  t 13 2656 1320
  t 1320 2658 13
  t 673 2657 1320
  t 1320 2656 673
  t 336 2654 1320
  t 1320 2657 336
  t 672 2658 1320
  t 1320 2654 672
  t 7 2591 1321
  t 1321 2659 7
  t 660 2652 1321
  t 1321 2591 660
  t 336 2657 1321
  t 1321 2652 336
  t 673 2659 1321
  t 1321 2657 673
  t 7 2659 1322
  t 1322 2597 7
  t 673 2660 1322
  t 1322 2659 673
  t 337 2661 1322
  t 1322 2660 337
  t 662 2597 1322
  t 1322 2661 662
  t 13 2662 1323
  t 1323 2656 13
  t 674 2663 1323
  t 1323 2662 674
  t 337 2660 1323
  t 1323 2663 337
  t 673 2656 1323
  t 1323 2660 673
  t 14 2664 1324
  t 1324 2666 14
  t 675 2665 1324
  t 1324 2664 675
  t 337 2663 1324
  t 1324 2665 337
  t 674 2666 1324
  t 1324 2663 674
  t 37 2667 1325
  t 1325 2669 37
  t 721 2668 1325
  t 1325 2667 721
  t 337 2665 1325
  t 1325 2668 337
  t 675 2669 1325
  t 1325 2665 675
  t 36 2601 1326
  t 1326 2670 36
  t 662 2661 1326
  t 1326 2601 662
  t 337 2668 1326
  t 1326 2661 337
  t 721 2670 1326
  t 1326 2668 721
  t 38 2671 1327
  t 1327 2612 38
  t 722 2672 1327
  t 1327 2671 722
  t 338 2673 1327
  t 1327 2672 338
  t 664 2612 1327
  t 1327 2673 664
  t 37 2669 1328
  t 1328 2675 37
  t 675 2674 1328
  t 1328 2669 675
  t 338 2672 1328
  t 1328 2674 338
  t 722 2675 1328
  t 1328 2672 722
  t 14 2676 1329
  t 1329 2664 14
  t 676 2677 1329
  t 1329 2676 676
  t 338 2674 1329
  t 1329 2677 338
  t 675 2664 1329
  t 1329 2674 675
  t 15 2678 1330
  t 1330 2680 15
  t 677 2679 1330
  t 1330 2678 677
  t 338 2677 1330
  t 1330 2679 338
  t 676 2680 1330
  t 1330 2677 676
  t 9 2617 1331
  t 1331 2681 9
  t 664 2673 1331
  t 1331 2617 664
  t 338 2679 1331
  t 1331 2673 338
  t 677 2681 1331
  t 1331 2679 677
  t 9 2681 1332
  t 1332 2623 9
  t 677 2682 1332
  t 1332 2681 677
  t 339 2683 1332
  t 1332 2682 339
  t 666 2623 1332
  t 1332 2683 666
  t 15 2684 1333
  t 1333 2678 15
  t 678 2685 1333
  t 1333 2684 678
  t 339 2682 1333
  t 1333 2685 339
  t 677 2678 1333
  t 1333 2682 677
  t 16 2686 1334
  t 1334 2688 16
  t 679 2687 1334
  t 1334 2686 679
  t 339 2685 1334
  t 1334 2687 339
  t 678 2688 1334
  t 1334 2685 678
  t 10 2627 1335
  t 1335 2689 10
  t 666 2683 1335
  t 1335 2627 666
  t 339 2687 1335
  t 1335 2683 339
  t 679 2689 1335
  t 1335 2687 679
  t 10 2689 1336
  t 1336 2633 10
  t 679 2690 1336
  t 1336 2689 679
  t 340 2691 1336
  t 1336 2690 340
  t 668 2633 1336
  t 1336 2691 668
  t 16 2692 1337
  t 1337 2686 16
  t 680 2693 1337
  t 1337 2692 680
  t 340 2690 1337
  t 1337 2693 340
  t 679 2686 1337
  t 1337 2690 679
  t 17 2694 1338
  t 1338 2696 17
  t 681 2695 1338
  t 1338 2694 681
  t 340 2693 1338
  t 1338 2695 340
  t 680 2696 1338
  t 1338 2693 680
  t 11 2637 1339
  t 1339 2697 11
  t 668 2691 1339
  t 1339 2637 668
  t 340 2695 1339
  t 1339 2691 340
  t 681 2697 1339
  t 1339 2695 681
  t 11 2697 1340
  t 1340 2643 11
  t 681 2698 1340
  t 1340 2697 681
  t 341 2699 1340
  t 1340 2698 341
  t 670 2643 1340
  t 1340 2699 670
  t 17 2700 1341
  t 1341 2694 17
  t 682 2701 1341
  t 1341 2700 682
  t 341 2698 1341
  t 1341 2701 341
  t 681 2694 1341
  t 1341 2698 681
  t 183 2702 1342
  t 1342 2704 183
  t 948 2703 1342
  t 1342 2702 948
  t 341 2701 1342
  t 1342 2703 341
  t 682 2704 1342
  t 1342 2701 682
  t 148 2647 1343
  t 1343 2705 148
  t 670 2699 1343
  t 1343 2647 670
  t 341 2703 1343
  t 1343 2699 341
  t 948 2705 1343
  t 1343 2703 948
  t 13 2706 1344
  t 1344 2662 13
  t 685 2707 1344
  t 1344 2706 685
  t 342 2708 1344
  t 1344 2707 342
  t 674 2662 1344
  t 1344 2708 674
  t 19 2709 1345
  t 1345 2711 19
  t 686 2710 1345
  t 1345 2709 686
  t 342 2707 1345
  t 1345 2710 342
  t 685 2711 1345
  t 1345 2707 685
  t 20 2712 1346
  t 1346 2714 20
  t 687 2713 1346
  t 1346 2712 687
  t 342 2710 1346
  t 1346 2713 342
  t 686 2714 1346
  t 1346 2710 686
  t 14 2666 1347
  t 1347 2715 14
  t 674 2708 1347
  t 1347 2666 674
  t 342 2713 1347
  t 1347 2708 342
  t 687 2715 1347
  t 1347 2713 687
  t 14 2715 1348
  t 1348 2676 14
  t 687 2716 1348
  t 1348 2715 687
  t 343 2717 1348
  t 1348 2716 343
  t 676 2676 1348
  t 1348 2717 676
  t 20 2718 1349
  t 1349 2712 20
  t 688 2719 1349
  t 1349 2718 688
  t 343 2716 1349
  t 1349 2719 343
  t 687 2712 1349
  t 1349 2716 687
  t 21 2720 1350
  t 1350 2722 21
  t 689 2721 1350
  t 1350 2720 689
  t 343 2719 1350
  t 1350 2721 343
  t 688 2722 1350
  t 1350 2719 688
  t 15 2680 1351
  t 1351 2723 15
  t 676 2717 1351
  t 1351 2680 676
  t 343 2721 1351
  t 1351 2717 343
  t 689 2723 1351
  t 1351 2721 689
  t 15 2723 1352
  t 1352 2684 15
  t 689 2724 1352
  t 1352 2723 689
  t 344 2725 1352
  t 1352 2724 344
  t 678 2684 1352
  t 1352 2725 678
  t 21 2726 1353
  t 1353 2720 21
  t 690 2727 1353
  t 1353 2726 690
  t 344 2724 1353
  t 1353 2727 344
  t 689 2720 1353
  t 1353 2724 689
  t 22 2728 1354
  t 1354 2730 22
  t 691 2729 1354
  t 1354 2728 691
  t 344 2727 1354
  t 1354 2729 344
  t 690 2730 1354
  t 1354 2727 690
  t 16 2688 1355
  t 1355 2731 16
  t 678 2725 1355
  t 1355 2688 678
  t 344 2729 1355
  t 1355 2725 344
  t 691 2731 1355
  t 1355 2729 691
  t 16 2731 1356
  t 1356 2692 16
  t 691 2732 1356
  t 1356 2731 691
  t 345 2733 1356
  t 1356 2732 345
  t 680 2692 1356
  t 1356 2733 680
  t 22 2734 1357
  t 1357 2728 22
  t 692 2735 1357
  t 1357 2734 692
  t 345 2732 1357
  t 1357 2735 345
  t 691 2728 1357
  t 1357 2732 691
  t 23 2736 1358
  t 1358 2738 23
  t 693 2737 1358
  t 1358 2736 693
  t 345 2735 1358
  t 1358 2737 345
  t 692 2738 1358
  t 1358 2735 692
  t 17 2696 1359
  t 1359 2739 17
  t 680 2733 1359
  t 1359 2696 680
  t 345 2737 1359
  t 1359 2733 345
  t 693 2739 1359
  t 1359 2737 693
  t 17 2739 1360
  t 1360 2700 17
  t 693 2740 1360
  t 1360 2739 693
  t 346 2741 1360
  t 1360 2740 346
  t 682 2700 1360
  t 1360 2741 682
  t 23 2742 1361
  t 1361 2736 23
  t 694 2743 1361
  t 1361 2742 694
  t 346 2740 1361
  t 1361 2743 346
  t 693 2736 1361
  t 1361 2740 693
  t 150 2744 1362
  t 1362 2746 150
  t 1005 2745 1362
  t 1362 2744 1005
  t 346 2743 1362
  t 1362 2745 346
  t 694 2746 1362
  t 1362 2743 694
  t 183 2704 1363
  t 1363 2747 183
  t 682 2741 1363
  t 1363 2704 682
  t 346 2745 1363
  t 1363 2741 346
  t 1005 2747 1363
  t 1363 2745 1005
  t 18 2748 1364
  t 1364 2751 18
  t 696 2749 1364
  t 1364 2748 696
  t 347 2750 1364
  t 1364 2749 347
  t 684 2751 1364
  t 1364 2750 684
  t 24 2752 1365
  t 1365 2754 24
  t 697 2753 1365
  t 1365 2752 697
  t 347 2749 1365
  t 1365 2753 347
  t 696 2754 1365
  t 1365 2749 696
  t 25 2755 1366
  t 1366 2757 25
  t 698 2756 1366
  t 1366 2755 698
  t 347 2753 1366
  t 1366 2756 347
  t 697 2757 1366
  t 1366 2753 697
  t 19 2758 1367
  t 1367 2759 19
  t 684 2750 1367
  t 1367 2758 684
  t 347 2756 1367
  t 1367 2750 347
  t 698 2759 1367
  t 1367 2756 698
  t 19 2759 1368
  t 1368 2709 19
  t 698 2760 1368
  t 1368 2759 698
  t 348 2761 1368
  t 1368 2760 348
  t 686 2709 1368
  t 1368 2761 686
  t 25 2762 1369
  t 1369 2755 25
  t 699 2763 1369
  t 1369 2762 699
  t 348 2760 1369
  t 1369 2763 348
  t 698 2755 1369
  t 1369 2760 698
  t 26 2764 1370
  t 1370 2766 26
  t 700 2765 1370
  t 1370 2764 700
  t 348 2763 1370
  t 1370 2765 348
  t 699 2766 1370
  t 1370 2763 699
  t 20 2714 1371
  t 1371 2767 20
  t 686 2761 1371
  t 1371 2714 686
  t 348 2765 1371
  t 1371 2761 348
  t 700 2767 1371
  t 1371 2765 700
  t 20 2767 1372
  t 1372 2718 20
  t 700 2768 1372
  t 1372 2767 700
  t 349 2769 1372
  t 1372 2768 349
  t 688 2718 1372
  t 1372 2769 688
  t 26 2770 1373
  t 1373 2764 26
  t 701 2771 1373
  t 1373 2770 701
  t 349 2768 1373
  t 1373 2771 349
  t 700 2764 1373
  t 1373 2768 700
  t 27 2772 1374
  t 1374 2774 27
  t 702 2773 1374
  t 1374 2772 702
  t 349 2771 1374
  t 1374 2773 349
  t 701 2774 1374
  t 1374 2771 701
  t 21 2722 1375
  t 1375 2775 21
  t 688 2769 1375
  t 1375 2722 688
  t 349 2773 1375
  t 1375 2769 349
  t 702 2775 1375
  t 1375 2773 702
  t 21 2775 1376
  t 1376 2726 21
  t 702 2776 1376
  t 1376 2775 702
  t 350 2777 1376
  t 1376 2776 350
  t 690 2726 1376
  t 1376 2777 690
  t 27 2778 1377
  t 1377 2772 27
  t 703 2779 1377
  t 1377 2778 703
  t 350 2776 1377
  t 1377 2779 350
  t 702 2772 1377
  t 1377 2776 702
  t 28 2780 1378
  t 1378 2782 28
  t 704 2781 1378
  t 1378 2780 704
  t 350 2779 1378
  t 1378 2781 350
  t 703 2782 1378
  t 1378 2779 703
  t 22 2730 1379
  t 1379 2783 22
  t 690 2777 1379
  t 1379 2730 690
  t 350 2781 1379
  t 1379 2777 350
  t 704 2783 1379
  t 1379 2781 704
  t 22 2783 1380
  t 1380 2734 22
  t 704 2784 1380
  t 1380 2783 704
  t 351 2785 1380
  t 1380 2784 351
  t 692 2734 1380
  t 1380 2785 692
  t 28 2786 1381
  t 1381 2780 28
  t 705 2787 1381
  t 1381 2786 705
  t 351 2784 1381
  t 1381 2787 351
  t 704 2780 1381
  t 1381 2784 704
  t 29 2788 1382
  t 1382 2790 29
  t 706 2789 1382
  t 1382 2788 706
  t 351 2787 1382
  t 1382 2789 351
  t 705 2790 1382
  t 1382 2787 705
  t 23 2738 1383
  t 1383 2791 23
  t 692 2785 1383
  t 1383 2738 692
  t 351 2789 1383
  t 1383 2785 351
  t 706 2791 1383
  t 1383 2789 706
  t 23 2791 1384
  t 1384 2742 23
  t 706 2792 1384
  t 1384 2791 706
  t 352 2793 1384
  t 1384 2792 352
  t 694 2742 1384
  t 1384 2793 694
  t 29 2794 1385
  t 1385 2788 29
  t 707 2795 1385
  t 1385 2794 707
  t 352 2792 1385
  t 1385 2795 352
  t 706 2788 1385
  t 1385 2792 706
  t 151 2796 1386
  t 1386 2798 151
  t 950 2797 5255
  t 5255 5316 950
  t 352 2795 5255
  t 5255 2797 352
  t 707 5318 5255
  t 5255 2795 707
  t 150 2746 1387
  t 1387 2799 150
  t 694 2793 1387
  t 1387 2746 694
  t 352 2797 1387
  t 1387 2793 352
  t 950 2799 1387
  t 1387 2797 950
  t 24 2800 1388
  t 1388 2752 24
  t 709 2801 1388
  t 1388 2800 709
  t 353 2802 1388
  t 1388 2801 353
  t 697 2752 1388
  t 1388 2802 697
  t 30 2803 1389
  t 1389 2805 30
  t 710 2804 1389
  t 1389 2803 710
  t 5180 5320 5256
  t 5256 5322 5180
  t 5212 5323 5256
  t 5256 5320 5212
  t 31 2806 1390
  t 1390 2808 31
  t 711 2807 5257
  t 5257 5324 711
  t 5180 5322 5257
  t 5257 2807 5180
  t 710 2808 1390
  t 1390 2804 710
  t 25 2757 1391
  t 1391 2809 25
  t 697 2802 1391
  t 1391 2757 697
  t 353 5325 1391
  t 1391 2802 353
  t 5214 2809 1391
  t 1391 5325 5214
  t 25 2809 1392
  t 1392 2762 25
  t 5214 2810 1392
  t 1392 2809 5214
  t 354 2811 1392
  t 1392 2810 354
  t 699 2762 1392
  t 1392 2811 699
  t 31 2812 1393
  t 1393 2806 31
  t 712 2813 1393
  t 1393 2812 712
  t 5181 5327 5258
  t 5258 5329 5181
  t 711 5324 5258
  t 5258 5327 711
  t 32 2814 1394
  t 1394 2816 32
  t 713 2815 5259
  t 5259 5330 713
  t 5181 5329 5259
  t 5259 2815 5181
  t 712 2816 1394
  t 1394 2813 712
  t 26 2766 1395
  t 1395 2817 26
  t 699 2811 1395
  t 1395 2766 699
  t 354 5331 1395
  t 1395 2811 354
  t 5216 2817 1395
  t 1395 5331 5216
  t 26 2817 1396
  t 1396 2770 26
  t 5216 2818 1396
  t 1396 2817 5216
  t 355 2819 1396
  t 1396 2818 355
  t 701 2770 1396
  t 1396 2819 701
  t 32 2820 1397
  t 1397 2814 32
  t 714 2821 1397
  t 1397 2820 714
  t 5182 5333 5260
  t 5260 5335 5182
  t 713 5330 5260
  t 5260 5333 713
  t 33 2822 1398
  t 1398 2824 33
  t 715 2823 5261
  t 5261 5336 715
  t 5182 5335 5261
  t 5261 2823 5182
  t 714 2824 1398
  t 1398 2821 714
  t 27 2774 1399
  t 1399 2825 27
  t 701 2819 1399
  t 1399 2774 701
  t 355 5337 1399
  t 1399 2819 355
  t 5218 2825 1399
  t 1399 5337 5218
  t 27 2825 1400
  t 1400 2778 27
  t 5218 2826 1400
  t 1400 2825 5218
  t 356 2827 1400
  t 1400 2826 356
  t 703 2778 1400
  t 1400 2827 703
  t 33 2828 1401
  t 1401 2822 33
  t 716 2829 1401
  t 1401 2828 716
  t 5183 5339 5262
  t 5262 5341 5183
  t 715 5336 5262
  t 5262 5339 715
  t 34 2830 1402
  t 1402 2832 34
  t 717 2831 5263
  t 5263 5342 717
  t 5183 5341 5263
  t 5263 2831 5183
  t 716 2832 1402
  t 1402 2829 716
  t 28 2782 1403
  t 1403 2833 28
  t 703 2827 1403
  t 1403 2782 703
  t 356 5343 1403
  t 1403 2827 356
  t 5220 2833 1403
  t 1403 5343 5220
  t 28 2833 1404
  t 1404 2786 28
  t 5220 2834 1404
  t 1404 2833 5220
  t 357 2835 1404
  t 1404 2834 357
  t 705 2786 1404
  t 1404 2835 705
  t 34 2836 1405
  t 1405 2830 34
  t 718 2837 1405
  t 1405 2836 718
  t 5184 5345 5264
  t 5264 5347 5184
  t 717 5342 5264
  t 5264 5345 717
  t 35 2838 1406
  t 1406 2840 35
  t 719 2839 5265
  t 5265 5348 719
  t 5184 5347 5265
  t 5265 2839 5184
  t 718 2840 1406
  t 1406 2837 718
  t 29 2790 1407
  t 1407 2841 29
  t 705 2835 1407
  t 1407 2790 705
  t 357 5349 1407
  t 1407 2835 357
  t 5222 2841 1407
  t 1407 5349 5222
  t 29 2841 1408
  t 1408 2794 29
  t 5222 2842 1408
  t 1408 2841 5222
  t 358 2843 1408
  t 1408 2842 358
  t 707 2794 1408
  t 1408 2843 707
  t 35 2844 1409
  t 1409 2838 35
  t 935 2845 1409
  t 1409 2844 935
  t 5185 5351 5266
  t 5266 5354 5185
  t 719 5348 5266
  t 5266 5351 719
  t 153 2846 1410
  t 1410 2848 153
  t 952 2847 1410
  t 1410 2846 952
  t 5186 5355 5267
  t 5267 5358 5186
  t 5229 5360 5268
  t 5268 5356 5229
  t 5168 5319 1411
  t 1411 2849 5168
  t 5210 5352 5269
  t 5269 2798 5210
  t 5187 5359 5269
  t 5269 5352 5187
  t 952 2849 1411
  t 1411 2847 952
  t 55 2850 1412
  t 1412 2853 55
  t 756 2851 1412
  t 1412 2850 756
  t 359 2852 1412
  t 1412 2851 359
  t 759 2853 1412
  t 1412 2852 759
  t 56 2854 1413
  t 1413 2856 56
  t 757 2855 1413
  t 1413 2854 757
  t 359 2851 1413
  t 1413 2855 359
  t 756 2856 1413
  t 1413 2851 756
  t 57 2857 1414
  t 1414 2859 57
  t 758 2858 1414
  t 1414 2857 758
  t 359 2855 1414
  t 1414 2858 359
  t 757 2859 1414
  t 1414 2855 757
  t 58 2860 1415
  t 1415 2861 58
  t 759 2852 1415
  t 1415 2860 759
  t 359 2858 1415
  t 1415 2852 359
  t 758 2861 1415
  t 1415 2858 758
  t 8 2604 1416
  t 1416 2864 8
  t 720 2862 1416
  t 1416 2604 720
  t 360 2863 1416
  t 1416 2862 360
  t 728 2864 1416
  t 1416 2863 728
  t 36 2865 1417
  t 1417 2599 36
  t 729 2866 1417
  t 1417 2865 729
  t 360 2862 1417
  t 1417 2866 360
  t 720 2599 1417
  t 1417 2862 720
  t 40 2867 1418
  t 1418 2869 40
  t 724 2868 1418
  t 1418 2867 724
  t 360 2866 1418
  t 1418 2868 360
  t 729 2869 1418
  t 1418 2866 729
  t 39 2870 1419
  t 1419 2871 39
  t 728 2863 1419
  t 1419 2870 728
  t 360 2868 1419
  t 1419 2863 360
  t 724 2871 1419
  t 1419 2868 724
  t 36 2670 1420
  t 1420 2865 36
  t 721 2872 1420
  t 1420 2670 721
  t 361 2873 1420
  t 1420 2872 361
  t 729 2865 1420
  t 1420 2873 729
  t 37 2874 1421
  t 1421 2667 37
  t 730 2875 1421
  t 1421 2874 730
  t 361 2872 1421
  t 1421 2875 361
  t 721 2667 1421
  t 1421 2872 721
  t 41 2876 1422
  t 1422 2878 41
  t 725 2877 1422
  t 1422 2876 725
  t 361 2875 1422
  t 1422 2877 361
  t 730 2878 1422
  t 1422 2875 730
  t 40 2869 1423
  t 1423 2879 40
  t 729 2873 1423
  t 1423 2869 729
  t 361 2877 1423
  t 1423 2873 361
  t 725 2879 1423
  t 1423 2877 725
  t 37 2675 1424
  t 1424 2874 37
  t 722 2880 1424
  t 1424 2675 722
  t 362 2881 1424
  t 1424 2880 362
  t 730 2874 1424
  t 1424 2881 730
  t 38 2882 1425
  t 1425 2671 38
  t 731 2883 1425
  t 1425 2882 731
  t 362 2880 1425
  t 1425 2883 362
  t 722 2671 1425
  t 1425 2880 722
  t 42 2884 1426
  t 1426 2886 42
  t 726 2885 1426
  t 1426 2884 726
  t 362 2883 1426
  t 1426 2885 362
  t 731 2886 1426
  t 1426 2883 731
  t 41 2878 1427
  t 1427 2887 41
  t 730 2881 1427
  t 1427 2878 730
  t 362 2885 1427
  t 1427 2881 362
  t 726 2887 1427
  t 1427 2885 726
  t 38 2614 1428
  t 1428 2882 38
  t 723 2888 1428
  t 1428 2614 723
  t 363 2889 1428
  t 1428 2888 363
  t 731 2882 1428
  t 1428 2889 731
  t 8 2864 1429
  t 1429 2610 8
  t 728 2890 1429
  t 1429 2864 728
  t 363 2888 1429
  t 1429 2890 363
  t 723 2610 1429
  t 1429 2888 723
  t 39 2891 1430
  t 1430 2870 39
  t 727 2892 1430
  t 1430 2891 727
  t 363 2890 1430
  t 1430 2892 363
  t 728 2870 1430
  t 1430 2890 728
  t 42 2886 1431
  t 1431 2893 42
  t 731 2889 1431
  t 1431 2886 731
  t 363 2892 1431
  t 1431 2889 363
  t 727 2893 1431
  t 1431 2892 727
  t 39 2871 1432
  t 1432 2896 39
  t 724 2894 1432
  t 1432 2871 724
  t 364 2895 1432
  t 1432 2894 364
  t 736 2896 1432
  t 1432 2895 736
  t 40 2897 1433
  t 1433 2867 40
  t 737 2898 1433
  t 1433 2897 737
  t 364 2894 1433
  t 1433 2898 364
  t 724 2867 1433
  t 1433 2894 724
  t 44 2899 1434
  t 1434 2901 44
  t 732 2900 1434
  t 1434 2899 732
  t 364 2898 1434
  t 1434 2900 364
  t 737 2901 1434
  t 1434 2898 737
  t 43 2902 1435
  t 1435 2903 43
  t 736 2895 1435
  t 1435 2902 736
  t 364 2900 1435
  t 1435 2895 364
  t 732 2903 1435
  t 1435 2900 732
  t 40 2879 1436
  t 1436 2897 40
  t 725 2904 1436
  t 1436 2879 725
  t 365 2905 1436
  t 1436 2904 365
  t 737 2897 1436
  t 1436 2905 737
  t 41 2906 1437
  t 1437 2876 41
  t 738 2907 1437
  t 1437 2906 738
  t 365 2904 1437
  t 1437 2907 365
  t 725 2876 1437
  t 1437 2904 725
  t 45 2908 1438
  t 1438 2910 45
  t 733 2909 1438
  t 1438 2908 733
  t 365 2907 1438
  t 1438 2909 365
  t 738 2910 1438
  t 1438 2907 738
  t 44 2901 1439
  t 1439 2911 44
  t 737 2905 1439
  t 1439 2901 737
  t 365 2909 1439
  t 1439 2905 365
  t 733 2911 1439
  t 1439 2909 733
  t 41 2887 1440
  t 1440 2906 41
  t 726 2912 1440
  t 1440 2887 726
  t 366 2913 1440
  t 1440 2912 366
  t 738 2906 1440
  t 1440 2913 738
  t 42 2914 1441
  t 1441 2884 42
  t 739 2915 1441
  t 1441 2914 739
  t 366 2912 1441
  t 1441 2915 366
  t 726 2884 1441
  t 1441 2912 726
  t 46 2916 1442
  t 1442 2918 46
  t 734 2917 1442
  t 1442 2916 734
  t 366 2915 1442
  t 1442 2917 366
  t 739 2918 1442
  t 1442 2915 739
  t 45 2910 1443
  t 1443 2919 45
  t 738 2913 1443
  t 1443 2910 738
  t 366 2917 1443
  t 1443 2913 366
  t 734 2919 1443
  t 1443 2917 734
  t 42 2893 1444
  t 1444 2914 42
  t 727 2920 1444
  t 1444 2893 727
  t 367 2921 1444
  t 1444 2920 367
  t 739 2914 1444
  t 1444 2921 739
  t 39 2896 1445
  t 1445 2891 39
  t 736 2922 1445
  t 1445 2896 736
  t 367 2920 1445
  t 1445 2922 367
  t 727 2891 1445
  t 1445 2920 727
  t 43 2923 1446
  t 1446 2902 43
  t 735 2924 1446
  t 1446 2923 735
  t 367 2922 1446
  t 1446 2924 367
  t 736 2902 1446
  t 1446 2922 736
  t 46 2918 1447
  t 1447 2925 46
  t 739 2921 1447
  t 1447 2918 739
  t 367 2924 1447
  t 1447 2921 367
  t 735 2925 1447
  t 1447 2924 735
  t 43 2903 1448
  t 1448 2928 43
  t 732 2926 1448
  t 1448 2903 732
  t 368 2927 1448
  t 1448 2926 368
  t 744 2928 1448
  t 1448 2927 744
  t 44 2929 1449
  t 1449 2899 44
  t 745 2930 1449
  t 1449 2929 745
  t 368 2926 1449
  t 1449 2930 368
  t 732 2899 1449
  t 1449 2926 732
  t 48 2931 1450
  t 1450 2933 48
  t 740 2932 1450
  t 1450 2931 740
  t 368 2930 1450
  t 1450 2932 368
  t 745 2933 1450
  t 1450 2930 745
  t 47 2934 1451
  t 1451 2935 47
  t 744 2927 1451
  t 1451 2934 744
  t 368 2932 1451
  t 1451 2927 368
  t 740 2935 1451
  t 1451 2932 740
  t 44 2911 1452
  t 1452 2929 44
  t 733 2936 1452
  t 1452 2911 733
  t 369 2937 1452
  t 1452 2936 369
  t 745 2929 1452
  t 1452 2937 745
  t 45 2938 1453
  t 1453 2908 45
  t 746 2939 1453
  t 1453 2938 746
  t 369 2936 1453
  t 1453 2939 369
  t 733 2908 1453
  t 1453 2936 733
  t 49 2940 1454
  t 1454 2942 49
  t 741 2941 1454
  t 1454 2940 741
  t 369 2939 1454
  t 1454 2941 369
  t 746 2942 1454
  t 1454 2939 746
  t 48 2933 1455
  t 1455 2943 48
  t 745 2937 1455
  t 1455 2933 745
  t 369 2941 1455
  t 1455 2937 369
  t 741 2943 1455
  t 1455 2941 741
  t 45 2919 1456
  t 1456 2938 45
  t 734 2944 1456
  t 1456 2919 734
  t 370 2945 1456
  t 1456 2944 370
  t 746 2938 1456
  t 1456 2945 746
  t 46 2946 1457
  t 1457 2916 46
  t 747 2947 1457
  t 1457 2946 747
  t 370 2944 1457
  t 1457 2947 370
  t 734 2916 1457
  t 1457 2944 734
  t 50 2948 1458
  t 1458 2950 50
  t 742 2949 1458
  t 1458 2948 742
  t 370 2947 1458
  t 1458 2949 370
  t 747 2950 1458
  t 1458 2947 747
  t 49 2942 1459
  t 1459 2951 49
  t 746 2945 1459
  t 1459 2942 746
  t 370 2949 1459
  t 1459 2945 370
  t 742 2951 1459
  t 1459 2949 742
  t 46 2925 1460
  t 1460 2946 46
  t 735 2952 1460
  t 1460 2925 735
  t 371 2953 1460
  t 1460 2952 371
  t 747 2946 1460
  t 1460 2953 747
  t 43 2928 1461
  t 1461 2923 43
  t 744 2954 1461
  t 1461 2928 744
  t 371 2952 1461
  t 1461 2954 371
  t 735 2923 1461
  t 1461 2952 735
  t 47 2955 1462
  t 1462 2934 47
  t 743 2956 1462
  t 1462 2955 743
  t 371 2954 1462
  t 1462 2956 371
  t 744 2934 1462
  t 1462 2954 744
  t 50 2950 1463
  t 1463 2957 50
  t 747 2953 1463
  t 1463 2950 747
  t 371 2956 1463
  t 1463 2953 371
  t 743 2957 1463
  t 1463 2956 743
  t 47 2935 1464
  t 1464 2960 47
  t 740 2958 1464
  t 1464 2935 740
  t 372 2959 1464
  t 1464 2958 372
  t 752 2960 1464
  t 1464 2959 752
  t 48 2961 1465
  t 1465 2931 48
  t 753 2962 1465
  t 1465 2961 753
  t 372 2958 1465
  t 1465 2962 372
  t 740 2931 1465
  t 1465 2958 740
  t 52 2963 1466
  t 1466 2965 52
  t 748 2964 1466
  t 1466 2963 748
  t 372 2962 1466
  t 1466 2964 372
  t 753 2965 1466
  t 1466 2962 753
  t 51 2966 1467
  t 1467 2967 51
  t 752 2959 1467
  t 1467 2966 752
  t 372 2964 1467
  t 1467 2959 372
  t 748 2967 1467
  t 1467 2964 748
  t 48 2943 1468
  t 1468 2961 48
  t 741 2968 1468
  t 1468 2943 741
  t 373 2969 1468
  t 1468 2968 373
  t 753 2961 1468
  t 1468 2969 753
  t 49 2970 1469
  t 1469 2940 49
  t 754 2971 1469
  t 1469 2970 754
  t 373 2968 1469
  t 1469 2971 373
  t 741 2940 1469
  t 1469 2968 741
  t 53 2972 1470
  t 1470 2974 53
  t 749 2973 1470
  t 1470 2972 749
  t 373 2971 1470
  t 1470 2973 373
  t 754 2974 1470
  t 1470 2971 754
  t 52 2965 1471
  t 1471 2975 52
  t 753 2969 1471
  t 1471 2965 753
  t 373 2973 1471
  t 1471 2969 373
  t 749 2975 1471
  t 1471 2973 749
  t 49 2951 1472
  t 1472 2970 49
  t 742 2976 1472
  t 1472 2951 742
  t 374 2977 1472
  t 1472 2976 374
  t 754 2970 1472
  t 1472 2977 754
  t 50 2978 1473
  t 1473 2948 50
  t 755 2979 1473
  t 1473 2978 755
  t 374 2976 1473
  t 1473 2979 374
  t 742 2948 1473
  t 1473 2976 742
  t 54 2980 1474
  t 1474 2982 54
  t 750 2981 1474
  t 1474 2980 750
  t 374 2979 1474
  t 1474 2981 374
  t 755 2982 1474
  t 1474 2979 755
  t 53 2974 1475
  t 1475 2983 53
  t 754 2977 1475
  t 1475 2974 754
  t 374 2981 1475
  t 1475 2977 374
  t 750 2983 1475
  t 1475 2981 750
  t 50 2957 1476
  t 1476 2978 50
  t 743 2984 1476
  t 1476 2957 743
  t 375 2985 1476
  t 1476 2984 375
  t 755 2978 1476
  t 1476 2985 755
  t 47 2960 1477
  t 1477 2955 47
  t 752 2986 1477
  t 1477 2960 752
  t 375 2984 1477
  t 1477 2986 375
  t 743 2955 1477
  t 1477 2984 743
  t 51 2987 1478
  t 1478 2966 51
  t 751 2988 1478
  t 1478 2987 751
  t 375 2986 1478
  t 1478 2988 375
  t 752 2966 1478
  t 1478 2986 752
  t 54 2982 1479
  t 1479 2989 54
  t 755 2985 1479
  t 1479 2982 755
  t 375 2988 1479
  t 1479 2985 375
  t 751 2989 1479
  t 1479 2988 751
  t 51 2967 1480
  t 1480 2992 51
  t 748 2990 1480
  t 1480 2967 748
  t 376 2991 1480
  t 1480 2990 376
  t 760 2992 1480
  t 1480 2991 760
  t 52 2993 1481
  t 1481 2963 52
  t 761 2994 1481
  t 1481 2993 761
  t 376 2990 1481
  t 1481 2994 376
  t 748 2963 1481
  t 1481 2990 748
  t 56 2856 1482
  t 1482 2996 56
  t 756 2995 1482
  t 1482 2856 756
  t 376 2994 1482
  t 1482 2995 376
  t 761 2996 1482
  t 1482 2994 761
  t 55 2997 1483
  t 1483 2850 55
  t 760 2991 1483
  t 1483 2997 760
  t 376 2995 1483
  t 1483 2991 376
  t 756 2850 1483
  t 1483 2995 756
  t 52 2975 1484
  t 1484 2993 52
  t 749 2998 1484
  t 1484 2975 749
  t 377 2999 1484
  t 1484 2998 377
  t 761 2993 1484
  t 1484 2999 761
  t 53 3000 1485
  t 1485 2972 53
  t 762 3001 1485
  t 1485 3000 762
  t 377 2998 1485
  t 1485 3001 377
  t 749 2972 1485
  t 1485 2998 749
  t 57 2859 1486
  t 1486 3003 57
  t 757 3002 1486
  t 1486 2859 757
  t 377 3001 1486
  t 1486 3002 377
  t 762 3003 1486
  t 1486 3001 762
  t 56 2996 1487
  t 1487 2854 56
  t 761 2999 1487
  t 1487 2996 761
  t 377 3002 1487
  t 1487 2999 377
  t 757 2854 1487
  t 1487 3002 757
  t 53 2983 1488
  t 1488 3000 53
  t 750 3004 1488
  t 1488 2983 750
  t 378 3005 1488
  t 1488 3004 378
  t 762 3000 1488
  t 1488 3005 762
  t 54 3006 1489
  t 1489 2980 54
  t 763 3007 1489
  t 1489 3006 763
  t 378 3004 1489
  t 1489 3007 378
  t 750 2980 1489
  t 1489 3004 750
  t 58 2861 1490
  t 1490 3009 58
  t 758 3008 1490
  t 1490 2861 758
  t 378 3007 1490
  t 1490 3008 378
  t 763 3009 1490
  t 1490 3007 763
  t 57 3003 1491
  t 1491 2857 57
  t 762 3005 1491
  t 1491 3003 762
  t 378 3008 1491
  t 1491 3005 378
  t 758 2857 1491
  t 1491 3008 758
  t 54 2989 1492
  t 1492 3006 54
  t 751 3010 1492
  t 1492 2989 751
  t 379 3011 1492
  t 1492 3010 379
  t 763 3006 1492
  t 1492 3011 763
  t 51 2992 1493
  t 1493 2987 51
  t 760 3012 1493
  t 1493 2992 760
  t 379 3010 1493
  t 1493 3012 379
  t 751 2987 1493
  t 1493 3010 751
  t 55 2853 1494
  t 1494 2997 55
  t 759 3013 1494
  t 1494 2853 759
  t 379 3012 1494
  t 1494 3013 379
  t 760 2997 1494
  t 1494 3012 760
  t 58 3009 1495
  t 1495 2860 58
  t 763 3011 1495
  t 1495 3009 763
  t 379 3013 1495
  t 1495 3011 379
  t 759 2860 1495
  t 1495 3013 759
  t 5167 5350 1496
  t 1496 3016 5167
  t 5221 3014 1496
  t 1496 5350 5221
  t 380 3015 5270
  t 5270 5363 380
  t 770 5365 5270
  t 5270 3015 770
  t 5166 3017 1497
  t 1497 5346 5166
  t 771 3018 5271
  t 5271 5366 771
  t 380 5363 5271
  t 5271 3018 380
  t 5221 5346 1497
  t 1497 3014 5221
  t 60 3019 1498
  t 1498 3021 60
  t 764 3020 1498
  t 1498 3019 764
  t 5188 5367 1498
  t 1498 3020 5188
  t 5224 3021 1498
  t 1498 5367 5224
  t 59 3022 1499
  t 1499 3023 59
  t 5223 5364 1499
  t 1499 3022 5223
  t 5188 3020 1499
  t 1499 5364 5188
  t 764 3023 1499
  t 1499 3020 764
  t 5166 5344 1500
  t 1500 3017 5166
  t 5219 3024 1500
  t 1500 5344 5219
  t 381 3025 5272
  t 5272 5368 381
  t 771 5366 5272
  t 5272 3025 771
  t 5165 3026 1501
  t 1501 5340 5165
  t 772 3027 5273
  t 5273 5370 772
  t 381 5368 5273
  t 5273 3027 381
  t 5219 5340 1501
  t 1501 3024 5219
  t 61 3028 1502
  t 1502 3030 61
  t 765 3029 1502
  t 1502 3028 765
  t 5189 5371 1502
  t 1502 3029 5189
  t 5225 3030 1502
  t 1502 5371 5225
  t 60 3021 1503
  t 1503 3031 60
  t 5224 5369 1503
  t 1503 3021 5224
  t 5189 3029 1503
  t 1503 5369 5189
  t 765 3031 1503
  t 1503 3029 765
  t 5165 5338 1504
  t 1504 3026 5165
  t 5217 3032 1504
  t 1504 5338 5217
  t 382 3033 5274
  t 5274 5372 382
  t 772 5370 5274
  t 5274 3033 772
  t 5164 3034 1505
  t 1505 5334 5164
  t 773 3035 5275
  t 5275 5374 773
  t 382 5372 5275
  t 5275 3035 382
  t 5217 5334 1505
  t 1505 3032 5217
  t 62 3036 1506
  t 1506 3038 62
  t 837 3037 1506
  t 1506 3036 837
  t 5190 5375 1506
  t 1506 3037 5190
  t 5226 3038 1506
  t 1506 5375 5226
  t 95 3039 1507
  t 1507 3041 95
  t 766 3040 1507
  t 1507 3039 766
  t 5190 3037 1507
  t 1507 3040 5190
  t 837 3041 1507
  t 1507 3037 837
  t 61 3030 1508
  t 1508 3042 61
  t 5225 5373 1508
  t 1508 3030 5225
  t 5190 3040 1508
  t 1508 5373 5190
  t 766 3042 1508
  t 1508 3040 766
  t 5164 5332 1509
  t 1509 3034 5164
  t 5215 3043 1509
  t 1509 5332 5215
  t 383 3044 5276
  t 5276 5376 383
  t 773 5374 5276
  t 5276 3044 773
  t 5163 3045 1510
  t 1510 5328 5163
  t 774 3046 5277
  t 5277 5378 774
  t 383 5376 5277
  t 5277 3046 383
  t 5215 5328 1510
  t 1510 3043 5215
  t 63 3047 1511
  t 1511 3049 63
  t 767 3048 1511
  t 1511 3047 767
  t 5191 5379 1511
  t 1511 3048 5191
  t 5227 3049 1511
  t 1511 5379 5227
  t 93 3050 1512
  t 1512 3052 93
  t 834 3051 1512
  t 1512 3050 834
  t 5191 3048 1512
  t 1512 3051 5191
  t 767 3052 1512
  t 1512 3048 767
  t 62 3038 1513
  t 1513 3053 62
  t 5226 5377 1513
  t 1513 3038 5226
  t 5191 3051 1513
  t 1513 5377 5191
  t 834 3053 1513
  t 1513 3051 834
  t 5163 5326 1514
  t 1514 3045 5163
  t 5213 3054 1514
  t 1514 5326 5213
  t 384 3055 5278
  t 5278 5380 384
  t 774 5378 5278
  t 5278 3055 774
  t 5162 3056 1515
  t 1515 5321 5162
  t 775 3057 5279
  t 5279 5382 775
  t 384 5380 5279
  t 5279 3057 384
  t 5213 5321 1515
  t 1515 3054 5213
  t 64 3058 1516
  t 1516 3060 64
  t 768 3059 1516
  t 1516 3058 768
  t 5192 5383 1516
  t 1516 3059 5192
  t 5228 3060 1516
  t 1516 5383 5228
  t 63 3049 1517
  t 1517 3061 63
  t 5227 5381 1517
  t 1517 3049 5227
  t 5192 3059 1517
  t 1517 5381 5192
  t 768 3061 1517
  t 1517 3059 768
  t 5162 3062 1518
  t 1518 3056 5162
  t 708 3063 1518
  t 1518 3062 708
  t 385 3064 5280
  t 5280 5385 385
  t 775 5382 5280
  t 5280 3064 775
  t 152 3065 1519
  t 1519 3067 152
  t 954 3066 5281
  t 5281 5387 954
  t 385 5385 5281
  t 5281 3066 385
  t 708 3067 1519
  t 1519 3063 708
  t 230 3068 1520
  t 1520 3070 230
  t 769 3069 1520
  t 1520 3068 769
  t 5193 5388 1520
  t 1520 3069 5193
  t 5234 3070 1520
  t 1520 5388 5234
  t 64 3060 1521
  t 1521 3071 64
  t 5228 5386 1521
  t 1521 3060 5228
  t 5193 3069 1521
  t 1521 5386 5193
  t 769 3071 1521
  t 1521 3069 769
  t 59 3023 1522
  t 1522 3074 59
  t 764 3072 1522
  t 1522 3023 764
  t 386 3073 1522
  t 1522 3072 386
  t 782 3074 1522
  t 1522 3073 782
  t 60 3075 1523
  t 1523 3019 60
  t 783 3076 1523
  t 1523 3075 783
  t 386 3072 1523
  t 1523 3076 386
  t 764 3019 1523
  t 1523 3072 764
  t 66 3077 1524
  t 1524 3079 66
  t 776 3078 1524
  t 1524 3077 776
  t 386 3076 1524
  t 1524 3078 386
  t 783 3079 1524
  t 1524 3076 783
  t 65 3080 1525
  t 1525 3081 65
  t 782 3073 1525
  t 1525 3080 782
  t 386 3078 1525
  t 1525 3073 386
  t 776 3081 1525
  t 1525 3078 776
  t 60 3031 1526
  t 1526 3075 60
  t 765 3082 1526
  t 1526 3031 765
  t 387 3083 1526
  t 1526 3082 387
  t 783 3075 1526
  t 1526 3083 783
  t 61 3084 1527
  t 1527 3028 61
  t 784 3085 1527
  t 1527 3084 784
  t 387 3082 1527
  t 1527 3085 387
  t 765 3028 1527
  t 1527 3082 765
  t 67 3086 1528
  t 1528 3088 67
  t 777 3087 1528
  t 1528 3086 777
  t 387 3085 1528
  t 1528 3087 387
  t 784 3088 1528
  t 1528 3085 784
  t 66 3079 1529
  t 1529 3089 66
  t 783 3083 1529
  t 1529 3079 783
  t 387 3087 1529
  t 1529 3083 387
  t 777 3089 1529
  t 1529 3087 777
  t 61 3042 1530
  t 1530 3084 61
  t 766 3090 1530
  t 1530 3042 766
  t 388 3091 1530
  t 1530 3090 388
  t 784 3084 1530
  t 1530 3091 784
  t 95 3092 1531
  t 1531 3039 95
  t 836 3093 1531
  t 1531 3092 836
  t 388 3090 1531
  t 1531 3093 388
  t 766 3039 1531
  t 1531 3090 766
  t 94 3094 1532
  t 1532 3096 94
  t 785 3095 1532
  t 1532 3094 785
  t 388 3093 1532
  t 1532 3095 388
  t 836 3096 1532
  t 1532 3093 836
  t 68 3097 1533
  t 1533 3099 68
  t 778 3098 1533
  t 1533 3097 778
  t 388 3095 1533
  t 1533 3098 388
  t 785 3099 1533
  t 1533 3095 785
  t 67 3088 1534
  t 1534 3100 67
  t 784 3091 1534
  t 1534 3088 784
  t 388 3098 1534
  t 1534 3091 388
  t 778 3100 1534
  t 1534 3098 778
  t 94 3101 1535
  t 1535 3094 94
  t 835 3102 1535
  t 1535 3101 835
  t 389 3103 1535
  t 1535 3102 389
  t 785 3094 1535
  t 1535 3103 785
  t 93 3052 1536
  t 1536 3105 93
  t 767 3104 1536
  t 1536 3052 767
  t 389 3102 1536
  t 1536 3104 389
  t 835 3105 1536
  t 1536 3102 835
  t 63 3106 1537
  t 1537 3047 63
  t 786 3107 1537
  t 1537 3106 786
  t 389 3104 1537
  t 1537 3107 389
  t 767 3047 1537
  t 1537 3104 767
  t 69 3108 1538
  t 1538 3110 69
  t 779 3109 1538
  t 1538 3108 779
  t 389 3107 1538
  t 1538 3109 389
  t 786 3110 1538
  t 1538 3107 786
  t 68 3099 1539
  t 1539 3111 68
  t 785 3103 1539
  t 1539 3099 785
  t 389 3109 1539
  t 1539 3103 389
  t 779 3111 1539
  t 1539 3109 779
  t 63 3061 1540
  t 1540 3106 63
  t 768 3112 1540
  t 1540 3061 768
  t 390 3113 1540
  t 1540 3112 390
  t 786 3106 1540
  t 1540 3113 786
  t 64 3114 1541
  t 1541 3058 64
  t 787 3115 1541
  t 1541 3114 787
  t 390 3112 1541
  t 1541 3115 390
  t 768 3058 1541
  t 1541 3112 768
  t 70 3116 1542
  t 1542 3118 70
  t 780 3117 1542
  t 1542 3116 780
  t 390 3115 1542
  t 1542 3117 390
  t 787 3118 1542
  t 1542 3115 787
  t 69 3110 1543
  t 1543 3119 69
  t 786 3113 1543
  t 1543 3110 786
  t 390 3117 1543
  t 1543 3113 390
  t 780 3119 1543
  t 1543 3117 780
  t 64 3071 1544
  t 1544 3114 64
  t 769 3120 1544
  t 1544 3071 769
  t 391 3121 1544
  t 1544 3120 391
  t 787 3114 1544
  t 1544 3121 787
  t 230 3122 1545
  t 1545 3068 230
  t 1099 3123 1545
  t 1545 3122 1099
  t 391 3120 1545
  t 1545 3123 391
  t 769 3068 1545
  t 1545 3120 769
  t 238 3124 1546
  t 1546 3126 238
  t 781 3125 1546
  t 1546 3124 781
  t 391 3123 1546
  t 1546 3125 391
  t 1099 3126 1546
  t 1546 3123 1099
  t 70 3118 1547
  t 1547 3127 70
  t 787 3121 1547
  t 1547 3118 787
  t 391 3125 1547
  t 1547 3121 391
  t 781 3127 1547
  t 1547 3125 781
  t 65 3081 1548
  t 1548 3130 65
  t 776 3128 1548
  t 1548 3081 776
  t 392 3129 1548
  t 1548 3128 392
  t 794 3130 1548
  t 1548 3129 794
  t 66 3131 1549
  t 1549 3077 66
  t 795 3132 1549
  t 1549 3131 795
  t 392 3128 1549
  t 1549 3132 392
  t 776 3077 1549
  t 1549 3128 776
  t 72 3133 1550
  t 1550 3135 72
  t 788 3134 1550
  t 1550 3133 788
  t 392 3132 1550
  t 1550 3134 392
  t 795 3135 1550
  t 1550 3132 795
  t 71 3136 1551
  t 1551 3137 71
  t 794 3129 1551
  t 1551 3136 794
  t 392 3134 1551
  t 1551 3129 392
  t 788 3137 1551
  t 1551 3134 788
  t 66 3089 1552
  t 1552 3131 66
  t 777 3138 1552
  t 1552 3089 777
  t 393 3139 1552
  t 1552 3138 393
  t 795 3131 1552
  t 1552 3139 795
  t 67 3140 1553
  t 1553 3086 67
  t 796 3141 1553
  t 1553 3140 796
  t 393 3138 1553
  t 1553 3141 393
  t 777 3086 1553
  t 1553 3138 777
  t 73 3142 1554
  t 1554 3144 73
  t 789 3143 1554
  t 1554 3142 789
  t 393 3141 1554
  t 1554 3143 393
  t 796 3144 1554
  t 1554 3141 796
  t 72 3135 1555
  t 1555 3145 72
  t 795 3139 1555
  t 1555 3135 795
  t 393 3143 1555
  t 1555 3139 393
  t 789 3145 1555
  t 1555 3143 789
  t 67 3100 1556
  t 1556 3140 67
  t 778 3146 1556
  t 1556 3100 778
  t 394 3147 1556
  t 1556 3146 394
  t 796 3140 1556
  t 1556 3147 796
  t 68 3148 1557
  t 1557 3097 68
  t 797 3149 1557
  t 1557 3148 797
  t 394 3146 1557
  t 1557 3149 394
  t 778 3097 1557
  t 1557 3146 778
  t 74 3150 1558
  t 1558 3152 74
  t 790 3151 1558
  t 1558 3150 790
  t 394 3149 1558
  t 1558 3151 394
  t 797 3152 1558
  t 1558 3149 797
  t 73 3144 1559
  t 1559 3153 73
  t 796 3147 1559
  t 1559 3144 796
  t 394 3151 1559
  t 1559 3147 394
  t 790 3153 1559
  t 1559 3151 790
  t 68 3111 1560
  t 1560 3148 68
  t 779 3154 1560
  t 1560 3111 779
  t 395 3155 1560
  t 1560 3154 395
  t 797 3148 1560
  t 1560 3155 797
  t 69 3156 1561
  t 1561 3108 69
  t 798 3157 1561
  t 1561 3156 798
  t 395 3154 1561
  t 1561 3157 395
  t 779 3108 1561
  t 1561 3154 779
  t 75 3158 1562
  t 1562 3160 75
  t 791 3159 1562
  t 1562 3158 791
  t 395 3157 1562
  t 1562 3159 395
  t 798 3160 1562
  t 1562 3157 798
  t 74 3152 1563
  t 1563 3161 74
  t 797 3155 1563
  t 1563 3152 797
  t 395 3159 1563
  t 1563 3155 395
  t 791 3161 1563
  t 1563 3159 791
  t 69 3119 1564
  t 1564 3156 69
  t 780 3162 1564
  t 1564 3119 780
  t 396 3163 1564
  t 1564 3162 396
  t 798 3156 1564
  t 1564 3163 798
  t 70 3164 1565
  t 1565 3116 70
  t 799 3165 1565
  t 1565 3164 799
  t 396 3162 1565
  t 1565 3165 396
  t 780 3116 1565
  t 1565 3162 780
  t 76 3166 1566
  t 1566 3168 76
  t 792 3167 1566
  t 1566 3166 792
  t 396 3165 1566
  t 1566 3167 396
  t 799 3168 1566
  t 1566 3165 799
  t 75 3160 1567
  t 1567 3169 75
  t 798 3163 1567
  t 1567 3160 798
  t 396 3167 1567
  t 1567 3163 396
  t 792 3169 1567
  t 1567 3167 792
  t 70 3127 1568
  t 1568 3164 70
  t 781 3170 1568
  t 1568 3127 781
  t 397 3171 1568
  t 1568 3170 397
  t 799 3164 1568
  t 1568 3171 799
  t 238 3172 1569
  t 1569 3124 238
  t 1112 3173 1569
  t 1569 3172 1112
  t 397 3170 1569
  t 1569 3173 397
  t 781 3124 1569
  t 1569 3170 781
  t 157 3174 1570
  t 1570 3176 157
  t 793 3175 1570
  t 1570 3174 793
  t 397 3173 1570
  t 1570 3175 397
  t 1112 3176 1570
  t 1570 3173 1112
  t 76 3168 1571
  t 1571 3177 76
  t 799 3171 1571
  t 1571 3168 799
  t 397 3175 1571
  t 1571 3171 397
  t 793 3177 1571
  t 1571 3175 793
  t 71 3137 1572
  t 1572 3180 71
  t 788 3178 1572
  t 1572 3137 788
  t 398 3179 1572
  t 1572 3178 398
  t 806 3180 1572
  t 1572 3179 806
  t 72 3181 1573
  t 1573 3133 72
  t 807 3182 1573
  t 1573 3181 807
  t 398 3178 1573
  t 1573 3182 398
  t 788 3133 1573
  t 1573 3178 788
  t 78 3183 1574
  t 1574 3185 78
  t 800 3184 1574
  t 1574 3183 800
  t 398 3182 1574
  t 1574 3184 398
  t 807 3185 1574
  t 1574 3182 807
  t 77 3186 1575
  t 1575 3187 77
  t 806 3179 1575
  t 1575 3186 806
  t 398 3184 1575
  t 1575 3179 398
  t 800 3187 1575
  t 1575 3184 800
  t 72 3145 1576
  t 1576 3181 72
  t 789 3188 1576
  t 1576 3145 789
  t 399 3189 1576
  t 1576 3188 399
  t 807 3181 1576
  t 1576 3189 807
  t 73 3190 1577
  t 1577 3142 73
  t 808 3191 1577
  t 1577 3190 808
  t 399 3188 1577
  t 1577 3191 399
  t 789 3142 1577
  t 1577 3188 789
  t 79 3192 1578
  t 1578 3194 79
  t 801 3193 1578
  t 1578 3192 801
  t 399 3191 1578
  t 1578 3193 399
  t 808 3194 1578
  t 1578 3191 808
  t 78 3185 1579
  t 1579 3195 78
  t 807 3189 1579
  t 1579 3185 807
  t 399 3193 1579
  t 1579 3189 399
  t 801 3195 1579
  t 1579 3193 801
  t 73 3153 1580
  t 1580 3190 73
  t 790 3196 1580
  t 1580 3153 790
  t 400 3197 1580
  t 1580 3196 400
  t 808 3190 1580
  t 1580 3197 808
  t 74 3198 1581
  t 1581 3150 74
  t 809 3199 1581
  t 1581 3198 809
  t 400 3196 1581
  t 1581 3199 400
  t 790 3150 1581
  t 1581 3196 790
  t 80 3200 1582
  t 1582 3202 80
  t 802 3201 1582
  t 1582 3200 802
  t 400 3199 1582
  t 1582 3201 400
  t 809 3202 1582
  t 1582 3199 809
  t 79 3194 1583
  t 1583 3203 79
  t 808 3197 1583
  t 1583 3194 808
  t 400 3201 1583
  t 1583 3197 400
  t 802 3203 1583
  t 1583 3201 802
  t 74 3161 1584
  t 1584 3198 74
  t 791 3204 1584
  t 1584 3161 791
  t 401 3205 1584
  t 1584 3204 401
  t 809 3198 1584
  t 1584 3205 809
  t 75 3206 1585
  t 1585 3158 75
  t 810 3207 1585
  t 1585 3206 810
  t 401 3204 1585
  t 1585 3207 401
  t 791 3158 1585
  t 1585 3204 791
  t 81 3208 1586
  t 1586 3210 81
  t 803 3209 1586
  t 1586 3208 803
  t 401 3207 1586
  t 1586 3209 401
  t 810 3210 1586
  t 1586 3207 810
  t 80 3202 1587
  t 1587 3211 80
  t 809 3205 1587
  t 1587 3202 809
  t 401 3209 1587
  t 1587 3205 401
  t 803 3211 1587
  t 1587 3209 803
  t 75 3169 1588
  t 1588 3206 75
  t 792 3212 1588
  t 1588 3169 792
  t 402 3213 1588
  t 1588 3212 402
  t 810 3206 1588
  t 1588 3213 810
  t 76 3214 1589
  t 1589 3166 76
  t 811 3215 1589
  t 1589 3214 811
  t 402 3212 1589
  t 1589 3215 402
  t 792 3166 1589
  t 1589 3212 792
  t 82 3216 1590
  t 1590 3218 82
  t 804 3217 1590
  t 1590 3216 804
  t 402 3215 1590
  t 1590 3217 402
  t 811 3218 1590
  t 1590 3215 811
  t 81 3210 1591
  t 1591 3219 81
  t 810 3213 1591
  t 1591 3210 810
  t 402 3217 1591
  t 1591 3213 402
  t 804 3219 1591
  t 1591 3217 804
  t 76 3177 1592
  t 1592 3214 76
  t 793 3220 1592
  t 1592 3177 793
  t 403 3221 1592
  t 1592 3220 403
  t 811 3214 1592
  t 1592 3221 811
  t 157 3222 1593
  t 1593 3174 157
  t 958 3223 1593
  t 1593 3222 958
  t 403 3220 1593
  t 1593 3223 403
  t 793 3174 1593
  t 1593 3220 793
  t 251 3224 1594
  t 1594 3226 251
  t 805 3225 1594
  t 1594 3224 805
  t 403 3223 1594
  t 1594 3225 403
  t 958 3226 1594
  t 1594 3223 958
  t 82 3218 1595
  t 1595 3227 82
  t 811 3221 1595
  t 1595 3218 811
  t 403 3225 1595
  t 1595 3221 403
  t 805 3227 1595
  t 1595 3225 805
  t 77 3187 1596
  t 1596 3230 77
  t 800 3228 1596
  t 1596 3187 800
  t 404 3229 1596
  t 1596 3228 404
  t 818 3230 1596
  t 1596 3229 818
  t 78 3231 1597
  t 1597 3183 78
  t 819 3232 1597
  t 1597 3231 819
  t 404 3228 1597
  t 1597 3232 404
  t 800 3183 1597
  t 1597 3228 800
  t 84 3233 1598
  t 1598 3235 84
  t 812 3234 1598
  t 1598 3233 812
  t 404 3232 1598
  t 1598 3234 404
  t 819 3235 1598
  t 1598 3232 819
  t 83 3236 1599
  t 1599 3237 83
  t 818 3229 1599
  t 1599 3236 818
  t 404 3234 1599
  t 1599 3229 404
  t 812 3237 1599
  t 1599 3234 812
  t 78 3195 1600
  t 1600 3231 78
  t 801 3238 1600
  t 1600 3195 801
  t 405 3239 1600
  t 1600 3238 405
  t 819 3231 1600
  t 1600 3239 819
  t 79 3240 1601
  t 1601 3192 79
  t 820 3241 1601
  t 1601 3240 820
  t 405 3238 1601
  t 1601 3241 405
  t 801 3192 1601
  t 1601 3238 801
  t 85 3242 1602
  t 1602 3244 85
  t 813 3243 1602
  t 1602 3242 813
  t 405 3241 1602
  t 1602 3243 405
  t 820 3244 1602
  t 1602 3241 820
  t 84 3235 1603
  t 1603 3245 84
  t 819 3239 1603
  t 1603 3235 819
  t 405 3243 1603
  t 1603 3239 405
  t 813 3245 1603
  t 1603 3243 813
  t 79 3203 1604
  t 1604 3240 79
  t 802 3246 1604
  t 1604 3203 802
  t 406 3247 1604
  t 1604 3246 406
  t 820 3240 1604
  t 1604 3247 820
  t 80 3248 1605
  t 1605 3200 80
  t 821 3249 1605
  t 1605 3248 821
  t 406 3246 1605
  t 1605 3249 406
  t 802 3200 1605
  t 1605 3246 802
  t 86 3250 1606
  t 1606 3252 86
  t 873 3251 1606
  t 1606 3250 873
  t 406 3249 1606
  t 1606 3251 406
  t 821 3252 1606
  t 1606 3249 821
  t 114 3253 1607
  t 1607 3255 114
  t 814 3254 1607
  t 1607 3253 814
  t 406 3251 1607
  t 1607 3254 406
  t 873 3255 1607
  t 1607 3251 873
  t 85 3244 1608
  t 1608 3256 85
  t 820 3247 1608
  t 1608 3244 820
  t 406 3254 1608
  t 1608 3247 406
  t 814 3256 1608
  t 1608 3254 814
  t 80 3211 1609
  t 1609 3248 80
  t 803 3257 1609
  t 1609 3211 803
  t 407 3258 1609
  t 1609 3257 407
  t 821 3248 1609
  t 1609 3258 821
  t 81 3259 1610
  t 1610 3208 81
  t 822 3260 1610
  t 1610 3259 822
  t 407 3257 1610
  t 1610 3260 407
  t 803 3208 1610
  t 1610 3257 803
  t 87 3261 1611
  t 1611 3263 87
  t 815 3262 1611
  t 1611 3261 815
  t 407 3260 1611
  t 1611 3262 407
  t 822 3263 1611
  t 1611 3260 822
  t 112 3264 1612
  t 1612 3266 112
  t 870 3265 1612
  t 1612 3264 870
  t 407 3262 1612
  t 1612 3265 407
  t 815 3266 1612
  t 1612 3262 815
  t 86 3252 1613
  t 1613 3267 86
  t 821 3258 1613
  t 1613 3252 821
  t 407 3265 1613
  t 1613 3258 407
  t 870 3267 1613
  t 1613 3265 870
  t 81 3219 1614
  t 1614 3259 81
  t 804 3268 1614
  t 1614 3219 804
  t 408 3269 1614
  t 1614 3268 408
  t 822 3259 1614
  t 1614 3269 822
  t 82 3270 1615
  t 1615 3216 82
  t 823 3271 1615
  t 1615 3270 823
  t 408 3268 1615
  t 1615 3271 408
  t 804 3216 1615
  t 1615 3268 804
  t 88 3272 1616
  t 1616 3274 88
  t 816 3273 1616
  t 1616 3272 816
  t 408 3271 1616
  t 1616 3273 408
  t 823 3274 1616
  t 1616 3271 823
  t 87 3263 1617
  t 1617 3275 87
  t 822 3269 1617
  t 1617 3263 822
  t 408 3273 1617
  t 1617 3269 408
  t 816 3275 1617
  t 1617 3273 816
  t 82 3227 1618
  t 1618 3270 82
  t 805 3276 1618
  t 1618 3227 805
  t 409 3277 1618
  t 1618 3276 409
  t 823 3270 1618
  t 1618 3277 823
  t 251 3278 1619
  t 1619 3224 251
  t 1139 3279 1619
  t 1619 3278 1139
  t 409 3276 1619
  t 1619 3279 409
  t 805 3224 1619
  t 1619 3276 805
  t 260 3280 1620
  t 1620 3282 260
  t 817 3281 1620
  t 1620 3280 817
  t 409 3279 1620
  t 1620 3281 409
  t 1139 3282 1620
  t 1620 3279 1139
  t 88 3274 1621
  t 1621 3283 88
  t 823 3277 1621
  t 1621 3274 823
  t 409 3281 1621
  t 1621 3277 409
  t 817 3283 1621
  t 1621 3281 817
  t 83 3237 1622
  t 1622 3286 83
  t 812 3284 1622
  t 1622 3237 812
  t 410 3285 1622
  t 1622 3284 410
  t 828 3286 1622
  t 1622 3285 828
  t 84 3287 1623
  t 1623 3233 84
  t 829 3288 1623
  t 1623 3287 829
  t 410 3284 1623
  t 1623 3288 410
  t 812 3233 1623
  t 1623 3284 812
  t 89 3289 1624
  t 1624 3291 89
  t 824 3290 1624
  t 1624 3289 824
  t 410 3288 1624
  t 1624 3290 410
  t 829 3291 1624
  t 1624 3288 829
  t 262 3292 1625
  t 1625 3294 262
  t 1143 3293 1625
  t 1625 3292 1143
  t 410 3290 1625
  t 1625 3293 410
  t 824 3294 1625
  t 1625 3290 824
  t 263 3295 1626
  t 1626 3296 263
  t 828 3285 1626
  t 1626 3295 828
  t 410 3293 1626
  t 1626 3285 410
  t 1143 3296 1626
  t 1626 3293 1143
  t 84 3245 1627
  t 1627 3287 84
  t 813 3297 1627
  t 1627 3245 813
  t 411 3298 1627
  t 1627 3297 411
  t 829 3287 1627
  t 1627 3298 829
  t 85 3299 1628
  t 1628 3242 85
  t 830 3300 1628
  t 1628 3299 830
  t 411 3297 1628
  t 1628 3300 411
  t 813 3242 1628
  t 1628 3297 813
  t 90 3301 1629
  t 1629 3303 90
  t 825 3302 1629
  t 1629 3301 825
  t 411 3300 1629
  t 1629 3302 411
  t 830 3303 1629
  t 1629 3300 830
  t 89 3291 1630
  t 1630 3304 89
  t 829 3298 1630
  t 1630 3291 829
  t 411 3302 1630
  t 1630 3298 411
  t 825 3304 1630
  t 1630 3302 825
  t 85 3256 1631
  t 1631 3299 85
  t 814 3305 1631
  t 1631 3256 814
  t 412 3306 1631
  t 1631 3305 412
  t 830 3299 1631
  t 1631 3306 830
  t 114 3307 1632
  t 1632 3253 114
  t 872 3308 1632
  t 1632 3307 872
  t 412 3305 1632
  t 1632 3308 412
  t 814 3253 1632
  t 1632 3305 814
  t 113 3309 1633
  t 1633 3311 113
  t 831 3310 1633
  t 1633 3309 831
  t 412 3308 1633
  t 1633 3310 412
  t 872 3311 1633
  t 1633 3308 872
  t 91 3312 1634
  t 1634 3314 91
  t 826 3313 1634
  t 1634 3312 826
  t 412 3310 1634
  t 1634 3313 412
  t 831 3314 1634
  t 1634 3310 831
  t 90 3303 1635
  t 1635 3315 90
  t 830 3306 1635
  t 1635 3303 830
  t 412 3313 1635
  t 1635 3306 412
  t 826 3315 1635
  t 1635 3313 826
  t 113 3316 1636
  t 1636 3309 113
  t 871 3317 1636
  t 1636 3316 871
  t 413 3318 1636
  t 1636 3317 413
  t 831 3309 1636
  t 1636 3318 831
  t 112 3266 1637
  t 1637 3320 112
  t 815 3319 1637
  t 1637 3266 815
  t 413 3317 1637
  t 1637 3319 413
  t 871 3320 1637
  t 1637 3317 871
  t 87 3321 1638
  t 1638 3261 87
  t 832 3322 1638
  t 1638 3321 832
  t 413 3319 1638
  t 1638 3322 413
  t 815 3261 1638
  t 1638 3319 815
  t 92 3323 1639
  t 1639 3325 92
  t 827 3324 1639
  t 1639 3323 827
  t 413 3322 1639
  t 1639 3324 413
  t 832 3325 1639
  t 1639 3322 832
  t 91 3314 1640
  t 1640 3326 91
  t 831 3318 1640
  t 1640 3314 831
  t 413 3324 1640
  t 1640 3318 413
  t 827 3326 1640
  t 1640 3324 827
  t 87 3275 1641
  t 1641 3321 87
  t 816 3327 1641
  t 1641 3275 816
  t 414 3328 1641
  t 1641 3327 414
  t 832 3321 1641
  t 1641 3328 832
  t 88 3329 1642
  t 1642 3272 88
  t 833 3330 1642
  t 1642 3329 833
  t 414 3327 1642
  t 1642 3330 414
  t 816 3272 1642
  t 1642 3327 816
  t 159 3331 1643
  t 1643 3333 159
  t 1154 3332 1643
  t 1643 3331 1154
  t 414 3330 1643
  t 1643 3332 414
  t 833 3333 1643
  t 1643 3330 833
  t 268 3334 1644
  t 1644 3336 268
  t 941 3335 1644
  t 1644 3334 941
  t 414 3332 1644
  t 1644 3335 414
  t 1154 3336 1644
  t 1644 3332 1154
  t 92 3325 1645
  t 1645 3337 92
  t 832 3328 1645
  t 1645 3325 832
  t 414 3335 1645
  t 1645 3328 414
  t 941 3337 1645
  t 1645 3335 941
  t 88 3283 1646
  t 1646 3329 88
  t 817 3338 1646
  t 1646 3283 817
  t 415 3339 1646
  t 1646 3338 415
  t 833 3329 1646
  t 1646 3339 833
  t 260 3340 1647
  t 1647 3280 260
  t 960 3341 1647
  t 1647 3340 960
  t 415 3338 1647
  t 1647 3341 415
  t 817 3280 1647
  t 1647 3338 817
  t 159 3333 1648
  t 1648 3342 159
  t 833 3339 1648
  t 1648 3333 833
  t 415 3341 1648
  t 1648 3339 415
  t 960 3342 1648
  t 1648 3341 960
  t 108 3343 1649
  t 1649 3346 108
  t 862 3344 1649
  t 1649 3343 862
  t 416 3345 1649
  t 1649 3344 416
  t 865 3346 1649
  t 1649 3345 865
  t 109 3347 1650
  t 1650 3349 109
  t 863 3348 1650
  t 1650 3347 863
  t 416 3344 1650
  t 1650 3348 416
  t 862 3349 1650
  t 1650 3344 862
  t 110 3350 1651
  t 1651 3352 110
  t 864 3351 1651
  t 1651 3350 864
  t 416 3348 1651
  t 1651 3351 416
  t 863 3352 1651
  t 1651 3348 863
  t 111 3353 1652
  t 1652 3354 111
  t 865 3345 1652
  t 1652 3353 865
  t 416 3351 1652
  t 1652 3345 416
  t 864 3354 1652
  t 1652 3351 864
  t 62 3053 1653
  t 1653 3357 62
  t 834 3355 1653
  t 1653 3053 834
  t 417 3356 1653
  t 1653 3355 417
  t 842 3357 1653
  t 1653 3356 842
  t 93 3358 1654
  t 1654 3050 93
  t 843 3359 1654
  t 1654 3358 843
  t 417 3355 1654
  t 1654 3359 417
  t 834 3050 1654
  t 1654 3355 834
  t 97 3360 1655
  t 1655 3362 97
  t 838 3361 1655
  t 1655 3360 838
  t 417 3359 1655
  t 1655 3361 417
  t 843 3362 1655
  t 1655 3359 843
  t 96 3363 1656
  t 1656 3364 96
  t 842 3356 1656
  t 1656 3363 842
  t 417 3361 1656
  t 1656 3356 417
  t 838 3364 1656
  t 1656 3361 838
  t 93 3105 1657
  t 1657 3358 93
  t 835 3365 1657
  t 1657 3105 835
  t 418 3366 1657
  t 1657 3365 418
  t 843 3358 1657
  t 1657 3366 843
  t 94 3367 1658
  t 1658 3101 94
  t 844 3368 1658
  t 1658 3367 844
  t 418 3365 1658
  t 1658 3368 418
  t 835 3101 1658
  t 1658 3365 835
  t 98 3369 1659
  t 1659 3371 98
  t 839 3370 1659
  t 1659 3369 839
  t 418 3368 1659
  t 1659 3370 418
  t 844 3371 1659
  t 1659 3368 844
  t 97 3362 1660
  t 1660 3372 97
  t 843 3366 1660
  t 1660 3362 843
  t 418 3370 1660
  t 1660 3366 418
  t 839 3372 1660
  t 1660 3370 839
  t 94 3096 1661
  t 1661 3367 94
  t 836 3373 1661
  t 1661 3096 836
  t 419 3374 1661
  t 1661 3373 419
  t 844 3367 1661
  t 1661 3374 844
  t 95 3375 1662
  t 1662 3092 95
  t 845 3376 1662
  t 1662 3375 845
  t 419 3373 1662
  t 1662 3376 419
  t 836 3092 1662
  t 1662 3373 836
  t 99 3377 1663
  t 1663 3379 99
  t 840 3378 1663
  t 1663 3377 840
  t 419 3376 1663
  t 1663 3378 419
  t 845 3379 1663
  t 1663 3376 845
  t 98 3371 1664
  t 1664 3380 98
  t 844 3374 1664
  t 1664 3371 844
  t 419 3378 1664
  t 1664 3374 419
  t 840 3380 1664
  t 1664 3378 840
  t 95 3041 1665
  t 1665 3375 95
  t 837 3381 1665
  t 1665 3041 837
  t 420 3382 1665
  t 1665 3381 420
  t 845 3375 1665
  t 1665 3382 845
  t 62 3357 1666
  t 1666 3036 62
  t 842 3383 1666
  t 1666 3357 842
  t 420 3381 1666
  t 1666 3383 420
  t 837 3036 1666
  t 1666 3381 837
  t 96 3384 1667
  t 1667 3363 96
  t 841 3385 1667
  t 1667 3384 841
  t 420 3383 1667
  t 1667 3385 420
  t 842 3363 1667
  t 1667 3383 842
  t 99 3379 1668
  t 1668 3386 99
  t 845 3382 1668
  t 1668 3379 845
  t 420 3385 1668
  t 1668 3382 420
  t 841 3386 1668
  t 1668 3385 841
  t 96 3364 1669
  t 1669 3389 96
  t 838 3387 1669
  t 1669 3364 838
  t 421 3388 1669
  t 1669 3387 421
  t 850 3389 1669
  t 1669 3388 850
  t 97 3390 1670
  t 1670 3360 97
  t 851 3391 1670
  t 1670 3390 851
  t 421 3387 1670
  t 1670 3391 421
  t 838 3360 1670
  t 1670 3387 838
  t 101 3392 1671
  t 1671 3394 101
  t 846 3393 1671
  t 1671 3392 846
  t 421 3391 1671
  t 1671 3393 421
  t 851 3394 1671
  t 1671 3391 851
  t 100 3395 1672
  t 1672 3396 100
  t 850 3388 1672
  t 1672 3395 850
  t 421 3393 1672
  t 1672 3388 421
  t 846 3396 1672
  t 1672 3393 846
  t 97 3372 1673
  t 1673 3390 97
  t 839 3397 1673
  t 1673 3372 839
  t 422 3398 1673
  t 1673 3397 422
  t 851 3390 1673
  t 1673 3398 851
  t 98 3399 1674
  t 1674 3369 98
  t 852 3400 1674
  t 1674 3399 852
  t 422 3397 1674
  t 1674 3400 422
  t 839 3369 1674
  t 1674 3397 839
  t 102 3401 1675
  t 1675 3403 102
  t 847 3402 1675
  t 1675 3401 847
  t 422 3400 1675
  t 1675 3402 422
  t 852 3403 1675
  t 1675 3400 852
  t 101 3394 1676
  t 1676 3404 101
  t 851 3398 1676
  t 1676 3394 851
  t 422 3402 1676
  t 1676 3398 422
  t 847 3404 1676
  t 1676 3402 847
  t 98 3380 1677
  t 1677 3399 98
  t 840 3405 1677
  t 1677 3380 840
  t 423 3406 1677
  t 1677 3405 423
  t 852 3399 1677
  t 1677 3406 852
  t 99 3407 1678
  t 1678 3377 99
  t 853 3408 1678
  t 1678 3407 853
  t 423 3405 1678
  t 1678 3408 423
  t 840 3377 1678
  t 1678 3405 840
  t 103 3409 1679
  t 1679 3411 103
  t 848 3410 1679
  t 1679 3409 848
  t 423 3408 1679
  t 1679 3410 423
  t 853 3411 1679
  t 1679 3408 853
  t 102 3403 1680
  t 1680 3412 102
  t 852 3406 1680
  t 1680 3403 852
  t 423 3410 1680
  t 1680 3406 423
  t 848 3412 1680
  t 1680 3410 848
  t 99 3386 1681
  t 1681 3407 99
  t 841 3413 1681
  t 1681 3386 841
  t 424 3414 1681
  t 1681 3413 424
  t 853 3407 1681
  t 1681 3414 853
  t 96 3389 1682
  t 1682 3384 96
  t 850 3415 1682
  t 1682 3389 850
  t 424 3413 1682
  t 1682 3415 424
  t 841 3384 1682
  t 1682 3413 841
  t 100 3416 1683
  t 1683 3395 100
  t 849 3417 1683
  t 1683 3416 849
  t 424 3415 1683
  t 1683 3417 424
  t 850 3395 1683
  t 1683 3415 850
  t 103 3411 1684
  t 1684 3418 103
  t 853 3414 1684
  t 1684 3411 853
  t 424 3417 1684
  t 1684 3414 424
  t 849 3418 1684
  t 1684 3417 849
  t 100 3396 1685
  t 1685 3421 100
  t 846 3419 1685
  t 1685 3396 846
  t 425 3420 1685
  t 1685 3419 425
  t 858 3421 1685
  t 1685 3420 858
  t 101 3422 1686
  t 1686 3392 101
  t 859 3423 1686
  t 1686 3422 859
  t 425 3419 1686
  t 1686 3423 425
  t 846 3392 1686
  t 1686 3419 846
  t 105 3424 1687
  t 1687 3426 105
  t 854 3425 1687
  t 1687 3424 854
  t 425 3423 1687
  t 1687 3425 425
  t 859 3426 1687
  t 1687 3423 859
  t 104 3427 1688
  t 1688 3428 104
  t 858 3420 1688
  t 1688 3427 858
  t 425 3425 1688
  t 1688 3420 425
  t 854 3428 1688
  t 1688 3425 854
  t 101 3404 1689
  t 1689 3422 101
  t 847 3429 1689
  t 1689 3404 847
  t 426 3430 1689
  t 1689 3429 426
  t 859 3422 1689
  t 1689 3430 859
  t 102 3431 1690
  t 1690 3401 102
  t 860 3432 1690
  t 1690 3431 860
  t 426 3429 1690
  t 1690 3432 426
  t 847 3401 1690
  t 1690 3429 847
  t 106 3433 1691
  t 1691 3435 106
  t 855 3434 1691
  t 1691 3433 855
  t 426 3432 1691
  t 1691 3434 426
  t 860 3435 1691
  t 1691 3432 860
  t 105 3426 1692
  t 1692 3436 105
  t 859 3430 1692
  t 1692 3426 859
  t 426 3434 1692
  t 1692 3430 426
  t 855 3436 1692
  t 1692 3434 855
  t 102 3412 1693
  t 1693 3431 102
  t 848 3437 1693
  t 1693 3412 848
  t 427 3438 1693
  t 1693 3437 427
  t 860 3431 1693
  t 1693 3438 860
  t 103 3439 1694
  t 1694 3409 103
  t 861 3440 1694
  t 1694 3439 861
  t 427 3437 1694
  t 1694 3440 427
  t 848 3409 1694
  t 1694 3437 848
  t 107 3441 1695
  t 1695 3443 107
  t 856 3442 1695
  t 1695 3441 856
  t 427 3440 1695
  t 1695 3442 427
  t 861 3443 1695
  t 1695 3440 861
  t 106 3435 1696
  t 1696 3444 106
  t 860 3438 1696
  t 1696 3435 860
  t 427 3442 1696
  t 1696 3438 427
  t 856 3444 1696
  t 1696 3442 856
  t 103 3418 1697
  t 1697 3439 103
  t 849 3445 1697
  t 1697 3418 849
  t 428 3446 1697
  t 1697 3445 428
  t 861 3439 1697
  t 1697 3446 861
  t 100 3421 1698
  t 1698 3416 100
  t 858 3447 1698
  t 1698 3421 858
  t 428 3445 1698
  t 1698 3447 428
  t 849 3416 1698
  t 1698 3445 849
  t 104 3448 1699
  t 1699 3427 104
  t 857 3449 1699
  t 1699 3448 857
  t 428 3447 1699
  t 1699 3449 428
  t 858 3427 1699
  t 1699 3447 858
  t 107 3443 1700
  t 1700 3450 107
  t 861 3446 1700
  t 1700 3443 861
  t 428 3449 1700
  t 1700 3446 428
  t 857 3450 1700
  t 1700 3449 857
  t 104 3428 1701
  t 1701 3453 104
  t 854 3451 1701
  t 1701 3428 854
  t 429 3452 1701
  t 1701 3451 429
  t 866 3453 1701
  t 1701 3452 866
  t 105 3454 1702
  t 1702 3424 105
  t 867 3455 1702
  t 1702 3454 867
  t 429 3451 1702
  t 1702 3455 429
  t 854 3424 1702
  t 1702 3451 854
  t 109 3349 1703
  t 1703 3457 109
  t 862 3456 1703
  t 1703 3349 862
  t 429 3455 1703
  t 1703 3456 429
  t 867 3457 1703
  t 1703 3455 867
  t 108 3458 1704
  t 1704 3343 108
  t 866 3452 1704
  t 1704 3458 866
  t 429 3456 1704
  t 1704 3452 429
  t 862 3343 1704
  t 1704 3456 862
  t 105 3436 1705
  t 1705 3454 105
  t 855 3459 1705
  t 1705 3436 855
  t 430 3460 1705
  t 1705 3459 430
  t 867 3454 1705
  t 1705 3460 867
  t 106 3461 1706
  t 1706 3433 106
  t 868 3462 1706
  t 1706 3461 868
  t 430 3459 1706
  t 1706 3462 430
  t 855 3433 1706
  t 1706 3459 855
  t 110 3352 1707
  t 1707 3464 110
  t 863 3463 1707
  t 1707 3352 863
  t 430 3462 1707
  t 1707 3463 430
  t 868 3464 1707
  t 1707 3462 868
  t 109 3457 1708
  t 1708 3347 109
  t 867 3460 1708
  t 1708 3457 867
  t 430 3463 1708
  t 1708 3460 430
  t 863 3347 1708
  t 1708 3463 863
  t 106 3444 1709
  t 1709 3461 106
  t 856 3465 1709
  t 1709 3444 856
  t 431 3466 1709
  t 1709 3465 431
  t 868 3461 1709
  t 1709 3466 868
  t 107 3467 1710
  t 1710 3441 107
  t 869 3468 1710
  t 1710 3467 869
  t 431 3465 1710
  t 1710 3468 431
  t 856 3441 1710
  t 1710 3465 856
  t 111 3354 1711
  t 1711 3470 111
  t 864 3469 1711
  t 1711 3354 864
  t 431 3468 1711
  t 1711 3469 431
  t 869 3470 1711
  t 1711 3468 869
  t 110 3464 1712
  t 1712 3350 110
  t 868 3466 1712
  t 1712 3464 868
  t 431 3469 1712
  t 1712 3466 431
  t 864 3350 1712
  t 1712 3469 864
  t 107 3450 1713
  t 1713 3467 107
  t 857 3471 1713
  t 1713 3450 857
  t 432 3472 1713
  t 1713 3471 432
  t 869 3467 1713
  t 1713 3472 869
  t 104 3453 1714
  t 1714 3448 104
  t 866 3473 1714
  t 1714 3453 866
  t 432 3471 1714
  t 1714 3473 432
  t 857 3448 1714
  t 1714 3471 857
  t 108 3346 1715
  t 1715 3458 108
  t 865 3474 1715
  t 1715 3346 865
  t 432 3473 1715
  t 1715 3474 432
  t 866 3458 1715
  t 1715 3473 866
  t 111 3470 1716
  t 1716 3353 111
  t 869 3472 1716
  t 1716 3470 869
  t 432 3474 1716
  t 1716 3472 432
  t 865 3353 1716
  t 1716 3474 865
  t 127 3475 1717
  t 1717 3478 127
  t 898 3476 1717
  t 1717 3475 898
  t 433 3477 1717
  t 1717 3476 433
  t 901 3478 1717
  t 1717 3477 901
  t 128 3479 1718
  t 1718 3481 128
  t 899 3480 1718
  t 1718 3479 899
  t 433 3476 1718
  t 1718 3480 433
  t 898 3481 1718
  t 1718 3476 898
  t 129 3482 1719
  t 1719 3484 129
  t 900 3483 1719
  t 1719 3482 900
  t 433 3480 1719
  t 1719 3483 433
  t 899 3484 1719
  t 1719 3480 899
  t 130 3485 1720
  t 1720 3486 130
  t 901 3477 1720
  t 1720 3485 901
  t 433 3483 1720
  t 1720 3477 433
  t 900 3486 1720
  t 1720 3483 900
  t 86 3267 1721
  t 1721 3489 86
  t 870 3487 1721
  t 1721 3267 870
  t 434 3488 1721
  t 1721 3487 434
  t 878 3489 1721
  t 1721 3488 878
  t 112 3490 1722
  t 1722 3264 112
  t 879 3491 1722
  t 1722 3490 879
  t 434 3487 1722
  t 1722 3491 434
  t 870 3264 1722
  t 1722 3487 870
  t 116 3492 1723
  t 1723 3494 116
  t 874 3493 1723
  t 1723 3492 874
  t 434 3491 1723
  t 1723 3493 434
  t 879 3494 1723
  t 1723 3491 879
  t 115 3495 1724
  t 1724 3496 115
  t 878 3488 1724
  t 1724 3495 878
  t 434 3493 1724
  t 1724 3488 434
  t 874 3496 1724
  t 1724 3493 874
  t 112 3320 1725
  t 1725 3490 112
  t 871 3497 1725
  t 1725 3320 871
  t 435 3498 1725
  t 1725 3497 435
  t 879 3490 1725
  t 1725 3498 879
  t 113 3499 1726
  t 1726 3316 113
  t 880 3500 1726
  t 1726 3499 880
  t 435 3497 1726
  t 1726 3500 435
  t 871 3316 1726
  t 1726 3497 871
  t 117 3501 1727
  t 1727 3503 117
  t 875 3502 1727
  t 1727 3501 875
  t 435 3500 1727
  t 1727 3502 435
  t 880 3503 1727
  t 1727 3500 880
  t 116 3494 1728
  t 1728 3504 116
  t 879 3498 1728
  t 1728 3494 879
  t 435 3502 1728
  t 1728 3498 435
  t 875 3504 1728
  t 1728 3502 875
  t 113 3311 1729
  t 1729 3499 113
  t 872 3505 1729
  t 1729 3311 872
  t 436 3506 1729
  t 1729 3505 436
  t 880 3499 1729
  t 1729 3506 880
  t 114 3507 1730
  t 1730 3307 114
  t 881 3508 1730
  t 1730 3507 881
  t 436 3505 1730
  t 1730 3508 436
  t 872 3307 1730
  t 1730 3505 872
  t 118 3509 1731
  t 1731 3511 118
  t 876 3510 1731
  t 1731 3509 876
  t 436 3508 1731
  t 1731 3510 436
  t 881 3511 1731
  t 1731 3508 881
  t 117 3503 1732
  t 1732 3512 117
  t 880 3506 1732
  t 1732 3503 880
  t 436 3510 1732
  t 1732 3506 436
  t 876 3512 1732
  t 1732 3510 876
  t 114 3255 1733
  t 1733 3507 114
  t 873 3513 1733
  t 1733 3255 873
  t 437 3514 1733
  t 1733 3513 437
  t 881 3507 1733
  t 1733 3514 881
  t 86 3489 1734
  t 1734 3250 86
  t 878 3515 1734
  t 1734 3489 878
  t 437 3513 1734
  t 1734 3515 437
  t 873 3250 1734
  t 1734 3513 873
  t 115 3516 1735
  t 1735 3495 115
  t 877 3517 1735
  t 1735 3516 877
  t 437 3515 1735
  t 1735 3517 437
  t 878 3495 1735
  t 1735 3515 878
  t 118 3511 1736
  t 1736 3518 118
  t 881 3514 1736
  t 1736 3511 881
  t 437 3517 1736
  t 1736 3514 437
  t 877 3518 1736
  t 1736 3517 877
  t 115 3496 1737
  t 1737 3521 115
  t 874 3519 1737
  t 1737 3496 874
  t 438 3520 1737
  t 1737 3519 438
  t 886 3521 1737
  t 1737 3520 886
  t 116 3522 1738
  t 1738 3492 116
  t 887 3523 1738
  t 1738 3522 887
  t 438 3519 1738
  t 1738 3523 438
  t 874 3492 1738
  t 1738 3519 874
  t 120 3524 1739
  t 1739 3526 120
  t 882 3525 1739
  t 1739 3524 882
  t 438 3523 1739
  t 1739 3525 438
  t 887 3526 1739
  t 1739 3523 887
  t 119 3527 1740
  t 1740 3528 119
  t 886 3520 1740
  t 1740 3527 886
  t 438 3525 1740
  t 1740 3520 438
  t 882 3528 1740
  t 1740 3525 882
  t 116 3504 1741
  t 1741 3522 116
  t 875 3529 1741
  t 1741 3504 875
  t 439 3530 1741
  t 1741 3529 439
  t 887 3522 1741
  t 1741 3530 887
  t 117 3531 1742
  t 1742 3501 117
  t 888 3532 1742
  t 1742 3531 888
  t 439 3529 1742
  t 1742 3532 439
  t 875 3501 1742
  t 1742 3529 875
  t 121 3533 1743
  t 1743 3535 121
  t 883 3534 1743
  t 1743 3533 883
  t 439 3532 1743
  t 1743 3534 439
  t 888 3535 1743
  t 1743 3532 888
  t 120 3526 1744
  t 1744 3536 120
  t 887 3530 1744
  t 1744 3526 887
  t 439 3534 1744
  t 1744 3530 439
  t 883 3536 1744
  t 1744 3534 883
  t 117 3512 1745
  t 1745 3531 117
  t 876 3537 1745
  t 1745 3512 876
  t 440 3538 1745
  t 1745 3537 440
  t 888 3531 1745
  t 1745 3538 888
  t 118 3539 1746
  t 1746 3509 118
  t 889 3540 1746
  t 1746 3539 889
  t 440 3537 1746
  t 1746 3540 440
  t 876 3509 1746
  t 1746 3537 876
  t 122 3541 1747
  t 1747 3543 122
  t 884 3542 1747
  t 1747 3541 884
  t 440 3540 1747
  t 1747 3542 440
  t 889 3543 1747
  t 1747 3540 889
  t 121 3535 1748
  t 1748 3544 121
  t 888 3538 1748
  t 1748 3535 888
  t 440 3542 1748
  t 1748 3538 440
  t 884 3544 1748
  t 1748 3542 884
  t 118 3518 1749
  t 1749 3539 118
  t 877 3545 1749
  t 1749 3518 877
  t 441 3546 1749
  t 1749 3545 441
  t 889 3539 1749
  t 1749 3546 889
  t 115 3521 1750
  t 1750 3516 115
  t 886 3547 1750
  t 1750 3521 886
  t 441 3545 1750
  t 1750 3547 441
  t 877 3516 1750
  t 1750 3545 877
  t 119 3548 1751
  t 1751 3527 119
  t 885 3549 1751
  t 1751 3548 885
  t 441 3547 1751
  t 1751 3549 441
  t 886 3527 1751
  t 1751 3547 886
  t 122 3543 1752
  t 1752 3550 122
  t 889 3546 1752
  t 1752 3543 889
  t 441 3549 1752
  t 1752 3546 441
  t 885 3550 1752
  t 1752 3549 885
  t 119 3528 1753
  t 1753 3553 119
  t 882 3551 1753
  t 1753 3528 882
  t 442 3552 1753
  t 1753 3551 442
  t 894 3553 1753
  t 1753 3552 894
  t 120 3554 1754
  t 1754 3524 120
  t 895 3555 1754
  t 1754 3554 895
  t 442 3551 1754
  t 1754 3555 442
  t 882 3524 1754
  t 1754 3551 882
  t 124 3556 1755
  t 1755 3558 124
  t 890 3557 1755
  t 1755 3556 890
  t 442 3555 1755
  t 1755 3557 442
  t 895 3558 1755
  t 1755 3555 895
  t 123 3559 1756
  t 1756 3560 123
  t 894 3552 1756
  t 1756 3559 894
  t 442 3557 1756
  t 1756 3552 442
  t 890 3560 1756
  t 1756 3557 890
  t 120 3536 1757
  t 1757 3554 120
  t 883 3561 1757
  t 1757 3536 883
  t 443 3562 1757
  t 1757 3561 443
  t 895 3554 1757
  t 1757 3562 895
  t 121 3563 1758
  t 1758 3533 121
  t 896 3564 1758
  t 1758 3563 896
  t 443 3561 1758
  t 1758 3564 443
  t 883 3533 1758
  t 1758 3561 883
  t 125 3565 1759
  t 1759 3567 125
  t 891 3566 1759
  t 1759 3565 891
  t 443 3564 1759
  t 1759 3566 443
  t 896 3567 1759
  t 1759 3564 896
  t 124 3558 1760
  t 1760 3568 124
  t 895 3562 1760
  t 1760 3558 895
  t 443 3566 1760
  t 1760 3562 443
  t 891 3568 1760
  t 1760 3566 891
  t 121 3544 1761
  t 1761 3563 121
  t 884 3569 1761
  t 1761 3544 884
  t 444 3570 1761
  t 1761 3569 444
  t 896 3563 1761
  t 1761 3570 896
  t 122 3571 1762
  t 1762 3541 122
  t 897 3572 1762
  t 1762 3571 897
  t 444 3569 1762
  t 1762 3572 444
  t 884 3541 1762
  t 1762 3569 884
  t 126 3573 1763
  t 1763 3575 126
  t 892 3574 1763
  t 1763 3573 892
  t 444 3572 1763
  t 1763 3574 444
  t 897 3575 1763
  t 1763 3572 897
  t 125 3567 1764
  t 1764 3576 125
  t 896 3570 1764
  t 1764 3567 896
  t 444 3574 1764
  t 1764 3570 444
  t 892 3576 1764
  t 1764 3574 892
  t 122 3550 1765
  t 1765 3571 122
  t 885 3577 1765
  t 1765 3550 885
  t 445 3578 1765
  t 1765 3577 445
  t 897 3571 1765
  t 1765 3578 897
  t 119 3553 1766
  t 1766 3548 119
  t 894 3579 1766
  t 1766 3553 894
  t 445 3577 1766
  t 1766 3579 445
  t 885 3548 1766
  t 1766 3577 885
  t 123 3580 1767
  t 1767 3559 123
  t 893 3581 1767
  t 1767 3580 893
  t 445 3579 1767
  t 1767 3581 445
  t 894 3559 1767
  t 1767 3579 894
  t 126 3575 1768
  t 1768 3582 126
  t 897 3578 1768
  t 1768 3575 897
  t 445 3581 1768
  t 1768 3578 445
  t 893 3582 1768
  t 1768 3581 893
  t 123 3560 1769
  t 1769 3585 123
  t 890 3583 1769
  t 1769 3560 890
  t 446 3584 1769
  t 1769 3583 446
  t 902 3585 1769
  t 1769 3584 902
  t 124 3586 1770
  t 1770 3556 124
  t 903 3587 1770
  t 1770 3586 903
  t 446 3583 1770
  t 1770 3587 446
  t 890 3556 1770
  t 1770 3583 890
  t 128 3481 1771
  t 1771 3589 128
  t 898 3588 1771
  t 1771 3481 898
  t 446 3587 1771
  t 1771 3588 446
  t 903 3589 1771
  t 1771 3587 903
  t 127 3590 1772
  t 1772 3475 127
  t 902 3584 1772
  t 1772 3590 902
  t 446 3588 1772
  t 1772 3584 446
  t 898 3475 1772
  t 1772 3588 898
  t 124 3568 1773
  t 1773 3586 124
  t 891 3591 1773
  t 1773 3568 891
  t 447 3592 1773
  t 1773 3591 447
  t 903 3586 1773
  t 1773 3592 903
  t 125 3593 1774
  t 1774 3565 125
  t 904 3594 1774
  t 1774 3593 904
  t 447 3591 1774
  t 1774 3594 447
  t 891 3565 1774
  t 1774 3591 891
  t 129 3484 1775
  t 1775 3596 129
  t 899 3595 1775
  t 1775 3484 899
  t 447 3594 1775
  t 1775 3595 447
  t 904 3596 1775
  t 1775 3594 904
  t 128 3589 1776
  t 1776 3479 128
  t 903 3592 1776
  t 1776 3589 903
  t 447 3595 1776
  t 1776 3592 447
  t 899 3479 1776
  t 1776 3595 899
  t 125 3576 1777
  t 1777 3593 125
  t 892 3597 1777
  t 1777 3576 892
  t 448 3598 1777
  t 1777 3597 448
  t 904 3593 1777
  t 1777 3598 904
  t 126 3599 1778
  t 1778 3573 126
  t 905 3600 1778
  t 1778 3599 905
  t 448 3597 1778
  t 1778 3600 448
  t 892 3573 1778
  t 1778 3597 892
  t 130 3486 1779
  t 1779 3602 130
  t 900 3601 1779
  t 1779 3486 900
  t 448 3600 1779
  t 1779 3601 448
  t 905 3602 1779
  t 1779 3600 905
  t 129 3596 1780
  t 1780 3482 129
  t 904 3598 1780
  t 1780 3596 904
  t 448 3601 1780
  t 1780 3598 448
  t 900 3482 1780
  t 1780 3601 900
  t 126 3582 1781
  t 1781 3599 126
  t 893 3603 1781
  t 1781 3582 893
  t 449 3604 1781
  t 1781 3603 449
  t 905 3599 1781
  t 1781 3604 905
  t 123 3585 1782
  t 1782 3580 123
  t 902 3605 1782
  t 1782 3585 902
  t 449 3603 1782
  t 1782 3605 449
  t 893 3580 1782
  t 1782 3603 893
  t 127 3478 1783
  t 1783 3590 127
  t 901 3606 1783
  t 1783 3478 901
  t 449 3605 1783
  t 1783 3606 449
  t 902 3590 1783
  t 1783 3605 902
  t 130 3602 1784
  t 1784 3485 130
  t 905 3604 1784
  t 1784 3602 905
  t 449 3606 1784
  t 1784 3604 449
  t 901 3485 1784
  t 1784 3606 901
  t 12 3607 1785
  t 1785 3610 12
  t 683 3608 1785
  t 1785 3607 683
  t 450 3609 1785
  t 1785 3608 450
  t 906 3610 1785
  t 1785 3609 906
  t 18 3611 1786
  t 1786 3613 18
  t 907 3612 1786
  t 1786 3611 907
  t 450 3608 1786
  t 1786 3612 450
  t 683 3613 1786
  t 1786 3608 683
  t 132 3614 1787
  t 1787 3616 132
  t 910 3615 1787
  t 1787 3614 910
  t 450 3612 1787
  t 1787 3615 450
  t 907 3616 1787
  t 1787 3612 907
  t 131 3617 1788
  t 1788 3618 131
  t 906 3609 1788
  t 1788 3617 906
  t 450 3615 1788
  t 1788 3609 450
  t 910 3618 1788
  t 1788 3615 910
  t 18 2751 1789
  t 1789 3611 18
  t 684 3619 1789
  t 1789 2751 684
  t 451 3620 1789
  t 1789 3619 451
  t 907 3611 1789
  t 1789 3620 907
  t 19 3621 1790
  t 1790 2758 19
  t 908 3622 1790
  t 1790 3621 908
  t 451 3619 1790
  t 1790 3622 451
  t 684 2758 1790
  t 1790 3619 684
  t 133 3623 1791
  t 1791 3625 133
  t 911 3624 1791
  t 1791 3623 911
  t 451 3622 1791
  t 1791 3624 451
  t 908 3625 1791
  t 1791 3622 908
  t 132 3616 1792
  t 1792 3626 132
  t 907 3620 1792
  t 1792 3616 907
  t 451 3624 1792
  t 1792 3620 451
  t 911 3626 1792
  t 1792 3624 911
  t 19 2711 1793
  t 1793 3621 19
  t 685 3627 1793
  t 1793 2711 685
  t 452 3628 1793
  t 1793 3627 452
  t 908 3621 1793
  t 1793 3628 908
  t 13 3629 1794
  t 1794 2706 13
  t 909 3630 1794
  t 1794 3629 909
  t 452 3627 1794
  t 1794 3630 452
  t 685 2706 1794
  t 1794 3627 685
  t 134 3631 1795
  t 1795 3633 134
  t 912 3632 1795
  t 1795 3631 912
  t 452 3630 1795
  t 1795 3632 452
  t 909 3633 1795
  t 1795 3630 909
  t 133 3625 1796
  t 1796 3634 133
  t 908 3628 1796
  t 1796 3625 908
  t 452 3632 1796
  t 1796 3628 452
  t 912 3634 1796
  t 1796 3632 912
  t 13 2658 1797
  t 1797 3629 13
  t 672 3635 1797
  t 1797 2658 672
  t 453 3636 1797
  t 1797 3635 453
  t 909 3629 1797
  t 1797 3636 909
  t 12 3610 1798
  t 1798 2653 12
  t 906 3637 1798
  t 1798 3610 906
  t 453 3635 1798
  t 1798 3637 453
  t 672 2653 1798
  t 1798 3635 672
  t 131 3638 1799
  t 1799 3617 131
  t 913 3639 1799
  t 1799 3638 913
  t 453 3637 1799
  t 1799 3639 453
  t 906 3617 1799
  t 1799 3637 906
  t 134 3633 1800
  t 1800 3640 134
  t 909 3636 1800
  t 1800 3633 909
  t 453 3639 1800
  t 1800 3636 453
  t 913 3640 1800
  t 1800 3639 913
  t 139 3641 1801
  t 1801 3644 139
  t 922 3642 1801
  t 1801 3641 922
  t 454 3643 1801
  t 1801 3642 454
  t 925 3644 1801
  t 1801 3643 925
  t 140 3645 1802
  t 1802 3647 140
  t 923 3646 1802
  t 1802 3645 923
  t 454 3642 1802
  t 1802 3646 454
  t 922 3647 1802
  t 1802 3642 922
  t 141 3648 1803
  t 1803 3650 141
  t 924 3649 1803
  t 1803 3648 924
  t 454 3646 1803
  t 1803 3649 454
  t 923 3650 1803
  t 1803 3646 923
  t 142 3651 1804
  t 1804 3652 142
  t 925 3643 1804
  t 1804 3651 925
  t 454 3649 1804
  t 1804 3643 454
  t 924 3652 1804
  t 1804 3649 924
  t 131 3618 1805
  t 1805 3655 131
  t 910 3653 1805
  t 1805 3618 910
  t 455 3654 1805
  t 1805 3653 455
  t 918 3655 1805
  t 1805 3654 918
  t 132 3656 1806
  t 1806 3614 132
  t 919 3657 1806
  t 1806 3656 919
  t 455 3653 1806
  t 1806 3657 455
  t 910 3614 1806
  t 1806 3653 910
  t 136 3658 1807
  t 1807 3660 136
  t 914 3659 1807
  t 1807 3658 914
  t 455 3657 1807
  t 1807 3659 455
  t 919 3660 1807
  t 1807 3657 919
  t 135 3661 1808
  t 1808 3662 135
  t 918 3654 1808
  t 1808 3661 918
  t 455 3659 1808
  t 1808 3654 455
  t 914 3662 1808
  t 1808 3659 914
  t 132 3626 1809
  t 1809 3656 132
  t 911 3663 1809
  t 1809 3626 911
  t 456 3664 1809
  t 1809 3663 456
  t 919 3656 1809
  t 1809 3664 919
  t 133 3665 1810
  t 1810 3623 133
  t 920 3666 1810
  t 1810 3665 920
  t 456 3663 1810
  t 1810 3666 456
  t 911 3623 1810
  t 1810 3663 911
  t 137 3667 1811
  t 1811 3669 137
  t 915 3668 1811
  t 1811 3667 915
  t 456 3666 1811
  t 1811 3668 456
  t 920 3669 1811
  t 1811 3666 920
  t 136 3660 1812
  t 1812 3670 136
  t 919 3664 1812
  t 1812 3660 919
  t 456 3668 1812
  t 1812 3664 456
  t 915 3670 1812
  t 1812 3668 915
  t 133 3634 1813
  t 1813 3665 133
  t 912 3671 1813
  t 1813 3634 912
  t 457 3672 1813
  t 1813 3671 457
  t 920 3665 1813
  t 1813 3672 920
  t 134 3673 1814
  t 1814 3631 134
  t 921 3674 1814
  t 1814 3673 921
  t 457 3671 1814
  t 1814 3674 457
  t 912 3631 1814
  t 1814 3671 912
  t 138 3675 1815
  t 1815 3677 138
  t 916 3676 1815
  t 1815 3675 916
  t 457 3674 1815
  t 1815 3676 457
  t 921 3677 1815
  t 1815 3674 921
  t 137 3669 1816
  t 1816 3678 137
  t 920 3672 1816
  t 1816 3669 920
  t 457 3676 1816
  t 1816 3672 457
  t 916 3678 1816
  t 1816 3676 916
  t 134 3640 1817
  t 1817 3673 134
  t 913 3679 1817
  t 1817 3640 913
  t 458 3680 1817
  t 1817 3679 458
  t 921 3673 1817
  t 1817 3680 921
  t 131 3655 1818
  t 1818 3638 131
  t 918 3681 1818
  t 1818 3655 918
  t 458 3679 1818
  t 1818 3681 458
  t 913 3638 1818
  t 1818 3679 913
  t 135 3682 1819
  t 1819 3661 135
  t 917 3683 1819
  t 1819 3682 917
  t 458 3681 1819
  t 1819 3683 458
  t 918 3661 1819
  t 1819 3681 918
  t 138 3677 1820
  t 1820 3684 138
  t 921 3680 1820
  t 1820 3677 921
  t 458 3683 1820
  t 1820 3680 458
  t 917 3684 1820
  t 1820 3683 917
  t 135 3662 1821
  t 1821 3687 135
  t 914 3685 1821
  t 1821 3662 914
  t 459 3686 1821
  t 1821 3685 459
  t 926 3687 1821
  t 1821 3686 926
  t 136 3688 1822
  t 1822 3658 136
  t 927 3689 1822
  t 1822 3688 927
  t 459 3685 1822
  t 1822 3689 459
  t 914 3658 1822
  t 1822 3685 914
  t 140 3647 1823
  t 1823 3691 140
  t 922 3690 1823
  t 1823 3647 922
  t 459 3689 1823
  t 1823 3690 459
  t 927 3691 1823
  t 1823 3689 927
  t 139 3692 1824
  t 1824 3641 139
  t 926 3686 1824
  t 1824 3692 926
  t 459 3690 1824
  t 1824 3686 459
  t 922 3641 1824
  t 1824 3690 922
  t 136 3670 1825
  t 1825 3688 136
  t 915 3693 1825
  t 1825 3670 915
  t 460 3694 1825
  t 1825 3693 460
  t 927 3688 1825
  t 1825 3694 927
  t 137 3695 1826
  t 1826 3667 137
  t 928 3696 1826
  t 1826 3695 928
  t 460 3693 1826
  t 1826 3696 460
  t 915 3667 1826
  t 1826 3693 915
  t 141 3650 1827
  t 1827 3698 141
  t 923 3697 1827
  t 1827 3650 923
  t 460 3696 1827
  t 1827 3697 460
  t 928 3698 1827
  t 1827 3696 928
  t 140 3691 1828
  t 1828 3645 140
  t 927 3694 1828
  t 1828 3691 927
  t 460 3697 1828
  t 1828 3694 460
  t 923 3645 1828
  t 1828 3697 923
  t 137 3678 1829
  t 1829 3695 137
  t 916 3699 1829
  t 1829 3678 916
  t 461 3700 1829
  t 1829 3699 461
  t 928 3695 1829
  t 1829 3700 928
  t 138 3701 1830
  t 1830 3675 138
  t 929 3702 1830
  t 1830 3701 929
  t 461 3699 1830
  t 1830 3702 461
  t 916 3675 1830
  t 1830 3699 916
  t 142 3652 1831
  t 1831 3704 142
  t 924 3703 1831
  t 1831 3652 924
  t 461 3702 1831
  t 1831 3703 461
  t 929 3704 1831
  t 1831 3702 929
  t 141 3698 1832
  t 1832 3648 141
  t 928 3700 1832
  t 1832 3698 928
  t 461 3703 1832
  t 1832 3700 461
  t 924 3648 1832
  t 1832 3703 924
  t 138 3684 1833
  t 1833 3701 138
  t 917 3705 1833
  t 1833 3684 917
  t 462 3706 1833
  t 1833 3705 462
  t 929 3701 1833
  t 1833 3706 929
  t 135 3687 1834
  t 1834 3682 135
  t 926 3707 1834
  t 1834 3687 926
  t 462 3705 1834
  t 1834 3707 462
  t 917 3682 1834
  t 1834 3705 917
  t 139 3644 1835
  t 1835 3692 139
  t 925 3708 1835
  t 1835 3644 925
  t 462 3707 1835
  t 1835 3708 462
  t 926 3692 1835
  t 1835 3707 926
  t 142 3704 1836
  t 1836 3651 142
  t 929 3706 1836
  t 1836 3704 929
  t 462 3708 1836
  t 1836 3706 462
  t 925 3651 1836
  t 1836 3708 925
  t 18 3709 1837
  t 1837 3712 18
  t 934 3710 1837
  t 1837 3709 934
  t 463 3711 1837
  t 1837 3710 463
  t 1287 3712 1837
  t 1837 3711 1287
  t 314 3713 1838
  t 1838 3715 314
  t 1247 3714 1838
  t 1838 3713 1247
  t 463 3710 1838
  t 1838 3714 463
  t 934 3715 1838
  t 1838 3710 934
  t 160 3716 1839
  t 1839 3718 160
  t 942 3717 1839
  t 1839 3716 942
  t 463 3714 1839
  t 1839 3717 463
  t 1247 3718 1839
  t 1839 3714 1247
  t 143 3719 1840
  t 1840 3720 143
  t 1287 3711 1840
  t 1840 3719 1287
  t 463 3717 1840
  t 1840 3711 463
  t 942 3720 1840
  t 1840 3717 942
  t 144 3721 1841
  t 1841 3724 144
  t 931 3722 1841
  t 1841 3721 931
  t 464 3723 1841
  t 1841 3722 464
  t 1253 3724 1841
  t 1841 3723 1253
  t 0 3725 1842
  t 1842 3727 0
  t 647 3726 1842
  t 1842 3725 647
  t 464 3722 1842
  t 1842 3726 464
  t 931 3727 1842
  t 1842 3722 931
  t 317 3728 1843
  t 1843 3729 317
  t 1253 3723 1843
  t 1843 3728 1253
  t 464 3726 1843
  t 1843 3723 464
  t 647 3729 1843
  t 1843 3726 647
  t 317 3729 1844
  t 1844 3732 317
  t 647 3730 1844
  t 1844 3729 647
  t 465 3731 1844
  t 1844 3730 465
  t 1255 3732 1844
  t 1844 3731 1255
  t 0 2585 1845
  t 1845 3725 0
  t 648 3733 1845
  t 1845 2585 648
  t 465 3730 1845
  t 1845 3733 465
  t 647 3725 1845
  t 1845 3730 647
  t 1 3734 1846
  t 1846 2592 1
  t 649 3735 1846
  t 1846 3734 649
  t 465 3733 1846
  t 1846 3735 465
  t 648 2592 1846
  t 1846 3733 648
  t 318 3736 1847
  t 1847 3737 318
  t 1255 3731 1847
  t 1847 3736 1255
  t 465 3735 1847
  t 1847 3731 465
  t 649 3737 1847
  t 1847 3735 649
  t 318 3737 1848
  t 1848 3740 318
  t 649 3738 1848
  t 1848 3737 649
  t 466 3739 1848
  t 1848 3738 466
  t 1257 3740 1848
  t 1848 3739 1257
  t 1 2596 1849
  t 1849 3734 1
  t 650 3741 1849
  t 1849 2596 650
  t 466 3738 1849
  t 1849 3741 466
  t 649 3734 1849
  t 1849 3738 649
  t 2 3742 1850
  t 1850 2605 2
  t 651 3743 1850
  t 1850 3742 651
  t 466 3741 1850
  t 1850 3743 466
  t 650 2605 1850
  t 1850 3741 650
  t 319 3744 1851
  t 1851 3745 319
  t 1257 3739 1851
  t 1851 3744 1257
  t 466 3743 1851
  t 1851 3739 466
  t 651 3745 1851
  t 1851 3743 651
  t 319 3745 1852
  t 1852 3748 319
  t 651 3746 1852
  t 1852 3745 651
  t 467 3747 1852
  t 1852 3746 467
  t 943 3748 1852
  t 1852 3747 943
  t 2 2609 1853
  t 1853 3742 2
  t 652 3749 1853
  t 1853 2609 652
  t 467 3746 1853
  t 1853 3749 467
  t 651 3742 1853
  t 1853 3746 651
  t 3 3750 1854
  t 1854 2618 3
  t 653 3751 1854
  t 1854 3750 653
  t 467 3749 1854
  t 1854 3751 467
  t 652 2618 1854
  t 1854 3749 652
  t 145 3752 1855
  t 1855 3753 145
  t 943 3747 1855
  t 1855 3752 943
  t 467 3751 1855
  t 1855 3747 467
  t 653 3753 1855
  t 1855 3751 653
  t 145 3753 1856
  t 1856 3756 145
  t 653 3754 1856
  t 1856 3753 653
  t 468 3755 1856
  t 1856 3754 468
  t 1260 3756 1856
  t 1856 3755 1260
  t 3 2622 1857
  t 1857 3750 3
  t 654 3757 1857
  t 1857 2622 654
  t 468 3754 1857
  t 1857 3757 468
  t 653 3750 1857
  t 1857 3754 653
  t 4 3758 1858
  t 1858 2628 4
  t 655 3759 1858
  t 1858 3758 655
  t 468 3757 1858
  t 1858 3759 468
  t 654 2628 1858
  t 1858 3757 654
  t 320 3760 1859
  t 1859 3761 320
  t 1260 3755 1859
  t 1859 3760 1260
  t 468 3759 1859
  t 1859 3755 468
  t 655 3761 1859
  t 1859 3759 655
  t 320 3761 1860
  t 1860 3764 320
  t 655 3762 1860
  t 1860 3761 655
  t 469 3763 1860
  t 1860 3762 469
  t 944 3764 1860
  t 1860 3763 944
  t 4 2632 1861
  t 1861 3758 4
  t 656 3765 1861
  t 1861 2632 656
  t 469 3762 1861
  t 1861 3765 469
  t 655 3758 1861
  t 1861 3762 655
  t 5 3766 1862
  t 1862 2638 5
  t 657 3767 1862
  t 1862 3766 657
  t 469 3765 1862
  t 1862 3767 469
  t 656 2638 1862
  t 1862 3765 656
  t 146 3768 1863
  t 1863 3769 146
  t 944 3763 1863
  t 1863 3768 944
  t 469 3767 1863
  t 1863 3763 469
  t 657 3769 1863
  t 1863 3767 657
  t 146 3769 1864
  t 1864 3772 146
  t 657 3770 1864
  t 1864 3769 657
  t 470 3771 1864
  t 1864 3770 470
  t 1262 3772 1864
  t 1864 3771 1262
  t 5 2642 1865
  t 1865 3766 5
  t 658 3773 1865
  t 1865 2642 658
  t 470 3770 1865
  t 1865 3773 470
  t 657 3766 1865
  t 1865 3770 657
  t 175 3774 1866
  t 1866 2648 175
  t 1262 3771 1866
  t 1866 3774 1262
  t 470 3773 1866
  t 1866 3771 470
  t 658 2648 1866
  t 1866 3773 658
  t 147 3775 1867
  t 1867 3778 147
  t 932 3776 1867
  t 1867 3775 932
  t 471 3777 1867
  t 1867 3776 471
  t 945 3778 1867
  t 1867 3777 945
  t 6 2588 1868
  t 1868 3780 6
  t 659 3779 1868
  t 1868 2588 659
  t 471 3776 1868
  t 1868 3779 471
  t 932 3780 1868
  t 1868 3776 932
  t 0 3727 1869
  t 1869 2582 0
  t 931 3781 1869
  t 1869 3727 931
  t 471 3779 1869
  t 1869 3781 471
  t 659 2582 1869
  t 1869 3779 659
  t 144 3782 1870
  t 1870 3721 144
  t 945 3777 1870
  t 1870 3782 945
  t 471 3781 1870
  t 1870 3777 471
  t 931 3721 1870
  t 1870 3781 931
  t 149 3783 1871
  t 1871 3786 149
  t 933 3784 1871
  t 1871 3783 933
  t 472 3785 1871
  t 1871 3784 472
  t 947 3786 1871
  t 1871 3785 947
  t 12 2655 1872
  t 1872 3788 12
  t 671 3787 1872
  t 1872 2655 671
  t 472 3784 1872
  t 1872 3787 472
  t 933 3788 1872
  t 1872 3784 933
  t 6 3780 1873
  t 1873 2650 6
  t 932 3789 1873
  t 1873 3780 932
  t 472 3787 1873
  t 1873 3789 472
  t 671 2650 1873
  t 1873 3787 671
  t 147 3790 1874
  t 1874 3775 147
  t 947 3785 1874
  t 1874 3790 947
  t 472 3789 1874
  t 1874 3785 472
  t 932 3775 1874
  t 1874 3789 932
  t 314 3715 1875
  t 1875 3793 314
  t 934 3791 1875
  t 1875 3715 934
  t 473 3792 1875
  t 1875 3791 473
  t 949 3793 1875
  t 1875 3792 949
  t 18 3613 1876
  t 1876 3709 18
  t 683 3794 1876
  t 1876 3613 683
  t 473 3791 1876
  t 1876 3794 473
  t 934 3709 1876
  t 1876 3791 934
  t 12 3788 1877
  t 1877 3607 12
  t 933 3795 1877
  t 1877 3788 933
  t 473 3794 1877
  t 1877 3795 473
  t 683 3607 1877
  t 1877 3794 683
  t 149 3796 1878
  t 1878 3783 149
  t 949 3792 1878
  t 1878 3796 949
  t 473 3795 1878
  t 1878 3792 473
  t 933 3783 1878
  t 1878 3795 933
  t 5171 5389 1879
  t 1879 3799 5171
  t 5211 3797 1879
  t 1879 5389 5211
  t 474 3798 5282
  t 5282 5390 474
  t 951 5392 5282
  t 5282 3798 951
  t 30 2805 1880
  t 1880 5384 30
  t 5212 3800 5283
  t 5283 5323 5212
  t 474 5390 5283
  t 5283 3800 474
  t 5211 5384 1880
  t 1880 3797 5211
  t 24 3801 1881
  t 1881 2800 24
  t 695 3802 1881
  t 1881 3801 695
  t 5194 5393 1881
  t 1881 3802 5194
  t 709 2800 1881
  t 1881 5393 709
  t 313 3803 1882
  t 1882 3804 313
  t 5231 5391 1882
  t 1882 3803 5231
  t 5194 3802 1882
  t 1882 5391 5194
  t 695 3804 1882
  t 1882 3802 695
  t 5172 5361 1883
  t 1883 3807 5172
  t 5230 3805 1883
  t 1883 5361 5230
  t 475 3806 5284
  t 5284 5394 475
  t 953 5396 5284
  t 5284 3806 953
  t 5167 3016 1884
  t 1884 5353 5167
  t 770 3808 5285
  t 5285 5365 770
  t 475 5394 5285
  t 5285 3808 475
  t 5230 5353 1884
  t 1884 3805 5230
  t 59 3809 1885
  t 1885 3022 59
  t 936 3810 1885
  t 1885 3809 936
  t 5195 5397 1885
  t 1885 3810 5195
  t 5223 3022 1885
  t 1885 5397 5223
  t 154 3811 1886
  t 1886 3812 154
  t 5233 5395 1886
  t 1886 3811 5233
  t 5195 3810 1886
  t 1886 5395 5195
  t 936 3812 1886
  t 1886 3810 936
  t 154 3812 1887
  t 1887 3815 154
  t 936 3813 1887
  t 1887 3812 936
  t 476 3814 1887
  t 1887 3813 476
  t 955 3815 1887
  t 1887 3814 955
  t 59 3074 1888
  t 1888 3809 59
  t 782 3816 1888
  t 1888 3074 782
  t 476 3813 1888
  t 1888 3816 476
  t 936 3809 1888
  t 1888 3813 936
  t 65 3817 1889
  t 1889 3080 65
  t 937 3818 1889
  t 1889 3817 937
  t 476 3816 1889
  t 1889 3818 476
  t 782 3080 1889
  t 1889 3816 782
  t 155 3819 1890
  t 1890 3820 155
  t 955 3814 1890
  t 1890 3819 955
  t 476 3818 1890
  t 1890 3814 476
  t 937 3820 1890
  t 1890 3818 937
  t 155 3820 1891
  t 1891 3823 155
  t 937 3821 1891
  t 1891 3820 937
  t 477 3822 1891
  t 1891 3821 477
  t 956 3823 1891
  t 1891 3822 956
  t 65 3130 1892
  t 1892 3817 65
  t 794 3824 1892
  t 1892 3130 794
  t 477 3821 1892
  t 1892 3824 477
  t 937 3817 1892
  t 1892 3821 937
  t 71 3825 1893
  t 1893 3136 71
  t 938 3826 1893
  t 1893 3825 938
  t 477 3824 1893
  t 1893 3826 477
  t 794 3136 1893
  t 1893 3824 794
  t 156 3827 1894
  t 1894 3828 156
  t 956 3822 1894
  t 1894 3827 956
  t 477 3826 1894
  t 1894 3822 477
  t 938 3828 1894
  t 1894 3826 938
  t 156 3828 1895
  t 1895 3831 156
  t 938 3829 1895
  t 1895 3828 938
  t 478 3830 1895
  t 1895 3829 478
  t 957 3831 1895
  t 1895 3830 957
  t 71 3180 1896
  t 1896 3825 71
  t 806 3832 1896
  t 1896 3180 806
  t 478 3829 1896
  t 1896 3832 478
  t 938 3825 1896
  t 1896 3829 938
  t 77 3833 1897
  t 1897 3186 77
  t 939 3834 1897
  t 1897 3833 939
  t 478 3832 1897
  t 1897 3834 478
  t 806 3186 1897
  t 1897 3832 806
  t 321 3835 1898
  t 1898 3836 321
  t 957 3830 1898
  t 1898 3835 957
  t 478 3834 1898
  t 1898 3830 478
  t 939 3836 1898
  t 1898 3834 939
  t 321 3836 1899
  t 1899 3839 321
  t 939 3837 1899
  t 1899 3836 939
  t 479 3838 1899
  t 1899 3837 479
  t 1270 3839 1899
  t 1899 3838 1270
  t 77 3230 1900
  t 1900 3833 77
  t 818 3840 1900
  t 1900 3230 818
  t 479 3837 1900
  t 1900 3840 479
  t 939 3833 1900
  t 1900 3837 939
  t 83 3841 1901
  t 1901 3236 83
  t 940 3842 1901
  t 1901 3841 940
  t 479 3840 1901
  t 1901 3842 479
  t 818 3236 1901
  t 1901 3840 818
  t 158 3843 1902
  t 1902 3844 158
  t 1270 3838 1902
  t 1902 3843 1270
  t 479 3842 1902
  t 1902 3838 479
  t 940 3844 1902
  t 1902 3842 940
  t 158 3844 1903
  t 1903 3847 158
  t 940 3845 1903
  t 1903 3844 940
  t 480 3846 1903
  t 1903 3845 480
  t 959 3847 1903
  t 1903 3846 959
  t 83 3286 1904
  t 1904 3841 83
  t 828 3848 1904
  t 1904 3286 828
  t 480 3845 1904
  t 1904 3848 480
  t 940 3841 1904
  t 1904 3845 940
  t 263 3849 1905
  t 1905 3295 263
  t 959 3846 1905
  t 1905 3849 959
  t 480 3848 1905
  t 1905 3846 480
  t 828 3295 1905
  t 1905 3848 828
  t 161 3850 1906
  t 1906 3853 161
  t 964 3851 1906
  t 1906 3850 964
  t 481 3852 1906
  t 1906 3851 481
  t 961 3853 1906
  t 1906 3852 961
  t 164 3854 1907
  t 1907 3856 164
  t 963 3855 1907
  t 1907 3854 963
  t 481 3851 1907
  t 1907 3855 481
  t 964 3856 1907
  t 1907 3851 964
  t 163 3857 1908
  t 1908 3859 163
  t 962 3858 1908
  t 1908 3857 962
  t 481 3855 1908
  t 1908 3858 481
  t 963 3859 1908
  t 1908 3855 963
  t 162 3860 1909
  t 1909 3861 162
  t 961 3852 1909
  t 1909 3860 961
  t 481 3858 1909
  t 1909 3852 481
  t 962 3861 1909
  t 1909 3858 962
  t 164 3862 1910
  t 1910 3854 164
  t 968 3863 1910
  t 1910 3862 968
  t 482 3864 1910
  t 1910 3863 482
  t 963 3854 1910
  t 1910 3864 963
  t 167 3865 1911
  t 1911 3867 167
  t 967 3866 1911
  t 1911 3865 967
  t 482 3863 1911
  t 1911 3866 482
  t 968 3867 1911
  t 1911 3863 968
  t 166 3868 1912
  t 1912 3870 166
  t 966 3869 1912
  t 1912 3868 966
  t 482 3866 1912
  t 1912 3869 482
  t 967 3870 1912
  t 1912 3866 967
  t 165 3871 1913
  t 1913 3873 165
  t 965 3872 1913
  t 1913 3871 965
  t 482 3869 1913
  t 1913 3872 482
  t 966 3873 1913
  t 1913 3869 966
  t 163 3859 1914
  t 1914 3874 163
  t 963 3864 1914
  t 1914 3859 963
  t 482 3872 1914
  t 1914 3864 482
  t 965 3874 1914
  t 1914 3872 965
  t 167 3875 1915
  t 1915 3865 167
  t 972 3876 1915
  t 1915 3875 972
  t 483 3877 1915
  t 1915 3876 483
  t 967 3865 1915
  t 1915 3877 967
  t 170 3878 1916
  t 1916 3880 170
  t 971 3879 1916
  t 1916 3878 971
  t 483 3876 1916
  t 1916 3879 483
  t 972 3880 1916
  t 1916 3876 972
  t 169 3881 1917
  t 1917 3883 169
  t 970 3882 1917
  t 1917 3881 970
  t 483 3879 1917
  t 1917 3882 483
  t 971 3883 1917
  t 1917 3879 971
  t 168 3884 1918
  t 1918 3886 168
  t 969 3885 1918
  t 1918 3884 969
  t 483 3882 1918
  t 1918 3885 483
  t 970 3886 1918
  t 1918 3882 970
  t 166 3870 1919
  t 1919 3887 166
  t 967 3877 1919
  t 1919 3870 967
  t 483 3885 1919
  t 1919 3877 483
  t 969 3887 1919
  t 1919 3885 969
  t 170 3888 1920
  t 1920 3878 170
  t 975 3889 1920
  t 1920 3888 975
  t 484 3890 1920
  t 1920 3889 484
  t 971 3878 1920
  t 1920 3890 971
  t 172 3891 1921
  t 1921 3893 172
  t 974 3892 1921
  t 1921 3891 974
  t 484 3889 1921
  t 1921 3892 484
  t 975 3893 1921
  t 1921 3889 975
  t 171 3894 1922
  t 1922 3896 171
  t 973 3895 1922
  t 1922 3894 973
  t 484 3892 1922
  t 1922 3895 484
  t 974 3896 1922
  t 1922 3892 974
  t 169 3883 1923
  t 1923 3897 169
  t 971 3890 1923
  t 1923 3883 971
  t 484 3895 1923
  t 1923 3890 484
  t 973 3897 1923
  t 1923 3895 973
  t 172 3898 1924
  t 1924 3891 172
  t 978 3899 1924
  t 1924 3898 978
  t 485 3900 1924
  t 1924 3899 485
  t 974 3891 1924
  t 1924 3900 974
  t 174 3901 1925
  t 1925 3903 174
  t 977 3902 1925
  t 1925 3901 977
  t 485 3899 1925
  t 1925 3902 485
  t 978 3903 1925
  t 1925 3899 978
  t 173 3904 1926
  t 1926 3906 173
  t 976 3905 1926
  t 1926 3904 976
  t 485 3902 1926
  t 1926 3905 485
  t 977 3906 1926
  t 1926 3902 977
  t 171 3896 1927
  t 1927 3907 171
  t 974 3900 1927
  t 1927 3896 974
  t 485 3905 1927
  t 1927 3900 485
  t 976 3907 1927
  t 1927 3905 976
  t 174 3908 1928
  t 1928 3901 174
  t 980 3909 1928
  t 1928 3908 980
  t 486 3910 1928
  t 1928 3909 486
  t 977 3901 1928
  t 1928 3910 977
  t 175 2649 1929
  t 1929 3912 175
  t 946 3911 1929
  t 1929 2649 946
  t 486 3909 1929
  t 1929 3911 486
  t 980 3912 1929
  t 1929 3909 980
  t 148 3913 1930
  t 1930 2645 148
  t 979 3914 1930
  t 1930 3913 979
  t 486 3911 1930
  t 1930 3914 486
  t 946 2645 1930
  t 1930 3911 946
  t 173 3906 1931
  t 1931 3915 173
  t 977 3910 1931
  t 1931 3906 977
  t 486 3914 1931
  t 1931 3910 486
  t 979 3915 1931
  t 1931 3914 979
  t 162 3861 1932
  t 1932 3918 162
  t 962 3916 1932
  t 1932 3861 962
  t 487 3917 1932
  t 1932 3916 487
  t 981 3918 1932
  t 1932 3917 981
  t 163 3919 1933
  t 1933 3857 163
  t 983 3920 1933
  t 1933 3919 983
  t 487 3916 1933
  t 1933 3920 487
  t 962 3857 1933
  t 1933 3916 962
  t 177 3921 1934
  t 1934 3923 177
  t 982 3922 1934
  t 1934 3921 982
  t 487 3920 1934
  t 1934 3922 487
  t 983 3923 1934
  t 1934 3920 983
  t 176 3924 1935
  t 1935 3925 176
  t 981 3917 1935
  t 1935 3924 981
  t 487 3922 1935
  t 1935 3917 487
  t 982 3925 1935
  t 1935 3922 982
  t 163 3874 1936
  t 1936 3919 163
  t 965 3926 1936
  t 1936 3874 965
  t 488 3927 1936
  t 1936 3926 488
  t 983 3919 1936
  t 1936 3927 983
  t 165 3928 1937
  t 1937 3871 165
  t 986 3929 1937
  t 1937 3928 986
  t 488 3926 1937
  t 1937 3929 488
  t 965 3871 1937
  t 1937 3926 965
  t 179 3930 1938
  t 1938 3932 179
  t 985 3931 1938
  t 1938 3930 985
  t 488 3929 1938
  t 1938 3931 488
  t 986 3932 1938
  t 1938 3929 986
  t 178 3933 1939
  t 1939 3935 178
  t 984 3934 1939
  t 1939 3933 984
  t 488 3931 1939
  t 1939 3934 488
  t 985 3935 1939
  t 1939 3931 985
  t 177 3923 1940
  t 1940 3936 177
  t 983 3927 1940
  t 1940 3923 983
  t 488 3934 1940
  t 1940 3927 488
  t 984 3936 1940
  t 1940 3934 984
  t 168 3886 1941
  t 1941 3939 168
  t 970 3937 1941
  t 1941 3886 970
  t 489 3938 1941
  t 1941 3937 489
  t 987 3939 1941
  t 1941 3938 987
  t 169 3940 1942
  t 1942 3881 169
  t 989 3941 1942
  t 1942 3940 989
  t 489 3937 1942
  t 1942 3941 489
  t 970 3881 1942
  t 1942 3937 970
  t 180 3942 1943
  t 1943 3944 180
  t 988 3943 1943
  t 1943 3942 988
  t 489 3941 1943
  t 1943 3943 489
  t 989 3944 1943
  t 1943 3941 989
  t 178 3935 1944
  t 1944 3946 178
  t 985 3945 1944
  t 1944 3935 985
  t 489 3943 1944
  t 1944 3945 489
  t 988 3946 1944
  t 1944 3943 988
  t 179 3947 1945
  t 1945 3930 179
  t 987 3938 1945
  t 1945 3947 987
  t 489 3945 1945
  t 1945 3938 489
  t 985 3930 1945
  t 1945 3945 985
  t 169 3897 1946
  t 1946 3940 169
  t 973 3948 1946
  t 1946 3897 973
  t 490 3949 1946
  t 1946 3948 490
  t 989 3940 1946
  t 1946 3949 989
  t 171 3950 1947
  t 1947 3894 171
  t 991 3951 1947
  t 1947 3950 991
  t 490 3948 1947
  t 1947 3951 490
  t 973 3894 1947
  t 1947 3948 973
  t 181 3952 1948
  t 1948 3954 181
  t 990 3953 1948
  t 1948 3952 990
  t 490 3951 1948
  t 1948 3953 490
  t 991 3954 1948
  t 1948 3951 991
  t 180 3944 1949
  t 1949 3955 180
  t 989 3949 1949
  t 1949 3944 989
  t 490 3953 1949
  t 1949 3949 490
  t 990 3955 1949
  t 1949 3953 990
  t 171 3907 1950
  t 1950 3950 171
  t 976 3956 1950
  t 1950 3907 976
  t 491 3957 1950
  t 1950 3956 491
  t 991 3950 1950
  t 1950 3957 991
  t 173 3958 1951
  t 1951 3904 173
  t 993 3959 1951
  t 1951 3958 993
  t 491 3956 1951
  t 1951 3959 491
  t 976 3904 1951
  t 1951 3956 976
  t 182 3960 1952
  t 1952 3962 182
  t 992 3961 1952
  t 1952 3960 992
  t 491 3959 1952
  t 1952 3961 491
  t 993 3962 1952
  t 1952 3959 993
  t 181 3954 1953
  t 1953 3963 181
  t 991 3957 1953
  t 1953 3954 991
  t 491 3961 1953
  t 1953 3957 491
  t 992 3963 1953
  t 1953 3961 992
  t 173 3915 1954
  t 1954 3958 173
  t 979 3964 1954
  t 1954 3915 979
  t 492 3965 1954
  t 1954 3964 492
  t 993 3958 1954
  t 1954 3965 993
  t 148 2705 1955
  t 1955 3913 148
  t 948 3966 1955
  t 1955 2705 948
  t 492 3964 1955
  t 1955 3966 492
  t 979 3913 1955
  t 1955 3964 979
  t 183 3967 1956
  t 1956 2702 183
  t 994 3968 1956
  t 1956 3967 994
  t 492 3966 1956
  t 1956 3968 492
  t 948 2702 1956
  t 1956 3966 948
  t 182 3962 1957
  t 1957 3969 182
  t 993 3965 1957
  t 1957 3962 993
  t 492 3968 1957
  t 1957 3965 492
  t 994 3969 1957
  t 1957 3968 994
  t 177 3936 1958
  t 1958 3972 177
  t 984 3970 1958
  t 1958 3936 984
  t 493 3971 1958
  t 1958 3970 493
  t 995 3972 1958
  t 1958 3971 995
  t 178 3973 1959
  t 1959 3933 178
  t 997 3974 1959
  t 1959 3973 997
  t 493 3970 1959
  t 1959 3974 493
  t 984 3933 1959
  t 1959 3970 984
  t 185 3975 1960
  t 1960 3977 185
  t 996 3976 1960
  t 1960 3975 996
  t 493 3974 1960
  t 1960 3976 493
  t 997 3977 1960
  t 1960 3974 997
  t 184 3978 1961
  t 1961 3979 184
  t 995 3971 1961
  t 1961 3978 995
  t 493 3976 1961
  t 1961 3971 493
  t 996 3979 1961
  t 1961 3976 996
  t 178 3946 1962
  t 1962 3973 178
  t 988 3980 1962
  t 1962 3946 988
  t 494 3981 1962
  t 1962 3980 494
  t 997 3973 1962
  t 1962 3981 997
  t 180 3982 1963
  t 1963 3942 180
  t 999 3983 1963
  t 1963 3982 999
  t 494 3980 1963
  t 1963 3983 494
  t 988 3942 1963
  t 1963 3980 988
  t 186 3984 1964
  t 1964 3986 186
  t 998 3985 1964
  t 1964 3984 998
  t 494 3983 1964
  t 1964 3985 494
  t 999 3986 1964
  t 1964 3983 999
  t 185 3977 1965
  t 1965 3987 185
  t 997 3981 1965
  t 1965 3977 997
  t 494 3985 1965
  t 1965 3981 494
  t 998 3987 1965
  t 1965 3985 998
  t 180 3955 1966
  t 1966 3982 180
  t 990 3988 1966
  t 1966 3955 990
  t 495 3989 1966
  t 1966 3988 495
  t 999 3982 1966
  t 1966 3989 999
  t 181 3990 1967
  t 1967 3952 181
  t 1001 3991 1967
  t 1967 3990 1001
  t 495 3988 1967
  t 1967 3991 495
  t 990 3952 1967
  t 1967 3988 990
  t 187 3992 1968
  t 1968 3994 187
  t 1000 3993 1968
  t 1968 3992 1000
  t 495 3991 1968
  t 1968 3993 495
  t 1001 3994 1968
  t 1968 3991 1001
  t 186 3986 1969
  t 1969 3995 186
  t 999 3989 1969
  t 1969 3986 999
  t 495 3993 1969
  t 1969 3989 495
  t 1000 3995 1969
  t 1969 3993 1000
  t 181 3963 1970
  t 1970 3990 181
  t 992 3996 1970
  t 1970 3963 992
  t 496 3997 1970
  t 1970 3996 496
  t 1001 3990 1970
  t 1970 3997 1001
  t 182 3998 1971
  t 1971 3960 182
  t 1003 3999 1971
  t 1971 3998 1003
  t 496 3996 1971
  t 1971 3999 496
  t 992 3960 1971
  t 1971 3996 992
  t 188 4000 1972
  t 1972 4002 188
  t 1002 4001 1972
  t 1972 4000 1002
  t 496 3999 1972
  t 1972 4001 496
  t 1003 4002 1972
  t 1972 3999 1003
  t 187 3994 1973
  t 1973 4003 187
  t 1001 3997 1973
  t 1973 3994 1001
  t 496 4001 1973
  t 1973 3997 496
  t 1002 4003 1973
  t 1973 4001 1002
  t 182 3969 1974
  t 1974 3998 182
  t 994 4004 1974
  t 1974 3969 994
  t 497 4005 1974
  t 1974 4004 497
  t 1003 3998 1974
  t 1974 4005 1003
  t 183 2747 1975
  t 1975 3967 183
  t 1005 4006 1975
  t 1975 2747 1005
  t 497 4004 1975
  t 1975 4006 497
  t 994 3967 1975
  t 1975 4004 994
  t 150 4007 1976
  t 1976 2744 150
  t 1004 4008 1976
  t 1976 4007 1004
  t 497 4006 1976
  t 1976 4008 497
  t 1005 2744 1976
  t 1976 4006 1005
  t 188 4002 1977
  t 1977 4009 188
  t 1003 4005 1977
  t 1977 4002 1003
  t 497 4008 1977
  t 1977 4005 497
  t 1004 4009 1977
  t 1977 4008 1004
  t 189 4010 1978
  t 1978 4013 189
  t 1009 4011 1978
  t 1978 4010 1009
  t 498 4012 1978
  t 1978 4011 498
  t 1006 4013 1978
  t 1978 4012 1006
  t 184 4014 1979
  t 1979 4016 184
  t 1008 4015 1979
  t 1979 4014 1008
  t 498 4011 1979
  t 1979 4015 498
  t 1009 4016 1979
  t 1979 4011 1009
  t 191 4017 1980
  t 1980 4019 191
  t 1007 4018 1980
  t 1980 4017 1007
  t 498 4015 1980
  t 1980 4018 498
  t 1008 4019 1980
  t 1980 4015 1008
  t 190 4020 1981
  t 1981 4021 190
  t 1006 4012 1981
  t 1981 4020 1006
  t 498 4018 1981
  t 1981 4012 498
  t 1007 4021 1981
  t 1981 4018 1007
  t 184 3979 1982
  t 1982 4014 184
  t 996 4022 1982
  t 1982 3979 996
  t 499 4023 1982
  t 1982 4022 499
  t 1008 4014 1982
  t 1982 4023 1008
  t 185 4024 1983
  t 1983 3975 185
  t 1011 4025 1983
  t 1983 4024 1011
  t 499 4022 1983
  t 1983 4025 499
  t 996 3975 1983
  t 1983 4022 996
  t 192 4026 1984
  t 1984 4028 192
  t 1010 4027 1984
  t 1984 4026 1010
  t 499 4025 1984
  t 1984 4027 499
  t 1011 4028 1984
  t 1984 4025 1011
  t 191 4019 1985
  t 1985 4029 191
  t 1008 4023 1985
  t 1985 4019 1008
  t 499 4027 1985
  t 1985 4023 499
  t 1010 4029 1985
  t 1985 4027 1010
  t 185 3987 1986
  t 1986 4024 185
  t 998 4030 1986
  t 1986 3987 998
  t 500 4031 1986
  t 1986 4030 500
  t 1011 4024 1986
  t 1986 4031 1011
  t 186 4032 1987
  t 1987 3984 186
  t 1013 4033 1987
  t 1987 4032 1013
  t 500 4030 1987
  t 1987 4033 500
  t 998 3984 1987
  t 1987 4030 998
  t 193 4034 1988
  t 1988 4036 193
  t 1012 4035 1988
  t 1988 4034 1012
  t 500 4033 1988
  t 1988 4035 500
  t 1013 4036 1988
  t 1988 4033 1013
  t 192 4028 1989
  t 1989 4037 192
  t 1011 4031 1989
  t 1989 4028 1011
  t 500 4035 1989
  t 1989 4031 500
  t 1012 4037 1989
  t 1989 4035 1012
  t 186 3995 1990
  t 1990 4032 186
  t 1000 4038 1990
  t 1990 3995 1000
  t 501 4039 1990
  t 1990 4038 501
  t 1013 4032 1990
  t 1990 4039 1013
  t 187 4040 1991
  t 1991 3992 187
  t 1015 4041 1991
  t 1991 4040 1015
  t 501 4038 1991
  t 1991 4041 501
  t 1000 3992 1991
  t 1991 4038 1000
  t 194 4042 1992
  t 1992 4044 194
  t 1014 4043 1992
  t 1992 4042 1014
  t 501 4041 1992
  t 1992 4043 501
  t 1015 4044 1992
  t 1992 4041 1015
  t 193 4036 1993
  t 1993 4045 193
  t 1013 4039 1993
  t 1993 4036 1013
  t 501 4043 1993
  t 1993 4039 501
  t 1014 4045 1993
  t 1993 4043 1014
  t 187 4003 1994
  t 1994 4040 187
  t 1002 4046 1994
  t 1994 4003 1002
  t 502 4047 1994
  t 1994 4046 502
  t 1015 4040 1994
  t 1994 4047 1015
  t 188 4048 1995
  t 1995 4000 188
  t 1017 4049 1995
  t 1995 4048 1017
  t 502 4046 1995
  t 1995 4049 502
  t 1002 4000 1995
  t 1995 4046 1002
  t 195 4050 1996
  t 1996 4052 195
  t 1016 4051 1996
  t 1996 4050 1016
  t 502 4049 1996
  t 1996 4051 502
  t 1017 4052 1996
  t 1996 4049 1017
  t 194 4044 1997
  t 1997 4053 194
  t 1015 4047 1997
  t 1997 4044 1015
  t 502 4051 1997
  t 1997 4047 502
  t 1016 4053 1997
  t 1997 4051 1016
  t 188 4009 1998
  t 1998 4048 188
  t 1004 4054 1998
  t 1998 4009 1004
  t 503 4055 1998
  t 1998 4054 503
  t 1017 4048 1998
  t 1998 4055 1017
  t 150 2799 1999
  t 1999 4007 150
  t 950 4056 1999
  t 1999 2799 950
  t 503 4054 1999
  t 1999 4056 503
  t 1004 4007 1999
  t 1999 4054 1004
  t 5169 4057 2000
  t 2000 5317 5169
  t 1018 4058 5286
  t 5286 5398 1018
  t 503 4056 5286
  t 5286 4058 503
  t 950 5316 5286
  t 5286 4056 950
  t 195 4052 2001
  t 2001 4059 195
  t 1017 4055 2001
  t 2001 4052 1017
  t 503 4058 2001
  t 2001 4055 503
  t 1018 4059 2001
  t 2001 4058 1018
  t 190 4021 2002
  t 2002 4062 190
  t 1007 4060 2002
  t 2002 4021 1007
  t 504 4061 2002
  t 2002 4060 504
  t 1019 4062 2002
  t 2002 4061 1019
  t 191 4063 2003
  t 2003 4017 191
  t 1021 4064 2003
  t 2003 4063 1021
  t 504 4060 2003
  t 2003 4064 504
  t 1007 4017 2003
  t 2003 4060 1007
  t 197 4065 2004
  t 2004 4067 197
  t 1020 4066 2004
  t 2004 4065 1020
  t 5196 5401 5287
  t 5287 5403 5196
  t 5238 5404 5287
  t 5287 5401 5238
  t 196 4068 2005
  t 2005 4069 196
  t 5236 5400 5288
  t 5288 5405 5236
  t 5196 5403 5288
  t 5288 5400 5196
  t 1020 4069 2005
  t 2005 4066 1020
  t 191 4029 2006
  t 2006 4063 191
  t 1010 4070 2006
  t 2006 4029 1010
  t 505 4071 2006
  t 2006 4070 505
  t 1021 4063 2006
  t 2006 4071 1021
  t 192 4072 2007
  t 2007 4026 192
  t 1023 4073 2007
  t 2007 4072 1023
  t 505 4070 2007
  t 2007 4073 505
  t 1010 4026 2007
  t 2007 4070 1010
  t 198 4074 2008
  t 2008 4076 198
  t 1022 4075 2008
  t 2008 4074 1022
  t 5197 5408 5289
  t 5289 5410 5197
  t 5240 5411 5289
  t 5289 5408 5240
  t 197 4067 2009
  t 2009 4077 197
  t 5238 5407 5290
  t 5290 5404 5238
  t 5197 5410 5290
  t 5290 5407 5197
  t 1022 4077 2009
  t 2009 4075 1022
  t 192 4037 2010
  t 2010 4072 192
  t 1012 4078 2010
  t 2010 4037 1012
  t 506 4079 2010
  t 2010 4078 506
  t 1023 4072 2010
  t 2010 4079 1023
  t 193 4080 2011
  t 2011 4034 193
  t 1025 4081 2011
  t 2011 4080 1025
  t 506 4078 2011
  t 2011 4081 506
  t 1012 4034 2011
  t 2011 4078 1012
  t 199 4082 2012
  t 2012 4084 199
  t 1024 4083 2012
  t 2012 4082 1024
  t 5198 5414 5291
  t 5291 5416 5198
  t 5242 5417 5291
  t 5291 5414 5242
  t 198 4076 2013
  t 2013 4085 198
  t 5240 5413 5292
  t 5292 5411 5240
  t 5198 5416 5292
  t 5292 5413 5198
  t 1024 4085 2013
  t 2013 4083 1024
  t 193 4045 2014
  t 2014 4080 193
  t 1014 4086 2014
  t 2014 4045 1014
  t 507 4087 2014
  t 2014 4086 507
  t 1025 4080 2014
  t 2014 4087 1025
  t 194 4088 2015
  t 2015 4042 194
  t 1027 4089 2015
  t 2015 4088 1027
  t 507 4086 2015
  t 2015 4089 507
  t 1014 4042 2015
  t 2015 4086 1014
  t 200 4090 2016
  t 2016 4092 200
  t 1026 4091 2016
  t 2016 4090 1026
  t 5199 5420 5293
  t 5293 5422 5199
  t 5244 5423 5293
  t 5293 5420 5244
  t 199 4084 2017
  t 2017 4093 199
  t 5242 5419 5294
  t 5294 5417 5242
  t 5199 5422 5294
  t 5294 5419 5199
  t 1026 4093 2017
  t 2017 4091 1026
  t 194 4053 2018
  t 2018 4088 194
  t 1016 4094 2018
  t 2018 4053 1016
  t 508 4095 2018
  t 2018 4094 508
  t 1027 4088 2018
  t 2018 4095 1027
  t 195 4096 2019
  t 2019 4050 195
  t 1029 4097 2019
  t 2019 4096 1029
  t 508 4094 2019
  t 2019 4097 508
  t 1016 4050 2019
  t 2019 4094 1016
  t 201 4098 2020
  t 2020 4100 201
  t 1028 4099 2020
  t 2020 4098 1028
  t 5200 5426 5295
  t 5295 5428 5200
  t 5246 5429 5295
  t 5295 5426 5246
  t 200 4092 2021
  t 2021 4101 200
  t 5244 5425 5296
  t 5296 5423 5244
  t 5200 5428 5296
  t 5296 5425 5200
  t 1028 4101 2021
  t 2021 4099 1028
  t 195 4059 2022
  t 2022 4096 195
  t 1018 4102 2022
  t 2022 4059 1018
  t 509 4103 2022
  t 2022 4102 509
  t 1029 4096 2022
  t 2022 4103 1029
  t 5170 5362 2023
  t 2023 5399 5170
  t 5232 4104 2023
  t 2023 5362 5232
  t 5201 5431 5297
  t 5297 5433 5201
  t 5235 4057 5297
  t 5297 5431 5235
  t 5173 4105 2024
  t 2024 5357 5173
  t 1030 4106 2024
  t 2024 4105 1030
  t 5201 5433 5298
  t 5298 5435 5201
  t 5232 5357 2024
  t 2024 4104 5232
  t 201 4100 2025
  t 2025 4107 201
  t 5246 5432 5299
  t 5299 5429 5246
  t 5201 5435 5299
  t 5299 5432 5201
  t 1030 4107 2025
  t 2025 4106 1030
  t 202 4108 2026
  t 2026 4111 202
  t 1034 4109 2026
  t 2026 4108 1034
  t 510 4110 2026
  t 2026 4109 510
  t 1031 4111 2026
  t 2026 4110 1031
  t 205 4112 2027
  t 2027 4114 205
  t 1033 4113 2027
  t 2027 4112 1033
  t 510 4109 2027
  t 2027 4113 510
  t 1034 4114 2027
  t 2027 4109 1034
  t 204 4115 2028
  t 2028 4117 204
  t 1032 4116 2028
  t 2028 4115 1032
  t 510 4113 2028
  t 2028 4116 510
  t 1033 4117 2028
  t 2028 4113 1033
  t 203 4118 2029
  t 2029 4119 203
  t 1031 4110 2029
  t 2029 4118 1031
  t 510 4116 2029
  t 2029 4110 510
  t 1032 4119 2029
  t 2029 4116 1032
  t 166 4120 2030
  t 2030 3868 166
  t 1037 4121 2030
  t 2030 4120 1037
  t 511 4122 2030
  t 2030 4121 511
  t 966 3868 2030
  t 2030 4122 966
  t 207 4123 2031
  t 2031 4125 207
  t 1036 4124 2031
  t 2031 4123 1036
  t 511 4121 2031
  t 2031 4124 511
  t 1037 4125 2031
  t 2031 4121 1037
  t 206 4126 2032
  t 2032 4128 206
  t 1035 4127 2032
  t 2032 4126 1035
  t 511 4124 2032
  t 2032 4127 511
  t 1036 4128 2032
  t 2032 4124 1036
  t 165 3873 2033
  t 2033 4129 165
  t 966 4122 2033
  t 2033 3873 966
  t 511 4127 2033
  t 2033 4122 511
  t 1035 4129 2033
  t 2033 4127 1035
  t 165 4129 2034
  t 2034 3928 165
  t 1035 4130 2034
  t 2034 4129 1035
  t 512 4131 2034
  t 2034 4130 512
  t 986 3928 2034
  t 2034 4131 986
  t 206 4132 2035
  t 2035 4126 206
  t 1039 4133 2035
  t 2035 4132 1039
  t 512 4130 2035
  t 2035 4133 512
  t 1035 4126 2035
  t 2035 4130 1035
  t 208 4134 2036
  t 2036 4136 208
  t 1038 4135 2036
  t 2036 4134 1038
  t 512 4133 2036
  t 2036 4135 512
  t 1039 4136 2036
  t 2036 4133 1039
  t 179 3932 2037
  t 2037 4137 179
  t 986 4131 2037
  t 2037 3932 986
  t 512 4135 2037
  t 2037 4131 512
  t 1038 4137 2037
  t 2037 4135 1038
  t 179 4137 2038
  t 2038 3947 179
  t 1038 4138 2038
  t 2038 4137 1038
  t 513 4139 2038
  t 2038 4138 513
  t 987 3947 2038
  t 2038 4139 987
  t 208 4140 2039
  t 2039 4134 208
  t 1041 4141 2039
  t 2039 4140 1041
  t 513 4138 2039
  t 2039 4141 513
  t 1038 4134 2039
  t 2039 4138 1038
  t 209 4142 2040
  t 2040 4144 209
  t 1040 4143 2040
  t 2040 4142 1040
  t 513 4141 2040
  t 2040 4143 513
  t 1041 4144 2040
  t 2040 4141 1041
  t 168 3939 2041
  t 2041 4145 168
  t 987 4139 2041
  t 2041 3939 987
  t 513 4143 2041
  t 2041 4139 513
  t 1040 4145 2041
  t 2041 4143 1040
  t 168 4145 2042
  t 2042 3884 168
  t 1040 4146 2042
  t 2042 4145 1040
  t 514 4147 2042
  t 2042 4146 514
  t 969 3884 2042
  t 2042 4147 969
  t 209 4148 2043
  t 2043 4142 209
  t 1042 4149 2043
  t 2043 4148 1042
  t 514 4146 2043
  t 2043 4149 514
  t 1040 4142 2043
  t 2043 4146 1040
  t 207 4125 2044
  t 2044 4151 207
  t 1037 4150 2044
  t 2044 4125 1037
  t 514 4149 2044
  t 2044 4150 514
  t 1042 4151 2044
  t 2044 4149 1042
  t 166 3887 2045
  t 2045 4120 166
  t 969 4147 2045
  t 2045 3887 969
  t 514 4150 2045
  t 2045 4147 514
  t 1037 4120 2045
  t 2045 4150 1037
  t 207 4152 2046
  t 2046 4123 207
  t 1045 4153 2046
  t 2046 4152 1045
  t 515 4154 2046
  t 2046 4153 515
  t 1036 4123 2046
  t 2046 4154 1036
  t 211 4155 2047
  t 2047 4157 211
  t 1044 4156 2047
  t 2047 4155 1044
  t 515 4153 2047
  t 2047 4156 515
  t 1045 4157 2047
  t 2047 4153 1045
  t 210 4158 2048
  t 2048 4160 210
  t 1043 4159 2048
  t 2048 4158 1043
  t 515 4156 2048
  t 2048 4159 515
  t 1044 4160 2048
  t 2048 4156 1044
  t 206 4128 2049
  t 2049 4161 206
  t 1036 4154 2049
  t 2049 4128 1036
  t 515 4159 2049
  t 2049 4154 515
  t 1043 4161 2049
  t 2049 4159 1043
  t 206 4161 2050
  t 2050 4132 206
  t 1043 4162 2050
  t 2050 4161 1043
  t 516 4163 2050
  t 2050 4162 516
  t 1039 4132 2050
  t 2050 4163 1039
  t 210 4164 2051
  t 2051 4158 210
  t 1047 4165 2051
  t 2051 4164 1047
  t 516 4162 2051
  t 2051 4165 516
  t 1043 4158 2051
  t 2051 4162 1043
  t 212 4166 2052
  t 2052 4168 212
  t 1046 4167 2052
  t 2052 4166 1046
  t 516 4165 2052
  t 2052 4167 516
  t 1047 4168 2052
  t 2052 4165 1047
  t 208 4136 2053
  t 2053 4169 208
  t 1039 4163 2053
  t 2053 4136 1039
  t 516 4167 2053
  t 2053 4163 516
  t 1046 4169 2053
  t 2053 4167 1046
  t 208 4169 2054
  t 2054 4140 208
  t 1046 4170 2054
  t 2054 4169 1046
  t 517 4171 2054
  t 2054 4170 517
  t 1041 4140 2054
  t 2054 4171 1041
  t 212 4172 2055
  t 2055 4166 212
  t 1049 4173 2055
  t 2055 4172 1049
  t 517 4170 2055
  t 2055 4173 517
  t 1046 4166 2055
  t 2055 4170 1046
  t 213 4174 2056
  t 2056 4176 213
  t 1048 4175 2056
  t 2056 4174 1048
  t 517 4173 2056
  t 2056 4175 517
  t 1049 4176 2056
  t 2056 4173 1049
  t 209 4144 2057
  t 2057 4177 209
  t 1041 4171 2057
  t 2057 4144 1041
  t 517 4175 2057
  t 2057 4171 517
  t 1048 4177 2057
  t 2057 4175 1048
  t 209 4177 2058
  t 2058 4148 209
  t 1048 4178 2058
  t 2058 4177 1048
  t 518 4179 2058
  t 2058 4178 518
  t 1042 4148 2058
  t 2058 4179 1042
  t 213 4180 2059
  t 2059 4174 213
  t 1050 4181 2059
  t 2059 4180 1050
  t 518 4178 2059
  t 2059 4181 518
  t 1048 4174 2059
  t 2059 4178 1048
  t 211 4157 2060
  t 2060 4183 211
  t 1045 4182 2060
  t 2060 4157 1045
  t 518 4181 2060
  t 2060 4182 518
  t 1050 4183 2060
  t 2060 4181 1050
  t 207 4151 2061
  t 2061 4152 207
  t 1042 4179 2061
  t 2061 4151 1042
  t 518 4182 2061
  t 2061 4179 518
  t 1045 4152 2061
  t 2061 4182 1045
  t 211 4184 2062
  t 2062 4155 211
  t 1053 4185 2062
  t 2062 4184 1053
  t 519 4186 2062
  t 2062 4185 519
  t 1044 4155 2062
  t 2062 4186 1044
  t 215 4187 2063
  t 2063 4189 215
  t 1052 4188 2063
  t 2063 4187 1052
  t 519 4185 2063
  t 2063 4188 519
  t 1053 4189 2063
  t 2063 4185 1053
  t 214 4190 2064
  t 2064 4192 214
  t 1051 4191 2064
  t 2064 4190 1051
  t 519 4188 2064
  t 2064 4191 519
  t 1052 4192 2064
  t 2064 4188 1052
  t 210 4160 2065
  t 2065 4193 210
  t 1044 4186 2065
  t 2065 4160 1044
  t 519 4191 2065
  t 2065 4186 519
  t 1051 4193 2065
  t 2065 4191 1051
  t 210 4193 2066
  t 2066 4164 210
  t 1051 4194 2066
  t 2066 4193 1051
  t 520 4195 2066
  t 2066 4194 520
  t 1047 4164 2066
  t 2066 4195 1047
  t 214 4196 2067
  t 2067 4190 214
  t 1055 4197 2067
  t 2067 4196 1055
  t 520 4194 2067
  t 2067 4197 520
  t 1051 4190 2067
  t 2067 4194 1051
  t 216 4198 2068
  t 2068 4200 216
  t 1054 4199 2068
  t 2068 4198 1054
  t 520 4197 2068
  t 2068 4199 520
  t 1055 4200 2068
  t 2068 4197 1055
  t 212 4168 2069
  t 2069 4201 212
  t 1047 4195 2069
  t 2069 4168 1047
  t 520 4199 2069
  t 2069 4195 520
  t 1054 4201 2069
  t 2069 4199 1054
  t 212 4201 2070
  t 2070 4172 212
  t 1054 4202 2070
  t 2070 4201 1054
  t 521 4203 2070
  t 2070 4202 521
  t 1049 4172 2070
  t 2070 4203 1049
  t 216 4204 2071
  t 2071 4198 216
  t 1057 4205 2071
  t 2071 4204 1057
  t 521 4202 2071
  t 2071 4205 521
  t 1054 4198 2071
  t 2071 4202 1054
  t 217 4206 2072
  t 2072 4208 217
  t 1056 4207 2072
  t 2072 4206 1056
  t 521 4205 2072
  t 2072 4207 521
  t 1057 4208 2072
  t 2072 4205 1057
  t 213 4176 2073
  t 2073 4209 213
  t 1049 4203 2073
  t 2073 4176 1049
  t 521 4207 2073
  t 2073 4203 521
  t 1056 4209 2073
  t 2073 4207 1056
  t 213 4209 2074
  t 2074 4180 213
  t 1056 4210 2074
  t 2074 4209 1056
  t 522 4211 2074
  t 2074 4210 522
  t 1050 4180 2074
  t 2074 4211 1050
  t 217 4212 2075
  t 2075 4206 217
  t 1058 4213 2075
  t 2075 4212 1058
  t 522 4210 2075
  t 2075 4213 522
  t 1056 4206 2075
  t 2075 4210 1056
  t 215 4189 2076
  t 2076 4215 215
  t 1053 4214 2076
  t 2076 4189 1053
  t 522 4213 2076
  t 2076 4214 522
  t 1058 4215 2076
  t 2076 4213 1058
  t 211 4183 2077
  t 2077 4184 211
  t 1050 4211 2077
  t 2077 4183 1050
  t 522 4214 2077
  t 2077 4211 522
  t 1053 4184 2077
  t 2077 4214 1053
  t 215 4216 2078
  t 2078 4187 215
  t 1061 4217 2078
  t 2078 4216 1061
  t 523 4218 2078
  t 2078 4217 523
  t 1052 4187 2078
  t 2078 4218 1052
  t 219 4219 2079
  t 2079 4221 219
  t 1060 4220 2079
  t 2079 4219 1060
  t 523 4217 2079
  t 2079 4220 523
  t 1061 4221 2079
  t 2079 4217 1061
  t 218 4222 2080
  t 2080 4224 218
  t 1059 4223 2080
  t 2080 4222 1059
  t 523 4220 2080
  t 2080 4223 523
  t 1060 4224 2080
  t 2080 4220 1060
  t 214 4192 2081
  t 2081 4225 214
  t 1052 4218 2081
  t 2081 4192 1052
  t 523 4223 2081
  t 2081 4218 523
  t 1059 4225 2081
  t 2081 4223 1059
  t 214 4225 2082
  t 2082 4196 214
  t 1059 4226 2082
  t 2082 4225 1059
  t 524 4227 2082
  t 2082 4226 524
  t 1055 4196 2082
  t 2082 4227 1055
  t 218 4228 2083
  t 2083 4222 218
  t 1063 4229 2083
  t 2083 4228 1063
  t 524 4226 2083
  t 2083 4229 524
  t 1059 4222 2083
  t 2083 4226 1059
  t 220 4230 2084
  t 2084 4232 220
  t 1062 4231 2084
  t 2084 4230 1062
  t 524 4229 2084
  t 2084 4231 524
  t 1063 4232 2084
  t 2084 4229 1063
  t 216 4200 2085
  t 2085 4233 216
  t 1055 4227 2085
  t 2085 4200 1055
  t 524 4231 2085
  t 2085 4227 524
  t 1062 4233 2085
  t 2085 4231 1062
  t 216 4233 2086
  t 2086 4204 216
  t 1062 4234 2086
  t 2086 4233 1062
  t 525 4235 2086
  t 2086 4234 525
  t 1057 4204 2086
  t 2086 4235 1057
  t 220 4236 2087
  t 2087 4230 220
  t 1065 4237 2087
  t 2087 4236 1065
  t 525 4234 2087
  t 2087 4237 525
  t 1062 4230 2087
  t 2087 4234 1062
  t 221 4238 2088
  t 2088 4240 221
  t 1064 4239 2088
  t 2088 4238 1064
  t 525 4237 2088
  t 2088 4239 525
  t 1065 4240 2088
  t 2088 4237 1065
  t 217 4208 2089
  t 2089 4241 217
  t 1057 4235 2089
  t 2089 4208 1057
  t 525 4239 2089
  t 2089 4235 525
  t 1064 4241 2089
  t 2089 4239 1064
  t 217 4241 2090
  t 2090 4212 217
  t 1064 4242 2090
  t 2090 4241 1064
  t 526 4243 2090
  t 2090 4242 526
  t 1058 4212 2090
  t 2090 4243 1058
  t 221 4244 2091
  t 2091 4238 221
  t 1066 4245 2091
  t 2091 4244 1066
  t 526 4242 2091
  t 2091 4245 526
  t 1064 4238 2091
  t 2091 4242 1064
  t 219 4221 2092
  t 2092 4247 219
  t 1061 4246 2092
  t 2092 4221 1061
  t 526 4245 2092
  t 2092 4246 526
  t 1066 4247 2092
  t 2092 4245 1066
  t 215 4215 2093
  t 2093 4216 215
  t 1058 4243 2093
  t 2093 4215 1058
  t 526 4246 2093
  t 2093 4243 526
  t 1061 4216 2093
  t 2093 4246 1061
  t 219 4248 2094
  t 2094 4219 219
  t 1068 4249 2094
  t 2094 4248 1068
  t 527 4250 2094
  t 2094 4249 527
  t 1060 4219 2094
  t 2094 4250 1060
  t 202 4111 2095
  t 2095 4252 202
  t 1031 4251 2095
  t 2095 4111 1031
  t 527 4249 2095
  t 2095 4251 527
  t 1068 4252 2095
  t 2095 4249 1068
  t 203 4253 2096
  t 2096 4118 203
  t 1067 4254 2096
  t 2096 4253 1067
  t 527 4251 2096
  t 2096 4254 527
  t 1031 4118 2096
  t 2096 4251 1031
  t 218 4224 2097
  t 2097 4255 218
  t 1060 4250 2097
  t 2097 4224 1060
  t 527 4254 2097
  t 2097 4250 527
  t 1067 4255 2097
  t 2097 4254 1067
  t 218 4255 2098
  t 2098 4228 218
  t 1067 4256 2098
  t 2098 4255 1067
  t 528 4257 2098
  t 2098 4256 528
  t 1063 4228 2098
  t 2098 4257 1063
  t 203 4119 2099
  t 2099 4253 203
  t 1032 4258 2099
  t 2099 4119 1032
  t 528 4256 2099
  t 2099 4258 528
  t 1067 4253 2099
  t 2099 4256 1067
  t 204 4259 2100
  t 2100 4115 204
  t 1069 4260 2100
  t 2100 4259 1069
  t 528 4258 2100
  t 2100 4260 528
  t 1032 4115 2100
  t 2100 4258 1032
  t 220 4232 2101
  t 2101 4261 220
  t 1063 4257 2101
  t 2101 4232 1063
  t 528 4260 2101
  t 2101 4257 528
  t 1069 4261 2101
  t 2101 4260 1069
  t 220 4261 2102
  t 2102 4236 220
  t 1069 4262 2102
  t 2102 4261 1069
  t 529 4263 2102
  t 2102 4262 529
  t 1065 4236 2102
  t 2102 4263 1065
  t 204 4117 2103
  t 2103 4259 204
  t 1033 4264 2103
  t 2103 4117 1033
  t 529 4262 2103
  t 2103 4264 529
  t 1069 4259 2103
  t 2103 4262 1069
  t 205 4265 2104
  t 2104 4112 205
  t 1070 4266 2104
  t 2104 4265 1070
  t 529 4264 2104
  t 2104 4266 529
  t 1033 4112 2104
  t 2104 4264 1033
  t 221 4240 2105
  t 2105 4267 221
  t 1065 4263 2105
  t 2105 4240 1065
  t 529 4266 2105
  t 2105 4263 529
  t 1070 4267 2105
  t 2105 4266 1070
  t 221 4267 2106
  t 2106 4244 221
  t 1070 4268 2106
  t 2106 4267 1070
  t 530 4269 2106
  t 2106 4268 530
  t 1066 4244 2106
  t 2106 4269 1066
  t 205 4114 2107
  t 2107 4265 205
  t 1034 4270 2107
  t 2107 4114 1034
  t 530 4268 2107
  t 2107 4270 530
  t 1070 4265 2107
  t 2107 4268 1070
  t 202 4252 2108
  t 2108 4108 202
  t 1068 4271 2108
  t 2108 4252 1068
  t 530 4270 2108
  t 2108 4271 530
  t 1034 4108 2108
  t 2108 4270 1034
  t 219 4247 2109
  t 2109 4248 219
  t 1066 4269 2109
  t 2109 4247 1066
  t 530 4271 2109
  t 2109 4269 530
  t 1068 4248 2109
  t 2109 4271 1068
  t 5179 4272 2110
  t 2110 5427 5179
  t 1073 4273 5300
  t 5300 5437 1073
  t 531 4274 5300
  t 5300 4273 531
  t 5245 5427 2110
  t 2110 5439 5245
  t 223 4275 2111
  t 2111 4277 223
  t 1072 4276 2111
  t 2111 4275 1072
  t 5202 5438 2111
  t 2111 4276 5202
  t 5249 4277 2111
  t 2111 5438 5249
  t 222 4278 2112
  t 2112 4280 222
  t 1071 4279 2112
  t 2112 4278 1071
  t 5202 4276 2112
  t 2112 4279 5202
  t 1072 4280 2112
  t 2112 4276 1072
  t 5178 5430 2113
  t 2113 4281 5178
  t 5245 5439 2113
  t 2113 5430 5245
  t 531 5440 5301
  t 5301 4274 531
  t 5248 5441 5301
  t 5301 5440 5248
  t 5178 4281 2114
  t 2114 5421 5178
  t 5248 4282 5302
  t 5302 5441 5248
  t 532 4283 5302
  t 5302 4282 532
  t 5243 5421 2114
  t 2114 5443 5243
  t 222 4284 2115
  t 2115 4278 222
  t 1075 4285 2115
  t 2115 4284 1075
  t 5203 5442 2115
  t 2115 4285 5203
  t 1071 4278 2115
  t 2115 5442 1071
  t 224 4286 2116
  t 2116 4288 224
  t 1074 4287 2116
  t 2116 4286 1074
  t 5203 4285 2116
  t 2116 4287 5203
  t 1075 4288 2116
  t 2116 4285 1075
  t 5177 5424 2117
  t 2117 4289 5177
  t 5243 5443 2117
  t 2117 5424 5243
  t 532 5444 5303
  t 5303 4283 532
  t 5250 5445 5303
  t 5303 5444 5250
  t 5177 4289 2118
  t 2118 5415 5177
  t 5250 4290 5304
  t 5304 5445 5250
  t 533 4291 5304
  t 5304 4290 533
  t 5241 5415 2118
  t 2118 5447 5241
  t 224 4292 2119
  t 2119 4286 224
  t 1078 4293 2119
  t 2119 4292 1078
  t 5204 5446 2119
  t 2119 4293 5204
  t 1074 4286 2119
  t 2119 5446 1074
  t 226 4294 2120
  t 2120 4296 226
  t 1077 4295 2120
  t 2120 4294 1077
  t 5204 4293 2120
  t 2120 4295 5204
  t 1078 4296 2120
  t 2120 4293 1078
  t 225 4297 2121
  t 2121 4299 225
  t 1076 4298 2121
  t 2121 4297 1076
  t 5204 4295 2121
  t 2121 4298 5204
  t 1077 4299 2121
  t 2121 4295 1077
  t 5176 5418 2122
  t 2122 4300 5176
  t 5241 5447 2122
  t 2122 5418 5241
  t 533 5448 5305
  t 5305 4291 533
  t 5251 5449 5305
  t 5305 5448 5251
  t 5176 4300 2123
  t 2123 5409 5176
  t 5251 4301 5306
  t 5306 5449 5251
  t 534 4302 5306
  t 5306 4301 534
  t 5239 5409 2123
  t 2123 5451 5239
  t 225 4303 2124
  t 2124 4297 225
  t 1081 4304 2124
  t 2124 4303 1081
  t 5205 5450 2124
  t 2124 4304 5205
  t 1076 4297 2124
  t 2124 5450 1076
  t 228 4305 2125
  t 2125 4307 228
  t 1080 4306 2125
  t 2125 4305 1080
  t 5205 4304 2125
  t 2125 4306 5205
  t 1081 4307 2125
  t 2125 4304 1081
  t 227 4308 2126
  t 2126 4310 227
  t 1079 4309 2126
  t 2126 4308 1079
  t 5205 4306 2126
  t 2126 4309 5205
  t 1080 4310 2126
  t 2126 4306 1080
  t 5175 5412 2127
  t 2127 4311 5175
  t 5239 5451 2127
  t 2127 5412 5239
  t 534 5452 5307
  t 5307 4302 534
  t 5252 5453 5307
  t 5307 5452 5252
  t 5175 4311 2128
  t 2128 5402 5175
  t 5252 4312 5308
  t 5308 5453 5252
  t 535 4313 5308
  t 5308 4312 535
  t 5237 5402 2128
  t 2128 5455 5237
  t 227 4314 2129
  t 2129 4308 227
  t 1083 4315 2129
  t 2129 4314 1083
  t 5206 5454 2129
  t 2129 4315 5206
  t 1079 4308 2129
  t 2129 5454 1079
  t 229 4316 2130
  t 2130 4318 229
  t 1082 4317 2130
  t 2130 4316 1082
  t 5206 4315 2130
  t 2130 4317 5206
  t 1083 4318 2130
  t 2130 4315 1083
  t 5174 5406 2131
  t 2131 4319 5174
  t 5237 5455 2131
  t 2131 5406 5237
  t 535 5456 5309
  t 5309 4313 535
  t 5253 5457 5309
  t 5309 5456 5253
  t 5174 4319 2132
  t 2132 4322 5174
  t 5253 4320 5310
  t 5310 5457 5253
  t 536 4321 5310
  t 5310 4320 536
  t 1084 4322 2132
  t 2132 5459 1084
  t 229 4323 2133
  t 2133 4316 229
  t 1085 4324 2133
  t 2133 4323 1085
  t 5207 5458 2133
  t 2133 4324 5207
  t 1082 4316 2133
  t 2133 5458 1082
  t 230 3070 2134
  t 2134 4326 230
  t 5234 4325 2134
  t 2134 3070 5234
  t 5207 4324 2134
  t 2134 4325 5207
  t 1085 4326 2134
  t 2134 4324 1085
  t 152 4327 2135
  t 2135 3065 152
  t 1084 5459 2135
  t 2135 4327 1084
  t 536 5461 5311
  t 5311 4321 536
  t 954 5387 5311
  t 5311 5461 954
  t 223 4328 2136
  t 2136 4275 223
  t 1088 4329 2136
  t 2136 4328 1088
  t 537 4330 2136
  t 2136 4329 537
  t 1072 4275 2136
  t 2136 4330 1072
  t 232 4331 2137
  t 2137 4333 232
  t 1087 4332 2137
  t 2137 4331 1087
  t 537 4329 2137
  t 2137 4332 537
  t 1088 4333 2137
  t 2137 4329 1088
  t 231 4334 2138
  t 2138 4336 231
  t 1086 4335 2138
  t 2138 4334 1086
  t 537 4332 2138
  t 2138 4335 537
  t 1087 4336 2138
  t 2138 4332 1087
  t 222 4280 2139
  t 2139 4337 222
  t 1072 4330 2139
  t 2139 4280 1072
  t 537 4335 2139
  t 2139 4330 537
  t 1086 4337 2139
  t 2139 4335 1086
  t 222 4337 2140
  t 2140 4284 222
  t 1086 4338 2140
  t 2140 4337 1086
  t 538 4339 2140
  t 2140 4338 538
  t 1075 4284 2140
  t 2140 4339 1075
  t 231 4340 2141
  t 2141 4334 231
  t 1090 4341 2141
  t 2141 4340 1090
  t 538 4338 2141
  t 2141 4341 538
  t 1086 4334 2141
  t 2141 4338 1086
  t 233 4342 2142
  t 2142 4344 233
  t 1089 4343 2142
  t 2142 4342 1089
  t 538 4341 2142
  t 2142 4343 538
  t 1090 4344 2142
  t 2142 4341 1090
  t 224 4288 2143
  t 2143 4345 224
  t 1075 4339 2143
  t 2143 4288 1075
  t 538 4343 2143
  t 2143 4339 538
  t 1089 4345 2143
  t 2143 4343 1089
  t 224 4345 2144
  t 2144 4292 224
  t 1089 4346 2144
  t 2144 4345 1089
  t 539 4347 2144
  t 2144 4346 539
  t 1078 4292 2144
  t 2144 4347 1078
  t 233 4348 2145
  t 2145 4342 233
  t 1093 4349 2145
  t 2145 4348 1093
  t 539 4346 2145
  t 2145 4349 539
  t 1089 4342 2145
  t 2145 4346 1089
  t 235 4350 2146
  t 2146 4352 235
  t 1092 4351 2146
  t 2146 4350 1092
  t 539 4349 2146
  t 2146 4351 539
  t 1093 4352 2146
  t 2146 4349 1093
  t 234 4353 2147
  t 2147 4355 234
  t 1091 4354 2147
  t 2147 4353 1091
  t 539 4351 2147
  t 2147 4354 539
  t 1092 4355 2147
  t 2147 4351 1092
  t 226 4296 2148
  t 2148 4356 226
  t 1078 4347 2148
  t 2148 4296 1078
  t 539 4354 2148
  t 2148 4347 539
  t 1091 4356 2148
  t 2148 4354 1091
  t 234 4355 2149
  t 2149 4359 234
  t 1092 4357 2149
  t 2149 4355 1092
  t 540 4358 2149
  t 2149 4357 540
  t 1094 4359 2149
  t 2149 4358 1094
  t 235 4360 2150
  t 2150 4350 235
  t 1096 4361 2150
  t 2150 4360 1096
  t 540 4357 2150
  t 2150 4361 540
  t 1092 4350 2150
  t 2150 4357 1092
  t 236 4362 2151
  t 2151 4364 236
  t 1095 4363 2151
  t 2151 4362 1095
  t 540 4361 2151
  t 2151 4363 540
  t 1096 4364 2151
  t 2151 4361 1096
  t 227 4310 2152
  t 2152 4366 227
  t 1080 4365 2152
  t 2152 4310 1080
  t 540 4363 2152
  t 2152 4365 540
  t 1095 4366 2152
  t 2152 4363 1095
  t 228 4367 2153
  t 2153 4305 228
  t 1094 4358 2153
  t 2153 4367 1094
  t 540 4365 2153
  t 2153 4358 540
  t 1080 4305 2153
  t 2153 4365 1080
  t 227 4366 2154
  t 2154 4314 227
  t 1095 4368 2154
  t 2154 4366 1095
  t 541 4369 2154
  t 2154 4368 541
  t 1083 4314 2154
  t 2154 4369 1083
  t 236 4370 2155
  t 2155 4362 236
  t 1098 4371 2155
  t 2155 4370 1098
  t 541 4368 2155
  t 2155 4371 541
  t 1095 4362 2155
  t 2155 4368 1095
  t 237 4372 2156
  t 2156 4374 237
  t 1097 4373 2156
  t 2156 4372 1097
  t 541 4371 2156
  t 2156 4373 541
  t 1098 4374 2156
  t 2156 4371 1098
  t 229 4318 2157
  t 2157 4375 229
  t 1083 4369 2157
  t 2157 4318 1083
  t 541 4373 2157
  t 2157 4369 541
  t 1097 4375 2157
  t 2157 4373 1097
  t 229 4375 2158
  t 2158 4323 229
  t 1097 4376 2158
  t 2158 4375 1097
  t 542 4377 2158
  t 2158 4376 542
  t 1085 4323 2158
  t 2158 4377 1085
  t 237 4378 2159
  t 2159 4372 237
  t 1100 4379 2159
  t 2159 4378 1100
  t 542 4376 2159
  t 2159 4379 542
  t 1097 4372 2159
  t 2159 4376 1097
  t 238 3126 2160
  t 2160 4381 238
  t 1099 4380 2160
  t 2160 3126 1099
  t 542 4379 2160
  t 2160 4380 542
  t 1100 4381 2160
  t 2160 4379 1100
  t 230 4326 2161
  t 2161 3122 230
  t 1085 4377 2161
  t 2161 4326 1085
  t 542 4380 2161
  t 2161 4377 542
  t 1099 3122 2161
  t 2161 4380 1099
  t 232 4382 2162
  t 2162 4331 232
  t 1103 4383 2162
  t 2162 4382 1103
  t 543 4384 2162
  t 2162 4383 543
  t 1087 4331 2162
  t 2162 4384 1087
  t 240 4385 2163
  t 2163 4387 240
  t 1102 4386 2163
  t 2163 4385 1102
  t 543 4383 2163
  t 2163 4386 543
  t 1103 4387 2163
  t 2163 4383 1103
  t 239 4388 2164
  t 2164 4390 239
  t 1101 4389 2164
  t 2164 4388 1101
  t 543 4386 2164
  t 2164 4389 543
  t 1102 4390 2164
  t 2164 4386 1102
  t 231 4336 2165
  t 2165 4391 231
  t 1087 4384 2165
  t 2165 4336 1087
  t 543 4389 2165
  t 2165 4384 543
  t 1101 4391 2165
  t 2165 4389 1101
  t 231 4391 2166
  t 2166 4340 231
  t 1101 4392 2166
  t 2166 4391 1101
  t 544 4393 2166
  t 2166 4392 544
  t 1090 4340 2166
  t 2166 4393 1090
  t 239 4394 2167
  t 2167 4388 239
  t 1105 4395 2167
  t 2167 4394 1105
  t 544 4392 2167
  t 2167 4395 544
  t 1101 4388 2167
  t 2167 4392 1101
  t 241 4396 2168
  t 2168 4398 241
  t 1104 4397 2168
  t 2168 4396 1104
  t 544 4395 2168
  t 2168 4397 544
  t 1105 4398 2168
  t 2168 4395 1105
  t 233 4344 2169
  t 2169 4399 233
  t 1090 4393 2169
  t 2169 4344 1090
  t 544 4397 2169
  t 2169 4393 544
  t 1104 4399 2169
  t 2169 4397 1104
  t 233 4399 2170
  t 2170 4348 233
  t 1104 4400 2170
  t 2170 4399 1104
  t 545 4401 2170
  t 2170 4400 545
  t 1093 4348 2170
  t 2170 4401 1093
  t 241 4402 2171
  t 2171 4396 241
  t 1107 4403 2171
  t 2171 4402 1107
  t 545 4400 2171
  t 2171 4403 545
  t 1104 4396 2171
  t 2171 4400 1104
  t 242 4404 2172
  t 2172 4406 242
  t 1106 4405 2172
  t 2172 4404 1106
  t 545 4403 2172
  t 2172 4405 545
  t 1107 4406 2172
  t 2172 4403 1107
  t 235 4352 2173
  t 2173 4407 235
  t 1093 4401 2173
  t 2173 4352 1093
  t 545 4405 2173
  t 2173 4401 545
  t 1106 4407 2173
  t 2173 4405 1106
  t 235 4407 2174
  t 2174 4360 235
  t 1106 4408 2174
  t 2174 4407 1106
  t 546 4409 2174
  t 2174 4408 546
  t 1096 4360 2174
  t 2174 4409 1096
  t 242 4410 2175
  t 2175 4404 242
  t 1109 4411 2175
  t 2175 4410 1109
  t 546 4408 2175
  t 2175 4411 546
  t 1106 4404 2175
  t 2175 4408 1106
  t 243 4412 2176
  t 2176 4414 243
  t 1108 4413 2176
  t 2176 4412 1108
  t 546 4411 2176
  t 2176 4413 546
  t 1109 4414 2176
  t 2176 4411 1109
  t 236 4364 2177
  t 2177 4415 236
  t 1096 4409 2177
  t 2177 4364 1096
  t 546 4413 2177
  t 2177 4409 546
  t 1108 4415 2177
  t 2177 4413 1108
  t 236 4415 2178
  t 2178 4370 236
  t 1108 4416 2178
  t 2178 4415 1108
  t 547 4417 2178
  t 2178 4416 547
  t 1098 4370 2178
  t 2178 4417 1098
  t 243 4418 2179
  t 2179 4412 243
  t 1111 4419 2179
  t 2179 4418 1111
  t 547 4416 2179
  t 2179 4419 547
  t 1108 4412 2179
  t 2179 4416 1108
  t 244 4420 2180
  t 2180 4422 244
  t 1110 4421 2180
  t 2180 4420 1110
  t 547 4419 2180
  t 2180 4421 547
  t 1111 4422 2180
  t 2180 4419 1111
  t 237 4374 2181
  t 2181 4423 237
  t 1098 4417 2181
  t 2181 4374 1098
  t 547 4421 2181
  t 2181 4417 547
  t 1110 4423 2181
  t 2181 4421 1110
  t 237 4423 2182
  t 2182 4378 237
  t 1110 4424 2182
  t 2182 4423 1110
  t 548 4425 2182
  t 2182 4424 548
  t 1100 4378 2182
  t 2182 4425 1100
  t 244 4426 2183
  t 2183 4420 244
  t 1113 4427 2183
  t 2183 4426 1113
  t 548 4424 2183
  t 2183 4427 548
  t 1110 4420 2183
  t 2183 4424 1110
  t 157 3176 2184
  t 2184 4429 157
  t 1112 4428 2184
  t 2184 3176 1112
  t 548 4427 2184
  t 2184 4428 548
  t 1113 4429 2184
  t 2184 4427 1113
  t 238 4381 2185
  t 2185 3172 238
  t 1100 4425 2185
  t 2185 4381 1100
  t 548 4428 2185
  t 2185 4425 548
  t 1112 3172 2185
  t 2185 4428 1112
  t 240 4430 2186
  t 2186 4385 240
  t 1116 4431 2186
  t 2186 4430 1116
  t 549 4432 2186
  t 2186 4431 549
  t 1102 4385 2186
  t 2186 4432 1102
  t 246 4433 2187
  t 2187 4435 246
  t 1115 4434 2187
  t 2187 4433 1115
  t 549 4431 2187
  t 2187 4434 549
  t 1116 4435 2187
  t 2187 4431 1116
  t 245 4436 2188
  t 2188 4438 245
  t 1114 4437 2188
  t 2188 4436 1114
  t 549 4434 2188
  t 2188 4437 549
  t 1115 4438 2188
  t 2188 4434 1115
  t 239 4390 2189
  t 2189 4439 239
  t 1102 4432 2189
  t 2189 4390 1102
  t 549 4437 2189
  t 2189 4432 549
  t 1114 4439 2189
  t 2189 4437 1114
  t 239 4439 2190
  t 2190 4394 239
  t 1114 4440 2190
  t 2190 4439 1114
  t 550 4441 2190
  t 2190 4440 550
  t 1105 4394 2190
  t 2190 4441 1105
  t 245 4442 2191
  t 2191 4436 245
  t 1118 4443 2191
  t 2191 4442 1118
  t 550 4440 2191
  t 2191 4443 550
  t 1114 4436 2191
  t 2191 4440 1114
  t 247 4444 2192
  t 2192 4446 247
  t 1117 4445 2192
  t 2192 4444 1117
  t 550 4443 2192
  t 2192 4445 550
  t 1118 4446 2192
  t 2192 4443 1118
  t 241 4398 2193
  t 2193 4447 241
  t 1105 4441 2193
  t 2193 4398 1105
  t 550 4445 2193
  t 2193 4441 550
  t 1117 4447 2193
  t 2193 4445 1117
  t 241 4447 2194
  t 2194 4402 241
  t 1117 4448 2194
  t 2194 4447 1117
  t 551 4449 2194
  t 2194 4448 551
  t 1107 4402 2194
  t 2194 4449 1107
  t 247 4450 2195
  t 2195 4444 247
  t 1120 4451 2195
  t 2195 4450 1120
  t 551 4448 2195
  t 2195 4451 551
  t 1117 4444 2195
  t 2195 4448 1117
  t 248 4452 2196
  t 2196 4454 248
  t 1119 4453 2196
  t 2196 4452 1119
  t 551 4451 2196
  t 2196 4453 551
  t 1120 4454 2196
  t 2196 4451 1120
  t 242 4406 2197
  t 2197 4455 242
  t 1107 4449 2197
  t 2197 4406 1107
  t 551 4453 2197
  t 2197 4449 551
  t 1119 4455 2197
  t 2197 4453 1119
  t 242 4455 2198
  t 2198 4410 242
  t 1119 4456 2198
  t 2198 4455 1119
  t 552 4457 2198
  t 2198 4456 552
  t 1109 4410 2198
  t 2198 4457 1109
  t 248 4458 2199
  t 2199 4452 248
  t 1122 4459 2199
  t 2199 4458 1122
  t 552 4456 2199
  t 2199 4459 552
  t 1119 4452 2199
  t 2199 4456 1119
  t 249 4460 2200
  t 2200 4462 249
  t 1121 4461 2200
  t 2200 4460 1121
  t 552 4459 2200
  t 2200 4461 552
  t 1122 4462 2200
  t 2200 4459 1122
  t 243 4414 2201
  t 2201 4463 243
  t 1109 4457 2201
  t 2201 4414 1109
  t 552 4461 2201
  t 2201 4457 552
  t 1121 4463 2201
  t 2201 4461 1121
  t 243 4463 2202
  t 2202 4418 243
  t 1121 4464 2202
  t 2202 4463 1121
  t 553 4465 2202
  t 2202 4464 553
  t 1111 4418 2202
  t 2202 4465 1111
  t 249 4466 2203
  t 2203 4460 249
  t 1124 4467 2203
  t 2203 4466 1124
  t 553 4464 2203
  t 2203 4467 553
  t 1121 4460 2203
  t 2203 4464 1121
  t 250 4468 2204
  t 2204 4470 250
  t 1123 4469 2204
  t 2204 4468 1123
  t 553 4467 2204
  t 2204 4469 553
  t 1124 4470 2204
  t 2204 4467 1124
  t 244 4422 2205
  t 2205 4471 244
  t 1111 4465 2205
  t 2205 4422 1111
  t 553 4469 2205
  t 2205 4465 553
  t 1123 4471 2205
  t 2205 4469 1123
  t 244 4471 2206
  t 2206 4426 244
  t 1123 4472 2206
  t 2206 4471 1123
  t 554 4473 2206
  t 2206 4472 554
  t 1113 4426 2206
  t 2206 4473 1113
  t 250 4474 2207
  t 2207 4468 250
  t 1125 4475 2207
  t 2207 4474 1125
  t 554 4472 2207
  t 2207 4475 554
  t 1123 4468 2207
  t 2207 4472 1123
  t 251 3226 2208
  t 2208 4477 251
  t 958 4476 2208
  t 2208 3226 958
  t 554 4475 2208
  t 2208 4476 554
  t 1125 4477 2208
  t 2208 4475 1125
  t 157 4429 2209
  t 2209 3222 157
  t 1113 4473 2209
  t 2209 4429 1113
  t 554 4476 2209
  t 2209 4473 554
  t 958 3222 2209
  t 2209 4476 958
  t 246 4478 2210
  t 2210 4433 246
  t 1128 4479 2210
  t 2210 4478 1128
  t 555 4480 2210
  t 2210 4479 555
  t 1115 4433 2210
  t 2210 4480 1115
  t 253 4481 2211
  t 2211 4483 253
  t 1127 4482 2211
  t 2211 4481 1127
  t 555 4479 2211
  t 2211 4482 555
  t 1128 4483 2211
  t 2211 4479 1128
  t 252 4484 2212
  t 2212 4486 252
  t 1126 4485 2212
  t 2212 4484 1126
  t 555 4482 2212
  t 2212 4485 555
  t 1127 4486 2212
  t 2212 4482 1127
  t 245 4438 2213
  t 2213 4487 245
  t 1115 4480 2213
  t 2213 4438 1115
  t 555 4485 2213
  t 2213 4480 555
  t 1126 4487 2213
  t 2213 4485 1126
  t 245 4487 2214
  t 2214 4442 245
  t 1126 4488 2214
  t 2214 4487 1126
  t 556 4489 2214
  t 2214 4488 556
  t 1118 4442 2214
  t 2214 4489 1118
  t 252 4490 2215
  t 2215 4484 252
  t 1130 4491 2215
  t 2215 4490 1130
  t 556 4488 2215
  t 2215 4491 556
  t 1126 4484 2215
  t 2215 4488 1126
  t 254 4492 2216
  t 2216 4494 254
  t 1129 4493 2216
  t 2216 4492 1129
  t 556 4491 2216
  t 2216 4493 556
  t 1130 4494 2216
  t 2216 4491 1130
  t 247 4446 2217
  t 2217 4495 247
  t 1118 4489 2217
  t 2217 4446 1118
  t 556 4493 2217
  t 2217 4489 556
  t 1129 4495 2217
  t 2217 4493 1129
  t 247 4495 2218
  t 2218 4450 247
  t 1129 4496 2218
  t 2218 4495 1129
  t 557 4497 2218
  t 2218 4496 557
  t 1120 4450 2218
  t 2218 4497 1120
  t 254 4498 2219
  t 2219 4492 254
  t 1133 4499 2219
  t 2219 4498 1133
  t 557 4496 2219
  t 2219 4499 557
  t 1129 4492 2219
  t 2219 4496 1129
  t 256 4500 2220
  t 2220 4502 256
  t 1132 4501 2220
  t 2220 4500 1132
  t 557 4499 2220
  t 2220 4501 557
  t 1133 4502 2220
  t 2220 4499 1133
  t 255 4503 2221
  t 2221 4505 255
  t 1131 4504 2221
  t 2221 4503 1131
  t 557 4501 2221
  t 2221 4504 557
  t 1132 4505 2221
  t 2221 4501 1132
  t 248 4454 2222
  t 2222 4506 248
  t 1120 4497 2222
  t 2222 4454 1120
  t 557 4504 2222
  t 2222 4497 557
  t 1131 4506 2222
  t 2222 4504 1131
  t 248 4506 2223
  t 2223 4458 248
  t 1131 4507 2223
  t 2223 4506 1131
  t 558 4508 2223
  t 2223 4507 558
  t 1122 4458 2223
  t 2223 4508 1122
  t 255 4509 2224
  t 2224 4503 255
  t 1136 4510 2224
  t 2224 4509 1136
  t 558 4507 2224
  t 2224 4510 558
  t 1131 4503 2224
  t 2224 4507 1131
  t 258 4511 2225
  t 2225 4513 258
  t 1135 4512 2225
  t 2225 4511 1135
  t 558 4510 2225
  t 2225 4512 558
  t 1136 4513 2225
  t 2225 4510 1136
  t 257 4514 2226
  t 2226 4516 257
  t 1134 4515 2226
  t 2226 4514 1134
  t 558 4512 2226
  t 2226 4515 558
  t 1135 4516 2226
  t 2226 4512 1135
  t 249 4462 2227
  t 2227 4517 249
  t 1122 4508 2227
  t 2227 4462 1122
  t 558 4515 2227
  t 2227 4508 558
  t 1134 4517 2227
  t 2227 4515 1134
  t 249 4517 2228
  t 2228 4466 249
  t 1134 4518 2228
  t 2228 4517 1134
  t 559 4519 2228
  t 2228 4518 559
  t 1124 4466 2228
  t 2228 4519 1124
  t 257 4520 2229
  t 2229 4514 257
  t 1138 4521 2229
  t 2229 4520 1138
  t 559 4518 2229
  t 2229 4521 559
  t 1134 4514 2229
  t 2229 4518 1134
  t 259 4522 2230
  t 2230 4524 259
  t 1137 4523 2230
  t 2230 4522 1137
  t 559 4521 2230
  t 2230 4523 559
  t 1138 4524 2230
  t 2230 4521 1138
  t 250 4470 2231
  t 2231 4525 250
  t 1124 4519 2231
  t 2231 4470 1124
  t 559 4523 2231
  t 2231 4519 559
  t 1137 4525 2231
  t 2231 4523 1137
  t 250 4525 2232
  t 2232 4474 250
  t 1137 4526 2232
  t 2232 4525 1137
  t 560 4527 2232
  t 2232 4526 560
  t 1125 4474 2232
  t 2232 4527 1125
  t 259 4528 2233
  t 2233 4522 259
  t 1140 4529 2233
  t 2233 4528 1140
  t 560 4526 2233
  t 2233 4529 560
  t 1137 4522 2233
  t 2233 4526 1137
  t 260 3282 2234
  t 2234 4531 260
  t 1139 4530 2234
  t 2234 3282 1139
  t 560 4529 2234
  t 2234 4530 560
  t 1140 4531 2234
  t 2234 4529 1140
  t 251 4477 2235
  t 2235 3278 251
  t 1125 4527 2235
  t 2235 4477 1125
  t 560 4530 2235
  t 2235 4527 560
  t 1139 3278 2235
  t 2235 4530 1139
  t 253 4532 2236
  t 2236 4481 253
  t 1144 4533 2236
  t 2236 4532 1144
  t 561 4534 2236
  t 2236 4533 561
  t 1127 4481 2236
  t 2236 4534 1127
  t 263 3296 2237
  t 2237 4536 263
  t 1143 4535 2237
  t 2237 3296 1143
  t 561 4533 2237
  t 2237 4535 561
  t 1144 4536 2237
  t 2237 4533 1144
  t 262 4537 2238
  t 2238 3292 262
  t 1142 4538 2238
  t 2238 4537 1142
  t 561 4535 2238
  t 2238 4538 561
  t 1143 3292 2238
  t 2238 4535 1143
  t 261 4539 2239
  t 2239 4541 261
  t 1141 4540 2239
  t 2239 4539 1141
  t 561 4538 2239
  t 2239 4540 561
  t 1142 4541 2239
  t 2239 4538 1142
  t 252 4486 2240
  t 2240 4542 252
  t 1127 4534 2240
  t 2240 4486 1127
  t 561 4540 2240
  t 2240 4534 561
  t 1141 4542 2240
  t 2240 4540 1141
  t 252 4542 2241
  t 2241 4490 252
  t 1141 4543 2241
  t 2241 4542 1141
  t 562 4544 2241
  t 2241 4543 562
  t 1130 4490 2241
  t 2241 4544 1130
  t 261 4545 2242
  t 2242 4539 261
  t 1146 4546 2242
  t 2242 4545 1146
  t 562 4543 2242
  t 2242 4546 562
  t 1141 4539 2242
  t 2242 4543 1141
  t 264 4547 2243
  t 2243 4549 264
  t 1145 4548 2243
  t 2243 4547 1145
  t 562 4546 2243
  t 2243 4548 562
  t 1146 4549 2243
  t 2243 4546 1146
  t 254 4494 2244
  t 2244 4550 254
  t 1130 4544 2244
  t 2244 4494 1130
  t 562 4548 2244
  t 2244 4544 562
  t 1145 4550 2244
  t 2244 4548 1145
  t 254 4550 2245
  t 2245 4498 254
  t 1145 4551 2245
  t 2245 4550 1145
  t 563 4552 2245
  t 2245 4551 563
  t 1133 4498 2245
  t 2245 4552 1133
  t 264 4553 2246
  t 2246 4547 264
  t 1149 4554 2246
  t 2246 4553 1149
  t 563 4551 2246
  t 2246 4554 563
  t 1145 4547 2246
  t 2246 4551 1145
  t 266 4555 2247
  t 2247 4557 266
  t 1148 4556 2247
  t 2247 4555 1148
  t 563 4554 2247
  t 2247 4556 563
  t 1149 4557 2247
  t 2247 4554 1149
  t 265 4558 2248
  t 2248 4560 265
  t 1147 4559 2248
  t 2248 4558 1147
  t 563 4556 2248
  t 2248 4559 563
  t 1148 4560 2248
  t 2248 4556 1148
  t 256 4502 2249
  t 2249 4561 256
  t 1133 4552 2249
  t 2249 4502 1133
  t 563 4559 2249
  t 2249 4552 563
  t 1147 4561 2249
  t 2249 4559 1147
  t 265 4560 2250
  t 2250 4564 265
  t 1148 4562 2250
  t 2250 4560 1148
  t 564 4563 2250
  t 2250 4562 564
  t 1150 4564 2250
  t 2250 4563 1150
  t 266 4565 2251
  t 2251 4555 266
  t 1152 4566 2251
  t 2251 4565 1152
  t 564 4562 2251
  t 2251 4566 564
  t 1148 4555 2251
  t 2251 4562 1148
  t 267 4567 2252
  t 2252 4569 267
  t 1151 4568 2252
  t 2252 4567 1151
  t 564 4566 2252
  t 2252 4568 564
  t 1152 4569 2252
  t 2252 4566 1152
  t 257 4516 2253
  t 2253 4571 257
  t 1135 4570 2253
  t 2253 4516 1135
  t 564 4568 2253
  t 2253 4570 564
  t 1151 4571 2253
  t 2253 4568 1151
  t 258 4572 2254
  t 2254 4511 258
  t 1150 4563 2254
  t 2254 4572 1150
  t 564 4570 2254
  t 2254 4563 564
  t 1135 4511 2254
  t 2254 4570 1135
  t 257 4571 2255
  t 2255 4520 257
  t 1151 4573 2255
  t 2255 4571 1151
  t 565 4574 2255
  t 2255 4573 565
  t 1138 4520 2255
  t 2255 4574 1138
  t 267 4575 2256
  t 2256 4567 267
  t 1155 4576 2256
  t 2256 4575 1155
  t 565 4573 2256
  t 2256 4576 565
  t 1151 4567 2256
  t 2256 4573 1151
  t 268 3336 2257
  t 2257 4578 268
  t 1154 4577 2257
  t 2257 3336 1154
  t 565 4576 2257
  t 2257 4577 565
  t 1155 4578 2257
  t 2257 4576 1155
  t 159 4579 2258
  t 2258 3331 159
  t 1153 4580 2258
  t 2258 4579 1153
  t 565 4577 2258
  t 2258 4580 565
  t 1154 3331 2258
  t 2258 4577 1154
  t 259 4524 2259
  t 2259 4581 259
  t 1138 4574 2259
  t 2259 4524 1138
  t 565 4580 2259
  t 2259 4574 565
  t 1153 4581 2259
  t 2259 4580 1153
  t 259 4581 2260
  t 2260 4528 259
  t 1153 4582 2260
  t 2260 4581 1153
  t 566 4583 2260
  t 2260 4582 566
  t 1140 4528 2260
  t 2260 4583 1140
  t 159 3342 2261
  t 2261 4579 159
  t 960 4584 2261
  t 2261 3342 960
  t 566 4582 2261
  t 2261 4584 566
  t 1153 4579 2261
  t 2261 4582 1153
  t 260 4531 2262
  t 2262 3340 260
  t 1140 4583 2262
  t 2262 4531 1140
  t 566 4584 2262
  t 2262 4583 566
  t 960 3340 2262
  t 2262 4584 960
  t 269 4585 2263
  t 2263 4588 269
  t 1159 4586 2263
  t 2263 4585 1159
  t 567 4587 2263
  t 2263 4586 567
  t 1156 4588 2263
  t 2263 4587 1156
  t 272 4589 2264
  t 2264 4591 272
  t 1158 4590 2264
  t 2264 4589 1158
  t 567 4586 2264
  t 2264 4590 567
  t 1159 4591 2264
  t 2264 4586 1159
  t 271 4592 2265
  t 2265 4594 271
  t 1157 4593 2265
  t 2265 4592 1157
  t 567 4590 2265
  t 2265 4593 567
  t 1158 4594 2265
  t 2265 4590 1158
  t 270 4595 2266
  t 2266 4596 270
  t 1156 4587 2266
  t 2266 4595 1156
  t 567 4593 2266
  t 2266 4587 567
  t 1157 4596 2266
  t 2266 4593 1157
  t 225 4597 2267
  t 2267 4303 225
  t 1162 4598 2267
  t 2267 4597 1162
  t 568 4599 2267
  t 2267 4598 568
  t 1081 4303 2267
  t 2267 4599 1081
  t 274 4600 2268
  t 2268 4602 274
  t 1161 4601 2268
  t 2268 4600 1161
  t 568 4598 2268
  t 2268 4601 568
  t 1162 4602 2268
  t 2268 4598 1162
  t 273 4603 2269
  t 2269 4605 273
  t 1160 4604 2269
  t 2269 4603 1160
  t 568 4601 2269
  t 2269 4604 568
  t 1161 4605 2269
  t 2269 4601 1161
  t 228 4307 2270
  t 2270 4606 228
  t 1081 4599 2270
  t 2270 4307 1081
  t 568 4604 2270
  t 2270 4599 568
  t 1160 4606 2270
  t 2270 4604 1160
  t 228 4606 2271
  t 2271 4367 228
  t 1160 4607 2271
  t 2271 4606 1160
  t 569 4608 2271
  t 2271 4607 569
  t 1094 4367 2271
  t 2271 4608 1094
  t 273 4609 2272
  t 2272 4603 273
  t 1164 4610 2272
  t 2272 4609 1164
  t 569 4607 2272
  t 2272 4610 569
  t 1160 4603 2272
  t 2272 4607 1160
  t 275 4611 2273
  t 2273 4613 275
  t 1163 4612 2273
  t 2273 4611 1163
  t 569 4610 2273
  t 2273 4612 569
  t 1164 4613 2273
  t 2273 4610 1164
  t 234 4359 2274
  t 2274 4614 234
  t 1094 4608 2274
  t 2274 4359 1094
  t 569 4612 2274
  t 2274 4608 569
  t 1163 4614 2274
  t 2274 4612 1163
  t 234 4614 2275
  t 2275 4353 234
  t 1163 4615 2275
  t 2275 4614 1163
  t 570 4616 2275
  t 2275 4615 570
  t 1091 4353 2275
  t 2275 4616 1091
  t 275 4617 2276
  t 2276 4611 275
  t 1166 4618 2276
  t 2276 4617 1166
  t 570 4615 2276
  t 2276 4618 570
  t 1163 4611 2276
  t 2276 4615 1163
  t 276 4619 2277
  t 2277 4621 276
  t 1165 4620 2277
  t 2277 4619 1165
  t 570 4618 2277
  t 2277 4620 570
  t 1166 4621 2277
  t 2277 4618 1166
  t 226 4356 2278
  t 2278 4622 226
  t 1091 4616 2278
  t 2278 4356 1091
  t 570 4620 2278
  t 2278 4616 570
  t 1165 4622 2278
  t 2278 4620 1165
  t 226 4622 2279
  t 2279 4294 226
  t 1165 4623 2279
  t 2279 4622 1165
  t 571 4624 2279
  t 2279 4623 571
  t 1077 4294 2279
  t 2279 4624 1077
  t 276 4625 2280
  t 2280 4619 276
  t 1167 4626 2280
  t 2280 4625 1167
  t 571 4623 2280
  t 2280 4626 571
  t 1165 4619 2280
  t 2280 4623 1165
  t 274 4602 2281
  t 2281 4628 274
  t 1162 4627 2281
  t 2281 4602 1162
  t 571 4626 2281
  t 2281 4627 571
  t 1167 4628 2281
  t 2281 4626 1167
  t 225 4299 2282
  t 2282 4597 225
  t 1077 4624 2282
  t 2282 4299 1077
  t 571 4627 2282
  t 2282 4624 571
  t 1162 4597 2282
  t 2282 4627 1162
  t 274 4629 2283
  t 2283 4600 274
  t 1170 4630 2283
  t 2283 4629 1170
  t 572 4631 2283
  t 2283 4630 572
  t 1161 4600 2283
  t 2283 4631 1161
  t 278 4632 2284
  t 2284 4634 278
  t 1169 4633 2284
  t 2284 4632 1169
  t 572 4630 2284
  t 2284 4633 572
  t 1170 4634 2284
  t 2284 4630 1170
  t 277 4635 2285
  t 2285 4637 277
  t 1168 4636 2285
  t 2285 4635 1168
  t 572 4633 2285
  t 2285 4636 572
  t 1169 4637 2285
  t 2285 4633 1169
  t 273 4605 2286
  t 2286 4638 273
  t 1161 4631 2286
  t 2286 4605 1161
  t 572 4636 2286
  t 2286 4631 572
  t 1168 4638 2286
  t 2286 4636 1168
  t 273 4638 2287
  t 2287 4609 273
  t 1168 4639 2287
  t 2287 4638 1168
  t 573 4640 2287
  t 2287 4639 573
  t 1164 4609 2287
  t 2287 4640 1164
  t 277 4641 2288
  t 2288 4635 277
  t 1172 4642 2288
  t 2288 4641 1172
  t 573 4639 2288
  t 2288 4642 573
  t 1168 4635 2288
  t 2288 4639 1168
  t 279 4643 2289
  t 2289 4645 279
  t 1171 4644 2289
  t 2289 4643 1171
  t 573 4642 2289
  t 2289 4644 573
  t 1172 4645 2289
  t 2289 4642 1172
  t 275 4613 2290
  t 2290 4646 275
  t 1164 4640 2290
  t 2290 4613 1164
  t 573 4644 2290
  t 2290 4640 573
  t 1171 4646 2290
  t 2290 4644 1171
  t 275 4646 2291
  t 2291 4617 275
  t 1171 4647 2291
  t 2291 4646 1171
  t 574 4648 2291
  t 2291 4647 574
  t 1166 4617 2291
  t 2291 4648 1166
  t 279 4649 2292
  t 2292 4643 279
  t 1174 4650 2292
  t 2292 4649 1174
  t 574 4647 2292
  t 2292 4650 574
  t 1171 4643 2292
  t 2292 4647 1171
  t 280 4651 2293
  t 2293 4653 280
  t 1173 4652 2293
  t 2293 4651 1173
  t 574 4650 2293
  t 2293 4652 574
  t 1174 4653 2293
  t 2293 4650 1174
  t 276 4621 2294
  t 2294 4654 276
  t 1166 4648 2294
  t 2294 4621 1166
  t 574 4652 2294
  t 2294 4648 574
  t 1173 4654 2294
  t 2294 4652 1173
  t 276 4654 2295
  t 2295 4625 276
  t 1173 4655 2295
  t 2295 4654 1173
  t 575 4656 2295
  t 2295 4655 575
  t 1167 4625 2295
  t 2295 4656 1167
  t 280 4657 2296
  t 2296 4651 280
  t 1175 4658 2296
  t 2296 4657 1175
  t 575 4655 2296
  t 2296 4658 575
  t 1173 4651 2296
  t 2296 4655 1173
  t 278 4634 2297
  t 2297 4660 278
  t 1170 4659 2297
  t 2297 4634 1170
  t 575 4658 2297
  t 2297 4659 575
  t 1175 4660 2297
  t 2297 4658 1175
  t 274 4628 2298
  t 2298 4629 274
  t 1167 4656 2298
  t 2298 4628 1167
  t 575 4659 2298
  t 2298 4656 575
  t 1170 4629 2298
  t 2298 4659 1170
  t 278 4661 2299
  t 2299 4632 278
  t 1178 4662 2299
  t 2299 4661 1178
  t 576 4663 2299
  t 2299 4662 576
  t 1169 4632 2299
  t 2299 4663 1169
  t 282 4664 2300
  t 2300 4666 282
  t 1177 4665 2300
  t 2300 4664 1177
  t 576 4662 2300
  t 2300 4665 576
  t 1178 4666 2300
  t 2300 4662 1178
  t 281 4667 2301
  t 2301 4669 281
  t 1176 4668 2301
  t 2301 4667 1176
  t 576 4665 2301
  t 2301 4668 576
  t 1177 4669 2301
  t 2301 4665 1177
  t 277 4637 2302
  t 2302 4670 277
  t 1169 4663 2302
  t 2302 4637 1169
  t 576 4668 2302
  t 2302 4663 576
  t 1176 4670 2302
  t 2302 4668 1176
  t 277 4670 2303
  t 2303 4641 277
  t 1176 4671 2303
  t 2303 4670 1176
  t 577 4672 2303
  t 2303 4671 577
  t 1172 4641 2303
  t 2303 4672 1172
  t 281 4673 2304
  t 2304 4667 281
  t 1180 4674 2304
  t 2304 4673 1180
  t 577 4671 2304
  t 2304 4674 577
  t 1176 4667 2304
  t 2304 4671 1176
  t 283 4675 2305
  t 2305 4677 283
  t 1179 4676 2305
  t 2305 4675 1179
  t 577 4674 2305
  t 2305 4676 577
  t 1180 4677 2305
  t 2305 4674 1180
  t 279 4645 2306
  t 2306 4678 279
  t 1172 4672 2306
  t 2306 4645 1172
  t 577 4676 2306
  t 2306 4672 577
  t 1179 4678 2306
  t 2306 4676 1179
  t 279 4678 2307
  t 2307 4649 279
  t 1179 4679 2307
  t 2307 4678 1179
  t 578 4680 2307
  t 2307 4679 578
  t 1174 4649 2307
  t 2307 4680 1174
  t 283 4681 2308
  t 2308 4675 283
  t 1182 4682 2308
  t 2308 4681 1182
  t 578 4679 2308
  t 2308 4682 578
  t 1179 4675 2308
  t 2308 4679 1179
  t 284 4683 2309
  t 2309 4685 284
  t 1181 4684 2309
  t 2309 4683 1181
  t 578 4682 2309
  t 2309 4684 578
  t 1182 4685 2309
  t 2309 4682 1182
  t 280 4653 2310
  t 2310 4686 280
  t 1174 4680 2310
  t 2310 4653 1174
  t 578 4684 2310
  t 2310 4680 578
  t 1181 4686 2310
  t 2310 4684 1181
  t 280 4686 2311
  t 2311 4657 280
  t 1181 4687 2311
  t 2311 4686 1181
  t 579 4688 2311
  t 2311 4687 579
  t 1175 4657 2311
  t 2311 4688 1175
  t 284 4689 2312
  t 2312 4683 284
  t 1183 4690 2312
  t 2312 4689 1183
  t 579 4687 2312
  t 2312 4690 579
  t 1181 4683 2312
  t 2312 4687 1181
  t 282 4666 2313
  t 2313 4692 282
  t 1178 4691 2313
  t 2313 4666 1178
  t 579 4690 2313
  t 2313 4691 579
  t 1183 4692 2313
  t 2313 4690 1183
  t 278 4660 2314
  t 2314 4661 278
  t 1175 4688 2314
  t 2314 4660 1175
  t 579 4691 2314
  t 2314 4688 579
  t 1178 4661 2314
  t 2314 4691 1178
  t 282 4693 2315
  t 2315 4664 282
  t 1185 4694 2315
  t 2315 4693 1185
  t 580 4695 2315
  t 2315 4694 580
  t 1177 4664 2315
  t 2315 4695 1177
  t 269 4588 2316
  t 2316 4697 269
  t 1156 4696 2316
  t 2316 4588 1156
  t 580 4694 2316
  t 2316 4696 580
  t 1185 4697 2316
  t 2316 4694 1185
  t 270 4698 2317
  t 2317 4595 270
  t 1184 4699 2317
  t 2317 4698 1184
  t 580 4696 2317
  t 2317 4699 580
  t 1156 4595 2317
  t 2317 4696 1156
  t 281 4669 2318
  t 2318 4700 281
  t 1177 4695 2318
  t 2318 4669 1177
  t 580 4699 2318
  t 2318 4695 580
  t 1184 4700 2318
  t 2318 4699 1184
  t 281 4700 2319
  t 2319 4673 281
  t 1184 4701 2319
  t 2319 4700 1184
  t 581 4702 2319
  t 2319 4701 581
  t 1180 4673 2319
  t 2319 4702 1180
  t 270 4596 2320
  t 2320 4698 270
  t 1157 4703 2320
  t 2320 4596 1157
  t 581 4701 2320
  t 2320 4703 581
  t 1184 4698 2320
  t 2320 4701 1184
  t 271 4704 2321
  t 2321 4592 271
  t 1186 4705 2321
  t 2321 4704 1186
  t 581 4703 2321
  t 2321 4705 581
  t 1157 4592 2321
  t 2321 4703 1157
  t 283 4677 2322
  t 2322 4706 283
  t 1180 4702 2322
  t 2322 4677 1180
  t 581 4705 2322
  t 2322 4702 581
  t 1186 4706 2322
  t 2322 4705 1186
  t 283 4706 2323
  t 2323 4681 283
  t 1186 4707 2323
  t 2323 4706 1186
  t 582 4708 2323
  t 2323 4707 582
  t 1182 4681 2323
  t 2323 4708 1182
  t 271 4594 2324
  t 2324 4704 271
  t 1158 4709 2324
  t 2324 4594 1158
  t 582 4707 2324
  t 2324 4709 582
  t 1186 4704 2324
  t 2324 4707 1186
  t 272 4710 2325
  t 2325 4589 272
  t 1187 4711 2325
  t 2325 4710 1187
  t 582 4709 2325
  t 2325 4711 582
  t 1158 4589 2325
  t 2325 4709 1158
  t 284 4685 2326
  t 2326 4712 284
  t 1182 4708 2326
  t 2326 4685 1182
  t 582 4711 2326
  t 2326 4708 582
  t 1187 4712 2326
  t 2326 4711 1187
  t 284 4712 2327
  t 2327 4689 284
  t 1187 4713 2327
  t 2327 4712 1187
  t 583 4714 2327
  t 2327 4713 583
  t 1183 4689 2327
  t 2327 4714 1183
  t 272 4591 2328
  t 2328 4710 272
  t 1159 4715 2328
  t 2328 4591 1159
  t 583 4713 2328
  t 2328 4715 583
  t 1187 4710 2328
  t 2328 4713 1187
  t 269 4697 2329
  t 2329 4585 269
  t 1185 4716 2329
  t 2329 4697 1185
  t 583 4715 2329
  t 2329 4716 583
  t 1159 4585 2329
  t 2329 4715 1159
  t 282 4692 2330
  t 2330 4693 282
  t 1183 4714 2330
  t 2330 4692 1183
  t 583 4716 2330
  t 2330 4714 583
  t 1185 4693 2330
  t 2330 4716 1185
  t 285 4717 2331
  t 2331 4720 285
  t 1191 4718 2331
  t 2331 4717 1191
  t 584 4719 2331
  t 2331 4718 584
  t 1188 4720 2331
  t 2331 4719 1188
  t 288 4721 2332
  t 2332 4723 288
  t 1190 4722 2332
  t 2332 4721 1190
  t 584 4718 2332
  t 2332 4722 584
  t 1191 4723 2332
  t 2332 4718 1191
  t 287 4724 2333
  t 2333 4726 287
  t 1189 4725 2333
  t 2333 4724 1189
  t 584 4722 2333
  t 2333 4725 584
  t 1190 4726 2333
  t 2333 4722 1190
  t 286 4727 2334
  t 2334 4728 286
  t 1188 4719 2334
  t 2334 4727 1188
  t 584 4725 2334
  t 2334 4719 584
  t 1189 4728 2334
  t 2334 4725 1189
  t 255 4729 2335
  t 2335 4509 255
  t 1194 4730 2335
  t 2335 4729 1194
  t 585 4731 2335
  t 2335 4730 585
  t 1136 4509 2335
  t 2335 4731 1136
  t 290 4732 2336
  t 2336 4734 290
  t 1193 4733 2336
  t 2336 4732 1193
  t 585 4730 2336
  t 2336 4733 585
  t 1194 4734 2336
  t 2336 4730 1194
  t 289 4735 2337
  t 2337 4737 289
  t 1192 4736 2337
  t 2337 4735 1192
  t 585 4733 2337
  t 2337 4736 585
  t 1193 4737 2337
  t 2337 4733 1193
  t 258 4513 2338
  t 2338 4738 258
  t 1136 4731 2338
  t 2338 4513 1136
  t 585 4736 2338
  t 2338 4731 585
  t 1192 4738 2338
  t 2338 4736 1192
  t 258 4738 2339
  t 2339 4572 258
  t 1192 4739 2339
  t 2339 4738 1192
  t 586 4740 2339
  t 2339 4739 586
  t 1150 4572 2339
  t 2339 4740 1150
  t 289 4741 2340
  t 2340 4735 289
  t 1196 4742 2340
  t 2340 4741 1196
  t 586 4739 2340
  t 2340 4742 586
  t 1192 4735 2340
  t 2340 4739 1192
  t 291 4743 2341
  t 2341 4745 291
  t 1195 4744 2341
  t 2341 4743 1195
  t 586 4742 2341
  t 2341 4744 586
  t 1196 4745 2341
  t 2341 4742 1196
  t 265 4564 2342
  t 2342 4746 265
  t 1150 4740 2342
  t 2342 4564 1150
  t 586 4744 2342
  t 2342 4740 586
  t 1195 4746 2342
  t 2342 4744 1195
  t 265 4746 2343
  t 2343 4558 265
  t 1195 4747 2343
  t 2343 4746 1195
  t 587 4748 2343
  t 2343 4747 587
  t 1147 4558 2343
  t 2343 4748 1147
  t 291 4749 2344
  t 2344 4743 291
  t 1198 4750 2344
  t 2344 4749 1198
  t 587 4747 2344
  t 2344 4750 587
  t 1195 4743 2344
  t 2344 4747 1195
  t 292 4751 2345
  t 2345 4753 292
  t 1197 4752 2345
  t 2345 4751 1197
  t 587 4750 2345
  t 2345 4752 587
  t 1198 4753 2345
  t 2345 4750 1198
  t 256 4561 2346
  t 2346 4754 256
  t 1147 4748 2346
  t 2346 4561 1147
  t 587 4752 2346
  t 2346 4748 587
  t 1197 4754 2346
  t 2346 4752 1197
  t 256 4754 2347
  t 2347 4500 256
  t 1197 4755 2347
  t 2347 4754 1197
  t 588 4756 2347
  t 2347 4755 588
  t 1132 4500 2347
  t 2347 4756 1132
  t 292 4757 2348
  t 2348 4751 292
  t 1199 4758 2348
  t 2348 4757 1199
  t 588 4755 2348
  t 2348 4758 588
  t 1197 4751 2348
  t 2348 4755 1197
  t 290 4734 2349
  t 2349 4760 290
  t 1194 4759 2349
  t 2349 4734 1194
  t 588 4758 2349
  t 2349 4759 588
  t 1199 4760 2349
  t 2349 4758 1199
  t 255 4505 2350
  t 2350 4729 255
  t 1132 4756 2350
  t 2350 4505 1132
  t 588 4759 2350
  t 2350 4756 588
  t 1194 4729 2350
  t 2350 4759 1194
  t 290 4761 2351
  t 2351 4732 290
  t 1202 4762 2351
  t 2351 4761 1202
  t 589 4763 2351
  t 2351 4762 589
  t 1193 4732 2351
  t 2351 4763 1193
  t 294 4764 2352
  t 2352 4766 294
  t 1201 4765 2352
  t 2352 4764 1201
  t 589 4762 2352
  t 2352 4765 589
  t 1202 4766 2352
  t 2352 4762 1202
  t 293 4767 2353
  t 2353 4769 293
  t 1200 4768 2353
  t 2353 4767 1200
  t 589 4765 2353
  t 2353 4768 589
  t 1201 4769 2353
  t 2353 4765 1201
  t 289 4737 2354
  t 2354 4770 289
  t 1193 4763 2354
  t 2354 4737 1193
  t 589 4768 2354
  t 2354 4763 589
  t 1200 4770 2354
  t 2354 4768 1200
  t 289 4770 2355
  t 2355 4741 289
  t 1200 4771 2355
  t 2355 4770 1200
  t 590 4772 2355
  t 2355 4771 590
  t 1196 4741 2355
  t 2355 4772 1196
  t 293 4773 2356
  t 2356 4767 293
  t 1204 4774 2356
  t 2356 4773 1204
  t 590 4771 2356
  t 2356 4774 590
  t 1200 4767 2356
  t 2356 4771 1200
  t 295 4775 2357
  t 2357 4777 295
  t 1203 4776 2357
  t 2357 4775 1203
  t 590 4774 2357
  t 2357 4776 590
  t 1204 4777 2357
  t 2357 4774 1204
  t 291 4745 2358
  t 2358 4778 291
  t 1196 4772 2358
  t 2358 4745 1196
  t 590 4776 2358
  t 2358 4772 590
  t 1203 4778 2358
  t 2358 4776 1203
  t 291 4778 2359
  t 2359 4749 291
  t 1203 4779 2359
  t 2359 4778 1203
  t 591 4780 2359
  t 2359 4779 591
  t 1198 4749 2359
  t 2359 4780 1198
  t 295 4781 2360
  t 2360 4775 295
  t 1206 4782 2360
  t 2360 4781 1206
  t 591 4779 2360
  t 2360 4782 591
  t 1203 4775 2360
  t 2360 4779 1203
  t 296 4783 2361
  t 2361 4785 296
  t 1205 4784 2361
  t 2361 4783 1205
  t 591 4782 2361
  t 2361 4784 591
  t 1206 4785 2361
  t 2361 4782 1206
  t 292 4753 2362
  t 2362 4786 292
  t 1198 4780 2362
  t 2362 4753 1198
  t 591 4784 2362
  t 2362 4780 591
  t 1205 4786 2362
  t 2362 4784 1205
  t 292 4786 2363
  t 2363 4757 292
  t 1205 4787 2363
  t 2363 4786 1205
  t 592 4788 2363
  t 2363 4787 592
  t 1199 4757 2363
  t 2363 4788 1199
  t 296 4789 2364
  t 2364 4783 296
  t 1207 4790 2364
  t 2364 4789 1207
  t 592 4787 2364
  t 2364 4790 592
  t 1205 4783 2364
  t 2364 4787 1205
  t 294 4766 2365
  t 2365 4792 294
  t 1202 4791 2365
  t 2365 4766 1202
  t 592 4790 2365
  t 2365 4791 592
  t 1207 4792 2365
  t 2365 4790 1207
  t 290 4760 2366
  t 2366 4761 290
  t 1199 4788 2366
  t 2366 4760 1199
  t 592 4791 2366
  t 2366 4788 592
  t 1202 4761 2366
  t 2366 4791 1202
  t 294 4793 2367
  t 2367 4764 294
  t 1210 4794 2367
  t 2367 4793 1210
  t 593 4795 2367
  t 2367 4794 593
  t 1201 4764 2367
  t 2367 4795 1201
  t 298 4796 2368
  t 2368 4798 298
  t 1209 4797 2368
  t 2368 4796 1209
  t 593 4794 2368
  t 2368 4797 593
  t 1210 4798 2368
  t 2368 4794 1210
  t 297 4799 2369
  t 2369 4801 297
  t 1208 4800 2369
  t 2369 4799 1208
  t 593 4797 2369
  t 2369 4800 593
  t 1209 4801 2369
  t 2369 4797 1209
  t 293 4769 2370
  t 2370 4802 293
  t 1201 4795 2370
  t 2370 4769 1201
  t 593 4800 2370
  t 2370 4795 593
  t 1208 4802 2370
  t 2370 4800 1208
  t 293 4802 2371
  t 2371 4773 293
  t 1208 4803 2371
  t 2371 4802 1208
  t 594 4804 2371
  t 2371 4803 594
  t 1204 4773 2371
  t 2371 4804 1204
  t 297 4805 2372
  t 2372 4799 297
  t 1212 4806 2372
  t 2372 4805 1212
  t 594 4803 2372
  t 2372 4806 594
  t 1208 4799 2372
  t 2372 4803 1208
  t 299 4807 2373
  t 2373 4809 299
  t 1211 4808 2373
  t 2373 4807 1211
  t 594 4806 2373
  t 2373 4808 594
  t 1212 4809 2373
  t 2373 4806 1212
  t 295 4777 2374
  t 2374 4810 295
  t 1204 4804 2374
  t 2374 4777 1204
  t 594 4808 2374
  t 2374 4804 594
  t 1211 4810 2374
  t 2374 4808 1211
  t 295 4810 2375
  t 2375 4781 295
  t 1211 4811 2375
  t 2375 4810 1211
  t 595 4812 2375
  t 2375 4811 595
  t 1206 4781 2375
  t 2375 4812 1206
  t 299 4813 2376
  t 2376 4807 299
  t 1214 4814 2376
  t 2376 4813 1214
  t 595 4811 2376
  t 2376 4814 595
  t 1211 4807 2376
  t 2376 4811 1211
  t 300 4815 2377
  t 2377 4817 300
  t 1213 4816 2377
  t 2377 4815 1213
  t 595 4814 2377
  t 2377 4816 595
  t 1214 4817 2377
  t 2377 4814 1214
  t 296 4785 2378
  t 2378 4818 296
  t 1206 4812 2378
  t 2378 4785 1206
  t 595 4816 2378
  t 2378 4812 595
  t 1213 4818 2378
  t 2378 4816 1213
  t 296 4818 2379
  t 2379 4789 296
  t 1213 4819 2379
  t 2379 4818 1213
  t 596 4820 2379
  t 2379 4819 596
  t 1207 4789 2379
  t 2379 4820 1207
  t 300 4821 2380
  t 2380 4815 300
  t 1215 4822 2380
  t 2380 4821 1215
  t 596 4819 2380
  t 2380 4822 596
  t 1213 4815 2380
  t 2380 4819 1213
  t 298 4798 2381
  t 2381 4824 298
  t 1210 4823 2381
  t 2381 4798 1210
  t 596 4822 2381
  t 2381 4823 596
  t 1215 4824 2381
  t 2381 4822 1215
  t 294 4792 2382
  t 2382 4793 294
  t 1207 4820 2382
  t 2382 4792 1207
  t 596 4823 2382
  t 2382 4820 596
  t 1210 4793 2382
  t 2382 4823 1210
  t 298 4825 2383
  t 2383 4796 298
  t 1217 4826 2383
  t 2383 4825 1217
  t 597 4827 2383
  t 2383 4826 597
  t 1209 4796 2383
  t 2383 4827 1209
  t 285 4720 2384
  t 2384 4829 285
  t 1188 4828 2384
  t 2384 4720 1188
  t 597 4826 2384
  t 2384 4828 597
  t 1217 4829 2384
  t 2384 4826 1217
  t 286 4830 2385
  t 2385 4727 286
  t 1216 4831 2385
  t 2385 4830 1216
  t 597 4828 2385
  t 2385 4831 597
  t 1188 4727 2385
  t 2385 4828 1188
  t 297 4801 2386
  t 2386 4832 297
  t 1209 4827 2386
  t 2386 4801 1209
  t 597 4831 2386
  t 2386 4827 597
  t 1216 4832 2386
  t 2386 4831 1216
  t 297 4832 2387
  t 2387 4805 297
  t 1216 4833 2387
  t 2387 4832 1216
  t 598 4834 2387
  t 2387 4833 598
  t 1212 4805 2387
  t 2387 4834 1212
  t 286 4728 2388
  t 2388 4830 286
  t 1189 4835 2388
  t 2388 4728 1189
  t 598 4833 2388
  t 2388 4835 598
  t 1216 4830 2388
  t 2388 4833 1216
  t 287 4836 2389
  t 2389 4724 287
  t 1218 4837 2389
  t 2389 4836 1218
  t 598 4835 2389
  t 2389 4837 598
  t 1189 4724 2389
  t 2389 4835 1189
  t 299 4809 2390
  t 2390 4838 299
  t 1212 4834 2390
  t 2390 4809 1212
  t 598 4837 2390
  t 2390 4834 598
  t 1218 4838 2390
  t 2390 4837 1218
  t 299 4838 2391
  t 2391 4813 299
  t 1218 4839 2391
  t 2391 4838 1218
  t 599 4840 2391
  t 2391 4839 599
  t 1214 4813 2391
  t 2391 4840 1214
  t 287 4726 2392
  t 2392 4836 287
  t 1190 4841 2392
  t 2392 4726 1190
  t 599 4839 2392
  t 2392 4841 599
  t 1218 4836 2392
  t 2392 4839 1218
  t 288 4842 2393
  t 2393 4721 288
  t 1219 4843 2393
  t 2393 4842 1219
  t 599 4841 2393
  t 2393 4843 599
  t 1190 4721 2393
  t 2393 4841 1190
  t 300 4817 2394
  t 2394 4844 300
  t 1214 4840 2394
  t 2394 4817 1214
  t 599 4843 2394
  t 2394 4840 599
  t 1219 4844 2394
  t 2394 4843 1219
  t 300 4844 2395
  t 2395 4821 300
  t 1219 4845 2395
  t 2395 4844 1219
  t 600 4846 2395
  t 2395 4845 600
  t 1215 4821 2395
  t 2395 4846 1215
  t 288 4723 2396
  t 2396 4842 288
  t 1191 4847 2396
  t 2396 4723 1191
  t 600 4845 2396
  t 2396 4847 600
  t 1219 4842 2396
  t 2396 4845 1219
  t 285 4829 2397
  t 2397 4717 285
  t 1217 4848 2397
  t 2397 4829 1217
  t 600 4847 2397
  t 2397 4848 600
  t 1191 4717 2397
  t 2397 4847 1191
  t 298 4824 2398
  t 2398 4825 298
  t 1215 4846 2398
  t 2398 4824 1215
  t 600 4848 2398
  t 2398 4846 600
  t 1217 4825 2398
  t 2398 4848 1217
  t 176 4849 2399
  t 2399 4852 176
  t 1223 4850 2399
  t 2399 4849 1223
  t 601 4851 2399
  t 2399 4850 601
  t 1220 4852 2399
  t 2399 4851 1220
  t 302 4853 2400
  t 2400 4855 302
  t 1222 4854 2400
  t 2400 4853 1222
  t 601 4850 2400
  t 2400 4854 601
  t 1223 4855 2400
  t 2400 4850 1223
  t 301 4856 2401
  t 2401 4858 301
  t 1221 4857 2401
  t 2401 4856 1221
  t 601 4854 2401
  t 2401 4857 601
  t 1222 4858 2401
  t 2401 4854 1222
  t 189 4859 2402
  t 2402 4860 189
  t 1220 4851 2402
  t 2402 4859 1220
  t 601 4857 2402
  t 2402 4851 601
  t 1221 4860 2402
  t 2402 4857 1221
  t 189 4860 2403
  t 2403 4010 189
  t 1221 4861 2403
  t 2403 4860 1221
  t 602 4862 2403
  t 2403 4861 602
  t 1009 4010 2403
  t 2403 4862 1009
  t 301 4863 2404
  t 2404 4856 301
  t 1225 4864 2404
  t 2404 4863 1225
  t 602 4861 2404
  t 2404 4864 602
  t 1221 4856 2404
  t 2404 4861 1221
  t 303 4865 2405
  t 2405 4867 303
  t 1224 4866 2405
  t 2405 4865 1224
  t 602 4864 2405
  t 2405 4866 602
  t 1225 4867 2405
  t 2405 4864 1225
  t 184 4016 2406
  t 2406 4868 184
  t 1009 4862 2406
  t 2406 4016 1009
  t 602 4866 2406
  t 2406 4862 602
  t 1224 4868 2406
  t 2406 4866 1224
  t 184 4868 2407
  t 2407 3978 184
  t 1224 4869 2407
  t 2407 4868 1224
  t 603 4870 2407
  t 2407 4869 603
  t 995 3978 2407
  t 2407 4870 995
  t 303 4871 2408
  t 2408 4865 303
  t 1227 4872 2408
  t 2408 4871 1227
  t 603 4869 2408
  t 2408 4872 603
  t 1224 4865 2408
  t 2408 4869 1224
  t 304 4873 2409
  t 2409 4875 304
  t 1226 4874 2409
  t 2409 4873 1226
  t 603 4872 2409
  t 2409 4874 603
  t 1227 4875 2409
  t 2409 4872 1227
  t 177 3972 2410
  t 2410 4876 177
  t 995 4870 2410
  t 2410 3972 995
  t 603 4874 2410
  t 2410 4870 603
  t 1226 4876 2410
  t 2410 4874 1226
  t 177 4876 2411
  t 2411 3921 177
  t 1226 4877 2411
  t 2411 4876 1226
  t 604 4878 2411
  t 2411 4877 604
  t 982 3921 2411
  t 2411 4878 982
  t 304 4879 2412
  t 2412 4873 304
  t 1228 4880 2412
  t 2412 4879 1228
  t 604 4877 2412
  t 2412 4880 604
  t 1226 4873 2412
  t 2412 4877 1226
  t 302 4855 2413
  t 2413 4882 302
  t 1223 4881 2413
  t 2413 4855 1223
  t 604 4880 2413
  t 2413 4881 604
  t 1228 4882 2413
  t 2413 4880 1228
  t 176 3925 2414
  t 2414 4849 176
  t 982 4878 2414
  t 2414 3925 982
  t 604 4881 2414
  t 2414 4878 604
  t 1223 4849 2414
  t 2414 4881 1223
  t 305 4883 2415
  t 2415 4886 305
  t 1232 4884 2415
  t 2415 4883 1232
  t 605 4885 2415
  t 2415 4884 605
  t 1229 4886 2415
  t 2415 4885 1229
  t 308 4887 2416
  t 2416 4889 308
  t 1231 4888 2416
  t 2416 4887 1231
  t 605 4884 2416
  t 2416 4888 605
  t 1232 4889 2416
  t 2416 4884 1232
  t 307 4890 2417
  t 2417 4892 307
  t 1230 4891 2417
  t 2417 4890 1230
  t 605 4888 2417
  t 2417 4891 605
  t 1231 4892 2417
  t 2417 4888 1231
  t 306 4893 2418
  t 2418 4894 306
  t 1229 4885 2418
  t 2418 4893 1229
  t 605 4891 2418
  t 2418 4885 605
  t 1230 4894 2418
  t 2418 4891 1230
  t 302 4895 2419
  t 2419 4853 302
  t 1235 4896 2419
  t 2419 4895 1235
  t 606 4897 2419
  t 2419 4896 606
  t 1222 4853 2419
  t 2419 4897 1222
  t 310 4898 2420
  t 2420 4900 310
  t 1234 4899 2420
  t 2420 4898 1234
  t 606 4896 2420
  t 2420 4899 606
  t 1235 4900 2420
  t 2420 4896 1235
  t 309 4901 2421
  t 2421 4903 309
  t 1233 4902 2421
  t 2421 4901 1233
  t 606 4899 2421
  t 2421 4902 606
  t 1234 4903 2421
  t 2421 4899 1234
  t 301 4858 2422
  t 2422 4904 301
  t 1222 4897 2422
  t 2422 4858 1222
  t 606 4902 2422
  t 2422 4897 606
  t 1233 4904 2422
  t 2422 4902 1233
  t 301 4904 2423
  t 2423 4863 301
  t 1233 4905 2423
  t 2423 4904 1233
  t 607 4906 2423
  t 2423 4905 607
  t 1225 4863 2423
  t 2423 4906 1225
  t 309 4907 2424
  t 2424 4901 309
  t 1237 4908 2424
  t 2424 4907 1237
  t 607 4905 2424
  t 2424 4908 607
  t 1233 4901 2424
  t 2424 4905 1233
  t 311 4909 2425
  t 2425 4911 311
  t 1236 4910 2425
  t 2425 4909 1236
  t 607 4908 2425
  t 2425 4910 607
  t 1237 4911 2425
  t 2425 4908 1237
  t 303 4867 2426
  t 2426 4912 303
  t 1225 4906 2426
  t 2426 4867 1225
  t 607 4910 2426
  t 2426 4906 607
  t 1236 4912 2426
  t 2426 4910 1236
  t 303 4912 2427
  t 2427 4871 303
  t 1236 4913 2427
  t 2427 4912 1236
  t 608 4914 2427
  t 2427 4913 608
  t 1227 4871 2427
  t 2427 4914 1227
  t 311 4915 2428
  t 2428 4909 311
  t 1239 4916 2428
  t 2428 4915 1239
  t 608 4913 2428
  t 2428 4916 608
  t 1236 4909 2428
  t 2428 4913 1236
  t 312 4917 2429
  t 2429 4919 312
  t 1238 4918 2429
  t 2429 4917 1238
  t 608 4916 2429
  t 2429 4918 608
  t 1239 4919 2429
  t 2429 4916 1239
  t 304 4875 2430
  t 2430 4920 304
  t 1227 4914 2430
  t 2430 4875 1227
  t 608 4918 2430
  t 2430 4914 608
  t 1238 4920 2430
  t 2430 4918 1238
  t 304 4920 2431
  t 2431 4879 304
  t 1238 4921 2431
  t 2431 4920 1238
  t 609 4922 2431
  t 2431 4921 609
  t 1228 4879 2431
  t 2431 4922 1228
  t 312 4923 2432
  t 2432 4917 312
  t 1240 4924 2432
  t 2432 4923 1240
  t 609 4921 2432
  t 2432 4924 609
  t 1238 4917 2432
  t 2432 4921 1238
  t 310 4900 2433
  t 2433 4926 310
  t 1235 4925 2433
  t 2433 4900 1235
  t 609 4924 2433
  t 2433 4925 609
  t 1240 4926 2433
  t 2433 4924 1240
  t 302 4882 2434
  t 2434 4895 302
  t 1228 4922 2434
  t 2434 4882 1228
  t 609 4925 2434
  t 2434 4922 609
  t 1235 4895 2434
  t 2434 4925 1235
  t 310 4927 2435
  t 2435 4898 310
  t 1242 4928 2435
  t 2435 4927 1242
  t 610 4929 2435
  t 2435 4928 610
  t 1234 4898 2435
  t 2435 4929 1234
  t 305 4886 2436
  t 2436 4931 305
  t 1229 4930 2436
  t 2436 4886 1229
  t 610 4928 2436
  t 2436 4930 610
  t 1242 4931 2436
  t 2436 4928 1242
  t 306 4932 2437
  t 2437 4893 306
  t 1241 4933 2437
  t 2437 4932 1241
  t 610 4930 2437
  t 2437 4933 610
  t 1229 4893 2437
  t 2437 4930 1229
  t 309 4903 2438
  t 2438 4934 309
  t 1234 4929 2438
  t 2438 4903 1234
  t 610 4933 2438
  t 2438 4929 610
  t 1241 4934 2438
  t 2438 4933 1241
  t 309 4934 2439
  t 2439 4907 309
  t 1241 4935 2439
  t 2439 4934 1241
  t 611 4936 2439
  t 2439 4935 611
  t 1237 4907 2439
  t 2439 4936 1237
  t 306 4894 2440
  t 2440 4932 306
  t 1230 4937 2440
  t 2440 4894 1230
  t 611 4935 2440
  t 2440 4937 611
  t 1241 4932 2440
  t 2440 4935 1241
  t 307 4938 2441
  t 2441 4890 307
  t 1243 4939 2441
  t 2441 4938 1243
  t 611 4937 2441
  t 2441 4939 611
  t 1230 4890 2441
  t 2441 4937 1230
  t 311 4911 2442
  t 2442 4940 311
  t 1237 4936 2442
  t 2442 4911 1237
  t 611 4939 2442
  t 2442 4936 611
  t 1243 4940 2442
  t 2442 4939 1243
  t 311 4940 2443
  t 2443 4915 311
  t 1243 4941 2443
  t 2443 4940 1243
  t 612 4942 2443
  t 2443 4941 612
  t 1239 4915 2443
  t 2443 4942 1239
  t 307 4892 2444
  t 2444 4938 307
  t 1231 4943 2444
  t 2444 4892 1231
  t 612 4941 2444
  t 2444 4943 612
  t 1243 4938 2444
  t 2444 4941 1243
  t 308 4944 2445
  t 2445 4887 308
  t 1244 4945 2445
  t 2445 4944 1244
  t 612 4943 2445
  t 2445 4945 612
  t 1231 4887 2445
  t 2445 4943 1231
  t 312 4919 2446
  t 2446 4946 312
  t 1239 4942 2446
  t 2446 4919 1239
  t 612 4945 2446
  t 2446 4942 612
  t 1244 4946 2446
  t 2446 4945 1244
  t 312 4946 2447
  t 2447 4923 312
  t 1244 4947 2447
  t 2447 4946 1244
  t 613 4948 2447
  t 2447 4947 613
  t 1240 4923 2447
  t 2447 4948 1240
  t 308 4889 2448
  t 2448 4944 308
  t 1232 4949 2448
  t 2448 4889 1232
  t 613 4947 2448
  t 2448 4949 613
  t 1244 4944 2448
  t 2448 4947 1244
  t 305 4931 2449
  t 2449 4883 305
  t 1242 4950 2449
  t 2449 4931 1242
  t 613 4949 2449
  t 2449 4950 613
  t 1232 4883 2449
  t 2449 4949 1232
  t 310 4926 2450
  t 2450 4927 310
  t 1240 4948 2450
  t 2450 4926 1240
  t 613 4950 2450
  t 2450 4948 613
  t 1242 4927 2450
  t 2450 4950 1242
  t 313 4951 2451
  t 2451 4954 313
  t 1250 4952 2451
  t 2451 4951 1250
  t 614 4953 2451
  t 2451 4952 614
  t 1290 4954 2451
  t 2451 4953 1290
  t 316 4955 2452
  t 2452 4957 316
  t 1249 4956 2452
  t 2452 4955 1249
  t 614 4952 2452
  t 2452 4956 614
  t 1250 4957 2452
  t 2452 4952 1250
  t 315 4958 2453
  t 2453 4959 315
  t 1290 4953 2453
  t 2453 4958 1290
  t 614 4956 2453
  t 2453 4953 614
  t 1249 4959 2453
  t 2453 4956 1249
  t 144 3724 2454
  t 2454 4962 144
  t 1253 4960 2454
  t 2454 3724 1253
  t 615 4961 2454
  t 2454 4960 615
  t 1251 4962 2454
  t 2454 4961 1251
  t 317 4963 2455
  t 2455 3728 317
  t 1252 4964 2455
  t 2455 4963 1252
  t 615 4960 2455
  t 2455 4964 615
  t 1253 3728 2455
  t 2455 4960 1253
  t 161 4965 2456
  t 2456 4966 161
  t 1251 4961 2456
  t 2456 4965 1251
  t 615 4964 2456
  t 2456 4961 615
  t 1252 4966 2456
  t 2456 4964 1252
  t 317 3732 2457
  t 2457 4963 317
  t 1255 4967 2457
  t 2457 3732 1255
  t 616 4968 2457
  t 2457 4967 616
  t 1252 4963 2457
  t 2457 4968 1252
  t 318 4969 2458
  t 2458 3736 318
  t 1254 4970 2458
  t 2458 4969 1254
  t 616 4967 2458
  t 2458 4970 616
  t 1255 3736 2458
  t 2458 4967 1255
  t 164 3856 2459
  t 2459 4972 164
  t 964 4971 2459
  t 2459 3856 964
  t 616 4970 2459
  t 2459 4971 616
  t 1254 4972 2459
  t 2459 4970 1254
  t 161 4966 2460
  t 2460 3850 161
  t 1252 4968 2460
  t 2460 4966 1252
  t 616 4971 2460
  t 2460 4968 616
  t 964 3850 2460
  t 2460 4971 964
  t 318 3740 2461
  t 2461 4969 318
  t 1257 4973 2461
  t 2461 3740 1257
  t 617 4974 2461
  t 2461 4973 617
  t 1254 4969 2461
  t 2461 4974 1254
  t 319 4975 2462
  t 2462 3744 319
  t 1256 4976 2462
  t 2462 4975 1256
  t 617 4973 2462
  t 2462 4976 617
  t 1257 3744 2462
  t 2462 4973 1257
  t 167 3867 2463
  t 2463 4978 167
  t 968 4977 2463
  t 2463 3867 968
  t 617 4976 2463
  t 2463 4977 617
  t 1256 4978 2463
  t 2463 4976 1256
  t 164 4972 2464
  t 2464 3862 164
  t 1254 4974 2464
  t 2464 4972 1254
  t 617 4977 2464
  t 2464 4974 617
  t 968 3862 2464
  t 2464 4977 968
  t 319 3748 2465
  t 2465 4975 319
  t 943 4979 2465
  t 2465 3748 943
  t 618 4980 2465
  t 2465 4979 618
  t 1256 4975 2465
  t 2465 4980 1256
  t 145 4981 2466
  t 2466 3752 145
  t 1258 4982 2466
  t 2466 4981 1258
  t 618 4979 2466
  t 2466 4982 618
  t 943 3752 2466
  t 2466 4979 943
  t 170 3880 2467
  t 2467 4984 170
  t 972 4983 2467
  t 2467 3880 972
  t 618 4982 2467
  t 2467 4983 618
  t 1258 4984 2467
  t 2467 4982 1258
  t 167 4978 2468
  t 2468 3875 167
  t 1256 4980 2468
  t 2468 4978 1256
  t 618 4983 2468
  t 2468 4980 618
  t 972 3875 2468
  t 2468 4983 972
  t 145 3756 2469
  t 2469 4981 145
  t 1260 4985 2469
  t 2469 3756 1260
  t 619 4986 2469
  t 2469 4985 619
  t 1258 4981 2469
  t 2469 4986 1258
  t 320 4987 2470
  t 2470 3760 320
  t 1259 4988 2470
  t 2470 4987 1259
  t 619 4985 2470
  t 2470 4988 619
  t 1260 3760 2470
  t 2470 4985 1260
  t 172 3893 2471
  t 2471 4990 172
  t 975 4989 2471
  t 2471 3893 975
  t 619 4988 2471
  t 2471 4989 619
  t 1259 4990 2471
  t 2471 4988 1259
  t 170 4984 2472
  t 2472 3888 170
  t 1258 4986 2472
  t 2472 4984 1258
  t 619 4989 2472
  t 2472 4986 619
  t 975 3888 2472
  t 2472 4989 975
  t 320 3764 2473
  t 2473 4987 320
  t 944 4991 2473
  t 2473 3764 944
  t 620 4992 2473
  t 2473 4991 620
  t 1259 4987 2473
  t 2473 4992 1259
  t 146 4993 2474
  t 2474 3768 146
  t 1261 4994 2474
  t 2474 4993 1261
  t 620 4991 2474
  t 2474 4994 620
  t 944 3768 2474
  t 2474 4991 944
  t 174 3903 2475
  t 2475 4996 174
  t 978 4995 2475
  t 2475 3903 978
  t 620 4994 2475
  t 2475 4995 620
  t 1261 4996 2475
  t 2475 4994 1261
  t 172 4990 2476
  t 2476 3898 172
  t 1259 4992 2476
  t 2476 4990 1259
  t 620 4995 2476
  t 2476 4992 620
  t 978 3898 2476
  t 2476 4995 978
  t 146 3772 2477
  t 2477 4993 146
  t 1262 4997 2477
  t 2477 3772 1262
  t 621 4998 2477
  t 2477 4997 621
  t 1261 4993 2477
  t 2477 4998 1261
  t 175 3912 2478
  t 2478 3774 175
  t 980 4999 2478
  t 2478 3912 980
  t 621 4997 2478
  t 2478 4999 621
  t 1262 3774 2478
  t 2478 4997 1262
  t 174 4996 2479
  t 2479 3908 174
  t 1261 4998 2479
  t 2479 4996 1261
  t 621 4999 2479
  t 2479 4998 621
  t 980 3908 2479
  t 2479 4999 980
  t 147 3778 2480
  t 2480 5002 147
  t 945 5000 2480
  t 2480 3778 945
  t 622 5001 2480
  t 2480 5000 622
  t 1263 5002 2480
  t 2480 5001 1263
  t 144 4962 2481
  t 2481 3782 144
  t 1251 5003 2481
  t 2481 4962 1251
  t 622 5000 2481
  t 2481 5003 622
  t 945 3782 2481
  t 2481 5000 945
  t 161 3853 2482
  t 2482 4965 161
  t 961 5004 2482
  t 2482 3853 961
  t 622 5003 2482
  t 2482 5004 622
  t 1251 4965 2482
  t 2482 5003 1251
  t 162 5005 2483
  t 2483 3860 162
  t 1263 5001 2483
  t 2483 5005 1263
  t 622 5004 2483
  t 2483 5001 622
  t 961 3860 2483
  t 2483 5004 961
  t 149 3786 2484
  t 2484 5008 149
  t 947 5006 2484
  t 2484 3786 947
  t 623 5007 2484
  t 2484 5006 623
  t 1264 5008 2484
  t 2484 5007 1264
  t 147 5002 2485
  t 2485 3790 147
  t 1263 5009 2485
  t 2485 5002 1263
  t 623 5006 2485
  t 2485 5009 623
  t 947 3790 2485
  t 2485 5006 947
  t 162 3918 2486
  t 2486 5005 162
  t 981 5010 2486
  t 2486 3918 981
  t 623 5009 2486
  t 2486 5010 623
  t 1263 5005 2486
  t 2486 5009 1263
  t 176 5011 2487
  t 2487 3924 176
  t 1264 5007 2487
  t 2487 5011 1264
  t 623 5010 2487
  t 2487 5007 623
  t 981 3924 2487
  t 2487 5010 981
  t 314 3793 2488
  t 2488 5014 314
  t 949 5012 2488
  t 2488 3793 949
  t 624 5013 2488
  t 2488 5012 624
  t 1246 5014 2488
  t 2488 5013 1246
  t 149 5008 2489
  t 2489 3796 149
  t 1264 5015 2489
  t 2489 5008 1264
  t 624 5012 2489
  t 2489 5015 624
  t 949 3796 2489
  t 2489 5012 949
  t 176 4852 2490
  t 2490 5011 176
  t 1220 5016 2490
  t 2490 4852 1220
  t 624 5015 2490
  t 2490 5016 624
  t 1264 5011 2490
  t 2490 5015 1264
  t 189 5017 2491
  t 2491 4859 189
  t 1246 5013 2491
  t 2491 5017 1246
  t 624 5016 2491
  t 2491 5013 624
  t 1220 4859 2491
  t 2491 5016 1220
  t 5171 3799 2492
  t 2492 5462 5171
  t 951 5018 5312
  t 5312 5392 951
  t 625 5019 5312
  t 5312 5018 625
  t 5254 5462 2492
  t 2492 5464 5254
  t 313 5020 2493
  t 2493 3803 313
  t 1245 5021 2493
  t 2493 5020 1245
  t 5208 5463 2493
  t 2493 5021 5208
  t 5231 3803 2493
  t 2493 5463 5231
  t 190 4062 2494
  t 2494 5023 190
  t 1019 5022 2494
  t 2494 4062 1019
  t 5208 5021 2494
  t 2494 5022 5208
  t 1245 5023 2494
  t 2494 5021 1245
  t 196 5460 2495
  t 2495 4068 196
  t 5254 5464 2495
  t 2495 5460 5254
  t 625 5465 5313
  t 5313 5019 625
  t 5236 5405 5313
  t 5313 5465 5236
  t 5172 3807 2496
  t 2496 5434 5172
  t 953 5024 5314
  t 5314 5396 953
  t 626 5025 5314
  t 5314 5024 626
  t 5247 5434 2496
  t 2496 5467 5247
  t 154 5026 2497
  t 2497 3811 154
  t 1265 5027 2497
  t 2497 5026 1265
  t 5209 5466 2497
  t 2497 5027 5209
  t 5233 3811 2497
  t 2497 5466 5233
  t 223 4277 2498
  t 2498 5029 223
  t 5249 5028 2498
  t 2498 4277 5249
  t 5209 5027 2498
  t 2498 5028 5209
  t 1265 5029 2498
  t 2498 5027 1265
  t 5179 5436 2499
  t 2499 4272 5179
  t 5247 5467 2499
  t 2499 5436 5247
  t 626 5468 5315
  t 5315 5025 626
  t 1073 5437 5315
  t 5315 5468 1073
  t 154 3815 2500
  t 2500 5026 154
  t 955 5030 2500
  t 2500 3815 955
  t 627 5031 2500
  t 2500 5030 627
  t 1265 5026 2500
  t 2500 5031 1265
  t 155 5032 2501
  t 2501 3819 155
  t 1266 5033 2501
  t 2501 5032 1266
  t 627 5030 2501
  t 2501 5033 627
  t 955 3819 2501
  t 2501 5030 955
  t 232 4333 2502
  t 2502 5035 232
  t 1088 5034 2502
  t 2502 4333 1088
  t 627 5033 2502
  t 2502 5034 627
  t 1266 5035 2502
  t 2502 5033 1266
  t 223 5029 2503
  t 2503 4328 223
  t 1265 5031 2503
  t 2503 5029 1265
  t 627 5034 2503
  t 2503 5031 627
  t 1088 4328 2503
  t 2503 5034 1088
  t 155 3823 2504
  t 2504 5032 155
  t 956 5036 2504
  t 2504 3823 956
  t 628 5037 2504
  t 2504 5036 628
  t 1266 5032 2504
  t 2504 5037 1266
  t 156 5038 2505
  t 2505 3827 156
  t 1267 5039 2505
  t 2505 5038 1267
  t 628 5036 2505
  t 2505 5039 628
  t 956 3827 2505
  t 2505 5036 956
  t 240 4387 2506
  t 2506 5041 240
  t 1103 5040 2506
  t 2506 4387 1103
  t 628 5039 2506
  t 2506 5040 628
  t 1267 5041 2506
  t 2506 5039 1267
  t 232 5035 2507
  t 2507 4382 232
  t 1266 5037 2507
  t 2507 5035 1266
  t 628 5040 2507
  t 2507 5037 628
  t 1103 4382 2507
  t 2507 5040 1103
  t 156 3831 2508
  t 2508 5038 156
  t 957 5042 2508
  t 2508 3831 957
  t 629 5043 2508
  t 2508 5042 629
  t 1267 5038 2508
  t 2508 5043 1267
  t 321 5044 2509
  t 2509 3835 321
  t 1268 5045 2509
  t 2509 5044 1268
  t 629 5042 2509
  t 2509 5045 629
  t 957 3835 2509
  t 2509 5042 957
  t 246 4435 2510
  t 2510 5047 246
  t 1116 5046 2510
  t 2510 4435 1116
  t 629 5045 2510
  t 2510 5046 629
  t 1268 5047 2510
  t 2510 5045 1268
  t 240 5041 2511
  t 2511 4430 240
  t 1267 5043 2511
  t 2511 5041 1267
  t 629 5046 2511
  t 2511 5043 629
  t 1116 4430 2511
  t 2511 5046 1116
  t 321 3839 2512
  t 2512 5044 321
  t 1270 5048 2512
  t 2512 3839 1270
  t 630 5049 2512
  t 2512 5048 630
  t 1268 5044 2512
  t 2512 5049 1268
  t 158 5050 2513
  t 2513 3843 158
  t 1269 5051 2513
  t 2513 5050 1269
  t 630 5048 2513
  t 2513 5051 630
  t 1270 3843 2513
  t 2513 5048 1270
  t 253 4483 2514
  t 2514 5053 253
  t 1128 5052 2514
  t 2514 4483 1128
  t 630 5051 2514
  t 2514 5052 630
  t 1269 5053 2514
  t 2514 5051 1269
  t 246 5047 2515
  t 2515 4478 246
  t 1268 5049 2515
  t 2515 5047 1268
  t 630 5052 2515
  t 2515 5049 630
  t 1128 4478 2515
  t 2515 5052 1128
  t 158 3847 2516
  t 2516 5050 158
  t 959 5054 2516
  t 2516 3847 959
  t 631 5055 2516
  t 2516 5054 631
  t 1269 5050 2516
  t 2516 5055 1269
  t 263 4536 2517
  t 2517 3849 263
  t 1144 5056 2517
  t 2517 4536 1144
  t 631 5054 2517
  t 2517 5056 631
  t 959 3849 2517
  t 2517 5054 959
  t 253 5053 2518
  t 2518 4532 253
  t 1269 5055 2518
  t 2518 5053 1269
  t 631 5056 2518
  t 2518 5055 631
  t 1144 4532 2518
  t 2518 5056 1144
  t 326 5057 2519
  t 2519 5060 326
  t 1279 5058 2519
  t 2519 5057 1279
  t 632 5059 2519
  t 2519 5058 632
  t 1291 5060 2519
  t 2519 5059 1291
  t 327 5061 2520
  t 2520 5063 327
  t 1280 5062 2520
  t 2520 5061 1280
  t 632 5058 2520
  t 2520 5062 632
  t 1279 5063 2520
  t 2520 5058 1279
  t 328 5064 2521
  t 2521 5065 328
  t 1291 5059 2521
  t 2521 5064 1291
  t 632 5062 2521
  t 2521 5059 632
  t 1280 5065 2521
  t 2521 5062 1280
  t 316 5066 2522
  t 2522 5069 316
  t 930 5067 2522
  t 2522 5066 930
  t 633 5068 2522
  t 2522 5067 633
  t 1275 5069 2522
  t 2522 5068 1275
  t 143 5070 2523
  t 2523 5072 143
  t 1276 5071 2523
  t 2523 5070 1276
  t 633 5067 2523
  t 2523 5071 633
  t 930 5072 2523
  t 2523 5067 930
  t 323 5073 2524
  t 2524 5075 323
  t 1271 5074 2524
  t 2524 5073 1271
  t 633 5071 2524
  t 2524 5074 633
  t 1276 5075 2524
  t 2524 5071 1276
  t 322 5076 2525
  t 2525 5077 322
  t 1275 5068 2525
  t 2525 5076 1275
  t 633 5074 2525
  t 2525 5068 633
  t 1271 5077 2525
  t 2525 5074 1271
  t 143 3720 2526
  t 2526 5070 143
  t 942 5078 2526
  t 2526 3720 942
  t 634 5079 2526
  t 2526 5078 634
  t 1276 5070 2526
  t 2526 5079 1276
  t 160 5080 2527
  t 2527 3716 160
  t 1277 5081 2527
  t 2527 5080 1277
  t 634 5078 2527
  t 2527 5081 634
  t 942 3716 2527
  t 2527 5078 942
  t 324 5082 2528
  t 2528 5084 324
  t 1272 5083 2528
  t 2528 5082 1272
  t 634 5081 2528
  t 2528 5083 634
  t 1277 5084 2528
  t 2528 5081 1277
  t 323 5075 2529
  t 2529 5085 323
  t 1276 5079 2529
  t 2529 5075 1276
  t 634 5083 2529
  t 2529 5079 634
  t 1272 5085 2529
  t 2529 5083 1272
  t 160 5086 2530
  t 2530 5080 160
  t 1248 5087 2530
  t 2530 5086 1248
  t 635 5088 2530
  t 2530 5087 635
  t 1277 5080 2530
  t 2530 5088 1277
  t 315 5089 2531
  t 2531 5091 315
  t 1278 5090 2531
  t 2531 5089 1278
  t 635 5087 2531
  t 2531 5090 635
  t 1248 5091 2531
  t 2531 5087 1248
  t 325 5092 2532
  t 2532 5094 325
  t 1273 5093 2532
  t 2532 5092 1273
  t 635 5090 2532
  t 2532 5093 635
  t 1278 5094 2532
  t 2532 5090 1278
  t 324 5084 2533
  t 2533 5095 324
  t 1277 5088 2533
  t 2533 5084 1277
  t 635 5093 2533
  t 2533 5088 635
  t 1273 5095 2533
  t 2533 5093 1273
  t 315 4959 2534
  t 2534 5089 315
  t 1249 5096 2534
  t 2534 4959 1249
  t 636 5097 2534
  t 2534 5096 636
  t 1278 5089 2534
  t 2534 5097 1278
  t 316 5069 2535
  t 2535 4955 316
  t 1275 5098 2535
  t 2535 5069 1275
  t 636 5096 2535
  t 2535 5098 636
  t 1249 4955 2535
  t 2535 5096 1249
  t 322 5099 2536
  t 2536 5076 322
  t 1274 5100 2536
  t 2536 5099 1274
  t 636 5098 2536
  t 2536 5100 636
  t 1275 5076 2536
  t 2536 5098 1275
  t 325 5094 2537
  t 2537 5101 325
  t 1278 5097 2537
  t 2537 5094 1278
  t 636 5100 2537
  t 2537 5097 636
  t 1274 5101 2537
  t 2537 5100 1274
  t 322 5077 2538
  t 2538 5104 322
  t 1271 5102 2538
  t 2538 5077 1271
  t 637 5103 2538
  t 2538 5102 637
  t 1283 5104 2538
  t 2538 5103 1283
  t 323 5105 2539
  t 2539 5073 323
  t 1284 5106 2539
  t 2539 5105 1284
  t 637 5102 2539
  t 2539 5106 637
  t 1271 5073 2539
  t 2539 5102 1271
  t 327 5063 2540
  t 2540 5108 327
  t 1279 5107 2540
  t 2540 5063 1279
  t 637 5106 2540
  t 2540 5107 637
  t 1284 5108 2540
  t 2540 5106 1284
  t 326 5109 2541
  t 2541 5057 326
  t 1283 5103 2541
  t 2541 5109 1283
  t 637 5107 2541
  t 2541 5103 637
  t 1279 5057 2541
  t 2541 5107 1279
  t 323 5085 2542
  t 2542 5105 323
  t 1272 5110 2542
  t 2542 5085 1272
  t 638 5111 2542
  t 2542 5110 638
  t 1284 5105 2542
  t 2542 5111 1284
  t 324 5112 2543
  t 2543 5082 324
  t 1285 5113 2543
  t 2543 5112 1285
  t 638 5110 2543
  t 2543 5113 638
  t 1272 5082 2543
  t 2543 5110 1272
  t 328 5065 2544
  t 2544 5115 328
  t 1280 5114 2544
  t 2544 5065 1280
  t 638 5113 2544
  t 2544 5114 638
  t 1285 5115 2544
  t 2544 5113 1285
  t 327 5108 2545
  t 2545 5061 327
  t 1284 5111 2545
  t 2545 5108 1284
  t 638 5114 2545
  t 2545 5111 638
  t 1280 5061 2545
  t 2545 5114 1280
  t 324 5095 2546
  t 2546 5112 324
  t 1273 5116 2546
  t 2546 5095 1273
  t 639 5117 2546
  t 2546 5116 639
  t 1285 5112 2546
  t 2546 5117 1285
  t 325 5118 2547
  t 2547 5092 325
  t 1286 5119 2547
  t 2547 5118 1286
  t 639 5116 2547
  t 2547 5119 639
  t 1273 5092 2547
  t 2547 5116 1273
  t 329 5120 2548
  t 2548 5122 329
  t 1281 5121 2548
  t 2548 5120 1281
  t 639 5119 2548
  t 2548 5121 639
  t 1286 5122 2548
  t 2548 5119 1286
  t 328 5115 2549
  t 2549 5123 328
  t 1285 5117 2549
  t 2549 5115 1285
  t 639 5121 2549
  t 2549 5117 639
  t 1281 5123 2549
  t 2549 5121 1281
  t 325 5101 2550
  t 2550 5118 325
  t 1274 5124 2550
  t 2550 5101 1274
  t 640 5125 2550
  t 2550 5124 640
  t 1286 5118 2550
  t 2550 5125 1286
  t 322 5104 2551
  t 2551 5099 322
  t 1283 5126 2551
  t 2551 5104 1283
  t 640 5124 2551
  t 2551 5126 640
  t 1274 5099 2551
  t 2551 5124 1274
  t 326 5127 2552
  t 2552 5109 326
  t 1282 5128 2552
  t 2552 5127 1282
  t 640 5126 2552
  t 2552 5128 640
  t 1283 5109 2552
  t 2552 5126 1283
  t 329 5122 2553
  t 2553 5129 329
  t 1286 5125 2553
  t 2553 5122 1286
  t 640 5128 2553
  t 2553 5125 640
  t 1282 5129 2553
  t 2553 5128 1282
  t 267 4569 2554
  t 2554 4575 267
  t 1152 5130 2554
  t 2554 4569 1152
  t 641 5131 2554
  t 2554 5130 641
  t 1155 4575 2554
  t 2554 5131 1155
  t 266 4557 2555
  t 2555 4565 266
  t 1149 5132 2555
  t 2555 4557 1149
  t 641 5130 2555
  t 2555 5132 641
  t 1152 4565 2555
  t 2555 5130 1152
  t 264 4549 2556
  t 2556 4553 264
  t 1146 5133 2556
  t 2556 4549 1146
  t 641 5132 2556
  t 2556 5133 641
  t 1149 4553 2556
  t 2556 5132 1149
  t 261 4541 2557
  t 2557 4545 261
  t 1142 5134 2557
  t 2557 4541 1142
  t 641 5133 2557
  t 2557 5134 641
  t 1146 4545 2557
  t 2557 5133 1146
  t 262 3294 2558
  t 2558 4537 262
  t 824 5135 2558
  t 2558 3294 824
  t 641 5134 2558
  t 2558 5135 641
  t 1142 4537 2558
  t 2558 5134 1142
  t 89 3304 2559
  t 2559 3289 89
  t 825 5136 2559
  t 2559 3304 825
  t 641 5135 2559
  t 2559 5136 641
  t 824 3289 2559
  t 2559 5135 824
  t 90 3315 2560
  t 2560 3301 90
  t 826 5137 2560
  t 2560 3315 826
  t 641 5136 2560
  t 2560 5137 641
  t 825 3301 2560
  t 2560 5136 825
  t 91 3326 2561
  t 2561 3312 91
  t 827 5138 2561
  t 2561 3326 827
  t 641 5137 2561
  t 2561 5138 641
  t 826 3312 2561
  t 2561 5137 826
  t 92 3337 2562
  t 2562 3323 92
  t 941 5139 2562
  t 2562 3337 941
  t 641 5138 2562
  t 2562 5139 641
  t 827 3323 2562
  t 2562 5138 827
  t 268 4578 2563
  t 2563 3334 268
  t 1155 5131 2563
  t 2563 4578 1155
  t 641 5139 2563
  t 2563 5131 641
  t 941 3334 2563
  t 2563 5139 941
  t 143 5140 2564
  t 2564 3719 143
  t 1288 5141 2564
  t 2564 5140 1288
  t 642 5142 2564
  t 2564 5141 642
  t 1287 3719 2564
  t 2564 5142 1287
  t 313 3804 2565
  t 2565 5144 313
  t 695 5143 2565
  t 2565 3804 695
  t 642 5141 2565
  t 2565 5143 642
  t 1288 5144 2565
  t 2565 5141 1288
  t 24 2754 2566
  t 2566 3801 24
  t 696 5145 2566
  t 2566 2754 696
  t 642 5143 2566
  t 2566 5145 642
  t 695 3801 2566
  t 2566 5143 695
  t 18 3712 2567
  t 2567 2748 18
  t 1287 5142 2567
  t 2567 3712 1287
  t 642 5145 2567
  t 2567 5142 642
  t 696 2748 2567
  t 2567 5145 696
  t 143 5072 2568
  t 2568 5140 143
  t 930 5146 2568
  t 2568 5072 930
  t 643 5147 2568
  t 2568 5146 643
  t 1288 5140 2568
  t 2568 5147 1288
  t 316 4957 2569
  t 2569 5066 316
  t 1250 5148 2569
  t 2569 4957 1250
  t 643 5146 2569
  t 2569 5148 643
  t 930 5066 2569
  t 2569 5146 930
  t 313 5144 2570
  t 2570 4951 313
  t 1288 5147 2570
  t 2570 5144 1288
  t 643 5148 2570
  t 2570 5147 643
  t 1250 4951 2570
  t 2570 5148 1250
  t 315 5091 2571
  t 2571 5151 315
  t 1248 5149 2571
  t 2571 5091 1248
  t 644 5150 2571
  t 2571 5149 644
  t 1289 5151 2571
  t 2571 5150 1289
  t 160 3718 2572
  t 2572 5086 160
  t 1247 5152 2572
  t 2572 3718 1247
  t 644 5149 2572
  t 2572 5152 644
  t 1248 5086 2572
  t 2572 5149 1248
  t 314 5014 2573
  t 2573 3713 314
  t 1246 5153 2573
  t 2573 5014 1246
  t 644 5152 2573
  t 2573 5153 644
  t 1247 3713 2573
  t 2573 5152 1247
  t 189 5154 2574
  t 2574 5017 189
  t 1289 5150 2574
  t 2574 5154 1289
  t 644 5153 2574
  t 2574 5150 644
  t 1246 5017 2574
  t 2574 5153 1246
  t 315 5151 2575
  t 2575 4958 315
  t 1289 5155 2575
  t 2575 5151 1289
  t 645 5156 2575
  t 2575 5155 645
  t 1290 4958 2575
  t 2575 5156 1290
  t 189 4013 2576
  t 2576 5154 189
  t 1006 5157 2576
  t 2576 4013 1006
  t 645 5155 2576
  t 2576 5157 645
  t 1289 5154 2576
  t 2576 5155 1289
  t 190 5023 2577
  t 2577 4020 190
  t 1245 5158 2577
  t 2577 5023 1245
  t 645 5157 2577
  t 2577 5158 645
  t 1006 4020 2577
  t 2577 5157 1006
  t 313 4954 2578
  t 2578 5020 313
  t 1290 5156 2578
  t 2578 4954 1290
  t 645 5158 2578
  t 2578 5156 645
  t 1245 5020 2578
  t 2578 5158 1245
  t 328 5123 2579
  t 2579 5064 328
  t 1281 5159 2579
  t 2579 5123 1281
  t 646 5160 2579
  t 2579 5159 646
  t 1291 5064 2579
  t 2579 5160 1291
  t 329 5129 2580
  t 2580 5120 329
  t 1282 5161 2580
  t 2580 5129 1282
  t 646 5159 2580
  t 2580 5161 646
  t 1281 5120 2580
  t 2580 5159 1281
  t 326 5060 2581
  t 2581 5127 326
  t 1291 5160 2581
  t 2581 5060 1291
  t 646 5161 2581
  t 2581 5160 646
  t 1282 5127 2581
  t 2581 5161 1282
}

object {
  shader 7---Default
  type mesh
  name Cylinder01
  962 1920
  v -24.7513 -36.0906 74.8409    0.42635 0.739381 -0.521095    0 0
  v -23.5706 -36.0906 77.9637    0.664456 0.739382 0.108683    0 0
  v -25.6848 -36.0906 80.5477    0.238105 0.739383 0.629776    0 0
  v -28.9796 -36.0906 80.0088    -0.42635 0.739381 0.521095    0 0
  v -30.1603 -36.0906 76.8859    -0.664456 0.739382 -0.108683    0 0
  v -28.0462 -36.0906 74.3019    -0.238104 0.739385 -0.629774    0 0
  v -24.3793 -39.2648 74.3862    0.617766 -0.219712 -0.755044    0 0
  v -22.9909 -39.2648 78.0586    0.962771 -0.219712 0.157477    0 0
  v -25.477 -39.2648 81.0972    0.345009 -0.219709 0.912522    0 0
  v -29.3516 -39.2648 80.4634    -0.617764 -0.219715 0.755045    0 0
  v -30.74 -39.2648 76.7911    -0.962771 -0.219713 -0.157477    0 0
  v -28.2539 -39.2648 73.7524    -0.345008 -0.219713 -0.912521    0 0
  v -25.2838 -41.2221 75.4917    0.235033 -0.928569 -0.287261    0 0
  v -24.4005 -41.2221 77.828    0.366293 -0.928569 0.0599128    0 0
  v -25.9822 -41.2221 79.7611    0.131257 -0.928569 0.347175    0 0
  v -28.4471 -41.2221 79.3579    -0.235035 -0.928568 0.287263    0 0
  v -29.3304 -41.2221 77.0216    -0.366293 -0.928569 -0.0599124    0 0
  v -27.7488 -41.2221 75.0885    -0.131261 -0.928568 -0.347176    0 0
  v -26.8655 -35.1529 77.4248    -6.24108e-010 1 6.24108e-010    0 0
  v -23.1428 -37.3703 76.0174    0.91684 0.198106 -0.346639    0 0
  v -23.7853 -37.3703 79.945    0.758617 0.198107 0.620688    0 0
  v -27.5079 -37.3703 81.3524    -0.158224 0.198103 0.967326    0 0
  v -30.5881 -37.3703 78.8323    -0.91684 0.198105 0.346639    0 0
  v -29.9456 -37.3703 74.9047    -0.758617 0.198108 -0.620688    0 0
  v -26.223 -37.3703 73.4972    0.158224 0.198104 -0.967326    0 0
  v -26.8655 -41.6039 77.4248    1.4927e-008 -1 8.62965e-009    0 0
  v -23.7693 -40.6219 76.2542    0.71741 -0.641679 -0.27124    0 0
  v -24.3036 -40.6219 79.5209    0.593605 -0.64168 0.485676    0 0
  v -27.3998 -40.6219 80.6915    -0.123806 -0.641678 0.756916    0 0
  v -29.9617 -40.6219 78.5954    -0.717409 -0.64168 0.271239    0 0
  v -29.4273 -40.6219 75.3287    -0.593606 -0.641677 -0.485678    0 0
  v -26.3311 -40.6219 74.1581    0.123804 -0.64168 -0.756914    0 0
  v -24.1209 -35.808 76.3871    0.497668 0.846713 -0.188158    0 0
  v -24.5945 -35.808 79.2829    0.411784 0.846713 0.336914    0 0
  v -27.3391 -35.808 80.3205    -0.085884 0.846711 0.525075    0 0
  v -29.61 -35.808 78.4625    -0.497668 0.846713 0.188159    0 0
  v -29.1364 -35.808 75.5668    -0.411783 0.846713 -0.336913    0 0
  v -26.3918 -35.808 74.5291    0.0858838 0.846712 -0.525074    0 0
  v -23.2095 -39.2648 76.0426    0.912718 -0.218779 -0.345081    0 0
  v -24.3204 -37.3979 74.3142    0.623227 0.177093 -0.761726    0 0
  v -22.8991 -37.3979 78.0736    0.971287 0.177093 0.15887    0 0
  v -23.8404 -39.2648 79.8998    0.755208 -0.218777 0.617898    0 0
  v -25.4441 -37.3979 81.1842    0.348056 0.177091 0.920595    0 0
  v -27.4964 -39.2648 81.2821    -0.157515 -0.218783 0.962976    0 0
  v -29.4105 -37.3979 80.5354    -0.623228 0.177094 0.761725    0 0
  v -30.5214 -39.2648 78.8071    -0.912718 -0.218779 0.345081    0 0
  v -30.8318 -37.3979 76.7761    -0.971287 0.177093 -0.15887    0 0
  v -29.8905 -39.2648 74.9498    -0.755207 -0.218779 -0.617898    0 0
  v -28.2868 -37.3979 73.6655    -0.348054 0.177092 -0.920596    0 0
  v -26.2345 -39.2648 73.5676    0.157511 -0.218783 -0.962977    0 0
  v -24.8596 -41.3372 76.6665    0.272576 -0.956599 -0.103056    0 0
  v -25.2058 -41.3372 78.7827    0.225537 -0.956599 0.18453    0 0
  v -27.2116 -41.3372 79.5411    -0.0470402 -0.956599 0.287587    0 0
  v -28.8713 -41.3372 78.1832    -0.272576 -0.956599 0.103056    0 0
  v -28.5251 -41.3372 76.0669    -0.225537 -0.956599 -0.184531    0 0
  v -26.5193 -41.3372 75.3085    0.0470397 -0.956599 -0.287587    0 0
  v -23.5607 -40.6106 77.9654    0.769596 -0.626 0.12588    0 0
  v -24.745 -40.6106 74.8331    0.493812 -0.626002 -0.60355    0 0
  v -25.6812 -40.6106 80.5571    0.275782 -0.626003 0.729428    0 0
  v -28.986 -40.6106 80.0165    -0.493813 -0.626002 0.603548    0 0
  v -30.1702 -40.6106 76.8843    -0.769596 -0.626 -0.12588    0 0
  v -28.0497 -40.6106 74.2926    -0.275784 -0.625999 -0.72943    0 0
  v -27.6806 -35.5162 75.2689    -0.113934 0.946682 -0.301351    0 0
  v -29.1401 -35.5162 77.0528    -0.317944 0.946682 -0.0520049    0 0
  v -28.325 -35.5162 79.2087    -0.20401 0.946682 0.249345    0 0
  v -26.0503 -35.5162 79.5807    0.113934 0.946682 0.301351    0 0
  v -24.5908 -35.5162 77.7969    0.317944 0.946682 0.0520051    0 0
  v -25.4059 -35.5162 75.641    0.20401 0.946682 -0.249345    0 0
  v -23.8921 -36.5415 75.2417    0.708667 0.515934 -0.481252    0 0
  v -23.1915 -36.5415 77.0947    0.849796 0.515936 -0.107969    0 0
  v -22.8369 -38.3392 77.0276    0.992263 -0.0542406 -0.111679    0 0
  v -23.5818 -38.3392 75.0575    0.81795 -0.0542394 -0.572726    0 0
  v -23.4881 -36.5415 78.9083    0.771109 0.515937 0.373096    0 0
  v -24.7426 -36.5415 80.4415    0.518404 0.515936 0.681958    0 0
  v -24.5071 -38.3392 80.715    0.592848 -0.0542374 0.803486    0 0
  v -23.1734 -38.3392 79.0849    0.90497 -0.0542426 0.422003    0 0
  v -26.4615 -36.5415 81.0914    0.0624424 0.515938 0.854347    0 0
  v -28.4166 -36.5415 80.7716    -0.331391 0.515937 0.78993    0 0
  v -28.5357 -38.3392 81.1123    -0.399415 -0.054237 0.915165    0 0
  v -26.4571 -38.3392 81.4523    0.0870171 -0.0542368 0.994729    0 0
  v -29.8388 -36.5415 79.6079    -0.708667 0.515934 0.481252    0 0
  v -30.5394 -36.5415 77.7549    -0.849796 0.515936 0.107969    0 0
  v -30.894 -38.3392 77.8221    -0.992263 -0.0542406 0.111679    0 0
  v -30.1491 -38.3392 79.7922    -0.817951 -0.0542398 0.572725    0 0
  v -30.2428 -36.5415 75.9414    -0.77111 0.515936 -0.373095    0 0
  v -28.9883 -36.5415 74.4081    -0.518404 0.515934 -0.68196    0 0
  v -29.2238 -38.3392 74.1346    -0.592849 -0.054239 -0.803485    0 0
  v -30.5575 -38.3392 75.7647    -0.904971 -0.05424 -0.422002    0 0
  v -27.2694 -36.5415 73.7582    -0.062444 0.515938 -0.854347    0 0
  v -25.3144 -36.5415 74.078    0.331393 0.515937 -0.789929    0 0
  v -25.1952 -38.3392 73.7374    0.399415 -0.0542374 -0.915165    0 0
  v -27.2738 -38.3392 73.3974    -0.0870172 -0.0542368 -0.994729    0 0
  v -27.449 -41.456 75.8814    -0.063447 -0.983775 -0.167814    0 0
  v -25.8206 -41.456 76.1478    0.113608 -0.983775 -0.138854    0 0
  v -25.2371 -41.456 77.6912    0.177055 -0.983775 0.0289601    0 0
  v -26.2819 -41.456 78.9682    0.0634471 -0.983775 0.167814    0 0
  v -27.9103 -41.456 78.7018    -0.113608 -0.983775 0.138853    0 0
  v -28.4938 -41.456 77.1585    -0.177055 -0.983775 -0.0289602    0 0
  v -23.8833 -40.0294 75.2747    0.750918 -0.399224 -0.526063    0 0
  v -23.2068 -40.0294 77.0641    0.911125 -0.399226 -0.102323    0 0
  v -24.015 -41.0305 77.1737    0.53584 -0.841454 -0.0694958    0 0
  v -24.5618 -41.0305 75.7273    0.447787 -0.841454 -0.302392    0 0
  v -23.5124 -40.0294 78.9324    0.831042 -0.399226 0.387282    0 0
  v -24.7238 -40.0294 80.413    0.544176 -0.399227 0.737896    0 0
  v -25.2227 -41.0305 79.7678    0.328108 -0.841455 0.429301    0 0
  v -24.2436 -41.0305 78.5711    0.485774 -0.841454 0.236598    0 0
  v -26.4945 -40.0294 81.0825    0.0801224 -0.399227 0.913345    0 0
  v -28.3824 -40.0294 80.7737    -0.366949 -0.399226 0.840218    0 0
  v -28.0732 -41.0305 80.019    -0.207736 -0.841453 0.498801    0 0
  v -26.5472 -41.0305 80.2686    0.0379842 -0.841452 0.538994    0 0
  v -29.8476 -40.0294 79.5749    -0.750917 -0.399225 0.526063    0 0
  v -30.5241 -40.0294 77.7855    -0.911125 -0.399225 0.102323    0 0
  v -29.7159 -41.0305 77.676    -0.53584 -0.841454 0.0694956    0 0
  v -29.1691 -41.0305 79.1223    -0.447788 -0.841454 0.302394    0 0
  v -30.2185 -40.0294 75.9173    -0.831042 -0.399225 -0.387284    0 0
  v -29.0071 -40.0294 74.4367    -0.544177 -0.399228 -0.737895    0 0
  v -28.5082 -41.0305 75.0818    -0.328106 -0.841454 -0.429304    0 0
  v -29.4873 -41.0305 76.2786    -0.485774 -0.841454 -0.236598    0 0
  v -27.2364 -40.0294 73.7672    -0.0801231 -0.399225 -0.913345    0 0
  v -25.3485 -40.0294 74.076    0.366947 -0.399227 -0.840219    0 0
  v -25.6577 -41.0305 74.8307    0.207737 -0.841452 -0.498802    0 0
  v -27.1837 -41.0305 74.5811    -0.0379857 -0.841455 -0.538991    0 0
  v -28.5222 -35.9011 74.8046    -0.328279 0.815602 -0.476473    0 0
  v -28.2547 -35.378 76.2882    -0.180521 0.972418 -0.147699    0 0
  v -26.5757 -35.378 75.6534    0.0376502 0.972418 -0.230185    0 0
  v -27.3566 -35.9011 74.3639    -0.0690631 0.815601 -0.574478    0 0
  v -29.963 -35.9011 77.5495    -0.576778 0.815602 0.0460621    0 0
  v -28.5444 -35.378 78.0596    -0.218171 0.972418 0.082486    0 0
  v -29.7619 -35.9011 76.3197    -0.532044 0.815602 -0.227427    0 0
  v -28.3063 -35.9011 80.1697    -0.248497 0.8156 0.522537    0 0
  v -27.1552 -35.378 79.1962    -0.0376502 0.972418 0.230184    0 0
  v -29.2707 -35.9011 79.3806    -0.462981 0.815602 0.347049    0 0
  v -25.2087 -35.9011 80.045    0.32828 0.815601 0.476474    0 0
  v -25.4763 -35.378 78.5614    0.180521 0.972418 0.147698    0 0
  v -26.3743 -35.9011 80.4857    0.0690634 0.8156 0.574479    0 0
  v -23.7679 -35.9011 77.3002    0.576778 0.815602 -0.0460621    0 0
  v -25.1865 -35.378 76.79    0.218171 0.972418 -0.082486    0 0
  v -23.969 -35.9011 78.5299    0.532044 0.815601 0.227429    0 0
  v -25.4246 -35.9011 74.6799    0.248499 0.815601 -0.522536    0 0
  v -24.4602 -35.9011 75.469    0.462979 0.815602 -0.347049    0 0
  v -23.4629 -36.4952 76.1384    0.787352 0.539872 -0.297683    0 0
  v -23.6253 -37.3841 75.0824    0.80881 0.187841 -0.557264    0 0
  v -24.4937 -36.5948 74.526    0.552744 0.487921 -0.675579    0 0
  v -23.1692 -36.5948 78.0294    0.861441 0.48792 0.140903    0 0
  v -22.886 -37.3841 77.0377    0.975179 0.187841 -0.117226    0 0
  v -22.9683 -39.2648 77.0399    0.969773 -0.219167 -0.10727    0 0
  v -23.0873 -38.3378 75.9964    0.934196 -0.0502736 -0.353201    0 0
  v -22.8592 -38.3406 78.0801    0.985205 -0.0583301 0.161147    0 0
  v -24.2948 -38.3406 74.283    0.632159 -0.05833 -0.77264    0 0
  v -23.6885 -39.2648 75.1351    0.798168 -0.219169 -0.561154    0 0
  v -24.0501 -36.4952 79.7283    0.651476 0.539872 0.533027    0 0
  v -23.2167 -37.3841 79.0596    0.88701 0.18784 0.421817    0 0
  v -25.5409 -36.5948 80.9282    0.308695 0.48792 0.816481    0 0
  v -24.5405 -37.3841 80.6776    0.589111 0.18784 0.785916    0 0
  v -24.5836 -39.2648 80.6074    0.577784 -0.219168 0.786213    0 0
  v -23.7393 -38.3378 79.9826    0.772979 -0.0502756 0.632436    0 0
  v -25.4298 -38.3406 81.222    0.353048 -0.0583283 0.933785    0 0
  v -23.294 -39.2648 79.0313    0.885058 -0.219166 0.410657    0 0
  v -27.4527 -36.4952 81.0148    -0.135877 0.539875 0.830706    0 0
  v -26.4569 -37.3841 81.4021    0.0782025 0.18784 0.979081    0 0
  v -29.2372 -36.5948 80.3236    -0.552745 0.48792 0.675579    0 0
  v -28.5199 -37.3841 81.0647    -0.386069 0.18784 0.903143    0 0
  v -28.4807 -39.2648 80.9923    -0.391988 -0.219167 0.893482    0 0
  v -27.5175 -38.3378 81.411    -0.161216 -0.0502693 0.985638    0 0
  v -29.4361 -38.3406 80.5667    -0.632159 -0.0583302 0.77264    0 0
  v -26.471 -39.2648 81.321    0.0868881 -0.21917 0.97181    0 0
  v -30.268 -36.4952 78.7113    -0.787352 0.539872 0.297683    0 0
  v -30.1056 -37.3841 79.7673    -0.808809 0.187842 0.557264    0 0
  v -30.5618 -36.5948 76.8202    -0.861441 0.48792 -0.140903    0 0
  v -30.8449 -37.3841 77.8119    -0.975179 0.187841 0.117226    0 0
  v -30.7626 -39.2648 77.8097    -0.969773 -0.219167 0.10727    0 0
  v -30.6436 -38.3378 78.8533    -0.934196 -0.0502727 0.353201    0 0
  v -30.8717 -38.3406 76.7695    -0.985205 -0.0583293 -0.161148    0 0
  v -30.0424 -39.2648 79.7145    -0.798168 -0.219168 0.561153    0 0
  v -29.6808 -36.4952 75.1213    -0.651476 0.539872 -0.533027    0 0
  v -30.5142 -37.3841 75.79    -0.88701 0.187841 -0.421817    0 0
  v -28.19 -36.5948 73.9214    -0.308695 0.487918 -0.816482    0 0
  v -29.1904 -37.3841 74.1721    -0.589112 0.187842 -0.785915    0 0
  v -29.1473 -39.2648 74.2422    -0.577784 -0.219168 -0.786213    0 0
  v -29.9916 -38.3378 74.8671    -0.772979 -0.0502745 -0.632437    0 0
  v -28.3011 -38.3406 73.6277    -0.353047 -0.0583262 -0.933786    0 0
  v -30.4369 -39.2648 75.8183    -0.885057 -0.219169 -0.410656    0 0
  v -26.2783 -36.4952 73.8349    0.135877 0.539874 -0.830706    0 0
  v -27.274 -37.3841 73.4475    -0.078203 0.187841 -0.979081    0 0
  v -25.211 -37.3841 73.785    0.38607 0.18784 -0.903142    0 0
  v -25.2502 -39.2648 73.8574    0.391989 -0.219166 -0.893483    0 0
  v -26.2134 -38.3378 73.4386    0.161216 -0.0502695 -0.985638    0 0
  v -27.2599 -39.2648 73.5286    -0.0868881 -0.21917 -0.97181    0 0
  v -27.2316 -41.2992 75.171    -0.037997 -0.948624 -0.314115    0 0
  v -26.6599 -41.5123 76.1683    0.0213328 -0.991229 -0.130426    0 0
  v -27.8509 -41.5123 76.6185    -0.102286 -0.991228 -0.0836888    0 0
  v -28.082 -41.2992 75.4926    -0.179323 -0.948624 -0.260682    0 0
  v -25.0966 -41.2992 75.9809    0.253032 -0.948624 -0.189964    0 0
  v -25.6745 -41.5123 76.9745    0.12362 -0.991228 -0.0467378    0 0
  v -25.8004 -41.2992 75.4051    0.136096 -0.948625 -0.285638    0 0
  v -24.7305 -41.2992 78.2347    0.29103 -0.948624 0.12415    0 0
  v -25.88 -41.5123 78.2311    0.102286 -0.991228 0.0836888    0 0
  v -24.5838 -41.2992 77.3374    0.315418 -0.948624 -0.0249564    0 0
  v -26.4994 -41.2992 79.6786    0.0379984 -0.948624 0.314114    0 0
  v -27.071 -41.5123 78.6814    -0.0213331 -0.991228 0.130427    0 0
  v -25.6489 -41.2992 79.3571    0.179323 -0.948624 0.260682    0 0
  v -28.6343 -41.2992 78.8688    -0.253032 -0.948625 0.189962    0 0
  v -28.0564 -41.5123 77.8751    -0.12362 -0.991228 0.0467383    0 0
  v -27.9306 -41.2992 79.4445    -0.136095 -0.948625 0.285638    0 0
  v -29.0004 -41.2992 76.615    -0.291029 -0.948624 -0.124151    0 0
  v -29.1471 -41.2992 77.5123    -0.315419 -0.948624 0.0249566    0 0
  v -23.4344 -40.03 76.1276    0.856409 -0.402148 -0.323791    0 0
  v -24.1691 -40.6162 75.4735    0.636979 -0.633955 -0.438588    0 0
  v -24.5307 -40.0289 74.5713    0.581339 -0.396485 -0.710524    0 0
  v -23.2268 -40.0289 78.02    0.906002 -0.396485 0.148192    0 0
  v -23.5526 -40.6162 77.1042    0.767815 -0.633954 -0.0925343    0 0
  v -24.2359 -41.0494 76.4306    0.491306 -0.850949 -0.185754    0 0
  v -23.9862 -41.0088 77.8958    0.550768 -0.829782 0.0900872    0 0
  v -25.018 -41.0088 75.1668    0.353401 -0.829781 -0.431939    0 0
  v -24.0265 -40.03 79.7476    0.708614 -0.40215 0.579776    0 0
  v -23.8274 -40.6162 78.7843    0.698319 -0.633954 0.332345    0 0
  v -25.5616 -40.0289 80.8735    0.324665 -0.396489 0.858714    0 0
  v -24.9313 -40.6162 80.1335    0.464043 -0.633955 0.618681    0 0
  v -24.6897 -41.0494 79.205    0.40652 -0.850948 0.332608    0 0
  v -25.8337 -41.0088 80.1538    0.197367 -0.82978 0.522026    0 0
  v -27.4576 -40.03 81.0448    -0.147794 -0.40215 0.903567    0 0
  v -26.5238 -40.6162 80.7356    0.0613404 -0.633956 0.770932    0 0
  v -29.2002 -40.0289 80.2784    -0.58134 -0.396483 0.710525    0 0
  v -28.2442 -40.6162 80.4542    -0.303768 -0.633956 0.711213    0 0
  v -27.3193 -41.0494 80.1992    -0.0847857 -0.850949 0.51836    0 0
  v -28.7129 -41.0088 79.6829    -0.353402 -0.829782 0.431937    0 0
  v -30.2965 -40.03 78.722    -0.856409 -0.402148 0.323791    0 0
  v -29.5618 -40.6162 79.3761    -0.636978 -0.633956 0.438589    0 0
  v -30.5041 -40.0289 76.8297    -0.906002 -0.396484 -0.148191    0 0
  v -30.1783 -40.6162 77.7455    -0.767814 -0.633955 0.0925328    0 0
  v -29.495 -41.0494 78.419    -0.491307 -0.850948 0.185753    0 0
  v -29.7447 -41.0088 76.9539    -0.550769 -0.829782 -0.0900879    0 0
  v -29.7044 -40.03 75.102    -0.708614 -0.40215 -0.579777    0 0
  v -29.9035 -40.6162 76.0654    -0.698319 -0.633954 -0.332344    0 0
  v -28.1693 -40.0289 73.9761    -0.324666 -0.396488 -0.858714    0 0
  v -28.7996 -40.6162 74.7161    -0.464042 -0.633954 -0.618681    0 0
  v -29.0413 -41.0494 75.6446    -0.406519 -0.850949 -0.332607    0 0
  v -27.8972 -41.0088 74.6958    -0.197368 -0.829782 -0.522023    0 0
  v -26.2733 -40.03 73.8048    0.147796 -0.402145 -0.903568    0 0
  v -27.2072 -40.6162 74.114    -0.0613408 -0.633953 -0.770935    0 0
  v -25.4867 -40.6162 74.3954    0.303771 -0.633956 -0.711212    0 0
  v -26.4117 -41.0494 74.6504    0.0847857 -0.850949 -0.51836    0 0
  v -27.9145 -35.8083 74.6503    -0.181885 0.857601 -0.481081    0 0
  v -28.4209 -35.5931 75.4601    -0.243088 0.924646 -0.293153    0 0
  v -27.3467 -35.2918 76.152    -0.0600556 0.985476 -0.158844    0 0
  v -26.9989 -35.5931 74.9224    -0.011666 0.924645 -0.38065    0 0
  v -29.7928 -35.8083 76.946    -0.507573 0.8576 -0.0830206    0 0
  v -29.3447 -35.5931 77.7895    -0.375423 0.924645 0.063942    0 0
  v -28.2084 -35.2918 77.2052    -0.167591 0.985476 -0.0274121    0 0
  v -29.0993 -35.5931 76.2892    -0.335485 0.924645 -0.180224    0 0
  v -28.7438 -35.8083 79.7206    -0.325685 0.8576 0.398059    0 0
  v -27.7892 -35.5931 79.7543    -0.132338 0.924645 0.357097    0 0
  v -27.7271 -35.2918 78.478    -0.107535 0.985475 0.131432    0 0
  v -28.9659 -35.5931 78.7916    -0.323821 0.924645 0.200428    0 0
  v -25.8165 -35.8083 80.1994    0.181888 0.857599 0.481083    0 0
  v -25.31 -35.5931 79.3896    0.243088 0.924645 0.293155    0 0
  v -26.3842 -35.2918 78.6977    0.0600556 0.985476 0.158844    0 0
  v -26.732 -35.5931 79.9272    0.0116665 0.924645 0.380651    0 0
  v -23.9381 -35.8083 77.9036    0.507573 0.8576 0.0830219    0 0
  v -24.3862 -35.5931 77.0601    0.375423 0.924645 -0.0639421    0 0
  v -25.5225 -35.2918 77.6445    0.167591 0.985476 0.0274123    0 0
  v -24.6316 -35.5931 78.5604    0.335486 0.924645 0.180224    0 0
  v -24.9871 -35.8083 75.1291    0.325686 0.8576 -0.398058    0 0
  v -25.9417 -35.5931 75.0954    0.132337 0.924645 -0.357097    0 0
  v -26.0038 -35.2918 76.3716    0.107535 0.985475 -0.131432    0 0
  v -24.7651 -35.5931 76.0581    0.323821 0.924645 -0.200428    0 0
  v -24.3553 -36.2542 74.9841    0.55785 0.65372 -0.511325    0 0
  v -23.9291 -36.1433 75.7837    0.631811 0.701763 -0.329154    0 0
  v -23.4711 -36.924 75.5908    0.829891 0.357773 -0.428111    0 0
  v -24.0321 -36.9609 74.7467    0.699678 0.33402 -0.631571    0 0
  v -23.3684 -36.2542 77.5943    0.756602 0.653718 0.0143563    0 0
  v -22.969 -36.9609 77.5585    0.942505 0.334021 0.0106965    0 0
  v -23.1067 -36.924 76.5544    0.905541 0.357773 -0.228021    0 0
  v -23.5779 -36.1433 76.7128    0.691539 0.701764 -0.171177    0 0
  v -22.8616 -38.8151 77.5536    0.989478 -0.143043 0.0217419    0 0
  v -22.9766 -38.8151 76.5154    0.962207 -0.141145 -0.232888    0 0
  v -22.9285 -37.8523 76.5059    0.969464 0.0579877 -0.238278    0 0
  v -22.8068 -37.8597 77.557    0.998712 0.0473231 0.0182805    0 0
  v -23.9483 -38.8151 74.6794    0.727593 -0.143043 -0.67093    0 0
  v -23.9095 -37.8597 74.6405    0.736808 0.0473215 -0.674444    0 0
  v -23.3053 -37.8523 75.5093    0.88461 0.0579868 -0.462712    0 0
  v -23.3476 -38.8151 75.5339    0.875602 -0.141145 -0.461952    0 0
  v -23.4966 -36.2542 78.3783    0.721747 0.653718 0.227452    0 0
  v -23.9761 -36.1433 79.1472    0.600961 0.701764 0.382587    0 0
  v -23.5799 -36.924 79.4474    0.785701 0.357773 0.504651    0 0
  v -23.1295 -36.9609 78.5396    0.896796 0.33402 0.290151    0 0
  v -25.2637 -36.2542 80.5381    0.365865 0.65372 0.662415    0 0
  v -25.033 -36.9609 80.8661    0.461989 0.334023 0.82158    0 0
  v -24.2323 -36.924 80.2448    0.650242 0.357772 0.670212    0 0
  v -24.605 -36.1433 79.9159    0.494013 0.701764 0.513302    0 0
  v -24.975 -38.8151 80.9566    0.475908 -0.143044 0.867785    0 0
  v -24.1334 -38.8151 80.338    0.68279 -0.141145 0.716851    0 0
  v -24.1012 -37.8523 80.3748    0.691084 0.0579887 0.720444    0 0
  v -24.9506 -37.8597 81.0058    0.483527 0.0473214 0.87405    0 0
  v -23.0292 -38.8151 78.5784    0.944839 -0.143042 0.294648    0 0
  v -22.9762 -37.8597 78.5926    0.95249 0.0473233 0.30087    0 0
  v -23.4265 -37.8523 79.5502    0.843025 0.0579872 0.534739    0 0
  v -23.469 -38.8151 79.5259    0.837863 -0.141144 0.527318    0 0
  v -26.0068 -36.2542 80.8191    0.163896 0.65372 0.738774    0 0
  v -26.9124 -36.1433 80.7883    -0.0308489 0.701763 0.711742    0 0
  v -26.9743 -36.924 81.2815    -0.0441892 0.357775 0.932762    0 0
  v -25.9629 -36.9609 81.2177    0.197119 0.334019 0.921724    0 0
  v -28.7608 -36.2542 80.3686    -0.390734 0.653719 0.648057    0 0
  v -28.9294 -36.9609 80.7324    -0.480515 0.334019 0.810886    0 0
  v -27.991 -36.924 81.1152    -0.2553 0.357775 0.898231    0 0
  v -27.8926 -36.1433 80.628    -0.197525 0.701762 0.68448    0 0
  v -28.9789 -38.8151 80.8279    -0.513568 -0.143044 0.846042    0 0
  v -28.0223 -38.8151 81.2474    -0.279417 -0.141147 0.949739    0 0
  v -28.0381 -37.8523 81.2938    -0.278381 0.0579863 0.958719    0 0
  v -29.0093 -37.8597 80.8736    -0.515185 0.0473232 0.855772    0 0
  v -25.9464 -38.8151 81.3239    0.21725 -0.143044 0.965578    0 0
  v -25.9322 -37.8597 81.3769    0.215683 0.0473266 0.975316    0 0
  v -26.9866 -37.8523 81.4658    -0.041585 0.0579842 0.997451    0 0
  v -26.9868 -38.8151 81.4168    -0.0377404 -0.141144 0.989269    0 0
  v -29.3756 -36.2542 79.8656    -0.55785 0.65372 0.511325    0 0
  v -29.8018 -36.1433 79.0659    -0.631812 0.701763 0.329154    0 0
  v -30.2598 -36.924 79.2589    -0.829891 0.357774 0.428111    0 0
  v -29.6989 -36.9609 80.1029    -0.699678 0.33402 0.631571    0 0
  v -30.3625 -36.2542 77.2553    -0.756602 0.653718 -0.0143563    0 0
  v -30.7619 -36.9609 77.2912    -0.942505 0.334021 -0.0106965    0 0
  v -30.6242 -36.924 78.2952    -0.905541 0.357773 0.228021    0 0
  v -30.153 -36.1433 78.1369    -0.691539 0.701764 0.171177    0 0
  v -30.8693 -38.8151 77.2961    -0.989478 -0.143043 -0.0217419    0 0
  v -30.7543 -38.8151 78.3343    -0.962207 -0.141145 0.232888    0 0
  v -30.8024 -37.8523 78.3438    -0.969464 0.0579877 0.238279    0 0
  v -30.9241 -37.8597 77.2926    -0.998712 0.0473231 -0.0182808    0 0
  v -29.7826 -38.8151 80.1703    -0.727593 -0.143044 0.67093    0 0
  v -29.8214 -37.8597 80.2091    -0.736808 0.0473218 0.674444    0 0
  v -30.4256 -37.8523 79.3403    -0.884611 0.0579864 0.46271    0 0
  v -30.3833 -38.8151 79.3157    -0.875602 -0.141145 0.461952    0 0
  v -30.2343 -36.2542 76.4713    -0.721747 0.653717 -0.227451    0 0
  v -29.7548 -36.1433 75.7024    -0.600961 0.701765 -0.382587    0 0
  v -30.151 -36.924 75.4022    -0.785701 0.357773 -0.504651    0 0
  v -30.6014 -36.9609 76.3101    -0.896796 0.33402 -0.290151    0 0
  v -28.4672 -36.2542 74.3115    -0.365868 0.653718 -0.662415    0 0
  v -28.6979 -36.9609 73.9836    -0.461992 0.334022 -0.82158    0 0
  v -29.4986 -36.924 74.6049    -0.650242 0.357771 -0.670213    0 0
  v -29.1259 -36.1433 74.9337    -0.494014 0.701764 -0.5133    0 0
  v -28.7559 -38.8151 73.893    -0.475911 -0.143044 -0.867783    0 0
  v -29.5975 -38.8151 74.5117    -0.68279 -0.141145 -0.716851    0 0
  v -29.6298 -37.8523 74.4748    -0.691085 0.0579888 -0.720444    0 0
  v -28.7803 -37.8597 73.8438    -0.483526 0.0473217 -0.87405    0 0
  v -30.7017 -38.8151 76.2712    -0.94484 -0.143042 -0.294647    0 0
  v -30.7547 -37.8597 76.257    -0.95249 0.0473234 -0.30087    0 0
  v -30.3044 -37.8523 75.2994    -0.843025 0.0579873 -0.534739    0 0
  v -30.2619 -38.8151 75.3237    -0.837862 -0.141144 -0.527319    0 0
  v -27.7241 -36.2542 74.0306    -0.163891 0.65372 -0.738776    0 0
  v -26.8185 -36.1433 74.0614    0.0308488 0.701764 -0.711741    0 0
  v -26.7566 -36.924 73.5682    0.0441888 0.357774 -0.932762    0 0
  v -27.768 -36.9609 73.632    -0.197117 0.334017 -0.921725    0 0
  v -24.9701 -36.2542 74.481    0.390735 0.653718 -0.648058    0 0
  v -24.8015 -36.9609 74.1172    0.480515 0.334019 -0.810886    0 0
  v -25.7399 -36.924 73.7345    0.2553 0.357774 -0.898231    0 0
  v -25.8383 -36.1433 74.2217    0.197525 0.701763 -0.684479    0 0
  v -24.752 -38.8151 74.0218    0.513569 -0.143042 -0.846041    0 0
  v -25.7086 -38.8151 73.6022    0.279417 -0.141143 -0.949739    0 0
  v -25.6928 -37.8523 73.5559    0.278379 0.0579883 -0.958719    0 0
  v -24.7217 -37.8597 73.976    0.515187 0.047325 -0.85577    0 0
  v -27.7845 -38.8151 73.5257    -0.217246 -0.143044 -0.965579    0 0
  v -27.7987 -37.8597 73.4727    -0.215683 0.0473268 -0.975316    0 0
  v -26.7443 -37.8523 73.3839    0.0415851 0.0579844 -0.997451    0 0
  v -26.7441 -38.8151 73.4328    0.0377385 -0.141142 -0.98927    0 0
  v -27.6328 -41.337 75.3953    -0.099322 -0.959753 -0.262698    0 0
  v -26.9633 -41.4247 75.6245    -0.00635339 -0.97753 -0.210702    0 0
  v -27.2053 -41.5474 76.526    -0.034344 -0.995273 -0.0908385    0 0
  v -27.9832 -41.4247 76.0101    -0.134634 -0.97753 -0.162202    0 0
  v -25.4915 -41.337 75.7455    0.177843 -0.959753 -0.217364    0 0
  v -25.3553 -41.4247 76.4399    0.179297 -0.97753 -0.110854    0 0
  v -26.257 -41.5474 76.6811    0.0614962 -0.995273 -0.0751622    0 0
  v -26.1991 -41.4247 75.7495    0.0731544 -0.97753 -0.197698    0 0
  v -24.7242 -41.337 77.7751    0.277165 -0.959752 0.0453346    0 0
  v -25.2574 -41.4247 78.2403    0.18565 -0.97753 0.0998486    0 0
  v -25.9172 -41.5474 77.5799    0.0958406 -0.995273 0.0156763    0 0
  v -25.0814 -41.4247 77.1642    0.207788 -0.97753 -0.0354952    0 0
  v -26.0981 -41.337 79.4543    0.0993202 -0.959752 0.2627    0 0
  v -26.7676 -41.4247 79.2251    0.00635385 -0.97753 0.210702    0 0
  v -26.5256 -41.5474 78.3236    0.034344 -0.995273 0.0908384    0 0
  v -25.7477 -41.4247 78.8395    0.134634 -0.97753 0.162201    0 0
  v -28.2394 -41.337 79.1041    -0.177844 -0.959752 0.217364    0 0
  v -28.3757 -41.4247 78.4097    -0.179296 -0.97753 0.110853    0 0
  v -27.4739 -41.5474 78.1685    -0.0614967 -0.995273 0.0751623    0 0
  v -27.5318 -41.4247 79.1001    -0.0731545 -0.97753 0.197697    0 0
  v -29.0067 -41.337 77.0746    -0.277164 -0.959752 -0.0453347    0 0
  v -28.4735 -41.4247 76.6094    -0.18565 -0.97753 -0.099848    0 0
  v -27.8138 -41.5474 77.2697    -0.0958407 -0.995273 -0.0156764    0 0
  v -28.6495 -41.4247 77.6854    -0.207788 -0.97753 0.035496    0 0
  v -24.0872 -39.6695 74.8101    0.701071 -0.300818 -0.646536    0 0
  v -23.5151 -39.6695 75.624    0.843317 -0.301358 -0.444971    0 0
  v -23.7758 -40.3464 75.762    0.758707 -0.516421 -0.39708    0 0
  v -24.2993 -40.3434 75.0072    0.635219 -0.508001 -0.581749    0 0
  v -23.0522 -39.6695 77.5474    0.95345 -0.300819 0.0209974    0 0
  v -23.3417 -40.3434 77.54    0.861208 -0.508001 0.01598    0 0
  v -23.4486 -40.3464 76.6277    0.831634 -0.516419 -0.204195    0 0
  v -23.1617 -39.6695 76.5587    0.926763 -0.301359 -0.224262    0 0
  v -24.2156 -41.1555 77.5575    0.436313 -0.899761 0.00780139    0 0
  v -24.396 -41.2006 76.8938    0.39383 -0.91397 -0.0977586    0 0
  v -23.8552 -40.8511 76.7304    0.635657 -0.755029 -0.160846    0 0
  v -23.7368 -40.836 77.5347    0.671096 -0.74134 0.00680668    0 0
  v -24.9662 -41.1555 75.5722    0.322016 -0.899761 -0.294509    0 0
  v -24.592 -40.836 75.2725    0.498731 -0.741338 -0.449094    0 0
  v -24.1487 -40.8511 75.954    0.583072 -0.755028 -0.299932    0 0
  v -24.6624 -41.2006 76.1892    0.359997 -0.913969 -0.187248    0 0
  v -23.2119 -39.6695 78.5235    0.910452 -0.30082 0.283874    0 0
  v -23.6307 -39.6695 79.4259    0.807014 -0.30136 0.507849    0 0
  v -23.8806 -40.3464 79.2691    0.723237 -0.516418 0.45852    0 0
  v -23.4886 -40.3434 78.4384    0.821419 -0.508 0.259241    0 0
  v -25.065 -39.6695 80.7885    0.458542 -0.300819 0.83621    0 0
  v -25.2033 -40.3434 80.5341    0.416764 -0.508002 0.753818    0 0
  v -24.4666 -40.3464 79.9854    0.592655 -0.516417 0.61812    0 0
  v -24.2635 -39.6695 80.1993    0.657597 -0.30136 0.69047    0 0
  v -25.6555 -41.1555 79.786    0.211399 -0.899762 0.381757    0 0
  v -25.1709 -41.2006 79.298    0.281576 -0.91397 0.292188    0 0
  v -24.7589 -40.8511 79.6845    0.457123 -0.755031 0.470072    0 0
  v -25.3962 -40.836 80.1893    0.329654 -0.741337 0.584591    0 0
  v -24.3114 -41.1555 78.1433    0.416061 -0.899761 0.131618    0 0
  v -23.8648 -40.836 78.3175    0.638291 -0.741339 0.207365    0 0
  v -24.2333 -40.8511 79.0422    0.551283 -0.75503 0.354989    0 0
  v -24.6939 -41.2006 78.7149    0.342159 -0.91397 0.218142    0 0
  v -25.9902 -39.6695 81.1382    0.209381 -0.300819 0.930413    0 0
  v -26.981 -39.6695 81.2267    -0.0363045 -0.301358 0.95282    0 0
  v -26.9702 -40.3464 80.9319    -0.0354731 -0.516421 0.8556    0 0
  v -26.0548 -40.3434 80.856    0.186201 -0.508004 0.840988    0 0
  v -28.8783 -39.6695 80.6658    -0.494911 -0.300817 0.815213    0 0
  v -28.7271 -40.3434 80.4189    -0.444444 -0.508001 0.737838    0 0
  v -27.8835 -40.3464 80.7825    -0.238977 -0.516421 0.822313    0 0
  v -27.9672 -39.6695 81.0654    -0.269162 -0.301356 0.914733    0 0
  v -28.3053 -41.1555 79.6533    -0.224917 -0.89976 0.373957    0 0
  v -27.6404 -41.2006 79.8289    -0.112252 -0.91397 0.389947    0 0
  v -27.7692 -40.8511 80.379    -0.178533 -0.755028 0.630919    0 0
  v -28.5249 -40.836 80.0794    -0.341442 -0.741341 0.577781    0 0
  v -26.2106 -41.1555 79.9959    0.0940459 -0.899763 0.426123    0 0
  v -26.1382 -40.836 80.4698    0.139563 -0.741337 0.656462    0 0
  v -26.9501 -40.8511 80.513    -0.0317866 -0.75503 0.654919    0 0
  v -26.8969 -41.2006 79.9505    -0.0178372 -0.91397 0.40539    0 0
  v -29.6437 -39.6695 80.0396    -0.701069 -0.300817 0.646538    0 0
  v -30.2158 -39.6695 79.2257    -0.843318 -0.301357 0.444971    0 0
  v -29.9551 -40.3464 79.0876    -0.758708 -0.516421 0.39708    0 0
  v -29.4316 -40.3434 79.8425    -0.635218 -0.508001 0.581749    0 0
  v -30.6787 -39.6695 77.3022    -0.95345 -0.30082 -0.0209977    0 0
  v -30.3892 -40.3434 77.3097    -0.861208 -0.508002 -0.015981    0 0
  v -30.2823 -40.3464 78.222    -0.831634 -0.516419 0.204196    0 0
  v -30.5692 -39.6695 78.291    -0.926763 -0.301359 0.224262    0 0
  v -29.5153 -41.1555 77.2921    -0.436313 -0.899761 -0.00780131    0 0
  v -29.3349 -41.2006 77.9558    -0.39383 -0.91397 0.0977587    0 0
  v -29.8757 -40.8511 78.1193    -0.635656 -0.755029 0.160847    0 0
  v -29.9941 -40.836 77.315    -0.671097 -0.741338 -0.00680695    0 0
  v -28.7647 -41.1555 79.2775    -0.322014 -0.899761 0.294512    0 0
  v -29.1389 -40.836 79.5771    -0.498728 -0.74134 0.449093    0 0
  v -29.5822 -40.8511 78.8956    -0.583071 -0.75503 0.29993    0 0
  v -29.0685 -41.2006 78.6604    -0.359996 -0.91397 0.187247    0 0
  v -30.519 -39.6695 76.3261    -0.910452 -0.300819 -0.283874    0 0
  v -30.1002 -39.6695 75.4238    -0.807014 -0.301361 -0.507849    0 0
  v -29.8503 -40.3464 75.5805    -0.723237 -0.516418 -0.458521    0 0
  v -30.2423 -40.3434 76.4113    -0.821418 -0.508003 -0.259241    0 0
  v -28.6659 -39.6695 74.0612    -0.458541 -0.300821 -0.83621    0 0
  v -28.5276 -40.3434 74.3155    -0.416763 -0.508 -0.75382    0 0
  v -29.2643 -40.3464 74.8643    -0.592658 -0.516416 -0.61812    0 0
  v -29.4674 -39.6695 74.6504    -0.657597 -0.301361 -0.690469    0 0
  v -28.0755 -41.1555 75.0636    -0.211399 -0.899761 -0.381759    0 0
  v -28.56 -41.2006 75.5517    -0.281576 -0.91397 -0.292187    0 0
  v -28.972 -40.8511 75.1651    -0.457124 -0.755029 -0.470073    0 0
  v -28.3347 -40.836 74.6604    -0.329654 -0.741337 -0.584592    0 0
  v -29.4195 -41.1555 76.7064    -0.416061 -0.899761 -0.131619    0 0
  v -29.8661 -40.836 76.5321    -0.638293 -0.741338 -0.207366    0 0
  v -29.4976 -40.8511 75.8075    -0.551286 -0.755028 -0.354988    0 0
  v -29.0371 -41.2006 76.1347    -0.34216 -0.91397 -0.218142    0 0
  v -27.7407 -39.6695 73.7114    -0.209381 -0.30082 -0.930412    0 0
  v -26.7499 -39.6695 73.6229    0.0363026 -0.301361 -0.952819    0 0
  v -26.7607 -40.3464 73.9177    0.0354706 -0.51642 -0.8556    0 0
  v -27.6761 -40.3434 73.9936    -0.186201 -0.508005 -0.840988    0 0
  v -24.8527 -39.6695 74.1838    0.494909 -0.300821 -0.815213    0 0
  v -25.0038 -40.3434 74.4307    0.444445 -0.507999 -0.737839    0 0
  v -25.8474 -40.3464 74.0671    0.238978 -0.516415 -0.822317    0 0
  v -25.7637 -39.6695 73.7842    0.269163 -0.301364 -0.91473    0 0
  v -25.4256 -41.1555 75.1963    0.224913 -0.89976 -0.373959    0 0
  v -26.0906 -41.2006 75.0207    0.112252 -0.91397 -0.389947    0 0
  v -25.9618 -40.8511 74.4706    0.178531 -0.75503 -0.630917    0 0
  v -25.206 -40.836 74.7702    0.341442 -0.74134 -0.577783    0 0
  v -27.5203 -41.1555 74.8537    -0.0940475 -0.89976 -0.426129    0 0
  v -27.5927 -40.836 74.3798    -0.139563 -0.741336 -0.656463    0 0
  v -26.7808 -40.8511 74.3367    0.0317898 -0.755028 -0.654921    0 0
  v -26.834 -41.2006 74.8991    0.0178383 -0.913969 -0.405391    0 0
  v -28.2501 -35.9971 74.4973    -0.278625 0.772984 -0.569969    0 0
  v -28.144 -35.6772 75.0346    -0.210641 0.902911 -0.374676    0 0
  v -27.4881 -35.6772 74.7866    -0.0899269 0.902911 -0.420316    0 0
  v -27.764 -35.9971 74.3135    -0.16815 0.772983 -0.611738    0 0
  v -28.7409 -35.5628 75.8904    -0.277517 0.933503 -0.22706    0 0
  v -27.9289 -35.4142 75.7893    -0.139901 0.967486 -0.210708    0 0
  v -28.8206 -35.8342 75.1723    -0.366103 0.840598 -0.399204    0 0
  v -26.6973 -35.2447 76.3966    0.0211733 0.99136 -0.129448    0 0
  v -27.1501 -35.4142 75.4948    -0.0344944 0.967486 -0.250561    0 0
  v -27.6718 -35.2447 76.7651    -0.101519 0.99136 -0.0830602    0 0
  v -26.8896 -35.8342 74.4422    0.0104154 0.840598 -0.54156    0 0
  v -26.4743 -35.5628 75.0335    0.0578788 0.933503 -0.353867    0 0
  v -30.0931 -35.9971 77.1602    -0.63292 0.772984 -0.0436785    0 0
  v -29.5747 -35.6772 77.3369    -0.429803 0.902909 -0.00491379    0 0
  v -29.4615 -35.6772 76.6449    -0.408968 0.90291 -0.132279    0 0
  v -30.0092 -35.9971 76.6473    -0.613855 0.772983 -0.16025    0 0
  v -29.132 -35.5628 78.2818    -0.335397 0.933504 0.126807    0 0
  v -28.8136 -35.4142 77.528    -0.252428 0.967487 0.0158046    0 0
  v -29.7938 -35.8342 77.9918    -0.528773 0.840598 0.117446    0 0
  v -28.6792 -35.4142 76.7063    -0.234238 0.967487 -0.095407    0 0
  v -27.84 -35.2447 77.7933    -0.122692 0.99136 0.0463874    0 0
  v -29.4605 -35.8342 75.9544    -0.463794 0.840599 -0.2798    0 0
  v -28.7084 -35.9971 80.0878    -0.354288 0.772983 0.526287    0 0
  v -28.2962 -35.6772 79.7272    -0.219158 0.902909 0.369763    0 0
  v -28.8389 -35.6772 79.2831    -0.319044 0.902909 0.288038    0 0
  v -29.1107 -35.9971 79.7586    -0.445706 0.772985 0.451486    0 0
  v -27.2566 -35.5628 79.8162    -0.0578788 0.933503 0.353867    0 0
  v -27.7502 -35.4142 79.1636    -0.112528 0.967487 0.226511    0 0
  v -27.8386 -35.8342 80.2443    -0.162677 0.840595 0.516659    0 0
  v -28.3946 -35.4142 78.6363    -0.199744 0.967487 0.155153    0 0
  v -27.0336 -35.2447 78.453    -0.0211733 0.99136 0.129448    0 0
  v -29.4364 -35.8342 78.937    -0.474213 0.840596 0.261764    0 0
  v -25.4808 -35.9971 80.3524    0.278631 0.772986 0.569962    0 0
  v -25.5869 -35.6772 79.815    0.210646 0.902909 0.374679    0 0
  v -26.2428 -35.6772 80.063    0.0899259 0.902909 0.420319    0 0
  v -25.9669 -35.9971 80.5362    0.168145 0.772984 0.611737    0 0
  v -24.9901 -35.5628 78.9592    0.277517 0.933503 0.22706    0 0
  v -25.802 -35.4142 79.0604    0.139901 0.967486 0.210708    0 0
  v -24.9103 -35.8342 79.6773    0.366101 0.840596 0.39921    0 0
  v -26.5808 -35.4142 79.3549    0.0344944 0.967486 0.250561    0 0
  v -26.0591 -35.2447 78.0845    0.101519 0.99136 0.0830602    0 0
  v -26.8413 -35.8342 80.4074    -0.0104127 0.840596 0.541563    0 0
  v -23.6378 -35.9971 77.6894    0.63292 0.772984 0.0436785    0 0
  v -24.1562 -35.6772 77.5127    0.429803 0.902909 0.00491379    0 0
  v -24.2694 -35.6772 78.2047    0.40897 0.902909 0.132281    0 0
  v -23.7217 -35.9971 78.2024    0.613853 0.772984 0.160252    0 0
  v -24.5989 -35.5628 76.5679    0.335397 0.933504 -0.126807    0 0
  v -24.9173 -35.4142 77.3216    0.252429 0.967486 -0.0158046    0 0
  v -23.9371 -35.8342 76.8579    0.528773 0.840598 -0.117446    0 0
  v -25.0517 -35.4142 78.1434    0.234238 0.967487 0.0954063    0 0
  v -25.8909 -35.2447 77.0564    0.122692 0.99136 -0.0463874    0 0
  v -24.2704 -35.8342 78.8952    0.463798 0.840597 0.2798    0 0
  v -25.0225 -35.9971 74.7619    0.354291 0.772982 -0.526286    0 0
  v -25.4347 -35.6772 75.1225    0.219158 0.90291 -0.36976    0 0
  v -24.892 -35.6772 75.5665    0.319044 0.902909 -0.288038    0 0
  v -24.6202 -35.9971 75.091    0.445706 0.772985 -0.451486    0 0
  v -25.9808 -35.4142 75.686    0.112528 0.967487 -0.226511    0 0
  v -25.8923 -35.8342 74.6053    0.162673 0.840596 -0.516657    0 0
  v -25.3363 -35.4142 76.2133    0.199744 0.967487 -0.155153    0 0
  v -24.2945 -35.8342 75.9126    0.47421 0.840598 -0.261763    0 0
  v -24.1318 -36.1919 75.3547    0.602318 0.680196 -0.417789    0 0
  v -24.1675 -36.5765 74.8541    0.646312 0.494351 -0.58129    0 0
  v -24.6259 -36.2888 74.6876    0.487635 0.637959 -0.596004    0 0
  v -23.7452 -36.1225 76.2451    0.655965 0.712884 -0.248006    0 0
  v -23.6582 -36.51 75.6752    0.750587 0.535241 -0.387474    0 0
  v -23.357 -37.3749 75.5342    0.87016 0.19611 -0.452064    0 0
  v -23.7262 -36.9425 75.1479    0.773907 0.346692 -0.529975    0 0
  v -23.2651 -36.9148 76.0636    0.871035 0.36448 -0.329323    0 0
  v -24.39 -36.9701 74.3992    0.598764 0.325437 -0.731828    0 0
  v -23.9468 -37.3933 74.6722    0.727682 0.179329 -0.662057    0 0
  v -23.3752 -36.2888 77.9957    0.759973 0.637956 0.124307    0 0
  v -23.1416 -36.5765 77.5676    0.869223 0.49435 0.00829752    0 0
  v -23.446 -36.1919 77.1686    0.728064 0.680194 -0.0852014    0 0
  v -22.8557 -37.3933 77.5579    0.983674 0.17933 0.0150297    0 0
  v -23.0051 -36.9425 77.0554    0.930952 0.346693 -0.114594    0 0
  v -23.0075 -36.9701 78.0559    0.933164 0.325437 0.152632    0 0
  v -23.3029 -36.51 76.6149    0.819188 0.535243 -0.206024    0 0
  v -22.9838 -37.3749 76.5214    0.951585 0.19611 -0.236701    0 0
  v -22.945 -39.2648 77.5509    0.975369 -0.219511 0.0216927    0 0
  v -22.8854 -38.8151 77.0318    0.983856 -0.14207 -0.108827    0 0
  v -22.8122 -38.3402 77.5556    0.998123 -0.0574464 0.0212026    0 0
  v -22.9084 -38.8151 78.0721    0.976645 -0.143688 0.159746    0 0
  v -23.1317 -38.8151 76.0132    0.92609 -0.140575 -0.350136    0 0
  v -22.9298 -38.3383 76.5049    0.970499 -0.0510922 -0.235631    0 0
  v -23.0576 -39.2648 76.5343    0.948428 -0.218885 -0.229289    0 0
  v -22.8335 -37.856 77.029    0.992043 0.0527479 -0.114314    0 0
  v -23.0873 -37.8504 75.9964    0.933608 0.0614951 -0.352979    0 0
  v -22.8529 -37.8615 78.0811    0.985947 0.0436106 0.161268    0 0
  v -24.3264 -38.8151 74.3216    0.626664 -0.143686 -0.765928    0 0
  v -23.9125 -38.3402 74.6451    0.734432 -0.0574459 -0.676246    0 0
  v -23.6209 -38.8151 75.0864    0.809759 -0.14207 -0.569303    0 0
  v -24.0091 -39.2648 74.7366    0.717046 -0.219514 -0.661558    0 0
  v -23.5802 -37.856 75.0542    0.81953 0.052746 -0.570603    0 0
  v -24.2908 -37.8615 74.278    0.632634 0.0436072 -0.773223    0 0
  v -23.3056 -38.3383 75.5109    0.883635 -0.0510902 -0.465381    0 0
  v -23.4209 -39.2648 75.5733    0.862889 -0.218885 -0.455535    0 0
  v -23.7059 -36.1919 78.7572    0.662976 0.680194 0.312729    0 0
  v -23.2902 -36.5765 78.4759    0.826567 0.494354 0.269076    0 0
  v -24.2836 -36.1225 79.5372    0.542758 0.712888 0.444078    0 0
  v -23.7466 -36.51 79.3276    0.710857 0.535243 0.456286    0 0
  v -23.4739 -37.3749 79.5179    0.826581 0.196106 0.527548    0 0
  v -23.324 -36.9425 79.005    0.845926 0.346691 0.405234    0 0
  v -23.8864 -36.9148 79.8622    0.720717 0.364476 0.589681    0 0
  v -23.0223 -37.3933 78.5762    0.9372 0.179328 0.299162    0 0
  v -25.6147 -36.2888 80.7329    0.272332 0.637955 0.720312    0 0
  v -25.1272 -36.5765 80.7212    0.427425 0.494347 0.756921    0 0
  v -24.9338 -36.1919 80.258    0.437822 0.680195 0.587917    0 0
  v -24.9759 -37.3933 80.9639    0.478824 0.179329 0.8594    0 0
  v -24.6153 -36.9425 80.5833    0.564719 0.346692 0.748931    0 0
  v -25.483 -36.9701 81.0814    0.334396 0.325444 0.884458    0 0
  v -24.3828 -36.51 80.1051    0.588013 0.535243 0.606429    0 0
  v -24.1422 -37.3749 80.3347    0.68078 0.196113 0.705747    0 0
  v -25.0144 -39.2648 80.8831    0.468898 -0.219511 0.855541    0 0
  v -24.535 -38.8151 80.6751    0.586176 -0.14207 0.79763    0 0
  v -24.9521 -38.3402 81.0005    0.480701 -0.0574409 0.875001    0 0
  v -25.4475 -38.8151 81.1753    0.349977 -0.14369 0.925672    0 0
  v -23.7761 -38.8151 79.9525    0.766273 -0.140577 0.626948    0 0
  v -24.101 -38.3383 80.3732    0.68931 -0.0510931 0.722662    0 0
  v -24.1903 -39.2648 80.2773    0.672784 -0.218886 0.706719    0 0
  v -24.5067 -37.856 80.7186    0.595018 0.05275 0.801979    0 0
  v -23.7393 -37.8504 79.9826    0.772495 0.0614968 0.632037    0 0
  v -25.4276 -37.8615 81.228    0.353313 0.0436094 0.934488    0 0
  v -22.9817 -38.3402 78.5923    0.952863 -0.0574468 0.297913    0 0
  v -23.2181 -38.8151 79.0655    0.89791 -0.142068 0.416622    0 0
  v -23.1091 -39.2648 78.5544    0.931451 -0.219511 0.290197    0 0
  v -23.1698 -37.856 79.0846    0.903921 0.052749 0.424433    0 0
  v -23.428 -38.3383 79.5507    0.84485 -0.051092 0.532559    0 0
  v -23.5397 -39.2648 79.4821    0.825948 -0.218881 0.519519    0 0
  v -26.4395 -36.1919 80.8273    0.0606528 0.680197 0.730516    0 0
  v -25.9881 -36.5765 81.0467    0.180262 0.49435 0.850367    0 0
  v -27.4039 -36.1225 80.7169    -0.113202 0.712885 0.692084    0 0
  v -26.9539 -36.51 81.0772    -0.0397295 0.535247 0.843761    0 0
  v -26.9824 -37.3749 81.4085    -0.0435756 0.196104 0.979614    0 0
  v -26.4632 -36.9425 81.2819    0.0720238 0.34669 0.935211    0 0
  v -27.4868 -36.9148 81.2235    -0.150319 0.364482 0.918998    0 0
  v -25.941 -37.3933 81.3288    0.209516 0.17933 0.96122    0 0
  v -29.105 -36.2888 80.162    -0.487635 0.637959 0.596004    0 0
  v -28.851 -36.5765 80.5784    -0.441797 0.494351 0.74862    0 0
  v -28.3532 -36.1919 80.5142    -0.290243 0.680197 0.673121    0 0
  v -28.9856 -37.3933 80.8308    -0.504852 0.17933 0.844373    0 0
  v -28.4757 -36.9425 80.9527    -0.366235 0.34669 0.863526    0 0
  v -29.3409 -36.9701 80.4504    -0.598767 0.325437 0.731826    0 0
  v -27.9453 -36.51 80.915    -0.23117 0.535246 0.812448    0 0
  v -28.0239 -37.3749 81.2382    -0.270808 0.196105 0.942447    0 0
  v -28.9349 -39.2648 80.757    -0.506472 -0.219508 0.833848    0 0
  v -28.5151 -38.8151 81.0682    -0.397685 -0.142065 0.906457    0 0
  v -29.0053 -38.3402 80.8697    -0.517421 -0.0574461 0.8538    0 0
  v -29.4045 -38.8151 80.5281    -0.626664 -0.143686 0.765928    0 0
  v -27.5098 -38.8151 81.3641    -0.15982 -0.14058 0.977085    0 0
  v -28.0366 -38.3383 81.2931    -0.281192 -0.0510859 0.958291    0 0
  v -27.9982 -39.2648 81.1678    -0.27564 -0.218887 0.936008    0 0
  v -28.5386 -37.856 81.1145    -0.397021 0.0527437 0.916293    0 0
  v -27.5175 -37.8504 81.411    -0.161116 0.0614918 0.985018    0 0
  v -29.4401 -37.8615 80.5717    -0.632634 0.0436073 0.773222    0 0
  v -25.9346 -38.3402 81.372    0.218429 -0.0574427 0.974161    0 0
  v -26.4626 -38.8151 81.4039    0.0881529 -0.14207 0.985923    0 0
  v -25.9656 -39.2648 81.2427    0.214405 -0.21951 0.951759    0 0
  v -26.455 -37.856 81.4553    0.0843913 0.0527485 0.995036    0 0
  v -26.9879 -38.3383 81.4647    -0.0387851 -0.0510841 0.997941    0 0
  v -26.9843 -39.2648 81.3336    -0.0369431 -0.218886 0.975051    0 0
  v -29.5991 -36.1919 79.4949    -0.602319 0.680196 0.417786    0 0
  v -29.5634 -36.5765 79.9956    -0.646313 0.494348 0.581291    0 0
  v -29.9857 -36.1225 78.6045    -0.655964 0.712884 0.248009    0 0
  v -30.0727 -36.51 79.1744    -0.750586 0.535243 0.387474    0 0
  v -30.3739 -37.3749 79.3154    -0.870161 0.19611 0.452063    0 0
  v -30.0047 -36.9425 79.7018    -0.773905 0.346693 0.529977    0 0
  v -30.4658 -36.9148 78.7861    -0.871035 0.36448 0.329323    0 0
  v -29.7841 -37.3933 80.1774    -0.727681 0.179332 0.662058    0 0
  v -30.3557 -36.2888 76.8539    -0.759973 0.637956 -0.124307    0 0
  v -30.5893 -36.5765 77.282    -0.869223 0.49435 -0.00829752    0 0
  v -30.2849 -36.1919 77.6811    -0.728064 0.680194 0.0852014    0 0
  v -30.8752 -37.3933 77.2917    -0.983674 0.17933 -0.0150297    0 0
  v -30.7258 -36.9425 77.7943    -0.930952 0.346693 0.114594    0 0
  v -30.7234 -36.9701 76.7938    -0.933164 0.325437 -0.152632    0 0
  v -30.428 -36.51 78.2347    -0.819188 0.535243 0.206024    0 0
  v -30.7471 -37.3749 78.3283    -0.951585 0.19611 0.236701    0 0
  v -30.7859 -39.2648 77.2987    -0.975369 -0.219511 -0.0216927    0 0
  v -30.8455 -38.8151 77.8179    -0.983856 -0.14207 0.108827    0 0
  v -30.9188 -38.3402 77.2941    -0.998123 -0.0574464 -0.0212038    0 0
  v -30.8225 -38.8151 76.7776    -0.976645 -0.143688 -0.159747    0 0
  v -30.5992 -38.8151 78.8365    -0.92609 -0.140575 0.350136    0 0
  v -30.8011 -38.3383 78.3448    -0.970499 -0.0510922 0.235631    0 0
  v -30.6733 -39.2648 78.3153    -0.948428 -0.218885 0.229289    0 0
  v -30.8974 -37.856 77.8206    -0.992043 0.0527479 0.114314    0 0
  v -30.6436 -37.8504 78.8533    -0.933608 0.0614951 0.35298    0 0
  v -30.878 -37.8615 76.7685    -0.985947 0.0436105 -0.161268    0 0
  v -29.8184 -38.3402 80.2045    -0.734433 -0.0574445 0.676246    0 0
  v -30.11 -38.8151 79.7632    -0.80976 -0.14207 0.569302    0 0
  v -29.7219 -39.2648 80.1131    -0.717046 -0.219516 0.661557    0 0
  v -30.1507 -37.856 79.7955    -0.81953 0.0527444 0.570603    0 0
  v -30.4253 -38.3383 79.3387    -0.883635 -0.0510902 0.465381    0 0
  v -30.31 -39.2648 79.2763    -0.862889 -0.218885 0.455535    0 0
  v -30.025 -36.1919 76.0925    -0.662979 0.680192 -0.312728    0 0
  v -30.4408 -36.5765 76.3737    -0.826567 0.494354 -0.269076    0 0
  v -29.4473 -36.1225 75.3124    -0.542756 0.712889 -0.444077    0 0
  v -29.9843 -36.51 75.5221    -0.710859 0.535242 -0.456285    0 0
  v -30.257 -37.3749 75.3317    -0.826581 0.196107 -0.527547    0 0
  v -30.4069 -36.9425 75.8447    -0.845926 0.346691 -0.405234    0 0
  v -29.8445 -36.9148 74.9874    -0.720718 0.364475 -0.589681    0 0
  v -30.7086 -37.3933 76.2735    -0.9372 0.179328 -0.299162    0 0
  v -28.1162 -36.2888 74.1167    -0.27233 0.637962 -0.720306    0 0
  v -28.6037 -36.5765 74.1285    -0.42743 0.494348 -0.756917    0 0
  v -28.7971 -36.1918 74.5917    -0.437824 0.68019 -0.587922    0 0
  v -28.755 -37.3933 73.8857    -0.478824 0.179336 -0.859399    0 0
  v -29.1156 -36.9425 74.2664    -0.564719 0.346692 -0.748931    0 0
  v -28.2479 -36.9701 73.7682    -0.334396 0.325437 -0.88446    0 0
  v -29.3481 -36.51 74.7445    -0.588012 0.535242 -0.606431    0 0
  v -29.5887 -37.3749 74.5149    -0.680779 0.196114 -0.705747    0 0
  v -28.7165 -39.2648 73.9666    -0.468898 -0.219511 -0.855541    0 0
  v -29.1959 -38.8151 74.1745    -0.586176 -0.14207 -0.79763    0 0
  v -28.7789 -38.3402 73.8492    -0.4807 -0.0574478 -0.875001    0 0
  v -28.2834 -38.8151 73.6743    -0.349977 -0.14369 -0.925672    0 0
  v -29.9548 -38.8151 74.8971    -0.766271 -0.140577 -0.626951    0 0
  v -29.63 -38.3383 74.4764    -0.68931 -0.0510931 -0.722662    0 0
  v -29.5406 -39.2648 74.5723    -0.672784 -0.218886 -0.706719    0 0
  v -29.2242 -37.856 74.131    -0.595022 0.0527506 -0.801976    0 0
  v -29.9916 -37.8504 74.8671    -0.772495 0.0614968 -0.632037    0 0
  v -28.3034 -37.8615 73.6217    -0.353307 0.0436093 -0.934491    0 0
  v -30.7492 -38.3402 76.2574    -0.952863 -0.0574468 -0.297913    0 0
  v -30.5128 -38.8151 75.7842    -0.897911 -0.142068 -0.41662    0 0
  v -30.6218 -39.2648 76.2952    -0.931451 -0.219511 -0.290197    0 0
  v -30.5611 -37.856 75.765    -0.903921 0.0527495 -0.424433    0 0
  v -30.3029 -38.3383 75.2989    -0.84485 -0.0510877 -0.532559    0 0
  v -30.1912 -39.2648 75.3675    -0.825948 -0.218885 -0.519519    0 0
  v -27.2914 -36.1919 74.0224    -0.0606551 0.680194 -0.730518    0 0
  v -27.7428 -36.5765 73.803    -0.180255 0.49435 -0.850368    0 0
  v -26.327 -36.1225 74.1327    0.113201 0.712886 -0.692083    0 0
  v -26.777 -36.51 73.7725    0.0397276 0.535246 -0.843762    0 0
  v -26.7485 -37.3749 73.4411    0.0435756 0.196105 -0.979614    0 0
  v -27.2677 -36.9425 73.5677    -0.0720238 0.34669 -0.935211    0 0
  v -26.2441 -36.9148 73.6262    0.150319 0.364481 -0.918998    0 0
  v -27.7899 -37.3933 73.5209    -0.209516 0.17933 -0.96122    0 0
  v -24.8799 -36.5765 74.2712    0.441797 0.494351 -0.74862    0 0
  v -25.3777 -36.1919 74.3354    0.290246 0.680194 -0.673122    0 0
  v -24.7453 -37.3933 74.0189    0.504852 0.17933 -0.844373    0 0
  v -25.2552 -36.9425 73.8969    0.366235 0.34669 -0.863526    0 0
  v -25.7856 -36.51 73.9346    0.231172 0.535244 -0.812449    0 0
  v -25.707 -37.3749 73.6115    0.270808 0.196107 -0.942447    0 0
  v -24.796 -39.2648 74.0926    0.506471 -0.219507 -0.833849    0 0
  v -25.2158 -38.8151 73.7815    0.397684 -0.142072 -0.906456    0 0
  v -24.7256 -38.3402 73.9799    0.517427 -0.0574471 -0.853797    0 0
  v -26.2211 -38.8151 73.4855    0.159821 -0.140572 -0.977086    0 0
  v -25.6943 -38.3383 73.5565    0.281186 -0.0510864 -0.958293    0 0
  v -25.7327 -39.2648 73.6818    0.275647 -0.218887 -0.936006    0 0
  v -25.1923 -37.856 73.7352    0.397021 0.0527514 -0.916293    0 0
  v -26.2134 -37.8504 73.4386    0.161116 0.0614918 -0.985018    0 0
  v -27.7963 -38.3402 73.4777    -0.21843 -0.0574427 -0.974161    0 0
  v -27.2683 -38.8151 73.4458    -0.0881529 -0.142071 -0.985923    0 0
  v -27.7654 -39.2648 73.607    -0.214405 -0.21951 -0.951759    0 0
  v -27.2759 -37.856 73.3944    -0.0843915 0.0527492 -0.995035    0 0
  v -26.7431 -38.3383 73.385    0.0387851 -0.0510842 -0.997941    0 0
  v -26.7466 -39.2648 73.516    0.0369359 -0.218886 -0.975051    0 0
  v -27.5353 -41.2602 75.116    -0.0920001 -0.937643 -0.335205    0 0
  v -27.3182 -41.3904 75.5146    -0.0493661 -0.971666 -0.231145    0 0
  v -27.7897 -41.3904 75.6929    -0.115907 -0.971666 -0.205988    0 0
  v -27.8906 -41.2602 75.2504    -0.152782 -0.937643 -0.312222    0 0
  v -26.5847 -41.437 75.7083    0.032207 -0.979893 -0.196908    0 0
  v -27.0683 -41.4975 76.0528    -0.0194277 -0.989734 -0.141595    0 0
  v -26.8864 -41.3265 75.2402    0.00578238 -0.954997 -0.29656    0 0
  v -27.4339 -41.5665 76.9598    -0.0584767 -0.997142 -0.0478448    0 0
  v -27.621 -41.4975 76.2618    -0.0791102 -0.989734 -0.119031    0 0
  v -26.7469 -41.5665 76.7    0.012196 -0.997142 -0.0745649    0 0
  v -28.295 -41.3265 75.7728    -0.200535 -0.954996 -0.218558    0 0
  v -28.2116 -41.437 76.3234    -0.154423 -0.979893 -0.126346    0 0
  v -25.2009 -41.2602 75.6903    0.244299 -0.937643 -0.247273    0 0
  v -25.4375 -41.3904 76.0776    0.175495 -0.971666 -0.158323    0 0
  v -25.8277 -41.3904 75.7584    0.120437 -0.971666 -0.203372    0 0
  v -25.4949 -41.2602 75.4497    0.194 -0.937643 -0.288426    0 0
  v -25.2386 -41.437 76.8097    0.18663 -0.979893 -0.070561    0 0
  v -25.7787 -41.4975 76.5631    0.112912 -0.989734 -0.0876223    0 0
  v -24.984 -41.3265 76.3144    0.259719 -0.954997 -0.143273    0 0
  v -26.2361 -41.4975 76.1889    0.0635282 -0.989734 -0.128027    0 0
  v -26.1785 -41.5665 77.1651    0.0706734 -0.997142 -0.0267199    0 0
  v -26.1495 -41.3265 75.3608    0.0890073 -0.954996 -0.282949    0 0
  v -24.531 -41.2602 77.9991    0.336294 -0.937643 0.0879313    0 0
  v -24.9848 -41.3904 77.9878    0.224859 -0.971666 0.0728218    0 0
  v -24.9034 -41.3904 77.4903    0.236343 -0.971666 0.0026151    0 0
  v -24.4697 -41.2602 77.6242    0.346785 -0.937643 0.0237971    0 0
  v -25.5193 -41.437 78.5262    0.154423 -0.979893 0.126347    0 0
  v -25.5758 -41.4975 77.9352    0.132339 -0.989734 0.0539729    0 0
  v -24.9631 -41.3265 78.499    0.253937 -0.954997 0.153287    0 0
  v -25.4805 -41.4975 77.352    0.142639 -0.989734 -0.00899556    0 0
  v -26.297 -41.5665 77.8899    0.0584769 -0.997142 0.0478447    0 0
  v -24.72 -41.3265 77.0128    0.289542 -0.954997 -0.0643908    0 0
  v -26.1956 -41.2602 79.7336    0.0919946 -0.937644 0.335203    0 0
  v -26.4127 -41.3904 79.335    0.0493653 -0.971666 0.231147    0 0
  v -25.9412 -41.3904 79.1567    0.115908 -0.971666 0.205988    0 0
  v -25.8403 -41.2602 79.5993    0.152782 -0.937643 0.312222    0 0
  v -27.1462 -41.437 79.1413    -0.0322088 -0.979893 0.196907    0 0
  v -26.6626 -41.4975 78.7968    0.0194277 -0.989734 0.141595    0 0
  v -26.8445 -41.3265 79.6094    -0.00577918 -0.954997 0.29656    0 0
  v -26.1099 -41.4975 78.5878    0.0791104 -0.989734 0.119031    0 0
  v -26.984 -41.5665 78.1496    -0.0121959 -0.997142 0.0745649    0 0
  v -25.4359 -41.3265 79.0769    0.200536 -0.954997 0.218556    0 0
  v -28.53 -41.2602 79.1593    -0.244297 -0.937643 0.247275    0 0
  v -28.2934 -41.3904 78.772    -0.175496 -0.971666 0.158322    0 0
  v -27.9032 -41.3904 79.0912    -0.120435 -0.971667 0.20337    0 0
  v -28.236 -41.2602 79.3999    -0.194005 -0.937643 0.288424    0 0
  v -28.4923 -41.437 78.0399    -0.18663 -0.979893 0.0705616    0 0
  v -27.9522 -41.4975 78.2865    -0.112912 -0.989734 0.087623    0 0
  v -28.7469 -41.3265 78.5353    -0.259718 -0.954997 0.143273    0 0
  v -27.4949 -41.4975 78.6607    -0.0635295 -0.989734 0.128028    0 0
  v -27.5524 -41.5665 77.6845    -0.0706734 -0.997142 0.0267199    0 0
  v -27.5814 -41.3265 79.4889    -0.089007 -0.954997 0.282947    0 0
  v -29.1999 -41.2602 76.8505    -0.336295 -0.937643 -0.087932    0 0
  v -28.7461 -41.3904 76.8618    -0.224859 -0.971666 -0.0728218    0 0
  v -28.8275 -41.3904 77.3593    -0.236343 -0.971666 -0.00261511    0 0
  v -29.2612 -41.2602 77.2254    -0.346785 -0.937643 -0.0237971    0 0
  v -28.1551 -41.4975 76.9145    -0.13234 -0.989734 -0.0539729    0 0
  v -28.7679 -41.3265 76.3507    -0.253938 -0.954997 -0.153285    0 0
  v -28.2505 -41.4975 77.4977    -0.142639 -0.989734 0.0089956    0 0
  v -29.0109 -41.3265 77.8369    -0.289542 -0.954997 0.0643916    0 0
  v -23.7754 -39.6695 75.1978    0.780106 -0.301051 -0.548455    0 0
  v -24.1836 -40.0291 74.9002    0.675139 -0.396913 -0.62181    0 0
  v -24.4473 -39.6695 74.4693    0.603948 -0.300626 -0.738154    0 0
  v -23.3095 -39.6695 76.0804    0.891802 -0.301669 -0.337172    0 0
  v -23.6327 -40.0298 75.6866    0.810252 -0.401599 -0.42686    0 0
  v -23.9471 -40.62 75.8509    0.681768 -0.64025 -0.353939    0 0
  v -24.014 -40.3449 75.3665    0.704714 -0.512248 -0.490898    0 0
  v -23.5868 -40.3472 76.1852    0.799355 -0.519322 -0.30222    0 0
  v -24.6298 -40.3427 74.6924    0.546537 -0.505055 -0.667994    0 0
  v -24.4351 -40.6125 75.1312    0.576064 -0.627506 -0.52382    0 0
  v -23.0968 -39.6695 78.0412    0.941235 -0.300624 0.153955    0 0
  v -23.1842 -40.0291 77.5437    0.917645 -0.396917 0.019607    0 0
  v -23.0749 -39.6695 77.0505    0.947826 -0.301055 -0.104843    0 0
  v -23.5256 -40.6125 77.5368    0.778523 -0.627508 0.0116786    0 0
  v -23.3655 -40.3449 77.0818    0.853214 -0.512248 -0.0981227    0 0
  v -23.3813 -40.3427 77.9947    0.851766 -0.505059 0.13932    0 0
  v -23.2913 -40.0298 76.5895    0.889988 -0.401598 -0.215965    0 0
  v -23.6358 -40.62 76.6743    0.745396 -0.640251 -0.185642    0 0
  v -24.287 -41.1809 77.237    0.416436 -0.907782 -0.0501344    0 0
  v -23.9689 -41.0163 77.5395    0.554025 -0.832492 0.00356043    0 0
  v -24.2132 -41.1414 77.8586    0.440232 -0.894992 0.0720065    0 0
  v -24.5265 -41.2091 76.5405    0.372808 -0.91714 -0.140952    0 0
  v -24.1082 -41.0434 76.8016    0.511713 -0.849239 -0.130161    0 0
  v -23.7696 -40.8435 77.1321    0.657702 -0.748744 -0.082525    0 0
  v -23.9845 -40.8548 76.3356    0.609115 -0.758909 -0.230294    0 0
  v -23.7655 -40.8323 77.9319    0.667906 -0.736184 0.109247    0 0
  v -25.1636 -41.1414 75.3448    0.282477 -0.894992 -0.345248    0 0
  v -24.7693 -41.0163 75.4225    0.41309 -0.832493 -0.369203    0 0
  v -24.8077 -41.1809 75.8598    0.345442 -0.907781 -0.237916    0 0
  v -24.3503 -40.8435 75.5962    0.547785 -0.748747 -0.373243    0 0
  v -24.8764 -40.8323 74.9937    0.428558 -0.736184 -0.523805    0 0
  v -24.3856 -41.0434 76.0679    0.469828 -0.84924 -0.240941    0 0
  v -23.3917 -39.6695 78.9874    0.865027 -0.301057 0.401363    0 0
  v -23.3382 -40.0291 78.4851    0.876071 -0.396916 0.273784    0 0
  v -23.9232 -39.6695 79.8321    0.737899 -0.30167 0.603738    0 0
  v -23.7437 -40.0298 79.3554    0.774797 -0.401603 0.488268    0 0
  v -24.0432 -40.62 79.1652    0.647406 -0.64025 0.413456    0 0
  v -23.6572 -40.3449 78.8651    0.777486 -0.512248 0.364852    0 0
  v -24.1526 -40.3472 79.6445    0.66141 -0.519318 0.541152    0 0
  v -23.6639 -40.6125 78.3828    0.741672 -0.627507 0.236974    0 0
  v -25.515 -39.6695 80.9967    0.337289 -0.300625 0.892111    0 0
  v -25.1277 -40.0291 80.6723    0.441842 -0.396921 0.804506    0 0
  v -24.646 -39.6695 80.5203    0.564711 -0.301056 0.768418    0 0
  v -25.2925 -40.6125 80.3733    0.379151 -0.627506 0.680059    0 0
  v -24.8184 -40.3449 80.2844    0.511583 -0.512249 0.689844    0 0
  v -25.6169 -40.3427 80.7271    0.305232 -0.505056 0.807311    0 0
  v -24.3549 -40.0298 80.1024    0.632024 -0.401599 0.66277    0 0
  v -24.6006 -40.62 79.8465    0.533466 -0.640251 0.552714    0 0
  v -25.4135 -41.1809 79.5639    0.251637 -0.907782 0.335576    0 0
  v -25.5165 -41.0163 79.9907    0.273929 -0.832493 0.481579    0 0
  v -25.915 -41.1414 79.9386    0.157756 -0.894992 0.417256    0 0
  v -24.9301 -41.2091 79.0083    0.308468 -0.917142 0.252386    0 0
  v -24.9471 -41.0434 79.5011    0.368576 -0.84924 0.378078    0 0
  v -25.064 -40.8435 79.9595    0.40032 -0.748745 0.528323    0 0
  v -24.4817 -40.8548 79.3752    0.503997 -0.75891 0.412361    0 0
  v -25.7546 -40.8323 80.363    0.239338 -0.736187 0.633045    0 0
  v -24.0833 -41.0163 78.239    0.526288 -0.832492 0.173142    0 0
  v -24.4812 -41.1809 78.4244    0.37876 -0.907782 0.180201    0 0
  v -24.0242 -40.8435 78.6886    0.597133 -0.748744 0.287775    0 0
  v -24.4504 -41.0434 78.894    0.443577 -0.849239 0.286414    0 0
  v -26.4818 -39.6695 81.2144    0.0849211 -0.301051 0.949819    0 0
  v -26.02 -40.0291 81.0097    0.200934 -0.396917 0.89559    0 0
  v -27.4791 -39.6695 81.1766    -0.153904 -0.301666 0.94091    0 0
  v -26.9765 -40.0298 81.0936    -0.0354563 -0.401606 0.915126    0 0
  v -26.9616 -40.62 80.7392    -0.0343617 -0.640249 0.767399    0 0
  v -26.5086 -40.3449 80.9234    0.0727678 -0.51225 0.855748    0 0
  v -27.4313 -40.3472 80.8841    -0.137944 -0.51932 0.843373    0 0
  v -26.0943 -40.6125 80.6764    0.165608 -0.627513 0.76079    0 0
  v -29.2836 -39.6695 80.3803    -0.603949 -0.300624 0.738154    0 0
  v -28.809 -40.0291 80.5535    -0.475802 -0.39692 0.784899    0 0
  v -28.4365 -39.6695 80.8947    -0.383115 -0.301056 0.873263    0 0
  v -28.6324 -40.6125 80.2612    -0.399376 -0.627507 0.668381    0 0
  v -28.3184 -40.3449 80.6274    -0.341632 -0.512251 0.787964    0 0
  v -29.1011 -40.3427 80.1572    -0.546535 -0.505062 0.667991    0 0
  v -27.9291 -40.0298 80.9378    -0.257962 -0.401598 0.878735    0 0
  v -27.8303 -40.62 80.5971    -0.211931 -0.640251 0.738352    0 0
  v -27.992 -41.1809 79.7518    -0.164797 -0.907782 0.385712    0 0
  v -28.4131 -41.0163 79.876    -0.280101 -0.83249 0.478021    0 0
  v -28.5673 -41.1414 79.5048    -0.282477 -0.894992 0.345248    0 0
  v -27.2691 -41.2091 79.8926    -0.0643384 -0.917141 0.393337    0 0
  v -27.7044 -41.0434 80.1243    -0.143133 -0.84924 0.508236    0 0
  v -28.1599 -40.8435 80.2522    -0.257385 -0.748742 0.610851    0 0
  v -27.3626 -40.8548 80.4644    -0.105116 -0.758911 0.642655    0 0
  v -28.8545 -40.8323 79.8559    -0.428563 -0.736184 0.5238    0 0
  v -26.1794 -41.0163 80.2413    0.1132 -0.83249 0.542352    0 0
  v -26.539 -41.1809 79.9894    0.0333214 -0.907783 0.418115    0 0
  v -26.5393 -40.8435 80.5173    0.049349 -0.748745 0.661019    0 0
  v -26.9303 -41.0434 80.2509    -0.0262547 -0.849239 0.527356    0 0
  v -29.9555 -39.6695 79.6519    -0.780106 -0.301051 0.548455    0 0
  v -29.5473 -40.0291 79.9494    -0.67514 -0.396913 0.621808    0 0
  v -30.4214 -39.6695 78.7692    -0.891802 -0.301669 0.337172    0 0
  v -30.0983 -40.0298 79.163    -0.810252 -0.401599 0.42686    0 0
  v -29.7838 -40.62 78.9987    -0.681767 -0.640251 0.353938    0 0
  v -29.7169 -40.3449 79.4831    -0.704714 -0.512248 0.490898    0 0
  v -30.1442 -40.3472 78.6644    -0.799355 -0.519322 0.30222    0 0
  v -29.2958 -40.6125 79.7185    -0.576058 -0.62751 0.523821    0 0
  v -30.6341 -39.6695 76.8084    -0.941234 -0.300626 -0.153955    0 0
  v -30.5467 -40.0291 77.306    -0.917645 -0.396917 -0.0196086    0 0
  v -30.656 -39.6695 77.7992    -0.947826 -0.301055 0.104843    0 0
  v -30.2053 -40.6125 77.3128    -0.778523 -0.627507 -0.0116785    0 0
  v -30.3654 -40.3449 77.7679    -0.853214 -0.512248 0.0981227    0 0
  v -30.3496 -40.3427 76.8549    -0.851767 -0.505057 -0.139321    0 0
  v -30.4396 -40.0298 78.2602    -0.889988 -0.401598 0.215965    0 0
  v -30.0951 -40.62 78.1754    -0.745396 -0.640251 0.185642    0 0
  v -29.4439 -41.1809 77.6127    -0.416436 -0.907782 0.0501344    0 0
  v -29.762 -41.0163 77.3101    -0.554025 -0.832492 -0.0035613    0 0
  v -29.5177 -41.1414 76.991    -0.440232 -0.894992 -0.0720074    0 0
  v -29.2044 -41.2091 78.3091    -0.372807 -0.917141 0.140951    0 0
  v -29.6227 -41.0434 78.048    -0.511713 -0.849239 0.130161    0 0
  v -29.9613 -40.8435 77.7175    -0.657702 -0.748744 0.082525    0 0
  v -29.7464 -40.8548 78.514    -0.609115 -0.75891 0.230293    0 0
  v -29.9654 -40.8323 76.9178    -0.667906 -0.736184 -0.109247    0 0
  v -28.9616 -41.0163 79.4272    -0.413091 -0.832491 0.369209    0 0
  v -28.9232 -41.1809 78.9898    -0.345441 -0.907782 0.237915    0 0
  v -29.3806 -40.8435 79.2535    -0.547783 -0.748747 0.373245    0 0
  v -29.3454 -41.0434 78.7817    -0.469829 -0.84924 0.240941    0 0
  v -30.3392 -39.6695 75.8623    -0.865027 -0.301057 -0.401363    0 0
  v -30.3928 -40.0291 76.3646    -0.876071 -0.396916 -0.273783    0 0
  v -29.8077 -39.6695 75.0175    -0.737899 -0.30167 -0.603738    0 0
  v -29.9872 -40.0298 75.4942    -0.774798 -0.4016 -0.488269    0 0
  v -29.6877 -40.62 75.6844    -0.647405 -0.640251 -0.413456    0 0
  v -30.0737 -40.3449 75.9845    -0.777487 -0.512248 -0.364851    0 0
  v -29.5783 -40.3472 75.2052    -0.661408 -0.519318 -0.541155    0 0
  v -30.067 -40.6125 76.4669    -0.741673 -0.627507 -0.236974    0 0
  v -28.2159 -39.6695 73.8529    -0.337289 -0.300626 -0.89211    0 0
  v -28.6032 -40.0291 74.1773    -0.44184 -0.396921 -0.804507    0 0
  v -29.0849 -39.6695 74.3293    -0.564711 -0.301056 -0.768418    0 0
  v -28.4384 -40.6125 74.4764    -0.379145 -0.627509 -0.68006    0 0
  v -28.9125 -40.3449 74.5653    -0.511587 -0.512242 -0.689846    0 0
  v -28.114 -40.3427 74.1225    -0.305233 -0.505054 -0.807312    0 0
  v -29.376 -40.0298 74.7472    -0.632024 -0.401601 -0.662769    0 0
  v -29.1303 -40.62 75.0031    -0.533471 -0.640248 -0.552712    0 0
  v -28.3174 -41.1809 75.2858    -0.251635 -0.907783 -0.335573    0 0
  v -28.2144 -41.0163 74.859    -0.273928 -0.832489 -0.481586    0 0
  v -27.8159 -41.1414 74.911    -0.157756 -0.894992 -0.417256    0 0
  v -28.8008 -41.2091 75.8414    -0.30847 -0.917141 -0.252387    0 0
  v -28.7838 -41.0434 75.3485    -0.368579 -0.84924 -0.378075    0 0
  v -28.6669 -40.8435 74.8901    -0.400317 -0.748745 -0.528324    0 0
  v -29.2492 -40.8548 75.4745    -0.503998 -0.75891 -0.412362    0 0
  v -27.9763 -40.8323 74.4867    -0.239344 -0.736186 -0.633044    0 0
  v -29.6476 -41.0163 76.6107    -0.526288 -0.832492 -0.173142    0 0
  v -29.2497 -41.1809 76.4252    -0.37876 -0.907782 -0.180201    0 0
  v -29.7067 -40.8435 76.161    -0.597133 -0.748744 -0.287775    0 0
  v -29.2805 -41.0434 75.9556    -0.443577 -0.849239 -0.286414    0 0
  v -27.2491 -39.6695 73.6352    -0.0849211 -0.30105 -0.949819    0 0
  v -27.7109 -40.0291 73.84    -0.200936 -0.396917 -0.89559    0 0
  v -26.2518 -39.6695 73.6731    0.153903 -0.301674 -0.940907    0 0
  v -26.7544 -40.0298 73.756    0.0354565 -0.401599 -0.915129    0 0
  v -26.7693 -40.62 74.1105    0.0343616 -0.640253 -0.767395    0 0
  v -27.2223 -40.3449 73.9262    -0.0727727 -0.512251 -0.855747    0 0
  v -26.2996 -40.3472 73.9656    0.137951 -0.519319 -0.843373    0 0
  v -27.6366 -40.6125 74.1733    -0.165609 -0.627509 -0.760793    0 0
  v -24.9219 -40.0291 74.2962    0.475803 -0.39692 -0.784898    0 0
  v -25.2944 -39.6695 73.9549    0.383115 -0.301056 -0.873263    0 0
  v -25.0985 -40.6125 74.5884    0.399375 -0.62751 -0.668379    0 0
  v -25.4125 -40.3449 74.2222    0.341631 -0.512244 -0.787968    0 0
  v -25.8018 -40.0298 73.9118    0.257962 -0.4016 -0.878734    0 0
  v -25.9006 -40.62 74.2526    0.211926 -0.640248 -0.738357    0 0
  v -25.7389 -41.1809 75.0979    0.164798 -0.907782 -0.385712    0 0
  v -25.3178 -41.0163 74.9737    0.280098 -0.832488 -0.478027    0 0
  v -26.4618 -41.2091 74.957    0.0643386 -0.917141 -0.393337    0 0
  v -26.0265 -41.0434 74.7253    0.143133 -0.849241 -0.508236    0 0
  v -25.571 -40.8435 74.5974    0.257386 -0.748747 -0.610844    0 0
  v -26.3683 -40.8548 74.3853    0.105116 -0.758911 -0.642655    0 0
  v -27.5515 -41.0163 74.6083    -0.1132 -0.832491 -0.542351    0 0
  v -27.1919 -41.1809 74.8602    -0.0333209 -0.907781 -0.418119    0 0
  v -27.1916 -40.8435 74.3323    -0.0493464 -0.748744 -0.66102    0 0
  v -26.8006 -41.0434 74.5987    0.0262547 -0.849239 -0.527356    0 0
  t 5 482 242
  t 242 485 5
  t 122 483 242
  t 242 482 122
  t 62 484 242
  t 242 483 62
  t 125 485 242
  t 242 484 125
  t 36 486 243
  t 243 488 36
  t 123 487 243
  t 243 486 123
  t 62 483 243
  t 243 487 62
  t 122 488 243
  t 243 483 122
  t 18 489 244
  t 244 491 18
  t 124 490 244
  t 244 489 124
  t 62 487 244
  t 244 490 62
  t 123 491 244
  t 244 487 123
  t 37 492 245
  t 245 493 37
  t 125 484 245
  t 245 492 125
  t 62 490 245
  t 245 484 62
  t 124 493 245
  t 245 490 124
  t 4 494 246
  t 246 497 4
  t 126 495 246
  t 246 494 126
  t 63 496 246
  t 246 495 63
  t 128 497 246
  t 246 496 128
  t 35 498 247
  t 247 500 35
  t 127 499 247
  t 247 498 127
  t 63 495 247
  t 247 499 63
  t 126 500 247
  t 247 495 126
  t 18 491 248
  t 248 502 18
  t 123 501 248
  t 248 491 123
  t 63 499 248
  t 248 501 63
  t 127 502 248
  t 248 499 127
  t 36 503 249
  t 249 486 36
  t 128 496 249
  t 249 503 128
  t 63 501 249
  t 249 496 63
  t 123 486 249
  t 249 501 123
  t 3 504 250
  t 250 507 3
  t 129 505 250
  t 250 504 129
  t 64 506 250
  t 250 505 64
  t 131 507 250
  t 250 506 131
  t 34 508 251
  t 251 510 34
  t 130 509 251
  t 251 508 130
  t 64 505 251
  t 251 509 64
  t 129 510 251
  t 251 505 129
  t 18 502 252
  t 252 512 18
  t 127 511 252
  t 252 502 127
  t 64 509 252
  t 252 511 64
  t 130 512 252
  t 252 509 130
  t 35 513 253
  t 253 498 35
  t 131 506 253
  t 253 513 131
  t 64 511 253
  t 253 506 64
  t 127 498 253
  t 253 511 127
  t 2 514 254
  t 254 517 2
  t 132 515 254
  t 254 514 132
  t 65 516 254
  t 254 515 65
  t 134 517 254
  t 254 516 134
  t 33 518 255
  t 255 520 33
  t 133 519 255
  t 255 518 133
  t 65 515 255
  t 255 519 65
  t 132 520 255
  t 255 515 132
  t 18 512 256
  t 256 522 18
  t 130 521 256
  t 256 512 130
  t 65 519 256
  t 256 521 65
  t 133 522 256
  t 256 519 133
  t 34 523 257
  t 257 508 34
  t 134 516 257
  t 257 523 134
  t 65 521 257
  t 257 516 65
  t 130 508 257
  t 257 521 130
  t 1 524 258
  t 258 527 1
  t 135 525 258
  t 258 524 135
  t 66 526 258
  t 258 525 66
  t 137 527 258
  t 258 526 137
  t 32 528 259
  t 259 530 32
  t 136 529 259
  t 259 528 136
  t 66 525 259
  t 259 529 66
  t 135 530 259
  t 259 525 135
  t 18 522 260
  t 260 532 18
  t 133 531 260
  t 260 522 133
  t 66 529 260
  t 260 531 66
  t 136 532 260
  t 260 529 136
  t 33 533 261
  t 261 518 33
  t 137 526 261
  t 261 533 137
  t 66 531 261
  t 261 526 66
  t 133 518 261
  t 261 531 133
  t 0 534 262
  t 262 537 0
  t 138 535 262
  t 262 534 138
  t 67 536 262
  t 262 535 67
  t 139 537 262
  t 262 536 139
  t 37 493 263
  t 263 539 37
  t 124 538 263
  t 263 493 124
  t 67 535 263
  t 263 538 67
  t 138 539 263
  t 263 535 138
  t 18 532 264
  t 264 489 18
  t 136 540 264
  t 264 532 136
  t 67 538 264
  t 264 540 67
  t 124 489 264
  t 264 538 124
  t 32 541 265
  t 265 528 32
  t 139 536 265
  t 265 541 139
  t 67 540 265
  t 265 536 67
  t 136 528 265
  t 265 540 136
  t 0 537 266
  t 266 544 0
  t 139 542 266
  t 266 537 139
  t 68 543 266
  t 266 542 68
  t 142 544 266
  t 266 543 142
  t 32 545 267
  t 267 541 32
  t 140 546 267
  t 267 545 140
  t 68 542 267
  t 267 546 68
  t 139 541 267
  t 267 542 139
  t 19 547 268
  t 268 549 19
  t 141 548 268
  t 268 547 141
  t 68 546 268
  t 268 548 68
  t 140 549 268
  t 268 546 140
  t 39 550 269
  t 269 551 39
  t 142 543 269
  t 269 550 142
  t 68 548 269
  t 269 543 68
  t 141 551 269
  t 269 548 141
  t 1 552 270
  t 270 524 1
  t 143 553 270
  t 270 552 143
  t 69 554 270
  t 270 553 69
  t 135 524 270
  t 270 554 135
  t 40 555 271
  t 271 557 40
  t 144 556 271
  t 271 555 144
  t 69 553 271
  t 271 556 69
  t 143 557 271
  t 271 553 143
  t 19 549 272
  t 272 559 19
  t 140 558 272
  t 272 549 140
  t 69 556 272
  t 272 558 69
  t 144 559 272
  t 272 556 144
  t 32 530 273
  t 273 545 32
  t 135 554 273
  t 273 530 135
  t 69 558 273
  t 273 554 69
  t 140 545 273
  t 273 558 140
  t 7 560 274
  t 274 563 7
  t 145 561 274
  t 274 560 145
  t 70 562 274
  t 274 561 70
  t 147 563 274
  t 274 562 147
  t 38 564 275
  t 275 566 38
  t 146 565 275
  t 275 564 146
  t 70 561 275
  t 275 565 70
  t 145 566 275
  t 275 561 145
  t 19 559 276
  t 276 568 19
  t 144 567 276
  t 276 559 144
  t 70 565 276
  t 276 567 70
  t 146 568 276
  t 276 565 146
  t 40 569 277
  t 277 555 40
  t 147 562 277
  t 277 569 147
  t 70 567 277
  t 277 562 70
  t 144 555 277
  t 277 567 144
  t 6 570 278
  t 278 573 6
  t 148 571 278
  t 278 570 148
  t 71 572 278
  t 278 571 71
  t 149 573 278
  t 278 572 149
  t 39 551 279
  t 279 575 39
  t 141 574 279
  t 279 551 141
  t 71 571 279
  t 279 574 71
  t 148 575 279
  t 279 571 148
  t 19 568 280
  t 280 547 19
  t 146 576 280
  t 280 568 146
  t 71 574 280
  t 280 576 71
  t 141 547 280
  t 280 574 141
  t 38 577 281
  t 281 564 38
  t 149 572 281
  t 281 577 149
  t 71 576 281
  t 281 572 71
  t 146 564 281
  t 281 576 146
  t 1 527 282
  t 282 552 1
  t 137 578 282
  t 282 527 137
  t 72 579 282
  t 282 578 72
  t 143 552 282
  t 282 579 143
  t 33 580 283
  t 283 533 33
  t 150 581 283
  t 283 580 150
  t 72 578 283
  t 283 581 72
  t 137 533 283
  t 283 578 137
  t 20 582 284
  t 284 584 20
  t 151 583 284
  t 284 582 151
  t 72 581 284
  t 284 583 72
  t 150 584 284
  t 284 581 150
  t 40 557 285
  t 285 585 40
  t 143 579 285
  t 285 557 143
  t 72 583 285
  t 285 579 72
  t 151 585 285
  t 285 583 151
  t 2 586 286
  t 286 514 2
  t 152 587 286
  t 286 586 152
  t 73 588 286
  t 286 587 73
  t 132 514 286
  t 286 588 132
  t 42 589 287
  t 287 591 42
  t 153 590 287
  t 287 589 153
  t 73 587 287
  t 287 590 73
  t 152 591 287
  t 287 587 152
  t 20 584 288
  t 288 593 20
  t 150 592 288
  t 288 584 150
  t 73 590 288
  t 288 592 73
  t 153 593 288
  t 288 590 153
  t 33 520 289
  t 289 580 33
  t 132 588 289
  t 289 520 132
  t 73 592 289
  t 289 588 73
  t 150 580 289
  t 289 592 150
  t 8 594 290
  t 290 597 8
  t 154 595 290
  t 290 594 154
  t 74 596 290
  t 290 595 74
  t 156 597 290
  t 290 596 156
  t 41 598 291
  t 291 600 41
  t 155 599 291
  t 291 598 155
  t 74 595 291
  t 291 599 74
  t 154 600 291
  t 291 595 154
  t 20 593 292
  t 292 602 20
  t 153 601 292
  t 292 593 153
  t 74 599 292
  t 292 601 74
  t 155 602 292
  t 292 599 155
  t 42 603 293
  t 293 589 42
  t 156 596 293
  t 293 603 156
  t 74 601 293
  t 293 596 74
  t 153 589 293
  t 293 601 153
  t 7 563 294
  t 294 606 7
  t 147 604 294
  t 294 563 147
  t 75 605 294
  t 294 604 75
  t 157 606 294
  t 294 605 157
  t 40 585 295
  t 295 569 40
  t 151 607 295
  t 295 585 151
  t 75 604 295
  t 295 607 75
  t 147 569 295
  t 295 604 147
  t 20 602 296
  t 296 582 20
  t 155 608 296
  t 296 602 155
  t 75 607 296
  t 296 608 75
  t 151 582 296
  t 296 607 151
  t 41 609 297
  t 297 598 41
  t 157 605 297
  t 297 609 157
  t 75 608 297
  t 297 605 75
  t 155 598 297
  t 297 608 155
  t 2 517 298
  t 298 586 2
  t 134 610 298
  t 298 517 134
  t 76 611 298
  t 298 610 76
  t 152 586 298
  t 298 611 152
  t 34 612 299
  t 299 523 34
  t 158 613 299
  t 299 612 158
  t 76 610 299
  t 299 613 76
  t 134 523 299
  t 299 610 134
  t 21 614 300
  t 300 616 21
  t 159 615 300
  t 300 614 159
  t 76 613 300
  t 300 615 76
  t 158 616 300
  t 300 613 158
  t 42 591 301
  t 301 617 42
  t 152 611 301
  t 301 591 152
  t 76 615 301
  t 301 611 76
  t 159 617 301
  t 301 615 159
  t 3 618 302
  t 302 504 3
  t 160 619 302
  t 302 618 160
  t 77 620 302
  t 302 619 77
  t 129 504 302
  t 302 620 129
  t 44 621 303
  t 303 623 44
  t 161 622 303
  t 303 621 161
  t 77 619 303
  t 303 622 77
  t 160 623 303
  t 303 619 160
  t 21 616 304
  t 304 625 21
  t 158 624 304
  t 304 616 158
  t 77 622 304
  t 304 624 77
  t 161 625 304
  t 304 622 161
  t 34 510 305
  t 305 612 34
  t 129 620 305
  t 305 510 129
  t 77 624 305
  t 305 620 77
  t 158 612 305
  t 305 624 158
  t 9 626 306
  t 306 629 9
  t 162 627 306
  t 306 626 162
  t 78 628 306
  t 306 627 78
  t 164 629 306
  t 306 628 164
  t 43 630 307
  t 307 632 43
  t 163 631 307
  t 307 630 163
  t 78 627 307
  t 307 631 78
  t 162 632 307
  t 307 627 162
  t 21 625 308
  t 308 634 21
  t 161 633 308
  t 308 625 161
  t 78 631 308
  t 308 633 78
  t 163 634 308
  t 308 631 163
  t 44 635 309
  t 309 621 44
  t 164 628 309
  t 309 635 164
  t 78 633 309
  t 309 628 78
  t 161 621 309
  t 309 633 161
  t 8 597 310
  t 310 638 8
  t 156 636 310
  t 310 597 156
  t 79 637 310
  t 310 636 79
  t 165 638 310
  t 310 637 165
  t 42 617 311
  t 311 603 42
  t 159 639 311
  t 311 617 159
  t 79 636 311
  t 311 639 79
  t 156 603 311
  t 311 636 156
  t 21 634 312
  t 312 614 21
  t 163 640 312
  t 312 634 163
  t 79 639 312
  t 312 640 79
  t 159 614 312
  t 312 639 159
  t 43 641 313
  t 313 630 43
  t 165 637 313
  t 313 641 165
  t 79 640 313
  t 313 637 79
  t 163 630 313
  t 313 640 163
  t 3 507 314
  t 314 618 3
  t 131 642 314
  t 314 507 131
  t 80 643 314
  t 314 642 80
  t 160 618 314
  t 314 643 160
  t 35 644 315
  t 315 513 35
  t 166 645 315
  t 315 644 166
  t 80 642 315
  t 315 645 80
  t 131 513 315
  t 315 642 131
  t 22 646 316
  t 316 648 22
  t 167 647 316
  t 316 646 167
  t 80 645 316
  t 316 647 80
  t 166 648 316
  t 316 645 166
  t 44 623 317
  t 317 649 44
  t 160 643 317
  t 317 623 160
  t 80 647 317
  t 317 643 80
  t 167 649 317
  t 317 647 167
  t 4 650 318
  t 318 494 4
  t 168 651 318
  t 318 650 168
  t 81 652 318
  t 318 651 81
  t 126 494 318
  t 318 652 126
  t 46 653 319
  t 319 655 46
  t 169 654 319
  t 319 653 169
  t 81 651 319
  t 319 654 81
  t 168 655 319
  t 319 651 168
  t 22 648 320
  t 320 657 22
  t 166 656 320
  t 320 648 166
  t 81 654 320
  t 320 656 81
  t 169 657 320
  t 320 654 169
  t 35 500 321
  t 321 644 35
  t 126 652 321
  t 321 500 126
  t 81 656 321
  t 321 652 81
  t 166 644 321
  t 321 656 166
  t 10 658 322
  t 322 661 10
  t 170 659 322
  t 322 658 170
  t 82 660 322
  t 322 659 82
  t 172 661 322
  t 322 660 172
  t 45 662 323
  t 323 664 45
  t 171 663 323
  t 323 662 171
  t 82 659 323
  t 323 663 82
  t 170 664 323
  t 323 659 170
  t 22 657 324
  t 324 666 22
  t 169 665 324
  t 324 657 169
  t 82 663 324
  t 324 665 82
  t 171 666 324
  t 324 663 171
  t 46 667 325
  t 325 653 46
  t 172 660 325
  t 325 667 172
  t 82 665 325
  t 325 660 82
  t 169 653 325
  t 325 665 169
  t 9 629 326
  t 326 670 9
  t 164 668 326
  t 326 629 164
  t 83 669 326
  t 326 668 83
  t 173 670 326
  t 326 669 173
  t 44 649 327
  t 327 635 44
  t 167 671 327
  t 327 649 167
  t 83 668 327
  t 327 671 83
  t 164 635 327
  t 327 668 164
  t 22 666 328
  t 328 646 22
  t 171 672 328
  t 328 666 171
  t 83 671 328
  t 328 672 83
  t 167 646 328
  t 328 671 167
  t 45 673 329
  t 329 662 45
  t 173 669 329
  t 329 673 173
  t 83 672 329
  t 329 669 83
  t 171 662 329
  t 329 672 171
  t 4 497 330
  t 330 650 4
  t 128 674 330
  t 330 497 128
  t 84 675 330
  t 330 674 84
  t 168 650 330
  t 330 675 168
  t 36 676 331
  t 331 503 36
  t 174 677 331
  t 331 676 174
  t 84 674 331
  t 331 677 84
  t 128 503 331
  t 331 674 128
  t 23 678 332
  t 332 680 23
  t 175 679 332
  t 332 678 175
  t 84 677 332
  t 332 679 84
  t 174 680 332
  t 332 677 174
  t 46 655 333
  t 333 681 46
  t 168 675 333
  t 333 655 168
  t 84 679 333
  t 333 675 84
  t 175 681 333
  t 333 679 175
  t 5 682 334
  t 334 482 5
  t 176 683 334
  t 334 682 176
  t 85 684 334
  t 334 683 85
  t 122 482 334
  t 334 684 122
  t 48 685 335
  t 335 687 48
  t 177 686 335
  t 335 685 177
  t 85 683 335
  t 335 686 85
  t 176 687 335
  t 335 683 176
  t 23 680 336
  t 336 689 23
  t 174 688 336
  t 336 680 174
  t 85 686 336
  t 336 688 85
  t 177 689 336
  t 336 686 177
  t 36 488 337
  t 337 676 36
  t 122 684 337
  t 337 488 122
  t 85 688 337
  t 337 684 85
  t 174 676 337
  t 337 688 174
  t 11 690 338
  t 338 693 11
  t 178 691 338
  t 338 690 178
  t 86 692 338
  t 338 691 86
  t 180 693 338
  t 338 692 180
  t 47 694 339
  t 339 696 47
  t 179 695 339
  t 339 694 179
  t 86 691 339
  t 339 695 86
  t 178 696 339
  t 339 691 178
  t 23 689 340
  t 340 698 23
  t 177 697 340
  t 340 689 177
  t 86 695 340
  t 340 697 86
  t 179 698 340
  t 340 695 179
  t 48 699 341
  t 341 685 48
  t 180 692 341
  t 341 699 180
  t 86 697 341
  t 341 692 86
  t 177 685 341
  t 341 697 177
  t 10 661 342
  t 342 702 10
  t 172 700 342
  t 342 661 172
  t 87 701 342
  t 342 700 87
  t 181 702 342
  t 342 701 181
  t 46 681 343
  t 343 667 46
  t 175 703 343
  t 343 681 175
  t 87 700 343
  t 343 703 87
  t 172 667 343
  t 343 700 172
  t 23 698 344
  t 344 678 23
  t 179 704 344
  t 344 698 179
  t 87 703 344
  t 344 704 87
  t 175 678 344
  t 344 703 175
  t 47 705 345
  t 345 694 47
  t 181 701 345
  t 345 705 181
  t 87 704 345
  t 345 701 87
  t 179 694 345
  t 345 704 179
  t 5 485 346
  t 346 682 5
  t 125 706 346
  t 346 485 125
  t 88 707 346
  t 346 706 88
  t 176 682 346
  t 346 707 176
  t 37 708 347
  t 347 492 37
  t 182 709 347
  t 347 708 182
  t 88 706 347
  t 347 709 88
  t 125 492 347
  t 347 706 125
  t 24 710 348
  t 348 712 24
  t 183 711 348
  t 348 710 183
  t 88 709 348
  t 348 711 88
  t 182 712 348
  t 348 709 182
  t 48 687 349
  t 349 713 48
  t 176 707 349
  t 349 687 176
  t 88 711 349
  t 349 707 88
  t 183 713 349
  t 349 711 183
  t 0 544 350
  t 350 534 0
  t 142 714 350
  t 350 544 142
  t 89 715 350
  t 350 714 89
  t 138 534 350
  t 350 715 138
  t 39 716 351
  t 351 550 39
  t 184 717 351
  t 351 716 184
  t 89 714 351
  t 351 717 89
  t 142 550 351
  t 351 714 142
  t 24 712 352
  t 352 719 24
  t 182 718 352
  t 352 712 182
  t 89 717 352
  t 352 718 89
  t 184 719 352
  t 352 717 184
  t 37 539 353
  t 353 708 37
  t 138 715 353
  t 353 539 138
  t 89 718 353
  t 353 715 89
  t 182 708 353
  t 353 718 182
  t 6 720 354
  t 354 570 6
  t 185 721 354
  t 354 720 185
  t 90 722 354
  t 354 721 90
  t 148 570 354
  t 354 722 148
  t 49 723 355
  t 355 725 49
  t 186 724 355
  t 355 723 186
  t 90 721 355
  t 355 724 90
  t 185 725 355
  t 355 721 185
  t 24 719 356
  t 356 727 24
  t 184 726 356
  t 356 719 184
  t 90 724 356
  t 356 726 90
  t 186 727 356
  t 356 724 186
  t 39 575 357
  t 357 716 39
  t 148 722 357
  t 357 575 148
  t 90 726 357
  t 357 722 90
  t 184 716 357
  t 357 726 184
  t 11 693 358
  t 358 730 11
  t 180 728 358
  t 358 693 180
  t 91 729 358
  t 358 728 91
  t 187 730 358
  t 358 729 187
  t 48 713 359
  t 359 699 48
  t 183 731 359
  t 359 713 183
  t 91 728 359
  t 359 731 91
  t 180 699 359
  t 359 728 180
  t 24 727 360
  t 360 710 24
  t 186 732 360
  t 360 727 186
  t 91 731 360
  t 360 732 91
  t 183 710 360
  t 360 731 183
  t 49 733 361
  t 361 723 49
  t 187 729 361
  t 361 733 187
  t 91 732 361
  t 361 729 91
  t 186 723 361
  t 361 732 186
  t 17 734 362
  t 362 737 17
  t 188 735 362
  t 362 734 188
  t 92 736 362
  t 362 735 92
  t 191 737 362
  t 362 736 191
  t 55 738 363
  t 363 740 55
  t 189 739 363
  t 363 738 189
  t 92 735 363
  t 363 739 92
  t 188 740 363
  t 363 735 188
  t 25 741 364
  t 364 743 25
  t 190 742 364
  t 364 741 190
  t 92 739 364
  t 364 742 92
  t 189 743 364
  t 364 739 189
  t 54 744 365
  t 365 745 54
  t 191 736 365
  t 365 744 191
  t 92 742 365
  t 365 736 92
  t 190 745 365
  t 365 742 190
  t 12 746 366
  t 366 749 12
  t 192 747 366
  t 366 746 192
  t 93 748 366
  t 366 747 93
  t 194 749 366
  t 366 748 194
  t 50 750 367
  t 367 752 50
  t 193 751 367
  t 367 750 193
  t 93 747 367
  t 367 751 93
  t 192 752 367
  t 367 747 192
  t 25 743 368
  t 368 754 25
  t 189 753 368
  t 368 743 189
  t 93 751 368
  t 368 753 93
  t 193 754 368
  t 368 751 193
  t 55 755 369
  t 369 738 55
  t 194 748 369
  t 369 755 194
  t 93 753 369
  t 369 748 93
  t 189 738 369
  t 369 753 189
  t 13 756 370
  t 370 759 13
  t 195 757 370
  t 370 756 195
  t 94 758 370
  t 370 757 94
  t 197 759 370
  t 370 758 197
  t 51 760 371
  t 371 762 51
  t 196 761 371
  t 371 760 196
  t 94 757 371
  t 371 761 94
  t 195 762 371
  t 371 757 195
  t 25 754 372
  t 372 764 25
  t 193 763 372
  t 372 754 193
  t 94 761 372
  t 372 763 94
  t 196 764 372
  t 372 761 196
  t 50 765 373
  t 373 750 50
  t 197 758 373
  t 373 765 197
  t 94 763 373
  t 373 758 94
  t 193 750 373
  t 373 763 193
  t 14 766 374
  t 374 769 14
  t 198 767 374
  t 374 766 198
  t 95 768 374
  t 374 767 95
  t 200 769 374
  t 374 768 200
  t 52 770 375
  t 375 772 52
  t 199 771 375
  t 375 770 199
  t 95 767 375
  t 375 771 95
  t 198 772 375
  t 375 767 198
  t 25 764 376
  t 376 774 25
  t 196 773 376
  t 376 764 196
  t 95 771 376
  t 376 773 95
  t 199 774 376
  t 376 771 199
  t 51 775 377
  t 377 760 51
  t 200 768 377
  t 377 775 200
  t 95 773 377
  t 377 768 95
  t 196 760 377
  t 377 773 196
  t 15 776 378
  t 378 779 15
  t 201 777 378
  t 378 776 201
  t 96 778 378
  t 378 777 96
  t 203 779 378
  t 378 778 203
  t 53 780 379
  t 379 782 53
  t 202 781 379
  t 379 780 202
  t 96 777 379
  t 379 781 96
  t 201 782 379
  t 379 777 201
  t 25 774 380
  t 380 784 25
  t 199 783 380
  t 380 774 199
  t 96 781 380
  t 380 783 96
  t 202 784 380
  t 380 781 202
  t 52 785 381
  t 381 770 52
  t 203 778 381
  t 381 785 203
  t 96 783 381
  t 381 778 96
  t 199 770 381
  t 381 783 199
  t 16 786 382
  t 382 789 16
  t 204 787 382
  t 382 786 204
  t 97 788 382
  t 382 787 97
  t 205 789 382
  t 382 788 205
  t 54 745 383
  t 383 791 54
  t 190 790 383
  t 383 745 190
  t 97 787 383
  t 383 790 97
  t 204 791 383
  t 383 787 204
  t 25 784 384
  t 384 741 25
  t 202 792 384
  t 384 784 202
  t 97 790 384
  t 384 792 97
  t 190 741 384
  t 384 790 190
  t 53 793 385
  t 385 780 53
  t 205 788 385
  t 385 793 205
  t 97 792 385
  t 385 788 97
  t 202 780 385
  t 385 792 202
  t 6 573 386
  t 386 796 6
  t 149 794 386
  t 386 573 149
  t 98 795 386
  t 386 794 98
  t 208 796 386
  t 386 795 208
  t 38 797 387
  t 387 577 38
  t 206 798 387
  t 387 797 206
  t 98 794 387
  t 387 798 98
  t 149 577 387
  t 387 794 149
  t 26 799 388
  t 388 801 26
  t 207 800 388
  t 388 799 207
  t 98 798 388
  t 388 800 98
  t 206 801 388
  t 388 798 206
  t 57 802 389
  t 389 803 57
  t 208 795 389
  t 389 802 208
  t 98 800 389
  t 389 795 98
  t 207 803 389
  t 389 800 207
  t 7 804 390
  t 390 560 7
  t 209 805 390
  t 390 804 209
  t 99 806 390
  t 390 805 99
  t 145 560 390
  t 390 806 145
  t 56 807 391
  t 391 809 56
  t 210 808 391
  t 391 807 210
  t 99 805 391
  t 391 808 99
  t 209 809 391
  t 391 805 209
  t 26 801 392
  t 392 811 26
  t 206 810 392
  t 392 801 206
  t 99 808 392
  t 392 810 99
  t 210 811 392
  t 392 808 210
  t 38 566 393
  t 393 797 38
  t 145 806 393
  t 393 566 145
  t 99 810 393
  t 393 806 99
  t 206 797 393
  t 393 810 206
  t 13 759 394
  t 394 814 13
  t 197 812 394
  t 394 759 197
  t 100 813 394
  t 394 812 100
  t 212 814 394
  t 394 813 212
  t 50 815 395
  t 395 765 50
  t 211 816 395
  t 395 815 211
  t 100 812 395
  t 395 816 100
  t 197 765 395
  t 395 812 197
  t 26 811 396
  t 396 818 26
  t 210 817 396
  t 396 811 210
  t 100 816 396
  t 396 817 100
  t 211 818 396
  t 396 816 211
  t 56 819 397
  t 397 807 56
  t 212 813 397
  t 397 819 212
  t 100 817 397
  t 397 813 100
  t 210 807 397
  t 397 817 210
  t 12 820 398
  t 398 746 12
  t 213 821 398
  t 398 820 213
  t 101 822 398
  t 398 821 101
  t 192 746 398
  t 398 822 192
  t 57 803 399
  t 399 824 57
  t 207 823 399
  t 399 803 207
  t 101 821 399
  t 399 823 101
  t 213 824 399
  t 399 821 213
  t 26 818 400
  t 400 799 26
  t 211 825 400
  t 400 818 211
  t 101 823 400
  t 400 825 101
  t 207 799 400
  t 400 823 207
  t 50 752 401
  t 401 815 50
  t 192 822 401
  t 401 752 192
  t 101 825 401
  t 401 822 101
  t 211 815 401
  t 401 825 211
  t 7 606 402
  t 402 804 7
  t 157 826 402
  t 402 606 157
  t 102 827 402
  t 402 826 102
  t 209 804 402
  t 402 827 209
  t 41 828 403
  t 403 609 41
  t 214 829 403
  t 403 828 214
  t 102 826 403
  t 403 829 102
  t 157 609 403
  t 403 826 157
  t 27 830 404
  t 404 832 27
  t 215 831 404
  t 404 830 215
  t 102 829 404
  t 404 831 102
  t 214 832 404
  t 404 829 214
  t 56 809 405
  t 405 833 56
  t 209 827 405
  t 405 809 209
  t 102 831 405
  t 405 827 102
  t 215 833 405
  t 405 831 215
  t 8 834 406
  t 406 594 8
  t 216 835 406
  t 406 834 216
  t 103 836 406
  t 406 835 103
  t 154 594 406
  t 406 836 154
  t 58 837 407
  t 407 839 58
  t 217 838 407
  t 407 837 217
  t 103 835 407
  t 407 838 103
  t 216 839 407
  t 407 835 216
  t 27 832 408
  t 408 841 27
  t 214 840 408
  t 408 832 214
  t 103 838 408
  t 408 840 103
  t 217 841 408
  t 408 838 217
  t 41 600 409
  t 409 828 41
  t 154 836 409
  t 409 600 154
  t 103 840 409
  t 409 836 103
  t 214 828 409
  t 409 840 214
  t 14 769 410
  t 410 844 14
  t 200 842 410
  t 410 769 200
  t 104 843 410
  t 410 842 104
  t 219 844 410
  t 410 843 219
  t 51 845 411
  t 411 775 51
  t 218 846 411
  t 411 845 218
  t 104 842 411
  t 411 846 104
  t 200 775 411
  t 411 842 200
  t 27 841 412
  t 412 848 27
  t 217 847 412
  t 412 841 217
  t 104 846 412
  t 412 847 104
  t 218 848 412
  t 412 846 218
  t 58 849 413
  t 413 837 58
  t 219 843 413
  t 413 849 219
  t 104 847 413
  t 413 843 104
  t 217 837 413
  t 413 847 217
  t 13 814 414
  t 414 756 13
  t 212 850 414
  t 414 814 212
  t 105 851 414
  t 414 850 105
  t 195 756 414
  t 414 851 195
  t 56 833 415
  t 415 819 56
  t 215 852 415
  t 415 833 215
  t 105 850 415
  t 415 852 105
  t 212 819 415
  t 415 850 212
  t 27 848 416
  t 416 830 27
  t 218 853 416
  t 416 848 218
  t 105 852 416
  t 416 853 105
  t 215 830 416
  t 416 852 215
  t 51 762 417
  t 417 845 51
  t 195 851 417
  t 417 762 195
  t 105 853 417
  t 417 851 105
  t 218 845 417
  t 417 853 218
  t 8 638 418
  t 418 834 8
  t 165 854 418
  t 418 638 165
  t 106 855 418
  t 418 854 106
  t 216 834 418
  t 418 855 216
  t 43 856 419
  t 419 641 43
  t 220 857 419
  t 419 856 220
  t 106 854 419
  t 419 857 106
  t 165 641 419
  t 419 854 165
  t 28 858 420
  t 420 860 28
  t 221 859 420
  t 420 858 221
  t 106 857 420
  t 420 859 106
  t 220 860 420
  t 420 857 220
  t 58 839 421
  t 421 861 58
  t 216 855 421
  t 421 839 216
  t 106 859 421
  t 421 855 106
  t 221 861 421
  t 421 859 221
  t 9 862 422
  t 422 626 9
  t 222 863 422
  t 422 862 222
  t 107 864 422
  t 422 863 107
  t 162 626 422
  t 422 864 162
  t 59 865 423
  t 423 867 59
  t 223 866 423
  t 423 865 223
  t 107 863 423
  t 423 866 107
  t 222 867 423
  t 423 863 222
  t 28 860 424
  t 424 869 28
  t 220 868 424
  t 424 860 220
  t 107 866 424
  t 424 868 107
  t 223 869 424
  t 424 866 223
  t 43 632 425
  t 425 856 43
  t 162 864 425
  t 425 632 162
  t 107 868 425
  t 425 864 107
  t 220 856 425
  t 425 868 220
  t 15 779 426
  t 426 872 15
  t 203 870 426
  t 426 779 203
  t 108 871 426
  t 426 870 108
  t 225 872 426
  t 426 871 225
  t 52 873 427
  t 427 785 52
  t 224 874 427
  t 427 873 224
  t 108 870 427
  t 427 874 108
  t 203 785 427
  t 427 870 203
  t 28 869 428
  t 428 876 28
  t 223 875 428
  t 428 869 223
  t 108 874 428
  t 428 875 108
  t 224 876 428
  t 428 874 224
  t 59 877 429
  t 429 865 59
  t 225 871 429
  t 429 877 225
  t 108 875 429
  t 429 871 108
  t 223 865 429
  t 429 875 223
  t 14 844 430
  t 430 766 14
  t 219 878 430
  t 430 844 219
  t 109 879 430
  t 430 878 109
  t 198 766 430
  t 430 879 198
  t 58 861 431
  t 431 849 58
  t 221 880 431
  t 431 861 221
  t 109 878 431
  t 431 880 109
  t 219 849 431
  t 431 878 219
  t 28 876 432
  t 432 858 28
  t 224 881 432
  t 432 876 224
  t 109 880 432
  t 432 881 109
  t 221 858 432
  t 432 880 221
  t 52 772 433
  t 433 873 52
  t 198 879 433
  t 433 772 198
  t 109 881 433
  t 433 879 109
  t 224 873 433
  t 433 881 224
  t 9 670 434
  t 434 862 9
  t 173 882 434
  t 434 670 173
  t 110 883 434
  t 434 882 110
  t 222 862 434
  t 434 883 222
  t 45 884 435
  t 435 673 45
  t 226 885 435
  t 435 884 226
  t 110 882 435
  t 435 885 110
  t 173 673 435
  t 435 882 173
  t 29 886 436
  t 436 888 29
  t 227 887 436
  t 436 886 227
  t 110 885 436
  t 436 887 110
  t 226 888 436
  t 436 885 226
  t 59 867 437
  t 437 889 59
  t 222 883 437
  t 437 867 222
  t 110 887 437
  t 437 883 110
  t 227 889 437
  t 437 887 227
  t 10 890 438
  t 438 658 10
  t 228 891 438
  t 438 890 228
  t 111 892 438
  t 438 891 111
  t 170 658 438
  t 438 892 170
  t 60 893 439
  t 439 895 60
  t 229 894 439
  t 439 893 229
  t 111 891 439
  t 439 894 111
  t 228 895 439
  t 439 891 228
  t 29 888 440
  t 440 897 29
  t 226 896 440
  t 440 888 226
  t 111 894 440
  t 440 896 111
  t 229 897 440
  t 440 894 229
  t 45 664 441
  t 441 884 45
  t 170 892 441
  t 441 664 170
  t 111 896 441
  t 441 892 111
  t 226 884 441
  t 441 896 226
  t 16 789 442
  t 442 900 16
  t 205 898 442
  t 442 789 205
  t 112 899 442
  t 442 898 112
  t 231 900 442
  t 442 899 231
  t 53 901 443
  t 443 793 53
  t 230 902 443
  t 443 901 230
  t 112 898 443
  t 443 902 112
  t 205 793 443
  t 443 898 205
  t 29 897 444
  t 444 904 29
  t 229 903 444
  t 444 897 229
  t 112 902 444
  t 444 903 112
  t 230 904 444
  t 444 902 230
  t 60 905 445
  t 445 893 60
  t 231 899 445
  t 445 905 231
  t 112 903 445
  t 445 899 112
  t 229 893 445
  t 445 903 229
  t 15 872 446
  t 446 776 15
  t 225 906 446
  t 446 872 225
  t 113 907 446
  t 446 906 113
  t 201 776 446
  t 446 907 201
  t 59 889 447
  t 447 877 59
  t 227 908 447
  t 447 889 227
  t 113 906 447
  t 447 908 113
  t 225 877 447
  t 447 906 225
  t 29 904 448
  t 448 886 29
  t 230 909 448
  t 448 904 230
  t 113 908 448
  t 448 909 113
  t 227 886 448
  t 448 908 227
  t 53 782 449
  t 449 901 53
  t 201 907 449
  t 449 782 201
  t 113 909 449
  t 449 907 113
  t 230 901 449
  t 449 909 230
  t 10 702 450
  t 450 890 10
  t 181 910 450
  t 450 702 181
  t 114 911 450
  t 450 910 114
  t 228 890 450
  t 450 911 228
  t 47 912 451
  t 451 705 47
  t 232 913 451
  t 451 912 232
  t 114 910 451
  t 451 913 114
  t 181 705 451
  t 451 910 181
  t 30 914 452
  t 452 916 30
  t 233 915 452
  t 452 914 233
  t 114 913 452
  t 452 915 114
  t 232 916 452
  t 452 913 232
  t 60 895 453
  t 453 917 60
  t 228 911 453
  t 453 895 228
  t 114 915 453
  t 453 911 114
  t 233 917 453
  t 453 915 233
  t 11 918 454
  t 454 690 11
  t 234 919 454
  t 454 918 234
  t 115 920 454
  t 454 919 115
  t 178 690 454
  t 454 920 178
  t 61 921 455
  t 455 923 61
  t 235 922 455
  t 455 921 235
  t 115 919 455
  t 455 922 115
  t 234 923 455
  t 455 919 234
  t 30 916 456
  t 456 925 30
  t 232 924 456
  t 456 916 232
  t 115 922 456
  t 456 924 115
  t 235 925 456
  t 456 922 235
  t 47 696 457
  t 457 912 47
  t 178 920 457
  t 457 696 178
  t 115 924 457
  t 457 920 115
  t 232 912 457
  t 457 924 232
  t 17 737 458
  t 458 928 17
  t 191 926 458
  t 458 737 191
  t 116 927 458
  t 458 926 116
  t 237 928 458
  t 458 927 237
  t 54 929 459
  t 459 744 54
  t 236 930 459
  t 459 929 236
  t 116 926 459
  t 459 930 116
  t 191 744 459
  t 459 926 191
  t 30 925 460
  t 460 932 30
  t 235 931 460
  t 460 925 235
  t 116 930 460
  t 460 931 116
  t 236 932 460
  t 460 930 236
  t 61 933 461
  t 461 921 61
  t 237 927 461
  t 461 933 237
  t 116 931 461
  t 461 927 116
  t 235 921 461
  t 461 931 235
  t 16 900 462
  t 462 786 16
  t 231 934 462
  t 462 900 231
  t 117 935 462
  t 462 934 117
  t 204 786 462
  t 462 935 204
  t 60 917 463
  t 463 905 60
  t 233 936 463
  t 463 917 233
  t 117 934 463
  t 463 936 117
  t 231 905 463
  t 463 934 231
  t 30 932 464
  t 464 914 30
  t 236 937 464
  t 464 932 236
  t 117 936 464
  t 464 937 117
  t 233 914 464
  t 464 936 233
  t 54 791 465
  t 465 929 54
  t 204 935 465
  t 465 791 204
  t 117 937 465
  t 465 935 117
  t 236 929 465
  t 465 937 236
  t 11 730 466
  t 466 918 11
  t 187 938 466
  t 466 730 187
  t 118 939 466
  t 466 938 118
  t 234 918 466
  t 466 939 234
  t 49 940 467
  t 467 733 49
  t 238 941 467
  t 467 940 238
  t 118 938 467
  t 467 941 118
  t 187 733 467
  t 467 938 187
  t 31 942 468
  t 468 944 31
  t 239 943 468
  t 468 942 239
  t 118 941 468
  t 468 943 118
  t 238 944 468
  t 468 941 238
  t 61 923 469
  t 469 945 61
  t 234 939 469
  t 469 923 234
  t 118 943 469
  t 469 939 118
  t 239 945 469
  t 469 943 239
  t 6 796 470
  t 470 720 6
  t 208 946 470
  t 470 796 208
  t 119 947 470
  t 470 946 119
  t 185 720 470
  t 470 947 185
  t 57 948 471
  t 471 802 57
  t 240 949 471
  t 471 948 240
  t 119 946 471
  t 471 949 119
  t 208 802 471
  t 471 946 208
  t 31 944 472
  t 472 951 31
  t 238 950 472
  t 472 944 238
  t 119 949 472
  t 472 950 119
  t 240 951 472
  t 472 949 240
  t 49 725 473
  t 473 940 49
  t 185 947 473
  t 473 725 185
  t 119 950 473
  t 473 947 119
  t 238 940 473
  t 473 950 238
  t 12 749 474
  t 474 820 12
  t 194 952 474
  t 474 749 194
  t 120 953 474
  t 474 952 120
  t 213 820 474
  t 474 953 213
  t 55 954 475
  t 475 755 55
  t 241 955 475
  t 475 954 241
  t 120 952 475
  t 475 955 120
  t 194 755 475
  t 475 952 194
  t 31 951 476
  t 476 957 31
  t 240 956 476
  t 476 951 240
  t 120 955 476
  t 476 956 120
  t 241 957 476
  t 476 955 241
  t 57 824 477
  t 477 948 57
  t 213 953 477
  t 477 824 213
  t 120 956 477
  t 477 953 120
  t 240 948 477
  t 477 956 240
  t 17 928 478
  t 478 734 17
  t 237 958 478
  t 478 928 237
  t 121 959 478
  t 478 958 121
  t 188 734 478
  t 478 959 188
  t 61 945 479
  t 479 933 61
  t 239 960 479
  t 479 945 239
  t 121 958 479
  t 479 960 121
  t 237 933 479
  t 479 958 237
  t 31 957 480
  t 480 942 31
  t 241 961 480
  t 480 957 241
  t 121 960 480
  t 480 961 121
  t 239 942 480
  t 480 960 239
  t 55 740 481
  t 481 954 55
  t 188 959 481
  t 481 740 188
  t 121 961 481
  t 481 959 121
  t 241 954 481
  t 481 961 241
}

object {
  shader 1---Default
  type mesh
  name Sphere02
  5442 10320
  v -121.744 75.4883 107.225    0.19626 -0.456562 0.867775    0 0
  v -115.147 79.6731 107.221    0.314302 -0.3142 0.89582    0 0
  v -111.55 85.317 107.279    0.38288 -0.1209 0.915853    0 0
  v -111.491 91.2764 107.225    0.392252 0.106262 0.913699    0 0
  v -115.262 97.1311 107.292    0.307236 0.319018 0.896568    0 0
  v -121.744 101.335 107.225    0.19626 0.456562 0.867775    0 0
  v -115.257 65.7942 97.0649    0.262129 -0.735408 0.62487    0 0
  v -103.401 72.7601 97.0565    0.505636 -0.54262 0.670742    0 0
  v -96.5677 82.8296 102.673    -0.273779 0.0818371 0.958305    0 0
  v -96.7866 93.0849 97.0404    0.665175 0.217747 0.714233    0 0
  v -103.405 103.833 97.0612    0.521273 0.521647 0.675395    0 0
  v -115.257 111.029 97.0649    0.262129 0.735409 0.62487    0 0
  v -110.796 59.7117 84.4709    0.260169 -0.913633 0.312389    0 0
  v -95.9059 68.3837 84.5349    0.666491 -0.623169 0.409207    0 0
  v -87.8844 81.4667 84.4835    0.87797 -0.280209 0.388138    0 0
  v -87.9911 95.1075 84.5738    0.871768 0.26858 0.409737    0 0
  v -96.3236 107.891 84.5118    0.639656 0.694813 0.328746    0 0
  v -111.336 116.626 84.5105    0.321288 0.912704 0.252478    0 0
  v -110.076 59.3775 69.245    0.289255 -0.922756 -0.254664    0 0
  v -94.0575 68.3324 69.718    0.688154 -0.664177 -0.292085    0 0
  v -85.8769 81.4567 69.5609    0.925937 -0.306959 -0.220037    0 0
  v -85.8769 95.3663 69.5609    0.925938 0.306958 -0.220037    0 0
  v -94.6827 107.898 69.5609    0.637358 0.738883 -0.218693    0 0
  v -110.427 116.58 69.5512    0.313767 0.923207 -0.221899    0 0
  v -114.348 66.1814 56.0335    0.255152 -0.671139 -0.696038    0 0
  v -102.401 72.9567 56.1425    0.433947 -0.497364 -0.751212    0 0
  v -95.5018 82.8957 56.1425    0.550673 -0.180701 -0.814927    0 0
  v -95.5018 93.9272 56.1425    0.550673 0.180701 -0.814927    0 0
  v -102.401 103.866 56.1425    0.433947 0.497364 -0.751212    0 0
  v -114.711 110.731 56.1403    0.238946 0.698952 -0.674071    0 0
  v -123.368 75.4729 47.5221    0.198242 -0.467564 -0.861443    0 0
  v -118.001 79.44 47.5221    0.296243 -0.276046 -0.914351    0 0
  v -114.955 85.2096 47.5221    0.326794 -0.0872127 -0.941063    0 0
  v -114.955 91.6134 47.5221    0.326794 0.0872127 -0.941063    0 0
  v -118.001 97.383 47.5221    0.296243 0.276046 -0.914352    0 0
  v -123.368 101.35 47.5221    0.198243 0.467564 -0.861443    0 0
  v -94.6677 79.4994 99.9867    -0.0134834 -0.967395 0.252912    0 0
  v -90.7456 81.8668 97.1437    0.913808 -0.282385 -0.291914    0 0
  v -92.8688 85.0876 100.012    0.349027 0.883653 0.31199    0 0
  v -83.974 79.1534 113.968    -0.780348 0.171979 0.601232    0 0
  v -83.1182 77.7397 113.184    -0.216433 -0.968165 -0.125753    0 0
  v -81.3228 78.7763 112.561    0.730802 -0.147461 -0.666471    0 0
  v -82.3965 80.2118 113.407    0.170291 0.98357 0.0599249    0 0
  v -81.919 78.3036 119.096    -0.955537 0.284535 -0.0773824    0 0
  v -79.9065 75.2796 117.593    -0.358649 -0.709639 -0.606451    0 0
  v -75.8676 77.5334 116.563    0.28536 0.0242311 -0.958114    0 0
  v -78.3321 80.6004 118.202    -0.0968932 0.873668 -0.476776    0 0
  v -81.4917 78.1116 121.885    -0.875798 0.205473 0.436759    0 0
  v -78.4877 73.608 119.656    -0.237684 -0.937249 -0.255091    0 0
  v -72.4546 76.9806 118.107    0.573837 -0.0760026 -0.815435    0 0
  v -76.1173 81.5466 120.556    0.0499432 0.985845 -0.160049    0 0
  v -78.6026 77.5535 125.048    -0.485631 0.0453776 0.872985    0 0
  v -75.6948 73.1936 122.889    -0.00333505 -0.957352 0.288906    0 0
  v -69.8552 76.4575 121.39    0.94235 -0.241827 -0.231293    0 0
  v -73.4016 80.8781 123.761    0.277113 0.875111 0.396723    0 0
  v -74.6105 76.9382 125.99    -0.0059032 -0.112291 0.993658    0 0
  v -73.2971 75.0099 125.024    0.23241 -0.623921 0.746129    0 0
  v -70.7633 76.4445 124.379    0.714861 -0.282227 0.639783    0 0
  v -72.3002 78.3942 125.413    0.401727 0.30226 0.864438    0 0
  v -121.499 103.305 41.5883    0.381082 0.877835 0.290141    0 0
  v -114.877 98.7294 41.5899    0.674627 0.65395 0.342386    0 0
  v -111.23 92.7915 41.6162    0.883635 0.255277 0.392458    0 0
  v -112.204 84.7246 45.232    0.218609 -0.0479802 0.974632    0 0
  v -115.048 77.884 41.6092    0.66894 -0.65967 0.342571    0 0
  v -121.499 73.5177 41.5883    0.381083 -0.877835 0.290141    0 0
  v -120.604 104.294 33.5791    0.394361 0.918571 0.0265704    0 0
  v -113.406 99.2617 33.5794    0.73385 0.678921 0.0230328    0 0
  v -109.531 92.3442 33.5716    0.967055 0.253953 0.0176594    0 0
  v -109.471 84.5651 33.2879    0.968136 -0.250257 0.00920356    0 0
  v -113.409 77.5613 33.5701    0.734758 -0.677891 0.0243806    0 0
  v -120.604 72.5284 33.5791    0.394362 -0.918571 0.0265704    0 0
  v -121.178 103.639 25.0062    0.387614 0.898615 -0.20554    0 0
  v -114.357 98.8225 25.0062    0.718779 0.65229 -0.240572    0 0
  v -110.662 92.0929 25.0062    0.932072 0.241421 -0.270106    0 0
  v -110.662 84.73 25.0062    0.932072 -0.241422 -0.270106    0 0
  v -114.357 78.0005 25.0062    0.718779 -0.65229 -0.240573    0 0
  v -121.178 73.1844 25.0062    0.387614 -0.898615 -0.20554    0 0
  v -122.958 101.604 17.9815    0.335365 0.762689 -0.553024    0 0
  v -117.296 97.5425 17.9815    0.585824 0.52704 -0.615661    0 0
  v -114.108 91.6602 17.9793    0.725805 0.185477 -0.662424    0 0
  v -113.93 85.1324 18.076    0.741751 -0.191094 -0.642875    0 0
  v -117.299 79.2845 17.9793    0.585932 -0.525855 -0.616571    0 0
  v -122.958 75.2186 17.9815    0.335365 -0.762689 -0.553024    0 0
  v -126.05 98.1595 14.1073    0.217589 0.421988 -0.880103    0 0
  v -122.425 95.3174 14.0763    0.306752 0.277276 -0.910506    0 0
  v -120.051 91.0908 14.087    0.36412 0.100074 -0.92596    0 0
  v -117.111 85.4695 14.6436    0.916525 -0.233707 -0.324596    0 0
  v -122.521 81.3513 14.0721    0.30256 -0.286497 -0.909053    0 0
  v -126.05 78.6634 14.1073    0.21759 -0.421989 -0.880102    0 0
  v -126.874 92.7228 12.5313    0.119487 0.08698 -0.989018    0 0
  v -125.448 90.0489 12.5523    0.146197 0.0380919 -0.988522    0 0
  v -125.794 86.8255 12.4696    0.13215 -0.0334476 -0.990665    0 0
  v -126.897 84.0819 12.5283    0.117632 -0.0878611 -0.989163    0 0
  v -111.745 81.1585 41.9671    0.386654 -0.895331 0.221091    0 0
  v -109.311 84.3765 38.3151    0.792109 -0.210432 -0.572958    0 0
  v -109.944 88.0552 41.9044    0.704041 0.656028 0.271944    0 0
  v -107.439 84.3687 44.8807    0.133289 0.040389 0.990254    0 0
  v -107.701 81.8133 42.2788    0.0136733 -0.998652 0.0500713    0 0
  v -106.627 84.1186 39.0919    -0.0888321 -0.0537972 -0.994593    0 0
  v -106.439 86.7252 41.8955    0.156938 0.987427 -0.0189046    0 0
  v -102.497 83.8689 43.2136    0.533999 0.0330829 0.844838    0 0
  v -103.575 81.5688 41.1224    -0.0737242 -0.995331 0.0622934    0 0
  v -103.817 83.672 38.0848    -0.564272 -0.0304747 -0.825026    0 0
  v -102.819 86.1155 40.4402    0.184932 0.978955 -0.0862969    0 0
  v -98.7616 83.1573 39.5996    0.810857 0.073154 0.580655    0 0
  v -100.358 81.2124 38.4049    -0.0222691 -0.997607 0.0654497    0 0
  v -101.651 83.0155 36.0405    -0.734744 -0.103545 -0.670396    0 0
  v -100.008 85.0092 37.3911    0.192194 0.961243 -0.197672    0 0
  v -97.3313 82.7023 36.3777    0.997082 -0.0117608 -0.0754274    0 0
  v -98.5543 81.4755 36.0093    0.239164 -0.897952 -0.369435    0 0
  v -99.834 82.6362 34.8524    -0.177796 -0.289287 -0.940586    0 0
  v -98.5707 83.8726 35.2704    0.363556 0.661844 -0.655583    0 0
  v -120.649 83.7151 13.4668    0.0368077 -0.862096 -0.505406    0 0
  v -122.698 86.1438 12.6184    -0.377781 0.0876887 -0.921733    0 0
  v -119.549 87.9664 13.4381    0.269515 0.761227 -0.589827    0 0
  v -116.744 85.2594 10.9558    0.958572 -0.222581 0.177755    0 0
  v -119.551 83.8923 10.4803    -0.129773 -0.991152 0.0278757    0 0
  v -121.221 85.774 10.1039    -0.939784 0.219906 -0.261625    0 0
  v -118.707 87.1702 10.327    0.129768 0.987114 -0.0936316    0 0
  v -116.326 84.8873 6.32056    0.971275 -0.229341 0.0634559    0 0
  v -118.914 83.6348 5.96867    -0.128534 -0.991058 0.0358291    0 0
  v -120.465 85.3592 5.68852    -0.960347 0.226093 -0.163146    0 0
  v -118.145 86.6366 5.79949    0.127575 0.985711 -0.109989    0 0
  v -116.315 84.6102 2.56142    0.967347 -0.237599 -0.088237    0 0
  v -118.433 83.5813 2.2556    -0.106262 -0.988183 -0.110462    0 0
  v -119.712 84.9991 2.04254    -0.902393 0.199576 -0.381911    0 0
  v -117.804 86.0454 2.1164    0.14529 0.959116 -0.242875    0 0
  v -116.908 84.5863 0.977822    0.665213 -0.207445 -0.717258    0 0
  v -117.945 84.0722 0.831119    0.0338327 -0.672459 -0.739361    0 0
  v -118.601 84.7824 0.719038    -0.401203 0.0489563 -0.91468    0 0
  v -117.635 85.3009 0.761266    0.188106 0.541823 -0.819173    0 0
  v -105.502 60.6384 80.7996    0.542734 -0.839896 -0.00374824    0 0
  v -104.869 60.5449 73.4452    0.534847 -0.832622 0.143807    0 0
  v -97.0857 64.8033 73.6764    0.438543 -0.890515 0.121093    0 0
  v -98.004 64.9441 80.9545    0.442492 -0.896769 -0.00253364    0 0
  v -105.17 62.5676 80.0815    0.752068 -0.0425742 -0.657708    0 0
  v -104.699 62.472 73.9699    0.644097 0.0249725 0.764536    0 0
  v -98.2779 65.9717 74.2187    -0.702941 -0.129024 0.699448    0 0
  v -98.9934 66.129 80.2475    -0.583032 -0.191603 -0.789533    0 0
  v -104.488 67.99 79.0008    0.764939 -0.500593 -0.405308    0 0
  v -104.115 67.9134 74.5896    0.695303 -0.462774 0.549903    0 0
  v -99.5075 70.4495 74.7584    -0.296047 -0.689645 0.660868    0 0
  v -99.9936 70.5558 79.1316    -0.205447 -0.726798 -0.655406    0 0
  v -118.569 59.1905 63.1305    0.165455 -0.87268 -0.459406    0 0
  v -129.55 73.9389 107.169    2.98463e-007 -0.535496 0.844538    0 0
  v -129.55 89.509 110.865    2.49853e-007 0.00922098 0.999957    0 0
  v -129.55 94.4077 110.473    -1.25776e-008 0.189752 0.981832    0 0
  v -129.55 63.3755 97.0649    -1.07705e-007 -0.794847 0.60681    0 0
  v -129.55 113.447 97.0649    -2.01422e-007 0.794846 0.606811    0 0
  v -129.55 57.169 84.5127    -7.93761e-009 -0.974221 0.225596    0 0
  v -129.55 119.706 69.5184    -4.66895e-010 0.974637 -0.223792    0 0
  v -129.55 113.139 56.1328    7.00277e-010 0.766537 -0.6422    0 0
  v -129.55 74.135 47.5221    5.50095e-008 -0.912699 0.408633    0 0
  v -129.55 102.688 47.5221    -4.73759e-007 0.564112 -0.825699    0 0
  v -129.55 104.963 41.5883    4.5247e-008 0.964505 0.264064    0 0
  v -129.55 106.114 33.5791    4.99156e-008 0.999701 0.0244475    0 0
  v -129.55 105.351 25.0062    -1.52037e-007 0.98186 -0.189609    0 0
  v -129.55 71.4716 25.0062    -2.13131e-007 -0.98186 -0.189609    0 0
  v -129.55 99.0626 14.1502    2.33063e-010 0.527146 -0.849775    0 0
  v -129.55 80.839 12.8047    -9.32214e-010 -0.249512 -0.968372    0 0
  v -129.55 58.3205 63.205    2.65637e-008 -0.92636 -0.37664    0 0
  v -137.355 75.4883 107.225    -0.19626 -0.456562 0.867775    0 0
  v -143.842 65.7942 97.0649    -0.262129 -0.735408 0.62487    0 0
  v -155.538 72.6088 97.052    -0.504554 -0.541359 0.672574    0 0
  v -143.798 79.66 107.32    -0.299401 -0.324394 0.897289    0 0
  v -164.261 79.3318 99.9828    0.0038155 -0.95444 0.298378    0 0
  v -161.92 82.999 102.697    0.15649 0.13963 0.97776    0 0
  v -147.248 85.3606 107.487    -0.372402 -0.119102 0.920397    0 0
  v -163.734 87.4733 97.228    -0.51507 0.665131 0.540651    0 0
  v -163.201 90.0177 97.0212    -0.682361 0.109167 0.722818    0 0
  v -147.532 91.1611 107.339    -0.381248 0.119071 0.916773    0 0
  v -156.026 103.23 97.0598    -0.537208 0.501786 0.677952    0 0
  v -143.891 97.0386 107.292    -0.311899 0.315867 0.896073    0 0
  v -143.842 111.029 97.0649    -0.262129 0.735408 0.62487    0 0
  v -137.355 101.335 107.225    -0.19626 0.456562 0.867775    0 0
  v -129.55 102.884 107.169    -3.21915e-007 0.535496 0.844538    0 0
  v -148.303 59.7117 84.4709    -0.260169 -0.913633 0.312389    0 0
  v -163.191 68.2899 84.4664    -0.663709 -0.631822 0.400365    0 0
  v -171.296 81.4421 84.2721    -0.877629 -0.280404 0.388768    0 0
  v -168.299 81.9654 96.5746    -0.944151 -0.241868 -0.223781    0 0
  v -171.31 94.9684 84.4584    -0.879002 0.271135 0.392225    0 0
  v -162.852 107.762 84.5117    -0.643132 0.687264 0.337713    0 0
  v -147.764 116.626 84.5105    -0.321288 0.912704 0.252478    0 0
  v -129.55 119.682 84.503    -7.47018e-009 0.972983 0.230876    0 0
  v -165.042 68.3324 69.718    -0.688154 -0.664176 -0.292085    0 0
  v -173.222 81.4567 69.5609    -0.925938 -0.306959 -0.220036    0 0
  v -173.222 95.3663 69.5609    -0.925938 0.306958 -0.220036    0 0
  v -164.416 107.898 69.5609    -0.637358 0.738883 -0.218693    0 0
  v -148.672 116.58 69.5512    -0.313767 0.923207 -0.221899    0 0
  v -149.023 59.3775 69.245    -0.289254 -0.922756 -0.254664    0 0
  v -144.751 66.1814 56.0335    -0.255152 -0.67114 -0.696038    0 0
  v -156.698 72.9567 56.1425    -0.433947 -0.497364 -0.751212    0 0
  v -163.597 82.8957 56.1425    -0.550674 -0.180701 -0.814927    0 0
  v -163.597 93.9272 56.1425    -0.550674 0.180701 -0.814927    0 0
  v -156.698 103.866 56.1425    -0.433947 0.497364 -0.751212    0 0
  v -144.388 110.731 56.1403    -0.238946 0.698951 -0.674071    0 0
  v -135.731 75.4729 47.5221    -0.198242 -0.467564 -0.861443    0 0
  v -141.098 79.44 47.5221    -0.296243 -0.276045 -0.914352    0 0
  v -144.145 85.2096 47.5221    -0.326793 -0.0872133 -0.941063    0 0
  v -144.145 91.6134 47.5221    -0.326794 0.0872135 -0.941063    0 0
  v -141.098 97.383 47.5221    -0.296243 0.276045 -0.914352    0 0
  v -135.731 101.35 47.5221    -0.198242 0.467564 -0.861443    0 0
  v -184.489 76.9382 125.99    0.00590527 -0.11229 0.993658    0 0
  v -185.802 75.0099 125.024    -0.23241 -0.623921 0.746129    0 0
  v -188.336 76.4445 124.379    -0.71486 -0.282223 0.639786    0 0
  v -186.799 78.3942 125.413    -0.401725 0.30226 0.86444    0 0
  v -175.981 77.7397 113.184    0.216436 -0.968164 -0.125751    0 0
  v -174.978 79.2109 113.791    0.783697 0.146794 0.603548    0 0
  v -177.641 78.8314 112.366    -0.72673 -0.177908 -0.663485    0 0
  v -176.002 80.5187 112.481    -0.182009 0.980246 0.0774062    0 0
  v -179.193 75.2796 117.593    0.358649 -0.709636 -0.606455    0 0
  v -177.18 78.3036 119.096    0.955537 0.284537 -0.0773827    0 0
  v -183.232 77.5334 116.563    -0.285361 0.0242307 -0.958114    0 0
  v -180.767 80.6004 118.202    0.0968916 0.873668 -0.476778    0 0
  v -180.611 73.608 119.656    0.237683 -0.937249 -0.255089    0 0
  v -177.607 78.1116 121.885    0.875799 0.205477 0.436756    0 0
  v -186.645 76.9806 118.107    -0.573838 -0.0760037 -0.815434    0 0
  v -182.982 81.5466 120.556    -0.0499417 0.985845 -0.160051    0 0
  v -183.404 73.1936 122.889    0.00333604 -0.957351 0.288908    0 0
  v -180.497 77.5535 125.048    0.485631 0.0453762 0.872985    0 0
  v -189.244 76.4575 121.39    -0.94235 -0.241826 -0.231295    0 0
  v -185.698 80.8781 123.761    -0.277113 0.875111 0.396724    0 0
  v -144.223 98.7294 41.5899    -0.674628 0.653949 0.342385    0 0
  v -137.6 103.305 41.5883    -0.381083 0.877835 0.290142    0 0
  v -147.87 92.7915 41.6162    -0.883636 0.255276 0.392456    0 0
  v -146.895 84.7246 45.232    -0.218609 -0.047981 0.974632    0 0
  v -149.155 88.0552 41.9044    -0.704039 0.65603 0.271944    0 0
  v -144.051 77.884 41.6092    -0.66894 -0.659669 0.342572    0 0
  v -147.355 81.1585 41.9671    -0.386654 -0.895331 0.22109    0 0
  v -137.6 73.5177 41.5883    -0.381083 -0.877835 0.290142    0 0
  v -129.55 71.8595 41.5883    9.09604e-008 -0.964505 0.264064    0 0
  v -145.694 99.2617 33.5794    -0.73385 0.678922 0.0230328    0 0
  v -138.495 104.294 33.5791    -0.394361 0.918571 0.0265706    0 0
  v -149.568 92.3442 33.5716    -0.967055 0.253955 0.0176597    0 0
  v -149.789 84.3765 38.3151    -0.79211 -0.210433 -0.572957    0 0
  v -149.629 84.5651 33.2879    -0.968135 -0.250258 0.00920539    0 0
  v -145.69 77.5613 33.5701    -0.734758 -0.677891 0.0243816    0 0
  v -138.495 72.5284 33.5791    -0.394361 -0.918572 0.0265706    0 0
  v -129.55 70.7088 33.5791    -4.66501e-010 -0.999701 0.0244475    0 0
  v -144.742 98.8225 25.0062    -0.718778 0.65229 -0.240572    0 0
  v -137.921 103.639 25.0062    -0.387615 0.898614 -0.205541    0 0
  v -148.437 92.0929 25.0062    -0.932072 0.241423 -0.270106    0 0
  v -148.437 84.73 25.0062    -0.932072 -0.241423 -0.270106    0 0
  v -144.742 78.0005 25.0062    -0.718779 -0.65229 -0.240572    0 0
  v -137.921 73.1844 25.0062    -0.387615 -0.898614 -0.205541    0 0
  v -141.803 97.5425 17.9815    -0.585824 0.52704 -0.615662    0 0
  v -136.141 101.604 17.9815    -0.335366 0.762689 -0.553023    0 0
  v -144.991 91.6602 17.9792    -0.725804 0.185475 -0.662425    0 0
  v -145.169 85.1324 18.076    -0.741751 -0.191095 -0.642875    0 0
  v -141.801 79.2845 17.9793    -0.585932 -0.525856 -0.616571    0 0
  v -136.141 75.2186 17.9815    -0.335364 -0.76269 -0.553023    0 0
  v -129.55 73.8371 17.9815    2.90716e-007 -0.853895 -0.520445    0 0
  v -136.674 95.3174 14.0763    -0.306751 0.277276 -0.910506    0 0
  v -133.049 98.1595 14.1073    -0.21759 0.421989 -0.880102    0 0
  v -139.048 91.0908 14.087    -0.364123 0.100076 -0.925959    0 0
  v -141.989 85.4695 14.6436    -0.916525 -0.233707 -0.324598    0 0
  v -139.55 87.9664 13.4381    -0.269515 0.76123 -0.589823    0 0
  v -136.578 81.3513 14.0721    -0.302558 -0.286498 -0.909053    0 0
  v -138.45 83.7151 13.4668    -0.0368098 -0.862096 -0.505406    0 0
  v -133.049 78.6634 14.1073    -0.217589 -0.421989 -0.880103    0 0
  v -129.55 77.7604 14.1502    -1.16531e-010 -0.527148 -0.849774    0 0
  v -132.225 92.7228 12.5313    -0.119483 0.0869799 -0.989019    0 0
  v -129.55 93.5406 12.369    1.8855e-006 0.0943732 -0.995537    0 0
  v -129.55 95.9839 12.8047    -2.82228e-007 0.249515 -0.968371    0 0
  v -133.651 90.0489 12.5523    -0.146198 0.0380908 -0.988522    0 0
  v -136.401 86.1438 12.6184    0.377784 0.0876875 -0.921732    0 0
  v -133.306 86.8255 12.4696    -0.13215 -0.0334483 -0.990665    0 0
  v -132.203 84.0819 12.5283    -0.117631 -0.0878611 -0.989163    0 0
  v -129.55 83.2824 12.369    -5.22814e-006 -0.0943699 -0.995537    0 0
  v -161.768 82.7023 36.3777    -0.997083 -0.0117559 -0.0754183    0 0
  v -160.545 81.4755 36.0093    -0.239165 -0.897951 -0.369437    0 0
  v -159.265 82.6362 34.8524    0.177797 -0.289285 -0.940586    0 0
  v -160.528 83.8726 35.2704    -0.363554 0.661846 -0.655582    0 0
  v -151.398 81.8133 42.2788    -0.0136734 -0.998652 0.0500715    0 0
  v -151.66 84.3687 44.8807    -0.133287 0.0403897 0.990254    0 0
  v -152.472 84.1186 39.0919    0.0888324 -0.0537981 -0.994593    0 0
  v -152.66 86.7252 41.8955    -0.156938 0.987427 -0.0189046    0 0
  v -155.524 81.5688 41.1224    0.0737262 -0.995331 0.0622942    0 0
  v -156.602 83.8689 43.2136    -0.534 0.0330847 0.844837    0 0
  v -155.283 83.672 38.0848    0.564271 -0.0304754 -0.825027    0 0
  v -156.28 86.1155 40.4402    -0.184933 0.978955 -0.086297    0 0
  v -158.741 81.2124 38.4049    0.0222716 -0.997607 0.0654494    0 0
  v -160.338 83.1573 39.5996    -0.810857 0.0731539 0.580655    0 0
  v -157.448 83.0155 36.0405    0.734742 -0.103549 -0.670397    0 0
  v -159.091 85.0092 37.3911    -0.192194 0.961243 -0.197672    0 0
  v -142.191 84.5863 0.977822    -0.665206 -0.207438 -0.717266    0 0
  v -141.154 84.0722 0.831112    -0.0338417 -0.672469 -0.739351    0 0
  v -140.498 84.7824 0.719038    0.401196 0.0489344 -0.914684    0 0
  v -141.465 85.3009 0.761273    -0.188111 0.541838 -0.819161    0 0
  v -139.548 83.8923 10.4803    0.129773 -0.991152 0.0278765    0 0
  v -142.355 85.2594 10.9558    -0.958573 -0.22258 0.177755    0 0
  v -137.878 85.774 10.1039    0.939784 0.219902 -0.261628    0 0
  v -140.393 87.1702 10.327    -0.129769 0.987114 -0.0936308    0 0
  v -140.185 83.6348 5.96867    0.128534 -0.991058 0.0358294    0 0
  v -142.773 84.8873 6.32056    -0.971275 -0.229341 0.063458    0 0
  v -138.634 85.3592 5.68852    0.960347 0.226092 -0.163144    0 0
  v -140.954 86.6366 5.7995    -0.127575 0.985712 -0.109989    0 0
  v -140.666 83.5813 2.25562    0.106264 -0.988183 -0.11046    0 0
  v -142.784 84.6102 2.56143    -0.967347 -0.237601 -0.0882383    0 0
  v -139.388 84.9991 2.04254    0.902395 0.19957 -0.381911    0 0
  v -141.295 86.0454 2.11641    -0.145289 0.959115 -0.242876    0 0
  v -154.23 60.5449 73.4452    -0.534846 -0.832622 0.143807    0 0
  v -153.597 60.6384 80.7996    -0.542735 -0.839895 -0.00375085    0 0
  v -162.014 64.8033 73.6764    -0.438544 -0.890514 0.121091    0 0
  v -161.095 64.9441 80.9545    -0.442493 -0.896768 -0.0025327    0 0
  v -154.612 67.99 79.0008    -0.764939 -0.500594 -0.405307    0 0
  v -154.984 67.9134 74.5896    -0.695303 -0.462772 0.549905    0 0
  v -159.592 70.4495 74.7584    0.296047 -0.689644 0.660869    0 0
  v -159.106 70.5558 79.1316    0.205445 -0.726797 -0.655407    0 0
  v -154.401 62.472 73.9699    -0.644097 0.0249735 0.764536    0 0
  v -153.93 62.5676 80.0815    -0.752068 -0.0425735 -0.657709    0 0
  v -160.821 65.9717 74.2187    0.702942 -0.129021 0.699447    0 0
  v -160.106 66.129 80.2475    0.583031 -0.191602 -0.789534    0 0
  v -129.55 62.8686 56.0476    -4.20274e-008 -0.659112 -0.752045    0 0
  v -129.55 56.5506 70.6502    1.39874e-009 -0.994275 -0.106854    0 0
  v -140.53 59.1905 63.1305    -0.165454 -0.872681 -0.459405    0 0
  v -129.55 60.6005 58.5135    -7.03842e-009 -0.969747 -0.244111    0 0
  v -129.55 82.4152 110.473    -3.76629e-007 -0.18975 0.981832    0 0
  v -129.55 85.2496 110.833    4.60708e-007 -0.0427777 0.999085    0 0
  v -129.55 87.3139 110.865    2.48921e-007 -0.00922095 0.999957    0 0
  v -129.55 91.5734 110.833    4.62573e-007 0.0427775 0.999085    0 0
  v -129.55 102.986 17.9815    -2.92118e-007 0.853895 -0.520445    0 0
  v -129.55 62.5627 59.1495    -1.22555e-007 -0.0373736 0.999301    0 0
  v -120.275 61.147 62.9455    -0.934874 -0.0945458 -0.342157    0 0
  v -129.55 60.7438 62.0651    6.35132e-008 0.00578976 -0.999983    0 0
  v -138.825 61.1471 62.9455    0.934874 -0.0945447 -0.342158    0 0
  v -129.55 70.0776 59.4986    8.89688e-008 -0.19028 0.98173    0 0
  v -122.113 68.043 62.2259    -0.694614 -0.600492 -0.396134    0 0
  v -129.55 68.7707 61.4669    -4.98814e-008 -0.30329 -0.952898    0 0
  v -136.986 68.043 62.2259    0.694613 -0.600491 -0.396136    0 0
  v -113.151 72.7465 102.708    0.332884 -0.553619 0.763344    0 0
  v -104.12 80.021 102.217    0.344024 -0.442986 0.827896    0 0
  v -101.64 87.6198 102.212    0.46584 0.233758 0.853434    0 0
  v -105.584 96.5718 102.701    0.515167 0.307881 0.799883    0 0
  v -113.179 104.068 102.725    0.3344 0.553644 0.762663    0 0
  v -123.793 107.952 102.711    0.116389 0.680839 0.723126    0 0
  v -105.538 65.7885 91.2302    0.429777 -0.728043 0.534083    0 0
  v -94.3166 76.7486 91.9632    0.676182 -0.605281 0.420015    0 0
  v -90.8585 87.4746 91.9581    0.870986 0.186809 0.454408    0 0
  v -94.5661 100.431 91.0716    0.697741 0.43157 0.571756    0 0
  v -105.534 111.023 91.0633    0.443936 0.747441 0.494219    0 0
  v -121.083 116.57 91.0629    0.147872 0.878751 0.453796    0 0
  v -88.9575 74.5679 77.1882    0.848102 -0.514877 0.124998    0 0
  v -84.6163 88.3874 77.184    0.987533 0.00102235 0.157406    0 0
  v -89.1335 102.33 77.1698    0.820423 0.559124 0.119526    0 0
  v -101.81 113.523 77.1687    0.491313 0.869769 0.0459798    0 0
  v -119.754 119.726 77.1483    0.163925 0.986441 0.00787495    0 0
  v -103.867 65.9638 62.1606    0.421738 -0.733972 -0.532374    0 0
  v -92.2791 75.9479 62.3419    0.683709 -0.472728 -0.555941    0 0
  v -88.1064 88.4115 62.3401    0.808766 1.75293e-007 -0.588131    0 0
  v -92.2885 100.867 62.3401    0.682815 0.481974 -0.549058    0 0
  v -103.994 110.855 62.3394    0.420792 0.768457 -0.482087    0 0
  v -120.534 116.401 62.3189    0.143496 0.883546 -0.44582    0 0
  v -113.815 72.8994 51.4172    0.28377 -0.478638 -0.830891    0 0
  v -106.484 79.8012 51.4183    0.381709 -0.251498 -0.889408    0 0
  v -103.863 88.4115 51.4183    0.411183 2.95374e-007 -0.911553    0 0
  v -106.484 97.0217 51.4183    0.381709 0.251498 -0.889408    0 0
  v -113.818 103.924 51.4183    0.282787 0.481726 -0.829441    0 0
  v -124.04 107.691 51.4176    0.1068 0.628765 -0.770226    0 0
  v -72.3891 76.6271 125.616    0.356868 -0.208118 0.910677    0 0
  v -89.3764 79.8609 107.266    -0.610348 -0.627039 0.484042    0 0
  v -87.4001 79.5083 105.666    0.333988 -0.871968 -0.357942    0 0
  v -86.7676 81.5725 105.732    0.708149 0.655025 -0.263566    0 0
  v -88.7668 81.8516 107.332    -0.256573 0.799738 0.54276    0 0
  v -81.7679 77.1244 117.086    -0.827868 -0.557346 0.0632482    0 0
  v -79.0101 76.7634 115.91    0.200229 -0.691727 -0.693846    0 0
  v -78.2977 79.2007 116.188    0.434513 0.673653 -0.597821    0 0
  v -81.0555 79.5617 117.364    -0.510562 0.842104 0.173746    0 0
  v -81.5251 75.7614 119.691    -0.853187 -0.51754 -0.0649961    0 0
  v -76.204 75.0918 117.466    0.143123 -0.619725 -0.771659    0 0
  v -74.8118 79.7675 117.998    0.317462 0.63701 -0.70245    0 0
  v -80.1329 80.4371 120.223    -0.548104 0.836394 0.00515329    0 0
  v -79.8839 74.847 122.674    -0.631849 -0.629981 0.451543    0 0
  v -73.3859 74.0352 119.957    0.354306 -0.833755 -0.423461    0 0
  v -71.6801 79.7427 120.604    0.608512 0.696345 -0.380548    0 0
  v -78.178 80.5545 123.321    -0.391664 0.78272 0.483682    0 0
  v -76.0043 75.1818 125.25    -0.150559 -0.514382 0.844241    0 0
  v -71.6923 74.635 123.445    0.522939 -0.776369 0.351833    0 0
  v -70.5683 78.4257 123.878    0.792662 0.386789 0.471254    0 0
  v -74.8804 78.9724 125.683    -0.0231383 0.389957 0.920542    0 0
  v -119.108 100.526 44.7368    0.514798 0.719908 0.465527    0 0
  v -114.244 95.3423 44.7473    0.717011 0.407372 0.565635    0 0
  v -112.576 88.6811 45.0155    0.777298 0.027654 0.628525    0 0
  v -114.408 81.4496 45.0156    0.688286 -0.410153 0.598362    0 0
  v -119.118 76.2928 44.7439    0.51406 -0.719915 0.466331    0 0
  v -125.896 73.3031 44.7367    0.18857 -0.897861 0.397853    0 0
  v -117.057 101.846 37.7967    0.562983 0.808542 0.171201    0 0
  v -111.49 96.0175 37.7981    0.849138 0.497667 0.176895    0 0
  v -109.413 88.6002 37.774    0.988949 0.0874849 0.119689    0 0
  v -111.415 80.8163 37.774    0.820164 -0.564306 0.0942869    0 0
  v -117.06 74.9736 37.7946    0.562338 -0.8094 0.169257    0 0
  v -125.115 71.5225 37.7966    0.197535 -0.968898 0.149055    0 0
  v -116.84 101.985 29.2297    0.572739 0.812619 -0.107796    0 0
  v -111.232 95.8419 29.2297    0.868973 0.47747 -0.130035    0 0
  v -109.296 88.4183 29.2228    0.990233 0.00247672 -0.139398    0 0
  v -111.232 80.9821 29.2227    0.86819 -0.47866 -0.130881    0 0
  v -116.84 74.8379 29.2296    0.572756 -0.81261 -0.107776    0 0
  v -125.032 71.3241 29.2297    0.19859 -0.975633 -0.0932847    0 0
  v -118.461 100.868 21.1642    0.539197 0.759505 -0.363894    0 0
  v -113.393 95.2674 21.1642    0.798316 0.435398 -0.416077    0 0
  v -111.615 88.4095 21.1653    0.899383 0.00317093 -0.437149    0 0
  v -113.39 81.5561 21.1653    0.797832 -0.438602 -0.413633    0 0
  v -118.461 75.9552 21.1642    0.539226 -0.759458 -0.36395    0 0
  v -125.652 72.8301 21.1642    0.190712 -0.927823 -0.320583    0 0
  v -121.899 98.5064 15.6732    0.358905 0.494459 -0.791642    0 0
  v -117.954 94.0731 15.676    0.488492 0.264634 -0.831471    0 0
  v -116.514 88.3254 15.5689    0.583777 0.101973 -0.805485    0 0
  v -117.933 82.7928 15.5701    0.50356 -0.384683 -0.773593    0 0
  v -121.901 78.315 15.6726    0.358736 -0.496148 -0.790662    0 0
  v -126.954 75.989 15.6843    0.141489 -0.661633 -0.736358    0 0
  v -127.036 95.191 12.8718    0.164302 0.214018 -0.962913    0 0
  v -123.977 92.425 13.0254    0.230671 0.12228 -0.965318    0 0
  v -122.997 88.4766 12.9649    0.185597 0.106034 -0.976888    0 0
  v -124.062 84.2667 12.9636    0.134693 -0.198961 -0.970707    0 0
  v -127.039 81.6284 12.8715    0.163027 -0.214803 -0.962955    0 0
  v -128.38 79.3499 13.3638    0.0916309 -0.386256 -0.917829    0 0
  v -98.2167 82.5795 35.0936    0.451551 -0.249032 -0.856787    0 0
  v -110.265 82.6161 44.22    0.0583939 -0.69165 0.719868    0 0
  v -108.986 82.4131 40.0793    0.224167 -0.815595 -0.533436    0 0
  v -107.976 86.1892 39.9369    0.340802 0.690849 -0.637638    0 0
  v -109.259 86.3795 44.0775    0.200111 0.679426 0.705929    0 0
  v -105.279 82.5438 43.6685    0.151659 -0.712961 0.684607    0 0
  v -105.469 82.3926 39.8896    -0.250365 -0.782593 -0.56997    0 0
  v -104.78 85.5952 39.5289    -0.138763 0.730811 -0.668326    0 0
  v -104.591 85.7465 43.3077    0.315399 0.724042 0.613422    0 0
  v -100.991 82.0765 41.2071    0.422215 -0.710606 0.562827    0 0
  v -102.504 81.9594 38.165    -0.491405 -0.773026 -0.401189    0 0
  v -102.125 84.8383 37.5694    -0.348407 0.719549 -0.600717    0 0
  v -100.613 84.9554 40.6115    0.607382 0.699298 0.376921    0 0
  v -98.0713 81.7237 37.6018    0.625513 -0.711767 0.319562    0 0
  v -100.229 81.6533 35.9193    -0.354083 -0.829344 -0.43222    0 0
  v -100.161 83.9025 35.2436    -0.308458 0.629565 -0.713093    0 0
  v -98.0036 83.9729 36.9261    0.689283 0.71891 0.0897605    0 0
  v -117.7 84.6639 0.574299    0.140802 -0.0911985 -0.985828    0 0
  v -118.256 84.2994 12.7558    0.43292 -0.899879 0.0528879    0 0
  v -121.449 84.6904 11.8772    -0.670456 -0.651523 -0.354975    0 0
  v -120.833 87.0665 11.8145    -0.412458 0.82171 -0.393283    0 0
  v -117.632 86.7056 12.6932    0.714456 0.699368 -0.0209052    0 0
  v -117.506 84.0881 8.54064    0.42193 -0.901 0.100866    0 0
  v -120.461 84.4251 8.07788    -0.749178 -0.658514 -0.0713607    0 0
  v -119.91 86.5706 7.95914    -0.481434 0.860494 -0.166646    0 0
  v -116.955 86.2336 8.42191    0.696831 0.717185 -0.00854855    0 0
  v -117.183 83.842 4.12475    0.429966 -0.901401 0.0510431    0 0
  v -119.822 84.1433 3.72169    -0.743839 -0.660079 -0.104876    0 0
  v -119.332 86.0576 3.61371    -0.477965 0.855755 -0.198075    0 0
  v -116.693 85.7563 4.01677    0.70431 0.706517 -0.0691453    0 0
  v -117.159 83.9784 1.40153    0.459026 -0.837858 -0.295448    0 0
  v -118.925 84.182 1.13165    -0.572135 -0.574546 -0.585285    0 0
  v -118.6 85.4635 1.059    -0.37733 0.694698 -0.612386    0 0
  v -116.834 85.26 1.32888    0.699808 0.578931 -0.418459    0 0
  v -107.975 59.2185 77.1279    0.290263 -0.95632 0.0346455    0 0
  v -100.74 62.8321 70.9676    0.470787 -0.847808 -0.244093    0 0
  v -94.9227 66.539 77.2926    0.692757 -0.713632 0.104005    0 0
  v -102.172 62.9285 83.4281    0.470097 -0.81817 0.331069    0 0
  v -102.071 70.7278 76.7921    0.479466 -0.875141 0.0651148    0 0
  v -106.118 60.4142 77.0558    0.966114 -0.24665 0.0760821    0 0
  v -101.112 62.8876 72.8097    0.206303 -0.443101 0.872411    0 0
  v -96.9741 65.5393 77.3488    -0.498285 -0.866137 -0.0389608    0 0
  v -101.979 63.0658 81.5948    0.312015 -0.506341 -0.803906    0 0
  v -106.021 64.8447 76.8458    0.988558 -0.131133 0.0745486    0 0
  v -101.57 67.043 73.0545    0.030092 -0.133391 0.990606    0 0
  v -97.8859 69.4048 77.1136    -0.957159 -0.269061 -0.10702    0 0
  v -102.337 67.2065 80.9049    0.15598 -0.228887 -0.960875    0 0
  v -121.09 57.8025 66.1693    0.106022 -0.965864 -0.236359    0 0
  v -126.836 78.2956 109.27    0.0675381 -0.345594 0.93595    0 0
  v -123.792 82.0056 109.938    0.144356 -0.217206 0.965393    0 0
  v -121.068 84.9785 109.979    0.181007 -0.11187 0.977099    0 0
  v -120.103 88.3917 109.988    0.191502 0.00267712 0.981489    0 0
  v -121.095 91.837 109.996    0.179278 0.105656 0.978109    0 0
  v -123.794 94.8172 109.939    0.143505 0.217782 0.96539    0 0
  v -126.836 98.5273 109.27    0.0675392 0.345592 0.935951    0 0
  v -123.793 68.8705 102.711    0.116388 -0.680839 0.723126    0 0
  v -121.075 60.2482 91.0634    0.142233 -0.877322 0.45834    0 0
  v -119.902 56.9806 77.2674    0.12827 -0.991033 0.0374109    0 0
  v -123.949 69.1433 51.3888    0.10461 -0.56365 -0.819363    0 0
  v -125.896 103.52 44.7367    0.18857 0.897861 0.397853    0 0
  v -125.115 105.3 37.7966    0.197535 0.968898 0.149055    0 0
  v -125.032 105.499 29.2297    0.19859 0.975633 -0.0932848    0 0
  v -125.652 103.993 21.1642    0.190712 0.927823 -0.320582    0 0
  v -126.954 100.834 15.6843    0.141489 0.661632 -0.736359    0 0
  v -128.38 97.473 13.3638    0.0916268 0.386255 -0.91783    0 0
  v -145.905 72.7415 102.734    -0.32898 -0.556985 0.762587    0 0
  v -153.852 79.9169 102.829    -0.353657 -0.43901 0.825952    0 0
  v -156.463 87.9605 102.834    -0.523747 0.180664 0.832496    0 0
  v -154.001 95.557 102.737    -0.52429 0.297568 0.797856    0 0
  v -145.938 104.036 102.725    -0.341156 0.549544 0.762636    0 0
  v -135.306 107.952 102.711    -0.116388 0.680839 0.723126    0 0
  v -153.558 65.7504 91.2032    -0.425765 -0.731131 0.533078    0 0
  v -164.68 75.8789 91.2515    -0.678853 -0.593715 0.432043    0 0
  v -168.727 88.1403 91.1708    -0.84133 0.12468 0.525945    0 0
  v -165.283 99.1303 91.0289    -0.70098 0.411671 0.58237    0 0
  v -153.589 110.982 91.0633    -0.450652 0.740868 0.498024    0 0
  v -138.016 116.57 91.0629    -0.147872 0.878751 0.453797    0 0
  v -170.141 74.5311 77.1589    -0.848567 -0.515617 0.118631    0 0
  v -174.508 88.4133 77.15    -0.988859 0.000501131 0.148851    0 0
  v -169.987 102.297 77.1685    -0.820047 0.559658 0.11961    0 0
  v -157.29 113.521 77.1687    -0.491706 0.869515 0.0465786    0 0
  v -139.345 119.726 77.1483    -0.163925 0.986441 0.00787538    0 0
  v -155.232 65.9638 62.1606    -0.421738 -0.733972 -0.532374    0 0
  v -166.82 75.9479 62.3419    -0.683709 -0.472728 -0.555941    0 0
  v -170.993 88.4115 62.3401    -0.808765 -2.24975e-007 -0.588132    0 0
  v -166.811 100.867 62.3401    -0.682815 0.481974 -0.549058    0 0
  v -155.105 110.855 62.3394    -0.420792 0.768457 -0.482087    0 0
  v -138.565 116.401 62.3189    -0.143495 0.883546 -0.44582    0 0
  v -145.285 72.8994 51.4172    -0.28377 -0.478637 -0.830892    0 0
  v -152.615 79.8012 51.4183    -0.381709 -0.251499 -0.889408    0 0
  v -155.236 88.4115 51.4183    -0.411183 -2.5158e-008 -0.911553    0 0
  v -152.615 97.0217 51.4183    -0.381709 0.251498 -0.889408    0 0
  v -145.281 103.924 51.4183    -0.282787 0.481726 -0.829441    0 0
  v -135.059 107.691 51.4176    -0.1068 0.628766 -0.770226    0 0
  v -186.71 76.6271 125.616    -0.35687 -0.208119 0.910676    0 0
  v -169.639 79.8714 107.247    0.606775 -0.609592 0.51012    0 0
  v -171.662 79.4852 105.587    -0.352667 -0.867299 -0.35131    0 0
  v -171.092 82.2297 103.764    -0.718675 0.662495 -0.2112    0 0
  v -168.773 82.5029 105.719    0.199253 0.803372 0.561152    0 0
  v -177.33 77.125 117.084    0.826072 -0.559984 0.0634219    0 0
  v -180.088 76.764 115.908    -0.199403 -0.69383 -0.691982    0 0
  v -180.758 79.2188 116.126    -0.463176 0.665797 -0.584963    0 0
  v -177.997 79.5804 117.307    0.512892 0.831217 0.214524    0 0
  v -177.574 75.7614 119.691    0.853187 -0.51754 -0.0649971    0 0
  v -182.895 75.0918 117.466    -0.143123 -0.619725 -0.771658    0 0
  v -184.287 79.7675 117.998    -0.317463 0.63701 -0.702449    0 0
  v -178.966 80.4371 120.223    0.548102 0.836395 0.00515356    0 0
  v -179.215 74.847 122.674    0.63185 -0.629981 0.451541    0 0
  v -185.713 74.0352 119.957    -0.354307 -0.833755 -0.423462    0 0
  v -187.419 79.7427 120.604    -0.608512 0.696344 -0.380549    0 0
  v -180.921 80.5545 123.321    0.391665 0.782721 0.483681    0 0
  v -183.095 75.1818 125.25    0.15056 -0.514383 0.844241    0 0
  v -187.407 74.635 123.445    -0.522937 -0.776369 0.351835    0 0
  v -188.531 78.4257 123.878    -0.792664 0.386789 0.471252    0 0
  v -184.219 78.9724 125.683    0.0231397 0.389957 0.920542    0 0
  v -139.992 100.526 44.7368    -0.514797 0.719908 0.465529    0 0
  v -144.856 95.3423 44.7473    -0.71701 0.407373 0.565636    0 0
  v -146.523 88.6811 45.0155    -0.777296 0.0276561 0.628527    0 0
  v -144.691 81.4496 45.0156    -0.688287 -0.410153 0.59836    0 0
  v -139.981 76.2928 44.7439    -0.514059 -0.719916 0.466331    0 0
  v -133.203 73.3031 44.7367    -0.18857 -0.897861 0.397853    0 0
  v -142.043 101.846 37.7967    -0.562983 0.808542 0.1712    0 0
  v -147.609 96.0175 37.7981    -0.849139 0.497665 0.176896    0 0
  v -149.687 88.6002 37.774    -0.988949 0.0874835 0.119691    0 0
  v -147.685 80.8163 37.774    -0.820163 -0.564307 0.0942858    0 0
  v -142.039 74.9736 37.7946    -0.562338 -0.8094 0.169257    0 0
  v -133.984 71.5225 37.7966    -0.197535 -0.968898 0.149055    0 0
  v -142.259 101.985 29.2297    -0.572739 0.812619 -0.107796    0 0
  v -147.868 95.8419 29.2297    -0.868973 0.477469 -0.130034    0 0
  v -149.803 88.4183 29.2228    -0.990233 0.0024763 -0.139399    0 0
  v -147.868 80.9821 29.2227    -0.86819 -0.478661 -0.130882    0 0
  v -142.259 74.8379 29.2296    -0.572757 -0.812609 -0.107776    0 0
  v -134.067 71.3241 29.2297    -0.19859 -0.975633 -0.0932858    0 0
  v -140.638 100.868 21.1642    -0.539196 0.759505 -0.363894    0 0
  v -145.706 95.2674 21.1642    -0.798316 0.435398 -0.416078    0 0
  v -147.484 88.4095 21.1653    -0.899384 0.00317138 -0.437149    0 0
  v -145.709 81.5561 21.1653    -0.797831 -0.438601 -0.413635    0 0
  v -140.638 75.9552 21.1642    -0.539226 -0.759458 -0.363949    0 0
  v -133.447 72.8301 21.1642    -0.190713 -0.927823 -0.320582    0 0
  v -137.2 98.5064 15.6732    -0.358904 0.494459 -0.791643    0 0
  v -141.146 94.0731 15.676    -0.488491 0.264634 -0.831472    0 0
  v -142.585 88.3254 15.5689    -0.583777 0.101975 -0.805485    0 0
  v -141.166 82.7928 15.57    -0.50356 -0.384684 -0.773593    0 0
  v -137.198 78.315 15.6726    -0.358736 -0.496148 -0.790662    0 0
  v -132.145 75.989 15.6843    -0.141489 -0.661632 -0.736359    0 0
  v -132.063 95.191 12.8718    -0.164302 0.214018 -0.962913    0 0
  v -135.122 92.425 13.0254    -0.230673 0.122281 -0.965317    0 0
  v -136.102 88.4766 12.9649    -0.185597 0.106033 -0.976888    0 0
  v -135.037 84.2667 12.9636    -0.134691 -0.19896 -0.970708    0 0
  v -132.06 81.6284 12.8715    -0.163028 -0.214801 -0.962955    0 0
  v -130.719 79.3499 13.3638    -0.0916328 -0.386256 -0.917829    0 0
  v -160.883 82.5795 35.0936    -0.45155 -0.249032 -0.856788    0 0
  v -148.834 82.6161 44.22    -0.0583935 -0.69165 0.719868    0 0
  v -150.113 82.4131 40.0793    -0.224167 -0.815594 -0.533437    0 0
  v -151.123 86.1892 39.9369    -0.340802 0.690849 -0.637638    0 0
  v -149.841 86.3795 44.0775    -0.200112 0.679425 0.705929    0 0
  v -153.82 82.5438 43.6685    -0.15166 -0.71296 0.684607    0 0
  v -153.631 82.3926 39.8896    0.250365 -0.782593 -0.569969    0 0
  v -154.319 85.5952 39.5289    0.138763 0.73081 -0.668327    0 0
  v -154.508 85.7465 43.3077    -0.315399 0.724043 0.613421    0 0
  v -158.108 82.0765 41.2071    -0.422215 -0.710607 0.562826    0 0
  v -156.596 81.9594 38.165    0.491405 -0.773026 -0.401188    0 0
  v -156.974 84.8383 37.5694    0.348408 0.719549 -0.600717    0 0
  v -158.486 84.9554 40.6115    -0.60738 0.699298 0.376923    0 0
  v -161.028 81.7237 37.6018    -0.625513 -0.711768 0.319563    0 0
  v -158.87 81.6533 35.9193    0.354084 -0.829344 -0.432219    0 0
  v -158.938 83.9025 35.2436    0.308453 0.629567 -0.713093    0 0
  v -161.096 83.9729 36.9261    -0.689282 0.718912 0.0897578    0 0
  v -141.4 84.6639 0.574293    -0.140811 -0.0911875 -0.985828    0 0
  v -140.843 84.2994 12.7558    -0.432921 -0.899879 0.0528862    0 0
  v -137.65 84.6904 11.8772    0.670455 -0.651526 -0.354971    0 0
  v -138.266 87.0665 11.8145    0.412458 0.821709 -0.393286    0 0
  v -141.468 86.7056 12.6932    -0.714457 0.699367 -0.0209058    0 0
  v -141.594 84.0881 8.54064    -0.421928 -0.901001 0.100866    0 0
  v -138.638 84.4251 8.07787    0.749178 -0.658513 -0.0713592    0 0
  v -139.189 86.5706 7.95915    0.481434 0.860494 -0.166646    0 0
  v -142.144 86.2336 8.42191    -0.696832 0.717183 -0.00855004    0 0
  v -141.916 83.842 4.12475    -0.429964 -0.901402 0.0510419    0 0
  v -139.277 84.1433 3.72168    0.743841 -0.660077 -0.104876    0 0
  v -139.767 86.0576 3.61372    0.477964 0.855755 -0.198075    0 0
  v -142.406 85.7563 4.01678    -0.70431 0.706517 -0.0691453    0 0
  v -141.94 83.9784 1.40153    -0.459027 -0.837857 -0.295449    0 0
  v -140.174 84.182 1.13165    0.572131 -0.574548 -0.585287    0 0
  v -140.499 85.4635 1.059    0.377331 0.694703 -0.61238    0 0
  v -142.265 85.26 1.32888    -0.699802 0.578931 -0.418468    0 0
  v -151.124 59.2185 77.1279    -0.290263 -0.956319 0.034646    0 0
  v -158.359 62.8321 70.9676    -0.470787 -0.847808 -0.244094    0 0
  v -164.176 66.5381 77.2919    -0.691897 -0.714581 0.103208    0 0
  v -156.927 62.9276 83.4274    -0.469885 -0.818825 0.329748    0 0
  v -157.028 70.7278 76.7921    -0.479466 -0.875141 0.065115    0 0
  v -152.982 60.4142 77.0558    -0.966112 -0.246656 0.0760808    0 0
  v -157.987 62.8876 72.8097    -0.206304 -0.443101 0.872411    0 0
  v -162.125 65.5393 77.3488    0.498289 -0.866135 -0.0389613    0 0
  v -157.12 63.0658 81.5948    -0.312016 -0.506344 -0.803904    0 0
  v -153.078 64.8447 76.8458    -0.988558 -0.131134 0.0745452    0 0
  v -157.529 67.043 73.0545    -0.0300918 -0.133391 0.990606    0 0
  v -161.213 69.4048 77.1136    0.957159 -0.269062 -0.107018    0 0
  v -156.762 67.2065 80.9048    -0.15598 -0.228886 -0.960875    0 0
  v -134.422 60.6351 58.9233    -0.187522 -0.729974 -0.657247    0 0
  v -132.264 78.2956 109.27    -0.0675377 -0.345594 0.935951    0 0
  v -135.305 82.0054 109.939    -0.142891 -0.218197 0.965387    0 0
  v -137.986 84.9755 110.008    -0.173428 -0.109971 0.978687    0 0
  v -138.952 88.405 110.021    -0.182903 0.00441634 0.983121    0 0
  v -138.016 91.8135 109.997    -0.178231 0.10765 0.978082    0 0
  v -135.306 94.8163 109.939    -0.143766 0.217601 0.965392    0 0
  v -132.264 98.5273 109.27    -0.0675394 0.345592 0.935951    0 0
  v -135.306 68.8705 102.711    -0.116389 -0.680839 0.723126    0 0
  v -138.024 60.2482 91.0634    -0.142233 -0.877322 0.45834    0 0
  v -139.197 56.9806 77.2674    -0.12827 -0.991033 0.0374108    0 0
  v -135.15 69.1433 51.3888    -0.10461 -0.56365 -0.819363    0 0
  v -133.203 103.52 44.7367    -0.18857 0.897861 0.397853    0 0
  v -133.984 105.3 37.7966    -0.197535 0.968898 0.149055    0 0
  v -134.067 105.499 29.2297    -0.19859 0.975633 -0.0932849    0 0
  v -133.447 103.993 21.1642    -0.190713 0.927823 -0.320582    0 0
  v -132.145 100.834 15.6843    -0.141489 0.661631 -0.736359    0 0
  v -130.719 97.473 13.3638    -0.0916257 0.386254 -0.91783    0 0
  v -125.47 70.4555 60.9178    -0.0942241 -0.874271 -0.476206    0 0
  v -123.01 60.2668 60.6516    -0.437821 -0.410695 0.799777    0 0
  v -122.918 59.0355 62.8557    0.131592 -0.336984 -0.932269    0 0
  v -136.181 59.0355 62.8557    -0.131592 -0.336986 -0.932268    0 0
  v -136.09 60.2668 60.6516    0.437821 -0.410694 0.799777    0 0
  v -123.416 65.9041 60.8308    -0.439314 -0.043505 0.89728    0 0
  v -123.416 64.6658 62.7255    0.149371 -0.0496829 -0.987532    0 0
  v -135.683 64.6658 62.7255    -0.14937 -0.0496824 -0.987532    0 0
  v -135.683 65.9041 60.8308    0.439314 -0.0435059 0.897279    0 0
  v -129.55 88.4116 12.1921    1.34286e-008 0.000690772 -1    0 0
  v -116.899 61.2431 60.955    0.248159 -0.780121 -0.574307    0 0
  v -124.678 60.6351 58.9233    0.187521 -0.729976 -0.657245    0 0
  v -138.009 57.8025 66.1693    -0.106022 -0.965864 -0.236358    0 0
  v -142.2 61.2431 60.955    -0.248159 -0.78012 -0.574307    0 0
  v -133.629 70.4555 60.9178    0.0942244 -0.874271 -0.476206    0 0
  v -125.451 80.3563 109.761    0.130166 -0.259968 0.956804    0 0
  v -118.26 77.368 107.272    0.248551 -0.395545 0.884176    0 0
  v -122.251 83.4244 109.974    0.168281 -0.159836 0.972694    0 0
  v -112.716 82.4151 107.126    0.356818 -0.237975 0.903354    0 0
  v -120.366 86.6551 110.001    0.186171 -0.0536187 0.981053    0 0
  v -110.882 88.2139 107.126    0.400802 0.00705473 0.916138    0 0
  v -120.36 90.1449 109.996    0.188455 0.0483742 0.98089    0 0
  v -112.985 94.3337 107.288    0.359822 0.220319 0.906635    0 0
  v -122.262 93.3967 109.981    0.164648 0.162211 0.972923    0 0
  v -118.272 99.4531 107.279    0.246366 0.396898 0.884181    0 0
  v -125.451 96.4667 109.761    0.130164 0.25997 0.956804    0 0
  v -125.451 102.699 107.133    0.0966575 0.523848 0.84631    0 0
  v -118.271 70.3439 102.72    0.230834 -0.630346 0.741201    0 0
  v -108.837 68.7739 97.0641    0.387398 -0.658242 0.645476    0 0
  v -108.569 75.9982 102.548    0.429734 -0.443769 0.786383    0 0
  v -99.125 77.1809 97.3358    0.411315 -0.674947 0.61259    0 0
  v -103.512 84.0481 103.271    0.335286 -0.107131 0.936006    0 0
  v -95.4556 88.3633 97.3279    0.616027 0.449928 0.646588    0 0
  v -103.356 92.1046 102.538    0.55444 0.167276 0.815239    0 0
  v -99.3407 98.5686 97.0525    0.612304 0.368646 0.699417    0 0
  v -108.849 100.738 102.724    0.437845 0.441144 0.78338    0 0
  v -108.838 108.026 97.0646    0.393111 0.65358 0.646759    0 0
  v -118.271 106.479 102.72    0.230834 0.630346 0.741202    0 0
  v -122.262 112.84 97.0649    0.131625 0.780316 0.611377    0 0
  v -112.917 62.3054 91.0874    0.28281 -0.820978 0.495999    0 0
  v -103.269 63.7823 86.1768    0.44704 -0.767684 0.459147    0 0
  v -99.2468 70.5498 91.2482    0.579184 -0.599297 0.552619    0 0
  v -91.097 75.0327 84.6601    0.785296 -0.485978 0.383583    0 0
  v -90.8325 81.9478 90.9518    0.914032 -0.291057 0.282543    0 0
  v -86.9726 88.1705 84.6589    0.911717 0.00451552 0.410794    0 0
  v -91.7568 94.0465 91.2133    0.773475 0.237907 0.587484    0 0
  v -91.1609 101.828 84.5166    0.775642 0.50518 0.378381    0 0
  v -99.2568 106.289 91.061    0.587548 0.608231 0.533706    0 0
  v -103.201 112.896 84.5124    0.481637 0.829475 0.282838    0 0
  v -112.958 114.475 91.0634    0.29577 0.832487 0.468493    0 0
  v -120.251 118.91 84.5059    0.160514 0.95844 0.235854    0 0
  v -111.969 58.3176 77.1463    0.197201 -0.979815 0.0327917    0 0
  v -101.539 63.7766 67.8921    0.45046 -0.791155 -0.413714    0 0
  v -92.6944 69.1948 77.2155    0.789329 -0.603511 0.112844    0 0
  v -89.173 74.8179 69.5725    0.820187 -0.523994 -0.229616    0 0
  v -85.7385 81.2658 77.1665    0.941582 -0.30545 0.141856    0 0
  v -84.741 88.4115 69.5609    0.975338 7.73485e-007 -0.220719    0 0
  v -85.7491 95.5322 77.1755    0.941164 0.303336 0.14899    0 0
  v -89.2564 101.97 69.5609    0.799435 0.559488 -0.218808    0 0
  v -94.5748 108.435 77.1693    0.660507 0.746425 0.0811164    0 0
  v -101.896 112.844 69.56    0.471479 0.85401 -0.219941    0 0
  v -110.367 117.355 77.1626    0.326865 0.944835 0.0211159    0 0
  v -119.785 118.906 69.5309    0.158205 0.961828 -0.223289    0 0
  v -120.947 64.4687 55.8208    0.159844 -0.699635 -0.696391    0 0
  v -110.872 62.7136 61.9549    0.323547 -0.78667 -0.525801    0 0
  v -108.014 69.0452 56.1316    0.348509 -0.606177 -0.714907    0 0
  v -97.2542 70.4602 62.3262    0.553246 -0.628594 -0.546616    0 0
  v -98.1497 77.6583 56.1425    0.505358 -0.349849 -0.788808    0 0
  v -89.1584 82.0226 62.3401    0.774433 -0.259002 -0.57721    0 0
  v -94.6118 88.4115 56.1425    0.566306 1.22497e-007 -0.824195    0 0
  v -89.1584 94.8004 62.3401    0.774433 0.259002 -0.57721    0 0
  v -98.1497 99.1646 56.1425    0.505358 0.34985 -0.788808    0 0
  v -97.3143 106.313 62.3401    0.557492 0.65173 -0.514249    0 0
  v -108.05 107.787 56.1422    0.343389 0.614797 -0.710006    0 0
  v -111.888 114.28 62.3332    0.28354 0.842124 -0.458728    0 0
  v -121.981 112.531 56.1356    0.122335 0.749899 -0.650143    0 0
  v -126.421 74.4647 47.5221    0.18895 -0.887997 0.419237    0 0
  v -118.689 70.5599 51.4074    0.207711 -0.558462 -0.803105    0 0
  v -120.489 77.166 47.5221    0.258969 -0.375199 -0.890034    0 0
  v -109.635 76.0366 51.4183    0.307606 -0.315739 -0.897601    0 0
  v -116.124 82.1693 47.5221    0.317174 -0.178535 -0.931411    0 0
  v -104.522 83.9949 51.4183    0.351192 -0.103216 -0.930597    0 0
  v -114.562 88.4115 47.5221    0.329574 -2.23569e-008 -0.94413    0 0
  v -104.522 92.828 51.4183    0.351192 0.103216 -0.930597    0 0
  v -116.124 94.6537 47.5221    0.317174 0.178535 -0.931411    0 0
  v -109.635 100.786 51.4183    0.307606 0.315739 -0.897601    0 0
  v -120.489 99.657 47.5221    0.258968 0.375199 -0.890034    0 0
  v -118.725 106.272 51.4181    0.193972 0.507651 -0.839443    0 0
  v -96.5543 80.8013 102.025    -0.263901 -0.666757 0.696988    0 0
  v -92.3399 79.7178 97.8594    0.474658 -0.875871 -0.0868906    0 0
  v -90.8966 84.2312 97.8766    0.823915 0.565802 -0.0321254    0 0
  v -95.3408 84.5804 102.042    0.0270554 0.718339 0.695167    0 0
  v -83.8527 78.2561 113.683    -0.711927 -0.608175 0.351116    0 0
  v -82.0451 77.999 112.724    0.299505 -0.81956 -0.488486    0 0
  v -81.553 79.6845 112.876    0.623902 0.687242 -0.372081    0 0
  v -83.3607 79.9416 113.835    -0.386119 0.802973 0.454034    0 0
  v -89.4485 80.922 107.616    -0.652061 0.169969 0.738868    0 0
  v -88.572 79.2374 106.479    -0.180877 -0.983445 0.0109382    0 0
  v -86.5859 80.4675 105.328    0.806129 -0.21834 -0.549985    0 0
  v -87.6762 82.1617 106.576    0.244655 0.957595 0.15217    0 0
  v -81.606 76.3779 118.52    -0.865266 -0.428269 -0.260576    0 0
  v -77.4801 75.8528 116.793    0.069834 -0.522859 -0.849554    0 0
  v -76.4066 79.4806 117.208    0.223148 0.59671 -0.770806    0 0
  v -80.5325 80.0057 118.935    -0.570587 0.804228 -0.166277    0 0
  v -81.9769 78.4198 117.479    -0.92515 0.23072 0.301441    0 0
  v -80.6335 76.3827 116.453    -0.29192 -0.87885 -0.377367    0 0
  v -77.9321 77.8903 115.754    0.521075 -0.0530837 -0.851858    0 0
  v -79.5887 79.9574 116.861    0.0320319 0.97738 -0.209051    0 0
  v -81.0268 75.2409 121.032    -0.768256 -0.602112 0.217357    0 0
  v -74.8651 74.4698 118.456    0.252053 -0.743562 -0.619342    0 0
  v -73.2489 79.8824 119.07    0.46292 0.681063 -0.567325    0 0
  v -79.4105 80.6536 121.646    -0.484443 0.83624 0.25694    0 0
  v -81.9273 78.2418 120.43    -0.955314 0.260824 0.139091    0 0
  v -79.3327 74.3492 118.501    -0.317317 -0.820495 -0.475497    0 0
  v -74.123 77.2598 117.166    0.397272 -0.0138681 -0.917596    0 0
  v -77.2909 81.2069 119.281    -0.0409149 0.932589 -0.358613    0 0
  v -78.1524 74.7746 124.221    -0.406144 -0.601327 0.68808    0 0
  v -72.1883 74.0273 121.727    0.471081 -0.878978 -0.0740345    0 0
  v -70.6247 79.2667 122.322    0.777713 0.628606 -0.00402691    0 0
  v -76.5888 80.014 124.816    -0.227025 0.631576 0.741331    0 0
  v -80.3739 77.8738 123.573    -0.732073 0.139491 0.666792    0 0
  v -77.2061 73.1258 121.223    -0.144081 -0.989248 -0.0250756    0 0
  v -70.8436 76.6832 119.588    0.752655 -0.144772 -0.642301    0 0
  v -74.7042 81.4968 122.172    0.145619 0.987456 0.0610393    0 0
  v -73.9814 75.8558 125.697    0.080355 -0.401718 0.912231    0 0
  v -71.8086 75.575 124.787    0.485803 -0.547597 0.681273    0 0
  v -71.2476 77.4871 125.007    0.628602 0.0845177 0.773121    0 0
  v -73.4203 77.7678 125.918    0.164839 0.128 0.97798    0 0
  v -76.3691 77.1989 125.848    -0.207808 -0.0489252 0.976945    0 0
  v -74.2454 74.015 124.266    0.141182 -0.801582 0.580977    0 0
  v -69.9941 76.3909 123.18    0.898837 -0.294134 0.324926    0 0
  v -72.5834 79.6191 124.907    0.377127 0.58753 0.71595    0 0
  v -117.906 101.29 41.5884    0.542206 0.778636 0.315814    0 0
  v -112.615 95.8626 41.5954    0.793291 0.484092 0.369248    0 0
  v -110.656 89.7964 41.6866    0.892769 0.220537 0.392844    0 0
  v -113.135 80.0867 41.6884    0.668916 -0.661106 0.339837    0 0
  v -117.924 75.5123 41.5904    0.537643 -0.782087 0.315087    0 0
  v -125.439 72.2773 41.5883    0.193771 -0.942964 0.270688    0 0
  v -122.369 102.388 44.7367    0.367138 0.826688 0.426375    0 0
  v -116.328 98.1155 44.7378    0.629011 0.582522 0.514794    0 0
  v -112.99 92.2384 44.8133    0.779549 0.206084 0.591467    0 0
  v -113.649 84.9935 45.9063    0.723124 -0.182978 0.666041    0 0
  v -116.429 78.6629 44.8086    0.629422 -0.580967 0.516047    0 0
  v -122.369 74.4347 44.7367    0.367138 -0.826689 0.426374    0 0
  v -116.675 102.101 33.5791    0.57402 0.81838 0.0274908    0 0
  v -111.002 95.9733 33.5793    0.872358 0.488613 0.0157325    0 0
  v -109.024 88.4796 33.5101    0.999748 0.00987987 0.0201507    0 0
  v -111.001 80.8611 33.5092    0.870801 -0.491348 0.0168381    0 0
  v -116.675 74.7219 33.5782    0.574241 -0.81822 0.0276461    0 0
  v -124.969 71.1709 33.5791    0.199241 -0.979632 0.0249776    0 0
  v -120.882 103.98 37.7966    0.390345 0.906809 0.159148    0 0
  v -113.858 99.1195 37.7978    0.712301 0.679188 0.177004    0 0
  v -110.028 92.5614 37.7811    0.948485 0.258137 0.183691    0 0
  v -109.661 84.5366 36.6613    0.968228 -0.249813 -0.0113408    0 0
  v -113.894 77.669 37.7763    0.71352 -0.679249 0.171785    0 0
  v -120.882 72.8429 37.7966    0.390345 -0.906809 0.159148    0 0
  v -117.465 101.554 25.0062    0.562841 0.796166 -0.222103    0 0
  v -112.065 95.6156 25.0062    0.847644 0.463637 -0.257955    0 0
  v -110.192 88.4115 25.0062    0.961578 2.51136e-007 -0.274532    0 0
  v -112.065 81.2073 25.0062    0.847644 -0.463637 -0.257955    0 0
  v -117.465 75.2685 25.0062    0.562841 -0.796166 -0.222103    0 0
  v -125.271 71.9043 25.0062    0.19633 -0.961233 -0.193612    0 0
  v -120.724 104.157 29.2297    0.392857 0.914234 -0.0991909    0 0
  v -113.607 99.1516 29.2297    0.733899 0.668791 -0.118786    0 0
  v -109.782 92.213 29.2289    0.958797 0.249183 -0.136441    0 0
  v -109.776 84.6185 29.2005    0.958243 -0.248393 -0.141674    0 0
  v -113.607 77.6713 29.2288    0.733992 -0.668723 -0.118595    0 0
  v -120.724 72.6655 29.2297    0.392858 -0.914234 -0.0991907    0 0
  v -119.914 99.8673 17.9815    0.472236 0.660424 -0.58381    0 0
  v -115.328 94.7597 17.9813    0.672808 0.364938 -0.643545    0 0
  v -113.673 88.3917 17.9919    0.748103 0.0141057 -0.663433    0 0
  v -115.303 82.0689 17.9919    0.670792 -0.379671 -0.637094    0 0
  v -119.914 76.956 17.9813    0.472389 -0.660154 -0.583992    0 0
  v -126.207 74.1791 17.9815    0.17276 -0.830908 -0.52891    0 0
  v -121.903 102.811 21.1642    0.37481 0.862906 -0.338985    0 0
  v -115.553 98.3015 21.1642    0.682564 0.617395 -0.391063    0 0
  v -112.063 91.9187 21.164    0.872566 0.225199 -0.43349    0 0
  v -112.045 84.9012 21.1737    0.87666 -0.226527 -0.424444    0 0
  v -115.553 78.5218 21.164    0.682583 -0.617158 -0.391403    0 0
  v -121.903 74.0123 21.1642    0.374809 -0.862906 -0.338986    0 0
  v -124.286 96.9208 14.0558    0.261982 0.349805 -0.899445    0 0
  v -120.961 93.2993 14.0892    0.344153 0.189342 -0.919624    0 0
  v -119.712 89.0644 14.0108    0.3604 0.213048 -0.908142    0 0
  v -121.287 82.8937 14.0122    0.270613 -0.394427 -0.878178    0 0
  v -124.296 79.8867 14.0554    0.259298 -0.353866 -0.898634    0 0
  v -127.751 77.9015 14.1664    0.116111 -0.505495 -0.854982    0 0
  v -124.392 99.9742 15.6784    0.26856 0.587695 -0.76321    0 0
  v -119.667 96.5111 15.6753    0.43276 0.387634 -0.813915    0 0
  v -116.884 91.334 15.6706    0.522277 0.134909 -0.842037    0 0
  v -116.088 85.3888 15.9972    0.67146 -0.173114 -0.720537    0 0
  v -119.688 80.2968 15.6691    0.434319 -0.391889 -0.811043    0 0
  v -124.392 76.8488 15.6784    0.268561 -0.587695 -0.76321    0 0
  v -128.375 92.751 12.3812    0.0843307 0.0740017 -0.993686    0 0
  v -126.659 91.079 12.4434    0.118142 0.0558321 -0.991426    0 0
  v -126.084 88.4414 12.4282    0.126663 0.0117031 -0.991877    0 0
  v -126.749 85.7234 12.4254    0.105589 -0.0644344 -0.99232    0 0
  v -127.771 96.5479 13.112    0.152632 0.297331 -0.942495    0 0
  v -125.164 94.0598 13.0005    0.209395 0.182373 -0.960674    0 0
  v -123.181 90.568 13.0347    0.247051 0.0647561 -0.966836    0 0
  v -124.094 86.3986 12.7307    0.0883195 -0.0238125 -0.995808    0 0
  v -125.215 82.7091 12.9954    0.205569 -0.183859 -0.961217    0 0
  v -127.771 80.275 13.112    0.152631 -0.29733 -0.942496    0 0
  v -112.478 82.2924 44.3166    0.261954 -0.628713 0.732188    0 0
  v -110.451 81.9814 39.4031    0.615959 -0.748718 -0.24498    0 0
  v -109.156 86.9372 39.3603    0.872148 0.410069 -0.266837    0 0
  v -111.221 87.1203 44.2738    0.458522 0.448304 0.767321    0 0
  v -107.759 82.6672 44.1409    0.0561418 -0.709376 0.702591    0 0
  v -107.205 82.4967 40.194    -0.0507731 -0.801175 -0.596272    0 0
  v -106.345 85.8457 39.9326    0.0286276 0.730141 -0.682697    0 0
  v -106.898 86.0162 43.8795    0.186926 0.733965 0.652959    0 0
  v -110.03 84.5333 45.0526    0.059652 0.0211873 0.997994    0 0
  v -109.878 81.6578 42.234    0.142395 -0.984973 0.09773    0 0
  v -108.162 84.2463 39.0086    0.257417 -0.101642 -0.96094    0 0
  v -108.406 87.1589 42.025    0.325021 0.943847 0.0592836    0 0
  v -102.985 82.3234 42.6963    0.290945 -0.712017 0.639048    0 0
  v -103.884 82.1892 39.1993    -0.411143 -0.766862 -0.492833    0 0
  v -103.369 85.2892 38.7342    -0.270151 0.723308 -0.635487    0 0
  v -102.47 85.4235 42.2312    0.490949 0.700946 0.517343    0 0
  v -104.869 84.1534 44.3089    0.318757 0.0348191 0.947197    0 0
  v -105.556 81.7479 41.9242    -0.0547084 -0.997353 0.0478941    0 0
  v -105.147 83.9316 38.7666    -0.338858 -0.0343642 -0.94021    0 0
  v -104.546 86.4451 41.3951    0.134333 0.989928 -0.0446927    0 0
  v -99.3289 81.8526 39.418    0.511718 -0.707928 0.486809    0 0
  v -101.299 81.7559 36.9913    -0.483703 -0.802336 -0.349698    0 0
  v -101.061 84.3446 36.3001    -0.388067 0.710888 -0.586551    0 0
  v -99.0904 84.4413 38.7267    0.636707 0.725955 0.259987    0 0
  v -100.444 83.5165 41.5635    0.707591 0.0461636 0.705113    0 0
  v -101.841 81.373 39.8806    -0.0555496 -0.995887 0.0715838    0 0
  v -102.662 83.3447 37.1017    -0.701911 -0.0515246 -0.710398    0 0
  v -101.287 85.5954 39.0071    0.219559 0.964142 -0.149078    0 0
  v -97.6284 81.9154 36.1013    0.722633 -0.631152 -0.281865    0 0
  v -99.2252 81.8769 35.2265    0.0164776 -0.689695 -0.723912    0 0
  v -99.2585 83.361 34.7662    0.0754714 0.240116 -0.967806    0 0
  v -97.6617 83.3995 35.641    0.788267 0.419584 -0.450095    0 0
  v -97.5676 82.8626 37.6567    0.923284 0.077231 0.376273    0 0
  v -99.1611 81.1702 36.9621    0.0783169 -0.995536 -0.052668    0 0
  v -100.726 82.7588 35.1718    -0.573263 -0.20693 -0.792811    0 0
  v -99.0569 84.473 35.9705    0.225572 0.91452 -0.335812    0 0
  v -118.433 83.9874 14.2916    0.510975 -0.761935 -0.397945    0 0
  v -122.378 84.6217 12.8317    -0.299857 -0.510958 -0.80561    0 0
  v -121.633 87.517 12.812    -0.132967 0.562571 -0.815987    0 0
  v -117.606 87.1827 14.272    0.733781 0.480886 -0.47991    0 0
  v -117.817 84.2311 10.8094    0.415228 -0.899955 0.132917    0 0
  v -120.87 84.582 10.2286    -0.740308 -0.658429 -0.135705    0 0
  v -120.294 86.8169 10.1241    -0.471919 0.855853 -0.211677    0 0
  v -117.242 86.466 10.7049    0.691215 0.721191 0.045886    0 0
  v -117.134 85.4074 12.9918    0.963166 -0.231334 0.137095    0 0
  v -120.069 83.9561 12.2609    -0.108963 -0.990119 -0.088267    0 0
  v -121.798 85.9552 11.7148    -0.836409 0.195193 -0.512172    0 0
  v -119.165 87.4416 12.169    0.157267 0.969319 -0.188911    0 0
  v -117.314 83.9453 6.21745    0.425085 -0.901437 0.0819412    0 0
  v -120.136 84.267 5.78652    -0.749887 -0.658698 -0.0615431    0 0
  v -119.611 86.3136 5.67117    -0.482334 0.861021 -0.161236    0 0
  v -116.79 85.9919 6.1021    0.700016 0.713229 -0.0357955    0 0
  v -116.47 85.0755 8.65025    0.968711 -0.226816 0.100767    0 0
  v -119.183 83.7628 8.27596    -0.129554 -0.990758 0.0401786    0 0
  v -120.804 85.5697 7.97153    -0.957902 0.225304 -0.177936    0 0
  v -118.375 86.9094 8.10182    0.126725 0.986888 -0.0999657    0 0
  v -117.123 83.8363 2.46834    0.442646 -0.895689 -0.0424905    0 0
  v -119.438 84.1015 2.11456    -0.710767 -0.652986 -0.261572    0 0
  v -119.009 85.7816 2.01964    -0.457808 0.826274 -0.328152    0 0
  v -116.694 85.5164 2.37343    0.712415 0.682259 -0.164275    0 0
  v -116.26 84.7233 4.22423    0.972438 -0.232004 0.023194    0 0
  v -118.679 83.5516 3.88899    -0.123766 -0.992308 0.00249302    0 0
  v -120.131 85.1652 3.63307    -0.95215 0.221178 -0.210929    0 0
  v -117.96 86.3591 3.73064    0.13202 0.981076 -0.141637    0 0
  v -117.339 84.2581 0.829068    0.380096 -0.545914 -0.746663    0 0
  v -118.335 84.3738 0.676736    -0.238067 -0.355749 -0.903751    0 0
  v -118.153 85.0971 0.635567    -0.148345 0.344013 -0.927172    0 0
  v -117.157 84.9814 0.787899    0.50298 0.255314 -0.825727    0 0
  v -116.543 84.5692 1.4895    0.89646 -0.239261 -0.37298    0 0
  v -118.159 83.7794 1.23988    -0.0540715 -0.919329 -0.389757    0 0
  v -119.147 84.8692 1.09158    -0.709058 0.136242 -0.691863    0 0
  v -117.679 85.6689 1.13277    0.173059 0.849378 -0.498605    0 0
  v -106.722 60.2172 81.7699    0.348485 -0.911876 0.216888    0 0
  v -105.866 60.1354 72.4934    0.349666 -0.926866 -0.13658    0 0
  v -96.0117 65.5555 72.6633    0.627602 -0.767754 -0.129111    0 0
  v -97.2724 65.6399 81.8654    0.60948 -0.740565 0.283017    0 0
  v -106.575 59.8131 77.0873    0.566983 -0.821778 0.0566674    0 0
  v -100.836 62.6528 72.2306    0.468712 -0.868758 0.159902    0 0
  v -96.1556 65.6523 77.3506    0.422249 -0.903546 0.0728708    0 0
  v -101.894 62.8125 82.2073    0.500174 -0.865222 -0.0348809    0 0
  v -106.079 61.8779 76.988    0.997188 0.0219743 0.0716465    0 0
  v -101.38 64.1988 72.9906    -0.0265549 -0.0274951 0.999269    0 0
  v -97.4905 66.6923 77.2708    -0.972487 -0.204202 -0.112119    0 0
  v -102.189 64.3713 81.2682    0.0959983 -0.121484 -0.98794    0 0
  v -105.153 61.1484 80.3374    0.785112 -0.354751 -0.507692    0 0
  v -104.644 61.0467 73.8523    0.700297 -0.281182 0.656141    0 0
  v -97.8123 64.7761 74.1098    -0.258357 -0.721123 0.642833    0 0
  v -98.5742 64.9358 80.5096    -0.198953 -0.731988 -0.651622    0 0
  v -104.916 68.1607 76.7472    0.834532 -0.54531 0.0786987    0 0
  v -101.771 69.7139 74.068    0.315665 -0.639257 0.701217    0 0
  v -99.1684 71.3827 76.9364    -0.349732 -0.936727 -0.0151918    0 0
  v -102.313 69.8295 79.6156    0.404464 -0.694352 -0.595218    0 0
  v -105.157 65.4498 79.7794    0.777923 -0.189849 -0.598993    0 0
  v -104.708 65.3593 73.9889    0.679273 -0.127446 0.722735    0 0
  v -98.6338 68.6716 74.2229    -0.661124 -0.225764 0.715504    0 0
  v -99.3088 68.8207 79.9378    -0.541629 -0.28308 -0.79152    0 0
  v -123.247 60.1153 60.1217    0.00540471 -0.956571 -0.291448    0 0
  v -125.451 74.1236 107.133    0.0966571 -0.523848 0.84631    0 0
  v -122.262 63.9829 97.0649    0.131625 -0.780316 0.611377    0 0
  v -120.233 57.8748 84.511    0.135105 -0.961539 0.239145    0 0
  v -119.899 57.2042 70.6239    0.127654 -0.98636 -0.103915    0 0
  v -126.421 102.358 47.5221    0.107835 0.53808 -0.835967    0 0
  v -125.439 104.546 41.5883    0.19377 0.942964 0.270687    0 0
  v -124.969 105.652 33.5791    0.199241 0.979632 0.0249778    0 0
  v -125.271 104.919 25.0062    0.19633 0.961233 -0.193612    0 0
  v -126.207 102.644 17.9815    0.17276 0.830908 -0.528911    0 0
  v -127.751 98.9214 14.1664    0.116112 0.505494 -0.854982    0 0
  v -128.378 84.0698 12.3808    0.083619 -0.0742831 -0.993725    0 0
  v -122.236 58.4652 63.7249    0.0847802 -0.9217 -0.378525    0 0
  v -129.55 88.4115 110.868    4.40488e-007 -9.20597e-009 1    0 0
  v -129.55 92.6103 110.768    -4.80211e-008 0.116978 0.993134    0 0
  v -129.55 68.4056 102.714    2.73658e-007 -0.694058 0.719919    0 0
  v -129.55 108.417 102.714    -3.10021e-007 0.694058 0.719919    0 0
  v -129.55 59.5514 91.0636    -1.10138e-007 -0.894068 0.447932    0 0
  v -129.55 117.274 91.0626    -2.02535e-007 0.893538 0.448987    0 0
  v -129.55 56.3049 77.2783    -1.58561e-008 -0.999388 0.03498    0 0
  v -129.55 117.127 62.3101    -1.63355e-008 0.896927 -0.442178    0 0
  v -129.55 68.6009 51.3959    0 -0.582326 -0.812955    0 0
  v -129.55 108.163 51.4173    -4.90511e-007 0.593591 -0.804767    0 0
  v -129.55 103.896 44.7367    -5.03479e-008 0.921707 0.387886    0 0
  v -129.55 72.9266 44.7367    -5.03479e-008 -0.921707 0.387886    0 0
  v -129.55 105.748 37.7966    2.28558e-008 0.989333 0.14567    0 0
  v -129.55 105.955 29.2297    -1.03077e-007 0.995822 -0.0913147    0 0
  v -129.55 104.389 21.1642    -1.15718e-007 0.949316 -0.314324    0 0
  v -129.55 72.4343 21.1642    1.16651e-007 -0.949316 -0.314324    0 0
  v -129.55 97.2696 13.2257    -5.0111e-007 0.383202 -0.923665    0 0
  v -129.55 79.5533 13.2257    -1.16537e-010 -0.383202 -0.923665    0 0
  v -140.828 70.3439 102.72    -0.230834 -0.630346 0.741201    0 0
  v -150.245 68.7578 97.0636    -0.385408 -0.659434 0.645452    0 0
  v -150.138 75.9717 102.794    -0.425528 -0.452207 0.783859    0 0
  v -140.822 77.3666 107.282    -0.243665 -0.398561 0.884181    0 0
  v -159.549 76.7523 97.3264    -0.403978 -0.670128 0.62268    0 0
  v -162.101 80.7669 102.263    0.218253 -0.639623 0.737053    0 0
  v -154.726 84.2278 103.829    -0.359225 -0.084654 0.929404    0 0
  v -145.997 82.3753 107.373    -0.344454 -0.234803 0.908966    0 0
  v -161.39 85.6746 101.357    -0.244975 0.671593 0.69925    0 0
  v -163.3 88.6758 97.0362    -0.658787 0.271334 0.701696    0 0
  v -155.749 90.9051 102.864    -0.557528 0.135414 0.819039    0 0
  v -147.914 88.3246 107.375    -0.387165 0.0058739 0.921992    0 0
  v -160.784 96.5203 97.0465    -0.625456 0.337439 0.70352    0 0
  v -150.429 100.421 102.724    -0.451003 0.431696 0.781175    0 0
  v -146.241 94.0785 107.3    -0.3586 0.224319 0.906139    0 0
  v -150.295 107.966 97.0644    -0.403274 0.645607 0.648508    0 0
  v -140.828 106.479 102.72    -0.230834 0.630346 0.741201    0 0
  v -140.833 99.4438 107.279    -0.248491 0.395586 0.884174    0 0
  v -136.838 112.84 97.0649    -0.131625 0.780316 0.611377    0 0
  v -133.648 102.699 107.133    -0.0966573 0.523848 0.84631    0 0
  v -146.182 62.3054 91.0874    -0.282809 -0.820978 0.495998    0 0
  v -155.83 63.7707 86.1683    -0.445474 -0.770311 0.456261    0 0
  v -159.848 70.216 90.9935    -0.572298 -0.605324 0.553225    0 0
  v -167.981 74.6878 84.4169    -0.789259 -0.485987 0.37535    0 0
  v -168.522 81.9602 90.3113    -0.914006 -0.270429 0.302425    0 0
  v -166.72 79.3731 97.571    -0.507172 -0.860616 -0.0460193    0 0
  v -167.634 85.4986 95.4379    -0.80532 0.555612 0.206773    0 0
  v -172.326 88.3993 84.4267    -0.918479 -0.00638559 0.395419    0 0
  v -168.227 92.5256 90.865    -0.786923 0.194435 0.585617    0 0
  v -168.161 101.472 84.5023    -0.774977 0.50343 0.382059    0 0
  v -160.081 105.881 91.0603    -0.595996 0.589693 0.545023    0 0
  v -155.906 112.884 84.5124    -0.484122 0.827168 0.285341    0 0
  v -146.141 114.475 91.0634    -0.29577 0.832487 0.468493    0 0
  v -138.849 118.91 84.5059    -0.160514 0.95844 0.235854    0 0
  v -166.404 69.1833 77.2069    -0.787887 -0.606088 0.109049    0 0
  v -169.926 74.8179 69.5725    -0.820187 -0.523994 -0.229615    0 0
  v -173.37 81.2621 77.1429    -0.941932 -0.305984 0.138342    0 0
  v -174.358 88.4115 69.5609    -0.975338 -1.09961e-007 -0.220718    0 0
  v -173.367 95.5304 77.1628    -0.941522 0.305651 0.141824    0 0
  v -169.843 101.97 69.5609    -0.799434 0.559489 -0.218807    0 0
  v -164.532 108.422 77.1693    -0.661254 0.745485 0.083643    0 0
  v -157.203 112.844 69.56    -0.471478 0.85401 -0.219941    0 0
  v -148.732 117.355 77.1626    -0.326865 0.944835 0.0211162    0 0
  v -139.314 118.906 69.5309    -0.158205 0.961828 -0.223289    0 0
  v -129.55 120.537 77.1394    1.54039e-008 0.999991 0.00420383    0 0
  v -148.227 62.7136 61.9549    -0.323547 -0.78667 -0.525802    0 0
  v -151.085 69.0452 56.1316    -0.348509 -0.606177 -0.714907    0 0
  v -161.845 70.4602 62.3262    -0.553246 -0.628594 -0.546616    0 0
  v -157.56 63.7766 67.8921    -0.450459 -0.791155 -0.413714    0 0
  v -160.949 77.6583 56.1425    -0.505359 -0.34985 -0.788808    0 0
  v -169.941 82.0225 62.3401    -0.774432 -0.259002 -0.577211    0 0
  v -164.487 88.4115 56.1425    -0.566306 -6.12488e-008 -0.824195    0 0
  v -169.941 94.8004 62.3401    -0.774432 0.259002 -0.577211    0 0
  v -160.949 99.1646 56.1425    -0.505358 0.34985 -0.788808    0 0
  v -161.785 106.313 62.3401    -0.557492 0.65173 -0.514248    0 0
  v -151.049 107.787 56.1422    -0.343389 0.614797 -0.710006    0 0
  v -147.212 114.28 62.3332    -0.283541 0.842124 -0.458728    0 0
  v -137.118 112.531 56.1356    -0.122335 0.749898 -0.650144    0 0
  v -140.41 70.5599 51.4074    -0.20771 -0.558462 -0.803104    0 0
  v -138.61 77.166 47.5221    -0.258969 -0.375199 -0.890034    0 0
  v -149.464 76.0366 51.4183    -0.341633 -0.372714 -0.862769    0 0
  v -142.975 82.1693 47.5221    -0.317173 -0.178534 -0.931411    0 0
  v -154.577 83.9949 51.4183    -0.404016 -0.126177 -0.906008    0 0
  v -144.538 88.4115 47.5221    -0.329575 -2.32884e-008 -0.94413    0 0
  v -154.577 92.828 51.4183    -0.404016 0.126177 -0.906008    0 0
  v -142.975 94.6537 47.5221    -0.317173 0.178534 -0.931411    0 0
  v -149.464 100.786 51.4183    -0.341632 0.372714 -0.86277    0 0
  v -138.61 99.657 47.5221    -0.258969 0.3752 -0.890034    0 0
  v -140.374 106.272 51.4181    -0.20435 0.569949 -0.795864    0 0
  v -132.679 102.358 47.5221    -0.107835 0.538081 -0.835967    0 0
  v -185.118 75.8558 125.697    -0.0803548 -0.40172 0.91223    0 0
  v -187.291 75.575 124.787    -0.485802 -0.547597 0.681274    0 0
  v -187.852 77.4871 125.007    -0.628604 0.0845162 0.77312    0 0
  v -185.679 77.7678 125.918    -0.16484 0.128002 0.977979    0 0
  v -170.51 79.2213 106.478    0.183199 -0.982746 0.0254652    0 0
  v -175.232 78.2619 113.666    0.710742 -0.610094 0.350186    0 0
  v -169.196 81.0904 107.164    0.623454 0.191627 0.758013    0 0
  v -172.158 80.6225 104.757    -0.817828 -0.211229 -0.535293    0 0
  v -177.041 78.0045 112.705    -0.297856 -0.821025 -0.487032    0 0
  v -169.18 83.309 103.68    -0.262844 0.944226 0.19837    0 0
  v -177.11 79.866 112.26    -0.651105 0.656279 -0.381261    0 0
  v -175.272 80.1289 113.265    0.402432 0.780081 0.479084    0 0
  v -178.466 76.3827 116.453    0.291919 -0.878851 -0.377365    0 0
  v -177.493 76.3779 118.52    0.865266 -0.428268 -0.260579    0 0
  v -177.108 78.4255 117.462    0.924842 0.214911 0.313815    0 0
  v -181.154 77.8958 115.734    -0.527478 -0.0691555 -0.846749    0 0
  v -181.619 75.8528 116.793    -0.0698354 -0.52286 -0.849553    0 0
  v -179.44 79.9881 116.768    -0.0516389 0.984711 -0.166364    0 0
  v -182.693 79.4806 117.208    -0.223147 0.596712 -0.770805    0 0
  v -178.567 80.0057 118.935    0.570588 0.804227 -0.166278    0 0
  v -179.767 74.3492 118.501    0.317317 -0.820496 -0.475496    0 0
  v -178.072 75.2409 121.032    0.768254 -0.602115 0.217356    0 0
  v -177.172 78.2418 120.43    0.955314 0.260823 0.139092    0 0
  v -184.976 77.2598 117.166    -0.397272 -0.0138681 -0.917596    0 0
  v -184.234 74.4698 118.456    -0.252053 -0.743562 -0.619342    0 0
  v -181.808 81.2069 119.281    0.0409147 0.93259 -0.358612    0 0
  v -185.85 79.8824 119.07    -0.462919 0.681062 -0.567328    0 0
  v -179.689 80.6536 121.646    0.484444 0.83624 0.256938    0 0
  v -181.893 73.1258 121.223    0.144082 -0.989248 -0.025077    0 0
  v -180.947 74.7746 124.221    0.406141 -0.601325 0.688083    0 0
  v -178.725 77.8738 123.573    0.732073 0.139491 0.666792    0 0
  v -188.256 76.6832 119.588    -0.752655 -0.144773 -0.642302    0 0
  v -186.911 74.0273 121.727    -0.471081 -0.878977 -0.0740361    0 0
  v -184.395 81.4968 122.172    -0.145619 0.987456 0.0610392    0 0
  v -188.474 79.2667 122.322    -0.777715 0.628605 -0.00402531    0 0
  v -182.51 80.014 124.816    0.227024 0.631575 0.741332    0 0
  v -184.854 74.015 124.266    -0.141182 -0.801582 0.580977    0 0
  v -182.73 77.1989 125.848    0.207807 -0.0489233 0.976946    0 0
  v -189.105 76.3909 123.18    -0.898839 -0.29413 0.324924    0 0
  v -186.516 79.6191 124.907    -0.377126 0.587532 0.715949    0 0
  v -142.772 98.1155 44.7378    -0.642267 0.611736 0.461815    0 0
  v -141.193 101.29 41.5884    -0.542206 0.778636 0.315815    0 0
  v -136.73 102.388 44.7367    -0.367138 0.826688 0.426375    0 0
  v -146.109 92.2384 44.8133    -0.809525 0.223708 0.542792    0 0
  v -146.484 95.8626 41.5954    -0.793291 0.484093 0.369247    0 0
  v -145.45 84.9935 45.9063    -0.540841 -0.137563 0.8298    0 0
  v -147.878 87.1203 44.2738    -0.458522 0.448305 0.76732    0 0
  v -148.444 89.7964 41.6866    -0.89277 0.220535 0.392844    0 0
  v -142.67 78.6629 44.8086    -0.637479 -0.609648 0.471116    0 0
  v -145.964 80.0867 41.6884    -0.668917 -0.661107 0.339836    0 0
  v -146.621 82.2924 44.3166    -0.261954 -0.628712 0.732189    0 0
  v -136.73 74.4347 44.7367    -0.371418 -0.845574 0.383476    0 0
  v -141.175 75.5123 41.5904    -0.537642 -0.782088 0.315086    0 0
  v -132.679 74.4647 47.5221    -0.188951 -0.887997 0.419236    0 0
  v -133.66 72.2773 41.5883    -0.193772 -0.942964 0.270687    0 0
  v -145.241 99.1195 37.7978    -0.712301 0.679188 0.177004    0 0
  v -142.425 102.101 33.5791    -0.574021 0.818379 0.0274913    0 0
  v -138.217 103.98 37.7966    -0.390345 0.906809 0.159148    0 0
  v -149.071 92.5614 37.7811    -0.948484 0.25814 0.183691    0 0
  v -148.097 95.9733 33.5793    -0.872359 0.488612 0.0157307    0 0
  v -149.944 86.9372 39.3603    -0.872147 0.41007 -0.266837    0 0
  v -149.439 84.5366 36.6613    -0.968228 -0.249814 -0.0113424    0 0
  v -150.075 88.4796 33.5101    -0.999748 0.00987899 0.0201507    0 0
  v -148.648 81.9814 39.4031    -0.615961 -0.748717 -0.244979    0 0
  v -145.205 77.669 37.7763    -0.713521 -0.679248 0.171783    0 0
  v -148.098 80.8611 33.5092    -0.870801 -0.491347 0.0168406    0 0
  v -138.217 72.8429 37.7966    -0.390345 -0.906809 0.159148    0 0
  v -142.424 74.7219 33.5782    -0.574241 -0.818219 0.0276466    0 0
  v -129.55 71.0745 37.7966    2.19229e-008 -0.989333 0.14567    0 0
  v -134.13 71.1709 33.5791    -0.199241 -0.979632 0.0249786    0 0
  v -145.493 99.1516 29.2297    -0.733899 0.668792 -0.118786    0 0
  v -141.635 101.554 25.0062    -0.562841 0.796166 -0.222103    0 0
  v -138.375 104.157 29.2297    -0.392857 0.914234 -0.0991912    0 0
  v -149.317 92.213 29.2289    -0.958796 0.249185 -0.136441    0 0
  v -147.034 95.6156 25.0062    -0.847644 0.463637 -0.257953    0 0
  v -149.323 84.6185 29.2005    -0.958243 -0.248393 -0.141674    0 0
  v -148.907 88.4115 25.0062    -0.961578 -4.76132e-008 -0.274533    0 0
  v -145.492 77.6713 29.2288    -0.733992 -0.668723 -0.118595    0 0
  v -147.034 81.2073 25.0062    -0.847644 -0.463638 -0.257953    0 0
  v -138.375 72.6655 29.2297    -0.392857 -0.914234 -0.0991911    0 0
  v -141.635 75.2685 25.0062    -0.562841 -0.796166 -0.222104    0 0
  v -129.55 70.8682 29.2297    -3.21824e-008 -0.995822 -0.0913146    0 0
  v -133.828 71.9043 25.0062    -0.19633 -0.961233 -0.193612    0 0
  v -143.546 98.3015 21.1642    -0.682564 0.617395 -0.391062    0 0
  v -139.186 99.8673 17.9815    -0.472236 0.660424 -0.58381    0 0
  v -137.196 102.811 21.1642    -0.374809 0.862906 -0.338986    0 0
  v -147.036 91.9187 21.164    -0.872566 0.225199 -0.43349    0 0
  v -143.772 94.7597 17.9813    -0.672807 0.364939 -0.643545    0 0
  v -147.054 84.9012 21.1737    -0.87666 -0.226527 -0.424443    0 0
  v -145.426 88.3917 17.9919    -0.748103 0.0141076 -0.663432    0 0
  v -143.546 78.5218 21.164    -0.682584 -0.617158 -0.391402    0 0
  v -143.796 82.0689 17.9919    -0.670793 -0.379669 -0.637093    0 0
  v -137.196 74.0123 21.1642    -0.374809 -0.862906 -0.338985    0 0
  v -139.185 76.956 17.9813    -0.472389 -0.660153 -0.583992    0 0
  v -132.892 74.1791 17.9815    -0.17276 -0.830908 -0.528911    0 0
  v -139.432 96.5111 15.6753    -0.432761 0.387635 -0.813915    0 0
  v -134.813 96.9208 14.0558    -0.261982 0.349805 -0.899445    0 0
  v -134.707 99.9742 15.6784    -0.26856 0.587694 -0.763211    0 0
  v -142.215 91.334 15.6706    -0.522275 0.134907 -0.842039    0 0
  v -138.138 93.2993 14.0892    -0.344153 0.189339 -0.919624    0 0
  v -143.011 85.3888 15.9972    -0.67146 -0.173114 -0.720537    0 0
  v -141.494 87.1827 14.272    -0.733782 0.480886 -0.479909    0 0
  v -139.387 89.0644 14.0108    -0.360401 0.21305 -0.908141    0 0
  v -139.412 80.2968 15.6691    -0.434318 -0.391888 -0.811044    0 0
  v -137.812 82.8937 14.0122    -0.270612 -0.394431 -0.878176    0 0
  v -140.666 83.9874 14.2916    -0.510975 -0.761934 -0.397946    0 0
  v -134.707 76.8488 15.6784    -0.26856 -0.587695 -0.763211    0 0
  v -134.803 79.8867 14.0554    -0.259298 -0.353864 -0.898635    0 0
  v -129.55 75.7244 15.6827    -9.33484e-010 -0.684516 -0.728998    0 0
  v -131.348 77.9015 14.1664    -0.116112 -0.505495 -0.854981    0 0
  v -133.935 94.0598 13.0005    -0.209396 0.182374 -0.960673    0 0
  v -130.724 92.751 12.3812    -0.0843313 0.0740005 -0.993686    0 0
  v -129.55 94.9128 12.5709    9.80668e-007 0.185378 -0.982667    0 0
  v -131.329 96.5479 13.112    -0.152632 0.297331 -0.942495    0 0
  v -135.918 90.568 13.0347    -0.247051 0.0647552 -0.966836    0 0
  v -132.441 91.079 12.4434    -0.118141 0.0558313 -0.991426    0 0
  v -137.467 87.517 12.812    0.132973 0.562572 -0.815985    0 0
  v -135.005 86.3986 12.7307    -0.0883198 -0.0238157 -0.995807    0 0
  v -133.015 88.4414 12.4282    -0.126663 0.0117032 -0.991877    0 0
  v -136.721 84.6217 12.8317    0.299858 -0.510953 -0.805613    0 0
  v -133.884 82.7091 12.9954    -0.205568 -0.183863 -0.961216    0 0
  v -132.35 85.7234 12.4254    -0.105591 -0.0644356 -0.99232    0 0
  v -131.329 80.275 13.112    -0.152634 -0.297329 -0.942496    0 0
  v -129.55 81.9102 12.5709    -9.79736e-007 -0.185379 -0.982667    0 0
  v -130.721 84.0698 12.3808    -0.0836185 -0.0742851 -0.993725    0 0
  v -161.471 81.9154 36.1013    -0.722633 -0.631154 -0.281863    0 0
  v -159.874 81.8769 35.2265    -0.0164784 -0.689695 -0.723912    0 0
  v -159.841 83.361 34.7662    -0.0754698 0.240118 -0.967806    0 0
  v -161.437 83.3995 35.641    -0.788267 0.419585 -0.450093    0 0
  v -149.221 81.6578 42.234    -0.142395 -0.984973 0.0977298    0 0
  v -151.341 82.6672 44.1409    -0.0561417 -0.709376 0.702591    0 0
  v -149.07 84.5333 45.0526    -0.0596524 0.0211875 0.997994    0 0
  v -150.937 84.2463 39.0086    -0.257416 -0.101643 -0.96094    0 0
  v -151.894 82.4967 40.194    0.0507727 -0.801175 -0.596272    0 0
  v -150.693 87.1589 42.025    -0.325021 0.943847 0.0592827    0 0
  v -152.755 85.8457 39.9326    -0.0286264 0.730141 -0.682696    0 0
  v -152.201 86.0162 43.8795    -0.186925 0.733965 0.652958    0 0
  v -153.543 81.7479 41.9242    0.0547083 -0.997353 0.0478944    0 0
  v -156.114 82.3234 42.6963    -0.290944 -0.712018 0.639048    0 0
  v -154.23 84.1534 44.3089    -0.318757 0.0348182 0.947197    0 0
  v -153.952 83.9316 38.7666    0.338859 -0.0343628 -0.94021    0 0
  v -155.215 82.1892 39.1993    0.411142 -0.766862 -0.492833    0 0
  v -154.553 86.4451 41.3951    -0.134332 0.989928 -0.0446927    0 0
  v -155.73 85.2892 38.7342    0.270151 0.723308 -0.635488    0 0
  v -156.63 85.4235 42.2312    -0.490952 0.700945 0.517341    0 0
  v -157.258 81.373 39.8806    0.0555473 -0.995887 0.0715812    0 0
  v -159.77 81.8526 39.418    -0.511717 -0.707929 0.486808    0 0
  v -158.655 83.5165 41.5635    -0.707591 0.0461674 0.705113    0 0
  v -156.438 83.3447 37.1017    0.701913 -0.0515255 -0.710397    0 0
  v -157.8 81.7559 36.9913    0.483703 -0.802336 -0.349697    0 0
  v -157.812 85.5954 39.0071    -0.219559 0.964142 -0.149077    0 0
  v -158.039 84.3446 36.3001    0.388067 0.710888 -0.586551    0 0
  v -160.009 84.4413 38.7267    -0.636708 0.725955 0.259987    0 0
  v -159.938 81.1702 36.9621    -0.0783162 -0.995536 -0.0526678    0 0
  v -161.532 82.8626 37.6567    -0.923286 0.0772279 0.37627    0 0
  v -158.373 82.7588 35.1718    0.573261 -0.206933 -0.792812    0 0
  v -160.042 84.473 35.9705    -0.225572 0.91452 -0.335813    0 0
  v -141.76 84.2581 0.829075    -0.3801 -0.545914 -0.746661    0 0
  v -140.764 84.3738 0.676743    0.238081 -0.355743 -0.90375    0 0
  v -140.946 85.0971 0.635567    0.148338 0.344011 -0.927174    0 0
  v -141.943 84.9814 0.787899    -0.502977 0.255316 -0.825729    0 0
  v -139.03 83.9561 12.2609    0.108963 -0.990119 -0.0882677    0 0
  v -141.282 84.2311 10.8094    -0.415227 -0.899955 0.132918    0 0
  v -141.965 85.4074 12.9919    -0.963166 -0.231335 0.137095    0 0
  v -137.301 85.9552 11.7148    0.836411 0.195195 -0.512168    0 0
  v -138.23 84.582 10.2286    0.740308 -0.658429 -0.135707    0 0
  v -139.934 87.4416 12.169    -0.157268 0.969319 -0.188912    0 0
  v -138.805 86.8169 10.1241    0.471917 0.855855 -0.211677    0 0
  v -141.857 86.466 10.7049    -0.691215 0.721191 0.0458848    0 0
  v -139.917 83.7628 8.27596    0.129554 -0.990758 0.0401786    0 0
  v -141.785 83.9453 6.21745    -0.425085 -0.901436 0.0819429    0 0
  v -142.629 85.0755 8.65024    -0.968712 -0.226813 0.100765    0 0
  v -138.295 85.5697 7.97153    0.957903 0.2253 -0.177937    0 0
  v -138.963 84.267 5.78652    0.749887 -0.658697 -0.0615461    0 0
  v -140.724 86.9094 8.10182    -0.126725 0.986888 -0.099966    0 0
  v -139.488 86.3136 5.67117    0.482335 0.86102 -0.161236    0 0
  v -142.31 85.9919 6.1021    -0.700016 0.713229 -0.0357943    0 0
  v -140.421 83.5516 3.88899    0.123766 -0.992308 0.00249252    0 0
  v -141.977 83.8363 2.46834    -0.442645 -0.89569 -0.0424876    0 0
  v -142.839 84.7233 4.22421    -0.972439 -0.232002 0.023193    0 0
  v -138.969 85.1652 3.63307    0.95215 0.221176 -0.21093    0 0
  v -139.661 84.1015 2.11456    0.710768 -0.652985 -0.26157    0 0
  v -141.139 86.3591 3.73064    -0.132017 0.981076 -0.141638    0 0
  v -140.09 85.7816 2.01964    0.457808 0.826273 -0.328154    0 0
  v -142.406 85.5164 2.37344    -0.712416 0.68226 -0.164273    0 0
  v -140.94 83.7794 1.23988    0.0540696 -0.919329 -0.389756    0 0
  v -142.556 84.5692 1.4895    -0.896459 -0.239263 -0.37298    0 0
  v -139.952 84.8692 1.09158    0.709061 0.13624 -0.69186    0 0
  v -141.42 85.6689 1.13277    -0.173063 0.849374 -0.49861    0 0
  v -147.13 58.3176 77.1463    -0.197201 -0.979815 0.0327919    0 0
  v -153.233 60.1354 72.4934    -0.349666 -0.926865 -0.13658    0 0
  v -152.524 59.8131 77.0873    -0.566986 -0.821776 0.0566667    0 0
  v -152.377 60.2172 81.7699    -0.348485 -0.911876 0.216887    0 0
  v -163.087 65.5555 72.6633    -0.6276 -0.767755 -0.129111    0 0
  v -158.263 62.6528 72.2306    -0.468712 -0.868758 0.159901    0 0
  v -161.827 65.6342 81.8613    -0.608087 -0.742838 0.28004    0 0
  v -162.944 65.6523 77.3506    -0.422252 -0.903545 0.0728716    0 0
  v -157.205 62.8125 82.2073    -0.500174 -0.865222 -0.0348814    0 0
  v -154.183 68.1607 76.7472    -0.834533 -0.545309 0.0786969    0 0
  v -157.328 69.7139 74.068    -0.315664 -0.639257 0.701218    0 0
  v -159.931 71.3827 76.9364    0.349733 -0.936726 -0.0151919    0 0
  v -156.786 69.8295 79.6156    -0.404463 -0.694352 -0.595218    0 0
  v -154.455 61.0467 73.8523    -0.700296 -0.281183 0.656142    0 0
  v -153.02 61.8779 76.988    -0.997188 0.0219723 0.0716474    0 0
  v -153.946 61.1484 80.3374    -0.785112 -0.354756 -0.507689    0 0
  v -161.287 64.7761 74.1098    0.258352 -0.721126 0.642831    0 0
  v -157.719 64.1989 72.9906    0.026555 -0.0274951 0.999269    0 0
  v -160.525 64.9358 80.5096    0.198951 -0.73199 -0.651621    0 0
  v -161.609 66.6923 77.2708    0.972488 -0.204198 -0.112116    0 0
  v -156.91 64.3713 81.2682    -0.0959985 -0.121484 -0.98794    0 0
  v -154.391 65.3593 73.9889    -0.679272 -0.127447 0.722736    0 0
  v -153.942 65.4498 79.7794    -0.777924 -0.189849 -0.598992    0 0
  v -160.465 68.6716 74.2229    0.661122 -0.225765 0.715505    0 0
  v -159.79 68.8207 79.9378    0.541627 -0.283081 -0.791521    0 0
  v -138.152 64.4687 55.8208    -0.159844 -0.699635 -0.696391    0 0
  v -139.2 57.2042 70.6239    -0.127655 -0.98636 -0.103915    0 0
  v -129.55 57.4073 65.9439    1.86465e-008 -0.968328 -0.249681    0 0
  v -136.863 58.4652 63.7249    -0.0847803 -0.9217 -0.378524    0 0
  v -135.852 60.1153 60.1217    -0.00540116 -0.956573 -0.291442    0 0
  v -129.55 61.1 57.5938    -2.84699e-009 -0.721601 -0.692309    0 0
  v -133.648 74.1236 107.133    -0.0966574 -0.523848 0.84631    0 0
  v -133.648 80.3563 109.761    -0.130165 -0.259969 0.956804    0 0
  v -129.55 79.0687 109.609    -6.20863e-007 -0.333025 0.942918    0 0
  v -136.832 83.423 109.985    -0.162143 -0.163864 0.973066    0 0
  v -129.55 84.2127 110.768    -4.80211e-008 -0.116978 0.993135    0 0
  v -138.7 86.6593 110.024    -0.179282 -0.053123 0.982362    0 0
  v -129.55 86.2534 110.855    5.44061e-007 -0.0221087 0.999756    0 0
  v -138.728 90.1412 110.008    -0.183251 0.0563146 0.981452    0 0
  v -136.842 93.3874 109.981    -0.165258 0.161783 0.972891    0 0
  v -129.55 90.5695 110.855    5.43595e-007 0.0221087 0.999756    0 0
  v -133.648 96.4667 109.761    -0.130164 0.25997 0.956803    0 0
  v -129.55 97.7542 109.609    -4.66264e-010 0.333024 0.942918    0 0
  v -136.838 63.9829 97.0649    -0.131625 -0.780316 0.611376    0 0
  v -138.867 57.8748 84.511    -0.135106 -0.961538 0.239145    0 0
  v -133.66 104.546 41.5883    -0.193771 0.942964 0.270687    0 0
  v -134.13 105.652 33.5791    -0.199241 0.979632 0.0249777    0 0
  v -133.828 104.919 25.0062    -0.19633 0.961233 -0.193612    0 0
  v -132.892 102.644 17.9815    -0.17276 0.830908 -0.528911    0 0
  v -131.348 98.9214 14.1664    -0.116112 0.505494 -0.854982    0 0
  v -129.55 101.099 15.6827    4.66742e-010 0.684516 -0.728997    0 0
  v -123.226 62.0202 60.7825    -0.438638 -0.0565538 0.896883    0 0
  v -123.226 60.7801 62.7704    0.147993 0.0171193 -0.98884    0 0
  v -135.873 60.7801 62.7704    -0.147993 0.0171195 -0.98884    0 0
  v -135.873 62.0202 60.7824    0.438638 -0.0565537 0.896883    0 0
  v -129.55 60.7907 58.9918    -4.87159e-008 -0.413662 0.910431    0 0
  v -119.812 59.412 62.9368    -0.602166 -0.693635 -0.395306    0 0
  v -129.55 58.9949 62.1775    2.91505e-008 -0.436309 -0.899797    0 0
  v -139.287 59.412 62.9368    0.602164 -0.693635 -0.395308    0 0
  v -124.117 69.5178 60.8071    -0.485778 -0.284704 0.826416    0 0
  v -124.117 68.643 62.1248    0.0928602 -0.315586 -0.944342    0 0
  v -134.982 68.643 62.1248    -0.0928603 -0.315586 -0.944342    0 0
  v -134.982 69.5178 60.8071    0.485778 -0.284705 0.826416    0 0
  v -129.55 66.4631 59.245    8.67319e-008 -0.0349528 0.999389    0 0
  v -120.643 64.9558 62.8845    -0.905764 -0.240106 -0.3492    0 0
  v -129.55 64.6469 62.0238    -4.48605e-008 -0.0515484 -0.998671    0 0
  v -138.456 64.9558 62.8845    0.905763 -0.240107 -0.349201    0 0
  v -115.809 59.0567 65.1244    0.261186 -0.891041 -0.371253    0 0
  v -121.708 60.7289 59.858    0.242506 -0.697636 -0.674162    0 0
  v -143.291 59.0567 65.1244    -0.261187 -0.891041 -0.371252    0 0
  v -137.391 60.7289 59.858    -0.242507 -0.697635 -0.674163    0 0
  v -129.55 70.8862 60.1695    3.66024e-008 -0.928581 -0.371129    0 0
  v -117.754 73.8514 105.191    0.255599 -0.523071 0.813059    0 0
  v -113.704 69.1816 99.9755    0.304746 -0.652724 0.6936    0 0
  v -108.239 72.3592 99.9284    0.415749 -0.558054 0.718142    0 0
  v -113.616 76.3123 105.146    0.339724 -0.439263 0.831646    0 0
  v -109.989 79.4394 104.921    0.405398 -0.339031 0.848946    0 0
  v -103.663 76.389 99.7401    0.47016 -0.487256 0.735888    0 0
  v -98.7869 79.4558 100.01    0.115013 -0.79276 0.598585    0 0
  v -100.324 82.0047 102.144    0.0550661 -0.29009 0.955414    0 0
  v -107.886 82.9292 105.027    0.410529 -0.235491 0.880914    0 0
  v -106.791 86.3248 105.026    0.448185 -0.0316913 0.893379    0 0
  v -99.3902 84.8774 102.146    0.149363 0.235682 0.960284    0 0
  v -96.487 86.5022 100.014    0.376773 0.698956 0.607868    0 0
  v -99.122 90.2542 99.7273    0.606555 0.205699 0.767971    0 0
  v -106.651 89.8242 104.917    0.485237 0.0822362 0.870507    0 0
  v -108.113 93.6134 105.143    0.469148 0.205712 0.858827    0 0
  v -100.922 95.0628 99.915    0.594394 0.270332 0.757375    0 0
  v -103.979 100.055 99.9687    0.533277 0.410682 0.739565    0 0
  v -110.448 97.3089 105.202    0.417377 0.32974 0.846798    0 0
  v -113.708 100.496 105.202    0.337738 0.441436 0.831305    0 0
  v -108.302 104.388 99.9742    0.426113 0.551956 0.716779    0 0
  v -113.704 107.641 99.9755    0.305965 0.652189 0.693567    0 0
  v -117.754 102.972 105.191    0.25518 0.523388 0.812987    0 0
  v -122.258 104.747 105.155    0.170194 0.588946 0.790048    0 0
  v -119.795 109.816 99.9755    0.18589 0.714041 0.674975    0 0
  v -126.257 110.907 99.9755    0.0616743 0.743822 0.665526    0 0
  v -127.067 105.597 105.146    0.0454459 0.626952 0.777731    0 0
  v -110.43 65.3838 94.1098    0.343842 -0.742653 0.574665    0 0
  v -107.964 62.6167 88.2788    0.359924 -0.809116 0.464527    0 0
  v -100.717 66.9072 88.3307    0.525294 -0.6869 0.50223    0 0
  v -103.966 69.2265 94.1496    0.478348 -0.643399 0.59768    0 0
  v -98.843 74.1963 94.309    0.570759 -0.562294 0.59838    0 0
  v -94.8761 72.5368 88.1353    0.686716 -0.545922 0.479991    0 0
  v -90.8208 78.7378 87.9795    0.808623 -0.410587 0.421363    0 0
  v -92.2316 80.1455 94.118    0.822088 -0.568014 0.0391434    0 0
  v -95.2697 78.3565 96.389    0.353346 -0.875063 0.330774    0 0
  v -92.6633 86.382 96.3933    0.647216 0.66421 0.37408    0 0
  v -90.9916 83.9973 94.1199    0.998304 0.0270707 0.0515355    0 0
  v -88.8878 84.768 87.9773    0.891864 -0.115618 0.437278    0 0
  v -89.0339 91.2381 88.1328    0.85416 0.141242 0.500461    0 0
  v -93.4744 90.7055 94.2962    0.73591 0.215642 0.641821    0 0
  v -95.2075 96.5339 94.1362    0.68903 0.31637 0.652034    0 0
  v -90.9434 97.9577 87.9252    0.786467 0.364679 0.498476    0 0
  v -94.9463 104.325 87.8766    0.683766 0.56492 0.461875    0 0
  v -98.7684 102.441 94.103    0.610807 0.479086 0.63039    0 0
  v -103.951 107.559 94.1084    0.488007 0.638383 0.595245    0 0
  v -100.77 109.812 87.8794    0.542381 0.731263 0.413614    0 0
  v -108.04 114.084 87.8797    0.388542 0.840436 0.37776    0 0
  v -110.43 111.439 94.1098    0.348623 0.746992 0.566097    0 0
  v -117.763 114.049 94.1098    0.209274 0.810182 0.547548    0 0
  v -116.279 117.002 87.8783    0.232682 0.904923 0.356333    0 0
  v -125.065 118.478 87.8765    0.0777525 0.934938 0.346188    0 0
  v -125.568 115.364 94.1098    0.0699708 0.839915 0.538189    0 0
  v -91.8404 71.5966 80.9695    0.787447 -0.556526 0.264965    0 0
  v -90.7861 71.5333 73.3934    0.81014 -0.5837 -0.0544728    0 0
  v -86.8919 77.8768 73.3573    0.898582 -0.437612 -0.0323412    0 0
  v -87.9904 77.9351 80.9351    0.867465 -0.417998 0.269781    0 0
  v -85.7858 84.7866 80.9346    0.946171 -0.144219 0.289762    0 0
  v -84.5987 84.8395 73.3573    0.987166 -0.158457 -0.019864    0 0
  v -84.5987 91.9835 73.3573    0.987164 0.158651 -0.0183841    0 0
  v -85.8151 91.873 80.9657    0.942801 0.145878 0.299743    0 0
  v -88.015 98.8623 80.9242    0.864017 0.419928 0.277732    0 0
  v -86.8919 98.9461 73.3573    0.892604 0.449797 -0.0306756    0 0
  v -91.3646 105.383 73.3573    0.741645 0.668861 -0.0508734    0 0
  v -92.3615 105.355 80.9145    0.73296 0.638349 0.235118    0 0
  v -98.6202 110.979 80.915    0.571998 0.798597 0.187246    0 0
  v -97.7898 110.966 73.3573    0.569353 0.818863 -0.0728083    0 0
  v -105.8 115.423 73.3538    0.403633 0.910385 -0.0909933    0 0
  v -106.424 115.444 80.9134    0.408486 0.900329 0.150155    0 0
  v -115.276 118.534 80.9064    0.244663 0.961241 0.127105    0 0
  v -114.888 118.532 73.3397    0.242207 0.964777 -0.102671    0 0
  v -124.594 120.134 73.3222    0.0818644 0.990823 -0.107557    0 0
  v -124.725 120.111 80.8976    0.0821008 0.989719 0.117116    0 0
  v -106.32 62.7078 65.3318    0.379268 -0.810111 -0.447076    0 0
  v -109.059 65.71 58.9866    0.341548 -0.715852 -0.609016    0 0
  v -102.506 69.3921 59.0738    0.443555 -0.636798 -0.630672    0 0
  v -98.7885 66.9298 65.4912    0.517793 -0.717777 -0.465495    0 0
  v -92.6562 72.227 65.8921    0.694338 -0.581993 -0.423295    0 0
  v -97.0123 74.1005 59.0738    0.552589 -0.502697 -0.664786    0 0
  v -93.1878 79.5281 59.0738    0.638106 -0.326048 -0.697505    0 0
  v -88.5002 78.4461 65.8621    0.815441 -0.411637 -0.406954    0 0
  v -86.2919 85.0325 65.8621    0.89625 -0.146724 -0.418578    0 0
  v -91.227 85.3994 59.0738    0.685881 -0.111975 -0.719047    0 0
  v -91.227 91.4236 59.0738    0.685881 0.111975 -0.719047    0 0
  v -86.292 91.7904 65.8621    0.89625 0.146724 -0.418578    0 0
  v -88.5002 98.3768 65.8621    0.813599 0.417423 -0.404741    0 0
  v -93.1878 97.2949 59.0738    0.638148 0.326425 -0.697291    0 0
  v -97.0123 102.722 59.0738    0.553621 0.506542 -0.660999    0 0
  v -92.8073 104.466 65.8621    0.680067 0.624327 -0.38435    0 0
  v -98.9947 109.747 65.8621    0.525446 0.768928 -0.364219    0 0
  v -102.506 107.431 59.0738    0.444106 0.64753 -0.619253    0 0
  v -109.349 111.184 59.072    0.325694 0.744607 -0.582653    0 0
  v -106.707 113.964 65.8586    0.374724 0.858778 -0.349402    0 0
  v -115.451 116.905 65.8446    0.226071 0.912614 -0.340628    0 0
  v -117.091 113.787 59.065    0.198961 0.806535 -0.556702    0 0
  v -125.34 115.114 59.0562    0.0674452 0.836105 -0.544407    0 0
  v -124.785 118.422 65.827    0.0766708 0.938292 -0.337239    0 0
  v -113.539 69.4555 53.6077    0.265007 -0.560814 -0.784384    0 0
  v -119 73.9003 49.4185    0.232424 -0.422488 -0.876061    0 0
  v -115.334 76.2854 49.4185    0.279753 -0.326166 -0.902969    0 0
  v -108.152 72.5636 53.6251    0.338182 -0.469875 -0.815384    0 0
  v -103.773 76.4869 53.6251    0.396976 -0.347796 -0.849381    0 0
  v -112.372 79.2873 49.4185    0.308534 -0.226181 -0.923931    0 0
  v -110.311 82.7477 49.4185    0.322924 -0.132409 -0.937117    0 0
  v -100.724 81.0094 53.6251    0.435271 -0.213266 -0.874675    0 0
  v -99.1612 85.9016 53.6251    0.454244 -0.0710454 -0.88804    0 0
  v -109.254 86.4911 49.4185    0.328847 -0.0430448 -0.943402    0 0
  v -109.254 90.3319 49.4185    0.328847 0.0430448 -0.943402    0 0
  v -99.1612 90.9213 53.6251    0.454244 0.0710456 -0.88804    0 0
  v -100.724 95.8135 53.6251    0.435271 0.213266 -0.874675    0 0
  v -110.311 94.0752 49.4185    0.322924 0.132409 -0.937117    0 0
  v -112.372 97.5356 49.4185    0.308534 0.226182 -0.923931    0 0
  v -103.773 100.336 53.6251    0.396976 0.347797 -0.849381    0 0
  v -108.152 104.259 53.6251    0.337623 0.471132 -0.81489    0 0
  v -115.334 100.538 49.4185    0.279753 0.326165 -0.90297    0 0
  v -119 102.923 49.4185    0.232424 0.422487 -0.876061    0 0
  v -113.597 107.382 53.6248    0.260868 0.571157 -0.778285    0 0
  v -119.728 109.529 53.6234    0.164726 0.644504 -0.746646    0 0
  v -123.083 104.55 49.4185    0.156373 0.507316 -0.847454    0 0
  v -127.371 105.357 49.4185    0.0549813 0.55775 -0.828186    0 0
  v -126.234 110.609 53.6216    0.0563557 0.682463 -0.728744    0 0
  v -73.5411 76.7843 125.927    0.129905 -0.150339 0.980063    0 0
  v -72.7899 75.7175 125.385    0.285582 -0.482816 0.827848    0 0
  v -71.4214 76.5097 125.038    0.582287 -0.257549 0.77111    0 0
  v -72.2432 77.5832 125.601    0.397596 0.105587 0.911465    0 0
  v -93.0653 81.1894 104.527    -0.577821 -0.267451 0.771098    0 0
  v -92.4198 79.9484 103.615    -0.335459 -0.887656 0.31549    0 0
  v -85.984 78.7221 110.381    -0.47912 -0.85494 0.198802    0 0
  v -86.3933 79.4881 110.84    -0.764542 -0.26643 0.586933    0 0
  v -90.9213 79.6003 102.217    0.100302 -0.991197 -0.0864126    0 0
  v -89.4592 80.497 101.237    0.645943 -0.64444 -0.409212    0 0
  v -84.133 79.147 109.359    0.549232 -0.630276 -0.548723    0 0
  v -85.0799 78.5857 109.788    0.083022 -0.958062 -0.27427    0 0
  v -88.948 82.123 101.257    0.896423 0.226474 -0.380966    0 0
  v -89.742 83.3446 102.267    0.508941 0.860396 0.0264248    0 0
  v -84.4149 80.8221 109.927    0.478247 0.870016 -0.119802    0 0
  v -83.867 80.0416 109.414    0.798809 0.338377 -0.497398    0 0
  v -91.3018 83.4969 103.665    0.0698067 0.917777 0.390911    0 0
  v -92.6153 82.6196 104.547    -0.374325 0.518911 0.768513    0 0
  v -86.1273 80.3827 110.896    -0.549654 0.556169 0.623342    0 0
  v -85.319 80.9586 110.519    -0.0809613 0.938157 0.336612    0 0
  v -82.6296 78.1277 115.956    -0.874624 -0.256039 0.411675    0 0
  v -82.0679 77.2313 115.493    -0.548655 -0.835503 0.0302083    0 0
  v -80.9867 76.1214 117.553    -0.64216 -0.683901 -0.346279    0 0
  v -81.8767 77.493 118.232    -0.988588 -0.145779 -0.0379902    0 0
  v -80.9003 77.0735 114.96    0.0489885 -0.899754 -0.433638    0 0
  v -79.7106 77.7332 114.624    0.47264 -0.545815 -0.69188    0 0
  v -77.3023 76.9049 116.316    0.250979 -0.357072 -0.899727    0 0
  v -79.157 75.8861 116.787    -0.0722598 -0.706838 -0.703675    0 0
  v -79.4057 78.7816 114.737    0.667591 0.384172 -0.637758    0 0
  v -80.1379 79.6947 115.242    0.377392 0.884547 -0.274138    0 0
  v -77.9728 79.9105 117.25    0.156328 0.795032 -0.586076    0 0
  v -76.8286 78.5146 116.501    0.360011 0.376784 -0.853479    0 0
  v -81.3055 79.8525 115.775    -0.188733 0.962815 0.193306    0 0
  v -82.3247 79.1762 116.069    -0.666943 0.581469 0.465919    0 0
  v -81.403 79.1028 118.417    -0.78063 0.62475 0.0174587    0 0
  v -79.8026 80.1458 118.017    -0.32275 0.923191 -0.208687    0 0
  v -82.018 77.1263 119.514    -0.988487 -0.140217 -0.0568572    0 0
  v -80.7829 75.2282 118.581    -0.641313 -0.678173 -0.358885    0 0
  v -80.3501 74.481 119.7    -0.589927 -0.797468 -0.126613    0 0
  v -81.853 76.7877 120.831    -0.948896 -0.217878 0.228312    0 0
  v -78.2438 74.9072 117.518    -0.0771456 -0.695953 -0.713932    0 0
  v -75.6703 76.3239 116.858    0.233722 -0.34434 -0.909288    0 0
  v -74.1293 75.8189 117.601    0.360492 -0.450542 -0.816736    0 0
  v -77.2606 74.0935 118.408    0.00295798 -0.824708 -0.565551    0 0
  v -75.0075 78.5555 117.113    0.331152 0.372987 -0.866729    0 0
  v -76.5868 80.4864 118.155    0.13424 0.781215 -0.609658    0 0
  v -75.2367 80.8792 119.178    0.240042 0.84566 -0.476696    0 0
  v -73.3197 78.5332 117.91    0.482752 0.385531 -0.786331    0 0
  v -79.1259 80.8074 119.217    -0.330946 0.912385 -0.240891    0 0
  v -81.3552 79.358 119.769    -0.780613 0.624886 -0.0126654    0 0
  v -81.0435 79.502 121.14    -0.74394 0.620671 0.247631    0 0
  v -78.3263 81.2667 120.47    -0.275567 0.960574 -0.0368908    0 0
  v -81.0974 76.4549 122.392    -0.825103 -0.276226 0.492854    0 0
  v -79.4335 73.9026 121.141    -0.492849 -0.861478 0.122291    0 0
  v -77.9917 73.65 122.801    -0.353157 -0.859098 0.370448    0 0
  v -79.6431 76.1832 124.043    -0.633867 -0.309993 0.708602    0 0
  v -76.013 73.475 119.711    0.092246 -0.923833 -0.371514    0 0
  v -72.5462 75.3862 118.817    0.497578 -0.556293 -0.665548    0 0
  v -71.1566 75.1222 120.495    0.637725 -0.650108 -0.413119    0 0
  v -74.5971 73.2256 121.382    0.19048 -0.97458 -0.117942    0 0
  v -71.6484 78.3907 119.158    0.656091 0.384559 -0.649353    0 0
  v -73.7685 80.9863 120.563    0.357534 0.885513 -0.29671    0 0
  v -72.3699 80.6801 122.227    0.486537 0.872807 -0.0386    0 0
  v -70.2657 78.104 120.833    0.847259 0.35117 -0.398538    0 0
  v -77.189 81.4138 121.993    -0.198527 0.961364 0.190701    0 0
  v -80.1996 79.4594 122.733    -0.651391 0.571318 0.499285    0 0
  v -78.7522 79.1649 124.381    -0.503137 0.474643 0.722196    0 0
  v -75.7645 81.1045 123.646    -0.0940346 0.892375 0.441388    0 0
  v -77.558 76.105 125.266    -0.338716 -0.317303 0.885771    0 0
  v -76.1971 74.015 124.24    -0.135732 -0.754293 0.642354    0 0
  v -74.4163 74.8782 125.148    0.0575516 -0.604693 0.794376    0 0
  v -75.322 76.2556 125.829    -0.0877677 -0.289349 0.953191    0 0
  v -73.3997 73.6628 123.07    0.306934 -0.911928 0.272357    0 0
  v -70.5643 75.2244 122.341    0.733722 -0.674855 0.0788805    0 0
  v -70.8452 75.6837 123.954    0.670044 -0.54348 0.505639    0 0
  v -72.697 74.658 124.428    0.357259 -0.726535 0.586952    0 0
  v -69.8326 77.6827 122.621    0.967813 0.209584 0.13933    0 0
  v -71.5705 79.8084 123.769    0.607834 0.687672 0.397044    0 0
  v -71.5343 78.5951 124.879    0.581431 0.376235 0.721377    0 0
  v -70.3992 77.1959 124.128    0.815066 0.010591 0.579272    0 0
  v -74.3679 80.1606 124.939    0.070088 0.665281 0.743296    0 0
  v -76.8263 78.5632 125.546    -0.254232 0.294148 0.921327    0 0
  v -74.876 77.7677 126.003    -0.0315708 0.108798 0.993562    0 0
  v -73.2536 78.8152 125.599    0.213325 0.375443 0.901962    0 0
  v -121.284 101.068 46.1521    0.444701 0.763268 0.468682    0 0
  v -118.399 98.987 46.1524    0.573415 0.636809 0.515432    0 0
  v -116.937 99.7385 43.2312    0.593977 0.695134 0.404946    0 0
  v -120.14 101.981 43.2306    0.457303 0.80877 0.369817    0 0
  v -116.069 96.4278 46.1533    0.670913 0.473423 0.570742    0 0
  v -114.461 93.5028 46.173    0.737563 0.290362 0.609664    0 0
  v -112.607 94.1376 43.2584    0.799764 0.350921 0.487065    0 0
  v -114.37 97.0765 43.2335    0.707591 0.547846 0.446296    0 0
  v -113.682 90.2678 46.2472    0.781056 0.097309 0.616832    0 0
  v -113.897 86.8337 46.528    0.791303 -0.0975023 0.6036    0 0
  v -112.514 86.4175 45.2236    0.50904 0.0944657 0.855544    0 0
  v -111.133 88.5262 43.2929    0.746192 0.365159 0.556647    0 0
  v -111.759 90.9645 43.3463    0.845419 0.158294 0.510107    0 0
  v -114.756 83.4199 46.5272    0.752582 -0.291295 0.590565    0 0
  v -116.169 80.382 46.2451    0.675197 -0.473598 0.565521    0 0
  v -114.681 79.4562 43.3408    0.677605 -0.57619 0.457009    0 0
  v -113.035 81.1256 43.3137    0.490768 -0.715598 0.497057    0 0
  v -113.309 83.3122 45.232    0.416683 -0.335024 0.845065    0 0
  v -118.419 77.8333 46.1707    0.573619 -0.636849 0.515154    0 0
  v -121.284 75.7548 46.1521    0.444653 -0.763275 0.468717    0 0
  v -120.14 74.8418 43.2306    0.456055 -0.809336 0.37012    0 0
  v -116.999 77.0264 43.2526    0.587482 -0.697587 0.410168    0 0
  v -124.488 74.3203 46.1521    0.28029 -0.857094 0.432235    0 0
  v -127.845 73.6099 46.1521    0.0948029 -0.906581 0.411246    0 0
  v -127.593 72.4663 43.2306    0.0962098 -0.941138 0.324041    0 0
  v -123.754 73.2608 43.2306    0.28442 -0.896191 0.34051    0 0
  v -119.231 102.727 39.7645    0.474758 0.848829 0.232582    0 0
  v -115.778 100.331 39.7651    0.626519 0.738351 0.249621    0 0
  v -115.082 100.683 35.7226    0.649455 0.753564 0.101732    0 0
  v -118.681 103.195 35.7223    0.4851 0.868936 0.0981218    0 0
  v -113.035 97.5023 39.7674    0.762138 0.592214 0.261589    0 0
  v -111.148 94.3871 39.768    0.88192 0.386743 0.26953    0 0
  v -110.305 94.2674 35.718    0.920186 0.37935 0.0967036    0 0
  v -112.244 97.6639 35.7238    0.798095 0.594578 0.0975817    0 0
  v -110.187 91.0201 39.7585    0.945494 0.172759 0.276036    0 0
  v -109.766 88.4547 40.1786    0.925629 0.340743 0.164638    0 0
  v -109.326 86.1362 37.9489    0.984994 -0.000529546 -0.17259    0 0
  v -109.229 86.5439 35.3157    0.992094 -0.104549 0.0694129    0 0
  v -109.312 90.5207 35.689    0.985438 0.135833 0.102279    0 0
  v -110.174 82.8603 37.9573    0.860402 -0.475608 -0.183044    0 0
  v -111.72 80.8836 40.1994    0.643921 -0.756649 0.11335    0 0
  v -113.258 79.0437 39.7529    0.741031 -0.625825 0.243345    0 0
  v -112.259 79.1594 35.6864    0.79701 -0.596517 0.0945645    0 0
  v -110.234 82.6457 35.3148    0.919256 -0.388752 0.0619744    0 0
  v -115.823 76.4361 39.7622    0.623025 -0.743506 0.242979    0 0
  v -119.231 74.0961 39.7645    0.47377 -0.849561 0.231924    0 0
  v -118.681 73.6276 35.7223    0.48514 -0.868921 0.0980567    0 0
  v -115.085 76.1402 35.7151    0.650206 -0.752959 0.10142    0 0
  v -123.17 72.3954 39.7645    0.291943 -0.931997 0.214828    0 0
  v -127.392 71.5326 39.7645    0.0986387 -0.973796 0.204919    0 0
  v -127.27 70.9462 35.7223    0.100065 -0.991147 0.087266    0 0
  v -122.817 71.8519 35.7223    0.296205 -0.950761 0.0911913    0 0
  v -118.587 103.278 31.4043    0.487561 0.872102 -0.0414945    0 0
  v -114.964 100.732 31.4044    0.657397 0.752073 -0.0470797    0 0
  v -115.418 100.479 27.0865    0.650088 0.739753 -0.173641    0 0
  v -118.944 102.965 27.0865    0.482612 0.861115 -0.159893    0 0
  v -112.117 97.6264 31.4046    0.809463 0.58447 -0.0562601    0 0
  v -110.181 94.1279 31.4035    0.926177 0.371828 -0.0627689    0 0
  v -110.751 93.9788 27.0865    0.910173 0.362388 -0.200647    0 0
  v -112.641 97.4265 27.0865    0.798937 0.571099 -0.188536    0 0
  v -109.201 90.3694 31.3977    0.989734 0.128458 -0.062651    0 0
  v -109.184 86.5018 31.323    0.990535 -0.11858 -0.0691264    0 0
  v -109.794 86.5293 27.0865    0.970275 -0.123164 -0.208318    0 0
  v -109.794 90.2936 27.0865    0.970418 0.123952 -0.207183    0 0
  v -110.167 82.7131 31.3228    0.92415 -0.375927 -0.068006    0 0
  v -112.12 79.1967 31.3972    0.809467 -0.584541 -0.0554492    0 0
  v -112.641 79.3964 27.0865    0.79891 -0.57114 -0.188523    0 0
  v -110.751 82.8441 27.0865    0.909823 -0.36269 -0.201689    0 0
  v -114.964 76.0912 31.4029    0.657577 -0.751929 -0.0468552    0 0
  v -118.587 73.5448 31.4043    0.487579 -0.872093 -0.041485    0 0
  v -118.944 73.8575 27.0865    0.482613 -0.861115 -0.159892    0 0
  v -115.418 76.3442 27.0865    0.650095 -0.73975 -0.173628    0 0
  v -122.756 71.7558 31.4043    0.297023 -0.954098 -0.038388    0 0
  v -127.249 70.8425 31.4043    0.100342 -0.994273 -0.0367809    0 0
  v -127.328 71.2339 27.0865    0.0995041 -0.984789 -0.142445    0 0
  v -122.986 72.1186 27.0865    0.294628 -0.943992 -0.148574    0 0
  v -119.652 102.346 23.0204    0.471732 0.838161 -0.27378    0 0
  v -116.318 99.986 23.0204    0.631643 0.716703 -0.295575    0 0
  v -117.66 99.2505 19.4729    0.581929 0.657379 -0.478761    0 0
  v -120.708 101.421 19.4729    0.440732 0.777456 -0.448685    0 0
  v -113.674 97.0726 23.0204    0.77199 0.550184 -0.318322    0 0
  v -111.866 93.7666 23.0204    0.875083 0.34765 -0.336704    0 0
  v -113.531 93.4488 19.4725    0.786788 0.311263 -0.532992    0 0
  v -115.217 96.5444 19.4729    0.701914 0.498132 -0.509098    0 0
  v -110.948 90.2231 23.0204    0.930351 0.118468 -0.347005    0 0
  v -110.948 86.5998 23.0204    0.931113 -0.117698 -0.34522    0 0
  v -112.627 86.6948 19.4971    0.839823 -0.0951543 -0.534457    0 0
  v -112.674 90.1128 19.4711    0.831135 0.106736 -0.545731    0 0
  v -111.866 83.0564 23.0204    0.875414 -0.348597 -0.334859    0 0
  v -113.674 79.7503 23.0204    0.77193 -0.550264 -0.318329    0 0
  v -115.218 80.2818 19.4711    0.701115 -0.49935 -0.509007    0 0
  v -113.485 83.3696 19.4971    0.789925 -0.324658 -0.520208    0 0
  v -116.318 76.8369 23.0204    0.631649 -0.71668 -0.295617    0 0
  v -119.652 74.4771 23.0204    0.471734 -0.838159 -0.273782    0 0
  v -120.708 75.402 19.4729    0.440758 -0.777427 -0.448708    0 0
  v -117.661 77.5731 19.4725    0.582043 -0.657033 -0.479097    0 0
  v -123.442 72.8374 23.0204    0.289556 -0.922491 -0.255281    0 0
  v -127.485 72.0093 23.0204    0.0977247 -0.964559 -0.245105    0 0
  v -127.72 73.1666 19.4729    0.0925103 -0.908685 -0.407103    0 0
  v -124.122 73.9103 19.4729    0.273965 -0.864122 -0.42218    0 0
  v -122.211 100.105 16.7254    0.362919 0.630936 -0.685718    0 0
  v -119.57 98.2042 16.7254    0.465 0.521701 -0.715264    0 0
  v -121.999 96.8854 14.796    0.334408 0.374598 -0.864782    0 0
  v -124.126 98.4644 14.8013    0.276237 0.45661 -0.845695    0 0
  v -117.411 95.793 16.7254    0.547729 0.386203 -0.742186    0 0
  v -115.902 92.9941 16.7236    0.602723 0.236986 -0.761947    0 0
  v -118.857 92.4754 14.8058    0.424975 0.171673 -0.888777    0 0
  v -120.157 94.8531 14.8055    0.389228 0.274684 -0.879233    0 0
  v -115.138 89.9428 16.7163    0.633373 0.0879255 -0.768836    0 0
  v -114.9 86.8037 16.8465    0.670821 -0.0530636 -0.739719    0 0
  v -116.732 86.6039 15.19    0.765417 0.0477045 -0.641765    0 0
  v -118.303 88.1842 14.3688    0.490806 0.416761 -0.765127    0 0
  v -118.2 89.9724 14.7973    0.444638 0.0982473 -0.890306    0 0
  v -115.671 83.8059 16.8465    0.629591 -0.28157 -0.724109    0 0
  v -117.42 81.0462 16.7163    0.547698 -0.39628 -0.736878    0 0
  v -120.283 81.7812 14.7949    0.380048 -0.320519 -0.867659    0 0
  v -119.564 83.2874 14.3792    0.329701 -0.633859 -0.699657    0 0
  v -117.308 84.3734 15.1942    0.677577 -0.415691 -0.606704    0 0
  v -119.572 78.622 16.7236    0.465424 -0.521697 -0.714991    0 0
  v -122.211 76.7176 16.7254    0.362953 -0.63095 -0.685687    0 0
  v -124.126 78.3586 14.8013    0.275687 -0.457583 -0.845349    0 0
  v -122.024 79.8998 14.7939    0.333224 -0.382098 -0.861953    0 0
  v -125.089 75.4365 16.7254    0.232632 -0.71815 -0.655853    0 0
  v -128.053 74.813 16.7254    0.0784531 -0.765846 -0.63822    0 0
  v -128.449 76.7928 14.8356    0.0588467 -0.597126 -0.799986    0 0
  v -126.279 77.2814 14.8287    0.1915 -0.54345 -0.817306    0 0
  v -126.285 96.7146 13.4657    0.211584 0.318212 -0.924107    0 0
  v -124.726 95.4386 13.4393    0.237216 0.26722 -0.933982    0 0
  v -126.911 93.7803 12.6423    0.13531 0.14033 -0.980815    0 0
  v -128.656 94.1639 12.4866    0.0853856 0.136417 -0.986965    0 0
  v -128.477 95.5896 12.7592    0.0896243 0.224225 -0.970407    0 0
  v -123.111 93.8429 13.4868    0.276269 0.193097 -0.941482    0 0
  v -122.008 91.8865 13.4969    0.296673 0.121665 -0.947197    0 0
  v -124.873 91.0768 12.7019    0.179328 0.0758206 -0.980863    0 0
  v -125.742 92.6654 12.6899    0.171207 0.100353 -0.980111    0 0
  v -121.469 89.8241 13.4895    0.299959 0.0782783 -0.950735    0 0
  v -120.997 88.3102 13.3335    0.189187 0.43725 -0.879216    0 0
  v -122.927 87.1554 12.8067    -0.0329562 0.157519 -0.986966    0 0
  v -124.822 87.5225 12.6125    0.156356 0.00691588 -0.987677    0 0
  v -124.478 89.4085 12.696    0.186482 0.0275711 -0.982071    0 0
  v -123.393 85.3249 12.8109    -0.0794031 -0.142888 -0.986549    0 0
  v -122.148 83.8134 13.344    0.0459067 -0.536285 -0.842788    0 0
  v -123.276 82.7421 13.4777    0.253022 -0.230684 -0.939555    0 0
  v -125.8 84.1109 12.6823    0.161164 -0.107266 -0.981081    0 0
  v -125.262 85.757 12.6125    0.134607 -0.0829175 -0.987424    0 0
  v -124.759 81.3367 13.4374    0.232407 -0.271301 -0.934014    0 0
  v -126.285 80.1083 13.4657    0.210822 -0.318952 -0.924026    0 0
  v -128.477 81.2333 12.7592    0.0895362 -0.224306 -0.970397    0 0
  v -128.656 82.6591 12.4866    0.085203 -0.13649 -0.986971    0 0
  v -126.924 83.0322 12.6406    0.133528 -0.141016 -0.980961    0 0
  v -127.497 79.0767 13.6031    0.162809 -0.396815 -0.903345    0 0
  v -128.814 78.6879 13.6374    0.0399673 -0.455882 -0.889142    0 0
  v -128.82 80.1388 13.0255    0.062405 -0.31351 -0.947532    0 0
  v -97.5174 82.6263 35.6846    0.850066 -0.135459 -0.508958    0 0
  v -98.3032 81.8607 35.4957    0.357094 -0.68612 -0.633816    0 0
  v -99.1432 82.5883 34.8261    0.0987637 -0.28887 -0.95226    0 0
  v -98.3446 83.357 35.0307    0.445425 0.288813 -0.847457    0 0
  v -111.41 83.4909 44.8823    0.0882279 -0.381193 0.920276    0 0
  v -111.241 81.7797 43.2713    0.176205 -0.865531 0.468838    0 0
  v -108.981 82.0495 43.3367    0.0496018 -0.900801 0.43139    0 0
  v -108.95 83.5105 44.7966    0.0418707 -0.400816 0.915201    0 0
  v -110.359 81.6459 40.9026    0.33273 -0.929579 -0.158659    0 0
  v -109.235 83.1871 39.0627    0.465932 -0.563035 -0.682568    0 0
  v -107.727 83.2682 39.4495    0.0526502 -0.542715 -0.838265    0 0
  v -108.492 81.9526 41.1979    0.0772381 -0.952224 -0.295471    0 0
  v -108.631 85.4649 39.0162    0.581315 0.29228 -0.759372    0 0
  v -108.882 87.2167 40.7864    0.574489 0.791781 -0.207476    0 0
  v -107.252 86.6199 40.9278    0.189926 0.903401 -0.38444    0 0
  v -107.231 85.1351 39.3415    0.0977729 0.418167 -0.903093    0 0
  v -109.774 87.3164 43.1551    0.399916 0.772286 0.493601    0 0
  v -110.816 85.7346 44.8358    0.181112 0.346958 0.920227    0 0
  v -108.454 85.3774 44.6885    0.119701 0.452767 0.883557    0 0
  v -107.741 86.7168 43.0666    0.202032 0.89662 0.394025    0 0
  v -106.34 83.3962 44.4992    0.161167 -0.40646 0.899342    0 0
  v -106.604 82.0549 43.1492    0.0395429 -0.909682 0.413418    0 0
  v -104.344 81.9036 42.5069    0.0840071 -0.911227 0.403248    0 0
  v -103.854 83.1797 43.7187    0.334754 -0.404747 0.850952    0 0
  v -106.507 81.9693 41.0837    -0.0925111 -0.945136 -0.313304    0 0
  v -106.097 83.1823 39.3355    -0.209081 -0.517371 -0.829827    0 0
  v -104.591 82.9896 38.8433    -0.434169 -0.49491 -0.752703    0 0
  v -104.639 81.8275 40.5567    -0.21755 -0.934406 -0.282058    0 0
  v -105.682 84.9199 39.1688    -0.147089 0.439359 -0.886188    0 0
  v -105.47 86.3133 40.6669    0.034203 0.912153 -0.40842    0 0
  v -103.84 86.0385 40.0099    -0.0459385 0.909651 -0.412825    0 0
  v -104.272 84.674 38.6246    -0.35434 0.43692 -0.826767    0 0
  v -105.567 86.3988 42.7323    0.211443 0.911499 0.35279    0 0
  v -105.925 85.1338 44.3324    0.247875 0.459983 0.852627    0 0
  v -103.535 84.8641 43.5    0.438493 0.444399 0.781174    0 0
  v -103.546 86.1145 41.96    0.315241 0.898124 0.306589    0 0
  v -101.631 82.8997 42.3884    0.526036 -0.399918 0.750568    0 0
  v -102.316 81.692 41.3672    0.168762 -0.912007 0.373849    0 0
  v -100.579 81.4903 39.8319    0.239187 -0.912441 0.332025    0 0
  v -99.7535 82.6026 40.6091    0.659254 -0.390893 0.642329    0 0
  v -102.968 81.6249 39.6119    -0.290238 -0.929771 -0.226468    0 0
  v -103.26 82.7318 38.0003    -0.605301 -0.489502 -0.627693    0 0
  v -102.105 82.4593 36.9385    -0.660453 -0.526354 -0.535493    0 0
  v -101.52 81.4329 38.3637    -0.299257 -0.936928 -0.180585    0 0
  v -103.023 84.3337 37.7176    -0.520829 0.425153 -0.740258    0 0
  v -102.376 85.6294 38.9052    -0.073738 0.904371 -0.420328    0 0
  v -101.104 85.0824 37.4938    -0.102855 0.898526 -0.426698    0 0
  v -101.939 83.9191 36.5905    -0.599291 0.409746 -0.68772    0 0
  v -101.724 85.6966 40.6605    0.442172 0.87349 0.203715    0 0
  v -101.395 84.5015 42.1057    0.629951 0.438463 0.641023    0 0
  v -99.5873 84.0624 40.2611    0.731759 0.463373 0.499814    0 0
  v -100.163 85.1398 38.962    0.473385 0.8755 0.096989    0 0
  v -98.2484 82.3427 38.6497    0.761064 -0.37892 0.526499    0 0
  v -99.1357 81.3419 38.1475    0.307329 -0.91346 0.26672    0 0
  v -98.2103 81.4307 36.6436    0.428468 -0.902393 -0.0458502    0 0
  v -97.4304 82.2337 36.9168    0.913537 -0.369097 0.170933    0 0
  v -100.269 81.2969 37.0455    -0.252471 -0.949281 -0.187413    0 0
  v -101.08 82.2304 35.8949    -0.605912 -0.588777 -0.534988    0 0
  v -100.087 82.1586 35.1605    -0.312416 -0.593293 -0.741889    0 0
  v -99.2812 81.4015 35.9654    -0.0416153 -0.920045 -0.389598    0 0
  v -100.999 83.534 35.5201    -0.592301 0.361072 -0.720282    0 0
  v -100.066 84.5561 36.1085    -0.123729 0.880244 -0.458106    0 0
  v -99.2668 84.0089 35.1656    0.0620158 0.709844 -0.701623    0 0
  v -100.088 83.196 34.8415    -0.305137 0.139473 -0.94204    0 0
  v -98.9333 84.601 37.2104    0.463621 0.886026 0.00358935    0 0
  v -98.1674 83.6464 38.2749    0.787737 0.493784 0.368303    0 0
  v -97.4315 83.2711 36.5977    0.917375 0.395438 0.0452944    0 0
  v -98.1959 84.0381 35.8437    0.544551 0.782695 -0.301418    0 0
  v -117.223 84.6129 0.734968    0.460738 -0.164531 -0.872153    0 0
  v -117.818 84.3126 0.663427    0.0829778 -0.451099 -0.888608    0 0
  v -118.21 84.7276 0.584057    -0.185796 -0.0093701 -0.982544    0 0
  v -117.637 85.0292 0.622619    0.178116 0.287729 -0.941003    0 0
  v -117.64 84.7566 13.7929    0.738815 -0.671972 -0.0510418    0 0
  v -119.366 83.9132 13.2717    0.211104 -0.962871 -0.168267    0 0
  v -118.908 83.9997 11.6377    0.173168 -0.982127 0.0737454    0 0
  v -117.34 84.7589 11.9705    0.684035 -0.708182 0.174855    0 0
  v -121.218 84.176 12.665    -0.33026 -0.85664 -0.396354    0 0
  v -122.194 85.341 12.3172    -0.674246 -0.258013 -0.691969    0 0
  v -121.456 85.2364 11.036    -0.906817 -0.288559 -0.307273    0 0
  v -120.555 84.1907 11.2639    -0.451029 -0.88594 -0.108088    0 0
  v -121.839 86.7113 12.2962    -0.524727 0.508334 -0.682831    0 0
  v -120.333 87.5858 12.6127    -0.0766092 0.884514 -0.46018    0 0
  v -119.768 87.2326 11.1495    -0.183502 0.962303 -0.20075    0 0
  v -121.141 86.4532 10.9902    -0.706541 0.625791 -0.330432    0 0
  v -118.46 87.403 13.2194    0.482742 0.834309 -0.266248    0 0
  v -117.263 86.2069 13.7719    0.953081 0.286349 -0.0981838    0 0
  v -117.025 85.9757 11.9248    0.916762 0.375845 0.135234    0 0
  v -118.122 87.0416 11.5233    0.443809 0.895723 -0.0267272    0 0
  v -116.961 84.6109 9.79907    0.690339 -0.710408 0.13694    0 0
  v -118.486 83.8817 9.56051    0.174767 -0.980984 0.0844235    0 0
  v -118.21 83.746 7.24348    0.177407 -0.981445 0.0727547    0 0
  v -116.745 84.4447 7.45362    0.695794 -0.711557 0.0977582    0 0
  v -120.09 84.0652 9.29102    -0.464827 -0.884975 -0.0274734    0 0
  v -120.972 85.0695 9.12537    -0.943994 -0.287891 -0.161224    0 0
  v -120.603 84.8843 6.86455    -0.950563 -0.287332 -0.117774    0 0
  v -119.753 83.9218 7.00784    -0.466094 -0.884702 -0.00766755    0 0
  v -120.672 86.2377 9.06412    -0.738361 0.641557 -0.207913    0 0
  v -119.34 86.9856 9.13791    -0.20076 0.968556 -0.146953    0 0
  v -119.036 86.7195 6.8502    -0.203425 0.969354 -0.137733    0 0
  v -120.316 86.0034 6.80149    -0.744269 0.645213 -0.172523    0 0
  v -117.736 86.8022 9.4074    0.440633 0.896809 -0.0397033    0 0
  v -116.661 85.7791 9.73783    0.922901 0.377442 0.0760985    0 0
  v -116.459 85.5638 7.39057    0.92786 0.37216 0.0239447    0 0
  v -117.493 86.5437 7.08582    0.442388 0.894525 -0.0641777    0 0
  v -116.622 84.2932 5.21214    0.698676 -0.711636 0.0736611    0 0
  v -118.009 83.6308 5.00968    0.180181 -0.98203 0.0561464    0 0
  v -117.842 83.5908 3.11866    0.189044 -0.981968 0.00118701    0 0
  v -116.578 84.1956 3.30896    0.704042 -0.709998 0.015086    0 0
  v -119.471 83.7976 4.78638    -0.46427 -0.885429 -0.0216625    0 0
  v -120.277 84.7102 4.6539    -0.94838 -0.288465 -0.131773    0 0
  v -119.914 84.5768 2.79951    -0.929092 -0.291812 -0.22723    0 0
  v -119.176 83.7433 2.91489    -0.453811 -0.885909 -0.0960238    0 0
  v -120.005 85.7707 4.59411    -0.742608 0.643511 -0.185545    0 0
  v -118.792 86.4488 4.6369    -0.201806 0.967593 -0.151783    0 0
  v -118.557 86.1628 2.77834    -0.194089 0.957079 -0.215243    0 0
  v -119.666 85.5446 2.74488    -0.728806 0.629724 -0.268867    0 0
  v -117.33 86.282 4.8602    0.445407 0.891402 -0.0837521    0 0
  v -116.35 85.3536 5.15235    0.929975 0.367599 -0.00410878    0 0
  v -116.331 85.1633 3.25434    0.932177 0.355859 -0.0664153    0 0
  v -117.223 86.0103 2.98212    0.453247 0.880642 -0.13797    0 0
  v -116.662 84.1976 1.93477    0.706449 -0.691166 -0.152381    0 0
  v -117.703 83.6966 1.76642    0.21353 -0.963628 -0.160703    0 0
  v -117.629 83.9597 1.0148    0.232704 -0.810902 -0.536923    0 0
  v -116.902 84.3137 1.13358    0.639494 -0.549959 -0.537208    0 0
  v -118.807 83.8234 1.5978    -0.408868 -0.856713 -0.314435    0 0
  v -119.421 84.5144 1.51324    -0.8249 -0.283495 -0.489051    0 0
  v -118.815 84.5349 0.841091    -0.530266 -0.208794 -0.82172    0 0
  v -118.375 84.0461 0.900764    -0.240998 -0.683017 -0.689498    0 0
  v -119.217 85.3151 1.46792    -0.658017 0.561738 -0.501462    0 0
  v -118.297 85.8251 1.48455    -0.16772 0.900849 -0.400426    0 0
  v -118.023 85.4349 0.821904    -0.0686863 0.663261 -0.745229    0 0
  v -118.678 85.0764 0.810337    -0.444743 0.349873 -0.824495    0 0
  v -117.193 85.6984 1.65317    0.469296 0.832805 -0.293592    0 0
  v -116.458 84.9983 1.88947    0.918652 0.314143 -0.239566    0 0
  v -116.765 84.8551 1.10282    0.774587 0.154453 -0.613318    0 0
  v -117.278 85.3486 0.935929    0.434799 0.620626 -0.652514    0 0
  v -109.353 59.1272 80.2288    0.240428 -0.960425 0.140632    0 0
  v -108.885 59.041 73.9762    0.24816 -0.966105 -0.0711194    0 0
  v -106.491 59.7329 74.9172    0.417421 -0.908632 0.0121538    0 0
  v -106.88 59.7729 79.3169    0.416802 -0.905359 0.0812518    0 0
  v -104.375 61.3393 70.072    0.387206 -0.869606 -0.306362    0 0
  v -97.7367 65.0104 70.2014    0.551511 -0.766327 -0.329513    0 0
  v -98.4242 63.9612 72.1639    0.51057 -0.858531 -0.0473673    0 0
  v -103.109 61.4082 72.056    0.453214 -0.890219 -0.0459088    0 0
  v -94.0369 67.3208 74.159    0.748878 -0.661296 -0.043239    0 0
  v -94.8996 67.3523 80.317    0.724919 -0.645069 0.241616    0 0
  v -96.3012 65.7722 79.4988    0.561145 -0.817898 0.127119    0 0
  v -95.7012 65.7068 75.1411    0.56709 -0.822418 0.04514    0 0
  v -99.4487 65.0621 84.1549    0.540867 -0.730596 0.416765    0 0
  v -105.692 61.4458 84.12    0.376058 -0.848313 0.372755    0 0
  v -104.157 61.5185 82.294    0.464216 -0.871753 0.156684    0 0
  v -99.6834 64.0968 82.36    0.51634 -0.839248 0.170457    0 0
  v -103.644 69.4716 78.1788    0.674466 -0.70932 -0.204845    0 0
  v -103.387 69.4177 75.3578    0.63446 -0.68847 0.351381    0 0
  v -100.452 71.0479 75.4598    0.128049 -0.908138 0.398608    0 0
  v -100.745 71.1112 78.2688    0.176034 -0.931128 -0.319394    0 0
  v -106.094 60.2716 78.9498    0.773868 -0.627481 -0.085994    0 0
  v -105.806 60.22 75.2133    0.766469 -0.596378 0.238451    0 0
  v -105.65 61.118 75.3322    0.909889 -0.027569 0.413935    0 0
  v -105.898 61.1684 78.7481    0.960328 -0.0639101 -0.271452    0 0
  v -102.978 61.6185 72.8172    0.515082 -0.693134 0.504238    0 0
  v -99.0231 63.768 72.9594    0.298758 -0.836541 0.459284    0 0
  v -99.48 64.3393 73.295    -0.250223 -0.230741 0.940291    0 0
  v -103.082 62.3863 73.1509    0.331102 -0.0957806 0.938721    0 0
  v -96.6956 65.2592 75.5083    0.132445 -0.97219 0.193146    0 0
  v -97.1595 65.3467 79.1893    0.126927 -0.983721 -0.127208    0 0
  v -97.7673 65.7924 78.9903    -0.764878 -0.441926 -0.468683    0 0
  v -97.354 65.7017 75.6307    -0.843121 -0.431371 0.32104    0 0
  v -99.9879 63.9482 81.5855    0.343216 -0.855372 -0.387997    0 0
  v -103.767 61.7629 81.4986    0.582 -0.732594 -0.352961    0 0
  v -103.773 62.5308 81.0839    0.45915 -0.180668 -0.869793    0 0
  v -100.335 64.5241 81.1716    -0.140332 -0.302861 -0.942646    0 0
  v -105.948 63.4119 78.5757    0.959706 -0.0350684 -0.278808    0 0
  v -105.71 63.3648 75.2835    0.908255 -0.00139432 0.418415    0 0
  v -105.308 66.549 75.3792    0.872761 -0.310005 0.377073    0 0
  v -105.525 66.5924 78.2137    0.91518 -0.334064 -0.225494    0 0
  v -103.241 64.5843 73.1811    0.291258 -0.00720238 0.956618    0 0
  v -99.7747 66.4608 73.3198    -0.351422 -0.0505175 0.934853    0 0
  v -100.194 69.2251 73.6724    -0.176268 -0.403715 0.897744    0 0
  v -103.169 67.6054 73.5569    0.44808 -0.323519 0.833402    0 0
  v -97.7308 67.7711 75.5707    -0.951118 -0.129696 0.280274    0 0
  v -98.1309 67.8599 78.8084    -0.868306 -0.159844 -0.469569    0 0
  v -98.7572 70.434 78.4189    -0.673321 -0.557063 -0.486128    0 0
  v -98.4237 70.3602 75.6234    -0.753443 -0.542839 0.371012    0 0
  v -100.6 66.6404 80.9108    -0.234874 -0.140967 -0.96175    0 0
  v -103.904 64.7221 80.8266    0.423273 -0.0980649 -0.900679    0 0
  v -103.755 67.7274 80.1647    0.561207 -0.396409 -0.726572    0 0
  v -100.896 69.3776 80.2412    -0.0623143 -0.478293 -0.875986    0 0
  v -116.352 58.1674 67.7907    0.190191 -0.960865 -0.20141    0 0
  v -124.876 57.0711 68.1195    0.0600496 -0.982894 -0.174111    0 0
  v -125.414 57.9496 64.5126    0.0481338 -0.948424 -0.313328    0 0
  v -118.869 58.5168 64.6481    0.155955 -0.933692 -0.322332    0 0
  v -127.845 76.545 108.59    0.0175582 -0.431005 0.902179    0 0
  v -124.85 77.2275 108.634    0.145565 -0.381186 0.912966    0 0
  v -127.845 80.5571 110.055    0.0442272 -0.255945 0.965679    0 0
  v -127.067 82.8325 110.477    0.0708168 -0.180528 0.981017    0 0
  v -122.258 78.9629 108.811    0.179522 -0.325379 0.928386    0 0
  v -119.778 80.705 108.858    0.215771 -0.272033 0.937785    0 0
  v -126.257 84.1799 110.61    0.088366 -0.109439 0.990058    0 0
  v -125.568 85.29 110.637    0.0933035 -0.0642196 0.993564    0 0
  v -117.674 82.6692 108.827    0.257213 -0.202447 0.944911    0 0
  v -116.295 84.8742 108.854    0.273494 -0.143934 0.951044    0 0
  v -125.089 86.4942 110.651    0.092338 -0.0371193 0.995036    0 0
  v -124.843 87.7638 110.656    0.0922636 -0.0095403 0.995689    0 0
  v -115.584 87.1677 108.857    0.291359 -0.029885 0.956147    0 0
  v -115.556 89.5205 108.835    0.294188 0.035278 0.955096    0 0
  v -124.843 89.0591 110.656    0.0926337 0.0101978 0.995648    0 0
  v -125.089 90.3288 110.651    0.0923835 0.0344901 0.995126    0 0
  v -116.34 91.8927 108.877    0.278689 0.122132 0.952584    0 0
  v -117.766 94.1388 108.883    0.250565 0.203712 0.946424    0 0
  v -125.568 91.5329 110.637    0.0920705 0.0644504 0.993665    0 0
  v -126.257 92.6431 110.61    0.0878508 0.109771 0.990067    0 0
  v -119.796 96.115 108.87    0.211982 0.274469 0.937939    0 0
  v -122.258 97.86 108.811    0.179088 0.325657 0.928372    0 0
  v -127.067 93.9904 110.477    0.0707664 0.180568 0.981013    0 0
  v -127.845 96.2658 110.055    0.0442268 0.255945 0.965679    0 0
  v -124.85 99.5954 108.634    0.145564 0.381186 0.912967    0 0
  v -127.845 100.278 108.59    0.0175584 0.431005 0.902179    0 0
  v -126.257 65.9158 99.9755    0.0616742 -0.743822 0.665526    0 0
  v -119.795 67.0072 99.9755    0.185891 -0.714041 0.674975    0 0
  v -122.258 72.0761 105.155    0.170195 -0.588946 0.790048    0 0
  v -127.067 71.2262 105.146    0.0454456 -0.626952 0.777731    0 0
  v -125.065 58.3557 87.8801    0.0740177 -0.935639 0.34511    0 0
  v -116.162 59.7119 87.8763    0.20378 -0.900744 0.383581    0 0
  v -117.763 62.7737 94.1098    0.207215 -0.808382 0.550981    0 0
  v -125.568 61.4587 94.1098    0.069749 -0.83994 0.538179    0 0
  v -124.612 56.5055 73.8088    0.0693596 -0.996937 -0.0361396    0 0
  v -115.221 57.7422 73.5345    0.180471 -0.982243 -0.0512738    0 0
  v -115.572 57.9527 80.9069    0.174412 -0.974908 0.138329    0 0
  v -124.725 56.7636 80.9152    0.0722346 -0.989963 0.121475    0 0
  v -127.371 71.4659 49.4185    0.0549819 -0.55775 -0.828186    0 0
  v -123.083 72.2727 49.4185    0.156373 -0.507316 -0.847454    0 0
  v -119.438 67.365 53.5379    0.174741 -0.620796 -0.76425    0 0
  v -126.002 66.0955 53.5189    0.0780823 -0.639122 -0.765131    0 0
  v -127.845 103.213 46.1521    0.0948019 0.906582 0.411245    0 0
  v -124.488 102.503 46.1521    0.28029 0.857095 0.432233    0 0
  v -123.754 103.562 43.2306    0.284421 0.896191 0.34051    0 0
  v -127.593 104.357 43.2306    0.0962099 0.941139 0.324039    0 0
  v -127.392 105.29 39.7645    0.0986387 0.973796 0.20492    0 0
  v -123.17 104.428 39.7645    0.291943 0.931997 0.214828    0 0
  v -122.817 104.971 35.7223    0.296204 0.950761 0.0911913    0 0
  v -127.27 105.877 35.7223    0.100065 0.991147 0.0872659    0 0
  v -127.249 105.98 31.4043    0.100342 0.994273 -0.0367804    0 0
  v -122.756 105.067 31.4043    0.297023 0.954098 -0.0383883    0 0
  v -122.986 104.704 27.0865    0.294628 0.943992 -0.148574    0 0
  v -127.328 105.589 27.0865    0.0995051 0.984788 -0.142446    0 0
  v -127.485 104.814 23.0204    0.0977252 0.964559 -0.245104    0 0
  v -123.442 103.986 23.0204    0.289556 0.922491 -0.255281    0 0
  v -124.122 102.913 19.4729    0.273965 0.864122 -0.422181    0 0
  v -127.72 103.656 19.4729    0.0925101 0.908685 -0.407103    0 0
  v -128.053 102.01 16.7254    0.0784529 0.765846 -0.63822    0 0
  v -125.089 101.386 16.7254    0.232632 0.71815 -0.655853    0 0
  v -126.279 99.5416 14.8288    0.1915 0.54345 -0.817306    0 0
  v -128.449 100.03 14.8356    0.0588499 0.597126 -0.799986    0 0
  v -128.814 98.135 13.6374    0.0399688 0.455875 -0.889146    0 0
  v -127.497 97.7463 13.6031    0.162807 0.396814 -0.903345    0 0
  v -128.82 96.6841 13.0256    0.0624041 0.313518 -0.947529    0 0
  v -141.345 73.8514 105.191    -0.254102 -0.524022 0.812916    0 0
  v -145.35 76.3014 105.229    -0.330399 -0.446441 0.831581    0 0
  v -150.726 72.3247 99.9945    -0.413599 -0.561015 0.717076    0 0
  v -145.395 69.1816 99.9755    -0.303961 -0.653325 0.693379    0 0
  v -148.643 79.3919 105.244    -0.396069 -0.348241 0.849622    0 0
  v -150.605 82.9775 105.455    -0.40707 -0.223584 0.88561    0 0
  v -158.011 82.2343 102.657    -0.115316 -0.226757 0.967101    0 0
  v -159.943 79.1252 100.039    -0.140402 -0.7845 0.604026    0 0
  v -154.99 76.2227 99.9145    -0.471659 -0.489362 0.733527    0 0
  v -151.847 86.5068 105.403    -0.444289 -0.0411778 0.894937    0 0
  v -152.216 89.663 105.223    -0.480513 0.0829804 0.873053    0 0
  v -159.837 89.1202 99.9976    -0.629252 0.111567 0.769152    0 0
  v -160.993 87.8665 99.459    -0.563645 0.465565 0.682315    0 0
  v -158.359 85.3016 102.577    -0.288996 0.237999 0.927274    0 0
  v -151.159 92.9677 105.255    -0.467127 0.205596 0.859955    0 0
  v -148.863 96.9386 105.201    -0.423884 0.325814 0.845084    0 0
  v -155.664 99.0734 99.9665    -0.548575 0.394646 0.737102    0 0
  v -159.074 92.6635 100.011    -0.608006 0.224679 0.761477    0 0
  v -145.434 100.422 105.202    -0.344848 0.436791 0.830839    0 0
  v -141.345 102.972 105.191    -0.256388 0.52269 0.813056    0 0
  v -145.395 107.641 99.9755    -0.308804 0.650557 0.693841    0 0
  v -150.906 104.192 99.9737    -0.441407 0.5404 0.716329    0 0
  v -136.841 104.747 105.155    -0.170195 0.588946 0.790048    0 0
  v -132.032 105.597 105.146    -0.0454458 0.626953 0.777731    0 0
  v -132.842 110.907 99.9755    -0.0616742 0.743822 0.665526    0 0
  v -139.304 109.816 99.9755    -0.185891 0.71404 0.674975    0 0
  v -148.669 65.3838 94.1098    -0.342844 -0.743138 0.574634    0 0
  v -155.102 69.106 94.079    -0.47352 -0.645638 0.599108    0 0
  v -158.378 66.7975 88.2497    -0.52065 -0.694426 0.496685    0 0
  v -151.135 62.6167 88.2788    -0.358948 -0.809921 0.46388    0 0
  v -160.066 73.7503 94.1157    -0.564709 -0.560586 0.60568    0 0
  v -163.402 77.8146 96.3495    -0.343852 -0.85828 0.380948    0 0
  v -167.089 79.9826 93.5074    -0.854285 -0.515394 0.0675729    0 0
  v -168.353 78.4258 87.5633    -0.812653 -0.400529 0.423286    0 0
  v -164.231 72.107 87.8368    -0.685849 -0.551019 0.475384    0 0
  v -165.822 87.9689 94.8777    -0.667037 0.440375 0.600942    0 0
  v -166.153 89.47 93.9872    -0.739489 0.113824 0.663475    0 0
  v -170.479 91.0369 87.8796    -0.864255 0.123682 0.487614    0 0
  v -170.434 85.1074 87.6521    -0.8883 -0.128554 0.440905    0 0
  v -168.369 84.5378 92.9623    -0.982315 0.0358736 0.183767    0 0
  v -165.18 93.8391 94.0175    -0.702801 0.264701 0.660307    0 0
  v -160.951 101.344 94.1008    -0.619291 0.455093 0.639819    0 0
  v -164.46 103.81 87.876    -0.686082 0.552571 0.47324    0 0
  v -168.749 97.0229 87.8043    -0.791865 0.355926 0.496253    0 0
  v -155.272 107.34 94.108    -0.501163 0.621916 0.601711    0 0
  v -148.669 111.439 94.1098    -0.351507 0.744976 0.566969    0 0
  v -151.059 114.084 87.8797    -0.389974 0.839425 0.378531    0 0
  v -158.391 109.709 87.8792    -0.548838 0.721983 0.421327    0 0
  v -141.336 114.049 94.1098    -0.209274 0.810183 0.547548    0 0
  v -133.531 115.364 94.1098    -0.0699708 0.839915 0.538189    0 0
  v -134.034 118.478 87.8765    -0.0777523 0.934938 0.346188    0 0
  v -142.821 117.002 87.8783    -0.232682 0.904923 0.356333    0 0
  v -167.255 71.4869 80.8885    -0.786602 -0.562257 0.255194    0 0
  v -171.12 77.8345 80.8275    -0.869645 -0.416716 0.264697    0 0
  v -172.207 77.8768 73.3573    -0.898606 -0.437443 -0.033914    0 0
  v -168.313 71.5333 73.3934    -0.809727 -0.584105 -0.056248    0 0
  v -173.388 84.8512 80.8159    -0.947375 -0.148748 0.283468    0 0
  v -173.372 91.9407 80.8644    -0.947129 0.148792 0.284267    0 0
  v -174.5 91.9835 73.3573    -0.987046 0.159034 -0.0211735    0 0
  v -174.5 84.8395 73.3573    -0.987074 -0.158785 -0.0217151    0 0
  v -171.161 98.7769 80.9038    -0.864437 0.422916 0.271829    0 0
  v -166.799 105.251 80.9143    -0.733386 0.635874 0.240437    0 0
  v -167.735 105.383 73.3573    -0.741737 0.668805 -0.0502474    0 0
  v -172.207 98.9461 73.3573    -0.892444 0.450045 -0.0316783    0 0
  v -160.491 110.959 80.915    -0.573819 0.79648 0.190659    0 0
  v -152.675 115.444 80.9134    -0.408841 0.90012 0.15044    0 0
  v -153.299 115.423 73.3538    -0.403654 0.910378 -0.0909657    0 0
  v -161.309 110.966 73.3573    -0.569491 0.8188 -0.0724362    0 0
  v -143.824 118.534 80.9064    -0.244663 0.961241 0.127105    0 0
  v -134.374 120.111 80.8976    -0.0821009 0.989719 0.117117    0 0
  v -134.505 120.134 73.3222    -0.081864 0.990823 -0.107557    0 0
  v -144.211 118.532 73.3397    -0.242207 0.964777 -0.102671    0 0
  v -152.779 62.7078 65.3318    -0.379268 -0.810111 -0.447075    0 0
  v -160.311 66.9298 65.4912    -0.517793 -0.717777 -0.465495    0 0
  v -156.593 69.3921 59.0738    -0.443556 -0.636798 -0.630672    0 0
  v -150.04 65.71 58.9866    -0.341548 -0.715853 -0.609015    0 0
  v -166.443 72.227 65.8921    -0.694338 -0.581993 -0.423295    0 0
  v -170.599 78.4461 65.8621    -0.815441 -0.411637 -0.406954    0 0
  v -165.911 79.5281 59.0738    -0.638106 -0.326047 -0.697505    0 0
  v -162.087 74.1005 59.0738    -0.552589 -0.502697 -0.664787    0 0
  v -172.807 85.0325 65.8621    -0.89625 -0.146725 -0.418578    0 0
  v -172.807 91.7904 65.8621    -0.89625 0.146725 -0.418578    0 0
  v -167.872 91.4236 59.0738    -0.685881 0.111976 -0.719047    0 0
  v -167.872 85.3994 59.0738    -0.685881 -0.111976 -0.719047    0 0
  v -170.599 98.3768 65.8621    -0.813599 0.417422 -0.404741    0 0
  v -166.292 104.466 65.8621    -0.680067 0.624327 -0.38435    0 0
  v -162.087 102.722 59.0738    -0.553621 0.506541 -0.660999    0 0
  v -165.911 97.2949 59.0738    -0.638148 0.326425 -0.697291    0 0
  v -160.105 109.747 65.8621    -0.525446 0.768928 -0.364219    0 0
  v -152.393 113.964 65.8586    -0.374724 0.858778 -0.349402    0 0
  v -149.75 111.184 59.072    -0.325694 0.744607 -0.582653    0 0
  v -156.593 107.431 59.0738    -0.444106 0.64753 -0.619254    0 0
  v -143.648 116.905 65.8446    -0.226071 0.912614 -0.340628    0 0
  v -134.315 118.422 65.827    -0.0766708 0.938292 -0.337239    0 0
  v -133.759 115.114 59.0562    -0.067445 0.836105 -0.544407    0 0
  v -142.008 113.787 59.065    -0.198961 0.806534 -0.556702    0 0
  v -145.561 69.4555 53.6077    -0.265006 -0.560814 -0.784384    0 0
  v -150.947 72.5636 53.6251    -0.338182 -0.469875 -0.815384    0 0
  v -143.765 76.2854 49.4185    -0.279754 -0.326166 -0.902969    0 0
  v -140.099 73.9003 49.4185    -0.232424 -0.422488 -0.876061    0 0
  v -155.326 76.4869 53.6251    -0.396976 -0.347796 -0.849381    0 0
  v -158.375 81.0094 53.6251    -0.435271 -0.213265 -0.874675    0 0
  v -148.788 82.7477 49.4185    -0.322924 -0.132409 -0.937117    0 0
  v -146.727 79.2873 49.4185    -0.308533 -0.226181 -0.923932    0 0
  v -159.938 85.9016 53.6251    -0.454244 -0.0710469 -0.88804    0 0
  v -159.938 90.9213 53.6251    -0.454244 0.0710468 -0.88804    0 0
  v -149.845 90.3319 49.4185    -0.328847 0.0430452 -0.943402    0 0
  v -149.845 86.4911 49.4185    -0.328847 -0.0430444 -0.943402    0 0
  v -158.375 95.8135 53.6251    -0.435271 0.213265 -0.874675    0 0
  v -155.326 100.336 53.6251    -0.396976 0.347797 -0.849381    0 0
  v -146.727 97.5356 49.4185    -0.308533 0.226181 -0.923931    0 0
  v -148.788 94.0752 49.4185    -0.322924 0.132408 -0.937117    0 0
  v -150.947 104.259 53.6251    -0.337623 0.471132 -0.814889    0 0
  v -145.503 107.382 53.6248    -0.260867 0.571157 -0.778285    0 0
  v -140.099 102.923 49.4185    -0.232425 0.422487 -0.876061    0 0
  v -143.765 100.538 49.4185    -0.279754 0.326166 -0.902969    0 0
  v -139.371 109.529 53.6234    -0.164725 0.644504 -0.746646    0 0
  v -132.865 110.609 53.6216    -0.056356 0.682463 -0.728744    0 0
  v -131.728 105.357 49.4185    -0.0549814 0.557751 -0.828185    0 0
  v -136.016 104.55 49.4185    -0.156373 0.507316 -0.847454    0 0
  v -185.558 76.7843 125.927    -0.129904 -0.150339 0.980063    0 0
  v -186.856 77.5832 125.601    -0.397595 0.105586 0.911466    0 0
  v -187.678 76.5097 125.038    -0.582285 -0.25755 0.771111    0 0
  v -186.309 75.7175 125.385    -0.285584 -0.482816 0.827847    0 0
  v -165.756 81.2333 104.489    0.536026 -0.185424 0.823586    0 0
  v -172.588 79.5341 110.699    0.762186 -0.255433 0.594833    0 0
  v -173.115 78.7221 110.381    0.477928 -0.854901 0.201815    0 0
  v -166.545 79.9139 103.681    0.314507 -0.89068 0.328292    0 0
  v -168.147 79.4799 102.146    -0.0900485 -0.995016 -0.0428387    0 0
  v -174.019 78.5857 109.788    -0.0825374 -0.959322 -0.269979    0 0
  v -174.858 79.1912 109.203    -0.554939 -0.626273 -0.547562    0 0
  v -169.543 80.4405 100.974    -0.697892 -0.595636 -0.397698    0 0
  v -169.483 82.6528 99.6981    -0.924713 0.225645 -0.306578    0 0
  v -174.691 80.2623 108.636    -0.810041 0.309669 -0.497935    0 0
  v -173.468 81.3478 108.268    -0.49845 0.859696 -0.111671    0 0
  v -167.121 85.0317 98.645    -0.503536 0.844165 0.183948    0 0
  v -164.769 85.1253 100.838    -0.191212 0.878424 0.437961    0 0
  v -172.525 81.4916 108.919    0.0774464 0.930417 0.358226    0 0
  v -172.382 80.6125 110.191    0.54928 0.541429 0.636511    0 0
  v -165.123 83.1293 103.701    0.274087 0.521614 0.807957    0 0
  v -176.446 78.1369 115.928    0.871003 -0.268945 0.411123    0 0
  v -177.222 77.493 118.232    0.988292 -0.148349 -0.0356611    0 0
  v -178.112 76.1214 117.553    0.642027 -0.684035 -0.346261    0 0
  v -177.031 77.2313 115.493    0.547967 -0.835968 0.0298112    0 0
  v -178.199 77.0735 114.96    -0.0484343 -0.900063 -0.43306    0 0
  v -179.942 75.8861 116.787    0.072312 -0.706957 -0.703551    0 0
  v -181.797 76.9049 116.316    -0.251828 -0.359539 -0.898507    0 0
  v -179.367 77.742 114.593    -0.468394 -0.556836 -0.68596    0 0
  v -179.585 78.8258 114.581    -0.686204 0.348954 -0.638243    0 0
  v -182.271 78.5146 116.501    -0.368866 0.374071 -0.850887    0 0
  v -181.126 79.9105 117.25    -0.16997 0.801345 -0.573546    0 0
  v -178.718 79.7998 114.91    -0.411572 0.873511 -0.259975    0 0
  v -177.543 79.9591 115.455    0.193903 0.951587 0.238503    0 0
  v -179.297 80.1458 118.017    0.319741 0.929053 -0.186083    0 0
  v -177.696 79.1028 118.417    0.782337 0.622103 0.0306058    0 0
  v -176.657 79.2222 115.928    0.67658 0.550922 0.488593    0 0
  v -177.081 77.1263 119.514    0.988488 -0.140214 -0.0568539    0 0
  v -177.246 76.7877 120.831    0.948896 -0.217876 0.22831    0 0
  v -178.749 74.481 119.7    0.589926 -0.79747 -0.126608    0 0
  v -178.316 75.2282 118.581    0.641312 -0.678174 -0.358887    0 0
  v -180.855 74.9072 117.518    0.0771443 -0.695951 -0.713933    0 0
  v -181.839 74.0935 118.408    -0.00295963 -0.824709 -0.56555    0 0
  v -184.97 75.8189 117.601    -0.360493 -0.450543 -0.816735    0 0
  v -183.429 76.3239 116.858    -0.233723 -0.344342 -0.909287    0 0
  v -184.092 78.5555 117.113    -0.331154 0.372987 -0.866728    0 0
  v -185.779 78.5332 117.91    -0.482752 0.385532 -0.786331    0 0
  v -183.862 80.8792 119.178    -0.240041 0.84566 -0.476697    0 0
  v -182.512 80.4864 118.155    -0.134238 0.781213 -0.609661    0 0
  v -179.973 80.8074 119.217    0.330945 0.912385 -0.240891    0 0
  v -180.773 81.2667 120.47    0.275565 0.960574 -0.0368918    0 0
  v -178.056 79.502 121.14    0.74394 0.62067 0.247633    0 0
  v -177.744 79.358 119.769    0.780614 0.624885 -0.0126674    0 0
  v -178.002 76.4549 122.392    0.825102 -0.276227 0.492854    0 0
  v -179.456 76.1832 124.043    0.633867 -0.309991 0.708603    0 0
  v -181.107 73.65 122.801    0.353156 -0.859098 0.370447    0 0
  v -179.666 73.9026 121.141    0.49285 -0.861478 0.122289    0 0
  v -183.086 73.475 119.711    -0.0922458 -0.923833 -0.371515    0 0
  v -184.502 73.2256 121.382    -0.19048 -0.97458 -0.117945    0 0
  v -187.943 75.1222 120.495    -0.637724 -0.650109 -0.413118    0 0
  v -186.553 75.3862 118.817    -0.497578 -0.556294 -0.665547    0 0
  v -187.451 78.3907 119.158    -0.656091 0.384559 -0.649353    0 0
  v -188.834 78.104 120.833    -0.84726 0.351169 -0.398536    0 0
  v -186.729 80.6801 122.227    -0.486537 0.872807 -0.0385988    0 0
  v -185.331 80.9863 120.563    -0.357533 0.885512 -0.296712    0 0
  v -181.91 81.4138 121.993    0.198527 0.961364 0.190701    0 0
  v -183.335 81.1045 123.646    0.0940341 0.892375 0.441388    0 0
  v -180.347 79.1649 124.381    0.503137 0.474644 0.722196    0 0
  v -178.9 79.4594 122.733    0.65139 0.571318 0.499286    0 0
  v -181.541 76.105 125.266    0.338717 -0.317304 0.88577    0 0
  v -183.777 76.2555 125.829    0.0877672 -0.28935 0.953191    0 0
  v -184.683 74.8782 125.148    -0.0575521 -0.604693 0.794376    0 0
  v -182.902 74.015 124.24    0.135732 -0.754293 0.642354    0 0
  v -185.7 73.6628 123.07    -0.306934 -0.911927 0.27236    0 0
  v -186.402 74.658 124.428    -0.35726 -0.726535 0.586952    0 0
  v -188.254 75.6837 123.954    -0.670041 -0.543481 0.505641    0 0
  v -188.535 75.2244 122.341    -0.733723 -0.674855 0.0788779    0 0
  v -189.267 77.6827 122.621    -0.967813 0.209585 0.139327    0 0
  v -188.7 77.1959 124.128    -0.815066 0.010595 0.579271    0 0
  v -187.565 78.5951 124.879    -0.581433 0.376233 0.721377    0 0
  v -187.529 79.8084 123.769    -0.607834 0.687674 0.397043    0 0
  v -184.731 80.1606 124.939    -0.0700879 0.665282 0.743295    0 0
  v -185.846 78.8152 125.599    -0.213325 0.375442 0.901962    0 0
  v -184.223 77.7677 126.003    0.0315725 0.1088 0.993562    0 0
  v -182.273 78.5632 125.546    0.254229 0.294148 0.921328    0 0
  v -137.816 101.068 46.1521    -0.444702 0.763268 0.468681    0 0
  v -138.959 101.981 43.2306    -0.457304 0.80877 0.369817    0 0
  v -142.162 99.7385 43.2312    -0.593976 0.695133 0.404947    0 0
  v -140.7 98.987 46.1524    -0.573415 0.636809 0.515431    0 0
  v -143.03 96.4278 46.1533    -0.670912 0.473422 0.570744    0 0
  v -144.729 97.0765 43.2335    -0.707591 0.547846 0.446295    0 0
  v -146.492 94.1376 43.2584    -0.799763 0.350921 0.487066    0 0
  v -144.638 93.5028 46.173    -0.73756 0.290362 0.609668    0 0
  v -145.417 90.2678 46.2472    -0.781056 0.0973085 0.616832    0 0
  v -147.34 90.9645 43.3463    -0.845418 0.158294 0.510108    0 0
  v -147.966 88.5262 43.2929    -0.746194 0.365156 0.556647    0 0
  v -146.585 86.4175 45.2236    -0.509043 0.0944645 0.855542    0 0
  v -145.202 86.8337 46.528    -0.791304 -0.0975023 0.603598    0 0
  v -144.343 83.4199 46.5272    -0.75258 -0.291294 0.590568    0 0
  v -145.79 83.3122 45.232    -0.416684 -0.335024 0.845064    0 0
  v -146.065 81.1256 43.3137    -0.490767 -0.7156 0.497056    0 0
  v -144.418 79.4562 43.3408    -0.677606 -0.576189 0.457008    0 0
  v -142.93 80.382 46.2451    -0.675195 -0.473597 0.565524    0 0
  v -140.68 77.8333 46.1707    -0.57362 -0.636849 0.515154    0 0
  v -142.1 77.0264 43.2526    -0.587482 -0.697587 0.410168    0 0
  v -138.959 74.8418 43.2306    -0.456055 -0.809336 0.37012    0 0
  v -137.816 75.7548 46.1521    -0.444654 -0.763275 0.468716    0 0
  v -134.611 74.3203 46.1521    -0.280289 -0.857095 0.432234    0 0
  v -135.345 73.2608 43.2306    -0.284421 -0.896191 0.34051    0 0
  v -131.506 72.4663 43.2306    -0.0962098 -0.941138 0.324041    0 0
  v -131.254 73.6099 46.1521    -0.0948031 -0.906581 0.411245    0 0
  v -139.868 102.727 39.7645    -0.474758 0.848829 0.232582    0 0
  v -140.418 103.195 35.7223    -0.4851 0.868936 0.0981223    0 0
  v -144.017 100.683 35.7226    -0.649455 0.753564 0.101731    0 0
  v -143.321 100.331 39.7651    -0.62652 0.738351 0.249622    0 0
  v -146.064 97.5023 39.7674    -0.762137 0.592214 0.261591    0 0
  v -146.855 97.6639 35.7238    -0.798094 0.594579 0.0975815    0 0
  v -148.794 94.2674 35.718    -0.920186 0.379349 0.096704    0 0
  v -147.952 94.3871 39.768    -0.88192 0.386744 0.269529    0 0
  v -148.912 91.0201 39.7585    -0.945493 0.172759 0.276038    0 0
  v -149.788 90.5207 35.689    -0.985438 0.135833 0.102278    0 0
  v -149.87 86.5439 35.3157    -0.992094 -0.104552 0.0694128    0 0
  v -149.773 86.1362 37.9489    -0.984993 -0.0005307 -0.172591    0 0
  v -149.333 88.4547 40.1786    -0.925629 0.340742 0.164639    0 0
  v -148.925 82.8603 37.9573    -0.860404 -0.475605 -0.183042    0 0
  v -148.865 82.6457 35.3148    -0.919256 -0.388751 0.061974    0 0
  v -146.84 79.1594 35.6864    -0.79701 -0.596517 0.0945648    0 0
  v -145.841 79.0437 39.7529    -0.741032 -0.625822 0.243346    0 0
  v -147.38 80.8836 40.1994    -0.643919 -0.75665 0.113351    0 0
  v -143.276 76.4361 39.7622    -0.623024 -0.743508 0.242978    0 0
  v -144.014 76.1402 35.7151    -0.650205 -0.752959 0.101421    0 0
  v -140.418 73.6276 35.7223    -0.485141 -0.868921 0.0980574    0 0
  v -139.868 74.0961 39.7645    -0.473771 -0.84956 0.231924    0 0
  v -135.929 72.3954 39.7645    -0.291943 -0.931997 0.214828    0 0
  v -136.282 71.8519 35.7223    -0.296205 -0.950761 0.0911914    0 0
  v -131.829 70.9462 35.7223    -0.100065 -0.991147 0.0872661    0 0
  v -131.707 71.5326 39.7645    -0.0986389 -0.973796 0.204919    0 0
  v -140.512 103.278 31.4043    -0.487562 0.872102 -0.0414948    0 0
  v -140.155 102.965 27.0865    -0.482613 0.861115 -0.159893    0 0
  v -143.681 100.479 27.0865    -0.650088 0.739753 -0.173641    0 0
  v -144.135 100.732 31.4044    -0.657396 0.752073 -0.0470799    0 0
  v -146.983 97.6264 31.4046    -0.809463 0.584469 -0.0562605    0 0
  v -146.458 97.4265 27.0865    -0.798936 0.5711 -0.188537    0 0
  v -148.349 93.9788 27.0865    -0.910174 0.362388 -0.200646    0 0
  v -148.918 94.1279 31.4035    -0.926177 0.371829 -0.0627698    0 0
  v -149.899 90.3694 31.3977    -0.989734 0.128458 -0.0626514    0 0
  v -149.305 90.2936 27.0865    -0.970418 0.123952 -0.207182    0 0
  v -149.305 86.5293 27.0865    -0.970275 -0.123164 -0.208318    0 0
  v -149.915 86.5018 31.323    -0.990535 -0.118582 -0.069126    0 0
  v -148.932 82.7131 31.3228    -0.924151 -0.375925 -0.0680064    0 0
  v -148.349 82.8441 27.0865    -0.909823 -0.36269 -0.201688    0 0
  v -146.458 79.3964 27.0865    -0.79891 -0.571141 -0.188522    0 0
  v -146.98 79.1967 31.3972    -0.809466 -0.584542 -0.05545    0 0
  v -144.135 76.0912 31.4029    -0.657577 -0.751929 -0.046856    0 0
  v -143.681 76.3442 27.0865    -0.650095 -0.73975 -0.173628    0 0
  v -140.155 73.8575 27.0865    -0.482613 -0.861115 -0.159893    0 0
  v -140.512 73.5448 31.4043    -0.48758 -0.872092 -0.041485    0 0
  v -136.343 71.7558 31.4043    -0.297024 -0.954098 -0.0383877    0 0
  v -136.113 72.1186 27.0865    -0.294628 -0.943992 -0.148574    0 0
  v -131.771 71.2339 27.0865    -0.0995039 -0.984788 -0.142445    0 0
  v -131.85 70.8425 31.4043    -0.10034 -0.994273 -0.0367805    0 0
  v -139.447 102.346 23.0204    -0.471732 0.838161 -0.273779    0 0
  v -138.391 101.421 19.4729    -0.440732 0.777456 -0.448685    0 0
  v -141.439 99.2505 19.4729    -0.581928 0.657379 -0.478761    0 0
  v -142.781 99.986 23.0204    -0.631643 0.716702 -0.295575    0 0
  v -145.425 97.0726 23.0204    -0.771989 0.550185 -0.318321    0 0
  v -143.883 96.5444 19.4729    -0.701914 0.498133 -0.509098    0 0
  v -145.568 93.4488 19.4725    -0.786789 0.311263 -0.532991    0 0
  v -147.233 93.7666 23.0204    -0.875083 0.347648 -0.336705    0 0
  v -148.151 90.2231 23.0204    -0.930351 0.118468 -0.347005    0 0
  v -146.425 90.1128 19.4711    -0.831135 0.106735 -0.545731    0 0
  v -146.473 86.6948 19.4971    -0.839822 -0.095153 -0.534458    0 0
  v -148.151 86.5998 23.0204    -0.931113 -0.117697 -0.34522    0 0
  v -147.233 83.0564 23.0204    -0.875415 -0.348595 -0.334859    0 0
  v -145.614 83.3696 19.4971    -0.789923 -0.324658 -0.520209    0 0
  v -143.881 80.2818 19.4711    -0.701116 -0.49935 -0.509006    0 0
  v -145.425 79.7503 23.0204    -0.771929 -0.550266 -0.318328    0 0
  v -142.781 76.8369 23.0204    -0.63165 -0.716679 -0.295617    0 0
  v -141.439 77.5731 19.4725    -0.582043 -0.657033 -0.479097    0 0
  v -138.391 75.402 19.4729    -0.440759 -0.777427 -0.448707    0 0
  v -139.447 74.4771 23.0204    -0.471734 -0.838159 -0.273782    0 0
  v -135.658 72.8374 23.0204    -0.289556 -0.92249 -0.255281    0 0
  v -134.978 73.9103 19.4729    -0.273964 -0.864122 -0.42218    0 0
  v -131.379 73.1666 19.4729    -0.0925102 -0.908685 -0.407103    0 0
  v -131.614 72.0093 23.0204    -0.0977246 -0.964559 -0.245105    0 0
  v -136.888 100.105 16.7254    -0.362919 0.630937 -0.685717    0 0
  v -134.974 98.4644 14.8013    -0.276237 0.456611 -0.845695    0 0
  v -137.1 96.8854 14.796    -0.334409 0.374597 -0.864782    0 0
  v -139.529 98.2042 16.7254    -0.465001 0.521701 -0.715264    0 0
  v -141.688 95.793 16.7254    -0.547729 0.386204 -0.742186    0 0
  v -138.942 94.8531 14.8055    -0.389228 0.274682 -0.879233    0 0
  v -140.242 92.4754 14.8058    -0.424974 0.171672 -0.888778    0 0
  v -143.197 92.9941 16.7236    -0.602723 0.236985 -0.761947    0 0
  v -143.961 89.9428 16.7163    -0.633373 0.087925 -0.768835    0 0
  v -140.899 89.9724 14.7973    -0.444638 0.0982476 -0.890306    0 0
  v -140.796 88.1842 14.3688    -0.490805 0.416765 -0.765126    0 0
  v -142.367 86.6039 15.19    -0.765416 0.047704 -0.641765    0 0
  v -144.199 86.8037 16.8465    -0.670822 -0.0530648 -0.739718    0 0
  v -143.428 83.8059 16.8465    -0.629592 -0.281569 -0.724108    0 0
  v -141.792 84.3734 15.1942    -0.677578 -0.415688 -0.606705    0 0
  v -139.535 83.2874 14.3792    -0.329702 -0.633861 -0.699655    0 0
  v -138.816 81.7812 14.7949    -0.380047 -0.32052 -0.867659    0 0
  v -141.679 81.0462 16.7163    -0.547698 -0.396279 -0.736879    0 0
  v -139.527 78.622 16.7236    -0.465423 -0.521698 -0.714991    0 0
  v -137.075 79.8998 14.7939    -0.333223 -0.382096 -0.861955    0 0
  v -134.974 78.3586 14.8013    -0.275688 -0.457582 -0.845349    0 0
  v -136.888 76.7176 16.7254    -0.362954 -0.630949 -0.685688    0 0
  v -134.01 75.4365 16.7254    -0.23263 -0.71815 -0.655854    0 0
  v -132.821 77.2814 14.8288    -0.191498 -0.543452 -0.817305    0 0
  v -130.65 76.7928 14.8356    -0.0588487 -0.597126 -0.799986    0 0
  v -131.046 74.813 16.7254    -0.0784535 -0.765845 -0.638221    0 0
  v -132.814 96.7146 13.4657    -0.211583 0.318213 -0.924107    0 0
  v -130.622 95.5896 12.7592    -0.0896244 0.224226 -0.970407    0 0
  v -130.443 94.1639 12.4866    -0.0853835 0.136417 -0.986965    0 0
  v -132.188 93.7803 12.6423    -0.13531 0.14033 -0.980815    0 0
  v -134.373 95.4386 13.4393    -0.237217 0.26722 -0.933982    0 0
  v -135.988 93.8429 13.4869    -0.276271 0.193096 -0.941482    0 0
  v -133.357 92.6654 12.6899    -0.171208 0.100351 -0.980111    0 0
  v -134.226 91.0768 12.7019    -0.179329 0.0758213 -0.980863    0 0
  v -137.091 91.8865 13.4969    -0.296674 0.121667 -0.947197    0 0
  v -137.63 89.8241 13.4895    -0.29996 0.0782794 -0.950734    0 0
  v -134.621 89.4085 12.696    -0.186482 0.0275736 -0.982071    0 0
  v -134.277 87.5225 12.6125    -0.156354 0.00691364 -0.987677    0 0
  v -136.172 87.1554 12.8067    0.0329549 0.157518 -0.986966    0 0
  v -138.103 88.3102 13.3335    -0.189188 0.437254 -0.879214    0 0
  v -135.706 85.3249 12.8109    0.0794085 -0.14289 -0.986548    0 0
  v -133.837 85.757 12.6125    -0.134607 -0.0829189 -0.987424    0 0
  v -133.299 84.1109 12.6823    -0.161165 -0.107266 -0.981081    0 0
  v -135.823 82.7421 13.4777    -0.25302 -0.230688 -0.939555    0 0
  v -136.951 83.8134 13.344    -0.0459029 -0.536287 -0.842786    0 0
  v -134.341 81.3367 13.4374    -0.232409 -0.271298 -0.934015    0 0
  v -132.175 83.0322 12.6406    -0.133531 -0.141017 -0.980961    0 0
  v -130.443 82.6591 12.4866    -0.0852043 -0.136489 -0.986971    0 0
  v -130.622 81.2333 12.7592    -0.0895373 -0.224307 -0.970397    0 0
  v -132.814 80.1083 13.4657    -0.210822 -0.318951 -0.924026    0 0
  v -131.602 79.0767 13.6031    -0.16281 -0.396814 -0.903345    0 0
  v -130.279 80.1388 13.0255    -0.062405 -0.31351 -0.947532    0 0
  v -130.285 78.6879 13.6374    -0.0399674 -0.455882 -0.889142    0 0
  v -161.582 82.6263 35.6846    -0.850069 -0.135454 -0.508955    0 0
  v -160.755 83.357 35.0307    -0.445423 0.288812 -0.847459    0 0
  v -159.956 82.5883 34.8261    -0.0987638 -0.28887 -0.95226    0 0
  v -160.796 81.8607 35.4957    -0.357093 -0.686122 -0.633814    0 0
  v -147.69 83.4909 44.8823    -0.0882277 -0.381193 0.920276    0 0
  v -150.15 83.5105 44.7966    -0.0418715 -0.400816 0.915201    0 0
  v -150.118 82.0495 43.3367    -0.0496017 -0.900801 0.43139    0 0
  v -147.858 81.7797 43.2713    -0.176206 -0.86553 0.468838    0 0
  v -148.74 81.6459 40.9026    -0.33273 -0.92958 -0.158659    0 0
  v -150.607 81.9526 41.1979    -0.077238 -0.952224 -0.295471    0 0
  v -151.372 83.2682 39.4495    -0.0526503 -0.542715 -0.838265    0 0
  v -149.864 83.1871 39.0627    -0.465932 -0.563034 -0.682569    0 0
  v -150.468 85.4649 39.0162    -0.581314 0.292279 -0.759373    0 0
  v -151.868 85.1351 39.3415    -0.0977723 0.418167 -0.903093    0 0
  v -151.848 86.6199 40.9278    -0.189926 0.903401 -0.38444    0 0
  v -150.217 87.2167 40.7864    -0.574488 0.791781 -0.207476    0 0
  v -149.325 87.3164 43.1551    -0.399914 0.772287 0.4936    0 0
  v -151.359 86.7168 43.0666    -0.202032 0.89662 0.394025    0 0
  v -150.646 85.3774 44.6885    -0.119701 0.452768 0.883557    0 0
  v -148.283 85.7346 44.8358    -0.181112 0.346959 0.920227    0 0
  v -152.759 83.3962 44.4992    -0.161166 -0.406459 0.899342    0 0
  v -155.245 83.1797 43.7187    -0.334754 -0.404748 0.850952    0 0
  v -154.755 81.9036 42.5069    -0.0840078 -0.911227 0.403248    0 0
  v -152.495 82.0549 43.1492    -0.0395425 -0.909682 0.413418    0 0
  v -152.592 81.9693 41.0837    0.0925115 -0.945136 -0.313303    0 0
  v -154.46 81.8275 40.5567    0.21755 -0.934406 -0.282058    0 0
  v -154.508 82.9896 38.8433    0.434167 -0.494911 -0.752703    0 0
  v -153.002 83.1823 39.3355    0.209081 -0.517371 -0.829827    0 0
  v -153.417 84.9199 39.1688    0.147088 0.439358 -0.886188    0 0
  v -154.827 84.674 38.6246    0.354339 0.43692 -0.826768    0 0
  v -155.259 86.0385 40.0099    0.045938 0.909651 -0.412826    0 0
  v -153.629 86.3133 40.6669    -0.0342026 0.912153 -0.408419    0 0
  v -153.532 86.3988 42.7323    -0.211443 0.911499 0.35279    0 0
  v -155.554 86.1145 41.96    -0.315242 0.898123 0.306589    0 0
  v -155.564 84.8641 43.5    -0.438494 0.444399 0.781174    0 0
  v -153.174 85.1338 44.3324    -0.247874 0.459984 0.852627    0 0
  v -157.468 82.8997 42.3884    -0.526037 -0.399918 0.750567    0 0
  v -159.346 82.6026 40.6091    -0.659254 -0.390891 0.64233    0 0
  v -158.52 81.4903 39.8319    -0.239187 -0.912441 0.332024    0 0
  v -156.783 81.692 41.3672    -0.168764 -0.912006 0.37385    0 0
  v -156.132 81.6249 39.6119    0.290239 -0.92977 -0.22647    0 0
  v -157.579 81.4329 38.3637    0.299256 -0.936929 -0.180584    0 0
  v -156.994 82.4593 36.9385    0.660452 -0.526355 -0.535494    0 0
  v -155.839 82.7318 38.0003    0.605299 -0.489504 -0.627693    0 0
  v -156.076 84.3337 37.7176    0.520829 0.425153 -0.740258    0 0
  v -157.16 83.9191 36.5905    0.599292 0.409745 -0.68772    0 0
  v -157.995 85.0824 37.4938    0.102855 0.898526 -0.426698    0 0
  v -156.723 85.6294 38.9052    0.0737386 0.904371 -0.420327    0 0
  v -157.375 85.6966 40.6605    -0.442172 0.87349 0.203715    0 0
  v -158.936 85.1398 38.962    -0.473384 0.8755 0.09699    0 0
  v -159.512 84.0624 40.2611    -0.731758 0.463371 0.499817    0 0
  v -157.705 84.5015 42.1057    -0.629953 0.438464 0.641022    0 0
  v -160.851 82.3427 38.6498    -0.761062 -0.378922 0.5265    0 0
  v -161.669 82.2337 36.9168    -0.913538 -0.369094 0.170934    0 0
  v -160.889 81.4307 36.6436    -0.428469 -0.902392 -0.04585    0 0
  v -159.963 81.3419 38.1475    -0.307329 -0.91346 0.266721    0 0
  v -158.831 81.2969 37.0455    0.252472 -0.949281 -0.187413    0 0
  v -159.818 81.4015 35.9654    0.0416145 -0.920045 -0.389597    0 0
  v -159.012 82.1586 35.1605    0.312416 -0.593291 -0.741891    0 0
  v -158.019 82.2304 35.8949    0.605914 -0.588777 -0.534985    0 0
  v -158.1 83.534 35.5201    0.592302 0.361072 -0.720281    0 0
  v -159.011 83.196 34.8415    0.305134 0.139474 -0.942041    0 0
  v -159.832 84.0089 35.1656    -0.0620138 0.709845 -0.701623    0 0
  v -159.033 84.5561 36.1085    0.123728 0.880243 -0.458108    0 0
  v -160.166 84.601 37.2104    -0.463622 0.886026 0.00358905    0 0
  v -160.903 84.0381 35.8437    -0.544551 0.782696 -0.301416    0 0
  v -161.668 83.2711 36.5977    -0.917378 0.395432 0.045293    0 0
  v -160.932 83.6464 38.275    -0.787737 0.493784 0.368304    0 0
  v -141.876 84.6129 0.734975    -0.460738 -0.164532 -0.872153    0 0
  v -141.462 85.0292 0.622619    -0.178114 0.287743 -0.940999    0 0
  v -140.889 84.7276 0.584057    0.185805 -0.00937106 -0.982542    0 0
  v -141.281 84.3126 0.66342    -0.0829813 -0.451103 -0.888606    0 0
  v -141.459 84.7566 13.7929    -0.738818 -0.671969 -0.0510423    0 0
  v -141.759 84.7589 11.9705    -0.684033 -0.708183 0.174856    0 0
  v -140.191 83.9997 11.6377    -0.173169 -0.982127 0.0737458    0 0
  v -139.733 83.9132 13.2717    -0.211104 -0.962871 -0.168268    0 0
  v -137.882 84.176 12.665    0.330257 -0.856639 -0.396358    0 0
  v -138.544 84.1907 11.2639    0.451028 -0.885941 -0.108087    0 0
  v -137.643 85.2364 11.036    0.906816 -0.288559 -0.307276    0 0
  v -136.905 85.341 12.3172    0.674247 -0.258012 -0.691969    0 0
  v -137.26 86.7113 12.2962    0.524727 0.508333 -0.682831    0 0
  v -137.958 86.4532 10.9902    0.706541 0.625792 -0.330431    0 0
  v -139.331 87.2326 11.1495    0.183502 0.962303 -0.200751    0 0
  v -138.766 87.5858 12.6127    0.0766099 0.884513 -0.460183    0 0
  v -140.639 87.403 13.2194    -0.48274 0.83431 -0.266248    0 0
  v -140.977 87.0416 11.5233    -0.443807 0.895724 -0.026729    0 0
  v -142.074 85.9757 11.9248    -0.916762 0.375845 0.135234    0 0
  v -141.836 86.2069 13.772    -0.953083 0.286344 -0.0981844    0 0
  v -142.138 84.6109 9.79907    -0.690336 -0.710411 0.13694    0 0
  v -142.354 84.4447 7.45362    -0.695791 -0.711561 0.0977559    0 0
  v -140.889 83.746 7.24348    -0.177407 -0.981445 0.0727553    0 0
  v -140.613 83.8817 9.56051    -0.174769 -0.980984 0.0844229    0 0
  v -139.009 84.0652 9.29102    0.46483 -0.884974 -0.0274742    0 0
  v -139.346 83.9218 7.00784    0.466095 -0.884702 -0.00766688    0 0
  v -138.496 84.8843 6.86456    0.950564 -0.287329 -0.117774    0 0
  v -138.127 85.0695 9.12536    0.943994 -0.287893 -0.161222    0 0
  v -138.427 86.2377 9.06412    0.738361 0.641556 -0.207914    0 0
  v -138.783 86.0034 6.8015    0.744271 0.645211 -0.172523    0 0
  v -140.063 86.7195 6.8502    0.203426 0.969354 -0.137733    0 0
  v -139.759 86.9856 9.13791    0.200761 0.968555 -0.146953    0 0
  v -141.364 86.8022 9.4074    -0.440634 0.896809 -0.0397021    0 0
  v -141.606 86.5437 7.08583    -0.44239 0.894524 -0.0641784    0 0
  v -142.641 85.5638 7.39056    -0.927857 0.372167 0.0239433    0 0
  v -142.438 85.7791 9.73783    -0.9229 0.377446 0.0760987    0 0
  v -142.477 84.2932 5.21213    -0.698676 -0.711636 0.0736613    0 0
  v -142.521 84.1956 3.30896    -0.704042 -0.709998 0.0150849    0 0
  v -141.257 83.5908 3.11866    -0.189044 -0.981968 0.00118716    0 0
  v -141.09 83.6308 5.00969    -0.18018 -0.98203 0.0561459    0 0
  v -139.628 83.7976 4.78638    0.464271 -0.885428 -0.0216632    0 0
  v -139.923 83.7433 2.91489    0.453808 -0.885911 -0.0960245    0 0
  v -139.185 84.5768 2.7995    0.929092 -0.29181 -0.227232    0 0
  v -138.822 84.7102 4.6539    0.948379 -0.288468 -0.131772    0 0
  v -139.094 85.7707 4.59411    0.742608 0.643511 -0.185546    0 0
  v -139.433 85.5446 2.74488    0.728808 0.629722 -0.268866    0 0
  v -140.542 86.1628 2.77835    0.194088 0.957079 -0.215242    0 0
  v -140.307 86.4488 4.63691    0.201805 0.967593 -0.151783    0 0
  v -141.769 86.282 4.8602    -0.445408 0.891402 -0.0837527    0 0
  v -141.876 86.0103 2.98212    -0.453247 0.880643 -0.137968    0 0
  v -142.768 85.1633 3.25434    -0.932176 0.35586 -0.0664165    0 0
  v -142.749 85.3536 5.15235    -0.929973 0.367604 -0.00410955    0 0
  v -142.438 84.1976 1.93477    -0.706452 -0.691164 -0.152377    0 0
  v -142.197 84.3137 1.13358    -0.63949 -0.549962 -0.537209    0 0
  v -141.47 83.9597 1.0148    -0.232707 -0.810905 -0.536917    0 0
  v -141.396 83.6966 1.76642    -0.21353 -0.963628 -0.160702    0 0
  v -140.292 83.8234 1.59781    0.408867 -0.856714 -0.314434    0 0
  v -140.724 84.0461 0.900758    0.241001 -0.683016 -0.689499    0 0
  v -140.284 84.5349 0.841098    0.530258 -0.208806 -0.821721    0 0
  v -139.679 84.5144 1.51323    0.824902 -0.283498 -0.489046    0 0
  v -139.883 85.3151 1.46793    0.658018 0.561741 -0.501457    0 0
  v -140.421 85.0764 0.81033    0.444738 0.349868 -0.8245    0 0
  v -141.076 85.4349 0.821904    0.0686752 0.663261 -0.745231    0 0
  v -140.802 85.8251 1.48455    0.167717 0.90085 -0.400425    0 0
  v -141.906 85.6984 1.65316    -0.46929 0.832808 -0.293594    0 0
  v -141.822 85.3486 0.935942    -0.43479 0.620636 -0.652509    0 0
  v -142.334 84.8551 1.10282    -0.774584 0.154452 -0.613322    0 0
  v -142.641 84.9983 1.88946    -0.918656 0.314138 -0.23956    0 0
  v -149.746 59.1272 80.2288    -0.240428 -0.960426 0.140632    0 0
  v -152.22 59.7729 79.3169    -0.416802 -0.905359 0.0812518    0 0
  v -152.608 59.7329 74.9172    -0.417423 -0.908631 0.012155    0 0
  v -150.214 59.041 73.9762    -0.248159 -0.966105 -0.0711197    0 0
  v -154.724 61.3393 70.072    -0.387206 -0.869605 -0.306362    0 0
  v -155.991 61.4082 72.056    -0.453214 -0.890219 -0.0459076    0 0
  v -160.675 63.9612 72.1639    -0.51057 -0.85853 -0.0473686    0 0
  v -161.362 65.0104 70.2014    -0.551511 -0.766327 -0.329513    0 0
  v -165.062 67.3208 74.159    -0.748535 -0.661658 -0.0436423    0 0
  v -163.398 65.7068 75.1411    -0.567006 -0.822477 0.0451176    0 0
  v -162.798 65.7721 79.4988    -0.560373 -0.818546 0.12635    0 0
  v -164.199 67.3372 80.3058    -0.723036 -0.648568 0.237861    0 0
  v -159.65 65.047 84.1437    -0.539594 -0.733745 0.412864    0 0
  v -159.416 64.0968 82.36    -0.51599 -0.839701 0.169281    0 0
  v -154.943 61.5185 82.294    -0.464219 -0.871772 0.156573    0 0
  v -153.407 61.4458 84.12    -0.375913 -0.848588 0.372274    0 0
  v -155.455 69.4716 78.1788    -0.674466 -0.709319 -0.204847    0 0
  v -158.354 71.1112 78.2688    -0.176033 -0.931128 -0.319395    0 0
  v -158.647 71.0479 75.4598    -0.128049 -0.908138 0.398608    0 0
  v -155.712 69.4177 75.3578    -0.63446 -0.688471 0.351381    0 0
  v -153.005 60.2716 78.9498    -0.773863 -0.627488 -0.0859926    0 0
  v -153.201 61.1684 78.7481    -0.960328 -0.0639068 -0.271453    0 0
  v -153.45 61.118 75.3322    -0.909889 -0.0275747 0.413934    0 0
  v -153.293 60.22 75.2133    -0.766469 -0.596378 0.238452    0 0
  v -156.121 61.6185 72.8172    -0.515083 -0.693136 0.504235    0 0
  v -156.017 62.3863 73.1509    -0.331102 -0.0957796 0.938721    0 0
  v -159.619 64.3393 73.295    0.250224 -0.23074 0.940291    0 0
  v -160.076 63.768 72.9594    -0.298759 -0.836542 0.459282    0 0
  v -162.404 65.2592 75.5083    -0.132447 -0.97219 0.193144    0 0
  v -161.745 65.7017 75.6307    0.843119 -0.431374 0.321042    0 0
  v -161.332 65.7924 78.9903    0.764879 -0.441924 -0.468683    0 0
  v -161.94 65.3467 79.1893    -0.126929 -0.983721 -0.127206    0 0
  v -159.111 63.9482 81.5855    -0.343217 -0.855373 -0.387994    0 0
  v -158.764 64.5241 81.1716    0.140332 -0.30286 -0.942647    0 0
  v -155.327 62.5308 81.0839    -0.45915 -0.180668 -0.869793    0 0
  v -155.333 61.7629 81.4986    -0.582 -0.732595 -0.35296    0 0
  v -153.151 63.4119 78.5757    -0.959707 -0.035069 -0.278807    0 0
  v -153.574 66.5924 78.2137    -0.91518 -0.334063 -0.225492    0 0
  v -153.791 66.549 75.3792    -0.872761 -0.310007 0.377072    0 0
  v -153.389 63.3648 75.2835    -0.908256 -0.00138963 0.418414    0 0
  v -155.859 64.5843 73.1811    -0.291257 -0.00720248 0.956618    0 0
  v -155.93 67.6054 73.5569    -0.44808 -0.323519 0.833403    0 0
  v -158.905 69.2251 73.6724    0.176269 -0.403715 0.897743    0 0
  v -159.324 66.4608 73.3198    0.351422 -0.0505176 0.934853    0 0
  v -161.368 67.7711 75.5707    0.951118 -0.129694 0.280276    0 0
  v -160.675 70.3602 75.6234    0.753443 -0.542838 0.371014    0 0
  v -160.342 70.434 78.4189    0.67332 -0.557063 -0.486128    0 0
  v -160.968 67.8599 78.8084    0.868305 -0.159844 -0.46957    0 0
  v -158.499 66.6404 80.9108    0.234874 -0.140967 -0.96175    0 0
  v -158.203 69.3776 80.2412    0.0623133 -0.478294 -0.875986    0 0
  v -155.344 67.7274 80.1647    -0.561206 -0.39641 -0.726572    0 0
  v -155.195 64.7221 80.8266    -0.423273 -0.0980652 -0.900679    0 0
  v -132.829 61.2722 57.9027    -0.179742 -0.611578 -0.770497    0 0
  v -132.464 60.6338 58.5135    -0.0534874 -0.880927 -0.470221    0 0
  v -137.479 60.0911 60.5683    -0.208588 -0.783391 -0.585482    0 0
  v -131.254 76.545 108.59    -0.0175582 -0.431005 0.902179    0 0
  v -131.254 80.5571 110.055    -0.0442274 -0.255945 0.965679    0 0
  v -134.249 77.2275 108.634    -0.145565 -0.381186 0.912966    0 0
  v -132.032 82.8325 110.477    -0.0707343 -0.180593 0.981011    0 0
  v -132.842 84.1799 110.61    -0.0875345 -0.109981 0.990072    0 0
  v -139.295 80.7028 108.875    -0.208818 -0.27651 0.93805    0 0
  v -136.841 78.9629 108.811    -0.178707 -0.325899 0.928361    0 0
  v -133.531 85.29 110.637    -0.0911055 -0.0650661 0.993713    0 0
  v -134.011 86.4942 110.651    -0.0903294 -0.0357121 0.995271    0 0
  v -142.644 84.8721 108.957    -0.264136 -0.134513 0.955059    0 0
  v -141.291 82.6583 108.91    -0.243028 -0.209565 0.947111    0 0
  v -134.257 87.7638 110.656    -0.0898601 -0.0104376 0.9959    0 0
  v -134.257 89.0591 110.656    -0.0905155 0.0122753 0.995819    0 0
  v -143.418 89.5499 108.932    -0.28236 0.0497638 0.958017    0 0
  v -143.354 87.2098 108.97    -0.279018 -0.0365882 0.959588    0 0
  v -134.011 90.3288 110.651    -0.091658 0.0355365 0.995156    0 0
  v -133.531 91.5329 110.637    -0.0920626 0.0645289 0.99366    0 0
  v -141.375 94.0648 108.883    -0.251572 0.203879 0.946121    0 0
  v -142.775 91.8275 108.897    -0.273375 0.130279 0.953044    0 0
  v -132.842 92.6431 110.61    -0.0879201 0.109714 0.990067    0 0
  v -132.032 93.9904 110.477    -0.0707779 0.180558 0.981014    0 0
  v -136.841 97.86 108.811    -0.179336 0.3255 0.928379    0 0
  v -139.312 96.1002 108.87    -0.213591 0.273443 0.937874    0 0
  v -131.254 96.2658 110.055    -0.0442269 0.255945 0.965679    0 0
  v -131.254 100.278 108.59    -0.0175584 0.431005 0.902179    0 0
  v -134.249 99.5954 108.634    -0.145564 0.381186 0.912967    0 0
  v -132.842 65.9158 99.9755    -0.0616742 -0.743822 0.665526    0 0
  v -132.032 71.2262 105.146    -0.0454455 -0.626952 0.777731    0 0
  v -136.841 72.0761 105.155    -0.170195 -0.588946 0.790048    0 0
  v -139.304 67.0072 99.9755    -0.185891 -0.71404 0.674975    0 0
  v -134.034 58.3557 87.8801    -0.0740177 -0.935639 0.34511    0 0
  v -133.531 61.4587 94.1098    -0.069749 -0.83994 0.538179    0 0
  v -141.336 62.7737 94.1098    -0.207215 -0.808382 0.550981    0 0
  v -142.938 59.7119 87.8763    -0.20378 -0.900744 0.383581    0 0
  v -134.487 56.5055 73.8088    -0.0693595 -0.996937 -0.0361397    0 0
  v -134.374 56.7636 80.9152    -0.0722343 -0.989963 0.121474    0 0
  v -143.527 57.9527 80.9069    -0.174413 -0.974908 0.138329    0 0
  v -143.879 57.7422 73.5345    -0.180471 -0.982243 -0.051274    0 0
  v -131.728 71.4659 49.4185    -0.0549819 -0.55775 -0.828186    0 0
  v -133.097 66.0955 53.5189    -0.0780823 -0.639122 -0.765131    0 0
  v -139.661 67.365 53.5379    -0.174741 -0.620796 -0.76425    0 0
  v -136.016 72.2727 49.4185    -0.156373 -0.507316 -0.847454    0 0
  v -131.254 103.213 46.1521    -0.0948021 0.906582 0.411244    0 0
  v -131.506 104.357 43.2306    -0.0962096 0.941139 0.32404    0 0
  v -135.345 103.562 43.2306    -0.284421 0.896191 0.34051    0 0
  v -134.611 102.503 46.1521    -0.28029 0.857096 0.432232    0 0
  v -131.707 105.29 39.7645    -0.0986389 0.973796 0.20492    0 0
  v -131.829 105.877 35.7223    -0.100065 0.991147 0.0872661    0 0
  v -136.282 104.971 35.7223    -0.296205 0.950761 0.0911914    0 0
  v -135.929 104.428 39.7645    -0.291943 0.931997 0.214828    0 0
  v -131.85 105.98 31.4043    -0.100342 0.994273 -0.0367805    0 0
  v -131.771 105.589 27.0865    -0.0995047 0.984788 -0.142445    0 0
  v -136.113 104.704 27.0865    -0.294628 0.943992 -0.148574    0 0
  v -136.343 105.067 31.4043    -0.297023 0.954098 -0.038388    0 0
  v -131.614 104.814 23.0204    -0.0977248 0.964559 -0.245105    0 0
  v -131.379 103.656 19.4729    -0.0925099 0.908685 -0.407103    0 0
  v -134.978 102.913 19.4729    -0.273965 0.864122 -0.42218    0 0
  v -135.658 103.986 23.0204    -0.289556 0.922491 -0.255281    0 0
  v -131.046 102.01 16.7254    -0.0784524 0.765846 -0.63822    0 0
  v -130.65 100.03 14.8356    -0.0588496 0.597126 -0.799986    0 0
  v -132.821 99.5416 14.8288    -0.1915 0.54345 -0.817307    0 0
  v -134.01 101.386 16.7254    -0.232632 0.71815 -0.655853    0 0
  v -130.285 98.135 13.6374    -0.0399675 0.455877 -0.889145    0 0
  v -130.279 96.6841 13.0256    -0.0624047 0.313515 -0.94753    0 0
  v -131.602 97.7463 13.6031    -0.162809 0.396813 -0.903345    0 0
  v -126.929 70.7671 60.1076    -0.222375 -0.790291 0.570955    0 0
  v -123.451 69.5965 61.6084    -0.437495 -0.797647 -0.415159    0 0
  v -126.929 70.1174 61.0836    0.0887207 -0.540792 -0.836465    0 0
  v -126.117 60.4071 59.3247    -0.166395 -0.917317 0.361721    0 0
  v -120.51 59.595 61.8865    -0.303853 -0.948418 0.0904233    0 0
  v -120.96 60.4306 61.9944    -0.650166 -0.193008 0.734869    0 0
  v -126.114 61.2496 59.6202    -0.259115 -0.116716 0.958768    0 0
  v -120.266 58.8699 63.3268    0.0662063 -0.733477 -0.676482    0 0
  v -125.873 58.6299 62.7597    0.065801 -0.797927 -0.599152    0 0
  v -126.114 59.6334 62.3186    0.109607 -0.0676053 -0.991673    0 0
  v -120.96 59.7841 63.0738    -0.0105506 -0.0451355 -0.998925    0 0
  v -133.226 58.6299 62.7597    -0.065801 -0.797927 -0.599151    0 0
  v -138.833 58.8699 63.3268    -0.0662059 -0.733479 -0.67648    0 0
  v -138.139 59.7841 63.0738    0.0105512 -0.0451357 -0.998925    0 0
  v -132.985 59.6334 62.3186    -0.109607 -0.0676054 -0.991673    0 0
  v -138.589 59.595 61.8865    0.303854 -0.948418 0.0904256    0 0
  v -132.982 60.4071 59.3247    0.166395 -0.917317 0.361721    0 0
  v -132.985 61.2496 59.6202    0.259115 -0.116715 0.958769    0 0
  v -138.139 60.4306 61.9944    0.650167 -0.193009 0.734867    0 0
  v -126.215 64.1975 59.7108    -0.25712 -0.0268166 0.966007    0 0
  v -121.212 63.3517 62.0527    -0.641753 -0.0491347 0.765336    0 0
  v -121.934 67.3099 61.8468    -0.703108 -0.205689 0.680685    0 0
  v -126.378 68.3296 59.8246    -0.254701 -0.0709391 0.964414    0 0
  v -121.212 62.6785 63.1014    -0.00388905 -0.0152836 -0.999876    0 0
  v -126.215 62.5145 62.3327    0.114732 -0.00607425 -0.993378    0 0
  v -126.378 66.8256 62.102    0.116354 -0.128913 -0.984806    0 0
  v -121.934 66.7083 62.7577    -0.0493004 -0.223805 -0.973386    0 0
  v -132.885 62.5145 62.3327    -0.114732 -0.00607382 -0.993378    0 0
  v -137.887 62.6785 63.1014    0.00388936 -0.0152834 -0.999876    0 0
  v -137.165 66.7083 62.7577    0.049302 -0.223806 -0.973386    0 0
  v -132.721 66.8256 62.102    -0.116354 -0.128913 -0.984806    0 0
  v -137.887 63.3517 62.0527    0.641754 -0.0491353 0.765335    0 0
  v -132.885 64.1975 59.7108    0.257119 -0.0268171 0.966008    0 0
  v -132.721 68.3296 59.8246    0.2547 -0.0709392 0.964415    0 0
  v -137.165 67.3099 61.8468    0.70311 -0.205691 0.680682    0 0
  v -131.134 85.5062 12.3331    -0.0728687 -0.0484226 -0.996165    0 0
  v -131.953 87.3291 12.32    -0.0787474 -0.0184395 -0.996724    0 0
  v -132.068 89.5132 12.3469    -0.0919 0.0249161 -0.995456    0 0
  v -131.147 91.3062 12.3348    -0.0764981 0.0462486 -0.995997    0 0
  v -129.55 91.9363 12.2774    1.43296e-006 0.0407007 -0.999171    0 0
  v -127.953 91.3062 12.3348    0.0764973 0.0462491 -0.995997    0 0
  v -127.031 89.5132 12.3469    0.0919003 0.0249154 -0.995456    0 0
  v -127.146 87.3291 12.32    0.0787461 -0.0184393 -0.996724    0 0
  v -127.966 85.5062 12.3331    0.0728687 -0.0484207 -0.996165    0 0
  v -129.55 84.8866 12.2774    3.90633e-007 -0.0407699 -0.999169    0 0
  v -117.747 59.8852 62.4773    0.267669 -0.793564 -0.546451    0 0
  v -122.138 62.1387 58.1208    0.172817 -0.730062 -0.661168    0 0
  v -115.641 63.3929 58.6378    0.243409 -0.749853 -0.615201    0 0
  v -113.097 60.3568 64.4094    0.310642 -0.834644 -0.45483    0 0
  v -121.62 60.0911 60.5683    0.208588 -0.783392 -0.585481    0 0
  v -126.635 60.6338 58.5135    0.0534879 -0.880926 -0.470221    0 0
  v -126.27 61.2722 57.9027    0.179742 -0.611577 -0.770498    0 0
  v -140.23 58.5168 64.6481    -0.155954 -0.933692 -0.322332    0 0
  v -133.685 57.9496 64.5126    -0.048134 -0.948424 -0.313328    0 0
  v -134.223 57.0711 68.1195    -0.0600496 -0.982894 -0.174111    0 0
  v -142.747 58.1674 67.7907    -0.190191 -0.960865 -0.201409    0 0
  v -141.352 59.8852 62.4773    -0.267669 -0.793564 -0.546452    0 0
  v -146.002 60.3568 64.4094    -0.310642 -0.834644 -0.45483    0 0
  v -143.458 63.3929 58.6378    -0.243409 -0.749853 -0.615202    0 0
  v -136.961 62.1387 58.1208    -0.172817 -0.730062 -0.661169    0 0
  v -132.17 70.1174 61.0836    -0.0887206 -0.540792 -0.836465    0 0
  v -135.648 69.5965 61.6084    0.437495 -0.797647 -0.41516    0 0
  v -132.17 70.7671 60.1076    0.222375 -0.79029 0.570956    0 0
  v -119.97 72.8768 105.177    0.213179 -0.557212 0.80254    0 0
  v -115.652 71.4344 102.723    0.281285 -0.595885 0.752197    0 0
  v -115.63 74.9973 105.184    0.296685 -0.484152 0.823149    0 0
  v -119.97 76.3788 107.259    0.218386 -0.426897 0.877534    0 0
  v -111.95 67.1468 97.0649    0.325586 -0.701079 0.634415    0 0
  v -110.877 70.6545 99.9638    0.361041 -0.610454 0.704979    0 0
  v -116.688 67.9596 99.9755    0.245374 -0.687476 0.683497    0 0
  v -105.823 74.277 99.8578    0.467498 -0.496581 0.731337    0 0
  v -110.784 74.2709 102.655    0.383183 -0.502404 0.775088    0 0
  v -105.97 70.6526 97.0616    0.446369 -0.606952 0.657544    0 0
  v -116.644 78.4635 107.26    0.279841 -0.358539 0.890584    0 0
  v -111.73 77.7937 105.062    0.382594 -0.383868 0.840397    0 0
  v -106.521 77.9189 102.37    0.443633 -0.424121 0.7895    0 0
  v -108.629 81.1757 104.862    0.416492 -0.276679 0.866016    0 0
  v -113.797 81.0046 107.153    0.34199 -0.271455 0.899642    0 0
  v -101.181 75.0734 97.0481    0.51151 -0.538681 0.669462    0 0
  v -101.427 78.2602 99.7369    0.346466 -0.618201 0.705541    0 0
  v -95.7737 80.0079 101.116    -0.154012 -0.886764 0.435811    0 0
  v -100.034 80.6031 101.428    0.0726591 -0.600229 0.796521    0 0
  v -97.0446 78.6709 98.2193    0.198041 -0.868526 0.454359    0 0
  v -99.9957 83.4873 102.327    0.0778733 -0.0242553 0.996668    0 0
  v -103.957 82.2522 103.081    0.306852 -0.272639 0.911871    0 0
  v -96.7662 81.7845 102.524    -0.310586 -0.286723 0.90627    0 0
  v -112.026 83.8614 107.209    0.367953 -0.195302 0.909102    0 0
  v -107.394 84.6592 105.165    0.424589 -0.135497 0.89519    0 0
  v -102.82 85.7432 103.08    0.367317 0.0718282 0.927318    0 0
  v -106.427 88.0163 104.859    0.469208 0.00827972 0.883049    0 0
  v -111.11 86.7552 107.209    0.395151 -0.0428894 0.917614    0 0
  v -96.1168 83.809 102.533    -0.153597 0.421569 0.893693    0 0
  v -98.2922 85.9556 101.432    0.274449 0.529333 0.802798    0 0
  v -94.4517 86.6126 98.2238    0.478686 0.736416 0.47807    0 0
  v -98.1695 88.1896 99.7299    0.531923 0.429907 0.729547    0 0
  v -94.1671 85.0015 101.139    0.197919 0.862715 0.465351    0 0
  v -99.8659 92.583 99.8433    0.612334 0.19763 0.7655    0 0
  v -102.606 89.9493 102.36    0.556091 0.152326 0.817043    0 0
  v -96.1081 90.5644 97.0338    0.66515 0.233916 0.709125    0 0
  v -111.04 89.7307 107.155    0.400317 0.0498403 0.91502    0 0
  v -107.276 91.7046 105.058    0.484701 0.134691 0.864247    0 0
  v -104.345 94.3375 102.646    0.539528 0.238834 0.807383    0 0
  v -109.168 95.4988 105.187    0.447298 0.268934 0.852994    0 0
  v -112.14 92.8214 107.267    0.378455 0.166139 0.910588    0 0
  v -97.8684 95.7935 97.0467    0.641209 0.295724 0.708095    0 0
  v -102.293 97.5885 99.9533    0.569325 0.339961 0.748529    0 0
  v -105.981 102.356 99.9721    0.484751 0.483063 0.729154    0 0
  v -107.081 98.7308 102.722    0.48245 0.373802 0.792158    0 0
  v -101.191 101.289 97.0575    0.574425 0.442082 0.688912    0 0
  v -114.026 95.781 107.294    0.335577 0.271783 0.901955    0 0
  v -111.959 98.9919 105.202    0.379463 0.388335 0.839764    0 0
  v -110.896 102.517 102.725    0.386428 0.502427 0.77346    0 0
  v -115.653 101.822 105.199    0.294904 0.485709 0.822872    0 0
  v -116.69 98.352 107.288    0.275316 0.361724 0.890705    0 0
  v -105.972 106.078 97.0634    0.459072 0.594141 0.660491    0 0
  v -110.893 106.15 99.9752    0.366069 0.607525 0.704916    0 0
  v -116.688 108.863 99.9755    0.245374 0.687477 0.683496    0 0
  v -115.652 105.389 102.723    0.281331 0.595854 0.752204    0 0
  v -111.95 109.676 97.0649    0.327473 0.699924 0.634719    0 0
  v -119.97 100.444 107.259    0.217837 0.42733 0.87746    0 0
  v -119.97 103.946 105.177    0.213179 0.557212 0.80254    0 0
  v -120.992 107.339 102.715    0.174924 0.660375 0.730278    0 0
  v -124.623 105.316 105.14    0.107918 0.618572 0.778282    0 0
  v -123.557 102.134 107.171    0.160063 0.492687 0.855359    0 0
  v -118.706 112.084 97.0649    0.197039 0.761864 0.61704    0 0
  v -122.995 110.497 99.9755    0.123863 0.733392 0.668427    0 0
  v -129.55 111.044 99.9755    -3.77628e-008 0.74693 0.664903    0 0
  v -126.656 108.306 102.712    0.0563131 0.691602 0.720081    0 0
  v -125.888 113.295 97.0649    0.0659537 0.791246 0.607931    0 0
  v -127.469 102.886 107.149    0.0318301 0.536456 0.843328    0 0
  v -129.55 105.665 105.155    -1.1989e-006 0.625795 0.779988    0 0
  v -114.018 63.9181 94.1098    0.277338 -0.778913 0.562476    0 0
  v -109.113 63.8784 91.1633    0.356929 -0.776976 0.518565    0 0
  v -107.06 67.1576 94.1197    0.410959 -0.696993 0.587635    0 0
  v -106.864 61.754 85.8124    0.35788 -0.83129 0.425299    0 0
  v -104.263 64.6492 88.4949    0.4408 -0.749871 0.493345    0 0
  v -111.903 60.9307 87.975    0.283394 -0.857781 0.428836    0 0
  v -97.5232 69.5001 88.1047    0.608637 -0.613944 0.502628    0 0
  v -102.218 68.0037 91.2277    0.504312 -0.66812 0.54707    0 0
  v -99.7116 65.9293 85.8446    0.53856 -0.700226 0.468654    0 0
  v -101.207 71.5771 94.2094    0.543086 -0.578944 0.608179    0 0
  v -96.7179 73.4525 91.3843    0.621282 -0.557938 0.550195    0 0
  v -96.8663 76.6131 94.8888    0.502121 -0.696633 0.512422    0 0
  v -93.2671 71.801 84.6383    0.744793 -0.543792 0.386747    0 0
  v -92.6756 75.7165 88.1758    0.755334 -0.480735 0.445381    0 0
  v -89.4967 81.7164 87.8216    0.867016 -0.276274 0.414675    0 0
  v -92.0367 79.3907 91.1701    0.825553 -0.482025 0.293452    0 0
  v -89.2501 78.2361 84.5624    0.83203 -0.403481 0.380697    0 0
  v -91.3808 80.6362 97.311    0.742139 -0.626302 -0.238696    0 0
  v -93.6145 78.7641 94.8961    0.601391 -0.777559 0.183657    0 0
  v -91.2982 82.0426 93.9081    0.953346 -0.301745 -0.00898216    0 0
  v -93.4793 79.3708 98.8262    0.185632 -0.978026 0.0948963    0 0
  v -91.7194 84.8539 98.8489    0.55269 0.816131 0.168716    0 0
  v -91.4129 85.5852 94.8996    0.888091 0.402431 0.222133    0 0
  v -93.0796 88.2315 94.8819    0.7216 0.413332 0.555382    0 0
  v -90.3683 84.5684 91.1683    0.949014 -0.0601308 0.309445    0 0
  v -90.5781 83.1503 97.3202    0.965629 0.135896 -0.221569    0 0
  v -87.1578 84.7796 84.5613    0.906904 -0.133946 0.39948    0 0
  v -88.7988 87.9296 88.1725    0.882586 0.0072693 0.470094    0 0
  v -89.7099 94.6089 88.0023    0.824817 0.248793 0.507719    0 0
  v -91.1424 90.8668 91.3756    0.791233 0.174755 0.586013    0 0
  v -87.2309 91.6349 84.6391    0.899155 0.136279 0.41587    0 0
  v -94.0996 93.5556 94.1948    0.718135 0.229595 0.656938    0 0
  v -92.9093 97.2625 91.1176    0.738622 0.336796 0.583957    0 0
  v -96.7724 99.5319 94.1092    0.653702 0.396809 0.644373    0 0
  v -89.3114 98.5231 84.5353    0.828865 0.393263 0.397904    0 0
  v -92.7002 101.218 87.8878    0.739685 0.467752 0.483812    0 0
  v -97.6476 107.211 87.8783    0.617441 0.654333 0.436595    0 0
  v -96.6932 103.468 91.0583    0.649093 0.520124 0.555112    0 0
  v -93.5087 104.968 84.511    0.712266 0.605697 0.354694    0 0
  v -101.17 105.153 94.1064    0.555539 0.561797 0.612993    0 0
  v -102.223 108.811 91.0626    0.517675 0.68569 0.511705    0 0
  v -107.056 109.656 94.1094    0.419116 0.699422 0.578921    0 0
  v -99.5749 110.541 84.5124    0.561302 0.770051 0.303251    0 0
  v -104.254 112.108 87.8798    0.466274 0.792578 0.392949    0 0
  v -112.068 115.721 87.8792    0.310852 0.87741 0.365408    0 0
  v -109.131 112.914 91.0635    0.370208 0.795696 0.47939    0 0
  v -107.142 114.933 84.5118    0.402162 0.876281 0.265325    0 0
  v -114.018 112.905 94.1098    0.278888 0.783255 0.555638    0 0
  v -116.956 115.694 91.0632    0.221793 0.859854 0.459846    0 0
  v -121.626 114.87 94.1098    0.139686 0.828906 0.541667    0 0
  v -115.721 117.954 84.5083    0.240763 0.939848 0.24232    0 0
  v -120.626 117.922 87.8773    0.155208 0.923876 0.349805    0 0
  v -129.55 118.664 87.8762    -3.36117e-008 0.938611 0.344978    0 0
  v -125.295 117.097 91.0627    0.0740882 0.88988 0.450139    0 0
  v -124.876 119.488 84.5039    0.0805288 0.969382 0.231978    0 0
  v -129.55 115.53 94.1098    -7.73393e-007 0.843566 0.537026    0 0
  v -93.6803 69.0351 80.7922    0.760477 -0.59389 0.262621    0 0
  v -90.909 71.6115 77.1982    0.814311 -0.568372 0.11769    0 0
  v -89.8029 74.6817 80.9751    0.824283 -0.499396 0.26676    0 0
  v -91.3943 71.6444 69.6073    0.772763 -0.585493 -0.245021    0 0
  v -88.7253 74.5956 73.3663    0.851195 -0.523226 -0.0412453    0 0
  v -92.686 69.0038 73.6029    0.782111 -0.619835 -0.0640803    0 0
  v -85.4586 81.3128 73.3573    0.949821 -0.311788 -0.0250521    0 0
  v -87.1637 77.8202 77.1744    0.893456 -0.429121 0.132635    0 0
  v -87.2967 78.0903 69.5609    0.874103 -0.433339 -0.219458    0 0
  v -86.5894 81.3168 80.9035    0.915062 -0.293469 0.276653    0 0
  v -84.8926 84.8021 77.1742    0.976408 -0.153818 0.151549    0 0
  v -85.5408 88.3151 80.9736    0.95385 0.00227361 0.300276    0 0
  v -85.0249 84.9118 69.5609    0.96277 -0.156729 -0.220251    0 0
  v -84.3121 88.4115 73.3573    0.999863 -1.59375e-006 -0.016579    0 0
  v -85.4586 95.5101 73.3573    0.949873 0.311804 -0.0227969    0 0
  v -84.8999 91.98 77.182    0.975376 0.154317 0.157569    0 0
  v -85.025 91.9111 69.5609    0.96277 0.156728 -0.220252    0 0
  v -86.632 95.4066 80.9396    0.91188 0.287812 0.292642    0 0
  v -87.1699 98.9963 77.1716    0.887278 0.440612 0.136381    0 0
  v -89.9346 102.194 80.9167    0.803123 0.536829 0.258472    0 0
  v -87.2967 98.7326 69.5609    0.869106 0.443416 -0.219173    0 0
  v -88.87 102.251 73.3573    0.821274 0.569126 -0.0400642    0 0
  v -94.3473 108.302 73.3573    0.655594 0.752549 -0.0621825    0 0
  v -91.6113 105.49 77.1692    0.743519 0.661095 0.100661    0 0
  v -91.7277 105.039 69.5609    0.720652 0.657937 -0.218584    0 0
  v -95.2665 108.298 80.9148    0.654247 0.726504 0.210125    0 0
  v -97.9953 111.122 77.1693    0.574845 0.815904 0.0620791    0 0
  v -102.36 113.37 80.9147    0.490136 0.855606 0.166448    0 0
  v -98.0931 110.509 69.5609    0.552522 0.804147 -0.219243    0 0
  v -101.629 113.349 73.3564    0.48517 0.870482 -0.0828876    0 0
  v -110.241 117.16 73.3485    0.322554 0.941449 -0.0981428    0 0
  v -105.955 115.61 77.1667    0.408921 0.91202 0.0316795    0 0
  v -106.028 114.877 69.5571    0.391831 0.893069 -0.221125    0 0
  v -110.75 117.174 80.9108    0.326707 0.935222 0.136462    0 0
  v -114.984 118.73 77.1558    0.245102 0.969414 0.0127188    0 0
  v -119.951 119.516 80.9015    0.163434 0.979178 0.120415    0 0
  v -115.03 117.927 69.5416    0.2358 0.945893 -0.2229    0 0
  v -119.689 119.527 73.3301    0.162298 0.981022 -0.106089    0 0
  v -129.55 120.34 73.3186    -9.33635e-010 0.994133 -0.108164    0 0
  v -124.626 120.331 77.1421    0.0825611 0.996574 0.00492217    0 0
  v -124.642 119.503 69.5222    0.0799782 0.971338 -0.223845    0 0
  v -129.55 120.312 80.8958    0 0.993246 0.116024    0 0
  v -109.964 61.1517 65.2368    0.345985 -0.835828 -0.426246    0 0
  v -107.418 64.1396 62.1159    0.370505 -0.767937 -0.522493    0 0
  v -102.488 64.7316 65.236    0.439889 -0.766469 -0.467999    0 0
  v -105.421 61.6844 68.1464    0.376154 -0.840237 -0.390526    0 0
  v -111.135 67.4662 56.0989    0.302132 -0.645375 -0.701575    0 0
  v -105.715 67.4016 59.052    0.391367 -0.682612 -0.617149    0 0
  v -112.41 64.3596 58.8558    0.291434 -0.740681 -0.605358    0 0
  v -99.5628 71.6391 59.0738    0.496748 -0.578859 -0.646655    0 0
  v -100.421 68.0753 62.2473    0.481821 -0.688441 -0.542124    0 0
  v -105.073 70.8861 56.1425    0.391332 -0.559518 -0.730615    0 0
  v -97.8221 65.92 68.3083    0.543499 -0.730891 -0.412804    0 0
  v -95.4393 69.3968 65.8068    0.600575 -0.659768 -0.451681    0 0
  v -94.5397 73.1045 62.3475    0.620246 -0.559779 -0.549493    0 0
  v -90.3673 75.2876 65.8696    0.760018 -0.508725 -0.40444    0 0
  v -100.086 75.2246 56.1425    0.472494 -0.42697 -0.771003    0 0
  v -94.8792 76.7416 59.0738    0.59883 -0.42137 -0.681065    0 0
  v -91.9623 82.4255 59.0738    0.667369 -0.222529 -0.710703    0 0
  v -90.4735 78.9301 62.3401    0.734387 -0.376595 -0.56467    0 0
  v -96.6143 80.2259 56.1425    0.531136 -0.268333 -0.803674    0 0
  v -87.12 81.6964 65.8621    0.863762 -0.288733 -0.412976    0 0
  v -88.3694 85.1966 62.3401    0.800038 -0.131438 -0.585375    0 0
  v -86.0159 88.4115 65.8621    0.907366 9.34967e-007 -0.420341    0 0
  v -94.8343 85.636 56.1425    0.562199 -0.0906501 -0.822019    0 0
  v -90.9819 88.4115 59.0738    0.691893 -6.92761e-008 -0.722    0 0
  v -91.9623 94.3974 59.0738    0.667369 0.222529 -0.710704    0 0
  v -88.3694 91.6263 62.3401    0.800038 0.131438 -0.585374    0 0
  v -94.8343 91.187 56.1425    0.562199 0.0906509 -0.822019    0 0
  v -87.12 95.1265 65.8621    0.863761 0.288732 -0.412977    0 0
  v -90.4735 97.8928 62.3401    0.733874 0.377821 -0.564518    0 0
  v -90.4051 101.503 65.8621    0.750708 0.529718 -0.39476    0 0
  v -96.6143 96.597 56.1425    0.531137 0.268332 -0.803674    0 0
  v -94.8792 100.081 59.0738    0.599404 0.421774 -0.68031    0 0
  v -99.5628 105.184 59.0738    0.50042 0.583129 -0.639954    0 0
  v -94.5775 103.686 62.3401    0.622881 0.573724 -0.531845    0 0
  v -100.086 101.598 56.1425    0.472494 0.42697 -0.771003    0 0
  v -95.6796 107.227 65.8621    0.602972 0.704744 -0.373846    0 0
  v -100.473 108.711 62.3401    0.488496 0.717141 -0.497071    0 0
  v -102.691 112.002 65.8613    0.448918 0.81958 -0.356035    0 0
  v -105.073 105.937 56.1425    0.389784 0.561314 -0.730065    0 0
  v -105.787 109.439 59.0734    0.385269 0.701449 -0.599614    0 0
  v -113.136 112.642 59.0694    0.262831 0.780138 -0.567719    0 0
  v -107.819 112.72 62.3373    0.352156 0.809948 -0.469009    0 0
  v -111.28 109.392 56.1416    0.292593 0.661413 -0.690595    0 0
  v -110.981 115.607 65.8533    0.300133 0.889612 -0.344255    0 0
  v -116.141 115.51 62.3264    0.213461 0.866703 -0.450844    0 0
  v -120.069 117.848 65.8349    0.151703 0.928658 -0.338497    0 0
  v -118.29 111.778 56.1381    0.18102 0.729312 -0.6598    0 0
  v -121.174 114.613 59.0602    0.133424 0.825272 -0.548748    0 0
  v -129.55 115.283 59.0545    0 0.839661 -0.543112    0 0
  v -125.019 116.943 62.3128    0.0723794 0.893521 -0.443149    0 0
  v -125.747 112.986 56.1337    0.061471 0.762556 -0.643995    0 0
  v -129.55 118.618 65.8234    0 0.941443 -0.337172    0 0
  v -116.455 68.2704 53.5815    0.220117 -0.596925 -0.77151    0 0
  v -116.188 71.6196 51.4139    0.251012 -0.520239 -0.816299    0 0
  v -110.75 70.895 53.6208    0.30295 -0.520929 -0.798032    0 0
  v -121.894 76.2392 47.5221    0.241982 -0.412578 -0.878194    0 0
  v -117.097 75.0069 49.4185    0.25073 -0.385902 -0.887814    0 0
  v -121.007 72.983 49.4185    0.18898 -0.475277 -0.859301    0 0
  v -113.747 77.718 49.4185    0.290691 -0.287069 -0.912738    0 0
  v -111.615 74.3786 51.4183    0.282051 -0.37574 -0.882761    0 0
  v -119.181 78.238 47.5221    0.286699 -0.314131 -0.905056    0 0
  v -105.806 74.436 53.6251    0.369381 -0.412301 -0.832806    0 0
  v -107.919 77.8526 51.4183    0.366451 -0.306788 -0.878405    0 0
  v -102.072 78.6876 53.6251    0.418355 -0.281999 -0.863397    0 0
  v -116.979 80.7565 47.5221    0.312316 -0.215108 -0.925304    0 0
  v -111.223 80.9712 49.4185    0.31427 -0.187403 -0.930653    0 0
  v -109.65 84.595 49.4185    0.325732 -0.0920615 -0.940969    0 0
  v -105.347 81.8572 51.4183    0.34382 -0.16096 -0.925138    0 0
  v -115.446 83.6598 47.5221    0.324137 -0.124806 -0.937741    0 0
  v -99.7473 83.4237 53.6251    0.446876 -0.142769 -0.88313    0 0
  v -104.028 86.1891 51.4183    0.40923 -0.0611351 -0.910381    0 0
  v -98.9658 88.4115 53.6251    0.456273 6.3824e-007 -0.88984    0 0
  v -114.66 86.8003 47.5221    0.328678 -0.0403903 -0.943578    0 0
  v -109.122 88.4115 49.4185    0.329168 -4.37834e-008 -0.944271    0 0
  v -109.65 92.2279 49.4185    0.325732 0.0920617 -0.940969    0 0
  v -104.028 90.6339 51.4183    0.354216 0.0529262 -0.933665    0 0
  v -114.66 90.0226 47.5221    0.328677 0.0403903 -0.943578    0 0
  v -99.7473 93.3993 53.6251    0.446876 0.142768 -0.88313    0 0
  v -105.347 94.9658 51.4183    0.395531 0.185134 -0.8996    0 0
  v -102.072 98.1354 53.6251    0.418355 0.281999 -0.863397    0 0
  v -115.446 93.1632 47.5221    0.324137 0.124806 -0.937741    0 0
  v -111.223 95.8518 49.4185    0.31427 0.187403 -0.930653    0 0
  v -113.747 99.1049 49.4185    0.290691 0.287068 -0.912738    0 0
  v -107.919 98.9704 51.4183    0.32115 0.268919 -0.908044    0 0
  v -116.979 96.0664 47.5221    0.312316 0.215108 -0.925304    0 0
  v -105.806 102.387 53.6251    0.369381 0.412302 -0.832806    0 0
  v -111.615 102.444 51.4183    0.318037 0.424151 -0.847908    0 0
  v -110.765 105.931 53.625    0.301026 0.524935 -0.796132    0 0
  v -119.181 98.5849 47.5221    0.286698 0.31413 -0.905056    0 0
  v -117.097 101.816 49.4185    0.25073 0.385902 -0.887814    0 0
  v -121.007 103.84 49.4185    0.188981 0.475277 -0.859301    0 0
  v -116.202 105.207 51.4182    0.225085 0.471001 -0.852933    0 0
  v -121.894 100.584 47.5221    0.241982 0.412576 -0.878194    0 0
  v -116.6 108.588 53.6242    0.214497 0.612464 -0.760841    0 0
  v -121.346 107.1 51.4178    0.160748 0.602614 -0.781676    0 0
  v -122.95 110.204 53.6224    0.111121 0.668691 -0.73519    0 0
  v -124.88 101.94 47.5221    0.165418 0.502654 -0.848514    0 0
  v -125.21 105.055 49.4185    0.101594 0.541261 -0.834694    0 0
  v -129.55 105.457 49.4185    -9.89397e-007 0.565038 -0.825065    0 0
  v -126.783 108.045 51.4174    0.05046 0.58878 -0.806717    0 0
  v -127.98 102.606 47.5221    0.0585895 0.557789 -0.827912    0 0
  v -129.55 110.745 53.6213    -4.66461e-010 0.687464 -0.726218    0 0
  v -74.3547 76.4501 125.915    0.0199383 -0.237954 0.971072    0 0
  v -73.1276 76.2313 125.722    0.207881 -0.323223 0.923208    0 0
  v -72.8483 77.186 125.833    0.260384 -0.0244355 0.965196    0 0
  v -74.1006 77.3164 126.015    0.0545062 -0.00716081 0.998488    0 0
  v -72.6168 75.2055 124.944    0.33752 -0.613072 0.714299    0 0
  v -72.043 76.0903 125.268    0.437367 -0.394115 0.808321    0 0
  v -73.6012 75.3329 125.357    0.162658 -0.542957 0.823857    0 0
  v -70.8863 76.9025 124.668    0.703031 -0.117203 0.701435    0 0
  v -71.7638 77.0451 125.378    0.5079 -0.0643623 0.859008    0 0
  v -71.1404 76.0362 124.568    0.627835 -0.419465 0.655646    0 0
  v -72.7697 78.161 125.683    0.297789 0.241942 0.923464    0 0
  v -71.7853 78.0336 125.27    0.507187 0.234407 0.829346    0 0
  v -92.9044 80.498 104.182    -0.496097 -0.654306 0.570764    0 0
  v -89.5109 80.3728 107.513    -0.697955 -0.26297 0.666113    0 0
  v -92.9522 81.9281 104.649    -0.530949 0.153078 0.833463    0 0
  v -91.722 79.6221 102.926    -0.140923 -0.985148 0.0981026    0 0
  v -89.0488 79.4592 106.904    -0.431887 -0.865499 0.253742    0 0
  v -83.5492 77.9188 113.445    -0.511066 -0.849092 0.133624    0 0
  v -86.2618 79.0577 110.644    -0.672056 -0.608366 0.422174    0 0
  v -85.5826 78.5439 110.084    -0.198896 -0.978209 -0.0595533    0 0
  v -86.356 79.9506 110.936    -0.724917 0.169822 0.667575    0 0
  v -84.0028 78.6886 113.868    -0.813509 -0.269486 0.515345    0 0
  v -90.1298 79.8898 101.612    0.378636 -0.888631 -0.258787    0 0
  v -87.9901 79.2652 106.044    0.0867296 -0.976367 -0.197953    0 0
  v -89.0264 81.2865 101.112    0.846548 -0.251666 -0.469064    0 0
  v -86.8992 79.9323 105.414    0.581217 -0.650096 -0.489451    0 0
  v -81.5927 78.3457 112.59    0.5227 -0.59635 -0.609222    0 0
  v -84.5666 78.8019 109.533    0.31568 -0.848854 -0.424021    0 0
  v -83.8696 79.5755 109.306    0.772589 -0.182937 -0.607981    0 0
  v -82.5852 77.7817 112.933    0.0750222 -0.936194 -0.343385    0 0
  v -89.196 82.8584 101.65    0.757224 0.6275 -0.181261    0 0
  v -86.5586 81.0439 105.449    0.843061 0.293992 -0.450351    0 0
  v -90.4795 83.5635 102.981    0.276421 0.939137 0.203992    0 0
  v -87.1632 81.964 106.132    0.502269 0.86223 -0.065465    0 0
  v -81.9291 80.029 113.136    0.43853 0.881153 -0.176806    0 0
  v -84.0678 80.4793 109.637    0.671144 0.67074 -0.315712    0 0
  v -84.851 81.004 110.237    0.214305 0.970671 0.10896    0 0
  v -81.3303 79.2447 112.671    0.748233 0.369037 -0.551326    0 0
  v -92.0626 83.1729 104.22    -0.146371 0.789035 0.596657    0 0
  v -88.2372 82.109 106.992    -0.0177104 0.932489 0.360765    0 0
  v -89.1856 81.4354 107.548    -0.479274 0.550649 0.683434    0 0
  v -83.7404 79.5875 113.949    -0.60689 0.558705 0.565272    0 0
  v -85.7631 80.7351 110.748    -0.333538 0.794689 0.50717    0 0
  v -82.8932 80.1662 113.647    -0.135618 0.946703 0.292168    0 0
  v -82.4408 77.6239 115.751    -0.761636 -0.59957 0.245816    0 0
  v -82.0091 77.7483 117.333    -0.951634 -0.21586 0.218625    0 0
  v -82.6018 78.6696 116.074    -0.846618 0.187636 0.498026    0 0
  v -81.5435 77.0234 115.218    -0.243357 -0.943307 -0.225719    0 0
  v -81.2953 76.639 116.779    -0.601157 -0.786354 -0.142329    0 0
  v -80.8975 75.6579 118.07    -0.648123 -0.633911 -0.42201    0 0
  v -81.5757 76.7213 117.929    -0.865384 -0.47091 -0.171329    0 0
  v -80.1628 75.8055 117.156    -0.34208 -0.764019 -0.547043    0 0
  v -81.8368 78.3243 118.411    -0.961639 0.27249 0.0316212    0 0
  v -81.9679 77.3047 118.882    -0.983393 -0.114737 -0.14062    0 0
  v -80.2515 77.3279 114.752    0.268962 -0.772815 -0.574819    0 0
  v -79.8245 76.4465 116.151    -0.00192756 -0.824048 -0.566517    0 0
  v -79.3909 78.2356 114.608    0.655659 -0.104347 -0.747812    0 0
  v -78.3321 77.267 115.765    0.378349 -0.46233 -0.801937    0 0
  v -76.4666 76.6046 116.579    0.198049 -0.312644 -0.928994    0 0
  v -78.1449 76.2802 116.492    0.108854 -0.573965 -0.811612    0 0
  v -76.805 77.6773 116.304    0.354018 0.00358905 -0.935232    0 0
  v -78.697 75.3779 117.149    -0.0991705 -0.653587 -0.750326    0 0
  v -79.6798 79.2938 114.963    0.552073 0.693552 -0.462818    0 0
  v -77.9521 78.5668 115.913    0.530391 0.389295 -0.753083    0 0
  v -80.7049 79.9067 115.528    0.111633 0.993014 -0.0382311    0 0
  v -78.8747 79.6961 116.522    0.278696 0.86063 -0.426197    0 0
  v -77.2657 80.2149 117.703    0.104749 0.758663 -0.643007    0 0
  v -77.2567 79.2985 116.839    0.285856 0.623449 -0.727734    0 0
  v -78.8602 80.2324 117.666    -0.0600026 0.912985 -0.403557    0 0
  v -75.8941 78.5394 116.801    0.28913 0.367692 -0.883859    0 0
  v -81.869 79.5898 115.962    -0.445109 0.820538 0.358602    0 0
  v -80.3455 79.8887 117.149    -0.258047 0.966022 0.014631    0 0
  v -81.6292 79.0481 117.482    -0.739488 0.614105 0.275739    0 0
  v -81.3953 79.2396 119.103    -0.781458 0.617645 -0.0885353    0 0
  v -80.6875 79.7396 118.276    -0.560527 0.825374 -0.0675759    0 0
  v -79.4662 80.495 118.624    -0.343751 0.890907 -0.296851    0 0
  v -81.6006 76.0578 119.098    -0.865221 -0.465746 -0.185671    0 0
  v -81.9916 76.9549 120.155    -0.981261 -0.177734 0.0744202    0 0
  v -81.961 78.2782 119.761    -0.960826 0.277076 0.00659846    0 0
  v -79.6392 74.7928 118.031    -0.343733 -0.755602 -0.557596    0 0
  v -80.6111 74.8349 119.114    -0.623353 -0.739104 -0.255256    0 0
  v -79.9682 74.1693 120.366    -0.544586 -0.8387 0.00292407    0 0
  v -81.3453 75.4889 120.327    -0.819916 -0.567033 0.0788025    0 0
  v -78.9583 73.9529 119.032    -0.280182 -0.886293 -0.368758    0 0
  v -81.7827 78.1884 121.13    -0.92659 0.235652 0.293085    0 0
  v -81.5668 76.622 121.568    -0.893682 -0.251339 0.3717    0 0
  v -76.8398 75.456 117.106    0.0981964 -0.56178 -0.821438    0 0
  v -77.7731 74.4778 117.927    -0.0413302 -0.758305 -0.650589    0 0
  v -74.9785 77.3955 116.839    0.327974 0.00970192 -0.944637    0 0
  v -74.8967 76.0621 117.188    0.290835 -0.393158 -0.872262    0 0
  v -73.3513 75.5938 118.133    0.431121 -0.50634 -0.74683    0 0
  v -75.5524 74.7624 117.904    0.197578 -0.684715 -0.701518    0 0
  v -73.2865 77.1227 117.577    0.483659 -0.0437443 -0.874163    0 0
  v -76.682 73.758 118.992    0.0486103 -0.881225 -0.470191    0 0
  v -75.5971 79.6404 117.583    0.259258 0.613264 -0.746118    0 0
  v -74.1543 78.5558 117.472    0.398512 0.379898 -0.834785    0 0
  v -77.8166 80.9299 118.731    -0.075712 0.898594 -0.4322    0 0
  v -75.9169 80.7121 118.636    0.181628 0.813126 -0.553026    0 0
  v -74.527 80.9749 119.81    0.299951 0.870675 -0.389812    0 0
  v -74.0345 79.8516 118.482    0.389043 0.661606 -0.641032    0 0
  v -76.7321 81.4172 119.88    0.00328365 0.96471 -0.263293    0 0
  v -72.4893 78.4805 118.46    0.570467 0.387439 -0.724195    0 0
  v -80.3578 80.2422 119.575    -0.563739 0.81989 -0.0998933    0 0
  v -78.7549 81.0692 119.823    -0.307824 0.939588 -0.149729    0 0
  v -81.2491 79.4486 120.439    -0.770489 0.628413 0.106978    0 0
  v -80.7048 79.5087 121.896    -0.7024 0.600578 0.382022    0 0
  v -79.8274 80.5782 120.905    -0.520762 0.843443 0.131952    0 0
  v -77.8132 81.3862 121.184    -0.238176 0.967964 0.0794841    0 0
  v -80.5354 75.0177 121.835    -0.706271 -0.621921 0.338224    0 0
  v -80.4534 76.3031 123.239    -0.741921 -0.295322 0.601945    0 0
  v -81.0191 78.0052 122.722    -0.811469 0.174052 0.557874    0 0
  v -77.8925 73.3186 120.403    -0.193415 -0.970555 -0.143574    0 0
  v -78.7675 73.7173 121.971    -0.431872 -0.869237 0.240653    0 0
  v -77.1278 73.7371 123.576    -0.247323 -0.820051 0.516089    0 0
  v -79.0852 74.7567 123.49    -0.535328 -0.625252 0.567876    0 0
  v -76.4624 73.0704 122.069    -0.0827464 -0.989856 0.115492    0 0
  v -79.5654 77.7217 124.37    -0.627329 0.0977838 0.772591    0 0
  v -78.6751 76.1116 124.74    -0.489794 -0.318097 0.811737    0 0
  v -74.1219 74.2161 119.153    0.302896 -0.792182 -0.529813    0 0
  v -75.3019 73.2843 120.523    0.137768 -0.955721 -0.260034    0 0
  v -71.6127 76.8296 118.789    0.661359 -0.108649 -0.742159    0 0
  v -71.7895 75.2207 119.616    0.564954 -0.603863 -0.562296    0 0
  v -70.723 75.1152 121.415    0.706685 -0.683103 -0.184298    0 0
  v -72.7203 73.961 120.829    0.411033 -0.867548 -0.280022    0 0
  v -70.2302 76.5547 120.467    0.852716 -0.189099 -0.486947    0 0
  v -73.9469 73.3385 122.246    0.252711 -0.964765 0.0732498    0 0
  v -72.4386 79.8495 119.792    0.534051 0.69303 -0.48425    0 0
  v -70.8796 78.2647 119.961    0.746246 0.374855 -0.550092    0 0
  v -75.4235 81.581 121.339    0.095984 0.993845 -0.0553198    0 0
  v -73.0274 80.8943 121.385    0.417717 0.889181 -0.186732    0 0
  v -71.8622 80.3244 123.039    0.561126 0.809441 0.17304    0 0
  v -71.0499 79.5519 121.462    0.692586 0.683052 -0.231873    0 0
  v -74.0124 81.2704 122.998    0.205078 0.956649 0.206798    0 0
  v -69.8891 77.9096 121.732    0.94313 0.295856 -0.151576    0 0
  v -78.852 80.6511 122.473    -0.442462 0.816434 0.371029    0 0
  v -76.4929 81.3273 122.834    -0.152944 0.939433 0.306714    0 0
  v -79.5435 79.3471 123.584    -0.588177 0.531672 0.609403    0 0
  v -77.8412 78.9059 125.058    -0.384438 0.390439 0.83652    0 0
  v -77.4148 80.3476 124.124    -0.323448 0.726376 0.606431    0 0
  v -75.043 80.723 124.369    -0.0140545 0.798784 0.601453    0 0
  v -77.0981 74.9284 124.809    -0.268648 -0.559896 0.783801    0 0
  v -76.4031 76.1555 125.627    -0.209269 -0.3106 0.927219    0 0
  v -77.4947 77.3736 125.537    -0.336865 -0.00623643 0.941532    0 0
  v -74.937 73.5361 123.635    0.0761322 -0.888074 0.453352    0 0
  v -75.2699 74.4175 124.771    -0.0393385 -0.680369 0.731813    0 0
  v -74.9529 75.4984 125.543    -0.0384595 -0.46348 0.885273    0 0
  v -73.6763 74.5472 124.743    0.199969 -0.695901 0.689735    0 0
  v -75.3532 77.0464 125.988    -0.0824462 -0.0887894 0.992632    0 0
  v -71.8529 74.268 122.615    0.511036 -0.845566 0.154469    0 0
  v -72.9761 74.1266 123.811    0.342599 -0.831094 0.438073    0 0
  v -69.8016 76.4051 122.319    0.957542 -0.280069 0.0683771    0 0
  v -70.6239 75.4229 123.209    0.714031 -0.628496 0.308466    0 0
  v -71.6846 75.0803 124.174    0.513683 -0.678983 0.524512    0 0
  v -70.3572 76.4088 123.897    0.791314 -0.289999 0.538259    0 0
  v -70.481 78.8772 123.139    0.815037 0.519975 0.25562    0 0
  v -70.026 77.4394 123.439    0.914707 0.117116 0.386775    0 0
  v -72.9249 80.2963 124.404    0.338699 0.741266 0.57949    0 0
  v -71.4696 79.2069 124.392    0.6144 0.538486 0.576669    0 0
  v -70.8365 77.9548 124.504    0.727658 0.241693 0.641949    0 0
  v -72.3782 78.9407 125.247    0.397989 0.413481 0.818925    0 0
  v -75.7262 79.5376 125.333    -0.119511 0.510017 0.851822    0 0
  v -73.7634 79.4978 125.351    0.141238 0.523178 0.840438    0 0
  v -75.8053 78.172 125.858    -0.138897 0.205881 0.968669    0 0
  v -74.1047 78.3729 125.873    0.0689314 0.266078 0.961484    0 0
  v -119.787 100.098 46.1522    0.510245 0.707414 0.489096    0 0
  v -120.692 101.539 44.7367    0.444149 0.778113 0.444153    0 0
  v -122.86 101.877 46.1521    0.364607 0.815887 0.448765    0 0
  v -117.15 97.7567 46.1527    0.621962 0.566207 0.5409    0 0
  v -117.643 99.376 44.7372    0.572182 0.659785 0.487126    0 0
  v -116.307 100.061 41.5889    0.609865 0.720998 0.328979    0 0
  v -118.473 100.927 43.2307    0.529179 0.755485 0.38628    0 0
  v -115.56 98.4447 43.232    0.652207 0.628223 0.424218    0 0
  v -121.91 102.869 43.2306    0.374594 0.856916 0.354083    0 0
  v -119.646 102.382 41.5883    0.466368 0.831161 0.302774    0 0
  v -115.168 95.0075 46.1586    0.703252 0.390382 0.59417    0 0
  v -115.189 96.7707 44.7389    0.671935 0.506221 0.540595    0 0
  v -113.961 91.9205 46.2011    0.760958 0.197637 0.617966    0 0
  v -113.505 93.8313 44.7698    0.748603 0.31467 0.583589    0 0
  v -111.807 94.3476 41.6031    0.842111 0.381573 0.381118    0 0
  v -113.381 95.639 43.2406    0.756685 0.45714 0.467387    0 0
  v -112.062 92.5777 43.292    0.832835 0.236166 0.500612    0 0
  v -113.642 97.3265 41.5915    0.734086 0.578447 0.355691    0 0
  v -113.651 88.5652 46.345    0.790942 0.000545902 0.611891    0 0
  v -112.712 90.5645 44.8846    0.794751 0.127661 0.593358    0 0
  v -114.304 85.1072 46.6405    0.778026 -0.196289 0.59678    0 0
  v -113.17 86.7463 45.7048    0.744943 -0.0599178 0.664432    0 0
  v -111.779 86.022 44.9715    0.314388 0.238189 0.918927    0 0
  v -111.896 87.7284 44.5    0.643968 0.242208 0.7257    0 0
  v -112.985 84.8575 45.4666    0.406318 -0.10282 0.907928    0 0
  v -110.374 88.779 41.7899    0.840637 0.404239 0.360445    0 0
  v -111.512 89.535 43.3654    0.818103 0.206282 0.5368    0 0
  v -110.572 87.8244 43.1994    0.587576 0.5943 0.549147    0 0
  v -110.893 91.2042 41.6364    0.899361 0.180759 0.398091    0 0
  v -115.347 81.8266 46.3435    0.714312 -0.386836 0.583194    0 0
  v -114.05 83.273 45.7059    0.692835 -0.309397 0.651347    0 0
  v -117.2 79.0597 46.1986    0.623508 -0.565645 0.539707    0 0
  v -115.392 79.9633 44.8805    0.662629 -0.521712 0.537345    0 0
  v -113.986 79.0774 41.6302    0.701069 -0.620658 0.351121    0 0
  v -113.814 80.4892 43.3671    0.619605 -0.616359 0.485995    0 0
  v -115.716 78.2331 43.2857    0.645726 -0.628903 0.433034    0 0
  v -112.218 81.5081 43.2565    0.313614 -0.812298 0.491749    0 0
  v -113.366 81.9966 44.5157    0.469917 -0.547289 0.69257    0 0
  v -112.443 80.7408 41.8127    0.539729 -0.789654 0.291786    0 0
  v -112.455 83.423 44.9944    0.208836 -0.364413 0.907519    0 0
  v -119.792 76.7244 46.1568    0.510152 -0.707431 0.489169    0 0
  v -117.684 77.4292 44.7655    0.570772 -0.659893 0.488631    0 0
  v -122.86 74.9462 46.1521    0.364606 -0.815885 0.448769    0 0
  v -120.692 75.2844 44.7367    0.443783 -0.778363 0.444081    0 0
  v -119.646 74.4411 41.5883    0.46452 -0.832284 0.30253    0 0
  v -118.489 75.8811 43.2361    0.525129 -0.757704 0.387458    0 0
  v -121.91 73.9534 43.2306    0.374594 -0.856916 0.354083    0 0
  v -116.376 76.6778 41.5967    0.60112 -0.728903 0.327651    0 0
  v -124.88 74.8825 47.5221    0.282281 -0.856472 0.432172    0 0
  v -126.154 73.8754 46.1521    0.187736 -0.888504 0.418708    0 0
  v -124.109 73.7743 44.7367    0.278386 -0.868704 0.4097    0 0
  v -129.55 73.5219 46.1521    0 -0.912789 0.408431    0 0
  v -127.715 73.0206 44.7367    0.0943061 -0.915961 0.390027    0 0
  v -127.98 74.2166 47.5221    0.0953876 -0.906668 0.41092    0 0
  v -127.484 71.9645 41.5883    0.0974677 -0.959165 0.265522    0 0
  v -125.655 72.7647 43.2306    0.19121 -0.924428 0.329957    0 0
  v -129.55 72.3666 43.2306    9.32779e-008 -0.946778 0.321886    0 0
  v -123.437 72.7957 41.5883    0.288334 -0.916044 0.278797    0 0
  v -117.43 101.6 39.7646    0.55342 0.796965 0.24202    0 0
  v -118.905 103.003 37.7966    0.480642 0.861091 0.16585    0 0
  v -121.154 103.68 39.7645    0.386349 0.894949 0.223161    0 0
  v -114.304 98.9548 39.7659    0.694447 0.67216 0.256797    0 0
  v -115.365 100.541 37.7971    0.639104 0.748726 0.175941    0 0
  v -114.943 100.749 33.5792    0.656037 0.754255 0.0267219    0 0
  v -116.8 102.017 35.7224    0.569824 0.815484 0.101416    0 0
  v -113.554 99.2223 35.7231    0.72556 0.680664 0.101284    0 0
  v -120.696 104.19 35.7223    0.392902 0.914708 0.0945336    0 0
  v -118.571 103.292 33.579    0.487461 0.872707 0.0276444    0 0
  v -111.98 95.9784 39.7684    0.824849 0.498826 0.266076    0 0
  v -112.564 97.6121 37.7989    0.782685 0.596502 0.177734    0 0
  v -110.547 92.7329 39.765    0.924798 0.262954 0.274961    0 0
  v -110.642 94.3344 37.793    0.906653 0.382424 0.178137    0 0
  v -110.147 94.1955 33.5769    0.926804 0.375258 0.0146803    0 0
  v -111.159 96.0111 35.7228    0.864788 0.493007 0.0953159    0 0
  v -109.687 92.4361 35.7074    0.961786 0.254514 0.100943    0 0
  v -112.09 97.6659 33.5798    0.807666 0.589334 0.0189833    0 0
  v -109.962 89.5076 39.8593    0.94816 0.202391 0.245011    0 0
  v -109.655 90.6972 37.7602    0.969779 0.152572 0.190395    0 0
  v -109.454 87.7336 40.5448    0.810741 0.585336 -0.00901794    0 0
  v -109.391 87.5687 38.7885    0.982194 0.187776 -0.00597533    0 0
  v -109.584 84.4643 37.6689    0.936966 -0.242938 -0.251151    0 0
  v -109.353 86.4628 36.9158    0.997356 -0.0712143 0.0144654    0 0
  v -109.101 85.7436 38.5906    0.860859 0.143823 -0.488096    0 0
  v -109.118 86.5125 33.3757    0.993389 -0.11398 0.013649    0 0
  v -109.164 88.5478 35.5845    0.995884 0.0126131 0.0897608    0 0
  v -109.566 84.5596 35.14    0.967003 -0.249256 0.0527015    0 0
  v -109.159 90.4312 33.5624    0.991299 0.129869 0.0214461    0 0
  v -109.803 83.0593 38.6134    0.710505 -0.538173 -0.453379    0 0
  v -110.938 81.5811 38.8041    0.769755 -0.637431 -0.0340546    0 0
  v -110.325 82.6894 36.9169    0.907146 -0.420812 0.00166747    0 0
  v -112.357 80.1658 39.8611    0.722112 -0.662299 0.199786    0 0
  v -111.127 81.332 40.6018    0.500601 -0.86528 -0.0262685    0 0
  v -114.416 77.7297 39.7587    0.692607 -0.677471 0.247648    0 0
  v -112.636 79.142 37.756    0.772929 -0.610505 0.172815    0 0
  v -112.098 79.1572 33.5611    0.808106 -0.588642 0.0215521    0 0
  v -111.158 80.8347 35.5827    0.865507 -0.494767 0.0781293    0 0
  v -113.561 77.6009 35.7043    0.727555 -0.678481 0.101623    0 0
  v -110.112 82.6725 33.3753    0.92448 -0.38109 0.0103421    0 0
  v -117.441 75.2094 39.7639    0.550299 -0.799805 0.239756    0 0
  v -115.379 76.268 37.7885    0.639821 -0.749007 0.172098    0 0
  v -121.154 73.1426 39.7645    0.386349 -0.894949 0.223161    0 0
  v -118.905 73.8204 37.7966    0.480514 -0.861164 0.165841    0 0
  v -118.571 73.5312 33.5791    0.487508 -0.872681 0.027645    0 0
  v -116.801 74.8062 35.7205    0.570327 -0.815157 0.101228    0 0
  v -120.696 72.6332 35.7223    0.392903 -0.914708 0.0945336    0 0
  v -114.945 76.0741 33.5755    0.65648 -0.753854 0.0271639    0 0
  v -125.258 71.8577 39.7645    0.195873 -0.958211 0.208484    0 0
  v -122.961 72.0756 37.7966    0.294366 -0.943325 0.153256    0 0
  v -129.55 71.4231 39.7645    8.6758e-008 -0.97904 0.203669    0 0
  v -127.32 71.1875 37.7966    0.0994512 -0.984209 0.146432    0 0
  v -127.246 70.8255 33.5791    0.100364 -0.994647 0.024568    0 0
  v -125.017 71.288 35.7223    0.198605 -0.976059 0.0886824    0 0
  v -129.55 70.8307 35.7223    -9.32929e-010 -0.996227 0.0867872    0 0
  v -122.746 71.7401 33.579    0.29706 -0.954514 0.0256416    0 0
  v -116.693 102.087 31.4043    0.574876 0.817078 -0.043599    0 0
  v -118.715 103.166 29.2297    0.485748 0.867987 -0.103185    0 0
  v -120.617 104.28 31.4043    0.394153 0.918185 -0.0397603    0 0
  v -113.429 99.2365 31.4045    0.736723 0.674264 -0.051049    0 0
  v -115.127 100.639 29.2297    0.655319 0.746875 -0.112853    0 0
  v -115.82 100.258 25.0062    0.642704 0.730404 -0.231174    0 0
  v -117.102 101.804 27.0865    0.568631 0.805559 -0.166531    0 0
  v -113.922 99.0119 27.0865    0.727894 0.66134 -0.18111    0 0
  v -120.915 103.94 27.0865    0.390563 0.90764 -0.153785    0 0
  v -119.26 102.688 25.0062    0.478245 0.851871 -0.213538    0 0
  v -111.032 95.9179 31.4044    0.873716 0.482644 -0.0606189    0 0
  v -112.306 97.5462 29.2297    0.806538 0.577867 -0.124764    0 0
  v -109.569 92.2728 31.4014    0.965699 0.251819 -0.0633376    0 0
  v -110.388 94.0579 29.2294    0.920435 0.36715 -0.134163    0 0
  v -111.249 93.8839 25.0062    0.896021 0.356354 -0.264874    0 0
  v -111.582 95.7422 27.0865    0.860259 0.470994 -0.195239    0 0
  v -110.153 92.156 27.0865    0.947503 0.245633 -0.204701    0 0
  v -113.103 97.2683 25.0062    0.788147 0.562536 -0.249755    0 0
  v -109.073 88.4387 31.3768    0.997994 0.00555077 -0.0630708    0 0
  v -109.418 90.3265 29.228    0.982454 0.12602 -0.137485    0 0
  v -109.545 84.5847 31.2879    0.965348 -0.250092 -0.0745521    0 0
  v -109.414 86.5085 29.2093    0.98218 -0.123183 -0.141943    0 0
  v -110.31 86.5608 25.0062    0.954175 -0.121587 -0.273437    0 0
  v -109.674 88.4115 27.0865    0.978081 -8.76714e-007 -0.208226    0 0
  v -110.153 84.6669 27.0865    0.947109 -0.245533 -0.206636    0 0
  v -110.31 90.2621 25.0062    0.954175 0.121587 -0.273437    0 0
  v -111.032 80.9096 31.3764    0.872344 -0.485159 -0.0603054    0 0
  v -110.385 82.7696 29.2093    0.919433 -0.368313 -0.137796    0 0
  v -113.43 77.5865 31.4007    0.736993 -0.674009 -0.0505368    0 0
  v -112.307 79.2767 29.2279    0.806494 -0.578012 -0.124373    0 0
  v -113.103 79.5546 25.0062    0.788147 -0.562535 -0.249756    0 0
  v -111.582 81.0807 27.0865    0.860233 -0.47098 -0.195391    0 0
  v -113.922 77.811 27.0865    0.727898 -0.661344 -0.181076    0 0
  v -111.249 82.939 25.0062    0.896021 -0.356354 -0.264874    0 0
  v -116.693 74.7357 31.404    0.574934 -0.81704 -0.043558    0 0
  v -115.128 76.1838 29.2293    0.655348 -0.746857 -0.112794    0 0
  v -120.617 72.5432 31.4043    0.394153 -0.918184 -0.0397603    0 0
  v -118.715 73.6572 29.2297    0.48575 -0.867986 -0.103185    0 0
  v -119.26 74.1345 25.0062    0.478245 -0.85187 -0.213538    0 0
  v -117.102 75.0188 27.0865    0.568632 -0.805559 -0.166529    0 0
  v -120.915 72.8832 27.0865    0.390563 -0.90764 -0.153784    0 0
  v -115.82 76.5645 25.0062    0.642704 -0.730404 -0.231174    0 0
  v -124.976 71.1874 31.4043    0.199144 -0.979258 -0.0373617    0 0
  v -122.839 71.8863 29.2297    0.296066 -0.950356 -0.0957486    0 0
  v -129.55 70.726 31.4043    -1.67922e-008 -0.99933 -0.0365875    0 0
  v -127.278 70.9833 29.2297    0.100018 -0.990745 -0.0917637    0 0
  v -127.399 71.5805 25.0062    0.0987917 -0.976699 -0.190522    0 0
  v -125.132 71.5676 27.0865    0.197597 -0.969551 -0.144659    0 0
  v -129.55 71.1214 27.0865    -1.23126e-007 -0.989909 -0.141702    0 0
  v -123.19 72.44 25.0062    0.292599 -0.935384 -0.198602    0 0
  v -117.913 101.245 23.0204    0.554049 0.782382 -0.284445    0 0
  v -120.13 101.927 21.1642    0.460269 0.815407 -0.351091    0 0
  v -121.504 103.266 23.0204    0.382939 0.885292 -0.263849    0 0
  v -114.895 98.5881 23.0204    0.705169 0.639073 -0.307121    0 0
  v -116.926 99.6528 21.1642    0.612944 0.694219 -0.377305    0 0
  v -118.536 98.7704 17.9815    0.531325 0.598337 -0.599738    0 0
  v -119.124 100.412 19.4729    0.51394 0.721805 -0.463533    0 0
  v -116.348 97.9554 19.4729    0.645342 0.582413 -0.494296    0 0
  v -122.384 102.261 19.4729    0.360295 0.825419 -0.434593    0 0
  v -121.398 100.817 17.9815    0.407407 0.714952 -0.56821    0 0
  v -112.662 95.459 23.0204    0.8289 0.45288 -0.328367    0 0
  v -114.373 96.8334 21.1642    0.745251 0.530211 -0.404324    0 0
  v -111.292 92.0148 23.0204    0.909351 0.2353 -0.343096    0 0
  v -112.62 93.6228 21.1642    0.840991 0.333636 -0.425935    0 0
  v -114.619 93.2405 17.9806    0.703597 0.277375 -0.654228    0 0
  v -114.275 95.036 19.4728    0.749108 0.407673 -0.52215    0 0
  v -112.995 91.8015 19.472    0.814338 0.209425 -0.541289    0 0
  v -116.223 96.1996 17.9815    0.633571 0.448266 -0.63059    0 0
  v -110.833 88.4115 23.0204    0.937472 -4.63183e-007 -0.348059    0 0
  v -111.729 90.1742 21.1638    0.891609 0.11362 -0.438319    0 0
  v -111.292 84.8081 23.0204    0.91042 -0.235576 -0.340057    0 0
  v -111.717 86.6449 21.1703    0.895496 -0.110811 -0.431054    0 0
  v -113.684 86.7482 18.0421    0.753849 -0.0762904 -0.652603    0 0
  v -112.556 88.4036 19.477    0.83819 0.00750186 -0.545327    0 0
  v -112.924 85.0093 19.5107    0.826355 -0.213202 -0.521231    0 0
  v -113.804 90.0365 17.977    0.738447 0.0955642 -0.667505    0 0
  v -112.662 81.364 23.0204    0.828996 -0.452932 -0.328051    0 0
  v -112.609 83.199 21.1703    0.842957 -0.337533 -0.418922    0 0
  v -114.895 78.2348 23.0204    0.70515 -0.639055 -0.3072    0 0
  v -114.373 79.9904 21.1638    0.744854 -0.530396 -0.404812    0 0
  v -116.228 80.6314 17.977    0.631626 -0.449816 -0.631438    0 0
  v -114.265 81.7892 19.477    0.747133 -0.414853 -0.519316    0 0
  v -116.349 78.8691 19.472    0.64539 -0.581834 -0.494914    0 0
  v -114.503 83.571 18.0421    0.709335 -0.300317 -0.637694    0 0
  v -117.913 75.5774 23.0204    0.554048 -0.782379 -0.284453    0 0
  v -116.926 77.1703 21.1642    0.612965 -0.694127 -0.377441    0 0
  v -121.504 73.5569 23.0204    0.382939 -0.885292 -0.26385    0 0
  v -120.13 74.8961 21.1642    0.460276 -0.815402 -0.351092    0 0
  v -121.398 76.0056 17.9815    0.407464 -0.714911 -0.568222    0 0
  v -119.124 76.4115 19.4728    0.514018 -0.721695 -0.463618    0 0
  v -122.384 74.5624 19.4729    0.360295 -0.825419 -0.434593    0 0
  v -118.537 78.0541 17.9806    0.531542 -0.597729 -0.600152    0 0
  v -125.442 72.3208 23.0204    0.194296 -0.948871 -0.248783    0 0
  v -123.75 73.3234 21.1642    0.283908 -0.900888 -0.328324    0 0
  v -129.55 71.9047 23.0204    -2.26697e-007 -0.969809 -0.243867    0 0
  v -127.592 72.5335 21.1642    0.0958236 -0.943994 -0.315743    0 0
  v -127.873 73.922 17.9815    0.0866695 -0.848314 -0.522352    0 0
  v -125.905 73.4452 19.4729    0.184202 -0.892111 -0.412562    0 0
  v -129.55 73.0739 19.4729    8.42257e-007 -0.914206 -0.405251    0 0
  v -124.565 74.6105 17.9815    0.256217 -0.802257 -0.539199    0 0
  v -120.846 99.2254 16.7254    0.416278 0.579025 -0.70103    0 0
  v -123.127 99.312 15.6751    0.316509 0.541968 -0.778519    0 0
  v -123.636 100.83 16.7254    0.301094 0.678367 -0.670194    0 0
  v -118.415 97.0555 16.7254    0.509562 0.456582 -0.7293    0 0
  v -120.733 97.5698 15.6738    0.396868 0.443723 -0.803496    0 0
  v -123.339 96.169 14.0614    0.282234 0.316889 -0.905497    0 0
  v -123.053 97.7313 14.7938    0.305036 0.414855 -0.857233    0 0
  v -121.016 95.9261 14.8019    0.364023 0.326511 -0.872283    0 0
  v -125.205 99.072 14.8144    0.238634 0.500587 -0.832146    0 0
  v -125.185 97.5896 14.0746    0.241374 0.382262 -0.891972    0 0
  v -116.569 94.4336 16.7249    0.578731 0.31259 -0.753231    0 0
  v -118.736 95.3392 15.6761    0.463822 0.326123 -0.823719    0 0
  v -115.421 91.4916 16.7208    0.620087 0.157316 -0.768599    0 0
  v -117.332 92.7317 15.6743    0.508071 0.200249 -0.837714    0 0
  v -120.432 92.2016 14.0895    0.355534 0.147263 -0.922989    0 0
  v -119.433 93.6937 14.8068    0.408868 0.223507 -0.8848    0 0
  v -118.442 91.2258 14.8026    0.43665 0.117406 -0.891938    0 0
  v -121.629 94.3494 14.0852    0.32846 0.232758 -0.915389    0 0
  v -114.986 88.372 16.7461    0.649859 0.0177801 -0.759846    0 0
  v -116.622 89.8989 15.6645    0.528927 0.0937439 -0.843474    0 0
  v -115.066 85.2707 16.9143    0.670668 -0.1725 -0.721421    0 0
  v -116.005 86.782 15.8994    0.675464 -0.014818 -0.737244    0 0
  v -117.134 86.3765 14.5402    0.905251 0.171922 -0.388539    0 0
  v -117.249 87.5936 14.8796    0.640296 0.2576 -0.723645    0 0
  v -116.753 85.4517 15.2962    0.785417 -0.202797 -0.584803    0 0
  v -119.639 88.4112 13.8045    0.332215 0.487978 -0.807162    0 0
  v -118.149 88.8976 14.687    0.462077 0.193829 -0.865399    0 0
  v -118.472 87.7225 13.8703    0.505756 0.676555 -0.535243    0 0
  v -119.83 90.0013 14.0829    0.365759 0.0975584 -0.925582    0 0
  v -116.521 82.4007 16.7461    0.586874 -0.337328 -0.736063    0 0
  v -116.702 84.0737 15.9004    0.621226 -0.318045 -0.716189    0 0
  v -118.419 79.7756 16.7208    0.510535 -0.455761 -0.729134    0 0
  v -118.777 81.4536 15.6639    0.45633 -0.353591 -0.816539    0 0
  v -121.821 82.1652 14.0769    0.308451 -0.283797 -0.907919    0 0
  v -119.742 82.6661 14.689    0.368471 -0.41899 -0.829866    0 0
  v -121.079 80.8025 14.7966    0.363982 -0.336423 -0.868526    0 0
  v -119.516 83.6886 13.8965    0.270397 -0.854378 -0.443762    0 0
  v -118.283 83.5813 14.8874    0.505114 -0.54566 -0.668667    0 0
  v -120.927 83.3966 13.816    0.166131 -0.643771 -0.746966    0 0
  v -117.588 84.6271 14.5507    0.744971 -0.574783 -0.338591    0 0
  v -120.846 77.5984 16.7249    0.416633 -0.578835 -0.700976    0 0
  v -120.742 79.2471 15.6713    0.397713 -0.446154 -0.80173    0 0
  v -123.636 75.9927 16.7254    0.301094 -0.678367 -0.670194    0 0
  v -123.127 77.511 15.6751    0.316362 -0.542101 -0.778486    0 0
  v -125.185 79.2334 14.0746    0.240253 -0.383479 -0.891752    0 0
  v -123.059 79.0822 14.7932    0.303308 -0.418433 -0.856106    0 0
  v -125.205 77.7509 14.8144    0.238636 -0.500586 -0.832146    0 0
  v -123.377 80.5923 14.0597    0.277263 -0.325744 -0.903889    0 0
  v -126.564 75.0446 16.7254    0.157044 -0.748645 -0.644103    0 0
  v -125.668 76.3421 15.682    0.209078 -0.630533 -0.747472    0 0
  v -129.55 74.7372 16.7254    9.342e-010 -0.771297 -0.636475    0 0
  v -128.249 75.7873 15.6837    0.0695045 -0.679755 -0.730139    0 0
  v -128.642 77.7771 14.1605    0.0488435 -0.52487 -0.84978    0 0
  v -127.357 76.9589 14.838    0.127639 -0.581314 -0.803606    0 0
  v -129.55 76.7488 14.8315    -4.6642e-010 -0.599596 -0.800303    0 0
  v -126.896 78.2082 14.1433    0.177994 -0.467601 -0.865834    0 0
  v -125.58 96.0956 13.428    0.220507 0.289776 -0.931347    0 0
  v -127.393 95.9959 13.0141    0.168047 0.261989 -0.950327    0 0
  v -126.904 97.2726 13.5311    0.1954 0.352923 -0.915021    0 0
  v -123.858 94.7018 13.469    0.258849 0.234722 -0.936965    0 0
  v -125.977 94.6554 12.9571    0.191013 0.206154 -0.959695    0 0
  v -127.559 92.7012 12.4499    0.102099 0.084043 -0.991218    0 0
  v -127.773 94.0055 12.5668    0.117207 0.133907 -0.984038    0 0
  v -126.193 93.3722 12.6909    0.161199 0.128818 -0.978479    0 0
  v -129.55 94.2264 12.4454    3.68483e-006 0.145388 -0.989375    0 0
  v -128.429 94.9743 12.6404    0.0931432 0.177687 -0.979669    0 0
  v -129.061 93.153 12.3487    0.0555759 0.0746758 -0.995658    0 0
  v -128.656 96.1221 12.8765    0.0817998 0.259244 -0.962342    0 0
  v -129.55 95.4646 12.681    9.32481e-010 0.213703 -0.976899    0 0
  v -122.493 92.8939 13.4953    0.28713 0.157249 -0.944896    0 0
  v -124.512 93.2946 13.019    0.223792 0.148195 -0.963304    0 0
  v -121.665 90.8526 13.4941    0.304122 0.0825231 -0.949052    0 0
  v -123.513 91.5162 13.0328    0.238903 0.0976047 -0.966126    0 0
  v -126.057 90.4489 12.481    0.130585 0.046349 -0.990353    0 0
  v -125.366 91.8401 12.6801    0.169941 0.085487 -0.981739    0 0
  v -124.499 90.2936 12.7193    0.192045 0.0492326 -0.98015    0 0
  v -126.866 91.9907 12.4713    0.115244 0.0702891 -0.990847    0 0
  v -121.29 88.9327 13.4478    0.268131 0.195184 -0.943403    0 0
  v -123.043 89.5801 13.0248    0.246134 0.0534792 -0.967759    0 0
  v -120.655 87.885 13.078    0.0497212 0.720176 -0.692008    0 0
  v -122.164 87.889 12.9897    0.07475 0.303664 -0.949843    0 0
  v -123.325 86.2529 12.7565    -0.0883175 0.0188642 -0.995914    0 0
  v -123.732 87.3904 12.7754    0.10608 0.052126 -0.99299    0 0
  v -122.324 86.9011 12.6619    -0.284119 0.34246 -0.895543    0 0
  v -126.019 87.5145 12.4251    0.124749 -0.00532671 -0.992174    0 0
  v -124.642 88.469 12.6533    0.170015 0.0126142 -0.985361    0 0
  v -125.026 86.6061 12.5926    0.143242 -0.0365662 -0.989012    0 0
  v -125.798 89.367 12.4784    0.136233 0.0243842 -0.990377    0 0
  v -122.723 85.3517 12.6724    -0.375476 -0.206092 -0.903628    0 0
  v -123.034 84.4767 12.9975    -0.0233294 -0.348203 -0.937129    0 0
  v -124.231 85.4102 12.7764    0.0759889 -0.104887 -0.991577    0 0
  v -122.7 83.3985 13.4474    0.188698 -0.33208 -0.924184    0 0
  v -121.645 84.0512 13.1042    -0.164509 -0.750489 -0.64008    0 0
  v -123.94 82.0022 13.4644    0.252638 -0.239605 -0.937424    0 0
  v -124.613 83.421 13.0089    0.207664 -0.1726 -0.962852    0 0
  v -126.897 84.8074 12.4673    0.111651 -0.0737969 -0.991004    0 0
  v -125.523 84.9377 12.6499    0.147062 -0.089778 -0.985044    0 0
  v -126.224 83.4259 12.6868    0.159321 -0.129393 -0.97871    0 0
  v -126.298 86.3888 12.4251    0.110279 -0.0536175 -0.992453    0 0
  v -125.588 80.7155 13.4276    0.217773 -0.292696 -0.931077    0 0
  v -125.998 82.1458 12.955    0.188404 -0.207112 -0.960005    0 0
  v -126.904 79.5503 13.5311    0.1954 -0.352923 -0.915021    0 0
  v -127.393 80.8271 13.0141    0.167887 -0.262279 -0.950276    0 0
  v -129.55 81.3583 12.681    9.32481e-010 -0.213703 -0.976899    0 0
  v -128.429 81.8486 12.6404    0.0929718 -0.177705 -0.979682    0 0
  v -128.656 80.7008 12.8765    0.081801 -0.259239 -0.962343    0 0
  v -129.061 83.67 12.3487    0.0554224 -0.0747321 -0.995662    0 0
  v -127.776 82.8149 12.5663    0.116426 -0.134304 -0.984077    0 0
  v -129.55 82.5966 12.4454    -3.6811e-006 -0.145383 -0.989375    0 0
  v -127.569 84.1133 12.4485    0.100849 -0.0845836 -0.9913    0 0
  v -128.117 78.7637 13.6493    0.105422 -0.438087 -0.892729    0 0
  v -128.124 79.7618 13.2249    0.126867 -0.342949 -0.930748    0 0
  v -129.55 78.7093 13.6169    0 -0.455591 -0.890189    0 0
  v -128.897 79.4877 13.2609    0.0460703 -0.384169 -0.922113    0 0
  v -129.55 80.2503 12.9706    4.6615e-010 -0.307725 -0.951475    0 0
  v -97.3712 82.3343 36.2378    0.94947 -0.270231 -0.159633    0 0
  v -97.8216 82.2053 35.5245    0.609296 -0.452535 -0.651131    0 0
  v -97.8487 83.0029 35.276    0.654435 0.064854 -0.753332    0 0
  v -97.3882 83.0171 36.0258    0.957364 0.177203 -0.22815    0 0
  v -98.8329 81.5927 35.6316    0.140395 -0.838754 -0.5261    0 0
  v -98.6985 82.1856 35.082    0.235846 -0.495556 -0.835943    0 0
  v -98.0948 81.6103 36.0291    0.418293 -0.837426 -0.351779    0 0
  v -99.6142 82.9611 34.7416    -0.0812756 -0.0813837 -0.993363    0 0
  v -98.7255 82.9831 34.8335    0.2753 -0.0278025 -0.960956    0 0
  v -99.5972 82.2783 34.9536    -0.0969102 -0.477641 -0.873194    0 0
  v -98.1262 83.7089 35.38    0.532196 0.591373 -0.605842    0 0
  v -98.8643 83.6914 34.9826    0.24107 0.519744 -0.819604    0 0
  v -111.43 82.4947 44.2373    0.132388 -0.670868 0.729664    0 0
  v -110.224 83.519 44.8362    0.0354845 -0.397029 0.91712    0 0
  v -111.199 84.6201 45.1129    0.0843622 -0.00199936 0.996433    0 0
  v -110.874 81.459 42.1159    0.23873 -0.960142 0.145382    0 0
  v -110.147 81.9551 43.3131    0.0939903 -0.889153 0.447854    0 0
  v -107.785 82.0778 43.2971    0.0350281 -0.907516 0.418554    0 0
  v -109.027 82.6694 44.2071    0.0367319 -0.704423 0.70883    0 0
  v -108.805 81.7707 42.2966    0.0698897 -0.995474 0.0643946    0 0
  v -108.756 84.4531 44.9941    0.0682213 0.0382078 0.996938    0 0
  v -107.638 83.4685 44.7041    0.0859062 -0.405058 0.910246    0 0
  v -109.784 82.2516 39.8215    0.428641 -0.801514 -0.416944    0 0
  v -109.464 81.8459 41.1013    0.196256 -0.947983 -0.250624    0 0
  v -108.816 84.3067 38.7523    0.503303 -0.146459 -0.851608    0 0
  v -108.524 83.2534 39.3323    0.236335 -0.558091 -0.795412    0 0
  v -106.9 83.2412 39.4415    -0.0877562 -0.529205 -0.843944    0 0
  v -108.11 82.4877 40.1968    0.0754188 -0.809792 -0.581849    0 0
  v -107.412 84.1865 39.1123    0.0497898 -0.0680342 -0.99644    0 0
  v -107.49 81.9869 41.1921    -0.0107414 -0.949845 -0.312537    0 0
  v -108.659 86.4915 39.7343    0.625272 0.594292 -0.505818    0 0
  v -107.984 85.2715 39.2563    0.298132 0.381591 -0.874932    0 0
  v -109.265 87.5288 41.9881    0.492525 0.857784 0.147053    0 0
  v -108.123 86.8601 40.9114    0.351831 0.874676 -0.333402    0 0
  v -106.343 86.4522 40.8436    0.097039 0.910629 -0.401669    0 0
  v -107.18 85.9881 39.9942    0.150842 0.720412 -0.676945    0 0
  v -107.441 86.9047 41.9995    0.215688 0.976447 0.00539759    0 0
  v -106.441 85.0273 39.3021    -0.0407075 0.434611 -0.899698    0 0
  v -110.321 86.6835 44.1501    0.302029 0.594277 0.745395    0 0
  v -108.808 86.9608 43.1231    0.272985 0.857679 0.435735    0 0
  v -109.687 85.5285 44.7602    0.120116 0.41998 0.899549    0 0
  v -107.179 85.2547 44.5647    0.167519 0.465384 0.869112    0 0
  v -108.097 86.1698 44.0045    0.167416 0.721674 0.671683    0 0
  v -106.638 86.5432 42.9486    0.189895 0.910331 0.367746    0 0
  v -106.504 82.6223 43.9637    0.0968848 -0.713011 0.694427    0 0
  v -105.073 83.2983 44.1735    0.241367 -0.406401 0.881238    0 0
  v -106.138 84.2692 44.6555    0.220156 0.0381058 0.97472    0 0
  v -106.614 81.8014 42.1558    -0.0233669 -0.998734 0.0445474    0 0
  v -105.452 81.9928 42.8875    0.0551928 -0.911088 0.408501    0 0
  v -103.294 81.7993 42.0019    0.125236 -0.91157 0.391608    0 0
  v -104.101 82.4411 43.2484    0.214795 -0.712516 0.66797    0 0
  v -104.539 81.666 41.5808    -0.0683001 -0.996195 0.0541411    0 0
  v -103.65 84.0204 43.8315    0.422244 0.0331081 0.905877    0 0
  v -102.701 83.0452 43.1265    0.432253 -0.402221 0.807079    0 0
  v -106.322 82.4618 40.091    -0.151814 -0.792727 -0.59037    0 0
  v -105.553 81.9121 40.8721    -0.157328 -0.939996 -0.302746    0 0
  v -105.871 84.0339 38.9755    -0.219768 -0.0399042 -0.974736    0 0
  v -105.325 83.0967 39.135    -0.326406 -0.503685 -0.79985    0 0
  v -103.901 82.8662 38.4639    -0.533019 -0.485758 -0.69277    0 0
  v -104.653 82.2985 39.5918    -0.334413 -0.773787 -0.537979    0 0
  v -104.461 83.8112 38.4685    -0.459886 -0.0270333 -0.887567    0 0
  v -103.774 81.7277 40.1369    -0.258385 -0.931367 -0.256502    0 0
  v -105.544 85.7198 39.7783    -0.0581916 0.733007 -0.677727    0 0
  v -104.958 84.8047 38.9426    -0.25521 0.44137 -0.860268    0 0
  v -105.473 86.5798 41.6973    0.137762 0.989928 -0.0326122    0 0
  v -104.635 86.1823 40.3911    -0.0122299 0.911588 -0.410923    0 0
  v -103.087 85.8611 39.5167    -0.0610001 0.906974 -0.416747    0 0
  v -104.054 85.4567 39.1817    -0.210468 0.727091 -0.653484    0 0
  v -103.66 86.2981 40.9793    0.154918 0.986074 -0.0604763    0 0
  v -103.626 84.5196 38.2159    -0.449965 0.431632 -0.781809    0 0
  v -105.726 85.8803 43.651    0.243675 0.732239 0.635962    0 0
  v -104.534 86.2629 42.4065    0.256031 0.906661 0.335283    0 0
  v -104.706 85.0064 43.9811    0.338675 0.451991 0.825229    0 0
  v -102.427 84.6986 42.8784    0.541488 0.437195 0.718089    0 0
  v -103.502 85.5993 42.8382    0.401203 0.711728 0.57661    0 0
  v -102.607 85.9327 41.3817    0.389144 0.88323 0.261672    0 0
  v -101.948 82.1999 42.0052    0.362298 -0.711071 0.602593    0 0
  v -100.648 82.7499 41.5381    0.598168 -0.39548 0.696987    0 0
  v -101.427 83.698 42.4457    0.629892 0.0380496 0.77575    0 0
  v -102.676 81.4693 40.5457    -0.0642005 -0.99566 0.0673731    0 0
  v -101.411 81.5872 40.6336    0.206774 -0.912283 0.353532    0 0
  v -99.8206 81.4067 38.993    0.267697 -0.912521 0.309263    0 0
  v -100.118 81.9588 40.334    0.469621 -0.709985 0.524764    0 0
  v -101.069 81.2855 39.1571    -0.0379666 -0.996812 0.0701726    0 0
  v -99.554 83.3333 40.6029    0.763785 0.0596625 0.642708    0 0
  v -98.9527 82.4646 39.6351    0.707181 -0.38442 0.593395    0 0
  v -103.169 82.0741 38.7141    -0.462113 -0.766487 -0.446038    0 0
  v -102.217 81.5247 39.0111    -0.297646 -0.933173 -0.201481    0 0
  v -103.218 83.5134 37.6187    -0.653294 -0.0335801 -0.756359    0 0
  v -102.664 82.5937 37.4819    -0.646663 -0.502474 -0.573887    0 0
  v -101.58 82.3357 36.3996    -0.65023 -0.556903 -0.516778    0 0
  v -101.882 81.8513 37.5811    -0.493016 -0.787817 -0.369161    0 0
  v -102.141 83.1756 36.5652    -0.73342 -0.0708676 -0.676072    0 0
  v -100.871 81.3551 37.6987    -0.283059 -0.943647 -0.17149    0 0
  v -102.726 85.0775 38.184    -0.31635 0.720836 -0.6167    0 0
  v -102.462 84.1292 37.1643    -0.572281 0.419535 -0.704617    0 0
  v -102.025 85.8743 39.7683    0.21717 0.968786 -0.119543    0 0
  v -101.713 85.3633 38.2171    -0.0838153 0.901402 -0.424794    0 0
  v -100.553 84.8068 36.7771    -0.120623 0.894719 -0.430033    0 0
  v -101.57 84.5884 36.9286    -0.370029 0.718103 -0.589412    0 0
  v -100.612 85.3 38.2002    0.214718 0.960216 -0.178556    0 0
  v -101.452 83.7164 36.0309    -0.614069 0.397107 -0.682075    0 0
  v -101.504 85.2034 41.4751    0.564536 0.694339 0.446309    0 0
  v -100.907 85.4257 39.8395    0.469749 0.870654 0.145936    0 0
  v -100.446 84.2853 41.2204    0.68946 0.449186 0.568223    0 0
  v -98.8255 83.8453 39.2665    0.757464 0.482944 0.439332    0 0
  v -99.8062 84.6959 39.6816    0.628825 0.711603 0.313367    0 0
  v -99.5026 84.8583 38.0713    0.464161 0.884128 0.0535909    0 0
  v -98.6263 81.7636 38.4909    0.558818 -0.706585 0.434119    0 0
  v -97.7158 82.2586 37.721    0.83137 -0.380914 0.404633    0 0
  v -98.072 82.9975 38.5893    0.856496 0.0858395 0.508966    0 0
  v -99.7065 81.1591 37.6541    0.0132933 -0.99921 0.0374508    0 0
  v -98.5804 81.3364 37.3471    0.371769 -0.913451 0.165513    0 0
  v -97.7252 81.7646 36.7995    0.701434 -0.705456 0.101602    0 0
  v -98.7681 81.2902 36.3864    0.175 -0.958474 -0.225175    0 0
  v -97.3308 82.7614 36.8861    0.989075 0.0403281 0.141787    0 0
  v -100.75 81.6794 36.4248    -0.439496 -0.821981 -0.362203    0 0
  v -99.7318 81.2989 36.4518    -0.173018 -0.950221 -0.259123    0 0
  v -101.187 82.8739 35.559    -0.696468 -0.148084 -0.702142    0 0
  v -100.589 82.1643 35.4675    -0.4909 -0.61995 -0.612111    0 0
  v -99.7279 81.7093 35.5127    -0.201378 -0.803869 -0.559679    0 0
  v -100.245 82.6779 34.9298    -0.339156 -0.270187 -0.901095    0 0
  v -100.599 84.1237 35.722    -0.378714 0.69177 -0.614841    0 0
  v -100.554 83.3634 35.1072    -0.495216 0.287497 -0.819821    0 0
  v -99.4838 84.7442 36.6234    0.188124 0.953203 -0.236674    0 0
  v -99.6385 84.3002 35.5505    -0.0678193 0.830662 -0.552631    0 0
  v -99.7257 83.6579 34.9139    -0.154136 0.490365 -0.857779    0 0
  v -98.7455 84.1639 35.5057    0.304975 0.798629 -0.518827    0 0
  v -98.4745 84.208 37.7881    0.648156 0.735613 0.196894    0 0
  v -98.4872 84.3377 36.4458    0.495681 0.862894 -0.0985572    0 0
  v -97.6803 83.4577 37.3607    0.83976 0.482897 0.248222    0 0
  v -97.723 83.7131 36.2007    0.756629 0.644994 -0.107216    0 0
  v -117.063 84.4307 0.898848    0.565341 -0.373583 -0.735409    0 0
  v -117.501 84.4504 0.663963    0.275224 -0.323889 -0.905178    0 0
  v -117.407 84.8243 0.642664    0.330384 0.0714919 -0.941135    0 0
  v -116.98 84.7608 0.880056    0.629559 -0.00508951 -0.776936    0 0
  v -118.126 84.1833 0.740102    -0.0837217 -0.557795 -0.825746    0 0
  v -118.016 84.5104 0.58523    -0.0490756 -0.232562 -0.971343    0 0
  v -117.671 84.1304 0.80962    0.181231 -0.641934 -0.745034    0 0
  v -118.423 84.9282 0.659292    -0.316741 0.177856 -0.931688    0 0
  v -117.922 84.8842 0.563925    -0.00318455 0.134347 -0.990929    0 0
  v -118.507 84.5982 0.678077    -0.356595 -0.116488 -0.926968    0 0
  v -117.406 85.1786 0.749994    0.328404 0.446174 -0.832514    0 0
  v -117.861 85.2315 0.680476    0.0448304 0.47225 -0.880324    0 0
  v -118.406 84.2125 13.5787    0.472113 -0.871886 -0.130091    0 0
  v -117.534 84.791 12.9298    0.700028 -0.705395 0.111256    0 0
  v -117.212 85.4525 13.8716    0.970442 -0.241035 -0.012036    0 0
  v -120.358 83.8904 12.9434    -0.0676774 -0.969092 -0.237234    0 0
  v -119.151 84.0029 12.5153    0.185752 -0.982588 -0.00414654    0 0
  v -118.674 83.9453 10.6493    0.17269 -0.980766 0.0909751    0 0
  v -118.041 84.2913 11.8303    0.416318 -0.900665 0.124425    0 0
  v -119.795 83.9456 11.4348    -0.125054 -0.992147 -0.00254008    0 0
  v -116.952 85.3409 12.016    0.954388 -0.223 0.198532    0 0
  v -117.126 84.6893 10.9239    0.684715 -0.709104 0.168335    0 0
  v -121.858 84.6871 12.4514    -0.537167 -0.612865 -0.579524    0 0
  v -120.857 84.2138 12.0453    -0.418914 -0.882392 -0.214231    0 0
  v -122.197 86.0462 12.2647    -0.676397 0.157794 -0.719436    0 0
  v -121.78 85.3001 11.7651    -0.836555 -0.28429 -0.468354    0 0
  v -121.195 85.1571 10.1495    -0.933332 -0.288699 -0.213412    0 0
  v -121.128 84.6494 11.1294    -0.722053 -0.657564 -0.215057    0 0
  v -121.48 85.8661 10.9881    -0.910454 0.212106 -0.355083    0 0
  v -120.302 84.1325 10.3395    -0.46199 -0.885273 -0.0534501    0 0
  v -121.194 87.2524 12.4122    -0.311161 0.739809 -0.596541    0 0
  v -121.452 86.5679 11.7317    -0.650626 0.593342 -0.473952    0 0
  v -119.381 87.6549 12.8858    0.196243 0.922441 -0.332553    0 0
  v -120.036 87.3794 11.9618    -0.152347 0.94401 -0.292634    0 0
  v -119.535 87.1124 10.2001    -0.196727 0.967126 -0.16114    0 0
  v -120.538 86.9309 11.0437    -0.455534 0.84704 -0.273885    0 0
  v -118.93 87.2917 11.309    0.137602 0.984132 -0.112025    0 0
  v -120.888 86.3491 10.0937    -0.729294 0.636606 -0.250726    0 0
  v -117.708 86.8978 13.5394    0.744453 0.633584 -0.210621    0 0
  v -118.325 87.1884 12.4318    0.46056 0.881979 -0.0999895    0 0
  v -117.2 86.0788 12.8964    0.932258 0.354433 0.0726087    0 0
  v -116.819 85.8812 10.8682    0.916988 0.380667 0.119269    0 0
  v -117.451 86.5727 11.7445    0.694172 0.718152 0.0488136    0 0
  v -117.907 86.9253 10.5099    0.439639 0.89793 -0.020967    0 0
  v -117.642 84.1619 9.70046    0.419467 -0.900513 0.114554    0 0
  v -116.837 84.5281 8.63072    0.6937 -0.711153 0.114203    0 0
  v -116.586 85.1698 9.82273    0.965298 -0.22468 0.133113    0 0
  v -119.35 83.8298 9.41283    -0.129681 -0.990884 0.0364969    0 0
  v -118.334 83.8137 8.41178    0.17635 -0.981192 0.0785004    0 0
  v -118.105 83.6834 6.09598    0.178459 -0.981691 0.0666009    0 0
  v -117.399 84.0144 7.36722    0.423704 -0.90129 0.0902859    0 0
  v -119.041 83.6962 7.11336    -0.129108 -0.990827 0.0399265    0 0
  v -116.386 84.9801 7.47173    0.970458 -0.22826 0.0781517    0 0
  v -116.677 84.365 6.30251    0.697175 -0.711675 0.0864038    0 0
  v -120.65 84.5058 9.19518    -0.746522 -0.658623 -0.0944492    0 0
  v -119.91 83.9934 8.16497    -0.46568 -0.884854 -0.0132668    0 0
  v -120.999 85.6742 9.08165    -0.952273 0.22312 -0.208311    0 0
  v -120.778 84.9774 8.01371    -0.948654 -0.287644 -0.131592    0 0
  v -120.439 84.794 5.72793    -0.950533 -0.287564 -0.117448    0 0
  v -120.292 84.3441 6.92541    -0.750045 -0.658575 -0.0609179    0 0
  v -120.629 85.4637 6.82375    -0.960258 0.226151 -0.163584    0 0
  v -119.61 83.855 5.86614    -0.465737 -0.884869 -0.00978565    0 0
  v -120.087 86.6961 9.08035    -0.47876 0.85868 -0.182912    0 0
  v -120.484 86.1216 7.95039    -0.742709 0.643923 -0.183705    0 0
  v -118.524 87.0422 9.24441    0.127314 0.987136 -0.0967144    0 0
  v -119.176 86.854 8.00666    -0.202985 0.969161 -0.139727    0 0
  v -118.91 86.5838 5.71234    -0.203093 0.968958 -0.140971    0 0
  v -119.754 86.4424 6.80718    -0.482544 0.861178 -0.159764    0 0
  v -118.252 86.7736 6.93995    0.126704 0.986443 -0.104286    0 0
  v -120.159 85.8856 5.66641    -0.744264 0.645155 -0.172757    0 0
  v -117.079 86.3522 9.58564    0.694384 0.719467 0.014107    0 0
  v -117.6 86.6743 8.25347    0.441092 0.895857 -0.0536386    0 0
  v -116.544 85.6723 8.5674    0.925907 0.375008 0.0454561    0 0
  v -116.397 85.4566 6.24099    0.928959 0.370045 0.0100352    0 0
  v -116.861 86.1127 7.24898    0.698443 0.715238 -0.0247509    0 0
  v -117.405 86.4122 5.94217    0.443611 0.893277 -0.072573    0 0
  v -117.241 83.8853 5.1286    0.426855 -0.901532 0.0709592    0 0
  v -116.587 84.2348 4.20634    0.700929 -0.711355 0.0516943    0 0
  v -116.282 84.8006 5.23011    0.971899 -0.230387 0.0483189    0 0
  v -118.795 83.5836 4.88555    -0.126996 -0.991589 0.0249514    0 0
  v -117.921 83.597 4.00907    0.183412 -0.98237 0.0361855    0 0
  v -117.77 83.6211 2.36295    0.19857 -0.978202 -0.06076    0 0
  v -117.142 83.8232 3.22996    0.434825 -0.900351 0.017171    0 0
  v -118.559 83.5478 3.004    -0.11774 -0.992324 -0.0378159    0 0
  v -116.269 84.6587 3.32672    0.97197 -0.2344 -0.0182153    0 0
  v -116.601 84.1813 2.54382    0.70712 -0.705434 -0.0484164    0 0
  v -119.982 84.198 4.70992    -0.748159 -0.659298 -0.0747333    0 0
  v -119.329 83.7577 3.79411    -0.460827 -0.886198 -0.0478802    0 0
  v -120.302 85.2593 4.61605    -0.958143 0.224648 -0.177469    0 0
  v -120.106 84.6365 3.66893    -0.942648 -0.290048 -0.165189    0 0
  v -119.689 84.5348 2.07211    -0.895081 -0.291535 -0.337397    0 0
  v -119.644 84.1091 2.84787    -0.734073 -0.659728 -0.160923    0 0
  v -119.937 85.0781 2.76632    -0.937922 0.214187 -0.272813    0 0
  v -119.005 83.7625 2.17427    -0.438341 -0.879984 -0.18299    0 0
  v -119.473 86.1865 4.59781    -0.481016 0.859532 -0.172711    0 0
  v -119.845 85.6574 3.61134    -0.738366 0.639285 -0.214778    0 0
  v -118.048 86.5 4.72113    0.12911 0.984252 -0.120738    0 0
  v -118.676 86.31 3.65015    -0.199104 0.964331 -0.174426    0 0
  v -118.433 86.0027 2.04772    -0.184312 0.939668 -0.28819    0 0
  v -119.18 85.9237 2.74546    -0.471608 0.847207 -0.244593    0 0
  v -117.879 86.2092 2.8538    0.136916 0.974437 -0.178117    0 0
  v -119.46 85.4309 2.02149    -0.705615 0.607185 -0.365285    0 0
  v -116.732 85.8737 5.01649    0.701678 0.71087 -0.0480817    0 0
  v -117.268 86.1493 3.86513    0.448412 0.887776 -0.103827    0 0
  v -116.326 85.2557 4.14875    0.931226 0.363379 -0.0278104    0 0
  v -116.373 85.0773 2.49321    0.930435 0.341645 -0.13255    0 0
  v -116.678 85.6378 3.12755    0.707909 0.698592 -0.104087    0 0
  v -117.198 85.8612 2.23641    0.460336 0.865544 -0.197292    0 0
  v -117.126 83.8891 1.86396    0.452303 -0.880713 -0.140595    0 0
  v -116.761 84.2424 1.46896    0.689527 -0.651866 -0.315631    0 0
  v -116.407 84.5809 1.95216    0.949447 -0.24053 -0.201732    0 0
  v -118.296 83.6611 1.66881    -0.0868863 -0.971042 -0.222548    0 0
  v -117.653 83.8115 1.32004    0.232526 -0.919878 -0.315841    0 0
  v -117.228 84.1011 1.06574    0.445174 -0.733423 -0.513723    0 0
  v -118.036 83.9284 0.965041    -0.00200953 -0.790409 -0.612576    0 0
  v -116.724 84.5731 1.16404    0.774274 -0.224762 -0.591592    0 0
  v -119.195 84.1267 1.54781    -0.661811 -0.628853 -0.408106    0 0
  v -118.593 83.9199 1.17635    -0.353002 -0.795905 -0.491859    0 0
  v -119.441 84.9294 1.48847    -0.830405 0.174318 -0.52919    0 0
  v -119.124 84.5146 1.10788    -0.70496 -0.260992 -0.659481    0 0
  v -118.638 84.2643 0.850079    -0.427069 -0.475937 -0.768827    0 0
  v -118.848 84.8186 0.839336    -0.533503 0.085263 -0.84149    0 0
  v -118.813 85.6281 1.46287    -0.430138 0.781063 -0.452682    0 0
  v -118.951 85.197 1.0692    -0.573531 0.482243 -0.662196    0 0
  v -117.735 85.863 1.54423    0.15733 0.925744 -0.343868    0 0
  v -118.158 85.6345 1.07917    -0.13779 0.81799 -0.558486    0 0
  v -118.379 85.2884 0.791907    -0.285013 0.543415 -0.7896    0 0
  v -117.645 85.4702 0.877502    0.186714 0.683628 -0.705542    0 0
  v -116.744 85.3905 1.77903    0.713872 0.648856 -0.263388    0 0
  v -117.218 85.5261 1.22286    0.472673 0.76084 -0.444637    0 0
  v -116.588 84.9247 1.43029    0.876483 0.260864 -0.404633    0 0
  v -116.968 85.1252 1.00757    0.639827 0.445523 -0.626203    0 0
  v -111.853 58.645 80.7333    0.2017 -0.968088 0.148738    0 0
  v -109.526 58.8268 77.13    0.224541 -0.973984 0.0305941    0 0
  v -107.79 59.4773 79.6659    0.303814 -0.944913 0.121805    0 0
  v -108.149 59.9857 82.7372    0.298919 -0.916418 0.266132    0 0
  v -107.234 59.8512 71.4094    0.316595 -0.930635 -0.183541    0 0
  v -107.346 59.4308 74.5852    0.306994 -0.950448 -0.0490203    0 0
  v -111.41 58.4994 73.492    0.20789 -0.975212 -0.0757881    0 0
  v -106.063 59.9837 75.0881    0.563007 -0.820478 0.0991939    0 0
  v -107.067 59.5391 77.1098    0.412022 -0.910084 0.0445573    0 0
  v -105.167 60.3555 73.1093    0.432192 -0.901617 -0.0172356    0 0
  v -105.914 60.4332 81.1684    0.436088 -0.89132 0.123999    0 0
  v -106.392 60.0318 79.1041    0.557901 -0.829582 0.023255    0 0
  v -100.984 63.1705 69.743    0.457931 -0.813237 -0.359088    0 0
  v -103.499 61.3535 71.3086    0.405533 -0.889647 -0.209933    0 0
  v -95.2244 66.51 71.617    0.671708 -0.711272 -0.207126    0 0
  v -98.0861 64.3183 71.4076    0.546307 -0.807966 -0.220769    0 0
  v -98.7401 63.8181 72.6285    0.451039 -0.881276 0.141129    0 0
  v -100.725 62.6803 71.7451    0.478786 -0.875919 -0.0594136    0 0
  v -96.6135 65.0403 73.3001    0.545956 -0.837781 -0.00737939    0 0
  v -103.003 61.4982 72.4978    0.496496 -0.851778 0.167231    0 0
  v -93.99 67.5618 77.2512    0.758655 -0.64221 0.109585    0 0
  v -94.9911 66.2874 74.7693    0.683541 -0.729891 -0.00552774    0 0
  v -96.7309 66.5624 82.8028    0.642013 -0.680222 0.353719    0 0
  v -95.7046 66.3356 79.8004    0.666945 -0.717196 0.202026    0 0
  v -96.762 65.4974 79.3244    0.423282 -0.905173 0.038663    0 0
  v -95.6197 65.9533 77.3272    0.569396 -0.817034 0.0907914    0 0
  v -97.6784 65.1559 81.2963    0.541523 -0.826033 0.156275    0 0
  v -96.2438 65.4178 75.3591    0.429409 -0.897686 0.0988355    0 0
  v -102.59 63.2303 84.5388    0.453875 -0.786734 0.418386    0 0
  v -99.5616 64.4149 83.0605    0.536069 -0.776942 0.330138    0 0
  v -104.704 61.4485 83.0109    0.408451 -0.864495 0.292943    0 0
  v -103.895 61.6315 81.8348    0.522932 -0.852049 -0.0235511    0 0
  v -101.961 62.8121 82.6919    0.490397 -0.854861 0.16948    0 0
  v -99.8226 63.9829 81.9147    0.472437 -0.880799 -0.0315582    0 0
  v -104.822 68.1139 78.072    0.818085 -0.532596 -0.216973    0 0
  v -103.631 69.6096 76.753    0.666997 -0.741272 0.0750406    0 0
  v -102.212 70.5194 78.3169    0.476871 -0.847 -0.234913    0 0
  v -103.621 68.8841 79.3959    0.648705 -0.584357 -0.487554    0 0
  v -103.153 68.7862 74.2176    0.567881 -0.53901 0.622077    0 0
  v -101.916 70.4564 75.2922    0.435514 -0.824301 0.361738    0 0
  v -104.604 68.0693 75.4542    0.775553 -0.51232 0.368844    0 0
  v -99.2149 71.0599 75.6427    -0.340409 -0.833803 0.43462    0 0
  v -100.497 71.3663 76.8561    0.196019 -0.979648 0.0431963    0 0
  v -100.416 70.2897 74.3188    -0.0280002 -0.699524 0.71406    0 0
  v -100.958 70.407 79.4723    0.0638671 -0.750336 -0.657964    0 0
  v -99.5066 71.1238 78.2358    -0.275782 -0.851584 -0.445813    0 0
  v -106.273 60.0652 77.072    0.797256 -0.599565 0.0700296    0 0
  v -105.944 60.611 78.8368    0.934211 -0.286458 -0.21258    0 0
  v -105.262 60.838 80.5306    0.695442 -0.67817 -0.237583    0 0
  v -104.705 60.7373 73.6897    0.660438 -0.630155 0.408321    0 0
  v -105.681 60.559 75.2943    0.898333 -0.240605 0.36757    0 0
  v -105.672 62.0142 75.3282    0.90561 0.0320003 0.422902    0 0
  v -106.067 60.9788 77.0305    0.996757 -0.034276 0.0727998    0 0
  v -104.652 61.5869 73.9425    0.664372 -0.0503568 0.745704    0 0
  v -105.136 61.6861 80.1957    0.768656 -0.119906 -0.628324    0 0
  v -105.914 62.0625 78.6668    0.958471 -0.00215984 -0.285181    0 0
  v -100.969 62.6874 72.5792    0.396612 -0.762763 0.510775    0 0
  v -103.012 61.8782 73.0297    0.43197 -0.350912 0.830821    0 0
  v -97.4838 64.6839 73.9412    0.206407 -0.915727 0.344731    0 0
  v -99.2705 63.9089 73.1753    -0.0102609 -0.563684 0.825927    0 0
  v -99.6489 65.1572 73.3369    -0.341488 -0.06851 0.937386    0 0
  v -101.254 63.3569 72.9406    0.0411365 -0.152341 0.987472    0 0
  v -98.0755 65.174 74.1972    -0.596757 -0.344635 0.724644    0 0
  v -103.166 63.252 73.1962    0.286266 0.00255442 0.958147    0 0
  v -96.6053 65.4836 77.3583    0.1053 -0.993766 0.0366128    0 0
  v -97.0634 65.3232 75.5962    -0.448786 -0.836859 0.313462    0 0
  v -98.3048 64.8383 80.6991    0.214676 -0.93271 -0.289771    0 0
  v -97.4943 65.4137 79.0818    -0.417052 -0.83066 -0.36888    0 0
  v -97.9793 66.5766 78.903    -0.856676 -0.208604 -0.471795    0 0
  v -97.2673 65.9115 77.3202    -0.88368 -0.458563 -0.0939667    0 0
  v -98.8058 65.3336 80.3658    -0.486849 -0.384223 -0.784443    0 0
  v -97.5742 66.487 75.6196    -0.940412 -0.180322 0.288287    0 0
  v -101.909 62.8613 81.8511    0.465273 -0.788695 -0.401848    0 0
  v -100.164 64.0946 81.3464    0.0717023 -0.601663 -0.795525    0 0
  v -103.737 62.0252 81.2576    0.547342 -0.430342 -0.71779    0 0
  v -103.839 63.3923 80.9495    0.417181 -0.0856721 -0.904776    0 0
  v -102.081 63.5333 81.41    0.161481 -0.23709 -0.957973    0 0
  v -100.485 65.3387 81.035    -0.225891 -0.156176 -0.961552    0 0
  v -106.111 63.2302 76.9203    0.997326 -0.0126574 0.0719757    0 0
  v -105.864 64.9955 78.4372    0.954937 -0.154482 -0.253438    0 0
  v -105.214 63.9094 79.9707    0.757821 -0.0685348 -0.648853    0 0
  v -104.751 63.816 73.9441    0.650978 -0.000287351 0.759096    0 0
  v -105.632 64.9497 75.2749    0.908604 -0.125424 0.39838    0 0
  v -105.668 66.5303 76.7831    0.947284 -0.310978 0.0771111    0 0
  v -104.468 66.8426 74.2283    0.699992 -0.326253 0.635272    0 0
  v -104.886 66.9273 79.4234    0.782977 -0.372822 -0.497945    0 0
  v -101.481 65.5169 72.9783    -0.0294146 -0.0223961 0.999316    0 0
  v -103.258 66.1224 73.2524    0.346071 -0.1248 0.929871    0 0
  v -98.4238 67.2632 74.1892    -0.7159 -0.0941552 0.691825    0 0
  v -99.9317 67.9251 73.3846    -0.292374 -0.167901 0.941449    0 0
  v -101.661 68.5091 73.3699    0.145507 -0.34486 0.927307    0 0
  v -99.0283 69.82 74.4337    -0.491025 -0.494838 0.716959    0 0
  v -97.6488 67.9736 77.1988    -0.982169 -0.148626 -0.115126    0 0
  v -97.9665 69.1851 75.5499    -0.916515 -0.258622 0.305146    0 0
  v -99.1304 67.4192 80.1342    -0.596066 -0.159212 -0.786993    0 0
  v -98.3483 69.27 78.6619    -0.832591 -0.281579 -0.476975    0 0
  v -98.3452 70.635 77.0242    -0.822203 -0.563539 -0.0800377    0 0
  v -99.6206 69.9504 79.5703    -0.383461 -0.538166 -0.750556    0 0
  v -102.279 65.6869 81.1408    0.0948346 -0.119614 -0.988281    0 0
  v -100.723 68.0973 80.6844    -0.173842 -0.255039 -0.951175    0 0
  v -103.899 66.2554 80.6025    0.474903 -0.212236 -0.854063    0 0
  v -102.352 68.6563 80.4374    0.26633 -0.429915 -0.862694    0 0
  v -115.257 57.9989 70.269    0.196381 -0.973806 -0.114617    0 0
  v -120.408 57.4796 68.1161    0.120397 -0.978433 -0.167852    0 0
  v -117.794 58.317 65.9626    0.181037 -0.949545 -0.256103    0 0
  v -113.614 59.1285 66.7021    0.278019 -0.905038 -0.321888    0 0
  v -129.55 56.9367 68.0407    0 -0.983151 -0.182792    0 0
  v -125.133 57.5032 66.07    0.0528392 -0.967232 -0.248335    0 0
  v -124.687 56.7172 70.6896    0.0670629 -0.992196 -0.105113    0 0
  v -125.676 58.3465 63.4186    0.0463794 -0.924391 -0.378615    0 0
  v -121.71 58.149 64.7202    0.0909424 -0.947438 -0.306743    0 0
  v -129.55 57.8921 64.3388    2.47031e-008 -0.946913 -0.321489    0 0
  v -117.384 59.0849 63.9994    0.260861 -0.866981 -0.424612    0 0
  v -119.665 58.7175 63.7889    0.121886 -0.912928 -0.389494    0 0
  v -127.469 73.9374 107.149    0.0318291 -0.536457 0.843327    0 0
  v -126.244 76.6104 108.559    0.0829158 -0.420218 0.903627    0 0
  v -128.026 78.826 109.536    0.0254147 -0.337197 0.941091    0 0
  v -129.55 76.6503 108.631    -9.24008e-009 -0.425379 0.905015    0 0
  v -123.557 78.1079 108.742    0.16928 -0.34706 0.922439    0 0
  v -126.244 79.3111 109.583    0.108165 -0.301604 0.947278    0 0
  v -123.557 74.6885 107.171    0.160064 -0.492687 0.855359    0 0
  v -129.55 80.9707 110.172    -2.15425e-006 -0.243938 0.969791    0 0
  v -127.469 81.854 110.313    0.0653269 -0.201927 0.977219    0 0
  v -124.623 81.2366 109.874    0.135532 -0.239171 0.961472    0 0
  v -126.656 83.579 110.568    0.0822183 -0.145395 0.985951    0 0
  v -129.55 83.4611 110.662    0 -0.158945 0.987287    0 0
  v -120.987 79.8196 108.848    0.194038 -0.301451 0.933529    0 0
  v -118.662 81.6458 108.849    0.237015 -0.238522 0.94177    0 0
  v -122.991 82.717 109.966    0.154996 -0.192841 0.968911    0 0
  v -129.55 84.7741 110.816    -6.15681e-008 -0.0608012 0.99815    0 0
  v -125.888 84.7214 110.626    0.093133 -0.0821112 0.992262    0 0
  v -121.604 84.1815 109.976    0.175967 -0.137125 0.974799    0 0
  v -125.301 85.8821 110.646    0.0939665 -0.0486175 0.994388    0 0
  v -129.55 85.7434 110.846    9.54871e-007 -0.0215463 0.999768    0 0
  v -116.868 83.7527 108.819    0.267321 -0.17901 0.946834    0 0
  v -115.889 86.0178 108.883    0.2815 -0.0879696 0.95552    0 0
  v -120.66 85.8057 109.992    0.182824 -0.089283 0.979083    0 0
  v -129.55 86.7776 110.861    -4.00902e-008 -0.00908946 0.999959    0 0
  v -124.935 87.1226 110.654    0.0917557 -0.0220058 0.995538    0 0
  v -120.175 87.5184 109.996    0.189284 -0.0212618 0.981692    0 0
  v -124.812 88.4115 110.657    0.0926251 7.18902e-007 0.995701    0 0
  v -129.55 87.8602 110.867    8.45553e-007 -0.00269625 0.999996    0 0
  v -115.45 88.3324 108.824    0.296055 0.00524634 0.955157    0 0
  v -115.865 90.7134 108.862    0.287995 0.0778882 0.954459    0 0
  v -120.168 89.2708 109.99    0.191091 0.0236779 0.981287    0 0
  v -129.55 88.9628 110.867    8.4462e-007 0.00269625 0.999996    0 0
  v -124.935 89.7003 110.654    0.0923076 0.0221136 0.995485    0 0
  v -120.671 91.0032 109.998    0.183733 0.0799402 0.97972    0 0
  v -125.301 90.9408 110.646    0.0927043 0.0481162 0.99453    0 0
  v -129.55 90.0453 110.861    -4.00902e-008 0.00908946 0.999959    0 0
  v -116.975 93.0405 108.884    0.265324 0.166181 0.94973    0 0
  v -118.708 95.1697 108.877    0.230638 0.243089 0.942186    0 0
  v -121.627 92.6377 109.99    0.171718 0.137497 0.975504    0 0
  v -129.55 91.0796 110.846    9.54871e-007 0.0215463 0.999768    0 0
  v -125.888 92.1015 110.626    0.0925654 0.08176 0.992344    0 0
  v -122.995 94.1052 109.969    0.153336 0.19402 0.96894    0 0
  v -126.656 93.2439 110.568    0.082152 0.145357 0.985963    0 0
  v -129.55 92.0489 110.816    -5.97024e-008 0.0608012 0.99815    0 0
  v -120.992 97.0025 108.851    0.19245 0.30264 0.933473    0 0
  v -123.557 98.715 108.742    0.16928 0.34706 0.922439    0 0
  v -124.623 95.5864 109.874    0.135399 0.239333 0.96145    0 0
  v -129.55 93.3618 110.662    0 0.158945 0.987287    0 0
  v -127.469 94.9689 110.313    0.0653256 0.20193 0.977219    0 0
  v -126.244 97.5119 109.583    0.108163 0.301603 0.947278    0 0
  v -128.026 97.9969 109.536    0.025415 0.337195 0.941092    0 0
  v -129.55 95.8522 110.172    1.61387e-008 0.243939 0.969791    0 0
  v -126.244 100.213 108.559    0.0829157 0.420218 0.903627    0 0
  v -129.55 100.173 108.631    -9.35667e-009 0.425378 0.905016    0 0
  v -125.888 63.5278 97.0649    0.0659535 -0.791246 0.607931    0 0
  v -122.995 66.3256 99.9755    0.123863 -0.733392 0.668426    0 0
  v -126.656 68.5172 102.712    0.0563129 -0.691601 0.720081    0 0
  v -129.55 65.7789 99.9755    3.54317e-008 -0.746931 0.664902    0 0
  v -120.992 69.4843 102.715    0.174925 -0.660375 0.730278    0 0
  v -118.706 64.739 97.0649    0.197039 -0.761864 0.617041    0 0
  v -124.623 71.5067 105.14    0.107917 -0.618572 0.778282    0 0
  v -129.55 71.1582 105.155    1.19843e-006 -0.625795 0.779988    0 0
  v -124.876 57.361 84.5127    0.0736286 -0.971158 0.226783    0 0
  v -120.597 58.8803 87.8791    0.140941 -0.924773 0.353455    0 0
  v -125.295 59.7282 91.0636    0.0732343 -0.890468 0.449113    0 0
  v -129.55 58.1701 87.8801    -3.45475e-008 -0.939651 0.342135    0 0
  v -116.927 61.1013 91.0627    0.214057 -0.853942 0.474302    0 0
  v -115.649 58.6482 84.506    0.184956 -0.948766 0.256191    0 0
  v -121.626 61.9531 94.1098    0.139612 -0.828476 0.542343    0 0
  v -129.55 61.2931 94.1098    -4.04894e-007 -0.843717 0.536789    0 0
  v -119.795 57.0005 73.756    0.130085 -0.99088 -0.0351348    0 0
  v -124.631 56.4997 77.2823    0.0704052 -0.996853 0.0364238    0 0
  v -129.55 56.3196 73.793    0 -0.999247 -0.0387873    0 0
  v -115.555 57.6444 77.2071    0.168174 -0.985105 0.0358679    0 0
  v -120.025 57.2568 80.9131    0.128493 -0.983507 0.12729    0 0
  v -129.55 56.5676 80.9152    0 -0.992944 0.118587    0 0
  v -125.21 71.7676 49.4185    0.101595 -0.54126 -0.834695    0 0
  v -126.725 68.748 51.3917    0.0549592 -0.578021 -0.814169    0 0
  v -129.55 71.366 49.4185    0 -0.565038 -0.825065    0 0
  v -121.273 69.7409 51.3965    0.148424 -0.540778 -0.827967    0 0
  v -117.565 65.223 55.9245    0.202458 -0.693569 -0.691356    0 0
  v -122.588 66.6648 53.507    0.126432 -0.638772 -0.758937    0 0
  v -129.55 65.8436 53.5355    -7.1974e-007 -0.629249 -0.777204    0 0
  v -124.656 63.7964 55.7714    0.115809 -0.704377 -0.700315    0 0
  v -126.154 102.947 46.1521    0.187737 0.888505 0.418704    0 0
  v -127.715 103.802 44.7367    0.0943061 0.915961 0.390027    0 0
  v -129.55 103.301 46.1521    0 0.912789 0.408431    0 0
  v -124.109 103.049 44.7367    0.278386 0.868704 0.409701    0 0
  v -123.437 104.027 41.5883    0.288334 0.916044 0.278796    0 0
  v -125.655 104.058 43.2306    0.19121 0.924428 0.329957    0 0
  v -129.55 104.456 43.2306    -9.42107e-008 0.946778 0.321886    0 0
  v -127.484 104.858 41.5883    0.0974677 0.959165 0.265522    0 0
  v -125.258 104.965 39.7645    0.195873 0.958211 0.208484    0 0
  v -127.32 105.635 37.7966    0.0994512 0.984209 0.146432    0 0
  v -129.55 105.4 39.7645    8.6758e-008 0.97904 0.203669    0 0
  v -122.961 104.747 37.7966    0.294366 0.943325 0.153256    0 0
  v -122.746 105.083 33.5791    0.29706 0.954514 0.0256417    0 0
  v -125.017 105.535 35.7223    0.198605 0.976059 0.0886824    0 0
  v -129.55 105.992 35.7223    -9.32929e-010 0.996227 0.0867872    0 0
  v -127.246 105.997 33.579    0.100364 0.994647 0.0245679    0 0
  v -124.976 105.636 31.4043    0.199145 0.979258 -0.0373617    0 0
  v -127.278 105.84 29.2296    0.100019 0.990745 -0.0917639    0 0
  v -129.55 106.097 31.4043    -2.98527e-008 0.99933 -0.0365858    0 0
  v -122.839 104.937 29.2297    0.296066 0.950356 -0.095748    0 0
  v -123.19 104.383 25.0062    0.292598 0.935384 -0.198601    0 0
  v -125.132 105.255 27.0865    0.197596 0.969551 -0.144661    0 0
  v -129.55 105.702 27.0865    -2.41588e-007 0.989909 -0.141704    0 0
  v -127.399 105.242 25.0062    0.0987936 0.976699 -0.190522    0 0
  v -125.442 104.502 23.0204    0.194295 0.948871 -0.248781    0 0
  v -127.592 104.289 21.1642    0.095824 0.943994 -0.315742    0 0
  v -129.55 104.918 23.0204    2.26697e-007 0.969809 -0.243867    0 0
  v -123.75 103.5 21.1642    0.283908 0.900888 -0.328324    0 0
  v -124.565 102.212 17.9815    0.256217 0.802257 -0.539199    0 0
  v -125.905 103.378 19.4729    0.184202 0.892111 -0.412562    0 0
  v -129.55 103.749 19.4729    -8.41324e-007 0.914205 -0.405252    0 0
  v -127.873 102.901 17.9815    0.0866684 0.848314 -0.522353    0 0
  v -126.564 101.778 16.7254    0.157044 0.748645 -0.644103    0 0
  v -128.249 101.036 15.6837    0.0695045 0.679755 -0.730139    0 0
  v -129.55 102.086 16.7254    9.342e-010 0.771298 -0.636474    0 0
  v -125.668 100.481 15.682    0.209077 0.630532 -0.747473    0 0
  v -126.896 98.6147 14.1433    0.177993 0.4676 -0.865834    0 0
  v -127.357 99.864 14.838    0.127641 0.581313 -0.803606    0 0
  v -129.55 100.074 14.8315    0 0.599598 -0.800302    0 0
  v -128.642 99.0459 14.1605    0.0488466 0.52487 -0.84978    0 0
  v -128.117 98.0592 13.6493    0.105425 0.438084 -0.892731    0 0
  v -128.897 97.3352 13.261    0.0460668 0.384166 -0.922114    0 0
  v -129.55 98.1137 13.6169    0 0.455584 -0.890193    0 0
  v -128.124 97.0611 13.2249    0.126864 0.342952 -0.930747    0 0
  v -129.55 96.5727 12.9706    -1.60635e-006 0.307731 -0.951474    0 0
  v -139.13 76.3788 107.259    -0.217205 -0.427826 0.877375    0 0
  v -143.436 74.9946 105.205    -0.291042 -0.488372 0.82267    0 0
  v -143.447 71.4344 102.723    -0.27991 -0.596822 0.751967    0 0
  v -139.13 72.8768 105.177    -0.21318 -0.557212 0.802539    0 0
  v -147.086 77.7682 105.247    -0.368708 -0.397171 0.840422    0 0
  v -148.141 74.2508 102.759    -0.377122 -0.508758 0.773915    0 0
  v -142.389 78.4581 107.302    -0.270206 -0.364996 0.890936    0 0
  v -153.06 70.588 97.0597    -0.444471 -0.607749 0.658094    0 0
  v -148.189 70.6458 99.9803    -0.358976 -0.612361 0.704379    0 0
  v -152.996 74.1923 99.984    -0.46852 -0.496996 0.7304    0 0
  v -142.411 67.9596 99.9755    -0.245374 -0.687476 0.683497    0 0
  v -147.149 67.1468 97.0649    -0.325028 -0.701418 0.634326    0 0
  v -145.018 80.9792 107.338    -0.324971 -0.280401 0.9032    0 0
  v -149.897 81.2045 105.291    -0.414255 -0.276071 0.867282    0 0
  v -152.107 77.8003 102.643    -0.447544 -0.427766 0.785316    0 0
  v -151.17 84.7501 105.547    -0.41887 -0.133887 0.898121    0 0
  v -154.211 82.4685 103.742    -0.318977 -0.252976 0.913376    0 0
  v -146.72 83.8709 107.445    -0.358594 -0.184762 0.915026    0 0
  v -161.888 81.86 102.717    0.238903 -0.199841 0.950257    0 0
  v -158.247 80.5342 101.898    -0.107705 -0.578628 0.808449    0 0
  v -158.284 83.6933 102.715    -0.154735 0.0053801 0.987941    0 0
  v -161.717 78.3236 98.2129    -0.203612 -0.847452 0.490272    0 0
  v -157.154 77.8885 99.8322    -0.349971 -0.618561 0.703493    0 0
  v -163.065 79.882 101.206    0.119448 -0.885729 0.448572    0 0
  v -157.621 74.7912 97.0395    -0.507942 -0.538363 0.672428    0 0
  v -147.673 86.8534 107.446    -0.382836 -0.0507774 0.92242    0 0
  v -152.351 88.1926 105.203    -0.469625 -0.00209044 0.882863    0 0
  v -155.416 86.0201 103.636    -0.400703 0.0501994 0.914832    0 0
  v -151.784 91.2 105.269    -0.477626 0.141934 0.867023    0 0
  v -156.192 89.3774 102.739    -0.567401 0.130216 0.813081    0 0
  v -147.844 89.7272 107.353    -0.386192 0.0634886 0.920231    0 0
  v -163.229 89.0177 97.0145    -0.683724 0.100358 0.722806    0 0
  v -160.29 88.5123 99.74    -0.6164 0.239626 0.750087    0 0
  v -159.69 90.4001 100.018    -0.622051 0.115292 0.774442    0 0
  v -162.219 86.7923 99.4131    -0.409458 0.726098 0.552381    0 0
  v -159 86.8139 101.696    -0.439286 0.450916 0.776983    0 0
  v -163.435 88.3287 97.1024    -0.641386 0.351373 0.682027    0 0
  v -161.51 84.3299 102.319    0.00140947 0.42854 0.903522    0 0
  v -147.022 92.5785 107.319    -0.3722 0.175463 0.911416    0 0
  v -150.197 94.9486 105.214    -0.449293 0.270407 0.851479    0 0
  v -155.192 92.9417 102.794    -0.544509 0.220786 0.809174    0 0
  v -147.246 98.8067 105.202    -0.387694 0.382724 0.838579    0 0
  v -152.376 98.0967 102.721    -0.493457 0.365075 0.789443    0 0
  v -145.179 95.5958 107.293    -0.338581 0.271318 0.900971    0 0
  v -158.573 100.084 97.0547    -0.589076 0.417683 0.691759    0 0
  v -157.601 95.9583 99.9749    -0.583436 0.315898 0.748205    0 0
  v -153.389 101.866 99.971    -0.501868 0.468008 0.72739    0 0
  v -162.542 92.6604 97.034    -0.660193 0.228011 0.715651    0 0
  v -142.431 98.3149 107.288    -0.278859 0.35945 0.890524    0 0
  v -143.457 101.803 105.198    -0.298754 0.483144 0.822993    0 0
  v -148.274 102.391 102.725    -0.397497 0.494929 0.772684    0 0
  v -139.13 103.946 105.177    -0.21318 0.557212 0.802539    0 0
  v -143.447 105.389 102.723    -0.283209 0.594574 0.752512    0 0
  v -139.13 100.444 107.259    -0.218366 0.426916 0.87753    0 0
  v -147.149 109.676 97.0649    -0.330927 0.697798 0.635268    0 0
  v -148.234 106.1 99.9751    -0.375552 0.600939 0.705573    0 0
  v -142.411 108.863 99.9755    -0.245374 0.687476 0.683497    0 0
  v -153.26 105.837 97.0629    -0.475958 0.577587 0.663218    0 0
  v -135.542 102.134 107.171    -0.160063 0.492687 0.855359    0 0
  v -134.476 105.316 105.14    -0.107917 0.618572 0.778282    0 0
  v -138.107 107.339 102.715    -0.174925 0.660375 0.730278    0 0
  v -132.443 108.306 102.712    -0.0563129 0.691601 0.720081    0 0
  v -131.63 102.886 107.149    -0.03183 0.536457 0.843327    0 0
  v -133.211 113.295 97.0649    -0.0659537 0.791246 0.60793    0 0
  v -136.104 110.497 99.9755    -0.123863 0.733392 0.668426    0 0
  v -140.393 112.084 97.0649    -0.197039 0.761864 0.617041    0 0
  v -152.031 67.1275 94.1021    -0.407738 -0.698858 0.587663    0 0
  v -149.987 63.8784 91.1633    -0.355478 -0.777792 0.518339    0 0
  v -145.081 63.9181 94.1098    -0.277337 -0.778913 0.562475    0 0
  v -157.806 71.315 94.0728    -0.538773 -0.579472 0.611503    0 0
  v -156.869 67.8515 91.1199    -0.497596 -0.674478 0.545415    0 0
  v -159.386 65.8829 85.8103    -0.53674 -0.705366 0.463    0 0
  v -154.835 64.6217 88.4746    -0.437415 -0.753285 0.491151    0 0
  v -161.573 69.2554 87.9288    -0.60289 -0.625655 0.495055    0 0
  v -147.196 60.9307 87.9751    -0.283393 -0.857781 0.428837    0 0
  v -152.235 61.754 85.8124    -0.357354 -0.831625 0.425086    0 0
  v -161.766 75.9419 94.7757    -0.490976 -0.691675 0.529649    0 0
  v -162.276 72.9367 91.1286    -0.619022 -0.55408 0.556604    0 0
  v -165.474 79.0847 98.7281    -0.174531 -0.971587 0.159869    0 0
  v -165.416 78.1148 94.3843    -0.616124 -0.757534 0.215719    0 0
  v -167.972 82.1158 93.2463    -0.962168 -0.269061 0.0428772    0 0
  v -167.311 79.109 90.4655    -0.835659 -0.460863 0.298796    0 0
  v -167.739 80.4896 96.9538    -0.796729 -0.566388 -0.210778    0 0
  v -169.882 78.0323 84.3239    -0.83444 -0.400302 0.378772    0 0
  v -166.495 75.2986 87.7782    -0.758363 -0.473395 0.448087    0 0
  v -169.749 81.6933 87.4476    -0.865241 -0.274487 0.419542    0 0
  v -165.829 71.5564 84.4624    -0.744934 -0.552606 0.373764    0 0
  v -165.985 88.711 94.3319    -0.722494 0.226499 0.653223    0 0
  v -167.831 86.7322 93.2892    -0.833573 0.351331 0.426288    0 0
  v -165.905 86.7931 95.9212    -0.565497 0.695514 0.443254    0 0
  v -165.981 91.0961 93.9859    -0.738773 0.141565 0.658919    0 0
  v -168.518 90.2257 91.0087    -0.793238 0.131547 0.594532    0 0
  v -172.082 91.6692 84.4491    -0.909335 0.137399 0.392724    0 0
  v -170.59 88.3262 87.9239    -0.882071 -0.0192602 0.470722    0 0
  v -169.915 93.8759 87.797    -0.834732 0.242035 0.494613    0 0
  v -169.078 85.0264 90.5122    -0.934891 -0.0803332 0.345724    0 0
  v -172.091 84.9452 84.3316    -0.906608 -0.141759 0.397449    0 0
  v -168.314 83.7306 95.8491    -0.984793 0.143554 -0.0978559    0 0
  v -163.3 97.706 94.0773    -0.66281 0.366092 0.653192    0 0
  v -167.181 95.4847 90.9523    -0.748123 0.309746 0.586831    0 0
  v -158.239 104.604 94.1053    -0.568164 0.539437 0.621448    0 0
  v -162.884 102.652 91.0571    -0.654063 0.501243 0.566531    0 0
  v -165.744 104.711 84.5107    -0.712655 0.599572 0.364194    0 0
  v -166.87 100.444 87.8568    -0.739682 0.460234 0.490974    0 0
  v -161.605 106.954 87.878    -0.623128 0.641255 0.447776    0 0
  v -170.032 98.1826 84.4795    -0.83046 0.396153 0.391662    0 0
  v -152.074 109.601 94.1093    -0.428622 0.691305 0.581705    0 0
  v -156.972 108.648 91.0623    -0.527685 0.672272 0.519229    0 0
  v -145.081 112.905 94.1098    -0.278888 0.783255 0.555637    0 0
  v -149.968 112.914 91.0635    -0.372534 0.794403 0.479731    0 0
  v -151.957 114.933 84.5118    -0.402928 0.875898 0.265428    0 0
  v -154.861 112.083 87.8798    -0.470776 0.788592 0.395591    0 0
  v -147.031 115.721 87.8792    -0.310852 0.87741 0.365409    0 0
  v -159.555 110.49 84.5123    -0.5648 0.765358 0.308591    0 0
  v -137.473 114.87 94.1098    -0.139685 0.828906 0.541667    0 0
  v -142.143 115.694 91.0632    -0.221793 0.859854 0.459846    0 0
  v -133.804 117.097 91.0627    -0.0740882 0.88988 0.450139    0 0
  v -134.223 119.488 84.5039    -0.0805288 0.969382 0.231978    0 0
  v -138.473 117.922 87.8773    -0.155208 0.923876 0.349805    0 0
  v -143.378 117.954 84.5083    -0.240763 0.939848 0.242321    0 0
  v -169.295 74.5345 80.8581    -0.826249 -0.501349 0.256831    0 0
  v -168.189 71.5841 77.1779    -0.813779 -0.57038 0.111492    0 0
  v -165.417 68.9888 80.7579    -0.758119 -0.599394 0.256871    0 0
  v -172.546 81.3018 80.8092    -0.915396 -0.294564 0.274375    0 0
  v -171.938 77.7951 77.1475    -0.894241 -0.428848 0.128151    0 0
  v -171.802 78.0903 69.5609    -0.874102 -0.433341 -0.219456    0 0
  v -170.374 74.5956 73.3663    -0.851106 -0.523185 -0.0435508    0 0
  v -173.641 81.3128 73.3573    -0.949795 -0.31178 -0.0261225    0 0
  v -166.413 69.0038 73.6029    -0.781976 -0.619913 -0.0649672    0 0
  v -167.705 71.6444 69.6073    -0.772763 -0.585493 -0.245021    0 0
  v -173.66 88.4188 80.8376    -0.957961 0.000689226 0.286898    0 0
  v -174.225 84.8183 77.1446    -0.977005 -0.155156 0.146247    0 0
  v -172.536 95.3992 80.8889    -0.914007 0.293135 0.28047    0 0
  v -174.221 91.9969 77.1567    -0.976665 0.155893 0.147726    0 0
  v -174.074 91.9111 69.5609    -0.96277 0.156728 -0.220251    0 0
  v -174.787 88.4115 73.3573    -0.999809 1.10724e-007 -0.019552    0 0
  v -173.641 95.5101 73.3573    -0.949829 0.31179 -0.0247402    0 0
  v -174.074 84.9118 69.5609    -0.96277 -0.156728 -0.220251    0 0
  v -169.248 102.064 80.9115    -0.801896 0.537763 0.260335    0 0
  v -171.949 98.975 77.1665    -0.887237 0.441759 0.132885    0 0
  v -163.863 108.247 80.9148    -0.655769 0.723557 0.215483    0 0
  v -167.503 105.465 77.1692    -0.743578 0.660574 0.1036    0 0
  v -167.371 105.039 69.5609    -0.720652 0.657937 -0.218584    0 0
  v -170.229 102.251 73.3573    -0.82128 0.569129 -0.0398951    0 0
  v -164.752 108.302 73.3573    -0.65562 0.752576 -0.0615719    0 0
  v -171.802 98.7326 69.5609    -0.869107 0.443415 -0.219171    0 0
  v -156.742 113.365 80.9147    -0.491123 0.854844 0.167453    0 0
  v -161.107 111.117 77.1693    -0.575283 0.815493 0.0634119    0 0
  v -148.349 117.174 80.9108    -0.326707 0.935222 0.136463    0 0
  v -153.145 115.61 77.1667    -0.409001 0.911984 0.0316861    0 0
  v -153.071 114.877 69.5571    -0.391831 0.893069 -0.221125    0 0
  v -157.471 113.349 73.3564    -0.485174 0.87049 -0.082789    0 0
  v -148.858 117.16 73.3485    -0.322554 0.941449 -0.0981434    0 0
  v -161.006 110.509 69.5609    -0.552522 0.804146 -0.219244    0 0
  v -139.149 119.516 80.9015    -0.163434 0.979178 0.120415    0 0
  v -144.115 118.73 77.1558    -0.245102 0.969414 0.0127185    0 0
  v -134.473 120.331 77.1421    -0.0825613 0.996574 0.00492218    0 0
  v -134.457 119.503 69.5222    -0.0799782 0.971338 -0.223845    0 0
  v -139.41 119.527 73.3301    -0.162298 0.981022 -0.106089    0 0
  v -144.069 117.927 69.5416    -0.2358 0.945893 -0.2229    0 0
  v -153.678 61.6844 68.1464    -0.376154 -0.840236 -0.390526    0 0
  v -156.612 64.7316 65.236    -0.439889 -0.766469 -0.467999    0 0
  v -151.681 64.1396 62.1159    -0.370505 -0.767937 -0.522493    0 0
  v -149.135 61.1517 65.2368    -0.345985 -0.835828 -0.426246    0 0
  v -163.66 69.3968 65.8068    -0.600576 -0.659768 -0.451681    0 0
  v -158.678 68.0753 62.2473    -0.481821 -0.68844 -0.542125    0 0
  v -161.277 65.92 68.3083    -0.543499 -0.730891 -0.412804    0 0
  v -154.026 70.8861 56.1425    -0.391332 -0.559518 -0.730616    0 0
  v -153.385 67.4016 59.052    -0.391367 -0.682612 -0.617148    0 0
  v -159.536 71.6391 59.0738    -0.496748 -0.57886 -0.646655    0 0
  v -146.689 64.3596 58.8558    -0.291434 -0.740681 -0.605358    0 0
  v -147.964 67.4662 56.0989    -0.302131 -0.645375 -0.701575    0 0
  v -168.732 75.2876 65.8696    -0.760018 -0.508726 -0.404439    0 0
  v -164.559 73.1045 62.3475    -0.620246 -0.55978 -0.549492    0 0
  v -171.979 81.6964 65.8621    -0.863762 -0.288732 -0.412977    0 0
  v -168.626 78.9301 62.3401    -0.734387 -0.376594 -0.564671    0 0
  v -162.485 80.2259 56.1425    -0.531137 -0.268333 -0.803673    0 0
  v -164.22 76.7416 59.0738    -0.59883 -0.421369 -0.681066    0 0
  v -167.137 82.4255 59.0738    -0.667369 -0.222529 -0.710704    0 0
  v -159.013 75.2246 56.1425    -0.472495 -0.426969 -0.771003    0 0
  v -173.083 88.4115 65.8621    -0.907367 -5.53846e-007 -0.42034    0 0
  v -170.73 85.1966 62.3401    -0.800037 -0.13144 -0.585375    0 0
  v -171.979 95.1265 65.8621    -0.863761 0.288732 -0.412977    0 0
  v -170.73 91.6263 62.3401    -0.800037 0.13144 -0.585376    0 0
  v -164.265 91.187 56.1425    -0.562199 0.0906518 -0.822018    0 0
  v -168.117 88.4115 59.0738    -0.691892 -7.11484e-008 -0.722001    0 0
  v -167.137 94.3974 59.0738    -0.667369 0.222529 -0.710703    0 0
  v -164.265 85.636 56.1425    -0.562199 -0.0906522 -0.822018    0 0
  v -168.694 101.503 65.8621    -0.750708 0.529719 -0.394761    0 0
  v -168.626 97.8928 62.3401    -0.733873 0.37782 -0.564519    0 0
  v -163.42 107.227 65.8621    -0.602973 0.704744 -0.373845    0 0
  v -164.522 103.686 62.3401    -0.622882 0.573723 -0.531846    0 0
  v -159.013 101.598 56.1425    -0.472494 0.426971 -0.771003    0 0
  v -164.22 100.081 59.0738    -0.599404 0.421774 -0.68031    0 0
  v -159.536 105.184 59.0738    -0.500419 0.583128 -0.639955    0 0
  v -162.485 96.597 56.1425    -0.531137 0.268333 -0.803673    0 0
  v -156.408 112.002 65.8613    -0.448917 0.81958 -0.356036    0 0
  v -158.626 108.711 62.3401    -0.488495 0.717142 -0.497071    0 0
  v -148.119 115.607 65.8533    -0.300133 0.889612 -0.344255    0 0
  v -151.28 112.72 62.3373    -0.352157 0.809948 -0.469009    0 0
  v -147.819 109.392 56.1416    -0.292593 0.661413 -0.690596    0 0
  v -153.312 109.439 59.0734    -0.385269 0.701449 -0.599614    0 0
  v -145.964 112.642 59.0694    -0.262832 0.780137 -0.567719    0 0
  v -154.026 105.937 56.1425    -0.389784 0.561314 -0.730065    0 0
  v -139.031 117.848 65.8349    -0.151703 0.928658 -0.338496    0 0
  v -142.958 115.51 62.3264    -0.213461 0.866703 -0.450843    0 0
  v -134.081 116.943 62.3128    -0.0723792 0.893521 -0.443149    0 0
  v -133.352 112.986 56.1337    -0.0614708 0.762556 -0.643995    0 0
  v -137.926 114.613 59.0602    -0.133423 0.825272 -0.548748    0 0
  v -140.809 111.778 56.1381    -0.18102 0.729311 -0.659801    0 0
  v -148.349 70.895 53.6208    -0.302951 -0.520928 -0.798032    0 0
  v -142.912 71.6196 51.4139    -0.251012 -0.520239 -0.816299    0 0
  v -142.644 68.2704 53.5815    -0.220117 -0.596926 -0.77151    0 0
  v -153.293 74.436 53.6251    -0.369381 -0.412302 -0.832806    0 0
  v -147.484 74.3786 51.4183    -0.318219 -0.423885 -0.847973    0 0
  v -139.918 78.238 47.5221    -0.2867 -0.314131 -0.905055    0 0
  v -142.002 75.0069 49.4185    -0.250731 -0.385901 -0.887814    0 0
  v -145.352 77.718 49.4185    -0.29069 -0.287069 -0.912738    0 0
  v -138.092 72.983 49.4185    -0.18898 -0.475278 -0.859301    0 0
  v -137.205 76.2392 47.5221    -0.241982 -0.412577 -0.878194    0 0
  v -157.027 78.6876 53.6251    -0.418356 -0.282 -0.863397    0 0
  v -151.18 77.8526 51.4183    -0.366451 -0.306789 -0.878404    0 0
  v -159.352 83.4237 53.6251    -0.446876 -0.142768 -0.88313    0 0
  v -153.753 81.8572 51.4183    -0.395532 -0.185132 -0.8996    0 0
  v -143.653 83.6598 47.5221    -0.324136 -0.124806 -0.937742    0 0
  v -147.877 80.9712 49.4185    -0.314269 -0.187402 -0.930653    0 0
  v -149.449 84.595 49.4185    -0.325731 -0.0920613 -0.94097    0 0
  v -142.12 80.7565 47.5221    -0.312316 -0.215108 -0.925304    0 0
  v -160.133 88.4115 53.6251    -0.456273 -5.50529e-008 -0.88984    0 0
  v -155.072 86.1891 51.4183    -0.40923 -0.0611365 -0.910381    0 0
  v -159.352 93.3993 53.6251    -0.446876 0.142768 -0.88313    0 0
  v -155.072 90.6339 51.4183    -0.40923 0.0611363 -0.910381    0 0
  v -144.439 90.0226 47.5221    -0.328678 0.0403903 -0.943578    0 0
  v -149.978 88.4115 49.4185    -0.329168 -4.56465e-008 -0.944271    0 0
  v -149.449 92.2279 49.4185    -0.325732 0.0920617 -0.940969    0 0
  v -144.439 86.8003 47.5221    -0.328678 -0.0403903 -0.943578    0 0
  v -157.027 98.1354 53.6251    -0.418356 0.281999 -0.863397    0 0
  v -153.753 94.9658 51.4183    -0.395532 0.185132 -0.8996    0 0
  v -153.293 102.387 53.6251    -0.369381 0.412303 -0.832805    0 0
  v -151.18 98.9704 51.4183    -0.36645 0.306788 -0.878405    0 0
  v -142.12 96.0664 47.5221    -0.312316 0.215108 -0.925304    0 0
  v -147.877 95.8518 49.4185    -0.314269 0.187402 -0.930653    0 0
  v -145.352 99.1049 49.4185    -0.29069 0.287068 -0.912738    0 0
  v -143.653 93.1632 47.5221    -0.324136 0.124806 -0.937742    0 0
  v -148.334 105.931 53.625    -0.301026 0.524936 -0.796132    0 0
  v -147.484 102.444 51.4183    -0.318037 0.424151 -0.847908    0 0
  v -142.499 108.588 53.6242    -0.214497 0.612463 -0.760841    0 0
  v -142.897 105.207 51.4182    -0.250844 0.524798 -0.813427    0 0
  v -137.205 100.584 47.5221    -0.241983 0.412576 -0.878194    0 0
  v -142.002 101.816 49.4185    -0.25073 0.385902 -0.887814    0 0
  v -138.092 103.84 49.4185    -0.188981 0.475277 -0.859301    0 0
  v -139.918 98.5849 47.5221    -0.286699 0.31413 -0.905056    0 0
  v -136.149 110.204 53.6224    -0.111121 0.66869 -0.735191    0 0
  v -137.753 107.1 51.4178    -0.160748 0.602614 -0.781676    0 0
  v -132.317 108.045 51.4174    -0.0552101 0.64411 -0.762938    0 0
  v -131.119 102.606 47.5221    -0.0585895 0.55779 -0.827911    0 0
  v -133.889 105.055 49.4185    -0.101593 0.541262 -0.834694    0 0
  v -134.219 101.94 47.5221    -0.165418 0.502654 -0.848514    0 0
  v -184.999 77.3164 126.015    -0.0545033 -0.00715752 0.998488    0 0
  v -186.251 77.186 125.833    -0.260386 -0.0244349 0.965195    0 0
  v -185.972 76.2313 125.722    -0.207884 -0.323226 0.923206    0 0
  v -184.745 76.4501 125.915    -0.0199352 -0.237956 0.971071    0 0
  v -187.314 78.0336 125.27    -0.507188 0.234408 0.829345    0 0
  v -187.335 77.0451 125.378    -0.507901 -0.0643642 0.859008    0 0
  v -186.329 78.161 125.683    -0.297788 0.241944 0.923464    0 0
  v -187.959 76.0362 124.568    -0.627829 -0.419468 0.65565    0 0
  v -187.056 76.0903 125.268    -0.437367 -0.394117 0.80832    0 0
  v -188.213 76.9025 124.668    -0.703031 -0.117197 0.701436    0 0
  v -185.498 75.3329 125.357    -0.162658 -0.542956 0.823857    0 0
  v -186.482 75.2055 124.944    -0.337521 -0.613071 0.714299    0 0
  v -165.566 82.1191 104.323    0.470453 0.194422 0.86074    0 0
  v -169.395 80.4321 107.355    0.685744 -0.204253 0.698595    0 0
  v -165.985 80.4916 104.256    0.475621 -0.628037 0.615918    0 0
  v -175.037 78.7116 113.798    0.811391 -0.281714 0.512136    0 0
  v -172.808 79.0692 110.609    0.672269 -0.602554 0.430097    0 0
  v -172.448 80.0655 110.583    0.719375 0.174451 0.672359    0 0
  v -173.517 78.5439 110.084    0.197823 -0.978528 -0.0578677    0 0
  v -170.017 79.4506 106.92    0.425233 -0.866149 0.262607    0 0
  v -175.55 77.9188 113.445    0.510759 -0.849324 0.133317    0 0
  v -167.308 79.5575 102.924    0.144345 -0.981224 0.127923    0 0
  v -171.101 79.2351 106.026    -0.0841659 -0.980095 -0.179807    0 0
  v -168.934 79.7509 101.459    -0.411557 -0.880034 -0.236985    0 0
  v -176.514 77.7817 112.933    -0.0745363 -0.936357 -0.343044    0 0
  v -174.506 78.8129 109.494    -0.32125 -0.847523 -0.422497    0 0
  v -174.959 79.6858 108.917    -0.77209 -0.19452 -0.605011    0 0
  v -172.062 79.9646 105.184    -0.613119 -0.619623 -0.490054    0 0
  v -177.452 78.3678 112.512    -0.515838 -0.607037 -0.604498    0 0
  v -169.788 81.443 100.463    -0.866353 -0.234767 -0.440814    0 0
  v -171.806 81.4081 104.242    -0.858097 0.29405 -0.420955    0 0
  v -168.608 83.9622 98.9529    -0.735693 0.676928 -0.022887    0 0
  v -177.498 79.355 112.281    -0.762419 0.323809 -0.560237    0 0
  v -174.159 80.8424 108.405    -0.686473 0.659252 -0.306824    0 0
  v -172.847 81.6178 108.386    -0.230386 0.965147 0.124154    0 0
  v -170.1 82.9377 103.484    -0.497553 0.867426 0.0036173    0 0
  v -176.562 80.2919 112.306    -0.471209 0.863315 -0.18069    0 0
  v -165.534 85.5743 99.1716    -0.345799 0.877685 0.331802    0 0
  v -168.787 83.0758 104.605    -0.0367427 0.924792 0.378695    0 0
  v -164.716 84.2047 102.557    -0.00499709 0.804075 0.594508    0 0
  v -175.578 80.4327 112.847    0.149376 0.933994 0.324564    0 0
  v -172.403 81.1096 109.608    0.318869 0.793206 0.518794    0 0
  v -168.954 81.8042 106.596    0.429447 0.571537 0.699229    0 0
  v -175.064 79.7025 113.597    0.622384 0.525066 0.580469    0 0
  v -176.438 78.6926 116.003    0.848341 0.161228 0.504304    0 0
  v -177.084 77.7506 117.326    0.949522 -0.222342 0.221298    0 0
  v -176.652 77.6262 115.744    0.759243 -0.603355 0.243953    0 0
  v -177.131 77.3047 118.882    0.983395 -0.114737 -0.140608    0 0
  v -177.523 76.7213 117.929    0.865356 -0.471141 -0.170836    0 0
  v -177.262 78.3243 118.411    0.961614 0.271759 0.0380224    0 0
  v -178.936 75.8055 117.156    0.342078 -0.764019 -0.547045    0 0
  v -177.804 76.639 116.779    0.600816 -0.786563 -0.142616    0 0
  v -178.202 75.6579 118.07    0.648121 -0.633911 -0.422013    0 0
  v -177.556 77.0234 115.218    0.243357 -0.943307 -0.225719    0 0
  v -179.275 76.4465 116.151    0.00222162 -0.824179 -0.566326    0 0
  v -178.842 77.3301 114.744    -0.266461 -0.775366 -0.572544    0 0
  v -180.402 75.3779 117.149    0.0991686 -0.653585 -0.750328    0 0
  v -180.954 76.2802 116.492    -0.10907 -0.574246 -0.811384    0 0
  v -182.294 77.6773 116.304    -0.357993 0.00233566 -0.933721    0 0
  v -180.762 77.2692 115.757    -0.378391 -0.468142 -0.798538    0 0
  v -182.633 76.6046 116.579    -0.198049 -0.312648 -0.928993    0 0
  v -179.654 78.2577 114.531    -0.655844 -0.132915 -0.743103    0 0
  v -181.12 78.5779 115.874    -0.548503 0.377256 -0.746206    0 0
  v -179.245 79.3664 114.717    -0.583508 0.669596 -0.459521    0 0
  v -183.205 78.5394 116.801    -0.289131 0.367696 -0.883857    0 0
  v -181.842 79.2985 116.839    -0.297074 0.627984 -0.719294    0 0
  v -180.239 80.2324 117.666    0.0499087 0.922505 -0.382745    0 0
  v -180.164 79.7224 116.439    -0.308031 0.864722 -0.396702    0 0
  v -181.833 80.2149 117.703    -0.104749 0.758663 -0.643007    0 0
  v -178.114 80.0295 115.158    -0.129311 0.991604 -0.000635618    0 0
  v -178.691 79.9153 117.069    0.250873 0.965908 0.0639117    0 0
  v -177.044 79.6647 115.734    0.45617 0.79705 0.395754    0 0
  v -179.633 80.495 118.624    0.343748 0.890908 -0.296851    0 0
  v -178.412 79.7396 118.276    0.557991 0.828345 -0.0498996    0 0
  v -177.441 79.0596 117.446    0.7404 0.600863 0.301285    0 0
  v -177.704 79.2396 119.103    0.781458 0.617644 -0.0885353    0 0
  v -177.138 78.2782 119.761    0.960827 0.277072 0.0066043    0 0
  v -177.108 76.9549 120.155    0.981263 -0.177725 0.0744122    0 0
  v -177.499 76.0578 119.098    0.865223 -0.465742 -0.185671    0 0
  v -177.532 76.622 121.568    0.893682 -0.251342 0.371698    0 0
  v -177.754 75.4889 120.327    0.819912 -0.567038 0.0788117    0 0
  v -177.317 78.1884 121.13    0.926591 0.235657 0.293079    0 0
  v -180.141 73.9529 119.032    0.280181 -0.886296 -0.368752    0 0
  v -178.488 74.8349 119.114    0.623351 -0.739106 -0.255256    0 0
  v -179.131 74.1693 120.366    0.544586 -0.8387 0.00292651    0 0
  v -179.46 74.7928 118.031    0.343735 -0.7556 -0.557598    0 0
  v -181.326 74.4778 117.927    0.0413279 -0.758304 -0.65059    0 0
  v -182.259 75.456 117.106    -0.0981973 -0.56178 -0.821438    0 0
  v -182.417 73.758 118.992    -0.0486103 -0.881226 -0.47019    0 0
  v -183.547 74.7624 117.904    -0.197578 -0.684715 -0.701519    0 0
  v -185.813 77.1227 117.577    -0.483657 -0.0437446 -0.874164    0 0
  v -184.202 76.0621 117.188    -0.290837 -0.393157 -0.872262    0 0
  v -185.748 75.5938 118.133    -0.431121 -0.50634 -0.74683    0 0
  v -184.121 77.3955 116.839    -0.327981 0.00969866 -0.944635    0 0
  v -184.945 78.5558 117.472    -0.398513 0.379894 -0.834786    0 0
  v -183.502 79.6404 117.583    -0.259257 0.613263 -0.746119    0 0
  v -186.61 78.4805 118.46    -0.570469 0.387438 -0.724194    0 0
  v -185.065 79.8516 118.482    -0.389044 0.661606 -0.641032    0 0
  v -182.367 81.4172 119.88    -0.00328397 0.96471 -0.263293    0 0
  v -183.182 80.7121 118.636    -0.181628 0.813126 -0.553026    0 0
  v -184.572 80.9749 119.81    -0.29995 0.870675 -0.389814    0 0
  v -181.283 80.9299 118.731    0.075712 0.898594 -0.4322    0 0
  v -180.344 81.0692 119.823    0.307824 0.939588 -0.149729    0 0
  v -178.741 80.2422 119.575    0.563738 0.819891 -0.0998913    0 0
  v -181.286 81.3862 121.184    0.238175 0.967965 0.079483    0 0
  v -179.272 80.5782 120.905    0.520763 0.843442 0.13195    0 0
  v -177.85 79.4486 120.439    0.77049 0.62841 0.106982    0 0
  v -178.394 79.5087 121.896    0.702401 0.600578 0.382018    0 0
  v -178.08 78.0052 122.722    0.811468 0.174054 0.557875    0 0
  v -178.646 76.3031 123.239    0.741919 -0.295323 0.601947    0 0
  v -178.564 75.0177 121.835    0.706271 -0.621923 0.33822    0 0
  v -180.424 76.1116 124.74    0.489792 -0.318097 0.811738    0 0
  v -180.014 74.7567 123.49    0.535329 -0.625251 0.567877    0 0
  v -179.534 77.7217 124.37    0.627329 0.0977824 0.772591    0 0
  v -182.637 73.0704 122.069    0.0827485 -0.989855 0.115494    0 0
  v -180.332 73.7173 121.971    0.431874 -0.869236 0.240651    0 0
  v -181.971 73.7371 123.576    0.247323 -0.82005 0.51609    0 0
  v -181.207 73.3186 120.403    0.193417 -0.970555 -0.143575    0 0
  v -183.797 73.2843 120.523    -0.137767 -0.95572 -0.260038    0 0
  v -184.977 74.2161 119.153    -0.302897 -0.792182 -0.529812    0 0
  v -185.152 73.3385 122.246    -0.252713 -0.964764 0.0732531    0 0
  v -186.379 73.961 120.829    -0.411034 -0.867547 -0.280023    0 0
  v -188.869 76.5547 120.467    -0.852717 -0.189101 -0.486944    0 0
  v -187.31 75.2207 119.616    -0.564953 -0.603864 -0.562295    0 0
  v -188.376 75.1152 121.415    -0.706685 -0.683103 -0.184302    0 0
  v -187.486 76.8296 118.789    -0.661359 -0.108648 -0.742159    0 0
  v -188.22 78.2647 119.961    -0.746245 0.374854 -0.550094    0 0
  v -186.661 79.8495 119.792    -0.534051 0.693029 -0.484253    0 0
  v -189.21 77.9096 121.732    -0.943131 0.295853 -0.151578    0 0
  v -188.049 79.5519 121.462    -0.692585 0.683052 -0.231874    0 0
  v -185.087 81.2704 122.998    -0.20508 0.956648 0.206801    0 0
  v -186.072 80.8943 121.385    -0.417718 0.889181 -0.186732    0 0
  v -187.237 80.3244 123.039    -0.561124 0.809442 0.173042    0 0
  v -183.676 81.581 121.339    -0.0959835 0.993844 -0.0553208    0 0
  v -182.606 81.3273 122.834    0.152946 0.939433 0.306715    0 0
  v -180.247 80.6511 122.473    0.442459 0.816433 0.371035    0 0
  v -184.056 80.723 124.369    0.0140534 0.798785 0.601452    0 0
  v -181.684 80.3476 124.124    0.323449 0.726378 0.606428    0 0
  v -179.556 79.3471 123.584    0.588177 0.531675 0.609401    0 0
  v -181.258 78.9059 125.058    0.384437 0.390438 0.83652    0 0
  v -181.605 77.3736 125.537    0.336866 -0.0062375 0.941532    0 0
  v -182.696 76.1555 125.627    0.20927 -0.3106 0.927218    0 0
  v -182.001 74.9284 124.809    0.268648 -0.559896 0.783802    0 0
  v -184.146 75.4984 125.543    0.0384585 -0.463481 0.885272    0 0
  v -183.746 77.0464 125.988    0.0824462 -0.0887889 0.992632    0 0
  v -185.423 74.5472 124.743    -0.19997 -0.695901 0.689734    0 0
  v -183.829 74.4175 124.771    0.0393385 -0.680369 0.731813    0 0
  v -184.162 73.5361 123.635    -0.0761329 -0.888074 0.453352    0 0
  v -186.123 74.1266 123.811    -0.342598 -0.831094 0.438074    0 0
  v -187.246 74.268 122.615    -0.511035 -0.845567 0.154467    0 0
  v -187.415 75.0803 124.174    -0.51368 -0.678982 0.524515    0 0
  v -188.742 76.4088 123.897    -0.791318 -0.289993 0.538257    0 0
  v -188.475 75.4229 123.209    -0.714032 -0.628496 0.308466    0 0
  v -189.298 76.4051 122.319    -0.957543 -0.280067 0.0683734    0 0
  v -189.073 77.4394 123.439    -0.914707 0.117114 0.386777    0 0
  v -188.618 78.8772 123.139    -0.815036 0.519974 0.255622    0 0
  v -188.263 77.9548 124.504    -0.72766 0.241689 0.641949    0 0
  v -186.721 78.9407 125.247    -0.39799 0.413478 0.818926    0 0
  v -187.63 79.2069 124.392    -0.614401 0.538485 0.576667    0 0
  v -186.174 80.2962 124.404    -0.338698 0.741269 0.579487    0 0
  v -185.336 79.4978 125.351    -0.141237 0.523178 0.840439    0 0
  v -183.373 79.5376 125.333    0.119511 0.510017 0.851821    0 0
  v -184.994 78.3729 125.873    -0.0689322 0.266078 0.961484    0 0
  v -183.294 78.172 125.858    0.138896 0.205882 0.968669    0 0
  v -136.239 101.877 46.1521    -0.364607 0.815888 0.448763    0 0
  v -138.407 101.539 44.7367    -0.444149 0.778114 0.444151    0 0
  v -139.312 100.098 46.1522    -0.517763 0.717796 0.4655    0 0
  v -139.453 102.382 41.5883    -0.466368 0.831161 0.302773    0 0
  v -140.626 100.927 43.2307    -0.52918 0.755485 0.386279    0 0
  v -137.189 102.869 43.2306    -0.374594 0.856916 0.354082    0 0
  v -143.539 98.4447 43.2321    -0.652206 0.628223 0.42422    0 0
  v -141.456 99.376 44.7372    -0.588632 0.678666 0.439233    0 0
  v -142.792 100.061 41.5889    -0.609865 0.720997 0.32898    0 0
  v -141.949 97.7567 46.1527    -0.62196 0.566205 0.540905    0 0
  v -143.91 96.7707 44.7389    -0.671932 0.50622 0.5406    0 0
  v -143.931 95.0075 46.1586    -0.720448 0.39964 0.566782    0 0
  v -145.457 97.3265 41.5915    -0.734086 0.578447 0.355691    0 0
  v -145.718 95.639 43.2406    -0.756684 0.457142 0.467387    0 0
  v -147.038 92.5777 43.292    -0.832834 0.236164 0.500613    0 0
  v -145.594 93.8313 44.7698    -0.781773 0.326933 0.530986    0 0
  v -147.292 94.3476 41.6031    -0.842112 0.381574 0.381115    0 0
  v -145.138 91.9205 46.2011    -0.760955 0.197634 0.617971    0 0
  v -146.387 90.5645 44.8846    -0.794752 0.127663 0.593356    0 0
  v -145.448 88.5652 46.345    -0.777448 0.00288918 0.62894    0 0
  v -148.206 91.2042 41.6364    -0.89936 0.180761 0.398092    0 0
  v -147.587 89.535 43.3654    -0.818102 0.206282 0.536802    0 0
  v -148.528 87.8244 43.1994    -0.587576 0.594301 0.549145    0 0
  v -147.203 87.7284 44.5    -0.643969 0.242208 0.7257    0 0
  v -148.726 88.779 41.7899    -0.84064 0.404234 0.360445    0 0
  v -146.114 84.8575 45.4666    -0.406322 -0.102823 0.907926    0 0
  v -145.929 86.7463 45.7048    -0.595809 0.0135816 0.803011    0 0
  v -147.32 86.022 44.9715    -0.31439 0.238187 0.918927    0 0
  v -144.795 85.1072 46.6405    -0.778023 -0.196286 0.596784    0 0
  v -145.049 83.273 45.7059    -0.692834 -0.309399 0.651347    0 0
  v -143.752 81.8266 46.3435    -0.699945 -0.382093 0.603392    0 0
  v -146.644 83.423 44.9944    -0.208835 -0.364413 0.907519    0 0
  v -145.733 81.9966 44.5157    -0.469915 -0.547289 0.692571    0 0
  v -146.656 80.7408 41.8127    -0.539725 -0.789657 0.291786    0 0
  v -145.285 80.4892 43.3671    -0.619606 -0.616358 0.485994    0 0
  v -146.881 81.5081 43.2565    -0.313615 -0.812298 0.491749    0 0
  v -143.384 78.2331 43.2857    -0.645725 -0.628905 0.433033    0 0
  v -143.707 79.9633 44.8805    -0.685835 -0.535242 0.493098    0 0
  v -145.113 79.0774 41.6302    -0.701071 -0.620656 0.35112    0 0
  v -141.899 79.0597 46.1986    -0.623507 -0.565644 0.539709    0 0
  v -141.416 77.4292 44.7655    -0.570771 -0.659894 0.488631    0 0
  v -139.307 76.7244 46.1568    -0.517609 -0.717464 0.466182    0 0
  v -142.723 76.6778 41.5967    -0.601119 -0.728903 0.327653    0 0
  v -140.61 75.8811 43.2361    -0.52513 -0.757704 0.387457    0 0
  v -137.189 73.9534 43.2306    -0.374594 -0.856916 0.354082    0 0
  v -138.407 75.2844 44.7367    -0.453997 -0.795995 0.400349    0 0
  v -139.453 74.4411 41.5883    -0.464521 -0.832284 0.302529    0 0
  v -136.239 74.9462 46.1521    -0.364607 -0.815886 0.448767    0 0
  v -134.99 73.7743 44.7367    -0.278385 -0.868703 0.409703    0 0
  v -132.945 73.8754 46.1521    -0.189698 -0.897739 0.397592    0 0
  v -134.219 74.8825 47.5221    -0.282281 -0.856473 0.43217    0 0
  v -135.662 72.7957 41.5883    -0.288334 -0.916044 0.278797    0 0
  v -133.444 72.7647 43.2306    -0.191211 -0.924428 0.329957    0 0
  v -131.384 73.0206 44.7367    -0.0959244 -0.931595 0.350614    0 0
  v -131.615 71.9645 41.5883    -0.0974678 -0.959165 0.265523    0 0
  v -131.119 74.2166 47.5221    -0.0953875 -0.906668 0.41092    0 0
  v -137.946 103.68 39.7645    -0.38635 0.894949 0.22316    0 0
  v -140.194 103.003 37.7966    -0.480641 0.861091 0.165852    0 0
  v -141.669 101.6 39.7646    -0.553419 0.796965 0.242019    0 0
  v -140.528 103.292 33.5791    -0.48746 0.872707 0.0276444    0 0
  v -142.299 102.017 35.7224    -0.569825 0.815484 0.101416    0 0
  v -138.403 104.19 35.7223    -0.392902 0.914708 0.0945336    0 0
  v -145.545 99.2223 35.7231    -0.725559 0.680665 0.101284    0 0
  v -143.734 100.541 37.7971    -0.639103 0.748727 0.175941    0 0
  v -144.156 100.749 33.5792    -0.656036 0.754256 0.0267219    0 0
  v -144.795 98.9548 39.7659    -0.694447 0.672159 0.256798    0 0
  v -146.535 97.6121 37.7989    -0.782686 0.5965 0.177735    0 0
  v -147.119 95.9784 39.7684    -0.82485 0.498824 0.266076    0 0
  v -147.009 97.6659 33.5798    -0.807666 0.589334 0.0189805    0 0
  v -147.94 96.0111 35.7228    -0.86479 0.493004 0.0953176    0 0
  v -149.412 92.4361 35.7074    -0.961786 0.254517 0.100943    0 0
  v -148.457 94.3344 37.793    -0.906652 0.382426 0.178137    0 0
  v -148.952 94.1955 33.5769    -0.926804 0.375259 0.014682    0 0
  v -148.552 92.7329 39.765    -0.924797 0.262957 0.274962    0 0
  v -149.444 90.6972 37.7602    -0.969779 0.15257 0.190397    0 0
  v -149.137 89.5076 39.8593    -0.948161 0.202387 0.245011    0 0
  v -149.94 90.4312 33.5624    -0.991299 0.129867 0.0214461    0 0
  v -149.935 88.5478 35.5845    -0.995884 0.0126113 0.0897607    0 0
  v -149.533 84.5596 35.14    -0.967002 -0.249258 0.0527015    0 0
  v -149.746 86.4628 36.9158    -0.997356 -0.0712161 0.0144651    0 0
  v -149.981 86.5125 33.3757    -0.993389 -0.113982 0.013649    0 0
  v -149.998 85.7436 38.5906    -0.860859 0.143822 -0.488095    0 0
  v -149.708 87.5687 38.7885    -0.982193 0.187778 -0.00597346    0 0
  v -149.515 84.4643 37.6689    -0.936965 -0.242935 -0.251156    0 0
  v -149.645 87.7336 40.5448    -0.810737 0.585342 -0.00901942    0 0
  v -148.774 82.6894 36.9169    -0.907147 -0.42081 0.00166184    0 0
  v -148.161 81.5811 38.8041    -0.769756 -0.63743 -0.0340527    0 0
  v -149.296 83.0593 38.6134    -0.710508 -0.538173 -0.453375    0 0
  v -148.987 82.6725 33.3753    -0.924481 -0.381087 0.0103457    0 0
  v -147.942 80.8347 35.5827    -0.865507 -0.494766 0.0781296    0 0
  v -145.538 77.6009 35.7043    -0.727556 -0.678481 0.101622    0 0
  v -146.463 79.142 37.756    -0.772929 -0.610505 0.172814    0 0
  v -147.002 79.1572 33.5611    -0.808105 -0.588644 0.0215535    0 0
  v -146.742 80.1658 39.8611    -0.722109 -0.662302 0.199788    0 0
  v -144.684 77.7297 39.7587    -0.692608 -0.677469 0.24765    0 0
  v -147.972 81.332 40.6018    -0.500603 -0.865279 -0.0262671    0 0
  v -143.72 76.268 37.7885    -0.639819 -0.749009 0.172096    0 0
  v -141.658 75.2094 39.7639    -0.550297 -0.799806 0.239756    0 0
  v -144.154 76.0741 33.5755    -0.65648 -0.753854 0.027164    0 0
  v -142.298 74.8062 35.7205    -0.570328 -0.815156 0.101229    0 0
  v -138.403 72.6332 35.7223    -0.392902 -0.914708 0.0945336    0 0
  v -140.194 73.8204 37.7966    -0.480514 -0.861164 0.165843    0 0
  v -140.528 73.5312 33.5791    -0.487507 -0.872681 0.0276451    0 0
  v -137.946 73.1426 39.7645    -0.38635 -0.894949 0.22316    0 0
  v -136.138 72.0756 37.7966    -0.294366 -0.943324 0.153256    0 0
  v -133.842 71.8577 39.7645    -0.195873 -0.958211 0.208484    0 0
  v -136.353 71.7401 33.5791    -0.297061 -0.954514 0.0256412    0 0
  v -134.082 71.288 35.7223    -0.198604 -0.976059 0.0886827    0 0
  v -131.779 71.1875 37.7966    -0.0994512 -0.984209 0.146432    0 0
  v -131.854 70.8255 33.5791    -0.100364 -0.994647 0.024568    0 0
  v -138.482 104.28 31.4043    -0.394152 0.918185 -0.0397589    0 0
  v -140.384 103.166 29.2297    -0.48575 0.867986 -0.103186    0 0
  v -142.407 102.087 31.4044    -0.574877 0.817078 -0.0436    0 0
  v -139.839 102.688 25.0062    -0.478245 0.85187 -0.213537    0 0
  v -141.997 101.804 27.0865    -0.568631 0.805559 -0.166531    0 0
  v -138.184 103.94 27.0865    -0.390563 0.90764 -0.153786    0 0
  v -145.178 99.0119 27.0865    -0.727893 0.66134 -0.181112    0 0
  v -143.972 100.639 29.2297    -0.655317 0.746876 -0.112852    0 0
  v -143.279 100.258 25.0062    -0.642704 0.730404 -0.231174    0 0
  v -145.67 99.2365 31.4045    -0.736724 0.674263 -0.051049    0 0
  v -146.793 97.5462 29.2297    -0.806539 0.577866 -0.124763    0 0
  v -148.067 95.9179 31.4044    -0.873715 0.482645 -0.0606204    0 0
  v -145.996 97.2683 25.0062    -0.788146 0.562538 -0.249754    0 0
  v -147.517 95.7422 27.0865    -0.86026 0.470994 -0.195238    0 0
  v -148.947 92.156 27.0865    -0.947502 0.245635 -0.204702    0 0
  v -148.711 94.0579 29.2294    -0.920435 0.367151 -0.134163    0 0
  v -147.85 93.8839 25.0062    -0.896022 0.356352 -0.264873    0 0
  v -149.53 92.2728 31.4014    -0.965699 0.251821 -0.0633394    0 0
  v -149.681 90.3265 29.228    -0.982455 0.12602 -0.137485    0 0
  v -150.026 88.4387 31.3768    -0.997994 0.00554894 -0.0630709    0 0
  v -148.789 90.2621 25.0062    -0.954174 0.121588 -0.273438    0 0
  v -149.425 88.4115 27.0865    -0.978081 -8.73913e-007 -0.208226    0 0
  v -148.947 84.6669 27.0865    -0.947108 -0.245535 -0.206638    0 0
  v -149.685 86.5085 29.2093    -0.982181 -0.123182 -0.141942    0 0
  v -148.789 86.5608 25.0062    -0.954174 -0.121588 -0.273439    0 0
  v -149.554 84.5847 31.2879    -0.965348 -0.25009 -0.0745503    0 0
  v -148.714 82.7696 29.2093    -0.919433 -0.368313 -0.137798    0 0
  v -148.067 80.9096 31.3764    -0.872343 -0.48516 -0.060307    0 0
  v -147.85 82.939 25.0062    -0.896022 -0.356352 -0.264872    0 0
  v -147.517 81.0807 27.0865    -0.860233 -0.47098 -0.195389    0 0
  v -145.178 77.811 27.0865    -0.727898 -0.661344 -0.181078    0 0
  v -146.792 79.2767 29.2279    -0.806495 -0.578011 -0.124373    0 0
  v -145.996 79.5546 25.0062    -0.788146 -0.562537 -0.249755    0 0
  v -145.669 77.5865 31.4007    -0.736992 -0.67401 -0.0505355    0 0
  v -143.972 76.1838 29.2293    -0.655347 -0.746858 -0.112793    0 0
  v -142.406 74.7357 31.404    -0.574935 -0.817039 -0.043558    0 0
  v -143.279 76.5645 25.0062    -0.642705 -0.730403 -0.231174    0 0
  v -141.997 75.0188 27.0865    -0.568632 -0.80556 -0.166528    0 0
  v -138.184 72.8832 27.0865    -0.390563 -0.90764 -0.153786    0 0
  v -140.384 73.6572 29.2297    -0.485751 -0.867985 -0.103186    0 0
  v -139.839 74.1345 25.0062    -0.478244 -0.851871 -0.213538    0 0
  v -138.482 72.5432 31.4043    -0.394152 -0.918185 -0.0397589    0 0
  v -136.26 71.8863 29.2297    -0.296067 -0.950356 -0.0957481    0 0
  v -134.124 71.1874 31.4043    -0.199145 -0.979258 -0.0373603    0 0
  v -135.91 72.44 25.0062    -0.2926 -0.935384 -0.198602    0 0
  v -133.967 71.5676 27.0865    -0.197597 -0.969551 -0.14466    0 0
  v -131.822 70.9833 29.2297    -0.100016 -0.990745 -0.0917638    0 0
  v -131.701 71.5805 25.0062    -0.0987913 -0.976699 -0.190522    0 0
  v -137.595 103.266 23.0204    -0.382938 0.885292 -0.263848    0 0
  v -138.969 101.927 21.1642    -0.460269 0.815406 -0.351092    0 0
  v -141.186 101.246 23.0204    -0.554049 0.782382 -0.284444    0 0
  v -137.701 100.817 17.9815    -0.407408 0.714952 -0.56821    0 0
  v -139.976 100.412 19.4729    -0.513939 0.721806 -0.463533    0 0
  v -136.715 102.261 19.4729    -0.360295 0.825419 -0.434593    0 0
  v -142.751 97.9554 19.4729    -0.645342 0.582412 -0.494297    0 0
  v -142.173 99.6528 21.1642    -0.612943 0.69422 -0.377305    0 0
  v -140.563 98.7704 17.9815    -0.531325 0.598337 -0.599739    0 0
  v -144.204 98.5881 23.0204    -0.705169 0.639074 -0.307118    0 0
  v -144.726 96.8334 21.1642    -0.745251 0.530209 -0.404326    0 0
  v -146.437 95.459 23.0204    -0.828899 0.45288 -0.328368    0 0
  v -142.876 96.1996 17.9815    -0.633569 0.44827 -0.63059    0 0
  v -144.824 95.036 19.4728    -0.749108 0.407677 -0.522146    0 0
  v -146.104 91.8015 19.472    -0.81434 0.209423 -0.541287    0 0
  v -146.479 93.6228 21.1642    -0.840991 0.333636 -0.425935    0 0
  v -144.48 93.2405 17.9806    -0.703597 0.277374 -0.654229    0 0
  v -147.807 92.0148 23.0204    -0.909352 0.235299 -0.343095    0 0
  v -147.37 90.1742 21.1638    -0.891609 0.11362 -0.43832    0 0
  v -148.266 88.4115 23.0204    -0.937473 -1.19157e-006 -0.348059    0 0
  v -145.296 90.0365 17.977    -0.738448 0.0955629 -0.667505    0 0
  v -146.543 88.4036 19.477    -0.838191 0.00750466 -0.545326    0 0
  v -146.175 85.0093 19.5107    -0.826352 -0.213205 -0.521235    0 0
  v -147.382 86.6449 21.1703    -0.895498 -0.110809 -0.431052    0 0
  v -145.415 86.7482 18.0421    -0.753849 -0.0762952 -0.652603    0 0
  v -147.807 84.8081 23.0204    -0.910422 -0.235574 -0.340054    0 0
  v -146.49 83.199 21.1703    -0.842955 -0.337533 -0.418925    0 0
  v -146.437 81.364 23.0204    -0.828996 -0.452934 -0.32805    0 0
  v -144.596 83.571 18.0421    -0.709337 -0.300315 -0.637693    0 0
  v -144.834 81.7892 19.477    -0.747133 -0.414851 -0.519317    0 0
  v -142.75 78.8691 19.472    -0.645391 -0.581834 -0.494913    0 0
  v -144.726 79.9904 21.1638    -0.744853 -0.530397 -0.404811    0 0
  v -142.871 80.6314 17.977    -0.631627 -0.449815 -0.631437    0 0
  v -144.204 78.2348 23.0204    -0.705151 -0.639055 -0.307199    0 0
  v -142.173 77.1703 21.1642    -0.612966 -0.694127 -0.37744    0 0
  v -141.186 75.5774 23.0204    -0.554048 -0.78238 -0.284453    0 0
  v -140.562 78.0541 17.9806    -0.531541 -0.59773 -0.600153    0 0
  v -139.975 76.4115 19.4728    -0.514017 -0.721695 -0.463619    0 0
  v -136.715 74.5624 19.4729    -0.360294 -0.82542 -0.434592    0 0
  v -138.969 74.8961 21.1642    -0.460276 -0.815403 -0.351091    0 0
  v -137.702 76.0056 17.9815    -0.407466 -0.714909 -0.568221    0 0
  v -137.595 73.5569 23.0204    -0.382939 -0.885292 -0.263848    0 0
  v -135.35 73.3234 21.1642    -0.283907 -0.900888 -0.328324    0 0
  v -133.657 72.3208 23.0204    -0.194296 -0.948871 -0.248783    0 0
  v -134.534 74.6105 17.9815    -0.256216 -0.802258 -0.539199    0 0
  v -133.194 73.4452 19.4729    -0.184203 -0.892111 -0.412562    0 0
  v -131.508 72.5335 21.1642    -0.0958237 -0.943994 -0.315742    0 0
  v -131.226 73.922 17.9815    -0.0866693 -0.848314 -0.522353    0 0
  v -135.464 100.83 16.7254    -0.301094 0.678367 -0.670194    0 0
  v -135.972 99.312 15.6751    -0.316508 0.541969 -0.77852    0 0
  v -138.254 99.2254 16.7254    -0.416279 0.579025 -0.701029    0 0
  v -133.914 97.5896 14.0746    -0.241373 0.382264 -0.891972    0 0
  v -136.047 97.7313 14.7938    -0.305036 0.414856 -0.857233    0 0
  v -133.894 99.072 14.8144    -0.238634 0.500586 -0.832146    0 0
  v -138.083 95.9261 14.8019    -0.36402 0.326512 -0.872284    0 0
  v -138.366 97.5698 15.6738    -0.396868 0.443723 -0.803495    0 0
  v -135.76 96.169 14.0614    -0.282237 0.316885 -0.905498    0 0
  v -140.684 97.0555 16.7254    -0.509563 0.456583 -0.7293    0 0
  v -140.363 95.3392 15.6761    -0.463825 0.326121 -0.823718    0 0
  v -142.53 94.4336 16.7249    -0.578727 0.312591 -0.753235    0 0
  v -137.47 94.3494 14.0852    -0.328457 0.232755 -0.915391    0 0
  v -139.666 93.6937 14.8068    -0.408869 0.223502 -0.884801    0 0
  v -140.657 91.2258 14.8026    -0.436647 0.117406 -0.891939    0 0
  v -141.767 92.7317 15.6743    -0.508067 0.200252 -0.837715    0 0
  v -138.668 92.2016 14.0895    -0.355535 0.147265 -0.922989    0 0
  v -143.678 91.4916 16.7208    -0.620087 0.157313 -0.768599    0 0
  v -142.477 89.8989 15.6645    -0.528927 0.0937398 -0.843475    0 0
  v -144.113 88.372 16.7461    -0.649857 0.0177828 -0.759848    0 0
  v -139.269 90.0013 14.0829    -0.36576 0.097557 -0.925582    0 0
  v -140.951 88.8976 14.687    -0.462077 0.193833 -0.865398    0 0
  v -140.628 87.7225 13.8703    -0.505758 0.676553 -0.535243    0 0
  v -141.851 87.5936 14.8796    -0.640297 0.257596 -0.723646    0 0
  v -139.46 88.4112 13.8045    -0.332214 0.487983 -0.807159    0 0
  v -142.347 85.4517 15.2962    -0.785417 -0.202792 -0.584804    0 0
  v -143.094 86.782 15.8994    -0.67546 -0.0148179 -0.737248    0 0
  v -141.965 86.3765 14.5402    -0.905254 0.171924 -0.388532    0 0
  v -144.033 85.2707 16.9143    -0.67067 -0.172503 -0.721418    0 0
  v -142.398 84.0737 15.9004    -0.621227 -0.318045 -0.716187    0 0
  v -142.578 82.4007 16.7461    -0.586875 -0.337326 -0.736063    0 0
  v -141.512 84.6271 14.5507    -0.744972 -0.574777 -0.338596    0 0
  v -140.816 83.5813 14.8874    -0.505113 -0.545664 -0.668665    0 0
  v -138.172 83.3966 13.816    -0.166132 -0.643776 -0.746962    0 0
  v -139.357 82.6661 14.689    -0.368471 -0.418991 -0.829865    0 0
  v -139.583 83.6886 13.8965    -0.270396 -0.854379 -0.443759    0 0
  v -138.02 80.8025 14.7966    -0.36398 -0.336421 -0.868527    0 0
  v -140.322 81.4536 15.6639    -0.456329 -0.353589 -0.816541    0 0
  v -137.278 82.1652 14.0769    -0.308449 -0.283804 -0.907917    0 0
  v -140.68 79.7756 16.7208    -0.510534 -0.455762 -0.729133    0 0
  v -138.358 79.2471 15.6713    -0.397712 -0.446155 -0.80173    0 0
  v -138.253 77.5984 16.7249    -0.416634 -0.578834 -0.700976    0 0
  v -135.722 80.5923 14.0598    -0.277262 -0.325743 -0.90389    0 0
  v -136.04 79.0822 14.7932    -0.303306 -0.418432 -0.856107    0 0
  v -133.894 77.7509 14.8144    -0.238635 -0.500588 -0.832145    0 0
  v -135.972 77.511 15.6751    -0.316362 -0.542099 -0.778488    0 0
  v -133.914 79.2334 14.0746    -0.240256 -0.383474 -0.891754    0 0
  v -135.464 75.9927 16.7254    -0.301092 -0.678367 -0.670195    0 0
  v -133.431 76.3421 15.682    -0.209075 -0.630533 -0.747473    0 0
  v -132.535 75.0446 16.7254    -0.157045 -0.748643 -0.644104    0 0
  v -132.203 78.2082 14.1433    -0.17799 -0.467603 -0.865833    0 0
  v -131.743 76.9589 14.838    -0.127641 -0.581314 -0.803605    0 0
  v -130.85 75.7873 15.6837    -0.0695063 -0.679754 -0.730139    0 0
  v -130.458 77.7771 14.1605    -0.0488438 -0.52487 -0.84978    0 0
  v -132.196 97.2726 13.5311    -0.195399 0.352921 -0.915022    0 0
  v -131.706 95.9959 13.0141    -0.168045 0.261993 -0.950327    0 0
  v -133.52 96.0956 13.428    -0.220505 0.289775 -0.931347    0 0
  v -130.67 94.9743 12.6404    -0.0931427 0.177691 -0.979668    0 0
  v -130.444 96.1221 12.8765    -0.0818018 0.259246 -0.962341    0 0
  v -130.038 93.153 12.3487    -0.0555703 0.0746748 -0.995658    0 0
  v -131.326 94.0055 12.5668    -0.11721 0.133908 -0.984038    0 0
  v -132.906 93.3722 12.6909    -0.161196 0.12882 -0.978479    0 0
  v -133.122 94.6554 12.9571    -0.191013 0.206155 -0.959695    0 0
  v -131.541 92.7012 12.4499    -0.102103 0.0840407 -0.991218    0 0
  v -135.241 94.7018 13.469    -0.258852 0.23472 -0.936964    0 0
  v -134.587 93.2946 13.019    -0.223797 0.148194 -0.963303    0 0
  v -136.607 92.8939 13.4953    -0.28713 0.157251 -0.944896    0 0
  v -132.233 91.9907 12.4713    -0.115241 0.0702894 -0.990847    0 0
  v -133.733 91.8401 12.6801    -0.169944 0.0854856 -0.981739    0 0
  v -134.6 90.2936 12.7193    -0.192044 0.0492308 -0.980151    0 0
  v -135.586 91.5162 13.0328    -0.238903 0.0976082 -0.966125    0 0
  v -133.043 90.4489 12.481    -0.130585 0.0463474 -0.990353    0 0
  v -137.435 90.8526 13.4941    -0.304123 0.0825232 -0.949052    0 0
  v -136.056 89.5801 13.0248    -0.246133 0.0534858 -0.967759    0 0
  v -137.809 88.9327 13.4478    -0.268136 0.195188 -0.943401    0 0
  v -133.301 89.367 12.4784    -0.136234 0.0243877 -0.990376    0 0
  v -134.458 88.469 12.6533    -0.170013 0.0126153 -0.985361    0 0
  v -134.073 86.6061 12.5926    -0.143235 -0.0365652 -0.989013    0 0
  v -135.367 87.3904 12.7754    -0.10608 0.0521236 -0.99299    0 0
  v -133.08 87.5145 12.4251    -0.124749 -0.00533368 -0.992174    0 0
  v -136.775 86.9011 12.6619    0.284121 0.342466 -0.89554    0 0
  v -136.935 87.889 12.9897    -0.0747539 0.303657 -0.949844    0 0
  v -135.775 86.2529 12.7565    0.088319 0.0188602 -0.995914    0 0
  v -138.444 87.885 13.078    -0.049716 0.72018 -0.692004    0 0
  v -134.868 85.4102 12.7764    -0.0759908 -0.104893 -0.991576    0 0
  v -136.065 84.4767 12.9975    0.0233357 -0.348202 -0.937129    0 0
  v -136.376 85.3517 12.6724    0.375485 -0.206092 -0.903625    0 0
  v -132.802 86.3888 12.4251    -0.110285 -0.0536112 -0.992453    0 0
  v -133.577 84.9377 12.6499    -0.147065 -0.0897823 -0.985044    0 0
  v -132.876 83.4259 12.6868    -0.159324 -0.12939 -0.97871    0 0
  v -134.486 83.421 13.0089    -0.207662 -0.172599 -0.962853    0 0
  v -132.202 84.8074 12.4673    -0.111649 -0.0738048 -0.991003    0 0
  v -136.399 83.3985 13.4474    -0.188694 -0.332081 -0.924185    0 0
  v -135.159 82.0022 13.4644    -0.252637 -0.239607 -0.937424    0 0
  v -137.454 84.0512 13.1042    0.164507 -0.750486 -0.640084    0 0
  v -133.101 82.1458 12.9551    -0.188407 -0.207111 -0.960004    0 0
  v -133.511 80.7155 13.4276    -0.217774 -0.292698 -0.931076    0 0
  v -131.53 84.1133 12.4486    -0.100856 -0.0845796 -0.991299    0 0
  v -131.323 82.8149 12.5663    -0.116423 -0.134308 -0.984077    0 0
  v -130.67 81.8486 12.6404    -0.0929723 -0.177701 -0.979683    0 0
  v -130.038 83.67 12.3487    -0.0554212 -0.0747353 -0.995662    0 0
  v -130.444 80.7008 12.8765    -0.081801 -0.259239 -0.962343    0 0
  v -131.706 80.8271 13.0141    -0.16789 -0.262279 -0.950275    0 0
  v -132.196 79.5503 13.5311    -0.1954 -0.352921 -0.915022    0 0
  v -130.975 79.7618 13.2249    -0.126869 -0.34295 -0.930747    0 0
  v -130.982 78.7637 13.6493    -0.105425 -0.438087 -0.892729    0 0
  v -130.202 79.4877 13.2609    -0.0460703 -0.384169 -0.922113    0 0
  v -161.711 83.0171 36.0258    -0.957367 0.177197 -0.228145    0 0
  v -161.251 83.0029 35.276    -0.654438 0.0648551 -0.753329    0 0
  v -161.278 82.2053 35.5245    -0.609299 -0.452535 -0.651128    0 0
  v -161.728 82.3343 36.2378    -0.949474 -0.270221 -0.159625    0 0
  v -160.235 83.6914 34.9826    -0.241066 0.519746 -0.819604    0 0
  v -160.374 82.9831 34.8335    -0.275297 -0.0278038 -0.960957    0 0
  v -160.973 83.7089 35.38    -0.532198 0.591374 -0.605839    0 0
  v -159.502 82.2783 34.9536    0.0969091 -0.47764 -0.873195    0 0
  v -160.401 82.1856 35.082    -0.235845 -0.495559 -0.835942    0 0
  v -159.485 82.9611 34.7416    0.081277 -0.0813826 -0.993363    0 0
  v -161.004 81.6103 36.0291    -0.418293 -0.837426 -0.35178    0 0
  v -160.266 81.5927 35.6316    -0.140396 -0.838753 -0.5261    0 0
  v -147.9 84.6201 45.1129    -0.0843604 -0.00199923 0.996433    0 0
  v -148.875 83.519 44.8362    -0.0354843 -0.39703 0.917119    0 0
  v -147.669 82.4947 44.2373    -0.132388 -0.670868 0.729664    0 0
  v -151.461 83.4685 44.7041    -0.0859064 -0.405056 0.910247    0 0
  v -150.072 82.6694 44.2071    -0.0367321 -0.704423 0.70883    0 0
  v -150.343 84.4531 44.9941    -0.0682245 0.0382093 0.996938    0 0
  v -150.294 81.7707 42.2966    -0.0698896 -0.995474 0.0643941    0 0
  v -148.952 81.9551 43.3131    -0.0939901 -0.889153 0.447853    0 0
  v -151.314 82.0778 43.2971    -0.0350281 -0.907516 0.418555    0 0
  v -148.225 81.459 42.1159    -0.23873 -0.960142 0.145382    0 0
  v -149.635 81.8459 41.1013    -0.196254 -0.947983 -0.250624    0 0
  v -149.315 82.2516 39.8215    -0.42864 -0.801514 -0.416945    0 0
  v -151.609 81.9869 41.1921    0.0107404 -0.949845 -0.312537    0 0
  v -150.989 82.4877 40.1968    -0.07542 -0.809792 -0.58185    0 0
  v -151.687 84.1865 39.1123    -0.0497888 -0.0680339 -0.99644    0 0
  v -150.575 83.2534 39.3323    -0.236337 -0.558091 -0.795411    0 0
  v -152.2 83.2412 39.4415    0.0877562 -0.529206 -0.843943    0 0
  v -150.283 84.3067 38.7523    -0.503304 -0.14646 -0.851607    0 0
  v -151.115 85.2715 39.2563    -0.29813 0.38159 -0.874933    0 0
  v -150.44 86.4915 39.7343    -0.625271 0.594292 -0.50582    0 0
  v -152.658 85.0273 39.3021    0.0407092 0.434611 -0.899698    0 0
  v -151.919 85.9881 39.9942    -0.150843 0.720411 -0.676944    0 0
  v -151.659 86.9047 41.9995    -0.215689 0.976447 0.0053978    0 0
  v -150.976 86.8601 40.9114    -0.351833 0.874675 -0.333401    0 0
  v -152.757 86.4522 40.8436    -0.0970388 0.910629 -0.401668    0 0
  v -149.835 87.5288 41.9881    -0.492522 0.857787 0.147052    0 0
  v -150.291 86.9608 43.1231    -0.272985 0.857679 0.435736    0 0
  v -148.778 86.6835 44.1501    -0.30203 0.594276 0.745395    0 0
  v -152.461 86.5432 42.9486    -0.189894 0.910332 0.367746    0 0
  v -151.003 86.1698 44.0045    -0.167415 0.721673 0.671684    0 0
  v -149.412 85.5285 44.7602    -0.120118 0.419983 0.899548    0 0
  v -151.92 85.2547 44.5647    -0.167515 0.465383 0.869113    0 0
  v -152.961 84.2692 44.6555    -0.220154 0.0381045 0.974721    0 0
  v -154.026 83.2983 44.1735    -0.241368 -0.406399 0.881239    0 0
  v -152.595 82.6223 43.9637    -0.0968825 -0.713011 0.694427    0 0
  v -156.398 83.0452 43.1265    -0.432252 -0.402223 0.807078    0 0
  v -154.999 82.4411 43.2484    -0.214797 -0.712516 0.667969    0 0
  v -155.449 84.0204 43.8315    -0.422244 0.0331063 0.905877    0 0
  v -154.561 81.666 41.5808    0.0683002 -0.996195 0.0541406    0 0
  v -153.647 81.9928 42.8875    -0.0551921 -0.911088 0.408499    0 0
  v -155.805 81.7993 42.0019    -0.125237 -0.911569 0.391609    0 0
  v -152.485 81.8014 42.1558    0.0233668 -0.998734 0.0445473    0 0
  v -153.546 81.9121 40.8721    0.157328 -0.939996 -0.302745    0 0
  v -152.777 82.4618 40.091    0.151814 -0.792728 -0.590369    0 0
  v -155.326 81.7277 40.1369    0.258387 -0.931366 -0.256501    0 0
  v -154.446 82.2985 39.5918    0.334413 -0.773789 -0.537977    0 0
  v -154.638 83.8112 38.4685    0.459885 -0.0270315 -0.887567    0 0
  v -153.774 83.0967 39.135    0.326406 -0.503685 -0.79985    0 0
  v -155.199 82.8662 38.4639    0.533015 -0.485759 -0.692772    0 0
  v -153.228 84.0339 38.9755    0.219767 -0.0399047 -0.974736    0 0
  v -154.141 84.8047 38.9426    0.255208 0.441369 -0.860269    0 0
  v -153.555 85.7198 39.7783    0.058193 0.733008 -0.677727    0 0
  v -155.473 84.5196 38.2159    0.449964 0.431633 -0.781809    0 0
  v -155.045 85.4567 39.1817    0.210466 0.72709 -0.653486    0 0
  v -155.439 86.2981 40.9793    -0.15492 0.986074 -0.0604771    0 0
  v -154.464 86.1823 40.3911    0.0122308 0.911588 -0.410923    0 0
  v -156.013 85.8611 39.5167    0.0609987 0.906973 -0.416747    0 0
  v -153.626 86.5798 41.6973    -0.137761 0.989928 -0.0326133    0 0
  v -154.565 86.2629 42.4065    -0.256031 0.90666 0.335284    0 0
  v -153.373 85.8803 43.651    -0.243675 0.73224 0.635961    0 0
  v -156.492 85.9327 41.3817    -0.389145 0.88323 0.261668    0 0
  v -155.597 85.5993 42.8382    -0.401202 0.711729 0.57661    0 0
  v -154.394 85.0064 43.9811    -0.338676 0.451992 0.825228    0 0
  v -156.673 84.6986 42.8784    -0.541492 0.437193 0.718087    0 0
  v -157.672 83.698 42.4457    -0.629895 0.0380532 0.775748    0 0
  v -158.452 82.7499 41.5381    -0.598168 -0.395477 0.696988    0 0
  v -157.151 82.1999 42.0052    -0.362298 -0.711071 0.602593    0 0
  v -160.146 82.4646 39.6351    -0.707181 -0.384425 0.593391    0 0
  v -158.981 81.9588 40.334    -0.469618 -0.709988 0.524762    0 0
  v -159.545 83.3333 40.6029    -0.763782 0.0596672 0.64271    0 0
  v -158.03 81.2855 39.1571    0.0379704 -0.996812 0.070169    0 0
  v -157.688 81.5872 40.6336    -0.206776 -0.912282 0.353532    0 0
  v -159.279 81.4067 38.993    -0.267696 -0.912521 0.309264    0 0
  v -156.423 81.4692 40.5457    0.0642003 -0.99566 0.0673737    0 0
  v -156.882 81.5247 39.0111    0.297637 -0.933176 -0.201482    0 0
  v -155.93 82.0741 38.7141    0.462116 -0.766484 -0.44604    0 0
  v -158.228 81.3551 37.6987    0.283067 -0.943644 -0.17149    0 0
  v -157.217 81.8513 37.5811    0.493007 -0.787824 -0.369158    0 0
  v -156.958 83.1756 36.5652    0.733423 -0.0708631 -0.676069    0 0
  v -156.436 82.5937 37.4819    0.64667 -0.502466 -0.573887    0 0
  v -157.52 82.3357 36.3996    0.650226 -0.556908 -0.516778    0 0
  v -155.881 83.5134 37.6187    0.65329 -0.0335844 -0.756362    0 0
  v -156.637 84.1292 37.1643    0.572285 0.419529 -0.704618    0 0
  v -156.374 85.0775 38.184    0.316352 0.720836 -0.616699    0 0
  v -157.647 83.7164 36.0309    0.614071 0.397107 -0.682072    0 0
  v -157.529 84.5884 36.9286    0.370028 0.718102 -0.589413    0 0
  v -158.487 85.3 38.2002    -0.214718 0.960216 -0.178556    0 0
  v -157.386 85.3633 38.2171    0.083815 0.901402 -0.424794    0 0
  v -158.546 84.8068 36.7771    0.120624 0.894718 -0.430034    0 0
  v -157.074 85.8743 39.7683    -0.21717 0.968786 -0.119542    0 0
  v -158.192 85.4257 39.8395    -0.469748 0.870654 0.145938    0 0
  v -157.595 85.2034 41.4751    -0.564539 0.694338 0.446308    0 0
  v -159.597 84.8583 38.0713    -0.46416 0.884129 0.0535893    0 0
  v -159.293 84.6959 39.6816    -0.628824 0.711604 0.31337    0 0
  v -158.653 84.2853 41.2204    -0.689458 0.449185 0.568226    0 0
  v -160.274 83.8453 39.2665    -0.757464 0.482943 0.439334    0 0
  v -161.027 82.9975 38.5893    -0.856496 0.085835 0.508966    0 0
  v -161.383 82.2586 37.721    -0.83137 -0.380917 0.404631    0 0
  v -160.473 81.7636 38.4909    -0.558819 -0.706584 0.43412    0 0
  v -161.374 81.7646 36.7995    -0.701439 -0.70545 0.101608    0 0
  v -161.768 82.7614 36.8861    -0.989076 0.0403203 0.141784    0 0
  v -160.331 81.2902 36.3864    -0.174998 -0.958473 -0.225176    0 0
  v -160.519 81.3364 37.3471    -0.371771 -0.91345 0.165516    0 0
  v -159.393 81.1591 37.6541    -0.0132933 -0.99921 0.0374508    0 0
  v -159.367 81.2989 36.4518    0.173016 -0.950222 -0.259123    0 0
  v -158.349 81.6794 36.4248    0.439501 -0.82198 -0.362199    0 0
  v -159.371 81.7093 35.5127    0.201377 -0.803869 -0.55968    0 0
  v -158.854 82.6779 34.9298    0.339154 -0.270184 -0.901096    0 0
  v -158.51 82.1643 35.4675    0.490902 -0.619948 -0.612111    0 0
  v -157.912 82.8739 35.559    0.696469 -0.148089 -0.70214    0 0
  v -158.546 83.3634 35.1072    0.495211 0.287496 -0.819825    0 0
  v -158.501 84.1237 35.722    0.378711 0.691772 -0.614841    0 0
  v -159.373 83.6579 34.9139    0.154135 0.490368 -0.857777    0 0
  v -160.354 84.1639 35.5057    -0.304974 0.798631 -0.518825    0 0
  v -159.461 84.3002 35.5505    0.0678179 0.830661 -0.552632    0 0
  v -159.615 84.7442 36.6234    -0.188126 0.953202 -0.236673    0 0
  v -160.612 84.3377 36.4458    -0.495682 0.862893 -0.0985591    0 0
  v -160.625 84.208 37.7881    -0.648157 0.735613 0.196892    0 0
  v -161.376 83.7131 36.2007    -0.756627 0.644996 -0.107218    0 0
  v -161.419 83.4577 37.3607    -0.839761 0.482895 0.248221    0 0
  v -142.12 84.7608 0.880056    -0.629552 -0.00510627 -0.776942    0 0
  v -141.692 84.8243 0.642664    -0.330392 0.0714864 -0.941133    0 0
  v -141.598 84.4504 0.663963    -0.275252 -0.323893 -0.905168    0 0
  v -142.036 84.4307 0.898848    -0.565334 -0.373574 -0.735418    0 0
  v -141.238 85.2315 0.680483    -0.0448404 0.472256 -0.88032    0 0
  v -141.178 84.8842 0.563925    0.0031898 0.134358 -0.990928    0 0
  v -141.693 85.1786 0.749994    -0.3284 0.446199 -0.832502    0 0
  v -140.593 84.5982 0.678083    0.356596 -0.116515 -0.926965    0 0
  v -141.083 84.5104 0.585223    0.0490961 -0.232565 -0.971341    0 0
  v -140.676 84.9282 0.659292    0.316727 0.17785 -0.931694    0 0
  v -141.428 84.1304 0.80962    -0.181253 -0.641941 -0.745023    0 0
  v -140.973 84.1832 0.740102    0.0837302 -0.557784 -0.825752    0 0
  v -141.887 85.4525 13.8716    -0.97044 -0.241041 -0.0120364    0 0
  v -141.565 84.791 12.9298    -0.70003 -0.705394 0.111253    0 0
  v -140.694 84.2125 13.5787    -0.472115 -0.871885 -0.130093    0 0
  v -141.974 84.6893 10.9239    -0.684714 -0.709105 0.168337    0 0
  v -141.058 84.2913 11.8303    -0.41632 -0.900665 0.124423    0 0
  v -142.147 85.3409 12.0161    -0.954386 -0.223005 0.198534    0 0
  v -139.304 83.9456 11.4348    0.125054 -0.992147 -0.00254004    0 0
  v -139.948 84.0029 12.5153    -0.18575 -0.982588 -0.00414832    0 0
  v -140.425 83.9453 10.6493    -0.172691 -0.980766 0.0909759    0 0
  v -138.741 83.8904 12.9434    0.0676773 -0.969092 -0.237237    0 0
  v -138.242 84.2138 12.0453    0.418911 -0.882394 -0.21423    0 0
  v -137.241 84.6871 12.4514    0.537164 -0.612865 -0.579527    0 0
  v -138.797 84.1325 10.3395    0.461994 -0.885271 -0.0534492    0 0
  v -137.971 84.6494 11.1294    0.722047 -0.65757 -0.215057    0 0
  v -137.619 85.8661 10.9881    0.910453 0.212112 -0.355083    0 0
  v -137.319 85.3001 11.7651    0.83656 -0.284285 -0.468348    0 0
  v -137.904 85.1571 10.1495    0.933331 -0.288698 -0.213417    0 0
  v -136.902 86.0462 12.2647    0.676394 0.157789 -0.71944    0 0
  v -137.648 86.5679 11.7317    0.650626 0.59334 -0.473955    0 0
  v -137.906 87.2524 12.4122    0.311164 0.739807 -0.596541    0 0
  v -138.211 86.3491 10.0937    0.729299 0.636601 -0.250724    0 0
  v -138.561 86.9309 11.0437    0.455535 0.847039 -0.273886    0 0
  v -140.169 87.2917 11.309    -0.137602 0.984132 -0.112025    0 0
  v -139.063 87.3794 11.9618    0.152347 0.94401 -0.292637    0 0
  v -139.565 87.1124 10.2001    0.196725 0.967126 -0.16114    0 0
  v -139.718 87.6549 12.8858    -0.196246 0.922441 -0.332551    0 0
  v -140.774 87.1884 12.4318    -0.460558 0.88198 -0.0999899    0 0
  v -141.391 86.8978 13.5394    -0.74445 0.633589 -0.210617    0 0
  v -141.193 86.9253 10.5099    -0.439641 0.897929 -0.0209649    0 0
  v -141.648 86.5727 11.7445    -0.694172 0.718153 0.0488084    0 0
  v -141.899 86.0788 12.8964    -0.932259 0.354431 0.0726048    0 0
  v -142.281 85.8812 10.8682    -0.916985 0.380676 0.119267    0 0
  v -142.513 85.1698 9.82273    -0.965297 -0.224681 0.133113    0 0
  v -142.262 84.5281 8.63073    -0.693697 -0.711156 0.114201    0 0
  v -141.457 84.1619 9.70046    -0.419466 -0.900514 0.114553    0 0
  v -142.423 84.365 6.30251    -0.697167 -0.711682 0.0864082    0 0
  v -141.7 84.0144 7.36722    -0.423704 -0.90129 0.0902859    0 0
  v -142.713 84.9801 7.47173    -0.970459 -0.228258 0.0781519    0 0
  v -140.059 83.6962 7.11336    0.129107 -0.990826 0.0399264    0 0
  v -140.765 83.8137 8.41178    -0.176351 -0.981192 0.0784993    0 0
  v -140.995 83.6834 6.09598    -0.178461 -0.98169 0.0666012    0 0
  v -139.75 83.8298 9.41283    0.129681 -0.990884 0.036497    0 0
  v -139.189 83.9934 8.16497    0.46568 -0.884854 -0.0132668    0 0
  v -138.449 84.5058 9.19518    0.746521 -0.658625 -0.0944463    0 0
  v -139.49 83.855 5.86614    0.465739 -0.884868 -0.009786    0 0
  v -138.807 84.3441 6.92541    0.750042 -0.658579 -0.0609174    0 0
  v -138.47 85.4637 6.82376    0.960258 0.226154 -0.163585    0 0
  v -138.322 84.9774 8.01371    0.948654 -0.287645 -0.13159    0 0
  v -138.66 84.794 5.72794    0.950532 -0.287564 -0.117455    0 0
  v -138.101 85.6742 9.08165    0.952275 0.223117 -0.208307    0 0
  v -138.615 86.1216 7.95039    0.742705 0.643927 -0.183705    0 0
  v -139.012 86.6961 9.08035    0.478759 0.858681 -0.182914    0 0
  v -138.94 85.8856 5.66642    0.744265 0.645154 -0.172759    0 0
  v -139.345 86.4424 6.80718    0.482544 0.861178 -0.159761    0 0
  v -140.848 86.7736 6.93995    -0.126705 0.986443 -0.104285    0 0
  v -139.923 86.854 8.00666    0.202989 0.96916 -0.139728    0 0
  v -140.189 86.5838 5.71234    0.203091 0.968959 -0.140972    0 0
  v -140.575 87.0422 9.24441    -0.127316 0.987136 -0.0967142    0 0
  v -141.499 86.6743 8.25347    -0.441092 0.895857 -0.0536388    0 0
  v -142.02 86.3522 9.58564    -0.694383 0.719467 0.0141093    0 0
  v -141.694 86.4122 5.94217    -0.443613 0.893276 -0.072571    0 0
  v -142.238 86.1127 7.24898    -0.698445 0.715236 -0.0247528    0 0
  v -142.555 85.6723 8.5674    -0.925905 0.375012 0.0454524    0 0
  v -142.702 85.4566 6.24099    -0.928955 0.370056 0.0100371    0 0
  v -142.817 84.8006 5.23011    -0.9719 -0.230383 0.0483149    0 0
  v -142.512 84.2348 4.20634    -0.700928 -0.711357 0.0516919    0 0
  v -141.858 83.8853 5.1286    -0.426853 -0.901533 0.0709588    0 0
  v -142.498 84.1813 2.54382    -0.707122 -0.705432 -0.0484165    0 0
  v -141.957 83.8232 3.22996    -0.434824 -0.900352 0.0171706    0 0
  v -142.831 84.6587 3.32672    -0.97197 -0.2344 -0.0182202    0 0
  v -140.54 83.5478 3.004    0.117741 -0.992324 -0.0378158    0 0
  v -141.178 83.597 4.00908    -0.183412 -0.98237 0.0361855    0 0
  v -141.33 83.6211 2.36295    -0.19857 -0.978202 -0.0607577    0 0
  v -140.304 83.5836 4.88555    0.126998 -0.991589 0.0249507    0 0
  v -139.77 83.7577 3.79411    0.460821 -0.8862 -0.0478812    0 0
  v -139.117 84.198 4.70992    0.748161 -0.659295 -0.0747305    0 0
  v -140.095 83.7625 2.17427    0.43834 -0.879986 -0.182985    0 0
  v -139.455 84.1091 2.84787    0.734073 -0.659727 -0.160926    0 0
  v -139.162 85.0781 2.76632    0.937924 0.214182 -0.272809    0 0
  v -138.993 84.6365 3.66892    0.942651 -0.290035 -0.165191    0 0
  v -139.41 84.5348 2.07211    0.895082 -0.291539 -0.33739    0 0
  v -138.797 85.2593 4.61605    0.958144 0.22464 -0.177472    0 0
  v -139.255 85.6574 3.61134    0.738369 0.639282 -0.214779    0 0
  v -139.626 86.1865 4.59782    0.481016 0.859531 -0.172712    0 0
  v -139.639 85.4309 2.02149    0.705618 0.607181 -0.365288    0 0
  v -139.919 85.9237 2.74547    0.471609 0.847208 -0.24459    0 0
  v -141.22 86.2092 2.85381    -0.136912 0.974438 -0.178117    0 0
  v -140.423 86.31 3.65016    0.199105 0.96433 -0.174426    0 0
  v -140.666 86.0027 2.04772    0.184309 0.939669 -0.288189    0 0
  v -141.051 86.5 4.72113    -0.129106 0.984253 -0.120738    0 0
  v -141.831 86.1493 3.86513    -0.44841 0.887778 -0.103826    0 0
  v -142.367 85.8737 5.01649    -0.701679 0.710869 -0.0480793    0 0
  v -141.902 85.8612 2.2364    -0.460336 0.865544 -0.197294    0 0
  v -142.421 85.6378 3.12755    -0.70791 0.698591 -0.104087    0 0
  v -142.773 85.2557 4.14875    -0.931226 0.36338 -0.0278105    0 0
  v -142.727 85.0773 2.4932    -0.930438 0.341638 -0.132549    0 0
  v -142.693 84.5809 1.95216    -0.94945 -0.240533 -0.201714    0 0
  v -142.338 84.2424 1.46896    -0.689519 -0.651873 -0.315633    0 0
  v -141.973 83.8891 1.86396    -0.452306 -0.880711 -0.140593    0 0
  v -141.872 84.1011 1.06574    -0.445172 -0.733419 -0.51373    0 0
  v -142.375 84.5731 1.16403    -0.774264 -0.224762 -0.591606    0 0
  v -141.064 83.9284 0.965041    0.00200199 -0.790419 -0.612563    0 0
  v -141.446 83.8115 1.32004    -0.232527 -0.919876 -0.315846    0 0
  v -140.804 83.6611 1.66881    0.0868869 -0.971043 -0.222547    0 0
  v -140.506 83.9199 1.17635    0.353 -0.795909 -0.491854    0 0
  v -139.904 84.1267 1.54781    0.66181 -0.628854 -0.408106    0 0
  v -140.461 84.2643 0.850079    0.42707 -0.475921 -0.768837    0 0
  v -140.251 84.8186 0.839336    0.533507 0.085236 -0.84149    0 0
  v -139.975 84.5146 1.10788    0.704952 -0.260997 -0.659487    0 0
  v -139.658 84.9294 1.48847    0.830405 0.174327 -0.529186    0 0
  v -140.149 85.197 1.0692    0.573538 0.48225 -0.662185    0 0
  v -140.286 85.6281 1.46287    0.430139 0.781063 -0.452682    0 0
  v -140.72 85.2884 0.791907    0.285006 0.543418 -0.7896    0 0
  v -141.454 85.4702 0.877516    -0.18673 0.683628 -0.705539    0 0
  v -140.941 85.6345 1.07917    0.137789 0.817991 -0.558484    0 0
  v -141.364 85.863 1.54423    -0.157329 0.925745 -0.343866    0 0
  v -141.882 85.5261 1.22286    -0.472664 0.760837 -0.444653    0 0
  v -142.355 85.3905 1.77902    -0.713872 0.648858 -0.263382    0 0
  v -142.131 85.1252 1.00758    -0.639818 0.445535 -0.626205    0 0
  v -142.511 84.9247 1.43028    -0.876481 0.260864 -0.404637    0 0
  v -150.95 59.9857 82.7372    -0.29892 -0.916417 0.266131    0 0
  v -151.31 59.4773 79.6659    -0.303813 -0.944913 0.121806    0 0
  v -149.574 58.8268 77.13    -0.224541 -0.973984 0.030594    0 0
  v -147.246 58.645 80.7333    -0.2017 -0.968088 0.148738    0 0
  v -152.708 60.0318 79.1041    -0.557908 -0.829577 0.023251    0 0
  v -152.032 59.5391 77.1098    -0.412025 -0.910083 0.0445568    0 0
  v -153.185 60.4332 81.1684    -0.436087 -0.89132 0.123999    0 0
  v -153.933 60.3555 73.1093    -0.432192 -0.901617 -0.0172345    0 0
  v -151.753 59.4308 74.5852    -0.306996 -0.950447 -0.0490194    0 0
  v -153.036 59.9837 75.0881    -0.563002 -0.820481 0.0991919    0 0
  v -147.69 58.4994 73.492    -0.20789 -0.975212 -0.0757879    0 0
  v -151.865 59.8512 71.4094    -0.316595 -0.930635 -0.183541    0 0
  v -155.601 61.3535 71.3086    -0.405532 -0.889647 -0.209934    0 0
  v -158.116 63.1705 69.743    -0.457931 -0.813237 -0.35909    0 0
  v -156.096 61.4982 72.4978    -0.496497 -0.851777 0.167231    0 0
  v -158.374 62.6803 71.7451    -0.478787 -0.875919 -0.0594047    0 0
  v -162.486 65.0403 73.3001    -0.545955 -0.837782 -0.00738018    0 0
  v -161.013 64.3183 71.4076    -0.546307 -0.807967 -0.220768    0 0
  v -160.359 63.8181 72.6285    -0.451038 -0.881276 0.141126    0 0
  v -163.875 66.51 71.617    -0.671709 -0.71127 -0.207127    0 0
  v -164.108 66.2874 74.7693    -0.683507 -0.729922 -0.00564383    0 0
  v -165.109 67.558 77.2484    -0.757754 -0.643499 0.108249    0 0
  v -162.855 65.4178 75.3591    -0.429409 -0.897686 0.0988354    0 0
  v -163.48 65.9533 77.3272    -0.569116 -0.817233 0.0907593    0 0
  v -161.421 65.1559 81.2963    -0.54065 -0.82689 0.154758    0 0
  v -163.394 66.3318 79.7976    -0.665167 -0.719369 0.20015    0 0
  v -162.337 65.4974 79.3244    -0.423282 -0.905173 0.0386633    0 0
  v -162.368 66.5397 82.786    -0.63977 -0.685177 0.348177    0 0
  v -159.537 64.4111 83.0577    -0.535525 -0.778568 0.327178    0 0
  v -156.509 63.2265 84.536    -0.453425 -0.787797 0.416872    0 0
  v -159.277 63.9829 81.9147    -0.472438 -0.880799 -0.0315544    0 0
  v -157.138 62.8121 82.6919    -0.490435 -0.854913 0.169108    0 0
  v -154.395 61.4485 83.0109    -0.408382 -0.864547 0.292887    0 0
  v -155.204 61.6315 81.8348    -0.522933 -0.852048 -0.0235545    0 0
  v -155.479 68.8841 79.3959    -0.648705 -0.584356 -0.487555    0 0
  v -156.887 70.5194 78.3169    -0.476871 -0.847 -0.234915    0 0
  v -155.468 69.6096 76.753    -0.666998 -0.741271 0.0750389    0 0
  v -154.277 68.1139 78.072    -0.818086 -0.532595 -0.216973    0 0
  v -159.593 71.1238 78.2358    0.275782 -0.851584 -0.445813    0 0
  v -158.602 71.3663 76.8561    -0.196018 -0.979648 0.0431963    0 0
  v -158.141 70.407 79.4723    -0.0638679 -0.750336 -0.657965    0 0
  v -158.683 70.2897 74.3188    0.0280024 -0.699524 0.71406    0 0
  v -157.183 70.4564 75.2922    -0.435512 -0.824302 0.361739    0 0
  v -159.884 71.0599 75.6427    0.340409 -0.833802 0.434621    0 0
  v -154.495 68.0693 75.4542    -0.775554 -0.512318 0.368845    0 0
  v -155.946 68.7862 74.2176    -0.567881 -0.539009 0.622078    0 0
  v -153.837 60.838 80.5306    -0.695438 -0.678175 -0.23758    0 0
  v -153.155 60.611 78.8368    -0.934207 -0.286475 -0.212578    0 0
  v -152.827 60.0652 77.072    -0.797252 -0.59957 0.0700316    0 0
  v -153.185 62.0625 78.6668    -0.958471 -0.00215445 -0.285181    0 0
  v -153.032 60.9788 77.0305    -0.996758 -0.0342804 0.0727956    0 0
  v -153.963 61.6861 80.1957    -0.768657 -0.119904 -0.628323    0 0
  v -154.447 61.5869 73.9425    -0.66437 -0.0503589 0.745705    0 0
  v -153.418 60.559 75.2943    -0.898334 -0.240596 0.367572    0 0
  v -153.427 62.0142 75.3282    -0.905611 0.0319951 0.4229    0 0
  v -154.394 60.7373 73.6897    -0.660438 -0.630155 0.408321    0 0
  v -156.087 61.8782 73.0297    -0.43197 -0.350915 0.830819    0 0
  v -158.13 62.6874 72.5792    -0.396615 -0.762767 0.510767    0 0
  v -155.933 63.252 73.1962    -0.286266 0.00255436 0.958147    0 0
  v -157.846 63.3569 72.9406    -0.0411359 -0.15234 0.987472    0 0
  v -161.024 65.174 74.1972    0.596757 -0.344635 0.724643    0 0
  v -159.829 63.9089 73.1753    0.0102619 -0.563684 0.825927    0 0
  v -159.45 65.1572 73.3369    0.341489 -0.0685101 0.937386    0 0
  v -161.615 64.6839 73.9412    -0.206414 -0.915728 0.344725    0 0
  v -162.036 65.3232 75.5962    0.448779 -0.836862 0.313463    0 0
  v -162.494 65.4836 77.3583    -0.105297 -0.993767 0.0366126    0 0
  v -161.525 66.487 75.6196    0.940413 -0.180316 0.288288    0 0
  v -161.832 65.9115 77.3202    0.88368 -0.458563 -0.0939647    0 0
  v -160.293 65.3336 80.3658    0.486846 -0.384228 -0.784442    0 0
  v -161.605 65.4137 79.0818    0.417054 -0.830658 -0.368881    0 0
  v -161.12 66.5766 78.903    0.856677 -0.2086 -0.471796    0 0
  v -160.794 64.8383 80.6991    -0.214676 -0.93271 -0.28977    0 0
  v -158.935 64.0946 81.3464    -0.0717052 -0.601665 -0.795524    0 0
  v -157.191 62.8613 81.8511    -0.465273 -0.788696 -0.401844    0 0
  v -158.614 65.3387 81.035    0.225893 -0.156175 -0.961552    0 0
  v -157.018 63.5333 81.41    -0.16148 -0.237088 -0.957974    0 0
  v -155.362 62.0252 81.2576    -0.547343 -0.430342 -0.717789    0 0
  v -155.26 63.3923 80.9495    -0.417183 -0.0856719 -0.904775    0 0
  v -153.885 63.9094 79.9707    -0.757821 -0.0685327 -0.648853    0 0
  v -153.235 64.9955 78.4372    -0.954936 -0.154484 -0.25344    0 0
  v -152.988 63.2302 76.9203    -0.997326 -0.0126527 0.0719757    0 0
  v -153.431 66.5303 76.7831    -0.947283 -0.31098 0.0771103    0 0
  v -154.214 66.9273 79.4234    -0.782979 -0.372823 -0.497943    0 0
  v -154.631 66.8426 74.2283    -0.699993 -0.326253 0.635271    0 0
  v -153.467 64.9497 75.2749    -0.908604 -0.125425 0.398382    0 0
  v -154.348 63.816 73.9441    -0.650979 -0.000287224 0.759096    0 0
  v -155.841 66.1224 73.2524    -0.34607 -0.1248 0.929871    0 0
  v -157.618 65.5169 72.9783    0.0294146 -0.0223962 0.999316    0 0
  v -157.438 68.5091 73.3699    -0.145507 -0.34486 0.927308    0 0
  v -160.071 69.82 74.4337    0.491021 -0.494839 0.716961    0 0
  v -159.167 67.9251 73.3846    0.292373 -0.167901 0.94145    0 0
  v -160.675 67.2632 74.1892    0.715899 -0.094153 0.691826    0 0
  v -161.133 69.1851 75.5499    0.916515 -0.258621 0.305149    0 0
  v -161.45 67.9736 77.1988    0.98217 -0.148623 -0.115126    0 0
  v -160.754 70.635 77.0242    0.822201 -0.563541 -0.0800376    0 0
  v -159.479 69.9504 79.5703    0.383459 -0.538166 -0.750557    0 0
  v -160.751 69.27 78.6619    0.83259 -0.281579 -0.476977    0 0
  v -159.969 67.4192 80.1342    0.596065 -0.15921 -0.786993    0 0
  v -158.376 68.0973 80.6844    0.17384 -0.25504 -0.951175    0 0
  v -156.82 65.6869 81.1408    -0.0948362 -0.119617 -0.98828    0 0
  v -156.747 68.6563 80.4374    -0.266329 -0.429913 -0.862695    0 0
  v -155.201 66.2554 80.6025    -0.474901 -0.212236 -0.854064    0 0
  v -129.55 61.5982 57.1917    0 -0.64889 -0.760883    0 0
  v -132.336 60.9189 58.0741    -0.121022 -0.723343 -0.6798    0 0
  v -135.631 60.6509 59.2801    -0.241395 -0.656461 -0.714694    0 0
  v -134.264 61.6824 57.9385    -0.181195 -0.655847 -0.732826    0 0
  v -132.813 60.4515 59.003    0.0142617 -0.970957 -0.238828    0 0
  v -135.175 60.3583 59.4693    -0.132657 -0.836259 -0.532046    0 0
  v -129.55 60.7735 58.0714    -3.65766e-008 -0.884076 -0.467343    0 0
  v -139.497 59.908 61.6309    -0.25824 -0.752789 -0.605493    0 0
  v -138.442 59.7025 61.5197    -0.0860633 -0.909572 -0.406536    0 0
  v -131.073 78.826 109.536    -0.0254155 -0.337195 0.941092    0 0
  v -132.855 76.6104 108.559    -0.0829155 -0.420218 0.903627    0 0
  v -131.63 73.9374 107.149    -0.031829 -0.536456 0.843328    0 0
  v -131.63 81.854 110.313    -0.0653256 -0.201929 0.977219    0 0
  v -132.855 79.3111 109.583    -0.108163 -0.301603 0.947278    0 0
  v -135.542 74.6885 107.171    -0.160065 -0.492686 0.855359    0 0
  v -135.542 78.1079 108.742    -0.169281 -0.34706 0.922439    0 0
  v -132.443 83.579 110.568    -0.0821114 -0.145332 0.98597    0 0
  v -134.476 81.2366 109.874    -0.135307 -0.239444 0.961436    0 0
  v -133.211 84.7214 110.626    -0.0922317 -0.0815617 0.992392    0 0
  v -136.102 82.7164 109.971    -0.152199 -0.194786 0.968965    0 0
  v -138.105 79.8191 108.852    -0.191106 -0.303622 0.93343    0 0
  v -140.37 81.6404 108.891    -0.225496 -0.246888 0.942442    0 0
  v -133.799 85.8821 110.646    -0.0916054 -0.0476721 0.994654    0 0
  v -137.462 84.1787 109.997    -0.168254 -0.139597 0.975809    0 0
  v -134.164 87.1226 110.654    -0.0898798 -0.0216499 0.995717    0 0
  v -138.4 85.8052 110.018    -0.176345 -0.0840938 0.98073    0 0
  v -142.051 83.7408 108.932    -0.254864 -0.175937 0.950837    0 0
  v -143.076 86.0344 108.974    -0.271394 -0.0877148 0.958463    0 0
  v -134.287 88.4115 110.657    -0.0898751 2.07088e-007 0.995953    0 0
  v -138.884 87.529 110.024    -0.18105 -0.0243592 0.983172    0 0
  v -134.164 89.7003 110.654    -0.0912154 0.0219095 0.99559    0 0
  v -138.9 89.2782 110.015    -0.183484 0.0308887 0.982537    0 0
  v -143.471 88.3857 108.954    -0.282735 0.00829643 0.959162    0 0
  v -143.188 90.6985 108.91    -0.278895 0.0934135 0.955767    0 0
  v -133.799 90.9408 110.646    -0.0925684 0.0480567 0.994546    0 0
  v -138.432 90.9869 110.002    -0.181308 0.0836478 0.979862    0 0
  v -133.211 92.1015 110.626    -0.0925959 0.0817869 0.992339    0 0
  v -137.483 92.6192 109.99    -0.171986 0.137883 0.975402    0 0
  v -142.172 92.9465 108.888    -0.263773 0.170486 0.949399    0 0
  v -140.412 95.1326 108.877    -0.232554 0.241941 0.94201    0 0
  v -132.443 93.2439 110.568    -0.0821638 0.145363 0.985961    0 0
  v -136.106 94.1015 109.969    -0.153701 0.193814 0.968923    0 0
  v -131.63 94.9689 110.313    -0.0653256 0.20193 0.977219    0 0
  v -134.476 95.5864 109.874    -0.135439 0.239286 0.961456    0 0
  v -138.109 96.9988 108.851    -0.193197 0.302119 0.933488    0 0
  v -135.542 98.715 108.742    -0.16928 0.34706 0.922439    0 0
  v -131.073 97.9969 109.536    -0.025415 0.337195 0.941092    0 0
  v -132.855 97.5119 109.583    -0.108164 0.301604 0.947278    0 0
  v -132.855 100.213 108.559    -0.0829161 0.420218 0.903627    0 0
  v -132.443 68.5172 102.712    -0.0563129 -0.691601 0.720081    0 0
  v -136.104 66.3256 99.9755    -0.123863 -0.733392 0.668426    0 0
  v -133.211 63.5278 97.0649    -0.0659535 -0.791246 0.60793    0 0
  v -134.476 71.5067 105.14    -0.107918 -0.618572 0.778282    0 0
  v -138.107 69.4843 102.715    -0.174926 -0.660375 0.730278    0 0
  v -140.393 64.739 97.0649    -0.197039 -0.761864 0.617041    0 0
  v -133.804 59.7282 91.0636    -0.0732343 -0.890468 0.449114    0 0
  v -138.502 58.8804 87.8791    -0.140942 -0.924773 0.353456    0 0
  v -134.223 57.361 84.5127    -0.0736282 -0.971158 0.226783    0 0
  v -137.473 61.9531 94.1098    -0.139612 -0.828476 0.542343    0 0
  v -142.172 61.1013 91.0627    -0.214057 -0.853942 0.474302    0 0
  v -143.45 58.6482 84.506    -0.184956 -0.948766 0.256191    0 0
  v -134.468 56.4997 77.2823    -0.0704049 -0.996853 0.0364238    0 0
  v -139.304 57.0005 73.756    -0.130085 -0.99088 -0.0351352    0 0
  v -134.412 56.7172 70.6896    -0.0670629 -0.992196 -0.105113    0 0
  v -139.075 57.2568 80.9131    -0.128493 -0.983507 0.12729    0 0
  v -143.544 57.6444 77.2071    -0.168174 -0.985105 0.0358679    0 0
  v -143.842 57.9989 70.269    -0.196381 -0.973806 -0.114618    0 0
  v -132.375 68.748 51.3917    -0.0549598 -0.57802 -0.814169    0 0
  v -133.889 71.7676 49.4185    -0.105849 -0.564012 -0.818955    0 0
  v -134.443 63.7964 55.7714    -0.115809 -0.704377 -0.700315    0 0
  v -136.512 66.6648 53.507    -0.126432 -0.638772 -0.758937    0 0
  v -137.826 69.7409 51.3965    -0.161289 -0.589094 -0.791805    0 0
  v -141.534 65.223 55.9245    -0.202458 -0.693568 -0.691357    0 0
  v -131.384 103.802 44.7367    -0.094306 0.915962 0.390027    0 0
  v -132.945 102.947 46.1521    -0.189698 0.897739 0.397592    0 0
  v -131.615 104.858 41.5883    -0.0974679 0.959165 0.265523    0 0
  v -133.444 104.058 43.2306    -0.19121 0.924428 0.329957    0 0
  v -134.99 103.049 44.7367    -0.283708 0.885229 0.368618    0 0
  v -135.662 104.027 41.5883    -0.288334 0.916044 0.278797    0 0
  v -131.779 105.635 37.7966    -0.0994512 0.984209 0.146432    0 0
  v -133.842 104.965 39.7645    -0.195873 0.958211 0.208484    0 0
  v -131.854 105.997 33.5791    -0.100364 0.994647 0.024568    0 0
  v -134.082 105.535 35.7223    -0.198604 0.976059 0.0886827    0 0
  v -136.138 104.747 37.7966    -0.294366 0.943324 0.153256    0 0
  v -136.353 105.083 33.5791    -0.297061 0.954514 0.0256412    0 0
  v -131.822 105.84 29.2297    -0.100019 0.990745 -0.091764    0 0
  v -134.124 105.636 31.4043    -0.199145 0.979258 -0.037362    0 0
  v -131.701 105.242 25.0062    -0.0987915 0.9767 -0.190521    0 0
  v -133.967 105.255 27.0865    -0.197596 0.969551 -0.144659    0 0
  v -136.26 104.937 29.2297    -0.296066 0.950356 -0.095748    0 0
  v -135.91 104.383 25.0062    -0.2926 0.935384 -0.198602    0 0
  v -131.508 104.289 21.1642    -0.0958242 0.943994 -0.315743    0 0
  v -133.657 104.502 23.0204    -0.194296 0.948871 -0.248784    0 0
  v -131.226 102.901 17.9815    -0.086668 0.848314 -0.522352    0 0
  v -133.194 103.378 19.4729    -0.184202 0.892111 -0.412561    0 0
  v -135.35 103.5 21.1642    -0.283907 0.900889 -0.328324    0 0
  v -134.534 102.212 17.9815    -0.256217 0.802257 -0.539199    0 0
  v -130.85 101.036 15.6837    -0.0695026 0.679755 -0.730139    0 0
  v -132.535 101.778 16.7254    -0.157045 0.748645 -0.644102    0 0
  v -130.458 99.0459 14.1605    -0.0488469 0.52487 -0.84978    0 0
  v -131.743 99.864 14.838    -0.127641 0.581311 -0.803607    0 0
  v -133.431 100.481 15.682    -0.209078 0.630532 -0.747473    0 0
  v -132.203 98.6147 14.1433    -0.177993 0.467601 -0.865834    0 0
  v -130.202 97.3352 13.261    -0.0460613 0.384165 -0.922115    0 0
  v -130.982 98.0592 13.6493    -0.105425 0.438088 -0.892729    0 0
  v -130.975 97.0611 13.2249    -0.126869 0.342943 -0.930749    0 0
  v -126.585 69.9401 59.9359    -0.256313 -0.199815 0.945715    0 0
  v -124.75 70.3726 60.8389    -0.428098 -0.86644 0.256932    0 0
  v -127.136 70.8223 60.4525    -0.0355207 -0.923923 -0.380926    0 0
  v -129.55 70.8689 59.7514    -2.2849e-009 -0.797053 0.603909    0 0
  v -122.643 68.3911 62.29    -0.204126 -0.466451 -0.860672    0 0
  v -124.75 69.9503 61.4734    0.00179402 -0.611736 -0.79106    0 0
  v -122.643 68.8013 61.6718    -0.764482 -0.513654 0.38952    0 0
  v -129.55 70.1543 60.825    0 -0.550113 -0.83509    0 0
  v -126.585 68.752 61.7252    0.110947 -0.292038 -0.94995    0 0
  v -126.286 60.4515 59.003    -0.0142619 -0.970957 -0.238827    0 0
  v -122.999 60.0482 60.4806    -0.28982 -0.896032 0.33635    0 0
  v -126.077 60.6299 59.5175    -0.259248 -0.402484 0.877951    0 0
  v -129.55 60.5629 58.8093    0 -0.928084 0.372372    0 0
  v -119.362 59.1636 63.012    -0.122742 -0.880455 -0.457966    0 0
  v -120.753 59.8205 61.9507    -0.618008 -0.510179 0.59815    0 0
  v -120.658 59.7025 61.5197    0.0860678 -0.909569 -0.406542    0 0
  v -121.118 61.5621 62.0257    -0.643419 -0.0782171 0.761508    0 0
  v -123.108 60.8805 60.7399    -0.442635 -0.13807 0.886008    0 0
  v -120.101 60.0238 62.9253    -0.884006 -0.276405 -0.377007    0 0
  v -129.55 61.414 59.0942    -1.69972e-007 -0.105239 0.994447    0 0
  v -126.177 62.3956 59.6717    -0.257233 -0.041927 0.96544    0 0
  v -122.633 58.6976 63.1397    0.0977768 -0.770456 -0.62995    0 0
  v -120.692 59.1626 63.1318    0.0187371 -0.305032 -0.952158    0 0
  v -129.55 58.6222 62.5215    4.0935e-008 -0.813597 -0.581429    0 0
  v -126.016 58.9941 62.4287    0.0970273 -0.418925 -0.902822    0 0
  v -126.177 60.7421 62.3223    0.113085 0.00897888 -0.993545    0 0
  v -123.108 59.6684 62.7636    0.145831 -0.0389554 -0.988542    0 0
  v -129.55 59.6362 62.0623    7.8764e-008 -0.0875159 -0.996163    0 0
  v -121.118 60.9007 63.0859    -0.00802654 0.00905416 -0.999927    0 0
  v -133.423 58.3465 63.4186    -0.0463799 -0.924391 -0.378615    0 0
  v -136.466 58.6976 63.1397    -0.0977768 -0.77046 -0.629945    0 0
  v -133.083 58.9941 62.4287    -0.0970269 -0.418925 -0.902822    0 0
  v -139.737 59.1636 63.012    0.122744 -0.880455 -0.457966    0 0
  v -138.407 59.1626 63.1318    -0.0187366 -0.305034 -0.952157    0 0
  v -139.435 58.7175 63.7889    -0.121885 -0.912929 -0.389494    0 0
  v -137.981 60.9007 63.0859    0.00802652 0.00905416 -0.999927    0 0
  v -135.992 59.6684 62.7636    -0.145831 -0.0389545 -0.988542    0 0
  v -138.998 60.0238 62.9253    0.884002 -0.27641 -0.377013    0 0
  v -132.922 60.7421 62.3223    -0.113085 0.00897912 -0.993545    0 0
  v -136.1 60.0482 60.4806    0.289821 -0.896031 0.336352    0 0
  v -138.346 59.8205 61.9507    0.618007 -0.510181 0.598149    0 0
  v -133.022 60.6299 59.5175    0.259248 -0.402483 0.877951    0 0
  v -132.922 62.3956 59.6717    0.257232 -0.0419275 0.96544    0 0
  v -135.992 60.8805 60.7399    0.442635 -0.13807 0.886008    0 0
  v -137.981 61.5621 62.0257    0.643419 -0.0782179 0.761507    0 0
  v -123.297 63.8167 60.8162    -0.438335 -0.0328046 0.898213    0 0
  v -126.268 66.2954 59.7557    -0.257735 -0.0369346 0.965509    0 0
  v -129.55 64.3669 59.1909    0 -0.0243814 0.999703    0 0
  v -120.379 62.9299 62.9659    -0.935099 -0.0930876 -0.341941    0 0
  v -121.424 65.4006 62.0136    -0.652529 -0.0814861 0.75337    0 0
  v -123.681 67.9164 60.8161    -0.44469 -0.0843555 0.891703    0 0
  v -121.298 66.808 62.5996    -0.796248 -0.486186 -0.360016    0 0
  v -129.55 68.4879 59.3387    0 -0.0731629 0.99732    0 0
  v -123.297 62.5544 62.7826    0.151893 -0.00261441 -0.988394    0 0
  v -121.424 64.7402 63.0241    0.00247685 -0.0848324 -0.996392    0 0
  v -129.55 62.5156 62.0749    0 -0.00920298 -0.999958    0 0
  v -126.268 64.6444 62.2819    0.116152 -0.0483055 -0.992056    0 0
  v -123.681 66.7884 62.5242    0.138677 -0.127147 -0.982142    0 0
  v -129.55 66.8335 61.8438    0 -0.136726 -0.990609    0 0
  v -135.803 62.5544 62.7826    -0.151893 -0.00261359 -0.988394    0 0
  v -132.831 64.6444 62.2819    -0.116152 -0.0483055 -0.992056    0 0
  v -138.721 62.9299 62.9659    0.935099 -0.0930877 -0.341943    0 0
  v -137.675 64.7402 63.0241    -0.00247688 -0.0848325 -0.996392    0 0
  v -136.456 68.3911 62.29    0.204125 -0.466451 -0.860672    0 0
  v -135.4