/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuslsel.cxx,v $
 *
 *  $Revision: 1.22 $
 *
 *  last change: $Author: kz $ $Date: 2006/12/12 17:24:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sd.hxx"

#include "fuslsel.hxx"

#ifndef _SVDPAGV_HXX //autogen
#include <svx/svdpagv.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include "sdresid.hxx"
#ifndef SD_SLIDE_VIEW_SHELL_HXX
#include "SlideViewShell.hxx"
#endif
#ifndef SD_SLIDE_VIEW_HXX
#include "SlideView.hxx"
#endif
#ifndef SD_WINDOW_SHELL_HXX
#include "Window.hxx"
#endif
#include "drawdoc.hxx"
#include "sdpage.hxx"
#include "pres.hxx"
#ifndef SD_SHOW_VIEW_HXX
#include "showview.hxx"
#endif
#ifndef SD_FRAMW_VIEW_HXX
#include "FrameView.hxx"
#endif
#include "strings.hrc"
#include "app.hrc"                  
#include "AccessibleSlideView.hxx"

using namespace ::com::sun::star;

namespace sd {

// --------------------
// - FuSlideSelection -
// --------------------

// -----------------------------------------------------------------------------

TYPEINIT1( FuSlideSelection, FuSlide );

// -----------------------------------------------------------------------------

FuSlideSelection::FuSlideSelection (
    SlideViewShell* pViewSh,
    ::sd::Window* pWin,
    SlideView* pView,
    SdDrawDocument* pDoc,
    SfxRequest& rReq)
    : FuSlide(pViewSh, pWin, pView, pDoc, rReq),
      bSubstShown(FALSE),
      bPageHit(FALSE),
      bDragSelection(FALSE),
	  pSound(new Sound)
{
	pIsShowingEffectInfo = new FSS_IsShowingEffectInfo;
	pIsShowingEffectInfo->bDisposed = FALSE;
	pIsShowingEffectInfo->bIsShowingEffect = FALSE;

	aDelayToScrollTimer.SetTimeout(50);
	aDragTimer.SetTimeoutHdl( LINK( this, FuSlideSelection, DragSlideHdl ) );
}

FunctionReference FuSlideSelection::Create( SlideViewShell* pViewSh, ::sd::Window* pWin, SlideView* pView, SdDrawDocument* pDoc, SfxRequest& rReq )
{
	FunctionReference xFunc( new FuSlideSelection( pViewSh, pWin, pView, pDoc, rReq ) );
	xFunc->DoExecute(rReq);
	return xFunc;
}

void FuSlideSelection::DoExecute( SfxRequest& rReq )
{
	FuSlide::DoExecute( rReq );
}

// -----------------------------------------------------------------------------

FuSlideSelection::~FuSlideSelection()
{
    aDragTimer.Stop();
	delete pSound;

	if( pIsShowingEffectInfo && pIsShowingEffectInfo->bIsShowingEffect )
	{
		// we can not delete the info because its
		// used in ShowFade(), but mark it as
		// dispose so ShowFade() will clear it
		pIsShowingEffectInfo->bDisposed = TRUE;
	}
	else
	{
		delete pIsShowingEffectInfo;
	}
}

// -----------------------------------------------------------------------------

BOOL FuSlideSelection::MouseButtonDown(const MouseEvent& rMEvt)
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());

	BOOL			bReturn = FALSE;
	Point			aPos( mpWindow->PixelToLogic( rMEvt.GetPosPixel() ) );
    SdPage*         pHitPage = pSlView->GetHitPage( aPos );
    SdPage*         pFadePage = pSlView->GetFadePage( aPos );
	USHORT			nNoOfPages = mpDoc->GetSdPageCount(PK_STANDARD);
	USHORT			nPage;

	mpWindow->CaptureMouse();

	if ((rMEvt.IsLeft() || rMEvt.IsRight())
        && rMEvt.GetClicks() == 1 
        && pHitPage)
	{
		bPageHit = TRUE;		 // Seite getroffen, merken fuer MouseMove

		if (rMEvt.IsShift())
            pSlView->Select( ( pHitPage->GetPageNum() - 1 ) / 2, !pHitPage->IsSelected() );
		else if( !pHitPage->IsSelected() )
		{
    		// einfache Selektion, alle selektierten deselektieren, getroffene Seite selektieren
            pSlView->SelectAllSlides( FALSE );
            pSlView->Select( ( pHitPage->GetPageNum() - 1 ) / 2, TRUE );
		}

		// Position und Status der Ersatzdarstellung merken
		aDragPos = aPos;
		bSubstShown = FALSE;
		bFirstMouseMove = TRUE;
		aDragTimer.Start();
	}

	// bei Doppelklick: einfache Selektion und in Zeichenmodus gehen
	if( ( rMEvt.GetButtons() == MOUSE_LEFT ) && ( rMEvt.GetClicks() == 2 ) && pHitPage )
	{
		for (nPage = 0; nPage < nNoOfPages; nPage++)
		{
			SdPage* pTestPage = mpDoc->GetSdPage(nPage, PK_STANDARD);
			mpDoc->SetSelected(pTestPage, FALSE);
		}
		
        mpDoc->SetSelected(pHitPage, TRUE);
		bReturn = TRUE;
		mpViewShell->GetFrameView()->SetSelectedPage((pHitPage->GetPageNum()-1)/2);
		mpViewShell->GetViewFrame()->GetDispatcher()->Execute(SID_DRAWINGMODE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
	}

	// eines der Diawechselsymbole getroffen?
	if( ( rMEvt.GetButtons() == MOUSE_LEFT ) && ( rMEvt.GetClicks() == 1 ) && pFadePage )
	{
    	ShowEffect( ( pFadePage->GetPageNum() - 1 ) >> 1 );
        return TRUE;
	}

	// Selektionsrechteck aufziehen
	if( !pHitPage && !bReturn )
	{
		// keine erweiterte Selektion: alle Seiten deselektieren
		if( !rMEvt.IsShift() )
            pSlView->SelectAllSlides( FALSE );

		bDragSelection = TRUE;
		pSlView->BegEncirclement(aPos);
	}

	return bReturn;
}

// -----------------------------------------------------------------------------

BOOL FuSlideSelection::MouseMove(const MouseEvent& rMEvt)
{
	Point   aPix( rMEvt.GetPosPixel() );
	Point   aPos( mpWindow->PixelToLogic( aPix ) );
    BOOL    bReturn = FALSE;

    if( aDragTimer.IsActive() )
	{
        if( bFirstMouseMove )
			bFirstMouseMove = FALSE;
		else
            aDragTimer.Stop();
	}

	if( rMEvt.GetButtons() == MOUSE_LEFT && bPageHit && !rMEvt.IsShift() || bSubstShown )
	{										
		ForceScroll( aPix );

		// wenn DragRect erzeugt, an alter Pos. loeschen, Position aendern
		if (bSubstShown)
		{
			DrawSubst();
			ChangeSubstPos(aPos- aDragPos);
			aDragPos = aPos;
		}
		// sonst Ersatzdarstellungen erzeugen
		else
		{
			CreateSubst();
			bSubstShown = TRUE;
		}

		// Aenderung der Einfuegeposition
		Point aTemp = CalcPosOfInsertMarker (aPos);
		if (aTemp != aPosOfInsertMarker)
		{
			DrawInsertMarker(FALSE);
			aPosOfInsertMarker = aTemp;
			DrawInsertMarker(TRUE);
		}

		// wenn Ersatzdarstellungen erzeugt, an neuer Pos. zeichnen
		if (bSubstShown)
		{
			DrawSubst();
		}

		bReturn = TRUE;
	}
	else if (bDragSelection)
	{
		ForceScroll( aPix );
		pSlView->MovEncirclement(aPos);
	}

	return bReturn;
}

// -----------------------------------------------------------------------------

BOOL FuSlideSelection::MouseButtonUp(const MouseEvent& rMEvt)
{
	// #95491# remember button state for creation of own MouseEvents
	SetMouseButtonCode(rMEvt.GetButtons());
	SdDrawDocument* pDoc = pSlView->GetDoc();
	BOOL            bReturn = FALSE;

	if( aDragTimer.IsActive() )
		aDragTimer.Stop();

	if (rMEvt.GetButtons() == MOUSE_LEFT && bSubstShown)
	{
		Point aPos = mpWindow->PixelToLogic(rMEvt.GetPosPixel());

		// Ersatzdarstellung loeschen
		DrawSubst();					// vom Bildschirm
		DeleteSubst();					// und aus dem Speicher
		bSubstShown = FALSE;

		// Einfuegemarke loeschen
		DrawInsertMarker(FALSE);

		// Seiten ablegen wenn Ziel gueltig
		USHORT nTargetPage = GetTargetPage( aPos );

		pSlView->MoveMarked( nTargetPage );
		mpViewShell->GetViewFrame()->GetBindings().Invalidate(SID_STATUS_PAGE);
		bReturn = TRUE;
	}

	if (bDragSelection)
	{
		aDragSelRect = pSlView->EndEncirclement();
		bDragSelection = FALSE;
		
        USHORT nNoOfPages = pDoc->GetSdPageCount(PK_STANDARD);
	
        for( USHORT nPage = 0; nPage < nNoOfPages; nPage++ )
		{
			SdPage*   pPage = pDoc->GetSdPage(nPage, PK_STANDARD);
			Rectangle aPageRect(pSlView->CalcPagePos(nPage), pPage->GetSize());
			
            if( aDragSelRect.IsInside( aPageRect ) )
                pSlView->Select( ( pPage->GetPageNum() - 1 ) / 2, rMEvt.IsShift() ? !pPage->IsSelected() : TRUE );
		}
	}

	bPageHit = FALSE;				  // ab jetzt keine Seite mehr "am Haken"
    mpWindow->ReleaseMouse();

	return bReturn;
}

// -----------------------------------------------------------------------------

BOOL FuSlideSelection::KeyInput(const KeyEvent& rKEvt)
{
    SlideView*	pSlideView = PTR_CAST(SlideView, mpView );
	BOOL            bReturn = FALSE;

	switch( rKEvt.GetKeyCode().GetCode() )
	{
        case( KEY_RETURN ):
        {
            if( pSlideView && pSlideView->HasFocus() )
            {
                const USHORT nFocusPage = pSlideView->GetFocusPage();

		        for( USHORT nPage = 0, nPageCount = mpDoc->GetSdPageCount( PK_STANDARD ); nPage < nPageCount; nPage++ )
			        mpDoc->SetSelected( mpDoc->GetSdPage( nPage, PK_STANDARD ), FALSE );
		        
                mpDoc->SetSelected( mpDoc->GetSdPage( nFocusPage, PK_STANDARD ), TRUE );
		        mpViewShell->GetFrameView()->SetSelectedPage( nFocusPage );
		        mpViewShell->GetViewFrame()->GetDispatcher()->Execute( SID_DRAWINGMODE, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
		        bReturn = TRUE;
            }
        }

		case( KEY_ESCAPE ):
		{
			bReturn = cancel();
		}
		break;

		case( KEY_SPACE ):
		{
            if( pSlideView && pSlideView->HasFocus() )
            {
                pSlideView->MoveFocus( SLIDEVIEWFOCUSMOVE_SELECT );
    			bReturn = TRUE;
            }
		}
		break;

		case( KEY_LEFT ):
		{
            if( pSlideView && pSlideView->HasFocus() )
            {
                pSlideView->MoveFocus( SLIDEVIEWFOCUSMOVE_LEFT );
    			bReturn = TRUE;
            }
		}
		break;

		case( KEY_UP ):
		{
            if( pSlideView && pSlideView->HasFocus() )
            {
                pSlideView->MoveFocus( SLIDEVIEWFOCUSMOVE_TOP );
    			bReturn = TRUE;
            }
		}
		break;

		case( KEY_RIGHT ):
		{
            if( pSlideView && pSlideView->HasFocus() )
            {
                pSlideView->MoveFocus( SLIDEVIEWFOCUSMOVE_RIGHT );
    			bReturn = TRUE;
            }
		}
		break;

		case( KEY_DOWN ):
		{
            if( pSlideView && pSlideView->HasFocus() )
            {
                pSlideView->MoveFocus( SLIDEVIEWFOCUSMOVE_BOTTOM );
    			bReturn = TRUE;
            }
		}
		break;

		case( KEY_ADD ):
		{
			mpViewShell->SetZoom(mpWindow->GetZoom() * 3 / 2);
			bReturn = TRUE;
		}
		break;

		case( KEY_PAGEUP ):
		{
            if( pSlideView )
            {
			    ScrollStart();
			    mpViewShell->ScrollLines( 0, -10 );
			    ScrollEnd();
			    bReturn = TRUE;
            }
		}
		break;

		case( KEY_PAGEDOWN ):
		{
            if( pSlideView )
            {
			    ScrollStart();
			    mpViewShell->ScrollLines( 0, 10 );
			    ScrollEnd();
			    bReturn = TRUE;
            }
		}
		break;

		case( KEY_SUBTRACT ):
		{
			mpViewShell->SetZoom(mpWindow->GetZoom() * 2 / 3);
			bReturn = TRUE;
		}
		break;

        case( KEY_DELETE ):
        {
            if( pSlideView )
            {
			    USHORT	nMarkedPages = 0, nCount = mpDoc->GetSdPageCount( PK_STANDARD );
			    
			    for( USHORT nPgNum = 0; nPgNum < nCount; nPgNum++ )
			    {
				    SdPage* pPage = mpDoc->GetSdPage(nPgNum, PK_STANDARD);
				    
				    if( pPage && pPage->IsSelected() )
				    {
					    nMarkedPages++;
				    }
			    }

			    if( nCount>1 && nMarkedPages )
				    pSlideView->DeleteMarked();

			    bReturn = TRUE;
            }
        }
        break;

        default:
        break;
	}

	return( bReturn || FuSlide::KeyInput( rKEvt ) );
}

// -----------------------------------------------------------------------------

void FuSlideSelection::Activate()
{
	FuSlide::Activate();
}

// -----------------------------------------------------------------------------

void FuSlideSelection::Deactivate()
{
	// Sound nicht mehr blockieren, damit er in der Show gespielt werden kann
	if (pSound)
		pSound->Stop();

	FuSlide::Deactivate();
}

// -----------------------------------------------------------------------------

void FuSlideSelection::DrawSubst() const
{
	ULONG nNoOfSubst = aSubstList.Count();
	ULONG nSubst;
	for (nSubst = 0; nSubst < nNoOfSubst; nSubst++)
	{
		mpViewShell->DrawMarkRect(*(Rectangle*)aSubstList.GetObject(nSubst));
	}
}

// -----------------------------------------------------------------------------

void FuSlideSelection::DrawDragSelectionRect() const
{
	mpViewShell->DrawMarkRect(aDragSelRect);
}

// -----------------------------------------------------------------------------

void FuSlideSelection::DrawInsertMarker (BOOL bShow)
{
	Color aNewColor;

	if (bShow)
		aNewColor = Color(COL_BLACK);
	else
		aNewColor = mpWindow->GetBackground().GetColor();


	Size  aMarkerSize	= mpDoc->GetSdPage(0, PK_STANDARD)->GetSize();
	aMarkerSize.Width() = pSlView->GetPageGap() / pSlView->GetPagesPerRow();

	Rectangle aMarkerRect(aPosOfInsertMarker, aMarkerSize);
	mpViewShell->DrawFilledRect( aMarkerRect, aNewColor, aNewColor );
}

// -----------------------------------------------------------------------------

USHORT FuSlideSelection::GetTargetPage(const Point& rPoint) const
{
	USHORT			nResult;
	SdDrawDocument* pDoc		  = pSlView->GetDoc();
	USHORT			nNumOfPages   = pDoc->GetSdPageCount(PK_STANDARD);

	USHORT			nPagesPerRow  = pSlView->GetPagesPerRow();
	Size			aPageSize	  = pDoc->GetSdPage(0, PK_STANDARD)->GetSize();
	ULONG			nGap		  = pSlView->GetPageGap();

	USHORT			nColumn;
	USHORT			nRow;
	Point			aWorkPoint;

	if (rPoint.X() < (long)(nGap + aPageSize.Width()))
	{
		nColumn = 0;
	}
	else
	{
		aWorkPoint = rPoint;
		aWorkPoint.X() += aPageSize.Width() / 2;
		nColumn = (USHORT)(aWorkPoint.X() / (aPageSize.Width() + nGap));
		nColumn = Min(nColumn, (USHORT)(nPagesPerRow - 1));
	}

	if (rPoint.Y() < (long)(nGap + aPageSize.Height()))
	{
		nRow = 0;
	}
	else
	{
		aWorkPoint = rPoint;
		aWorkPoint.Y() -= nGap / 2;
		nRow = (USHORT)(aWorkPoint.Y() / (aPageSize.Height() + nGap));
		nRow = Min(nRow, (USHORT)(nNumOfPages / nPagesPerRow));
	}

	nResult = nRow * nPagesPerRow + nColumn;		// die getroffene Seite
	nResult = Min(nResult, (USHORT)(nNumOfPages - 1));

	// linke oder rechte Hlfte getroffen?
	Rectangle	aPageRect(pSlView->GetPageArea(nResult));
	long		nCenter = aPageRect.TopLeft().X();
	nCenter += aPageRect.GetWidth() / 2;

	// links getroffen, also hinter Vorgaengerseite einfuegen
	if (rPoint.X() < nCenter)
		nResult--;

	return nResult;
}

// -----------------------------------------------------------------------------

Point FuSlideSelection::CalcPosOfInsertMarker( const Point& rPoint )
{
	Point  aResult;
	USHORT nNoOfPages = mpDoc->GetSdPageCount(PK_STANDARD);

	USHORT nTargetPage = GetTargetPage(rPoint);

	if (nTargetPage == (USHORT)-1)
	{
		nTargetPage = 0;
	}

	Size  aPageSize   = mpDoc->GetSdPage(0, PK_STANDARD)->GetSize();

	Point aTargetPagePoint	= pSlView->CalcPagePos(nTargetPage);
	Point aWorkPoint(aTargetPagePoint);
	aWorkPoint.X()	 += aPageSize.Width() / 2;		// Seitenzentrum
	aWorkPoint.Y()	 += aPageSize.Height() / 2;

	// wenn es eine Folgeseite gibt: Marke hinter Zielseite oder vor Folgeseite
	if (nTargetPage < nNoOfPages - 1)
	{
		Point aNextPagePoint = pSlView->CalcPagePos(nTargetPage + 1);
		Point aNextCenter	 = aNextPagePoint;
		aNextCenter.X() 	+= aPageSize.Width() / 2;
		aNextCenter.Y() 	+= aPageSize.Height() / 2;

		Point aToTarget = rPoint - aWorkPoint;
		float fToTarget = aToTarget.X() * (float)aToTarget.X() +
						  aToTarget.Y() * (float)aToTarget.Y();

		Point aToNext	= rPoint - aNextCenter;
		float fToNext	= aToNext.X() * (float)aToNext.X() +
							aToNext.Y() * (float)aToNext.Y();

		if (fToNext < fToTarget)
		{
			aWorkPoint = aNextCenter;
		}
	}

	if (rPoint.X() < aWorkPoint.X())
	{
		aWorkPoint.X() -= aPageSize.Width() / 2;	  // zurueck zum Ursprung
		aWorkPoint.Y() -= aPageSize.Height() / 2;
		aResult 		= aWorkPoint;
		aResult.X()    -= pSlView->GetPageGap() * 5 / 8;
	}
	else
	{
		aWorkPoint.X() -= aPageSize.Width() / 2;	  // zurueck zum Ursprung
		aWorkPoint.Y() -= aPageSize.Height() / 2;
		aResult 		= aWorkPoint;
		aResult.X()    += aPageSize.Width() + pSlView->GetPageGap() * 3 / 8;
	}
	return aResult;
}

// -----------------------------------------------------------------------------

void FuSlideSelection::CreateSubst()
{
    for( USHORT nPage = 0, nNoOfPages = mpDoc->GetSdPageCount( PK_STANDARD ); nPage < nNoOfPages; nPage++ )
	{
		SdPage* pTestPage = mpDoc->GetSdPage( nPage, PK_STANDARD );

		if( pTestPage->IsSelected() )
			aSubstList.Insert( new Rectangle( pSlView->GetPageArea( nPage ) ), LIST_APPEND ); 
	}
}

// -----------------------------------------------------------------------------

void FuSlideSelection::DeleteSubst()
{
	while (aSubstList.Count() > 0)
	{
		delete (Rectangle*)aSubstList.Remove((ULONG)0);
	}
}

// -----------------------------------------------------------------------------

void FuSlideSelection::ChangeSubstPos(const Point& rVector)
{
	Rectangle * pRect	   = NULL;
	ULONG		nNoOfSubst = aSubstList.Count();
	ULONG		nSubst;
	for (nSubst = 0; nSubst < nNoOfSubst; nSubst++)
	{
		pRect = (Rectangle*)aSubstList.GetObject(nSubst);
		pRect->SetPos(rVector + pRect->TopLeft());
	}
}

// -----------------------------------------------------------------------------

void FuSlideSelection::ShowEffect(USHORT )
{
	DBG_ERROR("not implemented");
}

// -----------------------------------------------------------------------------

void FuSlideSelection::ScrollStart()
{
	DrawInsertMarker( FALSE );

	if( bSubstShown )
		DrawSubst();
}

// -----------------------------------------------------------------------------

void FuSlideSelection::ScrollEnd()
{
	if( bSubstShown )
		DrawSubst();
}

// -----------------------------------------------------------------------------

void FuSlideSelection::Paint(const Rectangle&, ::sd::Window* )
{
	if(bSubstShown)
		DrawSubst();
}

// -----------------------------------------------------------------------------

IMPL_LINK( FuSlideSelection, DragSlideHdl, Timer*, EMPTYARG )
{
	if( bPageHit )
	{
		DrawSubst();
		DeleteSubst();
		DrawInsertMarker( FALSE );
		bPageHit = bSubstShown = FALSE;
		mpWindow->ReleaseMouse();
		mpView->StartDrag( aDragPos, mpWindow );
	}
	
    return 0;
}

/** is called when the currenct function should be aborted. <p>
	This is used when a function gets a KEY_ESCAPE but can also
	be called directly.

	@returns true if a active function was aborted
*/
bool FuSlideSelection::cancel()
{
    SlideView*	pSlideView = PTR_CAST(SlideView, mpView );
	if( pSlideView )
	{
		pSlideView->MoveFocus( SLIDEVIEWFOCUSMOVE_TOGGLE );
		return true;
	}
	else
	{
		return false;
	}
}

} // end of namespace sd
