#ifndef RPTUI_SECTIONSWINDOW_HXX
#define RPTUI_SECTIONSWINDOW_HXX
/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: SectionsWindow.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/09 11:56:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_REPORT_XSECTION_HPP_
#include <com/sun/star/report/XSection.hpp>
#endif
#ifndef _SV_WINDOW_HXX
#include <vcl/window.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
#include <svtools/colorcfg.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_MULTIPLEX_HXX_
#include <comphelper/propmultiplex.hxx>
#endif
#ifndef _CPPUHELPER_BASEMUTEX_HXX_
#include "cppuhelper/basemutex.hxx"
#endif
#ifndef RPTUI_UITOOLS_HXX
#include "UITools.hxx"
#endif
#ifndef RPTUI_UNDOACTIONS_HXX
#include "UndoActions.hxx"
#endif

#include <list>
#include <map>
#include <boost/shared_ptr.hpp>

class Splitter;
namespace comphelper
{
	class OPropertyChangeMultiplexer;
}
namespace rptui
{
	class OReportWindow;
	class ODesignView;
	class OStartMarker;
	class OSectionsWindow :		public Window
							,	public ::cppu::BaseMutex
							,	public ::comphelper::OPropertyChangeListener
	{
	public:
		typedef ::std::pair< ::rtl::Reference< comphelper::OPropertyChangeMultiplexer>, ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection > > TSectionMutilPair;
		typedef ::std::pair< ::boost::shared_ptr<OStartMarker>,TSectionMutilPair> TSectionPair;
		typedef ::std::list< TSectionPair > TSectionsMap;
        typedef ::std::map< com::sun::star::uno::Reference< com::sun::star::report::XGroup>,::rtl::Reference< comphelper::OPropertyChangeMultiplexer> > TGroupChangeMultiplexer;
	private:
		TSectionsMap		    m_aSections;
        TGroupChangeMultiplexer m_aGroupChangeMultiplexer; /// a collection of all groups with the property change multiplexer
		OReportWindow*		    m_pParent;
		void ImplInitSettings();

        /** set the title of the group header or footer
        *
        * \param _xGroup 
        * \param _nResId 
        * \param _pGetSection 
        * \param _pIsSectionOn 
        */
        void setGroupSectionTitle(const ::com::sun::star::uno::Reference< ::com::sun::star::report::XGroup>& _xGroup,USHORT _nResId,::std::mem_fun_t< ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection> , OGroupHelper> _pGetSection,::std::mem_fun_t<sal_Bool, OGroupHelper> _pIsSectionOn);

        OSectionsWindow(OSectionsWindow&);
        void operator =(OSectionsWindow&);
	protected:
		virtual void DataChanged( const DataChangedEvent& rDCEvt );
		virtual void MouseButtonDown( const MouseEvent& rMEvt );
        // OPropertyChangeListener
		virtual void	_propertyChanged(const ::com::sun::star::beans::PropertyChangeEvent& _rEvent) throw( ::com::sun::star::uno::RuntimeException);
	public:
		OSectionsWindow( Window* _pParent,OReportWindow* _pReportWindow);
		virtual ~OSectionsWindow();

        // windows overload
		virtual void Resize();

        OReportWindow*	getReportWindow() const { return m_pParent; }

		/** gives the position of the section 
		*	If the section is <NULL/> nothing happens.
		* \param _xSection 
		*/
		USHORT			getPosition(const ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection >& _xSection) const;

		/** removes the section at the given position.
		*
		* \param _nPosition Zero based.
		*/
		void			removeSection(USHORT _nPosition);

		/** adds a new section at position _nPosition.
			If the section is <NULL/> nothing happens.
			If the position is grater than the current elements, the section will be appended.
		*/
		void			addSection(const ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection >& _xSection
									,const ::rtl::OUString& _sColorEntry
									,USHORT _nPosition = USHRT_MAX);

		USHORT			find(const OStartMarker* _pMarker) const;

		sal_Int32		getRulerWidth() const;

		/** returns the minimum height of the section
		*
		* \param _nPos
		* \return the height in pixel
		*/
		sal_Int32		getMinHeight(USHORT _nPos) const;

		/** shows or hides the ruler.
		*/
		void			showRuler(sal_Bool _bShow);

		/** triggers the property browser with the section
			@param	_pStartMarker
		*/
		void			showProperties( const OStartMarker* _pStartMarker);

		/** the the section as marked or not marked
			@param	_xSection	the section where to set the marked flag
			@param	_bMark		the marked flag
		*/
		void			setMarked(const ::com::sun::star::uno::Reference< ::com::sun::star::report::XSection >& _xSection,sal_Bool _bMark);

        /** fills the positions of all collapsed sections.
        *
        * \param _rCollapsedPositions Out parameter which holds afterwards all positions of the collapsed sections.
        */
        void fillCollapsedSections(::std::vector<sal_uInt16>& _rCollapsedPositions) const;

        /** collpase all sections given by their position
        *
        * \param _aCollpasedSections The position of the sections which should be collapsed.
        */
        void collapseSections(const com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue>& _aCollpasedSections);
	};
//==============================================================================
} // rptui
//==============================================================================
#endif // RPTUI_SECTIONSWINDOW_HXX

