
/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: resources.cxx,v $
 *
 *  $Revision: 1.66 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2007/06/04 08:41:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
/*
    
    THIS FILE IS GENERATED AUTOMATICALLY! DO NOT EDIT!

*/
#include <resources.hxx>

#ifndef WW8_OUTPUT_WITH_DEPTH
#include <WW8OutputWithDepth.hxx>
#endif

#ifndef INCLUDED_SPRMIDS_HXX
#include <resourcemodel/sprmids.hxx>
#endif

namespace doctok {

extern WW8OutputWithDepth output;

using namespace ::std;

Sprm::Kind SprmKind(sal_uInt32 sprmCode)
{
    Sprm::Kind nResult = Sprm::UNKNOWN;

    switch(sprmCode)
    {
    case NS_sprm::LN_PIstdPermute:
    case NS_sprm::LN_PIncLvl:
    case NS_sprm::LN_PJcExtra:
    case NS_sprm::LN_PJc:
    case NS_sprm::LN_PFSideBySide:
    case NS_sprm::LN_PFKeep:
    case NS_sprm::LN_PFKeepFollow:
    case NS_sprm::LN_PFPageBreakBefore:
    case NS_sprm::LN_PBrcl:
    case NS_sprm::LN_PBrcp:
    case NS_sprm::LN_PIlvl:
    case NS_sprm::LN_PIlfo:
    case NS_sprm::LN_PFNoLineNumb:
    case NS_sprm::LN_PChgTabsPapx:
    case NS_sprm::LN_PDxaRight:
    case NS_sprm::LN_PDxaLeft:
    case NS_sprm::LN_PNest:
    case NS_sprm::LN_PDxaLeft1:
    case NS_sprm::LN_PDyaLine:
    case NS_sprm::LN_PDyaBefore:
    case NS_sprm::LN_PDyaAfter:
    case NS_sprm::LN_PChgTabs:
    case NS_sprm::LN_PFInTable:
    case NS_sprm::LN_PCell:
    case NS_sprm::LN_PRow:
    case NS_sprm::LN_PFTtp:
    case NS_sprm::LN_PDxaAbs:
    case NS_sprm::LN_PDyaAbs:
    case NS_sprm::LN_PDxaWidth:
    case NS_sprm::LN_PPc:
    case NS_sprm::LN_PBrcTop10:
    case NS_sprm::LN_PBrcLeft10:
    case NS_sprm::LN_PBrcBottom10:
    case NS_sprm::LN_PBrcRight10:
    case NS_sprm::LN_PBrcBetween10:
    case NS_sprm::LN_PBrcBar10:
    case NS_sprm::LN_PDxaFromText10:
    case NS_sprm::LN_PWr:
    case NS_sprm::LN_PBrcBar:
    case NS_sprm::LN_PFNoAutoHyph:
    case NS_sprm::LN_PWHeightAbs:
    case NS_sprm::LN_PDcs:
    case NS_sprm::LN_PShd:
    case NS_sprm::LN_PDyaFromText:
    case NS_sprm::LN_PDxaFromText:
    case NS_sprm::LN_PFLocked:
    case NS_sprm::LN_PFWidowControl:
    case NS_sprm::LN_PRuler:
    case NS_sprm::LN_PFKinsoku:
    case NS_sprm::LN_PFWordWrap:
    case NS_sprm::LN_PFOverflowPunct:
    case NS_sprm::LN_PFTopLinePunct:
    case NS_sprm::LN_PFAutoSpaceDE:
    case NS_sprm::LN_PFAutoSpaceDN:
    case NS_sprm::LN_PWAlignFont:
    case NS_sprm::LN_PFrameTextFlow:
    case NS_sprm::LN_PISnapBaseLine:
    case NS_sprm::LN_PAnld:
    case NS_sprm::LN_PPropRMark:
    case NS_sprm::LN_POutLvl:
    case NS_sprm::LN_PFBiDi:
    case NS_sprm::LN_PFNumRMIns:
    case NS_sprm::LN_PCrLf:
    case NS_sprm::LN_PNumRM:
    case NS_sprm::LN_PHugePapx:
    case NS_sprm::LN_PFUsePgsuSettings:
    case NS_sprm::LN_PFAdjustRight:
    case NS_sprm::LN_PTightWrap:
    case NS_sprm::LN_PicBrcl:
    case NS_sprm::LN_PicScale:
    case NS_sprm::LN_PicBrcTop:
    case NS_sprm::LN_PicBrcLeft:
    case NS_sprm::LN_PicBrcBottom:
    case NS_sprm::LN_PicBrcRight:
    case NS_sprm::LN_PTableDepth:
    case NS_sprm::LN_PBrcTop:
    case NS_sprm::LN_PBrcLeft:
    case NS_sprm::LN_PBrcBottom:
    case NS_sprm::LN_PBrcRight:
    case NS_sprm::LN_PBrcBetween:
    case NS_sprm::LN_PBorderTop:
    case NS_sprm::LN_PBorderLeft:
    case NS_sprm::LN_PBorderBottom:
    case NS_sprm::LN_PBorderRight:
    case NS_sprm::LN_PBorderBetween:
      nResult = Sprm::PARAGRAPH;
      break;
    case NS_sprm::LN_CFRMarkDel:
    case NS_sprm::LN_CFRMark:
    case NS_sprm::LN_CFFldVanish:
    case NS_sprm::LN_CPicLocation:
    case NS_sprm::LN_CIbstRMark:
    case NS_sprm::LN_CDttmRMark:
    case NS_sprm::LN_CFData:
    case NS_sprm::LN_CIdslRMark:
    case NS_sprm::LN_CChs:
    case NS_sprm::LN_CSymbol:
    case NS_sprm::LN_CFOle2:
    case NS_sprm::LN_CIdCharType:
    case NS_sprm::LN_CHighlight:
    case NS_sprm::LN_CObjLocation:
    case NS_sprm::LN_CFFtcAsciSymb:
    case NS_sprm::LN_CIstd:
    case NS_sprm::LN_CIstdPermute:
    case NS_sprm::LN_CDefault:
    case NS_sprm::LN_CPlain:
    case NS_sprm::LN_CKcd:
    case NS_sprm::LN_CFBold:
    case NS_sprm::LN_CFItalic:
    case NS_sprm::LN_CFStrike:
    case NS_sprm::LN_CFOutline:
    case NS_sprm::LN_CFShadow:
    case NS_sprm::LN_CFSmallCaps:
    case NS_sprm::LN_CFCaps:
    case NS_sprm::LN_CFVanish:
    case NS_sprm::LN_CFtcDefault:
    case NS_sprm::LN_CKul:
    case NS_sprm::LN_CSizePos:
    case NS_sprm::LN_CDxaSpace:
    case NS_sprm::LN_CLid:
    case NS_sprm::LN_CIco:
    case NS_sprm::LN_CHps:
    case NS_sprm::LN_CHpsInc:
    case NS_sprm::LN_CHpsPos:
    case NS_sprm::LN_CHpsPosAdj:
    case NS_sprm::LN_CMajority:
    case NS_sprm::LN_CIss:
    case NS_sprm::LN_CHpsNew50:
    case NS_sprm::LN_CHpsInc1:
    case NS_sprm::LN_CHpsKern:
    case NS_sprm::LN_CMajority50:
    case NS_sprm::LN_CHpsMul:
    case NS_sprm::LN_CYsri:
    case NS_sprm::LN_CRgFtc0:
    case NS_sprm::LN_CRgFtc1:
    case NS_sprm::LN_CRgFtc2:
    case NS_sprm::LN_CCharScale:
    case NS_sprm::LN_CFDStrike:
    case NS_sprm::LN_CFImprint:
    case NS_sprm::LN_CFNoProof:
    case NS_sprm::LN_CFspecVanish:
    case NS_sprm::LN_CFitText:
    case NS_sprm::LN_CComplexScript:
    case NS_sprm::LN_CFSpec:
    case NS_sprm::LN_CFObj:
    case NS_sprm::LN_CPropRMark:
    case NS_sprm::LN_CFEmboss:
    case NS_sprm::LN_CSfxText:
    case NS_sprm::LN_CFBiDi:
    case NS_sprm::LN_CFDiacColor:
    case NS_sprm::LN_CFBoldBi:
    case NS_sprm::LN_CFItalicBi:
    case NS_sprm::LN_CFtcBi:
    case NS_sprm::LN_CLidBi:
    case NS_sprm::LN_CIcoBi:
    case NS_sprm::LN_CHpsBi:
    case NS_sprm::LN_CDispFldRMark:
    case NS_sprm::LN_CIbstRMarkDel:
    case NS_sprm::LN_CDttmRMarkDel:
    case NS_sprm::LN_CBrc:
    case NS_sprm::LN_CShd:
    case NS_sprm::LN_CIdslRMarkDel:
    case NS_sprm::LN_CFUsePgsuSettings:
    case NS_sprm::LN_CCpg:
    case NS_sprm::LN_CRgLid0:
    case NS_sprm::LN_CRgLid1:
    case NS_sprm::LN_CIdctHint:
    case NS_sprm::LN_CIndrsid:
    case NS_sprm::LN_Cdelrsid:
    case NS_sprm::LN_CBorder:
    case NS_sprm::LN_CEastAsianLayout:
      nResult = Sprm::CHARACTER;
      break;
    case NS_sprm::LN_TCantSplit:
    case NS_sprm::LN_TJc:
    case NS_sprm::LN_TDxaLeft:
    case NS_sprm::LN_TDxaGapHalf:
    case NS_sprm::LN_TFCantSplit:
    case NS_sprm::LN_TTableHeader:
    case NS_sprm::LN_TTableBorders:
    case NS_sprm::LN_TDefTable10:
    case NS_sprm::LN_TDyaRowHeight:
    case NS_sprm::LN_TDefTable:
    case NS_sprm::LN_TDefTableShd:
    case NS_sprm::LN_TCellShd:
    case NS_sprm::LN_TTlp:
    case NS_sprm::LN_TFBiDi:
    case NS_sprm::LN_THTMLProps:
    case NS_sprm::LN_TSetBrc:
    case NS_sprm::LN_TInsert:
    case NS_sprm::LN_TDelete:
    case NS_sprm::LN_TDxaCol:
    case NS_sprm::LN_TMerge:
    case NS_sprm::LN_TSplit:
    case NS_sprm::LN_TSetBrc10:
    case NS_sprm::LN_TSetShd:
    case NS_sprm::LN_TSetShdOdd:
    case NS_sprm::LN_TTextFlow:
    case NS_sprm::LN_TDiagLine:
    case NS_sprm::LN_TVertMerge:
    case NS_sprm::LN_TVertAlign:
    case NS_sprm::LN_TCellTopColor:
    case NS_sprm::LN_TCellLeftColor:
    case NS_sprm::LN_TCellBottomColor:
    case NS_sprm::LN_TCellRightColor:
    case NS_sprm::LN_TGridLineProps:
    case NS_sprm::LN_TCellShadow:
    case NS_sprm::LN_TTPreferredWidth:
    case NS_sprm::LN_TTRLeft:
      nResult = Sprm::TABLE;
      break;
    default:
      break;
    }

    return nResult;
}

/*
    Automatically generated class: ListLevel
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 28
*/
    WW8ListLevel::~WW8ListLevel()
    {
    }
    
    void WW8ListLevel::init()
    {
      
    }

    void WW8ListLevel::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_iStartAt());
                rHandler.attribute(NS_rtf::LN_ISTARTAT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_nfc());
                rHandler.attribute(NS_rtf::LN_NFC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_jc());
                rHandler.attribute(NS_rtf::LN_JC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fLegal());
                rHandler.attribute(NS_rtf::LN_FLEGAL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fNoRestart());
                rHandler.attribute(NS_rtf::LN_FNORESTART, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fPrev());
                rHandler.attribute(NS_rtf::LN_FPREV, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fPrevSpace());
                rHandler.attribute(NS_rtf::LN_FPREVSPACE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fWord6());
                rHandler.attribute(NS_rtf::LN_FWORD6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused5_7());
                rHandler.attribute(NS_rtf::LN_UNUSED5_7, *pVal);
            }
            {
                sal_uInt32 nCount = get_rgbxchNums_count();              
                for (sal_uInt32 n = 0; n < nCount; ++n)
                {
                    WW8Value::Pointer_t pVal = createValue(get_rgbxchNums(n));
                    rHandler.attribute(NS_rtf::LN_RGBXCHNUMS, *pVal);
                }
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ixchFollow());
                rHandler.attribute(NS_rtf::LN_IXCHFOLLOW, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dxaSpace());
                rHandler.attribute(NS_rtf::LN_DXASPACE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dxaIndent());
                rHandler.attribute(NS_rtf::LN_DXAINDENT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cbGrpprlChpx());
                rHandler.attribute(NS_rtf::LN_CBGRPPRLCHPX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cbGrpprlPapx());
                rHandler.attribute(NS_rtf::LN_CBGRPPRLPAPX, *pVal);
            }
      resolveNoAuto(rHandler);
    
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8ListLevel::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='ListLevel'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "iStartAt", get_iStartAt());
        doctok::dump(o, "nfc", get_nfc());
        doctok::dump(o, "jc", get_jc());
        doctok::dump(o, "fLegal", get_fLegal());
        doctok::dump(o, "fNoRestart", get_fNoRestart());
        doctok::dump(o, "fPrev", get_fPrev());
        doctok::dump(o, "fPrevSpace", get_fPrevSpace());
        doctok::dump(o, "fWord6", get_fWord6());
        doctok::dump(o, "unused5_7", get_unused5_7());
        {
            sal_uInt32 nCount = get_rgbxchNums_count();
            
            for (sal_uInt32 n = 0; n < nCount; ++n)
            {
                doctok::dump(o, "rgbxchNums", get_rgbxchNums(n));
            }
        }
        doctok::dump(o, "ixchFollow", get_ixchFollow());
        doctok::dump(o, "dxaSpace", get_dxaSpace());
        doctok::dump(o, "dxaIndent", get_dxaIndent());
        doctok::dump(o, "cbGrpprlChpx", get_cbGrpprlChpx());
        doctok::dump(o, "cbGrpprlPapx", get_cbGrpprlPapx());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: List
    
    Stereotype ww8resource

    Stereotype withindex

    Parent Resource: Properties
    Size: 28
*/
    WW8List::~WW8List()
    {
    }
    
    void WW8List::init()
    {
      
    }

    void WW8List::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_lsid());
                rHandler.attribute(NS_rtf::LN_LSID, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_tplc());
                rHandler.attribute(NS_rtf::LN_TPLC, *pVal);
            }
            {
                sal_uInt32 nCount = get_rgistd_count();              
                for (sal_uInt32 n = 0; n < nCount; ++n)
                {
                    WW8Value::Pointer_t pVal = createValue(get_rgistd(n));
                    rHandler.attribute(NS_rtf::LN_RGISTD, *pVal);
                }
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fSimpleList());
                rHandler.attribute(NS_rtf::LN_FSIMPLELIST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fRestartHdn());
                rHandler.attribute(NS_rtf::LN_FRESTARTHDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unsigned26_2());
                rHandler.attribute(NS_rtf::LN_UNSIGNED26_2, *pVal);
            }
          {
              sal_uInt32 nCount = get_listlevel_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_listlevel(n));
                  rHandler.attribute(NS_rtf::LN_LISTLEVEL, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8List::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='List'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "lsid", get_lsid());
        doctok::dump(o, "tplc", get_tplc());
        {
            sal_uInt32 nCount = get_rgistd_count();
            
            for (sal_uInt32 n = 0; n < nCount; ++n)
            {
                doctok::dump(o, "rgistd", get_rgistd(n));
            }
        }
        doctok::dump(o, "fSimpleList", get_fSimpleList());
        doctok::dump(o, "fRestartHdn", get_fRestartHdn());
        doctok::dump(o, "unsigned26_2", get_unsigned26_2());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: ListTable
    
    Stereotype ww8resource

    Stereotype plcf

    Parent Resource: Table
    Size: 0
*/
    WW8ListTable::~WW8ListTable()
    {
    }
    
    void WW8ListTable::init()
    {
      
    }
void WW8ListTable::resolve(Table & rHandler)
    {
       sal_uInt32 nCount = getEntryCount();
       doctok::Reference< Properties >::Pointer_t pEntry;
       for (sal_uInt32 n = 0; n < nCount; ++n)
       {
           pEntry = getEntry(n);
           
           if (pEntry.get() != 0x0)
           {
               try 
               {
                   rHandler.entry(n, pEntry);
               }
               catch (ExceptionOutOfBounds e)
               {                
               }
           }
       }
   }
    
/*
    Automatically generated class: LFOLevel
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 8
*/
    WW8LFOLevel::~WW8LFOLevel()
    {
    }
    
    void WW8LFOLevel::init()
    {
      
    }

    void WW8LFOLevel::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_iStartAt());
                rHandler.attribute(NS_rtf::LN_ISTARTAT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ilvl());
                rHandler.attribute(NS_rtf::LN_ILVL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fStartAt());
                rHandler.attribute(NS_rtf::LN_FSTARTAT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fFormatting());
                rHandler.attribute(NS_rtf::LN_FFORMATTING, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unsigned4_6());
                rHandler.attribute(NS_rtf::LN_UNSIGNED4_6, *pVal);
            }
      resolveNoAuto(rHandler);
    
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8LFOLevel::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='LFOLevel'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "iStartAt", get_iStartAt());
        doctok::dump(o, "ilvl", get_ilvl());
        doctok::dump(o, "fStartAt", get_fStartAt());
        doctok::dump(o, "fFormatting", get_fFormatting());
        doctok::dump(o, "unsigned4_6", get_unsigned4_6());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: LFO
    
    Stereotype ww8resource

    Stereotype withindex

    Parent Resource: Properties
    Size: 16
*/
    WW8LFO::~WW8LFO()
    {
    }
    
    void WW8LFO::init()
    {
      
    }

    void WW8LFO::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_lsid());
                rHandler.attribute(NS_rtf::LN_LSID, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused4());
                rHandler.attribute(NS_rtf::LN_UNUSED4, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused8());
                rHandler.attribute(NS_rtf::LN_UNUSED8, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_clfolvl());
                rHandler.attribute(NS_rtf::LN_CLFOLVL, *pVal);
            }
          {
              sal_uInt32 nCount = get_lfolevel_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_lfolevel(n));
                  rHandler.attribute(NS_rtf::LN_LFO, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8LFO::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='LFO'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "lsid", get_lsid());
        doctok::dump(o, "unused4", get_unused4());
        doctok::dump(o, "unused8", get_unused8());
        doctok::dump(o, "clfolvl", get_clfolvl());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: LFOTable
    
    Stereotype ww8resource

    Stereotype plcf

    Parent Resource: Table
    Size: 0
*/
    WW8LFOTable::~WW8LFOTable()
    {
    }
    
    void WW8LFOTable::init()
    {
      
    }
void WW8LFOTable::resolve(Table & rHandler)
    {
       sal_uInt32 nCount = getEntryCount();
       doctok::Reference< Properties >::Pointer_t pEntry;
       for (sal_uInt32 n = 0; n < nCount; ++n)
       {
           pEntry = getEntry(n);
           
           if (pEntry.get() != 0x0)
           {
               try 
               {
                   rHandler.entry(n, pEntry);
               }
               catch (ExceptionOutOfBounds e)
               {                
               }
           }
       }
   }
    
/*
    Automatically generated class: FontTable
    
    Stereotype ww8resource

    Stereotype plcf

    Parent Resource: Table
    Size: 0
*/
    WW8FontTable::~WW8FontTable()
    {
    }
    
    void WW8FontTable::init()
    {
      
    }
void WW8FontTable::resolve(Table & rHandler)
    {
       sal_uInt32 nCount = getEntryCount();
       doctok::Reference< Properties >::Pointer_t pEntry;
       for (sal_uInt32 n = 0; n < nCount; ++n)
       {
           pEntry = getEntry(n);
           
           if (pEntry.get() != 0x0)
           {
               try 
               {
                   rHandler.entry(n, pEntry);
               }
               catch (ExceptionOutOfBounds e)
               {                
               }
           }
       }
   }
    
/*
    Automatically generated class: Font
    
    Stereotype ww8resource

    Stereotype withindex

    Parent Resource: Properties
    Size: 40
*/
    WW8Font::~WW8Font()
    {
    }
    
    void WW8Font::init()
    {
      
    }

    void WW8Font::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_cbFfnM1());
                rHandler.attribute(NS_rtf::LN_CBFFNM1, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_prq());
                rHandler.attribute(NS_rtf::LN_PRQ, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fTrueType());
                rHandler.attribute(NS_rtf::LN_FTRUETYPE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused1_3());
                rHandler.attribute(NS_rtf::LN_UNUSED1_3, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ff());
                rHandler.attribute(NS_rtf::LN_FF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused1_7());
                rHandler.attribute(NS_rtf::LN_UNUSED1_7, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_wWeight());
                rHandler.attribute(NS_rtf::LN_WWEIGHT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_chs());
                rHandler.attribute(NS_rtf::LN_CHS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ixchSzAlt());
                rHandler.attribute(NS_rtf::LN_IXCHSZALT, *pVal);
            }
            {
                sal_uInt32 nCount = get_panose_count();              
                for (sal_uInt32 n = 0; n < nCount; ++n)
                {
                    WW8Value::Pointer_t pVal = createValue(get_panose(n));
                    rHandler.attribute(NS_rtf::LN_PANOSE, *pVal);
                }
            }
            {
                sal_uInt32 nCount = get_fs_count();              
                for (sal_uInt32 n = 0; n < nCount; ++n)
                {
                    WW8Value::Pointer_t pVal = createValue(get_fs(n));
                    rHandler.attribute(NS_rtf::LN_FS, *pVal);
                }
            }
          {
              WW8Value::Pointer_t pVal = createValue(get_f());
              rHandler.attribute(NS_rtf::LN_F, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_altName());
              rHandler.attribute(NS_rtf::LN_ALTFONTNAME, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_xszFfn());
              rHandler.attribute(NS_rtf::LN_XSZFFN, *pVal);
          }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8Font::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='Font'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "cbFfnM1", get_cbFfnM1());
        doctok::dump(o, "prq", get_prq());
        doctok::dump(o, "fTrueType", get_fTrueType());
        doctok::dump(o, "unused1_3", get_unused1_3());
        doctok::dump(o, "ff", get_ff());
        doctok::dump(o, "unused1_7", get_unused1_7());
        doctok::dump(o, "wWeight", get_wWeight());
        doctok::dump(o, "chs", get_chs());
        doctok::dump(o, "ixchSzAlt", get_ixchSzAlt());
        {
            sal_uInt32 nCount = get_panose_count();
            
            for (sal_uInt32 n = 0; n < nCount; ++n)
            {
                doctok::dump(o, "panose", get_panose(n));
            }
        }
        {
            sal_uInt32 nCount = get_fs_count();
            
            for (sal_uInt32 n = 0; n < nCount; ++n)
            {
                doctok::dump(o, "fs", get_fs(n));
            }
        }
        o.addItem("</dump>");
    }

/*
    Automatically generated class: Style
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Stereotype withindex

    Parent Resource: Properties
    Size: 0
*/
    WW8Style::~WW8Style()
    {
    }
    
    void WW8Style::init()
    {
      
    }

    void WW8Style::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_sti());
                rHandler.attribute(NS_rtf::LN_STI, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fScratch());
                rHandler.attribute(NS_rtf::LN_FSCRATCH, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fInvalHeight());
                rHandler.attribute(NS_rtf::LN_FINVALHEIGHT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fHasUpe());
                rHandler.attribute(NS_rtf::LN_FHASUPE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fMassCopy());
                rHandler.attribute(NS_rtf::LN_FMASSCOPY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_sgc());
                rHandler.attribute(NS_rtf::LN_SGC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_istdBase());
                rHandler.attribute(NS_rtf::LN_ISTDBASE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cupx());
                rHandler.attribute(NS_rtf::LN_CUPX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_istdNext());
                rHandler.attribute(NS_rtf::LN_ISTDNEXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_bchUpe());
                rHandler.attribute(NS_rtf::LN_BCHUPE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fAutoRedef());
                rHandler.attribute(NS_rtf::LN_FAUTOREDEF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fHidden());
                rHandler.attribute(NS_rtf::LN_FHIDDEN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused8_3());
                rHandler.attribute(NS_rtf::LN_UNUSED8_3, *pVal);
            }
          {
              WW8Value::Pointer_t pVal = createValue(get_xstzName());
              rHandler.attribute(NS_rtf::LN_XSTZNAME, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_xstzName1());
              rHandler.attribute(NS_rtf::LN_XSTZNAME1, *pVal);
          }

          {
              sal_uInt32 nCount = get_upx_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_upx(n));
                  rHandler.attribute(NS_rtf::LN_UPX, *pVal);
             }
         }

      resolveNoAuto(rHandler);
    
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8Style::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='Style'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "sti", get_sti());
        doctok::dump(o, "fScratch", get_fScratch());
        doctok::dump(o, "fInvalHeight", get_fInvalHeight());
        doctok::dump(o, "fHasUpe", get_fHasUpe());
        doctok::dump(o, "fMassCopy", get_fMassCopy());
        doctok::dump(o, "sgc", get_sgc());
        doctok::dump(o, "istdBase", get_istdBase());
        doctok::dump(o, "cupx", get_cupx());
        doctok::dump(o, "istdNext", get_istdNext());
        doctok::dump(o, "bchUpe", get_bchUpe());
        doctok::dump(o, "fAutoRedef", get_fAutoRedef());
        doctok::dump(o, "fHidden", get_fHidden());
        doctok::dump(o, "unused8_3", get_unused8_3());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: StyleSheet
    
    Stereotype ww8resource

    Stereotype plcf

    Parent Resource: Table
    Size: 0
*/
    WW8StyleSheet::~WW8StyleSheet()
    {
    }
    
    void WW8StyleSheet::init()
    {
      
    }
void WW8StyleSheet::resolve(Table & rHandler)
    {
       sal_uInt32 nCount = getEntryCount();
       doctok::Reference< Properties >::Pointer_t pEntry;
       for (sal_uInt32 n = 0; n < nCount; ++n)
       {
           pEntry = getEntry(n);
           
           if (pEntry.get() != 0x0)
           {
               try 
               {
                   rHandler.entry(n, pEntry);
               }
               catch (ExceptionOutOfBounds e)
               {                
               }
           }
       }
   }
    
/*
    Automatically generated class: Fib
    
    Stereotype ww8resource

    Stereotype withmembers

    Parent Resource: Properties
    Size: 898
*/
    WW8Fib::~WW8Fib()
    {
    }
    
    void WW8Fib::init()
    {
      

/*
(fibh) FIBH Beginning of the FIB header magic number

Name: wIdent(attribute)
Offset: 0x0000
Mask: 
Shift:  0
*/


    mwIdent =  (getU16(0x0000));
  

/*
FIB version written. This will be >= 101 for all Word 6.0
                  for Windows and after documents.

Name: nFib(attribute)
Offset: 0x0002
Mask: 
Shift:  0
*/


    mnFib =  (getU16(0x0002));
  

/*
product version written by

Name: nProduct(attribute)
Offset: 0x0004
Mask: 
Shift:  0
*/


    mnProduct =  (getU16(0x0004));
  

/*
language stamp -- localized version
                  In pre-WinWord 2.0 files this value was the nLocale. If value is
                  < 999, then it is the nLocale, otherwise it is the lid.

Name: lid(attribute)
Offset: 0x0006
Mask: 
Shift:  0
*/


    mlid =  (getU16(0x0006));
  

/*


Name: pnNext(attribute)
Offset: 0x0008
Mask: 
Shift:  0
*/


    mpnNext =  (getS16(0x0008));
  

/*
Set if this document is a template

Name: fDot(attribute)
Offset: 0x000a
Mask: 0x0001
Shift:  0
*/


    mfDot =  (getU16(0x000a) & 0x0001);
  

/*
Set if this document is a glossary

Name: fGlsy(attribute)
Offset: 0x000a
Mask: 0x0002
Shift:  1
*/


    mfGlsy =  (getU16(0x000a) & 0x0002) >> 1;
  

/*
when 1, file is in complex, fast-saved format.

Name: fComplex(attribute)
Offset: 0x000a
Mask: 0x0004
Shift:  2
*/


    mfComplex =  (getU16(0x000a) & 0x0004) >> 2;
  

/*
set if file contains 1 or more pictures

Name: fHasPic(attribute)
Offset: 0x000a
Mask: 0x0008
Shift:  3
*/


    mfHasPic =  (getU16(0x000a) & 0x0008) >> 3;
  

/*
count of times file was quicksaved

Name: cQuickSaves(attribute)
Offset: 0x000a
Mask: 0x00f0
Shift:  4
*/


    mcQuickSaves =  (getU16(0x000a) & 0x00f0) >> 4;
  

/*
Set if file is encrypted

Name: fEncrypted(attribute)
Offset: 0x000a
Mask: 0x0100
Shift:  8
*/


    mfEncrypted =  (getU16(0x000a) & 0x0100) >> 8;
  

/*
When 0, this fib refers to the table stream named "0Table",
                  when 1, this fib refers to the table stream named "1Table".
                  Normally, a file will have only one table stream, but under unusual
                  circumstances a file may have table streams with both names. In
                  that case, this flag must be used to decide which table stream is
                  valid.

Name: fWhichTblStm(attribute)
Offset: 0x000a
Mask: 0x0200
Shift:  9
*/


    mfWhichTblStm =  (getU16(0x000a) & 0x0200) >> 9;
  

/*
Set when user has recommended that file be read read-only

Name: fReadOnlyRecommended(attribute)
Offset: 0x000a
Mask: 0x0400
Shift:  10
*/


    mfReadOnlyRecommended =  (getU16(0x000a) & 0x0400) >> 10;
  

/*
Set when file owner has made the file write reserved

Name: fWriteReservation(attribute)
Offset: 0x000a
Mask: 0x0800
Shift:  11
*/


    mfWriteReservation =  (getU16(0x000a) & 0x0800) >> 11;
  

/*
Set when using extended character set in file

Name: fExtChar(attribute)
Offset: 0x000a
Mask: 0x1000
Shift:  12
*/


    mfExtChar =  (getU16(0x000a) & 0x1000) >> 12;
  

/*
REVIEW

Name: fLoadOverride(attribute)
Offset: 0x000a
Mask: 0x2000
Shift:  13
*/


    mfLoadOverride =  (getU16(0x000a) & 0x2000) >> 13;
  

/*
REVIEW

Name: fFarEast(attribute)
Offset: 0x000a
Mask: 0x4000
Shift:  14
*/


    mfFarEast =  (getU16(0x000a) & 0x4000) >> 14;
  

/*
REVIEW

Name: fCrypto(attribute)
Offset: 0x000a
Mask: 0x8000
Shift:  15
*/


    mfCrypto =  (getU16(0x000a) & 0x8000) >> 15;
  

/*
This file format it compatible with readers that understand
                  nFib at or above this value.

Name: nFibBack(attribute)
Offset: 0x000c
Mask: 
Shift:  0
*/


    mnFibBack =  (getU16(0x000c));
  

/*
File encrypted key, only valid if fEncrypted.

Name: lKey(attribute)
Offset: 0x000e
Mask: 
Shift:  0
*/


    mlKey =  (getU32(0x000e));
  

/*
environment in which file was created
                  0 created by Win Word
                  1 created by Mac Word

Name: envr(attribute)
Offset: 0x0012
Mask: 
Shift:  0
*/


    menvr =  (getU8(0x0012));
  

/*
when 1, this file was last saved in the Mac environment

Name: fMac(attribute)
Offset: 0x0013
Mask: 0x01
Shift:  0
*/


    mfMac =  (getU8(0x0013) & 0x01);
  

/*


Name: fEmptySpecial(attribute)
Offset: 0x0013
Mask: 0x02
Shift:  1
*/


    mfEmptySpecial =  (getU8(0x0013) & 0x02) >> 1;
  

/*


Name: fLoadOverridePage(attribute)
Offset: 0x0013
Mask: 0x04
Shift:  2
*/


    mfLoadOverridePage =  (getU8(0x0013) & 0x04) >> 2;
  

/*


Name: fFutureSavedUndo(attribute)
Offset: 0x0013
Mask: 0x08
Shift:  3
*/


    mfFutureSavedUndo =  (getU8(0x0013) & 0x08) >> 3;
  

/*


Name: fWord97Saved(attribute)
Offset: 0x0013
Mask: 0x10
Shift:  4
*/


    mfWord97Saved =  (getU8(0x0013) & 0x10) >> 4;
  

/*


Name: fSpare0(attribute)
Offset: 0x0013
Mask: 0xfe
Shift:  5
*/


    mfSpare0 =  (getU8(0x0013) & 0xfe) >> 5;
  

/*
Default extended character set id for text in document stream.
                  (overridden by chp.chse)
                  0 by default characters in doc stream should be interpreted using
                  the ANSI character set used by Windows
                  256 characters in doc stream should be interpreted using the
                  Macintosh character set.

Name: chs(attribute)
Offset: 0x0014
Mask: 
Shift:  0
*/


    mchs =  (getU16(0x0014));
  

/*
Default extended character set id for text in internal data
                  structures
                  0 by default characters stored in internal data structures should
                  be interpreted using the ANSI character set used by Windows
                  256 characters stored in internal data structures should be
                  interpreted using the Macintosh character set.

Name: chsTables(attribute)
Offset: 0x0016
Mask: 
Shift:  0
*/


    mchsTables =  (getU16(0x0016));
  

/*
file offset of first character of text. In non-complex
                  files a CP can be transformed into an FC by the
                  following transformation:
                  fc = cp + fib.fcMin.

Name: fcMin(attribute)
Offset: 0x0018
Mask: 
Shift:  0
*/


    mfcMin =  (getU32(0x0018));
  

/*
file offset of last character of text in document text stream +
                  1

Name: fcMac(attribute)
Offset: 0x001c
Mask: 
Shift:  0
*/


    mfcMac =  (getU32(0x001c));
  

/*
Count of fields in the array of "shorts"

Name: csw(attribute)
Offset: 0x0020
Mask: 
Shift:  0
*/


    mcsw =  (getU16(0x0020));
  

/*
[Beginning of the array of shorts, rgls]
                  Unique number Identifying the File's creator 6A62 is the creator ID
                  for Word and is reserved. Other creators should choose a different
                  value.

Name: wMagicCreated(attribute)
Offset: 0x0022
Mask: 
Shift:  0
*/


    mwMagicCreated =  (getU16(0x0022));
  

/*
identifies the File's last modifier

Name: wMagicRevised(attribute)
Offset: 0x0024
Mask: 
Shift:  0
*/


    mwMagicRevised =  (getU16(0x0024));
  

/*
private data

Name: wMagicCreatedPrivate(attribute)
Offset: 0x0026
Mask: 
Shift:  0
*/


    mwMagicCreatedPrivate =  (getU16(0x0026));
  

/*
private data

Name: wMagicRevisedPrivate(attribute)
Offset: 0x0028
Mask: 
Shift:  0
*/


    mwMagicRevisedPrivate =  (getU16(0x0028));
  

/*
not used

Name: pnFbpChpFirst_W6(attribute)
Offset: 0x002a
Mask: 
Shift:  0
*/


    mpnFbpChpFirst_W6 =  (getU16(0x002a));
  

/*
not used

Name: pnChpFirst_W6(attribute)
Offset: 0x002c
Mask: 
Shift:  0
*/


    mpnChpFirst_W6 =  (getU16(0x002c));
  

/*
not used

Name: cpnBteChp_W6(attribute)
Offset: 0x002e
Mask: 
Shift:  0
*/


    mcpnBteChp_W6 =  (getU16(0x002e));
  

/*
not used

Name: pnFbpPapFirst_W6(attribute)
Offset: 0x0030
Mask: 
Shift:  0
*/


    mpnFbpPapFirst_W6 =  (getU16(0x0030));
  

/*
not used

Name: pnPapFirst_W6(attribute)
Offset: 0x0032
Mask: 
Shift:  0
*/


    mpnPapFirst_W6 =  (getU16(0x0032));
  

/*
not used

Name: cpnBtePap_W6(attribute)
Offset: 0x0034
Mask: 
Shift:  0
*/


    mcpnBtePap_W6 =  (getU16(0x0034));
  

/*
not used

Name: pnFbpLvcFirst_W6(attribute)
Offset: 0x0036
Mask: 
Shift:  0
*/


    mpnFbpLvcFirst_W6 =  (getU16(0x0036));
  

/*
not used

Name: pnLvcFirst_W6(attribute)
Offset: 0x0038
Mask: 
Shift:  0
*/


    mpnLvcFirst_W6 =  (getU16(0x0038));
  

/*
not used

Name: cpnBteLvc_W6(attribute)
Offset: 0x003a
Mask: 
Shift:  0
*/


    mcpnBteLvc_W6 =  (getU16(0x003a));
  

/*
Language id if document was written by Far East version of Word
                  (i.e. FIB.fFarEast is on)

Name: lidFE(attribute)
Offset: 0x003c
Mask: 
Shift:  0
*/


    mlidFE =  (getS16(0x003c));
  

/*
Number of fields in the array of longs

Name: clw(attribute)
Offset: 0x003e
Mask: 
Shift:  0
*/


    mclw =  (getU16(0x003e));
  

/*
[Beginning of the array of longs, rglw]
                  file offset of last byte written to file + 1.

Name: cbMac(attribute)
Offset: 0x0040
Mask: 
Shift:  0
*/


    mcbMac =  (getU32(0x0040));
  

/*
contains the build date of the creator. 10695 indicates the
                  creator program was compiled on Jan 6, 1995

Name: lProductCreated(attribute)
Offset: 0x0044
Mask: 
Shift:  0
*/


    mlProductCreated =  (getU32(0x0044));
  

/*
contains the build date of the File's last modifier

Name: lProductRevised(attribute)
Offset: 0x0048
Mask: 
Shift:  0
*/


    mlProductRevised =  (getU32(0x0048));
  

/*
length of main document text stream

Name: ccpText(attribute)
Offset: 0x004c
Mask: 
Shift:  0
*/


    mccpText =  (getU32(0x004c));
  

/*
length of footnote subdocument text stream

Name: ccpFtn(attribute)
Offset: 0x0050
Mask: 
Shift:  0
*/


    mccpFtn =  (getU32(0x0050));
  

/*
length of header subdocument text stream

Name: ccpHdd(attribute)
Offset: 0x0054
Mask: 
Shift:  0
*/


    mccpHdd =  (getU32(0x0054));
  

/*
length of macro subdocument text stream, which should now
                  always be 0.

Name: ccpMcr(attribute)
Offset: 0x0058
Mask: 
Shift:  0
*/


    mccpMcr =  (getU32(0x0058));
  

/*
length of annotation subdocument text stream

Name: ccpAtn(attribute)
Offset: 0x005c
Mask: 
Shift:  0
*/


    mccpAtn =  (getU32(0x005c));
  

/*
length of endnote subdocument text stream

Name: ccpEdn(attribute)
Offset: 0x0060
Mask: 
Shift:  0
*/


    mccpEdn =  (getU32(0x0060));
  

/*
length of textbox subdocument text stream

Name: ccpTxbx(attribute)
Offset: 0x0064
Mask: 
Shift:  0
*/


    mccpTxbx =  (getU32(0x0064));
  

/*
length of header textbox subdocument text stream.

Name: ccpHdrTxbx(attribute)
Offset: 0x0068
Mask: 
Shift:  0
*/


    mccpHdrTxbx =  (getU32(0x0068));
  

/*
when there was insufficient memory for Word to expand the
                  plcfbte at save time, the plcfbte is written to the file in a
                  linked list of 512-byte pieces starting with this pn

Name: pnFbpChpFirst(attribute)
Offset: 0x006c
Mask: 
Shift:  0
*/


    mpnFbpChpFirst =  (getU32(0x006c));
  

/*
the page number of the lowest numbered page in the document
                  that records CHPX FKP information

Name: pnChpFirst(attribute)
Offset: 0x0070
Mask: 
Shift:  0
*/


    mpnChpFirst =  (getU32(0x0070));
  

/*
count of CHPX FKPs recorded in file. In non-complex files if
                  the number of entries in the plcfbteChpx is less than this, the
                  plcfbteChpx is incomplete.

Name: cpnBteChp(attribute)
Offset: 0x0074
Mask: 
Shift:  0
*/


    mcpnBteChp =  (getU32(0x0074));
  

/*
when there was insufficient memory for Word to expand the
                  plcfbte at save time, the plcfbte is written to the file in a
                  linked list of 512-byte pieces starting with this pn

Name: pnFbpPapFirst(attribute)
Offset: 0x0078
Mask: 
Shift:  0
*/


    mpnFbpPapFirst =  (getU32(0x0078));
  

/*
the page number of the lowest numbered page in the document
                  that records PAPX FKP information

Name: pnPapFirst(attribute)
Offset: 0x007c
Mask: 
Shift:  0
*/


    mpnPapFirst =  (getU32(0x007c));
  

/*
count of PAPX FKPs recorded in file. In non-complex files if
                  the number of entries in the plcfbtePapx is less than this, the
                  plcfbtePapx is incomplete.

Name: cpnBtePap(attribute)
Offset: 0x0080
Mask: 
Shift:  0
*/


    mcpnBtePap =  (getU32(0x0080));
  

/*
when there was insufficient memory for Word to expand the
                  plcfbte at save time, the plcfbte is written to the file in a
                  linked list of 512-byte pieces starting with this pn

Name: pnFbpLvcFirst(attribute)
Offset: 0x0084
Mask: 
Shift:  0
*/


    mpnFbpLvcFirst =  (getU32(0x0084));
  

/*
the page number of the lowest numbered page in the document
                  that records LVC FKP information

Name: pnLvcFirst(attribute)
Offset: 0x0088
Mask: 
Shift:  0
*/


    mpnLvcFirst =  (getU32(0x0088));
  

/*
count of LVC FKPs recorded in file. In non-complex files if the
                  number of entries in the plcfbtePapx is less than this, the
                  plcfbtePapx is incomplete.

Name: cpnBteLvc(attribute)
Offset: 0x008c
Mask: 
Shift:  0
*/


    mcpnBteLvc =  (getU32(0x008c));
  

/*


Name: fcIslandFirst(attribute)
Offset: 0x0090
Mask: 
Shift:  0
*/


    mfcIslandFirst =  (getU32(0x0090));
  

/*


Name: fcIslandLim(attribute)
Offset: 0x0094
Mask: 
Shift:  0
*/


    mfcIslandLim =  (getU32(0x0094));
  

/*
Number of fields in the array of FC/LCB pairs.

Name: cfclcb(attribute)
Offset: 0x0098
Mask: 
Shift:  0
*/


    mcfclcb =  (getU16(0x0098));
  

/*
[Beginning of array of FC/LCB pairs, rgfclcb]
                  file offset of original allocation for STSH in table stream. During
                  fast save Word will attempt to reuse this allocation if STSH is
                  small enough to fit.

Name: fcStshfOrig(attribute)
Offset: 0x009a
Mask: 
Shift:  0
*/


    mfcStshfOrig =  (getU32(0x009a));
  

/*
count of bytes of original STSH allocation

Name: lcbStshfOrig(attribute)
Offset: 0x009e
Mask: 
Shift:  0
*/


    mlcbStshfOrig =  (getU32(0x009e));
  

/*
offset of STSH in table stream.

Name: fcStshf(attribute)
Offset: 0x00a2
Mask: 
Shift:  0
*/


    mfcStshf =  (getU32(0x00a2));
  

/*
count of bytes of current STSH allocation

Name: lcbStshf(attribute)
Offset: 0x00a6
Mask: 
Shift:  0
*/


    mlcbStshf =  (getU32(0x00a6));
  

/*
offset in table stream of footnote reference PLCF of FRD
                  structures. CPs in PLC are relative to main document text stream
                  and give location of footnote references.

Name: fcPlcffndRef(attribute)
Offset: 0x00aa
Mask: 
Shift:  0
*/


    mfcPlcffndRef =  (getU32(0x00aa));
  

/*
count of bytes of footnote reference PLC== 0 if no footnotes
                  defined in document.

Name: lcbPlcffndRef(attribute)
Offset: 0x00ae
Mask: 
Shift:  0
*/


    mlcbPlcffndRef =  (getU32(0x00ae));
  

/*
offset in table stream of footnote text PLC. CPs in PLC are
                  relative to footnote subdocument text stream and give location of
                  beginnings of footnote text for corresponding references recorded
                  in plcffndRef. No structure is stored in this plc. There will just
                  be n+1 FC entries in this PLC when there are n
                  footnotes

Name: fcPlcffndTxt(attribute)
Offset: 0x00b2
Mask: 
Shift:  0
*/


    mfcPlcffndTxt =  (getU32(0x00b2));
  

/*
count of bytes of footnote text PLC. == 0 if no footnotes
                  defined in document

Name: lcbPlcffndTxt(attribute)
Offset: 0x00b6
Mask: 
Shift:  0
*/


    mlcbPlcffndTxt =  (getU32(0x00b6));
  

/*
offset in table stream of annotation reference ATRD PLC. The
                  CPs recorded in this PLC give the offset of annotation references
                  in the main document.

Name: fcPlcfandRef(attribute)
Offset: 0x00ba
Mask: 
Shift:  0
*/


    mfcPlcfandRef =  (getU32(0x00ba));
  

/*
count of bytes of annotation reference PLC.

Name: lcbPlcfandRef(attribute)
Offset: 0x00be
Mask: 
Shift:  0
*/


    mlcbPlcfandRef =  (getU32(0x00be));
  

/*
offset in table stream of annotation text PLC. The Cps recorded
                  in this PLC give the offset of the annotation text in the
                  annotation sub document corresponding to the references stored in
                  the plcfandRef. There is a 1 to 1 correspondence between entries
                  recorded in the plcfandTxt and the plcfandRef. No structure is
                  stored in this PLC.

Name: fcPlcfandTxt(attribute)
Offset: 0x00c2
Mask: 
Shift:  0
*/


    mfcPlcfandTxt =  (getU32(0x00c2));
  

/*
count of bytes of the annotation text PLC

Name: lcbPlcfandTxt(attribute)
Offset: 0x00c6
Mask: 
Shift:  0
*/


    mlcbPlcfandTxt =  (getU32(0x00c6));
  

/*
offset in table stream of section descriptor SED PLC. CPs in
                  PLC are relative to main document.

Name: fcPlcfsed(attribute)
Offset: 0x00ca
Mask: 
Shift:  0
*/


    mfcPlcfsed =  (getU32(0x00ca));
  

/*
count of bytes of section descriptor PLC.

Name: lcbPlcfsed(attribute)
Offset: 0x00ce
Mask: 
Shift:  0
*/


    mlcbPlcfsed =  (getU32(0x00ce));
  

/*
no longer used

Name: fcPlcfpad(attribute)
Offset: 0x00d2
Mask: 
Shift:  0
*/


    mfcPlcfpad =  (getU32(0x00d2));
  

/*
no longer used

Name: lcbPlcfpad(attribute)
Offset: 0x00d6
Mask: 
Shift:  0
*/


    mlcbPlcfpad =  (getU32(0x00d6));
  

/*
offset in table stream of PHE PLC of paragraph heights. CPs in
                  PLC are relative to main document text stream. Only written for
                  files in complex format. Should not be written by third
                  party creators of Word files.

Name: fcPlcfphe(attribute)
Offset: 0x00da
Mask: 
Shift:  0
*/


    mfcPlcfphe =  (getU32(0x00da));
  

/*
count of bytes of paragraph height PLC. ==0 when file is
                  non-complex.

Name: lcbPlcfphe(attribute)
Offset: 0x00de
Mask: 
Shift:  0
*/


    mlcbPlcfphe =  (getU32(0x00de));
  

/*
offset in table stream of glossary string table. This table
                  consists of Pascal style strings (strings stored prefixed with a
                  length byte) concatenated one after another.

Name: fcSttbfglsy(attribute)
Offset: 0x00e2
Mask: 
Shift:  0
*/


    mfcSttbfglsy =  (getU32(0x00e2));
  

/*
count of bytes of glossary string table. == 0 for non-glossary
                  documents.!=0 for glossary documents.

Name: lcbSttbfglsy(attribute)
Offset: 0x00e6
Mask: 
Shift:  0
*/


    mlcbSttbfglsy =  (getU32(0x00e6));
  

/*
offset in table stream of glossary PLC. CPs in PLC are relative
                  to main document and mark the beginnings of glossary entries and
                  are in 1-1 correspondence with entries of sttbfglsy. No structure
                  is stored in this PLC. There will be n+1 FC entries
                  in this PLC when there are n glossary entries.

Name: fcPlcfglsy(attribute)
Offset: 0x00ea
Mask: 
Shift:  0
*/


    mfcPlcfglsy =  (getU32(0x00ea));
  

/*
count of bytes of glossary PLC.== 0 for non-glossary
                  documents.!=0 for glossary documents.

Name: lcbPlcfglsy(attribute)
Offset: 0x00ee
Mask: 
Shift:  0
*/


    mlcbPlcfglsy =  (getU32(0x00ee));
  

/*
byte offset in table stream of header HDD PLC. CPs are relative
                  to header subdocument and mark the beginnings of individual headers
                  in the header subdocument. No structure is stored in this PLC.
                  There will be n+1FC entries in this PLC when there are
                  n headers stored for the document.

Name: fcPlcfhdd(attribute)
Offset: 0x00f2
Mask: 
Shift:  0
*/


    mfcPlcfhdd =  (getU32(0x00f2));
  

/*
count of bytes of header PLC.
                  == 0 if document contains no headers

Name: lcbPlcfhdd(attribute)
Offset: 0x00f6
Mask: 
Shift:  0
*/


    mlcbPlcfhdd =  (getU32(0x00f6));
  

/*
offset in table stream of character property bin table.PLC. FCs
                  in PLC are file offsets in the main stream. Describes text of main
                  document and all subdocuments.

Name: fcPlcfbteChpx(attribute)
Offset: 0x00fa
Mask: 
Shift:  0
*/


    mfcPlcfbteChpx =  (getU32(0x00fa));
  

/*
count of bytes of character property bin table PLC.

Name: lcbPlcfbteChpx(attribute)
Offset: 0x00fe
Mask: 
Shift:  0
*/


    mlcbPlcfbteChpx =  (getU32(0x00fe));
  

/*
offset in table stream of paragraph property bin table.PLC. FCs
                  in PLC are file offsets in the main stream. Describes text of main
                  document and all subdocuments.

Name: fcPlcfbtePapx(attribute)
Offset: 0x0102
Mask: 
Shift:  0
*/


    mfcPlcfbtePapx =  (getU32(0x0102));
  

/*
count of bytes of paragraph property bin table PLC

Name: lcbPlcfbtePapx(attribute)
Offset: 0x0106
Mask: 
Shift:  0
*/


    mlcbPlcfbtePapx =  (getU32(0x0106));
  

/*
offset in table stream of PLC reserved for private use. The
                  SEA is 6 bytes long.

Name: fcPlcfsea(attribute)
Offset: 0x010a
Mask: 
Shift:  0
*/


    mfcPlcfsea =  (getU32(0x010a));
  

/*
count of bytes of private use PLC.

Name: lcbPlcfsea(attribute)
Offset: 0x010e
Mask: 
Shift:  0
*/


    mlcbPlcfsea =  (getU32(0x010e));
  

/*
offset in table stream of font information STTBF. The sttbfffn
                  is a STTBF where is string is actually an FFN structure. The
                  nth entry in the STTBF describes the font that will be
                  displayed when the chp.ftc for text is equal to n. See the
                  FFN file structure definition.

Name: fcSttbfffn(attribute)
Offset: 0x0112
Mask: 
Shift:  0
*/


    mfcSttbfffn =  (getU32(0x0112));
  

/*
count of bytes in sttbfffn.

Name: lcbSttbfffn(attribute)
Offset: 0x0116
Mask: 
Shift:  0
*/


    mlcbSttbfffn =  (getU32(0x0116));
  

/*
offset in table stream to the FLD PLC of field positions in the
                  main document. The CPs point to the beginning CP of a field, the CP
                  of field separator character inside a field and the ending CP of
                  the field. A field may be nested within another field. 20 levels of
                  field nesting are allowed.

Name: fcPlcffldMom(attribute)
Offset: 0x011a
Mask: 
Shift:  0
*/


    mfcPlcffldMom =  (getU32(0x011a));
  

/*
count of bytes in plcffldMom

Name: lcbPlcffldMom(attribute)
Offset: 0x011e
Mask: 
Shift:  0
*/


    mlcbPlcffldMom =  (getU32(0x011e));
  

/*
offset in table stream to the FLD PLC of field positions in the
                  header subdocument.

Name: fcPlcffldHdr(attribute)
Offset: 0x0122
Mask: 
Shift:  0
*/


    mfcPlcffldHdr =  (getU32(0x0122));
  

/*
count of bytes in plcffldHdr

Name: lcbPlcffldHdr(attribute)
Offset: 0x0126
Mask: 
Shift:  0
*/


    mlcbPlcffldHdr =  (getU32(0x0126));
  

/*
offset in table stream to the FLD PLC of field positions in the
                  footnote subdocument.

Name: fcPlcffldFtn(attribute)
Offset: 0x012a
Mask: 
Shift:  0
*/


    mfcPlcffldFtn =  (getU32(0x012a));
  

/*
count of bytes in plcffldFtn

Name: lcbPlcffldFtn(attribute)
Offset: 0x012e
Mask: 
Shift:  0
*/


    mlcbPlcffldFtn =  (getU32(0x012e));
  

/*
offset in table stream to the FLD PLC of field positions in the
                  annotation subdocument.

Name: fcPlcffldAtn(attribute)
Offset: 0x0132
Mask: 
Shift:  0
*/


    mfcPlcffldAtn =  (getU32(0x0132));
  

/*
count of bytes in plcffldAtn

Name: lcbPlcffldAtn(attribute)
Offset: 0x0136
Mask: 
Shift:  0
*/


    mlcbPlcffldAtn =  (getU32(0x0136));
  

/*
no longer used

Name: fcPlcffldMcr(attribute)
Offset: 0x013a
Mask: 
Shift:  0
*/


    mfcPlcffldMcr =  (getU32(0x013a));
  

/*
no longer used

Name: lcbPlcffldMcr(attribute)
Offset: 0x013e
Mask: 
Shift:  0
*/


    mlcbPlcffldMcr =  (getU32(0x013e));
  

/*
offset in table stream of the STTBF that records bookmark names
                  in the main document

Name: fcSttbfbkmk(attribute)
Offset: 0x0142
Mask: 
Shift:  0
*/


    mfcSttbfbkmk =  (getU32(0x0142));
  

/*


Name: lcbSttbfbkmk(attribute)
Offset: 0x0146
Mask: 
Shift:  0
*/


    mlcbSttbfbkmk =  (getU32(0x0146));
  

/*
offset in table stream of the PLCF that records the beginning
                  CP offsets of bookmarks in the main document. See BKF structure
                  definition

Name: fcPlcfbkf(attribute)
Offset: 0x014a
Mask: 
Shift:  0
*/


    mfcPlcfbkf =  (getU32(0x014a));
  

/*


Name: lcbPlcfbkf(attribute)
Offset: 0x014e
Mask: 
Shift:  0
*/


    mlcbPlcfbkf =  (getU32(0x014e));
  

/*
offset in table stream of the PLCF that records the ending CP
                  offsets of bookmarks recorded in the main document. No structure is
                  stored in this PLCF.

Name: fcPlcfbkl(attribute)
Offset: 0x0152
Mask: 
Shift:  0
*/


    mfcPlcfbkl =  (getU32(0x0152));
  

/*


Name: lcbPlcfbkl(attribute)
Offset: 0x0156
Mask: 
Shift:  0
*/


    mlcbPlcfbkl =  (getU32(0x0156));
  

/*
offset in table stream of the macro commands. These commands
                  are private and undocumented.

Name: fcCmds(attribute)
Offset: 0x015a
Mask: 
Shift:  0
*/


    mfcCmds =  (getU32(0x015a));
  

/*
undocument size of undocument structure not documented
                  above

Name: lcbCmds(attribute)
Offset: 0x015e
Mask: 
Shift:  0
*/


    mlcbCmds =  (getU32(0x015e));
  

/*
no longer used

Name: fcPlcmcr(attribute)
Offset: 0x0162
Mask: 
Shift:  0
*/


    mfcPlcmcr =  (getU32(0x0162));
  

/*


Name: lcbPlcmcr(attribute)
Offset: 0x0166
Mask: 
Shift:  0
*/


    mlcbPlcmcr =  (getU32(0x0166));
  

/*
no longer used

Name: fcSttbfmcr(attribute)
Offset: 0x016a
Mask: 
Shift:  0
*/


    mfcSttbfmcr =  (getU32(0x016a));
  

/*


Name: lcbSttbfmcr(attribute)
Offset: 0x016e
Mask: 
Shift:  0
*/


    mlcbSttbfmcr =  (getU32(0x016e));
  

/*
offset in table stream of the printer driver information (names
                  of drivers, port, etc.)

Name: fcPrDrvr(attribute)
Offset: 0x0172
Mask: 
Shift:  0
*/


    mfcPrDrvr =  (getU32(0x0172));
  

/*
count of bytes of the printer driver information (names of
                  drivers, port, etc.)

Name: lcbPrDrvr(attribute)
Offset: 0x0176
Mask: 
Shift:  0
*/


    mlcbPrDrvr =  (getU32(0x0176));
  

/*
offset in table stream of the print environment in portrait
                  mode.

Name: fcPrEnvPort(attribute)
Offset: 0x017a
Mask: 
Shift:  0
*/


    mfcPrEnvPort =  (getU32(0x017a));
  

/*
count of bytes of the print environment in portrait mode.

Name: lcbPrEnvPort(attribute)
Offset: 0x017e
Mask: 
Shift:  0
*/


    mlcbPrEnvPort =  (getU32(0x017e));
  

/*
offset in table stream of the print environment in landscape
                  mode.

Name: fcPrEnvLand(attribute)
Offset: 0x0182
Mask: 
Shift:  0
*/


    mfcPrEnvLand =  (getU32(0x0182));
  

/*
count of bytes of the print environment in landscape mode.

Name: lcbPrEnvLand(attribute)
Offset: 0x0186
Mask: 
Shift:  0
*/


    mlcbPrEnvLand =  (getU32(0x0186));
  

/*
offset in table stream of Window Save
                  State data structure. WSS contains dimensions of
                  document's main text window and the last selection made by Word
                  user.

Name: fcWss(attribute)
Offset: 0x018a
Mask: 
Shift:  0
*/


    mfcWss =  (getU32(0x018a));
  

/*
count of bytes of WSS. ==0 if unable to store the window state.
                  Should not be written by third party creators of Word files.

Name: lcbWss(attribute)
Offset: 0x018e
Mask: 
Shift:  0
*/


    mlcbWss =  (getU32(0x018e));
  

/*
offset in table stream of document property data
                  structure.

Name: fcDop(attribute)
Offset: 0x0192
Mask: 
Shift:  0
*/


    mfcDop =  (getU32(0x0192));
  

/*
count of bytes of document properties.

Name: lcbDop(attribute)
Offset: 0x0196
Mask: 
Shift:  0
*/


    mlcbDop =  (getU32(0x0196));
  

/*
offset in table stream of STTBF of associated strings. The
                  strings in this table specify document summary info and the paths
                  to special documents related to this document. See documentation of
                  the STTBFASSOC.

Name: fcSttbfAssoc(attribute)
Offset: 0x019a
Mask: 
Shift:  0
*/


    mfcSttbfAssoc =  (getU32(0x019a));
  

/*


Name: lcbSttbfAssoc(attribute)
Offset: 0x019e
Mask: 
Shift:  0
*/


    mlcbSttbfAssoc =  (getU32(0x019e));
  

/*
offset in table stream of beginning of information for
                  complex files. Consists of an encoding of all of the
                  prms quoted by the document followed by the plcpcd
                  (piece table) for the document.

Name: fcClx(attribute)
Offset: 0x01a2
Mask: 
Shift:  0
*/


    mfcClx =  (getU32(0x01a2));
  

/*
count of bytes of complex file information == 0 if file is
                  non-complex.

Name: lcbClx(attribute)
Offset: 0x01a6
Mask: 
Shift:  0
*/


    mlcbClx =  (getU32(0x01a6));
  

/*
not used

Name: fcPlcfpgdFtn(attribute)
Offset: 0x01aa
Mask: 
Shift:  0
*/


    mfcPlcfpgdFtn =  (getU32(0x01aa));
  

/*


Name: lcbPlcfpgdFtn(attribute)
Offset: 0x01ae
Mask: 
Shift:  0
*/


    mlcbPlcfpgdFtn =  (getU32(0x01ae));
  

/*
offset in table stream of the name of the original file.
                  fcAutosaveSource and cbAutosaveSource should both be 0 if autosave
                  is off.

Name: fcAutosaveSource(attribute)
Offset: 0x01b2
Mask: 
Shift:  0
*/


    mfcAutosaveSource =  (getU32(0x01b2));
  

/*
count of bytes of the name of the original file.

Name: lcbAutosaveSource(attribute)
Offset: 0x01b6
Mask: 
Shift:  0
*/


    mlcbAutosaveSource =  (getU32(0x01b6));
  

/*
offset in table stream of group of strings recording the names
                  of the owners of annotations stored in the document

Name: fcGrpXstAtnOwners(attribute)
Offset: 0x01ba
Mask: 
Shift:  0
*/


    mfcGrpXstAtnOwners =  (getU32(0x01ba));
  

/*
count of bytes of the group of strings

Name: lcbGrpXstAtnOwners(attribute)
Offset: 0x01be
Mask: 
Shift:  0
*/


    mlcbGrpXstAtnOwners =  (getU32(0x01be));
  

/*
offset in table stream of the sttbf that records names of
                  bookmarks for the annotation subdocument

Name: fcSttbfAtnbkmk(attribute)
Offset: 0x01c2
Mask: 
Shift:  0
*/


    mfcSttbfAtnbkmk =  (getU32(0x01c2));
  

/*
length in bytes of the sttbf that records names of bookmarks
                  for the annotation subdocument

Name: lcbSttbfAtnbkmk(attribute)
Offset: 0x01c6
Mask: 
Shift:  0
*/


    mlcbSttbfAtnbkmk =  (getU32(0x01c6));
  

/*
no longer used

Name: fcPlcdoaMom(attribute)
Offset: 0x01ca
Mask: 
Shift:  0
*/


    mfcPlcdoaMom =  (getU32(0x01ca));
  

/*


Name: lcbPlcdoaMom(attribute)
Offset: 0x01ce
Mask: 
Shift:  0
*/


    mlcbPlcdoaMom =  (getU32(0x01ce));
  

/*
no longer used

Name: fcPlcdoaHdr(attribute)
Offset: 0x01d2
Mask: 
Shift:  0
*/


    mfcPlcdoaHdr =  (getU32(0x01d2));
  

/*


Name: lcbPlcdoaHdr(attribute)
Offset: 0x01d6
Mask: 
Shift:  0
*/


    mlcbPlcdoaHdr =  (getU32(0x01d6));
  

/*
offset in table stream of the FSPA PLC for main
                  document. == 0 if document has no office art objects.

Name: fcPlcspaMom(attribute)
Offset: 0x01da
Mask: 
Shift:  0
*/


    mfcPlcspaMom =  (getU32(0x01da));
  

/*
length in bytes of the FSPA PLC of the main
                  document.

Name: lcbPlcspaMom(attribute)
Offset: 0x01de
Mask: 
Shift:  0
*/


    mlcbPlcspaMom =  (getU32(0x01de));
  

/*
offset in table stream of the FSPA PLC for header
                  document. == 0 if document has no office art objects.

Name: fcPlcspaHdr(attribute)
Offset: 0x01e2
Mask: 
Shift:  0
*/


    mfcPlcspaHdr =  (getU32(0x01e2));
  

/*
length in bytes of the FSPA PLC of the header
                  document.

Name: lcbPlcspaHdr(attribute)
Offset: 0x01e6
Mask: 
Shift:  0
*/


    mlcbPlcspaHdr =  (getU32(0x01e6));
  

/*
offset in table stream of BKF (bookmark first) PLC of the
                  annotation subdocument

Name: fcPlcfAtnbkf(attribute)
Offset: 0x01ea
Mask: 
Shift:  0
*/


    mfcPlcfAtnbkf =  (getU32(0x01ea));
  

/*
length in bytes of BKF (bookmark first) PLC of the annotation
                  subdocument

Name: lcbPlcfAtnbkf(attribute)
Offset: 0x01ee
Mask: 
Shift:  0
*/


    mlcbPlcfAtnbkf =  (getU32(0x01ee));
  

/*
offset in table stream of BKL (bookmark last) PLC of the
                  annotation subdocument

Name: fcPlcfAtnbkl(attribute)
Offset: 0x01f2
Mask: 
Shift:  0
*/


    mfcPlcfAtnbkl =  (getU32(0x01f2));
  

/*
length in bytes of PLC marking the CP limits of the annotation
                  bookmarks. No structure is stored in this PLC.

Name: lcbPlcfAtnbkl(attribute)
Offset: 0x01f6
Mask: 
Shift:  0
*/


    mlcbPlcfAtnbkl =  (getU32(0x01f6));
  

/*
offset in table stream of PMS (Print Merge State) information
                  block. This contains the current state of a print merge
                  operation

Name: fcPms(attribute)
Offset: 0x01fa
Mask: 
Shift:  0
*/


    mfcPms =  (getU32(0x01fa));
  

/*
length in bytes of PMS. ==0 if no current print merge state.
                  Should not be written by third party creators of Word files.

Name: lcbPms(attribute)
Offset: 0x01fe
Mask: 
Shift:  0
*/


    mlcbPms =  (getU32(0x01fe));
  

/*
offset in table stream of form field Sttbf which contains
                  strings used in form field dropdown controls

Name: fcFormFldSttbf(attribute)
Offset: 0x0202
Mask: 
Shift:  0
*/


    mfcFormFldSttbf =  (getU32(0x0202));
  

/*
length in bytes of form field Sttbf

Name: lcbFormFldSttbf(attribute)
Offset: 0x0206
Mask: 
Shift:  0
*/


    mlcbFormFldSttbf =  (getU32(0x0206));
  

/*
offset in table stream of endnote reference PLCF of FRD
                  structures. CPs in PLCF are relative to main document text stream
                  and give location of endnote references.

Name: fcPlcfendRef(attribute)
Offset: 0x020a
Mask: 
Shift:  0
*/


    mfcPlcfendRef =  (getU32(0x020a));
  

/*


Name: lcbPlcfendRef(attribute)
Offset: 0x020e
Mask: 
Shift:  0
*/


    mlcbPlcfendRef =  (getU32(0x020e));
  

/*
offset in table stream of PlcfendRef which points to endnote
                  text in the endnote document stream which corresponds with the
                  plcfendRef. No structure is stored in this PLC.

Name: fcPlcfendTxt(attribute)
Offset: 0x0212
Mask: 
Shift:  0
*/


    mfcPlcfendTxt =  (getU32(0x0212));
  

/*


Name: lcbPlcfendTxt(attribute)
Offset: 0x0216
Mask: 
Shift:  0
*/


    mlcbPlcfendTxt =  (getU32(0x0216));
  

/*
offset in table stream to FLD PLCF of field positions in the
                  endnote subdoc

Name: fcPlcffldEdn(attribute)
Offset: 0x021a
Mask: 
Shift:  0
*/


    mfcPlcffldEdn =  (getU32(0x021a));
  

/*


Name: lcbPlcffldEdn(attribute)
Offset: 0x021e
Mask: 
Shift:  0
*/


    mlcbPlcffldEdn =  (getU32(0x021e));
  

/*
not used

Name: fcPlcfpgdEdn(attribute)
Offset: 0x0222
Mask: 
Shift:  0
*/


    mfcPlcfpgdEdn =  (getU32(0x0222));
  

/*


Name: lcbPlcfpgdEdn(attribute)
Offset: 0x0226
Mask: 
Shift:  0
*/


    mlcbPlcfpgdEdn =  (getU32(0x0226));
  

/*
offset in table stream of the office art object table data. The
                  format of office art object table data is found in a separate
                  document.

Name: fcDggInfo(attribute)
Offset: 0x022a
Mask: 
Shift:  0
*/


    mfcDggInfo =  (getU32(0x022a));
  

/*
length in bytes of the office art object table data

Name: lcbDggInfo(attribute)
Offset: 0x022e
Mask: 
Shift:  0
*/


    mlcbDggInfo =  (getU32(0x022e));
  

/*
offset in table stream to STTBF that records the author
                  abbreviations for authors who have made revisions in the
                  document.

Name: fcSttbfRMark(attribute)
Offset: 0x0232
Mask: 
Shift:  0
*/


    mfcSttbfRMark =  (getU32(0x0232));
  

/*


Name: lcbSttbfRMark(attribute)
Offset: 0x0236
Mask: 
Shift:  0
*/


    mlcbSttbfRMark =  (getU32(0x0236));
  

/*
offset in table stream to STTBF that records caption titles
                  used in the document.

Name: fcSttbfCaption(attribute)
Offset: 0x023a
Mask: 
Shift:  0
*/


    mfcSttbfCaption =  (getU32(0x023a));
  

/*


Name: lcbSttbfCaption(attribute)
Offset: 0x023e
Mask: 
Shift:  0
*/


    mlcbSttbfCaption =  (getU32(0x023e));
  

/*
offset in table stream to the STTBF that records the object
                  names and indices into the caption STTBF for objects which get auto
                  captions.

Name: fcSttbfAutoCaption(attribute)
Offset: 0x0242
Mask: 
Shift:  0
*/


    mfcSttbfAutoCaption =  (getU32(0x0242));
  

/*


Name: lcbSttbfAutoCaption(attribute)
Offset: 0x0246
Mask: 
Shift:  0
*/


    mlcbSttbfAutoCaption =  (getU32(0x0246));
  

/*
offset in table stream to WKB PLCF that describes the
                  boundaries of contributing documents in a master document

Name: fcPlcfwkb(attribute)
Offset: 0x024a
Mask: 
Shift:  0
*/


    mfcPlcfwkb =  (getU32(0x024a));
  

/*


Name: lcbPlcfwkb(attribute)
Offset: 0x024e
Mask: 
Shift:  0
*/


    mlcbPlcfwkb =  (getU32(0x024e));
  

/*
offset in table stream of PLCF (of SPLS structures) that
                  records spell check state

Name: fcPlcfspl(attribute)
Offset: 0x0252
Mask: 
Shift:  0
*/


    mfcPlcfspl =  (getU32(0x0252));
  

/*


Name: lcbPlcfspl(attribute)
Offset: 0x0256
Mask: 
Shift:  0
*/


    mlcbPlcfspl =  (getU32(0x0256));
  

/*
offset in table stream of PLCF that records the beginning CP in
                  the text box subdoc of the text of individual text box entries. No
                  structure is stored in this PLCF

Name: fcPlcftxbxTxt(attribute)
Offset: 0x025a
Mask: 
Shift:  0
*/


    mfcPlcftxbxTxt =  (getU32(0x025a));
  

/*


Name: lcbPlcftxbxTxt(attribute)
Offset: 0x025e
Mask: 
Shift:  0
*/


    mlcbPlcftxbxTxt =  (getU32(0x025e));
  

/*
offset in table stream of the FLD PLCF that records field
                  boundaries recorded in the textbox subdoc.

Name: fcPlcffldTxbx(attribute)
Offset: 0x0262
Mask: 
Shift:  0
*/


    mfcPlcffldTxbx =  (getU32(0x0262));
  

/*


Name: lcbPlcffldTxbx(attribute)
Offset: 0x0266
Mask: 
Shift:  0
*/


    mlcbPlcffldTxbx =  (getU32(0x0266));
  

/*
offset in table stream of PLCF that records the beginning CP in
                  the header text box subdoc of the text of individual header text
                  box entries. No structure is stored in this PLC.

Name: fcPlcfHdrtxbxTxt(attribute)
Offset: 0x026a
Mask: 
Shift:  0
*/


    mfcPlcfHdrtxbxTxt =  (getU32(0x026a));
  

/*


Name: lcbPlcfHdrtxbxTxt(attribute)
Offset: 0x026e
Mask: 
Shift:  0
*/


    mlcbPlcfHdrtxbxTxt =  (getU32(0x026e));
  

/*
offset in table stream of the FLD PLCF that records field
                  boundaries recorded in the header textbox subdoc.

Name: fcPlcffldHdrTxbx(attribute)
Offset: 0x0272
Mask: 
Shift:  0
*/


    mfcPlcffldHdrTxbx =  (getU32(0x0272));
  

/*


Name: lcbPlcffldHdrTxbx(attribute)
Offset: 0x0276
Mask: 
Shift:  0
*/


    mlcbPlcffldHdrTxbx =  (getU32(0x0276));
  

/*
Macro User storage

Name: fcStwUser(attribute)
Offset: 0x027a
Mask: 
Shift:  0
*/


    mfcStwUser =  (getU32(0x027a));
  

/*


Name: lcbStwUser(attribute)
Offset: 0x027e
Mask: 
Shift:  0
*/


    mlcbStwUser =  (getU32(0x027e));
  

/*
offset in table stream of embedded true type font data.

Name: fcSttbttmbd(attribute)
Offset: 0x0282
Mask: 
Shift:  0
*/


    mfcSttbttmbd =  (getU32(0x0282));
  

/*


Name: lcbSttbttmbd(attribute)
Offset: 0x0286
Mask: 
Shift:  0
*/


    mlcbSttbttmbd =  (getU32(0x0286));
  

/*


Name: fcUnused(attribute)
Offset: 0x028a
Mask: 
Shift:  0
*/


    mfcUnused =  (getU32(0x028a));
  

/*


Name: lcbUnused(attribute)
Offset: 0x028e
Mask: 
Shift:  0
*/


    mlcbUnused =  (getU32(0x028e));
  

/*
(FCPGD, beginning of array of fcPgd / fcBkd pairs
                  rgpgdbkd).
                  offset in table stream of the PLF that records the page descriptors
                  for the main text of the doc.

Name: fcPgdMother(attribute)
Offset: 0x0292
Mask: 
Shift:  0
*/


    mfcPgdMother =  (getU32(0x0292));
  

/*


Name: lcbPgdMother(attribute)
Offset: 0x0296
Mask: 
Shift:  0
*/


    mlcbPgdMother =  (getU32(0x0296));
  

/*
offset in table stream of the PLCF that records the break
                  descriptors for the main text of the doc.

Name: fcBkdMother(attribute)
Offset: 0x029a
Mask: 
Shift:  0
*/


    mfcBkdMother =  (getU32(0x029a));
  

/*


Name: lcbBkdMother(attribute)
Offset: 0x029e
Mask: 
Shift:  0
*/


    mlcbBkdMother =  (getU32(0x029e));
  

/*
offset in table stream of the PLF that records the page
                  descriptors for the footnote text of the doc.

Name: fcPgdFtn(attribute)
Offset: 0x02a2
Mask: 
Shift:  0
*/


    mfcPgdFtn =  (getU32(0x02a2));
  

/*


Name: lcbPgdFtn(attribute)
Offset: 0x02a6
Mask: 
Shift:  0
*/


    mlcbPgdFtn =  (getU32(0x02a6));
  

/*
offset in table stream of the PLCF that records the break
                  descriptors for the footnote text of the doc.

Name: fcBkdFtn(attribute)
Offset: 0x02aa
Mask: 
Shift:  0
*/


    mfcBkdFtn =  (getU32(0x02aa));
  

/*


Name: lcbBkdFtn(attribute)
Offset: 0x02ae
Mask: 
Shift:  0
*/


    mlcbBkdFtn =  (getU32(0x02ae));
  

/*
offset in table stream of the PLF that records the page
                  descriptors for the endnote text of the doc.

Name: fcPgdEdn(attribute)
Offset: 0x02b2
Mask: 
Shift:  0
*/


    mfcPgdEdn =  (getU32(0x02b2));
  

/*


Name: lcbPgdEdn(attribute)
Offset: 0x02b6
Mask: 
Shift:  0
*/


    mlcbPgdEdn =  (getU32(0x02b6));
  

/*
offset in table stream of the PLCF that records the break
                  descriptors for the endnote text of the doc.

Name: fcBkdEdn(attribute)
Offset: 0x02ba
Mask: 
Shift:  0
*/


    mfcBkdEdn =  (getU32(0x02ba));
  

/*


Name: lcbBkdEdn(attribute)
Offset: 0x02be
Mask: 
Shift:  0
*/


    mlcbBkdEdn =  (getU32(0x02be));
  

/*
offset in table stream of the STTBF containing field keywords.
                  This is only used in a small number of the international versions
                  of word. This field is no longer written to the file for nFib >=
                  167.

Name: fcSttbfIntlFld(attribute)
Offset: 0x02c2
Mask: 
Shift:  0
*/


    mfcSttbfIntlFld =  (getU32(0x02c2));
  

/*
Always 0 for nFib >= 167.

Name: lcbSttbfIntlFld(attribute)
Offset: 0x02c6
Mask: 
Shift:  0
*/


    mlcbSttbfIntlFld =  (getU32(0x02c6));
  

/*
offset in table stream of a mailer routing slip.

Name: fcRouteSlip(attribute)
Offset: 0x02ca
Mask: 
Shift:  0
*/


    mfcRouteSlip =  (getU32(0x02ca));
  

/*


Name: lcbRouteSlip(attribute)
Offset: 0x02ce
Mask: 
Shift:  0
*/


    mlcbRouteSlip =  (getU32(0x02ce));
  

/*
offset in table stream of STTBF recording the names of the
                  users who have saved this document alternating with the save
                  locations.

Name: fcSttbSavedBy(attribute)
Offset: 0x02d2
Mask: 
Shift:  0
*/


    mfcSttbSavedBy =  (getU32(0x02d2));
  

/*


Name: lcbSttbSavedBy(attribute)
Offset: 0x02d6
Mask: 
Shift:  0
*/


    mlcbSttbSavedBy =  (getU32(0x02d6));
  

/*
offset in table stream of STTBF recording filenames of
                  documents which are referenced by this document.

Name: fcSttbFnm(attribute)
Offset: 0x02da
Mask: 
Shift:  0
*/


    mfcSttbFnm =  (getU32(0x02da));
  

/*


Name: lcbSttbFnm(attribute)
Offset: 0x02de
Mask: 
Shift:  0
*/


    mlcbSttbFnm =  (getU32(0x02de));
  

/*
offset in the table stream of list format information.

Name: fcPlcfLst(attribute)
Offset: 0x02e2
Mask: 
Shift:  0
*/


    mfcPlcfLst =  (getU32(0x02e2));
  

/*


Name: lcbPlcfLst(attribute)
Offset: 0x02e6
Mask: 
Shift:  0
*/


    mlcbPlcfLst =  (getU32(0x02e6));
  

/*
offset in the table stream of list format override
                  information.

Name: fcPlfLfo(attribute)
Offset: 0x02ea
Mask: 
Shift:  0
*/


    mfcPlfLfo =  (getU32(0x02ea));
  

/*


Name: lcbPlfLfo(attribute)
Offset: 0x02ee
Mask: 
Shift:  0
*/


    mlcbPlfLfo =  (getU32(0x02ee));
  

/*
offset in the table stream of the textbox break table (a PLCF
                  of BKDs) for the main document

Name: fcPlcftxbxBkd(attribute)
Offset: 0x02f2
Mask: 
Shift:  0
*/


    mfcPlcftxbxBkd =  (getU32(0x02f2));
  

/*


Name: lcbPlcftxbxBkd(attribute)
Offset: 0x02f6
Mask: 
Shift:  0
*/


    mlcbPlcftxbxBkd =  (getU32(0x02f6));
  

/*
offset in the table stream of the textbox break table (a PLCF
                  of BKDs) for the header subdocument

Name: fcPlcftxbxHdrBkd(attribute)
Offset: 0x02fa
Mask: 
Shift:  0
*/


    mfcPlcftxbxHdrBkd =  (getU32(0x02fa));
  

/*


Name: lcbPlcftxbxHdrBkd(attribute)
Offset: 0x02fe
Mask: 
Shift:  0
*/


    mlcbPlcftxbxHdrBkd =  (getU32(0x02fe));
  

/*
offset in main stream of undocumented undo / versioning
                  data

Name: fcDocUndo(attribute)
Offset: 0x0302
Mask: 
Shift:  0
*/


    mfcDocUndo =  (getU32(0x0302));
  

/*


Name: lcbDocUndo(attribute)
Offset: 0x0306
Mask: 
Shift:  0
*/


    mlcbDocUndo =  (getU32(0x0306));
  

/*
offset in main stream of undocumented undo / versioning
                  data

Name: fcRgbuse(attribute)
Offset: 0x030a
Mask: 
Shift:  0
*/


    mfcRgbuse =  (getU32(0x030a));
  

/*


Name: lcbRgbuse(attribute)
Offset: 0x030e
Mask: 
Shift:  0
*/


    mlcbRgbuse =  (getU32(0x030e));
  

/*
offset in main stream of undocumented undo / versioning
                  data

Name: fcUsp(attribute)
Offset: 0x0312
Mask: 
Shift:  0
*/


    mfcUsp =  (getU32(0x0312));
  

/*


Name: lcbUsp(attribute)
Offset: 0x0316
Mask: 
Shift:  0
*/


    mlcbUsp =  (getU32(0x0316));
  

/*
offset in table stream of undocumented undo / versioning
                  data

Name: fcUskf(attribute)
Offset: 0x031a
Mask: 
Shift:  0
*/


    mfcUskf =  (getU32(0x031a));
  

/*


Name: lcbUskf(attribute)
Offset: 0x031e
Mask: 
Shift:  0
*/


    mlcbUskf =  (getU32(0x031e));
  

/*
offset in table stream of undocumented undo / versioning
                  data

Name: fcPlcupcRgbuse(attribute)
Offset: 0x0322
Mask: 
Shift:  0
*/


    mfcPlcupcRgbuse =  (getU32(0x0322));
  

/*


Name: lcbPlcupcRgbuse(attribute)
Offset: 0x0326
Mask: 
Shift:  0
*/


    mlcbPlcupcRgbuse =  (getU32(0x0326));
  

/*
offset in table stream of undocumented undo / versioning
                  data

Name: fcPlcupcUsp(attribute)
Offset: 0x032a
Mask: 
Shift:  0
*/


    mfcPlcupcUsp =  (getU32(0x032a));
  

/*


Name: lcbPlcupcUsp(attribute)
Offset: 0x032e
Mask: 
Shift:  0
*/


    mlcbPlcupcUsp =  (getU32(0x032e));
  

/*
offset in table stream of string table of style names for
                  glossary entries

Name: fcSttbGlsyStyle(attribute)
Offset: 0x0332
Mask: 
Shift:  0
*/


    mfcSttbGlsyStyle =  (getU32(0x0332));
  

/*


Name: lcbSttbGlsyStyle(attribute)
Offset: 0x0336
Mask: 
Shift:  0
*/


    mlcbSttbGlsyStyle =  (getU32(0x0336));
  

/*
offset in table stream of undocumented grammar options PL

Name: fcPlgosl(attribute)
Offset: 0x033a
Mask: 
Shift:  0
*/


    mfcPlgosl =  (getU32(0x033a));
  

/*


Name: lcbPlgosl(attribute)
Offset: 0x033e
Mask: 
Shift:  0
*/


    mlcbPlgosl =  (getU32(0x033e));
  

/*
offset in table stream of undocumented ocx data

Name: fcPlcocx(attribute)
Offset: 0x0342
Mask: 
Shift:  0
*/


    mfcPlcocx =  (getU32(0x0342));
  

/*


Name: lcbPlcocx(attribute)
Offset: 0x0346
Mask: 
Shift:  0
*/


    mlcbPlcocx =  (getU32(0x0346));
  

/*
offset in table stream of character property bin table.PLC. FCs
                  in PLC are file offsets. Describes text of main document and all
                  subdocuments.

Name: fcPlcfbteLvc(attribute)
Offset: 0x034a
Mask: 
Shift:  0
*/


    mfcPlcfbteLvc =  (getU32(0x034a));
  

/*


Name: lcbPlcfbteLvc(attribute)
Offset: 0x034e
Mask: 
Shift:  0
*/


    mlcbPlcfbteLvc =  (getU32(0x034e));
  

/*
(a.k.a FILETIME ftModified)

Name: dwLowDateTime(attribute)
Offset: 0x0352
Mask: 
Shift:  0
*/


    mdwLowDateTime =  (getU32(0x0352));
  

/*


Name: dwHighDateTime(attribute)
Offset: 0x0356
Mask: 
Shift:  0
*/


    mdwHighDateTime =  (getU32(0x0356));
  

/*
offset in table stream of LVC PLCF

Name: fcPlcflvc(attribute)
Offset: 0x035a
Mask: 
Shift:  0
*/


    mfcPlcflvc =  (getU32(0x035a));
  

/*
size of LVC PLCF, ==0 for non-complex files

Name: lcbPlcflvc(attribute)
Offset: 0x035e
Mask: 
Shift:  0
*/


    mlcbPlcflvc =  (getU32(0x035e));
  

/*
offset in table stream of autosummary ASUMY PLCF.

Name: fcPlcasumy(attribute)
Offset: 0x0362
Mask: 
Shift:  0
*/


    mfcPlcasumy =  (getU32(0x0362));
  

/*


Name: lcbPlcasumy(attribute)
Offset: 0x0366
Mask: 
Shift:  0
*/


    mlcbPlcasumy =  (getU32(0x0366));
  

/*
offset in table stream of PLCF (of SPLS structures) which
                  records grammar check state

Name: fcPlcfgram(attribute)
Offset: 0x036a
Mask: 
Shift:  0
*/


    mfcPlcfgram =  (getU32(0x036a));
  

/*


Name: lcbPlcfgram(attribute)
Offset: 0x036e
Mask: 
Shift:  0
*/


    mlcbPlcfgram =  (getU32(0x036e));
  

/*
offset in table stream of list names string table

Name: fcSttbListNames(attribute)
Offset: 0x0372
Mask: 
Shift:  0
*/


    mfcSttbListNames =  (getU32(0x0372));
  

/*


Name: lcbSttbListNames(attribute)
Offset: 0x0376
Mask: 
Shift:  0
*/


    mlcbSttbListNames =  (getU32(0x0376));
  

/*
offset in table stream of undocumented undo / versioning
                  data

Name: fcSttbfUssr(attribute)
Offset: 0x037a
Mask: 
Shift:  0
*/


    mfcSttbfUssr =  (getU32(0x037a));
  

/*


Name: lcbSttbfUssr(attribute)
Offset: 0x037e
Mask: 
Shift:  0
*/


    mlcbSttbfUssr =  (getU32(0x037e));
  
    }

    void WW8Fib::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_wIdent());
                rHandler.attribute(NS_rtf::LN_WIDENT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_nFib());
                rHandler.attribute(NS_rtf::LN_NFIB, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_nProduct());
                rHandler.attribute(NS_rtf::LN_NPRODUCT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lid());
                rHandler.attribute(NS_rtf::LN_LID, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnNext());
                rHandler.attribute(NS_rtf::LN_PNNEXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fDot());
                rHandler.attribute(NS_rtf::LN_FDOT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fGlsy());
                rHandler.attribute(NS_rtf::LN_FGLSY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fComplex());
                rHandler.attribute(NS_rtf::LN_FCOMPLEX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fHasPic());
                rHandler.attribute(NS_rtf::LN_FHASPIC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cQuickSaves());
                rHandler.attribute(NS_rtf::LN_CQUICKSAVES, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fEncrypted());
                rHandler.attribute(NS_rtf::LN_FENCRYPTED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fWhichTblStm());
                rHandler.attribute(NS_rtf::LN_FWHICHTBLSTM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fReadOnlyRecommended());
                rHandler.attribute(NS_rtf::LN_FREADONLYRECOMMENDED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fWriteReservation());
                rHandler.attribute(NS_rtf::LN_FWRITERESERVATION, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fExtChar());
                rHandler.attribute(NS_rtf::LN_FEXTCHAR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fLoadOverride());
                rHandler.attribute(NS_rtf::LN_FLOADOVERRIDE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fFarEast());
                rHandler.attribute(NS_rtf::LN_FFAREAST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fCrypto());
                rHandler.attribute(NS_rtf::LN_FCRYPTO, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_nFibBack());
                rHandler.attribute(NS_rtf::LN_NFIBBACK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lKey());
                rHandler.attribute(NS_rtf::LN_LKEY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_envr());
                rHandler.attribute(NS_rtf::LN_ENVR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fMac());
                rHandler.attribute(NS_rtf::LN_FMAC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fEmptySpecial());
                rHandler.attribute(NS_rtf::LN_FEMPTYSPECIAL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fLoadOverridePage());
                rHandler.attribute(NS_rtf::LN_FLOADOVERRIDEPAGE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fFutureSavedUndo());
                rHandler.attribute(NS_rtf::LN_FFUTURESAVEDUNDO, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fWord97Saved());
                rHandler.attribute(NS_rtf::LN_FWORD97SAVED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fSpare0());
                rHandler.attribute(NS_rtf::LN_FSPARE0, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_chs());
                rHandler.attribute(NS_rtf::LN_CHS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_chsTables());
                rHandler.attribute(NS_rtf::LN_CHSTABLES, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcMin());
                rHandler.attribute(NS_rtf::LN_FCMIN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcMac());
                rHandler.attribute(NS_rtf::LN_FCMAC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_csw());
                rHandler.attribute(NS_rtf::LN_CSW, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_wMagicCreated());
                rHandler.attribute(NS_rtf::LN_WMAGICCREATED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_wMagicRevised());
                rHandler.attribute(NS_rtf::LN_WMAGICREVISED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_wMagicCreatedPrivate());
                rHandler.attribute(NS_rtf::LN_WMAGICCREATEDPRIVATE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_wMagicRevisedPrivate());
                rHandler.attribute(NS_rtf::LN_WMAGICREVISEDPRIVATE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnFbpChpFirst_W6());
                rHandler.attribute(NS_rtf::LN_PNFBPCHPFIRST_W6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnChpFirst_W6());
                rHandler.attribute(NS_rtf::LN_PNCHPFIRST_W6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cpnBteChp_W6());
                rHandler.attribute(NS_rtf::LN_CPNBTECHP_W6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnFbpPapFirst_W6());
                rHandler.attribute(NS_rtf::LN_PNFBPPAPFIRST_W6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnPapFirst_W6());
                rHandler.attribute(NS_rtf::LN_PNPAPFIRST_W6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cpnBtePap_W6());
                rHandler.attribute(NS_rtf::LN_CPNBTEPAP_W6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnFbpLvcFirst_W6());
                rHandler.attribute(NS_rtf::LN_PNFBPLVCFIRST_W6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnLvcFirst_W6());
                rHandler.attribute(NS_rtf::LN_PNLVCFIRST_W6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cpnBteLvc_W6());
                rHandler.attribute(NS_rtf::LN_CPNBTELVC_W6, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lidFE());
                rHandler.attribute(NS_rtf::LN_LIDFE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_clw());
                rHandler.attribute(NS_rtf::LN_CLW, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cbMac());
                rHandler.attribute(NS_rtf::LN_CBMAC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lProductCreated());
                rHandler.attribute(NS_rtf::LN_LPRODUCTCREATED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lProductRevised());
                rHandler.attribute(NS_rtf::LN_LPRODUCTREVISED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ccpText());
                rHandler.attribute(NS_rtf::LN_CCPTEXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ccpFtn());
                rHandler.attribute(NS_rtf::LN_CCPFTN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ccpHdd());
                rHandler.attribute(NS_rtf::LN_CCPHDD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ccpMcr());
                rHandler.attribute(NS_rtf::LN_CCPMCR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ccpAtn());
                rHandler.attribute(NS_rtf::LN_CCPATN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ccpEdn());
                rHandler.attribute(NS_rtf::LN_CCPEDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ccpTxbx());
                rHandler.attribute(NS_rtf::LN_CCPTXBX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ccpHdrTxbx());
                rHandler.attribute(NS_rtf::LN_CCPHDRTXBX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnFbpChpFirst());
                rHandler.attribute(NS_rtf::LN_PNFBPCHPFIRST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnChpFirst());
                rHandler.attribute(NS_rtf::LN_PNCHPFIRST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cpnBteChp());
                rHandler.attribute(NS_rtf::LN_CPNBTECHP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnFbpPapFirst());
                rHandler.attribute(NS_rtf::LN_PNFBPPAPFIRST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnPapFirst());
                rHandler.attribute(NS_rtf::LN_PNPAPFIRST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cpnBtePap());
                rHandler.attribute(NS_rtf::LN_CPNBTEPAP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnFbpLvcFirst());
                rHandler.attribute(NS_rtf::LN_PNFBPLVCFIRST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_pnLvcFirst());
                rHandler.attribute(NS_rtf::LN_PNLVCFIRST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cpnBteLvc());
                rHandler.attribute(NS_rtf::LN_CPNBTELVC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcIslandFirst());
                rHandler.attribute(NS_rtf::LN_FCISLANDFIRST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcIslandLim());
                rHandler.attribute(NS_rtf::LN_FCISLANDLIM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cfclcb());
                rHandler.attribute(NS_rtf::LN_CFCLCB, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcStshfOrig());
                rHandler.attribute(NS_rtf::LN_FCSTSHFORIG, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbStshfOrig());
                rHandler.attribute(NS_rtf::LN_LCBSTSHFORIG, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcStshf());
                rHandler.attribute(NS_rtf::LN_FCSTSHF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbStshf());
                rHandler.attribute(NS_rtf::LN_LCBSTSHF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffndRef());
                rHandler.attribute(NS_rtf::LN_FCPLCFFNDREF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffndRef());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFNDREF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffndTxt());
                rHandler.attribute(NS_rtf::LN_FCPLCFFNDTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffndTxt());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFNDTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfandRef());
                rHandler.attribute(NS_rtf::LN_FCPLCFANDREF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfandRef());
                rHandler.attribute(NS_rtf::LN_LCBPLCFANDREF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfandTxt());
                rHandler.attribute(NS_rtf::LN_FCPLCFANDTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfandTxt());
                rHandler.attribute(NS_rtf::LN_LCBPLCFANDTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfsed());
                rHandler.attribute(NS_rtf::LN_FCPLCFSED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfsed());
                rHandler.attribute(NS_rtf::LN_LCBPLCFSED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfpad());
                rHandler.attribute(NS_rtf::LN_FCPLCFPAD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfpad());
                rHandler.attribute(NS_rtf::LN_LCBPLCFPAD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfphe());
                rHandler.attribute(NS_rtf::LN_FCPLCFPHE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfphe());
                rHandler.attribute(NS_rtf::LN_LCBPLCFPHE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfglsy());
                rHandler.attribute(NS_rtf::LN_FCSTTBFGLSY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfglsy());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFGLSY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfglsy());
                rHandler.attribute(NS_rtf::LN_FCPLCFGLSY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfglsy());
                rHandler.attribute(NS_rtf::LN_LCBPLCFGLSY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfhdd());
                rHandler.attribute(NS_rtf::LN_FCPLCFHDD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfhdd());
                rHandler.attribute(NS_rtf::LN_LCBPLCFHDD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfbteChpx());
                rHandler.attribute(NS_rtf::LN_FCPLCFBTECHPX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfbteChpx());
                rHandler.attribute(NS_rtf::LN_LCBPLCFBTECHPX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfbtePapx());
                rHandler.attribute(NS_rtf::LN_FCPLCFBTEPAPX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfbtePapx());
                rHandler.attribute(NS_rtf::LN_LCBPLCFBTEPAPX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfsea());
                rHandler.attribute(NS_rtf::LN_FCPLCFSEA, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfsea());
                rHandler.attribute(NS_rtf::LN_LCBPLCFSEA, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfffn());
                rHandler.attribute(NS_rtf::LN_FCSTTBFFFN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfffn());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFFFN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffldMom());
                rHandler.attribute(NS_rtf::LN_FCPLCFFLDMOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffldMom());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFLDMOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffldHdr());
                rHandler.attribute(NS_rtf::LN_FCPLCFFLDHDR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffldHdr());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFLDHDR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffldFtn());
                rHandler.attribute(NS_rtf::LN_FCPLCFFLDFTN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffldFtn());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFLDFTN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffldAtn());
                rHandler.attribute(NS_rtf::LN_FCPLCFFLDATN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffldAtn());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFLDATN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffldMcr());
                rHandler.attribute(NS_rtf::LN_FCPLCFFLDMCR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffldMcr());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFLDMCR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfbkmk());
                rHandler.attribute(NS_rtf::LN_FCSTTBFBKMK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfbkmk());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFBKMK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfbkf());
                rHandler.attribute(NS_rtf::LN_FCPLCFBKF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfbkf());
                rHandler.attribute(NS_rtf::LN_LCBPLCFBKF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfbkl());
                rHandler.attribute(NS_rtf::LN_FCPLCFBKL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfbkl());
                rHandler.attribute(NS_rtf::LN_LCBPLCFBKL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcCmds());
                rHandler.attribute(NS_rtf::LN_FCCMDS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbCmds());
                rHandler.attribute(NS_rtf::LN_LCBCMDS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcmcr());
                rHandler.attribute(NS_rtf::LN_FCPLCMCR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcmcr());
                rHandler.attribute(NS_rtf::LN_LCBPLCMCR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfmcr());
                rHandler.attribute(NS_rtf::LN_FCSTTBFMCR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfmcr());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFMCR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPrDrvr());
                rHandler.attribute(NS_rtf::LN_FCPRDRVR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPrDrvr());
                rHandler.attribute(NS_rtf::LN_LCBPRDRVR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPrEnvPort());
                rHandler.attribute(NS_rtf::LN_FCPRENVPORT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPrEnvPort());
                rHandler.attribute(NS_rtf::LN_LCBPRENVPORT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPrEnvLand());
                rHandler.attribute(NS_rtf::LN_FCPRENVLAND, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPrEnvLand());
                rHandler.attribute(NS_rtf::LN_LCBPRENVLAND, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcWss());
                rHandler.attribute(NS_rtf::LN_FCWSS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbWss());
                rHandler.attribute(NS_rtf::LN_LCBWSS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcDop());
                rHandler.attribute(NS_rtf::LN_FCDOP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbDop());
                rHandler.attribute(NS_rtf::LN_LCBDOP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfAssoc());
                rHandler.attribute(NS_rtf::LN_FCSTTBFASSOC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfAssoc());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFASSOC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcClx());
                rHandler.attribute(NS_rtf::LN_FCCLX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbClx());
                rHandler.attribute(NS_rtf::LN_LCBCLX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfpgdFtn());
                rHandler.attribute(NS_rtf::LN_FCPLCFPGDFTN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfpgdFtn());
                rHandler.attribute(NS_rtf::LN_LCBPLCFPGDFTN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcAutosaveSource());
                rHandler.attribute(NS_rtf::LN_FCAUTOSAVESOURCE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbAutosaveSource());
                rHandler.attribute(NS_rtf::LN_LCBAUTOSAVESOURCE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcGrpXstAtnOwners());
                rHandler.attribute(NS_rtf::LN_FCGRPXSTATNOWNERS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbGrpXstAtnOwners());
                rHandler.attribute(NS_rtf::LN_LCBGRPXSTATNOWNERS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfAtnbkmk());
                rHandler.attribute(NS_rtf::LN_FCSTTBFATNBKMK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfAtnbkmk());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFATNBKMK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcdoaMom());
                rHandler.attribute(NS_rtf::LN_FCPLCDOAMOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcdoaMom());
                rHandler.attribute(NS_rtf::LN_LCBPLCDOAMOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcdoaHdr());
                rHandler.attribute(NS_rtf::LN_FCPLCDOAHDR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcdoaHdr());
                rHandler.attribute(NS_rtf::LN_LCBPLCDOAHDR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcspaMom());
                rHandler.attribute(NS_rtf::LN_FCPLCSPAMOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcspaMom());
                rHandler.attribute(NS_rtf::LN_LCBPLCSPAMOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcspaHdr());
                rHandler.attribute(NS_rtf::LN_FCPLCSPAHDR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcspaHdr());
                rHandler.attribute(NS_rtf::LN_LCBPLCSPAHDR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfAtnbkf());
                rHandler.attribute(NS_rtf::LN_FCPLCFATNBKF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfAtnbkf());
                rHandler.attribute(NS_rtf::LN_LCBPLCFATNBKF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfAtnbkl());
                rHandler.attribute(NS_rtf::LN_FCPLCFATNBKL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfAtnbkl());
                rHandler.attribute(NS_rtf::LN_LCBPLCFATNBKL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPms());
                rHandler.attribute(NS_rtf::LN_FCPMS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPms());
                rHandler.attribute(NS_rtf::LN_LCBPMS, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcFormFldSttbf());
                rHandler.attribute(NS_rtf::LN_FCFORMFLDSTTBF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbFormFldSttbf());
                rHandler.attribute(NS_rtf::LN_LCBFORMFLDSTTBF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfendRef());
                rHandler.attribute(NS_rtf::LN_FCPLCFENDREF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfendRef());
                rHandler.attribute(NS_rtf::LN_LCBPLCFENDREF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfendTxt());
                rHandler.attribute(NS_rtf::LN_FCPLCFENDTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfendTxt());
                rHandler.attribute(NS_rtf::LN_LCBPLCFENDTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffldEdn());
                rHandler.attribute(NS_rtf::LN_FCPLCFFLDEDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffldEdn());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFLDEDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfpgdEdn());
                rHandler.attribute(NS_rtf::LN_FCPLCFPGDEDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfpgdEdn());
                rHandler.attribute(NS_rtf::LN_LCBPLCFPGDEDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcDggInfo());
                rHandler.attribute(NS_rtf::LN_FCDGGINFO, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbDggInfo());
                rHandler.attribute(NS_rtf::LN_LCBDGGINFO, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfRMark());
                rHandler.attribute(NS_rtf::LN_FCSTTBFRMARK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfRMark());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFRMARK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfCaption());
                rHandler.attribute(NS_rtf::LN_FCSTTBFCAPTION, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfCaption());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFCAPTION, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfAutoCaption());
                rHandler.attribute(NS_rtf::LN_FCSTTBFAUTOCAPTION, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfAutoCaption());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFAUTOCAPTION, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfwkb());
                rHandler.attribute(NS_rtf::LN_FCPLCFWKB, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfwkb());
                rHandler.attribute(NS_rtf::LN_LCBPLCFWKB, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfspl());
                rHandler.attribute(NS_rtf::LN_FCPLCFSPL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfspl());
                rHandler.attribute(NS_rtf::LN_LCBPLCFSPL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcftxbxTxt());
                rHandler.attribute(NS_rtf::LN_FCPLCFTXBXTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcftxbxTxt());
                rHandler.attribute(NS_rtf::LN_LCBPLCFTXBXTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffldTxbx());
                rHandler.attribute(NS_rtf::LN_FCPLCFFLDTXBX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffldTxbx());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFLDTXBX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfHdrtxbxTxt());
                rHandler.attribute(NS_rtf::LN_FCPLCFHDRTXBXTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfHdrtxbxTxt());
                rHandler.attribute(NS_rtf::LN_LCBPLCFHDRTXBXTXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcffldHdrTxbx());
                rHandler.attribute(NS_rtf::LN_FCPLCFFLDHDRTXBX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcffldHdrTxbx());
                rHandler.attribute(NS_rtf::LN_LCBPLCFFLDHDRTXBX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcStwUser());
                rHandler.attribute(NS_rtf::LN_FCSTWUSER, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbStwUser());
                rHandler.attribute(NS_rtf::LN_LCBSTWUSER, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbttmbd());
                rHandler.attribute(NS_rtf::LN_FCSTTBTTMBD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbttmbd());
                rHandler.attribute(NS_rtf::LN_LCBSTTBTTMBD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcUnused());
                rHandler.attribute(NS_rtf::LN_FCUNUSED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbUnused());
                rHandler.attribute(NS_rtf::LN_LCBUNUSED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPgdMother());
                rHandler.attribute(NS_rtf::LN_FCPGDMOTHER, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPgdMother());
                rHandler.attribute(NS_rtf::LN_LCBPGDMOTHER, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcBkdMother());
                rHandler.attribute(NS_rtf::LN_FCBKDMOTHER, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbBkdMother());
                rHandler.attribute(NS_rtf::LN_LCBBKDMOTHER, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPgdFtn());
                rHandler.attribute(NS_rtf::LN_FCPGDFTN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPgdFtn());
                rHandler.attribute(NS_rtf::LN_LCBPGDFTN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcBkdFtn());
                rHandler.attribute(NS_rtf::LN_FCBKDFTN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbBkdFtn());
                rHandler.attribute(NS_rtf::LN_LCBBKDFTN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPgdEdn());
                rHandler.attribute(NS_rtf::LN_FCPGDEDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPgdEdn());
                rHandler.attribute(NS_rtf::LN_LCBPGDEDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcBkdEdn());
                rHandler.attribute(NS_rtf::LN_FCBKDEDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbBkdEdn());
                rHandler.attribute(NS_rtf::LN_LCBBKDEDN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfIntlFld());
                rHandler.attribute(NS_rtf::LN_FCSTTBFINTLFLD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfIntlFld());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFINTLFLD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcRouteSlip());
                rHandler.attribute(NS_rtf::LN_FCROUTESLIP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbRouteSlip());
                rHandler.attribute(NS_rtf::LN_LCBROUTESLIP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbSavedBy());
                rHandler.attribute(NS_rtf::LN_FCSTTBSAVEDBY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbSavedBy());
                rHandler.attribute(NS_rtf::LN_LCBSTTBSAVEDBY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbFnm());
                rHandler.attribute(NS_rtf::LN_FCSTTBFNM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbFnm());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFNM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfLst());
                rHandler.attribute(NS_rtf::LN_FCPLCFLST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfLst());
                rHandler.attribute(NS_rtf::LN_LCBPLCFLST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlfLfo());
                rHandler.attribute(NS_rtf::LN_FCPLFLFO, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlfLfo());
                rHandler.attribute(NS_rtf::LN_LCBPLFLFO, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcftxbxBkd());
                rHandler.attribute(NS_rtf::LN_FCPLCFTXBXBKD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcftxbxBkd());
                rHandler.attribute(NS_rtf::LN_LCBPLCFTXBXBKD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcftxbxHdrBkd());
                rHandler.attribute(NS_rtf::LN_FCPLCFTXBXHDRBKD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcftxbxHdrBkd());
                rHandler.attribute(NS_rtf::LN_LCBPLCFTXBXHDRBKD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcDocUndo());
                rHandler.attribute(NS_rtf::LN_FCDOCUNDO, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbDocUndo());
                rHandler.attribute(NS_rtf::LN_LCBDOCUNDO, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcRgbuse());
                rHandler.attribute(NS_rtf::LN_FCRGBUSE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbRgbuse());
                rHandler.attribute(NS_rtf::LN_LCBRGBUSE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcUsp());
                rHandler.attribute(NS_rtf::LN_FCUSP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbUsp());
                rHandler.attribute(NS_rtf::LN_LCBUSP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcUskf());
                rHandler.attribute(NS_rtf::LN_FCUSKF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbUskf());
                rHandler.attribute(NS_rtf::LN_LCBUSKF, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcupcRgbuse());
                rHandler.attribute(NS_rtf::LN_FCPLCUPCRGBUSE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcupcRgbuse());
                rHandler.attribute(NS_rtf::LN_LCBPLCUPCRGBUSE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcupcUsp());
                rHandler.attribute(NS_rtf::LN_FCPLCUPCUSP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcupcUsp());
                rHandler.attribute(NS_rtf::LN_LCBPLCUPCUSP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbGlsyStyle());
                rHandler.attribute(NS_rtf::LN_FCSTTBGLSYSTYLE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbGlsyStyle());
                rHandler.attribute(NS_rtf::LN_LCBSTTBGLSYSTYLE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlgosl());
                rHandler.attribute(NS_rtf::LN_FCPLGOSL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlgosl());
                rHandler.attribute(NS_rtf::LN_LCBPLGOSL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcocx());
                rHandler.attribute(NS_rtf::LN_FCPLCOCX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcocx());
                rHandler.attribute(NS_rtf::LN_LCBPLCOCX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfbteLvc());
                rHandler.attribute(NS_rtf::LN_FCPLCFBTELVC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfbteLvc());
                rHandler.attribute(NS_rtf::LN_LCBPLCFBTELVC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dwLowDateTime());
                rHandler.attribute(NS_rtf::LN_DWLOWDATETIME, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dwHighDateTime());
                rHandler.attribute(NS_rtf::LN_DWHIGHDATETIME, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcflvc());
                rHandler.attribute(NS_rtf::LN_FCPLCFLVC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcflvc());
                rHandler.attribute(NS_rtf::LN_LCBPLCFLVC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcasumy());
                rHandler.attribute(NS_rtf::LN_FCPLCASUMY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcasumy());
                rHandler.attribute(NS_rtf::LN_LCBPLCASUMY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPlcfgram());
                rHandler.attribute(NS_rtf::LN_FCPLCFGRAM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbPlcfgram());
                rHandler.attribute(NS_rtf::LN_LCBPLCFGRAM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbListNames());
                rHandler.attribute(NS_rtf::LN_FCSTTBLISTNAMES, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbListNames());
                rHandler.attribute(NS_rtf::LN_LCBSTTBLISTNAMES, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSttbfUssr());
                rHandler.attribute(NS_rtf::LN_FCSTTBFUSSR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lcbSttbfUssr());
                rHandler.attribute(NS_rtf::LN_LCBSTTBFUSSR, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8Fib::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='Fib'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "wIdent", get_wIdent());
        doctok::dump(o, "nFib", get_nFib());
        doctok::dump(o, "nProduct", get_nProduct());
        doctok::dump(o, "lid", get_lid());
        doctok::dump(o, "pnNext", get_pnNext());
        doctok::dump(o, "fDot", get_fDot());
        doctok::dump(o, "fGlsy", get_fGlsy());
        doctok::dump(o, "fComplex", get_fComplex());
        doctok::dump(o, "fHasPic", get_fHasPic());
        doctok::dump(o, "cQuickSaves", get_cQuickSaves());
        doctok::dump(o, "fEncrypted", get_fEncrypted());
        doctok::dump(o, "fWhichTblStm", get_fWhichTblStm());
        doctok::dump(o, "fReadOnlyRecommended", get_fReadOnlyRecommended());
        doctok::dump(o, "fWriteReservation", get_fWriteReservation());
        doctok::dump(o, "fExtChar", get_fExtChar());
        doctok::dump(o, "fLoadOverride", get_fLoadOverride());
        doctok::dump(o, "fFarEast", get_fFarEast());
        doctok::dump(o, "fCrypto", get_fCrypto());
        doctok::dump(o, "nFibBack", get_nFibBack());
        doctok::dump(o, "lKey", get_lKey());
        doctok::dump(o, "envr", get_envr());
        doctok::dump(o, "fMac", get_fMac());
        doctok::dump(o, "fEmptySpecial", get_fEmptySpecial());
        doctok::dump(o, "fLoadOverridePage", get_fLoadOverridePage());
        doctok::dump(o, "fFutureSavedUndo", get_fFutureSavedUndo());
        doctok::dump(o, "fWord97Saved", get_fWord97Saved());
        doctok::dump(o, "fSpare0", get_fSpare0());
        doctok::dump(o, "chs", get_chs());
        doctok::dump(o, "chsTables", get_chsTables());
        doctok::dump(o, "fcMin", get_fcMin());
        doctok::dump(o, "fcMac", get_fcMac());
        doctok::dump(o, "csw", get_csw());
        doctok::dump(o, "wMagicCreated", get_wMagicCreated());
        doctok::dump(o, "wMagicRevised", get_wMagicRevised());
        doctok::dump(o, "wMagicCreatedPrivate", get_wMagicCreatedPrivate());
        doctok::dump(o, "wMagicRevisedPrivate", get_wMagicRevisedPrivate());
        doctok::dump(o, "pnFbpChpFirst_W6", get_pnFbpChpFirst_W6());
        doctok::dump(o, "pnChpFirst_W6", get_pnChpFirst_W6());
        doctok::dump(o, "cpnBteChp_W6", get_cpnBteChp_W6());
        doctok::dump(o, "pnFbpPapFirst_W6", get_pnFbpPapFirst_W6());
        doctok::dump(o, "pnPapFirst_W6", get_pnPapFirst_W6());
        doctok::dump(o, "cpnBtePap_W6", get_cpnBtePap_W6());
        doctok::dump(o, "pnFbpLvcFirst_W6", get_pnFbpLvcFirst_W6());
        doctok::dump(o, "pnLvcFirst_W6", get_pnLvcFirst_W6());
        doctok::dump(o, "cpnBteLvc_W6", get_cpnBteLvc_W6());
        doctok::dump(o, "lidFE", get_lidFE());
        doctok::dump(o, "clw", get_clw());
        doctok::dump(o, "cbMac", get_cbMac());
        doctok::dump(o, "lProductCreated", get_lProductCreated());
        doctok::dump(o, "lProductRevised", get_lProductRevised());
        doctok::dump(o, "ccpText", get_ccpText());
        doctok::dump(o, "ccpFtn", get_ccpFtn());
        doctok::dump(o, "ccpHdd", get_ccpHdd());
        doctok::dump(o, "ccpMcr", get_ccpMcr());
        doctok::dump(o, "ccpAtn", get_ccpAtn());
        doctok::dump(o, "ccpEdn", get_ccpEdn());
        doctok::dump(o, "ccpTxbx", get_ccpTxbx());
        doctok::dump(o, "ccpHdrTxbx", get_ccpHdrTxbx());
        doctok::dump(o, "pnFbpChpFirst", get_pnFbpChpFirst());
        doctok::dump(o, "pnChpFirst", get_pnChpFirst());
        doctok::dump(o, "cpnBteChp", get_cpnBteChp());
        doctok::dump(o, "pnFbpPapFirst", get_pnFbpPapFirst());
        doctok::dump(o, "pnPapFirst", get_pnPapFirst());
        doctok::dump(o, "cpnBtePap", get_cpnBtePap());
        doctok::dump(o, "pnFbpLvcFirst", get_pnFbpLvcFirst());
        doctok::dump(o, "pnLvcFirst", get_pnLvcFirst());
        doctok::dump(o, "cpnBteLvc", get_cpnBteLvc());
        doctok::dump(o, "fcIslandFirst", get_fcIslandFirst());
        doctok::dump(o, "fcIslandLim", get_fcIslandLim());
        doctok::dump(o, "cfclcb", get_cfclcb());
        doctok::dump(o, "fcStshfOrig", get_fcStshfOrig());
        doctok::dump(o, "lcbStshfOrig", get_lcbStshfOrig());
        doctok::dump(o, "fcStshf", get_fcStshf());
        doctok::dump(o, "lcbStshf", get_lcbStshf());
        doctok::dump(o, "fcPlcffndRef", get_fcPlcffndRef());
        doctok::dump(o, "lcbPlcffndRef", get_lcbPlcffndRef());
        doctok::dump(o, "fcPlcffndTxt", get_fcPlcffndTxt());
        doctok::dump(o, "lcbPlcffndTxt", get_lcbPlcffndTxt());
        doctok::dump(o, "fcPlcfandRef", get_fcPlcfandRef());
        doctok::dump(o, "lcbPlcfandRef", get_lcbPlcfandRef());
        doctok::dump(o, "fcPlcfandTxt", get_fcPlcfandTxt());
        doctok::dump(o, "lcbPlcfandTxt", get_lcbPlcfandTxt());
        doctok::dump(o, "fcPlcfsed", get_fcPlcfsed());
        doctok::dump(o, "lcbPlcfsed", get_lcbPlcfsed());
        doctok::dump(o, "fcPlcfpad", get_fcPlcfpad());
        doctok::dump(o, "lcbPlcfpad", get_lcbPlcfpad());
        doctok::dump(o, "fcPlcfphe", get_fcPlcfphe());
        doctok::dump(o, "lcbPlcfphe", get_lcbPlcfphe());
        doctok::dump(o, "fcSttbfglsy", get_fcSttbfglsy());
        doctok::dump(o, "lcbSttbfglsy", get_lcbSttbfglsy());
        doctok::dump(o, "fcPlcfglsy", get_fcPlcfglsy());
        doctok::dump(o, "lcbPlcfglsy", get_lcbPlcfglsy());
        doctok::dump(o, "fcPlcfhdd", get_fcPlcfhdd());
        doctok::dump(o, "lcbPlcfhdd", get_lcbPlcfhdd());
        doctok::dump(o, "fcPlcfbteChpx", get_fcPlcfbteChpx());
        doctok::dump(o, "lcbPlcfbteChpx", get_lcbPlcfbteChpx());
        doctok::dump(o, "fcPlcfbtePapx", get_fcPlcfbtePapx());
        doctok::dump(o, "lcbPlcfbtePapx", get_lcbPlcfbtePapx());
        doctok::dump(o, "fcPlcfsea", get_fcPlcfsea());
        doctok::dump(o, "lcbPlcfsea", get_lcbPlcfsea());
        doctok::dump(o, "fcSttbfffn", get_fcSttbfffn());
        doctok::dump(o, "lcbSttbfffn", get_lcbSttbfffn());
        doctok::dump(o, "fcPlcffldMom", get_fcPlcffldMom());
        doctok::dump(o, "lcbPlcffldMom", get_lcbPlcffldMom());
        doctok::dump(o, "fcPlcffldHdr", get_fcPlcffldHdr());
        doctok::dump(o, "lcbPlcffldHdr", get_lcbPlcffldHdr());
        doctok::dump(o, "fcPlcffldFtn", get_fcPlcffldFtn());
        doctok::dump(o, "lcbPlcffldFtn", get_lcbPlcffldFtn());
        doctok::dump(o, "fcPlcffldAtn", get_fcPlcffldAtn());
        doctok::dump(o, "lcbPlcffldAtn", get_lcbPlcffldAtn());
        doctok::dump(o, "fcPlcffldMcr", get_fcPlcffldMcr());
        doctok::dump(o, "lcbPlcffldMcr", get_lcbPlcffldMcr());
        doctok::dump(o, "fcSttbfbkmk", get_fcSttbfbkmk());
        doctok::dump(o, "lcbSttbfbkmk", get_lcbSttbfbkmk());
        doctok::dump(o, "fcPlcfbkf", get_fcPlcfbkf());
        doctok::dump(o, "lcbPlcfbkf", get_lcbPlcfbkf());
        doctok::dump(o, "fcPlcfbkl", get_fcPlcfbkl());
        doctok::dump(o, "lcbPlcfbkl", get_lcbPlcfbkl());
        doctok::dump(o, "fcCmds", get_fcCmds());
        doctok::dump(o, "lcbCmds", get_lcbCmds());
        doctok::dump(o, "fcPlcmcr", get_fcPlcmcr());
        doctok::dump(o, "lcbPlcmcr", get_lcbPlcmcr());
        doctok::dump(o, "fcSttbfmcr", get_fcSttbfmcr());
        doctok::dump(o, "lcbSttbfmcr", get_lcbSttbfmcr());
        doctok::dump(o, "fcPrDrvr", get_fcPrDrvr());
        doctok::dump(o, "lcbPrDrvr", get_lcbPrDrvr());
        doctok::dump(o, "fcPrEnvPort", get_fcPrEnvPort());
        doctok::dump(o, "lcbPrEnvPort", get_lcbPrEnvPort());
        doctok::dump(o, "fcPrEnvLand", get_fcPrEnvLand());
        doctok::dump(o, "lcbPrEnvLand", get_lcbPrEnvLand());
        doctok::dump(o, "fcWss", get_fcWss());
        doctok::dump(o, "lcbWss", get_lcbWss());
        doctok::dump(o, "fcDop", get_fcDop());
        doctok::dump(o, "lcbDop", get_lcbDop());
        doctok::dump(o, "fcSttbfAssoc", get_fcSttbfAssoc());
        doctok::dump(o, "lcbSttbfAssoc", get_lcbSttbfAssoc());
        doctok::dump(o, "fcClx", get_fcClx());
        doctok::dump(o, "lcbClx", get_lcbClx());
        doctok::dump(o, "fcPlcfpgdFtn", get_fcPlcfpgdFtn());
        doctok::dump(o, "lcbPlcfpgdFtn", get_lcbPlcfpgdFtn());
        doctok::dump(o, "fcAutosaveSource", get_fcAutosaveSource());
        doctok::dump(o, "lcbAutosaveSource", get_lcbAutosaveSource());
        doctok::dump(o, "fcGrpXstAtnOwners", get_fcGrpXstAtnOwners());
        doctok::dump(o, "lcbGrpXstAtnOwners", get_lcbGrpXstAtnOwners());
        doctok::dump(o, "fcSttbfAtnbkmk", get_fcSttbfAtnbkmk());
        doctok::dump(o, "lcbSttbfAtnbkmk", get_lcbSttbfAtnbkmk());
        doctok::dump(o, "fcPlcdoaMom", get_fcPlcdoaMom());
        doctok::dump(o, "lcbPlcdoaMom", get_lcbPlcdoaMom());
        doctok::dump(o, "fcPlcdoaHdr", get_fcPlcdoaHdr());
        doctok::dump(o, "lcbPlcdoaHdr", get_lcbPlcdoaHdr());
        doctok::dump(o, "fcPlcspaMom", get_fcPlcspaMom());
        doctok::dump(o, "lcbPlcspaMom", get_lcbPlcspaMom());
        doctok::dump(o, "fcPlcspaHdr", get_fcPlcspaHdr());
        doctok::dump(o, "lcbPlcspaHdr", get_lcbPlcspaHdr());
        doctok::dump(o, "fcPlcfAtnbkf", get_fcPlcfAtnbkf());
        doctok::dump(o, "lcbPlcfAtnbkf", get_lcbPlcfAtnbkf());
        doctok::dump(o, "fcPlcfAtnbkl", get_fcPlcfAtnbkl());
        doctok::dump(o, "lcbPlcfAtnbkl", get_lcbPlcfAtnbkl());
        doctok::dump(o, "fcPms", get_fcPms());
        doctok::dump(o, "lcbPms", get_lcbPms());
        doctok::dump(o, "fcFormFldSttbf", get_fcFormFldSttbf());
        doctok::dump(o, "lcbFormFldSttbf", get_lcbFormFldSttbf());
        doctok::dump(o, "fcPlcfendRef", get_fcPlcfendRef());
        doctok::dump(o, "lcbPlcfendRef", get_lcbPlcfendRef());
        doctok::dump(o, "fcPlcfendTxt", get_fcPlcfendTxt());
        doctok::dump(o, "lcbPlcfendTxt", get_lcbPlcfendTxt());
        doctok::dump(o, "fcPlcffldEdn", get_fcPlcffldEdn());
        doctok::dump(o, "lcbPlcffldEdn", get_lcbPlcffldEdn());
        doctok::dump(o, "fcPlcfpgdEdn", get_fcPlcfpgdEdn());
        doctok::dump(o, "lcbPlcfpgdEdn", get_lcbPlcfpgdEdn());
        doctok::dump(o, "fcDggInfo", get_fcDggInfo());
        doctok::dump(o, "lcbDggInfo", get_lcbDggInfo());
        doctok::dump(o, "fcSttbfRMark", get_fcSttbfRMark());
        doctok::dump(o, "lcbSttbfRMark", get_lcbSttbfRMark());
        doctok::dump(o, "fcSttbfCaption", get_fcSttbfCaption());
        doctok::dump(o, "lcbSttbfCaption", get_lcbSttbfCaption());
        doctok::dump(o, "fcSttbfAutoCaption", get_fcSttbfAutoCaption());
        doctok::dump(o, "lcbSttbfAutoCaption", get_lcbSttbfAutoCaption());
        doctok::dump(o, "fcPlcfwkb", get_fcPlcfwkb());
        doctok::dump(o, "lcbPlcfwkb", get_lcbPlcfwkb());
        doctok::dump(o, "fcPlcfspl", get_fcPlcfspl());
        doctok::dump(o, "lcbPlcfspl", get_lcbPlcfspl());
        doctok::dump(o, "fcPlcftxbxTxt", get_fcPlcftxbxTxt());
        doctok::dump(o, "lcbPlcftxbxTxt", get_lcbPlcftxbxTxt());
        doctok::dump(o, "fcPlcffldTxbx", get_fcPlcffldTxbx());
        doctok::dump(o, "lcbPlcffldTxbx", get_lcbPlcffldTxbx());
        doctok::dump(o, "fcPlcfHdrtxbxTxt", get_fcPlcfHdrtxbxTxt());
        doctok::dump(o, "lcbPlcfHdrtxbxTxt", get_lcbPlcfHdrtxbxTxt());
        doctok::dump(o, "fcPlcffldHdrTxbx", get_fcPlcffldHdrTxbx());
        doctok::dump(o, "lcbPlcffldHdrTxbx", get_lcbPlcffldHdrTxbx());
        doctok::dump(o, "fcStwUser", get_fcStwUser());
        doctok::dump(o, "lcbStwUser", get_lcbStwUser());
        doctok::dump(o, "fcSttbttmbd", get_fcSttbttmbd());
        doctok::dump(o, "lcbSttbttmbd", get_lcbSttbttmbd());
        doctok::dump(o, "fcUnused", get_fcUnused());
        doctok::dump(o, "lcbUnused", get_lcbUnused());
        doctok::dump(o, "fcPgdMother", get_fcPgdMother());
        doctok::dump(o, "lcbPgdMother", get_lcbPgdMother());
        doctok::dump(o, "fcBkdMother", get_fcBkdMother());
        doctok::dump(o, "lcbBkdMother", get_lcbBkdMother());
        doctok::dump(o, "fcPgdFtn", get_fcPgdFtn());
        doctok::dump(o, "lcbPgdFtn", get_lcbPgdFtn());
        doctok::dump(o, "fcBkdFtn", get_fcBkdFtn());
        doctok::dump(o, "lcbBkdFtn", get_lcbBkdFtn());
        doctok::dump(o, "fcPgdEdn", get_fcPgdEdn());
        doctok::dump(o, "lcbPgdEdn", get_lcbPgdEdn());
        doctok::dump(o, "fcBkdEdn", get_fcBkdEdn());
        doctok::dump(o, "lcbBkdEdn", get_lcbBkdEdn());
        doctok::dump(o, "fcSttbfIntlFld", get_fcSttbfIntlFld());
        doctok::dump(o, "lcbSttbfIntlFld", get_lcbSttbfIntlFld());
        doctok::dump(o, "fcRouteSlip", get_fcRouteSlip());
        doctok::dump(o, "lcbRouteSlip", get_lcbRouteSlip());
        doctok::dump(o, "fcSttbSavedBy", get_fcSttbSavedBy());
        doctok::dump(o, "lcbSttbSavedBy", get_lcbSttbSavedBy());
        doctok::dump(o, "fcSttbFnm", get_fcSttbFnm());
        doctok::dump(o, "lcbSttbFnm", get_lcbSttbFnm());
        doctok::dump(o, "fcPlcfLst", get_fcPlcfLst());
        doctok::dump(o, "lcbPlcfLst", get_lcbPlcfLst());
        doctok::dump(o, "fcPlfLfo", get_fcPlfLfo());
        doctok::dump(o, "lcbPlfLfo", get_lcbPlfLfo());
        doctok::dump(o, "fcPlcftxbxBkd", get_fcPlcftxbxBkd());
        doctok::dump(o, "lcbPlcftxbxBkd", get_lcbPlcftxbxBkd());
        doctok::dump(o, "fcPlcftxbxHdrBkd", get_fcPlcftxbxHdrBkd());
        doctok::dump(o, "lcbPlcftxbxHdrBkd", get_lcbPlcftxbxHdrBkd());
        doctok::dump(o, "fcDocUndo", get_fcDocUndo());
        doctok::dump(o, "lcbDocUndo", get_lcbDocUndo());
        doctok::dump(o, "fcRgbuse", get_fcRgbuse());
        doctok::dump(o, "lcbRgbuse", get_lcbRgbuse());
        doctok::dump(o, "fcUsp", get_fcUsp());
        doctok::dump(o, "lcbUsp", get_lcbUsp());
        doctok::dump(o, "fcUskf", get_fcUskf());
        doctok::dump(o, "lcbUskf", get_lcbUskf());
        doctok::dump(o, "fcPlcupcRgbuse", get_fcPlcupcRgbuse());
        doctok::dump(o, "lcbPlcupcRgbuse", get_lcbPlcupcRgbuse());
        doctok::dump(o, "fcPlcupcUsp", get_fcPlcupcUsp());
        doctok::dump(o, "lcbPlcupcUsp", get_lcbPlcupcUsp());
        doctok::dump(o, "fcSttbGlsyStyle", get_fcSttbGlsyStyle());
        doctok::dump(o, "lcbSttbGlsyStyle", get_lcbSttbGlsyStyle());
        doctok::dump(o, "fcPlgosl", get_fcPlgosl());
        doctok::dump(o, "lcbPlgosl", get_lcbPlgosl());
        doctok::dump(o, "fcPlcocx", get_fcPlcocx());
        doctok::dump(o, "lcbPlcocx", get_lcbPlcocx());
        doctok::dump(o, "fcPlcfbteLvc", get_fcPlcfbteLvc());
        doctok::dump(o, "lcbPlcfbteLvc", get_lcbPlcfbteLvc());
        doctok::dump(o, "dwLowDateTime", get_dwLowDateTime());
        doctok::dump(o, "dwHighDateTime", get_dwHighDateTime());
        doctok::dump(o, "fcPlcflvc", get_fcPlcflvc());
        doctok::dump(o, "lcbPlcflvc", get_lcbPlcflvc());
        doctok::dump(o, "fcPlcasumy", get_fcPlcasumy());
        doctok::dump(o, "lcbPlcasumy", get_lcbPlcasumy());
        doctok::dump(o, "fcPlcfgram", get_fcPlcfgram());
        doctok::dump(o, "lcbPlcfgram", get_lcbPlcfgram());
        doctok::dump(o, "fcSttbListNames", get_fcSttbListNames());
        doctok::dump(o, "lcbSttbListNames", get_lcbSttbListNames());
        doctok::dump(o, "fcSttbfUssr", get_fcSttbfUssr());
        doctok::dump(o, "lcbSttbfUssr", get_lcbSttbfUssr());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: BKD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 6
*/
    WW8BKD::~WW8BKD()
    {
    }
    
    void WW8BKD::init()
    {
      
    }

    void WW8BKD::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_ibkl());
                rHandler.attribute(NS_rtf::LN_IBKL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_itcFirst());
                rHandler.attribute(NS_rtf::LN_ITCFIRST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fPub());
                rHandler.attribute(NS_rtf::LN_FPUB, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_itcLim());
                rHandler.attribute(NS_rtf::LN_ITCLIM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fCol());
                rHandler.attribute(NS_rtf::LN_FCOL, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8BKD::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='BKD'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "ibkl", get_ibkl());
        doctok::dump(o, "itcFirst", get_itcFirst());
        doctok::dump(o, "fPub", get_fPub());
        doctok::dump(o, "itcLim", get_itcLim());
        doctok::dump(o, "fCol", get_fCol());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: SED
    
    Stereotype ww8resource

    Stereotype needsdocument

    Parent Resource: Properties
    Size: 12
*/
    WW8SED::~WW8SED()
    {
    }
    
    void WW8SED::init()
    {
      
    }

    void WW8SED::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_fn());
                rHandler.attribute(NS_rtf::LN_FN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcSepx());
                rHandler.attribute(NS_rtf::LN_FCSEPX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fnMpr());
                rHandler.attribute(NS_rtf::LN_FNMPR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fcMpr());
                rHandler.attribute(NS_rtf::LN_FCMPR, *pVal);
            }
          {
              WW8Value::Pointer_t pVal = createValue(get_sepx());
              rHandler.attribute(NS_rtf::LN_sed, *pVal);
          }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8SED::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='SED'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "fn", get_fn());
        doctok::dump(o, "fcSepx", get_fcSepx());
        doctok::dump(o, "fnMpr", get_fnMpr());
        doctok::dump(o, "fcMpr", get_fcMpr());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: SHD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 2
*/
    WW8SHD::~WW8SHD()
    {
    }
    
    void WW8SHD::init()
    {
      
    }

    void WW8SHD::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_icoFore());
                rHandler.attribute(NS_rtf::LN_ICOFORE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_icoBack());
                rHandler.attribute(NS_rtf::LN_ICOBACK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ipat());
                rHandler.attribute(NS_rtf::LN_IPAT, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8SHD::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='SHD'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "icoFore", get_icoFore());
        doctok::dump(o, "icoBack", get_icoBack());
        doctok::dump(o, "ipat", get_ipat());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: CellShd
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 10
*/
    WW8CellShd::~WW8CellShd()
    {
    }
    
    void WW8CellShd::init()
    {
      
    }

    void WW8CellShd::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_shdForeColor());
                rHandler.attribute(NS_rtf::LN_SHDFORECOLOR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shdBackColor());
                rHandler.attribute(NS_rtf::LN_SHDBACKCOLOR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shdPattern());
                rHandler.attribute(NS_rtf::LN_SHDPATTERN, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8CellShd::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='CellShd'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "shdForeColor", get_shdForeColor());
        doctok::dump(o, "shdBackColor", get_shdBackColor());
        doctok::dump(o, "shdPattern", get_shdPattern());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: BRC
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 4
*/
    WW8BRC::~WW8BRC()
    {
    }
    
    void WW8BRC::init()
    {
      
    }

    void WW8BRC::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_dptLineWidth());
                rHandler.attribute(NS_rtf::LN_DPTLINEWIDTH, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcType());
                rHandler.attribute(NS_rtf::LN_BRCTYPE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ico());
                rHandler.attribute(NS_rtf::LN_ICO, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dptSpace());
                rHandler.attribute(NS_rtf::LN_DPTSPACE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fShadow());
                rHandler.attribute(NS_rtf::LN_FSHADOW, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fFrame());
                rHandler.attribute(NS_rtf::LN_FFRAME, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused2_15());
                rHandler.attribute(NS_rtf::LN_UNUSED2_15, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8BRC::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='BRC'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "dptLineWidth", get_dptLineWidth());
        doctok::dump(o, "brcType", get_brcType());
        doctok::dump(o, "ico", get_ico());
        doctok::dump(o, "dptSpace", get_dptSpace());
        doctok::dump(o, "fShadow", get_fShadow());
        doctok::dump(o, "fFrame", get_fFrame());
        doctok::dump(o, "unused2_15", get_unused2_15());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: TC
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 20
*/
    WW8TC::~WW8TC()
    {
    }
    
    void WW8TC::init()
    {
      
    }

    void WW8TC::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_fFirstMerged());
                rHandler.attribute(NS_rtf::LN_FFIRSTMERGED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fMerged());
                rHandler.attribute(NS_rtf::LN_FMERGED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fVertical());
                rHandler.attribute(NS_rtf::LN_FVERTICAL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fBackward());
                rHandler.attribute(NS_rtf::LN_FBACKWARD, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fRotateFont());
                rHandler.attribute(NS_rtf::LN_FROTATEFONT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fVertMerge());
                rHandler.attribute(NS_rtf::LN_FVERTMERGE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fVertRestart());
                rHandler.attribute(NS_rtf::LN_FVERTRESTART, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_vertAlign());
                rHandler.attribute(NS_rtf::LN_VERTALIGN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fUnused());
                rHandler.attribute(NS_rtf::LN_FUNUSED, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_CellPreferredSize());
                rHandler.attribute(NS_rtf::LN_CellPrefferedSize, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcTop());
                rHandler.attribute(NS_rtf::LN_BRCTOP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcLeft());
                rHandler.attribute(NS_rtf::LN_BRCLEFT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcBottom());
                rHandler.attribute(NS_rtf::LN_BRCBOTTOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcRight());
                rHandler.attribute(NS_rtf::LN_BRCRIGHT, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8TC::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='TC'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "fFirstMerged", get_fFirstMerged());
        doctok::dump(o, "fMerged", get_fMerged());
        doctok::dump(o, "fVertical", get_fVertical());
        doctok::dump(o, "fBackward", get_fBackward());
        doctok::dump(o, "fRotateFont", get_fRotateFont());
        doctok::dump(o, "fVertMerge", get_fVertMerge());
        doctok::dump(o, "fVertRestart", get_fVertRestart());
        doctok::dump(o, "vertAlign", get_vertAlign());
        doctok::dump(o, "fUnused", get_fUnused());
        doctok::dump(o, "CellPreferredSize", get_CellPreferredSize());
        doctok::dump(o, "brcTop", get_brcTop());
        doctok::dump(o, "brcLeft", get_brcLeft());
        doctok::dump(o, "brcBottom", get_brcBottom());
        doctok::dump(o, "brcRight", get_brcRight());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: BKF
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 4
*/
    WW8BKF::~WW8BKF()
    {
    }
    
    void WW8BKF::init()
    {
      
    }

    void WW8BKF::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_ibkl());
                rHandler.attribute(NS_rtf::LN_IBKL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_itcFirst());
                rHandler.attribute(NS_rtf::LN_ITCFIRST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fPub());
                rHandler.attribute(NS_rtf::LN_FPUB, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_itcLim());
                rHandler.attribute(NS_rtf::LN_ITCLIM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fCol());
                rHandler.attribute(NS_rtf::LN_FCOL, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8BKF::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='BKF'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "ibkl", get_ibkl());
        doctok::dump(o, "itcFirst", get_itcFirst());
        doctok::dump(o, "fPub", get_fPub());
        doctok::dump(o, "itcLim", get_itcLim());
        doctok::dump(o, "fCol", get_fCol());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: LineProps
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 8
*/
    WW8LineProps::~WW8LineProps()
    {
    }
    
    void WW8LineProps::init()
    {
      
    }

    void WW8LineProps::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_linecolor());
                rHandler.attribute(NS_rtf::LN_LINECOLOR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_linewidth());
                rHandler.attribute(NS_rtf::LN_LINEWIDTH, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_linetype());
                rHandler.attribute(NS_rtf::LN_LINETYPE, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8LineProps::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='LineProps'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "linecolor", get_linecolor());
        doctok::dump(o, "linewidth", get_linewidth());
        doctok::dump(o, "linetype", get_linetype());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: TBD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8TBD::~WW8TBD()
    {
    }
    
    void WW8TBD::init()
    {
      
    }

    void WW8TBD::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_jc());
                rHandler.attribute(NS_rtf::LN_JC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_tlc());
                rHandler.attribute(NS_rtf::LN_TLC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused0_6());
                rHandler.attribute(NS_rtf::LN_UNUSED0_6, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8TBD::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='TBD'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "jc", get_jc());
        doctok::dump(o, "tlc", get_tlc());
        doctok::dump(o, "unused0_6", get_unused0_6());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: METAFILEPICT
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8METAFILEPICT::~WW8METAFILEPICT()
    {
    }
    
    void WW8METAFILEPICT::init()
    {
      
    }

    void WW8METAFILEPICT::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_mm());
                rHandler.attribute(NS_rtf::LN_MM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_xExt());
                rHandler.attribute(NS_rtf::LN_XEXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_yExt());
                rHandler.attribute(NS_rtf::LN_YEXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_hMF());
                rHandler.attribute(NS_rtf::LN_HMF, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8METAFILEPICT::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='METAFILEPICT'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "mm", get_mm());
        doctok::dump(o, "xExt", get_xExt());
        doctok::dump(o, "yExt", get_yExt());
        doctok::dump(o, "hMF", get_hMF());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FFDATA
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 0
*/
    WW8FFDATA::~WW8FFDATA()
    {
    }
    
    void WW8FFDATA::init()
    {
      
    }

    void WW8FFDATA::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_unknown());
                rHandler.attribute(NS_rtf::LN_unknown, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dropdownIndex());
                rHandler.attribute(NS_rtf::LN_dropdownIndex, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fTooltip());
                rHandler.attribute(NS_rtf::LN_tooltip, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fNomark());
                rHandler.attribute(NS_rtf::LN_nomark, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fUseSize());
                rHandler.attribute(NS_rtf::LN_useSize, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fNumersOnly());
                rHandler.attribute(NS_rtf::LN_numbersOnly, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fDateOnly());
                rHandler.attribute(NS_rtf::LN_dateOnly, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fUnused());
                rHandler.attribute(NS_rtf::LN_unused, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_size());
                rHandler.attribute(NS_rtf::LN_size, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_hpsCheckbox());
                rHandler.attribute(NS_rtf::LN_hpsCheckbox, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_title());
                rHandler.attribute(NS_rtf::LN_fftitle, *pVal);
            }
          {
              WW8Value::Pointer_t pVal = createValue(get_FLT());
              rHandler.attribute(NS_rtf::LN_FLT, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_default());
              rHandler.attribute(NS_rtf::LN_ffdefault, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_checked());
              rHandler.attribute(NS_rtf::LN_ffchecked, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_formatting());
              rHandler.attribute(NS_rtf::LN_ffformatting, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_help());
              rHandler.attribute(NS_rtf::LN_ffhelp, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_tooltip());
              rHandler.attribute(NS_rtf::LN_fftooltip, *pVal);
          }

      resolveNoAuto(rHandler);
    
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FFDATA::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FFDATA'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "unknown", get_unknown());
        doctok::dump(o, "dropdownIndex", get_dropdownIndex());
        doctok::dump(o, "fTooltip", get_fTooltip());
        doctok::dump(o, "fNomark", get_fNomark());
        doctok::dump(o, "fUseSize", get_fUseSize());
        doctok::dump(o, "fNumersOnly", get_fNumersOnly());
        doctok::dump(o, "fDateOnly", get_fDateOnly());
        doctok::dump(o, "fUnused", get_fUnused());
        doctok::dump(o, "size", get_size());
        doctok::dump(o, "hpsCheckbox", get_hpsCheckbox());
        doctok::dump(o, "title", get_title());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: PICF
    
    Stereotype ww8resource

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 0
*/
    WW8PICF::~WW8PICF()
    {
    }
    
    void WW8PICF::init()
    {
      
    }

    void WW8PICF::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_lcb());
                rHandler.attribute(NS_rtf::LN_LCB, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cbHeader());
                rHandler.attribute(NS_rtf::LN_CBHEADER, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_mfp());
                rHandler.attribute(NS_rtf::LN_MFP, *pVal);
            }
            {
                sal_uInt32 nCount = get_bm_rcWinMF_count();              
                for (sal_uInt32 n = 0; n < nCount; ++n)
                {
                    WW8Value::Pointer_t pVal = createValue(get_bm_rcWinMF(n));
                    rHandler.attribute(NS_rtf::LN_BM_RCWINMF, *pVal);
                }
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dxaGoal());
                rHandler.attribute(NS_rtf::LN_DXAGOAL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dyaGoal());
                rHandler.attribute(NS_rtf::LN_DYAGOAL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_mx());
                rHandler.attribute(NS_rtf::LN_MX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_my());
                rHandler.attribute(NS_rtf::LN_MY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dxaCropLeft());
                rHandler.attribute(NS_rtf::LN_DXACROPLEFT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dyaCropTop());
                rHandler.attribute(NS_rtf::LN_DYACROPTOP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dxaCropRight());
                rHandler.attribute(NS_rtf::LN_DXACROPRIGHT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dyaCropBottom());
                rHandler.attribute(NS_rtf::LN_DYACROPBOTTOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcl());
                rHandler.attribute(NS_rtf::LN_BRCL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fFrameEmpty());
                rHandler.attribute(NS_rtf::LN_FFRAMEEMPTY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fBitmap());
                rHandler.attribute(NS_rtf::LN_FBITMAP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fDrawHatch());
                rHandler.attribute(NS_rtf::LN_FDRAWHATCH, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fError());
                rHandler.attribute(NS_rtf::LN_FERROR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_bpp());
                rHandler.attribute(NS_rtf::LN_BPP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcTop());
                rHandler.attribute(NS_rtf::LN_BRCTOP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcLeft());
                rHandler.attribute(NS_rtf::LN_BRCLEFT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcBottom());
                rHandler.attribute(NS_rtf::LN_BRCBOTTOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_brcRight());
                rHandler.attribute(NS_rtf::LN_BRCRIGHT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dxaOrigin());
                rHandler.attribute(NS_rtf::LN_DXAORIGIN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_dyaOrigin());
                rHandler.attribute(NS_rtf::LN_DYAORIGIN, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cProps());
                rHandler.attribute(NS_rtf::LN_CPROPS, *pVal);
            }
      resolveNoAuto(rHandler);
    
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8PICF::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='PICF'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "lcb", get_lcb());
        doctok::dump(o, "cbHeader", get_cbHeader());
        doctok::dump(o, "mfp", get_mfp());
        {
            sal_uInt32 nCount = get_bm_rcWinMF_count();
            
            for (sal_uInt32 n = 0; n < nCount; ++n)
            {
                doctok::dump(o, "bm_rcWinMF", get_bm_rcWinMF(n));
            }
        }
        doctok::dump(o, "dxaGoal", get_dxaGoal());
        doctok::dump(o, "dyaGoal", get_dyaGoal());
        doctok::dump(o, "mx", get_mx());
        doctok::dump(o, "my", get_my());
        doctok::dump(o, "dxaCropLeft", get_dxaCropLeft());
        doctok::dump(o, "dyaCropTop", get_dyaCropTop());
        doctok::dump(o, "dxaCropRight", get_dxaCropRight());
        doctok::dump(o, "dyaCropBottom", get_dyaCropBottom());
        doctok::dump(o, "brcl", get_brcl());
        doctok::dump(o, "fFrameEmpty", get_fFrameEmpty());
        doctok::dump(o, "fBitmap", get_fBitmap());
        doctok::dump(o, "fDrawHatch", get_fDrawHatch());
        doctok::dump(o, "fError", get_fError());
        doctok::dump(o, "bpp", get_bpp());
        doctok::dump(o, "brcTop", get_brcTop());
        doctok::dump(o, "brcLeft", get_brcLeft());
        doctok::dump(o, "brcBottom", get_brcBottom());
        doctok::dump(o, "brcRight", get_brcRight());
        doctok::dump(o, "dxaOrigin", get_dxaOrigin());
        doctok::dump(o, "dyaOrigin", get_dyaOrigin());
        doctok::dump(o, "cProps", get_cProps());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FSPA
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 26
*/
    WW8FSPA::~WW8FSPA()
    {
    }
    
    void WW8FSPA::init()
    {
      
    }

    void WW8FSPA::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_spid());
                rHandler.attribute(NS_rtf::LN_SPID, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_xaLeft());
                rHandler.attribute(NS_rtf::LN_XALEFT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_yaTop());
                rHandler.attribute(NS_rtf::LN_YATOP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_xaRight());
                rHandler.attribute(NS_rtf::LN_XARIGHT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_yaBottom());
                rHandler.attribute(NS_rtf::LN_YABOTTOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fHdr());
                rHandler.attribute(NS_rtf::LN_FHDR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_bx());
                rHandler.attribute(NS_rtf::LN_BX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_by());
                rHandler.attribute(NS_rtf::LN_BY, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_wr());
                rHandler.attribute(NS_rtf::LN_WR, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_wrk());
                rHandler.attribute(NS_rtf::LN_WRK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fRcaSimple());
                rHandler.attribute(NS_rtf::LN_FRCASIMPLE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fBelowText());
                rHandler.attribute(NS_rtf::LN_FBELOWTEXT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fAnchorLock());
                rHandler.attribute(NS_rtf::LN_FANCHORLOCK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cTxbx());
                rHandler.attribute(NS_rtf::LN_CTXBX, *pVal);
            }
          {
              WW8Value::Pointer_t pVal = createValue(get_shape());
              rHandler.attribute(NS_rtf::LN_shape, *pVal);
          }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FSPA::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FSPA'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "spid", get_spid());
        doctok::dump(o, "xaLeft", get_xaLeft());
        doctok::dump(o, "yaTop", get_yaTop());
        doctok::dump(o, "xaRight", get_xaRight());
        doctok::dump(o, "yaBottom", get_yaBottom());
        doctok::dump(o, "fHdr", get_fHdr());
        doctok::dump(o, "bx", get_bx());
        doctok::dump(o, "by", get_by());
        doctok::dump(o, "wr", get_wr());
        doctok::dump(o, "wrk", get_wrk());
        doctok::dump(o, "fRcaSimple", get_fRcaSimple());
        doctok::dump(o, "fBelowText", get_fBelowText());
        doctok::dump(o, "fAnchorLock", get_fAnchorLock());
        doctok::dump(o, "cTxbx", get_cTxbx());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FLD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 2
*/
    WW8FLD::~WW8FLD()
    {
    }
    
    void WW8FLD::init()
    {
      
    }

    void WW8FLD::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_ch());
                rHandler.attribute(NS_rtf::LN_CH, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused0_5());
                rHandler.attribute(NS_rtf::LN_UNUSED0_5, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_flt());
                rHandler.attribute(NS_rtf::LN_FLT, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FLD::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FLD'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "ch", get_ch());
        doctok::dump(o, "unused0_5", get_unused0_5());
        doctok::dump(o, "flt", get_flt());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: Rectangle
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 16
*/
    WW8Rectangle::~WW8Rectangle()
    {
    }
    
    void WW8Rectangle::init()
    {
      
    }

    void WW8Rectangle::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_left());
                rHandler.attribute(NS_rtf::LN_shpLeft, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_top());
                rHandler.attribute(NS_rtf::LN_shpTop, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_right());
                rHandler.attribute(NS_rtf::LN_shpRight, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_bottom());
                rHandler.attribute(NS_rtf::LN_shpBottom, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8Rectangle::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='Rectangle'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "left", get_left());
        doctok::dump(o, "top", get_top());
        doctok::dump(o, "right", get_right());
        doctok::dump(o, "bottom", get_bottom());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FOPTE
    
    Stereotype ww8resource

    Stereotype withindex

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 6
*/
    WW8FOPTE::~WW8FOPTE()
    {
    }
    
    void WW8FOPTE::init()
    {
      
    }

    void WW8FOPTE::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_pid());
                rHandler.attribute(NS_rtf::LN_shppid, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fBid());
                rHandler.attribute(NS_rtf::LN_shpfBid, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fComplex());
                rHandler.attribute(NS_rtf::LN_shpfComplex, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_op());
                rHandler.attribute(NS_rtf::LN_shpop, *pVal);
            }
          {
              WW8Value::Pointer_t pVal = createValue(get_name());
              rHandler.attribute(NS_rtf::LN_shpname, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_value());
              rHandler.attribute(NS_rtf::LN_shpvalue, *pVal);
          }

      resolveNoAuto(rHandler);
    
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FOPTE::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FOPTE'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "pid", get_pid());
        doctok::dump(o, "fBid", get_fBid());
        doctok::dump(o, "fComplex", get_fComplex());
        doctok::dump(o, "op", get_op());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FDGG
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 16
*/
    WW8FDGG::~WW8FDGG()
    {
    }
    
    void WW8FDGG::init()
    {
      
    }

    void WW8FDGG::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_spidMax());
                rHandler.attribute(NS_rtf::LN_shpspidMax, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cidcl());
                rHandler.attribute(NS_rtf::LN_shpcidcl, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cspSaved());
                rHandler.attribute(NS_rtf::LN_shpcspSaved, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cdgSaved());
                rHandler.attribute(NS_rtf::LN_shpcdgSaved, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FDGG::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FDGG'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "spidMax", get_spidMax());
        doctok::dump(o, "cidcl", get_cidcl());
        doctok::dump(o, "cspSaved", get_cspSaved());
        doctok::dump(o, "cdgSaved", get_cdgSaved());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FIDCL
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 4
*/
    WW8FIDCL::~WW8FIDCL()
    {
    }
    
    void WW8FIDCL::init()
    {
      
    }

    void WW8FIDCL::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_dgid());
                rHandler.attribute(NS_rtf::LN_shpdgid, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cspidCur());
                rHandler.attribute(NS_rtf::LN_shpcspidCur, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FIDCL::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FIDCL'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "dgid", get_dgid());
        doctok::dump(o, "cspidCur", get_cspidCur());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FBSE
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0x24
*/
    WW8FBSE::~WW8FBSE()
    {
    }
    
    void WW8FBSE::init()
    {
      
    }

    void WW8FBSE::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_btWin32());
                rHandler.attribute(NS_rtf::LN_shpbtWin32, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_btMacOS());
                rHandler.attribute(NS_rtf::LN_shpbtMacOS, *pVal);
            }
            {
                sal_uInt32 nCount = get_rgbUid_count();              
                for (sal_uInt32 n = 0; n < nCount; ++n)
                {
                    WW8Value::Pointer_t pVal = createValue(get_rgbUid(n));
                    rHandler.attribute(NS_rtf::LN_shprgbUid, *pVal);
                }
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_tag());
                rHandler.attribute(NS_rtf::LN_shptag, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_size());
                rHandler.attribute(NS_rtf::LN_shpsize, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cRef());
                rHandler.attribute(NS_rtf::LN_shpcRef, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_foDelay());
                rHandler.attribute(NS_rtf::LN_shpfoDelay, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_usage());
                rHandler.attribute(NS_rtf::LN_shpusage, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cbName());
                rHandler.attribute(NS_rtf::LN_shpcbName, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused2());
                rHandler.attribute(NS_rtf::LN_shpunused2, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused3());
                rHandler.attribute(NS_rtf::LN_shpunused3, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FBSE::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FBSE'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "btWin32", get_btWin32());
        doctok::dump(o, "btMacOS", get_btMacOS());
        {
            sal_uInt32 nCount = get_rgbUid_count();
            
            for (sal_uInt32 n = 0; n < nCount; ++n)
            {
                doctok::dump(o, "rgbUid", get_rgbUid(n));
            }
        }
        doctok::dump(o, "tag", get_tag());
        doctok::dump(o, "size", get_size());
        doctok::dump(o, "cRef", get_cRef());
        doctok::dump(o, "foDelay", get_foDelay());
        doctok::dump(o, "usage", get_usage());
        doctok::dump(o, "cbName", get_cbName());
        doctok::dump(o, "unused2", get_unused2());
        doctok::dump(o, "unused3", get_unused3());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FRD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 2
*/
    WW8FRD::~WW8FRD()
    {
    }
    
    void WW8FRD::init()
    {
      
    }

    void WW8FRD::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_pid());
                rHandler.attribute(NS_rtf::LN_FRD, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FRD::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FRD'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "pid", get_pid());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: ATRD
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 28
*/
    WW8ATRD::~WW8ATRD()
    {
    }
    
    void WW8ATRD::init()
    {
      
    }

    void WW8ATRD::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_ibst());
                rHandler.attribute(NS_rtf::LN_IBST, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_ak());
                rHandler.attribute(NS_rtf::LN_AK, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_unused22_2());
                rHandler.attribute(NS_rtf::LN_UNUSED22_2, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_grfbmc());
                rHandler.attribute(NS_rtf::LN_GRFBMC, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lTagBkmk());
                rHandler.attribute(NS_rtf::LN_LTAGBKMK, *pVal);
            }
          {
              WW8Value::Pointer_t pVal = createValue(get_xstUsrInitl());
              rHandler.attribute(NS_rtf::LN_xstUsrInitl, *pVal);
          }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8ATRD::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='ATRD'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "ibst", get_ibst());
        doctok::dump(o, "ak", get_ak());
        doctok::dump(o, "unused22_2", get_unused22_2());
        doctok::dump(o, "grfbmc", get_grfbmc());
        doctok::dump(o, "lTagBkmk", get_lTagBkmk());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FTXBXS
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 22
*/
    WW8FTXBXS::~WW8FTXBXS()
    {
    }
    
    void WW8FTXBXS::init()
    {
      
    }

    void WW8FTXBXS::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_cTxbx());
                rHandler.attribute(NS_rtf::LN_CTXBX, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_iNextReuse());
                rHandler.attribute(NS_rtf::LN_INEXTREUSE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_cReusable());
                rHandler.attribute(NS_rtf::LN_CREUSABLE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_fReusable());
                rHandler.attribute(NS_rtf::LN_FREUSABLE, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_lid());
                rHandler.attribute(NS_rtf::LN_LID, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_txidUndo());
                rHandler.attribute(NS_rtf::LN_TXIDUNDO, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FTXBXS::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FTXBXS'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "cTxbx", get_cTxbx());
        doctok::dump(o, "iNextReuse", get_iNextReuse());
        doctok::dump(o, "cReusable", get_cReusable());
        doctok::dump(o, "fReusable", get_fReusable());
        doctok::dump(o, "lid", get_lid());
        doctok::dump(o, "txidUndo", get_txidUndo());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPChgTabsPapx
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPChgTabsPapx::~WW8sprmPChgTabsPapx()
    {
    }
    
    void WW8sprmPChgTabsPapx::init()
    {
      
    }

    void WW8sprmPChgTabsPapx::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_dxaDel_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_dxaDel(n));
                  rHandler.attribute(NS_rtf::LN_dxaDel, *pVal);
             }
         }

          {
              sal_uInt32 nCount = get_dxaAdd_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_dxaAdd(n));
                  rHandler.attribute(NS_rtf::LN_dxaAdd, *pVal);
             }
         }

          {
              sal_uInt32 nCount = get_tbdAdd_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_tbdAdd(n));
                  rHandler.attribute(NS_rtf::LN_tbdAdd, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPChgTabsPapx::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPChgTabsPapx'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmCPicLocation
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmCPicLocation::~WW8sprmCPicLocation()
    {
    }
    
    void WW8sprmCPicLocation::init()
    {
      
    }

    void WW8sprmCPicLocation::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_fcPic());
                rHandler.attribute(NS_rtf::LN_fcPic, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmCPicLocation::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmCPicLocation'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "fcPic", get_fcPic());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmCSymbol
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmCSymbol::~WW8sprmCSymbol()
    {
    }
    
    void WW8sprmCSymbol::init()
    {
      
    }

    void WW8sprmCSymbol::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_font());
                rHandler.attribute(NS_rtf::LN_FONT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_char());
                rHandler.attribute(NS_rtf::LN_CHAR, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmCSymbol::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmCSymbol'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "font", get_font());
        doctok::dump(o, "char", get_char());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTTableBorders
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmTTableBorders::~WW8sprmTTableBorders()
    {
    }
    
    void WW8sprmTTableBorders::init()
    {
      
    }

    void WW8sprmTTableBorders::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_rgbbrc_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_rgbbrc(n));
                  rHandler.attribute(NS_rtf::LN_rgbrc, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTTableBorders::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTTableBorders'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTDefTable
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmTDefTable::~WW8sprmTDefTable()
    {
    }
    
    void WW8sprmTDefTable::init()
    {
      
    }

    void WW8sprmTDefTable::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_cellx_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_cellx(n));
                  rHandler.attribute(NS_rtf::LN_cellx, *pVal);
             }
         }

          {
              sal_uInt32 nCount = get_tc_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_tc(n));
                  rHandler.attribute(NS_rtf::LN_tc, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTDefTable::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTDefTable'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTDefTableShd
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmTDefTableShd::~WW8sprmTDefTableShd()
    {
    }
    
    void WW8sprmTDefTableShd::init()
    {
      
    }

    void WW8sprmTDefTableShd::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_shd_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_shd(n));
                  rHandler.attribute(NS_rtf::LN_shd, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTDefTableShd::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTDefTableShd'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTCellShd
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmTCellShd::~WW8sprmTCellShd()
    {
    }
    
    void WW8sprmTCellShd::init()
    {
      
    }

    void WW8sprmTCellShd::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_shd_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_shd(n));
                  rHandler.attribute(NS_rtf::LN_cellShd, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTCellShd::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTCellShd'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTCellTopColor
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmTCellTopColor::~WW8sprmTCellTopColor()
    {
    }
    
    void WW8sprmTCellTopColor::init()
    {
      
    }

    void WW8sprmTCellTopColor::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_cellTopColor_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_cellTopColor(n));
                  rHandler.attribute(NS_rtf::LN_cellTopColor, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTCellTopColor::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTCellTopColor'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTCellLeftColor
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmTCellLeftColor::~WW8sprmTCellLeftColor()
    {
    }
    
    void WW8sprmTCellLeftColor::init()
    {
      
    }

    void WW8sprmTCellLeftColor::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_cellLeftColor_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_cellLeftColor(n));
                  rHandler.attribute(NS_rtf::LN_cellLeftColor, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTCellLeftColor::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTCellLeftColor'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTCellBottomColor
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmTCellBottomColor::~WW8sprmTCellBottomColor()
    {
    }
    
    void WW8sprmTCellBottomColor::init()
    {
      
    }

    void WW8sprmTCellBottomColor::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_cellBottomColor_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_cellBottomColor(n));
                  rHandler.attribute(NS_rtf::LN_cellBottomColor, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTCellBottomColor::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTCellBottomColor'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTCellRightColor
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmTCellRightColor::~WW8sprmTCellRightColor()
    {
    }
    
    void WW8sprmTCellRightColor::init()
    {
      
    }

    void WW8sprmTCellRightColor::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_cellRightColor_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_cellRightColor(n));
                  rHandler.attribute(NS_rtf::LN_cellRightColor, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTCellRightColor::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTCellRightColor'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTGridLineProps
    
    Stereotype ww8sprm

    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0x33
*/
    WW8sprmTGridLineProps::~WW8sprmTGridLineProps()
    {
    }
    
    void WW8sprmTGridLineProps::init()
    {
      
    }

    void WW8sprmTGridLineProps::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsTop());
                rHandler.attribute(NS_rtf::LN_LINEPROPSTOP, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsLeft());
                rHandler.attribute(NS_rtf::LN_LINEPROPSLEFT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsBottom());
                rHandler.attribute(NS_rtf::LN_LINEPROPSBOTTOM, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsRight());
                rHandler.attribute(NS_rtf::LN_LINEPROPSRIGHT, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsHorizontal());
                rHandler.attribute(NS_rtf::LN_LINEPROPSHORIZONTAL, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsVertical());
                rHandler.attribute(NS_rtf::LN_LINEPROPSVERTICAL, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTGridLineProps::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTGridLineProps'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "linePropsTop", get_linePropsTop());
        doctok::dump(o, "linePropsLeft", get_linePropsLeft());
        doctok::dump(o, "linePropsBottom", get_linePropsBottom());
        doctok::dump(o, "linePropsRight", get_linePropsRight());
        doctok::dump(o, "linePropsHorizontal", get_linePropsHorizontal());
        doctok::dump(o, "linePropsVertical", get_linePropsVertical());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTCellShadow
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmTCellShadow::~WW8sprmTCellShadow()
    {
    }
    
    void WW8sprmTCellShadow::init()
    {
      
    }

    void WW8sprmTCellShadow::resolve(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_cellShadow_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_cellShadow(n));
                  rHandler.attribute(NS_rtf::LN_CELLSHADOW, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTCellShadow::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTCellShadow'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBrcTop
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBrcTop::~WW8sprmPBrcTop()
    {
    }
    
    void WW8sprmPBrcTop::init()
    {
      
    }

    void WW8sprmPBrcTop::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_brcTop());
                rHandler.attribute(NS_rtf::LN_BRCTOP, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBrcTop::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBrcTop'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "brcTop", get_brcTop());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBrcLeft
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBrcLeft::~WW8sprmPBrcLeft()
    {
    }
    
    void WW8sprmPBrcLeft::init()
    {
      
    }

    void WW8sprmPBrcLeft::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_brcLeft());
                rHandler.attribute(NS_rtf::LN_BRCLEFT, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBrcLeft::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBrcLeft'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "brcLeft", get_brcLeft());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBrcBottom
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBrcBottom::~WW8sprmPBrcBottom()
    {
    }
    
    void WW8sprmPBrcBottom::init()
    {
      
    }

    void WW8sprmPBrcBottom::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_brcBottom());
                rHandler.attribute(NS_rtf::LN_BRCLEFT, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBrcBottom::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBrcBottom'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "brcBottom", get_brcBottom());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBrcRight
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBrcRight::~WW8sprmPBrcRight()
    {
    }
    
    void WW8sprmPBrcRight::init()
    {
      
    }

    void WW8sprmPBrcRight::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_brcRight());
                rHandler.attribute(NS_rtf::LN_BRCRIGHT, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBrcRight::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBrcRight'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "brcRight", get_brcRight());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBrcBetween
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBrcBetween::~WW8sprmPBrcBetween()
    {
    }
    
    void WW8sprmPBrcBetween::init()
    {
      
    }

    void WW8sprmPBrcBetween::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_brcBetween());
                rHandler.attribute(NS_rtf::LN_BRCBETWEEN, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBrcBetween::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBrcBetween'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "brcBetween", get_brcBetween());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBorderTop
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBorderTop::~WW8sprmPBorderTop()
    {
    }
    
    void WW8sprmPBorderTop::init()
    {
      
    }

    void WW8sprmPBorderTop::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsTop());
                rHandler.attribute(NS_rtf::LN_LINEPROPSTOP, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBorderTop::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBorderTop'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "linePropsTop", get_linePropsTop());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBorderLeft
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBorderLeft::~WW8sprmPBorderLeft()
    {
    }
    
    void WW8sprmPBorderLeft::init()
    {
      
    }

    void WW8sprmPBorderLeft::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsLeft());
                rHandler.attribute(NS_rtf::LN_LINEPROPSLEFT, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBorderLeft::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBorderLeft'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "linePropsLeft", get_linePropsLeft());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBorderBottom
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBorderBottom::~WW8sprmPBorderBottom()
    {
    }
    
    void WW8sprmPBorderBottom::init()
    {
      
    }

    void WW8sprmPBorderBottom::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsBottom());
                rHandler.attribute(NS_rtf::LN_LINEPROPSBOTTOM, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBorderBottom::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBorderBottom'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "linePropsBottom", get_linePropsBottom());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBorderRight
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBorderRight::~WW8sprmPBorderRight()
    {
    }
    
    void WW8sprmPBorderRight::init()
    {
      
    }

    void WW8sprmPBorderRight::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsRight());
                rHandler.attribute(NS_rtf::LN_LINEPROPSRIGHT, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBorderRight::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBorderRight'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "linePropsRight", get_linePropsRight());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmPBorderBetween
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmPBorderBetween::~WW8sprmPBorderBetween()
    {
    }
    
    void WW8sprmPBorderBetween::init()
    {
      
    }

    void WW8sprmPBorderBetween::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_linePropsBetween());
                rHandler.attribute(NS_rtf::LN_LINEPROPSBETWEEN, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmPBorderBetween::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmPBorderBetween'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "linePropsBetween", get_linePropsBetween());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmCBorder
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmCBorder::~WW8sprmCBorder()
    {
    }
    
    void WW8sprmCBorder::init()
    {
      
    }

    void WW8sprmCBorder::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_lineProps());
                rHandler.attribute(NS_rtf::LN_LINEPROPS, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmCBorder::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmCBorder'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "lineProps", get_lineProps());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTTPreferredWidth
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 6
*/
    WW8sprmTTPreferredWidth::~WW8sprmTTPreferredWidth()
    {
    }
    
    void WW8sprmTTPreferredWidth::init()
    {
      
    }

    void WW8sprmTTPreferredWidth::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_unit());
                rHandler.attribute(NS_rtf::LN_unit, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_preferredWidth());
                rHandler.attribute(NS_rtf::LN_preferredWidth, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTTPreferredWidth::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTTPreferredWidth'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "unit", get_unit());
        doctok::dump(o, "preferredWidth", get_preferredWidth());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmTTRLeft
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 6
*/
    WW8sprmTTRLeft::~WW8sprmTTRLeft()
    {
    }
    
    void WW8sprmTTRLeft::init()
    {
      
    }

    void WW8sprmTTRLeft::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_unit());
                rHandler.attribute(NS_rtf::LN_unit, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_trleft());
                rHandler.attribute(NS_rtf::LN_trleft, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmTTRLeft::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmTTRLeft'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "unit", get_unit());
        doctok::dump(o, "trleft", get_trleft());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: sprmCEastAsianLayout
    
    Stereotype ww8resource

    Stereotype ww8sprm

    Parent Resource: Properties
    Size: 0
*/
    WW8sprmCEastAsianLayout::~WW8sprmCEastAsianLayout()
    {
    }
    
    void WW8sprmCEastAsianLayout::init()
    {
      
    }

    void WW8sprmCEastAsianLayout::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_fcEastAsianLayout());
                rHandler.attribute(NS_rtf::LN_fcEastAsianLayout, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8sprmCEastAsianLayout::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='sprmCEastAsianLayout'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "fcEastAsianLayout", get_fcEastAsianLayout());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: UDefProp
    
    Stereotype dffrecord

    Stereotype resolvenoauto

    Parent Resource: Properties
    Size: 0
*/
    DffUDefProp::~DffUDefProp()
    {
    }
    
    void DffUDefProp::resolveLocal(Properties & rHandler)
    {
        try 
        {
      resolveNoAuto(rHandler);
    
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffUDefProp::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='UDefProp'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FSPGR
    
    Stereotype dffrecord

    Parent Resource: Properties
    Size: 0
*/
    DffFSPGR::~DffFSPGR()
    {
    }
    
    void DffFSPGR::resolveLocal(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_rectangle());
                rHandler.attribute(NS_rtf::LN_rectangle, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffFSPGR::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FSPGR'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "rectangle", get_rectangle());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: OPT
    
    Stereotype dffrecord

    Parent Resource: Properties
    Size: 0
*/
    DffOPT::~DffOPT()
    {
    }
    
    void DffOPT::resolveLocal(Properties & rHandler)
    {
        try 
        {
          {
              sal_uInt32 nCount = get_property_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_property(n));
                  rHandler.attribute(NS_rtf::LN_shpopt, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffOPT::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='OPT'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FSP
    
    Stereotype dffrecord

    Parent Resource: Properties
    Size: 0
*/
    DffFSP::~DffFSP()
    {
    }
    
    void DffFSP::resolveLocal(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_shptype());
                rHandler.attribute(NS_rtf::LN_shptype, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpid());
                rHandler.attribute(NS_rtf::LN_shpid, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfGroup());
                rHandler.attribute(NS_rtf::LN_shpfGroup, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfChild());
                rHandler.attribute(NS_rtf::LN_shpfChild, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfPatriarch());
                rHandler.attribute(NS_rtf::LN_shpfPatriarch, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfDeleted());
                rHandler.attribute(NS_rtf::LN_shpfDeleted, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfOleShape());
                rHandler.attribute(NS_rtf::LN_shpfOleShape, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfHaveMaster());
                rHandler.attribute(NS_rtf::LN_shpfHaveMaster, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfFlipH());
                rHandler.attribute(NS_rtf::LN_shpfFlipH, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfFlipV());
                rHandler.attribute(NS_rtf::LN_shpfFlipV, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfConnector());
                rHandler.attribute(NS_rtf::LN_shpfConnector, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfHaveAnchor());
                rHandler.attribute(NS_rtf::LN_shpfHaveAnchor, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfBackground());
                rHandler.attribute(NS_rtf::LN_shpfBackground, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_shpfHaveSpt());
                rHandler.attribute(NS_rtf::LN_shpfHaveSpt, *pVal);
            }
          {
              WW8Value::Pointer_t pVal = createValue(get_shptypename());
              rHandler.attribute(NS_rtf::LN_shptypename, *pVal);
          }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffFSP::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FSP'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "shptype", get_shptype());
        doctok::dump(o, "shpid", get_shpid());
        doctok::dump(o, "shpfGroup", get_shpfGroup());
        doctok::dump(o, "shpfChild", get_shpfChild());
        doctok::dump(o, "shpfPatriarch", get_shpfPatriarch());
        doctok::dump(o, "shpfDeleted", get_shpfDeleted());
        doctok::dump(o, "shpfOleShape", get_shpfOleShape());
        doctok::dump(o, "shpfHaveMaster", get_shpfHaveMaster());
        doctok::dump(o, "shpfFlipH", get_shpfFlipH());
        doctok::dump(o, "shpfFlipV", get_shpfFlipV());
        doctok::dump(o, "shpfConnector", get_shpfConnector());
        doctok::dump(o, "shpfHaveAnchor", get_shpfHaveAnchor());
        doctok::dump(o, "shpfBackground", get_shpfBackground());
        doctok::dump(o, "shpfHaveSpt", get_shpfHaveSpt());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: DGG
    
    Stereotype dffrecord

    Parent Resource: Properties
    Size: 0
*/
    DffDGG::~DffDGG()
    {
    }
    
    void DffDGG::resolveLocal(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_fdgg());
                rHandler.attribute(NS_rtf::LN_shpdgg, *pVal);
            }
          {
              sal_uInt32 nCount = get_fidcl_count();
              
              for (sal_uInt32 n = 0; n < nCount; ++n)
              {
                  WW8Value::Pointer_t pVal = createValue(get_fidcl(n));
                  rHandler.attribute(NS_rtf::LN_shpdgg, *pVal);
             }
         }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffDGG::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='DGG'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "fdgg", get_fdgg());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: BSE
    
    Stereotype dffrecord

    Parent Resource: Properties
    Size: 0
*/
    DffBSE::~DffBSE()
    {
    }
    
    void DffBSE::resolveLocal(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_fbse());
                rHandler.attribute(NS_rtf::LN_shpfbse, *pVal);
            }
          {
              WW8Value::Pointer_t pVal = createValue(get_blipname());
              rHandler.attribute(NS_rtf::LN_shpblipbname, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_blip());
              rHandler.attribute(NS_rtf::LN_blip, *pVal);
          }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffBSE::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='BSE'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "fbse", get_fbse());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: BlipPng
    
    Stereotype dffrecord

    Parent Resource: Properties
    Size: 0
*/
    DffBlipPng::~DffBlipPng()
    {
    }
    
    void DffBlipPng::resolveLocal(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_payload());
                rHandler.attribute(NS_rtf::LN_payload, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffBlipPng::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='BlipPng'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: BlipDib
    
    Stereotype dffrecord

    Parent Resource: Properties
    Size: 0
*/
    DffBlipDib::~DffBlipDib()
    {
    }
    
    void DffBlipDib::resolveLocal(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_payload());
                rHandler.attribute(NS_rtf::LN_payload, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffBlipDib::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='BlipDib'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: SpContainer
    
    Stereotype dffrecord

    Parent Resource: Properties
    Size: 0
*/
    DffSpContainer::~DffSpContainer()
    {
    }
    
    void DffSpContainer::resolveLocal(Properties & rHandler)
    {
        try 
        {
          {
              WW8Value::Pointer_t pVal = createValue(get_blip());
              rHandler.attribute(NS_rtf::LN_blip, *pVal);
          }

          {
              WW8Value::Pointer_t pVal = createValue(get_shptxt());
              rHandler.attribute(NS_rtf::LN_shptxt, *pVal);
          }

      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffSpContainer::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='SpContainer'>");
        
        WW8StructBase::dump(o);
        o.addItem("</dump>");
    }

/*
    Automatically generated class: FDG
    
    Stereotype ww8resource

    Parent Resource: Properties
    Size: 0
*/
    WW8FDG::~WW8FDG()
    {
    }
    
    void WW8FDG::init()
    {
      
    }

    void WW8FDG::resolve(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_csp());
                rHandler.attribute(NS_rtf::LN_csp, *pVal);
            }
            {
                WW8Value::Pointer_t pVal = createValue(get_spidCur());
                rHandler.attribute(NS_rtf::LN_spidCur, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    WW8FDG::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='FDG'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "csp", get_csp());
        doctok::dump(o, "spidCur", get_spidCur());
        o.addItem("</dump>");
    }

/*
    Automatically generated class: Dg
    
    Stereotype dffrecord

    Parent Resource: Properties
    Size: 0
*/
    DffDg::~DffDg()
    {
    }
    
    void DffDg::resolveLocal(Properties & rHandler)
    {
        try 
        {
            {
                WW8Value::Pointer_t pVal = createValue(get_fdg());
                rHandler.attribute(NS_rtf::LN_fdg, *pVal);
            }
      } catch (Exception & e) {
         clog << e.getText() << endl;
      }
    }

    void 
    DffDg::dump(OutputWithDepth < string > & o) const
    {
        o.addItem("<dump type='Dg'>");
        
        WW8StructBase::dump(o);
        doctok::dump(o, "fdg", get_fdg());
        o.addItem("</dump>");
    }

doctok::Reference < Properties > ::Pointer_t createSprmProps
(WW8PropertyImpl & rProp)
{
    doctok::Reference < Properties > ::Pointer_t pResult;

    switch (rProp.getId())
    {

    case 0xC60D:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPChgTabsPapx(rProp, 0, rProp.getCount()));

        break;

    case 0x6A03:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmCPicLocation(rProp, 0, rProp.getCount()));

        break;

    case 0x6A09:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmCSymbol(rProp, 0, rProp.getCount()));

        break;

    case 0xD605:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTTableBorders(rProp, 0, rProp.getCount()));

        break;

    case 0xD608:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTDefTable(rProp, 0, rProp.getCount()));

        break;

    case 0xD609:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTDefTableShd(rProp, 0, rProp.getCount()));

        break;

    case 0xD612:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTCellShd(rProp, 0, rProp.getCount()));

        break;

    case 0xD61A:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTCellTopColor(rProp, 0, rProp.getCount()));

        break;

    case 0xD61B:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTCellLeftColor(rProp, 0, rProp.getCount()));

        break;

    case 0xD61C:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTCellBottomColor(rProp, 0, rProp.getCount()));

        break;

    case 0xD61D:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTCellRightColor(rProp, 0, rProp.getCount()));

        break;

    case 0xD613:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTGridLineProps(rProp, 0, rProp.getCount()));

        break;

    case 0xd670:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTCellShadow(rProp, 0, rProp.getCount()));

        break;

    case 0x6424:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBrcTop(rProp, 0, rProp.getCount()));

        break;

    case 0x6425:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBrcLeft(rProp, 0, rProp.getCount()));

        break;

    case 0x6426:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBrcBottom(rProp, 0, rProp.getCount()));

        break;

    case 0x6427:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBrcRight(rProp, 0, rProp.getCount()));

        break;

    case 0x6428:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBrcBetween(rProp, 0, rProp.getCount()));

        break;

    case 0xc64e:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBorderTop(rProp, 0, rProp.getCount()));

        break;

    case 0xc64f:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBorderLeft(rProp, 0, rProp.getCount()));

        break;

    case 0xc650:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBorderBottom(rProp, 0, rProp.getCount()));

        break;

    case 0xc651:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBorderRight(rProp, 0, rProp.getCount()));

        break;

    case 0xc652:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmPBorderBetween(rProp, 0, rProp.getCount()));

        break;

    case 0xca72:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmCBorder(rProp, 0, rProp.getCount()));

        break;

    case 0xf614:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTTPreferredWidth(rProp, 0, rProp.getCount()));

        break;

    case 0xf661:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmTTRLeft(rProp, 0, rProp.getCount()));

        break;

    case 0xCA78:
        pResult = doctok::Reference < Properties > ::Pointer_t(new WW8sprmCEastAsianLayout(rProp, 0, rProp.getCount()));

        break;

    default:
        break;
    }

    return pResult;
}

doctok::Reference < BinaryObj > ::Pointer_t createSprmBinary
(WW8PropertyImpl & rProp)
{
    doctok::Reference < BinaryObj > ::Pointer_t pResult;

    switch (rProp.getId())
    {

    // warnings....
    case 0:
        break;

    default:
           break;
    }

    return pResult;
}

DffRecord * createDffRecord
(WW8StructBase * pParent, sal_uInt32 nOffset, sal_uInt32 * pCount)
{
    DffRecord * pResult = NULL;
    DffRecord aTmpRec(pParent, nOffset, 8);
    sal_uInt32 nSize = aTmpRec.calcSize();

    if (pCount != NULL)
        *pCount = nSize;

    switch (aTmpRec.getRecordType())
    {
        case 0xf122:
             pResult = new DffUDefProp(pParent, nOffset, nSize);
                 
             break;
        case 0xf009:
             pResult = new DffFSPGR(pParent, nOffset, nSize);
                 
             break;
        case 0xf00b:
             pResult = new DffOPT(pParent, nOffset, nSize);
                 
             break;
        case 0xf00a:
             pResult = new DffFSP(pParent, nOffset, nSize);
                 
             break;
        case 0xf006:
             pResult = new DffDGG(pParent, nOffset, nSize);
                 
             break;
        case 0xf007:
             pResult = new DffBSE(pParent, nOffset, nSize);
                 
             break;
        case 0xf01e:
             pResult = new DffBlipPng(pParent, nOffset, nSize);
                 
             break;
        case 0xf01f:
             pResult = new DffBlipDib(pParent, nOffset, nSize);
                 
             break;
        case 0xf004:
             pResult = new DffSpContainer(pParent, nOffset, nSize);
                 
             break;
        case 0xf008:
             pResult = new DffDg(pParent, nOffset, nSize);
                 
             break;

         default:
             pResult = new DffRecord(pParent, nOffset, nSize);

             break;
    }

    return pResult;
}

DffRecord * createDffRecord
(WW8Stream & rStream, sal_uInt32 nOffset, sal_uInt32 * pCount)
{
    DffRecord * pResult = NULL;
    DffRecord aTmpRec(rStream, nOffset, 8);
    sal_uInt32 nSize = aTmpRec.calcSize();

    if (pCount != NULL)
        *pCount = nSize;

    switch (aTmpRec.getRecordType())
    {
        case 0xf122:
             pResult = new DffUDefProp(rStream, nOffset, nSize);
                 
             break;
        case 0xf009:
             pResult = new DffFSPGR(rStream, nOffset, nSize);
                 
             break;
        case 0xf00b:
             pResult = new DffOPT(rStream, nOffset, nSize);
                 
             break;
        case 0xf00a:
             pResult = new DffFSP(rStream, nOffset, nSize);
                 
             break;
        case 0xf006:
             pResult = new DffDGG(rStream, nOffset, nSize);
                 
             break;
        case 0xf007:
             pResult = new DffBSE(rStream, nOffset, nSize);
                 
             break;
        case 0xf01e:
             pResult = new DffBlipPng(rStream, nOffset, nSize);
                 
             break;
        case 0xf01f:
             pResult = new DffBlipDib(rStream, nOffset, nSize);
                 
             break;
        case 0xf004:
             pResult = new DffSpContainer(rStream, nOffset, nSize);
                 
             break;
        case 0xf008:
             pResult = new DffDg(rStream, nOffset, nSize);
                 
             break;

         default:
             pResult = new DffRecord(rStream, nOffset, nSize);

             break;
    }

    return pResult;
}
    
rtl::OUString WW8FOPTE::get_name()
{
    return getDffOptName(get_pid());
}

rtl::OUString getDffOptName(sal_uInt32 nPid)
{
    rtl::OUString result;

    switch (nPid)
    {

      case NS_dff::LN_shprotation:
      result = rtl::OUString::createFromAscii("dff:shprotation");
      break;

      case NS_dff::LN_shpfLockRotation:
      result = rtl::OUString::createFromAscii("dff:shpfLockRotation");
      break;

      case NS_dff::LN_shpfLockAspectRatio:
      result = rtl::OUString::createFromAscii("dff:shpfLockAspectRatio");
      break;

      case NS_dff::LN_shpfLockPosition:
      result = rtl::OUString::createFromAscii("dff:shpfLockPosition");
      break;

      case NS_dff::LN_shpfLockAgainstSelect:
      result = rtl::OUString::createFromAscii("dff:shpfLockAgainstSelect");
      break;

      case NS_dff::LN_shpfLockCropping:
      result = rtl::OUString::createFromAscii("dff:shpfLockCropping");
      break;

      case NS_dff::LN_shpfLockVertices:
      result = rtl::OUString::createFromAscii("dff:shpfLockVertices");
      break;

      case NS_dff::LN_shpfLockText:
      result = rtl::OUString::createFromAscii("dff:shpfLockText");
      break;

      case NS_dff::LN_shpfLockAdjustHandles:
      result = rtl::OUString::createFromAscii("dff:shpfLockAdjustHandles");
      break;

      case NS_dff::LN_shpfLockAgainstGrouping:
      result = rtl::OUString::createFromAscii("dff:shpfLockAgainstGrouping");
      break;

      case NS_dff::LN_shplTxid:
      result = rtl::OUString::createFromAscii("dff:shplTxid");
      break;

      case NS_dff::LN_shpdxTextLeft:
      result = rtl::OUString::createFromAscii("dff:shpdxTextLeft");
      break;

      case NS_dff::LN_shpdyTextTop:
      result = rtl::OUString::createFromAscii("dff:shpdyTextTop");
      break;

      case NS_dff::LN_shpdxTextRight:
      result = rtl::OUString::createFromAscii("dff:shpdxTextRight");
      break;

      case NS_dff::LN_shpdyTextBottom:
      result = rtl::OUString::createFromAscii("dff:shpdyTextBottom");
      break;

      case NS_dff::LN_shpWrapText:
      result = rtl::OUString::createFromAscii("dff:shpWrapText");
      break;

      case NS_dff::LN_shpscaleText:
      result = rtl::OUString::createFromAscii("dff:shpscaleText");
      break;

      case NS_dff::LN_shpanchorText:
      result = rtl::OUString::createFromAscii("dff:shpanchorText");
      break;

      case NS_dff::LN_shptxflTextFlow:
      result = rtl::OUString::createFromAscii("dff:shptxflTextFlow");
      break;

      case NS_dff::LN_shpcdirFont:
      result = rtl::OUString::createFromAscii("dff:shpcdirFont");
      break;

      case NS_dff::LN_shphspNext:
      result = rtl::OUString::createFromAscii("dff:shphspNext");
      break;

      case NS_dff::LN_shptxdir:
      result = rtl::OUString::createFromAscii("dff:shptxdir");
      break;

      case NS_dff::LN_shpfSelectText:
      result = rtl::OUString::createFromAscii("dff:shpfSelectText");
      break;

      case NS_dff::LN_shpfAutoTextMargin:
      result = rtl::OUString::createFromAscii("dff:shpfAutoTextMargin");
      break;

      case NS_dff::LN_shpfRotateText:
      result = rtl::OUString::createFromAscii("dff:shpfRotateText");
      break;

      case NS_dff::LN_shpfFitShapeToText:
      result = rtl::OUString::createFromAscii("dff:shpfFitShapeToText");
      break;

      case NS_dff::LN_shpfFitTextToShape:
      result = rtl::OUString::createFromAscii("dff:shpfFitTextToShape");
      break;

      case NS_dff::LN_shpgtextUNICODE:
      result = rtl::OUString::createFromAscii("dff:shpgtextUNICODE");
      break;

      case NS_dff::LN_shpgtextRTF:
      result = rtl::OUString::createFromAscii("dff:shpgtextRTF");
      break;

      case NS_dff::LN_shpgtextAlign:
      result = rtl::OUString::createFromAscii("dff:shpgtextAlign");
      break;

      case NS_dff::LN_shpgtextSize:
      result = rtl::OUString::createFromAscii("dff:shpgtextSize");
      break;

      case NS_dff::LN_shpgtextSpacing:
      result = rtl::OUString::createFromAscii("dff:shpgtextSpacing");
      break;

      case NS_dff::LN_shpgtextFont:
      result = rtl::OUString::createFromAscii("dff:shpgtextFont");
      break;

      case NS_dff::LN_shpgtextFReverseRows:
      result = rtl::OUString::createFromAscii("dff:shpgtextFReverseRows");
      break;

      case NS_dff::LN_shpfGtext:
      result = rtl::OUString::createFromAscii("dff:shpfGtext");
      break;

      case NS_dff::LN_shpgtextFVertical:
      result = rtl::OUString::createFromAscii("dff:shpgtextFVertical");
      break;

      case NS_dff::LN_shpgtextFKern:
      result = rtl::OUString::createFromAscii("dff:shpgtextFKern");
      break;

      case NS_dff::LN_shpgtextFTight:
      result = rtl::OUString::createFromAscii("dff:shpgtextFTight");
      break;

      case NS_dff::LN_shpgtextFStretch:
      result = rtl::OUString::createFromAscii("dff:shpgtextFStretch");
      break;

      case NS_dff::LN_shpgtextFShrinkFit:
      result = rtl::OUString::createFromAscii("dff:shpgtextFShrinkFit");
      break;

      case NS_dff::LN_shpgtextFBestFit:
      result = rtl::OUString::createFromAscii("dff:shpgtextFBestFit");
      break;

      case NS_dff::LN_shpgtextFNormalize:
      result = rtl::OUString::createFromAscii("dff:shpgtextFNormalize");
      break;

      case NS_dff::LN_shpgtextFDxMeasure:
      result = rtl::OUString::createFromAscii("dff:shpgtextFDxMeasure");
      break;

      case NS_dff::LN_shpgtextFBold:
      result = rtl::OUString::createFromAscii("dff:shpgtextFBold");
      break;

      case NS_dff::LN_shpgtextFItalic:
      result = rtl::OUString::createFromAscii("dff:shpgtextFItalic");
      break;

      case NS_dff::LN_shpgtextFUnderline:
      result = rtl::OUString::createFromAscii("dff:shpgtextFUnderline");
      break;

      case NS_dff::LN_shpgtextFShadow:
      result = rtl::OUString::createFromAscii("dff:shpgtextFShadow");
      break;

      case NS_dff::LN_shpgtextFSmallcaps:
      result = rtl::OUString::createFromAscii("dff:shpgtextFSmallcaps");
      break;

      case NS_dff::LN_shpgtextFStrikethrough:
      result = rtl::OUString::createFromAscii("dff:shpgtextFStrikethrough");
      break;

      case NS_dff::LN_shpcropFromTop:
      result = rtl::OUString::createFromAscii("dff:shpcropFromTop");
      break;

      case NS_dff::LN_shpcropFromBottom:
      result = rtl::OUString::createFromAscii("dff:shpcropFromBottom");
      break;

      case NS_dff::LN_shpcropFromLeft:
      result = rtl::OUString::createFromAscii("dff:shpcropFromLeft");
      break;

      case NS_dff::LN_shpcropFromRight:
      result = rtl::OUString::createFromAscii("dff:shpcropFromRight");
      break;

      case NS_dff::LN_shppib:
      result = rtl::OUString::createFromAscii("dff:shppib");
      break;

      case NS_dff::LN_shppibName:
      result = rtl::OUString::createFromAscii("dff:shppibName");
      break;

      case NS_dff::LN_shppibFlags:
      result = rtl::OUString::createFromAscii("dff:shppibFlags");
      break;

      case NS_dff::LN_shppictureTransparent:
      result = rtl::OUString::createFromAscii("dff:shppictureTransparent");
      break;

      case NS_dff::LN_shppictureContrast:
      result = rtl::OUString::createFromAscii("dff:shppictureContrast");
      break;

      case NS_dff::LN_shppictureBrightness:
      result = rtl::OUString::createFromAscii("dff:shppictureBrightness");
      break;

      case NS_dff::LN_shppictureGamma:
      result = rtl::OUString::createFromAscii("dff:shppictureGamma");
      break;

      case NS_dff::LN_shppictureId:
      result = rtl::OUString::createFromAscii("dff:shppictureId");
      break;

      case NS_dff::LN_shppictureDblCrMod:
      result = rtl::OUString::createFromAscii("dff:shppictureDblCrMod");
      break;

      case NS_dff::LN_shppictureFillCrMod:
      result = rtl::OUString::createFromAscii("dff:shppictureFillCrMod");
      break;

      case NS_dff::LN_shppictureLineCrMod:
      result = rtl::OUString::createFromAscii("dff:shppictureLineCrMod");
      break;

      case NS_dff::LN_shppibPrint:
      result = rtl::OUString::createFromAscii("dff:shppibPrint");
      break;

      case NS_dff::LN_shppibPrintName:
      result = rtl::OUString::createFromAscii("dff:shppibPrintName");
      break;

      case NS_dff::LN_shppibPrintFlags:
      result = rtl::OUString::createFromAscii("dff:shppibPrintFlags");
      break;

      case NS_dff::LN_shpfNoHitTestPicture:
      result = rtl::OUString::createFromAscii("dff:shpfNoHitTestPicture");
      break;

      case NS_dff::LN_shppictureGray:
      result = rtl::OUString::createFromAscii("dff:shppictureGray");
      break;

      case NS_dff::LN_shppictureBiLevel:
      result = rtl::OUString::createFromAscii("dff:shppictureBiLevel");
      break;

      case NS_dff::LN_shppictureActive:
      result = rtl::OUString::createFromAscii("dff:shppictureActive");
      break;

      case NS_dff::LN_shpgeoLeft:
      result = rtl::OUString::createFromAscii("dff:shpgeoLeft");
      break;

      case NS_dff::LN_shpgeoTop:
      result = rtl::OUString::createFromAscii("dff:shpgeoTop");
      break;

      case NS_dff::LN_shpgeoRight:
      result = rtl::OUString::createFromAscii("dff:shpgeoRight");
      break;

      case NS_dff::LN_shpgeoBottom:
      result = rtl::OUString::createFromAscii("dff:shpgeoBottom");
      break;

      case NS_dff::LN_shpshapePath:
      result = rtl::OUString::createFromAscii("dff:shpshapePath");
      break;

      case NS_dff::LN_shppVertices:
      result = rtl::OUString::createFromAscii("dff:shppVertices");
      break;

      case NS_dff::LN_shppSegmentInfo:
      result = rtl::OUString::createFromAscii("dff:shppSegmentInfo");
      break;

      case NS_dff::LN_shpadjustValue:
      result = rtl::OUString::createFromAscii("dff:shpadjustValue");
      break;

      case NS_dff::LN_shpadjust2Value:
      result = rtl::OUString::createFromAscii("dff:shpadjust2Value");
      break;

      case NS_dff::LN_shpadjust3Value:
      result = rtl::OUString::createFromAscii("dff:shpadjust3Value");
      break;

      case NS_dff::LN_shpadjust4Value:
      result = rtl::OUString::createFromAscii("dff:shpadjust4Value");
      break;

      case NS_dff::LN_shpadjust5Value:
      result = rtl::OUString::createFromAscii("dff:shpadjust5Value");
      break;

      case NS_dff::LN_shpadjust6Value:
      result = rtl::OUString::createFromAscii("dff:shpadjust6Value");
      break;

      case NS_dff::LN_shpadjust7Value:
      result = rtl::OUString::createFromAscii("dff:shpadjust7Value");
      break;

      case NS_dff::LN_shpadjust8Value:
      result = rtl::OUString::createFromAscii("dff:shpadjust8Value");
      break;

      case NS_dff::LN_shpadjust9Value:
      result = rtl::OUString::createFromAscii("dff:shpadjust9Value");
      break;

      case NS_dff::LN_shpadjust10Value:
      result = rtl::OUString::createFromAscii("dff:shpadjust10Value");
      break;

      case NS_dff::LN_shpfShadowOK:
      result = rtl::OUString::createFromAscii("dff:shpfShadowOK");
      break;

      case NS_dff::LN_shpf3DOK:
      result = rtl::OUString::createFromAscii("dff:shpf3DOK");
      break;

      case NS_dff::LN_shpfLineOK:
      result = rtl::OUString::createFromAscii("dff:shpfLineOK");
      break;

      case NS_dff::LN_shpfGtextOK:
      result = rtl::OUString::createFromAscii("dff:shpfGtextOK");
      break;

      case NS_dff::LN_shpfFillShadeShapeOK:
      result = rtl::OUString::createFromAscii("dff:shpfFillShadeShapeOK");
      break;

      case NS_dff::LN_shpfFillOK:
      result = rtl::OUString::createFromAscii("dff:shpfFillOK");
      break;

      case NS_dff::LN_shpfillType:
      result = rtl::OUString::createFromAscii("dff:shpfillType");
      break;

      case NS_dff::LN_shpfillColor:
      result = rtl::OUString::createFromAscii("dff:shpfillColor");
      break;

      case NS_dff::LN_shpfillOpacity:
      result = rtl::OUString::createFromAscii("dff:shpfillOpacity");
      break;

      case NS_dff::LN_shpfillBackColor:
      result = rtl::OUString::createFromAscii("dff:shpfillBackColor");
      break;

      case NS_dff::LN_shpfillBackOpacity:
      result = rtl::OUString::createFromAscii("dff:shpfillBackOpacity");
      break;

      case NS_dff::LN_shpfillCrMod:
      result = rtl::OUString::createFromAscii("dff:shpfillCrMod");
      break;

      case NS_dff::LN_shpfillBlip:
      result = rtl::OUString::createFromAscii("dff:shpfillBlip");
      break;

      case NS_dff::LN_shpfillBlipName:
      result = rtl::OUString::createFromAscii("dff:shpfillBlipName");
      break;

      case NS_dff::LN_shpfillBlipFlags:
      result = rtl::OUString::createFromAscii("dff:shpfillBlipFlags");
      break;

      case NS_dff::LN_shpfillWidth:
      result = rtl::OUString::createFromAscii("dff:shpfillWidth");
      break;

      case NS_dff::LN_shpfillHeight:
      result = rtl::OUString::createFromAscii("dff:shpfillHeight");
      break;

      case NS_dff::LN_shpfillAngle:
      result = rtl::OUString::createFromAscii("dff:shpfillAngle");
      break;

      case NS_dff::LN_shpfillFocus:
      result = rtl::OUString::createFromAscii("dff:shpfillFocus");
      break;

      case NS_dff::LN_shpfillToLeft:
      result = rtl::OUString::createFromAscii("dff:shpfillToLeft");
      break;

      case NS_dff::LN_shpfillToTop:
      result = rtl::OUString::createFromAscii("dff:shpfillToTop");
      break;

      case NS_dff::LN_shpfillToRight:
      result = rtl::OUString::createFromAscii("dff:shpfillToRight");
      break;

      case NS_dff::LN_shpfillToBottom:
      result = rtl::OUString::createFromAscii("dff:shpfillToBottom");
      break;

      case NS_dff::LN_shpfillRectLeft:
      result = rtl::OUString::createFromAscii("dff:shpfillRectLeft");
      break;

      case NS_dff::LN_shpfillRectTop:
      result = rtl::OUString::createFromAscii("dff:shpfillRectTop");
      break;

      case NS_dff::LN_shpfillRectRight:
      result = rtl::OUString::createFromAscii("dff:shpfillRectRight");
      break;

      case NS_dff::LN_shpfillRectBottom:
      result = rtl::OUString::createFromAscii("dff:shpfillRectBottom");
      break;

      case NS_dff::LN_shpfillDztype:
      result = rtl::OUString::createFromAscii("dff:shpfillDztype");
      break;

      case NS_dff::LN_shpfillShadePreset:
      result = rtl::OUString::createFromAscii("dff:shpfillShadePreset");
      break;

      case NS_dff::LN_shpfillShadeColors:
      result = rtl::OUString::createFromAscii("dff:shpfillShadeColors");
      break;

      case NS_dff::LN_shpfillOriginX:
      result = rtl::OUString::createFromAscii("dff:shpfillOriginX");
      break;

      case NS_dff::LN_shpfillOriginY:
      result = rtl::OUString::createFromAscii("dff:shpfillOriginY");
      break;

      case NS_dff::LN_shpfillShapeOriginX:
      result = rtl::OUString::createFromAscii("dff:shpfillShapeOriginX");
      break;

      case NS_dff::LN_shpfillShapeOriginY:
      result = rtl::OUString::createFromAscii("dff:shpfillShapeOriginY");
      break;

      case NS_dff::LN_shpfillShadeType:
      result = rtl::OUString::createFromAscii("dff:shpfillShadeType");
      break;

      case NS_dff::LN_shpfFilled:
      result = rtl::OUString::createFromAscii("dff:shpfFilled");
      break;

      case NS_dff::LN_shpfHitTestFill:
      result = rtl::OUString::createFromAscii("dff:shpfHitTestFill");
      break;

      case NS_dff::LN_shpfillShape:
      result = rtl::OUString::createFromAscii("dff:shpfillShape");
      break;

      case NS_dff::LN_shpfillUseRect:
      result = rtl::OUString::createFromAscii("dff:shpfillUseRect");
      break;

      case NS_dff::LN_shpfNoFillHitTest:
      result = rtl::OUString::createFromAscii("dff:shpfNoFillHitTest");
      break;

      case NS_dff::LN_shplineColor:
      result = rtl::OUString::createFromAscii("dff:shplineColor");
      break;

      case NS_dff::LN_shplineOpacity:
      result = rtl::OUString::createFromAscii("dff:shplineOpacity");
      break;

      case NS_dff::LN_shplineBackColor:
      result = rtl::OUString::createFromAscii("dff:shplineBackColor");
      break;

      case NS_dff::LN_shplineCrMod:
      result = rtl::OUString::createFromAscii("dff:shplineCrMod");
      break;

      case NS_dff::LN_shplineType:
      result = rtl::OUString::createFromAscii("dff:shplineType");
      break;

      case NS_dff::LN_shplineFillBlip:
      result = rtl::OUString::createFromAscii("dff:shplineFillBlip");
      break;

      case NS_dff::LN_shplineFillBlipName:
      result = rtl::OUString::createFromAscii("dff:shplineFillBlipName");
      break;

      case NS_dff::LN_shplineFillBlipFlags:
      result = rtl::OUString::createFromAscii("dff:shplineFillBlipFlags");
      break;

      case NS_dff::LN_shplineFillWidth:
      result = rtl::OUString::createFromAscii("dff:shplineFillWidth");
      break;

      case NS_dff::LN_shplineFillHeight:
      result = rtl::OUString::createFromAscii("dff:shplineFillHeight");
      break;

      case NS_dff::LN_shplineFillDztype:
      result = rtl::OUString::createFromAscii("dff:shplineFillDztype");
      break;

      case NS_dff::LN_shplineWidth:
      result = rtl::OUString::createFromAscii("dff:shplineWidth");
      break;

      case NS_dff::LN_shplineMiterLimit:
      result = rtl::OUString::createFromAscii("dff:shplineMiterLimit");
      break;

      case NS_dff::LN_shplineStyle:
      result = rtl::OUString::createFromAscii("dff:shplineStyle");
      break;

      case NS_dff::LN_shplineDashing:
      result = rtl::OUString::createFromAscii("dff:shplineDashing");
      break;

      case NS_dff::LN_shplineDashStyle:
      result = rtl::OUString::createFromAscii("dff:shplineDashStyle");
      break;

      case NS_dff::LN_shplineStartArrowhead:
      result = rtl::OUString::createFromAscii("dff:shplineStartArrowhead");
      break;

      case NS_dff::LN_shplineEndArrowhead:
      result = rtl::OUString::createFromAscii("dff:shplineEndArrowhead");
      break;

      case NS_dff::LN_shplineStartArrowWidth:
      result = rtl::OUString::createFromAscii("dff:shplineStartArrowWidth");
      break;

      case NS_dff::LN_shplineStartArrowLength:
      result = rtl::OUString::createFromAscii("dff:shplineStartArrowLength");
      break;

      case NS_dff::LN_shplineEndArrowWidth:
      result = rtl::OUString::createFromAscii("dff:shplineEndArrowWidth");
      break;

      case NS_dff::LN_shplineEndArrowLength:
      result = rtl::OUString::createFromAscii("dff:shplineEndArrowLength");
      break;

      case NS_dff::LN_shplineJoinStyle:
      result = rtl::OUString::createFromAscii("dff:shplineJoinStyle");
      break;

      case NS_dff::LN_shplineEndCapStyle:
      result = rtl::OUString::createFromAscii("dff:shplineEndCapStyle");
      break;

      case NS_dff::LN_shpfArrowheadsOK:
      result = rtl::OUString::createFromAscii("dff:shpfArrowheadsOK");
      break;

      case NS_dff::LN_shpfLine:
      result = rtl::OUString::createFromAscii("dff:shpfLine");
      break;

      case NS_dff::LN_shpfHitTestLine:
      result = rtl::OUString::createFromAscii("dff:shpfHitTestLine");
      break;

      case NS_dff::LN_shplineFillShape:
      result = rtl::OUString::createFromAscii("dff:shplineFillShape");
      break;

      case NS_dff::LN_shpfNoLineDrawDash:
      result = rtl::OUString::createFromAscii("dff:shpfNoLineDrawDash");
      break;

      case NS_dff::LN_shpshadowType:
      result = rtl::OUString::createFromAscii("dff:shpshadowType");
      break;

      case NS_dff::LN_shpshadowColor:
      result = rtl::OUString::createFromAscii("dff:shpshadowColor");
      break;

      case NS_dff::LN_shpshadowHighlight:
      result = rtl::OUString::createFromAscii("dff:shpshadowHighlight");
      break;

      case NS_dff::LN_shpshadowCrMod:
      result = rtl::OUString::createFromAscii("dff:shpshadowCrMod");
      break;

      case NS_dff::LN_shpshadowOpacity:
      result = rtl::OUString::createFromAscii("dff:shpshadowOpacity");
      break;

      case NS_dff::LN_shpshadowOffsetX:
      result = rtl::OUString::createFromAscii("dff:shpshadowOffsetX");
      break;

      case NS_dff::LN_shpshadowOffsetY:
      result = rtl::OUString::createFromAscii("dff:shpshadowOffsetY");
      break;

      case NS_dff::LN_shpshadowSecondOffsetX:
      result = rtl::OUString::createFromAscii("dff:shpshadowSecondOffsetX");
      break;

      case NS_dff::LN_shpshadowSecondOffsetY:
      result = rtl::OUString::createFromAscii("dff:shpshadowSecondOffsetY");
      break;

      case NS_dff::LN_shpshadowScaleXToX:
      result = rtl::OUString::createFromAscii("dff:shpshadowScaleXToX");
      break;

      case NS_dff::LN_shpshadowScaleYToX:
      result = rtl::OUString::createFromAscii("dff:shpshadowScaleYToX");
      break;

      case NS_dff::LN_shpshadowScaleXToY:
      result = rtl::OUString::createFromAscii("dff:shpshadowScaleXToY");
      break;

      case NS_dff::LN_shpshadowScaleYToY:
      result = rtl::OUString::createFromAscii("dff:shpshadowScaleYToY");
      break;

      case NS_dff::LN_shpshadowPerspectiveX:
      result = rtl::OUString::createFromAscii("dff:shpshadowPerspectiveX");
      break;

      case NS_dff::LN_shpshadowPerspectiveY:
      result = rtl::OUString::createFromAscii("dff:shpshadowPerspectiveY");
      break;

      case NS_dff::LN_shpshadowWeight:
      result = rtl::OUString::createFromAscii("dff:shpshadowWeight");
      break;

      case NS_dff::LN_shpshadowOriginX:
      result = rtl::OUString::createFromAscii("dff:shpshadowOriginX");
      break;

      case NS_dff::LN_shpshadowOriginY:
      result = rtl::OUString::createFromAscii("dff:shpshadowOriginY");
      break;

      case NS_dff::LN_shpfShadow:
      result = rtl::OUString::createFromAscii("dff:shpfShadow");
      break;

      case NS_dff::LN_shpfshadowObscured:
      result = rtl::OUString::createFromAscii("dff:shpfshadowObscured");
      break;

      case NS_dff::LN_shpperspectiveType:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveType");
      break;

      case NS_dff::LN_shpperspectiveOffsetX:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveOffsetX");
      break;

      case NS_dff::LN_shpperspectiveOffsetY:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveOffsetY");
      break;

      case NS_dff::LN_shpperspectiveScaleXToX:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveScaleXToX");
      break;

      case NS_dff::LN_shpperspectiveScaleYToX:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveScaleYToX");
      break;

      case NS_dff::LN_shpperspectiveScaleXToY:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveScaleXToY");
      break;

      case NS_dff::LN_shpperspectiveScaleYToY:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveScaleYToY");
      break;

      case NS_dff::LN_shpperspectivePerspectiveX:
      result = rtl::OUString::createFromAscii("dff:shpperspectivePerspectiveX");
      break;

      case NS_dff::LN_shpperspectivePerspectiveY:
      result = rtl::OUString::createFromAscii("dff:shpperspectivePerspectiveY");
      break;

      case NS_dff::LN_shpperspectiveWeight:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveWeight");
      break;

      case NS_dff::LN_shpperspectiveOriginX:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveOriginX");
      break;

      case NS_dff::LN_shpperspectiveOriginY:
      result = rtl::OUString::createFromAscii("dff:shpperspectiveOriginY");
      break;

      case NS_dff::LN_shpfPerspective:
      result = rtl::OUString::createFromAscii("dff:shpfPerspective");
      break;

      case NS_dff::LN_shpc3DSpecularAmt:
      result = rtl::OUString::createFromAscii("dff:shpc3DSpecularAmt");
      break;

      case NS_dff::LN_shpc3DDiffuseAmt:
      result = rtl::OUString::createFromAscii("dff:shpc3DDiffuseAmt");
      break;

      case NS_dff::LN_shpc3DShininess:
      result = rtl::OUString::createFromAscii("dff:shpc3DShininess");
      break;

      case NS_dff::LN_shpc3DEdgeThickness:
      result = rtl::OUString::createFromAscii("dff:shpc3DEdgeThickness");
      break;

      case NS_dff::LN_shpc3DExtrudeForward:
      result = rtl::OUString::createFromAscii("dff:shpc3DExtrudeForward");
      break;

      case NS_dff::LN_shpc3DExtrudeBackward:
      result = rtl::OUString::createFromAscii("dff:shpc3DExtrudeBackward");
      break;

      case NS_dff::LN_shpc3DExtrudePlane:
      result = rtl::OUString::createFromAscii("dff:shpc3DExtrudePlane");
      break;

      case NS_dff::LN_shpc3DExtrusionColor:
      result = rtl::OUString::createFromAscii("dff:shpc3DExtrusionColor");
      break;

      case NS_dff::LN_shpc3DCrMod:
      result = rtl::OUString::createFromAscii("dff:shpc3DCrMod");
      break;

      case NS_dff::LN_shpf3D:
      result = rtl::OUString::createFromAscii("dff:shpf3D");
      break;

      case NS_dff::LN_shpfc3DMetallic:
      result = rtl::OUString::createFromAscii("dff:shpfc3DMetallic");
      break;

      case NS_dff::LN_shpfc3DUseExtrusionColor:
      result = rtl::OUString::createFromAscii("dff:shpfc3DUseExtrusionColor");
      break;

      case NS_dff::LN_shpfc3DLightFace:
      result = rtl::OUString::createFromAscii("dff:shpfc3DLightFace");
      break;

      case NS_dff::LN_shpc3DYRotationAngle:
      result = rtl::OUString::createFromAscii("dff:shpc3DYRotationAngle");
      break;

      case NS_dff::LN_shpc3DXRotationAngle:
      result = rtl::OUString::createFromAscii("dff:shpc3DXRotationAngle");
      break;

      case NS_dff::LN_shpc3DRotationAxisX:
      result = rtl::OUString::createFromAscii("dff:shpc3DRotationAxisX");
      break;

      case NS_dff::LN_shpc3DRotationAxisY:
      result = rtl::OUString::createFromAscii("dff:shpc3DRotationAxisY");
      break;

      case NS_dff::LN_shpc3DRotationAxisZ:
      result = rtl::OUString::createFromAscii("dff:shpc3DRotationAxisZ");
      break;

      case NS_dff::LN_shpc3DRotationAngle:
      result = rtl::OUString::createFromAscii("dff:shpc3DRotationAngle");
      break;

      case NS_dff::LN_shpc3DRotationCenterX:
      result = rtl::OUString::createFromAscii("dff:shpc3DRotationCenterX");
      break;

      case NS_dff::LN_shpc3DRotationCenterY:
      result = rtl::OUString::createFromAscii("dff:shpc3DRotationCenterY");
      break;

      case NS_dff::LN_shpc3DRotationCenterZ:
      result = rtl::OUString::createFromAscii("dff:shpc3DRotationCenterZ");
      break;

      case NS_dff::LN_shpc3DRenderMode:
      result = rtl::OUString::createFromAscii("dff:shpc3DRenderMode");
      break;

      case NS_dff::LN_shpc3DTolerance:
      result = rtl::OUString::createFromAscii("dff:shpc3DTolerance");
      break;

      case NS_dff::LN_shpc3DXViewpoint:
      result = rtl::OUString::createFromAscii("dff:shpc3DXViewpoint");
      break;

      case NS_dff::LN_shpc3DYViewpoint:
      result = rtl::OUString::createFromAscii("dff:shpc3DYViewpoint");
      break;

      case NS_dff::LN_shpc3DZViewpoint:
      result = rtl::OUString::createFromAscii("dff:shpc3DZViewpoint");
      break;

      case NS_dff::LN_shpc3DOriginX:
      result = rtl::OUString::createFromAscii("dff:shpc3DOriginX");
      break;

      case NS_dff::LN_shpc3DOriginY:
      result = rtl::OUString::createFromAscii("dff:shpc3DOriginY");
      break;

      case NS_dff::LN_shpc3DSkewAngle:
      result = rtl::OUString::createFromAscii("dff:shpc3DSkewAngle");
      break;

      case NS_dff::LN_shpc3DSkewAmount:
      result = rtl::OUString::createFromAscii("dff:shpc3DSkewAmount");
      break;

      case NS_dff::LN_shpc3DAmbientIntensity:
      result = rtl::OUString::createFromAscii("dff:shpc3DAmbientIntensity");
      break;

      case NS_dff::LN_shpc3DKeyX:
      result = rtl::OUString::createFromAscii("dff:shpc3DKeyX");
      break;

      case NS_dff::LN_shpc3DKeyY:
      result = rtl::OUString::createFromAscii("dff:shpc3DKeyY");
      break;

      case NS_dff::LN_shpc3DKeyZ:
      result = rtl::OUString::createFromAscii("dff:shpc3DKeyZ");
      break;

      case NS_dff::LN_shpc3DKeyIntensity:
      result = rtl::OUString::createFromAscii("dff:shpc3DKeyIntensity");
      break;

      case NS_dff::LN_shpc3DFillX:
      result = rtl::OUString::createFromAscii("dff:shpc3DFillX");
      break;

      case NS_dff::LN_shpc3DFillY:
      result = rtl::OUString::createFromAscii("dff:shpc3DFillY");
      break;

      case NS_dff::LN_shpc3DFillZ:
      result = rtl::OUString::createFromAscii("dff:shpc3DFillZ");
      break;

      case NS_dff::LN_shpc3DFillIntensity:
      result = rtl::OUString::createFromAscii("dff:shpc3DFillIntensity");
      break;

      case NS_dff::LN_shpfc3DConstrainRotation:
      result = rtl::OUString::createFromAscii("dff:shpfc3DConstrainRotation");
      break;

      case NS_dff::LN_shpfc3DRotationCenterAuto:
      result = rtl::OUString::createFromAscii("dff:shpfc3DRotationCenterAuto");
      break;

      case NS_dff::LN_shpfc3DParallel:
      result = rtl::OUString::createFromAscii("dff:shpfc3DParallel");
      break;

      case NS_dff::LN_shpfc3DKeyHarsh:
      result = rtl::OUString::createFromAscii("dff:shpfc3DKeyHarsh");
      break;

      case NS_dff::LN_shpfc3DFillHarsh:
      result = rtl::OUString::createFromAscii("dff:shpfc3DFillHarsh");
      break;

      case NS_dff::LN_shphspMaster:
      result = rtl::OUString::createFromAscii("dff:shphspMaster");
      break;

      case NS_dff::LN_shpcxstyle:
      result = rtl::OUString::createFromAscii("dff:shpcxstyle");
      break;

      case NS_dff::LN_shpbWMode:
      result = rtl::OUString::createFromAscii("dff:shpbWMode");
      break;

      case NS_dff::LN_shpbWModePureBW:
      result = rtl::OUString::createFromAscii("dff:shpbWModePureBW");
      break;

      case NS_dff::LN_shpbWModeBW:
      result = rtl::OUString::createFromAscii("dff:shpbWModeBW");
      break;

      case NS_dff::LN_shpfOleIcon:
      result = rtl::OUString::createFromAscii("dff:shpfOleIcon");
      break;

      case NS_dff::LN_shpfPreferRelativeResize:
      result = rtl::OUString::createFromAscii("dff:shpfPreferRelativeResize");
      break;

      case NS_dff::LN_shpfLockShapeType:
      result = rtl::OUString::createFromAscii("dff:shpfLockShapeType");
      break;

      case NS_dff::LN_shpfDeleteAttachedObject:
      result = rtl::OUString::createFromAscii("dff:shpfDeleteAttachedObject");
      break;

      case NS_dff::LN_shpfBackground:
      result = rtl::OUString::createFromAscii("dff:shpfBackground");
      break;

      case NS_dff::LN_shpspcot:
      result = rtl::OUString::createFromAscii("dff:shpspcot");
      break;

      case NS_dff::LN_shpdxyCalloutGap:
      result = rtl::OUString::createFromAscii("dff:shpdxyCalloutGap");
      break;

      case NS_dff::LN_shpspcoa:
      result = rtl::OUString::createFromAscii("dff:shpspcoa");
      break;

      case NS_dff::LN_shpspcod:
      result = rtl::OUString::createFromAscii("dff:shpspcod");
      break;

      case NS_dff::LN_shpdxyCalloutDropSpecified:
      result = rtl::OUString::createFromAscii("dff:shpdxyCalloutDropSpecified");
      break;

      case NS_dff::LN_shpdxyCalloutLengthSpecified:
      result = rtl::OUString::createFromAscii("dff:shpdxyCalloutLengthSpecified");
      break;

      case NS_dff::LN_shpfCallout:
      result = rtl::OUString::createFromAscii("dff:shpfCallout");
      break;

      case NS_dff::LN_shpfCalloutAccentBar:
      result = rtl::OUString::createFromAscii("dff:shpfCalloutAccentBar");
      break;

      case NS_dff::LN_shpfCalloutTextBorder:
      result = rtl::OUString::createFromAscii("dff:shpfCalloutTextBorder");
      break;

      case NS_dff::LN_shpfCalloutMinusX:
      result = rtl::OUString::createFromAscii("dff:shpfCalloutMinusX");
      break;

      case NS_dff::LN_shpfCalloutMinusY:
      result = rtl::OUString::createFromAscii("dff:shpfCalloutMinusY");
      break;

      case NS_dff::LN_shpfCalloutDropAuto:
      result = rtl::OUString::createFromAscii("dff:shpfCalloutDropAuto");
      break;

      case NS_dff::LN_shpfCalloutLengthSpecified:
      result = rtl::OUString::createFromAscii("dff:shpfCalloutLengthSpecified");
      break;

      case NS_dff::LN_shpwzName:
      result = rtl::OUString::createFromAscii("dff:shpwzName");
      break;

      case NS_dff::LN_shpwzDescription:
      result = rtl::OUString::createFromAscii("dff:shpwzDescription");
      break;

      case NS_dff::LN_shppihlShape:
      result = rtl::OUString::createFromAscii("dff:shppihlShape");
      break;

      case NS_dff::LN_shppWrapPolygonVertices:
      result = rtl::OUString::createFromAscii("dff:shppWrapPolygonVertices");
      break;

      case NS_dff::LN_shpdxWrapDistLeft:
      result = rtl::OUString::createFromAscii("dff:shpdxWrapDistLeft");
      break;

      case NS_dff::LN_shpdyWrapDistTop:
      result = rtl::OUString::createFromAscii("dff:shpdyWrapDistTop");
      break;

      case NS_dff::LN_shpdxWrapDistRight:
      result = rtl::OUString::createFromAscii("dff:shpdxWrapDistRight");
      break;

      case NS_dff::LN_shpdyWrapDistBottom:
      result = rtl::OUString::createFromAscii("dff:shpdyWrapDistBottom");
      break;

      case NS_dff::LN_shplidRegroup:
      result = rtl::OUString::createFromAscii("dff:shplidRegroup");
      break;

      case NS_dff::LN_shpfEditedWrap:
      result = rtl::OUString::createFromAscii("dff:shpfEditedWrap");
      break;

      case NS_dff::LN_shpfBehindDocument:
      result = rtl::OUString::createFromAscii("dff:shpfBehindDocument");
      break;

      case NS_dff::LN_shpfOnDblClickNotify:
      result = rtl::OUString::createFromAscii("dff:shpfOnDblClickNotify");
      break;

      case NS_dff::LN_shpfIsButton:
      result = rtl::OUString::createFromAscii("dff:shpfIsButton");
      break;

      case NS_dff::LN_shpfOneD:
      result = rtl::OUString::createFromAscii("dff:shpfOneD");
      break;

      case NS_dff::LN_shpfHidden:
      result = rtl::OUString::createFromAscii("dff:shpfHidden");
      break;

      case NS_dff::LN_shpfPrint:
      result = rtl::OUString::createFromAscii("dff:shpfPrint");
      break;

      default:
         break;
    }

    return result;
}

WW8Value::Pointer_t WW8FOPTE::get_stringValue()
{
    WW8Value::Pointer_t pResult;
    DffOPT * pOpt = dynamic_cast < DffOPT * >(mpParent); 
    sal_uInt32 nExtraOffset = pOpt->get_extraoffset(mnIndex);
    sal_uInt32 nExtraLength = pOpt->get_extraoffset(mnIndex + 1) - nExtraOffset;
    pResult = createValue(mpParent->getString(nExtraOffset, nExtraLength / 2));

    return pResult;
}

WW8Value::Pointer_t WW8FOPTE::get_value()
{
    WW8Value::Pointer_t pResult;

    switch (get_pid())
    {

        case NS_dff::LN_shprotation:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfLockRotation:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLockAspectRatio:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLockPosition:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLockAgainstSelect:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLockCropping:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLockVertices:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLockText:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLockAdjustHandles:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLockAgainstGrouping:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shplTxid:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpdxTextLeft:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpdyTextTop:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpdxTextRight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpdyTextBottom:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpscaleText:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfSelectText:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfAutoTextMargin:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfRotateText:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfFitShapeToText:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfFitTextToShape:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextUNICODE:
        {
        
              pResult = get_stringValue();

        }
        break;

        case NS_dff::LN_shpgtextSize:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpgtextSpacing:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpgtextFont:
        {
        
              pResult = get_stringValue();

        }
        break;

        case NS_dff::LN_shpgtextFReverseRows:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfGtext:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFVertical:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFKern:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFTight:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFStretch:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFShrinkFit:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFBestFit:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFNormalize:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFDxMeasure:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFBold:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFItalic:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFUnderline:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFShadow:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFSmallcaps:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgtextFStrikethrough:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpcropFromTop:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpcropFromBottom:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpcropFromLeft:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpcropFromRight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shppibName:
        {
        
              pResult = get_stringValue();

        }
        break;

        case NS_dff::LN_shppictureTransparent:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shppictureContrast:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shppictureBrightness:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shppictureGamma:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shppictureId:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shppibPrintName:
        {
        
              pResult = get_stringValue();

        }
        break;

        case NS_dff::LN_shpfNoHitTestPicture:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shppictureGray:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shppictureBiLevel:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shppictureActive:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpgeoLeft:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpgeoTop:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpgeoRight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpgeoBottom:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjustValue:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjust2Value:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjust3Value:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjust4Value:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjust5Value:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjust6Value:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjust7Value:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjust8Value:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjust9Value:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpadjust10Value:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfShadowOK:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpf3DOK:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLineOK:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfGtextOK:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfFillShadeShapeOK:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfFillOK:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfillOpacity:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillBackOpacity:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillBlipName:
        {
        
              pResult = get_stringValue();

        }
        break;

        case NS_dff::LN_shpfillWidth:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillHeight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillAngle:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillFocus:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillToLeft:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillToTop:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillToRight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillToBottom:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillRectLeft:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillRectTop:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillRectRight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillRectBottom:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillShadePreset:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillOriginX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillOriginY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillShapeOriginX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfillShapeOriginY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfFilled:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfHitTestFill:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfillShape:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfillUseRect:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfNoFillHitTest:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shplineOpacity:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shplineFillBlipName:
        {
        
              pResult = get_stringValue();

        }
        break;

        case NS_dff::LN_shplineFillWidth:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shplineFillHeight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shplineWidth:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shplineMiterLimit:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfArrowheadsOK:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLine:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfHitTestLine:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shplineFillShape:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfNoLineDrawDash:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpshadowOpacity:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowOffsetX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowOffsetY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowSecondOffsetX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowSecondOffsetY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowScaleXToX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowScaleYToX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowScaleXToY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowScaleYToY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowPerspectiveX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowPerspectiveY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowWeight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowOriginX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpshadowOriginY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfShadow:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfshadowObscured:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpperspectiveOffsetX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectiveOffsetY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectiveScaleXToX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectiveScaleYToX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectiveScaleXToY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectiveScaleYToY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectivePerspectiveX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectivePerspectiveY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectiveWeight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectiveOriginX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpperspectiveOriginY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfPerspective:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpc3DSpecularAmt:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DDiffuseAmt:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DShininess:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DEdgeThickness:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DExtrudeForward:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DExtrudeBackward:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DExtrudePlane:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpf3D:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfc3DMetallic:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfc3DUseExtrusionColor:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfc3DLightFace:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpc3DYRotationAngle:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DXRotationAngle:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DRotationAxisX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DRotationAxisY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DRotationAxisZ:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DRotationAngle:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DRotationCenterX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DRotationCenterY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DRotationCenterZ:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DTolerance:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DXViewpoint:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DYViewpoint:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DZViewpoint:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DOriginX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DOriginY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DSkewAngle:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DSkewAmount:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DAmbientIntensity:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DKeyX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DKeyY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DKeyZ:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DKeyIntensity:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DFillX:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DFillY:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DFillZ:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpc3DFillIntensity:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfc3DConstrainRotation:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfc3DRotationCenterAuto:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfc3DParallel:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfc3DKeyHarsh:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfc3DFillHarsh:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfOleIcon:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfPreferRelativeResize:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfLockShapeType:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfDeleteAttachedObject:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfBackground:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpdxyCalloutGap:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpdxyCalloutDropSpecified:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpdxyCalloutLengthSpecified:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfCallout:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfCalloutAccentBar:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfCalloutTextBorder:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfCalloutMinusX:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfCalloutMinusY:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfCalloutDropAuto:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfCalloutLengthSpecified:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpwzName:
        {
        
              pResult = get_stringValue();

        }
        break;

        case NS_dff::LN_shpwzDescription:
        {
        
              pResult = get_stringValue();

        }
        break;

        case NS_dff::LN_shpdxWrapDistLeft:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpdyWrapDistTop:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpdxWrapDistRight:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpdyWrapDistBottom:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shplidRegroup:
        {
        pResult = createValue(getU32(0x2));

        }
        break;

        case NS_dff::LN_shpfEditedWrap:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfBehindDocument:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfOnDblClickNotify:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfIsButton:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfOneD:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfHidden:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

        case NS_dff::LN_shpfPrint:
        {
        pResult = createValue(getU32(0x2) & 1);

        }
        break;

    default:
        pResult = createValue(getU32(0x2));

        break;
    }

    return pResult;
}

bool isBooleanDffOpt(sal_uInt32 nId)
{
    bool bResult = false;

    switch (nId)
    {
    case NS_dff::LN_shpfLockRotation:
    case NS_dff::LN_shpfLockAspectRatio:
    case NS_dff::LN_shpfLockPosition:
    case NS_dff::LN_shpfLockAgainstSelect:
    case NS_dff::LN_shpfLockCropping:
    case NS_dff::LN_shpfLockVertices:
    case NS_dff::LN_shpfLockText:
    case NS_dff::LN_shpfLockAdjustHandles:
    case NS_dff::LN_shpfLockAgainstGrouping:
    case NS_dff::LN_shpfSelectText:
    case NS_dff::LN_shpfAutoTextMargin:
    case NS_dff::LN_shpfRotateText:
    case NS_dff::LN_shpfFitShapeToText:
    case NS_dff::LN_shpfFitTextToShape:
    case NS_dff::LN_shpgtextFReverseRows:
    case NS_dff::LN_shpfGtext:
    case NS_dff::LN_shpgtextFVertical:
    case NS_dff::LN_shpgtextFKern:
    case NS_dff::LN_shpgtextFTight:
    case NS_dff::LN_shpgtextFStretch:
    case NS_dff::LN_shpgtextFShrinkFit:
    case NS_dff::LN_shpgtextFBestFit:
    case NS_dff::LN_shpgtextFNormalize:
    case NS_dff::LN_shpgtextFDxMeasure:
    case NS_dff::LN_shpgtextFBold:
    case NS_dff::LN_shpgtextFItalic:
    case NS_dff::LN_shpgtextFUnderline:
    case NS_dff::LN_shpgtextFShadow:
    case NS_dff::LN_shpgtextFSmallcaps:
    case NS_dff::LN_shpgtextFStrikethrough:
    case NS_dff::LN_shpfNoHitTestPicture:
    case NS_dff::LN_shppictureGray:
    case NS_dff::LN_shppictureBiLevel:
    case NS_dff::LN_shppictureActive:
    case NS_dff::LN_shpfShadowOK:
    case NS_dff::LN_shpf3DOK:
    case NS_dff::LN_shpfLineOK:
    case NS_dff::LN_shpfGtextOK:
    case NS_dff::LN_shpfFillShadeShapeOK:
    case NS_dff::LN_shpfFillOK:
    case NS_dff::LN_shpfFilled:
    case NS_dff::LN_shpfHitTestFill:
    case NS_dff::LN_shpfillShape:
    case NS_dff::LN_shpfillUseRect:
    case NS_dff::LN_shpfNoFillHitTest:
    case NS_dff::LN_shpfArrowheadsOK:
    case NS_dff::LN_shpfLine:
    case NS_dff::LN_shpfHitTestLine:
    case NS_dff::LN_shplineFillShape:
    case NS_dff::LN_shpfNoLineDrawDash:
    case NS_dff::LN_shpfShadow:
    case NS_dff::LN_shpfshadowObscured:
    case NS_dff::LN_shpfPerspective:
    case NS_dff::LN_shpf3D:
    case NS_dff::LN_shpfc3DMetallic:
    case NS_dff::LN_shpfc3DUseExtrusionColor:
    case NS_dff::LN_shpfc3DLightFace:
    case NS_dff::LN_shpfc3DConstrainRotation:
    case NS_dff::LN_shpfc3DRotationCenterAuto:
    case NS_dff::LN_shpfc3DParallel:
    case NS_dff::LN_shpfc3DKeyHarsh:
    case NS_dff::LN_shpfc3DFillHarsh:
    case NS_dff::LN_shpfOleIcon:
    case NS_dff::LN_shpfPreferRelativeResize:
    case NS_dff::LN_shpfLockShapeType:
    case NS_dff::LN_shpfDeleteAttachedObject:
    case NS_dff::LN_shpfBackground:
    case NS_dff::LN_shpfCallout:
    case NS_dff::LN_shpfCalloutAccentBar:
    case NS_dff::LN_shpfCalloutTextBorder:
    case NS_dff::LN_shpfCalloutMinusX:
    case NS_dff::LN_shpfCalloutMinusY:
    case NS_dff::LN_shpfCalloutDropAuto:
    case NS_dff::LN_shpfCalloutLengthSpecified:
    case NS_dff::LN_shpfEditedWrap:
    case NS_dff::LN_shpfBehindDocument:
    case NS_dff::LN_shpfOnDblClickNotify:
    case NS_dff::LN_shpfIsButton:
    case NS_dff::LN_shpfOneD:
    case NS_dff::LN_shpfHidden:
    case NS_dff::LN_shpfPrint:

      bResult = true;
      break;

    default:
        break;
    }
    
    return bResult;
}

}
