/**
 * \file QSpellcheckerDialog.C
 * This file is part of LyX, the document processor.
 * Licence details can be found in the file COPYING.
 *
 * \author John Levon
 *
 * Full author contact details are available in file CREDITS.
 */

#include <config.h>

#include "QSpellcheckerDialog.h"
#include "QSpellchecker.h"

#include <qcombobox.h>
#include <qlistbox.h>
#include <qpushbutton.h>

namespace lyx {
namespace frontend {

QSpellcheckerDialog::QSpellcheckerDialog(QSpellchecker * form)
	: QSpellcheckerDialogBase(0, 0, false, 0),
	form_(form)
{
	connect(closePB, SIGNAL(clicked()),
		form, SLOT(slotClose()));
}


void QSpellcheckerDialog::acceptClicked()
{
	form_->accept();
}


void QSpellcheckerDialog::addClicked()
{
	form_->add();
}


void QSpellcheckerDialog::replaceClicked()
{
	form_->replace();
}


void QSpellcheckerDialog::ignoreClicked()
{
	form_->ignore();
}


void QSpellcheckerDialog::suggestionChanged(const QString & str)
{
	if (replaceCO->count() != 0)
		replaceCO->changeItem(str, 0);
	else
		replaceCO->insertItem(str);

	replaceCO->setCurrentItem(0);
}


void QSpellcheckerDialog::replaceChanged(const QString & str)
{
	if (suggestionsLB->currentText() == str)
		return;

	unsigned int i = 0;
	for (; i < suggestionsLB->count(); ++i) {
		if (suggestionsLB->text(i) == str)
			break;
	}

	if (i != suggestionsLB->count())
		suggestionsLB->setCurrentItem(i);
}


void QSpellcheckerDialog::closeEvent(QCloseEvent * e)
{
	form_->slotWMHide();
	e->accept();
}


void QSpellcheckerDialog::reject()
{
	form_->slotWMHide();
	QSpellcheckerDialogBase::reject();
}

} // namespace frontend
} // namespace lyx
