/*
 * ldm_getenv_bool()
 * 
 * Handle boolean environment types.
 * (originally part of ldm.c)

 * Copyright Scott Balneaves, sbalneav@ltsp.org, 2007, 2008
 *     Ryan Niebur, RyanRyan52@gmail.com,       2008
 *     Vagrant Cascadian, vagrant@freegeek.org, 2008

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, you can find it on the World Wide
 * Web at http://www.gnu.org/copyleft/gpl.html, or write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301, USA.

 */

#include <stdlib.h>
#include <glib-object.h>

int
ldm_getenv_bool(const char *name)
{
    char *env = getenv(name);

    if (env)
        if (*env == 'y' || *env == 't' || *env == 'T' || *env == 'Y')
            return TRUE;

    return FALSE;
}

