/* zbuser.cc
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>
#include "zbuser.hh"

zbuser::zbuser (QString name, productList * pList, printInfo * prints,
		bool isCountdown, QTime elapsed)
{
  pInfo = prints;
  userName = name;
  prods = pList;
  startTime = QTime::currentTime ();
  usedTime = QTime (0, 0, 0);
  if (elapsed.toString ("hh:mm") != "00:00")
    {
      startTime.addSecs (0 - (elapsed.minute () * 60) +
			 (elapsed.hour () * 60 * 60));
      usedTime.setHMS (elapsed.hour (), elapsed.minute (), 0);
    }
  timer = new QTimer ();
  connect (timer, SIGNAL (timeout ()), this, SLOT (slotTimeout ()));
  running = false;
  priceTime = 0;
  priceItems = 0;
  countdown = isCountdown;
  elapsedTime = elapsed;
  colorPrint = 0;
  grayPrint = 0;
  emit updateUser();
}

zbuser::~zbuser ()
{
  emit updateUser();
}

void
zbuser::timeStart ()
{
  timer->start (60000, false);
  running = true;
}

void
zbuser::timePause ()
{
  timer->stop ();
}

void
zbuser::timeStop ()
{
  timer->stop ();
  running = false;
}

bool
zbuser::isOn ()
{
  return running;
}

QString
zbuser::name ()
{
  return userName;
}

QString
zbuser::tarif()
{
  return aktTarif->name;
}

void
zbuser::slotTimeout ()
{
  if (countdown == true)
    usedTime = usedTime.addSecs (0 - 60);
  else
    usedTime = usedTime.addSecs (60);
  emit timeChanged (usedTime);
  emit priceChanged (calcTarif () + priceItems);
  emit updateUser();
}

QString
zbuser::getTime()
{
  return usedTime.toString("hh:mm");
}

void
zbuser::setTarif (tarifInfo * tarif)
{
  aktTarif = tarif;
  // tarifStatus
  if (aktTarif->fullHour != 0 && aktTarif->halfHour == 0
      && aktTarif->quartHour == 0)
    tarifStatus = 1;
  else if (aktTarif->fullHour == 0 && aktTarif->halfHour != 0
	   && aktTarif->quartHour == 0)
    tarifStatus = 2;
  else if (aktTarif->fullHour == 0 && aktTarif->halfHour == 0
	   && aktTarif->quartHour != 0)
    tarifStatus = 3;
  else if (aktTarif->fullHour != 0 && aktTarif->halfHour != 0
	   && aktTarif->quartHour == 0)
    tarifStatus = 4;
  else if (aktTarif->fullHour == 0 && aktTarif->halfHour != 0
	   && aktTarif->quartHour != 0)
    tarifStatus = 5;
  else if (aktTarif->fullHour != 0 && aktTarif->halfHour == 0
	   && aktTarif->quartHour != 0)
    tarifStatus = 6;
  else if (aktTarif->fullHour != 0 && aktTarif->halfHour != 0
	   && aktTarif->quartHour != 0)
    tarifStatus = 7;
  // happyStatus
  if (aktTarif->happyFullHour != 0 && aktTarif->happyHalfHour == 0
      && aktTarif->happyQuartHour == 0)
    happyStatus = 1;
  else if (aktTarif->happyFullHour == 0 && aktTarif->happyHalfHour != 0
	   && aktTarif->happyQuartHour == 0)
    happyStatus = 2;
  else if (aktTarif->happyFullHour == 0 && aktTarif->happyHalfHour == 0
	   && aktTarif->happyQuartHour != 0)
    happyStatus = 3;
  else if (aktTarif->happyFullHour != 0 && aktTarif->happyHalfHour != 0
	   && aktTarif->happyQuartHour == 0)
    happyStatus = 4;
  else if (aktTarif->happyFullHour == 0 && aktTarif->happyHalfHour != 0
	   && aktTarif->happyQuartHour != 0)
    happyStatus = 5;
  else if (aktTarif->happyFullHour != 0 && aktTarif->happyHalfHour == 0
	   && aktTarif->happyQuartHour != 0)
    happyStatus = 6;
  else if (aktTarif->happyFullHour != 0 && aktTarif->happyHalfHour != 0
	   && aktTarif->happyQuartHour != 0)
    happyStatus = 7;
  if (priceTime == 0)
    priceTime = calcTarif ();
}

void
zbuser::updateTarif (tarifInfo * tarif)
{
  setTarif (tarif);
  emit priceChanged (calcTarif () + priceItems);
  emit timeChanged (usedTime);
  emit updateUser();
}

void
zbuser::addItem (int index, int count)
{
  if (count > 0)
    {
      userProdInfo pi;
      pi.index = index;
      pi.count = count;
      pi.zeit = QTime::currentTime ();
      usProdList.append (pi);
      priceItems += (*prods)[index].price;
      if (countdown == true)
	{
	  emit priceChanged (priceTime + priceItems);
	}
      else
	{
	  emit priceChanged (calcTarif () + priceItems);
	}
      emit updateUser();
    }
}

void
zbuser::addPrint (bool color, int count)
{
  if (color)
    {
      priceItems += pInfo->color * count;
      colorPrint+= count;
    }
  else
    {
      priceItems += pInfo->gray * count;
      grayPrint+=count;
    }
  if (countdown == true)
    {
      emit priceChanged (priceTime + priceItems);
    }
  else
    {
      emit priceChanged (calcTarif () + priceItems);
    }
  emit updateUser();
}

float
zbuser::getPrice()
{
  return priceTime;
}

float
zbuser::calcTarif ()
{
  QTime aktTime = usedTime;
  if (countdown == true)
    {
      aktTime = elapsedTime;
    }
  float test = 0;
  if (aktTarif->fullDayHours != test
      && aktTime.hour () >= aktTarif->fullDayHours)
    {
      //qDebug("voller tag");
      return aktTarif->fullDay;
    }

  QTime usTime = QTime (0, 0);
  QTime hpTime = QTime (0, 0);
  float price = 0;

  if (aktTarif->happyEnabled > 0)
    {
      //qDebug("mit happy hour");
      if (startTime < aktTarif->happyStart)
	{
	  //qDebug("hat vor der happy hour angefangen");
	  if (addTime (startTime, aktTime) < aktTarif->happyStart)
	    {
	      //qDebug("ist noch vor der happy hour");
	      usTime = aktTime;
	    }
	  else if (addTime (startTime, aktTime) >= aktTarif->happyStart
		   && addTime (startTime, aktTime) < aktTarif->happyStop)
	    {
	      //qDebug("ist in der happy hour");
	      usTime = subTime (aktTarif->happyStart, startTime);
	      hpTime = subTime (aktTime, usTime);
	    }
	  else
	    {
	      //qDebug("ist nach der happy hour");
	      hpTime = subTime (aktTarif->happyStop, aktTarif->happyStart);
	      usTime = subTime (aktTime, hpTime);
	    }
	}
      else if (startTime >= aktTarif->happyStart
	       && startTime < aktTarif->happyStop)
	{
	  //qDebug("hat in der happy hour angefangen");
	  if (QTime::currentTime () < aktTarif->happyStop)
	    {
	      //qDebug("ist in der happy hour");
	      hpTime = aktTime;
	    }
	  else
	    {
	      //qDebug("ist nach der happy hour");
	      usTime = subTime (QTime::currentTime (), aktTarif->happyStop);
	      hpTime = subTime (aktTime, usTime);
	    }
	}
      else
	{
	  //qDebug("hat nach der happy hour angefangen");
	  usTime = aktTime;
	}
    }
  else
    {
      usTime = aktTime;
    }
  switch (tarifStatus)
    {
    case 1:
      price += tarif_1 (usTime.hour (), usTime.minute ());
      break;
    case 2:
      price += tarif_2 (usTime.hour (), usTime.minute ());
      break;
    case 3:
      price += tarif_3 (usTime.hour (), usTime.minute ());
      break;
    case 4:
      price += tarif_4 (usTime.hour (), usTime.minute ());
      break;
    case 5:
      price += tarif_5 (usTime.hour (), usTime.minute ());
      break;
    case 6:
      price += tarif_6 (usTime.hour (), usTime.minute ());
      break;
    case 7:
      price += tarif_7 (usTime.hour (), usTime.minute ());
      break;
    }
  switch (happyStatus)
    {
    case 1:
      price += happy_1 (hpTime.hour (), hpTime.minute ());
      break;
    case 2:
      price += happy_2 (hpTime.hour (), hpTime.minute ());
      break;
    case 3:
      price += happy_3 (hpTime.hour (), hpTime.minute ());
      break;
    case 4:
      price += happy_4 (hpTime.hour (), hpTime.minute ());
      break;
    case 5:
      price += happy_5 (hpTime.hour (), hpTime.minute ());
      break;
    case 6:
      price += happy_6 (hpTime.hour (), hpTime.minute ());
      break;
    case 7:
      price += happy_7 (hpTime.hour (), hpTime.minute ());
      break;
    }
  return (price);
}

float
zbuser::tarif_1 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * aktTarif->fullHour;
  if (m >= vorlauf)
    p += aktTarif->fullHour;
  return (p);
}

float
zbuser::tarif_2 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * (2 * aktTarif->halfHour);
  if (m >= (vorlauf + 30))
    p += 2 * aktTarif->halfHour;
  else if (m >= vorlauf)
    p += aktTarif->halfHour;
  return (p);
}

float
zbuser::tarif_3 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * (4 * aktTarif->quartHour);
  if (m >= (vorlauf + 45))
    p += 4 * aktTarif->quartHour;
  else if (m >= (vorlauf + 30))
    p += 3 * aktTarif->quartHour;
  else if (m >= (vorlauf + 15))
    p += 2 * aktTarif->quartHour;
  else if (m >= vorlauf)
    p += aktTarif->quartHour;
  return (p);
}

float
zbuser::tarif_4 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * aktTarif->fullHour;
  if (m >= (vorlauf + 30))
    p += aktTarif->fullHour;
  else if (m >= vorlauf)
    p += aktTarif->halfHour;
  return (p);
}

float
zbuser::tarif_5 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * (2 * aktTarif->halfHour);
  if (m >= (vorlauf + 45))
    p += 2 * aktTarif->halfHour;
  else if (m >= (vorlauf + 30))
    p += aktTarif->halfHour + aktTarif->quartHour;
  else if (m >= (vorlauf + 15))
    p += aktTarif->halfHour;
  else if (m >= vorlauf)
    p += aktTarif->quartHour;
  return (p);
}

float
zbuser::tarif_6 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * aktTarif->fullHour;
  if (m >= (vorlauf + 45))
    p += aktTarif->fullHour;
  else if (m >= (vorlauf + 30))
    p += 3 * aktTarif->quartHour;
  else if (m >= (vorlauf + 15))
    p += 2 * aktTarif->quartHour;
  else if (m >= vorlauf)
    p += aktTarif->quartHour;
  return (p);
}

float
zbuser::tarif_7 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * aktTarif->fullHour;
  if (m >= (vorlauf + 45))
    p += aktTarif->fullHour;
  else if (m >= (vorlauf + 30))
    p += aktTarif->halfHour + aktTarif->quartHour;
  else if (m >= (vorlauf + 15))
    p += aktTarif->halfHour;
  else if (m >= vorlauf)
    p += aktTarif->quartHour;
  return (p);
}

float
zbuser::happy_1 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * aktTarif->happyFullHour;
  if (m >= vorlauf)
    p += aktTarif->happyFullHour;
  return (p);
}

float
zbuser::happy_2 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * (2 * aktTarif->happyHalfHour);
  if (m >= (vorlauf + 30))
    p += 2 * aktTarif->halfHour;
  else if (m >= vorlauf)
    p += aktTarif->happyHalfHour;
  return (p);
}

float
zbuser::happy_3 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * (4 * aktTarif->happyQuartHour);
  if (m >= (vorlauf + 45))
    p += 4 * aktTarif->happyQuartHour;
  else if (m >= (vorlauf + 30))
    p += 3 * aktTarif->happyQuartHour;
  else if (m >= (vorlauf + 15))
    p += 2 * aktTarif->happyQuartHour;
  else if (m >= vorlauf)
    p += aktTarif->happyQuartHour;
  return (p);
}

float
zbuser::happy_4 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * aktTarif->happyFullHour;
  if (m >= (vorlauf + 30))
    p += aktTarif->fullHour;
  else if (m >= vorlauf)
    p += aktTarif->happyHalfHour;
  return (p);
}

float
zbuser::happy_5 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * (2 * aktTarif->happyHalfHour);
  if (m >= (vorlauf + 45))
    p += 2 * aktTarif->happyHalfHour;
  else if (m >= (vorlauf + 30))
    p += aktTarif->happyHalfHour + aktTarif->happyQuartHour;
  else if (m >= (vorlauf + 15))
    p += aktTarif->happyHalfHour;
  else if (m >= vorlauf)
    p += aktTarif->happyQuartHour;
  return (p);
}

float
zbuser::happy_6 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * aktTarif->happyFullHour;
  if (m >= (vorlauf + 45))
    p += aktTarif->happyFullHour;
  else if (m >= (vorlauf + 30))
    p += 3 * aktTarif->happyQuartHour;
  else if (m >= (vorlauf + 15))
    p += 2 * aktTarif->happyQuartHour;
  else if (m >= vorlauf)
    p += aktTarif->happyQuartHour;
  return (p);
}

float
zbuser::happy_7 (int h, int m)
{
  int vorlauf = aktTarif->vorlauf;
  if (countdown == true)
    vorlauf = 1;
  float p = 0;
  p = h * aktTarif->happyFullHour;
  if (m >= (vorlauf + 45))
    p += aktTarif->happyFullHour;
  else if (m >= (vorlauf + 30))
    p += aktTarif->happyHalfHour + aktTarif->happyQuartHour;
  else if (m >= (vorlauf + 15))
    p += aktTarif->happyHalfHour;
  else if (m >= vorlauf)
    p += aktTarif->happyQuartHour;
  return (p);
}

QTime
zbuser::subTime (QTime time1, QTime time2)
{
  return time1.addSecs (0 - (time2.minute () * 60) +
			(time2.hour () * 60 * 60));
}

QTime
zbuser::addTime (QTime time1, QTime time2)
{
  return time1.addSecs ((time2.minute () * 60) + (time2.hour () * 60 * 60));
}
