/* cfg_tf.cc
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include "cfg_tf.hh"

cfg_tf::cfg_tf (QWidget * parent, tarifList * tf, groupList * gList, bool write, QString * cur):QWidget
  (parent)
{
  tarife = tf;
  groups = gList;
  CfgWrite = write;
  curency = cur;
  initView ();
  initData ();
  happyOff ();
}

cfg_tf::~cfg_tf ()
{
}

void
cfg_tf::initView ()
{
  tfGrid = new QGridLayout (this, 6, 3, 3, 3);
  // curency
  listWidget = new QWidget (this);
  listBox = new QVBoxLayout (listWidget);
  tfLbCur = new QLabel (listWidget);
  tfLbCur->setText (tr ("Curency"));
  listBox->addWidget (tfLbCur);
  tfEdCur = new QComboBox (true, listWidget);
  tfEdCur->insertItem ("EUR");
  tfEdCur->insertItem ("USD");
  if (*curency != "EUR" && *curency != "USD")
    tfEdCur->insertItem (*curency);
  tfEdCur->setCurrentText (*curency);
  listBox->addWidget (tfEdCur);
  connect (tfEdCur, SIGNAL (activated (int)), this,
	   SLOT (slotCurChanged (int)));
  connect (tfEdCur, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotCurChanged (const QString &)));
  // tarif list
  tfList = new QListBox (listWidget);
  listBox->addWidget (tfList);
  connect (tfList, SIGNAL (highlighted (int)), this,
	   SLOT (slotTfListSelected (int)));
  // normal settings
  tfGrp1 =
    new QGroupBox (100, Qt::Vertical, tr ("Normal Settings"), this,
		   "normalsettings");
  tfGrp1Widget = new QWidget (tfGrp1);
  tfGrid1 = new QGridLayout (tfGrp1Widget, 6, 7, 3, 3);
  // validator
  rxFloat = QRegExp ("\\d*\\.\\d{0,2}");
  vlFloat = new QRegExpValidator (rxFloat, 0);
  // tarif name
  tfLbName = new QLabel (tfGrp1Widget);
  tfLbName->setText (tr ("Name"));
  tfEdName = new QLineEdit (tfGrp1Widget);
  tfEdName->setEnabled (CfgWrite);
  connect (tfEdName, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotName (const QString &)));
  tfGrid1->addWidget (tfLbName, 0, 0);
  tfGrid1->addMultiCellWidget (tfEdName, 0, 0, 1, 2);
  // full hour
  tfLbFullHour = new QLabel (tfGrp1Widget);
  tfLbFullHour->setText (tr ("Full Hour"));
  tfEdFullHour = new QLineEdit (tfGrp1Widget);
  tfEdFullHour->setEnabled (CfgWrite);
  tfEdFullHour->setValidator (vlFloat);
  connect (tfEdFullHour, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotFullHour (const QString &)));
  tfCur1 = new QLabel (tfGrp1Widget);
  tfCur1->setText (*curency);
  tfGrid1->addWidget (tfLbFullHour, 1, 0);
  tfGrid1->addWidget (tfEdFullHour, 1, 1);
  tfGrid1->addWidget (tfCur1, 1, 2);
  // half hour
  tfLbHalfHour = new QLabel (tfGrp1Widget);
  tfLbHalfHour->setText (tr ("Half Hour"));
  tfEdHalfHour = new QLineEdit (tfGrp1Widget);
  tfEdHalfHour->setEnabled (CfgWrite);
  tfEdHalfHour->setValidator (vlFloat);
  connect (tfEdHalfHour, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotHalfHour (const QString &)));
  tfCur2 = new QLabel (tfGrp1Widget);
  tfCur2->setText (*curency);
  tfGrid1->addWidget (tfLbHalfHour, 2, 0);
  tfGrid1->addWidget (tfEdHalfHour, 2, 1);
  tfGrid1->addWidget (tfCur2, 2, 2);
  // quart hour
  tfLbQuartHour = new QLabel (tfGrp1Widget);
  tfLbQuartHour->setText (tr ("Quarter Hour"));
  tfEdQuartHour = new QLineEdit (tfGrp1Widget);
  tfEdQuartHour->setEnabled (CfgWrite);
  tfEdQuartHour->setValidator (vlFloat);
  connect (tfEdQuartHour, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotQuartHour (const QString &)));
  tfCur3 = new QLabel (tfGrp1Widget);
  tfCur3->setText (*curency);
  tfGrid1->addWidget (tfLbQuartHour, 3, 0);
  tfGrid1->addWidget (tfEdQuartHour, 3, 1);
  tfGrid1->addWidget (tfCur3, 3, 2);
  // full day
  tfLbFullDay = new QLabel (tfGrp1Widget);
  tfLbFullDay->setText (tr ("Full day"));
  tfEdFullDay = new QLineEdit (tfGrp1Widget);
  tfEdFullDay->setEnabled (CfgWrite);
  tfEdFullDay->setValidator (vlFloat);
  connect (tfEdFullDay, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotFullDay (const QString &)));
  tfCur4 = new QLabel (tfGrp1Widget);
  tfCur4->setText (*curency);
  tfGrid1->addWidget (tfLbFullDay, 4, 0);
  tfGrid1->addWidget (tfEdFullDay, 4, 1);
  tfGrid1->addWidget (tfCur4, 4, 2);
  // half day
  tfLbHalfDay = new QLabel (tfGrp1Widget);
  tfLbHalfDay->setText (tr ("Half day"));
  tfEdHalfDay = new QLineEdit (tfGrp1Widget);
  tfEdHalfDay->setEnabled (false);
  //TODO
  tfEdHalfDay->setValidator (vlFloat);
  connect (tfEdHalfDay, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotHalfDay (const QString &)));
  tfCur5 = new QLabel (tfGrp1Widget);
  tfCur5->setText (*curency);
  tfGrid1->addWidget (tfLbHalfDay, 5, 0);
  tfGrid1->addWidget (tfEdHalfDay, 5, 1);
  tfGrid1->addWidget (tfCur5, 5, 2);
  // spacer
  tfSpacer1 =
    new QSpacerItem (30, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
  tfGrid1->addItem (tfSpacer1, 0, 3);
  // tax
  tfLbTax = new QLabel (tfGrp1Widget);
  tfLbTax->setText (tr ("Tax"));
  tfEdTax = new QLineEdit (tfGrp1Widget);
  tfEdTax->setEnabled (CfgWrite);
  tfEdTax->setValidator (vlFloat);
  connect (tfEdTax, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotTax (const QString &)));
  tfTaxCur = new QLabel (tfGrp1Widget);
  tfTaxCur->setText ("%");
  tfGrid1->addWidget (tfLbTax, 1, 4);
  tfGrid1->addWidget (tfEdTax, 1, 5);
  tfGrid1->addWidget (tfTaxCur, 1, 6);
  // vorlauf
  tfLbVorlauf = new QLabel (tfGrp1Widget);
  tfLbVorlauf->setText (tr ("Vorlauf"));
  tfEdVorlauf = new QSpinBox (tfGrp1Widget);
  tfEdVorlauf->setEnabled (CfgWrite);
  connect (tfEdVorlauf, SIGNAL (valueChanged (int)), this,
	   SLOT (slotVorlauf (int)));
  tfVorlCur = new QLabel (tfGrp1Widget);
  tfVorlCur->setText (tr ("min"));
  tfGrid1->addWidget (tfLbVorlauf, 2, 4);
  tfGrid1->addWidget (tfEdVorlauf, 2, 5);
  tfGrid1->addWidget (tfVorlCur, 2, 6);
  // happy enabled
  tfEdHappyEnabled = new QCheckBox (tfGrp1Widget);
  tfEdHappyEnabled->setText (tr ("Happy Hour enabled"));
  tfEdHappyEnabled->setEnabled (CfgWrite);
  connect (tfEdHappyEnabled, SIGNAL (toggled (bool)), this,
	   SLOT (slotHappyEnabled (bool)));
  tfGrid1->addMultiCellWidget (tfEdHappyEnabled, 3, 3, 4, 6);
  // full day hours
  tfLbFullDayHours = new QLabel (tfGrp1Widget);
  tfLbFullDayHours->setText (tr ("for"));
  tfEdFullDayHours = new QSpinBox (tfGrp1Widget);
  tfEdFullDayHours->setEnabled (CfgWrite);
  connect (tfEdFullDayHours, SIGNAL (valueChanged (const QString &)), this,
	   SLOT (slotFullDay (const QString &)));
  tfLbFullDayHours2 = new QLabel (tfGrp1Widget);
  tfLbFullDayHours2->setText (tr ("Hours"));
  tfGrid1->addWidget (tfLbFullDayHours, 4, 4);
  tfGrid1->addWidget (tfEdFullDayHours, 4, 5);
  tfGrid1->addWidget (tfLbFullDayHours2, 4, 6);
  // half day hours
  tfLbHalfDayHours = new QLabel (tfGrp1Widget);
  tfLbHalfDayHours->setText (tr ("for"));
  tfEdHalfDayHours = new QSpinBox (tfGrp1Widget);
  tfEdHalfDayHours->setEnabled (CfgWrite);
  connect (tfEdHalfDayHours, SIGNAL (valueChanged (const QString &)), this,
	   SLOT (slotHalfDay (const QString &)));
  tfLbHalfDayHours2 = new QLabel (tfGrp1Widget);
  tfLbHalfDayHours2->setText (tr ("Hours"));
  tfGrid1->addWidget (tfLbHalfDayHours, 5, 4);
  tfGrid1->addWidget (tfEdHalfDayHours, 5, 5);
  tfGrid1->addWidget (tfLbHalfDayHours2, 5, 6);


  // happy hour settings
  tfGrp2 =
    new QGroupBox (100, Qt::Vertical, tr ("Happy Hour Settings"), this,
		   "happysettings");
  tfGrp2Widget = new QWidget (tfGrp2);
  tfGrid2 = new QGridLayout (tfGrp2Widget, 5, 6, 3, 3);
  // happy full hour
  tfLbHappyFullHour = new QLabel (tfGrp2Widget);
  tfLbHappyFullHour->setText (tr ("Full Hour"));
  tfEdHappyFullHour = new QLineEdit (tfGrp2Widget);
  tfEdHappyFullHour->setEnabled (CfgWrite);
  tfEdHappyFullHour->setValidator (vlFloat);
  connect (tfEdHappyFullHour, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotHappyFullHour (const QString &)));
  tfCur6 = new QLabel (tfGrp2Widget);
  tfCur6->setText (*curency);
  tfGrid2->addWidget (tfLbHappyFullHour, 0, 0);
  tfGrid2->addWidget (tfEdHappyFullHour, 0, 1);
  tfGrid2->addWidget (tfCur6, 0, 2);
  // happy half hour
  tfLbHappyHalfHour = new QLabel (tfGrp2Widget);
  tfLbHappyHalfHour->setText (tr ("Half Hour"));
  tfEdHappyHalfHour = new QLineEdit (tfGrp2Widget);
  tfEdHappyHalfHour->setEnabled (CfgWrite);
  tfEdHappyHalfHour->setValidator (vlFloat);
  connect (tfEdHappyHalfHour, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotHappyHalfHour (const QString &)));
  tfCur7 = new QLabel (tfGrp2Widget);
  tfCur7->setText (*curency);
  tfGrid2->addWidget (tfLbHappyHalfHour, 1, 0);
  tfGrid2->addWidget (tfEdHappyHalfHour, 1, 1);
  tfGrid2->addWidget (tfCur7, 1, 2);
  // happy quart hour
  tfLbHappyQuartHour = new QLabel (tfGrp2Widget);
  tfLbHappyQuartHour->setText (tr ("Quarter Hour"));
  tfEdHappyQuartHour = new QLineEdit (tfGrp2Widget);
  tfEdHappyQuartHour->setEnabled (CfgWrite);
  tfEdHappyQuartHour->setValidator (vlFloat);
  connect (tfEdHappyQuartHour, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotHappyQuartHour (const QString &)));
  tfCur8 = new QLabel (tfGrp2Widget);
  tfCur8->setText (*curency);
  tfGrid2->addWidget (tfLbHappyQuartHour, 2, 0);
  tfGrid2->addWidget (tfEdHappyQuartHour, 2, 1);
  tfGrid2->addWidget (tfCur8, 2, 2);
  // happy hour start
  tfLbHappyStart = new QLabel (tfGrp2Widget);
  tfLbHappyStart->setText (tr ("Start"));
  tfEdHappyStart = new QTimeEdit (tfGrp2Widget);
  tfEdHappyStart->setEnabled (CfgWrite);
  connect (tfEdHappyStart, SIGNAL (valueChanged (const QTime &)), this,
	   SLOT (slotHappyStart (const QTime &)));
  tfGrid2->addWidget (tfLbHappyStart, 3, 0);
  tfGrid2->addMultiCellWidget (tfEdHappyStart, 3, 3, 1, 2);
  // happy hour stop
  tfLbHappyStop = new QLabel (tfGrp2Widget);
  tfLbHappyStop->setText (tr ("Stop"));
  tfEdHappyStop = new QTimeEdit (tfGrp2Widget);
  tfEdHappyStop->setEnabled (CfgWrite);
  connect (tfEdHappyStop, SIGNAL (valueChanged (const QTime &)), this,
	   SLOT (slotHappyStop (const QTime &)));
  tfGrid2->addWidget (tfLbHappyStop, 4, 0);
  tfGrid2->addMultiCellWidget (tfEdHappyStop, 4, 4, 1, 2);
  // spacer
  tfSpacer2 =
    new QSpacerItem (0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
  tfGrid2->addItem (tfSpacer2, 0, 3);
  // days
  tfDayMo = new QCheckBox (tfGrp2Widget);
  tfDayMo->setText (tr ("Mo"));
  tfDayMo->setEnabled (CfgWrite);
  connect (tfDayMo, SIGNAL (toggled (bool)), this, SLOT (slotDayMo (bool)));
  tfGrid2->addWidget (tfDayMo, 0, 4);
  tfDayDi = new QCheckBox (tfGrp2Widget);
  tfDayDi->setText (tr ("Tu"));
  tfDayDi->setEnabled (CfgWrite);
  connect (tfDayDi, SIGNAL (toggled (bool)), this, SLOT (slotDayDi (bool)));
  tfGrid2->addWidget (tfDayDi, 1, 4);
  tfDayMi = new QCheckBox (tfGrp2Widget);
  tfDayMi->setText (tr ("We"));
  tfDayMi->setEnabled (CfgWrite);
  connect (tfDayMi, SIGNAL (toggled (bool)), this, SLOT (slotDayMi (bool)));
  tfGrid2->addWidget (tfDayMi, 2, 4);
  tfDayDo = new QCheckBox (tfGrp2Widget);
  tfDayDo->setText (tr ("Th"));
  tfDayDo->setEnabled (CfgWrite);
  connect (tfDayDo, SIGNAL (toggled (bool)), this, SLOT (slotDayDo (bool)));
  tfGrid2->addWidget (tfDayDo, 3, 4);
  tfDayFr = new QCheckBox (tfGrp2Widget);
  tfDayFr->setText (tr ("Fr"));
  tfDayFr->setEnabled (CfgWrite);
  connect (tfDayFr, SIGNAL (toggled (bool)), this, SLOT (slotDayFr (bool)));
  tfGrid2->addWidget (tfDayFr, 4, 4);
  tfDaySa = new QCheckBox (tfGrp2Widget);
  tfDaySa->setText (tr ("Sa"));
  tfDaySa->setEnabled (CfgWrite);
  connect (tfDaySa, SIGNAL (toggled (bool)), this, SLOT (slotDaySa (bool)));
  tfGrid2->addWidget (tfDaySa, 0, 5);
  tfDaySo = new QCheckBox (tfGrp2Widget);
  tfDaySo->setText (tr ("So"));
  tfDaySo->setEnabled (CfgWrite);
  connect (tfDaySo, SIGNAL (toggled (bool)), this, SLOT (slotDaySo (bool)));
  tfGrid2->addWidget (tfDaySo, 1, 5);
  // buttons
  tfBtnBox = new QHBoxLayout (0, 0, 3, "buttons");
  tfBtnNew = new QPushButton (this);
  tfBtnNew->setText (tr ("New"));
  tfBtnNew->setEnabled (true);
  connect (tfBtnNew, SIGNAL (clicked ()), this, SLOT (slotTfBtnNew ()));
  tfBtnBox->addWidget (tfBtnNew);
  tfBtnSave = new QPushButton (this);
  tfBtnSave->setText (tr ("Save"));
  tfBtnSave->setEnabled (CfgWrite);
  connect (tfBtnSave, SIGNAL (clicked ()), this, SLOT (slotTfBtnSave ()));
  tfBtnBox->addWidget (tfBtnSave);
  tfBtnSpace =
    new QSpacerItem (0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
  tfBtnBox->addItem (tfBtnSpace);
  tfBtnDel = new QPushButton (this);
  tfBtnDel->setText (tr ("Delete"));
  tfBtnDel->setEnabled (CfgWrite);
  connect (tfBtnDel, SIGNAL (clicked ()), this, SLOT (slotTfBtnDel ()));
  tfBtnBox->addWidget (tfBtnDel);
  // end
  tfGrid->addMultiCellWidget (listWidget, 0, 4, 0, 0);
  tfGrid->addMultiCellWidget (tfGrp1, 0, 2, 1, 1);
  tfGrid->addWidget (tfGrp2, 3, 1);
  tfGrid->addLayout (tfBtnBox, 4, 1);
  // spacer
  tfSpacer3 =
    new QSpacerItem (0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
  tfSpacer4 =
    new QSpacerItem (0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
  tfGrid->addItem (tfSpacer3, 0, 2);
  tfGrid->addItem (tfSpacer4, 3, 0);
}

void
cfg_tf::initData ()
{
  clear ();
  tfList->clear ();
  for (tarifList::iterator it = tarife->begin (); it != tarife->end (); ++it)
    tfList->insertItem ((*it).name);
}

void
cfg_tf::setEnabled (bool write)
{
  if (CfgWrite == write)
    return;
  CfgWrite = write;
  tfEdCur->setEnabled (CfgWrite);
  tfEdName->setEnabled (CfgWrite);
  tfEdFullHour->setEnabled (CfgWrite);
  tfEdHalfHour->setEnabled (CfgWrite);
  tfEdQuartHour->setEnabled (CfgWrite);
  tfEdFullDay->setEnabled (CfgWrite);
  tfEdHalfDay->setEnabled (false);
  tfEdTax->setEnabled (CfgWrite);
  tfEdVorlauf->setEnabled (CfgWrite);
  tfEdFullDayHours->setEnabled (CfgWrite);
  tfEdHalfDayHours->setEnabled (CfgWrite);
  tfEdHappyEnabled->setEnabled (CfgWrite);
  if (tfEdHappyEnabled->isChecked ())
    {
      tfEdHappyFullHour->setEnabled (CfgWrite);
      tfEdHappyHalfHour->setEnabled (CfgWrite);
      tfEdHappyQuartHour->setEnabled (CfgWrite);
      tfEdHappyStart->setEnabled (CfgWrite);
      tfEdHappyStop->setEnabled (CfgWrite);
      tfDayMo->setEnabled (CfgWrite);
      tfDayDi->setEnabled (CfgWrite);
      tfDayMi->setEnabled (CfgWrite);
      tfDayDo->setEnabled (CfgWrite);
      tfDayFr->setEnabled (CfgWrite);
      tfDaySa->setEnabled (CfgWrite);
      tfDaySo->setEnabled (CfgWrite);
    }
  else
    {
      tfEdHappyFullHour->setEnabled (false);
      tfEdHappyHalfHour->setEnabled (false);
      tfEdHappyQuartHour->setEnabled (false);
      tfEdHappyStart->setEnabled (false);
      tfEdHappyStop->setEnabled (false);
      tfDayMo->setEnabled (false);
      tfDayDi->setEnabled (false);
      tfDayMi->setEnabled (false);
      tfDayDo->setEnabled (false);
      tfDayFr->setEnabled (false);
      tfDaySa->setEnabled (false);
      tfDaySo->setEnabled (false);
    }
}

void
cfg_tf::clear ()
{
  tfEdFullHour->clear ();
  tfEdFullHour->setEnabled (CfgWrite);
  tfEdHalfHour->clear ();
  tfEdHalfHour->setEnabled (CfgWrite);
  tfEdQuartHour->clear ();
  tfEdQuartHour->setEnabled (CfgWrite);
  tfEdFullDay->clear ();
  tfEdFullDay->setEnabled (CfgWrite);
  tfEdHalfDay->clear ();
  tfEdHalfDay->setEnabled (false);
  tfEdTax->clear ();
  tfEdTax->setEnabled (CfgWrite);
  tfEdVorlauf->setValue (0);
  tfEdVorlauf->setEnabled (CfgWrite);
  tfEdHappyEnabled->setChecked (false);
  tfEdHappyEnabled->setEnabled (CfgWrite);
  tfEdFullDayHours->setValue (0);
  tfEdFullDayHours->setEnabled (CfgWrite);
  tfEdHalfDayHours->setValue (0);
  tfEdHalfDayHours->setEnabled (CfgWrite);
  tfEdHappyFullHour->clear ();
  tfEdHappyFullHour->setEnabled (false);
  tfEdHappyHalfHour->clear ();
  tfEdHappyHalfHour->setEnabled (false);
  tfEdHappyQuartHour->clear ();
  tfEdHappyQuartHour->setEnabled (false);
  tfEdHappyStart->setTime (QTime (0, 0, 0));
  tfEdHappyStart->setEnabled (false);
  tfEdHappyStop->setTime (QTime (0, 0, 0));
  tfEdHappyStop->setEnabled (false);
  tfDayMo->setChecked (false);
  tfDayMo->setEnabled (false);
  tfDayDi->setChecked (false);
  tfDayDi->setEnabled (false);
  tfDayMi->setChecked (false);
  tfDayMi->setEnabled (false);
  tfDayDo->setChecked (false);
  tfDayDo->setEnabled (false);
  tfDayFr->setChecked (false);
  tfDayFr->setEnabled (false);
  tfDaySa->setChecked (false);
  tfDaySa->setEnabled (false);
  tfDaySo->setChecked (false);
  tfDaySo->setEnabled (false);
}

void
cfg_tf::happyOff ()
{
  tfEdHappyEnabled->setChecked (false);
  tfEdHappyFullHour->clear ();
  tfEdHappyFullHour->setEnabled (false);
  tfEdHappyHalfHour->clear ();
  tfEdHappyHalfHour->setEnabled (false);
  tfEdHappyQuartHour->clear ();
  tfEdHappyQuartHour->setEnabled (false);
  tfEdHappyStart->setTime (QTime (0, 0, 0));
  tfEdHappyStart->setEnabled (false);
  tfEdHappyStop->setTime (QTime (0, 0, 0));
  tfEdHappyStop->setEnabled (false);
  tfDayMo->setChecked (false);
  tfDayMo->setEnabled (false);
  tfDayDi->setChecked (false);
  tfDayDi->setEnabled (false);
  tfDayMi->setChecked (false);
  tfDayMi->setEnabled (false);
  tfDayDo->setChecked (false);
  tfDayDo->setEnabled (false);
  tfDayFr->setChecked (false);
  tfDayFr->setEnabled (false);
  tfDaySa->setChecked (false);
  tfDaySa->setEnabled (false);
  tfDaySo->setChecked (false);
  tfDaySo->setEnabled (false);
}

void
cfg_tf::happyOn (int i)
{
  QString buf;
  buf.setNum ((*tarife)[i].happyFullHour);
  tfEdHappyFullHour->setText (buf);
  tfEdHappyFullHour->setEnabled (CfgWrite);
  buf.setNum ((*tarife)[i].happyHalfHour);
  tfEdHappyHalfHour->setText (buf);
  tfEdHappyHalfHour->setEnabled (CfgWrite);
  buf.setNum ((*tarife)[i].happyQuartHour);
  tfEdHappyQuartHour->setText (buf);
  tfEdHappyQuartHour->setEnabled (CfgWrite);
  tfDayMo->setChecked (false);
  if ((*tarife)[i].day[0] > 0)
    tfDayMo->setChecked (CfgWrite);
  tfDayMo->setEnabled (CfgWrite);
  tfDayDi->setChecked (false);
  if ((*tarife)[i].day[1] > 0)
    tfDayDi->setChecked (true);
  tfDayDi->setEnabled (CfgWrite);
  tfDayMi->setChecked (false);
  if ((*tarife)[i].day[2] > 0)
    tfDayMi->setChecked (true);
  tfDayMi->setEnabled (CfgWrite);
  tfDayDo->setChecked (false);
  if ((*tarife)[i].day[3] > 0)
    tfDayDo->setChecked (true);
  tfDayDo->setEnabled (CfgWrite);
  tfDayFr->setChecked (false);
  if ((*tarife)[i].day[4] > 0)
    tfDayFr->setChecked (true);
  tfDayFr->setEnabled (CfgWrite);
  tfDaySa->setChecked (false);
  if ((*tarife)[i].day[5] > 0)
    tfDaySa->setChecked (true);
  tfDaySa->setEnabled (CfgWrite);
  tfDaySo->setChecked (false);
  if ((*tarife)[i].day[6] > 0)
    tfDaySo->setChecked (true);
  tfDaySo->setEnabled (CfgWrite);
  tfEdHappyStart->setTime ((*tarife)[i].happyStart);
  tfEdHappyStart->setEnabled (CfgWrite);
  tfEdHappyStop->setTime ((*tarife)[i].happyStop);
  tfEdHappyStop->setEnabled (CfgWrite);
  tfEdHappyEnabled->setChecked (true);
}

void
cfg_tf::slotTfListSelected (int i)
{
  QString buf;
  currentItem = i;
  tfEdName->setText ((*tarife)[i].name);
  buf.setNum ((*tarife)[i].fullHour);
  tfEdFullHour->setText (buf);
  buf.setNum ((*tarife)[i].halfHour);
  tfEdHalfHour->setText (buf);
  buf.setNum ((*tarife)[i].quartHour);
  tfEdQuartHour->setText (buf);
  buf.setNum ((*tarife)[i].fullDay);
  tfEdFullDay->setText (buf);
  buf.setNum ((*tarife)[i].halfDay);
  tfEdHalfDay->setText (buf);
  buf.setNum ((*tarife)[i].tax);
  tfEdTax->setText (buf);
  tfEdVorlauf->setValue ((*tarife)[i].vorlauf);
  tfEdFullDayHours->setValue ((*tarife)[i].fullDayHours);
  tfEdHalfDayHours->setValue ((*tarife)[i].halfDayHours);
  if ((*tarife)[i].happyEnabled > 0)
    {
      happyOn (i);
    }
  else
    {
      happyOff ();
    }
}

void
cfg_tf::slotTfBtnNew ()
{
  currentItem = -1;
  tfList->clearSelection ();
  clear ();
}

void
cfg_tf::slotTfBtnSave ()
{
  tarifInfo t;
  QString msg;
  t.name = tfEdName->text ();
  t.fullHour = tfEdFullHour->text ().toFloat ();
  t.halfHour = tfEdHalfHour->text ().toFloat ();
  t.quartHour = tfEdQuartHour->text ().toFloat ();
  if (t.fullHour == 0 && t.halfHour == 0 && t.quartHour == 0)
    {
      msg = tr ("You have set any prices to 0? Are you sure?");
      QMessageBox::information (this, tr ("Warning"), msg);
      return;
    }
  t.fullDay = tfEdFullDay->text ().toFloat ();
  t.halfDay = tfEdHalfDay->text ().toFloat ();
  t.fullDayHours = tfEdFullDayHours->value ();
  t.halfDayHours = tfEdHalfDayHours->value ();
  t.tax = tfEdTax->text ().toFloat ();
  t.vorlauf = tfEdVorlauf->value ();
  if (tfEdHappyEnabled->isChecked ())
    {
      // mit happy
      t.happyEnabled = 1;
      t.happyFullHour = tfEdHappyFullHour->text ().toFloat ();
      t.happyHalfHour = tfEdHappyHalfHour->text ().toFloat ();
      t.happyQuartHour = tfEdHappyQuartHour->text ().toFloat ();
      if (t.happyFullHour == 0 && t.happyHalfHour == 0
	  && t.happyQuartHour == 0)
	{
	  msg =
	    tr
	    ("The price for the Happy Hour seems o be 0. if you dont want to use this feature, please uncheck the box 'Happy Hour Enabled'.");
	  QMessageBox::information (this, tr ("Warning"), msg);
	  return;
	}
      QTime tme = tfEdHappyStart->time ();
      t.happyStart = QTime (tme.hour (), tme.minute (), 0);
      tme = tfEdHappyStop->time ();
      t.happyStop = QTime (tme.hour (), tme.minute (), 0);
      if (t.happyStart == t.happyStop)
	{
	  msg =
	    tr
	    ("The start and the end time for the happy hour are the same. If you dont want to use the Happy Hour, please uncheck the box 'Happy Hour Enabled'");
	  QMessageBox::information (this, tr ("Warning"), msg);
	  return;
	}
      t.day[0] = t.day[1] = t.day[2] = t.day[3] = t.day[4] = t.day[5] =
	t.day[6] = 0;
      if (tfDayMo->isChecked ())
	t.day[0] = 1;
      if (tfDayDi->isChecked ())
	t.day[1] = 1;
      if (tfDayMi->isChecked ())
	t.day[2] = 1;
      if (tfDayDo->isChecked ())
	t.day[3] = 1;
      if (tfDayFr->isChecked ())
	t.day[4] = 1;
      if (tfDaySa->isChecked ())
	t.day[5] = 1;
      if (tfDaySo->isChecked ())
	t.day[6] = 1;
      if (t.day[0] == t.day[1] == t.day[2] == t.day[3] == t.day[4] ==
	  t.day[5] == t.day[6] == 0)
	{
	  msg =
	    tr
	    ("You have set the Happy Hour is active on 0 days? If you dont want to use the Happy Hour, please uncheck the box 'Happy Hour enabled'.");
	  QMessageBox::information (this, tr ("Warning"), msg);
	  return;
	}
    }
  else
    {
      // ohne happy
      float test = 0;
      t.happyEnabled = 0;
      t.happyFullHour = t.happyHalfHour = t.happyQuartHour = test;
      t.happyStart = t.happyStop = QTime (0, 0, 0);
      t.day[0] = t.day[1] = t.day[2] = t.day[3] = t.day[4] = t.day[5] =
	t.day[6] = 0;
    }
  if (tfList->currentItem () < 0)
    {
      // neuer tarif
      tarife->append (t);
    }
  else
    {
      // tarif gendert
      for (tarifList::iterator ti = tarife->begin (); ti != tarife->end ();
	   ++ti)
	if ((*ti).name == tfList->currentText ())
	  (*ti) = t;
    }
  initData ();
  emit configChanged ();
}

void
cfg_tf::slotTfBtnDel ()
{
  bool found = false;
  compList::iterator ci;
  for (groupList::iterator gi = groups->begin (); gi != groups->end (); ++gi)
    {
      for (ci = (*gi).comp.begin (); ci != (*gi).comp.end (); ++ci)
	if ((*ci).view->tarif () == tfList->currentText ())
	  {
	    // warning
	    QString msg = tr ("This tarif is curently at the computer ")
	      + (*ci).view->title ()
	      + tr (" in use. Please chose for this computer an other tarif")
	      + tr (" an then try again.");
	    QMessageBox::information (this, tr ("Warning"), msg);
	    found = true;
	    break;
	  }
      if (found)
	break;
    }
  if (!found)
    {
      for (tarifList::iterator ti = tarife->begin (); ti != tarife->end ();
	   ++ti)
	{
	  if ((*ti).name == tfList->currentText ())
	    {
	      tarife->remove (ti);
	      break;
	    }
	}
    }
}

void
cfg_tf::slotCurChanged (int i)
{
  if (i < 0)
    return;
  QString cur = tfEdCur->currentText ();
  tfCur1->setText (cur);
  tfCur2->setText (cur);
  tfCur3->setText (cur);
  tfCur4->setText (cur);
  tfCur5->setText (cur);
  tfCur6->setText (cur);
  tfCur7->setText (cur);
  tfCur8->setText (cur);
  emit curencyChanged (cur);
  emit configChanged ();
}

void
cfg_tf::slotCurChanged (const QString & s)
{
  if (s.isNull ())
    return;
  QString cur = s;
  tfCur1->setText (cur);
  tfCur2->setText (cur);
  tfCur3->setText (cur);
  tfCur4->setText (cur);
  tfCur5->setText (cur);
  tfCur6->setText (cur);
  tfCur7->setText (cur);
  tfCur8->setText (cur);
  emit curencyChanged (cur);
  emit configChanged ();
}

void
cfg_tf::slotName (const QString & s)
{
  if (currentItem < 0 || (*tarife)[currentItem].name != s)
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotFullHour (const QString & s)
{
  if (currentItem < 0 || (*tarife)[currentItem].fullHour != s.toFloat ())
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotHalfHour (const QString & s)
{
  if (currentItem < 0 || (*tarife)[currentItem].halfHour != s.toFloat ())
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotQuartHour (const QString & s)
{
  if (currentItem < 0 || (*tarife)[currentItem].quartHour != s.toFloat ())
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotFullDay (const QString & s)
{
  if (currentItem < 0 || (*tarife)[currentItem].fullDay != s.toFloat ())
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotHalfDay (const QString & s)
{
  if (currentItem < 0 || (*tarife)[currentItem].halfDay != s.toFloat ())
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotFullDayHours (int i)
{
  unsigned int test = 0;
  if (currentItem < test || (*tarife)[currentItem].fullDayHours != i)
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotHalfDayHours (int i)
{
  unsigned int test = 0;
  if (currentItem < test || (*tarife)[currentItem].halfDayHours != i)
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotHappyEnabled (bool on)
{
  if (on == true)
    {
      if (currentItem < 0 || (*tarife)[currentItem].happyEnabled == 0)
	{
	  tfBtnSave->setEnabled (CfgWrite);
	}
      happyOn (currentItem);
    }
  else
    {
      if (currentItem < 0 || (*tarife)[currentItem].happyEnabled == 1)
	{
	  tfBtnSave->setEnabled (CfgWrite);
	}
      happyOff ();
    }
}

void
cfg_tf::slotTax (const QString & s)
{
  if (currentItem < 0 || (*tarife)[currentItem].tax != s.toFloat ())
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotVorlauf (int i)
{
  if (currentItem < 0 || (*tarife)[currentItem].vorlauf != i)
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotHappyFullHour (const QString & s)
{
  if (currentItem < 0 || (*tarife)[currentItem].happyFullHour != s.toFloat ())
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotHappyHalfHour (const QString & s)
{
  if (currentItem < 0 || (*tarife)[currentItem].happyHalfHour != s.toFloat ())
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotHappyQuartHour (const QString & s)
{
  if (currentItem < 0
      || (*tarife)[currentItem].happyQuartHour != s.toFloat ())
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotHappyStart (const QTime & t)
{
  if (currentItem < 0 || (*tarife)[currentItem].happyStart != t)
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotHappyStop (const QTime & t)
{
  if (currentItem < 0 || (*tarife)[currentItem].happyStop != t)
    tfBtnSave->setEnabled (CfgWrite);
}

void
cfg_tf::slotDayMo (bool on)
{
  if (on == true)
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[0] == 0)
	tfBtnSave->setEnabled (CfgWrite);
    }
  else
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[0] == 1)
	tfBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_tf::slotDayDi (bool on)
{
  if (on == true)
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[1] == 0)
	tfBtnSave->setEnabled (CfgWrite);
    }
  else
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[1] == 1)
	tfBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_tf::slotDayMi (bool on)
{
  if (on == true)
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[2] == 0)
	tfBtnSave->setEnabled (CfgWrite);
    }
  else
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[2] == 1)
	tfBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_tf::slotDayDo (bool on)
{
  if (on == true)
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[3] == 0)
	tfBtnSave->setEnabled (CfgWrite);
    }
  else
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[3] == 1)
	tfBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_tf::slotDayFr (bool on)
{
  if (on == true)
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[4] == 0)
	tfBtnSave->setEnabled (CfgWrite);
    }
  else
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[4] == 1)
	tfBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_tf::slotDaySa (bool on)
{
  if (on == true)
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[5] == 0)
	tfBtnSave->setEnabled (CfgWrite);
    }
  else
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[5] == 1)
	tfBtnSave->setEnabled (CfgWrite);
    }
}

void
cfg_tf::slotDaySo (bool on)
{
  if (on == true)
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[6] == 0)
	tfBtnSave->setEnabled (CfgWrite);
    }
  else
    {
      if (currentItem < 0 || (*tarife)[currentItem].day[6] == 1)
	tfBtnSave->setEnabled (CfgWrite);
    }
}
