/* cfg_cli.hh
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFG_CLI_H
#define CFG_CLI_H
#include <stdio.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qmultilineedit.h>
#include <qlistbox.h>
#include <qspinbox.h>
#include <qmessagebox.h>
#include <qtabwidget.h>
#include <qcombobox.h>
#include <qgrid.h>
#include "ipinput.hh"
#include "zbuser.hh"
#include "zbconfig.hh"

class cfg_cli:public QWidget
{
Q_OBJECT public:
    cfg_cli (QWidget * parent, groupList * gList, bool write,
	     QTabWidget * tabWv);
   ~cfg_cli ();
  void setEnabled (bool write);
  void setData(tarifList *tf,productList *pl,printInfo *pi, QString cur);
private:			// private funktions
  void initView ();
  void initData ();
  void clear ();
private:			// private variables
  tarifList *tarife;
  productList *products;
  QString curency;
  printInfo *pInfo;
  QTabWidget * tabView;
  int currentItem;
  int currentGroup;
  groupList *groups;
  bool CfgWrite;
  QGridLayout *cliGrid;
  // groups
  QListBox *grpList;
  QGroupBox *grpGroup;
  QGridLayout *gGrid;
  QWidget *gWidget;
  QLabel *lbGrpName;
  QLineEdit *edGrpName;
  QPushButton *btnGrpNew;
  QPushButton *btnGrpSave;
  QPushButton *btnGrpDel;
  // clients
  QListBox *cliList;
  QGroupBox *cliGroup;
  QWidget *cliWidget;
  QGridLayout *cGrid;
  QLabel *lbName;
  QLineEdit *edName;
  QLabel *lbGroup;
  QComboBox *edGroup;
  QLabel *lbNr;
  QSpinBox *edNr;
  QLabel *lbIp;
  ipinput *edIp;
  QLabel *lbNotes;
  QSpacerItem *spNotes;
  QMultiLineEdit *edNotes;
  QWidget *btnWidget;
  QHBoxLayout *btnBox;
  QPushButton *btnNew;
  QPushButton *btnSave;
  QSpacerItem *btnSpace;
  QPushButton *btnDel;
  QSpacerItem *sp1;
  QSpacerItem *sp2;
  private slots:void slotListSelected (int i);
  void slotBtnNew ();
  void slotBtnSave ();
  void slotBtnDel ();
  void slotEdName (const QString & s);
  void slotEdGroup (const QString & s);
  void slotEdNr (int i);
  void slotEdIp (const QString s);
  void slotGrpListSelected (int i);
  void slotGrpBtnNew ();
  void slotGrpBtnSave ();
  void slotGrpBtnDel ();
  void slotEdGrpName (const QString & s);
    signals:void configChanged ();
};

#endif
