/*
                      VMA Editor - Input Dialog

	For taking simple arbitary input for editor functions,
	calling functions need to build additional widgets on it
	and update its callback.

 */

#ifndef EDITORIDIALOG_H
#define EDITORIDIALOG_H

#include "editor.h"

extern gint EditorIDialogCreate(
	ma_editor_struct *editor, ma_editor_idialog_struct *d
);
extern void EditorIDialogRecordWidget(
        ma_editor_idialog_struct *d, GtkWidget *w
);
extern GtkWidget *EditorIDialogGetWidget(
        ma_editor_idialog_struct *d, gint n       
);
extern GtkWidget *EditorIDialogClientParent(ma_editor_idialog_struct *d);
extern void EditorIDialogReset(  
        ma_editor_struct *editor, ma_editor_idialog_struct *d,
	gbool need_unmap
);
extern void EditorIDialogDestroy(
	ma_editor_struct *editor, ma_editor_idialog_struct *d
);

extern gint EditorIDialogMap(
        ma_editor_struct *editor, ma_editor_idialog_struct *d,
	const gchar *title,
	const gchar *ok_label, const gchar *apply_label,
	const gchar *cancel_label,
	gpointer client_data,
	void (*func_ok_cb)(gpointer, gpointer),
        void (*func_apply_cb)(gpointer, gpointer),
	void (*func_cancel_cb)(gpointer, gpointer)
);
extern void EditorIDialogUnmap(
        ma_editor_struct *editor, ma_editor_idialog_struct *d
);

#endif	/* EDITORIDIALOG_H */
