/*
                             Global Pixmaps
 */

#ifndef VMAPIXMAPS_H
#define VMAPIXMAPS_H

#include <sys/types.h>
#include <gtk/gtk.h>

#include "splash.h"


/*
 *	Pixmap index numbers, these correspond to an allocated
 *	pixmap in the global vma_pixmaps_list.
 */
#define VMA_PIXMAP_INDEX_OFFSET		0

#define VMA_PIXMAP_VMA_20x20		(0 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_FOLDER_OPENED_20x20	(1 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_FOLDER_CLOSED_20x20	(2 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_FILE_20x20		(3 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_FILE_V3D_20x20	(4 + VMA_PIXMAP_INDEX_OFFSET)

#define VMA_PIXMAP_ADD_20x20		(5 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_APPERANCE_20x20	(6 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_BACKUP_20x20		(7 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_BROWSE_20x20		(8 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_CANCEL_20x20		(9 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_CLOSE_20x20		(10 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_COPY_20x20		(11 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_CULL_20x20		(12 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_CUT_20x20		(13 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_DEVICES_20x20	(14 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_ERROR_32x32		(15 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_EXIT_20x20		(16 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_FONTS_20x20		(17 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_GLOBAL_20x20		(18 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_GRID_20x20		(19 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_HELP_20x20		(20 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_INFO_32x32		(21 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_LOCAL_32x32		(22 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MAXIMIZE_20x20	(23 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MENU_MAP_20x20	(24 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MODEL_20x20		(25 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MODEL_HIDDEN_20x20	(26 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MODEL_OTHER_20x20	(27 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MOVE_RATE_20x20	(28 + VMA_PIXMAP_INDEX_OFFSET)

#define VMA_PIXMAP_MP_COLOR_20x20	(30 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_COMMENT_20x20	(31 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_HEIGHTFIELD_LOAD_20x20	(32 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_LINE_20x20	(33 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_LINELOOP_20x20	(34 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_LINESTRIP_20x20	(35 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_POINT_20x20	(36 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_POLYGON_20x20	(37 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_QUAD_20x20	(38 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_QUADSTRIP_20x20	(39 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_ROTATE_20x20	(40 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_TEXTURE_ORIENT_20x20	(41 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_TEXTURE_SELECT_20x20	(42 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_TEXTURE_OFF_20x20	(43 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_TRANSLATE_20x20	(44 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_TRIANGLE_20x20	(45 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_TRIANGLEFAN_20x20	(46 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_MP_TRIANGLESTRIP_20x20	(47 + VMA_PIXMAP_INDEX_OFFSET)

#define VMA_PIXMAP_NEW_20x20		(50 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_OK_20x20		(51 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_OPEN_20x20		(52 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_PASTE_20x20		(53 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_PLUGIN_20x20		(54 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_PLUGIN_ENABLED_20x20	(55 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_PLUGIN_DISABLED_20x20	(56 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_POWER_ON_20x20	(57 + VMA_PIXMAP_INDEX_OFFSET)   
#define VMA_PIXMAP_POWER_OFF_20x20	(58 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_PRECISION_20x20      (59 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_PROPERTIES_20x20	(60 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_QUESTION_32x32	(61 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_REDO_20x20		(62 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_RELOAD_20x20		(63 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_REMOVE_20x20		(64 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_RENDER_20x20		(65 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_RESTORE_20x20	(66 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_REVERT_20x20		(67 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_SAVE_20x20		(68 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_SAVE_AS_20x20	(69 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_SELECT_20x20		(70 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_TEXTURE_20x20	(71 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_TRALSNATIONS_20x20	(72 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_UNDO_20x20		(73 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_VIEWABLE_DIM_20x20	(74 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_WARNING_32x32	(75 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_ZOOM_IN_20x20	(76 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_ZOOM_ONETOONE_20x20	(77 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_ZOOM_OUT_20x20	(78 + VMA_PIXMAP_INDEX_OFFSET)
#define VMA_PIXMAP_ZOOM_TOFIT_20x20	(79 + VMA_PIXMAP_INDEX_OFFSET)

/* Highest pixmap index number. */
#define VMA_PIXMAP_HIGHEST		(79 + VMA_PIXMAP_INDEX_OFFSET)


/*
 *	Pixmaps list structure:
 */
typedef struct {

	GtkPixmap **pixmap;
	GdkPixmap **pixmap_gdk;
	GdkBitmap **mask;
	gint total_pixmaps;

} vma_pixmaps_list_struct;

extern vma_pixmaps_list_struct vma_pixmaps_list;



extern GtkPixmap *VMAPixmapsListGetPtr(
	vma_pixmaps_list_struct *list,
	gint n
);
extern gint VMAPixmapsListGetValues(
        vma_pixmaps_list_struct *list,
        gint n,
        GdkPixmap **pixmap_gdk_rtn,
        GdkBitmap **mask_rtn,
        GtkPixmap **pixmap_rtn
);
extern gint VMAPixmapsListGetMPCode(
	vma_pixmaps_list_struct *list, gint ptype
);
extern gint VMAPixmapsListLoad(
	gpointer core, vma_pixmaps_list_struct *list,
	splash_win_struct *splash_win
);
extern void VMAPixmapsListUnload(
	gpointer core, vma_pixmaps_list_struct *list
);



#endif	/* VMAPIXMAPS_H */
