/*
                         VMA Editor - Primitives

	Also does creation of primitives toolbar and menu.

 */

#ifndef EDITORPRIMITIVE_H
#define EDITORPRIMITIVE_H

#include "editor.h"

extern int EditorPrimitiveDoCreateSimple(
        ma_editor_struct *editor, int ptype, int create_pos, void *p
);
extern int EditorPrimitiveDoCreate(
        ma_editor_struct *editor,
        int model_num,
        int create_pos, int insert_mode,
        int select,
        void *p,
        gbool record_undo
);
extern void EditorPrimitiveDoDelete(
        ma_editor_struct *editor,
        int model_num,
        int *list, int total,
        gbool record_undo
);

extern gbool EditorPrimitiveIsRealized(ma_editor_struct *editor, void *p);
extern void EditorPrimitiveRealize(
        ma_editor_struct *editor, void *p,
        gbool rerealize
);
extern void EditorPrimitiveUnrealize(ma_editor_struct *editor, void *p);
extern void EditorPrimitiveRealizeAll(  
        ma_editor_struct *editor, int model_num,
        gbool rerealize
);
extern void EditorPrimitiveRealizeAllType(
        ma_editor_struct *editor, int model_num, int ptype,
        gbool rerealize
);
extern void EditorPrimitiveUnrealizeAll(ma_editor_struct *editor, int model_num);

extern int EditorPrimitiveVertexAdd(
        ma_editor_struct *editor, int model_num, int pn, int vertex_num,
	mp_vertex_struct *v, mp_vertex_struct *n, mp_vertex_struct *tc,
        gbool report_errors
);
extern void EditorPrimitiveVertexRemove(
        ma_editor_struct *editor, int model_num, int pn, int vertex_num,
        gbool record_undo, gbool report_errors
);

extern GtkWidget *EditorPrimitivesCreateCreateMenu(ma_editor_struct *editor);
extern int EditorPrimitivesCreateToolBar(ma_editor_struct *editor);


#endif	/* EDITORPRIMITIVE_H */
