/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallGraphWindow;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.StaticMainWindowPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class StaticMainWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    private boolean mShown = false;
    ParaProfTrial ppTrial = null;
    JFileChooser fileChooser = new JFileChooser();
    private StaticMainWindowPanel panel = null;
    private DataSorter dataSorter = null;
    private JMenu optionsMenu = null;
    private JMenu windowsMenu = null;
    private JCheckBoxMenuItem nameCheckBox = null;
    private JCheckBoxMenuItem normalizeCheckBox = null;
    private JCheckBoxMenuItem stackBarsCheckBox = null;
    private JCheckBoxMenuItem orderByMeanCheckBox = null;
    private JCheckBoxMenuItem orderCheckBox = null;
    private JCheckBoxMenuItem slidersCheckBox = null;
    private JCheckBoxMenuItem pathTitleCheckBox = null;
    private JCheckBoxMenuItem metaDataCheckBox = null;
    private JLabel sliderMultipleLabel = new JLabel("Slider Multiple");
    private JComboBox sliderMultiple;
    private JLabel barLengthLabel = new JLabel("Bar Multiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane sp;
    private boolean name = false;
    private int order = 0;
    private boolean normalizeBars = true;
    private boolean orderByMean = true;
    private boolean stackBars = true;
    boolean displaySliders = false;
    private Vector list;

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        JMenuItem jMenuItem = null;
        JMenu jMenu2 = new JMenu("File");
        jMenu = new JMenu("Save ...");
        jMenuItem = new JMenuItem("Save Image");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu2.add(jMenu);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu2.addMenuListener(this);
        this.optionsMenu = new JMenu("Options");
        this.nameCheckBox = new JCheckBoxMenuItem("Sort By Name", false);
        this.nameCheckBox.addActionListener(this);
        this.optionsMenu.add(this.nameCheckBox);
        this.normalizeCheckBox = new JCheckBoxMenuItem("Normalize Bars", true);
        this.normalizeCheckBox.addActionListener(this);
        this.optionsMenu.add(this.normalizeCheckBox);
        this.orderByMeanCheckBox = new JCheckBoxMenuItem("Order By Mean", true);
        this.orderByMeanCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderByMeanCheckBox);
        this.orderCheckBox = new JCheckBoxMenuItem("Descending Order", true);
        this.orderCheckBox.addActionListener(this);
        this.optionsMenu.add(this.orderCheckBox);
        this.stackBarsCheckBox = new JCheckBoxMenuItem("Stack Bars Together", true);
        this.stackBarsCheckBox.addActionListener(this);
        this.optionsMenu.add(this.stackBarsCheckBox);
        this.slidersCheckBox = new JCheckBoxMenuItem("Display Sliders", false);
        this.slidersCheckBox.addActionListener(this);
        this.optionsMenu.add(this.slidersCheckBox);
        this.pathTitleCheckBox = new JCheckBoxMenuItem("Show Path Title in Reverse", true);
        this.pathTitleCheckBox.addActionListener(this);
        this.optionsMenu.add(this.pathTitleCheckBox);
        this.metaDataCheckBox = new JCheckBoxMenuItem("Show Meta Data in Panel", true);
        this.metaDataCheckBox.addActionListener(this);
        this.optionsMenu.add(this.metaDataCheckBox);
        this.windowsMenu = new JMenu("Windows");
        jMenuItem = new JMenuItem("Show ParaProf Manager");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Function Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Group Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show User Event Ledger");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Call Path Relations");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Full Call Graph");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close All Sub-Windows");
        jMenuItem.addActionListener(this);
        this.windowsMenu.add(jMenuItem);
        this.windowsMenu.addMenuListener(this);
        JMenu jMenu3 = new JMenu("Help");
        jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenu3.addMenuListener(this);
        jMenuBar.add(jMenu2);
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(this.windowsMenu);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
    }

    public StaticMainWindow(ParaProfTrial paraProfTrial, boolean bl) {
        this.ppTrial = paraProfTrial;
        this.setTitle("ParaProf: " + paraProfTrial.getTrialIdentifier(true));
        int n = 750;
        int n2 = 400;
        this.setSize(new Dimension(n, n2));
        this.dataSorter = new DataSorter(paraProfTrial);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StaticMainWindow.this.thisWindowClosing(windowEvent);
            }
        });
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        int n5 = (n4 - n) / 2;
        int n6 = (n3 - n2) / 2;
        this.setLocation(n5, n6);
        this.setupMenus();
        this.contentPane = this.getContentPane();
        this.gbl = new GridBagLayout();
        this.contentPane.setLayout(this.gbl);
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 5, 5, 5);
        this.panel = new StaticMainWindowPanel(paraProfTrial, this);
        this.sp = new JScrollPane(this.panel);
        this.setHeader();
        String[] stringArray = new String[]{"1.00", "0.75", "0.50", "0.25", "0.10"};
        this.sliderMultiple = new JComboBox<String>(stringArray);
        this.sliderMultiple.addActionListener(this);
        this.barLengthSlider.setPaintTicks(true);
        this.barLengthSlider.setMajorTickSpacing(5);
        this.barLengthSlider.setMinorTickSpacing(1);
        this.barLengthSlider.setPaintLabels(true);
        this.barLengthSlider.setSnapToTicks(true);
        this.barLengthSlider.addChangeListener(this);
        this.gbc.fill = 1;
        this.gbc.anchor = 10;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.addCompItem(this.sp, this.gbc, 0, 0, 1, 1);
        this.dataSorter = new DataSorter(paraProfTrial);
        this.sortLocalData();
        this.panel.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Print")) {
                    ParaProfUtils.print(this.panel);
                } else if (string.equals("Show ParaProf Manager")) {
                    new ParaProfManagerWindow().show();
                } else if (!string.equals("Show 3D Window")) {
                    if (string.equals("Preferences...")) {
                        this.ppTrial.getPreferences().showPreferencesWindow();
                    } else if (string.equals("Save Image")) {
                        ParaProfImageOutput paraProfImageOutput = new ParaProfImageOutput();
                        paraProfImageOutput.saveImage(this.panel);
                    } else if (string.equals("Close This Window")) {
                        this.closeThisWindow();
                    } else if (string.equals("Exit ParaProf!")) {
                        this.setVisible(false);
                        this.dispose();
                        ParaProf.exitParaProf(0);
                    } else if (string.equals("Sort By Name")) {
                        this.name = this.nameCheckBox.isSelected();
                        this.sortLocalData();
                        this.panel.repaint();
                    } else if (string.equals("Normalize Bars")) {
                        this.normalizeBars = this.normalizeCheckBox.isSelected();
                        this.panel.repaint();
                    } else if (string.equals("Stack Bars Together")) {
                        if (this.stackBarsCheckBox.isSelected()) {
                            this.normalizeCheckBox.setEnabled(true);
                            this.orderByMeanCheckBox.setEnabled(true);
                            this.stackBars = true;
                        } else {
                            this.stackBars = false;
                            this.normalizeCheckBox.setSelected(false);
                            this.normalizeCheckBox.setEnabled(false);
                            this.normalizeBars = false;
                            this.orderByMeanCheckBox.setSelected(true);
                            this.orderByMeanCheckBox.setEnabled(false);
                            this.orderByMean = true;
                        }
                        this.panel.repaint();
                    } else if (string.equals("Order By Mean")) {
                        this.orderByMean = this.orderByMeanCheckBox.isSelected();
                        this.sortLocalData();
                        this.panel.repaint();
                    } else if (string.equals("Descending Order")) {
                        this.order = this.orderCheckBox.isSelected() ? 0 : 1;
                        this.sortLocalData();
                        this.panel.repaint();
                    } else if (string.equals("Display Sliders")) {
                        if (this.slidersCheckBox.isSelected()) {
                            this.displaySliders(true);
                        } else {
                            this.displaySliders(false);
                        }
                    } else if (string.equals("Show Path Title in Reverse")) {
                        this.setTitle("ParaProf: " + this.ppTrial.getTrialIdentifier(this.pathTitleCheckBox.isSelected()));
                    } else if (string.equals("Show Meta Data in Panel")) {
                        this.setHeader();
                    } else if (string.equals("Show Function Ledger")) {
                        new LedgerWindow(this.ppTrial, 0).show();
                    } else if (string.equals("Show Group Ledger")) {
                        new LedgerWindow(this.ppTrial, 1).show();
                    } else if (string.equals("Show User Event Ledger")) {
                        new LedgerWindow(this.ppTrial, 2).show();
                    } else if (string.equals("Show Call Path Relations")) {
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.ppTrial, -1, -1, -1, this.getDataSorter(), 2);
                        this.ppTrial.getSystemEvents().addObserver(callPathTextWindow);
                        callPathTextWindow.show();
                    } else if (string.equals("Show Full Call Graph")) {
                        CallGraphWindow callGraphWindow = new CallGraphWindow(this.ppTrial, this.ppTrial.getDataSource().getMeanData());
                        this.ppTrial.getSystemEvents().addObserver(callGraphWindow);
                        callGraphWindow.show();
                    } else if (string.equals("Close All Sub-Windows")) {
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                    } else if (string.equals("About ParaProf")) {
                        JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                    } else if (string.equals("Show Help Window")) {
                        ParaProf.helpWindow.show();
                    }
                }
            } else if (object == this.sliderMultiple) {
                this.panel.changeInMultiples();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.panel.changeInMultiples();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.ppTrial.groupNamesPresent()) {
                this.windowsMenu.getItem(2).setEnabled(true);
            } else {
                this.windowsMenu.getItem(2).setEnabled(false);
            }
            if (this.ppTrial.userEventsPresent()) {
                this.windowsMenu.getItem(3).setEnabled(true);
            } else {
                this.windowsMenu.getItem(3).setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.sortLocalData();
            this.setHeader();
            this.panel.repaint();
        }
    }

    public Dimension getViewportSize() {
        return this.sp.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.sp.getViewport().getViewRect();
    }

    public void setVerticalScrollBarPosition(int n) {
        JScrollBar jScrollBar = this.sp.getVerticalScrollBar();
        jScrollBar.setValue(n);
    }

    public void setHeader() {
        if (this.metaDataCheckBox.isSelected()) {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setEditable(false);
            Preferences preferences = this.ppTrial.getPreferences();
            jTextArea.setFont(new Font(preferences.getParaProfFont(), preferences.getFontStyle(), preferences.getFontSize()));
            jTextArea.append(this.getHeaderString());
            this.sp.setColumnHeaderView(jTextArea);
        } else {
            this.sp.setColumnHeaderView(null);
        }
    }

    public String getHeaderString() {
        return "Metric Name: " + this.ppTrial.getMetricName(this.ppTrial.getSelectedMetricID()) + "\n" + "Value Type: " + UtilFncs.getValueTypeString((int)2) + "\n";
    }

    public double getSliderValue() {
        return this.barLengthSlider.getValue();
    }

    public double getSliderMultiple() {
        String string = null;
        string = (String)this.sliderMultiple.getSelectedItem();
        return Double.parseDouble(string);
    }

    private void displaySliders(boolean bl) {
        if (bl) {
            this.contentPane.remove(this.sp);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultipleLabel, this.gbc, 0, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultiple, this.gbc, 1, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, this.gbc, 2, 0, 1, 1);
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.7;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, this.gbc, 3, 0, 1, 1);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 0.99;
            this.addCompItem(this.sp, this.gbc, 0, 1, 4, 1);
        } else {
            this.contentPane.remove(this.sliderMultipleLabel);
            this.contentPane.remove(this.sliderMultiple);
            this.contentPane.remove(this.barLengthLabel);
            this.contentPane.remove(this.barLengthSlider);
            this.contentPane.remove(this.sp);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.addCompItem(this.sp, this.gbc, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.contentPane.add(component, gridBagConstraints);
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    private void sortLocalData() {
        this.list = this.name ? this.dataSorter.getAllFunctionProfiles(0 + this.order) : (this.orderByMean ? this.dataSorter.getAllFunctionProfiles(20 + this.order) : this.dataSorter.getAllFunctionProfiles(2 + this.order));
    }

    public Vector getData() {
        return this.list;
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            this.setVisible(false);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public boolean getNormalizeBars() {
        return this.normalizeBars;
    }

    public boolean getStackBars() {
        return this.stackBars;
    }
}

