/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UserEventProfile;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class DataSorter {
    private ParaProfTrial trial = null;
    private double maxExclusiveSum = 0.0;
    private double[] maxExclusives;

    public DataSorter(ParaProfTrial paraProfTrial) {
        this.trial = paraProfTrial;
    }

    public Vector getUserEventProfiles(int n, int n2, int n3, int n4) {
        UserEventProfile userEventProfile = null;
        Vector vector = this.trial.getDataSource().getThread(n, n2, n3).getUserEventProfiles();
        Vector<PPUserEventProfile> vector2 = new Vector<PPUserEventProfile>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            userEventProfile = (UserEventProfile)enumeration.nextElement();
            if (userEventProfile == null) continue;
            PPUserEventProfile pPUserEventProfile = new PPUserEventProfile(this.trial, n, n2, n3, userEventProfile);
            pPUserEventProfile.setSortType(n4);
            vector2.addElement(pPUserEventProfile);
        }
        Collections.sort(vector2);
        return vector2;
    }

    public Vector getFunctionProfiles(int n, int n2, int n3, int n4) {
        Vector<PPFunctionProfile> vector = null;
        Thread thread = n == -1 ? this.trial.getDataSource().getMeanData() : this.trial.getDataSource().getThread(n, n2, n3);
        Vector vector2 = thread.getFunctionProfiles();
        vector = new Vector<PPFunctionProfile>();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            FunctionProfile functionProfile = (FunctionProfile)enumeration.nextElement();
            if (functionProfile == null || !this.trial.displayFunction(functionProfile.getFunction())) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this.trial, thread, functionProfile);
            pPFunctionProfile.setSortType(n4);
            vector.addElement(pPFunctionProfile);
        }
        Collections.sort(vector);
        return vector;
    }

    public Vector getAllFunctionProfiles(int n) {
        Object object;
        FunctionProfile functionProfile;
        Object var2_2 = null;
        Vector<PPThread> vector = new Vector<PPThread>();
        Thread thread = this.trial.getDataSource().getMeanData();
        PPThread pPThread = new PPThread(thread, this.trial);
        Object object2 = thread.getFunctionProfiles().elements();
        while (object2.hasMoreElements()) {
            functionProfile = (FunctionProfile)object2.nextElement();
            if (functionProfile == null || !this.trial.displayFunction(functionProfile.getFunction())) continue;
            object = new PPFunctionProfile(this.trial, thread, functionProfile);
            ((PPFunctionProfile)object).setSortType(n);
            pPThread.addFunction((PPFunctionProfile)object);
        }
        Collections.sort(pPThread.getFunctionList());
        vector.add(pPThread);
        this.maxExclusiveSum = 0.0;
        this.maxExclusives = new double[this.trial.getDataSource().getNumFunctions()];
        object2 = this.trial.getDataSource().getNodes();
        while (object2.hasNext()) {
            functionProfile = (Node)object2.next();
            object = functionProfile.getContexts();
            while (object.hasNext()) {
                Context context = (Context)object.next();
                Iterator iterator = context.getThreads();
                while (iterator.hasNext()) {
                    thread = (Thread)iterator.next();
                    int n2 = 0;
                    pPThread = new PPThread(thread, this.trial);
                    double d = 0.0;
                    Enumeration enumeration = thread.getFunctionProfiles().elements();
                    while (enumeration.hasMoreElements()) {
                        FunctionProfile functionProfile2 = (FunctionProfile)enumeration.nextElement();
                        if (functionProfile2 == null || !this.trial.displayFunction(functionProfile2.getFunction())) continue;
                        PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this.trial, thread, functionProfile2);
                        pPFunctionProfile.setSortType(n);
                        pPThread.addFunction(pPFunctionProfile);
                        ++n2;
                        d += pPFunctionProfile.getExclusiveValue();
                        this.maxExclusives[functionProfile2.getFunction().getID()] = Math.max(this.maxExclusives[functionProfile2.getFunction().getID()], pPFunctionProfile.getExclusiveValue());
                    }
                    if (d > this.maxExclusiveSum) {
                        this.maxExclusiveSum = d;
                    }
                    if (n2 == 0) continue;
                    Collections.sort(pPThread.getFunctionList());
                    vector.add(pPThread);
                }
            }
        }
        return vector;
    }

    public Vector getFunctionData(Function function, int n, boolean bl) {
        PPFunctionProfile pPFunctionProfile;
        Thread thread;
        FunctionProfile functionProfile;
        Vector<PPFunctionProfile> vector = new Vector<PPFunctionProfile>();
        if (bl && (functionProfile = (thread = this.trial.getDataSource().getMeanData()).getFunctionProfile(function)) != null) {
            pPFunctionProfile = new PPFunctionProfile(this.trial, thread, functionProfile);
            pPFunctionProfile.setSortType(n);
            vector.add(pPFunctionProfile);
        }
        Iterator iterator = this.trial.getDataSource().getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    thread = (Thread)iterator3.next();
                    functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null) continue;
                    pPFunctionProfile = new PPFunctionProfile(this.trial, thread, functionProfile);
                    pPFunctionProfile.setSortType(n);
                    vector.add(pPFunctionProfile);
                }
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public Vector getUserEventData(UserEvent userEvent, int n) {
        Vector<PPUserEventProfile> vector = new Vector<PPUserEventProfile>();
        Iterator iterator = this.trial.getDataSource().getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent);
                    if (userEventProfile == null) continue;
                    PPUserEventProfile pPUserEventProfile = new PPUserEventProfile(this.trial, node.getNodeID(), context.getContextID(), thread.getThreadID(), userEventProfile);
                    pPUserEventProfile.setSortType(n);
                    vector.add(pPUserEventProfile);
                }
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public double getMaxExclusiveSum() {
        return this.maxExclusiveSum;
    }

    public double[] getMaxExclusives() {
        return this.maxExclusives;
    }
}

