/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.LedgerDataElement;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.UserEventWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class LedgerWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private int xPanelSize = 300;
    private int yPanelSize = 400;
    private int barHeight = -1;
    private int barSpacing = -1;
    private ParaProfTrial ppTrial = null;
    private LedgerWindow window = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;
    private Vector list = null;
    private boolean widthSet = false;
    private int windowType = -1;

    public void setupMenus() {
        JMenuItem jMenuItem = null;
        switch (this.windowType) {
            case 0: {
                jMenuItem = new JMenuItem("Show Function Details");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Change Function Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Reset to Generic Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                break;
            }
            case 1: {
                jMenuItem = new JMenuItem("Change Group Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Reset to Generic Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Show This Group Only");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Show All Groups Except This One");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Show All Groups");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                break;
            }
            case 2: {
                jMenuItem = new JMenuItem("Show User Event Details");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Change User Event Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Reset to Generic Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
            }
        }
    }

    public LedgerWindowPanel(ParaProfTrial paraProfTrial, LedgerWindow ledgerWindow, int n) {
        this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setBackground(Color.white);
        this.ppTrial = paraProfTrial;
        this.window = ledgerWindow;
        this.windowType = n;
        this.addMouseListener(this);
        this.setupMenus();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.renderIt((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2;
        this.list = this.window.getData();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.ppTrial.getPreferences().setBarDetails(graphics2D);
        this.barSpacing = this.ppTrial.getPreferences().getBarSpacing();
        this.barHeight = this.ppTrial.getPreferences().getBarHeight();
        Font font = new Font(this.ppTrial.getPreferences().getParaProfFont(), this.ppTrial.getPreferences().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        if (!this.widthSet) {
            n2 = 0;
            while (n2 < this.list.size()) {
                LedgerDataElement ledgerDataElement = (LedgerDataElement)this.list.get(n2);
                if (ledgerDataElement.getName() != null && this.xPanelSize < (n = 5 + this.barHeight + fontMetrics.stringWidth(ledgerDataElement.getName()))) {
                    this.xPanelSize = n + 11;
                }
                ++n2;
            }
            this.widthSet = true;
        }
        if (this.resizePanel(fontMetrics, n5) && bl) {
            this.revalidate();
            return;
        }
        n2 = 0;
        int n7 = 0;
        n = 0;
        int n8 = 0;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        if (!bl2) {
            if (bl) {
                rectangle = graphics2D.getClipBounds();
                n2 = (int)rectangle.getY();
                n7 = (int)((double)n2 + rectangle.getHeight());
            } else {
                rectangle2 = this.window.getViewRect();
                n2 = (int)rectangle2.getY();
                n7 = (int)((double)n2 + rectangle2.getHeight());
            }
            n = (n2 - n4) / this.barSpacing - 1;
            n8 = (n7 - n4) / this.barSpacing + 1;
            if (n < 0) {
                n = 0;
            }
            if (n8 < 0) {
                n8 = 0;
            }
            if (n > this.list.size() - 1) {
                n = this.list.size() - 1;
            }
            if (n8 > this.list.size() - 1) {
                n8 = this.list.size() - 1;
            }
            if (bl) {
                n4 += (n - 1) * this.barSpacing;
            }
        } else {
            n = 0;
            n8 = this.list.size() - 1;
        }
        n3 = 5;
        n4 += this.barSpacing;
        int n9 = n;
        while (n9 <= n8) {
            LedgerDataElement ledgerDataElement = (LedgerDataElement)this.list.get(n9);
            if (ledgerDataElement.getName() != null) {
                graphics2D.setColor(ledgerDataElement.getColor());
                graphics2D.fillRect(n3, (n4 += this.barSpacing) - this.barHeight, this.barHeight, this.barHeight);
                if (ledgerDataElement.isHighlighted(this.ppTrial.getColorChooser())) {
                    graphics2D.setColor(ledgerDataElement.getHighlightColor(this.ppTrial.getColorChooser()));
                    graphics2D.drawRect(n3, n4 - this.barHeight, this.barHeight, this.barHeight);
                    graphics2D.drawRect(n3 + 1, n4 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
                } else {
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRect(n3, n4 - this.barHeight, this.barHeight, this.barHeight);
                }
                graphics2D.setColor(Color.black);
                String string = ledgerDataElement.getName();
                graphics2D.drawString(string, n3 += this.barHeight + 10, n4);
                int n10 = 5 + this.barHeight + fontMetrics.stringWidth(string);
                if (n6 < n10) {
                    n6 = n10 + 11;
                }
                if (bl) {
                    ledgerDataElement.setDrawCoords(0, n10, n4 - this.barHeight, n4);
                }
                n3 -= this.barHeight + 10;
            }
            ++n9;
        }
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        int n2 = this.window.getData().size() * this.barSpacing;
        if (n2 != this.yPanelSize) {
            this.yPanelSize = n2;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (this.clickedOnObject instanceof LedgerDataElement) {
                    LedgerDataElement ledgerDataElement = (LedgerDataElement)this.clickedOnObject;
                    if (string.equals("Show Function Details")) {
                        this.ppTrial.getColorChooser().setHighlightedFunction(ledgerDataElement.getFunction());
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(this.ppTrial, ledgerDataElement.getFunction(), this.ppTrial.getStaticMainWindow().getDataSorter());
                        this.ppTrial.getSystemEvents().addObserver(functionDataWindow);
                        functionDataWindow.show();
                    } else if (string.equals("Show User Event Details")) {
                        this.ppTrial.getColorChooser().setHighlightedUserEvent(ledgerDataElement.getUserEvent());
                        UserEventWindow userEventWindow = new UserEventWindow(this.ppTrial, ledgerDataElement.getUserEvent(), this.ppTrial.getStaticMainWindow().getDataSorter());
                        this.ppTrial.getSystemEvents().addObserver(userEventWindow);
                        userEventWindow.show();
                    } else if (string.equals("Change Function Color") || string.equals("Change User Event Color") || string.equals("Change Group Color")) {
                        Color color = ledgerDataElement.getColor();
                        if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                            ledgerDataElement.setSpecificColor(color);
                            ledgerDataElement.setColorFlag(true);
                            this.ppTrial.getSystemEvents().updateRegisteredObjects("colorEvent");
                        }
                    } else if (string.equals("Reset to Generic Color")) {
                        ledgerDataElement.setColorFlag(false);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    } else if (string.equals("Show This Group Only")) {
                        this.ppTrial.setSelectedGroup(ledgerDataElement.getGroup());
                        this.ppTrial.setGroupFilter(1);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("dataEvent");
                    } else if (string.equals("Show All Groups Except This One")) {
                        this.ppTrial.setSelectedGroup(ledgerDataElement.getGroup());
                        this.ppTrial.setGroupFilter(2);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("dataEvent");
                    } else if (string.equals("Show All Groups")) {
                        this.ppTrial.setSelectedGroup(null);
                        this.ppTrial.setGroupFilter(0);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("dataEvent");
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            if (this.list == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            Enumeration enumeration = this.list.elements();
            while (enumeration.hasMoreElements()) {
                LedgerDataElement ledgerDataElement = (LedgerDataElement)enumeration.nextElement();
                if (n2 > ledgerDataElement.getYEnd()) continue;
                if (n2 >= ledgerDataElement.getYBeg() && n >= ledgerDataElement.getXBeg() && n <= ledgerDataElement.getXEnd()) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = ledgerDataElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                    if (this.windowType == 2) {
                        this.ppTrial.getColorChooser().toggleHighlightedUserEvent(ledgerDataElement.getUserEvent());
                    } else if (this.windowType == 1) {
                        this.ppTrial.getColorChooser().toggleHighlightedGroup(ledgerDataElement.getGroup());
                    } else {
                        this.ppTrial.getColorChooser().toggleHighlightedFunction(ledgerDataElement.getFunction());
                    }
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            return this.getPreferredSize();
        }
        return this.window.getSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }
}

