/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.DataSourceException;
import edu.uoregon.tau.dms.dss.DatabaseException;
import edu.uoregon.tau.paraprof.ParaProfObserver;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.EventQueue;
import java.util.Enumeration;
import java.util.Vector;

public class DataSourceThreadControl
implements Runnable {
    private DataSource dataSource = null;
    private Vector observers = new Vector();
    private boolean loadedOk = false;
    private Exception exception = null;

    public void initialize(DataSource dataSource) {
        this.dataSource = dataSource;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        try {
            this.dataSource.load();
            this.loadedOk = true;
        }
        catch (Exception exception) {
            this.exception = new DataSourceException(exception);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                DataSourceThreadControl.this.notifyObservers();
            }
        });
    }

    public void addObserver(ParaProfObserver paraProfObserver) {
        this.observers.add(paraProfObserver);
    }

    public void removeObserver(ParaProfObserver paraProfObserver) {
        this.observers.remove(paraProfObserver);
    }

    public void notifyObservers() {
        try {
            if (this.loadedOk) {
                Enumeration enumeration = this.observers.elements();
                while (enumeration.hasMoreElements()) {
                    ((ParaProfObserver)enumeration.nextElement()).update(this.dataSource);
                }
            } else {
                Enumeration enumeration = this.observers.elements();
                while (enumeration.hasMoreElements()) {
                    ((ParaProfObserver)enumeration.nextElement()).update(this.exception);
                }
            }
        }
        catch (DatabaseException databaseException) {
            ParaProfUtils.handleException((Exception)((Object)databaseException));
        }
    }
}

