/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.machine;

import org.jatha.Jatha;
import org.jatha.compile.CompilerException;
import org.jatha.compile.LispPrimitive;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispHashTable;
import org.jatha.machine.SECDRegister;
import org.jatha.machine.SECDop;
import org.jatha.machine.opAP;
import org.jatha.machine.opDAP;
import org.jatha.machine.opDUM;
import org.jatha.machine.opJOIN;
import org.jatha.machine.opLD;
import org.jatha.machine.opLDC;
import org.jatha.machine.opLDF;
import org.jatha.machine.opLDFC;
import org.jatha.machine.opLD_GLOBAL;
import org.jatha.machine.opLIS;
import org.jatha.machine.opNIL;
import org.jatha.machine.opRAP;
import org.jatha.machine.opRTN;
import org.jatha.machine.opRTN_IF;
import org.jatha.machine.opRTN_IT;
import org.jatha.machine.opSEL;
import org.jatha.machine.opSP_BIND;
import org.jatha.machine.opSP_UNBIND;
import org.jatha.machine.opSTOP;
import org.jatha.machine.opT;
import org.jatha.machine.opTEST;

public class SECDMachine {
    Jatha f_lisp = null;
    public SECDRegister S = null;
    public SECDRegister E = null;
    public SECDRegister C = null;
    public SECDRegister D = null;
    public LispValue B = null;
    public SECDop AP = null;
    public SECDop DAP = null;
    public SECDop DUM = null;
    public SECDop JOIN = null;
    public SECDop LD = null;
    public SECDop LD_GLOBAL = null;
    public SECDop LDC = null;
    public SECDop LDF = null;
    public SECDop LDFC = null;
    public SECDop LIS = null;
    public SECDop NIL = null;
    public SECDop RAP = null;
    public SECDop RTN = null;
    public SECDop RTN_IF = null;
    public SECDop RTN_IT = null;
    public SECDop SEL = null;
    public SECDop SP_BIND = null;
    public SECDop SP_UNBIND = null;
    public SECDop STOP = null;
    public SECDop T = null;
    public SECDop TEST = null;

    public SECDMachine(Jatha lisp) {
        this.f_lisp = lisp;
        this.S = new SECDRegister(this.f_lisp, "S-05171955");
        this.E = new SECDRegister(this.f_lisp, "E-06141957");
        this.C = new SECDRegister(this.f_lisp, "C-06151962");
        this.D = new SECDRegister(this.f_lisp, "D-06071966");
        this.B = new StandardLispHashTable(this.f_lisp, this.f_lisp.NIL, this.f_lisp.NIL, this.f_lisp.NIL, this.f_lisp.NIL);
        this.AP = new opAP(this.f_lisp);
        this.DAP = new opDAP(this.f_lisp);
        this.DUM = new opDUM(this.f_lisp);
        this.JOIN = new opJOIN(this.f_lisp);
        this.LD = new opLD(this.f_lisp);
        this.LD_GLOBAL = new opLD_GLOBAL(this.f_lisp);
        this.LDC = new opLDC(this.f_lisp);
        this.LDF = new opLDF(this.f_lisp);
        this.LDFC = new opLDFC(this.f_lisp);
        this.LIS = new opLIS(this.f_lisp);
        this.NIL = new opNIL(this.f_lisp);
        this.RAP = new opRAP(this.f_lisp);
        this.RTN = new opRTN(this.f_lisp);
        this.RTN_IF = new opRTN_IF(this.f_lisp);
        this.RTN_IT = new opRTN_IT(this.f_lisp);
        this.SEL = new opSEL(this.f_lisp);
        this.SP_BIND = new opSP_BIND(this.f_lisp);
        this.SP_UNBIND = new opSP_UNBIND(this.f_lisp);
        this.STOP = new opSTOP(this.f_lisp);
        this.T = new opT(this.f_lisp);
        this.TEST = new opTEST(this.f_lisp);
    }

    public Jatha getLisp() {
        return this.f_lisp;
    }

    public void special_bind(LispValue symbol, LispValue value) {
        if (symbol.basic_constantp()) {
            symbol.setf_symbol_value(value);
        } else {
            LispValue bindings = this.B.gethash(symbol, this.f_lisp.NIL);
            this.B.setf_gethash(symbol, this.f_lisp.makeCons(value, bindings));
            symbol.adjustSpecialCount(1);
        }
    }

    public void special_unbind(LispValue symbol) {
        LispValue bindings = this.B.gethash(symbol, this.f_lisp.NIL);
        this.B.setf_gethash(symbol, bindings.cdr());
        symbol.adjustSpecialCount(-1);
    }

    public void special_set(LispValue symbol, LispValue value) {
        if (symbol.get_specialCount() > 0) {
            LispValue bindings = this.B.gethash(symbol, this.f_lisp.NIL);
            this.B.setf_gethash(symbol, this.f_lisp.makeCons(value, bindings.cdr()));
        } else {
            symbol.setf_symbol_value(value);
        }
    }

    public LispValue get_special_value(LispValue symbol) {
        if (symbol.get_specialCount() > 0) {
            return this.B.gethash(symbol).car();
        }
        return symbol.symbol_value();
    }

    public LispValue Execute(LispValue code, LispValue globals) throws CompilerException {
        this.S.assign(this.f_lisp.NIL);
        this.E.assign(globals);
        this.C.assign(code);
        this.D.assign(this.f_lisp.NIL);
        LispValue opcode = this.C.value().car();
        while (opcode != this.STOP && opcode != this.f_lisp.NIL) {
            if (opcode != null) {
                ((LispPrimitive)opcode).Execute(this);
            } else {
                System.err.println("internal error in Jatha.SECDMachine.Execute: opcode is null");
                System.err.println("remaining code is " + ((Object)this.C.value()).toString());
            }
            opcode = this.C.value().car();
        }
        return this.S.value().car();
    }
}

